// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('goog.net.XhrIo');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.getStatus();
if(cljs.core.truth_(temp__5753__auto__)){
var st = temp__5753__auto__;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
})();
var error = (function (){var pred__19836 = cljs.core._EQ_;
var expr__19837 = e.getLastErrorCode();
if(cljs.core.truth_((pred__19836.cljs$core$IFn$_invoke$arity$2 ? pred__19836.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.NO_ERROR,expr__19837) : pred__19836.call(null,goog.net.ErrorCode.NO_ERROR,expr__19837)))){
return new cljs.core.Keyword("xhttp","no-error","xhttp/no-error",1902047248);
} else {
if(cljs.core.truth_((pred__19836.cljs$core$IFn$_invoke$arity$2 ? pred__19836.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.EXCEPTION,expr__19837) : pred__19836.call(null,goog.net.ErrorCode.EXCEPTION,expr__19837)))){
return new cljs.core.Keyword("xhttp","exception","xhttp/exception",1363682040);
} else {
if(cljs.core.truth_((pred__19836.cljs$core$IFn$_invoke$arity$2 ? pred__19836.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.HTTP_ERROR,expr__19837) : pred__19836.call(null,goog.net.ErrorCode.HTTP_ERROR,expr__19837)))){
return new cljs.core.Keyword("xhttp","http-error","xhttp/http-error",-960604305);
} else {
if(cljs.core.truth_((pred__19836.cljs$core$IFn$_invoke$arity$2 ? pred__19836.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.ABORT,expr__19837) : pred__19836.call(null,goog.net.ErrorCode.ABORT,expr__19837)))){
return new cljs.core.Keyword("xhttp","abort","xhttp/abort",666776046);
} else {
if(cljs.core.truth_((pred__19836.cljs$core$IFn$_invoke$arity$2 ? pred__19836.cljs$core$IFn$_invoke$arity$2(goog.net.ErrorCode.TIMEOUT,expr__19837) : pred__19836.call(null,goog.net.ErrorCode.TIMEOUT,expr__19837)))){
return new cljs.core.Keyword("xhttp","timeout","xhttp/timeout",357433562);
} else {
return new cljs.core.Keyword("xhttp","unknown-error","xhttp/unknown-error",693274399);
}
}
}
}
}
})();
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4221__auto__ = status;
if(cljs.core.truth_(and__4221__auto__)){
return (status > (0));
} else {
return and__4221__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__19839 = new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"url","url",276297046),url,new cljs.core.Keyword(null,"error","error",-978969032),error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19839,new cljs.core.Keyword(null,"status","status",-1997798413),status);
} else {
return G__19839;
}
})());
});
fluree.db.util.xhttp.throw_if_timeout = (function fluree$db$util$xhttp$throw_if_timeout(response){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.util.xhttp.TimeoutException,new cljs.core.Keyword(null,"type","type",1174270348).cljs$core$IFn$_invoke$arity$1(cljs.core.first(new cljs.core.Keyword("error","via","error/via",1749063568).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response)))))){
throw (new fluree.db.util.xhttp.TimeoutException(new cljs.core.Keyword("error","cause","error/cause",-200428996).cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"error","error",-978969032).cljs$core$IFn$_invoke$arity$1(response))));
} else {
return response;
}
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__19840 = opts;
var map__19840__$1 = cljs.core.__destructure_map(map__19840);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19840__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19840__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19840__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19841 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__19841__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19841,headers], 0)):G__19841);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19841__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19841__$1;
}
})();
try{var G__19843_19849 = url;
var G__19844_19850 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(xhr.getResponseJson(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),true], 0)));
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__19845_19851 = "POST";
var G__19846_19852 = fluree.db.util.json.stringify(message);
var G__19847_19853 = cljs.core.clj__GT_js(headers__$1);
var G__19848_19854 = request_timeout;
goog.net.XhrIo.send(G__19843_19849,G__19844_19850,G__19845_19851,G__19846_19852,G__19847_19853,G__19848_19854);
}catch (e19842){var e_19855 = e19842;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_19855);
}
return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__19856 = opts;
var map__19856__$1 = cljs.core.__destructure_map(map__19856);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19856__$1,new cljs.core.Keyword(null,"request-timeout","request-timeout",-2047539823),(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19856__$1,new cljs.core.Keyword(null,"token","token",-1211463215));
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19856__$1,new cljs.core.Keyword(null,"headers","headers",-835030129));
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19856__$1,new cljs.core.Keyword(null,"body","body",-2049205669));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__19856__$1,new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"text","text",-1790561697));
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__19857 = cljs.core.PersistentArrayMap.EMPTY;
var G__19857__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__19857,headers], 0)):G__19857);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19857__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__19857__$1;
}
})();
try{var G__19859_19866 = url;
var G__19860_19867 = (function (event){
var xhr = event.target;
var success_QMARK_ = xhr.isSuccess();
if(cljs.core.truth_(success_QMARK_)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__19865 = output_format;
var G__19865__$1 = (((G__19865 instanceof cljs.core.Keyword))?G__19865.fqn:null);
switch (G__19865__$1) {
case "text":
return xhr.getResponseText();

break;
case "json":
return xhr.getResponseJson();

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text for now.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
} else {
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,xhr));
}
});
var G__19861_19868 = "GET";
var G__19862_19869 = body;
var G__19863_19870 = cljs.core.clj__GT_js(headers__$1);
var G__19864_19871 = request_timeout;
goog.net.XhrIo.send(G__19859_19866,G__19860_19867,G__19861_19868,G__19862_19869,G__19863_19870,G__19864_19871);
}catch (e19858){var e_19873 = e19858;
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["CAUGHT ERROR!"], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,e_19873);
}
return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__19874 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"headers","headers",-835030129),"Accept"], null),"application/json"),new cljs.core.Keyword(null,"output-format","output-format",-1826382676),new cljs.core.Keyword(null,"json","json",1279968570));
if(cljs.core.truth_(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__19874,new cljs.core.Keyword(null,"body","body",-2049205669),fluree.db.util.json.stringify(new cljs.core.Keyword(null,"body","body",-2049205669).cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__19874;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__2755__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19906){
var state_val_19907 = (state_19906[(1)]);
if((state_val_19907 === (7))){
var inst_19902 = (state_19906[(2)]);
var state_19906__$1 = state_19906;
var statearr_19908_19933 = state_19906__$1;
(statearr_19908_19933[(2)] = inst_19902);

(statearr_19908_19933[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (1))){
var state_19906__$1 = state_19906;
var statearr_19909_19934 = state_19906__$1;
(statearr_19909_19934[(2)] = null);

(statearr_19909_19934[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (4))){
var inst_19877 = (state_19906[(7)]);
var inst_19877__$1 = (state_19906[(2)]);
var inst_19878 = (inst_19877__$1 == null);
var state_19906__$1 = (function (){var statearr_19910 = state_19906;
(statearr_19910[(7)] = inst_19877__$1);

return statearr_19910;
})();
if(cljs.core.truth_(inst_19878)){
var statearr_19911_19935 = state_19906__$1;
(statearr_19911_19935[(1)] = (5));

} else {
var statearr_19912_19936 = state_19906__$1;
(statearr_19912_19936[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (6))){
var inst_19877 = (state_19906[(7)]);
var inst_19885 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19877,(0),null);
var inst_19886 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19877,(1),null);
var state_19906__$1 = (function (){var statearr_19913 = state_19906;
(statearr_19913[(8)] = inst_19886);

(statearr_19913[(9)] = inst_19885);

return statearr_19913;
})();
var statearr_19914_19937 = state_19906__$1;
(statearr_19914_19937[(2)] = null);

(statearr_19914_19937[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (3))){
var inst_19904 = (state_19906[(2)]);
var state_19906__$1 = state_19906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19906__$1,inst_19904);
} else {
if((state_val_19907 === (2))){
var state_19906__$1 = state_19906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_19906__$1,(4),pub_chan);
} else {
if((state_val_19907 === (11))){
var _ = (function (){var statearr_19916 = state_19906;
(statearr_19916[(4)] = cljs.core.rest((state_19906[(4)])));

return statearr_19916;
})();
var state_19906__$1 = state_19906;
var ex19915 = (state_19906__$1[(2)]);
var statearr_19917_19938 = state_19906__$1;
(statearr_19917_19938[(5)] = ex19915);


var statearr_19918_19939 = state_19906__$1;
(statearr_19918_19939[(1)] = (10));

(statearr_19918_19939[(5)] = null);



return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (9))){
var inst_19899 = (state_19906[(2)]);
var state_19906__$1 = (function (){var statearr_19919 = state_19906;
(statearr_19919[(10)] = inst_19899);

return statearr_19919;
})();
var statearr_19920_19940 = state_19906__$1;
(statearr_19920_19940[(2)] = null);

(statearr_19920_19940[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (5))){
var inst_19880 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_19906__$1 = state_19906;
var statearr_19921_19941 = state_19906__$1;
(statearr_19921_19941[(2)] = inst_19880);

(statearr_19921_19941[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (10))){
var inst_19886 = (state_19906[(8)]);
var inst_19885 = (state_19906[(9)]);
var inst_19887 = (state_19906[(2)]);
var inst_19888 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_19887,"Error sending websocket message:",inst_19885], 0));
var inst_19889 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19886,false);
var state_19906__$1 = (function (){var statearr_19922 = state_19906;
(statearr_19922[(11)] = inst_19888);

return statearr_19922;
})();
var statearr_19923_19942 = state_19906__$1;
(statearr_19923_19942[(2)] = inst_19889);

(statearr_19923_19942[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19907 === (8))){
var inst_19886 = (state_19906[(8)]);
var inst_19885 = (state_19906[(9)]);
var _ = (function (){var statearr_19924 = state_19906;
(statearr_19924[(4)] = cljs.core.cons((11),(state_19906[(4)])));

return statearr_19924;
})();
var inst_19895 = ws.send(inst_19885);
var inst_19896 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_19886,true);
var ___$1 = (function (){var statearr_19925 = state_19906;
(statearr_19925[(4)] = cljs.core.rest((state_19906[(4)])));

return statearr_19925;
})();
var state_19906__$1 = (function (){var statearr_19926 = state_19906;
(statearr_19926[(12)] = inst_19895);

return statearr_19926;
})();
var statearr_19927_19943 = state_19906__$1;
(statearr_19927_19943[(2)] = inst_19896);

(statearr_19927_19943[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0 = (function (){
var statearr_19928 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_19928[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__);

(statearr_19928[(1)] = (1));

return statearr_19928;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1 = (function (state_19906){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19906);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19929){var ex__2736__auto__ = e19929;
var statearr_19930_19944 = state_19906;
(statearr_19930_19944[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19906[(4)]))){
var statearr_19931_19945 = state_19906;
(statearr_19931_19945[(1)] = cljs.core.first((state_19906[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19946 = state_19906;
state_19906 = G__19946;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__ = function(state_19906){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1.call(this,state_19906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19932 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19932[(6)] = c__2755__auto__);

return statearr_19932;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));

return c__2755__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (new WebSocket(url));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__2755__auto___19984 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__2756__auto__ = (function (){var switch__2732__auto__ = (function (state_19971){
var state_val_19972 = (state_19971[(1)]);
if((state_val_19972 === (1))){
var inst_19950 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_19951 = [open_QMARK_,timeout_chan];
var inst_19952 = (new cljs.core.PersistentVector(null,2,(5),inst_19950,inst_19951,null));
var state_19971__$1 = state_19971;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_19971__$1,(2),inst_19952,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"priority","priority",1431093715),true], 0));
} else {
if((state_val_19972 === (2))){
var inst_19954 = (state_19971[(2)]);
var inst_19955 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19954,(0),null);
var inst_19956 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_19954,(1),null);
var inst_19957 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_19956,timeout_chan);
var state_19971__$1 = (function (){var statearr_19973 = state_19971;
(statearr_19973[(7)] = inst_19955);

return statearr_19973;
})();
if(inst_19957){
var statearr_19974_19985 = state_19971__$1;
(statearr_19974_19985[(1)] = (3));

} else {
var statearr_19975_19986 = state_19971__$1;
(statearr_19975_19986[(1)] = (4));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (3))){
var inst_19959 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_19960 = [new cljs.core.Keyword(null,"status","status",-1997798413),new cljs.core.Keyword(null,"error","error",-978969032)];
var inst_19961 = [(400),new cljs.core.Keyword("db","connection-error","db/connection-error",-707380971)];
var inst_19962 = cljs.core.PersistentHashMap.fromArrays(inst_19960,inst_19961);
var inst_19963 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_19959,inst_19962);
var inst_19964 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_19963);
var inst_19965 = fluree.db.util.xhttp.close_websocket(ws);
var state_19971__$1 = (function (){var statearr_19976 = state_19971;
(statearr_19976[(8)] = inst_19964);

return statearr_19976;
})();
var statearr_19977_19987 = state_19971__$1;
(statearr_19977_19987[(2)] = inst_19965);

(statearr_19977_19987[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (4))){
var inst_19967 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_19971__$1 = state_19971;
var statearr_19978_19988 = state_19971__$1;
(statearr_19978_19988[(2)] = inst_19967);

(statearr_19978_19988[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_19972 === (5))){
var inst_19969 = (state_19971[(2)]);
var state_19971__$1 = state_19971;
return cljs.core.async.impl.ioc_helpers.return_chan(state_19971__$1,inst_19969);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0 = (function (){
var statearr_19979 = [null,null,null,null,null,null,null,null,null];
(statearr_19979[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__);

(statearr_19979[(1)] = (1));

return statearr_19979;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1 = (function (state_19971){
while(true){
var ret_value__2734__auto__ = (function (){try{while(true){
var result__2735__auto__ = switch__2732__auto__(state_19971);
if(cljs.core.keyword_identical_QMARK_(result__2735__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__2735__auto__;
}
break;
}
}catch (e19980){var ex__2736__auto__ = e19980;
var statearr_19981_19989 = state_19971;
(statearr_19981_19989[(2)] = ex__2736__auto__);


if(cljs.core.seq((state_19971[(4)]))){
var statearr_19982_19990 = state_19971;
(statearr_19982_19990[(1)] = cljs.core.first((state_19971[(4)])));

} else {
throw ex__2736__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__2734__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__19991 = state_19971;
state_19971 = G__19991;
continue;
} else {
return ret_value__2734__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__ = function(state_19971){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1.call(this,state_19971);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__2733__auto__;
})()
})();
var state__2757__auto__ = (function (){var statearr_19983 = (f__2756__auto__.cljs$core$IFn$_invoke$arity$0 ? f__2756__auto__.cljs$core$IFn$_invoke$arity$0() : f__2756__auto__.call(null));
(statearr_19983[(6)] = c__2755__auto___19984);

return statearr_19983;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__2757__auto__);
}));


return new cljs.core.Keyword("fluree.db.util.xhttp","no-return","fluree.db.util.xhttp/no-return",1591333002);
});
