// Compiled by ClojureScript 1.10.866 {:static-fns true, :optimize-constants false, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38210(s__38211){
return (new cljs.core.LazySeq(null,(function (){
var s__38211__$1 = s__38211;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38211__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38216 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38216,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38216,(1),null);
var iterys__4618__auto__ = ((function (s__38211__$1,vec__38216,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38210_$_iter__38212(s__38213){
return (new cljs.core.LazySeq(null,((function (s__38211__$1,vec__38216,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__38213__$1 = s__38213;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38213__$1);
if(temp__5753__auto____$1){
var s__38213__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38213__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38213__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38215 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38214 = (0);
while(true){
if((i__38214 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38214);
cljs.core.chunk_append(b__38215,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38268 = (i__38214 + (1));
i__38214 = G__38268;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38215),tailrecursion$priority_map$iter__38210_$_iter__38212(cljs.core.chunk_rest(s__38213__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38215),null);
}
} else {
var item = cljs.core.first(s__38213__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38210_$_iter__38212(cljs.core.rest(s__38213__$2)));
}
} else {
return null;
}
break;
}
});})(s__38211__$1,vec__38216,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__38211__$1,vec__38216,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38210(cljs.core.rest(s__38211__$1)));
} else {
var G__38269 = cljs.core.rest(s__38211__$1);
s__38211__$1 = G__38269;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38219(s__38220){
return (new cljs.core.LazySeq(null,(function (){
var s__38220__$1 = s__38220;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38220__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38225 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38225,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38225,(1),null);
var iterys__4618__auto__ = ((function (s__38220__$1,vec__38225,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__38219_$_iter__38221(s__38222){
return (new cljs.core.LazySeq(null,((function (s__38220__$1,vec__38225,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__38222__$1 = s__38222;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38222__$1);
if(temp__5753__auto____$1){
var s__38222__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38222__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38222__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38224 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38223 = (0);
while(true){
if((i__38223 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38223);
cljs.core.chunk_append(b__38224,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38270 = (i__38223 + (1));
i__38223 = G__38270;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38224),tailrecursion$priority_map$iter__38219_$_iter__38221(cljs.core.chunk_rest(s__38222__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38224),null);
}
} else {
var item = cljs.core.first(s__38222__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38219_$_iter__38221(cljs.core.rest(s__38222__$2)));
}
} else {
return null;
}
break;
}
});})(s__38220__$1,vec__38225,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__38220__$1,vec__38225,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38219(cljs.core.rest(s__38220__$1)));
} else {
var G__38271 = cljs.core.rest(s__38220__$1);
s__38220__$1 = G__38271;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4330__auto__ = self__.__hash;
if((!((h__4330__auto__ == null)))){
return h__4330__auto__;
} else {
var h__4330__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4330__auto____$1);

return h__4330__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__38228 = item;
var G__38229 = new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517);
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__38228,G__38229) : self__.item__GT_priority.call(null,G__38228,G__38229));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,new cljs.core.Keyword("tailrecursion.priority-map","not-found","tailrecursion.priority-map/not-found",-436727517))){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38230(s__38231){
return (new cljs.core.LazySeq(null,(function (){
var s__38231__$1 = s__38231;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38231__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38236 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38236,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38236,(1),null);
var iterys__4618__auto__ = ((function (s__38231__$1,vec__38236,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38230_$_iter__38232(s__38233){
return (new cljs.core.LazySeq(null,((function (s__38231__$1,vec__38236,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__38233__$1 = s__38233;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38233__$1);
if(temp__5753__auto____$1){
var s__38233__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38233__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38233__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38235 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38234 = (0);
while(true){
if((i__38234 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38234);
cljs.core.chunk_append(b__38235,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38272 = (i__38234 + (1));
i__38234 = G__38272;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38235),tailrecursion$priority_map$iter__38230_$_iter__38232(cljs.core.chunk_rest(s__38233__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38235),null);
}
} else {
var item = cljs.core.first(s__38233__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38230_$_iter__38232(cljs.core.rest(s__38233__$2)));
}
} else {
return null;
}
break;
}
});})(s__38231__$1,vec__38236,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__38231__$1,vec__38236,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38230(cljs.core.rest(s__38231__$1)));
} else {
var G__38273 = cljs.core.rest(s__38231__$1);
s__38231__$1 = G__38273;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38239(s__38240){
return (new cljs.core.LazySeq(null,(function (){
var s__38240__$1 = s__38240;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38240__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38245 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38245,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38245,(1),null);
var iterys__4618__auto__ = ((function (s__38240__$1,vec__38245,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__38239_$_iter__38241(s__38242){
return (new cljs.core.LazySeq(null,((function (s__38240__$1,vec__38245,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__38242__$1 = s__38242;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38242__$1);
if(temp__5753__auto____$1){
var s__38242__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38242__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38242__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38244 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38243 = (0);
while(true){
if((i__38243 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38243);
cljs.core.chunk_append(b__38244,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38274 = (i__38243 + (1));
i__38243 = G__38274;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38244),tailrecursion$priority_map$iter__38239_$_iter__38241(cljs.core.chunk_rest(s__38242__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38244),null);
}
} else {
var item = cljs.core.first(s__38242__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38239_$_iter__38241(cljs.core.rest(s__38242__$2)));
}
} else {
return null;
}
break;
}
});})(s__38240__$1,vec__38245,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__38240__$1,vec__38245,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38239(cljs.core.rest(s__38240__$1)));
} else {
var G__38275 = cljs.core.rest(s__38240__$1);
s__38240__$1 = G__38275;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__38276 = null;
var G__38276__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__38276__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__38276 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__38276__2.call(this,self__,item);
case 3:
return G__38276__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__38276.cljs$core$IFn$_invoke$arity$2 = G__38276__2;
G__38276.cljs$core$IFn$_invoke$arity$3 = G__38276__3;
return G__38276;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args38209){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args38209)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__38248 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__38248.cljs$core$IFn$_invoke$arity$1 ? fexpr__38248.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__38248.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38249(s__38250){
return (new cljs.core.LazySeq(null,(function (){
var s__38250__$1 = s__38250;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38250__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38255 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38255,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38255,(1),null);
var iterys__4618__auto__ = ((function (s__38250__$1,vec__38255,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38249_$_iter__38251(s__38252){
return (new cljs.core.LazySeq(null,((function (s__38250__$1,vec__38255,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__38252__$1 = s__38252;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38252__$1);
if(temp__5753__auto____$1){
var s__38252__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38252__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38252__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38254 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38253 = (0);
while(true){
if((i__38253 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38253);
cljs.core.chunk_append(b__38254,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__38277 = (i__38253 + (1));
i__38253 = G__38277;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38254),tailrecursion$priority_map$iter__38249_$_iter__38251(cljs.core.chunk_rest(s__38252__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38254),null);
}
} else {
var item = cljs.core.first(s__38252__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__38249_$_iter__38251(cljs.core.rest(s__38252__$2)));
}
} else {
return null;
}
break;
}
});})(s__38250__$1,vec__38255,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__38250__$1,vec__38255,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38249(cljs.core.rest(s__38250__$1)));
} else {
var G__38278 = cljs.core.rest(s__38250__$1);
s__38250__$1 = G__38278;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4622__auto__ = (function tailrecursion$priority_map$iter__38258(s__38259){
return (new cljs.core.LazySeq(null,(function (){
var s__38259__$1 = s__38259;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__38259__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__38264 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38264,(1),null);
var iterys__4618__auto__ = ((function (s__38259__$1,vec__38264,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__38258_$_iter__38260(s__38261){
return (new cljs.core.LazySeq(null,((function (s__38259__$1,vec__38264,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__38261__$1 = s__38261;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__38261__$1);
if(temp__5753__auto____$1){
var s__38261__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__38261__$2)){
var c__4620__auto__ = cljs.core.chunk_first(s__38261__$2);
var size__4621__auto__ = cljs.core.count(c__4620__auto__);
var b__38263 = cljs.core.chunk_buffer(size__4621__auto__);
if((function (){var i__38262 = (0);
while(true){
if((i__38262 < size__4621__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4620__auto__,i__38262);
cljs.core.chunk_append(b__38263,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__38279 = (i__38262 + (1));
i__38262 = G__38279;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__38263),tailrecursion$priority_map$iter__38258_$_iter__38260(cljs.core.chunk_rest(s__38261__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__38263),null);
}
} else {
var item = cljs.core.first(s__38261__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__38258_$_iter__38260(cljs.core.rest(s__38261__$2)));
}
} else {
return null;
}
break;
}
});})(s__38259__$1,vec__38264,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__38259__$1,vec__38264,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4619__auto__ = cljs.core.seq(iterys__4618__auto__(item_set));
if(fs__4619__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4619__auto__,tailrecursion$priority_map$iter__38258(cljs.core.rest(s__38259__$1)));
} else {
var G__38280 = cljs.core.rest(s__38259__$1);
s__38259__$1 = G__38280;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4622__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__38267 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__38267) : self__.keyfn.call(null,G__38267));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"priority->set-of-items","priority->set-of-items",-1256537211,null),new cljs.core.Symbol(null,"item->priority","item->priority",-899999435,null),new cljs.core.Symbol(null,"meta","meta",-1154898805,null),new cljs.core.Symbol(null,"keyfn","keyfn",-1874375437,null),cljs.core.with_meta(new cljs.core.Symbol(null,"__hash","__hash",-1328796629,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"mutable","mutable",875778266),true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4461__auto__,writer__4462__auto__,opt__4463__auto__){
return cljs.core._write(writer__4462__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__38282 = arguments.length;
switch (G__38282) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38285 = arguments.length;
var i__4830__auto___38286 = (0);
while(true){
if((i__4830__auto___38286 < len__4829__auto___38285)){
args__4835__auto__.push((arguments[i__4830__auto___38286]));

var G__38287 = (i__4830__auto___38286 + (1));
i__4830__auto___38286 = G__38287;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((0) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__38288 = cljs.core.nnext(in$);
var G__38289 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38288;
out = G__38289;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq38284){
var self__4817__auto__ = this;
return self__4817__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq38284));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38292 = arguments.length;
var i__4830__auto___38293 = (0);
while(true){
if((i__4830__auto___38293 < len__4829__auto___38292)){
args__4835__auto__.push((arguments[i__4830__auto___38293]));

var G__38294 = (i__4830__auto___38293 + (1));
i__4830__auto___38293 = G__38294;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__38295 = cljs.core.nnext(in$);
var G__38296 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38295;
out = G__38296;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq38290){
var G__38291 = cljs.core.first(seq38290);
var seq38290__$1 = cljs.core.next(seq38290);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38291,seq38290__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38299 = arguments.length;
var i__4830__auto___38300 = (0);
while(true){
if((i__4830__auto___38300 < len__4829__auto___38299)){
args__4835__auto__.push((arguments[i__4830__auto___38300]));

var G__38301 = (i__4830__auto___38300 + (1));
i__4830__auto___38300 = G__38301;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((1) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__38302 = cljs.core.nnext(in$);
var G__38303 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38302;
out = G__38303;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq38297){
var G__38298 = cljs.core.first(seq38297);
var seq38297__$1 = cljs.core.next(seq38297);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38298,seq38297__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4835__auto__ = [];
var len__4829__auto___38307 = arguments.length;
var i__4830__auto___38308 = (0);
while(true){
if((i__4830__auto___38308 < len__4829__auto___38307)){
args__4835__auto__.push((arguments[i__4830__auto___38308]));

var G__38309 = (i__4830__auto___38308 + (1));
i__4830__auto___38308 = G__38309;
continue;
} else {
}
break;
}

var argseq__4836__auto__ = ((((2) < args__4835__auto__.length))?(new cljs.core.IndexedSeq(args__4835__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4836__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__38310 = cljs.core.nnext(in$);
var G__38311 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__38310;
out = G__38311;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq38304){
var G__38305 = cljs.core.first(seq38304);
var seq38304__$1 = cljs.core.next(seq38304);
var G__38306 = cljs.core.first(seq38304__$1);
var seq38304__$2 = cljs.core.next(seq38304__$1);
var self__4816__auto__ = this;
return self__4816__auto__.cljs$core$IFn$_invoke$arity$variadic(G__38305,G__38306,seq38304__$2);
}));

