// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__17862 = s;
var map__17862__$1 = cljs.core.__destructure_map(map__17862);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17862__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17862__$1,cljs.core.cst$kw$info);
var d = (0);
var G__17864 = info;
var map__17865 = G__17864;
var map__17865__$1 = cljs.core.__destructure_map(map__17865);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17865__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__17864__$1 = G__17864;
while(true){
var d__$2 = d__$1;
var map__17867 = G__17864__$1;
var map__17867__$1 = cljs.core.__destructure_map(map__17867);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17867__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__17868 = (d__$2 + (1));
var G__17869 = shadow__$1;
d__$1 = G__17868;
G__17864__$1 = G__17869;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__17870){
var map__17871 = p__17870;
var map__17871__$1 = cljs.core.__destructure_map(map__17871);
var name_var = map__17871__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17871__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17871__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__17872 = info;
var map__17872__$1 = cljs.core.__destructure_map(map__17872);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17872__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17872__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__17873 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__17873) : cljs.compiler.munge.call(null,G__17873));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__17875 = arguments.length;
switch (G__17875) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__17876 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__17876.cljs$core$IFn$_invoke$arity$1 ? fexpr__17876.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__17876.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__17878 = cp;
switch (G__17878) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__17880_17884 = cljs.core.seq(s);
var chunk__17881_17885 = null;
var count__17882_17886 = (0);
var i__17883_17887 = (0);
while(true){
if((i__17883_17887 < count__17882_17886)){
var c_17888 = chunk__17881_17885.cljs$core$IIndexed$_nth$arity$2(null,i__17883_17887);
sb.append(cljs.compiler.escape_char(c_17888));


var G__17889 = seq__17880_17884;
var G__17890 = chunk__17881_17885;
var G__17891 = count__17882_17886;
var G__17892 = (i__17883_17887 + (1));
seq__17880_17884 = G__17889;
chunk__17881_17885 = G__17890;
count__17882_17886 = G__17891;
i__17883_17887 = G__17892;
continue;
} else {
var temp__5753__auto___17893 = cljs.core.seq(seq__17880_17884);
if(temp__5753__auto___17893){
var seq__17880_17894__$1 = temp__5753__auto___17893;
if(cljs.core.chunked_seq_QMARK_(seq__17880_17894__$1)){
var c__4638__auto___17895 = cljs.core.chunk_first(seq__17880_17894__$1);
var G__17896 = cljs.core.chunk_rest(seq__17880_17894__$1);
var G__17897 = c__4638__auto___17895;
var G__17898 = cljs.core.count(c__4638__auto___17895);
var G__17899 = (0);
seq__17880_17884 = G__17896;
chunk__17881_17885 = G__17897;
count__17882_17886 = G__17898;
i__17883_17887 = G__17899;
continue;
} else {
var c_17900 = cljs.core.first(seq__17880_17894__$1);
sb.append(cljs.compiler.escape_char(c_17900));


var G__17901 = cljs.core.next(seq__17880_17894__$1);
var G__17902 = null;
var G__17903 = (0);
var G__17904 = (0);
seq__17880_17884 = G__17901;
chunk__17881_17885 = G__17902;
count__17882_17886 = G__17903;
i__17883_17887 = G__17904;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__17905 = cljs.core.get_global_hierarchy;
return (fexpr__17905.cljs$core$IFn$_invoke$arity$0 ? fexpr__17905.cljs$core$IFn$_invoke$arity$0() : fexpr__17905.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__17906_17911 = ast;
var map__17906_17912__$1 = cljs.core.__destructure_map(map__17906_17911);
var env_17913 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17906_17912__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_17913))){
var map__17907_17914 = env_17913;
var map__17907_17915__$1 = cljs.core.__destructure_map(map__17907_17914);
var line_17916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17907_17915__$1,cljs.core.cst$kw$line);
var column_17917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17907_17915__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__17908 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__17910 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__17909 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__17909.cljs$core$IFn$_invoke$arity$1 ? fexpr__17909.cljs$core$IFn$_invoke$arity$1(G__17910) : fexpr__17909.call(null,G__17910));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__17908,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__17908;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_17916 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_17917)?(column_17917 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__17926 = arguments.length;
switch (G__17926) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___17933 = arguments.length;
var i__4819__auto___17934 = (0);
while(true){
if((i__4819__auto___17934 < len__4818__auto___17933)){
args_arr__4839__auto__.push((arguments[i__4819__auto___17934]));

var G__17935 = (i__4819__auto___17934 + (1));
i__4819__auto___17934 = G__17935;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_17936 = (function (){var G__17927 = a;
if((!(typeof a === 'string'))){
return G__17927.toString();
} else {
return G__17927;
}
})();
var temp__5757__auto___17937 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___17937 == null)){
} else {
var sm_data_17938 = temp__5757__auto___17937;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_17938,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__17918_SHARP_){
return (p1__17918_SHARP_ + s_17936.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_17936], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__17928 = cljs.core.seq(xs);
var chunk__17929 = null;
var count__17930 = (0);
var i__17931 = (0);
while(true){
if((i__17931 < count__17930)){
var x = chunk__17929.cljs$core$IIndexed$_nth$arity$2(null,i__17931);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__17939 = seq__17928;
var G__17940 = chunk__17929;
var G__17941 = count__17930;
var G__17942 = (i__17931 + (1));
seq__17928 = G__17939;
chunk__17929 = G__17940;
count__17930 = G__17941;
i__17931 = G__17942;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__17928);
if(temp__5753__auto__){
var seq__17928__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__17928__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__17928__$1);
var G__17943 = cljs.core.chunk_rest(seq__17928__$1);
var G__17944 = c__4638__auto__;
var G__17945 = cljs.core.count(c__4638__auto__);
var G__17946 = (0);
seq__17928 = G__17943;
chunk__17929 = G__17944;
count__17930 = G__17945;
i__17931 = G__17946;
continue;
} else {
var x = cljs.core.first(seq__17928__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__17947 = cljs.core.next(seq__17928__$1);
var G__17948 = null;
var G__17949 = (0);
var G__17950 = (0);
seq__17928 = G__17947;
chunk__17929 = G__17948;
count__17930 = G__17949;
i__17931 = G__17950;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq17920){
var G__17921 = cljs.core.first(seq17920);
var seq17920__$1 = cljs.core.next(seq17920);
var G__17922 = cljs.core.first(seq17920__$1);
var seq17920__$2 = cljs.core.next(seq17920__$1);
var G__17923 = cljs.core.first(seq17920__$2);
var seq17920__$3 = cljs.core.next(seq17920__$2);
var G__17924 = cljs.core.first(seq17920__$3);
var seq17920__$4 = cljs.core.next(seq17920__$3);
var G__17925 = cljs.core.first(seq17920__$4);
var seq17920__$5 = cljs.core.next(seq17920__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17921,G__17922,G__17923,G__17924,G__17925,seq17920__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__17951){
var map__17952 = p__17951;
var map__17952__$1 = cljs.core.__destructure_map(map__17952);
var m = map__17952__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__17952__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__17960 = arguments.length;
switch (G__17960) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___17966 = arguments.length;
var i__4819__auto___17967 = (0);
while(true){
if((i__4819__auto___17967 < len__4818__auto___17966)){
args_arr__4839__auto__.push((arguments[i__4819__auto___17967]));

var G__17968 = (i__4819__auto___17967 + (1));
i__4819__auto___17967 = G__17968;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__17961_17969 = cljs.core.seq(xs);
var chunk__17962_17970 = null;
var count__17963_17971 = (0);
var i__17964_17972 = (0);
while(true){
if((i__17964_17972 < count__17963_17971)){
var x_17973 = chunk__17962_17970.cljs$core$IIndexed$_nth$arity$2(null,i__17964_17972);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_17973);


var G__17974 = seq__17961_17969;
var G__17975 = chunk__17962_17970;
var G__17976 = count__17963_17971;
var G__17977 = (i__17964_17972 + (1));
seq__17961_17969 = G__17974;
chunk__17962_17970 = G__17975;
count__17963_17971 = G__17976;
i__17964_17972 = G__17977;
continue;
} else {
var temp__5753__auto___17978 = cljs.core.seq(seq__17961_17969);
if(temp__5753__auto___17978){
var seq__17961_17979__$1 = temp__5753__auto___17978;
if(cljs.core.chunked_seq_QMARK_(seq__17961_17979__$1)){
var c__4638__auto___17980 = cljs.core.chunk_first(seq__17961_17979__$1);
var G__17981 = cljs.core.chunk_rest(seq__17961_17979__$1);
var G__17982 = c__4638__auto___17980;
var G__17983 = cljs.core.count(c__4638__auto___17980);
var G__17984 = (0);
seq__17961_17969 = G__17981;
chunk__17962_17970 = G__17982;
count__17963_17971 = G__17983;
i__17964_17972 = G__17984;
continue;
} else {
var x_17985 = cljs.core.first(seq__17961_17979__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_17985);


var G__17986 = cljs.core.next(seq__17961_17979__$1);
var G__17987 = null;
var G__17988 = (0);
var G__17989 = (0);
seq__17961_17969 = G__17986;
chunk__17962_17970 = G__17987;
count__17963_17971 = G__17988;
i__17964_17972 = G__17989;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq17954){
var G__17955 = cljs.core.first(seq17954);
var seq17954__$1 = cljs.core.next(seq17954);
var G__17956 = cljs.core.first(seq17954__$1);
var seq17954__$2 = cljs.core.next(seq17954__$1);
var G__17957 = cljs.core.first(seq17954__$2);
var seq17954__$3 = cljs.core.next(seq17954__$2);
var G__17958 = cljs.core.first(seq17954__$3);
var seq17954__$4 = cljs.core.next(seq17954__$3);
var G__17959 = cljs.core.first(seq17954__$4);
var seq17954__$5 = cljs.core.next(seq17954__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__17955,G__17956,G__17957,G__17958,G__17959,seq17954__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__17990_17994 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__17991_17995 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__17992_17996 = true;
var _STAR_print_fn_STAR__temp_val__17993_17997 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__17992_17996);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__17993_17997);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__17991_17995);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__17990_17994);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__17998 = cljs.core.get_global_hierarchy;
return (fexpr__17998.cljs$core$IFn$_invoke$arity$0 ? fexpr__17998.cljs$core$IFn$_invoke$arity$0() : fexpr__17998.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__17999 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17999,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__17999,(1),null);
var G__18002 = ns;
var G__18003 = name;
var G__18004 = (function (){
var G__18005 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__18005) : cljs.compiler.emit_constant.call(null,G__18005));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__18002,G__18003,G__18004) : cljs.compiler.emit_record_value.call(null,G__18002,G__18003,G__18004));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__18006 = cljs.core.keys(x);
var G__18007 = cljs.core.vals(x);
var G__18008 = cljs.compiler.emit_constants_comma_sep;
var G__18009 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__18006,G__18007,G__18008,G__18009) : cljs.compiler.emit_map.call(null,G__18006,G__18007,G__18008,G__18009));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__18010 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__18011 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__18010,G__18011) : cljs.compiler.emit_with_meta.call(null,G__18010,G__18011));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__18012 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18012,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18012,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18012,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__18015 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__18015) : x.call(null,G__18015));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__18016 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__18016) : x.call(null,G__18016));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__18018 = items;
var G__18019 = (function (p1__18017_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__18017_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__18018,G__18019) : cljs.compiler.emit_js_object.call(null,G__18018,G__18019));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__18021){
var map__18022 = p__18021;
var map__18022__$1 = cljs.core.__destructure_map(map__18022);
var ast = map__18022__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18022__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18022__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18022__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__18023 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__18023__$1 = cljs.core.__destructure_map(map__18023);
var cenv = map__18023__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18023__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4212__auto__ = js_module_name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__18024 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4210__auto__ = (function (){var G__18025 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__18025) : cljs.compiler.es5_GT__EQ_.call(null,G__18025));
})();
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4210__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__18024,cljs.analyzer.es5_allowed);
} else {
return G__18024;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4212__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__18026 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__18026,reserved);
} else {
return G__18026;
}
})();
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__18027_18028 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__18027_18029__$1 = (((G__18027_18028 instanceof cljs.core.Keyword))?G__18027_18028.fqn:null);
switch (G__18027_18029__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4210__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__18031){
var map__18032 = p__18031;
var map__18032__$1 = cljs.core.__destructure_map(map__18032);
var arg = map__18032__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18032__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__18033 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__18033__$1 = cljs.core.__destructure_map(map__18033);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18033__$1,cljs.core.cst$kw$name);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__18034){
var map__18035 = p__18034;
var map__18035__$1 = cljs.core.__destructure_map(map__18035);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18035__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__18036_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__18036_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__18037 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__18037) : comma_sep.call(null,G__18037));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__18038 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__18038) : comma_sep.call(null,G__18038));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__18039){
var map__18040 = p__18039;
var map__18040__$1 = cljs.core.__destructure_map(map__18040);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18040__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18040__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18040__$1,cljs.core.cst$kw$vals);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__18041){
var map__18042 = p__18041;
var map__18042__$1 = cljs.core.__destructure_map(map__18042);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18042__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18042__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__18043_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__18043_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__18044 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__18044) : comma_sep.call(null,G__18044));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__18045){
var map__18046 = p__18045;
var map__18046__$1 = cljs.core.__destructure_map(map__18046);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18046__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18046__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___18069 = cljs.core.seq(items);
if(temp__5753__auto___18069){
var items_18070__$1 = temp__5753__auto___18069;
var vec__18047_18071 = items_18070__$1;
var seq__18048_18072 = cljs.core.seq(vec__18047_18071);
var first__18049_18073 = cljs.core.first(seq__18048_18072);
var seq__18048_18074__$1 = cljs.core.next(seq__18048_18072);
var vec__18050_18075 = first__18049_18073;
var k_18076 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18050_18075,(0),null);
var v_18077 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18050_18075,(1),null);
var r_18078 = seq__18048_18074__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_18076),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_18077) : emit_js_object_val.call(null,v_18077)));

var seq__18053_18079 = cljs.core.seq(r_18078);
var chunk__18054_18080 = null;
var count__18055_18081 = (0);
var i__18056_18082 = (0);
while(true){
if((i__18056_18082 < count__18055_18081)){
var vec__18063_18083 = chunk__18054_18080.cljs$core$IIndexed$_nth$arity$2(null,i__18056_18082);
var k_18084__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18063_18083,(0),null);
var v_18085__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18063_18083,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_18084__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_18085__$1) : emit_js_object_val.call(null,v_18085__$1)));


var G__18086 = seq__18053_18079;
var G__18087 = chunk__18054_18080;
var G__18088 = count__18055_18081;
var G__18089 = (i__18056_18082 + (1));
seq__18053_18079 = G__18086;
chunk__18054_18080 = G__18087;
count__18055_18081 = G__18088;
i__18056_18082 = G__18089;
continue;
} else {
var temp__5753__auto___18090__$1 = cljs.core.seq(seq__18053_18079);
if(temp__5753__auto___18090__$1){
var seq__18053_18091__$1 = temp__5753__auto___18090__$1;
if(cljs.core.chunked_seq_QMARK_(seq__18053_18091__$1)){
var c__4638__auto___18092 = cljs.core.chunk_first(seq__18053_18091__$1);
var G__18093 = cljs.core.chunk_rest(seq__18053_18091__$1);
var G__18094 = c__4638__auto___18092;
var G__18095 = cljs.core.count(c__4638__auto___18092);
var G__18096 = (0);
seq__18053_18079 = G__18093;
chunk__18054_18080 = G__18094;
count__18055_18081 = G__18095;
i__18056_18082 = G__18096;
continue;
} else {
var vec__18066_18097 = cljs.core.first(seq__18053_18091__$1);
var k_18098__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18066_18097,(0),null);
var v_18099__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18066_18097,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_18098__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_18099__$1) : emit_js_object_val.call(null,v_18099__$1)));


var G__18100 = cljs.core.next(seq__18053_18091__$1);
var G__18101 = null;
var G__18102 = (0);
var G__18103 = (0);
seq__18053_18079 = G__18100;
chunk__18054_18080 = G__18101;
count__18055_18081 = G__18102;
i__18056_18082 = G__18103;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__18104){
var map__18105 = p__18104;
var map__18105__$1 = cljs.core.__destructure_map(map__18105);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18105__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18105__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18105__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__18106){
var map__18107 = p__18106;
var map__18107__$1 = cljs.core.__destructure_map(map__18107);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18107__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18107__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__18108){
var map__18109 = p__18108;
var map__18109__$1 = cljs.core.__destructure_map(map__18109);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18109__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__18110){
var map__18111 = p__18110;
var map__18111__$1 = cljs.core.__destructure_map(map__18111);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18111__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18111__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__18112 = cljs.analyzer.unwrap_quote(expr);
var map__18112__$1 = cljs.core.__destructure_map(map__18112);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18112__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18112__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18112__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4210__auto__){
var and__4210__auto____$1 = form;
if(cljs.core.truth_(and__4210__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__18113 = cljs.analyzer.unwrap_quote(expr);
var map__18113__$1 = cljs.core.__destructure_map(map__18113);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18113__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18113__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18113__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4212__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4212__auto__ = (function (){var fexpr__18114 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__18114.cljs$core$IFn$_invoke$arity$1 ? fexpr__18114.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__18114.call(null,tag));
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__18115){
var map__18116 = p__18115;
var map__18116__$1 = cljs.core.__destructure_map(map__18116);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18116__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18116__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18116__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18116__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18116__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4212__auto__ = unchecked;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__18117){
var map__18118 = p__18117;
var map__18118__$1 = cljs.core.__destructure_map(map__18118);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18118__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18118__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18118__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18118__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__18119_18147 = cljs.core.seq(nodes);
var chunk__18120_18148 = null;
var count__18121_18149 = (0);
var i__18122_18150 = (0);
while(true){
if((i__18122_18150 < count__18121_18149)){
var map__18135_18151 = chunk__18120_18148.cljs$core$IIndexed$_nth$arity$2(null,i__18122_18150);
var map__18135_18152__$1 = cljs.core.__destructure_map(map__18135_18151);
var ts_18153 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18135_18152__$1,cljs.core.cst$kw$tests);
var map__18136_18154 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18135_18152__$1,cljs.core.cst$kw$then);
var map__18136_18155__$1 = cljs.core.__destructure_map(map__18136_18154);
var then_18156 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18136_18155__$1,cljs.core.cst$kw$then);
var seq__18137_18157 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_18153));
var chunk__18138_18158 = null;
var count__18139_18159 = (0);
var i__18140_18160 = (0);
while(true){
if((i__18140_18160 < count__18139_18159)){
var test_18161 = chunk__18138_18158.cljs$core$IIndexed$_nth$arity$2(null,i__18140_18160);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_18161,":");


var G__18162 = seq__18137_18157;
var G__18163 = chunk__18138_18158;
var G__18164 = count__18139_18159;
var G__18165 = (i__18140_18160 + (1));
seq__18137_18157 = G__18162;
chunk__18138_18158 = G__18163;
count__18139_18159 = G__18164;
i__18140_18160 = G__18165;
continue;
} else {
var temp__5753__auto___18166 = cljs.core.seq(seq__18137_18157);
if(temp__5753__auto___18166){
var seq__18137_18167__$1 = temp__5753__auto___18166;
if(cljs.core.chunked_seq_QMARK_(seq__18137_18167__$1)){
var c__4638__auto___18168 = cljs.core.chunk_first(seq__18137_18167__$1);
var G__18169 = cljs.core.chunk_rest(seq__18137_18167__$1);
var G__18170 = c__4638__auto___18168;
var G__18171 = cljs.core.count(c__4638__auto___18168);
var G__18172 = (0);
seq__18137_18157 = G__18169;
chunk__18138_18158 = G__18170;
count__18139_18159 = G__18171;
i__18140_18160 = G__18172;
continue;
} else {
var test_18173 = cljs.core.first(seq__18137_18167__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_18173,":");


var G__18174 = cljs.core.next(seq__18137_18167__$1);
var G__18175 = null;
var G__18176 = (0);
var G__18177 = (0);
seq__18137_18157 = G__18174;
chunk__18138_18158 = G__18175;
count__18139_18159 = G__18176;
i__18140_18160 = G__18177;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_18156);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_18156);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__18178 = seq__18119_18147;
var G__18179 = chunk__18120_18148;
var G__18180 = count__18121_18149;
var G__18181 = (i__18122_18150 + (1));
seq__18119_18147 = G__18178;
chunk__18120_18148 = G__18179;
count__18121_18149 = G__18180;
i__18122_18150 = G__18181;
continue;
} else {
var temp__5753__auto___18182 = cljs.core.seq(seq__18119_18147);
if(temp__5753__auto___18182){
var seq__18119_18183__$1 = temp__5753__auto___18182;
if(cljs.core.chunked_seq_QMARK_(seq__18119_18183__$1)){
var c__4638__auto___18184 = cljs.core.chunk_first(seq__18119_18183__$1);
var G__18185 = cljs.core.chunk_rest(seq__18119_18183__$1);
var G__18186 = c__4638__auto___18184;
var G__18187 = cljs.core.count(c__4638__auto___18184);
var G__18188 = (0);
seq__18119_18147 = G__18185;
chunk__18120_18148 = G__18186;
count__18121_18149 = G__18187;
i__18122_18150 = G__18188;
continue;
} else {
var map__18141_18189 = cljs.core.first(seq__18119_18183__$1);
var map__18141_18190__$1 = cljs.core.__destructure_map(map__18141_18189);
var ts_18191 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18141_18190__$1,cljs.core.cst$kw$tests);
var map__18142_18192 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18141_18190__$1,cljs.core.cst$kw$then);
var map__18142_18193__$1 = cljs.core.__destructure_map(map__18142_18192);
var then_18194 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18142_18193__$1,cljs.core.cst$kw$then);
var seq__18143_18195 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_18191));
var chunk__18144_18196 = null;
var count__18145_18197 = (0);
var i__18146_18198 = (0);
while(true){
if((i__18146_18198 < count__18145_18197)){
var test_18199 = chunk__18144_18196.cljs$core$IIndexed$_nth$arity$2(null,i__18146_18198);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_18199,":");


var G__18200 = seq__18143_18195;
var G__18201 = chunk__18144_18196;
var G__18202 = count__18145_18197;
var G__18203 = (i__18146_18198 + (1));
seq__18143_18195 = G__18200;
chunk__18144_18196 = G__18201;
count__18145_18197 = G__18202;
i__18146_18198 = G__18203;
continue;
} else {
var temp__5753__auto___18204__$1 = cljs.core.seq(seq__18143_18195);
if(temp__5753__auto___18204__$1){
var seq__18143_18205__$1 = temp__5753__auto___18204__$1;
if(cljs.core.chunked_seq_QMARK_(seq__18143_18205__$1)){
var c__4638__auto___18206 = cljs.core.chunk_first(seq__18143_18205__$1);
var G__18207 = cljs.core.chunk_rest(seq__18143_18205__$1);
var G__18208 = c__4638__auto___18206;
var G__18209 = cljs.core.count(c__4638__auto___18206);
var G__18210 = (0);
seq__18143_18195 = G__18207;
chunk__18144_18196 = G__18208;
count__18145_18197 = G__18209;
i__18146_18198 = G__18210;
continue;
} else {
var test_18211 = cljs.core.first(seq__18143_18205__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_18211,":");


var G__18212 = cljs.core.next(seq__18143_18205__$1);
var G__18213 = null;
var G__18214 = (0);
var G__18215 = (0);
seq__18143_18195 = G__18212;
chunk__18144_18196 = G__18213;
count__18145_18197 = G__18214;
i__18146_18198 = G__18215;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_18194);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_18194);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__18216 = cljs.core.next(seq__18119_18183__$1);
var G__18217 = null;
var G__18218 = (0);
var G__18219 = (0);
seq__18119_18147 = G__18216;
chunk__18120_18148 = G__18217;
count__18121_18149 = G__18218;
i__18122_18150 = G__18219;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__18220){
var map__18221 = p__18220;
var map__18221__$1 = cljs.core.__destructure_map(map__18221);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18221__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__18225 = env;
var G__18226 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__18225,G__18226) : cljs.compiler.resolve_type.call(null,G__18225,G__18226));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__18227 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18227,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__18222_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__18222_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__18222_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__18230 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__18230,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__18230;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__18233 = env;
var G__18234 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__18233,G__18234) : cljs.compiler.resolve_type.call(null,G__18233,G__18234));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18235_SHARP_){
return cljs.compiler.resolve_type(env,p1__18235_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__18236 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__18237 = cljs.core.seq(vec__18236);
var first__18238 = cljs.core.first(seq__18237);
var seq__18237__$1 = cljs.core.next(seq__18237);
var p = first__18238;
var first__18238__$1 = cljs.core.first(seq__18237__$1);
var seq__18237__$2 = cljs.core.next(seq__18237__$1);
var ts = first__18238__$1;
var first__18238__$2 = cljs.core.first(seq__18237__$2);
var seq__18237__$3 = cljs.core.next(seq__18237__$2);
var n = first__18238__$2;
var xs = seq__18237__$3;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__18239 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__18240 = cljs.core.seq(vec__18239);
var first__18241 = cljs.core.first(seq__18240);
var seq__18240__$1 = cljs.core.next(seq__18240);
var p = first__18241;
var first__18241__$1 = cljs.core.first(seq__18240__$1);
var seq__18240__$2 = cljs.core.next(seq__18240__$1);
var ts = first__18241__$1;
var xs = seq__18240__$2;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__18243 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__18242 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__18242.cljs$core$IFn$_invoke$arity$1 ? fexpr__18242.cljs$core$IFn$_invoke$arity$1(G__18243) : fexpr__18242.call(null,G__18243));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__18246 = arguments.length;
switch (G__18246) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__18254 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18244_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__18244_SHARP_);
} else {
return p1__18244_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__18255 = cljs.core.seq(vec__18254);
var first__18256 = cljs.core.first(seq__18255);
var seq__18255__$1 = cljs.core.next(seq__18255);
var x = first__18256;
var ys = seq__18255__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__18257 = cljs.core.seq(ys);
var chunk__18258 = null;
var count__18259 = (0);
var i__18260 = (0);
while(true){
if((i__18260 < count__18259)){
var next_line = chunk__18258.cljs$core$IIndexed$_nth$arity$2(null,i__18260);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__18266 = seq__18257;
var G__18267 = chunk__18258;
var G__18268 = count__18259;
var G__18269 = (i__18260 + (1));
seq__18257 = G__18266;
chunk__18258 = G__18267;
count__18259 = G__18268;
i__18260 = G__18269;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__18257);
if(temp__5753__auto__){
var seq__18257__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18257__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__18257__$1);
var G__18270 = cljs.core.chunk_rest(seq__18257__$1);
var G__18271 = c__4638__auto__;
var G__18272 = cljs.core.count(c__4638__auto__);
var G__18273 = (0);
seq__18257 = G__18270;
chunk__18258 = G__18271;
count__18259 = G__18272;
i__18260 = G__18273;
continue;
} else {
var next_line = cljs.core.first(seq__18257__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__18274 = cljs.core.next(seq__18257__$1);
var G__18275 = null;
var G__18276 = (0);
var G__18277 = (0);
seq__18257 = G__18274;
chunk__18258 = G__18275;
count__18259 = G__18276;
i__18260 = G__18277;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__18261_18278 = cljs.core.seq(docs__$2);
var chunk__18262_18279 = null;
var count__18263_18280 = (0);
var i__18264_18281 = (0);
while(true){
if((i__18264_18281 < count__18263_18280)){
var e_18282 = chunk__18262_18279.cljs$core$IIndexed$_nth$arity$2(null,i__18264_18281);
if(cljs.core.truth_(e_18282)){
print_comment_lines(e_18282);
} else {
}


var G__18283 = seq__18261_18278;
var G__18284 = chunk__18262_18279;
var G__18285 = count__18263_18280;
var G__18286 = (i__18264_18281 + (1));
seq__18261_18278 = G__18283;
chunk__18262_18279 = G__18284;
count__18263_18280 = G__18285;
i__18264_18281 = G__18286;
continue;
} else {
var temp__5753__auto___18287 = cljs.core.seq(seq__18261_18278);
if(temp__5753__auto___18287){
var seq__18261_18288__$1 = temp__5753__auto___18287;
if(cljs.core.chunked_seq_QMARK_(seq__18261_18288__$1)){
var c__4638__auto___18289 = cljs.core.chunk_first(seq__18261_18288__$1);
var G__18290 = cljs.core.chunk_rest(seq__18261_18288__$1);
var G__18291 = c__4638__auto___18289;
var G__18292 = cljs.core.count(c__4638__auto___18289);
var G__18293 = (0);
seq__18261_18278 = G__18290;
chunk__18262_18279 = G__18291;
count__18263_18280 = G__18292;
i__18264_18281 = G__18293;
continue;
} else {
var e_18294 = cljs.core.first(seq__18261_18288__$1);
if(cljs.core.truth_(e_18294)){
print_comment_lines(e_18294);
} else {
}


var G__18295 = cljs.core.next(seq__18261_18288__$1);
var G__18296 = null;
var G__18297 = (0);
var G__18298 = (0);
seq__18261_18278 = G__18295;
chunk__18262_18279 = G__18296;
count__18263_18280 = G__18297;
i__18264_18281 = G__18298;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4210__auto__ = cljs.core.some((function (p1__18300_SHARP_){
return goog.string.startsWith(p1__18300_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = opts;
if(cljs.core.truth_(and__4210__auto____$1)){
var and__4210__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4210__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4210__auto____$2;
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__18301){
var map__18302 = p__18301;
var map__18302__$1 = cljs.core.__destructure_map(map__18302);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18302__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4212__auto__ = init;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return test;
} else {
return and__4210__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__18303){
var map__18304 = p__18303;
var map__18304__$1 = cljs.core.__destructure_map(map__18304);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18304__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18304__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18304__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__18305_18329 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__18306_18330 = null;
var count__18307_18331 = (0);
var i__18308_18332 = (0);
while(true){
if((i__18308_18332 < count__18307_18331)){
var vec__18315_18333 = chunk__18306_18330.cljs$core$IIndexed$_nth$arity$2(null,i__18308_18332);
var i_18334 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18315_18333,(0),null);
var param_18335 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18315_18333,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_18335);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__18336 = seq__18305_18329;
var G__18337 = chunk__18306_18330;
var G__18338 = count__18307_18331;
var G__18339 = (i__18308_18332 + (1));
seq__18305_18329 = G__18336;
chunk__18306_18330 = G__18337;
count__18307_18331 = G__18338;
i__18308_18332 = G__18339;
continue;
} else {
var temp__5753__auto___18340 = cljs.core.seq(seq__18305_18329);
if(temp__5753__auto___18340){
var seq__18305_18341__$1 = temp__5753__auto___18340;
if(cljs.core.chunked_seq_QMARK_(seq__18305_18341__$1)){
var c__4638__auto___18342 = cljs.core.chunk_first(seq__18305_18341__$1);
var G__18343 = cljs.core.chunk_rest(seq__18305_18341__$1);
var G__18344 = c__4638__auto___18342;
var G__18345 = cljs.core.count(c__4638__auto___18342);
var G__18346 = (0);
seq__18305_18329 = G__18343;
chunk__18306_18330 = G__18344;
count__18307_18331 = G__18345;
i__18308_18332 = G__18346;
continue;
} else {
var vec__18318_18347 = cljs.core.first(seq__18305_18341__$1);
var i_18348 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18318_18347,(0),null);
var param_18349 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18318_18347,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_18349);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__18350 = cljs.core.next(seq__18305_18341__$1);
var G__18351 = null;
var G__18352 = (0);
var G__18353 = (0);
seq__18305_18329 = G__18350;
chunk__18306_18330 = G__18351;
count__18307_18331 = G__18352;
i__18308_18332 = G__18353;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__18321_18354 = cljs.core.seq(params);
var chunk__18322_18355 = null;
var count__18323_18356 = (0);
var i__18324_18357 = (0);
while(true){
if((i__18324_18357 < count__18323_18356)){
var param_18358 = chunk__18322_18355.cljs$core$IIndexed$_nth$arity$2(null,i__18324_18357);
cljs.compiler.emit(param_18358);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18358,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18359 = seq__18321_18354;
var G__18360 = chunk__18322_18355;
var G__18361 = count__18323_18356;
var G__18362 = (i__18324_18357 + (1));
seq__18321_18354 = G__18359;
chunk__18322_18355 = G__18360;
count__18323_18356 = G__18361;
i__18324_18357 = G__18362;
continue;
} else {
var temp__5753__auto___18363 = cljs.core.seq(seq__18321_18354);
if(temp__5753__auto___18363){
var seq__18321_18364__$1 = temp__5753__auto___18363;
if(cljs.core.chunked_seq_QMARK_(seq__18321_18364__$1)){
var c__4638__auto___18365 = cljs.core.chunk_first(seq__18321_18364__$1);
var G__18366 = cljs.core.chunk_rest(seq__18321_18364__$1);
var G__18367 = c__4638__auto___18365;
var G__18368 = cljs.core.count(c__4638__auto___18365);
var G__18369 = (0);
seq__18321_18354 = G__18366;
chunk__18322_18355 = G__18367;
count__18323_18356 = G__18368;
i__18324_18357 = G__18369;
continue;
} else {
var param_18370 = cljs.core.first(seq__18321_18364__$1);
cljs.compiler.emit(param_18370);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18370,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18371 = cljs.core.next(seq__18321_18364__$1);
var G__18372 = null;
var G__18373 = (0);
var G__18374 = (0);
seq__18321_18354 = G__18371;
chunk__18322_18355 = G__18372;
count__18323_18356 = G__18373;
i__18324_18357 = G__18374;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__18325_18375 = cljs.core.seq(params);
var chunk__18326_18376 = null;
var count__18327_18377 = (0);
var i__18328_18378 = (0);
while(true){
if((i__18328_18378 < count__18327_18377)){
var param_18379 = chunk__18326_18376.cljs$core$IIndexed$_nth$arity$2(null,i__18328_18378);
cljs.compiler.emit(param_18379);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18379,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18380 = seq__18325_18375;
var G__18381 = chunk__18326_18376;
var G__18382 = count__18327_18377;
var G__18383 = (i__18328_18378 + (1));
seq__18325_18375 = G__18380;
chunk__18326_18376 = G__18381;
count__18327_18377 = G__18382;
i__18328_18378 = G__18383;
continue;
} else {
var temp__5753__auto___18384 = cljs.core.seq(seq__18325_18375);
if(temp__5753__auto___18384){
var seq__18325_18385__$1 = temp__5753__auto___18384;
if(cljs.core.chunked_seq_QMARK_(seq__18325_18385__$1)){
var c__4638__auto___18386 = cljs.core.chunk_first(seq__18325_18385__$1);
var G__18387 = cljs.core.chunk_rest(seq__18325_18385__$1);
var G__18388 = c__4638__auto___18386;
var G__18389 = cljs.core.count(c__4638__auto___18386);
var G__18390 = (0);
seq__18325_18375 = G__18387;
chunk__18326_18376 = G__18388;
count__18327_18377 = G__18389;
i__18328_18378 = G__18390;
continue;
} else {
var param_18391 = cljs.core.first(seq__18325_18385__$1);
cljs.compiler.emit(param_18391);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18391,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18392 = cljs.core.next(seq__18325_18385__$1);
var G__18393 = null;
var G__18394 = (0);
var G__18395 = (0);
seq__18325_18375 = G__18392;
chunk__18326_18376 = G__18393;
count__18327_18377 = G__18394;
i__18328_18378 = G__18395;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__18396 = cljs.core.seq(params);
var chunk__18397 = null;
var count__18398 = (0);
var i__18399 = (0);
while(true){
if((i__18399 < count__18398)){
var param = chunk__18397.cljs$core$IIndexed$_nth$arity$2(null,i__18399);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18400 = seq__18396;
var G__18401 = chunk__18397;
var G__18402 = count__18398;
var G__18403 = (i__18399 + (1));
seq__18396 = G__18400;
chunk__18397 = G__18401;
count__18398 = G__18402;
i__18399 = G__18403;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__18396);
if(temp__5753__auto__){
var seq__18396__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__18396__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__18396__$1);
var G__18404 = cljs.core.chunk_rest(seq__18396__$1);
var G__18405 = c__4638__auto__;
var G__18406 = cljs.core.count(c__4638__auto__);
var G__18407 = (0);
seq__18396 = G__18404;
chunk__18397 = G__18405;
count__18398 = G__18406;
i__18399 = G__18407;
continue;
} else {
var param = cljs.core.first(seq__18396__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18408 = cljs.core.next(seq__18396__$1);
var G__18409 = null;
var G__18410 = (0);
var G__18411 = (0);
seq__18396 = G__18408;
chunk__18397 = G__18409;
count__18398 = G__18410;
i__18399 = G__18411;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__18412){
var map__18413 = p__18412;
var map__18413__$1 = cljs.core.__destructure_map(map__18413);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18413__$1,cljs.core.cst$kw$recurs);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__18414){
var map__18415 = p__18414;
var map__18415__$1 = cljs.core.__destructure_map(map__18415);
var f = map__18415__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18415__$1,cljs.core.cst$kw$recurs);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_18424__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_18425 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_18424__$1);
var delegate_name_18426 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_18425),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_18426," = function (");

var seq__18416_18427 = cljs.core.seq(params);
var chunk__18417_18428 = null;
var count__18418_18429 = (0);
var i__18419_18430 = (0);
while(true){
if((i__18419_18430 < count__18418_18429)){
var param_18431 = chunk__18417_18428.cljs$core$IIndexed$_nth$arity$2(null,i__18419_18430);
cljs.compiler.emit(param_18431);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18431,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18432 = seq__18416_18427;
var G__18433 = chunk__18417_18428;
var G__18434 = count__18418_18429;
var G__18435 = (i__18419_18430 + (1));
seq__18416_18427 = G__18432;
chunk__18417_18428 = G__18433;
count__18418_18429 = G__18434;
i__18419_18430 = G__18435;
continue;
} else {
var temp__5753__auto___18436 = cljs.core.seq(seq__18416_18427);
if(temp__5753__auto___18436){
var seq__18416_18437__$1 = temp__5753__auto___18436;
if(cljs.core.chunked_seq_QMARK_(seq__18416_18437__$1)){
var c__4638__auto___18438 = cljs.core.chunk_first(seq__18416_18437__$1);
var G__18439 = cljs.core.chunk_rest(seq__18416_18437__$1);
var G__18440 = c__4638__auto___18438;
var G__18441 = cljs.core.count(c__4638__auto___18438);
var G__18442 = (0);
seq__18416_18427 = G__18439;
chunk__18417_18428 = G__18440;
count__18418_18429 = G__18441;
i__18419_18430 = G__18442;
continue;
} else {
var param_18443 = cljs.core.first(seq__18416_18437__$1);
cljs.compiler.emit(param_18443);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18443,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18444 = cljs.core.next(seq__18416_18437__$1);
var G__18445 = null;
var G__18446 = (0);
var G__18447 = (0);
seq__18416_18427 = G__18444;
chunk__18417_18428 = G__18445;
count__18418_18429 = G__18446;
i__18419_18430 = G__18447;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_18425," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_18448 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_18448,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_18426,".call(this,");

var seq__18420_18449 = cljs.core.seq(params);
var chunk__18421_18450 = null;
var count__18422_18451 = (0);
var i__18423_18452 = (0);
while(true){
if((i__18423_18452 < count__18422_18451)){
var param_18453 = chunk__18421_18450.cljs$core$IIndexed$_nth$arity$2(null,i__18423_18452);
cljs.compiler.emit(param_18453);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18453,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18454 = seq__18420_18449;
var G__18455 = chunk__18421_18450;
var G__18456 = count__18422_18451;
var G__18457 = (i__18423_18452 + (1));
seq__18420_18449 = G__18454;
chunk__18421_18450 = G__18455;
count__18422_18451 = G__18456;
i__18423_18452 = G__18457;
continue;
} else {
var temp__5753__auto___18458 = cljs.core.seq(seq__18420_18449);
if(temp__5753__auto___18458){
var seq__18420_18459__$1 = temp__5753__auto___18458;
if(cljs.core.chunked_seq_QMARK_(seq__18420_18459__$1)){
var c__4638__auto___18460 = cljs.core.chunk_first(seq__18420_18459__$1);
var G__18461 = cljs.core.chunk_rest(seq__18420_18459__$1);
var G__18462 = c__4638__auto___18460;
var G__18463 = cljs.core.count(c__4638__auto___18460);
var G__18464 = (0);
seq__18420_18449 = G__18461;
chunk__18421_18450 = G__18462;
count__18422_18451 = G__18463;
i__18423_18452 = G__18464;
continue;
} else {
var param_18465 = cljs.core.first(seq__18420_18459__$1);
cljs.compiler.emit(param_18465);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_18465,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__18466 = cljs.core.next(seq__18420_18459__$1);
var G__18467 = null;
var G__18468 = (0);
var G__18469 = (0);
seq__18420_18449 = G__18466;
chunk__18421_18450 = G__18467;
count__18422_18451 = G__18468;
i__18423_18452 = G__18469;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18425,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_18425,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_18424__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18425,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_18426,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_18425,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__18473){
var map__18474 = p__18473;
var map__18474__$1 = cljs.core.__destructure_map(map__18474);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18474__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__18470_SHARP_){
var and__4210__auto__ = p1__18470_SHARP_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__18470_SHARP_));
} else {
return and__4210__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4212__auto__ = in_loop;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_18526__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_18527 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_18526__$1);
var maxparams_18528 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_18529 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_18527),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_18530 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__18471_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__18471_SHARP_)));
}),cljs.core.seq(mmap_18529));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_18527," = null;");

var seq__18475_18531 = cljs.core.seq(ms_18530);
var chunk__18476_18532 = null;
var count__18477_18533 = (0);
var i__18478_18534 = (0);
while(true){
if((i__18478_18534 < count__18477_18533)){
var vec__18485_18535 = chunk__18476_18532.cljs$core$IIndexed$_nth$arity$2(null,i__18478_18534);
var n_18536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18485_18535,(0),null);
var meth_18537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18485_18535,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_18536," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18537))){
cljs.compiler.emit_variadic_fn_method(meth_18537);
} else {
cljs.compiler.emit_fn_method(meth_18537);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__18538 = seq__18475_18531;
var G__18539 = chunk__18476_18532;
var G__18540 = count__18477_18533;
var G__18541 = (i__18478_18534 + (1));
seq__18475_18531 = G__18538;
chunk__18476_18532 = G__18539;
count__18477_18533 = G__18540;
i__18478_18534 = G__18541;
continue;
} else {
var temp__5753__auto___18542 = cljs.core.seq(seq__18475_18531);
if(temp__5753__auto___18542){
var seq__18475_18543__$1 = temp__5753__auto___18542;
if(cljs.core.chunked_seq_QMARK_(seq__18475_18543__$1)){
var c__4638__auto___18544 = cljs.core.chunk_first(seq__18475_18543__$1);
var G__18545 = cljs.core.chunk_rest(seq__18475_18543__$1);
var G__18546 = c__4638__auto___18544;
var G__18547 = cljs.core.count(c__4638__auto___18544);
var G__18548 = (0);
seq__18475_18531 = G__18545;
chunk__18476_18532 = G__18546;
count__18477_18533 = G__18547;
i__18478_18534 = G__18548;
continue;
} else {
var vec__18488_18549 = cljs.core.first(seq__18475_18543__$1);
var n_18550 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18488_18549,(0),null);
var meth_18551 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18488_18549,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_18550," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18551))){
cljs.compiler.emit_variadic_fn_method(meth_18551);
} else {
cljs.compiler.emit_fn_method(meth_18551);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__18552 = cljs.core.next(seq__18475_18543__$1);
var G__18553 = null;
var G__18554 = (0);
var G__18555 = (0);
seq__18475_18531 = G__18552;
chunk__18476_18532 = G__18553;
count__18477_18533 = G__18554;
i__18478_18534 = G__18555;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18527," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_18528),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_18528)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_18528));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__18491_18556 = cljs.core.seq(ms_18530);
var chunk__18492_18557 = null;
var count__18493_18558 = (0);
var i__18494_18559 = (0);
while(true){
if((i__18494_18559 < count__18493_18558)){
var vec__18501_18560 = chunk__18492_18557.cljs$core$IIndexed$_nth$arity$2(null,i__18494_18559);
var n_18561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18501_18560,(0),null);
var meth_18562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18501_18560,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18562))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_18563 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_18563," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_18564 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_18563," = new cljs.core.IndexedSeq(",a_18564,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_18561,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_18528)),(((cljs.core.count(maxparams_18528) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_18563,");"], 0));
} else {
var pcnt_18565 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_18562));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_18565,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_18561,".call(this",(((pcnt_18565 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_18565,maxparams_18528)),null,(1),null)),(2),null))),");");
}


var G__18566 = seq__18491_18556;
var G__18567 = chunk__18492_18557;
var G__18568 = count__18493_18558;
var G__18569 = (i__18494_18559 + (1));
seq__18491_18556 = G__18566;
chunk__18492_18557 = G__18567;
count__18493_18558 = G__18568;
i__18494_18559 = G__18569;
continue;
} else {
var temp__5753__auto___18570 = cljs.core.seq(seq__18491_18556);
if(temp__5753__auto___18570){
var seq__18491_18571__$1 = temp__5753__auto___18570;
if(cljs.core.chunked_seq_QMARK_(seq__18491_18571__$1)){
var c__4638__auto___18572 = cljs.core.chunk_first(seq__18491_18571__$1);
var G__18573 = cljs.core.chunk_rest(seq__18491_18571__$1);
var G__18574 = c__4638__auto___18572;
var G__18575 = cljs.core.count(c__4638__auto___18572);
var G__18576 = (0);
seq__18491_18556 = G__18573;
chunk__18492_18557 = G__18574;
count__18493_18558 = G__18575;
i__18494_18559 = G__18576;
continue;
} else {
var vec__18504_18577 = cljs.core.first(seq__18491_18571__$1);
var n_18578 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18504_18577,(0),null);
var meth_18579 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18504_18577,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18579))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_18580 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_18580," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_18581 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_18580," = new cljs.core.IndexedSeq(",a_18581,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_18578,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_18528)),(((cljs.core.count(maxparams_18528) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_18580,");"], 0));
} else {
var pcnt_18582 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_18579));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_18582,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_18578,".call(this",(((pcnt_18582 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_18582,maxparams_18528)),null,(1),null)),(2),null))),");");
}


var G__18583 = cljs.core.next(seq__18491_18571__$1);
var G__18584 = null;
var G__18585 = (0);
var G__18586 = (0);
seq__18491_18556 = G__18583;
chunk__18492_18557 = G__18584;
count__18493_18558 = G__18585;
i__18494_18559 = G__18586;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_18587 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_18530)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_18587,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18527,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18527,".cljs$lang$applyTo = ",cljs.core.some((function (p1__18472_SHARP_){
var vec__18507 = p1__18472_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18507,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18507,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_18530),".cljs$lang$applyTo;");
} else {
}

var seq__18510_18588 = cljs.core.seq(ms_18530);
var chunk__18511_18589 = null;
var count__18512_18590 = (0);
var i__18513_18591 = (0);
while(true){
if((i__18513_18591 < count__18512_18590)){
var vec__18520_18592 = chunk__18511_18589.cljs$core$IIndexed$_nth$arity$2(null,i__18513_18591);
var n_18593 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18520_18592,(0),null);
var meth_18594 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18520_18592,(1),null);
var c_18595 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_18594));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18594))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18527,".cljs$core$IFn$_invoke$arity$variadic = ",n_18593,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_18527,".cljs$core$IFn$_invoke$arity$",c_18595," = ",n_18593,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__18596 = seq__18510_18588;
var G__18597 = chunk__18511_18589;
var G__18598 = count__18512_18590;
var G__18599 = (i__18513_18591 + (1));
seq__18510_18588 = G__18596;
chunk__18511_18589 = G__18597;
count__18512_18590 = G__18598;
i__18513_18591 = G__18599;
continue;
} else {
var temp__5753__auto___18600 = cljs.core.seq(seq__18510_18588);
if(temp__5753__auto___18600){
var seq__18510_18601__$1 = temp__5753__auto___18600;
if(cljs.core.chunked_seq_QMARK_(seq__18510_18601__$1)){
var c__4638__auto___18602 = cljs.core.chunk_first(seq__18510_18601__$1);
var G__18603 = cljs.core.chunk_rest(seq__18510_18601__$1);
var G__18604 = c__4638__auto___18602;
var G__18605 = cljs.core.count(c__4638__auto___18602);
var G__18606 = (0);
seq__18510_18588 = G__18603;
chunk__18511_18589 = G__18604;
count__18512_18590 = G__18605;
i__18513_18591 = G__18606;
continue;
} else {
var vec__18523_18607 = cljs.core.first(seq__18510_18601__$1);
var n_18608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18523_18607,(0),null);
var meth_18609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18523_18607,(1),null);
var c_18610 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_18609));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_18609))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_18527,".cljs$core$IFn$_invoke$arity$variadic = ",n_18608,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_18527,".cljs$core$IFn$_invoke$arity$",c_18610," = ",n_18608,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__18611 = cljs.core.next(seq__18510_18601__$1);
var G__18612 = null;
var G__18613 = (0);
var G__18614 = (0);
seq__18510_18588 = G__18611;
chunk__18511_18589 = G__18612;
count__18512_18590 = G__18613;
i__18513_18591 = G__18614;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_18527,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__18615){
var map__18616 = p__18615;
var map__18616__$1 = cljs.core.__destructure_map(map__18616);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18616__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18616__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18616__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__18617_18621 = cljs.core.seq(statements);
var chunk__18618_18622 = null;
var count__18619_18623 = (0);
var i__18620_18624 = (0);
while(true){
if((i__18620_18624 < count__18619_18623)){
var s_18625 = chunk__18618_18622.cljs$core$IIndexed$_nth$arity$2(null,i__18620_18624);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_18625);


var G__18626 = seq__18617_18621;
var G__18627 = chunk__18618_18622;
var G__18628 = count__18619_18623;
var G__18629 = (i__18620_18624 + (1));
seq__18617_18621 = G__18626;
chunk__18618_18622 = G__18627;
count__18619_18623 = G__18628;
i__18620_18624 = G__18629;
continue;
} else {
var temp__5753__auto___18630 = cljs.core.seq(seq__18617_18621);
if(temp__5753__auto___18630){
var seq__18617_18631__$1 = temp__5753__auto___18630;
if(cljs.core.chunked_seq_QMARK_(seq__18617_18631__$1)){
var c__4638__auto___18632 = cljs.core.chunk_first(seq__18617_18631__$1);
var G__18633 = cljs.core.chunk_rest(seq__18617_18631__$1);
var G__18634 = c__4638__auto___18632;
var G__18635 = cljs.core.count(c__4638__auto___18632);
var G__18636 = (0);
seq__18617_18621 = G__18633;
chunk__18618_18622 = G__18634;
count__18619_18623 = G__18635;
i__18620_18624 = G__18636;
continue;
} else {
var s_18637 = cljs.core.first(seq__18617_18631__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_18637);


var G__18638 = cljs.core.next(seq__18617_18631__$1);
var G__18639 = null;
var G__18640 = (0);
var G__18641 = (0);
seq__18617_18621 = G__18638;
chunk__18618_18622 = G__18639;
count__18619_18623 = G__18640;
i__18620_18624 = G__18641;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__18642){
var map__18643 = p__18642;
var map__18643__$1 = cljs.core.__destructure_map(map__18643);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18643__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18643__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18643__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18643__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18643__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__18644,is_loop){
var map__18645 = p__18644;
var map__18645__$1 = cljs.core.__destructure_map(map__18645);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18645__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18645__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18645__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__18646_18656 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__18647_18657 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__18647_18657);

try{var seq__18648_18658 = cljs.core.seq(bindings);
var chunk__18649_18659 = null;
var count__18650_18660 = (0);
var i__18651_18661 = (0);
while(true){
if((i__18651_18661 < count__18650_18660)){
var map__18654_18662 = chunk__18649_18659.cljs$core$IIndexed$_nth$arity$2(null,i__18651_18661);
var map__18654_18663__$1 = cljs.core.__destructure_map(map__18654_18662);
var binding_18664 = map__18654_18663__$1;
var init_18665 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18654_18663__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_18664);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_18665,";");


var G__18666 = seq__18648_18658;
var G__18667 = chunk__18649_18659;
var G__18668 = count__18650_18660;
var G__18669 = (i__18651_18661 + (1));
seq__18648_18658 = G__18666;
chunk__18649_18659 = G__18667;
count__18650_18660 = G__18668;
i__18651_18661 = G__18669;
continue;
} else {
var temp__5753__auto___18670 = cljs.core.seq(seq__18648_18658);
if(temp__5753__auto___18670){
var seq__18648_18671__$1 = temp__5753__auto___18670;
if(cljs.core.chunked_seq_QMARK_(seq__18648_18671__$1)){
var c__4638__auto___18672 = cljs.core.chunk_first(seq__18648_18671__$1);
var G__18673 = cljs.core.chunk_rest(seq__18648_18671__$1);
var G__18674 = c__4638__auto___18672;
var G__18675 = cljs.core.count(c__4638__auto___18672);
var G__18676 = (0);
seq__18648_18658 = G__18673;
chunk__18649_18659 = G__18674;
count__18650_18660 = G__18675;
i__18651_18661 = G__18676;
continue;
} else {
var map__18655_18677 = cljs.core.first(seq__18648_18671__$1);
var map__18655_18678__$1 = cljs.core.__destructure_map(map__18655_18677);
var binding_18679 = map__18655_18678__$1;
var init_18680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18655_18678__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_18679);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_18680,";");


var G__18681 = cljs.core.next(seq__18648_18671__$1);
var G__18682 = null;
var G__18683 = (0);
var G__18684 = (0);
seq__18648_18658 = G__18681;
chunk__18649_18659 = G__18682;
count__18650_18660 = G__18683;
i__18651_18661 = G__18684;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__18646_18656);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__18685){
var map__18686 = p__18685;
var map__18686__$1 = cljs.core.__destructure_map(map__18686);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18686__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18686__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18686__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4695__auto___18687 = cljs.core.count(exprs);
var i_18688 = (0);
while(true){
if((i_18688 < n__4695__auto___18687)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_18688) : temps.call(null,i_18688))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_18688) : exprs.call(null,i_18688)),";");

var G__18689 = (i_18688 + (1));
i_18688 = G__18689;
continue;
} else {
}
break;
}

var n__4695__auto___18690 = cljs.core.count(exprs);
var i_18691 = (0);
while(true){
if((i_18691 < n__4695__auto___18690)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_18691) : params.call(null,i_18691)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_18691) : temps.call(null,i_18691)),";");

var G__18692 = (i_18691 + (1));
i_18691 = G__18692;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__18693){
var map__18694 = p__18693;
var map__18694__$1 = cljs.core.__destructure_map(map__18694);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18694__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18694__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18694__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__18695_18703 = cljs.core.seq(bindings);
var chunk__18696_18704 = null;
var count__18697_18705 = (0);
var i__18698_18706 = (0);
while(true){
if((i__18698_18706 < count__18697_18705)){
var map__18701_18707 = chunk__18696_18704.cljs$core$IIndexed$_nth$arity$2(null,i__18698_18706);
var map__18701_18708__$1 = cljs.core.__destructure_map(map__18701_18707);
var binding_18709 = map__18701_18708__$1;
var init_18710 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18701_18708__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_18709)," = ",init_18710,";");


var G__18711 = seq__18695_18703;
var G__18712 = chunk__18696_18704;
var G__18713 = count__18697_18705;
var G__18714 = (i__18698_18706 + (1));
seq__18695_18703 = G__18711;
chunk__18696_18704 = G__18712;
count__18697_18705 = G__18713;
i__18698_18706 = G__18714;
continue;
} else {
var temp__5753__auto___18715 = cljs.core.seq(seq__18695_18703);
if(temp__5753__auto___18715){
var seq__18695_18716__$1 = temp__5753__auto___18715;
if(cljs.core.chunked_seq_QMARK_(seq__18695_18716__$1)){
var c__4638__auto___18717 = cljs.core.chunk_first(seq__18695_18716__$1);
var G__18718 = cljs.core.chunk_rest(seq__18695_18716__$1);
var G__18719 = c__4638__auto___18717;
var G__18720 = cljs.core.count(c__4638__auto___18717);
var G__18721 = (0);
seq__18695_18703 = G__18718;
chunk__18696_18704 = G__18719;
count__18697_18705 = G__18720;
i__18698_18706 = G__18721;
continue;
} else {
var map__18702_18722 = cljs.core.first(seq__18695_18716__$1);
var map__18702_18723__$1 = cljs.core.__destructure_map(map__18702_18722);
var binding_18724 = map__18702_18723__$1;
var init_18725 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18702_18723__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_18724)," = ",init_18725,";");


var G__18726 = cljs.core.next(seq__18695_18716__$1);
var G__18727 = null;
var G__18728 = (0);
var G__18729 = (0);
seq__18695_18703 = G__18726;
chunk__18696_18704 = G__18727;
count__18697_18705 = G__18728;
i__18698_18706 = G__18729;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__18732){
var map__18733 = p__18732;
var map__18733__$1 = cljs.core.__destructure_map(map__18733);
var expr = map__18733__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18733__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18733__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18733__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4210__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4210__auto__ = protocol;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = tag;
if(cljs.core.truth_(and__4210__auto____$1)){
var or__4212__auto__ = (function (){var and__4210__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto____$2)){
var and__4210__auto____$3 = protocol;
if(cljs.core.truth_(and__4210__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4210__auto____$3;
}
} else {
return and__4210__auto____$2;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto____$2 = (function (){var or__4212__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4210__auto____$2)){
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
var and__4210__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4210__auto____$3){
var and__4210__auto____$4 = cljs.core.not((function (){var fexpr__18737 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__18737.cljs$core$IFn$_invoke$arity$1 ? fexpr__18737.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__18737.call(null,tag));
})());
if(and__4210__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4210__auto____$4;
}
} else {
return and__4210__auto____$3;
}
}
} else {
return and__4210__auto____$2;
}
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__18738 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__18738.cljs$core$IFn$_invoke$arity$1 ? fexpr__18738.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__18738.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__18734 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (arity > mfa);
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__18730_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__18730_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__18731_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__18731_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18734,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18734,(1),null);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_18741 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_18741,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_18742 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_18742,args)),(((mfa_18742 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_18742,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var G__18740 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__18739 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__18739.cljs$core$IFn$_invoke$arity$1 ? fexpr__18739.cljs$core$IFn$_invoke$arity$1(G__18740) : fexpr__18739.call(null,G__18740));
} else {
return and__4210__auto__;
}
})())){
var fprop_18743 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_18743," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_18743,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_18743," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_18743,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__18744){
var map__18745 = p__18744;
var map__18745__$1 = cljs.core.__destructure_map(map__18745);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18745__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18745__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18745__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__18746){
var map__18747 = p__18746;
var map__18747__$1 = cljs.core.__destructure_map(map__18747);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18747__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__18748_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__18748_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__18749 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18749,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18749,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__18752 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__18752__$1 = cljs.core.__destructure_map(map__18752);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18752__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18752__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__18753 = options;
var map__18753__$1 = cljs.core.__destructure_map(map__18753);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18753__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18753__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18753__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__18754 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__18757 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__18757__$1 = cljs.core.__destructure_map(map__18757);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18757__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18757__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18754,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18754,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__18758_18786 = cljs.core.seq(libs_to_load);
var chunk__18759_18787 = null;
var count__18760_18788 = (0);
var i__18761_18789 = (0);
while(true){
if((i__18761_18789 < count__18760_18788)){
var lib_18790 = chunk__18759_18787.cljs$core$IIndexed$_nth$arity$2(null,i__18761_18789);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_18790)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_18790),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18790),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_18790),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18790),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_18790,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18790),"');");
}

}
}
}


var G__18791 = seq__18758_18786;
var G__18792 = chunk__18759_18787;
var G__18793 = count__18760_18788;
var G__18794 = (i__18761_18789 + (1));
seq__18758_18786 = G__18791;
chunk__18759_18787 = G__18792;
count__18760_18788 = G__18793;
i__18761_18789 = G__18794;
continue;
} else {
var temp__5753__auto___18795 = cljs.core.seq(seq__18758_18786);
if(temp__5753__auto___18795){
var seq__18758_18796__$1 = temp__5753__auto___18795;
if(cljs.core.chunked_seq_QMARK_(seq__18758_18796__$1)){
var c__4638__auto___18797 = cljs.core.chunk_first(seq__18758_18796__$1);
var G__18798 = cljs.core.chunk_rest(seq__18758_18796__$1);
var G__18799 = c__4638__auto___18797;
var G__18800 = cljs.core.count(c__4638__auto___18797);
var G__18801 = (0);
seq__18758_18786 = G__18798;
chunk__18759_18787 = G__18799;
count__18760_18788 = G__18800;
i__18761_18789 = G__18801;
continue;
} else {
var lib_18802 = cljs.core.first(seq__18758_18796__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_18802)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_18802),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18802),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_18802),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18802),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_18802,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_18802),"');");
}

}
}
}


var G__18803 = cljs.core.next(seq__18758_18796__$1);
var G__18804 = null;
var G__18805 = (0);
var G__18806 = (0);
seq__18758_18786 = G__18803;
chunk__18759_18787 = G__18804;
count__18760_18788 = G__18805;
i__18761_18789 = G__18806;
continue;
}
} else {
}
}
break;
}

var seq__18762_18807 = cljs.core.seq(node_libs);
var chunk__18763_18808 = null;
var count__18764_18809 = (0);
var i__18765_18810 = (0);
while(true){
if((i__18765_18810 < count__18764_18809)){
var lib_18811 = chunk__18763_18808.cljs$core$IIndexed$_nth$arity$2(null,i__18765_18810);
var vec__18772_18812 = cljs.analyzer.lib_AMPERSAND_sublib(lib_18811);
var lib_SINGLEQUOTE__18813 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18772_18812,(0),null);
var sublib_18814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18772_18812,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_18811)," = require('",lib_SINGLEQUOTE__18813,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_18814),";"], 0));


var G__18815 = seq__18762_18807;
var G__18816 = chunk__18763_18808;
var G__18817 = count__18764_18809;
var G__18818 = (i__18765_18810 + (1));
seq__18762_18807 = G__18815;
chunk__18763_18808 = G__18816;
count__18764_18809 = G__18817;
i__18765_18810 = G__18818;
continue;
} else {
var temp__5753__auto___18819 = cljs.core.seq(seq__18762_18807);
if(temp__5753__auto___18819){
var seq__18762_18820__$1 = temp__5753__auto___18819;
if(cljs.core.chunked_seq_QMARK_(seq__18762_18820__$1)){
var c__4638__auto___18821 = cljs.core.chunk_first(seq__18762_18820__$1);
var G__18822 = cljs.core.chunk_rest(seq__18762_18820__$1);
var G__18823 = c__4638__auto___18821;
var G__18824 = cljs.core.count(c__4638__auto___18821);
var G__18825 = (0);
seq__18762_18807 = G__18822;
chunk__18763_18808 = G__18823;
count__18764_18809 = G__18824;
i__18765_18810 = G__18825;
continue;
} else {
var lib_18826 = cljs.core.first(seq__18762_18820__$1);
var vec__18775_18827 = cljs.analyzer.lib_AMPERSAND_sublib(lib_18826);
var lib_SINGLEQUOTE__18828 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18775_18827,(0),null);
var sublib_18829 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18775_18827,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_18826)," = require('",lib_SINGLEQUOTE__18828,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_18829),";"], 0));


var G__18830 = cljs.core.next(seq__18762_18820__$1);
var G__18831 = null;
var G__18832 = (0);
var G__18833 = (0);
seq__18762_18807 = G__18830;
chunk__18763_18808 = G__18831;
count__18764_18809 = G__18832;
i__18765_18810 = G__18833;
continue;
}
} else {
}
}
break;
}

var seq__18778_18834 = cljs.core.seq(global_exports_libs);
var chunk__18779_18835 = null;
var count__18780_18836 = (0);
var i__18781_18837 = (0);
while(true){
if((i__18781_18837 < count__18780_18836)){
var lib_18838 = chunk__18779_18835.cljs$core$IIndexed$_nth$arity$2(null,i__18781_18837);
var map__18784_18839 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_18838))));
var map__18784_18840__$1 = cljs.core.__destructure_map(map__18784_18839);
var global_exports_18841 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18784_18840__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_18841,lib_18838);


var G__18842 = seq__18778_18834;
var G__18843 = chunk__18779_18835;
var G__18844 = count__18780_18836;
var G__18845 = (i__18781_18837 + (1));
seq__18778_18834 = G__18842;
chunk__18779_18835 = G__18843;
count__18780_18836 = G__18844;
i__18781_18837 = G__18845;
continue;
} else {
var temp__5753__auto___18846 = cljs.core.seq(seq__18778_18834);
if(temp__5753__auto___18846){
var seq__18778_18847__$1 = temp__5753__auto___18846;
if(cljs.core.chunked_seq_QMARK_(seq__18778_18847__$1)){
var c__4638__auto___18848 = cljs.core.chunk_first(seq__18778_18847__$1);
var G__18849 = cljs.core.chunk_rest(seq__18778_18847__$1);
var G__18850 = c__4638__auto___18848;
var G__18851 = cljs.core.count(c__4638__auto___18848);
var G__18852 = (0);
seq__18778_18834 = G__18849;
chunk__18779_18835 = G__18850;
count__18780_18836 = G__18851;
i__18781_18837 = G__18852;
continue;
} else {
var lib_18853 = cljs.core.first(seq__18778_18847__$1);
var map__18785_18854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_18853))));
var map__18785_18855__$1 = cljs.core.__destructure_map(map__18785_18854);
var global_exports_18856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18785_18855__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_18856,lib_18853);


var G__18857 = cljs.core.next(seq__18778_18847__$1);
var G__18858 = null;
var G__18859 = (0);
var G__18860 = (0);
seq__18778_18834 = G__18857;
chunk__18779_18835 = G__18858;
count__18780_18836 = G__18859;
i__18781_18837 = G__18860;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__18861){
var map__18862 = p__18861;
var map__18862__$1 = cljs.core.__destructure_map(map__18862);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18862__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__18863){
var map__18864 = p__18863;
var map__18864__$1 = cljs.core.__destructure_map(map__18864);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18864__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__18865){
var map__18866 = p__18865;
var map__18866__$1 = cljs.core.__destructure_map(map__18866);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18866__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18866__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18866__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18866__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18866__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__18867_18891 = cljs.core.seq(protocols);
var chunk__18868_18892 = null;
var count__18869_18893 = (0);
var i__18870_18894 = (0);
while(true){
if((i__18870_18894 < count__18869_18893)){
var protocol_18895 = chunk__18868_18892.cljs$core$IIndexed$_nth$arity$2(null,i__18870_18894);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_18895)),"}");


var G__18896 = seq__18867_18891;
var G__18897 = chunk__18868_18892;
var G__18898 = count__18869_18893;
var G__18899 = (i__18870_18894 + (1));
seq__18867_18891 = G__18896;
chunk__18868_18892 = G__18897;
count__18869_18893 = G__18898;
i__18870_18894 = G__18899;
continue;
} else {
var temp__5753__auto___18900 = cljs.core.seq(seq__18867_18891);
if(temp__5753__auto___18900){
var seq__18867_18901__$1 = temp__5753__auto___18900;
if(cljs.core.chunked_seq_QMARK_(seq__18867_18901__$1)){
var c__4638__auto___18902 = cljs.core.chunk_first(seq__18867_18901__$1);
var G__18903 = cljs.core.chunk_rest(seq__18867_18901__$1);
var G__18904 = c__4638__auto___18902;
var G__18905 = cljs.core.count(c__4638__auto___18902);
var G__18906 = (0);
seq__18867_18891 = G__18903;
chunk__18868_18892 = G__18904;
count__18869_18893 = G__18905;
i__18870_18894 = G__18906;
continue;
} else {
var protocol_18907 = cljs.core.first(seq__18867_18901__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_18907)),"}");


var G__18908 = cljs.core.next(seq__18867_18901__$1);
var G__18909 = null;
var G__18910 = (0);
var G__18911 = (0);
seq__18867_18891 = G__18908;
chunk__18868_18892 = G__18909;
count__18869_18893 = G__18910;
i__18870_18894 = G__18911;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__18871_18912 = cljs.core.seq(fields__$1);
var chunk__18872_18913 = null;
var count__18873_18914 = (0);
var i__18874_18915 = (0);
while(true){
if((i__18874_18915 < count__18873_18914)){
var fld_18916 = chunk__18872_18913.cljs$core$IIndexed$_nth$arity$2(null,i__18874_18915);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_18916," = ",fld_18916,";");


var G__18917 = seq__18871_18912;
var G__18918 = chunk__18872_18913;
var G__18919 = count__18873_18914;
var G__18920 = (i__18874_18915 + (1));
seq__18871_18912 = G__18917;
chunk__18872_18913 = G__18918;
count__18873_18914 = G__18919;
i__18874_18915 = G__18920;
continue;
} else {
var temp__5753__auto___18921 = cljs.core.seq(seq__18871_18912);
if(temp__5753__auto___18921){
var seq__18871_18922__$1 = temp__5753__auto___18921;
if(cljs.core.chunked_seq_QMARK_(seq__18871_18922__$1)){
var c__4638__auto___18923 = cljs.core.chunk_first(seq__18871_18922__$1);
var G__18924 = cljs.core.chunk_rest(seq__18871_18922__$1);
var G__18925 = c__4638__auto___18923;
var G__18926 = cljs.core.count(c__4638__auto___18923);
var G__18927 = (0);
seq__18871_18912 = G__18924;
chunk__18872_18913 = G__18925;
count__18873_18914 = G__18926;
i__18874_18915 = G__18927;
continue;
} else {
var fld_18928 = cljs.core.first(seq__18871_18922__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_18928," = ",fld_18928,";");


var G__18929 = cljs.core.next(seq__18871_18922__$1);
var G__18930 = null;
var G__18931 = (0);
var G__18932 = (0);
seq__18871_18912 = G__18929;
chunk__18872_18913 = G__18930;
count__18873_18914 = G__18931;
i__18874_18915 = G__18932;
continue;
}
} else {
}
}
break;
}

var seq__18875_18933 = cljs.core.seq(pmasks);
var chunk__18876_18934 = null;
var count__18877_18935 = (0);
var i__18878_18936 = (0);
while(true){
if((i__18878_18936 < count__18877_18935)){
var vec__18885_18937 = chunk__18876_18934.cljs$core$IIndexed$_nth$arity$2(null,i__18878_18936);
var pno_18938 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18885_18937,(0),null);
var pmask_18939 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18885_18937,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_18938,"$ = ",pmask_18939,";");


var G__18940 = seq__18875_18933;
var G__18941 = chunk__18876_18934;
var G__18942 = count__18877_18935;
var G__18943 = (i__18878_18936 + (1));
seq__18875_18933 = G__18940;
chunk__18876_18934 = G__18941;
count__18877_18935 = G__18942;
i__18878_18936 = G__18943;
continue;
} else {
var temp__5753__auto___18944 = cljs.core.seq(seq__18875_18933);
if(temp__5753__auto___18944){
var seq__18875_18945__$1 = temp__5753__auto___18944;
if(cljs.core.chunked_seq_QMARK_(seq__18875_18945__$1)){
var c__4638__auto___18946 = cljs.core.chunk_first(seq__18875_18945__$1);
var G__18947 = cljs.core.chunk_rest(seq__18875_18945__$1);
var G__18948 = c__4638__auto___18946;
var G__18949 = cljs.core.count(c__4638__auto___18946);
var G__18950 = (0);
seq__18875_18933 = G__18947;
chunk__18876_18934 = G__18948;
count__18877_18935 = G__18949;
i__18878_18936 = G__18950;
continue;
} else {
var vec__18888_18951 = cljs.core.first(seq__18875_18945__$1);
var pno_18952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18888_18951,(0),null);
var pmask_18953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18888_18951,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_18952,"$ = ",pmask_18953,";");


var G__18954 = cljs.core.next(seq__18875_18945__$1);
var G__18955 = null;
var G__18956 = (0);
var G__18957 = (0);
seq__18875_18933 = G__18954;
chunk__18876_18934 = G__18955;
count__18877_18935 = G__18956;
i__18878_18936 = G__18957;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__18958){
var map__18959 = p__18958;
var map__18959__$1 = cljs.core.__destructure_map(map__18959);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18959__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18959__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18959__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18959__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__18959__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__18960_18984 = cljs.core.seq(protocols);
var chunk__18961_18985 = null;
var count__18962_18986 = (0);
var i__18963_18987 = (0);
while(true){
if((i__18963_18987 < count__18962_18986)){
var protocol_18988 = chunk__18961_18985.cljs$core$IIndexed$_nth$arity$2(null,i__18963_18987);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_18988)),"}");


var G__18989 = seq__18960_18984;
var G__18990 = chunk__18961_18985;
var G__18991 = count__18962_18986;
var G__18992 = (i__18963_18987 + (1));
seq__18960_18984 = G__18989;
chunk__18961_18985 = G__18990;
count__18962_18986 = G__18991;
i__18963_18987 = G__18992;
continue;
} else {
var temp__5753__auto___18993 = cljs.core.seq(seq__18960_18984);
if(temp__5753__auto___18993){
var seq__18960_18994__$1 = temp__5753__auto___18993;
if(cljs.core.chunked_seq_QMARK_(seq__18960_18994__$1)){
var c__4638__auto___18995 = cljs.core.chunk_first(seq__18960_18994__$1);
var G__18996 = cljs.core.chunk_rest(seq__18960_18994__$1);
var G__18997 = c__4638__auto___18995;
var G__18998 = cljs.core.count(c__4638__auto___18995);
var G__18999 = (0);
seq__18960_18984 = G__18996;
chunk__18961_18985 = G__18997;
count__18962_18986 = G__18998;
i__18963_18987 = G__18999;
continue;
} else {
var protocol_19000 = cljs.core.first(seq__18960_18994__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_19000)),"}");


var G__19001 = cljs.core.next(seq__18960_18994__$1);
var G__19002 = null;
var G__19003 = (0);
var G__19004 = (0);
seq__18960_18984 = G__19001;
chunk__18961_18985 = G__19002;
count__18962_18986 = G__19003;
i__18963_18987 = G__19004;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__18964_19005 = cljs.core.seq(fields__$1);
var chunk__18965_19006 = null;
var count__18966_19007 = (0);
var i__18967_19008 = (0);
while(true){
if((i__18967_19008 < count__18966_19007)){
var fld_19009 = chunk__18965_19006.cljs$core$IIndexed$_nth$arity$2(null,i__18967_19008);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_19009," = ",fld_19009,";");


var G__19010 = seq__18964_19005;
var G__19011 = chunk__18965_19006;
var G__19012 = count__18966_19007;
var G__19013 = (i__18967_19008 + (1));
seq__18964_19005 = G__19010;
chunk__18965_19006 = G__19011;
count__18966_19007 = G__19012;
i__18967_19008 = G__19013;
continue;
} else {
var temp__5753__auto___19014 = cljs.core.seq(seq__18964_19005);
if(temp__5753__auto___19014){
var seq__18964_19015__$1 = temp__5753__auto___19014;
if(cljs.core.chunked_seq_QMARK_(seq__18964_19015__$1)){
var c__4638__auto___19016 = cljs.core.chunk_first(seq__18964_19015__$1);
var G__19017 = cljs.core.chunk_rest(seq__18964_19015__$1);
var G__19018 = c__4638__auto___19016;
var G__19019 = cljs.core.count(c__4638__auto___19016);
var G__19020 = (0);
seq__18964_19005 = G__19017;
chunk__18965_19006 = G__19018;
count__18966_19007 = G__19019;
i__18967_19008 = G__19020;
continue;
} else {
var fld_19021 = cljs.core.first(seq__18964_19015__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_19021," = ",fld_19021,";");


var G__19022 = cljs.core.next(seq__18964_19015__$1);
var G__19023 = null;
var G__19024 = (0);
var G__19025 = (0);
seq__18964_19005 = G__19022;
chunk__18965_19006 = G__19023;
count__18966_19007 = G__19024;
i__18967_19008 = G__19025;
continue;
}
} else {
}
}
break;
}

var seq__18968_19026 = cljs.core.seq(pmasks);
var chunk__18969_19027 = null;
var count__18970_19028 = (0);
var i__18971_19029 = (0);
while(true){
if((i__18971_19029 < count__18970_19028)){
var vec__18978_19030 = chunk__18969_19027.cljs$core$IIndexed$_nth$arity$2(null,i__18971_19029);
var pno_19031 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18978_19030,(0),null);
var pmask_19032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18978_19030,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_19031,"$ = ",pmask_19032,";");


var G__19033 = seq__18968_19026;
var G__19034 = chunk__18969_19027;
var G__19035 = count__18970_19028;
var G__19036 = (i__18971_19029 + (1));
seq__18968_19026 = G__19033;
chunk__18969_19027 = G__19034;
count__18970_19028 = G__19035;
i__18971_19029 = G__19036;
continue;
} else {
var temp__5753__auto___19037 = cljs.core.seq(seq__18968_19026);
if(temp__5753__auto___19037){
var seq__18968_19038__$1 = temp__5753__auto___19037;
if(cljs.core.chunked_seq_QMARK_(seq__18968_19038__$1)){
var c__4638__auto___19039 = cljs.core.chunk_first(seq__18968_19038__$1);
var G__19040 = cljs.core.chunk_rest(seq__18968_19038__$1);
var G__19041 = c__4638__auto___19039;
var G__19042 = cljs.core.count(c__4638__auto___19039);
var G__19043 = (0);
seq__18968_19026 = G__19040;
chunk__18969_19027 = G__19041;
count__18970_19028 = G__19042;
i__18971_19029 = G__19043;
continue;
} else {
var vec__18981_19044 = cljs.core.first(seq__18968_19038__$1);
var pno_19045 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18981_19044,(0),null);
var pmask_19046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__18981_19044,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_19045,"$ = ",pmask_19046,";");


var G__19047 = cljs.core.next(seq__18968_19038__$1);
var G__19048 = null;
var G__19049 = (0);
var G__19050 = (0);
seq__18968_19026 = G__19047;
chunk__18969_19027 = G__19048;
count__18970_19028 = G__19049;
i__18971_19029 = G__19050;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__19051){
var map__19052 = p__19051;
var map__19052__$1 = cljs.core.__destructure_map(map__19052);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19052__$1,cljs.core.cst$kw$env);
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__19053){
var map__19054 = p__19053;
var map__19054__$1 = cljs.core.__destructure_map(map__19054);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__19054__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4210__auto__ = code;
if(cljs.core.truth_(and__4210__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4210__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__16611__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__16611__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__19059 = cljs.core.seq(table);
var chunk__19060 = null;
var count__19061 = (0);
var i__19062 = (0);
while(true){
if((i__19062 < count__19061)){
var vec__19069 = chunk__19060.cljs$core$IIndexed$_nth$arity$2(null,i__19062);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19069,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19069,(1),null);
var ns_19075 = cljs.core.namespace(sym);
var name_19076 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__19077 = seq__19059;
var G__19078 = chunk__19060;
var G__19079 = count__19061;
var G__19080 = (i__19062 + (1));
seq__19059 = G__19077;
chunk__19060 = G__19078;
count__19061 = G__19079;
i__19062 = G__19080;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__19059);
if(temp__5753__auto__){
var seq__19059__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__19059__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__19059__$1);
var G__19081 = cljs.core.chunk_rest(seq__19059__$1);
var G__19082 = c__4638__auto__;
var G__19083 = cljs.core.count(c__4638__auto__);
var G__19084 = (0);
seq__19059 = G__19081;
chunk__19060 = G__19082;
count__19061 = G__19083;
i__19062 = G__19084;
continue;
} else {
var vec__19072 = cljs.core.first(seq__19059__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19072,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19072,(1),null);
var ns_19085 = cljs.core.namespace(sym);
var name_19086 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__19087 = cljs.core.next(seq__19059__$1);
var G__19088 = null;
var G__19089 = (0);
var G__19090 = (0);
seq__19059 = G__19087;
chunk__19060 = G__19088;
count__19061 = G__19089;
i__19062 = G__19090;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__19092 = arguments.length;
switch (G__19092) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_19097 = cljs.core.first(ks);
var vec__19093_19098 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_19097);
var top_19099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__19093_19098,(0),null);
var prefix_SINGLEQUOTE__19100 = vec__19093_19098;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_19097)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__19100) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_19099)) || (cljs.core.contains_QMARK_(known_externs,top_19099)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__19100)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_19099);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__19100)),";");
}
} else {
}

var m_19101 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_19097);
if(cljs.core.empty_QMARK_(m_19101)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__19100,m_19101,top_level,known_externs);
}

var G__19102 = cljs.core.next(ks);
ks = G__19102;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

