// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.core.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async.impl.protocols');
goog.require('cljs.core.async.impl.channels');
goog.require('cljs.core.async.impl.buffers');
goog.require('cljs.core.async.impl.timers');
goog.require('cljs.core.async.impl.dispatch');
goog.require('cljs.core.async.impl.ioc_helpers');
goog.require('goog.array');
cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__26361 = arguments.length;
switch (G__26361) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26362 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26362 = (function (f,blockable,meta26363){
this.f = f;
this.blockable = blockable;
this.meta26363 = meta26363;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26364,meta26363__$1){
var self__ = this;
var _26364__$1 = this;
return (new cljs.core.async.t_cljs$core$async26362(self__.f,self__.blockable,meta26363__$1));
}));

(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26364){
var self__ = this;
var _26364__$1 = this;
return self__.meta26363;
}));

(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async26362.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async26362.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$blockable,cljs.core.cst$sym$meta26363], null);
}));

(cljs.core.async.t_cljs$core$async26362.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26362.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26362");

(cljs.core.async.t_cljs$core$async26362.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async26362");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26362.
 */
cljs.core.async.__GT_t_cljs$core$async26362 = (function cljs$core$async$__GT_t_cljs$core$async26362(f__$1,blockable__$1,meta26363){
return (new cljs.core.async.t_cljs$core$async26362(f__$1,blockable__$1,meta26363));
});

}

return (new cljs.core.async.t_cljs$core$async26362(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__26368 = arguments.length;
switch (G__26368) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__26371 = arguments.length;
switch (G__26371) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__26374 = arguments.length;
switch (G__26374) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_26376 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_26376) : fn1.call(null,val_26376));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_26376) : fn1.call(null,val_26376));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__26378 = arguments.length;
switch (G__26378) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5751__auto__)){
var ret = temp__5751__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5751__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5751__auto__)){
var retb = temp__5751__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null,ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__4695__auto___26380 = n;
var x_26381 = (0);
while(true){
if((x_26381 < n__4695__auto___26380)){
(a[x_26381] = x_26381);

var G__26382 = (x_26381 + (1));
x_26381 = G__26382;
continue;
} else {
}
break;
}

goog.array.shuffle(a);

return a;
});
cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26383 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26383 = (function (flag,meta26384){
this.flag = flag;
this.meta26384 = meta26384;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26385,meta26384__$1){
var self__ = this;
var _26385__$1 = this;
return (new cljs.core.async.t_cljs$core$async26383(self__.flag,meta26384__$1));
}));

(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26385){
var self__ = this;
var _26385__$1 = this;
return self__.meta26384;
}));

(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async26383.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async26383.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$meta26384], null);
}));

(cljs.core.async.t_cljs$core$async26383.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26383.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26383");

(cljs.core.async.t_cljs$core$async26383.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async26383");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26383.
 */
cljs.core.async.__GT_t_cljs$core$async26383 = (function cljs$core$async$alt_flag_$___GT_t_cljs$core$async26383(flag__$1,meta26384){
return (new cljs.core.async.t_cljs$core$async26383(flag__$1,meta26384));
});

}

return (new cljs.core.async.t_cljs$core$async26383(flag,cljs.core.PersistentArrayMap.EMPTY));
});
cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26386 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26386 = (function (flag,cb,meta26387){
this.flag = flag;
this.cb = cb;
this.meta26387 = meta26387;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26388,meta26387__$1){
var self__ = this;
var _26388__$1 = this;
return (new cljs.core.async.t_cljs$core$async26386(self__.flag,self__.cb,meta26387__$1));
}));

(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26388){
var self__ = this;
var _26388__$1 = this;
return self__.meta26387;
}));

(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async26386.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async26386.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$flag,cljs.core.cst$sym$cb,cljs.core.cst$sym$meta26387], null);
}));

(cljs.core.async.t_cljs$core$async26386.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26386.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26386");

(cljs.core.async.t_cljs$core$async26386.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async26386");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26386.
 */
cljs.core.async.__GT_t_cljs$core$async26386 = (function cljs$core$async$alt_handler_$___GT_t_cljs$core$async26386(flag__$1,cb__$1,meta26387){
return (new cljs.core.async.t_cljs$core$async26386(flag__$1,cb__$1,meta26387));
});

}

return (new cljs.core.async.t_cljs$core$async26386(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var n = cljs.core.count(ports);
var idxs = cljs.core.async.random_array(n);
var priority = cljs.core.cst$kw$priority.cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null,(0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null,(1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26389_SHARP_){
var G__26391 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26389_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__26391) : fret.call(null,G__26391));
});})(i,val,idx,port,wport,flag,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,n,idxs,priority){
return (function (p1__26390_SHARP_){
var G__26392 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__26390_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__26392) : fret.call(null,G__26392));
});})(i,idx,port,wport,flag,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__4212__auto__ = wport;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return port;
}
})()], null));
} else {
var G__26393 = (i + (1));
i = G__26393;
continue;
}
} else {
return null;
}
break;
}
})();
var or__4212__auto__ = ret;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,cljs.core.cst$kw$default)){
var temp__5753__auto__ = (function (){var and__4210__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null);
if(cljs.core.truth_(and__4210__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5753__auto__)){
var got = temp__5753__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$default.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$default], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___26398 = arguments.length;
var i__4819__auto___26399 = (0);
while(true){
if((i__4819__auto___26399 < len__4818__auto___26398)){
args__4824__auto__.push((arguments[i__4819__auto___26399]));

var G__26400 = (i__4819__auto___26399 + (1));
i__4819__auto___26399 = G__26400;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__26396){
var map__26397 = p__26396;
var map__26397__$1 = cljs.core.__destructure_map(map__26397);
var opts = map__26397__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq26394){
var G__26395 = cljs.core.first(seq26394);
var seq26394__$1 = cljs.core.next(seq26394);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__26395,seq26394__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__26402 = arguments.length;
switch (G__26402) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__24424__auto___26449 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26426){
var state_val_26427 = (state_26426[(1)]);
if((state_val_26427 === (7))){
var inst_26422 = (state_26426[(2)]);
var state_26426__$1 = state_26426;
var statearr_26428_26450 = state_26426__$1;
(statearr_26428_26450[(2)] = inst_26422);

(statearr_26428_26450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (1))){
var state_26426__$1 = state_26426;
var statearr_26429_26451 = state_26426__$1;
(statearr_26429_26451[(2)] = null);

(statearr_26429_26451[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (4))){
var inst_26405 = (state_26426[(7)]);
var inst_26405__$1 = (state_26426[(2)]);
var inst_26406 = (inst_26405__$1 == null);
var state_26426__$1 = (function (){var statearr_26430 = state_26426;
(statearr_26430[(7)] = inst_26405__$1);

return statearr_26430;
})();
if(cljs.core.truth_(inst_26406)){
var statearr_26431_26452 = state_26426__$1;
(statearr_26431_26452[(1)] = (5));

} else {
var statearr_26432_26453 = state_26426__$1;
(statearr_26432_26453[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (13))){
var state_26426__$1 = state_26426;
var statearr_26433_26454 = state_26426__$1;
(statearr_26433_26454[(2)] = null);

(statearr_26433_26454[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (6))){
var inst_26405 = (state_26426[(7)]);
var state_26426__$1 = state_26426;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26426__$1,(11),to,inst_26405);
} else {
if((state_val_26427 === (3))){
var inst_26424 = (state_26426[(2)]);
var state_26426__$1 = state_26426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26426__$1,inst_26424);
} else {
if((state_val_26427 === (12))){
var state_26426__$1 = state_26426;
var statearr_26434_26455 = state_26426__$1;
(statearr_26434_26455[(2)] = null);

(statearr_26434_26455[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (2))){
var state_26426__$1 = state_26426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26426__$1,(4),from);
} else {
if((state_val_26427 === (11))){
var inst_26415 = (state_26426[(2)]);
var state_26426__$1 = state_26426;
if(cljs.core.truth_(inst_26415)){
var statearr_26435_26456 = state_26426__$1;
(statearr_26435_26456[(1)] = (12));

} else {
var statearr_26436_26457 = state_26426__$1;
(statearr_26436_26457[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (9))){
var state_26426__$1 = state_26426;
var statearr_26437_26458 = state_26426__$1;
(statearr_26437_26458[(2)] = null);

(statearr_26437_26458[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (5))){
var state_26426__$1 = state_26426;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26438_26459 = state_26426__$1;
(statearr_26438_26459[(1)] = (8));

} else {
var statearr_26439_26460 = state_26426__$1;
(statearr_26439_26460[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (14))){
var inst_26420 = (state_26426[(2)]);
var state_26426__$1 = state_26426;
var statearr_26440_26461 = state_26426__$1;
(statearr_26440_26461[(2)] = inst_26420);

(statearr_26440_26461[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (10))){
var inst_26412 = (state_26426[(2)]);
var state_26426__$1 = state_26426;
var statearr_26441_26462 = state_26426__$1;
(statearr_26441_26462[(2)] = inst_26412);

(statearr_26441_26462[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26427 === (8))){
var inst_26409 = cljs.core.async.close_BANG_(to);
var state_26426__$1 = state_26426;
var statearr_26442_26463 = state_26426__$1;
(statearr_26442_26463[(2)] = inst_26409);

(statearr_26442_26463[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_26443 = [null,null,null,null,null,null,null,null];
(statearr_26443[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_26443[(1)] = (1));

return statearr_26443;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_26426){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26426);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26444){var ex__24301__auto__ = e26444;
var statearr_26445_26464 = state_26426;
(statearr_26445_26464[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26426[(4)]))){
var statearr_26446_26465 = state_26426;
(statearr_26446_26465[(1)] = cljs.core.first((state_26426[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26466 = state_26426;
state_26426 = G__26466;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_26426){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_26426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26447 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26447[(6)] = c__24424__auto___26449);

return statearr_26447;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process = (function (p__26467){
var vec__26468 = p__26467;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26468,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26468,(1),null);
var job = vec__26468;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__24424__auto___26644 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26475){
var state_val_26476 = (state_26475[(1)]);
if((state_val_26476 === (1))){
var state_26475__$1 = state_26475;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26475__$1,(2),res,v);
} else {
if((state_val_26476 === (2))){
var inst_26472 = (state_26475[(2)]);
var inst_26473 = cljs.core.async.close_BANG_(res);
var state_26475__$1 = (function (){var statearr_26477 = state_26475;
(statearr_26477[(7)] = inst_26472);

return statearr_26477;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_26475__$1,inst_26473);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_26478 = [null,null,null,null,null,null,null,null];
(statearr_26478[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__);

(statearr_26478[(1)] = (1));

return statearr_26478;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1 = (function (state_26475){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26475);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26479){var ex__24301__auto__ = e26479;
var statearr_26480_26645 = state_26475;
(statearr_26480_26645[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26475[(4)]))){
var statearr_26481_26646 = state_26475;
(statearr_26481_26646[(1)] = cljs.core.first((state_26475[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26647 = state_26475;
state_26475 = G__26647;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = function(state_26475){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1.call(this,state_26475);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26482 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26482[(6)] = c__24424__auto___26644);

return statearr_26482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__26483){
var vec__26484 = p__26483;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26484,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26484,(1),null);
var job = vec__26484;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null,v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__4695__auto___26648 = n;
var __26649 = (0);
while(true){
if((__26649 < n__4695__auto___26648)){
var G__26487_26650 = type;
var G__26487_26651__$1 = (((G__26487_26650 instanceof cljs.core.Keyword))?G__26487_26650.fqn:null);
switch (G__26487_26651__$1) {
case "compute":
var c__24424__auto___26653 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__26649,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = ((function (__26649,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function (state_26500){
var state_val_26501 = (state_26500[(1)]);
if((state_val_26501 === (1))){
var state_26500__$1 = state_26500;
var statearr_26502_26654 = state_26500__$1;
(statearr_26502_26654[(2)] = null);

(statearr_26502_26654[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26501 === (2))){
var state_26500__$1 = state_26500;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26500__$1,(4),jobs);
} else {
if((state_val_26501 === (3))){
var inst_26498 = (state_26500[(2)]);
var state_26500__$1 = state_26500;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26500__$1,inst_26498);
} else {
if((state_val_26501 === (4))){
var inst_26490 = (state_26500[(2)]);
var inst_26491 = process(inst_26490);
var state_26500__$1 = state_26500;
if(cljs.core.truth_(inst_26491)){
var statearr_26503_26655 = state_26500__$1;
(statearr_26503_26655[(1)] = (5));

} else {
var statearr_26504_26656 = state_26500__$1;
(statearr_26504_26656[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26501 === (5))){
var state_26500__$1 = state_26500;
var statearr_26505_26657 = state_26500__$1;
(statearr_26505_26657[(2)] = null);

(statearr_26505_26657[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26501 === (6))){
var state_26500__$1 = state_26500;
var statearr_26506_26658 = state_26500__$1;
(statearr_26506_26658[(2)] = null);

(statearr_26506_26658[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26501 === (7))){
var inst_26496 = (state_26500[(2)]);
var state_26500__$1 = state_26500;
var statearr_26507_26659 = state_26500__$1;
(statearr_26507_26659[(2)] = inst_26496);

(statearr_26507_26659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__26649,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
;
return ((function (__26649,switch__24297__auto__,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_26508 = [null,null,null,null,null,null,null];
(statearr_26508[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__);

(statearr_26508[(1)] = (1));

return statearr_26508;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1 = (function (state_26500){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26500);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26509){var ex__24301__auto__ = e26509;
var statearr_26510_26660 = state_26500;
(statearr_26510_26660[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26500[(4)]))){
var statearr_26511_26661 = state_26500;
(statearr_26511_26661[(1)] = cljs.core.first((state_26500[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26662 = state_26500;
state_26500 = G__26662;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = function(state_26500){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1.call(this,state_26500);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__;
})()
;})(__26649,switch__24297__auto__,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
})();
var state__24426__auto__ = (function (){var statearr_26512 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26512[(6)] = c__24424__auto___26653);

return statearr_26512;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
});})(__26649,c__24424__auto___26653,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
);


break;
case "async":
var c__24424__auto___26663 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__26649,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = ((function (__26649,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function (state_26525){
var state_val_26526 = (state_26525[(1)]);
if((state_val_26526 === (1))){
var state_26525__$1 = state_26525;
var statearr_26527_26664 = state_26525__$1;
(statearr_26527_26664[(2)] = null);

(statearr_26527_26664[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26526 === (2))){
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26525__$1,(4),jobs);
} else {
if((state_val_26526 === (3))){
var inst_26523 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26525__$1,inst_26523);
} else {
if((state_val_26526 === (4))){
var inst_26515 = (state_26525[(2)]);
var inst_26516 = async(inst_26515);
var state_26525__$1 = state_26525;
if(cljs.core.truth_(inst_26516)){
var statearr_26528_26665 = state_26525__$1;
(statearr_26528_26665[(1)] = (5));

} else {
var statearr_26529_26666 = state_26525__$1;
(statearr_26529_26666[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26526 === (5))){
var state_26525__$1 = state_26525;
var statearr_26530_26667 = state_26525__$1;
(statearr_26530_26667[(2)] = null);

(statearr_26530_26667[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26526 === (6))){
var state_26525__$1 = state_26525;
var statearr_26531_26668 = state_26525__$1;
(statearr_26531_26668[(2)] = null);

(statearr_26531_26668[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26526 === (7))){
var inst_26521 = (state_26525[(2)]);
var state_26525__$1 = state_26525;
var statearr_26532_26669 = state_26525__$1;
(statearr_26532_26669[(2)] = inst_26521);

(statearr_26532_26669[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});})(__26649,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
;
return ((function (__26649,switch__24297__auto__,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_26533 = [null,null,null,null,null,null,null];
(statearr_26533[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__);

(statearr_26533[(1)] = (1));

return statearr_26533;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1 = (function (state_26525){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26525);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26534){var ex__24301__auto__ = e26534;
var statearr_26535_26670 = state_26525;
(statearr_26535_26670[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26525[(4)]))){
var statearr_26536_26671 = state_26525;
(statearr_26536_26671[(1)] = cljs.core.first((state_26525[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26672 = state_26525;
state_26525 = G__26672;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = function(state_26525){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1.call(this,state_26525);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__;
})()
;})(__26649,switch__24297__auto__,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
})();
var state__24426__auto__ = (function (){var statearr_26537 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26537[(6)] = c__24424__auto___26663);

return statearr_26537;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
});})(__26649,c__24424__auto___26663,G__26487_26650,G__26487_26651__$1,n__4695__auto___26648,jobs,results,process,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__26487_26651__$1)].join('')));

}

var G__26673 = (__26649 + (1));
__26649 = G__26673;
continue;
} else {
}
break;
}

var c__24424__auto___26674 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26559){
var state_val_26560 = (state_26559[(1)]);
if((state_val_26560 === (7))){
var inst_26555 = (state_26559[(2)]);
var state_26559__$1 = state_26559;
var statearr_26561_26675 = state_26559__$1;
(statearr_26561_26675[(2)] = inst_26555);

(statearr_26561_26675[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26560 === (1))){
var state_26559__$1 = state_26559;
var statearr_26562_26676 = state_26559__$1;
(statearr_26562_26676[(2)] = null);

(statearr_26562_26676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26560 === (4))){
var inst_26540 = (state_26559[(7)]);
var inst_26540__$1 = (state_26559[(2)]);
var inst_26541 = (inst_26540__$1 == null);
var state_26559__$1 = (function (){var statearr_26563 = state_26559;
(statearr_26563[(7)] = inst_26540__$1);

return statearr_26563;
})();
if(cljs.core.truth_(inst_26541)){
var statearr_26564_26677 = state_26559__$1;
(statearr_26564_26677[(1)] = (5));

} else {
var statearr_26565_26678 = state_26559__$1;
(statearr_26565_26678[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26560 === (6))){
var inst_26540 = (state_26559[(7)]);
var inst_26545 = (state_26559[(8)]);
var inst_26545__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_26546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26547 = [inst_26540,inst_26545__$1];
var inst_26548 = (new cljs.core.PersistentVector(null,2,(5),inst_26546,inst_26547,null));
var state_26559__$1 = (function (){var statearr_26566 = state_26559;
(statearr_26566[(8)] = inst_26545__$1);

return statearr_26566;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26559__$1,(8),jobs,inst_26548);
} else {
if((state_val_26560 === (3))){
var inst_26557 = (state_26559[(2)]);
var state_26559__$1 = state_26559;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26559__$1,inst_26557);
} else {
if((state_val_26560 === (2))){
var state_26559__$1 = state_26559;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26559__$1,(4),from);
} else {
if((state_val_26560 === (9))){
var inst_26552 = (state_26559[(2)]);
var state_26559__$1 = (function (){var statearr_26567 = state_26559;
(statearr_26567[(9)] = inst_26552);

return statearr_26567;
})();
var statearr_26568_26679 = state_26559__$1;
(statearr_26568_26679[(2)] = null);

(statearr_26568_26679[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26560 === (5))){
var inst_26543 = cljs.core.async.close_BANG_(jobs);
var state_26559__$1 = state_26559;
var statearr_26569_26680 = state_26559__$1;
(statearr_26569_26680[(2)] = inst_26543);

(statearr_26569_26680[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26560 === (8))){
var inst_26545 = (state_26559[(8)]);
var inst_26550 = (state_26559[(2)]);
var state_26559__$1 = (function (){var statearr_26570 = state_26559;
(statearr_26570[(10)] = inst_26550);

return statearr_26570;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26559__$1,(9),results,inst_26545);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_26571 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26571[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__);

(statearr_26571[(1)] = (1));

return statearr_26571;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1 = (function (state_26559){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26559);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26572){var ex__24301__auto__ = e26572;
var statearr_26573_26681 = state_26559;
(statearr_26573_26681[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26559[(4)]))){
var statearr_26574_26682 = state_26559;
(statearr_26574_26682[(1)] = cljs.core.first((state_26559[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26683 = state_26559;
state_26559 = G__26683;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = function(state_26559){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1.call(this,state_26559);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26575 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26575[(6)] = c__24424__auto___26674);

return statearr_26575;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26613){
var state_val_26614 = (state_26613[(1)]);
if((state_val_26614 === (7))){
var inst_26609 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
var statearr_26615_26684 = state_26613__$1;
(statearr_26615_26684[(2)] = inst_26609);

(statearr_26615_26684[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (20))){
var state_26613__$1 = state_26613;
var statearr_26616_26685 = state_26613__$1;
(statearr_26616_26685[(2)] = null);

(statearr_26616_26685[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (1))){
var state_26613__$1 = state_26613;
var statearr_26617_26686 = state_26613__$1;
(statearr_26617_26686[(2)] = null);

(statearr_26617_26686[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (4))){
var inst_26578 = (state_26613[(7)]);
var inst_26578__$1 = (state_26613[(2)]);
var inst_26579 = (inst_26578__$1 == null);
var state_26613__$1 = (function (){var statearr_26618 = state_26613;
(statearr_26618[(7)] = inst_26578__$1);

return statearr_26618;
})();
if(cljs.core.truth_(inst_26579)){
var statearr_26619_26687 = state_26613__$1;
(statearr_26619_26687[(1)] = (5));

} else {
var statearr_26620_26688 = state_26613__$1;
(statearr_26620_26688[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (15))){
var inst_26591 = (state_26613[(8)]);
var state_26613__$1 = state_26613;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26613__$1,(18),to,inst_26591);
} else {
if((state_val_26614 === (21))){
var inst_26604 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
var statearr_26621_26689 = state_26613__$1;
(statearr_26621_26689[(2)] = inst_26604);

(statearr_26621_26689[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (13))){
var inst_26606 = (state_26613[(2)]);
var state_26613__$1 = (function (){var statearr_26622 = state_26613;
(statearr_26622[(9)] = inst_26606);

return statearr_26622;
})();
var statearr_26623_26690 = state_26613__$1;
(statearr_26623_26690[(2)] = null);

(statearr_26623_26690[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (6))){
var inst_26578 = (state_26613[(7)]);
var state_26613__$1 = state_26613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26613__$1,(11),inst_26578);
} else {
if((state_val_26614 === (17))){
var inst_26599 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
if(cljs.core.truth_(inst_26599)){
var statearr_26624_26691 = state_26613__$1;
(statearr_26624_26691[(1)] = (19));

} else {
var statearr_26625_26692 = state_26613__$1;
(statearr_26625_26692[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (3))){
var inst_26611 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26613__$1,inst_26611);
} else {
if((state_val_26614 === (12))){
var inst_26588 = (state_26613[(10)]);
var state_26613__$1 = state_26613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26613__$1,(14),inst_26588);
} else {
if((state_val_26614 === (2))){
var state_26613__$1 = state_26613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26613__$1,(4),results);
} else {
if((state_val_26614 === (19))){
var state_26613__$1 = state_26613;
var statearr_26626_26693 = state_26613__$1;
(statearr_26626_26693[(2)] = null);

(statearr_26626_26693[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (11))){
var inst_26588 = (state_26613[(2)]);
var state_26613__$1 = (function (){var statearr_26627 = state_26613;
(statearr_26627[(10)] = inst_26588);

return statearr_26627;
})();
var statearr_26628_26694 = state_26613__$1;
(statearr_26628_26694[(2)] = null);

(statearr_26628_26694[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (9))){
var state_26613__$1 = state_26613;
var statearr_26629_26695 = state_26613__$1;
(statearr_26629_26695[(2)] = null);

(statearr_26629_26695[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (5))){
var state_26613__$1 = state_26613;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26630_26696 = state_26613__$1;
(statearr_26630_26696[(1)] = (8));

} else {
var statearr_26631_26697 = state_26613__$1;
(statearr_26631_26697[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (14))){
var inst_26593 = (state_26613[(11)]);
var inst_26591 = (state_26613[(8)]);
var inst_26591__$1 = (state_26613[(2)]);
var inst_26592 = (inst_26591__$1 == null);
var inst_26593__$1 = cljs.core.not(inst_26592);
var state_26613__$1 = (function (){var statearr_26632 = state_26613;
(statearr_26632[(11)] = inst_26593__$1);

(statearr_26632[(8)] = inst_26591__$1);

return statearr_26632;
})();
if(inst_26593__$1){
var statearr_26633_26698 = state_26613__$1;
(statearr_26633_26698[(1)] = (15));

} else {
var statearr_26634_26699 = state_26613__$1;
(statearr_26634_26699[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (16))){
var inst_26593 = (state_26613[(11)]);
var state_26613__$1 = state_26613;
var statearr_26635_26700 = state_26613__$1;
(statearr_26635_26700[(2)] = inst_26593);

(statearr_26635_26700[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (10))){
var inst_26585 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
var statearr_26636_26701 = state_26613__$1;
(statearr_26636_26701[(2)] = inst_26585);

(statearr_26636_26701[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (18))){
var inst_26596 = (state_26613[(2)]);
var state_26613__$1 = state_26613;
var statearr_26637_26702 = state_26613__$1;
(statearr_26637_26702[(2)] = inst_26596);

(statearr_26637_26702[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26614 === (8))){
var inst_26582 = cljs.core.async.close_BANG_(to);
var state_26613__$1 = state_26613;
var statearr_26638_26703 = state_26613__$1;
(statearr_26638_26703[(2)] = inst_26582);

(statearr_26638_26703[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_26639 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26639[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__);

(statearr_26639[(1)] = (1));

return statearr_26639;
});
var cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1 = (function (state_26613){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26613);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26640){var ex__24301__auto__ = e26640;
var statearr_26641_26704 = state_26613;
(statearr_26641_26704[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26613[(4)]))){
var statearr_26642_26705 = state_26613;
(statearr_26642_26705[(1)] = cljs.core.first((state_26613[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26706 = state_26613;
state_26613 = G__26706;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__ = function(state_26613){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1.call(this,state_26613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26643 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26643[(6)] = c__24424__auto__);

return statearr_26643;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). af must close!
 *   the channel before returning.  The presumption is that af will
 *   return immediately, having launched some asynchronous operation
 *   whose completion/callback will manipulate the result channel. Outputs
 *   will be returned in order relative to  the inputs. By default, the to
 *   channel will be closed when the from channel closes, but can be
 *   determined by the close?  parameter. Will stop consuming the from
 *   channel if the to channel closes.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__26708 = arguments.length;
switch (G__26708) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,cljs.core.cst$kw$async);
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__26711 = arguments.length;
switch (G__26711) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,cljs.core.cst$kw$compute);
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__26714 = arguments.length;
switch (G__26714) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__24424__auto___26764 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26740){
var state_val_26741 = (state_26740[(1)]);
if((state_val_26741 === (7))){
var inst_26736 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26742_26765 = state_26740__$1;
(statearr_26742_26765[(2)] = inst_26736);

(statearr_26742_26765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (1))){
var state_26740__$1 = state_26740;
var statearr_26743_26766 = state_26740__$1;
(statearr_26743_26766[(2)] = null);

(statearr_26743_26766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (4))){
var inst_26717 = (state_26740[(7)]);
var inst_26717__$1 = (state_26740[(2)]);
var inst_26718 = (inst_26717__$1 == null);
var state_26740__$1 = (function (){var statearr_26744 = state_26740;
(statearr_26744[(7)] = inst_26717__$1);

return statearr_26744;
})();
if(cljs.core.truth_(inst_26718)){
var statearr_26745_26767 = state_26740__$1;
(statearr_26745_26767[(1)] = (5));

} else {
var statearr_26746_26768 = state_26740__$1;
(statearr_26746_26768[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (13))){
var state_26740__$1 = state_26740;
var statearr_26747_26769 = state_26740__$1;
(statearr_26747_26769[(2)] = null);

(statearr_26747_26769[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (6))){
var inst_26717 = (state_26740[(7)]);
var inst_26723 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_26717) : p.call(null,inst_26717));
var state_26740__$1 = state_26740;
if(cljs.core.truth_(inst_26723)){
var statearr_26748_26770 = state_26740__$1;
(statearr_26748_26770[(1)] = (9));

} else {
var statearr_26749_26771 = state_26740__$1;
(statearr_26749_26771[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (3))){
var inst_26738 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26740__$1,inst_26738);
} else {
if((state_val_26741 === (12))){
var state_26740__$1 = state_26740;
var statearr_26750_26772 = state_26740__$1;
(statearr_26750_26772[(2)] = null);

(statearr_26750_26772[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (2))){
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26740__$1,(4),ch);
} else {
if((state_val_26741 === (11))){
var inst_26717 = (state_26740[(7)]);
var inst_26727 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26740__$1,(8),inst_26727,inst_26717);
} else {
if((state_val_26741 === (9))){
var state_26740__$1 = state_26740;
var statearr_26751_26773 = state_26740__$1;
(statearr_26751_26773[(2)] = tc);

(statearr_26751_26773[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (5))){
var inst_26720 = cljs.core.async.close_BANG_(tc);
var inst_26721 = cljs.core.async.close_BANG_(fc);
var state_26740__$1 = (function (){var statearr_26752 = state_26740;
(statearr_26752[(8)] = inst_26720);

return statearr_26752;
})();
var statearr_26753_26774 = state_26740__$1;
(statearr_26753_26774[(2)] = inst_26721);

(statearr_26753_26774[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (14))){
var inst_26734 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
var statearr_26754_26775 = state_26740__$1;
(statearr_26754_26775[(2)] = inst_26734);

(statearr_26754_26775[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (10))){
var state_26740__$1 = state_26740;
var statearr_26755_26776 = state_26740__$1;
(statearr_26755_26776[(2)] = fc);

(statearr_26755_26776[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26741 === (8))){
var inst_26729 = (state_26740[(2)]);
var state_26740__$1 = state_26740;
if(cljs.core.truth_(inst_26729)){
var statearr_26756_26777 = state_26740__$1;
(statearr_26756_26777[(1)] = (12));

} else {
var statearr_26757_26778 = state_26740__$1;
(statearr_26757_26778[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_26758 = [null,null,null,null,null,null,null,null,null];
(statearr_26758[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_26758[(1)] = (1));

return statearr_26758;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_26740){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26740);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26759){var ex__24301__auto__ = e26759;
var statearr_26760_26779 = state_26740;
(statearr_26760_26779[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26740[(4)]))){
var statearr_26761_26780 = state_26740;
(statearr_26761_26780[(1)] = cljs.core.first((state_26740[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26781 = state_26740;
state_26740 = G__26781;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_26740){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_26740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26762 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26762[(6)] = c__24424__auto___26764);

return statearr_26762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26803){
var state_val_26804 = (state_26803[(1)]);
if((state_val_26804 === (7))){
var inst_26799 = (state_26803[(2)]);
var state_26803__$1 = state_26803;
var statearr_26805_26824 = state_26803__$1;
(statearr_26805_26824[(2)] = inst_26799);

(statearr_26805_26824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (1))){
var inst_26782 = init;
var inst_26783 = inst_26782;
var state_26803__$1 = (function (){var statearr_26806 = state_26803;
(statearr_26806[(7)] = inst_26783);

return statearr_26806;
})();
var statearr_26807_26825 = state_26803__$1;
(statearr_26807_26825[(2)] = null);

(statearr_26807_26825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (4))){
var inst_26786 = (state_26803[(8)]);
var inst_26786__$1 = (state_26803[(2)]);
var inst_26787 = (inst_26786__$1 == null);
var state_26803__$1 = (function (){var statearr_26808 = state_26803;
(statearr_26808[(8)] = inst_26786__$1);

return statearr_26808;
})();
if(cljs.core.truth_(inst_26787)){
var statearr_26809_26826 = state_26803__$1;
(statearr_26809_26826[(1)] = (5));

} else {
var statearr_26810_26827 = state_26803__$1;
(statearr_26810_26827[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (6))){
var inst_26783 = (state_26803[(7)]);
var inst_26790 = (state_26803[(9)]);
var inst_26786 = (state_26803[(8)]);
var inst_26790__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_26783,inst_26786) : f.call(null,inst_26783,inst_26786));
var inst_26791 = cljs.core.reduced_QMARK_(inst_26790__$1);
var state_26803__$1 = (function (){var statearr_26811 = state_26803;
(statearr_26811[(9)] = inst_26790__$1);

return statearr_26811;
})();
if(inst_26791){
var statearr_26812_26828 = state_26803__$1;
(statearr_26812_26828[(1)] = (8));

} else {
var statearr_26813_26829 = state_26803__$1;
(statearr_26813_26829[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (3))){
var inst_26801 = (state_26803[(2)]);
var state_26803__$1 = state_26803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26803__$1,inst_26801);
} else {
if((state_val_26804 === (2))){
var state_26803__$1 = state_26803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26803__$1,(4),ch);
} else {
if((state_val_26804 === (9))){
var inst_26790 = (state_26803[(9)]);
var inst_26783 = inst_26790;
var state_26803__$1 = (function (){var statearr_26814 = state_26803;
(statearr_26814[(7)] = inst_26783);

return statearr_26814;
})();
var statearr_26815_26830 = state_26803__$1;
(statearr_26815_26830[(2)] = null);

(statearr_26815_26830[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (5))){
var inst_26783 = (state_26803[(7)]);
var state_26803__$1 = state_26803;
var statearr_26816_26831 = state_26803__$1;
(statearr_26816_26831[(2)] = inst_26783);

(statearr_26816_26831[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (10))){
var inst_26797 = (state_26803[(2)]);
var state_26803__$1 = state_26803;
var statearr_26817_26832 = state_26803__$1;
(statearr_26817_26832[(2)] = inst_26797);

(statearr_26817_26832[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26804 === (8))){
var inst_26790 = (state_26803[(9)]);
var inst_26793 = cljs.core.deref(inst_26790);
var state_26803__$1 = state_26803;
var statearr_26818_26833 = state_26803__$1;
(statearr_26818_26833[(2)] = inst_26793);

(statearr_26818_26833[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__24298__auto__ = null;
var cljs$core$async$reduce_$_state_machine__24298__auto____0 = (function (){
var statearr_26819 = [null,null,null,null,null,null,null,null,null,null];
(statearr_26819[(0)] = cljs$core$async$reduce_$_state_machine__24298__auto__);

(statearr_26819[(1)] = (1));

return statearr_26819;
});
var cljs$core$async$reduce_$_state_machine__24298__auto____1 = (function (state_26803){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26803);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26820){var ex__24301__auto__ = e26820;
var statearr_26821_26834 = state_26803;
(statearr_26821_26834[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26803[(4)]))){
var statearr_26822_26835 = state_26803;
(statearr_26822_26835[(1)] = cljs.core.first((state_26803[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26836 = state_26803;
state_26803 = G__26836;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__24298__auto__ = function(state_26803){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__24298__auto____1.call(this,state_26803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__24298__auto____0;
cljs$core$async$reduce_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__24298__auto____1;
return cljs$core$async$reduce_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26823 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26823[(6)] = c__24424__auto__);

return statearr_26823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null,f));
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26842){
var state_val_26843 = (state_26842[(1)]);
if((state_val_26843 === (1))){
var inst_26837 = cljs.core.async.reduce(f__$1,init,ch);
var state_26842__$1 = state_26842;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26842__$1,(2),inst_26837);
} else {
if((state_val_26843 === (2))){
var inst_26839 = (state_26842[(2)]);
var inst_26840 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_26839) : f__$1.call(null,inst_26839));
var state_26842__$1 = state_26842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26842__$1,inst_26840);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__24298__auto__ = null;
var cljs$core$async$transduce_$_state_machine__24298__auto____0 = (function (){
var statearr_26844 = [null,null,null,null,null,null,null];
(statearr_26844[(0)] = cljs$core$async$transduce_$_state_machine__24298__auto__);

(statearr_26844[(1)] = (1));

return statearr_26844;
});
var cljs$core$async$transduce_$_state_machine__24298__auto____1 = (function (state_26842){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26842);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26845){var ex__24301__auto__ = e26845;
var statearr_26846_26849 = state_26842;
(statearr_26846_26849[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26842[(4)]))){
var statearr_26847_26850 = state_26842;
(statearr_26847_26850[(1)] = cljs.core.first((state_26842[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26851 = state_26842;
state_26842 = G__26851;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__24298__auto__ = function(state_26842){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__24298__auto____1.call(this,state_26842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__24298__auto____0;
cljs$core$async$transduce_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__24298__auto____1;
return cljs$core$async$transduce_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26848 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26848[(6)] = c__24424__auto__);

return statearr_26848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__26853 = arguments.length;
switch (G__26853) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_26878){
var state_val_26879 = (state_26878[(1)]);
if((state_val_26879 === (7))){
var inst_26860 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
var statearr_26880_26902 = state_26878__$1;
(statearr_26880_26902[(2)] = inst_26860);

(statearr_26880_26902[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (1))){
var inst_26854 = cljs.core.seq(coll);
var inst_26855 = inst_26854;
var state_26878__$1 = (function (){var statearr_26881 = state_26878;
(statearr_26881[(7)] = inst_26855);

return statearr_26881;
})();
var statearr_26882_26903 = state_26878__$1;
(statearr_26882_26903[(2)] = null);

(statearr_26882_26903[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (4))){
var inst_26855 = (state_26878[(7)]);
var inst_26858 = cljs.core.first(inst_26855);
var state_26878__$1 = state_26878;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_26878__$1,(7),ch,inst_26858);
} else {
if((state_val_26879 === (13))){
var inst_26872 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
var statearr_26883_26904 = state_26878__$1;
(statearr_26883_26904[(2)] = inst_26872);

(statearr_26883_26904[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (6))){
var inst_26863 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
if(cljs.core.truth_(inst_26863)){
var statearr_26884_26905 = state_26878__$1;
(statearr_26884_26905[(1)] = (8));

} else {
var statearr_26885_26906 = state_26878__$1;
(statearr_26885_26906[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (3))){
var inst_26876 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26878__$1,inst_26876);
} else {
if((state_val_26879 === (12))){
var state_26878__$1 = state_26878;
var statearr_26886_26907 = state_26878__$1;
(statearr_26886_26907[(2)] = null);

(statearr_26886_26907[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (2))){
var inst_26855 = (state_26878[(7)]);
var state_26878__$1 = state_26878;
if(cljs.core.truth_(inst_26855)){
var statearr_26887_26908 = state_26878__$1;
(statearr_26887_26908[(1)] = (4));

} else {
var statearr_26888_26909 = state_26878__$1;
(statearr_26888_26909[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (11))){
var inst_26869 = cljs.core.async.close_BANG_(ch);
var state_26878__$1 = state_26878;
var statearr_26889_26910 = state_26878__$1;
(statearr_26889_26910[(2)] = inst_26869);

(statearr_26889_26910[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (9))){
var state_26878__$1 = state_26878;
if(cljs.core.truth_(close_QMARK_)){
var statearr_26890_26911 = state_26878__$1;
(statearr_26890_26911[(1)] = (11));

} else {
var statearr_26891_26912 = state_26878__$1;
(statearr_26891_26912[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (5))){
var inst_26855 = (state_26878[(7)]);
var state_26878__$1 = state_26878;
var statearr_26892_26913 = state_26878__$1;
(statearr_26892_26913[(2)] = inst_26855);

(statearr_26892_26913[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (10))){
var inst_26874 = (state_26878[(2)]);
var state_26878__$1 = state_26878;
var statearr_26893_26914 = state_26878__$1;
(statearr_26893_26914[(2)] = inst_26874);

(statearr_26893_26914[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26879 === (8))){
var inst_26855 = (state_26878[(7)]);
var inst_26865 = cljs.core.next(inst_26855);
var inst_26855__$1 = inst_26865;
var state_26878__$1 = (function (){var statearr_26894 = state_26878;
(statearr_26894[(7)] = inst_26855__$1);

return statearr_26894;
})();
var statearr_26895_26915 = state_26878__$1;
(statearr_26895_26915[(2)] = null);

(statearr_26895_26915[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_26896 = [null,null,null,null,null,null,null,null];
(statearr_26896[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_26896[(1)] = (1));

return statearr_26896;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_26878){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_26878);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e26897){var ex__24301__auto__ = e26897;
var statearr_26898_26916 = state_26878;
(statearr_26898_26916[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_26878[(4)]))){
var statearr_26899_26917 = state_26878;
(statearr_26899_26917[(1)] = cljs.core.first((state_26878[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__26918 = state_26878;
state_26878 = G__26918;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_26878){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_26878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_26900 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_26900[(6)] = c__24424__auto__);

return statearr_26900;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__26920 = arguments.length;
switch (G__26920) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_26922 = (function (_){
var x__4509__auto__ = (((_ == null))?null:_);
var m__4510__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4510__auto__.call(null,_));
} else {
var m__4508__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__4508__auto__.call(null,_));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_26922(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_26923 = (function (m,ch,close_QMARK_){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4510__auto__.call(null,m,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__4508__auto__.call(null,m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_26923(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_26924 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_26924(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_26925 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_26925(m);
}
});

/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async26926 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async26926 = (function (ch,cs,meta26927){
this.ch = ch;
this.cs = cs;
this.meta26927 = meta26927;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_26928,meta26927__$1){
var self__ = this;
var _26928__$1 = this;
return (new cljs.core.async.t_cljs$core$async26926(self__.ch,self__.cs,meta26927__$1));
}));

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_26928){
var self__ = this;
var _26928__$1 = this;
return self__.meta26927;
}));

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async26926.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async26926.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$cs,cljs.core.cst$sym$meta26927], null);
}));

(cljs.core.async.t_cljs$core$async26926.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async26926.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async26926");

(cljs.core.async.t_cljs$core$async26926.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async26926");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async26926.
 */
cljs.core.async.__GT_t_cljs$core$async26926 = (function cljs$core$async$mult_$___GT_t_cljs$core$async26926(ch__$1,cs__$1,meta26927){
return (new cljs.core.async.t_cljs$core$async26926(ch__$1,cs__$1,meta26927));
});

}

return (new cljs.core.async.t_cljs$core$async26926(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__24424__auto___27145 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27061){
var state_val_27062 = (state_27061[(1)]);
if((state_val_27062 === (7))){
var inst_27057 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27063_27146 = state_27061__$1;
(statearr_27063_27146[(2)] = inst_27057);

(statearr_27063_27146[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (20))){
var inst_26962 = (state_27061[(7)]);
var inst_26974 = cljs.core.first(inst_26962);
var inst_26975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26974,(0),null);
var inst_26976 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26974,(1),null);
var state_27061__$1 = (function (){var statearr_27064 = state_27061;
(statearr_27064[(8)] = inst_26975);

return statearr_27064;
})();
if(cljs.core.truth_(inst_26976)){
var statearr_27065_27147 = state_27061__$1;
(statearr_27065_27147[(1)] = (22));

} else {
var statearr_27066_27148 = state_27061__$1;
(statearr_27066_27148[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (27))){
var inst_26931 = (state_27061[(9)]);
var inst_27006 = (state_27061[(10)]);
var inst_27004 = (state_27061[(11)]);
var inst_27011 = (state_27061[(12)]);
var inst_27011__$1 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_27004,inst_27006);
var inst_27012 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_27011__$1,inst_26931,done);
var state_27061__$1 = (function (){var statearr_27067 = state_27061;
(statearr_27067[(12)] = inst_27011__$1);

return statearr_27067;
})();
if(cljs.core.truth_(inst_27012)){
var statearr_27068_27149 = state_27061__$1;
(statearr_27068_27149[(1)] = (30));

} else {
var statearr_27069_27150 = state_27061__$1;
(statearr_27069_27150[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (1))){
var state_27061__$1 = state_27061;
var statearr_27070_27151 = state_27061__$1;
(statearr_27070_27151[(2)] = null);

(statearr_27070_27151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (24))){
var inst_26962 = (state_27061[(7)]);
var inst_26981 = (state_27061[(2)]);
var inst_26982 = cljs.core.next(inst_26962);
var inst_26940 = inst_26982;
var inst_26941 = null;
var inst_26942 = (0);
var inst_26943 = (0);
var state_27061__$1 = (function (){var statearr_27071 = state_27061;
(statearr_27071[(13)] = inst_26942);

(statearr_27071[(14)] = inst_26943);

(statearr_27071[(15)] = inst_26940);

(statearr_27071[(16)] = inst_26941);

(statearr_27071[(17)] = inst_26981);

return statearr_27071;
})();
var statearr_27072_27152 = state_27061__$1;
(statearr_27072_27152[(2)] = null);

(statearr_27072_27152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (39))){
var state_27061__$1 = state_27061;
var statearr_27076_27153 = state_27061__$1;
(statearr_27076_27153[(2)] = null);

(statearr_27076_27153[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (4))){
var inst_26931 = (state_27061[(9)]);
var inst_26931__$1 = (state_27061[(2)]);
var inst_26932 = (inst_26931__$1 == null);
var state_27061__$1 = (function (){var statearr_27077 = state_27061;
(statearr_27077[(9)] = inst_26931__$1);

return statearr_27077;
})();
if(cljs.core.truth_(inst_26932)){
var statearr_27078_27154 = state_27061__$1;
(statearr_27078_27154[(1)] = (5));

} else {
var statearr_27079_27155 = state_27061__$1;
(statearr_27079_27155[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (15))){
var inst_26942 = (state_27061[(13)]);
var inst_26943 = (state_27061[(14)]);
var inst_26940 = (state_27061[(15)]);
var inst_26941 = (state_27061[(16)]);
var inst_26958 = (state_27061[(2)]);
var inst_26959 = (inst_26943 + (1));
var tmp27073 = inst_26942;
var tmp27074 = inst_26940;
var tmp27075 = inst_26941;
var inst_26940__$1 = tmp27074;
var inst_26941__$1 = tmp27075;
var inst_26942__$1 = tmp27073;
var inst_26943__$1 = inst_26959;
var state_27061__$1 = (function (){var statearr_27080 = state_27061;
(statearr_27080[(13)] = inst_26942__$1);

(statearr_27080[(14)] = inst_26943__$1);

(statearr_27080[(15)] = inst_26940__$1);

(statearr_27080[(18)] = inst_26958);

(statearr_27080[(16)] = inst_26941__$1);

return statearr_27080;
})();
var statearr_27081_27156 = state_27061__$1;
(statearr_27081_27156[(2)] = null);

(statearr_27081_27156[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (21))){
var inst_26985 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27085_27157 = state_27061__$1;
(statearr_27085_27157[(2)] = inst_26985);

(statearr_27085_27157[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (31))){
var inst_27011 = (state_27061[(12)]);
var inst_27015 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_27011);
var state_27061__$1 = state_27061;
var statearr_27086_27158 = state_27061__$1;
(statearr_27086_27158[(2)] = inst_27015);

(statearr_27086_27158[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (32))){
var inst_27006 = (state_27061[(10)]);
var inst_27004 = (state_27061[(11)]);
var inst_27005 = (state_27061[(19)]);
var inst_27003 = (state_27061[(20)]);
var inst_27017 = (state_27061[(2)]);
var inst_27018 = (inst_27006 + (1));
var tmp27082 = inst_27004;
var tmp27083 = inst_27005;
var tmp27084 = inst_27003;
var inst_27003__$1 = tmp27084;
var inst_27004__$1 = tmp27082;
var inst_27005__$1 = tmp27083;
var inst_27006__$1 = inst_27018;
var state_27061__$1 = (function (){var statearr_27087 = state_27061;
(statearr_27087[(10)] = inst_27006__$1);

(statearr_27087[(11)] = inst_27004__$1);

(statearr_27087[(19)] = inst_27005__$1);

(statearr_27087[(20)] = inst_27003__$1);

(statearr_27087[(21)] = inst_27017);

return statearr_27087;
})();
var statearr_27088_27159 = state_27061__$1;
(statearr_27088_27159[(2)] = null);

(statearr_27088_27159[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (40))){
var inst_27030 = (state_27061[(22)]);
var inst_27034 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null,inst_27030);
var state_27061__$1 = state_27061;
var statearr_27089_27160 = state_27061__$1;
(statearr_27089_27160[(2)] = inst_27034);

(statearr_27089_27160[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (33))){
var inst_27021 = (state_27061[(23)]);
var inst_27023 = cljs.core.chunked_seq_QMARK_(inst_27021);
var state_27061__$1 = state_27061;
if(inst_27023){
var statearr_27090_27161 = state_27061__$1;
(statearr_27090_27161[(1)] = (36));

} else {
var statearr_27091_27162 = state_27061__$1;
(statearr_27091_27162[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (13))){
var inst_26952 = (state_27061[(24)]);
var inst_26955 = cljs.core.async.close_BANG_(inst_26952);
var state_27061__$1 = state_27061;
var statearr_27092_27163 = state_27061__$1;
(statearr_27092_27163[(2)] = inst_26955);

(statearr_27092_27163[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (22))){
var inst_26975 = (state_27061[(8)]);
var inst_26978 = cljs.core.async.close_BANG_(inst_26975);
var state_27061__$1 = state_27061;
var statearr_27093_27164 = state_27061__$1;
(statearr_27093_27164[(2)] = inst_26978);

(statearr_27093_27164[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (36))){
var inst_27021 = (state_27061[(23)]);
var inst_27025 = cljs.core.chunk_first(inst_27021);
var inst_27026 = cljs.core.chunk_rest(inst_27021);
var inst_27027 = cljs.core.count(inst_27025);
var inst_27003 = inst_27026;
var inst_27004 = inst_27025;
var inst_27005 = inst_27027;
var inst_27006 = (0);
var state_27061__$1 = (function (){var statearr_27094 = state_27061;
(statearr_27094[(10)] = inst_27006);

(statearr_27094[(11)] = inst_27004);

(statearr_27094[(19)] = inst_27005);

(statearr_27094[(20)] = inst_27003);

return statearr_27094;
})();
var statearr_27095_27165 = state_27061__$1;
(statearr_27095_27165[(2)] = null);

(statearr_27095_27165[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (41))){
var inst_27021 = (state_27061[(23)]);
var inst_27036 = (state_27061[(2)]);
var inst_27037 = cljs.core.next(inst_27021);
var inst_27003 = inst_27037;
var inst_27004 = null;
var inst_27005 = (0);
var inst_27006 = (0);
var state_27061__$1 = (function (){var statearr_27096 = state_27061;
(statearr_27096[(10)] = inst_27006);

(statearr_27096[(11)] = inst_27004);

(statearr_27096[(19)] = inst_27005);

(statearr_27096[(20)] = inst_27003);

(statearr_27096[(25)] = inst_27036);

return statearr_27096;
})();
var statearr_27097_27166 = state_27061__$1;
(statearr_27097_27166[(2)] = null);

(statearr_27097_27166[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (43))){
var state_27061__$1 = state_27061;
var statearr_27098_27167 = state_27061__$1;
(statearr_27098_27167[(2)] = null);

(statearr_27098_27167[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (29))){
var inst_27045 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27099_27168 = state_27061__$1;
(statearr_27099_27168[(2)] = inst_27045);

(statearr_27099_27168[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (44))){
var inst_27054 = (state_27061[(2)]);
var state_27061__$1 = (function (){var statearr_27100 = state_27061;
(statearr_27100[(26)] = inst_27054);

return statearr_27100;
})();
var statearr_27101_27169 = state_27061__$1;
(statearr_27101_27169[(2)] = null);

(statearr_27101_27169[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (6))){
var inst_26995 = (state_27061[(27)]);
var inst_26994 = cljs.core.deref(cs);
var inst_26995__$1 = cljs.core.keys(inst_26994);
var inst_26996 = cljs.core.count(inst_26995__$1);
var inst_26997 = cljs.core.reset_BANG_(dctr,inst_26996);
var inst_27002 = cljs.core.seq(inst_26995__$1);
var inst_27003 = inst_27002;
var inst_27004 = null;
var inst_27005 = (0);
var inst_27006 = (0);
var state_27061__$1 = (function (){var statearr_27102 = state_27061;
(statearr_27102[(10)] = inst_27006);

(statearr_27102[(28)] = inst_26997);

(statearr_27102[(11)] = inst_27004);

(statearr_27102[(19)] = inst_27005);

(statearr_27102[(20)] = inst_27003);

(statearr_27102[(27)] = inst_26995__$1);

return statearr_27102;
})();
var statearr_27103_27170 = state_27061__$1;
(statearr_27103_27170[(2)] = null);

(statearr_27103_27170[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (28))){
var inst_27021 = (state_27061[(23)]);
var inst_27003 = (state_27061[(20)]);
var inst_27021__$1 = cljs.core.seq(inst_27003);
var state_27061__$1 = (function (){var statearr_27104 = state_27061;
(statearr_27104[(23)] = inst_27021__$1);

return statearr_27104;
})();
if(inst_27021__$1){
var statearr_27105_27171 = state_27061__$1;
(statearr_27105_27171[(1)] = (33));

} else {
var statearr_27106_27172 = state_27061__$1;
(statearr_27106_27172[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (25))){
var inst_27006 = (state_27061[(10)]);
var inst_27005 = (state_27061[(19)]);
var inst_27008 = (inst_27006 < inst_27005);
var inst_27009 = inst_27008;
var state_27061__$1 = state_27061;
if(cljs.core.truth_(inst_27009)){
var statearr_27107_27173 = state_27061__$1;
(statearr_27107_27173[(1)] = (27));

} else {
var statearr_27108_27174 = state_27061__$1;
(statearr_27108_27174[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (34))){
var state_27061__$1 = state_27061;
var statearr_27109_27175 = state_27061__$1;
(statearr_27109_27175[(2)] = null);

(statearr_27109_27175[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (17))){
var state_27061__$1 = state_27061;
var statearr_27110_27176 = state_27061__$1;
(statearr_27110_27176[(2)] = null);

(statearr_27110_27176[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (3))){
var inst_27059 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27061__$1,inst_27059);
} else {
if((state_val_27062 === (12))){
var inst_26990 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27111_27177 = state_27061__$1;
(statearr_27111_27177[(2)] = inst_26990);

(statearr_27111_27177[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (2))){
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27061__$1,(4),ch);
} else {
if((state_val_27062 === (23))){
var state_27061__$1 = state_27061;
var statearr_27112_27178 = state_27061__$1;
(statearr_27112_27178[(2)] = null);

(statearr_27112_27178[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (35))){
var inst_27043 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27113_27179 = state_27061__$1;
(statearr_27113_27179[(2)] = inst_27043);

(statearr_27113_27179[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (19))){
var inst_26962 = (state_27061[(7)]);
var inst_26966 = cljs.core.chunk_first(inst_26962);
var inst_26967 = cljs.core.chunk_rest(inst_26962);
var inst_26968 = cljs.core.count(inst_26966);
var inst_26940 = inst_26967;
var inst_26941 = inst_26966;
var inst_26942 = inst_26968;
var inst_26943 = (0);
var state_27061__$1 = (function (){var statearr_27114 = state_27061;
(statearr_27114[(13)] = inst_26942);

(statearr_27114[(14)] = inst_26943);

(statearr_27114[(15)] = inst_26940);

(statearr_27114[(16)] = inst_26941);

return statearr_27114;
})();
var statearr_27115_27180 = state_27061__$1;
(statearr_27115_27180[(2)] = null);

(statearr_27115_27180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (11))){
var inst_26940 = (state_27061[(15)]);
var inst_26962 = (state_27061[(7)]);
var inst_26962__$1 = cljs.core.seq(inst_26940);
var state_27061__$1 = (function (){var statearr_27116 = state_27061;
(statearr_27116[(7)] = inst_26962__$1);

return statearr_27116;
})();
if(inst_26962__$1){
var statearr_27117_27181 = state_27061__$1;
(statearr_27117_27181[(1)] = (16));

} else {
var statearr_27118_27182 = state_27061__$1;
(statearr_27118_27182[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (9))){
var inst_26992 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27119_27183 = state_27061__$1;
(statearr_27119_27183[(2)] = inst_26992);

(statearr_27119_27183[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (5))){
var inst_26938 = cljs.core.deref(cs);
var inst_26939 = cljs.core.seq(inst_26938);
var inst_26940 = inst_26939;
var inst_26941 = null;
var inst_26942 = (0);
var inst_26943 = (0);
var state_27061__$1 = (function (){var statearr_27120 = state_27061;
(statearr_27120[(13)] = inst_26942);

(statearr_27120[(14)] = inst_26943);

(statearr_27120[(15)] = inst_26940);

(statearr_27120[(16)] = inst_26941);

return statearr_27120;
})();
var statearr_27121_27184 = state_27061__$1;
(statearr_27121_27184[(2)] = null);

(statearr_27121_27184[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (14))){
var state_27061__$1 = state_27061;
var statearr_27122_27185 = state_27061__$1;
(statearr_27122_27185[(2)] = null);

(statearr_27122_27185[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (45))){
var inst_27051 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27123_27186 = state_27061__$1;
(statearr_27123_27186[(2)] = inst_27051);

(statearr_27123_27186[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (26))){
var inst_26995 = (state_27061[(27)]);
var inst_27047 = (state_27061[(2)]);
var inst_27048 = cljs.core.seq(inst_26995);
var state_27061__$1 = (function (){var statearr_27124 = state_27061;
(statearr_27124[(29)] = inst_27047);

return statearr_27124;
})();
if(inst_27048){
var statearr_27125_27187 = state_27061__$1;
(statearr_27125_27187[(1)] = (42));

} else {
var statearr_27126_27188 = state_27061__$1;
(statearr_27126_27188[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (16))){
var inst_26962 = (state_27061[(7)]);
var inst_26964 = cljs.core.chunked_seq_QMARK_(inst_26962);
var state_27061__$1 = state_27061;
if(inst_26964){
var statearr_27127_27189 = state_27061__$1;
(statearr_27127_27189[(1)] = (19));

} else {
var statearr_27128_27190 = state_27061__$1;
(statearr_27128_27190[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (38))){
var inst_27040 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27129_27191 = state_27061__$1;
(statearr_27129_27191[(2)] = inst_27040);

(statearr_27129_27191[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (30))){
var state_27061__$1 = state_27061;
var statearr_27130_27192 = state_27061__$1;
(statearr_27130_27192[(2)] = null);

(statearr_27130_27192[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (10))){
var inst_26943 = (state_27061[(14)]);
var inst_26941 = (state_27061[(16)]);
var inst_26951 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_26941,inst_26943);
var inst_26952 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26951,(0),null);
var inst_26953 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26951,(1),null);
var state_27061__$1 = (function (){var statearr_27131 = state_27061;
(statearr_27131[(24)] = inst_26952);

return statearr_27131;
})();
if(cljs.core.truth_(inst_26953)){
var statearr_27132_27193 = state_27061__$1;
(statearr_27132_27193[(1)] = (13));

} else {
var statearr_27133_27194 = state_27061__$1;
(statearr_27133_27194[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (18))){
var inst_26988 = (state_27061[(2)]);
var state_27061__$1 = state_27061;
var statearr_27134_27195 = state_27061__$1;
(statearr_27134_27195[(2)] = inst_26988);

(statearr_27134_27195[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (42))){
var state_27061__$1 = state_27061;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27061__$1,(45),dchan);
} else {
if((state_val_27062 === (37))){
var inst_26931 = (state_27061[(9)]);
var inst_27030 = (state_27061[(22)]);
var inst_27021 = (state_27061[(23)]);
var inst_27030__$1 = cljs.core.first(inst_27021);
var inst_27031 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_27030__$1,inst_26931,done);
var state_27061__$1 = (function (){var statearr_27135 = state_27061;
(statearr_27135[(22)] = inst_27030__$1);

return statearr_27135;
})();
if(cljs.core.truth_(inst_27031)){
var statearr_27136_27196 = state_27061__$1;
(statearr_27136_27196[(1)] = (39));

} else {
var statearr_27137_27197 = state_27061__$1;
(statearr_27137_27197[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27062 === (8))){
var inst_26942 = (state_27061[(13)]);
var inst_26943 = (state_27061[(14)]);
var inst_26945 = (inst_26943 < inst_26942);
var inst_26946 = inst_26945;
var state_27061__$1 = state_27061;
if(cljs.core.truth_(inst_26946)){
var statearr_27138_27198 = state_27061__$1;
(statearr_27138_27198[(1)] = (10));

} else {
var statearr_27139_27199 = state_27061__$1;
(statearr_27139_27199[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__24298__auto__ = null;
var cljs$core$async$mult_$_state_machine__24298__auto____0 = (function (){
var statearr_27140 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27140[(0)] = cljs$core$async$mult_$_state_machine__24298__auto__);

(statearr_27140[(1)] = (1));

return statearr_27140;
});
var cljs$core$async$mult_$_state_machine__24298__auto____1 = (function (state_27061){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27061);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27141){var ex__24301__auto__ = e27141;
var statearr_27142_27200 = state_27061;
(statearr_27142_27200[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27061[(4)]))){
var statearr_27143_27201 = state_27061;
(statearr_27143_27201[(1)] = cljs.core.first((state_27061[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27202 = state_27061;
state_27061 = G__27202;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__24298__auto__ = function(state_27061){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__24298__auto____1.call(this,state_27061);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__24298__auto____0;
cljs$core$async$mult_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__24298__auto____1;
return cljs$core$async$mult_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27144 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27144[(6)] = c__24424__auto___27145);

return statearr_27144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__27204 = arguments.length;
switch (G__27204) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_27206 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_27206(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_27207 = (function (m,ch){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4510__auto__.call(null,m,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__4508__auto__.call(null,m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_27207(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_27208 = (function (m){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4510__auto__.call(null,m));
} else {
var m__4508__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__4508__auto__.call(null,m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_27208(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_27209 = (function (m,state_map){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4510__auto__.call(null,m,state_map));
} else {
var m__4508__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__4508__auto__.call(null,m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_27209(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_27210 = (function (m,mode){
var x__4509__auto__ = (((m == null))?null:m);
var m__4510__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4510__auto__.call(null,m,mode));
} else {
var m__4508__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__4508__auto__.call(null,m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_27210(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___27220 = arguments.length;
var i__4819__auto___27221 = (0);
while(true){
if((i__4819__auto___27221 < len__4818__auto___27220)){
args__4824__auto__.push((arguments[i__4819__auto___27221]));

var G__27222 = (i__4819__auto___27221 + (1));
i__4819__auto___27221 = G__27222;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((3) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4825__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__27215){
var map__27216 = p__27215;
var map__27216__$1 = cljs.core.__destructure_map(map__27216);
var opts = map__27216__$1;
var statearr_27217_27223 = state;
(statearr_27217_27223[(1)] = cont_block);


var temp__5753__auto__ = cljs.core.async.do_alts((function (val){
var statearr_27218_27224 = state;
(statearr_27218_27224[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5753__auto__)){
var cb = temp__5753__auto__;
var statearr_27219_27225 = state;
(statearr_27219_27225[(2)] = cljs.core.deref(cb));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq27211){
var G__27212 = cljs.core.first(seq27211);
var seq27211__$1 = cljs.core.next(seq27211);
var G__27213 = cljs.core.first(seq27211__$1);
var seq27211__$2 = cljs.core.next(seq27211__$1);
var G__27214 = cljs.core.first(seq27211__$2);
var seq27211__$3 = cljs.core.next(seq27211__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__27212,G__27213,G__27214,seq27211__$3);
}));

/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$pause,null,cljs.core.cst$kw$mute,null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,cljs.core.cst$kw$solo);
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$mute);
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null,v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(cljs.core.cst$kw$solo,chs);
var pauses = pick(cljs.core.cst$kw$pause,chs);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$solos,solos,cljs.core.cst$kw$mutes,pick(cljs.core.cst$kw$mute,chs),cljs.core.cst$kw$reads,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,cljs.core.cst$kw$pause)) && ((!(cljs.core.empty_QMARK_(solos))))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27226 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27226 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta27227){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta27227 = meta27227;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27228,meta27227__$1){
var self__ = this;
var _27228__$1 = this;
return (new cljs.core.async.t_cljs$core$async27226(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta27227__$1));
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27228){
var self__ = this;
var _27228__$1 = this;
return self__.meta27227;
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async27226.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null,mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null));
}));

(cljs.core.async.t_cljs$core$async27226.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$change,cljs.core.cst$sym$solo_DASH_mode,cljs.core.cst$sym$pick,cljs.core.cst$sym$cs,cljs.core.cst$sym$calc_DASH_state,cljs.core.cst$sym$out,cljs.core.cst$sym$changed,cljs.core.cst$sym$solo_DASH_modes,cljs.core.cst$sym$attrs,cljs.core.cst$sym$meta27227], null);
}));

(cljs.core.async.t_cljs$core$async27226.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27226.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27226");

(cljs.core.async.t_cljs$core$async27226.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27226");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27226.
 */
cljs.core.async.__GT_t_cljs$core$async27226 = (function cljs$core$async$mix_$___GT_t_cljs$core$async27226(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta27227){
return (new cljs.core.async.t_cljs$core$async27226(change__$1,solo_mode__$1,pick__$1,cs__$1,calc_state__$1,out__$1,changed__$1,solo_modes__$1,attrs__$1,meta27227));
});

}

return (new cljs.core.async.t_cljs$core$async27226(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24424__auto___27341 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27296){
var state_val_27297 = (state_27296[(1)]);
if((state_val_27297 === (7))){
var inst_27256 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
if(cljs.core.truth_(inst_27256)){
var statearr_27298_27342 = state_27296__$1;
(statearr_27298_27342[(1)] = (8));

} else {
var statearr_27299_27343 = state_27296__$1;
(statearr_27299_27343[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (20))){
var inst_27249 = (state_27296[(7)]);
var state_27296__$1 = state_27296;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27296__$1,(23),out,inst_27249);
} else {
if((state_val_27297 === (1))){
var inst_27232 = calc_state();
var inst_27233 = cljs.core.__destructure_map(inst_27232);
var inst_27234 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27233,cljs.core.cst$kw$solos);
var inst_27235 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27233,cljs.core.cst$kw$mutes);
var inst_27236 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27233,cljs.core.cst$kw$reads);
var inst_27237 = inst_27232;
var state_27296__$1 = (function (){var statearr_27300 = state_27296;
(statearr_27300[(8)] = inst_27237);

(statearr_27300[(9)] = inst_27236);

(statearr_27300[(10)] = inst_27234);

(statearr_27300[(11)] = inst_27235);

return statearr_27300;
})();
var statearr_27301_27344 = state_27296__$1;
(statearr_27301_27344[(2)] = null);

(statearr_27301_27344[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (24))){
var inst_27240 = (state_27296[(12)]);
var inst_27237 = inst_27240;
var state_27296__$1 = (function (){var statearr_27302 = state_27296;
(statearr_27302[(8)] = inst_27237);

return statearr_27302;
})();
var statearr_27303_27345 = state_27296__$1;
(statearr_27303_27345[(2)] = null);

(statearr_27303_27345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (4))){
var inst_27249 = (state_27296[(7)]);
var inst_27251 = (state_27296[(13)]);
var inst_27248 = (state_27296[(2)]);
var inst_27249__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27248,(0),null);
var inst_27250 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27248,(1),null);
var inst_27251__$1 = (inst_27249__$1 == null);
var state_27296__$1 = (function (){var statearr_27304 = state_27296;
(statearr_27304[(7)] = inst_27249__$1);

(statearr_27304[(14)] = inst_27250);

(statearr_27304[(13)] = inst_27251__$1);

return statearr_27304;
})();
if(cljs.core.truth_(inst_27251__$1)){
var statearr_27305_27346 = state_27296__$1;
(statearr_27305_27346[(1)] = (5));

} else {
var statearr_27306_27347 = state_27296__$1;
(statearr_27306_27347[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (15))){
var inst_27270 = (state_27296[(15)]);
var inst_27241 = (state_27296[(16)]);
var inst_27270__$1 = cljs.core.empty_QMARK_(inst_27241);
var state_27296__$1 = (function (){var statearr_27307 = state_27296;
(statearr_27307[(15)] = inst_27270__$1);

return statearr_27307;
})();
if(inst_27270__$1){
var statearr_27308_27348 = state_27296__$1;
(statearr_27308_27348[(1)] = (17));

} else {
var statearr_27309_27349 = state_27296__$1;
(statearr_27309_27349[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (21))){
var inst_27240 = (state_27296[(12)]);
var inst_27237 = inst_27240;
var state_27296__$1 = (function (){var statearr_27310 = state_27296;
(statearr_27310[(8)] = inst_27237);

return statearr_27310;
})();
var statearr_27311_27350 = state_27296__$1;
(statearr_27311_27350[(2)] = null);

(statearr_27311_27350[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (13))){
var inst_27263 = (state_27296[(2)]);
var inst_27264 = calc_state();
var inst_27237 = inst_27264;
var state_27296__$1 = (function (){var statearr_27312 = state_27296;
(statearr_27312[(8)] = inst_27237);

(statearr_27312[(17)] = inst_27263);

return statearr_27312;
})();
var statearr_27313_27351 = state_27296__$1;
(statearr_27313_27351[(2)] = null);

(statearr_27313_27351[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (22))){
var inst_27290 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
var statearr_27314_27352 = state_27296__$1;
(statearr_27314_27352[(2)] = inst_27290);

(statearr_27314_27352[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (6))){
var inst_27250 = (state_27296[(14)]);
var inst_27254 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27250,change);
var state_27296__$1 = state_27296;
var statearr_27315_27353 = state_27296__$1;
(statearr_27315_27353[(2)] = inst_27254);

(statearr_27315_27353[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (25))){
var state_27296__$1 = state_27296;
var statearr_27316_27354 = state_27296__$1;
(statearr_27316_27354[(2)] = null);

(statearr_27316_27354[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (17))){
var inst_27250 = (state_27296[(14)]);
var inst_27242 = (state_27296[(18)]);
var inst_27272 = (inst_27242.cljs$core$IFn$_invoke$arity$1 ? inst_27242.cljs$core$IFn$_invoke$arity$1(inst_27250) : inst_27242.call(null,inst_27250));
var inst_27273 = cljs.core.not(inst_27272);
var state_27296__$1 = state_27296;
var statearr_27317_27355 = state_27296__$1;
(statearr_27317_27355[(2)] = inst_27273);

(statearr_27317_27355[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (3))){
var inst_27294 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27296__$1,inst_27294);
} else {
if((state_val_27297 === (12))){
var state_27296__$1 = state_27296;
var statearr_27318_27356 = state_27296__$1;
(statearr_27318_27356[(2)] = null);

(statearr_27318_27356[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (2))){
var inst_27237 = (state_27296[(8)]);
var inst_27240 = (state_27296[(12)]);
var inst_27240__$1 = cljs.core.__destructure_map(inst_27237);
var inst_27241 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27240__$1,cljs.core.cst$kw$solos);
var inst_27242 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27240__$1,cljs.core.cst$kw$mutes);
var inst_27243 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27240__$1,cljs.core.cst$kw$reads);
var state_27296__$1 = (function (){var statearr_27319 = state_27296;
(statearr_27319[(16)] = inst_27241);

(statearr_27319[(18)] = inst_27242);

(statearr_27319[(12)] = inst_27240__$1);

return statearr_27319;
})();
return cljs.core.async.ioc_alts_BANG_(state_27296__$1,(4),inst_27243);
} else {
if((state_val_27297 === (23))){
var inst_27281 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
if(cljs.core.truth_(inst_27281)){
var statearr_27320_27357 = state_27296__$1;
(statearr_27320_27357[(1)] = (24));

} else {
var statearr_27321_27358 = state_27296__$1;
(statearr_27321_27358[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (19))){
var inst_27276 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
var statearr_27322_27359 = state_27296__$1;
(statearr_27322_27359[(2)] = inst_27276);

(statearr_27322_27359[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (11))){
var inst_27250 = (state_27296[(14)]);
var inst_27260 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_27250);
var state_27296__$1 = state_27296;
var statearr_27323_27360 = state_27296__$1;
(statearr_27323_27360[(2)] = inst_27260);

(statearr_27323_27360[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (9))){
var inst_27241 = (state_27296[(16)]);
var inst_27250 = (state_27296[(14)]);
var inst_27267 = (state_27296[(19)]);
var inst_27267__$1 = (inst_27241.cljs$core$IFn$_invoke$arity$1 ? inst_27241.cljs$core$IFn$_invoke$arity$1(inst_27250) : inst_27241.call(null,inst_27250));
var state_27296__$1 = (function (){var statearr_27324 = state_27296;
(statearr_27324[(19)] = inst_27267__$1);

return statearr_27324;
})();
if(cljs.core.truth_(inst_27267__$1)){
var statearr_27325_27361 = state_27296__$1;
(statearr_27325_27361[(1)] = (14));

} else {
var statearr_27326_27362 = state_27296__$1;
(statearr_27326_27362[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (5))){
var inst_27251 = (state_27296[(13)]);
var state_27296__$1 = state_27296;
var statearr_27327_27363 = state_27296__$1;
(statearr_27327_27363[(2)] = inst_27251);

(statearr_27327_27363[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (14))){
var inst_27267 = (state_27296[(19)]);
var state_27296__$1 = state_27296;
var statearr_27328_27364 = state_27296__$1;
(statearr_27328_27364[(2)] = inst_27267);

(statearr_27328_27364[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (26))){
var inst_27286 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
var statearr_27329_27365 = state_27296__$1;
(statearr_27329_27365[(2)] = inst_27286);

(statearr_27329_27365[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (16))){
var inst_27278 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
if(cljs.core.truth_(inst_27278)){
var statearr_27330_27366 = state_27296__$1;
(statearr_27330_27366[(1)] = (20));

} else {
var statearr_27331_27367 = state_27296__$1;
(statearr_27331_27367[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (10))){
var inst_27292 = (state_27296[(2)]);
var state_27296__$1 = state_27296;
var statearr_27332_27368 = state_27296__$1;
(statearr_27332_27368[(2)] = inst_27292);

(statearr_27332_27368[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (18))){
var inst_27270 = (state_27296[(15)]);
var state_27296__$1 = state_27296;
var statearr_27333_27369 = state_27296__$1;
(statearr_27333_27369[(2)] = inst_27270);

(statearr_27333_27369[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27297 === (8))){
var inst_27249 = (state_27296[(7)]);
var inst_27258 = (inst_27249 == null);
var state_27296__$1 = state_27296;
if(cljs.core.truth_(inst_27258)){
var statearr_27334_27370 = state_27296__$1;
(statearr_27334_27370[(1)] = (11));

} else {
var statearr_27335_27371 = state_27296__$1;
(statearr_27335_27371[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__24298__auto__ = null;
var cljs$core$async$mix_$_state_machine__24298__auto____0 = (function (){
var statearr_27336 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27336[(0)] = cljs$core$async$mix_$_state_machine__24298__auto__);

(statearr_27336[(1)] = (1));

return statearr_27336;
});
var cljs$core$async$mix_$_state_machine__24298__auto____1 = (function (state_27296){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27296);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27337){var ex__24301__auto__ = e27337;
var statearr_27338_27372 = state_27296;
(statearr_27338_27372[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27296[(4)]))){
var statearr_27339_27373 = state_27296;
(statearr_27339_27373[(1)] = cljs.core.first((state_27296[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27374 = state_27296;
state_27296 = G__27374;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__24298__auto__ = function(state_27296){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__24298__auto____1.call(this,state_27296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__24298__auto____0;
cljs$core$async$mix_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__24298__auto____1;
return cljs$core$async$mix_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27340 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27340[(6)] = c__24424__auto___27341);

return statearr_27340;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_27377 = (function (p,v,ch,close_QMARK_){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4510__auto__.call(null,p,v,ch,close_QMARK_));
} else {
var m__4508__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__4508__auto__.call(null,p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_27377(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_27378 = (function (p,v,ch){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4510__auto__.call(null,p,v,ch));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__4508__auto__.call(null,p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_27378(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_27379 = (function() {
var G__27380 = null;
var G__27380__1 = (function (p){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4510__auto__.call(null,p));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__4508__auto__.call(null,p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__27380__2 = (function (p,v){
var x__4509__auto__ = (((p == null))?null:p);
var m__4510__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4510__auto__.call(null,p,v));
} else {
var m__4508__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__4508__auto__.call(null,p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__27380 = function(p,v){
switch(arguments.length){
case 1:
return G__27380__1.call(this,p);
case 2:
return G__27380__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__27380.cljs$core$IFn$_invoke$arity$1 = G__27380__1;
G__27380.cljs$core$IFn$_invoke$arity$2 = G__27380__2;
return G__27380;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__27376 = arguments.length;
switch (G__27376) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_27379.cljs$core$IFn$_invoke$arity$1(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_27379.cljs$core$IFn$_invoke$arity$2(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__27384 = arguments.length;
switch (G__27384) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__27382_SHARP_){
if(cljs.core.truth_((p1__27382_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__27382_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__27382_SHARP_.call(null,topic)))){
return p1__27382_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__27382_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null,topic)))));
}
})),topic);
}
});
var p = (function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27385 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27385 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta27386){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta27386 = meta27386;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27387,meta27386__$1){
var self__ = this;
var _27387__$1 = this;
return (new cljs.core.async.t_cljs$core$async27385(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta27386__$1));
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27387){
var self__ = this;
var _27387__$1 = this;
return self__.meta27386;
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null,topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5753__auto__)){
var m = temp__5753__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async27385.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async27385.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$ch,cljs.core.cst$sym$topic_DASH_fn,cljs.core.cst$sym$buf_DASH_fn,cljs.core.cst$sym$mults,cljs.core.cst$sym$ensure_DASH_mult,cljs.core.cst$sym$meta27386], null);
}));

(cljs.core.async.t_cljs$core$async27385.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27385.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27385");

(cljs.core.async.t_cljs$core$async27385.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27385");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27385.
 */
cljs.core.async.__GT_t_cljs$core$async27385 = (function cljs$core$async$__GT_t_cljs$core$async27385(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27386){
return (new cljs.core.async.t_cljs$core$async27385(ch__$1,topic_fn__$1,buf_fn__$1,mults__$1,ensure_mult__$1,meta27386));
});

}

return (new cljs.core.async.t_cljs$core$async27385(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
})()
;
var c__24424__auto___27506 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27459){
var state_val_27460 = (state_27459[(1)]);
if((state_val_27460 === (7))){
var inst_27455 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27461_27507 = state_27459__$1;
(statearr_27461_27507[(2)] = inst_27455);

(statearr_27461_27507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (20))){
var state_27459__$1 = state_27459;
var statearr_27462_27508 = state_27459__$1;
(statearr_27462_27508[(2)] = null);

(statearr_27462_27508[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (1))){
var state_27459__$1 = state_27459;
var statearr_27463_27509 = state_27459__$1;
(statearr_27463_27509[(2)] = null);

(statearr_27463_27509[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (24))){
var inst_27438 = (state_27459[(7)]);
var inst_27447 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_27438);
var state_27459__$1 = state_27459;
var statearr_27464_27510 = state_27459__$1;
(statearr_27464_27510[(2)] = inst_27447);

(statearr_27464_27510[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (4))){
var inst_27390 = (state_27459[(8)]);
var inst_27390__$1 = (state_27459[(2)]);
var inst_27391 = (inst_27390__$1 == null);
var state_27459__$1 = (function (){var statearr_27465 = state_27459;
(statearr_27465[(8)] = inst_27390__$1);

return statearr_27465;
})();
if(cljs.core.truth_(inst_27391)){
var statearr_27466_27511 = state_27459__$1;
(statearr_27466_27511[(1)] = (5));

} else {
var statearr_27467_27512 = state_27459__$1;
(statearr_27467_27512[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (15))){
var inst_27432 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27468_27513 = state_27459__$1;
(statearr_27468_27513[(2)] = inst_27432);

(statearr_27468_27513[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (21))){
var inst_27452 = (state_27459[(2)]);
var state_27459__$1 = (function (){var statearr_27469 = state_27459;
(statearr_27469[(9)] = inst_27452);

return statearr_27469;
})();
var statearr_27470_27514 = state_27459__$1;
(statearr_27470_27514[(2)] = null);

(statearr_27470_27514[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (13))){
var inst_27414 = (state_27459[(10)]);
var inst_27416 = cljs.core.chunked_seq_QMARK_(inst_27414);
var state_27459__$1 = state_27459;
if(inst_27416){
var statearr_27471_27515 = state_27459__$1;
(statearr_27471_27515[(1)] = (16));

} else {
var statearr_27472_27516 = state_27459__$1;
(statearr_27472_27516[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (22))){
var inst_27444 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
if(cljs.core.truth_(inst_27444)){
var statearr_27473_27517 = state_27459__$1;
(statearr_27473_27517[(1)] = (23));

} else {
var statearr_27474_27518 = state_27459__$1;
(statearr_27474_27518[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (6))){
var inst_27440 = (state_27459[(11)]);
var inst_27438 = (state_27459[(7)]);
var inst_27390 = (state_27459[(8)]);
var inst_27438__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_27390) : topic_fn.call(null,inst_27390));
var inst_27439 = cljs.core.deref(mults);
var inst_27440__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_27439,inst_27438__$1);
var state_27459__$1 = (function (){var statearr_27475 = state_27459;
(statearr_27475[(11)] = inst_27440__$1);

(statearr_27475[(7)] = inst_27438__$1);

return statearr_27475;
})();
if(cljs.core.truth_(inst_27440__$1)){
var statearr_27476_27519 = state_27459__$1;
(statearr_27476_27519[(1)] = (19));

} else {
var statearr_27477_27520 = state_27459__$1;
(statearr_27477_27520[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (25))){
var inst_27449 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27478_27521 = state_27459__$1;
(statearr_27478_27521[(2)] = inst_27449);

(statearr_27478_27521[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (17))){
var inst_27414 = (state_27459[(10)]);
var inst_27423 = cljs.core.first(inst_27414);
var inst_27424 = cljs.core.async.muxch_STAR_(inst_27423);
var inst_27425 = cljs.core.async.close_BANG_(inst_27424);
var inst_27426 = cljs.core.next(inst_27414);
var inst_27400 = inst_27426;
var inst_27401 = null;
var inst_27402 = (0);
var inst_27403 = (0);
var state_27459__$1 = (function (){var statearr_27479 = state_27459;
(statearr_27479[(12)] = inst_27402);

(statearr_27479[(13)] = inst_27403);

(statearr_27479[(14)] = inst_27425);

(statearr_27479[(15)] = inst_27400);

(statearr_27479[(16)] = inst_27401);

return statearr_27479;
})();
var statearr_27480_27522 = state_27459__$1;
(statearr_27480_27522[(2)] = null);

(statearr_27480_27522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (3))){
var inst_27457 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27459__$1,inst_27457);
} else {
if((state_val_27460 === (12))){
var inst_27434 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27481_27523 = state_27459__$1;
(statearr_27481_27523[(2)] = inst_27434);

(statearr_27481_27523[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (2))){
var state_27459__$1 = state_27459;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27459__$1,(4),ch);
} else {
if((state_val_27460 === (23))){
var state_27459__$1 = state_27459;
var statearr_27482_27524 = state_27459__$1;
(statearr_27482_27524[(2)] = null);

(statearr_27482_27524[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (19))){
var inst_27440 = (state_27459[(11)]);
var inst_27390 = (state_27459[(8)]);
var inst_27442 = cljs.core.async.muxch_STAR_(inst_27440);
var state_27459__$1 = state_27459;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27459__$1,(22),inst_27442,inst_27390);
} else {
if((state_val_27460 === (11))){
var inst_27414 = (state_27459[(10)]);
var inst_27400 = (state_27459[(15)]);
var inst_27414__$1 = cljs.core.seq(inst_27400);
var state_27459__$1 = (function (){var statearr_27483 = state_27459;
(statearr_27483[(10)] = inst_27414__$1);

return statearr_27483;
})();
if(inst_27414__$1){
var statearr_27484_27525 = state_27459__$1;
(statearr_27484_27525[(1)] = (13));

} else {
var statearr_27485_27526 = state_27459__$1;
(statearr_27485_27526[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (9))){
var inst_27436 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27486_27527 = state_27459__$1;
(statearr_27486_27527[(2)] = inst_27436);

(statearr_27486_27527[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (5))){
var inst_27397 = cljs.core.deref(mults);
var inst_27398 = cljs.core.vals(inst_27397);
var inst_27399 = cljs.core.seq(inst_27398);
var inst_27400 = inst_27399;
var inst_27401 = null;
var inst_27402 = (0);
var inst_27403 = (0);
var state_27459__$1 = (function (){var statearr_27487 = state_27459;
(statearr_27487[(12)] = inst_27402);

(statearr_27487[(13)] = inst_27403);

(statearr_27487[(15)] = inst_27400);

(statearr_27487[(16)] = inst_27401);

return statearr_27487;
})();
var statearr_27488_27528 = state_27459__$1;
(statearr_27488_27528[(2)] = null);

(statearr_27488_27528[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (14))){
var state_27459__$1 = state_27459;
var statearr_27492_27529 = state_27459__$1;
(statearr_27492_27529[(2)] = null);

(statearr_27492_27529[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (16))){
var inst_27414 = (state_27459[(10)]);
var inst_27418 = cljs.core.chunk_first(inst_27414);
var inst_27419 = cljs.core.chunk_rest(inst_27414);
var inst_27420 = cljs.core.count(inst_27418);
var inst_27400 = inst_27419;
var inst_27401 = inst_27418;
var inst_27402 = inst_27420;
var inst_27403 = (0);
var state_27459__$1 = (function (){var statearr_27493 = state_27459;
(statearr_27493[(12)] = inst_27402);

(statearr_27493[(13)] = inst_27403);

(statearr_27493[(15)] = inst_27400);

(statearr_27493[(16)] = inst_27401);

return statearr_27493;
})();
var statearr_27494_27530 = state_27459__$1;
(statearr_27494_27530[(2)] = null);

(statearr_27494_27530[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (10))){
var inst_27402 = (state_27459[(12)]);
var inst_27403 = (state_27459[(13)]);
var inst_27400 = (state_27459[(15)]);
var inst_27401 = (state_27459[(16)]);
var inst_27408 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_27401,inst_27403);
var inst_27409 = cljs.core.async.muxch_STAR_(inst_27408);
var inst_27410 = cljs.core.async.close_BANG_(inst_27409);
var inst_27411 = (inst_27403 + (1));
var tmp27489 = inst_27402;
var tmp27490 = inst_27400;
var tmp27491 = inst_27401;
var inst_27400__$1 = tmp27490;
var inst_27401__$1 = tmp27491;
var inst_27402__$1 = tmp27489;
var inst_27403__$1 = inst_27411;
var state_27459__$1 = (function (){var statearr_27495 = state_27459;
(statearr_27495[(12)] = inst_27402__$1);

(statearr_27495[(17)] = inst_27410);

(statearr_27495[(13)] = inst_27403__$1);

(statearr_27495[(15)] = inst_27400__$1);

(statearr_27495[(16)] = inst_27401__$1);

return statearr_27495;
})();
var statearr_27496_27531 = state_27459__$1;
(statearr_27496_27531[(2)] = null);

(statearr_27496_27531[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (18))){
var inst_27429 = (state_27459[(2)]);
var state_27459__$1 = state_27459;
var statearr_27497_27532 = state_27459__$1;
(statearr_27497_27532[(2)] = inst_27429);

(statearr_27497_27532[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27460 === (8))){
var inst_27402 = (state_27459[(12)]);
var inst_27403 = (state_27459[(13)]);
var inst_27405 = (inst_27403 < inst_27402);
var inst_27406 = inst_27405;
var state_27459__$1 = state_27459;
if(cljs.core.truth_(inst_27406)){
var statearr_27498_27533 = state_27459__$1;
(statearr_27498_27533[(1)] = (10));

} else {
var statearr_27499_27534 = state_27459__$1;
(statearr_27499_27534[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_27500 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27500[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_27500[(1)] = (1));

return statearr_27500;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_27459){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27459);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27501){var ex__24301__auto__ = e27501;
var statearr_27502_27535 = state_27459;
(statearr_27502_27535[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27459[(4)]))){
var statearr_27503_27536 = state_27459;
(statearr_27503_27536[(1)] = cljs.core.first((state_27459[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27537 = state_27459;
state_27459 = G__27537;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_27459){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_27459);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27504 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27504[(6)] = c__24424__auto___27506);

return statearr_27504;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__27539 = arguments.length;
switch (G__27539) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__27542 = arguments.length;
switch (G__27542) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__27545 = arguments.length;
switch (G__27545) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
var c__24424__auto___27623 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27588){
var state_val_27589 = (state_27588[(1)]);
if((state_val_27589 === (7))){
var state_27588__$1 = state_27588;
var statearr_27590_27624 = state_27588__$1;
(statearr_27590_27624[(2)] = null);

(statearr_27590_27624[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (1))){
var state_27588__$1 = state_27588;
var statearr_27591_27625 = state_27588__$1;
(statearr_27591_27625[(2)] = null);

(statearr_27591_27625[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (4))){
var inst_27549 = (state_27588[(7)]);
var inst_27548 = (state_27588[(8)]);
var inst_27551 = (inst_27549 < inst_27548);
var state_27588__$1 = state_27588;
if(cljs.core.truth_(inst_27551)){
var statearr_27592_27626 = state_27588__$1;
(statearr_27592_27626[(1)] = (6));

} else {
var statearr_27593_27627 = state_27588__$1;
(statearr_27593_27627[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (15))){
var inst_27574 = (state_27588[(9)]);
var inst_27579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_27574);
var state_27588__$1 = state_27588;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27588__$1,(17),out,inst_27579);
} else {
if((state_val_27589 === (13))){
var inst_27574 = (state_27588[(9)]);
var inst_27574__$1 = (state_27588[(2)]);
var inst_27575 = cljs.core.some(cljs.core.nil_QMARK_,inst_27574__$1);
var state_27588__$1 = (function (){var statearr_27594 = state_27588;
(statearr_27594[(9)] = inst_27574__$1);

return statearr_27594;
})();
if(cljs.core.truth_(inst_27575)){
var statearr_27595_27628 = state_27588__$1;
(statearr_27595_27628[(1)] = (14));

} else {
var statearr_27596_27629 = state_27588__$1;
(statearr_27596_27629[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (6))){
var state_27588__$1 = state_27588;
var statearr_27597_27630 = state_27588__$1;
(statearr_27597_27630[(2)] = null);

(statearr_27597_27630[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (17))){
var inst_27581 = (state_27588[(2)]);
var state_27588__$1 = (function (){var statearr_27599 = state_27588;
(statearr_27599[(10)] = inst_27581);

return statearr_27599;
})();
var statearr_27600_27631 = state_27588__$1;
(statearr_27600_27631[(2)] = null);

(statearr_27600_27631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (3))){
var inst_27586 = (state_27588[(2)]);
var state_27588__$1 = state_27588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27588__$1,inst_27586);
} else {
if((state_val_27589 === (12))){
var _ = (function (){var statearr_27601 = state_27588;
(statearr_27601[(4)] = cljs.core.rest((state_27588[(4)])));

return statearr_27601;
})();
var state_27588__$1 = state_27588;
var ex27598 = (state_27588__$1[(2)]);
var statearr_27602_27632 = state_27588__$1;
(statearr_27602_27632[(5)] = ex27598);


if((ex27598 instanceof Object)){
var statearr_27603_27633 = state_27588__$1;
(statearr_27603_27633[(1)] = (11));

(statearr_27603_27633[(5)] = null);

} else {
throw ex27598;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (2))){
var inst_27547 = cljs.core.reset_BANG_(dctr,cnt);
var inst_27548 = cnt;
var inst_27549 = (0);
var state_27588__$1 = (function (){var statearr_27604 = state_27588;
(statearr_27604[(7)] = inst_27549);

(statearr_27604[(11)] = inst_27547);

(statearr_27604[(8)] = inst_27548);

return statearr_27604;
})();
var statearr_27605_27634 = state_27588__$1;
(statearr_27605_27634[(2)] = null);

(statearr_27605_27634[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (11))){
var inst_27553 = (state_27588[(2)]);
var inst_27554 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_27588__$1 = (function (){var statearr_27606 = state_27588;
(statearr_27606[(12)] = inst_27553);

return statearr_27606;
})();
var statearr_27607_27635 = state_27588__$1;
(statearr_27607_27635[(2)] = inst_27554);

(statearr_27607_27635[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (9))){
var inst_27549 = (state_27588[(7)]);
var _ = (function (){var statearr_27608 = state_27588;
(statearr_27608[(4)] = cljs.core.cons((12),(state_27588[(4)])));

return statearr_27608;
})();
var inst_27560 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_27549) : chs__$1.call(null,inst_27549));
var inst_27561 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_27549) : done.call(null,inst_27549));
var inst_27562 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_27560,inst_27561);
var ___$1 = (function (){var statearr_27609 = state_27588;
(statearr_27609[(4)] = cljs.core.rest((state_27588[(4)])));

return statearr_27609;
})();
var state_27588__$1 = state_27588;
var statearr_27610_27636 = state_27588__$1;
(statearr_27610_27636[(2)] = inst_27562);

(statearr_27610_27636[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (5))){
var inst_27572 = (state_27588[(2)]);
var state_27588__$1 = (function (){var statearr_27611 = state_27588;
(statearr_27611[(13)] = inst_27572);

return statearr_27611;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27588__$1,(13),dchan);
} else {
if((state_val_27589 === (14))){
var inst_27577 = cljs.core.async.close_BANG_(out);
var state_27588__$1 = state_27588;
var statearr_27612_27637 = state_27588__$1;
(statearr_27612_27637[(2)] = inst_27577);

(statearr_27612_27637[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (16))){
var inst_27584 = (state_27588[(2)]);
var state_27588__$1 = state_27588;
var statearr_27613_27638 = state_27588__$1;
(statearr_27613_27638[(2)] = inst_27584);

(statearr_27613_27638[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (10))){
var inst_27549 = (state_27588[(7)]);
var inst_27565 = (state_27588[(2)]);
var inst_27566 = (inst_27549 + (1));
var inst_27549__$1 = inst_27566;
var state_27588__$1 = (function (){var statearr_27614 = state_27588;
(statearr_27614[(7)] = inst_27549__$1);

(statearr_27614[(14)] = inst_27565);

return statearr_27614;
})();
var statearr_27615_27639 = state_27588__$1;
(statearr_27615_27639[(2)] = null);

(statearr_27615_27639[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27589 === (8))){
var inst_27570 = (state_27588[(2)]);
var state_27588__$1 = state_27588;
var statearr_27616_27640 = state_27588__$1;
(statearr_27616_27640[(2)] = inst_27570);

(statearr_27616_27640[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_27617 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27617[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_27617[(1)] = (1));

return statearr_27617;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_27588){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27588);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27618){var ex__24301__auto__ = e27618;
var statearr_27619_27641 = state_27588;
(statearr_27619_27641[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27588[(4)]))){
var statearr_27620_27642 = state_27588;
(statearr_27620_27642[(1)] = cljs.core.first((state_27588[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27643 = state_27588;
state_27588 = G__27643;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_27588){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_27588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27621 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27621[(6)] = c__24424__auto___27623);

return statearr_27621;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__27646 = arguments.length;
switch (G__27646) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___27701 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27678){
var state_val_27679 = (state_27678[(1)]);
if((state_val_27679 === (7))){
var inst_27658 = (state_27678[(7)]);
var inst_27657 = (state_27678[(8)]);
var inst_27657__$1 = (state_27678[(2)]);
var inst_27658__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27657__$1,(0),null);
var inst_27659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27657__$1,(1),null);
var inst_27660 = (inst_27658__$1 == null);
var state_27678__$1 = (function (){var statearr_27680 = state_27678;
(statearr_27680[(7)] = inst_27658__$1);

(statearr_27680[(8)] = inst_27657__$1);

(statearr_27680[(9)] = inst_27659);

return statearr_27680;
})();
if(cljs.core.truth_(inst_27660)){
var statearr_27681_27702 = state_27678__$1;
(statearr_27681_27702[(1)] = (8));

} else {
var statearr_27682_27703 = state_27678__$1;
(statearr_27682_27703[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (1))){
var inst_27647 = cljs.core.vec(chs);
var inst_27648 = inst_27647;
var state_27678__$1 = (function (){var statearr_27683 = state_27678;
(statearr_27683[(10)] = inst_27648);

return statearr_27683;
})();
var statearr_27684_27704 = state_27678__$1;
(statearr_27684_27704[(2)] = null);

(statearr_27684_27704[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (4))){
var inst_27648 = (state_27678[(10)]);
var state_27678__$1 = state_27678;
return cljs.core.async.ioc_alts_BANG_(state_27678__$1,(7),inst_27648);
} else {
if((state_val_27679 === (6))){
var inst_27674 = (state_27678[(2)]);
var state_27678__$1 = state_27678;
var statearr_27685_27705 = state_27678__$1;
(statearr_27685_27705[(2)] = inst_27674);

(statearr_27685_27705[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (3))){
var inst_27676 = (state_27678[(2)]);
var state_27678__$1 = state_27678;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27678__$1,inst_27676);
} else {
if((state_val_27679 === (2))){
var inst_27648 = (state_27678[(10)]);
var inst_27650 = cljs.core.count(inst_27648);
var inst_27651 = (inst_27650 > (0));
var state_27678__$1 = state_27678;
if(cljs.core.truth_(inst_27651)){
var statearr_27687_27706 = state_27678__$1;
(statearr_27687_27706[(1)] = (4));

} else {
var statearr_27688_27707 = state_27678__$1;
(statearr_27688_27707[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (11))){
var inst_27648 = (state_27678[(10)]);
var inst_27667 = (state_27678[(2)]);
var tmp27686 = inst_27648;
var inst_27648__$1 = tmp27686;
var state_27678__$1 = (function (){var statearr_27689 = state_27678;
(statearr_27689[(10)] = inst_27648__$1);

(statearr_27689[(11)] = inst_27667);

return statearr_27689;
})();
var statearr_27690_27708 = state_27678__$1;
(statearr_27690_27708[(2)] = null);

(statearr_27690_27708[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (9))){
var inst_27658 = (state_27678[(7)]);
var state_27678__$1 = state_27678;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27678__$1,(11),out,inst_27658);
} else {
if((state_val_27679 === (5))){
var inst_27672 = cljs.core.async.close_BANG_(out);
var state_27678__$1 = state_27678;
var statearr_27691_27709 = state_27678__$1;
(statearr_27691_27709[(2)] = inst_27672);

(statearr_27691_27709[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (10))){
var inst_27670 = (state_27678[(2)]);
var state_27678__$1 = state_27678;
var statearr_27692_27710 = state_27678__$1;
(statearr_27692_27710[(2)] = inst_27670);

(statearr_27692_27710[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27679 === (8))){
var inst_27658 = (state_27678[(7)]);
var inst_27648 = (state_27678[(10)]);
var inst_27657 = (state_27678[(8)]);
var inst_27659 = (state_27678[(9)]);
var inst_27662 = (function (){var cs = inst_27648;
var vec__27653 = inst_27657;
var v = inst_27658;
var c = inst_27659;
return (function (p1__27644_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__27644_SHARP_);
});
})();
var inst_27663 = cljs.core.filterv(inst_27662,inst_27648);
var inst_27648__$1 = inst_27663;
var state_27678__$1 = (function (){var statearr_27693 = state_27678;
(statearr_27693[(10)] = inst_27648__$1);

return statearr_27693;
})();
var statearr_27694_27711 = state_27678__$1;
(statearr_27694_27711[(2)] = null);

(statearr_27694_27711[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_27695 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27695[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_27695[(1)] = (1));

return statearr_27695;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_27678){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27678);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27696){var ex__24301__auto__ = e27696;
var statearr_27697_27712 = state_27678;
(statearr_27697_27712[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27678[(4)]))){
var statearr_27698_27713 = state_27678;
(statearr_27698_27713[(1)] = cljs.core.first((state_27678[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27714 = state_27678;
state_27678 = G__27714;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_27678){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_27678);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27699 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27699[(6)] = c__24424__auto___27701);

return statearr_27699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__27716 = arguments.length;
switch (G__27716) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___27762 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27740){
var state_val_27741 = (state_27740[(1)]);
if((state_val_27741 === (7))){
var inst_27722 = (state_27740[(7)]);
var inst_27722__$1 = (state_27740[(2)]);
var inst_27723 = (inst_27722__$1 == null);
var inst_27724 = cljs.core.not(inst_27723);
var state_27740__$1 = (function (){var statearr_27742 = state_27740;
(statearr_27742[(7)] = inst_27722__$1);

return statearr_27742;
})();
if(inst_27724){
var statearr_27743_27763 = state_27740__$1;
(statearr_27743_27763[(1)] = (8));

} else {
var statearr_27744_27764 = state_27740__$1;
(statearr_27744_27764[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (1))){
var inst_27717 = (0);
var state_27740__$1 = (function (){var statearr_27745 = state_27740;
(statearr_27745[(8)] = inst_27717);

return statearr_27745;
})();
var statearr_27746_27765 = state_27740__$1;
(statearr_27746_27765[(2)] = null);

(statearr_27746_27765[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (4))){
var state_27740__$1 = state_27740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27740__$1,(7),ch);
} else {
if((state_val_27741 === (6))){
var inst_27735 = (state_27740[(2)]);
var state_27740__$1 = state_27740;
var statearr_27747_27766 = state_27740__$1;
(statearr_27747_27766[(2)] = inst_27735);

(statearr_27747_27766[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (3))){
var inst_27737 = (state_27740[(2)]);
var inst_27738 = cljs.core.async.close_BANG_(out);
var state_27740__$1 = (function (){var statearr_27748 = state_27740;
(statearr_27748[(9)] = inst_27737);

return statearr_27748;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_27740__$1,inst_27738);
} else {
if((state_val_27741 === (2))){
var inst_27717 = (state_27740[(8)]);
var inst_27719 = (inst_27717 < n);
var state_27740__$1 = state_27740;
if(cljs.core.truth_(inst_27719)){
var statearr_27749_27767 = state_27740__$1;
(statearr_27749_27767[(1)] = (4));

} else {
var statearr_27750_27768 = state_27740__$1;
(statearr_27750_27768[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (11))){
var inst_27717 = (state_27740[(8)]);
var inst_27727 = (state_27740[(2)]);
var inst_27728 = (inst_27717 + (1));
var inst_27717__$1 = inst_27728;
var state_27740__$1 = (function (){var statearr_27751 = state_27740;
(statearr_27751[(10)] = inst_27727);

(statearr_27751[(8)] = inst_27717__$1);

return statearr_27751;
})();
var statearr_27752_27769 = state_27740__$1;
(statearr_27752_27769[(2)] = null);

(statearr_27752_27769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (9))){
var state_27740__$1 = state_27740;
var statearr_27753_27770 = state_27740__$1;
(statearr_27753_27770[(2)] = null);

(statearr_27753_27770[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (5))){
var state_27740__$1 = state_27740;
var statearr_27754_27771 = state_27740__$1;
(statearr_27754_27771[(2)] = null);

(statearr_27754_27771[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (10))){
var inst_27732 = (state_27740[(2)]);
var state_27740__$1 = state_27740;
var statearr_27755_27772 = state_27740__$1;
(statearr_27755_27772[(2)] = inst_27732);

(statearr_27755_27772[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27741 === (8))){
var inst_27722 = (state_27740[(7)]);
var state_27740__$1 = state_27740;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27740__$1,(11),out,inst_27722);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_27756 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_27756[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_27756[(1)] = (1));

return statearr_27756;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_27740){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27740);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27757){var ex__24301__auto__ = e27757;
var statearr_27758_27773 = state_27740;
(statearr_27758_27773[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27740[(4)]))){
var statearr_27759_27774 = state_27740;
(statearr_27759_27774[(1)] = cljs.core.first((state_27740[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27775 = state_27740;
state_27740 = G__27775;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_27740){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_27740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27760 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27760[(6)] = c__24424__auto___27762);

return statearr_27760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27777 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27777 = (function (f,ch,meta27778){
this.f = f;
this.ch = ch;
this.meta27778 = meta27778;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27779,meta27778__$1){
var self__ = this;
var _27779__$1 = this;
return (new cljs.core.async.t_cljs$core$async27777(self__.f,self__.ch,meta27778__$1));
}));

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27779){
var self__ = this;
var _27779__$1 = this;
return self__.meta27778;
}));

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(function (){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27780 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27780 = (function (f,ch,meta27778,_,fn1,meta27781){
this.f = f;
this.ch = ch;
this.meta27778 = meta27778;
this._ = _;
this.fn1 = fn1;
this.meta27781 = meta27781;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27782,meta27781__$1){
var self__ = this;
var _27782__$1 = this;
return (new cljs.core.async.t_cljs$core$async27780(self__.f,self__.ch,self__.meta27778,self__._,self__.fn1,meta27781__$1));
}));

(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27782){
var self__ = this;
var _27782__$1 = this;
return self__.meta27781;
}));

(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async27780.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__27776_SHARP_){
var G__27783 = (((p1__27776_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__27776_SHARP_) : self__.f.call(null,p1__27776_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__27783) : f1.call(null,G__27783));
});
}));

(cljs.core.async.t_cljs$core$async27780.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27778,cljs.core.with_meta(cljs.core.cst$sym$_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$tag,cljs.core.cst$sym$cljs$core$async_SLASH_t_cljs$core$async27777], null)),cljs.core.cst$sym$fn1,cljs.core.cst$sym$meta27781], null);
}));

(cljs.core.async.t_cljs$core$async27780.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27780.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27780");

(cljs.core.async.t_cljs$core$async27780.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27780");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27780.
 */
cljs.core.async.__GT_t_cljs$core$async27780 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27780(f__$1,ch__$1,meta27778__$1,___$2,fn1__$1,meta27781){
return (new cljs.core.async.t_cljs$core$async27780(f__$1,ch__$1,meta27778__$1,___$2,fn1__$1,meta27781));
});

}

return (new cljs.core.async.t_cljs$core$async27780(self__.f,self__.ch,self__.meta27778,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY));
})()
);
if(cljs.core.truth_((function (){var and__4210__auto__ = ret;
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__4210__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__27784 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__27784) : self__.f.call(null,G__27784));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27777.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async27777.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27778], null);
}));

(cljs.core.async.t_cljs$core$async27777.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27777.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27777");

(cljs.core.async.t_cljs$core$async27777.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27777");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27777.
 */
cljs.core.async.__GT_t_cljs$core$async27777 = (function cljs$core$async$map_LT__$___GT_t_cljs$core$async27777(f__$1,ch__$1,meta27778){
return (new cljs.core.async.t_cljs$core$async27777(f__$1,ch__$1,meta27778));
});

}

return (new cljs.core.async.t_cljs$core$async27777(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27785 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27785 = (function (f,ch,meta27786){
this.f = f;
this.ch = ch;
this.meta27786 = meta27786;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27787,meta27786__$1){
var self__ = this;
var _27787__$1 = this;
return (new cljs.core.async.t_cljs$core$async27785(self__.f,self__.ch,meta27786__$1));
}));

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27787){
var self__ = this;
var _27787__$1 = this;
return self__.meta27786;
}));

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27785.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null,val)),fn1);
}));

(cljs.core.async.t_cljs$core$async27785.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$f,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27786], null);
}));

(cljs.core.async.t_cljs$core$async27785.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27785.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27785");

(cljs.core.async.t_cljs$core$async27785.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27785");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27785.
 */
cljs.core.async.__GT_t_cljs$core$async27785 = (function cljs$core$async$map_GT__$___GT_t_cljs$core$async27785(f__$1,ch__$1,meta27786){
return (new cljs.core.async.t_cljs$core$async27785(f__$1,ch__$1,meta27786));
});

}

return (new cljs.core.async.t_cljs$core$async27785(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
if((typeof cljs !== 'undefined') && (typeof cljs.core !== 'undefined') && (typeof cljs.core.async !== 'undefined') && (typeof cljs.core.async.t_cljs$core$async27788 !== 'undefined')){
} else {

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async27788 = (function (p,ch,meta27789){
this.p = p;
this.ch = ch;
this.meta27789 = meta27789;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_27790,meta27789__$1){
var self__ = this;
var _27790__$1 = this;
return (new cljs.core.async.t_cljs$core$async27788(self__.p,self__.ch,meta27789__$1));
}));

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_27790){
var self__ = this;
var _27790__$1 = this;
return self__.meta27789;
}));

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async27788.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null,val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async27788.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$p,cljs.core.cst$sym$ch,cljs.core.cst$sym$meta27789], null);
}));

(cljs.core.async.t_cljs$core$async27788.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async27788.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async27788");

(cljs.core.async.t_cljs$core$async27788.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"cljs.core.async/t_cljs$core$async27788");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async27788.
 */
cljs.core.async.__GT_t_cljs$core$async27788 = (function cljs$core$async$filter_GT__$___GT_t_cljs$core$async27788(p__$1,ch__$1,meta27789){
return (new cljs.core.async.t_cljs$core$async27788(p__$1,ch__$1,meta27789));
});

}

return (new cljs.core.async.t_cljs$core$async27788(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__27792 = arguments.length;
switch (G__27792) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___27833 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27813){
var state_val_27814 = (state_27813[(1)]);
if((state_val_27814 === (7))){
var inst_27809 = (state_27813[(2)]);
var state_27813__$1 = state_27813;
var statearr_27815_27834 = state_27813__$1;
(statearr_27815_27834[(2)] = inst_27809);

(statearr_27815_27834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (1))){
var state_27813__$1 = state_27813;
var statearr_27816_27835 = state_27813__$1;
(statearr_27816_27835[(2)] = null);

(statearr_27816_27835[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (4))){
var inst_27795 = (state_27813[(7)]);
var inst_27795__$1 = (state_27813[(2)]);
var inst_27796 = (inst_27795__$1 == null);
var state_27813__$1 = (function (){var statearr_27817 = state_27813;
(statearr_27817[(7)] = inst_27795__$1);

return statearr_27817;
})();
if(cljs.core.truth_(inst_27796)){
var statearr_27818_27836 = state_27813__$1;
(statearr_27818_27836[(1)] = (5));

} else {
var statearr_27819_27837 = state_27813__$1;
(statearr_27819_27837[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (6))){
var inst_27795 = (state_27813[(7)]);
var inst_27800 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_27795) : p.call(null,inst_27795));
var state_27813__$1 = state_27813;
if(cljs.core.truth_(inst_27800)){
var statearr_27820_27838 = state_27813__$1;
(statearr_27820_27838[(1)] = (8));

} else {
var statearr_27821_27839 = state_27813__$1;
(statearr_27821_27839[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (3))){
var inst_27811 = (state_27813[(2)]);
var state_27813__$1 = state_27813;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27813__$1,inst_27811);
} else {
if((state_val_27814 === (2))){
var state_27813__$1 = state_27813;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27813__$1,(4),ch);
} else {
if((state_val_27814 === (11))){
var inst_27803 = (state_27813[(2)]);
var state_27813__$1 = state_27813;
var statearr_27822_27840 = state_27813__$1;
(statearr_27822_27840[(2)] = inst_27803);

(statearr_27822_27840[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (9))){
var state_27813__$1 = state_27813;
var statearr_27823_27841 = state_27813__$1;
(statearr_27823_27841[(2)] = null);

(statearr_27823_27841[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (5))){
var inst_27798 = cljs.core.async.close_BANG_(out);
var state_27813__$1 = state_27813;
var statearr_27824_27842 = state_27813__$1;
(statearr_27824_27842[(2)] = inst_27798);

(statearr_27824_27842[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (10))){
var inst_27806 = (state_27813[(2)]);
var state_27813__$1 = (function (){var statearr_27825 = state_27813;
(statearr_27825[(8)] = inst_27806);

return statearr_27825;
})();
var statearr_27826_27843 = state_27813__$1;
(statearr_27826_27843[(2)] = null);

(statearr_27826_27843[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27814 === (8))){
var inst_27795 = (state_27813[(7)]);
var state_27813__$1 = state_27813;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27813__$1,(11),out,inst_27795);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_27827 = [null,null,null,null,null,null,null,null,null];
(statearr_27827[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_27827[(1)] = (1));

return statearr_27827;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_27813){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27813);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27828){var ex__24301__auto__ = e27828;
var statearr_27829_27844 = state_27813;
(statearr_27829_27844[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27813[(4)]))){
var statearr_27830_27845 = state_27813;
(statearr_27830_27845[(1)] = cljs.core.first((state_27813[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27846 = state_27813;
state_27813 = G__27846;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_27813){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_27813);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27831 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27831[(6)] = c__24424__auto___27833);

return statearr_27831;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__27848 = arguments.length;
switch (G__27848) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_27911){
var state_val_27912 = (state_27911[(1)]);
if((state_val_27912 === (7))){
var inst_27907 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27913_27952 = state_27911__$1;
(statearr_27913_27952[(2)] = inst_27907);

(statearr_27913_27952[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (20))){
var inst_27877 = (state_27911[(7)]);
var inst_27888 = (state_27911[(2)]);
var inst_27889 = cljs.core.next(inst_27877);
var inst_27863 = inst_27889;
var inst_27864 = null;
var inst_27865 = (0);
var inst_27866 = (0);
var state_27911__$1 = (function (){var statearr_27914 = state_27911;
(statearr_27914[(8)] = inst_27864);

(statearr_27914[(9)] = inst_27863);

(statearr_27914[(10)] = inst_27865);

(statearr_27914[(11)] = inst_27866);

(statearr_27914[(12)] = inst_27888);

return statearr_27914;
})();
var statearr_27915_27953 = state_27911__$1;
(statearr_27915_27953[(2)] = null);

(statearr_27915_27953[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (1))){
var state_27911__$1 = state_27911;
var statearr_27916_27954 = state_27911__$1;
(statearr_27916_27954[(2)] = null);

(statearr_27916_27954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (4))){
var inst_27852 = (state_27911[(13)]);
var inst_27852__$1 = (state_27911[(2)]);
var inst_27853 = (inst_27852__$1 == null);
var state_27911__$1 = (function (){var statearr_27917 = state_27911;
(statearr_27917[(13)] = inst_27852__$1);

return statearr_27917;
})();
if(cljs.core.truth_(inst_27853)){
var statearr_27918_27955 = state_27911__$1;
(statearr_27918_27955[(1)] = (5));

} else {
var statearr_27919_27956 = state_27911__$1;
(statearr_27919_27956[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (15))){
var state_27911__$1 = state_27911;
var statearr_27923_27957 = state_27911__$1;
(statearr_27923_27957[(2)] = null);

(statearr_27923_27957[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (21))){
var state_27911__$1 = state_27911;
var statearr_27924_27958 = state_27911__$1;
(statearr_27924_27958[(2)] = null);

(statearr_27924_27958[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (13))){
var inst_27864 = (state_27911[(8)]);
var inst_27863 = (state_27911[(9)]);
var inst_27865 = (state_27911[(10)]);
var inst_27866 = (state_27911[(11)]);
var inst_27873 = (state_27911[(2)]);
var inst_27874 = (inst_27866 + (1));
var tmp27920 = inst_27864;
var tmp27921 = inst_27863;
var tmp27922 = inst_27865;
var inst_27863__$1 = tmp27921;
var inst_27864__$1 = tmp27920;
var inst_27865__$1 = tmp27922;
var inst_27866__$1 = inst_27874;
var state_27911__$1 = (function (){var statearr_27925 = state_27911;
(statearr_27925[(8)] = inst_27864__$1);

(statearr_27925[(9)] = inst_27863__$1);

(statearr_27925[(14)] = inst_27873);

(statearr_27925[(10)] = inst_27865__$1);

(statearr_27925[(11)] = inst_27866__$1);

return statearr_27925;
})();
var statearr_27926_27959 = state_27911__$1;
(statearr_27926_27959[(2)] = null);

(statearr_27926_27959[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (22))){
var state_27911__$1 = state_27911;
var statearr_27927_27960 = state_27911__$1;
(statearr_27927_27960[(2)] = null);

(statearr_27927_27960[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (6))){
var inst_27852 = (state_27911[(13)]);
var inst_27861 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_27852) : f.call(null,inst_27852));
var inst_27862 = cljs.core.seq(inst_27861);
var inst_27863 = inst_27862;
var inst_27864 = null;
var inst_27865 = (0);
var inst_27866 = (0);
var state_27911__$1 = (function (){var statearr_27928 = state_27911;
(statearr_27928[(8)] = inst_27864);

(statearr_27928[(9)] = inst_27863);

(statearr_27928[(10)] = inst_27865);

(statearr_27928[(11)] = inst_27866);

return statearr_27928;
})();
var statearr_27929_27961 = state_27911__$1;
(statearr_27929_27961[(2)] = null);

(statearr_27929_27961[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (17))){
var inst_27877 = (state_27911[(7)]);
var inst_27881 = cljs.core.chunk_first(inst_27877);
var inst_27882 = cljs.core.chunk_rest(inst_27877);
var inst_27883 = cljs.core.count(inst_27881);
var inst_27863 = inst_27882;
var inst_27864 = inst_27881;
var inst_27865 = inst_27883;
var inst_27866 = (0);
var state_27911__$1 = (function (){var statearr_27930 = state_27911;
(statearr_27930[(8)] = inst_27864);

(statearr_27930[(9)] = inst_27863);

(statearr_27930[(10)] = inst_27865);

(statearr_27930[(11)] = inst_27866);

return statearr_27930;
})();
var statearr_27931_27962 = state_27911__$1;
(statearr_27931_27962[(2)] = null);

(statearr_27931_27962[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (3))){
var inst_27909 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27911__$1,inst_27909);
} else {
if((state_val_27912 === (12))){
var inst_27897 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27932_27963 = state_27911__$1;
(statearr_27932_27963[(2)] = inst_27897);

(statearr_27932_27963[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (2))){
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27911__$1,(4),in$);
} else {
if((state_val_27912 === (23))){
var inst_27905 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27933_27964 = state_27911__$1;
(statearr_27933_27964[(2)] = inst_27905);

(statearr_27933_27964[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (19))){
var inst_27892 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27934_27965 = state_27911__$1;
(statearr_27934_27965[(2)] = inst_27892);

(statearr_27934_27965[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (11))){
var inst_27863 = (state_27911[(9)]);
var inst_27877 = (state_27911[(7)]);
var inst_27877__$1 = cljs.core.seq(inst_27863);
var state_27911__$1 = (function (){var statearr_27935 = state_27911;
(statearr_27935[(7)] = inst_27877__$1);

return statearr_27935;
})();
if(inst_27877__$1){
var statearr_27936_27966 = state_27911__$1;
(statearr_27936_27966[(1)] = (14));

} else {
var statearr_27937_27967 = state_27911__$1;
(statearr_27937_27967[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (9))){
var inst_27899 = (state_27911[(2)]);
var inst_27900 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_27911__$1 = (function (){var statearr_27938 = state_27911;
(statearr_27938[(15)] = inst_27899);

return statearr_27938;
})();
if(cljs.core.truth_(inst_27900)){
var statearr_27939_27968 = state_27911__$1;
(statearr_27939_27968[(1)] = (21));

} else {
var statearr_27940_27969 = state_27911__$1;
(statearr_27940_27969[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (5))){
var inst_27855 = cljs.core.async.close_BANG_(out);
var state_27911__$1 = state_27911;
var statearr_27941_27970 = state_27911__$1;
(statearr_27941_27970[(2)] = inst_27855);

(statearr_27941_27970[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (14))){
var inst_27877 = (state_27911[(7)]);
var inst_27879 = cljs.core.chunked_seq_QMARK_(inst_27877);
var state_27911__$1 = state_27911;
if(inst_27879){
var statearr_27942_27971 = state_27911__$1;
(statearr_27942_27971[(1)] = (17));

} else {
var statearr_27943_27972 = state_27911__$1;
(statearr_27943_27972[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (16))){
var inst_27895 = (state_27911[(2)]);
var state_27911__$1 = state_27911;
var statearr_27944_27973 = state_27911__$1;
(statearr_27944_27973[(2)] = inst_27895);

(statearr_27944_27973[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27912 === (10))){
var inst_27864 = (state_27911[(8)]);
var inst_27866 = (state_27911[(11)]);
var inst_27871 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(inst_27864,inst_27866);
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27911__$1,(13),out,inst_27871);
} else {
if((state_val_27912 === (18))){
var inst_27877 = (state_27911[(7)]);
var inst_27886 = cljs.core.first(inst_27877);
var state_27911__$1 = state_27911;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_27911__$1,(20),out,inst_27886);
} else {
if((state_val_27912 === (8))){
var inst_27865 = (state_27911[(10)]);
var inst_27866 = (state_27911[(11)]);
var inst_27868 = (inst_27866 < inst_27865);
var inst_27869 = inst_27868;
var state_27911__$1 = state_27911;
if(cljs.core.truth_(inst_27869)){
var statearr_27945_27974 = state_27911__$1;
(statearr_27945_27974[(1)] = (10));

} else {
var statearr_27946_27975 = state_27911__$1;
(statearr_27946_27975[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_27947 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27947[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__);

(statearr_27947[(1)] = (1));

return statearr_27947;
});
var cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____1 = (function (state_27911){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_27911);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e27948){var ex__24301__auto__ = e27948;
var statearr_27949_27976 = state_27911;
(statearr_27949_27976[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_27911[(4)]))){
var statearr_27950_27977 = state_27911;
(statearr_27950_27977[(1)] = cljs.core.first((state_27911[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__27978 = state_27911;
state_27911 = G__27978;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__ = function(state_27911){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____1.call(this,state_27911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__24298__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_27951 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_27951[(6)] = c__24424__auto__);

return statearr_27951;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__27980 = arguments.length;
switch (G__27980) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__27983 = arguments.length;
switch (G__27983) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__27986 = arguments.length;
switch (G__27986) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___28034 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_28010){
var state_val_28011 = (state_28010[(1)]);
if((state_val_28011 === (7))){
var inst_28005 = (state_28010[(2)]);
var state_28010__$1 = state_28010;
var statearr_28012_28035 = state_28010__$1;
(statearr_28012_28035[(2)] = inst_28005);

(statearr_28012_28035[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (1))){
var inst_27987 = null;
var state_28010__$1 = (function (){var statearr_28013 = state_28010;
(statearr_28013[(7)] = inst_27987);

return statearr_28013;
})();
var statearr_28014_28036 = state_28010__$1;
(statearr_28014_28036[(2)] = null);

(statearr_28014_28036[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (4))){
var inst_27990 = (state_28010[(8)]);
var inst_27990__$1 = (state_28010[(2)]);
var inst_27991 = (inst_27990__$1 == null);
var inst_27992 = cljs.core.not(inst_27991);
var state_28010__$1 = (function (){var statearr_28015 = state_28010;
(statearr_28015[(8)] = inst_27990__$1);

return statearr_28015;
})();
if(inst_27992){
var statearr_28016_28037 = state_28010__$1;
(statearr_28016_28037[(1)] = (5));

} else {
var statearr_28017_28038 = state_28010__$1;
(statearr_28017_28038[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (6))){
var state_28010__$1 = state_28010;
var statearr_28018_28039 = state_28010__$1;
(statearr_28018_28039[(2)] = null);

(statearr_28018_28039[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (3))){
var inst_28007 = (state_28010[(2)]);
var inst_28008 = cljs.core.async.close_BANG_(out);
var state_28010__$1 = (function (){var statearr_28019 = state_28010;
(statearr_28019[(9)] = inst_28007);

return statearr_28019;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_28010__$1,inst_28008);
} else {
if((state_val_28011 === (2))){
var state_28010__$1 = state_28010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28010__$1,(4),ch);
} else {
if((state_val_28011 === (11))){
var inst_27990 = (state_28010[(8)]);
var inst_27999 = (state_28010[(2)]);
var inst_27987 = inst_27990;
var state_28010__$1 = (function (){var statearr_28020 = state_28010;
(statearr_28020[(7)] = inst_27987);

(statearr_28020[(10)] = inst_27999);

return statearr_28020;
})();
var statearr_28021_28040 = state_28010__$1;
(statearr_28021_28040[(2)] = null);

(statearr_28021_28040[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (9))){
var inst_27990 = (state_28010[(8)]);
var state_28010__$1 = state_28010;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28010__$1,(11),out,inst_27990);
} else {
if((state_val_28011 === (5))){
var inst_27987 = (state_28010[(7)]);
var inst_27990 = (state_28010[(8)]);
var inst_27994 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_27990,inst_27987);
var state_28010__$1 = state_28010;
if(inst_27994){
var statearr_28023_28041 = state_28010__$1;
(statearr_28023_28041[(1)] = (8));

} else {
var statearr_28024_28042 = state_28010__$1;
(statearr_28024_28042[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (10))){
var inst_28002 = (state_28010[(2)]);
var state_28010__$1 = state_28010;
var statearr_28025_28043 = state_28010__$1;
(statearr_28025_28043[(2)] = inst_28002);

(statearr_28025_28043[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28011 === (8))){
var inst_27987 = (state_28010[(7)]);
var tmp28022 = inst_27987;
var inst_27987__$1 = tmp28022;
var state_28010__$1 = (function (){var statearr_28026 = state_28010;
(statearr_28026[(7)] = inst_27987__$1);

return statearr_28026;
})();
var statearr_28027_28044 = state_28010__$1;
(statearr_28027_28044[(2)] = null);

(statearr_28027_28044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_28028 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_28028[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_28028[(1)] = (1));

return statearr_28028;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_28010){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_28010);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e28029){var ex__24301__auto__ = e28029;
var statearr_28030_28045 = state_28010;
(statearr_28030_28045[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_28010[(4)]))){
var statearr_28031_28046 = state_28010;
(statearr_28031_28046[(1)] = cljs.core.first((state_28010[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__28047 = state_28010;
state_28010 = G__28047;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_28010){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_28010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_28032 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_28032[(6)] = c__24424__auto___28034);

return statearr_28032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__28049 = arguments.length;
switch (G__28049) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___28116 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_28087){
var state_val_28088 = (state_28087[(1)]);
if((state_val_28088 === (7))){
var inst_28083 = (state_28087[(2)]);
var state_28087__$1 = state_28087;
var statearr_28089_28117 = state_28087__$1;
(statearr_28089_28117[(2)] = inst_28083);

(statearr_28089_28117[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (1))){
var inst_28050 = (new Array(n));
var inst_28051 = inst_28050;
var inst_28052 = (0);
var state_28087__$1 = (function (){var statearr_28090 = state_28087;
(statearr_28090[(7)] = inst_28052);

(statearr_28090[(8)] = inst_28051);

return statearr_28090;
})();
var statearr_28091_28118 = state_28087__$1;
(statearr_28091_28118[(2)] = null);

(statearr_28091_28118[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (4))){
var inst_28055 = (state_28087[(9)]);
var inst_28055__$1 = (state_28087[(2)]);
var inst_28056 = (inst_28055__$1 == null);
var inst_28057 = cljs.core.not(inst_28056);
var state_28087__$1 = (function (){var statearr_28092 = state_28087;
(statearr_28092[(9)] = inst_28055__$1);

return statearr_28092;
})();
if(inst_28057){
var statearr_28093_28119 = state_28087__$1;
(statearr_28093_28119[(1)] = (5));

} else {
var statearr_28094_28120 = state_28087__$1;
(statearr_28094_28120[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (15))){
var inst_28077 = (state_28087[(2)]);
var state_28087__$1 = state_28087;
var statearr_28095_28121 = state_28087__$1;
(statearr_28095_28121[(2)] = inst_28077);

(statearr_28095_28121[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (13))){
var state_28087__$1 = state_28087;
var statearr_28096_28122 = state_28087__$1;
(statearr_28096_28122[(2)] = null);

(statearr_28096_28122[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (6))){
var inst_28052 = (state_28087[(7)]);
var inst_28073 = (inst_28052 > (0));
var state_28087__$1 = state_28087;
if(cljs.core.truth_(inst_28073)){
var statearr_28097_28123 = state_28087__$1;
(statearr_28097_28123[(1)] = (12));

} else {
var statearr_28098_28124 = state_28087__$1;
(statearr_28098_28124[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (3))){
var inst_28085 = (state_28087[(2)]);
var state_28087__$1 = state_28087;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28087__$1,inst_28085);
} else {
if((state_val_28088 === (12))){
var inst_28051 = (state_28087[(8)]);
var inst_28075 = cljs.core.vec(inst_28051);
var state_28087__$1 = state_28087;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28087__$1,(15),out,inst_28075);
} else {
if((state_val_28088 === (2))){
var state_28087__$1 = state_28087;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28087__$1,(4),ch);
} else {
if((state_val_28088 === (11))){
var inst_28067 = (state_28087[(2)]);
var inst_28068 = (new Array(n));
var inst_28051 = inst_28068;
var inst_28052 = (0);
var state_28087__$1 = (function (){var statearr_28099 = state_28087;
(statearr_28099[(7)] = inst_28052);

(statearr_28099[(10)] = inst_28067);

(statearr_28099[(8)] = inst_28051);

return statearr_28099;
})();
var statearr_28100_28125 = state_28087__$1;
(statearr_28100_28125[(2)] = null);

(statearr_28100_28125[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (9))){
var inst_28051 = (state_28087[(8)]);
var inst_28065 = cljs.core.vec(inst_28051);
var state_28087__$1 = state_28087;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28087__$1,(11),out,inst_28065);
} else {
if((state_val_28088 === (5))){
var inst_28052 = (state_28087[(7)]);
var inst_28060 = (state_28087[(11)]);
var inst_28055 = (state_28087[(9)]);
var inst_28051 = (state_28087[(8)]);
var inst_28059 = (inst_28051[inst_28052] = inst_28055);
var inst_28060__$1 = (inst_28052 + (1));
var inst_28061 = (inst_28060__$1 < n);
var state_28087__$1 = (function (){var statearr_28101 = state_28087;
(statearr_28101[(11)] = inst_28060__$1);

(statearr_28101[(12)] = inst_28059);

return statearr_28101;
})();
if(cljs.core.truth_(inst_28061)){
var statearr_28102_28126 = state_28087__$1;
(statearr_28102_28126[(1)] = (8));

} else {
var statearr_28103_28127 = state_28087__$1;
(statearr_28103_28127[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (14))){
var inst_28080 = (state_28087[(2)]);
var inst_28081 = cljs.core.async.close_BANG_(out);
var state_28087__$1 = (function (){var statearr_28105 = state_28087;
(statearr_28105[(13)] = inst_28080);

return statearr_28105;
})();
var statearr_28106_28128 = state_28087__$1;
(statearr_28106_28128[(2)] = inst_28081);

(statearr_28106_28128[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (10))){
var inst_28071 = (state_28087[(2)]);
var state_28087__$1 = state_28087;
var statearr_28107_28129 = state_28087__$1;
(statearr_28107_28129[(2)] = inst_28071);

(statearr_28107_28129[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28088 === (8))){
var inst_28060 = (state_28087[(11)]);
var inst_28051 = (state_28087[(8)]);
var tmp28104 = inst_28051;
var inst_28051__$1 = tmp28104;
var inst_28052 = inst_28060;
var state_28087__$1 = (function (){var statearr_28108 = state_28087;
(statearr_28108[(7)] = inst_28052);

(statearr_28108[(8)] = inst_28051__$1);

return statearr_28108;
})();
var statearr_28109_28130 = state_28087__$1;
(statearr_28109_28130[(2)] = null);

(statearr_28109_28130[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_28110 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28110[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_28110[(1)] = (1));

return statearr_28110;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_28087){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_28087);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e28111){var ex__24301__auto__ = e28111;
var statearr_28112_28131 = state_28087;
(statearr_28112_28131[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_28087[(4)]))){
var statearr_28113_28132 = state_28087;
(statearr_28113_28132[(1)] = cljs.core.first((state_28087[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__28133 = state_28087;
state_28087 = G__28133;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_28087){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_28087);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_28114 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_28114[(6)] = c__24424__auto___28116);

return statearr_28114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__28135 = arguments.length;
switch (G__28135) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__24424__auto___28213 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_28180){
var state_val_28181 = (state_28180[(1)]);
if((state_val_28181 === (7))){
var inst_28176 = (state_28180[(2)]);
var state_28180__$1 = state_28180;
var statearr_28182_28214 = state_28180__$1;
(statearr_28182_28214[(2)] = inst_28176);

(statearr_28182_28214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (1))){
var inst_28136 = [];
var inst_28137 = inst_28136;
var inst_28138 = cljs.core.cst$kw$cljs$core$async_SLASH_nothing;
var state_28180__$1 = (function (){var statearr_28183 = state_28180;
(statearr_28183[(7)] = inst_28138);

(statearr_28183[(8)] = inst_28137);

return statearr_28183;
})();
var statearr_28184_28215 = state_28180__$1;
(statearr_28184_28215[(2)] = null);

(statearr_28184_28215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (4))){
var inst_28141 = (state_28180[(9)]);
var inst_28141__$1 = (state_28180[(2)]);
var inst_28142 = (inst_28141__$1 == null);
var inst_28143 = cljs.core.not(inst_28142);
var state_28180__$1 = (function (){var statearr_28185 = state_28180;
(statearr_28185[(9)] = inst_28141__$1);

return statearr_28185;
})();
if(inst_28143){
var statearr_28186_28216 = state_28180__$1;
(statearr_28186_28216[(1)] = (5));

} else {
var statearr_28187_28217 = state_28180__$1;
(statearr_28187_28217[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (15))){
var inst_28137 = (state_28180[(8)]);
var inst_28168 = cljs.core.vec(inst_28137);
var state_28180__$1 = state_28180;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28180__$1,(18),out,inst_28168);
} else {
if((state_val_28181 === (13))){
var inst_28163 = (state_28180[(2)]);
var state_28180__$1 = state_28180;
var statearr_28188_28218 = state_28180__$1;
(statearr_28188_28218[(2)] = inst_28163);

(statearr_28188_28218[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (6))){
var inst_28137 = (state_28180[(8)]);
var inst_28165 = inst_28137.length;
var inst_28166 = (inst_28165 > (0));
var state_28180__$1 = state_28180;
if(cljs.core.truth_(inst_28166)){
var statearr_28189_28219 = state_28180__$1;
(statearr_28189_28219[(1)] = (15));

} else {
var statearr_28190_28220 = state_28180__$1;
(statearr_28190_28220[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (17))){
var inst_28173 = (state_28180[(2)]);
var inst_28174 = cljs.core.async.close_BANG_(out);
var state_28180__$1 = (function (){var statearr_28191 = state_28180;
(statearr_28191[(10)] = inst_28173);

return statearr_28191;
})();
var statearr_28192_28221 = state_28180__$1;
(statearr_28192_28221[(2)] = inst_28174);

(statearr_28192_28221[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (3))){
var inst_28178 = (state_28180[(2)]);
var state_28180__$1 = state_28180;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28180__$1,inst_28178);
} else {
if((state_val_28181 === (12))){
var inst_28137 = (state_28180[(8)]);
var inst_28156 = cljs.core.vec(inst_28137);
var state_28180__$1 = state_28180;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_28180__$1,(14),out,inst_28156);
} else {
if((state_val_28181 === (2))){
var state_28180__$1 = state_28180;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28180__$1,(4),ch);
} else {
if((state_val_28181 === (11))){
var inst_28141 = (state_28180[(9)]);
var inst_28137 = (state_28180[(8)]);
var inst_28145 = (state_28180[(11)]);
var inst_28153 = inst_28137.push(inst_28141);
var tmp28193 = inst_28137;
var inst_28137__$1 = tmp28193;
var inst_28138 = inst_28145;
var state_28180__$1 = (function (){var statearr_28194 = state_28180;
(statearr_28194[(12)] = inst_28153);

(statearr_28194[(7)] = inst_28138);

(statearr_28194[(8)] = inst_28137__$1);

return statearr_28194;
})();
var statearr_28195_28222 = state_28180__$1;
(statearr_28195_28222[(2)] = null);

(statearr_28195_28222[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (9))){
var inst_28138 = (state_28180[(7)]);
var inst_28149 = cljs.core.keyword_identical_QMARK_(inst_28138,cljs.core.cst$kw$cljs$core$async_SLASH_nothing);
var state_28180__$1 = state_28180;
var statearr_28196_28223 = state_28180__$1;
(statearr_28196_28223[(2)] = inst_28149);

(statearr_28196_28223[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (5))){
var inst_28141 = (state_28180[(9)]);
var inst_28138 = (state_28180[(7)]);
var inst_28146 = (state_28180[(13)]);
var inst_28145 = (state_28180[(11)]);
var inst_28145__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_28141) : f.call(null,inst_28141));
var inst_28146__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28145__$1,inst_28138);
var state_28180__$1 = (function (){var statearr_28197 = state_28180;
(statearr_28197[(13)] = inst_28146__$1);

(statearr_28197[(11)] = inst_28145__$1);

return statearr_28197;
})();
if(inst_28146__$1){
var statearr_28198_28224 = state_28180__$1;
(statearr_28198_28224[(1)] = (8));

} else {
var statearr_28199_28225 = state_28180__$1;
(statearr_28199_28225[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (14))){
var inst_28141 = (state_28180[(9)]);
var inst_28145 = (state_28180[(11)]);
var inst_28158 = (state_28180[(2)]);
var inst_28159 = [];
var inst_28160 = inst_28159.push(inst_28141);
var inst_28137 = inst_28159;
var inst_28138 = inst_28145;
var state_28180__$1 = (function (){var statearr_28200 = state_28180;
(statearr_28200[(7)] = inst_28138);

(statearr_28200[(14)] = inst_28158);

(statearr_28200[(8)] = inst_28137);

(statearr_28200[(15)] = inst_28160);

return statearr_28200;
})();
var statearr_28201_28226 = state_28180__$1;
(statearr_28201_28226[(2)] = null);

(statearr_28201_28226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (16))){
var state_28180__$1 = state_28180;
var statearr_28202_28227 = state_28180__$1;
(statearr_28202_28227[(2)] = null);

(statearr_28202_28227[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (10))){
var inst_28151 = (state_28180[(2)]);
var state_28180__$1 = state_28180;
if(cljs.core.truth_(inst_28151)){
var statearr_28203_28228 = state_28180__$1;
(statearr_28203_28228[(1)] = (11));

} else {
var statearr_28204_28229 = state_28180__$1;
(statearr_28204_28229[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (18))){
var inst_28170 = (state_28180[(2)]);
var state_28180__$1 = state_28180;
var statearr_28205_28230 = state_28180__$1;
(statearr_28205_28230[(2)] = inst_28170);

(statearr_28205_28230[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28181 === (8))){
var inst_28146 = (state_28180[(13)]);
var state_28180__$1 = state_28180;
var statearr_28206_28231 = state_28180__$1;
(statearr_28206_28231[(2)] = inst_28146);

(statearr_28206_28231[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__24298__auto__ = null;
var cljs$core$async$state_machine__24298__auto____0 = (function (){
var statearr_28207 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28207[(0)] = cljs$core$async$state_machine__24298__auto__);

(statearr_28207[(1)] = (1));

return statearr_28207;
});
var cljs$core$async$state_machine__24298__auto____1 = (function (state_28180){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_28180);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e28208){var ex__24301__auto__ = e28208;
var statearr_28209_28232 = state_28180;
(statearr_28209_28232[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_28180[(4)]))){
var statearr_28210_28233 = state_28180;
(statearr_28210_28233[(1)] = cljs.core.first((state_28180[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__28234 = state_28180;
state_28180 = G__28234;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
cljs$core$async$state_machine__24298__auto__ = function(state_28180){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__24298__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__24298__auto____1.call(this,state_28180);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__24298__auto____0;
cljs$core$async$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__24298__auto____1;
return cljs$core$async$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_28211 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_28211[(6)] = c__24424__auto___28213);

return statearr_28211;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);

