// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.source_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('goog.object');
goog.require('clojure.string');
goog.require('clojure.set');
goog.require('cljs.source_map.base64_vlq');
/**
 * Take a seq of source file names and return a map from
 * file number to integer index. For reverse source maps.
 */
cljs.source_map.indexed_sources = (function cljs$source_map$indexed_sources(sources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,p__15576){
var vec__15577 = p__15576;
var i = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15577,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15577,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,v,i);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (a,b){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [a,b], null);
}),sources));
});
/**
 * Take a seq of source file names and return a comparator
 * that can be used to construct a sorted map. For reverse
 * source maps.
 */
cljs.source_map.source_compare = (function cljs$source_map$source_compare(sources){
var sources__$1 = cljs.source_map.indexed_sources(sources);
return (function (a,b){
return cljs.core.compare((sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(a) : sources__$1.call(null,a)),(sources__$1.cljs$core$IFn$_invoke$arity$1 ? sources__$1.cljs$core$IFn$_invoke$arity$1(b) : sources__$1.call(null,b)));
});
});
/**
 * Take a source map segment represented as a vector
 * and return a map.
 */
cljs.source_map.seg__GT_map = (function cljs$source_map$seg__GT_map(seg,source_map){
var vec__15580 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15580,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15580,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15580,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15580,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15580,(4),null);
return new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$gcol,gcol,cljs.core.cst$kw$source,(goog.object.get(source_map,"sources")[source]),cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$name,(function (){var temp__5753__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(seg));
if(cljs.core.truth_(temp__5753__auto__)){
var name__$1 = temp__5753__auto__;
return (goog.object.get(source_map,"names")[name__$1]);
} else {
return null;
}
})()], null);
});
/**
 * Combine a source map segment vector and a relative
 * source map segment vector and combine them to get
 * an absolute segment posititon information as a vector.
 */
cljs.source_map.seg_combine = (function cljs$source_map$seg_combine(seg,relseg){
var vec__15583 = seg;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15583,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15583,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15583,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15583,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15583,(4),null);
var vec__15586 = relseg;
var rgcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586,(0),null);
var rsource = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586,(1),null);
var rline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586,(2),null);
var rcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586,(3),null);
var rname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15586,(4),null);
var nseg = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(gcol + rgcol),((function (){var or__4212__auto__ = source;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rsource),((function (){var or__4212__auto__ = line;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rline),((function (){var or__4212__auto__ = col;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rcol),((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})() + rname)], null);
if(cljs.core.truth_(name)){
return cljs.core.with_meta(nseg,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$name,(name + rname)], null));
} else {
return nseg;
}
});
/**
 * Helper for decode-reverse. Take a reverse source map and
 *   update it with a segment map.
 */
cljs.source_map.update_reverse_result = (function cljs$source_map$update_reverse_result(result,segmap,gline){
var map__15589 = segmap;
var map__15589__$1 = cljs.core.__destructure_map(map__15589);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15589__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15589__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15589__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15589__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15589__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gline,gline,cljs.core.cst$kw$gcol,gcol], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [source], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [line], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [col], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (v){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(v,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a reverse source map
 *   mapping original ClojureScript source locations to the generated
 *   JavaScript.
 */
cljs.source_map.decode_reverse = (function cljs$source_map$decode_reverse(var_args){
var G__15591 = arguments.length;
switch (G__15591) {
case 1:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode_reverse.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.sorted_map_by(cljs.source_map.source_compare(sources));
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__15595 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__15599 = cljs.core.next(segs__$1);
var G__15600 = nrelseg;
var G__15601 = cljs.source_map.update_reverse_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__15599;
relseg__$1 = G__15600;
result__$1 = G__15601;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15595,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15595,(1),null);
var G__15602 = (gline + (1));
var G__15603 = cljs.core.next(lines__$1);
var G__15604 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__15605 = result__$1;
gline = G__15602;
lines__$1 = G__15603;
relseg = G__15604;
result = G__15605;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode_reverse.cljs$lang$maxFixedArity = 2);

/**
 * Helper for decode. Take a source map and update it based on a
 *   segment map.
 */
cljs.source_map.update_result = (function cljs$source_map$update_result(result,segmap,gline){
var map__15607 = segmap;
var map__15607__$1 = cljs.core.__destructure_map(map__15607);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,cljs.core.cst$kw$gcol);
var source = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,cljs.core.cst$kw$source);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,cljs.core.cst$kw$line);
var col = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,cljs.core.cst$kw$col);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__15607__$1,cljs.core.cst$kw$name);
var d = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$col,col,cljs.core.cst$kw$source,source], null);
var d__$1 = (cljs.core.truth_(name)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(d,cljs.core.cst$kw$name,name):d);
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(result,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (m){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (p1__15606_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__15606_SHARP_,d__$1);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
});
/**
 * Convert a v3 source map JSON object into a source map mapping
 *   generated JavaScript source locations to the original
 *   ClojureScript.
 */
cljs.source_map.decode = (function cljs$source_map$decode(var_args){
var G__15609 = arguments.length;
switch (G__15609) {
case 1:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$1 = (function (source_map){
return cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2(goog.object.get(source_map,"mappings"),source_map);
}));

(cljs.source_map.decode.cljs$core$IFn$_invoke$arity$2 = (function (mappings,source_map){
var sources = goog.object.get(source_map,"sources");
var relseg_init = new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null);
var lines = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(mappings,/;/));
var gline = (0);
var lines__$1 = lines;
var relseg = relseg_init;
var result = cljs.core.PersistentArrayMap.EMPTY;
while(true){
if(lines__$1){
var line = cljs.core.first(lines__$1);
var vec__15613 = ((clojure.string.blank_QMARK_(line))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result,relseg], null):(function (){var segs = cljs.core.seq(clojure.string.split.cljs$core$IFn$_invoke$arity$2(line,/,/));
var segs__$1 = segs;
var relseg__$1 = relseg;
var result__$1 = result;
while(true){
if(segs__$1){
var seg = cljs.core.first(segs__$1);
var nrelseg = cljs.source_map.seg_combine(cljs.source_map.base64_vlq.decode(seg),relseg__$1);
var G__15617 = cljs.core.next(segs__$1);
var G__15618 = nrelseg;
var G__15619 = cljs.source_map.update_result(result__$1,cljs.source_map.seg__GT_map(nrelseg,source_map),gline);
segs__$1 = G__15617;
relseg__$1 = G__15618;
result__$1 = G__15619;
continue;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [result__$1,relseg__$1], null);
}
break;
}
})());
var result__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15613,(0),null);
var relseg__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15613,(1),null);
var G__15620 = (gline + (1));
var G__15621 = cljs.core.next(lines__$1);
var G__15622 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(relseg__$1,(0),(0));
var G__15623 = result__$1;
gline = G__15620;
lines__$1 = G__15621;
relseg = G__15622;
result = G__15623;
continue;
} else {
return result;
}
break;
}
}));

(cljs.source_map.decode.cljs$lang$maxFixedArity = 2);

/**
 * Take a nested sorted map encoding line and column information
 * for a file and return a vector of vectors of encoded segments.
 * Each vector represents a line, and the internal vectors are segments
 * representing the contents of the line.
 */
cljs.source_map.lines__GT_segs = (function cljs$source_map$lines__GT_segs(lines){
var relseg = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),(0),(0),(0),(0)], null));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (segs,cols){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__15624){
var vec__15625 = p__15624;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15625,(0),null);
var source = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15625,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15625,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15625,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15625,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0),source,line,col,name], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (cols__$1,p__15628){
var vec__15629 = p__15628;
var gcol = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15629,(0),null);
var sidx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15629,(1),null);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15629,(2),null);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15629,(3),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15629,(4),null);
var seg = vec__15629;
var offset = cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core._,seg,cljs.core.deref(relseg));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(relseg,(function (p__15632){
var vec__15633 = p__15632;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15633,(0),null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15633,(1),null);
var ___$2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15633,(2),null);
var ___$3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15633,(3),null);
var lname = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15633,(4),null);
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol,sidx,line,col,(function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return lname;
}
})()], null);
}));

return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cols__$1,cljs.source_map.base64_vlq.encode(offset));
}),cljs.core.PersistentVector.EMPTY,cols));
}),cljs.core.PersistentVector.EMPTY,lines);
});
/**
 * Take an internal source map representation represented as nested
 * sorted maps of file, line, column and return a source map v3 JSON
 * string.
 */
cljs.source_map.encode = (function cljs$source_map$encode(m,opts){
var lines = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentVector.EMPTY], null));
var names__GT_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var name_idx = cljs.core.atom.cljs$core$IFn$_invoke$arity$1((0));
var preamble_lines = cljs.core.take.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = cljs.core.cst$kw$preamble_DASH_line_DASH_count.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentVector.EMPTY));
var info__GT_segv = (function (info,source_idx,line,col){
var segv = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$gcol.cljs$core$IFn$_invoke$arity$1(info),source_idx,line,col], null);
var temp__5751__auto__ = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
if(cljs.core.truth_(temp__5751__auto__)){
var name = temp__5751__auto__;
var idx = (function (){var temp__5751__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(names__GT_idx),name);
if(cljs.core.truth_(temp__5751__auto____$1)){
var idx = temp__5751__auto____$1;
return idx;
} else {
var cidx = cljs.core.deref(name_idx);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(names__GT_idx,cljs.core.assoc,name,cidx);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(name_idx,cljs.core.inc);

return cidx;
}
})();
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(segv,idx);
} else {
return segv;
}
});
var encode_cols = (function (infos,source_idx,line,col){
var seq__15639 = cljs.core.seq(infos);
var chunk__15640 = null;
var count__15641 = (0);
var i__15642 = (0);
while(true){
if((i__15642 < count__15641)){
var info = chunk__15640.cljs$core$IIndexed$_nth$arity$2(null,i__15642);
var segv_15993 = info__GT_segv(info,source_idx,line,col);
var gline_15994 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_15995 = cljs.core.count(cljs.core.deref(lines));
if((gline_15994 > (lc_15995 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__15639,chunk__15640,count__15641,i__15642,segv_15993,gline_15994,lc_15995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_15994 - (lc_15995 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_15993], null));
});})(seq__15639,chunk__15640,count__15641,i__15642,segv_15993,gline_15994,lc_15995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__15639,chunk__15640,count__15641,i__15642,segv_15993,gline_15994,lc_15995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_15994], null),cljs.core.conj,segv_15993);
});})(seq__15639,chunk__15640,count__15641,i__15642,segv_15993,gline_15994,lc_15995,info,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__15996 = seq__15639;
var G__15997 = chunk__15640;
var G__15998 = count__15641;
var G__15999 = (i__15642 + (1));
seq__15639 = G__15996;
chunk__15640 = G__15997;
count__15641 = G__15998;
i__15642 = G__15999;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__15639);
if(temp__5753__auto__){
var seq__15639__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__15639__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__15639__$1);
var G__16000 = cljs.core.chunk_rest(seq__15639__$1);
var G__16001 = c__4638__auto__;
var G__16002 = cljs.core.count(c__4638__auto__);
var G__16003 = (0);
seq__15639 = G__16000;
chunk__15640 = G__16001;
count__15641 = G__16002;
i__15642 = G__16003;
continue;
} else {
var info = cljs.core.first(seq__15639__$1);
var segv_16004 = info__GT_segv(info,source_idx,line,col);
var gline_16005 = cljs.core.cst$kw$gline.cljs$core$IFn$_invoke$arity$1(info);
var lc_16006 = cljs.core.count(cljs.core.deref(lines));
if((gline_16005 > (lc_16006 - (1)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__15639,chunk__15640,count__15641,i__15642,segv_16004,gline_16005,lc_16006,info,seq__15639__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(lines__$1,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(((gline_16005 - (lc_16006 - (1))) - (1)),cljs.core.PersistentVector.EMPTY)),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [segv_16004], null));
});})(seq__15639,chunk__15640,count__15641,i__15642,segv_16004,gline_16005,lc_16006,info,seq__15639__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(lines,((function (seq__15639,chunk__15640,count__15641,i__15642,segv_16004,gline_16005,lc_16006,info,seq__15639__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv){
return (function (lines__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(lines__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16005], null),cljs.core.conj,segv_16004);
});})(seq__15639,chunk__15640,count__15641,i__15642,segv_16004,gline_16005,lc_16006,info,seq__15639__$1,temp__5753__auto__,lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv))
);
}


var G__16007 = cljs.core.next(seq__15639__$1);
var G__16008 = null;
var G__16009 = (0);
var G__16010 = (0);
seq__15639 = G__16007;
chunk__15640 = G__16008;
count__15641 = G__16009;
i__15642 = G__16010;
continue;
}
} else {
return null;
}
}
break;
}
});
var seq__15643_16011 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(((function (lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols){
return (function (i,v){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [i,v], null);
});})(lines,names__GT_idx,name_idx,preamble_lines,info__GT_segv,encode_cols))
,m));
var chunk__15644_16012 = null;
var count__15645_16013 = (0);
var i__15646_16014 = (0);
while(true){
if((i__15646_16014 < count__15645_16013)){
var vec__15819_16015 = chunk__15644_16012.cljs$core$IIndexed$_nth$arity$2(null,i__15646_16014);
var source_idx_16016 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15819_16015,(0),null);
var vec__15822_16017 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15819_16015,(1),null);
var __16018 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15822_16017,(0),null);
var lines_16019__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15822_16017,(1),null);
var seq__15825_16020 = cljs.core.seq(lines_16019__$1);
var chunk__15826_16021 = null;
var count__15827_16022 = (0);
var i__15828_16023 = (0);
while(true){
if((i__15828_16023 < count__15827_16022)){
var vec__15867_16024 = chunk__15826_16021.cljs$core$IIndexed$_nth$arity$2(null,i__15828_16023);
var line_16025 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15867_16024,(0),null);
var cols_16026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15867_16024,(1),null);
var seq__15870_16027 = cljs.core.seq(cols_16026);
var chunk__15871_16028 = null;
var count__15872_16029 = (0);
var i__15873_16030 = (0);
while(true){
if((i__15873_16030 < count__15872_16029)){
var vec__15880_16031 = chunk__15871_16028.cljs$core$IIndexed$_nth$arity$2(null,i__15873_16030);
var col_16032 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15880_16031,(0),null);
var infos_16033 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15880_16031,(1),null);
encode_cols(infos_16033,source_idx_16016,line_16025,col_16032);


var G__16034 = seq__15870_16027;
var G__16035 = chunk__15871_16028;
var G__16036 = count__15872_16029;
var G__16037 = (i__15873_16030 + (1));
seq__15870_16027 = G__16034;
chunk__15871_16028 = G__16035;
count__15872_16029 = G__16036;
i__15873_16030 = G__16037;
continue;
} else {
var temp__5753__auto___16038 = cljs.core.seq(seq__15870_16027);
if(temp__5753__auto___16038){
var seq__15870_16039__$1 = temp__5753__auto___16038;
if(cljs.core.chunked_seq_QMARK_(seq__15870_16039__$1)){
var c__4638__auto___16040 = cljs.core.chunk_first(seq__15870_16039__$1);
var G__16041 = cljs.core.chunk_rest(seq__15870_16039__$1);
var G__16042 = c__4638__auto___16040;
var G__16043 = cljs.core.count(c__4638__auto___16040);
var G__16044 = (0);
seq__15870_16027 = G__16041;
chunk__15871_16028 = G__16042;
count__15872_16029 = G__16043;
i__15873_16030 = G__16044;
continue;
} else {
var vec__15883_16045 = cljs.core.first(seq__15870_16039__$1);
var col_16046 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15883_16045,(0),null);
var infos_16047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15883_16045,(1),null);
encode_cols(infos_16047,source_idx_16016,line_16025,col_16046);


var G__16048 = cljs.core.next(seq__15870_16039__$1);
var G__16049 = null;
var G__16050 = (0);
var G__16051 = (0);
seq__15870_16027 = G__16048;
chunk__15871_16028 = G__16049;
count__15872_16029 = G__16050;
i__15873_16030 = G__16051;
continue;
}
} else {
}
}
break;
}


var G__16052 = seq__15825_16020;
var G__16053 = chunk__15826_16021;
var G__16054 = count__15827_16022;
var G__16055 = (i__15828_16023 + (1));
seq__15825_16020 = G__16052;
chunk__15826_16021 = G__16053;
count__15827_16022 = G__16054;
i__15828_16023 = G__16055;
continue;
} else {
var temp__5753__auto___16056 = cljs.core.seq(seq__15825_16020);
if(temp__5753__auto___16056){
var seq__15825_16057__$1 = temp__5753__auto___16056;
if(cljs.core.chunked_seq_QMARK_(seq__15825_16057__$1)){
var c__4638__auto___16058 = cljs.core.chunk_first(seq__15825_16057__$1);
var G__16059 = cljs.core.chunk_rest(seq__15825_16057__$1);
var G__16060 = c__4638__auto___16058;
var G__16061 = cljs.core.count(c__4638__auto___16058);
var G__16062 = (0);
seq__15825_16020 = G__16059;
chunk__15826_16021 = G__16060;
count__15827_16022 = G__16061;
i__15828_16023 = G__16062;
continue;
} else {
var vec__15886_16063 = cljs.core.first(seq__15825_16057__$1);
var line_16064 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15886_16063,(0),null);
var cols_16065 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15886_16063,(1),null);
var seq__15889_16066 = cljs.core.seq(cols_16065);
var chunk__15890_16067 = null;
var count__15891_16068 = (0);
var i__15892_16069 = (0);
while(true){
if((i__15892_16069 < count__15891_16068)){
var vec__15899_16070 = chunk__15890_16067.cljs$core$IIndexed$_nth$arity$2(null,i__15892_16069);
var col_16071 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15899_16070,(0),null);
var infos_16072 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15899_16070,(1),null);
encode_cols(infos_16072,source_idx_16016,line_16064,col_16071);


var G__16073 = seq__15889_16066;
var G__16074 = chunk__15890_16067;
var G__16075 = count__15891_16068;
var G__16076 = (i__15892_16069 + (1));
seq__15889_16066 = G__16073;
chunk__15890_16067 = G__16074;
count__15891_16068 = G__16075;
i__15892_16069 = G__16076;
continue;
} else {
var temp__5753__auto___16077__$1 = cljs.core.seq(seq__15889_16066);
if(temp__5753__auto___16077__$1){
var seq__15889_16078__$1 = temp__5753__auto___16077__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15889_16078__$1)){
var c__4638__auto___16079 = cljs.core.chunk_first(seq__15889_16078__$1);
var G__16080 = cljs.core.chunk_rest(seq__15889_16078__$1);
var G__16081 = c__4638__auto___16079;
var G__16082 = cljs.core.count(c__4638__auto___16079);
var G__16083 = (0);
seq__15889_16066 = G__16080;
chunk__15890_16067 = G__16081;
count__15891_16068 = G__16082;
i__15892_16069 = G__16083;
continue;
} else {
var vec__15902_16084 = cljs.core.first(seq__15889_16078__$1);
var col_16085 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15902_16084,(0),null);
var infos_16086 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15902_16084,(1),null);
encode_cols(infos_16086,source_idx_16016,line_16064,col_16085);


var G__16087 = cljs.core.next(seq__15889_16078__$1);
var G__16088 = null;
var G__16089 = (0);
var G__16090 = (0);
seq__15889_16066 = G__16087;
chunk__15890_16067 = G__16088;
count__15891_16068 = G__16089;
i__15892_16069 = G__16090;
continue;
}
} else {
}
}
break;
}


var G__16091 = cljs.core.next(seq__15825_16057__$1);
var G__16092 = null;
var G__16093 = (0);
var G__16094 = (0);
seq__15825_16020 = G__16091;
chunk__15826_16021 = G__16092;
count__15827_16022 = G__16093;
i__15828_16023 = G__16094;
continue;
}
} else {
}
}
break;
}


var G__16095 = seq__15643_16011;
var G__16096 = chunk__15644_16012;
var G__16097 = count__15645_16013;
var G__16098 = (i__15646_16014 + (1));
seq__15643_16011 = G__16095;
chunk__15644_16012 = G__16096;
count__15645_16013 = G__16097;
i__15646_16014 = G__16098;
continue;
} else {
var temp__5753__auto___16099 = cljs.core.seq(seq__15643_16011);
if(temp__5753__auto___16099){
var seq__15643_16100__$1 = temp__5753__auto___16099;
if(cljs.core.chunked_seq_QMARK_(seq__15643_16100__$1)){
var c__4638__auto___16101 = cljs.core.chunk_first(seq__15643_16100__$1);
var G__16102 = cljs.core.chunk_rest(seq__15643_16100__$1);
var G__16103 = c__4638__auto___16101;
var G__16104 = cljs.core.count(c__4638__auto___16101);
var G__16105 = (0);
seq__15643_16011 = G__16102;
chunk__15644_16012 = G__16103;
count__15645_16013 = G__16104;
i__15646_16014 = G__16105;
continue;
} else {
var vec__15905_16106 = cljs.core.first(seq__15643_16100__$1);
var source_idx_16107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15905_16106,(0),null);
var vec__15908_16108 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15905_16106,(1),null);
var __16109 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15908_16108,(0),null);
var lines_16110__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15908_16108,(1),null);
var seq__15911_16111 = cljs.core.seq(lines_16110__$1);
var chunk__15912_16112 = null;
var count__15913_16113 = (0);
var i__15914_16114 = (0);
while(true){
if((i__15914_16114 < count__15913_16113)){
var vec__15953_16115 = chunk__15912_16112.cljs$core$IIndexed$_nth$arity$2(null,i__15914_16114);
var line_16116 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15953_16115,(0),null);
var cols_16117 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15953_16115,(1),null);
var seq__15956_16118 = cljs.core.seq(cols_16117);
var chunk__15957_16119 = null;
var count__15958_16120 = (0);
var i__15959_16121 = (0);
while(true){
if((i__15959_16121 < count__15958_16120)){
var vec__15966_16122 = chunk__15957_16119.cljs$core$IIndexed$_nth$arity$2(null,i__15959_16121);
var col_16123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15966_16122,(0),null);
var infos_16124 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15966_16122,(1),null);
encode_cols(infos_16124,source_idx_16107,line_16116,col_16123);


var G__16125 = seq__15956_16118;
var G__16126 = chunk__15957_16119;
var G__16127 = count__15958_16120;
var G__16128 = (i__15959_16121 + (1));
seq__15956_16118 = G__16125;
chunk__15957_16119 = G__16126;
count__15958_16120 = G__16127;
i__15959_16121 = G__16128;
continue;
} else {
var temp__5753__auto___16129__$1 = cljs.core.seq(seq__15956_16118);
if(temp__5753__auto___16129__$1){
var seq__15956_16130__$1 = temp__5753__auto___16129__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15956_16130__$1)){
var c__4638__auto___16131 = cljs.core.chunk_first(seq__15956_16130__$1);
var G__16132 = cljs.core.chunk_rest(seq__15956_16130__$1);
var G__16133 = c__4638__auto___16131;
var G__16134 = cljs.core.count(c__4638__auto___16131);
var G__16135 = (0);
seq__15956_16118 = G__16132;
chunk__15957_16119 = G__16133;
count__15958_16120 = G__16134;
i__15959_16121 = G__16135;
continue;
} else {
var vec__15969_16136 = cljs.core.first(seq__15956_16130__$1);
var col_16137 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15969_16136,(0),null);
var infos_16138 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15969_16136,(1),null);
encode_cols(infos_16138,source_idx_16107,line_16116,col_16137);


var G__16139 = cljs.core.next(seq__15956_16130__$1);
var G__16140 = null;
var G__16141 = (0);
var G__16142 = (0);
seq__15956_16118 = G__16139;
chunk__15957_16119 = G__16140;
count__15958_16120 = G__16141;
i__15959_16121 = G__16142;
continue;
}
} else {
}
}
break;
}


var G__16143 = seq__15911_16111;
var G__16144 = chunk__15912_16112;
var G__16145 = count__15913_16113;
var G__16146 = (i__15914_16114 + (1));
seq__15911_16111 = G__16143;
chunk__15912_16112 = G__16144;
count__15913_16113 = G__16145;
i__15914_16114 = G__16146;
continue;
} else {
var temp__5753__auto___16147__$1 = cljs.core.seq(seq__15911_16111);
if(temp__5753__auto___16147__$1){
var seq__15911_16148__$1 = temp__5753__auto___16147__$1;
if(cljs.core.chunked_seq_QMARK_(seq__15911_16148__$1)){
var c__4638__auto___16149 = cljs.core.chunk_first(seq__15911_16148__$1);
var G__16150 = cljs.core.chunk_rest(seq__15911_16148__$1);
var G__16151 = c__4638__auto___16149;
var G__16152 = cljs.core.count(c__4638__auto___16149);
var G__16153 = (0);
seq__15911_16111 = G__16150;
chunk__15912_16112 = G__16151;
count__15913_16113 = G__16152;
i__15914_16114 = G__16153;
continue;
} else {
var vec__15972_16154 = cljs.core.first(seq__15911_16148__$1);
var line_16155 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15972_16154,(0),null);
var cols_16156 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15972_16154,(1),null);
var seq__15975_16157 = cljs.core.seq(cols_16156);
var chunk__15976_16158 = null;
var count__15977_16159 = (0);
var i__15978_16160 = (0);
while(true){
if((i__15978_16160 < count__15977_16159)){
var vec__15985_16161 = chunk__15976_16158.cljs$core$IIndexed$_nth$arity$2(null,i__15978_16160);
var col_16162 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15985_16161,(0),null);
var infos_16163 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15985_16161,(1),null);
encode_cols(infos_16163,source_idx_16107,line_16155,col_16162);


var G__16164 = seq__15975_16157;
var G__16165 = chunk__15976_16158;
var G__16166 = count__15977_16159;
var G__16167 = (i__15978_16160 + (1));
seq__15975_16157 = G__16164;
chunk__15976_16158 = G__16165;
count__15977_16159 = G__16166;
i__15978_16160 = G__16167;
continue;
} else {
var temp__5753__auto___16168__$2 = cljs.core.seq(seq__15975_16157);
if(temp__5753__auto___16168__$2){
var seq__15975_16169__$1 = temp__5753__auto___16168__$2;
if(cljs.core.chunked_seq_QMARK_(seq__15975_16169__$1)){
var c__4638__auto___16170 = cljs.core.chunk_first(seq__15975_16169__$1);
var G__16171 = cljs.core.chunk_rest(seq__15975_16169__$1);
var G__16172 = c__4638__auto___16170;
var G__16173 = cljs.core.count(c__4638__auto___16170);
var G__16174 = (0);
seq__15975_16157 = G__16171;
chunk__15976_16158 = G__16172;
count__15977_16159 = G__16173;
i__15978_16160 = G__16174;
continue;
} else {
var vec__15988_16175 = cljs.core.first(seq__15975_16169__$1);
var col_16176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15988_16175,(0),null);
var infos_16177 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__15988_16175,(1),null);
encode_cols(infos_16177,source_idx_16107,line_16155,col_16176);


var G__16178 = cljs.core.next(seq__15975_16169__$1);
var G__16179 = null;
var G__16180 = (0);
var G__16181 = (0);
seq__15975_16157 = G__16178;
chunk__15976_16158 = G__16179;
count__15977_16159 = G__16180;
i__15978_16160 = G__16181;
continue;
}
} else {
}
}
break;
}


var G__16182 = cljs.core.next(seq__15911_16148__$1);
var G__16183 = null;
var G__16184 = (0);
var G__16185 = (0);
seq__15911_16111 = G__16182;
chunk__15912_16112 = G__16183;
count__15913_16113 = G__16184;
i__15914_16114 = G__16185;
continue;
}
} else {
}
}
break;
}


var G__16186 = cljs.core.next(seq__15643_16100__$1);
var G__16187 = null;
var G__16188 = (0);
var G__16189 = (0);
seq__15643_16011 = G__16186;
chunk__15644_16012 = G__16187;
count__15645_16013 = G__16188;
i__15646_16014 = G__16189;
continue;
}
} else {
}
}
break;
}

var source_map_file_contents = (function (){var G__15991 = ({"version": (3), "file": cljs.core.cst$kw$file.cljs$core$IFn$_invoke$arity$1(opts), "sources": (function (){var paths = cljs.core.keys(m);
var f = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(((cljs.core.cst$kw$source_DASH_map_DASH_timestamp.cljs$core$IFn$_invoke$arity$1(opts) === true)?(function (p1__15636_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__15636_SHARP_),"?rel=",cljs.core.str.cljs$core$IFn$_invoke$arity$1((new Date()).valueOf())].join('');
}):cljs.core.identity),(function (p1__15637_SHARP_){
return cljs.core.last(clojure.string.split.cljs$core$IFn$_invoke$arity$2(p1__15637_SHARP_,/\//));
}));
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(f,paths));
})(), "lineCount": cljs.core.cst$kw$lines.cljs$core$IFn$_invoke$arity$1(opts), "mappings": clojure.string.join.cljs$core$IFn$_invoke$arity$2(";",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__15638_SHARP_){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",p1__15638_SHARP_);
}),cljs.source_map.lines__GT_segs(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(preamble_lines,cljs.core.deref(lines))))), "names": cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.set.map_invert(cljs.core.deref(names__GT_idx)),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.deref(names__GT_idx)))))});
if(cljs.core.truth_(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts))){
var G__15992 = G__15991;
goog.object.set(G__15992,"sourcesContent",cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$sources_DASH_content.cljs$core$IFn$_invoke$arity$1(opts)));

return G__15992;
} else {
return G__15991;
}
})();
return JSON.stringify(source_map_file_contents);
});
/**
 * Merge an internal source map representation of a single
 * ClojureScript file mapping original to generated with a
 * second source map mapping original JS to generated JS.
 * The is to support source maps that work through multiple
 * compilation steps like Google Closure optimization passes.
 */
cljs.source_map.merge_source_maps = (function cljs$source_map$merge_source_maps(cljs_map,js_map){
var line_map_seq = cljs.core.seq(cljs_map);
var new_lines = cljs.core.sorted_map();
while(true){
if(line_map_seq){
var vec__16190 = cljs.core.first(line_map_seq);
var line = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16190,(0),null);
var col_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16190,(1),null);
var new_cols = (function (){var col_map_seq = cljs.core.seq(col_map);
var new_cols = cljs.core.sorted_map();
while(true){
if(col_map_seq){
var vec__16193 = cljs.core.first(col_map_seq);
var col = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16193,(0),null);
var infos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16193,(1),null);
var G__16198 = cljs.core.next(col_map_seq);
var G__16199 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_cols,col,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (col_map_seq,new_cols,line_map_seq,new_lines,vec__16193,col,infos,vec__16190,line,col_map){
return (function (v,p__16196){
var map__16197 = p__16196;
var map__16197__$1 = cljs.core.__destructure_map(map__16197);
var gline = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16197__$1,cljs.core.cst$kw$gline);
var gcol = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16197__$1,cljs.core.cst$kw$gcol);
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(v,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(js_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline,gcol], null)));
});})(col_map_seq,new_cols,line_map_seq,new_lines,vec__16193,col,infos,vec__16190,line,col_map))
,cljs.core.PersistentVector.EMPTY,infos));
col_map_seq = G__16198;
new_cols = G__16199;
continue;
} else {
return new_cols;
}
break;
}
})();
var G__16200 = cljs.core.next(line_map_seq);
var G__16201 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new_lines,line,new_cols);
line_map_seq = G__16200;
new_lines = G__16201;
continue;
} else {
return new_lines;
}
break;
}
});
/**
 * Given a ClojureScript to JavaScript source map, invert it. Useful when
 * mapping JavaScript stack traces when environment support is unavailable.
 */
cljs.source_map.invert_reverse_map = (function cljs$source_map$invert_reverse_map(reverse_map){
var inverted = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.sorted_map());
var seq__16202_16410 = cljs.core.seq(reverse_map);
var chunk__16203_16411 = null;
var count__16204_16412 = (0);
var i__16205_16413 = (0);
while(true){
if((i__16205_16413 < count__16204_16412)){
var vec__16308_16414 = chunk__16203_16411.cljs$core$IIndexed$_nth$arity$2(null,i__16205_16413);
var line_16415 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16308_16414,(0),null);
var columns_16416 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16308_16414,(1),null);
var seq__16311_16417 = cljs.core.seq(columns_16416);
var chunk__16312_16418 = null;
var count__16313_16419 = (0);
var i__16314_16420 = (0);
while(true){
if((i__16314_16420 < count__16313_16419)){
var vec__16337_16421 = chunk__16312_16418.cljs$core$IIndexed$_nth$arity$2(null,i__16314_16420);
var column_16422 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16337_16421,(0),null);
var column_info_16423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16337_16421,(1),null);
var seq__16340_16424 = cljs.core.seq(column_info_16423);
var chunk__16341_16425 = null;
var count__16342_16426 = (0);
var i__16343_16427 = (0);
while(true){
if((i__16343_16427 < count__16342_16426)){
var map__16346_16428 = chunk__16341_16425.cljs$core$IIndexed$_nth$arity$2(null,i__16343_16427);
var map__16346_16429__$1 = cljs.core.__destructure_map(map__16346_16428);
var gline_16430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16346_16429__$1,cljs.core.cst$kw$gline);
var gcol_16431 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16346_16429__$1,cljs.core.cst$kw$gcol);
var name_16432 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16346_16429__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16430], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16340_16424,chunk__16341_16425,count__16342_16426,i__16343_16427,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16346_16428,map__16346_16429__$1,gline_16430,gcol_16431,name_16432,vec__16337_16421,column_16422,column_info_16423,vec__16308_16414,line_16415,columns_16416,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16431], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16415,cljs.core.cst$kw$col,column_16422,cljs.core.cst$kw$name,name_16432], null));
});})(seq__16340_16424,chunk__16341_16425,count__16342_16426,i__16343_16427,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16346_16428,map__16346_16429__$1,gline_16430,gcol_16431,name_16432,vec__16337_16421,column_16422,column_info_16423,vec__16308_16414,line_16415,columns_16416,inverted))
,cljs.core.sorted_map()));


var G__16433 = seq__16340_16424;
var G__16434 = chunk__16341_16425;
var G__16435 = count__16342_16426;
var G__16436 = (i__16343_16427 + (1));
seq__16340_16424 = G__16433;
chunk__16341_16425 = G__16434;
count__16342_16426 = G__16435;
i__16343_16427 = G__16436;
continue;
} else {
var temp__5753__auto___16437 = cljs.core.seq(seq__16340_16424);
if(temp__5753__auto___16437){
var seq__16340_16438__$1 = temp__5753__auto___16437;
if(cljs.core.chunked_seq_QMARK_(seq__16340_16438__$1)){
var c__4638__auto___16439 = cljs.core.chunk_first(seq__16340_16438__$1);
var G__16440 = cljs.core.chunk_rest(seq__16340_16438__$1);
var G__16441 = c__4638__auto___16439;
var G__16442 = cljs.core.count(c__4638__auto___16439);
var G__16443 = (0);
seq__16340_16424 = G__16440;
chunk__16341_16425 = G__16441;
count__16342_16426 = G__16442;
i__16343_16427 = G__16443;
continue;
} else {
var map__16347_16444 = cljs.core.first(seq__16340_16438__$1);
var map__16347_16445__$1 = cljs.core.__destructure_map(map__16347_16444);
var gline_16446 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347_16445__$1,cljs.core.cst$kw$gline);
var gcol_16447 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347_16445__$1,cljs.core.cst$kw$gcol);
var name_16448 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16347_16445__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16446], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16340_16424,chunk__16341_16425,count__16342_16426,i__16343_16427,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16347_16444,map__16347_16445__$1,gline_16446,gcol_16447,name_16448,seq__16340_16438__$1,temp__5753__auto___16437,vec__16337_16421,column_16422,column_info_16423,vec__16308_16414,line_16415,columns_16416,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16447], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16415,cljs.core.cst$kw$col,column_16422,cljs.core.cst$kw$name,name_16448], null));
});})(seq__16340_16424,chunk__16341_16425,count__16342_16426,i__16343_16427,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16347_16444,map__16347_16445__$1,gline_16446,gcol_16447,name_16448,seq__16340_16438__$1,temp__5753__auto___16437,vec__16337_16421,column_16422,column_info_16423,vec__16308_16414,line_16415,columns_16416,inverted))
,cljs.core.sorted_map()));


var G__16449 = cljs.core.next(seq__16340_16438__$1);
var G__16450 = null;
var G__16451 = (0);
var G__16452 = (0);
seq__16340_16424 = G__16449;
chunk__16341_16425 = G__16450;
count__16342_16426 = G__16451;
i__16343_16427 = G__16452;
continue;
}
} else {
}
}
break;
}


var G__16453 = seq__16311_16417;
var G__16454 = chunk__16312_16418;
var G__16455 = count__16313_16419;
var G__16456 = (i__16314_16420 + (1));
seq__16311_16417 = G__16453;
chunk__16312_16418 = G__16454;
count__16313_16419 = G__16455;
i__16314_16420 = G__16456;
continue;
} else {
var temp__5753__auto___16457 = cljs.core.seq(seq__16311_16417);
if(temp__5753__auto___16457){
var seq__16311_16458__$1 = temp__5753__auto___16457;
if(cljs.core.chunked_seq_QMARK_(seq__16311_16458__$1)){
var c__4638__auto___16459 = cljs.core.chunk_first(seq__16311_16458__$1);
var G__16460 = cljs.core.chunk_rest(seq__16311_16458__$1);
var G__16461 = c__4638__auto___16459;
var G__16462 = cljs.core.count(c__4638__auto___16459);
var G__16463 = (0);
seq__16311_16417 = G__16460;
chunk__16312_16418 = G__16461;
count__16313_16419 = G__16462;
i__16314_16420 = G__16463;
continue;
} else {
var vec__16348_16464 = cljs.core.first(seq__16311_16458__$1);
var column_16465 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16348_16464,(0),null);
var column_info_16466 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16348_16464,(1),null);
var seq__16351_16467 = cljs.core.seq(column_info_16466);
var chunk__16352_16468 = null;
var count__16353_16469 = (0);
var i__16354_16470 = (0);
while(true){
if((i__16354_16470 < count__16353_16469)){
var map__16357_16471 = chunk__16352_16468.cljs$core$IIndexed$_nth$arity$2(null,i__16354_16470);
var map__16357_16472__$1 = cljs.core.__destructure_map(map__16357_16471);
var gline_16473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16357_16472__$1,cljs.core.cst$kw$gline);
var gcol_16474 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16357_16472__$1,cljs.core.cst$kw$gcol);
var name_16475 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16357_16472__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16473], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16351_16467,chunk__16352_16468,count__16353_16469,i__16354_16470,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16357_16471,map__16357_16472__$1,gline_16473,gcol_16474,name_16475,vec__16348_16464,column_16465,column_info_16466,seq__16311_16458__$1,temp__5753__auto___16457,vec__16308_16414,line_16415,columns_16416,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16474], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16415,cljs.core.cst$kw$col,column_16465,cljs.core.cst$kw$name,name_16475], null));
});})(seq__16351_16467,chunk__16352_16468,count__16353_16469,i__16354_16470,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16357_16471,map__16357_16472__$1,gline_16473,gcol_16474,name_16475,vec__16348_16464,column_16465,column_info_16466,seq__16311_16458__$1,temp__5753__auto___16457,vec__16308_16414,line_16415,columns_16416,inverted))
,cljs.core.sorted_map()));


var G__16476 = seq__16351_16467;
var G__16477 = chunk__16352_16468;
var G__16478 = count__16353_16469;
var G__16479 = (i__16354_16470 + (1));
seq__16351_16467 = G__16476;
chunk__16352_16468 = G__16477;
count__16353_16469 = G__16478;
i__16354_16470 = G__16479;
continue;
} else {
var temp__5753__auto___16480__$1 = cljs.core.seq(seq__16351_16467);
if(temp__5753__auto___16480__$1){
var seq__16351_16481__$1 = temp__5753__auto___16480__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16351_16481__$1)){
var c__4638__auto___16482 = cljs.core.chunk_first(seq__16351_16481__$1);
var G__16483 = cljs.core.chunk_rest(seq__16351_16481__$1);
var G__16484 = c__4638__auto___16482;
var G__16485 = cljs.core.count(c__4638__auto___16482);
var G__16486 = (0);
seq__16351_16467 = G__16483;
chunk__16352_16468 = G__16484;
count__16353_16469 = G__16485;
i__16354_16470 = G__16486;
continue;
} else {
var map__16358_16487 = cljs.core.first(seq__16351_16481__$1);
var map__16358_16488__$1 = cljs.core.__destructure_map(map__16358_16487);
var gline_16489 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16358_16488__$1,cljs.core.cst$kw$gline);
var gcol_16490 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16358_16488__$1,cljs.core.cst$kw$gcol);
var name_16491 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16358_16488__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16489], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16351_16467,chunk__16352_16468,count__16353_16469,i__16354_16470,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16358_16487,map__16358_16488__$1,gline_16489,gcol_16490,name_16491,seq__16351_16481__$1,temp__5753__auto___16480__$1,vec__16348_16464,column_16465,column_info_16466,seq__16311_16458__$1,temp__5753__auto___16457,vec__16308_16414,line_16415,columns_16416,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16490], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16415,cljs.core.cst$kw$col,column_16465,cljs.core.cst$kw$name,name_16491], null));
});})(seq__16351_16467,chunk__16352_16468,count__16353_16469,i__16354_16470,seq__16311_16417,chunk__16312_16418,count__16313_16419,i__16314_16420,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16358_16487,map__16358_16488__$1,gline_16489,gcol_16490,name_16491,seq__16351_16481__$1,temp__5753__auto___16480__$1,vec__16348_16464,column_16465,column_info_16466,seq__16311_16458__$1,temp__5753__auto___16457,vec__16308_16414,line_16415,columns_16416,inverted))
,cljs.core.sorted_map()));


var G__16492 = cljs.core.next(seq__16351_16481__$1);
var G__16493 = null;
var G__16494 = (0);
var G__16495 = (0);
seq__16351_16467 = G__16492;
chunk__16352_16468 = G__16493;
count__16353_16469 = G__16494;
i__16354_16470 = G__16495;
continue;
}
} else {
}
}
break;
}


var G__16496 = cljs.core.next(seq__16311_16458__$1);
var G__16497 = null;
var G__16498 = (0);
var G__16499 = (0);
seq__16311_16417 = G__16496;
chunk__16312_16418 = G__16497;
count__16313_16419 = G__16498;
i__16314_16420 = G__16499;
continue;
}
} else {
}
}
break;
}


var G__16500 = seq__16202_16410;
var G__16501 = chunk__16203_16411;
var G__16502 = count__16204_16412;
var G__16503 = (i__16205_16413 + (1));
seq__16202_16410 = G__16500;
chunk__16203_16411 = G__16501;
count__16204_16412 = G__16502;
i__16205_16413 = G__16503;
continue;
} else {
var temp__5753__auto___16504 = cljs.core.seq(seq__16202_16410);
if(temp__5753__auto___16504){
var seq__16202_16505__$1 = temp__5753__auto___16504;
if(cljs.core.chunked_seq_QMARK_(seq__16202_16505__$1)){
var c__4638__auto___16506 = cljs.core.chunk_first(seq__16202_16505__$1);
var G__16507 = cljs.core.chunk_rest(seq__16202_16505__$1);
var G__16508 = c__4638__auto___16506;
var G__16509 = cljs.core.count(c__4638__auto___16506);
var G__16510 = (0);
seq__16202_16410 = G__16507;
chunk__16203_16411 = G__16508;
count__16204_16412 = G__16509;
i__16205_16413 = G__16510;
continue;
} else {
var vec__16359_16511 = cljs.core.first(seq__16202_16505__$1);
var line_16512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16359_16511,(0),null);
var columns_16513 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16359_16511,(1),null);
var seq__16362_16514 = cljs.core.seq(columns_16513);
var chunk__16363_16515 = null;
var count__16364_16516 = (0);
var i__16365_16517 = (0);
while(true){
if((i__16365_16517 < count__16364_16516)){
var vec__16388_16518 = chunk__16363_16515.cljs$core$IIndexed$_nth$arity$2(null,i__16365_16517);
var column_16519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16388_16518,(0),null);
var column_info_16520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16388_16518,(1),null);
var seq__16391_16521 = cljs.core.seq(column_info_16520);
var chunk__16392_16522 = null;
var count__16393_16523 = (0);
var i__16394_16524 = (0);
while(true){
if((i__16394_16524 < count__16393_16523)){
var map__16397_16525 = chunk__16392_16522.cljs$core$IIndexed$_nth$arity$2(null,i__16394_16524);
var map__16397_16526__$1 = cljs.core.__destructure_map(map__16397_16525);
var gline_16527 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16397_16526__$1,cljs.core.cst$kw$gline);
var gcol_16528 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16397_16526__$1,cljs.core.cst$kw$gcol);
var name_16529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16397_16526__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16527], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16391_16521,chunk__16392_16522,count__16393_16523,i__16394_16524,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16397_16525,map__16397_16526__$1,gline_16527,gcol_16528,name_16529,vec__16388_16518,column_16519,column_info_16520,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16528], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16512,cljs.core.cst$kw$col,column_16519,cljs.core.cst$kw$name,name_16529], null));
});})(seq__16391_16521,chunk__16392_16522,count__16393_16523,i__16394_16524,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16397_16525,map__16397_16526__$1,gline_16527,gcol_16528,name_16529,vec__16388_16518,column_16519,column_info_16520,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted))
,cljs.core.sorted_map()));


var G__16530 = seq__16391_16521;
var G__16531 = chunk__16392_16522;
var G__16532 = count__16393_16523;
var G__16533 = (i__16394_16524 + (1));
seq__16391_16521 = G__16530;
chunk__16392_16522 = G__16531;
count__16393_16523 = G__16532;
i__16394_16524 = G__16533;
continue;
} else {
var temp__5753__auto___16534__$1 = cljs.core.seq(seq__16391_16521);
if(temp__5753__auto___16534__$1){
var seq__16391_16535__$1 = temp__5753__auto___16534__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16391_16535__$1)){
var c__4638__auto___16536 = cljs.core.chunk_first(seq__16391_16535__$1);
var G__16537 = cljs.core.chunk_rest(seq__16391_16535__$1);
var G__16538 = c__4638__auto___16536;
var G__16539 = cljs.core.count(c__4638__auto___16536);
var G__16540 = (0);
seq__16391_16521 = G__16537;
chunk__16392_16522 = G__16538;
count__16393_16523 = G__16539;
i__16394_16524 = G__16540;
continue;
} else {
var map__16398_16541 = cljs.core.first(seq__16391_16535__$1);
var map__16398_16542__$1 = cljs.core.__destructure_map(map__16398_16541);
var gline_16543 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398_16542__$1,cljs.core.cst$kw$gline);
var gcol_16544 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398_16542__$1,cljs.core.cst$kw$gcol);
var name_16545 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16398_16542__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16543], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16391_16521,chunk__16392_16522,count__16393_16523,i__16394_16524,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16398_16541,map__16398_16542__$1,gline_16543,gcol_16544,name_16545,seq__16391_16535__$1,temp__5753__auto___16534__$1,vec__16388_16518,column_16519,column_info_16520,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16544], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16512,cljs.core.cst$kw$col,column_16519,cljs.core.cst$kw$name,name_16545], null));
});})(seq__16391_16521,chunk__16392_16522,count__16393_16523,i__16394_16524,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16398_16541,map__16398_16542__$1,gline_16543,gcol_16544,name_16545,seq__16391_16535__$1,temp__5753__auto___16534__$1,vec__16388_16518,column_16519,column_info_16520,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted))
,cljs.core.sorted_map()));


var G__16546 = cljs.core.next(seq__16391_16535__$1);
var G__16547 = null;
var G__16548 = (0);
var G__16549 = (0);
seq__16391_16521 = G__16546;
chunk__16392_16522 = G__16547;
count__16393_16523 = G__16548;
i__16394_16524 = G__16549;
continue;
}
} else {
}
}
break;
}


var G__16550 = seq__16362_16514;
var G__16551 = chunk__16363_16515;
var G__16552 = count__16364_16516;
var G__16553 = (i__16365_16517 + (1));
seq__16362_16514 = G__16550;
chunk__16363_16515 = G__16551;
count__16364_16516 = G__16552;
i__16365_16517 = G__16553;
continue;
} else {
var temp__5753__auto___16554__$1 = cljs.core.seq(seq__16362_16514);
if(temp__5753__auto___16554__$1){
var seq__16362_16555__$1 = temp__5753__auto___16554__$1;
if(cljs.core.chunked_seq_QMARK_(seq__16362_16555__$1)){
var c__4638__auto___16556 = cljs.core.chunk_first(seq__16362_16555__$1);
var G__16557 = cljs.core.chunk_rest(seq__16362_16555__$1);
var G__16558 = c__4638__auto___16556;
var G__16559 = cljs.core.count(c__4638__auto___16556);
var G__16560 = (0);
seq__16362_16514 = G__16557;
chunk__16363_16515 = G__16558;
count__16364_16516 = G__16559;
i__16365_16517 = G__16560;
continue;
} else {
var vec__16399_16561 = cljs.core.first(seq__16362_16555__$1);
var column_16562 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16399_16561,(0),null);
var column_info_16563 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__16399_16561,(1),null);
var seq__16402_16564 = cljs.core.seq(column_info_16563);
var chunk__16403_16565 = null;
var count__16404_16566 = (0);
var i__16405_16567 = (0);
while(true){
if((i__16405_16567 < count__16404_16566)){
var map__16408_16568 = chunk__16403_16565.cljs$core$IIndexed$_nth$arity$2(null,i__16405_16567);
var map__16408_16569__$1 = cljs.core.__destructure_map(map__16408_16568);
var gline_16570 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16408_16569__$1,cljs.core.cst$kw$gline);
var gcol_16571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16408_16569__$1,cljs.core.cst$kw$gcol);
var name_16572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16408_16569__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16570], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16402_16564,chunk__16403_16565,count__16404_16566,i__16405_16567,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16408_16568,map__16408_16569__$1,gline_16570,gcol_16571,name_16572,vec__16399_16561,column_16562,column_info_16563,seq__16362_16555__$1,temp__5753__auto___16554__$1,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16571], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16512,cljs.core.cst$kw$col,column_16562,cljs.core.cst$kw$name,name_16572], null));
});})(seq__16402_16564,chunk__16403_16565,count__16404_16566,i__16405_16567,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16408_16568,map__16408_16569__$1,gline_16570,gcol_16571,name_16572,vec__16399_16561,column_16562,column_info_16563,seq__16362_16555__$1,temp__5753__auto___16554__$1,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted))
,cljs.core.sorted_map()));


var G__16573 = seq__16402_16564;
var G__16574 = chunk__16403_16565;
var G__16575 = count__16404_16566;
var G__16576 = (i__16405_16567 + (1));
seq__16402_16564 = G__16573;
chunk__16403_16565 = G__16574;
count__16404_16566 = G__16575;
i__16405_16567 = G__16576;
continue;
} else {
var temp__5753__auto___16577__$2 = cljs.core.seq(seq__16402_16564);
if(temp__5753__auto___16577__$2){
var seq__16402_16578__$1 = temp__5753__auto___16577__$2;
if(cljs.core.chunked_seq_QMARK_(seq__16402_16578__$1)){
var c__4638__auto___16579 = cljs.core.chunk_first(seq__16402_16578__$1);
var G__16580 = cljs.core.chunk_rest(seq__16402_16578__$1);
var G__16581 = c__4638__auto___16579;
var G__16582 = cljs.core.count(c__4638__auto___16579);
var G__16583 = (0);
seq__16402_16564 = G__16580;
chunk__16403_16565 = G__16581;
count__16404_16566 = G__16582;
i__16405_16567 = G__16583;
continue;
} else {
var map__16409_16584 = cljs.core.first(seq__16402_16578__$1);
var map__16409_16585__$1 = cljs.core.__destructure_map(map__16409_16584);
var gline_16586 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16409_16585__$1,cljs.core.cst$kw$gline);
var gcol_16587 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16409_16585__$1,cljs.core.cst$kw$gcol);
var name_16588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__16409_16585__$1,cljs.core.cst$kw$name);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(inverted,cljs.core.update_in,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gline_16586], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(((function (seq__16402_16564,chunk__16403_16565,count__16404_16566,i__16405_16567,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16409_16584,map__16409_16585__$1,gline_16586,gcol_16587,name_16588,seq__16402_16578__$1,temp__5753__auto___16577__$2,vec__16399_16561,column_16562,column_info_16563,seq__16362_16555__$1,temp__5753__auto___16554__$1,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted){
return (function (columns__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(columns__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [gcol_16587], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2(cljs.core.conj,cljs.core.PersistentVector.EMPTY),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$line,line_16512,cljs.core.cst$kw$col,column_16562,cljs.core.cst$kw$name,name_16588], null));
});})(seq__16402_16564,chunk__16403_16565,count__16404_16566,i__16405_16567,seq__16362_16514,chunk__16363_16515,count__16364_16516,i__16365_16517,seq__16202_16410,chunk__16203_16411,count__16204_16412,i__16205_16413,map__16409_16584,map__16409_16585__$1,gline_16586,gcol_16587,name_16588,seq__16402_16578__$1,temp__5753__auto___16577__$2,vec__16399_16561,column_16562,column_info_16563,seq__16362_16555__$1,temp__5753__auto___16554__$1,vec__16359_16511,line_16512,columns_16513,seq__16202_16505__$1,temp__5753__auto___16504,inverted))
,cljs.core.sorted_map()));


var G__16589 = cljs.core.next(seq__16402_16578__$1);
var G__16590 = null;
var G__16591 = (0);
var G__16592 = (0);
seq__16402_16564 = G__16589;
chunk__16403_16565 = G__16590;
count__16404_16566 = G__16591;
i__16405_16567 = G__16592;
continue;
}
} else {
}
}
break;
}


var G__16593 = cljs.core.next(seq__16362_16555__$1);
var G__16594 = null;
var G__16595 = (0);
var G__16596 = (0);
seq__16362_16514 = G__16593;
chunk__16363_16515 = G__16594;
count__16364_16516 = G__16595;
i__16365_16517 = G__16596;
continue;
}
} else {
}
}
break;
}


var G__16597 = cljs.core.next(seq__16202_16505__$1);
var G__16598 = null;
var G__16599 = (0);
var G__16600 = (0);
seq__16202_16410 = G__16597;
chunk__16203_16411 = G__16598;
count__16204_16412 = G__16599;
i__16205_16413 = G__16600;
continue;
}
} else {
}
}
break;
}

return cljs.core.deref(inverted);
});
