// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__38768 = cljs.core.get_global_hierarchy;
return (fexpr__38768.cljs$core$IFn$_invoke$arity$0 ? fexpr__38768.cljs$core$IFn$_invoke$arity$0() : fexpr__38768.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["set websocket id:",ws_id], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["process event:",event_type,event_data], 0));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__38769 = cljs.core.seq(callbacks);
var chunk__38770 = null;
var count__38771 = (0);
var i__38772 = (0);
while(true){
if((i__38772 < count__38771)){
var vec__38781 = chunk__38770.cljs$core$IIndexed$_nth$arity$2(null,i__38772);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38781,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38781,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e38784){var e_38789 = e38784;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_38789,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__38790 = seq__38769;
var G__38791 = chunk__38770;
var G__38792 = count__38771;
var G__38793 = (i__38772 + (1));
seq__38769 = G__38790;
chunk__38770 = G__38791;
count__38771 = G__38792;
i__38772 = G__38793;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__38769);
if(temp__5753__auto__){
var seq__38769__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__38769__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__38769__$1);
var G__38794 = cljs.core.chunk_rest(seq__38769__$1);
var G__38795 = c__4638__auto__;
var G__38796 = cljs.core.count(c__4638__auto__);
var G__38797 = (0);
seq__38769 = G__38794;
chunk__38770 = G__38795;
count__38771 = G__38796;
i__38772 = G__38797;
continue;
} else {
var vec__38785 = cljs.core.first(seq__38769__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38785,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38785,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e38788){var e_38798 = e38788;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_38798,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__38799 = cljs.core.next(seq__38769__$1);
var G__38800 = null;
var G__38801 = (0);
var G__38802 = (0);
seq__38769 = G__38799;
chunk__38770 = G__38800;
count__38771 = G__38801;
i__38772 = G__38802;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__38805 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38805,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__38808 = conn;
var map__38808__$1 = cljs.core.__destructure_map(map__38808);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38808__$1,cljs.core.cst$kw$state);
var G__38809 = event_type__$1;
var G__38809__$1 = (((G__38809 instanceof cljs.core.Keyword))?G__38809.fqn:null);
switch (G__38809__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Found response channel for subject",subject], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,(function (p1__38803_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__38803_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__38810 = error_data;
var map__38810__$1 = cljs.core.__destructure_map(map__38810);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38810__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e38804){var e = e38804;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
