// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__84329_84498 = cljs.core.seq(servers);
var chunk__84330_84499 = null;
var count__84331_84500 = (0);
var i__84332_84501 = (0);
while(true){
if((i__84332_84501 < count__84331_84500)){
var server_84502 = chunk__84330_84499.cljs$core$IIndexed$_nth$arity$2(null,i__84332_84501);
var healthcheck_uri_84503 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_84502),"/fdb/health"].join('');
var resp_chan_84504 = fluree.db.util.xhttp.post_json(healthcheck_uri_84503,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__24424__auto___84505 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502){
return (function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = ((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502){
return (function (state_84393){
var state_val_84394 = (state_84393[(1)]);
if((state_val_84394 === (1))){
var state_84393__$1 = state_84393;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84393__$1,(2),resp_chan_84504);
} else {
if((state_val_84394 === (2))){
var inst_84382 = (state_84393[(7)]);
var inst_84382__$1 = (state_84393[(2)]);
var inst_84383 = fluree.db.util.core.exception_QMARK_(inst_84382__$1);
var state_84393__$1 = (function (){var statearr_84395 = state_84393;
(statearr_84395[(7)] = inst_84382__$1);

return statearr_84395;
})();
if(inst_84383){
var statearr_84396_84506 = state_84393__$1;
(statearr_84396_84506[(1)] = (3));

} else {
var statearr_84397_84507 = state_84393__$1;
(statearr_84397_84507[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84394 === (3))){
var inst_84382 = (state_84393[(7)]);
var inst_84385 = cljs.core.ex_message(inst_84382);
var inst_84386 = cljs.core.ex_data(inst_84382);
var inst_84387 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_84385,inst_84386], 0));
var state_84393__$1 = state_84393;
var statearr_84398_84508 = state_84393__$1;
(statearr_84398_84508[(2)] = inst_84387);

(statearr_84398_84508[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84394 === (4))){
var inst_84389 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_84502);
var state_84393__$1 = state_84393;
var statearr_84399_84509 = state_84393__$1;
(statearr_84399_84509[(2)] = inst_84389);

(statearr_84399_84509[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84394 === (5))){
var inst_84391 = (state_84393[(2)]);
var state_84393__$1 = state_84393;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84393__$1,inst_84391);
} else {
return null;
}
}
}
}
}
});})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502))
;
return ((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,switch__24297__auto__,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0 = (function (){
var statearr_84400 = [null,null,null,null,null,null,null,null];
(statearr_84400[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__);

(statearr_84400[(1)] = (1));

return statearr_84400;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1 = (function (state_84393){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84393);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84401){var ex__24301__auto__ = e84401;
var statearr_84402_84510 = state_84393;
(statearr_84402_84510[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84393[(4)]))){
var statearr_84403_84511 = state_84393;
(statearr_84403_84511[(1)] = cljs.core.first((state_84393[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84512 = state_84393;
state_84393 = G__84512;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = function(state_84393){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1.call(this,state_84393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__;
})()
;})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,switch__24297__auto__,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502))
})();
var state__24426__auto__ = (function (){var statearr_84404 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84404[(6)] = c__24424__auto___84505);

return statearr_84404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
});})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84505,healthcheck_uri_84503,resp_chan_84504,server_84502))
);



var G__84513 = seq__84329_84498;
var G__84514 = chunk__84330_84499;
var G__84515 = count__84331_84500;
var G__84516 = (i__84332_84501 + (1));
seq__84329_84498 = G__84513;
chunk__84330_84499 = G__84514;
count__84331_84500 = G__84515;
i__84332_84501 = G__84516;
continue;
} else {
var temp__5753__auto___84517 = cljs.core.seq(seq__84329_84498);
if(temp__5753__auto___84517){
var seq__84329_84518__$1 = temp__5753__auto___84517;
if(cljs.core.chunked_seq_QMARK_(seq__84329_84518__$1)){
var c__4638__auto___84519 = cljs.core.chunk_first(seq__84329_84518__$1);
var G__84520 = cljs.core.chunk_rest(seq__84329_84518__$1);
var G__84521 = c__4638__auto___84519;
var G__84522 = cljs.core.count(c__4638__auto___84519);
var G__84523 = (0);
seq__84329_84498 = G__84520;
chunk__84330_84499 = G__84521;
count__84331_84500 = G__84522;
i__84332_84501 = G__84523;
continue;
} else {
var server_84524 = cljs.core.first(seq__84329_84518__$1);
var healthcheck_uri_84525 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_84524),"/fdb/health"].join('');
var resp_chan_84526 = fluree.db.util.xhttp.post_json(healthcheck_uri_84525,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__24424__auto___84527 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517){
return (function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = ((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517){
return (function (state_84417){
var state_val_84418 = (state_84417[(1)]);
if((state_val_84418 === (1))){
var state_84417__$1 = state_84417;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84417__$1,(2),resp_chan_84526);
} else {
if((state_val_84418 === (2))){
var inst_84406 = (state_84417[(7)]);
var inst_84406__$1 = (state_84417[(2)]);
var inst_84407 = fluree.db.util.core.exception_QMARK_(inst_84406__$1);
var state_84417__$1 = (function (){var statearr_84419 = state_84417;
(statearr_84419[(7)] = inst_84406__$1);

return statearr_84419;
})();
if(inst_84407){
var statearr_84420_84528 = state_84417__$1;
(statearr_84420_84528[(1)] = (3));

} else {
var statearr_84421_84529 = state_84417__$1;
(statearr_84421_84529[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84418 === (3))){
var inst_84406 = (state_84417[(7)]);
var inst_84409 = cljs.core.ex_message(inst_84406);
var inst_84410 = cljs.core.ex_data(inst_84406);
var inst_84411 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_84409,inst_84410], 0));
var state_84417__$1 = state_84417;
var statearr_84422_84530 = state_84417__$1;
(statearr_84422_84530[(2)] = inst_84411);

(statearr_84422_84530[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84418 === (4))){
var inst_84413 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_84524);
var state_84417__$1 = state_84417;
var statearr_84423_84531 = state_84417__$1;
(statearr_84423_84531[(2)] = inst_84413);

(statearr_84423_84531[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84418 === (5))){
var inst_84415 = (state_84417[(2)]);
var state_84417__$1 = state_84417;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84417__$1,inst_84415);
} else {
return null;
}
}
}
}
}
});})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517))
;
return ((function (seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,switch__24297__auto__,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0 = (function (){
var statearr_84424 = [null,null,null,null,null,null,null,null];
(statearr_84424[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__);

(statearr_84424[(1)] = (1));

return statearr_84424;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1 = (function (state_84417){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84417);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84425){var ex__24301__auto__ = e84425;
var statearr_84426_84532 = state_84417;
(statearr_84426_84532[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84417[(4)]))){
var statearr_84427_84533 = state_84417;
(statearr_84427_84533[(1)] = cljs.core.first((state_84417[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84534 = state_84417;
state_84417 = G__84534;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = function(state_84417){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1.call(this,state_84417);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__;
})()
;})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,switch__24297__auto__,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517))
})();
var state__24426__auto__ = (function (){var statearr_84428 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84428[(6)] = c__24424__auto___84527);

return statearr_84428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
});})(seq__84329_84498,chunk__84330_84499,count__84331_84500,i__84332_84501,c__24424__auto___84527,healthcheck_uri_84525,resp_chan_84526,server_84524,seq__84329_84518__$1,temp__5753__auto___84517))
);



var G__84535 = cljs.core.next(seq__84329_84518__$1);
var G__84536 = null;
var G__84537 = (0);
var G__84538 = (0);
seq__84329_84498 = G__84535;
chunk__84330_84499 = G__84536;
count__84331_84500 = G__84537;
i__84332_84501 = G__84538;
continue;
}
} else {
}
}
break;
}

var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84472){
var state_val_84473 = (state_84472[(1)]);
if((state_val_84473 === (7))){
var inst_84444 = (state_84472[(7)]);
var inst_84451 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_84444,cljs.core.cst$kw$default);
var state_84472__$1 = state_84472;
if(inst_84451){
var statearr_84474_84539 = state_84472__$1;
(statearr_84474_84539[(1)] = (9));

} else {
var statearr_84475_84540 = state_84472__$1;
(statearr_84475_84540[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (1))){
var inst_84436 = (state_84472[(8)]);
var inst_84437 = (state_84472[(9)]);
var inst_84436__$1 = promise_chan;
var inst_84437__$1 = cljs.core.async.timeout((60000));
var inst_84438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84439 = [inst_84436__$1,inst_84437__$1];
var inst_84440 = (new cljs.core.PersistentVector(null,2,(5),inst_84438,inst_84439,null));
var state_84472__$1 = (function (){var statearr_84476 = state_84472;
(statearr_84476[(8)] = inst_84436__$1);

(statearr_84476[(9)] = inst_84437__$1);

return statearr_84476;
})();
return cljs.core.async.ioc_alts_BANG_(state_84472__$1,(2),inst_84440);
} else {
if((state_val_84473 === (4))){
var inst_84437 = (state_84472[(9)]);
var inst_84444 = (state_84472[(7)]);
var inst_84448 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_84444,inst_84437);
var state_84472__$1 = state_84472;
if(inst_84448){
var statearr_84477_84541 = state_84472__$1;
(statearr_84477_84541[(1)] = (6));

} else {
var statearr_84478_84542 = state_84472__$1;
(statearr_84478_84542[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (13))){
var state_84472__$1 = state_84472;
var statearr_84479_84543 = state_84472__$1;
(statearr_84479_84543[(2)] = null);

(statearr_84479_84543[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (6))){
var state_84472__$1 = state_84472;
var statearr_84480_84544 = state_84472__$1;
(statearr_84480_84544[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_84480_84544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (3))){
var state_84472__$1 = state_84472;
var statearr_84481_84545 = state_84472__$1;
(statearr_84481_84545[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_84481_84545[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (12))){
var inst_84462 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_84463 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_84464 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_84465 = cljs.core.PersistentHashMap.fromArrays(inst_84463,inst_84464);
var inst_84466 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_84465);
var inst_84467 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_84466);
var state_84472__$1 = (function (){var statearr_84482 = state_84472;
(statearr_84482[(10)] = inst_84462);

return statearr_84482;
})();
var statearr_84483_84546 = state_84472__$1;
(statearr_84483_84546[(2)] = inst_84467);

(statearr_84483_84546[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (2))){
var inst_84436 = (state_84472[(8)]);
var inst_84444 = (state_84472[(7)]);
var inst_84442 = (state_84472[(2)]);
var inst_84443 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84442,(0),null);
var inst_84444__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84442,(1),null);
var inst_84445 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_84444__$1,inst_84436);
var state_84472__$1 = (function (){var statearr_84484 = state_84472;
(statearr_84484[(11)] = inst_84443);

(statearr_84484[(7)] = inst_84444__$1);

return statearr_84484;
})();
if(inst_84445){
var statearr_84485_84547 = state_84472__$1;
(statearr_84485_84547[(1)] = (3));

} else {
var statearr_84486_84548 = state_84472__$1;
(statearr_84486_84548[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (11))){
var inst_84455 = (state_84472[(2)]);
var state_84472__$1 = state_84472;
var statearr_84487_84549 = state_84472__$1;
(statearr_84487_84549[(2)] = inst_84455);

(statearr_84487_84549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (9))){
var inst_84443 = (state_84472[(11)]);
var state_84472__$1 = state_84472;
var statearr_84488_84550 = state_84472__$1;
(statearr_84488_84550[(2)] = inst_84443);

(statearr_84488_84550[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (5))){
var inst_84459 = (state_84472[(2)]);
var inst_84460 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_84459);
var state_84472__$1 = state_84472;
if(inst_84460){
var statearr_84489_84551 = state_84472__$1;
(statearr_84489_84551[(1)] = (12));

} else {
var statearr_84490_84552 = state_84472__$1;
(statearr_84490_84552[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (14))){
var inst_84470 = (state_84472[(2)]);
var state_84472__$1 = state_84472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84472__$1,inst_84470);
} else {
if((state_val_84473 === (10))){
var state_84472__$1 = state_84472;
var statearr_84491_84553 = state_84472__$1;
(statearr_84491_84553[(2)] = null);

(statearr_84491_84553[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84473 === (8))){
var inst_84457 = (state_84472[(2)]);
var state_84472__$1 = state_84472;
var statearr_84492_84554 = state_84472__$1;
(statearr_84492_84554[(2)] = inst_84457);

(statearr_84492_84554[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0 = (function (){
var statearr_84493 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84493[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__);

(statearr_84493[(1)] = (1));

return statearr_84493;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1 = (function (state_84472){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84472);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84494){var ex__24301__auto__ = e84494;
var statearr_84495_84555 = state_84472;
(statearr_84495_84555[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84472[(4)]))){
var statearr_84496_84556 = state_84472;
(statearr_84496_84556[(1)] = cljs.core.first((state_84472[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84557 = state_84472;
state_84472 = G__84557;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__ = function(state_84472){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1.call(this,state_84472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84497 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84497[(6)] = c__24424__auto__);

return statearr_84497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84601){
var state_val_84602 = (state_84601[(1)]);
if((state_val_84602 === (7))){
var state_84601__$1 = state_84601;
var statearr_84603_84629 = state_84601__$1;
(statearr_84603_84629[(2)] = null);

(statearr_84603_84629[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (1))){
var state_84601__$1 = state_84601;
var statearr_84604_84630 = state_84601__$1;
(statearr_84604_84630[(2)] = null);

(statearr_84604_84630[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (4))){
var inst_84558 = (state_84601[(2)]);
var state_84601__$1 = state_84601;
var statearr_84605_84631 = state_84601__$1;
(statearr_84605_84631[(2)] = inst_84558);

(statearr_84605_84631[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (6))){
var inst_84580 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_84601__$1 = state_84601;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84601__$1,(9),inst_84580);
} else {
if((state_val_84602 === (3))){
var inst_84599 = (state_84601[(2)]);
var state_84601__$1 = state_84601;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84601__$1,inst_84599);
} else {
if((state_val_84602 === (12))){
var inst_84593 = (state_84601[(2)]);
var state_84601__$1 = state_84601;
var statearr_84606_84632 = state_84601__$1;
(statearr_84606_84632[(2)] = inst_84593);

(statearr_84606_84632[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (2))){
var inst_84564 = (state_84601[(7)]);
var inst_84569 = (state_84601[(8)]);
var inst_84574 = (state_84601[(9)]);
var _ = (function (){var statearr_84607 = state_84601;
(statearr_84607[(4)] = cljs.core.cons((5),(state_84601[(4)])));

return statearr_84607;
})();
var inst_84564__$1 = fluree.db.util.core.random_uuid();
var inst_84565 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84566 = [conn_id,cljs.core.cst$kw$ws];
var inst_84567 = (new cljs.core.PersistentVector(null,2,(5),inst_84565,inst_84566,null));
var inst_84568 = (function (){var lock_id = inst_84564__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_84569__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_84567,inst_84568);
var inst_84570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84571 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_84572 = (new cljs.core.PersistentVector(null,3,(5),inst_84570,inst_84571,null));
var inst_84573 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_84569__$1,inst_84572);
var inst_84574__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_84564__$1,inst_84573);
var inst_84575 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84576 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_84577 = (new cljs.core.PersistentVector(null,3,(5),inst_84575,inst_84576,null));
var inst_84578 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_84569__$1,inst_84577);
var state_84601__$1 = (function (){var statearr_84608 = state_84601;
(statearr_84608[(7)] = inst_84564__$1);

(statearr_84608[(10)] = inst_84578);

(statearr_84608[(8)] = inst_84569__$1);

(statearr_84608[(9)] = inst_84574__$1);

return statearr_84608;
})();
if(inst_84574__$1){
var statearr_84609_84633 = state_84601__$1;
(statearr_84609_84633[(1)] = (6));

} else {
var statearr_84610_84634 = state_84601__$1;
(statearr_84610_84634[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (11))){
var inst_84585 = (state_84601[(11)]);
var inst_84578 = (state_84601[(10)]);
var inst_84584 = (state_84601[(12)]);
var inst_84591 = fluree.db.util.xhttp.try_socket(inst_84584,sub_chan,pub_chan,inst_84578,(60000),inst_84585);
var state_84601__$1 = state_84601;
var statearr_84612_84635 = state_84601__$1;
(statearr_84612_84635[(2)] = inst_84591);

(statearr_84612_84635[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (9))){
var inst_84564 = (state_84601[(7)]);
var inst_84582 = (state_84601[(13)]);
var inst_84578 = (state_84601[(10)]);
var inst_84569 = (state_84601[(8)]);
var inst_84574 = (state_84601[(9)]);
var inst_84584 = (state_84601[(12)]);
var inst_84582__$1 = (state_84601[(2)]);
var inst_84583 = clojure.string.replace(inst_84582__$1,"http","ws");
var inst_84584__$1 = [inst_84583,"/fdb/ws"].join('');
var inst_84585 = (function (){var lock_id = inst_84564;
var state = inst_84569;
var have_lock_QMARK_ = inst_84574;
var resp_chan = inst_84578;
var healthy_server = inst_84582__$1;
var ws_url = inst_84584__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_84586 = fluree.db.util.core.exception_QMARK_(inst_84582__$1);
var state_84601__$1 = (function (){var statearr_84613 = state_84601;
(statearr_84613[(11)] = inst_84585);

(statearr_84613[(13)] = inst_84582__$1);

(statearr_84613[(12)] = inst_84584__$1);

return statearr_84613;
})();
if(inst_84586){
var statearr_84614_84636 = state_84601__$1;
(statearr_84614_84636[(1)] = (10));

} else {
var statearr_84615_84637 = state_84601__$1;
(statearr_84615_84637[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (5))){
var _ = (function (){var statearr_84616 = state_84601;
(statearr_84616[(4)] = cljs.core.rest((state_84601[(4)])));

return statearr_84616;
})();
var state_84601__$1 = state_84601;
var ex84611 = (state_84601__$1[(2)]);
var statearr_84617_84638 = state_84601__$1;
(statearr_84617_84638[(5)] = ex84611);


if((ex84611 instanceof Error)){
var statearr_84618_84639 = state_84601__$1;
(statearr_84618_84639[(1)] = (4));

(statearr_84618_84639[(5)] = null);

} else {
throw ex84611;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (10))){
var inst_84582 = (state_84601[(13)]);
var inst_84578 = (state_84601[(10)]);
var inst_84588 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_84589 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_84578,inst_84582);
var state_84601__$1 = (function (){var statearr_84619 = state_84601;
(statearr_84619[(14)] = inst_84588);

return statearr_84619;
})();
var statearr_84620_84640 = state_84601__$1;
(statearr_84620_84640[(2)] = inst_84589);

(statearr_84620_84640[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84602 === (8))){
var inst_84578 = (state_84601[(10)]);
var inst_84596 = (state_84601[(2)]);
var _ = (function (){var statearr_84621 = state_84601;
(statearr_84621[(4)] = cljs.core.rest((state_84601[(4)])));

return statearr_84621;
})();
var state_84601__$1 = (function (){var statearr_84622 = state_84601;
(statearr_84622[(15)] = inst_84596);

return statearr_84622;
})();
var statearr_84623_84641 = state_84601__$1;
(statearr_84623_84641[(2)] = inst_84578);

(statearr_84623_84641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__24298__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__24298__auto____0 = (function (){
var statearr_84624 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84624[(0)] = fluree$db$connection$establish_socket_$_state_machine__24298__auto__);

(statearr_84624[(1)] = (1));

return statearr_84624;
});
var fluree$db$connection$establish_socket_$_state_machine__24298__auto____1 = (function (state_84601){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84601);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84625){var ex__24301__auto__ = e84625;
var statearr_84626_84642 = state_84601;
(statearr_84626_84642[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84601[(4)]))){
var statearr_84627_84643 = state_84601;
(statearr_84627_84643[(1)] = cljs.core.first((state_84601[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84644 = state_84601;
state_84601 = G__84644;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__24298__auto__ = function(state_84601){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__24298__auto____1.call(this,state_84601);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__24298__auto____0;
fluree$db$connection$establish_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__24298__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84628 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84628[(6)] = c__24424__auto__);

return statearr_84628;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k84646,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__84650 = k84646;
var G__84650__$1 = (((G__84650 instanceof cljs.core.Keyword))?G__84650.fqn:null);
switch (G__84650__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k84646,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__84651){
var vec__84652 = p__84651;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__84652,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__84652,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__84645){
var self__ = this;
var G__84645__$1 = this;
return (new cljs.core.RecordIter((0),G__84645__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__84655 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__84655(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this84647,other84648){
var self__ = this;
var this84647__$1 = this;
return (((!((other84648 == null)))) && ((((this84647__$1.constructor === other84648.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.id,other84648.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.servers,other84648.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.state,other84648.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.req_chan,other84648.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.sub_chan,other84648.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.pub_chan,other84648.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.storage_read,other84648.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.storage_write,other84648.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.object_cache,other84648.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.parallelism,other84648.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.serializer,other84648.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.default_network,other84648.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.transactor_QMARK_,other84648.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.publish,other84648.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.transact_handler,other84648.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.tx_private_key,other84648.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.tx_key_id,other84648.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.meta,other84648.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.add_listener,other84648.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.remove_listener,other84648.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.close,other84648.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this84647__$1.__extmap,other84648.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k84646){
var self__ = this;
var this__4468__auto____$1 = this;
var G__84656 = k84646;
var G__84656__$1 = (((G__84656 instanceof cljs.core.Keyword))?G__84656.fqn:null);
switch (G__84656__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k84646);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__84645){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__84657 = cljs.core.keyword_identical_QMARK_;
var expr__84658 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__84660 = cljs.core.cst$kw$id;
var G__84661 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84660,G__84661) : pred__84657.call(null,G__84660,G__84661));
})())){
return (new fluree.db.connection.Connection(G__84645,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84662 = cljs.core.cst$kw$servers;
var G__84663 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84662,G__84663) : pred__84657.call(null,G__84662,G__84663));
})())){
return (new fluree.db.connection.Connection(self__.id,G__84645,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84664 = cljs.core.cst$kw$state;
var G__84665 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84664,G__84665) : pred__84657.call(null,G__84664,G__84665));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__84645,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84666 = cljs.core.cst$kw$req_DASH_chan;
var G__84667 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84666,G__84667) : pred__84657.call(null,G__84666,G__84667));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__84645,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84668 = cljs.core.cst$kw$sub_DASH_chan;
var G__84669 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84668,G__84669) : pred__84657.call(null,G__84668,G__84669));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__84645,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84670 = cljs.core.cst$kw$pub_DASH_chan;
var G__84671 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84670,G__84671) : pred__84657.call(null,G__84670,G__84671));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__84645,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84672 = cljs.core.cst$kw$storage_DASH_read;
var G__84673 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84672,G__84673) : pred__84657.call(null,G__84672,G__84673));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__84645,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84674 = cljs.core.cst$kw$storage_DASH_write;
var G__84675 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84674,G__84675) : pred__84657.call(null,G__84674,G__84675));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__84645,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84676 = cljs.core.cst$kw$object_DASH_cache;
var G__84677 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84676,G__84677) : pred__84657.call(null,G__84676,G__84677));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__84645,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84678 = cljs.core.cst$kw$parallelism;
var G__84679 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84678,G__84679) : pred__84657.call(null,G__84678,G__84679));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__84645,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84680 = cljs.core.cst$kw$serializer;
var G__84681 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84680,G__84681) : pred__84657.call(null,G__84680,G__84681));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__84645,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84682 = cljs.core.cst$kw$default_DASH_network;
var G__84683 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84682,G__84683) : pred__84657.call(null,G__84682,G__84683));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__84645,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84684 = cljs.core.cst$kw$transactor_QMARK_;
var G__84685 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84684,G__84685) : pred__84657.call(null,G__84684,G__84685));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__84645,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84686 = cljs.core.cst$kw$publish;
var G__84687 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84686,G__84687) : pred__84657.call(null,G__84686,G__84687));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__84645,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84688 = cljs.core.cst$kw$transact_DASH_handler;
var G__84689 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84688,G__84689) : pred__84657.call(null,G__84688,G__84689));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__84645,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84690 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__84691 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84690,G__84691) : pred__84657.call(null,G__84690,G__84691));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__84645,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84692 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__84693 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84692,G__84693) : pred__84657.call(null,G__84692,G__84693));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__84645,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84694 = cljs.core.cst$kw$meta;
var G__84695 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84694,G__84695) : pred__84657.call(null,G__84694,G__84695));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__84645,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84696 = cljs.core.cst$kw$add_DASH_listener;
var G__84697 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84696,G__84697) : pred__84657.call(null,G__84696,G__84697));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__84645,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84698 = cljs.core.cst$kw$remove_DASH_listener;
var G__84699 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84698,G__84699) : pred__84657.call(null,G__84698,G__84699));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__84645,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__84700 = cljs.core.cst$kw$close;
var G__84701 = expr__84658;
return (pred__84657.cljs$core$IFn$_invoke$arity$2 ? pred__84657.cljs$core$IFn$_invoke$arity$2(G__84700,G__84701) : pred__84657.call(null,G__84700,G__84701));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__84645,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__84645),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__84645){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__84645,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__84649){
var extmap__4501__auto__ = (function (){var G__84702 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__84649,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__84649)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__84702);
} else {
return G__84702;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__84649),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__84649),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__84708 = servers_STAR_;
var vec__84709 = G__84708;
var seq__84710 = cljs.core.seq(vec__84709);
var first__84711 = cljs.core.first(seq__84710);
var seq__84710__$1 = cljs.core.next(seq__84710);
var server = first__84711;
var r = seq__84710__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__84708__$1 = G__84708;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__84715 = G__84708__$1;
var seq__84716 = cljs.core.seq(vec__84715);
var first__84717 = cljs.core.first(seq__84716);
var seq__84716__$1 = cljs.core.next(seq__84716);
var server__$1 = first__84717;
var r__$1 = seq__84716__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__84718 = r__$1;
var G__84719 = is_https_QMARK_;
var G__84720 = result_STAR_;
G__84708__$1 = G__84718;
https_QMARK___$1 = G__84719;
result__$1 = G__84720;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__84721 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__84721 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__84721);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84750){
var state_val_84751 = (state_84750[(1)]);
if((state_val_84751 === (7))){
var inst_84736 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_84737 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_84738 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_84739 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_84740 = fluree.db.connection.establish_socket(inst_84736,inst_84737,inst_84738,inst_84739);
var state_84750__$1 = state_84750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84750__$1,(9),inst_84740);
} else {
if((state_val_84751 === (1))){
var state_84750__$1 = state_84750;
var statearr_84752_84771 = state_84750__$1;
(statearr_84752_84771[(2)] = null);

(statearr_84752_84771[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (4))){
var inst_84722 = (state_84750[(2)]);
var state_84750__$1 = state_84750;
var statearr_84753_84772 = state_84750__$1;
(statearr_84753_84772[(2)] = inst_84722);

(statearr_84753_84772[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (6))){
var inst_84733 = (state_84750[(7)]);
var state_84750__$1 = state_84750;
var statearr_84754_84773 = state_84750__$1;
(statearr_84754_84773[(2)] = inst_84733);

(statearr_84754_84773[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (3))){
var inst_84748 = (state_84750[(2)]);
var state_84750__$1 = state_84750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84750__$1,inst_84748);
} else {
if((state_val_84751 === (2))){
var inst_84733 = (state_84750[(7)]);
var _ = (function (){var statearr_84756 = state_84750;
(statearr_84756[(4)] = cljs.core.cons((5),(state_84750[(4)])));

return statearr_84756;
})();
var inst_84728 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_84729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84730 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_84731 = [inst_84730,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_84732 = (new cljs.core.PersistentVector(null,3,(5),inst_84729,inst_84731,null));
var inst_84733__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_84728,inst_84732);
var state_84750__$1 = (function (){var statearr_84757 = state_84750;
(statearr_84757[(7)] = inst_84733__$1);

return statearr_84757;
})();
if(cljs.core.truth_(inst_84733__$1)){
var statearr_84758_84774 = state_84750__$1;
(statearr_84758_84774[(1)] = (6));

} else {
var statearr_84759_84775 = state_84750__$1;
(statearr_84759_84775[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (9))){
var inst_84742 = (state_84750[(2)]);
var inst_84743 = fluree.db.util.async.throw_err(inst_84742);
var state_84750__$1 = state_84750;
var statearr_84760_84776 = state_84750__$1;
(statearr_84760_84776[(2)] = inst_84743);

(statearr_84760_84776[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (5))){
var _ = (function (){var statearr_84761 = state_84750;
(statearr_84761[(4)] = cljs.core.rest((state_84750[(4)])));

return statearr_84761;
})();
var state_84750__$1 = state_84750;
var ex84755 = (state_84750__$1[(2)]);
var statearr_84762_84777 = state_84750__$1;
(statearr_84762_84777[(5)] = ex84755);


if((ex84755 instanceof Error)){
var statearr_84763_84778 = state_84750__$1;
(statearr_84763_84778[(1)] = (4));

(statearr_84763_84778[(5)] = null);

} else {
throw ex84755;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84751 === (8))){
var inst_84745 = (state_84750[(2)]);
var _ = (function (){var statearr_84764 = state_84750;
(statearr_84764[(4)] = cljs.core.rest((state_84750[(4)])));

return statearr_84764;
})();
var state_84750__$1 = state_84750;
var statearr_84765_84779 = state_84750__$1;
(statearr_84765_84779[(2)] = inst_84745);

(statearr_84765_84779[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__24298__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__24298__auto____0 = (function (){
var statearr_84766 = [null,null,null,null,null,null,null,null];
(statearr_84766[(0)] = fluree$db$connection$get_socket_$_state_machine__24298__auto__);

(statearr_84766[(1)] = (1));

return statearr_84766;
});
var fluree$db$connection$get_socket_$_state_machine__24298__auto____1 = (function (state_84750){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84750);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84767){var ex__24301__auto__ = e84767;
var statearr_84768_84780 = state_84750;
(statearr_84768_84780[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84750[(4)]))){
var statearr_84769_84781 = state_84750;
(statearr_84769_84781[(1)] = cljs.core.first((state_84750[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84782 = state_84750;
state_84750 = G__84782;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__24298__auto__ = function(state_84750){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__24298__auto____1.call(this,state_84750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__24298__auto____0;
fluree$db$connection$get_socket_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__24298__auto____1;
return fluree$db$connection$get_socket_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84770 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84770[(6)] = c__24424__auto__);

return statearr_84770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e84783){var e = e84783;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84910){
var state_val_84911 = (state_84910[(1)]);
if((state_val_84911 === (7))){
var inst_84906 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84913_84983 = state_84910__$1;
(statearr_84913_84983[(2)] = inst_84906);

(statearr_84913_84983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (20))){
var _ = (function (){var statearr_84914 = state_84910;
(statearr_84914[(4)] = cljs.core.rest((state_84910[(4)])));

return statearr_84914;
})();
var state_84910__$1 = state_84910;
var ex84912 = (state_84910__$1[(2)]);
var statearr_84915_84984 = state_84910__$1;
(statearr_84915_84984[(5)] = ex84912);


var statearr_84916_84985 = state_84910__$1;
(statearr_84916_84985[(1)] = (10));

(statearr_84916_84985[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (27))){
var inst_84898 = (state_84910[(2)]);
var _ = (function (){var statearr_84917 = state_84910;
(statearr_84917[(4)] = cljs.core.rest((state_84910[(4)])));

return statearr_84917;
})();
var state_84910__$1 = state_84910;
var statearr_84918_84986 = state_84910__$1;
(statearr_84918_84986[(2)] = inst_84898);

(statearr_84918_84986[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (1))){
var inst_84785 = (0);
var state_84910__$1 = (function (){var statearr_84919 = state_84910;
(statearr_84919[(7)] = inst_84785);

return statearr_84919;
})();
var statearr_84920_84987 = state_84910__$1;
(statearr_84920_84987[(2)] = null);

(statearr_84920_84987[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (24))){
var inst_84876 = (state_84910[(8)]);
var inst_84876__$1 = (state_84910[(2)]);
var inst_84877 = inst_84876__$1 === true;
var state_84910__$1 = (function (){var statearr_84921 = state_84910;
(statearr_84921[(8)] = inst_84876__$1);

return statearr_84921;
})();
if(cljs.core.truth_(inst_84877)){
var statearr_84922_84988 = state_84910__$1;
(statearr_84922_84988[(1)] = (25));

} else {
var statearr_84923_84989 = state_84910__$1;
(statearr_84923_84989[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (4))){
var inst_84788 = (state_84910[(9)]);
var inst_84788__$1 = (state_84910[(2)]);
var state_84910__$1 = (function (){var statearr_84924 = state_84910;
(statearr_84924[(9)] = inst_84788__$1);

return statearr_84924;
})();
if(cljs.core.truth_(inst_84788__$1)){
var statearr_84925_84990 = state_84910__$1;
(statearr_84925_84990[(1)] = (5));

} else {
var statearr_84926_84991 = state_84910__$1;
(statearr_84926_84991[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (15))){
var inst_84801 = (state_84910[(10)]);
var state_84910__$1 = state_84910;
var statearr_84927_84992 = state_84910__$1;
(statearr_84927_84992[(2)] = inst_84801);

(statearr_84927_84992[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (21))){
var inst_84827 = (state_84910[(11)]);
var inst_84828 = (state_84910[(12)]);
var inst_84833 = (state_84910[(13)]);
var inst_84788 = (state_84910[(9)]);
var inst_84832 = (state_84910[(14)]);
var inst_84825 = (state_84910[(15)]);
var inst_84824 = (state_84910[(16)]);
var inst_84829 = (state_84910[(17)]);
var inst_84785 = (state_84910[(7)]);
var inst_84826 = (state_84910[(18)]);
var inst_84835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84836 = [cljs.core.cst$kw$pending_DASH_req,inst_84832];
var inst_84837 = (new cljs.core.PersistentVector(null,2,(5),inst_84835,inst_84836,null));
var inst_84838 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_84837,inst_84827);
var inst_84865 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_84866 = (function (){var resp_chan = inst_84827;
var timeout = inst_84833;
var vec__84820 = inst_84788;
var i = inst_84785;
var c__24424__auto____$1 = inst_84865;
var data = inst_84826;
var _ = inst_84824;
var req_id = inst_84832;
var operation = inst_84825;
var map__84823 = inst_84829;
var msg = inst_84788;
var opts = inst_84828;
return (function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84863){
var state_val_84864 = (state_84863[(1)]);
if((state_val_84864 === (1))){
var inst_84842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84843 = cljs.core.async.timeout(timeout);
var inst_84844 = [resp_chan,inst_84843];
var inst_84845 = (new cljs.core.PersistentVector(null,2,(5),inst_84842,inst_84844,null));
var state_84863__$1 = state_84863;
return cljs.core.async.ioc_alts_BANG_(state_84863__$1,(2),inst_84845);
} else {
if((state_val_84864 === (2))){
var inst_84848 = (state_84863[(7)]);
var inst_84847 = (state_84863[(2)]);
var inst_84848__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84847,(0),null);
var inst_84849 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84847,(1),null);
var inst_84850 = (function (){var vec__84839 = inst_84847;
var resp = inst_84848__$1;
var c = inst_84849;
return (function (p1__84784_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__84784_SHARP_,req_id);
});
})();
var inst_84851 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_84850);
var inst_84852 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_84849,resp_chan);
var state_84863__$1 = (function (){var statearr_84928 = state_84863;
(statearr_84928[(8)] = inst_84851);

(statearr_84928[(7)] = inst_84848__$1);

return statearr_84928;
})();
if(inst_84852){
var statearr_84929_84993 = state_84863__$1;
(statearr_84929_84993[(1)] = (3));

} else {
var statearr_84930_84994 = state_84863__$1;
(statearr_84930_84994[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84864 === (3))){
var inst_84848 = (state_84863[(7)]);
var state_84863__$1 = state_84863;
var statearr_84931_84995 = state_84863__$1;
(statearr_84931_84995[(2)] = inst_84848);

(statearr_84931_84995[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84864 === (4))){
var inst_84855 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_84856 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_84857 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_84858 = cljs.core.PersistentHashMap.fromArrays(inst_84856,inst_84857);
var inst_84859 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_84855,inst_84858);
var state_84863__$1 = state_84863;
var statearr_84932_84996 = state_84863__$1;
(statearr_84932_84996[(2)] = inst_84859);

(statearr_84932_84996[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84864 === (5))){
var inst_84861 = (state_84863[(2)]);
var state_84863__$1 = state_84863;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84863__$1,inst_84861);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__24298__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__24298__auto____0 = (function (){
var statearr_84933 = [null,null,null,null,null,null,null,null,null];
(statearr_84933[(0)] = fluree$db$connection$msg_producer_$_state_machine__24298__auto__);

(statearr_84933[(1)] = (1));

return statearr_84933;
});
var fluree$db$connection$msg_producer_$_state_machine__24298__auto____1 = (function (state_84863){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84863);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84934){var ex__24301__auto__ = e84934;
var statearr_84935_84997 = state_84863;
(statearr_84935_84997[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84863[(4)]))){
var statearr_84936_84998 = state_84863;
(statearr_84936_84998[(1)] = cljs.core.first((state_84863[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84999 = state_84863;
state_84863 = G__84999;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__24298__auto__ = function(state_84863){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__24298__auto____1.call(this,state_84863);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__24298__auto____0;
fluree$db$connection$msg_producer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__24298__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84937 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84937[(6)] = c__24424__auto____$1);

return statearr_84937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
});
})();
var inst_84867 = cljs.core.async.impl.dispatch.run(inst_84866);
var state_84910__$1 = (function (){var statearr_84938 = state_84910;
(statearr_84938[(19)] = inst_84867);

(statearr_84938[(20)] = inst_84838);

return statearr_84938;
})();
var statearr_84939_85000 = state_84910__$1;
(statearr_84939_85000[(2)] = inst_84865);

(statearr_84939_85000[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (31))){
var inst_84886 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_84910__$1 = state_84910;
var statearr_84940_85001 = state_84910__$1;
(statearr_84940_85001[(2)] = inst_84886);

(statearr_84940_85001[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (32))){
var state_84910__$1 = state_84910;
var statearr_84941_85002 = state_84910__$1;
(statearr_84941_85002[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (33))){
var inst_84894 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84943_85003 = state_84910__$1;
(statearr_84943_85003[(2)] = inst_84894);

(statearr_84943_85003[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (13))){
var inst_84801 = (state_84910[(10)]);
var inst_84798 = (state_84910[(2)]);
var inst_84799 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84798,(0),null);
var inst_84800 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84798,(1),null);
var inst_84801__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84798,(2),null);
var state_84910__$1 = (function (){var statearr_84944 = state_84910;
(statearr_84944[(10)] = inst_84801__$1);

(statearr_84944[(21)] = inst_84799);

(statearr_84944[(22)] = inst_84800);

return statearr_84944;
})();
if(cljs.core.truth_(inst_84801__$1)){
var statearr_84945_85004 = state_84910__$1;
(statearr_84945_85004[(1)] = (14));

} else {
var statearr_84946_85005 = state_84910__$1;
(statearr_84946_85005[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (22))){
var state_84910__$1 = state_84910;
var statearr_84947_85006 = state_84910__$1;
(statearr_84947_85006[(2)] = null);

(statearr_84947_85006[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (36))){
var inst_84892 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84948_85007 = state_84910__$1;
(statearr_84948_85007[(2)] = inst_84892);

(statearr_84948_85007[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (29))){
var inst_84876 = (state_84910[(8)]);
var inst_84884 = (inst_84876 == null);
var state_84910__$1 = state_84910;
if(cljs.core.truth_(inst_84884)){
var statearr_84949_85008 = state_84910__$1;
(statearr_84949_85008[(1)] = (31));

} else {
var statearr_84950_85009 = state_84910__$1;
(statearr_84950_85009[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (6))){
var state_84910__$1 = state_84910;
var statearr_84951_85010 = state_84910__$1;
(statearr_84951_85010[(2)] = null);

(statearr_84951_85010[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (28))){
var inst_84876 = (state_84910[(8)]);
var inst_84882 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_84876,"Error processing message in producer."], 0));
var state_84910__$1 = state_84910;
var statearr_84952_85011 = state_84910__$1;
(statearr_84952_85011[(2)] = inst_84882);

(statearr_84952_85011[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (25))){
var state_84910__$1 = state_84910;
var statearr_84953_85012 = state_84910__$1;
(statearr_84953_85012[(2)] = null);

(statearr_84953_85012[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (34))){
var inst_84876 = (state_84910[(8)]);
var inst_84889 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_84876], 0));
var state_84910__$1 = state_84910;
var statearr_84954_85013 = state_84910__$1;
(statearr_84954_85013[(2)] = inst_84889);

(statearr_84954_85013[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (17))){
var inst_84790 = (state_84910[(23)]);
var inst_84801 = (state_84910[(10)]);
var inst_84808 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_84801,inst_84790);
var state_84910__$1 = state_84910;
var statearr_84955_85014 = state_84910__$1;
(statearr_84955_85014[(2)] = inst_84808);

(statearr_84955_85014[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (3))){
var inst_84908 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84910__$1,inst_84908);
} else {
if((state_val_84911 === (12))){
var state_84910__$1 = state_84910;
var statearr_84956_85015 = state_84910__$1;
(statearr_84956_85015[(2)] = null);

(statearr_84956_85015[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (2))){
var state_84910__$1 = state_84910;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84910__$1,(4),req_chan);
} else {
if((state_val_84911 === (23))){
var inst_84832 = (state_84910[(14)]);
var inst_84825 = (state_84910[(15)]);
var inst_84826 = (state_84910[(18)]);
var inst_84870 = (state_84910[(2)]);
var inst_84871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_84872 = [inst_84825,inst_84832,inst_84826];
var inst_84873 = (new cljs.core.PersistentVector(null,3,(5),inst_84871,inst_84872,null));
var inst_84874 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_84873) : publish_fn.call(null,conn,inst_84873));
var state_84910__$1 = (function (){var statearr_84957 = state_84910;
(statearr_84957[(24)] = inst_84870);

return statearr_84957;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84910__$1,(24),inst_84874);
} else {
if((state_val_84911 === (35))){
var state_84910__$1 = state_84910;
var statearr_84958_85016 = state_84910__$1;
(statearr_84958_85016[(2)] = null);

(statearr_84958_85016[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (19))){
var inst_84814 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84959_85017 = state_84910__$1;
(statearr_84959_85017[(2)] = inst_84814);

(statearr_84959_85017[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (11))){
var inst_84788 = (state_84910[(9)]);
var state_84910__$1 = state_84910;
var statearr_84960_85018 = state_84910__$1;
(statearr_84960_85018[(2)] = inst_84788);

(statearr_84960_85018[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (9))){
var inst_84785 = (state_84910[(7)]);
var inst_84901 = (state_84910[(2)]);
var inst_84902 = (inst_84785 + (1));
var inst_84785__$1 = inst_84902;
var state_84910__$1 = (function (){var statearr_84961 = state_84910;
(statearr_84961[(7)] = inst_84785__$1);

(statearr_84961[(25)] = inst_84901);

return statearr_84961;
})();
var statearr_84962_85019 = state_84910__$1;
(statearr_84962_85019[(2)] = null);

(statearr_84962_85019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (5))){
var state_84910__$1 = state_84910;
var statearr_84963_85020 = state_84910__$1;
(statearr_84963_85020[(2)] = null);

(statearr_84963_85020[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (14))){
var inst_84801 = (state_84910[(10)]);
var inst_84803 = fluree.db.util.async.channel_QMARK_(inst_84801);
var state_84910__$1 = state_84910;
var statearr_84964_85021 = state_84910__$1;
(statearr_84964_85021[(2)] = inst_84803);

(statearr_84964_85021[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (26))){
var inst_84876 = (state_84910[(8)]);
var inst_84880 = fluree.db.util.core.exception_QMARK_(inst_84876);
var state_84910__$1 = state_84910;
if(inst_84880){
var statearr_84965_85022 = state_84910__$1;
(statearr_84965_85022[(1)] = (28));

} else {
var statearr_84966_85023 = state_84910__$1;
(statearr_84966_85023[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (16))){
var inst_84806 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
if(cljs.core.truth_(inst_84806)){
var statearr_84967_85024 = state_84910__$1;
(statearr_84967_85024[(1)] = (17));

} else {
var statearr_84968_85025 = state_84910__$1;
(statearr_84968_85025[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (30))){
var inst_84896 = (state_84910[(2)]);
var state_84910__$1 = state_84910;
var statearr_84969_85026 = state_84910__$1;
(statearr_84969_85026[(2)] = inst_84896);

(statearr_84969_85026[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (10))){
var inst_84788 = (state_84910[(9)]);
var inst_84790 = (state_84910[(2)]);
var inst_84794 = cljs.core.sequential_QMARK_(inst_84788);
var state_84910__$1 = (function (){var statearr_84970 = state_84910;
(statearr_84970[(23)] = inst_84790);

return statearr_84970;
})();
if(inst_84794){
var statearr_84971_85027 = state_84910__$1;
(statearr_84971_85027[(1)] = (11));

} else {
var statearr_84972_85028 = state_84910__$1;
(statearr_84972_85028[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (18))){
var inst_84790 = (state_84910[(23)]);
var inst_84788 = (state_84910[(9)]);
var inst_84810 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_84788], 0));
var inst_84811 = ["Error processing ledger request, no valid return channel: ",inst_84810].join('');
var inst_84812 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_84790,inst_84811], 0));
var state_84910__$1 = state_84910;
var statearr_84973_85029 = state_84910__$1;
(statearr_84973_85029[(2)] = inst_84812);

(statearr_84973_85029[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84911 === (8))){
var inst_84827 = (state_84910[(11)]);
var inst_84828 = (state_84910[(12)]);
var inst_84788 = (state_84910[(9)]);
var inst_84829 = (state_84910[(17)]);
var _ = (function (){var statearr_84974 = state_84910;
(statearr_84974[(4)] = cljs.core.cons((20),(state_84910[(4)])));

return statearr_84974;
})();
var inst_84824 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_84788], 0));
var inst_84825 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84788,(0),null);
var inst_84826 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84788,(1),null);
var inst_84827__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84788,(2),null);
var inst_84828__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_84788,(3),null);
var inst_84829__$1 = cljs.core.__destructure_map(inst_84828__$1);
var inst_84830 = fluree.db.util.core.random_uuid();
var inst_84831 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_84830);
var inst_84832 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_84829__$1,cljs.core.cst$kw$req_DASH_id,inst_84831);
var inst_84833 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_84829__$1,cljs.core.cst$kw$timeout,(60000));
var state_84910__$1 = (function (){var statearr_84975 = state_84910;
(statearr_84975[(11)] = inst_84827__$1);

(statearr_84975[(12)] = inst_84828__$1);

(statearr_84975[(13)] = inst_84833);

(statearr_84975[(14)] = inst_84832);

(statearr_84975[(15)] = inst_84825);

(statearr_84975[(16)] = inst_84824);

(statearr_84975[(17)] = inst_84829__$1);

(statearr_84975[(18)] = inst_84826);

return statearr_84975;
})();
if(cljs.core.truth_(inst_84827__$1)){
var statearr_84976_85030 = state_84910__$1;
(statearr_84976_85030[(1)] = (21));

} else {
var statearr_84977_85031 = state_84910__$1;
(statearr_84977_85031[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__24298__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__24298__auto____0 = (function (){
var statearr_84978 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84978[(0)] = fluree$db$connection$msg_producer_$_state_machine__24298__auto__);

(statearr_84978[(1)] = (1));

return statearr_84978;
});
var fluree$db$connection$msg_producer_$_state_machine__24298__auto____1 = (function (state_84910){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84910);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84979){var ex__24301__auto__ = e84979;
var statearr_84980_85032 = state_84910;
(statearr_84980_85032[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84910[(4)]))){
var statearr_84981_85033 = state_84910;
(statearr_84981_85033[(1)] = cljs.core.first((state_84910[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__85034 = state_84910;
state_84910 = G__85034;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__24298__auto__ = function(state_84910){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__24298__auto____1.call(this,state_84910);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__24298__auto____0;
fluree$db$connection$msg_producer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__24298__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84982 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84982[(6)] = c__24424__auto__);

return statearr_84982;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__85035 = conn;
var map__85035__$1 = cljs.core.__destructure_map(map__85035);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85035__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_85120){
var state_val_85121 = (state_85120[(1)]);
if((state_val_85121 === (7))){
var inst_85116 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85122_85173 = state_85120__$1;
(statearr_85122_85173[(2)] = inst_85116);

(statearr_85122_85173[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (20))){
var inst_85054 = (state_85120[(7)]);
var inst_85068 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_85069 = [inst_85054];
var inst_85070 = cljs.core.PersistentHashMap.fromArrays(inst_85068,inst_85069);
var inst_85071 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_85070], 0));
var state_85120__$1 = state_85120;
var statearr_85123_85174 = state_85120__$1;
(statearr_85123_85174[(2)] = inst_85071);

(statearr_85123_85174[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (27))){
var state_85120__$1 = state_85120;
var statearr_85124_85175 = state_85120__$1;
(statearr_85124_85175[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (1))){
var inst_85036 = (0);
var state_85120__$1 = (function (){var statearr_85126 = state_85120;
(statearr_85126[(8)] = inst_85036);

return statearr_85126;
})();
var statearr_85127_85176 = state_85120__$1;
(statearr_85127_85176[(2)] = null);

(statearr_85127_85176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (24))){
var inst_85047 = (state_85120[(9)]);
var inst_85096 = fluree.db.util.core.exception_QMARK_(inst_85047);
var state_85120__$1 = state_85120;
if(inst_85096){
var statearr_85128_85177 = state_85120__$1;
(statearr_85128_85177[(1)] = (26));

} else {
var statearr_85129_85178 = state_85120__$1;
(statearr_85129_85178[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (4))){
var inst_85041 = (state_85120[(10)]);
var inst_85046 = (state_85120[(2)]);
var inst_85047 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85046,(0),null);
var inst_85048 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_85046,(1),null);
var inst_85049 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_85048,inst_85041);
var state_85120__$1 = (function (){var statearr_85130 = state_85120;
(statearr_85130[(9)] = inst_85047);

return statearr_85130;
})();
if(inst_85049){
var statearr_85131_85179 = state_85120__$1;
(statearr_85131_85179[(1)] = (5));

} else {
var statearr_85132_85180 = state_85120__$1;
(statearr_85132_85180[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (15))){
var inst_85054 = (state_85120[(7)]);
var inst_85063 = typeof inst_85054 === 'string';
var state_85120__$1 = state_85120;
if(cljs.core.truth_(inst_85063)){
var statearr_85133_85181 = state_85120__$1;
(statearr_85133_85181[(1)] = (17));

} else {
var statearr_85134_85182 = state_85120__$1;
(statearr_85134_85182[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (21))){
var state_85120__$1 = state_85120;
var statearr_85135_85183 = state_85120__$1;
(statearr_85135_85183[(2)] = null);

(statearr_85135_85183[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (31))){
var inst_85110 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85136_85184 = state_85120__$1;
(statearr_85136_85184[(2)] = inst_85110);

(statearr_85136_85184[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (13))){
var inst_85080 = (state_85120[(2)]);
var inst_85081 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_85082 = fluree.db.connection.close_websocket(inst_85081);
var inst_85083 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_85084 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_85083);
var state_85120__$1 = (function (){var statearr_85137 = state_85120;
(statearr_85137[(11)] = inst_85082);

(statearr_85137[(12)] = inst_85080);

return statearr_85137;
})();
var statearr_85138_85185 = state_85120__$1;
(statearr_85138_85185[(2)] = inst_85084);

(statearr_85138_85185[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (22))){
var inst_85074 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85139_85186 = state_85120__$1;
(statearr_85139_85186[(2)] = inst_85074);

(statearr_85139_85186[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (29))){
var inst_85047 = (state_85120[(9)]);
var inst_85102 = fluree.db.util.json.parse(inst_85047);
var inst_85103 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_85102], 0));
var inst_85104 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_85103], 0));
var inst_85105 = fluree.db.util.json.parse(inst_85047);
var inst_85106 = fluree.db.conn_events.process_events(conn,inst_85105);
var inst_85036 = (0);
var state_85120__$1 = (function (){var statearr_85140 = state_85120;
(statearr_85140[(8)] = inst_85036);

(statearr_85140[(13)] = inst_85104);

(statearr_85140[(14)] = inst_85106);

return statearr_85140;
})();
var statearr_85141_85187 = state_85120__$1;
(statearr_85141_85187[(2)] = null);

(statearr_85141_85187[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (6))){
var inst_85047 = (state_85120[(9)]);
var inst_85092 = (inst_85047 == null);
var state_85120__$1 = state_85120;
if(cljs.core.truth_(inst_85092)){
var statearr_85142_85188 = state_85120__$1;
(statearr_85142_85188[(1)] = (23));

} else {
var statearr_85143_85189 = state_85120__$1;
(statearr_85143_85189[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (28))){
var inst_85112 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85144_85190 = state_85120__$1;
(statearr_85144_85190[(2)] = inst_85112);

(statearr_85144_85190[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (25))){
var inst_85114 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85145_85191 = state_85120__$1;
(statearr_85145_85191[(2)] = inst_85114);

(statearr_85145_85191[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (17))){
var inst_85054 = (state_85120[(7)]);
var inst_85065 = cljs.core.eval(inst_85054);
var state_85120__$1 = state_85120;
var statearr_85146_85192 = state_85120__$1;
(statearr_85146_85192[(2)] = inst_85065);

(statearr_85146_85192[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (3))){
var inst_85118 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85120__$1,inst_85118);
} else {
if((state_val_85121 === (12))){
var inst_85054 = (state_85120[(7)]);
var inst_85059 = cljs.core.fn_QMARK_(inst_85054);
var state_85120__$1 = state_85120;
if(inst_85059){
var statearr_85147_85193 = state_85120__$1;
(statearr_85147_85193[(1)] = (14));

} else {
var statearr_85148_85194 = state_85120__$1;
(statearr_85148_85194[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (2))){
var inst_85041 = (state_85120[(10)]);
var inst_85041__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_85042 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85043 = [sub_chan,inst_85041__$1];
var inst_85044 = (new cljs.core.PersistentVector(null,2,(5),inst_85042,inst_85043,null));
var state_85120__$1 = (function (){var statearr_85149 = state_85120;
(statearr_85149[(10)] = inst_85041__$1);

return statearr_85149;
})();
return cljs.core.async.ioc_alts_BANG_(state_85120__$1,(4),inst_85044);
} else {
if((state_val_85121 === (23))){
var inst_85094 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_85120__$1 = state_85120;
var statearr_85150_85195 = state_85120__$1;
(statearr_85150_85195[(2)] = inst_85094);

(statearr_85150_85195[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (19))){
var inst_85076 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85151_85196 = state_85120__$1;
(statearr_85151_85196[(2)] = inst_85076);

(statearr_85151_85196[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (11))){
var inst_85057 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_85120__$1 = state_85120;
var statearr_85152_85197 = state_85120__$1;
(statearr_85152_85197[(2)] = inst_85057);

(statearr_85152_85197[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (9))){
var inst_85036 = (state_85120[(8)]);
var inst_85086 = fluree.db.connection.ping_transactor(conn);
var inst_85087 = (inst_85036 + (1));
var inst_85036__$1 = inst_85087;
var state_85120__$1 = (function (){var statearr_85153 = state_85120;
(statearr_85153[(8)] = inst_85036__$1);

(statearr_85153[(15)] = inst_85086);

return statearr_85153;
})();
var statearr_85154_85198 = state_85120__$1;
(statearr_85154_85198[(2)] = null);

(statearr_85154_85198[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (5))){
var inst_85036 = (state_85120[(8)]);
var inst_85051 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_85036);
var state_85120__$1 = state_85120;
if(inst_85051){
var statearr_85155_85199 = state_85120__$1;
(statearr_85155_85199[(1)] = (8));

} else {
var statearr_85156_85200 = state_85120__$1;
(statearr_85156_85200[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (14))){
var inst_85054 = (state_85120[(7)]);
var inst_85061 = (inst_85054.cljs$core$IFn$_invoke$arity$0 ? inst_85054.cljs$core$IFn$_invoke$arity$0() : inst_85054.call(null));
var state_85120__$1 = state_85120;
var statearr_85157_85201 = state_85120__$1;
(statearr_85157_85201[(2)] = inst_85061);

(statearr_85157_85201[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (26))){
var inst_85047 = (state_85120[(9)]);
var inst_85098 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_85047], 0));
var inst_85036 = (0);
var state_85120__$1 = (function (){var statearr_85158 = state_85120;
(statearr_85158[(16)] = inst_85098);

(statearr_85158[(8)] = inst_85036);

return statearr_85158;
})();
var statearr_85159_85202 = state_85120__$1;
(statearr_85159_85202[(2)] = null);

(statearr_85159_85202[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (16))){
var inst_85078 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85160_85203 = state_85120__$1;
(statearr_85160_85203[(2)] = inst_85078);

(statearr_85160_85203[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (30))){
var state_85120__$1 = state_85120;
var statearr_85161_85204 = state_85120__$1;
(statearr_85161_85204[(2)] = null);

(statearr_85161_85204[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (10))){
var inst_85090 = (state_85120[(2)]);
var state_85120__$1 = state_85120;
var statearr_85162_85205 = state_85120__$1;
(statearr_85162_85205[(2)] = inst_85090);

(statearr_85162_85205[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (18))){
var state_85120__$1 = state_85120;
var statearr_85163_85206 = state_85120__$1;
(statearr_85163_85206[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_85121 === (8))){
var inst_85054 = (state_85120[(7)]);
var inst_85053 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_85054__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_85055 = (inst_85054__$1 == null);
var state_85120__$1 = (function (){var statearr_85165 = state_85120;
(statearr_85165[(17)] = inst_85053);

(statearr_85165[(7)] = inst_85054__$1);

return statearr_85165;
})();
if(cljs.core.truth_(inst_85055)){
var statearr_85166_85207 = state_85120__$1;
(statearr_85166_85207[(1)] = (11));

} else {
var statearr_85167_85208 = state_85120__$1;
(statearr_85167_85208[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__24298__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__24298__auto____0 = (function (){
var statearr_85168 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_85168[(0)] = fluree$db$connection$msg_consumer_$_state_machine__24298__auto__);

(statearr_85168[(1)] = (1));

return statearr_85168;
});
var fluree$db$connection$msg_consumer_$_state_machine__24298__auto____1 = (function (state_85120){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_85120);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e85169){var ex__24301__auto__ = e85169;
var statearr_85170_85209 = state_85120;
(statearr_85170_85209[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_85120[(4)]))){
var statearr_85171_85210 = state_85120;
(statearr_85171_85210[(1)] = cljs.core.first((state_85120[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__85211 = state_85120;
state_85120 = G__85211;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__24298__auto__ = function(state_85120){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__24298__auto____1.call(this,state_85120);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__24298__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__24298__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_85172 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_85172[(6)] = c__24424__auto__);

return statearr_85172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__85213 = arguments.length;
switch (G__85213) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__85214 = opts;
var map__85214__$1 = cljs.core.__destructure_map(map__85214);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85214__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85214__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_85266){
var state_val_85267 = (state_85266[(1)]);
if((state_val_85267 === (7))){
var inst_85224 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_85225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_85226 = [conn_id,cljs.core.cst$kw$token];
var inst_85227 = (new cljs.core.PersistentVector(null,2,(5),inst_85225,inst_85226,null));
var inst_85228 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_85224,inst_85227);
var state_85266__$1 = state_85266;
var statearr_85268_85299 = state_85266__$1;
(statearr_85268_85299[(2)] = inst_85228);

(statearr_85268_85299[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (1))){
var state_85266__$1 = state_85266;
var statearr_85269_85300 = state_85266__$1;
(statearr_85269_85300[(2)] = null);

(statearr_85269_85300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (4))){
var inst_85215 = (state_85266[(2)]);
var state_85266__$1 = state_85266;
var statearr_85270_85301 = state_85266__$1;
(statearr_85270_85301[(2)] = inst_85215);

(statearr_85270_85301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (15))){
var inst_85235 = (state_85266[(7)]);
var inst_85254 = (state_85266[(2)]);
var inst_85255 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_85256 = [(5000),inst_85254,cljs.core.cst$kw$text];
var inst_85257 = cljs.core.PersistentHashMap.fromArrays(inst_85255,inst_85256);
var inst_85258 = fluree.db.util.xhttp.get(inst_85235,inst_85257);
var state_85266__$1 = state_85266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85266__$1,(16),inst_85258);
} else {
if((state_val_85267 === (13))){
var inst_85235 = (state_85266[(7)]);
var inst_85245 = (state_85266[(8)]);
var inst_85247 = [cljs.core.cst$kw$headers];
var inst_85248 = [inst_85245];
var inst_85249 = cljs.core.PersistentHashMap.fromArrays(inst_85247,inst_85248);
var inst_85250 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_85235,inst_85249,private$);
var inst_85251 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_85250);
var state_85266__$1 = state_85266;
var statearr_85271_85302 = state_85266__$1;
(statearr_85271_85302[(2)] = inst_85251);

(statearr_85271_85302[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (6))){
var inst_85221 = (state_85266[(9)]);
var state_85266__$1 = state_85266;
var statearr_85272_85303 = state_85266__$1;
(statearr_85272_85303[(2)] = inst_85221);

(statearr_85272_85303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (3))){
var inst_85264 = (state_85266[(2)]);
var state_85266__$1 = state_85266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85266__$1,inst_85264);
} else {
if((state_val_85267 === (12))){
var inst_85245 = (state_85266[(2)]);
var state_85266__$1 = (function (){var statearr_85273 = state_85266;
(statearr_85273[(8)] = inst_85245);

return statearr_85273;
})();
if(cljs.core.truth_(private$)){
var statearr_85274_85304 = state_85266__$1;
(statearr_85274_85304[(1)] = (13));

} else {
var statearr_85275_85305 = state_85266__$1;
(statearr_85275_85305[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (2))){
var inst_85221 = (state_85266[(9)]);
var _ = (function (){var statearr_85276 = state_85266;
(statearr_85276[(4)] = cljs.core.cons((5),(state_85266[(4)])));

return statearr_85276;
})();
var inst_85221__$1 = jwt;
var state_85266__$1 = (function (){var statearr_85277 = state_85266;
(statearr_85277[(9)] = inst_85221__$1);

return statearr_85277;
})();
if(cljs.core.truth_(inst_85221__$1)){
var statearr_85278_85306 = state_85266__$1;
(statearr_85278_85306[(1)] = (6));

} else {
var statearr_85279_85307 = state_85266__$1;
(statearr_85279_85307[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (11))){
var inst_85239 = (state_85266[(10)]);
var state_85266__$1 = state_85266;
var statearr_85281_85308 = state_85266__$1;
(statearr_85281_85308[(2)] = inst_85239);

(statearr_85281_85308[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (9))){
var inst_85230 = (state_85266[(11)]);
var inst_85231 = (state_85266[(12)]);
var inst_85234 = (state_85266[(2)]);
var inst_85235 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85234),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85231)].join('');
var inst_85237 = ["Accept"];
var inst_85238 = ["application/json"];
var inst_85239 = cljs.core.PersistentHashMap.fromArrays(inst_85237,inst_85238);
var state_85266__$1 = (function (){var statearr_85282 = state_85266;
(statearr_85282[(10)] = inst_85239);

(statearr_85282[(7)] = inst_85235);

return statearr_85282;
})();
if(cljs.core.truth_(inst_85230)){
var statearr_85283_85309 = state_85266__$1;
(statearr_85283_85309[(1)] = (10));

} else {
var statearr_85284_85310 = state_85266__$1;
(statearr_85284_85310[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (5))){
var _ = (function (){var statearr_85285 = state_85266;
(statearr_85285[(4)] = cljs.core.rest((state_85266[(4)])));

return statearr_85285;
})();
var state_85266__$1 = state_85266;
var ex85280 = (state_85266__$1[(2)]);
var statearr_85286_85311 = state_85266__$1;
(statearr_85286_85311[(5)] = ex85280);


if((ex85280 instanceof Error)){
var statearr_85287_85312 = state_85266__$1;
(statearr_85287_85312[(1)] = (4));

(statearr_85287_85312[(5)] = null);

} else {
throw ex85280;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (14))){
var inst_85245 = (state_85266[(8)]);
var state_85266__$1 = state_85266;
var statearr_85288_85313 = state_85266__$1;
(statearr_85288_85313[(2)] = inst_85245);

(statearr_85288_85313[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (16))){
var inst_85260 = (state_85266[(2)]);
var inst_85261 = fluree.db.util.async.throw_err(inst_85260);
var _ = (function (){var statearr_85289 = state_85266;
(statearr_85289[(4)] = cljs.core.rest((state_85266[(4)])));

return statearr_85289;
})();
var state_85266__$1 = state_85266;
var statearr_85290_85314 = state_85266__$1;
(statearr_85290_85314[(2)] = inst_85261);

(statearr_85290_85314[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (10))){
var inst_85230 = (state_85266[(11)]);
var inst_85239 = (state_85266[(10)]);
var inst_85241 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_85230)].join('');
var inst_85242 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_85239,"Authorization",inst_85241);
var state_85266__$1 = state_85266;
var statearr_85291_85315 = state_85266__$1;
(statearr_85291_85315[(2)] = inst_85242);

(statearr_85291_85315[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85267 === (8))){
var inst_85230 = (state_85266[(2)]);
var inst_85231 = clojure.string.replace(k,"_","/");
var inst_85232 = fluree.db.connection.get_server(conn_id,servers);
var state_85266__$1 = (function (){var statearr_85292 = state_85266;
(statearr_85292[(11)] = inst_85230);

(statearr_85292[(12)] = inst_85231);

return statearr_85292;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85266__$1,(9),inst_85232);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__24298__auto__ = null;
var fluree$db$connection$state_machine__24298__auto____0 = (function (){
var statearr_85293 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_85293[(0)] = fluree$db$connection$state_machine__24298__auto__);

(statearr_85293[(1)] = (1));

return statearr_85293;
});
var fluree$db$connection$state_machine__24298__auto____1 = (function (state_85266){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_85266);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e85294){var ex__24301__auto__ = e85294;
var statearr_85295_85316 = state_85266;
(statearr_85295_85316[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_85266[(4)]))){
var statearr_85296_85317 = state_85266;
(statearr_85296_85317[(1)] = cljs.core.first((state_85266[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__85318 = state_85266;
state_85266 = G__85318;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$state_machine__24298__auto__ = function(state_85266){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__24298__auto____1.call(this,state_85266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__24298__auto____0;
fluree$db$connection$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__24298__auto____1;
return fluree$db$connection$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_85297 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_85297[(6)] = c__24424__auto__);

return statearr_85297;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__85319_SHARP_){
if(cljs.core.truth_(p1__85319_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__85320_SHARP_){
var or__4212__auto__ = p1__85320_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e85321){var e = e85321;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__85322 = opts;
var map__85322__$1 = cljs.core.__destructure_map(map__85322);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__85322__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__85322__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__85323_85324 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__85323_85324.cljs$core$IFn$_invoke$arity$0 ? fexpr__85323_85324.cljs$core$IFn$_invoke$arity$0() : fexpr__85323_85324.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___85365 = arguments.length;
var i__4819__auto___85366 = (0);
while(true){
if((i__4819__auto___85366 < len__4818__auto___85365)){
args__4824__auto__.push((arguments[i__4819__auto___85366]));

var G__85367 = (i__4819__auto___85366 + (1));
i__4819__auto___85366 = G__85367;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__85327){
var vec__85328 = p__85327;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__85328,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__24424__auto___85368 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_85348){
var state_val_85349 = (state_85348[(1)]);
if((state_val_85349 === (1))){
var inst_85331 = fluree.db.connection.get_socket(conn);
var state_85348__$1 = state_85348;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_85348__$1,(2),inst_85331);
} else {
if((state_val_85349 === (2))){
var inst_85334 = (state_85348[(7)]);
var inst_85333 = (state_85348[(8)]);
var inst_85333__$1 = (state_85348[(2)]);
var inst_85334__$1 = (inst_85333__$1 == null);
var state_85348__$1 = (function (){var statearr_85350 = state_85348;
(statearr_85350[(7)] = inst_85334__$1);

(statearr_85350[(8)] = inst_85333__$1);

return statearr_85350;
})();
if(cljs.core.truth_(inst_85334__$1)){
var statearr_85351_85369 = state_85348__$1;
(statearr_85351_85369[(1)] = (3));

} else {
var statearr_85352_85370 = state_85348__$1;
(statearr_85352_85370[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (3))){
var inst_85334 = (state_85348[(7)]);
var state_85348__$1 = state_85348;
var statearr_85353_85371 = state_85348__$1;
(statearr_85353_85371[(2)] = inst_85334);

(statearr_85353_85371[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (4))){
var inst_85333 = (state_85348[(8)]);
var inst_85337 = fluree.db.util.core.exception_QMARK_(inst_85333);
var state_85348__$1 = state_85348;
var statearr_85354_85372 = state_85348__$1;
(statearr_85354_85372[(2)] = inst_85337);

(statearr_85354_85372[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (5))){
var inst_85339 = (state_85348[(2)]);
var state_85348__$1 = state_85348;
if(cljs.core.truth_(inst_85339)){
var statearr_85355_85373 = state_85348__$1;
(statearr_85355_85373[(1)] = (6));

} else {
var statearr_85356_85374 = state_85348__$1;
(statearr_85356_85374[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (6))){
var inst_85333 = (state_85348[(8)]);
var inst_85341 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_85333,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_85342 = cljs.core.async.close_BANG_(conn);
var state_85348__$1 = (function (){var statearr_85357 = state_85348;
(statearr_85357[(9)] = inst_85341);

return statearr_85357;
})();
var statearr_85358_85375 = state_85348__$1;
(statearr_85358_85375[(2)] = inst_85342);

(statearr_85358_85375[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (7))){
var inst_85344 = fluree.db.connection.msg_consumer(conn);
var state_85348__$1 = state_85348;
var statearr_85359_85376 = state_85348__$1;
(statearr_85359_85376[(2)] = inst_85344);

(statearr_85359_85376[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_85349 === (8))){
var inst_85346 = (state_85348[(2)]);
var state_85348__$1 = state_85348;
return cljs.core.async.impl.ioc_helpers.return_chan(state_85348__$1,inst_85346);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__24298__auto__ = null;
var fluree$db$connection$state_machine__24298__auto____0 = (function (){
var statearr_85360 = [null,null,null,null,null,null,null,null,null,null];
(statearr_85360[(0)] = fluree$db$connection$state_machine__24298__auto__);

(statearr_85360[(1)] = (1));

return statearr_85360;
});
var fluree$db$connection$state_machine__24298__auto____1 = (function (state_85348){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_85348);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e85361){var ex__24301__auto__ = e85361;
var statearr_85362_85377 = state_85348;
(statearr_85362_85377[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_85348[(4)]))){
var statearr_85363_85378 = state_85348;
(statearr_85363_85378[(1)] = cljs.core.first((state_85348[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__85379 = state_85348;
state_85348 = G__85379;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$connection$state_machine__24298__auto__ = function(state_85348){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__24298__auto____1.call(this,state_85348);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__24298__auto____0;
fluree$db$connection$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__24298__auto____1;
return fluree$db$connection$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_85364 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_85364[(6)] = c__24424__auto___85368);

return statearr_85364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq85325){
var G__85326 = cljs.core.first(seq85325);
var seq85325__$1 = cljs.core.next(seq85325);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__85326,seq85325__$1);
}));

