// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4210__auto__ = typeof value === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4210__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,716,null,716,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,814,null,814,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,523,null,523,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,429,null,429,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,390,null,390,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,728,null,728,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,535,null,535,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,609,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,622,null,622,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,752,null,752,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,780,null,780,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,698,null,698,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,416,null,416,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,377,null,377,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,468,null,468,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,790,null,790,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,570,null,570,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,377,null,377,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,661,null,661,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,455,null,455,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,596,null,596,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,508,null,508,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,560,null,560,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,547,null,547,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,802,null,802,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,442,null,442,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,403,null,403,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,583,null,583,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,764,null,764,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,349,349,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,363,363,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),null,(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,686,null,686,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,635,null,635,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,648,null,648,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,481,null,481,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,740,null,740,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,673,null,673,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__83303 = cljs.core.meta(f);
var map__83303__$1 = cljs.core.__destructure_map(map__83303);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83303__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__83303__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4210__auto__ = (function (){var G__83305 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__83304 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__83304.cljs$core$IFn$_invoke$arity$1 ? fexpr__83304.cljs$core$IFn$_invoke$arity$1(G__83305) : fexpr__83304.call(null,G__83305));
})();
if(cljs.core.truth_(and__4210__auto__)){
var G__83307 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__83306 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__83306.cljs$core$IFn$_invoke$arity$1 ? fexpr__83306.cljs$core$IFn$_invoke$arity$1(G__83307) : fexpr__83306.call(null,G__83307));
} else {
return and__4210__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__83302_SHARP_){
return (cljs.core.count(p1__83302_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83392){
var state_val_83393 = (state_83392[(1)]);
if((state_val_83393 === (7))){
var inst_83317 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_83318 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83319 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_83320 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_83321 = [fn_name,inst_83319,inst_83320];
var inst_83322 = (new cljs.core.PersistentVector(null,3,(5),inst_83318,inst_83321,null));
var inst_83323 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83317,inst_83322);
var state_83392__$1 = state_83392;
var statearr_83394_83431 = state_83392__$1;
(statearr_83394_83431[(2)] = inst_83323);

(statearr_83394_83431[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (1))){
var state_83392__$1 = state_83392;
var statearr_83395_83432 = state_83392__$1;
(statearr_83395_83432[(2)] = null);

(statearr_83395_83432[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (4))){
var inst_83308 = (state_83392[(2)]);
var state_83392__$1 = state_83392;
var statearr_83396_83433 = state_83392__$1;
(statearr_83396_83433[(2)] = inst_83308);

(statearr_83396_83433[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (15))){
var inst_83341 = (state_83392[(7)]);
var inst_83355 = (state_83392[(8)]);
var inst_83353 = (state_83392[(2)]);
var inst_83354 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83341,"_fn/params");
var inst_83355__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_83354);
var inst_83356 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83341,"_fn/code");
var inst_83357 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_83356);
var inst_83358 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_83357,funType,inst_83355__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_83357,funType,inst_83355__$1));
var state_83392__$1 = (function (){var statearr_83397 = state_83392;
(statearr_83397[(9)] = inst_83353);

(statearr_83397[(8)] = inst_83355__$1);

return statearr_83397;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83392__$1,(16),inst_83358);
} else {
if((state_val_83393 === (13))){
var inst_83344 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_83345 = ["Unknown function: ",inst_83344].join('');
var inst_83346 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_83347 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_83348 = cljs.core.PersistentHashMap.fromArrays(inst_83346,inst_83347);
var inst_83349 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83345,inst_83348);
var inst_83350 = (function(){throw inst_83349})();
var state_83392__$1 = state_83392;
var statearr_83398_83434 = state_83392__$1;
(statearr_83398_83434[(2)] = inst_83350);

(statearr_83398_83434[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (6))){
var state_83392__$1 = state_83392;
var statearr_83399_83435 = state_83392__$1;
(statearr_83399_83435[(2)] = null);

(statearr_83399_83435[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (17))){
var state_83392__$1 = state_83392;
var statearr_83400_83436 = state_83392__$1;
(statearr_83400_83436[(2)] = null);

(statearr_83400_83436[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (3))){
var inst_83390 = (state_83392[(2)]);
var state_83392__$1 = state_83392;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83392__$1,inst_83390);
} else {
if((state_val_83393 === (12))){
var inst_83341 = (state_83392[(7)]);
var inst_83340 = (state_83392[(2)]);
var inst_83341__$1 = fluree.db.util.async.throw_err(inst_83340);
var inst_83342 = cljs.core.empty_QMARK_(inst_83341__$1);
var state_83392__$1 = (function (){var statearr_83401 = state_83392;
(statearr_83401[(7)] = inst_83341__$1);

return statearr_83401;
})();
if(inst_83342){
var statearr_83402_83437 = state_83392__$1;
(statearr_83402_83437[(1)] = (13));

} else {
var statearr_83403_83438 = state_83392__$1;
(statearr_83403_83438[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (2))){
var inst_83314 = (state_83392[(10)]);
var _ = (function (){var statearr_83404 = state_83392;
(statearr_83404[(4)] = cljs.core.cons((5),(state_83392[(4)])));

return statearr_83404;
})();
var inst_83314__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_83392__$1 = (function (){var statearr_83405 = state_83392;
(statearr_83405[(10)] = inst_83314__$1);

return statearr_83405;
})();
if(cljs.core.truth_(inst_83314__$1)){
var statearr_83406_83439 = state_83392__$1;
(statearr_83406_83439[(1)] = (6));

} else {
var statearr_83407_83440 = state_83392__$1;
(statearr_83407_83440[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (19))){
var inst_83375 = (state_83392[(11)]);
var inst_83385 = (state_83392[(2)]);
var state_83392__$1 = (function (){var statearr_83408 = state_83392;
(statearr_83408[(12)] = inst_83385);

return statearr_83408;
})();
var statearr_83409_83441 = state_83392__$1;
(statearr_83409_83441[(2)] = inst_83375);

(statearr_83409_83441[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (11))){
var inst_83387 = (state_83392[(2)]);
var _ = (function (){var statearr_83411 = state_83392;
(statearr_83411[(4)] = cljs.core.rest((state_83392[(4)])));

return statearr_83411;
})();
var state_83392__$1 = state_83392;
var statearr_83412_83442 = state_83392__$1;
(statearr_83412_83442[(2)] = inst_83387);

(statearr_83412_83442[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (9))){
var inst_83325 = (state_83392[(13)]);
var state_83392__$1 = state_83392;
var statearr_83413_83443 = state_83392__$1;
(statearr_83413_83443[(2)] = inst_83325);

(statearr_83413_83443[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (5))){
var _ = (function (){var statearr_83414 = state_83392;
(statearr_83414[(4)] = cljs.core.rest((state_83392[(4)])));

return statearr_83414;
})();
var state_83392__$1 = state_83392;
var ex83410 = (state_83392__$1[(2)]);
var statearr_83415_83444 = state_83392__$1;
(statearr_83415_83444[(5)] = ex83410);


if((ex83410 instanceof Error)){
var statearr_83416_83445 = state_83392__$1;
(statearr_83416_83445[(1)] = (4));

(statearr_83416_83445[(5)] = null);

} else {
throw ex83410;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (14))){
var state_83392__$1 = state_83392;
var statearr_83417_83446 = state_83392__$1;
(statearr_83417_83446[(2)] = null);

(statearr_83417_83446[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (16))){
var inst_83341 = (state_83392[(7)]);
var inst_83325 = (state_83392[(13)]);
var inst_83353 = (state_83392[(9)]);
var inst_83314 = (state_83392[(10)]);
var inst_83355 = (state_83392[(8)]);
var inst_83337 = (state_83392[(14)]);
var inst_83360 = (state_83392[(2)]);
var inst_83361 = fluree.db.util.async.throw_err(inst_83360);
var inst_83362 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83341,"_fn/spec");
var inst_83363 = cljs.core.PersistentVector.EMPTY;
var inst_83364 = cljs.core.cst$sym$_QMARK_ctx;
var inst_83365 = (function (){var forward_time_travel_db_QMARK_ = inst_83314;
var or__4212__auto__ = inst_83325;
var query = inst_83337;
var res = inst_83341;
var _ = inst_83353;
var params = inst_83355;
var code = inst_83361;
var spec = inst_83362;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_83366 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_83365,inst_83355);
var inst_83367 = cljs.core.cons(inst_83364,inst_83366);
var inst_83368 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_83363,inst_83367);
var inst_83369 = fluree.db.dbfunctions.core.build_fn(inst_83368,inst_83361);
var inst_83370 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_83371 = cljs.core.count(inst_83355);
var inst_83372 = [inst_83371];
var inst_83373 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_83372);
var inst_83374 = [inst_83369,inst_83355,inst_83373,false,inst_83362,null];
var inst_83375 = cljs.core.PersistentHashMap.fromArrays(inst_83370,inst_83374);
var state_83392__$1 = (function (){var statearr_83418 = state_83392;
(statearr_83418[(11)] = inst_83375);

return statearr_83418;
})();
if(cljs.core.truth_(inst_83314)){
var statearr_83419_83447 = state_83392__$1;
(statearr_83419_83447[(1)] = (17));

} else {
var statearr_83420_83448 = state_83392__$1;
(statearr_83420_83448[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (10))){
var inst_83337 = (state_83392[(14)]);
var inst_83328 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_83329 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83330 = ["_fn/params","_fn/code","_fn/spec"];
var inst_83331 = (new cljs.core.PersistentVector(null,3,(5),inst_83329,inst_83330,null));
var inst_83332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83333 = cljs.core.name(fn_name);
var inst_83334 = ["_fn/name",inst_83333];
var inst_83335 = (new cljs.core.PersistentVector(null,2,(5),inst_83332,inst_83334,null));
var inst_83336 = [inst_83331,inst_83335];
var inst_83337__$1 = cljs.core.PersistentHashMap.fromArrays(inst_83328,inst_83336);
var inst_83338 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_83337__$1);
var state_83392__$1 = (function (){var statearr_83421 = state_83392;
(statearr_83421[(14)] = inst_83337__$1);

return statearr_83421;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83392__$1,(12),inst_83338);
} else {
if((state_val_83393 === (18))){
var inst_83375 = (state_83392[(11)]);
var inst_83378 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83379 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_83380 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_83381 = [fn_name,inst_83379,inst_83380];
var inst_83382 = (new cljs.core.PersistentVector(null,3,(5),inst_83378,inst_83381,null));
var inst_83383 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_83382,inst_83375);
var state_83392__$1 = state_83392;
var statearr_83422_83449 = state_83392__$1;
(statearr_83422_83449[(2)] = inst_83383);

(statearr_83422_83449[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83393 === (8))){
var inst_83325 = (state_83392[(13)]);
var inst_83325__$1 = (state_83392[(2)]);
var state_83392__$1 = (function (){var statearr_83423 = state_83392;
(statearr_83423[(13)] = inst_83325__$1);

return statearr_83423;
})();
if(cljs.core.truth_(inst_83325__$1)){
var statearr_83424_83450 = state_83392__$1;
(statearr_83424_83450[(1)] = (9));

} else {
var statearr_83425_83451 = state_83392__$1;
(statearr_83425_83451[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____0 = (function (){
var statearr_83426 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83426[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__);

(statearr_83426[(1)] = (1));

return statearr_83426;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____1 = (function (state_83392){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83392);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83427){var ex__24301__auto__ = e83427;
var statearr_83428_83452 = state_83392;
(statearr_83428_83452[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83392[(4)]))){
var statearr_83429_83453 = state_83392;
(statearr_83429_83453[(1)] = cljs.core.first((state_83392[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83454 = state_83392;
state_83392 = G__83454;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__ = function(state_83392){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____1.call(this,state_83392);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83430 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83430[(6)] = c__24424__auto__);

return statearr_83430;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__83456 = arguments.length;
switch (G__83456) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__83460 = arguments.length;
switch (G__83460) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83590){
var state_val_83591 = (state_83590[(1)]);
if((state_val_83591 === (7))){
var inst_83585 = (state_83590[(2)]);
var _ = (function (){var statearr_83592 = state_83590;
(statearr_83592[(4)] = cljs.core.rest((state_83590[(4)])));

return statearr_83592;
})();
var state_83590__$1 = state_83590;
var statearr_83593_83673 = state_83590__$1;
(statearr_83593_83673[(2)] = inst_83585);

(statearr_83593_83673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (20))){
var inst_83499 = (state_83590[(7)]);
var state_83590__$1 = state_83590;
var statearr_83594_83674 = state_83590__$1;
(statearr_83594_83674[(2)] = inst_83499);

(statearr_83594_83674[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (27))){
var inst_83486 = (state_83590[(8)]);
var inst_83512 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_83513 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83486)," used in function.",inst_83512].join('');
var inst_83514 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_83515 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_83516 = cljs.core.PersistentHashMap.fromArrays(inst_83514,inst_83515);
var inst_83517 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83513,inst_83516);
var inst_83518 = (function(){throw inst_83517})();
var state_83590__$1 = state_83590;
var statearr_83595_83675 = state_83590__$1;
(statearr_83595_83675[(2)] = inst_83518);

(statearr_83595_83675[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (1))){
var state_83590__$1 = state_83590;
var statearr_83596_83676 = state_83590__$1;
(statearr_83596_83676[(2)] = null);

(statearr_83596_83676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (24))){
var inst_83509 = (state_83590[(9)]);
var inst_83509__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_83590__$1 = (function (){var statearr_83597 = state_83590;
(statearr_83597[(9)] = inst_83509__$1);

return statearr_83597;
})();
if(inst_83509__$1){
var statearr_83598_83677 = state_83590__$1;
(statearr_83598_83677[(1)] = (26));

} else {
var statearr_83599_83678 = state_83590__$1;
(statearr_83599_83678[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (39))){
var inst_83486 = (state_83590[(8)]);
var inst_83546 = (inst_83486 == null);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83546)){
var statearr_83600_83679 = state_83590__$1;
(statearr_83600_83679[(1)] = (42));

} else {
var statearr_83601_83680 = state_83590__$1;
(statearr_83601_83680[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (46))){
var state_83590__$1 = state_83590;
var statearr_83602_83681 = state_83590__$1;
(statearr_83602_83681[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (4))){
var inst_83461 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83604_83682 = state_83590__$1;
(statearr_83604_83682[(2)] = inst_83461);

(statearr_83604_83682[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (15))){
var inst_83486 = (state_83590[(8)]);
var inst_83497 = (inst_83486 instanceof cljs.core.Symbol);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83497)){
var statearr_83605_83683 = state_83590__$1;
(statearr_83605_83683[(1)] = (17));

} else {
var statearr_83606_83684 = state_83590__$1;
(statearr_83606_83684[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (48))){
var inst_83553 = (state_83590[(2)]);
var inst_83554 = fluree.db.util.async.throw_err(inst_83553);
var state_83590__$1 = state_83590;
var statearr_83607_83685 = state_83590__$1;
(statearr_83607_83685[(2)] = inst_83554);

(statearr_83607_83685[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (50))){
var state_83590__$1 = state_83590;
var statearr_83608_83686 = state_83590__$1;
(statearr_83608_83686[(2)] = null);

(statearr_83608_83686[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (21))){
var inst_83474 = (state_83590[(10)]);
var inst_83479 = (state_83590[(11)]);
var inst_83506 = (state_83590[(12)]);
var inst_83476 = (state_83590[(13)]);
var inst_83477 = (state_83590[(14)]);
var inst_83499 = (state_83590[(7)]);
var inst_83480 = (state_83590[(15)]);
var inst_83487 = (state_83590[(16)]);
var inst_83486 = (state_83590[(8)]);
var inst_83502 = [inst_83486];
var inst_83503 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_83502);
var inst_83504 = (function (){var x = inst_83486;
var first__83473 = inst_83476;
var first__83484 = inst_83486;
var r = inst_83487;
var seq__83472 = inst_83477;
var seq__83483 = inst_83487;
var or__4212__auto__ = inst_83499;
var acc = inst_83480;
var vec__83471 = inst_83474;
var vec__83482 = inst_83479;
var G__83470 = inst_83479;
return (function (p1__83458_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__83458_SHARP_);
});
})();
var inst_83505 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_83504,params);
var inst_83506__$1 = cljs.core.some(inst_83503,inst_83505);
var state_83590__$1 = (function (){var statearr_83609 = state_83590;
(statearr_83609[(12)] = inst_83506__$1);

return statearr_83609;
})();
if(cljs.core.truth_(inst_83506__$1)){
var statearr_83610_83687 = state_83590__$1;
(statearr_83610_83687[(1)] = (23));

} else {
var statearr_83611_83688 = state_83590__$1;
(statearr_83611_83688[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (31))){
var inst_83536 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83536)){
var statearr_83612_83689 = state_83590__$1;
(statearr_83612_83689[(1)] = (35));

} else {
var statearr_83613_83690 = state_83590__$1;
(statearr_83613_83690[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (32))){
var inst_83529 = (state_83590[(17)]);
var state_83590__$1 = state_83590;
var statearr_83614_83691 = state_83590__$1;
(statearr_83614_83691[(2)] = inst_83529);

(statearr_83614_83691[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (40))){
var inst_83571 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83615_83692 = state_83590__$1;
(statearr_83615_83692[(2)] = inst_83571);

(statearr_83615_83692[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (33))){
var inst_83486 = (state_83590[(8)]);
var inst_83532 = (inst_83486 == null);
var state_83590__$1 = state_83590;
var statearr_83616_83693 = state_83590__$1;
(statearr_83616_83693[(2)] = inst_83532);

(statearr_83616_83693[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (13))){
var inst_83480 = (state_83590[(15)]);
var inst_83487 = (state_83590[(16)]);
var inst_83579 = (state_83590[(2)]);
var inst_83580 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_83480,inst_83579);
var inst_83479 = inst_83487;
var inst_83480__$1 = inst_83580;
var state_83590__$1 = (function (){var statearr_83617 = state_83590;
(statearr_83617[(11)] = inst_83479);

(statearr_83617[(15)] = inst_83480__$1);

return statearr_83617;
})();
var statearr_83618_83694 = state_83590__$1;
(statearr_83618_83694[(2)] = null);

(statearr_83618_83694[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (22))){
var inst_83524 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83619_83695 = state_83590__$1;
(statearr_83619_83695[(2)] = inst_83524);

(statearr_83619_83695[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (36))){
var inst_83486 = (state_83590[(8)]);
var inst_83539 = cljs.core.vector_QMARK_(inst_83486);
var state_83590__$1 = state_83590;
if(inst_83539){
var statearr_83620_83696 = state_83590__$1;
(statearr_83620_83696[(1)] = (38));

} else {
var statearr_83621_83697 = state_83590__$1;
(statearr_83621_83697[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (41))){
var inst_83543 = (state_83590[(2)]);
var inst_83544 = fluree.db.util.async.throw_err(inst_83543);
var state_83590__$1 = state_83590;
var statearr_83622_83698 = state_83590__$1;
(statearr_83622_83698[(2)] = inst_83544);

(statearr_83622_83698[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (43))){
var inst_83486 = (state_83590[(8)]);
var inst_83549 = cljs.core.list_QMARK_(inst_83486);
var state_83590__$1 = state_83590;
if(inst_83549){
var statearr_83623_83699 = state_83590__$1;
(statearr_83623_83699[(1)] = (45));

} else {
var statearr_83624_83700 = state_83590__$1;
(statearr_83624_83700[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (29))){
var inst_83526 = (state_83590[(18)]);
var state_83590__$1 = state_83590;
var statearr_83625_83701 = state_83590__$1;
(statearr_83625_83701[(2)] = inst_83526);

(statearr_83625_83701[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (44))){
var inst_83569 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83626_83702 = state_83590__$1;
(statearr_83626_83702[(2)] = inst_83569);

(statearr_83626_83702[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (6))){
var inst_83479 = (state_83590[(11)]);
var inst_83486 = (state_83590[(8)]);
var inst_83485 = cljs.core.seq(inst_83479);
var inst_83486__$1 = cljs.core.first(inst_83485);
var inst_83487 = cljs.core.next(inst_83485);
var inst_83488 = (inst_83486__$1 == null);
var state_83590__$1 = (function (){var statearr_83627 = state_83590;
(statearr_83627[(16)] = inst_83487);

(statearr_83627[(8)] = inst_83486__$1);

return statearr_83627;
})();
if(cljs.core.truth_(inst_83488)){
var statearr_83628_83703 = state_83590__$1;
(statearr_83628_83703[(1)] = (8));

} else {
var statearr_83629_83704 = state_83590__$1;
(statearr_83629_83704[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (28))){
var inst_83520 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83630_83705 = state_83590__$1;
(statearr_83630_83705[(2)] = inst_83520);

(statearr_83630_83705[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (51))){
var inst_83565 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83631_83706 = state_83590__$1;
(statearr_83631_83706[(2)] = inst_83565);

(statearr_83631_83706[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (25))){
var inst_83522 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83632_83707 = state_83590__$1;
(statearr_83632_83707[(2)] = inst_83522);

(statearr_83632_83707[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (34))){
var inst_83534 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83633_83708 = state_83590__$1;
(statearr_83633_83708[(2)] = inst_83534);

(statearr_83633_83708[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (17))){
var inst_83499 = (state_83590[(7)]);
var inst_83486 = (state_83590[(8)]);
var inst_83499__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_83486) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_83486));
var state_83590__$1 = (function (){var statearr_83634 = state_83590;
(statearr_83634[(7)] = inst_83499__$1);

return statearr_83634;
})();
if(cljs.core.truth_(inst_83499__$1)){
var statearr_83635_83709 = state_83590__$1;
(statearr_83635_83709[(1)] = (20));

} else {
var statearr_83636_83710 = state_83590__$1;
(statearr_83636_83710[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (3))){
var inst_83588 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83590__$1,inst_83588);
} else {
if((state_val_83591 === (12))){
var inst_83486 = (state_83590[(8)]);
var inst_83494 = typeof inst_83486 === 'number';
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83494)){
var statearr_83637_83711 = state_83590__$1;
(statearr_83637_83711[(1)] = (14));

} else {
var statearr_83638_83712 = state_83590__$1;
(statearr_83638_83712[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (2))){
var inst_83474 = (state_83590[(10)]);
var _ = (function (){var statearr_83639 = state_83590;
(statearr_83639[(4)] = cljs.core.cons((5),(state_83590[(4)])));

return statearr_83639;
})();
var inst_83474__$1 = vec;
var inst_83475 = cljs.core.seq(inst_83474__$1);
var inst_83476 = cljs.core.first(inst_83475);
var inst_83477 = cljs.core.next(inst_83475);
var inst_83478 = cljs.core.PersistentVector.EMPTY;
var inst_83479 = inst_83474__$1;
var inst_83480 = inst_83478;
var state_83590__$1 = (function (){var statearr_83640 = state_83590;
(statearr_83640[(10)] = inst_83474__$1);

(statearr_83640[(11)] = inst_83479);

(statearr_83640[(13)] = inst_83476);

(statearr_83640[(14)] = inst_83477);

(statearr_83640[(15)] = inst_83480);

return statearr_83640;
})();
var statearr_83641_83713 = state_83590__$1;
(statearr_83641_83713[(2)] = null);

(statearr_83641_83713[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (23))){
var inst_83506 = (state_83590[(12)]);
var state_83590__$1 = state_83590;
var statearr_83642_83714 = state_83590__$1;
(statearr_83642_83714[(2)] = inst_83506);

(statearr_83642_83714[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (47))){
var inst_83567 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83643_83715 = state_83590__$1;
(statearr_83643_83715[(2)] = inst_83567);

(statearr_83643_83715[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (35))){
var inst_83486 = (state_83590[(8)]);
var state_83590__$1 = state_83590;
var statearr_83644_83716 = state_83590__$1;
(statearr_83644_83716[(2)] = inst_83486);

(statearr_83644_83716[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (19))){
var inst_83575 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83645_83717 = state_83590__$1;
(statearr_83645_83717[(2)] = inst_83575);

(statearr_83645_83717[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (11))){
var inst_83486 = (state_83590[(8)]);
var state_83590__$1 = state_83590;
var statearr_83647_83718 = state_83590__$1;
(statearr_83647_83718[(2)] = inst_83486);

(statearr_83647_83718[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (9))){
var inst_83486 = (state_83590[(8)]);
var inst_83491 = typeof inst_83486 === 'string';
var state_83590__$1 = state_83590;
if(cljs.core.truth_(inst_83491)){
var statearr_83648_83719 = state_83590__$1;
(statearr_83648_83719[(1)] = (11));

} else {
var statearr_83649_83720 = state_83590__$1;
(statearr_83649_83720[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (5))){
var _ = (function (){var statearr_83650 = state_83590;
(statearr_83650[(4)] = cljs.core.rest((state_83590[(4)])));

return statearr_83650;
})();
var state_83590__$1 = state_83590;
var ex83646 = (state_83590__$1[(2)]);
var statearr_83651_83721 = state_83590__$1;
(statearr_83651_83721[(5)] = ex83646);


if((ex83646 instanceof Error)){
var statearr_83652_83722 = state_83590__$1;
(statearr_83652_83722[(1)] = (4));

(statearr_83652_83722[(5)] = null);

} else {
throw ex83646;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (14))){
var inst_83486 = (state_83590[(8)]);
var state_83590__$1 = state_83590;
var statearr_83653_83723 = state_83590__$1;
(statearr_83653_83723[(2)] = inst_83486);

(statearr_83653_83723[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (45))){
var inst_83486 = (state_83590[(8)]);
var inst_83551 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_83486,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_83486,funType,params));
var state_83590__$1 = state_83590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83590__$1,(48),inst_83551);
} else {
if((state_val_83591 === (26))){
var inst_83509 = (state_83590[(9)]);
var state_83590__$1 = state_83590;
var statearr_83654_83724 = state_83590__$1;
(statearr_83654_83724[(2)] = inst_83509);

(statearr_83654_83724[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (16))){
var inst_83577 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83655_83725 = state_83590__$1;
(statearr_83655_83725[(2)] = inst_83577);

(statearr_83655_83725[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (38))){
var inst_83486 = (state_83590[(8)]);
var inst_83541 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_83486,funType,params);
var state_83590__$1 = state_83590;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83590__$1,(41),inst_83541);
} else {
if((state_val_83591 === (30))){
var inst_83529 = (state_83590[(17)]);
var inst_83486 = (state_83590[(8)]);
var inst_83529__$1 = inst_83486 === false;
var state_83590__$1 = (function (){var statearr_83656 = state_83590;
(statearr_83656[(17)] = inst_83529__$1);

return statearr_83656;
})();
if(cljs.core.truth_(inst_83529__$1)){
var statearr_83657_83726 = state_83590__$1;
(statearr_83657_83726[(1)] = (32));

} else {
var statearr_83658_83727 = state_83590__$1;
(statearr_83658_83727[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (10))){
var inst_83583 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83659_83728 = state_83590__$1;
(statearr_83659_83728[(2)] = inst_83583);

(statearr_83659_83728[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (18))){
var inst_83526 = (state_83590[(18)]);
var inst_83486 = (state_83590[(8)]);
var inst_83526__$1 = inst_83486 === true;
var state_83590__$1 = (function (){var statearr_83660 = state_83590;
(statearr_83660[(18)] = inst_83526__$1);

return statearr_83660;
})();
if(cljs.core.truth_(inst_83526__$1)){
var statearr_83661_83729 = state_83590__$1;
(statearr_83661_83729[(1)] = (29));

} else {
var statearr_83662_83730 = state_83590__$1;
(statearr_83662_83730[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (42))){
var inst_83486 = (state_83590[(8)]);
var state_83590__$1 = state_83590;
var statearr_83663_83731 = state_83590__$1;
(statearr_83663_83731[(2)] = inst_83486);

(statearr_83663_83731[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (37))){
var inst_83573 = (state_83590[(2)]);
var state_83590__$1 = state_83590;
var statearr_83664_83732 = state_83590__$1;
(statearr_83664_83732[(2)] = inst_83573);

(statearr_83664_83732[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (8))){
var inst_83480 = (state_83590[(15)]);
var state_83590__$1 = state_83590;
var statearr_83665_83733 = state_83590__$1;
(statearr_83665_83733[(2)] = inst_83480);

(statearr_83665_83733[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83591 === (49))){
var inst_83486 = (state_83590[(8)]);
var inst_83557 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83486], 0));
var inst_83558 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_83559 = ["Illegal element (",inst_83557,") in vector: ",inst_83558,"."].join('');
var inst_83560 = cljs.core.PersistentHashMap.EMPTY;
var inst_83561 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83559,inst_83560);
var inst_83562 = (function(){throw inst_83561})();
var state_83590__$1 = state_83590;
var statearr_83666_83734 = state_83590__$1;
(statearr_83666_83734[(2)] = inst_83562);

(statearr_83666_83734[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__24298__auto____0 = (function (){
var statearr_83667 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83667[(0)] = fluree$db$dbfunctions$core$state_machine__24298__auto__);

(statearr_83667[(1)] = (1));

return statearr_83667;
});
var fluree$db$dbfunctions$core$state_machine__24298__auto____1 = (function (state_83590){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83590);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83668){var ex__24301__auto__ = e83668;
var statearr_83669_83735 = state_83590;
(statearr_83669_83735[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83590[(4)]))){
var statearr_83670_83736 = state_83590;
(statearr_83670_83736[(1)] = cljs.core.first((state_83590[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83737 = state_83590;
state_83590 = G__83737;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__24298__auto__ = function(state_83590){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__24298__auto____1.call(this,state_83590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__24298__auto____0;
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__24298__auto____1;
return fluree$db$dbfunctions$core$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83671 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83671[(6)] = c__24424__auto__);

return statearr_83671;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__83740 = arguments.length;
switch (G__83740) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83904){
var state_val_83905 = (state_83904[(1)]);
if((state_val_83905 === (7))){
var inst_83748 = (state_83904[(7)]);
var inst_83754 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_83748,type);
var state_83904__$1 = state_83904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83904__$1,(9),inst_83754);
} else {
if((state_val_83905 === (59))){
var inst_83797 = (state_83904[(8)]);
var inst_83868 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_83797], 0));
var inst_83869 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_83797) : type.call(null,inst_83797));
var inst_83870 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_83871 = ["Illegal element (",inst_83868,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83869),") in function argument: ",inst_83870,"."].join('');
var inst_83872 = cljs.core.PersistentHashMap.EMPTY;
var inst_83873 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83871,inst_83872);
var inst_83874 = (function(){throw inst_83873})();
var state_83904__$1 = state_83904;
var statearr_83906_84001 = state_83904__$1;
(statearr_83906_84001[(2)] = inst_83874);

(statearr_83906_84001[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (20))){
var inst_83803 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
if(cljs.core.truth_(inst_83803)){
var statearr_83907_84002 = state_83904__$1;
(statearr_83907_84002[(1)] = (21));

} else {
var statearr_83908_84003 = state_83904__$1;
(statearr_83908_84003[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (58))){
var inst_83864 = (state_83904[(2)]);
var inst_83865 = fluree.db.util.async.throw_err(inst_83864);
var state_83904__$1 = state_83904;
var statearr_83909_84004 = state_83904__$1;
(statearr_83909_84004[(2)] = inst_83865);

(statearr_83909_84004[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (60))){
var state_83904__$1 = state_83904;
var statearr_83910_84005 = state_83904__$1;
(statearr_83910_84005[(2)] = null);

(statearr_83910_84005[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (27))){
var inst_83809 = (state_83904[(2)]);
var inst_83810 = fluree.db.util.async.throw_err(inst_83809);
var state_83904__$1 = state_83904;
var statearr_83911_84006 = state_83904__$1;
(statearr_83911_84006[(2)] = inst_83810);

(statearr_83911_84006[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (1))){
var state_83904__$1 = state_83904;
var statearr_83912_84007 = state_83904__$1;
(statearr_83912_84007[(2)] = null);

(statearr_83912_84007[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (24))){
var inst_83797 = (state_83904[(8)]);
var inst_83807 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_83797,type,params);
var state_83904__$1 = state_83904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83904__$1,(27),inst_83807);
} else {
if((state_val_83905 === (55))){
var inst_83797 = (state_83904[(8)]);
var inst_83862 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_83797,type,params);
var state_83904__$1 = state_83904;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83904__$1,(58),inst_83862);
} else {
if((state_val_83905 === (39))){
var inst_83845 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83913_84008 = state_83904__$1;
(statearr_83913_84008[(2)] = inst_83845);

(statearr_83913_84008[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (46))){
var inst_83847 = (state_83904[(9)]);
var state_83904__$1 = state_83904;
var statearr_83914_84009 = state_83904__$1;
(statearr_83914_84009[(2)] = inst_83847);

(statearr_83914_84009[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (4))){
var inst_83741 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83915_84010 = state_83904__$1;
(statearr_83915_84010[(2)] = inst_83741);

(statearr_83915_84010[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (54))){
var inst_83881 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83916_84011 = state_83904__$1;
(statearr_83916_84011[(2)] = inst_83881);

(statearr_83916_84011[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (15))){
var inst_83749 = (state_83904[(10)]);
var inst_83778 = (state_83904[(2)]);
var inst_83786 = cljs.core.seq(inst_83749);
var inst_83787 = cljs.core.first(inst_83786);
var inst_83788 = cljs.core.next(inst_83786);
var inst_83789 = cljs.core.PersistentVector.EMPTY;
var inst_83790 = inst_83749;
var inst_83791 = inst_83789;
var state_83904__$1 = (function (){var statearr_83917 = state_83904;
(statearr_83917[(11)] = inst_83787);

(statearr_83917[(12)] = inst_83790);

(statearr_83917[(13)] = inst_83778);

(statearr_83917[(14)] = inst_83788);

(statearr_83917[(15)] = inst_83791);

return statearr_83917;
})();
var statearr_83918_84012 = state_83904__$1;
(statearr_83918_84012[(2)] = null);

(statearr_83918_84012[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (48))){
var inst_83857 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
if(cljs.core.truth_(inst_83857)){
var statearr_83919_84013 = state_83904__$1;
(statearr_83919_84013[(1)] = (52));

} else {
var statearr_83920_84014 = state_83904__$1;
(statearr_83920_84014[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (50))){
var inst_83797 = (state_83904[(8)]);
var inst_83853 = (inst_83797 == null);
var state_83904__$1 = state_83904;
var statearr_83921_84015 = state_83904__$1;
(statearr_83921_84015[(2)] = inst_83853);

(statearr_83921_84015[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (21))){
var inst_83797 = (state_83904[(8)]);
var inst_83805 = cljs.core.list_QMARK_(inst_83797);
var state_83904__$1 = state_83904;
if(inst_83805){
var statearr_83922_84016 = state_83904__$1;
(statearr_83922_84016[(1)] = (24));

} else {
var statearr_83923_84017 = state_83904__$1;
(statearr_83923_84017[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (31))){
var inst_83797 = (state_83904[(8)]);
var state_83904__$1 = state_83904;
var statearr_83924_84018 = state_83904__$1;
(statearr_83924_84018[(2)] = inst_83797);

(statearr_83924_84018[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (32))){
var inst_83797 = (state_83904[(8)]);
var inst_83818 = (inst_83797 instanceof cljs.core.Symbol);
var state_83904__$1 = state_83904;
if(cljs.core.truth_(inst_83818)){
var statearr_83925_84019 = state_83904__$1;
(statearr_83925_84019[(1)] = (34));

} else {
var statearr_83926_84020 = state_83904__$1;
(statearr_83926_84020[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (40))){
var inst_83827 = (state_83904[(16)]);
var state_83904__$1 = state_83904;
var statearr_83927_84021 = state_83904__$1;
(statearr_83927_84021[(2)] = inst_83827);

(statearr_83927_84021[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (56))){
var state_83904__$1 = state_83904;
var statearr_83928_84022 = state_83904__$1;
(statearr_83928_84022[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (33))){
var inst_83885 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83930_84023 = state_83904__$1;
(statearr_83930_84023[(2)] = inst_83885);

(statearr_83930_84023[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (13))){
var inst_83748 = (state_83904[(7)]);
var inst_83762 = (state_83904[(17)]);
var inst_83750 = (state_83904[(18)]);
var inst_83772 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83748),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83762),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83750),"."].join('');
var inst_83773 = cljs.core.PersistentHashMap.EMPTY;
var inst_83774 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83772,inst_83773);
var inst_83775 = (function(){throw inst_83774})();
var state_83904__$1 = state_83904;
var statearr_83931_84024 = state_83904__$1;
(statearr_83931_84024[(2)] = inst_83775);

(statearr_83931_84024[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (22))){
var inst_83791 = (state_83904[(15)]);
var state_83904__$1 = state_83904;
var statearr_83932_84025 = state_83904__$1;
(statearr_83932_84025[(2)] = inst_83791);

(statearr_83932_84025[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (36))){
var inst_83883 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83933_84026 = state_83904__$1;
(statearr_83933_84026[(2)] = inst_83883);

(statearr_83933_84026[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (41))){
var inst_83830 = (state_83904[(19)]);
var inst_83830__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_83904__$1 = (function (){var statearr_83934 = state_83904;
(statearr_83934[(19)] = inst_83830__$1);

return statearr_83934;
})();
if(inst_83830__$1){
var statearr_83935_84027 = state_83904__$1;
(statearr_83935_84027[(1)] = (43));

} else {
var statearr_83936_84028 = state_83904__$1;
(statearr_83936_84028[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (43))){
var inst_83830 = (state_83904[(19)]);
var state_83904__$1 = state_83904;
var statearr_83937_84029 = state_83904__$1;
(statearr_83937_84029[(2)] = inst_83830);

(statearr_83937_84029[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (61))){
var inst_83877 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83938_84030 = state_83904__$1;
(statearr_83938_84030[(2)] = inst_83877);

(statearr_83938_84030[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (29))){
var inst_83797 = (state_83904[(8)]);
var inst_83815 = typeof inst_83797 === 'number';
var state_83904__$1 = state_83904;
if(cljs.core.truth_(inst_83815)){
var statearr_83939_84031 = state_83904__$1;
(statearr_83939_84031[(1)] = (31));

} else {
var statearr_83940_84032 = state_83904__$1;
(statearr_83940_84032[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (44))){
var inst_83797 = (state_83904[(8)]);
var inst_83833 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_83834 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83797)," used in function argument: ",inst_83833].join('');
var inst_83835 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_83836 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_83837 = cljs.core.PersistentHashMap.fromArrays(inst_83835,inst_83836);
var inst_83838 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_83834,inst_83837);
var inst_83839 = (function(){throw inst_83838})();
var state_83904__$1 = state_83904;
var statearr_83941_84033 = state_83904__$1;
(statearr_83941_84033[(2)] = inst_83839);

(statearr_83941_84033[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (6))){
var inst_83751 = (state_83904[(20)]);
var state_83904__$1 = state_83904;
var statearr_83942_84034 = state_83904__$1;
(statearr_83942_84034[(2)] = inst_83751);

(statearr_83942_84034[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (28))){
var inst_83797 = (state_83904[(8)]);
var state_83904__$1 = state_83904;
var statearr_83943_84035 = state_83904__$1;
(statearr_83943_84035[(2)] = inst_83797);

(statearr_83943_84035[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (51))){
var inst_83855 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83944_84036 = state_83904__$1;
(statearr_83944_84036[(2)] = inst_83855);

(statearr_83944_84036[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (25))){
var inst_83797 = (state_83904[(8)]);
var inst_83812 = typeof inst_83797 === 'string';
var state_83904__$1 = state_83904;
if(cljs.core.truth_(inst_83812)){
var statearr_83945_84037 = state_83904__$1;
(statearr_83945_84037[(1)] = (28));

} else {
var statearr_83946_84038 = state_83904__$1;
(statearr_83946_84038[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (34))){
var inst_83820 = (state_83904[(21)]);
var inst_83797 = (state_83904[(8)]);
var inst_83820__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_83797) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_83797));
var state_83904__$1 = (function (){var statearr_83947 = state_83904;
(statearr_83947[(21)] = inst_83820__$1);

return statearr_83947;
})();
if(cljs.core.truth_(inst_83820__$1)){
var statearr_83948_84039 = state_83904__$1;
(statearr_83948_84039[(1)] = (37));

} else {
var statearr_83949_84040 = state_83904__$1;
(statearr_83949_84040[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (17))){
var inst_83761 = (state_83904[(22)]);
var inst_83896 = (state_83904[(2)]);
var inst_83897 = cljs.core.cst$sym$_QMARK_ctx;
var inst_83898 = cljs.core.cons(inst_83897,inst_83896);
var inst_83899 = cljs.core.cons(inst_83761,inst_83898);
var _ = (function (){var statearr_83950 = state_83904;
(statearr_83950[(4)] = cljs.core.rest((state_83904[(4)])));

return statearr_83950;
})();
var state_83904__$1 = state_83904;
var statearr_83951_84041 = state_83904__$1;
(statearr_83951_84041[(2)] = inst_83899);

(statearr_83951_84041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (3))){
var inst_83902 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83904__$1,inst_83902);
} else {
if((state_val_83905 === (12))){
var inst_83769 = (state_83904[(2)]);
var inst_83770 = cljs.core.not(inst_83769);
var state_83904__$1 = state_83904;
if(inst_83770){
var statearr_83952_84042 = state_83904__$1;
(statearr_83952_84042[(1)] = (13));

} else {
var statearr_83953_84043 = state_83904__$1;
(statearr_83953_84043[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (2))){
var inst_83748 = (state_83904[(7)]);
var inst_83749 = (state_83904[(10)]);
var inst_83751 = (state_83904[(20)]);
var _ = (function (){var statearr_83954 = state_83904;
(statearr_83954[(4)] = cljs.core.cons((5),(state_83904[(4)])));

return statearr_83954;
})();
var inst_83748__$1 = cljs.core.first(form);
var inst_83749__$1 = cljs.core.rest(form);
var inst_83750 = cljs.core.count(inst_83749__$1);
var inst_83751__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_83748__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_83748__$1));
var state_83904__$1 = (function (){var statearr_83955 = state_83904;
(statearr_83955[(7)] = inst_83748__$1);

(statearr_83955[(18)] = inst_83750);

(statearr_83955[(10)] = inst_83749__$1);

(statearr_83955[(20)] = inst_83751__$1);

return statearr_83955;
})();
if(cljs.core.truth_(inst_83751__$1)){
var statearr_83956_84044 = state_83904__$1;
(statearr_83956_84044[(1)] = (6));

} else {
var statearr_83957_84045 = state_83904__$1;
(statearr_83957_84045[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (23))){
var inst_83894 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83958_84046 = state_83904__$1;
(statearr_83958_84046[(2)] = inst_83894);

(statearr_83958_84046[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (47))){
var inst_83850 = (state_83904[(23)]);
var inst_83797 = (state_83904[(8)]);
var inst_83850__$1 = inst_83797 === false;
var state_83904__$1 = (function (){var statearr_83959 = state_83904;
(statearr_83959[(23)] = inst_83850__$1);

return statearr_83959;
})();
if(cljs.core.truth_(inst_83850__$1)){
var statearr_83960_84047 = state_83904__$1;
(statearr_83960_84047[(1)] = (49));

} else {
var statearr_83961_84048 = state_83904__$1;
(statearr_83961_84048[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (35))){
var inst_83847 = (state_83904[(9)]);
var inst_83797 = (state_83904[(8)]);
var inst_83847__$1 = inst_83797 === true;
var state_83904__$1 = (function (){var statearr_83962 = state_83904;
(statearr_83962[(9)] = inst_83847__$1);

return statearr_83962;
})();
if(cljs.core.truth_(inst_83847__$1)){
var statearr_83963_84049 = state_83904__$1;
(statearr_83963_84049[(1)] = (46));

} else {
var statearr_83964_84050 = state_83904__$1;
(statearr_83964_84050[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (19))){
var inst_83797 = (state_83904[(8)]);
var inst_83801 = inst_83797 === false;
var state_83904__$1 = state_83904;
var statearr_83965_84051 = state_83904__$1;
(statearr_83965_84051[(2)] = inst_83801);

(statearr_83965_84051[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (57))){
var inst_83879 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83966_84052 = state_83904__$1;
(statearr_83966_84052[(2)] = inst_83879);

(statearr_83966_84052[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (11))){
var inst_83762 = (state_83904[(17)]);
var inst_83750 = (state_83904[(18)]);
var inst_83767 = (inst_83762.cljs$core$IFn$_invoke$arity$1 ? inst_83762.cljs$core$IFn$_invoke$arity$1(inst_83750) : inst_83762.call(null,inst_83750));
var state_83904__$1 = state_83904;
var statearr_83968_84053 = state_83904__$1;
(statearr_83968_84053[(2)] = inst_83767);

(statearr_83968_84053[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (9))){
var inst_83756 = (state_83904[(2)]);
var inst_83757 = fluree.db.util.async.throw_err(inst_83756);
var state_83904__$1 = state_83904;
var statearr_83969_84054 = state_83904__$1;
(statearr_83969_84054[(2)] = inst_83757);

(statearr_83969_84054[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (5))){
var _ = (function (){var statearr_83970 = state_83904;
(statearr_83970[(4)] = cljs.core.rest((state_83904[(4)])));

return statearr_83970;
})();
var state_83904__$1 = state_83904;
var ex83967 = (state_83904__$1[(2)]);
var statearr_83971_84055 = state_83904__$1;
(statearr_83971_84055[(5)] = ex83967);


if((ex83967 instanceof Error)){
var statearr_83972_84056 = state_83904__$1;
(statearr_83972_84056[(1)] = (4));

(statearr_83972_84056[(5)] = null);

} else {
throw ex83967;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (14))){
var state_83904__$1 = state_83904;
var statearr_83973_84057 = state_83904__$1;
(statearr_83973_84057[(2)] = null);

(statearr_83973_84057[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (45))){
var inst_83841 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83974_84058 = state_83904__$1;
(statearr_83974_84058[(2)] = inst_83841);

(statearr_83974_84058[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (53))){
var inst_83797 = (state_83904[(8)]);
var inst_83860 = cljs.core.vector_QMARK_(inst_83797);
var state_83904__$1 = state_83904;
if(inst_83860){
var statearr_83975_84059 = state_83904__$1;
(statearr_83975_84059[(1)] = (55));

} else {
var statearr_83976_84060 = state_83904__$1;
(statearr_83976_84060[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (26))){
var inst_83791 = (state_83904[(15)]);
var inst_83798 = (state_83904[(24)]);
var inst_83889 = (state_83904[(2)]);
var inst_83890 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_83791,inst_83889);
var inst_83790 = inst_83798;
var inst_83791__$1 = inst_83890;
var state_83904__$1 = (function (){var statearr_83977 = state_83904;
(statearr_83977[(12)] = inst_83790);

(statearr_83977[(15)] = inst_83791__$1);

return statearr_83977;
})();
var statearr_83978_84061 = state_83904__$1;
(statearr_83978_84061[(2)] = null);

(statearr_83978_84061[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (16))){
var inst_83790 = (state_83904[(12)]);
var inst_83797 = (state_83904[(8)]);
var inst_83796 = cljs.core.seq(inst_83790);
var inst_83797__$1 = cljs.core.first(inst_83796);
var inst_83798 = cljs.core.next(inst_83796);
var state_83904__$1 = (function (){var statearr_83979 = state_83904;
(statearr_83979[(24)] = inst_83798);

(statearr_83979[(8)] = inst_83797__$1);

return statearr_83979;
})();
if(cljs.core.truth_(inst_83797__$1)){
var statearr_83980_84062 = state_83904__$1;
(statearr_83980_84062[(1)] = (18));

} else {
var statearr_83981_84063 = state_83904__$1;
(statearr_83981_84063[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (38))){
var inst_83748 = (state_83904[(7)]);
var inst_83764 = (state_83904[(25)]);
var inst_83762 = (state_83904[(17)]);
var inst_83787 = (state_83904[(11)]);
var inst_83820 = (state_83904[(21)]);
var inst_83827 = (state_83904[(16)]);
var inst_83750 = (state_83904[(18)]);
var inst_83790 = (state_83904[(12)]);
var inst_83763 = (state_83904[(26)]);
var inst_83778 = (state_83904[(13)]);
var inst_83760 = (state_83904[(27)]);
var inst_83788 = (state_83904[(14)]);
var inst_83791 = (state_83904[(15)]);
var inst_83749 = (state_83904[(10)]);
var inst_83798 = (state_83904[(24)]);
var inst_83759 = (state_83904[(28)]);
var inst_83797 = (state_83904[(8)]);
var inst_83761 = (state_83904[(22)]);
var inst_83823 = [inst_83797];
var inst_83824 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_83823);
var inst_83825 = (function (){var arity = inst_83762;
var args_n = inst_83750;
var fn_map = inst_83759;
var map__83747 = inst_83760;
var vec__83783 = inst_83749;
var first__83795 = inst_83797;
var vec__83793 = inst_83790;
var args = inst_83749;
var r = inst_83798;
var first__83785 = inst_83787;
var or__4212__auto__ = inst_83820;
var _ = inst_83778;
var seq__83784 = inst_83788;
var acc = inst_83791;
var seq__83794 = inst_83798;
var arglist = inst_83763;
var fn_name = inst_83748;
var _AMPERSAND_args_QMARK_ = inst_83764;
var G__83782 = inst_83790;
var arg = inst_83797;
var f = inst_83761;
return (function (p1__83738_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__83738_SHARP_);
});
})();
var inst_83826 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_83825,params);
var inst_83827__$1 = cljs.core.some(inst_83824,inst_83826);
var state_83904__$1 = (function (){var statearr_83982 = state_83904;
(statearr_83982[(16)] = inst_83827__$1);

return statearr_83982;
})();
if(cljs.core.truth_(inst_83827__$1)){
var statearr_83983_84064 = state_83904__$1;
(statearr_83983_84064[(1)] = (40));

} else {
var statearr_83984_84065 = state_83904__$1;
(statearr_83984_84065[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (30))){
var inst_83887 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83985_84066 = state_83904__$1;
(statearr_83985_84066[(2)] = inst_83887);

(statearr_83985_84066[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (10))){
var inst_83764 = (state_83904[(25)]);
var state_83904__$1 = state_83904;
var statearr_83986_84067 = state_83904__$1;
(statearr_83986_84067[(2)] = inst_83764);

(statearr_83986_84067[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (18))){
var inst_83797 = (state_83904[(8)]);
var state_83904__$1 = state_83904;
var statearr_83987_84068 = state_83904__$1;
(statearr_83987_84068[(2)] = inst_83797);

(statearr_83987_84068[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (52))){
var inst_83797 = (state_83904[(8)]);
var state_83904__$1 = state_83904;
var statearr_83988_84069 = state_83904__$1;
(statearr_83988_84069[(2)] = inst_83797);

(statearr_83988_84069[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (42))){
var inst_83843 = (state_83904[(2)]);
var state_83904__$1 = state_83904;
var statearr_83989_84070 = state_83904__$1;
(statearr_83989_84070[(2)] = inst_83843);

(statearr_83989_84070[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (37))){
var inst_83820 = (state_83904[(21)]);
var state_83904__$1 = state_83904;
var statearr_83990_84071 = state_83904__$1;
(statearr_83990_84071[(2)] = inst_83820);

(statearr_83990_84071[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (8))){
var inst_83764 = (state_83904[(25)]);
var inst_83760 = (state_83904[(27)]);
var inst_83759 = (state_83904[(28)]);
var inst_83759__$1 = (state_83904[(2)]);
var inst_83760__$1 = cljs.core.__destructure_map(inst_83759__$1);
var inst_83761 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83760__$1,cljs.core.cst$kw$f);
var inst_83762 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83760__$1,cljs.core.cst$kw$arity);
var inst_83763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83760__$1,cljs.core.cst$kw$arglist);
var inst_83764__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_83760__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_83904__$1 = (function (){var statearr_83991 = state_83904;
(statearr_83991[(25)] = inst_83764__$1);

(statearr_83991[(17)] = inst_83762);

(statearr_83991[(26)] = inst_83763);

(statearr_83991[(27)] = inst_83760__$1);

(statearr_83991[(28)] = inst_83759__$1);

(statearr_83991[(22)] = inst_83761);

return statearr_83991;
})();
if(cljs.core.truth_(inst_83764__$1)){
var statearr_83992_84072 = state_83904__$1;
(statearr_83992_84072[(1)] = (10));

} else {
var statearr_83993_84073 = state_83904__$1;
(statearr_83993_84073[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83905 === (49))){
var inst_83850 = (state_83904[(23)]);
var state_83904__$1 = state_83904;
var statearr_83994_84074 = state_83904__$1;
(statearr_83994_84074[(2)] = inst_83850);

(statearr_83994_84074[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__24298__auto____0 = (function (){
var statearr_83995 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_83995[(0)] = fluree$db$dbfunctions$core$state_machine__24298__auto__);

(statearr_83995[(1)] = (1));

return statearr_83995;
});
var fluree$db$dbfunctions$core$state_machine__24298__auto____1 = (function (state_83904){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83904);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83996){var ex__24301__auto__ = e83996;
var statearr_83997_84075 = state_83904;
(statearr_83997_84075[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83904[(4)]))){
var statearr_83998_84076 = state_83904;
(statearr_83998_84076[(1)] = cljs.core.first((state_83904[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84077 = state_83904;
state_83904 = G__84077;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__24298__auto__ = function(state_83904){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__24298__auto____1.call(this,state_83904);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__24298__auto____0;
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__24298__auto____1;
return fluree$db$dbfunctions$core$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83999 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83999[(6)] = c__24424__auto__);

return statearr_83999;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__84079 = arguments.length;
switch (G__84079) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84161){
var state_val_84162 = (state_84161[(1)]);
if((state_val_84162 === (7))){
var inst_84089 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_84161__$1 = state_84161;
var statearr_84163_84211 = state_84161__$1;
(statearr_84163_84211[(2)] = inst_84089);

(statearr_84163_84211[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (20))){
var inst_84139 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_84161__$1 = state_84161;
var statearr_84164_84212 = state_84161__$1;
(statearr_84164_84212[(2)] = inst_84139);

(statearr_84164_84212[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (1))){
var state_84161__$1 = state_84161;
var statearr_84165_84213 = state_84161__$1;
(statearr_84165_84213[(2)] = null);

(statearr_84165_84213[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (24))){
var inst_84136 = (state_84161[(7)]);
var inst_84145 = cljs.core.eval(inst_84136);
var state_84161__$1 = state_84161;
var statearr_84167_84214 = state_84161__$1;
(statearr_84167_84214[(2)] = inst_84145);

(statearr_84167_84214[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (4))){
var inst_84080 = (state_84161[(2)]);
var state_84161__$1 = state_84161;
var statearr_84168_84215 = state_84161__$1;
(statearr_84168_84215[(2)] = inst_84080);

(statearr_84168_84215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (15))){
var _ = (function (){var statearr_84169 = state_84161;
(statearr_84169[(4)] = cljs.core.rest((state_84161[(4)])));

return statearr_84169;
})();
var state_84161__$1 = state_84161;
var ex84166 = (state_84161__$1[(2)]);
var statearr_84170_84216 = state_84161__$1;
(statearr_84170_84216[(5)] = ex84166);


var statearr_84171_84217 = state_84161__$1;
(statearr_84171_84217[(1)] = (14));

(statearr_84171_84217[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (21))){
var inst_84137 = (state_84161[(8)]);
var state_84161__$1 = state_84161;
var statearr_84172_84218 = state_84161__$1;
(statearr_84172_84218[(2)] = inst_84137);

(statearr_84172_84218[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (13))){
var inst_84154 = (state_84161[(2)]);
var state_84161__$1 = state_84161;
var statearr_84173_84219 = state_84161__$1;
(statearr_84173_84219[(2)] = inst_84154);

(statearr_84173_84219[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (22))){
var inst_84142 = (state_84161[(2)]);
var state_84161__$1 = state_84161;
if(cljs.core.truth_(inst_84142)){
var statearr_84174_84220 = state_84161__$1;
(statearr_84174_84220[(1)] = (23));

} else {
var statearr_84175_84221 = state_84161__$1;
(statearr_84175_84221[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (6))){
var inst_84086 = (state_84161[(9)]);
var state_84161__$1 = state_84161;
var statearr_84176_84222 = state_84161__$1;
(statearr_84176_84222[(2)] = inst_84086);

(statearr_84176_84222[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (25))){
var inst_84147 = (state_84161[(2)]);
var inst_84148 = [cljs.core.cst$kw$fnstr];
var inst_84149 = [fn_str];
var inst_84150 = cljs.core.PersistentHashMap.fromArrays(inst_84148,inst_84149);
var inst_84151 = cljs.core.with_meta(inst_84147,inst_84150);
var _ = (function (){var statearr_84177 = state_84161;
(statearr_84177[(4)] = cljs.core.rest((state_84161[(4)])));

return statearr_84177;
})();
var state_84161__$1 = state_84161;
var statearr_84178_84223 = state_84161__$1;
(statearr_84178_84223[(2)] = inst_84151);

(statearr_84178_84223[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (17))){
var inst_84112 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_84113 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_84114 = cljs.core.PersistentHashMap.fromArrays(inst_84112,inst_84113);
var inst_84115 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_84114);
var inst_84116 = (function(){throw inst_84115})();
var state_84161__$1 = state_84161;
var statearr_84179_84224 = state_84161__$1;
(statearr_84179_84224[(2)] = inst_84116);

(statearr_84179_84224[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (3))){
var inst_84159 = (state_84161[(2)]);
var state_84161__$1 = state_84161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84161__$1,inst_84159);
} else {
if((state_val_84162 === (12))){
var _ = (function (){var statearr_84180 = state_84161;
(statearr_84180[(4)] = cljs.core.cons((15),(state_84161[(4)])));

return statearr_84180;
})();
var inst_84109 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_84161__$1 = state_84161;
if(cljs.core.truth_(inst_84109)){
var statearr_84181_84225 = state_84161__$1;
(statearr_84181_84225[(1)] = (16));

} else {
var statearr_84182_84226 = state_84161__$1;
(statearr_84182_84226[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (2))){
var inst_84086 = (state_84161[(9)]);
var _ = (function (){var statearr_84183 = state_84161;
(statearr_84183[(4)] = cljs.core.cons((5),(state_84161[(4)])));

return statearr_84183;
})();
var inst_84086__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_84161__$1 = (function (){var statearr_84184 = state_84161;
(statearr_84184[(9)] = inst_84086__$1);

return statearr_84184;
})();
if(inst_84086__$1){
var statearr_84185_84227 = state_84161__$1;
(statearr_84185_84227[(1)] = (6));

} else {
var statearr_84186_84228 = state_84161__$1;
(statearr_84186_84228[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (23))){
var inst_84136 = (state_84161[(7)]);
var state_84161__$1 = state_84161;
var statearr_84187_84229 = state_84161__$1;
(statearr_84187_84229[(2)] = inst_84136);

(statearr_84187_84229[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (19))){
var inst_84137 = (state_84161[(8)]);
var inst_84122 = (state_84161[(2)]);
var inst_84123 = fluree.db.util.async.throw_err(inst_84122);
var inst_84124 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_84125 = (new cljs.core.List(null,inst_84124,null,(1),null));
var inst_84126 = cljs.core.cst$sym$_QMARK_ctx;
var inst_84127 = (new cljs.core.List(null,inst_84126,null,(1),null));
var inst_84128 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_84127);
var inst_84129 = cljs.core.seq(inst_84128);
var inst_84130 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_84129);
var inst_84131 = cljs.core.vec(inst_84130);
var inst_84132 = (new cljs.core.List(null,inst_84131,null,(1),null));
var inst_84133 = (new cljs.core.List(null,inst_84123,null,(1),null));
var inst_84134 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_84125,inst_84132,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_84133], 0));
var inst_84135 = cljs.core.seq(inst_84134);
var inst_84136 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_84135);
var inst_84137__$1 = params;
var state_84161__$1 = (function (){var statearr_84188 = state_84161;
(statearr_84188[(7)] = inst_84136);

(statearr_84188[(8)] = inst_84137__$1);

return statearr_84188;
})();
if(cljs.core.truth_(inst_84137__$1)){
var statearr_84189_84230 = state_84161__$1;
(statearr_84189_84230[(1)] = (20));

} else {
var statearr_84190_84231 = state_84161__$1;
(statearr_84190_84231[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (11))){
var inst_84156 = (state_84161[(2)]);
var _ = (function (){var statearr_84192 = state_84161;
(statearr_84192[(4)] = cljs.core.rest((state_84161[(4)])));

return statearr_84192;
})();
var state_84161__$1 = state_84161;
var statearr_84193_84232 = state_84161__$1;
(statearr_84193_84232[(2)] = inst_84156);

(statearr_84193_84232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (9))){
var inst_84093 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_84094 = fluree.db.dbfunctions.core.true_or_false = inst_84093;
var state_84161__$1 = state_84161;
var statearr_84194_84233 = state_84161__$1;
(statearr_84194_84233[(2)] = inst_84094);

(statearr_84194_84233[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (5))){
var _ = (function (){var statearr_84195 = state_84161;
(statearr_84195[(4)] = cljs.core.rest((state_84161[(4)])));

return statearr_84195;
})();
var state_84161__$1 = state_84161;
var ex84191 = (state_84161__$1[(2)]);
var statearr_84196_84234 = state_84161__$1;
(statearr_84196_84234[(5)] = ex84191);


if((ex84191 instanceof Error)){
var statearr_84197_84235 = state_84161__$1;
(statearr_84197_84235[(1)] = (4));

(statearr_84197_84235[(5)] = null);

} else {
throw ex84191;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (14))){
var inst_84096 = (state_84161[(2)]);
var inst_84097 = (function(){throw inst_84096})();
var inst_84098 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_84099 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_84100 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_84101 = cljs.core.PersistentHashMap.fromArrays(inst_84099,inst_84100);
var inst_84102 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_84098,inst_84101);
var inst_84103 = (function(){throw inst_84102})();
var state_84161__$1 = (function (){var statearr_84198 = state_84161;
(statearr_84198[(10)] = inst_84097);

return statearr_84198;
})();
var statearr_84199_84236 = state_84161__$1;
(statearr_84199_84236[(2)] = inst_84103);

(statearr_84199_84236[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (16))){
var state_84161__$1 = state_84161;
var statearr_84200_84237 = state_84161__$1;
(statearr_84200_84237[(2)] = null);

(statearr_84200_84237[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (10))){
var state_84161__$1 = state_84161;
var statearr_84201_84238 = state_84161__$1;
(statearr_84201_84238[(2)] = null);

(statearr_84201_84238[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84162 === (18))){
var inst_84118 = (state_84161[(2)]);
var inst_84119 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_84120 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_84119,type,params);
var state_84161__$1 = (function (){var statearr_84202 = state_84161;
(statearr_84202[(11)] = inst_84118);

return statearr_84202;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84161__$1,(19),inst_84120);
} else {
if((state_val_84162 === (8))){
var inst_84091 = (state_84161[(2)]);
var state_84161__$1 = state_84161;
if(cljs.core.truth_(inst_84091)){
var statearr_84203_84239 = state_84161__$1;
(statearr_84203_84239[(1)] = (9));

} else {
var statearr_84204_84240 = state_84161__$1;
(statearr_84204_84240[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__24298__auto____0 = (function (){
var statearr_84205 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_84205[(0)] = fluree$db$dbfunctions$core$state_machine__24298__auto__);

(statearr_84205[(1)] = (1));

return statearr_84205;
});
var fluree$db$dbfunctions$core$state_machine__24298__auto____1 = (function (state_84161){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84161);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84206){var ex__24301__auto__ = e84206;
var statearr_84207_84241 = state_84161;
(statearr_84207_84241[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84161[(4)]))){
var statearr_84208_84242 = state_84161;
(statearr_84208_84242[(1)] = cljs.core.first((state_84161[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84243 = state_84161;
state_84161 = G__84243;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__24298__auto__ = function(state_84161){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__24298__auto____1.call(this,state_84161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__24298__auto____0;
fluree$db$dbfunctions$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__24298__auto____1;
return fluree$db$dbfunctions$core$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84209 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84209[(6)] = c__24424__auto__);

return statearr_84209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_84271){
var state_val_84272 = (state_84271[(1)]);
if((state_val_84272 === (7))){
var inst_84258 = (state_84271[(7)]);
var state_84271__$1 = state_84271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84271__$1,(10),inst_84258);
} else {
if((state_val_84272 === (1))){
var state_84271__$1 = state_84271;
var statearr_84273_84293 = state_84271__$1;
(statearr_84273_84293[(2)] = null);

(statearr_84273_84293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (4))){
var inst_84244 = (state_84271[(2)]);
var state_84271__$1 = state_84271;
var statearr_84274_84294 = state_84271__$1;
(statearr_84274_84294[(2)] = inst_84244);

(statearr_84274_84294[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (6))){
var inst_84253 = (state_84271[(8)]);
var inst_84258 = (state_84271[(7)]);
var inst_84256 = (state_84271[(2)]);
var inst_84257 = fluree.db.util.async.throw_err(inst_84256);
var inst_84258__$1 = (inst_84257.cljs$core$IFn$_invoke$arity$1 ? inst_84257.cljs$core$IFn$_invoke$arity$1(inst_84253) : inst_84257.call(null,inst_84253));
var inst_84259 = fluree.db.util.async.channel_QMARK_(inst_84258__$1);
var state_84271__$1 = (function (){var statearr_84275 = state_84271;
(statearr_84275[(7)] = inst_84258__$1);

return statearr_84275;
})();
if(inst_84259){
var statearr_84276_84295 = state_84271__$1;
(statearr_84276_84295[(1)] = (7));

} else {
var statearr_84277_84296 = state_84271__$1;
(statearr_84277_84296[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (3))){
var inst_84269 = (state_84271[(2)]);
var state_84271__$1 = state_84271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_84271__$1,inst_84269);
} else {
if((state_val_84272 === (2))){
var _ = (function (){var statearr_84279 = state_84271;
(statearr_84279[(4)] = cljs.core.cons((5),(state_84271[(4)])));

return statearr_84279;
})();
var inst_84250 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_84251 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_84252 = [db,block_instant,s,p,auth_id,fuel];
var inst_84253 = cljs.core.PersistentHashMap.fromArrays(inst_84251,inst_84252);
var inst_84254 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_84250,"txn",null);
var state_84271__$1 = (function (){var statearr_84280 = state_84271;
(statearr_84280[(8)] = inst_84253);

return statearr_84280;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_84271__$1,(6),inst_84254);
} else {
if((state_val_84272 === (9))){
var inst_84266 = (state_84271[(2)]);
var _ = (function (){var statearr_84281 = state_84271;
(statearr_84281[(4)] = cljs.core.rest((state_84271[(4)])));

return statearr_84281;
})();
var state_84271__$1 = state_84271;
var statearr_84282_84297 = state_84271__$1;
(statearr_84282_84297[(2)] = inst_84266);

(statearr_84282_84297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (5))){
var _ = (function (){var statearr_84283 = state_84271;
(statearr_84283[(4)] = cljs.core.rest((state_84271[(4)])));

return statearr_84283;
})();
var state_84271__$1 = state_84271;
var ex84278 = (state_84271__$1[(2)]);
var statearr_84284_84298 = state_84271__$1;
(statearr_84284_84298[(5)] = ex84278);


if((ex84278 instanceof Error)){
var statearr_84285_84299 = state_84271__$1;
(statearr_84285_84299[(1)] = (4));

(statearr_84285_84299[(5)] = null);

} else {
throw ex84278;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (10))){
var inst_84262 = (state_84271[(2)]);
var inst_84263 = fluree.db.util.async.throw_err(inst_84262);
var state_84271__$1 = state_84271;
var statearr_84286_84300 = state_84271__$1;
(statearr_84286_84300[(2)] = inst_84263);

(statearr_84286_84300[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_84272 === (8))){
var inst_84258 = (state_84271[(7)]);
var state_84271__$1 = state_84271;
var statearr_84287_84301 = state_84271__$1;
(statearr_84287_84301[(2)] = inst_84258);

(statearr_84287_84301[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____0 = (function (){
var statearr_84288 = [null,null,null,null,null,null,null,null,null];
(statearr_84288[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__);

(statearr_84288[(1)] = (1));

return statearr_84288;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____1 = (function (state_84271){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_84271);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e84289){var ex__24301__auto__ = e84289;
var statearr_84290_84302 = state_84271;
(statearr_84290_84302[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_84271[(4)]))){
var statearr_84291_84303 = state_84271;
(statearr_84291_84303[(1)] = cljs.core.first((state_84271[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__84304 = state_84271;
state_84271 = G__84304;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__ = function(state_84271){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____1.call(this,state_84271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_84292 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_84292[(6)] = c__24424__auto__);

return statearr_84292;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
