// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___79534 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_79585){
var state_val_79586 = (state_79585[(1)]);
if((state_val_79586 === (7))){
var inst_79580 = (state_79585[(2)]);
var _ = (function (){var statearr_79587 = state_79585;
(statearr_79587[(4)] = cljs.core.rest((state_79585[(4)])));

return statearr_79587;
})();
var state_79585__$1 = state_79585;
var statearr_79588_79615 = state_79585__$1;
(statearr_79588_79615[(2)] = inst_79580);

(statearr_79588_79615[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (1))){
var state_79585__$1 = state_79585;
var statearr_79589_79616 = state_79585__$1;
(statearr_79589_79616[(2)] = null);

(statearr_79589_79616[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (4))){
var inst_79535 = (state_79585[(2)]);
var state_79585__$1 = state_79585;
var statearr_79590_79617 = state_79585__$1;
(statearr_79590_79617[(2)] = inst_79535);

(statearr_79590_79617[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (13))){
var inst_79576 = (state_79585[(2)]);
var state_79585__$1 = state_79585;
var statearr_79591_79618 = state_79585__$1;
(statearr_79591_79618[(2)] = inst_79576);

(statearr_79591_79618[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (6))){
var inst_79560 = (state_79585[(7)]);
var inst_79553 = (state_79585[(8)]);
var inst_79559 = cljs.core.seq(inst_79553);
var inst_79560__$1 = cljs.core.first(inst_79559);
var inst_79561 = cljs.core.next(inst_79559);
var inst_79562 = cljs.core.not(inst_79560__$1);
var state_79585__$1 = (function (){var statearr_79592 = state_79585;
(statearr_79592[(9)] = inst_79561);

(statearr_79592[(7)] = inst_79560__$1);

return statearr_79592;
})();
if(inst_79562){
var statearr_79593_79619 = state_79585__$1;
(statearr_79593_79619[(1)] = (8));

} else {
var statearr_79594_79620 = state_79585__$1;
(statearr_79594_79620[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (3))){
var inst_79583 = (state_79585[(2)]);
var state_79585__$1 = state_79585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79585__$1,inst_79583);
} else {
if((state_val_79586 === (12))){
var inst_79561 = (state_79585[(9)]);
var inst_79560 = (state_79585[(7)]);
var inst_79554 = (state_79585[(10)]);
var inst_79573 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_79554,inst_79560);
var inst_79553 = inst_79561;
var inst_79554__$1 = inst_79573;
var state_79585__$1 = (function (){var statearr_79595 = state_79585;
(statearr_79595[(8)] = inst_79553);

(statearr_79595[(10)] = inst_79554__$1);

return statearr_79595;
})();
var statearr_79596_79621 = state_79585__$1;
(statearr_79596_79621[(2)] = null);

(statearr_79596_79621[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (2))){
var _ = (function (){var statearr_79597 = state_79585;
(statearr_79597[(4)] = cljs.core.cons((5),(state_79585[(4)])));

return statearr_79597;
})();
var inst_79548 = args;
var inst_79549 = cljs.core.seq(inst_79548);
var inst_79550 = cljs.core.first(inst_79549);
var inst_79551 = cljs.core.next(inst_79549);
var inst_79552 = cljs.core.PersistentVector.EMPTY;
var inst_79553 = inst_79548;
var inst_79554 = inst_79552;
var state_79585__$1 = (function (){var statearr_79598 = state_79585;
(statearr_79598[(11)] = inst_79550);

(statearr_79598[(12)] = inst_79551);

(statearr_79598[(8)] = inst_79553);

(statearr_79598[(10)] = inst_79554);

return statearr_79598;
})();
var statearr_79599_79622 = state_79585__$1;
(statearr_79599_79622[(2)] = null);

(statearr_79599_79622[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (11))){
var inst_79560 = (state_79585[(7)]);
var state_79585__$1 = state_79585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79585__$1,(14),inst_79560);
} else {
if((state_val_79586 === (9))){
var inst_79560 = (state_79585[(7)]);
var inst_79565 = fluree.db.util.async.channel_QMARK_(inst_79560);
var state_79585__$1 = state_79585;
if(inst_79565){
var statearr_79601_79623 = state_79585__$1;
(statearr_79601_79623[(1)] = (11));

} else {
var statearr_79602_79624 = state_79585__$1;
(statearr_79602_79624[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (5))){
var _ = (function (){var statearr_79603 = state_79585;
(statearr_79603[(4)] = cljs.core.rest((state_79585[(4)])));

return statearr_79603;
})();
var state_79585__$1 = state_79585;
var ex79600 = (state_79585__$1[(2)]);
var statearr_79604_79625 = state_79585__$1;
(statearr_79604_79625[(5)] = ex79600);


if((ex79600 instanceof Error)){
var statearr_79605_79626 = state_79585__$1;
(statearr_79605_79626[(1)] = (4));

(statearr_79605_79626[(5)] = null);

} else {
throw ex79600;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (14))){
var inst_79561 = (state_79585[(9)]);
var inst_79554 = (state_79585[(10)]);
var inst_79568 = (state_79585[(2)]);
var inst_79569 = fluree.db.util.async.throw_err(inst_79568);
var inst_79570 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_79554,inst_79569);
var inst_79553 = inst_79561;
var inst_79554__$1 = inst_79570;
var state_79585__$1 = (function (){var statearr_79606 = state_79585;
(statearr_79606[(8)] = inst_79553);

(statearr_79606[(10)] = inst_79554__$1);

return statearr_79606;
})();
var statearr_79607_79627 = state_79585__$1;
(statearr_79607_79627[(2)] = null);

(statearr_79607_79627[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (10))){
var inst_79578 = (state_79585[(2)]);
var state_79585__$1 = state_79585;
var statearr_79608_79628 = state_79585__$1;
(statearr_79608_79628[(2)] = inst_79578);

(statearr_79608_79628[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79586 === (8))){
var inst_79554 = (state_79585[(10)]);
var state_79585__$1 = state_79585;
var statearr_79609_79629 = state_79585__$1;
(statearr_79609_79629[(2)] = inst_79554);

(statearr_79609_79629[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____0 = (function (){
var statearr_79610 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_79610[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__);

(statearr_79610[(1)] = (1));

return statearr_79610;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____1 = (function (state_79585){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_79585);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e79611){var ex__24301__auto__ = e79611;
var statearr_79612_79630 = state_79585;
(statearr_79612_79630[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_79585[(4)]))){
var statearr_79613_79631 = state_79585;
(statearr_79613_79631[(1)] = cljs.core.first((state_79585[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__79632 = state_79585;
state_79585 = G__79632;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__ = function(state_79585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____1.call(this,state_79585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_79614 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_79614[(6)] = c__24424__auto__);

return statearr_79614;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__79633 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79633,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__79633,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_79681){
var state_val_79682 = (state_79681[(1)]);
if((state_val_79682 === (7))){
var state_79681__$1 = state_79681;
var statearr_79683_79712 = state_79681__$1;
(statearr_79683_79712[(2)] = coll);

(statearr_79683_79712[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (1))){
var state_79681__$1 = state_79681;
var statearr_79684_79713 = state_79681__$1;
(statearr_79684_79713[(2)] = null);

(statearr_79684_79713[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (4))){
var inst_79636 = (state_79681[(2)]);
var state_79681__$1 = state_79681;
var statearr_79685_79714 = state_79681__$1;
(statearr_79685_79714[(2)] = inst_79636);

(statearr_79685_79714[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (15))){
var inst_79655 = (state_79681[(7)]);
var inst_79663 = (state_79681[(2)]);
var inst_79664 = fluree.db.dbfunctions.internal.nth(inst_79655,inst_79663);
var inst_79665 = cljs.core.count(inst_79655);
var inst_79666 = ((9) + inst_79665);
var inst_79667 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79668 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_79669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79670 = [inst_79655,inst_79663];
var inst_79671 = (new cljs.core.PersistentVector(null,2,(5),inst_79669,inst_79670,null));
var inst_79672 = ["nth",inst_79671,inst_79664];
var inst_79673 = cljs.core.PersistentHashMap.fromArrays(inst_79668,inst_79672);
var inst_79674 = [inst_79673,inst_79666];
var inst_79675 = (new cljs.core.PersistentVector(null,2,(5),inst_79667,inst_79674,null));
var inst_79676 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_79675);
var _ = (function (){var statearr_79686 = state_79681;
(statearr_79686[(4)] = cljs.core.rest((state_79681[(4)])));

return statearr_79686;
})();
var state_79681__$1 = (function (){var statearr_79687 = state_79681;
(statearr_79687[(8)] = inst_79676);

return statearr_79687;
})();
var statearr_79688_79715 = state_79681__$1;
(statearr_79688_79715[(2)] = inst_79664);

(statearr_79688_79715[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (13))){
var state_79681__$1 = state_79681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79681__$1,(16),key);
} else {
if((state_val_79682 === (6))){
var state_79681__$1 = state_79681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79681__$1,(9),coll);
} else {
if((state_val_79682 === (3))){
var inst_79679 = (state_79681[(2)]);
var state_79681__$1 = state_79681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79681__$1,inst_79679);
} else {
if((state_val_79682 === (12))){
var inst_79655 = (state_79681[(2)]);
var inst_79656 = fluree.db.util.async.channel_QMARK_(key);
var state_79681__$1 = (function (){var statearr_79689 = state_79681;
(statearr_79689[(7)] = inst_79655);

return statearr_79689;
})();
if(inst_79656){
var statearr_79690_79716 = state_79681__$1;
(statearr_79690_79716[(1)] = (13));

} else {
var statearr_79691_79717 = state_79681__$1;
(statearr_79691_79717[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (2))){
var _ = (function (){var statearr_79692 = state_79681;
(statearr_79692[(4)] = cljs.core.cons((5),(state_79681[(4)])));

return statearr_79692;
})();
var inst_79642 = fluree.db.util.async.channel_QMARK_(coll);
var state_79681__$1 = state_79681;
if(inst_79642){
var statearr_79693_79718 = state_79681__$1;
(statearr_79693_79718[(1)] = (6));

} else {
var statearr_79694_79719 = state_79681__$1;
(statearr_79694_79719[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (11))){
var inst_79649 = (state_79681[(9)]);
var state_79681__$1 = state_79681;
var statearr_79696_79720 = state_79681__$1;
(statearr_79696_79720[(2)] = inst_79649);

(statearr_79696_79720[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (9))){
var inst_79645 = (state_79681[(2)]);
var inst_79646 = fluree.db.util.async.throw_err(inst_79645);
var state_79681__$1 = state_79681;
var statearr_79697_79721 = state_79681__$1;
(statearr_79697_79721[(2)] = inst_79646);

(statearr_79697_79721[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (5))){
var _ = (function (){var statearr_79698 = state_79681;
(statearr_79698[(4)] = cljs.core.rest((state_79681[(4)])));

return statearr_79698;
})();
var state_79681__$1 = state_79681;
var ex79695 = (state_79681__$1[(2)]);
var statearr_79699_79722 = state_79681__$1;
(statearr_79699_79722[(5)] = ex79695);


if((ex79695 instanceof Error)){
var statearr_79700_79723 = state_79681__$1;
(statearr_79700_79723[(1)] = (4));

(statearr_79700_79723[(5)] = null);

} else {
throw ex79695;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (14))){
var state_79681__$1 = state_79681;
var statearr_79701_79724 = state_79681__$1;
(statearr_79701_79724[(2)] = key);

(statearr_79701_79724[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (16))){
var inst_79659 = (state_79681[(2)]);
var inst_79660 = fluree.db.util.async.throw_err(inst_79659);
var state_79681__$1 = state_79681;
var statearr_79702_79725 = state_79681__$1;
(statearr_79702_79725[(2)] = inst_79660);

(statearr_79702_79725[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (10))){
var inst_79649 = (state_79681[(9)]);
var inst_79652 = cljs.core.vec(inst_79649);
var state_79681__$1 = state_79681;
var statearr_79703_79726 = state_79681__$1;
(statearr_79703_79726[(2)] = inst_79652);

(statearr_79703_79726[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79682 === (8))){
var inst_79649 = (state_79681[(9)]);
var inst_79649__$1 = (state_79681[(2)]);
var inst_79650 = cljs.core.set_QMARK_(inst_79649__$1);
var state_79681__$1 = (function (){var statearr_79704 = state_79681;
(statearr_79704[(9)] = inst_79649__$1);

return statearr_79704;
})();
if(inst_79650){
var statearr_79705_79727 = state_79681__$1;
(statearr_79705_79727[(1)] = (10));

} else {
var statearr_79706_79728 = state_79681__$1;
(statearr_79706_79728[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____0 = (function (){
var statearr_79707 = [null,null,null,null,null,null,null,null,null,null];
(statearr_79707[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__);

(statearr_79707[(1)] = (1));

return statearr_79707;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____1 = (function (state_79681){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_79681);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e79708){var ex__24301__auto__ = e79708;
var statearr_79709_79729 = state_79681;
(statearr_79709_79729[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_79681[(4)]))){
var statearr_79710_79730 = state_79681;
(statearr_79710_79730[(1)] = cljs.core.first((state_79681[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__79731 = state_79681;
state_79681 = G__79731;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__ = function(state_79681){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____1.call(this,state_79681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_79711 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_79711[(6)] = c__24424__auto__);

return statearr_79711;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_79792){
var state_val_79793 = (state_79792[(1)]);
if((state_val_79793 === (7))){
var state_79792__$1 = state_79792;
var statearr_79794_79828 = state_79792__$1;
(statearr_79794_79828[(2)] = test);

(statearr_79794_79828[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (20))){
var inst_79766 = (state_79792[(2)]);
var inst_79767 = fluree.db.util.async.throw_err(inst_79766);
var state_79792__$1 = state_79792;
var statearr_79795_79829 = state_79792__$1;
(statearr_79795_79829[(2)] = inst_79767);

(statearr_79795_79829[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (1))){
var state_79792__$1 = state_79792;
var statearr_79796_79830 = state_79792__$1;
(statearr_79796_79830[(2)] = null);

(statearr_79796_79830[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (4))){
var inst_79732 = (state_79792[(2)]);
var state_79792__$1 = state_79792;
var statearr_79797_79831 = state_79792__$1;
(statearr_79797_79831[(2)] = inst_79732);

(statearr_79797_79831[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (15))){
var inst_79750 = (state_79792[(7)]);
var inst_79758 = (state_79792[(2)]);
var inst_79759 = [inst_79758,f];
var inst_79760 = (new cljs.core.PersistentVector(null,2,(5),inst_79750,inst_79759,null));
var state_79792__$1 = state_79792;
var statearr_79798_79832 = state_79792__$1;
(statearr_79798_79832[(2)] = inst_79760);

(statearr_79798_79832[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (13))){
var state_79792__$1 = state_79792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79792__$1,(16),t);
} else {
if((state_val_79793 === (6))){
var state_79792__$1 = state_79792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79792__$1,(9),test);
} else {
if((state_val_79793 === (17))){
var state_79792__$1 = state_79792;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79792__$1,(20),f);
} else {
if((state_val_79793 === (3))){
var inst_79790 = (state_79792[(2)]);
var state_79792__$1 = state_79792;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79792__$1,inst_79790);
} else {
if((state_val_79793 === (12))){
var inst_79748 = (state_79792[(8)]);
var inst_79774 = (state_79792[(2)]);
var inst_79775 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79774,(0),null);
var inst_79776 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_79774,(1),null);
var inst_79777 = fluree.db.dbfunctions.internal.if_else(inst_79748,inst_79775,inst_79776);
var inst_79778 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79779 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_79780 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79781 = [inst_79748,inst_79775,inst_79776];
var inst_79782 = (new cljs.core.PersistentVector(null,3,(5),inst_79780,inst_79781,null));
var inst_79783 = ["if-else",inst_79782,inst_79777];
var inst_79784 = cljs.core.PersistentHashMap.fromArrays(inst_79779,inst_79783);
var inst_79785 = [inst_79784,(10)];
var inst_79786 = (new cljs.core.PersistentVector(null,2,(5),inst_79778,inst_79785,null));
var inst_79787 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_79786);
var _ = (function (){var statearr_79799 = state_79792;
(statearr_79799[(4)] = cljs.core.rest((state_79792[(4)])));

return statearr_79799;
})();
var state_79792__$1 = (function (){var statearr_79800 = state_79792;
(statearr_79800[(9)] = inst_79787);

return statearr_79800;
})();
var statearr_79801_79833 = state_79792__$1;
(statearr_79801_79833[(2)] = inst_79777);

(statearr_79801_79833[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (2))){
var _ = (function (){var statearr_79802 = state_79792;
(statearr_79802[(4)] = cljs.core.cons((5),(state_79792[(4)])));

return statearr_79802;
})();
var inst_79741 = fluree.db.util.async.channel_QMARK_(test);
var state_79792__$1 = state_79792;
if(inst_79741){
var statearr_79803_79834 = state_79792__$1;
(statearr_79803_79834[(1)] = (6));

} else {
var statearr_79804_79835 = state_79792__$1;
(statearr_79804_79835[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (19))){
var inst_79762 = (state_79792[(10)]);
var inst_79770 = (state_79792[(2)]);
var inst_79771 = [f,inst_79770];
var inst_79772 = (new cljs.core.PersistentVector(null,2,(5),inst_79762,inst_79771,null));
var state_79792__$1 = state_79792;
var statearr_79805_79836 = state_79792__$1;
(statearr_79805_79836[(2)] = inst_79772);

(statearr_79805_79836[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (11))){
var inst_79762 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79763 = fluree.db.util.async.channel_QMARK_(f);
var state_79792__$1 = (function (){var statearr_79807 = state_79792;
(statearr_79807[(10)] = inst_79762);

return statearr_79807;
})();
if(inst_79763){
var statearr_79808_79837 = state_79792__$1;
(statearr_79808_79837[(1)] = (17));

} else {
var statearr_79809_79838 = state_79792__$1;
(statearr_79809_79838[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (9))){
var inst_79744 = (state_79792[(2)]);
var inst_79745 = fluree.db.util.async.throw_err(inst_79744);
var state_79792__$1 = state_79792;
var statearr_79810_79839 = state_79792__$1;
(statearr_79810_79839[(2)] = inst_79745);

(statearr_79810_79839[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (5))){
var _ = (function (){var statearr_79811 = state_79792;
(statearr_79811[(4)] = cljs.core.rest((state_79792[(4)])));

return statearr_79811;
})();
var state_79792__$1 = state_79792;
var ex79806 = (state_79792__$1[(2)]);
var statearr_79812_79840 = state_79792__$1;
(statearr_79812_79840[(5)] = ex79806);


if((ex79806 instanceof Error)){
var statearr_79813_79841 = state_79792__$1;
(statearr_79813_79841[(1)] = (4));

(statearr_79813_79841[(5)] = null);

} else {
throw ex79806;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (14))){
var state_79792__$1 = state_79792;
var statearr_79814_79842 = state_79792__$1;
(statearr_79814_79842[(2)] = t);

(statearr_79814_79842[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (16))){
var inst_79754 = (state_79792[(2)]);
var inst_79755 = fluree.db.util.async.throw_err(inst_79754);
var state_79792__$1 = state_79792;
var statearr_79815_79843 = state_79792__$1;
(statearr_79815_79843[(2)] = inst_79755);

(statearr_79815_79843[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (10))){
var inst_79750 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79751 = fluree.db.util.async.channel_QMARK_(t);
var state_79792__$1 = (function (){var statearr_79816 = state_79792;
(statearr_79816[(7)] = inst_79750);

return statearr_79816;
})();
if(inst_79751){
var statearr_79817_79844 = state_79792__$1;
(statearr_79817_79844[(1)] = (13));

} else {
var statearr_79818_79845 = state_79792__$1;
(statearr_79818_79845[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (18))){
var state_79792__$1 = state_79792;
var statearr_79819_79846 = state_79792__$1;
(statearr_79819_79846[(2)] = f);

(statearr_79819_79846[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79793 === (8))){
var inst_79748 = (state_79792[(8)]);
var inst_79748__$1 = (state_79792[(2)]);
var state_79792__$1 = (function (){var statearr_79820 = state_79792;
(statearr_79820[(8)] = inst_79748__$1);

return statearr_79820;
})();
if(cljs.core.truth_(inst_79748__$1)){
var statearr_79821_79847 = state_79792__$1;
(statearr_79821_79847[(1)] = (10));

} else {
var statearr_79822_79848 = state_79792__$1;
(statearr_79822_79848[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____0 = (function (){
var statearr_79823 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_79823[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__);

(statearr_79823[(1)] = (1));

return statearr_79823;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____1 = (function (state_79792){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_79792);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e79824){var ex__24301__auto__ = e79824;
var statearr_79825_79849 = state_79792;
(statearr_79825_79849[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_79792[(4)]))){
var statearr_79826_79850 = state_79792;
(statearr_79826_79850[(1)] = cljs.core.first((state_79792[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__79851 = state_79792;
state_79792 = G__79851;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__ = function(state_79792){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____1.call(this,state_79792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_79827 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_79827[(6)] = c__24424__auto__);

return statearr_79827;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_79881){
var state_val_79882 = (state_79881[(1)]);
if((state_val_79882 === (7))){
var state_79881__$1 = state_79881;
var statearr_79883_79902 = state_79881__$1;
(statearr_79883_79902[(2)] = arg);

(statearr_79883_79902[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (1))){
var state_79881__$1 = state_79881;
var statearr_79884_79903 = state_79881__$1;
(statearr_79884_79903[(2)] = null);

(statearr_79884_79903[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (4))){
var inst_79852 = (state_79881[(2)]);
var state_79881__$1 = state_79881;
var statearr_79885_79904 = state_79881__$1;
(statearr_79885_79904[(2)] = inst_79852);

(statearr_79885_79904[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (6))){
var state_79881__$1 = state_79881;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79881__$1,(9),arg);
} else {
if((state_val_79882 === (3))){
var inst_79879 = (state_79881[(2)]);
var state_79881__$1 = state_79881;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79881__$1,inst_79879);
} else {
if((state_val_79882 === (2))){
var _ = (function (){var statearr_79887 = state_79881;
(statearr_79887[(4)] = cljs.core.cons((5),(state_79881[(4)])));

return statearr_79887;
})();
var inst_79858 = fluree.db.util.async.channel_QMARK_(arg);
var state_79881__$1 = state_79881;
if(inst_79858){
var statearr_79888_79905 = state_79881__$1;
(statearr_79888_79905[(1)] = (6));

} else {
var statearr_79889_79906 = state_79881__$1;
(statearr_79889_79906[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (9))){
var inst_79861 = (state_79881[(2)]);
var inst_79862 = fluree.db.util.async.throw_err(inst_79861);
var state_79881__$1 = state_79881;
var statearr_79890_79907 = state_79881__$1;
(statearr_79890_79907[(2)] = inst_79862);

(statearr_79890_79907[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (5))){
var _ = (function (){var statearr_79891 = state_79881;
(statearr_79891[(4)] = cljs.core.rest((state_79881[(4)])));

return statearr_79891;
})();
var state_79881__$1 = state_79881;
var ex79886 = (state_79881__$1[(2)]);
var statearr_79892_79908 = state_79881__$1;
(statearr_79892_79908[(5)] = ex79886);


if((ex79886 instanceof Error)){
var statearr_79893_79909 = state_79881__$1;
(statearr_79893_79909[(1)] = (4));

(statearr_79893_79909[(5)] = null);

} else {
throw ex79886;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79882 === (8))){
var inst_79865 = (state_79881[(2)]);
var inst_79866 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_79865);
var inst_79867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79868 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_79869 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79870 = [inst_79865];
var inst_79871 = (new cljs.core.PersistentVector(null,1,(5),inst_79869,inst_79870,null));
var inst_79872 = ["nil?",inst_79871,inst_79866];
var inst_79873 = cljs.core.PersistentHashMap.fromArrays(inst_79868,inst_79872);
var inst_79874 = [inst_79873,(10)];
var inst_79875 = (new cljs.core.PersistentVector(null,2,(5),inst_79867,inst_79874,null));
var inst_79876 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_79875);
var _ = (function (){var statearr_79894 = state_79881;
(statearr_79894[(4)] = cljs.core.rest((state_79881[(4)])));

return statearr_79894;
})();
var state_79881__$1 = (function (){var statearr_79895 = state_79881;
(statearr_79895[(7)] = inst_79876);

return statearr_79895;
})();
var statearr_79896_79910 = state_79881__$1;
(statearr_79896_79910[(2)] = inst_79866);

(statearr_79896_79910[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_79897 = [null,null,null,null,null,null,null,null];
(statearr_79897[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__);

(statearr_79897[(1)] = (1));

return statearr_79897;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____1 = (function (state_79881){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_79881);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e79898){var ex__24301__auto__ = e79898;
var statearr_79899_79911 = state_79881;
(statearr_79899_79911[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_79881[(4)]))){
var statearr_79900_79912 = state_79881;
(statearr_79900_79912[(1)] = cljs.core.first((state_79881[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__79913 = state_79881;
state_79881 = G__79913;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__ = function(state_79881){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____1.call(this,state_79881);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_79901 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_79901[(6)] = c__24424__auto__);

return statearr_79901;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_79943){
var state_val_79944 = (state_79943[(1)]);
if((state_val_79944 === (7))){
var state_79943__$1 = state_79943;
var statearr_79945_79964 = state_79943__$1;
(statearr_79945_79964[(2)] = arg);

(statearr_79945_79964[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (1))){
var state_79943__$1 = state_79943;
var statearr_79946_79965 = state_79943__$1;
(statearr_79946_79965[(2)] = null);

(statearr_79946_79965[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (4))){
var inst_79914 = (state_79943[(2)]);
var state_79943__$1 = state_79943;
var statearr_79947_79966 = state_79943__$1;
(statearr_79947_79966[(2)] = inst_79914);

(statearr_79947_79966[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (6))){
var state_79943__$1 = state_79943;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_79943__$1,(9),arg);
} else {
if((state_val_79944 === (3))){
var inst_79941 = (state_79943[(2)]);
var state_79943__$1 = state_79943;
return cljs.core.async.impl.ioc_helpers.return_chan(state_79943__$1,inst_79941);
} else {
if((state_val_79944 === (2))){
var _ = (function (){var statearr_79949 = state_79943;
(statearr_79949[(4)] = cljs.core.cons((5),(state_79943[(4)])));

return statearr_79949;
})();
var inst_79920 = fluree.db.util.async.channel_QMARK_(arg);
var state_79943__$1 = state_79943;
if(inst_79920){
var statearr_79950_79967 = state_79943__$1;
(statearr_79950_79967[(1)] = (6));

} else {
var statearr_79951_79968 = state_79943__$1;
(statearr_79951_79968[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (9))){
var inst_79923 = (state_79943[(2)]);
var inst_79924 = fluree.db.util.async.throw_err(inst_79923);
var state_79943__$1 = state_79943;
var statearr_79952_79969 = state_79943__$1;
(statearr_79952_79969[(2)] = inst_79924);

(statearr_79952_79969[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (5))){
var _ = (function (){var statearr_79953 = state_79943;
(statearr_79953[(4)] = cljs.core.rest((state_79943[(4)])));

return statearr_79953;
})();
var state_79943__$1 = state_79943;
var ex79948 = (state_79943__$1[(2)]);
var statearr_79954_79970 = state_79943__$1;
(statearr_79954_79970[(5)] = ex79948);


if((ex79948 instanceof Error)){
var statearr_79955_79971 = state_79943__$1;
(statearr_79955_79971[(1)] = (4));

(statearr_79955_79971[(5)] = null);

} else {
throw ex79948;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_79944 === (8))){
var inst_79927 = (state_79943[(2)]);
var inst_79928 = fluree.db.dbfunctions.internal.not(inst_79927);
var inst_79929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79930 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_79931 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79932 = [inst_79927];
var inst_79933 = (new cljs.core.PersistentVector(null,1,(5),inst_79931,inst_79932,null));
var inst_79934 = ["not?",inst_79933,inst_79928];
var inst_79935 = cljs.core.PersistentHashMap.fromArrays(inst_79930,inst_79934);
var inst_79936 = [inst_79935,(10)];
var inst_79937 = (new cljs.core.PersistentVector(null,2,(5),inst_79929,inst_79936,null));
var inst_79938 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_79937);
var _ = (function (){var statearr_79956 = state_79943;
(statearr_79956[(4)] = cljs.core.rest((state_79943[(4)])));

return statearr_79956;
})();
var state_79943__$1 = (function (){var statearr_79957 = state_79943;
(statearr_79957[(7)] = inst_79938);

return statearr_79957;
})();
var statearr_79958_79972 = state_79943__$1;
(statearr_79958_79972[(2)] = inst_79928);

(statearr_79958_79972[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____0 = (function (){
var statearr_79959 = [null,null,null,null,null,null,null,null];
(statearr_79959[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__);

(statearr_79959[(1)] = (1));

return statearr_79959;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____1 = (function (state_79943){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_79943);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e79960){var ex__24301__auto__ = e79960;
var statearr_79961_79973 = state_79943;
(statearr_79961_79973[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_79943[(4)]))){
var statearr_79962_79974 = state_79943;
(statearr_79962_79974[(1)] = cljs.core.first((state_79943[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__79975 = state_79943;
state_79943 = G__79975;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__ = function(state_79943){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____1.call(this,state_79943);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_79963 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_79963[(6)] = c__24424__auto__);

return statearr_79963;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80005){
var state_val_80006 = (state_80005[(1)]);
if((state_val_80006 === (7))){
var state_80005__$1 = state_80005;
var statearr_80007_80026 = state_80005__$1;
(statearr_80007_80026[(2)] = arg);

(statearr_80007_80026[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (1))){
var state_80005__$1 = state_80005;
var statearr_80008_80027 = state_80005__$1;
(statearr_80008_80027[(2)] = null);

(statearr_80008_80027[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (4))){
var inst_79976 = (state_80005[(2)]);
var state_80005__$1 = state_80005;
var statearr_80009_80028 = state_80005__$1;
(statearr_80009_80028[(2)] = inst_79976);

(statearr_80009_80028[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (6))){
var state_80005__$1 = state_80005;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80005__$1,(9),arg);
} else {
if((state_val_80006 === (3))){
var inst_80003 = (state_80005[(2)]);
var state_80005__$1 = state_80005;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80005__$1,inst_80003);
} else {
if((state_val_80006 === (2))){
var _ = (function (){var statearr_80011 = state_80005;
(statearr_80011[(4)] = cljs.core.cons((5),(state_80005[(4)])));

return statearr_80011;
})();
var inst_79982 = fluree.db.util.async.channel_QMARK_(arg);
var state_80005__$1 = state_80005;
if(inst_79982){
var statearr_80012_80029 = state_80005__$1;
(statearr_80012_80029[(1)] = (6));

} else {
var statearr_80013_80030 = state_80005__$1;
(statearr_80013_80030[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (9))){
var inst_79985 = (state_80005[(2)]);
var inst_79986 = fluree.db.util.async.throw_err(inst_79985);
var state_80005__$1 = state_80005;
var statearr_80014_80031 = state_80005__$1;
(statearr_80014_80031[(2)] = inst_79986);

(statearr_80014_80031[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (5))){
var _ = (function (){var statearr_80015 = state_80005;
(statearr_80015[(4)] = cljs.core.rest((state_80005[(4)])));

return statearr_80015;
})();
var state_80005__$1 = state_80005;
var ex80010 = (state_80005__$1[(2)]);
var statearr_80016_80032 = state_80005__$1;
(statearr_80016_80032[(5)] = ex80010);


if((ex80010 instanceof Error)){
var statearr_80017_80033 = state_80005__$1;
(statearr_80017_80033[(1)] = (4));

(statearr_80017_80033[(5)] = null);

} else {
throw ex80010;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80006 === (8))){
var inst_79989 = (state_80005[(2)]);
var inst_79990 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_79989);
var inst_79991 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79992 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_79993 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_79994 = [inst_79989];
var inst_79995 = (new cljs.core.PersistentVector(null,1,(5),inst_79993,inst_79994,null));
var inst_79996 = ["empty?",inst_79995,inst_79990];
var inst_79997 = cljs.core.PersistentHashMap.fromArrays(inst_79992,inst_79996);
var inst_79998 = [inst_79997,(10)];
var inst_79999 = (new cljs.core.PersistentVector(null,2,(5),inst_79991,inst_79998,null));
var inst_80000 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_79999);
var _ = (function (){var statearr_80018 = state_80005;
(statearr_80018[(4)] = cljs.core.rest((state_80005[(4)])));

return statearr_80018;
})();
var state_80005__$1 = (function (){var statearr_80019 = state_80005;
(statearr_80019[(7)] = inst_80000);

return statearr_80019;
})();
var statearr_80020_80034 = state_80005__$1;
(statearr_80020_80034[(2)] = inst_79990);

(statearr_80020_80034[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_80021 = [null,null,null,null,null,null,null,null];
(statearr_80021[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__);

(statearr_80021[(1)] = (1));

return statearr_80021;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____1 = (function (state_80005){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80005);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80022){var ex__24301__auto__ = e80022;
var statearr_80023_80035 = state_80005;
(statearr_80023_80035[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80005[(4)]))){
var statearr_80024_80036 = state_80005;
(statearr_80024_80036[(1)] = cljs.core.first((state_80005[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80037 = state_80005;
state_80005 = G__80037;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__ = function(state_80005){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____1.call(this,state_80005);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80025 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80025[(6)] = c__24424__auto__);

return statearr_80025;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___80082 = arguments.length;
var i__4819__auto___80083 = (0);
while(true){
if((i__4819__auto___80083 < len__4818__auto___80082)){
args__4824__auto__.push((arguments[i__4819__auto___80083]));

var G__80084 = (i__4819__auto___80083 + (1));
i__4819__auto___80083 = G__80084;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80065){
var state_val_80066 = (state_80065[(1)]);
if((state_val_80066 === (1))){
var state_80065__$1 = state_80065;
var statearr_80067_80085 = state_80065__$1;
(statearr_80067_80085[(2)] = null);

(statearr_80067_80085[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80066 === (2))){
var _ = (function (){var statearr_80068 = state_80065;
(statearr_80068[(4)] = cljs.core.cons((5),(state_80065[(4)])));

return statearr_80068;
})();
var inst_80046 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_80065__$1 = state_80065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80065__$1,(6),inst_80046);
} else {
if((state_val_80066 === (3))){
var inst_80063 = (state_80065[(2)]);
var state_80065__$1 = state_80065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80065__$1,inst_80063);
} else {
if((state_val_80066 === (4))){
var inst_80040 = (state_80065[(2)]);
var state_80065__$1 = state_80065;
var statearr_80070_80086 = state_80065__$1;
(statearr_80070_80086[(2)] = inst_80040);

(statearr_80070_80086[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80066 === (5))){
var _ = (function (){var statearr_80071 = state_80065;
(statearr_80071[(4)] = cljs.core.rest((state_80065[(4)])));

return statearr_80071;
})();
var state_80065__$1 = state_80065;
var ex80069 = (state_80065__$1[(2)]);
var statearr_80072_80087 = state_80065__$1;
(statearr_80072_80087[(5)] = ex80069);


if((ex80069 instanceof Error)){
var statearr_80073_80088 = state_80065__$1;
(statearr_80073_80088[(1)] = (4));

(statearr_80073_80088[(5)] = null);

} else {
throw ex80069;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80066 === (6))){
var inst_80048 = (state_80065[(2)]);
var inst_80049 = fluree.db.util.async.throw_err(inst_80048);
var inst_80050 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_80049);
var inst_80051 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80052 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80054 = [inst_80049];
var inst_80055 = (new cljs.core.PersistentVector(null,1,(5),inst_80053,inst_80054,null));
var inst_80056 = ["str",inst_80055,inst_80050];
var inst_80057 = cljs.core.PersistentHashMap.fromArrays(inst_80052,inst_80056);
var inst_80058 = [inst_80057,(10)];
var inst_80059 = (new cljs.core.PersistentVector(null,2,(5),inst_80051,inst_80058,null));
var inst_80060 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80059);
var _ = (function (){var statearr_80074 = state_80065;
(statearr_80074[(4)] = cljs.core.rest((state_80065[(4)])));

return statearr_80074;
})();
var state_80065__$1 = (function (){var statearr_80075 = state_80065;
(statearr_80075[(7)] = inst_80060);

return statearr_80075;
})();
var statearr_80076_80089 = state_80065__$1;
(statearr_80076_80089[(2)] = inst_80050);

(statearr_80076_80089[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_80077 = [null,null,null,null,null,null,null,null];
(statearr_80077[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_80077[(1)] = (1));

return statearr_80077;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_80065){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80065);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80078){var ex__24301__auto__ = e80078;
var statearr_80079_80090 = state_80065;
(statearr_80079_80090[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80065[(4)]))){
var statearr_80080_80091 = state_80065;
(statearr_80080_80091[(1)] = cljs.core.first((state_80065[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80092 = state_80065;
state_80065 = G__80092;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_80065){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_80065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80081 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80081[(6)] = c__24424__auto__);

return statearr_80081;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq80038){
var G__80039 = cljs.core.first(seq80038);
var seq80038__$1 = cljs.core.next(seq80038);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80039,seq80038__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80118){
var state_val_80119 = (state_80118[(1)]);
if((state_val_80119 === (1))){
var state_80118__$1 = state_80118;
var statearr_80120_80135 = state_80118__$1;
(statearr_80120_80135[(2)] = null);

(statearr_80120_80135[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80119 === (2))){
var _ = (function (){var statearr_80121 = state_80118;
(statearr_80121[(4)] = cljs.core.cons((5),(state_80118[(4)])));

return statearr_80121;
})();
var inst_80099 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80118__$1,(6),inst_80099);
} else {
if((state_val_80119 === (3))){
var inst_80116 = (state_80118[(2)]);
var state_80118__$1 = state_80118;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80118__$1,inst_80116);
} else {
if((state_val_80119 === (4))){
var inst_80093 = (state_80118[(2)]);
var state_80118__$1 = state_80118;
var statearr_80123_80136 = state_80118__$1;
(statearr_80123_80136[(2)] = inst_80093);

(statearr_80123_80136[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80119 === (5))){
var _ = (function (){var statearr_80124 = state_80118;
(statearr_80124[(4)] = cljs.core.rest((state_80118[(4)])));

return statearr_80124;
})();
var state_80118__$1 = state_80118;
var ex80122 = (state_80118__$1[(2)]);
var statearr_80125_80137 = state_80118__$1;
(statearr_80125_80137[(5)] = ex80122);


if((ex80122 instanceof Error)){
var statearr_80126_80138 = state_80118__$1;
(statearr_80126_80138[(1)] = (4));

(statearr_80126_80138[(5)] = null);

} else {
throw ex80122;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80119 === (6))){
var inst_80101 = (state_80118[(2)]);
var inst_80102 = fluree.db.util.async.throw_err(inst_80101);
var inst_80103 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_80102);
var inst_80104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80105 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80107 = [inst_80102];
var inst_80108 = (new cljs.core.PersistentVector(null,1,(5),inst_80106,inst_80107,null));
var inst_80109 = ["subs",inst_80108,inst_80103];
var inst_80110 = cljs.core.PersistentHashMap.fromArrays(inst_80105,inst_80109);
var inst_80111 = [inst_80110,(30)];
var inst_80112 = (new cljs.core.PersistentVector(null,2,(5),inst_80104,inst_80111,null));
var inst_80113 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80112);
var _ = (function (){var statearr_80127 = state_80118;
(statearr_80127[(4)] = cljs.core.rest((state_80118[(4)])));

return statearr_80127;
})();
var state_80118__$1 = (function (){var statearr_80128 = state_80118;
(statearr_80128[(7)] = inst_80113);

return statearr_80128;
})();
var statearr_80129_80139 = state_80118__$1;
(statearr_80129_80139[(2)] = inst_80103);

(statearr_80129_80139[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____0 = (function (){
var statearr_80130 = [null,null,null,null,null,null,null,null];
(statearr_80130[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__);

(statearr_80130[(1)] = (1));

return statearr_80130;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____1 = (function (state_80118){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80118);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80131){var ex__24301__auto__ = e80131;
var statearr_80132_80140 = state_80118;
(statearr_80132_80140[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80118[(4)]))){
var statearr_80133_80141 = state_80118;
(statearr_80133_80141[(1)] = cljs.core.first((state_80118[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80142 = state_80118;
state_80118 = G__80142;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__ = function(state_80118){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____1.call(this,state_80118);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80134 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80134[(6)] = c__24424__auto__);

return statearr_80134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80172){
var state_val_80173 = (state_80172[(1)]);
if((state_val_80173 === (7))){
var state_80172__$1 = state_80172;
var statearr_80174_80193 = state_80172__$1;
(statearr_80174_80193[(2)] = str);

(statearr_80174_80193[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (1))){
var state_80172__$1 = state_80172;
var statearr_80175_80194 = state_80172__$1;
(statearr_80175_80194[(2)] = null);

(statearr_80175_80194[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (4))){
var inst_80143 = (state_80172[(2)]);
var state_80172__$1 = state_80172;
var statearr_80176_80195 = state_80172__$1;
(statearr_80176_80195[(2)] = inst_80143);

(statearr_80176_80195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (6))){
var state_80172__$1 = state_80172;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80172__$1,(9),str);
} else {
if((state_val_80173 === (3))){
var inst_80170 = (state_80172[(2)]);
var state_80172__$1 = state_80172;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80172__$1,inst_80170);
} else {
if((state_val_80173 === (2))){
var _ = (function (){var statearr_80178 = state_80172;
(statearr_80178[(4)] = cljs.core.cons((5),(state_80172[(4)])));

return statearr_80178;
})();
var inst_80149 = fluree.db.util.async.channel_QMARK_(str);
var state_80172__$1 = state_80172;
if(inst_80149){
var statearr_80179_80196 = state_80172__$1;
(statearr_80179_80196[(1)] = (6));

} else {
var statearr_80180_80197 = state_80172__$1;
(statearr_80180_80197[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (9))){
var inst_80152 = (state_80172[(2)]);
var inst_80153 = fluree.db.util.async.throw_err(inst_80152);
var state_80172__$1 = state_80172;
var statearr_80181_80198 = state_80172__$1;
(statearr_80181_80198[(2)] = inst_80153);

(statearr_80181_80198[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (5))){
var _ = (function (){var statearr_80182 = state_80172;
(statearr_80182[(4)] = cljs.core.rest((state_80172[(4)])));

return statearr_80182;
})();
var state_80172__$1 = state_80172;
var ex80177 = (state_80172__$1[(2)]);
var statearr_80183_80199 = state_80172__$1;
(statearr_80183_80199[(5)] = ex80177);


if((ex80177 instanceof Error)){
var statearr_80184_80200 = state_80172__$1;
(statearr_80184_80200[(1)] = (4));

(statearr_80184_80200[(5)] = null);

} else {
throw ex80177;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80173 === (8))){
var inst_80156 = (state_80172[(2)]);
var inst_80157 = fluree.db.dbfunctions.internal.lower_case(inst_80156);
var inst_80158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80159 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80160 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80161 = [inst_80156];
var inst_80162 = (new cljs.core.PersistentVector(null,1,(5),inst_80160,inst_80161,null));
var inst_80163 = ["lower-case",inst_80162,inst_80157];
var inst_80164 = cljs.core.PersistentHashMap.fromArrays(inst_80159,inst_80163);
var inst_80165 = [inst_80164,(10)];
var inst_80166 = (new cljs.core.PersistentVector(null,2,(5),inst_80158,inst_80165,null));
var inst_80167 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80166);
var _ = (function (){var statearr_80185 = state_80172;
(statearr_80185[(4)] = cljs.core.rest((state_80172[(4)])));

return statearr_80185;
})();
var state_80172__$1 = (function (){var statearr_80186 = state_80172;
(statearr_80186[(7)] = inst_80167);

return statearr_80186;
})();
var statearr_80187_80201 = state_80172__$1;
(statearr_80187_80201[(2)] = inst_80157);

(statearr_80187_80201[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____0 = (function (){
var statearr_80188 = [null,null,null,null,null,null,null,null];
(statearr_80188[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__);

(statearr_80188[(1)] = (1));

return statearr_80188;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____1 = (function (state_80172){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80172);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80189){var ex__24301__auto__ = e80189;
var statearr_80190_80202 = state_80172;
(statearr_80190_80202[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80172[(4)]))){
var statearr_80191_80203 = state_80172;
(statearr_80191_80203[(1)] = cljs.core.first((state_80172[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80204 = state_80172;
state_80172 = G__80204;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__ = function(state_80172){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____1.call(this,state_80172);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80192 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80192[(6)] = c__24424__auto__);

return statearr_80192;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80234){
var state_val_80235 = (state_80234[(1)]);
if((state_val_80235 === (7))){
var state_80234__$1 = state_80234;
var statearr_80236_80255 = state_80234__$1;
(statearr_80236_80255[(2)] = str);

(statearr_80236_80255[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (1))){
var state_80234__$1 = state_80234;
var statearr_80237_80256 = state_80234__$1;
(statearr_80237_80256[(2)] = null);

(statearr_80237_80256[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (4))){
var inst_80205 = (state_80234[(2)]);
var state_80234__$1 = state_80234;
var statearr_80238_80257 = state_80234__$1;
(statearr_80238_80257[(2)] = inst_80205);

(statearr_80238_80257[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (6))){
var state_80234__$1 = state_80234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80234__$1,(9),str);
} else {
if((state_val_80235 === (3))){
var inst_80232 = (state_80234[(2)]);
var state_80234__$1 = state_80234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80234__$1,inst_80232);
} else {
if((state_val_80235 === (2))){
var _ = (function (){var statearr_80240 = state_80234;
(statearr_80240[(4)] = cljs.core.cons((5),(state_80234[(4)])));

return statearr_80240;
})();
var inst_80211 = fluree.db.util.async.channel_QMARK_(str);
var state_80234__$1 = state_80234;
if(inst_80211){
var statearr_80241_80258 = state_80234__$1;
(statearr_80241_80258[(1)] = (6));

} else {
var statearr_80242_80259 = state_80234__$1;
(statearr_80242_80259[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (9))){
var inst_80214 = (state_80234[(2)]);
var inst_80215 = fluree.db.util.async.throw_err(inst_80214);
var state_80234__$1 = state_80234;
var statearr_80243_80260 = state_80234__$1;
(statearr_80243_80260[(2)] = inst_80215);

(statearr_80243_80260[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (5))){
var _ = (function (){var statearr_80244 = state_80234;
(statearr_80244[(4)] = cljs.core.rest((state_80234[(4)])));

return statearr_80244;
})();
var state_80234__$1 = state_80234;
var ex80239 = (state_80234__$1[(2)]);
var statearr_80245_80261 = state_80234__$1;
(statearr_80245_80261[(5)] = ex80239);


if((ex80239 instanceof Error)){
var statearr_80246_80262 = state_80234__$1;
(statearr_80246_80262[(1)] = (4));

(statearr_80246_80262[(5)] = null);

} else {
throw ex80239;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80235 === (8))){
var inst_80218 = (state_80234[(2)]);
var inst_80219 = fluree.db.dbfunctions.internal.upper_case(inst_80218);
var inst_80220 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80221 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80222 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80223 = [inst_80218];
var inst_80224 = (new cljs.core.PersistentVector(null,1,(5),inst_80222,inst_80223,null));
var inst_80225 = ["upper-case",inst_80224,inst_80219];
var inst_80226 = cljs.core.PersistentHashMap.fromArrays(inst_80221,inst_80225);
var inst_80227 = [inst_80226,(10)];
var inst_80228 = (new cljs.core.PersistentVector(null,2,(5),inst_80220,inst_80227,null));
var inst_80229 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80228);
var _ = (function (){var statearr_80247 = state_80234;
(statearr_80247[(4)] = cljs.core.rest((state_80234[(4)])));

return statearr_80247;
})();
var state_80234__$1 = (function (){var statearr_80248 = state_80234;
(statearr_80248[(7)] = inst_80229);

return statearr_80248;
})();
var statearr_80249_80263 = state_80234__$1;
(statearr_80249_80263[(2)] = inst_80219);

(statearr_80249_80263[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____0 = (function (){
var statearr_80250 = [null,null,null,null,null,null,null,null];
(statearr_80250[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__);

(statearr_80250[(1)] = (1));

return statearr_80250;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____1 = (function (state_80234){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80234);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80251){var ex__24301__auto__ = e80251;
var statearr_80252_80264 = state_80234;
(statearr_80252_80264[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80234[(4)]))){
var statearr_80253_80265 = state_80234;
(statearr_80253_80265[(1)] = cljs.core.first((state_80234[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80266 = state_80234;
state_80234 = G__80266;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__ = function(state_80234){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____1.call(this,state_80234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80254 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80254[(6)] = c__24424__auto__);

return statearr_80254;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__80268 = arguments.length;
switch (G__80268) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80296){
var state_val_80297 = (state_80296[(1)]);
if((state_val_80297 === (1))){
var state_80296__$1 = state_80296;
var statearr_80298_80314 = state_80296__$1;
(statearr_80298_80314[(2)] = null);

(statearr_80298_80314[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80297 === (2))){
var _ = (function (){var statearr_80299 = state_80296;
(statearr_80299[(4)] = cljs.core.cons((5),(state_80296[(4)])));

return statearr_80299;
})();
var inst_80278 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_80296__$1 = state_80296;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80296__$1,(6),inst_80278);
} else {
if((state_val_80297 === (3))){
var inst_80294 = (state_80296[(2)]);
var state_80296__$1 = state_80296;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80296__$1,inst_80294);
} else {
if((state_val_80297 === (4))){
var inst_80269 = (state_80296[(2)]);
var state_80296__$1 = state_80296;
var statearr_80301_80315 = state_80296__$1;
(statearr_80301_80315[(2)] = inst_80269);

(statearr_80301_80315[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80297 === (5))){
var _ = (function (){var statearr_80302 = state_80296;
(statearr_80302[(4)] = cljs.core.rest((state_80296[(4)])));

return statearr_80302;
})();
var state_80296__$1 = state_80296;
var ex80300 = (state_80296__$1[(2)]);
var statearr_80303_80316 = state_80296__$1;
(statearr_80303_80316[(5)] = ex80300);


if((ex80300 instanceof Error)){
var statearr_80304_80317 = state_80296__$1;
(statearr_80304_80317[(1)] = (4));

(statearr_80304_80317[(5)] = null);

} else {
throw ex80300;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80297 === (6))){
var inst_80280 = (state_80296[(2)]);
var inst_80281 = fluree.db.util.async.throw_err(inst_80280);
var inst_80282 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80281,(0),null);
var inst_80283 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80281,(1),null);
var inst_80284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80285 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80286 = ["?s","?ctx",inst_80282];
var inst_80287 = cljs.core.PersistentHashMap.fromArrays(inst_80285,inst_80286);
var inst_80288 = ((10) + inst_80283);
var inst_80289 = [inst_80287,inst_80288];
var inst_80290 = (new cljs.core.PersistentVector(null,2,(5),inst_80284,inst_80289,null));
var inst_80291 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80290);
var _ = (function (){var statearr_80305 = state_80296;
(statearr_80305[(4)] = cljs.core.rest((state_80296[(4)])));

return statearr_80305;
})();
var state_80296__$1 = (function (){var statearr_80306 = state_80296;
(statearr_80306[(7)] = inst_80291);

return statearr_80306;
})();
var statearr_80307_80318 = state_80296__$1;
(statearr_80307_80318[(2)] = inst_80282);

(statearr_80307_80318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_80308 = [null,null,null,null,null,null,null,null];
(statearr_80308[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_80308[(1)] = (1));

return statearr_80308;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_80296){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80296);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80309){var ex__24301__auto__ = e80309;
var statearr_80310_80319 = state_80296;
(statearr_80310_80319[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80296[(4)]))){
var statearr_80311_80320 = state_80296;
(statearr_80311_80320[(1)] = cljs.core.first((state_80296[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80321 = state_80296;
state_80296 = G__80321;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_80296){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_80296);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80312 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80312[(6)] = c__24424__auto__);

return statearr_80312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__80323 = arguments.length;
switch (G__80323) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80361){
var state_val_80362 = (state_80361[(1)]);
if((state_val_80362 === (7))){
var inst_80354 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_80361__$1 = state_80361;
var statearr_80363_80383 = state_80361__$1;
(statearr_80363_80383[(2)] = inst_80354);

(statearr_80363_80383[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (1))){
var state_80361__$1 = state_80361;
var statearr_80364_80384 = state_80361__$1;
(statearr_80364_80384[(2)] = null);

(statearr_80364_80384[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (4))){
var inst_80324 = (state_80361[(2)]);
var state_80361__$1 = state_80361;
var statearr_80365_80385 = state_80361__$1;
(statearr_80365_80385[(2)] = inst_80324);

(statearr_80365_80385[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (6))){
var inst_80335 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_80361__$1 = state_80361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80361__$1,(10),inst_80335);
} else {
if((state_val_80362 === (3))){
var inst_80359 = (state_80361[(2)]);
var state_80361__$1 = state_80361;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80361__$1,inst_80359);
} else {
if((state_val_80362 === (2))){
var _ = (function (){var statearr_80367 = state_80361;
(statearr_80367[(4)] = cljs.core.cons((5),(state_80361[(4)])));

return statearr_80367;
})();
var inst_80330 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_80361__$1 = state_80361;
if(cljs.core.truth_(inst_80330)){
var statearr_80368_80386 = state_80361__$1;
(statearr_80368_80386[(1)] = (6));

} else {
var statearr_80369_80387 = state_80361__$1;
(statearr_80369_80387[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (9))){
var inst_80341 = (state_80361[(2)]);
var inst_80342 = fluree.db.util.async.throw_err(inst_80341);
var inst_80343 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80342,(0),null);
var inst_80344 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80342,(1),null);
var inst_80345 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80346 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80347 = ["?p","?ctx",inst_80343];
var inst_80348 = cljs.core.PersistentHashMap.fromArrays(inst_80346,inst_80347);
var inst_80349 = ((10) + inst_80344);
var inst_80350 = [inst_80348,inst_80349];
var inst_80351 = (new cljs.core.PersistentVector(null,2,(5),inst_80345,inst_80350,null));
var inst_80352 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80351);
var state_80361__$1 = (function (){var statearr_80370 = state_80361;
(statearr_80370[(7)] = inst_80352);

return statearr_80370;
})();
var statearr_80371_80388 = state_80361__$1;
(statearr_80371_80388[(2)] = inst_80343);

(statearr_80371_80388[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (5))){
var _ = (function (){var statearr_80372 = state_80361;
(statearr_80372[(4)] = cljs.core.rest((state_80361[(4)])));

return statearr_80372;
})();
var state_80361__$1 = state_80361;
var ex80366 = (state_80361__$1[(2)]);
var statearr_80373_80389 = state_80361__$1;
(statearr_80373_80389[(5)] = ex80366);


if((ex80366 instanceof Error)){
var statearr_80374_80390 = state_80361__$1;
(statearr_80374_80390[(1)] = (4));

(statearr_80374_80390[(5)] = null);

} else {
throw ex80366;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80362 === (10))){
var inst_80337 = (state_80361[(2)]);
var inst_80338 = fluree.db.util.async.throw_err(inst_80337);
var inst_80339 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_80338);
var state_80361__$1 = state_80361;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80361__$1,(9),inst_80339);
} else {
if((state_val_80362 === (8))){
var inst_80356 = (state_80361[(2)]);
var _ = (function (){var statearr_80375 = state_80361;
(statearr_80375[(4)] = cljs.core.rest((state_80361[(4)])));

return statearr_80375;
})();
var state_80361__$1 = state_80361;
var statearr_80376_80391 = state_80361__$1;
(statearr_80376_80391[(2)] = inst_80356);

(statearr_80376_80391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_80377 = [null,null,null,null,null,null,null,null];
(statearr_80377[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_80377[(1)] = (1));

return statearr_80377;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_80361){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80361);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80378){var ex__24301__auto__ = e80378;
var statearr_80379_80392 = state_80361;
(statearr_80379_80392[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80361[(4)]))){
var statearr_80380_80393 = state_80361;
(statearr_80380_80393[(1)] = cljs.core.first((state_80361[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80394 = state_80361;
state_80361 = G__80394;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_80361){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_80361);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80381 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80381[(6)] = c__24424__auto__);

return statearr_80381;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___80443 = arguments.length;
var i__4819__auto___80444 = (0);
while(true){
if((i__4819__auto___80444 < len__4818__auto___80443)){
args__4824__auto__.push((arguments[i__4819__auto___80444]));

var G__80445 = (i__4819__auto___80444 + (1));
i__4819__auto___80444 = G__80445;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80426){
var state_val_80427 = (state_80426[(1)]);
if((state_val_80427 === (1))){
var state_80426__$1 = state_80426;
var statearr_80428_80446 = state_80426__$1;
(statearr_80428_80446[(2)] = null);

(statearr_80428_80446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80427 === (2))){
var _ = (function (){var statearr_80429 = state_80426;
(statearr_80429[(4)] = cljs.core.cons((5),(state_80426[(4)])));

return statearr_80429;
})();
var inst_80403 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_80426__$1 = state_80426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80426__$1,(6),inst_80403);
} else {
if((state_val_80427 === (3))){
var inst_80424 = (state_80426[(2)]);
var state_80426__$1 = state_80426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80426__$1,inst_80424);
} else {
if((state_val_80427 === (4))){
var inst_80397 = (state_80426[(2)]);
var state_80426__$1 = state_80426;
var statearr_80431_80447 = state_80426__$1;
(statearr_80431_80447[(2)] = inst_80397);

(statearr_80431_80447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80427 === (5))){
var _ = (function (){var statearr_80432 = state_80426;
(statearr_80432[(4)] = cljs.core.rest((state_80426[(4)])));

return statearr_80432;
})();
var state_80426__$1 = state_80426;
var ex80430 = (state_80426__$1[(2)]);
var statearr_80433_80448 = state_80426__$1;
(statearr_80433_80448[(5)] = ex80430);


if((ex80430 instanceof Error)){
var statearr_80434_80449 = state_80426__$1;
(statearr_80434_80449[(1)] = (4));

(statearr_80434_80449[(5)] = null);

} else {
throw ex80430;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80427 === (6))){
var inst_80405 = (state_80426[(2)]);
var inst_80406 = fluree.db.util.async.throw_err(inst_80405);
var inst_80407 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_80406);
var inst_80408 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80409 = [inst_80406];
var inst_80410 = (new cljs.core.PersistentVector(null,1,(5),inst_80408,inst_80409,null));
var inst_80411 = cljs.core.count(inst_80410);
var inst_80412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80413 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80415 = [inst_80406];
var inst_80416 = (new cljs.core.PersistentVector(null,1,(5),inst_80414,inst_80415,null));
var inst_80417 = ["and",inst_80416,inst_80407];
var inst_80418 = cljs.core.PersistentHashMap.fromArrays(inst_80413,inst_80417);
var inst_80419 = [inst_80418,inst_80411];
var inst_80420 = (new cljs.core.PersistentVector(null,2,(5),inst_80412,inst_80419,null));
var inst_80421 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80420);
var _ = (function (){var statearr_80435 = state_80426;
(statearr_80435[(4)] = cljs.core.rest((state_80426[(4)])));

return statearr_80435;
})();
var state_80426__$1 = (function (){var statearr_80436 = state_80426;
(statearr_80436[(7)] = inst_80421);

return statearr_80436;
})();
var statearr_80437_80450 = state_80426__$1;
(statearr_80437_80450[(2)] = inst_80407);

(statearr_80437_80450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_80438 = [null,null,null,null,null,null,null,null];
(statearr_80438[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_80438[(1)] = (1));

return statearr_80438;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_80426){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80426);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80439){var ex__24301__auto__ = e80439;
var statearr_80440_80451 = state_80426;
(statearr_80440_80451[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80426[(4)]))){
var statearr_80441_80452 = state_80426;
(statearr_80441_80452[(1)] = cljs.core.first((state_80426[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80453 = state_80426;
state_80426 = G__80453;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_80426){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_80426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80442 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80442[(6)] = c__24424__auto__);

return statearr_80442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq80395){
var G__80396 = cljs.core.first(seq80395);
var seq80395__$1 = cljs.core.next(seq80395);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80396,seq80395__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___80502 = arguments.length;
var i__4819__auto___80503 = (0);
while(true){
if((i__4819__auto___80503 < len__4818__auto___80502)){
args__4824__auto__.push((arguments[i__4819__auto___80503]));

var G__80504 = (i__4819__auto___80503 + (1));
i__4819__auto___80503 = G__80504;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80485){
var state_val_80486 = (state_80485[(1)]);
if((state_val_80486 === (1))){
var state_80485__$1 = state_80485;
var statearr_80487_80505 = state_80485__$1;
(statearr_80487_80505[(2)] = null);

(statearr_80487_80505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80486 === (2))){
var _ = (function (){var statearr_80488 = state_80485;
(statearr_80488[(4)] = cljs.core.cons((5),(state_80485[(4)])));

return statearr_80488;
})();
var inst_80462 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_80485__$1 = state_80485;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80485__$1,(6),inst_80462);
} else {
if((state_val_80486 === (3))){
var inst_80483 = (state_80485[(2)]);
var state_80485__$1 = state_80485;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80485__$1,inst_80483);
} else {
if((state_val_80486 === (4))){
var inst_80456 = (state_80485[(2)]);
var state_80485__$1 = state_80485;
var statearr_80490_80506 = state_80485__$1;
(statearr_80490_80506[(2)] = inst_80456);

(statearr_80490_80506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80486 === (5))){
var _ = (function (){var statearr_80491 = state_80485;
(statearr_80491[(4)] = cljs.core.rest((state_80485[(4)])));

return statearr_80491;
})();
var state_80485__$1 = state_80485;
var ex80489 = (state_80485__$1[(2)]);
var statearr_80492_80507 = state_80485__$1;
(statearr_80492_80507[(5)] = ex80489);


if((ex80489 instanceof Error)){
var statearr_80493_80508 = state_80485__$1;
(statearr_80493_80508[(1)] = (4));

(statearr_80493_80508[(5)] = null);

} else {
throw ex80489;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80486 === (6))){
var inst_80464 = (state_80485[(2)]);
var inst_80465 = fluree.db.util.async.throw_err(inst_80464);
var inst_80466 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_80465);
var inst_80467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80468 = [inst_80465];
var inst_80469 = (new cljs.core.PersistentVector(null,1,(5),inst_80467,inst_80468,null));
var inst_80470 = cljs.core.count(inst_80469);
var inst_80471 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80472 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80473 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80474 = [inst_80465];
var inst_80475 = (new cljs.core.PersistentVector(null,1,(5),inst_80473,inst_80474,null));
var inst_80476 = ["or",inst_80475,inst_80466];
var inst_80477 = cljs.core.PersistentHashMap.fromArrays(inst_80472,inst_80476);
var inst_80478 = [inst_80477,inst_80470];
var inst_80479 = (new cljs.core.PersistentVector(null,2,(5),inst_80471,inst_80478,null));
var inst_80480 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80479);
var _ = (function (){var statearr_80494 = state_80485;
(statearr_80494[(4)] = cljs.core.rest((state_80485[(4)])));

return statearr_80494;
})();
var state_80485__$1 = (function (){var statearr_80495 = state_80485;
(statearr_80495[(7)] = inst_80480);

return statearr_80495;
})();
var statearr_80496_80509 = state_80485__$1;
(statearr_80496_80509[(2)] = inst_80466);

(statearr_80496_80509[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_80497 = [null,null,null,null,null,null,null,null];
(statearr_80497[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_80497[(1)] = (1));

return statearr_80497;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_80485){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80485);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80498){var ex__24301__auto__ = e80498;
var statearr_80499_80510 = state_80485;
(statearr_80499_80510[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80485[(4)]))){
var statearr_80500_80511 = state_80485;
(statearr_80500_80511[(1)] = cljs.core.first((state_80485[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80512 = state_80485;
state_80485 = G__80512;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_80485){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_80485);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80501 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80501[(6)] = c__24424__auto__);

return statearr_80501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq80454){
var G__80455 = cljs.core.first(seq80454);
var seq80454__$1 = cljs.core.next(seq80454);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__80455,seq80454__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80550){
var state_val_80551 = (state_80550[(1)]);
if((state_val_80551 === (7))){
var inst_80526 = fluree.db.util.async.channel_QMARK_(coll);
var state_80550__$1 = state_80550;
if(inst_80526){
var statearr_80552_80575 = state_80550__$1;
(statearr_80552_80575[(1)] = (10));

} else {
var statearr_80553_80576 = state_80550__$1;
(statearr_80553_80576[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (1))){
var state_80550__$1 = state_80550;
var statearr_80554_80577 = state_80550__$1;
(statearr_80554_80577[(2)] = null);

(statearr_80554_80577[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (4))){
var inst_80513 = (state_80550[(2)]);
var state_80550__$1 = state_80550;
var statearr_80555_80578 = state_80550__$1;
(statearr_80555_80578[(2)] = inst_80513);

(statearr_80555_80578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (13))){
var inst_80529 = (state_80550[(2)]);
var inst_80530 = fluree.db.util.async.throw_err(inst_80529);
var state_80550__$1 = state_80550;
var statearr_80556_80579 = state_80550__$1;
(statearr_80556_80579[(2)] = inst_80530);

(statearr_80556_80579[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (6))){
var inst_80521 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_80550__$1 = state_80550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80550__$1,(9),inst_80521);
} else {
if((state_val_80551 === (3))){
var inst_80548 = (state_80550[(2)]);
var state_80550__$1 = state_80550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80550__$1,inst_80548);
} else {
if((state_val_80551 === (12))){
var inst_80533 = (state_80550[(2)]);
var state_80550__$1 = state_80550;
var statearr_80557_80580 = state_80550__$1;
(statearr_80557_80580[(2)] = inst_80533);

(statearr_80557_80580[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (2))){
var _ = (function (){var statearr_80558 = state_80550;
(statearr_80558[(4)] = cljs.core.cons((5),(state_80550[(4)])));

return statearr_80558;
})();
var inst_80519 = cljs.core.vector_QMARK_(coll);
var state_80550__$1 = state_80550;
if(inst_80519){
var statearr_80559_80581 = state_80550__$1;
(statearr_80559_80581[(1)] = (6));

} else {
var statearr_80560_80582 = state_80550__$1;
(statearr_80560_80582[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (11))){
var state_80550__$1 = state_80550;
var statearr_80562_80583 = state_80550__$1;
(statearr_80562_80583[(2)] = coll);

(statearr_80562_80583[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (9))){
var inst_80523 = (state_80550[(2)]);
var inst_80524 = fluree.db.util.async.throw_err(inst_80523);
var state_80550__$1 = state_80550;
var statearr_80563_80584 = state_80550__$1;
(statearr_80563_80584[(2)] = inst_80524);

(statearr_80563_80584[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (5))){
var _ = (function (){var statearr_80564 = state_80550;
(statearr_80564[(4)] = cljs.core.rest((state_80550[(4)])));

return statearr_80564;
})();
var state_80550__$1 = state_80550;
var ex80561 = (state_80550__$1[(2)]);
var statearr_80565_80585 = state_80550__$1;
(statearr_80565_80585[(5)] = ex80561);


if((ex80561 instanceof Error)){
var statearr_80566_80586 = state_80550__$1;
(statearr_80566_80586[(1)] = (4));

(statearr_80566_80586[(5)] = null);

} else {
throw ex80561;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80551 === (10))){
var state_80550__$1 = state_80550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80550__$1,(13),coll);
} else {
if((state_val_80551 === (8))){
var inst_80535 = (state_80550[(2)]);
var inst_80536 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_80535);
var inst_80537 = cljs.core.count(inst_80536);
var inst_80538 = ((9) + inst_80537);
var inst_80539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80540 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80541 = ["count",inst_80535,inst_80537];
var inst_80542 = cljs.core.PersistentHashMap.fromArrays(inst_80540,inst_80541);
var inst_80543 = [inst_80542,inst_80538];
var inst_80544 = (new cljs.core.PersistentVector(null,2,(5),inst_80539,inst_80543,null));
var inst_80545 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80544);
var _ = (function (){var statearr_80567 = state_80550;
(statearr_80567[(4)] = cljs.core.rest((state_80550[(4)])));

return statearr_80567;
})();
var state_80550__$1 = (function (){var statearr_80568 = state_80550;
(statearr_80568[(7)] = inst_80545);

return statearr_80568;
})();
var statearr_80569_80587 = state_80550__$1;
(statearr_80569_80587[(2)] = inst_80537);

(statearr_80569_80587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____0 = (function (){
var statearr_80570 = [null,null,null,null,null,null,null,null];
(statearr_80570[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__);

(statearr_80570[(1)] = (1));

return statearr_80570;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____1 = (function (state_80550){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80550);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80571){var ex__24301__auto__ = e80571;
var statearr_80572_80588 = state_80550;
(statearr_80572_80588[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80550[(4)]))){
var statearr_80573_80589 = state_80550;
(statearr_80573_80589[(1)] = cljs.core.first((state_80550[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80590 = state_80550;
state_80550 = G__80590;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__ = function(state_80550){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____1.call(this,state_80550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80574 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80574[(6)] = c__24424__auto__);

return statearr_80574;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80640){
var state_val_80641 = (state_80640[(1)]);
if((state_val_80641 === (7))){
var state_80640__$1 = state_80640;
var statearr_80642_80675 = state_80640__$1;
(statearr_80642_80675[(2)] = subject);

(statearr_80642_80675[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (1))){
var state_80640__$1 = state_80640;
var statearr_80643_80676 = state_80640__$1;
(statearr_80643_80676[(2)] = null);

(statearr_80643_80676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (4))){
var inst_80591 = (state_80640[(2)]);
var state_80640__$1 = state_80640;
var statearr_80644_80677 = state_80640__$1;
(statearr_80644_80677[(2)] = inst_80591);

(statearr_80644_80677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (15))){
var inst_80604 = (state_80640[(7)]);
var state_80640__$1 = state_80640;
var statearr_80645_80678 = state_80640__$1;
(statearr_80645_80678[(2)] = inst_80604);

(statearr_80645_80678[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (13))){
var inst_80608 = (state_80640[(2)]);
var inst_80609 = fluree.db.util.async.throw_err(inst_80608);
var state_80640__$1 = state_80640;
var statearr_80646_80679 = state_80640__$1;
(statearr_80646_80679[(2)] = inst_80609);

(statearr_80646_80679[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (6))){
var state_80640__$1 = state_80640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80640__$1,(9),subject);
} else {
if((state_val_80641 === (17))){
var inst_80604 = (state_80640[(7)]);
var inst_80618 = cljs.core.first(inst_80604);
var state_80640__$1 = state_80640;
var statearr_80647_80680 = state_80640__$1;
(statearr_80647_80680[(2)] = inst_80618);

(statearr_80647_80680[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (3))){
var inst_80638 = (state_80640[(2)]);
var state_80640__$1 = state_80640;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80640__$1,inst_80638);
} else {
if((state_val_80641 === (12))){
var inst_80604 = (state_80640[(7)]);
var inst_80612 = (state_80640[(2)]);
var inst_80613 = cljs.core.vector_QMARK_(inst_80604);
var state_80640__$1 = (function (){var statearr_80648 = state_80640;
(statearr_80648[(8)] = inst_80612);

return statearr_80648;
})();
if(inst_80613){
var statearr_80649_80681 = state_80640__$1;
(statearr_80649_80681[(1)] = (14));

} else {
var statearr_80650_80682 = state_80640__$1;
(statearr_80650_80682[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (2))){
var _ = (function (){var statearr_80651 = state_80640;
(statearr_80651[(4)] = cljs.core.cons((5),(state_80640[(4)])));

return statearr_80651;
})();
var inst_80597 = fluree.db.util.async.channel_QMARK_(subject);
var state_80640__$1 = state_80640;
if(inst_80597){
var statearr_80652_80683 = state_80640__$1;
(statearr_80652_80683[(1)] = (6));

} else {
var statearr_80653_80684 = state_80640__$1;
(statearr_80653_80684[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (19))){
var inst_80621 = (state_80640[(2)]);
var state_80640__$1 = state_80640;
var statearr_80654_80685 = state_80640__$1;
(statearr_80654_80685[(2)] = inst_80621);

(statearr_80654_80685[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (11))){
var state_80640__$1 = state_80640;
var statearr_80656_80686 = state_80640__$1;
(statearr_80656_80686[(2)] = pred);

(statearr_80656_80686[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (9))){
var inst_80600 = (state_80640[(2)]);
var inst_80601 = fluree.db.util.async.throw_err(inst_80600);
var state_80640__$1 = state_80640;
var statearr_80657_80687 = state_80640__$1;
(statearr_80657_80687[(2)] = inst_80601);

(statearr_80657_80687[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (5))){
var _ = (function (){var statearr_80658 = state_80640;
(statearr_80658[(4)] = cljs.core.rest((state_80640[(4)])));

return statearr_80658;
})();
var state_80640__$1 = state_80640;
var ex80655 = (state_80640__$1[(2)]);
var statearr_80659_80688 = state_80640__$1;
(statearr_80659_80688[(5)] = ex80655);


if((ex80655 instanceof Error)){
var statearr_80660_80689 = state_80640__$1;
(statearr_80660_80689[(1)] = (4));

(statearr_80660_80689[(5)] = null);

} else {
throw ex80655;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (14))){
var inst_80604 = (state_80640[(7)]);
var inst_80615 = cljs.core.count(inst_80604);
var inst_80616 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_80615);
var state_80640__$1 = state_80640;
if(inst_80616){
var statearr_80661_80690 = state_80640__$1;
(statearr_80661_80690[(1)] = (17));

} else {
var statearr_80662_80691 = state_80640__$1;
(statearr_80662_80691[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (16))){
var inst_80612 = (state_80640[(8)]);
var inst_80604 = (state_80640[(7)]);
var inst_80624 = (state_80640[(2)]);
var inst_80625 = fluree.db.dbfunctions.internal.get(inst_80624,inst_80612);
var inst_80626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80627 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80628 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80629 = [inst_80604,inst_80612];
var inst_80630 = (new cljs.core.PersistentVector(null,2,(5),inst_80628,inst_80629,null));
var inst_80631 = ["get",inst_80630,inst_80625];
var inst_80632 = cljs.core.PersistentHashMap.fromArrays(inst_80627,inst_80631);
var inst_80633 = [inst_80632,(10)];
var inst_80634 = (new cljs.core.PersistentVector(null,2,(5),inst_80626,inst_80633,null));
var inst_80635 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80634);
var _ = (function (){var statearr_80663 = state_80640;
(statearr_80663[(4)] = cljs.core.rest((state_80640[(4)])));

return statearr_80663;
})();
var state_80640__$1 = (function (){var statearr_80664 = state_80640;
(statearr_80664[(9)] = inst_80635);

return statearr_80664;
})();
var statearr_80665_80692 = state_80640__$1;
(statearr_80665_80692[(2)] = inst_80625);

(statearr_80665_80692[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (10))){
var state_80640__$1 = state_80640;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80640__$1,(13),pred);
} else {
if((state_val_80641 === (18))){
var inst_80604 = (state_80640[(7)]);
var state_80640__$1 = state_80640;
var statearr_80666_80693 = state_80640__$1;
(statearr_80666_80693[(2)] = inst_80604);

(statearr_80666_80693[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80641 === (8))){
var inst_80604 = (state_80640[(2)]);
var inst_80605 = fluree.db.util.async.channel_QMARK_(pred);
var state_80640__$1 = (function (){var statearr_80667 = state_80640;
(statearr_80667[(7)] = inst_80604);

return statearr_80667;
})();
if(inst_80605){
var statearr_80668_80694 = state_80640__$1;
(statearr_80668_80694[(1)] = (10));

} else {
var statearr_80669_80695 = state_80640__$1;
(statearr_80669_80695[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____0 = (function (){
var statearr_80670 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80670[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__);

(statearr_80670[(1)] = (1));

return statearr_80670;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____1 = (function (state_80640){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80640);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80671){var ex__24301__auto__ = e80671;
var statearr_80672_80696 = state_80640;
(statearr_80672_80696[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80640[(4)]))){
var statearr_80673_80697 = state_80640;
(statearr_80673_80697[(1)] = cljs.core.first((state_80640[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80698 = state_80640;
state_80640 = G__80698;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__ = function(state_80640){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____1.call(this,state_80640);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80674 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80674[(6)] = c__24424__auto__);

return statearr_80674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80737){
var state_val_80738 = (state_80737[(1)]);
if((state_val_80738 === (7))){
var inst_80705 = (state_80737[(7)]);
var state_80737__$1 = state_80737;
var statearr_80739_80763 = state_80737__$1;
(statearr_80739_80763[(2)] = inst_80705);

(statearr_80739_80763[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (1))){
var state_80737__$1 = state_80737;
var statearr_80740_80764 = state_80737__$1;
(statearr_80740_80764[(2)] = null);

(statearr_80740_80764[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (4))){
var inst_80699 = (state_80737[(2)]);
var state_80737__$1 = state_80737;
var statearr_80741_80765 = state_80737__$1;
(statearr_80741_80765[(2)] = inst_80699);

(statearr_80741_80765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (6))){
var inst_80707 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_80737__$1 = state_80737;
var statearr_80742_80766 = state_80737__$1;
(statearr_80742_80766[(2)] = inst_80707);

(statearr_80742_80766[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (3))){
var inst_80735 = (state_80737[(2)]);
var state_80737__$1 = state_80737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80737__$1,inst_80735);
} else {
if((state_val_80738 === (12))){
var inst_80717 = (state_80737[(2)]);
var inst_80718 = fluree.db.util.async.throw_err(inst_80717);
var inst_80719 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80718,(0),null);
var inst_80720 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_80718,(1),null);
var inst_80721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80722 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80723 = ["?pO","?ctx",inst_80719];
var inst_80724 = cljs.core.PersistentHashMap.fromArrays(inst_80722,inst_80723);
var inst_80725 = ((10) + inst_80720);
var inst_80726 = [inst_80724,inst_80725];
var inst_80727 = (new cljs.core.PersistentVector(null,2,(5),inst_80721,inst_80726,null));
var inst_80728 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80727);
var state_80737__$1 = (function (){var statearr_80743 = state_80737;
(statearr_80743[(8)] = inst_80728);

return statearr_80743;
})();
var statearr_80744_80767 = state_80737__$1;
(statearr_80744_80767[(2)] = inst_80719);

(statearr_80744_80767[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (2))){
var inst_80705 = (state_80737[(7)]);
var _ = (function (){var statearr_80745 = state_80737;
(statearr_80745[(4)] = cljs.core.cons((5),(state_80737[(4)])));

return statearr_80745;
})();
var inst_80705__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_80737__$1 = (function (){var statearr_80746 = state_80737;
(statearr_80746[(7)] = inst_80705__$1);

return statearr_80746;
})();
if(cljs.core.truth_(inst_80705__$1)){
var statearr_80747_80768 = state_80737__$1;
(statearr_80747_80768[(1)] = (6));

} else {
var statearr_80748_80769 = state_80737__$1;
(statearr_80748_80769[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (11))){
var inst_80732 = (state_80737[(2)]);
var _ = (function (){var statearr_80750 = state_80737;
(statearr_80750[(4)] = cljs.core.rest((state_80737[(4)])));

return statearr_80750;
})();
var state_80737__$1 = state_80737;
var statearr_80751_80770 = state_80737__$1;
(statearr_80751_80770[(2)] = inst_80732);

(statearr_80751_80770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (9))){
var inst_80715 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_80737__$1 = state_80737;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80737__$1,(12),inst_80715);
} else {
if((state_val_80738 === (5))){
var _ = (function (){var statearr_80752 = state_80737;
(statearr_80752[(4)] = cljs.core.rest((state_80737[(4)])));

return statearr_80752;
})();
var state_80737__$1 = state_80737;
var ex80749 = (state_80737__$1[(2)]);
var statearr_80753_80771 = state_80737__$1;
(statearr_80753_80771[(5)] = ex80749);


if((ex80749 instanceof Error)){
var statearr_80754_80772 = state_80737__$1;
(statearr_80754_80772[(1)] = (4));

(statearr_80754_80772[(5)] = null);

} else {
throw ex80749;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (10))){
var inst_80730 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_80737__$1 = state_80737;
var statearr_80755_80773 = state_80737__$1;
(statearr_80755_80773[(2)] = inst_80730);

(statearr_80755_80773[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80738 === (8))){
var inst_80710 = (state_80737[(2)]);
var state_80737__$1 = state_80737;
if(cljs.core.truth_(inst_80710)){
var statearr_80756_80774 = state_80737__$1;
(statearr_80756_80774[(1)] = (9));

} else {
var statearr_80757_80775 = state_80737__$1;
(statearr_80757_80775[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____0 = (function (){
var statearr_80758 = [null,null,null,null,null,null,null,null,null];
(statearr_80758[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__);

(statearr_80758[(1)] = (1));

return statearr_80758;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____1 = (function (state_80737){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80737);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80759){var ex__24301__auto__ = e80759;
var statearr_80760_80776 = state_80737;
(statearr_80760_80776[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80737[(4)]))){
var statearr_80761_80777 = state_80737;
(statearr_80761_80777[(1)] = cljs.core.first((state_80737[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80778 = state_80737;
state_80737 = G__80778;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__ = function(state_80737){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____1.call(this,state_80737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80762 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80762[(6)] = c__24424__auto__);

return statearr_80762;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80830){
var state_val_80831 = (state_80830[(1)]);
if((state_val_80831 === (7))){
var state_80830__$1 = state_80830;
var statearr_80832_80865 = state_80830__$1;
(statearr_80832_80865[(2)] = subject);

(statearr_80832_80865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (1))){
var state_80830__$1 = state_80830;
var statearr_80833_80866 = state_80830__$1;
(statearr_80833_80866[(2)] = null);

(statearr_80833_80866[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (4))){
var inst_80779 = (state_80830[(2)]);
var state_80830__$1 = state_80830;
var statearr_80834_80867 = state_80830__$1;
(statearr_80834_80867[(2)] = inst_80779);

(statearr_80834_80867[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (15))){
var inst_80792 = (state_80830[(7)]);
var state_80830__$1 = state_80830;
var statearr_80835_80868 = state_80830__$1;
(statearr_80835_80868[(2)] = inst_80792);

(statearr_80835_80868[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (13))){
var inst_80796 = (state_80830[(2)]);
var inst_80797 = fluree.db.util.async.throw_err(inst_80796);
var state_80830__$1 = state_80830;
var statearr_80836_80869 = state_80830__$1;
(statearr_80836_80869[(2)] = inst_80797);

(statearr_80836_80869[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (6))){
var state_80830__$1 = state_80830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80830__$1,(9),subject);
} else {
if((state_val_80831 === (17))){
var inst_80792 = (state_80830[(7)]);
var inst_80806 = cljs.core.first(inst_80792);
var state_80830__$1 = state_80830;
var statearr_80837_80870 = state_80830__$1;
(statearr_80837_80870[(2)] = inst_80806);

(statearr_80837_80870[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (3))){
var inst_80828 = (state_80830[(2)]);
var state_80830__$1 = state_80830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80830__$1,inst_80828);
} else {
if((state_val_80831 === (12))){
var inst_80792 = (state_80830[(7)]);
var inst_80800 = (state_80830[(2)]);
var inst_80801 = cljs.core.vector_QMARK_(inst_80792);
var state_80830__$1 = (function (){var statearr_80838 = state_80830;
(statearr_80838[(8)] = inst_80800);

return statearr_80838;
})();
if(inst_80801){
var statearr_80839_80871 = state_80830__$1;
(statearr_80839_80871[(1)] = (14));

} else {
var statearr_80840_80872 = state_80830__$1;
(statearr_80840_80872[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (2))){
var _ = (function (){var statearr_80841 = state_80830;
(statearr_80841[(4)] = cljs.core.cons((5),(state_80830[(4)])));

return statearr_80841;
})();
var inst_80785 = fluree.db.util.async.channel_QMARK_(subject);
var state_80830__$1 = state_80830;
if(inst_80785){
var statearr_80842_80873 = state_80830__$1;
(statearr_80842_80873[(1)] = (6));

} else {
var statearr_80843_80874 = state_80830__$1;
(statearr_80843_80874[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (19))){
var inst_80809 = (state_80830[(2)]);
var state_80830__$1 = state_80830;
var statearr_80844_80875 = state_80830__$1;
(statearr_80844_80875[(2)] = inst_80809);

(statearr_80844_80875[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (11))){
var state_80830__$1 = state_80830;
var statearr_80846_80876 = state_80830__$1;
(statearr_80846_80876[(2)] = path);

(statearr_80846_80876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (9))){
var inst_80788 = (state_80830[(2)]);
var inst_80789 = fluree.db.util.async.throw_err(inst_80788);
var state_80830__$1 = state_80830;
var statearr_80847_80877 = state_80830__$1;
(statearr_80847_80877[(2)] = inst_80789);

(statearr_80847_80877[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (5))){
var _ = (function (){var statearr_80848 = state_80830;
(statearr_80848[(4)] = cljs.core.rest((state_80830[(4)])));

return statearr_80848;
})();
var state_80830__$1 = state_80830;
var ex80845 = (state_80830__$1[(2)]);
var statearr_80849_80878 = state_80830__$1;
(statearr_80849_80878[(5)] = ex80845);


if((ex80845 instanceof Error)){
var statearr_80850_80879 = state_80830__$1;
(statearr_80850_80879[(1)] = (4));

(statearr_80850_80879[(5)] = null);

} else {
throw ex80845;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (14))){
var inst_80792 = (state_80830[(7)]);
var inst_80803 = cljs.core.count(inst_80792);
var inst_80804 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_80803);
var state_80830__$1 = state_80830;
if(inst_80804){
var statearr_80851_80880 = state_80830__$1;
(statearr_80851_80880[(1)] = (17));

} else {
var statearr_80852_80881 = state_80830__$1;
(statearr_80852_80881[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (16))){
var inst_80792 = (state_80830[(7)]);
var inst_80800 = (state_80830[(8)]);
var inst_80812 = (state_80830[(2)]);
var inst_80813 = fluree.db.dbfunctions.internal.get_all(inst_80812,inst_80800);
var inst_80814 = cljs.core.count(inst_80800);
var inst_80815 = ((9) + inst_80814);
var inst_80816 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80817 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80819 = [inst_80792,inst_80800];
var inst_80820 = (new cljs.core.PersistentVector(null,2,(5),inst_80818,inst_80819,null));
var inst_80821 = ["get-all",inst_80820,inst_80813];
var inst_80822 = cljs.core.PersistentHashMap.fromArrays(inst_80817,inst_80821);
var inst_80823 = [inst_80822,inst_80815];
var inst_80824 = (new cljs.core.PersistentVector(null,2,(5),inst_80816,inst_80823,null));
var inst_80825 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80824);
var _ = (function (){var statearr_80853 = state_80830;
(statearr_80853[(4)] = cljs.core.rest((state_80830[(4)])));

return statearr_80853;
})();
var state_80830__$1 = (function (){var statearr_80854 = state_80830;
(statearr_80854[(9)] = inst_80825);

return statearr_80854;
})();
var statearr_80855_80882 = state_80830__$1;
(statearr_80855_80882[(2)] = inst_80813);

(statearr_80855_80882[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (10))){
var state_80830__$1 = state_80830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80830__$1,(13),path);
} else {
if((state_val_80831 === (18))){
var inst_80792 = (state_80830[(7)]);
var state_80830__$1 = state_80830;
var statearr_80856_80883 = state_80830__$1;
(statearr_80856_80883[(2)] = inst_80792);

(statearr_80856_80883[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80831 === (8))){
var inst_80792 = (state_80830[(2)]);
var inst_80793 = fluree.db.util.async.channel_QMARK_(path);
var state_80830__$1 = (function (){var statearr_80857 = state_80830;
(statearr_80857[(7)] = inst_80792);

return statearr_80857;
})();
if(inst_80793){
var statearr_80858_80884 = state_80830__$1;
(statearr_80858_80884[(1)] = (10));

} else {
var statearr_80859_80885 = state_80830__$1;
(statearr_80859_80885[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____0 = (function (){
var statearr_80860 = [null,null,null,null,null,null,null,null,null,null];
(statearr_80860[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__);

(statearr_80860[(1)] = (1));

return statearr_80860;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____1 = (function (state_80830){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80830);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80861){var ex__24301__auto__ = e80861;
var statearr_80862_80886 = state_80830;
(statearr_80862_80886[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80830[(4)]))){
var statearr_80863_80887 = state_80830;
(statearr_80863_80887[(1)] = cljs.core.first((state_80830[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80888 = state_80830;
state_80830 = G__80888;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__ = function(state_80830){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____1.call(this,state_80830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80864 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80864[(6)] = c__24424__auto__);

return statearr_80864;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [_QMARK_ctx,subject,path], null);

var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_80927){
var state_val_80928 = (state_80927[(1)]);
if((state_val_80928 === (7))){
var state_80927__$1 = state_80927;
var statearr_80929_80953 = state_80927__$1;
(statearr_80929_80953[(2)] = subject);

(statearr_80929_80953[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (1))){
var state_80927__$1 = state_80927;
var statearr_80930_80954 = state_80927__$1;
(statearr_80930_80954[(2)] = null);

(statearr_80930_80954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (4))){
var inst_80889 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
var statearr_80931_80955 = state_80927__$1;
(statearr_80931_80955[(2)] = inst_80889);

(statearr_80931_80955[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (13))){
var inst_80906 = (state_80927[(2)]);
var inst_80907 = fluree.db.util.async.throw_err(inst_80906);
var state_80927__$1 = state_80927;
var statearr_80932_80956 = state_80927__$1;
(statearr_80932_80956[(2)] = inst_80907);

(statearr_80932_80956[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (6))){
var state_80927__$1 = state_80927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80927__$1,(9),subject);
} else {
if((state_val_80928 === (3))){
var inst_80925 = (state_80927[(2)]);
var state_80927__$1 = state_80927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_80927__$1,inst_80925);
} else {
if((state_val_80928 === (12))){
var inst_80902 = (state_80927[(7)]);
var inst_80910 = (state_80927[(2)]);
var inst_80911 = fluree.db.dbfunctions.internal.get_in(inst_80902,inst_80910);
var inst_80912 = cljs.core.count(inst_80910);
var inst_80913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80914 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_80915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_80916 = [inst_80902,inst_80910];
var inst_80917 = (new cljs.core.PersistentVector(null,2,(5),inst_80915,inst_80916,null));
var inst_80918 = ["get-in",inst_80917,inst_80911];
var inst_80919 = cljs.core.PersistentHashMap.fromArrays(inst_80914,inst_80918);
var inst_80920 = [inst_80919,inst_80912];
var inst_80921 = (new cljs.core.PersistentVector(null,2,(5),inst_80913,inst_80920,null));
var inst_80922 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_80921);
var _ = (function (){var statearr_80933 = state_80927;
(statearr_80933[(4)] = cljs.core.rest((state_80927[(4)])));

return statearr_80933;
})();
var state_80927__$1 = (function (){var statearr_80934 = state_80927;
(statearr_80934[(8)] = inst_80922);

return statearr_80934;
})();
var statearr_80935_80957 = state_80927__$1;
(statearr_80935_80957[(2)] = inst_80911);

(statearr_80935_80957[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (2))){
var _ = (function (){var statearr_80936 = state_80927;
(statearr_80936[(4)] = cljs.core.cons((5),(state_80927[(4)])));

return statearr_80936;
})();
var inst_80895 = fluree.db.util.async.channel_QMARK_(subject);
var state_80927__$1 = state_80927;
if(inst_80895){
var statearr_80937_80958 = state_80927__$1;
(statearr_80937_80958[(1)] = (6));

} else {
var statearr_80938_80959 = state_80927__$1;
(statearr_80938_80959[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (11))){
var state_80927__$1 = state_80927;
var statearr_80940_80960 = state_80927__$1;
(statearr_80940_80960[(2)] = path);

(statearr_80940_80960[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (9))){
var inst_80898 = (state_80927[(2)]);
var inst_80899 = fluree.db.util.async.throw_err(inst_80898);
var state_80927__$1 = state_80927;
var statearr_80941_80961 = state_80927__$1;
(statearr_80941_80961[(2)] = inst_80899);

(statearr_80941_80961[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (5))){
var _ = (function (){var statearr_80942 = state_80927;
(statearr_80942[(4)] = cljs.core.rest((state_80927[(4)])));

return statearr_80942;
})();
var state_80927__$1 = state_80927;
var ex80939 = (state_80927__$1[(2)]);
var statearr_80943_80962 = state_80927__$1;
(statearr_80943_80962[(5)] = ex80939);


if((ex80939 instanceof Error)){
var statearr_80944_80963 = state_80927__$1;
(statearr_80944_80963[(1)] = (4));

(statearr_80944_80963[(5)] = null);

} else {
throw ex80939;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_80928 === (10))){
var state_80927__$1 = state_80927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_80927__$1,(13),path);
} else {
if((state_val_80928 === (8))){
var inst_80902 = (state_80927[(2)]);
var inst_80903 = fluree.db.util.async.channel_QMARK_(path);
var state_80927__$1 = (function (){var statearr_80945 = state_80927;
(statearr_80945[(7)] = inst_80902);

return statearr_80945;
})();
if(inst_80903){
var statearr_80946_80964 = state_80927__$1;
(statearr_80946_80964[(1)] = (10));

} else {
var statearr_80947_80965 = state_80927__$1;
(statearr_80947_80965[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____0 = (function (){
var statearr_80948 = [null,null,null,null,null,null,null,null,null];
(statearr_80948[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__);

(statearr_80948[(1)] = (1));

return statearr_80948;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____1 = (function (state_80927){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_80927);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e80949){var ex__24301__auto__ = e80949;
var statearr_80950_80966 = state_80927;
(statearr_80950_80966[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_80927[(4)]))){
var statearr_80951_80967 = state_80927;
(statearr_80951_80967[(1)] = cljs.core.first((state_80927[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__80968 = state_80927;
state_80927 = G__80968;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__ = function(state_80927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____1.call(this,state_80927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_80952 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_80952[(6)] = c__24424__auto__);

return statearr_80952;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81013){
var state_val_81014 = (state_81013[(1)]);
if((state_val_81014 === (7))){
var state_81013__$1 = state_81013;
var statearr_81015_81044 = state_81013__$1;
(statearr_81015_81044[(2)] = coll);

(statearr_81015_81044[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (1))){
var state_81013__$1 = state_81013;
var statearr_81016_81045 = state_81013__$1;
(statearr_81016_81045[(2)] = null);

(statearr_81016_81045[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (4))){
var inst_80969 = (state_81013[(2)]);
var state_81013__$1 = state_81013;
var statearr_81017_81046 = state_81013__$1;
(statearr_81017_81046[(2)] = inst_80969);

(statearr_81017_81046[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (15))){
var inst_80989 = (state_81013[(7)]);
var inst_80997 = (state_81013[(2)]);
var inst_80998 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_80989,inst_80997);
var inst_80999 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81000 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81002 = [inst_80989,inst_80997];
var inst_81003 = (new cljs.core.PersistentVector(null,2,(5),inst_81001,inst_81002,null));
var inst_81004 = ["contains?",inst_81003,inst_80998];
var inst_81005 = cljs.core.PersistentHashMap.fromArrays(inst_81000,inst_81004);
var inst_81006 = [inst_81005,(10)];
var inst_81007 = (new cljs.core.PersistentVector(null,2,(5),inst_80999,inst_81006,null));
var inst_81008 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81007);
var _ = (function (){var statearr_81018 = state_81013;
(statearr_81018[(4)] = cljs.core.rest((state_81013[(4)])));

return statearr_81018;
})();
var state_81013__$1 = (function (){var statearr_81019 = state_81013;
(statearr_81019[(8)] = inst_81008);

return statearr_81019;
})();
var statearr_81020_81047 = state_81013__$1;
(statearr_81020_81047[(2)] = inst_80998);

(statearr_81020_81047[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (13))){
var state_81013__$1 = state_81013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81013__$1,(16),key);
} else {
if((state_val_81014 === (6))){
var state_81013__$1 = state_81013;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81013__$1,(9),coll);
} else {
if((state_val_81014 === (3))){
var inst_81011 = (state_81013[(2)]);
var state_81013__$1 = state_81013;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81013__$1,inst_81011);
} else {
if((state_val_81014 === (12))){
var inst_80989 = (state_81013[(2)]);
var inst_80990 = fluree.db.util.async.channel_QMARK_(key);
var state_81013__$1 = (function (){var statearr_81021 = state_81013;
(statearr_81021[(7)] = inst_80989);

return statearr_81021;
})();
if(inst_80990){
var statearr_81022_81048 = state_81013__$1;
(statearr_81022_81048[(1)] = (13));

} else {
var statearr_81023_81049 = state_81013__$1;
(statearr_81023_81049[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (2))){
var _ = (function (){var statearr_81024 = state_81013;
(statearr_81024[(4)] = cljs.core.cons((5),(state_81013[(4)])));

return statearr_81024;
})();
var inst_80975 = fluree.db.util.async.channel_QMARK_(coll);
var state_81013__$1 = state_81013;
if(inst_80975){
var statearr_81025_81050 = state_81013__$1;
(statearr_81025_81050[(1)] = (6));

} else {
var statearr_81026_81051 = state_81013__$1;
(statearr_81026_81051[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (11))){
var inst_80982 = (state_81013[(9)]);
var inst_80986 = cljs.core.flatten(inst_80982);
var inst_80987 = cljs.core.set(inst_80986);
var state_81013__$1 = state_81013;
var statearr_81028_81052 = state_81013__$1;
(statearr_81028_81052[(2)] = inst_80987);

(statearr_81028_81052[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (9))){
var inst_80978 = (state_81013[(2)]);
var inst_80979 = fluree.db.util.async.throw_err(inst_80978);
var state_81013__$1 = state_81013;
var statearr_81029_81053 = state_81013__$1;
(statearr_81029_81053[(2)] = inst_80979);

(statearr_81029_81053[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (5))){
var _ = (function (){var statearr_81030 = state_81013;
(statearr_81030[(4)] = cljs.core.rest((state_81013[(4)])));

return statearr_81030;
})();
var state_81013__$1 = state_81013;
var ex81027 = (state_81013__$1[(2)]);
var statearr_81031_81054 = state_81013__$1;
(statearr_81031_81054[(5)] = ex81027);


if((ex81027 instanceof Error)){
var statearr_81032_81055 = state_81013__$1;
(statearr_81032_81055[(1)] = (4));

(statearr_81032_81055[(5)] = null);

} else {
throw ex81027;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (14))){
var state_81013__$1 = state_81013;
var statearr_81033_81056 = state_81013__$1;
(statearr_81033_81056[(2)] = key);

(statearr_81033_81056[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (16))){
var inst_80993 = (state_81013[(2)]);
var inst_80994 = fluree.db.util.async.throw_err(inst_80993);
var state_81013__$1 = state_81013;
var statearr_81034_81057 = state_81013__$1;
(statearr_81034_81057[(2)] = inst_80994);

(statearr_81034_81057[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (10))){
var inst_80982 = (state_81013[(9)]);
var state_81013__$1 = state_81013;
var statearr_81035_81058 = state_81013__$1;
(statearr_81035_81058[(2)] = inst_80982);

(statearr_81035_81058[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81014 === (8))){
var inst_80982 = (state_81013[(9)]);
var inst_80982__$1 = (state_81013[(2)]);
var inst_80983 = cljs.core.set_QMARK_(inst_80982__$1);
var state_81013__$1 = (function (){var statearr_81036 = state_81013;
(statearr_81036[(9)] = inst_80982__$1);

return statearr_81036;
})();
if(inst_80983){
var statearr_81037_81059 = state_81013__$1;
(statearr_81037_81059[(1)] = (10));

} else {
var statearr_81038_81060 = state_81013__$1;
(statearr_81038_81060[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_81039 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81039[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__);

(statearr_81039[(1)] = (1));

return statearr_81039;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____1 = (function (state_81013){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81013);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81040){var ex__24301__auto__ = e81040;
var statearr_81041_81061 = state_81013;
(statearr_81041_81061[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81013[(4)]))){
var statearr_81042_81062 = state_81013;
(statearr_81042_81062[(1)] = cljs.core.first((state_81013[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81063 = state_81013;
state_81013 = G__81063;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__ = function(state_81013){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____1.call(this,state_81013);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81043 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81043[(6)] = c__24424__auto__);

return statearr_81043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81135 = arguments.length;
var i__4819__auto___81136 = (0);
while(true){
if((i__4819__auto___81136 < len__4818__auto___81135)){
args__4824__auto__.push((arguments[i__4819__auto___81136]));

var G__81137 = (i__4819__auto___81136 + (1));
i__4819__auto___81136 = G__81137;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81109){
var state_val_81110 = (state_81109[(1)]);
if((state_val_81110 === (7))){
var inst_81075 = (state_81109[(7)]);
var inst_81079 = cljs.core.first(inst_81075);
var inst_81080 = cljs.core.coll_QMARK_(inst_81079);
var state_81109__$1 = state_81109;
var statearr_81111_81138 = state_81109__$1;
(statearr_81111_81138[(2)] = inst_81080);

(statearr_81111_81138[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (1))){
var state_81109__$1 = state_81109;
var statearr_81112_81139 = state_81109__$1;
(statearr_81112_81139[(2)] = null);

(statearr_81112_81139[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (4))){
var inst_81066 = (state_81109[(2)]);
var state_81109__$1 = state_81109;
var statearr_81113_81140 = state_81109__$1;
(statearr_81113_81140[(2)] = inst_81066);

(statearr_81113_81140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (6))){
var inst_81075 = (state_81109[(7)]);
var inst_81077 = (state_81109[(8)]);
var inst_81074 = (state_81109[(2)]);
var inst_81075__$1 = fluree.db.util.async.throw_err(inst_81074);
var inst_81076 = cljs.core.count(inst_81075__$1);
var inst_81077__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_81076);
var state_81109__$1 = (function (){var statearr_81114 = state_81109;
(statearr_81114[(7)] = inst_81075__$1);

(statearr_81114[(8)] = inst_81077__$1);

return statearr_81114;
})();
if(inst_81077__$1){
var statearr_81115_81141 = state_81109__$1;
(statearr_81115_81141[(1)] = (7));

} else {
var statearr_81116_81142 = state_81109__$1;
(statearr_81116_81142[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (3))){
var inst_81107 = (state_81109[(2)]);
var state_81109__$1 = state_81109;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81109__$1,inst_81107);
} else {
if((state_val_81110 === (12))){
var inst_81088 = (state_81109[(2)]);
var inst_81089 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_81088);
var inst_81090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81091 = [inst_81088];
var inst_81092 = (new cljs.core.PersistentVector(null,1,(5),inst_81090,inst_81091,null));
var inst_81093 = cljs.core.count(inst_81092);
var inst_81094 = ((9) + inst_81093);
var inst_81095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81096 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81097 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81098 = [inst_81088];
var inst_81099 = (new cljs.core.PersistentVector(null,1,(5),inst_81097,inst_81098,null));
var inst_81100 = ["hash-set",inst_81099,inst_81089];
var inst_81101 = cljs.core.PersistentHashMap.fromArrays(inst_81096,inst_81100);
var inst_81102 = [inst_81101,inst_81094];
var inst_81103 = (new cljs.core.PersistentVector(null,2,(5),inst_81095,inst_81102,null));
var inst_81104 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81103);
var _ = (function (){var statearr_81117 = state_81109;
(statearr_81117[(4)] = cljs.core.rest((state_81109[(4)])));

return statearr_81117;
})();
var state_81109__$1 = (function (){var statearr_81118 = state_81109;
(statearr_81118[(9)] = inst_81104);

return statearr_81118;
})();
var statearr_81119_81143 = state_81109__$1;
(statearr_81119_81143[(2)] = inst_81089);

(statearr_81119_81143[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (2))){
var _ = (function (){var statearr_81120 = state_81109;
(statearr_81120[(4)] = cljs.core.cons((5),(state_81109[(4)])));

return statearr_81120;
})();
var inst_81072 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81109__$1 = state_81109;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81109__$1,(6),inst_81072);
} else {
if((state_val_81110 === (11))){
var inst_81075 = (state_81109[(7)]);
var state_81109__$1 = state_81109;
var statearr_81122_81144 = state_81109__$1;
(statearr_81122_81144[(2)] = inst_81075);

(statearr_81122_81144[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (9))){
var inst_81083 = (state_81109[(2)]);
var state_81109__$1 = state_81109;
if(cljs.core.truth_(inst_81083)){
var statearr_81123_81145 = state_81109__$1;
(statearr_81123_81145[(1)] = (10));

} else {
var statearr_81124_81146 = state_81109__$1;
(statearr_81124_81146[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (5))){
var _ = (function (){var statearr_81125 = state_81109;
(statearr_81125[(4)] = cljs.core.rest((state_81109[(4)])));

return statearr_81125;
})();
var state_81109__$1 = state_81109;
var ex81121 = (state_81109__$1[(2)]);
var statearr_81126_81147 = state_81109__$1;
(statearr_81126_81147[(5)] = ex81121);


if((ex81121 instanceof Error)){
var statearr_81127_81148 = state_81109__$1;
(statearr_81127_81148[(1)] = (4));

(statearr_81127_81148[(5)] = null);

} else {
throw ex81121;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (10))){
var inst_81075 = (state_81109[(7)]);
var inst_81085 = cljs.core.first(inst_81075);
var state_81109__$1 = state_81109;
var statearr_81128_81149 = state_81109__$1;
(statearr_81128_81149[(2)] = inst_81085);

(statearr_81128_81149[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81110 === (8))){
var inst_81077 = (state_81109[(8)]);
var state_81109__$1 = state_81109;
var statearr_81129_81150 = state_81109__$1;
(statearr_81129_81150[(2)] = inst_81077);

(statearr_81129_81150[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81130 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81130[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81130[(1)] = (1));

return statearr_81130;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81109){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81109);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81131){var ex__24301__auto__ = e81131;
var statearr_81132_81151 = state_81109;
(statearr_81132_81151[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81109[(4)]))){
var statearr_81133_81152 = state_81109;
(statearr_81133_81152[(1)] = cljs.core.first((state_81109[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81153 = state_81109;
state_81109 = G__81153;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81109){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81109);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81134 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81134[(6)] = c__24424__auto__);

return statearr_81134;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq81064){
var G__81065 = cljs.core.first(seq81064);
var seq81064__$1 = cljs.core.next(seq81064);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81065,seq81064__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81203 = arguments.length;
var i__4819__auto___81204 = (0);
while(true){
if((i__4819__auto___81204 < len__4818__auto___81203)){
args__4824__auto__.push((arguments[i__4819__auto___81204]));

var G__81205 = (i__4819__auto___81204 + (1));
i__4819__auto___81204 = G__81205;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81186){
var state_val_81187 = (state_81186[(1)]);
if((state_val_81187 === (1))){
var state_81186__$1 = state_81186;
var statearr_81188_81206 = state_81186__$1;
(statearr_81188_81206[(2)] = null);

(statearr_81188_81206[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81187 === (2))){
var _ = (function (){var statearr_81189 = state_81186;
(statearr_81189[(4)] = cljs.core.cons((5),(state_81186[(4)])));

return statearr_81189;
})();
var inst_81162 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81186__$1 = state_81186;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81186__$1,(6),inst_81162);
} else {
if((state_val_81187 === (3))){
var inst_81184 = (state_81186[(2)]);
var state_81186__$1 = state_81186;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81186__$1,inst_81184);
} else {
if((state_val_81187 === (4))){
var inst_81156 = (state_81186[(2)]);
var state_81186__$1 = state_81186;
var statearr_81191_81207 = state_81186__$1;
(statearr_81191_81207[(2)] = inst_81156);

(statearr_81191_81207[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81187 === (5))){
var _ = (function (){var statearr_81192 = state_81186;
(statearr_81192[(4)] = cljs.core.rest((state_81186[(4)])));

return statearr_81192;
})();
var state_81186__$1 = state_81186;
var ex81190 = (state_81186__$1[(2)]);
var statearr_81193_81208 = state_81186__$1;
(statearr_81193_81208[(5)] = ex81190);


if((ex81190 instanceof Error)){
var statearr_81194_81209 = state_81186__$1;
(statearr_81194_81209[(1)] = (4));

(statearr_81194_81209[(5)] = null);

} else {
throw ex81190;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81187 === (6))){
var inst_81164 = (state_81186[(2)]);
var inst_81165 = fluree.db.util.async.throw_err(inst_81164);
var inst_81166 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_81165);
var inst_81167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81168 = [inst_81165];
var inst_81169 = (new cljs.core.PersistentVector(null,1,(5),inst_81167,inst_81168,null));
var inst_81170 = cljs.core.count(inst_81169);
var inst_81171 = ((9) + inst_81170);
var inst_81172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81173 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81174 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81175 = [inst_81165];
var inst_81176 = (new cljs.core.PersistentVector(null,1,(5),inst_81174,inst_81175,null));
var inst_81177 = ["==",inst_81176,inst_81166];
var inst_81178 = cljs.core.PersistentHashMap.fromArrays(inst_81173,inst_81177);
var inst_81179 = [inst_81178,inst_81171];
var inst_81180 = (new cljs.core.PersistentVector(null,2,(5),inst_81172,inst_81179,null));
var inst_81181 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81180);
var _ = (function (){var statearr_81195 = state_81186;
(statearr_81195[(4)] = cljs.core.rest((state_81186[(4)])));

return statearr_81195;
})();
var state_81186__$1 = (function (){var statearr_81196 = state_81186;
(statearr_81196[(7)] = inst_81181);

return statearr_81196;
})();
var statearr_81197_81210 = state_81186__$1;
(statearr_81197_81210[(2)] = inst_81166);

(statearr_81197_81210[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81198 = [null,null,null,null,null,null,null,null];
(statearr_81198[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81198[(1)] = (1));

return statearr_81198;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81186){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81186);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81199){var ex__24301__auto__ = e81199;
var statearr_81200_81211 = state_81186;
(statearr_81200_81211[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81186[(4)]))){
var statearr_81201_81212 = state_81186;
(statearr_81201_81212[(1)] = cljs.core.first((state_81186[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81213 = state_81186;
state_81186 = G__81213;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81186){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81186);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81202 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81202[(6)] = c__24424__auto__);

return statearr_81202;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq81154){
var G__81155 = cljs.core.first(seq81154);
var seq81154__$1 = cljs.core.next(seq81154);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81155,seq81154__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81263 = arguments.length;
var i__4819__auto___81264 = (0);
while(true){
if((i__4819__auto___81264 < len__4818__auto___81263)){
args__4824__auto__.push((arguments[i__4819__auto___81264]));

var G__81265 = (i__4819__auto___81264 + (1));
i__4819__auto___81264 = G__81265;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81246){
var state_val_81247 = (state_81246[(1)]);
if((state_val_81247 === (1))){
var state_81246__$1 = state_81246;
var statearr_81248_81266 = state_81246__$1;
(statearr_81248_81266[(2)] = null);

(statearr_81248_81266[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81247 === (2))){
var _ = (function (){var statearr_81249 = state_81246;
(statearr_81249[(4)] = cljs.core.cons((5),(state_81246[(4)])));

return statearr_81249;
})();
var inst_81222 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81246__$1 = state_81246;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81246__$1,(6),inst_81222);
} else {
if((state_val_81247 === (3))){
var inst_81244 = (state_81246[(2)]);
var state_81246__$1 = state_81246;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81246__$1,inst_81244);
} else {
if((state_val_81247 === (4))){
var inst_81216 = (state_81246[(2)]);
var state_81246__$1 = state_81246;
var statearr_81251_81267 = state_81246__$1;
(statearr_81251_81267[(2)] = inst_81216);

(statearr_81251_81267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81247 === (5))){
var _ = (function (){var statearr_81252 = state_81246;
(statearr_81252[(4)] = cljs.core.rest((state_81246[(4)])));

return statearr_81252;
})();
var state_81246__$1 = state_81246;
var ex81250 = (state_81246__$1[(2)]);
var statearr_81253_81268 = state_81246__$1;
(statearr_81253_81268[(5)] = ex81250);


if((ex81250 instanceof Error)){
var statearr_81254_81269 = state_81246__$1;
(statearr_81254_81269[(1)] = (4));

(statearr_81254_81269[(5)] = null);

} else {
throw ex81250;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81247 === (6))){
var inst_81224 = (state_81246[(2)]);
var inst_81225 = fluree.db.util.async.throw_err(inst_81224);
var inst_81226 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_81225);
var inst_81227 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81228 = [inst_81225];
var inst_81229 = (new cljs.core.PersistentVector(null,1,(5),inst_81227,inst_81228,null));
var inst_81230 = cljs.core.count(inst_81229);
var inst_81231 = ((9) + inst_81230);
var inst_81232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81233 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81234 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81235 = [inst_81225];
var inst_81236 = (new cljs.core.PersistentVector(null,1,(5),inst_81234,inst_81235,null));
var inst_81237 = [">",inst_81236,inst_81226];
var inst_81238 = cljs.core.PersistentHashMap.fromArrays(inst_81233,inst_81237);
var inst_81239 = [inst_81238,inst_81231];
var inst_81240 = (new cljs.core.PersistentVector(null,2,(5),inst_81232,inst_81239,null));
var inst_81241 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81240);
var _ = (function (){var statearr_81255 = state_81246;
(statearr_81255[(4)] = cljs.core.rest((state_81246[(4)])));

return statearr_81255;
})();
var state_81246__$1 = (function (){var statearr_81256 = state_81246;
(statearr_81256[(7)] = inst_81241);

return statearr_81256;
})();
var statearr_81257_81270 = state_81246__$1;
(statearr_81257_81270[(2)] = inst_81226);

(statearr_81257_81270[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81258 = [null,null,null,null,null,null,null,null];
(statearr_81258[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81258[(1)] = (1));

return statearr_81258;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81246){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81246);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81259){var ex__24301__auto__ = e81259;
var statearr_81260_81271 = state_81246;
(statearr_81260_81271[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81246[(4)]))){
var statearr_81261_81272 = state_81246;
(statearr_81261_81272[(1)] = cljs.core.first((state_81246[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81273 = state_81246;
state_81246 = G__81273;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81246){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81246);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81262 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81262[(6)] = c__24424__auto__);

return statearr_81262;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq81214){
var G__81215 = cljs.core.first(seq81214);
var seq81214__$1 = cljs.core.next(seq81214);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81215,seq81214__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81323 = arguments.length;
var i__4819__auto___81324 = (0);
while(true){
if((i__4819__auto___81324 < len__4818__auto___81323)){
args__4824__auto__.push((arguments[i__4819__auto___81324]));

var G__81325 = (i__4819__auto___81324 + (1));
i__4819__auto___81324 = G__81325;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81306){
var state_val_81307 = (state_81306[(1)]);
if((state_val_81307 === (1))){
var state_81306__$1 = state_81306;
var statearr_81308_81326 = state_81306__$1;
(statearr_81308_81326[(2)] = null);

(statearr_81308_81326[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81307 === (2))){
var _ = (function (){var statearr_81309 = state_81306;
(statearr_81309[(4)] = cljs.core.cons((5),(state_81306[(4)])));

return statearr_81309;
})();
var inst_81282 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81306__$1 = state_81306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81306__$1,(6),inst_81282);
} else {
if((state_val_81307 === (3))){
var inst_81304 = (state_81306[(2)]);
var state_81306__$1 = state_81306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81306__$1,inst_81304);
} else {
if((state_val_81307 === (4))){
var inst_81276 = (state_81306[(2)]);
var state_81306__$1 = state_81306;
var statearr_81311_81327 = state_81306__$1;
(statearr_81311_81327[(2)] = inst_81276);

(statearr_81311_81327[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81307 === (5))){
var _ = (function (){var statearr_81312 = state_81306;
(statearr_81312[(4)] = cljs.core.rest((state_81306[(4)])));

return statearr_81312;
})();
var state_81306__$1 = state_81306;
var ex81310 = (state_81306__$1[(2)]);
var statearr_81313_81328 = state_81306__$1;
(statearr_81313_81328[(5)] = ex81310);


if((ex81310 instanceof Error)){
var statearr_81314_81329 = state_81306__$1;
(statearr_81314_81329[(1)] = (4));

(statearr_81314_81329[(5)] = null);

} else {
throw ex81310;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81307 === (6))){
var inst_81284 = (state_81306[(2)]);
var inst_81285 = fluree.db.util.async.throw_err(inst_81284);
var inst_81286 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_81285);
var inst_81287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81288 = [inst_81285];
var inst_81289 = (new cljs.core.PersistentVector(null,1,(5),inst_81287,inst_81288,null));
var inst_81290 = cljs.core.count(inst_81289);
var inst_81291 = ((9) + inst_81290);
var inst_81292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81293 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81295 = [inst_81285];
var inst_81296 = (new cljs.core.PersistentVector(null,1,(5),inst_81294,inst_81295,null));
var inst_81297 = ["<",inst_81296,inst_81286];
var inst_81298 = cljs.core.PersistentHashMap.fromArrays(inst_81293,inst_81297);
var inst_81299 = [inst_81298,inst_81291];
var inst_81300 = (new cljs.core.PersistentVector(null,2,(5),inst_81292,inst_81299,null));
var inst_81301 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81300);
var _ = (function (){var statearr_81315 = state_81306;
(statearr_81315[(4)] = cljs.core.rest((state_81306[(4)])));

return statearr_81315;
})();
var state_81306__$1 = (function (){var statearr_81316 = state_81306;
(statearr_81316[(7)] = inst_81301);

return statearr_81316;
})();
var statearr_81317_81330 = state_81306__$1;
(statearr_81317_81330[(2)] = inst_81286);

(statearr_81317_81330[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81318 = [null,null,null,null,null,null,null,null];
(statearr_81318[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81318[(1)] = (1));

return statearr_81318;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81306){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81306);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81319){var ex__24301__auto__ = e81319;
var statearr_81320_81331 = state_81306;
(statearr_81320_81331[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81306[(4)]))){
var statearr_81321_81332 = state_81306;
(statearr_81321_81332[(1)] = cljs.core.first((state_81306[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81333 = state_81306;
state_81306 = G__81333;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81322 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81322[(6)] = c__24424__auto__);

return statearr_81322;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq81274){
var G__81275 = cljs.core.first(seq81274);
var seq81274__$1 = cljs.core.next(seq81274);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81275,seq81274__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81383 = arguments.length;
var i__4819__auto___81384 = (0);
while(true){
if((i__4819__auto___81384 < len__4818__auto___81383)){
args__4824__auto__.push((arguments[i__4819__auto___81384]));

var G__81385 = (i__4819__auto___81384 + (1));
i__4819__auto___81384 = G__81385;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81366){
var state_val_81367 = (state_81366[(1)]);
if((state_val_81367 === (1))){
var state_81366__$1 = state_81366;
var statearr_81368_81386 = state_81366__$1;
(statearr_81368_81386[(2)] = null);

(statearr_81368_81386[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81367 === (2))){
var _ = (function (){var statearr_81369 = state_81366;
(statearr_81369[(4)] = cljs.core.cons((5),(state_81366[(4)])));

return statearr_81369;
})();
var inst_81342 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81366__$1 = state_81366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81366__$1,(6),inst_81342);
} else {
if((state_val_81367 === (3))){
var inst_81364 = (state_81366[(2)]);
var state_81366__$1 = state_81366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81366__$1,inst_81364);
} else {
if((state_val_81367 === (4))){
var inst_81336 = (state_81366[(2)]);
var state_81366__$1 = state_81366;
var statearr_81371_81387 = state_81366__$1;
(statearr_81371_81387[(2)] = inst_81336);

(statearr_81371_81387[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81367 === (5))){
var _ = (function (){var statearr_81372 = state_81366;
(statearr_81372[(4)] = cljs.core.rest((state_81366[(4)])));

return statearr_81372;
})();
var state_81366__$1 = state_81366;
var ex81370 = (state_81366__$1[(2)]);
var statearr_81373_81388 = state_81366__$1;
(statearr_81373_81388[(5)] = ex81370);


if((ex81370 instanceof Error)){
var statearr_81374_81389 = state_81366__$1;
(statearr_81374_81389[(1)] = (4));

(statearr_81374_81389[(5)] = null);

} else {
throw ex81370;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81367 === (6))){
var inst_81344 = (state_81366[(2)]);
var inst_81345 = fluree.db.util.async.throw_err(inst_81344);
var inst_81346 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_81345);
var inst_81347 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81348 = [inst_81345];
var inst_81349 = (new cljs.core.PersistentVector(null,1,(5),inst_81347,inst_81348,null));
var inst_81350 = cljs.core.count(inst_81349);
var inst_81351 = ((9) + inst_81350);
var inst_81352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81353 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81354 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81355 = [inst_81345];
var inst_81356 = (new cljs.core.PersistentVector(null,1,(5),inst_81354,inst_81355,null));
var inst_81357 = ["<=",inst_81356,inst_81346];
var inst_81358 = cljs.core.PersistentHashMap.fromArrays(inst_81353,inst_81357);
var inst_81359 = [inst_81358,inst_81351];
var inst_81360 = (new cljs.core.PersistentVector(null,2,(5),inst_81352,inst_81359,null));
var inst_81361 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81360);
var _ = (function (){var statearr_81375 = state_81366;
(statearr_81375[(4)] = cljs.core.rest((state_81366[(4)])));

return statearr_81375;
})();
var state_81366__$1 = (function (){var statearr_81376 = state_81366;
(statearr_81376[(7)] = inst_81361);

return statearr_81376;
})();
var statearr_81377_81390 = state_81366__$1;
(statearr_81377_81390[(2)] = inst_81346);

(statearr_81377_81390[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81378 = [null,null,null,null,null,null,null,null];
(statearr_81378[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81378[(1)] = (1));

return statearr_81378;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81366){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81366);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81379){var ex__24301__auto__ = e81379;
var statearr_81380_81391 = state_81366;
(statearr_81380_81391[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81366[(4)]))){
var statearr_81381_81392 = state_81366;
(statearr_81381_81392[(1)] = cljs.core.first((state_81366[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81393 = state_81366;
state_81366 = G__81393;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81366){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81382 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81382[(6)] = c__24424__auto__);

return statearr_81382;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq81334){
var G__81335 = cljs.core.first(seq81334);
var seq81334__$1 = cljs.core.next(seq81334);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81335,seq81334__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81443 = arguments.length;
var i__4819__auto___81444 = (0);
while(true){
if((i__4819__auto___81444 < len__4818__auto___81443)){
args__4824__auto__.push((arguments[i__4819__auto___81444]));

var G__81445 = (i__4819__auto___81444 + (1));
i__4819__auto___81444 = G__81445;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81426){
var state_val_81427 = (state_81426[(1)]);
if((state_val_81427 === (1))){
var state_81426__$1 = state_81426;
var statearr_81428_81446 = state_81426__$1;
(statearr_81428_81446[(2)] = null);

(statearr_81428_81446[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81427 === (2))){
var _ = (function (){var statearr_81429 = state_81426;
(statearr_81429[(4)] = cljs.core.cons((5),(state_81426[(4)])));

return statearr_81429;
})();
var inst_81402 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81426__$1 = state_81426;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81426__$1,(6),inst_81402);
} else {
if((state_val_81427 === (3))){
var inst_81424 = (state_81426[(2)]);
var state_81426__$1 = state_81426;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81426__$1,inst_81424);
} else {
if((state_val_81427 === (4))){
var inst_81396 = (state_81426[(2)]);
var state_81426__$1 = state_81426;
var statearr_81431_81447 = state_81426__$1;
(statearr_81431_81447[(2)] = inst_81396);

(statearr_81431_81447[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81427 === (5))){
var _ = (function (){var statearr_81432 = state_81426;
(statearr_81432[(4)] = cljs.core.rest((state_81426[(4)])));

return statearr_81432;
})();
var state_81426__$1 = state_81426;
var ex81430 = (state_81426__$1[(2)]);
var statearr_81433_81448 = state_81426__$1;
(statearr_81433_81448[(5)] = ex81430);


if((ex81430 instanceof Error)){
var statearr_81434_81449 = state_81426__$1;
(statearr_81434_81449[(1)] = (4));

(statearr_81434_81449[(5)] = null);

} else {
throw ex81430;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81427 === (6))){
var inst_81404 = (state_81426[(2)]);
var inst_81405 = fluree.db.util.async.throw_err(inst_81404);
var inst_81406 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_81405);
var inst_81407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81408 = [inst_81405];
var inst_81409 = (new cljs.core.PersistentVector(null,1,(5),inst_81407,inst_81408,null));
var inst_81410 = cljs.core.count(inst_81409);
var inst_81411 = ((9) + inst_81410);
var inst_81412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81413 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81414 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81415 = [inst_81405];
var inst_81416 = (new cljs.core.PersistentVector(null,1,(5),inst_81414,inst_81415,null));
var inst_81417 = [">=",inst_81416,inst_81406];
var inst_81418 = cljs.core.PersistentHashMap.fromArrays(inst_81413,inst_81417);
var inst_81419 = [inst_81418,inst_81411];
var inst_81420 = (new cljs.core.PersistentVector(null,2,(5),inst_81412,inst_81419,null));
var inst_81421 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81420);
var _ = (function (){var statearr_81435 = state_81426;
(statearr_81435[(4)] = cljs.core.rest((state_81426[(4)])));

return statearr_81435;
})();
var state_81426__$1 = (function (){var statearr_81436 = state_81426;
(statearr_81436[(7)] = inst_81421);

return statearr_81436;
})();
var statearr_81437_81450 = state_81426__$1;
(statearr_81437_81450[(2)] = inst_81406);

(statearr_81437_81450[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81438 = [null,null,null,null,null,null,null,null];
(statearr_81438[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81438[(1)] = (1));

return statearr_81438;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81426){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81426);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81439){var ex__24301__auto__ = e81439;
var statearr_81440_81451 = state_81426;
(statearr_81440_81451[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81426[(4)]))){
var statearr_81441_81452 = state_81426;
(statearr_81441_81452[(1)] = cljs.core.first((state_81426[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81453 = state_81426;
state_81426 = G__81453;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81426){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81426);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81442 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81442[(6)] = c__24424__auto__);

return statearr_81442;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq81394){
var G__81395 = cljs.core.first(seq81394);
var seq81394__$1 = cljs.core.next(seq81394);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81395,seq81394__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81503 = arguments.length;
var i__4819__auto___81504 = (0);
while(true){
if((i__4819__auto___81504 < len__4818__auto___81503)){
args__4824__auto__.push((arguments[i__4819__auto___81504]));

var G__81505 = (i__4819__auto___81504 + (1));
i__4819__auto___81504 = G__81505;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81486){
var state_val_81487 = (state_81486[(1)]);
if((state_val_81487 === (1))){
var state_81486__$1 = state_81486;
var statearr_81488_81506 = state_81486__$1;
(statearr_81488_81506[(2)] = null);

(statearr_81488_81506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81487 === (2))){
var _ = (function (){var statearr_81489 = state_81486;
(statearr_81489[(4)] = cljs.core.cons((5),(state_81486[(4)])));

return statearr_81489;
})();
var inst_81462 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81486__$1 = state_81486;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81486__$1,(6),inst_81462);
} else {
if((state_val_81487 === (3))){
var inst_81484 = (state_81486[(2)]);
var state_81486__$1 = state_81486;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81486__$1,inst_81484);
} else {
if((state_val_81487 === (4))){
var inst_81456 = (state_81486[(2)]);
var state_81486__$1 = state_81486;
var statearr_81491_81507 = state_81486__$1;
(statearr_81491_81507[(2)] = inst_81456);

(statearr_81491_81507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81487 === (5))){
var _ = (function (){var statearr_81492 = state_81486;
(statearr_81492[(4)] = cljs.core.rest((state_81486[(4)])));

return statearr_81492;
})();
var state_81486__$1 = state_81486;
var ex81490 = (state_81486__$1[(2)]);
var statearr_81493_81508 = state_81486__$1;
(statearr_81493_81508[(5)] = ex81490);


if((ex81490 instanceof Error)){
var statearr_81494_81509 = state_81486__$1;
(statearr_81494_81509[(1)] = (4));

(statearr_81494_81509[(5)] = null);

} else {
throw ex81490;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81487 === (6))){
var inst_81464 = (state_81486[(2)]);
var inst_81465 = fluree.db.util.async.throw_err(inst_81464);
var inst_81466 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_81465);
var inst_81467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81468 = [inst_81465];
var inst_81469 = (new cljs.core.PersistentVector(null,1,(5),inst_81467,inst_81468,null));
var inst_81470 = cljs.core.count(inst_81469);
var inst_81471 = ((9) + inst_81470);
var inst_81472 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81473 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81475 = [inst_81465];
var inst_81476 = (new cljs.core.PersistentVector(null,1,(5),inst_81474,inst_81475,null));
var inst_81477 = ["not=",inst_81476,inst_81466];
var inst_81478 = cljs.core.PersistentHashMap.fromArrays(inst_81473,inst_81477);
var inst_81479 = [inst_81478,inst_81471];
var inst_81480 = (new cljs.core.PersistentVector(null,2,(5),inst_81472,inst_81479,null));
var inst_81481 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81480);
var _ = (function (){var statearr_81495 = state_81486;
(statearr_81495[(4)] = cljs.core.rest((state_81486[(4)])));

return statearr_81495;
})();
var state_81486__$1 = (function (){var statearr_81496 = state_81486;
(statearr_81496[(7)] = inst_81481);

return statearr_81496;
})();
var statearr_81497_81510 = state_81486__$1;
(statearr_81497_81510[(2)] = inst_81466);

(statearr_81497_81510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81498 = [null,null,null,null,null,null,null,null];
(statearr_81498[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81498[(1)] = (1));

return statearr_81498;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81486){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81486);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81499){var ex__24301__auto__ = e81499;
var statearr_81500_81511 = state_81486;
(statearr_81500_81511[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81486[(4)]))){
var statearr_81501_81512 = state_81486;
(statearr_81501_81512[(1)] = cljs.core.first((state_81486[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81513 = state_81486;
state_81486 = G__81513;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81486){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81486);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81502 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81502[(6)] = c__24424__auto__);

return statearr_81502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq81454){
var G__81455 = cljs.core.first(seq81454);
var seq81454__$1 = cljs.core.next(seq81454);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81455,seq81454__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81563 = arguments.length;
var i__4819__auto___81564 = (0);
while(true){
if((i__4819__auto___81564 < len__4818__auto___81563)){
args__4824__auto__.push((arguments[i__4819__auto___81564]));

var G__81565 = (i__4819__auto___81564 + (1));
i__4819__auto___81564 = G__81565;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81546){
var state_val_81547 = (state_81546[(1)]);
if((state_val_81547 === (1))){
var state_81546__$1 = state_81546;
var statearr_81548_81566 = state_81546__$1;
(statearr_81548_81566[(2)] = null);

(statearr_81548_81566[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81547 === (2))){
var _ = (function (){var statearr_81549 = state_81546;
(statearr_81549[(4)] = cljs.core.cons((5),(state_81546[(4)])));

return statearr_81549;
})();
var inst_81522 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81546__$1 = state_81546;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81546__$1,(6),inst_81522);
} else {
if((state_val_81547 === (3))){
var inst_81544 = (state_81546[(2)]);
var state_81546__$1 = state_81546;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81546__$1,inst_81544);
} else {
if((state_val_81547 === (4))){
var inst_81516 = (state_81546[(2)]);
var state_81546__$1 = state_81546;
var statearr_81551_81567 = state_81546__$1;
(statearr_81551_81567[(2)] = inst_81516);

(statearr_81551_81567[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81547 === (5))){
var _ = (function (){var statearr_81552 = state_81546;
(statearr_81552[(4)] = cljs.core.rest((state_81546[(4)])));

return statearr_81552;
})();
var state_81546__$1 = state_81546;
var ex81550 = (state_81546__$1[(2)]);
var statearr_81553_81568 = state_81546__$1;
(statearr_81553_81568[(5)] = ex81550);


if((ex81550 instanceof Error)){
var statearr_81554_81569 = state_81546__$1;
(statearr_81554_81569[(1)] = (4));

(statearr_81554_81569[(5)] = null);

} else {
throw ex81550;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81547 === (6))){
var inst_81524 = (state_81546[(2)]);
var inst_81525 = fluree.db.util.async.throw_err(inst_81524);
var inst_81526 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_81525);
var inst_81527 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81528 = [inst_81525];
var inst_81529 = (new cljs.core.PersistentVector(null,1,(5),inst_81527,inst_81528,null));
var inst_81530 = cljs.core.count(inst_81529);
var inst_81531 = ((9) + inst_81530);
var inst_81532 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81533 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81534 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81535 = [inst_81525];
var inst_81536 = (new cljs.core.PersistentVector(null,1,(5),inst_81534,inst_81535,null));
var inst_81537 = ["max",inst_81536,inst_81526];
var inst_81538 = cljs.core.PersistentHashMap.fromArrays(inst_81533,inst_81537);
var inst_81539 = [inst_81538,inst_81531];
var inst_81540 = (new cljs.core.PersistentVector(null,2,(5),inst_81532,inst_81539,null));
var inst_81541 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81540);
var _ = (function (){var statearr_81555 = state_81546;
(statearr_81555[(4)] = cljs.core.rest((state_81546[(4)])));

return statearr_81555;
})();
var state_81546__$1 = (function (){var statearr_81556 = state_81546;
(statearr_81556[(7)] = inst_81541);

return statearr_81556;
})();
var statearr_81557_81570 = state_81546__$1;
(statearr_81557_81570[(2)] = inst_81526);

(statearr_81557_81570[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81558 = [null,null,null,null,null,null,null,null];
(statearr_81558[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81558[(1)] = (1));

return statearr_81558;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81546){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81546);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81559){var ex__24301__auto__ = e81559;
var statearr_81560_81571 = state_81546;
(statearr_81560_81571[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81546[(4)]))){
var statearr_81561_81572 = state_81546;
(statearr_81561_81572[(1)] = cljs.core.first((state_81546[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81573 = state_81546;
state_81546 = G__81573;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81546){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81546);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81562 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81562[(6)] = c__24424__auto__);

return statearr_81562;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq81514){
var G__81515 = cljs.core.first(seq81514);
var seq81514__$1 = cljs.core.next(seq81514);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81515,seq81514__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___81623 = arguments.length;
var i__4819__auto___81624 = (0);
while(true){
if((i__4819__auto___81624 < len__4818__auto___81623)){
args__4824__auto__.push((arguments[i__4819__auto___81624]));

var G__81625 = (i__4819__auto___81624 + (1));
i__4819__auto___81624 = G__81625;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81606){
var state_val_81607 = (state_81606[(1)]);
if((state_val_81607 === (1))){
var state_81606__$1 = state_81606;
var statearr_81608_81626 = state_81606__$1;
(statearr_81608_81626[(2)] = null);

(statearr_81608_81626[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81607 === (2))){
var _ = (function (){var statearr_81609 = state_81606;
(statearr_81609[(4)] = cljs.core.cons((5),(state_81606[(4)])));

return statearr_81609;
})();
var inst_81582 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_81606__$1 = state_81606;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81606__$1,(6),inst_81582);
} else {
if((state_val_81607 === (3))){
var inst_81604 = (state_81606[(2)]);
var state_81606__$1 = state_81606;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81606__$1,inst_81604);
} else {
if((state_val_81607 === (4))){
var inst_81576 = (state_81606[(2)]);
var state_81606__$1 = state_81606;
var statearr_81611_81627 = state_81606__$1;
(statearr_81611_81627[(2)] = inst_81576);

(statearr_81611_81627[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81607 === (5))){
var _ = (function (){var statearr_81612 = state_81606;
(statearr_81612[(4)] = cljs.core.rest((state_81606[(4)])));

return statearr_81612;
})();
var state_81606__$1 = state_81606;
var ex81610 = (state_81606__$1[(2)]);
var statearr_81613_81628 = state_81606__$1;
(statearr_81613_81628[(5)] = ex81610);


if((ex81610 instanceof Error)){
var statearr_81614_81629 = state_81606__$1;
(statearr_81614_81629[(1)] = (4));

(statearr_81614_81629[(5)] = null);

} else {
throw ex81610;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81607 === (6))){
var inst_81584 = (state_81606[(2)]);
var inst_81585 = fluree.db.util.async.throw_err(inst_81584);
var inst_81586 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_81585);
var inst_81587 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81588 = [inst_81585];
var inst_81589 = (new cljs.core.PersistentVector(null,1,(5),inst_81587,inst_81588,null));
var inst_81590 = cljs.core.count(inst_81589);
var inst_81591 = ((9) + inst_81590);
var inst_81592 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81593 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81594 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81595 = [inst_81585];
var inst_81596 = (new cljs.core.PersistentVector(null,1,(5),inst_81594,inst_81595,null));
var inst_81597 = ["min",inst_81596,inst_81586];
var inst_81598 = cljs.core.PersistentHashMap.fromArrays(inst_81593,inst_81597);
var inst_81599 = [inst_81598,inst_81591];
var inst_81600 = (new cljs.core.PersistentVector(null,2,(5),inst_81592,inst_81599,null));
var inst_81601 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81600);
var _ = (function (){var statearr_81615 = state_81606;
(statearr_81615[(4)] = cljs.core.rest((state_81606[(4)])));

return statearr_81615;
})();
var state_81606__$1 = (function (){var statearr_81616 = state_81606;
(statearr_81616[(7)] = inst_81601);

return statearr_81616;
})();
var statearr_81617_81630 = state_81606__$1;
(statearr_81617_81630[(2)] = inst_81586);

(statearr_81617_81630[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81618 = [null,null,null,null,null,null,null,null];
(statearr_81618[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81618[(1)] = (1));

return statearr_81618;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81606){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81606);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81619){var ex__24301__auto__ = e81619;
var statearr_81620_81631 = state_81606;
(statearr_81620_81631[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81606[(4)]))){
var statearr_81621_81632 = state_81606;
(statearr_81621_81632[(1)] = cljs.core.first((state_81606[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81633 = state_81606;
state_81606 = G__81633;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81606){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81606);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81622 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81622[(6)] = c__24424__auto__);

return statearr_81622;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq81574){
var G__81575 = cljs.core.first(seq81574);
var seq81574__$1 = cljs.core.next(seq81574);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__81575,seq81574__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__81635 = arguments.length;
switch (G__81635) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81680){
var state_val_81681 = (state_81680[(1)]);
if((state_val_81681 === (7))){
var state_81680__$1 = state_81680;
var statearr_81682_81819 = state_81680__$1;
(statearr_81682_81819[(2)] = query_map);

(statearr_81682_81819[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (1))){
var state_81680__$1 = state_81680;
var statearr_81683_81820 = state_81680__$1;
(statearr_81683_81820[(2)] = null);

(statearr_81683_81820[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (4))){
var inst_81636 = (state_81680[(2)]);
var state_81680__$1 = state_81680;
var statearr_81684_81821 = state_81680__$1;
(statearr_81684_81821[(2)] = inst_81636);

(statearr_81684_81821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (13))){
var inst_81658 = (state_81680[(7)]);
var inst_81662 = (state_81680[(2)]);
var inst_81663 = fluree.db.util.async.throw_err(inst_81662);
var inst_81664 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81663,(0),null);
var inst_81665 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81663,(1),null);
var inst_81666 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81667 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81669 = [inst_81658];
var inst_81670 = (new cljs.core.PersistentVector(null,1,(5),inst_81668,inst_81669,null));
var inst_81671 = ["query",inst_81670,inst_81664];
var inst_81672 = cljs.core.PersistentHashMap.fromArrays(inst_81667,inst_81671);
var inst_81673 = [inst_81672,inst_81665];
var inst_81674 = (new cljs.core.PersistentVector(null,2,(5),inst_81666,inst_81673,null));
var inst_81675 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81674);
var _ = (function (){var statearr_81685 = state_81680;
(statearr_81685[(4)] = cljs.core.rest((state_81680[(4)])));

return statearr_81685;
})();
var state_81680__$1 = (function (){var statearr_81686 = state_81680;
(statearr_81686[(8)] = inst_81675);

return statearr_81686;
})();
var statearr_81687_81822 = state_81680__$1;
(statearr_81687_81822[(2)] = inst_81664);

(statearr_81687_81822[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (6))){
var state_81680__$1 = state_81680;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81680__$1,(9),query_map);
} else {
if((state_val_81681 === (3))){
var inst_81678 = (state_81680[(2)]);
var state_81680__$1 = state_81680;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81680__$1,inst_81678);
} else {
if((state_val_81681 === (12))){
var inst_81658 = (state_81680[(7)]);
var inst_81658__$1 = (state_81680[(2)]);
var inst_81659 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_81660 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_81659,inst_81658__$1);
var state_81680__$1 = (function (){var statearr_81688 = state_81680;
(statearr_81688[(7)] = inst_81658__$1);

return statearr_81688;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81680__$1,(13),inst_81660);
} else {
if((state_val_81681 === (2))){
var _ = (function (){var statearr_81689 = state_81680;
(statearr_81689[(4)] = cljs.core.cons((5),(state_81680[(4)])));

return statearr_81689;
})();
var inst_81645 = fluree.db.util.async.channel_QMARK_(query_map);
var state_81680__$1 = state_81680;
if(inst_81645){
var statearr_81690_81823 = state_81680__$1;
(statearr_81690_81823[(1)] = (6));

} else {
var statearr_81691_81824 = state_81680__$1;
(statearr_81691_81824[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (11))){
var inst_81652 = (state_81680[(9)]);
var state_81680__$1 = state_81680;
var statearr_81693_81825 = state_81680__$1;
(statearr_81693_81825[(2)] = inst_81652);

(statearr_81693_81825[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (9))){
var inst_81648 = (state_81680[(2)]);
var inst_81649 = fluree.db.util.async.throw_err(inst_81648);
var state_81680__$1 = state_81680;
var statearr_81694_81826 = state_81680__$1;
(statearr_81694_81826[(2)] = inst_81649);

(statearr_81694_81826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (5))){
var _ = (function (){var statearr_81695 = state_81680;
(statearr_81695[(4)] = cljs.core.rest((state_81680[(4)])));

return statearr_81695;
})();
var state_81680__$1 = state_81680;
var ex81692 = (state_81680__$1[(2)]);
var statearr_81696_81827 = state_81680__$1;
(statearr_81696_81827[(5)] = ex81692);


if((ex81692 instanceof Error)){
var statearr_81697_81828 = state_81680__$1;
(statearr_81697_81828[(1)] = (4));

(statearr_81697_81828[(5)] = null);

} else {
throw ex81692;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (10))){
var inst_81652 = (state_81680[(9)]);
var inst_81655 = fluree.db.util.json.parse(inst_81652);
var state_81680__$1 = state_81680;
var statearr_81698_81829 = state_81680__$1;
(statearr_81698_81829[(2)] = inst_81655);

(statearr_81698_81829[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81681 === (8))){
var inst_81652 = (state_81680[(9)]);
var inst_81652__$1 = (state_81680[(2)]);
var inst_81653 = typeof inst_81652__$1 === 'string';
var state_81680__$1 = (function (){var statearr_81699 = state_81680;
(statearr_81699[(9)] = inst_81652__$1);

return statearr_81699;
})();
if(cljs.core.truth_(inst_81653)){
var statearr_81700_81830 = state_81680__$1;
(statearr_81700_81830[(1)] = (10));

} else {
var statearr_81701_81831 = state_81680__$1;
(statearr_81701_81831[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81702 = [null,null,null,null,null,null,null,null,null,null];
(statearr_81702[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81702[(1)] = (1));

return statearr_81702;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81680){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81680);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81703){var ex__24301__auto__ = e81703;
var statearr_81704_81832 = state_81680;
(statearr_81704_81832[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81680[(4)]))){
var statearr_81705_81833 = state_81680;
(statearr_81705_81833[(1)] = cljs.core.first((state_81680[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81834 = state_81680;
state_81680 = G__81834;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81680){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81680);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81706 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81706[(6)] = c__24424__auto__);

return statearr_81706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81777){
var state_val_81778 = (state_81777[(1)]);
if((state_val_81778 === (7))){
var state_81777__$1 = state_81777;
var statearr_81779_81835 = state_81777__$1;
(statearr_81779_81835[(2)] = select);

(statearr_81779_81835[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (20))){
var inst_81747 = (state_81777[(2)]);
var inst_81748 = fluree.db.util.async.channel_QMARK_(limit);
var state_81777__$1 = (function (){var statearr_81780 = state_81777;
(statearr_81780[(7)] = inst_81747);

return statearr_81780;
})();
if(inst_81748){
var statearr_81781_81836 = state_81777__$1;
(statearr_81781_81836[(1)] = (22));

} else {
var statearr_81782_81837 = state_81777__$1;
(statearr_81782_81837[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (1))){
var state_81777__$1 = state_81777;
var statearr_81783_81838 = state_81777__$1;
(statearr_81783_81838[(2)] = null);

(statearr_81783_81838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (24))){
var inst_81731 = (state_81777[(8)]);
var inst_81723 = (state_81777[(9)]);
var inst_81739 = (state_81777[(10)]);
var inst_81747 = (state_81777[(7)]);
var inst_81755 = (state_81777[(2)]);
var inst_81756 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_81757 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_81756,inst_81723,inst_81731,inst_81739,inst_81747,inst_81755);
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(26),inst_81757);
} else {
if((state_val_81778 === (4))){
var inst_81707 = (state_81777[(2)]);
var state_81777__$1 = state_81777;
var statearr_81784_81839 = state_81777__$1;
(statearr_81784_81839[(2)] = inst_81707);

(statearr_81784_81839[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (15))){
var state_81777__$1 = state_81777;
var statearr_81785_81840 = state_81777__$1;
(statearr_81785_81840[(2)] = where);

(statearr_81785_81840[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (21))){
var inst_81743 = (state_81777[(2)]);
var inst_81744 = fluree.db.util.async.throw_err(inst_81743);
var state_81777__$1 = state_81777;
var statearr_81786_81841 = state_81777__$1;
(statearr_81786_81841[(2)] = inst_81744);

(statearr_81786_81841[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (13))){
var inst_81727 = (state_81777[(2)]);
var inst_81728 = fluree.db.util.async.throw_err(inst_81727);
var state_81777__$1 = state_81777;
var statearr_81787_81842 = state_81777__$1;
(statearr_81787_81842[(2)] = inst_81728);

(statearr_81787_81842[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (22))){
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(25),limit);
} else {
if((state_val_81778 === (6))){
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(9),select);
} else {
if((state_val_81778 === (25))){
var inst_81751 = (state_81777[(2)]);
var inst_81752 = fluree.db.util.async.throw_err(inst_81751);
var state_81777__$1 = state_81777;
var statearr_81788_81843 = state_81777__$1;
(statearr_81788_81843[(2)] = inst_81752);

(statearr_81788_81843[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (17))){
var inst_81735 = (state_81777[(2)]);
var inst_81736 = fluree.db.util.async.throw_err(inst_81735);
var state_81777__$1 = state_81777;
var statearr_81789_81844 = state_81777__$1;
(statearr_81789_81844[(2)] = inst_81736);

(statearr_81789_81844[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (3))){
var inst_81775 = (state_81777[(2)]);
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81777__$1,inst_81775);
} else {
if((state_val_81778 === (12))){
var inst_81731 = (state_81777[(2)]);
var inst_81732 = fluree.db.util.async.channel_QMARK_(where);
var state_81777__$1 = (function (){var statearr_81790 = state_81777;
(statearr_81790[(8)] = inst_81731);

return statearr_81790;
})();
if(inst_81732){
var statearr_81791_81845 = state_81777__$1;
(statearr_81791_81845[(1)] = (14));

} else {
var statearr_81792_81846 = state_81777__$1;
(statearr_81792_81846[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (2))){
var _ = (function (){var statearr_81793 = state_81777;
(statearr_81793[(4)] = cljs.core.cons((5),(state_81777[(4)])));

return statearr_81793;
})();
var inst_81716 = fluree.db.util.async.channel_QMARK_(select);
var state_81777__$1 = state_81777;
if(inst_81716){
var statearr_81794_81847 = state_81777__$1;
(statearr_81794_81847[(1)] = (6));

} else {
var statearr_81795_81848 = state_81777__$1;
(statearr_81795_81848[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (23))){
var state_81777__$1 = state_81777;
var statearr_81796_81849 = state_81777__$1;
(statearr_81796_81849[(2)] = limit);

(statearr_81796_81849[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (19))){
var state_81777__$1 = state_81777;
var statearr_81797_81850 = state_81777__$1;
(statearr_81797_81850[(2)] = block);

(statearr_81797_81850[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (11))){
var state_81777__$1 = state_81777;
var statearr_81799_81851 = state_81777__$1;
(statearr_81799_81851[(2)] = from);

(statearr_81799_81851[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (9))){
var inst_81719 = (state_81777[(2)]);
var inst_81720 = fluree.db.util.async.throw_err(inst_81719);
var state_81777__$1 = state_81777;
var statearr_81800_81852 = state_81777__$1;
(statearr_81800_81852[(2)] = inst_81720);

(statearr_81800_81852[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (5))){
var _ = (function (){var statearr_81801 = state_81777;
(statearr_81801[(4)] = cljs.core.rest((state_81777[(4)])));

return statearr_81801;
})();
var state_81777__$1 = state_81777;
var ex81798 = (state_81777__$1[(2)]);
var statearr_81802_81853 = state_81777__$1;
(statearr_81802_81853[(5)] = ex81798);


if((ex81798 instanceof Error)){
var statearr_81803_81854 = state_81777__$1;
(statearr_81803_81854[(1)] = (4));

(statearr_81803_81854[(5)] = null);

} else {
throw ex81798;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (14))){
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(17),where);
} else {
if((state_val_81778 === (26))){
var inst_81731 = (state_81777[(8)]);
var inst_81723 = (state_81777[(9)]);
var inst_81739 = (state_81777[(10)]);
var inst_81747 = (state_81777[(7)]);
var inst_81759 = (state_81777[(2)]);
var inst_81760 = fluree.db.util.async.throw_err(inst_81759);
var inst_81761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81760,(0),null);
var inst_81762 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81760,(1),null);
var inst_81763 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81764 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81765 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81766 = [inst_81723,inst_81731,inst_81739,inst_81747];
var inst_81767 = (new cljs.core.PersistentVector(null,4,(5),inst_81765,inst_81766,null));
var inst_81768 = ["query",inst_81767,inst_81761];
var inst_81769 = cljs.core.PersistentHashMap.fromArrays(inst_81764,inst_81768);
var inst_81770 = [inst_81769,inst_81762];
var inst_81771 = (new cljs.core.PersistentVector(null,2,(5),inst_81763,inst_81770,null));
var inst_81772 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81771);
var _ = (function (){var statearr_81804 = state_81777;
(statearr_81804[(4)] = cljs.core.rest((state_81777[(4)])));

return statearr_81804;
})();
var state_81777__$1 = (function (){var statearr_81805 = state_81777;
(statearr_81805[(11)] = inst_81772);

return statearr_81805;
})();
var statearr_81806_81855 = state_81777__$1;
(statearr_81806_81855[(2)] = inst_81761);

(statearr_81806_81855[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (16))){
var inst_81739 = (state_81777[(2)]);
var inst_81740 = fluree.db.util.async.channel_QMARK_(block);
var state_81777__$1 = (function (){var statearr_81807 = state_81777;
(statearr_81807[(10)] = inst_81739);

return statearr_81807;
})();
if(inst_81740){
var statearr_81808_81856 = state_81777__$1;
(statearr_81808_81856[(1)] = (18));

} else {
var statearr_81809_81857 = state_81777__$1;
(statearr_81809_81857[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81778 === (10))){
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(13),from);
} else {
if((state_val_81778 === (18))){
var state_81777__$1 = state_81777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81777__$1,(21),block);
} else {
if((state_val_81778 === (8))){
var inst_81723 = (state_81777[(2)]);
var inst_81724 = fluree.db.util.async.channel_QMARK_(from);
var state_81777__$1 = (function (){var statearr_81810 = state_81777;
(statearr_81810[(9)] = inst_81723);

return statearr_81810;
})();
if(inst_81724){
var statearr_81811_81858 = state_81777__$1;
(statearr_81811_81858[(1)] = (10));

} else {
var statearr_81812_81859 = state_81777__$1;
(statearr_81812_81859[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_81813 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81813[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_81813[(1)] = (1));

return statearr_81813;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_81777){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81777);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81814){var ex__24301__auto__ = e81814;
var statearr_81815_81860 = state_81777;
(statearr_81815_81860[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81777[(4)]))){
var statearr_81816_81861 = state_81777;
(statearr_81816_81861[(1)] = cljs.core.first((state_81777[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81862 = state_81777;
state_81777 = G__81862;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_81777){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_81777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81817 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81817[(6)] = c__24424__auto__);

return statearr_81817;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_81918){
var state_val_81919 = (state_81918[(1)]);
if((state_val_81919 === (7))){
var state_81918__$1 = state_81918;
var statearr_81920_81951 = state_81918__$1;
(statearr_81920_81951[(2)] = startSubject);

(statearr_81920_81951[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (1))){
var state_81918__$1 = state_81918;
var statearr_81921_81952 = state_81918__$1;
(statearr_81921_81952[(2)] = null);

(statearr_81921_81952[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (4))){
var inst_81863 = (state_81918[(2)]);
var state_81918__$1 = state_81918;
var statearr_81922_81953 = state_81918__$1;
(statearr_81922_81953[(2)] = inst_81863);

(statearr_81922_81953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (15))){
var inst_81895 = (state_81918[(2)]);
var inst_81896 = fluree.db.util.async.throw_err(inst_81895);
var inst_81897 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81896,(0),null);
var inst_81898 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81896,(1),null);
var inst_81899 = cljs.core.empty_QMARK_(inst_81897);
var state_81918__$1 = (function (){var statearr_81923 = state_81918;
(statearr_81923[(7)] = inst_81898);

return statearr_81923;
})();
if(inst_81899){
var statearr_81924_81954 = state_81918__$1;
(statearr_81924_81954[(1)] = (16));

} else {
var statearr_81925_81955 = state_81918__$1;
(statearr_81925_81955[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (13))){
var inst_81879 = (state_81918[(8)]);
var inst_81891 = (state_81918[(9)]);
var inst_81883 = (state_81918[(10)]);
var inst_81891__$1 = (state_81918[(2)]);
var inst_81892 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_81893 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_81892,inst_81879,inst_81883,inst_81891__$1);
var state_81918__$1 = (function (){var statearr_81926 = state_81918;
(statearr_81926[(9)] = inst_81891__$1);

return statearr_81926;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81918__$1,(15),inst_81893);
} else {
if((state_val_81919 === (6))){
var state_81918__$1 = state_81918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81918__$1,(9),startSubject);
} else {
if((state_val_81919 === (17))){
var state_81918__$1 = state_81918;
var statearr_81927_81956 = state_81918__$1;
(statearr_81927_81956[(2)] = true);

(statearr_81927_81956[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (3))){
var inst_81916 = (state_81918[(2)]);
var state_81918__$1 = state_81918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_81918__$1,inst_81916);
} else {
if((state_val_81919 === (12))){
var state_81918__$1 = state_81918;
var statearr_81928_81957 = state_81918__$1;
(statearr_81928_81957[(2)] = endSubject);

(statearr_81928_81957[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (2))){
var _ = (function (){var statearr_81929 = state_81918;
(statearr_81929[(4)] = cljs.core.cons((5),(state_81918[(4)])));

return statearr_81929;
})();
var inst_81872 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_81918__$1 = state_81918;
if(inst_81872){
var statearr_81930_81958 = state_81918__$1;
(statearr_81930_81958[(1)] = (6));

} else {
var statearr_81931_81959 = state_81918__$1;
(statearr_81931_81959[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (11))){
var state_81918__$1 = state_81918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81918__$1,(14),endSubject);
} else {
if((state_val_81919 === (9))){
var inst_81875 = (state_81918[(2)]);
var inst_81876 = fluree.db.util.async.throw_err(inst_81875);
var state_81918__$1 = state_81918;
var statearr_81933_81960 = state_81918__$1;
(statearr_81933_81960[(2)] = inst_81876);

(statearr_81933_81960[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (5))){
var _ = (function (){var statearr_81934 = state_81918;
(statearr_81934[(4)] = cljs.core.rest((state_81918[(4)])));

return statearr_81934;
})();
var state_81918__$1 = state_81918;
var ex81932 = (state_81918__$1[(2)]);
var statearr_81935_81961 = state_81918__$1;
(statearr_81935_81961[(5)] = ex81932);


if((ex81932 instanceof Error)){
var statearr_81936_81962 = state_81918__$1;
(statearr_81936_81962[(1)] = (4));

(statearr_81936_81962[(5)] = null);

} else {
throw ex81932;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (14))){
var inst_81887 = (state_81918[(2)]);
var inst_81888 = fluree.db.util.async.throw_err(inst_81887);
var state_81918__$1 = state_81918;
var statearr_81937_81963 = state_81918__$1;
(statearr_81937_81963[(2)] = inst_81888);

(statearr_81937_81963[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (16))){
var state_81918__$1 = state_81918;
var statearr_81938_81964 = state_81918__$1;
(statearr_81938_81964[(2)] = false);

(statearr_81938_81964[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (10))){
var inst_81882 = (state_81918[(2)]);
var inst_81883 = fluree.db.util.async.throw_err(inst_81882);
var inst_81884 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_81918__$1 = (function (){var statearr_81939 = state_81918;
(statearr_81939[(10)] = inst_81883);

return statearr_81939;
})();
if(inst_81884){
var statearr_81940_81965 = state_81918__$1;
(statearr_81940_81965[(1)] = (11));

} else {
var statearr_81941_81966 = state_81918__$1;
(statearr_81941_81966[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (18))){
var inst_81898 = (state_81918[(7)]);
var inst_81879 = (state_81918[(8)]);
var inst_81891 = (state_81918[(9)]);
var inst_81883 = (state_81918[(10)]);
var inst_81903 = (state_81918[(2)]);
var inst_81904 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81905 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81906 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81907 = [inst_81879,inst_81883,inst_81891];
var inst_81908 = (new cljs.core.PersistentVector(null,3,(5),inst_81906,inst_81907,null));
var inst_81909 = ["relationship?",inst_81908,inst_81903];
var inst_81910 = cljs.core.PersistentHashMap.fromArrays(inst_81905,inst_81909);
var inst_81911 = [inst_81910,inst_81898];
var inst_81912 = (new cljs.core.PersistentVector(null,2,(5),inst_81904,inst_81911,null));
var inst_81913 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_81912);
var _ = (function (){var statearr_81942 = state_81918;
(statearr_81942[(4)] = cljs.core.rest((state_81918[(4)])));

return statearr_81942;
})();
var state_81918__$1 = (function (){var statearr_81943 = state_81918;
(statearr_81943[(11)] = inst_81913);

return statearr_81943;
})();
var statearr_81944_81967 = state_81918__$1;
(statearr_81944_81967[(2)] = inst_81903);

(statearr_81944_81967[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_81919 === (8))){
var inst_81879 = (state_81918[(2)]);
var inst_81880 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_81918__$1 = (function (){var statearr_81945 = state_81918;
(statearr_81945[(8)] = inst_81879);

return statearr_81945;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_81918__$1,(10),inst_81880);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_81946 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_81946[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__);

(statearr_81946[(1)] = (1));

return statearr_81946;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____1 = (function (state_81918){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_81918);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e81947){var ex__24301__auto__ = e81947;
var statearr_81948_81968 = state_81918;
(statearr_81948_81968[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_81918[(4)]))){
var statearr_81949_81969 = state_81918;
(statearr_81949_81969[(1)] = cljs.core.first((state_81918[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__81970 = state_81918;
state_81918 = G__81970;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__ = function(state_81918){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____1.call(this,state_81918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_81950 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_81950[(6)] = c__24424__auto__);

return statearr_81950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82007){
var state_val_82008 = (state_82007[(1)]);
if((state_val_82008 === (7))){
var state_82007__$1 = state_82007;
var statearr_82009_82029 = state_82007__$1;
(statearr_82009_82029[(2)] = pred_name);

(statearr_82009_82029[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (1))){
var state_82007__$1 = state_82007;
var statearr_82010_82030 = state_82007__$1;
(statearr_82010_82030[(2)] = null);

(statearr_82010_82030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (4))){
var inst_81971 = (state_82007[(2)]);
var state_82007__$1 = state_82007;
var statearr_82011_82031 = state_82007__$1;
(statearr_82011_82031[(2)] = inst_81971);

(statearr_82011_82031[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (6))){
var state_82007__$1 = state_82007;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82007__$1,(9),pred_name);
} else {
if((state_val_82008 === (3))){
var inst_82005 = (state_82007[(2)]);
var state_82007__$1 = state_82007;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82007__$1,inst_82005);
} else {
if((state_val_82008 === (2))){
var _ = (function (){var statearr_82013 = state_82007;
(statearr_82013[(4)] = cljs.core.cons((5),(state_82007[(4)])));

return statearr_82013;
})();
var inst_81980 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_82007__$1 = state_82007;
if(inst_81980){
var statearr_82014_82032 = state_82007__$1;
(statearr_82014_82032[(1)] = (6));

} else {
var statearr_82015_82033 = state_82007__$1;
(statearr_82015_82033[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (9))){
var inst_81983 = (state_82007[(2)]);
var inst_81984 = fluree.db.util.async.throw_err(inst_81983);
var state_82007__$1 = state_82007;
var statearr_82016_82034 = state_82007__$1;
(statearr_82016_82034[(2)] = inst_81984);

(statearr_82016_82034[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (5))){
var _ = (function (){var statearr_82017 = state_82007;
(statearr_82017[(4)] = cljs.core.rest((state_82007[(4)])));

return statearr_82017;
})();
var state_82007__$1 = state_82007;
var ex82012 = (state_82007__$1[(2)]);
var statearr_82018_82035 = state_82007__$1;
(statearr_82018_82035[(5)] = ex82012);


if((ex82012 instanceof Error)){
var statearr_82019_82036 = state_82007__$1;
(statearr_82019_82036[(1)] = (4));

(statearr_82019_82036[(5)] = null);

} else {
throw ex82012;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (10))){
var inst_81987 = (state_82007[(7)]);
var inst_81991 = (state_82007[(2)]);
var inst_81992 = fluree.db.util.async.throw_err(inst_81991);
var inst_81993 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81992,(0),null);
var inst_81994 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_81992,(1),null);
var inst_81995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_81996 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_81997 = ["max-pred-val",inst_81987,inst_81993];
var inst_81998 = cljs.core.PersistentHashMap.fromArrays(inst_81996,inst_81997);
var inst_81999 = (inst_81994 + (10));
var inst_82000 = [inst_81998,inst_81999];
var inst_82001 = (new cljs.core.PersistentVector(null,2,(5),inst_81995,inst_82000,null));
var inst_82002 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82001);
var _ = (function (){var statearr_82020 = state_82007;
(statearr_82020[(4)] = cljs.core.rest((state_82007[(4)])));

return statearr_82020;
})();
var state_82007__$1 = (function (){var statearr_82021 = state_82007;
(statearr_82021[(8)] = inst_82002);

return statearr_82021;
})();
var statearr_82022_82037 = state_82007__$1;
(statearr_82022_82037[(2)] = inst_81993);

(statearr_82022_82037[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82008 === (8))){
var inst_81987 = (state_82007[(7)]);
var inst_81987__$1 = (state_82007[(2)]);
var inst_81988 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_81989 = fluree.db.dbfunctions.internal.max_pred_val(inst_81988,inst_81987__$1,null);
var state_82007__$1 = (function (){var statearr_82023 = state_82007;
(statearr_82023[(7)] = inst_81987__$1);

return statearr_82023;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82007__$1,(10),inst_81989);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____0 = (function (){
var statearr_82024 = [null,null,null,null,null,null,null,null,null];
(statearr_82024[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__);

(statearr_82024[(1)] = (1));

return statearr_82024;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____1 = (function (state_82007){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82007);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82025){var ex__24301__auto__ = e82025;
var statearr_82026_82038 = state_82007;
(statearr_82026_82038[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82007[(4)]))){
var statearr_82027_82039 = state_82007;
(statearr_82027_82039[(1)] = cljs.core.first((state_82007[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82040 = state_82007;
state_82007 = G__82040;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__ = function(state_82007){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____1.call(this,state_82007);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82028 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82028[(6)] = c__24424__auto__);

return statearr_82028;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82067){
var state_val_82068 = (state_82067[(1)]);
if((state_val_82068 === (7))){
var state_82067__$1 = state_82067;
var statearr_82069_82088 = state_82067__$1;
(statearr_82069_82088[(2)] = n);

(statearr_82069_82088[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (1))){
var state_82067__$1 = state_82067;
var statearr_82070_82089 = state_82067__$1;
(statearr_82070_82089[(2)] = null);

(statearr_82070_82089[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (4))){
var inst_82041 = (state_82067[(2)]);
var state_82067__$1 = state_82067;
var statearr_82071_82090 = state_82067__$1;
(statearr_82071_82090[(2)] = inst_82041);

(statearr_82071_82090[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (6))){
var state_82067__$1 = state_82067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82067__$1,(9),n);
} else {
if((state_val_82068 === (3))){
var inst_82065 = (state_82067[(2)]);
var state_82067__$1 = state_82067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82067__$1,inst_82065);
} else {
if((state_val_82068 === (2))){
var _ = (function (){var statearr_82073 = state_82067;
(statearr_82073[(4)] = cljs.core.cons((5),(state_82067[(4)])));

return statearr_82073;
})();
var inst_82047 = fluree.db.util.async.channel_QMARK_(n);
var state_82067__$1 = state_82067;
if(inst_82047){
var statearr_82074_82091 = state_82067__$1;
(statearr_82074_82091[(1)] = (6));

} else {
var statearr_82075_82092 = state_82067__$1;
(statearr_82075_82092[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (9))){
var inst_82050 = (state_82067[(2)]);
var inst_82051 = fluree.db.util.async.throw_err(inst_82050);
var state_82067__$1 = state_82067;
var statearr_82076_82093 = state_82067__$1;
(statearr_82076_82093[(2)] = inst_82051);

(statearr_82076_82093[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (5))){
var _ = (function (){var statearr_82077 = state_82067;
(statearr_82077[(4)] = cljs.core.rest((state_82067[(4)])));

return statearr_82077;
})();
var state_82067__$1 = state_82067;
var ex82072 = (state_82067__$1[(2)]);
var statearr_82078_82094 = state_82067__$1;
(statearr_82078_82094[(5)] = ex82072);


if((ex82072 instanceof Error)){
var statearr_82079_82095 = state_82067__$1;
(statearr_82079_82095[(1)] = (4));

(statearr_82079_82095[(5)] = null);

} else {
throw ex82072;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82068 === (8))){
var inst_82054 = (state_82067[(2)]);
var inst_82055 = fluree.db.dbfunctions.internal.inc(inst_82054);
var inst_82056 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82057 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82058 = ["inc",inst_82054,inst_82055];
var inst_82059 = cljs.core.PersistentHashMap.fromArrays(inst_82057,inst_82058);
var inst_82060 = [inst_82059,(10)];
var inst_82061 = (new cljs.core.PersistentVector(null,2,(5),inst_82056,inst_82060,null));
var inst_82062 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82061);
var _ = (function (){var statearr_82080 = state_82067;
(statearr_82080[(4)] = cljs.core.rest((state_82067[(4)])));

return statearr_82080;
})();
var state_82067__$1 = (function (){var statearr_82081 = state_82067;
(statearr_82081[(7)] = inst_82062);

return statearr_82081;
})();
var statearr_82082_82096 = state_82067__$1;
(statearr_82082_82096[(2)] = inst_82055);

(statearr_82082_82096[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____0 = (function (){
var statearr_82083 = [null,null,null,null,null,null,null,null];
(statearr_82083[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__);

(statearr_82083[(1)] = (1));

return statearr_82083;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____1 = (function (state_82067){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82067);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82084){var ex__24301__auto__ = e82084;
var statearr_82085_82097 = state_82067;
(statearr_82085_82097[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82067[(4)]))){
var statearr_82086_82098 = state_82067;
(statearr_82086_82098[(1)] = cljs.core.first((state_82067[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82099 = state_82067;
state_82067 = G__82099;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__ = function(state_82067){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____1.call(this,state_82067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82087 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82087[(6)] = c__24424__auto__);

return statearr_82087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82126){
var state_val_82127 = (state_82126[(1)]);
if((state_val_82127 === (7))){
var state_82126__$1 = state_82126;
var statearr_82128_82147 = state_82126__$1;
(statearr_82128_82147[(2)] = n);

(statearr_82128_82147[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (1))){
var state_82126__$1 = state_82126;
var statearr_82129_82148 = state_82126__$1;
(statearr_82129_82148[(2)] = null);

(statearr_82129_82148[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (4))){
var inst_82100 = (state_82126[(2)]);
var state_82126__$1 = state_82126;
var statearr_82130_82149 = state_82126__$1;
(statearr_82130_82149[(2)] = inst_82100);

(statearr_82130_82149[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (6))){
var state_82126__$1 = state_82126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82126__$1,(9),n);
} else {
if((state_val_82127 === (3))){
var inst_82124 = (state_82126[(2)]);
var state_82126__$1 = state_82126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82126__$1,inst_82124);
} else {
if((state_val_82127 === (2))){
var _ = (function (){var statearr_82132 = state_82126;
(statearr_82132[(4)] = cljs.core.cons((5),(state_82126[(4)])));

return statearr_82132;
})();
var inst_82106 = fluree.db.util.async.channel_QMARK_(n);
var state_82126__$1 = state_82126;
if(inst_82106){
var statearr_82133_82150 = state_82126__$1;
(statearr_82133_82150[(1)] = (6));

} else {
var statearr_82134_82151 = state_82126__$1;
(statearr_82134_82151[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (9))){
var inst_82109 = (state_82126[(2)]);
var inst_82110 = fluree.db.util.async.throw_err(inst_82109);
var state_82126__$1 = state_82126;
var statearr_82135_82152 = state_82126__$1;
(statearr_82135_82152[(2)] = inst_82110);

(statearr_82135_82152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (5))){
var _ = (function (){var statearr_82136 = state_82126;
(statearr_82136[(4)] = cljs.core.rest((state_82126[(4)])));

return statearr_82136;
})();
var state_82126__$1 = state_82126;
var ex82131 = (state_82126__$1[(2)]);
var statearr_82137_82153 = state_82126__$1;
(statearr_82137_82153[(5)] = ex82131);


if((ex82131 instanceof Error)){
var statearr_82138_82154 = state_82126__$1;
(statearr_82138_82154[(1)] = (4));

(statearr_82138_82154[(5)] = null);

} else {
throw ex82131;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82127 === (8))){
var inst_82113 = (state_82126[(2)]);
var inst_82114 = fluree.db.dbfunctions.internal.dec(inst_82113);
var inst_82115 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82116 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82117 = ["dec",inst_82113,inst_82114];
var inst_82118 = cljs.core.PersistentHashMap.fromArrays(inst_82116,inst_82117);
var inst_82119 = [inst_82118,(10)];
var inst_82120 = (new cljs.core.PersistentVector(null,2,(5),inst_82115,inst_82119,null));
var inst_82121 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82120);
var _ = (function (){var statearr_82139 = state_82126;
(statearr_82139[(4)] = cljs.core.rest((state_82126[(4)])));

return statearr_82139;
})();
var state_82126__$1 = (function (){var statearr_82140 = state_82126;
(statearr_82140[(7)] = inst_82121);

return statearr_82140;
})();
var statearr_82141_82155 = state_82126__$1;
(statearr_82141_82155[(2)] = inst_82114);

(statearr_82141_82155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____0 = (function (){
var statearr_82142 = [null,null,null,null,null,null,null,null];
(statearr_82142[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__);

(statearr_82142[(1)] = (1));

return statearr_82142;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____1 = (function (state_82126){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82126);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82143){var ex__24301__auto__ = e82143;
var statearr_82144_82156 = state_82126;
(statearr_82144_82156[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82126[(4)]))){
var statearr_82145_82157 = state_82126;
(statearr_82145_82157[(1)] = cljs.core.first((state_82126[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82158 = state_82126;
state_82126 = G__82158;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__ = function(state_82126){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____1.call(this,state_82126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82146 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82146[(6)] = c__24424__auto__);

return statearr_82146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82208 = arguments.length;
var i__4819__auto___82209 = (0);
while(true){
if((i__4819__auto___82209 < len__4818__auto___82208)){
args__4824__auto__.push((arguments[i__4819__auto___82209]));

var G__82210 = (i__4819__auto___82209 + (1));
i__4819__auto___82209 = G__82210;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82191){
var state_val_82192 = (state_82191[(1)]);
if((state_val_82192 === (1))){
var state_82191__$1 = state_82191;
var statearr_82193_82211 = state_82191__$1;
(statearr_82193_82211[(2)] = null);

(statearr_82193_82211[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82192 === (2))){
var _ = (function (){var statearr_82194 = state_82191;
(statearr_82194[(4)] = cljs.core.cons((5),(state_82191[(4)])));

return statearr_82194;
})();
var inst_82167 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82191__$1 = state_82191;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82191__$1,(6),inst_82167);
} else {
if((state_val_82192 === (3))){
var inst_82189 = (state_82191[(2)]);
var state_82191__$1 = state_82191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82191__$1,inst_82189);
} else {
if((state_val_82192 === (4))){
var inst_82161 = (state_82191[(2)]);
var state_82191__$1 = state_82191;
var statearr_82196_82212 = state_82191__$1;
(statearr_82196_82212[(2)] = inst_82161);

(statearr_82196_82212[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82192 === (5))){
var _ = (function (){var statearr_82197 = state_82191;
(statearr_82197[(4)] = cljs.core.rest((state_82191[(4)])));

return statearr_82197;
})();
var state_82191__$1 = state_82191;
var ex82195 = (state_82191__$1[(2)]);
var statearr_82198_82213 = state_82191__$1;
(statearr_82198_82213[(5)] = ex82195);


if((ex82195 instanceof Error)){
var statearr_82199_82214 = state_82191__$1;
(statearr_82199_82214[(1)] = (4));

(statearr_82199_82214[(5)] = null);

} else {
throw ex82195;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82192 === (6))){
var inst_82169 = (state_82191[(2)]);
var inst_82170 = fluree.db.util.async.throw_err(inst_82169);
var inst_82171 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_82170);
var inst_82172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82173 = [inst_82170];
var inst_82174 = (new cljs.core.PersistentVector(null,1,(5),inst_82172,inst_82173,null));
var inst_82175 = cljs.core.count(inst_82174);
var inst_82176 = ((9) + inst_82175);
var inst_82177 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82178 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82180 = [inst_82170];
var inst_82181 = (new cljs.core.PersistentVector(null,1,(5),inst_82179,inst_82180,null));
var inst_82182 = ["+",inst_82181,inst_82171];
var inst_82183 = cljs.core.PersistentHashMap.fromArrays(inst_82178,inst_82182);
var inst_82184 = [inst_82183,inst_82176];
var inst_82185 = (new cljs.core.PersistentVector(null,2,(5),inst_82177,inst_82184,null));
var inst_82186 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82185);
var _ = (function (){var statearr_82200 = state_82191;
(statearr_82200[(4)] = cljs.core.rest((state_82191[(4)])));

return statearr_82200;
})();
var state_82191__$1 = (function (){var statearr_82201 = state_82191;
(statearr_82201[(7)] = inst_82186);

return statearr_82201;
})();
var statearr_82202_82215 = state_82191__$1;
(statearr_82202_82215[(2)] = inst_82171);

(statearr_82202_82215[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_82203 = [null,null,null,null,null,null,null,null];
(statearr_82203[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_82203[(1)] = (1));

return statearr_82203;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_82191){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82191);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82204){var ex__24301__auto__ = e82204;
var statearr_82205_82216 = state_82191;
(statearr_82205_82216[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82191[(4)]))){
var statearr_82206_82217 = state_82191;
(statearr_82206_82217[(1)] = cljs.core.first((state_82191[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82218 = state_82191;
state_82191 = G__82218;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_82191){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_82191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82207 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82207[(6)] = c__24424__auto__);

return statearr_82207;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq82159){
var G__82160 = cljs.core.first(seq82159);
var seq82159__$1 = cljs.core.next(seq82159);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82160,seq82159__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82268 = arguments.length;
var i__4819__auto___82269 = (0);
while(true){
if((i__4819__auto___82269 < len__4818__auto___82268)){
args__4824__auto__.push((arguments[i__4819__auto___82269]));

var G__82270 = (i__4819__auto___82269 + (1));
i__4819__auto___82269 = G__82270;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82251){
var state_val_82252 = (state_82251[(1)]);
if((state_val_82252 === (1))){
var state_82251__$1 = state_82251;
var statearr_82253_82271 = state_82251__$1;
(statearr_82253_82271[(2)] = null);

(statearr_82253_82271[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82252 === (2))){
var _ = (function (){var statearr_82254 = state_82251;
(statearr_82254[(4)] = cljs.core.cons((5),(state_82251[(4)])));

return statearr_82254;
})();
var inst_82227 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82251__$1 = state_82251;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82251__$1,(6),inst_82227);
} else {
if((state_val_82252 === (3))){
var inst_82249 = (state_82251[(2)]);
var state_82251__$1 = state_82251;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82251__$1,inst_82249);
} else {
if((state_val_82252 === (4))){
var inst_82221 = (state_82251[(2)]);
var state_82251__$1 = state_82251;
var statearr_82256_82272 = state_82251__$1;
(statearr_82256_82272[(2)] = inst_82221);

(statearr_82256_82272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82252 === (5))){
var _ = (function (){var statearr_82257 = state_82251;
(statearr_82257[(4)] = cljs.core.rest((state_82251[(4)])));

return statearr_82257;
})();
var state_82251__$1 = state_82251;
var ex82255 = (state_82251__$1[(2)]);
var statearr_82258_82273 = state_82251__$1;
(statearr_82258_82273[(5)] = ex82255);


if((ex82255 instanceof Error)){
var statearr_82259_82274 = state_82251__$1;
(statearr_82259_82274[(1)] = (4));

(statearr_82259_82274[(5)] = null);

} else {
throw ex82255;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82252 === (6))){
var inst_82229 = (state_82251[(2)]);
var inst_82230 = fluree.db.util.async.throw_err(inst_82229);
var inst_82231 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_82230);
var inst_82232 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82233 = [inst_82230];
var inst_82234 = (new cljs.core.PersistentVector(null,1,(5),inst_82232,inst_82233,null));
var inst_82235 = cljs.core.count(inst_82234);
var inst_82236 = ((9) + inst_82235);
var inst_82237 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82238 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82239 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82240 = [inst_82230];
var inst_82241 = (new cljs.core.PersistentVector(null,1,(5),inst_82239,inst_82240,null));
var inst_82242 = ["-",inst_82241,inst_82231];
var inst_82243 = cljs.core.PersistentHashMap.fromArrays(inst_82238,inst_82242);
var inst_82244 = [inst_82243,inst_82236];
var inst_82245 = (new cljs.core.PersistentVector(null,2,(5),inst_82237,inst_82244,null));
var inst_82246 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82245);
var _ = (function (){var statearr_82260 = state_82251;
(statearr_82260[(4)] = cljs.core.rest((state_82251[(4)])));

return statearr_82260;
})();
var state_82251__$1 = (function (){var statearr_82261 = state_82251;
(statearr_82261[(7)] = inst_82246);

return statearr_82261;
})();
var statearr_82262_82275 = state_82251__$1;
(statearr_82262_82275[(2)] = inst_82231);

(statearr_82262_82275[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_82263 = [null,null,null,null,null,null,null,null];
(statearr_82263[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_82263[(1)] = (1));

return statearr_82263;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_82251){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82251);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82264){var ex__24301__auto__ = e82264;
var statearr_82265_82276 = state_82251;
(statearr_82265_82276[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82251[(4)]))){
var statearr_82266_82277 = state_82251;
(statearr_82266_82277[(1)] = cljs.core.first((state_82251[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82278 = state_82251;
state_82251 = G__82278;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_82251){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_82251);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82267 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82267[(6)] = c__24424__auto__);

return statearr_82267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq82219){
var G__82220 = cljs.core.first(seq82219);
var seq82219__$1 = cljs.core.next(seq82219);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82220,seq82219__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82328 = arguments.length;
var i__4819__auto___82329 = (0);
while(true){
if((i__4819__auto___82329 < len__4818__auto___82328)){
args__4824__auto__.push((arguments[i__4819__auto___82329]));

var G__82330 = (i__4819__auto___82329 + (1));
i__4819__auto___82329 = G__82330;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82311){
var state_val_82312 = (state_82311[(1)]);
if((state_val_82312 === (1))){
var state_82311__$1 = state_82311;
var statearr_82313_82331 = state_82311__$1;
(statearr_82313_82331[(2)] = null);

(statearr_82313_82331[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82312 === (2))){
var _ = (function (){var statearr_82314 = state_82311;
(statearr_82314[(4)] = cljs.core.cons((5),(state_82311[(4)])));

return statearr_82314;
})();
var inst_82287 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82311__$1 = state_82311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82311__$1,(6),inst_82287);
} else {
if((state_val_82312 === (3))){
var inst_82309 = (state_82311[(2)]);
var state_82311__$1 = state_82311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82311__$1,inst_82309);
} else {
if((state_val_82312 === (4))){
var inst_82281 = (state_82311[(2)]);
var state_82311__$1 = state_82311;
var statearr_82316_82332 = state_82311__$1;
(statearr_82316_82332[(2)] = inst_82281);

(statearr_82316_82332[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82312 === (5))){
var _ = (function (){var statearr_82317 = state_82311;
(statearr_82317[(4)] = cljs.core.rest((state_82311[(4)])));

return statearr_82317;
})();
var state_82311__$1 = state_82311;
var ex82315 = (state_82311__$1[(2)]);
var statearr_82318_82333 = state_82311__$1;
(statearr_82318_82333[(5)] = ex82315);


if((ex82315 instanceof Error)){
var statearr_82319_82334 = state_82311__$1;
(statearr_82319_82334[(1)] = (4));

(statearr_82319_82334[(5)] = null);

} else {
throw ex82315;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82312 === (6))){
var inst_82289 = (state_82311[(2)]);
var inst_82290 = fluree.db.util.async.throw_err(inst_82289);
var inst_82291 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_82290);
var inst_82292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82293 = [inst_82290];
var inst_82294 = (new cljs.core.PersistentVector(null,1,(5),inst_82292,inst_82293,null));
var inst_82295 = cljs.core.count(inst_82294);
var inst_82296 = ((9) + inst_82295);
var inst_82297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82298 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82300 = [inst_82290];
var inst_82301 = (new cljs.core.PersistentVector(null,1,(5),inst_82299,inst_82300,null));
var inst_82302 = ["*",inst_82301,inst_82291];
var inst_82303 = cljs.core.PersistentHashMap.fromArrays(inst_82298,inst_82302);
var inst_82304 = [inst_82303,inst_82296];
var inst_82305 = (new cljs.core.PersistentVector(null,2,(5),inst_82297,inst_82304,null));
var inst_82306 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82305);
var _ = (function (){var statearr_82320 = state_82311;
(statearr_82320[(4)] = cljs.core.rest((state_82311[(4)])));

return statearr_82320;
})();
var state_82311__$1 = (function (){var statearr_82321 = state_82311;
(statearr_82321[(7)] = inst_82306);

return statearr_82321;
})();
var statearr_82322_82335 = state_82311__$1;
(statearr_82322_82335[(2)] = inst_82291);

(statearr_82322_82335[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_82323 = [null,null,null,null,null,null,null,null];
(statearr_82323[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_82323[(1)] = (1));

return statearr_82323;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_82311){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82311);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82324){var ex__24301__auto__ = e82324;
var statearr_82325_82336 = state_82311;
(statearr_82325_82336[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82311[(4)]))){
var statearr_82326_82337 = state_82311;
(statearr_82326_82337[(1)] = cljs.core.first((state_82311[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82338 = state_82311;
state_82311 = G__82338;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_82311){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_82311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82327 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82327[(6)] = c__24424__auto__);

return statearr_82327;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq82279){
var G__82280 = cljs.core.first(seq82279);
var seq82279__$1 = cljs.core.next(seq82279);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82280,seq82279__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___82388 = arguments.length;
var i__4819__auto___82389 = (0);
while(true){
if((i__4819__auto___82389 < len__4818__auto___82388)){
args__4824__auto__.push((arguments[i__4819__auto___82389]));

var G__82390 = (i__4819__auto___82389 + (1));
i__4819__auto___82389 = G__82390;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82371){
var state_val_82372 = (state_82371[(1)]);
if((state_val_82372 === (1))){
var state_82371__$1 = state_82371;
var statearr_82373_82391 = state_82371__$1;
(statearr_82373_82391[(2)] = null);

(statearr_82373_82391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82372 === (2))){
var _ = (function (){var statearr_82374 = state_82371;
(statearr_82374[(4)] = cljs.core.cons((5),(state_82371[(4)])));

return statearr_82374;
})();
var inst_82347 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_82371__$1 = state_82371;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82371__$1,(6),inst_82347);
} else {
if((state_val_82372 === (3))){
var inst_82369 = (state_82371[(2)]);
var state_82371__$1 = state_82371;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82371__$1,inst_82369);
} else {
if((state_val_82372 === (4))){
var inst_82341 = (state_82371[(2)]);
var state_82371__$1 = state_82371;
var statearr_82376_82392 = state_82371__$1;
(statearr_82376_82392[(2)] = inst_82341);

(statearr_82376_82392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82372 === (5))){
var _ = (function (){var statearr_82377 = state_82371;
(statearr_82377[(4)] = cljs.core.rest((state_82371[(4)])));

return statearr_82377;
})();
var state_82371__$1 = state_82371;
var ex82375 = (state_82371__$1[(2)]);
var statearr_82378_82393 = state_82371__$1;
(statearr_82378_82393[(5)] = ex82375);


if((ex82375 instanceof Error)){
var statearr_82379_82394 = state_82371__$1;
(statearr_82379_82394[(1)] = (4));

(statearr_82379_82394[(5)] = null);

} else {
throw ex82375;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82372 === (6))){
var inst_82349 = (state_82371[(2)]);
var inst_82350 = fluree.db.util.async.throw_err(inst_82349);
var inst_82351 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_82350);
var inst_82352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82353 = [inst_82350];
var inst_82354 = (new cljs.core.PersistentVector(null,1,(5),inst_82352,inst_82353,null));
var inst_82355 = cljs.core.count(inst_82354);
var inst_82356 = ((9) + inst_82355);
var inst_82357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82358 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82359 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82360 = [inst_82350];
var inst_82361 = (new cljs.core.PersistentVector(null,1,(5),inst_82359,inst_82360,null));
var inst_82362 = ["/",inst_82361,inst_82351];
var inst_82363 = cljs.core.PersistentHashMap.fromArrays(inst_82358,inst_82362);
var inst_82364 = [inst_82363,inst_82356];
var inst_82365 = (new cljs.core.PersistentVector(null,2,(5),inst_82357,inst_82364,null));
var inst_82366 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82365);
var _ = (function (){var statearr_82380 = state_82371;
(statearr_82380[(4)] = cljs.core.rest((state_82371[(4)])));

return statearr_82380;
})();
var state_82371__$1 = (function (){var statearr_82381 = state_82371;
(statearr_82381[(7)] = inst_82366);

return statearr_82381;
})();
var statearr_82382_82395 = state_82371__$1;
(statearr_82382_82395[(2)] = inst_82351);

(statearr_82382_82395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_82383 = [null,null,null,null,null,null,null,null];
(statearr_82383[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_82383[(1)] = (1));

return statearr_82383;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_82371){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82371);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82384){var ex__24301__auto__ = e82384;
var statearr_82385_82396 = state_82371;
(statearr_82385_82396[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82371[(4)]))){
var statearr_82386_82397 = state_82371;
(statearr_82386_82397[(1)] = cljs.core.first((state_82371[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82398 = state_82371;
state_82371 = G__82398;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_82371){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_82371);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82387 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82387[(6)] = c__24424__auto__);

return statearr_82387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq82339){
var G__82340 = cljs.core.first(seq82339);
var seq82339__$1 = cljs.core.next(seq82339);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__82340,seq82339__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82436){
var state_val_82437 = (state_82436[(1)]);
if((state_val_82437 === (7))){
var state_82436__$1 = state_82436;
var statearr_82438_82462 = state_82436__$1;
(statearr_82438_82462[(2)] = n);

(statearr_82438_82462[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (1))){
var state_82436__$1 = state_82436;
var statearr_82439_82463 = state_82436__$1;
(statearr_82439_82463[(2)] = null);

(statearr_82439_82463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (4))){
var inst_82399 = (state_82436[(2)]);
var state_82436__$1 = state_82436;
var statearr_82440_82464 = state_82436__$1;
(statearr_82440_82464[(2)] = inst_82399);

(statearr_82440_82464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (13))){
var inst_82416 = (state_82436[(2)]);
var inst_82417 = fluree.db.util.async.throw_err(inst_82416);
var state_82436__$1 = state_82436;
var statearr_82441_82465 = state_82436__$1;
(statearr_82441_82465[(2)] = inst_82417);

(statearr_82441_82465[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (6))){
var state_82436__$1 = state_82436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82436__$1,(9),n);
} else {
if((state_val_82437 === (3))){
var inst_82434 = (state_82436[(2)]);
var state_82436__$1 = state_82436;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82436__$1,inst_82434);
} else {
if((state_val_82437 === (12))){
var inst_82412 = (state_82436[(7)]);
var inst_82420 = (state_82436[(2)]);
var inst_82421 = fluree.db.dbfunctions.internal.quot(inst_82412,inst_82420);
var inst_82422 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82423 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82425 = [inst_82412,inst_82420];
var inst_82426 = (new cljs.core.PersistentVector(null,2,(5),inst_82424,inst_82425,null));
var inst_82427 = ["quot",inst_82426,inst_82421];
var inst_82428 = cljs.core.PersistentHashMap.fromArrays(inst_82423,inst_82427);
var inst_82429 = [inst_82428,(2)];
var inst_82430 = (new cljs.core.PersistentVector(null,2,(5),inst_82422,inst_82429,null));
var inst_82431 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82430);
var _ = (function (){var statearr_82442 = state_82436;
(statearr_82442[(4)] = cljs.core.rest((state_82436[(4)])));

return statearr_82442;
})();
var state_82436__$1 = (function (){var statearr_82443 = state_82436;
(statearr_82443[(8)] = inst_82431);

return statearr_82443;
})();
var statearr_82444_82466 = state_82436__$1;
(statearr_82444_82466[(2)] = inst_82421);

(statearr_82444_82466[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (2))){
var _ = (function (){var statearr_82445 = state_82436;
(statearr_82445[(4)] = cljs.core.cons((5),(state_82436[(4)])));

return statearr_82445;
})();
var inst_82405 = fluree.db.util.async.channel_QMARK_(n);
var state_82436__$1 = state_82436;
if(inst_82405){
var statearr_82446_82467 = state_82436__$1;
(statearr_82446_82467[(1)] = (6));

} else {
var statearr_82447_82468 = state_82436__$1;
(statearr_82447_82468[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (11))){
var state_82436__$1 = state_82436;
var statearr_82449_82469 = state_82436__$1;
(statearr_82449_82469[(2)] = d);

(statearr_82449_82469[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (9))){
var inst_82408 = (state_82436[(2)]);
var inst_82409 = fluree.db.util.async.throw_err(inst_82408);
var state_82436__$1 = state_82436;
var statearr_82450_82470 = state_82436__$1;
(statearr_82450_82470[(2)] = inst_82409);

(statearr_82450_82470[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (5))){
var _ = (function (){var statearr_82451 = state_82436;
(statearr_82451[(4)] = cljs.core.rest((state_82436[(4)])));

return statearr_82451;
})();
var state_82436__$1 = state_82436;
var ex82448 = (state_82436__$1[(2)]);
var statearr_82452_82471 = state_82436__$1;
(statearr_82452_82471[(5)] = ex82448);


if((ex82448 instanceof Error)){
var statearr_82453_82472 = state_82436__$1;
(statearr_82453_82472[(1)] = (4));

(statearr_82453_82472[(5)] = null);

} else {
throw ex82448;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82437 === (10))){
var state_82436__$1 = state_82436;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82436__$1,(13),d);
} else {
if((state_val_82437 === (8))){
var inst_82412 = (state_82436[(2)]);
var inst_82413 = fluree.db.util.async.channel_QMARK_(d);
var state_82436__$1 = (function (){var statearr_82454 = state_82436;
(statearr_82454[(7)] = inst_82412);

return statearr_82454;
})();
if(inst_82413){
var statearr_82455_82473 = state_82436__$1;
(statearr_82455_82473[(1)] = (10));

} else {
var statearr_82456_82474 = state_82436__$1;
(statearr_82456_82474[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____0 = (function (){
var statearr_82457 = [null,null,null,null,null,null,null,null,null];
(statearr_82457[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__);

(statearr_82457[(1)] = (1));

return statearr_82457;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____1 = (function (state_82436){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82436);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82458){var ex__24301__auto__ = e82458;
var statearr_82459_82475 = state_82436;
(statearr_82459_82475[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82436[(4)]))){
var statearr_82460_82476 = state_82436;
(statearr_82460_82476[(1)] = cljs.core.first((state_82436[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82477 = state_82436;
state_82436 = G__82477;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__ = function(state_82436){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____1.call(this,state_82436);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82461 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82461[(6)] = c__24424__auto__);

return statearr_82461;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82515){
var state_val_82516 = (state_82515[(1)]);
if((state_val_82516 === (7))){
var state_82515__$1 = state_82515;
var statearr_82517_82541 = state_82515__$1;
(statearr_82517_82541[(2)] = n);

(statearr_82517_82541[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (1))){
var state_82515__$1 = state_82515;
var statearr_82518_82542 = state_82515__$1;
(statearr_82518_82542[(2)] = null);

(statearr_82518_82542[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (4))){
var inst_82478 = (state_82515[(2)]);
var state_82515__$1 = state_82515;
var statearr_82519_82543 = state_82515__$1;
(statearr_82519_82543[(2)] = inst_82478);

(statearr_82519_82543[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (13))){
var inst_82495 = (state_82515[(2)]);
var inst_82496 = fluree.db.util.async.throw_err(inst_82495);
var state_82515__$1 = state_82515;
var statearr_82520_82544 = state_82515__$1;
(statearr_82520_82544[(2)] = inst_82496);

(statearr_82520_82544[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (6))){
var state_82515__$1 = state_82515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82515__$1,(9),n);
} else {
if((state_val_82516 === (3))){
var inst_82513 = (state_82515[(2)]);
var state_82515__$1 = state_82515;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82515__$1,inst_82513);
} else {
if((state_val_82516 === (12))){
var inst_82491 = (state_82515[(7)]);
var inst_82499 = (state_82515[(2)]);
var inst_82500 = fluree.db.dbfunctions.internal.mod(inst_82491,inst_82499);
var inst_82501 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82502 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82503 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82504 = [inst_82491,inst_82499];
var inst_82505 = (new cljs.core.PersistentVector(null,2,(5),inst_82503,inst_82504,null));
var inst_82506 = ["mod",inst_82505,inst_82500];
var inst_82507 = cljs.core.PersistentHashMap.fromArrays(inst_82502,inst_82506);
var inst_82508 = [inst_82507,(2)];
var inst_82509 = (new cljs.core.PersistentVector(null,2,(5),inst_82501,inst_82508,null));
var inst_82510 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82509);
var _ = (function (){var statearr_82521 = state_82515;
(statearr_82521[(4)] = cljs.core.rest((state_82515[(4)])));

return statearr_82521;
})();
var state_82515__$1 = (function (){var statearr_82522 = state_82515;
(statearr_82522[(8)] = inst_82510);

return statearr_82522;
})();
var statearr_82523_82545 = state_82515__$1;
(statearr_82523_82545[(2)] = inst_82500);

(statearr_82523_82545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (2))){
var _ = (function (){var statearr_82524 = state_82515;
(statearr_82524[(4)] = cljs.core.cons((5),(state_82515[(4)])));

return statearr_82524;
})();
var inst_82484 = fluree.db.util.async.channel_QMARK_(n);
var state_82515__$1 = state_82515;
if(inst_82484){
var statearr_82525_82546 = state_82515__$1;
(statearr_82525_82546[(1)] = (6));

} else {
var statearr_82526_82547 = state_82515__$1;
(statearr_82526_82547[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (11))){
var state_82515__$1 = state_82515;
var statearr_82528_82548 = state_82515__$1;
(statearr_82528_82548[(2)] = d);

(statearr_82528_82548[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (9))){
var inst_82487 = (state_82515[(2)]);
var inst_82488 = fluree.db.util.async.throw_err(inst_82487);
var state_82515__$1 = state_82515;
var statearr_82529_82549 = state_82515__$1;
(statearr_82529_82549[(2)] = inst_82488);

(statearr_82529_82549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (5))){
var _ = (function (){var statearr_82530 = state_82515;
(statearr_82530[(4)] = cljs.core.rest((state_82515[(4)])));

return statearr_82530;
})();
var state_82515__$1 = state_82515;
var ex82527 = (state_82515__$1[(2)]);
var statearr_82531_82550 = state_82515__$1;
(statearr_82531_82550[(5)] = ex82527);


if((ex82527 instanceof Error)){
var statearr_82532_82551 = state_82515__$1;
(statearr_82532_82551[(1)] = (4));

(statearr_82532_82551[(5)] = null);

} else {
throw ex82527;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82516 === (10))){
var state_82515__$1 = state_82515;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82515__$1,(13),d);
} else {
if((state_val_82516 === (8))){
var inst_82491 = (state_82515[(2)]);
var inst_82492 = fluree.db.util.async.channel_QMARK_(d);
var state_82515__$1 = (function (){var statearr_82533 = state_82515;
(statearr_82533[(7)] = inst_82491);

return statearr_82533;
})();
if(inst_82492){
var statearr_82534_82552 = state_82515__$1;
(statearr_82534_82552[(1)] = (10));

} else {
var statearr_82535_82553 = state_82515__$1;
(statearr_82535_82553[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____0 = (function (){
var statearr_82536 = [null,null,null,null,null,null,null,null,null];
(statearr_82536[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__);

(statearr_82536[(1)] = (1));

return statearr_82536;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____1 = (function (state_82515){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82515);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82537){var ex__24301__auto__ = e82537;
var statearr_82538_82554 = state_82515;
(statearr_82538_82554[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82515[(4)]))){
var statearr_82539_82555 = state_82515;
(statearr_82539_82555[(1)] = cljs.core.first((state_82515[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82556 = state_82515;
state_82515 = G__82556;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__ = function(state_82515){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____1.call(this,state_82515);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82540 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82540[(6)] = c__24424__auto__);

return statearr_82540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82594){
var state_val_82595 = (state_82594[(1)]);
if((state_val_82595 === (7))){
var state_82594__$1 = state_82594;
var statearr_82596_82620 = state_82594__$1;
(statearr_82596_82620[(2)] = n);

(statearr_82596_82620[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (1))){
var state_82594__$1 = state_82594;
var statearr_82597_82621 = state_82594__$1;
(statearr_82597_82621[(2)] = null);

(statearr_82597_82621[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (4))){
var inst_82557 = (state_82594[(2)]);
var state_82594__$1 = state_82594;
var statearr_82598_82622 = state_82594__$1;
(statearr_82598_82622[(2)] = inst_82557);

(statearr_82598_82622[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (13))){
var inst_82574 = (state_82594[(2)]);
var inst_82575 = fluree.db.util.async.throw_err(inst_82574);
var state_82594__$1 = state_82594;
var statearr_82599_82623 = state_82594__$1;
(statearr_82599_82623[(2)] = inst_82575);

(statearr_82599_82623[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (6))){
var state_82594__$1 = state_82594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82594__$1,(9),n);
} else {
if((state_val_82595 === (3))){
var inst_82592 = (state_82594[(2)]);
var state_82594__$1 = state_82594;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82594__$1,inst_82592);
} else {
if((state_val_82595 === (12))){
var inst_82570 = (state_82594[(7)]);
var inst_82578 = (state_82594[(2)]);
var inst_82579 = fluree.db.dbfunctions.internal.rem(inst_82570,inst_82578);
var inst_82580 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82581 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82582 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82583 = [inst_82570,inst_82578];
var inst_82584 = (new cljs.core.PersistentVector(null,2,(5),inst_82582,inst_82583,null));
var inst_82585 = ["rem",inst_82584,inst_82579];
var inst_82586 = cljs.core.PersistentHashMap.fromArrays(inst_82581,inst_82585);
var inst_82587 = [inst_82586,(2)];
var inst_82588 = (new cljs.core.PersistentVector(null,2,(5),inst_82580,inst_82587,null));
var inst_82589 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82588);
var _ = (function (){var statearr_82600 = state_82594;
(statearr_82600[(4)] = cljs.core.rest((state_82594[(4)])));

return statearr_82600;
})();
var state_82594__$1 = (function (){var statearr_82601 = state_82594;
(statearr_82601[(8)] = inst_82589);

return statearr_82601;
})();
var statearr_82602_82624 = state_82594__$1;
(statearr_82602_82624[(2)] = inst_82579);

(statearr_82602_82624[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (2))){
var _ = (function (){var statearr_82603 = state_82594;
(statearr_82603[(4)] = cljs.core.cons((5),(state_82594[(4)])));

return statearr_82603;
})();
var inst_82563 = fluree.db.util.async.channel_QMARK_(n);
var state_82594__$1 = state_82594;
if(inst_82563){
var statearr_82604_82625 = state_82594__$1;
(statearr_82604_82625[(1)] = (6));

} else {
var statearr_82605_82626 = state_82594__$1;
(statearr_82605_82626[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (11))){
var state_82594__$1 = state_82594;
var statearr_82607_82627 = state_82594__$1;
(statearr_82607_82627[(2)] = d);

(statearr_82607_82627[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (9))){
var inst_82566 = (state_82594[(2)]);
var inst_82567 = fluree.db.util.async.throw_err(inst_82566);
var state_82594__$1 = state_82594;
var statearr_82608_82628 = state_82594__$1;
(statearr_82608_82628[(2)] = inst_82567);

(statearr_82608_82628[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (5))){
var _ = (function (){var statearr_82609 = state_82594;
(statearr_82609[(4)] = cljs.core.rest((state_82594[(4)])));

return statearr_82609;
})();
var state_82594__$1 = state_82594;
var ex82606 = (state_82594__$1[(2)]);
var statearr_82610_82629 = state_82594__$1;
(statearr_82610_82629[(5)] = ex82606);


if((ex82606 instanceof Error)){
var statearr_82611_82630 = state_82594__$1;
(statearr_82611_82630[(1)] = (4));

(statearr_82611_82630[(5)] = null);

} else {
throw ex82606;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82595 === (10))){
var state_82594__$1 = state_82594;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82594__$1,(13),d);
} else {
if((state_val_82595 === (8))){
var inst_82570 = (state_82594[(2)]);
var inst_82571 = fluree.db.util.async.channel_QMARK_(d);
var state_82594__$1 = (function (){var statearr_82612 = state_82594;
(statearr_82612[(7)] = inst_82570);

return statearr_82612;
})();
if(inst_82571){
var statearr_82613_82631 = state_82594__$1;
(statearr_82613_82631[(1)] = (10));

} else {
var statearr_82614_82632 = state_82594__$1;
(statearr_82614_82632[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____0 = (function (){
var statearr_82615 = [null,null,null,null,null,null,null,null,null];
(statearr_82615[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__);

(statearr_82615[(1)] = (1));

return statearr_82615;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____1 = (function (state_82594){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82594);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82616){var ex__24301__auto__ = e82616;
var statearr_82617_82633 = state_82594;
(statearr_82617_82633[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82594[(4)]))){
var statearr_82618_82634 = state_82594;
(statearr_82618_82634[(1)] = cljs.core.first((state_82594[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82635 = state_82594;
state_82594 = G__82635;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__ = function(state_82594){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____1.call(this,state_82594);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82619 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82619[(6)] = c__24424__auto__);

return statearr_82619;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82662){
var state_val_82663 = (state_82662[(1)]);
if((state_val_82663 === (7))){
var state_82662__$1 = state_82662;
var statearr_82664_82683 = state_82662__$1;
(statearr_82664_82683[(2)] = x);

(statearr_82664_82683[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (1))){
var state_82662__$1 = state_82662;
var statearr_82665_82684 = state_82662__$1;
(statearr_82665_82684[(2)] = null);

(statearr_82665_82684[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (4))){
var inst_82636 = (state_82662[(2)]);
var state_82662__$1 = state_82662;
var statearr_82666_82685 = state_82662__$1;
(statearr_82666_82685[(2)] = inst_82636);

(statearr_82666_82685[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (6))){
var state_82662__$1 = state_82662;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82662__$1,(9),x);
} else {
if((state_val_82663 === (3))){
var inst_82660 = (state_82662[(2)]);
var state_82662__$1 = state_82662;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82662__$1,inst_82660);
} else {
if((state_val_82663 === (2))){
var _ = (function (){var statearr_82668 = state_82662;
(statearr_82668[(4)] = cljs.core.cons((5),(state_82662[(4)])));

return statearr_82668;
})();
var inst_82642 = fluree.db.util.async.channel_QMARK_(x);
var state_82662__$1 = state_82662;
if(inst_82642){
var statearr_82669_82686 = state_82662__$1;
(statearr_82669_82686[(1)] = (6));

} else {
var statearr_82670_82687 = state_82662__$1;
(statearr_82670_82687[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (9))){
var inst_82645 = (state_82662[(2)]);
var inst_82646 = fluree.db.util.async.throw_err(inst_82645);
var state_82662__$1 = state_82662;
var statearr_82671_82688 = state_82662__$1;
(statearr_82671_82688[(2)] = inst_82646);

(statearr_82671_82688[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (5))){
var _ = (function (){var statearr_82672 = state_82662;
(statearr_82672[(4)] = cljs.core.rest((state_82662[(4)])));

return statearr_82672;
})();
var state_82662__$1 = state_82662;
var ex82667 = (state_82662__$1[(2)]);
var statearr_82673_82689 = state_82662__$1;
(statearr_82673_82689[(5)] = ex82667);


if((ex82667 instanceof Error)){
var statearr_82674_82690 = state_82662__$1;
(statearr_82674_82690[(1)] = (4));

(statearr_82674_82690[(5)] = null);

} else {
throw ex82667;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82663 === (8))){
var inst_82649 = (state_82662[(2)]);
var inst_82650 = fluree.db.dbfunctions.internal.boolean$(inst_82649);
var inst_82651 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82652 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82653 = ["boolean",inst_82649,inst_82650];
var inst_82654 = cljs.core.PersistentHashMap.fromArrays(inst_82652,inst_82653);
var inst_82655 = [inst_82654,(10)];
var inst_82656 = (new cljs.core.PersistentVector(null,2,(5),inst_82651,inst_82655,null));
var inst_82657 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82656);
var _ = (function (){var statearr_82675 = state_82662;
(statearr_82675[(4)] = cljs.core.rest((state_82662[(4)])));

return statearr_82675;
})();
var state_82662__$1 = (function (){var statearr_82676 = state_82662;
(statearr_82676[(7)] = inst_82657);

return statearr_82676;
})();
var statearr_82677_82691 = state_82662__$1;
(statearr_82677_82691[(2)] = inst_82650);

(statearr_82677_82691[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____0 = (function (){
var statearr_82678 = [null,null,null,null,null,null,null,null];
(statearr_82678[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__);

(statearr_82678[(1)] = (1));

return statearr_82678;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____1 = (function (state_82662){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82662);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82679){var ex__24301__auto__ = e82679;
var statearr_82680_82692 = state_82662;
(statearr_82680_82692[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82662[(4)]))){
var statearr_82681_82693 = state_82662;
(statearr_82681_82693[(1)] = cljs.core.first((state_82662[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82694 = state_82662;
state_82662 = G__82694;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__ = function(state_82662){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____1.call(this,state_82662);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82682 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82682[(6)] = c__24424__auto__);

return statearr_82682;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82732){
var state_val_82733 = (state_82732[(1)]);
if((state_val_82733 === (7))){
var state_82732__$1 = state_82732;
var statearr_82734_82758 = state_82732__$1;
(statearr_82734_82758[(2)] = pattern);

(statearr_82734_82758[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (1))){
var state_82732__$1 = state_82732;
var statearr_82735_82759 = state_82732__$1;
(statearr_82735_82759[(2)] = null);

(statearr_82735_82759[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (4))){
var inst_82695 = (state_82732[(2)]);
var state_82732__$1 = state_82732;
var statearr_82736_82760 = state_82732__$1;
(statearr_82736_82760[(2)] = inst_82695);

(statearr_82736_82760[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (13))){
var inst_82712 = (state_82732[(2)]);
var inst_82713 = fluree.db.util.async.throw_err(inst_82712);
var state_82732__$1 = state_82732;
var statearr_82737_82761 = state_82732__$1;
(statearr_82737_82761[(2)] = inst_82713);

(statearr_82737_82761[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (6))){
var state_82732__$1 = state_82732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82732__$1,(9),pattern);
} else {
if((state_val_82733 === (3))){
var inst_82730 = (state_82732[(2)]);
var state_82732__$1 = state_82732;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82732__$1,inst_82730);
} else {
if((state_val_82733 === (12))){
var inst_82708 = (state_82732[(7)]);
var inst_82716 = (state_82732[(2)]);
var inst_82717 = fluree.db.dbfunctions.internal.re_find(inst_82708,inst_82716);
var inst_82718 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82719 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82721 = [inst_82708,inst_82716];
var inst_82722 = (new cljs.core.PersistentVector(null,2,(5),inst_82720,inst_82721,null));
var inst_82723 = ["re-find",inst_82722,inst_82717];
var inst_82724 = cljs.core.PersistentHashMap.fromArrays(inst_82719,inst_82723);
var inst_82725 = [inst_82724,(10)];
var inst_82726 = (new cljs.core.PersistentVector(null,2,(5),inst_82718,inst_82725,null));
var inst_82727 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82726);
var _ = (function (){var statearr_82738 = state_82732;
(statearr_82738[(4)] = cljs.core.rest((state_82732[(4)])));

return statearr_82738;
})();
var state_82732__$1 = (function (){var statearr_82739 = state_82732;
(statearr_82739[(8)] = inst_82727);

return statearr_82739;
})();
var statearr_82740_82762 = state_82732__$1;
(statearr_82740_82762[(2)] = inst_82717);

(statearr_82740_82762[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (2))){
var _ = (function (){var statearr_82741 = state_82732;
(statearr_82741[(4)] = cljs.core.cons((5),(state_82732[(4)])));

return statearr_82741;
})();
var inst_82701 = fluree.db.util.async.channel_QMARK_(pattern);
var state_82732__$1 = state_82732;
if(inst_82701){
var statearr_82742_82763 = state_82732__$1;
(statearr_82742_82763[(1)] = (6));

} else {
var statearr_82743_82764 = state_82732__$1;
(statearr_82743_82764[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (11))){
var state_82732__$1 = state_82732;
var statearr_82745_82765 = state_82732__$1;
(statearr_82745_82765[(2)] = string);

(statearr_82745_82765[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (9))){
var inst_82704 = (state_82732[(2)]);
var inst_82705 = fluree.db.util.async.throw_err(inst_82704);
var state_82732__$1 = state_82732;
var statearr_82746_82766 = state_82732__$1;
(statearr_82746_82766[(2)] = inst_82705);

(statearr_82746_82766[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (5))){
var _ = (function (){var statearr_82747 = state_82732;
(statearr_82747[(4)] = cljs.core.rest((state_82732[(4)])));

return statearr_82747;
})();
var state_82732__$1 = state_82732;
var ex82744 = (state_82732__$1[(2)]);
var statearr_82748_82767 = state_82732__$1;
(statearr_82748_82767[(5)] = ex82744);


if((ex82744 instanceof Error)){
var statearr_82749_82768 = state_82732__$1;
(statearr_82749_82768[(1)] = (4));

(statearr_82749_82768[(5)] = null);

} else {
throw ex82744;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82733 === (10))){
var state_82732__$1 = state_82732;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82732__$1,(13),string);
} else {
if((state_val_82733 === (8))){
var inst_82708 = (state_82732[(2)]);
var inst_82709 = fluree.db.util.async.channel_QMARK_(string);
var state_82732__$1 = (function (){var statearr_82750 = state_82732;
(statearr_82750[(7)] = inst_82708);

return statearr_82750;
})();
if(inst_82709){
var statearr_82751_82769 = state_82732__$1;
(statearr_82751_82769[(1)] = (10));

} else {
var statearr_82752_82770 = state_82732__$1;
(statearr_82752_82770[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____0 = (function (){
var statearr_82753 = [null,null,null,null,null,null,null,null,null];
(statearr_82753[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__);

(statearr_82753[(1)] = (1));

return statearr_82753;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____1 = (function (state_82732){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82732);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82754){var ex__24301__auto__ = e82754;
var statearr_82755_82771 = state_82732;
(statearr_82755_82771[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82732[(4)]))){
var statearr_82756_82772 = state_82732;
(statearr_82756_82772[(1)] = cljs.core.first((state_82732[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82773 = state_82732;
state_82732 = G__82773;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__ = function(state_82732){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____1.call(this,state_82732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82757 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82757[(6)] = c__24424__auto__);

return statearr_82757;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82800){
var state_val_82801 = (state_82800[(1)]);
if((state_val_82801 === (7))){
var state_82800__$1 = state_82800;
var statearr_82802_82821 = state_82800__$1;
(statearr_82802_82821[(2)] = email);

(statearr_82802_82821[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (1))){
var state_82800__$1 = state_82800;
var statearr_82803_82822 = state_82800__$1;
(statearr_82803_82822[(2)] = null);

(statearr_82803_82822[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (4))){
var inst_82774 = (state_82800[(2)]);
var state_82800__$1 = state_82800;
var statearr_82804_82823 = state_82800__$1;
(statearr_82804_82823[(2)] = inst_82774);

(statearr_82804_82823[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (6))){
var state_82800__$1 = state_82800;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82800__$1,(9),email);
} else {
if((state_val_82801 === (3))){
var inst_82798 = (state_82800[(2)]);
var state_82800__$1 = state_82800;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82800__$1,inst_82798);
} else {
if((state_val_82801 === (2))){
var _ = (function (){var statearr_82806 = state_82800;
(statearr_82806[(4)] = cljs.core.cons((5),(state_82800[(4)])));

return statearr_82806;
})();
var inst_82780 = fluree.db.util.async.channel_QMARK_(email);
var state_82800__$1 = state_82800;
if(inst_82780){
var statearr_82807_82824 = state_82800__$1;
(statearr_82807_82824[(1)] = (6));

} else {
var statearr_82808_82825 = state_82800__$1;
(statearr_82808_82825[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (9))){
var inst_82783 = (state_82800[(2)]);
var inst_82784 = fluree.db.util.async.throw_err(inst_82783);
var state_82800__$1 = state_82800;
var statearr_82809_82826 = state_82800__$1;
(statearr_82809_82826[(2)] = inst_82784);

(statearr_82809_82826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (5))){
var _ = (function (){var statearr_82810 = state_82800;
(statearr_82810[(4)] = cljs.core.rest((state_82800[(4)])));

return statearr_82810;
})();
var state_82800__$1 = state_82800;
var ex82805 = (state_82800__$1[(2)]);
var statearr_82811_82827 = state_82800__$1;
(statearr_82811_82827[(5)] = ex82805);


if((ex82805 instanceof Error)){
var statearr_82812_82828 = state_82800__$1;
(statearr_82812_82828[(1)] = (4));

(statearr_82812_82828[(5)] = null);

} else {
throw ex82805;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82801 === (8))){
var inst_82787 = (state_82800[(2)]);
var inst_82788 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_82787);
var inst_82789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82790 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82791 = ["re-find",inst_82787,inst_82788];
var inst_82792 = cljs.core.PersistentHashMap.fromArrays(inst_82790,inst_82791);
var inst_82793 = [inst_82792,(10)];
var inst_82794 = (new cljs.core.PersistentVector(null,2,(5),inst_82789,inst_82793,null));
var inst_82795 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82794);
var _ = (function (){var statearr_82813 = state_82800;
(statearr_82813[(4)] = cljs.core.rest((state_82800[(4)])));

return statearr_82813;
})();
var state_82800__$1 = (function (){var statearr_82814 = state_82800;
(statearr_82814[(7)] = inst_82795);

return statearr_82814;
})();
var statearr_82815_82829 = state_82800__$1;
(statearr_82815_82829[(2)] = inst_82788);

(statearr_82815_82829[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_82816 = [null,null,null,null,null,null,null,null];
(statearr_82816[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__);

(statearr_82816[(1)] = (1));

return statearr_82816;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____1 = (function (state_82800){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82800);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82817){var ex__24301__auto__ = e82817;
var statearr_82818_82830 = state_82800;
(statearr_82818_82830[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82800[(4)]))){
var statearr_82819_82831 = state_82800;
(statearr_82819_82831[(1)] = cljs.core.first((state_82800[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82832 = state_82800;
state_82800 = G__82832;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__ = function(state_82800){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____1.call(this,state_82800);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82820 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82820[(6)] = c__24424__auto__);

return statearr_82820;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82879){
var state_val_82880 = (state_82879[(1)]);
if((state_val_82880 === (7))){
var inst_82849 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82879__$1 = state_82879;
if(cljs.core.truth_(inst_82849)){
var statearr_82881_82908 = state_82879__$1;
(statearr_82881_82908[(1)] = (9));

} else {
var statearr_82882_82909 = state_82879__$1;
(statearr_82882_82909[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (1))){
var state_82879__$1 = state_82879;
var statearr_82883_82910 = state_82879__$1;
(statearr_82883_82910[(2)] = null);

(statearr_82883_82910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (4))){
var inst_82833 = (state_82879[(2)]);
var state_82879__$1 = state_82879;
var statearr_82884_82911 = state_82879__$1;
(statearr_82884_82911[(2)] = inst_82833);

(statearr_82884_82911[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (15))){
var inst_82860 = (state_82879[(2)]);
var state_82879__$1 = state_82879;
var statearr_82885_82912 = state_82879__$1;
(statearr_82885_82912[(2)] = inst_82860);

(statearr_82885_82912[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (13))){
var inst_82857 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_82879__$1 = state_82879;
var statearr_82886_82913 = state_82879__$1;
(statearr_82886_82913[(2)] = inst_82857);

(statearr_82886_82913[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (6))){
var inst_82844 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82845 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_82846 = [inst_82845,(0)];
var inst_82847 = (new cljs.core.PersistentVector(null,2,(5),inst_82844,inst_82846,null));
var state_82879__$1 = state_82879;
var statearr_82887_82914 = state_82879__$1;
(statearr_82887_82914[(2)] = inst_82847);

(statearr_82887_82914[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (3))){
var inst_82877 = (state_82879[(2)]);
var state_82879__$1 = state_82879;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82879__$1,inst_82877);
} else {
if((state_val_82880 === (12))){
var inst_82853 = (state_82879[(2)]);
var inst_82854 = fluree.db.util.async.throw_err(inst_82853);
var state_82879__$1 = state_82879;
var statearr_82888_82915 = state_82879__$1;
(statearr_82888_82915[(2)] = inst_82854);

(statearr_82888_82915[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (2))){
var _ = (function (){var statearr_82889 = state_82879;
(statearr_82889[(4)] = cljs.core.cons((5),(state_82879[(4)])));

return statearr_82889;
})();
var inst_82842 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82879__$1 = state_82879;
if(cljs.core.truth_(inst_82842)){
var statearr_82890_82916 = state_82879__$1;
(statearr_82890_82916[(1)] = (6));

} else {
var statearr_82891_82917 = state_82879__$1;
(statearr_82891_82917[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (11))){
var inst_82862 = (state_82879[(2)]);
var state_82879__$1 = state_82879;
var statearr_82893_82918 = state_82879__$1;
(statearr_82893_82918[(2)] = inst_82862);

(statearr_82893_82918[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (9))){
var inst_82851 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_82879__$1 = state_82879;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82879__$1,(12),inst_82851);
} else {
if((state_val_82880 === (5))){
var _ = (function (){var statearr_82894 = state_82879;
(statearr_82894[(4)] = cljs.core.rest((state_82879[(4)])));

return statearr_82894;
})();
var state_82879__$1 = state_82879;
var ex82892 = (state_82879__$1[(2)]);
var statearr_82895_82919 = state_82879__$1;
(statearr_82895_82919[(5)] = ex82892);


if((ex82892 instanceof Error)){
var statearr_82896_82920 = state_82879__$1;
(statearr_82896_82920[(1)] = (4));

(statearr_82896_82920[(5)] = null);

} else {
throw ex82892;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (14))){
var state_82879__$1 = state_82879;
var statearr_82897_82921 = state_82879__$1;
(statearr_82897_82921[(2)] = null);

(statearr_82897_82921[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (10))){
var state_82879__$1 = state_82879;
var statearr_82898_82922 = state_82879__$1;
(statearr_82898_82922[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_82880 === (8))){
var inst_82864 = (state_82879[(2)]);
var inst_82865 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82864,(0),null);
var inst_82866 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_82864,(1),null);
var inst_82867 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82868 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82869 = ["?user_id","?ctx",inst_82865];
var inst_82870 = cljs.core.PersistentHashMap.fromArrays(inst_82868,inst_82869);
var inst_82871 = ((10) + inst_82866);
var inst_82872 = [inst_82870,inst_82871];
var inst_82873 = (new cljs.core.PersistentVector(null,2,(5),inst_82867,inst_82872,null));
var inst_82874 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82873);
var _ = (function (){var statearr_82900 = state_82879;
(statearr_82900[(4)] = cljs.core.rest((state_82879[(4)])));

return statearr_82900;
})();
var state_82879__$1 = (function (){var statearr_82901 = state_82879;
(statearr_82901[(7)] = inst_82874);

return statearr_82901;
})();
var statearr_82902_82923 = state_82879__$1;
(statearr_82902_82923[(2)] = inst_82865);

(statearr_82902_82923[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____0 = (function (){
var statearr_82903 = [null,null,null,null,null,null,null,null];
(statearr_82903[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__);

(statearr_82903[(1)] = (1));

return statearr_82903;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____1 = (function (state_82879){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82879);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82904){var ex__24301__auto__ = e82904;
var statearr_82905_82924 = state_82879;
(statearr_82905_82924[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82879[(4)]))){
var statearr_82906_82925 = state_82879;
(statearr_82906_82925[(1)] = cljs.core.first((state_82879[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82926 = state_82879;
state_82879 = G__82926;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__ = function(state_82879){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____1.call(this,state_82879);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82907 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82907[(6)] = c__24424__auto__);

return statearr_82907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_82954){
var state_val_82955 = (state_82954[(1)]);
if((state_val_82955 === (7))){
var inst_82947 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_82954__$1 = state_82954;
var statearr_82956_82975 = state_82954__$1;
(statearr_82956_82975[(2)] = inst_82947);

(statearr_82956_82975[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (1))){
var state_82954__$1 = state_82954;
var statearr_82957_82976 = state_82954__$1;
(statearr_82957_82976[(2)] = null);

(statearr_82957_82976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (4))){
var inst_82927 = (state_82954[(2)]);
var state_82954__$1 = state_82954;
var statearr_82958_82977 = state_82954__$1;
(statearr_82958_82977[(2)] = inst_82927);

(statearr_82958_82977[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (6))){
var inst_82935 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_82954__$1 = state_82954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_82954__$1,(9),inst_82935);
} else {
if((state_val_82955 === (3))){
var inst_82952 = (state_82954[(2)]);
var state_82954__$1 = state_82954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_82954__$1,inst_82952);
} else {
if((state_val_82955 === (2))){
var _ = (function (){var statearr_82960 = state_82954;
(statearr_82960[(4)] = cljs.core.cons((5),(state_82954[(4)])));

return statearr_82960;
})();
var inst_82933 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_82954__$1 = state_82954;
if(cljs.core.truth_(inst_82933)){
var statearr_82961_82978 = state_82954__$1;
(statearr_82961_82978[(1)] = (6));

} else {
var statearr_82962_82979 = state_82954__$1;
(statearr_82962_82979[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (9))){
var inst_82937 = (state_82954[(2)]);
var inst_82938 = fluree.db.util.async.throw_err(inst_82937);
var inst_82939 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_82940 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_82941 = ["?auth_id","?ctx",inst_82938];
var inst_82942 = cljs.core.PersistentHashMap.fromArrays(inst_82940,inst_82941);
var inst_82943 = [inst_82942,(10)];
var inst_82944 = (new cljs.core.PersistentVector(null,2,(5),inst_82939,inst_82943,null));
var inst_82945 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_82944);
var state_82954__$1 = (function (){var statearr_82963 = state_82954;
(statearr_82963[(7)] = inst_82945);

return statearr_82963;
})();
var statearr_82964_82980 = state_82954__$1;
(statearr_82964_82980[(2)] = inst_82938);

(statearr_82964_82980[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (5))){
var _ = (function (){var statearr_82965 = state_82954;
(statearr_82965[(4)] = cljs.core.rest((state_82954[(4)])));

return statearr_82965;
})();
var state_82954__$1 = state_82954;
var ex82959 = (state_82954__$1[(2)]);
var statearr_82966_82981 = state_82954__$1;
(statearr_82966_82981[(5)] = ex82959);


if((ex82959 instanceof Error)){
var statearr_82967_82982 = state_82954__$1;
(statearr_82967_82982[(1)] = (4));

(statearr_82967_82982[(5)] = null);

} else {
throw ex82959;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_82955 === (8))){
var inst_82949 = (state_82954[(2)]);
var _ = (function (){var statearr_82968 = state_82954;
(statearr_82968[(4)] = cljs.core.rest((state_82954[(4)])));

return statearr_82968;
})();
var state_82954__$1 = state_82954;
var statearr_82969_82983 = state_82954__$1;
(statearr_82969_82983[(2)] = inst_82949);

(statearr_82969_82983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____0 = (function (){
var statearr_82970 = [null,null,null,null,null,null,null,null];
(statearr_82970[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__);

(statearr_82970[(1)] = (1));

return statearr_82970;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____1 = (function (state_82954){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_82954);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e82971){var ex__24301__auto__ = e82971;
var statearr_82972_82984 = state_82954;
(statearr_82972_82984[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_82954[(4)]))){
var statearr_82973_82985 = state_82954;
(statearr_82973_82985[(1)] = cljs.core.first((state_82954[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__82986 = state_82954;
state_82954 = G__82986;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__ = function(state_82954){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____1.call(this,state_82954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_82974 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_82974[(6)] = c__24424__auto__);

return statearr_82974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__82988 = arguments.length;
switch (G__82988) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83030){
var state_val_83031 = (state_83030[(1)]);
if((state_val_83031 === (7))){
var state_83030__$1 = state_83030;
var statearr_83032_83062 = state_83030__$1;
(statearr_83032_83062[(2)] = seed);

(statearr_83032_83062[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (1))){
var state_83030__$1 = state_83030;
var statearr_83033_83063 = state_83030__$1;
(statearr_83033_83063[(2)] = null);

(statearr_83033_83063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (4))){
var inst_82989 = (state_83030[(2)]);
var state_83030__$1 = state_83030;
var statearr_83034_83064 = state_83030__$1;
(statearr_83034_83064[(2)] = inst_82989);

(statearr_83034_83064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (15))){
var state_83030__$1 = state_83030;
var statearr_83035_83065 = state_83030__$1;
(statearr_83035_83065[(2)] = (10));

(statearr_83035_83065[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (13))){
var inst_83006 = (state_83030[(2)]);
var inst_83007 = fluree.db.util.async.throw_err(inst_83006);
var state_83030__$1 = state_83030;
var statearr_83036_83066 = state_83030__$1;
(statearr_83036_83066[(2)] = inst_83007);

(statearr_83036_83066[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (6))){
var state_83030__$1 = state_83030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83030__$1,(9),seed);
} else {
if((state_val_83031 === (3))){
var inst_83028 = (state_83030[(2)]);
var state_83030__$1 = state_83030;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83030__$1,inst_83028);
} else {
if((state_val_83031 === (12))){
var inst_83010 = (state_83030[(7)]);
var inst_83010__$1 = (state_83030[(2)]);
var state_83030__$1 = (function (){var statearr_83037 = state_83030;
(statearr_83037[(7)] = inst_83010__$1);

return statearr_83037;
})();
if(cljs.core.truth_(inst_83010__$1)){
var statearr_83038_83067 = state_83030__$1;
(statearr_83038_83067[(1)] = (14));

} else {
var statearr_83039_83068 = state_83030__$1;
(statearr_83039_83068[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (2))){
var _ = (function (){var statearr_83040 = state_83030;
(statearr_83040[(4)] = cljs.core.cons((5),(state_83030[(4)])));

return statearr_83040;
})();
var inst_82995 = fluree.db.util.async.channel_QMARK_(seed);
var state_83030__$1 = state_83030;
if(inst_82995){
var statearr_83041_83069 = state_83030__$1;
(statearr_83041_83069[(1)] = (6));

} else {
var statearr_83042_83070 = state_83030__$1;
(statearr_83042_83070[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (11))){
var state_83030__$1 = state_83030;
var statearr_83044_83071 = state_83030__$1;
(statearr_83044_83071[(2)] = max);

(statearr_83044_83071[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (9))){
var inst_82998 = (state_83030[(2)]);
var inst_82999 = fluree.db.util.async.throw_err(inst_82998);
var state_83030__$1 = state_83030;
var statearr_83045_83072 = state_83030__$1;
(statearr_83045_83072[(2)] = inst_82999);

(statearr_83045_83072[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (5))){
var _ = (function (){var statearr_83046 = state_83030;
(statearr_83046[(4)] = cljs.core.rest((state_83030[(4)])));

return statearr_83046;
})();
var state_83030__$1 = state_83030;
var ex83043 = (state_83030__$1[(2)]);
var statearr_83047_83073 = state_83030__$1;
(statearr_83047_83073[(5)] = ex83043);


if((ex83043 instanceof Error)){
var statearr_83048_83074 = state_83030__$1;
(statearr_83048_83074[(1)] = (4));

(statearr_83048_83074[(5)] = null);

} else {
throw ex83043;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (14))){
var inst_83010 = (state_83030[(7)]);
var state_83030__$1 = state_83030;
var statearr_83049_83075 = state_83030__$1;
(statearr_83049_83075[(2)] = inst_83010);

(statearr_83049_83075[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (16))){
var inst_83002 = (state_83030[(8)]);
var inst_83014 = (state_83030[(2)]);
var inst_83015 = fluree.db.dbfunctions.internal.rand(inst_83002,inst_83014);
var inst_83016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83017 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83019 = [max,seed];
var inst_83020 = (new cljs.core.PersistentVector(null,2,(5),inst_83018,inst_83019,null));
var inst_83021 = ["rand",inst_83020,inst_83015];
var inst_83022 = cljs.core.PersistentHashMap.fromArrays(inst_83017,inst_83021);
var inst_83023 = [inst_83022,(10)];
var inst_83024 = (new cljs.core.PersistentVector(null,2,(5),inst_83016,inst_83023,null));
var inst_83025 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83024);
var _ = (function (){var statearr_83050 = state_83030;
(statearr_83050[(4)] = cljs.core.rest((state_83030[(4)])));

return statearr_83050;
})();
var state_83030__$1 = (function (){var statearr_83051 = state_83030;
(statearr_83051[(9)] = inst_83025);

return statearr_83051;
})();
var statearr_83052_83076 = state_83030__$1;
(statearr_83052_83076[(2)] = inst_83015);

(statearr_83052_83076[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83031 === (10))){
var state_83030__$1 = state_83030;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83030__$1,(13),max);
} else {
if((state_val_83031 === (8))){
var inst_83002 = (state_83030[(2)]);
var inst_83003 = fluree.db.util.async.channel_QMARK_(max);
var state_83030__$1 = (function (){var statearr_83053 = state_83030;
(statearr_83053[(8)] = inst_83002);

return statearr_83053;
})();
if(inst_83003){
var statearr_83054_83077 = state_83030__$1;
(statearr_83054_83077[(1)] = (10));

} else {
var statearr_83055_83078 = state_83030__$1;
(statearr_83055_83078[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__24298__auto____0 = (function (){
var statearr_83056 = [null,null,null,null,null,null,null,null,null,null];
(statearr_83056[(0)] = fluree$db$dbfunctions$fns$state_machine__24298__auto__);

(statearr_83056[(1)] = (1));

return statearr_83056;
});
var fluree$db$dbfunctions$fns$state_machine__24298__auto____1 = (function (state_83030){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83030);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83057){var ex__24301__auto__ = e83057;
var statearr_83058_83079 = state_83030;
(statearr_83058_83079[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83030[(4)]))){
var statearr_83059_83080 = state_83030;
(statearr_83059_83080[(1)] = cljs.core.first((state_83030[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83081 = state_83030;
state_83030 = G__83081;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__24298__auto__ = function(state_83030){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__24298__auto____1.call(this,state_83030);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83060 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83060[(6)] = c__24424__auto__);

return statearr_83060;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83102){
var state_val_83103 = (state_83102[(1)]);
if((state_val_83103 === (1))){
var state_83102__$1 = state_83102;
var statearr_83104_83119 = state_83102__$1;
(statearr_83104_83119[(2)] = null);

(statearr_83104_83119[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83103 === (2))){
var _ = (function (){var statearr_83105 = state_83102;
(statearr_83105[(4)] = cljs.core.cons((5),(state_83102[(4)])));

return statearr_83105;
})();
var inst_83088 = fluree.db.util.core.random_uuid();
var inst_83089 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_83088);
var inst_83090 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83091 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83092 = cljs.core.PersistentVector.EMPTY;
var inst_83093 = ["uuid",inst_83092,inst_83089];
var inst_83094 = cljs.core.PersistentHashMap.fromArrays(inst_83091,inst_83093);
var inst_83095 = [inst_83094,(10)];
var inst_83096 = (new cljs.core.PersistentVector(null,2,(5),inst_83090,inst_83095,null));
var inst_83097 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83096);
var ___$1 = (function (){var statearr_83106 = state_83102;
(statearr_83106[(4)] = cljs.core.rest((state_83102[(4)])));

return statearr_83106;
})();
var state_83102__$1 = (function (){var statearr_83107 = state_83102;
(statearr_83107[(7)] = inst_83097);

return statearr_83107;
})();
var statearr_83108_83120 = state_83102__$1;
(statearr_83108_83120[(2)] = inst_83089);

(statearr_83108_83120[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83103 === (3))){
var inst_83100 = (state_83102[(2)]);
var state_83102__$1 = state_83102;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83102__$1,inst_83100);
} else {
if((state_val_83103 === (4))){
var inst_83082 = (state_83102[(2)]);
var state_83102__$1 = state_83102;
var statearr_83110_83121 = state_83102__$1;
(statearr_83110_83121[(2)] = inst_83082);

(statearr_83110_83121[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83103 === (5))){
var _ = (function (){var statearr_83111 = state_83102;
(statearr_83111[(4)] = cljs.core.rest((state_83102[(4)])));

return statearr_83111;
})();
var state_83102__$1 = state_83102;
var ex83109 = (state_83102__$1[(2)]);
var statearr_83112_83122 = state_83102__$1;
(statearr_83112_83122[(5)] = ex83109);


if((ex83109 instanceof Error)){
var statearr_83113_83123 = state_83102__$1;
(statearr_83113_83123[(1)] = (4));

(statearr_83113_83123[(5)] = null);

} else {
throw ex83109;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____0 = (function (){
var statearr_83114 = [null,null,null,null,null,null,null,null];
(statearr_83114[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__);

(statearr_83114[(1)] = (1));

return statearr_83114;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____1 = (function (state_83102){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83102);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83115){var ex__24301__auto__ = e83115;
var statearr_83116_83124 = state_83102;
(statearr_83116_83124[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83102[(4)]))){
var statearr_83117_83125 = state_83102;
(statearr_83117_83125[(1)] = cljs.core.first((state_83102[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83126 = state_83102;
state_83102 = G__83126;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__ = function(state_83102){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____1.call(this,state_83102);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83118 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83118[(6)] = c__24424__auto__);

return statearr_83118;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83156){
var state_val_83157 = (state_83156[(1)]);
if((state_val_83157 === (7))){
var state_83156__$1 = state_83156;
var statearr_83158_83177 = state_83156__$1;
(statearr_83158_83177[(2)] = num);

(statearr_83158_83177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (1))){
var state_83156__$1 = state_83156;
var statearr_83159_83178 = state_83156__$1;
(statearr_83159_83178[(2)] = null);

(statearr_83159_83178[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (4))){
var inst_83127 = (state_83156[(2)]);
var state_83156__$1 = state_83156;
var statearr_83160_83179 = state_83156__$1;
(statearr_83160_83179[(2)] = inst_83127);

(statearr_83160_83179[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (6))){
var state_83156__$1 = state_83156;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83156__$1,(9),num);
} else {
if((state_val_83157 === (3))){
var inst_83154 = (state_83156[(2)]);
var state_83156__$1 = state_83156;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83156__$1,inst_83154);
} else {
if((state_val_83157 === (2))){
var _ = (function (){var statearr_83162 = state_83156;
(statearr_83162[(4)] = cljs.core.cons((5),(state_83156[(4)])));

return statearr_83162;
})();
var inst_83133 = fluree.db.util.async.channel_QMARK_(num);
var state_83156__$1 = state_83156;
if(inst_83133){
var statearr_83163_83180 = state_83156__$1;
(statearr_83163_83180[(1)] = (6));

} else {
var statearr_83164_83181 = state_83156__$1;
(statearr_83164_83181[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (9))){
var inst_83136 = (state_83156[(2)]);
var inst_83137 = fluree.db.util.async.throw_err(inst_83136);
var state_83156__$1 = state_83156;
var statearr_83165_83182 = state_83156__$1;
(statearr_83165_83182[(2)] = inst_83137);

(statearr_83165_83182[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (5))){
var _ = (function (){var statearr_83166 = state_83156;
(statearr_83166[(4)] = cljs.core.rest((state_83156[(4)])));

return statearr_83166;
})();
var state_83156__$1 = state_83156;
var ex83161 = (state_83156__$1[(2)]);
var statearr_83167_83183 = state_83156__$1;
(statearr_83167_83183[(5)] = ex83161);


if((ex83161 instanceof Error)){
var statearr_83168_83184 = state_83156__$1;
(statearr_83168_83184[(1)] = (4));

(statearr_83168_83184[(5)] = null);

} else {
throw ex83161;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83157 === (8))){
var inst_83140 = (state_83156[(2)]);
var inst_83141 = fluree.db.dbfunctions.internal.ceil(inst_83140);
var inst_83142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83143 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83145 = [fluree.db.dbfunctions.fns.ceil];
var inst_83146 = (new cljs.core.PersistentVector(null,1,(5),inst_83144,inst_83145,null));
var inst_83147 = ["",inst_83146,inst_83141];
var inst_83148 = cljs.core.PersistentHashMap.fromArrays(inst_83143,inst_83147);
var inst_83149 = [inst_83148,(10)];
var inst_83150 = (new cljs.core.PersistentVector(null,2,(5),inst_83142,inst_83149,null));
var inst_83151 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83150);
var _ = (function (){var statearr_83169 = state_83156;
(statearr_83169[(4)] = cljs.core.rest((state_83156[(4)])));

return statearr_83169;
})();
var state_83156__$1 = (function (){var statearr_83170 = state_83156;
(statearr_83170[(7)] = inst_83151);

return statearr_83170;
})();
var statearr_83171_83185 = state_83156__$1;
(statearr_83171_83185[(2)] = inst_83141);

(statearr_83171_83185[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____0 = (function (){
var statearr_83172 = [null,null,null,null,null,null,null,null];
(statearr_83172[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__);

(statearr_83172[(1)] = (1));

return statearr_83172;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____1 = (function (state_83156){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83156);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83173){var ex__24301__auto__ = e83173;
var statearr_83174_83186 = state_83156;
(statearr_83174_83186[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83156[(4)]))){
var statearr_83175_83187 = state_83156;
(statearr_83175_83187[(1)] = cljs.core.first((state_83156[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83188 = state_83156;
state_83156 = G__83188;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__ = function(state_83156){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____1.call(this,state_83156);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83176 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83176[(6)] = c__24424__auto__);

return statearr_83176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83218){
var state_val_83219 = (state_83218[(1)]);
if((state_val_83219 === (7))){
var state_83218__$1 = state_83218;
var statearr_83220_83239 = state_83218__$1;
(statearr_83220_83239[(2)] = num);

(statearr_83220_83239[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (1))){
var state_83218__$1 = state_83218;
var statearr_83221_83240 = state_83218__$1;
(statearr_83221_83240[(2)] = null);

(statearr_83221_83240[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (4))){
var inst_83189 = (state_83218[(2)]);
var state_83218__$1 = state_83218;
var statearr_83222_83241 = state_83218__$1;
(statearr_83222_83241[(2)] = inst_83189);

(statearr_83222_83241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (6))){
var state_83218__$1 = state_83218;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83218__$1,(9),num);
} else {
if((state_val_83219 === (3))){
var inst_83216 = (state_83218[(2)]);
var state_83218__$1 = state_83218;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83218__$1,inst_83216);
} else {
if((state_val_83219 === (2))){
var _ = (function (){var statearr_83224 = state_83218;
(statearr_83224[(4)] = cljs.core.cons((5),(state_83218[(4)])));

return statearr_83224;
})();
var inst_83195 = fluree.db.util.async.channel_QMARK_(num);
var state_83218__$1 = state_83218;
if(inst_83195){
var statearr_83225_83242 = state_83218__$1;
(statearr_83225_83242[(1)] = (6));

} else {
var statearr_83226_83243 = state_83218__$1;
(statearr_83226_83243[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (9))){
var inst_83198 = (state_83218[(2)]);
var inst_83199 = fluree.db.util.async.throw_err(inst_83198);
var state_83218__$1 = state_83218;
var statearr_83227_83244 = state_83218__$1;
(statearr_83227_83244[(2)] = inst_83199);

(statearr_83227_83244[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (5))){
var _ = (function (){var statearr_83228 = state_83218;
(statearr_83228[(4)] = cljs.core.rest((state_83218[(4)])));

return statearr_83228;
})();
var state_83218__$1 = state_83218;
var ex83223 = (state_83218__$1[(2)]);
var statearr_83229_83245 = state_83218__$1;
(statearr_83229_83245[(5)] = ex83223);


if((ex83223 instanceof Error)){
var statearr_83230_83246 = state_83218__$1;
(statearr_83230_83246[(1)] = (4));

(statearr_83230_83246[(5)] = null);

} else {
throw ex83223;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83219 === (8))){
var inst_83202 = (state_83218[(2)]);
var inst_83203 = fluree.db.dbfunctions.internal.floor(inst_83202);
var inst_83204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83205 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83206 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83207 = [fluree.db.dbfunctions.fns.floor];
var inst_83208 = (new cljs.core.PersistentVector(null,1,(5),inst_83206,inst_83207,null));
var inst_83209 = ["",inst_83208,inst_83203];
var inst_83210 = cljs.core.PersistentHashMap.fromArrays(inst_83205,inst_83209);
var inst_83211 = [inst_83210,(10)];
var inst_83212 = (new cljs.core.PersistentVector(null,2,(5),inst_83204,inst_83211,null));
var inst_83213 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83212);
var _ = (function (){var statearr_83231 = state_83218;
(statearr_83231[(4)] = cljs.core.rest((state_83218[(4)])));

return statearr_83231;
})();
var state_83218__$1 = (function (){var statearr_83232 = state_83218;
(statearr_83232[(7)] = inst_83213);

return statearr_83232;
})();
var statearr_83233_83247 = state_83218__$1;
(statearr_83233_83247[(2)] = inst_83203);

(statearr_83233_83247[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____0 = (function (){
var statearr_83234 = [null,null,null,null,null,null,null,null];
(statearr_83234[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__);

(statearr_83234[(1)] = (1));

return statearr_83234;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____1 = (function (state_83218){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83218);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83235){var ex__24301__auto__ = e83235;
var statearr_83236_83248 = state_83218;
(statearr_83236_83248[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83218[(4)]))){
var statearr_83237_83249 = state_83218;
(statearr_83237_83249[(1)] = cljs.core.first((state_83218[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83250 = state_83218;
state_83218 = G__83250;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__ = function(state_83218){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____1.call(this,state_83218);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83238 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83238[(6)] = c__24424__auto__);

return statearr_83238;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_83275){
var state_val_83276 = (state_83275[(1)]);
if((state_val_83276 === (1))){
var state_83275__$1 = state_83275;
var statearr_83277_83292 = state_83275__$1;
(statearr_83277_83292[(2)] = null);

(statearr_83277_83292[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83276 === (2))){
var _ = (function (){var statearr_83278 = state_83275;
(statearr_83278[(4)] = cljs.core.cons((5),(state_83275[(4)])));

return statearr_83278;
})();
var inst_83257 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_83275__$1 = state_83275;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_83275__$1,(6),inst_83257);
} else {
if((state_val_83276 === (3))){
var inst_83273 = (state_83275[(2)]);
var state_83275__$1 = state_83275;
return cljs.core.async.impl.ioc_helpers.return_chan(state_83275__$1,inst_83273);
} else {
if((state_val_83276 === (4))){
var inst_83251 = (state_83275[(2)]);
var state_83275__$1 = state_83275;
var statearr_83280_83293 = state_83275__$1;
(statearr_83280_83293[(2)] = inst_83251);

(statearr_83280_83293[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_83276 === (5))){
var _ = (function (){var statearr_83281 = state_83275;
(statearr_83281[(4)] = cljs.core.rest((state_83275[(4)])));

return statearr_83281;
})();
var state_83275__$1 = state_83275;
var ex83279 = (state_83275__$1[(2)]);
var statearr_83282_83294 = state_83275__$1;
(statearr_83282_83294[(5)] = ex83279);


if((ex83279 instanceof Error)){
var statearr_83283_83295 = state_83275__$1;
(statearr_83283_83295[(1)] = (4));

(statearr_83283_83295[(5)] = null);

} else {
throw ex83279;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_83276 === (6))){
var inst_83259 = (state_83275[(2)]);
var inst_83260 = fluree.db.util.async.throw_err(inst_83259);
var inst_83261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83262 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_83263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_83264 = [compare_val,new_val];
var inst_83265 = (new cljs.core.PersistentVector(null,2,(5),inst_83263,inst_83264,null));
var inst_83266 = ["",inst_83265,inst_83260];
var inst_83267 = cljs.core.PersistentHashMap.fromArrays(inst_83262,inst_83266);
var inst_83268 = [inst_83267,(10)];
var inst_83269 = (new cljs.core.PersistentVector(null,2,(5),inst_83261,inst_83268,null));
var inst_83270 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_83269);
var _ = (function (){var statearr_83284 = state_83275;
(statearr_83284[(4)] = cljs.core.rest((state_83275[(4)])));

return statearr_83284;
})();
var state_83275__$1 = (function (){var statearr_83285 = state_83275;
(statearr_83285[(7)] = inst_83270);

return statearr_83285;
})();
var statearr_83286_83296 = state_83275__$1;
(statearr_83286_83296[(2)] = inst_83260);

(statearr_83286_83296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____0 = (function (){
var statearr_83287 = [null,null,null,null,null,null,null,null];
(statearr_83287[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__);

(statearr_83287[(1)] = (1));

return statearr_83287;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____1 = (function (state_83275){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_83275);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e83288){var ex__24301__auto__ = e83288;
var statearr_83289_83297 = state_83275;
(statearr_83289_83297[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_83275[(4)]))){
var statearr_83290_83298 = state_83275;
(statearr_83290_83298[(1)] = cljs.core.first((state_83275[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__83299 = state_83275;
state_83275 = G__83299;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__ = function(state_83275){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____1.call(this,state_83275);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_83291 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_83291[(6)] = c__24424__auto__);

return statearr_83291;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
