// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__52189 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52189,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52189,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52189,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__52192){
var map__52193 = p__52192;
var map__52193__$1 = cljs.core.__destructure_map(map__52193);
var opts = map__52193__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52193__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_52253){
var state_val_52254 = (state_52253[(1)]);
if((state_val_52254 === (7))){
var inst_52224 = cljs.core.not(reindex_QMARK_);
var state_52253__$1 = state_52253;
var statearr_52255_52279 = state_52253__$1;
(statearr_52255_52279[(2)] = inst_52224);

(statearr_52255_52279[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (1))){
var state_52253__$1 = state_52253;
var statearr_52256_52280 = state_52253__$1;
(statearr_52256_52280[(2)] = null);

(statearr_52256_52280[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (4))){
var inst_52194 = (state_52253[(2)]);
var state_52253__$1 = state_52253;
var statearr_52257_52281 = state_52253__$1;
(statearr_52257_52281[(2)] = inst_52194);

(statearr_52257_52281[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (6))){
var inst_52222 = (state_52253[(7)]);
var inst_52214 = (state_52253[(8)]);
var inst_52208 = (state_52253[(9)]);
var inst_52207 = (state_52253[(2)]);
var inst_52208__$1 = fluree.db.util.async.throw_err(inst_52207);
var inst_52209 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_52210 = cljs.core.__destructure_map(inst_52209);
var inst_52211 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52210,cljs.core.cst$kw$post);
var inst_52212 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52210,cljs.core.cst$kw$size);
var inst_52213 = fluree.db.flake.size_bytes(inst_52208__$1);
var inst_52214__$1 = (inst_52212 + inst_52213);
var inst_52215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52216 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_52217 = (new cljs.core.PersistentVector(null,2,(5),inst_52215,inst_52216,null));
var inst_52218 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_52217);
var inst_52219 = cljs.core.__destructure_map(inst_52218);
var inst_52220 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52219,cljs.core.cst$kw$novelty_DASH_min);
var inst_52221 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52219,cljs.core.cst$kw$novelty_DASH_max);
var inst_52222__$1 = (inst_52214__$1 > inst_52221);
var state_52253__$1 = (function (){var statearr_52258 = state_52253;
(statearr_52258[(7)] = inst_52222__$1);

(statearr_52258[(10)] = inst_52211);

(statearr_52258[(8)] = inst_52214__$1);

(statearr_52258[(9)] = inst_52208__$1);

(statearr_52258[(11)] = inst_52220);

return statearr_52258;
})();
if(cljs.core.truth_(inst_52222__$1)){
var statearr_52259_52282 = state_52253__$1;
(statearr_52259_52282[(1)] = (7));

} else {
var statearr_52260_52283 = state_52253__$1;
(statearr_52260_52283[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (3))){
var inst_52251 = (state_52253[(2)]);
var state_52253__$1 = state_52253;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52253__$1,inst_52251);
} else {
if((state_val_52254 === (12))){
var inst_52211 = (state_52253[(10)]);
var inst_52214 = (state_52253[(8)]);
var inst_52208 = (state_52253[(9)]);
var inst_52237 = (state_52253[(2)]);
var inst_52238 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_52211,inst_52208);
var inst_52239 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_52240 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_52239,cljs.core.empty);
var inst_52241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52242 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_52243 = (new cljs.core.PersistentVector(null,2,(5),inst_52241,inst_52242,null));
var inst_52244 = cljs.core.assoc_in(db,inst_52243,inst_52238);
var inst_52245 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52246 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_52247 = (new cljs.core.PersistentVector(null,2,(5),inst_52245,inst_52246,null));
var inst_52248 = cljs.core.assoc_in(inst_52244,inst_52247,inst_52214);
var _ = (function (){var statearr_52261 = state_52253;
(statearr_52261[(4)] = cljs.core.rest((state_52253[(4)])));

return statearr_52261;
})();
var state_52253__$1 = (function (){var statearr_52262 = state_52253;
(statearr_52262[(12)] = inst_52237);

(statearr_52262[(13)] = inst_52240);

return statearr_52262;
})();
var statearr_52263_52284 = state_52253__$1;
(statearr_52263_52284[(2)] = inst_52248);

(statearr_52263_52284[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (2))){
var _ = (function (){var statearr_52264 = state_52253;
(statearr_52264[(4)] = cljs.core.cons((5),(state_52253[(4)])));

return statearr_52264;
})();
var inst_52202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52203 = [pred_id];
var inst_52204 = (new cljs.core.PersistentVector(null,1,(5),inst_52202,inst_52203,null));
var inst_52205 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_52204);
var state_52253__$1 = state_52253;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52253__$1,(6),inst_52205);
} else {
if((state_val_52254 === (11))){
var state_52253__$1 = state_52253;
var statearr_52266_52285 = state_52253__$1;
(statearr_52266_52285[(2)] = null);

(statearr_52266_52285[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (9))){
var inst_52227 = (state_52253[(2)]);
var state_52253__$1 = state_52253;
if(cljs.core.truth_(inst_52227)){
var statearr_52267_52286 = state_52253__$1;
(statearr_52267_52286[(1)] = (10));

} else {
var statearr_52268_52287 = state_52253__$1;
(statearr_52268_52287[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (5))){
var _ = (function (){var statearr_52269 = state_52253;
(statearr_52269[(4)] = cljs.core.rest((state_52253[(4)])));

return statearr_52269;
})();
var state_52253__$1 = state_52253;
var ex52265 = (state_52253__$1[(2)]);
var statearr_52270_52288 = state_52253__$1;
(statearr_52270_52288[(5)] = ex52265);


if((ex52265 instanceof Error)){
var statearr_52271_52289 = state_52253__$1;
(statearr_52271_52289[(1)] = (4));

(statearr_52271_52289[(5)] = null);

} else {
throw ex52265;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (10))){
var inst_52229 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_52230 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_52231 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_52232 = cljs.core.PersistentHashMap.fromArrays(inst_52230,inst_52231);
var inst_52233 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52229,inst_52232);
var inst_52234 = (function(){throw inst_52233})();
var state_52253__$1 = state_52253;
var statearr_52272_52290 = state_52253__$1;
(statearr_52272_52290[(2)] = inst_52234);

(statearr_52272_52290[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52254 === (8))){
var inst_52222 = (state_52253[(7)]);
var state_52253__$1 = state_52253;
var statearr_52273_52291 = state_52253__$1;
(statearr_52273_52291[(2)] = inst_52222);

(statearr_52273_52291[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____0 = (function (){
var statearr_52274 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52274[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__);

(statearr_52274[(1)] = (1));

return statearr_52274;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____1 = (function (state_52253){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_52253);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e52275){var ex__24301__auto__ = e52275;
var statearr_52276_52292 = state_52253;
(statearr_52276_52292[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_52253[(4)]))){
var statearr_52277_52293 = state_52253;
(statearr_52277_52293[(1)] = cljs.core.first((state_52253[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__52294 = state_52253;
state_52253 = G__52294;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__ = function(state_52253){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____1.call(this,state_52253);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_52278 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_52278[(6)] = c__24424__auto__);

return statearr_52278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__52299 = arguments.length;
switch (G__52299) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_52495){
var state_val_52496 = (state_52495[(1)]);
if((state_val_52496 === (7))){
var state_52495__$1 = state_52495;
var statearr_52497_52565 = state_52495__$1;
(statearr_52497_52565[(2)] = null);

(statearr_52497_52565[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (20))){
var inst_52419 = (state_52495[(7)]);
var inst_52418 = (state_52495[(8)]);
var inst_52337 = (state_52495[(9)]);
var inst_52417 = (state_52495[(10)]);
var inst_52388 = (state_52495[(11)]);
var inst_52420 = (state_52495[(12)]);
var inst_52421 = (state_52495[(13)]);
var inst_52338 = (state_52495[(14)]);
var inst_52431 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_52432 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52433 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_52434 = (new cljs.core.PersistentVector(null,2,(5),inst_52432,inst_52433,null));
var inst_52435 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_52388,inst_52434);
var inst_52436 = (inst_52337 + inst_52435);
var inst_52437 = [inst_52417,inst_52418,inst_52419,inst_52420,inst_52436];
var inst_52438 = cljs.core.PersistentHashMap.fromArrays(inst_52431,inst_52437);
var inst_52439 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_52388,cljs.core.cst$kw$ecount,inst_52421,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_52438], 0));
var state_52495__$1 = (function (){var statearr_52498 = state_52495;
(statearr_52498[(15)] = inst_52439);

return statearr_52498;
})();
if(cljs.core.truth_(inst_52338)){
var statearr_52499_52566 = state_52495__$1;
(statearr_52499_52566[(1)] = (23));

} else {
var statearr_52500_52567 = state_52495__$1;
(statearr_52500_52567[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (27))){
var inst_52439 = (state_52495[(15)]);
var state_52495__$1 = state_52495;
var statearr_52501_52568 = state_52495__$1;
(statearr_52501_52568[(2)] = inst_52439);

(statearr_52501_52568[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (1))){
var state_52495__$1 = state_52495;
var statearr_52502_52569 = state_52495__$1;
(statearr_52502_52569[(2)] = null);

(statearr_52502_52569[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (24))){
var inst_52439 = (state_52495[(15)]);
var inst_52442 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_52439);
var inst_52443 = (inst_52442 == null);
var state_52495__$1 = state_52495;
var statearr_52503_52570 = state_52495__$1;
(statearr_52503_52570[(2)] = inst_52443);

(statearr_52503_52570[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (39))){
var inst_52469 = (state_52495[(16)]);
var inst_52470 = (state_52495[(17)]);
var inst_52478 = (state_52495[(18)]);
var inst_52471 = (state_52495[(19)]);
var inst_52428 = (state_52495[(20)]);
var inst_52485 = (state_52495[(2)]);
var inst_52416 = inst_52428;
var inst_52417 = inst_52470;
var inst_52418 = inst_52471;
var inst_52419 = inst_52478;
var inst_52420 = inst_52485;
var inst_52421 = inst_52469;
var state_52495__$1 = (function (){var statearr_52504 = state_52495;
(statearr_52504[(7)] = inst_52419);

(statearr_52504[(21)] = inst_52416);

(statearr_52504[(8)] = inst_52418);

(statearr_52504[(10)] = inst_52417);

(statearr_52504[(12)] = inst_52420);

(statearr_52504[(13)] = inst_52421);

return statearr_52504;
})();
var statearr_52505_52571 = state_52495__$1;
(statearr_52505_52571[(2)] = null);

(statearr_52505_52571[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (4))){
var inst_52300 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
var statearr_52506_52572 = state_52495__$1;
(statearr_52506_52572[(2)] = inst_52300);

(statearr_52506_52572[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (15))){
var inst_52360 = (state_52495[(22)]);
var state_52495__$1 = state_52495;
var statearr_52507_52573 = state_52495__$1;
(statearr_52507_52573[(2)] = inst_52360);

(statearr_52507_52573[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (21))){
var inst_52347 = (state_52495[(23)]);
var inst_52419 = (state_52495[(7)]);
var inst_52398 = (state_52495[(24)]);
var inst_52416 = (state_52495[(21)]);
var inst_52418 = (state_52495[(8)]);
var inst_52337 = (state_52495[(9)]);
var inst_52339 = (state_52495[(25)]);
var inst_52324 = (state_52495[(26)]);
var inst_52322 = (state_52495[(27)]);
var inst_52328 = (state_52495[(28)]);
var inst_52417 = (state_52495[(10)]);
var inst_52388 = (state_52495[(11)]);
var inst_52420 = (state_52495[(12)]);
var inst_52428 = (state_52495[(20)]);
var inst_52332 = (state_52495[(29)]);
var inst_52307 = (state_52495[(30)]);
var inst_52341 = (state_52495[(31)]);
var inst_52421 = (state_52495[(13)]);
var inst_52427 = (state_52495[(32)]);
var inst_52338 = (state_52495[(14)]);
var inst_52336 = (state_52495[(33)]);
var inst_52397 = (state_52495[(34)]);
var inst_52466 = inst_52427.s;
var inst_52467 = fluree.db.flake.sid__GT_cid(inst_52466);
var inst_52468 = (function (){var flakes_bytes = inst_52337;
var t = inst_52307;
var spot = inst_52417;
var seq__52424 = inst_52428;
var add_flakes = inst_52324;
var G__52392 = inst_52416;
var root_setting_change_QMARK_ = inst_52339;
var ref_QMARK__map = inst_52336;
var r = inst_52428;
var psot = inst_52418;
var add_pred_to_idx_QMARK_ = inst_52347;
var _ = inst_52322;
var cid = inst_52467;
var ecount = inst_52421;
var vec__52423 = inst_52416;
var pred_ecount = inst_52341;
var vec__52393 = inst_52324;
var db_STAR_ = inst_52388;
var schema_change_QMARK_ = inst_52338;
var first__52395 = inst_52397;
var add_preds = inst_52328;
var first__52425 = inst_52427;
var seq__52394 = inst_52398;
var opst = inst_52420;
var idx_QMARK__map = inst_52332;
var post = inst_52419;
var f = inst_52427;
return (function (p1__52297_SHARP_){
if(cljs.core.truth_(p1__52297_SHARP_)){
var x__4295__auto__ = p1__52297_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_52469 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_52421,inst_52467,inst_52468);
var inst_52470 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52417,inst_52427);
var inst_52471 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52418,inst_52427);
var inst_52472 = inst_52427.p;
var inst_52473 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52332,inst_52472);
var state_52495__$1 = (function (){var statearr_52508 = state_52495;
(statearr_52508[(16)] = inst_52469);

(statearr_52508[(17)] = inst_52470);

(statearr_52508[(19)] = inst_52471);

return statearr_52508;
})();
if(cljs.core.truth_(inst_52473)){
var statearr_52509_52574 = state_52495__$1;
(statearr_52509_52574[(1)] = (34));

} else {
var statearr_52510_52575 = state_52495__$1;
(statearr_52510_52575[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (31))){
var inst_52454 = (state_52495[(35)]);
var state_52495__$1 = state_52495;
var statearr_52511_52576 = state_52495__$1;
(statearr_52511_52576[(2)] = inst_52454);

(statearr_52511_52576[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (32))){
var inst_52464 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
var statearr_52512_52577 = state_52495__$1;
(statearr_52512_52577[(2)] = inst_52464);

(statearr_52512_52577[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (33))){
var inst_52454 = (state_52495[(35)]);
var inst_52459 = (state_52495[(2)]);
var inst_52460 = fluree.db.util.async.throw_err(inst_52459);
var inst_52461 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_52454,cljs.core.cst$kw$settings,inst_52460);
var state_52495__$1 = state_52495;
var statearr_52513_52578 = state_52495__$1;
(statearr_52513_52578[(2)] = inst_52461);

(statearr_52513_52578[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (13))){
var inst_52337 = (state_52495[(9)]);
var inst_52324 = (state_52495[(26)]);
var inst_52388 = (state_52495[(11)]);
var inst_52307 = (state_52495[(30)]);
var inst_52378 = (state_52495[(2)]);
var inst_52379 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_52378,cljs.core.cst$kw$t,inst_52307);
var inst_52380 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52381 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_52382 = (new cljs.core.PersistentVector(null,2,(5),inst_52380,inst_52381,null));
var inst_52383 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_52379,inst_52382,cljs.core._PLUS_,inst_52337);
var inst_52384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52385 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_52386 = (new cljs.core.PersistentVector(null,2,(5),inst_52384,inst_52385,null));
var inst_52387 = cljs.core.count(inst_52324);
var inst_52388__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_52383,inst_52386,cljs.core._PLUS_,inst_52387);
var inst_52396 = cljs.core.seq(inst_52324);
var inst_52397 = cljs.core.first(inst_52396);
var inst_52398 = cljs.core.next(inst_52396);
var inst_52399 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52400 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_52401 = (new cljs.core.PersistentVector(null,2,(5),inst_52399,inst_52400,null));
var inst_52402 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_52388__$1,inst_52401);
var inst_52403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52404 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_52405 = (new cljs.core.PersistentVector(null,2,(5),inst_52403,inst_52404,null));
var inst_52406 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_52388__$1,inst_52405);
var inst_52407 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52408 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_52409 = (new cljs.core.PersistentVector(null,2,(5),inst_52407,inst_52408,null));
var inst_52410 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_52388__$1,inst_52409);
var inst_52411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52412 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_52413 = (new cljs.core.PersistentVector(null,2,(5),inst_52411,inst_52412,null));
var inst_52414 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_52388__$1,inst_52413);
var inst_52415 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_52416 = inst_52324;
var inst_52417 = inst_52402;
var inst_52418 = inst_52406;
var inst_52419 = inst_52410;
var inst_52420 = inst_52414;
var inst_52421 = inst_52415;
var state_52495__$1 = (function (){var statearr_52514 = state_52495;
(statearr_52514[(7)] = inst_52419);

(statearr_52514[(24)] = inst_52398);

(statearr_52514[(21)] = inst_52416);

(statearr_52514[(8)] = inst_52418);

(statearr_52514[(10)] = inst_52417);

(statearr_52514[(11)] = inst_52388__$1);

(statearr_52514[(12)] = inst_52420);

(statearr_52514[(13)] = inst_52421);

(statearr_52514[(34)] = inst_52397);

return statearr_52514;
})();
var statearr_52515_52579 = state_52495__$1;
(statearr_52515_52579[(2)] = null);

(statearr_52515_52579[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (22))){
var inst_52488 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
var statearr_52516_52580 = state_52495__$1;
(statearr_52516_52580[(2)] = inst_52488);

(statearr_52516_52580[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (36))){
var inst_52427 = (state_52495[(32)]);
var inst_52336 = (state_52495[(33)]);
var inst_52478 = (state_52495[(2)]);
var inst_52479 = inst_52427.p;
var inst_52480 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52336,inst_52479);
var state_52495__$1 = (function (){var statearr_52517 = state_52495;
(statearr_52517[(18)] = inst_52478);

return statearr_52517;
})();
if(cljs.core.truth_(inst_52480)){
var statearr_52518_52581 = state_52495__$1;
(statearr_52518_52581[(1)] = (37));

} else {
var statearr_52519_52582 = state_52495__$1;
(statearr_52519_52582[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (29))){
var inst_52439 = (state_52495[(15)]);
var inst_52449 = (state_52495[(2)]);
var inst_52450 = fluree.db.util.async.throw_err(inst_52449);
var inst_52451 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_52439,cljs.core.cst$kw$schema,inst_52450);
var state_52495__$1 = state_52495;
var statearr_52520_52583 = state_52495__$1;
(statearr_52520_52583[(2)] = inst_52451);

(statearr_52520_52583[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (6))){
var inst_52307 = (state_52495[(30)]);
var inst_52312 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_52313 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_52314 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52312)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52313)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52307),"."].join('');
var inst_52315 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52316 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_52317 = cljs.core.PersistentHashMap.fromArrays(inst_52315,inst_52316);
var inst_52318 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52314,inst_52317);
var inst_52319 = (function(){throw inst_52318})();
var state_52495__$1 = state_52495;
var statearr_52521_52584 = state_52495__$1;
(statearr_52521_52584[(2)] = inst_52319);

(statearr_52521_52584[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (28))){
var inst_52339 = (state_52495[(25)]);
var inst_52454 = (state_52495[(2)]);
var state_52495__$1 = (function (){var statearr_52522 = state_52495;
(statearr_52522[(35)] = inst_52454);

return statearr_52522;
})();
if(cljs.core.truth_(inst_52339)){
var statearr_52523_52585 = state_52495__$1;
(statearr_52523_52585[(1)] = (30));

} else {
var statearr_52524_52586 = state_52495__$1;
(statearr_52524_52586[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (25))){
var inst_52445 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
if(cljs.core.truth_(inst_52445)){
var statearr_52525_52587 = state_52495__$1;
(statearr_52525_52587[(1)] = (26));

} else {
var statearr_52526_52588 = state_52495__$1;
(statearr_52526_52588[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (34))){
var inst_52419 = (state_52495[(7)]);
var inst_52427 = (state_52495[(32)]);
var inst_52475 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52419,inst_52427);
var state_52495__$1 = state_52495;
var statearr_52527_52589 = state_52495__$1;
(statearr_52527_52589[(2)] = inst_52475);

(statearr_52527_52589[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (17))){
var inst_52367 = (state_52495[(36)]);
var inst_52371 = (state_52495[(2)]);
var inst_52372 = fluree.db.util.async.throw_err(inst_52371);
var inst_52359 = inst_52367;
var inst_52360 = inst_52372;
var state_52495__$1 = (function (){var statearr_52528 = state_52495;
(statearr_52528[(22)] = inst_52360);

(statearr_52528[(37)] = inst_52359);

return statearr_52528;
})();
var statearr_52529_52590 = state_52495__$1;
(statearr_52529_52590[(2)] = null);

(statearr_52529_52590[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (3))){
var inst_52493 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52495__$1,inst_52493);
} else {
if((state_val_52496 === (12))){
var inst_52366 = (state_52495[(38)]);
var inst_52359 = (state_52495[(37)]);
var inst_52365 = cljs.core.seq(inst_52359);
var inst_52366__$1 = cljs.core.first(inst_52365);
var inst_52367 = cljs.core.next(inst_52365);
var state_52495__$1 = (function (){var statearr_52530 = state_52495;
(statearr_52530[(36)] = inst_52367);

(statearr_52530[(38)] = inst_52366__$1);

return statearr_52530;
})();
if(cljs.core.truth_(inst_52366__$1)){
var statearr_52531_52591 = state_52495__$1;
(statearr_52531_52591[(1)] = (14));

} else {
var statearr_52532_52592 = state_52495__$1;
(statearr_52532_52592[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (2))){
var inst_52307 = (state_52495[(30)]);
var _ = (function (){var statearr_52533 = state_52495;
(statearr_52533[(4)] = cljs.core.cons((5),(state_52495[(4)])));

return statearr_52533;
})();
var inst_52306 = cljs.core.first(flakes);
var inst_52307__$1 = inst_52306.t;
var inst_52308 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_52309 = (inst_52308 - (1));
var inst_52310 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_52307__$1,inst_52309);
var state_52495__$1 = (function (){var statearr_52534 = state_52495;
(statearr_52534[(30)] = inst_52307__$1);

return statearr_52534;
})();
if(inst_52310){
var statearr_52535_52593 = state_52495__$1;
(statearr_52535_52593[(1)] = (6));

} else {
var statearr_52536_52594 = state_52495__$1;
(statearr_52536_52594[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (23))){
var inst_52338 = (state_52495[(14)]);
var state_52495__$1 = state_52495;
var statearr_52537_52595 = state_52495__$1;
(statearr_52537_52595[(2)] = inst_52338);

(statearr_52537_52595[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (35))){
var inst_52419 = (state_52495[(7)]);
var state_52495__$1 = state_52495;
var statearr_52538_52596 = state_52495__$1;
(statearr_52538_52596[(2)] = inst_52419);

(statearr_52538_52596[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (19))){
var inst_52490 = (state_52495[(2)]);
var _ = (function (){var statearr_52539 = state_52495;
(statearr_52539[(4)] = cljs.core.rest((state_52495[(4)])));

return statearr_52539;
})();
var state_52495__$1 = state_52495;
var statearr_52540_52597 = state_52495__$1;
(statearr_52540_52597[(2)] = inst_52490);

(statearr_52540_52597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (11))){
var inst_52347 = (state_52495[(23)]);
var inst_52347__$1 = (state_52495[(2)]);
var inst_52355 = cljs.core.seq(inst_52347__$1);
var inst_52356 = cljs.core.first(inst_52355);
var inst_52357 = cljs.core.next(inst_52355);
var inst_52358 = db;
var inst_52359 = inst_52347__$1;
var inst_52360 = inst_52358;
var state_52495__$1 = (function (){var statearr_52542 = state_52495;
(statearr_52542[(23)] = inst_52347__$1);

(statearr_52542[(22)] = inst_52360);

(statearr_52542[(39)] = inst_52357);

(statearr_52542[(40)] = inst_52356);

(statearr_52542[(37)] = inst_52359);

return statearr_52542;
})();
var statearr_52543_52598 = state_52495__$1;
(statearr_52543_52598[(2)] = null);

(statearr_52543_52598[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (9))){
var inst_52324 = (state_52495[(26)]);
var inst_52341 = (state_52495[(31)]);
var inst_52343 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_52324,inst_52341);
var state_52495__$1 = state_52495;
var statearr_52544_52599 = state_52495__$1;
(statearr_52544_52599[(2)] = inst_52343);

(statearr_52544_52599[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (5))){
var _ = (function (){var statearr_52545 = state_52495;
(statearr_52545[(4)] = cljs.core.rest((state_52495[(4)])));

return statearr_52545;
})();
var state_52495__$1 = state_52495;
var ex52541 = (state_52495__$1[(2)]);
var statearr_52546_52600 = state_52495__$1;
(statearr_52546_52600[(5)] = ex52541);


if((ex52541 instanceof Error)){
var statearr_52547_52601 = state_52495__$1;
(statearr_52547_52601[(1)] = (4));

(statearr_52547_52601[(5)] = null);

} else {
throw ex52541;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (14))){
var inst_52360 = (state_52495[(22)]);
var inst_52366 = (state_52495[(38)]);
var inst_52369 = fluree.db.graphdb.add_predicate_to_idx(inst_52360,inst_52366,opts);
var state_52495__$1 = state_52495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52495__$1,(17),inst_52369);
} else {
if((state_val_52496 === (26))){
var inst_52439 = (state_52495[(15)]);
var inst_52447 = fluree.db.query.schema.schema_map(inst_52439);
var state_52495__$1 = state_52495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52495__$1,(29),inst_52447);
} else {
if((state_val_52496 === (16))){
var inst_52376 = (state_52495[(2)]);
var state_52495__$1 = state_52495;
var statearr_52548_52602 = state_52495__$1;
(statearr_52548_52602[(2)] = inst_52376);

(statearr_52548_52602[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (38))){
var inst_52420 = (state_52495[(12)]);
var state_52495__$1 = state_52495;
var statearr_52549_52603 = state_52495__$1;
(statearr_52549_52603[(2)] = inst_52420);

(statearr_52549_52603[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (30))){
var inst_52454 = (state_52495[(35)]);
var inst_52457 = fluree.db.query.schema.setting_map(inst_52454);
var state_52495__$1 = state_52495;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52495__$1,(33),inst_52457);
} else {
if((state_val_52496 === (10))){
var inst_52345 = cljs.core.PersistentVector.EMPTY;
var state_52495__$1 = state_52495;
var statearr_52550_52604 = state_52495__$1;
(statearr_52550_52604[(2)] = inst_52345);

(statearr_52550_52604[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (18))){
var inst_52416 = (state_52495[(21)]);
var inst_52427 = (state_52495[(32)]);
var inst_52426 = cljs.core.seq(inst_52416);
var inst_52427__$1 = cljs.core.first(inst_52426);
var inst_52428 = cljs.core.next(inst_52426);
var inst_52429 = cljs.core.not(inst_52427__$1);
var state_52495__$1 = (function (){var statearr_52551 = state_52495;
(statearr_52551[(20)] = inst_52428);

(statearr_52551[(32)] = inst_52427__$1);

return statearr_52551;
})();
if(inst_52429){
var statearr_52552_52605 = state_52495__$1;
(statearr_52552_52605[(1)] = (20));

} else {
var statearr_52553_52606 = state_52495__$1;
(statearr_52553_52606[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (37))){
var inst_52420 = (state_52495[(12)]);
var inst_52427 = (state_52495[(32)]);
var inst_52482 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52420,inst_52427);
var state_52495__$1 = state_52495;
var statearr_52554_52607 = state_52495__$1;
(statearr_52554_52607[(2)] = inst_52482);

(statearr_52554_52607[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52496 === (8))){
var inst_52324 = (state_52495[(26)]);
var inst_52322 = (state_52495[(27)]);
var inst_52328 = (state_52495[(28)]);
var inst_52332 = (state_52495[(29)]);
var inst_52307 = (state_52495[(30)]);
var inst_52338 = (state_52495[(14)]);
var inst_52322__$1 = (state_52495[(2)]);
var inst_52323 = (function (){var t = inst_52307;
var _ = inst_52322__$1;
return (function (p1__52295_SHARP_){
return cljs.core.not((function (){var G__52555 = p1__52295_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__52555) : fluree.db.graphdb.exclude_predicates.call(null,G__52555));
})());
});
})();
var inst_52324__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_52323,flakes);
var inst_52325 = cljs.core.PersistentHashSet.EMPTY;
var inst_52326 = (function (){var t = inst_52307;
var _ = inst_52322__$1;
var add_flakes = inst_52324__$1;
return (function (p1__52296_SHARP_){
return p1__52296_SHARP_.p;
});
})();
var inst_52327 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_52326,inst_52324__$1);
var inst_52328__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_52325,inst_52327);
var inst_52329 = cljs.core.PersistentHashMap.EMPTY;
var inst_52330 = (function (){var t = inst_52307;
var _ = inst_52322__$1;
var add_flakes = inst_52324__$1;
var add_preds = inst_52328__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_52331 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_52330,inst_52328__$1);
var inst_52332__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_52329,inst_52331);
var inst_52333 = cljs.core.PersistentHashMap.EMPTY;
var inst_52334 = (function (){var t = inst_52307;
var _ = inst_52322__$1;
var add_flakes = inst_52324__$1;
var add_preds = inst_52328__$1;
var idx_QMARK__map = inst_52332__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_52335 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_52334,inst_52328__$1);
var inst_52336 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_52333,inst_52335);
var inst_52337 = fluree.db.flake.size_bytes(inst_52324__$1);
var inst_52338__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_52324__$1);
var inst_52339 = fluree.db.util.schema.setting_change_QMARK_(inst_52324__$1);
var inst_52340 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_52341 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52340,(0));
var state_52495__$1 = (function (){var statearr_52556 = state_52495;
(statearr_52556[(9)] = inst_52337);

(statearr_52556[(25)] = inst_52339);

(statearr_52556[(26)] = inst_52324__$1);

(statearr_52556[(27)] = inst_52322__$1);

(statearr_52556[(28)] = inst_52328__$1);

(statearr_52556[(29)] = inst_52332__$1);

(statearr_52556[(31)] = inst_52341);

(statearr_52556[(14)] = inst_52338__$1);

(statearr_52556[(33)] = inst_52336);

return statearr_52556;
})();
if(cljs.core.truth_(inst_52338__$1)){
var statearr_52557_52608 = state_52495__$1;
(statearr_52557_52608[(1)] = (9));

} else {
var statearr_52558_52609 = state_52495__$1;
(statearr_52558_52609[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_52559 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52559[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_52559[(1)] = (1));

return statearr_52559;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_52495){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_52495);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e52560){var ex__24301__auto__ = e52560;
var statearr_52561_52610 = state_52495;
(statearr_52561_52610[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_52495[(4)]))){
var statearr_52562_52611 = state_52495;
(statearr_52562_52611[(1)] = cljs.core.first((state_52495[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__52612 = state_52495;
state_52495 = G__52612;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_52495){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_52495);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_52563 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_52563[(6)] = c__24424__auto__);

return statearr_52563;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__52614 = arguments.length;
switch (G__52614) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___52761 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_52710){
var state_val_52711 = (state_52710[(1)]);
if((state_val_52711 === (7))){
var state_52710__$1 = state_52710;
var statearr_52712_52762 = state_52710__$1;
(statearr_52712_52762[(2)] = null);

(statearr_52712_52762[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (20))){
var inst_52659 = (state_52710[(7)]);
var inst_52660 = (state_52710[(8)]);
var inst_52658 = (state_52710[(9)]);
var inst_52679 = (inst_52658 + (1));
var inst_52680 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_52660,cljs.core.cst$kw$t,inst_52679);
var inst_52681 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_52680,inst_52659,opts);
var state_52710__$1 = state_52710;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52710__$1,(23),inst_52681);
} else {
if((state_val_52711 === (1))){
var state_52710__$1 = state_52710;
var statearr_52713_52763 = state_52710__$1;
(statearr_52713_52763[(2)] = null);

(statearr_52713_52763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (24))){
var inst_52684 = (state_52710[(10)]);
var inst_52687 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_52684,cljs.core.cst$kw$block,block);
var state_52710__$1 = state_52710;
var statearr_52714_52764 = state_52710__$1;
(statearr_52714_52764[(2)] = inst_52687);

(statearr_52714_52764[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (4))){
var inst_52615 = (state_52710[(2)]);
var inst_52616 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_52615);
var state_52710__$1 = state_52710;
var statearr_52715_52765 = state_52710__$1;
(statearr_52715_52765[(2)] = inst_52616);

(statearr_52715_52765[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (15))){
var inst_52666 = (state_52710[(11)]);
var state_52710__$1 = state_52710;
var statearr_52716_52766 = state_52710__$1;
(statearr_52716_52766[(2)] = inst_52666);

(statearr_52716_52766[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (21))){
var state_52710__$1 = state_52710;
var statearr_52717_52767 = state_52710__$1;
(statearr_52717_52767[(2)] = null);

(statearr_52717_52767[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (13))){
var inst_52702 = (state_52710[(2)]);
var inst_52703 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_52702);
var state_52710__$1 = state_52710;
var statearr_52718_52768 = state_52710__$1;
(statearr_52718_52768[(2)] = inst_52703);

(statearr_52718_52768[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (22))){
var inst_52698 = (state_52710[(2)]);
var state_52710__$1 = state_52710;
var statearr_52719_52769 = state_52710__$1;
(statearr_52719_52769[(2)] = inst_52698);

(statearr_52719_52769[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (6))){
var inst_52626 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_52627 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_52628 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52626)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_52627)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_52629 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52630 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_52631 = cljs.core.PersistentHashMap.fromArrays(inst_52629,inst_52630);
var inst_52632 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52628,inst_52631);
var inst_52633 = (function(){throw inst_52632})();
var state_52710__$1 = state_52710;
var statearr_52722_52770 = state_52710__$1;
(statearr_52722_52770[(2)] = inst_52633);

(statearr_52722_52770[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (25))){
var inst_52666 = (state_52710[(11)]);
var inst_52684 = (state_52710[(10)]);
var inst_52667 = (state_52710[(12)]);
var inst_52689 = inst_52666.t;
var inst_52690 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52691 = [inst_52666];
var inst_52692 = (new cljs.core.PersistentVector(null,1,(5),inst_52690,inst_52691,null));
var inst_52657 = inst_52667;
var inst_52658 = inst_52689;
var inst_52659 = inst_52692;
var inst_52660 = inst_52684;
var state_52710__$1 = (function (){var statearr_52723 = state_52710;
(statearr_52723[(7)] = inst_52659);

(statearr_52723[(8)] = inst_52660);

(statearr_52723[(13)] = inst_52657);

(statearr_52723[(9)] = inst_52658);

return statearr_52723;
})();
var statearr_52724_52771 = state_52710__$1;
(statearr_52724_52771[(2)] = null);

(statearr_52724_52771[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (17))){
var inst_52659 = (state_52710[(7)]);
var inst_52660 = (state_52710[(8)]);
var inst_52666 = (state_52710[(11)]);
var inst_52658 = (state_52710[(9)]);
var inst_52667 = (state_52710[(12)]);
var inst_52675 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_52659,inst_52666);
var tmp52720 = inst_52660;
var tmp52721 = inst_52658;
var inst_52657 = inst_52667;
var inst_52658__$1 = tmp52721;
var inst_52659__$1 = inst_52675;
var inst_52660__$1 = tmp52720;
var state_52710__$1 = (function (){var statearr_52725 = state_52710;
(statearr_52725[(7)] = inst_52659__$1);

(statearr_52725[(8)] = inst_52660__$1);

(statearr_52725[(13)] = inst_52657);

(statearr_52725[(9)] = inst_52658__$1);

return statearr_52725;
})();
var statearr_52726_52772 = state_52710__$1;
(statearr_52726_52772[(2)] = null);

(statearr_52726_52772[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (3))){
var inst_52708 = (state_52710[(2)]);
var state_52710__$1 = state_52710;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52710__$1,inst_52708);
} else {
if((state_val_52711 === (12))){
var inst_52666 = (state_52710[(11)]);
var inst_52657 = (state_52710[(13)]);
var inst_52665 = cljs.core.seq(inst_52657);
var inst_52666__$1 = cljs.core.first(inst_52665);
var inst_52667 = cljs.core.next(inst_52665);
var state_52710__$1 = (function (){var statearr_52727 = state_52710;
(statearr_52727[(11)] = inst_52666__$1);

(statearr_52727[(12)] = inst_52667);

return statearr_52727;
})();
if(cljs.core.truth_(inst_52666__$1)){
var statearr_52728_52773 = state_52710__$1;
(statearr_52728_52773[(1)] = (14));

} else {
var statearr_52729_52774 = state_52710__$1;
(statearr_52729_52774[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (2))){
var _ = (function (){var statearr_52730 = state_52710;
(statearr_52730[(4)] = cljs.core.cons((5),(state_52710[(4)])));

return statearr_52730;
})();
var inst_52622 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_52623 = (inst_52622 + (1));
var inst_52624 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_52623);
var state_52710__$1 = state_52710;
if(inst_52624){
var statearr_52731_52775 = state_52710__$1;
(statearr_52731_52775[(1)] = (6));

} else {
var statearr_52732_52776 = state_52710__$1;
(statearr_52732_52776[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (23))){
var inst_52666 = (state_52710[(11)]);
var inst_52683 = (state_52710[(2)]);
var inst_52684 = fluree.db.util.async.throw_err(inst_52683);
var inst_52685 = (inst_52666 == null);
var state_52710__$1 = (function (){var statearr_52733 = state_52710;
(statearr_52733[(10)] = inst_52684);

return statearr_52733;
})();
if(cljs.core.truth_(inst_52685)){
var statearr_52734_52777 = state_52710__$1;
(statearr_52734_52777[(1)] = (24));

} else {
var statearr_52735_52778 = state_52710__$1;
(statearr_52735_52778[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (19))){
var inst_52700 = (state_52710[(2)]);
var state_52710__$1 = state_52710;
var statearr_52736_52779 = state_52710__$1;
(statearr_52736_52779[(2)] = inst_52700);

(statearr_52736_52779[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (11))){
var inst_52705 = (state_52710[(2)]);
var _ = (function (){var statearr_52738 = state_52710;
(statearr_52738[(4)] = cljs.core.rest((state_52710[(4)])));

return statearr_52738;
})();
var state_52710__$1 = state_52710;
var statearr_52739_52780 = state_52710__$1;
(statearr_52739_52780[(2)] = inst_52705);

(statearr_52739_52780[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (9))){
var inst_52639 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_52640 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_52639);
var state_52710__$1 = state_52710;
var statearr_52740_52781 = state_52710__$1;
(statearr_52740_52781[(2)] = inst_52640);

(statearr_52740_52781[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (5))){
var _ = (function (){var statearr_52741 = state_52710;
(statearr_52741[(4)] = cljs.core.rest((state_52710[(4)])));

return statearr_52741;
})();
var state_52710__$1 = state_52710;
var ex52737 = (state_52710__$1[(2)]);
var statearr_52742_52782 = state_52710__$1;
(statearr_52742_52782[(5)] = ex52737);


var statearr_52743_52783 = state_52710__$1;
(statearr_52743_52783[(1)] = (4));

(statearr_52743_52783[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (14))){
var inst_52666 = (state_52710[(11)]);
var inst_52658 = (state_52710[(9)]);
var inst_52669 = inst_52666.t;
var inst_52670 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_52658,inst_52669);
var state_52710__$1 = state_52710;
var statearr_52744_52784 = state_52710__$1;
(statearr_52744_52784[(2)] = inst_52670);

(statearr_52744_52784[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (26))){
var inst_52695 = (state_52710[(2)]);
var state_52710__$1 = state_52710;
var statearr_52745_52785 = state_52710__$1;
(statearr_52745_52785[(2)] = inst_52695);

(statearr_52745_52785[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (16))){
var inst_52673 = (state_52710[(2)]);
var state_52710__$1 = state_52710;
if(cljs.core.truth_(inst_52673)){
var statearr_52746_52786 = state_52710__$1;
(statearr_52746_52786[(1)] = (17));

} else {
var statearr_52747_52787 = state_52710__$1;
(statearr_52747_52787[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (10))){
var inst_52642 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_52643 = cljs.core.first(inst_52642);
var inst_52651 = cljs.core.seq(inst_52642);
var inst_52652 = cljs.core.first(inst_52651);
var inst_52653 = cljs.core.next(inst_52651);
var inst_52654 = inst_52643.t;
var inst_52655 = cljs.core.PersistentVector.EMPTY;
var inst_52656 = db;
var inst_52657 = inst_52642;
var inst_52658 = inst_52654;
var inst_52659 = inst_52655;
var inst_52660 = inst_52656;
var state_52710__$1 = (function (){var statearr_52748 = state_52710;
(statearr_52748[(7)] = inst_52659);

(statearr_52748[(14)] = inst_52653);

(statearr_52748[(8)] = inst_52660);

(statearr_52748[(13)] = inst_52657);

(statearr_52748[(9)] = inst_52658);

(statearr_52748[(15)] = inst_52652);

return statearr_52748;
})();
var statearr_52749_52788 = state_52710__$1;
(statearr_52749_52788[(2)] = null);

(statearr_52749_52788[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (18))){
var state_52710__$1 = state_52710;
var statearr_52750_52789 = state_52710__$1;
(statearr_52750_52789[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_52711 === (8))){
var inst_52636 = (state_52710[(2)]);
var inst_52637 = cljs.core.empty_QMARK_(flakes);
var state_52710__$1 = (function (){var statearr_52752 = state_52710;
(statearr_52752[(16)] = inst_52636);

return statearr_52752;
})();
if(inst_52637){
var statearr_52753_52790 = state_52710__$1;
(statearr_52753_52790[(1)] = (9));

} else {
var statearr_52754_52791 = state_52710__$1;
(statearr_52754_52791[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_52755 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52755[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_52755[(1)] = (1));

return statearr_52755;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_52710){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_52710);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e52756){var ex__24301__auto__ = e52756;
var statearr_52757_52792 = state_52710;
(statearr_52757_52792[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_52710[(4)]))){
var statearr_52758_52793 = state_52710;
(statearr_52758_52793[(1)] = cljs.core.first((state_52710[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__52794 = state_52710;
state_52710 = G__52794;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_52710){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_52710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_52759 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_52759[(6)] = c__24424__auto___52761);

return statearr_52759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_52850){
var state_val_52851 = (state_52850[(1)]);
if((state_val_52851 === (7))){
var state_52850__$1 = state_52850;
var statearr_52852_52879 = state_52850__$1;
(statearr_52852_52879[(2)] = tt_id);

(statearr_52852_52879[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (1))){
var state_52850__$1 = state_52850;
var statearr_52853_52880 = state_52850__$1;
(statearr_52853_52880[(2)] = null);

(statearr_52853_52880[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (4))){
var inst_52795 = (state_52850[(2)]);
var state_52850__$1 = state_52850;
var statearr_52854_52881 = state_52850__$1;
(statearr_52854_52881[(2)] = inst_52795);

(statearr_52854_52881[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (13))){
var inst_52843 = (state_52850[(2)]);
var state_52850__$1 = state_52850;
var statearr_52855_52882 = state_52850__$1;
(statearr_52855_52882[(2)] = inst_52843);

(statearr_52855_52882[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (6))){
var inst_52803 = fluree.db.util.core.random_uuid();
var state_52850__$1 = state_52850;
var statearr_52856_52883 = state_52850__$1;
(statearr_52856_52883[(2)] = inst_52803);

(statearr_52856_52883[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (3))){
var inst_52848 = (state_52850[(2)]);
var state_52850__$1 = state_52850;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52850__$1,inst_52848);
} else {
if((state_val_52851 === (12))){
var inst_52826 = (state_52850[(7)]);
var state_52850__$1 = state_52850;
var statearr_52857_52884 = state_52850__$1;
(statearr_52857_52884[(2)] = inst_52826);

(statearr_52857_52884[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (2))){
var _ = (function (){var statearr_52858 = state_52850;
(statearr_52858[(4)] = cljs.core.cons((5),(state_52850[(4)])));

return statearr_52858;
})();
var inst_52801 = (tt_id == null);
var state_52850__$1 = state_52850;
if(cljs.core.truth_(inst_52801)){
var statearr_52859_52885 = state_52850__$1;
(statearr_52859_52885[(1)] = (6));

} else {
var statearr_52860_52886 = state_52850__$1;
(statearr_52860_52886[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (11))){
var inst_52833 = (state_52850[(8)]);
var inst_52826 = (state_52850[(7)]);
var inst_52836 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_52826,inst_52833);
var state_52850__$1 = state_52850;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52850__$1,(14),inst_52836);
} else {
if((state_val_52851 === (9))){
var inst_52827 = (state_52850[(9)]);
var inst_52833 = (state_52850[(8)]);
var inst_52832 = cljs.core.seq(inst_52827);
var inst_52833__$1 = cljs.core.first(inst_52832);
var inst_52834 = cljs.core.next(inst_52832);
var state_52850__$1 = (function (){var statearr_52862 = state_52850;
(statearr_52862[(10)] = inst_52834);

(statearr_52862[(8)] = inst_52833__$1);

return statearr_52862;
})();
if(cljs.core.truth_(inst_52833__$1)){
var statearr_52863_52887 = state_52850__$1;
(statearr_52863_52887[(1)] = (11));

} else {
var statearr_52864_52888 = state_52850__$1;
(statearr_52864_52888[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (5))){
var _ = (function (){var statearr_52865 = state_52850;
(statearr_52865[(4)] = cljs.core.rest((state_52850[(4)])));

return statearr_52865;
})();
var state_52850__$1 = state_52850;
var ex52861 = (state_52850__$1[(2)]);
var statearr_52866_52889 = state_52850__$1;
(statearr_52866_52889[(5)] = ex52861);


if((ex52861 instanceof Error)){
var statearr_52867_52890 = state_52850__$1;
(statearr_52867_52890[(1)] = (4));

(statearr_52867_52890[(5)] = null);

} else {
throw ex52861;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (14))){
var inst_52834 = (state_52850[(10)]);
var inst_52838 = (state_52850[(2)]);
var inst_52839 = fluree.db.util.async.throw_err(inst_52838);
var inst_52826 = inst_52839;
var inst_52827 = inst_52834;
var state_52850__$1 = (function (){var statearr_52868 = state_52850;
(statearr_52868[(9)] = inst_52827);

(statearr_52868[(7)] = inst_52826);

return statearr_52868;
})();
var statearr_52869_52891 = state_52850__$1;
(statearr_52869_52891[(2)] = null);

(statearr_52869_52891[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (10))){
var inst_52845 = (state_52850[(2)]);
var _ = (function (){var statearr_52870 = state_52850;
(statearr_52870[(4)] = cljs.core.rest((state_52850[(4)])));

return statearr_52870;
})();
var state_52850__$1 = state_52850;
var statearr_52871_52892 = state_52850__$1;
(statearr_52871_52892[(2)] = inst_52845);

(statearr_52871_52892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52851 === (8))){
var inst_52806 = (state_52850[(2)]);
var inst_52807 = (function (){var tt_id_SINGLEQUOTE_ = inst_52806;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_52808 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_52806);
var inst_52809 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52810 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_52811 = (new cljs.core.PersistentVector(null,4,(5),inst_52809,inst_52810,null));
var inst_52812 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_52807,inst_52808,inst_52811);
var inst_52813 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_52814 = cljs.core.reverse(inst_52813);
var inst_52815 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_52814);
var inst_52823 = cljs.core.seq(inst_52815);
var inst_52824 = cljs.core.first(inst_52823);
var inst_52825 = cljs.core.next(inst_52823);
var inst_52826 = inst_52812;
var inst_52827 = inst_52815;
var state_52850__$1 = (function (){var statearr_52872 = state_52850;
(statearr_52872[(11)] = inst_52824);

(statearr_52872[(9)] = inst_52827);

(statearr_52872[(7)] = inst_52826);

(statearr_52872[(12)] = inst_52825);

return statearr_52872;
})();
var statearr_52873_52893 = state_52850__$1;
(statearr_52873_52893[(2)] = null);

(statearr_52873_52893[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____0 = (function (){
var statearr_52874 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52874[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__);

(statearr_52874[(1)] = (1));

return statearr_52874;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____1 = (function (state_52850){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_52850);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e52875){var ex__24301__auto__ = e52875;
var statearr_52876_52894 = state_52850;
(statearr_52876_52894[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_52850[(4)]))){
var statearr_52877_52895 = state_52850;
(statearr_52877_52895[(1)] = cljs.core.first((state_52850[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__52896 = state_52850;
state_52850 = G__52896;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__ = function(state_52850){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____1.call(this,state_52850);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_52878 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_52878[(6)] = c__24424__auto__);

return statearr_52878;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___53083 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53014){
var state_val_53015 = (state_53014[(1)]);
if((state_val_53015 === (7))){
var inst_52924 = (state_53014[(7)]);
var inst_52924__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_53014__$1 = (function (){var statearr_53016 = state_53014;
(statearr_53016[(7)] = inst_52924__$1);

return statearr_53016;
})();
if(inst_52924__$1){
var statearr_53017_53084 = state_53014__$1;
(statearr_53017_53084[(1)] = (13));

} else {
var statearr_53018_53085 = state_53014__$1;
(statearr_53018_53085[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (20))){
var state_53014__$1 = state_53014;
var statearr_53019_53086 = state_53014__$1;
(statearr_53019_53086[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (27))){
var inst_52960 = (state_53014[(8)]);
var inst_52964 = inst_52960.s;
var state_53014__$1 = state_53014;
var statearr_53021_53087 = state_53014__$1;
(statearr_53021_53087[(2)] = inst_52964);

(statearr_53021_53087[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (1))){
var state_53014__$1 = state_53014;
var statearr_53022_53088 = state_53014__$1;
(statearr_53022_53088[(2)] = null);

(statearr_53022_53088[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (24))){
var inst_52954 = (state_53014[(9)]);
var inst_52958 = cljs.core.first(inst_52954);
var state_53014__$1 = state_53014;
var statearr_53023_53089 = state_53014__$1;
(statearr_53023_53089[(2)] = inst_52958);

(statearr_53023_53089[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (39))){
var state_53014__$1 = state_53014;
var statearr_53024_53090 = state_53014__$1;
(statearr_53024_53090[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (4))){
var inst_52897 = (state_53014[(2)]);
var inst_52898 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_52899 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52900 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_52901 = cljs.core.PersistentHashMap.fromArrays(inst_52899,inst_52900);
var inst_52902 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_52898,inst_52901,inst_52897);
var inst_52903 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_52902);
var state_53014__$1 = state_53014;
var statearr_53026_53091 = state_53014__$1;
(statearr_53026_53091[(2)] = inst_52903);

(statearr_53026_53091[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (15))){
var inst_52931 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
if(cljs.core.truth_(inst_52931)){
var statearr_53027_53092 = state_53014__$1;
(statearr_53027_53092[(1)] = (16));

} else {
var statearr_53028_53093 = state_53014__$1;
(statearr_53028_53093[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (21))){
var inst_52980 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53029_53094 = state_53014__$1;
(statearr_53029_53094[(2)] = inst_52980);

(statearr_53029_53094[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (31))){
var inst_52978 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53030_53095 = state_53014__$1;
(statearr_53030_53095[(2)] = inst_52978);

(statearr_53030_53095[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (32))){
var inst_52984 = (state_53014[(10)]);
var inst_52986 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_52984);
var state_53014__$1 = state_53014;
var statearr_53031_53096 = state_53014__$1;
(statearr_53031_53096[(2)] = inst_52986);

(statearr_53031_53096[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (40))){
var inst_53007 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53032_53097 = state_53014__$1;
(statearr_53032_53097[(2)] = inst_53007);

(statearr_53032_53097[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (33))){
var inst_52988 = (state_53014[(11)]);
var inst_52984 = (state_53014[(10)]);
var inst_52988__$1 = (inst_52984 == null);
var state_53014__$1 = (function (){var statearr_53033 = state_53014;
(statearr_53033[(11)] = inst_52988__$1);

return statearr_53033;
})();
if(cljs.core.truth_(inst_52988__$1)){
var statearr_53034_53098 = state_53014__$1;
(statearr_53034_53098[(1)] = (35));

} else {
var statearr_53035_53099 = state_53014__$1;
(statearr_53035_53099[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (13))){
var inst_52926 = cljs.core.first(ident);
var inst_52927 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_52926);
var inst_52928 = (inst_52927 == null);
var state_53014__$1 = state_53014;
var statearr_53036_53100 = state_53014__$1;
(statearr_53036_53100[(2)] = inst_52928);

(statearr_53036_53100[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (22))){
var inst_52954 = (state_53014[(9)]);
var inst_52953 = (state_53014[(2)]);
var inst_52954__$1 = fluree.db.util.async.throw_err(inst_52953);
var inst_52955 = (inst_52954__$1 == null);
var state_53014__$1 = (function (){var statearr_53037 = state_53014;
(statearr_53037[(9)] = inst_52954__$1);

return statearr_53037;
})();
if(cljs.core.truth_(inst_52955)){
var statearr_53038_53101 = state_53014__$1;
(statearr_53038_53101[(1)] = (23));

} else {
var statearr_53039_53102 = state_53014__$1;
(statearr_53039_53102[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (36))){
var inst_52988 = (state_53014[(11)]);
var state_53014__$1 = state_53014;
var statearr_53040_53103 = state_53014__$1;
(statearr_53040_53103[(2)] = inst_52988);

(statearr_53040_53103[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (41))){
var inst_53002 = cljs.core.async.close_BANG_(return_chan);
var state_53014__$1 = state_53014;
var statearr_53041_53104 = state_53014__$1;
(statearr_53041_53104[(2)] = inst_53002);

(statearr_53041_53104[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (43))){
var inst_53005 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53042_53105 = state_53014__$1;
(statearr_53042_53105[(2)] = inst_53005);

(statearr_53042_53105[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (29))){
var inst_52969 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_52970 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_52969].join('');
var inst_52971 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52972 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_52973 = cljs.core.PersistentHashMap.fromArrays(inst_52971,inst_52972);
var inst_52974 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52970,inst_52973);
var inst_52975 = (function(){throw inst_52974})();
var state_53014__$1 = state_53014;
var statearr_53043_53106 = state_53014__$1;
(statearr_53043_53106[(2)] = inst_52975);

(statearr_53043_53106[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (6))){
var inst_52911 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52912 = [ident];
var inst_52913 = (new cljs.core.PersistentVector(null,1,(5),inst_52911,inst_52912,null));
var inst_52914 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_52913);
var state_53014__$1 = state_53014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53014__$1,(9),inst_52914);
} else {
if((state_val_53015 === (28))){
var inst_52966 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53044_53107 = state_53014__$1;
(statearr_53044_53107[(2)] = inst_52966);

(statearr_53044_53107[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (25))){
var inst_52960 = (state_53014[(8)]);
var inst_52960__$1 = (state_53014[(2)]);
var inst_52961 = (inst_52960__$1 == null);
var state_53014__$1 = (function (){var statearr_53045 = state_53014;
(statearr_53045[(8)] = inst_52960__$1);

return statearr_53045;
})();
if(cljs.core.truth_(inst_52961)){
var statearr_53046_53108 = state_53014__$1;
(statearr_53046_53108[(1)] = (26));

} else {
var statearr_53047_53109 = state_53014__$1;
(statearr_53047_53109[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (34))){
var inst_53009 = (state_53014[(2)]);
var _ = (function (){var statearr_53048 = state_53014;
(statearr_53048[(4)] = cljs.core.rest((state_53014[(4)])));

return statearr_53048;
})();
var state_53014__$1 = state_53014;
var statearr_53049_53110 = state_53014__$1;
(statearr_53049_53110[(2)] = inst_53009);

(statearr_53049_53110[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (17))){
var inst_52942 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_53014__$1 = state_53014;
if(inst_52942){
var statearr_53050_53111 = state_53014__$1;
(statearr_53050_53111[(1)] = (19));

} else {
var statearr_53051_53112 = state_53014__$1;
(statearr_53051_53112[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (3))){
var inst_53012 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53014__$1,inst_53012);
} else {
if((state_val_53015 === (12))){
var inst_52922 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53052_53113 = state_53014__$1;
(statearr_53052_53113[(2)] = inst_52922);

(statearr_53052_53113[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (2))){
var _ = (function (){var statearr_53053 = state_53014;
(statearr_53053[(4)] = cljs.core.cons((5),(state_53014[(4)])));

return statearr_53053;
})();
var inst_52909 = typeof ident === 'number';
var state_53014__$1 = state_53014;
if(cljs.core.truth_(inst_52909)){
var statearr_53054_53114 = state_53014__$1;
(statearr_53054_53114[(1)] = (6));

} else {
var statearr_53055_53115 = state_53014__$1;
(statearr_53055_53115[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (23))){
var state_53014__$1 = state_53014;
var statearr_53056_53116 = state_53014__$1;
(statearr_53056_53116[(2)] = null);

(statearr_53056_53116[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (35))){
var state_53014__$1 = state_53014;
var statearr_53057_53117 = state_53014__$1;
(statearr_53057_53117[(2)] = strict_QMARK_);

(statearr_53057_53117[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (19))){
var inst_52945 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52946 = cljs.core.first(ident);
var inst_52947 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_52946);
var inst_52948 = cljs.core.second(ident);
var inst_52949 = [inst_52947,inst_52948];
var inst_52950 = (new cljs.core.PersistentVector(null,2,(5),inst_52945,inst_52949,null));
var inst_52951 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_52950);
var state_53014__$1 = state_53014;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53014__$1,(22),inst_52951);
} else {
if((state_val_53015 === (11))){
var state_53014__$1 = state_53014;
var statearr_53059_53118 = state_53014__$1;
(statearr_53059_53118[(2)] = null);

(statearr_53059_53118[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (9))){
var inst_52916 = (state_53014[(2)]);
var inst_52917 = fluree.db.util.async.throw_err(inst_52916);
var inst_52918 = cljs.core.not_empty(inst_52917);
var state_53014__$1 = state_53014;
if(cljs.core.truth_(inst_52918)){
var statearr_53060_53119 = state_53014__$1;
(statearr_53060_53119[(1)] = (10));

} else {
var statearr_53061_53120 = state_53014__$1;
(statearr_53061_53120[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (5))){
var _ = (function (){var statearr_53062 = state_53014;
(statearr_53062[(4)] = cljs.core.rest((state_53014[(4)])));

return statearr_53062;
})();
var state_53014__$1 = state_53014;
var ex53058 = (state_53014__$1[(2)]);
var statearr_53063_53121 = state_53014__$1;
(statearr_53063_53121[(5)] = ex53058);


var statearr_53064_53122 = state_53014__$1;
(statearr_53064_53122[(1)] = (4));

(statearr_53064_53122[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (14))){
var inst_52924 = (state_53014[(7)]);
var state_53014__$1 = state_53014;
var statearr_53065_53123 = state_53014__$1;
(statearr_53065_53123[(2)] = inst_52924);

(statearr_53065_53123[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (26))){
var state_53014__$1 = state_53014;
var statearr_53066_53124 = state_53014__$1;
(statearr_53066_53124[(2)] = null);

(statearr_53066_53124[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (16))){
var inst_52933 = cljs.core.first(ident);
var inst_52934 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_52933], 0));
var inst_52935 = ["Subject ID lookup failed. The predicate ",inst_52934," does not exist."].join('');
var inst_52936 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52937 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_52938 = cljs.core.PersistentHashMap.fromArrays(inst_52936,inst_52937);
var inst_52939 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52935,inst_52938);
var inst_52940 = (function(){throw inst_52939})();
var state_53014__$1 = state_53014;
var statearr_53067_53125 = state_53014__$1;
(statearr_53067_53125[(2)] = inst_52940);

(statearr_53067_53125[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (38))){
var inst_52994 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_52995 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_52996 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_52997 = cljs.core.PersistentHashMap.fromArrays(inst_52995,inst_52996);
var inst_52998 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_52994,inst_52997);
var inst_52999 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_52998);
var state_53014__$1 = state_53014;
var statearr_53068_53126 = state_53014__$1;
(statearr_53068_53126[(2)] = inst_52999);

(statearr_53068_53126[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (30))){
var state_53014__$1 = state_53014;
var statearr_53069_53127 = state_53014__$1;
(statearr_53069_53127[(2)] = null);

(statearr_53069_53127[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (10))){
var state_53014__$1 = state_53014;
var statearr_53070_53128 = state_53014__$1;
(statearr_53070_53128[(2)] = ident);

(statearr_53070_53128[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (18))){
var inst_52982 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
var statearr_53071_53129 = state_53014__$1;
(statearr_53071_53129[(2)] = inst_52982);

(statearr_53071_53129[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (42))){
var state_53014__$1 = state_53014;
var statearr_53072_53130 = state_53014__$1;
(statearr_53072_53130[(2)] = null);

(statearr_53072_53130[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (37))){
var inst_52992 = (state_53014[(2)]);
var state_53014__$1 = state_53014;
if(cljs.core.truth_(inst_52992)){
var statearr_53073_53131 = state_53014__$1;
(statearr_53073_53131[(1)] = (38));

} else {
var statearr_53074_53132 = state_53014__$1;
(statearr_53074_53132[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53015 === (8))){
var inst_52984 = (state_53014[(10)]);
var inst_52984__$1 = (state_53014[(2)]);
var state_53014__$1 = (function (){var statearr_53075 = state_53014;
(statearr_53075[(10)] = inst_52984__$1);

return statearr_53075;
})();
if(cljs.core.truth_(inst_52984__$1)){
var statearr_53076_53133 = state_53014__$1;
(statearr_53076_53133[(1)] = (32));

} else {
var statearr_53077_53134 = state_53014__$1;
(statearr_53077_53134[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__24298__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__24298__auto____0 = (function (){
var statearr_53078 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53078[(0)] = fluree$db$graphdb$subid_$_state_machine__24298__auto__);

(statearr_53078[(1)] = (1));

return statearr_53078;
});
var fluree$db$graphdb$subid_$_state_machine__24298__auto____1 = (function (state_53014){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53014);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53079){var ex__24301__auto__ = e53079;
var statearr_53080_53135 = state_53014;
(statearr_53080_53135[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53014[(4)]))){
var statearr_53081_53136 = state_53014;
(statearr_53081_53136[(1)] = cljs.core.first((state_53014[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53137 = state_53014;
state_53014 = G__53137;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__24298__auto__ = function(state_53014){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__24298__auto____1.call(this,state_53014);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__24298__auto____0;
fluree$db$graphdb$subid_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__24298__auto____1;
return fluree$db$graphdb$subid_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53082 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53082[(6)] = c__24424__auto___53083);

return statearr_53082;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return return_chan;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k53139,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__53143 = k53139;
var G__53143__$1 = (((G__53143 instanceof cljs.core.Keyword))?G__53143.fqn:null);
switch (G__53143__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k53139,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__53144){
var vec__53145 = p__53144;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53145,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53145,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__53138){
var self__ = this;
var G__53138__$1 = this;
return (new cljs.core.RecordIter((0),G__53138__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__53148 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__53148(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this53140,other53141){
var self__ = this;
var this53140__$1 = this;
return (((!((other53141 == null)))) && ((((this53140__$1.constructor === other53141.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.conn,other53141.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.network,other53141.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.dbid,other53141.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.block,other53141.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.t,other53141.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.tt_id,other53141.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.stats,other53141.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.spot,other53141.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.psot,other53141.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.post,other53141.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.opst,other53141.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.schema,other53141.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.settings,other53141.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.index_configs,other53141.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.schema_cache,other53141.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.novelty,other53141.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.permissions,other53141.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.fork,other53141.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.fork_block,other53141.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.current_db_fn,other53141.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53140__$1.__extmap,other53141.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k53139){
var self__ = this;
var this__4468__auto____$1 = this;
var G__53149 = k53139;
var G__53149__$1 = (((G__53149 instanceof cljs.core.Keyword))?G__53149.fqn:null);
switch (G__53149__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k53139);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__53138){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__53150 = cljs.core.keyword_identical_QMARK_;
var expr__53151 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__53153 = cljs.core.cst$kw$conn;
var G__53154 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53153,G__53154) : pred__53150.call(null,G__53153,G__53154));
})())){
return (new fluree.db.graphdb.GraphDb(G__53138,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53155 = cljs.core.cst$kw$network;
var G__53156 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53155,G__53156) : pred__53150.call(null,G__53155,G__53156));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__53138,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53157 = cljs.core.cst$kw$dbid;
var G__53158 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53157,G__53158) : pred__53150.call(null,G__53157,G__53158));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__53138,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53159 = cljs.core.cst$kw$block;
var G__53160 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53159,G__53160) : pred__53150.call(null,G__53159,G__53160));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__53138,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53161 = cljs.core.cst$kw$t;
var G__53162 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53161,G__53162) : pred__53150.call(null,G__53161,G__53162));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__53138,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53163 = cljs.core.cst$kw$tt_DASH_id;
var G__53164 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53163,G__53164) : pred__53150.call(null,G__53163,G__53164));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__53138,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53165 = cljs.core.cst$kw$stats;
var G__53166 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53165,G__53166) : pred__53150.call(null,G__53165,G__53166));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__53138,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53167 = cljs.core.cst$kw$spot;
var G__53168 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53167,G__53168) : pred__53150.call(null,G__53167,G__53168));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__53138,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53169 = cljs.core.cst$kw$psot;
var G__53170 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53169,G__53170) : pred__53150.call(null,G__53169,G__53170));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__53138,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53171 = cljs.core.cst$kw$post;
var G__53172 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53171,G__53172) : pred__53150.call(null,G__53171,G__53172));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__53138,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53173 = cljs.core.cst$kw$opst;
var G__53174 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53173,G__53174) : pred__53150.call(null,G__53173,G__53174));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__53138,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53175 = cljs.core.cst$kw$schema;
var G__53176 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53175,G__53176) : pred__53150.call(null,G__53175,G__53176));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__53138,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53177 = cljs.core.cst$kw$settings;
var G__53178 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53177,G__53178) : pred__53150.call(null,G__53177,G__53178));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__53138,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53179 = cljs.core.cst$kw$index_DASH_configs;
var G__53180 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53179,G__53180) : pred__53150.call(null,G__53179,G__53180));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__53138,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53181 = cljs.core.cst$kw$schema_DASH_cache;
var G__53182 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53181,G__53182) : pred__53150.call(null,G__53181,G__53182));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__53138,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53183 = cljs.core.cst$kw$novelty;
var G__53184 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53183,G__53184) : pred__53150.call(null,G__53183,G__53184));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__53138,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53185 = cljs.core.cst$kw$permissions;
var G__53186 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53185,G__53186) : pred__53150.call(null,G__53185,G__53186));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__53138,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53187 = cljs.core.cst$kw$fork;
var G__53188 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53187,G__53188) : pred__53150.call(null,G__53187,G__53188));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__53138,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53189 = cljs.core.cst$kw$fork_DASH_block;
var G__53190 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53189,G__53190) : pred__53150.call(null,G__53189,G__53190));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__53138,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53191 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__53192 = expr__53151;
return (pred__53150.cljs$core$IFn$_invoke$arity$2 ? pred__53150.cljs$core$IFn$_invoke$arity$2(G__53191,G__53192) : pred__53150.call(null,G__53191,G__53192));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__53138,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__53138),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__53138){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__53138,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53208){
var state_val_53209 = (state_53208[(1)]);
if((state_val_53209 === (1))){
var state_53208__$1 = state_53208;
var statearr_53210_53477 = state_53208__$1;
(statearr_53210_53477[(2)] = null);

(statearr_53210_53477[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53209 === (2))){
var _ = (function (){var statearr_53211 = state_53208;
(statearr_53211[(4)] = cljs.core.cons((5),(state_53208[(4)])));

return statearr_53211;
})();
var inst_53199 = (self__.current_db_fn.cljs$core$IFn$_invoke$arity$0 ? self__.current_db_fn.cljs$core$IFn$_invoke$arity$0() : self__.current_db_fn.call(null));
var state_53208__$1 = state_53208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53208__$1,(6),inst_53199);
} else {
if((state_val_53209 === (3))){
var inst_53206 = (state_53208[(2)]);
var state_53208__$1 = state_53208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53208__$1,inst_53206);
} else {
if((state_val_53209 === (4))){
var inst_53193 = (state_53208[(2)]);
var state_53208__$1 = state_53208;
var statearr_53213_53478 = state_53208__$1;
(statearr_53213_53478[(2)] = inst_53193);

(statearr_53213_53478[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53209 === (5))){
var _ = (function (){var statearr_53214 = state_53208;
(statearr_53214[(4)] = cljs.core.rest((state_53208[(4)])));

return statearr_53214;
})();
var state_53208__$1 = state_53208;
var ex53212 = (state_53208__$1[(2)]);
var statearr_53215_53479 = state_53208__$1;
(statearr_53215_53479[(5)] = ex53212);


if((ex53212 instanceof Error)){
var statearr_53216_53480 = state_53208__$1;
(statearr_53216_53480[(1)] = (4));

(statearr_53216_53480[(5)] = null);

} else {
throw ex53212;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53209 === (6))){
var inst_53201 = (state_53208[(2)]);
var inst_53202 = fluree.db.util.async.throw_err(inst_53201);
var inst_53203 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_53202,cljs.core.cst$kw$permissions,self__.permissions);
var _ = (function (){var statearr_53217 = state_53208;
(statearr_53217[(4)] = cljs.core.rest((state_53208[(4)])));

return statearr_53217;
})();
var state_53208__$1 = state_53208;
var statearr_53218_53481 = state_53208__$1;
(statearr_53218_53481[(2)] = inst_53203);

(statearr_53218_53481[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_53219 = [null,null,null,null,null,null,null];
(statearr_53219[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_53219[(1)] = (1));

return statearr_53219;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_53208){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53208);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53220){var ex__24301__auto__ = e53220;
var statearr_53221_53482 = state_53208;
(statearr_53221_53482[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53208[(4)]))){
var statearr_53222_53483 = state_53208;
(statearr_53222_53483[(1)] = cljs.core.first((state_53208[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53484 = state_53208;
state_53208 = G__53484;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_53208){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_53208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53223 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53223[(6)] = c__24424__auto__);

return statearr_53223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__53224 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__53224.cljs$core$IFn$_invoke$arity$1 ? fexpr__53224.cljs$core$IFn$_invoke$arity$1(property) : fexpr__53224.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_((function (){var fexpr__53225 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__53225.cljs$core$IFn$_invoke$arity$1 ? fexpr__53225.cljs$core$IFn$_invoke$arity$1(property) : fexpr__53225.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__53226 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(self__.schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return this$__$1.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(null,cljs.core.cst$kw$partition,G__53226);
} else {
return G__53226;
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$__$1,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53258){
var state_val_53259 = (state_53258[(1)]);
if((state_val_53259 === (7))){
var state_53258__$1 = state_53258;
var statearr_53260_53485 = state_53258__$1;
(statearr_53260_53485[(2)] = null);

(statearr_53260_53485[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (1))){
var state_53258__$1 = state_53258;
var statearr_53261_53486 = state_53258__$1;
(statearr_53261_53486[(2)] = null);

(statearr_53261_53486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (4))){
var inst_53227 = (state_53258[(2)]);
var state_53258__$1 = state_53258;
var statearr_53262_53487 = state_53258__$1;
(statearr_53262_53487[(2)] = inst_53227);

(statearr_53262_53487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (6))){
var inst_53241 = (state_53258[(7)]);
var inst_53240 = (state_53258[(2)]);
var inst_53241__$1 = fluree.db.util.async.throw_err(inst_53240);
var inst_53242 = (inst_53241__$1 == null);
var state_53258__$1 = (function (){var statearr_53263 = state_53258;
(statearr_53263[(7)] = inst_53241__$1);

return statearr_53263;
})();
if(cljs.core.truth_(inst_53242)){
var statearr_53264_53488 = state_53258__$1;
(statearr_53264_53488[(1)] = (7));

} else {
var statearr_53265_53489 = state_53258__$1;
(statearr_53265_53489[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (3))){
var inst_53256 = (state_53258[(2)]);
var state_53258__$1 = state_53258;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53258__$1,inst_53256);
} else {
if((state_val_53259 === (12))){
var inst_53253 = (state_53258[(2)]);
var _ = (function (){var statearr_53266 = state_53258;
(statearr_53266[(4)] = cljs.core.rest((state_53258[(4)])));

return statearr_53266;
})();
var state_53258__$1 = state_53258;
var statearr_53267_53490 = state_53258__$1;
(statearr_53267_53490[(2)] = inst_53253);

(statearr_53267_53490[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (2))){
var _ = (function (){var statearr_53268 = state_53258;
(statearr_53268[(4)] = cljs.core.cons((5),(state_53258[(4)])));

return statearr_53268;
})();
var inst_53234 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_53235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53236 = [tag_id,(30)];
var inst_53237 = (new cljs.core.PersistentVector(null,2,(5),inst_53235,inst_53236,null));
var inst_53238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_53234,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_53237);
var state_53258__$1 = state_53258;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53258__$1,(6),inst_53238);
} else {
if((state_val_53259 === (11))){
var inst_53247 = (state_53258[(8)]);
var inst_53251 = inst_53247.o;
var state_53258__$1 = state_53258;
var statearr_53270_53491 = state_53258__$1;
(statearr_53270_53491[(2)] = inst_53251);

(statearr_53270_53491[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (9))){
var inst_53247 = (state_53258[(8)]);
var inst_53247__$1 = (state_53258[(2)]);
var inst_53248 = (inst_53247__$1 == null);
var state_53258__$1 = (function (){var statearr_53271 = state_53258;
(statearr_53271[(8)] = inst_53247__$1);

return statearr_53271;
})();
if(cljs.core.truth_(inst_53248)){
var statearr_53272_53492 = state_53258__$1;
(statearr_53272_53492[(1)] = (10));

} else {
var statearr_53273_53493 = state_53258__$1;
(statearr_53273_53493[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (5))){
var _ = (function (){var statearr_53274 = state_53258;
(statearr_53274[(4)] = cljs.core.rest((state_53258[(4)])));

return statearr_53274;
})();
var state_53258__$1 = state_53258;
var ex53269 = (state_53258__$1[(2)]);
var statearr_53275_53494 = state_53258__$1;
(statearr_53275_53494[(5)] = ex53269);


if((ex53269 instanceof Error)){
var statearr_53276_53495 = state_53258__$1;
(statearr_53276_53495[(1)] = (4));

(statearr_53276_53495[(5)] = null);

} else {
throw ex53269;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (10))){
var state_53258__$1 = state_53258;
var statearr_53277_53496 = state_53258__$1;
(statearr_53277_53496[(2)] = null);

(statearr_53277_53496[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53259 === (8))){
var inst_53241 = (state_53258[(7)]);
var inst_53245 = cljs.core.first(inst_53241);
var state_53258__$1 = state_53258;
var statearr_53278_53497 = state_53258__$1;
(statearr_53278_53497[(2)] = inst_53245);

(statearr_53278_53497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_53279 = [null,null,null,null,null,null,null,null,null];
(statearr_53279[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_53279[(1)] = (1));

return statearr_53279;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_53258){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53258);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53280){var ex__24301__auto__ = e53280;
var statearr_53281_53498 = state_53258;
(statearr_53281_53498[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53258[(4)]))){
var statearr_53282_53499 = state_53258;
(statearr_53282_53499[(1)] = cljs.core.first((state_53258[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53500 = state_53258;
state_53258 = G__53500;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_53258){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_53258);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53283 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53283[(6)] = c__24424__auto__);

return statearr_53283;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53319){
var state_val_53320 = (state_53319[(1)]);
if((state_val_53320 === (7))){
var inst_53293 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_53319__$1 = state_53319;
var statearr_53321_53501 = state_53319__$1;
(statearr_53321_53501[(2)] = inst_53293);

(statearr_53321_53501[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (1))){
var state_53319__$1 = state_53319;
var statearr_53322_53502 = state_53319__$1;
(statearr_53322_53502[(2)] = null);

(statearr_53322_53502[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (4))){
var inst_53284 = (state_53319[(2)]);
var state_53319__$1 = state_53319;
var statearr_53323_53503 = state_53319__$1;
(statearr_53323_53503[(2)] = inst_53284);

(statearr_53323_53503[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (15))){
var inst_53314 = (state_53319[(2)]);
var _ = (function (){var statearr_53324 = state_53319;
(statearr_53324[(4)] = cljs.core.rest((state_53319[(4)])));

return statearr_53324;
})();
var state_53319__$1 = state_53319;
var statearr_53325_53504 = state_53319__$1;
(statearr_53325_53504[(2)] = inst_53314);

(statearr_53325_53504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (13))){
var inst_53299 = (state_53319[(7)]);
var inst_53305 = clojure.string.includes_QMARK_(inst_53299,":");
var state_53319__$1 = state_53319;
if(inst_53305){
var statearr_53326_53505 = state_53319__$1;
(statearr_53326_53505[(1)] = (16));

} else {
var statearr_53327_53506 = state_53319__$1;
(statearr_53327_53506[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (6))){
var state_53319__$1 = state_53319;
var statearr_53328_53507 = state_53319__$1;
(statearr_53328_53507[(2)] = pred);

(statearr_53328_53507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (17))){
var inst_53299 = (state_53319[(7)]);
var state_53319__$1 = state_53319;
var statearr_53329_53508 = state_53319__$1;
(statearr_53329_53508[(2)] = inst_53299);

(statearr_53329_53508[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (3))){
var inst_53317 = (state_53319[(2)]);
var state_53319__$1 = state_53319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53319__$1,inst_53317);
} else {
if((state_val_53320 === (12))){
var inst_53303 = (state_53319[(2)]);
var state_53319__$1 = state_53319;
if(cljs.core.truth_(inst_53303)){
var statearr_53330_53509 = state_53319__$1;
(statearr_53330_53509[(1)] = (13));

} else {
var statearr_53331_53510 = state_53319__$1;
(statearr_53331_53510[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (2))){
var _ = (function (){var statearr_53332 = state_53319;
(statearr_53332[(4)] = cljs.core.cons((5),(state_53319[(4)])));

return statearr_53332;
})();
var inst_53290 = typeof pred === 'string';
var state_53319__$1 = state_53319;
if(cljs.core.truth_(inst_53290)){
var statearr_53333_53511 = state_53319__$1;
(statearr_53333_53511[(1)] = (6));

} else {
var statearr_53334_53512 = state_53319__$1;
(statearr_53334_53512[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (11))){
var inst_53295 = (state_53319[(8)]);
var state_53319__$1 = state_53319;
var statearr_53336_53513 = state_53319__$1;
(statearr_53336_53513[(2)] = inst_53295);

(statearr_53336_53513[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (9))){
var inst_53295 = (state_53319[(8)]);
var inst_53298 = (state_53319[(2)]);
var inst_53299 = fluree.db.util.async.throw_err(inst_53298);
var state_53319__$1 = (function (){var statearr_53337 = state_53319;
(statearr_53337[(7)] = inst_53299);

return statearr_53337;
})();
if(cljs.core.truth_(inst_53295)){
var statearr_53338_53514 = state_53319__$1;
(statearr_53338_53514[(1)] = (10));

} else {
var statearr_53339_53515 = state_53319__$1;
(statearr_53339_53515[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (5))){
var _ = (function (){var statearr_53340 = state_53319;
(statearr_53340[(4)] = cljs.core.rest((state_53319[(4)])));

return statearr_53340;
})();
var state_53319__$1 = state_53319;
var ex53335 = (state_53319__$1[(2)]);
var statearr_53341_53516 = state_53319__$1;
(statearr_53341_53516[(5)] = ex53335);


if((ex53335 instanceof Error)){
var statearr_53342_53517 = state_53319__$1;
(statearr_53342_53517[(1)] = (4));

(statearr_53342_53517[(5)] = null);

} else {
throw ex53335;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (14))){
var state_53319__$1 = state_53319;
var statearr_53343_53518 = state_53319__$1;
(statearr_53343_53518[(2)] = null);

(statearr_53343_53518[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (16))){
var inst_53299 = (state_53319[(7)]);
var inst_53307 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_53299,/:/);
var inst_53308 = cljs.core.second(inst_53307);
var state_53319__$1 = state_53319;
var statearr_53344_53519 = state_53319__$1;
(statearr_53344_53519[(2)] = inst_53308);

(statearr_53344_53519[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (10))){
var inst_53299 = (state_53319[(7)]);
var state_53319__$1 = state_53319;
var statearr_53345_53520 = state_53319__$1;
(statearr_53345_53520[(2)] = inst_53299);

(statearr_53345_53520[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (18))){
var inst_53311 = (state_53319[(2)]);
var state_53319__$1 = state_53319;
var statearr_53346_53521 = state_53319__$1;
(statearr_53346_53521[(2)] = inst_53311);

(statearr_53346_53521[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53320 === (8))){
var inst_53295 = (state_53319[(2)]);
var inst_53296 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag$arity$2(null,tag_id);
var state_53319__$1 = (function (){var statearr_53347 = state_53319;
(statearr_53347[(8)] = inst_53295);

return statearr_53347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53319__$1,(9),inst_53296);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_53348 = [null,null,null,null,null,null,null,null,null];
(statearr_53348[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_53348[(1)] = (1));

return statearr_53348;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_53319){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53319);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53349){var ex__24301__auto__ = e53349;
var statearr_53350_53522 = state_53319;
(statearr_53350_53522[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53319[(4)]))){
var statearr_53351_53523 = state_53319;
(statearr_53351_53523[(1)] = cljs.core.first((state_53319[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53524 = state_53319;
state_53319 = G__53524;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_53319){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_53319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53352 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53352[(6)] = c__24424__auto__);

return statearr_53352;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53385){
var state_val_53386 = (state_53385[(1)]);
if((state_val_53386 === (7))){
var state_53385__$1 = state_53385;
var statearr_53387_53525 = state_53385__$1;
(statearr_53387_53525[(2)] = null);

(statearr_53387_53525[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (1))){
var state_53385__$1 = state_53385;
var statearr_53388_53526 = state_53385__$1;
(statearr_53388_53526[(2)] = null);

(statearr_53388_53526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (4))){
var inst_53353 = (state_53385[(2)]);
var state_53385__$1 = state_53385;
var statearr_53389_53527 = state_53385__$1;
(statearr_53389_53527[(2)] = inst_53353);

(statearr_53389_53527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (6))){
var inst_53368 = (state_53385[(7)]);
var inst_53367 = (state_53385[(2)]);
var inst_53368__$1 = fluree.db.util.async.throw_err(inst_53367);
var inst_53369 = (inst_53368__$1 == null);
var state_53385__$1 = (function (){var statearr_53390 = state_53385;
(statearr_53390[(7)] = inst_53368__$1);

return statearr_53390;
})();
if(cljs.core.truth_(inst_53369)){
var statearr_53391_53528 = state_53385__$1;
(statearr_53391_53528[(1)] = (7));

} else {
var statearr_53392_53529 = state_53385__$1;
(statearr_53392_53529[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (3))){
var inst_53383 = (state_53385[(2)]);
var state_53385__$1 = state_53385;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53385__$1,inst_53383);
} else {
if((state_val_53386 === (12))){
var inst_53380 = (state_53385[(2)]);
var _ = (function (){var statearr_53393 = state_53385;
(statearr_53393[(4)] = cljs.core.rest((state_53385[(4)])));

return statearr_53393;
})();
var state_53385__$1 = state_53385;
var statearr_53394_53530 = state_53385__$1;
(statearr_53394_53530[(2)] = inst_53380);

(statearr_53394_53530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (2))){
var _ = (function (){var statearr_53395 = state_53385;
(statearr_53395[(4)] = cljs.core.cons((5),(state_53385[(4)])));

return statearr_53395;
})();
var inst_53359 = (30);
var inst_53361 = this$__$1.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(null);
var inst_53362 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53363 = [inst_53359,tag_name];
var inst_53364 = (new cljs.core.PersistentVector(null,2,(5),inst_53362,inst_53363,null));
var inst_53365 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_53361,cljs.core.cst$kw$post,cljs.core._EQ_,inst_53364);
var state_53385__$1 = state_53385;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53385__$1,(6),inst_53365);
} else {
if((state_val_53386 === (11))){
var inst_53374 = (state_53385[(8)]);
var inst_53378 = inst_53374.s;
var state_53385__$1 = state_53385;
var statearr_53397_53531 = state_53385__$1;
(statearr_53397_53531[(2)] = inst_53378);

(statearr_53397_53531[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (9))){
var inst_53374 = (state_53385[(8)]);
var inst_53374__$1 = (state_53385[(2)]);
var inst_53375 = (inst_53374__$1 == null);
var state_53385__$1 = (function (){var statearr_53398 = state_53385;
(statearr_53398[(8)] = inst_53374__$1);

return statearr_53398;
})();
if(cljs.core.truth_(inst_53375)){
var statearr_53399_53532 = state_53385__$1;
(statearr_53399_53532[(1)] = (10));

} else {
var statearr_53400_53533 = state_53385__$1;
(statearr_53400_53533[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (5))){
var _ = (function (){var statearr_53401 = state_53385;
(statearr_53401[(4)] = cljs.core.rest((state_53385[(4)])));

return statearr_53401;
})();
var state_53385__$1 = state_53385;
var ex53396 = (state_53385__$1[(2)]);
var statearr_53402_53534 = state_53385__$1;
(statearr_53402_53534[(5)] = ex53396);


if((ex53396 instanceof Error)){
var statearr_53403_53535 = state_53385__$1;
(statearr_53403_53535[(1)] = (4));

(statearr_53403_53535[(5)] = null);

} else {
throw ex53396;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (10))){
var state_53385__$1 = state_53385;
var statearr_53404_53536 = state_53385__$1;
(statearr_53404_53536[(2)] = null);

(statearr_53404_53536[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53386 === (8))){
var inst_53368 = (state_53385[(7)]);
var inst_53372 = cljs.core.first(inst_53368);
var state_53385__$1 = state_53385;
var statearr_53405_53537 = state_53385__$1;
(statearr_53405_53537[(2)] = inst_53372);

(statearr_53405_53537[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_53406 = [null,null,null,null,null,null,null,null,null];
(statearr_53406[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_53406[(1)] = (1));

return statearr_53406;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_53385){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53385);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53407){var ex__24301__auto__ = e53407;
var statearr_53408_53538 = state_53385;
(statearr_53408_53538[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53385[(4)]))){
var statearr_53409_53539 = state_53385;
(statearr_53409_53539[(1)] = cljs.core.first((state_53385[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53540 = state_53385;
state_53385 = G__53540;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_53385){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_53385);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53410 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53410[(6)] = c__24424__auto__);

return statearr_53410;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_53445){
var state_val_53446 = (state_53445[(1)]);
if((state_val_53446 === (7))){
var inst_53424 = typeof pred === 'string';
var state_53445__$1 = state_53445;
if(cljs.core.truth_(inst_53424)){
var statearr_53447_53541 = state_53445__$1;
(statearr_53447_53541[(1)] = (10));

} else {
var statearr_53448_53542 = state_53445__$1;
(statearr_53448_53542[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (1))){
var state_53445__$1 = state_53445;
var statearr_53449_53543 = state_53445__$1;
(statearr_53449_53543[(2)] = null);

(statearr_53449_53543[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (4))){
var inst_53411 = (state_53445[(2)]);
var state_53445__$1 = state_53445;
var statearr_53450_53544 = state_53445__$1;
(statearr_53450_53544[(2)] = inst_53411);

(statearr_53450_53544[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (15))){
var inst_53438 = (state_53445[(2)]);
var state_53445__$1 = state_53445;
var statearr_53451_53545 = state_53445__$1;
(statearr_53451_53545[(2)] = inst_53438);

(statearr_53451_53545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (13))){
var inst_53429 = (state_53445[(7)]);
var inst_53431 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53429),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_53432 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,inst_53431);
var state_53445__$1 = state_53445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53445__$1,(16),inst_53432);
} else {
if((state_val_53446 === (6))){
var inst_53419 = this$__$1.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(null,tag_name);
var state_53445__$1 = state_53445;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53445__$1,(9),inst_53419);
} else {
if((state_val_53446 === (3))){
var inst_53443 = (state_53445[(2)]);
var state_53445__$1 = state_53445;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53445__$1,inst_53443);
} else {
if((state_val_53446 === (12))){
var inst_53429 = (state_53445[(7)]);
var inst_53429__$1 = (state_53445[(2)]);
var state_53445__$1 = (function (){var statearr_53452 = state_53445;
(statearr_53452[(7)] = inst_53429__$1);

return statearr_53452;
})();
if(cljs.core.truth_(inst_53429__$1)){
var statearr_53453_53546 = state_53445__$1;
(statearr_53453_53546[(1)] = (13));

} else {
var statearr_53454_53547 = state_53445__$1;
(statearr_53454_53547[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (2))){
var _ = (function (){var statearr_53455 = state_53445;
(statearr_53455[(4)] = cljs.core.cons((5),(state_53445[(4)])));

return statearr_53455;
})();
var inst_53417 = clojure.string.includes_QMARK_(tag_name,"/");
var state_53445__$1 = state_53445;
if(inst_53417){
var statearr_53456_53548 = state_53445__$1;
(statearr_53456_53548[(1)] = (6));

} else {
var statearr_53457_53549 = state_53445__$1;
(statearr_53457_53549[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (11))){
var inst_53427 = this$__$1.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(null,cljs.core.cst$kw$name,pred);
var state_53445__$1 = state_53445;
var statearr_53459_53550 = state_53445__$1;
(statearr_53459_53550[(2)] = inst_53427);

(statearr_53459_53550[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (9))){
var inst_53421 = (state_53445[(2)]);
var inst_53422 = fluree.db.util.async.throw_err(inst_53421);
var state_53445__$1 = state_53445;
var statearr_53460_53551 = state_53445__$1;
(statearr_53460_53551[(2)] = inst_53422);

(statearr_53460_53551[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (5))){
var _ = (function (){var statearr_53461 = state_53445;
(statearr_53461[(4)] = cljs.core.rest((state_53445[(4)])));

return statearr_53461;
})();
var state_53445__$1 = state_53445;
var ex53458 = (state_53445__$1[(2)]);
var statearr_53462_53552 = state_53445__$1;
(statearr_53462_53552[(5)] = ex53458);


if((ex53458 instanceof Error)){
var statearr_53463_53553 = state_53445__$1;
(statearr_53463_53553[(1)] = (4));

(statearr_53463_53553[(5)] = null);

} else {
throw ex53458;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (14))){
var state_53445__$1 = state_53445;
var statearr_53464_53554 = state_53445__$1;
(statearr_53464_53554[(2)] = null);

(statearr_53464_53554[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (16))){
var inst_53434 = (state_53445[(2)]);
var inst_53435 = fluree.db.util.async.throw_err(inst_53434);
var state_53445__$1 = state_53445;
var statearr_53465_53555 = state_53445__$1;
(statearr_53465_53555[(2)] = inst_53435);

(statearr_53465_53555[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (10))){
var state_53445__$1 = state_53445;
var statearr_53466_53556 = state_53445__$1;
(statearr_53466_53556[(2)] = pred);

(statearr_53466_53556[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_53446 === (8))){
var inst_53440 = (state_53445[(2)]);
var _ = (function (){var statearr_53467 = state_53445;
(statearr_53467[(4)] = cljs.core.rest((state_53445[(4)])));

return statearr_53467;
})();
var state_53445__$1 = state_53445;
var statearr_53468_53557 = state_53445__$1;
(statearr_53468_53557[(2)] = inst_53440);

(statearr_53468_53557[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__24298__auto__ = null;
var fluree$db$graphdb$state_machine__24298__auto____0 = (function (){
var statearr_53469 = [null,null,null,null,null,null,null,null];
(statearr_53469[(0)] = fluree$db$graphdb$state_machine__24298__auto__);

(statearr_53469[(1)] = (1));

return statearr_53469;
});
var fluree$db$graphdb$state_machine__24298__auto____1 = (function (state_53445){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_53445);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e53470){var ex__24301__auto__ = e53470;
var statearr_53471_53558 = state_53445;
(statearr_53471_53558[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_53445[(4)]))){
var statearr_53472_53559 = state_53445;
(statearr_53472_53559[(1)] = cljs.core.first((state_53445[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__53560 = state_53445;
state_53445 = G__53560;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__24298__auto__ = function(state_53445){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__24298__auto____1.call(this,state_53445);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__24298__auto____0;
fluree$db$graphdb$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__24298__auto____1;
return fluree$db$graphdb$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_53473 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_53473[(6)] = c__24424__auto__);

return statearr_53473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__53142){
var extmap__4501__auto__ = (function (){var G__53474 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__53142,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__53142)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__53474);
} else {
return G__53474;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__53142),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__53142),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
