// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41565){
var state_val_41566 = (state_41565[(1)]);
if((state_val_41566 === (1))){
var state_41565__$1 = state_41565;
var statearr_41567_41581 = state_41565__$1;
(statearr_41567_41581[(2)] = null);

(statearr_41567_41581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41566 === (2))){
var _ = (function (){var statearr_41568 = state_41565;
(statearr_41568[(4)] = cljs.core.cons((5),(state_41565[(4)])));

return statearr_41568;
})();
var inst_41556 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_41565__$1 = state_41565;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41565__$1,(6),inst_41556);
} else {
if((state_val_41566 === (3))){
var inst_41563 = (state_41565[(2)]);
var state_41565__$1 = state_41565;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41565__$1,inst_41563);
} else {
if((state_val_41566 === (4))){
var inst_41550 = (state_41565[(2)]);
var state_41565__$1 = state_41565;
var statearr_41570_41582 = state_41565__$1;
(statearr_41570_41582[(2)] = inst_41550);

(statearr_41570_41582[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41566 === (5))){
var _ = (function (){var statearr_41571 = state_41565;
(statearr_41571[(4)] = cljs.core.rest((state_41565[(4)])));

return statearr_41571;
})();
var state_41565__$1 = state_41565;
var ex41569 = (state_41565__$1[(2)]);
var statearr_41572_41583 = state_41565__$1;
(statearr_41572_41583[(5)] = ex41569);


if((ex41569 instanceof Error)){
var statearr_41573_41584 = state_41565__$1;
(statearr_41573_41584[(1)] = (4));

(statearr_41573_41584[(5)] = null);

} else {
throw ex41569;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41566 === (6))){
var inst_41558 = (state_41565[(2)]);
var inst_41559 = fluree.db.util.async.throw_err(inst_41558);
var inst_41560 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_41559);
var _ = (function (){var statearr_41574 = state_41565;
(statearr_41574[(4)] = cljs.core.rest((state_41565[(4)])));

return statearr_41574;
})();
var state_41565__$1 = state_41565;
var statearr_41575_41585 = state_41565__$1;
(statearr_41575_41585[(2)] = inst_41560);

(statearr_41575_41585[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____0 = (function (){
var statearr_41576 = [null,null,null,null,null,null,null];
(statearr_41576[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__);

(statearr_41576[(1)] = (1));

return statearr_41576;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____1 = (function (state_41565){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41565);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41577){var ex__24301__auto__ = e41577;
var statearr_41578_41586 = state_41565;
(statearr_41578_41586[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41565[(4)]))){
var statearr_41579_41587 = state_41565;
(statearr_41579_41587[(1)] = cljs.core.first((state_41565[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41588 = state_41565;
state_41565 = G__41588;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__ = function(state_41565){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____1.call(this,state_41565);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41580 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41580[(6)] = c__24424__auto__);

return statearr_41580;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41620){
var state_val_41621 = (state_41620[(1)]);
if((state_val_41621 === (7))){
var inst_41604 = (state_41620[(7)]);
var inst_41606 = cljs.core.empty_QMARK_(inst_41604);
var inst_41607 = (!(inst_41606));
var state_41620__$1 = state_41620;
var statearr_41622_41646 = state_41620__$1;
(statearr_41622_41646[(2)] = inst_41607);

(statearr_41622_41646[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (1))){
var state_41620__$1 = state_41620;
var statearr_41623_41647 = state_41620__$1;
(statearr_41623_41647[(2)] = null);

(statearr_41623_41647[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (4))){
var inst_41590 = (state_41620[(2)]);
var state_41620__$1 = state_41620;
var statearr_41624_41648 = state_41620__$1;
(statearr_41624_41648[(2)] = inst_41590);

(statearr_41624_41648[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (6))){
var inst_41596 = (state_41620[(8)]);
var inst_41604 = (state_41620[(7)]);
var inst_41602 = (state_41620[(2)]);
var inst_41603 = fluree.db.util.async.throw_err(inst_41602);
var inst_41604__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_41596,inst_41603);
var state_41620__$1 = (function (){var statearr_41625 = state_41620;
(statearr_41625[(7)] = inst_41604__$1);

return statearr_41625;
})();
if(cljs.core.truth_(inst_41604__$1)){
var statearr_41626_41649 = state_41620__$1;
(statearr_41626_41649[(1)] = (7));

} else {
var statearr_41627_41650 = state_41620__$1;
(statearr_41627_41650[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (3))){
var inst_41618 = (state_41620[(2)]);
var state_41620__$1 = state_41620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41620__$1,inst_41618);
} else {
if((state_val_41621 === (12))){
var inst_41615 = (state_41620[(2)]);
var _ = (function (){var statearr_41628 = state_41620;
(statearr_41628[(4)] = cljs.core.rest((state_41620[(4)])));

return statearr_41628;
})();
var state_41620__$1 = state_41620;
var statearr_41629_41651 = state_41620__$1;
(statearr_41629_41651[(2)] = inst_41615);

(statearr_41629_41651[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (2))){
var _ = (function (){var statearr_41630 = state_41620;
(statearr_41630[(4)] = cljs.core.cons((5),(state_41620[(4)])));

return statearr_41630;
})();
var inst_41596 = (function (){return (function (p1__41589_SHARP_){
return p1__41589_SHARP_.o;
});
})();
var inst_41597 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41598 = [pred_id];
var inst_41599 = (new cljs.core.PersistentVector(null,1,(5),inst_41597,inst_41598,null));
var inst_41600 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41599);
var state_41620__$1 = (function (){var statearr_41631 = state_41620;
(statearr_41631[(8)] = inst_41596);

return statearr_41631;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41620__$1,(6),inst_41600);
} else {
if((state_val_41621 === (11))){
var state_41620__$1 = state_41620;
var statearr_41633_41652 = state_41620__$1;
(statearr_41633_41652[(2)] = true);

(statearr_41633_41652[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (9))){
var inst_41610 = (state_41620[(2)]);
var state_41620__$1 = state_41620;
if(cljs.core.truth_(inst_41610)){
var statearr_41634_41653 = state_41620__$1;
(statearr_41634_41653[(1)] = (10));

} else {
var statearr_41635_41654 = state_41620__$1;
(statearr_41635_41654[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (5))){
var _ = (function (){var statearr_41636 = state_41620;
(statearr_41636[(4)] = cljs.core.rest((state_41620[(4)])));

return statearr_41636;
})();
var state_41620__$1 = state_41620;
var ex41632 = (state_41620__$1[(2)]);
var statearr_41637_41655 = state_41620__$1;
(statearr_41637_41655[(5)] = ex41632);


if((ex41632 instanceof Error)){
var statearr_41638_41656 = state_41620__$1;
(statearr_41638_41656[(1)] = (4));

(statearr_41638_41656[(5)] = null);

} else {
throw ex41632;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (10))){
var inst_41604 = (state_41620[(7)]);
var inst_41612 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_41604);
var state_41620__$1 = state_41620;
var statearr_41639_41657 = state_41620__$1;
(statearr_41639_41657[(2)] = inst_41612);

(statearr_41639_41657[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41621 === (8))){
var inst_41604 = (state_41620[(7)]);
var state_41620__$1 = state_41620;
var statearr_41640_41658 = state_41620__$1;
(statearr_41640_41658[(2)] = inst_41604);

(statearr_41640_41658[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____0 = (function (){
var statearr_41641 = [null,null,null,null,null,null,null,null,null];
(statearr_41641[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__);

(statearr_41641[(1)] = (1));

return statearr_41641;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____1 = (function (state_41620){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41620);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41642){var ex__24301__auto__ = e41642;
var statearr_41643_41659 = state_41620;
(statearr_41643_41659[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41620[(4)]))){
var statearr_41644_41660 = state_41620;
(statearr_41644_41660[(1)] = cljs.core.first((state_41620[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41661 = state_41620;
state_41620 = G__41661;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__ = function(state_41620){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____1.call(this,state_41620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41645 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41645[(6)] = c__24424__auto__);

return statearr_41645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_41742){
var state_val_41743 = (state_41742[(1)]);
if((state_val_41743 === (7))){
var state_41742__$1 = state_41742;
var statearr_41744_41782 = state_41742__$1;
(statearr_41744_41782[(2)] = flakes);

(statearr_41744_41782[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (20))){
var inst_41699 = (state_41742[(7)]);
var inst_41732 = (state_41742[(2)]);
var inst_41691 = inst_41699;
var inst_41692 = inst_41732;
var state_41742__$1 = (function (){var statearr_41745 = state_41742;
(statearr_41745[(8)] = inst_41691);

(statearr_41745[(9)] = inst_41692);

return statearr_41745;
})();
var statearr_41746_41783 = state_41742__$1;
(statearr_41746_41783[(2)] = null);

(statearr_41746_41783[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (1))){
var state_41742__$1 = state_41742;
var statearr_41747_41784 = state_41742__$1;
(statearr_41747_41784[(2)] = null);

(statearr_41747_41784[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (4))){
var inst_41664 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
var statearr_41748_41785 = state_41742__$1;
(statearr_41748_41785[(2)] = inst_41664);

(statearr_41748_41785[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (15))){
var inst_41698 = (state_41742[(10)]);
var inst_41716 = inst_41698.o;
var state_41742__$1 = state_41742;
var statearr_41749_41786 = state_41742__$1;
(statearr_41749_41786[(2)] = inst_41716);

(statearr_41749_41786[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (13))){
var inst_41735 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
var statearr_41750_41787 = state_41742__$1;
(statearr_41750_41787[(2)] = inst_41735);

(statearr_41750_41787[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (6))){
var inst_41671 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_41742__$1 = state_41742;
var statearr_41751_41788 = state_41742__$1;
(statearr_41751_41788[(2)] = inst_41671);

(statearr_41751_41788[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (17))){
var inst_41713 = (state_41742[(2)]);
var inst_41714 = fluree.db.util.async.throw_err(inst_41713);
var state_41742__$1 = state_41742;
var statearr_41752_41789 = state_41742__$1;
(statearr_41752_41789[(2)] = inst_41714);

(statearr_41752_41789[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (3))){
var inst_41740 = (state_41742[(2)]);
var state_41742__$1 = state_41742;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41742__$1,inst_41740);
} else {
if((state_val_41743 === (12))){
var inst_41698 = (state_41742[(10)]);
var inst_41705 = (state_41742[(11)]);
var inst_41703 = inst_41698.p;
var inst_41704 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_41703);
var inst_41705__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_41704);
var inst_41706 = inst_41698.op;
var inst_41707 = inst_41706 === false;
var inst_41708 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_41705__$1);
var state_41742__$1 = (function (){var statearr_41753 = state_41742;
(statearr_41753[(11)] = inst_41705__$1);

(statearr_41753[(12)] = inst_41707);

return statearr_41753;
})();
if(inst_41708){
var statearr_41754_41790 = state_41742__$1;
(statearr_41754_41790[(1)] = (14));

} else {
var statearr_41755_41791 = state_41742__$1;
(statearr_41755_41791[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (2))){
var _ = (function (){var statearr_41756 = state_41742;
(statearr_41756[(4)] = cljs.core.cons((5),(state_41742[(4)])));

return statearr_41756;
})();
var state_41742__$1 = state_41742;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_41757_41792 = state_41742__$1;
(statearr_41757_41792[(1)] = (6));

} else {
var statearr_41758_41793 = state_41742__$1;
(statearr_41758_41793[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (19))){
var inst_41698 = (state_41742[(10)]);
var inst_41718 = (state_41742[(13)]);
var inst_41692 = (state_41742[(9)]);
var inst_41705 = (state_41742[(11)]);
var inst_41726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41727 = inst_41698.s;
var inst_41728 = [inst_41727,inst_41705,cljs.core.cst$kw$new];
var inst_41729 = (new cljs.core.PersistentVector(null,3,(5),inst_41726,inst_41728,null));
var inst_41730 = cljs.core.assoc_in(inst_41692,inst_41729,inst_41718);
var state_41742__$1 = state_41742;
var statearr_41759_41794 = state_41742__$1;
(statearr_41759_41794[(2)] = inst_41730);

(statearr_41759_41794[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (11))){
var inst_41692 = (state_41742[(9)]);
var state_41742__$1 = state_41742;
var statearr_41761_41795 = state_41742__$1;
(statearr_41761_41795[(2)] = inst_41692);

(statearr_41761_41795[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (9))){
var inst_41698 = (state_41742[(10)]);
var inst_41691 = (state_41742[(8)]);
var inst_41697 = cljs.core.seq(inst_41691);
var inst_41698__$1 = cljs.core.first(inst_41697);
var inst_41699 = cljs.core.next(inst_41697);
var inst_41700 = cljs.core.not(inst_41698__$1);
var state_41742__$1 = (function (){var statearr_41762 = state_41742;
(statearr_41762[(7)] = inst_41699);

(statearr_41762[(10)] = inst_41698__$1);

return statearr_41762;
})();
if(inst_41700){
var statearr_41763_41796 = state_41742__$1;
(statearr_41763_41796[(1)] = (11));

} else {
var statearr_41764_41797 = state_41742__$1;
(statearr_41764_41797[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (5))){
var _ = (function (){var statearr_41765 = state_41742;
(statearr_41765[(4)] = cljs.core.rest((state_41742[(4)])));

return statearr_41765;
})();
var state_41742__$1 = state_41742;
var ex41760 = (state_41742__$1[(2)]);
var statearr_41766_41798 = state_41742__$1;
(statearr_41766_41798[(5)] = ex41760);


if((ex41760 instanceof Error)){
var statearr_41767_41799 = state_41742__$1;
(statearr_41767_41799[(1)] = (4));

(statearr_41767_41799[(5)] = null);

} else {
throw ex41760;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (14))){
var inst_41698 = (state_41742[(10)]);
var inst_41710 = inst_41698.o;
var inst_41711 = fluree.db.query.schema.convert_type_to_kw(inst_41710,db);
var state_41742__$1 = state_41742;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41742__$1,(17),inst_41711);
} else {
if((state_val_41743 === (16))){
var inst_41707 = (state_41742[(12)]);
var inst_41718 = (state_41742[(2)]);
var state_41742__$1 = (function (){var statearr_41768 = state_41742;
(statearr_41768[(13)] = inst_41718);

return statearr_41768;
})();
if(cljs.core.truth_(inst_41707)){
var statearr_41769_41800 = state_41742__$1;
(statearr_41769_41800[(1)] = (18));

} else {
var statearr_41770_41801 = state_41742__$1;
(statearr_41770_41801[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (10))){
var inst_41737 = (state_41742[(2)]);
var _ = (function (){var statearr_41771 = state_41742;
(statearr_41771[(4)] = cljs.core.rest((state_41742[(4)])));

return statearr_41771;
})();
var state_41742__$1 = state_41742;
var statearr_41772_41802 = state_41742__$1;
(statearr_41772_41802[(2)] = inst_41737);

(statearr_41772_41802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (18))){
var inst_41698 = (state_41742[(10)]);
var inst_41718 = (state_41742[(13)]);
var inst_41692 = (state_41742[(9)]);
var inst_41705 = (state_41742[(11)]);
var inst_41720 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41721 = inst_41698.s;
var inst_41722 = [inst_41721,inst_41705,cljs.core.cst$kw$old];
var inst_41723 = (new cljs.core.PersistentVector(null,3,(5),inst_41720,inst_41722,null));
var inst_41724 = cljs.core.assoc_in(inst_41692,inst_41723,inst_41718);
var state_41742__$1 = state_41742;
var statearr_41773_41803 = state_41742__$1;
(statearr_41773_41803[(2)] = inst_41724);

(statearr_41773_41803[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41743 === (8))){
var inst_41674 = (state_41742[(2)]);
var inst_41675 = cljs.core.PersistentHashSet.EMPTY;
var inst_41676 = cljs.core.vals(tempids);
var inst_41677 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41675,inst_41676);
var inst_41678 = (function (){var pred_flakes = inst_41674;
var is_new_QMARK_ = inst_41677;
return (function (p1__41663_SHARP_,p2__41662_SHARP_){
var f = p2__41662_SHARP_;
return cljs.core.assoc_in(p1__41663_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__41774 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__41774) : is_new_QMARK_.call(null,G__41774));
})()));
});
})();
var inst_41679 = cljs.core.PersistentHashMap.EMPTY;
var inst_41680 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_41678,inst_41679,inst_41674);
var inst_41688 = cljs.core.seq(inst_41674);
var inst_41689 = cljs.core.first(inst_41688);
var inst_41690 = cljs.core.next(inst_41688);
var inst_41691 = inst_41674;
var inst_41692 = inst_41680;
var state_41742__$1 = (function (){var statearr_41775 = state_41742;
(statearr_41775[(8)] = inst_41691);

(statearr_41775[(9)] = inst_41692);

(statearr_41775[(14)] = inst_41689);

(statearr_41775[(15)] = inst_41690);

return statearr_41775;
})();
var statearr_41776_41804 = state_41742__$1;
(statearr_41776_41804[(2)] = null);

(statearr_41776_41804[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____0 = (function (){
var statearr_41777 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41777[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__);

(statearr_41777[(1)] = (1));

return statearr_41777;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____1 = (function (state_41742){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_41742);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e41778){var ex__24301__auto__ = e41778;
var statearr_41779_41805 = state_41742;
(statearr_41779_41805[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_41742[(4)]))){
var statearr_41780_41806 = state_41742;
(statearr_41780_41806[(1)] = cljs.core.first((state_41742[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__41807 = state_41742;
state_41742 = G__41807;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__ = function(state_41742){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____1.call(this,state_41742);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_41781 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_41781[(6)] = c__24424__auto__);

return statearr_41781;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__41809 = arguments.length;
switch (G__41809) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__41812 = arguments.length;
switch (G__41812) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42124){
var state_val_42125 = (state_42124[(1)]);
if((state_val_42125 === (121))){
var inst_42079 = (state_42124[(7)]);
var state_42124__$1 = state_42124;
var statearr_42126_42319 = state_42124__$1;
(statearr_42126_42319[(2)] = inst_42079);

(statearr_42126_42319[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (65))){
var inst_41978 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41978)){
var statearr_42127_42320 = state_42124__$1;
(statearr_42127_42320[(1)] = (66));

} else {
var statearr_42128_42321 = state_42124__$1;
(statearr_42128_42321[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (70))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_41988 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_41989 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_41988,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,3,inst_41988,null));
var inst_41990 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41989,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_41989,null));
var inst_41991 = (inst_41990.cljs$core$IFn$_invoke$arity$1 ? inst_41990.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_41990.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41991)){
var statearr_42129_42322 = state_42124__$1;
(statearr_42129_42322[(1)] = (72));

} else {
var statearr_42130_42323 = state_42124__$1;
(statearr_42130_42323[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (62))){
var inst_41968 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42131_42324 = state_42124__$1;
(statearr_42131_42324[(2)] = inst_41968);

(statearr_42131_42324[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (74))){
var inst_42074 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42132_42325 = state_42124__$1;
(statearr_42132_42325[(2)] = inst_42074);

(statearr_42132_42325[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (110))){
var inst_42101 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42101)){
var statearr_42133_42326 = state_42124__$1;
(statearr_42133_42326[(1)] = (117));

} else {
var statearr_42134_42327 = state_42124__$1;
(statearr_42134_42327[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (7))){
var inst_42119 = (state_42124[(2)]);
var _ = (function (){var statearr_42135 = state_42124;
(statearr_42135[(4)] = cljs.core.rest((state_42124[(4)])));

return statearr_42135;
})();
var state_42124__$1 = state_42124;
var statearr_42136_42328 = state_42124__$1;
(statearr_42136_42328[(2)] = inst_42119);

(statearr_42136_42328[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (59))){
var inst_41852 = (state_42124[(10)]);
var inst_41972 = (state_42124[(11)]);
var inst_41971 = (state_42124[(2)]);
var inst_41972__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42137 = state_42124;
(statearr_42137[(12)] = inst_41971);

(statearr_42137[(11)] = inst_41972__$1);

return statearr_42137;
})();
if(cljs.core.truth_(inst_41972__$1)){
var statearr_42138_42329 = state_42124__$1;
(statearr_42138_42329[(1)] = (63));

} else {
var statearr_42139_42330 = state_42124__$1;
(statearr_42139_42330[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (86))){
var inst_42014 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42140_42331 = state_42124__$1;
(statearr_42140_42331[(2)] = inst_42014);

(statearr_42140_42331[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (20))){
var inst_41852 = (state_42124[(10)]);
var inst_41878 = (state_42124[(13)]);
var inst_41878__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42141 = state_42124;
(statearr_42141[(13)] = inst_41878__$1);

return statearr_42141;
})();
if(cljs.core.truth_(inst_41878__$1)){
var statearr_42142_42332 = state_42124__$1;
(statearr_42142_42332[(1)] = (23));

} else {
var statearr_42143_42333 = state_42124__$1;
(statearr_42143_42333[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (72))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_41993 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42144_42334 = state_42124__$1;
(statearr_42144_42334[(2)] = inst_41993);

(statearr_42144_42334[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (58))){
var inst_41933 = (state_42124[(14)]);
var state_42124__$1 = state_42124;
var statearr_42145_42335 = state_42124__$1;
(statearr_42145_42335[(2)] = inst_41933);

(statearr_42145_42335[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (60))){
var inst_41840 = (state_42124[(15)]);
var inst_41851 = (state_42124[(16)]);
var inst_41959 = fluree.db.dbproto._p_prop(inst_41840,cljs.core.cst$kw$name,inst_41851);
var inst_41960 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41959)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_41961 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41962 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_41963 = cljs.core.PersistentHashMap.fromArrays(inst_41961,inst_41962);
var inst_41964 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41960,inst_41963);
var inst_41965 = (function(){throw inst_41964})();
var state_42124__$1 = state_42124;
var statearr_42146_42336 = state_42124__$1;
(statearr_42146_42336[(2)] = inst_41965);

(statearr_42146_42336[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (27))){
var inst_41881 = (state_42124[(17)]);
var state_42124__$1 = state_42124;
var statearr_42147_42337 = state_42124__$1;
(statearr_42147_42337[(2)] = inst_41881);

(statearr_42147_42337[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (1))){
var state_42124__$1 = state_42124;
var statearr_42148_42338 = state_42124__$1;
(statearr_42148_42338[(2)] = null);

(statearr_42148_42338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (69))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42149_42339 = state_42124__$1;
(statearr_42149_42339[(2)] = inst_41971);

(statearr_42149_42339[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (101))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42052 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42150_42340 = state_42124__$1;
(statearr_42150_42340[(2)] = inst_42052);

(statearr_42150_42340[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (24))){
var inst_41878 = (state_42124[(13)]);
var state_42124__$1 = state_42124;
var statearr_42151_42341 = state_42124__$1;
(statearr_42151_42341[(2)] = inst_41878);

(statearr_42151_42341[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (102))){
var inst_42054 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42152_42342 = state_42124__$1;
(statearr_42152_42342[(2)] = inst_42054);

(statearr_42152_42342[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (55))){
var inst_41950 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42153_42343 = state_42124__$1;
(statearr_42153_42343[(2)] = inst_41950);

(statearr_42153_42343[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (85))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42012 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42154_42344 = state_42124__$1;
(statearr_42154_42344[(2)] = inst_42012);

(statearr_42154_42344[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (39))){
var inst_41915 = (state_42124[(18)]);
var state_42124__$1 = state_42124;
var statearr_42155_42345 = state_42124__$1;
(statearr_42155_42345[(2)] = inst_41915);

(statearr_42155_42345[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (88))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42156_42346 = state_42124__$1;
(statearr_42156_42346[(2)] = inst_41971);

(statearr_42156_42346[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (46))){
var inst_41852 = (state_42124[(10)]);
var inst_41934 = (state_42124[(19)]);
var inst_41933 = (state_42124[(2)]);
var inst_41934__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42157 = state_42124;
(statearr_42157[(19)] = inst_41934__$1);

(statearr_42157[(14)] = inst_41933);

return statearr_42157;
})();
if(cljs.core.truth_(inst_41934__$1)){
var statearr_42158_42347 = state_42124__$1;
(statearr_42158_42347[(1)] = (47));

} else {
var statearr_42159_42348 = state_42124__$1;
(statearr_42159_42348[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (4))){
var inst_41813 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42160_42349 = state_42124__$1;
(statearr_42160_42349[(2)] = inst_41813);

(statearr_42160_42349[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (77))){
var inst_42072 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42161_42350 = state_42124__$1;
(statearr_42161_42350[(2)] = inst_42072);

(statearr_42161_42350[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (106))){
var inst_42064 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42162_42351 = state_42124__$1;
(statearr_42162_42351[(2)] = inst_42064);

(statearr_42162_42351[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (119))){
var inst_41850 = (state_42124[(20)]);
var inst_42114 = (state_42124[(2)]);
var inst_41839 = inst_41850;
var inst_41840 = inst_42114;
var state_42124__$1 = (function (){var statearr_42163 = state_42124;
(statearr_42163[(15)] = inst_41840);

(statearr_42163[(21)] = inst_41839);

return statearr_42163;
})();
var statearr_42164_42352 = state_42124__$1;
(statearr_42164_42352[(2)] = null);

(statearr_42164_42352[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (95))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42036 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_42037 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_42036,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,5,inst_42036,null));
var inst_42038 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42037,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42037,null));
var inst_42039 = (inst_42038.cljs$core$IFn$_invoke$arity$1 ? inst_42038.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42038.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42039)){
var statearr_42165_42353 = state_42124__$1;
(statearr_42165_42353[(1)] = (96));

} else {
var statearr_42166_42354 = state_42124__$1;
(statearr_42166_42354[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (54))){
var inst_41941 = (state_42124[(22)]);
var state_42124__$1 = state_42124;
var statearr_42167_42355 = state_42124__$1;
(statearr_42167_42355[(2)] = inst_41941);

(statearr_42167_42355[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (92))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42168_42356 = state_42124__$1;
(statearr_42168_42356[(2)] = inst_41971);

(statearr_42168_42356[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (104))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42169_42357 = state_42124__$1;
(statearr_42169_42357[(2)] = inst_41971);

(statearr_42169_42357[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (15))){
var inst_41860 = (state_42124[(23)]);
var state_42124__$1 = state_42124;
var statearr_42170_42358 = state_42124__$1;
(statearr_42170_42358[(2)] = inst_41860);

(statearr_42170_42358[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (48))){
var inst_41934 = (state_42124[(19)]);
var state_42124__$1 = state_42124;
var statearr_42171_42359 = state_42124__$1;
(statearr_42171_42359[(2)] = inst_41934);

(statearr_42171_42359[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (50))){
var inst_41941 = (state_42124[(22)]);
var inst_41852 = (state_42124[(10)]);
var inst_41939 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41940 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41939);
var inst_41941__$1 = inst_41940 === true;
var state_42124__$1 = (function (){var statearr_42172 = state_42124;
(statearr_42172[(22)] = inst_41941__$1);

return statearr_42172;
})();
if(cljs.core.truth_(inst_41941__$1)){
var statearr_42173_42360 = state_42124__$1;
(statearr_42173_42360[(1)] = (53));

} else {
var statearr_42174_42361 = state_42124__$1;
(statearr_42174_42361[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (116))){
var inst_42095 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42175_42362 = state_42124__$1;
(statearr_42175_42362[(2)] = inst_42095);

(statearr_42175_42362[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (75))){
var inst_41984 = (state_42124[(9)]);
var state_42124__$1 = state_42124;
var G__42176_42363 = inst_41984;
var G__42176_42364__$1 = (((G__42176_42363 instanceof cljs.core.Keyword))?G__42176_42363.fqn:null);
switch (G__42176_42364__$1) {
case "long":
var statearr_42177_42366 = state_42124__$1;
(statearr_42177_42366[(1)] = (79));


break;
case "bigint":
var statearr_42178_42367 = state_42124__$1;
(statearr_42178_42367[(1)] = (83));


break;
case "double":
var statearr_42179_42368 = state_42124__$1;
(statearr_42179_42368[(1)] = (87));


break;
case "float":
var statearr_42180_42369 = state_42124__$1;
(statearr_42180_42369[(1)] = (91));


break;
case "bigdec":
var statearr_42181_42370 = state_42124__$1;
(statearr_42181_42370[(1)] = (95));


break;
case "string":
var statearr_42182_42371 = state_42124__$1;
(statearr_42182_42371[(1)] = (99));


break;
case "instant":
var statearr_42183_42372 = state_42124__$1;
(statearr_42183_42372[(1)] = (103));


break;
default:
var statearr_42184_42373 = state_42124__$1;
(statearr_42184_42373[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (99))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42046 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_42047 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_42046,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,5,inst_42046,null));
var inst_42048 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42047,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42047,null));
var inst_42049 = (inst_42048.cljs$core$IFn$_invoke$arity$1 ? inst_42048.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42048.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42049)){
var statearr_42185_42374 = state_42124__$1;
(statearr_42185_42374[(1)] = (100));

} else {
var statearr_42186_42375 = state_42124__$1;
(statearr_42186_42375[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (21))){
var inst_41876 = (state_42124[(24)]);
var state_42124__$1 = state_42124;
var statearr_42187_42376 = state_42124__$1;
(statearr_42187_42376[(2)] = inst_41876);

(statearr_42187_42376[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (31))){
var inst_41892 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42188_42377 = state_42124__$1;
(statearr_42188_42377[(2)] = inst_41892);

(statearr_42188_42377[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (113))){
var inst_42098 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42189_42378 = state_42124__$1;
(statearr_42189_42378[(2)] = inst_42098);

(statearr_42189_42378[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (32))){
var state_42124__$1 = state_42124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_42190_42379 = state_42124__$1;
(statearr_42190_42379[(1)] = (35));

} else {
var statearr_42191_42380 = state_42124__$1;
(statearr_42191_42380[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (40))){
var inst_41928 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41928)){
var statearr_42192_42381 = state_42124__$1;
(statearr_42192_42381[(1)] = (44));

} else {
var statearr_42193_42382 = state_42124__$1;
(statearr_42193_42382[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (91))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42026 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_42027 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_42026,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,3,inst_42026,null));
var inst_42028 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42027,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42027,null));
var inst_42029 = (inst_42028.cljs$core$IFn$_invoke$arity$1 ? inst_42028.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42028.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42029)){
var statearr_42194_42383 = state_42124__$1;
(statearr_42194_42383[(1)] = (92));

} else {
var statearr_42195_42384 = state_42124__$1;
(statearr_42195_42384[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (117))){
var state_42124__$1 = state_42124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_42196_42385 = state_42124__$1;
(statearr_42196_42385[(1)] = (120));

} else {
var statearr_42197_42386 = state_42124__$1;
(statearr_42197_42386[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (108))){
var inst_42083 = (state_42124[(25)]);
var inst_41852 = (state_42124[(10)]);
var inst_42083__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42198 = state_42124;
(statearr_42198[(25)] = inst_42083__$1);

return statearr_42198;
})();
if(cljs.core.truth_(inst_42083__$1)){
var statearr_42199_42387 = state_42124__$1;
(statearr_42199_42387[(1)] = (111));

} else {
var statearr_42200_42388 = state_42124__$1;
(statearr_42200_42388[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (56))){
var inst_41945 = (state_42124[(2)]);
var inst_41946 = fluree.db.util.async.throw_err(inst_41945);
var inst_41947 = cljs.core.not(inst_41946);
var state_42124__$1 = state_42124;
var statearr_42201_42389 = state_42124__$1;
(statearr_42201_42389[(2)] = inst_41947);

(statearr_42201_42389[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (33))){
var inst_41875 = (state_42124[(26)]);
var state_42124__$1 = state_42124;
var statearr_42202_42390 = state_42124__$1;
(statearr_42202_42390[(2)] = inst_41875);

(statearr_42202_42390[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (13))){
var inst_41870 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41870)){
var statearr_42203_42391 = state_42124__$1;
(statearr_42203_42391[(1)] = (17));

} else {
var statearr_42204_42392 = state_42124__$1;
(statearr_42204_42392[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (22))){
var inst_41901 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41901)){
var statearr_42205_42393 = state_42124__$1;
(statearr_42205_42393[(1)] = (32));

} else {
var statearr_42206_42394 = state_42124__$1;
(statearr_42206_42394[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (90))){
var inst_42024 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42207_42395 = state_42124__$1;
(statearr_42207_42395[(2)] = inst_42024);

(statearr_42207_42395[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (109))){
var inst_42081 = (state_42124[(27)]);
var state_42124__$1 = state_42124;
var statearr_42208_42396 = state_42124__$1;
(statearr_42208_42396[(2)] = inst_42081);

(statearr_42208_42396[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (36))){
var inst_41875 = (state_42124[(26)]);
var state_42124__$1 = state_42124;
var statearr_42209_42397 = state_42124__$1;
(statearr_42209_42397[(2)] = inst_41875);

(statearr_42209_42397[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (41))){
var inst_41852 = (state_42124[(10)]);
var inst_41920 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41921 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41920);
var inst_41922 = inst_41921 === true;
var state_42124__$1 = state_42124;
var statearr_42210_42398 = state_42124__$1;
(statearr_42210_42398[(2)] = inst_41922);

(statearr_42210_42398[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (118))){
var inst_42079 = (state_42124[(7)]);
var state_42124__$1 = state_42124;
var statearr_42211_42399 = state_42124__$1;
(statearr_42211_42399[(2)] = inst_42079);

(statearr_42211_42399[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (89))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42022 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42212_42400 = state_42124__$1;
(statearr_42212_42400[(2)] = inst_42022);

(statearr_42212_42400[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (100))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42213_42401 = state_42124__$1;
(statearr_42213_42401[(2)] = inst_41971);

(statearr_42213_42401[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (122))){
var inst_42111 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42214_42402 = state_42124__$1;
(statearr_42214_42402[(2)] = inst_42111);

(statearr_42214_42402[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (43))){
var inst_41925 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42215_42403 = state_42124__$1;
(statearr_42215_42403[(2)] = inst_41925);

(statearr_42215_42403[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (61))){
var inst_41933 = (state_42124[(14)]);
var state_42124__$1 = state_42124;
var statearr_42216_42404 = state_42124__$1;
(statearr_42216_42404[(2)] = inst_41933);

(statearr_42216_42404[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (29))){
var inst_41852 = (state_42124[(10)]);
var inst_41887 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41888 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41887);
var inst_41889 = inst_41888 === true;
var state_42124__$1 = state_42124;
var statearr_42217_42405 = state_42124__$1;
(statearr_42217_42405[(2)] = inst_41889);

(statearr_42217_42405[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (44))){
var inst_41914 = (state_42124[(28)]);
var inst_41930 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_41914,"a component","a non-component",throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42218_42406 = state_42124__$1;
(statearr_42218_42406[(2)] = inst_41930);

(statearr_42218_42406[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (93))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42032 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42219_42407 = state_42124__$1;
(statearr_42219_42407[(2)] = inst_42032);

(statearr_42219_42407[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (6))){
var inst_41851 = (state_42124[(16)]);
var inst_41839 = (state_42124[(21)]);
var inst_41848 = cljs.core.seq(inst_41839);
var inst_41849 = cljs.core.first(inst_41848);
var inst_41850 = cljs.core.next(inst_41848);
var inst_41851__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41849,(0),null);
var inst_41852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41849,(1),null);
var inst_41853 = cljs.core.not(inst_41851__$1);
var state_42124__$1 = (function (){var statearr_42220 = state_42124;
(statearr_42220[(10)] = inst_41852);

(statearr_42220[(16)] = inst_41851__$1);

(statearr_42220[(20)] = inst_41850);

return statearr_42220;
})();
if(inst_41853){
var statearr_42221_42408 = state_42124__$1;
(statearr_42221_42408[(1)] = (8));

} else {
var statearr_42222_42409 = state_42124__$1;
(statearr_42222_42409[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (111))){
var inst_41852 = (state_42124[(10)]);
var inst_42087 = (state_42124[(29)]);
var inst_42085 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_42086 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_42085);
var inst_42087__$1 = inst_42086 === true;
var state_42124__$1 = (function (){var statearr_42223 = state_42124;
(statearr_42223[(29)] = inst_42087__$1);

return statearr_42223;
})();
if(cljs.core.truth_(inst_42087__$1)){
var statearr_42224_42410 = state_42124__$1;
(statearr_42224_42410[(1)] = (114));

} else {
var statearr_42225_42411 = state_42124__$1;
(statearr_42225_42411[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (28))){
var inst_41895 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42226_42412 = state_42124__$1;
(statearr_42226_42412[(2)] = inst_41895);

(statearr_42226_42412[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (64))){
var inst_41972 = (state_42124[(11)]);
var state_42124__$1 = state_42124;
var statearr_42227_42413 = state_42124__$1;
(statearr_42227_42413[(2)] = inst_41972);

(statearr_42227_42413[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (103))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42056 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_42057 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_42056,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,2,inst_42056,null));
var inst_42058 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42057,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42057,null));
var inst_42059 = (inst_42058.cljs$core$IFn$_invoke$arity$1 ? inst_42058.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42058.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42059)){
var statearr_42228_42414 = state_42124__$1;
(statearr_42228_42414[(1)] = (104));

} else {
var statearr_42229_42415 = state_42124__$1;
(statearr_42229_42415[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (51))){
var inst_41937 = (state_42124[(30)]);
var state_42124__$1 = state_42124;
var statearr_42230_42416 = state_42124__$1;
(statearr_42230_42416[(2)] = inst_41937);

(statearr_42230_42416[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (25))){
var inst_41898 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42231_42417 = state_42124__$1;
(statearr_42231_42417[(2)] = inst_41898);

(statearr_42231_42417[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (34))){
var inst_41915 = (state_42124[(18)]);
var inst_41852 = (state_42124[(10)]);
var inst_41914 = (state_42124[(2)]);
var inst_41915__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42232 = state_42124;
(statearr_42232[(18)] = inst_41915__$1);

(statearr_42232[(28)] = inst_41914);

return statearr_42232;
})();
if(cljs.core.truth_(inst_41915__$1)){
var statearr_42233_42418 = state_42124__$1;
(statearr_42233_42418[(1)] = (38));

} else {
var statearr_42234_42419 = state_42124__$1;
(statearr_42234_42419[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (17))){
var inst_41840 = (state_42124[(15)]);
var inst_41872 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_41840,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42235_42420 = state_42124__$1;
(statearr_42235_42420[(2)] = inst_41872);

(statearr_42235_42420[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (3))){
var inst_42122 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42124__$1,inst_42122);
} else {
if((state_val_42125 === (12))){
var inst_41856 = (state_42124[(31)]);
var state_42124__$1 = state_42124;
var statearr_42236_42421 = state_42124__$1;
(statearr_42236_42421[(2)] = inst_41856);

(statearr_42236_42421[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (2))){
var _ = (function (){var statearr_42237 = state_42124;
(statearr_42237[(4)] = cljs.core.cons((5),(state_42124[(4)])));

return statearr_42237;
})();
var inst_41832 = pred_changes;
var inst_41833 = cljs.core.seq(inst_41832);
var inst_41834 = cljs.core.first(inst_41833);
var inst_41835 = cljs.core.next(inst_41833);
var inst_41836 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41834,(0),null);
var inst_41837 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41834,(1),null);
var inst_41838 = db;
var inst_41839 = inst_41832;
var inst_41840 = inst_41838;
var state_42124__$1 = (function (){var statearr_42238 = state_42124;
(statearr_42238[(32)] = inst_41837);

(statearr_42238[(33)] = inst_41836);

(statearr_42238[(15)] = inst_41840);

(statearr_42238[(34)] = inst_41835);

(statearr_42238[(21)] = inst_41839);

return statearr_42238;
})();
var statearr_42239_42422 = state_42124__$1;
(statearr_42239_42422[(2)] = null);

(statearr_42239_42422[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (66))){
var inst_41983 = (state_42124[(8)]);
var inst_41852 = (state_42124[(10)]);
var inst_41984 = (state_42124[(9)]);
var inst_41981 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41982 = cljs.core.__destructure_map(inst_41981);
var inst_41983__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41982,cljs.core.cst$kw$old);
var inst_41984__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41982,cljs.core.cst$kw$new);
var inst_41985 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41984__$1,inst_41983__$1);
var state_42124__$1 = (function (){var statearr_42240 = state_42124;
(statearr_42240[(8)] = inst_41983__$1);

(statearr_42240[(9)] = inst_41984__$1);

return statearr_42240;
})();
if(inst_41985){
var statearr_42241_42423 = state_42124__$1;
(statearr_42241_42423[(1)] = (69));

} else {
var statearr_42242_42424 = state_42124__$1;
(statearr_42242_42424[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (107))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42066 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42243_42425 = state_42124__$1;
(statearr_42243_42425[(2)] = inst_42066);

(statearr_42243_42425[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (23))){
var inst_41852 = (state_42124[(10)]);
var inst_41881 = (state_42124[(17)]);
var inst_41880 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41881__$1 = inst_41880 === true;
var state_42124__$1 = (function (){var statearr_42244 = state_42124;
(statearr_42244[(17)] = inst_41881__$1);

return statearr_42244;
})();
if(cljs.core.truth_(inst_41881__$1)){
var statearr_42245_42426 = state_42124__$1;
(statearr_42245_42426[(1)] = (26));

} else {
var statearr_42246_42427 = state_42124__$1;
(statearr_42246_42427[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (47))){
var inst_41937 = (state_42124[(30)]);
var inst_41852 = (state_42124[(10)]);
var inst_41936 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41937__$1 = cljs.core.not(inst_41936);
var state_42124__$1 = (function (){var statearr_42247 = state_42124;
(statearr_42247[(30)] = inst_41937__$1);

return statearr_42247;
})();
if(inst_41937__$1){
var statearr_42248_42428 = state_42124__$1;
(statearr_42248_42428[(1)] = (50));

} else {
var statearr_42249_42429 = state_42124__$1;
(statearr_42249_42429[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (35))){
var inst_41904 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41905 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_41906 = cljs.core.PersistentHashMap.fromArrays(inst_41904,inst_41905);
var inst_41907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_41906);
var inst_41908 = (function(){throw inst_41907})();
var state_42124__$1 = state_42124;
var statearr_42250_42430 = state_42124__$1;
(statearr_42250_42430[(2)] = inst_41908);

(statearr_42250_42430[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (82))){
var inst_42004 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42251_42431 = state_42124__$1;
(statearr_42251_42431[(2)] = inst_42004);

(statearr_42251_42431[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (76))){
var state_42124__$1 = state_42124;
var statearr_42252_42432 = state_42124__$1;
(statearr_42252_42432[(2)] = null);

(statearr_42252_42432[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (97))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42042 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42253_42433 = state_42124__$1;
(statearr_42253_42433[(2)] = inst_42042);

(statearr_42253_42433[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (19))){
var inst_41876 = (state_42124[(24)]);
var inst_41852 = (state_42124[(10)]);
var inst_41875 = (state_42124[(2)]);
var inst_41876__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42254 = state_42124;
(statearr_42254[(24)] = inst_41876__$1);

(statearr_42254[(26)] = inst_41875);

return statearr_42254;
})();
if(cljs.core.truth_(inst_41876__$1)){
var statearr_42255_42434 = state_42124__$1;
(statearr_42255_42434[(1)] = (20));

} else {
var statearr_42256_42435 = state_42124__$1;
(statearr_42256_42435[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (57))){
var state_42124__$1 = state_42124;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_42257_42436 = state_42124__$1;
(statearr_42257_42436[(1)] = (60));

} else {
var statearr_42258_42437 = state_42124__$1;
(statearr_42258_42437[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (68))){
var inst_41852 = (state_42124[(10)]);
var inst_42081 = (state_42124[(27)]);
var inst_42079 = (state_42124[(2)]);
var inst_42080 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_42081__$1 = inst_42080 === true;
var state_42124__$1 = (function (){var statearr_42259 = state_42124;
(statearr_42259[(7)] = inst_42079);

(statearr_42259[(27)] = inst_42081__$1);

return statearr_42259;
})();
if(cljs.core.truth_(inst_42081__$1)){
var statearr_42260_42438 = state_42124__$1;
(statearr_42260_42438[(1)] = (108));

} else {
var statearr_42261_42439 = state_42124__$1;
(statearr_42261_42439[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (11))){
var inst_41860 = (state_42124[(23)]);
var inst_41852 = (state_42124[(10)]);
var inst_41858 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41859 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41858);
var inst_41860__$1 = inst_41859 === false;
var state_42124__$1 = (function (){var statearr_42262 = state_42124;
(statearr_42262[(23)] = inst_41860__$1);

return statearr_42262;
})();
if(cljs.core.truth_(inst_41860__$1)){
var statearr_42263_42440 = state_42124__$1;
(statearr_42263_42440[(1)] = (14));

} else {
var statearr_42264_42441 = state_42124__$1;
(statearr_42264_42441[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (115))){
var inst_42087 = (state_42124[(29)]);
var state_42124__$1 = state_42124;
var statearr_42266_42442 = state_42124__$1;
(statearr_42266_42442[(2)] = inst_42087);

(statearr_42266_42442[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (9))){
var inst_41856 = (state_42124[(31)]);
var inst_41852 = (state_42124[(10)]);
var inst_41856__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41852);
var state_42124__$1 = (function (){var statearr_42267 = state_42124;
(statearr_42267[(31)] = inst_41856__$1);

return statearr_42267;
})();
if(cljs.core.truth_(inst_41856__$1)){
var statearr_42268_42443 = state_42124__$1;
(statearr_42268_42443[(1)] = (11));

} else {
var statearr_42269_42444 = state_42124__$1;
(statearr_42269_42444[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (5))){
var _ = (function (){var statearr_42270 = state_42124;
(statearr_42270[(4)] = cljs.core.rest((state_42124[(4)])));

return statearr_42270;
})();
var state_42124__$1 = state_42124;
var ex42265 = (state_42124__$1[(2)]);
var statearr_42271_42445 = state_42124__$1;
(statearr_42271_42445[(5)] = ex42265);


if((ex42265 instanceof Error)){
var statearr_42272_42446 = state_42124__$1;
(statearr_42272_42446[(1)] = (4));

(statearr_42272_42446[(5)] = null);

} else {
throw ex42265;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (112))){
var inst_42083 = (state_42124[(25)]);
var state_42124__$1 = state_42124;
var statearr_42273_42447 = state_42124__$1;
(statearr_42273_42447[(2)] = inst_42083);

(statearr_42273_42447[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (83))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42006 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_42007 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_42006,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,3,inst_42006,null));
var inst_42008 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42007,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42007,null));
var inst_42009 = (inst_42008.cljs$core$IFn$_invoke$arity$1 ? inst_42008.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42008.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42009)){
var statearr_42274_42448 = state_42124__$1;
(statearr_42274_42448[(1)] = (84));

} else {
var statearr_42275_42449 = state_42124__$1;
(statearr_42275_42449[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (14))){
var inst_41852 = (state_42124[(10)]);
var inst_41862 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41863 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_41862);
var inst_41864 = inst_41863 === true;
var state_42124__$1 = state_42124;
var statearr_42276_42450 = state_42124__$1;
(statearr_42276_42450[(2)] = inst_41864);

(statearr_42276_42450[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (45))){
var inst_41914 = (state_42124[(28)]);
var state_42124__$1 = state_42124;
var statearr_42277_42451 = state_42124__$1;
(statearr_42277_42451[(2)] = inst_41914);

(statearr_42277_42451[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (53))){
var inst_41840 = (state_42124[(15)]);
var inst_41851 = (state_42124[(16)]);
var inst_41943 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_41840,inst_41851);
var state_42124__$1 = state_42124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42124__$1,(56),inst_41943);
} else {
if((state_val_42125 === (78))){
var inst_42069 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42278_42452 = state_42124__$1;
(statearr_42278_42452[(2)] = inst_42069);

(statearr_42278_42452[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (26))){
var inst_41852 = (state_42124[(10)]);
var inst_41885 = (state_42124[(35)]);
var inst_41883 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41884 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_41883);
var inst_41885__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_41884);
var state_42124__$1 = (function (){var statearr_42279 = state_42124;
(statearr_42279[(35)] = inst_41885__$1);

return statearr_42279;
})();
if(inst_41885__$1){
var statearr_42280_42453 = state_42124__$1;
(statearr_42280_42453[(1)] = (29));

} else {
var statearr_42281_42454 = state_42124__$1;
(statearr_42281_42454[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (16))){
var inst_41867 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42282_42455 = state_42124__$1;
(statearr_42282_42455[(2)] = inst_41867);

(statearr_42282_42455[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (81))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42002 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42283_42456 = state_42124__$1;
(statearr_42283_42456[(2)] = inst_42002);

(statearr_42283_42456[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (120))){
var inst_42104 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42105 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_42106 = cljs.core.PersistentHashMap.fromArrays(inst_42104,inst_42105);
var inst_42107 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_42106);
var inst_42108 = (function(){throw inst_42107})();
var state_42124__$1 = state_42124;
var statearr_42284_42457 = state_42124__$1;
(statearr_42284_42457[(2)] = inst_42108);

(statearr_42284_42457[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (79))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_41996 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_41997 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_41996,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,2,inst_41996,null));
var inst_41998 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_41997,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_41997,null));
var inst_41999 = (inst_41998.cljs$core$IFn$_invoke$arity$1 ? inst_41998.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_41998.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41999)){
var statearr_42285_42458 = state_42124__$1;
(statearr_42285_42458[(1)] = (80));

} else {
var statearr_42286_42459 = state_42124__$1;
(statearr_42286_42459[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (38))){
var inst_41918 = (state_42124[(36)]);
var inst_41852 = (state_42124[(10)]);
var inst_41917 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41918__$1 = cljs.core.not(inst_41917);
var state_42124__$1 = (function (){var statearr_42287 = state_42124;
(statearr_42287[(36)] = inst_41918__$1);

return statearr_42287;
})();
if(inst_41918__$1){
var statearr_42288_42460 = state_42124__$1;
(statearr_42288_42460[(1)] = (41));

} else {
var statearr_42289_42461 = state_42124__$1;
(statearr_42289_42461[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (98))){
var inst_42044 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42290_42462 = state_42124__$1;
(statearr_42290_42462[(2)] = inst_42044);

(statearr_42290_42462[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (87))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42016 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_42017 = (inst_41984.cljs$core$IFn$_invoke$arity$5 ? inst_41984.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_42016,null) : inst_41984.call(null,cljs.core.PersistentArrayMap,null,3,inst_42016,null));
var inst_42018 = (inst_41984.cljs$core$IFn$_invoke$arity$4 ? inst_41984.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_42017,null) : inst_41984.call(null,cljs.core.PersistentHashSet,null,inst_42017,null));
var inst_42019 = (inst_42018.cljs$core$IFn$_invoke$arity$1 ? inst_42018.cljs$core$IFn$_invoke$arity$1(inst_41983) : inst_42018.call(null,inst_41983));
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_42019)){
var statearr_42291_42463 = state_42124__$1;
(statearr_42291_42463[(1)] = (88));

} else {
var statearr_42292_42464 = state_42124__$1;
(statearr_42292_42464[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (30))){
var inst_41885 = (state_42124[(35)]);
var state_42124__$1 = state_42124;
var statearr_42293_42465 = state_42124__$1;
(statearr_42293_42465[(2)] = inst_41885);

(statearr_42293_42465[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (73))){
var state_42124__$1 = state_42124;
var statearr_42294_42466 = state_42124__$1;
(statearr_42294_42466[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (96))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42296_42467 = state_42124__$1;
(statearr_42296_42467[(2)] = inst_41971);

(statearr_42296_42467[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (10))){
var inst_42117 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42297_42468 = state_42124__$1;
(statearr_42297_42468[(2)] = inst_42117);

(statearr_42297_42468[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (18))){
var inst_41840 = (state_42124[(15)]);
var state_42124__$1 = state_42124;
var statearr_42298_42469 = state_42124__$1;
(statearr_42298_42469[(2)] = inst_41840);

(statearr_42298_42469[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (105))){
var inst_41983 = (state_42124[(8)]);
var inst_41984 = (state_42124[(9)]);
var inst_42062 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_41983,inst_41984,throw_QMARK_);
var state_42124__$1 = state_42124;
var statearr_42299_42470 = state_42124__$1;
(statearr_42299_42470[(2)] = inst_42062);

(statearr_42299_42470[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (52))){
var inst_41953 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42300_42471 = state_42124__$1;
(statearr_42300_42471[(2)] = inst_41953);

(statearr_42300_42471[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (114))){
var inst_41852 = (state_42124[(10)]);
var inst_42089 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_42090 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_42089);
var inst_42091 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_42090);
var inst_42092 = (!(inst_42091));
var state_42124__$1 = state_42124;
var statearr_42301_42472 = state_42124__$1;
(statearr_42301_42472[(2)] = inst_42092);

(statearr_42301_42472[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (67))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42302_42473 = state_42124__$1;
(statearr_42302_42473[(2)] = inst_41971);

(statearr_42302_42473[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (71))){
var inst_42076 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42303_42474 = state_42124__$1;
(statearr_42303_42474[(2)] = inst_42076);

(statearr_42303_42474[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (42))){
var inst_41918 = (state_42124[(36)]);
var state_42124__$1 = state_42124;
var statearr_42304_42475 = state_42124__$1;
(statearr_42304_42475[(2)] = inst_41918);

(statearr_42304_42475[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (80))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42305_42476 = state_42124__$1;
(statearr_42305_42476[(2)] = inst_41971);

(statearr_42305_42476[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (37))){
var inst_41911 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42306_42477 = state_42124__$1;
(statearr_42306_42477[(2)] = inst_41911);

(statearr_42306_42477[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (63))){
var inst_41852 = (state_42124[(10)]);
var inst_41974 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_41852);
var inst_41975 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_41974);
var state_42124__$1 = state_42124;
var statearr_42307_42478 = state_42124__$1;
(statearr_42307_42478[(2)] = inst_41975);

(statearr_42307_42478[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (94))){
var inst_42034 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
var statearr_42308_42479 = state_42124__$1;
(statearr_42308_42479[(2)] = inst_42034);

(statearr_42308_42479[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (8))){
var inst_41840 = (state_42124[(15)]);
var state_42124__$1 = state_42124;
var statearr_42309_42480 = state_42124__$1;
(statearr_42309_42480[(2)] = inst_41840);

(statearr_42309_42480[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (49))){
var inst_41956 = (state_42124[(2)]);
var state_42124__$1 = state_42124;
if(cljs.core.truth_(inst_41956)){
var statearr_42310_42481 = state_42124__$1;
(statearr_42310_42481[(1)] = (57));

} else {
var statearr_42311_42482 = state_42124__$1;
(statearr_42311_42482[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42125 === (84))){
var inst_41971 = (state_42124[(12)]);
var state_42124__$1 = state_42124;
var statearr_42312_42483 = state_42124__$1;
(statearr_42312_42483[(2)] = inst_41971);

(statearr_42312_42483[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__24298__auto__ = null;
var fluree$db$query$schema$state_machine__24298__auto____0 = (function (){
var statearr_42313 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42313[(0)] = fluree$db$query$schema$state_machine__24298__auto__);

(statearr_42313[(1)] = (1));

return statearr_42313;
});
var fluree$db$query$schema$state_machine__24298__auto____1 = (function (state_42124){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42124);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42314){var ex__24301__auto__ = e42314;
var statearr_42315_42484 = state_42124;
(statearr_42315_42484[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42124[(4)]))){
var statearr_42316_42485 = state_42124;
(statearr_42316_42485[(1)] = cljs.core.first((state_42124[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42486 = state_42124;
state_42124 = G__42486;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__24298__auto__ = function(state_42124){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__24298__auto____1.call(this,state_42124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__24298__auto____0;
fluree$db$query$schema$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__24298__auto____1;
return fluree$db$query$schema$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42317 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42317[(6)] = c__24424__auto__);

return statearr_42317;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__42488 = arguments.length;
switch (G__42488) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42512){
var state_val_42513 = (state_42512[(1)]);
if((state_val_42513 === (7))){
var state_42512__$1 = state_42512;
var statearr_42514_42534 = state_42512__$1;
(statearr_42514_42534[(2)] = db);

(statearr_42514_42534[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (1))){
var state_42512__$1 = state_42512;
var statearr_42515_42535 = state_42512__$1;
(statearr_42515_42535[(2)] = null);

(statearr_42515_42535[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (4))){
var inst_42489 = (state_42512[(2)]);
var state_42512__$1 = state_42512;
var statearr_42516_42536 = state_42512__$1;
(statearr_42516_42536[(2)] = inst_42489);

(statearr_42516_42536[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (6))){
var inst_42498 = (state_42512[(7)]);
var inst_42497 = (state_42512[(2)]);
var inst_42498__$1 = fluree.db.util.async.throw_err(inst_42497);
var inst_42499 = cljs.core.empty_QMARK_(inst_42498__$1);
var state_42512__$1 = (function (){var statearr_42517 = state_42512;
(statearr_42517[(7)] = inst_42498__$1);

return statearr_42517;
})();
if(inst_42499){
var statearr_42518_42537 = state_42512__$1;
(statearr_42518_42537[(1)] = (7));

} else {
var statearr_42519_42538 = state_42512__$1;
(statearr_42519_42538[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (3))){
var inst_42510 = (state_42512[(2)]);
var state_42512__$1 = state_42512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42512__$1,inst_42510);
} else {
if((state_val_42513 === (2))){
var _ = (function (){var statearr_42521 = state_42512;
(statearr_42521[(4)] = cljs.core.cons((5),(state_42512[(4)])));

return statearr_42521;
})();
var inst_42495 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_42512__$1 = state_42512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42512__$1,(6),inst_42495);
} else {
if((state_val_42513 === (9))){
var inst_42507 = (state_42512[(2)]);
var _ = (function (){var statearr_42522 = state_42512;
(statearr_42522[(4)] = cljs.core.rest((state_42512[(4)])));

return statearr_42522;
})();
var state_42512__$1 = state_42512;
var statearr_42523_42539 = state_42512__$1;
(statearr_42523_42539[(2)] = inst_42507);

(statearr_42523_42539[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (5))){
var _ = (function (){var statearr_42524 = state_42512;
(statearr_42524[(4)] = cljs.core.rest((state_42512[(4)])));

return statearr_42524;
})();
var state_42512__$1 = state_42512;
var ex42520 = (state_42512__$1[(2)]);
var statearr_42525_42540 = state_42512__$1;
(statearr_42525_42540[(5)] = ex42520);


if((ex42520 instanceof Error)){
var statearr_42526_42541 = state_42512__$1;
(statearr_42526_42541[(1)] = (4));

(statearr_42526_42541[(5)] = null);

} else {
throw ex42520;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (10))){
var inst_42504 = (state_42512[(2)]);
var inst_42505 = fluree.db.util.async.throw_err(inst_42504);
var state_42512__$1 = state_42512;
var statearr_42527_42542 = state_42512__$1;
(statearr_42527_42542[(2)] = inst_42505);

(statearr_42527_42542[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42513 === (8))){
var inst_42498 = (state_42512[(7)]);
var inst_42502 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_42498,db,true);
var state_42512__$1 = state_42512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42512__$1,(10),inst_42502);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__24298__auto__ = null;
var fluree$db$query$schema$state_machine__24298__auto____0 = (function (){
var statearr_42528 = [null,null,null,null,null,null,null,null];
(statearr_42528[(0)] = fluree$db$query$schema$state_machine__24298__auto__);

(statearr_42528[(1)] = (1));

return statearr_42528;
});
var fluree$db$query$schema$state_machine__24298__auto____1 = (function (state_42512){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42512);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42529){var ex__24301__auto__ = e42529;
var statearr_42530_42543 = state_42512;
(statearr_42530_42543[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42512[(4)]))){
var statearr_42531_42544 = state_42512;
(statearr_42531_42544[(1)] = cljs.core.first((state_42512[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42545 = state_42512;
state_42512 = G__42545;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__24298__auto__ = function(state_42512){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__24298__auto____1.call(this,state_42512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__24298__auto____0;
fluree$db$query$schema$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__24298__auto____1;
return fluree$db$query$schema$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42532 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42532[(6)] = c__24424__auto__);

return statearr_42532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__42547 = arguments.length;
switch (G__42547) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__42549 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42549,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42549,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42549,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__42552_SHARP_,p2__42553_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__42552_SHARP_,p2__42553_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__42554_SHARP_){
var f = p1__42554_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42620){
var state_val_42621 = (state_42620[(1)]);
if((state_val_42621 === (1))){
var state_42620__$1 = state_42620;
var statearr_42622_42640 = state_42620__$1;
(statearr_42622_42640[(2)] = null);

(statearr_42622_42640[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42621 === (2))){
var _ = (function (){var statearr_42623 = state_42620;
(statearr_42623[(4)] = cljs.core.cons((5),(state_42620[(4)])));

return statearr_42623;
})();
var inst_42572 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42573 = fluree.db.flake.max_subject_id((1));
var inst_42574 = [inst_42573];
var inst_42575 = (new cljs.core.PersistentVector(null,1,(5),inst_42572,inst_42574,null));
var inst_42576 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42577 = [(0)];
var inst_42578 = (new cljs.core.PersistentVector(null,1,(5),inst_42576,inst_42577,null));
var inst_42579 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_42575,cljs.core._LT__EQ_,inst_42578);
var state_42620__$1 = state_42620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42620__$1,(6),inst_42579);
} else {
if((state_val_42621 === (3))){
var inst_42618 = (state_42620[(2)]);
var state_42620__$1 = state_42620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42620__$1,inst_42618);
} else {
if((state_val_42621 === (4))){
var inst_42560 = (state_42620[(2)]);
var state_42620__$1 = state_42620;
var statearr_42625_42641 = state_42620__$1;
(statearr_42625_42641[(2)] = inst_42560);

(statearr_42625_42641[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42621 === (5))){
var _ = (function (){var statearr_42626 = state_42620;
(statearr_42626[(4)] = cljs.core.rest((state_42620[(4)])));

return statearr_42626;
})();
var state_42620__$1 = state_42620;
var ex42624 = (state_42620__$1[(2)]);
var statearr_42627_42642 = state_42620__$1;
(statearr_42627_42642[(5)] = ex42624);


if((ex42624 instanceof Error)){
var statearr_42628_42643 = state_42620__$1;
(statearr_42628_42643[(1)] = (4));

(statearr_42628_42643[(5)] = null);

} else {
throw ex42624;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42621 === (6))){
var inst_42581 = (state_42620[(2)]);
var inst_42582 = fluree.db.util.async.throw_err(inst_42581);
var inst_42583 = (function (){var schema_flakes = inst_42582;
return (function (p1__42555_SHARP_){
return (p1__42555_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_42584 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42583,inst_42582);
var inst_42585 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42584,(0),null);
var inst_42586 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42584,(1),null);
var inst_42587 = (function (){var schema_flakes = inst_42582;
var vec__42566 = inst_42584;
var collection_flakes = inst_42585;
var predicate_flakes = inst_42586;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__42558_SHARP_,p2__42557_SHARP_){
var f = p2__42557_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__42558_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_42588 = [(-1),"_tx"];
var inst_42589 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_42590 = ["_tx",(-1),(-1),(-1),null,null];
var inst_42591 = cljs.core.PersistentHashMap.fromArrays(inst_42589,inst_42590);
var inst_42592 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_42593 = ["_tx",(-1),(-1),(-1),null,null];
var inst_42594 = cljs.core.PersistentHashMap.fromArrays(inst_42592,inst_42593);
var inst_42595 = [inst_42591,inst_42594];
var inst_42596 = cljs.core.PersistentHashMap.fromArrays(inst_42588,inst_42595);
var inst_42597 = (function (){var schema_flakes = inst_42582;
var vec__42566 = inst_42584;
var collection_flakes = inst_42585;
var predicate_flakes = inst_42586;
return (function (p1__42556_SHARP_){
return p1__42556_SHARP_.s;
});
})();
var inst_42598 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42597,inst_42585);
var inst_42599 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42587,inst_42596,inst_42598);
var inst_42601 = (function (){var schema_flakes = inst_42582;
var vec__42566 = inst_42584;
var collection_flakes = inst_42585;
var predicate_flakes = inst_42586;
var coll = inst_42599;
return (function (p__42600,pred_flakes){
var vec__42629 = p__42600;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42629,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42629,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__42632 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__42632.cljs$core$IFn$_invoke$arity$1 ? fexpr__42632.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__42632.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_42602 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42603 = cljs.core.PersistentHashMap.EMPTY;
var inst_42604 = cljs.core.PersistentHashSet.EMPTY;
var inst_42605 = [inst_42603,inst_42604];
var inst_42606 = (new cljs.core.PersistentVector(null,2,(5),inst_42602,inst_42605,null));
var inst_42607 = (function (){var schema_flakes = inst_42582;
var vec__42566 = inst_42584;
var collection_flakes = inst_42585;
var predicate_flakes = inst_42586;
var coll = inst_42599;
return (function (p1__42559_SHARP_){
return p1__42559_SHARP_.s;
});
})();
var inst_42608 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_42607,inst_42586);
var inst_42609 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42601,inst_42606,inst_42608);
var inst_42610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42609,(0),null);
var inst_42611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_42609,(1),null);
var inst_42612 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_42613 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42614 = [inst_42613,inst_42599,inst_42610,inst_42611];
var inst_42615 = cljs.core.PersistentHashMap.fromArrays(inst_42612,inst_42614);
var _ = (function (){var statearr_42633 = state_42620;
(statearr_42633[(4)] = cljs.core.rest((state_42620[(4)])));

return statearr_42633;
})();
var state_42620__$1 = state_42620;
var statearr_42634_42644 = state_42620__$1;
(statearr_42634_42644[(2)] = inst_42615);

(statearr_42634_42644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__24298__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__24298__auto____0 = (function (){
var statearr_42635 = [null,null,null,null,null,null,null];
(statearr_42635[(0)] = fluree$db$query$schema$schema_map_$_state_machine__24298__auto__);

(statearr_42635[(1)] = (1));

return statearr_42635;
});
var fluree$db$query$schema$schema_map_$_state_machine__24298__auto____1 = (function (state_42620){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42620);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42636){var ex__24301__auto__ = e42636;
var statearr_42637_42645 = state_42620;
(statearr_42637_42645[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42620[(4)]))){
var statearr_42638_42646 = state_42620;
(statearr_42638_42646[(1)] = cljs.core.first((state_42620[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42647 = state_42620;
state_42620 = G__42647;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__24298__auto__ = function(state_42620){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__24298__auto____1.call(this,state_42620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__24298__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__24298__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42639 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42639[(6)] = c__24424__auto__);

return statearr_42639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_42689){
var state_val_42690 = (state_42689[(1)]);
if((state_val_42690 === (7))){
var inst_42672 = (state_42689[(2)]);
var inst_42673 = fluree.db.query.schema.flake__GT_pred_map(inst_42672);
var inst_42674 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_42675 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(114));
var inst_42676 = cljs.core.boolean$(inst_42675);
var inst_42677 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(110));
var inst_42678 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(117));
var inst_42679 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_42678);
var inst_42680 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(111));
var inst_42681 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(115));
var inst_42682 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42673,(112));
var inst_42683 = [inst_42676,inst_42677,inst_42679,inst_42680,inst_42681,inst_42682];
var inst_42684 = cljs.core.PersistentHashMap.fromArrays(inst_42674,inst_42683);
var _ = (function (){var statearr_42691 = state_42689;
(statearr_42691[(4)] = cljs.core.rest((state_42689[(4)])));

return statearr_42691;
})();
var state_42689__$1 = state_42689;
var statearr_42692_42715 = state_42689__$1;
(statearr_42692_42715[(2)] = inst_42684);

(statearr_42692_42715[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (1))){
var state_42689__$1 = state_42689;
var statearr_42693_42716 = state_42689__$1;
(statearr_42693_42716[(2)] = null);

(statearr_42693_42716[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (4))){
var inst_42648 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
var statearr_42694_42717 = state_42689__$1;
(statearr_42694_42717[(2)] = inst_42648);

(statearr_42694_42717[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (6))){
var _ = (function (){var statearr_42695 = state_42689;
(statearr_42695[(4)] = cljs.core.cons((9),(state_42689[(4)])));

return statearr_42695;
})();
var inst_42660 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42662 = ["_setting/id","root"];
var inst_42663 = (new cljs.core.PersistentVector(null,2,(5),inst_42661,inst_42662,null));
var inst_42664 = [inst_42663];
var inst_42665 = (new cljs.core.PersistentVector(null,1,(5),inst_42660,inst_42664,null));
var inst_42666 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42665);
var state_42689__$1 = state_42689;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42689__$1,(10),inst_42666);
} else {
if((state_val_42690 === (3))){
var inst_42687 = (state_42689[(2)]);
var state_42689__$1 = state_42689;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42689__$1,inst_42687);
} else {
if((state_val_42690 === (2))){
var _ = (function (){var statearr_42698 = state_42689;
(statearr_42698[(4)] = cljs.core.cons((5),(state_42689[(4)])));

return statearr_42698;
})();
var state_42689__$1 = state_42689;
var statearr_42699_42718 = state_42689__$1;
(statearr_42699_42718[(2)] = null);

(statearr_42699_42718[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (9))){
var _ = (function (){var statearr_42700 = state_42689;
(statearr_42700[(4)] = cljs.core.rest((state_42689[(4)])));

return statearr_42700;
})();
var state_42689__$1 = state_42689;
var ex42696 = (state_42689__$1[(2)]);
var statearr_42701_42719 = state_42689__$1;
(statearr_42701_42719[(5)] = ex42696);


var statearr_42702_42720 = state_42689__$1;
(statearr_42702_42720[(1)] = (8));

(statearr_42702_42720[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (5))){
var _ = (function (){var statearr_42703 = state_42689;
(statearr_42703[(4)] = cljs.core.rest((state_42689[(4)])));

return statearr_42703;
})();
var state_42689__$1 = state_42689;
var ex42697 = (state_42689__$1[(2)]);
var statearr_42704_42721 = state_42689__$1;
(statearr_42704_42721[(5)] = ex42697);


if((ex42697 instanceof Error)){
var statearr_42705_42722 = state_42689__$1;
(statearr_42705_42722[(1)] = (4));

(statearr_42705_42722[(5)] = null);

} else {
throw ex42697;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (10))){
var inst_42668 = (state_42689[(2)]);
var inst_42669 = fluree.db.util.async.throw_err(inst_42668);
var _ = (function (){var statearr_42706 = state_42689;
(statearr_42706[(4)] = cljs.core.rest((state_42689[(4)])));

return statearr_42706;
})();
var state_42689__$1 = state_42689;
var statearr_42707_42723 = state_42689__$1;
(statearr_42707_42723[(2)] = inst_42669);

(statearr_42707_42723[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42690 === (8))){
var inst_42654 = (state_42689[(2)]);
var state_42689__$1 = (function (){var statearr_42708 = state_42689;
(statearr_42708[(7)] = inst_42654);

return statearr_42708;
})();
var statearr_42709_42724 = state_42689__$1;
(statearr_42709_42724[(2)] = null);

(statearr_42709_42724[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__24298__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__24298__auto____0 = (function (){
var statearr_42710 = [null,null,null,null,null,null,null,null];
(statearr_42710[(0)] = fluree$db$query$schema$setting_map_$_state_machine__24298__auto__);

(statearr_42710[(1)] = (1));

return statearr_42710;
});
var fluree$db$query$schema$setting_map_$_state_machine__24298__auto____1 = (function (state_42689){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_42689);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e42711){var ex__24301__auto__ = e42711;
var statearr_42712_42725 = state_42689;
(statearr_42712_42725[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_42689[(4)]))){
var statearr_42713_42726 = state_42689;
(statearr_42713_42726[(1)] = cljs.core.first((state_42689[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__42727 = state_42689;
state_42689 = G__42727;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__24298__auto__ = function(state_42689){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__24298__auto____1.call(this,state_42689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__24298__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__24298__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_42714 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_42714[(6)] = c__24424__auto__);

return statearr_42714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
