// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.session');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.graphdb');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.cache');
goog.require('clojure.string');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.operations');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.conn_events');



/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.session.DbSession = (function (conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.db_name = db_name;
this.update_chan = update_chan;
this.transact_chan = transact_chan;
this.state = state;
this.schema_cache = schema_cache;
this.blank_db = blank_db;
this.close = close;
this.id = id;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.session.DbSession.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k53926,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__53930 = k53926;
var G__53930__$1 = (((G__53930 instanceof cljs.core.Keyword))?G__53930.fqn:null);
switch (G__53930__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "db-name":
return self__.db_name;

break;
case "update-chan":
return self__.update_chan;

break;
case "transact-chan":
return self__.transact_chan;

break;
case "state":
return self__.state;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "blank-db":
return self__.blank_db;

break;
case "close":
return self__.close;

break;
case "id":
return self__.id;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k53926,else__4464__auto__);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__53931){
var vec__53932 = p__53931;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53932,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__53932,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.session.DbSession.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.session.DbSession{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$db_DASH_name,self__.db_name],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$update_DASH_chan,self__.update_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$blank_DASH_db,self__.blank_db],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__53925){
var self__ = this;
var G__53925__$1 = this;
return (new cljs.core.RecordIter((0),G__53925__$1,11,new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (11 + cljs.core.count(self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__53935 = (function (coll__4458__auto__){
return (1635626254 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__53935(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this53927,other53928){
var self__ = this;
var this53927__$1 = this;
return (((!((other53928 == null)))) && ((((this53927__$1.constructor === other53928.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.conn,other53928.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.network,other53928.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.dbid,other53928.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.db_name,other53928.db_name)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.update_chan,other53928.update_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.transact_chan,other53928.transact_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.state,other53928.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.schema_cache,other53928.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.blank_db,other53928.blank_db)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.close,other53928.close)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.id,other53928.id)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this53927__$1.__extmap,other53928.__extmap)))))))))))))))))))))))))));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$update_DASH_chan,null,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$transact_DASH_chan,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$blank_DASH_db,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k53926){
var self__ = this;
var this__4468__auto____$1 = this;
var G__53936 = k53926;
var G__53936__$1 = (((G__53936 instanceof cljs.core.Keyword))?G__53936.fqn:null);
switch (G__53936__$1) {
case "conn":
case "network":
case "dbid":
case "db-name":
case "update-chan":
case "transact-chan":
case "state":
case "schema-cache":
case "blank-db":
case "close":
case "id":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k53926);

}
}));

(fluree.db.session.DbSession.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__53925){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__53937 = cljs.core.keyword_identical_QMARK_;
var expr__53938 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__53940 = cljs.core.cst$kw$conn;
var G__53941 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53940,G__53941) : pred__53937.call(null,G__53940,G__53941));
})())){
return (new fluree.db.session.DbSession(G__53925,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53942 = cljs.core.cst$kw$network;
var G__53943 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53942,G__53943) : pred__53937.call(null,G__53942,G__53943));
})())){
return (new fluree.db.session.DbSession(self__.conn,G__53925,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53944 = cljs.core.cst$kw$dbid;
var G__53945 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53944,G__53945) : pred__53937.call(null,G__53944,G__53945));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,G__53925,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53946 = cljs.core.cst$kw$db_DASH_name;
var G__53947 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53946,G__53947) : pred__53937.call(null,G__53946,G__53947));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,G__53925,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53948 = cljs.core.cst$kw$update_DASH_chan;
var G__53949 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53948,G__53949) : pred__53937.call(null,G__53948,G__53949));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,G__53925,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53950 = cljs.core.cst$kw$transact_DASH_chan;
var G__53951 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53950,G__53951) : pred__53937.call(null,G__53950,G__53951));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,G__53925,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53952 = cljs.core.cst$kw$state;
var G__53953 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53952,G__53953) : pred__53937.call(null,G__53952,G__53953));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,G__53925,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53954 = cljs.core.cst$kw$schema_DASH_cache;
var G__53955 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53954,G__53955) : pred__53937.call(null,G__53954,G__53955));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,G__53925,self__.blank_db,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53956 = cljs.core.cst$kw$blank_DASH_db;
var G__53957 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53956,G__53957) : pred__53937.call(null,G__53956,G__53957));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,G__53925,self__.close,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53958 = cljs.core.cst$kw$close;
var G__53959 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53958,G__53959) : pred__53937.call(null,G__53958,G__53959));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,G__53925,self__.id,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__53960 = cljs.core.cst$kw$id;
var G__53961 = expr__53938;
return (pred__53937.cljs$core$IFn$_invoke$arity$2 ? pred__53937.cljs$core$IFn$_invoke$arity$2(G__53960,G__53961) : pred__53937.call(null,G__53960,G__53961));
})())){
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,G__53925,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__53925),null));
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.session.DbSession.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$db_DASH_name,self__.db_name,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$update_DASH_chan,self__.update_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_chan,self__.transact_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$blank_DASH_db,self__.blank_db,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null))], null),self__.__extmap));
}));

(fluree.db.session.DbSession.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__53925){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.session.DbSession(self__.conn,self__.network,self__.dbid,self__.db_name,self__.update_chan,self__.transact_chan,self__.state,self__.schema_cache,self__.blank_db,self__.close,self__.id,G__53925,self__.__extmap,self__.__hash));
}));

(fluree.db.session.DbSession.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.session.DbSession.getBasis = (function (){
return new cljs.core.PersistentVector(null, 11, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$db_DASH_name,cljs.core.cst$sym$update_DASH_chan,cljs.core.cst$sym$transact_DASH_chan,cljs.core.cst$sym$state,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$blank_DASH_db,cljs.core.cst$sym$close,cljs.core.cst$sym$id], null);
}));

(fluree.db.session.DbSession.cljs$lang$type = true);

(fluree.db.session.DbSession.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.session/DbSession",null,(1),null));
}));

(fluree.db.session.DbSession.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.session/DbSession");
}));

/**
 * Positional factory function for fluree.db.session/DbSession.
 */
fluree.db.session.__GT_DbSession = (function fluree$db$session$__GT_DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id){
return (new fluree.db.session.DbSession(conn,network,dbid,db_name,update_chan,transact_chan,state,schema_cache,blank_db,close,id,null,null,null));
});

/**
 * Factory function for fluree.db.session/DbSession, taking a map of keywords to field values.
 */
fluree.db.session.map__GT_DbSession = (function fluree$db$session$map__GT_DbSession(G__53929){
var extmap__4501__auto__ = (function (){var G__53962 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__53929,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$state,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$close,cljs.core.cst$kw$id], 0));
if(cljs.core.record_QMARK_(G__53929)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__53962);
} else {
return G__53962;
}
})();
return (new fluree.db.session.DbSession(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$db_DASH_name.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__53929),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__53929),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.session.cache_factory = (function fluree$db$session$cache_factory(){
return cljs.core.PersistentArrayMap.EMPTY;
});
fluree.db.session.session_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.session.cache_factory());
/**
 * Only replaces cache if an existing conn is not already present.
 *   Returns the cached connection.
 */
fluree.db.session.cache_BANG_ = (function fluree$db$session$cache_BANG_(session){
var map__53965 = session;
var map__53965__$1 = cljs.core.__destructure_map(map__53965);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53965__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53965__$1,cljs.core.cst$kw$dbid);
var cache_key = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(fluree.db.session.session_cache,(function (c){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(c,cache_key))){
return c;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(c,cache_key,session);
}
}));

return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),cache_key);
});
/**
 * Retrieves session from cache.
 */
fluree.db.session.from_cache = (function fluree$db$session$from_cache(network,dbid){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.session_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Removes a specific session from cache.
 */
fluree.db.session.remove_cache_BANG_ = (function fluree$db$session$remove_cache_BANG_(network,dbid){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.session.session_cache,cljs.core.dissoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Clears entire session cache. Should not be used under normal circumstances as sessions will not be properly closed.
 */
fluree.db.session.reset_cache_BANG_ = (function fluree$db$session$reset_cache_BANG_(){
return cljs.core.reset_BANG_(fluree.db.session.session_cache,fluree.db.session.cache_factory());
});
fluree.db.session.full_load_existing_db = (function fluree$db$session$full_load_existing_db(session){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___54117 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54069){
var state_val_54070 = (state_54069[(1)]);
if((state_val_54070 === (7))){
var inst_53986 = (state_54069[(7)]);
var inst_53991 = cljs.core.empty_QMARK_(inst_53986);
var state_54069__$1 = state_54069;
if(inst_53991){
var statearr_54071_54118 = state_54069__$1;
(statearr_54071_54118[(1)] = (10));

} else {
var statearr_54072_54119 = state_54069__$1;
(statearr_54072_54119[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (20))){
var inst_53979 = (state_54069[(8)]);
var inst_54017 = (state_54069[(9)]);
var inst_53978 = (state_54069[(10)]);
var inst_53977 = (state_54069[(11)]);
var inst_54022 = fluree.db.storage.core.read_block(inst_53977,inst_53978,inst_53979,inst_54017);
var state_54069__$1 = state_54069;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(22),inst_54022);
} else {
if((state_val_54070 === (27))){
var inst_54053 = (state_54069[(12)]);
var inst_54058 = (state_54069[(13)]);
var inst_54056 = (state_54069[(2)]);
var inst_54057 = fluree.db.util.async.throw_err(inst_54056);
var inst_54058__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_54053,cljs.core.cst$kw$schema,inst_54057);
var inst_54059 = fluree.db.query.schema.setting_map(inst_54058__$1);
var state_54069__$1 = (function (){var statearr_54073 = state_54069;
(statearr_54073[(13)] = inst_54058__$1);

return statearr_54073;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(28),inst_54059);
} else {
if((state_val_54070 === (1))){
var state_54069__$1 = state_54069;
var statearr_54074_54120 = state_54069__$1;
(statearr_54074_54120[(2)] = null);

(statearr_54074_54120[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (24))){
var inst_53979 = (state_54069[(8)]);
var inst_54017 = (state_54069[(9)]);
var inst_53978 = (state_54069[(10)]);
var inst_54039 = ["Error reading block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54017)," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53978),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53979),"."].join('');
var inst_54040 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_54041 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_54042 = cljs.core.PersistentHashMap.fromArrays(inst_54040,inst_54041);
var inst_54043 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_54039,inst_54042);
var inst_54044 = (function(){throw inst_54043})();
var state_54069__$1 = state_54069;
var statearr_54075_54121 = state_54069__$1;
(statearr_54075_54121[(2)] = inst_54044);

(statearr_54075_54121[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (4))){
var inst_53966 = (state_54069[(2)]);
var inst_53967 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_53966);
var state_54069__$1 = state_54069;
var statearr_54076_54122 = state_54069__$1;
(statearr_54076_54122[(2)] = inst_53967);

(statearr_54076_54122[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (15))){
var state_54069__$1 = state_54069;
var statearr_54077_54123 = state_54069__$1;
(statearr_54077_54123[(2)] = null);

(statearr_54077_54123[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (21))){
var inst_54048 = (state_54069[(2)]);
var state_54069__$1 = state_54069;
var statearr_54078_54124 = state_54069__$1;
(statearr_54078_54124[(2)] = inst_54048);

(statearr_54078_54124[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (13))){
var inst_54011 = (state_54069[(14)]);
var inst_53986 = (state_54069[(7)]);
var inst_54010 = (state_54069[(2)]);
var inst_54011__$1 = fluree.db.util.async.throw_err(inst_54010);
var inst_54012 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_53986);
var state_54069__$1 = (function (){var statearr_54079 = state_54069;
(statearr_54079[(14)] = inst_54011__$1);

(statearr_54079[(15)] = inst_54012);

return statearr_54079;
})();
if(cljs.core.truth_(inst_54011__$1)){
var statearr_54080_54125 = state_54069__$1;
(statearr_54080_54125[(1)] = (14));

} else {
var statearr_54081_54126 = state_54069__$1;
(statearr_54081_54126[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (22))){
var inst_54025 = (state_54069[(16)]);
var inst_54024 = (state_54069[(2)]);
var inst_54025__$1 = fluree.db.util.async.throw_err(inst_54024);
var state_54069__$1 = (function (){var statearr_54082 = state_54069;
(statearr_54082[(16)] = inst_54025__$1);

return statearr_54082;
})();
if(cljs.core.truth_(inst_54025__$1)){
var statearr_54083_54127 = state_54069__$1;
(statearr_54083_54127[(1)] = (23));

} else {
var statearr_54084_54128 = state_54069__$1;
(statearr_54084_54128[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (6))){
var inst_53986 = (state_54069[(7)]);
var inst_53985 = (state_54069[(2)]);
var inst_53986__$1 = fluree.db.util.async.throw_err(inst_53985);
var inst_53987 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_53986__$1);
var inst_53988 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_53987);
var inst_53989 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ready,inst_53988);
var state_54069__$1 = (function (){var statearr_54085 = state_54069;
(statearr_54085[(7)] = inst_53986__$1);

return statearr_54085;
})();
if(inst_53989){
var statearr_54086_54129 = state_54069__$1;
(statearr_54086_54129[(1)] = (7));

} else {
var statearr_54087_54130 = state_54069__$1;
(statearr_54087_54130[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (28))){
var inst_54058 = (state_54069[(13)]);
var inst_54061 = (state_54069[(2)]);
var inst_54062 = fluree.db.util.async.throw_err(inst_54061);
var inst_54063 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_54058,cljs.core.cst$kw$settings,inst_54062);
var inst_54064 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_54063);
var _ = (function (){var statearr_54088 = state_54069;
(statearr_54088[(4)] = cljs.core.rest((state_54069[(4)])));

return statearr_54088;
})();
var state_54069__$1 = state_54069;
var statearr_54089_54131 = state_54069__$1;
(statearr_54089_54131[(2)] = inst_54064);

(statearr_54089_54131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (25))){
var inst_54046 = (state_54069[(2)]);
var state_54069__$1 = state_54069;
var statearr_54090_54132 = state_54069__$1;
(statearr_54090_54132[(2)] = inst_54046);

(statearr_54090_54132[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (17))){
var inst_54017 = (state_54069[(9)]);
var inst_54012 = (state_54069[(15)]);
var inst_54019 = (inst_54017 > inst_54012);
var state_54069__$1 = state_54069;
if(cljs.core.truth_(inst_54019)){
var statearr_54091_54133 = state_54069__$1;
(statearr_54091_54133[(1)] = (19));

} else {
var statearr_54092_54134 = state_54069__$1;
(statearr_54092_54134[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (3))){
var inst_54067 = (state_54069[(2)]);
var state_54069__$1 = state_54069;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54069__$1,inst_54067);
} else {
if((state_val_54070 === (12))){
var inst_53998 = (state_54069[(2)]);
var inst_53999 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_54000 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_54001 = cljs.core.PersistentHashMap.fromArrays(inst_53999,inst_54000);
var inst_54002 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_53998,inst_54001);
var inst_54003 = (function(){throw inst_54002})();
var state_54069__$1 = state_54069;
var statearr_54093_54135 = state_54069__$1;
(statearr_54093_54135[(2)] = inst_54003);

(statearr_54093_54135[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (2))){
var inst_53979 = (state_54069[(8)]);
var inst_53978 = (state_54069[(10)]);
var inst_53977 = (state_54069[(11)]);
var _ = (function (){var statearr_54094 = state_54069;
(statearr_54094[(4)] = cljs.core.cons((5),(state_54069[(4)])));

return statearr_54094;
})();
var inst_53974 = cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
var inst_53975 = session;
var inst_53976 = cljs.core.__destructure_map(inst_53975);
var inst_53977__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53976,cljs.core.cst$kw$conn);
var inst_53978__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53976,cljs.core.cst$kw$network);
var inst_53979__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53976,cljs.core.cst$kw$dbid);
var inst_53980 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_53981 = [inst_53978__$1,inst_53979__$1];
var inst_53982 = (new cljs.core.PersistentVector(null,2,(5),inst_53980,inst_53981,null));
var inst_53983 = fluree.db.operations.ledger_info_async(inst_53977__$1,inst_53982);
var state_54069__$1 = (function (){var statearr_54095 = state_54069;
(statearr_54095[(17)] = inst_53974);

(statearr_54095[(8)] = inst_53979__$1);

(statearr_54095[(10)] = inst_53978__$1);

(statearr_54095[(11)] = inst_53977__$1);

return statearr_54095;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(6),inst_53983);
} else {
if((state_val_54070 === (23))){
var inst_54016 = (state_54069[(18)]);
var inst_54025 = (state_54069[(16)]);
var inst_54028 = cljs.core.__destructure_map(inst_54025);
var inst_54029 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54028,cljs.core.cst$kw$flakes);
var inst_54030 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54028,cljs.core.cst$kw$block);
var inst_54031 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_54028,cljs.core.cst$kw$t);
var inst_54032 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_54016,inst_54030,inst_54029);
var state_54069__$1 = (function (){var statearr_54096 = state_54069;
(statearr_54096[(19)] = inst_54031);

return statearr_54096;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(26),inst_54032);
} else {
if((state_val_54070 === (19))){
var inst_54016 = (state_54069[(18)]);
var state_54069__$1 = state_54069;
var statearr_54097_54136 = state_54069__$1;
(statearr_54097_54136[(2)] = inst_54016);

(statearr_54097_54136[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (11))){
var inst_53979 = (state_54069[(8)]);
var inst_53978 = (state_54069[(10)]);
var inst_53986 = (state_54069[(7)]);
var inst_53995 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_53986);
var inst_53996 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53978),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53979)," is not currently available. Status is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53995),"."].join('');
var state_54069__$1 = state_54069;
var statearr_54099_54137 = state_54069__$1;
(statearr_54099_54137[(2)] = inst_53996);

(statearr_54099_54137[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (9))){
var inst_53974 = (state_54069[(17)]);
var inst_53979 = (state_54069[(8)]);
var inst_53978 = (state_54069[(10)]);
var inst_53986 = (state_54069[(7)]);
var inst_53977 = (state_54069[(11)]);
var inst_54006 = (state_54069[(2)]);
var inst_54007 = cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(inst_53986);
var inst_54008 = fluree.db.storage.core.reify_db(inst_53977,inst_53978,inst_53979,inst_53974,inst_54007);
var state_54069__$1 = (function (){var statearr_54100 = state_54069;
(statearr_54100[(20)] = inst_54006);

return statearr_54100;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(13),inst_54008);
} else {
if((state_val_54070 === (5))){
var _ = (function (){var statearr_54101 = state_54069;
(statearr_54101[(4)] = cljs.core.rest((state_54069[(4)])));

return statearr_54101;
})();
var state_54069__$1 = state_54069;
var ex54098 = (state_54069__$1[(2)]);
var statearr_54102_54138 = state_54069__$1;
(statearr_54102_54138[(5)] = ex54098);


var statearr_54103_54139 = state_54069__$1;
(statearr_54103_54139[(1)] = (4));

(statearr_54103_54139[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (14))){
var inst_54011 = (state_54069[(14)]);
var inst_54014 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_54011);
var inst_54015 = (inst_54014 + (1));
var inst_54016 = inst_54011;
var inst_54017 = inst_54015;
var state_54069__$1 = (function (){var statearr_54104 = state_54069;
(statearr_54104[(18)] = inst_54016);

(statearr_54104[(9)] = inst_54017);

return statearr_54104;
})();
var statearr_54105_54140 = state_54069__$1;
(statearr_54105_54140[(2)] = null);

(statearr_54105_54140[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (26))){
var inst_54017 = (state_54069[(9)]);
var inst_54034 = (state_54069[(2)]);
var inst_54035 = fluree.db.util.async.throw_err(inst_54034);
var inst_54036 = (inst_54017 + (1));
var inst_54016 = inst_54035;
var inst_54017__$1 = inst_54036;
var state_54069__$1 = (function (){var statearr_54106 = state_54069;
(statearr_54106[(18)] = inst_54016);

(statearr_54106[(9)] = inst_54017__$1);

return statearr_54106;
})();
var statearr_54107_54141 = state_54069__$1;
(statearr_54107_54141[(2)] = null);

(statearr_54107_54141[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (16))){
var inst_54053 = (state_54069[(12)]);
var inst_54053__$1 = (state_54069[(2)]);
var inst_54054 = fluree.db.query.schema.schema_map(inst_54053__$1);
var state_54069__$1 = (function (){var statearr_54108 = state_54069;
(statearr_54108[(12)] = inst_54053__$1);

return statearr_54108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54069__$1,(27),inst_54054);
} else {
if((state_val_54070 === (10))){
var inst_53979 = (state_54069[(8)]);
var inst_53978 = (state_54069[(10)]);
var inst_53993 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53978),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_53979)," is not found on this ledger group."].join('');
var state_54069__$1 = state_54069;
var statearr_54109_54142 = state_54069__$1;
(statearr_54109_54142[(2)] = inst_53993);

(statearr_54109_54142[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (18))){
var inst_54050 = (state_54069[(2)]);
var state_54069__$1 = state_54069;
var statearr_54110_54143 = state_54069__$1;
(statearr_54110_54143[(2)] = inst_54050);

(statearr_54110_54143[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54070 === (8))){
var state_54069__$1 = state_54069;
var statearr_54111_54144 = state_54069__$1;
(statearr_54111_54144[(2)] = null);

(statearr_54111_54144[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__ = null;
var fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____0 = (function (){
var statearr_54112 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54112[(0)] = fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__);

(statearr_54112[(1)] = (1));

return statearr_54112;
});
var fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____1 = (function (state_54069){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54069);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54113){var ex__24301__auto__ = e54113;
var statearr_54114_54145 = state_54069;
(statearr_54114_54145[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54069[(4)]))){
var statearr_54115_54146 = state_54069;
(statearr_54115_54146[(1)] = cljs.core.first((state_54069[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54147 = state_54069;
state_54069 = G__54147;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__ = function(state_54069){
switch(arguments.length){
case 0:
return fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____1.call(this,state_54069);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____0;
fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$full_load_existing_db_$_state_machine__24298__auto____1;
return fluree$db$session$full_load_existing_db_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54116 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54116[(6)] = c__24424__auto___54117);

return statearr_54116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return pc;
});
/**
 * Performs a compare and set! to update db, but only does so if
 *   existing db promise-chan is the same as old-db-ch.
 * 
 *   Returns true if successful, false if it did not replace.
 */
fluree.db.session.cas_db_BANG_ = (function fluree$db$session$cas_db_BANG_(session,old_db_ch,new_db_ch){
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(old_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(state))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$db_SLASH_db,new_db_ch);
} else {
return state;
}
}));
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new_db_ch,cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(new_state));
});
/**
 * Clears db from cache, forcing a new full load next time db is requested.
 */
fluree.db.session.clear_db_BANG_ = (function fluree$db$session$clear_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,null);
});
/**
 * Clears any current db that is cached and forces a db reload.
 */
fluree.db.session.reload_db_BANG_ = (function fluree$db$session$reload_db_BANG_(session){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
});
/**
 * Returns block currently being indexed (truthy), or nil (falsey) if not currently indexing.
 */
fluree.db.session.indexing_QMARK_ = (function fluree$db$session$indexing_QMARK_(session){
return cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Returns block of last indexed block, but only for indexing done by this server.
 */
fluree.db.session.indexed = (function fluree$db$session$indexed(session){
return cljs.core.cst$kw$db_SLASH_indexed.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Attempts to acquire indexing lock, and if successful returns true, else false.
 */
fluree.db.session.acquire_indexing_lock_BANG_ = (function fluree$db$session$acquire_indexing_lock_BANG_(session,block){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (s){
var G__54148 = s;
if((cljs.core.cst$kw$db_SLASH_indexing.cljs$core$IFn$_invoke$arity$1(s) == null)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__54148,cljs.core.cst$kw$db_SLASH_indexing,block);
} else {
return G__54148;
}
}));

return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,fluree.db.session.indexing_QMARK_(session));
});
/**
 * Releases indexing lock, and updates the last indexed value on the connection with provided block number.
 */
fluree.db.session.release_indexing_lock_BANG_ = (function fluree$db$session$release_indexing_lock_BANG_(session,block){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.assoc,cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$db_SLASH_indexed,block], 0));
});
fluree.db.session.alias__GT_id_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.cache.lru_cache_factory(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$threshold,(100)], null)));
/**
 * Returns ledger id from alias.
 */
fluree.db.session.ledger_alias__GT_id = (function fluree$db$session$ledger_alias__GT_id(network,alias){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.session.alias__GT_id_cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var dbid = alias;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.session.alias__GT_id_cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,alias], null),dbid);

return dbid;
}
});
/**
 * Resolves a ledger identity in the form of 'network/alias' and returns a
 *   two-tuple of [network ledger-id].
 * 
 *   An alias lookup is always performed first, and if an alias doesn't exist it is assumed
 *   the provided name is a ledger-id.
 * 
 *   If you are providing a ledger-id, and wish to skip an alias lookup, a prefix of '$'
 *   can be used for the name portion of the ledger.
 * 
 *   i.e.
 *   - testnet/testledger - Look for ledger with an alias testledger on network testnet.
 *   - testnet/$testledger - look for a ledger with id testledger on network testnet (skip alias lookup).
 *   - [testnet testledger] - already in form of [network ledger-id]
 */
fluree.db.session.resolve_ledger = (function fluree$db$session$resolve_ledger(conn,ledger){
if(cljs.core.sequential_QMARK_(ledger)){
return ledger;
} else {
var ledger__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(ledger);
var network = cljs.core.namespace(ledger__$1);
var maybe_alias = cljs.core.name(ledger__$1);
var _ = (cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ledger__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null))})());
if(clojure.string.starts_with_QMARK_(maybe_alias,"$")){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,cljs.core.subs.cljs$core$IFn$_invoke$arity$2(maybe_alias,(1))], null);
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,fluree.db.session.ledger_alias__GT_id(network,maybe_alias),maybe_alias], null);
}
}
});
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.session !== 'undefined') && (typeof fluree.db.session.process_ledger_update !== 'undefined')){
} else {
fluree.db.session.process_ledger_update = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__54149 = cljs.core.get_global_hierarchy;
return (fexpr__54149.cljs$core$IFn$_invoke$arity$0 ? fexpr__54149.cljs$core$IFn$_invoke$arity$0() : fexpr__54149.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.session","process-ledger-update"),(function (_,event_type,___$1){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local_DASH_ledger_DASH_update,(function (_,___$1,___$2){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54151){
var state_val_54152 = (state_54151[(1)]);
if((state_val_54152 === (1))){
var state_54151__$1 = state_54151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54151__$1,cljs.core.cst$kw$fluree$db$session_SLASH_no_DASH_op);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__24298__auto__ = null;
var fluree$db$session$state_machine__24298__auto____0 = (function (){
var statearr_54153 = [null,null,null,null,null,null,null];
(statearr_54153[(0)] = fluree$db$session$state_machine__24298__auto__);

(statearr_54153[(1)] = (1));

return statearr_54153;
});
var fluree$db$session$state_machine__24298__auto____1 = (function (state_54151){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54151);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54154){var ex__24301__auto__ = e54154;
var statearr_54155_54158 = state_54151;
(statearr_54155_54158[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54151[(4)]))){
var statearr_54156_54159 = state_54151;
(statearr_54156_54159[(1)] = cljs.core.first((state_54151[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54160 = state_54151;
state_54151 = G__54160;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$state_machine__24298__auto__ = function(state_54151){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__24298__auto____1.call(this,state_54151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__24298__auto____0;
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__24298__auto____1;
return fluree$db$session$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54157 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54157[(6)] = c__24424__auto__);

return statearr_54157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$block,(function (session,event_type,p__54162){
var map__54163 = p__54162;
var map__54163__$1 = cljs.core.__destructure_map(map__54163);
var data = map__54163__$1;
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54163__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54163__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54163__$1,cljs.core.cst$kw$flakes);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54222){
var state_val_54223 = (state_54222[(1)]);
if((state_val_54223 === (7))){
var inst_54177 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_54178 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_54179 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54177),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54178),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but DB is already more current. No-op."].join('');
var inst_54180 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54179], 0));
var state_54222__$1 = state_54222;
var statearr_54224_54262 = state_54222__$1;
(statearr_54224_54262[(2)] = inst_54180);

(statearr_54224_54262[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (1))){
var state_54222__$1 = state_54222;
var statearr_54225_54263 = state_54222__$1;
(statearr_54225_54263[(2)] = null);

(statearr_54225_54263[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (4))){
var inst_54164 = (state_54222[(2)]);
var state_54222__$1 = state_54222;
var statearr_54226_54264 = state_54222__$1;
(statearr_54226_54264[(2)] = inst_54164);

(statearr_54226_54264[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (15))){
var inst_54203 = (state_54222[(2)]);
var state_54222__$1 = state_54222;
var statearr_54227_54265 = state_54222__$1;
(statearr_54227_54265[(2)] = inst_54203);

(statearr_54227_54265[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (13))){
var inst_54194 = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var inst_54195 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_54196 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_54197 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_54198 = [inst_54196,inst_54197];
var inst_54199 = (new cljs.core.PersistentVector(null,2,(5),inst_54195,inst_54198,null));
var inst_54200 = (function (){var G__54228 = inst_54194;
var G__54229 = cljs.core.cst$kw$local_DASH_ledger_DASH_update;
var G__54230 = inst_54199;
var G__54231 = data;
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(G__54228,G__54229,G__54230,G__54231) : fluree.db.conn_events.process_event.call(null,G__54228,G__54229,G__54230,G__54231));
})();
var state_54222__$1 = state_54222;
var statearr_54232_54266 = state_54222__$1;
(statearr_54232_54266[(2)] = inst_54200);

(statearr_54232_54266[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (6))){
var inst_54174 = (state_54222[(7)]);
var inst_54173 = (state_54222[(8)]);
var inst_54172 = (state_54222[(2)]);
var inst_54173__$1 = fluree.db.util.async.throw_err(inst_54172);
var inst_54174__$1 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_54173__$1);
var inst_54175 = (block <= inst_54174__$1);
var state_54222__$1 = (function (){var statearr_54233 = state_54222;
(statearr_54233[(7)] = inst_54174__$1);

(statearr_54233[(8)] = inst_54173__$1);

return statearr_54233;
})();
if(cljs.core.truth_(inst_54175)){
var statearr_54234_54267 = state_54222__$1;
(statearr_54234_54267[(1)] = (7));

} else {
var statearr_54235_54268 = state_54222__$1;
(statearr_54235_54268[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (17))){
var state_54222__$1 = state_54222;
var statearr_54236_54269 = state_54222__$1;
(statearr_54236_54269[(2)] = null);

(statearr_54236_54269[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (3))){
var inst_54220 = (state_54222[(2)]);
var state_54222__$1 = state_54222;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54222__$1,inst_54220);
} else {
if((state_val_54223 === (12))){
var inst_54215 = (state_54222[(2)]);
var state_54222__$1 = state_54222;
var statearr_54237_54270 = state_54222__$1;
(statearr_54237_54270[(2)] = inst_54215);

(statearr_54237_54270[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (2))){
var inst_54170 = (state_54222[(9)]);
var _ = (function (){var statearr_54238 = state_54222;
(statearr_54238[(4)] = cljs.core.cons((5),(state_54222[(4)])));

return statearr_54238;
})();
var inst_54170__$1 = (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
var state_54222__$1 = (function (){var statearr_54239 = state_54222;
(statearr_54239[(9)] = inst_54170__$1);

return statearr_54239;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54222__$1,(6),inst_54170__$1);
} else {
if((state_val_54223 === (11))){
var state_54222__$1 = state_54222;
var statearr_54241_54271 = state_54222__$1;
(statearr_54241_54271[(1)] = (16));



return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (9))){
var inst_54217 = (state_54222[(2)]);
var _ = (function (){var statearr_54243 = state_54222;
(statearr_54243[(4)] = cljs.core.rest((state_54222[(4)])));

return statearr_54243;
})();
var state_54222__$1 = state_54222;
var statearr_54244_54272 = state_54222__$1;
(statearr_54244_54272[(2)] = inst_54217);

(statearr_54244_54272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (5))){
var _ = (function (){var statearr_54245 = state_54222;
(statearr_54245[(4)] = cljs.core.rest((state_54222[(4)])));

return statearr_54245;
})();
var state_54222__$1 = state_54222;
var ex54240 = (state_54222__$1[(2)]);
var statearr_54246_54273 = state_54222__$1;
(statearr_54246_54273[(5)] = ex54240);


if((ex54240 instanceof Error)){
var statearr_54247_54274 = state_54222__$1;
(statearr_54247_54274[(1)] = (4));

(statearr_54247_54274[(5)] = null);

} else {
throw ex54240;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (14))){
var state_54222__$1 = state_54222;
var statearr_54248_54275 = state_54222__$1;
(statearr_54248_54275[(2)] = null);

(statearr_54248_54275[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (16))){
var inst_54174 = (state_54222[(7)]);
var inst_54206 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_54207 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_54208 = ["Missing block(s): ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54206),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54207),". Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", but latest local block is: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54174),". Forcing a db reload."].join('');
var inst_54209 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54208], 0));
var inst_54210 = fluree.db.session.reload_db_BANG_(session);
var state_54222__$1 = (function (){var statearr_54249 = state_54222;
(statearr_54249[(10)] = inst_54209);

return statearr_54249;
})();
var statearr_54250_54276 = state_54222__$1;
(statearr_54250_54276[(2)] = inst_54210);

(statearr_54250_54276[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (10))){
var inst_54174 = (state_54222[(7)]);
var inst_54170 = (state_54222[(9)]);
var inst_54173 = (state_54222[(8)]);
var inst_54185 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_54186 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_54187 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54185),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54186),": Received block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),", DB at that block, update cached db with flakes."].join('');
var inst_54188 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54187], 0));
var inst_54189 = (function (){var current_db_ch = inst_54170;
var current_db = inst_54173;
var current_block = inst_54174;
return (function (p1__54161_SHARP_){
if((p1__54161_SHARP_ instanceof fluree.db.flake.Flake)){
return p1__54161_SHARP_;
} else {
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(p1__54161_SHARP_);
}
});
})();
var inst_54190 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_54189,flakes);
var inst_54191 = fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3(inst_54173,block,inst_54190);
var inst_54192 = fluree.db.session.cas_db_BANG_(session,inst_54170,inst_54191);
var state_54222__$1 = (function (){var statearr_54251 = state_54222;
(statearr_54251[(11)] = inst_54188);

return statearr_54251;
})();
if(inst_54192){
var statearr_54252_54277 = state_54222__$1;
(statearr_54252_54277[(1)] = (13));

} else {
var statearr_54253_54278 = state_54222__$1;
(statearr_54253_54278[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (18))){
var inst_54213 = (state_54222[(2)]);
var state_54222__$1 = state_54222;
var statearr_54254_54279 = state_54222__$1;
(statearr_54254_54279[(2)] = inst_54213);

(statearr_54254_54279[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54223 === (8))){
var inst_54174 = (state_54222[(7)]);
var inst_54182 = ((1) + inst_54174);
var inst_54183 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_54182);
var state_54222__$1 = state_54222;
if(inst_54183){
var statearr_54255_54280 = state_54222__$1;
(statearr_54255_54280[(1)] = (10));

} else {
var statearr_54256_54281 = state_54222__$1;
(statearr_54256_54281[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__24298__auto__ = null;
var fluree$db$session$state_machine__24298__auto____0 = (function (){
var statearr_54257 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54257[(0)] = fluree$db$session$state_machine__24298__auto__);

(statearr_54257[(1)] = (1));

return statearr_54257;
});
var fluree$db$session$state_machine__24298__auto____1 = (function (state_54222){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54222);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54258){var ex__24301__auto__ = e54258;
var statearr_54259_54282 = state_54222;
(statearr_54259_54282[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54222[(4)]))){
var statearr_54260_54283 = state_54222;
(statearr_54260_54283[(1)] = cljs.core.first((state_54222[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54284 = state_54222;
state_54222 = G__54284;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$state_machine__24298__auto__ = function(state_54222){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__24298__auto____1.call(this,state_54222);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__24298__auto____0;
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__24298__auto____1;
return fluree$db$session$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54261 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54261[(6)] = c__24424__auto__);

return statearr_54261;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));
fluree.db.session.process_ledger_update.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new_DASH_index,(function (session,header,block){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54291){
var state_val_54292 = (state_54291[(1)]);
if((state_val_54292 === (1))){
var inst_54285 = fluree.db.session.clear_db_BANG_(session);
var inst_54286 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session);
var inst_54287 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session);
var inst_54288 = ["Ledger ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54286),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_54287)," re-indexed as of block: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_54289 = fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54288], 0));
var state_54291__$1 = (function (){var statearr_54293 = state_54291;
(statearr_54293[(7)] = inst_54285);

(statearr_54293[(8)] = inst_54289);

return statearr_54293;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_54291__$1,true);
} else {
return null;
}
});
return (function() {
var fluree$db$session$state_machine__24298__auto__ = null;
var fluree$db$session$state_machine__24298__auto____0 = (function (){
var statearr_54294 = [null,null,null,null,null,null,null,null,null];
(statearr_54294[(0)] = fluree$db$session$state_machine__24298__auto__);

(statearr_54294[(1)] = (1));

return statearr_54294;
});
var fluree$db$session$state_machine__24298__auto____1 = (function (state_54291){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54291);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54295){var ex__24301__auto__ = e54295;
var statearr_54296_54299 = state_54291;
(statearr_54296_54299[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54291[(4)]))){
var statearr_54297_54300 = state_54291;
(statearr_54297_54300[(1)] = cljs.core.first((state_54291[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54301 = state_54291;
state_54291 = G__54301;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$state_machine__24298__auto__ = function(state_54291){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__24298__auto____1.call(this,state_54291);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__24298__auto____0;
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__24298__auto____1;
return fluree$db$session$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54298 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54298[(6)] = c__24424__auto__);

return statearr_54298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));
fluree.db.session.closed_QMARK_ = (function fluree$db$session$closed_QMARK_(session){
return cljs.core.cst$kw$closed_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
});
/**
 * Properly shuts down a session.
 *   Returns true if shut down, false if it was already shut down.
 * 
 *   Calling with a session will shut down session, calling with
 *   two arity network + dbid will see if a session is in cache and
 *   then perform the shutdown on the cached session, else will return
 *   false.
 */
fluree.db.session.close = (function fluree$db$session$close(var_args){
var G__54303 = arguments.length;
switch (G__54303) {
case 1:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$1 = (function (session){
if(cljs.core.truth_(fluree.db.session.closed_QMARK_(session))){
return false;
} else {
var map__54304 = session;
var map__54304__$1 = cljs.core.__destructure_map(map__54304);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$conn);
var update_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$update_DASH_chan);
var transact_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$transact_DASH_chan);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$state);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$dbid);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54304__$1,cljs.core.cst$kw$id);
var closed_QMARK_ = fluree.db.session.closed_QMARK_(session);
if(cljs.core.truth_(closed_QMARK_)){
fluree.db.session.remove_cache_BANG_(network,dbid);

return false;
} else {
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc,cljs.core.cst$kw$closed_QMARK_,true);

var fexpr__54305_54308 = cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__54305_54308.cljs$core$IFn$_invoke$arity$3 ? fexpr__54305_54308.cljs$core$IFn$_invoke$arity$3(network,dbid,id) : fexpr__54305_54308.call(null,network,dbid,id));

cljs.core.async.close_BANG_(update_chan);

if(cljs.core.truth_(transact_chan)){
cljs.core.async.close_BANG_(transact_chan);
} else {
}

fluree.db.session.remove_cache_BANG_(network,dbid);

if(cljs.core.fn_QMARK_(cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session))){
var fexpr__54306_54309 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(session);
(fexpr__54306_54309.cljs$core$IFn$_invoke$arity$0 ? fexpr__54306_54309.cljs$core$IFn$_invoke$arity$0() : fexpr__54306_54309.call(null));
} else {
}

return true;
}
}
}));

(fluree.db.session.close.cljs$core$IFn$_invoke$arity$2 = (function (network,dbid){
var temp__5751__auto__ = fluree.db.session.from_cache(network,dbid);
if(cljs.core.truth_(temp__5751__auto__)){
var session = temp__5751__auto__;
return fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);
} else {
return false;
}
}));

(fluree.db.session.close.cljs$lang$maxFixedArity = 2);

/**
 * Creates loop that takes new blocks / index commands and processes them in order
 *   ensuring the consistency of the database.
 */
fluree.db.session.process_ledger_updates = (function fluree$db$session$process_ledger_updates(conn,network,ledger_id,update_chan){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54362){
var state_val_54363 = (state_54362[(1)]);
if((state_val_54363 === (7))){
var inst_54358 = (state_54362[(2)]);
var state_54362__$1 = state_54362;
var statearr_54364_54395 = state_54362__$1;
(statearr_54364_54395[(2)] = inst_54358);

(statearr_54364_54395[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (1))){
var state_54362__$1 = state_54362;
var statearr_54365_54396 = state_54362__$1;
(statearr_54365_54396[(2)] = null);

(statearr_54365_54396[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (4))){
var inst_54313 = (state_54362[(7)]);
var inst_54312 = (state_54362[(2)]);
var inst_54313__$1 = fluree.db.util.async.throw_err(inst_54312);
var inst_54314 = fluree.db.session.from_cache(network,ledger_id);
var inst_54315 = (inst_54313__$1 == null);
var state_54362__$1 = (function (){var statearr_54366 = state_54362;
(statearr_54366[(8)] = inst_54314);

(statearr_54366[(7)] = inst_54313__$1);

return statearr_54366;
})();
if(cljs.core.truth_(inst_54315)){
var statearr_54367_54397 = state_54362__$1;
(statearr_54367_54397[(1)] = (5));

} else {
var statearr_54368_54398 = state_54362__$1;
(statearr_54368_54398[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (15))){
var inst_54350 = (state_54362[(2)]);
var state_54362__$1 = (function (){var statearr_54369 = state_54362;
(statearr_54369[(9)] = inst_54350);

return statearr_54369;
})();
var statearr_54370_54399 = state_54362__$1;
(statearr_54370_54399[(2)] = null);

(statearr_54370_54399[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (13))){
var inst_54354 = (state_54362[(2)]);
var state_54362__$1 = state_54362;
var statearr_54372_54400 = state_54362__$1;
(statearr_54372_54400[(2)] = inst_54354);

(statearr_54372_54400[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (6))){
var inst_54314 = (state_54362[(8)]);
var inst_54320 = (inst_54314 == null);
var state_54362__$1 = state_54362;
if(cljs.core.truth_(inst_54320)){
var statearr_54373_54401 = state_54362__$1;
(statearr_54373_54401[(1)] = (8));

} else {
var statearr_54374_54402 = state_54362__$1;
(statearr_54374_54402[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (17))){
var _ = (function (){var statearr_54375 = state_54362;
(statearr_54375[(4)] = cljs.core.rest((state_54362[(4)])));

return statearr_54375;
})();
var state_54362__$1 = state_54362;
var ex54371 = (state_54362__$1[(2)]);
var statearr_54376_54403 = state_54362__$1;
(statearr_54376_54403[(5)] = ex54371);


var statearr_54377_54404 = state_54362__$1;
(statearr_54377_54404[(1)] = (16));

(statearr_54377_54404[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (3))){
var inst_54360 = (state_54362[(2)]);
var state_54362__$1 = state_54362;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54362__$1,inst_54360);
} else {
if((state_val_54363 === (12))){
var state_54362__$1 = state_54362;
var statearr_54378_54405 = state_54362__$1;
(statearr_54378_54405[(2)] = null);

(statearr_54378_54405[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (2))){
var state_54362__$1 = state_54362;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54362__$1,(4),update_chan);
} else {
if((state_val_54363 === (11))){
var state_54362__$1 = state_54362;
var statearr_54379_54406 = state_54362__$1;
(statearr_54379_54406[(2)] = null);

(statearr_54379_54406[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (9))){
var state_54362__$1 = state_54362;
var statearr_54380_54407 = state_54362__$1;
(statearr_54380_54407[(1)] = (11));



return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (5))){
var inst_54317 = ["Channel closed for session updates for: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"."].join('');
var inst_54318 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54317], 0));
var state_54362__$1 = state_54362;
var statearr_54382_54408 = state_54362__$1;
(statearr_54382_54408[(2)] = inst_54318);

(statearr_54382_54408[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (14))){
var inst_54314 = (state_54362[(8)]);
var inst_54313 = (state_54362[(7)]);
var _ = (function (){var statearr_54383 = state_54362;
(statearr_54383[(4)] = cljs.core.cons((17),(state_54362[(4)])));

return statearr_54383;
})();
var inst_54338 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54313,(0),null);
var inst_54339 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_54313,(1),null);
var inst_54340 = ["[process-ledger-updates[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"]: "].join('');
var inst_54341 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54313], 0));
var inst_54342 = fluree.db.util.core.trunc(inst_54341,(200));
var inst_54343 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54340,inst_54342], 0));
var inst_54344 = (fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3 ? fluree.db.session.process_ledger_update.cljs$core$IFn$_invoke$arity$3(inst_54314,inst_54338,inst_54339) : fluree.db.session.process_ledger_update.call(null,inst_54314,inst_54338,inst_54339));
var state_54362__$1 = (function (){var statearr_54384 = state_54362;
(statearr_54384[(10)] = inst_54343);

return statearr_54384;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54362__$1,(18),inst_54344);
} else {
if((state_val_54363 === (16))){
var inst_54313 = (state_54362[(7)]);
var inst_54328 = (state_54362[(2)]);
var inst_54329 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54328,"Exception processing ledger updates for message: ",inst_54313], 0));
var state_54362__$1 = state_54362;
var statearr_54385_54409 = state_54362__$1;
(statearr_54385_54409[(2)] = inst_54329);

(statearr_54385_54409[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (10))){
var inst_54356 = (state_54362[(2)]);
var state_54362__$1 = state_54362;
var statearr_54386_54410 = state_54362__$1;
(statearr_54386_54410[(2)] = inst_54356);

(statearr_54386_54410[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (18))){
var inst_54346 = (state_54362[(2)]);
var inst_54347 = fluree.db.util.async.throw_err(inst_54346);
var _ = (function (){var statearr_54387 = state_54362;
(statearr_54387[(4)] = cljs.core.rest((state_54362[(4)])));

return statearr_54387;
})();
var state_54362__$1 = state_54362;
var statearr_54388_54411 = state_54362__$1;
(statearr_54388_54411[(2)] = inst_54347);

(statearr_54388_54411[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54363 === (8))){
var inst_54313 = (state_54362[(7)]);
var inst_54322 = cljs.core.first(inst_54313);
var inst_54323 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54322], 0));
var inst_54324 = ["Ledger update received for session that is no longer open: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Message: ",inst_54323].join('');
var inst_54325 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54324], 0));
var state_54362__$1 = state_54362;
var statearr_54389_54412 = state_54362__$1;
(statearr_54389_54412[(2)] = inst_54325);

(statearr_54389_54412[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__ = null;
var fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____0 = (function (){
var statearr_54390 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54390[(0)] = fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__);

(statearr_54390[(1)] = (1));

return statearr_54390;
});
var fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____1 = (function (state_54362){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54362);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54391){var ex__24301__auto__ = e54391;
var statearr_54392_54413 = state_54362;
(statearr_54392_54413[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54362[(4)]))){
var statearr_54393_54414 = state_54362;
(statearr_54393_54414[(1)] = cljs.core.first((state_54362[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54415 = state_54362;
state_54362 = G__54415;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__ = function(state_54362){
switch(arguments.length){
case 0:
return fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____1.call(this,state_54362);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____0;
fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$process_ledger_updates_$_state_machine__24298__auto____1;
return fluree$db$session$process_ledger_updates_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54394 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54394[(6)] = c__24424__auto__);

return statearr_54394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Creates a connection without first checking if db exists. Only useful if reloading
 *   and replacing an existing DB.
 */
fluree.db.session.session_factory = (function fluree$db$session$session_factory(p__54416){
var map__54417 = p__54416;
var map__54417__$1 = cljs.core.__destructure_map(map__54417);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$conn);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$dbid);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$db);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$transactor_QMARK_);
var db_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$db_DASH_name);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$state);
var close = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$close);
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54417__$1,cljs.core.cst$kw$id);
var schema_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var update_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var transact_chan = (cljs.core.truth_(transactor_QMARK_)?cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0():null);
var state__$1 = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([state,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$req_SLASH_sync,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$req_SLASH_count,(0),cljs.core.cst$kw$req_SLASH_last,null,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$db_SLASH_db,(cljs.core.truth_(db)?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$schema_DASH_cache,schema_cache):null),cljs.core.cst$kw$db_SLASH_indexing,null,cljs.core.cst$kw$closed_QMARK_,false], null)], 0)));
var session = fluree.db.session.map__GT_DbSession(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$dbid,cljs.core.cst$kw$update_DASH_chan,cljs.core.cst$kw$db_DASH_name,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$id,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$transact_DASH_chan,cljs.core.cst$kw$network,cljs.core.cst$kw$blank_DASH_db,cljs.core.cst$kw$conn],[dbid,update_chan,db_name,state__$1,close,id,schema_cache,transact_chan,network,null,conn]));
var current_db_fn = (function (){
return (fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1 ? fluree.db.session.current_db.cljs$core$IFn$_invoke$arity$1(session) : fluree.db.session.current_db.call(null,session));
});
var blank_db = fluree.db.graphdb.blank_db(conn,network,dbid,schema_cache,current_db_fn);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session,cljs.core.cst$kw$blank_DASH_db,blank_db);
});
/**
 * Blocks can have multiple transactions. If we are monitoring a single transaction
 *   we take a full block response and return a map with just that transaction's details.
 *   If the entire block details are desired, the block can be used to retrieve them.
 * 
 *   If throw? is true, throws an exception if non-2xx response.
 */
fluree.db.session.block_response__GT_tx_response = (function fluree$db$session$block_response__GT_tx_response(block_result,txid){
var map__54421 = block_result;
var map__54421__$1 = cljs.core.__destructure_map(map__54421);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54421__$1,cljs.core.cst$kw$block);
var hash = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54421__$1,cljs.core.cst$kw$hash);
var instant = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54421__$1,cljs.core.cst$kw$instant);
var txns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54421__$1,cljs.core.cst$kw$txns);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54421__$1,cljs.core.cst$kw$flakes);
var tx_result = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(txid));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(txns,txid);
}
})();
var _ = (cljs.core.truth_(tx_result)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Unexpected error, unable to get tx results for txid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(txid)," out of block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error,cljs.core.cst$kw$block,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([block_result], 0))], null))})());
var map__54422 = tx_result;
var map__54422__$1 = cljs.core.__destructure_map(map__54422);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54422__$1,cljs.core.cst$kw$t);
var status = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54422__$1,cljs.core.cst$kw$status);
var t_filter = (((cljs.core.first(flakes) instanceof fluree.db.flake.Flake))?(function (p1__54418_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,p1__54418_SHARP_.t);
}):(function (p1__54419_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(t,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__54419_SHARP_,(3)));
}));
var response = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(tx_result,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$flakes,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(t_filter,flakes)], 0));
if((cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response) < (300))){
return response;
} else {
var error_msg = cljs.core.some((function (p1__54420_SHARP_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((109),cljs.core.second(p1__54420_SHARP_))){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__54420_SHARP_,(2));
} else {
return null;
}
}),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(response));
var vec__54423 = (cljs.core.truth_(error_msg)?cljs.core.re_find(/^([0-9]+) ([^ ]+) (.+)/,error_msg):null);
var ___$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54423,(0),null);
var status__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54423,(1),null);
var error = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54423,(2),null);
var message = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54423,(3),null);
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "Unknown error.";
}
})(),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response),cljs.core.cst$kw$error,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(error),cljs.core.cst$kw$meta,response], null));
}
});
/**
 * Creates new session and caches it.
 * 
 *   Will tolerate race conditions, and if this call successfully created the session
 *   it will attach an extra key, :new? true, to the session.
 * 
 *   If another process created the session first, will return the other process' session.
 */
fluree.db.session.create_and_cache_session = (function fluree$db$session$create_and_cache_session(opts){
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Create and cache session. Opt keys: ",cljs.core.keys(opts)], 0));
var id = cljs.core.keyword.cljs$core$IFn$_invoke$arity$2("session",cljs.core.subs.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid()),(0),(7)));
var session = fluree.db.session.session_factory(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$id,id));
var session_STAR_ = fluree.db.session.cache_BANG_(session);
var new_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(id,cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session_STAR_));
if(new_QMARK_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(session_STAR_,cljs.core.cst$kw$new_QMARK_,true);
} else {
return session_STAR_;
}
});
/**
 * Returns connection to the given ledger, and ensures it is cached.
 * 
 *   If 'state' is provided, it will get merged into the connection's state.
 *   Use namespaced keys, so as to not to create a conflict with system state keys.
 * 
 *   Options supported:
 *   - connect? - attempts to create a streaming connection to db - will fail if db does not exist
 *           - ensure is 'false' if trying to create a new db that does not yet exist.
 *   - state    - initial state map to use
 *   - auth     - the auth
 *   - jwt      - jwt from password login
 *   
 */
fluree.db.session.session = (function fluree$db$session$session(var_args){
var G__54427 = arguments.length;
switch (G__54427) {
case 2:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$2 = (function (conn,ledger){
return fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.session.session.cljs$core$IFn$_invoke$arity$3 = (function (conn,ledger,p__54428){
var map__54429 = p__54428;
var map__54429__$1 = cljs.core.__destructure_map(map__54429);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54429__$1,cljs.core.cst$kw$state);
var connect_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54429__$1,cljs.core.cst$kw$connect_QMARK_);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54429__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__54429__$1,cljs.core.cst$kw$jwt);
var vec__54430 = fluree.db.session.resolve_ledger(conn,ledger);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54430,(0),null);
var ledger_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54430,(1),null);
var ledger_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54430,(2),null);
var connect_QMARK___$1 = ((connect_QMARK_ === false)?false:true);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(conn);
var opts = fluree.db.util.core.without_nils(new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt], null));
var or__4212__auto__ = fluree.db.session.from_cache(network,ledger_id);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var session = fluree.db.session.create_and_cache_session(new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,ledger_id,cljs.core.cst$kw$db_DASH_name,null,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$jwt,jwt,cljs.core.cst$kw$conn,conn,cljs.core.cst$kw$state,(function (){var or__4212__auto____$1 = state;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.cst$kw$transactor_QMARK_,transactor_QMARK_], null));
var new_QMARK_ = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(session) === true;
if(new_QMARK_){
if(connect_QMARK___$1){
fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,opts);

var G__54434_54554 = network;
var G__54435_54555 = ledger_id;
var G__54436_54556 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(session);
var G__54437_54557 = (function (event_type,event_data){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [event_type,event_data], null));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$block,event_type)){
var temp__5753__auto__ = cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),cljs.core.cst$kw$db_SLASH_pending_DASH_tx));
if(cljs.core.truth_(temp__5753__auto__)){
var tx_callbacks = temp__5753__auto__;
var tids = cljs.core.keys(cljs.core.cst$kw$txns.cljs$core$IFn$_invoke$arity$1(event_data));
var seq__54438 = cljs.core.seq(tids);
var chunk__54439 = null;
var count__54440 = (0);
var i__54441 = (0);
while(true){
if((i__54441 < count__54440)){
var tid = chunk__54439.cljs$core$IIndexed$_nth$arity$2(null,i__54441);
var temp__5753__auto___54559__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___54559__$1)){
var keyed_callbacks_54560 = temp__5753__auto___54559__$1;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_54561 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__54482_54562 = cljs.core.seq(keyed_callbacks_54560);
var chunk__54483_54563 = null;
var count__54484_54564 = (0);
var i__54485_54565 = (0);
while(true){
if((i__54485_54565 < count__54484_54564)){
var vec__54494_54566 = chunk__54483_54563.cljs$core$IIndexed$_nth$arity$2(null,i__54485_54565);
var k_54567 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54494_54566,(0),null);
var f_54568 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54494_54566,(1),null);
try{(f_54568.cljs$core$IFn$_invoke$arity$1 ? f_54568.cljs$core$IFn$_invoke$arity$1(tx_response_54561) : f_54568.call(null,tx_response_54561));
}catch (e54497){var e_54569 = e54497;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_54569,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__54570 = seq__54482_54562;
var G__54571 = chunk__54483_54563;
var G__54572 = count__54484_54564;
var G__54573 = (i__54485_54565 + (1));
seq__54482_54562 = G__54570;
chunk__54483_54563 = G__54571;
count__54484_54564 = G__54572;
i__54485_54565 = G__54573;
continue;
} else {
var temp__5753__auto___54574__$2 = cljs.core.seq(seq__54482_54562);
if(temp__5753__auto___54574__$2){
var seq__54482_54575__$1 = temp__5753__auto___54574__$2;
if(cljs.core.chunked_seq_QMARK_(seq__54482_54575__$1)){
var c__4638__auto___54576 = cljs.core.chunk_first(seq__54482_54575__$1);
var G__54577 = cljs.core.chunk_rest(seq__54482_54575__$1);
var G__54578 = c__4638__auto___54576;
var G__54579 = cljs.core.count(c__4638__auto___54576);
var G__54580 = (0);
seq__54482_54562 = G__54577;
chunk__54483_54563 = G__54578;
count__54484_54564 = G__54579;
i__54485_54565 = G__54580;
continue;
} else {
var vec__54498_54581 = cljs.core.first(seq__54482_54575__$1);
var k_54582 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54498_54581,(0),null);
var f_54583 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54498_54581,(1),null);
try{(f_54583.cljs$core$IFn$_invoke$arity$1 ? f_54583.cljs$core$IFn$_invoke$arity$1(tx_response_54561) : f_54583.call(null,tx_response_54561));
}catch (e54501){var e_54584 = e54501;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_54584,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__54585 = cljs.core.next(seq__54482_54575__$1);
var G__54586 = null;
var G__54587 = (0);
var G__54588 = (0);
seq__54482_54562 = G__54585;
chunk__54483_54563 = G__54586;
count__54484_54564 = G__54587;
i__54485_54565 = G__54588;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__54589 = seq__54438;
var G__54590 = chunk__54439;
var G__54591 = count__54440;
var G__54592 = (i__54441 + (1));
seq__54438 = G__54589;
chunk__54439 = G__54590;
count__54440 = G__54591;
i__54441 = G__54592;
continue;
} else {
var temp__5753__auto____$1 = cljs.core.seq(seq__54438);
if(temp__5753__auto____$1){
var seq__54438__$1 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(seq__54438__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__54438__$1);
var G__54593 = cljs.core.chunk_rest(seq__54438__$1);
var G__54594 = c__4638__auto__;
var G__54595 = cljs.core.count(c__4638__auto__);
var G__54596 = (0);
seq__54438 = G__54593;
chunk__54439 = G__54594;
count__54440 = G__54595;
i__54441 = G__54596;
continue;
} else {
var tid = cljs.core.first(seq__54438__$1);
var temp__5753__auto___54597__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tx_callbacks,fluree.db.util.core.keyword__GT_str(tid));
if(cljs.core.truth_(temp__5753__auto___54597__$2)){
var keyed_callbacks_54598 = temp__5753__auto___54597__$2;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.util.core.keyword__GT_str(tid)], 0));

var tx_response_54599 = fluree.db.session.block_response__GT_tx_response(event_data,tid);
var seq__54502_54600 = cljs.core.seq(keyed_callbacks_54598);
var chunk__54503_54601 = null;
var count__54504_54602 = (0);
var i__54505_54603 = (0);
while(true){
if((i__54505_54603 < count__54504_54602)){
var vec__54514_54604 = chunk__54503_54601.cljs$core$IIndexed$_nth$arity$2(null,i__54505_54603);
var k_54605 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54514_54604,(0),null);
var f_54606 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54514_54604,(1),null);
try{(f_54606.cljs$core$IFn$_invoke$arity$1 ? f_54606.cljs$core$IFn$_invoke$arity$1(tx_response_54599) : f_54606.call(null,tx_response_54599));
}catch (e54517){var e_54607 = e54517;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_54607,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__54608 = seq__54502_54600;
var G__54609 = chunk__54503_54601;
var G__54610 = count__54504_54602;
var G__54611 = (i__54505_54603 + (1));
seq__54502_54600 = G__54608;
chunk__54503_54601 = G__54609;
count__54504_54602 = G__54610;
i__54505_54603 = G__54611;
continue;
} else {
var temp__5753__auto___54612__$3 = cljs.core.seq(seq__54502_54600);
if(temp__5753__auto___54612__$3){
var seq__54502_54613__$1 = temp__5753__auto___54612__$3;
if(cljs.core.chunked_seq_QMARK_(seq__54502_54613__$1)){
var c__4638__auto___54614 = cljs.core.chunk_first(seq__54502_54613__$1);
var G__54615 = cljs.core.chunk_rest(seq__54502_54613__$1);
var G__54616 = c__4638__auto___54614;
var G__54617 = cljs.core.count(c__4638__auto___54614);
var G__54618 = (0);
seq__54502_54600 = G__54615;
chunk__54503_54601 = G__54616;
count__54504_54602 = G__54617;
i__54505_54603 = G__54618;
continue;
} else {
var vec__54518_54619 = cljs.core.first(seq__54502_54613__$1);
var k_54620 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54518_54619,(0),null);
var f_54621 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__54518_54619,(1),null);
try{(f_54621.cljs$core$IFn$_invoke$arity$1 ? f_54621.cljs$core$IFn$_invoke$arity$1(tx_response_54599) : f_54621.call(null,tx_response_54599));
}catch (e54521){var e_54622 = e54521;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_54622,["Error processing transaction callback for tid: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tid),"."].join('')], 0));
}

var G__54623 = cljs.core.next(seq__54502_54613__$1);
var G__54624 = null;
var G__54625 = (0);
var G__54626 = (0);
seq__54502_54600 = G__54623;
chunk__54503_54601 = G__54624;
count__54504_54602 = G__54625;
i__54505_54603 = G__54626;
continue;
}
} else {
}
}
break;
}
} else {
}


var G__54627 = cljs.core.next(seq__54438__$1);
var G__54628 = null;
var G__54629 = (0);
var G__54630 = (0);
seq__54438 = G__54627;
chunk__54439 = G__54628;
count__54440 = G__54629;
i__54441 = G__54630;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return null;
}
} else {
return null;
}
});
var fexpr__54433_54558 = cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__54433_54558.cljs$core$IFn$_invoke$arity$4 ? fexpr__54433_54558.cljs$core$IFn$_invoke$arity$4(G__54434_54554,G__54435_54555,G__54436_54556,G__54437_54557) : fexpr__54433_54558.call(null,G__54434_54554,G__54435_54555,G__54436_54556,G__54437_54557));

fluree.db.session.process_ledger_updates(conn,network,ledger_id,cljs.core.cst$kw$update_DASH_chan.cljs$core$IFn$_invoke$arity$1(session));
} else {
}

if(cljs.core.truth_(transactor_QMARK_)){
var transact_handler_54631 = cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(conn);
var c__24424__auto___54632 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_54538){
var state_val_54539 = (state_54538[(1)]);
if((state_val_54539 === (1))){
var state_54538__$1 = state_54538;
var statearr_54540_54633 = state_54538__$1;
(statearr_54540_54633[(2)] = null);

(statearr_54540_54633[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54539 === (2))){
var inst_54523 = cljs.core.cst$kw$transact_DASH_chan.cljs$core$IFn$_invoke$arity$1(session);
var state_54538__$1 = state_54538;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54538__$1,(4),inst_54523);
} else {
if((state_val_54539 === (3))){
var inst_54536 = (state_54538[(2)]);
var state_54538__$1 = state_54538;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54538__$1,inst_54536);
} else {
if((state_val_54539 === (4))){
var inst_54525 = (state_54538[(7)]);
var inst_54525__$1 = (state_54538[(2)]);
var inst_54526 = (inst_54525__$1 == null);
var state_54538__$1 = (function (){var statearr_54541 = state_54538;
(statearr_54541[(7)] = inst_54525__$1);

return statearr_54541;
})();
if(cljs.core.truth_(inst_54526)){
var statearr_54542_54634 = state_54538__$1;
(statearr_54542_54634[(1)] = (5));

} else {
var statearr_54543_54635 = state_54538__$1;
(statearr_54543_54635[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_54539 === (5))){
var inst_54528 = ["Transactor session closing for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"[",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_alias),"]"].join('');
var inst_54529 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_54528], 0));
var state_54538__$1 = state_54538;
var statearr_54544_54636 = state_54538__$1;
(statearr_54544_54636[(2)] = inst_54529);

(statearr_54544_54636[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54539 === (6))){
var inst_54525 = (state_54538[(7)]);
var inst_54531 = (transact_handler_54631.cljs$core$IFn$_invoke$arity$2 ? transact_handler_54631.cljs$core$IFn$_invoke$arity$2(conn,inst_54525) : transact_handler_54631.call(null,conn,inst_54525));
var state_54538__$1 = (function (){var statearr_54545 = state_54538;
(statearr_54545[(8)] = inst_54531);

return statearr_54545;
})();
var statearr_54546_54637 = state_54538__$1;
(statearr_54546_54637[(2)] = null);

(statearr_54546_54637[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_54539 === (7))){
var inst_54534 = (state_54538[(2)]);
var state_54538__$1 = state_54538;
var statearr_54547_54638 = state_54538__$1;
(statearr_54547_54638[(2)] = inst_54534);

(statearr_54547_54638[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$session$state_machine__24298__auto__ = null;
var fluree$db$session$state_machine__24298__auto____0 = (function (){
var statearr_54548 = [null,null,null,null,null,null,null,null,null];
(statearr_54548[(0)] = fluree$db$session$state_machine__24298__auto__);

(statearr_54548[(1)] = (1));

return statearr_54548;
});
var fluree$db$session$state_machine__24298__auto____1 = (function (state_54538){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_54538);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e54549){var ex__24301__auto__ = e54549;
var statearr_54550_54639 = state_54538;
(statearr_54550_54639[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_54538[(4)]))){
var statearr_54551_54640 = state_54538;
(statearr_54551_54640[(1)] = cljs.core.first((state_54538[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__54641 = state_54538;
state_54538 = G__54641;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$session$state_machine__24298__auto__ = function(state_54538){
switch(arguments.length){
case 0:
return fluree$db$session$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$session$state_machine__24298__auto____1.call(this,state_54538);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$session$state_machine__24298__auto____0;
fluree$db$session$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$session$state_machine__24298__auto____1;
return fluree$db$session$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_54552 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_54552[(6)] = c__24424__auto___54632);

return statearr_54552;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

} else {
}
} else {
}

return session;
}
}));

(fluree.db.session.session.cljs$lang$maxFixedArity = 3);

/**
 * Gets the latest db from the central DB atom if available, or loads it from scratch.
 *   DB is returned as a core async promise channel.
 */
fluree.db.session.current_db = (function fluree$db$session$current_db(session){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__54642_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(p1__54642_SHARP_,cljs.core.cst$kw$req_SLASH_last,fluree.db.util.core.current_time_millis(),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$req_SLASH_count,(cljs.core.cst$kw$req_SLASH_count.cljs$core$IFn$_invoke$arity$1(p1__54642_SHARP_) + (1))], 0));
}));

var db = cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
if((db == null)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(session),cljs.core.empty);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),(function (p1__54643_SHARP_){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__54643_SHARP_,cljs.core.cst$kw$db_SLASH_db,fluree.db.session.full_load_existing_db(session));
}));

return cljs.core.cst$kw$db_SLASH_db.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)));
} else {
return db;
}
});
/**
 * Creates a session and returns a blank db.
 */
fluree.db.session.blank_db = (function fluree$db$session$blank_db(conn,ledger){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$connect_QMARK_,false], null));
return cljs.core.cst$kw$blank_DASH_db.cljs$core$IFn$_invoke$arity$1(session);
});
/**
 * Returns core async channel containing current db
 */
fluree.db.session.db = (function fluree$db$session$db(conn,ledger,opts){
var session = fluree.db.session.session.cljs$core$IFn$_invoke$arity$3(conn,ledger,opts);
return fluree.db.session.current_db(session);
});
/**
 * Useful for a shutdown process. Closes all sessions for a given connection-id.
 *   If no connection given, closes all sessions.
 */
fluree.db.session.close_all_sessions = (function fluree$db$session$close_all_sessions(var_args){
var G__54646 = arguments.length;
switch (G__54646) {
case 0:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$0 = (function (){
return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(null);
}));

(fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1 = (function (conn_id){
var sessions = (function (){var G__54647 = cljs.core.vals(cljs.core.deref(fluree.db.session.session_cache));
if(cljs.core.truth_(conn_id)){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__54644_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(conn_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(p1__54644_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$id], null)));
}),G__54647);
} else {
return G__54647;
}
})();
var seq__54648 = cljs.core.seq(sessions);
var chunk__54649 = null;
var count__54650 = (0);
var i__54651 = (0);
while(true){
if((i__54651 < count__54650)){
var session = chunk__54649.cljs$core$IIndexed$_nth$arity$2(null,i__54651);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__54653 = seq__54648;
var G__54654 = chunk__54649;
var G__54655 = count__54650;
var G__54656 = (i__54651 + (1));
seq__54648 = G__54653;
chunk__54649 = G__54654;
count__54650 = G__54655;
i__54651 = G__54656;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__54648);
if(temp__5753__auto__){
var seq__54648__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__54648__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__54648__$1);
var G__54657 = cljs.core.chunk_rest(seq__54648__$1);
var G__54658 = c__4638__auto__;
var G__54659 = cljs.core.count(c__4638__auto__);
var G__54660 = (0);
seq__54648 = G__54657;
chunk__54649 = G__54658;
count__54650 = G__54659;
i__54651 = G__54660;
continue;
} else {
var session = cljs.core.first(seq__54648__$1);
fluree.db.session.close.cljs$core$IFn$_invoke$arity$1(session);


var G__54661 = cljs.core.next(seq__54648__$1);
var G__54662 = null;
var G__54663 = (0);
var G__54664 = (0);
seq__54648 = G__54661;
chunk__54649 = G__54662;
count__54650 = G__54663;
i__54651 = G__54664;
continue;
}
} else {
return null;
}
}
break;
}
}));

(fluree.db.session.close_all_sessions.cljs$lang$maxFixedArity = 1);

/**
 * Adds a callback function to call when we see a completed transaction in a block
 *   for the given tid.
 * 
 *   Key is any arbitrary key provided that allows the callback to be unregistered later
 *   with monitor-tx-remove. It must be unique.
 */
fluree.db.session.monitor_tx = (function fluree$db$session$monitor_tx(session,tid,key,f){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null),(function (x){
if(cljs.core.truth_(x)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Key provided to monitor-tx must be unique.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_request], null));
} else {
}

return f;
}));
});
/**
 * Removes callback from supplied transaction id and key.
 * 
 *   Will return true if callback successfully removed, else false if
 *   callback didn't exist.
 */
fluree.db.session.monitor_tx_remove = (function fluree$db$session$monitor_tx_remove(session,tid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$db_SLASH_pending_DASH_tx,tid,key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(session),cljs.core.update,cljs.core.cst$kw$db_SLASH_pending_DASH_tx,(function (pending_txs){
var updated = cljs.core.update.cljs$core$IFn$_invoke$arity$4(pending_txs,tid,cljs.core.dissoc,key);
if(cljs.core.empty_QMARK_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(updated,tid))){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(updated,tid);
} else {
return updated;
}
}));

return true;
} else {
return false;
}
});
