// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43000){
var state_val_43001 = (state_43000[(1)]);
if((state_val_43001 === (7))){
var inst_42989 = (state_43000[(7)]);
var inst_42991 = fluree.db.storage.core.serde(conn);
var inst_42992 = fluree.db.serde.protocol._deserialize_block(inst_42991,inst_42989);
var state_43000__$1 = state_43000;
var statearr_43002_43021 = state_43000__$1;
(statearr_43002_43021[(2)] = inst_42992);

(statearr_43002_43021[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (1))){
var state_43000__$1 = state_43000;
var statearr_43003_43022 = state_43000__$1;
(statearr_43003_43022[(2)] = null);

(statearr_43003_43022[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (4))){
var inst_42979 = (state_43000[(2)]);
var state_43000__$1 = state_43000;
var statearr_43004_43023 = state_43000__$1;
(statearr_43004_43023[(2)] = inst_42979);

(statearr_43004_43023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (6))){
var inst_42989 = (state_43000[(7)]);
var inst_42988 = (state_43000[(2)]);
var inst_42989__$1 = fluree.db.util.async.throw_err(inst_42988);
var state_43000__$1 = (function (){var statearr_43005 = state_43000;
(statearr_43005[(7)] = inst_42989__$1);

return statearr_43005;
})();
if(cljs.core.truth_(inst_42989__$1)){
var statearr_43006_43024 = state_43000__$1;
(statearr_43006_43024[(1)] = (7));

} else {
var statearr_43007_43025 = state_43000__$1;
(statearr_43007_43025[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (3))){
var inst_42998 = (state_43000[(2)]);
var state_43000__$1 = state_43000;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43000__$1,inst_42998);
} else {
if((state_val_43001 === (2))){
var _ = (function (){var statearr_43009 = state_43000;
(statearr_43009[(4)] = cljs.core.cons((5),(state_43000[(4)])));

return statearr_43009;
})();
var inst_42985 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_42986 = fluree.db.storage.core.storage_read(conn,inst_42985);
var state_43000__$1 = state_43000;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43000__$1,(6),inst_42986);
} else {
if((state_val_43001 === (9))){
var inst_42995 = (state_43000[(2)]);
var _ = (function (){var statearr_43010 = state_43000;
(statearr_43010[(4)] = cljs.core.rest((state_43000[(4)])));

return statearr_43010;
})();
var state_43000__$1 = state_43000;
var statearr_43011_43026 = state_43000__$1;
(statearr_43011_43026[(2)] = inst_42995);

(statearr_43011_43026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (5))){
var _ = (function (){var statearr_43012 = state_43000;
(statearr_43012[(4)] = cljs.core.rest((state_43000[(4)])));

return statearr_43012;
})();
var state_43000__$1 = state_43000;
var ex43008 = (state_43000__$1[(2)]);
var statearr_43013_43027 = state_43000__$1;
(statearr_43013_43027[(5)] = ex43008);


if((ex43008 instanceof Error)){
var statearr_43014_43028 = state_43000__$1;
(statearr_43014_43028[(1)] = (4));

(statearr_43014_43028[(5)] = null);

} else {
throw ex43008;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43001 === (8))){
var state_43000__$1 = state_43000;
var statearr_43015_43029 = state_43000__$1;
(statearr_43015_43029[(2)] = null);

(statearr_43015_43029[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__24298__auto____0 = (function (){
var statearr_43016 = [null,null,null,null,null,null,null,null];
(statearr_43016[(0)] = fluree$db$storage$core$read_block_$_state_machine__24298__auto__);

(statearr_43016[(1)] = (1));

return statearr_43016;
});
var fluree$db$storage$core$read_block_$_state_machine__24298__auto____1 = (function (state_43000){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43000);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43017){var ex__24301__auto__ = e43017;
var statearr_43018_43030 = state_43000;
(statearr_43018_43030[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43000[(4)]))){
var statearr_43019_43031 = state_43000;
(statearr_43019_43031[(1)] = cljs.core.first((state_43000[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43032 = state_43000;
state_43000 = G__43032;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__24298__auto__ = function(state_43000){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__24298__auto____1.call(this,state_43000);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43020 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43020[(6)] = c__24424__auto__);

return statearr_43020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43055){
var state_val_43056 = (state_43055[(1)]);
if((state_val_43056 === (7))){
var inst_43044 = (state_43055[(7)]);
var inst_43046 = fluree.db.storage.core.serde(conn);
var inst_43047 = fluree.db.serde.protocol._deserialize_block(inst_43046,inst_43044);
var state_43055__$1 = state_43055;
var statearr_43057_43076 = state_43055__$1;
(statearr_43057_43076[(2)] = inst_43047);

(statearr_43057_43076[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (1))){
var state_43055__$1 = state_43055;
var statearr_43058_43077 = state_43055__$1;
(statearr_43058_43077[(2)] = null);

(statearr_43058_43077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (4))){
var inst_43033 = (state_43055[(2)]);
var state_43055__$1 = state_43055;
var statearr_43059_43078 = state_43055__$1;
(statearr_43059_43078[(2)] = inst_43033);

(statearr_43059_43078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (6))){
var inst_43044 = (state_43055[(7)]);
var inst_43043 = (state_43055[(2)]);
var inst_43044__$1 = fluree.db.util.async.throw_err(inst_43043);
var state_43055__$1 = (function (){var statearr_43060 = state_43055;
(statearr_43060[(7)] = inst_43044__$1);

return statearr_43060;
})();
if(cljs.core.truth_(inst_43044__$1)){
var statearr_43061_43079 = state_43055__$1;
(statearr_43061_43079[(1)] = (7));

} else {
var statearr_43062_43080 = state_43055__$1;
(statearr_43062_43080[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (3))){
var inst_43053 = (state_43055[(2)]);
var state_43055__$1 = state_43055;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43055__$1,inst_43053);
} else {
if((state_val_43056 === (2))){
var _ = (function (){var statearr_43064 = state_43055;
(statearr_43064[(4)] = cljs.core.cons((5),(state_43055[(4)])));

return statearr_43064;
})();
var inst_43039 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_43040 = [inst_43039,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_43041 = fluree.db.storage.core.storage_read(conn,inst_43040);
var state_43055__$1 = state_43055;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43055__$1,(6),inst_43041);
} else {
if((state_val_43056 === (9))){
var inst_43050 = (state_43055[(2)]);
var _ = (function (){var statearr_43065 = state_43055;
(statearr_43065[(4)] = cljs.core.rest((state_43055[(4)])));

return statearr_43065;
})();
var state_43055__$1 = state_43055;
var statearr_43066_43081 = state_43055__$1;
(statearr_43066_43081[(2)] = inst_43050);

(statearr_43066_43081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (5))){
var _ = (function (){var statearr_43067 = state_43055;
(statearr_43067[(4)] = cljs.core.rest((state_43055[(4)])));

return statearr_43067;
})();
var state_43055__$1 = state_43055;
var ex43063 = (state_43055__$1[(2)]);
var statearr_43068_43082 = state_43055__$1;
(statearr_43068_43082[(5)] = ex43063);


if((ex43063 instanceof Error)){
var statearr_43069_43083 = state_43055__$1;
(statearr_43069_43083[(1)] = (4));

(statearr_43069_43083[(5)] = null);

} else {
throw ex43063;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43056 === (8))){
var state_43055__$1 = state_43055;
var statearr_43070_43084 = state_43055__$1;
(statearr_43070_43084[(2)] = null);

(statearr_43070_43084[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____0 = (function (){
var statearr_43071 = [null,null,null,null,null,null,null,null];
(statearr_43071[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__);

(statearr_43071[(1)] = (1));

return statearr_43071;
});
var fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____1 = (function (state_43055){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43055);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43072){var ex__24301__auto__ = e43072;
var statearr_43073_43085 = state_43055;
(statearr_43073_43085[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43055[(4)]))){
var statearr_43074_43086 = state_43055;
(statearr_43074_43086[(1)] = cljs.core.first((state_43055[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43087 = state_43055;
state_43055 = G__43087;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__ = function(state_43055){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____1.call(this,state_43055);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43075 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43075[(6)] = c__24424__auto__);

return statearr_43075;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43111){
var state_val_43112 = (state_43111[(1)]);
if((state_val_43112 === (1))){
var state_43111__$1 = state_43111;
var statearr_43113_43127 = state_43111__$1;
(statearr_43113_43127[(2)] = null);

(statearr_43113_43127[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43112 === (2))){
var _ = (function (){var statearr_43114 = state_43111;
(statearr_43114[(4)] = cljs.core.cons((5),(state_43111[(4)])));

return statearr_43114;
})();
var inst_43094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43095 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_43096 = (new cljs.core.PersistentVector(null,3,(5),inst_43094,inst_43095,null));
var inst_43097 = cljs.core.select_keys(block_data,inst_43096);
var inst_43098 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43097);
var inst_43099 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_43098);
var inst_43100 = [inst_43099,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_43101 = fluree.db.storage.core.serde(conn);
var inst_43102 = fluree.db.serde.protocol._serialize_block(inst_43101,inst_43097);
var inst_43103 = fluree.db.storage.core.storage_write(conn,inst_43100,inst_43102);
var state_43111__$1 = state_43111;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43111__$1,(6),inst_43103);
} else {
if((state_val_43112 === (3))){
var inst_43109 = (state_43111[(2)]);
var state_43111__$1 = state_43111;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43111__$1,inst_43109);
} else {
if((state_val_43112 === (4))){
var inst_43088 = (state_43111[(2)]);
var state_43111__$1 = state_43111;
var statearr_43116_43128 = state_43111__$1;
(statearr_43116_43128[(2)] = inst_43088);

(statearr_43116_43128[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43112 === (5))){
var _ = (function (){var statearr_43117 = state_43111;
(statearr_43117[(4)] = cljs.core.rest((state_43111[(4)])));

return statearr_43117;
})();
var state_43111__$1 = state_43111;
var ex43115 = (state_43111__$1[(2)]);
var statearr_43118_43129 = state_43111__$1;
(statearr_43118_43129[(5)] = ex43115);


if((ex43115 instanceof Error)){
var statearr_43119_43130 = state_43111__$1;
(statearr_43119_43130[(1)] = (4));

(statearr_43119_43130[(5)] = null);

} else {
throw ex43115;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43112 === (6))){
var inst_43105 = (state_43111[(2)]);
var inst_43106 = fluree.db.util.async.throw_err(inst_43105);
var _ = (function (){var statearr_43120 = state_43111;
(statearr_43120[(4)] = cljs.core.rest((state_43111[(4)])));

return statearr_43120;
})();
var state_43111__$1 = state_43111;
var statearr_43121_43131 = state_43111__$1;
(statearr_43121_43131[(2)] = inst_43106);

(statearr_43121_43131[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____0 = (function (){
var statearr_43122 = [null,null,null,null,null,null,null];
(statearr_43122[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__);

(statearr_43122[(1)] = (1));

return statearr_43122;
});
var fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____1 = (function (state_43111){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43111);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43123){var ex__24301__auto__ = e43123;
var statearr_43124_43132 = state_43111;
(statearr_43124_43132[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43111[(4)]))){
var statearr_43125_43133 = state_43111;
(statearr_43125_43133[(1)] = cljs.core.first((state_43111[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43134 = state_43111;
state_43111 = G__43134;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__ = function(state_43111){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____1.call(this,state_43111);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43126 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43126[(6)] = c__24424__auto__);

return statearr_43126;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43157){
var state_val_43158 = (state_43157[(1)]);
if((state_val_43158 === (1))){
var state_43157__$1 = state_43157;
var statearr_43159_43173 = state_43157__$1;
(statearr_43159_43173[(2)] = null);

(statearr_43159_43173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43158 === (2))){
var _ = (function (){var statearr_43160 = state_43157;
(statearr_43160[(4)] = cljs.core.cons((5),(state_43157[(4)])));

return statearr_43160;
})();
var inst_43141 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43142 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_43143 = (new cljs.core.PersistentVector(null,3,(5),inst_43141,inst_43142,null));
var inst_43144 = cljs.core.select_keys(block_data,inst_43143);
var inst_43145 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_43144);
var inst_43146 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_43145);
var inst_43147 = fluree.db.storage.core.serde(conn);
var inst_43148 = fluree.db.serde.protocol._serialize_block(inst_43147,inst_43144);
var inst_43149 = fluree.db.storage.core.storage_write(conn,inst_43146,inst_43148);
var state_43157__$1 = state_43157;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43157__$1,(6),inst_43149);
} else {
if((state_val_43158 === (3))){
var inst_43155 = (state_43157[(2)]);
var state_43157__$1 = state_43157;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43157__$1,inst_43155);
} else {
if((state_val_43158 === (4))){
var inst_43135 = (state_43157[(2)]);
var state_43157__$1 = state_43157;
var statearr_43162_43174 = state_43157__$1;
(statearr_43162_43174[(2)] = inst_43135);

(statearr_43162_43174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43158 === (5))){
var _ = (function (){var statearr_43163 = state_43157;
(statearr_43163[(4)] = cljs.core.rest((state_43157[(4)])));

return statearr_43163;
})();
var state_43157__$1 = state_43157;
var ex43161 = (state_43157__$1[(2)]);
var statearr_43164_43175 = state_43157__$1;
(statearr_43164_43175[(5)] = ex43161);


if((ex43161 instanceof Error)){
var statearr_43165_43176 = state_43157__$1;
(statearr_43165_43176[(1)] = (4));

(statearr_43165_43176[(5)] = null);

} else {
throw ex43161;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43158 === (6))){
var inst_43151 = (state_43157[(2)]);
var inst_43152 = fluree.db.util.async.throw_err(inst_43151);
var _ = (function (){var statearr_43166 = state_43157;
(statearr_43166[(4)] = cljs.core.rest((state_43157[(4)])));

return statearr_43166;
})();
var state_43157__$1 = state_43157;
var statearr_43167_43177 = state_43157__$1;
(statearr_43167_43177[(2)] = inst_43152);

(statearr_43167_43177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__24298__auto____0 = (function (){
var statearr_43168 = [null,null,null,null,null,null,null];
(statearr_43168[(0)] = fluree$db$storage$core$write_block_$_state_machine__24298__auto__);

(statearr_43168[(1)] = (1));

return statearr_43168;
});
var fluree$db$storage$core$write_block_$_state_machine__24298__auto____1 = (function (state_43157){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43157);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43169){var ex__24301__auto__ = e43169;
var statearr_43170_43178 = state_43157;
(statearr_43170_43178[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43157[(4)]))){
var statearr_43171_43179 = state_43157;
(statearr_43171_43179[(1)] = cljs.core.first((state_43157[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43180 = state_43157;
state_43157 = G__43180;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__24298__auto__ = function(state_43157){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__24298__auto____1.call(this,state_43157);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43172 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43172[(6)] = c__24424__auto__);

return statearr_43172;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43200){
var state_val_43201 = (state_43200[(1)]);
if((state_val_43201 === (1))){
var state_43200__$1 = state_43200;
var statearr_43202_43216 = state_43200__$1;
(statearr_43202_43216[(2)] = null);

(statearr_43202_43216[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43201 === (2))){
var _ = (function (){var statearr_43203 = state_43200;
(statearr_43203[(4)] = cljs.core.cons((5),(state_43200[(4)])));

return statearr_43203;
})();
var inst_43187 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_43188 = [history,next_his_key];
var inst_43189 = cljs.core.PersistentHashMap.fromArrays(inst_43187,inst_43188);
var inst_43190 = fluree.db.storage.core.serde(conn);
var inst_43191 = fluree.db.serde.protocol._serialize_leaf(inst_43190,inst_43189);
var inst_43192 = fluree.db.storage.core.storage_write(conn,his_key,inst_43191);
var state_43200__$1 = state_43200;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43200__$1,(6),inst_43192);
} else {
if((state_val_43201 === (3))){
var inst_43198 = (state_43200[(2)]);
var state_43200__$1 = state_43200;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43200__$1,inst_43198);
} else {
if((state_val_43201 === (4))){
var inst_43181 = (state_43200[(2)]);
var state_43200__$1 = state_43200;
var statearr_43205_43217 = state_43200__$1;
(statearr_43205_43217[(2)] = inst_43181);

(statearr_43205_43217[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43201 === (5))){
var _ = (function (){var statearr_43206 = state_43200;
(statearr_43206[(4)] = cljs.core.rest((state_43200[(4)])));

return statearr_43206;
})();
var state_43200__$1 = state_43200;
var ex43204 = (state_43200__$1[(2)]);
var statearr_43207_43218 = state_43200__$1;
(statearr_43207_43218[(5)] = ex43204);


if((ex43204 instanceof Error)){
var statearr_43208_43219 = state_43200__$1;
(statearr_43208_43219[(1)] = (4));

(statearr_43208_43219[(5)] = null);

} else {
throw ex43204;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43201 === (6))){
var inst_43194 = (state_43200[(2)]);
var inst_43195 = fluree.db.util.async.throw_err(inst_43194);
var _ = (function (){var statearr_43209 = state_43200;
(statearr_43209[(4)] = cljs.core.rest((state_43200[(4)])));

return statearr_43209;
})();
var state_43200__$1 = state_43200;
var statearr_43210_43220 = state_43200__$1;
(statearr_43210_43220[(2)] = inst_43195);

(statearr_43210_43220[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__24298__auto____0 = (function (){
var statearr_43211 = [null,null,null,null,null,null,null];
(statearr_43211[(0)] = fluree$db$storage$core$write_history_$_state_machine__24298__auto__);

(statearr_43211[(1)] = (1));

return statearr_43211;
});
var fluree$db$storage$core$write_history_$_state_machine__24298__auto____1 = (function (state_43200){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43200);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43212){var ex__24301__auto__ = e43212;
var statearr_43213_43221 = state_43200;
(statearr_43213_43221[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43200[(4)]))){
var statearr_43214_43222 = state_43200;
(statearr_43214_43222[(1)] = cljs.core.first((state_43200[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43223 = state_43200;
state_43200 = G__43223;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__24298__auto__ = function(state_43200){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__24298__auto____1.call(this,state_43200);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_history_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43215 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43215[(6)] = c__24424__auto__);

return statearr_43215;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43249){
var state_val_43250 = (state_43249[(1)]);
if((state_val_43250 === (1))){
var state_43249__$1 = state_43249;
var statearr_43251_43268 = state_43249__$1;
(statearr_43251_43268[(2)] = null);

(statearr_43251_43268[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43250 === (2))){
var inst_43230 = (state_43249[(7)]);
var _ = (function (){var statearr_43252 = state_43249;
(statearr_43252[(4)] = cljs.core.cons((5),(state_43249[(4)])));

return statearr_43252;
})();
var inst_43230__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_43231 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43230__$1),"-his"].join('');
var inst_43232 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_43233 = [flakes,inst_43231];
var inst_43234 = cljs.core.PersistentHashMap.fromArrays(inst_43232,inst_43233);
var inst_43235 = fluree.db.storage.core.serde(conn);
var inst_43236 = fluree.db.serde.protocol._serialize_leaf(inst_43235,inst_43234);
var inst_43237 = fluree.db.storage.core.write_history(conn,history,inst_43231,null);
var inst_43238 = fluree.db.storage.core.storage_write(conn,inst_43230__$1,inst_43236);
var state_43249__$1 = (function (){var statearr_43253 = state_43249;
(statearr_43253[(8)] = inst_43238);

(statearr_43253[(7)] = inst_43230__$1);

return statearr_43253;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43249__$1,(6),inst_43237);
} else {
if((state_val_43250 === (3))){
var inst_43247 = (state_43249[(2)]);
var state_43249__$1 = state_43249;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43249__$1,inst_43247);
} else {
if((state_val_43250 === (4))){
var inst_43224 = (state_43249[(2)]);
var state_43249__$1 = state_43249;
var statearr_43255_43269 = state_43249__$1;
(statearr_43255_43269[(2)] = inst_43224);

(statearr_43255_43269[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43250 === (5))){
var _ = (function (){var statearr_43256 = state_43249;
(statearr_43256[(4)] = cljs.core.rest((state_43249[(4)])));

return statearr_43256;
})();
var state_43249__$1 = state_43249;
var ex43254 = (state_43249__$1[(2)]);
var statearr_43257_43270 = state_43249__$1;
(statearr_43257_43270[(5)] = ex43254);


if((ex43254 instanceof Error)){
var statearr_43258_43271 = state_43249__$1;
(statearr_43258_43271[(1)] = (4));

(statearr_43258_43271[(5)] = null);

} else {
throw ex43254;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43250 === (6))){
var inst_43238 = (state_43249[(8)]);
var inst_43240 = (state_43249[(2)]);
var inst_43241 = fluree.db.util.async.throw_err(inst_43240);
var state_43249__$1 = (function (){var statearr_43259 = state_43249;
(statearr_43259[(9)] = inst_43241);

return statearr_43259;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43249__$1,(7),inst_43238);
} else {
if((state_val_43250 === (7))){
var inst_43230 = (state_43249[(7)]);
var inst_43243 = (state_43249[(2)]);
var inst_43244 = fluree.db.util.async.throw_err(inst_43243);
var _ = (function (){var statearr_43260 = state_43249;
(statearr_43260[(4)] = cljs.core.rest((state_43249[(4)])));

return statearr_43260;
})();
var state_43249__$1 = (function (){var statearr_43261 = state_43249;
(statearr_43261[(10)] = inst_43244);

return statearr_43261;
})();
var statearr_43262_43272 = state_43249__$1;
(statearr_43262_43272[(2)] = inst_43230);

(statearr_43262_43272[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____0 = (function (){
var statearr_43263 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43263[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__);

(statearr_43263[(1)] = (1));

return statearr_43263;
});
var fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____1 = (function (state_43249){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43249);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43264){var ex__24301__auto__ = e43264;
var statearr_43265_43273 = state_43249;
(statearr_43265_43273[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43249[(4)]))){
var statearr_43266_43274 = state_43249;
(statearr_43266_43274[(1)] = cljs.core.first((state_43249[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43275 = state_43249;
state_43249 = G__43275;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__ = function(state_43249){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____1.call(this,state_43249);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43267 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43267[(6)] = c__24424__auto__);

return statearr_43267;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43292){
var state_val_43293 = (state_43292[(1)]);
if((state_val_43293 === (1))){
var state_43292__$1 = state_43292;
var statearr_43294_43309 = state_43292__$1;
(statearr_43294_43309[(2)] = null);

(statearr_43294_43309[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43293 === (2))){
var _ = (function (){var statearr_43295 = state_43292;
(statearr_43295[(4)] = cljs.core.cons((5),(state_43292[(4)])));

return statearr_43295;
})();
var inst_43282 = fluree.db.storage.core.serde(conn);
var inst_43283 = fluree.db.serde.protocol._serialize_branch(inst_43282,data);
var inst_43284 = fluree.db.storage.core.storage_write(conn,key,inst_43283);
var state_43292__$1 = state_43292;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43292__$1,(6),inst_43284);
} else {
if((state_val_43293 === (3))){
var inst_43290 = (state_43292[(2)]);
var state_43292__$1 = state_43292;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43292__$1,inst_43290);
} else {
if((state_val_43293 === (4))){
var inst_43276 = (state_43292[(2)]);
var state_43292__$1 = state_43292;
var statearr_43297_43310 = state_43292__$1;
(statearr_43297_43310[(2)] = inst_43276);

(statearr_43297_43310[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43293 === (5))){
var _ = (function (){var statearr_43298 = state_43292;
(statearr_43298[(4)] = cljs.core.rest((state_43292[(4)])));

return statearr_43298;
})();
var state_43292__$1 = state_43292;
var ex43296 = (state_43292__$1[(2)]);
var statearr_43299_43311 = state_43292__$1;
(statearr_43299_43311[(5)] = ex43296);


if((ex43296 instanceof Error)){
var statearr_43300_43312 = state_43292__$1;
(statearr_43300_43312[(1)] = (4));

(statearr_43300_43312[(5)] = null);

} else {
throw ex43296;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43293 === (6))){
var inst_43286 = (state_43292[(2)]);
var inst_43287 = fluree.db.util.async.throw_err(inst_43286);
var _ = (function (){var statearr_43301 = state_43292;
(statearr_43301[(4)] = cljs.core.rest((state_43292[(4)])));

return statearr_43301;
})();
var state_43292__$1 = (function (){var statearr_43302 = state_43292;
(statearr_43302[(7)] = inst_43287);

return statearr_43302;
})();
var statearr_43303_43313 = state_43292__$1;
(statearr_43303_43313[(2)] = key);

(statearr_43303_43313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____0 = (function (){
var statearr_43304 = [null,null,null,null,null,null,null,null];
(statearr_43304[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__);

(statearr_43304[(1)] = (1));

return statearr_43304;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____1 = (function (state_43292){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43292);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43305){var ex__24301__auto__ = e43305;
var statearr_43306_43314 = state_43292;
(statearr_43306_43314[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43292[(4)]))){
var statearr_43307_43315 = state_43292;
(statearr_43307_43315[(1)] = cljs.core.first((state_43292[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43316 = state_43292;
state_43292 = G__43316;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__ = function(state_43292){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____1.call(this,state_43292);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43308 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43308[(6)] = c__24424__auto__);

return statearr_43308;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__43317_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__43317_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__43318){
var map__43319 = p__43318;
var map__43319__$1 = cljs.core.__destructure_map(map__43319);
var progress = map__43319__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43319__$1,cljs.core.cst$kw$garbage);
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43347){
var state_val_43348 = (state_43347[(1)]);
if((state_val_43348 === (1))){
var state_43347__$1 = state_43347;
var statearr_43349_43365 = state_43347__$1;
(statearr_43349_43365[(2)] = null);

(statearr_43349_43365[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43348 === (2))){
var inst_43333 = (state_43347[(7)]);
var _ = (function (){var statearr_43350 = state_43347;
(statearr_43350[(4)] = cljs.core.cons((5),(state_43347[(4)])));

return statearr_43350;
})();
var inst_43327 = db;
var inst_43328 = cljs.core.__destructure_map(inst_43327);
var inst_43329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43328,cljs.core.cst$kw$conn);
var inst_43330 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43328,cljs.core.cst$kw$network);
var inst_43331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43328,cljs.core.cst$kw$dbid);
var inst_43332 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43328,cljs.core.cst$kw$block);
var inst_43333__$1 = fluree.db.storage.core.ledger_garbage_key(inst_43330,inst_43331,inst_43332);
var inst_43334 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_43335 = [inst_43331,inst_43332,garbage];
var inst_43336 = cljs.core.PersistentHashMap.fromArrays(inst_43334,inst_43335);
var inst_43337 = fluree.db.storage.core.serde(inst_43329);
var inst_43338 = fluree.db.serde.protocol._serialize_garbage(inst_43337,inst_43336);
var inst_43339 = fluree.db.storage.core.storage_write(inst_43329,inst_43333__$1,inst_43338);
var state_43347__$1 = (function (){var statearr_43351 = state_43347;
(statearr_43351[(7)] = inst_43333__$1);

return statearr_43351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43347__$1,(6),inst_43339);
} else {
if((state_val_43348 === (3))){
var inst_43345 = (state_43347[(2)]);
var state_43347__$1 = state_43347;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43347__$1,inst_43345);
} else {
if((state_val_43348 === (4))){
var inst_43320 = (state_43347[(2)]);
var state_43347__$1 = state_43347;
var statearr_43353_43366 = state_43347__$1;
(statearr_43353_43366[(2)] = inst_43320);

(statearr_43353_43366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43348 === (5))){
var _ = (function (){var statearr_43354 = state_43347;
(statearr_43354[(4)] = cljs.core.rest((state_43347[(4)])));

return statearr_43354;
})();
var state_43347__$1 = state_43347;
var ex43352 = (state_43347__$1[(2)]);
var statearr_43355_43367 = state_43347__$1;
(statearr_43355_43367[(5)] = ex43352);


if((ex43352 instanceof Error)){
var statearr_43356_43368 = state_43347__$1;
(statearr_43356_43368[(1)] = (4));

(statearr_43356_43368[(5)] = null);

} else {
throw ex43352;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43348 === (6))){
var inst_43333 = (state_43347[(7)]);
var inst_43341 = (state_43347[(2)]);
var inst_43342 = fluree.db.util.async.throw_err(inst_43341);
var _ = (function (){var statearr_43357 = state_43347;
(statearr_43357[(4)] = cljs.core.rest((state_43347[(4)])));

return statearr_43357;
})();
var state_43347__$1 = (function (){var statearr_43358 = state_43347;
(statearr_43358[(8)] = inst_43342);

return statearr_43358;
})();
var statearr_43359_43369 = state_43347__$1;
(statearr_43359_43369[(2)] = inst_43333);

(statearr_43359_43369[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____0 = (function (){
var statearr_43360 = [null,null,null,null,null,null,null,null,null];
(statearr_43360[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__);

(statearr_43360[(1)] = (1));

return statearr_43360;
});
var fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____1 = (function (state_43347){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43347);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43361){var ex__24301__auto__ = e43361;
var statearr_43362_43370 = state_43347;
(statearr_43362_43370[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43347[(4)]))){
var statearr_43363_43371 = state_43347;
(statearr_43363_43371[(1)] = cljs.core.first((state_43347[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43372 = state_43347;
state_43347 = G__43372;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__ = function(state_43347){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____1.call(this,state_43347);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__24298__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43364 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43364[(6)] = c__24424__auto__);

return statearr_43364;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__43374 = arguments.length;
switch (G__43374) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43430){
var state_val_43431 = (state_43430[(1)]);
if((state_val_43431 === (7))){
var state_43430__$1 = state_43430;
var statearr_43432_43458 = state_43430__$1;
(statearr_43432_43458[(2)] = (0));

(statearr_43432_43458[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (1))){
var state_43430__$1 = state_43430;
var statearr_43433_43459 = state_43430__$1;
(statearr_43433_43459[(2)] = null);

(statearr_43433_43459[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (4))){
var inst_43375 = (state_43430[(2)]);
var state_43430__$1 = state_43430;
var statearr_43434_43460 = state_43430__$1;
(statearr_43434_43460[(2)] = inst_43375);

(statearr_43434_43460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (6))){
var inst_43400 = (state_43430[(7)]);
var state_43430__$1 = state_43430;
var statearr_43435_43461 = state_43430__$1;
(statearr_43435_43461[(2)] = inst_43400);

(statearr_43435_43461[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (3))){
var inst_43428 = (state_43430[(2)]);
var state_43430__$1 = state_43430;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43430__$1,inst_43428);
} else {
if((state_val_43431 === (12))){
var inst_43397 = (state_43430[(8)]);
var inst_43424 = (state_43430[(2)]);
var inst_43425 = fluree.db.util.async.throw_err(inst_43424);
var _ = (function (){var statearr_43436 = state_43430;
(statearr_43436[(4)] = cljs.core.rest((state_43430[(4)])));

return statearr_43436;
})();
var state_43430__$1 = (function (){var statearr_43437 = state_43430;
(statearr_43437[(9)] = inst_43425);

return statearr_43437;
})();
var statearr_43438_43462 = state_43430__$1;
(statearr_43438_43462[(2)] = inst_43397);

(statearr_43438_43462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (2))){
var inst_43388 = (state_43430[(10)]);
var inst_43390 = (state_43430[(11)]);
var inst_43392 = (state_43430[(12)]);
var inst_43400 = (state_43430[(7)]);
var _ = (function (){var statearr_43439 = state_43430;
(statearr_43439[(4)] = cljs.core.cons((5),(state_43430[(4)])));

return statearr_43439;
})();
var inst_43382 = db;
var inst_43383 = cljs.core.__destructure_map(inst_43382);
var inst_43384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$network);
var inst_43385 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$t);
var inst_43386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$fork);
var inst_43387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$spot);
var inst_43388__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$stats);
var inst_43389 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$conn);
var inst_43390__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$block);
var inst_43391 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$psot);
var inst_43392__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$dbid);
var inst_43393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$ecount);
var inst_43394 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$opst);
var inst_43395 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$fork_DASH_block);
var inst_43396 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43383,cljs.core.cst$kw$post);
var inst_43397 = fluree.db.storage.core.ledger_root_key(inst_43384,inst_43392__$1,inst_43390__$1);
var inst_43398 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_43399 = fluree.db.storage.core.child_data(inst_43391);
var inst_43400__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_43388__$1);
var state_43430__$1 = (function (){var statearr_43440 = state_43430;
(statearr_43440[(13)] = inst_43393);

(statearr_43440[(8)] = inst_43397);

(statearr_43440[(10)] = inst_43388__$1);

(statearr_43440[(14)] = inst_43394);

(statearr_43440[(15)] = inst_43398);

(statearr_43440[(11)] = inst_43390__$1);

(statearr_43440[(16)] = inst_43389);

(statearr_43440[(17)] = inst_43396);

(statearr_43440[(18)] = inst_43385);

(statearr_43440[(12)] = inst_43392__$1);

(statearr_43440[(19)] = inst_43387);

(statearr_43440[(20)] = inst_43399);

(statearr_43440[(21)] = inst_43386);

(statearr_43440[(22)] = inst_43395);

(statearr_43440[(7)] = inst_43400__$1);

return statearr_43440;
})();
if(cljs.core.truth_(inst_43400__$1)){
var statearr_43441_43463 = state_43430__$1;
(statearr_43441_43463[(1)] = (6));

} else {
var statearr_43442_43464 = state_43430__$1;
(statearr_43442_43464[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (11))){
var inst_43397 = (state_43430[(8)]);
var inst_43388 = (state_43430[(10)]);
var inst_43394 = (state_43430[(14)]);
var inst_43398 = (state_43430[(15)]);
var inst_43390 = (state_43430[(11)]);
var inst_43389 = (state_43430[(16)]);
var inst_43404 = (state_43430[(23)]);
var inst_43396 = (state_43430[(17)]);
var inst_43385 = (state_43430[(18)]);
var inst_43392 = (state_43430[(12)]);
var inst_43387 = (state_43430[(19)]);
var inst_43399 = (state_43430[(20)]);
var inst_43386 = (state_43430[(21)]);
var inst_43395 = (state_43430[(22)]);
var inst_43409 = (state_43430[(2)]);
var inst_43410 = fluree.db.storage.core.child_data(inst_43394);
var inst_43411 = fluree.db.storage.core.child_data(inst_43396);
var inst_43412 = fluree.db.util.core.current_time_millis();
var inst_43413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43414 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_43415 = (new cljs.core.PersistentVector(null,2,(5),inst_43413,inst_43414,null));
var inst_43416 = cljs.core.select_keys(inst_43388,inst_43415);
var inst_43417 = fluree.db.storage.core.child_data(inst_43387);
var inst_43418 = [inst_43390,inst_43399,inst_43392,inst_43404,inst_43409,inst_43410,inst_43411,inst_43385,inst_43412,inst_43386,inst_43395,inst_43416,inst_43417];
var inst_43419 = cljs.core.PersistentHashMap.fromArrays(inst_43398,inst_43418);
var inst_43420 = fluree.db.storage.core.serde(inst_43389);
var inst_43421 = fluree.db.serde.protocol._serialize_db_root(inst_43420,inst_43419);
var inst_43422 = fluree.db.storage.core.storage_write(inst_43389,inst_43397,inst_43421);
var state_43430__$1 = state_43430;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43430__$1,(12),inst_43422);
} else {
if((state_val_43431 === (9))){
var inst_43405 = (state_43430[(24)]);
var state_43430__$1 = state_43430;
var statearr_43444_43465 = state_43430__$1;
(statearr_43444_43465[(2)] = inst_43405);

(statearr_43444_43465[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (5))){
var _ = (function (){var statearr_43445 = state_43430;
(statearr_43445[(4)] = cljs.core.rest((state_43430[(4)])));

return statearr_43445;
})();
var state_43430__$1 = state_43430;
var ex43443 = (state_43430__$1[(2)]);
var statearr_43446_43466 = state_43430__$1;
(statearr_43446_43466[(5)] = ex43443);


if((ex43443 instanceof Error)){
var statearr_43447_43467 = state_43430__$1;
(statearr_43447_43467[(1)] = (4));

(statearr_43447_43467[(5)] = null);

} else {
throw ex43443;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (10))){
var inst_43393 = (state_43430[(13)]);
var state_43430__$1 = state_43430;
var statearr_43448_43468 = state_43430__$1;
(statearr_43448_43468[(2)] = inst_43393);

(statearr_43448_43468[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43431 === (8))){
var inst_43405 = (state_43430[(24)]);
var inst_43404 = (state_43430[(2)]);
var inst_43405__$1 = custom_ecount;
var state_43430__$1 = (function (){var statearr_43449 = state_43430;
(statearr_43449[(24)] = inst_43405__$1);

(statearr_43449[(23)] = inst_43404);

return statearr_43449;
})();
if(cljs.core.truth_(inst_43405__$1)){
var statearr_43450_43469 = state_43430__$1;
(statearr_43450_43469[(1)] = (9));

} else {
var statearr_43451_43470 = state_43430__$1;
(statearr_43451_43470[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__24298__auto__ = null;
var fluree$db$storage$core$state_machine__24298__auto____0 = (function (){
var statearr_43452 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43452[(0)] = fluree$db$storage$core$state_machine__24298__auto__);

(statearr_43452[(1)] = (1));

return statearr_43452;
});
var fluree$db$storage$core$state_machine__24298__auto____1 = (function (state_43430){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43430);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43453){var ex__24301__auto__ = e43453;
var statearr_43454_43471 = state_43430;
(statearr_43454_43471[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43430[(4)]))){
var statearr_43455_43472 = state_43430;
(statearr_43455_43472[(1)] = cljs.core.first((state_43430[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43473 = state_43430;
state_43430 = G__43473;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__24298__auto__ = function(state_43430){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__24298__auto____1.call(this,state_43430);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__24298__auto____0;
fluree$db$storage$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__24298__auto____1;
return fluree$db$storage$core$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43456 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43456[(6)] = c__24424__auto__);

return statearr_43456;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___43532 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43506){
var state_val_43507 = (state_43506[(1)]);
if((state_val_43507 === (7))){
var inst_43486 = (state_43506[(7)]);
var state_43506__$1 = state_43506;
var statearr_43508_43533 = state_43506__$1;
(statearr_43508_43533[(2)] = inst_43486);

(statearr_43508_43533[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (1))){
var state_43506__$1 = state_43506;
var statearr_43509_43534 = state_43506__$1;
(statearr_43509_43534[(2)] = null);

(statearr_43509_43534[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (4))){
var inst_43474 = (state_43506[(2)]);
var inst_43475 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_43476 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_43474);
var inst_43477 = cljs.core.async.close_BANG_(return_ch);
var state_43506__$1 = (function (){var statearr_43510 = state_43506;
(statearr_43510[(8)] = inst_43476);

(statearr_43510[(9)] = inst_43475);

return statearr_43510;
})();
var statearr_43511_43535 = state_43506__$1;
(statearr_43511_43535[(2)] = inst_43477);

(statearr_43511_43535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (6))){
var inst_43486 = (state_43506[(7)]);
var inst_43485 = (state_43506[(10)]);
var inst_43485__$1 = (state_43506[(2)]);
var inst_43486__$1 = (inst_43485__$1 == null);
var state_43506__$1 = (function (){var statearr_43512 = state_43506;
(statearr_43512[(7)] = inst_43486__$1);

(statearr_43512[(10)] = inst_43485__$1);

return statearr_43512;
})();
if(cljs.core.truth_(inst_43486__$1)){
var statearr_43513_43536 = state_43506__$1;
(statearr_43513_43536[(1)] = (7));

} else {
var statearr_43514_43537 = state_43506__$1;
(statearr_43514_43537[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (3))){
var inst_43504 = (state_43506[(2)]);
var state_43506__$1 = state_43506;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43506__$1,inst_43504);
} else {
if((state_val_43507 === (12))){
var inst_43501 = (state_43506[(2)]);
var _ = (function (){var statearr_43515 = state_43506;
(statearr_43515[(4)] = cljs.core.rest((state_43506[(4)])));

return statearr_43515;
})();
var state_43506__$1 = state_43506;
var statearr_43516_43538 = state_43506__$1;
(statearr_43516_43538[(2)] = inst_43501);

(statearr_43516_43538[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (2))){
var _ = (function (){var statearr_43517 = state_43506;
(statearr_43517[(4)] = cljs.core.cons((5),(state_43506[(4)])));

return statearr_43517;
})();
var inst_43483 = fluree.db.storage.core.storage_read(conn,key);
var state_43506__$1 = state_43506;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43506__$1,(6),inst_43483);
} else {
if((state_val_43507 === (11))){
var inst_43485 = (state_43506[(10)]);
var inst_43495 = fluree.db.storage.core.serde(conn);
var inst_43496 = fluree.db.serde.protocol._deserialize_leaf(inst_43495,inst_43485);
var inst_43497 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_43496);
var inst_43498 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_43497);
var inst_43499 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_43498);
var state_43506__$1 = state_43506;
var statearr_43519_43539 = state_43506__$1;
(statearr_43519_43539[(2)] = inst_43499);

(statearr_43519_43539[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (9))){
var inst_43491 = (state_43506[(2)]);
var state_43506__$1 = state_43506;
if(cljs.core.truth_(inst_43491)){
var statearr_43520_43540 = state_43506__$1;
(statearr_43520_43540[(1)] = (10));

} else {
var statearr_43521_43541 = state_43506__$1;
(statearr_43521_43541[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (5))){
var _ = (function (){var statearr_43522 = state_43506;
(statearr_43522[(4)] = cljs.core.rest((state_43506[(4)])));

return statearr_43522;
})();
var state_43506__$1 = state_43506;
var ex43518 = (state_43506__$1[(2)]);
var statearr_43523_43542 = state_43506__$1;
(statearr_43523_43542[(5)] = ex43518);


var statearr_43524_43543 = state_43506__$1;
(statearr_43524_43543[(1)] = (4));

(statearr_43524_43543[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (10))){
var inst_43493 = cljs.core.async.close_BANG_(return_ch);
var state_43506__$1 = state_43506;
var statearr_43525_43544 = state_43506__$1;
(statearr_43525_43544[(2)] = inst_43493);

(statearr_43525_43544[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43507 === (8))){
var inst_43485 = (state_43506[(10)]);
var inst_43489 = (inst_43485 instanceof Error);
var state_43506__$1 = state_43506;
var statearr_43526_43545 = state_43506__$1;
(statearr_43526_43545[(2)] = inst_43489);

(statearr_43526_43545[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__24298__auto____0 = (function (){
var statearr_43527 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43527[(0)] = fluree$db$storage$core$reify_history_$_state_machine__24298__auto__);

(statearr_43527[(1)] = (1));

return statearr_43527;
});
var fluree$db$storage$core$reify_history_$_state_machine__24298__auto____1 = (function (state_43506){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43506);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43528){var ex__24301__auto__ = e43528;
var statearr_43529_43546 = state_43506;
(statearr_43529_43546[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43506[(4)]))){
var statearr_43530_43547 = state_43506;
(statearr_43530_43547[(1)] = cljs.core.first((state_43506[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43548 = state_43506;
state_43506 = G__43548;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__24298__auto__ = function(state_43506){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__24298__auto____1.call(this,state_43506);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__24298__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__24298__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43531 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43531[(6)] = c__24424__auto___43532);

return statearr_43531;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__43550 = arguments.length;
switch (G__43550) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___43662 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43613){
var state_val_43614 = (state_43613[(1)]);
if((state_val_43614 === (7))){
var state_43613__$1 = state_43613;
var statearr_43615_43663 = state_43613__$1;
(statearr_43615_43663[(2)] = cljs.core.cst$kw$novelty);

(statearr_43615_43663[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (20))){
var inst_43592 = cljs.core.PersistentVector.EMPTY;
var state_43613__$1 = state_43613;
var statearr_43616_43664 = state_43613__$1;
(statearr_43616_43664[(2)] = inst_43592);

(statearr_43616_43664[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (1))){
var state_43613__$1 = state_43613;
var statearr_43617_43665 = state_43613__$1;
(statearr_43617_43665[(2)] = null);

(statearr_43617_43665[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (24))){
var state_43613__$1 = state_43613;
var statearr_43618_43666 = state_43613__$1;
(statearr_43618_43666[(2)] = null);

(statearr_43618_43666[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (4))){
var inst_43553 = (state_43613[(2)]);
var inst_43554 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_43555 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_43553);
var inst_43556 = cljs.core.async.close_BANG_(result_ch);
var state_43613__$1 = (function (){var statearr_43619 = state_43613;
(statearr_43619[(7)] = inst_43555);

(statearr_43619[(8)] = inst_43554);

return statearr_43619;
})();
var statearr_43620_43667 = state_43613__$1;
(statearr_43620_43667[(2)] = inst_43556);

(statearr_43620_43667[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (15))){
var inst_43578 = (state_43613[(2)]);
var state_43613__$1 = state_43613;
var statearr_43621_43668 = state_43613__$1;
(statearr_43621_43668[(2)] = inst_43578);

(statearr_43621_43668[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (21))){
var inst_43567 = (state_43613[(9)]);
var inst_43566 = (state_43613[(10)]);
var inst_43595 = (state_43613[(11)]);
var inst_43565 = (state_43613[(12)]);
var inst_43582 = (state_43613[(13)]);
var inst_43602 = (state_43613[(2)]);
var inst_43603 = (function (){var base_node = inst_43565;
var first_flake = inst_43566;
var node_t = inst_43567;
var source = inst_43582;
var coll = inst_43595;
var conj_QMARK_ = inst_43602;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__43623 = f.p;
var fexpr__43622 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__43622.cljs$core$IFn$_invoke$arity$1 ? fexpr__43622.cljs$core$IFn$_invoke$arity$1(G__43623) : fexpr__43622.call(null,G__43623));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_43604 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_43565);
var inst_43605 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_43603,inst_43604,inst_43595);
var inst_43606 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_43605);
var inst_43607 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43565,cljs.core.cst$kw$flakes,inst_43606);
var inst_43608 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_43607);
var _ = (function (){var statearr_43624 = state_43613;
(statearr_43624[(4)] = cljs.core.rest((state_43613[(4)])));

return statearr_43624;
})();
var state_43613__$1 = state_43613;
var statearr_43625_43669 = state_43613__$1;
(statearr_43625_43669[(2)] = inst_43608);

(statearr_43625_43669[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (13))){
var state_43613__$1 = state_43613;
var statearr_43626_43670 = state_43613__$1;
(statearr_43626_43670[(2)] = cljs.core.cst$kw$none);

(statearr_43626_43670[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (22))){
var inst_43567 = (state_43613[(9)]);
var inst_43566 = (state_43613[(10)]);
var inst_43595 = (state_43613[(11)]);
var inst_43565 = (state_43613[(12)]);
var inst_43582 = (state_43613[(13)]);
var inst_43596 = (function (){var base_node = inst_43565;
var first_flake = inst_43566;
var node_t = inst_43567;
var source = inst_43582;
var coll = inst_43595;
return (function (f){
return f.op === true;
});
})();
var state_43613__$1 = state_43613;
var statearr_43627_43671 = state_43613__$1;
(statearr_43627_43671[(2)] = inst_43596);

(statearr_43627_43671[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (6))){
var inst_43567 = (state_43613[(9)]);
var inst_43565 = (state_43613[(12)]);
var inst_43564 = (state_43613[(2)]);
var inst_43565__$1 = fluree.db.util.async.throw_err(inst_43564);
var inst_43566 = fluree.db.dbproto._first_flake(inst_43565__$1);
var inst_43567__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_43565__$1);
var inst_43568 = (inst_43567__$1 > t);
var state_43613__$1 = (function (){var statearr_43628 = state_43613;
(statearr_43628[(9)] = inst_43567__$1);

(statearr_43628[(10)] = inst_43566);

(statearr_43628[(12)] = inst_43565__$1);

return statearr_43628;
})();
if(cljs.core.truth_(inst_43568)){
var statearr_43629_43672 = state_43613__$1;
(statearr_43629_43672[(1)] = (7));

} else {
var statearr_43630_43673 = state_43613__$1;
(statearr_43630_43673[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (17))){
var inst_43566 = (state_43613[(10)]);
var inst_43583 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_43566,rhs,leftmost_QMARK_,t);
var state_43613__$1 = state_43613;
var statearr_43631_43674 = state_43613__$1;
(statearr_43631_43674[(2)] = inst_43583);

(statearr_43631_43674[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (3))){
var inst_43611 = (state_43613[(2)]);
var state_43613__$1 = state_43613;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43613__$1,inst_43611);
} else {
if((state_val_43614 === (12))){
var inst_43580 = (state_43613[(2)]);
var state_43613__$1 = state_43613;
var statearr_43632_43675 = state_43613__$1;
(statearr_43632_43675[(2)] = inst_43580);

(statearr_43632_43675[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (2))){
var _ = (function (){var statearr_43633 = state_43613;
(statearr_43633[(4)] = cljs.core.cons((5),(state_43613[(4)])));

return statearr_43633;
})();
var inst_43562 = fluree.db.dbproto._resolve(node);
var state_43613__$1 = state_43613;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43613__$1,(6),inst_43562);
} else {
if((state_val_43614 === (23))){
var inst_43567 = (state_43613[(9)]);
var inst_43566 = (state_43613[(10)]);
var inst_43595 = (state_43613[(11)]);
var inst_43565 = (state_43613[(12)]);
var inst_43582 = (state_43613[(13)]);
var inst_43598 = (function (){var base_node = inst_43565;
var first_flake = inst_43566;
var node_t = inst_43567;
var source = inst_43582;
var coll = inst_43595;
return (function (f){
return f.op === false;
});
})();
var state_43613__$1 = state_43613;
var statearr_43634_43676 = state_43613__$1;
(statearr_43634_43676[(2)] = inst_43598);

(statearr_43634_43676[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (19))){
var inst_43585 = (state_43613[(14)]);
var inst_43588 = (state_43613[(2)]);
var inst_43589 = fluree.db.util.async.throw_err(inst_43588);
var inst_43590 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_43585,inst_43589);
var state_43613__$1 = state_43613;
var statearr_43635_43677 = state_43613__$1;
(statearr_43635_43677[(2)] = inst_43590);

(statearr_43635_43677[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (11))){
var inst_43567 = (state_43613[(9)]);
var inst_43574 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_43567,t);
var state_43613__$1 = state_43613;
if(inst_43574){
var statearr_43637_43678 = state_43613__$1;
(statearr_43637_43678[(1)] = (13));

} else {
var statearr_43638_43679 = state_43613__$1;
(statearr_43638_43679[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (9))){
var inst_43582 = (state_43613[(13)]);
var inst_43582__$1 = (state_43613[(2)]);
var state_43613__$1 = (function (){var statearr_43639 = state_43613;
(statearr_43639[(13)] = inst_43582__$1);

return statearr_43639;
})();
var G__43640_43680 = inst_43582__$1;
var G__43640_43681__$1 = (((G__43640_43680 instanceof cljs.core.Keyword))?G__43640_43680.fqn:null);
switch (G__43640_43681__$1) {
case "novelty":
var statearr_43641_43683 = state_43613__$1;
(statearr_43641_43683[(1)] = (17));


break;
case "history":
var statearr_43642_43684 = state_43613__$1;
(statearr_43642_43684[(1)] = (18));


break;
case "none":
var statearr_43643_43685 = state_43613__$1;
(statearr_43643_43685[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43640_43681__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (5))){
var _ = (function (){var statearr_43644 = state_43613;
(statearr_43644[(4)] = cljs.core.rest((state_43613[(4)])));

return statearr_43644;
})();
var state_43613__$1 = state_43613;
var ex43636 = (state_43613__$1[(2)]);
var statearr_43645_43686 = state_43613__$1;
(statearr_43645_43686[(5)] = ex43636);


var statearr_43646_43687 = state_43613__$1;
(statearr_43646_43687[(1)] = (4));

(statearr_43646_43687[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (14))){
var state_43613__$1 = state_43613;
var statearr_43647_43688 = state_43613__$1;
(statearr_43647_43688[(2)] = null);

(statearr_43647_43688[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (16))){
var inst_43582 = (state_43613[(13)]);
var inst_43595 = (state_43613[(2)]);
var state_43613__$1 = (function (){var statearr_43648 = state_43613;
(statearr_43648[(11)] = inst_43595);

return statearr_43648;
})();
var G__43649_43689 = inst_43582;
var G__43649_43690__$1 = (((G__43649_43689 instanceof cljs.core.Keyword))?G__43649_43689.fqn:null);
switch (G__43649_43690__$1) {
case "novelty":
var statearr_43650_43692 = state_43613__$1;
(statearr_43650_43692[(1)] = (22));


break;
case "history":
var statearr_43651_43693 = state_43613__$1;
(statearr_43651_43693[(1)] = (23));


break;
case "none":
var statearr_43652_43694 = state_43613__$1;
(statearr_43652_43694[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__43649_43690__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (10))){
var state_43613__$1 = state_43613;
var statearr_43653_43695 = state_43613__$1;
(statearr_43653_43695[(2)] = cljs.core.cst$kw$history);

(statearr_43653_43695[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43614 === (18))){
var inst_43567 = (state_43613[(9)]);
var inst_43566 = (state_43613[(10)]);
var inst_43565 = (state_43613[(12)]);
var inst_43582 = (state_43613[(13)]);
var inst_43585 = (function (){var base_node = inst_43565;
var first_flake = inst_43566;
var node_t = inst_43567;
var source = inst_43582;
return (function (p1__43552_SHARP_){
return (p1__43552_SHARP_.t <= t);
});
})();
var inst_43586 = fluree.db.dbproto._resolve_history(node);
var state_43613__$1 = (function (){var statearr_43654 = state_43613;
(statearr_43654[(14)] = inst_43585);

return statearr_43654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43613__$1,(19),inst_43586);
} else {
if((state_val_43614 === (8))){
var inst_43567 = (state_43613[(9)]);
var inst_43571 = (inst_43567 < t);
var state_43613__$1 = state_43613;
if(cljs.core.truth_(inst_43571)){
var statearr_43655_43696 = state_43613__$1;
(statearr_43655_43696[(1)] = (10));

} else {
var statearr_43656_43697 = state_43613__$1;
(statearr_43656_43697[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____0 = (function (){
var statearr_43657 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43657[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__);

(statearr_43657[(1)] = (1));

return statearr_43657;
});
var fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____1 = (function (state_43613){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43613);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43658){var ex__24301__auto__ = e43658;
var statearr_43659_43698 = state_43613;
(statearr_43659_43698[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43613[(4)]))){
var statearr_43660_43699 = state_43613;
(statearr_43660_43699[(1)] = cljs.core.first((state_43613[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43700 = state_43613;
state_43613 = G__43700;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__ = function(state_43613){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____1.call(this,state_43613);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__24298__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43661 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43661[(6)] = c__24424__auto___43662);

return statearr_43661;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43760){
var state_val_43761 = (state_43760[(1)]);
if((state_val_43761 === (7))){
var inst_43711 = (state_43760[(7)]);
var inst_43715 = (inst_43711 <= from_t);
var state_43760__$1 = state_43760;
var statearr_43762_43802 = state_43760__$1;
(statearr_43762_43802[(2)] = inst_43715);

(statearr_43762_43802[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (20))){
var inst_43745 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_43746 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43745)].join('');
var inst_43747 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43748 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_43749 = cljs.core.PersistentHashMap.fromArrays(inst_43747,inst_43748);
var inst_43750 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43746,inst_43749);
var inst_43751 = (function(){throw inst_43750})();
var state_43760__$1 = state_43760;
var statearr_43763_43803 = state_43760__$1;
(statearr_43763_43803[(2)] = inst_43751);

(statearr_43763_43803[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (1))){
var state_43760__$1 = state_43760;
var statearr_43764_43804 = state_43760__$1;
(statearr_43764_43804[(2)] = null);

(statearr_43764_43804[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (4))){
var inst_43703 = (state_43760[(2)]);
var inst_43704 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_43703], 0));
var inst_43705 = (function(){throw inst_43703})();
var state_43760__$1 = (function (){var statearr_43765 = state_43760;
(statearr_43765[(8)] = inst_43704);

return statearr_43765;
})();
var statearr_43766_43805 = state_43760__$1;
(statearr_43766_43805[(2)] = inst_43705);

(statearr_43766_43805[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (15))){
var inst_43730 = (state_43760[(2)]);
var state_43760__$1 = (function (){var statearr_43767 = state_43760;
(statearr_43767[(9)] = inst_43730);

return statearr_43767;
})();
if(cljs.core.truth_(from_t)){
var statearr_43768_43806 = state_43760__$1;
(statearr_43768_43806[(1)] = (16));

} else {
var statearr_43769_43807 = state_43760__$1;
(statearr_43769_43807[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (21))){
var inst_43740 = (state_43760[(10)]);
var inst_43739 = (state_43760[(11)]);
var inst_43741 = (state_43760[(12)]);
var inst_43753 = (state_43760[(2)]);
var inst_43754 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_43740,inst_43741,leftmost_QMARK_,to_t);
var inst_43755 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_43754,inst_43739);
var _ = (function (){var statearr_43770 = state_43760;
(statearr_43770[(4)] = cljs.core.rest((state_43760[(4)])));

return statearr_43770;
})();
var state_43760__$1 = (function (){var statearr_43771 = state_43760;
(statearr_43771[(13)] = inst_43753);

return statearr_43771;
})();
var statearr_43772_43808 = state_43760__$1;
(statearr_43772_43808[(2)] = inst_43755);

(statearr_43772_43808[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (13))){
var inst_43723 = (state_43760[(14)]);
var inst_43711 = (state_43760[(7)]);
var inst_43726 = (function (){var node_t = inst_43711;
var G__43719 = inst_43723;
return (function (p1__43701_SHARP_){
return (p1__43701_SHARP_.t < to_t);
});
})();
var inst_43727 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_43726,inst_43723);
var state_43760__$1 = state_43760;
var statearr_43773_43809 = state_43760__$1;
(statearr_43773_43809[(2)] = inst_43727);

(statearr_43773_43809[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (6))){
var inst_43712 = (state_43760[(15)]);
var state_43760__$1 = state_43760;
var statearr_43774_43810 = state_43760__$1;
(statearr_43774_43810[(2)] = inst_43712);

(statearr_43774_43810[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (17))){
var inst_43730 = (state_43760[(9)]);
var state_43760__$1 = state_43760;
var statearr_43775_43811 = state_43760__$1;
(statearr_43775_43811[(2)] = inst_43730);

(statearr_43775_43811[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (3))){
var inst_43758 = (state_43760[(2)]);
var state_43760__$1 = state_43760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43760__$1,inst_43758);
} else {
if((state_val_43761 === (12))){
var inst_43711 = (state_43760[(7)]);
var inst_43722 = (state_43760[(2)]);
var inst_43723 = fluree.db.util.async.throw_err(inst_43722);
var inst_43724 = (to_t > inst_43711);
var state_43760__$1 = (function (){var statearr_43776 = state_43760;
(statearr_43776[(14)] = inst_43723);

return statearr_43776;
})();
if(cljs.core.truth_(inst_43724)){
var statearr_43777_43812 = state_43760__$1;
(statearr_43777_43812[(1)] = (13));

} else {
var statearr_43778_43813 = state_43760__$1;
(statearr_43778_43813[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (2))){
var inst_43712 = (state_43760[(15)]);
var _ = (function (){var statearr_43779 = state_43760;
(statearr_43779[(4)] = cljs.core.cons((5),(state_43760[(4)])));

return statearr_43779;
})();
var inst_43711 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_43712__$1 = (from_t == null);
var state_43760__$1 = (function (){var statearr_43780 = state_43760;
(statearr_43780[(15)] = inst_43712__$1);

(statearr_43780[(7)] = inst_43711);

return statearr_43780;
})();
if(cljs.core.truth_(inst_43712__$1)){
var statearr_43781_43814 = state_43760__$1;
(statearr_43781_43814[(1)] = (6));

} else {
var statearr_43782_43815 = state_43760__$1;
(statearr_43782_43815[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (19))){
var state_43760__$1 = state_43760;
var statearr_43783_43816 = state_43760__$1;
(statearr_43783_43816[(2)] = null);

(statearr_43783_43816[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (11))){
var inst_43739 = (state_43760[(2)]);
var inst_43740 = fluree.db.dbproto._first_flake(node);
var inst_43741 = fluree.db.dbproto._rhs(node);
var inst_43742 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_43760__$1 = (function (){var statearr_43785 = state_43760;
(statearr_43785[(10)] = inst_43740);

(statearr_43785[(11)] = inst_43739);

(statearr_43785[(12)] = inst_43741);

return statearr_43785;
})();
if(cljs.core.truth_(inst_43742)){
var statearr_43786_43817 = state_43760__$1;
(statearr_43786_43817[(1)] = (19));

} else {
var statearr_43787_43818 = state_43760__$1;
(statearr_43787_43818[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (9))){
var inst_43720 = fluree.db.dbproto._resolve_history(node);
var state_43760__$1 = state_43760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43760__$1,(12),inst_43720);
} else {
if((state_val_43761 === (5))){
var _ = (function (){var statearr_43788 = state_43760;
(statearr_43788[(4)] = cljs.core.rest((state_43760[(4)])));

return statearr_43788;
})();
var state_43760__$1 = state_43760;
var ex43784 = (state_43760__$1[(2)]);
var statearr_43789_43819 = state_43760__$1;
(statearr_43789_43819[(5)] = ex43784);


var statearr_43790_43820 = state_43760__$1;
(statearr_43790_43820[(1)] = (4));

(statearr_43790_43820[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (14))){
var inst_43723 = (state_43760[(14)]);
var state_43760__$1 = state_43760;
var statearr_43791_43821 = state_43760__$1;
(statearr_43791_43821[(2)] = inst_43723);

(statearr_43791_43821[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (16))){
var inst_43730 = (state_43760[(9)]);
var inst_43711 = (state_43760[(7)]);
var inst_43732 = (function (){var node_t = inst_43711;
var G__43719 = inst_43730;
return (function (p1__43702_SHARP_){
return (p1__43702_SHARP_.t <= from_t);
});
})();
var inst_43733 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_43732,inst_43730);
var state_43760__$1 = state_43760;
var statearr_43792_43822 = state_43760__$1;
(statearr_43792_43822[(2)] = inst_43733);

(statearr_43792_43822[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (10))){
var state_43760__$1 = state_43760;
var statearr_43793_43823 = state_43760__$1;
(statearr_43793_43823[(2)] = null);

(statearr_43793_43823[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (18))){
var inst_43736 = (state_43760[(2)]);
var state_43760__$1 = state_43760;
var statearr_43794_43824 = state_43760__$1;
(statearr_43794_43824[(2)] = inst_43736);

(statearr_43794_43824[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43761 === (8))){
var inst_43717 = (state_43760[(2)]);
var state_43760__$1 = state_43760;
if(cljs.core.truth_(inst_43717)){
var statearr_43795_43825 = state_43760__$1;
(statearr_43795_43825[(1)] = (9));

} else {
var statearr_43796_43826 = state_43760__$1;
(statearr_43796_43826[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____0 = (function (){
var statearr_43797 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43797[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__);

(statearr_43797[(1)] = (1));

return statearr_43797;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____1 = (function (state_43760){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43760);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43798){var ex__24301__auto__ = e43798;
var statearr_43799_43827 = state_43760;
(statearr_43799_43827[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43760[(4)]))){
var statearr_43800_43828 = state_43760;
(statearr_43800_43828[(1)] = cljs.core.first((state_43760[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43829 = state_43760;
state_43760 = G__43829;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__ = function(state_43760){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____1.call(this,state_43760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43801 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43801[(6)] = c__24424__auto__);

return statearr_43801;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__43830_43840 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__43831_43841 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__43830_43840,G__43831_43841) : object_cache.call(null,G__43830_43840,G__43831_43841));

var G__43832 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__43833 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__43834 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__43835 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__43834,G__43835) : object_cache.call(null,G__43834,G__43835));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__43832,G__43833) : object_cache.call(null,G__43832,G__43833));
} else {
var G__43836 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__43837 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__43838 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__43839 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__43838,G__43839) : object_cache.call(null,G__43838,G__43839));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__43836,G__43837) : object_cache.call(null,G__43836,G__43837));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43862){
var state_val_43863 = (state_43862[(1)]);
if((state_val_43863 === (7))){
var state_43862__$1 = state_43862;
var statearr_43864_43884 = state_43862__$1;
(statearr_43864_43884[(2)] = null);

(statearr_43864_43884[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (1))){
var state_43862__$1 = state_43862;
var statearr_43865_43885 = state_43862__$1;
(statearr_43865_43885[(2)] = null);

(statearr_43865_43885[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (4))){
var inst_43842 = (state_43862[(2)]);
var state_43862__$1 = state_43862;
var statearr_43866_43886 = state_43862__$1;
(statearr_43866_43886[(2)] = inst_43842);

(statearr_43866_43886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (6))){
var inst_43848 = (state_43862[(7)]);
var inst_43850 = fluree.db.storage.core.serde(conn);
var state_43862__$1 = (function (){var statearr_43867 = state_43862;
(statearr_43867[(8)] = inst_43850);

return statearr_43867;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43862__$1,(9),inst_43848);
} else {
if((state_val_43863 === (3))){
var inst_43860 = (state_43862[(2)]);
var state_43862__$1 = state_43862;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43862__$1,inst_43860);
} else {
if((state_val_43863 === (2))){
var inst_43848 = (state_43862[(7)]);
var _ = (function (){var statearr_43869 = state_43862;
(statearr_43869[(4)] = cljs.core.cons((5),(state_43862[(4)])));

return statearr_43869;
})();
var inst_43848__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_43862__$1 = (function (){var statearr_43870 = state_43862;
(statearr_43870[(7)] = inst_43848__$1);

return statearr_43870;
})();
if(cljs.core.truth_(inst_43848__$1)){
var statearr_43871_43887 = state_43862__$1;
(statearr_43871_43887[(1)] = (6));

} else {
var statearr_43872_43888 = state_43862__$1;
(statearr_43872_43888[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (9))){
var inst_43850 = (state_43862[(8)]);
var inst_43852 = (state_43862[(2)]);
var inst_43853 = fluree.db.util.async.throw_err(inst_43852);
var inst_43854 = fluree.db.serde.protocol._deserialize_branch(inst_43850,inst_43853);
var state_43862__$1 = state_43862;
var statearr_43873_43889 = state_43862__$1;
(statearr_43873_43889[(2)] = inst_43854);

(statearr_43873_43889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (5))){
var _ = (function (){var statearr_43874 = state_43862;
(statearr_43874[(4)] = cljs.core.rest((state_43862[(4)])));

return statearr_43874;
})();
var state_43862__$1 = state_43862;
var ex43868 = (state_43862__$1[(2)]);
var statearr_43875_43890 = state_43862__$1;
(statearr_43875_43890[(5)] = ex43868);


if((ex43868 instanceof Error)){
var statearr_43876_43891 = state_43862__$1;
(statearr_43876_43891[(1)] = (4));

(statearr_43876_43891[(5)] = null);

} else {
throw ex43868;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43863 === (8))){
var inst_43857 = (state_43862[(2)]);
var _ = (function (){var statearr_43877 = state_43862;
(statearr_43877[(4)] = cljs.core.rest((state_43862[(4)])));

return statearr_43877;
})();
var state_43862__$1 = state_43862;
var statearr_43878_43892 = state_43862__$1;
(statearr_43878_43892[(2)] = inst_43857);

(statearr_43878_43892[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__24298__auto____0 = (function (){
var statearr_43879 = [null,null,null,null,null,null,null,null,null];
(statearr_43879[(0)] = fluree$db$storage$core$read_branch_$_state_machine__24298__auto__);

(statearr_43879[(1)] = (1));

return statearr_43879;
});
var fluree$db$storage$core$read_branch_$_state_machine__24298__auto____1 = (function (state_43862){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43862);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43880){var ex__24301__auto__ = e43880;
var statearr_43881_43893 = state_43862;
(statearr_43881_43893[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43862[(4)]))){
var statearr_43882_43894 = state_43862;
(statearr_43882_43894[(1)] = cljs.core.first((state_43862[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43895 = state_43862;
state_43862 = G__43895;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__24298__auto__ = function(state_43862){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__24298__auto____1.call(this,state_43862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43883 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43883[(6)] = c__24424__auto__);

return statearr_43883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___43974 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_43946){
var state_val_43947 = (state_43946[(1)]);
if((state_val_43947 === (7))){
var inst_43913 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_43914 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43915 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_43916 = cljs.core.PersistentHashMap.fromArrays(inst_43914,inst_43915);
var inst_43917 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43913,inst_43916);
var inst_43918 = (function(){throw inst_43917})();
var state_43946__$1 = state_43946;
var statearr_43948_43975 = state_43946__$1;
(statearr_43948_43975[(2)] = inst_43918);

(statearr_43948_43975[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (1))){
var state_43946__$1 = state_43946;
var statearr_43949_43976 = state_43946__$1;
(statearr_43949_43976[(2)] = null);

(statearr_43949_43976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (4))){
var inst_43896 = (state_43946[(2)]);
var inst_43897 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_43898 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_43896);
var inst_43899 = cljs.core.async.close_BANG_(return_ch);
var state_43946__$1 = (function (){var statearr_43950 = state_43946;
(statearr_43950[(7)] = inst_43898);

(statearr_43950[(8)] = inst_43897);

return statearr_43950;
})();
var statearr_43951_43977 = state_43946__$1;
(statearr_43951_43977[(2)] = inst_43899);

(statearr_43951_43977[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (6))){
var inst_43910 = (state_43946[(9)]);
var inst_43909 = (state_43946[(2)]);
var inst_43910__$1 = fluree.db.util.async.throw_err(inst_43909);
var inst_43911 = (inst_43910__$1 == null);
var state_43946__$1 = (function (){var statearr_43952 = state_43946;
(statearr_43952[(9)] = inst_43910__$1);

return statearr_43952;
})();
if(cljs.core.truth_(inst_43911)){
var statearr_43953_43978 = state_43946__$1;
(statearr_43953_43978[(1)] = (7));

} else {
var statearr_43954_43979 = state_43946__$1;
(statearr_43954_43979[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (3))){
var inst_43944 = (state_43946[(2)]);
var state_43946__$1 = state_43946;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43946__$1,inst_43944);
} else {
if((state_val_43947 === (12))){
var inst_43910 = (state_43946[(9)]);
var inst_43927 = (state_43946[(2)]);
var inst_43928 = cljs.core.__destructure_map(inst_43910);
var inst_43929 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43928,cljs.core.cst$kw$children);
var inst_43930 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43928,cljs.core.cst$kw$rhs);
var inst_43931 = config;
var inst_43932 = cljs.core.__destructure_map(inst_43931);
var inst_43933 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_43932,cljs.core.cst$kw$comparator);
var inst_43935 = (function (){var data = inst_43910;
var _ = inst_43927;
var map__43905 = inst_43928;
var children = inst_43929;
var rhs = inst_43930;
var map__43906 = inst_43932;
var comparator = inst_43933;
return (function (idx,p__43934){
var map__43955 = p__43934;
var map__43955__$1 = cljs.core.__destructure_map(map__43955);
var child = map__43955__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43955__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43955__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43955__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43955__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43955__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_43936 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_43935,inst_43929);
var inst_43937 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_43936);
var inst_43938 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_43937,inst_43936);
var inst_43939 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_43933,inst_43938);
var inst_43940 = fluree.db.index.__GT_IndexNode(block,t,inst_43930,inst_43939,config,leftmost_QMARK_);
var inst_43941 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_43940);
var _ = (function (){var statearr_43956 = state_43946;
(statearr_43956[(4)] = cljs.core.rest((state_43946[(4)])));

return statearr_43956;
})();
var state_43946__$1 = state_43946;
var statearr_43957_43980 = state_43946__$1;
(statearr_43957_43980[(2)] = inst_43941);

(statearr_43957_43980[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (2))){
var _ = (function (){var statearr_43958 = state_43946;
(statearr_43958[(4)] = cljs.core.cons((5),(state_43946[(4)])));

return statearr_43958;
})();
var inst_43907 = fluree.db.storage.core.read_branch(conn,key);
var state_43946__$1 = state_43946;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43946__$1,(6),inst_43907);
} else {
if((state_val_43947 === (11))){
var state_43946__$1 = state_43946;
var statearr_43960_43981 = state_43946__$1;
(statearr_43960_43981[(2)] = null);

(statearr_43960_43981[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (9))){
var inst_43910 = (state_43946[(9)]);
var inst_43921 = (state_43946[(2)]);
var inst_43922 = fluree.db.util.core.exception_QMARK_(inst_43910);
var state_43946__$1 = (function (){var statearr_43961 = state_43946;
(statearr_43961[(10)] = inst_43921);

return statearr_43961;
})();
if(inst_43922){
var statearr_43962_43982 = state_43946__$1;
(statearr_43962_43982[(1)] = (10));

} else {
var statearr_43963_43983 = state_43946__$1;
(statearr_43963_43983[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (5))){
var _ = (function (){var statearr_43964 = state_43946;
(statearr_43964[(4)] = cljs.core.rest((state_43946[(4)])));

return statearr_43964;
})();
var state_43946__$1 = state_43946;
var ex43959 = (state_43946__$1[(2)]);
var statearr_43965_43984 = state_43946__$1;
(statearr_43965_43984[(5)] = ex43959);


var statearr_43966_43985 = state_43946__$1;
(statearr_43966_43985[(1)] = (4));

(statearr_43966_43985[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (10))){
var inst_43910 = (state_43946[(9)]);
var inst_43924 = (function(){throw inst_43910})();
var state_43946__$1 = state_43946;
var statearr_43967_43986 = state_43946__$1;
(statearr_43967_43986[(2)] = inst_43924);

(statearr_43967_43986[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43947 === (8))){
var state_43946__$1 = state_43946;
var statearr_43968_43987 = state_43946__$1;
(statearr_43968_43987[(2)] = null);

(statearr_43968_43987[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____0 = (function (){
var statearr_43969 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_43969[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__);

(statearr_43969[(1)] = (1));

return statearr_43969;
});
var fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____1 = (function (state_43946){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_43946);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e43970){var ex__24301__auto__ = e43970;
var statearr_43971_43988 = state_43946;
(statearr_43971_43988[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_43946[(4)]))){
var statearr_43972_43989 = state_43946;
(statearr_43972_43989[(1)] = cljs.core.first((state_43946[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__43990 = state_43946;
state_43946 = G__43990;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__ = function(state_43946){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____1.call(this,state_43946);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__24298__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_43973 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_43973[(6)] = c__24424__auto___43974);

return statearr_43973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44011){
var state_val_44012 = (state_44011[(1)]);
if((state_val_44012 === (7))){
var state_44011__$1 = state_44011;
var statearr_44013_44033 = state_44011__$1;
(statearr_44013_44033[(2)] = null);

(statearr_44013_44033[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (1))){
var state_44011__$1 = state_44011;
var statearr_44014_44034 = state_44011__$1;
(statearr_44014_44034[(2)] = null);

(statearr_44014_44034[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (4))){
var inst_43991 = (state_44011[(2)]);
var state_44011__$1 = state_44011;
var statearr_44015_44035 = state_44011__$1;
(statearr_44015_44035[(2)] = inst_43991);

(statearr_44015_44035[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (6))){
var inst_43997 = (state_44011[(7)]);
var inst_43999 = fluree.db.storage.core.serde(conn);
var state_44011__$1 = (function (){var statearr_44016 = state_44011;
(statearr_44016[(8)] = inst_43999);

return statearr_44016;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44011__$1,(9),inst_43997);
} else {
if((state_val_44012 === (3))){
var inst_44009 = (state_44011[(2)]);
var state_44011__$1 = state_44011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44011__$1,inst_44009);
} else {
if((state_val_44012 === (2))){
var inst_43997 = (state_44011[(7)]);
var _ = (function (){var statearr_44018 = state_44011;
(statearr_44018[(4)] = cljs.core.cons((5),(state_44011[(4)])));

return statearr_44018;
})();
var inst_43997__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_44011__$1 = (function (){var statearr_44019 = state_44011;
(statearr_44019[(7)] = inst_43997__$1);

return statearr_44019;
})();
if(cljs.core.truth_(inst_43997__$1)){
var statearr_44020_44036 = state_44011__$1;
(statearr_44020_44036[(1)] = (6));

} else {
var statearr_44021_44037 = state_44011__$1;
(statearr_44021_44037[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (9))){
var inst_43999 = (state_44011[(8)]);
var inst_44001 = (state_44011[(2)]);
var inst_44002 = fluree.db.util.async.throw_err(inst_44001);
var inst_44003 = fluree.db.serde.protocol._deserialize_leaf(inst_43999,inst_44002);
var state_44011__$1 = state_44011;
var statearr_44022_44038 = state_44011__$1;
(statearr_44022_44038[(2)] = inst_44003);

(statearr_44022_44038[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (5))){
var _ = (function (){var statearr_44023 = state_44011;
(statearr_44023[(4)] = cljs.core.rest((state_44011[(4)])));

return statearr_44023;
})();
var state_44011__$1 = state_44011;
var ex44017 = (state_44011__$1[(2)]);
var statearr_44024_44039 = state_44011__$1;
(statearr_44024_44039[(5)] = ex44017);


if((ex44017 instanceof Error)){
var statearr_44025_44040 = state_44011__$1;
(statearr_44025_44040[(1)] = (4));

(statearr_44025_44040[(5)] = null);

} else {
throw ex44017;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44012 === (8))){
var inst_44006 = (state_44011[(2)]);
var _ = (function (){var statearr_44026 = state_44011;
(statearr_44026[(4)] = cljs.core.rest((state_44011[(4)])));

return statearr_44026;
})();
var state_44011__$1 = state_44011;
var statearr_44027_44041 = state_44011__$1;
(statearr_44027_44041[(2)] = inst_44006);

(statearr_44027_44041[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____0 = (function (){
var statearr_44028 = [null,null,null,null,null,null,null,null,null];
(statearr_44028[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__);

(statearr_44028[(1)] = (1));

return statearr_44028;
});
var fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____1 = (function (state_44011){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44011);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44029){var ex__24301__auto__ = e44029;
var statearr_44030_44042 = state_44011;
(statearr_44030_44042[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44011[(4)]))){
var statearr_44031_44043 = state_44011;
(statearr_44031_44043[(1)] = cljs.core.first((state_44011[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44044 = state_44011;
state_44011 = G__44044;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__ = function(state_44011){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____1.call(this,state_44011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44032 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44032[(6)] = c__24424__auto__);

return statearr_44032;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__24424__auto___44117 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44089){
var state_val_44090 = (state_44089[(1)]);
if((state_val_44090 === (7))){
var inst_44061 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_44062 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_44063 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_44064 = cljs.core.PersistentHashMap.fromArrays(inst_44062,inst_44063);
var inst_44065 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_44061,inst_44064);
var inst_44066 = (function(){throw inst_44065})();
var state_44089__$1 = state_44089;
var statearr_44091_44118 = state_44089__$1;
(statearr_44091_44118[(2)] = inst_44066);

(statearr_44091_44118[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (1))){
var state_44089__$1 = state_44089;
var statearr_44092_44119 = state_44089__$1;
(statearr_44092_44119[(2)] = null);

(statearr_44092_44119[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (4))){
var inst_44045 = (state_44089[(2)]);
var inst_44046 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_44047 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_44045);
var inst_44048 = cljs.core.async.close_BANG_(return_ch);
var state_44089__$1 = (function (){var statearr_44093 = state_44089;
(statearr_44093[(7)] = inst_44046);

(statearr_44093[(8)] = inst_44047);

return statearr_44093;
})();
var statearr_44094_44120 = state_44089__$1;
(statearr_44094_44120[(2)] = inst_44048);

(statearr_44094_44120[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (6))){
var inst_44058 = (state_44089[(9)]);
var inst_44058__$1 = (state_44089[(2)]);
var inst_44059 = (inst_44058__$1 == null);
var state_44089__$1 = (function (){var statearr_44095 = state_44089;
(statearr_44095[(9)] = inst_44058__$1);

return statearr_44095;
})();
if(cljs.core.truth_(inst_44059)){
var statearr_44096_44121 = state_44089__$1;
(statearr_44096_44121[(1)] = (7));

} else {
var statearr_44097_44122 = state_44089__$1;
(statearr_44097_44122[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (3))){
var inst_44087 = (state_44089[(2)]);
var state_44089__$1 = state_44089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44089__$1,inst_44087);
} else {
if((state_val_44090 === (12))){
var inst_44058 = (state_44089[(9)]);
var inst_44075 = (state_44089[(2)]);
var inst_44076 = cljs.core.__destructure_map(inst_44058);
var inst_44077 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44076,cljs.core.cst$kw$flakes);
var inst_44078 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44076,cljs.core.cst$kw$his);
var inst_44079 = config;
var inst_44080 = cljs.core.__destructure_map(inst_44079);
var inst_44081 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_44080,cljs.core.cst$kw$comparator);
var inst_44082 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_44081,inst_44077);
var inst_44083 = fluree.db.index.data_node(block,t,inst_44082,rhs,config);
var inst_44084 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_44083);
var _ = (function (){var statearr_44098 = state_44089;
(statearr_44098[(4)] = cljs.core.rest((state_44089[(4)])));

return statearr_44098;
})();
var state_44089__$1 = (function (){var statearr_44099 = state_44089;
(statearr_44099[(10)] = inst_44078);

(statearr_44099[(11)] = inst_44075);

return statearr_44099;
})();
var statearr_44100_44123 = state_44089__$1;
(statearr_44100_44123[(2)] = inst_44084);

(statearr_44100_44123[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (2))){
var _ = (function (){var statearr_44101 = state_44089;
(statearr_44101[(4)] = cljs.core.cons((5),(state_44089[(4)])));

return statearr_44101;
})();
var inst_44056 = fluree.db.storage.core.read_leaf(conn,key);
var state_44089__$1 = state_44089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44089__$1,(6),inst_44056);
} else {
if((state_val_44090 === (11))){
var state_44089__$1 = state_44089;
var statearr_44103_44124 = state_44089__$1;
(statearr_44103_44124[(2)] = null);

(statearr_44103_44124[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (9))){
var inst_44058 = (state_44089[(9)]);
var inst_44069 = (state_44089[(2)]);
var inst_44070 = fluree.db.util.core.exception_QMARK_(inst_44058);
var state_44089__$1 = (function (){var statearr_44104 = state_44089;
(statearr_44104[(12)] = inst_44069);

return statearr_44104;
})();
if(inst_44070){
var statearr_44105_44125 = state_44089__$1;
(statearr_44105_44125[(1)] = (10));

} else {
var statearr_44106_44126 = state_44089__$1;
(statearr_44106_44126[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (5))){
var _ = (function (){var statearr_44107 = state_44089;
(statearr_44107[(4)] = cljs.core.rest((state_44089[(4)])));

return statearr_44107;
})();
var state_44089__$1 = state_44089;
var ex44102 = (state_44089__$1[(2)]);
var statearr_44108_44127 = state_44089__$1;
(statearr_44108_44127[(5)] = ex44102);


var statearr_44109_44128 = state_44089__$1;
(statearr_44109_44128[(1)] = (4));

(statearr_44109_44128[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (10))){
var inst_44058 = (state_44089[(9)]);
var inst_44072 = (function(){throw inst_44058})();
var state_44089__$1 = state_44089;
var statearr_44110_44129 = state_44089__$1;
(statearr_44110_44129[(2)] = inst_44072);

(statearr_44110_44129[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44090 === (8))){
var state_44089__$1 = state_44089;
var statearr_44111_44130 = state_44089__$1;
(statearr_44111_44130[(2)] = null);

(statearr_44111_44130[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____0 = (function (){
var statearr_44112 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44112[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__);

(statearr_44112[(1)] = (1));

return statearr_44112;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____1 = (function (state_44089){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44089);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44113){var ex__24301__auto__ = e44113;
var statearr_44114_44131 = state_44089;
(statearr_44114_44131[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44089[(4)]))){
var statearr_44115_44132 = state_44089;
(statearr_44115_44132[(1)] = cljs.core.first((state_44089[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44133 = state_44089;
state_44089 = G__44133;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__ = function(state_44089){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____1.call(this,state_44089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44116 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44116[(6)] = c__24424__auto___44117);

return statearr_44116;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k44135,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__44139 = k44135;
var G__44139__$1 = (((G__44139 instanceof cljs.core.Keyword))?G__44139.fqn:null);
switch (G__44139__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k44135,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__44140){
var vec__44141 = p__44140;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44141,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44141,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__44134){
var self__ = this;
var G__44134__$1 = this;
return (new cljs.core.RecordIter((0),G__44134__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__44144 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__44145 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__44146 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__44147 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__44146,G__44147) : object_cache.call(null,G__44146,G__44147));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__44148 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__44149 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__44148,G__44149) : object_cache.call(null,G__44148,G__44149));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__44144,G__44145) : object_cache.call(null,G__44144,G__44145));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__44150 = history_id;
var G__44151 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__44150,G__44151) : object_cache.call(null,G__44150,G__44151));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__44152 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__44152(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this44136,other44137){
var self__ = this;
var this44136__$1 = this;
return (((!((other44137 == null)))) && ((((this44136__$1.constructor === other44137.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.conn,other44137.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.config,other44137.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.network,other44137.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.dbid,other44137.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.id,other44137.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.leaf,other44137.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.first,other44137.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.rhs,other44137.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.size,other44137.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.block,other44137.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.t,other44137.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.tt_id,other44137.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.leftmost_QMARK_,other44137.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.tempid,other44137.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this44136__$1.__extmap,other44137.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k44135){
var self__ = this;
var this__4468__auto____$1 = this;
var G__44153 = k44135;
var G__44153__$1 = (((G__44153 instanceof cljs.core.Keyword))?G__44153.fqn:null);
switch (G__44153__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k44135);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__44134){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__44154 = cljs.core.keyword_identical_QMARK_;
var expr__44155 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__44157 = cljs.core.cst$kw$conn;
var G__44158 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44157,G__44158) : pred__44154.call(null,G__44157,G__44158));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__44134,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44159 = cljs.core.cst$kw$config;
var G__44160 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44159,G__44160) : pred__44154.call(null,G__44159,G__44160));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__44134,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44161 = cljs.core.cst$kw$network;
var G__44162 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44161,G__44162) : pred__44154.call(null,G__44161,G__44162));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__44134,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44163 = cljs.core.cst$kw$dbid;
var G__44164 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44163,G__44164) : pred__44154.call(null,G__44163,G__44164));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__44134,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44165 = cljs.core.cst$kw$id;
var G__44166 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44165,G__44166) : pred__44154.call(null,G__44165,G__44166));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__44134,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44167 = cljs.core.cst$kw$leaf;
var G__44168 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44167,G__44168) : pred__44154.call(null,G__44167,G__44168));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__44134,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44169 = cljs.core.cst$kw$first;
var G__44170 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44169,G__44170) : pred__44154.call(null,G__44169,G__44170));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__44134,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44171 = cljs.core.cst$kw$rhs;
var G__44172 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44171,G__44172) : pred__44154.call(null,G__44171,G__44172));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__44134,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44173 = cljs.core.cst$kw$size;
var G__44174 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44173,G__44174) : pred__44154.call(null,G__44173,G__44174));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__44134,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44175 = cljs.core.cst$kw$block;
var G__44176 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44175,G__44176) : pred__44154.call(null,G__44175,G__44176));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__44134,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44177 = cljs.core.cst$kw$t;
var G__44178 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44177,G__44178) : pred__44154.call(null,G__44177,G__44178));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__44134,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44179 = cljs.core.cst$kw$tt_DASH_id;
var G__44180 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44179,G__44180) : pred__44154.call(null,G__44179,G__44180));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__44134,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44181 = cljs.core.cst$kw$leftmost_QMARK_;
var G__44182 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44181,G__44182) : pred__44154.call(null,G__44181,G__44182));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__44134,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__44183 = cljs.core.cst$kw$tempid;
var G__44184 = expr__44155;
return (pred__44154.cljs$core$IFn$_invoke$arity$2 ? pred__44154.cljs$core$IFn$_invoke$arity$2(G__44183,G__44184) : pred__44154.call(null,G__44183,G__44184));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__44134,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__44134),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__44134){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__44134,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__44138){
var extmap__4501__auto__ = (function (){var G__44185 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__44138,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__44138)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__44185);
} else {
return G__44185;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__44138),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__44138),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__44188 = blank_db;
var map__44188__$1 = cljs.core.__destructure_map(map__44188);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44188__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44188__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44188__$1,cljs.core.cst$kw$index_DASH_configs);
var map__44189 = root_data;
var map__44189__$1 = cljs.core.__destructure_map(map__44189);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44189__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44189__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44189__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__44189__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44211){
var state_val_44212 = (state_44211[(1)]);
if((state_val_44212 === (7))){
var state_44211__$1 = state_44211;
var statearr_44213_44233 = state_44211__$1;
(statearr_44213_44233[(2)] = null);

(statearr_44213_44233[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (1))){
var state_44211__$1 = state_44211;
var statearr_44214_44234 = state_44211__$1;
(statearr_44214_44234[(2)] = null);

(statearr_44214_44234[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (4))){
var inst_44190 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
var statearr_44215_44235 = state_44211__$1;
(statearr_44215_44235[(2)] = inst_44190);

(statearr_44215_44235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (6))){
var inst_44197 = (state_44211[(7)]);
var inst_44199 = fluree.db.storage.core.serde(conn);
var state_44211__$1 = (function (){var statearr_44216 = state_44211;
(statearr_44216[(8)] = inst_44199);

return statearr_44216;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44211__$1,(9),inst_44197);
} else {
if((state_val_44212 === (3))){
var inst_44209 = (state_44211[(2)]);
var state_44211__$1 = state_44211;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44211__$1,inst_44209);
} else {
if((state_val_44212 === (2))){
var inst_44197 = (state_44211[(7)]);
var _ = (function (){var statearr_44218 = state_44211;
(statearr_44218[(4)] = cljs.core.cons((5),(state_44211[(4)])));

return statearr_44218;
})();
var inst_44196 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_44197__$1 = fluree.db.storage.core.storage_read(conn,inst_44196);
var state_44211__$1 = (function (){var statearr_44219 = state_44211;
(statearr_44219[(7)] = inst_44197__$1);

return statearr_44219;
})();
if(cljs.core.truth_(inst_44197__$1)){
var statearr_44220_44236 = state_44211__$1;
(statearr_44220_44236[(1)] = (6));

} else {
var statearr_44221_44237 = state_44211__$1;
(statearr_44221_44237[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (9))){
var inst_44199 = (state_44211[(8)]);
var inst_44201 = (state_44211[(2)]);
var inst_44202 = fluree.db.util.async.throw_err(inst_44201);
var inst_44203 = fluree.db.serde.protocol._deserialize_garbage(inst_44199,inst_44202);
var state_44211__$1 = state_44211;
var statearr_44222_44238 = state_44211__$1;
(statearr_44222_44238[(2)] = inst_44203);

(statearr_44222_44238[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (5))){
var _ = (function (){var statearr_44223 = state_44211;
(statearr_44223[(4)] = cljs.core.rest((state_44211[(4)])));

return statearr_44223;
})();
var state_44211__$1 = state_44211;
var ex44217 = (state_44211__$1[(2)]);
var statearr_44224_44239 = state_44211__$1;
(statearr_44224_44239[(5)] = ex44217);


if((ex44217 instanceof Error)){
var statearr_44225_44240 = state_44211__$1;
(statearr_44225_44240[(1)] = (4));

(statearr_44225_44240[(5)] = null);

} else {
throw ex44217;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44212 === (8))){
var inst_44206 = (state_44211[(2)]);
var _ = (function (){var statearr_44226 = state_44211;
(statearr_44226[(4)] = cljs.core.rest((state_44211[(4)])));

return statearr_44226;
})();
var state_44211__$1 = state_44211;
var statearr_44227_44241 = state_44211__$1;
(statearr_44227_44241[(2)] = inst_44206);

(statearr_44227_44241[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____0 = (function (){
var statearr_44228 = [null,null,null,null,null,null,null,null,null];
(statearr_44228[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__);

(statearr_44228[(1)] = (1));

return statearr_44228;
});
var fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____1 = (function (state_44211){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44211);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44229){var ex__24301__auto__ = e44229;
var statearr_44230_44242 = state_44211;
(statearr_44230_44242[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44211[(4)]))){
var statearr_44231_44243 = state_44211;
(statearr_44231_44243[(1)] = cljs.core.first((state_44211[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44244 = state_44211;
state_44211 = G__44244;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__ = function(state_44211){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____1.call(this,state_44211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44232 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44232[(6)] = c__24424__auto__);

return statearr_44232;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44266){
var state_val_44267 = (state_44266[(1)]);
if((state_val_44267 === (7))){
var inst_44255 = (state_44266[(7)]);
var inst_44257 = fluree.db.storage.core.serde(conn);
var inst_44258 = fluree.db.serde.protocol._deserialize_db_root(inst_44257,inst_44255);
var state_44266__$1 = state_44266;
var statearr_44268_44287 = state_44266__$1;
(statearr_44268_44287[(2)] = inst_44258);

(statearr_44268_44287[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (1))){
var state_44266__$1 = state_44266;
var statearr_44269_44288 = state_44266__$1;
(statearr_44269_44288[(2)] = null);

(statearr_44269_44288[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (4))){
var inst_44245 = (state_44266[(2)]);
var state_44266__$1 = state_44266;
var statearr_44270_44289 = state_44266__$1;
(statearr_44270_44289[(2)] = inst_44245);

(statearr_44270_44289[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (6))){
var inst_44255 = (state_44266[(7)]);
var inst_44254 = (state_44266[(2)]);
var inst_44255__$1 = fluree.db.util.async.throw_err(inst_44254);
var state_44266__$1 = (function (){var statearr_44271 = state_44266;
(statearr_44271[(7)] = inst_44255__$1);

return statearr_44271;
})();
if(cljs.core.truth_(inst_44255__$1)){
var statearr_44272_44290 = state_44266__$1;
(statearr_44272_44290[(1)] = (7));

} else {
var statearr_44273_44291 = state_44266__$1;
(statearr_44273_44291[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (3))){
var inst_44264 = (state_44266[(2)]);
var state_44266__$1 = state_44266;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44266__$1,inst_44264);
} else {
if((state_val_44267 === (2))){
var _ = (function (){var statearr_44275 = state_44266;
(statearr_44275[(4)] = cljs.core.cons((5),(state_44266[(4)])));

return statearr_44275;
})();
var inst_44251 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_44252 = fluree.db.storage.core.storage_read(conn,inst_44251);
var state_44266__$1 = state_44266;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44266__$1,(6),inst_44252);
} else {
if((state_val_44267 === (9))){
var inst_44261 = (state_44266[(2)]);
var _ = (function (){var statearr_44276 = state_44266;
(statearr_44276[(4)] = cljs.core.rest((state_44266[(4)])));

return statearr_44276;
})();
var state_44266__$1 = state_44266;
var statearr_44277_44292 = state_44266__$1;
(statearr_44277_44292[(2)] = inst_44261);

(statearr_44277_44292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (5))){
var _ = (function (){var statearr_44278 = state_44266;
(statearr_44278[(4)] = cljs.core.rest((state_44266[(4)])));

return statearr_44278;
})();
var state_44266__$1 = state_44266;
var ex44274 = (state_44266__$1[(2)]);
var statearr_44279_44293 = state_44266__$1;
(statearr_44279_44293[(5)] = ex44274);


if((ex44274 instanceof Error)){
var statearr_44280_44294 = state_44266__$1;
(statearr_44280_44294[(1)] = (4));

(statearr_44280_44294[(5)] = null);

} else {
throw ex44274;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44267 === (8))){
var state_44266__$1 = state_44266;
var statearr_44281_44295 = state_44266__$1;
(statearr_44281_44295[(2)] = null);

(statearr_44281_44295[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____0 = (function (){
var statearr_44282 = [null,null,null,null,null,null,null,null];
(statearr_44282[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__);

(statearr_44282[(1)] = (1));

return statearr_44282;
});
var fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____1 = (function (state_44266){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44266);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44283){var ex__24301__auto__ = e44283;
var statearr_44284_44296 = state_44266;
(statearr_44284_44296[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44266[(4)]))){
var statearr_44285_44297 = state_44266;
(statearr_44285_44297[(1)] = cljs.core.first((state_44266[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44298 = state_44266;
state_44266 = G__44298;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__ = function(state_44266){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____1.call(this,state_44266);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__24298__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44286 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44286[(6)] = c__24424__auto__);

return statearr_44286;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44334){
var state_val_44335 = (state_44334[(1)]);
if((state_val_44335 === (7))){
var inst_44308 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_44309 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_44310 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_44311 = cljs.core.PersistentHashMap.fromArrays(inst_44309,inst_44310);
var inst_44312 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_44308,inst_44311);
var inst_44313 = (function(){throw inst_44312})();
var state_44334__$1 = state_44334;
var statearr_44336_44358 = state_44334__$1;
(statearr_44336_44358[(2)] = inst_44313);

(statearr_44336_44358[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (1))){
var state_44334__$1 = state_44334;
var statearr_44337_44359 = state_44334__$1;
(statearr_44337_44359[(2)] = null);

(statearr_44337_44359[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (4))){
var inst_44299 = (state_44334[(2)]);
var state_44334__$1 = state_44334;
var statearr_44338_44360 = state_44334__$1;
(statearr_44338_44360[(2)] = inst_44299);

(statearr_44338_44360[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (6))){
var state_44334__$1 = state_44334;
var statearr_44339_44361 = state_44334__$1;
(statearr_44339_44361[(2)] = null);

(statearr_44339_44361[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (3))){
var inst_44332 = (state_44334[(2)]);
var state_44334__$1 = state_44334;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44334__$1,inst_44332);
} else {
if((state_val_44335 === (2))){
var inst_44305 = (state_44334[(7)]);
var _ = (function (){var statearr_44340 = state_44334;
(statearr_44340[(4)] = cljs.core.cons((5),(state_44334[(4)])));

return statearr_44340;
})();
var inst_44305__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_44334__$1 = (function (){var statearr_44341 = state_44334;
(statearr_44341[(7)] = inst_44305__$1);

return statearr_44341;
})();
if(cljs.core.truth_(inst_44305__$1)){
var statearr_44342_44362 = state_44334__$1;
(statearr_44342_44362[(1)] = (6));

} else {
var statearr_44343_44363 = state_44334__$1;
(statearr_44343_44363[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (11))){
var inst_44324 = (state_44334[(8)]);
var inst_44327 = (state_44334[(2)]);
var inst_44328 = fluree.db.util.async.throw_err(inst_44327);
var inst_44329 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44324,cljs.core.cst$kw$settings,inst_44328);
var _ = (function (){var statearr_44345 = state_44334;
(statearr_44345[(4)] = cljs.core.rest((state_44334[(4)])));

return statearr_44345;
})();
var state_44334__$1 = state_44334;
var statearr_44346_44364 = state_44334__$1;
(statearr_44346_44364[(2)] = inst_44329);

(statearr_44346_44364[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (9))){
var inst_44319 = (state_44334[(9)]);
var inst_44317 = (state_44334[(2)]);
var inst_44318 = fluree.db.util.async.throw_err(inst_44317);
var inst_44319__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_44318);
var inst_44320 = fluree.db.query.schema.schema_map(inst_44319__$1);
var state_44334__$1 = (function (){var statearr_44347 = state_44334;
(statearr_44347[(9)] = inst_44319__$1);

return statearr_44347;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44334__$1,(10),inst_44320);
} else {
if((state_val_44335 === (5))){
var _ = (function (){var statearr_44348 = state_44334;
(statearr_44348[(4)] = cljs.core.rest((state_44334[(4)])));

return statearr_44348;
})();
var state_44334__$1 = state_44334;
var ex44344 = (state_44334__$1[(2)]);
var statearr_44349_44365 = state_44334__$1;
(statearr_44349_44365[(5)] = ex44344);


if((ex44344 instanceof Error)){
var statearr_44350_44366 = state_44334__$1;
(statearr_44350_44366[(1)] = (4));

(statearr_44350_44366[(5)] = null);

} else {
throw ex44344;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44335 === (10))){
var inst_44319 = (state_44334[(9)]);
var inst_44324 = (state_44334[(8)]);
var inst_44322 = (state_44334[(2)]);
var inst_44323 = fluree.db.util.async.throw_err(inst_44322);
var inst_44324__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_44319,cljs.core.cst$kw$schema,inst_44323);
var inst_44325 = fluree.db.query.schema.setting_map(inst_44324__$1);
var state_44334__$1 = (function (){var statearr_44351 = state_44334;
(statearr_44351[(8)] = inst_44324__$1);

return statearr_44351;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44334__$1,(11),inst_44325);
} else {
if((state_val_44335 === (8))){
var inst_44305 = (state_44334[(7)]);
var inst_44315 = (state_44334[(2)]);
var state_44334__$1 = (function (){var statearr_44352 = state_44334;
(statearr_44352[(10)] = inst_44315);

return statearr_44352;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44334__$1,(9),inst_44305);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__24298__auto____0 = (function (){
var statearr_44353 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_44353[(0)] = fluree$db$storage$core$reify_db_$_state_machine__24298__auto__);

(statearr_44353[(1)] = (1));

return statearr_44353;
});
var fluree$db$storage$core$reify_db_$_state_machine__24298__auto____1 = (function (state_44334){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44334);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44354){var ex__24301__auto__ = e44354;
var statearr_44355_44367 = state_44334;
(statearr_44355_44367[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44334[(4)]))){
var statearr_44356_44368 = state_44334;
(statearr_44356_44368[(1)] = cljs.core.first((state_44334[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44369 = state_44334;
state_44334 = G__44369;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__24298__auto__ = function(state_44334){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__24298__auto____1.call(this,state_44334);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__24298__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__24298__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44357 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44357[(6)] = c__24424__auto__);

return statearr_44357;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__44371 = arguments.length;
switch (G__44371) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44424){
var state_val_44425 = (state_44424[(1)]);
if((state_val_44425 === (7))){
var inst_44381 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_44382 = (new Error(inst_44381));
var inst_44383 = (function(){throw inst_44382})();
var state_44424__$1 = state_44424;
var statearr_44426_44466 = state_44424__$1;
(statearr_44426_44466[(2)] = inst_44383);

(statearr_44426_44466[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (20))){
var inst_44415 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
var statearr_44427_44467 = state_44424__$1;
(statearr_44427_44467[(2)] = inst_44415);

(statearr_44427_44467[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (1))){
var state_44424__$1 = state_44424;
var statearr_44428_44468 = state_44424__$1;
(statearr_44428_44468[(2)] = null);

(statearr_44428_44468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (4))){
var inst_44372 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
var statearr_44429_44469 = state_44424__$1;
(statearr_44429_44469[(2)] = inst_44372);

(statearr_44429_44469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (15))){
var inst_44390 = (state_44424[(7)]);
var state_44424__$1 = state_44424;
var statearr_44430_44470 = state_44424__$1;
(statearr_44430_44470[(2)] = inst_44390);

(statearr_44430_44470[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (21))){
var inst_44389 = (state_44424[(8)]);
var inst_44394 = (state_44424[(9)]);
var inst_44390 = (state_44424[(7)]);
var inst_44408 = (inst_44389 + (1));
var inst_44409 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44390,inst_44394);
var inst_44389__$1 = inst_44408;
var inst_44390__$1 = inst_44409;
var state_44424__$1 = (function (){var statearr_44431 = state_44424;
(statearr_44431[(8)] = inst_44389__$1);

(statearr_44431[(7)] = inst_44390__$1);

return statearr_44431;
})();
var statearr_44432_44471 = state_44424__$1;
(statearr_44432_44471[(2)] = null);

(statearr_44432_44471[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (13))){
var inst_44394 = (state_44424[(9)]);
var inst_44398 = (inst_44394 instanceof Error);
var state_44424__$1 = state_44424;
var statearr_44433_44472 = state_44424__$1;
(statearr_44433_44472[(2)] = inst_44398);

(statearr_44433_44472[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (22))){
var state_44424__$1 = state_44424;
var statearr_44434_44473 = state_44424__$1;
(statearr_44434_44473[(2)] = null);

(statearr_44434_44473[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (6))){
var state_44424__$1 = state_44424;
var statearr_44435_44474 = state_44424__$1;
(statearr_44435_44474[(2)] = null);

(statearr_44435_44474[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (17))){
var inst_44417 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
var statearr_44436_44475 = state_44424__$1;
(statearr_44436_44475[(2)] = inst_44417);

(statearr_44436_44475[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (3))){
var inst_44422 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44424__$1,inst_44422);
} else {
if((state_val_44425 === (12))){
var inst_44395 = (state_44424[(10)]);
var state_44424__$1 = state_44424;
var statearr_44437_44476 = state_44424__$1;
(statearr_44437_44476[(2)] = inst_44395);

(statearr_44437_44476[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (2))){
var _ = (function (){var statearr_44438 = state_44424;
(statearr_44438[(4)] = cljs.core.cons((5),(state_44424[(4)])));

return statearr_44438;
})();
var inst_44378 = (end >= start);
var state_44424__$1 = state_44424;
if(cljs.core.truth_(inst_44378)){
var statearr_44439_44477 = state_44424__$1;
(statearr_44439_44477[(1)] = (6));

} else {
var statearr_44440_44478 = state_44424__$1;
(statearr_44440_44478[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (23))){
var inst_44413 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
var statearr_44441_44479 = state_44424__$1;
(statearr_44441_44479[(2)] = inst_44413);

(statearr_44441_44479[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (19))){
var state_44424__$1 = state_44424;
var statearr_44442_44480 = state_44424__$1;
(statearr_44442_44480[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (11))){
var inst_44395 = (state_44424[(10)]);
var inst_44394 = (state_44424[(9)]);
var inst_44394__$1 = (state_44424[(2)]);
var inst_44395__$1 = (inst_44394__$1 == null);
var state_44424__$1 = (function (){var statearr_44445 = state_44424;
(statearr_44445[(10)] = inst_44395__$1);

(statearr_44445[(9)] = inst_44394__$1);

return statearr_44445;
})();
if(cljs.core.truth_(inst_44395__$1)){
var statearr_44446_44481 = state_44424__$1;
(statearr_44446_44481[(1)] = (12));

} else {
var statearr_44447_44482 = state_44424__$1;
(statearr_44447_44482[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (9))){
var inst_44389 = (state_44424[(8)]);
var inst_44392 = fluree.db.storage.core.read_block(conn,network,dbid,inst_44389);
var state_44424__$1 = state_44424;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44424__$1,(11),inst_44392);
} else {
if((state_val_44425 === (5))){
var _ = (function (){var statearr_44448 = state_44424;
(statearr_44448[(4)] = cljs.core.rest((state_44424[(4)])));

return statearr_44448;
})();
var state_44424__$1 = state_44424;
var ex44444 = (state_44424__$1[(2)]);
var statearr_44449_44483 = state_44424__$1;
(statearr_44449_44483[(5)] = ex44444);


if((ex44444 instanceof Error)){
var statearr_44450_44484 = state_44424__$1;
(statearr_44450_44484[(1)] = (4));

(statearr_44450_44484[(5)] = null);

} else {
throw ex44444;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (14))){
var inst_44400 = (state_44424[(2)]);
var state_44424__$1 = state_44424;
if(cljs.core.truth_(inst_44400)){
var statearr_44451_44485 = state_44424__$1;
(statearr_44451_44485[(1)] = (15));

} else {
var statearr_44452_44486 = state_44424__$1;
(statearr_44452_44486[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (16))){
var inst_44389 = (state_44424[(8)]);
var inst_44403 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_44389,end);
var state_44424__$1 = state_44424;
if(inst_44403){
var statearr_44453_44487 = state_44424__$1;
(statearr_44453_44487[(1)] = (18));

} else {
var statearr_44454_44488 = state_44424__$1;
(statearr_44454_44488[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (10))){
var inst_44419 = (state_44424[(2)]);
var _ = (function (){var statearr_44455 = state_44424;
(statearr_44455[(4)] = cljs.core.rest((state_44424[(4)])));

return statearr_44455;
})();
var state_44424__$1 = state_44424;
var statearr_44456_44489 = state_44424__$1;
(statearr_44456_44489[(2)] = inst_44419);

(statearr_44456_44489[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (18))){
var inst_44394 = (state_44424[(9)]);
var inst_44390 = (state_44424[(7)]);
var inst_44405 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_44390,inst_44394);
var state_44424__$1 = state_44424;
var statearr_44457_44490 = state_44424__$1;
(statearr_44457_44490[(2)] = inst_44405);

(statearr_44457_44490[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44425 === (8))){
var inst_44385 = (state_44424[(2)]);
var inst_44386 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_44387 = start;
var inst_44388 = cljs.core.PersistentVector.EMPTY;
var inst_44389 = inst_44387;
var inst_44390 = inst_44388;
var state_44424__$1 = (function (){var statearr_44458 = state_44424;
(statearr_44458[(8)] = inst_44389);

(statearr_44458[(11)] = inst_44386);

(statearr_44458[(7)] = inst_44390);

(statearr_44458[(12)] = inst_44385);

return statearr_44458;
})();
var statearr_44459_44491 = state_44424__$1;
(statearr_44459_44491[(2)] = null);

(statearr_44459_44491[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__24298__auto__ = null;
var fluree$db$storage$core$state_machine__24298__auto____0 = (function (){
var statearr_44460 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_44460[(0)] = fluree$db$storage$core$state_machine__24298__auto__);

(statearr_44460[(1)] = (1));

return statearr_44460;
});
var fluree$db$storage$core$state_machine__24298__auto____1 = (function (state_44424){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44424);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44461){var ex__24301__auto__ = e44461;
var statearr_44462_44492 = state_44424;
(statearr_44462_44492[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44424[(4)]))){
var statearr_44463_44493 = state_44424;
(statearr_44463_44493[(1)] = cljs.core.first((state_44424[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44494 = state_44424;
state_44424 = G__44494;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__24298__auto__ = function(state_44424){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__24298__auto____1.call(this,state_44424);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__24298__auto____0;
fluree$db$storage$core$state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__24298__auto____1;
return fluree$db$storage$core$state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44464 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44464[(6)] = c__24424__auto__);

return statearr_44464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__24424__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__24425__auto__ = (function (){var switch__24297__auto__ = (function (state_44510){
var state_val_44511 = (state_44510[(1)]);
if((state_val_44511 === (1))){
var state_44510__$1 = state_44510;
var statearr_44512_44526 = state_44510__$1;
(statearr_44512_44526[(2)] = null);

(statearr_44512_44526[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44511 === (2))){
var _ = (function (){var statearr_44513 = state_44510;
(statearr_44513[(4)] = cljs.core.cons((5),(state_44510[(4)])));

return statearr_44513;
})();
var inst_44501 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_44510__$1 = state_44510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_44510__$1,(6),inst_44501);
} else {
if((state_val_44511 === (3))){
var inst_44508 = (state_44510[(2)]);
var state_44510__$1 = state_44510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_44510__$1,inst_44508);
} else {
if((state_val_44511 === (4))){
var inst_44495 = (state_44510[(2)]);
var state_44510__$1 = state_44510;
var statearr_44515_44527 = state_44510__$1;
(statearr_44515_44527[(2)] = inst_44495);

(statearr_44515_44527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_44511 === (5))){
var _ = (function (){var statearr_44516 = state_44510;
(statearr_44516[(4)] = cljs.core.rest((state_44510[(4)])));

return statearr_44516;
})();
var state_44510__$1 = state_44510;
var ex44514 = (state_44510__$1[(2)]);
var statearr_44517_44528 = state_44510__$1;
(statearr_44517_44528[(5)] = ex44514);


if((ex44514 instanceof Error)){
var statearr_44518_44529 = state_44510__$1;
(statearr_44518_44529[(1)] = (4));

(statearr_44518_44529[(5)] = null);

} else {
throw ex44514;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_44511 === (6))){
var inst_44503 = (state_44510[(2)]);
var inst_44504 = fluree.db.util.async.throw_err(inst_44503);
var inst_44505 = cljs.core.first(inst_44504);
var _ = (function (){var statearr_44519 = state_44510;
(statearr_44519[(4)] = cljs.core.rest((state_44510[(4)])));

return statearr_44519;
})();
var state_44510__$1 = state_44510;
var statearr_44520_44530 = state_44510__$1;
(statearr_44520_44530[(2)] = inst_44505);

(statearr_44520_44530[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__24298__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__24298__auto____0 = (function (){
var statearr_44521 = [null,null,null,null,null,null,null];
(statearr_44521[(0)] = fluree$db$storage$core$block_$_state_machine__24298__auto__);

(statearr_44521[(1)] = (1));

return statearr_44521;
});
var fluree$db$storage$core$block_$_state_machine__24298__auto____1 = (function (state_44510){
while(true){
var ret_value__24299__auto__ = (function (){try{while(true){
var result__24300__auto__ = switch__24297__auto__(state_44510);
if(cljs.core.keyword_identical_QMARK_(result__24300__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__24300__auto__;
}
break;
}
}catch (e44522){var ex__24301__auto__ = e44522;
var statearr_44523_44531 = state_44510;
(statearr_44523_44531[(2)] = ex__24301__auto__);


if(cljs.core.seq((state_44510[(4)]))){
var statearr_44524_44532 = state_44510;
(statearr_44524_44532[(1)] = cljs.core.first((state_44510[(4)])));

} else {
throw ex__24301__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__24299__auto__,cljs.core.cst$kw$recur)){
var G__44533 = state_44510;
state_44510 = G__44533;
continue;
} else {
return ret_value__24299__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__24298__auto__ = function(state_44510){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__24298__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__24298__auto____1.call(this,state_44510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__24298__auto____0;
fluree$db$storage$core$block_$_state_machine__24298__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__24298__auto____1;
return fluree$db$storage$core$block_$_state_machine__24298__auto__;
})()
})();
var state__24426__auto__ = (function (){var statearr_44525 = (f__24425__auto__.cljs$core$IFn$_invoke$arity$0 ? f__24425__auto__.cljs$core$IFn$_invoke$arity$0() : f__24425__auto__.call(null));
(statearr_44525[(6)] = c__24424__auto__);

return statearr_44525;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__24426__auto__);
}));

return c__24424__auto__;
});
