// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('cljs.js');
fluree.db.util.core.max_long = ((9007199254740991) - (1));
fluree.db.util.core.min_long = (- fluree.db.util.core.max_long);
fluree.db.util.core.max_integer = (2147483647);
fluree.db.util.core.min_integer = (- (2147483647));
/**
 * Take the &env from a macro, and tell whether we are expanding into cljs.
 */
fluree.db.util.core.cljs_env_QMARK_ = (function fluree$db$util$core$cljs_env_QMARK_(env){
return cljs.core.boolean$(cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(env));
});
var ret__4867__auto___28237 = /**
 * Return then if we are generating cljs code and else for Clojure code.
 * https://groups.google.com/d/msg/clojurescript/iBY5HaQda4A/w1lAQi9_AwsJ
 */
fluree.db.util.core.if_cljs = (function fluree$db$util$core$if_cljs(_AMPERSAND_form,_AMPERSAND_env,then,else$){
if(fluree.db.util.core.cljs_env_QMARK_(_AMPERSAND_env)){
return then;
} else {
return else$;
}
});
(fluree.db.util.core.if_cljs.cljs$lang$macro = true);

var ret__4867__auto___28244 = (function (){
/**
 * A cross-platform variant of try-catch that catches all exceptions.
 * Does not (yet) support finally, and does not need or want an exception class.
 */
fluree.db.util.core.try_catchall = (function fluree$db$util$core$try_catchall(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28245 = arguments.length;
var i__4819__auto___28246 = (0);
while(true){
if((i__4819__auto___28246 < len__4818__auto___28245)){
args__4824__auto__.push((arguments[i__4819__auto___28246]));

var G__28247 = (i__4819__auto___28246 + (1));
i__4819__auto___28246 = G__28247;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.util.core.try_catchall.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
var try_body = cljs.core.butlast(body);
var vec__28241 = cljs.core.last(body);
var seq__28242 = cljs.core.seq(vec__28241);
var first__28243 = cljs.core.first(seq__28242);
var seq__28242__$1 = cljs.core.next(seq__28242);
var catch$ = first__28243;
var first__28243__$1 = cljs.core.first(seq__28242__$1);
var seq__28242__$2 = cljs.core.next(seq__28242__$1);
var sym = first__28243__$1;
var catch_body = seq__28242__$2;
var catch_form = vec__28241;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(catch$,cljs.core.cst$sym$catch)){
} else {
throw (new Error("Assert failed: (= catch (quote catch))"));
}

if((sym instanceof cljs.core.Symbol)){
} else {
throw (new Error("Assert failed: (symbol? sym)"));
}

return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$core_SLASH_if_DASH_cljs,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$try,null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$catch,null,(1),null)),(new cljs.core.List(null,cljs.core.cst$sym$js_SLASH_Object,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$try,null,(1),null)),try_body,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$catch,null,(1),null)),(new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$core_SLASH_Throwable,null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,sym,null,(1),null)),catch_body], 0)))),null,(1),null))], 0)))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_catchall.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_catchall.cljs$lang$applyTo = (function (seq28238){
var G__28239 = cljs.core.first(seq28238);
var seq28238__$1 = cljs.core.next(seq28238);
var G__28240 = cljs.core.first(seq28238__$1);
var seq28238__$2 = cljs.core.next(seq28238__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28239,G__28240,seq28238__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_catchall.cljs$lang$macro = true);

var ret__4867__auto___28251 = (function (){
/**
 * Like try but supports catch*. catch* is like catch but supports CLJ/CLJS with
 *   less boilerplate. In CLJ it catches `Exception`. In CLJS it catches `:default`.
 *   Use it like this: `(try* ... (catch* err (handle-err err)))`.
 *   Also supports an optional finally clause.
 */
fluree.db.util.core.try_STAR_ = (function fluree$db$util$core$try_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28252 = arguments.length;
var i__4819__auto___28253 = (0);
while(true){
if((i__4819__auto___28253 < len__4818__auto___28252)){
args__4824__auto__.push((arguments[i__4819__auto___28253]));

var G__28254 = (i__4819__auto___28253 + (1));
i__4819__auto___28253 = G__28254;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.util.core.try_STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,body){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$core_SLASH_if_DASH_cljs,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$cljs_DASH_exceptions_SLASH_try_STAR_,null,(1),null)),body))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$clj_DASH_exceptions_SLASH_try_STAR_,null,(1),null)),body))),null,(1),null))], 0))));
}));

(fluree.db.util.core.try_STAR_.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.util.core.try_STAR_.cljs$lang$applyTo = (function (seq28248){
var G__28249 = cljs.core.first(seq28248);
var seq28248__$1 = cljs.core.next(seq28248);
var G__28250 = cljs.core.first(seq28248__$1);
var seq28248__$2 = cljs.core.next(seq28248__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28249,G__28250,seq28248__$2);
}));

return null;
})()
;
(fluree.db.util.core.try_STAR_.cljs$lang$macro = true);

fluree.db.util.core.index_of = (function fluree$db$util$core$index_of(coll,value){
return cljs.core.some((function (p__28255){
var vec__28256 = p__28255;
var item = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28256,(0),null);
var idx = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28256,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(value,item)){
return idx;
} else {
return null;
}
}),cljs.core.partition.cljs$core$IFn$_invoke$arity$2((2),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.range.cljs$core$IFn$_invoke$arity$0())));
});
fluree.db.util.core.random_uuid = (function fluree$db$util$core$random_uuid(){

return cljs.core.random_uuid();
});
/**
 * Given a date, returns epoch millis if possible.
 */
fluree.db.util.core.date__GT_millis = (function fluree$db$util$core$date__GT_millis(date){
if(typeof date === 'string'){
return Date.parse(date).getTime();
} else {
if(typeof date === 'number'){
return date;
} else {
if((date instanceof Date)){
return date.getTime();
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid date: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([date], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_date], null));

}
}
}
});
/**
 * Returns current time in epoch milliseonds for closure/script
 */
fluree.db.util.core.current_time_millis = (function fluree$db$util$core$current_time_millis(){
return (new Date()).getTime();
});
/**
 * Returns response time, formatted as string. Must provide start time of request
 * for clj as (System/nanoTime), or for cljs epoch milliseconds
 */
fluree.db.util.core.response_time_formatted = (function fluree$db$util$core$response_time_formatted(start_time){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((fluree.db.util.core.current_time_millis() - start_time)),"ms"].join('');
});
fluree.db.util.core.deep_merge = (function fluree$db$util$core$deep_merge(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28264 = arguments.length;
var i__4819__auto___28265 = (0);
while(true){
if((i__4819__auto___28265 < len__4818__auto___28264)){
args__4824__auto__.push((arguments[i__4819__auto___28265]));

var G__28266 = (i__4819__auto___28265 + (1));
i__4819__auto___28265 = G__28266;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.util.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic = (function (v,vs){
var rec_merge = (function fluree$db$util$core$rec_merge(v1,v2){
if(((cljs.core.map_QMARK_(v1)) && (cljs.core.map_QMARK_(v2)))){
return cljs.core.merge_with.cljs$core$IFn$_invoke$arity$variadic(fluree.db.util.core.deep_merge,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([v1,v2], 0));
} else {
return v2;
}
});
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,vs))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__28260_SHARP_,p2__28261_SHARP_){
return rec_merge(p1__28260_SHARP_,p2__28261_SHARP_);
}),v,vs);
} else {
return v;
}
}));

(fluree.db.util.core.deep_merge.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.util.core.deep_merge.cljs$lang$applyTo = (function (seq28262){
var G__28263 = cljs.core.first(seq28262);
var seq28262__$1 = cljs.core.next(seq28262);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28263,seq28262__$1);
}));

fluree.db.util.core.email_QMARK_ = (function fluree$db$util$core$email_QMARK_(email){
return cljs.core.re_matches(/^[\w-\+]+(\.[\w]+)*@[\w-]+(\.[\w]+)*(\.[a-z]{2,})$/,email);
});
/**
 * Tests if an predicate identity two-tuple
 *   in form of [pred-name-or-id pred-value]
 */
fluree.db.util.core.pred_ident_QMARK_ = (function fluree$db$util$core$pred_ident_QMARK_(x){
return ((cljs.core.sequential_QMARK_(x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),cljs.core.count(x))) && (typeof cljs.core.first(x) === 'string'))));
});
fluree.db.util.core.temp_ident_QMARK_ = (function fluree$db$util$core$temp_ident_QMARK_(x){
return typeof x === 'string';
});
/**
 * Tests if an _id is a numeric or predicate-ident
 */
fluree.db.util.core.subj_ident_QMARK_ = (function fluree$db$util$core$subj_ident_QMARK_(x){
return ((cljs.core.int_QMARK_(x)) || (fluree.db.util.core.pred_ident_QMARK_(x)));
});
/**
 * Converts string to integer. Assumes you've already verified the string is
 *   parsable to an integer.
 */
fluree.db.util.core.str__GT_int = (function fluree$db$util$core$str__GT_int(s){
return parseInt(s);
});
/**
 * Converts a keyword to string. Can safely be called on a
 *   string which will return itself.
 */
fluree.db.util.core.keyword__GT_str = (function fluree$db$util$core$keyword__GT_str(k){
if((k instanceof cljs.core.Keyword)){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(k),(1));
} else {
if(typeof k === 'string'){
return k;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(k))," to string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));

}
}
});
/**
 * Converts a string to a keyword, checking to see if
 *   the string starts with a ':', which it strips before converting.
 */
fluree.db.util.core.str__GT_keyword = (function fluree$db$util$core$str__GT_keyword(s){
if(typeof s === 'string'){
if(clojure.string.starts_with_QMARK_(s,":")){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(1)));
} else {
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(s);
}
} else {
if((s instanceof cljs.core.Keyword)){
return s;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot convert type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(s))," to keyword: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));

}
}
});
/**
 * Takes time as a string and returns an java.time.Instant.
 */
fluree.db.util.core.str__GT_epoch_ms = (function fluree$db$util$core$str__GT_epoch_ms(time_str){
try{return Date.parse(time_str);
}catch (e28267){var _ = e28267;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid time string. Ensure format is ISO-8601 compatible. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([time_str], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_time], null));
}});
/**
 * Truncate string s to n characters.
 */
fluree.db.util.core.trunc = (function fluree$db$util$core$trunc(s,n){
if((cljs.core.count(s) < n)){
return s;
} else {
return [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),n)," ..."].join('');
}
});
var ret__4867__auto___28275 = (function (){
fluree.db.util.core.some_of = (function fluree$db$util$core$some_of(var_args){
var G__28274 = arguments.length;
switch (G__28274) {
case 2:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___28277 = arguments.length;
var i__4819__auto___28278 = (0);
while(true){
if((i__4819__auto___28278 < len__4818__auto___28277)){
args_arr__4839__auto__.push((arguments[i__4819__auto___28278]));

var G__28279 = (i__4819__auto___28278 + (1));
i__4819__auto___28278 = G__28279;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((3)),(0),null));
return fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__4840__auto__);

}
});

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$2 = (function (_AMPERSAND_form,_AMPERSAND_env){
return null;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$3 = (function (_AMPERSAND_form,_AMPERSAND_env,x){
return x;
}));

(fluree.db.util.core.some_of.cljs$core$IFn$_invoke$arity$variadic = (function (_AMPERSAND_form,_AMPERSAND_env,x,more){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_let,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$x__28268__auto__,null,(1),null)),(new cljs.core.List(null,x,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_nil_QMARK_,null,(1),null)),(new cljs.core.List(null,cljs.core.cst$sym$x__28268__auto__,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$core_SLASH_some_DASH_of,null,(1),null)),more))),null,(1),null)),(new cljs.core.List(null,cljs.core.cst$sym$x__28268__auto__,null,(1),null))], 0)))),null,(1),null))], 0))));
}));

/** @this {Function} */
(fluree.db.util.core.some_of.cljs$lang$applyTo = (function (seq28270){
var G__28271 = cljs.core.first(seq28270);
var seq28270__$1 = cljs.core.next(seq28270);
var G__28272 = cljs.core.first(seq28270__$1);
var seq28270__$2 = cljs.core.next(seq28270__$1);
var G__28273 = cljs.core.first(seq28270__$2);
var seq28270__$3 = cljs.core.next(seq28270__$2);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28271,G__28272,G__28273,seq28270__$3);
}));

(fluree.db.util.core.some_of.cljs$lang$maxFixedArity = (3));

return null;
})()
;
(fluree.db.util.core.some_of.cljs$lang$macro = true);

/**
 * Filters map k/v pairs dropping any where predicate applied to value is false.
 */
fluree.db.util.core.filter_vals = (function fluree$db$util$core$filter_vals(pred,m){
return cljs.core.reduce_kv((function (m__$1,k,v){
if(cljs.core.truth_((pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(v) : pred.call(null,v)))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,k,v);
} else {
return m__$1;
}
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Remove all keys from a map that have nil or empty collection values.
 */
fluree.db.util.core.without_nils = (function fluree$db$util$core$without_nils(m){
return fluree.db.util.core.filter_vals((function (p1__28280_SHARP_){
if(cljs.core.coll_QMARK_(p1__28280_SHARP_)){
return cljs.core.not_empty(p1__28280_SHARP_);
} else {
return (!((p1__28280_SHARP_ == null)));
}
}),m);
});
/**
 * Like range, but includes start/end values.
 */
fluree.db.util.core.inclusive_range = (function fluree$db$util$core$inclusive_range(var_args){
var G__28282 = arguments.length;
switch (G__28282) {
case 0:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.range.cljs$core$IFn$_invoke$arity$0();
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$1 = (function (end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$1((end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$2 = (function (start,end){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2(start,(end + (1)));
}));

(fluree.db.util.core.inclusive_range.cljs$core$IFn$_invoke$arity$3 = (function (start,end,step){
return cljs.core.range.cljs$core$IFn$_invoke$arity$3(start,(end + step),step);
}));

(fluree.db.util.core.inclusive_range.cljs$lang$maxFixedArity = 3);

/**
 * x-platform, returns true if is an execption
 */
fluree.db.util.core.exception_QMARK_ = (function fluree$db$util$core$exception_QMARK_(x){
return (x instanceof Error);
});
fluree.db.util.core.url_encode = (function fluree$db$util$core$url_encode(string){
var G__28284 = string;
var G__28284__$1 = (((G__28284 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28284));
var G__28284__$2 = (((G__28284__$1 == null))?null:encodeURIComponent(G__28284__$1));
if((G__28284__$2 == null)){
return null;
} else {
return G__28284__$2.replace("+","%20");
}
});
fluree.db.util.core.url_decode = (function fluree$db$util$core$url_decode(var_args){
var G__28286 = arguments.length;
switch (G__28286) {
case 1:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$1 = (function (string){
return fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2(string,"UTF-8");
}));

(fluree.db.util.core.url_decode.cljs$core$IFn$_invoke$arity$2 = (function (string,encoding){
var G__28287 = string;
var G__28287__$1 = (((G__28287 == null))?null:cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__28287));
if((G__28287__$1 == null)){
return null;
} else {
return decodeURIComponent(G__28287__$1);
}
}));

(fluree.db.util.core.url_decode.cljs$lang$maxFixedArity = 2);

fluree.db.util.core.map_invert = (function fluree$db$util$core$map_invert(m){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m__$1,p__28289){
var vec__28290 = p__28289;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28290,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28290,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m__$1,v,k);
}),cljs.core.PersistentArrayMap.EMPTY,m);
});
/**
 * Zero pads x
 */
fluree.db.util.core.zero_pad = (function fluree$db$util$core$zero_pad(x,pad){
var s = cljs.core.str.cljs$core$IFn$_invoke$arity$1(x);
while(true){
if((s.length < pad)){
var G__28293 = ["0",s].join('');
s = G__28293;
continue;
} else {
return s;
}
break;
}
});
