// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__88727 = (line + (1));
var G__88728 = (1);
var G__88729 = (counter + (1));
line = G__88727;
col = G__88728;
counter = G__88729;
continue;
} else {
var G__88730 = line;
var G__88731 = (col + (1));
var G__88732 = (counter + (1));
line = G__88730;
col = G__88731;
counter = G__88732;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__88733 = cljs.core.next(chars);
var G__88734 = (n__$1 - (1));
chars = G__88733;
n__$1 = G__88734;
continue;
} else {
var G__88735 = cljs.core.next(chars);
var G__88736 = n__$1;
chars = G__88735;
n__$1 = G__88736;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__88737){
var map__88738 = p__88737;
var map__88738__$1 = cljs.core.__destructure_map(map__88738);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88738__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88738__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88738__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__88738__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__88739_88747 = cljs.core.seq(full_reasons);
var chunk__88740_88748 = null;
var count__88741_88749 = (0);
var i__88742_88750 = (0);
while(true){
if((i__88742_88750 < count__88741_88749)){
var r_88751 = chunk__88740_88748.cljs$core$IIndexed$_nth$arity$2(null,i__88742_88750);
instaparse.failure.print_reason(r_88751);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__88752 = seq__88739_88747;
var G__88753 = chunk__88740_88748;
var G__88754 = count__88741_88749;
var G__88755 = (i__88742_88750 + (1));
seq__88739_88747 = G__88752;
chunk__88740_88748 = G__88753;
count__88741_88749 = G__88754;
i__88742_88750 = G__88755;
continue;
} else {
var temp__5753__auto___88756 = cljs.core.seq(seq__88739_88747);
if(temp__5753__auto___88756){
var seq__88739_88757__$1 = temp__5753__auto___88756;
if(cljs.core.chunked_seq_QMARK_(seq__88739_88757__$1)){
var c__4638__auto___88758 = cljs.core.chunk_first(seq__88739_88757__$1);
var G__88759 = cljs.core.chunk_rest(seq__88739_88757__$1);
var G__88760 = c__4638__auto___88758;
var G__88761 = cljs.core.count(c__4638__auto___88758);
var G__88762 = (0);
seq__88739_88747 = G__88759;
chunk__88740_88748 = G__88760;
count__88741_88749 = G__88761;
i__88742_88750 = G__88762;
continue;
} else {
var r_88763 = cljs.core.first(seq__88739_88757__$1);
instaparse.failure.print_reason(r_88763);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__88764 = cljs.core.next(seq__88739_88757__$1);
var G__88765 = null;
var G__88766 = (0);
var G__88767 = (0);
seq__88739_88747 = G__88764;
chunk__88740_88748 = G__88765;
count__88741_88749 = G__88766;
i__88742_88750 = G__88767;
continue;
}
} else {
}
}
break;
}

var seq__88743 = cljs.core.seq(partial_reasons);
var chunk__88744 = null;
var count__88745 = (0);
var i__88746 = (0);
while(true){
if((i__88746 < count__88745)){
var r = chunk__88744.cljs$core$IIndexed$_nth$arity$2(null,i__88746);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__88768 = seq__88743;
var G__88769 = chunk__88744;
var G__88770 = count__88745;
var G__88771 = (i__88746 + (1));
seq__88743 = G__88768;
chunk__88744 = G__88769;
count__88745 = G__88770;
i__88746 = G__88771;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__88743);
if(temp__5753__auto__){
var seq__88743__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__88743__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__88743__$1);
var G__88772 = cljs.core.chunk_rest(seq__88743__$1);
var G__88773 = c__4638__auto__;
var G__88774 = cljs.core.count(c__4638__auto__);
var G__88775 = (0);
seq__88743 = G__88772;
chunk__88744 = G__88773;
count__88745 = G__88774;
i__88746 = G__88775;
continue;
} else {
var r = cljs.core.first(seq__88743__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__88776 = cljs.core.next(seq__88743__$1);
var G__88777 = null;
var G__88778 = (0);
var G__88779 = (0);
seq__88743 = G__88776;
chunk__88744 = G__88777;
count__88745 = G__88778;
i__88746 = G__88779;
continue;
}
} else {
return null;
}
}
break;
}
});
