// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.conn_events');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
if((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.conn_events !== 'undefined') && (typeof fluree.db.conn_events.process_event !== 'undefined')){
} else {
fluree.db.conn_events.process_event = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__24893 = cljs.core.get_global_hierarchy;
return (fexpr__24893.cljs$core$IFn$_invoke$arity$0 ? fexpr__24893.cljs$core$IFn$_invoke$arity$0() : fexpr__24893.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fluree.db.conn-events","process-event"),(function (_,event_type,___$1,___$2){
return event_type;
}),cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_DASH_ws_DASH_id,(function (conn,_,___$1,ws_id){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["set websocket id:",ws_id], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),cljs.core.assoc,cljs.core.cst$kw$socket_DASH_id,ws_id);
}));
fluree.db.conn_events.process_event.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (conn,event_type,subject,event_data){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["process event:",event_type,event_data], 0));

var callbacks = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,subject], null));
var seq__24894 = cljs.core.seq(callbacks);
var chunk__24895 = null;
var count__24896 = (0);
var i__24897 = (0);
while(true){
if((i__24897 < count__24896)){
var vec__24906 = chunk__24895.cljs$core$IIndexed$_nth$arity$2(null,i__24897);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24906,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24906,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e24909){var e_24914 = e24909;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_24914,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__24915 = seq__24894;
var G__24916 = chunk__24895;
var G__24917 = count__24896;
var G__24918 = (i__24897 + (1));
seq__24894 = G__24915;
chunk__24895 = G__24916;
count__24896 = G__24917;
i__24897 = G__24918;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__24894);
if(temp__5753__auto__){
var seq__24894__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__24894__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__24894__$1);
var G__24919 = cljs.core.chunk_rest(seq__24894__$1);
var G__24920 = c__4638__auto__;
var G__24921 = cljs.core.count(c__4638__auto__);
var G__24922 = (0);
seq__24894 = G__24919;
chunk__24895 = G__24920;
count__24896 = G__24921;
i__24897 = G__24922;
continue;
} else {
var vec__24910 = cljs.core.first(seq__24894__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24910,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24910,(1),null);
try{(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(event_type,event_data) : f.call(null,event_type,event_data));
}catch (e24913){var e_24923 = e24913;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e_24923,["Error calling registered callback: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([k], 0))," for db: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(subject),". Event: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(event_type)," Data: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([event_data], 0)),"."].join('')], 0));
}

var G__24924 = cljs.core.next(seq__24894__$1);
var G__24925 = null;
var G__24926 = (0);
var G__24927 = (0);
seq__24894 = G__24924;
chunk__24895 = G__24925;
count__24896 = G__24926;
i__24897 = G__24927;
continue;
}
} else {
return null;
}
}
break;
}
}));
/**
 * Processes incoming events from the ledger.
 * 
 *   Requests that carry a :req-id in the header will attempt to lookup a
 *   corresponding return channel and send the message along on it.
 * 
 *   Otherwise looks for database events and updates local state accordingly.
 */
fluree.db.conn_events.process_events = (function fluree$db$conn_events$process_events(conn,msg){
try{var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Process events: ",msg], 0));
var vec__24930 = msg;
var event_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24930,(0),null);
var subject = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24930,(1),null);
var event_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24930,(2),null);
var error_data = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__24930,(3),null);
var event_type__$1 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(event_type);
var map__24933 = conn;
var map__24933__$1 = cljs.core.__destructure_map(map__24933);
var state = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24933__$1,cljs.core.cst$kw$state);
var G__24934 = event_type__$1;
var G__24934__$1 = (((G__24934 instanceof cljs.core.Keyword))?G__24934.fqn:null);
switch (G__24934__$1) {
case "response":
var temp__5753__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(state),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pending_DASH_req,subject], null));
if(cljs.core.truth_(temp__5753__auto__)){
var res_chan = temp__5753__auto__;
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Found response channel for subject",subject], 0));

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,(function (p1__24928_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__24928_SHARP_,subject);
}));

if(cljs.core.truth_(error_data)){
var map__24935 = error_data;
var map__24935__$1 = cljs.core.__destructure_map(map__24935);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__24935__$1,cljs.core.cst$kw$message);
var exception = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = message;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([error_data], 0));
}
})(),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(error_data,cljs.core.cst$kw$message));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,exception);
} else {
if(cljs.core.truth_(event_data)){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(res_chan,event_data);
} else {
return cljs.core.async.close_BANG_(res_chan);

}
}
} else {
return null;
}

break;
case "pong":
return null;

break;
default:
return (fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4 ? fluree.db.conn_events.process_event.cljs$core$IFn$_invoke$arity$4(conn,event_type__$1,subject,event_data) : fluree.db.conn_events.process_event.call(null,conn,event_type__$1,subject,event_data));

}
}catch (e24929){var e = e24929;
return fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e], 0));
}});
