// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___64731 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_64782){
var state_val_64783 = (state_64782[(1)]);
if((state_val_64783 === (7))){
var inst_64777 = (state_64782[(2)]);
var _ = (function (){var statearr_64784 = state_64782;
(statearr_64784[(4)] = cljs.core.rest((state_64782[(4)])));

return statearr_64784;
})();
var state_64782__$1 = state_64782;
var statearr_64785_64812 = state_64782__$1;
(statearr_64785_64812[(2)] = inst_64777);

(statearr_64785_64812[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (1))){
var state_64782__$1 = state_64782;
var statearr_64786_64813 = state_64782__$1;
(statearr_64786_64813[(2)] = null);

(statearr_64786_64813[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (4))){
var inst_64732 = (state_64782[(2)]);
var state_64782__$1 = state_64782;
var statearr_64787_64814 = state_64782__$1;
(statearr_64787_64814[(2)] = inst_64732);

(statearr_64787_64814[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (13))){
var inst_64773 = (state_64782[(2)]);
var state_64782__$1 = state_64782;
var statearr_64788_64815 = state_64782__$1;
(statearr_64788_64815[(2)] = inst_64773);

(statearr_64788_64815[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (6))){
var inst_64757 = (state_64782[(7)]);
var inst_64750 = (state_64782[(8)]);
var inst_64756 = cljs.core.seq(inst_64750);
var inst_64757__$1 = cljs.core.first(inst_64756);
var inst_64758 = cljs.core.next(inst_64756);
var inst_64759 = cljs.core.not(inst_64757__$1);
var state_64782__$1 = (function (){var statearr_64789 = state_64782;
(statearr_64789[(7)] = inst_64757__$1);

(statearr_64789[(9)] = inst_64758);

return statearr_64789;
})();
if(inst_64759){
var statearr_64790_64816 = state_64782__$1;
(statearr_64790_64816[(1)] = (8));

} else {
var statearr_64791_64817 = state_64782__$1;
(statearr_64791_64817[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (3))){
var inst_64780 = (state_64782[(2)]);
var state_64782__$1 = state_64782;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64782__$1,inst_64780);
} else {
if((state_val_64783 === (12))){
var inst_64751 = (state_64782[(10)]);
var inst_64757 = (state_64782[(7)]);
var inst_64758 = (state_64782[(9)]);
var inst_64770 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64751,inst_64757);
var inst_64750 = inst_64758;
var inst_64751__$1 = inst_64770;
var state_64782__$1 = (function (){var statearr_64792 = state_64782;
(statearr_64792[(10)] = inst_64751__$1);

(statearr_64792[(8)] = inst_64750);

return statearr_64792;
})();
var statearr_64793_64818 = state_64782__$1;
(statearr_64793_64818[(2)] = null);

(statearr_64793_64818[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (2))){
var _ = (function (){var statearr_64794 = state_64782;
(statearr_64794[(4)] = cljs.core.cons((5),(state_64782[(4)])));

return statearr_64794;
})();
var inst_64745 = args;
var inst_64746 = cljs.core.seq(inst_64745);
var inst_64747 = cljs.core.first(inst_64746);
var inst_64748 = cljs.core.next(inst_64746);
var inst_64749 = cljs.core.PersistentVector.EMPTY;
var inst_64750 = inst_64745;
var inst_64751 = inst_64749;
var state_64782__$1 = (function (){var statearr_64795 = state_64782;
(statearr_64795[(11)] = inst_64747);

(statearr_64795[(10)] = inst_64751);

(statearr_64795[(8)] = inst_64750);

(statearr_64795[(12)] = inst_64748);

return statearr_64795;
})();
var statearr_64796_64819 = state_64782__$1;
(statearr_64796_64819[(2)] = null);

(statearr_64796_64819[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (11))){
var inst_64757 = (state_64782[(7)]);
var state_64782__$1 = state_64782;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64782__$1,(14),inst_64757);
} else {
if((state_val_64783 === (9))){
var inst_64757 = (state_64782[(7)]);
var inst_64762 = fluree.db.util.async.channel_QMARK_(inst_64757);
var state_64782__$1 = state_64782;
if(inst_64762){
var statearr_64798_64820 = state_64782__$1;
(statearr_64798_64820[(1)] = (11));

} else {
var statearr_64799_64821 = state_64782__$1;
(statearr_64799_64821[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (5))){
var _ = (function (){var statearr_64800 = state_64782;
(statearr_64800[(4)] = cljs.core.rest((state_64782[(4)])));

return statearr_64800;
})();
var state_64782__$1 = state_64782;
var ex64797 = (state_64782__$1[(2)]);
var statearr_64801_64822 = state_64782__$1;
(statearr_64801_64822[(5)] = ex64797);


if((ex64797 instanceof Error)){
var statearr_64802_64823 = state_64782__$1;
(statearr_64802_64823[(1)] = (4));

(statearr_64802_64823[(5)] = null);

} else {
throw ex64797;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (14))){
var inst_64751 = (state_64782[(10)]);
var inst_64758 = (state_64782[(9)]);
var inst_64765 = (state_64782[(2)]);
var inst_64766 = fluree.db.util.async.throw_err(inst_64765);
var inst_64767 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_64751,inst_64766);
var inst_64750 = inst_64758;
var inst_64751__$1 = inst_64767;
var state_64782__$1 = (function (){var statearr_64803 = state_64782;
(statearr_64803[(10)] = inst_64751__$1);

(statearr_64803[(8)] = inst_64750);

return statearr_64803;
})();
var statearr_64804_64824 = state_64782__$1;
(statearr_64804_64824[(2)] = null);

(statearr_64804_64824[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (10))){
var inst_64775 = (state_64782[(2)]);
var state_64782__$1 = state_64782;
var statearr_64805_64825 = state_64782__$1;
(statearr_64805_64825[(2)] = inst_64775);

(statearr_64805_64825[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64783 === (8))){
var inst_64751 = (state_64782[(10)]);
var state_64782__$1 = state_64782;
var statearr_64806_64826 = state_64782__$1;
(statearr_64806_64826[(2)] = inst_64751);

(statearr_64806_64826[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____0 = (function (){
var statearr_64807 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_64807[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__);

(statearr_64807[(1)] = (1));

return statearr_64807;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____1 = (function (state_64782){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_64782);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e64808){var ex__10753__auto__ = e64808;
var statearr_64809_64827 = state_64782;
(statearr_64809_64827[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_64782[(4)]))){
var statearr_64810_64828 = state_64782;
(statearr_64810_64828[(1)] = cljs.core.first((state_64782[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__64829 = state_64782;
state_64782 = G__64829;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__ = function(state_64782){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____1.call(this,state_64782);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_64811 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_64811[(6)] = c__10876__auto__);

return statearr_64811;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__64830 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64830,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__64830,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_64878){
var state_val_64879 = (state_64878[(1)]);
if((state_val_64879 === (7))){
var state_64878__$1 = state_64878;
var statearr_64880_64909 = state_64878__$1;
(statearr_64880_64909[(2)] = coll);

(statearr_64880_64909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (1))){
var state_64878__$1 = state_64878;
var statearr_64881_64910 = state_64878__$1;
(statearr_64881_64910[(2)] = null);

(statearr_64881_64910[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (4))){
var inst_64833 = (state_64878[(2)]);
var state_64878__$1 = state_64878;
var statearr_64882_64911 = state_64878__$1;
(statearr_64882_64911[(2)] = inst_64833);

(statearr_64882_64911[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (15))){
var inst_64852 = (state_64878[(7)]);
var inst_64860 = (state_64878[(2)]);
var inst_64861 = fluree.db.dbfunctions.internal.nth(inst_64852,inst_64860);
var inst_64862 = cljs.core.count(inst_64852);
var inst_64863 = ((9) + inst_64862);
var inst_64864 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64865 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64866 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64867 = [inst_64852,inst_64860];
var inst_64868 = (new cljs.core.PersistentVector(null,2,(5),inst_64866,inst_64867,null));
var inst_64869 = ["nth",inst_64868,inst_64861];
var inst_64870 = cljs.core.PersistentHashMap.fromArrays(inst_64865,inst_64869);
var inst_64871 = [inst_64870,inst_64863];
var inst_64872 = (new cljs.core.PersistentVector(null,2,(5),inst_64864,inst_64871,null));
var inst_64873 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64872);
var _ = (function (){var statearr_64883 = state_64878;
(statearr_64883[(4)] = cljs.core.rest((state_64878[(4)])));

return statearr_64883;
})();
var state_64878__$1 = (function (){var statearr_64884 = state_64878;
(statearr_64884[(8)] = inst_64873);

return statearr_64884;
})();
var statearr_64885_64912 = state_64878__$1;
(statearr_64885_64912[(2)] = inst_64861);

(statearr_64885_64912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (13))){
var state_64878__$1 = state_64878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64878__$1,(16),key);
} else {
if((state_val_64879 === (6))){
var state_64878__$1 = state_64878;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64878__$1,(9),coll);
} else {
if((state_val_64879 === (3))){
var inst_64876 = (state_64878[(2)]);
var state_64878__$1 = state_64878;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64878__$1,inst_64876);
} else {
if((state_val_64879 === (12))){
var inst_64852 = (state_64878[(2)]);
var inst_64853 = fluree.db.util.async.channel_QMARK_(key);
var state_64878__$1 = (function (){var statearr_64886 = state_64878;
(statearr_64886[(7)] = inst_64852);

return statearr_64886;
})();
if(inst_64853){
var statearr_64887_64913 = state_64878__$1;
(statearr_64887_64913[(1)] = (13));

} else {
var statearr_64888_64914 = state_64878__$1;
(statearr_64888_64914[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (2))){
var _ = (function (){var statearr_64889 = state_64878;
(statearr_64889[(4)] = cljs.core.cons((5),(state_64878[(4)])));

return statearr_64889;
})();
var inst_64839 = fluree.db.util.async.channel_QMARK_(coll);
var state_64878__$1 = state_64878;
if(inst_64839){
var statearr_64890_64915 = state_64878__$1;
(statearr_64890_64915[(1)] = (6));

} else {
var statearr_64891_64916 = state_64878__$1;
(statearr_64891_64916[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (11))){
var inst_64846 = (state_64878[(9)]);
var state_64878__$1 = state_64878;
var statearr_64893_64917 = state_64878__$1;
(statearr_64893_64917[(2)] = inst_64846);

(statearr_64893_64917[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (9))){
var inst_64842 = (state_64878[(2)]);
var inst_64843 = fluree.db.util.async.throw_err(inst_64842);
var state_64878__$1 = state_64878;
var statearr_64894_64918 = state_64878__$1;
(statearr_64894_64918[(2)] = inst_64843);

(statearr_64894_64918[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (5))){
var _ = (function (){var statearr_64895 = state_64878;
(statearr_64895[(4)] = cljs.core.rest((state_64878[(4)])));

return statearr_64895;
})();
var state_64878__$1 = state_64878;
var ex64892 = (state_64878__$1[(2)]);
var statearr_64896_64919 = state_64878__$1;
(statearr_64896_64919[(5)] = ex64892);


if((ex64892 instanceof Error)){
var statearr_64897_64920 = state_64878__$1;
(statearr_64897_64920[(1)] = (4));

(statearr_64897_64920[(5)] = null);

} else {
throw ex64892;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (14))){
var state_64878__$1 = state_64878;
var statearr_64898_64921 = state_64878__$1;
(statearr_64898_64921[(2)] = key);

(statearr_64898_64921[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (16))){
var inst_64856 = (state_64878[(2)]);
var inst_64857 = fluree.db.util.async.throw_err(inst_64856);
var state_64878__$1 = state_64878;
var statearr_64899_64922 = state_64878__$1;
(statearr_64899_64922[(2)] = inst_64857);

(statearr_64899_64922[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (10))){
var inst_64846 = (state_64878[(9)]);
var inst_64849 = cljs.core.vec(inst_64846);
var state_64878__$1 = state_64878;
var statearr_64900_64923 = state_64878__$1;
(statearr_64900_64923[(2)] = inst_64849);

(statearr_64900_64923[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64879 === (8))){
var inst_64846 = (state_64878[(9)]);
var inst_64846__$1 = (state_64878[(2)]);
var inst_64847 = cljs.core.set_QMARK_(inst_64846__$1);
var state_64878__$1 = (function (){var statearr_64901 = state_64878;
(statearr_64901[(9)] = inst_64846__$1);

return statearr_64901;
})();
if(inst_64847){
var statearr_64902_64924 = state_64878__$1;
(statearr_64902_64924[(1)] = (10));

} else {
var statearr_64903_64925 = state_64878__$1;
(statearr_64903_64925[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____0 = (function (){
var statearr_64904 = [null,null,null,null,null,null,null,null,null,null];
(statearr_64904[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__);

(statearr_64904[(1)] = (1));

return statearr_64904;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____1 = (function (state_64878){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_64878);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e64905){var ex__10753__auto__ = e64905;
var statearr_64906_64926 = state_64878;
(statearr_64906_64926[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_64878[(4)]))){
var statearr_64907_64927 = state_64878;
(statearr_64907_64927[(1)] = cljs.core.first((state_64878[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__64928 = state_64878;
state_64878 = G__64928;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__ = function(state_64878){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____1.call(this,state_64878);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_64908 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_64908[(6)] = c__10876__auto__);

return statearr_64908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_64989){
var state_val_64990 = (state_64989[(1)]);
if((state_val_64990 === (7))){
var state_64989__$1 = state_64989;
var statearr_64991_65025 = state_64989__$1;
(statearr_64991_65025[(2)] = test);

(statearr_64991_65025[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (20))){
var inst_64963 = (state_64989[(2)]);
var inst_64964 = fluree.db.util.async.throw_err(inst_64963);
var state_64989__$1 = state_64989;
var statearr_64992_65026 = state_64989__$1;
(statearr_64992_65026[(2)] = inst_64964);

(statearr_64992_65026[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (1))){
var state_64989__$1 = state_64989;
var statearr_64993_65027 = state_64989__$1;
(statearr_64993_65027[(2)] = null);

(statearr_64993_65027[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (4))){
var inst_64929 = (state_64989[(2)]);
var state_64989__$1 = state_64989;
var statearr_64994_65028 = state_64989__$1;
(statearr_64994_65028[(2)] = inst_64929);

(statearr_64994_65028[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (15))){
var inst_64947 = (state_64989[(7)]);
var inst_64955 = (state_64989[(2)]);
var inst_64956 = [inst_64955,f];
var inst_64957 = (new cljs.core.PersistentVector(null,2,(5),inst_64947,inst_64956,null));
var state_64989__$1 = state_64989;
var statearr_64995_65029 = state_64989__$1;
(statearr_64995_65029[(2)] = inst_64957);

(statearr_64995_65029[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (13))){
var state_64989__$1 = state_64989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64989__$1,(16),t);
} else {
if((state_val_64990 === (6))){
var state_64989__$1 = state_64989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64989__$1,(9),test);
} else {
if((state_val_64990 === (17))){
var state_64989__$1 = state_64989;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_64989__$1,(20),f);
} else {
if((state_val_64990 === (3))){
var inst_64987 = (state_64989[(2)]);
var state_64989__$1 = state_64989;
return cljs.core.async.impl.ioc_helpers.return_chan(state_64989__$1,inst_64987);
} else {
if((state_val_64990 === (12))){
var inst_64945 = (state_64989[(8)]);
var inst_64971 = (state_64989[(2)]);
var inst_64972 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64971,(0),null);
var inst_64973 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_64971,(1),null);
var inst_64974 = fluree.db.dbfunctions.internal.if_else(inst_64945,inst_64972,inst_64973);
var inst_64975 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64976 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_64977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64978 = [inst_64945,inst_64972,inst_64973];
var inst_64979 = (new cljs.core.PersistentVector(null,3,(5),inst_64977,inst_64978,null));
var inst_64980 = ["if-else",inst_64979,inst_64974];
var inst_64981 = cljs.core.PersistentHashMap.fromArrays(inst_64976,inst_64980);
var inst_64982 = [inst_64981,(10)];
var inst_64983 = (new cljs.core.PersistentVector(null,2,(5),inst_64975,inst_64982,null));
var inst_64984 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_64983);
var _ = (function (){var statearr_64996 = state_64989;
(statearr_64996[(4)] = cljs.core.rest((state_64989[(4)])));

return statearr_64996;
})();
var state_64989__$1 = (function (){var statearr_64997 = state_64989;
(statearr_64997[(9)] = inst_64984);

return statearr_64997;
})();
var statearr_64998_65030 = state_64989__$1;
(statearr_64998_65030[(2)] = inst_64974);

(statearr_64998_65030[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (2))){
var _ = (function (){var statearr_64999 = state_64989;
(statearr_64999[(4)] = cljs.core.cons((5),(state_64989[(4)])));

return statearr_64999;
})();
var inst_64938 = fluree.db.util.async.channel_QMARK_(test);
var state_64989__$1 = state_64989;
if(inst_64938){
var statearr_65000_65031 = state_64989__$1;
(statearr_65000_65031[(1)] = (6));

} else {
var statearr_65001_65032 = state_64989__$1;
(statearr_65001_65032[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (19))){
var inst_64959 = (state_64989[(10)]);
var inst_64967 = (state_64989[(2)]);
var inst_64968 = [f,inst_64967];
var inst_64969 = (new cljs.core.PersistentVector(null,2,(5),inst_64959,inst_64968,null));
var state_64989__$1 = state_64989;
var statearr_65002_65033 = state_64989__$1;
(statearr_65002_65033[(2)] = inst_64969);

(statearr_65002_65033[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (11))){
var inst_64959 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64960 = fluree.db.util.async.channel_QMARK_(f);
var state_64989__$1 = (function (){var statearr_65004 = state_64989;
(statearr_65004[(10)] = inst_64959);

return statearr_65004;
})();
if(inst_64960){
var statearr_65005_65034 = state_64989__$1;
(statearr_65005_65034[(1)] = (17));

} else {
var statearr_65006_65035 = state_64989__$1;
(statearr_65006_65035[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (9))){
var inst_64941 = (state_64989[(2)]);
var inst_64942 = fluree.db.util.async.throw_err(inst_64941);
var state_64989__$1 = state_64989;
var statearr_65007_65036 = state_64989__$1;
(statearr_65007_65036[(2)] = inst_64942);

(statearr_65007_65036[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (5))){
var _ = (function (){var statearr_65008 = state_64989;
(statearr_65008[(4)] = cljs.core.rest((state_64989[(4)])));

return statearr_65008;
})();
var state_64989__$1 = state_64989;
var ex65003 = (state_64989__$1[(2)]);
var statearr_65009_65037 = state_64989__$1;
(statearr_65009_65037[(5)] = ex65003);


if((ex65003 instanceof Error)){
var statearr_65010_65038 = state_64989__$1;
(statearr_65010_65038[(1)] = (4));

(statearr_65010_65038[(5)] = null);

} else {
throw ex65003;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (14))){
var state_64989__$1 = state_64989;
var statearr_65011_65039 = state_64989__$1;
(statearr_65011_65039[(2)] = t);

(statearr_65011_65039[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (16))){
var inst_64951 = (state_64989[(2)]);
var inst_64952 = fluree.db.util.async.throw_err(inst_64951);
var state_64989__$1 = state_64989;
var statearr_65012_65040 = state_64989__$1;
(statearr_65012_65040[(2)] = inst_64952);

(statearr_65012_65040[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (10))){
var inst_64947 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_64948 = fluree.db.util.async.channel_QMARK_(t);
var state_64989__$1 = (function (){var statearr_65013 = state_64989;
(statearr_65013[(7)] = inst_64947);

return statearr_65013;
})();
if(inst_64948){
var statearr_65014_65041 = state_64989__$1;
(statearr_65014_65041[(1)] = (13));

} else {
var statearr_65015_65042 = state_64989__$1;
(statearr_65015_65042[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (18))){
var state_64989__$1 = state_64989;
var statearr_65016_65043 = state_64989__$1;
(statearr_65016_65043[(2)] = f);

(statearr_65016_65043[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_64990 === (8))){
var inst_64945 = (state_64989[(8)]);
var inst_64945__$1 = (state_64989[(2)]);
var state_64989__$1 = (function (){var statearr_65017 = state_64989;
(statearr_65017[(8)] = inst_64945__$1);

return statearr_65017;
})();
if(cljs.core.truth_(inst_64945__$1)){
var statearr_65018_65044 = state_64989__$1;
(statearr_65018_65044[(1)] = (10));

} else {
var statearr_65019_65045 = state_64989__$1;
(statearr_65019_65045[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____0 = (function (){
var statearr_65020 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_65020[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__);

(statearr_65020[(1)] = (1));

return statearr_65020;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____1 = (function (state_64989){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_64989);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65021){var ex__10753__auto__ = e65021;
var statearr_65022_65046 = state_64989;
(statearr_65022_65046[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_64989[(4)]))){
var statearr_65023_65047 = state_64989;
(statearr_65023_65047[(1)] = cljs.core.first((state_64989[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65048 = state_64989;
state_64989 = G__65048;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__ = function(state_64989){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____1.call(this,state_64989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65024 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65024[(6)] = c__10876__auto__);

return statearr_65024;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65078){
var state_val_65079 = (state_65078[(1)]);
if((state_val_65079 === (7))){
var state_65078__$1 = state_65078;
var statearr_65080_65099 = state_65078__$1;
(statearr_65080_65099[(2)] = arg);

(statearr_65080_65099[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (1))){
var state_65078__$1 = state_65078;
var statearr_65081_65100 = state_65078__$1;
(statearr_65081_65100[(2)] = null);

(statearr_65081_65100[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (4))){
var inst_65049 = (state_65078[(2)]);
var state_65078__$1 = state_65078;
var statearr_65082_65101 = state_65078__$1;
(statearr_65082_65101[(2)] = inst_65049);

(statearr_65082_65101[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (6))){
var state_65078__$1 = state_65078;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65078__$1,(9),arg);
} else {
if((state_val_65079 === (3))){
var inst_65076 = (state_65078[(2)]);
var state_65078__$1 = state_65078;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65078__$1,inst_65076);
} else {
if((state_val_65079 === (2))){
var _ = (function (){var statearr_65084 = state_65078;
(statearr_65084[(4)] = cljs.core.cons((5),(state_65078[(4)])));

return statearr_65084;
})();
var inst_65055 = fluree.db.util.async.channel_QMARK_(arg);
var state_65078__$1 = state_65078;
if(inst_65055){
var statearr_65085_65102 = state_65078__$1;
(statearr_65085_65102[(1)] = (6));

} else {
var statearr_65086_65103 = state_65078__$1;
(statearr_65086_65103[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (9))){
var inst_65058 = (state_65078[(2)]);
var inst_65059 = fluree.db.util.async.throw_err(inst_65058);
var state_65078__$1 = state_65078;
var statearr_65087_65104 = state_65078__$1;
(statearr_65087_65104[(2)] = inst_65059);

(statearr_65087_65104[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (5))){
var _ = (function (){var statearr_65088 = state_65078;
(statearr_65088[(4)] = cljs.core.rest((state_65078[(4)])));

return statearr_65088;
})();
var state_65078__$1 = state_65078;
var ex65083 = (state_65078__$1[(2)]);
var statearr_65089_65105 = state_65078__$1;
(statearr_65089_65105[(5)] = ex65083);


if((ex65083 instanceof Error)){
var statearr_65090_65106 = state_65078__$1;
(statearr_65090_65106[(1)] = (4));

(statearr_65090_65106[(5)] = null);

} else {
throw ex65083;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65079 === (8))){
var inst_65062 = (state_65078[(2)]);
var inst_65063 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_65062);
var inst_65064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65065 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65066 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65067 = [inst_65062];
var inst_65068 = (new cljs.core.PersistentVector(null,1,(5),inst_65066,inst_65067,null));
var inst_65069 = ["nil?",inst_65068,inst_65063];
var inst_65070 = cljs.core.PersistentHashMap.fromArrays(inst_65065,inst_65069);
var inst_65071 = [inst_65070,(10)];
var inst_65072 = (new cljs.core.PersistentVector(null,2,(5),inst_65064,inst_65071,null));
var inst_65073 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65072);
var _ = (function (){var statearr_65091 = state_65078;
(statearr_65091[(4)] = cljs.core.rest((state_65078[(4)])));

return statearr_65091;
})();
var state_65078__$1 = (function (){var statearr_65092 = state_65078;
(statearr_65092[(7)] = inst_65073);

return statearr_65092;
})();
var statearr_65093_65107 = state_65078__$1;
(statearr_65093_65107[(2)] = inst_65063);

(statearr_65093_65107[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_65094 = [null,null,null,null,null,null,null,null];
(statearr_65094[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__);

(statearr_65094[(1)] = (1));

return statearr_65094;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____1 = (function (state_65078){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65078);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65095){var ex__10753__auto__ = e65095;
var statearr_65096_65108 = state_65078;
(statearr_65096_65108[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65078[(4)]))){
var statearr_65097_65109 = state_65078;
(statearr_65097_65109[(1)] = cljs.core.first((state_65078[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65110 = state_65078;
state_65078 = G__65110;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__ = function(state_65078){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____1.call(this,state_65078);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65098 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65098[(6)] = c__10876__auto__);

return statearr_65098;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65140){
var state_val_65141 = (state_65140[(1)]);
if((state_val_65141 === (7))){
var state_65140__$1 = state_65140;
var statearr_65142_65161 = state_65140__$1;
(statearr_65142_65161[(2)] = arg);

(statearr_65142_65161[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (1))){
var state_65140__$1 = state_65140;
var statearr_65143_65162 = state_65140__$1;
(statearr_65143_65162[(2)] = null);

(statearr_65143_65162[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (4))){
var inst_65111 = (state_65140[(2)]);
var state_65140__$1 = state_65140;
var statearr_65144_65163 = state_65140__$1;
(statearr_65144_65163[(2)] = inst_65111);

(statearr_65144_65163[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (6))){
var state_65140__$1 = state_65140;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65140__$1,(9),arg);
} else {
if((state_val_65141 === (3))){
var inst_65138 = (state_65140[(2)]);
var state_65140__$1 = state_65140;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65140__$1,inst_65138);
} else {
if((state_val_65141 === (2))){
var _ = (function (){var statearr_65146 = state_65140;
(statearr_65146[(4)] = cljs.core.cons((5),(state_65140[(4)])));

return statearr_65146;
})();
var inst_65117 = fluree.db.util.async.channel_QMARK_(arg);
var state_65140__$1 = state_65140;
if(inst_65117){
var statearr_65147_65164 = state_65140__$1;
(statearr_65147_65164[(1)] = (6));

} else {
var statearr_65148_65165 = state_65140__$1;
(statearr_65148_65165[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (9))){
var inst_65120 = (state_65140[(2)]);
var inst_65121 = fluree.db.util.async.throw_err(inst_65120);
var state_65140__$1 = state_65140;
var statearr_65149_65166 = state_65140__$1;
(statearr_65149_65166[(2)] = inst_65121);

(statearr_65149_65166[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (5))){
var _ = (function (){var statearr_65150 = state_65140;
(statearr_65150[(4)] = cljs.core.rest((state_65140[(4)])));

return statearr_65150;
})();
var state_65140__$1 = state_65140;
var ex65145 = (state_65140__$1[(2)]);
var statearr_65151_65167 = state_65140__$1;
(statearr_65151_65167[(5)] = ex65145);


if((ex65145 instanceof Error)){
var statearr_65152_65168 = state_65140__$1;
(statearr_65152_65168[(1)] = (4));

(statearr_65152_65168[(5)] = null);

} else {
throw ex65145;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65141 === (8))){
var inst_65124 = (state_65140[(2)]);
var inst_65125 = fluree.db.dbfunctions.internal.not(inst_65124);
var inst_65126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65127 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65128 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65129 = [inst_65124];
var inst_65130 = (new cljs.core.PersistentVector(null,1,(5),inst_65128,inst_65129,null));
var inst_65131 = ["not?",inst_65130,inst_65125];
var inst_65132 = cljs.core.PersistentHashMap.fromArrays(inst_65127,inst_65131);
var inst_65133 = [inst_65132,(10)];
var inst_65134 = (new cljs.core.PersistentVector(null,2,(5),inst_65126,inst_65133,null));
var inst_65135 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65134);
var _ = (function (){var statearr_65153 = state_65140;
(statearr_65153[(4)] = cljs.core.rest((state_65140[(4)])));

return statearr_65153;
})();
var state_65140__$1 = (function (){var statearr_65154 = state_65140;
(statearr_65154[(7)] = inst_65135);

return statearr_65154;
})();
var statearr_65155_65169 = state_65140__$1;
(statearr_65155_65169[(2)] = inst_65125);

(statearr_65155_65169[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____0 = (function (){
var statearr_65156 = [null,null,null,null,null,null,null,null];
(statearr_65156[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__);

(statearr_65156[(1)] = (1));

return statearr_65156;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____1 = (function (state_65140){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65140);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65157){var ex__10753__auto__ = e65157;
var statearr_65158_65170 = state_65140;
(statearr_65158_65170[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65140[(4)]))){
var statearr_65159_65171 = state_65140;
(statearr_65159_65171[(1)] = cljs.core.first((state_65140[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65172 = state_65140;
state_65140 = G__65172;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__ = function(state_65140){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____1.call(this,state_65140);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65160 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65160[(6)] = c__10876__auto__);

return statearr_65160;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65202){
var state_val_65203 = (state_65202[(1)]);
if((state_val_65203 === (7))){
var state_65202__$1 = state_65202;
var statearr_65204_65223 = state_65202__$1;
(statearr_65204_65223[(2)] = arg);

(statearr_65204_65223[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (1))){
var state_65202__$1 = state_65202;
var statearr_65205_65224 = state_65202__$1;
(statearr_65205_65224[(2)] = null);

(statearr_65205_65224[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (4))){
var inst_65173 = (state_65202[(2)]);
var state_65202__$1 = state_65202;
var statearr_65206_65225 = state_65202__$1;
(statearr_65206_65225[(2)] = inst_65173);

(statearr_65206_65225[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (6))){
var state_65202__$1 = state_65202;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65202__$1,(9),arg);
} else {
if((state_val_65203 === (3))){
var inst_65200 = (state_65202[(2)]);
var state_65202__$1 = state_65202;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65202__$1,inst_65200);
} else {
if((state_val_65203 === (2))){
var _ = (function (){var statearr_65208 = state_65202;
(statearr_65208[(4)] = cljs.core.cons((5),(state_65202[(4)])));

return statearr_65208;
})();
var inst_65179 = fluree.db.util.async.channel_QMARK_(arg);
var state_65202__$1 = state_65202;
if(inst_65179){
var statearr_65209_65226 = state_65202__$1;
(statearr_65209_65226[(1)] = (6));

} else {
var statearr_65210_65227 = state_65202__$1;
(statearr_65210_65227[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (9))){
var inst_65182 = (state_65202[(2)]);
var inst_65183 = fluree.db.util.async.throw_err(inst_65182);
var state_65202__$1 = state_65202;
var statearr_65211_65228 = state_65202__$1;
(statearr_65211_65228[(2)] = inst_65183);

(statearr_65211_65228[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (5))){
var _ = (function (){var statearr_65212 = state_65202;
(statearr_65212[(4)] = cljs.core.rest((state_65202[(4)])));

return statearr_65212;
})();
var state_65202__$1 = state_65202;
var ex65207 = (state_65202__$1[(2)]);
var statearr_65213_65229 = state_65202__$1;
(statearr_65213_65229[(5)] = ex65207);


if((ex65207 instanceof Error)){
var statearr_65214_65230 = state_65202__$1;
(statearr_65214_65230[(1)] = (4));

(statearr_65214_65230[(5)] = null);

} else {
throw ex65207;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65203 === (8))){
var inst_65186 = (state_65202[(2)]);
var inst_65187 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_65186);
var inst_65188 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65189 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65190 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65191 = [inst_65186];
var inst_65192 = (new cljs.core.PersistentVector(null,1,(5),inst_65190,inst_65191,null));
var inst_65193 = ["empty?",inst_65192,inst_65187];
var inst_65194 = cljs.core.PersistentHashMap.fromArrays(inst_65189,inst_65193);
var inst_65195 = [inst_65194,(10)];
var inst_65196 = (new cljs.core.PersistentVector(null,2,(5),inst_65188,inst_65195,null));
var inst_65197 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65196);
var _ = (function (){var statearr_65215 = state_65202;
(statearr_65215[(4)] = cljs.core.rest((state_65202[(4)])));

return statearr_65215;
})();
var state_65202__$1 = (function (){var statearr_65216 = state_65202;
(statearr_65216[(7)] = inst_65197);

return statearr_65216;
})();
var statearr_65217_65231 = state_65202__$1;
(statearr_65217_65231[(2)] = inst_65187);

(statearr_65217_65231[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_65218 = [null,null,null,null,null,null,null,null];
(statearr_65218[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__);

(statearr_65218[(1)] = (1));

return statearr_65218;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____1 = (function (state_65202){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65202);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65219){var ex__10753__auto__ = e65219;
var statearr_65220_65232 = state_65202;
(statearr_65220_65232[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65202[(4)]))){
var statearr_65221_65233 = state_65202;
(statearr_65221_65233[(1)] = cljs.core.first((state_65202[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65234 = state_65202;
state_65202 = G__65234;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__ = function(state_65202){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____1.call(this,state_65202);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65222 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65222[(6)] = c__10876__auto__);

return statearr_65222;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___65279 = arguments.length;
var i__4819__auto___65280 = (0);
while(true){
if((i__4819__auto___65280 < len__4818__auto___65279)){
args__4824__auto__.push((arguments[i__4819__auto___65280]));

var G__65281 = (i__4819__auto___65280 + (1));
i__4819__auto___65280 = G__65281;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65262){
var state_val_65263 = (state_65262[(1)]);
if((state_val_65263 === (1))){
var state_65262__$1 = state_65262;
var statearr_65264_65282 = state_65262__$1;
(statearr_65264_65282[(2)] = null);

(statearr_65264_65282[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65263 === (2))){
var _ = (function (){var statearr_65265 = state_65262;
(statearr_65265[(4)] = cljs.core.cons((5),(state_65262[(4)])));

return statearr_65265;
})();
var inst_65243 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65262__$1 = state_65262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65262__$1,(6),inst_65243);
} else {
if((state_val_65263 === (3))){
var inst_65260 = (state_65262[(2)]);
var state_65262__$1 = state_65262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65262__$1,inst_65260);
} else {
if((state_val_65263 === (4))){
var inst_65237 = (state_65262[(2)]);
var state_65262__$1 = state_65262;
var statearr_65267_65283 = state_65262__$1;
(statearr_65267_65283[(2)] = inst_65237);

(statearr_65267_65283[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65263 === (5))){
var _ = (function (){var statearr_65268 = state_65262;
(statearr_65268[(4)] = cljs.core.rest((state_65262[(4)])));

return statearr_65268;
})();
var state_65262__$1 = state_65262;
var ex65266 = (state_65262__$1[(2)]);
var statearr_65269_65284 = state_65262__$1;
(statearr_65269_65284[(5)] = ex65266);


if((ex65266 instanceof Error)){
var statearr_65270_65285 = state_65262__$1;
(statearr_65270_65285[(1)] = (4));

(statearr_65270_65285[(5)] = null);

} else {
throw ex65266;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65263 === (6))){
var inst_65245 = (state_65262[(2)]);
var inst_65246 = fluree.db.util.async.throw_err(inst_65245);
var inst_65247 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_65246);
var inst_65248 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65249 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65250 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65251 = [inst_65246];
var inst_65252 = (new cljs.core.PersistentVector(null,1,(5),inst_65250,inst_65251,null));
var inst_65253 = ["str",inst_65252,inst_65247];
var inst_65254 = cljs.core.PersistentHashMap.fromArrays(inst_65249,inst_65253);
var inst_65255 = [inst_65254,(10)];
var inst_65256 = (new cljs.core.PersistentVector(null,2,(5),inst_65248,inst_65255,null));
var inst_65257 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65256);
var _ = (function (){var statearr_65271 = state_65262;
(statearr_65271[(4)] = cljs.core.rest((state_65262[(4)])));

return statearr_65271;
})();
var state_65262__$1 = (function (){var statearr_65272 = state_65262;
(statearr_65272[(7)] = inst_65257);

return statearr_65272;
})();
var statearr_65273_65286 = state_65262__$1;
(statearr_65273_65286[(2)] = inst_65247);

(statearr_65273_65286[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_65274 = [null,null,null,null,null,null,null,null];
(statearr_65274[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_65274[(1)] = (1));

return statearr_65274;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_65262){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65262);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65275){var ex__10753__auto__ = e65275;
var statearr_65276_65287 = state_65262;
(statearr_65276_65287[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65262[(4)]))){
var statearr_65277_65288 = state_65262;
(statearr_65277_65288[(1)] = cljs.core.first((state_65262[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65289 = state_65262;
state_65262 = G__65289;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_65262){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_65262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65278 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65278[(6)] = c__10876__auto__);

return statearr_65278;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq65235){
var G__65236 = cljs.core.first(seq65235);
var seq65235__$1 = cljs.core.next(seq65235);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65236,seq65235__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65315){
var state_val_65316 = (state_65315[(1)]);
if((state_val_65316 === (1))){
var state_65315__$1 = state_65315;
var statearr_65317_65332 = state_65315__$1;
(statearr_65317_65332[(2)] = null);

(statearr_65317_65332[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65316 === (2))){
var _ = (function (){var statearr_65318 = state_65315;
(statearr_65318[(4)] = cljs.core.cons((5),(state_65315[(4)])));

return statearr_65318;
})();
var inst_65296 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65315__$1 = state_65315;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65315__$1,(6),inst_65296);
} else {
if((state_val_65316 === (3))){
var inst_65313 = (state_65315[(2)]);
var state_65315__$1 = state_65315;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65315__$1,inst_65313);
} else {
if((state_val_65316 === (4))){
var inst_65290 = (state_65315[(2)]);
var state_65315__$1 = state_65315;
var statearr_65320_65333 = state_65315__$1;
(statearr_65320_65333[(2)] = inst_65290);

(statearr_65320_65333[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65316 === (5))){
var _ = (function (){var statearr_65321 = state_65315;
(statearr_65321[(4)] = cljs.core.rest((state_65315[(4)])));

return statearr_65321;
})();
var state_65315__$1 = state_65315;
var ex65319 = (state_65315__$1[(2)]);
var statearr_65322_65334 = state_65315__$1;
(statearr_65322_65334[(5)] = ex65319);


if((ex65319 instanceof Error)){
var statearr_65323_65335 = state_65315__$1;
(statearr_65323_65335[(1)] = (4));

(statearr_65323_65335[(5)] = null);

} else {
throw ex65319;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65316 === (6))){
var inst_65298 = (state_65315[(2)]);
var inst_65299 = fluree.db.util.async.throw_err(inst_65298);
var inst_65300 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_65299);
var inst_65301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65302 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65303 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65304 = [inst_65299];
var inst_65305 = (new cljs.core.PersistentVector(null,1,(5),inst_65303,inst_65304,null));
var inst_65306 = ["subs",inst_65305,inst_65300];
var inst_65307 = cljs.core.PersistentHashMap.fromArrays(inst_65302,inst_65306);
var inst_65308 = [inst_65307,(30)];
var inst_65309 = (new cljs.core.PersistentVector(null,2,(5),inst_65301,inst_65308,null));
var inst_65310 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65309);
var _ = (function (){var statearr_65324 = state_65315;
(statearr_65324[(4)] = cljs.core.rest((state_65315[(4)])));

return statearr_65324;
})();
var state_65315__$1 = (function (){var statearr_65325 = state_65315;
(statearr_65325[(7)] = inst_65310);

return statearr_65325;
})();
var statearr_65326_65336 = state_65315__$1;
(statearr_65326_65336[(2)] = inst_65300);

(statearr_65326_65336[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____0 = (function (){
var statearr_65327 = [null,null,null,null,null,null,null,null];
(statearr_65327[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__);

(statearr_65327[(1)] = (1));

return statearr_65327;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____1 = (function (state_65315){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65315);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65328){var ex__10753__auto__ = e65328;
var statearr_65329_65337 = state_65315;
(statearr_65329_65337[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65315[(4)]))){
var statearr_65330_65338 = state_65315;
(statearr_65330_65338[(1)] = cljs.core.first((state_65315[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65339 = state_65315;
state_65315 = G__65339;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__ = function(state_65315){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____1.call(this,state_65315);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65331 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65331[(6)] = c__10876__auto__);

return statearr_65331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65369){
var state_val_65370 = (state_65369[(1)]);
if((state_val_65370 === (7))){
var state_65369__$1 = state_65369;
var statearr_65371_65390 = state_65369__$1;
(statearr_65371_65390[(2)] = str);

(statearr_65371_65390[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (1))){
var state_65369__$1 = state_65369;
var statearr_65372_65391 = state_65369__$1;
(statearr_65372_65391[(2)] = null);

(statearr_65372_65391[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (4))){
var inst_65340 = (state_65369[(2)]);
var state_65369__$1 = state_65369;
var statearr_65373_65392 = state_65369__$1;
(statearr_65373_65392[(2)] = inst_65340);

(statearr_65373_65392[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (6))){
var state_65369__$1 = state_65369;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65369__$1,(9),str);
} else {
if((state_val_65370 === (3))){
var inst_65367 = (state_65369[(2)]);
var state_65369__$1 = state_65369;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65369__$1,inst_65367);
} else {
if((state_val_65370 === (2))){
var _ = (function (){var statearr_65375 = state_65369;
(statearr_65375[(4)] = cljs.core.cons((5),(state_65369[(4)])));

return statearr_65375;
})();
var inst_65346 = fluree.db.util.async.channel_QMARK_(str);
var state_65369__$1 = state_65369;
if(inst_65346){
var statearr_65376_65393 = state_65369__$1;
(statearr_65376_65393[(1)] = (6));

} else {
var statearr_65377_65394 = state_65369__$1;
(statearr_65377_65394[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (9))){
var inst_65349 = (state_65369[(2)]);
var inst_65350 = fluree.db.util.async.throw_err(inst_65349);
var state_65369__$1 = state_65369;
var statearr_65378_65395 = state_65369__$1;
(statearr_65378_65395[(2)] = inst_65350);

(statearr_65378_65395[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (5))){
var _ = (function (){var statearr_65379 = state_65369;
(statearr_65379[(4)] = cljs.core.rest((state_65369[(4)])));

return statearr_65379;
})();
var state_65369__$1 = state_65369;
var ex65374 = (state_65369__$1[(2)]);
var statearr_65380_65396 = state_65369__$1;
(statearr_65380_65396[(5)] = ex65374);


if((ex65374 instanceof Error)){
var statearr_65381_65397 = state_65369__$1;
(statearr_65381_65397[(1)] = (4));

(statearr_65381_65397[(5)] = null);

} else {
throw ex65374;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65370 === (8))){
var inst_65353 = (state_65369[(2)]);
var inst_65354 = fluree.db.dbfunctions.internal.lower_case(inst_65353);
var inst_65355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65356 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65357 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65358 = [inst_65353];
var inst_65359 = (new cljs.core.PersistentVector(null,1,(5),inst_65357,inst_65358,null));
var inst_65360 = ["lower-case",inst_65359,inst_65354];
var inst_65361 = cljs.core.PersistentHashMap.fromArrays(inst_65356,inst_65360);
var inst_65362 = [inst_65361,(10)];
var inst_65363 = (new cljs.core.PersistentVector(null,2,(5),inst_65355,inst_65362,null));
var inst_65364 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65363);
var _ = (function (){var statearr_65382 = state_65369;
(statearr_65382[(4)] = cljs.core.rest((state_65369[(4)])));

return statearr_65382;
})();
var state_65369__$1 = (function (){var statearr_65383 = state_65369;
(statearr_65383[(7)] = inst_65364);

return statearr_65383;
})();
var statearr_65384_65398 = state_65369__$1;
(statearr_65384_65398[(2)] = inst_65354);

(statearr_65384_65398[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____0 = (function (){
var statearr_65385 = [null,null,null,null,null,null,null,null];
(statearr_65385[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__);

(statearr_65385[(1)] = (1));

return statearr_65385;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____1 = (function (state_65369){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65369);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65386){var ex__10753__auto__ = e65386;
var statearr_65387_65399 = state_65369;
(statearr_65387_65399[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65369[(4)]))){
var statearr_65388_65400 = state_65369;
(statearr_65388_65400[(1)] = cljs.core.first((state_65369[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65401 = state_65369;
state_65369 = G__65401;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__ = function(state_65369){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____1.call(this,state_65369);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65389 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65389[(6)] = c__10876__auto__);

return statearr_65389;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65431){
var state_val_65432 = (state_65431[(1)]);
if((state_val_65432 === (7))){
var state_65431__$1 = state_65431;
var statearr_65433_65452 = state_65431__$1;
(statearr_65433_65452[(2)] = str);

(statearr_65433_65452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (1))){
var state_65431__$1 = state_65431;
var statearr_65434_65453 = state_65431__$1;
(statearr_65434_65453[(2)] = null);

(statearr_65434_65453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (4))){
var inst_65402 = (state_65431[(2)]);
var state_65431__$1 = state_65431;
var statearr_65435_65454 = state_65431__$1;
(statearr_65435_65454[(2)] = inst_65402);

(statearr_65435_65454[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (6))){
var state_65431__$1 = state_65431;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65431__$1,(9),str);
} else {
if((state_val_65432 === (3))){
var inst_65429 = (state_65431[(2)]);
var state_65431__$1 = state_65431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65431__$1,inst_65429);
} else {
if((state_val_65432 === (2))){
var _ = (function (){var statearr_65437 = state_65431;
(statearr_65437[(4)] = cljs.core.cons((5),(state_65431[(4)])));

return statearr_65437;
})();
var inst_65408 = fluree.db.util.async.channel_QMARK_(str);
var state_65431__$1 = state_65431;
if(inst_65408){
var statearr_65438_65455 = state_65431__$1;
(statearr_65438_65455[(1)] = (6));

} else {
var statearr_65439_65456 = state_65431__$1;
(statearr_65439_65456[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (9))){
var inst_65411 = (state_65431[(2)]);
var inst_65412 = fluree.db.util.async.throw_err(inst_65411);
var state_65431__$1 = state_65431;
var statearr_65440_65457 = state_65431__$1;
(statearr_65440_65457[(2)] = inst_65412);

(statearr_65440_65457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (5))){
var _ = (function (){var statearr_65441 = state_65431;
(statearr_65441[(4)] = cljs.core.rest((state_65431[(4)])));

return statearr_65441;
})();
var state_65431__$1 = state_65431;
var ex65436 = (state_65431__$1[(2)]);
var statearr_65442_65458 = state_65431__$1;
(statearr_65442_65458[(5)] = ex65436);


if((ex65436 instanceof Error)){
var statearr_65443_65459 = state_65431__$1;
(statearr_65443_65459[(1)] = (4));

(statearr_65443_65459[(5)] = null);

} else {
throw ex65436;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65432 === (8))){
var inst_65415 = (state_65431[(2)]);
var inst_65416 = fluree.db.dbfunctions.internal.upper_case(inst_65415);
var inst_65417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65418 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65420 = [inst_65415];
var inst_65421 = (new cljs.core.PersistentVector(null,1,(5),inst_65419,inst_65420,null));
var inst_65422 = ["upper-case",inst_65421,inst_65416];
var inst_65423 = cljs.core.PersistentHashMap.fromArrays(inst_65418,inst_65422);
var inst_65424 = [inst_65423,(10)];
var inst_65425 = (new cljs.core.PersistentVector(null,2,(5),inst_65417,inst_65424,null));
var inst_65426 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65425);
var _ = (function (){var statearr_65444 = state_65431;
(statearr_65444[(4)] = cljs.core.rest((state_65431[(4)])));

return statearr_65444;
})();
var state_65431__$1 = (function (){var statearr_65445 = state_65431;
(statearr_65445[(7)] = inst_65426);

return statearr_65445;
})();
var statearr_65446_65460 = state_65431__$1;
(statearr_65446_65460[(2)] = inst_65416);

(statearr_65446_65460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____0 = (function (){
var statearr_65447 = [null,null,null,null,null,null,null,null];
(statearr_65447[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__);

(statearr_65447[(1)] = (1));

return statearr_65447;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____1 = (function (state_65431){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65431);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65448){var ex__10753__auto__ = e65448;
var statearr_65449_65461 = state_65431;
(statearr_65449_65461[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65431[(4)]))){
var statearr_65450_65462 = state_65431;
(statearr_65450_65462[(1)] = cljs.core.first((state_65431[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65463 = state_65431;
state_65431 = G__65463;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__ = function(state_65431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____1.call(this,state_65431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65451 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65451[(6)] = c__10876__auto__);

return statearr_65451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__65465 = arguments.length;
switch (G__65465) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65493){
var state_val_65494 = (state_65493[(1)]);
if((state_val_65494 === (1))){
var state_65493__$1 = state_65493;
var statearr_65495_65511 = state_65493__$1;
(statearr_65495_65511[(2)] = null);

(statearr_65495_65511[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65494 === (2))){
var _ = (function (){var statearr_65496 = state_65493;
(statearr_65496[(4)] = cljs.core.cons((5),(state_65493[(4)])));

return statearr_65496;
})();
var inst_65475 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_65493__$1 = state_65493;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65493__$1,(6),inst_65475);
} else {
if((state_val_65494 === (3))){
var inst_65491 = (state_65493[(2)]);
var state_65493__$1 = state_65493;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65493__$1,inst_65491);
} else {
if((state_val_65494 === (4))){
var inst_65466 = (state_65493[(2)]);
var state_65493__$1 = state_65493;
var statearr_65498_65512 = state_65493__$1;
(statearr_65498_65512[(2)] = inst_65466);

(statearr_65498_65512[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65494 === (5))){
var _ = (function (){var statearr_65499 = state_65493;
(statearr_65499[(4)] = cljs.core.rest((state_65493[(4)])));

return statearr_65499;
})();
var state_65493__$1 = state_65493;
var ex65497 = (state_65493__$1[(2)]);
var statearr_65500_65513 = state_65493__$1;
(statearr_65500_65513[(5)] = ex65497);


if((ex65497 instanceof Error)){
var statearr_65501_65514 = state_65493__$1;
(statearr_65501_65514[(1)] = (4));

(statearr_65501_65514[(5)] = null);

} else {
throw ex65497;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65494 === (6))){
var inst_65477 = (state_65493[(2)]);
var inst_65478 = fluree.db.util.async.throw_err(inst_65477);
var inst_65479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65478,(0),null);
var inst_65480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65478,(1),null);
var inst_65481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65482 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65483 = ["?s","?ctx",inst_65479];
var inst_65484 = cljs.core.PersistentHashMap.fromArrays(inst_65482,inst_65483);
var inst_65485 = ((10) + inst_65480);
var inst_65486 = [inst_65484,inst_65485];
var inst_65487 = (new cljs.core.PersistentVector(null,2,(5),inst_65481,inst_65486,null));
var inst_65488 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65487);
var _ = (function (){var statearr_65502 = state_65493;
(statearr_65502[(4)] = cljs.core.rest((state_65493[(4)])));

return statearr_65502;
})();
var state_65493__$1 = (function (){var statearr_65503 = state_65493;
(statearr_65503[(7)] = inst_65488);

return statearr_65503;
})();
var statearr_65504_65515 = state_65493__$1;
(statearr_65504_65515[(2)] = inst_65479);

(statearr_65504_65515[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_65505 = [null,null,null,null,null,null,null,null];
(statearr_65505[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_65505[(1)] = (1));

return statearr_65505;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_65493){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65493);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65506){var ex__10753__auto__ = e65506;
var statearr_65507_65516 = state_65493;
(statearr_65507_65516[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65493[(4)]))){
var statearr_65508_65517 = state_65493;
(statearr_65508_65517[(1)] = cljs.core.first((state_65493[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65518 = state_65493;
state_65493 = G__65518;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_65493){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_65493);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65509 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65509[(6)] = c__10876__auto__);

return statearr_65509;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__65520 = arguments.length;
switch (G__65520) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65558){
var state_val_65559 = (state_65558[(1)]);
if((state_val_65559 === (7))){
var inst_65551 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_65558__$1 = state_65558;
var statearr_65560_65580 = state_65558__$1;
(statearr_65560_65580[(2)] = inst_65551);

(statearr_65560_65580[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (1))){
var state_65558__$1 = state_65558;
var statearr_65561_65581 = state_65558__$1;
(statearr_65561_65581[(2)] = null);

(statearr_65561_65581[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (4))){
var inst_65521 = (state_65558[(2)]);
var state_65558__$1 = state_65558;
var statearr_65562_65582 = state_65558__$1;
(statearr_65562_65582[(2)] = inst_65521);

(statearr_65562_65582[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (6))){
var inst_65532 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_65558__$1 = state_65558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65558__$1,(10),inst_65532);
} else {
if((state_val_65559 === (3))){
var inst_65556 = (state_65558[(2)]);
var state_65558__$1 = state_65558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65558__$1,inst_65556);
} else {
if((state_val_65559 === (2))){
var _ = (function (){var statearr_65564 = state_65558;
(statearr_65564[(4)] = cljs.core.cons((5),(state_65558[(4)])));

return statearr_65564;
})();
var inst_65527 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65558__$1 = state_65558;
if(cljs.core.truth_(inst_65527)){
var statearr_65565_65583 = state_65558__$1;
(statearr_65565_65583[(1)] = (6));

} else {
var statearr_65566_65584 = state_65558__$1;
(statearr_65566_65584[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (9))){
var inst_65538 = (state_65558[(2)]);
var inst_65539 = fluree.db.util.async.throw_err(inst_65538);
var inst_65540 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65539,(0),null);
var inst_65541 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65539,(1),null);
var inst_65542 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65543 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65544 = ["?p","?ctx",inst_65540];
var inst_65545 = cljs.core.PersistentHashMap.fromArrays(inst_65543,inst_65544);
var inst_65546 = ((10) + inst_65541);
var inst_65547 = [inst_65545,inst_65546];
var inst_65548 = (new cljs.core.PersistentVector(null,2,(5),inst_65542,inst_65547,null));
var inst_65549 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65548);
var state_65558__$1 = (function (){var statearr_65567 = state_65558;
(statearr_65567[(7)] = inst_65549);

return statearr_65567;
})();
var statearr_65568_65585 = state_65558__$1;
(statearr_65568_65585[(2)] = inst_65540);

(statearr_65568_65585[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (5))){
var _ = (function (){var statearr_65569 = state_65558;
(statearr_65569[(4)] = cljs.core.rest((state_65558[(4)])));

return statearr_65569;
})();
var state_65558__$1 = state_65558;
var ex65563 = (state_65558__$1[(2)]);
var statearr_65570_65586 = state_65558__$1;
(statearr_65570_65586[(5)] = ex65563);


if((ex65563 instanceof Error)){
var statearr_65571_65587 = state_65558__$1;
(statearr_65571_65587[(1)] = (4));

(statearr_65571_65587[(5)] = null);

} else {
throw ex65563;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65559 === (10))){
var inst_65534 = (state_65558[(2)]);
var inst_65535 = fluree.db.util.async.throw_err(inst_65534);
var inst_65536 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_65535);
var state_65558__$1 = state_65558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65558__$1,(9),inst_65536);
} else {
if((state_val_65559 === (8))){
var inst_65553 = (state_65558[(2)]);
var _ = (function (){var statearr_65572 = state_65558;
(statearr_65572[(4)] = cljs.core.rest((state_65558[(4)])));

return statearr_65572;
})();
var state_65558__$1 = state_65558;
var statearr_65573_65588 = state_65558__$1;
(statearr_65573_65588[(2)] = inst_65553);

(statearr_65573_65588[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_65574 = [null,null,null,null,null,null,null,null];
(statearr_65574[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_65574[(1)] = (1));

return statearr_65574;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_65558){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65558);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65575){var ex__10753__auto__ = e65575;
var statearr_65576_65589 = state_65558;
(statearr_65576_65589[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65558[(4)]))){
var statearr_65577_65590 = state_65558;
(statearr_65577_65590[(1)] = cljs.core.first((state_65558[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65591 = state_65558;
state_65558 = G__65591;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_65558){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_65558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65578 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65578[(6)] = c__10876__auto__);

return statearr_65578;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___65640 = arguments.length;
var i__4819__auto___65641 = (0);
while(true){
if((i__4819__auto___65641 < len__4818__auto___65640)){
args__4824__auto__.push((arguments[i__4819__auto___65641]));

var G__65642 = (i__4819__auto___65641 + (1));
i__4819__auto___65641 = G__65642;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65623){
var state_val_65624 = (state_65623[(1)]);
if((state_val_65624 === (1))){
var state_65623__$1 = state_65623;
var statearr_65625_65643 = state_65623__$1;
(statearr_65625_65643[(2)] = null);

(statearr_65625_65643[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65624 === (2))){
var _ = (function (){var statearr_65626 = state_65623;
(statearr_65626[(4)] = cljs.core.cons((5),(state_65623[(4)])));

return statearr_65626;
})();
var inst_65600 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65623__$1 = state_65623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65623__$1,(6),inst_65600);
} else {
if((state_val_65624 === (3))){
var inst_65621 = (state_65623[(2)]);
var state_65623__$1 = state_65623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65623__$1,inst_65621);
} else {
if((state_val_65624 === (4))){
var inst_65594 = (state_65623[(2)]);
var state_65623__$1 = state_65623;
var statearr_65628_65644 = state_65623__$1;
(statearr_65628_65644[(2)] = inst_65594);

(statearr_65628_65644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65624 === (5))){
var _ = (function (){var statearr_65629 = state_65623;
(statearr_65629[(4)] = cljs.core.rest((state_65623[(4)])));

return statearr_65629;
})();
var state_65623__$1 = state_65623;
var ex65627 = (state_65623__$1[(2)]);
var statearr_65630_65645 = state_65623__$1;
(statearr_65630_65645[(5)] = ex65627);


if((ex65627 instanceof Error)){
var statearr_65631_65646 = state_65623__$1;
(statearr_65631_65646[(1)] = (4));

(statearr_65631_65646[(5)] = null);

} else {
throw ex65627;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65624 === (6))){
var inst_65602 = (state_65623[(2)]);
var inst_65603 = fluree.db.util.async.throw_err(inst_65602);
var inst_65604 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_65603);
var inst_65605 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65606 = [inst_65603];
var inst_65607 = (new cljs.core.PersistentVector(null,1,(5),inst_65605,inst_65606,null));
var inst_65608 = cljs.core.count(inst_65607);
var inst_65609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65610 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65612 = [inst_65603];
var inst_65613 = (new cljs.core.PersistentVector(null,1,(5),inst_65611,inst_65612,null));
var inst_65614 = ["and",inst_65613,inst_65604];
var inst_65615 = cljs.core.PersistentHashMap.fromArrays(inst_65610,inst_65614);
var inst_65616 = [inst_65615,inst_65608];
var inst_65617 = (new cljs.core.PersistentVector(null,2,(5),inst_65609,inst_65616,null));
var inst_65618 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65617);
var _ = (function (){var statearr_65632 = state_65623;
(statearr_65632[(4)] = cljs.core.rest((state_65623[(4)])));

return statearr_65632;
})();
var state_65623__$1 = (function (){var statearr_65633 = state_65623;
(statearr_65633[(7)] = inst_65618);

return statearr_65633;
})();
var statearr_65634_65647 = state_65623__$1;
(statearr_65634_65647[(2)] = inst_65604);

(statearr_65634_65647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_65635 = [null,null,null,null,null,null,null,null];
(statearr_65635[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_65635[(1)] = (1));

return statearr_65635;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_65623){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65623);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65636){var ex__10753__auto__ = e65636;
var statearr_65637_65648 = state_65623;
(statearr_65637_65648[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65623[(4)]))){
var statearr_65638_65649 = state_65623;
(statearr_65638_65649[(1)] = cljs.core.first((state_65623[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65650 = state_65623;
state_65623 = G__65650;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_65623){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_65623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65639 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65639[(6)] = c__10876__auto__);

return statearr_65639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq65592){
var G__65593 = cljs.core.first(seq65592);
var seq65592__$1 = cljs.core.next(seq65592);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65593,seq65592__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___65699 = arguments.length;
var i__4819__auto___65700 = (0);
while(true){
if((i__4819__auto___65700 < len__4818__auto___65699)){
args__4824__auto__.push((arguments[i__4819__auto___65700]));

var G__65701 = (i__4819__auto___65700 + (1));
i__4819__auto___65700 = G__65701;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65682){
var state_val_65683 = (state_65682[(1)]);
if((state_val_65683 === (1))){
var state_65682__$1 = state_65682;
var statearr_65684_65702 = state_65682__$1;
(statearr_65684_65702[(2)] = null);

(statearr_65684_65702[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65683 === (2))){
var _ = (function (){var statearr_65685 = state_65682;
(statearr_65685[(4)] = cljs.core.cons((5),(state_65682[(4)])));

return statearr_65685;
})();
var inst_65659 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_65682__$1 = state_65682;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65682__$1,(6),inst_65659);
} else {
if((state_val_65683 === (3))){
var inst_65680 = (state_65682[(2)]);
var state_65682__$1 = state_65682;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65682__$1,inst_65680);
} else {
if((state_val_65683 === (4))){
var inst_65653 = (state_65682[(2)]);
var state_65682__$1 = state_65682;
var statearr_65687_65703 = state_65682__$1;
(statearr_65687_65703[(2)] = inst_65653);

(statearr_65687_65703[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65683 === (5))){
var _ = (function (){var statearr_65688 = state_65682;
(statearr_65688[(4)] = cljs.core.rest((state_65682[(4)])));

return statearr_65688;
})();
var state_65682__$1 = state_65682;
var ex65686 = (state_65682__$1[(2)]);
var statearr_65689_65704 = state_65682__$1;
(statearr_65689_65704[(5)] = ex65686);


if((ex65686 instanceof Error)){
var statearr_65690_65705 = state_65682__$1;
(statearr_65690_65705[(1)] = (4));

(statearr_65690_65705[(5)] = null);

} else {
throw ex65686;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65683 === (6))){
var inst_65661 = (state_65682[(2)]);
var inst_65662 = fluree.db.util.async.throw_err(inst_65661);
var inst_65663 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_65662);
var inst_65664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65665 = [inst_65662];
var inst_65666 = (new cljs.core.PersistentVector(null,1,(5),inst_65664,inst_65665,null));
var inst_65667 = cljs.core.count(inst_65666);
var inst_65668 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65669 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65670 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65671 = [inst_65662];
var inst_65672 = (new cljs.core.PersistentVector(null,1,(5),inst_65670,inst_65671,null));
var inst_65673 = ["or",inst_65672,inst_65663];
var inst_65674 = cljs.core.PersistentHashMap.fromArrays(inst_65669,inst_65673);
var inst_65675 = [inst_65674,inst_65667];
var inst_65676 = (new cljs.core.PersistentVector(null,2,(5),inst_65668,inst_65675,null));
var inst_65677 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65676);
var _ = (function (){var statearr_65691 = state_65682;
(statearr_65691[(4)] = cljs.core.rest((state_65682[(4)])));

return statearr_65691;
})();
var state_65682__$1 = (function (){var statearr_65692 = state_65682;
(statearr_65692[(7)] = inst_65677);

return statearr_65692;
})();
var statearr_65693_65706 = state_65682__$1;
(statearr_65693_65706[(2)] = inst_65663);

(statearr_65693_65706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_65694 = [null,null,null,null,null,null,null,null];
(statearr_65694[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_65694[(1)] = (1));

return statearr_65694;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_65682){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65682);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65695){var ex__10753__auto__ = e65695;
var statearr_65696_65707 = state_65682;
(statearr_65696_65707[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65682[(4)]))){
var statearr_65697_65708 = state_65682;
(statearr_65697_65708[(1)] = cljs.core.first((state_65682[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65709 = state_65682;
state_65682 = G__65709;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_65682){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_65682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65698 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65698[(6)] = c__10876__auto__);

return statearr_65698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq65651){
var G__65652 = cljs.core.first(seq65651);
var seq65651__$1 = cljs.core.next(seq65651);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__65652,seq65651__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65747){
var state_val_65748 = (state_65747[(1)]);
if((state_val_65748 === (7))){
var inst_65723 = fluree.db.util.async.channel_QMARK_(coll);
var state_65747__$1 = state_65747;
if(inst_65723){
var statearr_65749_65772 = state_65747__$1;
(statearr_65749_65772[(1)] = (10));

} else {
var statearr_65750_65773 = state_65747__$1;
(statearr_65750_65773[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (1))){
var state_65747__$1 = state_65747;
var statearr_65751_65774 = state_65747__$1;
(statearr_65751_65774[(2)] = null);

(statearr_65751_65774[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (4))){
var inst_65710 = (state_65747[(2)]);
var state_65747__$1 = state_65747;
var statearr_65752_65775 = state_65747__$1;
(statearr_65752_65775[(2)] = inst_65710);

(statearr_65752_65775[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (13))){
var inst_65726 = (state_65747[(2)]);
var inst_65727 = fluree.db.util.async.throw_err(inst_65726);
var state_65747__$1 = state_65747;
var statearr_65753_65776 = state_65747__$1;
(statearr_65753_65776[(2)] = inst_65727);

(statearr_65753_65776[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (6))){
var inst_65718 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_65747__$1 = state_65747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65747__$1,(9),inst_65718);
} else {
if((state_val_65748 === (3))){
var inst_65745 = (state_65747[(2)]);
var state_65747__$1 = state_65747;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65747__$1,inst_65745);
} else {
if((state_val_65748 === (12))){
var inst_65730 = (state_65747[(2)]);
var state_65747__$1 = state_65747;
var statearr_65754_65777 = state_65747__$1;
(statearr_65754_65777[(2)] = inst_65730);

(statearr_65754_65777[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (2))){
var _ = (function (){var statearr_65755 = state_65747;
(statearr_65755[(4)] = cljs.core.cons((5),(state_65747[(4)])));

return statearr_65755;
})();
var inst_65716 = cljs.core.vector_QMARK_(coll);
var state_65747__$1 = state_65747;
if(inst_65716){
var statearr_65756_65778 = state_65747__$1;
(statearr_65756_65778[(1)] = (6));

} else {
var statearr_65757_65779 = state_65747__$1;
(statearr_65757_65779[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (11))){
var state_65747__$1 = state_65747;
var statearr_65759_65780 = state_65747__$1;
(statearr_65759_65780[(2)] = coll);

(statearr_65759_65780[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (9))){
var inst_65720 = (state_65747[(2)]);
var inst_65721 = fluree.db.util.async.throw_err(inst_65720);
var state_65747__$1 = state_65747;
var statearr_65760_65781 = state_65747__$1;
(statearr_65760_65781[(2)] = inst_65721);

(statearr_65760_65781[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (5))){
var _ = (function (){var statearr_65761 = state_65747;
(statearr_65761[(4)] = cljs.core.rest((state_65747[(4)])));

return statearr_65761;
})();
var state_65747__$1 = state_65747;
var ex65758 = (state_65747__$1[(2)]);
var statearr_65762_65782 = state_65747__$1;
(statearr_65762_65782[(5)] = ex65758);


if((ex65758 instanceof Error)){
var statearr_65763_65783 = state_65747__$1;
(statearr_65763_65783[(1)] = (4));

(statearr_65763_65783[(5)] = null);

} else {
throw ex65758;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65748 === (10))){
var state_65747__$1 = state_65747;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65747__$1,(13),coll);
} else {
if((state_val_65748 === (8))){
var inst_65732 = (state_65747[(2)]);
var inst_65733 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_65732);
var inst_65734 = cljs.core.count(inst_65733);
var inst_65735 = ((9) + inst_65734);
var inst_65736 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65737 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65738 = ["count",inst_65732,inst_65734];
var inst_65739 = cljs.core.PersistentHashMap.fromArrays(inst_65737,inst_65738);
var inst_65740 = [inst_65739,inst_65735];
var inst_65741 = (new cljs.core.PersistentVector(null,2,(5),inst_65736,inst_65740,null));
var inst_65742 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65741);
var _ = (function (){var statearr_65764 = state_65747;
(statearr_65764[(4)] = cljs.core.rest((state_65747[(4)])));

return statearr_65764;
})();
var state_65747__$1 = (function (){var statearr_65765 = state_65747;
(statearr_65765[(7)] = inst_65742);

return statearr_65765;
})();
var statearr_65766_65784 = state_65747__$1;
(statearr_65766_65784[(2)] = inst_65734);

(statearr_65766_65784[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____0 = (function (){
var statearr_65767 = [null,null,null,null,null,null,null,null];
(statearr_65767[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__);

(statearr_65767[(1)] = (1));

return statearr_65767;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____1 = (function (state_65747){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65747);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65768){var ex__10753__auto__ = e65768;
var statearr_65769_65785 = state_65747;
(statearr_65769_65785[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65747[(4)]))){
var statearr_65770_65786 = state_65747;
(statearr_65770_65786[(1)] = cljs.core.first((state_65747[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65787 = state_65747;
state_65747 = G__65787;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__ = function(state_65747){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____1.call(this,state_65747);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65771 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65771[(6)] = c__10876__auto__);

return statearr_65771;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65837){
var state_val_65838 = (state_65837[(1)]);
if((state_val_65838 === (7))){
var state_65837__$1 = state_65837;
var statearr_65839_65872 = state_65837__$1;
(statearr_65839_65872[(2)] = subject);

(statearr_65839_65872[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (1))){
var state_65837__$1 = state_65837;
var statearr_65840_65873 = state_65837__$1;
(statearr_65840_65873[(2)] = null);

(statearr_65840_65873[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (4))){
var inst_65788 = (state_65837[(2)]);
var state_65837__$1 = state_65837;
var statearr_65841_65874 = state_65837__$1;
(statearr_65841_65874[(2)] = inst_65788);

(statearr_65841_65874[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (15))){
var inst_65801 = (state_65837[(7)]);
var state_65837__$1 = state_65837;
var statearr_65842_65875 = state_65837__$1;
(statearr_65842_65875[(2)] = inst_65801);

(statearr_65842_65875[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (13))){
var inst_65805 = (state_65837[(2)]);
var inst_65806 = fluree.db.util.async.throw_err(inst_65805);
var state_65837__$1 = state_65837;
var statearr_65843_65876 = state_65837__$1;
(statearr_65843_65876[(2)] = inst_65806);

(statearr_65843_65876[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (6))){
var state_65837__$1 = state_65837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65837__$1,(9),subject);
} else {
if((state_val_65838 === (17))){
var inst_65801 = (state_65837[(7)]);
var inst_65815 = cljs.core.first(inst_65801);
var state_65837__$1 = state_65837;
var statearr_65844_65877 = state_65837__$1;
(statearr_65844_65877[(2)] = inst_65815);

(statearr_65844_65877[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (3))){
var inst_65835 = (state_65837[(2)]);
var state_65837__$1 = state_65837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65837__$1,inst_65835);
} else {
if((state_val_65838 === (12))){
var inst_65801 = (state_65837[(7)]);
var inst_65809 = (state_65837[(2)]);
var inst_65810 = cljs.core.vector_QMARK_(inst_65801);
var state_65837__$1 = (function (){var statearr_65845 = state_65837;
(statearr_65845[(8)] = inst_65809);

return statearr_65845;
})();
if(inst_65810){
var statearr_65846_65878 = state_65837__$1;
(statearr_65846_65878[(1)] = (14));

} else {
var statearr_65847_65879 = state_65837__$1;
(statearr_65847_65879[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (2))){
var _ = (function (){var statearr_65848 = state_65837;
(statearr_65848[(4)] = cljs.core.cons((5),(state_65837[(4)])));

return statearr_65848;
})();
var inst_65794 = fluree.db.util.async.channel_QMARK_(subject);
var state_65837__$1 = state_65837;
if(inst_65794){
var statearr_65849_65880 = state_65837__$1;
(statearr_65849_65880[(1)] = (6));

} else {
var statearr_65850_65881 = state_65837__$1;
(statearr_65850_65881[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (19))){
var inst_65818 = (state_65837[(2)]);
var state_65837__$1 = state_65837;
var statearr_65851_65882 = state_65837__$1;
(statearr_65851_65882[(2)] = inst_65818);

(statearr_65851_65882[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (11))){
var state_65837__$1 = state_65837;
var statearr_65853_65883 = state_65837__$1;
(statearr_65853_65883[(2)] = pred);

(statearr_65853_65883[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (9))){
var inst_65797 = (state_65837[(2)]);
var inst_65798 = fluree.db.util.async.throw_err(inst_65797);
var state_65837__$1 = state_65837;
var statearr_65854_65884 = state_65837__$1;
(statearr_65854_65884[(2)] = inst_65798);

(statearr_65854_65884[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (5))){
var _ = (function (){var statearr_65855 = state_65837;
(statearr_65855[(4)] = cljs.core.rest((state_65837[(4)])));

return statearr_65855;
})();
var state_65837__$1 = state_65837;
var ex65852 = (state_65837__$1[(2)]);
var statearr_65856_65885 = state_65837__$1;
(statearr_65856_65885[(5)] = ex65852);


if((ex65852 instanceof Error)){
var statearr_65857_65886 = state_65837__$1;
(statearr_65857_65886[(1)] = (4));

(statearr_65857_65886[(5)] = null);

} else {
throw ex65852;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (14))){
var inst_65801 = (state_65837[(7)]);
var inst_65812 = cljs.core.count(inst_65801);
var inst_65813 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_65812);
var state_65837__$1 = state_65837;
if(inst_65813){
var statearr_65858_65887 = state_65837__$1;
(statearr_65858_65887[(1)] = (17));

} else {
var statearr_65859_65888 = state_65837__$1;
(statearr_65859_65888[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (16))){
var inst_65801 = (state_65837[(7)]);
var inst_65809 = (state_65837[(8)]);
var inst_65821 = (state_65837[(2)]);
var inst_65822 = fluree.db.dbfunctions.internal.get(inst_65821,inst_65809);
var inst_65823 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65824 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65825 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65826 = [inst_65801,inst_65809];
var inst_65827 = (new cljs.core.PersistentVector(null,2,(5),inst_65825,inst_65826,null));
var inst_65828 = ["get",inst_65827,inst_65822];
var inst_65829 = cljs.core.PersistentHashMap.fromArrays(inst_65824,inst_65828);
var inst_65830 = [inst_65829,(10)];
var inst_65831 = (new cljs.core.PersistentVector(null,2,(5),inst_65823,inst_65830,null));
var inst_65832 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65831);
var _ = (function (){var statearr_65860 = state_65837;
(statearr_65860[(4)] = cljs.core.rest((state_65837[(4)])));

return statearr_65860;
})();
var state_65837__$1 = (function (){var statearr_65861 = state_65837;
(statearr_65861[(9)] = inst_65832);

return statearr_65861;
})();
var statearr_65862_65889 = state_65837__$1;
(statearr_65862_65889[(2)] = inst_65822);

(statearr_65862_65889[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (10))){
var state_65837__$1 = state_65837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65837__$1,(13),pred);
} else {
if((state_val_65838 === (18))){
var inst_65801 = (state_65837[(7)]);
var state_65837__$1 = state_65837;
var statearr_65863_65890 = state_65837__$1;
(statearr_65863_65890[(2)] = inst_65801);

(statearr_65863_65890[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65838 === (8))){
var inst_65801 = (state_65837[(2)]);
var inst_65802 = fluree.db.util.async.channel_QMARK_(pred);
var state_65837__$1 = (function (){var statearr_65864 = state_65837;
(statearr_65864[(7)] = inst_65801);

return statearr_65864;
})();
if(inst_65802){
var statearr_65865_65891 = state_65837__$1;
(statearr_65865_65891[(1)] = (10));

} else {
var statearr_65866_65892 = state_65837__$1;
(statearr_65866_65892[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____0 = (function (){
var statearr_65867 = [null,null,null,null,null,null,null,null,null,null];
(statearr_65867[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__);

(statearr_65867[(1)] = (1));

return statearr_65867;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____1 = (function (state_65837){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65837);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65868){var ex__10753__auto__ = e65868;
var statearr_65869_65893 = state_65837;
(statearr_65869_65893[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65837[(4)]))){
var statearr_65870_65894 = state_65837;
(statearr_65870_65894[(1)] = cljs.core.first((state_65837[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65895 = state_65837;
state_65837 = G__65895;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__ = function(state_65837){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____1.call(this,state_65837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65871 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65871[(6)] = c__10876__auto__);

return statearr_65871;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_65934){
var state_val_65935 = (state_65934[(1)]);
if((state_val_65935 === (7))){
var inst_65902 = (state_65934[(7)]);
var state_65934__$1 = state_65934;
var statearr_65936_65960 = state_65934__$1;
(statearr_65936_65960[(2)] = inst_65902);

(statearr_65936_65960[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (1))){
var state_65934__$1 = state_65934;
var statearr_65937_65961 = state_65934__$1;
(statearr_65937_65961[(2)] = null);

(statearr_65937_65961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (4))){
var inst_65896 = (state_65934[(2)]);
var state_65934__$1 = state_65934;
var statearr_65938_65962 = state_65934__$1;
(statearr_65938_65962[(2)] = inst_65896);

(statearr_65938_65962[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (6))){
var inst_65904 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65934__$1 = state_65934;
var statearr_65939_65963 = state_65934__$1;
(statearr_65939_65963[(2)] = inst_65904);

(statearr_65939_65963[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (3))){
var inst_65932 = (state_65934[(2)]);
var state_65934__$1 = state_65934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_65934__$1,inst_65932);
} else {
if((state_val_65935 === (12))){
var inst_65914 = (state_65934[(2)]);
var inst_65915 = fluree.db.util.async.throw_err(inst_65914);
var inst_65916 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65915,(0),null);
var inst_65917 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_65915,(1),null);
var inst_65918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_65919 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_65920 = ["?pO","?ctx",inst_65916];
var inst_65921 = cljs.core.PersistentHashMap.fromArrays(inst_65919,inst_65920);
var inst_65922 = ((10) + inst_65917);
var inst_65923 = [inst_65921,inst_65922];
var inst_65924 = (new cljs.core.PersistentVector(null,2,(5),inst_65918,inst_65923,null));
var inst_65925 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_65924);
var state_65934__$1 = (function (){var statearr_65940 = state_65934;
(statearr_65940[(8)] = inst_65925);

return statearr_65940;
})();
var statearr_65941_65964 = state_65934__$1;
(statearr_65941_65964[(2)] = inst_65916);

(statearr_65941_65964[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (2))){
var inst_65902 = (state_65934[(7)]);
var _ = (function (){var statearr_65942 = state_65934;
(statearr_65942[(4)] = cljs.core.cons((5),(state_65934[(4)])));

return statearr_65942;
})();
var inst_65902__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_65934__$1 = (function (){var statearr_65943 = state_65934;
(statearr_65943[(7)] = inst_65902__$1);

return statearr_65943;
})();
if(cljs.core.truth_(inst_65902__$1)){
var statearr_65944_65965 = state_65934__$1;
(statearr_65944_65965[(1)] = (6));

} else {
var statearr_65945_65966 = state_65934__$1;
(statearr_65945_65966[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (11))){
var inst_65929 = (state_65934[(2)]);
var _ = (function (){var statearr_65947 = state_65934;
(statearr_65947[(4)] = cljs.core.rest((state_65934[(4)])));

return statearr_65947;
})();
var state_65934__$1 = state_65934;
var statearr_65948_65967 = state_65934__$1;
(statearr_65948_65967[(2)] = inst_65929);

(statearr_65948_65967[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (9))){
var inst_65912 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_65934__$1 = state_65934;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_65934__$1,(12),inst_65912);
} else {
if((state_val_65935 === (5))){
var _ = (function (){var statearr_65949 = state_65934;
(statearr_65949[(4)] = cljs.core.rest((state_65934[(4)])));

return statearr_65949;
})();
var state_65934__$1 = state_65934;
var ex65946 = (state_65934__$1[(2)]);
var statearr_65950_65968 = state_65934__$1;
(statearr_65950_65968[(5)] = ex65946);


if((ex65946 instanceof Error)){
var statearr_65951_65969 = state_65934__$1;
(statearr_65951_65969[(1)] = (4));

(statearr_65951_65969[(5)] = null);

} else {
throw ex65946;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (10))){
var inst_65927 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_65934__$1 = state_65934;
var statearr_65952_65970 = state_65934__$1;
(statearr_65952_65970[(2)] = inst_65927);

(statearr_65952_65970[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_65935 === (8))){
var inst_65907 = (state_65934[(2)]);
var state_65934__$1 = state_65934;
if(cljs.core.truth_(inst_65907)){
var statearr_65953_65971 = state_65934__$1;
(statearr_65953_65971[(1)] = (9));

} else {
var statearr_65954_65972 = state_65934__$1;
(statearr_65954_65972[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____0 = (function (){
var statearr_65955 = [null,null,null,null,null,null,null,null,null];
(statearr_65955[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__);

(statearr_65955[(1)] = (1));

return statearr_65955;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____1 = (function (state_65934){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_65934);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e65956){var ex__10753__auto__ = e65956;
var statearr_65957_65973 = state_65934;
(statearr_65957_65973[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_65934[(4)]))){
var statearr_65958_65974 = state_65934;
(statearr_65958_65974[(1)] = cljs.core.first((state_65934[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__65975 = state_65934;
state_65934 = G__65975;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__ = function(state_65934){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____1.call(this,state_65934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_65959 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_65959[(6)] = c__10876__auto__);

return statearr_65959;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66027){
var state_val_66028 = (state_66027[(1)]);
if((state_val_66028 === (7))){
var state_66027__$1 = state_66027;
var statearr_66029_66062 = state_66027__$1;
(statearr_66029_66062[(2)] = subject);

(statearr_66029_66062[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (1))){
var state_66027__$1 = state_66027;
var statearr_66030_66063 = state_66027__$1;
(statearr_66030_66063[(2)] = null);

(statearr_66030_66063[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (4))){
var inst_65976 = (state_66027[(2)]);
var state_66027__$1 = state_66027;
var statearr_66031_66064 = state_66027__$1;
(statearr_66031_66064[(2)] = inst_65976);

(statearr_66031_66064[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (15))){
var inst_65989 = (state_66027[(7)]);
var state_66027__$1 = state_66027;
var statearr_66032_66065 = state_66027__$1;
(statearr_66032_66065[(2)] = inst_65989);

(statearr_66032_66065[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (13))){
var inst_65993 = (state_66027[(2)]);
var inst_65994 = fluree.db.util.async.throw_err(inst_65993);
var state_66027__$1 = state_66027;
var statearr_66033_66066 = state_66027__$1;
(statearr_66033_66066[(2)] = inst_65994);

(statearr_66033_66066[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (6))){
var state_66027__$1 = state_66027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66027__$1,(9),subject);
} else {
if((state_val_66028 === (17))){
var inst_65989 = (state_66027[(7)]);
var inst_66003 = cljs.core.first(inst_65989);
var state_66027__$1 = state_66027;
var statearr_66034_66067 = state_66027__$1;
(statearr_66034_66067[(2)] = inst_66003);

(statearr_66034_66067[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (3))){
var inst_66025 = (state_66027[(2)]);
var state_66027__$1 = state_66027;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66027__$1,inst_66025);
} else {
if((state_val_66028 === (12))){
var inst_65989 = (state_66027[(7)]);
var inst_65997 = (state_66027[(2)]);
var inst_65998 = cljs.core.vector_QMARK_(inst_65989);
var state_66027__$1 = (function (){var statearr_66035 = state_66027;
(statearr_66035[(8)] = inst_65997);

return statearr_66035;
})();
if(inst_65998){
var statearr_66036_66068 = state_66027__$1;
(statearr_66036_66068[(1)] = (14));

} else {
var statearr_66037_66069 = state_66027__$1;
(statearr_66037_66069[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (2))){
var _ = (function (){var statearr_66038 = state_66027;
(statearr_66038[(4)] = cljs.core.cons((5),(state_66027[(4)])));

return statearr_66038;
})();
var inst_65982 = fluree.db.util.async.channel_QMARK_(subject);
var state_66027__$1 = state_66027;
if(inst_65982){
var statearr_66039_66070 = state_66027__$1;
(statearr_66039_66070[(1)] = (6));

} else {
var statearr_66040_66071 = state_66027__$1;
(statearr_66040_66071[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (19))){
var inst_66006 = (state_66027[(2)]);
var state_66027__$1 = state_66027;
var statearr_66041_66072 = state_66027__$1;
(statearr_66041_66072[(2)] = inst_66006);

(statearr_66041_66072[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (11))){
var state_66027__$1 = state_66027;
var statearr_66043_66073 = state_66027__$1;
(statearr_66043_66073[(2)] = path);

(statearr_66043_66073[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (9))){
var inst_65985 = (state_66027[(2)]);
var inst_65986 = fluree.db.util.async.throw_err(inst_65985);
var state_66027__$1 = state_66027;
var statearr_66044_66074 = state_66027__$1;
(statearr_66044_66074[(2)] = inst_65986);

(statearr_66044_66074[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (5))){
var _ = (function (){var statearr_66045 = state_66027;
(statearr_66045[(4)] = cljs.core.rest((state_66027[(4)])));

return statearr_66045;
})();
var state_66027__$1 = state_66027;
var ex66042 = (state_66027__$1[(2)]);
var statearr_66046_66075 = state_66027__$1;
(statearr_66046_66075[(5)] = ex66042);


if((ex66042 instanceof Error)){
var statearr_66047_66076 = state_66027__$1;
(statearr_66047_66076[(1)] = (4));

(statearr_66047_66076[(5)] = null);

} else {
throw ex66042;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (14))){
var inst_65989 = (state_66027[(7)]);
var inst_66000 = cljs.core.count(inst_65989);
var inst_66001 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66000);
var state_66027__$1 = state_66027;
if(inst_66001){
var statearr_66048_66077 = state_66027__$1;
(statearr_66048_66077[(1)] = (17));

} else {
var statearr_66049_66078 = state_66027__$1;
(statearr_66049_66078[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (16))){
var inst_65997 = (state_66027[(8)]);
var inst_65989 = (state_66027[(7)]);
var inst_66009 = (state_66027[(2)]);
var inst_66010 = fluree.db.dbfunctions.internal.get_all(inst_66009,inst_65997);
var inst_66011 = cljs.core.count(inst_65997);
var inst_66012 = ((9) + inst_66011);
var inst_66013 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66014 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66016 = [inst_65989,inst_65997];
var inst_66017 = (new cljs.core.PersistentVector(null,2,(5),inst_66015,inst_66016,null));
var inst_66018 = ["get-all",inst_66017,inst_66010];
var inst_66019 = cljs.core.PersistentHashMap.fromArrays(inst_66014,inst_66018);
var inst_66020 = [inst_66019,inst_66012];
var inst_66021 = (new cljs.core.PersistentVector(null,2,(5),inst_66013,inst_66020,null));
var inst_66022 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66021);
var _ = (function (){var statearr_66050 = state_66027;
(statearr_66050[(4)] = cljs.core.rest((state_66027[(4)])));

return statearr_66050;
})();
var state_66027__$1 = (function (){var statearr_66051 = state_66027;
(statearr_66051[(9)] = inst_66022);

return statearr_66051;
})();
var statearr_66052_66079 = state_66027__$1;
(statearr_66052_66079[(2)] = inst_66010);

(statearr_66052_66079[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (10))){
var state_66027__$1 = state_66027;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66027__$1,(13),path);
} else {
if((state_val_66028 === (18))){
var inst_65989 = (state_66027[(7)]);
var state_66027__$1 = state_66027;
var statearr_66053_66080 = state_66027__$1;
(statearr_66053_66080[(2)] = inst_65989);

(statearr_66053_66080[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66028 === (8))){
var inst_65989 = (state_66027[(2)]);
var inst_65990 = fluree.db.util.async.channel_QMARK_(path);
var state_66027__$1 = (function (){var statearr_66054 = state_66027;
(statearr_66054[(7)] = inst_65989);

return statearr_66054;
})();
if(inst_65990){
var statearr_66055_66081 = state_66027__$1;
(statearr_66055_66081[(1)] = (10));

} else {
var statearr_66056_66082 = state_66027__$1;
(statearr_66056_66082[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____0 = (function (){
var statearr_66057 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66057[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__);

(statearr_66057[(1)] = (1));

return statearr_66057;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____1 = (function (state_66027){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66027);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66058){var ex__10753__auto__ = e66058;
var statearr_66059_66083 = state_66027;
(statearr_66059_66083[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66027[(4)]))){
var statearr_66060_66084 = state_66027;
(statearr_66060_66084[(1)] = cljs.core.first((state_66027[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66085 = state_66027;
state_66027 = G__66085;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__ = function(state_66027){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____1.call(this,state_66027);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66061 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66061[(6)] = c__10876__auto__);

return statearr_66061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66124){
var state_val_66125 = (state_66124[(1)]);
if((state_val_66125 === (7))){
var state_66124__$1 = state_66124;
var statearr_66126_66150 = state_66124__$1;
(statearr_66126_66150[(2)] = subject);

(statearr_66126_66150[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (1))){
var state_66124__$1 = state_66124;
var statearr_66127_66151 = state_66124__$1;
(statearr_66127_66151[(2)] = null);

(statearr_66127_66151[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (4))){
var inst_66086 = (state_66124[(2)]);
var state_66124__$1 = state_66124;
var statearr_66128_66152 = state_66124__$1;
(statearr_66128_66152[(2)] = inst_66086);

(statearr_66128_66152[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (13))){
var inst_66103 = (state_66124[(2)]);
var inst_66104 = fluree.db.util.async.throw_err(inst_66103);
var state_66124__$1 = state_66124;
var statearr_66129_66153 = state_66124__$1;
(statearr_66129_66153[(2)] = inst_66104);

(statearr_66129_66153[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (6))){
var state_66124__$1 = state_66124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66124__$1,(9),subject);
} else {
if((state_val_66125 === (3))){
var inst_66122 = (state_66124[(2)]);
var state_66124__$1 = state_66124;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66124__$1,inst_66122);
} else {
if((state_val_66125 === (12))){
var inst_66099 = (state_66124[(7)]);
var inst_66107 = (state_66124[(2)]);
var inst_66108 = fluree.db.dbfunctions.internal.get_in(inst_66099,inst_66107);
var inst_66109 = cljs.core.count(inst_66107);
var inst_66110 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66111 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66113 = [inst_66099,inst_66107];
var inst_66114 = (new cljs.core.PersistentVector(null,2,(5),inst_66112,inst_66113,null));
var inst_66115 = ["get-in",inst_66114,inst_66108];
var inst_66116 = cljs.core.PersistentHashMap.fromArrays(inst_66111,inst_66115);
var inst_66117 = [inst_66116,inst_66109];
var inst_66118 = (new cljs.core.PersistentVector(null,2,(5),inst_66110,inst_66117,null));
var inst_66119 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66118);
var _ = (function (){var statearr_66130 = state_66124;
(statearr_66130[(4)] = cljs.core.rest((state_66124[(4)])));

return statearr_66130;
})();
var state_66124__$1 = (function (){var statearr_66131 = state_66124;
(statearr_66131[(8)] = inst_66119);

return statearr_66131;
})();
var statearr_66132_66154 = state_66124__$1;
(statearr_66132_66154[(2)] = inst_66108);

(statearr_66132_66154[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (2))){
var _ = (function (){var statearr_66133 = state_66124;
(statearr_66133[(4)] = cljs.core.cons((5),(state_66124[(4)])));

return statearr_66133;
})();
var inst_66092 = fluree.db.util.async.channel_QMARK_(subject);
var state_66124__$1 = state_66124;
if(inst_66092){
var statearr_66134_66155 = state_66124__$1;
(statearr_66134_66155[(1)] = (6));

} else {
var statearr_66135_66156 = state_66124__$1;
(statearr_66135_66156[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (11))){
var state_66124__$1 = state_66124;
var statearr_66137_66157 = state_66124__$1;
(statearr_66137_66157[(2)] = path);

(statearr_66137_66157[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (9))){
var inst_66095 = (state_66124[(2)]);
var inst_66096 = fluree.db.util.async.throw_err(inst_66095);
var state_66124__$1 = state_66124;
var statearr_66138_66158 = state_66124__$1;
(statearr_66138_66158[(2)] = inst_66096);

(statearr_66138_66158[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (5))){
var _ = (function (){var statearr_66139 = state_66124;
(statearr_66139[(4)] = cljs.core.rest((state_66124[(4)])));

return statearr_66139;
})();
var state_66124__$1 = state_66124;
var ex66136 = (state_66124__$1[(2)]);
var statearr_66140_66159 = state_66124__$1;
(statearr_66140_66159[(5)] = ex66136);


if((ex66136 instanceof Error)){
var statearr_66141_66160 = state_66124__$1;
(statearr_66141_66160[(1)] = (4));

(statearr_66141_66160[(5)] = null);

} else {
throw ex66136;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66125 === (10))){
var state_66124__$1 = state_66124;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66124__$1,(13),path);
} else {
if((state_val_66125 === (8))){
var inst_66099 = (state_66124[(2)]);
var inst_66100 = fluree.db.util.async.channel_QMARK_(path);
var state_66124__$1 = (function (){var statearr_66142 = state_66124;
(statearr_66142[(7)] = inst_66099);

return statearr_66142;
})();
if(inst_66100){
var statearr_66143_66161 = state_66124__$1;
(statearr_66143_66161[(1)] = (10));

} else {
var statearr_66144_66162 = state_66124__$1;
(statearr_66144_66162[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____0 = (function (){
var statearr_66145 = [null,null,null,null,null,null,null,null,null];
(statearr_66145[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__);

(statearr_66145[(1)] = (1));

return statearr_66145;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____1 = (function (state_66124){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66124);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66146){var ex__10753__auto__ = e66146;
var statearr_66147_66163 = state_66124;
(statearr_66147_66163[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66124[(4)]))){
var statearr_66148_66164 = state_66124;
(statearr_66148_66164[(1)] = cljs.core.first((state_66124[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66165 = state_66124;
state_66124 = G__66165;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__ = function(state_66124){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____1.call(this,state_66124);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66149 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66149[(6)] = c__10876__auto__);

return statearr_66149;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66210){
var state_val_66211 = (state_66210[(1)]);
if((state_val_66211 === (7))){
var state_66210__$1 = state_66210;
var statearr_66212_66241 = state_66210__$1;
(statearr_66212_66241[(2)] = coll);

(statearr_66212_66241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (1))){
var state_66210__$1 = state_66210;
var statearr_66213_66242 = state_66210__$1;
(statearr_66213_66242[(2)] = null);

(statearr_66213_66242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (4))){
var inst_66166 = (state_66210[(2)]);
var state_66210__$1 = state_66210;
var statearr_66214_66243 = state_66210__$1;
(statearr_66214_66243[(2)] = inst_66166);

(statearr_66214_66243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (15))){
var inst_66186 = (state_66210[(7)]);
var inst_66194 = (state_66210[(2)]);
var inst_66195 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_66186,inst_66194);
var inst_66196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66197 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66198 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66199 = [inst_66186,inst_66194];
var inst_66200 = (new cljs.core.PersistentVector(null,2,(5),inst_66198,inst_66199,null));
var inst_66201 = ["contains?",inst_66200,inst_66195];
var inst_66202 = cljs.core.PersistentHashMap.fromArrays(inst_66197,inst_66201);
var inst_66203 = [inst_66202,(10)];
var inst_66204 = (new cljs.core.PersistentVector(null,2,(5),inst_66196,inst_66203,null));
var inst_66205 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66204);
var _ = (function (){var statearr_66215 = state_66210;
(statearr_66215[(4)] = cljs.core.rest((state_66210[(4)])));

return statearr_66215;
})();
var state_66210__$1 = (function (){var statearr_66216 = state_66210;
(statearr_66216[(8)] = inst_66205);

return statearr_66216;
})();
var statearr_66217_66244 = state_66210__$1;
(statearr_66217_66244[(2)] = inst_66195);

(statearr_66217_66244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (13))){
var state_66210__$1 = state_66210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66210__$1,(16),key);
} else {
if((state_val_66211 === (6))){
var state_66210__$1 = state_66210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66210__$1,(9),coll);
} else {
if((state_val_66211 === (3))){
var inst_66208 = (state_66210[(2)]);
var state_66210__$1 = state_66210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66210__$1,inst_66208);
} else {
if((state_val_66211 === (12))){
var inst_66186 = (state_66210[(2)]);
var inst_66187 = fluree.db.util.async.channel_QMARK_(key);
var state_66210__$1 = (function (){var statearr_66218 = state_66210;
(statearr_66218[(7)] = inst_66186);

return statearr_66218;
})();
if(inst_66187){
var statearr_66219_66245 = state_66210__$1;
(statearr_66219_66245[(1)] = (13));

} else {
var statearr_66220_66246 = state_66210__$1;
(statearr_66220_66246[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (2))){
var _ = (function (){var statearr_66221 = state_66210;
(statearr_66221[(4)] = cljs.core.cons((5),(state_66210[(4)])));

return statearr_66221;
})();
var inst_66172 = fluree.db.util.async.channel_QMARK_(coll);
var state_66210__$1 = state_66210;
if(inst_66172){
var statearr_66222_66247 = state_66210__$1;
(statearr_66222_66247[(1)] = (6));

} else {
var statearr_66223_66248 = state_66210__$1;
(statearr_66223_66248[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (11))){
var inst_66179 = (state_66210[(9)]);
var inst_66183 = cljs.core.flatten(inst_66179);
var inst_66184 = cljs.core.set(inst_66183);
var state_66210__$1 = state_66210;
var statearr_66225_66249 = state_66210__$1;
(statearr_66225_66249[(2)] = inst_66184);

(statearr_66225_66249[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (9))){
var inst_66175 = (state_66210[(2)]);
var inst_66176 = fluree.db.util.async.throw_err(inst_66175);
var state_66210__$1 = state_66210;
var statearr_66226_66250 = state_66210__$1;
(statearr_66226_66250[(2)] = inst_66176);

(statearr_66226_66250[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (5))){
var _ = (function (){var statearr_66227 = state_66210;
(statearr_66227[(4)] = cljs.core.rest((state_66210[(4)])));

return statearr_66227;
})();
var state_66210__$1 = state_66210;
var ex66224 = (state_66210__$1[(2)]);
var statearr_66228_66251 = state_66210__$1;
(statearr_66228_66251[(5)] = ex66224);


if((ex66224 instanceof Error)){
var statearr_66229_66252 = state_66210__$1;
(statearr_66229_66252[(1)] = (4));

(statearr_66229_66252[(5)] = null);

} else {
throw ex66224;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (14))){
var state_66210__$1 = state_66210;
var statearr_66230_66253 = state_66210__$1;
(statearr_66230_66253[(2)] = key);

(statearr_66230_66253[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (16))){
var inst_66190 = (state_66210[(2)]);
var inst_66191 = fluree.db.util.async.throw_err(inst_66190);
var state_66210__$1 = state_66210;
var statearr_66231_66254 = state_66210__$1;
(statearr_66231_66254[(2)] = inst_66191);

(statearr_66231_66254[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (10))){
var inst_66179 = (state_66210[(9)]);
var state_66210__$1 = state_66210;
var statearr_66232_66255 = state_66210__$1;
(statearr_66232_66255[(2)] = inst_66179);

(statearr_66232_66255[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66211 === (8))){
var inst_66179 = (state_66210[(9)]);
var inst_66179__$1 = (state_66210[(2)]);
var inst_66180 = cljs.core.set_QMARK_(inst_66179__$1);
var state_66210__$1 = (function (){var statearr_66233 = state_66210;
(statearr_66233[(9)] = inst_66179__$1);

return statearr_66233;
})();
if(inst_66180){
var statearr_66234_66256 = state_66210__$1;
(statearr_66234_66256[(1)] = (10));

} else {
var statearr_66235_66257 = state_66210__$1;
(statearr_66235_66257[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_66236 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66236[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__);

(statearr_66236[(1)] = (1));

return statearr_66236;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____1 = (function (state_66210){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66210);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66237){var ex__10753__auto__ = e66237;
var statearr_66238_66258 = state_66210;
(statearr_66238_66258[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66210[(4)]))){
var statearr_66239_66259 = state_66210;
(statearr_66239_66259[(1)] = cljs.core.first((state_66210[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66260 = state_66210;
state_66210 = G__66260;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__ = function(state_66210){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____1.call(this,state_66210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66240 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66240[(6)] = c__10876__auto__);

return statearr_66240;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66332 = arguments.length;
var i__4819__auto___66333 = (0);
while(true){
if((i__4819__auto___66333 < len__4818__auto___66332)){
args__4824__auto__.push((arguments[i__4819__auto___66333]));

var G__66334 = (i__4819__auto___66333 + (1));
i__4819__auto___66333 = G__66334;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66306){
var state_val_66307 = (state_66306[(1)]);
if((state_val_66307 === (7))){
var inst_66272 = (state_66306[(7)]);
var inst_66276 = cljs.core.first(inst_66272);
var inst_66277 = cljs.core.coll_QMARK_(inst_66276);
var state_66306__$1 = state_66306;
var statearr_66308_66335 = state_66306__$1;
(statearr_66308_66335[(2)] = inst_66277);

(statearr_66308_66335[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (1))){
var state_66306__$1 = state_66306;
var statearr_66309_66336 = state_66306__$1;
(statearr_66309_66336[(2)] = null);

(statearr_66309_66336[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (4))){
var inst_66263 = (state_66306[(2)]);
var state_66306__$1 = state_66306;
var statearr_66310_66337 = state_66306__$1;
(statearr_66310_66337[(2)] = inst_66263);

(statearr_66310_66337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (6))){
var inst_66274 = (state_66306[(8)]);
var inst_66272 = (state_66306[(7)]);
var inst_66271 = (state_66306[(2)]);
var inst_66272__$1 = fluree.db.util.async.throw_err(inst_66271);
var inst_66273 = cljs.core.count(inst_66272__$1);
var inst_66274__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_66273);
var state_66306__$1 = (function (){var statearr_66311 = state_66306;
(statearr_66311[(8)] = inst_66274__$1);

(statearr_66311[(7)] = inst_66272__$1);

return statearr_66311;
})();
if(inst_66274__$1){
var statearr_66312_66338 = state_66306__$1;
(statearr_66312_66338[(1)] = (7));

} else {
var statearr_66313_66339 = state_66306__$1;
(statearr_66313_66339[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (3))){
var inst_66304 = (state_66306[(2)]);
var state_66306__$1 = state_66306;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66306__$1,inst_66304);
} else {
if((state_val_66307 === (12))){
var inst_66285 = (state_66306[(2)]);
var inst_66286 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_66285);
var inst_66287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66288 = [inst_66285];
var inst_66289 = (new cljs.core.PersistentVector(null,1,(5),inst_66287,inst_66288,null));
var inst_66290 = cljs.core.count(inst_66289);
var inst_66291 = ((9) + inst_66290);
var inst_66292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66293 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66295 = [inst_66285];
var inst_66296 = (new cljs.core.PersistentVector(null,1,(5),inst_66294,inst_66295,null));
var inst_66297 = ["hash-set",inst_66296,inst_66286];
var inst_66298 = cljs.core.PersistentHashMap.fromArrays(inst_66293,inst_66297);
var inst_66299 = [inst_66298,inst_66291];
var inst_66300 = (new cljs.core.PersistentVector(null,2,(5),inst_66292,inst_66299,null));
var inst_66301 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66300);
var _ = (function (){var statearr_66314 = state_66306;
(statearr_66314[(4)] = cljs.core.rest((state_66306[(4)])));

return statearr_66314;
})();
var state_66306__$1 = (function (){var statearr_66315 = state_66306;
(statearr_66315[(9)] = inst_66301);

return statearr_66315;
})();
var statearr_66316_66340 = state_66306__$1;
(statearr_66316_66340[(2)] = inst_66286);

(statearr_66316_66340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (2))){
var _ = (function (){var statearr_66317 = state_66306;
(statearr_66317[(4)] = cljs.core.cons((5),(state_66306[(4)])));

return statearr_66317;
})();
var inst_66269 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66306__$1 = state_66306;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66306__$1,(6),inst_66269);
} else {
if((state_val_66307 === (11))){
var inst_66272 = (state_66306[(7)]);
var state_66306__$1 = state_66306;
var statearr_66319_66341 = state_66306__$1;
(statearr_66319_66341[(2)] = inst_66272);

(statearr_66319_66341[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (9))){
var inst_66280 = (state_66306[(2)]);
var state_66306__$1 = state_66306;
if(cljs.core.truth_(inst_66280)){
var statearr_66320_66342 = state_66306__$1;
(statearr_66320_66342[(1)] = (10));

} else {
var statearr_66321_66343 = state_66306__$1;
(statearr_66321_66343[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (5))){
var _ = (function (){var statearr_66322 = state_66306;
(statearr_66322[(4)] = cljs.core.rest((state_66306[(4)])));

return statearr_66322;
})();
var state_66306__$1 = state_66306;
var ex66318 = (state_66306__$1[(2)]);
var statearr_66323_66344 = state_66306__$1;
(statearr_66323_66344[(5)] = ex66318);


if((ex66318 instanceof Error)){
var statearr_66324_66345 = state_66306__$1;
(statearr_66324_66345[(1)] = (4));

(statearr_66324_66345[(5)] = null);

} else {
throw ex66318;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (10))){
var inst_66272 = (state_66306[(7)]);
var inst_66282 = cljs.core.first(inst_66272);
var state_66306__$1 = state_66306;
var statearr_66325_66346 = state_66306__$1;
(statearr_66325_66346[(2)] = inst_66282);

(statearr_66325_66346[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66307 === (8))){
var inst_66274 = (state_66306[(8)]);
var state_66306__$1 = state_66306;
var statearr_66326_66347 = state_66306__$1;
(statearr_66326_66347[(2)] = inst_66274);

(statearr_66326_66347[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66327 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66327[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66327[(1)] = (1));

return statearr_66327;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66306){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66306);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66328){var ex__10753__auto__ = e66328;
var statearr_66329_66348 = state_66306;
(statearr_66329_66348[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66306[(4)]))){
var statearr_66330_66349 = state_66306;
(statearr_66330_66349[(1)] = cljs.core.first((state_66306[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66350 = state_66306;
state_66306 = G__66350;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66306){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66306);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66331 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66331[(6)] = c__10876__auto__);

return statearr_66331;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq66261){
var G__66262 = cljs.core.first(seq66261);
var seq66261__$1 = cljs.core.next(seq66261);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66262,seq66261__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66400 = arguments.length;
var i__4819__auto___66401 = (0);
while(true){
if((i__4819__auto___66401 < len__4818__auto___66400)){
args__4824__auto__.push((arguments[i__4819__auto___66401]));

var G__66402 = (i__4819__auto___66401 + (1));
i__4819__auto___66401 = G__66402;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66383){
var state_val_66384 = (state_66383[(1)]);
if((state_val_66384 === (1))){
var state_66383__$1 = state_66383;
var statearr_66385_66403 = state_66383__$1;
(statearr_66385_66403[(2)] = null);

(statearr_66385_66403[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66384 === (2))){
var _ = (function (){var statearr_66386 = state_66383;
(statearr_66386[(4)] = cljs.core.cons((5),(state_66383[(4)])));

return statearr_66386;
})();
var inst_66359 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66383__$1 = state_66383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66383__$1,(6),inst_66359);
} else {
if((state_val_66384 === (3))){
var inst_66381 = (state_66383[(2)]);
var state_66383__$1 = state_66383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66383__$1,inst_66381);
} else {
if((state_val_66384 === (4))){
var inst_66353 = (state_66383[(2)]);
var state_66383__$1 = state_66383;
var statearr_66388_66404 = state_66383__$1;
(statearr_66388_66404[(2)] = inst_66353);

(statearr_66388_66404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66384 === (5))){
var _ = (function (){var statearr_66389 = state_66383;
(statearr_66389[(4)] = cljs.core.rest((state_66383[(4)])));

return statearr_66389;
})();
var state_66383__$1 = state_66383;
var ex66387 = (state_66383__$1[(2)]);
var statearr_66390_66405 = state_66383__$1;
(statearr_66390_66405[(5)] = ex66387);


if((ex66387 instanceof Error)){
var statearr_66391_66406 = state_66383__$1;
(statearr_66391_66406[(1)] = (4));

(statearr_66391_66406[(5)] = null);

} else {
throw ex66387;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66384 === (6))){
var inst_66361 = (state_66383[(2)]);
var inst_66362 = fluree.db.util.async.throw_err(inst_66361);
var inst_66363 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_66362);
var inst_66364 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66365 = [inst_66362];
var inst_66366 = (new cljs.core.PersistentVector(null,1,(5),inst_66364,inst_66365,null));
var inst_66367 = cljs.core.count(inst_66366);
var inst_66368 = ((9) + inst_66367);
var inst_66369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66370 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66372 = [inst_66362];
var inst_66373 = (new cljs.core.PersistentVector(null,1,(5),inst_66371,inst_66372,null));
var inst_66374 = ["==",inst_66373,inst_66363];
var inst_66375 = cljs.core.PersistentHashMap.fromArrays(inst_66370,inst_66374);
var inst_66376 = [inst_66375,inst_66368];
var inst_66377 = (new cljs.core.PersistentVector(null,2,(5),inst_66369,inst_66376,null));
var inst_66378 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66377);
var _ = (function (){var statearr_66392 = state_66383;
(statearr_66392[(4)] = cljs.core.rest((state_66383[(4)])));

return statearr_66392;
})();
var state_66383__$1 = (function (){var statearr_66393 = state_66383;
(statearr_66393[(7)] = inst_66378);

return statearr_66393;
})();
var statearr_66394_66407 = state_66383__$1;
(statearr_66394_66407[(2)] = inst_66363);

(statearr_66394_66407[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66395 = [null,null,null,null,null,null,null,null];
(statearr_66395[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66395[(1)] = (1));

return statearr_66395;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66383){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66383);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66396){var ex__10753__auto__ = e66396;
var statearr_66397_66408 = state_66383;
(statearr_66397_66408[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66383[(4)]))){
var statearr_66398_66409 = state_66383;
(statearr_66398_66409[(1)] = cljs.core.first((state_66383[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66410 = state_66383;
state_66383 = G__66410;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66383){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66399 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66399[(6)] = c__10876__auto__);

return statearr_66399;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq66351){
var G__66352 = cljs.core.first(seq66351);
var seq66351__$1 = cljs.core.next(seq66351);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66352,seq66351__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66460 = arguments.length;
var i__4819__auto___66461 = (0);
while(true){
if((i__4819__auto___66461 < len__4818__auto___66460)){
args__4824__auto__.push((arguments[i__4819__auto___66461]));

var G__66462 = (i__4819__auto___66461 + (1));
i__4819__auto___66461 = G__66462;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66443){
var state_val_66444 = (state_66443[(1)]);
if((state_val_66444 === (1))){
var state_66443__$1 = state_66443;
var statearr_66445_66463 = state_66443__$1;
(statearr_66445_66463[(2)] = null);

(statearr_66445_66463[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66444 === (2))){
var _ = (function (){var statearr_66446 = state_66443;
(statearr_66446[(4)] = cljs.core.cons((5),(state_66443[(4)])));

return statearr_66446;
})();
var inst_66419 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66443__$1,(6),inst_66419);
} else {
if((state_val_66444 === (3))){
var inst_66441 = (state_66443[(2)]);
var state_66443__$1 = state_66443;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66443__$1,inst_66441);
} else {
if((state_val_66444 === (4))){
var inst_66413 = (state_66443[(2)]);
var state_66443__$1 = state_66443;
var statearr_66448_66464 = state_66443__$1;
(statearr_66448_66464[(2)] = inst_66413);

(statearr_66448_66464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66444 === (5))){
var _ = (function (){var statearr_66449 = state_66443;
(statearr_66449[(4)] = cljs.core.rest((state_66443[(4)])));

return statearr_66449;
})();
var state_66443__$1 = state_66443;
var ex66447 = (state_66443__$1[(2)]);
var statearr_66450_66465 = state_66443__$1;
(statearr_66450_66465[(5)] = ex66447);


if((ex66447 instanceof Error)){
var statearr_66451_66466 = state_66443__$1;
(statearr_66451_66466[(1)] = (4));

(statearr_66451_66466[(5)] = null);

} else {
throw ex66447;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66444 === (6))){
var inst_66421 = (state_66443[(2)]);
var inst_66422 = fluree.db.util.async.throw_err(inst_66421);
var inst_66423 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_66422);
var inst_66424 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66425 = [inst_66422];
var inst_66426 = (new cljs.core.PersistentVector(null,1,(5),inst_66424,inst_66425,null));
var inst_66427 = cljs.core.count(inst_66426);
var inst_66428 = ((9) + inst_66427);
var inst_66429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66430 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66431 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66432 = [inst_66422];
var inst_66433 = (new cljs.core.PersistentVector(null,1,(5),inst_66431,inst_66432,null));
var inst_66434 = [">",inst_66433,inst_66423];
var inst_66435 = cljs.core.PersistentHashMap.fromArrays(inst_66430,inst_66434);
var inst_66436 = [inst_66435,inst_66428];
var inst_66437 = (new cljs.core.PersistentVector(null,2,(5),inst_66429,inst_66436,null));
var inst_66438 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66437);
var _ = (function (){var statearr_66452 = state_66443;
(statearr_66452[(4)] = cljs.core.rest((state_66443[(4)])));

return statearr_66452;
})();
var state_66443__$1 = (function (){var statearr_66453 = state_66443;
(statearr_66453[(7)] = inst_66438);

return statearr_66453;
})();
var statearr_66454_66467 = state_66443__$1;
(statearr_66454_66467[(2)] = inst_66423);

(statearr_66454_66467[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66455 = [null,null,null,null,null,null,null,null];
(statearr_66455[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66455[(1)] = (1));

return statearr_66455;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66443){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66443);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66456){var ex__10753__auto__ = e66456;
var statearr_66457_66468 = state_66443;
(statearr_66457_66468[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66443[(4)]))){
var statearr_66458_66469 = state_66443;
(statearr_66458_66469[(1)] = cljs.core.first((state_66443[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66470 = state_66443;
state_66443 = G__66470;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66443){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66459 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66459[(6)] = c__10876__auto__);

return statearr_66459;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq66411){
var G__66412 = cljs.core.first(seq66411);
var seq66411__$1 = cljs.core.next(seq66411);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66412,seq66411__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66520 = arguments.length;
var i__4819__auto___66521 = (0);
while(true){
if((i__4819__auto___66521 < len__4818__auto___66520)){
args__4824__auto__.push((arguments[i__4819__auto___66521]));

var G__66522 = (i__4819__auto___66521 + (1));
i__4819__auto___66521 = G__66522;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66503){
var state_val_66504 = (state_66503[(1)]);
if((state_val_66504 === (1))){
var state_66503__$1 = state_66503;
var statearr_66505_66523 = state_66503__$1;
(statearr_66505_66523[(2)] = null);

(statearr_66505_66523[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66504 === (2))){
var _ = (function (){var statearr_66506 = state_66503;
(statearr_66506[(4)] = cljs.core.cons((5),(state_66503[(4)])));

return statearr_66506;
})();
var inst_66479 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66503__$1 = state_66503;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66503__$1,(6),inst_66479);
} else {
if((state_val_66504 === (3))){
var inst_66501 = (state_66503[(2)]);
var state_66503__$1 = state_66503;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66503__$1,inst_66501);
} else {
if((state_val_66504 === (4))){
var inst_66473 = (state_66503[(2)]);
var state_66503__$1 = state_66503;
var statearr_66508_66524 = state_66503__$1;
(statearr_66508_66524[(2)] = inst_66473);

(statearr_66508_66524[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66504 === (5))){
var _ = (function (){var statearr_66509 = state_66503;
(statearr_66509[(4)] = cljs.core.rest((state_66503[(4)])));

return statearr_66509;
})();
var state_66503__$1 = state_66503;
var ex66507 = (state_66503__$1[(2)]);
var statearr_66510_66525 = state_66503__$1;
(statearr_66510_66525[(5)] = ex66507);


if((ex66507 instanceof Error)){
var statearr_66511_66526 = state_66503__$1;
(statearr_66511_66526[(1)] = (4));

(statearr_66511_66526[(5)] = null);

} else {
throw ex66507;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66504 === (6))){
var inst_66481 = (state_66503[(2)]);
var inst_66482 = fluree.db.util.async.throw_err(inst_66481);
var inst_66483 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_66482);
var inst_66484 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66485 = [inst_66482];
var inst_66486 = (new cljs.core.PersistentVector(null,1,(5),inst_66484,inst_66485,null));
var inst_66487 = cljs.core.count(inst_66486);
var inst_66488 = ((9) + inst_66487);
var inst_66489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66490 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66491 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66492 = [inst_66482];
var inst_66493 = (new cljs.core.PersistentVector(null,1,(5),inst_66491,inst_66492,null));
var inst_66494 = ["<",inst_66493,inst_66483];
var inst_66495 = cljs.core.PersistentHashMap.fromArrays(inst_66490,inst_66494);
var inst_66496 = [inst_66495,inst_66488];
var inst_66497 = (new cljs.core.PersistentVector(null,2,(5),inst_66489,inst_66496,null));
var inst_66498 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66497);
var _ = (function (){var statearr_66512 = state_66503;
(statearr_66512[(4)] = cljs.core.rest((state_66503[(4)])));

return statearr_66512;
})();
var state_66503__$1 = (function (){var statearr_66513 = state_66503;
(statearr_66513[(7)] = inst_66498);

return statearr_66513;
})();
var statearr_66514_66527 = state_66503__$1;
(statearr_66514_66527[(2)] = inst_66483);

(statearr_66514_66527[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66515 = [null,null,null,null,null,null,null,null];
(statearr_66515[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66515[(1)] = (1));

return statearr_66515;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66503){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66503);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66516){var ex__10753__auto__ = e66516;
var statearr_66517_66528 = state_66503;
(statearr_66517_66528[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66503[(4)]))){
var statearr_66518_66529 = state_66503;
(statearr_66518_66529[(1)] = cljs.core.first((state_66503[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66530 = state_66503;
state_66503 = G__66530;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66503){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66503);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66519 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66519[(6)] = c__10876__auto__);

return statearr_66519;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq66471){
var G__66472 = cljs.core.first(seq66471);
var seq66471__$1 = cljs.core.next(seq66471);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66472,seq66471__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66580 = arguments.length;
var i__4819__auto___66581 = (0);
while(true){
if((i__4819__auto___66581 < len__4818__auto___66580)){
args__4824__auto__.push((arguments[i__4819__auto___66581]));

var G__66582 = (i__4819__auto___66581 + (1));
i__4819__auto___66581 = G__66582;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66563){
var state_val_66564 = (state_66563[(1)]);
if((state_val_66564 === (1))){
var state_66563__$1 = state_66563;
var statearr_66565_66583 = state_66563__$1;
(statearr_66565_66583[(2)] = null);

(statearr_66565_66583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66564 === (2))){
var _ = (function (){var statearr_66566 = state_66563;
(statearr_66566[(4)] = cljs.core.cons((5),(state_66563[(4)])));

return statearr_66566;
})();
var inst_66539 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66563__$1,(6),inst_66539);
} else {
if((state_val_66564 === (3))){
var inst_66561 = (state_66563[(2)]);
var state_66563__$1 = state_66563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66563__$1,inst_66561);
} else {
if((state_val_66564 === (4))){
var inst_66533 = (state_66563[(2)]);
var state_66563__$1 = state_66563;
var statearr_66568_66584 = state_66563__$1;
(statearr_66568_66584[(2)] = inst_66533);

(statearr_66568_66584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66564 === (5))){
var _ = (function (){var statearr_66569 = state_66563;
(statearr_66569[(4)] = cljs.core.rest((state_66563[(4)])));

return statearr_66569;
})();
var state_66563__$1 = state_66563;
var ex66567 = (state_66563__$1[(2)]);
var statearr_66570_66585 = state_66563__$1;
(statearr_66570_66585[(5)] = ex66567);


if((ex66567 instanceof Error)){
var statearr_66571_66586 = state_66563__$1;
(statearr_66571_66586[(1)] = (4));

(statearr_66571_66586[(5)] = null);

} else {
throw ex66567;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66564 === (6))){
var inst_66541 = (state_66563[(2)]);
var inst_66542 = fluree.db.util.async.throw_err(inst_66541);
var inst_66543 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_66542);
var inst_66544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66545 = [inst_66542];
var inst_66546 = (new cljs.core.PersistentVector(null,1,(5),inst_66544,inst_66545,null));
var inst_66547 = cljs.core.count(inst_66546);
var inst_66548 = ((9) + inst_66547);
var inst_66549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66550 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66551 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66552 = [inst_66542];
var inst_66553 = (new cljs.core.PersistentVector(null,1,(5),inst_66551,inst_66552,null));
var inst_66554 = ["<=",inst_66553,inst_66543];
var inst_66555 = cljs.core.PersistentHashMap.fromArrays(inst_66550,inst_66554);
var inst_66556 = [inst_66555,inst_66548];
var inst_66557 = (new cljs.core.PersistentVector(null,2,(5),inst_66549,inst_66556,null));
var inst_66558 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66557);
var _ = (function (){var statearr_66572 = state_66563;
(statearr_66572[(4)] = cljs.core.rest((state_66563[(4)])));

return statearr_66572;
})();
var state_66563__$1 = (function (){var statearr_66573 = state_66563;
(statearr_66573[(7)] = inst_66558);

return statearr_66573;
})();
var statearr_66574_66587 = state_66563__$1;
(statearr_66574_66587[(2)] = inst_66543);

(statearr_66574_66587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66575 = [null,null,null,null,null,null,null,null];
(statearr_66575[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66575[(1)] = (1));

return statearr_66575;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66563){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66563);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66576){var ex__10753__auto__ = e66576;
var statearr_66577_66588 = state_66563;
(statearr_66577_66588[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66563[(4)]))){
var statearr_66578_66589 = state_66563;
(statearr_66578_66589[(1)] = cljs.core.first((state_66563[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66590 = state_66563;
state_66563 = G__66590;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66563){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66579 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66579[(6)] = c__10876__auto__);

return statearr_66579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq66531){
var G__66532 = cljs.core.first(seq66531);
var seq66531__$1 = cljs.core.next(seq66531);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66532,seq66531__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66640 = arguments.length;
var i__4819__auto___66641 = (0);
while(true){
if((i__4819__auto___66641 < len__4818__auto___66640)){
args__4824__auto__.push((arguments[i__4819__auto___66641]));

var G__66642 = (i__4819__auto___66641 + (1));
i__4819__auto___66641 = G__66642;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66623){
var state_val_66624 = (state_66623[(1)]);
if((state_val_66624 === (1))){
var state_66623__$1 = state_66623;
var statearr_66625_66643 = state_66623__$1;
(statearr_66625_66643[(2)] = null);

(statearr_66625_66643[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66624 === (2))){
var _ = (function (){var statearr_66626 = state_66623;
(statearr_66626[(4)] = cljs.core.cons((5),(state_66623[(4)])));

return statearr_66626;
})();
var inst_66599 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66623__$1 = state_66623;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66623__$1,(6),inst_66599);
} else {
if((state_val_66624 === (3))){
var inst_66621 = (state_66623[(2)]);
var state_66623__$1 = state_66623;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66623__$1,inst_66621);
} else {
if((state_val_66624 === (4))){
var inst_66593 = (state_66623[(2)]);
var state_66623__$1 = state_66623;
var statearr_66628_66644 = state_66623__$1;
(statearr_66628_66644[(2)] = inst_66593);

(statearr_66628_66644[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66624 === (5))){
var _ = (function (){var statearr_66629 = state_66623;
(statearr_66629[(4)] = cljs.core.rest((state_66623[(4)])));

return statearr_66629;
})();
var state_66623__$1 = state_66623;
var ex66627 = (state_66623__$1[(2)]);
var statearr_66630_66645 = state_66623__$1;
(statearr_66630_66645[(5)] = ex66627);


if((ex66627 instanceof Error)){
var statearr_66631_66646 = state_66623__$1;
(statearr_66631_66646[(1)] = (4));

(statearr_66631_66646[(5)] = null);

} else {
throw ex66627;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66624 === (6))){
var inst_66601 = (state_66623[(2)]);
var inst_66602 = fluree.db.util.async.throw_err(inst_66601);
var inst_66603 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_66602);
var inst_66604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66605 = [inst_66602];
var inst_66606 = (new cljs.core.PersistentVector(null,1,(5),inst_66604,inst_66605,null));
var inst_66607 = cljs.core.count(inst_66606);
var inst_66608 = ((9) + inst_66607);
var inst_66609 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66610 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66611 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66612 = [inst_66602];
var inst_66613 = (new cljs.core.PersistentVector(null,1,(5),inst_66611,inst_66612,null));
var inst_66614 = [">=",inst_66613,inst_66603];
var inst_66615 = cljs.core.PersistentHashMap.fromArrays(inst_66610,inst_66614);
var inst_66616 = [inst_66615,inst_66608];
var inst_66617 = (new cljs.core.PersistentVector(null,2,(5),inst_66609,inst_66616,null));
var inst_66618 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66617);
var _ = (function (){var statearr_66632 = state_66623;
(statearr_66632[(4)] = cljs.core.rest((state_66623[(4)])));

return statearr_66632;
})();
var state_66623__$1 = (function (){var statearr_66633 = state_66623;
(statearr_66633[(7)] = inst_66618);

return statearr_66633;
})();
var statearr_66634_66647 = state_66623__$1;
(statearr_66634_66647[(2)] = inst_66603);

(statearr_66634_66647[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66635 = [null,null,null,null,null,null,null,null];
(statearr_66635[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66635[(1)] = (1));

return statearr_66635;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66623){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66623);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66636){var ex__10753__auto__ = e66636;
var statearr_66637_66648 = state_66623;
(statearr_66637_66648[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66623[(4)]))){
var statearr_66638_66649 = state_66623;
(statearr_66638_66649[(1)] = cljs.core.first((state_66623[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66650 = state_66623;
state_66623 = G__66650;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66623){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66623);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66639 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66639[(6)] = c__10876__auto__);

return statearr_66639;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq66591){
var G__66592 = cljs.core.first(seq66591);
var seq66591__$1 = cljs.core.next(seq66591);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66592,seq66591__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66700 = arguments.length;
var i__4819__auto___66701 = (0);
while(true){
if((i__4819__auto___66701 < len__4818__auto___66700)){
args__4824__auto__.push((arguments[i__4819__auto___66701]));

var G__66702 = (i__4819__auto___66701 + (1));
i__4819__auto___66701 = G__66702;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66683){
var state_val_66684 = (state_66683[(1)]);
if((state_val_66684 === (1))){
var state_66683__$1 = state_66683;
var statearr_66685_66703 = state_66683__$1;
(statearr_66685_66703[(2)] = null);

(statearr_66685_66703[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66684 === (2))){
var _ = (function (){var statearr_66686 = state_66683;
(statearr_66686[(4)] = cljs.core.cons((5),(state_66683[(4)])));

return statearr_66686;
})();
var inst_66659 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66683__$1 = state_66683;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66683__$1,(6),inst_66659);
} else {
if((state_val_66684 === (3))){
var inst_66681 = (state_66683[(2)]);
var state_66683__$1 = state_66683;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66683__$1,inst_66681);
} else {
if((state_val_66684 === (4))){
var inst_66653 = (state_66683[(2)]);
var state_66683__$1 = state_66683;
var statearr_66688_66704 = state_66683__$1;
(statearr_66688_66704[(2)] = inst_66653);

(statearr_66688_66704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66684 === (5))){
var _ = (function (){var statearr_66689 = state_66683;
(statearr_66689[(4)] = cljs.core.rest((state_66683[(4)])));

return statearr_66689;
})();
var state_66683__$1 = state_66683;
var ex66687 = (state_66683__$1[(2)]);
var statearr_66690_66705 = state_66683__$1;
(statearr_66690_66705[(5)] = ex66687);


if((ex66687 instanceof Error)){
var statearr_66691_66706 = state_66683__$1;
(statearr_66691_66706[(1)] = (4));

(statearr_66691_66706[(5)] = null);

} else {
throw ex66687;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66684 === (6))){
var inst_66661 = (state_66683[(2)]);
var inst_66662 = fluree.db.util.async.throw_err(inst_66661);
var inst_66663 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_66662);
var inst_66664 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66665 = [inst_66662];
var inst_66666 = (new cljs.core.PersistentVector(null,1,(5),inst_66664,inst_66665,null));
var inst_66667 = cljs.core.count(inst_66666);
var inst_66668 = ((9) + inst_66667);
var inst_66669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66670 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66671 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66672 = [inst_66662];
var inst_66673 = (new cljs.core.PersistentVector(null,1,(5),inst_66671,inst_66672,null));
var inst_66674 = ["not=",inst_66673,inst_66663];
var inst_66675 = cljs.core.PersistentHashMap.fromArrays(inst_66670,inst_66674);
var inst_66676 = [inst_66675,inst_66668];
var inst_66677 = (new cljs.core.PersistentVector(null,2,(5),inst_66669,inst_66676,null));
var inst_66678 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66677);
var _ = (function (){var statearr_66692 = state_66683;
(statearr_66692[(4)] = cljs.core.rest((state_66683[(4)])));

return statearr_66692;
})();
var state_66683__$1 = (function (){var statearr_66693 = state_66683;
(statearr_66693[(7)] = inst_66678);

return statearr_66693;
})();
var statearr_66694_66707 = state_66683__$1;
(statearr_66694_66707[(2)] = inst_66663);

(statearr_66694_66707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66695 = [null,null,null,null,null,null,null,null];
(statearr_66695[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66695[(1)] = (1));

return statearr_66695;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66683){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66683);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66696){var ex__10753__auto__ = e66696;
var statearr_66697_66708 = state_66683;
(statearr_66697_66708[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66683[(4)]))){
var statearr_66698_66709 = state_66683;
(statearr_66698_66709[(1)] = cljs.core.first((state_66683[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66710 = state_66683;
state_66683 = G__66710;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66683){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66683);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66699 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66699[(6)] = c__10876__auto__);

return statearr_66699;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq66651){
var G__66652 = cljs.core.first(seq66651);
var seq66651__$1 = cljs.core.next(seq66651);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66652,seq66651__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66760 = arguments.length;
var i__4819__auto___66761 = (0);
while(true){
if((i__4819__auto___66761 < len__4818__auto___66760)){
args__4824__auto__.push((arguments[i__4819__auto___66761]));

var G__66762 = (i__4819__auto___66761 + (1));
i__4819__auto___66761 = G__66762;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66743){
var state_val_66744 = (state_66743[(1)]);
if((state_val_66744 === (1))){
var state_66743__$1 = state_66743;
var statearr_66745_66763 = state_66743__$1;
(statearr_66745_66763[(2)] = null);

(statearr_66745_66763[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66744 === (2))){
var _ = (function (){var statearr_66746 = state_66743;
(statearr_66746[(4)] = cljs.core.cons((5),(state_66743[(4)])));

return statearr_66746;
})();
var inst_66719 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66743__$1 = state_66743;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66743__$1,(6),inst_66719);
} else {
if((state_val_66744 === (3))){
var inst_66741 = (state_66743[(2)]);
var state_66743__$1 = state_66743;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66743__$1,inst_66741);
} else {
if((state_val_66744 === (4))){
var inst_66713 = (state_66743[(2)]);
var state_66743__$1 = state_66743;
var statearr_66748_66764 = state_66743__$1;
(statearr_66748_66764[(2)] = inst_66713);

(statearr_66748_66764[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66744 === (5))){
var _ = (function (){var statearr_66749 = state_66743;
(statearr_66749[(4)] = cljs.core.rest((state_66743[(4)])));

return statearr_66749;
})();
var state_66743__$1 = state_66743;
var ex66747 = (state_66743__$1[(2)]);
var statearr_66750_66765 = state_66743__$1;
(statearr_66750_66765[(5)] = ex66747);


if((ex66747 instanceof Error)){
var statearr_66751_66766 = state_66743__$1;
(statearr_66751_66766[(1)] = (4));

(statearr_66751_66766[(5)] = null);

} else {
throw ex66747;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66744 === (6))){
var inst_66721 = (state_66743[(2)]);
var inst_66722 = fluree.db.util.async.throw_err(inst_66721);
var inst_66723 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_66722);
var inst_66724 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66725 = [inst_66722];
var inst_66726 = (new cljs.core.PersistentVector(null,1,(5),inst_66724,inst_66725,null));
var inst_66727 = cljs.core.count(inst_66726);
var inst_66728 = ((9) + inst_66727);
var inst_66729 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66730 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66731 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66732 = [inst_66722];
var inst_66733 = (new cljs.core.PersistentVector(null,1,(5),inst_66731,inst_66732,null));
var inst_66734 = ["max",inst_66733,inst_66723];
var inst_66735 = cljs.core.PersistentHashMap.fromArrays(inst_66730,inst_66734);
var inst_66736 = [inst_66735,inst_66728];
var inst_66737 = (new cljs.core.PersistentVector(null,2,(5),inst_66729,inst_66736,null));
var inst_66738 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66737);
var _ = (function (){var statearr_66752 = state_66743;
(statearr_66752[(4)] = cljs.core.rest((state_66743[(4)])));

return statearr_66752;
})();
var state_66743__$1 = (function (){var statearr_66753 = state_66743;
(statearr_66753[(7)] = inst_66738);

return statearr_66753;
})();
var statearr_66754_66767 = state_66743__$1;
(statearr_66754_66767[(2)] = inst_66723);

(statearr_66754_66767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66755 = [null,null,null,null,null,null,null,null];
(statearr_66755[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66755[(1)] = (1));

return statearr_66755;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66743){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66743);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66756){var ex__10753__auto__ = e66756;
var statearr_66757_66768 = state_66743;
(statearr_66757_66768[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66743[(4)]))){
var statearr_66758_66769 = state_66743;
(statearr_66758_66769[(1)] = cljs.core.first((state_66743[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66770 = state_66743;
state_66743 = G__66770;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66743){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66759 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66759[(6)] = c__10876__auto__);

return statearr_66759;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq66711){
var G__66712 = cljs.core.first(seq66711);
var seq66711__$1 = cljs.core.next(seq66711);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66712,seq66711__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___66820 = arguments.length;
var i__4819__auto___66821 = (0);
while(true){
if((i__4819__auto___66821 < len__4818__auto___66820)){
args__4824__auto__.push((arguments[i__4819__auto___66821]));

var G__66822 = (i__4819__auto___66821 + (1));
i__4819__auto___66821 = G__66822;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66803){
var state_val_66804 = (state_66803[(1)]);
if((state_val_66804 === (1))){
var state_66803__$1 = state_66803;
var statearr_66805_66823 = state_66803__$1;
(statearr_66805_66823[(2)] = null);

(statearr_66805_66823[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66804 === (2))){
var _ = (function (){var statearr_66806 = state_66803;
(statearr_66806[(4)] = cljs.core.cons((5),(state_66803[(4)])));

return statearr_66806;
})();
var inst_66779 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_66803__$1 = state_66803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66803__$1,(6),inst_66779);
} else {
if((state_val_66804 === (3))){
var inst_66801 = (state_66803[(2)]);
var state_66803__$1 = state_66803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66803__$1,inst_66801);
} else {
if((state_val_66804 === (4))){
var inst_66773 = (state_66803[(2)]);
var state_66803__$1 = state_66803;
var statearr_66808_66824 = state_66803__$1;
(statearr_66808_66824[(2)] = inst_66773);

(statearr_66808_66824[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66804 === (5))){
var _ = (function (){var statearr_66809 = state_66803;
(statearr_66809[(4)] = cljs.core.rest((state_66803[(4)])));

return statearr_66809;
})();
var state_66803__$1 = state_66803;
var ex66807 = (state_66803__$1[(2)]);
var statearr_66810_66825 = state_66803__$1;
(statearr_66810_66825[(5)] = ex66807);


if((ex66807 instanceof Error)){
var statearr_66811_66826 = state_66803__$1;
(statearr_66811_66826[(1)] = (4));

(statearr_66811_66826[(5)] = null);

} else {
throw ex66807;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66804 === (6))){
var inst_66781 = (state_66803[(2)]);
var inst_66782 = fluree.db.util.async.throw_err(inst_66781);
var inst_66783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_66782);
var inst_66784 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66785 = [inst_66782];
var inst_66786 = (new cljs.core.PersistentVector(null,1,(5),inst_66784,inst_66785,null));
var inst_66787 = cljs.core.count(inst_66786);
var inst_66788 = ((9) + inst_66787);
var inst_66789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66790 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66792 = [inst_66782];
var inst_66793 = (new cljs.core.PersistentVector(null,1,(5),inst_66791,inst_66792,null));
var inst_66794 = ["min",inst_66793,inst_66783];
var inst_66795 = cljs.core.PersistentHashMap.fromArrays(inst_66790,inst_66794);
var inst_66796 = [inst_66795,inst_66788];
var inst_66797 = (new cljs.core.PersistentVector(null,2,(5),inst_66789,inst_66796,null));
var inst_66798 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66797);
var _ = (function (){var statearr_66812 = state_66803;
(statearr_66812[(4)] = cljs.core.rest((state_66803[(4)])));

return statearr_66812;
})();
var state_66803__$1 = (function (){var statearr_66813 = state_66803;
(statearr_66813[(7)] = inst_66798);

return statearr_66813;
})();
var statearr_66814_66827 = state_66803__$1;
(statearr_66814_66827[(2)] = inst_66783);

(statearr_66814_66827[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66815 = [null,null,null,null,null,null,null,null];
(statearr_66815[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66815[(1)] = (1));

return statearr_66815;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66803){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66803);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66816){var ex__10753__auto__ = e66816;
var statearr_66817_66828 = state_66803;
(statearr_66817_66828[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66803[(4)]))){
var statearr_66818_66829 = state_66803;
(statearr_66818_66829[(1)] = cljs.core.first((state_66803[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__66830 = state_66803;
state_66803 = G__66830;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66819 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66819[(6)] = c__10876__auto__);

return statearr_66819;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq66771){
var G__66772 = cljs.core.first(seq66771);
var seq66771__$1 = cljs.core.next(seq66771);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__66772,seq66771__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__66832 = arguments.length;
switch (G__66832) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66877){
var state_val_66878 = (state_66877[(1)]);
if((state_val_66878 === (7))){
var state_66877__$1 = state_66877;
var statearr_66879_67016 = state_66877__$1;
(statearr_66879_67016[(2)] = query_map);

(statearr_66879_67016[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (1))){
var state_66877__$1 = state_66877;
var statearr_66880_67017 = state_66877__$1;
(statearr_66880_67017[(2)] = null);

(statearr_66880_67017[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (4))){
var inst_66833 = (state_66877[(2)]);
var state_66877__$1 = state_66877;
var statearr_66881_67018 = state_66877__$1;
(statearr_66881_67018[(2)] = inst_66833);

(statearr_66881_67018[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (13))){
var inst_66855 = (state_66877[(7)]);
var inst_66859 = (state_66877[(2)]);
var inst_66860 = fluree.db.util.async.throw_err(inst_66859);
var inst_66861 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66860,(0),null);
var inst_66862 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66860,(1),null);
var inst_66863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66864 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66866 = [inst_66855];
var inst_66867 = (new cljs.core.PersistentVector(null,1,(5),inst_66865,inst_66866,null));
var inst_66868 = ["query",inst_66867,inst_66861];
var inst_66869 = cljs.core.PersistentHashMap.fromArrays(inst_66864,inst_66868);
var inst_66870 = [inst_66869,inst_66862];
var inst_66871 = (new cljs.core.PersistentVector(null,2,(5),inst_66863,inst_66870,null));
var inst_66872 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66871);
var _ = (function (){var statearr_66882 = state_66877;
(statearr_66882[(4)] = cljs.core.rest((state_66877[(4)])));

return statearr_66882;
})();
var state_66877__$1 = (function (){var statearr_66883 = state_66877;
(statearr_66883[(8)] = inst_66872);

return statearr_66883;
})();
var statearr_66884_67019 = state_66877__$1;
(statearr_66884_67019[(2)] = inst_66861);

(statearr_66884_67019[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (6))){
var state_66877__$1 = state_66877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66877__$1,(9),query_map);
} else {
if((state_val_66878 === (3))){
var inst_66875 = (state_66877[(2)]);
var state_66877__$1 = state_66877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66877__$1,inst_66875);
} else {
if((state_val_66878 === (12))){
var inst_66855 = (state_66877[(7)]);
var inst_66855__$1 = (state_66877[(2)]);
var inst_66856 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66857 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_66856,inst_66855__$1);
var state_66877__$1 = (function (){var statearr_66885 = state_66877;
(statearr_66885[(7)] = inst_66855__$1);

return statearr_66885;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66877__$1,(13),inst_66857);
} else {
if((state_val_66878 === (2))){
var _ = (function (){var statearr_66886 = state_66877;
(statearr_66886[(4)] = cljs.core.cons((5),(state_66877[(4)])));

return statearr_66886;
})();
var inst_66842 = fluree.db.util.async.channel_QMARK_(query_map);
var state_66877__$1 = state_66877;
if(inst_66842){
var statearr_66887_67020 = state_66877__$1;
(statearr_66887_67020[(1)] = (6));

} else {
var statearr_66888_67021 = state_66877__$1;
(statearr_66888_67021[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (11))){
var inst_66849 = (state_66877[(9)]);
var state_66877__$1 = state_66877;
var statearr_66890_67022 = state_66877__$1;
(statearr_66890_67022[(2)] = inst_66849);

(statearr_66890_67022[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (9))){
var inst_66845 = (state_66877[(2)]);
var inst_66846 = fluree.db.util.async.throw_err(inst_66845);
var state_66877__$1 = state_66877;
var statearr_66891_67023 = state_66877__$1;
(statearr_66891_67023[(2)] = inst_66846);

(statearr_66891_67023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (5))){
var _ = (function (){var statearr_66892 = state_66877;
(statearr_66892[(4)] = cljs.core.rest((state_66877[(4)])));

return statearr_66892;
})();
var state_66877__$1 = state_66877;
var ex66889 = (state_66877__$1[(2)]);
var statearr_66893_67024 = state_66877__$1;
(statearr_66893_67024[(5)] = ex66889);


if((ex66889 instanceof Error)){
var statearr_66894_67025 = state_66877__$1;
(statearr_66894_67025[(1)] = (4));

(statearr_66894_67025[(5)] = null);

} else {
throw ex66889;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (10))){
var inst_66849 = (state_66877[(9)]);
var inst_66852 = fluree.db.util.json.parse(inst_66849);
var state_66877__$1 = state_66877;
var statearr_66895_67026 = state_66877__$1;
(statearr_66895_67026[(2)] = inst_66852);

(statearr_66895_67026[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66878 === (8))){
var inst_66849 = (state_66877[(9)]);
var inst_66849__$1 = (state_66877[(2)]);
var inst_66850 = typeof inst_66849__$1 === 'string';
var state_66877__$1 = (function (){var statearr_66896 = state_66877;
(statearr_66896[(9)] = inst_66849__$1);

return statearr_66896;
})();
if(cljs.core.truth_(inst_66850)){
var statearr_66897_67027 = state_66877__$1;
(statearr_66897_67027[(1)] = (10));

} else {
var statearr_66898_67028 = state_66877__$1;
(statearr_66898_67028[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_66899 = [null,null,null,null,null,null,null,null,null,null];
(statearr_66899[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_66899[(1)] = (1));

return statearr_66899;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66877){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66877);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e66900){var ex__10753__auto__ = e66900;
var statearr_66901_67029 = state_66877;
(statearr_66901_67029[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66877[(4)]))){
var statearr_66902_67030 = state_66877;
(statearr_66902_67030[(1)] = cljs.core.first((state_66877[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67031 = state_66877;
state_66877 = G__67031;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66877){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_66903 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_66903[(6)] = c__10876__auto__);

return statearr_66903;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_66974){
var state_val_66975 = (state_66974[(1)]);
if((state_val_66975 === (7))){
var state_66974__$1 = state_66974;
var statearr_66976_67032 = state_66974__$1;
(statearr_66976_67032[(2)] = select);

(statearr_66976_67032[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (20))){
var inst_66944 = (state_66974[(2)]);
var inst_66945 = fluree.db.util.async.channel_QMARK_(limit);
var state_66974__$1 = (function (){var statearr_66977 = state_66974;
(statearr_66977[(7)] = inst_66944);

return statearr_66977;
})();
if(inst_66945){
var statearr_66978_67033 = state_66974__$1;
(statearr_66978_67033[(1)] = (22));

} else {
var statearr_66979_67034 = state_66974__$1;
(statearr_66979_67034[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (1))){
var state_66974__$1 = state_66974;
var statearr_66980_67035 = state_66974__$1;
(statearr_66980_67035[(2)] = null);

(statearr_66980_67035[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (24))){
var inst_66928 = (state_66974[(8)]);
var inst_66936 = (state_66974[(9)]);
var inst_66944 = (state_66974[(7)]);
var inst_66920 = (state_66974[(10)]);
var inst_66952 = (state_66974[(2)]);
var inst_66953 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_66954 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_66953,inst_66920,inst_66928,inst_66936,inst_66944,inst_66952);
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(26),inst_66954);
} else {
if((state_val_66975 === (4))){
var inst_66904 = (state_66974[(2)]);
var state_66974__$1 = state_66974;
var statearr_66981_67036 = state_66974__$1;
(statearr_66981_67036[(2)] = inst_66904);

(statearr_66981_67036[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (15))){
var state_66974__$1 = state_66974;
var statearr_66982_67037 = state_66974__$1;
(statearr_66982_67037[(2)] = where);

(statearr_66982_67037[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (21))){
var inst_66940 = (state_66974[(2)]);
var inst_66941 = fluree.db.util.async.throw_err(inst_66940);
var state_66974__$1 = state_66974;
var statearr_66983_67038 = state_66974__$1;
(statearr_66983_67038[(2)] = inst_66941);

(statearr_66983_67038[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (13))){
var inst_66924 = (state_66974[(2)]);
var inst_66925 = fluree.db.util.async.throw_err(inst_66924);
var state_66974__$1 = state_66974;
var statearr_66984_67039 = state_66974__$1;
(statearr_66984_67039[(2)] = inst_66925);

(statearr_66984_67039[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (22))){
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(25),limit);
} else {
if((state_val_66975 === (6))){
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(9),select);
} else {
if((state_val_66975 === (25))){
var inst_66948 = (state_66974[(2)]);
var inst_66949 = fluree.db.util.async.throw_err(inst_66948);
var state_66974__$1 = state_66974;
var statearr_66985_67040 = state_66974__$1;
(statearr_66985_67040[(2)] = inst_66949);

(statearr_66985_67040[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (17))){
var inst_66932 = (state_66974[(2)]);
var inst_66933 = fluree.db.util.async.throw_err(inst_66932);
var state_66974__$1 = state_66974;
var statearr_66986_67041 = state_66974__$1;
(statearr_66986_67041[(2)] = inst_66933);

(statearr_66986_67041[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (3))){
var inst_66972 = (state_66974[(2)]);
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.return_chan(state_66974__$1,inst_66972);
} else {
if((state_val_66975 === (12))){
var inst_66928 = (state_66974[(2)]);
var inst_66929 = fluree.db.util.async.channel_QMARK_(where);
var state_66974__$1 = (function (){var statearr_66987 = state_66974;
(statearr_66987[(8)] = inst_66928);

return statearr_66987;
})();
if(inst_66929){
var statearr_66988_67042 = state_66974__$1;
(statearr_66988_67042[(1)] = (14));

} else {
var statearr_66989_67043 = state_66974__$1;
(statearr_66989_67043[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (2))){
var _ = (function (){var statearr_66990 = state_66974;
(statearr_66990[(4)] = cljs.core.cons((5),(state_66974[(4)])));

return statearr_66990;
})();
var inst_66913 = fluree.db.util.async.channel_QMARK_(select);
var state_66974__$1 = state_66974;
if(inst_66913){
var statearr_66991_67044 = state_66974__$1;
(statearr_66991_67044[(1)] = (6));

} else {
var statearr_66992_67045 = state_66974__$1;
(statearr_66992_67045[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (23))){
var state_66974__$1 = state_66974;
var statearr_66993_67046 = state_66974__$1;
(statearr_66993_67046[(2)] = limit);

(statearr_66993_67046[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (19))){
var state_66974__$1 = state_66974;
var statearr_66994_67047 = state_66974__$1;
(statearr_66994_67047[(2)] = block);

(statearr_66994_67047[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (11))){
var state_66974__$1 = state_66974;
var statearr_66996_67048 = state_66974__$1;
(statearr_66996_67048[(2)] = from);

(statearr_66996_67048[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (9))){
var inst_66916 = (state_66974[(2)]);
var inst_66917 = fluree.db.util.async.throw_err(inst_66916);
var state_66974__$1 = state_66974;
var statearr_66997_67049 = state_66974__$1;
(statearr_66997_67049[(2)] = inst_66917);

(statearr_66997_67049[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (5))){
var _ = (function (){var statearr_66998 = state_66974;
(statearr_66998[(4)] = cljs.core.rest((state_66974[(4)])));

return statearr_66998;
})();
var state_66974__$1 = state_66974;
var ex66995 = (state_66974__$1[(2)]);
var statearr_66999_67050 = state_66974__$1;
(statearr_66999_67050[(5)] = ex66995);


if((ex66995 instanceof Error)){
var statearr_67000_67051 = state_66974__$1;
(statearr_67000_67051[(1)] = (4));

(statearr_67000_67051[(5)] = null);

} else {
throw ex66995;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (14))){
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(17),where);
} else {
if((state_val_66975 === (26))){
var inst_66928 = (state_66974[(8)]);
var inst_66936 = (state_66974[(9)]);
var inst_66944 = (state_66974[(7)]);
var inst_66920 = (state_66974[(10)]);
var inst_66956 = (state_66974[(2)]);
var inst_66957 = fluree.db.util.async.throw_err(inst_66956);
var inst_66958 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66957,(0),null);
var inst_66959 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_66957,(1),null);
var inst_66960 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66961 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_66962 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_66963 = [inst_66920,inst_66928,inst_66936,inst_66944];
var inst_66964 = (new cljs.core.PersistentVector(null,4,(5),inst_66962,inst_66963,null));
var inst_66965 = ["query",inst_66964,inst_66958];
var inst_66966 = cljs.core.PersistentHashMap.fromArrays(inst_66961,inst_66965);
var inst_66967 = [inst_66966,inst_66959];
var inst_66968 = (new cljs.core.PersistentVector(null,2,(5),inst_66960,inst_66967,null));
var inst_66969 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_66968);
var _ = (function (){var statearr_67001 = state_66974;
(statearr_67001[(4)] = cljs.core.rest((state_66974[(4)])));

return statearr_67001;
})();
var state_66974__$1 = (function (){var statearr_67002 = state_66974;
(statearr_67002[(11)] = inst_66969);

return statearr_67002;
})();
var statearr_67003_67052 = state_66974__$1;
(statearr_67003_67052[(2)] = inst_66958);

(statearr_67003_67052[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (16))){
var inst_66936 = (state_66974[(2)]);
var inst_66937 = fluree.db.util.async.channel_QMARK_(block);
var state_66974__$1 = (function (){var statearr_67004 = state_66974;
(statearr_67004[(9)] = inst_66936);

return statearr_67004;
})();
if(inst_66937){
var statearr_67005_67053 = state_66974__$1;
(statearr_67005_67053[(1)] = (18));

} else {
var statearr_67006_67054 = state_66974__$1;
(statearr_67006_67054[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_66975 === (10))){
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(13),from);
} else {
if((state_val_66975 === (18))){
var state_66974__$1 = state_66974;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_66974__$1,(21),block);
} else {
if((state_val_66975 === (8))){
var inst_66920 = (state_66974[(2)]);
var inst_66921 = fluree.db.util.async.channel_QMARK_(from);
var state_66974__$1 = (function (){var statearr_67007 = state_66974;
(statearr_67007[(10)] = inst_66920);

return statearr_67007;
})();
if(inst_66921){
var statearr_67008_67055 = state_66974__$1;
(statearr_67008_67055[(1)] = (10));

} else {
var statearr_67009_67056 = state_66974__$1;
(statearr_67009_67056[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_67010 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67010[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_67010[(1)] = (1));

return statearr_67010;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_66974){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_66974);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67011){var ex__10753__auto__ = e67011;
var statearr_67012_67057 = state_66974;
(statearr_67012_67057[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_66974[(4)]))){
var statearr_67013_67058 = state_66974;
(statearr_67013_67058[(1)] = cljs.core.first((state_66974[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67059 = state_66974;
state_66974 = G__67059;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_66974){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_66974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67014 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67014[(6)] = c__10876__auto__);

return statearr_67014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67115){
var state_val_67116 = (state_67115[(1)]);
if((state_val_67116 === (7))){
var state_67115__$1 = state_67115;
var statearr_67117_67148 = state_67115__$1;
(statearr_67117_67148[(2)] = startSubject);

(statearr_67117_67148[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (1))){
var state_67115__$1 = state_67115;
var statearr_67118_67149 = state_67115__$1;
(statearr_67118_67149[(2)] = null);

(statearr_67118_67149[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (4))){
var inst_67060 = (state_67115[(2)]);
var state_67115__$1 = state_67115;
var statearr_67119_67150 = state_67115__$1;
(statearr_67119_67150[(2)] = inst_67060);

(statearr_67119_67150[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (15))){
var inst_67092 = (state_67115[(2)]);
var inst_67093 = fluree.db.util.async.throw_err(inst_67092);
var inst_67094 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67093,(0),null);
var inst_67095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67093,(1),null);
var inst_67096 = cljs.core.empty_QMARK_(inst_67094);
var state_67115__$1 = (function (){var statearr_67120 = state_67115;
(statearr_67120[(7)] = inst_67095);

return statearr_67120;
})();
if(inst_67096){
var statearr_67121_67151 = state_67115__$1;
(statearr_67121_67151[(1)] = (16));

} else {
var statearr_67122_67152 = state_67115__$1;
(statearr_67122_67152[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (13))){
var inst_67080 = (state_67115[(8)]);
var inst_67088 = (state_67115[(9)]);
var inst_67076 = (state_67115[(10)]);
var inst_67088__$1 = (state_67115[(2)]);
var inst_67089 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67090 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_67089,inst_67076,inst_67080,inst_67088__$1);
var state_67115__$1 = (function (){var statearr_67123 = state_67115;
(statearr_67123[(9)] = inst_67088__$1);

return statearr_67123;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67115__$1,(15),inst_67090);
} else {
if((state_val_67116 === (6))){
var state_67115__$1 = state_67115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67115__$1,(9),startSubject);
} else {
if((state_val_67116 === (17))){
var state_67115__$1 = state_67115;
var statearr_67124_67153 = state_67115__$1;
(statearr_67124_67153[(2)] = true);

(statearr_67124_67153[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (3))){
var inst_67113 = (state_67115[(2)]);
var state_67115__$1 = state_67115;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67115__$1,inst_67113);
} else {
if((state_val_67116 === (12))){
var state_67115__$1 = state_67115;
var statearr_67125_67154 = state_67115__$1;
(statearr_67125_67154[(2)] = endSubject);

(statearr_67125_67154[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (2))){
var _ = (function (){var statearr_67126 = state_67115;
(statearr_67126[(4)] = cljs.core.cons((5),(state_67115[(4)])));

return statearr_67126;
})();
var inst_67069 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_67115__$1 = state_67115;
if(inst_67069){
var statearr_67127_67155 = state_67115__$1;
(statearr_67127_67155[(1)] = (6));

} else {
var statearr_67128_67156 = state_67115__$1;
(statearr_67128_67156[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (11))){
var state_67115__$1 = state_67115;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67115__$1,(14),endSubject);
} else {
if((state_val_67116 === (9))){
var inst_67072 = (state_67115[(2)]);
var inst_67073 = fluree.db.util.async.throw_err(inst_67072);
var state_67115__$1 = state_67115;
var statearr_67130_67157 = state_67115__$1;
(statearr_67130_67157[(2)] = inst_67073);

(statearr_67130_67157[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (5))){
var _ = (function (){var statearr_67131 = state_67115;
(statearr_67131[(4)] = cljs.core.rest((state_67115[(4)])));

return statearr_67131;
})();
var state_67115__$1 = state_67115;
var ex67129 = (state_67115__$1[(2)]);
var statearr_67132_67158 = state_67115__$1;
(statearr_67132_67158[(5)] = ex67129);


if((ex67129 instanceof Error)){
var statearr_67133_67159 = state_67115__$1;
(statearr_67133_67159[(1)] = (4));

(statearr_67133_67159[(5)] = null);

} else {
throw ex67129;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (14))){
var inst_67084 = (state_67115[(2)]);
var inst_67085 = fluree.db.util.async.throw_err(inst_67084);
var state_67115__$1 = state_67115;
var statearr_67134_67160 = state_67115__$1;
(statearr_67134_67160[(2)] = inst_67085);

(statearr_67134_67160[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (16))){
var state_67115__$1 = state_67115;
var statearr_67135_67161 = state_67115__$1;
(statearr_67135_67161[(2)] = false);

(statearr_67135_67161[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (10))){
var inst_67079 = (state_67115[(2)]);
var inst_67080 = fluree.db.util.async.throw_err(inst_67079);
var inst_67081 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_67115__$1 = (function (){var statearr_67136 = state_67115;
(statearr_67136[(8)] = inst_67080);

return statearr_67136;
})();
if(inst_67081){
var statearr_67137_67162 = state_67115__$1;
(statearr_67137_67162[(1)] = (11));

} else {
var statearr_67138_67163 = state_67115__$1;
(statearr_67138_67163[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (18))){
var inst_67095 = (state_67115[(7)]);
var inst_67080 = (state_67115[(8)]);
var inst_67088 = (state_67115[(9)]);
var inst_67076 = (state_67115[(10)]);
var inst_67100 = (state_67115[(2)]);
var inst_67101 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67102 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67104 = [inst_67076,inst_67080,inst_67088];
var inst_67105 = (new cljs.core.PersistentVector(null,3,(5),inst_67103,inst_67104,null));
var inst_67106 = ["relationship?",inst_67105,inst_67100];
var inst_67107 = cljs.core.PersistentHashMap.fromArrays(inst_67102,inst_67106);
var inst_67108 = [inst_67107,inst_67095];
var inst_67109 = (new cljs.core.PersistentVector(null,2,(5),inst_67101,inst_67108,null));
var inst_67110 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67109);
var _ = (function (){var statearr_67139 = state_67115;
(statearr_67139[(4)] = cljs.core.rest((state_67115[(4)])));

return statearr_67139;
})();
var state_67115__$1 = (function (){var statearr_67140 = state_67115;
(statearr_67140[(11)] = inst_67110);

return statearr_67140;
})();
var statearr_67141_67164 = state_67115__$1;
(statearr_67141_67164[(2)] = inst_67100);

(statearr_67141_67164[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67116 === (8))){
var inst_67076 = (state_67115[(2)]);
var inst_67077 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_67115__$1 = (function (){var statearr_67142 = state_67115;
(statearr_67142[(10)] = inst_67076);

return statearr_67142;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67115__$1,(10),inst_67077);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_67143 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_67143[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__);

(statearr_67143[(1)] = (1));

return statearr_67143;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____1 = (function (state_67115){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67115);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67144){var ex__10753__auto__ = e67144;
var statearr_67145_67165 = state_67115;
(statearr_67145_67165[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67115[(4)]))){
var statearr_67146_67166 = state_67115;
(statearr_67146_67166[(1)] = cljs.core.first((state_67115[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67167 = state_67115;
state_67115 = G__67167;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__ = function(state_67115){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____1.call(this,state_67115);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67147 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67147[(6)] = c__10876__auto__);

return statearr_67147;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67204){
var state_val_67205 = (state_67204[(1)]);
if((state_val_67205 === (7))){
var state_67204__$1 = state_67204;
var statearr_67206_67226 = state_67204__$1;
(statearr_67206_67226[(2)] = pred_name);

(statearr_67206_67226[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (1))){
var state_67204__$1 = state_67204;
var statearr_67207_67227 = state_67204__$1;
(statearr_67207_67227[(2)] = null);

(statearr_67207_67227[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (4))){
var inst_67168 = (state_67204[(2)]);
var state_67204__$1 = state_67204;
var statearr_67208_67228 = state_67204__$1;
(statearr_67208_67228[(2)] = inst_67168);

(statearr_67208_67228[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (6))){
var state_67204__$1 = state_67204;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67204__$1,(9),pred_name);
} else {
if((state_val_67205 === (3))){
var inst_67202 = (state_67204[(2)]);
var state_67204__$1 = state_67204;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67204__$1,inst_67202);
} else {
if((state_val_67205 === (2))){
var _ = (function (){var statearr_67210 = state_67204;
(statearr_67210[(4)] = cljs.core.cons((5),(state_67204[(4)])));

return statearr_67210;
})();
var inst_67177 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_67204__$1 = state_67204;
if(inst_67177){
var statearr_67211_67229 = state_67204__$1;
(statearr_67211_67229[(1)] = (6));

} else {
var statearr_67212_67230 = state_67204__$1;
(statearr_67212_67230[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (9))){
var inst_67180 = (state_67204[(2)]);
var inst_67181 = fluree.db.util.async.throw_err(inst_67180);
var state_67204__$1 = state_67204;
var statearr_67213_67231 = state_67204__$1;
(statearr_67213_67231[(2)] = inst_67181);

(statearr_67213_67231[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (5))){
var _ = (function (){var statearr_67214 = state_67204;
(statearr_67214[(4)] = cljs.core.rest((state_67204[(4)])));

return statearr_67214;
})();
var state_67204__$1 = state_67204;
var ex67209 = (state_67204__$1[(2)]);
var statearr_67215_67232 = state_67204__$1;
(statearr_67215_67232[(5)] = ex67209);


if((ex67209 instanceof Error)){
var statearr_67216_67233 = state_67204__$1;
(statearr_67216_67233[(1)] = (4));

(statearr_67216_67233[(5)] = null);

} else {
throw ex67209;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (10))){
var inst_67184 = (state_67204[(7)]);
var inst_67188 = (state_67204[(2)]);
var inst_67189 = fluree.db.util.async.throw_err(inst_67188);
var inst_67190 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67189,(0),null);
var inst_67191 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_67189,(1),null);
var inst_67192 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67193 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67194 = ["max-pred-val",inst_67184,inst_67190];
var inst_67195 = cljs.core.PersistentHashMap.fromArrays(inst_67193,inst_67194);
var inst_67196 = (inst_67191 + (10));
var inst_67197 = [inst_67195,inst_67196];
var inst_67198 = (new cljs.core.PersistentVector(null,2,(5),inst_67192,inst_67197,null));
var inst_67199 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67198);
var _ = (function (){var statearr_67217 = state_67204;
(statearr_67217[(4)] = cljs.core.rest((state_67204[(4)])));

return statearr_67217;
})();
var state_67204__$1 = (function (){var statearr_67218 = state_67204;
(statearr_67218[(8)] = inst_67199);

return statearr_67218;
})();
var statearr_67219_67234 = state_67204__$1;
(statearr_67219_67234[(2)] = inst_67190);

(statearr_67219_67234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67205 === (8))){
var inst_67184 = (state_67204[(7)]);
var inst_67184__$1 = (state_67204[(2)]);
var inst_67185 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_67186 = fluree.db.dbfunctions.internal.max_pred_val(inst_67185,inst_67184__$1,null);
var state_67204__$1 = (function (){var statearr_67220 = state_67204;
(statearr_67220[(7)] = inst_67184__$1);

return statearr_67220;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67204__$1,(10),inst_67186);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____0 = (function (){
var statearr_67221 = [null,null,null,null,null,null,null,null,null];
(statearr_67221[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__);

(statearr_67221[(1)] = (1));

return statearr_67221;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____1 = (function (state_67204){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67204);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67222){var ex__10753__auto__ = e67222;
var statearr_67223_67235 = state_67204;
(statearr_67223_67235[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67204[(4)]))){
var statearr_67224_67236 = state_67204;
(statearr_67224_67236[(1)] = cljs.core.first((state_67204[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67237 = state_67204;
state_67204 = G__67237;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__ = function(state_67204){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____1.call(this,state_67204);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67225 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67225[(6)] = c__10876__auto__);

return statearr_67225;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67264){
var state_val_67265 = (state_67264[(1)]);
if((state_val_67265 === (7))){
var state_67264__$1 = state_67264;
var statearr_67266_67285 = state_67264__$1;
(statearr_67266_67285[(2)] = n);

(statearr_67266_67285[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (1))){
var state_67264__$1 = state_67264;
var statearr_67267_67286 = state_67264__$1;
(statearr_67267_67286[(2)] = null);

(statearr_67267_67286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (4))){
var inst_67238 = (state_67264[(2)]);
var state_67264__$1 = state_67264;
var statearr_67268_67287 = state_67264__$1;
(statearr_67268_67287[(2)] = inst_67238);

(statearr_67268_67287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (6))){
var state_67264__$1 = state_67264;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67264__$1,(9),n);
} else {
if((state_val_67265 === (3))){
var inst_67262 = (state_67264[(2)]);
var state_67264__$1 = state_67264;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67264__$1,inst_67262);
} else {
if((state_val_67265 === (2))){
var _ = (function (){var statearr_67270 = state_67264;
(statearr_67270[(4)] = cljs.core.cons((5),(state_67264[(4)])));

return statearr_67270;
})();
var inst_67244 = fluree.db.util.async.channel_QMARK_(n);
var state_67264__$1 = state_67264;
if(inst_67244){
var statearr_67271_67288 = state_67264__$1;
(statearr_67271_67288[(1)] = (6));

} else {
var statearr_67272_67289 = state_67264__$1;
(statearr_67272_67289[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (9))){
var inst_67247 = (state_67264[(2)]);
var inst_67248 = fluree.db.util.async.throw_err(inst_67247);
var state_67264__$1 = state_67264;
var statearr_67273_67290 = state_67264__$1;
(statearr_67273_67290[(2)] = inst_67248);

(statearr_67273_67290[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (5))){
var _ = (function (){var statearr_67274 = state_67264;
(statearr_67274[(4)] = cljs.core.rest((state_67264[(4)])));

return statearr_67274;
})();
var state_67264__$1 = state_67264;
var ex67269 = (state_67264__$1[(2)]);
var statearr_67275_67291 = state_67264__$1;
(statearr_67275_67291[(5)] = ex67269);


if((ex67269 instanceof Error)){
var statearr_67276_67292 = state_67264__$1;
(statearr_67276_67292[(1)] = (4));

(statearr_67276_67292[(5)] = null);

} else {
throw ex67269;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67265 === (8))){
var inst_67251 = (state_67264[(2)]);
var inst_67252 = fluree.db.dbfunctions.internal.inc(inst_67251);
var inst_67253 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67254 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67255 = ["inc",inst_67251,inst_67252];
var inst_67256 = cljs.core.PersistentHashMap.fromArrays(inst_67254,inst_67255);
var inst_67257 = [inst_67256,(10)];
var inst_67258 = (new cljs.core.PersistentVector(null,2,(5),inst_67253,inst_67257,null));
var inst_67259 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67258);
var _ = (function (){var statearr_67277 = state_67264;
(statearr_67277[(4)] = cljs.core.rest((state_67264[(4)])));

return statearr_67277;
})();
var state_67264__$1 = (function (){var statearr_67278 = state_67264;
(statearr_67278[(7)] = inst_67259);

return statearr_67278;
})();
var statearr_67279_67293 = state_67264__$1;
(statearr_67279_67293[(2)] = inst_67252);

(statearr_67279_67293[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____0 = (function (){
var statearr_67280 = [null,null,null,null,null,null,null,null];
(statearr_67280[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__);

(statearr_67280[(1)] = (1));

return statearr_67280;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____1 = (function (state_67264){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67264);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67281){var ex__10753__auto__ = e67281;
var statearr_67282_67294 = state_67264;
(statearr_67282_67294[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67264[(4)]))){
var statearr_67283_67295 = state_67264;
(statearr_67283_67295[(1)] = cljs.core.first((state_67264[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67296 = state_67264;
state_67264 = G__67296;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__ = function(state_67264){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____1.call(this,state_67264);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67284 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67284[(6)] = c__10876__auto__);

return statearr_67284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67323){
var state_val_67324 = (state_67323[(1)]);
if((state_val_67324 === (7))){
var state_67323__$1 = state_67323;
var statearr_67325_67344 = state_67323__$1;
(statearr_67325_67344[(2)] = n);

(statearr_67325_67344[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (1))){
var state_67323__$1 = state_67323;
var statearr_67326_67345 = state_67323__$1;
(statearr_67326_67345[(2)] = null);

(statearr_67326_67345[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (4))){
var inst_67297 = (state_67323[(2)]);
var state_67323__$1 = state_67323;
var statearr_67327_67346 = state_67323__$1;
(statearr_67327_67346[(2)] = inst_67297);

(statearr_67327_67346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (6))){
var state_67323__$1 = state_67323;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67323__$1,(9),n);
} else {
if((state_val_67324 === (3))){
var inst_67321 = (state_67323[(2)]);
var state_67323__$1 = state_67323;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67323__$1,inst_67321);
} else {
if((state_val_67324 === (2))){
var _ = (function (){var statearr_67329 = state_67323;
(statearr_67329[(4)] = cljs.core.cons((5),(state_67323[(4)])));

return statearr_67329;
})();
var inst_67303 = fluree.db.util.async.channel_QMARK_(n);
var state_67323__$1 = state_67323;
if(inst_67303){
var statearr_67330_67347 = state_67323__$1;
(statearr_67330_67347[(1)] = (6));

} else {
var statearr_67331_67348 = state_67323__$1;
(statearr_67331_67348[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (9))){
var inst_67306 = (state_67323[(2)]);
var inst_67307 = fluree.db.util.async.throw_err(inst_67306);
var state_67323__$1 = state_67323;
var statearr_67332_67349 = state_67323__$1;
(statearr_67332_67349[(2)] = inst_67307);

(statearr_67332_67349[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (5))){
var _ = (function (){var statearr_67333 = state_67323;
(statearr_67333[(4)] = cljs.core.rest((state_67323[(4)])));

return statearr_67333;
})();
var state_67323__$1 = state_67323;
var ex67328 = (state_67323__$1[(2)]);
var statearr_67334_67350 = state_67323__$1;
(statearr_67334_67350[(5)] = ex67328);


if((ex67328 instanceof Error)){
var statearr_67335_67351 = state_67323__$1;
(statearr_67335_67351[(1)] = (4));

(statearr_67335_67351[(5)] = null);

} else {
throw ex67328;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67324 === (8))){
var inst_67310 = (state_67323[(2)]);
var inst_67311 = fluree.db.dbfunctions.internal.dec(inst_67310);
var inst_67312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67313 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67314 = ["dec",inst_67310,inst_67311];
var inst_67315 = cljs.core.PersistentHashMap.fromArrays(inst_67313,inst_67314);
var inst_67316 = [inst_67315,(10)];
var inst_67317 = (new cljs.core.PersistentVector(null,2,(5),inst_67312,inst_67316,null));
var inst_67318 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67317);
var _ = (function (){var statearr_67336 = state_67323;
(statearr_67336[(4)] = cljs.core.rest((state_67323[(4)])));

return statearr_67336;
})();
var state_67323__$1 = (function (){var statearr_67337 = state_67323;
(statearr_67337[(7)] = inst_67318);

return statearr_67337;
})();
var statearr_67338_67352 = state_67323__$1;
(statearr_67338_67352[(2)] = inst_67311);

(statearr_67338_67352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____0 = (function (){
var statearr_67339 = [null,null,null,null,null,null,null,null];
(statearr_67339[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__);

(statearr_67339[(1)] = (1));

return statearr_67339;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____1 = (function (state_67323){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67323);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67340){var ex__10753__auto__ = e67340;
var statearr_67341_67353 = state_67323;
(statearr_67341_67353[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67323[(4)]))){
var statearr_67342_67354 = state_67323;
(statearr_67342_67354[(1)] = cljs.core.first((state_67323[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67355 = state_67323;
state_67323 = G__67355;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__ = function(state_67323){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____1.call(this,state_67323);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67343 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67343[(6)] = c__10876__auto__);

return statearr_67343;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___67405 = arguments.length;
var i__4819__auto___67406 = (0);
while(true){
if((i__4819__auto___67406 < len__4818__auto___67405)){
args__4824__auto__.push((arguments[i__4819__auto___67406]));

var G__67407 = (i__4819__auto___67406 + (1));
i__4819__auto___67406 = G__67407;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67388){
var state_val_67389 = (state_67388[(1)]);
if((state_val_67389 === (1))){
var state_67388__$1 = state_67388;
var statearr_67390_67408 = state_67388__$1;
(statearr_67390_67408[(2)] = null);

(statearr_67390_67408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67389 === (2))){
var _ = (function (){var statearr_67391 = state_67388;
(statearr_67391[(4)] = cljs.core.cons((5),(state_67388[(4)])));

return statearr_67391;
})();
var inst_67364 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67388__$1 = state_67388;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67388__$1,(6),inst_67364);
} else {
if((state_val_67389 === (3))){
var inst_67386 = (state_67388[(2)]);
var state_67388__$1 = state_67388;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67388__$1,inst_67386);
} else {
if((state_val_67389 === (4))){
var inst_67358 = (state_67388[(2)]);
var state_67388__$1 = state_67388;
var statearr_67393_67409 = state_67388__$1;
(statearr_67393_67409[(2)] = inst_67358);

(statearr_67393_67409[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67389 === (5))){
var _ = (function (){var statearr_67394 = state_67388;
(statearr_67394[(4)] = cljs.core.rest((state_67388[(4)])));

return statearr_67394;
})();
var state_67388__$1 = state_67388;
var ex67392 = (state_67388__$1[(2)]);
var statearr_67395_67410 = state_67388__$1;
(statearr_67395_67410[(5)] = ex67392);


if((ex67392 instanceof Error)){
var statearr_67396_67411 = state_67388__$1;
(statearr_67396_67411[(1)] = (4));

(statearr_67396_67411[(5)] = null);

} else {
throw ex67392;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67389 === (6))){
var inst_67366 = (state_67388[(2)]);
var inst_67367 = fluree.db.util.async.throw_err(inst_67366);
var inst_67368 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_67367);
var inst_67369 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67370 = [inst_67367];
var inst_67371 = (new cljs.core.PersistentVector(null,1,(5),inst_67369,inst_67370,null));
var inst_67372 = cljs.core.count(inst_67371);
var inst_67373 = ((9) + inst_67372);
var inst_67374 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67375 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67377 = [inst_67367];
var inst_67378 = (new cljs.core.PersistentVector(null,1,(5),inst_67376,inst_67377,null));
var inst_67379 = ["+",inst_67378,inst_67368];
var inst_67380 = cljs.core.PersistentHashMap.fromArrays(inst_67375,inst_67379);
var inst_67381 = [inst_67380,inst_67373];
var inst_67382 = (new cljs.core.PersistentVector(null,2,(5),inst_67374,inst_67381,null));
var inst_67383 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67382);
var _ = (function (){var statearr_67397 = state_67388;
(statearr_67397[(4)] = cljs.core.rest((state_67388[(4)])));

return statearr_67397;
})();
var state_67388__$1 = (function (){var statearr_67398 = state_67388;
(statearr_67398[(7)] = inst_67383);

return statearr_67398;
})();
var statearr_67399_67412 = state_67388__$1;
(statearr_67399_67412[(2)] = inst_67368);

(statearr_67399_67412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_67400 = [null,null,null,null,null,null,null,null];
(statearr_67400[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_67400[(1)] = (1));

return statearr_67400;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_67388){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67388);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67401){var ex__10753__auto__ = e67401;
var statearr_67402_67413 = state_67388;
(statearr_67402_67413[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67388[(4)]))){
var statearr_67403_67414 = state_67388;
(statearr_67403_67414[(1)] = cljs.core.first((state_67388[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67415 = state_67388;
state_67388 = G__67415;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_67388){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_67388);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67404 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67404[(6)] = c__10876__auto__);

return statearr_67404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq67356){
var G__67357 = cljs.core.first(seq67356);
var seq67356__$1 = cljs.core.next(seq67356);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67357,seq67356__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___67465 = arguments.length;
var i__4819__auto___67466 = (0);
while(true){
if((i__4819__auto___67466 < len__4818__auto___67465)){
args__4824__auto__.push((arguments[i__4819__auto___67466]));

var G__67467 = (i__4819__auto___67466 + (1));
i__4819__auto___67466 = G__67467;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67448){
var state_val_67449 = (state_67448[(1)]);
if((state_val_67449 === (1))){
var state_67448__$1 = state_67448;
var statearr_67450_67468 = state_67448__$1;
(statearr_67450_67468[(2)] = null);

(statearr_67450_67468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67449 === (2))){
var _ = (function (){var statearr_67451 = state_67448;
(statearr_67451[(4)] = cljs.core.cons((5),(state_67448[(4)])));

return statearr_67451;
})();
var inst_67424 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67448__$1 = state_67448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67448__$1,(6),inst_67424);
} else {
if((state_val_67449 === (3))){
var inst_67446 = (state_67448[(2)]);
var state_67448__$1 = state_67448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67448__$1,inst_67446);
} else {
if((state_val_67449 === (4))){
var inst_67418 = (state_67448[(2)]);
var state_67448__$1 = state_67448;
var statearr_67453_67469 = state_67448__$1;
(statearr_67453_67469[(2)] = inst_67418);

(statearr_67453_67469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67449 === (5))){
var _ = (function (){var statearr_67454 = state_67448;
(statearr_67454[(4)] = cljs.core.rest((state_67448[(4)])));

return statearr_67454;
})();
var state_67448__$1 = state_67448;
var ex67452 = (state_67448__$1[(2)]);
var statearr_67455_67470 = state_67448__$1;
(statearr_67455_67470[(5)] = ex67452);


if((ex67452 instanceof Error)){
var statearr_67456_67471 = state_67448__$1;
(statearr_67456_67471[(1)] = (4));

(statearr_67456_67471[(5)] = null);

} else {
throw ex67452;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67449 === (6))){
var inst_67426 = (state_67448[(2)]);
var inst_67427 = fluree.db.util.async.throw_err(inst_67426);
var inst_67428 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_67427);
var inst_67429 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67430 = [inst_67427];
var inst_67431 = (new cljs.core.PersistentVector(null,1,(5),inst_67429,inst_67430,null));
var inst_67432 = cljs.core.count(inst_67431);
var inst_67433 = ((9) + inst_67432);
var inst_67434 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67435 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67436 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67437 = [inst_67427];
var inst_67438 = (new cljs.core.PersistentVector(null,1,(5),inst_67436,inst_67437,null));
var inst_67439 = ["-",inst_67438,inst_67428];
var inst_67440 = cljs.core.PersistentHashMap.fromArrays(inst_67435,inst_67439);
var inst_67441 = [inst_67440,inst_67433];
var inst_67442 = (new cljs.core.PersistentVector(null,2,(5),inst_67434,inst_67441,null));
var inst_67443 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67442);
var _ = (function (){var statearr_67457 = state_67448;
(statearr_67457[(4)] = cljs.core.rest((state_67448[(4)])));

return statearr_67457;
})();
var state_67448__$1 = (function (){var statearr_67458 = state_67448;
(statearr_67458[(7)] = inst_67443);

return statearr_67458;
})();
var statearr_67459_67472 = state_67448__$1;
(statearr_67459_67472[(2)] = inst_67428);

(statearr_67459_67472[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_67460 = [null,null,null,null,null,null,null,null];
(statearr_67460[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_67460[(1)] = (1));

return statearr_67460;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_67448){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67448);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67461){var ex__10753__auto__ = e67461;
var statearr_67462_67473 = state_67448;
(statearr_67462_67473[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67448[(4)]))){
var statearr_67463_67474 = state_67448;
(statearr_67463_67474[(1)] = cljs.core.first((state_67448[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67475 = state_67448;
state_67448 = G__67475;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_67448){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_67448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67464 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67464[(6)] = c__10876__auto__);

return statearr_67464;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq67416){
var G__67417 = cljs.core.first(seq67416);
var seq67416__$1 = cljs.core.next(seq67416);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67417,seq67416__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___67525 = arguments.length;
var i__4819__auto___67526 = (0);
while(true){
if((i__4819__auto___67526 < len__4818__auto___67525)){
args__4824__auto__.push((arguments[i__4819__auto___67526]));

var G__67527 = (i__4819__auto___67526 + (1));
i__4819__auto___67526 = G__67527;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67508){
var state_val_67509 = (state_67508[(1)]);
if((state_val_67509 === (1))){
var state_67508__$1 = state_67508;
var statearr_67510_67528 = state_67508__$1;
(statearr_67510_67528[(2)] = null);

(statearr_67510_67528[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67509 === (2))){
var _ = (function (){var statearr_67511 = state_67508;
(statearr_67511[(4)] = cljs.core.cons((5),(state_67508[(4)])));

return statearr_67511;
})();
var inst_67484 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67508__$1 = state_67508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67508__$1,(6),inst_67484);
} else {
if((state_val_67509 === (3))){
var inst_67506 = (state_67508[(2)]);
var state_67508__$1 = state_67508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67508__$1,inst_67506);
} else {
if((state_val_67509 === (4))){
var inst_67478 = (state_67508[(2)]);
var state_67508__$1 = state_67508;
var statearr_67513_67529 = state_67508__$1;
(statearr_67513_67529[(2)] = inst_67478);

(statearr_67513_67529[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67509 === (5))){
var _ = (function (){var statearr_67514 = state_67508;
(statearr_67514[(4)] = cljs.core.rest((state_67508[(4)])));

return statearr_67514;
})();
var state_67508__$1 = state_67508;
var ex67512 = (state_67508__$1[(2)]);
var statearr_67515_67530 = state_67508__$1;
(statearr_67515_67530[(5)] = ex67512);


if((ex67512 instanceof Error)){
var statearr_67516_67531 = state_67508__$1;
(statearr_67516_67531[(1)] = (4));

(statearr_67516_67531[(5)] = null);

} else {
throw ex67512;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67509 === (6))){
var inst_67486 = (state_67508[(2)]);
var inst_67487 = fluree.db.util.async.throw_err(inst_67486);
var inst_67488 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_67487);
var inst_67489 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67490 = [inst_67487];
var inst_67491 = (new cljs.core.PersistentVector(null,1,(5),inst_67489,inst_67490,null));
var inst_67492 = cljs.core.count(inst_67491);
var inst_67493 = ((9) + inst_67492);
var inst_67494 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67495 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67496 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67497 = [inst_67487];
var inst_67498 = (new cljs.core.PersistentVector(null,1,(5),inst_67496,inst_67497,null));
var inst_67499 = ["*",inst_67498,inst_67488];
var inst_67500 = cljs.core.PersistentHashMap.fromArrays(inst_67495,inst_67499);
var inst_67501 = [inst_67500,inst_67493];
var inst_67502 = (new cljs.core.PersistentVector(null,2,(5),inst_67494,inst_67501,null));
var inst_67503 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67502);
var _ = (function (){var statearr_67517 = state_67508;
(statearr_67517[(4)] = cljs.core.rest((state_67508[(4)])));

return statearr_67517;
})();
var state_67508__$1 = (function (){var statearr_67518 = state_67508;
(statearr_67518[(7)] = inst_67503);

return statearr_67518;
})();
var statearr_67519_67532 = state_67508__$1;
(statearr_67519_67532[(2)] = inst_67488);

(statearr_67519_67532[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_67520 = [null,null,null,null,null,null,null,null];
(statearr_67520[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_67520[(1)] = (1));

return statearr_67520;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_67508){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67508);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67521){var ex__10753__auto__ = e67521;
var statearr_67522_67533 = state_67508;
(statearr_67522_67533[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67508[(4)]))){
var statearr_67523_67534 = state_67508;
(statearr_67523_67534[(1)] = cljs.core.first((state_67508[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67535 = state_67508;
state_67508 = G__67535;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_67508){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_67508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67524 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67524[(6)] = c__10876__auto__);

return statearr_67524;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq67476){
var G__67477 = cljs.core.first(seq67476);
var seq67476__$1 = cljs.core.next(seq67476);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67477,seq67476__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___67585 = arguments.length;
var i__4819__auto___67586 = (0);
while(true){
if((i__4819__auto___67586 < len__4818__auto___67585)){
args__4824__auto__.push((arguments[i__4819__auto___67586]));

var G__67587 = (i__4819__auto___67586 + (1));
i__4819__auto___67586 = G__67587;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67568){
var state_val_67569 = (state_67568[(1)]);
if((state_val_67569 === (1))){
var state_67568__$1 = state_67568;
var statearr_67570_67588 = state_67568__$1;
(statearr_67570_67588[(2)] = null);

(statearr_67570_67588[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67569 === (2))){
var _ = (function (){var statearr_67571 = state_67568;
(statearr_67571[(4)] = cljs.core.cons((5),(state_67568[(4)])));

return statearr_67571;
})();
var inst_67544 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_67568__$1 = state_67568;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67568__$1,(6),inst_67544);
} else {
if((state_val_67569 === (3))){
var inst_67566 = (state_67568[(2)]);
var state_67568__$1 = state_67568;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67568__$1,inst_67566);
} else {
if((state_val_67569 === (4))){
var inst_67538 = (state_67568[(2)]);
var state_67568__$1 = state_67568;
var statearr_67573_67589 = state_67568__$1;
(statearr_67573_67589[(2)] = inst_67538);

(statearr_67573_67589[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67569 === (5))){
var _ = (function (){var statearr_67574 = state_67568;
(statearr_67574[(4)] = cljs.core.rest((state_67568[(4)])));

return statearr_67574;
})();
var state_67568__$1 = state_67568;
var ex67572 = (state_67568__$1[(2)]);
var statearr_67575_67590 = state_67568__$1;
(statearr_67575_67590[(5)] = ex67572);


if((ex67572 instanceof Error)){
var statearr_67576_67591 = state_67568__$1;
(statearr_67576_67591[(1)] = (4));

(statearr_67576_67591[(5)] = null);

} else {
throw ex67572;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67569 === (6))){
var inst_67546 = (state_67568[(2)]);
var inst_67547 = fluree.db.util.async.throw_err(inst_67546);
var inst_67548 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_67547);
var inst_67549 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67550 = [inst_67547];
var inst_67551 = (new cljs.core.PersistentVector(null,1,(5),inst_67549,inst_67550,null));
var inst_67552 = cljs.core.count(inst_67551);
var inst_67553 = ((9) + inst_67552);
var inst_67554 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67555 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67556 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67557 = [inst_67547];
var inst_67558 = (new cljs.core.PersistentVector(null,1,(5),inst_67556,inst_67557,null));
var inst_67559 = ["/",inst_67558,inst_67548];
var inst_67560 = cljs.core.PersistentHashMap.fromArrays(inst_67555,inst_67559);
var inst_67561 = [inst_67560,inst_67553];
var inst_67562 = (new cljs.core.PersistentVector(null,2,(5),inst_67554,inst_67561,null));
var inst_67563 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67562);
var _ = (function (){var statearr_67577 = state_67568;
(statearr_67577[(4)] = cljs.core.rest((state_67568[(4)])));

return statearr_67577;
})();
var state_67568__$1 = (function (){var statearr_67578 = state_67568;
(statearr_67578[(7)] = inst_67563);

return statearr_67578;
})();
var statearr_67579_67592 = state_67568__$1;
(statearr_67579_67592[(2)] = inst_67548);

(statearr_67579_67592[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_67580 = [null,null,null,null,null,null,null,null];
(statearr_67580[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_67580[(1)] = (1));

return statearr_67580;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_67568){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67568);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67581){var ex__10753__auto__ = e67581;
var statearr_67582_67593 = state_67568;
(statearr_67582_67593[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67568[(4)]))){
var statearr_67583_67594 = state_67568;
(statearr_67583_67594[(1)] = cljs.core.first((state_67568[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67595 = state_67568;
state_67568 = G__67595;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_67568){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_67568);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67584 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67584[(6)] = c__10876__auto__);

return statearr_67584;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq67536){
var G__67537 = cljs.core.first(seq67536);
var seq67536__$1 = cljs.core.next(seq67536);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__67537,seq67536__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67633){
var state_val_67634 = (state_67633[(1)]);
if((state_val_67634 === (7))){
var state_67633__$1 = state_67633;
var statearr_67635_67659 = state_67633__$1;
(statearr_67635_67659[(2)] = n);

(statearr_67635_67659[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (1))){
var state_67633__$1 = state_67633;
var statearr_67636_67660 = state_67633__$1;
(statearr_67636_67660[(2)] = null);

(statearr_67636_67660[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (4))){
var inst_67596 = (state_67633[(2)]);
var state_67633__$1 = state_67633;
var statearr_67637_67661 = state_67633__$1;
(statearr_67637_67661[(2)] = inst_67596);

(statearr_67637_67661[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (13))){
var inst_67613 = (state_67633[(2)]);
var inst_67614 = fluree.db.util.async.throw_err(inst_67613);
var state_67633__$1 = state_67633;
var statearr_67638_67662 = state_67633__$1;
(statearr_67638_67662[(2)] = inst_67614);

(statearr_67638_67662[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (6))){
var state_67633__$1 = state_67633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67633__$1,(9),n);
} else {
if((state_val_67634 === (3))){
var inst_67631 = (state_67633[(2)]);
var state_67633__$1 = state_67633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67633__$1,inst_67631);
} else {
if((state_val_67634 === (12))){
var inst_67609 = (state_67633[(7)]);
var inst_67617 = (state_67633[(2)]);
var inst_67618 = fluree.db.dbfunctions.internal.quot(inst_67609,inst_67617);
var inst_67619 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67620 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67622 = [inst_67609,inst_67617];
var inst_67623 = (new cljs.core.PersistentVector(null,2,(5),inst_67621,inst_67622,null));
var inst_67624 = ["quot",inst_67623,inst_67618];
var inst_67625 = cljs.core.PersistentHashMap.fromArrays(inst_67620,inst_67624);
var inst_67626 = [inst_67625,(2)];
var inst_67627 = (new cljs.core.PersistentVector(null,2,(5),inst_67619,inst_67626,null));
var inst_67628 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67627);
var _ = (function (){var statearr_67639 = state_67633;
(statearr_67639[(4)] = cljs.core.rest((state_67633[(4)])));

return statearr_67639;
})();
var state_67633__$1 = (function (){var statearr_67640 = state_67633;
(statearr_67640[(8)] = inst_67628);

return statearr_67640;
})();
var statearr_67641_67663 = state_67633__$1;
(statearr_67641_67663[(2)] = inst_67618);

(statearr_67641_67663[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (2))){
var _ = (function (){var statearr_67642 = state_67633;
(statearr_67642[(4)] = cljs.core.cons((5),(state_67633[(4)])));

return statearr_67642;
})();
var inst_67602 = fluree.db.util.async.channel_QMARK_(n);
var state_67633__$1 = state_67633;
if(inst_67602){
var statearr_67643_67664 = state_67633__$1;
(statearr_67643_67664[(1)] = (6));

} else {
var statearr_67644_67665 = state_67633__$1;
(statearr_67644_67665[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (11))){
var state_67633__$1 = state_67633;
var statearr_67646_67666 = state_67633__$1;
(statearr_67646_67666[(2)] = d);

(statearr_67646_67666[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (9))){
var inst_67605 = (state_67633[(2)]);
var inst_67606 = fluree.db.util.async.throw_err(inst_67605);
var state_67633__$1 = state_67633;
var statearr_67647_67667 = state_67633__$1;
(statearr_67647_67667[(2)] = inst_67606);

(statearr_67647_67667[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (5))){
var _ = (function (){var statearr_67648 = state_67633;
(statearr_67648[(4)] = cljs.core.rest((state_67633[(4)])));

return statearr_67648;
})();
var state_67633__$1 = state_67633;
var ex67645 = (state_67633__$1[(2)]);
var statearr_67649_67668 = state_67633__$1;
(statearr_67649_67668[(5)] = ex67645);


if((ex67645 instanceof Error)){
var statearr_67650_67669 = state_67633__$1;
(statearr_67650_67669[(1)] = (4));

(statearr_67650_67669[(5)] = null);

} else {
throw ex67645;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67634 === (10))){
var state_67633__$1 = state_67633;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67633__$1,(13),d);
} else {
if((state_val_67634 === (8))){
var inst_67609 = (state_67633[(2)]);
var inst_67610 = fluree.db.util.async.channel_QMARK_(d);
var state_67633__$1 = (function (){var statearr_67651 = state_67633;
(statearr_67651[(7)] = inst_67609);

return statearr_67651;
})();
if(inst_67610){
var statearr_67652_67670 = state_67633__$1;
(statearr_67652_67670[(1)] = (10));

} else {
var statearr_67653_67671 = state_67633__$1;
(statearr_67653_67671[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____0 = (function (){
var statearr_67654 = [null,null,null,null,null,null,null,null,null];
(statearr_67654[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__);

(statearr_67654[(1)] = (1));

return statearr_67654;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____1 = (function (state_67633){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67633);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67655){var ex__10753__auto__ = e67655;
var statearr_67656_67672 = state_67633;
(statearr_67656_67672[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67633[(4)]))){
var statearr_67657_67673 = state_67633;
(statearr_67657_67673[(1)] = cljs.core.first((state_67633[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67674 = state_67633;
state_67633 = G__67674;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__ = function(state_67633){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____1.call(this,state_67633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67658 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67658[(6)] = c__10876__auto__);

return statearr_67658;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67712){
var state_val_67713 = (state_67712[(1)]);
if((state_val_67713 === (7))){
var state_67712__$1 = state_67712;
var statearr_67714_67738 = state_67712__$1;
(statearr_67714_67738[(2)] = n);

(statearr_67714_67738[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (1))){
var state_67712__$1 = state_67712;
var statearr_67715_67739 = state_67712__$1;
(statearr_67715_67739[(2)] = null);

(statearr_67715_67739[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (4))){
var inst_67675 = (state_67712[(2)]);
var state_67712__$1 = state_67712;
var statearr_67716_67740 = state_67712__$1;
(statearr_67716_67740[(2)] = inst_67675);

(statearr_67716_67740[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (13))){
var inst_67692 = (state_67712[(2)]);
var inst_67693 = fluree.db.util.async.throw_err(inst_67692);
var state_67712__$1 = state_67712;
var statearr_67717_67741 = state_67712__$1;
(statearr_67717_67741[(2)] = inst_67693);

(statearr_67717_67741[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (6))){
var state_67712__$1 = state_67712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67712__$1,(9),n);
} else {
if((state_val_67713 === (3))){
var inst_67710 = (state_67712[(2)]);
var state_67712__$1 = state_67712;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67712__$1,inst_67710);
} else {
if((state_val_67713 === (12))){
var inst_67688 = (state_67712[(7)]);
var inst_67696 = (state_67712[(2)]);
var inst_67697 = fluree.db.dbfunctions.internal.mod(inst_67688,inst_67696);
var inst_67698 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67699 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67700 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67701 = [inst_67688,inst_67696];
var inst_67702 = (new cljs.core.PersistentVector(null,2,(5),inst_67700,inst_67701,null));
var inst_67703 = ["mod",inst_67702,inst_67697];
var inst_67704 = cljs.core.PersistentHashMap.fromArrays(inst_67699,inst_67703);
var inst_67705 = [inst_67704,(2)];
var inst_67706 = (new cljs.core.PersistentVector(null,2,(5),inst_67698,inst_67705,null));
var inst_67707 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67706);
var _ = (function (){var statearr_67718 = state_67712;
(statearr_67718[(4)] = cljs.core.rest((state_67712[(4)])));

return statearr_67718;
})();
var state_67712__$1 = (function (){var statearr_67719 = state_67712;
(statearr_67719[(8)] = inst_67707);

return statearr_67719;
})();
var statearr_67720_67742 = state_67712__$1;
(statearr_67720_67742[(2)] = inst_67697);

(statearr_67720_67742[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (2))){
var _ = (function (){var statearr_67721 = state_67712;
(statearr_67721[(4)] = cljs.core.cons((5),(state_67712[(4)])));

return statearr_67721;
})();
var inst_67681 = fluree.db.util.async.channel_QMARK_(n);
var state_67712__$1 = state_67712;
if(inst_67681){
var statearr_67722_67743 = state_67712__$1;
(statearr_67722_67743[(1)] = (6));

} else {
var statearr_67723_67744 = state_67712__$1;
(statearr_67723_67744[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (11))){
var state_67712__$1 = state_67712;
var statearr_67725_67745 = state_67712__$1;
(statearr_67725_67745[(2)] = d);

(statearr_67725_67745[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (9))){
var inst_67684 = (state_67712[(2)]);
var inst_67685 = fluree.db.util.async.throw_err(inst_67684);
var state_67712__$1 = state_67712;
var statearr_67726_67746 = state_67712__$1;
(statearr_67726_67746[(2)] = inst_67685);

(statearr_67726_67746[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (5))){
var _ = (function (){var statearr_67727 = state_67712;
(statearr_67727[(4)] = cljs.core.rest((state_67712[(4)])));

return statearr_67727;
})();
var state_67712__$1 = state_67712;
var ex67724 = (state_67712__$1[(2)]);
var statearr_67728_67747 = state_67712__$1;
(statearr_67728_67747[(5)] = ex67724);


if((ex67724 instanceof Error)){
var statearr_67729_67748 = state_67712__$1;
(statearr_67729_67748[(1)] = (4));

(statearr_67729_67748[(5)] = null);

} else {
throw ex67724;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67713 === (10))){
var state_67712__$1 = state_67712;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67712__$1,(13),d);
} else {
if((state_val_67713 === (8))){
var inst_67688 = (state_67712[(2)]);
var inst_67689 = fluree.db.util.async.channel_QMARK_(d);
var state_67712__$1 = (function (){var statearr_67730 = state_67712;
(statearr_67730[(7)] = inst_67688);

return statearr_67730;
})();
if(inst_67689){
var statearr_67731_67749 = state_67712__$1;
(statearr_67731_67749[(1)] = (10));

} else {
var statearr_67732_67750 = state_67712__$1;
(statearr_67732_67750[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____0 = (function (){
var statearr_67733 = [null,null,null,null,null,null,null,null,null];
(statearr_67733[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__);

(statearr_67733[(1)] = (1));

return statearr_67733;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____1 = (function (state_67712){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67712);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67734){var ex__10753__auto__ = e67734;
var statearr_67735_67751 = state_67712;
(statearr_67735_67751[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67712[(4)]))){
var statearr_67736_67752 = state_67712;
(statearr_67736_67752[(1)] = cljs.core.first((state_67712[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67753 = state_67712;
state_67712 = G__67753;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__ = function(state_67712){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____1.call(this,state_67712);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67737 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67737[(6)] = c__10876__auto__);

return statearr_67737;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67791){
var state_val_67792 = (state_67791[(1)]);
if((state_val_67792 === (7))){
var state_67791__$1 = state_67791;
var statearr_67793_67817 = state_67791__$1;
(statearr_67793_67817[(2)] = n);

(statearr_67793_67817[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (1))){
var state_67791__$1 = state_67791;
var statearr_67794_67818 = state_67791__$1;
(statearr_67794_67818[(2)] = null);

(statearr_67794_67818[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (4))){
var inst_67754 = (state_67791[(2)]);
var state_67791__$1 = state_67791;
var statearr_67795_67819 = state_67791__$1;
(statearr_67795_67819[(2)] = inst_67754);

(statearr_67795_67819[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (13))){
var inst_67771 = (state_67791[(2)]);
var inst_67772 = fluree.db.util.async.throw_err(inst_67771);
var state_67791__$1 = state_67791;
var statearr_67796_67820 = state_67791__$1;
(statearr_67796_67820[(2)] = inst_67772);

(statearr_67796_67820[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (6))){
var state_67791__$1 = state_67791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67791__$1,(9),n);
} else {
if((state_val_67792 === (3))){
var inst_67789 = (state_67791[(2)]);
var state_67791__$1 = state_67791;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67791__$1,inst_67789);
} else {
if((state_val_67792 === (12))){
var inst_67767 = (state_67791[(7)]);
var inst_67775 = (state_67791[(2)]);
var inst_67776 = fluree.db.dbfunctions.internal.rem(inst_67767,inst_67775);
var inst_67777 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67778 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67779 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67780 = [inst_67767,inst_67775];
var inst_67781 = (new cljs.core.PersistentVector(null,2,(5),inst_67779,inst_67780,null));
var inst_67782 = ["rem",inst_67781,inst_67776];
var inst_67783 = cljs.core.PersistentHashMap.fromArrays(inst_67778,inst_67782);
var inst_67784 = [inst_67783,(2)];
var inst_67785 = (new cljs.core.PersistentVector(null,2,(5),inst_67777,inst_67784,null));
var inst_67786 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67785);
var _ = (function (){var statearr_67797 = state_67791;
(statearr_67797[(4)] = cljs.core.rest((state_67791[(4)])));

return statearr_67797;
})();
var state_67791__$1 = (function (){var statearr_67798 = state_67791;
(statearr_67798[(8)] = inst_67786);

return statearr_67798;
})();
var statearr_67799_67821 = state_67791__$1;
(statearr_67799_67821[(2)] = inst_67776);

(statearr_67799_67821[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (2))){
var _ = (function (){var statearr_67800 = state_67791;
(statearr_67800[(4)] = cljs.core.cons((5),(state_67791[(4)])));

return statearr_67800;
})();
var inst_67760 = fluree.db.util.async.channel_QMARK_(n);
var state_67791__$1 = state_67791;
if(inst_67760){
var statearr_67801_67822 = state_67791__$1;
(statearr_67801_67822[(1)] = (6));

} else {
var statearr_67802_67823 = state_67791__$1;
(statearr_67802_67823[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (11))){
var state_67791__$1 = state_67791;
var statearr_67804_67824 = state_67791__$1;
(statearr_67804_67824[(2)] = d);

(statearr_67804_67824[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (9))){
var inst_67763 = (state_67791[(2)]);
var inst_67764 = fluree.db.util.async.throw_err(inst_67763);
var state_67791__$1 = state_67791;
var statearr_67805_67825 = state_67791__$1;
(statearr_67805_67825[(2)] = inst_67764);

(statearr_67805_67825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (5))){
var _ = (function (){var statearr_67806 = state_67791;
(statearr_67806[(4)] = cljs.core.rest((state_67791[(4)])));

return statearr_67806;
})();
var state_67791__$1 = state_67791;
var ex67803 = (state_67791__$1[(2)]);
var statearr_67807_67826 = state_67791__$1;
(statearr_67807_67826[(5)] = ex67803);


if((ex67803 instanceof Error)){
var statearr_67808_67827 = state_67791__$1;
(statearr_67808_67827[(1)] = (4));

(statearr_67808_67827[(5)] = null);

} else {
throw ex67803;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67792 === (10))){
var state_67791__$1 = state_67791;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67791__$1,(13),d);
} else {
if((state_val_67792 === (8))){
var inst_67767 = (state_67791[(2)]);
var inst_67768 = fluree.db.util.async.channel_QMARK_(d);
var state_67791__$1 = (function (){var statearr_67809 = state_67791;
(statearr_67809[(7)] = inst_67767);

return statearr_67809;
})();
if(inst_67768){
var statearr_67810_67828 = state_67791__$1;
(statearr_67810_67828[(1)] = (10));

} else {
var statearr_67811_67829 = state_67791__$1;
(statearr_67811_67829[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____0 = (function (){
var statearr_67812 = [null,null,null,null,null,null,null,null,null];
(statearr_67812[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__);

(statearr_67812[(1)] = (1));

return statearr_67812;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____1 = (function (state_67791){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67791);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67813){var ex__10753__auto__ = e67813;
var statearr_67814_67830 = state_67791;
(statearr_67814_67830[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67791[(4)]))){
var statearr_67815_67831 = state_67791;
(statearr_67815_67831[(1)] = cljs.core.first((state_67791[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67832 = state_67791;
state_67791 = G__67832;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__ = function(state_67791){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____1.call(this,state_67791);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67816 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67816[(6)] = c__10876__auto__);

return statearr_67816;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67859){
var state_val_67860 = (state_67859[(1)]);
if((state_val_67860 === (7))){
var state_67859__$1 = state_67859;
var statearr_67861_67880 = state_67859__$1;
(statearr_67861_67880[(2)] = x);

(statearr_67861_67880[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (1))){
var state_67859__$1 = state_67859;
var statearr_67862_67881 = state_67859__$1;
(statearr_67862_67881[(2)] = null);

(statearr_67862_67881[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (4))){
var inst_67833 = (state_67859[(2)]);
var state_67859__$1 = state_67859;
var statearr_67863_67882 = state_67859__$1;
(statearr_67863_67882[(2)] = inst_67833);

(statearr_67863_67882[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (6))){
var state_67859__$1 = state_67859;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67859__$1,(9),x);
} else {
if((state_val_67860 === (3))){
var inst_67857 = (state_67859[(2)]);
var state_67859__$1 = state_67859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67859__$1,inst_67857);
} else {
if((state_val_67860 === (2))){
var _ = (function (){var statearr_67865 = state_67859;
(statearr_67865[(4)] = cljs.core.cons((5),(state_67859[(4)])));

return statearr_67865;
})();
var inst_67839 = fluree.db.util.async.channel_QMARK_(x);
var state_67859__$1 = state_67859;
if(inst_67839){
var statearr_67866_67883 = state_67859__$1;
(statearr_67866_67883[(1)] = (6));

} else {
var statearr_67867_67884 = state_67859__$1;
(statearr_67867_67884[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (9))){
var inst_67842 = (state_67859[(2)]);
var inst_67843 = fluree.db.util.async.throw_err(inst_67842);
var state_67859__$1 = state_67859;
var statearr_67868_67885 = state_67859__$1;
(statearr_67868_67885[(2)] = inst_67843);

(statearr_67868_67885[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (5))){
var _ = (function (){var statearr_67869 = state_67859;
(statearr_67869[(4)] = cljs.core.rest((state_67859[(4)])));

return statearr_67869;
})();
var state_67859__$1 = state_67859;
var ex67864 = (state_67859__$1[(2)]);
var statearr_67870_67886 = state_67859__$1;
(statearr_67870_67886[(5)] = ex67864);


if((ex67864 instanceof Error)){
var statearr_67871_67887 = state_67859__$1;
(statearr_67871_67887[(1)] = (4));

(statearr_67871_67887[(5)] = null);

} else {
throw ex67864;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67860 === (8))){
var inst_67846 = (state_67859[(2)]);
var inst_67847 = fluree.db.dbfunctions.internal.boolean$(inst_67846);
var inst_67848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67849 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67850 = ["boolean",inst_67846,inst_67847];
var inst_67851 = cljs.core.PersistentHashMap.fromArrays(inst_67849,inst_67850);
var inst_67852 = [inst_67851,(10)];
var inst_67853 = (new cljs.core.PersistentVector(null,2,(5),inst_67848,inst_67852,null));
var inst_67854 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67853);
var _ = (function (){var statearr_67872 = state_67859;
(statearr_67872[(4)] = cljs.core.rest((state_67859[(4)])));

return statearr_67872;
})();
var state_67859__$1 = (function (){var statearr_67873 = state_67859;
(statearr_67873[(7)] = inst_67854);

return statearr_67873;
})();
var statearr_67874_67888 = state_67859__$1;
(statearr_67874_67888[(2)] = inst_67847);

(statearr_67874_67888[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____0 = (function (){
var statearr_67875 = [null,null,null,null,null,null,null,null];
(statearr_67875[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__);

(statearr_67875[(1)] = (1));

return statearr_67875;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____1 = (function (state_67859){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67859);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67876){var ex__10753__auto__ = e67876;
var statearr_67877_67889 = state_67859;
(statearr_67877_67889[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67859[(4)]))){
var statearr_67878_67890 = state_67859;
(statearr_67878_67890[(1)] = cljs.core.first((state_67859[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67891 = state_67859;
state_67859 = G__67891;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__ = function(state_67859){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____1.call(this,state_67859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67879 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67879[(6)] = c__10876__auto__);

return statearr_67879;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67929){
var state_val_67930 = (state_67929[(1)]);
if((state_val_67930 === (7))){
var state_67929__$1 = state_67929;
var statearr_67931_67955 = state_67929__$1;
(statearr_67931_67955[(2)] = pattern);

(statearr_67931_67955[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (1))){
var state_67929__$1 = state_67929;
var statearr_67932_67956 = state_67929__$1;
(statearr_67932_67956[(2)] = null);

(statearr_67932_67956[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (4))){
var inst_67892 = (state_67929[(2)]);
var state_67929__$1 = state_67929;
var statearr_67933_67957 = state_67929__$1;
(statearr_67933_67957[(2)] = inst_67892);

(statearr_67933_67957[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (13))){
var inst_67909 = (state_67929[(2)]);
var inst_67910 = fluree.db.util.async.throw_err(inst_67909);
var state_67929__$1 = state_67929;
var statearr_67934_67958 = state_67929__$1;
(statearr_67934_67958[(2)] = inst_67910);

(statearr_67934_67958[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (6))){
var state_67929__$1 = state_67929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67929__$1,(9),pattern);
} else {
if((state_val_67930 === (3))){
var inst_67927 = (state_67929[(2)]);
var state_67929__$1 = state_67929;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67929__$1,inst_67927);
} else {
if((state_val_67930 === (12))){
var inst_67905 = (state_67929[(7)]);
var inst_67913 = (state_67929[(2)]);
var inst_67914 = fluree.db.dbfunctions.internal.re_find(inst_67905,inst_67913);
var inst_67915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67916 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67918 = [inst_67905,inst_67913];
var inst_67919 = (new cljs.core.PersistentVector(null,2,(5),inst_67917,inst_67918,null));
var inst_67920 = ["re-find",inst_67919,inst_67914];
var inst_67921 = cljs.core.PersistentHashMap.fromArrays(inst_67916,inst_67920);
var inst_67922 = [inst_67921,(10)];
var inst_67923 = (new cljs.core.PersistentVector(null,2,(5),inst_67915,inst_67922,null));
var inst_67924 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67923);
var _ = (function (){var statearr_67935 = state_67929;
(statearr_67935[(4)] = cljs.core.rest((state_67929[(4)])));

return statearr_67935;
})();
var state_67929__$1 = (function (){var statearr_67936 = state_67929;
(statearr_67936[(8)] = inst_67924);

return statearr_67936;
})();
var statearr_67937_67959 = state_67929__$1;
(statearr_67937_67959[(2)] = inst_67914);

(statearr_67937_67959[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (2))){
var _ = (function (){var statearr_67938 = state_67929;
(statearr_67938[(4)] = cljs.core.cons((5),(state_67929[(4)])));

return statearr_67938;
})();
var inst_67898 = fluree.db.util.async.channel_QMARK_(pattern);
var state_67929__$1 = state_67929;
if(inst_67898){
var statearr_67939_67960 = state_67929__$1;
(statearr_67939_67960[(1)] = (6));

} else {
var statearr_67940_67961 = state_67929__$1;
(statearr_67940_67961[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (11))){
var state_67929__$1 = state_67929;
var statearr_67942_67962 = state_67929__$1;
(statearr_67942_67962[(2)] = string);

(statearr_67942_67962[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (9))){
var inst_67901 = (state_67929[(2)]);
var inst_67902 = fluree.db.util.async.throw_err(inst_67901);
var state_67929__$1 = state_67929;
var statearr_67943_67963 = state_67929__$1;
(statearr_67943_67963[(2)] = inst_67902);

(statearr_67943_67963[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (5))){
var _ = (function (){var statearr_67944 = state_67929;
(statearr_67944[(4)] = cljs.core.rest((state_67929[(4)])));

return statearr_67944;
})();
var state_67929__$1 = state_67929;
var ex67941 = (state_67929__$1[(2)]);
var statearr_67945_67964 = state_67929__$1;
(statearr_67945_67964[(5)] = ex67941);


if((ex67941 instanceof Error)){
var statearr_67946_67965 = state_67929__$1;
(statearr_67946_67965[(1)] = (4));

(statearr_67946_67965[(5)] = null);

} else {
throw ex67941;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67930 === (10))){
var state_67929__$1 = state_67929;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67929__$1,(13),string);
} else {
if((state_val_67930 === (8))){
var inst_67905 = (state_67929[(2)]);
var inst_67906 = fluree.db.util.async.channel_QMARK_(string);
var state_67929__$1 = (function (){var statearr_67947 = state_67929;
(statearr_67947[(7)] = inst_67905);

return statearr_67947;
})();
if(inst_67906){
var statearr_67948_67966 = state_67929__$1;
(statearr_67948_67966[(1)] = (10));

} else {
var statearr_67949_67967 = state_67929__$1;
(statearr_67949_67967[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____0 = (function (){
var statearr_67950 = [null,null,null,null,null,null,null,null,null];
(statearr_67950[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__);

(statearr_67950[(1)] = (1));

return statearr_67950;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____1 = (function (state_67929){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67929);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e67951){var ex__10753__auto__ = e67951;
var statearr_67952_67968 = state_67929;
(statearr_67952_67968[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67929[(4)]))){
var statearr_67953_67969 = state_67929;
(statearr_67953_67969[(1)] = cljs.core.first((state_67929[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__67970 = state_67929;
state_67929 = G__67970;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__ = function(state_67929){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____1.call(this,state_67929);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_67954 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_67954[(6)] = c__10876__auto__);

return statearr_67954;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_67997){
var state_val_67998 = (state_67997[(1)]);
if((state_val_67998 === (7))){
var state_67997__$1 = state_67997;
var statearr_67999_68018 = state_67997__$1;
(statearr_67999_68018[(2)] = email);

(statearr_67999_68018[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (1))){
var state_67997__$1 = state_67997;
var statearr_68000_68019 = state_67997__$1;
(statearr_68000_68019[(2)] = null);

(statearr_68000_68019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (4))){
var inst_67971 = (state_67997[(2)]);
var state_67997__$1 = state_67997;
var statearr_68001_68020 = state_67997__$1;
(statearr_68001_68020[(2)] = inst_67971);

(statearr_68001_68020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (6))){
var state_67997__$1 = state_67997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_67997__$1,(9),email);
} else {
if((state_val_67998 === (3))){
var inst_67995 = (state_67997[(2)]);
var state_67997__$1 = state_67997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_67997__$1,inst_67995);
} else {
if((state_val_67998 === (2))){
var _ = (function (){var statearr_68003 = state_67997;
(statearr_68003[(4)] = cljs.core.cons((5),(state_67997[(4)])));

return statearr_68003;
})();
var inst_67977 = fluree.db.util.async.channel_QMARK_(email);
var state_67997__$1 = state_67997;
if(inst_67977){
var statearr_68004_68021 = state_67997__$1;
(statearr_68004_68021[(1)] = (6));

} else {
var statearr_68005_68022 = state_67997__$1;
(statearr_68005_68022[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (9))){
var inst_67980 = (state_67997[(2)]);
var inst_67981 = fluree.db.util.async.throw_err(inst_67980);
var state_67997__$1 = state_67997;
var statearr_68006_68023 = state_67997__$1;
(statearr_68006_68023[(2)] = inst_67981);

(statearr_68006_68023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (5))){
var _ = (function (){var statearr_68007 = state_67997;
(statearr_68007[(4)] = cljs.core.rest((state_67997[(4)])));

return statearr_68007;
})();
var state_67997__$1 = state_67997;
var ex68002 = (state_67997__$1[(2)]);
var statearr_68008_68024 = state_67997__$1;
(statearr_68008_68024[(5)] = ex68002);


if((ex68002 instanceof Error)){
var statearr_68009_68025 = state_67997__$1;
(statearr_68009_68025[(1)] = (4));

(statearr_68009_68025[(5)] = null);

} else {
throw ex68002;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_67998 === (8))){
var inst_67984 = (state_67997[(2)]);
var inst_67985 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_67984);
var inst_67986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_67987 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_67988 = ["re-find",inst_67984,inst_67985];
var inst_67989 = cljs.core.PersistentHashMap.fromArrays(inst_67987,inst_67988);
var inst_67990 = [inst_67989,(10)];
var inst_67991 = (new cljs.core.PersistentVector(null,2,(5),inst_67986,inst_67990,null));
var inst_67992 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_67991);
var _ = (function (){var statearr_68010 = state_67997;
(statearr_68010[(4)] = cljs.core.rest((state_67997[(4)])));

return statearr_68010;
})();
var state_67997__$1 = (function (){var statearr_68011 = state_67997;
(statearr_68011[(7)] = inst_67992);

return statearr_68011;
})();
var statearr_68012_68026 = state_67997__$1;
(statearr_68012_68026[(2)] = inst_67985);

(statearr_68012_68026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_68013 = [null,null,null,null,null,null,null,null];
(statearr_68013[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__);

(statearr_68013[(1)] = (1));

return statearr_68013;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____1 = (function (state_67997){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_67997);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68014){var ex__10753__auto__ = e68014;
var statearr_68015_68027 = state_67997;
(statearr_68015_68027[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_67997[(4)]))){
var statearr_68016_68028 = state_67997;
(statearr_68016_68028[(1)] = cljs.core.first((state_67997[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68029 = state_67997;
state_67997 = G__68029;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__ = function(state_67997){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____1.call(this,state_67997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68017 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68017[(6)] = c__10876__auto__);

return statearr_68017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68076){
var state_val_68077 = (state_68076[(1)]);
if((state_val_68077 === (7))){
var inst_68046 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68076__$1 = state_68076;
if(cljs.core.truth_(inst_68046)){
var statearr_68078_68105 = state_68076__$1;
(statearr_68078_68105[(1)] = (9));

} else {
var statearr_68079_68106 = state_68076__$1;
(statearr_68079_68106[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (1))){
var state_68076__$1 = state_68076;
var statearr_68080_68107 = state_68076__$1;
(statearr_68080_68107[(2)] = null);

(statearr_68080_68107[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (4))){
var inst_68030 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
var statearr_68081_68108 = state_68076__$1;
(statearr_68081_68108[(2)] = inst_68030);

(statearr_68081_68108[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (15))){
var inst_68057 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
var statearr_68082_68109 = state_68076__$1;
(statearr_68082_68109[(2)] = inst_68057);

(statearr_68082_68109[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (13))){
var inst_68054 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_68076__$1 = state_68076;
var statearr_68083_68110 = state_68076__$1;
(statearr_68083_68110[(2)] = inst_68054);

(statearr_68083_68110[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (6))){
var inst_68041 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68042 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_68043 = [inst_68042,(0)];
var inst_68044 = (new cljs.core.PersistentVector(null,2,(5),inst_68041,inst_68043,null));
var state_68076__$1 = state_68076;
var statearr_68084_68111 = state_68076__$1;
(statearr_68084_68111[(2)] = inst_68044);

(statearr_68084_68111[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (3))){
var inst_68074 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68076__$1,inst_68074);
} else {
if((state_val_68077 === (12))){
var inst_68050 = (state_68076[(2)]);
var inst_68051 = fluree.db.util.async.throw_err(inst_68050);
var state_68076__$1 = state_68076;
var statearr_68085_68112 = state_68076__$1;
(statearr_68085_68112[(2)] = inst_68051);

(statearr_68085_68112[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (2))){
var _ = (function (){var statearr_68086 = state_68076;
(statearr_68086[(4)] = cljs.core.cons((5),(state_68076[(4)])));

return statearr_68086;
})();
var inst_68039 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68076__$1 = state_68076;
if(cljs.core.truth_(inst_68039)){
var statearr_68087_68113 = state_68076__$1;
(statearr_68087_68113[(1)] = (6));

} else {
var statearr_68088_68114 = state_68076__$1;
(statearr_68088_68114[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (11))){
var inst_68059 = (state_68076[(2)]);
var state_68076__$1 = state_68076;
var statearr_68090_68115 = state_68076__$1;
(statearr_68090_68115[(2)] = inst_68059);

(statearr_68090_68115[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (9))){
var inst_68048 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_68076__$1 = state_68076;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68076__$1,(12),inst_68048);
} else {
if((state_val_68077 === (5))){
var _ = (function (){var statearr_68091 = state_68076;
(statearr_68091[(4)] = cljs.core.rest((state_68076[(4)])));

return statearr_68091;
})();
var state_68076__$1 = state_68076;
var ex68089 = (state_68076__$1[(2)]);
var statearr_68092_68116 = state_68076__$1;
(statearr_68092_68116[(5)] = ex68089);


if((ex68089 instanceof Error)){
var statearr_68093_68117 = state_68076__$1;
(statearr_68093_68117[(1)] = (4));

(statearr_68093_68117[(5)] = null);

} else {
throw ex68089;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (14))){
var state_68076__$1 = state_68076;
var statearr_68094_68118 = state_68076__$1;
(statearr_68094_68118[(2)] = null);

(statearr_68094_68118[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (10))){
var state_68076__$1 = state_68076;
var statearr_68095_68119 = state_68076__$1;
(statearr_68095_68119[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_68077 === (8))){
var inst_68061 = (state_68076[(2)]);
var inst_68062 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68061,(0),null);
var inst_68063 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_68061,(1),null);
var inst_68064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68065 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68066 = ["?user_id","?ctx",inst_68062];
var inst_68067 = cljs.core.PersistentHashMap.fromArrays(inst_68065,inst_68066);
var inst_68068 = ((10) + inst_68063);
var inst_68069 = [inst_68067,inst_68068];
var inst_68070 = (new cljs.core.PersistentVector(null,2,(5),inst_68064,inst_68069,null));
var inst_68071 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68070);
var _ = (function (){var statearr_68097 = state_68076;
(statearr_68097[(4)] = cljs.core.rest((state_68076[(4)])));

return statearr_68097;
})();
var state_68076__$1 = (function (){var statearr_68098 = state_68076;
(statearr_68098[(7)] = inst_68071);

return statearr_68098;
})();
var statearr_68099_68120 = state_68076__$1;
(statearr_68099_68120[(2)] = inst_68062);

(statearr_68099_68120[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____0 = (function (){
var statearr_68100 = [null,null,null,null,null,null,null,null];
(statearr_68100[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__);

(statearr_68100[(1)] = (1));

return statearr_68100;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____1 = (function (state_68076){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68076);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68101){var ex__10753__auto__ = e68101;
var statearr_68102_68121 = state_68076;
(statearr_68102_68121[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68076[(4)]))){
var statearr_68103_68122 = state_68076;
(statearr_68103_68122[(1)] = cljs.core.first((state_68076[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68123 = state_68076;
state_68076 = G__68123;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__ = function(state_68076){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____1.call(this,state_68076);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68104 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68104[(6)] = c__10876__auto__);

return statearr_68104;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68151){
var state_val_68152 = (state_68151[(1)]);
if((state_val_68152 === (7))){
var inst_68144 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_68151__$1 = state_68151;
var statearr_68153_68172 = state_68151__$1;
(statearr_68153_68172[(2)] = inst_68144);

(statearr_68153_68172[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (1))){
var state_68151__$1 = state_68151;
var statearr_68154_68173 = state_68151__$1;
(statearr_68154_68173[(2)] = null);

(statearr_68154_68173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (4))){
var inst_68124 = (state_68151[(2)]);
var state_68151__$1 = state_68151;
var statearr_68155_68174 = state_68151__$1;
(statearr_68155_68174[(2)] = inst_68124);

(statearr_68155_68174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (6))){
var inst_68132 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_68151__$1 = state_68151;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68151__$1,(9),inst_68132);
} else {
if((state_val_68152 === (3))){
var inst_68149 = (state_68151[(2)]);
var state_68151__$1 = state_68151;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68151__$1,inst_68149);
} else {
if((state_val_68152 === (2))){
var _ = (function (){var statearr_68157 = state_68151;
(statearr_68157[(4)] = cljs.core.cons((5),(state_68151[(4)])));

return statearr_68157;
})();
var inst_68130 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_68151__$1 = state_68151;
if(cljs.core.truth_(inst_68130)){
var statearr_68158_68175 = state_68151__$1;
(statearr_68158_68175[(1)] = (6));

} else {
var statearr_68159_68176 = state_68151__$1;
(statearr_68159_68176[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (9))){
var inst_68134 = (state_68151[(2)]);
var inst_68135 = fluree.db.util.async.throw_err(inst_68134);
var inst_68136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68137 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68138 = ["?auth_id","?ctx",inst_68135];
var inst_68139 = cljs.core.PersistentHashMap.fromArrays(inst_68137,inst_68138);
var inst_68140 = [inst_68139,(10)];
var inst_68141 = (new cljs.core.PersistentVector(null,2,(5),inst_68136,inst_68140,null));
var inst_68142 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68141);
var state_68151__$1 = (function (){var statearr_68160 = state_68151;
(statearr_68160[(7)] = inst_68142);

return statearr_68160;
})();
var statearr_68161_68177 = state_68151__$1;
(statearr_68161_68177[(2)] = inst_68135);

(statearr_68161_68177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (5))){
var _ = (function (){var statearr_68162 = state_68151;
(statearr_68162[(4)] = cljs.core.rest((state_68151[(4)])));

return statearr_68162;
})();
var state_68151__$1 = state_68151;
var ex68156 = (state_68151__$1[(2)]);
var statearr_68163_68178 = state_68151__$1;
(statearr_68163_68178[(5)] = ex68156);


if((ex68156 instanceof Error)){
var statearr_68164_68179 = state_68151__$1;
(statearr_68164_68179[(1)] = (4));

(statearr_68164_68179[(5)] = null);

} else {
throw ex68156;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68152 === (8))){
var inst_68146 = (state_68151[(2)]);
var _ = (function (){var statearr_68165 = state_68151;
(statearr_68165[(4)] = cljs.core.rest((state_68151[(4)])));

return statearr_68165;
})();
var state_68151__$1 = state_68151;
var statearr_68166_68180 = state_68151__$1;
(statearr_68166_68180[(2)] = inst_68146);

(statearr_68166_68180[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____0 = (function (){
var statearr_68167 = [null,null,null,null,null,null,null,null];
(statearr_68167[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__);

(statearr_68167[(1)] = (1));

return statearr_68167;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____1 = (function (state_68151){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68151);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68168){var ex__10753__auto__ = e68168;
var statearr_68169_68181 = state_68151;
(statearr_68169_68181[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68151[(4)]))){
var statearr_68170_68182 = state_68151;
(statearr_68170_68182[(1)] = cljs.core.first((state_68151[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68183 = state_68151;
state_68151 = G__68183;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__ = function(state_68151){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____1.call(this,state_68151);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68171 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68171[(6)] = c__10876__auto__);

return statearr_68171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__68185 = arguments.length;
switch (G__68185) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68227){
var state_val_68228 = (state_68227[(1)]);
if((state_val_68228 === (7))){
var state_68227__$1 = state_68227;
var statearr_68229_68259 = state_68227__$1;
(statearr_68229_68259[(2)] = seed);

(statearr_68229_68259[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (1))){
var state_68227__$1 = state_68227;
var statearr_68230_68260 = state_68227__$1;
(statearr_68230_68260[(2)] = null);

(statearr_68230_68260[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (4))){
var inst_68186 = (state_68227[(2)]);
var state_68227__$1 = state_68227;
var statearr_68231_68261 = state_68227__$1;
(statearr_68231_68261[(2)] = inst_68186);

(statearr_68231_68261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (15))){
var state_68227__$1 = state_68227;
var statearr_68232_68262 = state_68227__$1;
(statearr_68232_68262[(2)] = (10));

(statearr_68232_68262[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (13))){
var inst_68203 = (state_68227[(2)]);
var inst_68204 = fluree.db.util.async.throw_err(inst_68203);
var state_68227__$1 = state_68227;
var statearr_68233_68263 = state_68227__$1;
(statearr_68233_68263[(2)] = inst_68204);

(statearr_68233_68263[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (6))){
var state_68227__$1 = state_68227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68227__$1,(9),seed);
} else {
if((state_val_68228 === (3))){
var inst_68225 = (state_68227[(2)]);
var state_68227__$1 = state_68227;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68227__$1,inst_68225);
} else {
if((state_val_68228 === (12))){
var inst_68207 = (state_68227[(7)]);
var inst_68207__$1 = (state_68227[(2)]);
var state_68227__$1 = (function (){var statearr_68234 = state_68227;
(statearr_68234[(7)] = inst_68207__$1);

return statearr_68234;
})();
if(cljs.core.truth_(inst_68207__$1)){
var statearr_68235_68264 = state_68227__$1;
(statearr_68235_68264[(1)] = (14));

} else {
var statearr_68236_68265 = state_68227__$1;
(statearr_68236_68265[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (2))){
var _ = (function (){var statearr_68237 = state_68227;
(statearr_68237[(4)] = cljs.core.cons((5),(state_68227[(4)])));

return statearr_68237;
})();
var inst_68192 = fluree.db.util.async.channel_QMARK_(seed);
var state_68227__$1 = state_68227;
if(inst_68192){
var statearr_68238_68266 = state_68227__$1;
(statearr_68238_68266[(1)] = (6));

} else {
var statearr_68239_68267 = state_68227__$1;
(statearr_68239_68267[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (11))){
var state_68227__$1 = state_68227;
var statearr_68241_68268 = state_68227__$1;
(statearr_68241_68268[(2)] = max);

(statearr_68241_68268[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (9))){
var inst_68195 = (state_68227[(2)]);
var inst_68196 = fluree.db.util.async.throw_err(inst_68195);
var state_68227__$1 = state_68227;
var statearr_68242_68269 = state_68227__$1;
(statearr_68242_68269[(2)] = inst_68196);

(statearr_68242_68269[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (5))){
var _ = (function (){var statearr_68243 = state_68227;
(statearr_68243[(4)] = cljs.core.rest((state_68227[(4)])));

return statearr_68243;
})();
var state_68227__$1 = state_68227;
var ex68240 = (state_68227__$1[(2)]);
var statearr_68244_68270 = state_68227__$1;
(statearr_68244_68270[(5)] = ex68240);


if((ex68240 instanceof Error)){
var statearr_68245_68271 = state_68227__$1;
(statearr_68245_68271[(1)] = (4));

(statearr_68245_68271[(5)] = null);

} else {
throw ex68240;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (14))){
var inst_68207 = (state_68227[(7)]);
var state_68227__$1 = state_68227;
var statearr_68246_68272 = state_68227__$1;
(statearr_68246_68272[(2)] = inst_68207);

(statearr_68246_68272[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (16))){
var inst_68199 = (state_68227[(8)]);
var inst_68211 = (state_68227[(2)]);
var inst_68212 = fluree.db.dbfunctions.internal.rand(inst_68199,inst_68211);
var inst_68213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68214 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68215 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68216 = [max,seed];
var inst_68217 = (new cljs.core.PersistentVector(null,2,(5),inst_68215,inst_68216,null));
var inst_68218 = ["rand",inst_68217,inst_68212];
var inst_68219 = cljs.core.PersistentHashMap.fromArrays(inst_68214,inst_68218);
var inst_68220 = [inst_68219,(10)];
var inst_68221 = (new cljs.core.PersistentVector(null,2,(5),inst_68213,inst_68220,null));
var inst_68222 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68221);
var _ = (function (){var statearr_68247 = state_68227;
(statearr_68247[(4)] = cljs.core.rest((state_68227[(4)])));

return statearr_68247;
})();
var state_68227__$1 = (function (){var statearr_68248 = state_68227;
(statearr_68248[(9)] = inst_68222);

return statearr_68248;
})();
var statearr_68249_68273 = state_68227__$1;
(statearr_68249_68273[(2)] = inst_68212);

(statearr_68249_68273[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68228 === (10))){
var state_68227__$1 = state_68227;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68227__$1,(13),max);
} else {
if((state_val_68228 === (8))){
var inst_68199 = (state_68227[(2)]);
var inst_68200 = fluree.db.util.async.channel_QMARK_(max);
var state_68227__$1 = (function (){var statearr_68250 = state_68227;
(statearr_68250[(8)] = inst_68199);

return statearr_68250;
})();
if(inst_68200){
var statearr_68251_68274 = state_68227__$1;
(statearr_68251_68274[(1)] = (10));

} else {
var statearr_68252_68275 = state_68227__$1;
(statearr_68252_68275[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__10750__auto____0 = (function (){
var statearr_68253 = [null,null,null,null,null,null,null,null,null,null];
(statearr_68253[(0)] = fluree$db$dbfunctions$fns$state_machine__10750__auto__);

(statearr_68253[(1)] = (1));

return statearr_68253;
});
var fluree$db$dbfunctions$fns$state_machine__10750__auto____1 = (function (state_68227){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68227);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68254){var ex__10753__auto__ = e68254;
var statearr_68255_68276 = state_68227;
(statearr_68255_68276[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68227[(4)]))){
var statearr_68256_68277 = state_68227;
(statearr_68256_68277[(1)] = cljs.core.first((state_68227[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68278 = state_68227;
state_68227 = G__68278;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__10750__auto__ = function(state_68227){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__10750__auto____1.call(this,state_68227);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68257 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68257[(6)] = c__10876__auto__);

return statearr_68257;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68299){
var state_val_68300 = (state_68299[(1)]);
if((state_val_68300 === (1))){
var state_68299__$1 = state_68299;
var statearr_68301_68316 = state_68299__$1;
(statearr_68301_68316[(2)] = null);

(statearr_68301_68316[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68300 === (2))){
var _ = (function (){var statearr_68302 = state_68299;
(statearr_68302[(4)] = cljs.core.cons((5),(state_68299[(4)])));

return statearr_68302;
})();
var inst_68285 = fluree.db.util.core.random_uuid();
var inst_68286 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_68285);
var inst_68287 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68288 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68289 = cljs.core.PersistentVector.EMPTY;
var inst_68290 = ["uuid",inst_68289,inst_68286];
var inst_68291 = cljs.core.PersistentHashMap.fromArrays(inst_68288,inst_68290);
var inst_68292 = [inst_68291,(10)];
var inst_68293 = (new cljs.core.PersistentVector(null,2,(5),inst_68287,inst_68292,null));
var inst_68294 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68293);
var ___$1 = (function (){var statearr_68303 = state_68299;
(statearr_68303[(4)] = cljs.core.rest((state_68299[(4)])));

return statearr_68303;
})();
var state_68299__$1 = (function (){var statearr_68304 = state_68299;
(statearr_68304[(7)] = inst_68294);

return statearr_68304;
})();
var statearr_68305_68317 = state_68299__$1;
(statearr_68305_68317[(2)] = inst_68286);

(statearr_68305_68317[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68300 === (3))){
var inst_68297 = (state_68299[(2)]);
var state_68299__$1 = state_68299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68299__$1,inst_68297);
} else {
if((state_val_68300 === (4))){
var inst_68279 = (state_68299[(2)]);
var state_68299__$1 = state_68299;
var statearr_68307_68318 = state_68299__$1;
(statearr_68307_68318[(2)] = inst_68279);

(statearr_68307_68318[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68300 === (5))){
var _ = (function (){var statearr_68308 = state_68299;
(statearr_68308[(4)] = cljs.core.rest((state_68299[(4)])));

return statearr_68308;
})();
var state_68299__$1 = state_68299;
var ex68306 = (state_68299__$1[(2)]);
var statearr_68309_68319 = state_68299__$1;
(statearr_68309_68319[(5)] = ex68306);


if((ex68306 instanceof Error)){
var statearr_68310_68320 = state_68299__$1;
(statearr_68310_68320[(1)] = (4));

(statearr_68310_68320[(5)] = null);

} else {
throw ex68306;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____0 = (function (){
var statearr_68311 = [null,null,null,null,null,null,null,null];
(statearr_68311[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__);

(statearr_68311[(1)] = (1));

return statearr_68311;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____1 = (function (state_68299){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68299);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68312){var ex__10753__auto__ = e68312;
var statearr_68313_68321 = state_68299;
(statearr_68313_68321[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68299[(4)]))){
var statearr_68314_68322 = state_68299;
(statearr_68314_68322[(1)] = cljs.core.first((state_68299[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68323 = state_68299;
state_68299 = G__68323;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__ = function(state_68299){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____1.call(this,state_68299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68315 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68315[(6)] = c__10876__auto__);

return statearr_68315;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68353){
var state_val_68354 = (state_68353[(1)]);
if((state_val_68354 === (7))){
var state_68353__$1 = state_68353;
var statearr_68355_68374 = state_68353__$1;
(statearr_68355_68374[(2)] = num);

(statearr_68355_68374[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (1))){
var state_68353__$1 = state_68353;
var statearr_68356_68375 = state_68353__$1;
(statearr_68356_68375[(2)] = null);

(statearr_68356_68375[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (4))){
var inst_68324 = (state_68353[(2)]);
var state_68353__$1 = state_68353;
var statearr_68357_68376 = state_68353__$1;
(statearr_68357_68376[(2)] = inst_68324);

(statearr_68357_68376[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (6))){
var state_68353__$1 = state_68353;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68353__$1,(9),num);
} else {
if((state_val_68354 === (3))){
var inst_68351 = (state_68353[(2)]);
var state_68353__$1 = state_68353;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68353__$1,inst_68351);
} else {
if((state_val_68354 === (2))){
var _ = (function (){var statearr_68359 = state_68353;
(statearr_68359[(4)] = cljs.core.cons((5),(state_68353[(4)])));

return statearr_68359;
})();
var inst_68330 = fluree.db.util.async.channel_QMARK_(num);
var state_68353__$1 = state_68353;
if(inst_68330){
var statearr_68360_68377 = state_68353__$1;
(statearr_68360_68377[(1)] = (6));

} else {
var statearr_68361_68378 = state_68353__$1;
(statearr_68361_68378[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (9))){
var inst_68333 = (state_68353[(2)]);
var inst_68334 = fluree.db.util.async.throw_err(inst_68333);
var state_68353__$1 = state_68353;
var statearr_68362_68379 = state_68353__$1;
(statearr_68362_68379[(2)] = inst_68334);

(statearr_68362_68379[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (5))){
var _ = (function (){var statearr_68363 = state_68353;
(statearr_68363[(4)] = cljs.core.rest((state_68353[(4)])));

return statearr_68363;
})();
var state_68353__$1 = state_68353;
var ex68358 = (state_68353__$1[(2)]);
var statearr_68364_68380 = state_68353__$1;
(statearr_68364_68380[(5)] = ex68358);


if((ex68358 instanceof Error)){
var statearr_68365_68381 = state_68353__$1;
(statearr_68365_68381[(1)] = (4));

(statearr_68365_68381[(5)] = null);

} else {
throw ex68358;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68354 === (8))){
var inst_68337 = (state_68353[(2)]);
var inst_68338 = fluree.db.dbfunctions.internal.ceil(inst_68337);
var inst_68339 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68340 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68342 = [fluree.db.dbfunctions.fns.ceil];
var inst_68343 = (new cljs.core.PersistentVector(null,1,(5),inst_68341,inst_68342,null));
var inst_68344 = ["",inst_68343,inst_68338];
var inst_68345 = cljs.core.PersistentHashMap.fromArrays(inst_68340,inst_68344);
var inst_68346 = [inst_68345,(10)];
var inst_68347 = (new cljs.core.PersistentVector(null,2,(5),inst_68339,inst_68346,null));
var inst_68348 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68347);
var _ = (function (){var statearr_68366 = state_68353;
(statearr_68366[(4)] = cljs.core.rest((state_68353[(4)])));

return statearr_68366;
})();
var state_68353__$1 = (function (){var statearr_68367 = state_68353;
(statearr_68367[(7)] = inst_68348);

return statearr_68367;
})();
var statearr_68368_68382 = state_68353__$1;
(statearr_68368_68382[(2)] = inst_68338);

(statearr_68368_68382[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____0 = (function (){
var statearr_68369 = [null,null,null,null,null,null,null,null];
(statearr_68369[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__);

(statearr_68369[(1)] = (1));

return statearr_68369;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____1 = (function (state_68353){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68353);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68370){var ex__10753__auto__ = e68370;
var statearr_68371_68383 = state_68353;
(statearr_68371_68383[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68353[(4)]))){
var statearr_68372_68384 = state_68353;
(statearr_68372_68384[(1)] = cljs.core.first((state_68353[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68385 = state_68353;
state_68353 = G__68385;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__ = function(state_68353){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____1.call(this,state_68353);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68373 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68373[(6)] = c__10876__auto__);

return statearr_68373;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68415){
var state_val_68416 = (state_68415[(1)]);
if((state_val_68416 === (7))){
var state_68415__$1 = state_68415;
var statearr_68417_68436 = state_68415__$1;
(statearr_68417_68436[(2)] = num);

(statearr_68417_68436[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (1))){
var state_68415__$1 = state_68415;
var statearr_68418_68437 = state_68415__$1;
(statearr_68418_68437[(2)] = null);

(statearr_68418_68437[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (4))){
var inst_68386 = (state_68415[(2)]);
var state_68415__$1 = state_68415;
var statearr_68419_68438 = state_68415__$1;
(statearr_68419_68438[(2)] = inst_68386);

(statearr_68419_68438[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (6))){
var state_68415__$1 = state_68415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68415__$1,(9),num);
} else {
if((state_val_68416 === (3))){
var inst_68413 = (state_68415[(2)]);
var state_68415__$1 = state_68415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68415__$1,inst_68413);
} else {
if((state_val_68416 === (2))){
var _ = (function (){var statearr_68421 = state_68415;
(statearr_68421[(4)] = cljs.core.cons((5),(state_68415[(4)])));

return statearr_68421;
})();
var inst_68392 = fluree.db.util.async.channel_QMARK_(num);
var state_68415__$1 = state_68415;
if(inst_68392){
var statearr_68422_68439 = state_68415__$1;
(statearr_68422_68439[(1)] = (6));

} else {
var statearr_68423_68440 = state_68415__$1;
(statearr_68423_68440[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (9))){
var inst_68395 = (state_68415[(2)]);
var inst_68396 = fluree.db.util.async.throw_err(inst_68395);
var state_68415__$1 = state_68415;
var statearr_68424_68441 = state_68415__$1;
(statearr_68424_68441[(2)] = inst_68396);

(statearr_68424_68441[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (5))){
var _ = (function (){var statearr_68425 = state_68415;
(statearr_68425[(4)] = cljs.core.rest((state_68415[(4)])));

return statearr_68425;
})();
var state_68415__$1 = state_68415;
var ex68420 = (state_68415__$1[(2)]);
var statearr_68426_68442 = state_68415__$1;
(statearr_68426_68442[(5)] = ex68420);


if((ex68420 instanceof Error)){
var statearr_68427_68443 = state_68415__$1;
(statearr_68427_68443[(1)] = (4));

(statearr_68427_68443[(5)] = null);

} else {
throw ex68420;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68416 === (8))){
var inst_68399 = (state_68415[(2)]);
var inst_68400 = fluree.db.dbfunctions.internal.floor(inst_68399);
var inst_68401 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68402 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68403 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68404 = [fluree.db.dbfunctions.fns.floor];
var inst_68405 = (new cljs.core.PersistentVector(null,1,(5),inst_68403,inst_68404,null));
var inst_68406 = ["",inst_68405,inst_68400];
var inst_68407 = cljs.core.PersistentHashMap.fromArrays(inst_68402,inst_68406);
var inst_68408 = [inst_68407,(10)];
var inst_68409 = (new cljs.core.PersistentVector(null,2,(5),inst_68401,inst_68408,null));
var inst_68410 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68409);
var _ = (function (){var statearr_68428 = state_68415;
(statearr_68428[(4)] = cljs.core.rest((state_68415[(4)])));

return statearr_68428;
})();
var state_68415__$1 = (function (){var statearr_68429 = state_68415;
(statearr_68429[(7)] = inst_68410);

return statearr_68429;
})();
var statearr_68430_68444 = state_68415__$1;
(statearr_68430_68444[(2)] = inst_68400);

(statearr_68430_68444[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____0 = (function (){
var statearr_68431 = [null,null,null,null,null,null,null,null];
(statearr_68431[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__);

(statearr_68431[(1)] = (1));

return statearr_68431;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____1 = (function (state_68415){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68415);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68432){var ex__10753__auto__ = e68432;
var statearr_68433_68445 = state_68415;
(statearr_68433_68445[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68415[(4)]))){
var statearr_68434_68446 = state_68415;
(statearr_68434_68446[(1)] = cljs.core.first((state_68415[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68447 = state_68415;
state_68415 = G__68447;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__ = function(state_68415){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____1.call(this,state_68415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68435 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68435[(6)] = c__10876__auto__);

return statearr_68435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_68472){
var state_val_68473 = (state_68472[(1)]);
if((state_val_68473 === (1))){
var state_68472__$1 = state_68472;
var statearr_68474_68489 = state_68472__$1;
(statearr_68474_68489[(2)] = null);

(statearr_68474_68489[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68473 === (2))){
var _ = (function (){var statearr_68475 = state_68472;
(statearr_68475[(4)] = cljs.core.cons((5),(state_68472[(4)])));

return statearr_68475;
})();
var inst_68454 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_68472__$1 = state_68472;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_68472__$1,(6),inst_68454);
} else {
if((state_val_68473 === (3))){
var inst_68470 = (state_68472[(2)]);
var state_68472__$1 = state_68472;
return cljs.core.async.impl.ioc_helpers.return_chan(state_68472__$1,inst_68470);
} else {
if((state_val_68473 === (4))){
var inst_68448 = (state_68472[(2)]);
var state_68472__$1 = state_68472;
var statearr_68477_68490 = state_68472__$1;
(statearr_68477_68490[(2)] = inst_68448);

(statearr_68477_68490[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_68473 === (5))){
var _ = (function (){var statearr_68478 = state_68472;
(statearr_68478[(4)] = cljs.core.rest((state_68472[(4)])));

return statearr_68478;
})();
var state_68472__$1 = state_68472;
var ex68476 = (state_68472__$1[(2)]);
var statearr_68479_68491 = state_68472__$1;
(statearr_68479_68491[(5)] = ex68476);


if((ex68476 instanceof Error)){
var statearr_68480_68492 = state_68472__$1;
(statearr_68480_68492[(1)] = (4));

(statearr_68480_68492[(5)] = null);

} else {
throw ex68476;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_68473 === (6))){
var inst_68456 = (state_68472[(2)]);
var inst_68457 = fluree.db.util.async.throw_err(inst_68456);
var inst_68458 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68459 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_68460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_68461 = [compare_val,new_val];
var inst_68462 = (new cljs.core.PersistentVector(null,2,(5),inst_68460,inst_68461,null));
var inst_68463 = ["",inst_68462,inst_68457];
var inst_68464 = cljs.core.PersistentHashMap.fromArrays(inst_68459,inst_68463);
var inst_68465 = [inst_68464,(10)];
var inst_68466 = (new cljs.core.PersistentVector(null,2,(5),inst_68458,inst_68465,null));
var inst_68467 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_68466);
var _ = (function (){var statearr_68481 = state_68472;
(statearr_68481[(4)] = cljs.core.rest((state_68472[(4)])));

return statearr_68481;
})();
var state_68472__$1 = (function (){var statearr_68482 = state_68472;
(statearr_68482[(7)] = inst_68467);

return statearr_68482;
})();
var statearr_68483_68493 = state_68472__$1;
(statearr_68483_68493[(2)] = inst_68457);

(statearr_68483_68493[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____0 = (function (){
var statearr_68484 = [null,null,null,null,null,null,null,null];
(statearr_68484[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__);

(statearr_68484[(1)] = (1));

return statearr_68484;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____1 = (function (state_68472){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_68472);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e68485){var ex__10753__auto__ = e68485;
var statearr_68486_68494 = state_68472;
(statearr_68486_68494[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_68472[(4)]))){
var statearr_68487_68495 = state_68472;
(statearr_68487_68495[(1)] = cljs.core.first((state_68472[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__68496 = state_68472;
state_68472 = G__68496;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__ = function(state_68472){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____1.call(this,state_68472);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_68488 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_68488[(6)] = c__10876__auto__);

return statearr_68488;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
