// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.internal');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbproto');
goog.require('clojure.string');
goog.require('fluree.db.flake');
fluree.db.dbfunctions.internal.parse_select_map = (function fluree$db$dbfunctions$internal$parse_select_map(param_str){
var parsed_param = ((typeof param_str === 'string')?cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(param_str):param_str);
if(cljs.core.map_QMARK_(parsed_param)){
var key = cljs.core.first(cljs.core.keys(parsed_param));
var key_SINGLEQUOTE_ = ((typeof key === 'string')?key:(((cljs.core.namespace(key) == null))?cljs.core.name(key):[cljs.core.namespace(key),"/",cljs.core.name(key)].join('')));
var value = cljs.core.first(cljs.core.vals(parsed_param));
var value_SINGLEQUOTE_ = (fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.internal.parse_select_map.cljs$core$IFn$_invoke$arity$1(value) : fluree.db.dbfunctions.internal.parse_select_map.call(null,value));
var value_SINGLEQUOTE__SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(value_SINGLEQUOTE_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,value_SINGLEQUOTE_):value_SINGLEQUOTE_);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,key_SINGLEQUOTE_,value_SINGLEQUOTE__SINGLEQUOTE_);
} else {
if(typeof parsed_param === 'string'){
return parsed_param;
} else {
if((((parsed_param instanceof cljs.core.Symbol)) || (cljs.core.var_QMARK_(parsed_param)))){
if((cljs.core.namespace(parsed_param) == null)){
return cljs.core.name(parsed_param);
} else {
return [cljs.core.namespace(parsed_param),"/",cljs.core.name(parsed_param)].join('');
}
} else {
if(cljs.core.vector_QMARK_(parsed_param)){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.parse_select_map,parsed_param);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The query path is not properly formatted: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(parsed_param)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));

}
}
}
}
});
fluree.db.dbfunctions.internal.function_error = (function fluree$db$dbfunctions$internal$function_error(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40589 = arguments.length;
var i__4819__auto___40590 = (0);
while(true){
if((i__4819__auto___40590 < len__4818__auto___40589)){
args__4824__auto__.push((arguments[i__4819__auto___40590]));

var G__40591 = (i__4819__auto___40590 + (1));
i__4819__auto___40590 = G__40591;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic = (function (e,function_name,args){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([e,"Function Error: ",function_name,"args: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0))], 0));

throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2((function (){var e_SINGLEQUOTE_ = e;
var msg = e_SINGLEQUOTE_.getMessage();
var err_msg = (((msg == null))?e_SINGLEQUOTE_.getClass():msg);
var args_SINGLEQUOTE_ = ((cljs.core.coll_QMARK_(args))?clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",args):args);
return ["Error in database function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(function_name),": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(err_msg),". Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(args_SINGLEQUOTE_)].join('');
})(),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
}));

(fluree.db.dbfunctions.internal.function_error.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.db.dbfunctions.internal.function_error.cljs$lang$applyTo = (function (seq40586){
var G__40587 = cljs.core.first(seq40586);
var seq40586__$1 = cljs.core.next(seq40586);
var G__40588 = cljs.core.first(seq40586__$1);
var seq40586__$2 = cljs.core.next(seq40586__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__40587,G__40588,seq40586__$2);
}));

/**
 * Coerce to boolean. Everything except `false' and `nil' is true in boolean context.
 */
fluree.db.dbfunctions.internal.boolean$ = (function fluree$db$dbfunctions$internal$boolean(x){
try{return cljs.core.boolean$(x);
}catch (e40592){var e = e40592;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"boolean",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([x], 0));
}});
fluree.db.dbfunctions.internal.nil_QMARK_ = (function fluree$db$dbfunctions$internal$nil_QMARK_(arg){
try{return (arg == null);
}catch (e40593){var e = e40593;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nil?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.not = (function fluree$db$dbfunctions$internal$not(arg){
try{return cljs.core.not(arg);
}catch (e40594){var e = e40594;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
fluree.db.dbfunctions.internal.empty_QMARK_ = (function fluree$db$dbfunctions$internal$empty_QMARK_(arg){
try{return ((cljs.core.empty_QMARK_(arg)) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [null,null], null), null),arg)));
}catch (e40595){var e = e40595;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"empty?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([arg], 0));
}});
/**
 * Like clojure.core/if
 */
fluree.db.dbfunctions.internal.if_else = (function fluree$db$dbfunctions$internal$if_else(test,true_res,false_res){
try{if(cljs.core.truth_(test)){
return true_res;
} else {
return false_res;

}
}catch (e40596){var e = e40596;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"if-else",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([test,true_res,false_res], 0));
}});
/**
 * Returns true if all true
 */
fluree.db.dbfunctions.internal.and = (function fluree$db$dbfunctions$internal$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40599 = arguments.length;
var i__4819__auto___40600 = (0);
while(true){
if((i__4819__auto___40600 < len__4818__auto___40599)){
args__4824__auto__.push((arguments[i__4819__auto___40600]));

var G__40601 = (i__4819__auto___40600 + (1));
i__4819__auto___40600 = G__40601;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.every_QMARK_(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40598){var e = e40598;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"and",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.and.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.and.cljs$lang$applyTo = (function (seq40597){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40597));
}));

/**
 * Returns true if any true
 */
fluree.db.dbfunctions.internal.or = (function fluree$db$dbfunctions$internal$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40604 = arguments.length;
var i__4819__auto___40605 = (0);
while(true){
if((i__4819__auto___40605 < len__4818__auto___40604)){
args__4824__auto__.push((arguments[i__4819__auto___40605]));

var G__40606 = (i__4819__auto___40605 + (1));
i__4819__auto___40605 = G__40606;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.or.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{var coerced_coll = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.boolean$,args);
if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
return false;
} else {
return fluree.db.dbfunctions.internal.boolean$(cljs.core.some(cljs.core.true_QMARK_,coerced_coll));
}
}catch (e40603){var e = e40603;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"or",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.or.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.or.cljs$lang$applyTo = (function (seq40602){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40602));
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.internal.count = (function fluree$db$dbfunctions$internal$count(coll){
try{return cljs.core.count(coll);
}catch (e40607){var e = e40607;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"count",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll], 0));
}});
/**
 * Like clojure.core/str
 */
fluree.db.dbfunctions.internal.str = (function fluree$db$dbfunctions$internal$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40610 = arguments.length;
var i__4819__auto___40611 = (0);
while(true){
if((i__4819__auto___40611 < len__4818__auto___40610)){
args__4824__auto__.push((arguments[i__4819__auto___40611]));

var G__40612 = (i__4819__auto___40611 + (1));
i__4819__auto___40611 = G__40612;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,args);
}catch (e40609){var e = e40609;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"str",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.str.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.str.cljs$lang$applyTo = (function (seq40608){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40608));
}));

/**
 * Like clojure.core/subs
 */
fluree.db.dbfunctions.internal.subs = (function fluree$db$dbfunctions$internal$subs(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40615 = arguments.length;
var i__4819__auto___40616 = (0);
while(true){
if((i__4819__auto___40616 < len__4818__auto___40615)){
args__4824__auto__.push((arguments[i__4819__auto___40616]));

var G__40617 = (i__4819__auto___40616 + (1));
i__4819__auto___40616 = G__40617;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.subs.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.subs,args);
}catch (e40614){var e = e40614;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"subs",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.subs.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.subs.cljs$lang$applyTo = (function (seq40613){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40613));
}));

/**
 * Like clojure.core/lower-case
 */
fluree.db.dbfunctions.internal.lower_case = (function fluree$db$dbfunctions$internal$lower_case(str){
try{return clojure.string.lower_case(str);
}catch (e40618){var e = e40618;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"lower-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/upper-case
 */
fluree.db.dbfunctions.internal.upper_case = (function fluree$db$dbfunctions$internal$upper_case(str){
try{return clojure.string.upper_case(str);
}catch (e40619){var e = e40619;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"upper-case",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([str], 0));
}});
/**
 * Like clojure.core/max, but applies max on a sequence
 */
fluree.db.dbfunctions.internal.max = (function fluree$db$dbfunctions$internal$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40622 = arguments.length;
var i__4819__auto___40623 = (0);
while(true){
if((i__4819__auto___40623 < len__4818__auto___40622)){
args__4824__auto__.push((arguments[i__4819__auto___40623]));

var G__40624 = (i__4819__auto___40623 + (1));
i__4819__auto___40623 = G__40624;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.max.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.max,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40621){var e = e40621;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"max",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.max.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.max.cljs$lang$applyTo = (function (seq40620){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40620));
}));

/**
 * Like clojure.core/min, but applies min on a sequence
 */
fluree.db.dbfunctions.internal.min = (function fluree$db$dbfunctions$internal$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40627 = arguments.length;
var i__4819__auto___40628 = (0);
while(true){
if((i__4819__auto___40628 < len__4818__auto___40627)){
args__4824__auto__.push((arguments[i__4819__auto___40628]));

var G__40629 = (i__4819__auto___40628 + (1));
i__4819__auto___40628 = G__40629;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.min.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.min,cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,args));
}catch (e40626){var e = e40626;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"min",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.min.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.min.cljs$lang$applyTo = (function (seq40625){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40625));
}));

/**
 * Like clojure.core/>, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT_ = (function fluree$db$dbfunctions$internal$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40632 = arguments.length;
var i__4819__auto___40633 = (0);
while(true){
if((i__4819__auto___40633 < len__4818__auto___40632)){
args__4824__auto__.push((arguments[i__4819__auto___40633]));

var G__40634 = (i__4819__auto___40633 + (1));
i__4819__auto___40633 = G__40634;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,args);
}catch (e40631){var e = e40631;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT_.cljs$lang$applyTo = (function (seq40630){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40630));
}));

/**
 * Like clojure.core/>=, but applies > on a sequence
 */
fluree.db.dbfunctions.internal._GT__EQ_ = (function fluree$db$dbfunctions$internal$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40637 = arguments.length;
var i__4819__auto___40638 = (0);
while(true){
if((i__4819__auto___40638 < len__4818__auto___40637)){
args__4824__auto__.push((arguments[i__4819__auto___40638]));

var G__40639 = (i__4819__auto___40638 + (1));
i__4819__auto___40638 = G__40639;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,args);
}catch (e40636){var e = e40636;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,">=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._GT__EQ_.cljs$lang$applyTo = (function (seq40635){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40635));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT_ = (function fluree$db$dbfunctions$internal$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40642 = arguments.length;
var i__4819__auto___40643 = (0);
while(true){
if((i__4819__auto___40643 < len__4818__auto___40642)){
args__4824__auto__.push((arguments[i__4819__auto___40643]));

var G__40644 = (i__4819__auto___40643 + (1));
i__4819__auto___40643 = G__40644;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,args);
}catch (e40641){var e = e40641;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT_.cljs$lang$applyTo = (function (seq40640){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40640));
}));

/**
 * Like clojure.core/>, but applies < on a sequence
 */
fluree.db.dbfunctions.internal._LT__EQ_ = (function fluree$db$dbfunctions$internal$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40647 = arguments.length;
var i__4819__auto___40648 = (0);
while(true){
if((i__4819__auto___40648 < len__4818__auto___40647)){
args__4824__auto__.push((arguments[i__4819__auto___40648]));

var G__40649 = (i__4819__auto___40648 + (1));
i__4819__auto___40648 = G__40649;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,args);
}catch (e40646){var e = e40646;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"<=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._LT__EQ_.cljs$lang$applyTo = (function (seq40645){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40645));
}));

fluree.db.dbfunctions.internal.not_EQ_ = (function fluree$db$dbfunctions$internal$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40652 = arguments.length;
var i__4819__auto___40653 = (0);
while(true){
if((i__4819__auto___40653 < len__4818__auto___40652)){
args__4824__auto__.push((arguments[i__4819__auto___40653]));

var G__40654 = (i__4819__auto___40653 + (1));
i__4819__auto___40653 = G__40654;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,args);
}catch (e40651){var e = e40651;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"not=",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.not_EQ_.cljs$lang$applyTo = (function (seq40650){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40650));
}));

/**
 * Executes a database query, but returns the :results directly.
 */
fluree.db.dbfunctions.internal.query = (function fluree$db$dbfunctions$internal$query(var_args){
var G__40656 = arguments.length;
switch (G__40656) {
case 2:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2 = (function (db,query_map){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_40684){
var state_val_40685 = (state_40684[(1)]);
if((state_val_40685 === (7))){
var inst_40669 = (state_40684[(7)]);
var inst_40672 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40669,"query",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var state_40684__$1 = state_40684;
var statearr_40686_40772 = state_40684__$1;
(statearr_40686_40772[(2)] = inst_40672);

(statearr_40686_40772[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (1))){
var state_40684__$1 = state_40684;
var statearr_40687_40773 = state_40684__$1;
(statearr_40687_40773[(2)] = null);

(statearr_40687_40773[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (4))){
var inst_40657 = (state_40684[(2)]);
var state_40684__$1 = state_40684;
var statearr_40688_40774 = state_40684__$1;
(statearr_40688_40774[(2)] = inst_40657);

(statearr_40688_40774[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (6))){
var inst_40669 = (state_40684[(7)]);
var inst_40669__$1 = (state_40684[(2)]);
var inst_40670 = fluree.db.util.core.exception_QMARK_(inst_40669__$1);
var state_40684__$1 = (function (){var statearr_40689 = state_40684;
(statearr_40689[(7)] = inst_40669__$1);

return statearr_40689;
})();
if(inst_40670){
var statearr_40690_40775 = state_40684__$1;
(statearr_40690_40775[(1)] = (7));

} else {
var statearr_40691_40776 = state_40684__$1;
(statearr_40691_40776[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (3))){
var inst_40682 = (state_40684[(2)]);
var state_40684__$1 = state_40684;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40684__$1,inst_40682);
} else {
if((state_val_40685 === (2))){
var inst_40663 = (state_40684[(8)]);
var _ = (function (){var statearr_40693 = state_40684;
(statearr_40693[(4)] = cljs.core.cons((5),(state_40684[(4)])));

return statearr_40693;
})();
var inst_40663__$1 = cljs.core.volatile_BANG_((0));
var inst_40664 = cljs.core.cst$kw$opts.cljs$core$IFn$_invoke$arity$1(query_map);
var inst_40665 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_40664,cljs.core.cst$kw$fuel,inst_40663__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$max_DASH_fuel,(100000)], 0));
var inst_40666 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(query_map,cljs.core.cst$kw$opts,inst_40665);
var inst_40667 = fluree.db.query.fql.query(db,inst_40666);
var state_40684__$1 = (function (){var statearr_40694 = state_40684;
(statearr_40694[(8)] = inst_40663__$1);

return statearr_40694;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40684__$1,(6),inst_40667);
} else {
if((state_val_40685 === (9))){
var inst_40679 = (state_40684[(2)]);
var _ = (function (){var statearr_40695 = state_40684;
(statearr_40695[(4)] = cljs.core.rest((state_40684[(4)])));

return statearr_40695;
})();
var state_40684__$1 = state_40684;
var statearr_40696_40777 = state_40684__$1;
(statearr_40696_40777[(2)] = inst_40679);

(statearr_40696_40777[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (5))){
var _ = (function (){var statearr_40697 = state_40684;
(statearr_40697[(4)] = cljs.core.rest((state_40684[(4)])));

return statearr_40697;
})();
var state_40684__$1 = state_40684;
var ex40692 = (state_40684__$1[(2)]);
var statearr_40698_40778 = state_40684__$1;
(statearr_40698_40778[(5)] = ex40692);


if((ex40692 instanceof Error)){
var statearr_40699_40779 = state_40684__$1;
(statearr_40699_40779[(1)] = (4));

(statearr_40699_40779[(5)] = null);

} else {
throw ex40692;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40685 === (8))){
var inst_40663 = (state_40684[(8)]);
var inst_40669 = (state_40684[(7)]);
var inst_40674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40675 = cljs.core.deref(inst_40663);
var inst_40676 = [inst_40669,inst_40675];
var inst_40677 = (new cljs.core.PersistentVector(null,2,(5),inst_40674,inst_40676,null));
var state_40684__$1 = state_40684;
var statearr_40700_40780 = state_40684__$1;
(statearr_40700_40780[(2)] = inst_40677);

(statearr_40700_40780[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10750__auto____0 = (function (){
var statearr_40701 = [null,null,null,null,null,null,null,null,null];
(statearr_40701[(0)] = fluree$db$dbfunctions$internal$state_machine__10750__auto__);

(statearr_40701[(1)] = (1));

return statearr_40701;
});
var fluree$db$dbfunctions$internal$state_machine__10750__auto____1 = (function (state_40684){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_40684);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e40702){var ex__10753__auto__ = e40702;
var statearr_40703_40781 = state_40684;
(statearr_40703_40781[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_40684[(4)]))){
var statearr_40704_40782 = state_40684;
(statearr_40704_40782[(1)] = cljs.core.first((state_40684[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__40783 = state_40684;
state_40684 = G__40783;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10750__auto__ = function(state_40684){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____1.call(this,state_40684);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_40705 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_40705[(6)] = c__10876__auto__);

return statearr_40705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6 = (function (db,select,from,where,block,limit){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_40750){
var state_val_40751 = (state_40750[(1)]);
if((state_val_40751 === (7))){
var inst_40736 = (state_40750[(2)]);
var inst_40737 = fluree.db.query.fql.query(db,inst_40736);
var state_40750__$1 = state_40750;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40750__$1,(8),inst_40737);
} else {
if((state_val_40751 === (1))){
var inst_40706 = typeof select === 'string';
var state_40750__$1 = state_40750;
if(cljs.core.truth_(inst_40706)){
var statearr_40752_40784 = state_40750__$1;
(statearr_40752_40784[(1)] = (2));

} else {
var statearr_40753_40785 = state_40750__$1;
(statearr_40753_40785[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (4))){
var inst_40719 = (state_40750[(7)]);
var inst_40712 = (state_40750[(8)]);
var inst_40711 = (state_40750[(2)]);
var inst_40712__$1 = cljs.core.volatile_BANG_((0));
var inst_40713 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$where,cljs.core.cst$kw$block,cljs.core.cst$kw$limit,cljs.core.cst$kw$opts];
var inst_40714 = [cljs.core.cst$kw$fuel,cljs.core.cst$kw$max_DASH_fuel];
var inst_40715 = [inst_40712__$1,(100000)];
var inst_40716 = cljs.core.PersistentHashMap.fromArrays(inst_40714,inst_40715);
var inst_40717 = [inst_40711,from,where,block,limit,inst_40716];
var inst_40718 = cljs.core.PersistentHashMap.fromArrays(inst_40713,inst_40717);
var inst_40719__$1 = fluree.db.util.core.without_nils(inst_40718);
var inst_40720 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40719__$1);
var inst_40721 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40719__$1);
var inst_40722 = cljs.core.first(inst_40721);
var inst_40723 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40722], 0));
var inst_40724 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("[",inst_40723);
var inst_40725 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40719__$1);
var inst_40726 = cljs.core.last(inst_40725);
var inst_40727 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40726], 0));
var inst_40728 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("]",inst_40727);
var inst_40729 = fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_40720,inst_40724,inst_40728], 0));
var state_40750__$1 = (function (){var statearr_40754 = state_40750;
(statearr_40754[(7)] = inst_40719__$1);

(statearr_40754[(8)] = inst_40712__$1);

return statearr_40754;
})();
if(cljs.core.truth_(inst_40729)){
var statearr_40755_40786 = state_40750__$1;
(statearr_40755_40786[(1)] = (5));

} else {
var statearr_40756_40787 = state_40750__$1;
(statearr_40756_40787[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (6))){
var inst_40719 = (state_40750[(7)]);
var state_40750__$1 = state_40750;
var statearr_40757_40788 = state_40750__$1;
(statearr_40757_40788[(2)] = inst_40719);

(statearr_40757_40788[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (3))){
var state_40750__$1 = state_40750;
var statearr_40758_40789 = state_40750__$1;
(statearr_40758_40789[(2)] = select);

(statearr_40758_40789[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (2))){
var inst_40708 = fluree.db.dbfunctions.internal.parse_select_map(select);
var state_40750__$1 = state_40750;
var statearr_40759_40790 = state_40750__$1;
(statearr_40759_40790[(2)] = inst_40708);

(statearr_40759_40790[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (11))){
var inst_40748 = (state_40750[(2)]);
var state_40750__$1 = state_40750;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40750__$1,inst_40748);
} else {
if((state_val_40751 === (9))){
var inst_40739 = (state_40750[(9)]);
var state_40750__$1 = state_40750;
var statearr_40760_40791 = state_40750__$1;
(statearr_40760_40791[(2)] = inst_40739);

(statearr_40760_40791[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (5))){
var inst_40719 = (state_40750[(7)]);
var inst_40731 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(inst_40719);
var inst_40732 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_40731);
var inst_40733 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40719,cljs.core.cst$kw$where,inst_40732);
var state_40750__$1 = state_40750;
var statearr_40761_40792 = state_40750__$1;
(statearr_40761_40792[(2)] = inst_40733);

(statearr_40761_40792[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (10))){
var inst_40739 = (state_40750[(9)]);
var inst_40712 = (state_40750[(8)]);
var inst_40743 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40744 = cljs.core.deref(inst_40712);
var inst_40745 = [inst_40739,inst_40744];
var inst_40746 = (new cljs.core.PersistentVector(null,2,(5),inst_40743,inst_40745,null));
var state_40750__$1 = state_40750;
var statearr_40762_40793 = state_40750__$1;
(statearr_40762_40793[(2)] = inst_40746);

(statearr_40762_40793[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40751 === (8))){
var inst_40739 = (state_40750[(9)]);
var inst_40739__$1 = (state_40750[(2)]);
var inst_40740 = fluree.db.util.core.exception_QMARK_(inst_40739__$1);
var state_40750__$1 = (function (){var statearr_40763 = state_40750;
(statearr_40763[(9)] = inst_40739__$1);

return statearr_40763;
})();
if(inst_40740){
var statearr_40764_40794 = state_40750__$1;
(statearr_40764_40794[(1)] = (9));

} else {
var statearr_40765_40795 = state_40750__$1;
(statearr_40765_40795[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10750__auto____0 = (function (){
var statearr_40766 = [null,null,null,null,null,null,null,null,null,null];
(statearr_40766[(0)] = fluree$db$dbfunctions$internal$state_machine__10750__auto__);

(statearr_40766[(1)] = (1));

return statearr_40766;
});
var fluree$db$dbfunctions$internal$state_machine__10750__auto____1 = (function (state_40750){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_40750);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e40767){var ex__10753__auto__ = e40767;
var statearr_40768_40796 = state_40750;
(statearr_40768_40796[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_40750[(4)]))){
var statearr_40769_40797 = state_40750;
(statearr_40769_40797[(1)] = cljs.core.first((state_40750[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__40798 = state_40750;
state_40750 = G__40798;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10750__auto__ = function(state_40750){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____1.call(this,state_40750);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_40770 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_40770[(6)] = c__10876__auto__);

return statearr_40770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.internal.query.cljs$lang$maxFixedArity = 6);

fluree.db.dbfunctions.internal.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.dbfunctions.internal.reverse_ref_QMARK_ = (function fluree$db$dbfunctions$internal$reverse_ref_QMARK_(predicate_name){
if(typeof predicate_name === 'string'){
return fluree.db.dbfunctions.internal.boolean$(cljs.core.re_matches(fluree.db.dbfunctions.internal.pred_reverse_ref_re,predicate_name));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))], 0)),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
/**
 * A reverse-reference predicate gets transformed to the actual predicate name.
 */
fluree.db.dbfunctions.internal.unreverse_var = (function fluree$db$dbfunctions$internal$unreverse_var(pred){
return clojure.string.replace(pred,"/_","/");
});
fluree.db.dbfunctions.internal.build_where_single_path = (function fluree$db$dbfunctions$internal$build_where_single_path(startSubject,var$,endSubject){
var start_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$,"?var1"], null);
var bridge_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,"?var1"], null);
var end_clause = new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, ["?var2",var$,endSubject], null);
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [start_clause,bridge_clause,end_clause], null);
});
fluree.db.dbfunctions.internal.build_where_clause = (function fluree$db$dbfunctions$internal$build_where_clause(startSubject,path,endSubject){
var G__40802 = path;
var vec__40803 = G__40802;
var seq__40804 = cljs.core.seq(vec__40803);
var first__40805 = cljs.core.first(seq__40804);
var seq__40804__$1 = cljs.core.next(seq__40804);
var var$ = first__40805;
var r = seq__40804__$1;
var n = (1);
var where_clauses = cljs.core.PersistentVector.EMPTY;
var G__40802__$1 = G__40802;
var n__$1 = n;
var where_clauses__$1 = where_clauses;
while(true){
var vec__40809 = G__40802__$1;
var seq__40810 = cljs.core.seq(vec__40809);
var first__40811 = cljs.core.first(seq__40810);
var seq__40810__$1 = cljs.core.next(seq__40810);
var var$__$1 = first__40811;
var r__$1 = seq__40810__$1;
var n__$2 = n__$1;
var where_clauses__$2 = where_clauses__$1;
if(cljs.core.truth_(fluree.db.dbfunctions.internal.and.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2),fluree.db.dbfunctions.internal.nil_QMARK_(r__$1)], 0)))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
if(cljs.core.truth_(reverse_QMARK_)){
return fluree.db.dbfunctions.internal.build_where_single_path(endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject);
} else {
return fluree.db.dbfunctions.internal.build_where_single_path(startSubject,var$__$1,endSubject);
}
} else {
if(cljs.core.truth_(fluree.db.dbfunctions.internal.empty_QMARK_(where_clauses__$2))){
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clauses = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),startSubject], null)], null):new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [startSubject,var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null)], null));
var G__40812 = r__$1;
var G__40813 = n__$2;
var G__40814 = next_clauses;
G__40802__$1 = G__40812;
n__$1 = G__40813;
where_clauses__$1 = G__40814;
continue;
} else {
if(r__$1){
var next_n = (n__$2 + (1));
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var next_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0)),fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",next_n], 0))], null));
var G__40815 = r__$1;
var G__40816 = next_n;
var G__40817 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,next_clause);
G__40802__$1 = G__40815;
n__$1 = G__40816;
where_clauses__$1 = G__40817;
continue;
} else {
var reverse_QMARK_ = fluree.db.dbfunctions.internal.reverse_ref_QMARK_(var$__$1);
var last_clause = (cljs.core.truth_(reverse_QMARK_)?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [endSubject,fluree.db.dbfunctions.internal.unreverse_var(var$__$1),fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0))], null):new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["?var",n__$2], 0)),var$__$1,endSubject], null));
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(where_clauses__$2,last_clause);

}
}
}
break;
}
});
fluree.db.dbfunctions.internal.relationship_QMARK_ = (function fluree$db$dbfunctions$internal$relationship_QMARK_(db,startSubject,path,endSubject){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_40854){
var state_val_40855 = (state_40854[(1)]);
if((state_val_40855 === (7))){
var inst_40827 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40828 = [path];
var inst_40829 = (new cljs.core.PersistentVector(null,1,(5),inst_40827,inst_40828,null));
var state_40854__$1 = state_40854;
var statearr_40856_40884 = state_40854__$1;
(statearr_40856_40884[(2)] = inst_40829);

(statearr_40856_40884[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (1))){
var state_40854__$1 = state_40854;
var statearr_40857_40885 = state_40854__$1;
(statearr_40857_40885[(2)] = null);

(statearr_40857_40885[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (4))){
var inst_40818 = (state_40854[(2)]);
var state_40854__$1 = state_40854;
var statearr_40858_40886 = state_40854__$1;
(statearr_40858_40886[(2)] = inst_40818);

(statearr_40858_40886[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (13))){
var inst_40845 = (state_40854[(2)]);
var inst_40846 = fluree.db.util.async.throw_err(inst_40845);
var _ = (function (){var statearr_40859 = state_40854;
(statearr_40859[(4)] = cljs.core.rest((state_40854[(4)])));

return statearr_40859;
})();
var state_40854__$1 = state_40854;
var statearr_40860_40887 = state_40854__$1;
(statearr_40860_40887[(2)] = inst_40846);

(statearr_40860_40887[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (6))){
var state_40854__$1 = state_40854;
var statearr_40862_40888 = state_40854__$1;
(statearr_40862_40888[(2)] = path);

(statearr_40862_40888[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (3))){
var inst_40852 = (state_40854[(2)]);
var state_40854__$1 = state_40854;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40854__$1,inst_40852);
} else {
if((state_val_40855 === (12))){
var _ = (function (){var statearr_40863 = state_40854;
(statearr_40863[(4)] = cljs.core.rest((state_40854[(4)])));

return statearr_40863;
})();
var state_40854__$1 = state_40854;
var ex40861 = (state_40854__$1[(2)]);
var statearr_40864_40889 = state_40854__$1;
(statearr_40864_40889[(5)] = ex40861);


var statearr_40865_40890 = state_40854__$1;
(statearr_40865_40890[(1)] = (11));

(statearr_40865_40890[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (2))){
var _ = (function (){var statearr_40866 = state_40854;
(statearr_40866[(4)] = cljs.core.cons((5),(state_40854[(4)])));

return statearr_40866;
})();
var inst_40824 = cljs.core.vector_QMARK_(path);
var state_40854__$1 = state_40854;
if(inst_40824){
var statearr_40867_40891 = state_40854__$1;
(statearr_40867_40891[(1)] = (6));

} else {
var statearr_40868_40892 = state_40854__$1;
(statearr_40868_40892[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (11))){
var inst_40831 = (state_40854[(7)]);
var inst_40836 = (state_40854[(2)]);
var inst_40837 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40836,"relationship?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startSubject,inst_40831,endSubject], 0));
var state_40854__$1 = state_40854;
var statearr_40870_40893 = state_40854__$1;
(statearr_40870_40893[(2)] = inst_40837);

(statearr_40870_40893[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (9))){
var inst_40835 = (state_40854[(8)]);
var _ = (function (){var statearr_40871 = state_40854;
(statearr_40871[(4)] = cljs.core.cons((12),(state_40854[(4)])));

return statearr_40871;
})();
var inst_40843 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_40835);
var state_40854__$1 = state_40854;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40854__$1,(13),inst_40843);
} else {
if((state_val_40855 === (5))){
var _ = (function (){var statearr_40872 = state_40854;
(statearr_40872[(4)] = cljs.core.rest((state_40854[(4)])));

return statearr_40872;
})();
var state_40854__$1 = state_40854;
var ex40869 = (state_40854__$1[(2)]);
var statearr_40873_40894 = state_40854__$1;
(statearr_40873_40894[(5)] = ex40869);


if((ex40869 instanceof Error)){
var statearr_40874_40895 = state_40854__$1;
(statearr_40874_40895[(1)] = (4));

(statearr_40874_40895[(5)] = null);

} else {
throw ex40869;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (10))){
var inst_40849 = (state_40854[(2)]);
var _ = (function (){var statearr_40875 = state_40854;
(statearr_40875[(4)] = cljs.core.rest((state_40854[(4)])));

return statearr_40875;
})();
var state_40854__$1 = state_40854;
var statearr_40876_40896 = state_40854__$1;
(statearr_40876_40896[(2)] = inst_40849);

(statearr_40876_40896[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40855 === (8))){
var inst_40831 = (state_40854[(7)]);
var inst_40831__$1 = (state_40854[(2)]);
var inst_40832 = fluree.db.dbfunctions.internal.build_where_clause(startSubject,inst_40831__$1,endSubject);
var inst_40833 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where];
var inst_40834 = ["?var1",inst_40832];
var inst_40835 = cljs.core.PersistentHashMap.fromArrays(inst_40833,inst_40834);
var state_40854__$1 = (function (){var statearr_40877 = state_40854;
(statearr_40877[(8)] = inst_40835);

(statearr_40877[(7)] = inst_40831__$1);

return statearr_40877;
})();
var statearr_40878_40897 = state_40854__$1;
(statearr_40878_40897[(2)] = null);

(statearr_40878_40897[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_40879 = [null,null,null,null,null,null,null,null,null];
(statearr_40879[(0)] = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__);

(statearr_40879[(1)] = (1));

return statearr_40879;
});
var fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____1 = (function (state_40854){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_40854);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e40880){var ex__10753__auto__ = e40880;
var statearr_40881_40898 = state_40854;
(statearr_40881_40898[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_40854[(4)]))){
var statearr_40882_40899 = state_40854;
(statearr_40882_40899[(1)] = cljs.core.first((state_40854[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__40900 = state_40854;
state_40854 = G__40900;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__ = function(state_40854){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____1.call(this,state_40854);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$relationship_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_40883 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_40883[(6)] = c__10876__auto__);

return statearr_40883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Increments by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.inc = (function fluree$db$dbfunctions$internal$inc(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (1);
} else {
return (n + (1));
}
}catch (e40901){var e = e40901;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"inc",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
/**
 * Decrements by 1. nil is treated as zero.
 */
fluree.db.dbfunctions.internal.dec = (function fluree$db$dbfunctions$internal$dec(n){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(n))){
return (-1);
} else {
return (n - (1));
}
}catch (e40902){var e = e40902;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"dec",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n], 0));
}});
fluree.db.dbfunctions.internal.get = (function fluree$db$dbfunctions$internal$get(m,k){
try{var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k));
}
}catch (e40903){var e = e40903;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,k], 0));
}});
/**
 * Returns current epoch milliseconds.
 */
fluree.db.dbfunctions.internal.now = (function fluree$db$dbfunctions$internal$now(){
try{return fluree.db.util.core.current_time_millis();
}catch (e40904){var e = e40904;
return fluree.db.dbfunctions.internal.function_error(e,"now");
}});
/**
 * Returns sum of all arguments in a sequence.
 */
fluree.db.dbfunctions.internal._PLUS_ = (function fluree$db$dbfunctions$internal$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40907 = arguments.length;
var i__4819__auto___40908 = (0);
while(true){
if((i__4819__auto___40908 < len__4818__auto___40907)){
args__4824__auto__.push((arguments[i__4819__auto___40908]));

var G__40909 = (i__4819__auto___40908 + (1));
i__4819__auto___40908 = G__40909;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,args);
}catch (e40906){var e = e40906;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"+",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._PLUS_.cljs$lang$applyTo = (function (seq40905){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40905));
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.internal._ = (function fluree$db$dbfunctions$internal$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40912 = arguments.length;
var i__4819__auto___40913 = (0);
while(true){
if((i__4819__auto___40913 < len__4818__auto___40912)){
args__4824__auto__.push((arguments[i__4819__auto___40913]));

var G__40914 = (i__4819__auto___40913 + (1));
i__4819__auto___40913 = G__40914;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._,args);
}catch (e40911){var e = e40911;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"-",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._.cljs$lang$applyTo = (function (seq40910){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40910));
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.internal._STAR_ = (function fluree$db$dbfunctions$internal$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40917 = arguments.length;
var i__4819__auto___40918 = (0);
while(true){
if((i__4819__auto___40918 < len__4818__auto___40917)){
args__4824__auto__.push((arguments[i__4819__auto___40918]));

var G__40919 = (i__4819__auto___40918 + (1));
i__4819__auto___40918 = G__40919;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_((function (){var or__4212__auto__ = fluree.db.dbfunctions.internal.nil_QMARK_(args);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.dbfunctions.internal.empty_QMARK_(args);
}
})())){
return (1);
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._STAR_,args);
}
}catch (e40916){var e = e40916;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"*",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._STAR_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._STAR_.cljs$lang$applyTo = (function (seq40915){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40915));
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.internal._SLASH_ = (function fluree$db$dbfunctions$internal$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40922 = arguments.length;
var i__4819__auto___40923 = (0);
while(true){
if((i__4819__auto___40923 < len__4818__auto___40922)){
args__4824__auto__.push((arguments[i__4819__auto___40923]));

var G__40924 = (i__4819__auto___40923 + (1));
i__4819__auto___40923 = G__40924;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{if(cljs.core.truth_(fluree.db.dbfunctions.internal.nil_QMARK_(args))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Function / takes at least one argument",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn], null));
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._SLASH_,args);
}
}catch (e40921){var e = e40921;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"/",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._SLASH_.cljs$lang$applyTo = (function (seq40920){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40920));
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.quot = (function fluree$db$dbfunctions$internal$quot(n,d){
try{return cljs.core.quot(n,d);
}catch (e40925){var e = e40925;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"quot",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.internal.mod = (function fluree$db$dbfunctions$internal$mod(n,d){
try{return cljs.core.mod(n,d);
}catch (e40926){var e = e40926;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"mod",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.internal.rem = (function fluree$db$dbfunctions$internal$rem(n,d){
try{return cljs.core.rem(n,d);
}catch (e40927){var e = e40927;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rem",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([n,d], 0));
}});
/**
 * Returns the ceiling of a number, as integer.
 */
fluree.db.dbfunctions.internal.ceil = (function fluree$db$dbfunctions$internal$ceil(num){
try{return (Math.ceil(num) | (0));
}catch (e40928){var e = e40928;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"ceil",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Returns the floor of a number, as integer.
 */
fluree.db.dbfunctions.internal.floor = (function fluree$db$dbfunctions$internal$floor(num){
try{return (Math.floor(num) | (0));
}catch (e40929){var e = e40929;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"floor",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([num], 0));
}});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.internal.get_all = (function fluree$db$dbfunctions$internal$get_all(start_subject,path){
try{var G__40935 = path;
var vec__40936 = G__40935;
var seq__40937 = cljs.core.seq(vec__40936);
var first__40938 = cljs.core.first(seq__40937);
var seq__40937__$1 = cljs.core.next(seq__40937);
var pred = first__40938;
var r = seq__40937__$1;
var subjects = cljs.core.PersistentHashSet.createAsIfByAssoc([start_subject]);
var G__40935__$1 = G__40935;
var subjects__$1 = subjects;
while(true){
var vec__40942 = G__40935__$1;
var seq__40943 = cljs.core.seq(vec__40942);
var first__40944 = cljs.core.first(seq__40943);
var seq__40943__$1 = cljs.core.next(seq__40943);
var pred__$1 = first__40944;
var r__$1 = seq__40943__$1;
var subjects__$2 = subjects__$1;
var next_subjects = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__40935__$1,subjects__$1,vec__40942,seq__40943,first__40944,seq__40943__$1,pred__$1,r__$1,subjects__$2,G__40935,vec__40936,seq__40937,first__40938,seq__40937__$1,pred,r,subjects){
return (function (acc,subject){
var sub_subjects = ((cljs.core.vector_QMARK_(subject))?cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(((function (G__40935__$1,subjects__$1,vec__40942,seq__40943,first__40944,seq__40943__$1,pred__$1,r__$1,subjects__$2,G__40935,vec__40936,seq__40937,first__40938,seq__40937__$1,pred,r,subjects){
return (function (p1__40930_SHARP_){
return fluree.db.dbfunctions.internal.get(p1__40930_SHARP_,pred__$1);
});})(G__40935__$1,subjects__$1,vec__40942,seq__40943,first__40944,seq__40943__$1,pred__$1,r__$1,subjects__$2,G__40935,vec__40936,seq__40937,first__40938,seq__40937__$1,pred,r,subjects))
,subject):fluree.db.dbfunctions.internal.get(subject,pred__$1));
if(((cljs.core.vector_QMARK_(sub_subjects)) || (cljs.core.set_QMARK_(sub_subjects)))){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,sub_subjects);
}
});})(G__40935__$1,subjects__$1,vec__40942,seq__40943,first__40944,seq__40943__$1,pred__$1,r__$1,subjects__$2,G__40935,vec__40936,seq__40937,first__40938,seq__40937__$1,pred,r,subjects))
,cljs.core.PersistentHashSet.EMPTY,subjects__$2);
if(cljs.core.truth_((function (){var and__4210__auto__ = r__$1;
if(and__4210__auto__){
return cljs.core.not_empty(next_subjects);
} else {
return and__4210__auto__;
}
})())){
var G__40945 = r__$1;
var G__40946 = next_subjects;
G__40935__$1 = G__40945;
subjects__$1 = G__40946;
continue;
} else {
return cljs.core.set(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.nil_QMARK_,next_subjects));
}
break;
}
}catch (e40931){var e = e40931;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-all",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([start_subject,path], 0));
}});
/**
 * Returns the value in a nested structure
 */
fluree.db.dbfunctions.internal.get_in = (function fluree$db$dbfunctions$internal$get_in(m,ks){
try{return fluree.db.dbfunctions.internal.get_all(m,ks);
}catch (e40947){var e = e40947;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"get-in",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([m,ks], 0));
}});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.contains_QMARK_ = (function fluree$db$dbfunctions$internal$contains_QMARK_(coll,key){
try{return cljs.core.contains_QMARK_(coll,key);
}catch (e40948){var e = e40948;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"contains?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Returns a hash-set of args.
 */
fluree.db.dbfunctions.internal.hash_set = (function fluree$db$dbfunctions$internal$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40951 = arguments.length;
var i__4819__auto___40952 = (0);
while(true){
if((i__4819__auto___40952 < len__4818__auto___40951)){
args__4824__auto__.push((arguments[i__4819__auto___40952]));

var G__40953 = (i__4819__auto___40952 + (1));
i__4819__auto___40952 = G__40953;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_set,args);
}catch (e40950){var e = e40950;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"hash-set",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal.hash_set.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal.hash_set.cljs$lang$applyTo = (function (seq40949){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40949));
}));

/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.internal.nth = (function fluree$db$dbfunctions$internal$nth(coll,key){
try{var coll_SINGLEQUOTE_ = ((cljs.core.set_QMARK_(coll))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,coll):coll);
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll_SINGLEQUOTE_,key);
}catch (e40954){var e = e40954;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"nth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([coll,key], 0));
}});
/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.internal._EQ__EQ_ = (function fluree$db$dbfunctions$internal$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___40957 = arguments.length;
var i__4819__auto___40958 = (0);
while(true){
if((i__4819__auto___40958 < len__4818__auto___40957)){
args__4824__auto__.push((arguments[i__4819__auto___40958]));

var G__40959 = (i__4819__auto___40958 + (1));
i__4819__auto___40958 = G__40959;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (args){
try{return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,args);
}catch (e40956){var e = e40956;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"==",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([args], 0));
}}));

(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.dbfunctions.internal._EQ__EQ_.cljs$lang$applyTo = (function (seq40955){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq40955));
}));

/**
 * Returns the next regex match, if any, of string to pattern, using java.util.regex.Matcher.find().  Uses re-groups to return the groups.
 */
fluree.db.dbfunctions.internal.re_find = (function fluree$db$dbfunctions$internal$re_find(pattern,string){
try{return cljs.core.re_find(cljs.core.re_pattern(pattern),string);
}catch (e40960){var e = e40960;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"re-find",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pattern,string], 0));
}});
fluree.db.dbfunctions.internal._QMARK_pO = (function fluree$db$dbfunctions$internal$_QMARK_pO(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41017){
var state_val_41018 = (state_41017[(1)]);
if((state_val_41018 === (7))){
var inst_40963 = (state_41017[(2)]);
var state_41017__$1 = state_41017;
var statearr_41019_41053 = state_41017__$1;
(statearr_41019_41053[(2)] = inst_40963);

(statearr_41019_41053[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (1))){
var state_41017__$1 = state_41017;
var statearr_41020_41054 = state_41017__$1;
(statearr_41020_41054[(2)] = null);

(statearr_41020_41054[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (4))){
var inst_40962 = (state_41017[(2)]);
var state_41017__$1 = (function (){var statearr_41021 = state_41017;
(statearr_41021[(7)] = inst_40962);

return statearr_41021;
})();
var statearr_41022_41055 = state_41017__$1;
(statearr_41022_41055[(2)] = null);

(statearr_41022_41055[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (15))){
var inst_41000 = (state_41017[(8)]);
var inst_40997 = (state_41017[(9)]);
var inst_40988 = (state_41017[(10)]);
var inst_40985 = (state_41017[(11)]);
var inst_40998 = (state_41017[(12)]);
var inst_40987 = (state_41017[(13)]);
var inst_41004 = (function (){var db = inst_40985;
var prevT = inst_40987;
var db_SINGLEQUOTE_ = inst_40988;
var prev_vals = inst_40997;
var fuel = inst_40998;
var G__40999 = inst_41000;
return (function (p1__40961_SHARP_){
var f = p1__40961_SHARP_;
return f.o;
});
})();
var inst_41005 = (inst_41004.cljs$core$IFn$_invoke$arity$1 ? inst_41004.cljs$core$IFn$_invoke$arity$1(inst_41000) : inst_41004.call(null,inst_41000));
var state_41017__$1 = state_41017;
var statearr_41023_41056 = state_41017__$1;
(statearr_41023_41056[(2)] = inst_41005);

(statearr_41023_41056[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (13))){
var inst_41000 = (state_41017[(8)]);
var inst_40997 = (state_41017[(9)]);
var inst_40996 = (state_41017[(2)]);
var inst_40997__$1 = fluree.db.util.async.throw_err(inst_40996);
var inst_40998 = fluree.db.dbfunctions.internal.count(inst_40997__$1);
var inst_41000__$1 = cljs.core.first(inst_40997__$1);
var inst_41001 = (inst_41000__$1 == null);
var state_41017__$1 = (function (){var statearr_41024 = state_41017;
(statearr_41024[(8)] = inst_41000__$1);

(statearr_41024[(9)] = inst_40997__$1);

(statearr_41024[(12)] = inst_40998);

return statearr_41024;
})();
if(cljs.core.truth_(inst_41001)){
var statearr_41025_41057 = state_41017__$1;
(statearr_41025_41057[(1)] = (14));

} else {
var statearr_41026_41058 = state_41017__$1;
(statearr_41026_41058[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (6))){
var inst_40972 = (state_41017[(2)]);
var state_41017__$1 = state_41017;
var statearr_41027_41059 = state_41017__$1;
(statearr_41027_41059[(2)] = inst_40972);

(statearr_41027_41059[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (3))){
var inst_41015 = (state_41017[(2)]);
var state_41017__$1 = state_41017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41017__$1,inst_41015);
} else {
if((state_val_41018 === (12))){
var inst_41012 = (state_41017[(2)]);
var _ = (function (){var statearr_41028 = state_41017;
(statearr_41028[(4)] = cljs.core.rest((state_41017[(4)])));

return statearr_41028;
})();
var state_41017__$1 = state_41017;
var statearr_41029_41060 = state_41017__$1;
(statearr_41029_41060[(2)] = inst_41012);

(statearr_41029_41060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (2))){
var _ = (function (){var statearr_41031 = state_41017;
(statearr_41031[(4)] = cljs.core.cons((9),(state_41017[(4)])));

return statearr_41031;
})();
var inst_40978 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40979 = typeof inst_40978 === 'string';
var state_41017__$1 = state_41017;
if(cljs.core.truth_(inst_40979)){
var statearr_41032_41061 = state_41017__$1;
(statearr_41032_41061[(1)] = (10));

} else {
var statearr_41033_41062 = state_41017__$1;
(statearr_41033_41062[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (11))){
var inst_40988 = (state_41017[(10)]);
var inst_40985 = (state_41017[(11)]);
var inst_40987 = (state_41017[(13)]);
var inst_40985__$1 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40986 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_40985__$1);
var inst_40987__$1 = fluree.db.dbfunctions.internal.inc(inst_40986);
var inst_40988__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40985__$1,cljs.core.cst$kw$t,inst_40987__$1);
var inst_40989 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40990 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40991 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_40992 = [inst_40990,inst_40991];
var inst_40993 = (new cljs.core.PersistentVector(null,2,(5),inst_40989,inst_40992,null));
var inst_40994 = fluree.db.dbproto._search(inst_40988__$1,inst_40993);
var state_41017__$1 = (function (){var statearr_41034 = state_41017;
(statearr_41034[(10)] = inst_40988__$1);

(statearr_41034[(11)] = inst_40985__$1);

(statearr_41034[(13)] = inst_40987__$1);

return statearr_41034;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41017__$1,(13),inst_40994);
} else {
if((state_val_41018 === (9))){
var _ = (function (){var statearr_41035 = state_41017;
(statearr_41035[(4)] = cljs.core.rest((state_41017[(4)])));

return statearr_41035;
})();
var state_41017__$1 = state_41017;
var ex41030 = (state_41017__$1[(2)]);
var statearr_41036_41063 = state_41017__$1;
(statearr_41036_41063[(5)] = ex41030);


var statearr_41037_41064 = state_41017__$1;
(statearr_41037_41064[(1)] = (4));

(statearr_41037_41064[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (5))){
var inst_40962 = (state_41017[(7)]);
var _ = (function (){var statearr_41038 = state_41017;
(statearr_41038[(4)] = cljs.core.cons((8),(state_41017[(4)])));

return statearr_41038;
})();
var inst_40969 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_40962,"?pO",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var ___$1 = (function (){var statearr_41039 = state_41017;
(statearr_41039[(4)] = cljs.core.rest((state_41017[(4)])));

return statearr_41039;
})();
var state_41017__$1 = state_41017;
var statearr_41040_41065 = state_41017__$1;
(statearr_41040_41065[(2)] = inst_40969);

(statearr_41040_41065[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (14))){
var state_41017__$1 = state_41017;
var statearr_41041_41066 = state_41017__$1;
(statearr_41041_41066[(2)] = null);

(statearr_41041_41066[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (16))){
var inst_40998 = (state_41017[(12)]);
var inst_41007 = (state_41017[(2)]);
var inst_41008 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41009 = [inst_41007,inst_40998];
var inst_41010 = (new cljs.core.PersistentVector(null,2,(5),inst_41008,inst_41009,null));
var state_41017__$1 = state_41017;
var statearr_41043_41067 = state_41017__$1;
(statearr_41043_41067[(2)] = inst_41010);

(statearr_41043_41067[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (10))){
var inst_40981 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40982 = [null,(0)];
var inst_40983 = (new cljs.core.PersistentVector(null,2,(5),inst_40981,inst_40982,null));
var state_41017__$1 = state_41017;
var statearr_41044_41068 = state_41017__$1;
(statearr_41044_41068[(2)] = inst_40983);

(statearr_41044_41068[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41018 === (8))){
var _ = (function (){var statearr_41045 = state_41017;
(statearr_41045[(4)] = cljs.core.rest((state_41017[(4)])));

return statearr_41045;
})();
var state_41017__$1 = state_41017;
var ex41042 = (state_41017__$1[(2)]);
var statearr_41046_41069 = state_41017__$1;
(statearr_41046_41069[(5)] = ex41042);


var statearr_41047_41070 = state_41017__$1;
(statearr_41047_41070[(1)] = (7));

(statearr_41047_41070[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____0 = (function (){
var statearr_41048 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41048[(0)] = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__);

(statearr_41048[(1)] = (1));

return statearr_41048;
});
var fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____1 = (function (state_41017){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41017);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41049){var ex__10753__auto__ = e41049;
var statearr_41050_41071 = state_41017;
(statearr_41050_41071[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41017[(4)]))){
var statearr_41051_41072 = state_41017;
(statearr_41051_41072[(1)] = cljs.core.first((state_41017[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41073 = state_41017;
state_41017 = G__41073;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__ = function(state_41017){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____1.call(this,state_41017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_pO_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41052 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41052[(6)] = c__10876__auto__);

return statearr_41052;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.dbfunctions.internal.max_pred_val = (function fluree$db$dbfunctions$internal$max_pred_val(db,pred_name,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41125){
var state_val_41126 = (state_41125[(1)]);
if((state_val_41126 === (7))){
var inst_41075 = (state_41125[(2)]);
var state_41125__$1 = state_41125;
var statearr_41127_41156 = state_41125__$1;
(statearr_41127_41156[(2)] = inst_41075);

(statearr_41127_41156[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (1))){
var state_41125__$1 = state_41125;
var statearr_41128_41157 = state_41125__$1;
(statearr_41128_41157[(2)] = null);

(statearr_41128_41157[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (4))){
var inst_41074 = (state_41125[(2)]);
var state_41125__$1 = (function (){var statearr_41129 = state_41125;
(statearr_41129[(7)] = inst_41074);

return statearr_41129;
})();
var statearr_41130_41158 = state_41125__$1;
(statearr_41130_41158[(2)] = null);

(statearr_41130_41158[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (13))){
var inst_41120 = (state_41125[(2)]);
var _ = (function (){var statearr_41131 = state_41125;
(statearr_41131[(4)] = cljs.core.rest((state_41125[(4)])));

return statearr_41131;
})();
var state_41125__$1 = state_41125;
var statearr_41132_41159 = state_41125__$1;
(statearr_41132_41159[(2)] = inst_41120);

(statearr_41132_41159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (6))){
var inst_41084 = (state_41125[(2)]);
var state_41125__$1 = state_41125;
var statearr_41133_41160 = state_41125__$1;
(statearr_41133_41160[(2)] = inst_41084);

(statearr_41133_41160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (3))){
var inst_41123 = (state_41125[(2)]);
var state_41125__$1 = state_41125;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41125__$1,inst_41123);
} else {
if((state_val_41126 === (12))){
var inst_41107 = (state_41125[(8)]);
var inst_41116 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41117 = [null,inst_41107];
var inst_41118 = (new cljs.core.PersistentVector(null,2,(5),inst_41116,inst_41117,null));
var state_41125__$1 = state_41125;
var statearr_41134_41161 = state_41125__$1;
(statearr_41134_41161[(2)] = inst_41118);

(statearr_41134_41161[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (2))){
var _ = (function (){var statearr_41136 = state_41125;
(statearr_41136[(4)] = cljs.core.cons((9),(state_41125[(4)])));

return statearr_41136;
})();
var inst_41093 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41094 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41096 = [null,pred_name,"?o"];
var inst_41097 = (new cljs.core.PersistentVector(null,3,(5),inst_41095,inst_41096,null));
var inst_41098 = [inst_41097];
var inst_41099 = (new cljs.core.PersistentVector(null,1,(5),inst_41094,inst_41098,null));
var inst_41100 = ["?o",inst_41099,opts];
var inst_41101 = cljs.core.PersistentHashMap.fromArrays(inst_41093,inst_41100);
var inst_41102 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(db,inst_41101);
var state_41125__$1 = state_41125;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41125__$1,(10),inst_41102);
} else {
if((state_val_41126 === (11))){
var inst_41106 = (state_41125[(9)]);
var inst_41107 = (state_41125[(8)]);
var inst_41111 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41112 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_41106);
var inst_41113 = [inst_41112,inst_41107];
var inst_41114 = (new cljs.core.PersistentVector(null,2,(5),inst_41111,inst_41113,null));
var state_41125__$1 = state_41125;
var statearr_41137_41162 = state_41125__$1;
(statearr_41137_41162[(2)] = inst_41114);

(statearr_41137_41162[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (9))){
var _ = (function (){var statearr_41138 = state_41125;
(statearr_41138[(4)] = cljs.core.rest((state_41125[(4)])));

return statearr_41138;
})();
var state_41125__$1 = state_41125;
var ex41135 = (state_41125__$1[(2)]);
var statearr_41139_41163 = state_41125__$1;
(statearr_41139_41163[(5)] = ex41135);


var statearr_41140_41164 = state_41125__$1;
(statearr_41140_41164[(1)] = (4));

(statearr_41140_41164[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (5))){
var inst_41074 = (state_41125[(7)]);
var _ = (function (){var statearr_41142 = state_41125;
(statearr_41142[(4)] = cljs.core.cons((8),(state_41125[(4)])));

return statearr_41142;
})();
var inst_41081 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41074,"max-pred-val",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([pred_name], 0));
var ___$1 = (function (){var statearr_41143 = state_41125;
(statearr_41143[(4)] = cljs.core.rest((state_41125[(4)])));

return statearr_41143;
})();
var state_41125__$1 = state_41125;
var statearr_41144_41165 = state_41125__$1;
(statearr_41144_41165[(2)] = inst_41081);

(statearr_41144_41165[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (10))){
var inst_41106 = (state_41125[(9)]);
var inst_41104 = (state_41125[(2)]);
var inst_41105 = fluree.db.util.async.throw_err(inst_41104);
var inst_41106__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41105,(0),null);
var inst_41107 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41105,(1),null);
var inst_41108 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_41106__$1);
var inst_41109 = cljs.core.not(inst_41108);
var state_41125__$1 = (function (){var statearr_41145 = state_41125;
(statearr_41145[(9)] = inst_41106__$1);

(statearr_41145[(8)] = inst_41107);

return statearr_41145;
})();
if(inst_41109){
var statearr_41146_41166 = state_41125__$1;
(statearr_41146_41166[(1)] = (11));

} else {
var statearr_41147_41167 = state_41125__$1;
(statearr_41147_41167[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41126 === (8))){
var _ = (function (){var statearr_41148 = state_41125;
(statearr_41148[(4)] = cljs.core.rest((state_41125[(4)])));

return statearr_41148;
})();
var state_41125__$1 = state_41125;
var ex41141 = (state_41125__$1[(2)]);
var statearr_41149_41168 = state_41125__$1;
(statearr_41149_41168[(5)] = ex41141);


var statearr_41150_41169 = state_41125__$1;
(statearr_41150_41169[(1)] = (7));

(statearr_41150_41169[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____0 = (function (){
var statearr_41151 = [null,null,null,null,null,null,null,null,null,null];
(statearr_41151[(0)] = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__);

(statearr_41151[(1)] = (1));

return statearr_41151;
});
var fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____1 = (function (state_41125){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41125);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41152){var ex__10753__auto__ = e41152;
var statearr_41153_41170 = state_41125;
(statearr_41153_41170[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41125[(4)]))){
var statearr_41154_41171 = state_41125;
(statearr_41154_41171[(1)] = cljs.core.first((state_41125[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41172 = state_41125;
state_41125 = G__41172;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__ = function(state_41125){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____1.call(this,state_41125);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$max_pred_val_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41155 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41155[(6)] = c__10876__auto__);

return statearr_41155;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.dbfunctions.internal.valid_email_QMARK_ = (function fluree$db$dbfunctions$internal$valid_email_QMARK_(email){
try{var pattern = /[a-z0-9!#$%&'*+\/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&'*+\/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?/;
return cljs.core.boolean$((function (){var and__4210__auto__ = typeof email === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(pattern,email);
} else {
return and__4210__auto__;
}
})());
}catch (e41173){var e = e41173;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"valid-email?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([email], 0));
}});
/**
 * Retrieves all P-O Pairs for subject, potential additional params if specified.
 */
fluree.db.dbfunctions.internal._QMARK_s = (function fluree$db$dbfunctions$internal$_QMARK_s(var_args){
var G__41175 = arguments.length;
switch (G__41175) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41245){
var state_val_41246 = (state_41245[(1)]);
if((state_val_41246 === (7))){
var inst_41177 = (state_41245[(2)]);
var state_41245__$1 = state_41245;
var statearr_41247_41291 = state_41245__$1;
(statearr_41247_41291[(2)] = inst_41177);

(statearr_41247_41291[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (20))){
var inst_41221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41222 = ["*"];
var inst_41223 = (new cljs.core.PersistentVector(null,1,(5),inst_41221,inst_41222,null));
var state_41245__$1 = state_41245;
var statearr_41248_41292 = state_41245__$1;
(statearr_41248_41292[(2)] = inst_41223);

(statearr_41248_41292[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (1))){
var state_41245__$1 = state_41245;
var statearr_41249_41293 = state_41245__$1;
(statearr_41249_41293[(2)] = null);

(statearr_41249_41293[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (4))){
var inst_41176 = (state_41245[(2)]);
var state_41245__$1 = (function (){var statearr_41250 = state_41245;
(statearr_41250[(7)] = inst_41176);

return statearr_41250;
})();
var statearr_41251_41294 = state_41245__$1;
(statearr_41251_41294[(2)] = null);

(statearr_41251_41294[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (15))){
var inst_41240 = (state_41245[(2)]);
var _ = (function (){var statearr_41252 = state_41245;
(statearr_41252[(4)] = cljs.core.rest((state_41245[(4)])));

return statearr_41252;
})();
var state_41245__$1 = state_41245;
var statearr_41253_41295 = state_41245__$1;
(statearr_41253_41295[(2)] = inst_41240);

(statearr_41253_41295[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (21))){
var inst_41204 = (state_41245[(8)]);
var inst_41211 = (state_41245[(9)]);
var inst_41225 = (state_41245[(2)]);
var inst_41226 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41227 = cljs.core.PersistentHashMap.EMPTY;
var inst_41228 = [inst_41225,inst_41211,inst_41227];
var inst_41229 = cljs.core.PersistentHashMap.fromArrays(inst_41226,inst_41228);
var inst_41230 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41204,inst_41229);
var state_41245__$1 = state_41245;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41245__$1,(22),inst_41230);
} else {
if((state_val_41246 === (13))){
var inst_41199 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41245__$1 = state_41245;
var statearr_41254_41296 = state_41245__$1;
(statearr_41254_41296[(2)] = inst_41199);

(statearr_41254_41296[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (22))){
var inst_41232 = (state_41245[(2)]);
var inst_41233 = fluree.db.util.async.throw_err(inst_41232);
var inst_41234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41233,(0),null);
var inst_41235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41233,(1),null);
var inst_41236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41237 = [inst_41234,inst_41235];
var inst_41238 = (new cljs.core.PersistentVector(null,2,(5),inst_41236,inst_41237,null));
var state_41245__$1 = state_41245;
var statearr_41255_41297 = state_41245__$1;
(statearr_41255_41297[(2)] = inst_41238);

(statearr_41255_41297[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (6))){
var inst_41186 = (state_41245[(2)]);
var state_41245__$1 = state_41245;
var statearr_41256_41298 = state_41245__$1;
(statearr_41256_41298[(2)] = inst_41186);

(statearr_41256_41298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (17))){
var inst_41208 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41209 = fluree.db.dbfunctions.internal.get(inst_41208,cljs.core.cst$kw$_id);
var state_41245__$1 = state_41245;
var statearr_41257_41299 = state_41245__$1;
(statearr_41257_41299[(2)] = inst_41209);

(statearr_41257_41299[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (3))){
var inst_41243 = (state_41245[(2)]);
var state_41245__$1 = state_41245;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41245__$1,inst_41243);
} else {
if((state_val_41246 === (12))){
var inst_41197 = (state_41245[(2)]);
var state_41245__$1 = state_41245;
if(cljs.core.truth_(inst_41197)){
var statearr_41258_41300 = state_41245__$1;
(statearr_41258_41300[(1)] = (13));

} else {
var statearr_41259_41301 = state_41245__$1;
(statearr_41259_41301[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (2))){
var inst_41192 = (state_41245[(10)]);
var _ = (function (){var statearr_41260 = state_41245;
(statearr_41260[(4)] = cljs.core.cons((9),(state_41245[(4)])));

return statearr_41260;
})();
var inst_41192__$1 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41245__$1 = (function (){var statearr_41261 = state_41245;
(statearr_41261[(10)] = inst_41192__$1);

return statearr_41261;
})();
if(cljs.core.truth_(inst_41192__$1)){
var statearr_41262_41302 = state_41245__$1;
(statearr_41262_41302[(1)] = (10));

} else {
var statearr_41263_41303 = state_41245__$1;
(statearr_41263_41303[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (19))){
var inst_41213 = cljs.core.PersistentVector.EMPTY;
var inst_41214 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41215 = ["*"];
var inst_41216 = (new cljs.core.PersistentVector(null,1,(5),inst_41214,inst_41215,null));
var inst_41217 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41218 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41216,inst_41217);
var inst_41219 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41213,inst_41218);
var state_41245__$1 = state_41245;
var statearr_41265_41304 = state_41245__$1;
(statearr_41265_41304[(2)] = inst_41219);

(statearr_41265_41304[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (11))){
var inst_41192 = (state_41245[(10)]);
var state_41245__$1 = state_41245;
var statearr_41266_41305 = state_41245__$1;
(statearr_41266_41305[(2)] = inst_41192);

(statearr_41266_41305[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (9))){
var _ = (function (){var statearr_41267 = state_41245;
(statearr_41267[(4)] = cljs.core.rest((state_41245[(4)])));

return statearr_41267;
})();
var state_41245__$1 = state_41245;
var ex41264 = (state_41245__$1[(2)]);
var statearr_41268_41306 = state_41245__$1;
(statearr_41268_41306[(5)] = ex41264);


var statearr_41269_41307 = state_41245__$1;
(statearr_41269_41307[(1)] = (4));

(statearr_41269_41307[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (5))){
var inst_41176 = (state_41245[(7)]);
var _ = (function (){var statearr_41270 = state_41245;
(statearr_41270[(4)] = cljs.core.cons((8),(state_41245[(4)])));

return statearr_41270;
})();
var inst_41183 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41176,"?s",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var ___$1 = (function (){var statearr_41271 = state_41245;
(statearr_41271[(4)] = cljs.core.rest((state_41245[(4)])));

return statearr_41271;
})();
var state_41245__$1 = state_41245;
var statearr_41272_41308 = state_41245__$1;
(statearr_41272_41308[(2)] = inst_41183);

(statearr_41272_41308[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (14))){
var inst_41205 = (state_41245[(11)]);
var inst_41204 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41205__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41245__$1 = (function (){var statearr_41273 = state_41245;
(statearr_41273[(8)] = inst_41204);

(statearr_41273[(11)] = inst_41205__$1);

return statearr_41273;
})();
if(cljs.core.truth_(inst_41205__$1)){
var statearr_41274_41309 = state_41245__$1;
(statearr_41274_41309[(1)] = (16));

} else {
var statearr_41275_41310 = state_41245__$1;
(statearr_41275_41310[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (16))){
var inst_41205 = (state_41245[(11)]);
var state_41245__$1 = state_41245;
var statearr_41276_41311 = state_41245__$1;
(statearr_41276_41311[(2)] = inst_41205);

(statearr_41276_41311[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (10))){
var inst_41194 = fluree.db.dbfunctions.internal.empty_QMARK_(additional_params);
var state_41245__$1 = state_41245;
var statearr_41278_41312 = state_41245__$1;
(statearr_41278_41312[(2)] = inst_41194);

(statearr_41278_41312[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (18))){
var inst_41211 = (state_41245[(2)]);
var state_41245__$1 = (function (){var statearr_41279 = state_41245;
(statearr_41279[(9)] = inst_41211);

return statearr_41279;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41280_41313 = state_41245__$1;
(statearr_41280_41313[(1)] = (19));

} else {
var statearr_41281_41314 = state_41245__$1;
(statearr_41281_41314[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41246 === (8))){
var _ = (function (){var statearr_41282 = state_41245;
(statearr_41282[(4)] = cljs.core.rest((state_41245[(4)])));

return statearr_41282;
})();
var state_41245__$1 = state_41245;
var ex41277 = (state_41245__$1[(2)]);
var statearr_41283_41315 = state_41245__$1;
(statearr_41283_41315[(5)] = ex41277);


var statearr_41284_41316 = state_41245__$1;
(statearr_41284_41316[(1)] = (7));

(statearr_41284_41316[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10750__auto____0 = (function (){
var statearr_41285 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41285[(0)] = fluree$db$dbfunctions$internal$state_machine__10750__auto__);

(statearr_41285[(1)] = (1));

return statearr_41285;
});
var fluree$db$dbfunctions$internal$state_machine__10750__auto____1 = (function (state_41245){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41245);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41286){var ex__10753__auto__ = e41286;
var statearr_41287_41317 = state_41245;
(statearr_41287_41317[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41245[(4)]))){
var statearr_41288_41318 = state_41245;
(statearr_41288_41318[(1)] = cljs.core.first((state_41245[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41319 = state_41245;
state_41245 = G__41319;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10750__auto__ = function(state_41245){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____1.call(this,state_41245);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41289 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41289[(6)] = c__10876__auto__);

return statearr_41289;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Retrieves all P-O Pairs for predicate, potential additional params if specified
 */
fluree.db.dbfunctions.internal._QMARK_p = (function fluree$db$dbfunctions$internal$_QMARK_p(var_args){
var G__41321 = arguments.length;
switch (G__41321) {
case 1:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_params){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41365){
var state_val_41366 = (state_41365[(1)]);
if((state_val_41366 === (7))){
var inst_41343 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41344 = ["*"];
var inst_41345 = (new cljs.core.PersistentVector(null,1,(5),inst_41343,inst_41344,null));
var state_41365__$1 = state_41365;
var statearr_41367_41387 = state_41365__$1;
(statearr_41367_41387[(2)] = inst_41345);

(statearr_41367_41387[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (1))){
var state_41365__$1 = state_41365;
var statearr_41368_41388 = state_41365__$1;
(statearr_41368_41388[(2)] = null);

(statearr_41368_41388[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (4))){
var inst_41322 = (state_41365[(2)]);
var inst_41323 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41322,"?p",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object",additional_params], 0));
var state_41365__$1 = state_41365;
var statearr_41369_41389 = state_41365__$1;
(statearr_41369_41389[(2)] = inst_41323);

(statearr_41369_41389[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (6))){
var inst_41335 = cljs.core.PersistentVector.EMPTY;
var inst_41336 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41337 = ["*"];
var inst_41338 = (new cljs.core.PersistentVector(null,1,(5),inst_41336,inst_41337,null));
var inst_41339 = fluree.db.dbfunctions.internal.parse_select_map(additional_params);
var inst_41340 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_41338,inst_41339);
var inst_41341 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41335,inst_41340);
var state_41365__$1 = state_41365;
var statearr_41370_41390 = state_41365__$1;
(statearr_41370_41390[(2)] = inst_41341);

(statearr_41370_41390[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (3))){
var inst_41363 = (state_41365[(2)]);
var state_41365__$1 = state_41365;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41365__$1,inst_41363);
} else {
if((state_val_41366 === (2))){
var _ = (function (){var statearr_41372 = state_41365;
(statearr_41372[(4)] = cljs.core.cons((5),(state_41365[(4)])));

return statearr_41372;
})();
var inst_41332 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41333 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_41365__$1 = (function (){var statearr_41373 = state_41365;
(statearr_41373[(7)] = inst_41332);

(statearr_41373[(8)] = inst_41333);

return statearr_41373;
})();
if(cljs.core.truth_(additional_params)){
var statearr_41374_41391 = state_41365__$1;
(statearr_41374_41391[(1)] = (6));

} else {
var statearr_41375_41392 = state_41365__$1;
(statearr_41375_41392[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (9))){
var inst_41354 = (state_41365[(2)]);
var inst_41355 = fluree.db.util.async.throw_err(inst_41354);
var inst_41356 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41355,(0),null);
var inst_41357 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41355,(1),null);
var inst_41358 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41359 = [inst_41356,inst_41357];
var inst_41360 = (new cljs.core.PersistentVector(null,2,(5),inst_41358,inst_41359,null));
var _ = (function (){var statearr_41376 = state_41365;
(statearr_41376[(4)] = cljs.core.rest((state_41365[(4)])));

return statearr_41376;
})();
var state_41365__$1 = state_41365;
var statearr_41377_41393 = state_41365__$1;
(statearr_41377_41393[(2)] = inst_41360);

(statearr_41377_41393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (5))){
var _ = (function (){var statearr_41378 = state_41365;
(statearr_41378[(4)] = cljs.core.rest((state_41365[(4)])));

return statearr_41378;
})();
var state_41365__$1 = state_41365;
var ex41371 = (state_41365__$1[(2)]);
var statearr_41379_41394 = state_41365__$1;
(statearr_41379_41394[(5)] = ex41371);


var statearr_41380_41395 = state_41365__$1;
(statearr_41380_41395[(1)] = (4));

(statearr_41380_41395[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41366 === (8))){
var inst_41332 = (state_41365[(7)]);
var inst_41333 = (state_41365[(8)]);
var inst_41347 = (state_41365[(2)]);
var inst_41348 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41349 = cljs.core.PersistentHashMap.EMPTY;
var inst_41350 = [inst_41347,inst_41333,inst_41349];
var inst_41351 = cljs.core.PersistentHashMap.fromArrays(inst_41348,inst_41350);
var inst_41352 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41332,inst_41351);
var state_41365__$1 = state_41365;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41365__$1,(9),inst_41352);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$state_machine__10750__auto____0 = (function (){
var statearr_41381 = [null,null,null,null,null,null,null,null,null];
(statearr_41381[(0)] = fluree$db$dbfunctions$internal$state_machine__10750__auto__);

(statearr_41381[(1)] = (1));

return statearr_41381;
});
var fluree$db$dbfunctions$internal$state_machine__10750__auto____1 = (function (state_41365){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41365);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41382){var ex__10753__auto__ = e41382;
var statearr_41383_41396 = state_41365;
(statearr_41383_41396[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41365[(4)]))){
var statearr_41384_41397 = state_41365;
(statearr_41384_41397[(1)] = cljs.core.first((state_41365[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41398 = state_41365;
state_41365 = G__41398;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$state_machine__10750__auto__ = function(state_41365){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$state_machine__10750__auto____1.call(this,state_41365);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41385 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41385[(6)] = c__10876__auto__);

return statearr_41385;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.dbfunctions.internal._QMARK_p.cljs$lang$maxFixedArity = 2);

fluree.db.dbfunctions.internal._QMARK_user_id_from_auth = (function fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41442){
var state_val_41443 = (state_41442[(1)]);
if((state_val_41443 === (1))){
var state_41442__$1 = state_41442;
var statearr_41444_41458 = state_41442__$1;
(statearr_41444_41458[(2)] = null);

(statearr_41444_41458[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41443 === (2))){
var _ = (function (){var statearr_41445 = state_41442;
(statearr_41445[(4)] = cljs.core.cons((5),(state_41442[(4)])));

return statearr_41445;
})();
var inst_41409 = [cljs.core.cst$kw$select,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_41410 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41411 = ["_user/_auth"];
var inst_41412 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41413 = ["*"];
var inst_41414 = (new cljs.core.PersistentVector(null,1,(5),inst_41412,inst_41413,null));
var inst_41415 = [inst_41414];
var inst_41416 = cljs.core.PersistentHashMap.fromArrays(inst_41411,inst_41415);
var inst_41417 = [inst_41416];
var inst_41418 = (new cljs.core.PersistentVector(null,1,(5),inst_41410,inst_41417,null));
var inst_41419 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41420 = cljs.core.PersistentHashMap.EMPTY;
var inst_41421 = [inst_41418,inst_41419,inst_41420];
var inst_41422 = cljs.core.PersistentHashMap.fromArrays(inst_41409,inst_41421);
var inst_41423 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41424 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41423,inst_41422);
var state_41442__$1 = state_41442;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41442__$1,(6),inst_41424);
} else {
if((state_val_41443 === (3))){
var inst_41440 = (state_41442[(2)]);
var state_41442__$1 = state_41442;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41442__$1,inst_41440);
} else {
if((state_val_41443 === (4))){
var inst_41399 = (state_41442[(2)]);
var inst_41400 = fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(inst_41399,"?user_id-from-auth",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Context Object"], 0));
var state_41442__$1 = state_41442;
var statearr_41447_41459 = state_41442__$1;
(statearr_41447_41459[(2)] = inst_41400);

(statearr_41447_41459[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41443 === (5))){
var _ = (function (){var statearr_41448 = state_41442;
(statearr_41448[(4)] = cljs.core.rest((state_41442[(4)])));

return statearr_41448;
})();
var state_41442__$1 = state_41442;
var ex41446 = (state_41442__$1[(2)]);
var statearr_41449_41460 = state_41442__$1;
(statearr_41449_41460[(5)] = ex41446);


var statearr_41450_41461 = state_41442__$1;
(statearr_41450_41461[(1)] = (4));

(statearr_41450_41461[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_41443 === (6))){
var inst_41426 = (state_41442[(2)]);
var inst_41427 = fluree.db.util.async.throw_err(inst_41426);
var inst_41428 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41427,(0),null);
var inst_41429 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41427,(1),null);
var inst_41430 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41431 = ["_user/_auth","_id"];
var inst_41432 = (new cljs.core.PersistentVector(null,2,(5),inst_41430,inst_41431,null));
var inst_41433 = fluree.db.dbfunctions.internal.get_in(inst_41428,inst_41432);
var inst_41434 = cljs.core.first(inst_41433);
var inst_41435 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41436 = [inst_41434,inst_41429];
var inst_41437 = (new cljs.core.PersistentVector(null,2,(5),inst_41435,inst_41436,null));
var _ = (function (){var statearr_41451 = state_41442;
(statearr_41451[(4)] = cljs.core.rest((state_41442[(4)])));

return statearr_41451;
})();
var state_41442__$1 = state_41442;
var statearr_41452_41462 = state_41442__$1;
(statearr_41452_41462[(2)] = inst_41437);

(statearr_41452_41462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____0 = (function (){
var statearr_41453 = [null,null,null,null,null,null,null];
(statearr_41453[(0)] = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__);

(statearr_41453[(1)] = (1));

return statearr_41453;
});
var fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____1 = (function (state_41442){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41442);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41454){var ex__10753__auto__ = e41454;
var statearr_41455_41463 = state_41442;
(statearr_41455_41463[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41442[(4)]))){
var statearr_41456_41464 = state_41442;
(statearr_41456_41464[(1)] = cljs.core.first((state_41442[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41465 = state_41442;
state_41442 = G__41465;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__ = function(state_41442){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____1.call(this,state_41442);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_user_id_from_auth_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41457 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41457[(6)] = c__10876__auto__);

return statearr_41457;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.dbfunctions.internal._QMARK_auth_id = (function fluree$db$dbfunctions$internal$_QMARK_auth_id(_QMARK_ctx){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41482){
var state_val_41483 = (state_41482[(1)]);
if((state_val_41483 === (1))){
var state_41482__$1 = state_41482;
var statearr_41484_41498 = state_41482__$1;
(statearr_41484_41498[(2)] = null);

(statearr_41484_41498[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41483 === (2))){
var _ = (function (){var statearr_41485 = state_41482;
(statearr_41485[(4)] = cljs.core.cons((5),(state_41482[(4)])));

return statearr_41485;
})();
var inst_41472 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41473 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_41474 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(inst_41473,inst_41472);
var state_41482__$1 = state_41482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41482__$1,(6),inst_41474);
} else {
if((state_val_41483 === (3))){
var inst_41480 = (state_41482[(2)]);
var state_41482__$1 = state_41482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41482__$1,inst_41480);
} else {
if((state_val_41483 === (4))){
var inst_41466 = (state_41482[(2)]);
var state_41482__$1 = state_41482;
var statearr_41487_41499 = state_41482__$1;
(statearr_41487_41499[(2)] = inst_41466);

(statearr_41487_41499[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41483 === (5))){
var _ = (function (){var statearr_41488 = state_41482;
(statearr_41488[(4)] = cljs.core.rest((state_41482[(4)])));

return statearr_41488;
})();
var state_41482__$1 = state_41482;
var ex41486 = (state_41482__$1[(2)]);
var statearr_41489_41500 = state_41482__$1;
(statearr_41489_41500[(5)] = ex41486);


if((ex41486 instanceof Error)){
var statearr_41490_41501 = state_41482__$1;
(statearr_41490_41501[(1)] = (4));

(statearr_41490_41501[(5)] = null);

} else {
throw ex41486;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41483 === (6))){
var inst_41476 = (state_41482[(2)]);
var inst_41477 = fluree.db.util.async.throw_err(inst_41476);
var _ = (function (){var statearr_41491 = state_41482;
(statearr_41491[(4)] = cljs.core.rest((state_41482[(4)])));

return statearr_41491;
})();
var state_41482__$1 = state_41482;
var statearr_41492_41502 = state_41482__$1;
(statearr_41492_41502[(2)] = inst_41477);

(statearr_41492_41502[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____0 = (function (){
var statearr_41493 = [null,null,null,null,null,null,null];
(statearr_41493[(0)] = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__);

(statearr_41493[(1)] = (1));

return statearr_41493;
});
var fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____1 = (function (state_41482){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41482);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41494){var ex__10753__auto__ = e41494;
var statearr_41495_41503 = state_41482;
(statearr_41495_41503[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41482[(4)]))){
var statearr_41496_41504 = state_41482;
(statearr_41496_41504[(1)] = cljs.core.first((state_41482[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41505 = state_41482;
state_41482 = G__41505;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__ = function(state_41482){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____1.call(this,state_41482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$_QMARK_auth_id_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41497 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41497[(6)] = c__10876__auto__);

return statearr_41497;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Given an array of flakes, returns the sum of the objects of the true flakes
 */
fluree.db.dbfunctions.internal.objT = (function fluree$db$dbfunctions$internal$objT(flakes){
try{var trueF = cljs.core.filterv((function (p1__41506_SHARP_){
return p1__41506_SHARP_.op === true;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41507_SHARP_){
return p1__41507_SHARP_.o;
}),trueF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41508){var e = e41508;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objT",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
/**
 * Given an array of flakes, returns the sum of the objects of the false flakes
 */
fluree.db.dbfunctions.internal.objF = (function fluree$db$dbfunctions$internal$objF(flakes){
try{var falseF = cljs.core.filterv((function (p1__41509_SHARP_){
return p1__41509_SHARP_.op === false;
}),flakes);
var objs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__41510_SHARP_){
return p1__41510_SHARP_.o;
}),falseF);
var sum = cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core._PLUS_,objs);
return sum;
}catch (e41511){var e = e41511;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"objF",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([flakes], 0));
}});
fluree.db.dbfunctions.internal.rand = (function fluree$db$dbfunctions$internal$rand(instant,max_SINGLEQUOTE_){
try{var base = (new java.util.Random(instant)).nextDouble();
var num = ((function (){var G__41513 = fluree.db.dbfunctions.internal._STAR_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([base,max_SINGLEQUOTE_], 0));
return Math.floor(G__41513);
})() | (0));
return num;
}catch (e41512){var e = e41512;
return fluree.db.dbfunctions.internal.function_error.cljs$core$IFn$_invoke$arity$variadic(e,"rand",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instant,max_SINGLEQUOTE_], 0));
}});
/**
 * Returns new-val if existing-val is equal to compare-val, else throws exception
 */
fluree.db.dbfunctions.internal.cas = (function fluree$db$dbfunctions$internal$cas(_QMARK_ctx,compare_val,new_val){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_41593){
var state_val_41594 = (state_41593[(1)]);
if((state_val_41594 === (7))){
var inst_41532 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - subject id could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41533 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41534 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41535 = cljs.core.PersistentHashMap.fromArrays(inst_41533,inst_41534);
var inst_41536 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41532,inst_41535);
var inst_41537 = (function(){throw inst_41536})();
var state_41593__$1 = state_41593;
var statearr_41595_41630 = state_41593__$1;
(statearr_41595_41630[(2)] = inst_41537);

(statearr_41595_41630[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (1))){
var state_41593__$1 = state_41593;
var statearr_41596_41631 = state_41593__$1;
(statearr_41596_41631[(2)] = null);

(statearr_41596_41631[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (4))){
var inst_41514 = (state_41593[(2)]);
var state_41593__$1 = state_41593;
var statearr_41597_41632 = state_41593__$1;
(statearr_41597_41632[(2)] = inst_41514);

(statearr_41597_41632[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (15))){
var inst_41577 = (state_41593[(7)]);
var inst_41573 = (state_41593[(2)]);
var inst_41574 = fluree.db.util.async.throw_err(inst_41573);
var inst_41575 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41574,(0),null);
var inst_41576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41574,(1),null);
var inst_41577__$1 = cljs.core.first(inst_41575);
var inst_41578 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_41577__$1,compare_val);
var state_41593__$1 = (function (){var statearr_41598 = state_41593;
(statearr_41598[(7)] = inst_41577__$1);

(statearr_41598[(8)] = inst_41576);

return statearr_41598;
})();
if(inst_41578){
var statearr_41599_41633 = state_41593__$1;
(statearr_41599_41633[(1)] = (16));

} else {
var statearr_41600_41634 = state_41593__$1;
(statearr_41600_41634[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (13))){
var state_41593__$1 = state_41593;
var statearr_41601_41635 = state_41593__$1;
(statearr_41601_41635[(2)] = null);

(statearr_41601_41635[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (6))){
var state_41593__$1 = state_41593;
var statearr_41602_41636 = state_41593__$1;
(statearr_41602_41636[(2)] = null);

(statearr_41602_41636[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (17))){
var inst_41577 = (state_41593[(7)]);
var inst_41581 = ["The current value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_41577)," does not match the comparison value: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(compare_val),"."].join('');
var inst_41582 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41583 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41584 = cljs.core.PersistentHashMap.fromArrays(inst_41582,inst_41583);
var inst_41585 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41581,inst_41584);
var inst_41586 = (function(){throw inst_41585})();
var state_41593__$1 = state_41593;
var statearr_41603_41637 = state_41593__$1;
(statearr_41603_41637[(2)] = inst_41586);

(statearr_41603_41637[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (3))){
var inst_41591 = (state_41593[(2)]);
var state_41593__$1 = state_41593;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41593__$1,inst_41591);
} else {
if((state_val_41594 === (12))){
var inst_41529 = (state_41593[(9)]);
var inst_41552 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas on a multi-cardinality predicate: ",inst_41529], 0));
var inst_41553 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41554 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41555 = cljs.core.PersistentHashMap.fromArrays(inst_41553,inst_41554);
var inst_41556 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41552,inst_41555);
var inst_41557 = (function(){throw inst_41556})();
var state_41593__$1 = state_41593;
var statearr_41604_41638 = state_41593__$1;
(statearr_41604_41638[(2)] = inst_41557);

(statearr_41604_41638[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (2))){
var inst_41526 = (state_41593[(10)]);
var inst_41528 = (state_41593[(11)]);
var inst_41527 = (state_41593[(12)]);
var _ = (function (){var statearr_41605 = state_41593;
(statearr_41605[(4)] = cljs.core.cons((5),(state_41593[(4)])));

return statearr_41605;
})();
var inst_41524 = _QMARK_ctx;
var inst_41525 = cljs.core.__destructure_map(inst_41524);
var inst_41526__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41525,cljs.core.cst$kw$sid);
var inst_41527__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41525,cljs.core.cst$kw$pid);
var inst_41528__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41525,cljs.core.cst$kw$db);
var inst_41529 = fluree.db.dbproto._p_prop(inst_41528__$1,cljs.core.cst$kw$name,inst_41527__$1);
var state_41593__$1 = (function (){var statearr_41606 = state_41593;
(statearr_41606[(9)] = inst_41529);

(statearr_41606[(10)] = inst_41526__$1);

(statearr_41606[(11)] = inst_41528__$1);

(statearr_41606[(12)] = inst_41527__$1);

return statearr_41606;
})();
if(cljs.core.truth_(inst_41526__$1)){
var statearr_41607_41639 = state_41593__$1;
(statearr_41607_41639[(1)] = (6));

} else {
var statearr_41608_41640 = state_41593__$1;
(statearr_41608_41640[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (11))){
var inst_41528 = (state_41593[(11)]);
var inst_41527 = (state_41593[(12)]);
var inst_41549 = (state_41593[(2)]);
var inst_41550 = fluree.db.dbproto._p_prop(inst_41528,cljs.core.cst$kw$multi,inst_41527);
var state_41593__$1 = (function (){var statearr_41610 = state_41593;
(statearr_41610[(13)] = inst_41549);

return statearr_41610;
})();
if(cljs.core.truth_(inst_41550)){
var statearr_41611_41641 = state_41593__$1;
(statearr_41611_41641[(1)] = (12));

} else {
var statearr_41612_41642 = state_41593__$1;
(statearr_41612_41642[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (9))){
var state_41593__$1 = state_41593;
var statearr_41613_41643 = state_41593__$1;
(statearr_41613_41643[(2)] = null);

(statearr_41613_41643[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (5))){
var _ = (function (){var statearr_41614 = state_41593;
(statearr_41614[(4)] = cljs.core.rest((state_41593[(4)])));

return statearr_41614;
})();
var state_41593__$1 = state_41593;
var ex41609 = (state_41593__$1[(2)]);
var statearr_41615_41644 = state_41593__$1;
(statearr_41615_41644[(5)] = ex41609);


if((ex41609 instanceof Error)){
var statearr_41616_41645 = state_41593__$1;
(statearr_41616_41645[(1)] = (4));

(statearr_41616_41645[(5)] = null);

} else {
throw ex41609;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (14))){
var inst_41529 = (state_41593[(9)]);
var inst_41526 = (state_41593[(10)]);
var inst_41528 = (state_41593[(11)]);
var inst_41560 = (state_41593[(2)]);
var inst_41561 = [cljs.core.cst$kw$select,cljs.core.cst$kw$where,cljs.core.cst$kw$opts];
var inst_41562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41563 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41564 = [inst_41526,inst_41529,"?current-val"];
var inst_41565 = (new cljs.core.PersistentVector(null,3,(5),inst_41563,inst_41564,null));
var inst_41566 = [inst_41565];
var inst_41567 = (new cljs.core.PersistentVector(null,1,(5),inst_41562,inst_41566,null));
var inst_41568 = cljs.core.PersistentHashMap.EMPTY;
var inst_41569 = ["?current-val",inst_41567,inst_41568];
var inst_41570 = cljs.core.PersistentHashMap.fromArrays(inst_41561,inst_41569);
var inst_41571 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_41528,inst_41570);
var state_41593__$1 = (function (){var statearr_41617 = state_41593;
(statearr_41617[(14)] = inst_41560);

return statearr_41617;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41593__$1,(15),inst_41571);
} else {
if((state_val_41594 === (16))){
var state_41593__$1 = state_41593;
var statearr_41618_41646 = state_41593__$1;
(statearr_41618_41646[(2)] = new_val);

(statearr_41618_41646[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (10))){
var inst_41542 = fluree.db.dbfunctions.internal.str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to execute cas - predicate could be determined. Cas values: ",compare_val,new_val], 0));
var inst_41543 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41544 = [(400),cljs.core.cst$kw$db_SLASH_validation_DASH_error];
var inst_41545 = cljs.core.PersistentHashMap.fromArrays(inst_41543,inst_41544);
var inst_41546 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41542,inst_41545);
var inst_41547 = (function(){throw inst_41546})();
var state_41593__$1 = state_41593;
var statearr_41619_41647 = state_41593__$1;
(statearr_41619_41647[(2)] = inst_41547);

(statearr_41619_41647[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (18))){
var inst_41588 = (state_41593[(2)]);
var _ = (function (){var statearr_41620 = state_41593;
(statearr_41620[(4)] = cljs.core.rest((state_41593[(4)])));

return statearr_41620;
})();
var state_41593__$1 = state_41593;
var statearr_41621_41648 = state_41593__$1;
(statearr_41621_41648[(2)] = inst_41588);

(statearr_41621_41648[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41594 === (8))){
var inst_41529 = (state_41593[(9)]);
var inst_41539 = (state_41593[(2)]);
var state_41593__$1 = (function (){var statearr_41622 = state_41593;
(statearr_41622[(15)] = inst_41539);

return statearr_41622;
})();
if(cljs.core.truth_(inst_41529)){
var statearr_41623_41649 = state_41593__$1;
(statearr_41623_41649[(1)] = (9));

} else {
var statearr_41624_41650 = state_41593__$1;
(statearr_41624_41650[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__ = null;
var fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____0 = (function (){
var statearr_41625 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41625[(0)] = fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__);

(statearr_41625[(1)] = (1));

return statearr_41625;
});
var fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____1 = (function (state_41593){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_41593);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e41626){var ex__10753__auto__ = e41626;
var statearr_41627_41651 = state_41593;
(statearr_41627_41651[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_41593[(4)]))){
var statearr_41628_41652 = state_41593;
(statearr_41628_41652[(1)] = cljs.core.first((state_41593[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__41653 = state_41593;
state_41593 = G__41653;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__ = function(state_41593){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____1.call(this,state_41593);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____0;
fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto____1;
return fluree$db$dbfunctions$internal$cas_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_41629 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_41629[(6)] = c__10876__auto__);

return statearr_41629;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
