// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbproto');
goog.require('cljs.core');
goog.require('cljs.core.constants');

/**
 * All nodes must implement this protocol. It's includes the minimal functionality
 * necessary to avoid resolving nodes unless strictly necessary.
 * @interface
 */
fluree.db.dbproto.IResolve = function(){};

var fluree$db$dbproto$IResolve$_first_flake$dyn_28764 = (function (node){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._first_flake[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4510__auto__.call(null,node));
} else {
var m__4508__auto__ = (fluree.db.dbproto._first_flake["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4508__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-first-flake",node);
}
}
});
/**
 * Returns the first flake in this node
 */
fluree.db.dbproto._first_flake = (function fluree$db$dbproto$_first_flake(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_first_flake$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_first_flake$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_first_flake$dyn_28764(node);
}
});

var fluree$db$dbproto$IResolve$_rhs$dyn_28765 = (function (node){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._rhs[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4510__auto__.call(null,node));
} else {
var m__4508__auto__ = (fluree.db.dbproto._rhs["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4508__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-rhs",node);
}
}
});
/**
 * Returns the next node's first flake
 */
fluree.db.dbproto._rhs = (function fluree$db$dbproto$_rhs(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_rhs$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_rhs$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_rhs$dyn_28765(node);
}
});

var fluree$db$dbproto$IResolve$_history_count$dyn_28766 = (function (node){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._history_count[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4510__auto__.call(null,node));
} else {
var m__4508__auto__ = (fluree.db.dbproto._history_count["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4508__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-history-count",node);
}
}
});
/**
 * Returns how many history nodes are present for this node (if a leaf)
 */
fluree.db.dbproto._history_count = (function fluree$db$dbproto$_history_count(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_history_count$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_history_count$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_history_count$dyn_28766(node);
}
});

var fluree$db$dbproto$IResolve$_resolve$dyn_28767 = (function (node){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4510__auto__.call(null,node));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4508__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve",node);
}
}
});
/**
 * Returns node resolved with data as async channel
 */
fluree.db.dbproto._resolve = (function fluree$db$dbproto$_resolve(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve$dyn_28767(node);
}
});

var fluree$db$dbproto$IResolve$_resolve_to_t$dyn_28768 = (function() {
var G__28769 = null;
var G__28769__3 = (function (node,t,idx_novelty){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(node,t,idx_novelty) : m__4510__auto__.call(null,node,t,idx_novelty));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(node,t,idx_novelty) : m__4508__auto__.call(null,node,t,idx_novelty));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
});
var G__28769__4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_) : m__4510__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_) : m__4508__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
});
var G__28769__5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_to_t[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes) : m__4510__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_to_t["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$5 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes) : m__4508__auto__.call(null,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-to-t",node);
}
}
});
G__28769 = function(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
switch(arguments.length){
case 3:
return G__28769__3.call(this,node,t,idx_novelty);
case 4:
return G__28769__4.call(this,node,t,idx_novelty,fast_forward_db_QMARK_);
case 5:
return G__28769__5.call(this,node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28769.cljs$core$IFn$_invoke$arity$3 = G__28769__3;
G__28769.cljs$core$IFn$_invoke$arity$4 = G__28769__4;
G__28769.cljs$core$IFn$_invoke$arity$5 = G__28769__5;
return G__28769;
})()
;
/**
 * Resolves this node at specified transaction 't'. Novelty included for the specified index.
 */
fluree.db.dbproto._resolve_to_t = (function fluree$db$dbproto$_resolve_to_t(var_args){
var G__28761 = arguments.length;
switch (G__28761) {
case 3:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$3 = (function (node,t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3(node,t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_28768.cljs$core$IFn$_invoke$arity$3(node,t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4 = (function (node,t,idx_novelty,fast_forward_db_QMARK_){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_28768.cljs$core$IFn$_invoke$arity$4(node,t,idx_novelty,fast_forward_db_QMARK_);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$5 = (function (node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
} else {
return fluree$db$dbproto$IResolve$_resolve_to_t$dyn_28768.cljs$core$IFn$_invoke$arity$5(node,t,idx_novelty,fast_forward_db_QMARK_,remove_flakes);
}
}));

(fluree.db.dbproto._resolve_to_t.cljs$lang$maxFixedArity = 5);


var fluree$db$dbproto$IResolve$_resolve_history$dyn_28771 = (function (node){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_history[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4510__auto__.call(null,node));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_history["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(node) : m__4508__auto__.call(null,node));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history",node);
}
}
});
/**
 * Returns the history for data nodes.
 */
fluree.db.dbproto._resolve_history = (function fluree$db$dbproto$_resolve_history(node){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history$arity$1 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history$arity$1(node);
} else {
return fluree$db$dbproto$IResolve$_resolve_history$dyn_28771(node);
}
});

var fluree$db$dbproto$IResolve$_resolve_history_range$dyn_28772 = (function() {
var G__28773 = null;
var G__28773__3 = (function (node,from_t,to_t){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(node,from_t,to_t) : m__4510__auto__.call(null,node,from_t,to_t));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(node,from_t,to_t) : m__4508__auto__.call(null,node,from_t,to_t));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history-range",node);
}
}
});
var G__28773__4 = (function (node,from_t,to_t,idx_novelty){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._resolve_history_range[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(node,from_t,to_t,idx_novelty) : m__4510__auto__.call(null,node,from_t,to_t,idx_novelty));
} else {
var m__4508__auto__ = (fluree.db.dbproto._resolve_history_range["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(node,from_t,to_t,idx_novelty) : m__4508__auto__.call(null,node,from_t,to_t,idx_novelty));
} else {
throw cljs.core.missing_protocol("IResolve.-resolve-history-range",node);
}
}
});
G__28773 = function(node,from_t,to_t,idx_novelty){
switch(arguments.length){
case 3:
return G__28773__3.call(this,node,from_t,to_t);
case 4:
return G__28773__4.call(this,node,from_t,to_t,idx_novelty);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28773.cljs$core$IFn$_invoke$arity$3 = G__28773__3;
G__28773.cljs$core$IFn$_invoke$arity$4 = G__28773__4;
return G__28773;
})()
;
/**
 * Returns the history within specified range of 't' values. From is most recent time.
 */
fluree.db.dbproto._resolve_history_range = (function fluree$db$dbproto$_resolve_history_range(var_args){
var G__28763 = arguments.length;
switch (G__28763) {
case 3:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$3 = (function (node,from_t,to_t){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3(node,from_t,to_t);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_28772.cljs$core$IFn$_invoke$arity$3(node,from_t,to_t);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4 = (function (node,from_t,to_t,idx_novelty){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 == null)))))){
return node.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4(node,from_t,to_t,idx_novelty);
} else {
return fluree$db$dbproto$IResolve$_resolve_history_range$dyn_28772.cljs$core$IFn$_invoke$arity$4(node,from_t,to_t,idx_novelty);
}
}));

(fluree.db.dbproto._resolve_history_range.cljs$lang$maxFixedArity = 4);



/**
 * @interface
 */
fluree.db.dbproto.INode = function(){};

var fluree$db$dbproto$INode$_lookup$dyn_28775 = (function (node,flake){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._lookup[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4510__auto__.call(null,node,flake));
} else {
var m__4508__auto__ = (fluree.db.dbproto._lookup["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4508__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup",node);
}
}
});
/**
 * Returns the child node which contains the given key
 */
fluree.db.dbproto._lookup = (function fluree$db$dbproto$_lookup(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup$dyn_28775(node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_after$dyn_28776 = (function (node,flake){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._lookup_after[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4510__auto__.call(null,node,flake));
} else {
var m__4508__auto__ = (fluree.db.dbproto._lookup_after["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4508__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-after",node);
}
}
});
/**
 * Returns the child node which comes after the given key
 */
fluree.db.dbproto._lookup_after = (function fluree$db$dbproto$_lookup_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_after$dyn_28776(node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf$dyn_28777 = (function (node,flake){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._lookup_leaf[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4510__auto__.call(null,node,flake));
} else {
var m__4508__auto__ = (fluree.db.dbproto._lookup_leaf["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4508__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-leaf",node);
}
}
});
/**
 * Returns the leaf node which contains the given key
 */
fluree.db.dbproto._lookup_leaf = (function fluree$db$dbproto$_lookup_leaf(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf$dyn_28777(node,flake);
}
});

var fluree$db$dbproto$INode$_lookup_leaf_after$dyn_28778 = (function (node,flake){
var x__4509__auto__ = (((node == null))?null:node);
var m__4510__auto__ = (fluree.db.dbproto._lookup_leaf_after[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4510__auto__.call(null,node,flake));
} else {
var m__4508__auto__ = (fluree.db.dbproto._lookup_leaf_after["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(node,flake) : m__4508__auto__.call(null,node,flake));
} else {
throw cljs.core.missing_protocol("INode.-lookup-leaf-after",node);
}
}
});
/**
 * Returns the leaf node which comes after the given key
 */
fluree.db.dbproto._lookup_leaf_after = (function fluree$db$dbproto$_lookup_leaf_after(node,flake){
if((((!((node == null)))) && ((!((node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 == null)))))){
return node.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2(node,flake);
} else {
return fluree$db$dbproto$INode$_lookup_leaf_after$dyn_28778(node,flake);
}
});


/**
 * @interface
 */
fluree.db.dbproto.IFlureeDb = function(){};

var fluree$db$dbproto$IFlureeDb$_latest_db$dyn_28793 = (function (db){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._latest_db[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4510__auto__.call(null,db));
} else {
var m__4508__auto__ = (fluree.db.dbproto._latest_db["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4508__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-latest-db",db);
}
}
});
/**
 * Updates a db to the most current version of the db known to this server. Maintains existing permissions
 */
fluree.db.dbproto._latest_db = (function fluree$db$dbproto$_latest_db(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_latest_db$dyn_28793(db);
}
});

var fluree$db$dbproto$IFlureeDb$_rootdb$dyn_28794 = (function (db){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._rootdb[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4510__auto__.call(null,db));
} else {
var m__4508__auto__ = (fluree.db.dbproto._rootdb["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$1 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$1(db) : m__4508__auto__.call(null,db));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-rootdb",db);
}
}
});
/**
 * Returns root db version of this db.
 */
fluree.db.dbproto._rootdb = (function fluree$db$dbproto$_rootdb(db){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1(db);
} else {
return fluree$db$dbproto$IFlureeDb$_rootdb$dyn_28794(db);
}
});

var fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_28795 = (function() {
var G__28796 = null;
var G__28796__2 = (function (db,flakes){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4510__auto__.call(null,db,flakes));
} else {
var m__4508__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4508__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
});
var G__28796__3 = (function (db,tt_id,flakes){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._forward_time_travel[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4510__auto__.call(null,db,tt_id,flakes));
} else {
var m__4508__auto__ = (fluree.db.dbproto._forward_time_travel["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes) : m__4508__auto__.call(null,db,tt_id,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-forward-time-travel",db);
}
}
});
G__28796 = function(db,tt_id,flakes){
switch(arguments.length){
case 2:
return G__28796__2.call(this,db,tt_id);
case 3:
return G__28796__3.call(this,db,tt_id,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28796.cljs$core$IFn$_invoke$arity$2 = G__28796__2;
G__28796.cljs$core$IFn$_invoke$arity$3 = G__28796__3;
return G__28796;
})()
;
fluree.db.dbproto._forward_time_travel = (function fluree$db$dbproto$_forward_time_travel(var_args){
var G__28780 = arguments.length;
switch (G__28780) {
case 2:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_28795.cljs$core$IFn$_invoke$arity$2(db,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$core$IFn$_invoke$arity$3 = (function (db,tt_id,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3(db,tt_id,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_forward_time_travel$dyn_28795.cljs$core$IFn$_invoke$arity$3(db,tt_id,flakes);
}
}));

(fluree.db.dbproto._forward_time_travel.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_c_prop$dyn_28798 = (function (db,property,collection){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._c_prop[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4510__auto__.call(null,db,property,collection));
} else {
var m__4508__auto__ = (fluree.db.dbproto._c_prop["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,property,collection) : m__4508__auto__.call(null,db,property,collection));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-c-prop",db);
}
}
});
/**
 * Returns schema property for a collection.
 */
fluree.db.dbproto._c_prop = (function fluree$db$dbproto$_c_prop(db,property,collection){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3(db,property,collection);
} else {
return fluree$db$dbproto$IFlureeDb$_c_prop$dyn_28798(db,property,collection);
}
});

var fluree$db$dbproto$IFlureeDb$_p_prop$dyn_28799 = (function (db,property,predicate){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._p_prop[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4510__auto__.call(null,db,property,predicate));
} else {
var m__4508__auto__ = (fluree.db.dbproto._p_prop["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,property,predicate) : m__4508__auto__.call(null,db,property,predicate));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-p-prop",db);
}
}
});
/**
 * Returns the property specified for the given predicate.
 */
fluree.db.dbproto._p_prop = (function fluree$db$dbproto$_p_prop(db,property,predicate){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3(db,property,predicate);
} else {
return fluree$db$dbproto$IFlureeDb$_p_prop$dyn_28799(db,property,predicate);
}
});

var fluree$db$dbproto$IFlureeDb$_tag$dyn_28800 = (function() {
var G__28801 = null;
var G__28801__2 = (function (db,tag_id){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4510__auto__.call(null,db,tag_id));
} else {
var m__4508__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_id) : m__4508__auto__.call(null,db,tag_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
});
var G__28801__3 = (function (db,tag_id,pred){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._tag[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4510__auto__.call(null,db,tag_id,pred));
} else {
var m__4508__auto__ = (fluree.db.dbproto._tag["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred) : m__4508__auto__.call(null,db,tag_id,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag",db);
}
}
});
G__28801 = function(db,tag_id,pred){
switch(arguments.length){
case 2:
return G__28801__2.call(this,db,tag_id);
case 3:
return G__28801__3.call(this,db,tag_id,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28801.cljs$core$IFn$_invoke$arity$2 = G__28801__2;
G__28801.cljs$core$IFn$_invoke$arity$3 = G__28801__3;
return G__28801;
})()
;
/**
 * Returns resolved tag, shortens namespace if pred provided.
 */
fluree.db.dbproto._tag = (function fluree$db$dbproto$_tag(var_args){
var G__28782 = arguments.length;
switch (G__28782) {
case 2:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$2(db,tag_id);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_28800.cljs$core$IFn$_invoke$arity$2(db,tag_id);
}
}));

(fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_id,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag$arity$3(db,tag_id,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag$dyn_28800.cljs$core$IFn$_invoke$arity$3(db,tag_id,pred);
}
}));

(fluree.db.dbproto._tag.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_tag_id$dyn_28803 = (function() {
var G__28804 = null;
var G__28804__2 = (function (db,tag_name){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4510__auto__.call(null,db,tag_name));
} else {
var m__4508__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,tag_name) : m__4508__auto__.call(null,db,tag_name));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
});
var G__28804__3 = (function (db,tag_name,pred){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._tag_id[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4510__auto__.call(null,db,tag_name,pred));
} else {
var m__4508__auto__ = (fluree.db.dbproto._tag_id["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred) : m__4508__auto__.call(null,db,tag_name,pred));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-tag-id",db);
}
}
});
G__28804 = function(db,tag_name,pred){
switch(arguments.length){
case 2:
return G__28804__2.call(this,db,tag_name);
case 3:
return G__28804__3.call(this,db,tag_name,pred);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28804.cljs$core$IFn$_invoke$arity$2 = G__28804__2;
G__28804.cljs$core$IFn$_invoke$arity$3 = G__28804__3;
return G__28804;
})()
;
/**
 * Returns the tag sid. If pred provided will namespace tag if not already.
 */
fluree.db.dbproto._tag_id = (function fluree$db$dbproto$_tag_id(var_args){
var G__28784 = arguments.length;
switch (G__28784) {
case 2:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2 = (function (db,tag_name){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2(db,tag_name);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_28803.cljs$core$IFn$_invoke$arity$2(db,tag_name);
}
}));

(fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$3 = (function (db,tag_name,pred){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3(db,tag_name,pred);
} else {
return fluree$db$dbproto$IFlureeDb$_tag_id$dyn_28803.cljs$core$IFn$_invoke$arity$3(db,tag_name,pred);
}
}));

(fluree.db.dbproto._tag_id.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_subid$dyn_28806 = (function() {
var G__28807 = null;
var G__28807__2 = (function (db,ident){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4510__auto__.call(null,db,ident));
} else {
var m__4508__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,ident) : m__4508__auto__.call(null,db,ident));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
});
var G__28807__3 = (function (db,ident,strict_QMARK_){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._subid[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4510__auto__.call(null,db,ident,strict_QMARK_));
} else {
var m__4508__auto__ = (fluree.db.dbproto._subid["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_) : m__4508__auto__.call(null,db,ident,strict_QMARK_));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-subid",db);
}
}
});
G__28807 = function(db,ident,strict_QMARK_){
switch(arguments.length){
case 2:
return G__28807__2.call(this,db,ident);
case 3:
return G__28807__3.call(this,db,ident,strict_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28807.cljs$core$IFn$_invoke$arity$2 = G__28807__2;
G__28807.cljs$core$IFn$_invoke$arity$3 = G__28807__3;
return G__28807;
})()
;
/**
 * Returns subject ID if exists, else nil
 */
fluree.db.dbproto._subid = (function fluree$db$dbproto$_subid(var_args){
var G__28786 = arguments.length;
switch (G__28786) {
case 2:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2 = (function (db,ident){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$2(db,ident);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_28806.cljs$core$IFn$_invoke$arity$2(db,ident);
}
}));

(fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3 = (function (db,ident,strict_QMARK_){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_subid$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_subid$arity$3(db,ident,strict_QMARK_);
} else {
return fluree$db$dbproto$IFlureeDb$_subid$dyn_28806.cljs$core$IFn$_invoke$arity$3(db,ident,strict_QMARK_);
}
}));

(fluree.db.dbproto._subid.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_search$dyn_28809 = (function (db,fparts){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._search[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4510__auto__.call(null,db,fparts));
} else {
var m__4508__auto__ = (fluree.db.dbproto._search["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,fparts) : m__4508__auto__.call(null,db,fparts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-search",db);
}
}
});
/**
 * Performs a slice, but determines best index to use.
 */
fluree.db.dbproto._search = (function fluree$db$dbproto$_search(db,fparts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_search$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_search$arity$2(db,fparts);
} else {
return fluree$db$dbproto$IFlureeDb$_search$dyn_28809(db,fparts);
}
});

var fluree$db$dbproto$IFlureeDb$_query$dyn_28810 = (function() {
var G__28811 = null;
var G__28811__2 = (function (db,query){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4510__auto__.call(null,db,query));
} else {
var m__4508__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,query) : m__4508__auto__.call(null,db,query));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
});
var G__28811__3 = (function (db,query,opts){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._query[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4510__auto__.call(null,db,query,opts));
} else {
var m__4508__auto__ = (fluree.db.dbproto._query["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,query,opts) : m__4508__auto__.call(null,db,query,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-query",db);
}
}
});
G__28811 = function(db,query,opts){
switch(arguments.length){
case 2:
return G__28811__2.call(this,db,query);
case 3:
return G__28811__3.call(this,db,query,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28811.cljs$core$IFn$_invoke$arity$2 = G__28811__2;
G__28811.cljs$core$IFn$_invoke$arity$3 = G__28811__3;
return G__28811;
})()
;
/**
 * Performs a query.
 */
fluree.db.dbproto._query = (function fluree$db$dbproto$_query(var_args){
var G__28788 = arguments.length;
switch (G__28788) {
case 2:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2 = (function (db,query){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$2(db,query);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_28810.cljs$core$IFn$_invoke$arity$2(db,query);
}
}));

(fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$3 = (function (db,query,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_query$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_query$arity$3(db,query,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_query$dyn_28810.cljs$core$IFn$_invoke$arity$3(db,query,opts);
}
}));

(fluree.db.dbproto._query.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_with$dyn_28813 = (function() {
var G__28814 = null;
var G__28814__3 = (function (db,block,flakes){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4510__auto__.call(null,db,block,flakes));
} else {
var m__4508__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,block,flakes) : m__4508__auto__.call(null,db,block,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with",db);
}
}
});
var G__28814__4 = (function (db,block,flakes,opts){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._with[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts) : m__4510__auto__.call(null,db,block,flakes,opts));
} else {
var m__4508__auto__ = (fluree.db.dbproto._with["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$4 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts) : m__4508__auto__.call(null,db,block,flakes,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with",db);
}
}
});
G__28814 = function(db,block,flakes,opts){
switch(arguments.length){
case 3:
return G__28814__3.call(this,db,block,flakes);
case 4:
return G__28814__4.call(this,db,block,flakes,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28814.cljs$core$IFn$_invoke$arity$3 = G__28814__3;
G__28814.cljs$core$IFn$_invoke$arity$4 = G__28814__4;
return G__28814;
})()
;
/**
 * Applies flakes to this db as a new block with possibly multiple 't' transactions.
 */
fluree.db.dbproto._with = (function fluree$db$dbproto$_with(var_args){
var G__28790 = arguments.length;
switch (G__28790) {
case 3:
return fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$3(db,block,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_28813.cljs$core$IFn$_invoke$arity$3(db,block,flakes);
}
}));

(fluree.db.dbproto._with.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with$arity$4 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with$arity$4(db,block,flakes,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_with$dyn_28813.cljs$core$IFn$_invoke$arity$4(db,block,flakes,opts);
}
}));

(fluree.db.dbproto._with.cljs$lang$maxFixedArity = 4);


var fluree$db$dbproto$IFlureeDb$_with_t$dyn_28816 = (function() {
var G__28817 = null;
var G__28817__2 = (function (db,flakes){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4510__auto__.call(null,db,flakes));
} else {
var m__4508__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,flakes) : m__4508__auto__.call(null,db,flakes));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with-t",db);
}
}
});
var G__28817__3 = (function (db,flakes,opts){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._with_t[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$3(db,flakes,opts) : m__4510__auto__.call(null,db,flakes,opts));
} else {
var m__4508__auto__ = (fluree.db.dbproto._with_t["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$3 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$3(db,flakes,opts) : m__4508__auto__.call(null,db,flakes,opts));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-with-t",db);
}
}
});
G__28817 = function(db,flakes,opts){
switch(arguments.length){
case 2:
return G__28817__2.call(this,db,flakes);
case 3:
return G__28817__3.call(this,db,flakes,opts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__28817.cljs$core$IFn$_invoke$arity$2 = G__28817__2;
G__28817.cljs$core$IFn$_invoke$arity$3 = G__28817__3;
return G__28817;
})()
;
/**
 * Applies flakes to this db as a new 't', but retains current block.
 */
fluree.db.dbproto._with_t = (function fluree$db$dbproto$_with_t(var_args){
var G__28792 = arguments.length;
switch (G__28792) {
case 2:
return fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$2(db,flakes);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_28816.cljs$core$IFn$_invoke$arity$2(db,flakes);
}
}));

(fluree.db.dbproto._with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_with_t$arity$3(db,flakes,opts);
} else {
return fluree$db$dbproto$IFlureeDb$_with_t$dyn_28816.cljs$core$IFn$_invoke$arity$3(db,flakes,opts);
}
}));

(fluree.db.dbproto._with_t.cljs$lang$maxFixedArity = 3);


var fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_28819 = (function (db,pred_id){
var x__4509__auto__ = (((db == null))?null:db);
var m__4510__auto__ = (fluree.db.dbproto._add_predicate_to_idx[goog.typeOf(x__4509__auto__)]);
if((!((m__4510__auto__ == null)))){
return (m__4510__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4510__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4510__auto__.call(null,db,pred_id));
} else {
var m__4508__auto__ = (fluree.db.dbproto._add_predicate_to_idx["_"]);
if((!((m__4508__auto__ == null)))){
return (m__4508__auto__.cljs$core$IFn$_invoke$arity$2 ? m__4508__auto__.cljs$core$IFn$_invoke$arity$2(db,pred_id) : m__4508__auto__.call(null,db,pred_id));
} else {
throw cljs.core.missing_protocol("IFlureeDb.-add-predicate-to-idx",db);
}
}
});
/**
 * Adds predicate to idx, return updated db.
 */
fluree.db.dbproto._add_predicate_to_idx = (function fluree$db$dbproto$_add_predicate_to_idx(db,pred_id){
if((((!((db == null)))) && ((!((db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 == null)))))){
return db.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2(db,pred_id);
} else {
return fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$dyn_28819(db,pred_id);
}
});

fluree.db.dbproto.db_QMARK_ = (function fluree$db$dbproto$db_QMARK_(db){
if((!((db == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === db.fluree$db$dbproto$IFlureeDb$)))){
return true;
} else {
if((!db.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(fluree.db.dbproto.IFlureeDb,db);
}
});
