// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__38099 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38099,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38099,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__38099,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__38102){
var map__38103 = p__38102;
var map__38103__$1 = cljs.core.__destructure_map(map__38103);
var opts = map__38103__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38103__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_38163){
var state_val_38164 = (state_38163[(1)]);
if((state_val_38164 === (7))){
var inst_38134 = cljs.core.not(reindex_QMARK_);
var state_38163__$1 = state_38163;
var statearr_38165_38189 = state_38163__$1;
(statearr_38165_38189[(2)] = inst_38134);

(statearr_38165_38189[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (1))){
var state_38163__$1 = state_38163;
var statearr_38166_38190 = state_38163__$1;
(statearr_38166_38190[(2)] = null);

(statearr_38166_38190[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (4))){
var inst_38104 = (state_38163[(2)]);
var state_38163__$1 = state_38163;
var statearr_38167_38191 = state_38163__$1;
(statearr_38167_38191[(2)] = inst_38104);

(statearr_38167_38191[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (6))){
var inst_38132 = (state_38163[(7)]);
var inst_38118 = (state_38163[(8)]);
var inst_38124 = (state_38163[(9)]);
var inst_38117 = (state_38163[(2)]);
var inst_38118__$1 = fluree.db.util.async.throw_err(inst_38117);
var inst_38119 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_38120 = cljs.core.__destructure_map(inst_38119);
var inst_38121 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38120,cljs.core.cst$kw$post);
var inst_38122 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38120,cljs.core.cst$kw$size);
var inst_38123 = fluree.db.flake.size_bytes(inst_38118__$1);
var inst_38124__$1 = (inst_38122 + inst_38123);
var inst_38125 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38126 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_38127 = (new cljs.core.PersistentVector(null,2,(5),inst_38125,inst_38126,null));
var inst_38128 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_38127);
var inst_38129 = cljs.core.__destructure_map(inst_38128);
var inst_38130 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38129,cljs.core.cst$kw$novelty_DASH_min);
var inst_38131 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38129,cljs.core.cst$kw$novelty_DASH_max);
var inst_38132__$1 = (inst_38124__$1 > inst_38131);
var state_38163__$1 = (function (){var statearr_38168 = state_38163;
(statearr_38168[(10)] = inst_38130);

(statearr_38168[(11)] = inst_38121);

(statearr_38168[(7)] = inst_38132__$1);

(statearr_38168[(8)] = inst_38118__$1);

(statearr_38168[(9)] = inst_38124__$1);

return statearr_38168;
})();
if(cljs.core.truth_(inst_38132__$1)){
var statearr_38169_38192 = state_38163__$1;
(statearr_38169_38192[(1)] = (7));

} else {
var statearr_38170_38193 = state_38163__$1;
(statearr_38170_38193[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (3))){
var inst_38161 = (state_38163[(2)]);
var state_38163__$1 = state_38163;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38163__$1,inst_38161);
} else {
if((state_val_38164 === (12))){
var inst_38121 = (state_38163[(11)]);
var inst_38118 = (state_38163[(8)]);
var inst_38124 = (state_38163[(9)]);
var inst_38147 = (state_38163[(2)]);
var inst_38148 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38121,inst_38118);
var inst_38149 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_38150 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_38149,cljs.core.empty);
var inst_38151 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38152 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_38153 = (new cljs.core.PersistentVector(null,2,(5),inst_38151,inst_38152,null));
var inst_38154 = cljs.core.assoc_in(db,inst_38153,inst_38148);
var inst_38155 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38156 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_38157 = (new cljs.core.PersistentVector(null,2,(5),inst_38155,inst_38156,null));
var inst_38158 = cljs.core.assoc_in(inst_38154,inst_38157,inst_38124);
var _ = (function (){var statearr_38171 = state_38163;
(statearr_38171[(4)] = cljs.core.rest((state_38163[(4)])));

return statearr_38171;
})();
var state_38163__$1 = (function (){var statearr_38172 = state_38163;
(statearr_38172[(12)] = inst_38147);

(statearr_38172[(13)] = inst_38150);

return statearr_38172;
})();
var statearr_38173_38194 = state_38163__$1;
(statearr_38173_38194[(2)] = inst_38158);

(statearr_38173_38194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (2))){
var _ = (function (){var statearr_38174 = state_38163;
(statearr_38174[(4)] = cljs.core.cons((5),(state_38163[(4)])));

return statearr_38174;
})();
var inst_38112 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38113 = [pred_id];
var inst_38114 = (new cljs.core.PersistentVector(null,1,(5),inst_38112,inst_38113,null));
var inst_38115 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_38114);
var state_38163__$1 = state_38163;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38163__$1,(6),inst_38115);
} else {
if((state_val_38164 === (11))){
var state_38163__$1 = state_38163;
var statearr_38176_38195 = state_38163__$1;
(statearr_38176_38195[(2)] = null);

(statearr_38176_38195[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (9))){
var inst_38137 = (state_38163[(2)]);
var state_38163__$1 = state_38163;
if(cljs.core.truth_(inst_38137)){
var statearr_38177_38196 = state_38163__$1;
(statearr_38177_38196[(1)] = (10));

} else {
var statearr_38178_38197 = state_38163__$1;
(statearr_38178_38197[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (5))){
var _ = (function (){var statearr_38179 = state_38163;
(statearr_38179[(4)] = cljs.core.rest((state_38163[(4)])));

return statearr_38179;
})();
var state_38163__$1 = state_38163;
var ex38175 = (state_38163__$1[(2)]);
var statearr_38180_38198 = state_38163__$1;
(statearr_38180_38198[(5)] = ex38175);


if((ex38175 instanceof Error)){
var statearr_38181_38199 = state_38163__$1;
(statearr_38181_38199[(1)] = (4));

(statearr_38181_38199[(5)] = null);

} else {
throw ex38175;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (10))){
var inst_38139 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_38140 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_38141 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_38142 = cljs.core.PersistentHashMap.fromArrays(inst_38140,inst_38141);
var inst_38143 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38139,inst_38142);
var inst_38144 = (function(){throw inst_38143})();
var state_38163__$1 = state_38163;
var statearr_38182_38200 = state_38163__$1;
(statearr_38182_38200[(2)] = inst_38144);

(statearr_38182_38200[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38164 === (8))){
var inst_38132 = (state_38163[(7)]);
var state_38163__$1 = state_38163;
var statearr_38183_38201 = state_38163__$1;
(statearr_38183_38201[(2)] = inst_38132);

(statearr_38183_38201[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____0 = (function (){
var statearr_38184 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38184[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__);

(statearr_38184[(1)] = (1));

return statearr_38184;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____1 = (function (state_38163){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_38163);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e38185){var ex__10753__auto__ = e38185;
var statearr_38186_38202 = state_38163;
(statearr_38186_38202[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_38163[(4)]))){
var statearr_38187_38203 = state_38163;
(statearr_38187_38203[(1)] = cljs.core.first((state_38163[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__38204 = state_38163;
state_38163 = G__38204;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__ = function(state_38163){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____1.call(this,state_38163);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_38188 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_38188[(6)] = c__10876__auto__);

return statearr_38188;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__38209 = arguments.length;
switch (G__38209) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_38405){
var state_val_38406 = (state_38405[(1)]);
if((state_val_38406 === (7))){
var state_38405__$1 = state_38405;
var statearr_38407_38475 = state_38405__$1;
(statearr_38407_38475[(2)] = null);

(statearr_38407_38475[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (20))){
var inst_38328 = (state_38405[(7)]);
var inst_38329 = (state_38405[(8)]);
var inst_38298 = (state_38405[(9)]);
var inst_38247 = (state_38405[(10)]);
var inst_38327 = (state_38405[(11)]);
var inst_38331 = (state_38405[(12)]);
var inst_38248 = (state_38405[(13)]);
var inst_38330 = (state_38405[(14)]);
var inst_38341 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_38342 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38343 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_38344 = (new cljs.core.PersistentVector(null,2,(5),inst_38342,inst_38343,null));
var inst_38345 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38298,inst_38344);
var inst_38346 = (inst_38247 + inst_38345);
var inst_38347 = [inst_38327,inst_38328,inst_38329,inst_38330,inst_38346];
var inst_38348 = cljs.core.PersistentHashMap.fromArrays(inst_38341,inst_38347);
var inst_38349 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_38298,cljs.core.cst$kw$ecount,inst_38331,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_38348], 0));
var state_38405__$1 = (function (){var statearr_38408 = state_38405;
(statearr_38408[(15)] = inst_38349);

return statearr_38408;
})();
if(cljs.core.truth_(inst_38248)){
var statearr_38409_38476 = state_38405__$1;
(statearr_38409_38476[(1)] = (23));

} else {
var statearr_38410_38477 = state_38405__$1;
(statearr_38410_38477[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (27))){
var inst_38349 = (state_38405[(15)]);
var state_38405__$1 = state_38405;
var statearr_38411_38478 = state_38405__$1;
(statearr_38411_38478[(2)] = inst_38349);

(statearr_38411_38478[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (1))){
var state_38405__$1 = state_38405;
var statearr_38412_38479 = state_38405__$1;
(statearr_38412_38479[(2)] = null);

(statearr_38412_38479[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (24))){
var inst_38349 = (state_38405[(15)]);
var inst_38352 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_38349);
var inst_38353 = (inst_38352 == null);
var state_38405__$1 = state_38405;
var statearr_38413_38480 = state_38405__$1;
(statearr_38413_38480[(2)] = inst_38353);

(statearr_38413_38480[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (39))){
var inst_38338 = (state_38405[(16)]);
var inst_38379 = (state_38405[(17)]);
var inst_38380 = (state_38405[(18)]);
var inst_38388 = (state_38405[(19)]);
var inst_38381 = (state_38405[(20)]);
var inst_38395 = (state_38405[(2)]);
var inst_38326 = inst_38338;
var inst_38327 = inst_38380;
var inst_38328 = inst_38381;
var inst_38329 = inst_38388;
var inst_38330 = inst_38395;
var inst_38331 = inst_38379;
var state_38405__$1 = (function (){var statearr_38414 = state_38405;
(statearr_38414[(7)] = inst_38328);

(statearr_38414[(8)] = inst_38329);

(statearr_38414[(21)] = inst_38326);

(statearr_38414[(11)] = inst_38327);

(statearr_38414[(12)] = inst_38331);

(statearr_38414[(14)] = inst_38330);

return statearr_38414;
})();
var statearr_38415_38481 = state_38405__$1;
(statearr_38415_38481[(2)] = null);

(statearr_38415_38481[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (4))){
var inst_38210 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
var statearr_38416_38482 = state_38405__$1;
(statearr_38416_38482[(2)] = inst_38210);

(statearr_38416_38482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (15))){
var inst_38270 = (state_38405[(22)]);
var state_38405__$1 = state_38405;
var statearr_38417_38483 = state_38405__$1;
(statearr_38417_38483[(2)] = inst_38270);

(statearr_38417_38483[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (21))){
var inst_38328 = (state_38405[(7)]);
var inst_38329 = (state_38405[(8)]);
var inst_38338 = (state_38405[(16)]);
var inst_38307 = (state_38405[(23)]);
var inst_38326 = (state_38405[(21)]);
var inst_38238 = (state_38405[(24)]);
var inst_38242 = (state_38405[(25)]);
var inst_38308 = (state_38405[(26)]);
var inst_38298 = (state_38405[(9)]);
var inst_38247 = (state_38405[(10)]);
var inst_38257 = (state_38405[(27)]);
var inst_38251 = (state_38405[(28)]);
var inst_38327 = (state_38405[(11)]);
var inst_38234 = (state_38405[(29)]);
var inst_38232 = (state_38405[(30)]);
var inst_38331 = (state_38405[(12)]);
var inst_38217 = (state_38405[(31)]);
var inst_38248 = (state_38405[(13)]);
var inst_38337 = (state_38405[(32)]);
var inst_38249 = (state_38405[(33)]);
var inst_38330 = (state_38405[(14)]);
var inst_38246 = (state_38405[(34)]);
var inst_38376 = inst_38337.s;
var inst_38377 = fluree.db.flake.sid__GT_cid(inst_38376);
var inst_38378 = (function (){var flakes_bytes = inst_38247;
var t = inst_38217;
var spot = inst_38327;
var add_flakes = inst_38234;
var root_setting_change_QMARK_ = inst_38249;
var ref_QMARK__map = inst_38246;
var r = inst_38338;
var psot = inst_38328;
var add_pred_to_idx_QMARK_ = inst_38257;
var _ = inst_38232;
var cid = inst_38377;
var vec__38303 = inst_38234;
var ecount = inst_38331;
var pred_ecount = inst_38251;
var first__38305 = inst_38307;
var seq__38334 = inst_38338;
var G__38302 = inst_38326;
var db_STAR_ = inst_38298;
var schema_change_QMARK_ = inst_38248;
var vec__38333 = inst_38326;
var add_preds = inst_38238;
var opst = inst_38330;
var seq__38304 = inst_38308;
var idx_QMARK__map = inst_38242;
var post = inst_38329;
var f = inst_38337;
var first__38335 = inst_38337;
return (function (p1__38207_SHARP_){
if(cljs.core.truth_(p1__38207_SHARP_)){
var x__4295__auto__ = p1__38207_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_38379 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_38331,inst_38377,inst_38378);
var inst_38380 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38327,inst_38337);
var inst_38381 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38328,inst_38337);
var inst_38382 = inst_38337.p;
var inst_38383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38242,inst_38382);
var state_38405__$1 = (function (){var statearr_38418 = state_38405;
(statearr_38418[(17)] = inst_38379);

(statearr_38418[(18)] = inst_38380);

(statearr_38418[(20)] = inst_38381);

return statearr_38418;
})();
if(cljs.core.truth_(inst_38383)){
var statearr_38419_38484 = state_38405__$1;
(statearr_38419_38484[(1)] = (34));

} else {
var statearr_38420_38485 = state_38405__$1;
(statearr_38420_38485[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (31))){
var inst_38364 = (state_38405[(35)]);
var state_38405__$1 = state_38405;
var statearr_38421_38486 = state_38405__$1;
(statearr_38421_38486[(2)] = inst_38364);

(statearr_38421_38486[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (32))){
var inst_38374 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
var statearr_38422_38487 = state_38405__$1;
(statearr_38422_38487[(2)] = inst_38374);

(statearr_38422_38487[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (33))){
var inst_38364 = (state_38405[(35)]);
var inst_38369 = (state_38405[(2)]);
var inst_38370 = fluree.db.util.async.throw_err(inst_38369);
var inst_38371 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38364,cljs.core.cst$kw$settings,inst_38370);
var state_38405__$1 = state_38405;
var statearr_38423_38488 = state_38405__$1;
(statearr_38423_38488[(2)] = inst_38371);

(statearr_38423_38488[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (13))){
var inst_38298 = (state_38405[(9)]);
var inst_38247 = (state_38405[(10)]);
var inst_38234 = (state_38405[(29)]);
var inst_38217 = (state_38405[(31)]);
var inst_38288 = (state_38405[(2)]);
var inst_38289 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38288,cljs.core.cst$kw$t,inst_38217);
var inst_38290 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38291 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_38292 = (new cljs.core.PersistentVector(null,2,(5),inst_38290,inst_38291,null));
var inst_38293 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38289,inst_38292,cljs.core._PLUS_,inst_38247);
var inst_38294 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38295 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_38296 = (new cljs.core.PersistentVector(null,2,(5),inst_38294,inst_38295,null));
var inst_38297 = cljs.core.count(inst_38234);
var inst_38298__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_38293,inst_38296,cljs.core._PLUS_,inst_38297);
var inst_38306 = cljs.core.seq(inst_38234);
var inst_38307 = cljs.core.first(inst_38306);
var inst_38308 = cljs.core.next(inst_38306);
var inst_38309 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38310 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_38311 = (new cljs.core.PersistentVector(null,2,(5),inst_38309,inst_38310,null));
var inst_38312 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38298__$1,inst_38311);
var inst_38313 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38314 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_38315 = (new cljs.core.PersistentVector(null,2,(5),inst_38313,inst_38314,null));
var inst_38316 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38298__$1,inst_38315);
var inst_38317 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38318 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_38319 = (new cljs.core.PersistentVector(null,2,(5),inst_38317,inst_38318,null));
var inst_38320 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38298__$1,inst_38319);
var inst_38321 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38322 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_38323 = (new cljs.core.PersistentVector(null,2,(5),inst_38321,inst_38322,null));
var inst_38324 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_38298__$1,inst_38323);
var inst_38325 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_38326 = inst_38234;
var inst_38327 = inst_38312;
var inst_38328 = inst_38316;
var inst_38329 = inst_38320;
var inst_38330 = inst_38324;
var inst_38331 = inst_38325;
var state_38405__$1 = (function (){var statearr_38424 = state_38405;
(statearr_38424[(7)] = inst_38328);

(statearr_38424[(8)] = inst_38329);

(statearr_38424[(23)] = inst_38307);

(statearr_38424[(21)] = inst_38326);

(statearr_38424[(26)] = inst_38308);

(statearr_38424[(9)] = inst_38298__$1);

(statearr_38424[(11)] = inst_38327);

(statearr_38424[(12)] = inst_38331);

(statearr_38424[(14)] = inst_38330);

return statearr_38424;
})();
var statearr_38425_38489 = state_38405__$1;
(statearr_38425_38489[(2)] = null);

(statearr_38425_38489[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (22))){
var inst_38398 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
var statearr_38426_38490 = state_38405__$1;
(statearr_38426_38490[(2)] = inst_38398);

(statearr_38426_38490[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (36))){
var inst_38337 = (state_38405[(32)]);
var inst_38246 = (state_38405[(34)]);
var inst_38388 = (state_38405[(2)]);
var inst_38389 = inst_38337.p;
var inst_38390 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38246,inst_38389);
var state_38405__$1 = (function (){var statearr_38427 = state_38405;
(statearr_38427[(19)] = inst_38388);

return statearr_38427;
})();
if(cljs.core.truth_(inst_38390)){
var statearr_38428_38491 = state_38405__$1;
(statearr_38428_38491[(1)] = (37));

} else {
var statearr_38429_38492 = state_38405__$1;
(statearr_38429_38492[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (29))){
var inst_38349 = (state_38405[(15)]);
var inst_38359 = (state_38405[(2)]);
var inst_38360 = fluree.db.util.async.throw_err(inst_38359);
var inst_38361 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38349,cljs.core.cst$kw$schema,inst_38360);
var state_38405__$1 = state_38405;
var statearr_38430_38493 = state_38405__$1;
(statearr_38430_38493[(2)] = inst_38361);

(statearr_38430_38493[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (6))){
var inst_38217 = (state_38405[(31)]);
var inst_38222 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_38223 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_38224 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38222)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38223)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38217),"."].join('');
var inst_38225 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38226 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_38227 = cljs.core.PersistentHashMap.fromArrays(inst_38225,inst_38226);
var inst_38228 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38224,inst_38227);
var inst_38229 = (function(){throw inst_38228})();
var state_38405__$1 = state_38405;
var statearr_38431_38494 = state_38405__$1;
(statearr_38431_38494[(2)] = inst_38229);

(statearr_38431_38494[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (28))){
var inst_38249 = (state_38405[(33)]);
var inst_38364 = (state_38405[(2)]);
var state_38405__$1 = (function (){var statearr_38432 = state_38405;
(statearr_38432[(35)] = inst_38364);

return statearr_38432;
})();
if(cljs.core.truth_(inst_38249)){
var statearr_38433_38495 = state_38405__$1;
(statearr_38433_38495[(1)] = (30));

} else {
var statearr_38434_38496 = state_38405__$1;
(statearr_38434_38496[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (25))){
var inst_38355 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
if(cljs.core.truth_(inst_38355)){
var statearr_38435_38497 = state_38405__$1;
(statearr_38435_38497[(1)] = (26));

} else {
var statearr_38436_38498 = state_38405__$1;
(statearr_38436_38498[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (34))){
var inst_38329 = (state_38405[(8)]);
var inst_38337 = (state_38405[(32)]);
var inst_38385 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38329,inst_38337);
var state_38405__$1 = state_38405;
var statearr_38437_38499 = state_38405__$1;
(statearr_38437_38499[(2)] = inst_38385);

(statearr_38437_38499[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (17))){
var inst_38277 = (state_38405[(36)]);
var inst_38281 = (state_38405[(2)]);
var inst_38282 = fluree.db.util.async.throw_err(inst_38281);
var inst_38269 = inst_38277;
var inst_38270 = inst_38282;
var state_38405__$1 = (function (){var statearr_38438 = state_38405;
(statearr_38438[(37)] = inst_38269);

(statearr_38438[(22)] = inst_38270);

return statearr_38438;
})();
var statearr_38439_38500 = state_38405__$1;
(statearr_38439_38500[(2)] = null);

(statearr_38439_38500[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (3))){
var inst_38403 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38405__$1,inst_38403);
} else {
if((state_val_38406 === (12))){
var inst_38276 = (state_38405[(38)]);
var inst_38269 = (state_38405[(37)]);
var inst_38275 = cljs.core.seq(inst_38269);
var inst_38276__$1 = cljs.core.first(inst_38275);
var inst_38277 = cljs.core.next(inst_38275);
var state_38405__$1 = (function (){var statearr_38440 = state_38405;
(statearr_38440[(38)] = inst_38276__$1);

(statearr_38440[(36)] = inst_38277);

return statearr_38440;
})();
if(cljs.core.truth_(inst_38276__$1)){
var statearr_38441_38501 = state_38405__$1;
(statearr_38441_38501[(1)] = (14));

} else {
var statearr_38442_38502 = state_38405__$1;
(statearr_38442_38502[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (2))){
var inst_38217 = (state_38405[(31)]);
var _ = (function (){var statearr_38443 = state_38405;
(statearr_38443[(4)] = cljs.core.cons((5),(state_38405[(4)])));

return statearr_38443;
})();
var inst_38216 = cljs.core.first(flakes);
var inst_38217__$1 = inst_38216.t;
var inst_38218 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_38219 = (inst_38218 - (1));
var inst_38220 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_38217__$1,inst_38219);
var state_38405__$1 = (function (){var statearr_38444 = state_38405;
(statearr_38444[(31)] = inst_38217__$1);

return statearr_38444;
})();
if(inst_38220){
var statearr_38445_38503 = state_38405__$1;
(statearr_38445_38503[(1)] = (6));

} else {
var statearr_38446_38504 = state_38405__$1;
(statearr_38446_38504[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (23))){
var inst_38248 = (state_38405[(13)]);
var state_38405__$1 = state_38405;
var statearr_38447_38505 = state_38405__$1;
(statearr_38447_38505[(2)] = inst_38248);

(statearr_38447_38505[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (35))){
var inst_38329 = (state_38405[(8)]);
var state_38405__$1 = state_38405;
var statearr_38448_38506 = state_38405__$1;
(statearr_38448_38506[(2)] = inst_38329);

(statearr_38448_38506[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (19))){
var inst_38400 = (state_38405[(2)]);
var _ = (function (){var statearr_38449 = state_38405;
(statearr_38449[(4)] = cljs.core.rest((state_38405[(4)])));

return statearr_38449;
})();
var state_38405__$1 = state_38405;
var statearr_38450_38507 = state_38405__$1;
(statearr_38450_38507[(2)] = inst_38400);

(statearr_38450_38507[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (11))){
var inst_38257 = (state_38405[(27)]);
var inst_38257__$1 = (state_38405[(2)]);
var inst_38265 = cljs.core.seq(inst_38257__$1);
var inst_38266 = cljs.core.first(inst_38265);
var inst_38267 = cljs.core.next(inst_38265);
var inst_38268 = db;
var inst_38269 = inst_38257__$1;
var inst_38270 = inst_38268;
var state_38405__$1 = (function (){var statearr_38452 = state_38405;
(statearr_38452[(27)] = inst_38257__$1);

(statearr_38452[(37)] = inst_38269);

(statearr_38452[(39)] = inst_38267);

(statearr_38452[(40)] = inst_38266);

(statearr_38452[(22)] = inst_38270);

return statearr_38452;
})();
var statearr_38453_38508 = state_38405__$1;
(statearr_38453_38508[(2)] = null);

(statearr_38453_38508[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (9))){
var inst_38251 = (state_38405[(28)]);
var inst_38234 = (state_38405[(29)]);
var inst_38253 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_38234,inst_38251);
var state_38405__$1 = state_38405;
var statearr_38454_38509 = state_38405__$1;
(statearr_38454_38509[(2)] = inst_38253);

(statearr_38454_38509[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (5))){
var _ = (function (){var statearr_38455 = state_38405;
(statearr_38455[(4)] = cljs.core.rest((state_38405[(4)])));

return statearr_38455;
})();
var state_38405__$1 = state_38405;
var ex38451 = (state_38405__$1[(2)]);
var statearr_38456_38510 = state_38405__$1;
(statearr_38456_38510[(5)] = ex38451);


if((ex38451 instanceof Error)){
var statearr_38457_38511 = state_38405__$1;
(statearr_38457_38511[(1)] = (4));

(statearr_38457_38511[(5)] = null);

} else {
throw ex38451;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (14))){
var inst_38276 = (state_38405[(38)]);
var inst_38270 = (state_38405[(22)]);
var inst_38279 = fluree.db.graphdb.add_predicate_to_idx(inst_38270,inst_38276,opts);
var state_38405__$1 = state_38405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38405__$1,(17),inst_38279);
} else {
if((state_val_38406 === (26))){
var inst_38349 = (state_38405[(15)]);
var inst_38357 = fluree.db.query.schema.schema_map(inst_38349);
var state_38405__$1 = state_38405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38405__$1,(29),inst_38357);
} else {
if((state_val_38406 === (16))){
var inst_38286 = (state_38405[(2)]);
var state_38405__$1 = state_38405;
var statearr_38458_38512 = state_38405__$1;
(statearr_38458_38512[(2)] = inst_38286);

(statearr_38458_38512[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (38))){
var inst_38330 = (state_38405[(14)]);
var state_38405__$1 = state_38405;
var statearr_38459_38513 = state_38405__$1;
(statearr_38459_38513[(2)] = inst_38330);

(statearr_38459_38513[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (30))){
var inst_38364 = (state_38405[(35)]);
var inst_38367 = fluree.db.query.schema.setting_map(inst_38364);
var state_38405__$1 = state_38405;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38405__$1,(33),inst_38367);
} else {
if((state_val_38406 === (10))){
var inst_38255 = cljs.core.PersistentVector.EMPTY;
var state_38405__$1 = state_38405;
var statearr_38460_38514 = state_38405__$1;
(statearr_38460_38514[(2)] = inst_38255);

(statearr_38460_38514[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (18))){
var inst_38326 = (state_38405[(21)]);
var inst_38337 = (state_38405[(32)]);
var inst_38336 = cljs.core.seq(inst_38326);
var inst_38337__$1 = cljs.core.first(inst_38336);
var inst_38338 = cljs.core.next(inst_38336);
var inst_38339 = cljs.core.not(inst_38337__$1);
var state_38405__$1 = (function (){var statearr_38461 = state_38405;
(statearr_38461[(16)] = inst_38338);

(statearr_38461[(32)] = inst_38337__$1);

return statearr_38461;
})();
if(inst_38339){
var statearr_38462_38515 = state_38405__$1;
(statearr_38462_38515[(1)] = (20));

} else {
var statearr_38463_38516 = state_38405__$1;
(statearr_38463_38516[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (37))){
var inst_38337 = (state_38405[(32)]);
var inst_38330 = (state_38405[(14)]);
var inst_38392 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38330,inst_38337);
var state_38405__$1 = state_38405;
var statearr_38464_38517 = state_38405__$1;
(statearr_38464_38517[(2)] = inst_38392);

(statearr_38464_38517[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38406 === (8))){
var inst_38238 = (state_38405[(24)]);
var inst_38242 = (state_38405[(25)]);
var inst_38234 = (state_38405[(29)]);
var inst_38232 = (state_38405[(30)]);
var inst_38217 = (state_38405[(31)]);
var inst_38248 = (state_38405[(13)]);
var inst_38232__$1 = (state_38405[(2)]);
var inst_38233 = (function (){var t = inst_38217;
var _ = inst_38232__$1;
return (function (p1__38205_SHARP_){
return cljs.core.not((function (){var G__38465 = p1__38205_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__38465) : fluree.db.graphdb.exclude_predicates.call(null,G__38465));
})());
});
})();
var inst_38234__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_38233,flakes);
var inst_38235 = cljs.core.PersistentHashSet.EMPTY;
var inst_38236 = (function (){var t = inst_38217;
var _ = inst_38232__$1;
var add_flakes = inst_38234__$1;
return (function (p1__38206_SHARP_){
return p1__38206_SHARP_.p;
});
})();
var inst_38237 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38236,inst_38234__$1);
var inst_38238__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38235,inst_38237);
var inst_38239 = cljs.core.PersistentHashMap.EMPTY;
var inst_38240 = (function (){var t = inst_38217;
var _ = inst_38232__$1;
var add_flakes = inst_38234__$1;
var add_preds = inst_38238__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_38241 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38240,inst_38238__$1);
var inst_38242__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38239,inst_38241);
var inst_38243 = cljs.core.PersistentHashMap.EMPTY;
var inst_38244 = (function (){var t = inst_38217;
var _ = inst_38232__$1;
var add_flakes = inst_38234__$1;
var add_preds = inst_38238__$1;
var idx_QMARK__map = inst_38242__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_38245 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_38244,inst_38238__$1);
var inst_38246 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_38243,inst_38245);
var inst_38247 = fluree.db.flake.size_bytes(inst_38234__$1);
var inst_38248__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_38234__$1);
var inst_38249 = fluree.db.util.schema.setting_change_QMARK_(inst_38234__$1);
var inst_38250 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_38251 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38250,(0));
var state_38405__$1 = (function (){var statearr_38466 = state_38405;
(statearr_38466[(24)] = inst_38238__$1);

(statearr_38466[(25)] = inst_38242__$1);

(statearr_38466[(10)] = inst_38247);

(statearr_38466[(28)] = inst_38251);

(statearr_38466[(29)] = inst_38234__$1);

(statearr_38466[(30)] = inst_38232__$1);

(statearr_38466[(13)] = inst_38248__$1);

(statearr_38466[(33)] = inst_38249);

(statearr_38466[(34)] = inst_38246);

return statearr_38466;
})();
if(cljs.core.truth_(inst_38248__$1)){
var statearr_38467_38518 = state_38405__$1;
(statearr_38467_38518[(1)] = (9));

} else {
var statearr_38468_38519 = state_38405__$1;
(statearr_38468_38519[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_38469 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38469[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_38469[(1)] = (1));

return statearr_38469;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_38405){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_38405);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e38470){var ex__10753__auto__ = e38470;
var statearr_38471_38520 = state_38405;
(statearr_38471_38520[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_38405[(4)]))){
var statearr_38472_38521 = state_38405;
(statearr_38472_38521[(1)] = cljs.core.first((state_38405[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__38522 = state_38405;
state_38405 = G__38522;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_38405){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_38405);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_38473 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_38473[(6)] = c__10876__auto__);

return statearr_38473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__38524 = arguments.length;
switch (G__38524) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___38671 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_38620){
var state_val_38621 = (state_38620[(1)]);
if((state_val_38621 === (7))){
var state_38620__$1 = state_38620;
var statearr_38622_38672 = state_38620__$1;
(statearr_38622_38672[(2)] = null);

(statearr_38622_38672[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (20))){
var inst_38569 = (state_38620[(7)]);
var inst_38568 = (state_38620[(8)]);
var inst_38570 = (state_38620[(9)]);
var inst_38589 = (inst_38568 + (1));
var inst_38590 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38570,cljs.core.cst$kw$t,inst_38589);
var inst_38591 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_38590,inst_38569,opts);
var state_38620__$1 = state_38620;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38620__$1,(23),inst_38591);
} else {
if((state_val_38621 === (1))){
var state_38620__$1 = state_38620;
var statearr_38623_38673 = state_38620__$1;
(statearr_38623_38673[(2)] = null);

(statearr_38623_38673[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (24))){
var inst_38594 = (state_38620[(10)]);
var inst_38597 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38594,cljs.core.cst$kw$block,block);
var state_38620__$1 = state_38620;
var statearr_38624_38674 = state_38620__$1;
(statearr_38624_38674[(2)] = inst_38597);

(statearr_38624_38674[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (4))){
var inst_38525 = (state_38620[(2)]);
var inst_38526 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38525);
var state_38620__$1 = state_38620;
var statearr_38625_38675 = state_38620__$1;
(statearr_38625_38675[(2)] = inst_38526);

(statearr_38625_38675[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (15))){
var inst_38576 = (state_38620[(11)]);
var state_38620__$1 = state_38620;
var statearr_38626_38676 = state_38620__$1;
(statearr_38626_38676[(2)] = inst_38576);

(statearr_38626_38676[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (21))){
var state_38620__$1 = state_38620;
var statearr_38627_38677 = state_38620__$1;
(statearr_38627_38677[(2)] = null);

(statearr_38627_38677[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (13))){
var inst_38612 = (state_38620[(2)]);
var inst_38613 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38612);
var state_38620__$1 = state_38620;
var statearr_38628_38678 = state_38620__$1;
(statearr_38628_38678[(2)] = inst_38613);

(statearr_38628_38678[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (22))){
var inst_38608 = (state_38620[(2)]);
var state_38620__$1 = state_38620;
var statearr_38629_38679 = state_38620__$1;
(statearr_38629_38679[(2)] = inst_38608);

(statearr_38629_38679[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (6))){
var inst_38536 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_38537 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_38538 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38536)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_38537)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_38539 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38540 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_38541 = cljs.core.PersistentHashMap.fromArrays(inst_38539,inst_38540);
var inst_38542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38538,inst_38541);
var inst_38543 = (function(){throw inst_38542})();
var state_38620__$1 = state_38620;
var statearr_38632_38680 = state_38620__$1;
(statearr_38632_38680[(2)] = inst_38543);

(statearr_38632_38680[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (25))){
var inst_38594 = (state_38620[(10)]);
var inst_38577 = (state_38620[(12)]);
var inst_38576 = (state_38620[(11)]);
var inst_38599 = inst_38576.t;
var inst_38600 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38601 = [inst_38576];
var inst_38602 = (new cljs.core.PersistentVector(null,1,(5),inst_38600,inst_38601,null));
var inst_38567 = inst_38577;
var inst_38568 = inst_38599;
var inst_38569 = inst_38602;
var inst_38570 = inst_38594;
var state_38620__$1 = (function (){var statearr_38633 = state_38620;
(statearr_38633[(7)] = inst_38569);

(statearr_38633[(8)] = inst_38568);

(statearr_38633[(9)] = inst_38570);

(statearr_38633[(13)] = inst_38567);

return statearr_38633;
})();
var statearr_38634_38681 = state_38620__$1;
(statearr_38634_38681[(2)] = null);

(statearr_38634_38681[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (17))){
var inst_38569 = (state_38620[(7)]);
var inst_38577 = (state_38620[(12)]);
var inst_38568 = (state_38620[(8)]);
var inst_38570 = (state_38620[(9)]);
var inst_38576 = (state_38620[(11)]);
var inst_38585 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38569,inst_38576);
var tmp38630 = inst_38568;
var tmp38631 = inst_38570;
var inst_38567 = inst_38577;
var inst_38568__$1 = tmp38630;
var inst_38569__$1 = inst_38585;
var inst_38570__$1 = tmp38631;
var state_38620__$1 = (function (){var statearr_38635 = state_38620;
(statearr_38635[(7)] = inst_38569__$1);

(statearr_38635[(8)] = inst_38568__$1);

(statearr_38635[(9)] = inst_38570__$1);

(statearr_38635[(13)] = inst_38567);

return statearr_38635;
})();
var statearr_38636_38682 = state_38620__$1;
(statearr_38636_38682[(2)] = null);

(statearr_38636_38682[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (3))){
var inst_38618 = (state_38620[(2)]);
var state_38620__$1 = state_38620;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38620__$1,inst_38618);
} else {
if((state_val_38621 === (12))){
var inst_38576 = (state_38620[(11)]);
var inst_38567 = (state_38620[(13)]);
var inst_38575 = cljs.core.seq(inst_38567);
var inst_38576__$1 = cljs.core.first(inst_38575);
var inst_38577 = cljs.core.next(inst_38575);
var state_38620__$1 = (function (){var statearr_38637 = state_38620;
(statearr_38637[(12)] = inst_38577);

(statearr_38637[(11)] = inst_38576__$1);

return statearr_38637;
})();
if(cljs.core.truth_(inst_38576__$1)){
var statearr_38638_38683 = state_38620__$1;
(statearr_38638_38683[(1)] = (14));

} else {
var statearr_38639_38684 = state_38620__$1;
(statearr_38639_38684[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (2))){
var _ = (function (){var statearr_38640 = state_38620;
(statearr_38640[(4)] = cljs.core.cons((5),(state_38620[(4)])));

return statearr_38640;
})();
var inst_38532 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_38533 = (inst_38532 + (1));
var inst_38534 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_38533);
var state_38620__$1 = state_38620;
if(inst_38534){
var statearr_38641_38685 = state_38620__$1;
(statearr_38641_38685[(1)] = (6));

} else {
var statearr_38642_38686 = state_38620__$1;
(statearr_38642_38686[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (23))){
var inst_38576 = (state_38620[(11)]);
var inst_38593 = (state_38620[(2)]);
var inst_38594 = fluree.db.util.async.throw_err(inst_38593);
var inst_38595 = (inst_38576 == null);
var state_38620__$1 = (function (){var statearr_38643 = state_38620;
(statearr_38643[(10)] = inst_38594);

return statearr_38643;
})();
if(cljs.core.truth_(inst_38595)){
var statearr_38644_38687 = state_38620__$1;
(statearr_38644_38687[(1)] = (24));

} else {
var statearr_38645_38688 = state_38620__$1;
(statearr_38645_38688[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (19))){
var inst_38610 = (state_38620[(2)]);
var state_38620__$1 = state_38620;
var statearr_38646_38689 = state_38620__$1;
(statearr_38646_38689[(2)] = inst_38610);

(statearr_38646_38689[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (11))){
var inst_38615 = (state_38620[(2)]);
var _ = (function (){var statearr_38648 = state_38620;
(statearr_38648[(4)] = cljs.core.rest((state_38620[(4)])));

return statearr_38648;
})();
var state_38620__$1 = state_38620;
var statearr_38649_38690 = state_38620__$1;
(statearr_38649_38690[(2)] = inst_38615);

(statearr_38649_38690[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (9))){
var inst_38549 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_38550 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_38549);
var state_38620__$1 = state_38620;
var statearr_38650_38691 = state_38620__$1;
(statearr_38650_38691[(2)] = inst_38550);

(statearr_38650_38691[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (5))){
var _ = (function (){var statearr_38651 = state_38620;
(statearr_38651[(4)] = cljs.core.rest((state_38620[(4)])));

return statearr_38651;
})();
var state_38620__$1 = state_38620;
var ex38647 = (state_38620__$1[(2)]);
var statearr_38652_38692 = state_38620__$1;
(statearr_38652_38692[(5)] = ex38647);


var statearr_38653_38693 = state_38620__$1;
(statearr_38653_38693[(1)] = (4));

(statearr_38653_38693[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (14))){
var inst_38568 = (state_38620[(8)]);
var inst_38576 = (state_38620[(11)]);
var inst_38579 = inst_38576.t;
var inst_38580 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_38568,inst_38579);
var state_38620__$1 = state_38620;
var statearr_38654_38694 = state_38620__$1;
(statearr_38654_38694[(2)] = inst_38580);

(statearr_38654_38694[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (26))){
var inst_38605 = (state_38620[(2)]);
var state_38620__$1 = state_38620;
var statearr_38655_38695 = state_38620__$1;
(statearr_38655_38695[(2)] = inst_38605);

(statearr_38655_38695[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (16))){
var inst_38583 = (state_38620[(2)]);
var state_38620__$1 = state_38620;
if(cljs.core.truth_(inst_38583)){
var statearr_38656_38696 = state_38620__$1;
(statearr_38656_38696[(1)] = (17));

} else {
var statearr_38657_38697 = state_38620__$1;
(statearr_38657_38697[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (10))){
var inst_38552 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_38553 = cljs.core.first(inst_38552);
var inst_38561 = cljs.core.seq(inst_38552);
var inst_38562 = cljs.core.first(inst_38561);
var inst_38563 = cljs.core.next(inst_38561);
var inst_38564 = inst_38553.t;
var inst_38565 = cljs.core.PersistentVector.EMPTY;
var inst_38566 = db;
var inst_38567 = inst_38552;
var inst_38568 = inst_38564;
var inst_38569 = inst_38565;
var inst_38570 = inst_38566;
var state_38620__$1 = (function (){var statearr_38658 = state_38620;
(statearr_38658[(14)] = inst_38562);

(statearr_38658[(7)] = inst_38569);

(statearr_38658[(8)] = inst_38568);

(statearr_38658[(9)] = inst_38570);

(statearr_38658[(13)] = inst_38567);

(statearr_38658[(15)] = inst_38563);

return statearr_38658;
})();
var statearr_38659_38698 = state_38620__$1;
(statearr_38659_38698[(2)] = null);

(statearr_38659_38698[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (18))){
var state_38620__$1 = state_38620;
var statearr_38660_38699 = state_38620__$1;
(statearr_38660_38699[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38621 === (8))){
var inst_38546 = (state_38620[(2)]);
var inst_38547 = cljs.core.empty_QMARK_(flakes);
var state_38620__$1 = (function (){var statearr_38662 = state_38620;
(statearr_38662[(16)] = inst_38546);

return statearr_38662;
})();
if(inst_38547){
var statearr_38663_38700 = state_38620__$1;
(statearr_38663_38700[(1)] = (9));

} else {
var statearr_38664_38701 = state_38620__$1;
(statearr_38664_38701[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_38665 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38665[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_38665[(1)] = (1));

return statearr_38665;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_38620){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_38620);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e38666){var ex__10753__auto__ = e38666;
var statearr_38667_38702 = state_38620;
(statearr_38667_38702[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_38620[(4)]))){
var statearr_38668_38703 = state_38620;
(statearr_38668_38703[(1)] = cljs.core.first((state_38620[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__38704 = state_38620;
state_38620 = G__38704;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_38620){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_38620);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_38669 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_38669[(6)] = c__10876__auto___38671);

return statearr_38669;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_38760){
var state_val_38761 = (state_38760[(1)]);
if((state_val_38761 === (7))){
var state_38760__$1 = state_38760;
var statearr_38762_38789 = state_38760__$1;
(statearr_38762_38789[(2)] = tt_id);

(statearr_38762_38789[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (1))){
var state_38760__$1 = state_38760;
var statearr_38763_38790 = state_38760__$1;
(statearr_38763_38790[(2)] = null);

(statearr_38763_38790[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (4))){
var inst_38705 = (state_38760[(2)]);
var state_38760__$1 = state_38760;
var statearr_38764_38791 = state_38760__$1;
(statearr_38764_38791[(2)] = inst_38705);

(statearr_38764_38791[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (13))){
var inst_38753 = (state_38760[(2)]);
var state_38760__$1 = state_38760;
var statearr_38765_38792 = state_38760__$1;
(statearr_38765_38792[(2)] = inst_38753);

(statearr_38765_38792[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (6))){
var inst_38713 = fluree.db.util.core.random_uuid();
var state_38760__$1 = state_38760;
var statearr_38766_38793 = state_38760__$1;
(statearr_38766_38793[(2)] = inst_38713);

(statearr_38766_38793[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (3))){
var inst_38758 = (state_38760[(2)]);
var state_38760__$1 = state_38760;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38760__$1,inst_38758);
} else {
if((state_val_38761 === (12))){
var inst_38736 = (state_38760[(7)]);
var state_38760__$1 = state_38760;
var statearr_38767_38794 = state_38760__$1;
(statearr_38767_38794[(2)] = inst_38736);

(statearr_38767_38794[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (2))){
var _ = (function (){var statearr_38768 = state_38760;
(statearr_38768[(4)] = cljs.core.cons((5),(state_38760[(4)])));

return statearr_38768;
})();
var inst_38711 = (tt_id == null);
var state_38760__$1 = state_38760;
if(cljs.core.truth_(inst_38711)){
var statearr_38769_38795 = state_38760__$1;
(statearr_38769_38795[(1)] = (6));

} else {
var statearr_38770_38796 = state_38760__$1;
(statearr_38770_38796[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (11))){
var inst_38736 = (state_38760[(7)]);
var inst_38743 = (state_38760[(8)]);
var inst_38746 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_38736,inst_38743);
var state_38760__$1 = state_38760;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38760__$1,(14),inst_38746);
} else {
if((state_val_38761 === (9))){
var inst_38737 = (state_38760[(9)]);
var inst_38743 = (state_38760[(8)]);
var inst_38742 = cljs.core.seq(inst_38737);
var inst_38743__$1 = cljs.core.first(inst_38742);
var inst_38744 = cljs.core.next(inst_38742);
var state_38760__$1 = (function (){var statearr_38772 = state_38760;
(statearr_38772[(10)] = inst_38744);

(statearr_38772[(8)] = inst_38743__$1);

return statearr_38772;
})();
if(cljs.core.truth_(inst_38743__$1)){
var statearr_38773_38797 = state_38760__$1;
(statearr_38773_38797[(1)] = (11));

} else {
var statearr_38774_38798 = state_38760__$1;
(statearr_38774_38798[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (5))){
var _ = (function (){var statearr_38775 = state_38760;
(statearr_38775[(4)] = cljs.core.rest((state_38760[(4)])));

return statearr_38775;
})();
var state_38760__$1 = state_38760;
var ex38771 = (state_38760__$1[(2)]);
var statearr_38776_38799 = state_38760__$1;
(statearr_38776_38799[(5)] = ex38771);


if((ex38771 instanceof Error)){
var statearr_38777_38800 = state_38760__$1;
(statearr_38777_38800[(1)] = (4));

(statearr_38777_38800[(5)] = null);

} else {
throw ex38771;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (14))){
var inst_38744 = (state_38760[(10)]);
var inst_38748 = (state_38760[(2)]);
var inst_38749 = fluree.db.util.async.throw_err(inst_38748);
var inst_38736 = inst_38749;
var inst_38737 = inst_38744;
var state_38760__$1 = (function (){var statearr_38778 = state_38760;
(statearr_38778[(9)] = inst_38737);

(statearr_38778[(7)] = inst_38736);

return statearr_38778;
})();
var statearr_38779_38801 = state_38760__$1;
(statearr_38779_38801[(2)] = null);

(statearr_38779_38801[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (10))){
var inst_38755 = (state_38760[(2)]);
var _ = (function (){var statearr_38780 = state_38760;
(statearr_38780[(4)] = cljs.core.rest((state_38760[(4)])));

return statearr_38780;
})();
var state_38760__$1 = state_38760;
var statearr_38781_38802 = state_38760__$1;
(statearr_38781_38802[(2)] = inst_38755);

(statearr_38781_38802[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38761 === (8))){
var inst_38716 = (state_38760[(2)]);
var inst_38717 = (function (){var tt_id_SINGLEQUOTE_ = inst_38716;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_38718 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_38716);
var inst_38719 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38720 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_38721 = (new cljs.core.PersistentVector(null,4,(5),inst_38719,inst_38720,null));
var inst_38722 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_38717,inst_38718,inst_38721);
var inst_38723 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_38724 = cljs.core.reverse(inst_38723);
var inst_38725 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_38724);
var inst_38733 = cljs.core.seq(inst_38725);
var inst_38734 = cljs.core.first(inst_38733);
var inst_38735 = cljs.core.next(inst_38733);
var inst_38736 = inst_38722;
var inst_38737 = inst_38725;
var state_38760__$1 = (function (){var statearr_38782 = state_38760;
(statearr_38782[(11)] = inst_38735);

(statearr_38782[(9)] = inst_38737);

(statearr_38782[(7)] = inst_38736);

(statearr_38782[(12)] = inst_38734);

return statearr_38782;
})();
var statearr_38783_38803 = state_38760__$1;
(statearr_38783_38803[(2)] = null);

(statearr_38783_38803[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____0 = (function (){
var statearr_38784 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38784[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__);

(statearr_38784[(1)] = (1));

return statearr_38784;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____1 = (function (state_38760){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_38760);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e38785){var ex__10753__auto__ = e38785;
var statearr_38786_38804 = state_38760;
(statearr_38786_38804[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_38760[(4)]))){
var statearr_38787_38805 = state_38760;
(statearr_38787_38805[(1)] = cljs.core.first((state_38760[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__38806 = state_38760;
state_38760 = G__38806;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__ = function(state_38760){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____1.call(this,state_38760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_38788 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_38788[(6)] = c__10876__auto__);

return statearr_38788;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__10876__auto___38993 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_38924){
var state_val_38925 = (state_38924[(1)]);
if((state_val_38925 === (7))){
var inst_38834 = (state_38924[(7)]);
var inst_38834__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_38924__$1 = (function (){var statearr_38926 = state_38924;
(statearr_38926[(7)] = inst_38834__$1);

return statearr_38926;
})();
if(inst_38834__$1){
var statearr_38927_38994 = state_38924__$1;
(statearr_38927_38994[(1)] = (13));

} else {
var statearr_38928_38995 = state_38924__$1;
(statearr_38928_38995[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (20))){
var state_38924__$1 = state_38924;
var statearr_38929_38996 = state_38924__$1;
(statearr_38929_38996[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (27))){
var inst_38870 = (state_38924[(8)]);
var inst_38874 = inst_38870.s;
var state_38924__$1 = state_38924;
var statearr_38931_38997 = state_38924__$1;
(statearr_38931_38997[(2)] = inst_38874);

(statearr_38931_38997[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (1))){
var state_38924__$1 = state_38924;
var statearr_38932_38998 = state_38924__$1;
(statearr_38932_38998[(2)] = null);

(statearr_38932_38998[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (24))){
var inst_38864 = (state_38924[(9)]);
var inst_38868 = cljs.core.first(inst_38864);
var state_38924__$1 = state_38924;
var statearr_38933_38999 = state_38924__$1;
(statearr_38933_38999[(2)] = inst_38868);

(statearr_38933_38999[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (39))){
var state_38924__$1 = state_38924;
var statearr_38934_39000 = state_38924__$1;
(statearr_38934_39000[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (4))){
var inst_38807 = (state_38924[(2)]);
var inst_38808 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38809 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38810 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_38811 = cljs.core.PersistentHashMap.fromArrays(inst_38809,inst_38810);
var inst_38812 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_38808,inst_38811,inst_38807);
var inst_38813 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38812);
var state_38924__$1 = state_38924;
var statearr_38936_39001 = state_38924__$1;
(statearr_38936_39001[(2)] = inst_38813);

(statearr_38936_39001[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (15))){
var inst_38841 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
if(cljs.core.truth_(inst_38841)){
var statearr_38937_39002 = state_38924__$1;
(statearr_38937_39002[(1)] = (16));

} else {
var statearr_38938_39003 = state_38924__$1;
(statearr_38938_39003[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (21))){
var inst_38890 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38939_39004 = state_38924__$1;
(statearr_38939_39004[(2)] = inst_38890);

(statearr_38939_39004[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (31))){
var inst_38888 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38940_39005 = state_38924__$1;
(statearr_38940_39005[(2)] = inst_38888);

(statearr_38940_39005[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (32))){
var inst_38894 = (state_38924[(10)]);
var inst_38896 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38894);
var state_38924__$1 = state_38924;
var statearr_38941_39006 = state_38924__$1;
(statearr_38941_39006[(2)] = inst_38896);

(statearr_38941_39006[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (40))){
var inst_38917 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38942_39007 = state_38924__$1;
(statearr_38942_39007[(2)] = inst_38917);

(statearr_38942_39007[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (33))){
var inst_38898 = (state_38924[(11)]);
var inst_38894 = (state_38924[(10)]);
var inst_38898__$1 = (inst_38894 == null);
var state_38924__$1 = (function (){var statearr_38943 = state_38924;
(statearr_38943[(11)] = inst_38898__$1);

return statearr_38943;
})();
if(cljs.core.truth_(inst_38898__$1)){
var statearr_38944_39008 = state_38924__$1;
(statearr_38944_39008[(1)] = (35));

} else {
var statearr_38945_39009 = state_38924__$1;
(statearr_38945_39009[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (13))){
var inst_38836 = cljs.core.first(ident);
var inst_38837 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_38836);
var inst_38838 = (inst_38837 == null);
var state_38924__$1 = state_38924;
var statearr_38946_39010 = state_38924__$1;
(statearr_38946_39010[(2)] = inst_38838);

(statearr_38946_39010[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (22))){
var inst_38864 = (state_38924[(9)]);
var inst_38863 = (state_38924[(2)]);
var inst_38864__$1 = fluree.db.util.async.throw_err(inst_38863);
var inst_38865 = (inst_38864__$1 == null);
var state_38924__$1 = (function (){var statearr_38947 = state_38924;
(statearr_38947[(9)] = inst_38864__$1);

return statearr_38947;
})();
if(cljs.core.truth_(inst_38865)){
var statearr_38948_39011 = state_38924__$1;
(statearr_38948_39011[(1)] = (23));

} else {
var statearr_38949_39012 = state_38924__$1;
(statearr_38949_39012[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (36))){
var inst_38898 = (state_38924[(11)]);
var state_38924__$1 = state_38924;
var statearr_38950_39013 = state_38924__$1;
(statearr_38950_39013[(2)] = inst_38898);

(statearr_38950_39013[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (41))){
var inst_38912 = cljs.core.async.close_BANG_(return_chan);
var state_38924__$1 = state_38924;
var statearr_38951_39014 = state_38924__$1;
(statearr_38951_39014[(2)] = inst_38912);

(statearr_38951_39014[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (43))){
var inst_38915 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38952_39015 = state_38924__$1;
(statearr_38952_39015[(2)] = inst_38915);

(statearr_38952_39015[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (29))){
var inst_38879 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_38880 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_38879].join('');
var inst_38881 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38882 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_38883 = cljs.core.PersistentHashMap.fromArrays(inst_38881,inst_38882);
var inst_38884 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38880,inst_38883);
var inst_38885 = (function(){throw inst_38884})();
var state_38924__$1 = state_38924;
var statearr_38953_39016 = state_38924__$1;
(statearr_38953_39016[(2)] = inst_38885);

(statearr_38953_39016[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (6))){
var inst_38821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38822 = [ident];
var inst_38823 = (new cljs.core.PersistentVector(null,1,(5),inst_38821,inst_38822,null));
var inst_38824 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38823);
var state_38924__$1 = state_38924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38924__$1,(9),inst_38824);
} else {
if((state_val_38925 === (28))){
var inst_38876 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38954_39017 = state_38924__$1;
(statearr_38954_39017[(2)] = inst_38876);

(statearr_38954_39017[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (25))){
var inst_38870 = (state_38924[(8)]);
var inst_38870__$1 = (state_38924[(2)]);
var inst_38871 = (inst_38870__$1 == null);
var state_38924__$1 = (function (){var statearr_38955 = state_38924;
(statearr_38955[(8)] = inst_38870__$1);

return statearr_38955;
})();
if(cljs.core.truth_(inst_38871)){
var statearr_38956_39018 = state_38924__$1;
(statearr_38956_39018[(1)] = (26));

} else {
var statearr_38957_39019 = state_38924__$1;
(statearr_38957_39019[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (34))){
var inst_38919 = (state_38924[(2)]);
var _ = (function (){var statearr_38958 = state_38924;
(statearr_38958[(4)] = cljs.core.rest((state_38924[(4)])));

return statearr_38958;
})();
var state_38924__$1 = state_38924;
var statearr_38959_39020 = state_38924__$1;
(statearr_38959_39020[(2)] = inst_38919);

(statearr_38959_39020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (17))){
var inst_38852 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_38924__$1 = state_38924;
if(inst_38852){
var statearr_38960_39021 = state_38924__$1;
(statearr_38960_39021[(1)] = (19));

} else {
var statearr_38961_39022 = state_38924__$1;
(statearr_38961_39022[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (3))){
var inst_38922 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38924__$1,inst_38922);
} else {
if((state_val_38925 === (12))){
var inst_38832 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38962_39023 = state_38924__$1;
(statearr_38962_39023[(2)] = inst_38832);

(statearr_38962_39023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (2))){
var _ = (function (){var statearr_38963 = state_38924;
(statearr_38963[(4)] = cljs.core.cons((5),(state_38924[(4)])));

return statearr_38963;
})();
var inst_38819 = typeof ident === 'number';
var state_38924__$1 = state_38924;
if(cljs.core.truth_(inst_38819)){
var statearr_38964_39024 = state_38924__$1;
(statearr_38964_39024[(1)] = (6));

} else {
var statearr_38965_39025 = state_38924__$1;
(statearr_38965_39025[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (23))){
var state_38924__$1 = state_38924;
var statearr_38966_39026 = state_38924__$1;
(statearr_38966_39026[(2)] = null);

(statearr_38966_39026[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (35))){
var state_38924__$1 = state_38924;
var statearr_38967_39027 = state_38924__$1;
(statearr_38967_39027[(2)] = strict_QMARK_);

(statearr_38967_39027[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (19))){
var inst_38855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38856 = cljs.core.first(ident);
var inst_38857 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_38856);
var inst_38858 = cljs.core.second(ident);
var inst_38859 = [inst_38857,inst_38858];
var inst_38860 = (new cljs.core.PersistentVector(null,2,(5),inst_38855,inst_38859,null));
var inst_38861 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_38860);
var state_38924__$1 = state_38924;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38924__$1,(22),inst_38861);
} else {
if((state_val_38925 === (11))){
var state_38924__$1 = state_38924;
var statearr_38969_39028 = state_38924__$1;
(statearr_38969_39028[(2)] = null);

(statearr_38969_39028[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (9))){
var inst_38826 = (state_38924[(2)]);
var inst_38827 = fluree.db.util.async.throw_err(inst_38826);
var inst_38828 = cljs.core.not_empty(inst_38827);
var state_38924__$1 = state_38924;
if(cljs.core.truth_(inst_38828)){
var statearr_38970_39029 = state_38924__$1;
(statearr_38970_39029[(1)] = (10));

} else {
var statearr_38971_39030 = state_38924__$1;
(statearr_38971_39030[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (5))){
var _ = (function (){var statearr_38972 = state_38924;
(statearr_38972[(4)] = cljs.core.rest((state_38924[(4)])));

return statearr_38972;
})();
var state_38924__$1 = state_38924;
var ex38968 = (state_38924__$1[(2)]);
var statearr_38973_39031 = state_38924__$1;
(statearr_38973_39031[(5)] = ex38968);


var statearr_38974_39032 = state_38924__$1;
(statearr_38974_39032[(1)] = (4));

(statearr_38974_39032[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (14))){
var inst_38834 = (state_38924[(7)]);
var state_38924__$1 = state_38924;
var statearr_38975_39033 = state_38924__$1;
(statearr_38975_39033[(2)] = inst_38834);

(statearr_38975_39033[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (26))){
var state_38924__$1 = state_38924;
var statearr_38976_39034 = state_38924__$1;
(statearr_38976_39034[(2)] = null);

(statearr_38976_39034[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (16))){
var inst_38843 = cljs.core.first(ident);
var inst_38844 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_38843], 0));
var inst_38845 = ["Subject ID lookup failed. The predicate ",inst_38844," does not exist."].join('');
var inst_38846 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38847 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_38848 = cljs.core.PersistentHashMap.fromArrays(inst_38846,inst_38847);
var inst_38849 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38845,inst_38848);
var inst_38850 = (function(){throw inst_38849})();
var state_38924__$1 = state_38924;
var statearr_38977_39035 = state_38924__$1;
(statearr_38977_39035[(2)] = inst_38850);

(statearr_38977_39035[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (38))){
var inst_38904 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_38905 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_38906 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_38907 = cljs.core.PersistentHashMap.fromArrays(inst_38905,inst_38906);
var inst_38908 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_38904,inst_38907);
var inst_38909 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_38908);
var state_38924__$1 = state_38924;
var statearr_38978_39036 = state_38924__$1;
(statearr_38978_39036[(2)] = inst_38909);

(statearr_38978_39036[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (30))){
var state_38924__$1 = state_38924;
var statearr_38979_39037 = state_38924__$1;
(statearr_38979_39037[(2)] = null);

(statearr_38979_39037[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (10))){
var state_38924__$1 = state_38924;
var statearr_38980_39038 = state_38924__$1;
(statearr_38980_39038[(2)] = ident);

(statearr_38980_39038[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (18))){
var inst_38892 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
var statearr_38981_39039 = state_38924__$1;
(statearr_38981_39039[(2)] = inst_38892);

(statearr_38981_39039[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (42))){
var state_38924__$1 = state_38924;
var statearr_38982_39040 = state_38924__$1;
(statearr_38982_39040[(2)] = null);

(statearr_38982_39040[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (37))){
var inst_38902 = (state_38924[(2)]);
var state_38924__$1 = state_38924;
if(cljs.core.truth_(inst_38902)){
var statearr_38983_39041 = state_38924__$1;
(statearr_38983_39041[(1)] = (38));

} else {
var statearr_38984_39042 = state_38924__$1;
(statearr_38984_39042[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38925 === (8))){
var inst_38894 = (state_38924[(10)]);
var inst_38894__$1 = (state_38924[(2)]);
var state_38924__$1 = (function (){var statearr_38985 = state_38924;
(statearr_38985[(10)] = inst_38894__$1);

return statearr_38985;
})();
if(cljs.core.truth_(inst_38894__$1)){
var statearr_38986_39043 = state_38924__$1;
(statearr_38986_39043[(1)] = (32));

} else {
var statearr_38987_39044 = state_38924__$1;
(statearr_38987_39044[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__10750__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__10750__auto____0 = (function (){
var statearr_38988 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38988[(0)] = fluree$db$graphdb$subid_$_state_machine__10750__auto__);

(statearr_38988[(1)] = (1));

return statearr_38988;
});
var fluree$db$graphdb$subid_$_state_machine__10750__auto____1 = (function (state_38924){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_38924);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e38989){var ex__10753__auto__ = e38989;
var statearr_38990_39045 = state_38924;
(statearr_38990_39045[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_38924[(4)]))){
var statearr_38991_39046 = state_38924;
(statearr_38991_39046[(1)] = cljs.core.first((state_38924[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39047 = state_38924;
state_38924 = G__39047;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__10750__auto__ = function(state_38924){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__10750__auto____1.call(this,state_38924);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__10750__auto____0;
fluree$db$graphdb$subid_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__10750__auto____1;
return fluree$db$graphdb$subid_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_38992 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_38992[(6)] = c__10876__auto___38993);

return statearr_38992;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__39048){
var map__39049 = p__39048;
var map__39049__$1 = cljs.core.__destructure_map(map__39049);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39049__$1,cljs.core.cst$kw$current_DASH_db_DASH_fn);
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39049__$1,cljs.core.cst$kw$permissions);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39065){
var state_val_39066 = (state_39065[(1)]);
if((state_val_39066 === (1))){
var state_39065__$1 = state_39065;
var statearr_39067_39081 = state_39065__$1;
(statearr_39067_39081[(2)] = null);

(statearr_39067_39081[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39066 === (2))){
var _ = (function (){var statearr_39068 = state_39065;
(statearr_39068[(4)] = cljs.core.cons((5),(state_39065[(4)])));

return statearr_39068;
})();
var inst_39056 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_39065__$1 = state_39065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39065__$1,(6),inst_39056);
} else {
if((state_val_39066 === (3))){
var inst_39063 = (state_39065[(2)]);
var state_39065__$1 = state_39065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39065__$1,inst_39063);
} else {
if((state_val_39066 === (4))){
var inst_39050 = (state_39065[(2)]);
var state_39065__$1 = state_39065;
var statearr_39070_39082 = state_39065__$1;
(statearr_39070_39082[(2)] = inst_39050);

(statearr_39070_39082[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39066 === (5))){
var _ = (function (){var statearr_39071 = state_39065;
(statearr_39071[(4)] = cljs.core.rest((state_39065[(4)])));

return statearr_39071;
})();
var state_39065__$1 = state_39065;
var ex39069 = (state_39065__$1[(2)]);
var statearr_39072_39083 = state_39065__$1;
(statearr_39072_39083[(5)] = ex39069);


if((ex39069 instanceof Error)){
var statearr_39073_39084 = state_39065__$1;
(statearr_39073_39084[(1)] = (4));

(statearr_39073_39084[(5)] = null);

} else {
throw ex39069;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39066 === (6))){
var inst_39058 = (state_39065[(2)]);
var inst_39059 = fluree.db.util.async.throw_err(inst_39058);
var inst_39060 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39059,cljs.core.cst$kw$permissions,permissions);
var _ = (function (){var statearr_39074 = state_39065;
(statearr_39074[(4)] = cljs.core.rest((state_39065[(4)])));

return statearr_39074;
})();
var state_39065__$1 = state_39065;
var statearr_39075_39085 = state_39065__$1;
(statearr_39075_39085[(2)] = inst_39060);

(statearr_39075_39085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____0 = (function (){
var statearr_39076 = [null,null,null,null,null,null,null];
(statearr_39076[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__);

(statearr_39076[(1)] = (1));

return statearr_39076;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____1 = (function (state_39065){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39065);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39077){var ex__10753__auto__ = e39077;
var statearr_39078_39086 = state_39065;
(statearr_39078_39086[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39065[(4)]))){
var statearr_39079_39087 = state_39065;
(statearr_39079_39087[(1)] = cljs.core.first((state_39065[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39088 = state_39065;
state_39065 = G__39088;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__ = function(state_39065){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____1.call(this,state_39065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39080 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39080[(6)] = c__10876__auto__);

return statearr_39080;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__39089,property,collection){
var map__39090 = p__39089;
var map__39090__$1 = cljs.core.__destructure_map(map__39090);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39090__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__39091 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__39091.cljs$core$IFn$_invoke$arity$1 ? fexpr__39091.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39091.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__39092,property,predicate){
var map__39093 = p__39092;
var map__39093__$1 = cljs.core.__destructure_map(map__39093);
var this$ = map__39093__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39093__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__39094 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__39094.cljs$core$IFn$_invoke$arity$1 ? fexpr__39094.cljs$core$IFn$_invoke$arity$1(property) : fexpr__39094.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__39095 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return fluree.db.dbproto._c_prop(this$,cljs.core.cst$kw$partition,G__39095);
} else {
return G__39095;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return cljs.core.cst$kw$fluree$db$graphdb_SLASH_no_DASH_pred;
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__39097 = arguments.length;
switch (G__39097) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39129){
var state_val_39130 = (state_39129[(1)]);
if((state_val_39130 === (7))){
var state_39129__$1 = state_39129;
var statearr_39131_39225 = state_39129__$1;
(statearr_39131_39225[(2)] = null);

(statearr_39131_39225[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (1))){
var state_39129__$1 = state_39129;
var statearr_39132_39226 = state_39129__$1;
(statearr_39132_39226[(2)] = null);

(statearr_39132_39226[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (4))){
var inst_39098 = (state_39129[(2)]);
var state_39129__$1 = state_39129;
var statearr_39133_39227 = state_39129__$1;
(statearr_39133_39227[(2)] = inst_39098);

(statearr_39133_39227[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (6))){
var inst_39112 = (state_39129[(7)]);
var inst_39111 = (state_39129[(2)]);
var inst_39112__$1 = fluree.db.util.async.throw_err(inst_39111);
var inst_39113 = (inst_39112__$1 == null);
var state_39129__$1 = (function (){var statearr_39134 = state_39129;
(statearr_39134[(7)] = inst_39112__$1);

return statearr_39134;
})();
if(cljs.core.truth_(inst_39113)){
var statearr_39135_39228 = state_39129__$1;
(statearr_39135_39228[(1)] = (7));

} else {
var statearr_39136_39229 = state_39129__$1;
(statearr_39136_39229[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (3))){
var inst_39127 = (state_39129[(2)]);
var state_39129__$1 = state_39129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39129__$1,inst_39127);
} else {
if((state_val_39130 === (12))){
var inst_39124 = (state_39129[(2)]);
var _ = (function (){var statearr_39137 = state_39129;
(statearr_39137[(4)] = cljs.core.rest((state_39129[(4)])));

return statearr_39137;
})();
var state_39129__$1 = state_39129;
var statearr_39138_39230 = state_39129__$1;
(statearr_39138_39230[(2)] = inst_39124);

(statearr_39138_39230[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (2))){
var _ = (function (){var statearr_39139 = state_39129;
(statearr_39139[(4)] = cljs.core.cons((5),(state_39129[(4)])));

return statearr_39139;
})();
var inst_39105 = fluree.db.dbproto._rootdb(this$);
var inst_39106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39107 = [tag_id,(30)];
var inst_39108 = (new cljs.core.PersistentVector(null,2,(5),inst_39106,inst_39107,null));
var inst_39109 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39105,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39108);
var state_39129__$1 = state_39129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39129__$1,(6),inst_39109);
} else {
if((state_val_39130 === (11))){
var inst_39118 = (state_39129[(8)]);
var inst_39122 = inst_39118.o;
var state_39129__$1 = state_39129;
var statearr_39141_39231 = state_39129__$1;
(statearr_39141_39231[(2)] = inst_39122);

(statearr_39141_39231[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (9))){
var inst_39118 = (state_39129[(8)]);
var inst_39118__$1 = (state_39129[(2)]);
var inst_39119 = (inst_39118__$1 == null);
var state_39129__$1 = (function (){var statearr_39142 = state_39129;
(statearr_39142[(8)] = inst_39118__$1);

return statearr_39142;
})();
if(cljs.core.truth_(inst_39119)){
var statearr_39143_39232 = state_39129__$1;
(statearr_39143_39232[(1)] = (10));

} else {
var statearr_39144_39233 = state_39129__$1;
(statearr_39144_39233[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (5))){
var _ = (function (){var statearr_39145 = state_39129;
(statearr_39145[(4)] = cljs.core.rest((state_39129[(4)])));

return statearr_39145;
})();
var state_39129__$1 = state_39129;
var ex39140 = (state_39129__$1[(2)]);
var statearr_39146_39234 = state_39129__$1;
(statearr_39146_39234[(5)] = ex39140);


if((ex39140 instanceof Error)){
var statearr_39147_39235 = state_39129__$1;
(statearr_39147_39235[(1)] = (4));

(statearr_39147_39235[(5)] = null);

} else {
throw ex39140;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (10))){
var state_39129__$1 = state_39129;
var statearr_39148_39236 = state_39129__$1;
(statearr_39148_39236[(2)] = null);

(statearr_39148_39236[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39130 === (8))){
var inst_39112 = (state_39129[(7)]);
var inst_39116 = cljs.core.first(inst_39112);
var state_39129__$1 = state_39129;
var statearr_39149_39237 = state_39129__$1;
(statearr_39149_39237[(2)] = inst_39116);

(statearr_39149_39237[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_39150 = [null,null,null,null,null,null,null,null,null];
(statearr_39150[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_39150[(1)] = (1));

return statearr_39150;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_39129){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39129);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39151){var ex__10753__auto__ = e39151;
var statearr_39152_39238 = state_39129;
(statearr_39152_39238[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39129[(4)]))){
var statearr_39153_39239 = state_39129;
(statearr_39153_39239[(1)] = cljs.core.first((state_39129[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39240 = state_39129;
state_39129 = G__39240;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_39129){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_39129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39154 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39154[(6)] = c__10876__auto__);

return statearr_39154;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39190){
var state_val_39191 = (state_39190[(1)]);
if((state_val_39191 === (7))){
var inst_39164 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_39190__$1 = state_39190;
var statearr_39192_39241 = state_39190__$1;
(statearr_39192_39241[(2)] = inst_39164);

(statearr_39192_39241[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (1))){
var state_39190__$1 = state_39190;
var statearr_39193_39242 = state_39190__$1;
(statearr_39193_39242[(2)] = null);

(statearr_39193_39242[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (4))){
var inst_39155 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
var statearr_39194_39243 = state_39190__$1;
(statearr_39194_39243[(2)] = inst_39155);

(statearr_39194_39243[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (15))){
var inst_39185 = (state_39190[(2)]);
var _ = (function (){var statearr_39195 = state_39190;
(statearr_39195[(4)] = cljs.core.rest((state_39190[(4)])));

return statearr_39195;
})();
var state_39190__$1 = state_39190;
var statearr_39196_39244 = state_39190__$1;
(statearr_39196_39244[(2)] = inst_39185);

(statearr_39196_39244[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (13))){
var inst_39170 = (state_39190[(7)]);
var inst_39176 = clojure.string.includes_QMARK_(inst_39170,":");
var state_39190__$1 = state_39190;
if(inst_39176){
var statearr_39197_39245 = state_39190__$1;
(statearr_39197_39245[(1)] = (16));

} else {
var statearr_39198_39246 = state_39190__$1;
(statearr_39198_39246[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (6))){
var state_39190__$1 = state_39190;
var statearr_39199_39247 = state_39190__$1;
(statearr_39199_39247[(2)] = pred);

(statearr_39199_39247[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (17))){
var inst_39170 = (state_39190[(7)]);
var state_39190__$1 = state_39190;
var statearr_39200_39248 = state_39190__$1;
(statearr_39200_39248[(2)] = inst_39170);

(statearr_39200_39248[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (3))){
var inst_39188 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39190__$1,inst_39188);
} else {
if((state_val_39191 === (12))){
var inst_39174 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
if(cljs.core.truth_(inst_39174)){
var statearr_39201_39249 = state_39190__$1;
(statearr_39201_39249[(1)] = (13));

} else {
var statearr_39202_39250 = state_39190__$1;
(statearr_39202_39250[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (2))){
var _ = (function (){var statearr_39203 = state_39190;
(statearr_39203[(4)] = cljs.core.cons((5),(state_39190[(4)])));

return statearr_39203;
})();
var inst_39161 = typeof pred === 'string';
var state_39190__$1 = state_39190;
if(cljs.core.truth_(inst_39161)){
var statearr_39204_39251 = state_39190__$1;
(statearr_39204_39251[(1)] = (6));

} else {
var statearr_39205_39252 = state_39190__$1;
(statearr_39205_39252[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (11))){
var inst_39166 = (state_39190[(8)]);
var state_39190__$1 = state_39190;
var statearr_39207_39253 = state_39190__$1;
(statearr_39207_39253[(2)] = inst_39166);

(statearr_39207_39253[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (9))){
var inst_39166 = (state_39190[(8)]);
var inst_39169 = (state_39190[(2)]);
var inst_39170 = fluree.db.util.async.throw_err(inst_39169);
var state_39190__$1 = (function (){var statearr_39208 = state_39190;
(statearr_39208[(7)] = inst_39170);

return statearr_39208;
})();
if(cljs.core.truth_(inst_39166)){
var statearr_39209_39254 = state_39190__$1;
(statearr_39209_39254[(1)] = (10));

} else {
var statearr_39210_39255 = state_39190__$1;
(statearr_39210_39255[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (5))){
var _ = (function (){var statearr_39211 = state_39190;
(statearr_39211[(4)] = cljs.core.rest((state_39190[(4)])));

return statearr_39211;
})();
var state_39190__$1 = state_39190;
var ex39206 = (state_39190__$1[(2)]);
var statearr_39212_39256 = state_39190__$1;
(statearr_39212_39256[(5)] = ex39206);


if((ex39206 instanceof Error)){
var statearr_39213_39257 = state_39190__$1;
(statearr_39213_39257[(1)] = (4));

(statearr_39213_39257[(5)] = null);

} else {
throw ex39206;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (14))){
var state_39190__$1 = state_39190;
var statearr_39214_39258 = state_39190__$1;
(statearr_39214_39258[(2)] = null);

(statearr_39214_39258[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (16))){
var inst_39170 = (state_39190[(7)]);
var inst_39178 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_39170,/:/);
var inst_39179 = cljs.core.second(inst_39178);
var state_39190__$1 = state_39190;
var statearr_39215_39259 = state_39190__$1;
(statearr_39215_39259[(2)] = inst_39179);

(statearr_39215_39259[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (10))){
var inst_39170 = (state_39190[(7)]);
var state_39190__$1 = state_39190;
var statearr_39216_39260 = state_39190__$1;
(statearr_39216_39260[(2)] = inst_39170);

(statearr_39216_39260[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (18))){
var inst_39182 = (state_39190[(2)]);
var state_39190__$1 = state_39190;
var statearr_39217_39261 = state_39190__$1;
(statearr_39217_39261[(2)] = inst_39182);

(statearr_39217_39261[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39191 === (8))){
var inst_39166 = (state_39190[(2)]);
var inst_39167 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_39190__$1 = (function (){var statearr_39218 = state_39190;
(statearr_39218[(8)] = inst_39166);

return statearr_39218;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39190__$1,(9),inst_39167);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_39219 = [null,null,null,null,null,null,null,null,null];
(statearr_39219[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_39219[(1)] = (1));

return statearr_39219;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_39190){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39190);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39220){var ex__10753__auto__ = e39220;
var statearr_39221_39262 = state_39190;
(statearr_39221_39262[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39190[(4)]))){
var statearr_39222_39263 = state_39190;
(statearr_39222_39263[(1)] = cljs.core.first((state_39190[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39264 = state_39190;
state_39190 = G__39264;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_39190){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_39190);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39223 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39223[(6)] = c__10876__auto__);

return statearr_39223;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__39266 = arguments.length;
switch (G__39266) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39299){
var state_val_39300 = (state_39299[(1)]);
if((state_val_39300 === (7))){
var state_39299__$1 = state_39299;
var statearr_39301_39389 = state_39299__$1;
(statearr_39301_39389[(2)] = null);

(statearr_39301_39389[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (1))){
var state_39299__$1 = state_39299;
var statearr_39302_39390 = state_39299__$1;
(statearr_39302_39390[(2)] = null);

(statearr_39302_39390[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (4))){
var inst_39267 = (state_39299[(2)]);
var state_39299__$1 = state_39299;
var statearr_39303_39391 = state_39299__$1;
(statearr_39303_39391[(2)] = inst_39267);

(statearr_39303_39391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (6))){
var inst_39282 = (state_39299[(7)]);
var inst_39281 = (state_39299[(2)]);
var inst_39282__$1 = fluree.db.util.async.throw_err(inst_39281);
var inst_39283 = (inst_39282__$1 == null);
var state_39299__$1 = (function (){var statearr_39304 = state_39299;
(statearr_39304[(7)] = inst_39282__$1);

return statearr_39304;
})();
if(cljs.core.truth_(inst_39283)){
var statearr_39305_39392 = state_39299__$1;
(statearr_39305_39392[(1)] = (7));

} else {
var statearr_39306_39393 = state_39299__$1;
(statearr_39306_39393[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (3))){
var inst_39297 = (state_39299[(2)]);
var state_39299__$1 = state_39299;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39299__$1,inst_39297);
} else {
if((state_val_39300 === (12))){
var inst_39294 = (state_39299[(2)]);
var _ = (function (){var statearr_39307 = state_39299;
(statearr_39307[(4)] = cljs.core.rest((state_39299[(4)])));

return statearr_39307;
})();
var state_39299__$1 = state_39299;
var statearr_39308_39394 = state_39299__$1;
(statearr_39308_39394[(2)] = inst_39294);

(statearr_39308_39394[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (2))){
var _ = (function (){var statearr_39309 = state_39299;
(statearr_39309[(4)] = cljs.core.cons((5),(state_39299[(4)])));

return statearr_39309;
})();
var inst_39273 = (30);
var inst_39275 = fluree.db.dbproto._rootdb(this$);
var inst_39276 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39277 = [inst_39273,tag_name];
var inst_39278 = (new cljs.core.PersistentVector(null,2,(5),inst_39276,inst_39277,null));
var inst_39279 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_39275,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39278);
var state_39299__$1 = state_39299;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39299__$1,(6),inst_39279);
} else {
if((state_val_39300 === (11))){
var inst_39288 = (state_39299[(8)]);
var inst_39292 = inst_39288.s;
var state_39299__$1 = state_39299;
var statearr_39311_39395 = state_39299__$1;
(statearr_39311_39395[(2)] = inst_39292);

(statearr_39311_39395[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (9))){
var inst_39288 = (state_39299[(8)]);
var inst_39288__$1 = (state_39299[(2)]);
var inst_39289 = (inst_39288__$1 == null);
var state_39299__$1 = (function (){var statearr_39312 = state_39299;
(statearr_39312[(8)] = inst_39288__$1);

return statearr_39312;
})();
if(cljs.core.truth_(inst_39289)){
var statearr_39313_39396 = state_39299__$1;
(statearr_39313_39396[(1)] = (10));

} else {
var statearr_39314_39397 = state_39299__$1;
(statearr_39314_39397[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (5))){
var _ = (function (){var statearr_39315 = state_39299;
(statearr_39315[(4)] = cljs.core.rest((state_39299[(4)])));

return statearr_39315;
})();
var state_39299__$1 = state_39299;
var ex39310 = (state_39299__$1[(2)]);
var statearr_39316_39398 = state_39299__$1;
(statearr_39316_39398[(5)] = ex39310);


if((ex39310 instanceof Error)){
var statearr_39317_39399 = state_39299__$1;
(statearr_39317_39399[(1)] = (4));

(statearr_39317_39399[(5)] = null);

} else {
throw ex39310;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (10))){
var state_39299__$1 = state_39299;
var statearr_39318_39400 = state_39299__$1;
(statearr_39318_39400[(2)] = null);

(statearr_39318_39400[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39300 === (8))){
var inst_39282 = (state_39299[(7)]);
var inst_39286 = cljs.core.first(inst_39282);
var state_39299__$1 = state_39299;
var statearr_39319_39401 = state_39299__$1;
(statearr_39319_39401[(2)] = inst_39286);

(statearr_39319_39401[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_39320 = [null,null,null,null,null,null,null,null,null];
(statearr_39320[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_39320[(1)] = (1));

return statearr_39320;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_39299){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39299);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39321){var ex__10753__auto__ = e39321;
var statearr_39322_39402 = state_39299;
(statearr_39322_39402[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39299[(4)]))){
var statearr_39323_39403 = state_39299;
(statearr_39323_39403[(1)] = cljs.core.first((state_39299[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39404 = state_39299;
state_39299 = G__39404;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_39299){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_39299);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39324 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39324[(6)] = c__10876__auto__);

return statearr_39324;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_39359){
var state_val_39360 = (state_39359[(1)]);
if((state_val_39360 === (7))){
var inst_39338 = typeof pred === 'string';
var state_39359__$1 = state_39359;
if(cljs.core.truth_(inst_39338)){
var statearr_39361_39405 = state_39359__$1;
(statearr_39361_39405[(1)] = (10));

} else {
var statearr_39362_39406 = state_39359__$1;
(statearr_39362_39406[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (1))){
var state_39359__$1 = state_39359;
var statearr_39363_39407 = state_39359__$1;
(statearr_39363_39407[(2)] = null);

(statearr_39363_39407[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (4))){
var inst_39325 = (state_39359[(2)]);
var state_39359__$1 = state_39359;
var statearr_39364_39408 = state_39359__$1;
(statearr_39364_39408[(2)] = inst_39325);

(statearr_39364_39408[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (15))){
var inst_39352 = (state_39359[(2)]);
var state_39359__$1 = state_39359;
var statearr_39365_39409 = state_39359__$1;
(statearr_39365_39409[(2)] = inst_39352);

(statearr_39365_39409[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (13))){
var inst_39343 = (state_39359[(7)]);
var inst_39345 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39343),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_39346 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_39345);
var state_39359__$1 = state_39359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39359__$1,(16),inst_39346);
} else {
if((state_val_39360 === (6))){
var inst_39333 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_39359__$1 = state_39359;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39359__$1,(9),inst_39333);
} else {
if((state_val_39360 === (3))){
var inst_39357 = (state_39359[(2)]);
var state_39359__$1 = state_39359;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39359__$1,inst_39357);
} else {
if((state_val_39360 === (12))){
var inst_39343 = (state_39359[(7)]);
var inst_39343__$1 = (state_39359[(2)]);
var state_39359__$1 = (function (){var statearr_39366 = state_39359;
(statearr_39366[(7)] = inst_39343__$1);

return statearr_39366;
})();
if(cljs.core.truth_(inst_39343__$1)){
var statearr_39367_39410 = state_39359__$1;
(statearr_39367_39410[(1)] = (13));

} else {
var statearr_39368_39411 = state_39359__$1;
(statearr_39368_39411[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (2))){
var _ = (function (){var statearr_39369 = state_39359;
(statearr_39369[(4)] = cljs.core.cons((5),(state_39359[(4)])));

return statearr_39369;
})();
var inst_39331 = clojure.string.includes_QMARK_(tag_name,"/");
var state_39359__$1 = state_39359;
if(inst_39331){
var statearr_39370_39412 = state_39359__$1;
(statearr_39370_39412[(1)] = (6));

} else {
var statearr_39371_39413 = state_39359__$1;
(statearr_39371_39413[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (11))){
var inst_39341 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_39359__$1 = state_39359;
var statearr_39373_39414 = state_39359__$1;
(statearr_39373_39414[(2)] = inst_39341);

(statearr_39373_39414[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (9))){
var inst_39335 = (state_39359[(2)]);
var inst_39336 = fluree.db.util.async.throw_err(inst_39335);
var state_39359__$1 = state_39359;
var statearr_39374_39415 = state_39359__$1;
(statearr_39374_39415[(2)] = inst_39336);

(statearr_39374_39415[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (5))){
var _ = (function (){var statearr_39375 = state_39359;
(statearr_39375[(4)] = cljs.core.rest((state_39359[(4)])));

return statearr_39375;
})();
var state_39359__$1 = state_39359;
var ex39372 = (state_39359__$1[(2)]);
var statearr_39376_39416 = state_39359__$1;
(statearr_39376_39416[(5)] = ex39372);


if((ex39372 instanceof Error)){
var statearr_39377_39417 = state_39359__$1;
(statearr_39377_39417[(1)] = (4));

(statearr_39377_39417[(5)] = null);

} else {
throw ex39372;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (14))){
var state_39359__$1 = state_39359;
var statearr_39378_39418 = state_39359__$1;
(statearr_39378_39418[(2)] = null);

(statearr_39378_39418[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (16))){
var inst_39348 = (state_39359[(2)]);
var inst_39349 = fluree.db.util.async.throw_err(inst_39348);
var state_39359__$1 = state_39359;
var statearr_39379_39419 = state_39359__$1;
(statearr_39379_39419[(2)] = inst_39349);

(statearr_39379_39419[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (10))){
var state_39359__$1 = state_39359;
var statearr_39380_39420 = state_39359__$1;
(statearr_39380_39420[(2)] = pred);

(statearr_39380_39420[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39360 === (8))){
var inst_39354 = (state_39359[(2)]);
var _ = (function (){var statearr_39381 = state_39359;
(statearr_39381[(4)] = cljs.core.rest((state_39359[(4)])));

return statearr_39381;
})();
var state_39359__$1 = state_39359;
var statearr_39382_39421 = state_39359__$1;
(statearr_39382_39421[(2)] = inst_39354);

(statearr_39382_39421[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__10750__auto__ = null;
var fluree$db$graphdb$state_machine__10750__auto____0 = (function (){
var statearr_39383 = [null,null,null,null,null,null,null,null];
(statearr_39383[(0)] = fluree$db$graphdb$state_machine__10750__auto__);

(statearr_39383[(1)] = (1));

return statearr_39383;
});
var fluree$db$graphdb$state_machine__10750__auto____1 = (function (state_39359){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_39359);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e39384){var ex__10753__auto__ = e39384;
var statearr_39385_39422 = state_39359;
(statearr_39385_39422[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_39359[(4)]))){
var statearr_39386_39423 = state_39359;
(statearr_39386_39423[(1)] = cljs.core.first((state_39359[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__39424 = state_39359;
state_39359 = G__39424;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__10750__auto__ = function(state_39359){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__10750__auto____1.call(this,state_39359);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__10750__auto____0;
fluree$db$graphdb$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__10750__auto____1;
return fluree$db$graphdb$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_39387 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_39387[(6)] = c__10876__auto__);

return statearr_39387;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k39426,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__39430 = k39426;
var G__39430__$1 = (((G__39430 instanceof cljs.core.Keyword))?G__39430.fqn:null);
switch (G__39430__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k39426,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__39431){
var vec__39432 = p__39431;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39432,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39432,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__39425){
var self__ = this;
var G__39425__$1 = this;
return (new cljs.core.RecordIter((0),G__39425__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__39435 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__39435(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this39427,other39428){
var self__ = this;
var this39427__$1 = this;
return (((!((other39428 == null)))) && ((((this39427__$1.constructor === other39428.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.conn,other39428.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.network,other39428.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.dbid,other39428.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.block,other39428.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.t,other39428.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.tt_id,other39428.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.stats,other39428.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.spot,other39428.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.psot,other39428.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.post,other39428.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.opst,other39428.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.schema,other39428.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.settings,other39428.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.index_configs,other39428.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.schema_cache,other39428.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.novelty,other39428.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.permissions,other39428.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.fork,other39428.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.fork_block,other39428.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.current_db_fn,other39428.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this39427__$1.__extmap,other39428.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k39426){
var self__ = this;
var this__4468__auto____$1 = this;
var G__39436 = k39426;
var G__39436__$1 = (((G__39436 instanceof cljs.core.Keyword))?G__39436.fqn:null);
switch (G__39436__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k39426);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__39425){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__39437 = cljs.core.keyword_identical_QMARK_;
var expr__39438 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__39440 = cljs.core.cst$kw$conn;
var G__39441 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39440,G__39441) : pred__39437.call(null,G__39440,G__39441));
})())){
return (new fluree.db.graphdb.GraphDb(G__39425,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39442 = cljs.core.cst$kw$network;
var G__39443 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39442,G__39443) : pred__39437.call(null,G__39442,G__39443));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__39425,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39444 = cljs.core.cst$kw$dbid;
var G__39445 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39444,G__39445) : pred__39437.call(null,G__39444,G__39445));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__39425,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39446 = cljs.core.cst$kw$block;
var G__39447 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39446,G__39447) : pred__39437.call(null,G__39446,G__39447));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__39425,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39448 = cljs.core.cst$kw$t;
var G__39449 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39448,G__39449) : pred__39437.call(null,G__39448,G__39449));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__39425,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39450 = cljs.core.cst$kw$tt_DASH_id;
var G__39451 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39450,G__39451) : pred__39437.call(null,G__39450,G__39451));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__39425,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39452 = cljs.core.cst$kw$stats;
var G__39453 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39452,G__39453) : pred__39437.call(null,G__39452,G__39453));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__39425,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39454 = cljs.core.cst$kw$spot;
var G__39455 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39454,G__39455) : pred__39437.call(null,G__39454,G__39455));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__39425,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39456 = cljs.core.cst$kw$psot;
var G__39457 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39456,G__39457) : pred__39437.call(null,G__39456,G__39457));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__39425,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39458 = cljs.core.cst$kw$post;
var G__39459 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39458,G__39459) : pred__39437.call(null,G__39458,G__39459));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__39425,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39460 = cljs.core.cst$kw$opst;
var G__39461 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39460,G__39461) : pred__39437.call(null,G__39460,G__39461));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__39425,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39462 = cljs.core.cst$kw$schema;
var G__39463 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39462,G__39463) : pred__39437.call(null,G__39462,G__39463));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__39425,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39464 = cljs.core.cst$kw$settings;
var G__39465 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39464,G__39465) : pred__39437.call(null,G__39464,G__39465));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__39425,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39466 = cljs.core.cst$kw$index_DASH_configs;
var G__39467 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39466,G__39467) : pred__39437.call(null,G__39466,G__39467));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__39425,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39468 = cljs.core.cst$kw$schema_DASH_cache;
var G__39469 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39468,G__39469) : pred__39437.call(null,G__39468,G__39469));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__39425,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39470 = cljs.core.cst$kw$novelty;
var G__39471 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39470,G__39471) : pred__39437.call(null,G__39470,G__39471));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__39425,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39472 = cljs.core.cst$kw$permissions;
var G__39473 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39472,G__39473) : pred__39437.call(null,G__39472,G__39473));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__39425,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39474 = cljs.core.cst$kw$fork;
var G__39475 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39474,G__39475) : pred__39437.call(null,G__39474,G__39475));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__39425,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39476 = cljs.core.cst$kw$fork_DASH_block;
var G__39477 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39476,G__39477) : pred__39437.call(null,G__39476,G__39477));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__39425,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__39478 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__39479 = expr__39438;
return (pred__39437.cljs$core$IFn$_invoke$arity$2 ? pred__39437.cljs$core$IFn$_invoke$arity$2(G__39478,G__39479) : pred__39437.call(null,G__39478,G__39479));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__39425,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__39425),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__39425){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__39425,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__39429){
var extmap__4501__auto__ = (function (){var G__39480 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__39429,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__39429)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__39480);
} else {
return G__39480;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__39429),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__39429),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
