// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k28808,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__28812 = k28808;
var G__28812__$1 = (((G__28812 instanceof cljs.core.Keyword))?G__28812.fqn:null);
switch (G__28812__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28808,else__4464__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__28813){
var vec__28814 = p__28813;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28814,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28814,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28807){
var self__ = this;
var G__28807__$1 = this;
return (new cljs.core.RecordIter((0),G__28807__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__28817 = (function (coll__4458__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__28817(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28809,other28810){
var self__ = this;
var this28809__$1 = this;
return (((!((other28810 == null)))) && ((((this28809__$1.constructor === other28810.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28809__$1.index_type,other28810.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28809__$1.comparator,other28810.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28809__$1.historyComparator,other28810.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28809__$1.__extmap,other28810.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k28808){
var self__ = this;
var this__4468__auto____$1 = this;
var G__28818 = k28808;
var G__28818__$1 = (((G__28818 instanceof cljs.core.Keyword))?G__28818.fqn:null);
switch (G__28818__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28808);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__28807){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__28819 = cljs.core.keyword_identical_QMARK_;
var expr__28820 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__28822 = cljs.core.cst$kw$index_DASH_type;
var G__28823 = expr__28820;
return (pred__28819.cljs$core$IFn$_invoke$arity$2 ? pred__28819.cljs$core$IFn$_invoke$arity$2(G__28822,G__28823) : pred__28819.call(null,G__28822,G__28823));
})())){
return (new fluree.db.index.IndexConfig(G__28807,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28824 = cljs.core.cst$kw$comparator;
var G__28825 = expr__28820;
return (pred__28819.cljs$core$IFn$_invoke$arity$2 ? pred__28819.cljs$core$IFn$_invoke$arity$2(G__28824,G__28825) : pred__28819.call(null,G__28824,G__28825));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__28807,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28826 = cljs.core.cst$kw$historyComparator;
var G__28827 = expr__28820;
return (pred__28819.cljs$core$IFn$_invoke$arity$2 ? pred__28819.cljs$core$IFn$_invoke$arity$2(G__28826,G__28827) : pred__28819.call(null,G__28826,G__28827));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__28807,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__28807),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__28807){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__28807,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__28811){
var extmap__4501__auto__ = (function (){var G__28828 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28811,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__28811)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28828);
} else {
return G__28828;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__28811),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__28811),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__28811),null,cljs.core.not_empty(extmap__4501__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k28832,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__28836 = k28832;
var G__28836__$1 = (((G__28836 instanceof cljs.core.Keyword))?G__28836.fqn:null);
switch (G__28836__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28832,else__4464__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__28837){
var vec__28838 = p__28837;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28838,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28831){
var self__ = this;
var G__28831__$1 = this;
return (new cljs.core.RecordIter((0),G__28831__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28842){
var state_val_28843 = (state_28842[(1)]);
if((state_val_28843 === (1))){
var state_28842__$1 = state_28842;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28842__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10750__auto__ = null;
var fluree$db$index$state_machine__10750__auto____0 = (function (){
var statearr_28844 = [null,null,null,null,null,null,null];
(statearr_28844[(0)] = fluree$db$index$state_machine__10750__auto__);

(statearr_28844[(1)] = (1));

return statearr_28844;
});
var fluree$db$index$state_machine__10750__auto____1 = (function (state_28842){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28842);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28845){var ex__10753__auto__ = e28845;
var statearr_28846_28958 = state_28842;
(statearr_28846_28958[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28842[(4)]))){
var statearr_28847_28959 = state_28842;
(statearr_28847_28959[(1)] = cljs.core.first((state_28842[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28960 = state_28842;
state_28842 = G__28960;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$index$state_machine__10750__auto__ = function(state_28842){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10750__auto____1.call(this,state_28842);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10750__auto____0;
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10750__auto____1;
return fluree$db$index$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28848 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28848[(6)] = c__10876__auto__);

return statearr_28848;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28873){
var state_val_28874 = (state_28873[(1)]);
if((state_val_28874 === (7))){
var inst_28855 = (state_28873[(7)]);
var inst_28859 = fluree.db.dbproto._resolve(inst_28855);
var state_28873__$1 = state_28873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28873__$1,(10),inst_28859);
} else {
if((state_val_28874 === (1))){
var state_28873__$1 = state_28873;
var statearr_28875_28961 = state_28873__$1;
(statearr_28875_28961[(2)] = null);

(statearr_28875_28961[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (4))){
var inst_28849 = (state_28873[(2)]);
var state_28873__$1 = state_28873;
var statearr_28876_28962 = state_28873__$1;
(statearr_28876_28962[(2)] = inst_28849);

(statearr_28876_28962[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (6))){
var inst_28855 = (state_28873[(7)]);
var state_28873__$1 = state_28873;
var statearr_28877_28963 = state_28873__$1;
(statearr_28877_28963[(2)] = inst_28855);

(statearr_28877_28963[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (3))){
var inst_28871 = (state_28873[(2)]);
var state_28873__$1 = state_28873;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28873__$1,inst_28871);
} else {
if((state_val_28874 === (2))){
var inst_28855 = (state_28873[(7)]);
var _ = (function (){var statearr_28879 = state_28873;
(statearr_28879[(4)] = cljs.core.cons((5),(state_28873[(4)])));

return statearr_28879;
})();
var inst_28855__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_28856 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_28855__$1);
var state_28873__$1 = (function (){var statearr_28880 = state_28873;
(statearr_28880[(7)] = inst_28855__$1);

return statearr_28880;
})();
if(cljs.core.truth_(inst_28856)){
var statearr_28881_28964 = state_28873__$1;
(statearr_28881_28964[(1)] = (6));

} else {
var statearr_28882_28965 = state_28873__$1;
(statearr_28882_28965[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (9))){
var inst_28865 = (state_28873[(2)]);
var inst_28866 = fluree.db.util.async.throw_err(inst_28865);
var state_28873__$1 = state_28873;
var statearr_28883_28966 = state_28873__$1;
(statearr_28883_28966[(2)] = inst_28866);

(statearr_28883_28966[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (5))){
var _ = (function (){var statearr_28884 = state_28873;
(statearr_28884[(4)] = cljs.core.rest((state_28873[(4)])));

return statearr_28884;
})();
var state_28873__$1 = state_28873;
var ex28878 = (state_28873__$1[(2)]);
var statearr_28885_28967 = state_28873__$1;
(statearr_28885_28967[(5)] = ex28878);


if((ex28878 instanceof Error)){
var statearr_28886_28968 = state_28873__$1;
(statearr_28886_28968[(1)] = (4));

(statearr_28886_28968[(5)] = null);

} else {
throw ex28878;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28874 === (10))){
var inst_28861 = (state_28873[(2)]);
var inst_28862 = fluree.db.util.async.throw_err(inst_28861);
var inst_28863 = fluree.db.dbproto._lookup_leaf(inst_28862,flake);
var state_28873__$1 = state_28873;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28873__$1,(9),inst_28863);
} else {
if((state_val_28874 === (8))){
var inst_28868 = (state_28873[(2)]);
var _ = (function (){var statearr_28887 = state_28873;
(statearr_28887[(4)] = cljs.core.rest((state_28873[(4)])));

return statearr_28887;
})();
var state_28873__$1 = state_28873;
var statearr_28888_28969 = state_28873__$1;
(statearr_28888_28969[(2)] = inst_28868);

(statearr_28888_28969[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__10750__auto__ = null;
var fluree$db$index$state_machine__10750__auto____0 = (function (){
var statearr_28889 = [null,null,null,null,null,null,null,null];
(statearr_28889[(0)] = fluree$db$index$state_machine__10750__auto__);

(statearr_28889[(1)] = (1));

return statearr_28889;
});
var fluree$db$index$state_machine__10750__auto____1 = (function (state_28873){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28873);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28890){var ex__10753__auto__ = e28890;
var statearr_28891_28970 = state_28873;
(statearr_28891_28970[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28873[(4)]))){
var statearr_28892_28971 = state_28873;
(statearr_28892_28971[(1)] = cljs.core.first((state_28873[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28972 = state_28873;
state_28873 = G__28972;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$index$state_machine__10750__auto__ = function(state_28873){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10750__auto____1.call(this,state_28873);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10750__auto____0;
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10750__auto____1;
return fluree$db$index$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28893 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28893[(6)] = c__10876__auto__);

return statearr_28893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28918){
var state_val_28919 = (state_28918[(1)]);
if((state_val_28919 === (7))){
var inst_28900 = (state_28918[(7)]);
var inst_28904 = fluree.db.dbproto._resolve(inst_28900);
var state_28918__$1 = state_28918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28918__$1,(10),inst_28904);
} else {
if((state_val_28919 === (1))){
var state_28918__$1 = state_28918;
var statearr_28920_28973 = state_28918__$1;
(statearr_28920_28973[(2)] = null);

(statearr_28920_28973[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (4))){
var inst_28894 = (state_28918[(2)]);
var state_28918__$1 = state_28918;
var statearr_28921_28974 = state_28918__$1;
(statearr_28921_28974[(2)] = inst_28894);

(statearr_28921_28974[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (6))){
var inst_28900 = (state_28918[(7)]);
var state_28918__$1 = state_28918;
var statearr_28922_28975 = state_28918__$1;
(statearr_28922_28975[(2)] = inst_28900);

(statearr_28922_28975[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (3))){
var inst_28916 = (state_28918[(2)]);
var state_28918__$1 = state_28918;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28918__$1,inst_28916);
} else {
if((state_val_28919 === (2))){
var inst_28900 = (state_28918[(7)]);
var _ = (function (){var statearr_28924 = state_28918;
(statearr_28924[(4)] = cljs.core.cons((5),(state_28918[(4)])));

return statearr_28924;
})();
var inst_28900__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_28901 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_28900__$1);
var state_28918__$1 = (function (){var statearr_28925 = state_28918;
(statearr_28925[(7)] = inst_28900__$1);

return statearr_28925;
})();
if(cljs.core.truth_(inst_28901)){
var statearr_28926_28976 = state_28918__$1;
(statearr_28926_28976[(1)] = (6));

} else {
var statearr_28927_28977 = state_28918__$1;
(statearr_28927_28977[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (9))){
var inst_28910 = (state_28918[(2)]);
var inst_28911 = fluree.db.util.async.throw_err(inst_28910);
var state_28918__$1 = state_28918;
var statearr_28928_28978 = state_28918__$1;
(statearr_28928_28978[(2)] = inst_28911);

(statearr_28928_28978[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (5))){
var _ = (function (){var statearr_28929 = state_28918;
(statearr_28929[(4)] = cljs.core.rest((state_28918[(4)])));

return statearr_28929;
})();
var state_28918__$1 = state_28918;
var ex28923 = (state_28918__$1[(2)]);
var statearr_28930_28979 = state_28918__$1;
(statearr_28930_28979[(5)] = ex28923);


if((ex28923 instanceof Error)){
var statearr_28931_28980 = state_28918__$1;
(statearr_28931_28980[(1)] = (4));

(statearr_28931_28980[(5)] = null);

} else {
throw ex28923;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28919 === (10))){
var inst_28906 = (state_28918[(2)]);
var inst_28907 = fluree.db.util.async.throw_err(inst_28906);
var inst_28908 = fluree.db.dbproto._lookup_leaf_after(inst_28907,flake);
var state_28918__$1 = state_28918;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28918__$1,(9),inst_28908);
} else {
if((state_val_28919 === (8))){
var inst_28913 = (state_28918[(2)]);
var _ = (function (){var statearr_28932 = state_28918;
(statearr_28932[(4)] = cljs.core.rest((state_28918[(4)])));

return statearr_28932;
})();
var state_28918__$1 = state_28918;
var statearr_28933_28981 = state_28918__$1;
(statearr_28933_28981[(2)] = inst_28913);

(statearr_28933_28981[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__10750__auto__ = null;
var fluree$db$index$state_machine__10750__auto____0 = (function (){
var statearr_28934 = [null,null,null,null,null,null,null,null];
(statearr_28934[(0)] = fluree$db$index$state_machine__10750__auto__);

(statearr_28934[(1)] = (1));

return statearr_28934;
});
var fluree$db$index$state_machine__10750__auto____1 = (function (state_28918){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28918);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28935){var ex__10753__auto__ = e28935;
var statearr_28936_28982 = state_28918;
(statearr_28936_28982[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28918[(4)]))){
var statearr_28937_28983 = state_28918;
(statearr_28937_28983[(1)] = cljs.core.first((state_28918[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28984 = state_28918;
state_28918 = G__28984;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$index$state_machine__10750__auto__ = function(state_28918){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10750__auto____1.call(this,state_28918);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10750__auto____0;
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10750__auto____1;
return fluree$db$index$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28938 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28938[(6)] = c__10876__auto__);

return statearr_28938;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__28939 = (function (coll__4458__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__28939(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28833,other28834){
var self__ = this;
var this28833__$1 = this;
return (((!((other28834 == null)))) && ((((this28833__$1.constructor === other28834.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.block,other28834.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.t,other28834.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.rhs,other28834.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.children,other28834.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.config,other28834.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.leftmost_QMARK_,other28834.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28833__$1.__extmap,other28834.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k28832){
var self__ = this;
var this__4468__auto____$1 = this;
var G__28940 = k28832;
var G__28940__$1 = (((G__28940 instanceof cljs.core.Keyword))?G__28940.fqn:null);
switch (G__28940__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28832);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__28831){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__28941 = cljs.core.keyword_identical_QMARK_;
var expr__28942 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__28944 = cljs.core.cst$kw$block;
var G__28945 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28944,G__28945) : pred__28941.call(null,G__28944,G__28945));
})())){
return (new fluree.db.index.IndexNode(G__28831,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28946 = cljs.core.cst$kw$t;
var G__28947 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28946,G__28947) : pred__28941.call(null,G__28946,G__28947));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__28831,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28948 = cljs.core.cst$kw$rhs;
var G__28949 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28948,G__28949) : pred__28941.call(null,G__28948,G__28949));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__28831,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28950 = cljs.core.cst$kw$children;
var G__28951 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28950,G__28951) : pred__28941.call(null,G__28950,G__28951));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__28831,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28952 = cljs.core.cst$kw$config;
var G__28953 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28952,G__28953) : pred__28941.call(null,G__28952,G__28953));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__28831,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__28954 = cljs.core.cst$kw$leftmost_QMARK_;
var G__28955 = expr__28942;
return (pred__28941.cljs$core$IFn$_invoke$arity$2 ? pred__28941.cljs$core$IFn$_invoke$arity$2(G__28954,G__28955) : pred__28941.call(null,G__28954,G__28955));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__28831,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__28831),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__28831){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__28831,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__28835){
var extmap__4501__auto__ = (function (){var G__28956 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28835,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__28835)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__28956);
} else {
return G__28956;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__28835),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__28835),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__28835),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__28835),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__28835),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__28835),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k28987,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__28991 = k28987;
var G__28991__$1 = (((G__28991 instanceof cljs.core.Keyword))?G__28991.fqn:null);
switch (G__28991__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k28987,else__4464__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__28992){
var vec__28993 = p__28992;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28993,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28993,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__28986){
var self__ = this;
var G__28986__$1 = this;
return (new cljs.core.RecordIter((0),G__28986__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28997){
var state_val_28998 = (state_28997[(1)]);
if((state_val_28998 === (1))){
var state_28997__$1 = state_28997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28997__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10750__auto__ = null;
var fluree$db$index$state_machine__10750__auto____0 = (function (){
var statearr_28999 = [null,null,null,null,null,null,null];
(statearr_28999[(0)] = fluree$db$index$state_machine__10750__auto__);

(statearr_28999[(1)] = (1));

return statearr_28999;
});
var fluree$db$index$state_machine__10750__auto____1 = (function (state_28997){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28997);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29000){var ex__10753__auto__ = e29000;
var statearr_29001_29033 = state_28997;
(statearr_29001_29033[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28997[(4)]))){
var statearr_29002_29034 = state_28997;
(statearr_29002_29034[(1)] = cljs.core.first((state_28997[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29035 = state_28997;
state_28997 = G__29035;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$index$state_machine__10750__auto__ = function(state_28997){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10750__auto____1.call(this,state_28997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10750__auto____0;
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10750__auto____1;
return fluree$db$index$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29003 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29003[(6)] = c__10876__auto__);

return statearr_29003;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_29009){
var state_val_29010 = (state_29009[(1)]);
if((state_val_29010 === (1))){
var inst_29004 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_29005 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_29006 = cljs.core.PersistentHashMap.fromArrays(inst_29004,inst_29005);
var inst_29007 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_29006);
var state_29009__$1 = state_29009;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29009__$1,inst_29007);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__10750__auto__ = null;
var fluree$db$index$state_machine__10750__auto____0 = (function (){
var statearr_29011 = [null,null,null,null,null,null,null];
(statearr_29011[(0)] = fluree$db$index$state_machine__10750__auto__);

(statearr_29011[(1)] = (1));

return statearr_29011;
});
var fluree$db$index$state_machine__10750__auto____1 = (function (state_29009){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_29009);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e29012){var ex__10753__auto__ = e29012;
var statearr_29013_29036 = state_29009;
(statearr_29013_29036[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_29009[(4)]))){
var statearr_29014_29037 = state_29009;
(statearr_29014_29037[(1)] = cljs.core.first((state_29009[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__29038 = state_29009;
state_29009 = G__29038;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$index$state_machine__10750__auto__ = function(state_29009){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__10750__auto____1.call(this,state_29009);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__10750__auto____0;
fluree$db$index$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__10750__auto____1;
return fluree$db$index$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_29015 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_29015[(6)] = c__10876__auto__);

return statearr_29015;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__29016 = (function (coll__4458__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__29016(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this28988,other28989){
var self__ = this;
var this28988__$1 = this;
return (((!((other28989 == null)))) && ((((this28988__$1.constructor === other28989.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.block,other28989.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.t,other28989.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.flakes,other28989.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.rhs,other28989.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.config,other28989.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this28988__$1.__extmap,other28989.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k28987){
var self__ = this;
var this__4468__auto____$1 = this;
var G__29017 = k28987;
var G__29017__$1 = (((G__29017 instanceof cljs.core.Keyword))?G__29017.fqn:null);
switch (G__29017__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k28987);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__28986){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__29018 = cljs.core.keyword_identical_QMARK_;
var expr__29019 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__29021 = cljs.core.cst$kw$block;
var G__29022 = expr__29019;
return (pred__29018.cljs$core$IFn$_invoke$arity$2 ? pred__29018.cljs$core$IFn$_invoke$arity$2(G__29021,G__29022) : pred__29018.call(null,G__29021,G__29022));
})())){
return (new fluree.db.index.DataNode(G__28986,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29023 = cljs.core.cst$kw$t;
var G__29024 = expr__29019;
return (pred__29018.cljs$core$IFn$_invoke$arity$2 ? pred__29018.cljs$core$IFn$_invoke$arity$2(G__29023,G__29024) : pred__29018.call(null,G__29023,G__29024));
})())){
return (new fluree.db.index.DataNode(self__.block,G__28986,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29025 = cljs.core.cst$kw$flakes;
var G__29026 = expr__29019;
return (pred__29018.cljs$core$IFn$_invoke$arity$2 ? pred__29018.cljs$core$IFn$_invoke$arity$2(G__29025,G__29026) : pred__29018.call(null,G__29025,G__29026));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__28986,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29027 = cljs.core.cst$kw$rhs;
var G__29028 = expr__29019;
return (pred__29018.cljs$core$IFn$_invoke$arity$2 ? pred__29018.cljs$core$IFn$_invoke$arity$2(G__29027,G__29028) : pred__29018.call(null,G__29027,G__29028));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__28986,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__29029 = cljs.core.cst$kw$config;
var G__29030 = expr__29019;
return (pred__29018.cljs$core$IFn$_invoke$arity$2 ? pred__29018.cljs$core$IFn$_invoke$arity$2(G__29029,G__29030) : pred__29018.call(null,G__29029,G__29030));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__28986,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__28986),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__28986){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__28986,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__28990){
var extmap__4501__auto__ = (function (){var G__29031 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__28990,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__28990)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__29031);
} else {
return G__29031;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__28990),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__28990),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__28990),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__28990),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__28990),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
