// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e31980){var e = e31980;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__31981_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__31981_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__31981_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__31981_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__31981_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31982_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31982_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31983_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31983_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__31988 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31988,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31988,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31984_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31984_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__31991 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31991,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__31991,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31985_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31985_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31986_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31986_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__31987_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__31987_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31994_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__31994_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__31995 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__31995) : intersecting_vars.call(null,G__31995));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__31998,optional_QMARK_,fuel,max_fuel){
var map__31999 = p__31998;
var map__31999__$1 = cljs.core.__destructure_map(map__31999);
var res = map__31999__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31999__$1,cljs.core.cst$kw$vars);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32065){
var state_val_32066 = (state_32065[(1)]);
if((state_val_32066 === (7))){
var inst_32054 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32055 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_32056 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_32055,clause);
var inst_32057 = [null,inst_32056];
var inst_32058 = (new cljs.core.PersistentVector(null,2,(5),inst_32054,inst_32057,null));
var state_32065__$1 = state_32065;
var statearr_32067_32095 = state_32065__$1;
(statearr_32067_32095[(2)] = inst_32058);

(statearr_32067_32095[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (1))){
var state_32065__$1 = state_32065;
var statearr_32068_32096 = state_32065__$1;
(statearr_32068_32096[(2)] = null);

(statearr_32068_32096[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (4))){
var inst_32000 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32069_32097 = state_32065__$1;
(statearr_32069_32097[(2)] = inst_32000);

(statearr_32069_32097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (15))){
var inst_32043 = (state_32065[(2)]);
var inst_32044 = fluree.db.util.async.throw_err(inst_32043);
var inst_32045 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_32044);
var inst_32046 = cljs.core.count(inst_32045);
var inst_32047 = fluree.db.query.analytical.add_fuel(inst_32046,fuel,max_fuel);
var inst_32048 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32049 = [inst_32044,r];
var inst_32050 = (new cljs.core.PersistentVector(null,2,(5),inst_32048,inst_32049,null));
var state_32065__$1 = (function (){var statearr_32070 = state_32065;
(statearr_32070[(7)] = inst_32047);

return statearr_32070;
})();
var statearr_32071_32098 = state_32065__$1;
(statearr_32071_32098[(2)] = inst_32050);

(statearr_32071_32098[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (13))){
var inst_32009 = (state_32065[(8)]);
var inst_32022 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_32023 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_32022);
var inst_32024 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_32009);
var inst_32025 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_32024);
var inst_32026 = cljs.core.set(inst_32025);
var inst_32027 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_32023);
var inst_32028 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_32027);
var inst_32029 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32026,inst_32028);
var inst_32030 = (function (){var all_wd = inst_32009;
var optional = inst_32023;
var all_wd_vars = inst_32026;
var all_vars = inst_32029;
return (function (p1__31996_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__31996_SHARP_) : all_vars.call(null,p1__31996_SHARP_));
});
})();
var inst_32031 = cljs.core.keys(vars);
var inst_32032 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32030,inst_32031);
var inst_32033 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_32032);
var inst_32034 = cljs.core.set(inst_32033);
var inst_32035 = (function (){var all_wd = inst_32009;
var optional = inst_32023;
var all_wd_vars = inst_32026;
var all_vars = inst_32029;
var intersecting_vars = inst_32034;
return (function (p1__31997_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__31997_SHARP_);
});
})();
var inst_32036 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32035,inst_32009);
var inst_32037 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_32036);
var inst_32038 = fluree.db.query.analytical.select_from_tuples(inst_32037,res);
var inst_32039 = fluree.db.query.analytical.replace_vars_wikidata(inst_32009,inst_32034,vars);
var inst_32040 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_32034,inst_32029);
var inst_32041 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_32039,inst_32037,inst_32038,inst_32040,inst_32023);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32065__$1,(15),inst_32041);
} else {
if((state_val_32066 === (6))){
var inst_32010 = (state_32065[(9)]);
var inst_32008 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_32009 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_32008);
var inst_32010__$1 = optional_QMARK_;
var state_32065__$1 = (function (){var statearr_32072 = state_32065;
(statearr_32072[(8)] = inst_32009);

(statearr_32072[(9)] = inst_32010__$1);

return statearr_32072;
})();
if(cljs.core.truth_(inst_32010__$1)){
var statearr_32073_32099 = state_32065__$1;
(statearr_32073_32099[(1)] = (9));

} else {
var statearr_32074_32100 = state_32065__$1;
(statearr_32074_32100[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (3))){
var inst_32063 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32065__$1,inst_32063);
} else {
if((state_val_32066 === (12))){
var inst_32018 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32019 = [null,r];
var inst_32020 = (new cljs.core.PersistentVector(null,2,(5),inst_32018,inst_32019,null));
var state_32065__$1 = state_32065;
var statearr_32075_32101 = state_32065__$1;
(statearr_32075_32101[(2)] = inst_32020);

(statearr_32075_32101[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (2))){
var _ = (function (){var statearr_32076 = state_32065;
(statearr_32076[(4)] = cljs.core.cons((5),(state_32065[(4)])));

return statearr_32076;
})();
var inst_32006 = (r == null);
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32006)){
var statearr_32077_32102 = state_32065__$1;
(statearr_32077_32102[(1)] = (6));

} else {
var statearr_32078_32103 = state_32065__$1;
(statearr_32078_32103[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (11))){
var inst_32016 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
if(cljs.core.truth_(inst_32016)){
var statearr_32080_32104 = state_32065__$1;
(statearr_32080_32104[(1)] = (12));

} else {
var statearr_32081_32105 = state_32065__$1;
(statearr_32081_32105[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (9))){
var inst_32009 = (state_32065[(8)]);
var inst_32012 = cljs.core.empty_QMARK_(inst_32009);
var inst_32013 = (!(inst_32012));
var state_32065__$1 = state_32065;
var statearr_32082_32106 = state_32065__$1;
(statearr_32082_32106[(2)] = inst_32013);

(statearr_32082_32106[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (5))){
var _ = (function (){var statearr_32083 = state_32065;
(statearr_32083[(4)] = cljs.core.rest((state_32065[(4)])));

return statearr_32083;
})();
var state_32065__$1 = state_32065;
var ex32079 = (state_32065__$1[(2)]);
var statearr_32084_32107 = state_32065__$1;
(statearr_32084_32107[(5)] = ex32079);


if((ex32079 instanceof Error)){
var statearr_32085_32108 = state_32065__$1;
(statearr_32085_32108[(1)] = (4));

(statearr_32085_32108[(5)] = null);

} else {
throw ex32079;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (14))){
var inst_32052 = (state_32065[(2)]);
var state_32065__$1 = state_32065;
var statearr_32086_32109 = state_32065__$1;
(statearr_32086_32109[(2)] = inst_32052);

(statearr_32086_32109[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (10))){
var inst_32010 = (state_32065[(9)]);
var state_32065__$1 = state_32065;
var statearr_32087_32110 = state_32065__$1;
(statearr_32087_32110[(2)] = inst_32010);

(statearr_32087_32110[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32066 === (8))){
var inst_32060 = (state_32065[(2)]);
var _ = (function (){var statearr_32088 = state_32065;
(statearr_32088[(4)] = cljs.core.rest((state_32065[(4)])));

return statearr_32088;
})();
var state_32065__$1 = state_32065;
var statearr_32089_32111 = state_32065__$1;
(statearr_32089_32111[(2)] = inst_32060);

(statearr_32089_32111[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____0 = (function (){
var statearr_32090 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32090[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__);

(statearr_32090[(1)] = (1));

return statearr_32090;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____1 = (function (state_32065){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32065);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e32091){var ex__10753__auto__ = e32091;
var statearr_32092_32112 = state_32065;
(statearr_32092_32112[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32065[(4)]))){
var statearr_32093_32113 = state_32065;
(statearr_32093_32113[(1)] = cljs.core.first((state_32065[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__32114 = state_32065;
state_32065 = G__32114;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__ = function(state_32065){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____1.call(this,state_32065);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_32094 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_32094[(6)] = c__10876__auto__);

return statearr_32094;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__32116 = arguments.length;
switch (G__32116) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32210){
var state_val_32211 = (state_32210[(1)]);
if((state_val_32211 === (7))){
var inst_32123 = (state_32210[(7)]);
var inst_32133 = clojure.string.starts_with_QMARK_(inst_32123,"$fdb");
var state_32210__$1 = state_32210;
if(inst_32133){
var statearr_32212_32261 = state_32210__$1;
(statearr_32212_32261[(1)] = (9));

} else {
var statearr_32213_32262 = state_32210__$1;
(statearr_32213_32262[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (20))){
var state_32210__$1 = state_32210;
var statearr_32214_32263 = state_32210__$1;
(statearr_32214_32263[(2)] = null);

(statearr_32214_32263[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (27))){
var inst_32173 = (state_32210[(8)]);
var state_32210__$1 = state_32210;
var statearr_32215_32264 = state_32210__$1;
(statearr_32215_32264[(2)] = inst_32173);

(statearr_32215_32264[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (1))){
var state_32210__$1 = state_32210;
var statearr_32216_32265 = state_32210__$1;
(statearr_32216_32265[(2)] = null);

(statearr_32216_32265[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (24))){
var inst_32196 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32217_32266 = state_32210__$1;
(statearr_32217_32266[(2)] = inst_32196);

(statearr_32217_32266[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (4))){
var inst_32117 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32218_32267 = state_32210__$1;
(statearr_32218_32267[(2)] = inst_32117);

(statearr_32218_32267[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (15))){
var inst_32140 = (state_32210[(9)]);
var inst_32146 = (state_32210[(2)]);
var inst_32147 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32148 = cljs.core.PersistentVector.EMPTY;
var inst_32149 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_32150 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32148,inst_32149);
var inst_32151 = [inst_32140,inst_32150];
var inst_32152 = (new cljs.core.PersistentVector(null,2,(5),inst_32147,inst_32151,null));
var state_32210__$1 = (function (){var statearr_32219 = state_32210;
(statearr_32219[(10)] = inst_32146);

return statearr_32219;
})();
var statearr_32220_32268 = state_32210__$1;
(statearr_32220_32268[(2)] = inst_32152);

(statearr_32220_32268[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (21))){
var inst_32199 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32221_32269 = state_32210__$1;
(statearr_32221_32269[(2)] = inst_32199);

(statearr_32221_32269[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (13))){
var inst_32140 = (state_32210[(9)]);
var inst_32143 = (function(){throw inst_32140})();
var state_32210__$1 = state_32210;
var statearr_32222_32270 = state_32210__$1;
(statearr_32222_32270[(2)] = inst_32143);

(statearr_32222_32270[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (22))){
var inst_32164 = (state_32210[(11)]);
var inst_32162 = (state_32210[(12)]);
var inst_32166 = fluree.db.query.analytical.parse_block_from_source(inst_32162);
var inst_32167 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32168 = [cljs.core.cst$kw$sources,inst_32164];
var inst_32169 = (new cljs.core.PersistentVector(null,2,(5),inst_32167,inst_32168,null));
var inst_32170 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_32169);
var state_32210__$1 = (function (){var statearr_32223 = state_32210;
(statearr_32223[(13)] = inst_32166);

return statearr_32223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32210__$1,(25),inst_32170);
} else {
if((state_val_32211 === (29))){
var inst_32177 = (state_32210[(2)]);
var inst_32178 = fluree.db.util.async.throw_err(inst_32177);
var state_32210__$1 = state_32210;
var statearr_32224_32271 = state_32210__$1;
(statearr_32224_32271[(2)] = inst_32178);

(statearr_32224_32271[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (6))){
var inst_32126 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32127 = cljs.core.PersistentVector.EMPTY;
var inst_32128 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_32129 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32127,inst_32128);
var inst_32130 = [db,inst_32129];
var inst_32131 = (new cljs.core.PersistentVector(null,2,(5),inst_32126,inst_32130,null));
var state_32210__$1 = state_32210;
var statearr_32225_32272 = state_32210__$1;
(statearr_32225_32272[(2)] = inst_32131);

(statearr_32225_32272[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (28))){
var inst_32181 = (state_32210[(2)]);
var inst_32182 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32183 = cljs.core.PersistentVector.EMPTY;
var inst_32184 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_32185 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_32183,inst_32184);
var inst_32186 = [inst_32181,inst_32185];
var inst_32187 = (new cljs.core.PersistentVector(null,2,(5),inst_32182,inst_32186,null));
var state_32210__$1 = state_32210;
var statearr_32226_32273 = state_32210__$1;
(statearr_32226_32273[(2)] = inst_32187);

(statearr_32226_32273[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (25))){
var inst_32166 = (state_32210[(13)]);
var inst_32172 = (state_32210[(2)]);
var inst_32173 = fluree.db.util.async.throw_err(inst_32172);
var state_32210__$1 = (function (){var statearr_32227 = state_32210;
(statearr_32227[(8)] = inst_32173);

return statearr_32227;
})();
if(cljs.core.truth_(inst_32166)){
var statearr_32228_32274 = state_32210__$1;
(statearr_32228_32274[(1)] = (26));

} else {
var statearr_32229_32275 = state_32210__$1;
(statearr_32229_32275[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (17))){
var state_32210__$1 = state_32210;
var statearr_32230_32276 = state_32210__$1;
(statearr_32230_32276[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (3))){
var inst_32208 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32210__$1,inst_32208);
} else {
if((state_val_32211 === (12))){
var inst_32140 = (state_32210[(9)]);
var inst_32139 = (state_32210[(2)]);
var inst_32140__$1 = fluree.db.util.async.throw_err(inst_32139);
var inst_32141 = fluree.db.util.core.exception_QMARK_(inst_32140__$1);
var state_32210__$1 = (function (){var statearr_32232 = state_32210;
(statearr_32232[(9)] = inst_32140__$1);

return statearr_32232;
})();
if(inst_32141){
var statearr_32233_32277 = state_32210__$1;
(statearr_32233_32277[(1)] = (13));

} else {
var statearr_32234_32278 = state_32210__$1;
(statearr_32234_32278[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (2))){
var inst_32123 = (state_32210[(7)]);
var _ = (function (){var statearr_32235 = state_32210;
(statearr_32235[(4)] = cljs.core.cons((5),(state_32210[(4)])));

return statearr_32235;
})();
var inst_32123__$1 = cljs.core.first(clause);
var inst_32124 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_32123__$1);
var state_32210__$1 = (function (){var statearr_32236 = state_32210;
(statearr_32236[(7)] = inst_32123__$1);

return statearr_32236;
})();
if(inst_32124){
var statearr_32237_32279 = state_32210__$1;
(statearr_32237_32279[(1)] = (6));

} else {
var statearr_32238_32280 = state_32210__$1;
(statearr_32238_32280[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (23))){
var inst_32123 = (state_32210[(7)]);
var inst_32189 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32123)," is not supported in Fluree"].join('');
var inst_32190 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32191 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32192 = cljs.core.PersistentHashMap.fromArrays(inst_32190,inst_32191);
var inst_32193 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32189,inst_32192);
var inst_32194 = (function(){throw inst_32193})();
var state_32210__$1 = state_32210;
var statearr_32239_32281 = state_32210__$1;
(statearr_32239_32281[(2)] = inst_32194);

(statearr_32239_32281[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (19))){
var inst_32164 = (state_32210[(11)]);
var inst_32123 = (state_32210[(7)]);
var inst_32161 = fluree.db.query.analytical.isolate_source_name(inst_32123);
var inst_32162 = fluree.db.query.analytical.isolate_source_block(inst_32123);
var inst_32163 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_32161);
var inst_32164__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_32163);
var state_32210__$1 = (function (){var statearr_32240 = state_32210;
(statearr_32240[(11)] = inst_32164__$1);

(statearr_32240[(12)] = inst_32162);

return statearr_32240;
})();
if(cljs.core.truth_(inst_32164__$1)){
var statearr_32241_32282 = state_32210__$1;
(statearr_32241_32282[(1)] = (22));

} else {
var statearr_32242_32283 = state_32210__$1;
(statearr_32242_32283[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (11))){
var inst_32203 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32244_32284 = state_32210__$1;
(statearr_32244_32284[(2)] = inst_32203);

(statearr_32244_32284[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (9))){
var inst_32123 = (state_32210[(7)]);
var inst_32135 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_32123,(4));
var inst_32136 = fluree.db.query.analytical.parse_block_from_source(inst_32135);
var inst_32137 = fluree.db.time_travel.as_of_block(db,inst_32136);
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32210__$1,(12),inst_32137);
} else {
if((state_val_32211 === (5))){
var _ = (function (){var statearr_32245 = state_32210;
(statearr_32245[(4)] = cljs.core.rest((state_32210[(4)])));

return statearr_32245;
})();
var state_32210__$1 = state_32210;
var ex32243 = (state_32210__$1[(2)]);
var statearr_32246_32285 = state_32210__$1;
(statearr_32246_32285[(5)] = ex32243);


if((ex32243 instanceof Error)){
var statearr_32247_32286 = state_32210__$1;
(statearr_32247_32286[(1)] = (4));

(statearr_32247_32286[(5)] = null);

} else {
throw ex32243;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (14))){
var state_32210__$1 = state_32210;
var statearr_32248_32287 = state_32210__$1;
(statearr_32248_32287[(2)] = null);

(statearr_32248_32287[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (26))){
var inst_32173 = (state_32210[(8)]);
var inst_32166 = (state_32210[(13)]);
var inst_32175 = fluree.db.time_travel.as_of_block(inst_32173,inst_32166);
var state_32210__$1 = state_32210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32210__$1,(29),inst_32175);
} else {
if((state_val_32211 === (16))){
var inst_32156 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32157 = ["$wd",clause];
var inst_32158 = (new cljs.core.PersistentVector(null,2,(5),inst_32156,inst_32157,null));
var state_32210__$1 = state_32210;
var statearr_32249_32288 = state_32210__$1;
(statearr_32249_32288[(2)] = inst_32158);

(statearr_32249_32288[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (10))){
var inst_32123 = (state_32210[(7)]);
var inst_32154 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_32123);
var state_32210__$1 = state_32210;
if(inst_32154){
var statearr_32250_32289 = state_32210__$1;
(statearr_32250_32289[(1)] = (16));

} else {
var statearr_32251_32290 = state_32210__$1;
(statearr_32251_32290[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (18))){
var inst_32201 = (state_32210[(2)]);
var state_32210__$1 = state_32210;
var statearr_32252_32291 = state_32210__$1;
(statearr_32252_32291[(2)] = inst_32201);

(statearr_32252_32291[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32211 === (8))){
var inst_32205 = (state_32210[(2)]);
var _ = (function (){var statearr_32253 = state_32210;
(statearr_32253[(4)] = cljs.core.rest((state_32210[(4)])));

return statearr_32253;
})();
var state_32210__$1 = state_32210;
var statearr_32254_32292 = state_32210__$1;
(statearr_32254_32292[(2)] = inst_32205);

(statearr_32254_32292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10750__auto__ = null;
var fluree$db$query$analytical$state_machine__10750__auto____0 = (function (){
var statearr_32255 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32255[(0)] = fluree$db$query$analytical$state_machine__10750__auto__);

(statearr_32255[(1)] = (1));

return statearr_32255;
});
var fluree$db$query$analytical$state_machine__10750__auto____1 = (function (state_32210){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32210);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e32256){var ex__10753__auto__ = e32256;
var statearr_32257_32293 = state_32210;
(statearr_32257_32293[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32210[(4)]))){
var statearr_32258_32294 = state_32210;
(statearr_32258_32294[(1)] = cljs.core.first((state_32210[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__32295 = state_32210;
state_32210 = G__32295;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10750__auto__ = function(state_32210){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10750__auto____1.call(this,state_32210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10750__auto____0;
fluree$db$query$analytical$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10750__auto____1;
return fluree$db$query$analytical$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_32259 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_32259[(6)] = c__10876__auto__);

return statearr_32259;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__32296){
var vec__32297 = p__32296;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32297,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32297,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32300_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__32300_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__32304 = subjects;
var vec__32305 = G__32304;
var seq__32306 = cljs.core.seq(vec__32305);
var first__32307 = cljs.core.first(seq__32306);
var seq__32306__$1 = cljs.core.next(seq__32306);
var subject = first__32307;
var r = seq__32306__$1;
var acc = expanded_map;
var G__32304__$1 = G__32304;
var acc__$1 = acc;
while(true){
var vec__32311 = G__32304__$1;
var seq__32312 = cljs.core.seq(vec__32311);
var first__32313 = cljs.core.first(seq__32312);
var seq__32312__$1 = cljs.core.next(seq__32312);
var subject__$1 = first__32313;
var r__$1 = seq__32312__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__32314 = r__$1;
var G__32315 = acc__$2;
G__32304__$1 = G__32314;
acc__$1 = G__32315;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__32304__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__32304__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__32304__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__32304__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__32304__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__32304__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__32311,seq__32312,first__32313,seq__32312__$1,subject__$1,r__$1,acc__$2,G__32304,vec__32305,seq__32306,first__32307,seq__32306__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__32316 = r__$1;
var G__32317 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__32304__$1 = G__32316;
acc__$1 = G__32317;
continue;
} else {
var G__32318 = subjects;
var G__32319 = acc_STAR_;
G__32304__$1 = G__32318;
acc__$1 = G__32319;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32320_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__32320_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32411){
var state_val_32412 = (state_32411[(1)]);
if((state_val_32412 === (7))){
var state_32411__$1 = state_32411;
var statearr_32413_32459 = state_32411__$1;
(statearr_32413_32459[(2)] = (100));

(statearr_32413_32459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (20))){
var inst_32360 = (state_32411[(7)]);
var state_32411__$1 = state_32411;
var statearr_32414_32460 = state_32411__$1;
(statearr_32414_32460[(2)] = inst_32360);

(statearr_32414_32460[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (1))){
var state_32411__$1 = state_32411;
var statearr_32415_32461 = state_32411__$1;
(statearr_32415_32461[(2)] = null);

(statearr_32415_32461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (24))){
var inst_32397 = (state_32411[(8)]);
var inst_32399 = (state_32411[(9)]);
var inst_32332 = (state_32411[(10)]);
var inst_32398 = (state_32411[(11)]);
var inst_32402 = (function (){var max_depth = inst_32332;
var recur_map__$1 = inst_32398;
var subjects = inst_32397;
var tuples = inst_32399;
return (function (p1__32321_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__32321_SHARP_)],null));
});
})();
var inst_32403 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32402,inst_32399);
var inst_32404 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_32403);
var state_32411__$1 = state_32411;
var statearr_32416_32462 = state_32411__$1;
(statearr_32416_32462[(2)] = inst_32404);

(statearr_32416_32462[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (4))){
var inst_32322 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32417_32463 = state_32411__$1;
(statearr_32417_32463[(2)] = inst_32322);

(statearr_32417_32463[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (15))){
var inst_32345 = (state_32411[(12)]);
var inst_32356 = cljs.core.PersistentVector.EMPTY;
var inst_32357 = cljs.core.seq(inst_32345);
var inst_32358 = cljs.core.first(inst_32357);
var inst_32359 = cljs.core.next(inst_32357);
var inst_32360 = inst_32356;
var inst_32361 = inst_32345;
var state_32411__$1 = (function (){var statearr_32418 = state_32411;
(statearr_32418[(13)] = inst_32358);

(statearr_32418[(7)] = inst_32360);

(statearr_32418[(14)] = inst_32361);

(statearr_32418[(15)] = inst_32359);

return statearr_32418;
})();
var statearr_32419_32464 = state_32411__$1;
(statearr_32419_32464[(2)] = null);

(statearr_32419_32464[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (21))){
var inst_32381 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32420_32465 = state_32411__$1;
(statearr_32420_32465[(2)] = inst_32381);

(statearr_32420_32465[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (13))){
var inst_32394 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32421_32466 = state_32411__$1;
(statearr_32421_32466[(2)] = inst_32394);

(statearr_32421_32466[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (22))){
var inst_32368 = (state_32411[(16)]);
var inst_32360 = (state_32411[(7)]);
var inst_32375 = (state_32411[(2)]);
var inst_32376 = fluree.db.util.async.throw_err(inst_32375);
var inst_32377 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_32360,inst_32376);
var inst_32360__$1 = inst_32377;
var inst_32361 = inst_32368;
var state_32411__$1 = (function (){var statearr_32422 = state_32411;
(statearr_32422[(7)] = inst_32360__$1);

(statearr_32422[(14)] = inst_32361);

return statearr_32422;
})();
var statearr_32423_32467 = state_32411__$1;
(statearr_32423_32467[(2)] = null);

(statearr_32423_32467[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (6))){
var inst_32328 = (state_32411[(17)]);
var state_32411__$1 = state_32411;
var statearr_32424_32468 = state_32411__$1;
(statearr_32424_32468[(2)] = inst_32328);

(statearr_32424_32468[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (25))){
var inst_32406 = (state_32411[(2)]);
var _ = (function (){var statearr_32425 = state_32411;
(statearr_32425[(4)] = cljs.core.rest((state_32411[(4)])));

return statearr_32425;
})();
var state_32411__$1 = state_32411;
var statearr_32426_32469 = state_32411__$1;
(statearr_32426_32469[(2)] = inst_32406);

(statearr_32426_32469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (17))){
var inst_32367 = (state_32411[(18)]);
var inst_32361 = (state_32411[(14)]);
var inst_32366 = cljs.core.seq(inst_32361);
var inst_32367__$1 = cljs.core.first(inst_32366);
var inst_32368 = cljs.core.next(inst_32366);
var state_32411__$1 = (function (){var statearr_32427 = state_32411;
(statearr_32427[(16)] = inst_32368);

(statearr_32427[(18)] = inst_32367__$1);

return statearr_32427;
})();
if(cljs.core.truth_(inst_32367__$1)){
var statearr_32428_32470 = state_32411__$1;
(statearr_32428_32470[(1)] = (19));

} else {
var statearr_32429_32471 = state_32411__$1;
(statearr_32429_32471[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (3))){
var inst_32409 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32411__$1,inst_32409);
} else {
if((state_val_32412 === (12))){
var inst_32345 = (state_32411[(12)]);
var inst_32334 = (state_32411[(19)]);
var inst_32340 = cljs.core.vals(inst_32334);
var inst_32341 = cljs.core.flatten(inst_32340);
var inst_32342 = cljs.core.set(inst_32341);
var inst_32343 = cljs.core.keys(inst_32334);
var inst_32344 = cljs.core.set(inst_32343);
var inst_32345__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_32342,inst_32344);
var inst_32346 = cljs.core.empty_QMARK_(inst_32345__$1);
var state_32411__$1 = (function (){var statearr_32430 = state_32411;
(statearr_32430[(12)] = inst_32345__$1);

return statearr_32430;
})();
if(inst_32346){
var statearr_32431_32472 = state_32411__$1;
(statearr_32431_32472[(1)] = (14));

} else {
var statearr_32432_32473 = state_32411__$1;
(statearr_32432_32473[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (2))){
var inst_32328 = (state_32411[(17)]);
var _ = (function (){var statearr_32433 = state_32411;
(statearr_32433[(4)] = cljs.core.cons((5),(state_32411[(4)])));

return statearr_32433;
})();
var inst_32328__$1 = depth;
var state_32411__$1 = (function (){var statearr_32434 = state_32411;
(statearr_32434[(17)] = inst_32328__$1);

return statearr_32434;
})();
if(cljs.core.truth_(inst_32328__$1)){
var statearr_32435_32474 = state_32411__$1;
(statearr_32435_32474[(1)] = (6));

} else {
var statearr_32436_32475 = state_32411__$1;
(statearr_32436_32475[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (23))){
var inst_32399 = (state_32411[(9)]);
var state_32411__$1 = state_32411;
var statearr_32437_32476 = state_32411__$1;
(statearr_32437_32476[(2)] = inst_32399);

(statearr_32437_32476[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (19))){
var inst_32367 = (state_32411[(18)]);
var inst_32370 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32371 = [inst_32367,predicate];
var inst_32372 = (new cljs.core.PersistentVector(null,2,(5),inst_32370,inst_32371,null));
var inst_32373 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32372);
var state_32411__$1 = state_32411;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32411__$1,(22),inst_32373);
} else {
if((state_val_32412 === (11))){
var inst_32334 = (state_32411[(19)]);
var state_32411__$1 = state_32411;
var statearr_32439_32477 = state_32411__$1;
(statearr_32439_32477[(2)] = inst_32334);

(statearr_32439_32477[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (9))){
var inst_32332 = (state_32411[(10)]);
var inst_32335 = (state_32411[(20)]);
var inst_32337 = (inst_32335 >= inst_32332);
var state_32411__$1 = state_32411;
if(cljs.core.truth_(inst_32337)){
var statearr_32440_32478 = state_32411__$1;
(statearr_32440_32478[(1)] = (11));

} else {
var statearr_32441_32479 = state_32411__$1;
(statearr_32441_32479[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (5))){
var _ = (function (){var statearr_32442 = state_32411;
(statearr_32442[(4)] = cljs.core.rest((state_32411[(4)])));

return statearr_32442;
})();
var state_32411__$1 = state_32411;
var ex32438 = (state_32411__$1[(2)]);
var statearr_32443_32480 = state_32411__$1;
(statearr_32443_32480[(5)] = ex32438);


if((ex32438 instanceof Error)){
var statearr_32444_32481 = state_32411__$1;
(statearr_32444_32481[(1)] = (4));

(statearr_32444_32481[(5)] = null);

} else {
throw ex32438;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (14))){
var inst_32334 = (state_32411[(19)]);
var state_32411__$1 = state_32411;
var statearr_32445_32482 = state_32411__$1;
(statearr_32445_32482[(2)] = inst_32334);

(statearr_32445_32482[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (16))){
var inst_32392 = (state_32411[(2)]);
var state_32411__$1 = state_32411;
var statearr_32446_32483 = state_32411__$1;
(statearr_32446_32483[(2)] = inst_32392);

(statearr_32446_32483[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (10))){
var inst_32397 = (state_32411[(8)]);
var inst_32398 = (state_32411[(11)]);
var inst_32396 = (state_32411[(2)]);
var inst_32397__$1 = cljs.core.keys(inst_32396);
var inst_32398__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_32397__$1,inst_32396);
var inst_32399 = fluree.db.query.analytical.recur_map__GT_tuples(inst_32397__$1,inst_32398__$1);
var state_32411__$1 = (function (){var statearr_32447 = state_32411;
(statearr_32447[(8)] = inst_32397__$1);

(statearr_32447[(9)] = inst_32399);

(statearr_32447[(11)] = inst_32398__$1);

return statearr_32447;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_32448_32484 = state_32411__$1;
(statearr_32448_32484[(1)] = (23));

} else {
var statearr_32449_32485 = state_32411__$1;
(statearr_32449_32485[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (18))){
var inst_32335 = (state_32411[(20)]);
var inst_32334 = (state_32411[(19)]);
var inst_32383 = (state_32411[(2)]);
var inst_32384 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32385 = [(0),(2)];
var inst_32386 = (new cljs.core.PersistentVector(null,2,(5),inst_32384,inst_32385,null));
var inst_32387 = fluree.db.query.analytical.get_ns_arrays(inst_32386,inst_32383);
var inst_32388 = fluree.db.query.analytical.tuples__GT_map(inst_32334,inst_32387);
var inst_32389 = (inst_32335 + (1));
var inst_32334__$1 = inst_32388;
var inst_32335__$1 = inst_32389;
var state_32411__$1 = (function (){var statearr_32450 = state_32411;
(statearr_32450[(20)] = inst_32335__$1);

(statearr_32450[(19)] = inst_32334__$1);

return statearr_32450;
})();
var statearr_32451_32486 = state_32411__$1;
(statearr_32451_32486[(2)] = null);

(statearr_32451_32486[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32412 === (8))){
var inst_32332 = (state_32411[(2)]);
var inst_32333 = recur_map;
var inst_32334 = inst_32333;
var inst_32335 = (1);
var state_32411__$1 = (function (){var statearr_32452 = state_32411;
(statearr_32452[(10)] = inst_32332);

(statearr_32452[(20)] = inst_32335);

(statearr_32452[(19)] = inst_32334);

return statearr_32452;
})();
var statearr_32453_32487 = state_32411__$1;
(statearr_32453_32487[(2)] = null);

(statearr_32453_32487[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____0 = (function (){
var statearr_32454 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32454[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__);

(statearr_32454[(1)] = (1));

return statearr_32454;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____1 = (function (state_32411){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32411);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e32455){var ex__10753__auto__ = e32455;
var statearr_32456_32488 = state_32411;
(statearr_32456_32488[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32411[(4)]))){
var statearr_32457_32489 = state_32411;
(statearr_32457_32489[(1)] = cljs.core.first((state_32411[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__32490 = state_32411;
state_32411 = G__32490;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__ = function(state_32411){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____1.call(this,state_32411);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_32458 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_32458[(6)] = c__10876__auto__);

return statearr_32458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__32491,clause,fuel,max_fuel){
var map__32492 = p__32491;
var map__32492__$1 = cljs.core.__destructure_map(map__32492);
var res = map__32492__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32492__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32492__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32492__$1,cljs.core.cst$kw$vars);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32603){
var state_val_32604 = (state_32603[(1)]);
if((state_val_32604 === (7))){
var inst_32509 = (state_32603[(7)]);
var state_32603__$1 = state_32603;
var statearr_32605_32658 = state_32603__$1;
(statearr_32605_32658[(2)] = inst_32509);

(statearr_32605_32658[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (20))){
var inst_32537 = (state_32603[(8)]);
var inst_32568 = typeof inst_32537 === 'number';
var state_32603__$1 = state_32603;
if(cljs.core.truth_(inst_32568)){
var statearr_32606_32659 = state_32603__$1;
(statearr_32606_32659[(1)] = (22));

} else {
var statearr_32607_32660 = state_32603__$1;
(statearr_32607_32660[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (27))){
var inst_32583 = (state_32603[(2)]);
var state_32603__$1 = state_32603;
var statearr_32608_32661 = state_32603__$1;
(statearr_32608_32661[(2)] = inst_32583);

(statearr_32608_32661[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (1))){
var state_32603__$1 = state_32603;
var statearr_32609_32662 = state_32603__$1;
(statearr_32609_32662[(2)] = null);

(statearr_32609_32662[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (24))){
var inst_32585 = (state_32603[(2)]);
var state_32603__$1 = state_32603;
var statearr_32610_32663 = state_32603__$1;
(statearr_32610_32663[(2)] = inst_32585);

(statearr_32610_32663[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (4))){
var inst_32493 = (state_32603[(2)]);
var state_32603__$1 = state_32603;
var statearr_32611_32664 = state_32603__$1;
(statearr_32611_32664[(2)] = inst_32493);

(statearr_32611_32664[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (15))){
var inst_32551 = (state_32603[(2)]);
var inst_32552 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_32553 = fluree.db.query.analytical.variable_QMARK_(inst_32552);
var state_32603__$1 = (function (){var statearr_32612 = state_32603;
(statearr_32612[(9)] = inst_32551);

return statearr_32612;
})();
if(cljs.core.truth_(inst_32553)){
var statearr_32613_32665 = state_32603__$1;
(statearr_32613_32665[(1)] = (16));

} else {
var statearr_32614_32666 = state_32603__$1;
(statearr_32614_32666[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (21))){
var inst_32540 = (state_32603[(10)]);
var inst_32539 = (state_32603[(11)]);
var inst_32510 = (state_32603[(12)]);
var inst_32587 = (state_32603[(2)]);
var inst_32588 = fluree.db.query.analytical.tuples__GT_recur(db,inst_32540,inst_32587,inst_32510,inst_32539);
var state_32603__$1 = state_32603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32603__$1,(28),inst_32588);
} else {
if((state_val_32604 === (13))){
var inst_32519 = (state_32603[(13)]);
var inst_32543 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32519)].join('');
var inst_32544 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32545 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32546 = cljs.core.PersistentHashMap.fromArrays(inst_32544,inst_32545);
var inst_32547 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32543,inst_32546);
var inst_32548 = (function(){throw inst_32547})();
var state_32603__$1 = state_32603;
var statearr_32615_32667 = state_32603__$1;
(statearr_32615_32667[(2)] = inst_32548);

(statearr_32615_32667[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (22))){
var inst_32537 = (state_32603[(8)]);
var inst_32535 = (state_32603[(14)]);
var inst_32570 = cljs.core.PersistentHashMap.EMPTY;
var inst_32571 = cljs.core.flatten(inst_32535);
var inst_32572 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32570,inst_32537,inst_32571);
var state_32603__$1 = state_32603;
var statearr_32616_32668 = state_32603__$1;
(statearr_32616_32668[(2)] = inst_32572);

(statearr_32616_32668[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (6))){
var inst_32521 = (state_32603[(15)]);
var state_32603__$1 = state_32603;
var statearr_32617_32669 = state_32603__$1;
(statearr_32617_32669[(2)] = inst_32521);

(statearr_32617_32669[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (28))){
var inst_32590 = (state_32603[(2)]);
var inst_32591 = fluree.db.util.async.throw_err(inst_32590);
var state_32603__$1 = state_32603;
var statearr_32618_32670 = state_32603__$1;
(statearr_32618_32670[(2)] = inst_32591);

(statearr_32618_32670[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (25))){
var inst_32535 = (state_32603[(14)]);
var inst_32531 = (state_32603[(16)]);
var inst_32576 = cljs.core.PersistentHashMap.EMPTY;
var inst_32577 = cljs.core.first(inst_32531);
var inst_32578 = cljs.core.first(inst_32577);
var inst_32579 = cljs.core.flatten(inst_32535);
var inst_32580 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_32576,inst_32578,inst_32579);
var state_32603__$1 = state_32603;
var statearr_32619_32671 = state_32603__$1;
(statearr_32619_32671[(2)] = inst_32580);

(statearr_32619_32671[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (17))){
var inst_32519 = (state_32603[(13)]);
var inst_32556 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_32519)].join('');
var inst_32557 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32558 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32559 = cljs.core.PersistentHashMap.fromArrays(inst_32557,inst_32558);
var inst_32560 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_32556,inst_32559);
var inst_32561 = (function(){throw inst_32560})();
var state_32603__$1 = state_32603;
var statearr_32620_32672 = state_32603__$1;
(statearr_32620_32672[(2)] = inst_32561);

(statearr_32620_32672[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (3))){
var inst_32601 = (state_32603[(2)]);
var state_32603__$1 = state_32603;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32603__$1,inst_32601);
} else {
if((state_val_32604 === (12))){
var inst_32506 = (state_32603[(17)]);
var inst_32594 = (state_32603[(2)]);
var inst_32595 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_32596 = cljs.core.keys(inst_32506);
var inst_32597 = [inst_32596,vars,inst_32594];
var inst_32598 = cljs.core.PersistentHashMap.fromArrays(inst_32595,inst_32597);
var _ = (function (){var statearr_32621 = state_32603;
(statearr_32621[(4)] = cljs.core.rest((state_32603[(4)])));

return statearr_32621;
})();
var state_32603__$1 = state_32603;
var statearr_32622_32673 = state_32603__$1;
(statearr_32622_32673[(2)] = inst_32598);

(statearr_32622_32673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (2))){
var inst_32521 = (state_32603[(15)]);
var inst_32506 = (state_32603[(17)]);
var inst_32509 = (state_32603[(7)]);
var inst_32510 = (state_32603[(12)]);
var _ = (function (){var statearr_32623 = state_32603;
(statearr_32623[(4)] = cljs.core.cons((5),(state_32603[(4)])));

return statearr_32623;
})();
var inst_32503 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_32504 = cljs.core.__destructure_map(inst_32503);
var inst_32505 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32504,cljs.core.cst$kw$search);
var inst_32506__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32504,cljs.core.cst$kw$rel);
var inst_32507 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32504,cljs.core.cst$kw$opts);
var inst_32508 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_32509__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_32507);
var inst_32510__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_32507);
var inst_32512 = (function (){var map__32499 = inst_32504;
var search = inst_32505;
var rel = inst_32506__$1;
var opts = inst_32507;
var common_keys = inst_32508;
var object_fn = inst_32509__$1;
var recur_depth = inst_32510__$1;
return (function (p__32511,common_key){
var vec__32624 = p__32511;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32624,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32624,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__32627 = cljs.core._EQ_;
var expr__32628 = idx_of;
if(cljs.core.truth_((pred__32627.cljs$core$IFn$_invoke$arity$2 ? pred__32627.cljs$core$IFn$_invoke$arity$2((0),expr__32628) : pred__32627.call(null,(0),expr__32628)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__32627.cljs$core$IFn$_invoke$arity$2 ? pred__32627.cljs$core$IFn$_invoke$arity$2((1),expr__32628) : pred__32627.call(null,(1),expr__32628)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__32627.cljs$core$IFn$_invoke$arity$2 ? pred__32627.cljs$core$IFn$_invoke$arity$2((2),expr__32628) : pred__32627.call(null,(2),expr__32628)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__32628)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_32513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32514 = cljs.core.PersistentHashMap.EMPTY;
var inst_32515 = [inst_32514,inst_32505];
var inst_32516 = (new cljs.core.PersistentVector(null,2,(5),inst_32513,inst_32515,null));
var inst_32517 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32512,inst_32516,inst_32508);
var inst_32518 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32517,(0),null);
var inst_32519 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32517,(1),null);
var inst_32520 = [cljs.core.cst$kw$object_DASH_fn];
var inst_32521__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_32518);
var state_32603__$1 = (function (){var statearr_32630 = state_32603;
(statearr_32630[(15)] = inst_32521__$1);

(statearr_32630[(17)] = inst_32506__$1);

(statearr_32630[(13)] = inst_32519);

(statearr_32630[(7)] = inst_32509__$1);

(statearr_32630[(12)] = inst_32510__$1);

(statearr_32630[(18)] = inst_32520);

return statearr_32630;
})();
if(cljs.core.truth_(inst_32521__$1)){
var statearr_32631_32674 = state_32603__$1;
(statearr_32631_32674[(1)] = (6));

} else {
var statearr_32632_32675 = state_32603__$1;
(statearr_32632_32675[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (23))){
var inst_32537 = (state_32603[(8)]);
var inst_32574 = cljs.core.coll_QMARK_(inst_32537);
var state_32603__$1 = state_32603;
if(inst_32574){
var statearr_32633_32676 = state_32603__$1;
(statearr_32633_32676[(1)] = (25));

} else {
var statearr_32634_32677 = state_32603__$1;
(statearr_32634_32677[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (19))){
var inst_32535 = (state_32603[(14)]);
var inst_32565 = cljs.core.PersistentHashMap.EMPTY;
var inst_32566 = fluree.db.query.analytical.tuples__GT_map(inst_32565,inst_32535);
var state_32603__$1 = state_32603;
var statearr_32635_32678 = state_32603__$1;
(statearr_32635_32678[(2)] = inst_32566);

(statearr_32635_32678[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (11))){
var inst_32535 = (state_32603[(14)]);
var state_32603__$1 = state_32603;
var statearr_32637_32679 = state_32603__$1;
(statearr_32637_32679[(2)] = inst_32535);

(statearr_32637_32679[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (9))){
var inst_32506 = (state_32603[(17)]);
var inst_32531 = (state_32603[(16)]);
var inst_32510 = (state_32603[(12)]);
var inst_32530 = (state_32603[(2)]);
var inst_32531__$1 = fluree.db.util.async.throw_err(inst_32530);
var inst_32532 = cljs.core.count(inst_32531__$1);
var inst_32533 = fluree.db.query.analytical.add_fuel(inst_32532,fuel,max_fuel);
var inst_32534 = cljs.core.vals(inst_32506);
var inst_32535 = fluree.db.query.analytical.get_ns_arrays(inst_32534,inst_32531__$1);
var state_32603__$1 = (function (){var statearr_32638 = state_32603;
(statearr_32638[(19)] = inst_32533);

(statearr_32638[(14)] = inst_32535);

(statearr_32638[(16)] = inst_32531__$1);

return statearr_32638;
})();
if(cljs.core.truth_(inst_32510)){
var statearr_32639_32680 = state_32603__$1;
(statearr_32639_32680[(1)] = (10));

} else {
var statearr_32640_32681 = state_32603__$1;
(statearr_32640_32681[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (5))){
var _ = (function (){var statearr_32641 = state_32603;
(statearr_32641[(4)] = cljs.core.rest((state_32603[(4)])));

return statearr_32641;
})();
var state_32603__$1 = state_32603;
var ex32636 = (state_32603__$1[(2)]);
var statearr_32642_32682 = state_32603__$1;
(statearr_32642_32682[(5)] = ex32636);


if((ex32636 instanceof Error)){
var statearr_32643_32683 = state_32603__$1;
(statearr_32643_32683[(1)] = (4));

(statearr_32643_32683[(5)] = null);

} else {
throw ex32636;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (14))){
var state_32603__$1 = state_32603;
var statearr_32644_32684 = state_32603__$1;
(statearr_32644_32684[(2)] = null);

(statearr_32644_32684[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (26))){
var state_32603__$1 = state_32603;
var statearr_32645_32685 = state_32603__$1;
(statearr_32645_32685[(2)] = null);

(statearr_32645_32685[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (16))){
var state_32603__$1 = state_32603;
var statearr_32646_32686 = state_32603__$1;
(statearr_32646_32686[(2)] = null);

(statearr_32646_32686[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (10))){
var inst_32540 = (state_32603[(10)]);
var inst_32519 = (state_32603[(13)]);
var inst_32537 = cljs.core.first(inst_32519);
var inst_32538 = cljs.core.first(clause);
var inst_32539 = fluree.db.query.analytical.variable_QMARK_(inst_32538);
var inst_32540__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_32519,(1));
var inst_32541 = fluree.db.query.analytical.variable_QMARK_(inst_32540__$1);
var state_32603__$1 = (function (){var statearr_32647 = state_32603;
(statearr_32647[(10)] = inst_32540__$1);

(statearr_32647[(8)] = inst_32537);

(statearr_32647[(11)] = inst_32539);

return statearr_32647;
})();
if(cljs.core.truth_(inst_32541)){
var statearr_32648_32687 = state_32603__$1;
(statearr_32648_32687[(1)] = (13));

} else {
var statearr_32649_32688 = state_32603__$1;
(statearr_32649_32688[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (18))){
var inst_32539 = (state_32603[(11)]);
var inst_32563 = (state_32603[(2)]);
var state_32603__$1 = (function (){var statearr_32650 = state_32603;
(statearr_32650[(20)] = inst_32563);

return statearr_32650;
})();
if(cljs.core.truth_(inst_32539)){
var statearr_32651_32689 = state_32603__$1;
(statearr_32651_32689[(1)] = (19));

} else {
var statearr_32652_32690 = state_32603__$1;
(statearr_32652_32690[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32604 === (8))){
var inst_32519 = (state_32603[(13)]);
var inst_32520 = (state_32603[(18)]);
var inst_32525 = (state_32603[(2)]);
var inst_32526 = [inst_32525];
var inst_32527 = cljs.core.PersistentHashMap.fromArrays(inst_32520,inst_32526);
var inst_32528 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_32519,inst_32527);
var state_32603__$1 = state_32603;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32603__$1,(9),inst_32528);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____0 = (function (){
var statearr_32653 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32653[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__);

(statearr_32653[(1)] = (1));

return statearr_32653;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____1 = (function (state_32603){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32603);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e32654){var ex__10753__auto__ = e32654;
var statearr_32655_32691 = state_32603;
(statearr_32655_32691[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32603[(4)]))){
var statearr_32656_32692 = state_32603;
(statearr_32656_32692[(1)] = cljs.core.first((state_32603[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__32693 = state_32603;
state_32603 = G__32693;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__ = function(state_32603){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____1.call(this,state_32603);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_32657 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_32657[(6)] = c__10876__auto__);

return statearr_32657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__32694,res,clause){
var map__32695 = p__32694;
var map__32695__$1 = cljs.core.__destructure_map(map__32695);
var db = map__32695__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32695__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32695__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32695__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32794){
var state_val_32795 = (state_32794[(1)]);
if((state_val_32795 === (7))){
var inst_32705 = (state_32794[(7)]);
var state_32794__$1 = state_32794;
var statearr_32796_32836 = state_32794__$1;
(statearr_32796_32836[(2)] = inst_32705);

(statearr_32796_32836[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (20))){
var inst_32785 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
var statearr_32797_32837 = state_32794__$1;
(statearr_32797_32837[(2)] = inst_32785);

(statearr_32797_32837[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (1))){
var state_32794__$1 = state_32794;
var statearr_32798_32838 = state_32794__$1;
(statearr_32798_32838[(2)] = null);

(statearr_32798_32838[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (24))){
var inst_32764 = (state_32794[(2)]);
var inst_32765 = fluree.db.util.async.throw_err(inst_32764);
var state_32794__$1 = state_32794;
var statearr_32799_32839 = state_32794__$1;
(statearr_32799_32839[(2)] = inst_32765);

(statearr_32799_32839[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (4))){
var inst_32698 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
var statearr_32800_32840 = state_32794__$1;
(statearr_32800_32840[(2)] = inst_32698);

(statearr_32800_32840[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (15))){
var inst_32705 = (state_32794[(7)]);
var inst_32707 = (state_32794[(8)]);
var inst_32726 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32727 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32729 = [inst_32705];
var inst_32730 = (new cljs.core.PersistentVector(null,1,(5),inst_32728,inst_32729,null));
var inst_32731 = (function (){var subject_var = inst_32705;
var object_var = inst_32707;
var min_sid = inst_32726;
var max_sid = (0);
return (function (p1__32696_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__32696_SHARP_);
});
})();
var inst_32732 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_32726,(0));
var inst_32733 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32731,inst_32732);
var inst_32734 = cljs.core.PersistentHashMap.EMPTY;
var inst_32735 = [inst_32730,inst_32733,inst_32734];
var inst_32736 = cljs.core.PersistentHashMap.fromArrays(inst_32727,inst_32735);
var state_32794__$1 = state_32794;
var statearr_32801_32841 = state_32794__$1;
(statearr_32801_32841[(2)] = inst_32736);

(statearr_32801_32841[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (21))){
var inst_32758 = (state_32794[(9)]);
var state_32794__$1 = state_32794;
var statearr_32802_32842 = state_32794__$1;
(statearr_32802_32842[(2)] = inst_32758);

(statearr_32802_32842[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (13))){
var inst_32707 = (state_32794[(8)]);
var state_32794__$1 = state_32794;
if(cljs.core.truth_(inst_32707)){
var statearr_32803_32843 = state_32794__$1;
(statearr_32803_32843[(1)] = (18));

} else {
var statearr_32804_32844 = state_32794__$1;
(statearr_32804_32844[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (22))){
var inst_32758 = (state_32794[(9)]);
var inst_32762 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_32758);
var state_32794__$1 = state_32794;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32794__$1,(24),inst_32762);
} else {
if((state_val_32795 === (6))){
var inst_32707 = (state_32794[(8)]);
var state_32794__$1 = state_32794;
var statearr_32805_32845 = state_32794__$1;
(statearr_32805_32845[(2)] = inst_32707);

(statearr_32805_32845[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (17))){
var inst_32755 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
var statearr_32806_32846 = state_32794__$1;
(statearr_32806_32846[(2)] = inst_32755);

(statearr_32806_32846[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (3))){
var inst_32792 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32794__$1,inst_32792);
} else {
if((state_val_32795 === (12))){
var inst_32720 = ["_tx",null,"_block",null];
var inst_32721 = (new cljs.core.PersistentArrayMap(null,2,inst_32720,null));
var inst_32722 = (new cljs.core.PersistentHashSet(null,inst_32721,null));
var inst_32723 = cljs.core.last(clause);
var inst_32724 = (inst_32722.cljs$core$IFn$_invoke$arity$1 ? inst_32722.cljs$core$IFn$_invoke$arity$1(inst_32723) : inst_32722.call(null,inst_32723));
var state_32794__$1 = state_32794;
if(cljs.core.truth_(inst_32724)){
var statearr_32807_32847 = state_32794__$1;
(statearr_32807_32847[(1)] = (15));

} else {
var statearr_32808_32848 = state_32794__$1;
(statearr_32808_32848[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (2))){
var inst_32705 = (state_32794[(7)]);
var _ = (function (){var statearr_32809 = state_32794;
(statearr_32809[(4)] = cljs.core.cons((5),(state_32794[(4)])));

return statearr_32809;
})();
var inst_32704 = cljs.core.first(clause);
var inst_32705__$1 = fluree.db.query.analytical.variable_QMARK_(inst_32704);
var inst_32706 = cljs.core.last(clause);
var inst_32707 = fluree.db.query.analytical.variable_QMARK_(inst_32706);
var state_32794__$1 = (function (){var statearr_32810 = state_32794;
(statearr_32810[(7)] = inst_32705__$1);

(statearr_32810[(8)] = inst_32707);

return statearr_32810;
})();
if(cljs.core.truth_(inst_32705__$1)){
var statearr_32811_32849 = state_32794__$1;
(statearr_32811_32849[(1)] = (6));

} else {
var statearr_32812_32850 = state_32794__$1;
(statearr_32812_32850[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (23))){
var inst_32707 = (state_32794[(8)]);
var inst_32767 = (state_32794[(2)]);
var inst_32768 = fluree.db.flake.sid__GT_cid(inst_32767);
var inst_32769 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_32768);
var inst_32770 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32771 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32772 = [inst_32707];
var inst_32773 = (new cljs.core.PersistentVector(null,1,(5),inst_32771,inst_32772,null));
var inst_32774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32776 = [inst_32769];
var inst_32777 = (new cljs.core.PersistentVector(null,1,(5),inst_32775,inst_32776,null));
var inst_32778 = [inst_32777];
var inst_32779 = (new cljs.core.PersistentVector(null,1,(5),inst_32774,inst_32778,null));
var inst_32780 = cljs.core.PersistentHashMap.EMPTY;
var inst_32781 = [inst_32773,inst_32779,inst_32780];
var inst_32782 = cljs.core.PersistentHashMap.fromArrays(inst_32770,inst_32781);
var state_32794__$1 = state_32794;
var statearr_32813_32851 = state_32794__$1;
(statearr_32813_32851[(2)] = inst_32782);

(statearr_32813_32851[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (19))){
var state_32794__$1 = state_32794;
var statearr_32814_32852 = state_32794__$1;
(statearr_32814_32852[(2)] = null);

(statearr_32814_32852[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (11))){
var inst_32789 = (state_32794[(2)]);
var _ = (function (){var statearr_32816 = state_32794;
(statearr_32816[(4)] = cljs.core.rest((state_32794[(4)])));

return statearr_32816;
})();
var state_32794__$1 = state_32794;
var statearr_32817_32853 = state_32794__$1;
(statearr_32817_32853[(2)] = inst_32789);

(statearr_32817_32853[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (9))){
var inst_32713 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32714 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_32715 = cljs.core.PersistentHashMap.fromArrays(inst_32713,inst_32714);
var inst_32716 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_32715);
var inst_32717 = (function(){throw inst_32716})();
var state_32794__$1 = state_32794;
var statearr_32818_32854 = state_32794__$1;
(statearr_32818_32854[(2)] = inst_32717);

(statearr_32818_32854[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (5))){
var _ = (function (){var statearr_32819 = state_32794;
(statearr_32819[(4)] = cljs.core.rest((state_32794[(4)])));

return statearr_32819;
})();
var state_32794__$1 = state_32794;
var ex32815 = (state_32794__$1[(2)]);
var statearr_32820_32855 = state_32794__$1;
(statearr_32820_32855[(5)] = ex32815);


if((ex32815 instanceof Error)){
var statearr_32821_32856 = state_32794__$1;
(statearr_32821_32856[(1)] = (4));

(statearr_32821_32856[(5)] = null);

} else {
throw ex32815;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (14))){
var inst_32787 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
var statearr_32822_32857 = state_32794__$1;
(statearr_32822_32857[(2)] = inst_32787);

(statearr_32822_32857[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (16))){
var inst_32705 = (state_32794[(7)]);
var inst_32707 = (state_32794[(8)]);
var inst_32738 = cljs.core.last(clause);
var inst_32739 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_32738);
var inst_32740 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_32741 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32740,inst_32739);
var inst_32742 = fluree.db.flake.min_subject_id(inst_32739);
var inst_32743 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_32744 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32745 = [inst_32705];
var inst_32746 = (new cljs.core.PersistentVector(null,1,(5),inst_32744,inst_32745,null));
var inst_32747 = (function (){var subject_var = inst_32705;
var object_var = inst_32707;
var partition = inst_32739;
var max_sid = inst_32741;
var min_sid = inst_32742;
return (function (p1__32697_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__32697_SHARP_);
});
})();
var inst_32748 = (inst_32741 + (1));
var inst_32749 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_32742,inst_32748);
var inst_32750 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_32747,inst_32749);
var inst_32751 = cljs.core.PersistentHashMap.EMPTY;
var inst_32752 = [inst_32746,inst_32750,inst_32751];
var inst_32753 = cljs.core.PersistentHashMap.fromArrays(inst_32743,inst_32752);
var state_32794__$1 = state_32794;
var statearr_32823_32858 = state_32794__$1;
(statearr_32823_32858[(2)] = inst_32753);

(statearr_32823_32858[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (10))){
var inst_32705 = (state_32794[(7)]);
var state_32794__$1 = state_32794;
if(cljs.core.truth_(inst_32705)){
var statearr_32824_32859 = state_32794__$1;
(statearr_32824_32859[(1)] = (12));

} else {
var statearr_32825_32860 = state_32794__$1;
(statearr_32825_32860[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (18))){
var inst_32758 = (state_32794[(9)]);
var inst_32758__$1 = cljs.core.first(clause);
var inst_32759 = typeof inst_32758__$1 === 'number';
var state_32794__$1 = (function (){var statearr_32826 = state_32794;
(statearr_32826[(9)] = inst_32758__$1);

return statearr_32826;
})();
if(cljs.core.truth_(inst_32759)){
var statearr_32827_32861 = state_32794__$1;
(statearr_32827_32861[(1)] = (21));

} else {
var statearr_32828_32862 = state_32794__$1;
(statearr_32828_32862[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32795 === (8))){
var inst_32711 = (state_32794[(2)]);
var state_32794__$1 = state_32794;
if(cljs.core.truth_(inst_32711)){
var statearr_32829_32863 = state_32794__$1;
(statearr_32829_32863[(1)] = (9));

} else {
var statearr_32830_32864 = state_32794__$1;
(statearr_32830_32864[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____0 = (function (){
var statearr_32831 = [null,null,null,null,null,null,null,null,null,null];
(statearr_32831[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__);

(statearr_32831[(1)] = (1));

return statearr_32831;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____1 = (function (state_32794){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32794);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e32832){var ex__10753__auto__ = e32832;
var statearr_32833_32865 = state_32794;
(statearr_32833_32865[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32794[(4)]))){
var statearr_32834_32866 = state_32794;
(statearr_32834_32866[(1)] = cljs.core.first((state_32794[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__32867 = state_32794;
state_32794 = G__32867;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__ = function(state_32794){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____1.call(this,state_32794);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_32835 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_32835[(6)] = c__10876__auto__);

return statearr_32835;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__32874 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__32874 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__32874;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__32875(s__32876){
return (new cljs.core.LazySeq(null,(function (){
var s__32876__$1 = s__32876;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__32876__$1);
if(temp__5753__auto__){
var s__32876__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__32876__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__32876__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__32878 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__32877 = (0);
while(true){
if((i__32877 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__32877);
var delta = (x - mean);
cljs.core.chunk_append(b__32878,(delta * delta));

var G__32880 = (i__32877 + (1));
i__32877 = G__32880;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__32878),fluree$db$query$analytical$variance_$_iter__32875(cljs.core.chunk_rest(s__32876__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__32878),null);
}
} else {
var x = cljs.core.first(s__32876__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__32875(cljs.core.rest(s__32876__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__32879 = variance(coll);
return Math.sqrt(G__32879);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__32881 = null;
var G__32881__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32881__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32881 = function(n,coll){
switch(arguments.length){
case 1:
return G__32881__1.call(this,n);
case 2:
return G__32881__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32881.cljs$core$IFn$_invoke$arity$1 = G__32881__1;
G__32881.cljs$core$IFn$_invoke$arity$2 = G__32881__2;
return G__32881;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__32882 = null;
var G__32882__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__32882__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__32882 = function(n,coll){
switch(arguments.length){
case 1:
return G__32882__1.call(this,n);
case 2:
return G__32882__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32882.cljs$core$IFn$_invoke$arity$1 = G__32882__1;
G__32882.cljs$core$IFn$_invoke$arity$2 = G__32882__2;
return G__32882;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__32883 = null;
var G__32883__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__32883__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__32883 = function(n,coll){
switch(arguments.length){
case 1:
return G__32883__1.call(this,n);
case 2:
return G__32883__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__32883.cljs$core$IFn$_invoke$arity$1 = G__32883__1;
G__32883.cljs$core$IFn$_invoke$arity$2 = G__32883__2;
return G__32883;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__32884 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32884,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32884,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32884,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__32887 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__32890 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__32890) : agg_fn.call(null,G__32890));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32887,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32887,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__32891 = agg;
var map__32891__$1 = cljs.core.__destructure_map(map__32891);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32891__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32891__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32891__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__32893 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32893,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32893,(1),null);
var map__32896 = res__$1;
var map__32896__$1 = cljs.core.__destructure_map(map__32896);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32896__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32896__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32892_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__32892_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32897_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__32897_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32898_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32898_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32899_SHARP_,p2__32900_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__32899_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__32900_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32901_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__32901_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__32904,row,b_tuple){
var vec__32905 = p__32904;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32905,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32905,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32902_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32902_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32903_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__32903_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32908_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__32908_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32909_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__32909_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32914 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32916 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__32915 = (function (p1__32910_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32910_SHARP_);
});
return fexpr__32915(G__32916);
})()),cljs.core.set(b_idxs));
var fexpr__32913 = (function (p1__32911_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32911_SHARP_);
});
return fexpr__32913(G__32914);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32912_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__32912_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32917_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__32917_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32918_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32918_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__32923 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__32925 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__32924 = (function (p1__32919_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__32919_SHARP_);
});
return fexpr__32924(G__32925);
})()),cljs.core.set(b_idxs));
var fexpr__32922 = (function (p1__32920_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__32920_SHARP_);
});
return fexpr__32922(G__32923);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32921_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__32921_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__32927 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32927,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32927,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__32926_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__32926_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__32932 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32932,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32932,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__32930_SHARP_){
return fluree.db.util.core.index_of(headers,p1__32930_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__32931_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__32931_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__32935,filters,optional_QMARK_){
var map__32936 = p__32935;
var map__32936__$1 = cljs.core.__destructure_map(map__32936);
var tuple_map = map__32936__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32936__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32936__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32936__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__32937 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32937,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32937,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__32940 = res;
var map__32940__$1 = cljs.core.__destructure_map(map__32940);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32940__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__32940__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_32996){
var state_val_32997 = (state_32996[(1)]);
if((state_val_32997 === (7))){
var inst_32970 = (state_32996[(7)]);
var inst_32968 = (state_32996[(2)]);
var inst_32969 = fluree.db.util.async.throw_err(inst_32968);
var inst_32970__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32969,(0),null);
var inst_32971 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32969,(1),null);
var inst_32972 = (inst_32970__$1 == null);
var state_32996__$1 = (function (){var statearr_32998 = state_32996;
(statearr_32998[(7)] = inst_32970__$1);

(statearr_32998[(8)] = inst_32971);

return statearr_32998;
})();
if(cljs.core.truth_(inst_32972)){
var statearr_32999_33028 = state_32996__$1;
(statearr_32999_33028[(1)] = (8));

} else {
var statearr_33000_33029 = state_32996__$1;
(statearr_33000_33029[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (1))){
var inst_32948 = optional_clauses;
var inst_32949 = cljs.core.seq(inst_32948);
var inst_32950 = cljs.core.first(inst_32949);
var inst_32951 = cljs.core.next(inst_32949);
var inst_32952 = where_tuples;
var inst_32953 = inst_32948;
var inst_32954 = inst_32952;
var state_32996__$1 = (function (){var statearr_33001 = state_32996;
(statearr_33001[(9)] = inst_32953);

(statearr_33001[(10)] = inst_32951);

(statearr_33001[(11)] = inst_32954);

(statearr_33001[(12)] = inst_32950);

return statearr_33001;
})();
var statearr_33002_33030 = state_32996__$1;
(statearr_33002_33030[(2)] = null);

(statearr_33002_33030[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (4))){
var inst_32961 = (state_32996[(13)]);
var inst_32954 = (state_32996[(11)]);
var inst_32960 = (state_32996[(14)]);
var inst_32966 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_32954,inst_32960,inst_32961,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_32954,inst_32960,inst_32961,true,fuel,max_fuel,opts));
var state_32996__$1 = state_32996;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32996__$1,(7),inst_32966);
} else {
if((state_val_32997 === (15))){
var state_32996__$1 = state_32996;
var statearr_33003_33031 = state_32996__$1;
(statearr_33003_33031[(2)] = null);

(statearr_33003_33031[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (13))){
var inst_32987 = (state_32996[(2)]);
var state_32996__$1 = state_32996;
var statearr_33004_33032 = state_32996__$1;
(statearr_33004_33032[(2)] = inst_32987);

(statearr_33004_33032[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (6))){
var inst_32992 = (state_32996[(2)]);
var state_32996__$1 = state_32996;
var statearr_33005_33033 = state_32996__$1;
(statearr_33005_33033[(2)] = inst_32992);

(statearr_33005_33033[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (3))){
var inst_32994 = (state_32996[(2)]);
var state_32996__$1 = state_32996;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32996__$1,inst_32994);
} else {
if((state_val_32997 === (12))){
var state_32996__$1 = state_32996;
var statearr_33006_33034 = state_32996__$1;
(statearr_33006_33034[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (2))){
var inst_32953 = (state_32996[(9)]);
var inst_32960 = (state_32996[(14)]);
var inst_32959 = cljs.core.seq(inst_32953);
var inst_32960__$1 = cljs.core.first(inst_32959);
var inst_32961 = cljs.core.next(inst_32959);
var state_32996__$1 = (function (){var statearr_33008 = state_32996;
(statearr_33008[(13)] = inst_32961);

(statearr_33008[(14)] = inst_32960__$1);

return statearr_33008;
})();
if(cljs.core.truth_(inst_32960__$1)){
var statearr_33009_33035 = state_32996__$1;
(statearr_33009_33035[(1)] = (4));

} else {
var statearr_33010_33036 = state_32996__$1;
(statearr_33010_33036[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (11))){
var inst_32970 = (state_32996[(7)]);
var inst_32971 = (state_32996[(8)]);
var inst_32953 = inst_32971;
var inst_32954 = inst_32970;
var state_32996__$1 = (function (){var statearr_33011 = state_32996;
(statearr_33011[(9)] = inst_32953);

(statearr_33011[(11)] = inst_32954);

return statearr_33011;
})();
var statearr_33012_33037 = state_32996__$1;
(statearr_33012_33037[(2)] = null);

(statearr_33012_33037[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (9))){
var inst_32960 = (state_32996[(14)]);
var inst_32976 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_32960);
var state_32996__$1 = state_32996;
if(cljs.core.truth_(inst_32976)){
var statearr_33013_33038 = state_32996__$1;
(statearr_33013_33038[(1)] = (11));

} else {
var statearr_33014_33039 = state_32996__$1;
(statearr_33014_33039[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (5))){
var inst_32954 = (state_32996[(11)]);
var state_32996__$1 = state_32996;
var statearr_33015_33040 = state_32996__$1;
(statearr_33015_33040[(2)] = inst_32954);

(statearr_33015_33040[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (14))){
var inst_32970 = (state_32996[(7)]);
var inst_32954 = (state_32996[(11)]);
var inst_32971 = (state_32996[(8)]);
var inst_32981 = fluree.db.query.analytical.left_outer_join(inst_32954,inst_32970);
var inst_32953 = inst_32971;
var inst_32954__$1 = inst_32981;
var state_32996__$1 = (function (){var statearr_33016 = state_32996;
(statearr_33016[(9)] = inst_32953);

(statearr_33016[(11)] = inst_32954__$1);

return statearr_33016;
})();
var statearr_33017_33041 = state_32996__$1;
(statearr_33017_33041[(2)] = null);

(statearr_33017_33041[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (16))){
var inst_32985 = (state_32996[(2)]);
var state_32996__$1 = state_32996;
var statearr_33019_33042 = state_32996__$1;
(statearr_33019_33042[(2)] = inst_32985);

(statearr_33019_33042[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (10))){
var inst_32989 = (state_32996[(2)]);
var state_32996__$1 = state_32996;
var statearr_33020_33043 = state_32996__$1;
(statearr_33020_33043[(2)] = inst_32989);

(statearr_33020_33043[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32997 === (8))){
var inst_32954 = (state_32996[(11)]);
var inst_32971 = (state_32996[(8)]);
var tmp33018 = inst_32954;
var inst_32953 = inst_32971;
var inst_32954__$1 = tmp33018;
var state_32996__$1 = (function (){var statearr_33021 = state_32996;
(statearr_33021[(9)] = inst_32953);

(statearr_33021[(11)] = inst_32954__$1);

return statearr_33021;
})();
var statearr_33022_33044 = state_32996__$1;
(statearr_33022_33044[(2)] = null);

(statearr_33022_33044[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____0 = (function (){
var statearr_33023 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33023[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__);

(statearr_33023[(1)] = (1));

return statearr_33023;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____1 = (function (state_32996){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_32996);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e33024){var ex__10753__auto__ = e33024;
var statearr_33025_33045 = state_32996;
(statearr_33025_33045[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_32996[(4)]))){
var statearr_33026_33046 = state_32996;
(statearr_33026_33046[(1)] = cljs.core.first((state_32996[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__33047 = state_32996;
state_32996 = G__33047;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__ = function(state_32996){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____1.call(this,state_32996);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_33027 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_33027[(6)] = c__10876__auto__);

return statearr_33027;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__33049){
var vec__33050 = p__33049;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33050,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__33050,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__33048_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__33048_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__33054,p__33055,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__33056 = p__33054;
var map__33056__$1 = cljs.core.__destructure_map(map__33056);
var q_map = map__33056__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33056__$1,cljs.core.cst$kw$prefixes);
var map__33057 = p__33055;
var map__33057__$1 = cljs.core.__destructure_map(map__33057);
var res = map__33057__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33057__$1,cljs.core.cst$kw$vars);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_33294){
var state_val_33295 = (state_33294[(1)]);
if((state_val_33295 === (65))){
var inst_33243 = (state_33294[(7)]);
var inst_33244 = (state_33294[(8)]);
var inst_33255 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33256 = fluree.db.query.analytical.full_text__GT_tuples(inst_33243,res,inst_33244);
var inst_33257 = [inst_33256,r];
var inst_33258 = (new cljs.core.PersistentVector(null,2,(5),inst_33255,inst_33257,null));
var state_33294__$1 = state_33294;
var statearr_33296_33409 = state_33294__$1;
(statearr_33296_33409[(2)] = inst_33258);

(statearr_33296_33409[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (70))){
var inst_33270 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33297_33410 = state_33294__$1;
(statearr_33297_33410[(2)] = inst_33270);

(statearr_33297_33410[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (62))){
var inst_33244 = (state_33294[(8)]);
var inst_33252 = cljs.core.second(inst_33244);
var inst_33253 = clojure.string.starts_with_QMARK_(inst_33252,"fullText:");
var state_33294__$1 = state_33294;
if(inst_33253){
var statearr_33298_33411 = state_33294__$1;
(statearr_33298_33411[(1)] = (65));

} else {
var statearr_33299_33412 = state_33294__$1;
(statearr_33299_33412[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (7))){
var inst_33163 = (state_33294[(9)]);
var inst_33162 = cljs.core.count(clause);
var inst_33163__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_33162);
var state_33294__$1 = (function (){var statearr_33300 = state_33294;
(statearr_33300[(9)] = inst_33163__$1);

return statearr_33300;
})();
if(inst_33163__$1){
var statearr_33301_33413 = state_33294__$1;
(statearr_33301_33413[(1)] = (31));

} else {
var statearr_33302_33414 = state_33294__$1;
(statearr_33302_33414[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (59))){
var inst_33277 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33303_33415 = state_33294__$1;
(statearr_33303_33415[(2)] = inst_33277);

(statearr_33303_33415[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (20))){
var inst_33126 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33304_33416 = state_33294__$1;
(statearr_33304_33416[(2)] = inst_33126);

(statearr_33304_33416[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (58))){
var state_33294__$1 = state_33294;
var statearr_33305_33417 = state_33294__$1;
(statearr_33305_33417[(2)] = null);

(statearr_33305_33417[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (60))){
var inst_33243 = (state_33294[(7)]);
var inst_33241 = (state_33294[(2)]);
var inst_33242 = fluree.db.util.async.throw_err(inst_33241);
var inst_33243__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33242,(0),null);
var inst_33244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33242,(1),null);
var inst_33245 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_33243__$1);
var state_33294__$1 = (function (){var statearr_33306 = state_33294;
(statearr_33306[(7)] = inst_33243__$1);

(statearr_33306[(8)] = inst_33244);

return statearr_33306;
})();
if(inst_33245){
var statearr_33307_33418 = state_33294__$1;
(statearr_33307_33418[(1)] = (61));

} else {
var statearr_33308_33419 = state_33294__$1;
(statearr_33308_33419[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (27))){
var inst_33156 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33309_33420 = state_33294__$1;
(statearr_33309_33420[(2)] = inst_33156);

(statearr_33309_33420[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (1))){
var state_33294__$1 = state_33294;
var statearr_33310_33421 = state_33294__$1;
(statearr_33310_33421[(2)] = null);

(statearr_33310_33421[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (69))){
var state_33294__$1 = state_33294;
var statearr_33311_33422 = state_33294__$1;
(statearr_33311_33422[(2)] = null);

(statearr_33311_33422[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (24))){
var inst_33120 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33312_33423 = state_33294__$1;
(statearr_33312_33423[(2)] = inst_33120);

(statearr_33312_33423[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (55))){
var inst_33226 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_33227 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33228 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33229 = cljs.core.PersistentHashMap.fromArrays(inst_33227,inst_33228);
var inst_33230 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33226,inst_33229);
var inst_33231 = (function(){throw inst_33230})();
var state_33294__$1 = state_33294;
var statearr_33313_33424 = state_33294__$1;
(statearr_33313_33424[(2)] = inst_33231);

(statearr_33313_33424[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (39))){
var inst_33183 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
if(cljs.core.truth_(inst_33183)){
var statearr_33314_33425 = state_33294__$1;
(statearr_33314_33425[(1)] = (40));

} else {
var statearr_33315_33426 = state_33294__$1;
(statearr_33315_33426[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (46))){
var inst_33283 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33316_33427 = state_33294__$1;
(statearr_33316_33427[(2)] = inst_33283);

(statearr_33316_33427[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (4))){
var inst_33058 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33317_33428 = state_33294__$1;
(statearr_33317_33428[(2)] = inst_33058);

(statearr_33317_33428[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (54))){
var inst_33219 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_33220 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33221 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_33222 = cljs.core.PersistentHashMap.fromArrays(inst_33220,inst_33221);
var inst_33223 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33219,inst_33222);
var inst_33224 = (function(){throw inst_33223})();
var state_33294__$1 = state_33294;
var statearr_33318_33429 = state_33294__$1;
(statearr_33318_33429[(2)] = inst_33224);

(statearr_33318_33429[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (15))){
var inst_33158 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33319_33430 = state_33294__$1;
(statearr_33319_33430[(2)] = inst_33158);

(statearr_33319_33430[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (48))){
var inst_33207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33208 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_33209 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_33208);
var inst_33210 = [inst_33209,r];
var inst_33211 = (new cljs.core.PersistentVector(null,2,(5),inst_33207,inst_33210,null));
var state_33294__$1 = state_33294;
var statearr_33320_33431 = state_33294__$1;
(statearr_33320_33431[(2)] = inst_33211);

(statearr_33320_33431[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (50))){
var inst_33281 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33321_33432 = state_33294__$1;
(statearr_33321_33432[(2)] = inst_33281);

(statearr_33321_33432[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (21))){
var inst_33095 = (state_33294[(10)]);
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33104 = (state_33294[(13)]);
var inst_33103 = (state_33294[(14)]);
var inst_33096 = (state_33294[(15)]);
var inst_33094 = (state_33294[(16)]);
var inst_33092 = (state_33294[(17)]);
var inst_33097 = (state_33294[(18)]);
var inst_33108 = (state_33294[(2)]);
var inst_33109 = fluree.db.util.async.throw_err(inst_33108);
var inst_33110 = (function (){var new_res = inst_33109;
var seq__33090 = inst_33095;
var rest = inst_33104;
var first__33091 = inst_33094;
var vec__33089 = inst_33092;
var tuples = inst_33097;
var first__33101 = inst_33103;
var seq__33100 = inst_33104;
var expr__33069 = inst_33067;
var pred__33068 = inst_33071;
var vec__33099 = inst_33096;
var segment_type = inst_33067;
var clause_group = inst_33103;
var G__33088 = inst_33096;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_33111 = cljs.core.keys(vars);
var inst_33112 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33110,inst_33109,inst_33111);
var inst_33113 = fluree.db.query.analytical.res_absorb_vars(inst_33112);
var state_33294__$1 = (function (){var statearr_33322 = state_33294;
(statearr_33322[(19)] = inst_33113);

return statearr_33322;
})();
if(cljs.core.truth_(inst_33097)){
var statearr_33323_33433 = state_33294__$1;
(statearr_33323_33433[(1)] = (22));

} else {
var statearr_33324_33434 = state_33294__$1;
(statearr_33324_33434[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (31))){
var inst_33165 = cljs.core.second(clause);
var inst_33166 = clojure.string.starts_with_QMARK_(inst_33165,"fullText:");
var state_33294__$1 = state_33294;
var statearr_33325_33435 = state_33294__$1;
(statearr_33325_33435[(2)] = inst_33166);

(statearr_33325_33435[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (32))){
var inst_33163 = (state_33294[(9)]);
var state_33294__$1 = state_33294;
var statearr_33326_33436 = state_33294__$1;
(statearr_33326_33436[(2)] = inst_33163);

(statearr_33326_33436[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (40))){
var inst_33185 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33186 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_33294__$1 = (function (){var statearr_33327 = state_33294;
(statearr_33327[(20)] = inst_33185);

return statearr_33327;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(43),inst_33186);
} else {
if((state_val_33295 === (56))){
var inst_33233 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33328_33437 = state_33294__$1;
(statearr_33328_33437[(2)] = inst_33233);

(statearr_33328_33437[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (33))){
var inst_33169 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
if(cljs.core.truth_(inst_33169)){
var statearr_33329_33438 = state_33294__$1;
(statearr_33329_33438[(1)] = (34));

} else {
var statearr_33330_33439 = state_33294__$1;
(statearr_33330_33439[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (13))){
var inst_33092 = (state_33294[(17)]);
var inst_33092__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_33093 = cljs.core.seq(inst_33092__$1);
var inst_33094 = cljs.core.first(inst_33093);
var inst_33095 = cljs.core.next(inst_33093);
var inst_33096 = inst_33092__$1;
var inst_33097 = null;
var state_33294__$1 = (function (){var statearr_33331 = state_33294;
(statearr_33331[(10)] = inst_33095);

(statearr_33331[(15)] = inst_33096);

(statearr_33331[(16)] = inst_33094);

(statearr_33331[(17)] = inst_33092__$1);

(statearr_33331[(18)] = inst_33097);

return statearr_33331;
})();
var statearr_33332_33440 = state_33294__$1;
(statearr_33332_33440[(2)] = null);

(statearr_33332_33440[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (22))){
var inst_33104 = (state_33294[(13)]);
var inst_33113 = (state_33294[(19)]);
var inst_33097 = (state_33294[(18)]);
var inst_33115 = fluree.db.query.union.results(inst_33097,inst_33113);
var inst_33096 = inst_33104;
var inst_33097__$1 = inst_33115;
var state_33294__$1 = (function (){var statearr_33333 = state_33294;
(statearr_33333[(15)] = inst_33096);

(statearr_33333[(18)] = inst_33097__$1);

return statearr_33333;
})();
var statearr_33334_33441 = state_33294__$1;
(statearr_33334_33441[(2)] = null);

(statearr_33334_33441[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (36))){
var inst_33287 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33335_33442 = state_33294__$1;
(statearr_33335_33442[(2)] = inst_33287);

(statearr_33335_33442[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (41))){
var inst_33193 = cljs.core.count(clause);
var inst_33194 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_33193);
var state_33294__$1 = state_33294;
if(inst_33194){
var statearr_33336_33443 = state_33294__$1;
(statearr_33336_33443[(1)] = (44));

} else {
var statearr_33337_33444 = state_33294__$1;
(statearr_33337_33444[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (43))){
var inst_33185 = (state_33294[(20)]);
var inst_33188 = (state_33294[(2)]);
var inst_33189 = fluree.db.util.async.throw_err(inst_33188);
var inst_33190 = [inst_33189,r];
var inst_33191 = (new cljs.core.PersistentVector(null,2,(5),inst_33185,inst_33190,null));
var state_33294__$1 = state_33294;
var statearr_33338_33445 = state_33294__$1;
(statearr_33338_33445[(2)] = inst_33191);

(statearr_33338_33445[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (61))){
var inst_33244 = (state_33294[(8)]);
var inst_33247 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_33244,r,res,optional_QMARK_,fuel,max_fuel);
var state_33294__$1 = state_33294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(64),inst_33247);
} else {
if((state_val_33295 === (29))){
var inst_33067 = (state_33294[(12)]);
var inst_33150 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33067)].join('');
var inst_33151 = (new Error(inst_33150));
var inst_33152 = (function(){throw inst_33151})();
var state_33294__$1 = state_33294;
var statearr_33339_33446 = state_33294__$1;
(statearr_33339_33446[(2)] = inst_33152);

(statearr_33339_33446[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (44))){
var inst_33196 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33197 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_33294__$1 = (function (){var statearr_33340 = state_33294;
(statearr_33340[(21)] = inst_33196);

return statearr_33340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(47),inst_33197);
} else {
if((state_val_33295 === (6))){
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33066 = cljs.core.keys(clause);
var inst_33067__$1 = cljs.core.first(inst_33066);
var inst_33071__$1 = cljs.core._EQ_;
var inst_33072 = (function (){var G__33341 = cljs.core.cst$kw$optional;
var G__33342 = inst_33067__$1;
return (inst_33071__$1.cljs$core$IFn$_invoke$arity$2 ? inst_33071__$1.cljs$core$IFn$_invoke$arity$2(G__33341,G__33342) : inst_33071__$1.call(null,G__33341,G__33342));
})();
var state_33294__$1 = (function (){var statearr_33343 = state_33294;
(statearr_33343[(11)] = inst_33071__$1);

(statearr_33343[(12)] = inst_33067__$1);

return statearr_33343;
})();
if(cljs.core.truth_(inst_33072)){
var statearr_33344_33447 = state_33294__$1;
(statearr_33344_33447[(1)] = (9));

} else {
var statearr_33345_33448 = state_33294__$1;
(statearr_33345_33448[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (28))){
var inst_33144 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33145 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_33146 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_33145,optional_QMARK_);
var inst_33147 = [inst_33146,r];
var inst_33148 = (new cljs.core.PersistentVector(null,2,(5),inst_33144,inst_33147,null));
var state_33294__$1 = state_33294;
var statearr_33346_33449 = state_33294__$1;
(statearr_33346_33449[(2)] = inst_33148);

(statearr_33346_33449[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (64))){
var inst_33249 = (state_33294[(2)]);
var inst_33250 = fluree.db.util.async.throw_err(inst_33249);
var state_33294__$1 = state_33294;
var statearr_33347_33450 = state_33294__$1;
(statearr_33347_33450[(2)] = inst_33250);

(statearr_33347_33450[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (51))){
var inst_33216 = cljs.core.first(clause);
var inst_33217 = cljs.core.sequential_QMARK_(inst_33216);
var state_33294__$1 = state_33294;
if(inst_33217){
var statearr_33348_33451 = state_33294__$1;
(statearr_33348_33451[(1)] = (54));

} else {
var statearr_33349_33452 = state_33294__$1;
(statearr_33349_33452[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (25))){
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33132 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_33133 = (function (){var segment_type = inst_33067;
var pred__33068 = inst_33071;
var expr__33069 = inst_33067;
var bindings = inst_33132;
return (function (p1__33053_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__33053_SHARP_);
});
})();
var inst_33134 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_33133,inst_33132);
var inst_33135 = cljs.core.PersistentHashMap.EMPTY;
var inst_33136 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33135,inst_33134);
var inst_33137 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33138 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_33136);
var inst_33139 = [inst_33138,r];
var inst_33140 = (new cljs.core.PersistentVector(null,2,(5),inst_33137,inst_33139,null));
var state_33294__$1 = state_33294;
var statearr_33350_33453 = state_33294__$1;
(statearr_33350_33453[(2)] = inst_33140);

(statearr_33350_33453[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (34))){
var inst_33171 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33172 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_33173 = [inst_33172,r];
var inst_33174 = (new cljs.core.PersistentVector(null,2,(5),inst_33171,inst_33173,null));
var state_33294__$1 = state_33294;
var statearr_33351_33454 = state_33294__$1;
(statearr_33351_33454[(2)] = inst_33174);

(statearr_33351_33454[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (17))){
var inst_33128 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33352_33455 = state_33294__$1;
(statearr_33352_33455[(2)] = inst_33128);

(statearr_33352_33455[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (3))){
var inst_33292 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33294__$1,inst_33292);
} else {
if((state_val_33295 === (12))){
var inst_33074 = (state_33294[(22)]);
var inst_33078 = (state_33294[(2)]);
var inst_33079 = fluree.db.util.async.throw_err(inst_33078);
var inst_33080 = [inst_33079,r];
var inst_33081 = (new cljs.core.PersistentVector(null,2,(5),inst_33074,inst_33080,null));
var state_33294__$1 = state_33294;
var statearr_33353_33456 = state_33294__$1;
(statearr_33353_33456[(2)] = inst_33081);

(statearr_33353_33456[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (2))){
var _ = (function (){var statearr_33354 = state_33294;
(statearr_33354[(4)] = cljs.core.cons((5),(state_33294[(4)])));

return statearr_33354;
})();
var inst_33064 = cljs.core.map_QMARK_(clause);
var state_33294__$1 = state_33294;
if(inst_33064){
var statearr_33355_33457 = state_33294__$1;
(statearr_33355_33457[(1)] = (6));

} else {
var statearr_33356_33458 = state_33294__$1;
(statearr_33356_33458[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (66))){
var state_33294__$1 = state_33294;
var statearr_33357_33459 = state_33294__$1;
(statearr_33357_33459[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (23))){
var inst_33104 = (state_33294[(13)]);
var inst_33113 = (state_33294[(19)]);
var inst_33096 = inst_33104;
var inst_33097 = inst_33113;
var state_33294__$1 = (function (){var statearr_33359 = state_33294;
(statearr_33359[(15)] = inst_33096);

(statearr_33359[(18)] = inst_33097);

return statearr_33359;
})();
var statearr_33360_33460 = state_33294__$1;
(statearr_33360_33460[(2)] = null);

(statearr_33360_33460[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (47))){
var inst_33196 = (state_33294[(21)]);
var inst_33199 = (state_33294[(2)]);
var inst_33200 = fluree.db.util.async.throw_err(inst_33199);
var inst_33201 = [inst_33200,r];
var inst_33202 = (new cljs.core.PersistentVector(null,2,(5),inst_33196,inst_33201,null));
var state_33294__$1 = state_33294;
var statearr_33361_33461 = state_33294__$1;
(statearr_33361_33461[(2)] = inst_33202);

(statearr_33361_33461[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (35))){
var inst_33177 = (state_33294[(23)]);
var inst_33176 = cljs.core.count(clause);
var inst_33177__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_33176);
var state_33294__$1 = (function (){var statearr_33362 = state_33294;
(statearr_33362[(23)] = inst_33177__$1);

return statearr_33362;
})();
if(inst_33177__$1){
var statearr_33363_33462 = state_33294__$1;
(statearr_33363_33462[(1)] = (37));

} else {
var statearr_33364_33463 = state_33294__$1;
(statearr_33364_33463[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (19))){
var inst_33097 = (state_33294[(18)]);
var inst_33122 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33123 = [inst_33097,r];
var inst_33124 = (new cljs.core.PersistentVector(null,2,(5),inst_33122,inst_33123,null));
var state_33294__$1 = state_33294;
var statearr_33365_33464 = state_33294__$1;
(statearr_33365_33464[(2)] = inst_33124);

(statearr_33365_33464[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (57))){
var inst_33239 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_33294__$1 = state_33294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(60),inst_33239);
} else {
if((state_val_33295 === (68))){
var inst_33243 = (state_33294[(7)]);
var inst_33244 = (state_33294[(8)]);
var inst_33261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33262 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_33243,res,inst_33244,fuel,max_fuel);
var state_33294__$1 = (function (){var statearr_33366 = state_33294;
(statearr_33366[(24)] = inst_33261);

return statearr_33366;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(71),inst_33262);
} else {
if((state_val_33295 === (11))){
var inst_33160 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33368_33465 = state_33294__$1;
(statearr_33368_33465[(2)] = inst_33160);

(statearr_33368_33465[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (9))){
var inst_33074 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33075 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_33076 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_33075,res,fuel,max_fuel,opts);
var state_33294__$1 = (function (){var statearr_33369 = state_33294;
(statearr_33369[(22)] = inst_33074);

return statearr_33369;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(12),inst_33076);
} else {
if((state_val_33295 === (5))){
var _ = (function (){var statearr_33370 = state_33294;
(statearr_33370[(4)] = cljs.core.rest((state_33294[(4)])));

return statearr_33370;
})();
var state_33294__$1 = state_33294;
var ex33367 = (state_33294__$1[(2)]);
var statearr_33371_33466 = state_33294__$1;
(statearr_33371_33466[(5)] = ex33367);


if((ex33367 instanceof Error)){
var statearr_33372_33467 = state_33294__$1;
(statearr_33372_33467[(1)] = (4));

(statearr_33372_33467[(5)] = null);

} else {
throw ex33367;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (14))){
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33130 = (function (){var G__33373 = cljs.core.cst$kw$bind;
var G__33374 = inst_33067;
return (inst_33071.cljs$core$IFn$_invoke$arity$2 ? inst_33071.cljs$core$IFn$_invoke$arity$2(G__33373,G__33374) : inst_33071.call(null,G__33373,G__33374));
})();
var state_33294__$1 = state_33294;
if(cljs.core.truth_(inst_33130)){
var statearr_33375_33468 = state_33294__$1;
(statearr_33375_33468[(1)] = (25));

} else {
var statearr_33376_33469 = state_33294__$1;
(statearr_33376_33469[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (45))){
var inst_33204 = cljs.core.count(clause);
var inst_33205 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_33204);
var state_33294__$1 = state_33294;
if(inst_33205){
var statearr_33377_33470 = state_33294__$1;
(statearr_33377_33470[(1)] = (48));

} else {
var statearr_33378_33471 = state_33294__$1;
(statearr_33378_33471[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (53))){
var inst_33279 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33379_33472 = state_33294__$1;
(statearr_33379_33472[(2)] = inst_33279);

(statearr_33379_33472[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (26))){
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33142 = (function (){var G__33380 = cljs.core.cst$kw$filter;
var G__33381 = inst_33067;
return (inst_33071.cljs$core$IFn$_invoke$arity$2 ? inst_33071.cljs$core$IFn$_invoke$arity$2(G__33380,G__33381) : inst_33071.call(null,G__33380,G__33381));
})();
var state_33294__$1 = state_33294;
if(cljs.core.truth_(inst_33142)){
var statearr_33382_33473 = state_33294__$1;
(statearr_33382_33473[(1)] = (28));

} else {
var statearr_33383_33474 = state_33294__$1;
(statearr_33383_33474[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (16))){
var inst_33103 = (state_33294[(14)]);
var inst_33096 = (state_33294[(15)]);
var inst_33102 = cljs.core.seq(inst_33096);
var inst_33103__$1 = cljs.core.first(inst_33102);
var inst_33104 = cljs.core.next(inst_33102);
var state_33294__$1 = (function (){var statearr_33384 = state_33294;
(statearr_33384[(13)] = inst_33104);

(statearr_33384[(14)] = inst_33103__$1);

return statearr_33384;
})();
if(cljs.core.truth_(inst_33103__$1)){
var statearr_33385_33475 = state_33294__$1;
(statearr_33385_33475[(1)] = (18));

} else {
var statearr_33386_33476 = state_33294__$1;
(statearr_33386_33476[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (38))){
var inst_33177 = (state_33294[(23)]);
var state_33294__$1 = state_33294;
var statearr_33387_33477 = state_33294__$1;
(statearr_33387_33477[(2)] = inst_33177);

(statearr_33387_33477[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (30))){
var inst_33154 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33388_33478 = state_33294__$1;
(statearr_33388_33478[(2)] = inst_33154);

(statearr_33388_33478[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (10))){
var inst_33071 = (state_33294[(11)]);
var inst_33067 = (state_33294[(12)]);
var inst_33083 = (function (){var G__33389 = cljs.core.cst$kw$union;
var G__33390 = inst_33067;
return (inst_33071.cljs$core$IFn$_invoke$arity$2 ? inst_33071.cljs$core$IFn$_invoke$arity$2(G__33389,G__33390) : inst_33071.call(null,G__33389,G__33390));
})();
var state_33294__$1 = state_33294;
if(cljs.core.truth_(inst_33083)){
var statearr_33391_33479 = state_33294__$1;
(statearr_33391_33479[(1)] = (13));

} else {
var statearr_33392_33480 = state_33294__$1;
(statearr_33392_33480[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (18))){
var inst_33103 = (state_33294[(14)]);
var inst_33106 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_33103,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_33103,q_map,vars,fuel,max_fuel,opts));
var state_33294__$1 = state_33294;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33294__$1,(21),inst_33106);
} else {
if((state_val_33295 === (52))){
var state_33294__$1 = state_33294;
var statearr_33393_33481 = state_33294__$1;
(statearr_33393_33481[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (67))){
var inst_33272 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33395_33482 = state_33294__$1;
(statearr_33395_33482[(2)] = inst_33272);

(statearr_33395_33482[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (71))){
var inst_33261 = (state_33294[(24)]);
var inst_33264 = (state_33294[(2)]);
var inst_33265 = fluree.db.util.async.throw_err(inst_33264);
var inst_33266 = [inst_33265,r];
var inst_33267 = (new cljs.core.PersistentVector(null,2,(5),inst_33261,inst_33266,null));
var state_33294__$1 = state_33294;
var statearr_33396_33483 = state_33294__$1;
(statearr_33396_33483[(2)] = inst_33267);

(statearr_33396_33483[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (42))){
var inst_33285 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33397_33484 = state_33294__$1;
(statearr_33397_33484[(2)] = inst_33285);

(statearr_33397_33484[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (37))){
var inst_33179 = cljs.core.second(clause);
var inst_33180 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33179,"rdf:type");
var state_33294__$1 = state_33294;
var statearr_33398_33485 = state_33294__$1;
(statearr_33398_33485[(2)] = inst_33180);

(statearr_33398_33485[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (63))){
var inst_33274 = (state_33294[(2)]);
var state_33294__$1 = state_33294;
var statearr_33399_33486 = state_33294__$1;
(statearr_33399_33486[(2)] = inst_33274);

(statearr_33399_33486[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (8))){
var inst_33289 = (state_33294[(2)]);
var _ = (function (){var statearr_33400 = state_33294;
(statearr_33400[(4)] = cljs.core.rest((state_33294[(4)])));

return statearr_33400;
})();
var state_33294__$1 = state_33294;
var statearr_33401_33487 = state_33294__$1;
(statearr_33401_33487[(2)] = inst_33289);

(statearr_33401_33487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33295 === (49))){
var inst_33213 = cljs.core.count(clause);
var inst_33214 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_33213);
var state_33294__$1 = state_33294;
if(inst_33214){
var statearr_33402_33488 = state_33294__$1;
(statearr_33402_33488[(1)] = (51));

} else {
var statearr_33403_33489 = state_33294__$1;
(statearr_33403_33489[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____0 = (function (){
var statearr_33404 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33404[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__);

(statearr_33404[(1)] = (1));

return statearr_33404;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____1 = (function (state_33294){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_33294);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e33405){var ex__10753__auto__ = e33405;
var statearr_33406_33490 = state_33294;
(statearr_33406_33490[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_33294[(4)]))){
var statearr_33407_33491 = state_33294;
(statearr_33407_33491[(1)] = cljs.core.first((state_33294[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__33492 = state_33294;
state_33294 = G__33492;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__ = function(state_33294){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____1.call(this,state_33294);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_33408 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_33408[(6)] = c__10876__auto__);

return statearr_33408;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__33494 = arguments.length;
switch (G__33494) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_33574){
var state_val_33575 = (state_33574[(1)]);
if((state_val_33575 === (7))){
var inst_33569 = (state_33574[(2)]);
var _ = (function (){var statearr_33576 = state_33574;
(statearr_33576[(4)] = cljs.core.rest((state_33574[(4)])));

return statearr_33576;
})();
var state_33574__$1 = state_33574;
var statearr_33577_33625 = state_33574__$1;
(statearr_33577_33625[(2)] = inst_33569);

(statearr_33577_33625[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (20))){
var inst_33534 = (state_33574[(7)]);
var inst_33546 = (state_33574[(2)]);
var inst_33516 = inst_33534;
var inst_33517 = inst_33546;
var state_33574__$1 = (function (){var statearr_33578 = state_33574;
(statearr_33578[(8)] = inst_33517);

(statearr_33578[(9)] = inst_33516);

return statearr_33578;
})();
var statearr_33579_33626 = state_33574__$1;
(statearr_33579_33626[(2)] = null);

(statearr_33579_33626[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (1))){
var state_33574__$1 = state_33574;
var statearr_33580_33627 = state_33574__$1;
(statearr_33580_33627[(2)] = null);

(statearr_33580_33627[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (24))){
var inst_33533 = (state_33574[(10)]);
var inst_33517 = (state_33574[(8)]);
var inst_33534 = (state_33574[(7)]);
var inst_33554 = fluree.db.query.analytical.inner_join(inst_33517,inst_33533);
var inst_33516 = inst_33534;
var inst_33517__$1 = inst_33554;
var state_33574__$1 = (function (){var statearr_33581 = state_33574;
(statearr_33581[(8)] = inst_33517__$1);

(statearr_33581[(9)] = inst_33516);

return statearr_33581;
})();
var statearr_33582_33628 = state_33574__$1;
(statearr_33582_33628[(2)] = null);

(statearr_33582_33628[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (4))){
var inst_33495 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33584_33629 = state_33574__$1;
(statearr_33584_33629[(2)] = inst_33495);

(statearr_33584_33629[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (15))){
var inst_33533 = (state_33574[(10)]);
var state_33574__$1 = state_33574;
if(cljs.core.truth_(inst_33533)){
var statearr_33585_33630 = state_33574__$1;
(statearr_33585_33630[(1)] = (18));

} else {
var statearr_33586_33631 = state_33574__$1;
(statearr_33586_33631[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (21))){
var inst_33517 = (state_33574[(8)]);
var inst_33534 = (state_33574[(7)]);
var tmp33583 = inst_33517;
var inst_33516 = inst_33534;
var inst_33517__$1 = tmp33583;
var state_33574__$1 = (function (){var statearr_33587 = state_33574;
(statearr_33587[(8)] = inst_33517__$1);

(statearr_33587[(9)] = inst_33516);

return statearr_33587;
})();
var statearr_33588_33632 = state_33574__$1;
(statearr_33588_33632[(2)] = null);

(statearr_33588_33632[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (13))){
var inst_33517 = (state_33574[(8)]);
var inst_33540 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_33517,cljs.core.cst$kw$vars);
var inst_33541 = cljs.core.empty_QMARK_(inst_33540);
var state_33574__$1 = state_33574;
if(inst_33541){
var statearr_33589_33633 = state_33574__$1;
(statearr_33589_33633[(1)] = (15));

} else {
var statearr_33590_33634 = state_33574__$1;
(statearr_33590_33634[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (22))){
var state_33574__$1 = state_33574;
var statearr_33591_33635 = state_33574__$1;
(statearr_33591_33635[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (6))){
var inst_33523 = (state_33574[(11)]);
var inst_33516 = (state_33574[(9)]);
var inst_33522 = cljs.core.seq(inst_33516);
var inst_33523__$1 = cljs.core.first(inst_33522);
var inst_33524 = cljs.core.next(inst_33522);
var state_33574__$1 = (function (){var statearr_33593 = state_33574;
(statearr_33593[(12)] = inst_33524);

(statearr_33593[(11)] = inst_33523__$1);

return statearr_33593;
})();
if(cljs.core.truth_(inst_33523__$1)){
var statearr_33594_33636 = state_33574__$1;
(statearr_33594_33636[(1)] = (8));

} else {
var statearr_33595_33637 = state_33574__$1;
(statearr_33595_33637[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (25))){
var state_33574__$1 = state_33574;
var statearr_33596_33638 = state_33574__$1;
(statearr_33596_33638[(2)] = null);

(statearr_33596_33638[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (17))){
var inst_33562 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33597_33639 = state_33574__$1;
(statearr_33597_33639[(2)] = inst_33562);

(statearr_33597_33639[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (3))){
var inst_33572 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33574__$1,inst_33572);
} else {
if((state_val_33575 === (12))){
var inst_33533 = (state_33574[(10)]);
var inst_33534 = (state_33574[(7)]);
var inst_33516 = inst_33534;
var inst_33517 = inst_33533;
var state_33574__$1 = (function (){var statearr_33598 = state_33574;
(statearr_33598[(8)] = inst_33517);

(statearr_33598[(9)] = inst_33516);

return statearr_33598;
})();
var statearr_33599_33640 = state_33574__$1;
(statearr_33599_33640[(2)] = null);

(statearr_33599_33640[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (2))){
var _ = (function (){var statearr_33600 = state_33574;
(statearr_33600[(4)] = cljs.core.cons((5),(state_33574[(4)])));

return statearr_33600;
})();
var inst_33508 = where;
var inst_33509 = cljs.core.seq(inst_33508);
var inst_33510 = cljs.core.first(inst_33509);
var inst_33511 = cljs.core.next(inst_33509);
var inst_33512 = [cljs.core.cst$kw$vars];
var inst_33513 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_33514 = [inst_33513];
var inst_33515 = cljs.core.PersistentHashMap.fromArrays(inst_33512,inst_33514);
var inst_33516 = inst_33508;
var inst_33517 = inst_33515;
var state_33574__$1 = (function (){var statearr_33601 = state_33574;
(statearr_33601[(13)] = inst_33511);

(statearr_33601[(14)] = inst_33510);

(statearr_33601[(8)] = inst_33517);

(statearr_33601[(9)] = inst_33516);

return statearr_33601;
})();
var statearr_33602_33641 = state_33574__$1;
(statearr_33602_33641[(2)] = null);

(statearr_33602_33641[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (23))){
var inst_33560 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33603_33642 = state_33574__$1;
(statearr_33603_33642[(2)] = inst_33560);

(statearr_33603_33642[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (19))){
var inst_33517 = (state_33574[(8)]);
var state_33574__$1 = state_33574;
var statearr_33604_33643 = state_33574__$1;
(statearr_33604_33643[(2)] = inst_33517);

(statearr_33604_33643[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (11))){
var inst_33523 = (state_33574[(11)]);
var inst_33531 = (state_33574[(2)]);
var inst_33532 = fluree.db.util.async.throw_err(inst_33531);
var inst_33533 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33532,(0),null);
var inst_33534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_33532,(1),null);
var inst_33535 = cljs.core.count(inst_33523);
var inst_33536 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_33535);
var state_33574__$1 = (function (){var statearr_33606 = state_33574;
(statearr_33606[(10)] = inst_33533);

(statearr_33606[(7)] = inst_33534);

return statearr_33606;
})();
if(inst_33536){
var statearr_33607_33644 = state_33574__$1;
(statearr_33607_33644[(1)] = (12));

} else {
var statearr_33608_33645 = state_33574__$1;
(statearr_33608_33645[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (9))){
var inst_33517 = (state_33574[(8)]);
var state_33574__$1 = state_33574;
var statearr_33609_33646 = state_33574__$1;
(statearr_33609_33646[(2)] = inst_33517);

(statearr_33609_33646[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (5))){
var _ = (function (){var statearr_33610 = state_33574;
(statearr_33610[(4)] = cljs.core.rest((state_33574[(4)])));

return statearr_33610;
})();
var state_33574__$1 = state_33574;
var ex33605 = (state_33574__$1[(2)]);
var statearr_33611_33647 = state_33574__$1;
(statearr_33611_33647[(5)] = ex33605);


if((ex33605 instanceof Error)){
var statearr_33612_33648 = state_33574__$1;
(statearr_33612_33648[(1)] = (4));

(statearr_33612_33648[(5)] = null);

} else {
throw ex33605;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (14))){
var inst_33564 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33613_33649 = state_33574__$1;
(statearr_33613_33649[(2)] = inst_33564);

(statearr_33613_33649[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (26))){
var inst_33558 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33614_33650 = state_33574__$1;
(statearr_33614_33650[(2)] = inst_33558);

(statearr_33614_33650[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (16))){
var inst_33533 = (state_33574[(10)]);
var inst_33549 = (inst_33533 == null);
var state_33574__$1 = state_33574;
if(cljs.core.truth_(inst_33549)){
var statearr_33615_33651 = state_33574__$1;
(statearr_33615_33651[(1)] = (21));

} else {
var statearr_33616_33652 = state_33574__$1;
(statearr_33616_33652[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (10))){
var inst_33567 = (state_33574[(2)]);
var state_33574__$1 = state_33574;
var statearr_33617_33653 = state_33574__$1;
(statearr_33617_33653[(2)] = inst_33567);

(statearr_33617_33653[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (18))){
var inst_33533 = (state_33574[(10)]);
var state_33574__$1 = state_33574;
var statearr_33618_33654 = state_33574__$1;
(statearr_33618_33654[(2)] = inst_33533);

(statearr_33618_33654[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33575 === (8))){
var inst_33524 = (state_33574[(12)]);
var inst_33523 = (state_33574[(11)]);
var inst_33517 = (state_33574[(8)]);
var inst_33529 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_33517,inst_33523,inst_33524,false,fuel,max_fuel,opts);
var state_33574__$1 = state_33574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33574__$1,(11),inst_33529);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__10750__auto__ = null;
var fluree$db$query$analytical$state_machine__10750__auto____0 = (function (){
var statearr_33619 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33619[(0)] = fluree$db$query$analytical$state_machine__10750__auto__);

(statearr_33619[(1)] = (1));

return statearr_33619;
});
var fluree$db$query$analytical$state_machine__10750__auto____1 = (function (state_33574){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_33574);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e33620){var ex__10753__auto__ = e33620;
var statearr_33621_33655 = state_33574;
(statearr_33621_33655[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_33574[(4)]))){
var statearr_33622_33656 = state_33574;
(statearr_33622_33656[(1)] = cljs.core.first((state_33574[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__33657 = state_33574;
state_33574 = G__33657;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__10750__auto__ = function(state_33574){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__10750__auto____1.call(this,state_33574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__10750__auto____0;
fluree$db$query$analytical$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__10750__auto____1;
return fluree$db$query$analytical$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_33623 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_33623[(6)] = c__10876__auto__);

return statearr_33623;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_33692){
var state_val_33693 = (state_33692[(1)]);
if((state_val_33693 === (7))){
var inst_33669 = (state_33692[(7)]);
var inst_33674 = (state_33692[(8)]);
var inst_33676 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_33669,inst_33674,fuel,max_fuel,opts);
var state_33692__$1 = state_33692;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33692__$1,(10),inst_33676);
} else {
if((state_val_33693 === (1))){
var state_33692__$1 = state_33692;
var statearr_33694_33719 = state_33692__$1;
(statearr_33694_33719[(2)] = null);

(statearr_33694_33719[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (4))){
var inst_33658 = (state_33692[(2)]);
var state_33692__$1 = state_33692;
var statearr_33695_33720 = state_33692__$1;
(statearr_33695_33720[(2)] = inst_33658);

(statearr_33695_33720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (13))){
var inst_33687 = (state_33692[(2)]);
var _ = (function (){var statearr_33696 = state_33692;
(statearr_33696[(4)] = cljs.core.rest((state_33692[(4)])));

return statearr_33696;
})();
var state_33692__$1 = state_33692;
var statearr_33697_33721 = state_33692__$1;
(statearr_33697_33721[(2)] = inst_33687);

(statearr_33697_33721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (6))){
var inst_33669 = (state_33692[(7)]);
var inst_33673 = (state_33692[(2)]);
var inst_33674 = fluree.db.util.async.throw_err(inst_33673);
var state_33692__$1 = (function (){var statearr_33698 = state_33692;
(statearr_33698[(8)] = inst_33674);

return statearr_33698;
})();
if(cljs.core.truth_(inst_33669)){
var statearr_33699_33722 = state_33692__$1;
(statearr_33699_33722[(1)] = (7));

} else {
var statearr_33700_33723 = state_33692__$1;
(statearr_33700_33723[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (3))){
var inst_33690 = (state_33692[(2)]);
var state_33692__$1 = state_33692;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33692__$1,inst_33690);
} else {
if((state_val_33693 === (12))){
var inst_33682 = (state_33692[(9)]);
var state_33692__$1 = state_33692;
var statearr_33701_33724 = state_33692__$1;
(statearr_33701_33724[(2)] = inst_33682);

(statearr_33701_33724[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (2))){
var _ = (function (){var statearr_33702 = state_33692;
(statearr_33702[(4)] = cljs.core.cons((5),(state_33692[(4)])));

return statearr_33702;
})();
var inst_33665 = q_map;
var inst_33666 = cljs.core.__destructure_map(inst_33665);
var inst_33667 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33666,cljs.core.cst$kw$vars);
var inst_33668 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33666,cljs.core.cst$kw$where);
var inst_33669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33666,cljs.core.cst$kw$optional);
var inst_33670 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33666,cljs.core.cst$kw$filter);
var inst_33671 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_33668,q_map,inst_33667,fuel,max_fuel,opts);
var state_33692__$1 = (function (){var statearr_33703 = state_33692;
(statearr_33703[(7)] = inst_33669);

(statearr_33703[(10)] = inst_33670);

return statearr_33703;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33692__$1,(6),inst_33671);
} else {
if((state_val_33693 === (11))){
var inst_33682 = (state_33692[(9)]);
var inst_33670 = (state_33692[(10)]);
var inst_33684 = fluree.db.query.analytical.tuples__GT_filtered(inst_33682,inst_33670,null);
var state_33692__$1 = state_33692;
var statearr_33705_33725 = state_33692__$1;
(statearr_33705_33725[(2)] = inst_33684);

(statearr_33705_33725[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (9))){
var inst_33670 = (state_33692[(10)]);
var inst_33682 = (state_33692[(2)]);
var state_33692__$1 = (function (){var statearr_33706 = state_33692;
(statearr_33706[(9)] = inst_33682);

return statearr_33706;
})();
if(cljs.core.truth_(inst_33670)){
var statearr_33707_33726 = state_33692__$1;
(statearr_33707_33726[(1)] = (11));

} else {
var statearr_33708_33727 = state_33692__$1;
(statearr_33708_33727[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (5))){
var _ = (function (){var statearr_33709 = state_33692;
(statearr_33709[(4)] = cljs.core.rest((state_33692[(4)])));

return statearr_33709;
})();
var state_33692__$1 = state_33692;
var ex33704 = (state_33692__$1[(2)]);
var statearr_33710_33728 = state_33692__$1;
(statearr_33710_33728[(5)] = ex33704);


if((ex33704 instanceof Error)){
var statearr_33711_33729 = state_33692__$1;
(statearr_33711_33729[(1)] = (4));

(statearr_33711_33729[(5)] = null);

} else {
throw ex33704;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (10))){
var inst_33678 = (state_33692[(2)]);
var inst_33679 = fluree.db.util.async.throw_err(inst_33678);
var state_33692__$1 = state_33692;
var statearr_33712_33730 = state_33692__$1;
(statearr_33712_33730[(2)] = inst_33679);

(statearr_33712_33730[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33693 === (8))){
var inst_33674 = (state_33692[(8)]);
var state_33692__$1 = state_33692;
var statearr_33713_33731 = state_33692__$1;
(statearr_33713_33731[(2)] = inst_33674);

(statearr_33713_33731[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__10750__auto____0 = (function (){
var statearr_33714 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33714[(0)] = fluree$db$query$analytical$q_$_state_machine__10750__auto__);

(statearr_33714[(1)] = (1));

return statearr_33714;
});
var fluree$db$query$analytical$q_$_state_machine__10750__auto____1 = (function (state_33692){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_33692);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e33715){var ex__10753__auto__ = e33715;
var statearr_33716_33732 = state_33692;
(statearr_33716_33732[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_33692[(4)]))){
var statearr_33717_33733 = state_33692;
(statearr_33717_33733[(1)] = cljs.core.first((state_33692[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__33734 = state_33692;
state_33692 = G__33734;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__10750__auto__ = function(state_33692){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__10750__auto____1.call(this,state_33692);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__10750__auto____0;
fluree$db$query$analytical$q_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__10750__auto____1;
return fluree$db$query$analytical$q_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_33718 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_33718[(6)] = c__10876__auto__);

return statearr_33718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
