// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical_wikidata');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
fluree.db.query.analytical_wikidata.variable_QMARK_ = (function fluree$db$query$analytical_wikidata$variable_QMARK_(form){
if(((((typeof form === 'string') || ((form instanceof cljs.core.Symbol)))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
/**
 * Takes replacement vars, retrieves values from ctx, and puts into Wikidata VALUES statement,
 *   i.e. VALUES (?name ?countryName) {("Vincent van Gogh" "Kingdom of the Netherlands") ("Edvard Munch" "Norway")}
 */
fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt = (function fluree$db$query$analytical_wikidata$replacementVars__GT_ValuesSmt(vars,values){
var value_groups = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (value_group){
var stringified = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31760_SHARP_){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31760_SHARP_),"\""].join('');
}),value_group);
var joined_group = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",stringified);
return [" ( ",joined_group," ) "].join('');
}),values);
var value_group_str = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",value_groups);
return ["VALUES ( ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",vars)," ) { ",value_group_str," } "].join('');
});
fluree.db.query.analytical_wikidata.get_next_wd_clauses = (function fluree$db$query$analytical_wikidata$get_next_wd_clauses(coll){
var G__31764 = coll;
var vec__31765 = G__31764;
var seq__31766 = cljs.core.seq(vec__31765);
var first__31767 = cljs.core.first(seq__31766);
var seq__31766__$1 = cljs.core.next(seq__31766);
var clause = first__31767;
var r = seq__31766__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31764__$1 = G__31764;
var res__$1 = res;
while(true){
var vec__31771 = G__31764__$1;
var seq__31772 = cljs.core.seq(vec__31771);
var first__31773 = cljs.core.first(seq__31772);
var seq__31772__$1 = cljs.core.next(seq__31772);
var clause__$1 = first__31773;
var r__$1 = seq__31772__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31774 = r__$1;
var G__31775 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31764__$1 = G__31774;
res__$1 = G__31775;
continue;
} else {
return res__$2;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_optional_clauses(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res,p__31776){
var map__31777 = p__31776;
var map__31777__$1 = cljs.core.__destructure_map(map__31777);
var optional = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31777__$1,cljs.core.cst$kw$optional);
if(cljs.core.truth_(optional)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(res,optional);
} else {
return res;
}
}),cljs.core.PersistentVector.EMPTY,coll);
});
fluree.db.query.analytical_wikidata.get_all_wd_clauses = (function fluree$db$query$analytical_wikidata$get_all_wd_clauses(coll){
var G__31781 = coll;
var vec__31782 = G__31781;
var seq__31783 = cljs.core.seq(vec__31782);
var first__31784 = cljs.core.first(seq__31783);
var seq__31783__$1 = cljs.core.next(seq__31783);
var clause = first__31784;
var r = seq__31783__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31781__$1 = G__31781;
var res__$1 = res;
while(true){
var vec__31788 = G__31781__$1;
var seq__31789 = cljs.core.seq(vec__31788);
var first__31790 = cljs.core.first(seq__31789);
var seq__31789__$1 = cljs.core.next(seq__31789);
var clause__$1 = first__31790;
var r__$1 = seq__31789__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31791 = r__$1;
var G__31792 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,cljs.core.rest(clause__$1));
G__31781__$1 = G__31791;
res__$1 = G__31792;
continue;
} else {
var G__31793 = r__$1;
var G__31794 = res__$2;
G__31781__$1 = G__31793;
res__$1 = G__31794;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.drop_all_wd_clauses = (function fluree$db$query$analytical_wikidata$drop_all_wd_clauses(coll){
var G__31798 = coll;
var vec__31799 = G__31798;
var seq__31800 = cljs.core.seq(vec__31799);
var first__31801 = cljs.core.first(seq__31800);
var seq__31800__$1 = cljs.core.next(seq__31800);
var clause = first__31801;
var r = seq__31800__$1;
var res = cljs.core.PersistentVector.EMPTY;
var G__31798__$1 = G__31798;
var res__$1 = res;
while(true){
var vec__31805 = G__31798__$1;
var seq__31806 = cljs.core.seq(vec__31805);
var first__31807 = cljs.core.first(seq__31806);
var seq__31806__$1 = cljs.core.next(seq__31806);
var clause__$1 = first__31807;
var r__$1 = seq__31806__$1;
var res__$2 = res__$1;
if(cljs.core.truth_(clause__$1)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause__$1))){
var G__31808 = r__$1;
var G__31809 = res__$2;
G__31798__$1 = G__31808;
res__$1 = G__31809;
continue;
} else {
var G__31810 = r__$1;
var G__31811 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(res__$2,clause__$1);
G__31798__$1 = G__31810;
res__$1 = G__31811;
continue;
}
} else {
return res__$2;
}
break;
}
});
fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_ = (function fluree$db$query$analytical_wikidata$wikiDataVar_QMARK_(string){
if(cljs.core.truth_((function (){var and__4210__auto__ = typeof string === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^wd(t)*:(P|Q)\d+$/,string);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(string);
} else {
if(typeof string === 'string'){
return ["\"",string,"\""].join('');
} else {
return string;

}
}
});
fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata = (function fluree$db$query$analytical_wikidata$ad_hoc_clause_to_wikidata(clause,optional_QMARK_){
var G__31814 = clause;
var G__31814__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",cljs.core.first(clause)))?cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),G__31814):G__31814);
var G__31814__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical_wikidata.wikiDataVar_QMARK_,G__31814__$1)
;
var G__31814__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",G__31814__$2)
;
var G__31814__$4 = (function (){var fexpr__31815 = (function (p1__31812_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31812_SHARP_)," ."].join('');
});
return fexpr__31815(G__31814__$3);
})()
;
if(cljs.core.truth_(optional_QMARK_)){
var fexpr__31816 = (function (p1__31813_SHARP_){
return ["OPTIONAL {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31813_SHARP_),"}"].join('');
});
return fexpr__31816(G__31814__$4);
} else {
return G__31814__$4;
}
});
fluree.db.query.analytical_wikidata.parse_prefixes = (function fluree$db$query$analytical_wikidata$parse_prefixes(prefixes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc_str,prefix){
var pfx = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([fluree.db.util.core.keyword__GT_str(cljs.core.key(prefix)),":"].join(''));
var source = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.val(prefix));
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(acc_str)," PREFIX ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pfx)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(source)," \n "].join('');
}),"",prefixes);
});
fluree.db.query.analytical_wikidata.generateWikiDataQuery = (function fluree$db$query$analytical_wikidata$generateWikiDataQuery(q_map,clauses,select_vars,value_clause,optional_clauses){
var opts = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$limit,(100),cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$distinct,false,cljs.core.cst$kw$language,"en"], null),cljs.core.cst$kw$wikidataOpts.cljs$core$IFn$_invoke$arity$1(q_map),cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$wikidataOpts], null),q_map)], 0));
var map__31820 = opts;
var map__31820__$1 = cljs.core.__destructure_map(map__31820);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31820__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31820__$1,cljs.core.cst$kw$offset);
var distinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31820__$1,cljs.core.cst$kw$distinct);
var language = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31820__$1,cljs.core.cst$kw$language);
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31820__$1,cljs.core.cst$kw$prefixes);
var prefixes__$1 = (cljs.core.truth_(prefixes)?fluree.db.query.analytical_wikidata.parse_prefixes(prefixes):null);
var select_smt = ["SELECT ",(cljs.core.truth_(distinct)?"DISTINCT ":null)," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31817_SHARP_){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31817_SHARP_),"Label"].join('');
}),select_vars))," ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",select_vars)].join('');
var where_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31818_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31818_SHARP_,false);
}),clauses));
var optional_smt = clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__31819_SHARP_){
return fluree.db.query.analytical_wikidata.ad_hoc_clause_to_wikidata(p1__31819_SHARP_,true);
}),optional_clauses));
var serviceLabel = ["SERVICE wikibase:label { bd:serviceParam wikibase:language \"",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var or__4212__auto__ = language;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "en";
}
})()),"\" . }"].join('');
var full_query = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(prefixes__$1)," ",select_smt," WHERE { ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(value_clause)," ",where_smt," ",optional_smt," ",serviceLabel," } ",(cljs.core.truth_(limit)?["\n                          LIMIT ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(limit)].join(''):null)," OFFSET ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(offset)].join('');
return full_query;
});
fluree.db.query.analytical_wikidata.wikidataURL = "https://query.wikidata.org/bigdata/namespace/wdq/sparql?format=json&query=";
fluree.db.query.analytical_wikidata.submit_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_wikidata_query(query){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_31834){
var state_val_31835 = (state_31834[(1)]);
if((state_val_31835 === (1))){
var inst_31821 = fluree.db.util.core.url_encode(query);
var inst_31822 = [fluree.db.query.analytical_wikidata.wikidataURL,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31821)].join('');
var inst_31823 = ["User-Agent","Accept"];
var inst_31824 = ["Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36","application/sparql-results+json"];
var inst_31825 = cljs.core.PersistentHashMap.fromArrays(inst_31823,inst_31824);
var inst_31826 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$output_DASH_format];
var inst_31827 = [inst_31825,(30000),cljs.core.cst$kw$wikidata];
var inst_31828 = cljs.core.PersistentHashMap.fromArrays(inst_31826,inst_31827);
var inst_31829 = fluree.db.util.xhttp.get(inst_31822,inst_31828);
var state_31834__$1 = state_31834;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31834__$1,(2),inst_31829);
} else {
if((state_val_31835 === (2))){
var inst_31831 = (state_31834[(2)]);
var inst_31832 = fluree.db.util.async.throw_err(inst_31831);
var state_31834__$1 = state_31834;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31834__$1,inst_31832);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____0 = (function (){
var statearr_31836 = [null,null,null,null,null,null,null];
(statearr_31836[(0)] = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__);

(statearr_31836[(1)] = (1));

return statearr_31836;
});
var fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____1 = (function (state_31834){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_31834);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e31837){var ex__10753__auto__ = e31837;
var statearr_31838_31841 = state_31834;
(statearr_31838_31841[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_31834[(4)]))){
var statearr_31839_31842 = state_31834;
(statearr_31839_31842[(1)] = cljs.core.first((state_31834[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__31843 = state_31834;
state_31834 = G__31843;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__ = function(state_31834){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____1.call(this,state_31834);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____0;
fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto____1;
return fluree$db$query$analytical_wikidata$submit_wikidata_query_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_31840 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_31840[(6)] = c__10876__auto__);

return statearr_31840;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query = (function fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query(query){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_31861){
var state_val_31862 = (state_31861[(1)]);
if((state_val_31862 === (1))){
var inst_31844 = fluree.db.query.analytical_wikidata.submit_wikidata_query(query);
var state_31861__$1 = state_31861;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31861__$1,(2),inst_31844);
} else {
if((state_val_31862 === (2))){
var inst_31847 = (state_31861[(7)]);
var inst_31846 = (state_31861[(2)]);
var inst_31847__$1 = fluree.db.util.async.throw_err(inst_31846);
var inst_31848 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_31847__$1);
var inst_31849 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((200),inst_31848);
var state_31861__$1 = (function (){var statearr_31863 = state_31861;
(statearr_31863[(7)] = inst_31847__$1);

return statearr_31863;
})();
if(inst_31849){
var statearr_31864_31873 = state_31861__$1;
(statearr_31864_31873[(1)] = (3));

} else {
var statearr_31865_31874 = state_31861__$1;
(statearr_31865_31874[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31862 === (3))){
var inst_31847 = (state_31861[(7)]);
var state_31861__$1 = state_31861;
var statearr_31866_31875 = state_31861__$1;
(statearr_31866_31875[(2)] = inst_31847);

(statearr_31866_31875[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31862 === (4))){
var inst_31847 = (state_31861[(7)]);
var inst_31852 = (function (){var body = inst_31847;
return (function (item){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,k_v){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.key(k_v),cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1(cljs.core.val(k_v)));
}),cljs.core.PersistentArrayMap.EMPTY,item);
});
})();
var inst_31853 = cljs.core.second(inst_31847);
var inst_31854 = cljs.core.second(inst_31853);
var inst_31855 = cljs.core.first(inst_31854);
var inst_31856 = cljs.core.second(inst_31855);
var inst_31857 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_31852,inst_31856);
var state_31861__$1 = state_31861;
var statearr_31867_31876 = state_31861__$1;
(statearr_31867_31876[(2)] = inst_31857);

(statearr_31867_31876[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31862 === (5))){
var inst_31859 = (state_31861[(2)]);
var state_31861__$1 = state_31861;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31861__$1,inst_31859);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____0 = (function (){
var statearr_31868 = [null,null,null,null,null,null,null,null];
(statearr_31868[(0)] = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__);

(statearr_31868[(1)] = (1));

return statearr_31868;
});
var fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____1 = (function (state_31861){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_31861);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e31869){var ex__10753__auto__ = e31869;
var statearr_31870_31877 = state_31861;
(statearr_31870_31877[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_31861[(4)]))){
var statearr_31871_31878 = state_31861;
(statearr_31871_31878[(1)] = cljs.core.first((state_31861[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__31879 = state_31861;
state_31861 = G__31879;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__ = function(state_31861){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____1.call(this,state_31861);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____0;
fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto____1;
return fluree$db$query$analytical_wikidata$submit_PLUS_parse_wikidata_query_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_31872 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_31872[(6)] = c__10876__auto__);

return statearr_31872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples = (function fluree$db$query$analytical_wikidata$wikiDataResp__GT_tuples(wikidataRes,vars){
var labelVars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31880_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31880_SHARP_),"Label"].join(''));
}),vars);
var headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,vars),labelVars);
var headers_as_kws = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31881_SHARP_){
return fluree.db.util.core.str__GT_keyword(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__31881_SHARP_),(1)));
}),headers);
var results = cljs.core.cst$kw$bindings.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$results.cljs$core$IFn$_invoke$arity$1(wikidataRes));
var tuples = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__31882_SHARP_){
return cljs.core.cst$kw$value.cljs$core$IFn$_invoke$arity$1((p1__31882_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__31882_SHARP_.cljs$core$IFn$_invoke$arity$1(res) : p1__31882_SHARP_.call(null,res)));
}),headers_as_kws);
}),results);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$tuples,tuples], null);
});
fluree.db.query.analytical_wikidata.get_wikidata_tuples = (function fluree$db$query$analytical_wikidata$get_wikidata_tuples(q_map,clauses,matching_vars,matching_vals,all_vars,optional_clauses){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_31928){
var state_val_31929 = (state_31928[(1)]);
if((state_val_31929 === (7))){
var inst_31893 = fluree.db.query.analytical_wikidata.replacementVars__GT_ValuesSmt(matching_vars,matching_vals);
var state_31928__$1 = state_31928;
var statearr_31930_31958 = state_31928__$1;
(statearr_31930_31958[(2)] = inst_31893);

(statearr_31930_31958[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (1))){
var state_31928__$1 = state_31928;
var statearr_31931_31959 = state_31928__$1;
(statearr_31931_31959[(2)] = null);

(statearr_31931_31959[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (4))){
var inst_31883 = (state_31928[(2)]);
var state_31928__$1 = state_31928;
var statearr_31932_31960 = state_31928__$1;
(statearr_31932_31960[(2)] = inst_31883);

(statearr_31932_31960[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (15))){
var inst_31902 = (state_31928[(7)]);
var inst_31907 = (state_31928[(8)]);
var inst_31901 = (state_31928[(9)]);
var inst_31912 = (state_31928[(2)]);
var inst_31913 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(inst_31907,(0),inst_31912);
var inst_31914 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31915 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_31901);
var inst_31916 = [inst_31902,inst_31915];
var inst_31917 = cljs.core.PersistentHashMap.fromArrays(inst_31914,inst_31916);
var inst_31918 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31913,inst_31917);
var inst_31919 = (function(){throw inst_31918})();
var state_31928__$1 = state_31928;
var statearr_31933_31961 = state_31928__$1;
(statearr_31933_31961[(2)] = inst_31919);

(statearr_31933_31961[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (13))){
var inst_31906 = (state_31928[(10)]);
var state_31928__$1 = state_31928;
var statearr_31934_31962 = state_31928__$1;
(statearr_31934_31962[(2)] = inst_31906);

(statearr_31934_31962[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (6))){
var state_31928__$1 = state_31928;
var statearr_31935_31963 = state_31928__$1;
(statearr_31935_31963[(2)] = null);

(statearr_31935_31963[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (3))){
var inst_31926 = (state_31928[(2)]);
var state_31928__$1 = state_31928;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31928__$1,inst_31926);
} else {
if((state_val_31929 === (12))){
var inst_31923 = (state_31928[(2)]);
var _ = (function (){var statearr_31936 = state_31928;
(statearr_31936[(4)] = cljs.core.rest((state_31928[(4)])));

return statearr_31936;
})();
var state_31928__$1 = state_31928;
var statearr_31937_31964 = state_31928__$1;
(statearr_31937_31964[(2)] = inst_31923);

(statearr_31937_31964[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (2))){
var _ = (function (){var statearr_31938 = state_31928;
(statearr_31938[(4)] = cljs.core.cons((5),(state_31928[(4)])));

return statearr_31938;
})();
var inst_31890 = cljs.core.empty_QMARK_(matching_vars);
var state_31928__$1 = state_31928;
if(inst_31890){
var statearr_31939_31965 = state_31928__$1;
(statearr_31939_31965[(1)] = (6));

} else {
var statearr_31940_31966 = state_31928__$1;
(statearr_31940_31966[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (11))){
var inst_31901 = (state_31928[(9)]);
var inst_31921 = fluree.db.query.analytical_wikidata.wikiDataResp__GT_tuples(inst_31901,all_vars);
var state_31928__$1 = state_31928;
var statearr_31942_31967 = state_31928__$1;
(statearr_31942_31967[(2)] = inst_31921);

(statearr_31942_31967[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (9))){
var inst_31902 = (state_31928[(7)]);
var inst_31901 = (state_31928[(9)]);
var inst_31899 = (state_31928[(2)]);
var inst_31900 = fluree.db.util.async.throw_err(inst_31899);
var inst_31901__$1 = cljs.core.__destructure_map(inst_31900);
var inst_31902__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31901__$1,cljs.core.cst$kw$status);
var inst_31903 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31901__$1,cljs.core.cst$kw$message);
var inst_31904 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((400),inst_31902__$1);
var state_31928__$1 = (function (){var statearr_31943 = state_31928;
(statearr_31943[(11)] = inst_31903);

(statearr_31943[(7)] = inst_31902__$1);

(statearr_31943[(9)] = inst_31901__$1);

return statearr_31943;
})();
if(inst_31904){
var statearr_31944_31968 = state_31928__$1;
(statearr_31944_31968[(1)] = (10));

} else {
var statearr_31945_31969 = state_31928__$1;
(statearr_31945_31969[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (5))){
var _ = (function (){var statearr_31946 = state_31928;
(statearr_31946[(4)] = cljs.core.rest((state_31928[(4)])));

return statearr_31946;
})();
var state_31928__$1 = state_31928;
var ex31941 = (state_31928__$1[(2)]);
var statearr_31947_31970 = state_31928__$1;
(statearr_31947_31970[(5)] = ex31941);


if((ex31941 instanceof Error)){
var statearr_31948_31971 = state_31928__$1;
(statearr_31948_31971[(1)] = (4));

(statearr_31948_31971[(5)] = null);

} else {
throw ex31941;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (14))){
var state_31928__$1 = state_31928;
var statearr_31949_31972 = state_31928__$1;
(statearr_31949_31972[(2)] = (1000));

(statearr_31949_31972[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (10))){
var inst_31903 = (state_31928[(11)]);
var inst_31906 = (state_31928[(10)]);
var inst_31901 = (state_31928[(9)]);
var inst_31906__$1 = cljs.core.count(inst_31903);
var inst_31907 = cljs.core.cst$kw$message.cljs$core$IFn$_invoke$arity$1(inst_31901);
var inst_31908 = (inst_31906__$1 < (1000));
var state_31928__$1 = (function (){var statearr_31950 = state_31928;
(statearr_31950[(8)] = inst_31907);

(statearr_31950[(10)] = inst_31906__$1);

return statearr_31950;
})();
if(cljs.core.truth_(inst_31908)){
var statearr_31951_31973 = state_31928__$1;
(statearr_31951_31973[(1)] = (13));

} else {
var statearr_31952_31974 = state_31928__$1;
(statearr_31952_31974[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31929 === (8))){
var inst_31895 = (state_31928[(2)]);
var inst_31896 = fluree.db.query.analytical_wikidata.generateWikiDataQuery(q_map,clauses,all_vars,inst_31895,optional_clauses);
var inst_31897 = fluree.db.query.analytical_wikidata.submit_PLUS_parse_wikidata_query(inst_31896);
var state_31928__$1 = state_31928;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31928__$1,(9),inst_31897);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__ = null;
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____0 = (function (){
var statearr_31953 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31953[(0)] = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__);

(statearr_31953[(1)] = (1));

return statearr_31953;
});
var fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____1 = (function (state_31928){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_31928);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e31954){var ex__10753__auto__ = e31954;
var statearr_31955_31975 = state_31928;
(statearr_31955_31975[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_31928[(4)]))){
var statearr_31956_31976 = state_31928;
(statearr_31956_31976[(1)] = cljs.core.first((state_31928[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__31977 = state_31928;
state_31928 = G__31977;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__ = function(state_31928){
switch(arguments.length){
case 0:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____1.call(this,state_31928);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____0;
fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto____1;
return fluree$db$query$analytical_wikidata$get_wikidata_tuples_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_31957 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_31957[(6)] = c__10876__auto__);

return statearr_31957;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
