// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__33934 = arguments.length;
switch (G__33934) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__33935 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__33935) : f.call(null,G__33935));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__33936 = cljs.core._deref(vol);
var G__33937 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__33936,G__33937) : f.call(null,G__33936,G__33937));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__33938 = cljs.core._deref(vol);
var G__33939 = arg1;
var G__33940 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__33938,G__33939,G__33940) : f.call(null,G__33938,G__33939,G__33940));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__33941 = cljs.core._deref(vol);
var G__33942 = arg1;
var G__33943 = arg2;
var G__33944 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__33941,G__33942,G__33943,G__33944) : f.call(null,G__33941,G__33942,G__33943,G__33944));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__33947 = arguments.length;
switch (G__33947) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__33949 = null;
var G__33949__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33949__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33949__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__33949 = function(result,flake){
switch(arguments.length){
case 0:
return G__33949__0.call(this);
case 1:
return G__33949__1.call(this,result);
case 2:
return G__33949__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33949.cljs$core$IFn$_invoke$arity$0 = G__33949__0;
G__33949.cljs$core$IFn$_invoke$arity$1 = G__33949__1;
G__33949.cljs$core$IFn$_invoke$arity$2 = G__33949__2;
return G__33949;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__33950 = null;
var G__33950__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__33950__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__33950__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__33950 = function(result,flakes){
switch(arguments.length){
case 0:
return G__33950__0.call(this);
case 1:
return G__33950__1.call(this,result);
case 2:
return G__33950__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__33950.cljs$core$IFn$_invoke$arity$0 = G__33950__0;
G__33950.cljs$core$IFn$_invoke$arity$1 = G__33950__1;
G__33950.cljs$core$IFn$_invoke$arity$2 = G__33950__2;
return G__33950;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__33952 = res;
var G__33952__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__33951_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__33951_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__33952):G__33952);
var G__33952__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__33952__$1):G__33952__$1);
var G__33952__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__33952__$2):G__33952__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__33952__$3);
} else {
return G__33952__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__33956 = arguments.length;
switch (G__33956) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_34328){
var state_val_34329 = (state_34328[(1)]);
if((state_val_34329 === (65))){
var inst_34110 = (state_34328[(2)]);
var inst_34111 = fluree.db.util.async.throw_err(inst_34110);
var state_34328__$1 = (function (){var statearr_34330 = state_34328;
(statearr_34330[(7)] = inst_34111);

return statearr_34330;
})();
if(cljs.core.truth_(fuel)){
var statearr_34331_34516 = state_34328__$1;
(statearr_34331_34516[(1)] = (66));

} else {
var statearr_34332_34517 = state_34328__$1;
(statearr_34332_34517[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (70))){
var inst_34134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34142 = flakes;
var inst_34143 = cljs.core.seq(inst_34142);
var inst_34144 = cljs.core.first(inst_34143);
var inst_34145 = cljs.core.next(inst_34143);
var inst_34146 = cljs.core.PersistentVector.EMPTY;
var inst_34147 = inst_34142;
var inst_34148 = inst_34146;
var state_34328__$1 = (function (){var statearr_34333 = state_34328;
(statearr_34333[(8)] = inst_34145);

(statearr_34333[(9)] = inst_34147);

(statearr_34333[(10)] = inst_34144);

(statearr_34333[(11)] = inst_34148);

(statearr_34333[(12)] = inst_34134);

return statearr_34333;
})();
var statearr_34334_34518 = state_34328__$1;
(statearr_34334_34518[(2)] = null);

(statearr_34334_34518[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (62))){
var inst_34101 = (state_34328[(13)]);
var inst_34104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34105 = inst_34101.o;
var inst_34106 = [inst_34105];
var inst_34107 = (new cljs.core.PersistentVector(null,1,(5),inst_34104,inst_34106,null));
var inst_34108 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34107);
var state_34328__$1 = state_34328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34328__$1,(65),inst_34108);
} else {
if((state_val_34329 === (74))){
var inst_34134 = (state_34328[(12)]);
var inst_34190 = (state_34328[(2)]);
var inst_34191 = [inst_34190,offset_map];
var inst_34192 = (new cljs.core.PersistentVector(null,2,(5),inst_34134,inst_34191,null));
var state_34328__$1 = state_34328;
var statearr_34335_34519 = state_34328__$1;
(statearr_34335_34519[(2)] = inst_34192);

(statearr_34335_34519[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (110))){
var inst_34298 = (state_34328[(14)]);
var inst_34301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34302 = [acc,inst_34298];
var inst_34303 = (new cljs.core.PersistentVector(null,2,(5),inst_34301,inst_34302,null));
var state_34328__$1 = state_34328;
var statearr_34336_34520 = state_34328__$1;
(statearr_34336_34520[(2)] = inst_34303);

(statearr_34336_34520[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (7))){
var inst_33968 = (state_34328[(15)]);
var state_34328__$1 = state_34328;
var statearr_34337_34521 = state_34328__$1;
(statearr_34337_34521[(2)] = inst_33968);

(statearr_34337_34521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (59))){
var inst_34292 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34338_34522 = state_34328__$1;
(statearr_34338_34522[(2)] = inst_34292);

(statearr_34338_34522[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (86))){
var inst_34194 = (state_34328[(16)]);
var state_34328__$1 = state_34328;
var statearr_34339_34523 = state_34328__$1;
(statearr_34339_34523[(2)] = inst_34194);

(statearr_34339_34523[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (20))){
var inst_34010 = (state_34328[(17)]);
var inst_33997 = (state_34328[(18)]);
var inst_34009 = (state_34328[(19)]);
var inst_34008 = (state_34328[(2)]);
var inst_34009__$1 = cljs.core.__destructure_map(inst_33997);
var inst_34010__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_34011 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_34012 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$limit);
var inst_34013 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$orderBy);
var inst_34014 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$offset);
var inst_34015 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34009__$1,cljs.core.cst$kw$p);
var state_34328__$1 = (function (){var statearr_34340 = state_34328;
(statearr_34340[(20)] = inst_34012);

(statearr_34340[(17)] = inst_34010__$1);

(statearr_34340[(21)] = inst_34015);

(statearr_34340[(22)] = inst_34014);

(statearr_34340[(23)] = inst_34011);

(statearr_34340[(24)] = inst_34008);

(statearr_34340[(25)] = inst_34013);

(statearr_34340[(19)] = inst_34009__$1);

return statearr_34340;
})();
if(cljs.core.truth_(inst_34010__$1)){
var statearr_34341_34524 = state_34328__$1;
(statearr_34341_34524[(1)] = (24));

} else {
var statearr_34342_34525 = state_34328__$1;
(statearr_34342_34525[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (72))){
var inst_34290 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34343_34526 = state_34328__$1;
(statearr_34343_34526[(2)] = inst_34290);

(statearr_34343_34526[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (58))){
var inst_33997 = (state_34328[(18)]);
var inst_34132 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34132)){
var statearr_34344_34527 = state_34328__$1;
(statearr_34344_34527[(1)] = (70));

} else {
var statearr_34345_34528 = state_34328__$1;
(statearr_34345_34528[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (60))){
var inst_34094 = (state_34328[(26)]);
var inst_34101 = (state_34328[(13)]);
var inst_34100 = cljs.core.seq(inst_34094);
var inst_34101__$1 = cljs.core.first(inst_34100);
var inst_34102 = cljs.core.next(inst_34100);
var state_34328__$1 = (function (){var statearr_34346 = state_34328;
(statearr_34346[(13)] = inst_34101__$1);

(statearr_34346[(27)] = inst_34102);

return statearr_34346;
})();
if(cljs.core.truth_(inst_34101__$1)){
var statearr_34347_34529 = state_34328__$1;
(statearr_34347_34529[(1)] = (62));

} else {
var statearr_34348_34530 = state_34328__$1;
(statearr_34348_34530[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (27))){
var inst_34014 = (state_34328[(22)]);
var inst_34018 = (state_34328[(28)]);
var inst_34018__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_34014);
var state_34328__$1 = (function (){var statearr_34349 = state_34328;
(statearr_34349[(28)] = inst_34018__$1);

return statearr_34349;
})();
if(inst_34018__$1){
var statearr_34350_34531 = state_34328__$1;
(statearr_34350_34531[(1)] = (30));

} else {
var statearr_34351_34532 = state_34328__$1;
(statearr_34351_34532[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (1))){
var state_34328__$1 = state_34328;
var statearr_34352_34533 = state_34328__$1;
(statearr_34352_34533[(2)] = null);

(statearr_34352_34533[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (69))){
var inst_34095 = (state_34328[(29)]);
var inst_34102 = (state_34328[(27)]);
var inst_34120 = (state_34328[(2)]);
var inst_34121 = fluree.db.util.async.throw_err(inst_34120);
var inst_34122 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34095,inst_34121);
var inst_34094 = inst_34102;
var inst_34095__$1 = inst_34122;
var state_34328__$1 = (function (){var statearr_34353 = state_34328;
(statearr_34353[(26)] = inst_34094);

(statearr_34353[(29)] = inst_34095__$1);

return statearr_34353;
})();
var statearr_34354_34534 = state_34328__$1;
(statearr_34354_34534[(2)] = null);

(statearr_34354_34534[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (101))){
var inst_34235 = (state_34328[(30)]);
var inst_34255 = cljs.core.count(inst_34235);
var inst_34256 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_34255);
var state_34328__$1 = state_34328;
var statearr_34355_34535 = state_34328__$1;
(statearr_34355_34535[(2)] = inst_34256);

(statearr_34355_34535[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (24))){
var inst_34014 = (state_34328[(22)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34014)){
var statearr_34356_34536 = state_34328__$1;
(statearr_34356_34536[(1)] = (27));

} else {
var statearr_34357_34537 = state_34328__$1;
(statearr_34357_34537[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (102))){
var state_34328__$1 = state_34328;
var statearr_34358_34538 = state_34328__$1;
(statearr_34358_34538[(2)] = null);

(statearr_34358_34538[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (55))){
var inst_33997 = (state_34328[(18)]);
var inst_34070 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = state_34328;
var statearr_34359_34539 = state_34328__$1;
(statearr_34359_34539[(2)] = inst_34070);

(statearr_34359_34539[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (85))){
var inst_33997 = (state_34328[(18)]);
var inst_34196 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = state_34328;
var statearr_34360_34540 = state_34328__$1;
(statearr_34360_34540[(2)] = inst_34196);

(statearr_34360_34540[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (39))){
var inst_34045 = (state_34328[(31)]);
var inst_34013 = (state_34328[(25)]);
var inst_34045__$1 = cljs.core.not(inst_34013);
var state_34328__$1 = (function (){var statearr_34361 = state_34328;
(statearr_34361[(31)] = inst_34045__$1);

return statearr_34361;
})();
if(inst_34045__$1){
var statearr_34362_34541 = state_34328__$1;
(statearr_34362_34541[(1)] = (42));

} else {
var statearr_34363_34542 = state_34328__$1;
(statearr_34363_34542[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (88))){
var inst_34201 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34209 = flakes;
var inst_34210 = cljs.core.seq(inst_34209);
var inst_34211 = cljs.core.first(inst_34210);
var inst_34212 = cljs.core.next(inst_34210);
var inst_34213 = cljs.core.PersistentVector.EMPTY;
var inst_34214 = inst_34209;
var inst_34215 = inst_34213;
var state_34328__$1 = (function (){var statearr_34364 = state_34328;
(statearr_34364[(32)] = inst_34211);

(statearr_34364[(33)] = inst_34201);

(statearr_34364[(34)] = inst_34212);

(statearr_34364[(35)] = inst_34215);

(statearr_34364[(36)] = inst_34214);

return statearr_34364;
})();
var statearr_34365_34543 = state_34328__$1;
(statearr_34365_34543[(2)] = null);

(statearr_34365_34543[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (46))){
var inst_34012 = (state_34328[(20)]);
var state_34328__$1 = state_34328;
var statearr_34366_34544 = state_34328__$1;
(statearr_34366_34544[(2)] = inst_34012);

(statearr_34366_34544[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (4))){
var inst_33957 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34367_34545 = state_34328__$1;
(statearr_34367_34545[(2)] = inst_33957);

(statearr_34367_34545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (77))){
var inst_34188 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34368_34546 = state_34328__$1;
(statearr_34368_34546[(2)] = inst_34188);

(statearr_34368_34546[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (106))){
var inst_34286 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34369_34547 = state_34328__$1;
(statearr_34369_34547[(2)] = inst_34286);

(statearr_34369_34547[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (95))){
var inst_34263 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34370_34548 = state_34328__$1;
(statearr_34370_34548[(2)] = inst_34263);

(statearr_34370_34548[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (54))){
var inst_34067 = (state_34328[(37)]);
var state_34328__$1 = state_34328;
var statearr_34371_34549 = state_34328__$1;
(statearr_34371_34549[(2)] = inst_34067);

(statearr_34371_34549[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (92))){
var inst_34201 = (state_34328[(33)]);
var inst_34265 = (state_34328[(2)]);
var inst_34266 = [inst_34265,offset_map];
var inst_34267 = (new cljs.core.PersistentVector(null,2,(5),inst_34201,inst_34266,null));
var state_34328__$1 = state_34328;
var statearr_34372_34550 = state_34328__$1;
(statearr_34372_34550[(2)] = inst_34267);

(statearr_34372_34550[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (104))){
var inst_34012 = (state_34328[(20)]);
var inst_34010 = (state_34328[(17)]);
var inst_34015 = (state_34328[(21)]);
var inst_33982 = (state_34328[(38)]);
var inst_34014 = (state_34328[(22)]);
var inst_33997 = (state_34328[(18)]);
var inst_34011 = (state_34328[(23)]);
var inst_34008 = (state_34328[(24)]);
var inst_33967 = (state_34328[(39)]);
var inst_34013 = (state_34328[(25)]);
var inst_34009 = (state_34328[(19)]);
var inst_34270 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34271 = (function (){var map__33963 = inst_34009;
var p = inst_34015;
var pred_spec__$1 = inst_33982;
var orderBy = inst_34013;
var multi_QMARK_ = inst_34010;
var limit = inst_34012;
var offset = inst_34014;
var k = inst_34008;
var compact_QMARK_ = inst_33967;
var pred_spec_SINGLEQUOTE_ = inst_33997;
var ref_QMARK_ = inst_34011;
return (function (p1__33953_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_id],[p1__33953_SHARP_.o]);
});
})();
var inst_34272 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34271,flakes);
var inst_34273 = [inst_34272,offset_map];
var inst_34274 = (new cljs.core.PersistentVector(null,2,(5),inst_34270,inst_34273,null));
var state_34328__$1 = state_34328;
var statearr_34373_34551 = state_34328__$1;
(statearr_34373_34551[(2)] = inst_34274);

(statearr_34373_34551[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (15))){
var inst_33990 = (state_34328[(40)]);
var inst_33967 = (state_34328[(39)]);
var inst_33994 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33990,cljs.core.cst$kw$compact_QMARK_,inst_33967);
var state_34328__$1 = state_34328;
var statearr_34374_34552 = state_34328__$1;
(statearr_34374_34552[(2)] = inst_33994);

(statearr_34374_34552[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (48))){
var inst_34061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34062 = [null,offset_map];
var inst_34063 = (new cljs.core.PersistentVector(null,2,(5),inst_34061,inst_34062,null));
var state_34328__$1 = state_34328;
var statearr_34375_34553 = state_34328__$1;
(statearr_34375_34553[(2)] = inst_34063);

(statearr_34375_34553[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (50))){
var inst_34294 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34376_34554 = state_34328__$1;
(statearr_34376_34554[(2)] = inst_34294);

(statearr_34376_34554[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (116))){
var inst_34297 = (state_34328[(41)]);
var inst_34298 = (state_34328[(14)]);
var inst_34008 = (state_34328[(24)]);
var inst_34312 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34313 = cljs.core.first(inst_34297);
var inst_34314 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_34008,inst_34313);
var inst_34315 = [inst_34314,inst_34298];
var inst_34316 = (new cljs.core.PersistentVector(null,2,(5),inst_34312,inst_34315,null));
var state_34328__$1 = state_34328;
var statearr_34377_34555 = state_34328__$1;
(statearr_34377_34555[(2)] = inst_34316);

(statearr_34377_34555[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (75))){
var inst_33997 = (state_34328[(18)]);
var inst_34154 = (state_34328[(42)]);
var inst_34163 = (state_34328[(43)]);
var inst_34157 = cljs.core.deref(cache);
var inst_34158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34159 = inst_34154.o;
var inst_34160 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33997);
var inst_34161 = [inst_34159,inst_34160];
var inst_34162 = (new cljs.core.PersistentVector(null,2,(5),inst_34158,inst_34161,null));
var inst_34163__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34157,inst_34162);
var state_34328__$1 = (function (){var statearr_34378 = state_34328;
(statearr_34378[(43)] = inst_34163__$1);

return statearr_34378;
})();
if(cljs.core.truth_(inst_34163__$1)){
var statearr_34379_34556 = state_34328__$1;
(statearr_34379_34556[(1)] = (78));

} else {
var statearr_34380_34557 = state_34328__$1;
(statearr_34380_34557[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (99))){
var inst_34253 = (state_34328[(2)]);
var state_34328__$1 = (function (){var statearr_34381 = state_34328;
(statearr_34381[(44)] = inst_34253);

return statearr_34381;
})();
if(cljs.core.truth_(fuel)){
var statearr_34382_34558 = state_34328__$1;
(statearr_34382_34558[(1)] = (101));

} else {
var statearr_34383_34559 = state_34328__$1;
(statearr_34383_34559[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (21))){
var inst_34001 = (state_34328[(45)]);
var state_34328__$1 = state_34328;
var statearr_34384_34560 = state_34328__$1;
(statearr_34384_34560[(2)] = inst_34001);

(statearr_34384_34560[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (31))){
var inst_34018 = (state_34328[(28)]);
var state_34328__$1 = state_34328;
var statearr_34385_34561 = state_34328__$1;
(statearr_34385_34561[(2)] = inst_34018);

(statearr_34385_34561[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (113))){
var inst_34297 = (state_34328[(41)]);
var inst_34298 = (state_34328[(14)]);
var inst_34008 = (state_34328[(24)]);
var inst_34306 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34307 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_34008,inst_34297);
var inst_34308 = [inst_34307,inst_34298];
var inst_34309 = (new cljs.core.PersistentVector(null,2,(5),inst_34306,inst_34308,null));
var state_34328__$1 = state_34328;
var statearr_34386_34562 = state_34328__$1;
(statearr_34386_34562[(2)] = inst_34309);

(statearr_34386_34562[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (32))){
var inst_34024 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34387_34563 = state_34328__$1;
(statearr_34387_34563[(2)] = inst_34024);

(statearr_34387_34563[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (40))){
var inst_34010 = (state_34328[(17)]);
var state_34328__$1 = state_34328;
var statearr_34388_34564 = state_34328__$1;
(statearr_34388_34564[(2)] = inst_34010);

(statearr_34388_34564[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (91))){
var inst_34221 = (state_34328[(46)]);
var inst_34214 = (state_34328[(36)]);
var inst_34220 = cljs.core.seq(inst_34214);
var inst_34221__$1 = cljs.core.first(inst_34220);
var inst_34222 = cljs.core.next(inst_34220);
var state_34328__$1 = (function (){var statearr_34389 = state_34328;
(statearr_34389[(46)] = inst_34221__$1);

(statearr_34389[(47)] = inst_34222);

return statearr_34389;
})();
if(cljs.core.truth_(inst_34221__$1)){
var statearr_34390_34565 = state_34328__$1;
(statearr_34390_34565[(1)] = (93));

} else {
var statearr_34391_34566 = state_34328__$1;
(statearr_34391_34566[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (117))){
var state_34328__$1 = state_34328;
var statearr_34392_34567 = state_34328__$1;
(statearr_34392_34567[(2)] = null);

(statearr_34392_34567[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (108))){
var state_34328__$1 = state_34328;
var statearr_34393_34568 = state_34328__$1;
(statearr_34393_34568[(2)] = null);

(statearr_34393_34568[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (56))){
var inst_34072 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34394_34569 = state_34328__$1;
(statearr_34394_34569[(2)] = inst_34072);

(statearr_34394_34569[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (33))){
var inst_34015 = (state_34328[(21)]);
var inst_34032 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34033 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_34015);
var state_34328__$1 = (function (){var statearr_34395 = state_34328;
(statearr_34395[(48)] = inst_34032);

return statearr_34395;
})();
if(cljs.core.truth_(inst_34033)){
var statearr_34396_34570 = state_34328__$1;
(statearr_34396_34570[(1)] = (36));

} else {
var statearr_34397_34571 = state_34328__$1;
(statearr_34397_34571[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (13))){
var inst_33982 = (state_34328[(38)]);
var state_34328__$1 = state_34328;
var statearr_34398_34572 = state_34328__$1;
(statearr_34398_34572[(2)] = inst_33982);

(statearr_34398_34572[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (22))){
var inst_33997 = (state_34328[(18)]);
var inst_34004 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = state_34328;
var statearr_34399_34573 = state_34328__$1;
(statearr_34399_34573[(2)] = inst_34004);

(statearr_34399_34573[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (90))){
var inst_34288 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34400_34574 = state_34328__$1;
(statearr_34400_34574[(2)] = inst_34288);

(statearr_34400_34574[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (109))){
var inst_34284 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34401_34575 = state_34328__$1;
(statearr_34401_34575[(2)] = inst_34284);

(statearr_34401_34575[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (36))){
var inst_34015 = (state_34328[(21)]);
var inst_34035 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_34015,cljs.core.dec);
var state_34328__$1 = state_34328;
var statearr_34402_34576 = state_34328__$1;
(statearr_34402_34576[(2)] = inst_34035);

(statearr_34402_34576[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (41))){
var inst_34059 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34059)){
var statearr_34403_34577 = state_34328__$1;
(statearr_34403_34577[(1)] = (48));

} else {
var statearr_34404_34578 = state_34328__$1;
(statearr_34404_34578[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (118))){
var inst_34319 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34405_34579 = state_34328__$1;
(statearr_34405_34579[(2)] = inst_34319);

(statearr_34405_34579[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (89))){
var inst_34011 = (state_34328[(23)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34011)){
var statearr_34406_34580 = state_34328__$1;
(statearr_34406_34580[(1)] = (104));

} else {
var statearr_34407_34581 = state_34328__$1;
(statearr_34407_34581[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (100))){
var inst_34215 = (state_34328[(35)]);
var inst_34249 = (state_34328[(2)]);
var inst_34250 = fluree.db.util.async.throw_err(inst_34249);
var inst_34251 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34215,inst_34250);
var state_34328__$1 = state_34328;
var statearr_34408_34582 = state_34328__$1;
(statearr_34408_34582[(2)] = inst_34251);

(statearr_34408_34582[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (43))){
var inst_34045 = (state_34328[(31)]);
var state_34328__$1 = state_34328;
var statearr_34409_34583 = state_34328__$1;
(statearr_34409_34583[(2)] = inst_34045);

(statearr_34409_34583[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (61))){
var inst_34081 = (state_34328[(49)]);
var inst_34128 = (state_34328[(2)]);
var inst_34129 = [inst_34128,offset_map];
var inst_34130 = (new cljs.core.PersistentVector(null,2,(5),inst_34081,inst_34129,null));
var state_34328__$1 = state_34328;
var statearr_34410_34584 = state_34328__$1;
(statearr_34410_34584[(2)] = inst_34130);

(statearr_34410_34584[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (29))){
var inst_34027 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34411_34585 = state_34328__$1;
(statearr_34411_34585[(2)] = inst_34027);

(statearr_34411_34585[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (44))){
var inst_34056 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34412_34586 = state_34328__$1;
(statearr_34412_34586[(2)] = inst_34056);

(statearr_34412_34586[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (93))){
var inst_34221 = (state_34328[(46)]);
var inst_33997 = (state_34328[(18)]);
var inst_34224 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34225 = inst_34221.o;
var inst_34226 = [inst_34225];
var inst_34227 = (new cljs.core.PersistentVector(null,1,(5),inst_34224,inst_34226,null));
var inst_34228 = [cljs.core.cst$kw$limit];
var inst_34229 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_33997);
var inst_34230 = [inst_34229];
var inst_34231 = cljs.core.PersistentHashMap.fromArrays(inst_34228,inst_34230);
var inst_34232 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34227,inst_34231);
var state_34328__$1 = state_34328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34328__$1,(96),inst_34232);
} else {
if((state_val_34329 === (6))){
var inst_33970 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33971 = (inst_33970 == null);
var state_34328__$1 = state_34328;
var statearr_34413_34587 = state_34328__$1;
(statearr_34413_34587[(2)] = inst_33971);

(statearr_34413_34587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (111))){
var inst_34010 = (state_34328[(17)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34010)){
var statearr_34414_34588 = state_34328__$1;
(statearr_34414_34588[(1)] = (113));

} else {
var statearr_34415_34589 = state_34328__$1;
(statearr_34415_34589[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (28))){
var inst_34014 = (state_34328[(22)]);
var state_34328__$1 = state_34328;
var statearr_34416_34590 = state_34328__$1;
(statearr_34416_34590[(2)] = inst_34014);

(statearr_34416_34590[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (64))){
var inst_34126 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34417_34591 = state_34328__$1;
(statearr_34417_34591[(2)] = inst_34126);

(statearr_34417_34591[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (103))){
var inst_34253 = (state_34328[(44)]);
var inst_34222 = (state_34328[(47)]);
var inst_34259 = (state_34328[(2)]);
var inst_34214 = inst_34222;
var inst_34215 = inst_34253;
var state_34328__$1 = (function (){var statearr_34418 = state_34328;
(statearr_34418[(50)] = inst_34259);

(statearr_34418[(35)] = inst_34215);

(statearr_34418[(36)] = inst_34214);

return statearr_34418;
})();
var statearr_34419_34592 = state_34328__$1;
(statearr_34419_34592[(2)] = null);

(statearr_34419_34592[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (51))){
var inst_33997 = (state_34328[(18)]);
var inst_34067 = (state_34328[(37)]);
var inst_34067__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = (function (){var statearr_34420 = state_34328;
(statearr_34420[(37)] = inst_34067__$1);

return statearr_34420;
})();
if(cljs.core.truth_(inst_34067__$1)){
var statearr_34421_34593 = state_34328__$1;
(statearr_34421_34593[(1)] = (54));

} else {
var statearr_34422_34594 = state_34328__$1;
(statearr_34422_34594[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (25))){
var inst_34010 = (state_34328[(17)]);
var state_34328__$1 = state_34328;
var statearr_34423_34595 = state_34328__$1;
(statearr_34423_34595[(2)] = inst_34010);

(statearr_34423_34595[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (34))){
var inst_34010 = (state_34328[(17)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34010)){
var statearr_34424_34596 = state_34328__$1;
(statearr_34424_34596[(1)] = (39));

} else {
var statearr_34425_34597 = state_34328__$1;
(statearr_34425_34597[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (17))){
var inst_33998 = (state_34328[(51)]);
var inst_33997 = (state_34328[(18)]);
var inst_33997__$1 = (state_34328[(2)]);
var inst_33998__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_33997__$1);
var state_34328__$1 = (function (){var statearr_34426 = state_34328;
(statearr_34426[(51)] = inst_33998__$1);

(statearr_34426[(18)] = inst_33997__$1);

return statearr_34426;
})();
if(cljs.core.truth_(inst_33998__$1)){
var statearr_34427_34598 = state_34328__$1;
(statearr_34427_34598[(1)] = (18));

} else {
var statearr_34428_34599 = state_34328__$1;
(statearr_34428_34599[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (3))){
var inst_34326 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34328__$1,inst_34326);
} else {
if((state_val_34329 === (12))){
var inst_33982 = (state_34328[(38)]);
var inst_33987 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33982,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_34328__$1 = state_34328;
var statearr_34429_34600 = state_34328__$1;
(statearr_34429_34600[(2)] = inst_33987);

(statearr_34429_34600[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (2))){
var inst_33968 = (state_34328[(15)]);
var _ = (function (){var statearr_34430 = state_34328;
(statearr_34430[(4)] = cljs.core.cons((5),(state_34328[(4)])));

return statearr_34430;
})();
var inst_33967 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33968__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_34328__$1 = (function (){var statearr_34431 = state_34328;
(statearr_34431[(39)] = inst_33967);

(statearr_34431[(15)] = inst_33968__$1);

return statearr_34431;
})();
if(cljs.core.truth_(inst_33968__$1)){
var statearr_34432_34601 = state_34328__$1;
(statearr_34432_34601[(1)] = (6));

} else {
var statearr_34433_34602 = state_34328__$1;
(statearr_34433_34602[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (66))){
var inst_34111 = (state_34328[(7)]);
var inst_34113 = cljs.core.count(inst_34111);
var inst_34114 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_34113);
var state_34328__$1 = state_34328;
var statearr_34434_34603 = state_34328__$1;
(statearr_34434_34603[(2)] = inst_34114);

(statearr_34434_34603[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (107))){
var inst_34012 = (state_34328[(20)]);
var inst_34010 = (state_34328[(17)]);
var inst_34015 = (state_34328[(21)]);
var inst_33982 = (state_34328[(38)]);
var inst_34014 = (state_34328[(22)]);
var inst_33997 = (state_34328[(18)]);
var inst_34011 = (state_34328[(23)]);
var inst_34008 = (state_34328[(24)]);
var inst_33967 = (state_34328[(39)]);
var inst_34013 = (state_34328[(25)]);
var inst_34009 = (state_34328[(19)]);
var inst_34277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34278 = (function (){var map__33963 = inst_34009;
var p = inst_34015;
var pred_spec__$1 = inst_33982;
var orderBy = inst_34013;
var multi_QMARK_ = inst_34010;
var limit = inst_34012;
var offset = inst_34014;
var k = inst_34008;
var compact_QMARK_ = inst_33967;
var pred_spec_SINGLEQUOTE_ = inst_33997;
var ref_QMARK_ = inst_34011;
return (function (p1__33954_SHARP_){
return p1__33954_SHARP_.o;
});
})();
var inst_34279 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_34278,flakes);
var inst_34280 = [inst_34279,offset_map];
var inst_34281 = (new cljs.core.PersistentVector(null,2,(5),inst_34277,inst_34280,null));
var state_34328__$1 = state_34328;
var statearr_34435_34604 = state_34328__$1;
(statearr_34435_34604[(2)] = inst_34281);

(statearr_34435_34604[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (23))){
var inst_34006 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34436_34605 = state_34328__$1;
(statearr_34436_34605[(2)] = inst_34006);

(statearr_34436_34605[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (47))){
var inst_34053 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34437_34606 = state_34328__$1;
(statearr_34437_34606[(2)] = inst_34053);

(statearr_34437_34606[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (35))){
var inst_34297 = (state_34328[(41)]);
var inst_34296 = (state_34328[(2)]);
var inst_34297__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34296,(0),null);
var inst_34298 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34296,(1),null);
var inst_34299 = cljs.core.empty_QMARK_(inst_34297__$1);
var state_34328__$1 = (function (){var statearr_34438 = state_34328;
(statearr_34438[(41)] = inst_34297__$1);

(statearr_34438[(14)] = inst_34298);

return statearr_34438;
})();
if(inst_34299){
var statearr_34439_34607 = state_34328__$1;
(statearr_34439_34607[(1)] = (110));

} else {
var statearr_34440_34608 = state_34328__$1;
(statearr_34440_34608[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (82))){
var inst_34148 = (state_34328[(11)]);
var inst_34179 = (state_34328[(52)]);
var inst_34181 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34148,inst_34179);
var state_34328__$1 = state_34328;
var statearr_34441_34609 = state_34328__$1;
(statearr_34441_34609[(2)] = inst_34181);

(statearr_34441_34609[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (76))){
var inst_34148 = (state_34328[(11)]);
var state_34328__$1 = state_34328;
var statearr_34442_34610 = state_34328__$1;
(statearr_34442_34610[(2)] = inst_34148);

(statearr_34442_34610[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (97))){
var inst_34221 = (state_34328[(46)]);
var inst_34215 = (state_34328[(35)]);
var inst_34238 = [cljs.core.cst$kw$_id];
var inst_34239 = inst_34221.o;
var inst_34240 = [inst_34239];
var inst_34241 = cljs.core.PersistentHashMap.fromArrays(inst_34238,inst_34240);
var inst_34242 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34215,inst_34241);
var state_34328__$1 = state_34328;
var statearr_34443_34611 = state_34328__$1;
(statearr_34443_34611[(2)] = inst_34242);

(statearr_34443_34611[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (19))){
var inst_34001 = (state_34328[(45)]);
var inst_33997 = (state_34328[(18)]);
var inst_34001__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33997);
var state_34328__$1 = (function (){var statearr_34444 = state_34328;
(statearr_34444[(45)] = inst_34001__$1);

return statearr_34444;
})();
if(cljs.core.truth_(inst_34001__$1)){
var statearr_34445_34612 = state_34328__$1;
(statearr_34445_34612[(1)] = (21));

} else {
var statearr_34446_34613 = state_34328__$1;
(statearr_34446_34613[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (57))){
var inst_33997 = (state_34328[(18)]);
var inst_34077 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34078 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_34079 = (new cljs.core.PersistentVector(null,3,(5),inst_34077,inst_34078,null));
var inst_34080 = cljs.core.select_keys(inst_33997,inst_34079);
var inst_34081 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34089 = flakes;
var inst_34090 = cljs.core.seq(inst_34089);
var inst_34091 = cljs.core.first(inst_34090);
var inst_34092 = cljs.core.next(inst_34090);
var inst_34093 = cljs.core.PersistentVector.EMPTY;
var inst_34094 = inst_34089;
var inst_34095 = inst_34093;
var state_34328__$1 = (function (){var statearr_34447 = state_34328;
(statearr_34447[(26)] = inst_34094);

(statearr_34447[(53)] = inst_34091);

(statearr_34447[(49)] = inst_34081);

(statearr_34447[(54)] = inst_34080);

(statearr_34447[(29)] = inst_34095);

(statearr_34447[(55)] = inst_34092);

return statearr_34447;
})();
var statearr_34448_34614 = state_34328__$1;
(statearr_34448_34614[(2)] = null);

(statearr_34448_34614[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (68))){
var inst_34111 = (state_34328[(7)]);
var inst_34080 = (state_34328[(54)]);
var inst_34117 = (state_34328[(2)]);
var inst_34118 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34080,inst_34111) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34080,inst_34111));
var state_34328__$1 = (function (){var statearr_34449 = state_34328;
(statearr_34449[(56)] = inst_34117);

return statearr_34449;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34328__$1,(69),inst_34118);
} else {
if((state_val_34329 === (11))){
var inst_33982 = (state_34328[(38)]);
var inst_33982__$1 = (state_34328[(2)]);
var inst_33984 = cljs.core.contains_QMARK_(inst_33982__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_33985 = (!(inst_33984));
var state_34328__$1 = (function (){var statearr_34450 = state_34328;
(statearr_34450[(38)] = inst_33982__$1);

return statearr_34450;
})();
if(inst_33985){
var statearr_34451_34615 = state_34328__$1;
(statearr_34451_34615[(1)] = (12));

} else {
var statearr_34452_34616 = state_34328__$1;
(statearr_34452_34616[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (115))){
var inst_34321 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
var statearr_34454_34617 = state_34328__$1;
(statearr_34454_34617[(2)] = inst_34321);

(statearr_34454_34617[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (9))){
var inst_33976 = cljs.core.first(flakes);
var inst_33977 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_33976);
var inst_33978 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_33979 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_33977,inst_33978);
var state_34328__$1 = state_34328;
var statearr_34455_34618 = state_34328__$1;
(statearr_34455_34618[(2)] = inst_33979);

(statearr_34455_34618[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (5))){
var _ = (function (){var statearr_34456 = state_34328;
(statearr_34456[(4)] = cljs.core.rest((state_34328[(4)])));

return statearr_34456;
})();
var state_34328__$1 = state_34328;
var ex34453 = (state_34328__$1[(2)]);
var statearr_34457_34619 = state_34328__$1;
(statearr_34457_34619[(5)] = ex34453);


if((ex34453 instanceof Error)){
var statearr_34458_34620 = state_34328__$1;
(statearr_34458_34620[(1)] = (4));

(statearr_34458_34620[(5)] = null);

} else {
throw ex34453;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (112))){
var inst_34323 = (state_34328[(2)]);
var _ = (function (){var statearr_34459 = state_34328;
(statearr_34459[(4)] = cljs.core.rest((state_34328[(4)])));

return statearr_34459;
})();
var state_34328__$1 = state_34328;
var statearr_34460_34621 = state_34328__$1;
(statearr_34460_34621[(2)] = inst_34323);

(statearr_34460_34621[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (83))){
var inst_34148 = (state_34328[(11)]);
var state_34328__$1 = state_34328;
var statearr_34461_34622 = state_34328__$1;
(statearr_34461_34622[(2)] = inst_34148);

(statearr_34461_34622[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (14))){
var inst_33982 = (state_34328[(38)]);
var inst_33990 = (state_34328[(2)]);
var inst_33991 = cljs.core.contains_QMARK_(inst_33982,cljs.core.cst$kw$compact_QMARK_);
var inst_33992 = (!(inst_33991));
var state_34328__$1 = (function (){var statearr_34462 = state_34328;
(statearr_34462[(40)] = inst_33990);

return statearr_34462;
})();
if(inst_33992){
var statearr_34463_34623 = state_34328__$1;
(statearr_34463_34623[(1)] = (15));

} else {
var statearr_34464_34624 = state_34328__$1;
(statearr_34464_34624[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (45))){
var inst_34012 = (state_34328[(20)]);
var inst_34008 = (state_34328[(24)]);
var inst_34048 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_34008);
var inst_34049 = cljs.core.count(inst_34048);
var inst_34050 = (inst_34049 >= inst_34012);
var state_34328__$1 = state_34328;
var statearr_34465_34625 = state_34328__$1;
(statearr_34465_34625[(2)] = inst_34050);

(statearr_34465_34625[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (53))){
var inst_34075 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34075)){
var statearr_34466_34626 = state_34328__$1;
(statearr_34466_34626[(1)] = (57));

} else {
var statearr_34467_34627 = state_34328__$1;
(statearr_34467_34627[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (78))){
var inst_34163 = (state_34328[(43)]);
var state_34328__$1 = state_34328;
var statearr_34468_34628 = state_34328__$1;
(statearr_34468_34628[(2)] = inst_34163);

(statearr_34468_34628[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (26))){
var inst_34030 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34030)){
var statearr_34469_34629 = state_34328__$1;
(statearr_34469_34629[(1)] = (33));

} else {
var statearr_34470_34630 = state_34328__$1;
(statearr_34470_34630[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (16))){
var inst_33990 = (state_34328[(40)]);
var state_34328__$1 = state_34328;
var statearr_34471_34631 = state_34328__$1;
(statearr_34471_34631[(2)] = inst_33990);

(statearr_34471_34631[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (81))){
var inst_33997 = (state_34328[(18)]);
var inst_34154 = (state_34328[(42)]);
var inst_34170 = (state_34328[(2)]);
var inst_34171 = fluree.db.util.async.throw_err(inst_34170);
var inst_34172 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34173 = inst_34154.o;
var inst_34174 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33997);
var inst_34175 = [inst_34173,inst_34174];
var inst_34176 = (new cljs.core.PersistentVector(null,2,(5),inst_34172,inst_34175,null));
var inst_34177 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_34176,inst_34171);
var state_34328__$1 = (function (){var statearr_34472 = state_34328;
(statearr_34472[(57)] = inst_34177);

return statearr_34472;
})();
var statearr_34473_34632 = state_34328__$1;
(statearr_34473_34632[(2)] = inst_34171);

(statearr_34473_34632[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (79))){
var inst_33997 = (state_34328[(18)]);
var inst_34154 = (state_34328[(42)]);
var inst_34166 = inst_34154.o;
var inst_34167 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_33997);
var inst_34168 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_34166,inst_34167);
var state_34328__$1 = state_34328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34328__$1,(81),inst_34168);
} else {
if((state_val_34329 === (38))){
var inst_34032 = (state_34328[(48)]);
var inst_34040 = (state_34328[(2)]);
var inst_34041 = [null,inst_34040];
var inst_34042 = (new cljs.core.PersistentVector(null,2,(5),inst_34032,inst_34041,null));
var state_34328__$1 = state_34328;
var statearr_34474_34633 = state_34328__$1;
(statearr_34474_34633[(2)] = inst_34042);

(statearr_34474_34633[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (98))){
var inst_34235 = (state_34328[(30)]);
var inst_33967 = (state_34328[(39)]);
var inst_34244 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_];
var inst_34245 = [true,inst_33967];
var inst_34246 = cljs.core.PersistentHashMap.fromArrays(inst_34244,inst_34245);
var inst_34247 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34246,inst_34235) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34246,inst_34235));
var state_34328__$1 = state_34328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34328__$1,(100),inst_34247);
} else {
if((state_val_34329 === (87))){
var inst_34199 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34199)){
var statearr_34475_34634 = state_34328__$1;
(statearr_34475_34634[(1)] = (88));

} else {
var statearr_34476_34635 = state_34328__$1;
(statearr_34476_34635[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (30))){
var inst_34015 = (state_34328[(21)]);
var inst_34020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_34015);
var inst_34021 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_34020);
var state_34328__$1 = state_34328;
var statearr_34477_34636 = state_34328__$1;
(statearr_34477_34636[(2)] = inst_34021);

(statearr_34477_34636[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (73))){
var inst_34147 = (state_34328[(9)]);
var inst_34154 = (state_34328[(42)]);
var inst_34153 = cljs.core.seq(inst_34147);
var inst_34154__$1 = cljs.core.first(inst_34153);
var inst_34155 = cljs.core.next(inst_34153);
var state_34328__$1 = (function (){var statearr_34478 = state_34328;
(statearr_34478[(58)] = inst_34155);

(statearr_34478[(42)] = inst_34154__$1);

return statearr_34478;
})();
if(cljs.core.truth_(inst_34154__$1)){
var statearr_34479_34637 = state_34328__$1;
(statearr_34479_34637[(1)] = (75));

} else {
var statearr_34480_34638 = state_34328__$1;
(statearr_34480_34638[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (96))){
var inst_34235 = (state_34328[(30)]);
var inst_34234 = (state_34328[(2)]);
var inst_34235__$1 = fluree.db.util.async.throw_err(inst_34234);
var inst_34236 = cljs.core.empty_QMARK_(inst_34235__$1);
var state_34328__$1 = (function (){var statearr_34481 = state_34328;
(statearr_34481[(30)] = inst_34235__$1);

return statearr_34481;
})();
if(inst_34236){
var statearr_34482_34639 = state_34328__$1;
(statearr_34482_34639[(1)] = (97));

} else {
var statearr_34483_34640 = state_34328__$1;
(statearr_34483_34640[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (10))){
var state_34328__$1 = state_34328;
var statearr_34484_34641 = state_34328__$1;
(statearr_34484_34641[(2)] = pred_spec);

(statearr_34484_34641[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (18))){
var inst_33998 = (state_34328[(51)]);
var state_34328__$1 = state_34328;
var statearr_34485_34642 = state_34328__$1;
(statearr_34485_34642[(2)] = inst_33998);

(statearr_34485_34642[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (105))){
var state_34328__$1 = state_34328;
var statearr_34486_34643 = state_34328__$1;
(statearr_34486_34643[(1)] = (107));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (52))){
var inst_34065 = (state_34328[(59)]);
var state_34328__$1 = state_34328;
var statearr_34488_34644 = state_34328__$1;
(statearr_34488_34644[(2)] = inst_34065);

(statearr_34488_34644[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (114))){
var state_34328__$1 = state_34328;
var statearr_34489_34645 = state_34328__$1;
(statearr_34489_34645[(1)] = (116));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (67))){
var state_34328__$1 = state_34328;
var statearr_34491_34646 = state_34328__$1;
(statearr_34491_34646[(2)] = null);

(statearr_34491_34646[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (71))){
var inst_34194 = (state_34328[(16)]);
var inst_34194__$1 = componentFollow_QMARK_;
var state_34328__$1 = (function (){var statearr_34492 = state_34328;
(statearr_34492[(16)] = inst_34194__$1);

return statearr_34492;
})();
if(cljs.core.truth_(inst_34194__$1)){
var statearr_34493_34647 = state_34328__$1;
(statearr_34493_34647[(1)] = (85));

} else {
var statearr_34494_34648 = state_34328__$1;
(statearr_34494_34648[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (42))){
var inst_34012 = (state_34328[(20)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_34012)){
var statearr_34495_34649 = state_34328__$1;
(statearr_34495_34649[(1)] = (45));

} else {
var statearr_34496_34650 = state_34328__$1;
(statearr_34496_34650[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (80))){
var inst_34179 = (state_34328[(52)]);
var inst_34179__$1 = (state_34328[(2)]);
var state_34328__$1 = (function (){var statearr_34497 = state_34328;
(statearr_34497[(52)] = inst_34179__$1);

return statearr_34497;
})();
if(cljs.core.truth_(inst_34179__$1)){
var statearr_34498_34651 = state_34328__$1;
(statearr_34498_34651[(1)] = (82));

} else {
var statearr_34499_34652 = state_34328__$1;
(statearr_34499_34652[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (37))){
var inst_34015 = (state_34328[(21)]);
var inst_34014 = (state_34328[(22)]);
var inst_34037 = (inst_34014 - (1));
var inst_34038 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_34015,inst_34037);
var state_34328__$1 = state_34328;
var statearr_34500_34653 = state_34328__$1;
(statearr_34500_34653[(2)] = inst_34038);

(statearr_34500_34653[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (63))){
var inst_34095 = (state_34328[(29)]);
var state_34328__$1 = state_34328;
var statearr_34501_34654 = state_34328__$1;
(statearr_34501_34654[(2)] = inst_34095);

(statearr_34501_34654[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (94))){
var inst_34215 = (state_34328[(35)]);
var state_34328__$1 = state_34328;
var statearr_34502_34655 = state_34328__$1;
(statearr_34502_34655[(2)] = inst_34215);

(statearr_34502_34655[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (8))){
var inst_33974 = (state_34328[(2)]);
var state_34328__$1 = state_34328;
if(cljs.core.truth_(inst_33974)){
var statearr_34503_34656 = state_34328__$1;
(statearr_34503_34656[(1)] = (9));

} else {
var statearr_34504_34657 = state_34328__$1;
(statearr_34504_34657[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (49))){
var inst_34065 = (state_34328[(59)]);
var inst_34065__$1 = cljs.core.not(recur_QMARK_);
var state_34328__$1 = (function (){var statearr_34505 = state_34328;
(statearr_34505[(59)] = inst_34065__$1);

return statearr_34505;
})();
if(inst_34065__$1){
var statearr_34506_34658 = state_34328__$1;
(statearr_34506_34658[(1)] = (51));

} else {
var statearr_34507_34659 = state_34328__$1;
(statearr_34507_34659[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34329 === (84))){
var inst_34155 = (state_34328[(58)]);
var inst_34184 = (state_34328[(2)]);
var inst_34147 = inst_34155;
var inst_34148 = inst_34184;
var state_34328__$1 = (function (){var statearr_34508 = state_34328;
(statearr_34508[(9)] = inst_34147);

(statearr_34508[(11)] = inst_34148);

return statearr_34508;
})();
var statearr_34509_34660 = state_34328__$1;
(statearr_34509_34660[(2)] = null);

(statearr_34509_34660[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10750__auto__ = null;
var fluree$db$query$fql$state_machine__10750__auto____0 = (function (){
var statearr_34510 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34510[(0)] = fluree$db$query$fql$state_machine__10750__auto__);

(statearr_34510[(1)] = (1));

return statearr_34510;
});
var fluree$db$query$fql$state_machine__10750__auto____1 = (function (state_34328){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_34328);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e34511){var ex__10753__auto__ = e34511;
var statearr_34512_34661 = state_34328;
(statearr_34512_34661[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_34328[(4)]))){
var statearr_34513_34662 = state_34328;
(statearr_34513_34662[(1)] = cljs.core.first((state_34328[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__34663 = state_34328;
state_34328 = G__34663;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10750__auto__ = function(state_34328){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10750__auto____1.call(this,state_34328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10750__auto____0;
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10750__auto____1;
return fluree$db$query$fql$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_34514 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_34514[(6)] = c__10876__auto__);

return statearr_34514;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_34823){
var state_val_34824 = (state_34823[(1)]);
if((state_val_34824 === (7))){
var inst_34818 = (state_34823[(2)]);
var _ = (function (){var statearr_34825 = state_34823;
(statearr_34825[(4)] = cljs.core.rest((state_34823[(4)])));

return statearr_34825;
})();
var state_34823__$1 = state_34823;
var statearr_34826_34908 = state_34823__$1;
(statearr_34826_34908[(2)] = inst_34818);

(statearr_34826_34908[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (20))){
var inst_34745 = (state_34823[(7)]);
var state_34823__$1 = state_34823;
var statearr_34827_34909 = state_34823__$1;
(statearr_34827_34909[(2)] = inst_34745);

(statearr_34827_34909[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (27))){
var inst_34700 = (state_34823[(8)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34700)){
var statearr_34828_34910 = state_34823__$1;
(statearr_34828_34910[(1)] = (29));

} else {
var statearr_34829_34911 = state_34823__$1;
(statearr_34829_34911[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (1))){
var state_34823__$1 = state_34823;
var statearr_34830_34912 = state_34823__$1;
(statearr_34830_34912[(2)] = null);

(statearr_34830_34912[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (24))){
var inst_34701 = (state_34823[(9)]);
var state_34823__$1 = state_34823;
var statearr_34831_34913 = state_34823__$1;
(statearr_34831_34913[(2)] = inst_34701);

(statearr_34831_34913[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (39))){
var inst_34737 = (state_34823[(10)]);
var state_34823__$1 = state_34823;
var statearr_34832_34914 = state_34823__$1;
(statearr_34832_34914[(2)] = inst_34737);

(statearr_34832_34914[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (46))){
var inst_34702 = (state_34823[(11)]);
var state_34823__$1 = state_34823;
var statearr_34833_34915 = state_34823__$1;
(statearr_34833_34915[(2)] = inst_34702);

(statearr_34833_34915[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (4))){
var inst_34664 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34834_34916 = state_34823__$1;
(statearr_34834_34916[(2)] = inst_34664);

(statearr_34834_34916[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (15))){
var inst_34713 = (state_34823[(12)]);
var inst_34719 = cljs.core.count(inst_34713);
var inst_34720 = fluree.db.query.fql.add_fuel(fuel,inst_34719,max_fuel);
var state_34823__$1 = state_34823;
var statearr_34835_34917 = state_34823__$1;
(statearr_34835_34917[(2)] = inst_34720);

(statearr_34835_34917[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (48))){
var inst_34689 = (state_34823[(13)]);
var inst_34804 = (state_34823[(14)]);
var inst_34682 = (state_34823[(15)]);
var inst_34812 = (state_34823[(2)]);
var inst_34813 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34682,inst_34812,inst_34804);
var inst_34681 = inst_34689;
var inst_34682__$1 = inst_34813;
var state_34823__$1 = (function (){var statearr_34836 = state_34823;
(statearr_34836[(16)] = inst_34681);

(statearr_34836[(15)] = inst_34682__$1);

return statearr_34836;
})();
var statearr_34837_34918 = state_34823__$1;
(statearr_34837_34918[(2)] = null);

(statearr_34837_34918[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (50))){
var inst_34704 = (state_34823[(17)]);
var state_34823__$1 = state_34823;
var statearr_34838_34919 = state_34823__$1;
(statearr_34838_34919[(2)] = inst_34704);

(statearr_34838_34919[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (21))){
var inst_34701 = (state_34823[(9)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34701)){
var statearr_34840_34920 = state_34823__$1;
(statearr_34840_34920[(1)] = (23));

} else {
var statearr_34841_34921 = state_34823__$1;
(statearr_34841_34921[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (31))){
var inst_34761 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34761)){
var statearr_34842_34922 = state_34823__$1;
(statearr_34842_34922[(1)] = (32));

} else {
var statearr_34843_34923 = state_34823__$1;
(statearr_34843_34923[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (32))){
var inst_34737 = (state_34823[(10)]);
var inst_34736 = (state_34823[(18)]);
var inst_34744 = (state_34823[(19)]);
var inst_34763 = (inst_34736 + (1));
var tmp34839 = inst_34737;
var inst_34735 = inst_34744;
var inst_34736__$1 = inst_34763;
var inst_34737__$1 = tmp34839;
var state_34823__$1 = (function (){var statearr_34844 = state_34823;
(statearr_34844[(10)] = inst_34737__$1);

(statearr_34844[(20)] = inst_34735);

(statearr_34844[(18)] = inst_34736__$1);

return statearr_34844;
})();
var statearr_34845_34924 = state_34823__$1;
(statearr_34845_34924[(2)] = null);

(statearr_34845_34924[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (40))){
var state_34823__$1 = state_34823;
if(cljs.core.truth_(fuel)){
var statearr_34846_34925 = state_34823__$1;
(statearr_34846_34925[(1)] = (42));

} else {
var statearr_34847_34926 = state_34823__$1;
(statearr_34847_34926[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (33))){
var state_34823__$1 = state_34823;
var statearr_34848_34927 = state_34823__$1;
(statearr_34848_34927[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (13))){
var inst_34713 = (state_34823[(12)]);
var state_34823__$1 = state_34823;
var statearr_34850_34928 = state_34823__$1;
(statearr_34850_34928[(2)] = inst_34713);

(statearr_34850_34928[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (22))){
var inst_34754 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34754)){
var statearr_34851_34929 = state_34823__$1;
(statearr_34851_34929[(1)] = (26));

} else {
var statearr_34852_34930 = state_34823__$1;
(statearr_34852_34930[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (36))){
var state_34823__$1 = state_34823;
var statearr_34853_34931 = state_34823__$1;
(statearr_34853_34931[(2)] = null);

(statearr_34853_34931[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (41))){
var inst_34736 = (state_34823[(18)]);
var inst_34744 = (state_34823[(19)]);
var inst_34793 = (state_34823[(2)]);
var inst_34794 = (inst_34736 + (1));
var inst_34735 = inst_34744;
var inst_34736__$1 = inst_34794;
var inst_34737 = inst_34793;
var state_34823__$1 = (function (){var statearr_34854 = state_34823;
(statearr_34854[(10)] = inst_34737);

(statearr_34854[(20)] = inst_34735);

(statearr_34854[(18)] = inst_34736__$1);

return statearr_34854;
})();
var statearr_34855_34932 = state_34823__$1;
(statearr_34855_34932[(2)] = null);

(statearr_34855_34932[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (43))){
var state_34823__$1 = state_34823;
var statearr_34856_34933 = state_34823__$1;
(statearr_34856_34933[(2)] = null);

(statearr_34856_34933[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (29))){
var inst_34700 = (state_34823[(8)]);
var inst_34736 = (state_34823[(18)]);
var inst_34758 = (inst_34736 < inst_34700);
var state_34823__$1 = state_34823;
var statearr_34857_34934 = state_34823__$1;
(statearr_34857_34934[(2)] = inst_34758);

(statearr_34857_34934[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (44))){
var inst_34773 = (state_34823[(21)]);
var inst_34777 = (state_34823[(22)]);
var inst_34786 = (state_34823[(2)]);
var inst_34787 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_34777,inst_34773) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_34777,inst_34773));
var state_34823__$1 = (function (){var statearr_34858 = state_34823;
(statearr_34858[(23)] = inst_34786);

return statearr_34858;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34823__$1,(45),inst_34787);
} else {
if((state_val_34824 === (6))){
var inst_34681 = (state_34823[(16)]);
var inst_34688 = (state_34823[(24)]);
var inst_34687 = cljs.core.seq(inst_34681);
var inst_34688__$1 = cljs.core.first(inst_34687);
var inst_34689 = cljs.core.next(inst_34687);
var inst_34690 = cljs.core.not(inst_34688__$1);
var state_34823__$1 = (function (){var statearr_34859 = state_34823;
(statearr_34859[(13)] = inst_34689);

(statearr_34859[(24)] = inst_34688__$1);

return statearr_34859;
})();
if(inst_34690){
var statearr_34860_34935 = state_34823__$1;
(statearr_34860_34935[(1)] = (8));

} else {
var statearr_34861_34936 = state_34823__$1;
(statearr_34861_34936[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (28))){
var inst_34802 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34862_34937 = state_34823__$1;
(statearr_34862_34937[(2)] = inst_34802);

(statearr_34862_34937[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (51))){
var inst_34810 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34863_34938 = state_34823__$1;
(statearr_34863_34938[(2)] = inst_34810);

(statearr_34863_34938[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (25))){
var inst_34752 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34864_34939 = state_34823__$1;
(statearr_34864_34939[(2)] = inst_34752);

(statearr_34864_34939[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (34))){
var inst_34800 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34865_34940 = state_34823__$1;
(statearr_34865_34940[(2)] = inst_34800);

(statearr_34865_34940[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (17))){
var inst_34713 = (state_34823[(12)]);
var inst_34723 = (state_34823[(2)]);
var inst_34731 = cljs.core.seq(inst_34713);
var inst_34732 = cljs.core.first(inst_34731);
var inst_34733 = cljs.core.next(inst_34731);
var inst_34734 = cljs.core.PersistentVector.EMPTY;
var inst_34735 = inst_34713;
var inst_34736 = (0);
var inst_34737 = inst_34734;
var state_34823__$1 = (function (){var statearr_34866 = state_34823;
(statearr_34866[(10)] = inst_34737);

(statearr_34866[(25)] = inst_34732);

(statearr_34866[(26)] = inst_34733);

(statearr_34866[(27)] = inst_34723);

(statearr_34866[(20)] = inst_34735);

(statearr_34866[(18)] = inst_34736);

return statearr_34866;
})();
var statearr_34867_34941 = state_34823__$1;
(statearr_34867_34941[(2)] = null);

(statearr_34867_34941[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (3))){
var inst_34821 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34823__$1,inst_34821);
} else {
if((state_val_34824 === (12))){
var state_34823__$1 = state_34823;
var statearr_34868_34942 = state_34823__$1;
(statearr_34868_34942[(2)] = fuel);

(statearr_34868_34942[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (2))){
var _ = (function (){var statearr_34869 = state_34823;
(statearr_34869[(4)] = cljs.core.cons((5),(state_34823[(4)])));

return statearr_34869;
})();
var inst_34677 = reverse_refs_specs;
var inst_34678 = cljs.core.seq(inst_34677);
var inst_34679 = cljs.core.first(inst_34678);
var inst_34680 = cljs.core.next(inst_34678);
var inst_34681 = inst_34677;
var inst_34682 = null;
var state_34823__$1 = (function (){var statearr_34870 = state_34823;
(statearr_34870[(16)] = inst_34681);

(statearr_34870[(28)] = inst_34679);

(statearr_34870[(29)] = inst_34680);

(statearr_34870[(15)] = inst_34682);

return statearr_34870;
})();
var statearr_34871_34943 = state_34823__$1;
(statearr_34871_34943[(2)] = null);

(statearr_34871_34943[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (23))){
var inst_34701 = (state_34823[(9)]);
var inst_34736 = (state_34823[(18)]);
var inst_34749 = (inst_34736 >= inst_34701);
var state_34823__$1 = state_34823;
var statearr_34872_34944 = state_34823__$1;
(statearr_34872_34944[(2)] = inst_34749);

(statearr_34872_34944[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (47))){
var inst_34703 = (state_34823[(30)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34703)){
var statearr_34873_34945 = state_34823__$1;
(statearr_34873_34945[(1)] = (49));

} else {
var statearr_34874_34946 = state_34823__$1;
(statearr_34874_34946[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (35))){
var inst_34743 = (state_34823[(31)]);
var inst_34767 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34768 = [inst_34743];
var inst_34769 = (new cljs.core.PersistentVector(null,1,(5),inst_34767,inst_34768,null));
var inst_34770 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_34769);
var state_34823__$1 = state_34823;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34823__$1,(38),inst_34770);
} else {
if((state_val_34824 === (19))){
var inst_34702 = (state_34823[(11)]);
var inst_34804 = (state_34823[(2)]);
var state_34823__$1 = (function (){var statearr_34875 = state_34823;
(statearr_34875[(14)] = inst_34804);

return statearr_34875;
})();
if(cljs.core.truth_(inst_34702)){
var statearr_34876_34947 = state_34823__$1;
(statearr_34876_34947[(1)] = (46));

} else {
var statearr_34877_34948 = state_34823__$1;
(statearr_34877_34948[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (11))){
var inst_34713 = (state_34823[(12)]);
var inst_34710 = (state_34823[(2)]);
var inst_34711 = fluree.db.util.async.throw_err(inst_34710);
var inst_34712 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_34711);
var inst_34713__$1 = cljs.core.not_empty(inst_34712);
var state_34823__$1 = (function (){var statearr_34879 = state_34823;
(statearr_34879[(12)] = inst_34713__$1);

return statearr_34879;
})();
if(cljs.core.truth_(inst_34713__$1)){
var statearr_34880_34949 = state_34823__$1;
(statearr_34880_34949[(1)] = (12));

} else {
var statearr_34881_34950 = state_34823__$1;
(statearr_34881_34950[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (9))){
var inst_34698 = (state_34823[(32)]);
var inst_34688 = (state_34823[(24)]);
var inst_34697 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34688,(0),null);
var inst_34698__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_34688,(1),null);
var inst_34699 = cljs.core.__destructure_map(inst_34698__$1);
var inst_34700 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34699,cljs.core.cst$kw$offset);
var inst_34701 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34699,cljs.core.cst$kw$limit);
var inst_34702 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34699,cljs.core.cst$kw$as);
var inst_34703 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34699,cljs.core.cst$kw$name);
var inst_34704 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34699,cljs.core.cst$kw$p);
var inst_34705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34706 = [subject_id,inst_34697];
var inst_34707 = (new cljs.core.PersistentVector(null,2,(5),inst_34705,inst_34706,null));
var inst_34708 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_34707);
var state_34823__$1 = (function (){var statearr_34882 = state_34823;
(statearr_34882[(32)] = inst_34698__$1);

(statearr_34882[(30)] = inst_34703);

(statearr_34882[(8)] = inst_34700);

(statearr_34882[(17)] = inst_34704);

(statearr_34882[(11)] = inst_34702);

(statearr_34882[(9)] = inst_34701);

return statearr_34882;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34823__$1,(11),inst_34708);
} else {
if((state_val_34824 === (5))){
var _ = (function (){var statearr_34883 = state_34823;
(statearr_34883[(4)] = cljs.core.rest((state_34823[(4)])));

return statearr_34883;
})();
var state_34823__$1 = state_34823;
var ex34878 = (state_34823__$1[(2)]);
var statearr_34884_34951 = state_34823__$1;
(statearr_34884_34951[(5)] = ex34878);


if((ex34878 instanceof Error)){
var statearr_34885_34952 = state_34823__$1;
(statearr_34885_34952[(1)] = (4));

(statearr_34885_34952[(5)] = null);

} else {
throw ex34878;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (14))){
var inst_34717 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
if(cljs.core.truth_(inst_34717)){
var statearr_34886_34953 = state_34823__$1;
(statearr_34886_34953[(1)] = (15));

} else {
var statearr_34887_34954 = state_34823__$1;
(statearr_34887_34954[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (45))){
var inst_34737 = (state_34823[(10)]);
var inst_34789 = (state_34823[(2)]);
var inst_34790 = fluree.db.util.async.throw_err(inst_34789);
var inst_34791 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34737,inst_34790);
var state_34823__$1 = state_34823;
var statearr_34888_34955 = state_34823__$1;
(statearr_34888_34955[(2)] = inst_34791);

(statearr_34888_34955[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (26))){
var inst_34737 = (state_34823[(10)]);
var state_34823__$1 = state_34823;
var statearr_34889_34956 = state_34823__$1;
(statearr_34889_34956[(2)] = inst_34737);

(statearr_34889_34956[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (16))){
var state_34823__$1 = state_34823;
var statearr_34890_34957 = state_34823__$1;
(statearr_34890_34957[(2)] = null);

(statearr_34890_34957[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (38))){
var inst_34773 = (state_34823[(21)]);
var inst_34698 = (state_34823[(32)]);
var inst_34772 = (state_34823[(2)]);
var inst_34773__$1 = fluree.db.util.async.throw_err(inst_34772);
var inst_34774 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34775 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_34776 = (new cljs.core.PersistentVector(null,4,(5),inst_34774,inst_34775,null));
var inst_34777 = cljs.core.select_keys(inst_34698,inst_34776);
var inst_34778 = cljs.core.empty_QMARK_(inst_34773__$1);
var state_34823__$1 = (function (){var statearr_34891 = state_34823;
(statearr_34891[(21)] = inst_34773__$1);

(statearr_34891[(22)] = inst_34777);

return statearr_34891;
})();
if(inst_34778){
var statearr_34892_34958 = state_34823__$1;
(statearr_34892_34958[(1)] = (39));

} else {
var statearr_34893_34959 = state_34823__$1;
(statearr_34893_34959[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (30))){
var inst_34700 = (state_34823[(8)]);
var state_34823__$1 = state_34823;
var statearr_34894_34960 = state_34823__$1;
(statearr_34894_34960[(2)] = inst_34700);

(statearr_34894_34960[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (10))){
var inst_34816 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34895_34961 = state_34823__$1;
(statearr_34895_34961[(2)] = inst_34816);

(statearr_34895_34961[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (18))){
var inst_34743 = (state_34823[(31)]);
var inst_34735 = (state_34823[(20)]);
var inst_34745 = (state_34823[(7)]);
var inst_34742 = cljs.core.seq(inst_34735);
var inst_34743__$1 = cljs.core.first(inst_34742);
var inst_34744 = cljs.core.next(inst_34742);
var inst_34745__$1 = cljs.core.not(inst_34743__$1);
var state_34823__$1 = (function (){var statearr_34896 = state_34823;
(statearr_34896[(31)] = inst_34743__$1);

(statearr_34896[(7)] = inst_34745__$1);

(statearr_34896[(19)] = inst_34744);

return statearr_34896;
})();
if(inst_34745__$1){
var statearr_34897_34962 = state_34823__$1;
(statearr_34897_34962[(1)] = (20));

} else {
var statearr_34898_34963 = state_34823__$1;
(statearr_34898_34963[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (42))){
var inst_34773 = (state_34823[(21)]);
var inst_34782 = cljs.core.count(inst_34773);
var inst_34783 = fluree.db.query.fql.add_fuel(fuel,inst_34782,max_fuel);
var state_34823__$1 = state_34823;
var statearr_34899_34964 = state_34823__$1;
(statearr_34899_34964[(2)] = inst_34783);

(statearr_34899_34964[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (37))){
var inst_34798 = (state_34823[(2)]);
var state_34823__$1 = state_34823;
var statearr_34900_34965 = state_34823__$1;
(statearr_34900_34965[(2)] = inst_34798);

(statearr_34900_34965[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (8))){
var inst_34682 = (state_34823[(15)]);
var state_34823__$1 = state_34823;
var statearr_34901_34966 = state_34823__$1;
(statearr_34901_34966[(2)] = inst_34682);

(statearr_34901_34966[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34824 === (49))){
var inst_34703 = (state_34823[(30)]);
var state_34823__$1 = state_34823;
var statearr_34902_34967 = state_34823__$1;
(statearr_34902_34967[(2)] = inst_34703);

(statearr_34902_34967[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____0 = (function (){
var statearr_34903 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34903[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__);

(statearr_34903[(1)] = (1));

return statearr_34903;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____1 = (function (state_34823){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_34823);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e34904){var ex__10753__auto__ = e34904;
var statearr_34905_34968 = state_34823;
(statearr_34905_34968[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_34823[(4)]))){
var statearr_34906_34969 = state_34823;
(statearr_34906_34969[(1)] = cljs.core.first((state_34823[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__34970 = state_34823;
state_34823 = G__34970;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__ = function(state_34823){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____1.call(this,state_34823);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_34907 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_34907[(6)] = c__10876__auto__);

return statearr_34907;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__34971 = select_spec;
var map__34971__$1 = cljs.core.__destructure_map(map__34971);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34971__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34971__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_35085){
var state_val_35086 = (state_35085[(1)]);
if((state_val_35086 === (7))){
var inst_34997 = flakes;
var inst_34998 = cljs.core.seq(inst_34997);
var inst_34999 = cljs.core.first(inst_34998);
var inst_35000 = cljs.core.next(inst_34998);
var inst_35001 = cljs.core.PersistentVector.EMPTY;
var inst_35002 = inst_34997;
var inst_35003 = (0);
var inst_35004 = inst_35001;
var state_35085__$1 = (function (){var statearr_35087 = state_35085;
(statearr_35087[(7)] = inst_35004);

(statearr_35087[(8)] = inst_34999);

(statearr_35087[(9)] = inst_35003);

(statearr_35087[(10)] = inst_35002);

(statearr_35087[(11)] = inst_35000);

return statearr_35087;
})();
var statearr_35088_35154 = state_35085__$1;
(statearr_35088_35154[(2)] = null);

(statearr_35088_35154[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (20))){
var state_35085__$1 = state_35085;
var statearr_35089_35155 = state_35085__$1;
(statearr_35089_35155[(2)] = results);

(statearr_35089_35155[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (27))){
var state_35085__$1 = state_35085;
var statearr_35090_35156 = state_35085__$1;
(statearr_35090_35156[(2)] = null);

(statearr_35090_35156[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (1))){
var state_35085__$1 = state_35085;
var statearr_35091_35157 = state_35085__$1;
(statearr_35091_35157[(2)] = null);

(statearr_35091_35157[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (24))){
var state_35085__$1 = state_35085;
var statearr_35092_35158 = state_35085__$1;
(statearr_35092_35158[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (39))){
var inst_35004 = (state_35085[(7)]);
var inst_35011 = (state_35085[(12)]);
var inst_35066 = (state_35085[(13)]);
var inst_35069 = (state_35085[(2)]);
var inst_35070 = fluree.db.util.async.throw_err(inst_35069);
var inst_35071 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35004,inst_35070);
var inst_35002 = inst_35011;
var inst_35003 = inst_35066;
var inst_35004__$1 = inst_35071;
var state_35085__$1 = (function (){var statearr_35094 = state_35085;
(statearr_35094[(7)] = inst_35004__$1);

(statearr_35094[(9)] = inst_35003);

(statearr_35094[(10)] = inst_35002);

return statearr_35094;
})();
var statearr_35095_35159 = state_35085__$1;
(statearr_35095_35159[(2)] = null);

(statearr_35095_35159[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (4))){
var inst_34972 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35096_35160 = state_35085__$1;
(statearr_35096_35160[(2)] = inst_34972);

(statearr_35096_35160[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (15))){
var inst_34985 = (state_35085[(14)]);
var state_35085__$1 = state_35085;
var statearr_35097_35161 = state_35085__$1;
(statearr_35097_35161[(2)] = inst_34985);

(statearr_35097_35161[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (21))){
var inst_34981 = (state_35085[(15)]);
var state_35085__$1 = state_35085;
if(cljs.core.truth_(inst_34981)){
var statearr_35098_35162 = state_35085__$1;
(statearr_35098_35162[(1)] = (23));

} else {
var statearr_35099_35163 = state_35085__$1;
(statearr_35099_35163[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (31))){
var inst_35049 = (state_35085[(16)]);
var state_35085__$1 = state_35085;
var statearr_35100_35164 = state_35085__$1;
(statearr_35100_35164[(2)] = inst_35049);

(statearr_35100_35164[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (32))){
var inst_35041 = (state_35085[(17)]);
var inst_35055 = (state_35085[(2)]);
var state_35085__$1 = (function (){var statearr_35101 = state_35085;
(statearr_35101[(18)] = inst_35055);

return statearr_35101;
})();
if(cljs.core.truth_(inst_35041)){
var statearr_35102_35165 = state_35085__$1;
(statearr_35102_35165[(1)] = (33));

} else {
var statearr_35103_35166 = state_35085__$1;
(statearr_35103_35166[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (33))){
var inst_35041 = (state_35085[(17)]);
var state_35085__$1 = state_35085;
var statearr_35104_35167 = state_35085__$1;
(statearr_35104_35167[(2)] = inst_35041);

(statearr_35104_35167[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (13))){
var inst_35021 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
if(cljs.core.truth_(inst_35021)){
var statearr_35106_35168 = state_35085__$1;
(statearr_35106_35168[(1)] = (17));

} else {
var statearr_35107_35169 = state_35085__$1;
(statearr_35107_35169[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (22))){
var inst_35038 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35108_35170 = state_35085__$1;
(statearr_35108_35170[(2)] = inst_35038);

(statearr_35108_35170[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (36))){
var inst_35004 = (state_35085[(7)]);
var inst_35003 = (state_35085[(9)]);
var inst_35011 = (state_35085[(12)]);
var inst_35063 = (inst_35003 + (1));
var tmp35105 = inst_35004;
var inst_35002 = inst_35011;
var inst_35003__$1 = inst_35063;
var inst_35004__$1 = tmp35105;
var state_35085__$1 = (function (){var statearr_35109 = state_35085;
(statearr_35109[(7)] = inst_35004__$1);

(statearr_35109[(9)] = inst_35003__$1);

(statearr_35109[(10)] = inst_35002);

return statearr_35109;
})();
var statearr_35110_35171 = state_35085__$1;
(statearr_35110_35171[(2)] = null);

(statearr_35110_35171[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (29))){
var inst_35048 = (state_35085[(2)]);
var inst_35049 = fluree.db.util.async.throw_err(inst_35048);
var state_35085__$1 = (function (){var statearr_35111 = state_35085;
(statearr_35111[(16)] = inst_35049);

return statearr_35111;
})();
if(cljs.core.truth_(fuel)){
var statearr_35112_35172 = state_35085__$1;
(statearr_35112_35172[(1)] = (30));

} else {
var statearr_35113_35173 = state_35085__$1;
(statearr_35113_35173[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (6))){
var state_35085__$1 = state_35085;
var statearr_35114_35174 = state_35085__$1;
(statearr_35114_35174[(2)] = results);

(statearr_35114_35174[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (28))){
var inst_35034 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35115_35175 = state_35085__$1;
(statearr_35115_35175[(2)] = inst_35034);

(statearr_35115_35175[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (25))){
var inst_35036 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35116_35176 = state_35085__$1;
(statearr_35116_35176[(2)] = inst_35036);

(statearr_35116_35176[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (34))){
var inst_35055 = (state_35085[(18)]);
var inst_35058 = cljs.core.empty_QMARK_(inst_35055);
var state_35085__$1 = state_35085;
var statearr_35117_35177 = state_35085__$1;
(statearr_35117_35177[(2)] = inst_35058);

(statearr_35117_35177[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (17))){
var inst_35004 = (state_35085[(7)]);
var inst_35023 = cljs.core.empty_QMARK_(inst_35004);
var state_35085__$1 = state_35085;
if(inst_35023){
var statearr_35118_35178 = state_35085__$1;
(statearr_35118_35178[(1)] = (20));

} else {
var statearr_35119_35179 = state_35085__$1;
(statearr_35119_35179[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (3))){
var inst_35083 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35085__$1,inst_35083);
} else {
if((state_val_35086 === (12))){
var inst_34985 = (state_35085[(14)]);
var state_35085__$1 = state_35085;
if(cljs.core.truth_(inst_34985)){
var statearr_35120_35180 = state_35085__$1;
(statearr_35120_35180[(1)] = (14));

} else {
var statearr_35121_35181 = state_35085__$1;
(statearr_35121_35181[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (2))){
var _ = (function (){var statearr_35122 = state_35085;
(statearr_35122[(4)] = cljs.core.cons((5),(state_35085[(4)])));

return statearr_35122;
})();
var inst_34979 = select_spec;
var inst_34980 = cljs.core.__destructure_map(inst_34979);
var inst_34981 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34980,cljs.core.cst$kw$multi_QMARK_);
var inst_34982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34980,cljs.core.cst$kw$as);
var inst_34983 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34980,cljs.core.cst$kw$recur_DASH_seen);
var inst_34984 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34980,cljs.core.cst$kw$recur_DASH_depth);
var inst_34985 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34980,cljs.core.cst$kw$limit);
var inst_34986 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_34987 = (inst_34984 > inst_34986);
var state_35085__$1 = (function (){var statearr_35123 = state_35085;
(statearr_35123[(19)] = inst_34983);

(statearr_35123[(14)] = inst_34985);

(statearr_35123[(15)] = inst_34981);

(statearr_35123[(20)] = inst_34982);

return statearr_35123;
})();
if(cljs.core.truth_(inst_34987)){
var statearr_35124_35182 = state_35085__$1;
(statearr_35124_35182[(1)] = (6));

} else {
var statearr_35125_35183 = state_35085__$1;
(statearr_35125_35183[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (23))){
var inst_35004 = (state_35085[(7)]);
var inst_34982 = (state_35085[(20)]);
var inst_35027 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34982,inst_35004);
var state_35085__$1 = state_35085;
var statearr_35126_35184 = state_35085__$1;
(statearr_35126_35184[(2)] = inst_35027);

(statearr_35126_35184[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (35))){
var inst_35010 = (state_35085[(21)]);
var inst_35060 = (state_35085[(2)]);
var inst_35061 = fluree.db.query.fql.recur_select_spec(select_spec,inst_35010);
var state_35085__$1 = (function (){var statearr_35127 = state_35085;
(statearr_35127[(22)] = inst_35061);

return statearr_35127;
})();
if(cljs.core.truth_(inst_35060)){
var statearr_35128_35185 = state_35085__$1;
(statearr_35128_35185[(1)] = (36));

} else {
var statearr_35129_35186 = state_35085__$1;
(statearr_35129_35186[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (19))){
var inst_35076 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35130_35187 = state_35085__$1;
(statearr_35130_35187[(2)] = inst_35076);

(statearr_35130_35187[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (11))){
var inst_35012 = (state_35085[(23)]);
var state_35085__$1 = state_35085;
var statearr_35132_35188 = state_35085__$1;
(statearr_35132_35188[(2)] = inst_35012);

(statearr_35132_35188[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (9))){
var inst_35002 = (state_35085[(10)]);
var inst_35010 = (state_35085[(21)]);
var inst_35012 = (state_35085[(23)]);
var inst_35009 = cljs.core.seq(inst_35002);
var inst_35010__$1 = cljs.core.first(inst_35009);
var inst_35011 = cljs.core.next(inst_35009);
var inst_35012__$1 = cljs.core.not(inst_35010__$1);
var state_35085__$1 = (function (){var statearr_35133 = state_35085;
(statearr_35133[(21)] = inst_35010__$1);

(statearr_35133[(23)] = inst_35012__$1);

(statearr_35133[(12)] = inst_35011);

return statearr_35133;
})();
if(inst_35012__$1){
var statearr_35134_35189 = state_35085__$1;
(statearr_35134_35189[(1)] = (11));

} else {
var statearr_35135_35190 = state_35085__$1;
(statearr_35135_35190[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (5))){
var _ = (function (){var statearr_35136 = state_35085;
(statearr_35136[(4)] = cljs.core.rest((state_35085[(4)])));

return statearr_35136;
})();
var state_35085__$1 = state_35085;
var ex35131 = (state_35085__$1[(2)]);
var statearr_35137_35191 = state_35085__$1;
(statearr_35137_35191[(5)] = ex35131);


if((ex35131 instanceof Error)){
var statearr_35138_35192 = state_35085__$1;
(statearr_35138_35192[(1)] = (4));

(statearr_35138_35192[(5)] = null);

} else {
throw ex35131;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (14))){
var inst_35003 = (state_35085[(9)]);
var inst_34985 = (state_35085[(14)]);
var inst_35016 = (inst_35003 < inst_34985);
var state_35085__$1 = state_35085;
var statearr_35139_35193 = state_35085__$1;
(statearr_35139_35193[(2)] = inst_35016);

(statearr_35139_35193[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (26))){
var inst_35004 = (state_35085[(7)]);
var inst_34982 = (state_35085[(20)]);
var inst_35030 = cljs.core.first(inst_35004);
var inst_35031 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_34982,inst_35030);
var state_35085__$1 = state_35085;
var statearr_35140_35194 = state_35085__$1;
(statearr_35140_35194[(2)] = inst_35031);

(statearr_35140_35194[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (16))){
var inst_35019 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35141_35195 = state_35085__$1;
(statearr_35141_35195[(2)] = inst_35019);

(statearr_35141_35195[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (38))){
var inst_35074 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35142_35196 = state_35085__$1;
(statearr_35142_35196[(2)] = inst_35074);

(statearr_35142_35196[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (30))){
var inst_35049 = (state_35085[(16)]);
var inst_35051 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_35052 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35051,inst_35049);
var state_35085__$1 = state_35085;
var statearr_35143_35197 = state_35085__$1;
(statearr_35143_35197[(2)] = inst_35052);

(statearr_35143_35197[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (10))){
var inst_35078 = (state_35085[(2)]);
var state_35085__$1 = state_35085;
var statearr_35144_35198 = state_35085__$1;
(statearr_35144_35198[(2)] = inst_35078);

(statearr_35144_35198[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35086 === (18))){
var inst_34983 = (state_35085[(19)]);
var inst_35010 = (state_35085[(21)]);
var inst_35040 = inst_35010.o;
var inst_35041 = cljs.core.contains_QMARK_(inst_34983,inst_35040);
var inst_35043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35044 = [inst_35040];
var inst_35045 = (new cljs.core.PersistentVector(null,1,(5),inst_35043,inst_35044,null));
var inst_35046 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35045);
var state_35085__$1 = (function (){var statearr_35145 = state_35085;
(statearr_35145[(17)] = inst_35041);

return statearr_35145;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35085__$1,(29),inst_35046);
} else {
if((state_val_35086 === (37))){
var inst_35061 = (state_35085[(22)]);
var inst_35003 = (state_35085[(9)]);
var inst_35055 = (state_35085[(18)]);
var inst_35066 = (inst_35003 + (1));
var inst_35067 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_35061,inst_35055) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_35061,inst_35055));
var state_35085__$1 = (function (){var statearr_35146 = state_35085;
(statearr_35146[(13)] = inst_35066);

return statearr_35146;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35085__$1,(39),inst_35067);
} else {
if((state_val_35086 === (8))){
var inst_35080 = (state_35085[(2)]);
var _ = (function (){var statearr_35147 = state_35085;
(statearr_35147[(4)] = cljs.core.rest((state_35085[(4)])));

return statearr_35147;
})();
var state_35085__$1 = state_35085;
var statearr_35148_35199 = state_35085__$1;
(statearr_35148_35199[(2)] = inst_35080);

(statearr_35148_35199[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____0 = (function (){
var statearr_35149 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35149[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__);

(statearr_35149[(1)] = (1));

return statearr_35149;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____1 = (function (state_35085){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_35085);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e35150){var ex__10753__auto__ = e35150;
var statearr_35151_35200 = state_35085;
(statearr_35151_35200[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_35085[(4)]))){
var statearr_35152_35201 = state_35085;
(statearr_35152_35201[(1)] = cljs.core.first((state_35085[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__35202 = state_35085;
state_35085 = G__35202;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__ = function(state_35085){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____1.call(this,state_35085);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_35153 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_35153[(6)] = c__10876__auto__);

return statearr_35153;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_35383){
var state_val_35384 = (state_35383[(1)]);
if((state_val_35384 === (7))){
var state_35383__$1 = state_35383;
var statearr_35385_35471 = state_35383__$1;
(statearr_35385_35471[(2)] = null);

(statearr_35385_35471[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (20))){
var inst_35241 = cljs.core.PersistentHashMap.EMPTY;
var state_35383__$1 = state_35383;
var statearr_35386_35472 = state_35383__$1;
(statearr_35386_35472[(2)] = inst_35241);

(statearr_35386_35472[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (27))){
var inst_35243 = (state_35383[(7)]);
var inst_35259 = (state_35383[(8)]);
var inst_35223 = (state_35383[(9)]);
var inst_35229 = (state_35383[(10)]);
var inst_35362 = (state_35383[(2)]);
var inst_35363 = (function (){var top_level_subject = inst_35223;
var select_spec = inst_35229;
var base_acc = inst_35243;
var acc_PLUS_refs = inst_35259;
var result = inst_35362;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_35364 = cljs.core.PersistentVector.EMPTY;
var inst_35365 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35229);
var inst_35366 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_35365);
var inst_35367 = cljs.core.vals(inst_35366);
var inst_35368 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35229);
var inst_35369 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_35368);
var inst_35370 = cljs.core.vals(inst_35369);
var inst_35371 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35367,inst_35370);
var inst_35372 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35363,inst_35364,inst_35371);
var inst_35374 = (function (){var top_level_subject = inst_35223;
var select_spec = inst_35229;
var base_acc = inst_35243;
var acc_PLUS_refs = inst_35259;
var result = inst_35362;
var sort_preds = inst_35372;
return (function (acc,p__35373){
var vec__35387 = p__35373;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35387,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35387,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35387,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35387,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_35375 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_35374,inst_35362,inst_35372);
var state_35383__$1 = state_35383;
var statearr_35390_35473 = state_35383__$1;
(statearr_35390_35473[(2)] = inst_35375);

(statearr_35390_35473[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (1))){
var state_35383__$1 = state_35383;
var statearr_35391_35474 = state_35383__$1;
(statearr_35391_35474[(2)] = null);

(statearr_35391_35474[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (24))){
var inst_35259 = (state_35383[(8)]);
var inst_35259__$1 = (state_35383[(2)]);
var inst_35260 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,flakes);
var inst_35261 = cljs.core.PersistentHashMap.EMPTY;
var inst_35262 = inst_35260;
var inst_35263 = inst_35259__$1;
var inst_35264 = inst_35261;
var state_35383__$1 = (function (){var statearr_35392 = state_35383;
(statearr_35392[(11)] = inst_35264);

(statearr_35392[(12)] = inst_35262);

(statearr_35392[(8)] = inst_35259__$1);

(statearr_35392[(13)] = inst_35263);

return statearr_35392;
})();
var statearr_35393_35475 = state_35383__$1;
(statearr_35393_35475[(2)] = null);

(statearr_35393_35475[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (39))){
var inst_35279 = (state_35383[(14)]);
var inst_35229 = (state_35383[(10)]);
var inst_35272 = (state_35383[(15)]);
var inst_35263 = (state_35383[(13)]);
var inst_35308 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35309 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_35263,inst_35229,inst_35272,inst_35279,false);
var state_35383__$1 = (function (){var statearr_35394 = state_35383;
(statearr_35394[(16)] = inst_35308);

return statearr_35394;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35383__$1,(42),inst_35309);
} else {
if((state_val_35384 === (46))){
var inst_35264 = (state_35383[(11)]);
var inst_35262 = (state_35383[(12)]);
var inst_35272 = (state_35383[(15)]);
var inst_35326 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35327 = [cljs.core.cst$kw$_id];
var inst_35328 = cljs.core.first(inst_35272);
var inst_35329 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_35328);
var inst_35330 = [inst_35329];
var inst_35331 = cljs.core.PersistentHashMap.fromArrays(inst_35327,inst_35330);
var inst_35332 = cljs.core.rest(inst_35262);
var inst_35333 = [inst_35331,inst_35332,inst_35264];
var inst_35334 = (new cljs.core.PersistentVector(null,3,(5),inst_35326,inst_35333,null));
var state_35383__$1 = state_35383;
var statearr_35395_35476 = state_35383__$1;
(statearr_35395_35476[(2)] = inst_35334);

(statearr_35395_35476[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (4))){
var inst_35203 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35396_35477 = state_35383__$1;
(statearr_35396_35477[(2)] = inst_35203);

(statearr_35396_35477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (15))){
var inst_35230 = (state_35383[(17)]);
var inst_35229 = (state_35383[(10)]);
var inst_35229__$1 = (state_35383[(2)]);
var inst_35230__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35229__$1);
var state_35383__$1 = (function (){var statearr_35397 = state_35383;
(statearr_35397[(17)] = inst_35230__$1);

(statearr_35397[(10)] = inst_35229__$1);

return statearr_35397;
})();
if(cljs.core.truth_(inst_35230__$1)){
var statearr_35398_35478 = state_35383__$1;
(statearr_35398_35478[(1)] = (16));

} else {
var statearr_35399_35479 = state_35383__$1;
(statearr_35399_35479[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (48))){
var inst_35345 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35400_35480 = state_35383__$1;
(statearr_35400_35480[(2)] = inst_35345);

(statearr_35400_35480[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (50))){
var state_35383__$1 = state_35383;
var statearr_35401_35481 = state_35383__$1;
(statearr_35401_35481[(2)] = null);

(statearr_35401_35481[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (21))){
var inst_35229 = (state_35383[(10)]);
var inst_35243 = (state_35383[(2)]);
var inst_35244 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35245 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_35246 = (new cljs.core.PersistentVector(null,2,(5),inst_35244,inst_35245,null));
var inst_35247 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35229,inst_35246);
var state_35383__$1 = (function (){var statearr_35402 = state_35383;
(statearr_35402[(7)] = inst_35243);

return statearr_35402;
})();
if(cljs.core.truth_(inst_35247)){
var statearr_35403_35482 = state_35383__$1;
(statearr_35403_35482[(1)] = (22));

} else {
var statearr_35404_35483 = state_35383__$1;
(statearr_35404_35483[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (31))){
var inst_35278 = (state_35383[(18)]);
var inst_35272 = (state_35383[(15)]);
var inst_35263 = (state_35383[(13)]);
var inst_35282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35283 = fluree.db.query.fql.flake__GT_recur(db,inst_35272,inst_35278,inst_35263,fuel,max_fuel,cache);
var state_35383__$1 = (function (){var statearr_35405 = state_35383;
(statearr_35405[(19)] = inst_35282);

return statearr_35405;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35383__$1,(34),inst_35283);
} else {
if((state_val_35384 === (32))){
var inst_35278 = (state_35383[(18)]);
var state_35383__$1 = state_35383;
if(cljs.core.truth_(inst_35278)){
var statearr_35406_35484 = state_35383__$1;
(statearr_35406_35484[(1)] = (35));

} else {
var statearr_35407_35485 = state_35383__$1;
(statearr_35407_35485[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (40))){
var inst_35319 = (state_35383[(20)]);
var inst_35229 = (state_35383[(10)]);
var inst_35318 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_35229);
var inst_35319__$1 = cljs.core.empty_QMARK_(inst_35318);
var state_35383__$1 = (function (){var statearr_35408 = state_35383;
(statearr_35408[(20)] = inst_35319__$1);

return statearr_35408;
})();
if(inst_35319__$1){
var statearr_35409_35486 = state_35383__$1;
(statearr_35409_35486[(1)] = (43));

} else {
var statearr_35410_35487 = state_35383__$1;
(statearr_35410_35487[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (33))){
var inst_35272 = (state_35383[(15)]);
var inst_35351 = (state_35383[(2)]);
var inst_35352 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35351,(0),null);
var inst_35353 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35351,(1),null);
var inst_35354 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35351,(2),null);
var inst_35355 = cljs.core.first(inst_35272);
var inst_35356 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_35355);
var inst_35357 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_35352,cljs.core.cst$kw$_id,inst_35356);
var inst_35262 = inst_35353;
var inst_35263 = inst_35357;
var inst_35264 = inst_35354;
var state_35383__$1 = (function (){var statearr_35411 = state_35383;
(statearr_35411[(11)] = inst_35264);

(statearr_35411[(12)] = inst_35262);

(statearr_35411[(13)] = inst_35263);

return statearr_35411;
})();
var statearr_35412_35488 = state_35383__$1;
(statearr_35412_35488[(2)] = null);

(statearr_35412_35488[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (13))){
var inst_35223 = (state_35383[(9)]);
var inst_35226 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_35223);
var state_35383__$1 = state_35383;
var statearr_35413_35489 = state_35383__$1;
(statearr_35413_35489[(2)] = inst_35226);

(statearr_35413_35489[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (22))){
var inst_35229 = (state_35383[(10)]);
var inst_35249 = cljs.core.first(flakes);
var inst_35250 = fluree.db.query.fql.s(inst_35249);
var inst_35251 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_35229);
var inst_35252 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_35250,inst_35251);
var state_35383__$1 = state_35383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35383__$1,(25),inst_35252);
} else {
if((state_val_35384 === (36))){
var inst_35229 = (state_35383[(10)]);
var inst_35306 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35229);
var state_35383__$1 = state_35383;
if(cljs.core.truth_(inst_35306)){
var statearr_35414_35490 = state_35383__$1;
(statearr_35414_35490[(1)] = (39));

} else {
var statearr_35415_35491 = state_35383__$1;
(statearr_35415_35491[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (41))){
var inst_35347 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35416_35492 = state_35383__$1;
(statearr_35416_35492[(2)] = inst_35347);

(statearr_35416_35492[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (43))){
var inst_35229 = (state_35383[(10)]);
var inst_35321 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35229);
var state_35383__$1 = state_35383;
var statearr_35417_35493 = state_35383__$1;
(statearr_35417_35493[(2)] = inst_35321);

(statearr_35417_35493[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (29))){
var inst_35278 = (state_35383[(18)]);
var inst_35262 = (state_35383[(12)]);
var inst_35229 = (state_35383[(10)]);
var inst_35272 = (state_35383[(15)]);
var inst_35272__$1 = cljs.core.first(inst_35262);
var inst_35273 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35274 = cljs.core.first(inst_35272__$1);
var inst_35275 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_35274);
var inst_35276 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_35275];
var inst_35277 = (new cljs.core.PersistentVector(null,3,(5),inst_35273,inst_35276,null));
var inst_35278__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_35229,inst_35277);
var inst_35279 = fluree.db.query.fql.component_follow_QMARK_(inst_35278__$1,inst_35229);
var inst_35280 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_35278__$1);
var state_35383__$1 = (function (){var statearr_35418 = state_35383;
(statearr_35418[(18)] = inst_35278__$1);

(statearr_35418[(14)] = inst_35279);

(statearr_35418[(15)] = inst_35272__$1);

return statearr_35418;
})();
if(cljs.core.truth_(inst_35280)){
var statearr_35419_35494 = state_35383__$1;
(statearr_35419_35494[(1)] = (31));

} else {
var statearr_35420_35495 = state_35383__$1;
(statearr_35420_35495[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (44))){
var inst_35319 = (state_35383[(20)]);
var state_35383__$1 = state_35383;
var statearr_35421_35496 = state_35383__$1;
(statearr_35421_35496[(2)] = inst_35319);

(statearr_35421_35496[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (6))){
var state_35383__$1 = state_35383;
var statearr_35422_35497 = state_35383__$1;
(statearr_35422_35497[(2)] = null);

(statearr_35422_35497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (28))){
var inst_35263 = (state_35383[(13)]);
var state_35383__$1 = state_35383;
var statearr_35423_35498 = state_35383__$1;
(statearr_35423_35498[(2)] = inst_35263);

(statearr_35423_35498[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (51))){
var inst_35343 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35424_35499 = state_35383__$1;
(statearr_35424_35499[(2)] = inst_35343);

(statearr_35424_35499[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (25))){
var inst_35243 = (state_35383[(7)]);
var inst_35254 = (state_35383[(2)]);
var inst_35255 = fluree.db.util.async.throw_err(inst_35254);
var inst_35256 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35243,inst_35255], 0));
var state_35383__$1 = state_35383;
var statearr_35425_35500 = state_35383__$1;
(statearr_35425_35500[(2)] = inst_35256);

(statearr_35425_35500[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (34))){
var inst_35264 = (state_35383[(11)]);
var inst_35282 = (state_35383[(19)]);
var inst_35262 = (state_35383[(12)]);
var inst_35285 = (state_35383[(2)]);
var inst_35286 = fluree.db.util.async.throw_err(inst_35285);
var inst_35287 = cljs.core.rest(inst_35262);
var inst_35288 = [inst_35286,inst_35287,inst_35264];
var inst_35289 = (new cljs.core.PersistentVector(null,3,(5),inst_35282,inst_35288,null));
var state_35383__$1 = state_35383;
var statearr_35426_35501 = state_35383__$1;
(statearr_35426_35501[(2)] = inst_35289);

(statearr_35426_35501[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (17))){
var inst_35229 = (state_35383[(10)]);
var inst_35233 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_35229);
var state_35383__$1 = state_35383;
var statearr_35428_35502 = state_35383__$1;
(statearr_35428_35502[(2)] = inst_35233);

(statearr_35428_35502[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (3))){
var inst_35381 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35383__$1,inst_35381);
} else {
if((state_val_35384 === (12))){
var _ = (function (){var statearr_35429 = state_35383;
(statearr_35429[(4)] = cljs.core.rest((state_35383[(4)])));

return statearr_35429;
})();
var state_35383__$1 = state_35383;
var ex35427 = (state_35383__$1[(2)]);
var statearr_35430_35503 = state_35383__$1;
(statearr_35430_35503[(5)] = ex35427);


var statearr_35431_35504 = state_35383__$1;
(statearr_35431_35504[(1)] = (11));

(statearr_35431_35504[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (2))){
var _ = (function (){var statearr_35432 = state_35383;
(statearr_35432[(4)] = cljs.core.cons((5),(state_35383[(4)])));

return statearr_35432;
})();
var inst_35209 = cljs.core.not_empty(flakes);
var state_35383__$1 = state_35383;
if(cljs.core.truth_(inst_35209)){
var statearr_35433_35505 = state_35383__$1;
(statearr_35433_35505[(1)] = (6));

} else {
var statearr_35434_35506 = state_35383__$1;
(statearr_35434_35506[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (23))){
var inst_35243 = (state_35383[(7)]);
var state_35383__$1 = state_35383;
var statearr_35435_35507 = state_35383__$1;
(statearr_35435_35507[(2)] = inst_35243);

(statearr_35435_35507[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (47))){
var state_35383__$1 = state_35383;
var statearr_35436_35508 = state_35383__$1;
(statearr_35436_35508[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (35))){
var inst_35278 = (state_35383[(18)]);
var inst_35264 = (state_35383[(11)]);
var inst_35279 = (state_35383[(14)]);
var inst_35272 = (state_35383[(15)]);
var inst_35263 = (state_35383[(13)]);
var inst_35295 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_35263,inst_35278,inst_35272,inst_35279,false,inst_35264);
var state_35383__$1 = state_35383;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35383__$1,(38),inst_35295);
} else {
if((state_val_35384 === (19))){
var inst_35223 = (state_35383[(9)]);
var inst_35237 = [cljs.core.cst$kw$_id];
var inst_35238 = [inst_35223];
var inst_35239 = cljs.core.PersistentHashMap.fromArrays(inst_35237,inst_35238);
var state_35383__$1 = state_35383;
var statearr_35438_35509 = state_35383__$1;
(statearr_35438_35509[(2)] = inst_35239);

(statearr_35438_35509[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (11))){
var inst_35211 = (state_35383[(2)]);
var inst_35212 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_35211], 0));
var inst_35213 = (function(){throw inst_35211})();
var state_35383__$1 = (function (){var statearr_35440 = state_35383;
(statearr_35440[(21)] = inst_35212);

return statearr_35440;
})();
var statearr_35441_35510 = state_35383__$1;
(statearr_35441_35510[(2)] = inst_35213);

(statearr_35441_35510[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (9))){
var _ = (function (){var statearr_35442 = state_35383;
(statearr_35442[(4)] = cljs.core.cons((12),(state_35383[(4)])));

return statearr_35442;
})();
var inst_35219 = cljs.core.first(flakes);
var inst_35220 = fluree.db.query.fql.s(inst_35219);
var ___$1 = (function (){var statearr_35443 = state_35383;
(statearr_35443[(4)] = cljs.core.rest((state_35383[(4)])));

return statearr_35443;
})();
var state_35383__$1 = state_35383;
var statearr_35444_35511 = state_35383__$1;
(statearr_35444_35511[(2)] = inst_35220);

(statearr_35444_35511[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (5))){
var _ = (function (){var statearr_35445 = state_35383;
(statearr_35445[(4)] = cljs.core.rest((state_35383[(4)])));

return statearr_35445;
})();
var state_35383__$1 = state_35383;
var ex35439 = (state_35383__$1[(2)]);
var statearr_35446_35512 = state_35383__$1;
(statearr_35446_35512[(5)] = ex35439);


if((ex35439 instanceof Error)){
var statearr_35447_35513 = state_35383__$1;
(statearr_35447_35513[(1)] = (4));

(statearr_35447_35513[(5)] = null);

} else {
throw ex35439;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (14))){
var state_35383__$1 = state_35383;
var statearr_35448_35514 = state_35383__$1;
(statearr_35448_35514[(2)] = base_select_spec);

(statearr_35448_35514[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (45))){
var inst_35324 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
if(cljs.core.truth_(inst_35324)){
var statearr_35449_35515 = state_35383__$1;
(statearr_35449_35515[(1)] = (46));

} else {
var statearr_35450_35516 = state_35383__$1;
(statearr_35450_35516[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (26))){
var inst_35262 = (state_35383[(12)]);
var inst_35266 = cljs.core.empty_QMARK_(inst_35262);
var state_35383__$1 = state_35383;
if(inst_35266){
var statearr_35451_35517 = state_35383__$1;
(statearr_35451_35517[(1)] = (28));

} else {
var statearr_35452_35518 = state_35383__$1;
(statearr_35452_35518[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (16))){
var inst_35230 = (state_35383[(17)]);
var state_35383__$1 = state_35383;
var statearr_35453_35519 = state_35383__$1;
(statearr_35453_35519[(2)] = inst_35230);

(statearr_35453_35519[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (38))){
var inst_35262 = (state_35383[(12)]);
var inst_35297 = (state_35383[(2)]);
var inst_35298 = fluree.db.util.async.throw_err(inst_35297);
var inst_35299 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35298,(0),null);
var inst_35300 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35298,(1),null);
var inst_35301 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35302 = cljs.core.rest(inst_35262);
var inst_35303 = [inst_35299,inst_35302,inst_35300];
var inst_35304 = (new cljs.core.PersistentVector(null,3,(5),inst_35301,inst_35303,null));
var state_35383__$1 = state_35383;
var statearr_35454_35520 = state_35383__$1;
(statearr_35454_35520[(2)] = inst_35304);

(statearr_35454_35520[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (30))){
var inst_35360 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35455_35521 = state_35383__$1;
(statearr_35455_35521[(2)] = inst_35360);

(statearr_35455_35521[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (10))){
var inst_35223 = (state_35383[(2)]);
var inst_35224 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_35383__$1 = (function (){var statearr_35456 = state_35383;
(statearr_35456[(9)] = inst_35223);

return statearr_35456;
})();
if(cljs.core.truth_(inst_35224)){
var statearr_35457_35522 = state_35383__$1;
(statearr_35457_35522[(1)] = (13));

} else {
var statearr_35458_35523 = state_35383__$1;
(statearr_35458_35523[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (18))){
var inst_35235 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
if(cljs.core.truth_(inst_35235)){
var statearr_35459_35524 = state_35383__$1;
(statearr_35459_35524[(1)] = (19));

} else {
var statearr_35460_35525 = state_35383__$1;
(statearr_35460_35525[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (42))){
var inst_35264 = (state_35383[(11)]);
var inst_35262 = (state_35383[(12)]);
var inst_35308 = (state_35383[(16)]);
var inst_35311 = (state_35383[(2)]);
var inst_35312 = fluree.db.util.async.throw_err(inst_35311);
var inst_35313 = cljs.core.first(inst_35312);
var inst_35314 = cljs.core.rest(inst_35262);
var inst_35315 = [inst_35313,inst_35314,inst_35264];
var inst_35316 = (new cljs.core.PersistentVector(null,3,(5),inst_35308,inst_35315,null));
var state_35383__$1 = state_35383;
var statearr_35461_35526 = state_35383__$1;
(statearr_35461_35526[(2)] = inst_35316);

(statearr_35461_35526[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (37))){
var inst_35349 = (state_35383[(2)]);
var state_35383__$1 = state_35383;
var statearr_35462_35527 = state_35383__$1;
(statearr_35462_35527[(2)] = inst_35349);

(statearr_35462_35527[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (8))){
var inst_35378 = (state_35383[(2)]);
var _ = (function (){var statearr_35463 = state_35383;
(statearr_35463[(4)] = cljs.core.rest((state_35383[(4)])));

return statearr_35463;
})();
var state_35383__$1 = state_35383;
var statearr_35464_35528 = state_35383__$1;
(statearr_35464_35528[(2)] = inst_35378);

(statearr_35464_35528[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35384 === (49))){
var inst_35264 = (state_35383[(11)]);
var inst_35262 = (state_35383[(12)]);
var inst_35263 = (state_35383[(13)]);
var inst_35337 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35338 = cljs.core.rest(inst_35262);
var inst_35339 = [inst_35263,inst_35338,inst_35264];
var inst_35340 = (new cljs.core.PersistentVector(null,3,(5),inst_35337,inst_35339,null));
var state_35383__$1 = state_35383;
var statearr_35465_35529 = state_35383__$1;
(statearr_35465_35529[(2)] = inst_35340);

(statearr_35465_35529[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____0 = (function (){
var statearr_35466 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35466[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__);

(statearr_35466[(1)] = (1));

return statearr_35466;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____1 = (function (state_35383){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_35383);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e35467){var ex__10753__auto__ = e35467;
var statearr_35468_35530 = state_35383;
(statearr_35468_35530[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_35383[(4)]))){
var statearr_35469_35531 = state_35383;
(statearr_35469_35531[(1)] = cljs.core.first((state_35383[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__35532 = state_35383;
state_35383 = G__35532;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__ = function(state_35383){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____1.call(this,state_35383);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_35470 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_35470[(6)] = c__10876__auto__);

return statearr_35470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__35535 = arguments.length;
switch (G__35535) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_35577){
var state_val_35578 = (state_35577[(1)]);
if((state_val_35578 === (7))){
var inst_35543 = (state_35577[(7)]);
var state_35577__$1 = state_35577;
var statearr_35579_35609 = state_35577__$1;
(statearr_35579_35609[(2)] = inst_35543);

(statearr_35579_35609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (1))){
var state_35577__$1 = state_35577;
var statearr_35580_35610 = state_35577__$1;
(statearr_35580_35610[(2)] = null);

(statearr_35580_35610[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (4))){
var inst_35536 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
var statearr_35581_35611 = state_35577__$1;
(statearr_35581_35611[(2)] = inst_35536);

(statearr_35581_35611[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (15))){
var inst_35571 = (state_35577[(2)]);
var inst_35572 = fluree.db.util.async.throw_err(inst_35571);
var _ = (function (){var statearr_35582 = state_35577;
(statearr_35582[(4)] = cljs.core.rest((state_35577[(4)])));

return statearr_35582;
})();
var state_35577__$1 = state_35577;
var statearr_35583_35612 = state_35577__$1;
(statearr_35583_35612[(2)] = inst_35572);

(statearr_35583_35612[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (13))){
var inst_35555 = (state_35577[(8)]);
var state_35577__$1 = state_35577;
var statearr_35584_35613 = state_35577__$1;
(statearr_35584_35613[(2)] = inst_35555);

(statearr_35584_35613[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (6))){
var inst_35543 = (state_35577[(7)]);
var inst_35545 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_35546 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35543,inst_35545);
var state_35577__$1 = state_35577;
var statearr_35585_35614 = state_35577__$1;
(statearr_35585_35614[(2)] = inst_35546);

(statearr_35585_35614[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (3))){
var inst_35575 = (state_35577[(2)]);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35577__$1,inst_35575);
} else {
if((state_val_35578 === (12))){
var inst_35555 = (state_35577[(8)]);
var inst_35557 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_35558 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35555,inst_35557);
var state_35577__$1 = state_35577;
var statearr_35586_35615 = state_35577__$1;
(statearr_35586_35615[(2)] = inst_35558);

(statearr_35586_35615[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (2))){
var _ = (function (){var statearr_35587 = state_35577;
(statearr_35587[(4)] = cljs.core.cons((5),(state_35577[(4)])));

return statearr_35587;
})();
var inst_35543 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_35577__$1 = (function (){var statearr_35588 = state_35577;
(statearr_35588[(7)] = inst_35543);

return statearr_35588;
})();
if(cljs.core.truth_(fuel)){
var statearr_35589_35616 = state_35577__$1;
(statearr_35589_35616[(1)] = (6));

} else {
var statearr_35590_35617 = state_35577__$1;
(statearr_35590_35617[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (11))){
var inst_35555 = (state_35577[(2)]);
var state_35577__$1 = (function (){var statearr_35592 = state_35577;
(statearr_35592[(8)] = inst_35555);

return statearr_35592;
})();
if(cljs.core.truth_(limit)){
var statearr_35593_35618 = state_35577__$1;
(statearr_35593_35618[(1)] = (12));

} else {
var statearr_35594_35619 = state_35577__$1;
(statearr_35594_35619[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (9))){
var inst_35549 = (state_35577[(9)]);
var inst_35551 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_35552 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35549,inst_35551);
var state_35577__$1 = state_35577;
var statearr_35595_35620 = state_35577__$1;
(statearr_35595_35620[(2)] = inst_35552);

(statearr_35595_35620[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (5))){
var _ = (function (){var statearr_35596 = state_35577;
(statearr_35596[(4)] = cljs.core.rest((state_35577[(4)])));

return statearr_35596;
})();
var state_35577__$1 = state_35577;
var ex35591 = (state_35577__$1[(2)]);
var statearr_35597_35621 = state_35577__$1;
(statearr_35597_35621[(5)] = ex35591);


if((ex35591 instanceof Error)){
var statearr_35598_35622 = state_35577__$1;
(statearr_35598_35622[(1)] = (4));

(statearr_35598_35622[(5)] = null);

} else {
throw ex35591;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (14))){
var inst_35561 = (state_35577[(2)]);
var inst_35562 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_35563 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_35562);
var inst_35564 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_35561,inst_35563);
var inst_35565 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_35564,flakes);
var inst_35566 = cljs.core.PersistentVector.EMPTY;
var inst_35567 = (function (){var xf = inst_35564;
var flakes_by_sub = inst_35565;
return (function (p1__35533_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__35533_SHARP_);
});
})();
var inst_35568 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35567,inst_35565);
var inst_35569 = fluree.db.util.async.merge_into_QMARK_(inst_35566,inst_35568);
var state_35577__$1 = state_35577;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35577__$1,(15),inst_35569);
} else {
if((state_val_35578 === (10))){
var inst_35549 = (state_35577[(9)]);
var state_35577__$1 = state_35577;
var statearr_35599_35623 = state_35577__$1;
(statearr_35599_35623[(2)] = inst_35549);

(statearr_35599_35623[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35578 === (8))){
var inst_35549 = (state_35577[(2)]);
var state_35577__$1 = (function (){var statearr_35600 = state_35577;
(statearr_35600[(9)] = inst_35549);

return statearr_35600;
})();
if(cljs.core.truth_(offset)){
var statearr_35601_35624 = state_35577__$1;
(statearr_35601_35624[(1)] = (9));

} else {
var statearr_35602_35625 = state_35577__$1;
(statearr_35602_35625[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10750__auto__ = null;
var fluree$db$query$fql$state_machine__10750__auto____0 = (function (){
var statearr_35603 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35603[(0)] = fluree$db$query$fql$state_machine__10750__auto__);

(statearr_35603[(1)] = (1));

return statearr_35603;
});
var fluree$db$query$fql$state_machine__10750__auto____1 = (function (state_35577){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_35577);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e35604){var ex__10753__auto__ = e35604;
var statearr_35605_35626 = state_35577;
(statearr_35605_35626[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_35577[(4)]))){
var statearr_35606_35627 = state_35577;
(statearr_35606_35627[(1)] = cljs.core.first((state_35577[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__35628 = state_35577;
state_35577 = G__35628;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10750__auto__ = function(state_35577){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10750__auto____1.call(this,state_35577);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10750__auto____0;
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10750__auto____1;
return fluree$db$query$fql$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_35607 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_35607[(6)] = c__10876__auto__);

return statearr_35607;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__35630 = arguments.length;
switch (G__35630) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_35716){
var state_val_35717 = (state_35716[(1)]);
if((state_val_35717 === (7))){
var inst_35711 = (state_35716[(2)]);
var _ = (function (){var statearr_35719 = state_35716;
(statearr_35719[(4)] = cljs.core.rest((state_35716[(4)])));

return statearr_35719;
})();
var state_35716__$1 = state_35716;
var statearr_35720_35772 = state_35716__$1;
(statearr_35720_35772[(2)] = inst_35711);

(statearr_35720_35772[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (20))){
var inst_35650 = (state_35716[(7)]);
var inst_35651 = (state_35716[(8)]);
var inst_35658 = (state_35716[(9)]);
var inst_35679 = (inst_35650 + (1));
var tmp35718 = inst_35651;
var inst_35649 = inst_35658;
var inst_35650__$1 = inst_35679;
var inst_35651__$1 = tmp35718;
var state_35716__$1 = (function (){var statearr_35721 = state_35716;
(statearr_35721[(7)] = inst_35650__$1);

(statearr_35721[(10)] = inst_35649);

(statearr_35721[(8)] = inst_35651__$1);

return statearr_35721;
})();
var statearr_35722_35773 = state_35716__$1;
(statearr_35722_35773[(2)] = null);

(statearr_35722_35773[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (27))){
var inst_35689 = (state_35716[(11)]);
var inst_35691 = cljs.core.count(inst_35689);
var inst_35692 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_35691);
var state_35716__$1 = state_35716;
var statearr_35723_35774 = state_35716__$1;
(statearr_35723_35774[(2)] = inst_35692);

(statearr_35723_35774[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (1))){
var state_35716__$1 = state_35716;
var statearr_35724_35775 = state_35716__$1;
(statearr_35724_35775[(2)] = null);

(statearr_35724_35775[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (24))){
var state_35716__$1 = state_35716;
var statearr_35725_35776 = state_35716__$1;
(statearr_35725_35776[(2)] = null);

(statearr_35725_35776[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (4))){
var inst_35631 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
var statearr_35726_35777 = state_35716__$1;
(statearr_35726_35777[(2)] = inst_35631);

(statearr_35726_35777[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (15))){
var inst_35672 = (state_35716[(12)]);
var inst_35672__$1 = offset;
var state_35716__$1 = (function (){var statearr_35727 = state_35716;
(statearr_35727[(12)] = inst_35672__$1);

return statearr_35727;
})();
if(cljs.core.truth_(inst_35672__$1)){
var statearr_35728_35778 = state_35716__$1;
(statearr_35728_35778[(1)] = (17));

} else {
var statearr_35729_35779 = state_35716__$1;
(statearr_35729_35779[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (21))){
var state_35716__$1 = state_35716;
var statearr_35730_35780 = state_35716__$1;
(statearr_35730_35780[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (13))){
var inst_35667 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
var statearr_35732_35781 = state_35716__$1;
(statearr_35732_35781[(2)] = inst_35667);

(statearr_35732_35781[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (22))){
var inst_35707 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
var statearr_35733_35782 = state_35716__$1;
(statearr_35733_35782[(2)] = inst_35707);

(statearr_35733_35782[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (29))){
var inst_35689 = (state_35716[(11)]);
var inst_35650 = (state_35716[(7)]);
var inst_35695 = (state_35716[(2)]);
var inst_35696 = (inst_35650 + (1));
var inst_35697 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_35689);
var state_35716__$1 = (function (){var statearr_35734 = state_35716;
(statearr_35734[(13)] = inst_35695);

(statearr_35734[(14)] = inst_35696);

return statearr_35734;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35716__$1,(30),inst_35697);
} else {
if((state_val_35717 === (6))){
var inst_35659 = (state_35716[(15)]);
var inst_35657 = (state_35716[(16)]);
var inst_35649 = (state_35716[(10)]);
var inst_35656 = cljs.core.seq(inst_35649);
var inst_35657__$1 = cljs.core.first(inst_35656);
var inst_35658 = cljs.core.next(inst_35656);
var inst_35659__$1 = (inst_35657__$1 == null);
var state_35716__$1 = (function (){var statearr_35735 = state_35716;
(statearr_35735[(15)] = inst_35659__$1);

(statearr_35735[(16)] = inst_35657__$1);

(statearr_35735[(9)] = inst_35658);

return statearr_35735;
})();
if(cljs.core.truth_(inst_35659__$1)){
var statearr_35736_35783 = state_35716__$1;
(statearr_35736_35783[(1)] = (8));

} else {
var statearr_35737_35784 = state_35716__$1;
(statearr_35737_35784[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (28))){
var state_35716__$1 = state_35716;
var statearr_35738_35785 = state_35716__$1;
(statearr_35738_35785[(2)] = null);

(statearr_35738_35785[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (25))){
var inst_35705 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
var statearr_35739_35786 = state_35716__$1;
(statearr_35739_35786[(2)] = inst_35705);

(statearr_35739_35786[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (17))){
var inst_35650 = (state_35716[(7)]);
var inst_35674 = (inst_35650 < offset);
var state_35716__$1 = state_35716;
var statearr_35740_35787 = state_35716__$1;
(statearr_35740_35787[(2)] = inst_35674);

(statearr_35740_35787[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (3))){
var inst_35714 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35716__$1,inst_35714);
} else {
if((state_val_35717 === (12))){
var inst_35662 = (state_35716[(17)]);
var state_35716__$1 = state_35716;
var statearr_35741_35788 = state_35716__$1;
(statearr_35741_35788[(2)] = inst_35662);

(statearr_35741_35788[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (2))){
var _ = (function (){var statearr_35742 = state_35716;
(statearr_35742[(4)] = cljs.core.cons((5),(state_35716[(4)])));

return statearr_35742;
})();
var inst_35644 = subjects;
var inst_35645 = cljs.core.seq(inst_35644);
var inst_35646 = cljs.core.first(inst_35645);
var inst_35647 = cljs.core.next(inst_35645);
var inst_35648 = cljs.core.PersistentVector.EMPTY;
var inst_35649 = inst_35644;
var inst_35650 = (0);
var inst_35651 = inst_35648;
var state_35716__$1 = (function (){var statearr_35743 = state_35716;
(statearr_35743[(18)] = inst_35646);

(statearr_35743[(7)] = inst_35650);

(statearr_35743[(10)] = inst_35649);

(statearr_35743[(19)] = inst_35647);

(statearr_35743[(8)] = inst_35651);

return statearr_35743;
})();
var statearr_35744_35789 = state_35716__$1;
(statearr_35744_35789[(2)] = null);

(statearr_35744_35789[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (23))){
var inst_35657 = (state_35716[(16)]);
var inst_35683 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35684 = [inst_35657];
var inst_35685 = (new cljs.core.PersistentVector(null,1,(5),inst_35683,inst_35684,null));
var inst_35686 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_35685);
var state_35716__$1 = state_35716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35716__$1,(26),inst_35686);
} else {
if((state_val_35717 === (19))){
var inst_35677 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
if(cljs.core.truth_(inst_35677)){
var statearr_35745_35790 = state_35716__$1;
(statearr_35745_35790[(1)] = (20));

} else {
var statearr_35746_35791 = state_35716__$1;
(statearr_35746_35791[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (11))){
var inst_35650 = (state_35716[(7)]);
var inst_35664 = (inst_35650 > limit);
var state_35716__$1 = state_35716;
var statearr_35748_35792 = state_35716__$1;
(statearr_35748_35792[(2)] = inst_35664);

(statearr_35748_35792[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (9))){
var inst_35662 = (state_35716[(17)]);
var inst_35662__$1 = limit;
var state_35716__$1 = (function (){var statearr_35749 = state_35716;
(statearr_35749[(17)] = inst_35662__$1);

return statearr_35749;
})();
if(cljs.core.truth_(inst_35662__$1)){
var statearr_35750_35793 = state_35716__$1;
(statearr_35750_35793[(1)] = (11));

} else {
var statearr_35751_35794 = state_35716__$1;
(statearr_35751_35794[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (5))){
var _ = (function (){var statearr_35752 = state_35716;
(statearr_35752[(4)] = cljs.core.rest((state_35716[(4)])));

return statearr_35752;
})();
var state_35716__$1 = state_35716;
var ex35747 = (state_35716__$1[(2)]);
var statearr_35753_35795 = state_35716__$1;
(statearr_35753_35795[(5)] = ex35747);


if((ex35747 instanceof Error)){
var statearr_35754_35796 = state_35716__$1;
(statearr_35754_35796[(1)] = (4));

(statearr_35754_35796[(5)] = null);

} else {
throw ex35747;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (14))){
var inst_35651 = (state_35716[(8)]);
var state_35716__$1 = state_35716;
var statearr_35755_35797 = state_35716__$1;
(statearr_35755_35797[(2)] = inst_35651);

(statearr_35755_35797[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (26))){
var inst_35688 = (state_35716[(2)]);
var inst_35689 = fluree.db.util.async.throw_err(inst_35688);
var state_35716__$1 = (function (){var statearr_35756 = state_35716;
(statearr_35756[(11)] = inst_35689);

return statearr_35756;
})();
if(cljs.core.truth_(fuel)){
var statearr_35757_35798 = state_35716__$1;
(statearr_35757_35798[(1)] = (27));

} else {
var statearr_35758_35799 = state_35716__$1;
(statearr_35758_35799[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (16))){
var inst_35709 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
var statearr_35759_35800 = state_35716__$1;
(statearr_35759_35800[(2)] = inst_35709);

(statearr_35759_35800[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (30))){
var inst_35696 = (state_35716[(14)]);
var inst_35651 = (state_35716[(8)]);
var inst_35658 = (state_35716[(9)]);
var inst_35699 = (state_35716[(2)]);
var inst_35700 = fluree.db.util.async.throw_err(inst_35699);
var inst_35701 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35651,inst_35700);
var inst_35649 = inst_35658;
var inst_35650 = inst_35696;
var inst_35651__$1 = inst_35701;
var state_35716__$1 = (function (){var statearr_35760 = state_35716;
(statearr_35760[(7)] = inst_35650);

(statearr_35760[(10)] = inst_35649);

(statearr_35760[(8)] = inst_35651__$1);

return statearr_35760;
})();
var statearr_35761_35801 = state_35716__$1;
(statearr_35761_35801[(2)] = null);

(statearr_35761_35801[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (10))){
var inst_35669 = (state_35716[(2)]);
var state_35716__$1 = state_35716;
if(cljs.core.truth_(inst_35669)){
var statearr_35762_35802 = state_35716__$1;
(statearr_35762_35802[(1)] = (14));

} else {
var statearr_35763_35803 = state_35716__$1;
(statearr_35763_35803[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (18))){
var inst_35672 = (state_35716[(12)]);
var state_35716__$1 = state_35716;
var statearr_35764_35804 = state_35716__$1;
(statearr_35764_35804[(2)] = inst_35672);

(statearr_35764_35804[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35717 === (8))){
var inst_35659 = (state_35716[(15)]);
var state_35716__$1 = state_35716;
var statearr_35765_35805 = state_35716__$1;
(statearr_35765_35805[(2)] = inst_35659);

(statearr_35765_35805[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10750__auto__ = null;
var fluree$db$query$fql$state_machine__10750__auto____0 = (function (){
var statearr_35766 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_35766[(0)] = fluree$db$query$fql$state_machine__10750__auto__);

(statearr_35766[(1)] = (1));

return statearr_35766;
});
var fluree$db$query$fql$state_machine__10750__auto____1 = (function (state_35716){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_35716);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e35767){var ex__10753__auto__ = e35767;
var statearr_35768_35806 = state_35716;
(statearr_35768_35806[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_35716[(4)]))){
var statearr_35769_35807 = state_35716;
(statearr_35769_35807[(1)] = cljs.core.first((state_35716[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__35808 = state_35716;
state_35716 = G__35808;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10750__auto__ = function(state_35716){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10750__auto____1.call(this,state_35716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10750__auto____0;
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10750__auto____1;
return fluree$db$query$fql$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_35770 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_35770[(6)] = c__10876__auto__);

return statearr_35770;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__35810 = arguments.length;
switch (G__35810) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36001){
var state_val_36002 = (state_36001[(1)]);
if((state_val_36002 === (7))){
var state_36001__$1 = state_36001;
var statearr_36003_36078 = state_36001__$1;
(statearr_36003_36078[(2)] = null);

(statearr_36003_36078[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (20))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35881 = (state_36001[(2)]);
var inst_35882 = fluree.db.util.async.throw_err(inst_35881);
var inst_35883 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35884 = [inst_35851];
var inst_35885 = (new cljs.core.PersistentVector(null,1,(5),inst_35883,inst_35884,null));
var inst_35886 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35887 = [inst_35851,inst_35853];
var inst_35888 = (new cljs.core.PersistentVector(null,2,(5),inst_35886,inst_35887,null));
var inst_35889 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_35885,cljs.core._LT_,inst_35888);
var state_36001__$1 = (function (){var statearr_36004 = state_36001;
(statearr_36004[(9)] = inst_35882);

return statearr_36004;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(21),inst_35889);
} else {
if((state_val_36002 === (27))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35918 = (inst_35870.cljs$core$IFn$_invoke$arity$2 ? inst_35870.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_35852) : inst_35870.call(null,cljs.core._GT__EQ_,inst_35852));
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35918)){
var statearr_36005_36079 = state_36001__$1;
(statearr_36005_36079[(1)] = (30));

} else {
var statearr_36006_36080 = state_36001__$1;
(statearr_36006_36080[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (1))){
var state_36001__$1 = state_36001;
var statearr_36007_36081 = state_36001__$1;
(statearr_36007_36081[(2)] = null);

(statearr_36007_36081[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (24))){
var inst_35967 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36008_36082 = state_36001__$1;
(statearr_36008_36082[(2)] = inst_35967);

(statearr_36008_36082[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (39))){
var inst_35957 = null;
var state_36001__$1 = state_36001;
var statearr_36009_36083 = state_36001__$1;
(statearr_36009_36083[(2)] = inst_35957);

(statearr_36009_36083[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (46))){
var inst_35979 = (state_36001[(12)]);
var state_36001__$1 = state_36001;
var statearr_36010_36084 = state_36001__$1;
(statearr_36010_36084[(2)] = inst_35979);

(statearr_36010_36084[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (4))){
var inst_35811 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36011_36085 = state_36001__$1;
(statearr_36011_36085[(2)] = inst_35811);

(statearr_36011_36085[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (15))){
var state_36001__$1 = state_36001;
var statearr_36012_36086 = state_36001__$1;
(statearr_36012_36086[(2)] = null);

(statearr_36012_36086[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (48))){
var inst_35978 = (state_36001[(13)]);
var state_36001__$1 = state_36001;
var statearr_36013_36087 = state_36001__$1;
(statearr_36013_36087[(2)] = inst_35978);

(statearr_36013_36087[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (50))){
var inst_35989 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36014_36088 = state_36001__$1;
(statearr_36014_36088[(2)] = inst_35989);

(statearr_36014_36088[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (21))){
var inst_35882 = (state_36001[(9)]);
var inst_35891 = (state_36001[(2)]);
var inst_35892 = fluree.db.util.async.throw_err(inst_35891);
var inst_35893 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_35882,inst_35892);
var state_36001__$1 = state_36001;
var statearr_36015_36089 = state_36001__$1;
(statearr_36015_36089[(2)] = inst_35893);

(statearr_36015_36089[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (31))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35931 = (inst_35870.cljs$core$IFn$_invoke$arity$2 ? inst_35870.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_35852) : inst_35870.call(null,cljs.core._LT_,inst_35852));
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35931)){
var statearr_36016_36090 = state_36001__$1;
(statearr_36016_36090[(1)] = (34));

} else {
var statearr_36017_36091 = state_36001__$1;
(statearr_36017_36091[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (32))){
var inst_35963 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36018_36092 = state_36001__$1;
(statearr_36018_36092[(2)] = inst_35963);

(statearr_36018_36092[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (40))){
var inst_35959 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36019_36093 = state_36001__$1;
(statearr_36019_36093[(2)] = inst_35959);

(statearr_36019_36093[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (33))){
var inst_35928 = (state_36001[(2)]);
var inst_35929 = fluree.db.util.async.throw_err(inst_35928);
var state_36001__$1 = state_36001;
var statearr_36020_36094 = state_36001__$1;
(statearr_36020_36094[(2)] = inst_35929);

(statearr_36020_36094[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (13))){
var inst_35991 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36021_36095 = state_36001__$1;
(statearr_36021_36095[(2)] = inst_35991);

(statearr_36021_36095[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (22))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35898 = [inst_35851,inst_35853];
var inst_35899 = (new cljs.core.PersistentVector(null,2,(5),inst_35897,inst_35898,null));
var inst_35900 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_35899);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(25),inst_35900);
} else {
if((state_val_36002 === (36))){
var inst_35961 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36022_36096 = state_36001__$1;
(statearr_36022_36096[(2)] = inst_35961);

(statearr_36022_36096[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (41))){
var inst_35954 = (state_36001[(2)]);
var inst_35955 = fluree.db.util.async.throw_err(inst_35954);
var state_36001__$1 = state_36001;
var statearr_36023_36097 = state_36001__$1;
(statearr_36023_36097[(2)] = inst_35955);

(statearr_36023_36097[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (43))){
var inst_35837 = (state_36001[(14)]);
var inst_35970 = (state_36001[(15)]);
var inst_35971 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35837,inst_35970);
var state_36001__$1 = state_36001;
var statearr_36024_36098 = state_36001__$1;
(statearr_36024_36098[(2)] = inst_35971);

(statearr_36024_36098[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (29))){
var inst_35915 = (state_36001[(2)]);
var inst_35916 = fluree.db.util.async.throw_err(inst_35915);
var state_36001__$1 = state_36001;
var statearr_36025_36099 = state_36001__$1;
(statearr_36025_36099[(2)] = inst_35916);

(statearr_36025_36099[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (44))){
var inst_35837 = (state_36001[(14)]);
var inst_35970 = (state_36001[(15)]);
var inst_35973 = cljs.core.PersistentHashSet.EMPTY;
var inst_35974 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35973,inst_35970);
var inst_35975 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_35837,inst_35974);
var state_36001__$1 = state_36001;
var statearr_36026_36100 = state_36001__$1;
(statearr_36026_36100[(2)] = inst_35975);

(statearr_36026_36100[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (6))){
var inst_35822 = (state_36001[(16)]);
var inst_35832 = cljs.core.seq(inst_35822);
var inst_35833 = cljs.core.first(inst_35832);
var inst_35834 = cljs.core.next(inst_35832);
var inst_35835 = cljs.core.PersistentHashSet.EMPTY;
var inst_35836 = inst_35822;
var inst_35837 = inst_35835;
var state_36001__$1 = (function (){var statearr_36027 = state_36001;
(statearr_36027[(17)] = inst_35834);

(statearr_36027[(14)] = inst_35837);

(statearr_36027[(18)] = inst_35833);

(statearr_36027[(19)] = inst_35836);

return statearr_36027;
})();
var statearr_36028_36101 = state_36001__$1;
(statearr_36028_36101[(2)] = null);

(statearr_36028_36101[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (28))){
var inst_35965 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36029_36102 = state_36001__$1;
(statearr_36029_36102[(2)] = inst_35965);

(statearr_36029_36102[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (25))){
var inst_35902 = (state_36001[(2)]);
var inst_35903 = fluree.db.util.async.throw_err(inst_35902);
var state_36001__$1 = state_36001;
var statearr_36030_36103 = state_36001__$1;
(statearr_36030_36103[(2)] = inst_35903);

(statearr_36030_36103[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (34))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35934 = [inst_35851];
var inst_35935 = (new cljs.core.PersistentVector(null,1,(5),inst_35933,inst_35934,null));
var inst_35936 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35937 = [inst_35851,inst_35853];
var inst_35938 = (new cljs.core.PersistentVector(null,2,(5),inst_35936,inst_35937,null));
var inst_35939 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_35935,cljs.core._LT_,inst_35938);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(37),inst_35939);
} else {
if((state_val_36002 === (17))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35873 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35874 = [inst_35851,inst_35853];
var inst_35875 = (new cljs.core.PersistentVector(null,2,(5),inst_35873,inst_35874,null));
var inst_35876 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35877 = [inst_35851];
var inst_35878 = (new cljs.core.PersistentVector(null,1,(5),inst_35876,inst_35877,null));
var inst_35879 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_35875,cljs.core._LT__EQ_,inst_35878);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(20),inst_35879);
} else {
if((state_val_36002 === (3))){
var inst_35999 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36001__$1,inst_35999);
} else {
if((state_val_36002 === (12))){
var inst_35851 = (state_36001[(7)]);
var inst_35843 = (state_36001[(20)]);
var inst_35851__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(0),null);
var inst_35852 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(1),null);
var inst_35853 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35843,(2),null);
var inst_35854 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_35851__$1);
var inst_35855 = cljs.core.not(inst_35854);
var state_36001__$1 = (function (){var statearr_36031 = state_36001;
(statearr_36031[(7)] = inst_35851__$1);

(statearr_36031[(10)] = inst_35852);

(statearr_36031[(8)] = inst_35853);

return statearr_36031;
})();
if(inst_35855){
var statearr_36032_36104 = state_36001__$1;
(statearr_36032_36104[(1)] = (14));

} else {
var statearr_36033_36105 = state_36001__$1;
(statearr_36033_36105[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (2))){
var inst_35822 = (state_36001[(16)]);
var _ = (function (){var statearr_36034 = state_36001;
(statearr_36034[(4)] = cljs.core.cons((5),(state_36001[(4)])));

return statearr_36034;
})();
var inst_35820 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_35821 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35820,(0),null);
var inst_35822__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_35820,(1),null);
var inst_35823 = cljs.core.not_empty(inst_35822__$1);
var state_36001__$1 = (function (){var statearr_36035 = state_36001;
(statearr_36035[(16)] = inst_35822__$1);

(statearr_36035[(21)] = inst_35821);

return statearr_36035;
})();
if(cljs.core.truth_(inst_35823)){
var statearr_36036_36106 = state_36001__$1;
(statearr_36036_36106[(1)] = (6));

} else {
var statearr_36037_36107 = state_36001__$1;
(statearr_36037_36107[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (23))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35905 = (inst_35870.cljs$core$IFn$_invoke$arity$2 ? inst_35870.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_35852) : inst_35870.call(null,cljs.core._GT_,inst_35852));
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35905)){
var statearr_36038_36108 = state_36001__$1;
(statearr_36038_36108[(1)] = (26));

} else {
var statearr_36039_36109 = state_36001__$1;
(statearr_36039_36109[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (47))){
var inst_35984 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35984)){
var statearr_36040_36110 = state_36001__$1;
(statearr_36040_36110[(1)] = (48));

} else {
var statearr_36041_36111 = state_36001__$1;
(statearr_36041_36111[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (35))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35944 = (inst_35870.cljs$core$IFn$_invoke$arity$2 ? inst_35870.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_35852) : inst_35870.call(null,cljs.core._LT__EQ_,inst_35852));
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35944)){
var statearr_36042_36112 = state_36001__$1;
(statearr_36042_36112[(1)] = (38));

} else {
var statearr_36043_36113 = state_36001__$1;
(statearr_36043_36113[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (19))){
var inst_35821 = (state_36001[(21)]);
var inst_35969 = (state_36001[(2)]);
var inst_35970 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_35969);
var state_36001__$1 = (function (){var statearr_36044 = state_36001;
(statearr_36044[(15)] = inst_35970);

return statearr_36044;
})();
var G__36045_36114 = inst_35821;
var G__36045_36115__$1 = (((G__36045_36114 instanceof cljs.core.Keyword))?G__36045_36114.fqn:null);
switch (G__36045_36115__$1) {
case "or":
var statearr_36046_36117 = state_36001__$1;
(statearr_36046_36117[(1)] = (43));


break;
case "and":
var statearr_36047_36118 = state_36001__$1;
(statearr_36047_36118[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__36045_36115__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (11))){
var inst_35837 = (state_36001[(14)]);
var state_36001__$1 = state_36001;
var statearr_36049_36119 = state_36001__$1;
(statearr_36049_36119[(2)] = inst_35837);

(statearr_36049_36119[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (9))){
var inst_35843 = (state_36001[(20)]);
var inst_35836 = (state_36001[(19)]);
var inst_35842 = cljs.core.seq(inst_35836);
var inst_35843__$1 = cljs.core.first(inst_35842);
var inst_35844 = cljs.core.next(inst_35842);
var inst_35845 = cljs.core.not(inst_35843__$1);
var state_36001__$1 = (function (){var statearr_36050 = state_36001;
(statearr_36050[(22)] = inst_35844);

(statearr_36050[(20)] = inst_35843__$1);

return statearr_36050;
})();
if(inst_35845){
var statearr_36051_36120 = state_36001__$1;
(statearr_36051_36120[(1)] = (11));

} else {
var statearr_36052_36121 = state_36001__$1;
(statearr_36052_36121[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (5))){
var _ = (function (){var statearr_36053 = state_36001;
(statearr_36053[(4)] = cljs.core.rest((state_36001[(4)])));

return statearr_36053;
})();
var state_36001__$1 = state_36001;
var ex36048 = (state_36001__$1[(2)]);
var statearr_36054_36122 = state_36001__$1;
(statearr_36054_36122[(5)] = ex36048);


if((ex36048 instanceof Error)){
var statearr_36055_36123 = state_36001__$1;
(statearr_36055_36123[(1)] = (4));

(statearr_36055_36123[(5)] = null);

} else {
throw ex36048;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (14))){
var inst_35851 = (state_36001[(7)]);
var inst_35857 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_35851);
var inst_35858 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_35857)].join('');
var inst_35859 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_35860 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_35861 = cljs.core.PersistentHashMap.fromArrays(inst_35859,inst_35860);
var inst_35862 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_35858,inst_35861);
var inst_35863 = (function(){throw inst_35862})();
var state_36001__$1 = state_36001;
var statearr_36056_36124 = state_36001__$1;
(statearr_36056_36124[(2)] = inst_35863);

(statearr_36056_36124[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (45))){
var inst_35978 = (state_36001[(13)]);
var inst_35981 = cljs.core.empty_QMARK_(inst_35978);
var state_36001__$1 = state_36001;
var statearr_36057_36125 = state_36001__$1;
(statearr_36057_36125[(2)] = inst_35981);

(statearr_36057_36125[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (26))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35907 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35908 = [inst_35851,inst_35853];
var inst_35909 = (new cljs.core.PersistentVector(null,2,(5),inst_35907,inst_35908,null));
var inst_35910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35911 = [inst_35851];
var inst_35912 = (new cljs.core.PersistentVector(null,1,(5),inst_35910,inst_35911,null));
var inst_35913 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_35909,cljs.core._LT__EQ_,inst_35912);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(29),inst_35913);
} else {
if((state_val_36002 === (16))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35866 = (state_36001[(2)]);
var inst_35870__$1 = cljs.core.identical_QMARK_;
var inst_35871 = (inst_35870__$1.cljs$core$IFn$_invoke$arity$2 ? inst_35870__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_35852) : inst_35870__$1.call(null,cljs.core.not_EQ_,inst_35852));
var state_36001__$1 = (function (){var statearr_36058 = state_36001;
(statearr_36058[(23)] = inst_35866);

(statearr_36058[(11)] = inst_35870__$1);

return statearr_36058;
})();
if(cljs.core.truth_(inst_35871)){
var statearr_36059_36126 = state_36001__$1;
(statearr_36059_36126[(1)] = (17));

} else {
var statearr_36060_36127 = state_36001__$1;
(statearr_36060_36127[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (38))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35947 = [inst_35851];
var inst_35948 = (new cljs.core.PersistentVector(null,1,(5),inst_35946,inst_35947,null));
var inst_35949 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35950 = [inst_35851,inst_35853];
var inst_35951 = (new cljs.core.PersistentVector(null,2,(5),inst_35949,inst_35950,null));
var inst_35952 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_35948,cljs.core._LT__EQ_,inst_35951);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(41),inst_35952);
} else {
if((state_val_36002 === (30))){
var inst_35851 = (state_36001[(7)]);
var inst_35853 = (state_36001[(8)]);
var inst_35920 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35921 = [inst_35851,inst_35853];
var inst_35922 = (new cljs.core.PersistentVector(null,2,(5),inst_35920,inst_35921,null));
var inst_35923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35924 = [inst_35851];
var inst_35925 = (new cljs.core.PersistentVector(null,1,(5),inst_35923,inst_35924,null));
var inst_35926 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_35922,cljs.core._LT__EQ_,inst_35925);
var state_36001__$1 = state_36001;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36001__$1,(33),inst_35926);
} else {
if((state_val_36002 === (10))){
var inst_35993 = (state_36001[(2)]);
var state_36001__$1 = state_36001;
var statearr_36061_36128 = state_36001__$1;
(statearr_36061_36128[(2)] = inst_35993);

(statearr_36061_36128[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (18))){
var inst_35852 = (state_36001[(10)]);
var inst_35870 = (state_36001[(11)]);
var inst_35895 = (inst_35870.cljs$core$IFn$_invoke$arity$2 ? inst_35870.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_35852) : inst_35870.call(null,cljs.core._EQ_,inst_35852));
var state_36001__$1 = state_36001;
if(cljs.core.truth_(inst_35895)){
var statearr_36062_36129 = state_36001__$1;
(statearr_36062_36129[(1)] = (22));

} else {
var statearr_36063_36130 = state_36001__$1;
(statearr_36063_36130[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (42))){
var inst_35821 = (state_36001[(21)]);
var inst_35979 = (state_36001[(12)]);
var inst_35978 = (state_36001[(2)]);
var inst_35979__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_35821);
var state_36001__$1 = (function (){var statearr_36064 = state_36001;
(statearr_36064[(13)] = inst_35978);

(statearr_36064[(12)] = inst_35979__$1);

return statearr_36064;
})();
if(inst_35979__$1){
var statearr_36065_36131 = state_36001__$1;
(statearr_36065_36131[(1)] = (45));

} else {
var statearr_36066_36132 = state_36001__$1;
(statearr_36066_36132[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (37))){
var inst_35941 = (state_36001[(2)]);
var inst_35942 = fluree.db.util.async.throw_err(inst_35941);
var state_36001__$1 = state_36001;
var statearr_36067_36133 = state_36001__$1;
(statearr_36067_36133[(2)] = inst_35942);

(statearr_36067_36133[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (8))){
var inst_35996 = (state_36001[(2)]);
var _ = (function (){var statearr_36068 = state_36001;
(statearr_36068[(4)] = cljs.core.rest((state_36001[(4)])));

return statearr_36068;
})();
var state_36001__$1 = state_36001;
var statearr_36069_36134 = state_36001__$1;
(statearr_36069_36134[(2)] = inst_35996);

(statearr_36069_36134[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36002 === (49))){
var inst_35844 = (state_36001[(22)]);
var inst_35978 = (state_36001[(13)]);
var inst_35836 = inst_35844;
var inst_35837 = inst_35978;
var state_36001__$1 = (function (){var statearr_36070 = state_36001;
(statearr_36070[(14)] = inst_35837);

(statearr_36070[(19)] = inst_35836);

return statearr_36070;
})();
var statearr_36071_36135 = state_36001__$1;
(statearr_36071_36135[(2)] = null);

(statearr_36071_36135[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10750__auto__ = null;
var fluree$db$query$fql$state_machine__10750__auto____0 = (function (){
var statearr_36072 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36072[(0)] = fluree$db$query$fql$state_machine__10750__auto__);

(statearr_36072[(1)] = (1));

return statearr_36072;
});
var fluree$db$query$fql$state_machine__10750__auto____1 = (function (state_36001){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36001);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36073){var ex__10753__auto__ = e36073;
var statearr_36074_36136 = state_36001;
(statearr_36074_36136[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36001[(4)]))){
var statearr_36075_36137 = state_36001;
(statearr_36075_36137[(1)] = cljs.core.first((state_36001[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36138 = state_36001;
state_36001 = G__36138;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10750__auto__ = function(state_36001){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10750__auto____1.call(this,state_36001);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10750__auto____0;
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10750__auto____1;
return fluree$db$query$fql$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36076 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36076[(6)] = c__10876__auto__);

return statearr_36076;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__36139_SHARP_){
return ((typeof p1__36139_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__36139_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__36140_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__36140_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__36144 = vars;
var vec__36145 = G__36144;
var seq__36146 = cljs.core.seq(vec__36145);
var first__36147 = cljs.core.first(seq__36146);
var seq__36146__$1 = cljs.core.next(seq__36146);
var var$ = first__36147;
var r = seq__36146__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__36144__$1 = G__36144;
var all_vars__$1 = all_vars;
while(true){
var vec__36152 = G__36144__$1;
var seq__36153 = cljs.core.seq(vec__36152);
var first__36154 = cljs.core.first(seq__36153);
var seq__36153__$1 = cljs.core.next(seq__36153);
var var$__$1 = first__36154;
var r__$1 = seq__36153__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__36155 = cljs.core.set(all_vars__$2);
return (fexpr__36155.cljs$core$IFn$_invoke$arity$1 ? fexpr__36155.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__36155.call(null,var$__$1));
})())){
var G__36156 = r__$1;
var G__36157 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__36144__$1 = G__36156;
all_vars__$1 = G__36157;
continue;
} else {
var G__36158 = r__$1;
var G__36159 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__36144__$1 = G__36158;
all_vars__$1 = G__36159;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36194){
var state_val_36195 = (state_36194[(1)]);
if((state_val_36195 === (1))){
var inst_36167 = functionArray;
var inst_36168 = cljs.core.seq(inst_36167);
var inst_36169 = cljs.core.first(inst_36168);
var inst_36170 = cljs.core.next(inst_36168);
var inst_36171 = cljs.core.PersistentVector.EMPTY;
var inst_36172 = inst_36167;
var inst_36173 = inst_36171;
var state_36194__$1 = (function (){var statearr_36196 = state_36194;
(statearr_36196[(7)] = inst_36173);

(statearr_36196[(8)] = inst_36172);

(statearr_36196[(9)] = inst_36169);

(statearr_36196[(10)] = inst_36170);

return statearr_36196;
})();
var statearr_36197_36210 = state_36194__$1;
(statearr_36197_36210[(2)] = null);

(statearr_36197_36210[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36195 === (2))){
var inst_36172 = (state_36194[(8)]);
var inst_36179 = (state_36194[(11)]);
var inst_36178 = cljs.core.seq(inst_36172);
var inst_36179__$1 = cljs.core.first(inst_36178);
var inst_36180 = cljs.core.next(inst_36178);
var state_36194__$1 = (function (){var statearr_36198 = state_36194;
(statearr_36198[(12)] = inst_36180);

(statearr_36198[(11)] = inst_36179__$1);

return statearr_36198;
})();
if(cljs.core.truth_(inst_36179__$1)){
var statearr_36199_36211 = state_36194__$1;
(statearr_36199_36211[(1)] = (4));

} else {
var statearr_36200_36212 = state_36194__$1;
(statearr_36200_36212[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36195 === (3))){
var inst_36192 = (state_36194[(2)]);
var state_36194__$1 = state_36194;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36194__$1,inst_36192);
} else {
if((state_val_36195 === (4))){
var inst_36179 = (state_36194[(11)]);
var inst_36182 = (inst_36179.cljs$core$IFn$_invoke$arity$1 ? inst_36179.cljs$core$IFn$_invoke$arity$1(tuple) : inst_36179.call(null,tuple));
var state_36194__$1 = state_36194;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36194__$1,(7),inst_36182);
} else {
if((state_val_36195 === (5))){
var inst_36173 = (state_36194[(7)]);
var state_36194__$1 = state_36194;
var statearr_36201_36213 = state_36194__$1;
(statearr_36201_36213[(2)] = inst_36173);

(statearr_36201_36213[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36195 === (6))){
var inst_36190 = (state_36194[(2)]);
var state_36194__$1 = state_36194;
var statearr_36202_36214 = state_36194__$1;
(statearr_36202_36214[(2)] = inst_36190);

(statearr_36202_36214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36195 === (7))){
var inst_36173 = (state_36194[(7)]);
var inst_36180 = (state_36194[(12)]);
var inst_36184 = (state_36194[(2)]);
var inst_36185 = fluree.db.util.async.throw_err(inst_36184);
var inst_36186 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36173,inst_36185);
var inst_36172 = inst_36180;
var inst_36173__$1 = inst_36186;
var state_36194__$1 = (function (){var statearr_36203 = state_36194;
(statearr_36203[(7)] = inst_36173__$1);

(statearr_36203[(8)] = inst_36172);

return statearr_36203;
})();
var statearr_36204_36215 = state_36194__$1;
(statearr_36204_36215[(2)] = null);

(statearr_36204_36215[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____0 = (function (){
var statearr_36205 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36205[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__);

(statearr_36205[(1)] = (1));

return statearr_36205;
});
var fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____1 = (function (state_36194){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36194);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36206){var ex__10753__auto__ = e36206;
var statearr_36207_36216 = state_36194;
(statearr_36207_36216[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36194[(4)]))){
var statearr_36208_36217 = state_36194;
(statearr_36208_36217[(1)] = cljs.core.first((state_36194[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36218 = state_36194;
state_36194 = G__36218;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__ = function(state_36194){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____1.call(this,state_36194);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__10750__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36209 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36209[(6)] = c__10876__auto__);

return statearr_36209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__36219){
var vec__36220 = p__36219;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36220,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36220,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36234){
var state_val_36235 = (state_36234[(1)]);
if((state_val_36235 === (1))){
var inst_36223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36224 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_36225 = [query_map,_id,query_opts];
var inst_36226 = cljs.core.PersistentHashMap.fromArrays(inst_36224,inst_36225);
var inst_36227 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_36226) : fluree.db.query.fql.query.call(null,db,inst_36226));
var state_36234__$1 = (function (){var statearr_36236 = state_36234;
(statearr_36236[(7)] = inst_36223);

return statearr_36236;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36234__$1,(2),inst_36227);
} else {
if((state_val_36235 === (2))){
var inst_36223 = (state_36234[(7)]);
var inst_36229 = (state_36234[(2)]);
var inst_36230 = fluree.db.util.async.throw_err(inst_36229);
var inst_36231 = [tuple_index,inst_36230];
var inst_36232 = (new cljs.core.PersistentVector(null,2,(5),inst_36223,inst_36231,null));
var state_36234__$1 = state_36234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36234__$1,inst_36232);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__10750__auto____0 = (function (){
var statearr_36237 = [null,null,null,null,null,null,null,null];
(statearr_36237[(0)] = fluree$db$query$fql$expand_map_$_state_machine__10750__auto__);

(statearr_36237[(1)] = (1));

return statearr_36237;
});
var fluree$db$query$fql$expand_map_$_state_machine__10750__auto____1 = (function (state_36234){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36234);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36238){var ex__10753__auto__ = e36238;
var statearr_36239_36242 = state_36234;
(statearr_36239_36242[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36234[(4)]))){
var statearr_36240_36243 = state_36234;
(statearr_36240_36243[(1)] = cljs.core.first((state_36234[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36244 = state_36234;
state_36234 = G__36244;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__10750__auto__ = function(state_36234){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__10750__auto____1.call(this,state_36234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__10750__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__10750__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36241 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36241[(6)] = c__10876__auto__);

return statearr_36241;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__36245 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36245,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36245,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36308){
var state_val_36309 = (state_36308[(1)]);
if((state_val_36309 === (7))){
var inst_36303 = (state_36308[(2)]);
var _ = (function (){var statearr_36310 = state_36308;
(statearr_36310[(4)] = cljs.core.rest((state_36308[(4)])));

return statearr_36310;
})();
var state_36308__$1 = state_36308;
var statearr_36311_36402 = state_36308__$1;
(statearr_36311_36402[(2)] = inst_36303);

(statearr_36311_36402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (20))){
var inst_36294 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
var statearr_36312_36403 = state_36308__$1;
(statearr_36312_36403[(2)] = inst_36294);

(statearr_36312_36403[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (1))){
var state_36308__$1 = state_36308;
var statearr_36313_36404 = state_36308__$1;
(statearr_36313_36404[(2)] = null);

(statearr_36313_36404[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (4))){
var inst_36250 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
var statearr_36314_36405 = state_36308__$1;
(statearr_36314_36405[(2)] = inst_36250);

(statearr_36314_36405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (15))){
var inst_36270 = (state_36308[(7)]);
var inst_36279 = cljs.core.second(inst_36270);
var inst_36280 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_36279);
var inst_36281 = (inst_36280 > max_fuel);
var state_36308__$1 = state_36308;
if(cljs.core.truth_(inst_36281)){
var statearr_36315_36406 = state_36308__$1;
(statearr_36315_36406[(1)] = (18));

} else {
var statearr_36316_36407 = state_36308__$1;
(statearr_36316_36407[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (13))){
var state_36308__$1 = state_36308;
var statearr_36317_36408 = state_36308__$1;
(statearr_36317_36408[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (6))){
var inst_36258 = (state_36308[(8)]);
var state_36308__$1 = state_36308;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36308__$1,(8),inst_36258);
} else {
if((state_val_36309 === (17))){
var inst_36297 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
var statearr_36319_36409 = state_36308__$1;
(statearr_36319_36409[(2)] = inst_36297);

(statearr_36319_36409[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (3))){
var inst_36306 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36308__$1,inst_36306);
} else {
if((state_val_36309 === (12))){
var inst_36270 = (state_36308[(7)]);
var inst_36259 = (state_36308[(9)]);
var inst_36276 = (inst_36259.cljs$core$IFn$_invoke$arity$0 ? inst_36259.cljs$core$IFn$_invoke$arity$0() : inst_36259.call(null));
var state_36308__$1 = (function (){var statearr_36320 = state_36308;
(statearr_36320[(10)] = inst_36276);

return statearr_36320;
})();
var statearr_36321_36410 = state_36308__$1;
(statearr_36321_36410[(2)] = inst_36270);

(statearr_36321_36410[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (2))){
var inst_36258 = (state_36308[(8)]);
var inst_36259 = (state_36308[(9)]);
var _ = (function (){var statearr_36322 = state_36308;
(statearr_36322[(4)] = cljs.core.cons((5),(state_36308[(4)])));

return statearr_36322;
})();
var inst_36256 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_36257 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36258__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_36259__$1 = (function (){var expandMaps = inst_36256;
var queue_ch = inst_36257;
var res_ch = inst_36258__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_36260 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_36261 = cljs.core.volatile_BANG_((0));
var inst_36262 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36260,cljs.core.cst$kw$fuel,inst_36261);
var inst_36263 = (function (){var expandMaps = inst_36256;
var queue_ch = inst_36257;
var res_ch = inst_36258__$1;
var stop_BANG_ = inst_36259__$1;
var opts_STAR_ = inst_36262;
return (function (tuple_res,port){
var c__10876__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36355){
var state_val_36356 = (state_36355[(1)]);
if((state_val_36356 === (7))){
var state_36355__$1 = state_36355;
var statearr_36357_36411 = state_36355__$1;
(statearr_36357_36411[(2)] = tuple_res);

(statearr_36357_36411[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (1))){
var state_36355__$1 = state_36355;
var statearr_36358_36412 = state_36355__$1;
(statearr_36358_36412[(2)] = null);

(statearr_36358_36412[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (4))){
var inst_36323 = (state_36355[(2)]);
var inst_36324 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36323);
var inst_36325 = cljs.core.async.close_BANG_(port);
var state_36355__$1 = (function (){var statearr_36359 = state_36355;
(statearr_36359[(7)] = inst_36324);

return statearr_36359;
})();
var statearr_36360_36413 = state_36355__$1;
(statearr_36360_36413[(2)] = inst_36325);

(statearr_36360_36413[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (6))){
var inst_36332 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36333 = [tuple_res];
var inst_36334 = (new cljs.core.PersistentVector(null,1,(5),inst_36332,inst_36333,null));
var state_36355__$1 = state_36355;
var statearr_36361_36414 = state_36355__$1;
(statearr_36361_36414[(2)] = inst_36334);

(statearr_36361_36414[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (3))){
var inst_36353 = (state_36355[(2)]);
var state_36355__$1 = state_36355;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36355__$1,inst_36353);
} else {
if((state_val_36356 === (2))){
var ___$1 = (function (){var statearr_36363 = state_36355;
(statearr_36363[(4)] = cljs.core.cons((5),(state_36355[(4)])));

return statearr_36363;
})();
var state_36355__$1 = state_36355;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_36364_36415 = state_36355__$1;
(statearr_36364_36415[(1)] = (6));

} else {
var statearr_36365_36416 = state_36355__$1;
(statearr_36365_36416[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (9))){
var inst_36339 = (state_36355[(8)]);
var inst_36337 = (state_36355[(9)]);
var inst_36346 = (state_36355[(2)]);
var inst_36347 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_36337,inst_36346);
var inst_36348 = (inst_36339.cljs$core$IFn$_invoke$arity$1 ? inst_36339.cljs$core$IFn$_invoke$arity$1(inst_36347) : inst_36339.call(null,inst_36347));
var inst_36349 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_36348);
var inst_36350 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_36366 = state_36355;
(statearr_36366[(4)] = cljs.core.rest((state_36355[(4)])));

return statearr_36366;
})();
var state_36355__$1 = (function (){var statearr_36367 = state_36355;
(statearr_36367[(10)] = inst_36349);

return statearr_36367;
})();
var statearr_36368_36417 = state_36355__$1;
(statearr_36368_36417[(2)] = inst_36350);

(statearr_36368_36417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (5))){
var ___$1 = (function (){var statearr_36369 = state_36355;
(statearr_36369[(4)] = cljs.core.rest((state_36355[(4)])));

return statearr_36369;
})();
var state_36355__$1 = state_36355;
var ex36362 = (state_36355__$1[(2)]);
var statearr_36370_36418 = state_36355__$1;
(statearr_36370_36418[(5)] = ex36362);


var statearr_36371_36419 = state_36355__$1;
(statearr_36371_36419[(1)] = (4));

(statearr_36371_36419[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_36356 === (8))){
var inst_36337 = (state_36355[(9)]);
var inst_36337__$1 = (state_36355[(2)]);
var inst_36338 = cljs.core.volatile_BANG_((0));
var inst_36339 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36337__$1;
var query_fuel = inst_36338;
return (function (p1__36249_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__36249_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__36249_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_36340 = cljs.core.PersistentVector.EMPTY;
var inst_36341 = (function (){var tuple_res_SINGLEQUOTE_ = inst_36337__$1;
var query_fuel = inst_36338;
return (function (p1__36248_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__36248_SHARP_);
});
})();
var inst_36342 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_36341,expandMaps);
var inst_36343 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_36342);
var inst_36344 = cljs.core.async.into(inst_36340,inst_36343);
var state_36355__$1 = (function (){var statearr_36372 = state_36355;
(statearr_36372[(8)] = inst_36339);

(statearr_36372[(9)] = inst_36337__$1);

return statearr_36372;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36355__$1,(9),inst_36344);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0 = (function (){
var statearr_36373 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_36373[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__);

(statearr_36373[(1)] = (1));

return statearr_36373;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1 = (function (state_36355){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36355);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36374){var ex__10753__auto__ = e36374;
var statearr_36375_36420 = state_36355;
(statearr_36375_36420[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36355[(4)]))){
var statearr_36376_36421 = state_36355;
(statearr_36376_36421[(1)] = cljs.core.first((state_36355[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36422 = state_36355;
state_36355 = G__36422;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__ = function(state_36355){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1.call(this,state_36355);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36377 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36377[(6)] = c__10876__auto____$1);

return statearr_36377;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto____$1;
});
})();
var inst_36264 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_36257,tuples_res);
var inst_36265 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_36258__$1,inst_36263,inst_36257);
var inst_36266 = cljs.core.PersistentVector.EMPTY;
var inst_36267 = inst_36266;
var state_36308__$1 = (function (){var statearr_36378 = state_36308;
(statearr_36378[(11)] = inst_36264);

(statearr_36378[(12)] = inst_36267);

(statearr_36378[(13)] = inst_36265);

(statearr_36378[(8)] = inst_36258__$1);

(statearr_36378[(9)] = inst_36259__$1);

return statearr_36378;
})();
var statearr_36379_36423 = state_36308__$1;
(statearr_36379_36423[(2)] = null);

(statearr_36379_36423[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (19))){
var inst_36267 = (state_36308[(12)]);
var inst_36270 = (state_36308[(7)]);
var inst_36290 = cljs.core.first(inst_36270);
var inst_36291 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36267,inst_36290);
var inst_36267__$1 = inst_36291;
var state_36308__$1 = (function (){var statearr_36380 = state_36308;
(statearr_36380[(12)] = inst_36267__$1);

return statearr_36380;
})();
var statearr_36381_36424 = state_36308__$1;
(statearr_36381_36424[(2)] = null);

(statearr_36381_36424[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (11))){
var inst_36301 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
var statearr_36383_36425 = state_36308__$1;
(statearr_36383_36425[(2)] = inst_36301);

(statearr_36383_36425[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (9))){
var inst_36267 = (state_36308[(12)]);
var state_36308__$1 = state_36308;
var statearr_36384_36426 = state_36308__$1;
(statearr_36384_36426[(2)] = inst_36267);

(statearr_36384_36426[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (5))){
var _ = (function (){var statearr_36385 = state_36308;
(statearr_36385[(4)] = cljs.core.rest((state_36308[(4)])));

return statearr_36385;
})();
var state_36308__$1 = state_36308;
var ex36382 = (state_36308__$1[(2)]);
var statearr_36386_36427 = state_36308__$1;
(statearr_36386_36427[(5)] = ex36382);


if((ex36382 instanceof Error)){
var statearr_36387_36428 = state_36308__$1;
(statearr_36387_36428[(1)] = (4));

(statearr_36387_36428[(5)] = null);

} else {
throw ex36382;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (14))){
var inst_36299 = (state_36308[(2)]);
var state_36308__$1 = state_36308;
var statearr_36388_36429 = state_36308__$1;
(statearr_36388_36429[(2)] = inst_36299);

(statearr_36388_36429[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (16))){
var state_36308__$1 = state_36308;
var statearr_36389_36430 = state_36308__$1;
(statearr_36389_36430[(2)] = null);

(statearr_36389_36430[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (10))){
var inst_36270 = (state_36308[(7)]);
var inst_36274 = fluree.db.util.core.exception_QMARK_(inst_36270);
var state_36308__$1 = state_36308;
if(inst_36274){
var statearr_36390_36431 = state_36308__$1;
(statearr_36390_36431[(1)] = (12));

} else {
var statearr_36391_36432 = state_36308__$1;
(statearr_36391_36432[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (18))){
var inst_36259 = (state_36308[(9)]);
var inst_36283 = (inst_36259.cljs$core$IFn$_invoke$arity$0 ? inst_36259.cljs$core$IFn$_invoke$arity$0() : inst_36259.call(null));
var inst_36284 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_36285 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_36286 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_36287 = cljs.core.PersistentHashMap.fromArrays(inst_36285,inst_36286);
var inst_36288 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36284,inst_36287);
var state_36308__$1 = (function (){var statearr_36392 = state_36308;
(statearr_36392[(14)] = inst_36283);

return statearr_36392;
})();
var statearr_36393_36433 = state_36308__$1;
(statearr_36393_36433[(2)] = inst_36288);

(statearr_36393_36433[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36309 === (8))){
var inst_36270 = (state_36308[(7)]);
var inst_36270__$1 = (state_36308[(2)]);
var inst_36271 = (inst_36270__$1 == null);
var state_36308__$1 = (function (){var statearr_36394 = state_36308;
(statearr_36394[(7)] = inst_36270__$1);

return statearr_36394;
})();
if(cljs.core.truth_(inst_36271)){
var statearr_36395_36434 = state_36308__$1;
(statearr_36395_36434[(1)] = (9));

} else {
var statearr_36396_36435 = state_36308__$1;
(statearr_36396_36435[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0 = (function (){
var statearr_36397 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36397[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__);

(statearr_36397[(1)] = (1));

return statearr_36397;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1 = (function (state_36308){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36308);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36398){var ex__10753__auto__ = e36398;
var statearr_36399_36436 = state_36308;
(statearr_36399_36436[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36308[(4)]))){
var statearr_36400_36437 = state_36308;
(statearr_36400_36437[(1)] = cljs.core.first((state_36308[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36438 = state_36308;
state_36308 = G__36438;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__ = function(state_36308){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1.call(this,state_36308);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36401 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36401[(6)] = c__10876__auto__);

return statearr_36401;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__36439 = select;
var map__36439__$1 = cljs.core.__destructure_map(map__36439);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36439__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36439__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36439__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__36442 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36442,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36442,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36442,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__36440_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36440_SHARP_,compare_idx));
}):(function (p1__36441_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__36441_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__36447 = arguments.length;
switch (G__36447) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__36448,p__36449,group_limit,opts){
var map__36450 = p__36448;
var map__36450__$1 = cljs.core.__destructure_map(map__36450);
var res = map__36450__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36450__$1,cljs.core.cst$kw$vars);
var map__36451 = p__36449;
var map__36451__$1 = cljs.core.__destructure_map(map__36451);
var select_spec = map__36451__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36451__$1,cljs.core.cst$kw$groupBy);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_36588){
var state_val_36589 = (state_36588[(1)]);
if((state_val_36589 === (7))){
var inst_36458 = (state_36588[(7)]);
var state_36588__$1 = state_36588;
var statearr_36590_36692 = state_36588__$1;
(statearr_36590_36692[(2)] = inst_36458);

(statearr_36590_36692[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (59))){
var inst_36581 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
var statearr_36591_36693 = state_36588__$1;
(statearr_36591_36693[(2)] = inst_36581);

(statearr_36591_36693[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (20))){
var inst_36494 = (state_36588[(8)]);
var inst_36497 = (state_36588[(9)]);
var inst_36493 = (state_36588[(2)]);
var inst_36494__$1 = cljs.core.__destructure_map(inst_36493);
var inst_36495 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36494__$1,cljs.core.cst$kw$headers);
var inst_36496 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36494__$1,cljs.core.cst$kw$tuples);
var inst_36497__$1 = offset;
var state_36588__$1 = (function (){var statearr_36592 = state_36588;
(statearr_36592[(8)] = inst_36494__$1);

(statearr_36592[(10)] = inst_36496);

(statearr_36592[(11)] = inst_36495);

(statearr_36592[(9)] = inst_36497__$1);

return statearr_36592;
})();
if(cljs.core.truth_(inst_36497__$1)){
var statearr_36593_36694 = state_36588__$1;
(statearr_36593_36694[(1)] = (21));

} else {
var statearr_36594_36695 = state_36588__$1;
(statearr_36594_36695[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (58))){
var inst_36573 = (state_36588[(12)]);
var state_36588__$1 = state_36588;
var statearr_36595_36696 = state_36588__$1;
(statearr_36595_36696[(2)] = inst_36573);

(statearr_36595_36696[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (60))){
var inst_36577 = (state_36588[(2)]);
var inst_36578 = fluree.db.util.async.throw_err(inst_36577);
var state_36588__$1 = state_36588;
var statearr_36596_36697 = state_36588__$1;
(statearr_36596_36697[(2)] = inst_36578);

(statearr_36596_36697[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (27))){
var inst_36509 = cljs.core.not(inVector_QMARK_);
var state_36588__$1 = state_36588;
var statearr_36597_36698 = state_36588__$1;
(statearr_36597_36698[(2)] = inst_36509);

(statearr_36597_36698[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (1))){
var state_36588__$1 = state_36588;
var statearr_36598_36699 = state_36588__$1;
(statearr_36598_36699[(2)] = null);

(statearr_36598_36699[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (24))){
var state_36588__$1 = state_36588;
var statearr_36599_36700 = state_36588__$1;
(statearr_36599_36700[(2)] = offset);

(statearr_36599_36700[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (55))){
var inst_36567 = (state_36588[(13)]);
var state_36588__$1 = state_36588;
var statearr_36600_36701 = state_36588__$1;
(statearr_36600_36701[(2)] = inst_36567);

(statearr_36600_36701[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (39))){
var inst_36535 = (state_36588[(14)]);
var inst_36537 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_36538 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36535,inst_36537);
var state_36588__$1 = state_36588;
var statearr_36601_36702 = state_36588__$1;
(statearr_36601_36702[(2)] = inst_36538);

(statearr_36601_36702[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (46))){
var inst_36547 = (state_36588[(15)]);
var state_36588__$1 = state_36588;
var statearr_36602_36703 = state_36588__$1;
(statearr_36602_36703[(2)] = inst_36547);

(statearr_36602_36703[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (4))){
var inst_36452 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
var statearr_36603_36704 = state_36588__$1;
(statearr_36603_36704[(2)] = inst_36452);

(statearr_36603_36704[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (54))){
var inst_36561 = (state_36588[(16)]);
var inst_36567 = (state_36588[(13)]);
var inst_36569 = cljs.core.PersistentVector.EMPTY;
var inst_36570 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_36569,inst_36561,inst_36567);
var state_36588__$1 = state_36588;
var statearr_36604_36705 = state_36588__$1;
(statearr_36604_36705[(2)] = inst_36570);

(statearr_36604_36705[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (15))){
var inst_36479 = (state_36588[(17)]);
var inst_36481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36482 = [inst_36479];
var inst_36483 = (new cljs.core.PersistentVector(null,1,(5),inst_36481,inst_36482,null));
var state_36588__$1 = state_36588;
var statearr_36605_36706 = state_36588__$1;
(statearr_36605_36706[(2)] = inst_36483);

(statearr_36605_36706[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (48))){
var inst_36494 = (state_36588[(8)]);
var inst_36553 = (state_36588[(18)]);
var inst_36517 = (state_36588[(19)]);
var inst_36506 = (state_36588[(20)]);
var inst_36512 = (state_36588[(21)]);
var inst_36496 = (state_36588[(10)]);
var inst_36495 = (state_36588[(11)]);
var inst_36555 = (function (){var map__36488 = inst_36494;
var headers = inst_36495;
var tuples = inst_36496;
var offset_SINGLEQUOTE_ = inst_36506;
var single_result_QMARK_ = inst_36512;
var pp_keys = inst_36517;
var G__36518 = inst_36553;
return (function (p1__36445_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__36445_SHARP_);
});
})();
var inst_36556 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36555);
var inst_36557 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36553,inst_36556);
var state_36588__$1 = state_36588;
var statearr_36606_36707 = state_36588__$1;
(statearr_36606_36707[(2)] = inst_36557);

(statearr_36606_36707[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (50))){
var inst_36560 = (state_36588[(2)]);
var inst_36561 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_36560);
var state_36588__$1 = (function (){var statearr_36607 = state_36588;
(statearr_36607[(16)] = inst_36561);

return statearr_36607;
})();
if(cljs.core.truth_(orderBy)){
var statearr_36608_36708 = state_36588__$1;
(statearr_36608_36708[(1)] = (51));

} else {
var statearr_36609_36709 = state_36588__$1;
(statearr_36609_36709[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (21))){
var inst_36499 = cljs.core.not(groupBy);
var state_36588__$1 = state_36588;
var statearr_36610_36710 = state_36588__$1;
(statearr_36610_36710[(2)] = inst_36499);

(statearr_36610_36710[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (31))){
var state_36588__$1 = state_36588;
var statearr_36611_36711 = state_36588__$1;
(statearr_36611_36711[(2)] = null);

(statearr_36611_36711[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (32))){
var inst_36512 = (state_36588[(21)]);
var inst_36495 = (state_36588[(11)]);
var inst_36517 = (state_36588[(2)]);
var inst_36519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36520 = fluree.db.query.fql.select_tuples_fn(inst_36495,vars,select);
var inst_36521 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_36520);
var inst_36522 = [inst_36521];
var inst_36523 = (new cljs.core.PersistentVector(null,1,(5),inst_36519,inst_36522,null));
var state_36588__$1 = (function (){var statearr_36612 = state_36588;
(statearr_36612[(22)] = inst_36523);

(statearr_36612[(19)] = inst_36517);

return statearr_36612;
})();
if(cljs.core.truth_(inst_36512)){
var statearr_36613_36712 = state_36588__$1;
(statearr_36613_36712[(1)] = (33));

} else {
var statearr_36614_36713 = state_36588__$1;
(statearr_36614_36713[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (40))){
var inst_36535 = (state_36588[(14)]);
var state_36588__$1 = state_36588;
var statearr_36615_36714 = state_36588__$1;
(statearr_36615_36714[(2)] = inst_36535);

(statearr_36615_36714[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (56))){
var inst_36573 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36616 = state_36588;
(statearr_36616[(12)] = inst_36573);

return statearr_36616;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_36617_36715 = state_36588__$1;
(statearr_36617_36715[(1)] = (57));

} else {
var statearr_36618_36716 = state_36588__$1;
(statearr_36618_36716[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (33))){
var inst_36523 = (state_36588[(22)]);
var inst_36525 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_36526 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36523,inst_36525);
var state_36588__$1 = state_36588;
var statearr_36619_36717 = state_36588__$1;
(statearr_36619_36717[(2)] = inst_36526);

(statearr_36619_36717[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (13))){
var inst_36468 = (state_36588[(23)]);
var state_36588__$1 = state_36588;
var statearr_36620_36718 = state_36588__$1;
(statearr_36620_36718[(2)] = inst_36468);

(statearr_36620_36718[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (22))){
var inst_36497 = (state_36588[(9)]);
var state_36588__$1 = state_36588;
var statearr_36621_36719 = state_36588__$1;
(statearr_36621_36719[(2)] = inst_36497);

(statearr_36621_36719[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (36))){
var inst_36529 = (state_36588[(24)]);
var inst_36531 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_36532 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36529,inst_36531);
var state_36588__$1 = state_36588;
var statearr_36622_36720 = state_36588__$1;
(statearr_36622_36720[(2)] = inst_36532);

(statearr_36622_36720[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (41))){
var inst_36506 = (state_36588[(20)]);
var inst_36541 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36623 = state_36588;
(statearr_36623[(25)] = inst_36541);

return statearr_36623;
})();
if(cljs.core.truth_(inst_36506)){
var statearr_36624_36721 = state_36588__$1;
(statearr_36624_36721[(1)] = (42));

} else {
var statearr_36625_36722 = state_36588__$1;
(statearr_36625_36722[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (43))){
var inst_36541 = (state_36588[(25)]);
var state_36588__$1 = state_36588;
var statearr_36626_36723 = state_36588__$1;
(statearr_36626_36723[(2)] = inst_36541);

(statearr_36626_36723[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (29))){
var inst_36512 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36627 = state_36588;
(statearr_36627[(21)] = inst_36512);

return statearr_36627;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36628_36724 = state_36588__$1;
(statearr_36628_36724[(1)] = (30));

} else {
var statearr_36629_36725 = state_36588__$1;
(statearr_36629_36725[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (44))){
var inst_36547 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36630 = state_36588;
(statearr_36630[(15)] = inst_36547);

return statearr_36630;
})();
if(cljs.core.truth_(group_limit)){
var statearr_36631_36726 = state_36588__$1;
(statearr_36631_36726[(1)] = (45));

} else {
var statearr_36632_36727 = state_36588__$1;
(statearr_36632_36727[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (6))){
var inst_36460 = cljs.core.count(select);
var inst_36461 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_36460);
var state_36588__$1 = state_36588;
var statearr_36633_36728 = state_36588__$1;
(statearr_36633_36728[(2)] = inst_36461);

(statearr_36633_36728[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (28))){
var inst_36507 = (state_36588[(26)]);
var state_36588__$1 = state_36588;
var statearr_36634_36729 = state_36588__$1;
(statearr_36634_36729[(2)] = inst_36507);

(statearr_36634_36729[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (51))){
var inst_36496 = (state_36588[(10)]);
var inst_36495 = (state_36588[(11)]);
var inst_36564 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_36495,orderBy,inst_36496);
var state_36588__$1 = state_36588;
var statearr_36635_36730 = state_36588__$1;
(statearr_36635_36730[(2)] = inst_36564);

(statearr_36635_36730[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (25))){
var state_36588__$1 = state_36588;
var statearr_36636_36731 = state_36588__$1;
(statearr_36636_36731[(2)] = null);

(statearr_36636_36731[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (34))){
var inst_36523 = (state_36588[(22)]);
var state_36588__$1 = state_36588;
var statearr_36637_36732 = state_36588__$1;
(statearr_36637_36732[(2)] = inst_36523);

(statearr_36637_36732[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (17))){
var inst_36486 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
var statearr_36638_36733 = state_36588__$1;
(statearr_36638_36733[(2)] = inst_36486);

(statearr_36638_36733[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (3))){
var inst_36586 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36588__$1,inst_36586);
} else {
if((state_val_36589 === (12))){
var inst_36468 = (state_36588[(23)]);
var inst_36470 = cljs.core.first(select);
var inst_36471 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_36470);
var inst_36472 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36471);
var inst_36473 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_36472,(1));
var inst_36474 = [inst_36473];
var inst_36475 = [inst_36468];
var inst_36476 = cljs.core.PersistentHashMap.fromArrays(inst_36474,inst_36475);
var state_36588__$1 = state_36588;
var statearr_36639_36734 = state_36588__$1;
(statearr_36639_36734[(2)] = inst_36476);

(statearr_36639_36734[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (2))){
var inst_36458 = (state_36588[(7)]);
var _ = (function (){var statearr_36640 = state_36588;
(statearr_36640[(4)] = cljs.core.cons((5),(state_36588[(4)])));

return statearr_36640;
})();
var inst_36458__$1 = aggregates;
var state_36588__$1 = (function (){var statearr_36641 = state_36588;
(statearr_36641[(7)] = inst_36458__$1);

return statearr_36641;
})();
if(cljs.core.truth_(inst_36458__$1)){
var statearr_36642_36735 = state_36588__$1;
(statearr_36642_36735[(1)] = (6));

} else {
var statearr_36643_36736 = state_36588__$1;
(statearr_36643_36736[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (23))){
var inst_36502 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
if(cljs.core.truth_(inst_36502)){
var statearr_36644_36737 = state_36588__$1;
(statearr_36644_36737[(1)] = (24));

} else {
var statearr_36645_36738 = state_36588__$1;
(statearr_36645_36738[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (47))){
var inst_36553 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36646 = state_36588;
(statearr_36646[(18)] = inst_36553);

return statearr_36646;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36647_36739 = state_36588__$1;
(statearr_36647_36739[(1)] = (48));

} else {
var statearr_36648_36740 = state_36588__$1;
(statearr_36648_36740[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (35))){
var inst_36529 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36649 = state_36588;
(statearr_36649[(24)] = inst_36529);

return statearr_36649;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36650_36741 = state_36588__$1;
(statearr_36650_36741[(1)] = (36));

} else {
var statearr_36651_36742 = state_36588__$1;
(statearr_36651_36742[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (19))){
var state_36588__$1 = state_36588;
var statearr_36652_36743 = state_36588__$1;
(statearr_36652_36743[(2)] = res);

(statearr_36652_36743[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (57))){
var inst_36573 = (state_36588[(12)]);
var inst_36517 = (state_36588[(19)]);
var inst_36512 = (state_36588[(21)]);
var inst_36575 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_36517,inst_36512,db,fuel,max_fuel,opts,(8),inst_36573);
var state_36588__$1 = state_36588;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36588__$1,(60),inst_36575);
} else {
if((state_val_36589 === (11))){
var inst_36583 = (state_36588[(2)]);
var _ = (function (){var statearr_36654 = state_36588;
(statearr_36654[(4)] = cljs.core.rest((state_36588[(4)])));

return statearr_36654;
})();
var state_36588__$1 = state_36588;
var statearr_36655_36744 = state_36588__$1;
(statearr_36655_36744[(2)] = inst_36583);

(statearr_36655_36744[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (9))){
var inst_36466 = cljs.core.first(aggregates);
var inst_36467 = fluree.db.query.analytical.calculate_aggregate(res,inst_36466);
var inst_36468 = cljs.core.second(inst_36467);
var state_36588__$1 = (function (){var statearr_36656 = state_36588;
(statearr_36656[(23)] = inst_36468);

return statearr_36656;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_36657_36745 = state_36588__$1;
(statearr_36657_36745[(1)] = (12));

} else {
var statearr_36658_36746 = state_36588__$1;
(statearr_36658_36746[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (5))){
var _ = (function (){var statearr_36659 = state_36588;
(statearr_36659[(4)] = cljs.core.rest((state_36588[(4)])));

return statearr_36659;
})();
var state_36588__$1 = state_36588;
var ex36653 = (state_36588__$1[(2)]);
var statearr_36660_36747 = state_36588__$1;
(statearr_36660_36747[(5)] = ex36653);


if((ex36653 instanceof Error)){
var statearr_36661_36748 = state_36588__$1;
(statearr_36661_36748[(1)] = (4));

(statearr_36661_36748[(5)] = null);

} else {
throw ex36653;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (14))){
var inst_36479 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36662 = state_36588;
(statearr_36662[(17)] = inst_36479);

return statearr_36662;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_36663_36749 = state_36588__$1;
(statearr_36663_36749[(1)] = (15));

} else {
var statearr_36664_36750 = state_36588__$1;
(statearr_36664_36750[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (45))){
var inst_36547 = (state_36588[(15)]);
var inst_36549 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_36550 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36547,inst_36549);
var state_36588__$1 = state_36588;
var statearr_36665_36751 = state_36588__$1;
(statearr_36665_36751[(2)] = inst_36550);

(statearr_36665_36751[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (53))){
var inst_36567 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36666 = state_36588;
(statearr_36666[(13)] = inst_36567);

return statearr_36666;
})();
var statearr_36667_36752 = state_36588__$1;
(statearr_36667_36752[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (26))){
var inst_36507 = (state_36588[(26)]);
var inst_36506 = (state_36588[(2)]);
var inst_36507__$1 = cljs.core.not(prettyPrint);
var state_36588__$1 = (function (){var statearr_36669 = state_36588;
(statearr_36669[(26)] = inst_36507__$1);

(statearr_36669[(20)] = inst_36506);

return statearr_36669;
})();
if(inst_36507__$1){
var statearr_36670_36753 = state_36588__$1;
(statearr_36670_36753[(1)] = (27));

} else {
var statearr_36671_36754 = state_36588__$1;
(statearr_36671_36754[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (16))){
var inst_36479 = (state_36588[(17)]);
var state_36588__$1 = state_36588;
var statearr_36672_36755 = state_36588__$1;
(statearr_36672_36755[(2)] = inst_36479);

(statearr_36672_36755[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (38))){
var inst_36535 = (state_36588[(2)]);
var state_36588__$1 = (function (){var statearr_36673 = state_36588;
(statearr_36673[(14)] = inst_36535);

return statearr_36673;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_36674_36756 = state_36588__$1;
(statearr_36674_36756[(1)] = (39));

} else {
var statearr_36675_36757 = state_36588__$1;
(statearr_36675_36757[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (30))){
var inst_36514 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_36588__$1 = state_36588;
var statearr_36676_36758 = state_36588__$1;
(statearr_36676_36758[(2)] = inst_36514);

(statearr_36676_36758[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (10))){
var state_36588__$1 = state_36588;
if(cljs.core.truth_(aggregates)){
var statearr_36677_36759 = state_36588__$1;
(statearr_36677_36759[(1)] = (18));

} else {
var statearr_36678_36760 = state_36588__$1;
(statearr_36678_36760[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (18))){
var inst_36490 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_36588__$1 = state_36588;
var statearr_36679_36761 = state_36588__$1;
(statearr_36679_36761[(2)] = inst_36490);

(statearr_36679_36761[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (52))){
var inst_36496 = (state_36588[(10)]);
var state_36588__$1 = state_36588;
var statearr_36680_36762 = state_36588__$1;
(statearr_36680_36762[(2)] = inst_36496);

(statearr_36680_36762[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (42))){
var inst_36541 = (state_36588[(25)]);
var inst_36506 = (state_36588[(20)]);
var inst_36543 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_36506);
var inst_36544 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_36541,inst_36543);
var state_36588__$1 = state_36588;
var statearr_36681_36763 = state_36588__$1;
(statearr_36681_36763[(2)] = inst_36544);

(statearr_36681_36763[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (37))){
var inst_36529 = (state_36588[(24)]);
var state_36588__$1 = state_36588;
var statearr_36682_36764 = state_36588__$1;
(statearr_36682_36764[(2)] = inst_36529);

(statearr_36682_36764[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (8))){
var inst_36464 = (state_36588[(2)]);
var state_36588__$1 = state_36588;
if(cljs.core.truth_(inst_36464)){
var statearr_36683_36765 = state_36588__$1;
(statearr_36683_36765[(1)] = (9));

} else {
var statearr_36684_36766 = state_36588__$1;
(statearr_36684_36766[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36589 === (49))){
var inst_36553 = (state_36588[(18)]);
var state_36588__$1 = state_36588;
var statearr_36685_36767 = state_36588__$1;
(statearr_36685_36767[(2)] = inst_36553);

(statearr_36685_36767[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__10750__auto__ = null;
var fluree$db$query$fql$state_machine__10750__auto____0 = (function (){
var statearr_36686 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36686[(0)] = fluree$db$query$fql$state_machine__10750__auto__);

(statearr_36686[(1)] = (1));

return statearr_36686;
});
var fluree$db$query$fql$state_machine__10750__auto____1 = (function (state_36588){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_36588);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e36687){var ex__10753__auto__ = e36687;
var statearr_36688_36768 = state_36588;
(statearr_36688_36768[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_36588[(4)]))){
var statearr_36689_36769 = state_36588;
(statearr_36689_36769[(1)] = cljs.core.first((state_36588[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__36770 = state_36588;
state_36588 = G__36770;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__10750__auto__ = function(state_36588){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__10750__auto____1.call(this,state_36588);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__10750__auto____0;
fluree$db$query$fql$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__10750__auto____1;
return fluree$db$query$fql$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_36690 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_36690[(6)] = c__10876__auto__);

return statearr_36690;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__36773,groupBy){
var map__36774 = p__36773;
var map__36774__$1 = cljs.core.__destructure_map(map__36774);
var res = map__36774__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36774__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36774__$1,cljs.core.cst$kw$tuples);
var vec__36775 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36775,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36775,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36771_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36771_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36772_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36772_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__36778 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36778,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36778,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__36781,p__36782,opts){
var map__36783 = p__36781;
var map__36783__$1 = cljs.core.__destructure_map(map__36783);
var res = map__36783__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36783__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36783__$1,cljs.core.cst$kw$vars);
var map__36784 = p__36782;
var map__36784__$1 = cljs.core.__destructure_map(map__36784);
var select_spec = map__36784__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36784__$1,cljs.core.cst$kw$offset);
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_37026){
var state_val_37027 = (state_37026[(1)]);
if((state_val_37027 === (65))){
var state_37026__$1 = state_37026;
var statearr_37028_37179 = state_37026__$1;
(statearr_37028_37179[(1)] = (67));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (70))){
var inst_36947 = (state_37026[(7)]);
var state_37026__$1 = state_37026;
var statearr_37030_37180 = state_37026__$1;
(statearr_37030_37180[(2)] = inst_36947);

(statearr_37030_37180[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (62))){
var state_37026__$1 = state_37026;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37031_37181 = state_37026__$1;
(statearr_37031_37181[(1)] = (64));

} else {
var statearr_37032_37182 = state_37026__$1;
(statearr_37032_37182[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (74))){
var inst_36922 = (state_37026[(8)]);
var inst_36863 = (state_37026[(9)]);
var inst_36854 = (state_37026[(10)]);
var inst_36955 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36854,inst_36863,inst_36922);
var state_37026__$1 = state_37026;
var statearr_37033_37183 = state_37026__$1;
(statearr_37033_37183[(2)] = inst_36955);

(statearr_37033_37183[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (7))){
var state_37026__$1 = state_37026;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37034_37184 = state_37026__$1;
(statearr_37034_37184[(1)] = (82));

} else {
var statearr_37035_37185 = state_37026__$1;
(statearr_37035_37185[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (59))){
var inst_36852 = (state_37026[(11)]);
var inst_36922 = (state_37026[(8)]);
var inst_36926 = cljs.core.count(inst_36922);
var inst_36927 = (inst_36852 - inst_36926);
var state_37026__$1 = state_37026;
var statearr_37036_37186 = state_37026__$1;
(statearr_37036_37186[(2)] = inst_36927);

(statearr_37036_37186[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (86))){
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_37037_37187 = state_37026__$1;
(statearr_37037_37187[(1)] = (89));

} else {
var statearr_37038_37188 = state_37026__$1;
(statearr_37038_37188[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (20))){
var state_37026__$1 = state_37026;
var statearr_37039_37189 = state_37026__$1;
(statearr_37039_37189[(2)] = (0));

(statearr_37039_37189[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (72))){
var inst_36952 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36952)){
var statearr_37040_37190 = state_37026__$1;
(statearr_37040_37190[(1)] = (73));

} else {
var statearr_37041_37191 = state_37026__$1;
(statearr_37041_37191[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (58))){
var state_37026__$1 = state_37026;
var statearr_37042_37192 = state_37026__$1;
(statearr_37042_37192[(2)] = null);

(statearr_37042_37192[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (60))){
var inst_36853 = (state_37026[(12)]);
var inst_36929 = (state_37026[(2)]);
var inst_36930 = (inst_36853 <= (0));
var state_37026__$1 = (function (){var statearr_37043 = state_37026;
(statearr_37043[(13)] = inst_36929);

return statearr_37043;
})();
if(cljs.core.truth_(inst_36930)){
var statearr_37044_37193 = state_37026__$1;
(statearr_37044_37193[(1)] = (61));

} else {
var statearr_37045_37194 = state_37026__$1;
(statearr_37045_37194[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (27))){
var inst_36852 = (state_37026[(11)]);
var inst_36876 = (inst_36852 < (1));
var state_37026__$1 = state_37026;
var statearr_37046_37195 = state_37026__$1;
(statearr_37046_37195[(2)] = inst_36876);

(statearr_37046_37195[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (1))){
var state_37026__$1 = state_37026;
var statearr_37047_37196 = state_37026__$1;
(statearr_37047_37196[(2)] = null);

(statearr_37047_37196[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (69))){
var inst_36942 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37048_37197 = state_37026__$1;
(statearr_37048_37197[(2)] = inst_36942);

(statearr_37048_37197[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (24))){
var inst_36854 = (state_37026[(10)]);
var state_37026__$1 = state_37026;
var statearr_37049_37198 = state_37026__$1;
(statearr_37049_37198[(2)] = inst_36854);

(statearr_37049_37198[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (55))){
var inst_36852 = (state_37026[(11)]);
var inst_36912 = (state_37026[(14)]);
var inst_36919 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_36852,inst_36912);
var state_37026__$1 = state_37026;
var statearr_37050_37199 = state_37026__$1;
(statearr_37050_37199[(2)] = inst_36919);

(statearr_37050_37199[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (85))){
var inst_36997 = (state_37026[(15)]);
var inst_36996 = (state_37026[(2)]);
var inst_36997__$1 = fluree.db.util.async.throw_err(inst_36996);
var inst_36998 = cljs.core.coll_QMARK_(inst_36997__$1);
var inst_36999 = (!(inst_36998));
var state_37026__$1 = (function (){var statearr_37051 = state_37026;
(statearr_37051[(15)] = inst_36997__$1);

return statearr_37051;
})();
if(inst_36999){
var statearr_37052_37200 = state_37026__$1;
(statearr_37052_37200[(1)] = (86));

} else {
var statearr_37053_37201 = state_37026__$1;
(statearr_37053_37201[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (39))){
var inst_36871 = (state_37026[(16)]);
var inst_36893 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_36894 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_36895 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_36871,inst_36893,inst_36894);
var state_37026__$1 = state_37026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37026__$1,(42),inst_36895);
} else {
if((state_val_37027 === (88))){
var inst_37019 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37054_37202 = state_37026__$1;
(statearr_37054_37202[(2)] = inst_37019);

(statearr_37054_37202[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (46))){
var inst_36853 = (state_37026[(12)]);
var inst_36907 = ((0) < inst_36853);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36907)){
var statearr_37055_37203 = state_37026__$1;
(statearr_37055_37203[(1)] = (49));

} else {
var statearr_37056_37204 = state_37026__$1;
(statearr_37056_37204[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (4))){
var inst_36785 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37057_37205 = state_37026__$1;
(statearr_37057_37205[(2)] = inst_36785);

(statearr_37057_37205[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (77))){
var inst_36852 = (state_37026[(11)]);
var inst_36963 = (inst_36852 - (1));
var state_37026__$1 = state_37026;
var statearr_37058_37206 = state_37026__$1;
(statearr_37058_37206[(2)] = inst_36963);

(statearr_37058_37206[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (95))){
var inst_36997 = (state_37026[(15)]);
var state_37026__$1 = state_37026;
var statearr_37059_37207 = state_37026__$1;
(statearr_37059_37207[(2)] = inst_36997);

(statearr_37059_37207[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (54))){
var inst_36917 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36917)){
var statearr_37060_37208 = state_37026__$1;
(statearr_37060_37208[(1)] = (55));

} else {
var statearr_37061_37209 = state_37026__$1;
(statearr_37061_37209[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (92))){
var inst_36997 = (state_37026[(15)]);
var inst_37010 = cljs.core.first(inst_36997);
var state_37026__$1 = state_37026;
var statearr_37062_37210 = state_37026__$1;
(statearr_37062_37210[(2)] = inst_37010);

(statearr_37062_37210[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (15))){
var inst_36803 = (state_37026[(17)]);
var inst_36811 = (state_37026[(2)]);
var inst_36812 = fluree.db.util.async.throw_err(inst_36811);
var inst_36813 = [inst_36803];
var inst_36814 = [inst_36812];
var inst_36815 = cljs.core.PersistentHashMap.fromArrays(inst_36813,inst_36814);
var state_37026__$1 = state_37026;
var statearr_37063_37211 = state_37026__$1;
(statearr_37063_37211[(2)] = inst_36815);

(statearr_37063_37211[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (48))){
var inst_36975 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37064_37212 = state_37026__$1;
(statearr_37064_37212[(2)] = inst_36975);

(statearr_37064_37212[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (50))){
var inst_36898 = (state_37026[(18)]);
var state_37026__$1 = state_37026;
var statearr_37065_37213 = state_37026__$1;
(statearr_37065_37213[(2)] = inst_36898);

(statearr_37065_37213[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (75))){
var inst_36867 = (state_37026[(19)]);
var inst_36946 = (state_37026[(20)]);
var inst_36864 = (state_37026[(21)]);
var inst_36929 = (state_37026[(13)]);
var inst_36957 = (state_37026[(2)]);
var inst_36850 = inst_36864;
var inst_36851 = inst_36867;
var inst_36852 = inst_36929;
var inst_36853 = inst_36946;
var inst_36854 = inst_36957;
var state_37026__$1 = (function (){var statearr_37066 = state_37026;
(statearr_37066[(12)] = inst_36853);

(statearr_37066[(11)] = inst_36852);

(statearr_37066[(22)] = inst_36851);

(statearr_37066[(23)] = inst_36850);

(statearr_37066[(10)] = inst_36854);

return statearr_37066;
})();
var statearr_37067_37214 = state_37026__$1;
(statearr_37067_37214[(2)] = null);

(statearr_37067_37214[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (21))){
var inst_36843 = (state_37026[(24)]);
var inst_36835 = (state_37026[(25)]);
var inst_36831 = (state_37026[(26)]);
var inst_36848 = (state_37026[(2)]);
var inst_36849 = cljs.core.PersistentHashMap.EMPTY;
var inst_36850 = inst_36831;
var inst_36851 = inst_36835;
var inst_36852 = inst_36843;
var inst_36853 = inst_36848;
var inst_36854 = inst_36849;
var state_37026__$1 = (function (){var statearr_37068 = state_37026;
(statearr_37068[(12)] = inst_36853);

(statearr_37068[(11)] = inst_36852);

(statearr_37068[(22)] = inst_36851);

(statearr_37068[(23)] = inst_36850);

(statearr_37068[(10)] = inst_36854);

return statearr_37068;
})();
var statearr_37069_37215 = state_37026__$1;
(statearr_37069_37215[(2)] = null);

(statearr_37069_37215[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (31))){
var inst_36853 = (state_37026[(12)]);
var inst_36868 = (state_37026[(27)]);
var inst_36882 = (inst_36853 >= inst_36868);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36882)){
var statearr_37070_37216 = state_37026__$1;
(statearr_37070_37216[(1)] = (33));

} else {
var statearr_37071_37217 = state_37026__$1;
(statearr_37071_37217[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (32))){
var inst_36982 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37072_37218 = state_37026__$1;
(statearr_37072_37218[(2)] = inst_36982);

(statearr_37072_37218[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (40))){
var state_37026__$1 = state_37026;
var statearr_37073_37219 = state_37026__$1;
(statearr_37073_37219[(2)] = null);

(statearr_37073_37219[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (91))){
var inst_37007 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37074_37220 = state_37026__$1;
(statearr_37074_37220[(2)] = inst_37007);

(statearr_37074_37220[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (56))){
var inst_36912 = (state_37026[(14)]);
var state_37026__$1 = state_37026;
var statearr_37075_37221 = state_37026__$1;
(statearr_37075_37221[(2)] = inst_36912);

(statearr_37075_37221[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (33))){
var state_37026__$1 = state_37026;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_37076_37222 = state_37026__$1;
(statearr_37076_37222[(1)] = (36));

} else {
var statearr_37077_37223 = state_37026__$1;
(statearr_37077_37223[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (13))){
var inst_36835 = (state_37026[(25)]);
var inst_36800 = (state_37026[(28)]);
var inst_36831 = (state_37026[(26)]);
var inst_36831__$1 = cljs.core.keys(inst_36800);
var inst_36832 = cljs.core.seq(inst_36831__$1);
var inst_36833 = cljs.core.first(inst_36832);
var inst_36834 = cljs.core.next(inst_36832);
var inst_36835__$1 = cljs.core.vals(inst_36800);
var inst_36836 = cljs.core.seq(inst_36835__$1);
var inst_36837 = cljs.core.first(inst_36836);
var inst_36838 = cljs.core.next(inst_36836);
var inst_36839 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_37026__$1 = (function (){var statearr_37078 = state_37026;
(statearr_37078[(29)] = inst_36833);

(statearr_37078[(25)] = inst_36835__$1);

(statearr_37078[(30)] = inst_36837);

(statearr_37078[(26)] = inst_36831__$1);

(statearr_37078[(31)] = inst_36838);

(statearr_37078[(32)] = inst_36834);

return statearr_37078;
})();
if(inst_36839){
var statearr_37079_37224 = state_37026__$1;
(statearr_37079_37224[(1)] = (16));

} else {
var statearr_37080_37225 = state_37026__$1;
(statearr_37080_37225[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (22))){
var inst_36851 = (state_37026[(22)]);
var inst_36850 = (state_37026[(23)]);
var inst_36862 = cljs.core.seq(inst_36850);
var inst_36863 = cljs.core.first(inst_36862);
var inst_36864 = cljs.core.next(inst_36862);
var inst_36865 = cljs.core.seq(inst_36851);
var inst_36866 = cljs.core.first(inst_36865);
var inst_36867 = cljs.core.next(inst_36865);
var inst_36868 = cljs.core.count(inst_36866);
var inst_36869 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_36870 = [headers,vars,inst_36866];
var inst_36871 = cljs.core.PersistentHashMap.fromArrays(inst_36869,inst_36870);
var inst_36872 = (inst_36866 == null);
var state_37026__$1 = (function (){var statearr_37081 = state_37026;
(statearr_37081[(19)] = inst_36867);

(statearr_37081[(21)] = inst_36864);

(statearr_37081[(9)] = inst_36863);

(statearr_37081[(16)] = inst_36871);

(statearr_37081[(27)] = inst_36868);

return statearr_37081;
})();
if(cljs.core.truth_(inst_36872)){
var statearr_37082_37226 = state_37026__$1;
(statearr_37082_37226[(1)] = (24));

} else {
var statearr_37083_37227 = state_37026__$1;
(statearr_37083_37227[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (90))){
var inst_36997 = (state_37026[(15)]);
var state_37026__$1 = state_37026;
var statearr_37084_37228 = state_37026__$1;
(statearr_37084_37228[(2)] = inst_36997);

(statearr_37084_37228[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (36))){
var inst_36853 = (state_37026[(12)]);
var inst_36885 = (inst_36853 - (1));
var state_37026__$1 = state_37026;
var statearr_37085_37229 = state_37026__$1;
(statearr_37085_37229[(2)] = inst_36885);

(statearr_37085_37229[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (41))){
var inst_36978 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37086_37230 = state_37026__$1;
(statearr_37086_37230[(2)] = inst_36978);

(statearr_37086_37230[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (89))){
var inst_36997 = (state_37026[(15)]);
var inst_37002 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37003 = [inst_36997];
var inst_37004 = (new cljs.core.PersistentVector(null,1,(5),inst_37002,inst_37003,null));
var state_37026__$1 = state_37026;
var statearr_37087_37231 = state_37026__$1;
(statearr_37087_37231[(2)] = inst_37004);

(statearr_37087_37231[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (43))){
var inst_36898 = (state_37026[(18)]);
var inst_36901 = cljs.core.seq(inst_36898);
var state_37026__$1 = state_37026;
var statearr_37088_37232 = state_37026__$1;
(statearr_37088_37232[(2)] = inst_36901);

(statearr_37088_37232[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (61))){
var state_37026__$1 = state_37026;
var statearr_37089_37233 = state_37026__$1;
(statearr_37089_37233[(2)] = (0));

(statearr_37089_37233[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (29))){
var inst_36879 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36879)){
var statearr_37090_37234 = state_37026__$1;
(statearr_37090_37234[(1)] = (30));

} else {
var statearr_37091_37235 = state_37026__$1;
(statearr_37091_37235[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (44))){
var inst_36899 = (state_37026[(33)]);
var state_37026__$1 = state_37026;
var statearr_37092_37236 = state_37026__$1;
(statearr_37092_37236[(2)] = inst_36899);

(statearr_37092_37236[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (93))){
var state_37026__$1 = state_37026;
var statearr_37093_37237 = state_37026__$1;
(statearr_37093_37237[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (6))){
var inst_36792 = (state_37026[(34)]);
var inst_36792__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_36794 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_37026__$1 = (function (){var statearr_37095 = state_37026;
(statearr_37095[(35)] = inst_36794);

(statearr_37095[(34)] = inst_36792__$1);

return statearr_37095;
})();
if(cljs.core.truth_(inst_36792__$1)){
var statearr_37096_37238 = state_37026__$1;
(statearr_37096_37238[(1)] = (9));

} else {
var statearr_37097_37239 = state_37026__$1;
(statearr_37097_37239[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (28))){
var inst_36852 = (state_37026[(11)]);
var state_37026__$1 = state_37026;
var statearr_37098_37240 = state_37026__$1;
(statearr_37098_37240[(2)] = inst_36852);

(statearr_37098_37240[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (64))){
var inst_36853 = (state_37026[(12)]);
var inst_36934 = (inst_36853 - (1));
var state_37026__$1 = state_37026;
var statearr_37099_37241 = state_37026__$1;
(statearr_37099_37241[(2)] = inst_36934);

(statearr_37099_37241[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (51))){
var inst_36852 = (state_37026[(11)]);
var inst_36912 = (state_37026[(2)]);
var state_37026__$1 = (function (){var statearr_37100 = state_37026;
(statearr_37100[(14)] = inst_36912);

return statearr_37100;
})();
if(cljs.core.truth_(inst_36852)){
var statearr_37101_37242 = state_37026__$1;
(statearr_37101_37242[(1)] = (52));

} else {
var statearr_37102_37243 = state_37026__$1;
(statearr_37102_37243[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (25))){
var inst_36852 = (state_37026[(11)]);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36852)){
var statearr_37103_37244 = state_37026__$1;
(statearr_37103_37244[(1)] = (27));

} else {
var statearr_37104_37245 = state_37026__$1;
(statearr_37104_37245[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (34))){
var state_37026__$1 = state_37026;
var statearr_37105_37246 = state_37026__$1;
(statearr_37105_37246[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (17))){
var state_37026__$1 = state_37026;
var statearr_37107_37247 = state_37026__$1;
(statearr_37107_37247[(2)] = limit);

(statearr_37107_37247[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (3))){
var inst_37024 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37026__$1,inst_37024);
} else {
if((state_val_37027 === (12))){
var inst_36800 = (state_37026[(28)]);
var inst_36802 = cljs.core.keys(inst_36800);
var inst_36803 = cljs.core.first(inst_36802);
var inst_36804 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_36805 = cljs.core.vals(inst_36800);
var inst_36806 = cljs.core.first(inst_36805);
var inst_36807 = [headers,vars,inst_36806];
var inst_36808 = cljs.core.PersistentHashMap.fromArrays(inst_36804,inst_36807);
var inst_36809 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_36808,select_spec,limit,opts);
var state_37026__$1 = (function (){var statearr_37108 = state_37026;
(statearr_37108[(17)] = inst_36803);

return statearr_37108;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37026__$1,(15),inst_36809);
} else {
if((state_val_37027 === (2))){
var _ = (function (){var statearr_37109 = state_37026;
(statearr_37109[(4)] = cljs.core.cons((5),(state_37026[(4)])));

return statearr_37109;
})();
var state_37026__$1 = state_37026;
if(cljs.core.truth_(groupBy)){
var statearr_37110_37248 = state_37026__$1;
(statearr_37110_37248[(1)] = (6));

} else {
var statearr_37111_37249 = state_37026__$1;
(statearr_37111_37249[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (66))){
var inst_36944 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37112_37250 = state_37026__$1;
(statearr_37112_37250[(2)] = inst_36944);

(statearr_37112_37250[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (23))){
var inst_36986 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37113_37251 = state_37026__$1;
(statearr_37113_37251[(2)] = inst_36986);

(statearr_37113_37251[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (47))){
var inst_36852 = (state_37026[(11)]);
var inst_36960 = (inst_36852 == null);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36960)){
var statearr_37114_37252 = state_37026__$1;
(statearr_37114_37252[(1)] = (76));

} else {
var statearr_37115_37253 = state_37026__$1;
(statearr_37115_37253[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (35))){
var inst_36980 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37116_37254 = state_37026__$1;
(statearr_37116_37254[(2)] = inst_36980);

(statearr_37116_37254[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (82))){
var state_37026__$1 = state_37026;
var statearr_37117_37255 = state_37026__$1;
(statearr_37117_37255[(2)] = (1));

(statearr_37117_37255[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (76))){
var state_37026__$1 = state_37026;
var statearr_37118_37256 = state_37026__$1;
(statearr_37118_37256[(2)] = null);

(statearr_37118_37256[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (97))){
var inst_37015 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37119_37257 = state_37026__$1;
(statearr_37119_37257[(2)] = inst_37015);

(statearr_37119_37257[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (19))){
var inst_36844 = (state_37026[(36)]);
var state_37026__$1 = state_37026;
var statearr_37120_37258 = state_37026__$1;
(statearr_37120_37258[(2)] = inst_36844);

(statearr_37120_37258[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (57))){
var inst_36852 = (state_37026[(11)]);
var inst_36922 = (state_37026[(2)]);
var inst_36923 = (inst_36852 == null);
var state_37026__$1 = (function (){var statearr_37121 = state_37026;
(statearr_37121[(8)] = inst_36922);

return statearr_37121;
})();
if(cljs.core.truth_(inst_36923)){
var statearr_37122_37259 = state_37026__$1;
(statearr_37122_37259[(1)] = (58));

} else {
var statearr_37123_37260 = state_37026__$1;
(statearr_37123_37260[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (68))){
var state_37026__$1 = state_37026;
var statearr_37124_37261 = state_37026__$1;
(statearr_37124_37261[(2)] = null);

(statearr_37124_37261[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (11))){
var inst_36800 = (state_37026[(2)]);
var state_37026__$1 = (function (){var statearr_37126 = state_37026;
(statearr_37126[(28)] = inst_36800);

return statearr_37126;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37127_37262 = state_37026__$1;
(statearr_37127_37262[(1)] = (12));

} else {
var statearr_37128_37263 = state_37026__$1;
(statearr_37128_37263[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (9))){
var inst_36794 = (state_37026[(35)]);
var inst_36792 = (state_37026[(34)]);
var inst_36796 = cljs.core.sorted_map_by(inst_36792);
var inst_36797 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36796,inst_36794);
var state_37026__$1 = state_37026;
var statearr_37129_37264 = state_37026__$1;
(statearr_37129_37264[(2)] = inst_36797);

(statearr_37129_37264[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (5))){
var _ = (function (){var statearr_37130 = state_37026;
(statearr_37130[(4)] = cljs.core.rest((state_37026[(4)])));

return statearr_37130;
})();
var state_37026__$1 = state_37026;
var ex37125 = (state_37026__$1[(2)]);
var statearr_37131_37265 = state_37026__$1;
(statearr_37131_37265[(5)] = ex37125);


if((ex37125 instanceof Error)){
var statearr_37132_37266 = state_37026__$1;
(statearr_37132_37266[(1)] = (4));

(statearr_37132_37266[(5)] = null);

} else {
throw ex37125;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (83))){
var state_37026__$1 = state_37026;
var statearr_37133_37267 = state_37026__$1;
(statearr_37133_37267[(2)] = limit);

(statearr_37133_37267[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (14))){
var inst_36988 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37134_37268 = state_37026__$1;
(statearr_37134_37268[(2)] = inst_36988);

(statearr_37134_37268[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (45))){
var inst_36904 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
if(cljs.core.truth_(inst_36904)){
var statearr_37135_37269 = state_37026__$1;
(statearr_37135_37269[(1)] = (46));

} else {
var statearr_37136_37270 = state_37026__$1;
(statearr_37136_37270[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (53))){
var inst_36852 = (state_37026[(11)]);
var state_37026__$1 = state_37026;
var statearr_37137_37271 = state_37026__$1;
(statearr_37137_37271[(2)] = inst_36852);

(statearr_37137_37271[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (78))){
var inst_36853 = (state_37026[(12)]);
var inst_36965 = (state_37026[(2)]);
var inst_36966 = (inst_36853 <= (0));
var state_37026__$1 = (function (){var statearr_37138 = state_37026;
(statearr_37138[(37)] = inst_36965);

return statearr_37138;
})();
if(cljs.core.truth_(inst_36966)){
var statearr_37139_37272 = state_37026__$1;
(statearr_37139_37272[(1)] = (79));

} else {
var statearr_37140_37273 = state_37026__$1;
(statearr_37140_37273[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (26))){
var inst_36984 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37141_37274 = state_37026__$1;
(statearr_37141_37274[(2)] = inst_36984);

(statearr_37141_37274[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (16))){
var state_37026__$1 = state_37026;
var statearr_37142_37275 = state_37026__$1;
(statearr_37142_37275[(2)] = null);

(statearr_37142_37275[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (81))){
var inst_36898 = (state_37026[(18)]);
var inst_36867 = (state_37026[(19)]);
var inst_36864 = (state_37026[(21)]);
var inst_36863 = (state_37026[(9)]);
var inst_36965 = (state_37026[(37)]);
var inst_36854 = (state_37026[(10)]);
var inst_36971 = (state_37026[(2)]);
var inst_36972 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36854,inst_36863,inst_36898);
var inst_36850 = inst_36864;
var inst_36851 = inst_36867;
var inst_36852 = inst_36965;
var inst_36853 = inst_36971;
var inst_36854__$1 = inst_36972;
var state_37026__$1 = (function (){var statearr_37145 = state_37026;
(statearr_37145[(12)] = inst_36853);

(statearr_37145[(11)] = inst_36852);

(statearr_37145[(22)] = inst_36851);

(statearr_37145[(23)] = inst_36850);

(statearr_37145[(10)] = inst_36854__$1);

return statearr_37145;
})();
var statearr_37146_37276 = state_37026__$1;
(statearr_37146_37276[(2)] = null);

(statearr_37146_37276[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (79))){
var state_37026__$1 = state_37026;
var statearr_37147_37277 = state_37026__$1;
(statearr_37147_37277[(2)] = (0));

(statearr_37147_37277[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (38))){
var inst_36867 = (state_37026[(19)]);
var inst_36864 = (state_37026[(21)]);
var inst_36852 = (state_37026[(11)]);
var inst_36854 = (state_37026[(10)]);
var inst_36889 = (state_37026[(2)]);
var tmp37143 = inst_36852;
var tmp37144 = inst_36854;
var inst_36850 = inst_36864;
var inst_36851 = inst_36867;
var inst_36852__$1 = tmp37143;
var inst_36853 = inst_36889;
var inst_36854__$1 = tmp37144;
var state_37026__$1 = (function (){var statearr_37148 = state_37026;
(statearr_37148[(12)] = inst_36853);

(statearr_37148[(11)] = inst_36852__$1);

(statearr_37148[(22)] = inst_36851);

(statearr_37148[(23)] = inst_36850);

(statearr_37148[(10)] = inst_36854__$1);

return statearr_37148;
})();
var statearr_37149_37278 = state_37026__$1;
(statearr_37149_37278[(2)] = null);

(statearr_37149_37278[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (87))){
var state_37026__$1 = state_37026;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_37150_37279 = state_37026__$1;
(statearr_37150_37279[(1)] = (92));

} else {
var statearr_37151_37280 = state_37026__$1;
(statearr_37151_37280[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (30))){
var inst_36854 = (state_37026[(10)]);
var state_37026__$1 = state_37026;
var statearr_37152_37281 = state_37026__$1;
(statearr_37152_37281[(2)] = inst_36854);

(statearr_37152_37281[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (73))){
var inst_36854 = (state_37026[(10)]);
var state_37026__$1 = state_37026;
var statearr_37153_37282 = state_37026__$1;
(statearr_37153_37282[(2)] = inst_36854);

(statearr_37153_37282[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (96))){
var state_37026__$1 = state_37026;
var statearr_37154_37283 = state_37026__$1;
(statearr_37154_37283[(2)] = null);

(statearr_37154_37283[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (10))){
var inst_36794 = (state_37026[(35)]);
var state_37026__$1 = state_37026;
var statearr_37155_37284 = state_37026__$1;
(statearr_37155_37284[(2)] = inst_36794);

(statearr_37155_37284[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (18))){
var inst_36844 = (state_37026[(36)]);
var inst_36843 = (state_37026[(2)]);
var inst_36844__$1 = offset;
var state_37026__$1 = (function (){var statearr_37156 = state_37026;
(statearr_37156[(24)] = inst_36843);

(statearr_37156[(36)] = inst_36844__$1);

return statearr_37156;
})();
if(cljs.core.truth_(inst_36844__$1)){
var statearr_37157_37285 = state_37026__$1;
(statearr_37157_37285[(1)] = (19));

} else {
var statearr_37158_37286 = state_37026__$1;
(statearr_37158_37286[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (52))){
var inst_36852 = (state_37026[(11)]);
var inst_36914 = ((0) < inst_36852);
var state_37026__$1 = state_37026;
var statearr_37159_37287 = state_37026__$1;
(statearr_37159_37287[(2)] = inst_36914);

(statearr_37159_37287[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (67))){
var inst_36853 = (state_37026[(12)]);
var inst_36922 = (state_37026[(8)]);
var inst_36868 = (state_37026[(27)]);
var inst_36937 = cljs.core.count(inst_36922);
var inst_36938 = (inst_36868 - inst_36937);
var inst_36939 = (inst_36853 - inst_36938);
var state_37026__$1 = state_37026;
var statearr_37160_37288 = state_37026__$1;
(statearr_37160_37288[(2)] = inst_36939);

(statearr_37160_37288[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (71))){
var inst_36922 = (state_37026[(8)]);
var inst_36950 = cljs.core.empty_QMARK_(inst_36922);
var state_37026__$1 = state_37026;
var statearr_37161_37289 = state_37026__$1;
(statearr_37161_37289[(2)] = inst_36950);

(statearr_37161_37289[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (42))){
var inst_36898 = (state_37026[(18)]);
var inst_36899 = (state_37026[(33)]);
var inst_36897 = (state_37026[(2)]);
var inst_36898__$1 = fluree.db.util.async.throw_err(inst_36897);
var inst_36899__$1 = cljs.core.coll_QMARK_(inst_36898__$1);
var state_37026__$1 = (function (){var statearr_37162 = state_37026;
(statearr_37162[(18)] = inst_36898__$1);

(statearr_37162[(33)] = inst_36899__$1);

return statearr_37162;
})();
if(inst_36899__$1){
var statearr_37163_37290 = state_37026__$1;
(statearr_37163_37290[(1)] = (43));

} else {
var statearr_37164_37291 = state_37026__$1;
(statearr_37164_37291[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (80))){
var inst_36853 = (state_37026[(12)]);
var inst_36969 = (inst_36853 - (1));
var state_37026__$1 = state_37026;
var statearr_37165_37292 = state_37026__$1;
(statearr_37165_37292[(2)] = inst_36969);

(statearr_37165_37292[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (37))){
var inst_36853 = (state_37026[(12)]);
var inst_36868 = (state_37026[(27)]);
var inst_36887 = (inst_36853 - inst_36868);
var state_37026__$1 = state_37026;
var statearr_37166_37293 = state_37026__$1;
(statearr_37166_37293[(2)] = inst_36887);

(statearr_37166_37293[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (63))){
var inst_36922 = (state_37026[(8)]);
var inst_36947 = (state_37026[(7)]);
var inst_36946 = (state_37026[(2)]);
var inst_36947__$1 = (inst_36922 == null);
var state_37026__$1 = (function (){var statearr_37167 = state_37026;
(statearr_37167[(20)] = inst_36946);

(statearr_37167[(7)] = inst_36947__$1);

return statearr_37167;
})();
if(cljs.core.truth_(inst_36947__$1)){
var statearr_37168_37294 = state_37026__$1;
(statearr_37168_37294[(1)] = (70));

} else {
var statearr_37169_37295 = state_37026__$1;
(statearr_37169_37295[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (94))){
var inst_37017 = (state_37026[(2)]);
var state_37026__$1 = state_37026;
var statearr_37170_37296 = state_37026__$1;
(statearr_37170_37296[(2)] = inst_37017);

(statearr_37170_37296[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (8))){
var inst_37021 = (state_37026[(2)]);
var _ = (function (){var statearr_37171 = state_37026;
(statearr_37171[(4)] = cljs.core.rest((state_37026[(4)])));

return statearr_37171;
})();
var state_37026__$1 = state_37026;
var statearr_37172_37297 = state_37026__$1;
(statearr_37172_37297[(2)] = inst_37021);

(statearr_37172_37297[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (49))){
var inst_36898 = (state_37026[(18)]);
var inst_36853 = (state_37026[(12)]);
var inst_36909 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_36853,inst_36898);
var state_37026__$1 = state_37026;
var statearr_37173_37298 = state_37026__$1;
(statearr_37173_37298[(2)] = inst_36909);

(statearr_37173_37298[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37027 === (84))){
var inst_36993 = (state_37026[(2)]);
var inst_36994 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_36993,opts);
var state_37026__$1 = state_37026;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37026__$1,(85),inst_36994);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____0 = (function (){
var statearr_37174 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37174[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__);

(statearr_37174[(1)] = (1));

return statearr_37174;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____1 = (function (state_37026){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_37026);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e37175){var ex__10753__auto__ = e37175;
var statearr_37176_37299 = state_37026;
(statearr_37176_37299[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_37026[(4)]))){
var statearr_37177_37300 = state_37026;
(statearr_37177_37300[(1)] = cljs.core.first((state_37026[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__37301 = state_37026;
state_37026 = G__37301;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__ = function(state_37026){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____1.call(this,state_37026);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_37178 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_37178[(6)] = c__10876__auto__);

return statearr_37178;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__37304,opts){
var map__37305 = p__37304;
var map__37305__$1 = cljs.core.__destructure_map(map__37305);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37305__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37305__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37305__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37305__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__37302_SHARP_){
return cljs.core.contains_QMARK_(p1__37302_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__37303_SHARP_){
return cljs.core.contains_QMARK_(p1__37303_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__37307 = cljs.core.first(orderBy);
var fexpr__37306 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__37306.cljs$core$IFn$_invoke$arity$1 ? fexpr__37306.cljs$core$IFn$_invoke$arity$1(G__37307) : fexpr__37306.call(null,G__37307));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4212__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__37308,p__37309){
var map__37310 = p__37308;
var map__37310__$1 = cljs.core.__destructure_map(map__37310);
var query_map = map__37310__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37310__$1,cljs.core.cst$kw$construct);
var map__37311 = p__37309;
var map__37311__$1 = cljs.core.__destructure_map(map__37311);
var where_result = map__37311__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37311__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37311__$1,cljs.core.cst$kw$tuples);
var vec__37312 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37312,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37312,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__37312,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_37345){
var state_val_37346 = (state_37345[(1)]);
if((state_val_37346 === (7))){
var inst_37324 = (state_37345[(7)]);
var state_37345__$1 = state_37345;
var statearr_37347_37370 = state_37345__$1;
(statearr_37347_37370[(2)] = inst_37324);

(statearr_37347_37370[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (1))){
var state_37345__$1 = state_37345;
var statearr_37348_37371 = state_37345__$1;
(statearr_37348_37371[(2)] = null);

(statearr_37348_37371[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (4))){
var inst_37315 = (state_37345[(2)]);
var state_37345__$1 = state_37345;
var statearr_37349_37372 = state_37345__$1;
(statearr_37349_37372[(2)] = inst_37315);

(statearr_37349_37372[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (13))){
var inst_37334 = (state_37345[(2)]);
var inst_37335 = fluree.db.util.async.throw_err(inst_37334);
var state_37345__$1 = state_37345;
var statearr_37350_37373 = state_37345__$1;
(statearr_37350_37373[(2)] = inst_37335);

(statearr_37350_37373[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (6))){
var inst_37324 = (state_37345[(7)]);
var inst_37323 = (state_37345[(2)]);
var inst_37324__$1 = fluree.db.util.async.throw_err(inst_37323);
var inst_37325 = fluree.db.util.core.exception_QMARK_(inst_37324__$1);
var state_37345__$1 = (function (){var statearr_37351 = state_37345;
(statearr_37351[(7)] = inst_37324__$1);

return statearr_37351;
})();
if(inst_37325){
var statearr_37352_37374 = state_37345__$1;
(statearr_37352_37374[(1)] = (7));

} else {
var statearr_37353_37375 = state_37345__$1;
(statearr_37353_37375[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (3))){
var inst_37343 = (state_37345[(2)]);
var state_37345__$1 = state_37345;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37345__$1,inst_37343);
} else {
if((state_val_37346 === (12))){
var inst_37338 = (state_37345[(2)]);
var state_37345__$1 = state_37345;
var statearr_37354_37376 = state_37345__$1;
(statearr_37354_37376[(2)] = inst_37338);

(statearr_37354_37376[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (2))){
var _ = (function (){var statearr_37355 = state_37345;
(statearr_37355[(4)] = cljs.core.cons((5),(state_37345[(4)])));

return statearr_37355;
})();
var inst_37321 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_37345__$1 = state_37345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37345__$1,(6),inst_37321);
} else {
if((state_val_37346 === (11))){
var state_37345__$1 = state_37345;
var statearr_37357_37377 = state_37345__$1;
(statearr_37357_37377[(2)] = null);

(statearr_37357_37377[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (9))){
var inst_37340 = (state_37345[(2)]);
var _ = (function (){var statearr_37358 = state_37345;
(statearr_37358[(4)] = cljs.core.rest((state_37345[(4)])));

return statearr_37358;
})();
var state_37345__$1 = state_37345;
var statearr_37359_37378 = state_37345__$1;
(statearr_37359_37378[(2)] = inst_37340);

(statearr_37359_37378[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (5))){
var _ = (function (){var statearr_37360 = state_37345;
(statearr_37360[(4)] = cljs.core.rest((state_37345[(4)])));

return statearr_37360;
})();
var state_37345__$1 = state_37345;
var ex37356 = (state_37345__$1[(2)]);
var statearr_37361_37379 = state_37345__$1;
(statearr_37361_37379[(5)] = ex37356);


if((ex37356 instanceof Error)){
var statearr_37362_37380 = state_37345__$1;
(statearr_37362_37380[(1)] = (4));

(statearr_37362_37380[(5)] = null);

} else {
throw ex37356;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37346 === (10))){
var inst_37324 = (state_37345[(7)]);
var inst_37329 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_37324);
var inst_37330 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_37324);
var inst_37331 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_37329,inst_37330,query_map,opts);
var inst_37332 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_37324,inst_37331,opts);
var state_37345__$1 = state_37345;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37345__$1,(13),inst_37332);
} else {
if((state_val_37346 === (8))){
var state_37345__$1 = state_37345;
var statearr_37363_37381 = state_37345__$1;
(statearr_37363_37381[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____0 = (function (){
var statearr_37365 = [null,null,null,null,null,null,null,null];
(statearr_37365[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__);

(statearr_37365[(1)] = (1));

return statearr_37365;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____1 = (function (state_37345){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_37345);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e37366){var ex__10753__auto__ = e37366;
var statearr_37367_37382 = state_37345;
(statearr_37367_37382[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_37345[(4)]))){
var statearr_37368_37383 = state_37345;
(statearr_37368_37383[(1)] = cljs.core.first((state_37345[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__37384 = state_37345;
state_37345 = G__37384;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__ = function(state_37345){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____1.call(this,state_37345);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_37369 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_37369[(6)] = c__10876__auto__);

return statearr_37369;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__37385 = query_map;
var map__37385__$1 = cljs.core.__destructure_map(map__37385);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__37385__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__37386 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__37386,cljs.core.cst$kw$limit,(1));
} else {
return G__37386;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_37741){
var state_val_37742 = (state_37741[(1)]);
if((state_val_37742 === (121))){
var inst_37702 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37743_37938 = state_37741__$1;
(statearr_37743_37938[(2)] = inst_37702);

(statearr_37743_37938[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (65))){
var inst_37579 = typeof from === 'string';
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37579)){
var statearr_37744_37939 = state_37741__$1;
(statearr_37744_37939[(1)] = (72));

} else {
var statearr_37745_37940 = state_37741__$1;
(statearr_37745_37940[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (70))){
var inst_37450 = (state_37741[(7)]);
var inst_37448 = (state_37741[(8)]);
var inst_37572 = (state_37741[(2)]);
var inst_37573 = fluree.db.util.async.throw_err(inst_37572);
var inst_37574 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37450,fuel,max_fuel,inst_37448,inst_37573);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(71),inst_37574);
} else {
if((state_val_37742 === (62))){
var inst_37552 = (state_37741[(9)]);
var state_37741__$1 = state_37741;
var statearr_37746_37941 = state_37741__$1;
(statearr_37746_37941[(2)] = inst_37552);

(statearr_37746_37941[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (74))){
var inst_37708 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37747_37942 = state_37741__$1;
(statearr_37747_37942[(2)] = inst_37708);

(statearr_37747_37942[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (110))){
var inst_37643 = (state_37741[(10)]);
var state_37741__$1 = state_37741;
var statearr_37748_37943 = state_37741__$1;
(statearr_37748_37943[(2)] = inst_37643);

(statearr_37748_37943[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (130))){
var inst_37728 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37749_37944 = state_37741__$1;
(statearr_37749_37944[(2)] = inst_37728);

(statearr_37749_37944[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (128))){
var inst_37719 = (state_37741[(11)]);
var inst_37724 = fluree.db.util.core.exception_QMARK_(inst_37719);
var inst_37725 = (!(inst_37724));
var state_37741__$1 = state_37741;
var statearr_37750_37945 = state_37741__$1;
(statearr_37750_37945[(2)] = inst_37725);

(statearr_37750_37945[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (7))){
var inst_37418 = (state_37741[(12)]);
var inst_37418__$1 = selectOne;
var state_37741__$1 = (function (){var statearr_37751 = state_37741;
(statearr_37751[(12)] = inst_37418__$1);

return statearr_37751;
})();
if(cljs.core.truth_(inst_37418__$1)){
var statearr_37752_37946 = state_37741__$1;
(statearr_37752_37946[(1)] = (9));

} else {
var statearr_37753_37947 = state_37741__$1;
(statearr_37753_37947[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (59))){
var inst_37450 = (state_37741[(7)]);
var inst_37448 = (state_37741[(8)]);
var inst_37438 = (state_37741[(13)]);
var inst_37530 = (state_37741[(14)]);
var inst_37544 = (state_37741[(2)]);
var inst_37545 = fluree.db.util.async.throw_err(inst_37544);
var inst_37546 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_37530,inst_37545);
var inst_37547 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_37450,fuel,max_fuel,inst_37448,inst_37546,inst_37438);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(60),inst_37547);
} else {
if((state_val_37742 === (86))){
var inst_37450 = (state_37741[(7)]);
var inst_37440 = (state_37741[(15)]);
var inst_37448 = (state_37741[(8)]);
var inst_37438 = (state_37741[(13)]);
var inst_37612 = (state_37741[(2)]);
var inst_37613 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37450,fuel,max_fuel,inst_37448,inst_37612,inst_37438,inst_37440);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(87),inst_37613);
} else {
if((state_val_37742 === (20))){
var inst_37482 = (state_37741[(2)]);
var inst_37483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37482,(0),null);
var inst_37484 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37482,(1),null);
var inst_37485 = typeof where === 'string';
var state_37741__$1 = (function (){var statearr_37754 = state_37741;
(statearr_37754[(16)] = inst_37484);

(statearr_37754[(17)] = inst_37483);

return statearr_37754;
})();
if(cljs.core.truth_(inst_37485)){
var statearr_37755_37948 = state_37741__$1;
(statearr_37755_37948[(1)] = (30));

} else {
var statearr_37756_37949 = state_37741__$1;
(statearr_37756_37949[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (72))){
var inst_37437 = (state_37741[(18)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37437)){
var statearr_37757_37950 = state_37741__$1;
(statearr_37757_37950[(1)] = (75));

} else {
var statearr_37758_37951 = state_37741__$1;
(statearr_37758_37951[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (58))){
var inst_37538 = (state_37741[(2)]);
var inst_37539 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37540 = [from];
var inst_37541 = (new cljs.core.PersistentVector(null,1,(5),inst_37539,inst_37540,null));
var inst_37542 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_37541,inst_37538);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(59),inst_37542);
} else {
if((state_val_37742 === (60))){
var inst_37549 = (state_37741[(2)]);
var inst_37550 = fluree.db.util.async.throw_err(inst_37549);
var state_37741__$1 = state_37741;
var statearr_37759_37952 = state_37741__$1;
(statearr_37759_37952[(2)] = inst_37550);

(statearr_37759_37952[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (27))){
var inst_37467 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37468 = [null,null];
var inst_37469 = (new cljs.core.PersistentVector(null,2,(5),inst_37467,inst_37468,null));
var state_37741__$1 = state_37741;
var statearr_37760_37953 = state_37741__$1;
(statearr_37760_37953[(2)] = inst_37469);

(statearr_37760_37953[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (1))){
var state_37741__$1 = state_37741;
var statearr_37761_37954 = state_37741__$1;
(statearr_37761_37954[(2)] = null);

(statearr_37761_37954[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (69))){
var inst_37569 = (state_37741[(2)]);
var inst_37570 = fluree.db.query.range._block_or_tx_collection(db,inst_37569);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(70),inst_37570);
} else {
if((state_val_37742 === (101))){
var inst_37675 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37762_37955 = state_37741__$1;
(statearr_37762_37955[(2)] = inst_37675);

(statearr_37762_37955[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (24))){
var inst_37437 = (state_37741[(18)]);
var inst_37462 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37463 = [inst_37437,"ASC"];
var inst_37464 = (new cljs.core.PersistentVector(null,2,(5),inst_37462,inst_37463,null));
var state_37741__$1 = state_37741;
var statearr_37763_37956 = state_37741__$1;
(statearr_37763_37956[(2)] = inst_37464);

(statearr_37763_37956[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (102))){
var inst_37649 = (state_37741[(19)]);
var state_37741__$1 = state_37741;
var statearr_37764_37957 = state_37741__$1;
(statearr_37764_37957[(2)] = inst_37649);

(statearr_37764_37957[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (55))){
var inst_37437 = (state_37741[(18)]);
var inst_37530 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37765 = state_37741;
(statearr_37765[(14)] = inst_37530);

return statearr_37765;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37766_37958 = state_37741__$1;
(statearr_37766_37958[(1)] = (56));

} else {
var statearr_37767_37959 = state_37741__$1;
(statearr_37767_37959[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (85))){
var inst_37604 = (state_37741[(20)]);
var inst_37608 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37609 = [inst_37604];
var inst_37610 = (new cljs.core.PersistentVector(null,1,(5),inst_37608,inst_37609,null));
var state_37741__$1 = state_37741;
var statearr_37768_37960 = state_37741__$1;
(statearr_37768_37960[(2)] = inst_37610);

(statearr_37768_37960[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (39))){
var inst_37438 = (state_37741[(13)]);
var state_37741__$1 = state_37741;
var statearr_37769_37961 = state_37741__$1;
(statearr_37769_37961[(2)] = inst_37438);

(statearr_37769_37961[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (88))){
var inst_37618 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_37741__$1 = state_37741;
var statearr_37770_37962 = state_37741__$1;
(statearr_37770_37962[(2)] = inst_37618);

(statearr_37770_37962[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (46))){
var inst_37515 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37515)){
var statearr_37771_37963 = state_37741__$1;
(statearr_37771_37963[(1)] = (47));

} else {
var statearr_37772_37964 = state_37741__$1;
(statearr_37772_37964[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (4))){
var inst_37405 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37773_37965 = state_37741__$1;
(statearr_37773_37965[(2)] = inst_37405);

(statearr_37773_37965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (77))){
var inst_37588 = (state_37741[(2)]);
var inst_37589 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_37588);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(78),inst_37589);
} else {
if((state_val_37742 === (106))){
var state_37741__$1 = state_37741;
var statearr_37774_37966 = state_37741__$1;
(statearr_37774_37966[(2)] = null);

(statearr_37774_37966[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (119))){
var inst_37694 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_37695 = ["Invalid 'from' in query:",inst_37694].join('');
var inst_37696 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37697 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37698 = cljs.core.PersistentHashMap.fromArrays(inst_37696,inst_37697);
var inst_37699 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37695,inst_37698);
var state_37741__$1 = state_37741;
var statearr_37775_37967 = state_37741__$1;
(statearr_37775_37967[(2)] = inst_37699);

(statearr_37775_37967[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (95))){
var state_37741__$1 = state_37741;
var statearr_37776_37968 = state_37741__$1;
(statearr_37776_37968[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (54))){
var inst_37524 = (state_37741[(21)]);
var state_37741__$1 = state_37741;
var statearr_37778_37969 = state_37741__$1;
(statearr_37778_37969[(2)] = inst_37524);

(statearr_37778_37969[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (92))){
var inst_37623 = (state_37741[(22)]);
var state_37741__$1 = state_37741;
var statearr_37779_37970 = state_37741__$1;
(statearr_37779_37970[(2)] = inst_37623);

(statearr_37779_37970[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (104))){
var inst_37667 = (state_37741[(23)]);
var inst_37667__$1 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37780 = state_37741;
(statearr_37780[(23)] = inst_37667__$1);

return statearr_37780;
})();
if(cljs.core.truth_(inst_37667__$1)){
var statearr_37781_37971 = state_37741__$1;
(statearr_37781_37971[(1)] = (109));

} else {
var statearr_37782_37972 = state_37741__$1;
(statearr_37782_37972[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (15))){
var inst_37441 = (state_37741[(24)]);
var inst_37439 = (state_37741[(25)]);
var inst_37445 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37441,cljs.core.cst$kw$componentFollow_QMARK_,inst_37439);
var state_37741__$1 = state_37741;
var statearr_37783_37973 = state_37741__$1;
(statearr_37783_37973[(2)] = inst_37445);

(statearr_37783_37973[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (48))){
var inst_37552 = (state_37741[(9)]);
var inst_37552__$1 = typeof from === 'string';
var state_37741__$1 = (function (){var statearr_37784 = state_37741;
(statearr_37784[(9)] = inst_37552__$1);

return statearr_37784;
})();
if(cljs.core.truth_(inst_37552__$1)){
var statearr_37785_37974 = state_37741__$1;
(statearr_37785_37974[(1)] = (61));

} else {
var statearr_37786_37975 = state_37741__$1;
(statearr_37786_37975[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (50))){
var inst_37518 = (state_37741[(26)]);
var inst_37520 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_37521 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37518,inst_37520);
var state_37741__$1 = state_37741;
var statearr_37787_37976 = state_37741__$1;
(statearr_37787_37976[(2)] = inst_37521);

(statearr_37787_37976[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (116))){
var state_37741__$1 = state_37741;
var statearr_37788_37977 = state_37741__$1;
(statearr_37788_37977[(2)] = null);

(statearr_37788_37977[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (75))){
var inst_37582 = cljs.core.PersistentHashMap.EMPTY;
var state_37741__$1 = state_37741;
var statearr_37789_37978 = state_37741__$1;
(statearr_37789_37978[(2)] = inst_37582);

(statearr_37789_37978[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (99))){
var inst_37643 = (state_37741[(10)]);
var state_37741__$1 = state_37741;
var statearr_37790_37979 = state_37741__$1;
(statearr_37790_37979[(2)] = inst_37643);

(statearr_37790_37979[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (21))){
var inst_37437 = (state_37741[(18)]);
var inst_37454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37455 = cljs.core.second(inst_37437);
var inst_37456 = cljs.core.first(inst_37437);
var inst_37457 = [inst_37455,inst_37456];
var inst_37458 = (new cljs.core.PersistentVector(null,2,(5),inst_37454,inst_37457,null));
var state_37741__$1 = state_37741;
var statearr_37791_37980 = state_37741__$1;
(statearr_37791_37980[(2)] = inst_37458);

(statearr_37791_37980[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (31))){
var inst_37509 = (state_37741[(27)]);
var inst_37509__$1 = typeof from === 'string';
var state_37741__$1 = (function (){var statearr_37792 = state_37741;
(statearr_37792[(27)] = inst_37509__$1);

return statearr_37792;
})();
if(cljs.core.truth_(inst_37509__$1)){
var statearr_37793_37981 = state_37741__$1;
(statearr_37793_37981[(1)] = (44));

} else {
var statearr_37794_37982 = state_37741__$1;
(statearr_37794_37982[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (113))){
var state_37741__$1 = state_37741;
var statearr_37795_37983 = state_37741__$1;
(statearr_37795_37983[(2)] = null);

(statearr_37795_37983[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (32))){
var inst_37483 = (state_37741[(17)]);
var inst_37714 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37796 = state_37741;
(statearr_37796[(28)] = inst_37714);

return statearr_37796;
})();
if(cljs.core.truth_(inst_37483)){
var statearr_37797_37984 = state_37741__$1;
(statearr_37797_37984[(1)] = (122));

} else {
var statearr_37798_37985 = state_37741__$1;
(statearr_37798_37985[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (40))){
var inst_37437 = (state_37741[(18)]);
var inst_37499 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37799 = state_37741;
(statearr_37799[(29)] = inst_37499);

return statearr_37799;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37800_37986 = state_37741__$1;
(statearr_37800_37986[(1)] = (41));

} else {
var statearr_37801_37987 = state_37741__$1;
(statearr_37801_37987[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (129))){
var inst_37722 = (state_37741[(30)]);
var state_37741__$1 = state_37741;
var statearr_37802_37988 = state_37741__$1;
(statearr_37802_37988[(2)] = inst_37722);

(statearr_37802_37988[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (91))){
var inst_37625 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_37741__$1 = state_37741;
var statearr_37803_37989 = state_37741__$1;
(statearr_37803_37989[(2)] = inst_37625);

(statearr_37803_37989[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (117))){
var inst_37440 = (state_37741[(15)]);
var state_37741__$1 = state_37741;
var statearr_37804_37990 = state_37741__$1;
(statearr_37804_37990[(2)] = inst_37440);

(statearr_37804_37990[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (108))){
var inst_37664 = (state_37741[(2)]);
var inst_37665 = fluree.db.util.async.throw_err(inst_37664);
var state_37741__$1 = state_37741;
var statearr_37805_37991 = state_37741__$1;
(statearr_37805_37991[(2)] = inst_37665);

(statearr_37805_37991[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (56))){
var inst_37532 = cljs.core.PersistentHashMap.EMPTY;
var state_37741__$1 = state_37741;
var statearr_37806_37992 = state_37741__$1;
(statearr_37806_37992[(2)] = inst_37532);

(statearr_37806_37992[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (33))){
var state_37741__$1 = state_37741;
var statearr_37807_37993 = state_37741__$1;
(statearr_37807_37993[(2)] = from);

(statearr_37807_37993[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (13))){
var inst_37424 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37425 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37426 = cljs.core.PersistentHashMap.fromArrays(inst_37424,inst_37425);
var inst_37427 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_37426);
var inst_37428 = (function(){throw inst_37427})();
var state_37741__$1 = state_37741;
var statearr_37808_37994 = state_37741__$1;
(statearr_37808_37994[(2)] = inst_37428);

(statearr_37808_37994[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (22))){
var inst_37437 = (state_37741[(18)]);
var inst_37460 = typeof inst_37437 === 'string';
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37460)){
var statearr_37809_37995 = state_37741__$1;
(statearr_37809_37995[(1)] = (24));

} else {
var statearr_37810_37996 = state_37741__$1;
(statearr_37810_37996[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (90))){
var inst_37616 = (state_37741[(31)]);
var inst_37621 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37811 = state_37741;
(statearr_37811[(32)] = inst_37621);

return statearr_37811;
})();
var statearr_37812_37997 = state_37741__$1;
(statearr_37812_37997[(2)] = inst_37616);

(statearr_37812_37997[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (109))){
var inst_37643 = (state_37741[(10)]);
var inst_37667 = (state_37741[(23)]);
var inst_37669 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_37643,inst_37667);
var state_37741__$1 = state_37741;
var statearr_37813_37998 = state_37741__$1;
(statearr_37813_37998[(2)] = inst_37669);

(statearr_37813_37998[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (36))){
var inst_37437 = (state_37741[(18)]);
var inst_37494 = (state_37741[(2)]);
var inst_37495 = fluree.db.util.async.throw_err(inst_37494);
var state_37741__$1 = (function (){var statearr_37814 = state_37741;
(statearr_37814[(33)] = inst_37495);

return statearr_37814;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37815_37999 = state_37741__$1;
(statearr_37815_37999[(1)] = (38));

} else {
var statearr_37816_38000 = state_37741__$1;
(statearr_37816_38000[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (41))){
var state_37741__$1 = state_37741;
var statearr_37817_38001 = state_37741__$1;
(statearr_37817_38001[(2)] = null);

(statearr_37817_38001[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (118))){
var inst_37450 = (state_37741[(7)]);
var inst_37679 = (state_37741[(34)]);
var inst_37448 = (state_37741[(8)]);
var inst_37683 = (state_37741[(35)]);
var inst_37687 = (state_37741[(2)]);
var inst_37688 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37450,fuel,max_fuel,inst_37448,inst_37679,inst_37683,inst_37687);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(112),inst_37688);
} else {
if((state_val_37742 === (89))){
var state_37741__$1 = state_37741;
var statearr_37818_38002 = state_37741__$1;
(statearr_37818_38002[(2)] = null);

(statearr_37818_38002[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (100))){
var inst_37649 = (state_37741[(19)]);
var inst_37654 = cljs.core.int_QMARK_(inst_37649);
var state_37741__$1 = state_37741;
if(inst_37654){
var statearr_37819_38003 = state_37741__$1;
(statearr_37819_38003[(1)] = (102));

} else {
var statearr_37820_38004 = state_37741__$1;
(statearr_37820_38004[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (131))){
var inst_37719 = (state_37741[(11)]);
var inst_37733 = cljs.core.first(inst_37719);
var state_37741__$1 = state_37741;
var statearr_37821_38005 = state_37741__$1;
(statearr_37821_38005[(2)] = inst_37733);

(statearr_37821_38005[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (122))){
var inst_37714 = (state_37741[(28)]);
var inst_37440 = (state_37741[(15)]);
var inst_37438 = (state_37741[(13)]);
var inst_37484 = (state_37741[(16)]);
var inst_37483 = (state_37741[(17)]);
var inst_37716 = fluree.db.query.fql.sort_offset_and_limit_res(inst_37483,inst_37484,inst_37440,inst_37438,inst_37714);
var state_37741__$1 = state_37741;
var statearr_37822_38006 = state_37741__$1;
(statearr_37822_38006[(2)] = inst_37716);

(statearr_37822_38006[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (43))){
var inst_37450 = (state_37741[(7)]);
var inst_37495 = (state_37741[(33)]);
var inst_37448 = (state_37741[(8)]);
var inst_37499 = (state_37741[(29)]);
var inst_37503 = (state_37741[(2)]);
var inst_37504 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_37450,fuel,max_fuel,inst_37448,inst_37495,inst_37499,inst_37503);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(37),inst_37504);
} else {
if((state_val_37742 === (61))){
var inst_37554 = ["_tx",null,"_block",null];
var inst_37555 = (new cljs.core.PersistentArrayMap(null,2,inst_37554,null));
var inst_37556 = (new cljs.core.PersistentHashSet(null,inst_37555,null));
var inst_37557 = (inst_37556.cljs$core$IFn$_invoke$arity$1 ? inst_37556.cljs$core$IFn$_invoke$arity$1(from) : inst_37556.call(null,from));
var state_37741__$1 = state_37741;
var statearr_37823_38007 = state_37741__$1;
(statearr_37823_38007[(2)] = inst_37557);

(statearr_37823_38007[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (29))){
var inst_37472 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37824_38008 = state_37741__$1;
(statearr_37824_38008[(2)] = inst_37472);

(statearr_37824_38008[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (44))){
var inst_37511 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_37512 = clojure.string.includes_QMARK_(inst_37511,"/");
var state_37741__$1 = state_37741;
var statearr_37825_38009 = state_37741__$1;
(statearr_37825_38009[(2)] = inst_37512);

(statearr_37825_38009[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (93))){
var inst_37628 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37628)){
var statearr_37826_38010 = state_37741__$1;
(statearr_37826_38010[(1)] = (94));

} else {
var statearr_37827_38011 = state_37741__$1;
(statearr_37827_38011[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (6))){
var inst_37415 = (state_37741[(36)]);
var state_37741__$1 = state_37741;
var statearr_37828_38012 = state_37741__$1;
(statearr_37828_38012[(2)] = inst_37415);

(statearr_37828_38012[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (111))){
var inst_37650 = (state_37741[(37)]);
var inst_37672 = (state_37741[(2)]);
var inst_37642 = inst_37650;
var inst_37643 = inst_37672;
var state_37741__$1 = (function (){var statearr_37829 = state_37741;
(statearr_37829[(38)] = inst_37642);

(statearr_37829[(10)] = inst_37643);

return statearr_37829;
})();
var statearr_37830_38013 = state_37741__$1;
(statearr_37830_38013[(2)] = null);

(statearr_37830_38013[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (28))){
var state_37741__$1 = state_37741;
var statearr_37831_38014 = state_37741__$1;
(statearr_37831_38014[(2)] = null);

(statearr_37831_38014[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (64))){
var inst_37437 = (state_37741[(18)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37437)){
var statearr_37832_38015 = state_37741__$1;
(statearr_37832_38015[(1)] = (67));

} else {
var statearr_37833_38016 = state_37741__$1;
(statearr_37833_38016[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (103))){
var state_37741__$1 = state_37741;
if(cljs.core.truth_(fuel)){
var statearr_37834_38017 = state_37741__$1;
(statearr_37834_38017[(1)] = (105));

} else {
var statearr_37835_38018 = state_37741__$1;
(statearr_37835_38018[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (51))){
var inst_37518 = (state_37741[(26)]);
var state_37741__$1 = state_37741;
var statearr_37836_38019 = state_37741__$1;
(statearr_37836_38019[(2)] = inst_37518);

(statearr_37836_38019[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (25))){
var state_37741__$1 = state_37741;
var statearr_37837_38020 = state_37741__$1;
(statearr_37837_38020[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (34))){
var state_37741__$1 = state_37741;
var statearr_37839_38021 = state_37741__$1;
(statearr_37839_38021[(2)] = null);

(statearr_37839_38021[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (125))){
var inst_37719 = (state_37741[(11)]);
var inst_37722 = (state_37741[(30)]);
var inst_37722__$1 = cljs.core.coll_QMARK_(inst_37719);
var state_37741__$1 = (function (){var statearr_37840 = state_37741;
(statearr_37840[(30)] = inst_37722__$1);

return statearr_37840;
})();
if(inst_37722__$1){
var statearr_37841_38022 = state_37741__$1;
(statearr_37841_38022[(1)] = (128));

} else {
var statearr_37842_38023 = state_37741__$1;
(statearr_37842_38023[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (17))){
var inst_37437 = (state_37741[(18)]);
var inst_37448 = (state_37741[(2)]);
var inst_37449 = cljs.core.PersistentHashMap.EMPTY;
var inst_37450 = cljs.core.volatile_BANG_(inst_37449);
var state_37741__$1 = (function (){var statearr_37843 = state_37741;
(statearr_37843[(7)] = inst_37450);

(statearr_37843[(8)] = inst_37448);

return statearr_37843;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37844_38024 = state_37741__$1;
(statearr_37844_38024[(1)] = (18));

} else {
var statearr_37845_38025 = state_37741__$1;
(statearr_37845_38025[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (3))){
var inst_37739 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37741__$1,inst_37739);
} else {
if((state_val_37742 === (12))){
var inst_37421 = (state_37741[(39)]);
var state_37741__$1 = state_37741;
var statearr_37846_38026 = state_37741__$1;
(statearr_37846_38026[(2)] = inst_37421);

(statearr_37846_38026[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (2))){
var inst_37415 = (state_37741[(36)]);
var _ = (function (){var statearr_37847 = state_37741;
(statearr_37847[(4)] = cljs.core.cons((5),(state_37741[(4)])));

return statearr_37847;
})();
var inst_37415__$1 = select;
var state_37741__$1 = (function (){var statearr_37848 = state_37741;
(statearr_37848[(36)] = inst_37415__$1);

return statearr_37848;
})();
if(cljs.core.truth_(inst_37415__$1)){
var statearr_37849_38027 = state_37741__$1;
(statearr_37849_38027[(1)] = (6));

} else {
var statearr_37850_38028 = state_37741__$1;
(statearr_37850_38028[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (66))){
var inst_37710 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37851_38029 = state_37741__$1;
(statearr_37851_38029[(2)] = inst_37710);

(statearr_37851_38029[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (107))){
var inst_37649 = (state_37741[(19)]);
var inst_37661 = (state_37741[(2)]);
var inst_37662 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_37649,false);
var state_37741__$1 = (function (){var statearr_37852 = state_37741;
(statearr_37852[(40)] = inst_37661);

return statearr_37852;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(108),inst_37662);
} else {
if((state_val_37742 === (23))){
var inst_37476 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37853_38030 = state_37741__$1;
(statearr_37853_38030[(2)] = inst_37476);

(statearr_37853_38030[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (47))){
var inst_37518 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_37741__$1 = (function (){var statearr_37854 = state_37741;
(statearr_37854[(26)] = inst_37518);

return statearr_37854;
})();
if(cljs.core.truth_(fuel)){
var statearr_37855_38031 = state_37741__$1;
(statearr_37855_38031[(1)] = (50));

} else {
var statearr_37856_38032 = state_37741__$1;
(statearr_37856_38032[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (35))){
var inst_37491 = (state_37741[(2)]);
var inst_37492 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_37491);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(36),inst_37492);
} else {
if((state_val_37742 === (127))){
var inst_37731 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37731)){
var statearr_37857_38033 = state_37741__$1;
(statearr_37857_38033[(1)] = (131));

} else {
var statearr_37858_38034 = state_37741__$1;
(statearr_37858_38034[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (82))){
var inst_37706 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37859_38035 = state_37741__$1;
(statearr_37859_38035[(2)] = inst_37706);

(statearr_37859_38035[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (76))){
var inst_37440 = (state_37741[(15)]);
var inst_37438 = (state_37741[(13)]);
var inst_37584 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37585 = [inst_37438,inst_37440];
var inst_37586 = cljs.core.PersistentHashMap.fromArrays(inst_37584,inst_37585);
var state_37741__$1 = state_37741;
var statearr_37860_38036 = state_37741__$1;
(statearr_37860_38036[(2)] = inst_37586);

(statearr_37860_38036[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (97))){
var inst_37642 = (state_37741[(38)]);
var inst_37649 = (state_37741[(19)]);
var inst_37648 = cljs.core.seq(inst_37642);
var inst_37649__$1 = cljs.core.first(inst_37648);
var inst_37650 = cljs.core.next(inst_37648);
var inst_37651 = cljs.core.not(inst_37649__$1);
var state_37741__$1 = (function (){var statearr_37861 = state_37741;
(statearr_37861[(19)] = inst_37649__$1);

(statearr_37861[(37)] = inst_37650);

return statearr_37861;
})();
if(inst_37651){
var statearr_37862_38037 = state_37741__$1;
(statearr_37862_38037[(1)] = (99));

} else {
var statearr_37863_38038 = state_37741__$1;
(statearr_37863_38038[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (19))){
var inst_37478 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37479 = [null,null];
var inst_37480 = (new cljs.core.PersistentVector(null,2,(5),inst_37478,inst_37479,null));
var state_37741__$1 = state_37741;
var statearr_37864_38039 = state_37741__$1;
(statearr_37864_38039[(2)] = inst_37480);

(statearr_37864_38039[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (57))){
var inst_37440 = (state_37741[(15)]);
var inst_37438 = (state_37741[(13)]);
var inst_37534 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37535 = [inst_37438,inst_37440];
var inst_37536 = cljs.core.PersistentHashMap.fromArrays(inst_37534,inst_37535);
var state_37741__$1 = state_37741;
var statearr_37865_38040 = state_37741__$1;
(statearr_37865_38040[(2)] = inst_37536);

(statearr_37865_38040[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (68))){
var inst_37440 = (state_37741[(15)]);
var inst_37438 = (state_37741[(13)]);
var inst_37565 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_37566 = [inst_37438,inst_37440];
var inst_37567 = cljs.core.PersistentHashMap.fromArrays(inst_37565,inst_37566);
var state_37741__$1 = state_37741;
var statearr_37866_38041 = state_37741__$1;
(statearr_37866_38041[(2)] = inst_37567);

(statearr_37866_38041[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (11))){
var inst_37432 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37867_38042 = state_37741__$1;
(statearr_37867_38042[(2)] = inst_37432);

(statearr_37867_38042[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (115))){
var inst_37437 = (state_37741[(18)]);
var inst_37683 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37869 = state_37741;
(statearr_37869[(35)] = inst_37683);

return statearr_37869;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37870_38043 = state_37741__$1;
(statearr_37870_38043[(1)] = (116));

} else {
var statearr_37871_38044 = state_37741__$1;
(statearr_37871_38044[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (9))){
var inst_37418 = (state_37741[(12)]);
var state_37741__$1 = state_37741;
var statearr_37872_38045 = state_37741__$1;
(statearr_37872_38045[(2)] = inst_37418);

(statearr_37872_38045[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (5))){
var _ = (function (){var statearr_37873 = state_37741;
(statearr_37873[(4)] = cljs.core.rest((state_37741[(4)])));

return statearr_37873;
})();
var state_37741__$1 = state_37741;
var ex37868 = (state_37741__$1[(2)]);
var statearr_37874_38046 = state_37741__$1;
(statearr_37874_38046[(5)] = ex37868);


if((ex37868 instanceof Error)){
var statearr_37875_38047 = state_37741__$1;
(statearr_37875_38047[(1)] = (4));

(statearr_37875_38047[(5)] = null);

} else {
throw ex37868;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (112))){
var inst_37690 = (state_37741[(2)]);
var inst_37691 = fluree.db.util.async.throw_err(inst_37690);
var state_37741__$1 = state_37741;
var statearr_37876_38048 = state_37741__$1;
(statearr_37876_38048[(2)] = inst_37691);

(statearr_37876_38048[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (83))){
var inst_37604 = (state_37741[(20)]);
var inst_37603 = (state_37741[(2)]);
var inst_37604__$1 = fluree.db.util.async.throw_err(inst_37603);
var inst_37605 = (inst_37604__$1 == null);
var state_37741__$1 = (function (){var statearr_37877 = state_37741;
(statearr_37877[(20)] = inst_37604__$1);

return statearr_37877;
})();
if(cljs.core.truth_(inst_37605)){
var statearr_37878_38049 = state_37741__$1;
(statearr_37878_38049[(1)] = (84));

} else {
var statearr_37879_38050 = state_37741__$1;
(statearr_37879_38050[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (14))){
var inst_37430 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37880_38051 = state_37741__$1;
(statearr_37880_38051[(2)] = inst_37430);

(statearr_37880_38051[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (45))){
var inst_37509 = (state_37741[(27)]);
var state_37741__$1 = state_37741;
var statearr_37881_38052 = state_37741__$1;
(statearr_37881_38052[(2)] = inst_37509);

(statearr_37881_38052[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (53))){
var inst_37524 = (state_37741[(21)]);
var inst_37526 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_37527 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_37524,inst_37526);
var state_37741__$1 = state_37741;
var statearr_37882_38053 = state_37741__$1;
(statearr_37882_38053[(2)] = inst_37527);

(statearr_37882_38053[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (78))){
var inst_37450 = (state_37741[(7)]);
var inst_37448 = (state_37741[(8)]);
var inst_37591 = (state_37741[(2)]);
var inst_37592 = fluree.db.util.async.throw_err(inst_37591);
var inst_37593 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_37450,fuel,max_fuel,inst_37448,inst_37592);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(79),inst_37593);
} else {
if((state_val_37742 === (132))){
var inst_37719 = (state_37741[(11)]);
var state_37741__$1 = state_37741;
var statearr_37883_38054 = state_37741__$1;
(statearr_37883_38054[(2)] = inst_37719);

(statearr_37883_38054[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (26))){
var inst_37474 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37884_38055 = state_37741__$1;
(statearr_37884_38055[(2)] = inst_37474);

(statearr_37884_38055[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (123))){
var inst_37714 = (state_37741[(28)]);
var state_37741__$1 = state_37741;
var statearr_37885_38056 = state_37741__$1;
(statearr_37885_38056[(2)] = inst_37714);

(statearr_37885_38056[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (16))){
var inst_37441 = (state_37741[(24)]);
var state_37741__$1 = state_37741;
var statearr_37886_38057 = state_37741__$1;
(statearr_37886_38057[(2)] = inst_37441);

(statearr_37886_38057[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (133))){
var inst_37736 = (state_37741[(2)]);
var _ = (function (){var statearr_37887 = state_37741;
(statearr_37887[(4)] = cljs.core.rest((state_37741[(4)])));

return statearr_37887;
})();
var state_37741__$1 = state_37741;
var statearr_37888_38058 = state_37741__$1;
(statearr_37888_38058[(2)] = inst_37736);

(statearr_37888_38058[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (81))){
var inst_37623 = (state_37741[(22)]);
var inst_37623__$1 = cljs.core.sequential_QMARK_(from);
var state_37741__$1 = (function (){var statearr_37889 = state_37741;
(statearr_37889[(22)] = inst_37623__$1);

return statearr_37889;
})();
if(inst_37623__$1){
var statearr_37890_38059 = state_37741__$1;
(statearr_37890_38059[(1)] = (91));

} else {
var statearr_37891_38060 = state_37741__$1;
(statearr_37891_38060[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (120))){
var state_37741__$1 = state_37741;
var statearr_37892_38061 = state_37741__$1;
(statearr_37892_38061[(2)] = null);

(statearr_37892_38061[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (79))){
var inst_37595 = (state_37741[(2)]);
var inst_37596 = fluree.db.util.async.throw_err(inst_37595);
var state_37741__$1 = state_37741;
var statearr_37893_38062 = state_37741__$1;
(statearr_37893_38062[(2)] = inst_37596);

(statearr_37893_38062[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (38))){
var state_37741__$1 = state_37741;
var statearr_37894_38063 = state_37741__$1;
(statearr_37894_38063[(2)] = null);

(statearr_37894_38063[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (126))){
var inst_37720 = (state_37741[(41)]);
var state_37741__$1 = state_37741;
var statearr_37895_38064 = state_37741__$1;
(statearr_37895_38064[(2)] = inst_37720);

(statearr_37895_38064[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (98))){
var inst_37437 = (state_37741[(18)]);
var inst_37677 = (state_37741[(2)]);
var inst_37678 = cljs.core.PersistentVector.EMPTY;
var inst_37679 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37678,inst_37677);
var state_37741__$1 = (function (){var statearr_37896 = state_37741;
(statearr_37896[(34)] = inst_37679);

return statearr_37896;
})();
if(cljs.core.truth_(inst_37437)){
var statearr_37897_38065 = state_37741__$1;
(statearr_37897_38065[(1)] = (113));

} else {
var statearr_37898_38066 = state_37741__$1;
(statearr_37898_38066[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (124))){
var inst_37720 = (state_37741[(41)]);
var inst_37719 = (state_37741[(2)]);
var inst_37720__$1 = selectOne;
var state_37741__$1 = (function (){var statearr_37899 = state_37741;
(statearr_37899[(41)] = inst_37720__$1);

(statearr_37899[(11)] = inst_37719);

return statearr_37899;
})();
if(cljs.core.truth_(inst_37720__$1)){
var statearr_37900_38067 = state_37741__$1;
(statearr_37900_38067[(1)] = (125));

} else {
var statearr_37901_38068 = state_37741__$1;
(statearr_37901_38068[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (87))){
var inst_37615 = (state_37741[(2)]);
var inst_37616 = fluree.db.util.async.throw_err(inst_37615);
var state_37741__$1 = (function (){var statearr_37902 = state_37741;
(statearr_37902[(31)] = inst_37616);

return statearr_37902;
})();
if(cljs.core.truth_(fuel)){
var statearr_37903_38069 = state_37741__$1;
(statearr_37903_38069[(1)] = (88));

} else {
var statearr_37904_38070 = state_37741__$1;
(statearr_37904_38070[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (30))){
var inst_37487 = typeof from === 'string';
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37487)){
var statearr_37905_38071 = state_37741__$1;
(statearr_37905_38071[(1)] = (33));

} else {
var statearr_37906_38072 = state_37741__$1;
(statearr_37906_38072[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (73))){
var inst_37598 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_37741__$1 = state_37741;
if(inst_37598){
var statearr_37907_38073 = state_37741__$1;
(statearr_37907_38073[(1)] = (80));

} else {
var statearr_37908_38074 = state_37741__$1;
(statearr_37908_38074[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (96))){
var inst_37704 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37909_38075 = state_37741__$1;
(statearr_37909_38075[(2)] = inst_37704);

(statearr_37909_38075[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (10))){
var inst_37421 = (state_37741[(39)]);
var inst_37421__$1 = selectDistinct;
var state_37741__$1 = (function (){var statearr_37910 = state_37741;
(statearr_37910[(39)] = inst_37421__$1);

return statearr_37910;
})();
if(cljs.core.truth_(inst_37421__$1)){
var statearr_37911_38076 = state_37741__$1;
(statearr_37911_38076[(1)] = (12));

} else {
var statearr_37912_38077 = state_37741__$1;
(statearr_37912_38077[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (18))){
var inst_37437 = (state_37741[(18)]);
var inst_37452 = cljs.core.vector_QMARK_(inst_37437);
var state_37741__$1 = state_37741;
if(inst_37452){
var statearr_37913_38078 = state_37741__$1;
(statearr_37913_38078[(1)] = (21));

} else {
var statearr_37914_38079 = state_37741__$1;
(statearr_37914_38079[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (105))){
var inst_37658 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_37741__$1 = state_37741;
var statearr_37915_38080 = state_37741__$1;
(statearr_37915_38080[(2)] = inst_37658);

(statearr_37915_38080[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (52))){
var inst_37524 = (state_37741[(2)]);
var state_37741__$1 = (function (){var statearr_37916 = state_37741;
(statearr_37916[(21)] = inst_37524);

return statearr_37916;
})();
var statearr_37917_38081 = state_37741__$1;
(statearr_37917_38081[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (114))){
var inst_37438 = (state_37741[(13)]);
var state_37741__$1 = state_37741;
var statearr_37919_38082 = state_37741__$1;
(statearr_37919_38082[(2)] = inst_37438);

(statearr_37919_38082[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (67))){
var inst_37563 = cljs.core.PersistentHashMap.EMPTY;
var state_37741__$1 = state_37741;
var statearr_37920_38083 = state_37741__$1;
(statearr_37920_38083[(2)] = inst_37563);

(statearr_37920_38083[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (71))){
var inst_37576 = (state_37741[(2)]);
var inst_37577 = fluree.db.util.async.throw_err(inst_37576);
var state_37741__$1 = state_37741;
var statearr_37921_38084 = state_37741__$1;
(statearr_37921_38084[(2)] = inst_37577);

(statearr_37921_38084[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (42))){
var inst_37440 = (state_37741[(15)]);
var state_37741__$1 = state_37741;
var statearr_37922_38085 = state_37741__$1;
(statearr_37922_38085[(2)] = inst_37440);

(statearr_37922_38085[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (80))){
var inst_37601 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_37741__$1 = state_37741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37741__$1,(83),inst_37601);
} else {
if((state_val_37742 === (37))){
var inst_37506 = (state_37741[(2)]);
var inst_37507 = fluree.db.util.async.throw_err(inst_37506);
var state_37741__$1 = state_37741;
var statearr_37923_38086 = state_37741__$1;
(statearr_37923_38086[(2)] = inst_37507);

(statearr_37923_38086[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (63))){
var inst_37560 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
if(cljs.core.truth_(inst_37560)){
var statearr_37924_38087 = state_37741__$1;
(statearr_37924_38087[(1)] = (64));

} else {
var statearr_37925_38088 = state_37741__$1;
(statearr_37925_38088[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (94))){
var inst_37637 = from;
var inst_37638 = cljs.core.seq(inst_37637);
var inst_37639 = cljs.core.first(inst_37638);
var inst_37640 = cljs.core.next(inst_37638);
var inst_37641 = cljs.core.PersistentVector.EMPTY;
var inst_37642 = inst_37637;
var inst_37643 = inst_37641;
var state_37741__$1 = (function (){var statearr_37926 = state_37741;
(statearr_37926[(38)] = inst_37642);

(statearr_37926[(10)] = inst_37643);

(statearr_37926[(42)] = inst_37639);

(statearr_37926[(43)] = inst_37640);

return statearr_37926;
})();
var statearr_37927_38089 = state_37741__$1;
(statearr_37927_38089[(2)] = null);

(statearr_37927_38089[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (8))){
var inst_37439 = (state_37741[(25)]);
var inst_37434 = (state_37741[(2)]);
var inst_37435 = opts_SINGLEQUOTE_;
var inst_37436 = cljs.core.__destructure_map(inst_37435);
var inst_37437 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37436,cljs.core.cst$kw$orderBy);
var inst_37438 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37436,cljs.core.cst$kw$limit);
var inst_37439__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37436,cljs.core.cst$kw$component);
var inst_37440 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37436,cljs.core.cst$kw$offset);
var inst_37441 = fluree.db.query.fql_parser.parse_db(db,inst_37434,opts_SINGLEQUOTE_);
var inst_37442 = (inst_37439__$1 == null);
var inst_37443 = cljs.core.not(inst_37442);
var state_37741__$1 = (function (){var statearr_37928 = state_37741;
(statearr_37928[(24)] = inst_37441);

(statearr_37928[(15)] = inst_37440);

(statearr_37928[(18)] = inst_37437);

(statearr_37928[(25)] = inst_37439__$1);

(statearr_37928[(13)] = inst_37438);

return statearr_37928;
})();
if(inst_37443){
var statearr_37929_38090 = state_37741__$1;
(statearr_37929_38090[(1)] = (15));

} else {
var statearr_37930_38091 = state_37741__$1;
(statearr_37930_38091[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (49))){
var inst_37712 = (state_37741[(2)]);
var state_37741__$1 = state_37741;
var statearr_37931_38092 = state_37741__$1;
(statearr_37931_38092[(2)] = inst_37712);

(statearr_37931_38092[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37742 === (84))){
var state_37741__$1 = state_37741;
var statearr_37932_38093 = state_37741__$1;
(statearr_37932_38093[(2)] = null);

(statearr_37932_38093[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__10750__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__10750__auto____0 = (function (){
var statearr_37933 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37933[(0)] = fluree$db$query$fql$query_$_state_machine__10750__auto__);

(statearr_37933[(1)] = (1));

return statearr_37933;
});
var fluree$db$query$fql$query_$_state_machine__10750__auto____1 = (function (state_37741){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_37741);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e37934){var ex__10753__auto__ = e37934;
var statearr_37935_38094 = state_37741;
(statearr_37935_38094[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_37741[(4)]))){
var statearr_37936_38095 = state_37741;
(statearr_37936_38095[(1)] = cljs.core.first((state_37741[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__38096 = state_37741;
state_37741 = G__38096;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__10750__auto__ = function(state_37741){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__10750__auto____1.call(this,state_37741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__10750__auto____0;
fluree$db$query$fql$query_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__10750__auto____1;
return fluree$db$query$fql$query_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_37937 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_37937[(6)] = c__10876__auto__);

return statearr_37937;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}

});
