// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__25576 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25576,(5),null);
var G__25579 = idx;
var G__25579__$1 = (((G__25579 instanceof cljs.core.Keyword))?G__25579.fqn:null);
switch (G__25579__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25579__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__25581 = idx;
var G__25581__$1 = (((G__25581 instanceof cljs.core.Keyword))?G__25581.fqn:null);
switch (G__25581__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25581__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__25583 = idx;
var G__25583__$1 = (((G__25583 instanceof cljs.core.Keyword))?G__25583.fqn:null);
switch (G__25583__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__25583__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__25586 = arguments.length;
switch (G__25586) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__25587 = (function (){var pred__25590 = cljs.core.identical_QMARK_;
var expr__25591 = test;
if(cljs.core.truth_((pred__25590.cljs$core$IFn$_invoke$arity$2 ? pred__25590.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__25591) : pred__25590.call(null,cljs.core._EQ_,expr__25591)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25590.cljs$core$IFn$_invoke$arity$2 ? pred__25590.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__25591) : pred__25590.call(null,cljs.core._LT_,expr__25591)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__25590.cljs$core$IFn$_invoke$arity$2 ? pred__25590.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__25591) : pred__25590.call(null,cljs.core._LT__EQ_,expr__25591)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__25590.cljs$core$IFn$_invoke$arity$2 ? pred__25590.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__25591) : pred__25590.call(null,cljs.core._GT_,expr__25591)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__25590.cljs$core$IFn$_invoke$arity$2 ? pred__25590.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__25591) : pred__25590.call(null,cljs.core._GT__EQ_,expr__25591)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__25591)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25587,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25587,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25587,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__25587,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_25830){
var state_val_25831 = (state_25830[(1)]);
if((state_val_25831 === (65))){
var inst_25801 = (state_25830[(7)]);
var inst_25745 = (state_25830[(8)]);
var inst_25801__$1 = (state_25830[(2)]);
var inst_25802 = cljs.core.count(inst_25801__$1);
var state_25830__$1 = (function (){var statearr_25832 = state_25830;
(statearr_25832[(9)] = inst_25802);

(statearr_25832[(7)] = inst_25801__$1);

return statearr_25832;
})();
if(cljs.core.truth_(inst_25745)){
var statearr_25833_25970 = state_25830__$1;
(statearr_25833_25970[(1)] = (81));

} else {
var statearr_25834_25971 = state_25830__$1;
(statearr_25834_25971[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (70))){
var inst_25776 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25776)){
var statearr_25835_25972 = state_25830__$1;
(statearr_25835_25972[(1)] = (71));

} else {
var statearr_25836_25973 = state_25830__$1;
(statearr_25836_25973[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (62))){
var inst_25715 = (state_25830[(10)]);
var inst_25729 = (state_25830[(11)]);
var inst_25744 = (state_25830[(2)]);
var inst_25745 = fluree.db.dbproto._rhs(inst_25729);
var state_25830__$1 = (function (){var statearr_25837 = state_25830;
(statearr_25837[(12)] = inst_25744);

(statearr_25837[(8)] = inst_25745);

return statearr_25837;
})();
if(cljs.core.truth_(inst_25715)){
var statearr_25838_25974 = state_25830__$1;
(statearr_25838_25974[(1)] = (63));

} else {
var statearr_25839_25975 = state_25830__$1;
(statearr_25839_25975[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (74))){
var inst_25769 = (state_25830[(13)]);
var inst_25783 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_25769);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(77),inst_25783);
} else {
if((state_val_25831 === (7))){
var inst_25606 = (state_25830[(14)]);
var state_25830__$1 = state_25830;
var statearr_25840_25976 = state_25830__$1;
(statearr_25840_25976[(2)] = inst_25606);

(statearr_25840_25976[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (59))){
var inst_25736 = (state_25830[(15)]);
var inst_25692 = (state_25830[(16)]);
var inst_25691 = (state_25830[(17)]);
var inst_25735 = (state_25830[(2)]);
var inst_25736__$1 = fluree.db.util.async.throw_err(inst_25735);
var inst_25737 = fluree.db.flake.subrange(inst_25736__$1,start_test,inst_25691,end_test,inst_25692);
var inst_25738 = fluree.db.query.range.value_with_nil_pred(idx,inst_25691,inst_25692);
var state_25830__$1 = (function (){var statearr_25841 = state_25830;
(statearr_25841[(15)] = inst_25736__$1);

(statearr_25841[(18)] = inst_25737);

return statearr_25841;
})();
if(inst_25738){
var statearr_25842_25977 = state_25830__$1;
(statearr_25842_25977[(1)] = (60));

} else {
var statearr_25843_25978 = state_25830__$1;
(statearr_25843_25978[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (86))){
var inst_25810 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25844_25979 = state_25830__$1;
(statearr_25844_25979[(2)] = inst_25810);

(statearr_25844_25979[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (20))){
var inst_25607 = (state_25830[(19)]);
var inst_25655 = (state_25830[(20)]);
var inst_25654 = (state_25830[(2)]);
var inst_25655__$1 = (inst_25607 == null);
var state_25830__$1 = (function (){var statearr_25845 = state_25830;
(statearr_25845[(20)] = inst_25655__$1);

(statearr_25845[(21)] = inst_25654);

return statearr_25845;
})();
if(cljs.core.truth_(inst_25655__$1)){
var statearr_25846_25980 = state_25830__$1;
(statearr_25846_25980[(1)] = (22));

} else {
var statearr_25847_25981 = state_25830__$1;
(statearr_25847_25981[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (72))){
var inst_25762 = (state_25830[(22)]);
var inst_25780 = (inst_25762 + (1));
var inst_25781 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25830__$1 = (function (){var statearr_25848 = state_25830;
(statearr_25848[(23)] = inst_25780);

return statearr_25848;
})();
if(cljs.core.truth_(inst_25781)){
var statearr_25849_25982 = state_25830__$1;
(statearr_25849_25982[(1)] = (74));

} else {
var statearr_25850_25983 = state_25830__$1;
(statearr_25850_25983[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (58))){
var inst_25825 = (state_25830[(2)]);
var _ = (function (){var statearr_25851 = state_25830;
(statearr_25851[(4)] = cljs.core.rest((state_25830[(4)])));

return statearr_25851;
})();
var state_25830__$1 = state_25830;
var statearr_25852_25984 = state_25830__$1;
(statearr_25852_25984[(2)] = inst_25825);

(statearr_25852_25984[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (60))){
var inst_25609 = (state_25830[(24)]);
var inst_25736 = (state_25830[(15)]);
var inst_25616 = (state_25830[(25)]);
var inst_25692 = (state_25830[(16)]);
var inst_25612 = (state_25830[(26)]);
var inst_25691 = (state_25830[(17)]);
var inst_25731 = (state_25830[(27)]);
var inst_25724 = (state_25830[(28)]);
var inst_25663 = (state_25830[(29)]);
var inst_25697 = (state_25830[(30)]);
var inst_25709 = (state_25830[(31)]);
var inst_25719 = (state_25830[(32)]);
var inst_25708 = (state_25830[(33)]);
var inst_25690 = (state_25830[(34)]);
var inst_25698 = (state_25830[(35)]);
var inst_25605 = (state_25830[(36)]);
var inst_25702 = (state_25830[(37)]);
var inst_25610 = (state_25830[(38)]);
var inst_25627 = (state_25830[(39)]);
var inst_25645 = (state_25830[(40)]);
var inst_25737 = (state_25830[(18)]);
var inst_25715 = (state_25830[(10)]);
var inst_25654 = (state_25830[(21)]);
var inst_25617 = (state_25830[(41)]);
var inst_25681 = (state_25830[(42)]);
var inst_25730 = (state_25830[(43)]);
var inst_25672 = (state_25830[(44)]);
var inst_25636 = (state_25830[(45)]);
var inst_25729 = (state_25830[(11)]);
var inst_25740 = (function (){var no_filter_QMARK_ = inst_25715;
var next_node = inst_25729;
var flakes = inst_25736;
var s1 = inst_25627;
var o2 = inst_25654;
var t1 = inst_25609;
var i = inst_25730;
var m1 = inst_25681;
var root_node = inst_25724;
var to_t = inst_25709;
var s2 = inst_25636;
var p2 = inst_25672;
var permissions = inst_25698;
var vec__25599 = inst_25605;
var limit = inst_25697;
var start_flake = inst_25691;
var acc = inst_25731;
var t2 = inst_25616;
var vec__25602 = inst_25612;
var op1 = inst_25610;
var o1 = inst_25645;
var end_flake = inst_25692;
var base_result = inst_25737;
var p1 = inst_25663;
var idx_compare = inst_25702;
var op2 = inst_25617;
var from_t = inst_25708;
var m2 = inst_25690;
var novelty = inst_25719;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_25741 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_25740,inst_25737,inst_25737);
var state_25830__$1 = state_25830;
var statearr_25853_25985 = state_25830__$1;
(statearr_25853_25985[(2)] = inst_25741);

(statearr_25853_25985[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (27))){
var inst_25664 = (state_25830[(46)]);
var inst_25614 = (state_25830[(47)]);
var inst_25663 = (state_25830[(2)]);
var inst_25664__$1 = (inst_25614 == null);
var state_25830__$1 = (function (){var statearr_25854 = state_25830;
(statearr_25854[(29)] = inst_25663);

(statearr_25854[(46)] = inst_25664__$1);

return statearr_25854;
})();
if(cljs.core.truth_(inst_25664__$1)){
var statearr_25855_25986 = state_25830__$1;
(statearr_25855_25986[(1)] = (28));

} else {
var statearr_25856_25987 = state_25830__$1;
(statearr_25856_25987[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (1))){
var state_25830__$1 = state_25830;
var statearr_25857_25988 = state_25830__$1;
(statearr_25857_25988[(2)] = null);

(statearr_25857_25988[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (69))){
var inst_25697 = (state_25830[(30)]);
var inst_25762 = (state_25830[(22)]);
var inst_25774 = (inst_25762 > inst_25697);
var state_25830__$1 = state_25830;
var statearr_25858_25989 = state_25830__$1;
(statearr_25858_25989[(2)] = inst_25774);

(statearr_25858_25989[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (24))){
var inst_25659 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25659)){
var statearr_25859_25990 = state_25830__$1;
(statearr_25859_25990[(1)] = (25));

} else {
var statearr_25860_25991 = state_25830__$1;
(statearr_25860_25991[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (55))){
var inst_25691 = (state_25830[(17)]);
var inst_25724 = (state_25830[(28)]);
var inst_25723 = (state_25830[(2)]);
var inst_25724__$1 = fluree.db.util.async.throw_err(inst_25723);
var inst_25725 = fluree.db.dbproto._lookup_leaf(inst_25724__$1,inst_25691);
var state_25830__$1 = (function (){var statearr_25861 = state_25830;
(statearr_25861[(28)] = inst_25724__$1);

return statearr_25861;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(56),inst_25725);
} else {
if((state_val_25831 === (85))){
var inst_25805 = (state_25830[(48)]);
var state_25830__$1 = state_25830;
var statearr_25862_25992 = state_25830__$1;
(statearr_25862_25992[(2)] = inst_25805);

(statearr_25862_25992[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (39))){
var inst_25679 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25863_25993 = state_25830__$1;
(statearr_25863_25993[(2)] = inst_25679);

(statearr_25863_25993[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (88))){
var inst_25724 = (state_25830[(28)]);
var inst_25745 = (state_25830[(8)]);
var inst_25817 = fluree.db.dbproto._lookup_leaf(inst_25724,inst_25745);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(90),inst_25817);
} else {
if((state_val_25831 === (46))){
var inst_25693 = (state_25830[(49)]);
var state_25830__$1 = state_25830;
var statearr_25864_25994 = state_25830__$1;
(statearr_25864_25994[(2)] = inst_25693);

(statearr_25864_25994[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (4))){
var inst_25593 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25865_25995 = state_25830__$1;
(statearr_25865_25995[(2)] = inst_25593);

(statearr_25865_25995[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (77))){
var inst_25785 = (state_25830[(2)]);
var inst_25786 = fluree.db.util.async.throw_err(inst_25785);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25786)){
var statearr_25866_25996 = state_25830__$1;
(statearr_25866_25996[(1)] = (78));

} else {
var statearr_25867_25997 = state_25830__$1;
(statearr_25867_25997[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (54))){
var inst_25715 = (state_25830[(2)]);
var inst_25716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25717 = [cljs.core.cst$kw$novelty,idx];
var inst_25718 = (new cljs.core.PersistentVector(null,2,(5),inst_25716,inst_25717,null));
var inst_25719 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25718);
var inst_25720 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_25721 = fluree.db.dbproto._resolve(inst_25720);
var state_25830__$1 = (function (){var statearr_25868 = state_25830;
(statearr_25868[(32)] = inst_25719);

(statearr_25868[(10)] = inst_25715);

return statearr_25868;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(55),inst_25721);
} else {
if((state_val_25831 === (15))){
var inst_25608 = (state_25830[(50)]);
var state_25830__$1 = state_25830;
var statearr_25869_25998 = state_25830__$1;
(statearr_25869_25998[(2)] = inst_25608);

(statearr_25869_25998[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (48))){
var inst_25703 = (state_25830[(51)]);
var inst_25697 = (state_25830[(2)]);
var inst_25698 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_25699 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_25700 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_25701 = (new cljs.core.PersistentVector(null,3,(5),inst_25699,inst_25700,null));
var inst_25702 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_25701);
var inst_25703__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_25830__$1 = (function (){var statearr_25870 = state_25830;
(statearr_25870[(30)] = inst_25697);

(statearr_25870[(35)] = inst_25698);

(statearr_25870[(37)] = inst_25702);

(statearr_25870[(51)] = inst_25703__$1);

return statearr_25870;
})();
if(cljs.core.truth_(inst_25703__$1)){
var statearr_25871_25999 = state_25830__$1;
(statearr_25871_25999[(1)] = (49));

} else {
var statearr_25872_26000 = state_25830__$1;
(statearr_25872_26000[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (50))){
var inst_25706 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_25830__$1 = state_25830;
var statearr_25873_26001 = state_25830__$1;
(statearr_25873_26001[(2)] = inst_25706);

(statearr_25873_26001[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (75))){
var inst_25763 = (state_25830[(52)]);
var state_25830__$1 = state_25830;
var statearr_25874_26002 = state_25830__$1;
(statearr_25874_26002[(2)] = inst_25763);

(statearr_25874_26002[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (21))){
var inst_25650 = (state_25830[(2)]);
var inst_25651 = fluree.db.util.async.throw_err(inst_25650);
var state_25830__$1 = state_25830;
var statearr_25875_26003 = state_25830__$1;
(statearr_25875_26003[(2)] = inst_25651);

(statearr_25875_26003[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (31))){
var state_25830__$1 = state_25830;
var statearr_25876_26004 = state_25830__$1;
(statearr_25876_26004[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_25876_26004[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (32))){
var inst_25614 = (state_25830[(47)]);
var state_25830__$1 = state_25830;
var statearr_25877_26005 = state_25830__$1;
(statearr_25877_26005[(2)] = inst_25614);

(statearr_25877_26005[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (40))){
var inst_25618 = (state_25830[(53)]);
var state_25830__$1 = state_25830;
var statearr_25878_26006 = state_25830__$1;
(statearr_25878_26006[(2)] = inst_25618);

(statearr_25878_26006[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (56))){
var inst_25727 = (state_25830[(2)]);
var inst_25728 = fluree.db.util.async.throw_err(inst_25727);
var inst_25729 = inst_25728;
var inst_25730 = (0);
var inst_25731 = null;
var state_25830__$1 = (function (){var statearr_25879 = state_25830;
(statearr_25879[(27)] = inst_25731);

(statearr_25879[(43)] = inst_25730);

(statearr_25879[(11)] = inst_25729);

return statearr_25879;
})();
var statearr_25880_26007 = state_25830__$1;
(statearr_25880_26007[(2)] = null);

(statearr_25880_26007[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (33))){
var inst_25611 = (state_25830[(54)]);
var inst_25672 = (state_25830[(2)]);
var state_25830__$1 = (function (){var statearr_25881 = state_25830;
(statearr_25881[(44)] = inst_25672);

return statearr_25881;
})();
if(cljs.core.truth_(inst_25611)){
var statearr_25882_26008 = state_25830__$1;
(statearr_25882_26008[(1)] = (34));

} else {
var statearr_25883_26009 = state_25830__$1;
(statearr_25883_26009[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (13))){
var inst_25632 = (state_25830[(2)]);
var inst_25633 = fluree.db.util.async.throw_err(inst_25632);
var state_25830__$1 = state_25830;
var statearr_25884_26010 = state_25830__$1;
(statearr_25884_26010[(2)] = inst_25633);

(statearr_25884_26010[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (22))){
var inst_25645 = (state_25830[(40)]);
var state_25830__$1 = state_25830;
var statearr_25885_26011 = state_25830__$1;
(statearr_25885_26011[(2)] = inst_25645);

(statearr_25885_26011[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (90))){
var inst_25802 = (state_25830[(9)]);
var inst_25801 = (state_25830[(7)]);
var inst_25819 = (state_25830[(2)]);
var inst_25820 = fluree.db.util.async.throw_err(inst_25819);
var inst_25729 = inst_25820;
var inst_25730 = inst_25802;
var inst_25731 = inst_25801;
var state_25830__$1 = (function (){var statearr_25886 = state_25830;
(statearr_25886[(27)] = inst_25731);

(statearr_25886[(43)] = inst_25730);

(statearr_25886[(11)] = inst_25729);

return statearr_25886;
})();
var statearr_25887_26012 = state_25830__$1;
(statearr_25887_26012[(2)] = null);

(statearr_25887_26012[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (36))){
var inst_25618 = (state_25830[(53)]);
var inst_25681 = (state_25830[(2)]);
var state_25830__$1 = (function (){var statearr_25888 = state_25830;
(statearr_25888[(42)] = inst_25681);

return statearr_25888;
})();
if(cljs.core.truth_(inst_25618)){
var statearr_25889_26013 = state_25830__$1;
(statearr_25889_26013[(1)] = (40));

} else {
var statearr_25890_26014 = state_25830__$1;
(statearr_25890_26014[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (41))){
var inst_25684 = (cljs.core._LT__EQ_ === end_test);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25684)){
var statearr_25891_26015 = state_25830__$1;
(statearr_25891_26015[(1)] = (43));

} else {
var statearr_25892_26016 = state_25830__$1;
(statearr_25892_26016[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (89))){
var inst_25823 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25893_26017 = state_25830__$1;
(statearr_25893_26017[(2)] = inst_25823);

(statearr_25893_26017[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (43))){
var state_25830__$1 = state_25830;
var statearr_25894_26018 = state_25830__$1;
(statearr_25894_26018[(2)] = (2147483647));

(statearr_25894_26018[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (61))){
var inst_25737 = (state_25830[(18)]);
var state_25830__$1 = state_25830;
var statearr_25895_26019 = state_25830__$1;
(statearr_25895_26019[(2)] = inst_25737);

(statearr_25895_26019[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (29))){
var inst_25664 = (state_25830[(46)]);
var state_25830__$1 = state_25830;
var statearr_25896_26020 = state_25830__$1;
(statearr_25896_26020[(2)] = inst_25664);

(statearr_25896_26020[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (44))){
var state_25830__$1 = state_25830;
var statearr_25897_26021 = state_25830__$1;
(statearr_25897_26021[(2)] = fluree.db.util.core.min_integer);

(statearr_25897_26021[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (6))){
var inst_25606 = (state_25830[(14)]);
var inst_25621 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25606);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(9),inst_25621);
} else {
if((state_val_25831 === (28))){
var inst_25654 = (state_25830[(21)]);
var state_25830__$1 = state_25830;
var statearr_25898_26022 = state_25830__$1;
(statearr_25898_26022[(2)] = inst_25654);

(statearr_25898_26022[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (64))){
var inst_25744 = (state_25830[(12)]);
var inst_25730 = (state_25830[(43)]);
var inst_25758 = cljs.core.seq(inst_25744);
var inst_25759 = cljs.core.first(inst_25758);
var inst_25760 = cljs.core.next(inst_25758);
var inst_25761 = inst_25744;
var inst_25762 = inst_25730;
var inst_25763 = inst_25744;
var state_25830__$1 = (function (){var statearr_25899 = state_25830;
(statearr_25899[(55)] = inst_25761);

(statearr_25899[(22)] = inst_25762);

(statearr_25899[(56)] = inst_25759);

(statearr_25899[(57)] = inst_25760);

(statearr_25899[(52)] = inst_25763);

return statearr_25899;
})();
var statearr_25900_26023 = state_25830__$1;
(statearr_25900_26023[(2)] = null);

(statearr_25900_26023[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (51))){
var inst_25708 = (state_25830[(2)]);
var inst_25709 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_25710 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_25830__$1 = (function (){var statearr_25901 = state_25830;
(statearr_25901[(31)] = inst_25709);

(statearr_25901[(33)] = inst_25708);

return statearr_25901;
})();
if(cljs.core.truth_(inst_25710)){
var statearr_25902_26024 = state_25830__$1;
(statearr_25902_26024[(1)] = (52));

} else {
var statearr_25903_26025 = state_25830__$1;
(statearr_25903_26025[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (25))){
var state_25830__$1 = state_25830;
var statearr_25904_26026 = state_25830__$1;
(statearr_25904_26026[(2)] = (-1));

(statearr_25904_26026[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (34))){
var inst_25611 = (state_25830[(54)]);
var state_25830__$1 = state_25830;
var statearr_25905_26027 = state_25830__$1;
(statearr_25905_26027[(2)] = inst_25611);

(statearr_25905_26027[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (17))){
var inst_25641 = (state_25830[(2)]);
var inst_25642 = fluree.db.util.async.throw_err(inst_25641);
var state_25830__$1 = state_25830;
var statearr_25906_26028 = state_25830__$1;
(statearr_25906_26028[(2)] = inst_25642);

(statearr_25906_26028[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (3))){
var inst_25828 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.return_chan(state_25830__$1,inst_25828);
} else {
if((state_val_25831 === (12))){
var inst_25608 = (state_25830[(50)]);
var inst_25636 = (state_25830[(2)]);
var inst_25637 = fluree.db.util.core.pred_ident_QMARK_(inst_25608);
var state_25830__$1 = (function (){var statearr_25907 = state_25830;
(statearr_25907[(45)] = inst_25636);

return statearr_25907;
})();
if(inst_25637){
var statearr_25908_26029 = state_25830__$1;
(statearr_25908_26029[(1)] = (14));

} else {
var statearr_25909_26030 = state_25830__$1;
(statearr_25909_26030[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (2))){
var inst_25612 = (state_25830[(26)]);
var inst_25605 = (state_25830[(36)]);
var inst_25606 = (state_25830[(14)]);
var _ = (function (){var statearr_25910 = state_25830;
(statearr_25910[(4)] = cljs.core.cons((5),(state_25830[(4)])));

return statearr_25910;
})();
var inst_25605__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_25606__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(0),null);
var inst_25607 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(1),null);
var inst_25608 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(2),null);
var inst_25609 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(3),null);
var inst_25610 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(4),null);
var inst_25611 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25605__$1,(5),null);
var inst_25612__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_25613 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(0),null);
var inst_25614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(1),null);
var inst_25615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(2),null);
var inst_25616 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(3),null);
var inst_25617 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(4),null);
var inst_25618 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_25612__$1,(5),null);
var inst_25619 = fluree.db.util.core.pred_ident_QMARK_(inst_25606__$1);
var state_25830__$1 = (function (){var statearr_25911 = state_25830;
(statearr_25911[(24)] = inst_25609);

(statearr_25911[(25)] = inst_25616);

(statearr_25911[(26)] = inst_25612__$1);

(statearr_25911[(58)] = inst_25613);

(statearr_25911[(50)] = inst_25608);

(statearr_25911[(19)] = inst_25607);

(statearr_25911[(36)] = inst_25605__$1);

(statearr_25911[(14)] = inst_25606__$1);

(statearr_25911[(59)] = inst_25615);

(statearr_25911[(54)] = inst_25611);

(statearr_25911[(53)] = inst_25618);

(statearr_25911[(38)] = inst_25610);

(statearr_25911[(47)] = inst_25614);

(statearr_25911[(41)] = inst_25617);

return statearr_25911;
})();
if(inst_25619){
var statearr_25912_26031 = state_25830__$1;
(statearr_25912_26031[(1)] = (6));

} else {
var statearr_25913_26032 = state_25830__$1;
(statearr_25913_26032[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (66))){
var inst_25769 = (state_25830[(13)]);
var inst_25761 = (state_25830[(55)]);
var inst_25771 = (state_25830[(60)]);
var inst_25768 = cljs.core.seq(inst_25761);
var inst_25769__$1 = cljs.core.first(inst_25768);
var inst_25770 = cljs.core.next(inst_25768);
var inst_25771__$1 = (inst_25769__$1 == null);
var state_25830__$1 = (function (){var statearr_25914 = state_25830;
(statearr_25914[(13)] = inst_25769__$1);

(statearr_25914[(61)] = inst_25770);

(statearr_25914[(60)] = inst_25771__$1);

return statearr_25914;
})();
if(cljs.core.truth_(inst_25771__$1)){
var statearr_25915_26033 = state_25830__$1;
(statearr_25915_26033[(1)] = (68));

} else {
var statearr_25916_26034 = state_25830__$1;
(statearr_25916_26034[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (23))){
var inst_25655 = (state_25830[(20)]);
var state_25830__$1 = state_25830;
var statearr_25917_26035 = state_25830__$1;
(statearr_25917_26035[(2)] = inst_25655);

(statearr_25917_26035[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (47))){
var state_25830__$1 = state_25830;
var statearr_25918_26036 = state_25830__$1;
(statearr_25918_26036[(2)] = fluree.db.util.core.max_long);

(statearr_25918_26036[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (35))){
var inst_25675 = (cljs.core._GT__EQ_ === start_test);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25675)){
var statearr_25919_26037 = state_25830__$1;
(statearr_25919_26037[(1)] = (37));

} else {
var statearr_25920_26038 = state_25830__$1;
(statearr_25920_26038[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (82))){
var inst_25745 = (state_25830[(8)]);
var state_25830__$1 = state_25830;
var statearr_25921_26039 = state_25830__$1;
(statearr_25921_26039[(2)] = inst_25745);

(statearr_25921_26039[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (76))){
var inst_25780 = (state_25830[(23)]);
var inst_25770 = (state_25830[(61)]);
var inst_25794 = (state_25830[(2)]);
var inst_25761 = inst_25770;
var inst_25762 = inst_25780;
var inst_25763 = inst_25794;
var state_25830__$1 = (function (){var statearr_25922 = state_25830;
(statearr_25922[(55)] = inst_25761);

(statearr_25922[(22)] = inst_25762);

(statearr_25922[(52)] = inst_25763);

return statearr_25922;
})();
var statearr_25923_26040 = state_25830__$1;
(statearr_25923_26040[(2)] = null);

(statearr_25923_26040[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (19))){
var inst_25615 = (state_25830[(59)]);
var state_25830__$1 = state_25830;
var statearr_25924_26041 = state_25830__$1;
(statearr_25924_26041[(2)] = inst_25615);

(statearr_25924_26041[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (57))){
var inst_25709 = (state_25830[(31)]);
var inst_25719 = (state_25830[(32)]);
var inst_25708 = (state_25830[(33)]);
var inst_25729 = (state_25830[(11)]);
var inst_25733 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_25729,inst_25708,inst_25709,inst_25719);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(59),inst_25733);
} else {
if((state_val_25831 === (68))){
var inst_25771 = (state_25830[(60)]);
var state_25830__$1 = state_25830;
var statearr_25925_26042 = state_25830__$1;
(statearr_25925_26042[(2)] = inst_25771);

(statearr_25925_26042[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (11))){
var inst_25613 = (state_25830[(58)]);
var state_25830__$1 = state_25830;
var statearr_25927_26043 = state_25830__$1;
(statearr_25927_26043[(2)] = inst_25613);

(statearr_25927_26043[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (9))){
var inst_25623 = (state_25830[(2)]);
var inst_25624 = fluree.db.util.async.throw_err(inst_25623);
var state_25830__$1 = state_25830;
var statearr_25928_26044 = state_25830__$1;
(statearr_25928_26044[(2)] = inst_25624);

(statearr_25928_26044[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (5))){
var _ = (function (){var statearr_25929 = state_25830;
(statearr_25929[(4)] = cljs.core.rest((state_25830[(4)])));

return statearr_25929;
})();
var state_25830__$1 = state_25830;
var ex25926 = (state_25830__$1[(2)]);
var statearr_25930_26045 = state_25830__$1;
(statearr_25930_26045[(5)] = ex25926);


if((ex25926 instanceof Error)){
var statearr_25931_26046 = state_25830__$1;
(statearr_25931_26046[(1)] = (4));

(statearr_25931_26046[(5)] = null);

} else {
throw ex25926;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (83))){
var inst_25813 = (state_25830[(2)]);
var inst_25814 = cljs.core.not(inst_25813);
var state_25830__$1 = state_25830;
if(inst_25814){
var statearr_25932_26047 = state_25830__$1;
(statearr_25932_26047[(1)] = (87));

} else {
var statearr_25933_26048 = state_25830__$1;
(statearr_25933_26048[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (14))){
var inst_25608 = (state_25830[(50)]);
var inst_25639 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25608);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(17),inst_25639);
} else {
if((state_val_25831 === (45))){
var inst_25688 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25934_26049 = state_25830__$1;
(statearr_25934_26049[(2)] = inst_25688);

(statearr_25934_26049[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (53))){
var state_25830__$1 = state_25830;
var statearr_25935_26050 = state_25830__$1;
(statearr_25935_26050[(2)] = true);

(statearr_25935_26050[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (78))){
var inst_25763 = (state_25830[(52)]);
var state_25830__$1 = state_25830;
var statearr_25936_26051 = state_25830__$1;
(statearr_25936_26051[(2)] = inst_25763);

(statearr_25936_26051[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (26))){
var inst_25607 = (state_25830[(19)]);
var state_25830__$1 = state_25830;
var statearr_25937_26052 = state_25830__$1;
(statearr_25937_26052[(2)] = inst_25607);

(statearr_25937_26052[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (16))){
var inst_25615 = (state_25830[(59)]);
var inst_25645 = (state_25830[(2)]);
var inst_25646 = fluree.db.util.core.pred_ident_QMARK_(inst_25615);
var state_25830__$1 = (function (){var statearr_25938 = state_25830;
(statearr_25938[(40)] = inst_25645);

return statearr_25938;
})();
if(inst_25646){
var statearr_25939_26053 = state_25830__$1;
(statearr_25939_26053[(1)] = (18));

} else {
var statearr_25940_26054 = state_25830__$1;
(statearr_25940_26054[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (81))){
var inst_25692 = (state_25830[(16)]);
var inst_25745 = (state_25830[(8)]);
var inst_25805 = (state_25830[(48)]);
var inst_25702 = (state_25830[(37)]);
var inst_25804 = (inst_25702.cljs$core$IFn$_invoke$arity$2 ? inst_25702.cljs$core$IFn$_invoke$arity$2(inst_25745,inst_25692) : inst_25702.call(null,inst_25745,inst_25692));
var inst_25805__$1 = (inst_25804 < (0));
var state_25830__$1 = (function (){var statearr_25941 = state_25830;
(statearr_25941[(48)] = inst_25805__$1);

return statearr_25941;
})();
if(cljs.core.truth_(inst_25805__$1)){
var statearr_25942_26055 = state_25830__$1;
(statearr_25942_26055[(1)] = (84));

} else {
var statearr_25943_26056 = state_25830__$1;
(statearr_25943_26056[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (79))){
var inst_25769 = (state_25830[(13)]);
var inst_25763 = (state_25830[(52)]);
var inst_25789 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_25763,inst_25769);
var state_25830__$1 = state_25830;
var statearr_25944_26057 = state_25830__$1;
(statearr_25944_26057[(2)] = inst_25789);

(statearr_25944_26057[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (38))){
var state_25830__$1 = state_25830;
var statearr_25945_26058 = state_25830__$1;
(statearr_25945_26058[(2)] = (2147483647));

(statearr_25945_26058[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (87))){
var inst_25801 = (state_25830[(7)]);
var state_25830__$1 = state_25830;
var statearr_25946_26059 = state_25830__$1;
(statearr_25946_26059[(2)] = inst_25801);

(statearr_25946_26059[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (30))){
var inst_25668 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
if(cljs.core.truth_(inst_25668)){
var statearr_25947_26060 = state_25830__$1;
(statearr_25947_26060[(1)] = (31));

} else {
var statearr_25948_26061 = state_25830__$1;
(statearr_25948_26061[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (73))){
var inst_25797 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25949_26062 = state_25830__$1;
(statearr_25949_26062[(2)] = inst_25797);

(statearr_25949_26062[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (10))){
var inst_25613 = (state_25830[(58)]);
var inst_25630 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25613);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(13),inst_25630);
} else {
if((state_val_25831 === (18))){
var inst_25615 = (state_25830[(59)]);
var inst_25648 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_25615);
var state_25830__$1 = state_25830;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_25830__$1,(21),inst_25648);
} else {
if((state_val_25831 === (52))){
var inst_25663 = (state_25830[(29)]);
var inst_25698 = (state_25830[(35)]);
var inst_25627 = (state_25830[(39)]);
var inst_25672 = (state_25830[(44)]);
var inst_25636 = (state_25830[(45)]);
var inst_25712 = fluree.db.permissions_validate.no_filter_QMARK_(inst_25698,inst_25627,inst_25636,inst_25663,inst_25672);
var state_25830__$1 = state_25830;
var statearr_25950_26063 = state_25830__$1;
(statearr_25950_26063[(2)] = inst_25712);

(statearr_25950_26063[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (67))){
var inst_25799 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25951_26064 = state_25830__$1;
(statearr_25951_26064[(2)] = inst_25799);

(statearr_25951_26064[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (71))){
var inst_25731 = (state_25830[(27)]);
var inst_25763 = (state_25830[(52)]);
var inst_25778 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25763,inst_25731);
var state_25830__$1 = state_25830;
var statearr_25952_26065 = state_25830__$1;
(statearr_25952_26065[(2)] = inst_25778);

(statearr_25952_26065[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (42))){
var inst_25609 = (state_25830[(24)]);
var inst_25693 = (state_25830[(49)]);
var inst_25616 = (state_25830[(25)]);
var inst_25663 = (state_25830[(29)]);
var inst_25690 = (state_25830[(34)]);
var inst_25610 = (state_25830[(38)]);
var inst_25627 = (state_25830[(39)]);
var inst_25645 = (state_25830[(40)]);
var inst_25654 = (state_25830[(21)]);
var inst_25617 = (state_25830[(41)]);
var inst_25681 = (state_25830[(42)]);
var inst_25672 = (state_25830[(44)]);
var inst_25636 = (state_25830[(45)]);
var inst_25690__$1 = (state_25830[(2)]);
var inst_25691 = fluree.db.flake.__GT_Flake(inst_25627,inst_25663,inst_25645,inst_25609,inst_25610,inst_25681);
var inst_25692 = fluree.db.flake.__GT_Flake(inst_25636,inst_25672,inst_25654,inst_25616,inst_25617,inst_25690__$1);
var inst_25693__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_25830__$1 = (function (){var statearr_25953 = state_25830;
(statearr_25953[(49)] = inst_25693__$1);

(statearr_25953[(16)] = inst_25692);

(statearr_25953[(17)] = inst_25691);

(statearr_25953[(34)] = inst_25690__$1);

return statearr_25953;
})();
if(cljs.core.truth_(inst_25693__$1)){
var statearr_25954_26066 = state_25830__$1;
(statearr_25954_26066[(1)] = (46));

} else {
var statearr_25955_26067 = state_25830__$1;
(statearr_25955_26067[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (80))){
var inst_25791 = (state_25830[(2)]);
var state_25830__$1 = state_25830;
var statearr_25956_26068 = state_25830__$1;
(statearr_25956_26068[(2)] = inst_25791);

(statearr_25956_26068[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (37))){
var state_25830__$1 = state_25830;
var statearr_25957_26069 = state_25830__$1;
(statearr_25957_26069[(2)] = fluree.db.util.core.min_integer);

(statearr_25957_26069[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (63))){
var inst_25744 = (state_25830[(12)]);
var inst_25731 = (state_25830[(27)]);
var inst_25697 = (state_25830[(30)]);
var inst_25730 = (state_25830[(43)]);
var inst_25747 = (inst_25697 - inst_25730);
var inst_25748 = fluree.db.flake.take(inst_25747,inst_25744);
var inst_25749 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_25748,inst_25731);
var state_25830__$1 = state_25830;
var statearr_25958_26070 = state_25830__$1;
(statearr_25958_26070[(2)] = inst_25749);

(statearr_25958_26070[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (8))){
var inst_25613 = (state_25830[(58)]);
var inst_25627 = (state_25830[(2)]);
var inst_25628 = fluree.db.util.core.pred_ident_QMARK_(inst_25613);
var state_25830__$1 = (function (){var statearr_25959 = state_25830;
(statearr_25959[(39)] = inst_25627);

return statearr_25959;
})();
if(inst_25628){
var statearr_25960_26071 = state_25830__$1;
(statearr_25960_26071[(1)] = (10));

} else {
var statearr_25961_26072 = state_25830__$1;
(statearr_25961_26072[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (49))){
var inst_25703 = (state_25830[(51)]);
var state_25830__$1 = state_25830;
var statearr_25962_26073 = state_25830__$1;
(statearr_25962_26073[(2)] = inst_25703);

(statearr_25962_26073[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_25831 === (84))){
var inst_25802 = (state_25830[(9)]);
var inst_25697 = (state_25830[(30)]);
var inst_25807 = (inst_25802 < inst_25697);
var state_25830__$1 = state_25830;
var statearr_25963_26074 = state_25830__$1;
(statearr_25963_26074[(2)] = inst_25807);

(statearr_25963_26074[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10750__auto__ = null;
var fluree$db$query$range$state_machine__10750__auto____0 = (function (){
var statearr_25964 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_25964[(0)] = fluree$db$query$range$state_machine__10750__auto__);

(statearr_25964[(1)] = (1));

return statearr_25964;
});
var fluree$db$query$range$state_machine__10750__auto____1 = (function (state_25830){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_25830);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e25965){var ex__10753__auto__ = e25965;
var statearr_25966_26075 = state_25830;
(statearr_25966_26075[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_25830[(4)]))){
var statearr_25967_26076 = state_25830;
(statearr_25967_26076[(1)] = cljs.core.first((state_25830[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__26077 = state_25830;
state_25830 = G__26077;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10750__auto__ = function(state_25830){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10750__auto____1.call(this,state_25830);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10750__auto____0;
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10750__auto____1;
return fluree$db$query$range$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_25968 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_25968[(6)] = c__10876__auto__);

return statearr_25968;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_26152){
var state_val_26153 = (state_26152[(1)]);
if((state_val_26153 === (7))){
var inst_26147 = (state_26152[(2)]);
var _ = (function (){var statearr_26154 = state_26152;
(statearr_26154[(4)] = cljs.core.rest((state_26152[(4)])));

return statearr_26154;
})();
var state_26152__$1 = state_26152;
var statearr_26155_26195 = state_26152__$1;
(statearr_26155_26195[(2)] = inst_26147);

(statearr_26155_26195[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (20))){
var inst_26129 = (state_26152[(2)]);
var inst_26130 = fluree.db.util.async.throw_err(inst_26129);
var state_26152__$1 = state_26152;
var statearr_26156_26196 = state_26152__$1;
(statearr_26156_26196[(2)] = inst_26130);

(statearr_26156_26196[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (1))){
var state_26152__$1 = state_26152;
var statearr_26157_26197 = state_26152__$1;
(statearr_26157_26197[(2)] = null);

(statearr_26157_26197[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (4))){
var inst_26078 = (state_26152[(2)]);
var state_26152__$1 = state_26152;
var statearr_26158_26198 = state_26152__$1;
(statearr_26158_26198[(2)] = inst_26078);

(statearr_26158_26198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (15))){
var inst_26125 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_26152__$1 = state_26152;
if(cljs.core.truth_(inst_26125)){
var statearr_26159_26199 = state_26152__$1;
(statearr_26159_26199[(1)] = (17));

} else {
var statearr_26160_26200 = state_26152__$1;
(statearr_26160_26200[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (21))){
var state_26152__$1 = state_26152;
var statearr_26161_26201 = state_26152__$1;
(statearr_26161_26201[(2)] = (0));

(statearr_26161_26201[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (13))){
var inst_26117 = (state_26152[(2)]);
var state_26152__$1 = state_26152;
var statearr_26162_26202 = state_26152__$1;
(statearr_26162_26202[(2)] = inst_26117);

(statearr_26162_26202[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (22))){
var state_26152__$1 = state_26152;
var statearr_26163_26203 = state_26152__$1;
(statearr_26163_26203[(2)] = (1));

(statearr_26163_26203[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (6))){
var inst_26098 = (state_26152[(7)]);
var inst_26107 = (state_26152[(8)]);
var inst_26109 = (state_26152[(9)]);
var inst_26106 = cljs.core.seq(inst_26098);
var inst_26107__$1 = cljs.core.first(inst_26106);
var inst_26108 = cljs.core.next(inst_26106);
var inst_26109__$1 = (inst_26107__$1 == null);
var state_26152__$1 = (function (){var statearr_26164 = state_26152;
(statearr_26164[(8)] = inst_26107__$1);

(statearr_26164[(9)] = inst_26109__$1);

(statearr_26164[(10)] = inst_26108);

return statearr_26164;
})();
if(cljs.core.truth_(inst_26109__$1)){
var statearr_26165_26204 = state_26152__$1;
(statearr_26165_26204[(1)] = (8));

} else {
var statearr_26166_26205 = state_26152__$1;
(statearr_26166_26205[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (17))){
var inst_26107 = (state_26152[(8)]);
var inst_26127 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_26107);
var state_26152__$1 = state_26152;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26152__$1,(20),inst_26127);
} else {
if((state_val_26153 === (3))){
var inst_26150 = (state_26152[(2)]);
var state_26152__$1 = state_26152;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26152__$1,inst_26150);
} else {
if((state_val_26153 === (12))){
var inst_26100 = (state_26152[(11)]);
var inst_26115 = (inst_26100 >= subject_limit);
var state_26152__$1 = state_26152;
var statearr_26167_26206 = state_26152__$1;
(statearr_26167_26206[(2)] = inst_26115);

(statearr_26167_26206[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (2))){
var _ = (function (){var statearr_26168 = state_26152;
(statearr_26168[(4)] = cljs.core.cons((5),(state_26152[(4)])));

return statearr_26168;
})();
var inst_26091 = subject_groups;
var inst_26092 = cljs.core.seq(inst_26091);
var inst_26093 = cljs.core.first(inst_26092);
var inst_26094 = cljs.core.next(inst_26092);
var inst_26095 = flake_start;
var inst_26096 = subject_start;
var inst_26097 = cljs.core.PersistentVector.EMPTY;
var inst_26098 = inst_26091;
var inst_26099 = inst_26095;
var inst_26100 = inst_26096;
var inst_26101 = inst_26097;
var state_26152__$1 = (function (){var statearr_26169 = state_26152;
(statearr_26169[(7)] = inst_26098);

(statearr_26169[(12)] = inst_26101);

(statearr_26169[(13)] = inst_26094);

(statearr_26169[(14)] = inst_26099);

(statearr_26169[(15)] = inst_26093);

(statearr_26169[(11)] = inst_26100);

return statearr_26169;
})();
var statearr_26170_26207 = state_26152__$1;
(statearr_26170_26207[(2)] = null);

(statearr_26170_26207[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (23))){
var inst_26101 = (state_26152[(12)]);
var inst_26133 = (state_26152[(16)]);
var inst_26099 = (state_26152[(14)]);
var inst_26100 = (state_26152[(11)]);
var inst_26134 = (state_26152[(17)]);
var inst_26108 = (state_26152[(10)]);
var inst_26139 = (state_26152[(2)]);
var inst_26140 = (inst_26099 + inst_26134);
var inst_26141 = (inst_26100 + inst_26139);
var inst_26142 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26101,inst_26133);
var inst_26098 = inst_26108;
var inst_26099__$1 = inst_26140;
var inst_26100__$1 = inst_26141;
var inst_26101__$1 = inst_26142;
var state_26152__$1 = (function (){var statearr_26171 = state_26152;
(statearr_26171[(7)] = inst_26098);

(statearr_26171[(12)] = inst_26101__$1);

(statearr_26171[(14)] = inst_26099__$1);

(statearr_26171[(11)] = inst_26100__$1);

return statearr_26171;
})();
var statearr_26172_26208 = state_26152__$1;
(statearr_26172_26208[(2)] = null);

(statearr_26172_26208[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (19))){
var inst_26133 = (state_26152[(16)]);
var inst_26134 = (state_26152[(17)]);
var inst_26133__$1 = (state_26152[(2)]);
var inst_26134__$1 = cljs.core.count(inst_26133__$1);
var inst_26135 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_26134__$1);
var state_26152__$1 = (function (){var statearr_26173 = state_26152;
(statearr_26173[(16)] = inst_26133__$1);

(statearr_26173[(17)] = inst_26134__$1);

return statearr_26173;
})();
if(inst_26135){
var statearr_26174_26209 = state_26152__$1;
(statearr_26174_26209[(1)] = (21));

} else {
var statearr_26175_26210 = state_26152__$1;
(statearr_26175_26210[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (11))){
var inst_26112 = (state_26152[(18)]);
var state_26152__$1 = state_26152;
var statearr_26177_26211 = state_26152__$1;
(statearr_26177_26211[(2)] = inst_26112);

(statearr_26177_26211[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (9))){
var inst_26099 = (state_26152[(14)]);
var inst_26112 = (state_26152[(18)]);
var inst_26112__$1 = (inst_26099 >= flake_limit);
var state_26152__$1 = (function (){var statearr_26178 = state_26152;
(statearr_26178[(18)] = inst_26112__$1);

return statearr_26178;
})();
if(cljs.core.truth_(inst_26112__$1)){
var statearr_26179_26212 = state_26152__$1;
(statearr_26179_26212[(1)] = (11));

} else {
var statearr_26180_26213 = state_26152__$1;
(statearr_26180_26213[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (5))){
var _ = (function (){var statearr_26181 = state_26152;
(statearr_26181[(4)] = cljs.core.rest((state_26152[(4)])));

return statearr_26181;
})();
var state_26152__$1 = state_26152;
var ex26176 = (state_26152__$1[(2)]);
var statearr_26182_26214 = state_26152__$1;
(statearr_26182_26214[(5)] = ex26176);


if((ex26176 instanceof Error)){
var statearr_26183_26215 = state_26152__$1;
(statearr_26183_26215[(1)] = (4));

(statearr_26183_26215[(5)] = null);

} else {
throw ex26176;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (14))){
var inst_26101 = (state_26152[(12)]);
var inst_26099 = (state_26152[(14)]);
var inst_26100 = (state_26152[(11)]);
var inst_26121 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26122 = [inst_26099,inst_26100,inst_26101];
var inst_26123 = (new cljs.core.PersistentVector(null,3,(5),inst_26121,inst_26122,null));
var state_26152__$1 = state_26152;
var statearr_26184_26216 = state_26152__$1;
(statearr_26184_26216[(2)] = inst_26123);

(statearr_26184_26216[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (16))){
var inst_26145 = (state_26152[(2)]);
var state_26152__$1 = state_26152;
var statearr_26185_26217 = state_26152__$1;
(statearr_26185_26217[(2)] = inst_26145);

(statearr_26185_26217[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (10))){
var inst_26119 = (state_26152[(2)]);
var state_26152__$1 = state_26152;
if(cljs.core.truth_(inst_26119)){
var statearr_26186_26218 = state_26152__$1;
(statearr_26186_26218[(1)] = (14));

} else {
var statearr_26187_26219 = state_26152__$1;
(statearr_26187_26219[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (18))){
var inst_26107 = (state_26152[(8)]);
var state_26152__$1 = state_26152;
var statearr_26188_26220 = state_26152__$1;
(statearr_26188_26220[(2)] = inst_26107);

(statearr_26188_26220[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26153 === (8))){
var inst_26109 = (state_26152[(9)]);
var state_26152__$1 = state_26152;
var statearr_26189_26221 = state_26152__$1;
(statearr_26189_26221[(2)] = inst_26109);

(statearr_26189_26221[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____0 = (function (){
var statearr_26190 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26190[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__);

(statearr_26190[(1)] = (1));

return statearr_26190;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____1 = (function (state_26152){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_26152);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e26191){var ex__10753__auto__ = e26191;
var statearr_26192_26222 = state_26152;
(statearr_26192_26222[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_26152[(4)]))){
var statearr_26193_26223 = state_26152;
(statearr_26193_26223[(1)] = cljs.core.first((state_26152[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__26224 = state_26152;
state_26152 = G__26224;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__ = function(state_26152){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____1.call(this,state_26152);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_26194 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_26194[(6)] = c__10876__auto__);

return statearr_26194;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_26270){
var state_val_26271 = (state_26270[(1)]);
if((state_val_26271 === (7))){
var state_26270__$1 = state_26270;
var statearr_26272_26310 = state_26270__$1;
(statearr_26272_26310[(2)] = null);

(statearr_26272_26310[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (20))){
var inst_26256 = (state_26270[(2)]);
var inst_26257 = fluree.db.util.async.throw_err(inst_26256);
var inst_26235 = inst_26257;
var state_26270__$1 = (function (){var statearr_26273 = state_26270;
(statearr_26273[(7)] = inst_26235);

return statearr_26273;
})();
var statearr_26274_26311 = state_26270__$1;
(statearr_26274_26311[(2)] = null);

(statearr_26274_26311[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (1))){
var state_26270__$1 = state_26270;
var statearr_26275_26312 = state_26270__$1;
(statearr_26275_26312[(2)] = null);

(statearr_26275_26312[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (4))){
var inst_26225 = (state_26270[(2)]);
var state_26270__$1 = state_26270;
var statearr_26276_26313 = state_26270__$1;
(statearr_26276_26313[(2)] = inst_26225);

(statearr_26276_26313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (15))){
var inst_26252 = (state_26270[(8)]);
var inst_26235 = (state_26270[(7)]);
var inst_26252__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_26235);
var state_26270__$1 = (function (){var statearr_26277 = state_26270;
(statearr_26277[(8)] = inst_26252__$1);

return statearr_26277;
})();
if(cljs.core.truth_(inst_26252__$1)){
var statearr_26278_26314 = state_26270__$1;
(statearr_26278_26314[(1)] = (17));

} else {
var statearr_26279_26315 = state_26270__$1;
(statearr_26279_26315[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (13))){
var inst_26245 = (state_26270[(2)]);
var inst_26246 = fluree.db.util.async.throw_err(inst_26245);
var _ = (function (){var statearr_26280 = state_26270;
(statearr_26280[(4)] = cljs.core.rest((state_26270[(4)])));

return statearr_26280;
})();
var state_26270__$1 = state_26270;
var statearr_26281_26316 = state_26270__$1;
(statearr_26281_26316[(2)] = inst_26246);

(statearr_26281_26316[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (6))){
var inst_26233 = (state_26270[(2)]);
var inst_26234 = fluree.db.util.async.throw_err(inst_26233);
var inst_26235 = inst_26234;
var state_26270__$1 = (function (){var statearr_26282 = state_26270;
(statearr_26282[(7)] = inst_26235);

return statearr_26282;
})();
var statearr_26283_26317 = state_26270__$1;
(statearr_26283_26317[(2)] = null);

(statearr_26283_26317[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (17))){
var inst_26252 = (state_26270[(8)]);
var inst_26254 = fluree.db.dbproto._lookup_leaf(root_node,inst_26252);
var state_26270__$1 = state_26270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26270__$1,(20),inst_26254);
} else {
if((state_val_26271 === (3))){
var inst_26268 = (state_26270[(2)]);
var state_26270__$1 = state_26270;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26270__$1,inst_26268);
} else {
if((state_val_26271 === (12))){
var _ = (function (){var statearr_26285 = state_26270;
(statearr_26285[(4)] = cljs.core.rest((state_26270[(4)])));

return statearr_26285;
})();
var state_26270__$1 = state_26270;
var ex26284 = (state_26270__$1[(2)]);
var statearr_26286_26318 = state_26270__$1;
(statearr_26286_26318[(5)] = ex26284);


var statearr_26287_26319 = state_26270__$1;
(statearr_26287_26319[(1)] = (11));

(statearr_26287_26319[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (2))){
var _ = (function (){var statearr_26288 = state_26270;
(statearr_26288[(4)] = cljs.core.cons((5),(state_26270[(4)])));

return statearr_26288;
})();
var inst_26231 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_26270__$1 = state_26270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26270__$1,(6),inst_26231);
} else {
if((state_val_26271 === (19))){
var inst_26261 = (state_26270[(2)]);
var state_26270__$1 = state_26270;
var statearr_26289_26320 = state_26270__$1;
(statearr_26289_26320[(2)] = inst_26261);

(statearr_26289_26320[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (11))){
var inst_26237 = (state_26270[(2)]);
var state_26270__$1 = (function (){var statearr_26291 = state_26270;
(statearr_26291[(9)] = inst_26237);

return statearr_26291;
})();
var statearr_26292_26321 = state_26270__$1;
(statearr_26292_26321[(2)] = null);

(statearr_26292_26321[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (9))){
var inst_26235 = (state_26270[(7)]);
var _ = (function (){var statearr_26293 = state_26270;
(statearr_26293[(4)] = cljs.core.cons((12),(state_26270[(4)])));

return statearr_26293;
})();
var inst_26243 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_26235,t,novelty,fast_forward_db_QMARK_);
var state_26270__$1 = state_26270;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26270__$1,(13),inst_26243);
} else {
if((state_val_26271 === (5))){
var _ = (function (){var statearr_26294 = state_26270;
(statearr_26294[(4)] = cljs.core.rest((state_26270[(4)])));

return statearr_26294;
})();
var state_26270__$1 = state_26270;
var ex26290 = (state_26270__$1[(2)]);
var statearr_26295_26322 = state_26270__$1;
(statearr_26295_26322[(5)] = ex26290);


if((ex26290 instanceof Error)){
var statearr_26296_26323 = state_26270__$1;
(statearr_26296_26323[(1)] = (4));

(statearr_26296_26323[(5)] = null);

} else {
throw ex26290;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (14))){
var inst_26249 = (state_26270[(10)]);
var state_26270__$1 = state_26270;
var statearr_26297_26324 = state_26270__$1;
(statearr_26297_26324[(2)] = inst_26249);

(statearr_26297_26324[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (16))){
var inst_26263 = (state_26270[(2)]);
var state_26270__$1 = state_26270;
var statearr_26298_26325 = state_26270__$1;
(statearr_26298_26325[(2)] = inst_26263);

(statearr_26298_26325[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (10))){
var inst_26249 = (state_26270[(10)]);
var inst_26249__$1 = (state_26270[(2)]);
var state_26270__$1 = (function (){var statearr_26299 = state_26270;
(statearr_26299[(10)] = inst_26249__$1);

return statearr_26299;
})();
if(cljs.core.truth_(inst_26249__$1)){
var statearr_26300_26326 = state_26270__$1;
(statearr_26300_26326[(1)] = (14));

} else {
var statearr_26301_26327 = state_26270__$1;
(statearr_26301_26327[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (18))){
var state_26270__$1 = state_26270;
var statearr_26302_26328 = state_26270__$1;
(statearr_26302_26328[(2)] = null);

(statearr_26302_26328[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26271 === (8))){
var inst_26265 = (state_26270[(2)]);
var _ = (function (){var statearr_26303 = state_26270;
(statearr_26303[(4)] = cljs.core.rest((state_26270[(4)])));

return statearr_26303;
})();
var state_26270__$1 = state_26270;
var statearr_26304_26329 = state_26270__$1;
(statearr_26304_26329[(2)] = inst_26265);

(statearr_26304_26329[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____0 = (function (){
var statearr_26305 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_26305[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__);

(statearr_26305[(1)] = (1));

return statearr_26305;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____1 = (function (state_26270){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_26270);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e26306){var ex__10753__auto__ = e26306;
var statearr_26307_26330 = state_26270;
(statearr_26307_26330[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_26270[(4)]))){
var statearr_26308_26331 = state_26270;
(statearr_26308_26331[(1)] = cljs.core.first((state_26270[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__26332 = state_26270;
state_26270 = G__26332;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__ = function(state_26270){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____1.call(this,state_26270);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_26309 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_26309[(6)] = c__10876__auto__);

return statearr_26309;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__26339 = arguments.length;
switch (G__26339) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__26340 = (function (){var pred__26343 = cljs.core.identical_QMARK_;
var expr__26344 = test;
if(cljs.core.truth_((pred__26343.cljs$core$IFn$_invoke$arity$2 ? pred__26343.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__26344) : pred__26343.call(null,cljs.core._EQ_,expr__26344)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__26343.cljs$core$IFn$_invoke$arity$2 ? pred__26343.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__26344) : pred__26343.call(null,cljs.core._LT_,expr__26344)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__26343.cljs$core$IFn$_invoke$arity$2 ? pred__26343.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__26344) : pred__26343.call(null,cljs.core._LT__EQ_,expr__26344)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__26343.cljs$core$IFn$_invoke$arity$2 ? pred__26343.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__26344) : pred__26343.call(null,cljs.core._GT_,expr__26344)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__26343.cljs$core$IFn$_invoke$arity$2 ? pred__26343.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__26344) : pred__26343.call(null,cljs.core._GT__EQ_,expr__26344)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__26344)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26340,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26340,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26340,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__26340,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_26716){
var state_val_26717 = (state_26716[(1)]);
if((state_val_26717 === (121))){
var inst_26672 = (state_26716[(7)]);
var state_26716__$1 = state_26716;
var statearr_26718_26914 = state_26716__$1;
(statearr_26718_26914[(2)] = inst_26672);

(statearr_26718_26914[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (65))){
var inst_26524 = (state_26716[(8)]);
var inst_26530 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26719 = state_26716;
(statearr_26719[(9)] = inst_26530);

return statearr_26719;
})();
if(cljs.core.truth_(inst_26524)){
var statearr_26720_26915 = state_26716__$1;
(statearr_26720_26915[(1)] = (66));

} else {
var statearr_26721_26916 = state_26716__$1;
(statearr_26721_26916[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (70))){
var inst_26708 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26722_26917 = state_26716__$1;
(statearr_26722_26917[(2)] = inst_26708);

(statearr_26722_26917[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (62))){
var inst_26523 = (state_26716[(2)]);
var inst_26524 = fluree.db.util.async.throw_err(inst_26523);
var inst_26525 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_26716__$1 = (function (){var statearr_26723 = state_26716;
(statearr_26723[(8)] = inst_26524);

return statearr_26723;
})();
if(cljs.core.truth_(inst_26525)){
var statearr_26724_26918 = state_26716__$1;
(statearr_26724_26918[(1)] = (63));

} else {
var statearr_26725_26919 = state_26716__$1;
(statearr_26725_26919[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (74))){
var inst_26496 = (state_26716[(10)]);
var inst_26503 = (state_26716[(11)]);
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26504 = (state_26716[(14)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26551 = (state_26716[(17)]);
var inst_26378 = (state_26716[(18)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26366 = (state_26716[(21)]);
var inst_26533 = (state_26716[(22)]);
var inst_26543 = (state_26716[(23)]);
var inst_26438 = (state_26716[(24)]);
var inst_26373 = (state_26716[(25)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26483 = (state_26716[(28)]);
var inst_26382 = (state_26716[(29)]);
var inst_26497 = (state_26716[(30)]);
var inst_26534 = (state_26716[(31)]);
var inst_26505 = (state_26716[(32)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26530 = (state_26716[(9)]);
var inst_26434 = (state_26716[(35)]);
var inst_26535 = (state_26716[(36)]);
var inst_26381 = (state_26716[(37)]);
var inst_26509 = (state_26716[(38)]);
var inst_26524 = (state_26716[(8)]);
var inst_26494 = (state_26716[(39)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26435 = (state_26716[(45)]);
var inst_26520 = (state_26716[(46)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26553 = (function (){var no_filter_QMARK_ = inst_26530;
var t = inst_26510;
var max_limit_QMARK_ = inst_26504;
var next_node = inst_26533;
var fast_forward_db_QMARK_ = inst_26515;
var s1 = inst_26393;
var o2 = inst_26456;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var i = inst_26535;
var m1 = inst_26483;
var root_node = inst_26520;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26474;
var vec__26359 = inst_26434;
var permissions = inst_26505;
var limit = inst_26503;
var start_flake = inst_26493;
var flake_limit = inst_26497;
var offset = inst_26534;
var map__26365 = inst_26496;
var acc = inst_26537;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26447;
var vec__26355 = inst_26373;
var end_flake = inst_26494;
var base_result = inst_26543;
var s = inst_26536;
var node_start = inst_26524;
var p1 = inst_26465;
var subject_fn = inst_26382;
var G__26544 = inst_26551;
var object_fn = inst_26438;
var idx_compare = inst_26509;
var vec__26362 = inst_26435;
var op2 = inst_26378;
var m2 = inst_26492;
var novelty = inst_26514;
return (function (p1__26334_SHARP_){
var G__26726 = p1__26334_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__26726) : subject_fn.call(null,G__26726));
});
})();
var inst_26554 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26553,inst_26551);
var state_26716__$1 = state_26716;
var statearr_26727_26920 = state_26716__$1;
(statearr_26727_26920[(2)] = inst_26554);

(statearr_26727_26920[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (110))){
var inst_26685 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26728_26921 = state_26716__$1;
(statearr_26728_26921[(2)] = inst_26685);

(statearr_26728_26921[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (7))){
var inst_26367 = (state_26716[(49)]);
var state_26716__$1 = state_26716;
var statearr_26729_26922 = state_26716__$1;
(statearr_26729_26922[(2)] = inst_26367);

(statearr_26729_26922[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (59))){
var state_26716__$1 = state_26716;
var statearr_26730_26923 = state_26716__$1;
(statearr_26730_26923[(2)] = fluree.db.util.core.max_long);

(statearr_26730_26923[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (86))){
var inst_26530 = (state_26716[(9)]);
var state_26716__$1 = state_26716;
var statearr_26731_26924 = state_26716__$1;
(statearr_26731_26924[(2)] = inst_26530);

(statearr_26731_26924[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (20))){
var state_26716__$1 = state_26716;
var statearr_26732_26925 = state_26716__$1;
(statearr_26732_26925[(2)] = null);

(statearr_26732_26925[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (72))){
var inst_26543 = (state_26716[(23)]);
var state_26716__$1 = state_26716;
var statearr_26733_26926 = state_26716__$1;
(statearr_26733_26926[(2)] = inst_26543);

(statearr_26733_26926[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (58))){
var inst_26498 = (state_26716[(50)]);
var state_26716__$1 = state_26716;
var statearr_26734_26927 = state_26716__$1;
(statearr_26734_26927[(2)] = inst_26498);

(statearr_26734_26927[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (60))){
var inst_26503 = (state_26716[(11)]);
var inst_26503__$1 = (state_26716[(2)]);
var inst_26504 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_26503__$1,fluree.db.util.core.max_long);
var inst_26505 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_26506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26507 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_26508 = (new cljs.core.PersistentVector(null,3,(5),inst_26506,inst_26507,null));
var inst_26509 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26508);
var inst_26510 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_26511 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26512 = [cljs.core.cst$kw$novelty,idx];
var inst_26513 = (new cljs.core.PersistentVector(null,2,(5),inst_26511,inst_26512,null));
var inst_26514 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_26513);
var inst_26515 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_26516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_26517 = fluree.db.dbproto._resolve(inst_26516);
var state_26716__$1 = (function (){var statearr_26735 = state_26716;
(statearr_26735[(11)] = inst_26503__$1);

(statearr_26735[(12)] = inst_26515);

(statearr_26735[(14)] = inst_26504);

(statearr_26735[(19)] = inst_26510);

(statearr_26735[(20)] = inst_26514);

(statearr_26735[(32)] = inst_26505);

(statearr_26735[(38)] = inst_26509);

return statearr_26735;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(61),inst_26517);
} else {
if((state_val_26717 === (27))){
var inst_26436 = (state_26716[(51)]);
var state_26716__$1 = state_26716;
var statearr_26736_26928 = state_26716__$1;
(statearr_26736_26928[(2)] = inst_26436);

(statearr_26736_26928[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (1))){
var state_26716__$1 = state_26716;
var statearr_26737_26929 = state_26716__$1;
(statearr_26737_26929[(2)] = null);

(statearr_26737_26929[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (69))){
var inst_26493 = (state_26716[(13)]);
var inst_26533 = (state_26716[(22)]);
var inst_26494 = (state_26716[(39)]);
var inst_26542 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_26533);
var inst_26543 = fluree.db.flake.subrange(inst_26542,start_test,inst_26493,end_test,inst_26494);
var inst_26545 = fluree.db.query.range.value_with_nil_pred(idx,inst_26493,inst_26494);
var state_26716__$1 = (function (){var statearr_26738 = state_26716;
(statearr_26738[(23)] = inst_26543);

return statearr_26738;
})();
if(inst_26545){
var statearr_26739_26930 = state_26716__$1;
(statearr_26739_26930[(1)] = (71));

} else {
var statearr_26740_26931 = state_26716__$1;
(statearr_26740_26931[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (101))){
var inst_26497 = (state_26716[(30)]);
var inst_26630 = (state_26716[(52)]);
var inst_26629 = (state_26716[(53)]);
var inst_26631 = (state_26716[(54)]);
var inst_26634 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26635 = (inst_26631 - inst_26497);
var inst_26636 = (inst_26630 - inst_26635);
var inst_26637 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26636,inst_26629);
var inst_26638 = [inst_26497,inst_26637];
var inst_26639 = (new cljs.core.PersistentVector(null,2,(5),inst_26634,inst_26638,null));
var state_26716__$1 = state_26716;
var statearr_26741_26932 = state_26716__$1;
(statearr_26741_26932[(2)] = inst_26639);

(statearr_26741_26932[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (24))){
var inst_26379 = (state_26716[(55)]);
var inst_26378 = (state_26716[(18)]);
var inst_26384 = (state_26716[(56)]);
var inst_26366 = (state_26716[(21)]);
var inst_26373 = (state_26716[(25)]);
var inst_26368 = (state_26716[(57)]);
var inst_26382 = (state_26716[(29)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26416 = (state_26716[(58)]);
var inst_26372 = (state_26716[(59)]);
var inst_26369 = (state_26716[(60)]);
var inst_26381 = (state_26716[(37)]);
var inst_26376 = (state_26716[(61)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26393 = (state_26716[(44)]);
var inst_26375 = (state_26716[(62)]);
var inst_26426 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26427 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26428 = [null,null];
var inst_26429 = (new cljs.core.PersistentVector(null,2,(5),inst_26427,inst_26428,null));
var inst_26430 = (function (){var bool = inst_26416;
var s1 = inst_26393;
var o2 = inst_26376;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var m1 = inst_26372;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26375;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26369;
var vec__26355 = inst_26373;
var p1 = inst_26368;
var subject_fn = inst_26382;
var object_fn = inst_26384;
var op2 = inst_26378;
var m2 = inst_26379;
var temp__5755__auto__ = inst_26416;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_26431 = [inst_26429,inst_26430];
var inst_26432 = (new cljs.core.PersistentVector(null,2,(5),inst_26426,inst_26431,null));
var state_26716__$1 = state_26716;
var statearr_26742_26933 = state_26716__$1;
(statearr_26742_26933[(2)] = inst_26432);

(statearr_26742_26933[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (102))){
var inst_26629 = (state_26716[(53)]);
var inst_26631 = (state_26716[(54)]);
var inst_26641 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26642 = [inst_26631,inst_26629];
var inst_26643 = (new cljs.core.PersistentVector(null,2,(5),inst_26641,inst_26642,null));
var state_26716__$1 = state_26716;
var statearr_26743_26934 = state_26716__$1;
(statearr_26743_26934[(2)] = inst_26643);

(statearr_26743_26934[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (55))){
var state_26716__$1 = state_26716;
var statearr_26744_26935 = state_26716__$1;
(statearr_26744_26935[(2)] = (2147483647));

(statearr_26744_26935[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (85))){
var inst_26579 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
if(cljs.core.truth_(inst_26579)){
var statearr_26745_26936 = state_26716__$1;
(statearr_26745_26936[(1)] = (89));

} else {
var statearr_26746_26937 = state_26716__$1;
(statearr_26746_26937[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (39))){
var inst_26466 = (state_26716[(63)]);
var inst_26375 = (state_26716[(62)]);
var inst_26465 = (state_26716[(2)]);
var inst_26466__$1 = (inst_26375 == null);
var state_26716__$1 = (function (){var statearr_26747 = state_26716;
(statearr_26747[(63)] = inst_26466__$1);

(statearr_26747[(47)] = inst_26465);

return statearr_26747;
})();
if(cljs.core.truth_(inst_26466__$1)){
var statearr_26748_26938 = state_26716__$1;
(statearr_26748_26938[(1)] = (40));

} else {
var statearr_26749_26939 = state_26716__$1;
(statearr_26749_26939[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (88))){
var inst_26576 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26750_26940 = state_26716__$1;
(statearr_26750_26940[(2)] = inst_26576);

(statearr_26750_26940[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (46))){
var inst_26372 = (state_26716[(59)]);
var state_26716__$1 = state_26716;
var statearr_26751_26941 = state_26716__$1;
(statearr_26751_26941[(2)] = inst_26372);

(statearr_26751_26941[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (4))){
var inst_26346 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26752_26942 = state_26716__$1;
(statearr_26752_26942[(2)] = inst_26346);

(statearr_26752_26942[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (77))){
var inst_26496 = (state_26716[(10)]);
var inst_26503 = (state_26716[(11)]);
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26504 = (state_26716[(14)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26378 = (state_26716[(18)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26366 = (state_26716[(21)]);
var inst_26533 = (state_26716[(22)]);
var inst_26543 = (state_26716[(23)]);
var inst_26438 = (state_26716[(24)]);
var inst_26373 = (state_26716[(25)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26483 = (state_26716[(28)]);
var inst_26382 = (state_26716[(29)]);
var inst_26497 = (state_26716[(30)]);
var inst_26534 = (state_26716[(31)]);
var inst_26505 = (state_26716[(32)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26530 = (state_26716[(9)]);
var inst_26434 = (state_26716[(35)]);
var inst_26535 = (state_26716[(36)]);
var inst_26381 = (state_26716[(37)]);
var inst_26509 = (state_26716[(38)]);
var inst_26557 = (state_26716[(64)]);
var inst_26524 = (state_26716[(8)]);
var inst_26494 = (state_26716[(39)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26435 = (state_26716[(45)]);
var inst_26520 = (state_26716[(46)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26559 = (function (){var no_filter_QMARK_ = inst_26530;
var t = inst_26510;
var max_limit_QMARK_ = inst_26504;
var next_node = inst_26533;
var fast_forward_db_QMARK_ = inst_26515;
var s1 = inst_26393;
var o2 = inst_26456;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var i = inst_26535;
var m1 = inst_26483;
var root_node = inst_26520;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26474;
var vec__26359 = inst_26434;
var permissions = inst_26505;
var limit = inst_26503;
var start_flake = inst_26493;
var flake_limit = inst_26497;
var offset = inst_26534;
var map__26365 = inst_26496;
var acc = inst_26537;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26447;
var vec__26355 = inst_26373;
var end_flake = inst_26494;
var base_result = inst_26543;
var s = inst_26536;
var node_start = inst_26524;
var p1 = inst_26465;
var subject_fn = inst_26382;
var G__26544 = inst_26557;
var object_fn = inst_26438;
var idx_compare = inst_26509;
var vec__26362 = inst_26435;
var op2 = inst_26378;
var m2 = inst_26492;
var novelty = inst_26514;
return (function (p1__26335_SHARP_){
var G__26753 = p1__26335_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__26753) : predicate_fn.call(null,G__26753));
});
})();
var inst_26560 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26559,inst_26557);
var state_26716__$1 = state_26716;
var statearr_26754_26943 = state_26716__$1;
(statearr_26754_26943[(2)] = inst_26560);

(statearr_26754_26943[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (106))){
var inst_26570 = (state_26716[(65)]);
var state_26716__$1 = state_26716;
var statearr_26755_26944 = state_26716__$1;
(statearr_26755_26944[(2)] = inst_26570);

(statearr_26755_26944[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (119))){
var inst_26688 = (state_26716[(66)]);
var state_26716__$1 = state_26716;
var statearr_26756_26945 = state_26716__$1;
(statearr_26756_26945[(2)] = inst_26688);

(statearr_26756_26945[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (95))){
var inst_26503 = (state_26716[(11)]);
var inst_26603 = (state_26716[(67)]);
var inst_26536 = (state_26716[(26)]);
var inst_26613 = (state_26716[(68)]);
var inst_26611 = (state_26716[(69)]);
var inst_26612 = (state_26716[(70)]);
var inst_26611__$1 = cljs.core.count(inst_26603);
var inst_26612__$1 = (inst_26536 + inst_26611__$1);
var inst_26613__$1 = (inst_26612__$1 - inst_26503);
var inst_26614 = cljs.core.pos_int_QMARK_(inst_26613__$1);
var state_26716__$1 = (function (){var statearr_26757 = state_26716;
(statearr_26757[(68)] = inst_26613__$1);

(statearr_26757[(69)] = inst_26611__$1);

(statearr_26757[(70)] = inst_26612__$1);

return statearr_26757;
})();
if(inst_26614){
var statearr_26758_26946 = state_26716__$1;
(statearr_26758_26946[(1)] = (98));

} else {
var statearr_26759_26947 = state_26716__$1;
(statearr_26759_26947[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (54))){
var inst_26496 = (state_26716[(10)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26378 = (state_26716[(18)]);
var inst_26483 = (state_26716[(28)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26377 = (state_26716[(40)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26498 = (state_26716[(50)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26492__$1 = (state_26716[(2)]);
var inst_26493 = fluree.db.flake.__GT_Flake(inst_26393,inst_26465,inst_26447,inst_26370,inst_26371,inst_26483);
var inst_26494 = fluree.db.flake.__GT_Flake(inst_26402,inst_26474,inst_26456,inst_26377,inst_26378,inst_26492__$1);
var inst_26495 = opts;
var inst_26496__$1 = cljs.core.__destructure_map(inst_26495);
var inst_26497 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_26496__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_26498__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26496__$1,cljs.core.cst$kw$limit);
var inst_26499 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_26496__$1,cljs.core.cst$kw$offset,(0));
var state_26716__$1 = (function (){var statearr_26760 = state_26716;
(statearr_26760[(10)] = inst_26496__$1);

(statearr_26760[(13)] = inst_26493);

(statearr_26760[(15)] = inst_26492__$1);

(statearr_26760[(71)] = inst_26499);

(statearr_26760[(30)] = inst_26497);

(statearr_26760[(39)] = inst_26494);

(statearr_26760[(50)] = inst_26498__$1);

return statearr_26760;
})();
if(cljs.core.truth_(inst_26498__$1)){
var statearr_26761_26948 = state_26716__$1;
(statearr_26761_26948[(1)] = (58));

} else {
var statearr_26762_26949 = state_26716__$1;
(statearr_26762_26949[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (92))){
var inst_26592 = (state_26716[(72)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26534 = (state_26716[(31)]);
var inst_26535 = (state_26716[(36)]);
var inst_26595 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26596 = (inst_26534 - inst_26592);
var inst_26597 = [inst_26596,inst_26535,inst_26536,inst_26537];
var inst_26598 = (new cljs.core.PersistentVector(null,4,(5),inst_26595,inst_26597,null));
var state_26716__$1 = state_26716;
var statearr_26763_26950 = state_26716__$1;
(statearr_26763_26950[(2)] = inst_26598);

(statearr_26763_26950[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (104))){
var inst_26654 = (state_26716[(2)]);
var inst_26655 = fluree.db.util.async.throw_err(inst_26654);
var state_26716__$1 = state_26716;
var statearr_26764_26951 = state_26716__$1;
(statearr_26764_26951[(2)] = inst_26655);

(statearr_26764_26951[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (15))){
var inst_26376 = (state_26716[(61)]);
var inst_26406 = cljs.core.boolean_QMARK_(inst_26376);
var state_26716__$1 = state_26716;
if(inst_26406){
var statearr_26765_26952 = state_26716__$1;
(statearr_26765_26952[(1)] = (17));

} else {
var statearr_26766_26953 = state_26716__$1;
(statearr_26766_26953[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (48))){
var inst_26379 = (state_26716[(55)]);
var inst_26483 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26767 = state_26716;
(statearr_26767[(28)] = inst_26483);

return statearr_26767;
})();
if(cljs.core.truth_(inst_26379)){
var statearr_26768_26954 = state_26716__$1;
(statearr_26768_26954[(1)] = (52));

} else {
var statearr_26769_26955 = state_26716__$1;
(statearr_26769_26955[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (50))){
var state_26716__$1 = state_26716;
var statearr_26770_26956 = state_26716__$1;
(statearr_26770_26956[(2)] = (2147483647));

(statearr_26770_26956[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (116))){
var inst_26688 = (state_26716[(66)]);
var inst_26696 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26771 = state_26716;
(statearr_26771[(73)] = inst_26696);

return statearr_26771;
})();
if(cljs.core.truth_(inst_26688)){
var statearr_26772_26957 = state_26716__$1;
(statearr_26772_26957[(1)] = (118));

} else {
var statearr_26773_26958 = state_26716__$1;
(statearr_26773_26958[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (75))){
var inst_26551 = (state_26716[(17)]);
var state_26716__$1 = state_26716;
var statearr_26774_26959 = state_26716__$1;
(statearr_26774_26959[(2)] = inst_26551);

(statearr_26774_26959[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (99))){
var inst_26612 = (state_26716[(70)]);
var inst_26621 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26622 = [inst_26612,inst_26612];
var inst_26623 = (new cljs.core.PersistentVector(null,2,(5),inst_26621,inst_26622,null));
var state_26716__$1 = state_26716;
var statearr_26775_26960 = state_26716__$1;
(statearr_26775_26960[(2)] = inst_26623);

(statearr_26775_26960[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (21))){
var state_26716__$1 = state_26716;
var statearr_26776_26961 = state_26716__$1;
(statearr_26776_26961[(2)] = null);

(statearr_26776_26961[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (31))){
var inst_26437 = (state_26716[(74)]);
var state_26716__$1 = state_26716;
var statearr_26777_26962 = state_26716__$1;
(statearr_26777_26962[(2)] = inst_26437);

(statearr_26777_26962[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (113))){
var inst_26682 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26778_26963 = state_26716__$1;
(statearr_26778_26963[(2)] = inst_26682);

(statearr_26778_26963[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (32))){
var inst_26368 = (state_26716[(57)]);
var inst_26457 = (state_26716[(75)]);
var inst_26456 = (state_26716[(2)]);
var inst_26457__$1 = (inst_26368 == null);
var state_26716__$1 = (function (){var statearr_26779 = state_26716;
(statearr_26779[(75)] = inst_26457__$1);

(statearr_26779[(43)] = inst_26456);

return statearr_26779;
})();
if(cljs.core.truth_(inst_26457__$1)){
var statearr_26780_26964 = state_26716__$1;
(statearr_26780_26964[(1)] = (34));

} else {
var statearr_26781_26965 = state_26716__$1;
(statearr_26781_26965[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (40))){
var inst_26456 = (state_26716[(43)]);
var state_26716__$1 = state_26716;
var statearr_26782_26966 = state_26716__$1;
(statearr_26782_26966[(2)] = inst_26456);

(statearr_26782_26966[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (91))){
var inst_26570 = (state_26716[(65)]);
var inst_26668 = (state_26716[(2)]);
var inst_26669 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26668,(0),null);
var inst_26670 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26668,(1),null);
var inst_26671 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26668,(2),null);
var inst_26672 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26668,(3),null);
var state_26716__$1 = (function (){var statearr_26783 = state_26716;
(statearr_26783[(76)] = inst_26671);

(statearr_26783[(77)] = inst_26670);

(statearr_26783[(78)] = inst_26669);

(statearr_26783[(7)] = inst_26672);

return statearr_26783;
})();
if(cljs.core.truth_(inst_26570)){
var statearr_26784_26967 = state_26716__$1;
(statearr_26784_26967[(1)] = (105));

} else {
var statearr_26785_26968 = state_26716__$1;
(statearr_26785_26968[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (117))){
var inst_26692 = (state_26716[(2)]);
var inst_26693 = fluree.db.util.async.throw_err(inst_26692);
var state_26716__$1 = state_26716;
var statearr_26786_26969 = state_26716__$1;
(statearr_26786_26969[(2)] = inst_26693);

(statearr_26786_26969[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (108))){
var inst_26497 = (state_26716[(30)]);
var inst_26677 = (state_26716[(79)]);
var inst_26670 = (state_26716[(77)]);
var inst_26677__$1 = (inst_26670 < inst_26497);
var state_26716__$1 = (function (){var statearr_26787 = state_26716;
(statearr_26787[(79)] = inst_26677__$1);

return statearr_26787;
})();
if(cljs.core.truth_(inst_26677__$1)){
var statearr_26788_26970 = state_26716__$1;
(statearr_26788_26970[(1)] = (111));

} else {
var statearr_26789_26971 = state_26716__$1;
(statearr_26789_26971[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (56))){
var state_26716__$1 = state_26716;
var statearr_26790_26972 = state_26716__$1;
(statearr_26790_26972[(2)] = fluree.db.util.core.min_integer);

(statearr_26790_26972[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (33))){
var inst_26452 = (state_26716[(2)]);
var inst_26453 = fluree.db.util.async.throw_err(inst_26452);
var state_26716__$1 = state_26716;
var statearr_26791_26973 = state_26716__$1;
(statearr_26791_26973[(2)] = inst_26453);

(statearr_26791_26973[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (13))){
var inst_26398 = (state_26716[(2)]);
var inst_26399 = fluree.db.util.async.throw_err(inst_26398);
var state_26716__$1 = state_26716;
var statearr_26792_26974 = state_26716__$1;
(statearr_26792_26974[(2)] = inst_26399);

(statearr_26792_26974[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (22))){
var inst_26412 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26793_26975 = state_26716__$1;
(statearr_26793_26975[(2)] = inst_26412);

(statearr_26793_26975[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (90))){
var inst_26496 = (state_26716[(10)]);
var inst_26503 = (state_26716[(11)]);
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26504 = (state_26716[(14)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26378 = (state_26716[(18)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26366 = (state_26716[(21)]);
var inst_26569 = (state_26716[(80)]);
var inst_26533 = (state_26716[(22)]);
var inst_26543 = (state_26716[(23)]);
var inst_26592 = (state_26716[(72)]);
var inst_26438 = (state_26716[(24)]);
var inst_26373 = (state_26716[(25)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26483 = (state_26716[(28)]);
var inst_26382 = (state_26716[(29)]);
var inst_26497 = (state_26716[(30)]);
var inst_26534 = (state_26716[(31)]);
var inst_26505 = (state_26716[(32)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26530 = (state_26716[(9)]);
var inst_26434 = (state_26716[(35)]);
var inst_26535 = (state_26716[(36)]);
var inst_26381 = (state_26716[(37)]);
var inst_26591 = (state_26716[(81)]);
var inst_26509 = (state_26716[(38)]);
var inst_26524 = (state_26716[(8)]);
var inst_26494 = (state_26716[(39)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26435 = (state_26716[(45)]);
var inst_26570 = (state_26716[(65)]);
var inst_26520 = (state_26716[(46)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26590 = (function (){var no_filter_QMARK_ = inst_26530;
var base_result_SINGLEQUOTE_ = inst_26569;
var t = inst_26510;
var max_limit_QMARK_ = inst_26504;
var next_node = inst_26533;
var fast_forward_db_QMARK_ = inst_26515;
var s1 = inst_26393;
var o2 = inst_26456;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var i = inst_26535;
var rhs = inst_26570;
var m1 = inst_26483;
var root_node = inst_26520;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26474;
var vec__26359 = inst_26434;
var permissions = inst_26505;
var limit = inst_26503;
var start_flake = inst_26493;
var flake_limit = inst_26497;
var offset = inst_26534;
var map__26365 = inst_26496;
var acc = inst_26537;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26447;
var vec__26355 = inst_26373;
var end_flake = inst_26494;
var base_result = inst_26543;
var s = inst_26536;
var node_start = inst_26524;
var p1 = inst_26465;
var subject_fn = inst_26382;
var object_fn = inst_26438;
var idx_compare = inst_26509;
var vec__26362 = inst_26435;
var op2 = inst_26378;
var m2 = inst_26492;
var novelty = inst_26514;
return (function (p1__26337_SHARP_){
return p1__26337_SHARP_.s;
});
})();
var inst_26591__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_26590,inst_26569);
var inst_26592__$1 = cljs.core.count(inst_26591__$1);
var inst_26593 = (inst_26534 > inst_26592__$1);
var state_26716__$1 = (function (){var statearr_26794 = state_26716;
(statearr_26794[(72)] = inst_26592__$1);

(statearr_26794[(81)] = inst_26591__$1);

return statearr_26794;
})();
if(cljs.core.truth_(inst_26593)){
var statearr_26795_26976 = state_26716__$1;
(statearr_26795_26976[(1)] = (92));

} else {
var statearr_26796_26977 = state_26716__$1;
(statearr_26796_26977[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (109))){
var inst_26675 = (state_26716[(82)]);
var state_26716__$1 = state_26716;
var statearr_26797_26978 = state_26716__$1;
(statearr_26797_26978[(2)] = inst_26675);

(statearr_26797_26978[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (36))){
var inst_26461 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
if(cljs.core.truth_(inst_26461)){
var statearr_26798_26979 = state_26716__$1;
(statearr_26798_26979[(1)] = (37));

} else {
var statearr_26799_26980 = state_26716__$1;
(statearr_26799_26980[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (41))){
var inst_26466 = (state_26716[(63)]);
var state_26716__$1 = state_26716;
var statearr_26800_26981 = state_26716__$1;
(statearr_26800_26981[(2)] = inst_26466);

(statearr_26800_26981[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (118))){
var inst_26696 = (state_26716[(73)]);
var state_26716__$1 = state_26716;
var statearr_26801_26982 = state_26716__$1;
(statearr_26801_26982[(2)] = inst_26696);

(statearr_26801_26982[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (89))){
var inst_26569 = (state_26716[(80)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26497 = (state_26716[(30)]);
var inst_26535 = (state_26716[(36)]);
var inst_26581 = cljs.core.count(inst_26569);
var inst_26582 = (inst_26497 - inst_26535);
var inst_26583 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26582,inst_26569);
var inst_26584 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26537,inst_26583);
var inst_26585 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26586 = (inst_26535 + inst_26581);
var inst_26587 = [(0),inst_26586,inst_26536,inst_26584];
var inst_26588 = (new cljs.core.PersistentVector(null,4,(5),inst_26585,inst_26587,null));
var state_26716__$1 = state_26716;
var statearr_26802_26983 = state_26716__$1;
(statearr_26802_26983[(2)] = inst_26588);

(statearr_26802_26983[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (100))){
var inst_26603 = (state_26716[(67)]);
var inst_26497 = (state_26716[(30)]);
var inst_26630 = (state_26716[(52)]);
var inst_26535 = (state_26716[(36)]);
var inst_26629 = (state_26716[(53)]);
var inst_26631 = (state_26716[(54)]);
var inst_26625 = (state_26716[(2)]);
var inst_26626 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26625,(0),null);
var inst_26627 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26625,(1),null);
var inst_26628 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_26627,inst_26603);
var inst_26629__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_26628);
var inst_26630__$1 = cljs.core.count(inst_26629__$1);
var inst_26631__$1 = (inst_26535 + inst_26630__$1);
var inst_26632 = (inst_26631__$1 > inst_26497);
var state_26716__$1 = (function (){var statearr_26803 = state_26716;
(statearr_26803[(83)] = inst_26626);

(statearr_26803[(52)] = inst_26630__$1);

(statearr_26803[(53)] = inst_26629__$1);

(statearr_26803[(54)] = inst_26631__$1);

return statearr_26803;
})();
if(cljs.core.truth_(inst_26632)){
var statearr_26804_26984 = state_26716__$1;
(statearr_26804_26984[(1)] = (101));

} else {
var statearr_26805_26985 = state_26716__$1;
(statearr_26805_26985[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (122))){
var inst_26671 = (state_26716[(76)]);
var inst_26670 = (state_26716[(77)]);
var inst_26696 = (state_26716[(73)]);
var inst_26669 = (state_26716[(78)]);
var inst_26672 = (state_26716[(7)]);
var inst_26533 = inst_26696;
var inst_26534 = inst_26669;
var inst_26535 = inst_26670;
var inst_26536 = inst_26671;
var inst_26537 = inst_26672;
var state_26716__$1 = (function (){var statearr_26806 = state_26716;
(statearr_26806[(22)] = inst_26533);

(statearr_26806[(26)] = inst_26536);

(statearr_26806[(27)] = inst_26537);

(statearr_26806[(31)] = inst_26534);

(statearr_26806[(36)] = inst_26535);

return statearr_26806;
})();
var statearr_26807_26986 = state_26716__$1;
(statearr_26807_26986[(2)] = null);

(statearr_26807_26986[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (43))){
var state_26716__$1 = state_26716;
var statearr_26808_26987 = state_26716__$1;
(statearr_26808_26987[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_26808_26987[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (61))){
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26520 = (state_26716[(46)]);
var inst_26519 = (state_26716[(2)]);
var inst_26520__$1 = fluree.db.util.async.throw_err(inst_26519);
var inst_26521 = fluree.db.query.range.find_next_valid_node(inst_26520__$1,inst_26493,inst_26510,inst_26514,inst_26515);
var state_26716__$1 = (function (){var statearr_26809 = state_26716;
(statearr_26809[(46)] = inst_26520__$1);

return statearr_26809;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(62),inst_26521);
} else {
if((state_val_26717 === (29))){
var inst_26443 = (state_26716[(2)]);
var inst_26444 = fluree.db.util.async.throw_err(inst_26443);
var state_26716__$1 = state_26716;
var statearr_26810_26988 = state_26716__$1;
(statearr_26810_26988[(2)] = inst_26444);

(statearr_26810_26988[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (44))){
var inst_26375 = (state_26716[(62)]);
var state_26716__$1 = state_26716;
var statearr_26811_26989 = state_26716__$1;
(statearr_26811_26989[(2)] = inst_26375);

(statearr_26811_26989[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (93))){
var inst_26534 = (state_26716[(31)]);
var inst_26530 = (state_26716[(9)]);
var inst_26591 = (state_26716[(81)]);
var inst_26603 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_26534,inst_26591);
var state_26716__$1 = (function (){var statearr_26812 = state_26716;
(statearr_26812[(67)] = inst_26603);

return statearr_26812;
})();
if(cljs.core.truth_(inst_26530)){
var statearr_26813_26990 = state_26716__$1;
(statearr_26813_26990[(1)] = (95));

} else {
var statearr_26814_26991 = state_26716__$1;
(statearr_26814_26991[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (6))){
var inst_26367 = (state_26716[(49)]);
var inst_26387 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26367);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(9),inst_26387);
} else {
if((state_val_26717 === (111))){
var inst_26503 = (state_26716[(11)]);
var inst_26671 = (state_26716[(76)]);
var inst_26679 = (inst_26671 < inst_26503);
var state_26716__$1 = state_26716;
var statearr_26815_26992 = state_26716__$1;
(statearr_26815_26992[(2)] = inst_26679);

(statearr_26815_26992[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (28))){
var inst_26437 = (state_26716[(74)]);
var inst_26447 = (state_26716[(2)]);
var inst_26448 = fluree.db.util.core.pred_ident_QMARK_(inst_26437);
var state_26716__$1 = (function (){var statearr_26816 = state_26716;
(statearr_26816[(16)] = inst_26447);

return statearr_26816;
})();
if(inst_26448){
var statearr_26817_26993 = state_26716__$1;
(statearr_26817_26993[(1)] = (30));

} else {
var statearr_26818_26994 = state_26716__$1;
(statearr_26818_26994[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (64))){
var state_26716__$1 = state_26716;
var statearr_26819_26995 = state_26716__$1;
(statearr_26819_26995[(2)] = true);

(statearr_26819_26995[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (103))){
var inst_26626 = (state_26716[(83)]);
var inst_26645 = (state_26716[(2)]);
var inst_26646 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26645,(0),null);
var inst_26647 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26645,(1),null);
var inst_26648 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26649 = [inst_26646,inst_26626,inst_26647];
var inst_26650 = (new cljs.core.PersistentVector(null,3,(5),inst_26648,inst_26649,null));
var state_26716__$1 = state_26716;
var statearr_26820_26996 = state_26716__$1;
(statearr_26820_26996[(2)] = inst_26650);

(statearr_26820_26996[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (51))){
var inst_26481 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26821_26997 = state_26716__$1;
(statearr_26821_26997[(2)] = inst_26481);

(statearr_26821_26997[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (25))){
var inst_26434 = (state_26716[(35)]);
var inst_26436 = (state_26716[(51)]);
var inst_26435 = (state_26716[(45)]);
var inst_26434__$1 = (state_26716[(2)]);
var inst_26435__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26434__$1,(0),null);
var inst_26436__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26435__$1,(0),null);
var inst_26437 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26435__$1,(1),null);
var inst_26438 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26434__$1,(1),null);
var inst_26439 = fluree.db.util.core.pred_ident_QMARK_(inst_26436__$1);
var state_26716__$1 = (function (){var statearr_26822 = state_26716;
(statearr_26822[(74)] = inst_26437);

(statearr_26822[(24)] = inst_26438);

(statearr_26822[(35)] = inst_26434__$1);

(statearr_26822[(51)] = inst_26436__$1);

(statearr_26822[(45)] = inst_26435__$1);

return statearr_26822;
})();
if(inst_26439){
var statearr_26823_26998 = state_26716__$1;
(statearr_26823_26998[(1)] = (26));

} else {
var statearr_26824_26999 = state_26716__$1;
(statearr_26824_26999[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (34))){
var inst_26447 = (state_26716[(16)]);
var state_26716__$1 = state_26716;
var statearr_26825_27000 = state_26716__$1;
(statearr_26825_27000[(2)] = inst_26447);

(statearr_26825_27000[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (17))){
var inst_26376 = (state_26716[(61)]);
var state_26716__$1 = state_26716;
var statearr_26826_27001 = state_26716__$1;
(statearr_26826_27001[(2)] = inst_26376);

(statearr_26826_27001[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (3))){
var inst_26714 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26716__$1,inst_26714);
} else {
if((state_val_26717 === (12))){
var inst_26369 = (state_26716[(60)]);
var inst_26402 = (state_26716[(2)]);
var inst_26403 = cljs.core.boolean_QMARK_(inst_26369);
var state_26716__$1 = (function (){var statearr_26827 = state_26716;
(statearr_26827[(42)] = inst_26402);

return statearr_26827;
})();
if(inst_26403){
var statearr_26828_27002 = state_26716__$1;
(statearr_26828_27002[(1)] = (14));

} else {
var statearr_26829_27003 = state_26716__$1;
(statearr_26829_27003[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (2))){
var inst_26367 = (state_26716[(49)]);
var inst_26366 = (state_26716[(21)]);
var inst_26373 = (state_26716[(25)]);
var inst_26381 = (state_26716[(37)]);
var _ = (function (){var statearr_26830 = state_26716;
(statearr_26830[(4)] = cljs.core.cons((5),(state_26716[(4)])));

return statearr_26830;
})();
var inst_26366__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_26367__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(0),null);
var inst_26368 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(1),null);
var inst_26369 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(2),null);
var inst_26370 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(3),null);
var inst_26371 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(4),null);
var inst_26372 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26366__$1,(5),null);
var inst_26373__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_26374 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(0),null);
var inst_26375 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(1),null);
var inst_26376 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(2),null);
var inst_26377 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(3),null);
var inst_26378 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(4),null);
var inst_26379 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26373__$1,(5),null);
var inst_26380 = opts;
var inst_26381__$1 = cljs.core.__destructure_map(inst_26380);
var inst_26382 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26381__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_26383 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26381__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_26384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_26381__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_26385 = fluree.db.util.core.pred_ident_QMARK_(inst_26367__$1);
var state_26716__$1 = (function (){var statearr_26831 = state_26716;
(statearr_26831[(55)] = inst_26379);

(statearr_26831[(18)] = inst_26378);

(statearr_26831[(49)] = inst_26367__$1);

(statearr_26831[(56)] = inst_26384);

(statearr_26831[(21)] = inst_26366__$1);

(statearr_26831[(25)] = inst_26373__$1);

(statearr_26831[(57)] = inst_26368);

(statearr_26831[(29)] = inst_26382);

(statearr_26831[(84)] = inst_26374);

(statearr_26831[(33)] = inst_26370);

(statearr_26831[(34)] = inst_26371);

(statearr_26831[(59)] = inst_26372);

(statearr_26831[(60)] = inst_26369);

(statearr_26831[(37)] = inst_26381__$1);

(statearr_26831[(61)] = inst_26376);

(statearr_26831[(40)] = inst_26377);

(statearr_26831[(41)] = inst_26383);

(statearr_26831[(62)] = inst_26375);

return statearr_26831;
})();
if(inst_26385){
var statearr_26832_27004 = state_26716__$1;
(statearr_26832_27004[(1)] = (6));

} else {
var statearr_26833_27005 = state_26716__$1;
(statearr_26833_27005[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (66))){
var inst_26499 = (state_26716[(71)]);
var inst_26524 = (state_26716[(8)]);
var inst_26532 = cljs.core.PersistentVector.EMPTY;
var inst_26533 = inst_26524;
var inst_26534 = inst_26499;
var inst_26535 = (0);
var inst_26536 = (0);
var inst_26537 = inst_26532;
var state_26716__$1 = (function (){var statearr_26834 = state_26716;
(statearr_26834[(22)] = inst_26533);

(statearr_26834[(26)] = inst_26536);

(statearr_26834[(27)] = inst_26537);

(statearr_26834[(31)] = inst_26534);

(statearr_26834[(36)] = inst_26535);

return statearr_26834;
})();
var statearr_26835_27006 = state_26716__$1;
(statearr_26835_27006[(2)] = null);

(statearr_26835_27006[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (107))){
var inst_26688 = (state_26716[(66)]);
var inst_26688__$1 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26836 = state_26716;
(statearr_26836[(66)] = inst_26688__$1);

return statearr_26836;
})();
if(cljs.core.truth_(inst_26688__$1)){
var statearr_26837_27007 = state_26716__$1;
(statearr_26837_27007[(1)] = (114));

} else {
var statearr_26838_27008 = state_26716__$1;
(statearr_26838_27008[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (23))){
var inst_26384 = (state_26716[(56)]);
var inst_26369 = (state_26716[(60)]);
var inst_26376 = (state_26716[(61)]);
var inst_26419 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26421 = [inst_26369,inst_26376];
var inst_26422 = (new cljs.core.PersistentVector(null,2,(5),inst_26420,inst_26421,null));
var inst_26423 = [inst_26422,inst_26384];
var inst_26424 = (new cljs.core.PersistentVector(null,2,(5),inst_26419,inst_26423,null));
var state_26716__$1 = state_26716;
var statearr_26839_27009 = state_26716__$1;
(statearr_26839_27009[(2)] = inst_26424);

(statearr_26839_27009[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (47))){
var inst_26477 = (cljs.core._GT__EQ_ === start_test);
var state_26716__$1 = state_26716;
if(cljs.core.truth_(inst_26477)){
var statearr_26840_27010 = state_26716__$1;
(statearr_26840_27010[(1)] = (49));

} else {
var statearr_26841_27011 = state_26716__$1;
(statearr_26841_27011[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (35))){
var inst_26457 = (state_26716[(75)]);
var state_26716__$1 = state_26716;
var statearr_26842_27012 = state_26716__$1;
(statearr_26842_27012[(2)] = inst_26457);

(statearr_26842_27012[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (82))){
var inst_26504 = (state_26716[(14)]);
var inst_26533 = (state_26716[(22)]);
var inst_26569 = (state_26716[(2)]);
var inst_26570 = fluree.db.dbproto._rhs(inst_26533);
var state_26716__$1 = (function (){var statearr_26843 = state_26716;
(statearr_26843[(80)] = inst_26569);

(statearr_26843[(65)] = inst_26570);

return statearr_26843;
})();
if(cljs.core.truth_(inst_26504)){
var statearr_26844_27013 = state_26716__$1;
(statearr_26844_27013[(1)] = (83));

} else {
var statearr_26845_27014 = state_26716__$1;
(statearr_26845_27014[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (76))){
var inst_26383 = (state_26716[(41)]);
var inst_26557 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26846 = state_26716;
(statearr_26846[(64)] = inst_26557);

return statearr_26846;
})();
if(cljs.core.truth_(inst_26383)){
var statearr_26847_27015 = state_26716__$1;
(statearr_26847_27015[(1)] = (77));

} else {
var statearr_26848_27016 = state_26716__$1;
(statearr_26848_27016[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (97))){
var inst_26537 = (state_26716[(27)]);
var inst_26657 = (state_26716[(2)]);
var inst_26658 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26657,(0),null);
var inst_26659 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26657,(1),null);
var inst_26660 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_26657,(2),null);
var inst_26661 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26662 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_26537,inst_26660);
var inst_26663 = [(0),inst_26658,inst_26659,inst_26662];
var inst_26664 = (new cljs.core.PersistentVector(null,4,(5),inst_26661,inst_26663,null));
var state_26716__$1 = state_26716;
var statearr_26849_27017 = state_26716__$1;
(statearr_26849_27017[(2)] = inst_26664);

(statearr_26849_27017[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (19))){
var inst_26414 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26850_27018 = state_26716__$1;
(statearr_26850_27018[(2)] = inst_26414);

(statearr_26850_27018[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (57))){
var inst_26490 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26851_27019 = state_26716__$1;
(statearr_26851_27019[(2)] = inst_26490);

(statearr_26851_27019[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (68))){
var inst_26711 = (state_26716[(2)]);
var _ = (function (){var statearr_26852 = state_26716;
(statearr_26852[(4)] = cljs.core.rest((state_26716[(4)])));

return statearr_26852;
})();
var state_26716__$1 = state_26716;
var statearr_26853_27020 = state_26716__$1;
(statearr_26853_27020[(2)] = inst_26711);

(statearr_26853_27020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (11))){
var inst_26374 = (state_26716[(84)]);
var state_26716__$1 = state_26716;
var statearr_26854_27021 = state_26716__$1;
(statearr_26854_27021[(2)] = inst_26374);

(statearr_26854_27021[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (115))){
var state_26716__$1 = state_26716;
var statearr_26856_27022 = state_26716__$1;
(statearr_26856_27022[(2)] = null);

(statearr_26856_27022[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (9))){
var inst_26389 = (state_26716[(2)]);
var inst_26390 = fluree.db.util.async.throw_err(inst_26389);
var state_26716__$1 = state_26716;
var statearr_26857_27023 = state_26716__$1;
(statearr_26857_27023[(2)] = inst_26390);

(statearr_26857_27023[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (5))){
var _ = (function (){var statearr_26858 = state_26716;
(statearr_26858[(4)] = cljs.core.rest((state_26716[(4)])));

return statearr_26858;
})();
var state_26716__$1 = state_26716;
var ex26855 = (state_26716__$1[(2)]);
var statearr_26859_27024 = state_26716__$1;
(statearr_26859_27024[(5)] = ex26855);


if((ex26855 instanceof Error)){
var statearr_26860_27025 = state_26716__$1;
(statearr_26860_27025[(1)] = (4));

(statearr_26860_27025[(5)] = null);

} else {
throw ex26855;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (112))){
var inst_26677 = (state_26716[(79)]);
var state_26716__$1 = state_26716;
var statearr_26861_27026 = state_26716__$1;
(statearr_26861_27026[(2)] = inst_26677);

(statearr_26861_27026[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (83))){
var inst_26534 = (state_26716[(31)]);
var inst_26572 = (state_26716[(85)]);
var inst_26572__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_26534);
var state_26716__$1 = (function (){var statearr_26862 = state_26716;
(statearr_26862[(85)] = inst_26572__$1);

return statearr_26862;
})();
if(inst_26572__$1){
var statearr_26863_27027 = state_26716__$1;
(statearr_26863_27027[(1)] = (86));

} else {
var statearr_26864_27028 = state_26716__$1;
(statearr_26864_27028[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (14))){
var inst_26369 = (state_26716[(60)]);
var state_26716__$1 = state_26716;
var statearr_26865_27029 = state_26716__$1;
(statearr_26865_27029[(2)] = inst_26369);

(statearr_26865_27029[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (45))){
var inst_26372 = (state_26716[(59)]);
var inst_26474 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26866 = state_26716;
(statearr_26866[(48)] = inst_26474);

return statearr_26866;
})();
if(cljs.core.truth_(inst_26372)){
var statearr_26867_27030 = state_26716__$1;
(statearr_26867_27030[(1)] = (46));

} else {
var statearr_26868_27031 = state_26716__$1;
(statearr_26868_27031[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (53))){
var inst_26486 = (cljs.core._LT__EQ_ === end_test);
var state_26716__$1 = state_26716;
if(cljs.core.truth_(inst_26486)){
var statearr_26869_27032 = state_26716__$1;
(statearr_26869_27032[(1)] = (55));

} else {
var statearr_26870_27033 = state_26716__$1;
(statearr_26870_27033[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (78))){
var inst_26557 = (state_26716[(64)]);
var state_26716__$1 = state_26716;
var statearr_26871_27034 = state_26716__$1;
(statearr_26871_27034[(2)] = inst_26557);

(statearr_26871_27034[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (26))){
var inst_26436 = (state_26716[(51)]);
var inst_26441 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26436);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(29),inst_26441);
} else {
if((state_val_26717 === (123))){
var inst_26706 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26872_27035 = state_26716__$1;
(statearr_26872_27035[(2)] = inst_26706);

(statearr_26872_27035[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (16))){
var inst_26416 = (state_26716[(58)]);
var inst_26416__$1 = (state_26716[(2)]);
var inst_26417 = (inst_26416__$1 == null);
var state_26716__$1 = (function (){var statearr_26873 = state_26716;
(statearr_26873[(58)] = inst_26416__$1);

return statearr_26873;
})();
if(cljs.core.truth_(inst_26417)){
var statearr_26874_27036 = state_26716__$1;
(statearr_26874_27036[(1)] = (23));

} else {
var statearr_26875_27037 = state_26716__$1;
(statearr_26875_27037[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (81))){
var inst_26563 = (state_26716[(86)]);
var state_26716__$1 = state_26716;
var statearr_26876_27038 = state_26716__$1;
(statearr_26876_27038[(2)] = inst_26563);

(statearr_26876_27038[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (120))){
var inst_26700 = (state_26716[(2)]);
var inst_26701 = cljs.core.not(inst_26700);
var state_26716__$1 = state_26716;
if(inst_26701){
var statearr_26877_27039 = state_26716__$1;
(statearr_26877_27039[(1)] = (121));

} else {
var statearr_26878_27040 = state_26716__$1;
(statearr_26878_27040[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (79))){
var inst_26438 = (state_26716[(24)]);
var inst_26563 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26879 = state_26716;
(statearr_26879[(86)] = inst_26563);

return statearr_26879;
})();
if(cljs.core.truth_(inst_26438)){
var statearr_26880_27041 = state_26716__$1;
(statearr_26880_27041[(1)] = (80));

} else {
var statearr_26881_27042 = state_26716__$1;
(statearr_26881_27042[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (38))){
var inst_26368 = (state_26716[(57)]);
var state_26716__$1 = state_26716;
var statearr_26882_27043 = state_26716__$1;
(statearr_26882_27043[(2)] = inst_26368);

(statearr_26882_27043[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (98))){
var inst_26503 = (state_26716[(11)]);
var inst_26613 = (state_26716[(68)]);
var inst_26611 = (state_26716[(69)]);
var inst_26616 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_26617 = (inst_26611 - inst_26613);
var inst_26618 = [inst_26503,inst_26617];
var inst_26619 = (new cljs.core.PersistentVector(null,2,(5),inst_26616,inst_26618,null));
var state_26716__$1 = state_26716;
var statearr_26883_27044 = state_26716__$1;
(statearr_26883_27044[(2)] = inst_26619);

(statearr_26883_27044[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (87))){
var inst_26572 = (state_26716[(85)]);
var state_26716__$1 = state_26716;
var statearr_26884_27045 = state_26716__$1;
(statearr_26884_27045[(2)] = inst_26572);

(statearr_26884_27045[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (30))){
var inst_26437 = (state_26716[(74)]);
var inst_26450 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26437);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(33),inst_26450);
} else {
if((state_val_26717 === (73))){
var inst_26382 = (state_26716[(29)]);
var inst_26551 = (state_26716[(2)]);
var state_26716__$1 = (function (){var statearr_26885 = state_26716;
(statearr_26885[(17)] = inst_26551);

return statearr_26885;
})();
if(cljs.core.truth_(inst_26382)){
var statearr_26886_27046 = state_26716__$1;
(statearr_26886_27046[(1)] = (74));

} else {
var statearr_26887_27047 = state_26716__$1;
(statearr_26887_27047[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (96))){
var inst_26503 = (state_26716[(11)]);
var inst_26603 = (state_26716[(67)]);
var inst_26536 = (state_26716[(26)]);
var inst_26497 = (state_26716[(30)]);
var inst_26535 = (state_26716[(36)]);
var inst_26652 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_26603,inst_26535,inst_26536,inst_26497,inst_26503);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(104),inst_26652);
} else {
if((state_val_26717 === (10))){
var inst_26374 = (state_26716[(84)]);
var inst_26396 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_26374);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(13),inst_26396);
} else {
if((state_val_26717 === (18))){
var state_26716__$1 = state_26716;
var statearr_26888_27048 = state_26716__$1;
(statearr_26888_27048[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (105))){
var inst_26675 = (state_26716[(82)]);
var inst_26509 = (state_26716[(38)]);
var inst_26494 = (state_26716[(39)]);
var inst_26570 = (state_26716[(65)]);
var inst_26674 = (inst_26509.cljs$core$IFn$_invoke$arity$2 ? inst_26509.cljs$core$IFn$_invoke$arity$2(inst_26570,inst_26494) : inst_26509.call(null,inst_26570,inst_26494));
var inst_26675__$1 = (inst_26674 < (0));
var state_26716__$1 = (function (){var statearr_26890 = state_26716;
(statearr_26890[(82)] = inst_26675__$1);

return statearr_26890;
})();
if(cljs.core.truth_(inst_26675__$1)){
var statearr_26891_27049 = state_26716__$1;
(statearr_26891_27049[(1)] = (108));

} else {
var statearr_26892_27050 = state_26716__$1;
(statearr_26892_27050[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (52))){
var inst_26379 = (state_26716[(55)]);
var state_26716__$1 = state_26716;
var statearr_26893_27051 = state_26716__$1;
(statearr_26893_27051[(2)] = inst_26379);

(statearr_26893_27051[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (114))){
var inst_26515 = (state_26716[(12)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26570 = (state_26716[(65)]);
var inst_26520 = (state_26716[(46)]);
var inst_26690 = fluree.db.query.range.find_next_valid_node(inst_26520,inst_26570,inst_26510,inst_26514,inst_26515);
var state_26716__$1 = state_26716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26716__$1,(117),inst_26690);
} else {
if((state_val_26717 === (67))){
var state_26716__$1 = state_26716;
var statearr_26894_27052 = state_26716__$1;
(statearr_26894_27052[(2)] = null);

(statearr_26894_27052[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (71))){
var inst_26496 = (state_26716[(10)]);
var inst_26503 = (state_26716[(11)]);
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26504 = (state_26716[(14)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26378 = (state_26716[(18)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26366 = (state_26716[(21)]);
var inst_26533 = (state_26716[(22)]);
var inst_26543 = (state_26716[(23)]);
var inst_26438 = (state_26716[(24)]);
var inst_26373 = (state_26716[(25)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26483 = (state_26716[(28)]);
var inst_26382 = (state_26716[(29)]);
var inst_26497 = (state_26716[(30)]);
var inst_26534 = (state_26716[(31)]);
var inst_26505 = (state_26716[(32)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26530 = (state_26716[(9)]);
var inst_26434 = (state_26716[(35)]);
var inst_26535 = (state_26716[(36)]);
var inst_26381 = (state_26716[(37)]);
var inst_26509 = (state_26716[(38)]);
var inst_26524 = (state_26716[(8)]);
var inst_26494 = (state_26716[(39)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26435 = (state_26716[(45)]);
var inst_26520 = (state_26716[(46)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26547 = (function (){var no_filter_QMARK_ = inst_26530;
var t = inst_26510;
var max_limit_QMARK_ = inst_26504;
var next_node = inst_26533;
var fast_forward_db_QMARK_ = inst_26515;
var s1 = inst_26393;
var o2 = inst_26456;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var i = inst_26535;
var m1 = inst_26483;
var root_node = inst_26520;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26474;
var vec__26359 = inst_26434;
var permissions = inst_26505;
var limit = inst_26503;
var start_flake = inst_26493;
var flake_limit = inst_26497;
var offset = inst_26534;
var map__26365 = inst_26496;
var acc = inst_26537;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26447;
var vec__26355 = inst_26373;
var end_flake = inst_26494;
var base_result = inst_26543;
var s = inst_26536;
var node_start = inst_26524;
var p1 = inst_26465;
var subject_fn = inst_26382;
var G__26544 = inst_26543;
var object_fn = inst_26438;
var idx_compare = inst_26509;
var vec__26362 = inst_26435;
var op2 = inst_26378;
var m2 = inst_26492;
var novelty = inst_26514;
return (function (p1__26333_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__26333_SHARP_.o,start_flake.o);
});
})();
var inst_26548 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26547,inst_26543);
var state_26716__$1 = state_26716;
var statearr_26895_27053 = state_26716__$1;
(statearr_26895_27053[(2)] = inst_26548);

(statearr_26895_27053[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (42))){
var inst_26470 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
if(cljs.core.truth_(inst_26470)){
var statearr_26896_27054 = state_26716__$1;
(statearr_26896_27054[(1)] = (43));

} else {
var statearr_26897_27055 = state_26716__$1;
(statearr_26897_27055[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (80))){
var inst_26496 = (state_26716[(10)]);
var inst_26503 = (state_26716[(11)]);
var inst_26515 = (state_26716[(12)]);
var inst_26493 = (state_26716[(13)]);
var inst_26504 = (state_26716[(14)]);
var inst_26492 = (state_26716[(15)]);
var inst_26447 = (state_26716[(16)]);
var inst_26378 = (state_26716[(18)]);
var inst_26510 = (state_26716[(19)]);
var inst_26514 = (state_26716[(20)]);
var inst_26366 = (state_26716[(21)]);
var inst_26533 = (state_26716[(22)]);
var inst_26543 = (state_26716[(23)]);
var inst_26438 = (state_26716[(24)]);
var inst_26373 = (state_26716[(25)]);
var inst_26536 = (state_26716[(26)]);
var inst_26537 = (state_26716[(27)]);
var inst_26483 = (state_26716[(28)]);
var inst_26382 = (state_26716[(29)]);
var inst_26497 = (state_26716[(30)]);
var inst_26563 = (state_26716[(86)]);
var inst_26534 = (state_26716[(31)]);
var inst_26505 = (state_26716[(32)]);
var inst_26370 = (state_26716[(33)]);
var inst_26371 = (state_26716[(34)]);
var inst_26530 = (state_26716[(9)]);
var inst_26434 = (state_26716[(35)]);
var inst_26535 = (state_26716[(36)]);
var inst_26381 = (state_26716[(37)]);
var inst_26509 = (state_26716[(38)]);
var inst_26524 = (state_26716[(8)]);
var inst_26494 = (state_26716[(39)]);
var inst_26377 = (state_26716[(40)]);
var inst_26383 = (state_26716[(41)]);
var inst_26402 = (state_26716[(42)]);
var inst_26456 = (state_26716[(43)]);
var inst_26393 = (state_26716[(44)]);
var inst_26435 = (state_26716[(45)]);
var inst_26520 = (state_26716[(46)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26565 = (function (){var no_filter_QMARK_ = inst_26530;
var t = inst_26510;
var max_limit_QMARK_ = inst_26504;
var next_node = inst_26533;
var fast_forward_db_QMARK_ = inst_26515;
var s1 = inst_26393;
var o2 = inst_26456;
var t1 = inst_26370;
var predicate_fn = inst_26383;
var i = inst_26535;
var m1 = inst_26483;
var root_node = inst_26520;
var s2 = inst_26402;
var map__26358 = inst_26381;
var p2 = inst_26474;
var vec__26359 = inst_26434;
var permissions = inst_26505;
var limit = inst_26503;
var start_flake = inst_26493;
var flake_limit = inst_26497;
var offset = inst_26534;
var map__26365 = inst_26496;
var acc = inst_26537;
var t2 = inst_26377;
var vec__26352 = inst_26366;
var op1 = inst_26371;
var o1 = inst_26447;
var vec__26355 = inst_26373;
var end_flake = inst_26494;
var base_result = inst_26543;
var s = inst_26536;
var node_start = inst_26524;
var p1 = inst_26465;
var subject_fn = inst_26382;
var G__26544 = inst_26563;
var object_fn = inst_26438;
var idx_compare = inst_26509;
var vec__26362 = inst_26435;
var op2 = inst_26378;
var m2 = inst_26492;
var novelty = inst_26514;
return (function (p1__26336_SHARP_){
var G__26898 = p1__26336_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__26898) : object_fn.call(null,G__26898));
});
})();
var inst_26566 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_26565,inst_26563);
var state_26716__$1 = state_26716;
var statearr_26899_27056 = state_26716__$1;
(statearr_26899_27056[(2)] = inst_26566);

(statearr_26899_27056[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (37))){
var state_26716__$1 = state_26716;
var statearr_26900_27057 = state_26716__$1;
(statearr_26900_27057[(2)] = (-1));

(statearr_26900_27057[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (63))){
var inst_26505 = (state_26716[(32)]);
var inst_26402 = (state_26716[(42)]);
var inst_26393 = (state_26716[(44)]);
var inst_26465 = (state_26716[(47)]);
var inst_26474 = (state_26716[(48)]);
var inst_26527 = fluree.db.permissions_validate.no_filter_QMARK_(inst_26505,inst_26393,inst_26402,inst_26465,inst_26474);
var state_26716__$1 = state_26716;
var statearr_26901_27058 = state_26716__$1;
(statearr_26901_27058[(2)] = inst_26527);

(statearr_26901_27058[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (94))){
var inst_26666 = (state_26716[(2)]);
var state_26716__$1 = state_26716;
var statearr_26902_27059 = state_26716__$1;
(statearr_26902_27059[(2)] = inst_26666);

(statearr_26902_27059[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (8))){
var inst_26374 = (state_26716[(84)]);
var inst_26393 = (state_26716[(2)]);
var inst_26394 = fluree.db.util.core.pred_ident_QMARK_(inst_26374);
var state_26716__$1 = (function (){var statearr_26903 = state_26716;
(statearr_26903[(44)] = inst_26393);

return statearr_26903;
})();
if(inst_26394){
var statearr_26904_27060 = state_26716__$1;
(statearr_26904_27060[(1)] = (10));

} else {
var statearr_26905_27061 = state_26716__$1;
(statearr_26905_27061[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (49))){
var state_26716__$1 = state_26716;
var statearr_26906_27062 = state_26716__$1;
(statearr_26906_27062[(2)] = fluree.db.util.core.min_integer);

(statearr_26906_27062[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26717 === (84))){
var inst_26504 = (state_26716[(14)]);
var state_26716__$1 = state_26716;
var statearr_26907_27063 = state_26716__$1;
(statearr_26907_27063[(2)] = inst_26504);

(statearr_26907_27063[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10750__auto__ = null;
var fluree$db$query$range$state_machine__10750__auto____0 = (function (){
var statearr_26908 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26908[(0)] = fluree$db$query$range$state_machine__10750__auto__);

(statearr_26908[(1)] = (1));

return statearr_26908;
});
var fluree$db$query$range$state_machine__10750__auto____1 = (function (state_26716){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_26716);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e26909){var ex__10753__auto__ = e26909;
var statearr_26910_27064 = state_26716;
(statearr_26910_27064[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_26716[(4)]))){
var statearr_26911_27065 = state_26716;
(statearr_26911_27065[(1)] = cljs.core.first((state_26716[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27066 = state_26716;
state_26716 = G__27066;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10750__auto__ = function(state_26716){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10750__auto____1.call(this,state_26716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10750__auto____0;
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10750__auto____1;
return fluree$db$query$range$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_26912 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_26912[(6)] = c__10876__auto__);

return statearr_26912;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27122){
var state_val_27123 = (state_27122[(1)]);
if((state_val_27123 === (7))){
var inst_27086 = (state_27122[(7)]);
var inst_27096 = (state_27122[(8)]);
var inst_27094 = fluree.db.flake.Flake__GT_parts(inst_27086);
var inst_27095 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(0),null);
var inst_27096__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(1),null);
var inst_27097 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(2),null);
var inst_27098 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(3),null);
var inst_27099 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(4),null);
var inst_27100 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27094,(5),null);
var inst_27101 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_27097,inst_27096__$1);
var state_27122__$1 = (function (){var statearr_27124 = state_27122;
(statearr_27124[(9)] = inst_27095);

(statearr_27124[(8)] = inst_27096__$1);

(statearr_27124[(10)] = inst_27099);

(statearr_27124[(11)] = inst_27100);

(statearr_27124[(12)] = inst_27098);

return statearr_27124;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27122__$1,(10),inst_27101);
} else {
if((state_val_27123 === (1))){
var inst_27074 = flakes;
var inst_27075 = cljs.core.seq(inst_27074);
var inst_27076 = cljs.core.first(inst_27075);
var inst_27077 = cljs.core.next(inst_27075);
var inst_27078 = cljs.core.PersistentVector.EMPTY;
var inst_27079 = inst_27074;
var inst_27080 = inst_27078;
var state_27122__$1 = (function (){var statearr_27125 = state_27122;
(statearr_27125[(13)] = inst_27076);

(statearr_27125[(14)] = inst_27080);

(statearr_27125[(15)] = inst_27079);

(statearr_27125[(16)] = inst_27077);

return statearr_27125;
})();
var statearr_27126_27144 = state_27122__$1;
(statearr_27126_27144[(2)] = null);

(statearr_27126_27144[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (4))){
var inst_27086 = (state_27122[(7)]);
var inst_27089 = fluree.db.query.range.is_tag_flake_QMARK_(inst_27086);
var state_27122__$1 = state_27122;
if(inst_27089){
var statearr_27127_27145 = state_27122__$1;
(statearr_27127_27145[(1)] = (7));

} else {
var statearr_27128_27146 = state_27122__$1;
(statearr_27128_27146[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (6))){
var inst_27118 = (state_27122[(2)]);
var state_27122__$1 = state_27122;
var statearr_27129_27147 = state_27122__$1;
(statearr_27129_27147[(2)] = inst_27118);

(statearr_27129_27147[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (3))){
var inst_27120 = (state_27122[(2)]);
var state_27122__$1 = state_27122;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27122__$1,inst_27120);
} else {
if((state_val_27123 === (2))){
var inst_27086 = (state_27122[(7)]);
var inst_27079 = (state_27122[(15)]);
var inst_27085 = cljs.core.seq(inst_27079);
var inst_27086__$1 = cljs.core.first(inst_27085);
var inst_27087 = cljs.core.next(inst_27085);
var state_27122__$1 = (function (){var statearr_27130 = state_27122;
(statearr_27130[(17)] = inst_27087);

(statearr_27130[(7)] = inst_27086__$1);

return statearr_27130;
})();
if(cljs.core.truth_(inst_27086__$1)){
var statearr_27131_27148 = state_27122__$1;
(statearr_27131_27148[(1)] = (4));

} else {
var statearr_27132_27149 = state_27122__$1;
(statearr_27132_27149[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (9))){
var inst_27115 = (state_27122[(2)]);
var state_27122__$1 = state_27122;
var statearr_27133_27150 = state_27122__$1;
(statearr_27133_27150[(2)] = inst_27115);

(statearr_27133_27150[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (5))){
var inst_27080 = (state_27122[(14)]);
var state_27122__$1 = state_27122;
var statearr_27134_27151 = state_27122__$1;
(statearr_27134_27151[(2)] = inst_27080);

(statearr_27134_27151[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (10))){
var inst_27095 = (state_27122[(9)]);
var inst_27087 = (state_27122[(17)]);
var inst_27080 = (state_27122[(14)]);
var inst_27096 = (state_27122[(8)]);
var inst_27099 = (state_27122[(10)]);
var inst_27100 = (state_27122[(11)]);
var inst_27098 = (state_27122[(12)]);
var inst_27103 = (state_27122[(2)]);
var inst_27104 = fluree.db.util.async.throw_err(inst_27103);
var inst_27105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27106 = [inst_27095,inst_27096,inst_27104,inst_27098,inst_27099,inst_27100];
var inst_27107 = (new cljs.core.PersistentVector(null,6,(5),inst_27105,inst_27106,null));
var inst_27108 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_27107);
var inst_27109 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27080,inst_27108);
var inst_27079 = inst_27087;
var inst_27080__$1 = inst_27109;
var state_27122__$1 = (function (){var statearr_27135 = state_27122;
(statearr_27135[(14)] = inst_27080__$1);

(statearr_27135[(15)] = inst_27079);

return statearr_27135;
})();
var statearr_27136_27152 = state_27122__$1;
(statearr_27136_27152[(2)] = null);

(statearr_27136_27152[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27123 === (8))){
var inst_27087 = (state_27122[(17)]);
var inst_27086 = (state_27122[(7)]);
var inst_27080 = (state_27122[(14)]);
var inst_27112 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_27080,inst_27086);
var inst_27079 = inst_27087;
var inst_27080__$1 = inst_27112;
var state_27122__$1 = (function (){var statearr_27137 = state_27122;
(statearr_27137[(14)] = inst_27080__$1);

(statearr_27137[(15)] = inst_27079);

return statearr_27137;
})();
var statearr_27138_27153 = state_27122__$1;
(statearr_27138_27153[(2)] = null);

(statearr_27138_27153[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____0 = (function (){
var statearr_27139 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27139[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__);

(statearr_27139[(1)] = (1));

return statearr_27139;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____1 = (function (state_27122){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27122);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27140){var ex__10753__auto__ = e27140;
var statearr_27141_27154 = state_27122;
(statearr_27141_27154[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27122[(4)]))){
var statearr_27142_27155 = state_27122;
(statearr_27142_27155[(1)] = cljs.core.first((state_27122[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27156 = state_27122;
state_27122 = G__27156;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__ = function(state_27122){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____1.call(this,state_27122);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27143 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27143[(6)] = c__10876__auto__);

return statearr_27143;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__27158 = arguments.length;
switch (G__27158) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27328){
var state_val_27329 = (state_27328[(1)]);
if((state_val_27329 === (65))){
var state_27328__$1 = state_27328;
var statearr_27330_27430 = state_27328__$1;
(statearr_27330_27430[(2)] = null);

(statearr_27330_27430[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (70))){
var inst_27323 = (state_27328[(2)]);
var _ = (function (){var statearr_27331 = state_27328;
(statearr_27331[(4)] = cljs.core.rest((state_27328[(4)])));

return statearr_27331;
})();
var state_27328__$1 = state_27328;
var statearr_27332_27431 = state_27328__$1;
(statearr_27332_27431[(2)] = inst_27323);

(statearr_27332_27431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (62))){
var inst_27309 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27333_27432 = state_27328__$1;
(statearr_27333_27432[(2)] = inst_27309);

(statearr_27333_27432[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (7))){
var state_27328__$1 = state_27328;
var statearr_27334_27433 = state_27328__$1;
(statearr_27334_27433[(2)] = false);

(statearr_27334_27433[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (59))){
var inst_27283 = (state_27328[(2)]);
var inst_27284 = fluree.db.util.async.throw_err(inst_27283);
var state_27328__$1 = state_27328;
var statearr_27335_27434 = state_27328__$1;
(statearr_27335_27434[(2)] = inst_27284);

(statearr_27335_27434[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (20))){
var state_27328__$1 = state_27328;
var statearr_27336_27435 = state_27328__$1;
(statearr_27336_27435[(2)] = null);

(statearr_27336_27435[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (58))){
var inst_27273 = (state_27328[(2)]);
var inst_27274 = fluree.db.util.async.throw_err(inst_27273);
var inst_27275 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_27274);
var state_27328__$1 = state_27328;
var statearr_27337_27436 = state_27328__$1;
(statearr_27337_27436[(2)] = inst_27275);

(statearr_27337_27436[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (60))){
var inst_27209 = (state_27328[(7)]);
var inst_27169 = (state_27328[(8)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27289 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27290 = [inst_27170,inst_27169,inst_27209,inst_27172];
var inst_27291 = (new cljs.core.PersistentVector(null,4,(5),inst_27289,inst_27290,null));
var inst_27292 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_27291,opts);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(63),inst_27292);
} else {
if((state_val_27329 === (27))){
var inst_27220 = (state_27328[(11)]);
var inst_27209 = (state_27328[(7)]);
var inst_27220__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_27209);
var state_27328__$1 = (function (){var statearr_27338 = state_27328;
(statearr_27338[(11)] = inst_27220__$1);

return statearr_27338;
})();
if(inst_27220__$1){
var statearr_27339_27437 = state_27328__$1;
(statearr_27339_27437[(1)] = (30));

} else {
var statearr_27340_27438 = state_27328__$1;
(statearr_27340_27438[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (1))){
var state_27328__$1 = state_27328;
var statearr_27341_27439 = state_27328__$1;
(statearr_27341_27439[(2)] = null);

(statearr_27341_27439[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (69))){
var inst_27315 = (state_27328[(12)]);
var state_27328__$1 = state_27328;
var statearr_27342_27440 = state_27328__$1;
(statearr_27342_27440[(2)] = inst_27315);

(statearr_27342_27440[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (24))){
var inst_27170 = (state_27328[(10)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27170)){
var statearr_27343_27441 = state_27328__$1;
(statearr_27343_27441[(1)] = (27));

} else {
var statearr_27344_27442 = state_27328__$1;
(statearr_27344_27442[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (55))){
var inst_27209 = (state_27328[(7)]);
var inst_27267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27268 = [inst_27209];
var inst_27269 = (new cljs.core.PersistentVector(null,1,(5),inst_27267,inst_27268,null));
var inst_27270 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_27271 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_27269,inst_27270);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(58),inst_27271);
} else {
if((state_val_27329 === (39))){
var inst_27240 = (state_27328[(2)]);
var inst_27241 = fluree.db.util.async.throw_err(inst_27240);
var state_27328__$1 = state_27328;
var statearr_27345_27443 = state_27328__$1;
(statearr_27345_27443[(2)] = inst_27241);

(statearr_27345_27443[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (46))){
var inst_27253 = (state_27328[(13)]);
var inst_27253__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_27328__$1 = (function (){var statearr_27346 = state_27328;
(statearr_27346[(13)] = inst_27253__$1);

return statearr_27346;
})();
if(cljs.core.truth_(inst_27253__$1)){
var statearr_27347_27444 = state_27328__$1;
(statearr_27347_27444[(1)] = (49));

} else {
var statearr_27348_27445 = state_27328__$1;
(statearr_27348_27445[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (4))){
var inst_27159 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27349_27446 = state_27328__$1;
(statearr_27349_27446[(2)] = inst_27159);

(statearr_27349_27446[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (54))){
var inst_27265 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27265)){
var statearr_27350_27447 = state_27328__$1;
(statearr_27350_27447[(1)] = (55));

} else {
var statearr_27351_27448 = state_27328__$1;
(statearr_27351_27448[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (15))){
var inst_27171 = (state_27328[(14)]);
var inst_27190 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_27171);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(18),inst_27190);
} else {
if((state_val_27329 === (48))){
var inst_27311 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27352_27449 = state_27328__$1;
(statearr_27352_27449[(2)] = inst_27311);

(statearr_27352_27449[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (50))){
var inst_27253 = (state_27328[(13)]);
var inst_27179 = (state_27328[(15)]);
var inst_27209 = (state_27328[(7)]);
var inst_27173 = (state_27328[(16)]);
var inst_27168 = (state_27328[(17)]);
var inst_27169 = (state_27328[(8)]);
var inst_27184 = (state_27328[(18)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27257 = (function (){var t = inst_27172;
var p = inst_27170;
var idx_predicate_QMARK_ = inst_27173;
var o = inst_27209;
var vec__27165 = inst_27168;
var tag_predicate_QMARK_ = inst_27179;
var temp__5751__auto__ = inst_27253;
var s = inst_27169;
var o_coerce_QMARK_ = inst_27184;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_27328__$1 = state_27328;
var statearr_27353_27450 = state_27328__$1;
(statearr_27353_27450[(2)] = inst_27257);

(statearr_27353_27450[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (21))){
var inst_27205 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27354_27451 = state_27328__$1;
(statearr_27354_27451[(2)] = inst_27205);

(statearr_27354_27451[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (31))){
var inst_27220 = (state_27328[(11)]);
var state_27328__$1 = state_27328;
var statearr_27355_27452 = state_27328__$1;
(statearr_27355_27452[(2)] = inst_27220);

(statearr_27355_27452[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (32))){
var inst_27230 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27356_27453 = state_27328__$1;
(statearr_27356_27453[(2)] = inst_27230);

(statearr_27356_27453[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (40))){
var inst_27173 = (state_27328[(16)]);
var inst_27244 = (state_27328[(19)]);
var inst_27244__$1 = cljs.core.not(inst_27173);
var state_27328__$1 = (function (){var statearr_27357 = state_27328;
(statearr_27357[(19)] = inst_27244__$1);

return statearr_27357;
})();
if(inst_27244__$1){
var statearr_27358_27454 = state_27328__$1;
(statearr_27358_27454[(1)] = (43));

} else {
var statearr_27359_27455 = state_27328__$1;
(statearr_27359_27455[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (56))){
var inst_27259 = (state_27328[(20)]);
var inst_27169 = (state_27328[(8)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27277 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27278 = [inst_27170,inst_27169,null,inst_27172];
var inst_27279 = (new cljs.core.PersistentVector(null,4,(5),inst_27277,inst_27278,null));
var inst_27280 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_27259);
var inst_27281 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_27279,inst_27280);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(59),inst_27281);
} else {
if((state_val_27329 === (33))){
var inst_27209 = (state_27328[(7)]);
var inst_27223 = cljs.core.fn_QMARK_(inst_27209);
var inst_27224 = (!(inst_27223));
var state_27328__$1 = state_27328;
var statearr_27360_27456 = state_27328__$1;
(statearr_27360_27456[(2)] = inst_27224);

(statearr_27360_27456[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (13))){
var inst_27171 = (state_27328[(14)]);
var inst_27188 = fluree.db.query.range.tag_string_QMARK_(inst_27171);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27188)){
var statearr_27361_27457 = state_27328__$1;
(statearr_27361_27457[(1)] = (15));

} else {
var statearr_27362_27458 = state_27328__$1;
(statearr_27362_27458[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (22))){
var inst_27201 = (state_27328[(2)]);
var inst_27202 = fluree.db.util.async.throw_err(inst_27201);
var state_27328__$1 = state_27328;
var statearr_27363_27459 = state_27328__$1;
(statearr_27363_27459[(2)] = inst_27202);

(statearr_27363_27459[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (36))){
var inst_27209 = (state_27328[(7)]);
var inst_27169 = (state_27328[(8)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27236 = [inst_27170,inst_27209,inst_27169,inst_27172];
var inst_27237 = (new cljs.core.PersistentVector(null,4,(5),inst_27235,inst_27236,null));
var inst_27238 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_27237,opts);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(39),inst_27238);
} else {
if((state_val_27329 === (41))){
var inst_27170 = (state_27328[(10)]);
var state_27328__$1 = state_27328;
var statearr_27364_27460 = state_27328__$1;
(statearr_27364_27460[(2)] = inst_27170);

(statearr_27364_27460[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (43))){
var inst_27209 = (state_27328[(7)]);
var state_27328__$1 = state_27328;
var statearr_27365_27461 = state_27328__$1;
(statearr_27365_27461[(2)] = inst_27209);

(statearr_27365_27461[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (61))){
var inst_27209 = (state_27328[(7)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27209)){
var statearr_27366_27462 = state_27328__$1;
(statearr_27366_27462[(1)] = (64));

} else {
var statearr_27367_27463 = state_27328__$1;
(statearr_27367_27463[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (29))){
var inst_27233 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27233)){
var statearr_27368_27464 = state_27328__$1;
(statearr_27368_27464[(1)] = (36));

} else {
var statearr_27369_27465 = state_27328__$1;
(statearr_27369_27465[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (44))){
var inst_27244 = (state_27328[(19)]);
var state_27328__$1 = state_27328;
var statearr_27370_27466 = state_27328__$1;
(statearr_27370_27466[(2)] = inst_27244);

(statearr_27370_27466[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (6))){
var inst_27170 = (state_27328[(10)]);
var inst_27175 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_27170);
var inst_27176 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_27175);
var state_27328__$1 = state_27328;
var statearr_27371_27467 = state_27328__$1;
(statearr_27371_27467[(2)] = inst_27176);

(statearr_27371_27467[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (28))){
var inst_27170 = (state_27328[(10)]);
var state_27328__$1 = state_27328;
var statearr_27372_27468 = state_27328__$1;
(statearr_27372_27468[(2)] = inst_27170);

(statearr_27372_27468[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (64))){
var inst_27209 = (state_27328[(7)]);
var inst_27169 = (state_27328[(8)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27299 = [inst_27209,inst_27170,inst_27169,inst_27172];
var inst_27300 = (new cljs.core.PersistentVector(null,4,(5),inst_27298,inst_27299,null));
var inst_27301 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_27300,opts);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(67),inst_27301);
} else {
if((state_val_27329 === (51))){
var inst_27260 = (state_27328[(21)]);
var inst_27170 = (state_27328[(10)]);
var inst_27259 = (state_27328[(2)]);
var inst_27260__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_27170);
var state_27328__$1 = (function (){var statearr_27373 = state_27328;
(statearr_27373[(20)] = inst_27259);

(statearr_27373[(21)] = inst_27260__$1);

return statearr_27373;
})();
if(inst_27260__$1){
var statearr_27374_27469 = state_27328__$1;
(statearr_27374_27469[(1)] = (52));

} else {
var statearr_27375_27470 = state_27328__$1;
(statearr_27375_27470[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (25))){
var inst_27179 = (state_27328[(15)]);
var inst_27315 = (state_27328[(2)]);
var state_27328__$1 = (function (){var statearr_27376 = state_27328;
(statearr_27376[(12)] = inst_27315);

return statearr_27376;
})();
if(cljs.core.truth_(inst_27179)){
var statearr_27377_27471 = state_27328__$1;
(statearr_27377_27471[(1)] = (68));

} else {
var statearr_27378_27472 = state_27328__$1;
(statearr_27378_27472[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (34))){
var inst_27173 = (state_27328[(16)]);
var state_27328__$1 = state_27328;
var statearr_27379_27473 = state_27328__$1;
(statearr_27379_27473[(2)] = inst_27173);

(statearr_27379_27473[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (17))){
var inst_27207 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27380_27474 = state_27328__$1;
(statearr_27380_27474[(2)] = inst_27207);

(statearr_27380_27474[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (3))){
var inst_27326 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27328__$1,inst_27326);
} else {
if((state_val_27329 === (12))){
var inst_27171 = (state_27328[(14)]);
var state_27328__$1 = state_27328;
var statearr_27381_27475 = state_27328__$1;
(statearr_27381_27475[(2)] = inst_27171);

(statearr_27381_27475[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (2))){
var inst_27168 = (state_27328[(17)]);
var inst_27170 = (state_27328[(10)]);
var _ = (function (){var statearr_27382 = state_27328;
(statearr_27382[(4)] = cljs.core.cons((5),(state_27328[(4)])));

return statearr_27382;
})();
var inst_27168__$1 = fparts;
var inst_27169 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27168__$1,(0),null);
var inst_27170__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27168__$1,(1),null);
var inst_27171 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27168__$1,(2),null);
var inst_27172 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27168__$1,(3),null);
var inst_27173 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_27170__$1);
var state_27328__$1 = (function (){var statearr_27383 = state_27328;
(statearr_27383[(16)] = inst_27173);

(statearr_27383[(17)] = inst_27168__$1);

(statearr_27383[(14)] = inst_27171);

(statearr_27383[(8)] = inst_27169);

(statearr_27383[(9)] = inst_27172);

(statearr_27383[(10)] = inst_27170__$1);

return statearr_27383;
})();
if(cljs.core.truth_(inst_27170__$1)){
var statearr_27384_27476 = state_27328__$1;
(statearr_27384_27476[(1)] = (6));

} else {
var statearr_27385_27477 = state_27328__$1;
(statearr_27385_27477[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (66))){
var inst_27307 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27386_27478 = state_27328__$1;
(statearr_27386_27478[(2)] = inst_27307);

(statearr_27386_27478[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (23))){
var inst_27209 = (state_27328[(7)]);
var inst_27169 = (state_27328[(8)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27212 = [inst_27169,inst_27170,inst_27209,inst_27172];
var inst_27213 = (new cljs.core.PersistentVector(null,4,(5),inst_27211,inst_27212,null));
var inst_27214 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_27213,opts);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(26),inst_27214);
} else {
if((state_val_27329 === (47))){
var inst_27170 = (state_27328[(10)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27170)){
var statearr_27387_27479 = state_27328__$1;
(statearr_27387_27479[(1)] = (60));

} else {
var statearr_27388_27480 = state_27328__$1;
(statearr_27388_27480[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (35))){
var inst_27227 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27389_27481 = state_27328__$1;
(statearr_27389_27481[(2)] = inst_27227);

(statearr_27389_27481[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (19))){
var inst_27171 = (state_27328[(14)]);
var inst_27170 = (state_27328[(10)]);
var inst_27197 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_27170);
var inst_27198 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27197),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_27171)].join('');
var inst_27199 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_27198);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(22),inst_27199);
} else {
if((state_val_27329 === (57))){
var inst_27286 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27390_27482 = state_27328__$1;
(statearr_27390_27482[(2)] = inst_27286);

(statearr_27390_27482[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (68))){
var inst_27315 = (state_27328[(12)]);
var inst_27317 = fluree.db.query.range.coerce_tag_flakes(db,inst_27315);
var state_27328__$1 = state_27328;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27328__$1,(71),inst_27317);
} else {
if((state_val_27329 === (11))){
var inst_27184 = (state_27328[(18)]);
var inst_27184__$1 = (state_27328[(2)]);
var inst_27185 = cljs.core.not(inst_27184__$1);
var state_27328__$1 = (function (){var statearr_27392 = state_27328;
(statearr_27392[(18)] = inst_27184__$1);

return statearr_27392;
})();
if(inst_27185){
var statearr_27393_27483 = state_27328__$1;
(statearr_27393_27483[(1)] = (12));

} else {
var statearr_27394_27484 = state_27328__$1;
(statearr_27394_27484[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (9))){
var inst_27171 = (state_27328[(14)]);
var inst_27181 = typeof inst_27171 === 'string';
var state_27328__$1 = state_27328;
var statearr_27395_27485 = state_27328__$1;
(statearr_27395_27485[(2)] = inst_27181);

(statearr_27395_27485[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (5))){
var _ = (function (){var statearr_27396 = state_27328;
(statearr_27396[(4)] = cljs.core.rest((state_27328[(4)])));

return statearr_27396;
})();
var state_27328__$1 = state_27328;
var ex27391 = (state_27328__$1[(2)]);
var statearr_27397_27486 = state_27328__$1;
(statearr_27397_27486[(5)] = ex27391);


if((ex27391 instanceof Error)){
var statearr_27398_27487 = state_27328__$1;
(statearr_27398_27487[(1)] = (4));

(statearr_27398_27487[(5)] = null);

} else {
throw ex27391;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (14))){
var inst_27169 = (state_27328[(8)]);
var inst_27209 = (state_27328[(2)]);
var state_27328__$1 = (function (){var statearr_27399 = state_27328;
(statearr_27399[(7)] = inst_27209);

return statearr_27399;
})();
if(cljs.core.truth_(inst_27169)){
var statearr_27400_27488 = state_27328__$1;
(statearr_27400_27488[(1)] = (23));

} else {
var statearr_27401_27489 = state_27328__$1;
(statearr_27401_27489[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (45))){
var inst_27248 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27402_27490 = state_27328__$1;
(statearr_27402_27490[(2)] = inst_27248);

(statearr_27402_27490[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (53))){
var inst_27260 = (state_27328[(21)]);
var state_27328__$1 = state_27328;
var statearr_27403_27491 = state_27328__$1;
(statearr_27403_27491[(2)] = inst_27260);

(statearr_27403_27491[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (26))){
var inst_27216 = (state_27328[(2)]);
var inst_27217 = fluree.db.util.async.throw_err(inst_27216);
var state_27328__$1 = state_27328;
var statearr_27404_27492 = state_27328__$1;
(statearr_27404_27492[(2)] = inst_27217);

(statearr_27404_27492[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (16))){
var inst_27171 = (state_27328[(14)]);
var inst_27195 = typeof inst_27171 === 'string';
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27195)){
var statearr_27405_27493 = state_27328__$1;
(statearr_27405_27493[(1)] = (19));

} else {
var statearr_27406_27494 = state_27328__$1;
(statearr_27406_27494[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (38))){
var inst_27313 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
var statearr_27407_27495 = state_27328__$1;
(statearr_27407_27495[(2)] = inst_27313);

(statearr_27407_27495[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (30))){
var inst_27173 = (state_27328[(16)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27173)){
var statearr_27408_27496 = state_27328__$1;
(statearr_27408_27496[(1)] = (33));

} else {
var statearr_27409_27497 = state_27328__$1;
(statearr_27409_27497[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (10))){
var inst_27179 = (state_27328[(15)]);
var state_27328__$1 = state_27328;
var statearr_27410_27498 = state_27328__$1;
(statearr_27410_27498[(2)] = inst_27179);

(statearr_27410_27498[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (18))){
var inst_27192 = (state_27328[(2)]);
var inst_27193 = fluree.db.util.async.throw_err(inst_27192);
var state_27328__$1 = state_27328;
var statearr_27411_27499 = state_27328__$1;
(statearr_27411_27499[(2)] = inst_27193);

(statearr_27411_27499[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (52))){
var inst_27209 = (state_27328[(7)]);
var inst_27262 = cljs.core.int_QMARK_(inst_27209);
var state_27328__$1 = state_27328;
var statearr_27412_27500 = state_27328__$1;
(statearr_27412_27500[(2)] = inst_27262);

(statearr_27412_27500[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (67))){
var inst_27303 = (state_27328[(2)]);
var inst_27304 = fluree.db.util.async.throw_err(inst_27303);
var state_27328__$1 = state_27328;
var statearr_27413_27501 = state_27328__$1;
(statearr_27413_27501[(2)] = inst_27304);

(statearr_27413_27501[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (71))){
var inst_27319 = (state_27328[(2)]);
var inst_27320 = fluree.db.util.async.throw_err(inst_27319);
var state_27328__$1 = state_27328;
var statearr_27414_27502 = state_27328__$1;
(statearr_27414_27502[(2)] = inst_27320);

(statearr_27414_27502[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (42))){
var inst_27251 = (state_27328[(2)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27251)){
var statearr_27415_27503 = state_27328__$1;
(statearr_27415_27503[(1)] = (46));

} else {
var statearr_27416_27504 = state_27328__$1;
(statearr_27416_27504[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (37))){
var inst_27170 = (state_27328[(10)]);
var state_27328__$1 = state_27328;
if(cljs.core.truth_(inst_27170)){
var statearr_27417_27505 = state_27328__$1;
(statearr_27417_27505[(1)] = (40));

} else {
var statearr_27418_27506 = state_27328__$1;
(statearr_27418_27506[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (63))){
var inst_27294 = (state_27328[(2)]);
var inst_27295 = fluree.db.util.async.throw_err(inst_27294);
var state_27328__$1 = state_27328;
var statearr_27419_27507 = state_27328__$1;
(statearr_27419_27507[(2)] = inst_27295);

(statearr_27419_27507[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (8))){
var inst_27179 = (state_27328[(15)]);
var inst_27179__$1 = (state_27328[(2)]);
var state_27328__$1 = (function (){var statearr_27420 = state_27328;
(statearr_27420[(15)] = inst_27179__$1);

return statearr_27420;
})();
if(cljs.core.truth_(inst_27179__$1)){
var statearr_27421_27508 = state_27328__$1;
(statearr_27421_27508[(1)] = (9));

} else {
var statearr_27422_27509 = state_27328__$1;
(statearr_27422_27509[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27329 === (49))){
var inst_27253 = (state_27328[(13)]);
var inst_27179 = (state_27328[(15)]);
var inst_27209 = (state_27328[(7)]);
var inst_27173 = (state_27328[(16)]);
var inst_27168 = (state_27328[(17)]);
var inst_27169 = (state_27328[(8)]);
var inst_27184 = (state_27328[(18)]);
var inst_27172 = (state_27328[(9)]);
var inst_27170 = (state_27328[(10)]);
var inst_27255 = (function (){var obj_fn = inst_27253;
var t = inst_27172;
var p = inst_27170;
var idx_predicate_QMARK_ = inst_27173;
var o = inst_27209;
var vec__27165 = inst_27168;
var tag_predicate_QMARK_ = inst_27179;
var temp__5751__auto__ = inst_27253;
var s = inst_27169;
var o_coerce_QMARK_ = inst_27184;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_27328__$1 = state_27328;
var statearr_27423_27510 = state_27328__$1;
(statearr_27423_27510[(2)] = inst_27255);

(statearr_27423_27510[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10750__auto__ = null;
var fluree$db$query$range$state_machine__10750__auto____0 = (function (){
var statearr_27424 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27424[(0)] = fluree$db$query$range$state_machine__10750__auto__);

(statearr_27424[(1)] = (1));

return statearr_27424;
});
var fluree$db$query$range$state_machine__10750__auto____1 = (function (state_27328){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27328);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27425){var ex__10753__auto__ = e27425;
var statearr_27426_27511 = state_27328;
(statearr_27426_27511[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27328[(4)]))){
var statearr_27427_27512 = state_27328;
(statearr_27427_27512[(1)] = cljs.core.first((state_27328[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27513 = state_27328;
state_27328 = G__27513;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10750__auto__ = function(state_27328){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10750__auto____1.call(this,state_27328);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10750__auto____0;
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10750__auto____1;
return fluree$db$query$range$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27428 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27428[(6)] = c__10876__auto__);

return statearr_27428;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__27515 = arguments.length;
switch (G__27515) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27550){
var state_val_27551 = (state_27550[(1)]);
if((state_val_27551 === (7))){
var inst_27537 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_27538 = ["Invalid collection name: ",inst_27537].join('');
var inst_27539 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27540 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_27541 = cljs.core.PersistentHashMap.fromArrays(inst_27539,inst_27540);
var inst_27542 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_27538,inst_27541);
var inst_27543 = (function(){throw inst_27542})();
var state_27550__$1 = state_27550;
var statearr_27552_27572 = state_27550__$1;
(statearr_27552_27572[(2)] = inst_27543);

(statearr_27552_27572[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (1))){
var state_27550__$1 = state_27550;
var statearr_27553_27573 = state_27550__$1;
(statearr_27553_27573[(2)] = null);

(statearr_27553_27573[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (4))){
var inst_27516 = (state_27550[(2)]);
var state_27550__$1 = state_27550;
var statearr_27554_27574 = state_27550__$1;
(statearr_27554_27574[(2)] = inst_27516);

(statearr_27554_27574[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (6))){
var inst_27522 = (state_27550[(7)]);
var inst_27524 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27525 = fluree.db.flake.max_subject_id(inst_27522);
var inst_27526 = [inst_27525];
var inst_27527 = (new cljs.core.PersistentVector(null,1,(5),inst_27524,inst_27526,null));
var inst_27528 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27529 = fluree.db.flake.min_subject_id(inst_27522);
var inst_27530 = [inst_27529];
var inst_27531 = (new cljs.core.PersistentVector(null,1,(5),inst_27528,inst_27530,null));
var inst_27532 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_27527,cljs.core._LT__EQ_,inst_27531,opts);
var state_27550__$1 = state_27550;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27550__$1,(9),inst_27532);
} else {
if((state_val_27551 === (3))){
var inst_27548 = (state_27550[(2)]);
var state_27550__$1 = state_27550;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27550__$1,inst_27548);
} else {
if((state_val_27551 === (2))){
var inst_27522 = (state_27550[(7)]);
var _ = (function (){var statearr_27556 = state_27550;
(statearr_27556[(4)] = cljs.core.cons((5),(state_27550[(4)])));

return statearr_27556;
})();
var inst_27522__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_27550__$1 = (function (){var statearr_27557 = state_27550;
(statearr_27557[(7)] = inst_27522__$1);

return statearr_27557;
})();
if(cljs.core.truth_(inst_27522__$1)){
var statearr_27558_27575 = state_27550__$1;
(statearr_27558_27575[(1)] = (6));

} else {
var statearr_27559_27576 = state_27550__$1;
(statearr_27559_27576[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (9))){
var inst_27534 = (state_27550[(2)]);
var inst_27535 = fluree.db.util.async.throw_err(inst_27534);
var state_27550__$1 = state_27550;
var statearr_27560_27577 = state_27550__$1;
(statearr_27560_27577[(2)] = inst_27535);

(statearr_27560_27577[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (5))){
var _ = (function (){var statearr_27561 = state_27550;
(statearr_27561[(4)] = cljs.core.rest((state_27550[(4)])));

return statearr_27561;
})();
var state_27550__$1 = state_27550;
var ex27555 = (state_27550__$1[(2)]);
var statearr_27562_27578 = state_27550__$1;
(statearr_27562_27578[(5)] = ex27555);


var statearr_27563_27579 = state_27550__$1;
(statearr_27563_27579[(1)] = (4));

(statearr_27563_27579[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_27551 === (8))){
var inst_27545 = (state_27550[(2)]);
var _ = (function (){var statearr_27564 = state_27550;
(statearr_27564[(4)] = cljs.core.rest((state_27550[(4)])));

return statearr_27564;
})();
var state_27550__$1 = state_27550;
var statearr_27565_27580 = state_27550__$1;
(statearr_27565_27580[(2)] = inst_27545);

(statearr_27565_27580[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__10750__auto__ = null;
var fluree$db$query$range$state_machine__10750__auto____0 = (function (){
var statearr_27566 = [null,null,null,null,null,null,null,null];
(statearr_27566[(0)] = fluree$db$query$range$state_machine__10750__auto__);

(statearr_27566[(1)] = (1));

return statearr_27566;
});
var fluree$db$query$range$state_machine__10750__auto____1 = (function (state_27550){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27550);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27567){var ex__10753__auto__ = e27567;
var statearr_27568_27581 = state_27550;
(statearr_27568_27581[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27550[(4)]))){
var statearr_27569_27582 = state_27550;
(statearr_27569_27582[(1)] = cljs.core.first((state_27550[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27583 = state_27550;
state_27550 = G__27583;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__10750__auto__ = function(state_27550){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__10750__auto____1.call(this,state_27550);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__10750__auto____0;
fluree$db$query$range$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__10750__auto____1;
return fluree$db$query$range$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27570 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27570[(6)] = c__10876__auto__);

return statearr_27570;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__27587 = flakes;
var vec__27588 = G__27587;
var seq__27589 = cljs.core.seq(vec__27588);
var first__27590 = cljs.core.first(seq__27589);
var seq__27589__$1 = cljs.core.next(seq__27589);
var flake_SINGLEQUOTE_ = first__27590;
var r = seq__27589__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__27587__$1 = G__27587;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__27596 = G__27587__$1;
var seq__27597 = cljs.core.seq(vec__27596);
var first__27598 = cljs.core.first(seq__27597);
var seq__27597__$1 = cljs.core.next(seq__27597);
var flake_SINGLEQUOTE___$1 = first__27598;
var r__$1 = seq__27597__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e27600){var e = e27600;
return null;
}})();
var map__27599 = cmd_map;
var map__27599__$1 = cljs.core.__destructure_map(map__27599);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27599__$1,cljs.core.cst$kw$expire);
var G__27601 = r__$1;
var G__27602 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__27587__$1 = G__27601;
result_STAR___$1 = G__27602;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__27611 = blocks;
var vec__27612 = G__27611;
var seq__27613 = cljs.core.seq(vec__27612);
var first__27614 = cljs.core.first(seq__27613);
var seq__27613__$1 = cljs.core.next(seq__27613);
var block_SINGLEQUOTE_ = first__27614;
var r = seq__27613__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__27611__$1 = G__27611;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__27619 = G__27611__$1;
var seq__27620 = cljs.core.seq(vec__27619);
var first__27621 = cljs.core.first(seq__27620);
var seq__27620__$1 = cljs.core.next(seq__27620);
var block_SINGLEQUOTE___$1 = first__27621;
var r__$1 = seq__27620__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__27622 = block_SINGLEQUOTE___$1;
var map__27622__$1 = cljs.core.__destructure_map(map__27622);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27622__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27622__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__27622__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27603_SHARP_){
var f = p1__27603_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27604_SHARP_){
var f = p1__27604_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27605_SHARP_){
var f = p1__27605_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,instant,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27606_SHARP_){
var f = p1__27606_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,instant,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__27607_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__27607_SHARP_.p,(106));
});})(G__27611__$1,result_STAR___$1,map__27622,map__27622__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__27619,seq__27620,first__27621,seq__27620__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__27611,vec__27612,seq__27613,first__27614,seq__27613__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__27623 = r__$1;
var G__27624 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__27611__$1 = G__27623;
result_STAR___$1 = G__27624;
continue;
}
break;
}
});
