// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27642){
var state_val_27643 = (state_27642[(1)]);
if((state_val_27643 === (1))){
var state_27642__$1 = state_27642;
var statearr_27644_27658 = state_27642__$1;
(statearr_27644_27658[(2)] = null);

(statearr_27644_27658[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27643 === (2))){
var _ = (function (){var statearr_27645 = state_27642;
(statearr_27645[(4)] = cljs.core.cons((5),(state_27642[(4)])));

return statearr_27645;
})();
var inst_27633 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_27642__$1 = state_27642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27642__$1,(6),inst_27633);
} else {
if((state_val_27643 === (3))){
var inst_27640 = (state_27642[(2)]);
var state_27642__$1 = state_27642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27642__$1,inst_27640);
} else {
if((state_val_27643 === (4))){
var inst_27627 = (state_27642[(2)]);
var state_27642__$1 = state_27642;
var statearr_27647_27659 = state_27642__$1;
(statearr_27647_27659[(2)] = inst_27627);

(statearr_27647_27659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27643 === (5))){
var _ = (function (){var statearr_27648 = state_27642;
(statearr_27648[(4)] = cljs.core.rest((state_27642[(4)])));

return statearr_27648;
})();
var state_27642__$1 = state_27642;
var ex27646 = (state_27642__$1[(2)]);
var statearr_27649_27660 = state_27642__$1;
(statearr_27649_27660[(5)] = ex27646);


if((ex27646 instanceof Error)){
var statearr_27650_27661 = state_27642__$1;
(statearr_27650_27661[(1)] = (4));

(statearr_27650_27661[(5)] = null);

} else {
throw ex27646;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27643 === (6))){
var inst_27635 = (state_27642[(2)]);
var inst_27636 = fluree.db.util.async.throw_err(inst_27635);
var inst_27637 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_27636);
var _ = (function (){var statearr_27651 = state_27642;
(statearr_27651[(4)] = cljs.core.rest((state_27642[(4)])));

return statearr_27651;
})();
var state_27642__$1 = state_27642;
var statearr_27652_27662 = state_27642__$1;
(statearr_27652_27662[(2)] = inst_27637);

(statearr_27652_27662[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____0 = (function (){
var statearr_27653 = [null,null,null,null,null,null,null];
(statearr_27653[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__);

(statearr_27653[(1)] = (1));

return statearr_27653;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____1 = (function (state_27642){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27642);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27654){var ex__10753__auto__ = e27654;
var statearr_27655_27663 = state_27642;
(statearr_27655_27663[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27642[(4)]))){
var statearr_27656_27664 = state_27642;
(statearr_27656_27664[(1)] = cljs.core.first((state_27642[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27665 = state_27642;
state_27642 = G__27665;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__ = function(state_27642){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____1.call(this,state_27642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27657 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27657[(6)] = c__10876__auto__);

return statearr_27657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27697){
var state_val_27698 = (state_27697[(1)]);
if((state_val_27698 === (7))){
var inst_27681 = (state_27697[(7)]);
var inst_27683 = cljs.core.empty_QMARK_(inst_27681);
var inst_27684 = (!(inst_27683));
var state_27697__$1 = state_27697;
var statearr_27699_27723 = state_27697__$1;
(statearr_27699_27723[(2)] = inst_27684);

(statearr_27699_27723[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (1))){
var state_27697__$1 = state_27697;
var statearr_27700_27724 = state_27697__$1;
(statearr_27700_27724[(2)] = null);

(statearr_27700_27724[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (4))){
var inst_27667 = (state_27697[(2)]);
var state_27697__$1 = state_27697;
var statearr_27701_27725 = state_27697__$1;
(statearr_27701_27725[(2)] = inst_27667);

(statearr_27701_27725[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (6))){
var inst_27681 = (state_27697[(7)]);
var inst_27673 = (state_27697[(8)]);
var inst_27679 = (state_27697[(2)]);
var inst_27680 = fluree.db.util.async.throw_err(inst_27679);
var inst_27681__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_27673,inst_27680);
var state_27697__$1 = (function (){var statearr_27702 = state_27697;
(statearr_27702[(7)] = inst_27681__$1);

return statearr_27702;
})();
if(cljs.core.truth_(inst_27681__$1)){
var statearr_27703_27726 = state_27697__$1;
(statearr_27703_27726[(1)] = (7));

} else {
var statearr_27704_27727 = state_27697__$1;
(statearr_27704_27727[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (3))){
var inst_27695 = (state_27697[(2)]);
var state_27697__$1 = state_27697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27697__$1,inst_27695);
} else {
if((state_val_27698 === (12))){
var inst_27692 = (state_27697[(2)]);
var _ = (function (){var statearr_27705 = state_27697;
(statearr_27705[(4)] = cljs.core.rest((state_27697[(4)])));

return statearr_27705;
})();
var state_27697__$1 = state_27697;
var statearr_27706_27728 = state_27697__$1;
(statearr_27706_27728[(2)] = inst_27692);

(statearr_27706_27728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (2))){
var _ = (function (){var statearr_27707 = state_27697;
(statearr_27707[(4)] = cljs.core.cons((5),(state_27697[(4)])));

return statearr_27707;
})();
var inst_27673 = (function (){return (function (p1__27666_SHARP_){
return p1__27666_SHARP_.o;
});
})();
var inst_27674 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27675 = [pred_id];
var inst_27676 = (new cljs.core.PersistentVector(null,1,(5),inst_27674,inst_27675,null));
var inst_27677 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_27676);
var state_27697__$1 = (function (){var statearr_27708 = state_27697;
(statearr_27708[(8)] = inst_27673);

return statearr_27708;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27697__$1,(6),inst_27677);
} else {
if((state_val_27698 === (11))){
var state_27697__$1 = state_27697;
var statearr_27710_27729 = state_27697__$1;
(statearr_27710_27729[(2)] = true);

(statearr_27710_27729[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (9))){
var inst_27687 = (state_27697[(2)]);
var state_27697__$1 = state_27697;
if(cljs.core.truth_(inst_27687)){
var statearr_27711_27730 = state_27697__$1;
(statearr_27711_27730[(1)] = (10));

} else {
var statearr_27712_27731 = state_27697__$1;
(statearr_27712_27731[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (5))){
var _ = (function (){var statearr_27713 = state_27697;
(statearr_27713[(4)] = cljs.core.rest((state_27697[(4)])));

return statearr_27713;
})();
var state_27697__$1 = state_27697;
var ex27709 = (state_27697__$1[(2)]);
var statearr_27714_27732 = state_27697__$1;
(statearr_27714_27732[(5)] = ex27709);


if((ex27709 instanceof Error)){
var statearr_27715_27733 = state_27697__$1;
(statearr_27715_27733[(1)] = (4));

(statearr_27715_27733[(5)] = null);

} else {
throw ex27709;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (10))){
var inst_27681 = (state_27697[(7)]);
var inst_27689 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_27681);
var state_27697__$1 = state_27697;
var statearr_27716_27734 = state_27697__$1;
(statearr_27716_27734[(2)] = inst_27689);

(statearr_27716_27734[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27698 === (8))){
var inst_27681 = (state_27697[(7)]);
var state_27697__$1 = state_27697;
var statearr_27717_27735 = state_27697__$1;
(statearr_27717_27735[(2)] = inst_27681);

(statearr_27717_27735[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_27718 = [null,null,null,null,null,null,null,null,null];
(statearr_27718[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__);

(statearr_27718[(1)] = (1));

return statearr_27718;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____1 = (function (state_27697){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27697);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27719){var ex__10753__auto__ = e27719;
var statearr_27720_27736 = state_27697;
(statearr_27720_27736[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27697[(4)]))){
var statearr_27721_27737 = state_27697;
(statearr_27721_27737[(1)] = cljs.core.first((state_27697[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27738 = state_27697;
state_27697 = G__27738;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__ = function(state_27697){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____1.call(this,state_27697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27722 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27722[(6)] = c__10876__auto__);

return statearr_27722;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_27819){
var state_val_27820 = (state_27819[(1)]);
if((state_val_27820 === (7))){
var state_27819__$1 = state_27819;
var statearr_27821_27859 = state_27819__$1;
(statearr_27821_27859[(2)] = flakes);

(statearr_27821_27859[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (20))){
var inst_27776 = (state_27819[(7)]);
var inst_27809 = (state_27819[(2)]);
var inst_27768 = inst_27776;
var inst_27769 = inst_27809;
var state_27819__$1 = (function (){var statearr_27822 = state_27819;
(statearr_27822[(8)] = inst_27769);

(statearr_27822[(9)] = inst_27768);

return statearr_27822;
})();
var statearr_27823_27860 = state_27819__$1;
(statearr_27823_27860[(2)] = null);

(statearr_27823_27860[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (1))){
var state_27819__$1 = state_27819;
var statearr_27824_27861 = state_27819__$1;
(statearr_27824_27861[(2)] = null);

(statearr_27824_27861[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (4))){
var inst_27741 = (state_27819[(2)]);
var state_27819__$1 = state_27819;
var statearr_27825_27862 = state_27819__$1;
(statearr_27825_27862[(2)] = inst_27741);

(statearr_27825_27862[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (15))){
var inst_27775 = (state_27819[(10)]);
var inst_27793 = inst_27775.o;
var state_27819__$1 = state_27819;
var statearr_27826_27863 = state_27819__$1;
(statearr_27826_27863[(2)] = inst_27793);

(statearr_27826_27863[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (13))){
var inst_27812 = (state_27819[(2)]);
var state_27819__$1 = state_27819;
var statearr_27827_27864 = state_27819__$1;
(statearr_27827_27864[(2)] = inst_27812);

(statearr_27827_27864[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (6))){
var inst_27748 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_27819__$1 = state_27819;
var statearr_27828_27865 = state_27819__$1;
(statearr_27828_27865[(2)] = inst_27748);

(statearr_27828_27865[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (17))){
var inst_27790 = (state_27819[(2)]);
var inst_27791 = fluree.db.util.async.throw_err(inst_27790);
var state_27819__$1 = state_27819;
var statearr_27829_27866 = state_27819__$1;
(statearr_27829_27866[(2)] = inst_27791);

(statearr_27829_27866[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (3))){
var inst_27817 = (state_27819[(2)]);
var state_27819__$1 = state_27819;
return cljs.core.async.impl.ioc_helpers.return_chan(state_27819__$1,inst_27817);
} else {
if((state_val_27820 === (12))){
var inst_27775 = (state_27819[(10)]);
var inst_27782 = (state_27819[(11)]);
var inst_27780 = inst_27775.p;
var inst_27781 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_27780);
var inst_27782__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_27781);
var inst_27783 = inst_27775.op;
var inst_27784 = inst_27783 === false;
var inst_27785 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_27782__$1);
var state_27819__$1 = (function (){var statearr_27830 = state_27819;
(statearr_27830[(12)] = inst_27784);

(statearr_27830[(11)] = inst_27782__$1);

return statearr_27830;
})();
if(inst_27785){
var statearr_27831_27867 = state_27819__$1;
(statearr_27831_27867[(1)] = (14));

} else {
var statearr_27832_27868 = state_27819__$1;
(statearr_27832_27868[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (2))){
var _ = (function (){var statearr_27833 = state_27819;
(statearr_27833[(4)] = cljs.core.cons((5),(state_27819[(4)])));

return statearr_27833;
})();
var state_27819__$1 = state_27819;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_27834_27869 = state_27819__$1;
(statearr_27834_27869[(1)] = (6));

} else {
var statearr_27835_27870 = state_27819__$1;
(statearr_27835_27870[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (19))){
var inst_27769 = (state_27819[(8)]);
var inst_27775 = (state_27819[(10)]);
var inst_27795 = (state_27819[(13)]);
var inst_27782 = (state_27819[(11)]);
var inst_27803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27804 = inst_27775.s;
var inst_27805 = [inst_27804,inst_27782,cljs.core.cst$kw$new];
var inst_27806 = (new cljs.core.PersistentVector(null,3,(5),inst_27803,inst_27805,null));
var inst_27807 = cljs.core.assoc_in(inst_27769,inst_27806,inst_27795);
var state_27819__$1 = state_27819;
var statearr_27836_27871 = state_27819__$1;
(statearr_27836_27871[(2)] = inst_27807);

(statearr_27836_27871[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (11))){
var inst_27769 = (state_27819[(8)]);
var state_27819__$1 = state_27819;
var statearr_27838_27872 = state_27819__$1;
(statearr_27838_27872[(2)] = inst_27769);

(statearr_27838_27872[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (9))){
var inst_27775 = (state_27819[(10)]);
var inst_27768 = (state_27819[(9)]);
var inst_27774 = cljs.core.seq(inst_27768);
var inst_27775__$1 = cljs.core.first(inst_27774);
var inst_27776 = cljs.core.next(inst_27774);
var inst_27777 = cljs.core.not(inst_27775__$1);
var state_27819__$1 = (function (){var statearr_27839 = state_27819;
(statearr_27839[(10)] = inst_27775__$1);

(statearr_27839[(7)] = inst_27776);

return statearr_27839;
})();
if(inst_27777){
var statearr_27840_27873 = state_27819__$1;
(statearr_27840_27873[(1)] = (11));

} else {
var statearr_27841_27874 = state_27819__$1;
(statearr_27841_27874[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (5))){
var _ = (function (){var statearr_27842 = state_27819;
(statearr_27842[(4)] = cljs.core.rest((state_27819[(4)])));

return statearr_27842;
})();
var state_27819__$1 = state_27819;
var ex27837 = (state_27819__$1[(2)]);
var statearr_27843_27875 = state_27819__$1;
(statearr_27843_27875[(5)] = ex27837);


if((ex27837 instanceof Error)){
var statearr_27844_27876 = state_27819__$1;
(statearr_27844_27876[(1)] = (4));

(statearr_27844_27876[(5)] = null);

} else {
throw ex27837;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (14))){
var inst_27775 = (state_27819[(10)]);
var inst_27787 = inst_27775.o;
var inst_27788 = fluree.db.query.schema.convert_type_to_kw(inst_27787,db);
var state_27819__$1 = state_27819;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_27819__$1,(17),inst_27788);
} else {
if((state_val_27820 === (16))){
var inst_27784 = (state_27819[(12)]);
var inst_27795 = (state_27819[(2)]);
var state_27819__$1 = (function (){var statearr_27845 = state_27819;
(statearr_27845[(13)] = inst_27795);

return statearr_27845;
})();
if(cljs.core.truth_(inst_27784)){
var statearr_27846_27877 = state_27819__$1;
(statearr_27846_27877[(1)] = (18));

} else {
var statearr_27847_27878 = state_27819__$1;
(statearr_27847_27878[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (10))){
var inst_27814 = (state_27819[(2)]);
var _ = (function (){var statearr_27848 = state_27819;
(statearr_27848[(4)] = cljs.core.rest((state_27819[(4)])));

return statearr_27848;
})();
var state_27819__$1 = state_27819;
var statearr_27849_27879 = state_27819__$1;
(statearr_27849_27879[(2)] = inst_27814);

(statearr_27849_27879[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (18))){
var inst_27769 = (state_27819[(8)]);
var inst_27775 = (state_27819[(10)]);
var inst_27795 = (state_27819[(13)]);
var inst_27782 = (state_27819[(11)]);
var inst_27797 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_27798 = inst_27775.s;
var inst_27799 = [inst_27798,inst_27782,cljs.core.cst$kw$old];
var inst_27800 = (new cljs.core.PersistentVector(null,3,(5),inst_27797,inst_27799,null));
var inst_27801 = cljs.core.assoc_in(inst_27769,inst_27800,inst_27795);
var state_27819__$1 = state_27819;
var statearr_27850_27880 = state_27819__$1;
(statearr_27850_27880[(2)] = inst_27801);

(statearr_27850_27880[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_27820 === (8))){
var inst_27751 = (state_27819[(2)]);
var inst_27752 = cljs.core.PersistentHashSet.EMPTY;
var inst_27753 = cljs.core.vals(tempids);
var inst_27754 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_27752,inst_27753);
var inst_27755 = (function (){var pred_flakes = inst_27751;
var is_new_QMARK_ = inst_27754;
return (function (p1__27740_SHARP_,p2__27739_SHARP_){
var f = p2__27739_SHARP_;
return cljs.core.assoc_in(p1__27740_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__27851 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__27851) : is_new_QMARK_.call(null,G__27851));
})()));
});
})();
var inst_27756 = cljs.core.PersistentHashMap.EMPTY;
var inst_27757 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_27755,inst_27756,inst_27751);
var inst_27765 = cljs.core.seq(inst_27751);
var inst_27766 = cljs.core.first(inst_27765);
var inst_27767 = cljs.core.next(inst_27765);
var inst_27768 = inst_27751;
var inst_27769 = inst_27757;
var state_27819__$1 = (function (){var statearr_27852 = state_27819;
(statearr_27852[(8)] = inst_27769);

(statearr_27852[(14)] = inst_27767);

(statearr_27852[(9)] = inst_27768);

(statearr_27852[(15)] = inst_27766);

return statearr_27852;
})();
var statearr_27853_27881 = state_27819__$1;
(statearr_27853_27881[(2)] = null);

(statearr_27853_27881[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____0 = (function (){
var statearr_27854 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_27854[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__);

(statearr_27854[(1)] = (1));

return statearr_27854;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____1 = (function (state_27819){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_27819);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e27855){var ex__10753__auto__ = e27855;
var statearr_27856_27882 = state_27819;
(statearr_27856_27882[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_27819[(4)]))){
var statearr_27857_27883 = state_27819;
(statearr_27857_27883[(1)] = cljs.core.first((state_27819[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__27884 = state_27819;
state_27819 = G__27884;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__ = function(state_27819){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____1.call(this,state_27819);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_27858 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_27858[(6)] = c__10876__auto__);

return statearr_27858;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__27886 = arguments.length;
switch (G__27886) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__27889 = arguments.length;
switch (G__27889) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28201){
var state_val_28202 = (state_28201[(1)]);
if((state_val_28202 === (121))){
var inst_28156 = (state_28201[(7)]);
var state_28201__$1 = state_28201;
var statearr_28203_28396 = state_28201__$1;
(statearr_28203_28396[(2)] = inst_28156);

(statearr_28203_28396[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (65))){
var inst_28055 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28055)){
var statearr_28204_28397 = state_28201__$1;
(statearr_28204_28397[(1)] = (66));

} else {
var statearr_28205_28398 = state_28201__$1;
(statearr_28205_28398[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (70))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28065 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_28066 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_28065,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,3,inst_28065,null));
var inst_28067 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28066,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28066,null));
var inst_28068 = (inst_28067.cljs$core$IFn$_invoke$arity$1 ? inst_28067.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28067.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28068)){
var statearr_28206_28399 = state_28201__$1;
(statearr_28206_28399[(1)] = (72));

} else {
var statearr_28207_28400 = state_28201__$1;
(statearr_28207_28400[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (62))){
var inst_28045 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28208_28401 = state_28201__$1;
(statearr_28208_28401[(2)] = inst_28045);

(statearr_28208_28401[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (74))){
var inst_28151 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28209_28402 = state_28201__$1;
(statearr_28209_28402[(2)] = inst_28151);

(statearr_28209_28402[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (110))){
var inst_28178 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28178)){
var statearr_28210_28403 = state_28201__$1;
(statearr_28210_28403[(1)] = (117));

} else {
var statearr_28211_28404 = state_28201__$1;
(statearr_28211_28404[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (7))){
var inst_28196 = (state_28201[(2)]);
var _ = (function (){var statearr_28212 = state_28201;
(statearr_28212[(4)] = cljs.core.rest((state_28201[(4)])));

return statearr_28212;
})();
var state_28201__$1 = state_28201;
var statearr_28213_28405 = state_28201__$1;
(statearr_28213_28405[(2)] = inst_28196);

(statearr_28213_28405[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (59))){
var inst_27929 = (state_28201[(10)]);
var inst_28049 = (state_28201[(11)]);
var inst_28048 = (state_28201[(2)]);
var inst_28049__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28214 = state_28201;
(statearr_28214[(12)] = inst_28048);

(statearr_28214[(11)] = inst_28049__$1);

return statearr_28214;
})();
if(cljs.core.truth_(inst_28049__$1)){
var statearr_28215_28406 = state_28201__$1;
(statearr_28215_28406[(1)] = (63));

} else {
var statearr_28216_28407 = state_28201__$1;
(statearr_28216_28407[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (86))){
var inst_28091 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28217_28408 = state_28201__$1;
(statearr_28217_28408[(2)] = inst_28091);

(statearr_28217_28408[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (20))){
var inst_27929 = (state_28201[(10)]);
var inst_27955 = (state_28201[(13)]);
var inst_27955__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28218 = state_28201;
(statearr_28218[(13)] = inst_27955__$1);

return statearr_28218;
})();
if(cljs.core.truth_(inst_27955__$1)){
var statearr_28219_28409 = state_28201__$1;
(statearr_28219_28409[(1)] = (23));

} else {
var statearr_28220_28410 = state_28201__$1;
(statearr_28220_28410[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (72))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28070 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28221_28411 = state_28201__$1;
(statearr_28221_28411[(2)] = inst_28070);

(statearr_28221_28411[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (58))){
var inst_28010 = (state_28201[(14)]);
var state_28201__$1 = state_28201;
var statearr_28222_28412 = state_28201__$1;
(statearr_28222_28412[(2)] = inst_28010);

(statearr_28222_28412[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (60))){
var inst_27917 = (state_28201[(15)]);
var inst_27928 = (state_28201[(16)]);
var inst_28036 = fluree.db.dbproto._p_prop(inst_27917,cljs.core.cst$kw$name,inst_27928);
var inst_28037 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_28036)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_28038 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_28039 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_28040 = cljs.core.PersistentHashMap.fromArrays(inst_28038,inst_28039);
var inst_28041 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_28037,inst_28040);
var inst_28042 = (function(){throw inst_28041})();
var state_28201__$1 = state_28201;
var statearr_28223_28413 = state_28201__$1;
(statearr_28223_28413[(2)] = inst_28042);

(statearr_28223_28413[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (27))){
var inst_27958 = (state_28201[(17)]);
var state_28201__$1 = state_28201;
var statearr_28224_28414 = state_28201__$1;
(statearr_28224_28414[(2)] = inst_27958);

(statearr_28224_28414[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (1))){
var state_28201__$1 = state_28201;
var statearr_28225_28415 = state_28201__$1;
(statearr_28225_28415[(2)] = null);

(statearr_28225_28415[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (69))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28226_28416 = state_28201__$1;
(statearr_28226_28416[(2)] = inst_28048);

(statearr_28226_28416[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (101))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28129 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28227_28417 = state_28201__$1;
(statearr_28227_28417[(2)] = inst_28129);

(statearr_28227_28417[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (24))){
var inst_27955 = (state_28201[(13)]);
var state_28201__$1 = state_28201;
var statearr_28228_28418 = state_28201__$1;
(statearr_28228_28418[(2)] = inst_27955);

(statearr_28228_28418[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (102))){
var inst_28131 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28229_28419 = state_28201__$1;
(statearr_28229_28419[(2)] = inst_28131);

(statearr_28229_28419[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (55))){
var inst_28027 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28230_28420 = state_28201__$1;
(statearr_28230_28420[(2)] = inst_28027);

(statearr_28230_28420[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (85))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28089 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28231_28421 = state_28201__$1;
(statearr_28231_28421[(2)] = inst_28089);

(statearr_28231_28421[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (39))){
var inst_27992 = (state_28201[(18)]);
var state_28201__$1 = state_28201;
var statearr_28232_28422 = state_28201__$1;
(statearr_28232_28422[(2)] = inst_27992);

(statearr_28232_28422[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (88))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28233_28423 = state_28201__$1;
(statearr_28233_28423[(2)] = inst_28048);

(statearr_28233_28423[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (46))){
var inst_27929 = (state_28201[(10)]);
var inst_28011 = (state_28201[(19)]);
var inst_28010 = (state_28201[(2)]);
var inst_28011__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28234 = state_28201;
(statearr_28234[(19)] = inst_28011__$1);

(statearr_28234[(14)] = inst_28010);

return statearr_28234;
})();
if(cljs.core.truth_(inst_28011__$1)){
var statearr_28235_28424 = state_28201__$1;
(statearr_28235_28424[(1)] = (47));

} else {
var statearr_28236_28425 = state_28201__$1;
(statearr_28236_28425[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (4))){
var inst_27890 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28237_28426 = state_28201__$1;
(statearr_28237_28426[(2)] = inst_27890);

(statearr_28237_28426[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (77))){
var inst_28149 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28238_28427 = state_28201__$1;
(statearr_28238_28427[(2)] = inst_28149);

(statearr_28238_28427[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (106))){
var inst_28141 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28239_28428 = state_28201__$1;
(statearr_28239_28428[(2)] = inst_28141);

(statearr_28239_28428[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (119))){
var inst_27927 = (state_28201[(20)]);
var inst_28191 = (state_28201[(2)]);
var inst_27916 = inst_27927;
var inst_27917 = inst_28191;
var state_28201__$1 = (function (){var statearr_28240 = state_28201;
(statearr_28240[(15)] = inst_27917);

(statearr_28240[(21)] = inst_27916);

return statearr_28240;
})();
var statearr_28241_28429 = state_28201__$1;
(statearr_28241_28429[(2)] = null);

(statearr_28241_28429[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (95))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28113 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_28114 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_28113,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,5,inst_28113,null));
var inst_28115 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28114,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28114,null));
var inst_28116 = (inst_28115.cljs$core$IFn$_invoke$arity$1 ? inst_28115.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28115.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28116)){
var statearr_28242_28430 = state_28201__$1;
(statearr_28242_28430[(1)] = (96));

} else {
var statearr_28243_28431 = state_28201__$1;
(statearr_28243_28431[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (54))){
var inst_28018 = (state_28201[(22)]);
var state_28201__$1 = state_28201;
var statearr_28244_28432 = state_28201__$1;
(statearr_28244_28432[(2)] = inst_28018);

(statearr_28244_28432[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (92))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28245_28433 = state_28201__$1;
(statearr_28245_28433[(2)] = inst_28048);

(statearr_28245_28433[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (104))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28246_28434 = state_28201__$1;
(statearr_28246_28434[(2)] = inst_28048);

(statearr_28246_28434[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (15))){
var inst_27937 = (state_28201[(23)]);
var state_28201__$1 = state_28201;
var statearr_28247_28435 = state_28201__$1;
(statearr_28247_28435[(2)] = inst_27937);

(statearr_28247_28435[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (48))){
var inst_28011 = (state_28201[(19)]);
var state_28201__$1 = state_28201;
var statearr_28248_28436 = state_28201__$1;
(statearr_28248_28436[(2)] = inst_28011);

(statearr_28248_28436[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (50))){
var inst_27929 = (state_28201[(10)]);
var inst_28018 = (state_28201[(22)]);
var inst_28016 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28017 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_28016);
var inst_28018__$1 = inst_28017 === true;
var state_28201__$1 = (function (){var statearr_28249 = state_28201;
(statearr_28249[(22)] = inst_28018__$1);

return statearr_28249;
})();
if(cljs.core.truth_(inst_28018__$1)){
var statearr_28250_28437 = state_28201__$1;
(statearr_28250_28437[(1)] = (53));

} else {
var statearr_28251_28438 = state_28201__$1;
(statearr_28251_28438[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (116))){
var inst_28172 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28252_28439 = state_28201__$1;
(statearr_28252_28439[(2)] = inst_28172);

(statearr_28252_28439[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (75))){
var inst_28061 = (state_28201[(9)]);
var state_28201__$1 = state_28201;
var G__28253_28440 = inst_28061;
var G__28253_28441__$1 = (((G__28253_28440 instanceof cljs.core.Keyword))?G__28253_28440.fqn:null);
switch (G__28253_28441__$1) {
case "long":
var statearr_28254_28443 = state_28201__$1;
(statearr_28254_28443[(1)] = (79));


break;
case "bigint":
var statearr_28255_28444 = state_28201__$1;
(statearr_28255_28444[(1)] = (83));


break;
case "double":
var statearr_28256_28445 = state_28201__$1;
(statearr_28256_28445[(1)] = (87));


break;
case "float":
var statearr_28257_28446 = state_28201__$1;
(statearr_28257_28446[(1)] = (91));


break;
case "bigdec":
var statearr_28258_28447 = state_28201__$1;
(statearr_28258_28447[(1)] = (95));


break;
case "string":
var statearr_28259_28448 = state_28201__$1;
(statearr_28259_28448[(1)] = (99));


break;
case "instant":
var statearr_28260_28449 = state_28201__$1;
(statearr_28260_28449[(1)] = (103));


break;
default:
var statearr_28261_28450 = state_28201__$1;
(statearr_28261_28450[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (99))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28123 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_28124 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_28123,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,5,inst_28123,null));
var inst_28125 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28124,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28124,null));
var inst_28126 = (inst_28125.cljs$core$IFn$_invoke$arity$1 ? inst_28125.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28125.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28126)){
var statearr_28262_28451 = state_28201__$1;
(statearr_28262_28451[(1)] = (100));

} else {
var statearr_28263_28452 = state_28201__$1;
(statearr_28263_28452[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (21))){
var inst_27953 = (state_28201[(24)]);
var state_28201__$1 = state_28201;
var statearr_28264_28453 = state_28201__$1;
(statearr_28264_28453[(2)] = inst_27953);

(statearr_28264_28453[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (31))){
var inst_27969 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28265_28454 = state_28201__$1;
(statearr_28265_28454[(2)] = inst_27969);

(statearr_28265_28454[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (113))){
var inst_28175 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28266_28455 = state_28201__$1;
(statearr_28266_28455[(2)] = inst_28175);

(statearr_28266_28455[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (32))){
var state_28201__$1 = state_28201;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28267_28456 = state_28201__$1;
(statearr_28267_28456[(1)] = (35));

} else {
var statearr_28268_28457 = state_28201__$1;
(statearr_28268_28457[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (40))){
var inst_28005 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28005)){
var statearr_28269_28458 = state_28201__$1;
(statearr_28269_28458[(1)] = (44));

} else {
var statearr_28270_28459 = state_28201__$1;
(statearr_28270_28459[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (91))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28103 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_28104 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_28103,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,3,inst_28103,null));
var inst_28105 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28104,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28104,null));
var inst_28106 = (inst_28105.cljs$core$IFn$_invoke$arity$1 ? inst_28105.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28105.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28106)){
var statearr_28271_28460 = state_28201__$1;
(statearr_28271_28460[(1)] = (92));

} else {
var statearr_28272_28461 = state_28201__$1;
(statearr_28272_28461[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (117))){
var state_28201__$1 = state_28201;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28273_28462 = state_28201__$1;
(statearr_28273_28462[(1)] = (120));

} else {
var statearr_28274_28463 = state_28201__$1;
(statearr_28274_28463[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (108))){
var inst_27929 = (state_28201[(10)]);
var inst_28160 = (state_28201[(25)]);
var inst_28160__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28275 = state_28201;
(statearr_28275[(25)] = inst_28160__$1);

return statearr_28275;
})();
if(cljs.core.truth_(inst_28160__$1)){
var statearr_28276_28464 = state_28201__$1;
(statearr_28276_28464[(1)] = (111));

} else {
var statearr_28277_28465 = state_28201__$1;
(statearr_28277_28465[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (56))){
var inst_28022 = (state_28201[(2)]);
var inst_28023 = fluree.db.util.async.throw_err(inst_28022);
var inst_28024 = cljs.core.not(inst_28023);
var state_28201__$1 = state_28201;
var statearr_28278_28466 = state_28201__$1;
(statearr_28278_28466[(2)] = inst_28024);

(statearr_28278_28466[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (33))){
var inst_27952 = (state_28201[(26)]);
var state_28201__$1 = state_28201;
var statearr_28279_28467 = state_28201__$1;
(statearr_28279_28467[(2)] = inst_27952);

(statearr_28279_28467[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (13))){
var inst_27947 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_27947)){
var statearr_28280_28468 = state_28201__$1;
(statearr_28280_28468[(1)] = (17));

} else {
var statearr_28281_28469 = state_28201__$1;
(statearr_28281_28469[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (22))){
var inst_27978 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_27978)){
var statearr_28282_28470 = state_28201__$1;
(statearr_28282_28470[(1)] = (32));

} else {
var statearr_28283_28471 = state_28201__$1;
(statearr_28283_28471[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (90))){
var inst_28101 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28284_28472 = state_28201__$1;
(statearr_28284_28472[(2)] = inst_28101);

(statearr_28284_28472[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (109))){
var inst_28158 = (state_28201[(27)]);
var state_28201__$1 = state_28201;
var statearr_28285_28473 = state_28201__$1;
(statearr_28285_28473[(2)] = inst_28158);

(statearr_28285_28473[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (36))){
var inst_27952 = (state_28201[(26)]);
var state_28201__$1 = state_28201;
var statearr_28286_28474 = state_28201__$1;
(statearr_28286_28474[(2)] = inst_27952);

(statearr_28286_28474[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (41))){
var inst_27929 = (state_28201[(10)]);
var inst_27997 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27998 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_27997);
var inst_27999 = inst_27998 === true;
var state_28201__$1 = state_28201;
var statearr_28287_28475 = state_28201__$1;
(statearr_28287_28475[(2)] = inst_27999);

(statearr_28287_28475[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (118))){
var inst_28156 = (state_28201[(7)]);
var state_28201__$1 = state_28201;
var statearr_28288_28476 = state_28201__$1;
(statearr_28288_28476[(2)] = inst_28156);

(statearr_28288_28476[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (89))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28099 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28289_28477 = state_28201__$1;
(statearr_28289_28477[(2)] = inst_28099);

(statearr_28289_28477[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (100))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28290_28478 = state_28201__$1;
(statearr_28290_28478[(2)] = inst_28048);

(statearr_28290_28478[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (122))){
var inst_28188 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28291_28479 = state_28201__$1;
(statearr_28291_28479[(2)] = inst_28188);

(statearr_28291_28479[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (43))){
var inst_28002 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28292_28480 = state_28201__$1;
(statearr_28292_28480[(2)] = inst_28002);

(statearr_28292_28480[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (61))){
var inst_28010 = (state_28201[(14)]);
var state_28201__$1 = state_28201;
var statearr_28293_28481 = state_28201__$1;
(statearr_28293_28481[(2)] = inst_28010);

(statearr_28293_28481[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (29))){
var inst_27929 = (state_28201[(10)]);
var inst_27964 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27965 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_27964);
var inst_27966 = inst_27965 === true;
var state_28201__$1 = state_28201;
var statearr_28294_28482 = state_28201__$1;
(statearr_28294_28482[(2)] = inst_27966);

(statearr_28294_28482[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (44))){
var inst_27991 = (state_28201[(28)]);
var inst_28007 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_27991,"a component","a non-component",throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28295_28483 = state_28201__$1;
(statearr_28295_28483[(2)] = inst_28007);

(statearr_28295_28483[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (93))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28109 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28296_28484 = state_28201__$1;
(statearr_28296_28484[(2)] = inst_28109);

(statearr_28296_28484[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (6))){
var inst_27928 = (state_28201[(16)]);
var inst_27916 = (state_28201[(21)]);
var inst_27925 = cljs.core.seq(inst_27916);
var inst_27926 = cljs.core.first(inst_27925);
var inst_27927 = cljs.core.next(inst_27925);
var inst_27928__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27926,(0),null);
var inst_27929 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27926,(1),null);
var inst_27930 = cljs.core.not(inst_27928__$1);
var state_28201__$1 = (function (){var statearr_28297 = state_28201;
(statearr_28297[(10)] = inst_27929);

(statearr_28297[(16)] = inst_27928__$1);

(statearr_28297[(20)] = inst_27927);

return statearr_28297;
})();
if(inst_27930){
var statearr_28298_28485 = state_28201__$1;
(statearr_28298_28485[(1)] = (8));

} else {
var statearr_28299_28486 = state_28201__$1;
(statearr_28299_28486[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (111))){
var inst_27929 = (state_28201[(10)]);
var inst_28164 = (state_28201[(29)]);
var inst_28162 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28163 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_28162);
var inst_28164__$1 = inst_28163 === true;
var state_28201__$1 = (function (){var statearr_28300 = state_28201;
(statearr_28300[(29)] = inst_28164__$1);

return statearr_28300;
})();
if(cljs.core.truth_(inst_28164__$1)){
var statearr_28301_28487 = state_28201__$1;
(statearr_28301_28487[(1)] = (114));

} else {
var statearr_28302_28488 = state_28201__$1;
(statearr_28302_28488[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (28))){
var inst_27972 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28303_28489 = state_28201__$1;
(statearr_28303_28489[(2)] = inst_27972);

(statearr_28303_28489[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (64))){
var inst_28049 = (state_28201[(11)]);
var state_28201__$1 = state_28201;
var statearr_28304_28490 = state_28201__$1;
(statearr_28304_28490[(2)] = inst_28049);

(statearr_28304_28490[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (103))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28133 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_28134 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_28133,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,2,inst_28133,null));
var inst_28135 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28134,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28134,null));
var inst_28136 = (inst_28135.cljs$core$IFn$_invoke$arity$1 ? inst_28135.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28135.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28136)){
var statearr_28305_28491 = state_28201__$1;
(statearr_28305_28491[(1)] = (104));

} else {
var statearr_28306_28492 = state_28201__$1;
(statearr_28306_28492[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (51))){
var inst_28014 = (state_28201[(30)]);
var state_28201__$1 = state_28201;
var statearr_28307_28493 = state_28201__$1;
(statearr_28307_28493[(2)] = inst_28014);

(statearr_28307_28493[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (25))){
var inst_27975 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28308_28494 = state_28201__$1;
(statearr_28308_28494[(2)] = inst_27975);

(statearr_28308_28494[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (34))){
var inst_27929 = (state_28201[(10)]);
var inst_27992 = (state_28201[(18)]);
var inst_27991 = (state_28201[(2)]);
var inst_27992__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28309 = state_28201;
(statearr_28309[(28)] = inst_27991);

(statearr_28309[(18)] = inst_27992__$1);

return statearr_28309;
})();
if(cljs.core.truth_(inst_27992__$1)){
var statearr_28310_28495 = state_28201__$1;
(statearr_28310_28495[(1)] = (38));

} else {
var statearr_28311_28496 = state_28201__$1;
(statearr_28311_28496[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (17))){
var inst_27917 = (state_28201[(15)]);
var inst_27949 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_27917,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28312_28497 = state_28201__$1;
(statearr_28312_28497[(2)] = inst_27949);

(statearr_28312_28497[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (3))){
var inst_28199 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28201__$1,inst_28199);
} else {
if((state_val_28202 === (12))){
var inst_27933 = (state_28201[(31)]);
var state_28201__$1 = state_28201;
var statearr_28313_28498 = state_28201__$1;
(statearr_28313_28498[(2)] = inst_27933);

(statearr_28313_28498[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (2))){
var _ = (function (){var statearr_28314 = state_28201;
(statearr_28314[(4)] = cljs.core.cons((5),(state_28201[(4)])));

return statearr_28314;
})();
var inst_27909 = pred_changes;
var inst_27910 = cljs.core.seq(inst_27909);
var inst_27911 = cljs.core.first(inst_27910);
var inst_27912 = cljs.core.next(inst_27910);
var inst_27913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27911,(0),null);
var inst_27914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_27911,(1),null);
var inst_27915 = db;
var inst_27916 = inst_27909;
var inst_27917 = inst_27915;
var state_28201__$1 = (function (){var statearr_28315 = state_28201;
(statearr_28315[(15)] = inst_27917);

(statearr_28315[(32)] = inst_27912);

(statearr_28315[(33)] = inst_27914);

(statearr_28315[(21)] = inst_27916);

(statearr_28315[(34)] = inst_27913);

return statearr_28315;
})();
var statearr_28316_28499 = state_28201__$1;
(statearr_28316_28499[(2)] = null);

(statearr_28316_28499[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (66))){
var inst_27929 = (state_28201[(10)]);
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28058 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28059 = cljs.core.__destructure_map(inst_28058);
var inst_28060__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28059,cljs.core.cst$kw$old);
var inst_28061__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28059,cljs.core.cst$kw$new);
var inst_28062 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_28061__$1,inst_28060__$1);
var state_28201__$1 = (function (){var statearr_28317 = state_28201;
(statearr_28317[(8)] = inst_28060__$1);

(statearr_28317[(9)] = inst_28061__$1);

return statearr_28317;
})();
if(inst_28062){
var statearr_28318_28500 = state_28201__$1;
(statearr_28318_28500[(1)] = (69));

} else {
var statearr_28319_28501 = state_28201__$1;
(statearr_28319_28501[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (107))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28143 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28320_28502 = state_28201__$1;
(statearr_28320_28502[(2)] = inst_28143);

(statearr_28320_28502[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (23))){
var inst_27929 = (state_28201[(10)]);
var inst_27958 = (state_28201[(17)]);
var inst_27957 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27958__$1 = inst_27957 === true;
var state_28201__$1 = (function (){var statearr_28321 = state_28201;
(statearr_28321[(17)] = inst_27958__$1);

return statearr_28321;
})();
if(cljs.core.truth_(inst_27958__$1)){
var statearr_28322_28503 = state_28201__$1;
(statearr_28322_28503[(1)] = (26));

} else {
var statearr_28323_28504 = state_28201__$1;
(statearr_28323_28504[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (47))){
var inst_27929 = (state_28201[(10)]);
var inst_28014 = (state_28201[(30)]);
var inst_28013 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28014__$1 = cljs.core.not(inst_28013);
var state_28201__$1 = (function (){var statearr_28324 = state_28201;
(statearr_28324[(30)] = inst_28014__$1);

return statearr_28324;
})();
if(inst_28014__$1){
var statearr_28325_28505 = state_28201__$1;
(statearr_28325_28505[(1)] = (50));

} else {
var statearr_28326_28506 = state_28201__$1;
(statearr_28326_28506[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (35))){
var inst_27981 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_27982 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_27983 = cljs.core.PersistentHashMap.fromArrays(inst_27981,inst_27982);
var inst_27984 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_27983);
var inst_27985 = (function(){throw inst_27984})();
var state_28201__$1 = state_28201;
var statearr_28327_28507 = state_28201__$1;
(statearr_28327_28507[(2)] = inst_27985);

(statearr_28327_28507[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (82))){
var inst_28081 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28328_28508 = state_28201__$1;
(statearr_28328_28508[(2)] = inst_28081);

(statearr_28328_28508[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (76))){
var state_28201__$1 = state_28201;
var statearr_28329_28509 = state_28201__$1;
(statearr_28329_28509[(2)] = null);

(statearr_28329_28509[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (97))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28119 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28330_28510 = state_28201__$1;
(statearr_28330_28510[(2)] = inst_28119);

(statearr_28330_28510[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (19))){
var inst_27929 = (state_28201[(10)]);
var inst_27953 = (state_28201[(24)]);
var inst_27952 = (state_28201[(2)]);
var inst_27953__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28331 = state_28201;
(statearr_28331[(26)] = inst_27952);

(statearr_28331[(24)] = inst_27953__$1);

return statearr_28331;
})();
if(cljs.core.truth_(inst_27953__$1)){
var statearr_28332_28511 = state_28201__$1;
(statearr_28332_28511[(1)] = (20));

} else {
var statearr_28333_28512 = state_28201__$1;
(statearr_28333_28512[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (57))){
var state_28201__$1 = state_28201;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_28334_28513 = state_28201__$1;
(statearr_28334_28513[(1)] = (60));

} else {
var statearr_28335_28514 = state_28201__$1;
(statearr_28335_28514[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (68))){
var inst_27929 = (state_28201[(10)]);
var inst_28158 = (state_28201[(27)]);
var inst_28156 = (state_28201[(2)]);
var inst_28157 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28158__$1 = inst_28157 === true;
var state_28201__$1 = (function (){var statearr_28336 = state_28201;
(statearr_28336[(27)] = inst_28158__$1);

(statearr_28336[(7)] = inst_28156);

return statearr_28336;
})();
if(cljs.core.truth_(inst_28158__$1)){
var statearr_28337_28515 = state_28201__$1;
(statearr_28337_28515[(1)] = (108));

} else {
var statearr_28338_28516 = state_28201__$1;
(statearr_28338_28516[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (11))){
var inst_27929 = (state_28201[(10)]);
var inst_27937 = (state_28201[(23)]);
var inst_27935 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27936 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_27935);
var inst_27937__$1 = inst_27936 === false;
var state_28201__$1 = (function (){var statearr_28339 = state_28201;
(statearr_28339[(23)] = inst_27937__$1);

return statearr_28339;
})();
if(cljs.core.truth_(inst_27937__$1)){
var statearr_28340_28517 = state_28201__$1;
(statearr_28340_28517[(1)] = (14));

} else {
var statearr_28341_28518 = state_28201__$1;
(statearr_28341_28518[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (115))){
var inst_28164 = (state_28201[(29)]);
var state_28201__$1 = state_28201;
var statearr_28343_28519 = state_28201__$1;
(statearr_28343_28519[(2)] = inst_28164);

(statearr_28343_28519[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (9))){
var inst_27929 = (state_28201[(10)]);
var inst_27933 = (state_28201[(31)]);
var inst_27933__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_27929);
var state_28201__$1 = (function (){var statearr_28344 = state_28201;
(statearr_28344[(31)] = inst_27933__$1);

return statearr_28344;
})();
if(cljs.core.truth_(inst_27933__$1)){
var statearr_28345_28520 = state_28201__$1;
(statearr_28345_28520[(1)] = (11));

} else {
var statearr_28346_28521 = state_28201__$1;
(statearr_28346_28521[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (5))){
var _ = (function (){var statearr_28347 = state_28201;
(statearr_28347[(4)] = cljs.core.rest((state_28201[(4)])));

return statearr_28347;
})();
var state_28201__$1 = state_28201;
var ex28342 = (state_28201__$1[(2)]);
var statearr_28348_28522 = state_28201__$1;
(statearr_28348_28522[(5)] = ex28342);


if((ex28342 instanceof Error)){
var statearr_28349_28523 = state_28201__$1;
(statearr_28349_28523[(1)] = (4));

(statearr_28349_28523[(5)] = null);

} else {
throw ex28342;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (112))){
var inst_28160 = (state_28201[(25)]);
var state_28201__$1 = state_28201;
var statearr_28350_28524 = state_28201__$1;
(statearr_28350_28524[(2)] = inst_28160);

(statearr_28350_28524[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (83))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28083 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_28084 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_28083,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,3,inst_28083,null));
var inst_28085 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28084,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28084,null));
var inst_28086 = (inst_28085.cljs$core$IFn$_invoke$arity$1 ? inst_28085.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28085.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28086)){
var statearr_28351_28525 = state_28201__$1;
(statearr_28351_28525[(1)] = (84));

} else {
var statearr_28352_28526 = state_28201__$1;
(statearr_28352_28526[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (14))){
var inst_27929 = (state_28201[(10)]);
var inst_27939 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27940 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_27939);
var inst_27941 = inst_27940 === true;
var state_28201__$1 = state_28201;
var statearr_28353_28527 = state_28201__$1;
(statearr_28353_28527[(2)] = inst_27941);

(statearr_28353_28527[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (45))){
var inst_27991 = (state_28201[(28)]);
var state_28201__$1 = state_28201;
var statearr_28354_28528 = state_28201__$1;
(statearr_28354_28528[(2)] = inst_27991);

(statearr_28354_28528[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (53))){
var inst_27917 = (state_28201[(15)]);
var inst_27928 = (state_28201[(16)]);
var inst_28020 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_27917,inst_27928);
var state_28201__$1 = state_28201;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28201__$1,(56),inst_28020);
} else {
if((state_val_28202 === (78))){
var inst_28146 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28355_28529 = state_28201__$1;
(statearr_28355_28529[(2)] = inst_28146);

(statearr_28355_28529[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (26))){
var inst_27929 = (state_28201[(10)]);
var inst_27962 = (state_28201[(35)]);
var inst_27960 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27961 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_27960);
var inst_27962__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_27961);
var state_28201__$1 = (function (){var statearr_28356 = state_28201;
(statearr_28356[(35)] = inst_27962__$1);

return statearr_28356;
})();
if(inst_27962__$1){
var statearr_28357_28530 = state_28201__$1;
(statearr_28357_28530[(1)] = (29));

} else {
var statearr_28358_28531 = state_28201__$1;
(statearr_28358_28531[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (16))){
var inst_27944 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28359_28532 = state_28201__$1;
(statearr_28359_28532[(2)] = inst_27944);

(statearr_28359_28532[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (81))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28079 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28360_28533 = state_28201__$1;
(statearr_28360_28533[(2)] = inst_28079);

(statearr_28360_28533[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (120))){
var inst_28181 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_28182 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_28183 = cljs.core.PersistentHashMap.fromArrays(inst_28181,inst_28182);
var inst_28184 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_28183);
var inst_28185 = (function(){throw inst_28184})();
var state_28201__$1 = state_28201;
var statearr_28361_28534 = state_28201__$1;
(statearr_28361_28534[(2)] = inst_28185);

(statearr_28361_28534[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (79))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28073 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_28074 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_28073,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,2,inst_28073,null));
var inst_28075 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28074,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28074,null));
var inst_28076 = (inst_28075.cljs$core$IFn$_invoke$arity$1 ? inst_28075.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28075.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28076)){
var statearr_28362_28535 = state_28201__$1;
(statearr_28362_28535[(1)] = (80));

} else {
var statearr_28363_28536 = state_28201__$1;
(statearr_28363_28536[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (38))){
var inst_27929 = (state_28201[(10)]);
var inst_27995 = (state_28201[(36)]);
var inst_27994 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_27995__$1 = cljs.core.not(inst_27994);
var state_28201__$1 = (function (){var statearr_28364 = state_28201;
(statearr_28364[(36)] = inst_27995__$1);

return statearr_28364;
})();
if(inst_27995__$1){
var statearr_28365_28537 = state_28201__$1;
(statearr_28365_28537[(1)] = (41));

} else {
var statearr_28366_28538 = state_28201__$1;
(statearr_28366_28538[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (98))){
var inst_28121 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28367_28539 = state_28201__$1;
(statearr_28367_28539[(2)] = inst_28121);

(statearr_28367_28539[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (87))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28093 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_28094 = (inst_28061.cljs$core$IFn$_invoke$arity$5 ? inst_28061.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_28093,null) : inst_28061.call(null,cljs.core.PersistentArrayMap,null,3,inst_28093,null));
var inst_28095 = (inst_28061.cljs$core$IFn$_invoke$arity$4 ? inst_28061.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_28094,null) : inst_28061.call(null,cljs.core.PersistentHashSet,null,inst_28094,null));
var inst_28096 = (inst_28095.cljs$core$IFn$_invoke$arity$1 ? inst_28095.cljs$core$IFn$_invoke$arity$1(inst_28060) : inst_28095.call(null,inst_28060));
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28096)){
var statearr_28368_28540 = state_28201__$1;
(statearr_28368_28540[(1)] = (88));

} else {
var statearr_28369_28541 = state_28201__$1;
(statearr_28369_28541[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (30))){
var inst_27962 = (state_28201[(35)]);
var state_28201__$1 = state_28201;
var statearr_28370_28542 = state_28201__$1;
(statearr_28370_28542[(2)] = inst_27962);

(statearr_28370_28542[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (73))){
var state_28201__$1 = state_28201;
var statearr_28371_28543 = state_28201__$1;
(statearr_28371_28543[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (96))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28373_28544 = state_28201__$1;
(statearr_28373_28544[(2)] = inst_28048);

(statearr_28373_28544[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (10))){
var inst_28194 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28374_28545 = state_28201__$1;
(statearr_28374_28545[(2)] = inst_28194);

(statearr_28374_28545[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (18))){
var inst_27917 = (state_28201[(15)]);
var state_28201__$1 = state_28201;
var statearr_28375_28546 = state_28201__$1;
(statearr_28375_28546[(2)] = inst_27917);

(statearr_28375_28546[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (105))){
var inst_28060 = (state_28201[(8)]);
var inst_28061 = (state_28201[(9)]);
var inst_28139 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_28060,inst_28061,throw_QMARK_);
var state_28201__$1 = state_28201;
var statearr_28376_28547 = state_28201__$1;
(statearr_28376_28547[(2)] = inst_28139);

(statearr_28376_28547[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (52))){
var inst_28030 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28377_28548 = state_28201__$1;
(statearr_28377_28548[(2)] = inst_28030);

(statearr_28377_28548[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (114))){
var inst_27929 = (state_28201[(10)]);
var inst_28166 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28167 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_28166);
var inst_28168 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_28167);
var inst_28169 = (!(inst_28168));
var state_28201__$1 = state_28201;
var statearr_28378_28549 = state_28201__$1;
(statearr_28378_28549[(2)] = inst_28169);

(statearr_28378_28549[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (67))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28379_28550 = state_28201__$1;
(statearr_28379_28550[(2)] = inst_28048);

(statearr_28379_28550[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (71))){
var inst_28153 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28380_28551 = state_28201__$1;
(statearr_28380_28551[(2)] = inst_28153);

(statearr_28380_28551[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (42))){
var inst_27995 = (state_28201[(36)]);
var state_28201__$1 = state_28201;
var statearr_28381_28552 = state_28201__$1;
(statearr_28381_28552[(2)] = inst_27995);

(statearr_28381_28552[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (80))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28382_28553 = state_28201__$1;
(statearr_28382_28553[(2)] = inst_28048);

(statearr_28382_28553[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (37))){
var inst_27988 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28383_28554 = state_28201__$1;
(statearr_28383_28554[(2)] = inst_27988);

(statearr_28383_28554[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (63))){
var inst_27929 = (state_28201[(10)]);
var inst_28051 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_27929);
var inst_28052 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_28051);
var state_28201__$1 = state_28201;
var statearr_28384_28555 = state_28201__$1;
(statearr_28384_28555[(2)] = inst_28052);

(statearr_28384_28555[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (94))){
var inst_28111 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
var statearr_28385_28556 = state_28201__$1;
(statearr_28385_28556[(2)] = inst_28111);

(statearr_28385_28556[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (8))){
var inst_27917 = (state_28201[(15)]);
var state_28201__$1 = state_28201;
var statearr_28386_28557 = state_28201__$1;
(statearr_28386_28557[(2)] = inst_27917);

(statearr_28386_28557[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (49))){
var inst_28033 = (state_28201[(2)]);
var state_28201__$1 = state_28201;
if(cljs.core.truth_(inst_28033)){
var statearr_28387_28558 = state_28201__$1;
(statearr_28387_28558[(1)] = (57));

} else {
var statearr_28388_28559 = state_28201__$1;
(statearr_28388_28559[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28202 === (84))){
var inst_28048 = (state_28201[(12)]);
var state_28201__$1 = state_28201;
var statearr_28389_28560 = state_28201__$1;
(statearr_28389_28560[(2)] = inst_28048);

(statearr_28389_28560[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10750__auto__ = null;
var fluree$db$query$schema$state_machine__10750__auto____0 = (function (){
var statearr_28390 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_28390[(0)] = fluree$db$query$schema$state_machine__10750__auto__);

(statearr_28390[(1)] = (1));

return statearr_28390;
});
var fluree$db$query$schema$state_machine__10750__auto____1 = (function (state_28201){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28201);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28391){var ex__10753__auto__ = e28391;
var statearr_28392_28561 = state_28201;
(statearr_28392_28561[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28201[(4)]))){
var statearr_28393_28562 = state_28201;
(statearr_28393_28562[(1)] = cljs.core.first((state_28201[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28563 = state_28201;
state_28201 = G__28563;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10750__auto__ = function(state_28201){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10750__auto____1.call(this,state_28201);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10750__auto____0;
fluree$db$query$schema$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10750__auto____1;
return fluree$db$query$schema$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28394 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28394[(6)] = c__10876__auto__);

return statearr_28394;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__28565 = arguments.length;
switch (G__28565) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28589){
var state_val_28590 = (state_28589[(1)]);
if((state_val_28590 === (7))){
var state_28589__$1 = state_28589;
var statearr_28591_28611 = state_28589__$1;
(statearr_28591_28611[(2)] = db);

(statearr_28591_28611[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (1))){
var state_28589__$1 = state_28589;
var statearr_28592_28612 = state_28589__$1;
(statearr_28592_28612[(2)] = null);

(statearr_28592_28612[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (4))){
var inst_28566 = (state_28589[(2)]);
var state_28589__$1 = state_28589;
var statearr_28593_28613 = state_28589__$1;
(statearr_28593_28613[(2)] = inst_28566);

(statearr_28593_28613[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (6))){
var inst_28575 = (state_28589[(7)]);
var inst_28574 = (state_28589[(2)]);
var inst_28575__$1 = fluree.db.util.async.throw_err(inst_28574);
var inst_28576 = cljs.core.empty_QMARK_(inst_28575__$1);
var state_28589__$1 = (function (){var statearr_28594 = state_28589;
(statearr_28594[(7)] = inst_28575__$1);

return statearr_28594;
})();
if(inst_28576){
var statearr_28595_28614 = state_28589__$1;
(statearr_28595_28614[(1)] = (7));

} else {
var statearr_28596_28615 = state_28589__$1;
(statearr_28596_28615[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (3))){
var inst_28587 = (state_28589[(2)]);
var state_28589__$1 = state_28589;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28589__$1,inst_28587);
} else {
if((state_val_28590 === (2))){
var _ = (function (){var statearr_28598 = state_28589;
(statearr_28598[(4)] = cljs.core.cons((5),(state_28589[(4)])));

return statearr_28598;
})();
var inst_28572 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_28589__$1 = state_28589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28589__$1,(6),inst_28572);
} else {
if((state_val_28590 === (9))){
var inst_28584 = (state_28589[(2)]);
var _ = (function (){var statearr_28599 = state_28589;
(statearr_28599[(4)] = cljs.core.rest((state_28589[(4)])));

return statearr_28599;
})();
var state_28589__$1 = state_28589;
var statearr_28600_28616 = state_28589__$1;
(statearr_28600_28616[(2)] = inst_28584);

(statearr_28600_28616[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (5))){
var _ = (function (){var statearr_28601 = state_28589;
(statearr_28601[(4)] = cljs.core.rest((state_28589[(4)])));

return statearr_28601;
})();
var state_28589__$1 = state_28589;
var ex28597 = (state_28589__$1[(2)]);
var statearr_28602_28617 = state_28589__$1;
(statearr_28602_28617[(5)] = ex28597);


if((ex28597 instanceof Error)){
var statearr_28603_28618 = state_28589__$1;
(statearr_28603_28618[(1)] = (4));

(statearr_28603_28618[(5)] = null);

} else {
throw ex28597;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (10))){
var inst_28581 = (state_28589[(2)]);
var inst_28582 = fluree.db.util.async.throw_err(inst_28581);
var state_28589__$1 = state_28589;
var statearr_28604_28619 = state_28589__$1;
(statearr_28604_28619[(2)] = inst_28582);

(statearr_28604_28619[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28590 === (8))){
var inst_28575 = (state_28589[(7)]);
var inst_28579 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_28575,db,true);
var state_28589__$1 = state_28589;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28589__$1,(10),inst_28579);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__10750__auto__ = null;
var fluree$db$query$schema$state_machine__10750__auto____0 = (function (){
var statearr_28605 = [null,null,null,null,null,null,null,null];
(statearr_28605[(0)] = fluree$db$query$schema$state_machine__10750__auto__);

(statearr_28605[(1)] = (1));

return statearr_28605;
});
var fluree$db$query$schema$state_machine__10750__auto____1 = (function (state_28589){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28589);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28606){var ex__10753__auto__ = e28606;
var statearr_28607_28620 = state_28589;
(statearr_28607_28620[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28589[(4)]))){
var statearr_28608_28621 = state_28589;
(statearr_28608_28621[(1)] = cljs.core.first((state_28589[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28622 = state_28589;
state_28589 = G__28622;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__10750__auto__ = function(state_28589){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__10750__auto____1.call(this,state_28589);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__10750__auto____0;
fluree$db$query$schema$state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__10750__auto____1;
return fluree$db$query$schema$state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28609 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28609[(6)] = c__10876__auto__);

return statearr_28609;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__28624 = arguments.length;
switch (G__28624) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__28626 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28626,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28626,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28626,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__28629_SHARP_,p2__28630_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__28629_SHARP_,p2__28630_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__28631_SHARP_){
var f = p1__28631_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28697){
var state_val_28698 = (state_28697[(1)]);
if((state_val_28698 === (1))){
var state_28697__$1 = state_28697;
var statearr_28699_28717 = state_28697__$1;
(statearr_28699_28717[(2)] = null);

(statearr_28699_28717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28698 === (2))){
var _ = (function (){var statearr_28700 = state_28697;
(statearr_28700[(4)] = cljs.core.cons((5),(state_28697[(4)])));

return statearr_28700;
})();
var inst_28649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28650 = fluree.db.flake.max_subject_id((1));
var inst_28651 = [inst_28650];
var inst_28652 = (new cljs.core.PersistentVector(null,1,(5),inst_28649,inst_28651,null));
var inst_28653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28654 = [(0)];
var inst_28655 = (new cljs.core.PersistentVector(null,1,(5),inst_28653,inst_28654,null));
var inst_28656 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_28652,cljs.core._LT__EQ_,inst_28655);
var state_28697__$1 = state_28697;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28697__$1,(6),inst_28656);
} else {
if((state_val_28698 === (3))){
var inst_28695 = (state_28697[(2)]);
var state_28697__$1 = state_28697;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28697__$1,inst_28695);
} else {
if((state_val_28698 === (4))){
var inst_28637 = (state_28697[(2)]);
var state_28697__$1 = state_28697;
var statearr_28702_28718 = state_28697__$1;
(statearr_28702_28718[(2)] = inst_28637);

(statearr_28702_28718[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28698 === (5))){
var _ = (function (){var statearr_28703 = state_28697;
(statearr_28703[(4)] = cljs.core.rest((state_28697[(4)])));

return statearr_28703;
})();
var state_28697__$1 = state_28697;
var ex28701 = (state_28697__$1[(2)]);
var statearr_28704_28719 = state_28697__$1;
(statearr_28704_28719[(5)] = ex28701);


if((ex28701 instanceof Error)){
var statearr_28705_28720 = state_28697__$1;
(statearr_28705_28720[(1)] = (4));

(statearr_28705_28720[(5)] = null);

} else {
throw ex28701;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28698 === (6))){
var inst_28658 = (state_28697[(2)]);
var inst_28659 = fluree.db.util.async.throw_err(inst_28658);
var inst_28660 = (function (){var schema_flakes = inst_28659;
return (function (p1__28632_SHARP_){
return (p1__28632_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_28661 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28660,inst_28659);
var inst_28662 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28661,(0),null);
var inst_28663 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28661,(1),null);
var inst_28664 = (function (){var schema_flakes = inst_28659;
var vec__28643 = inst_28661;
var collection_flakes = inst_28662;
var predicate_flakes = inst_28663;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__28635_SHARP_,p2__28634_SHARP_){
var f = p2__28634_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__28635_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_28665 = [(-1),"_tx"];
var inst_28666 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_28667 = ["_tx",(-1),(-1),(-1),null,null];
var inst_28668 = cljs.core.PersistentHashMap.fromArrays(inst_28666,inst_28667);
var inst_28669 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_28670 = ["_tx",(-1),(-1),(-1),null,null];
var inst_28671 = cljs.core.PersistentHashMap.fromArrays(inst_28669,inst_28670);
var inst_28672 = [inst_28668,inst_28671];
var inst_28673 = cljs.core.PersistentHashMap.fromArrays(inst_28665,inst_28672);
var inst_28674 = (function (){var schema_flakes = inst_28659;
var vec__28643 = inst_28661;
var collection_flakes = inst_28662;
var predicate_flakes = inst_28663;
return (function (p1__28633_SHARP_){
return p1__28633_SHARP_.s;
});
})();
var inst_28675 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28674,inst_28662);
var inst_28676 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28664,inst_28673,inst_28675);
var inst_28678 = (function (){var schema_flakes = inst_28659;
var vec__28643 = inst_28661;
var collection_flakes = inst_28662;
var predicate_flakes = inst_28663;
var coll = inst_28676;
return (function (p__28677,pred_flakes){
var vec__28706 = p__28677;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28706,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28706,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__28709 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__28709.cljs$core$IFn$_invoke$arity$1 ? fexpr__28709.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__28709.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_28679 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28680 = cljs.core.PersistentHashMap.EMPTY;
var inst_28681 = cljs.core.PersistentHashSet.EMPTY;
var inst_28682 = [inst_28680,inst_28681];
var inst_28683 = (new cljs.core.PersistentVector(null,2,(5),inst_28679,inst_28682,null));
var inst_28684 = (function (){var schema_flakes = inst_28659;
var vec__28643 = inst_28661;
var collection_flakes = inst_28662;
var predicate_flakes = inst_28663;
var coll = inst_28676;
return (function (p1__28636_SHARP_){
return p1__28636_SHARP_.s;
});
})();
var inst_28685 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_28684,inst_28663);
var inst_28686 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_28678,inst_28683,inst_28685);
var inst_28687 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28686,(0),null);
var inst_28688 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_28686,(1),null);
var inst_28689 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_28690 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_28691 = [inst_28690,inst_28676,inst_28687,inst_28688];
var inst_28692 = cljs.core.PersistentHashMap.fromArrays(inst_28689,inst_28691);
var _ = (function (){var statearr_28710 = state_28697;
(statearr_28710[(4)] = cljs.core.rest((state_28697[(4)])));

return statearr_28710;
})();
var state_28697__$1 = state_28697;
var statearr_28711_28721 = state_28697__$1;
(statearr_28711_28721[(2)] = inst_28692);

(statearr_28711_28721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__10750__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__10750__auto____0 = (function (){
var statearr_28712 = [null,null,null,null,null,null,null];
(statearr_28712[(0)] = fluree$db$query$schema$schema_map_$_state_machine__10750__auto__);

(statearr_28712[(1)] = (1));

return statearr_28712;
});
var fluree$db$query$schema$schema_map_$_state_machine__10750__auto____1 = (function (state_28697){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28697);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28713){var ex__10753__auto__ = e28713;
var statearr_28714_28722 = state_28697;
(statearr_28714_28722[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28697[(4)]))){
var statearr_28715_28723 = state_28697;
(statearr_28715_28723[(1)] = cljs.core.first((state_28697[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28724 = state_28697;
state_28697 = G__28724;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__10750__auto__ = function(state_28697){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__10750__auto____1.call(this,state_28697);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__10750__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__10750__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28716 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28716[(6)] = c__10876__auto__);

return statearr_28716;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_28766){
var state_val_28767 = (state_28766[(1)]);
if((state_val_28767 === (7))){
var inst_28749 = (state_28766[(2)]);
var inst_28750 = fluree.db.query.schema.flake__GT_pred_map(inst_28749);
var inst_28751 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_28752 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(114));
var inst_28753 = cljs.core.boolean$(inst_28752);
var inst_28754 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(110));
var inst_28755 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(117));
var inst_28756 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_28755);
var inst_28757 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(111));
var inst_28758 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(115));
var inst_28759 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_28750,(112));
var inst_28760 = [inst_28753,inst_28754,inst_28756,inst_28757,inst_28758,inst_28759];
var inst_28761 = cljs.core.PersistentHashMap.fromArrays(inst_28751,inst_28760);
var _ = (function (){var statearr_28768 = state_28766;
(statearr_28768[(4)] = cljs.core.rest((state_28766[(4)])));

return statearr_28768;
})();
var state_28766__$1 = state_28766;
var statearr_28769_28792 = state_28766__$1;
(statearr_28769_28792[(2)] = inst_28761);

(statearr_28769_28792[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (1))){
var state_28766__$1 = state_28766;
var statearr_28770_28793 = state_28766__$1;
(statearr_28770_28793[(2)] = null);

(statearr_28770_28793[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (4))){
var inst_28725 = (state_28766[(2)]);
var state_28766__$1 = state_28766;
var statearr_28771_28794 = state_28766__$1;
(statearr_28771_28794[(2)] = inst_28725);

(statearr_28771_28794[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (6))){
var _ = (function (){var statearr_28772 = state_28766;
(statearr_28772[(4)] = cljs.core.cons((9),(state_28766[(4)])));

return statearr_28772;
})();
var inst_28737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28738 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_28739 = ["_setting/id","root"];
var inst_28740 = (new cljs.core.PersistentVector(null,2,(5),inst_28738,inst_28739,null));
var inst_28741 = [inst_28740];
var inst_28742 = (new cljs.core.PersistentVector(null,1,(5),inst_28737,inst_28741,null));
var inst_28743 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_28742);
var state_28766__$1 = state_28766;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_28766__$1,(10),inst_28743);
} else {
if((state_val_28767 === (3))){
var inst_28764 = (state_28766[(2)]);
var state_28766__$1 = state_28766;
return cljs.core.async.impl.ioc_helpers.return_chan(state_28766__$1,inst_28764);
} else {
if((state_val_28767 === (2))){
var _ = (function (){var statearr_28775 = state_28766;
(statearr_28775[(4)] = cljs.core.cons((5),(state_28766[(4)])));

return statearr_28775;
})();
var state_28766__$1 = state_28766;
var statearr_28776_28795 = state_28766__$1;
(statearr_28776_28795[(2)] = null);

(statearr_28776_28795[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (9))){
var _ = (function (){var statearr_28777 = state_28766;
(statearr_28777[(4)] = cljs.core.rest((state_28766[(4)])));

return statearr_28777;
})();
var state_28766__$1 = state_28766;
var ex28773 = (state_28766__$1[(2)]);
var statearr_28778_28796 = state_28766__$1;
(statearr_28778_28796[(5)] = ex28773);


var statearr_28779_28797 = state_28766__$1;
(statearr_28779_28797[(1)] = (8));

(statearr_28779_28797[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (5))){
var _ = (function (){var statearr_28780 = state_28766;
(statearr_28780[(4)] = cljs.core.rest((state_28766[(4)])));

return statearr_28780;
})();
var state_28766__$1 = state_28766;
var ex28774 = (state_28766__$1[(2)]);
var statearr_28781_28798 = state_28766__$1;
(statearr_28781_28798[(5)] = ex28774);


if((ex28774 instanceof Error)){
var statearr_28782_28799 = state_28766__$1;
(statearr_28782_28799[(1)] = (4));

(statearr_28782_28799[(5)] = null);

} else {
throw ex28774;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (10))){
var inst_28745 = (state_28766[(2)]);
var inst_28746 = fluree.db.util.async.throw_err(inst_28745);
var _ = (function (){var statearr_28783 = state_28766;
(statearr_28783[(4)] = cljs.core.rest((state_28766[(4)])));

return statearr_28783;
})();
var state_28766__$1 = state_28766;
var statearr_28784_28800 = state_28766__$1;
(statearr_28784_28800[(2)] = inst_28746);

(statearr_28784_28800[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_28767 === (8))){
var inst_28731 = (state_28766[(2)]);
var state_28766__$1 = (function (){var statearr_28785 = state_28766;
(statearr_28785[(7)] = inst_28731);

return statearr_28785;
})();
var statearr_28786_28801 = state_28766__$1;
(statearr_28786_28801[(2)] = null);

(statearr_28786_28801[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__10750__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__10750__auto____0 = (function (){
var statearr_28787 = [null,null,null,null,null,null,null,null];
(statearr_28787[(0)] = fluree$db$query$schema$setting_map_$_state_machine__10750__auto__);

(statearr_28787[(1)] = (1));

return statearr_28787;
});
var fluree$db$query$schema$setting_map_$_state_machine__10750__auto____1 = (function (state_28766){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_28766);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e28788){var ex__10753__auto__ = e28788;
var statearr_28789_28802 = state_28766;
(statearr_28789_28802[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_28766[(4)]))){
var statearr_28790_28803 = state_28766;
(statearr_28790_28803[(1)] = cljs.core.first((state_28766[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__28804 = state_28766;
state_28766 = G__28804;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__10750__auto__ = function(state_28766){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__10750__auto____1.call(this,state_28766);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__10750__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__10750__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_28791 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_28791[(6)] = c__10876__auto__);

return statearr_28791;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
