// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_23210){
var state_val_23211 = (state_23210[(1)]);
if((state_val_23211 === (7))){
var inst_23205 = (state_23210[(2)]);
var _ = (function (){var statearr_23212 = state_23210;
(statearr_23212[(4)] = cljs.core.rest((state_23210[(4)])));

return statearr_23212;
})();
var state_23210__$1 = state_23210;
var statearr_23213_23235 = state_23210__$1;
(statearr_23213_23235[(2)] = inst_23205);

(statearr_23213_23235[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (1))){
var state_23210__$1 = state_23210;
var statearr_23214_23236 = state_23210__$1;
(statearr_23214_23236[(2)] = null);

(statearr_23214_23236[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (4))){
var inst_23167 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23215_23237 = state_23210__$1;
(statearr_23215_23237[(2)] = inst_23167);

(statearr_23215_23237[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (6))){
var inst_23192 = (state_23210[(7)]);
var inst_23185 = (state_23210[(8)]);
var inst_23191 = cljs.core.seq(inst_23185);
var inst_23192__$1 = cljs.core.first(inst_23191);
var inst_23193 = cljs.core.next(inst_23191);
var inst_23194 = cljs.core.not(inst_23192__$1);
var state_23210__$1 = (function (){var statearr_23216 = state_23210;
(statearr_23216[(7)] = inst_23192__$1);

(statearr_23216[(9)] = inst_23193);

return statearr_23216;
})();
if(inst_23194){
var statearr_23217_23238 = state_23210__$1;
(statearr_23217_23238[(1)] = (8));

} else {
var statearr_23218_23239 = state_23210__$1;
(statearr_23218_23239[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (3))){
var inst_23208 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23210__$1,inst_23208);
} else {
if((state_val_23211 === (2))){
var _ = (function (){var statearr_23219 = state_23210;
(statearr_23219[(4)] = cljs.core.cons((5),(state_23210[(4)])));

return statearr_23219;
})();
var inst_23180 = chs;
var inst_23181 = cljs.core.seq(inst_23180);
var inst_23182 = cljs.core.first(inst_23181);
var inst_23183 = cljs.core.next(inst_23181);
var inst_23184 = coll;
var inst_23185 = inst_23180;
var inst_23186 = inst_23184;
var state_23210__$1 = (function (){var statearr_23220 = state_23210;
(statearr_23220[(10)] = inst_23182);

(statearr_23220[(11)] = inst_23183);

(statearr_23220[(12)] = inst_23186);

(statearr_23220[(8)] = inst_23185);

return statearr_23220;
})();
var statearr_23221_23240 = state_23210__$1;
(statearr_23221_23240[(2)] = null);

(statearr_23221_23240[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (11))){
var inst_23193 = (state_23210[(9)]);
var inst_23186 = (state_23210[(12)]);
var inst_23198 = (state_23210[(2)]);
var inst_23199 = fluree.db.util.async.throw_err(inst_23198);
var inst_23200 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23186,inst_23199);
var inst_23185 = inst_23193;
var inst_23186__$1 = inst_23200;
var state_23210__$1 = (function (){var statearr_23223 = state_23210;
(statearr_23223[(12)] = inst_23186__$1);

(statearr_23223[(8)] = inst_23185);

return statearr_23223;
})();
var statearr_23224_23241 = state_23210__$1;
(statearr_23224_23241[(2)] = null);

(statearr_23224_23241[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (9))){
var inst_23192 = (state_23210[(7)]);
var state_23210__$1 = state_23210;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23210__$1,(11),inst_23192);
} else {
if((state_val_23211 === (5))){
var _ = (function (){var statearr_23225 = state_23210;
(statearr_23225[(4)] = cljs.core.rest((state_23210[(4)])));

return statearr_23225;
})();
var state_23210__$1 = state_23210;
var ex23222 = (state_23210__$1[(2)]);
var statearr_23226_23242 = state_23210__$1;
(statearr_23226_23242[(5)] = ex23222);


var statearr_23227_23243 = state_23210__$1;
(statearr_23227_23243[(1)] = (4));

(statearr_23227_23243[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (10))){
var inst_23203 = (state_23210[(2)]);
var state_23210__$1 = state_23210;
var statearr_23228_23244 = state_23210__$1;
(statearr_23228_23244[(2)] = inst_23203);

(statearr_23228_23244[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23211 === (8))){
var inst_23186 = (state_23210[(12)]);
var state_23210__$1 = state_23210;
var statearr_23229_23245 = state_23210__$1;
(statearr_23229_23245[(2)] = inst_23186);

(statearr_23229_23245[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_23230 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_23230[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__);

(statearr_23230[(1)] = (1));

return statearr_23230;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____1 = (function (state_23210){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_23210);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e23231){var ex__10753__auto__ = e23231;
var statearr_23232_23246 = state_23210;
(statearr_23232_23246[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_23210[(4)]))){
var statearr_23233_23247 = state_23210;
(statearr_23233_23247[(1)] = cljs.core.first((state_23210[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__23248 = state_23210;
state_23210 = G__23248;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__ = function(state_23210){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____1.call(this,state_23210);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_23234 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_23234[(6)] = c__10876__auto__);

return statearr_23234;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_23274){
var state_val_23275 = (state_23274[(1)]);
if((state_val_23275 === (7))){
var inst_23269 = (state_23274[(2)]);
var _ = (function (){var statearr_23276 = state_23274;
(statearr_23276[(4)] = cljs.core.rest((state_23274[(4)])));

return statearr_23276;
})();
var state_23274__$1 = state_23274;
var statearr_23277_23299 = state_23274__$1;
(statearr_23277_23299[(2)] = inst_23269);

(statearr_23277_23299[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (1))){
var state_23274__$1 = state_23274;
var statearr_23278_23300 = state_23274__$1;
(statearr_23278_23300[(2)] = null);

(statearr_23278_23300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (4))){
var inst_23249 = (state_23274[(2)]);
var state_23274__$1 = state_23274;
var statearr_23279_23301 = state_23274__$1;
(statearr_23279_23301[(2)] = inst_23249);

(statearr_23279_23301[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (6))){
var state_23274__$1 = state_23274;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_23274__$1,(8),chan);
} else {
if((state_val_23275 === (3))){
var inst_23272 = (state_23274[(2)]);
var state_23274__$1 = state_23274;
return cljs.core.async.impl.ioc_helpers.return_chan(state_23274__$1,inst_23272);
} else {
if((state_val_23275 === (2))){
var _ = (function (){var statearr_23280 = state_23274;
(statearr_23280[(4)] = cljs.core.cons((5),(state_23274[(4)])));

return statearr_23280;
})();
var inst_23255 = coll;
var inst_23256 = inst_23255;
var state_23274__$1 = (function (){var statearr_23281 = state_23274;
(statearr_23281[(7)] = inst_23256);

return statearr_23281;
})();
var statearr_23282_23302 = state_23274__$1;
(statearr_23282_23302[(2)] = null);

(statearr_23282_23302[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (11))){
var inst_23267 = (state_23274[(2)]);
var state_23274__$1 = state_23274;
var statearr_23284_23303 = state_23274__$1;
(statearr_23284_23303[(2)] = inst_23267);

(statearr_23284_23303[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (9))){
var inst_23256 = (state_23274[(7)]);
var state_23274__$1 = state_23274;
var statearr_23285_23304 = state_23274__$1;
(statearr_23285_23304[(2)] = inst_23256);

(statearr_23285_23304[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (5))){
var _ = (function (){var statearr_23286 = state_23274;
(statearr_23286[(4)] = cljs.core.rest((state_23274[(4)])));

return statearr_23286;
})();
var state_23274__$1 = state_23274;
var ex23283 = (state_23274__$1[(2)]);
var statearr_23287_23305 = state_23274__$1;
(statearr_23287_23305[(5)] = ex23283);


var statearr_23288_23306 = state_23274__$1;
(statearr_23288_23306[(1)] = (4));

(statearr_23288_23306[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (10))){
var inst_23260 = (state_23274[(8)]);
var inst_23256 = (state_23274[(7)]);
var inst_23264 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_23256,inst_23260);
var inst_23256__$1 = inst_23264;
var state_23274__$1 = (function (){var statearr_23289 = state_23274;
(statearr_23289[(7)] = inst_23256__$1);

return statearr_23289;
})();
var statearr_23290_23307 = state_23274__$1;
(statearr_23290_23307[(2)] = null);

(statearr_23290_23307[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_23275 === (8))){
var inst_23260 = (state_23274[(8)]);
var inst_23259 = (state_23274[(2)]);
var inst_23260__$1 = fluree.db.util.async.throw_err(inst_23259);
var inst_23261 = (inst_23260__$1 == null);
var state_23274__$1 = (function (){var statearr_23291 = state_23274;
(statearr_23291[(8)] = inst_23260__$1);

return statearr_23291;
})();
if(cljs.core.truth_(inst_23261)){
var statearr_23292_23308 = state_23274__$1;
(statearr_23292_23308[(1)] = (9));

} else {
var statearr_23293_23309 = state_23274__$1;
(statearr_23293_23309[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____0 = (function (){
var statearr_23294 = [null,null,null,null,null,null,null,null,null];
(statearr_23294[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__);

(statearr_23294[(1)] = (1));

return statearr_23294;
});
var fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____1 = (function (state_23274){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_23274);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e23295){var ex__10753__auto__ = e23295;
var statearr_23296_23310 = state_23274;
(statearr_23296_23310[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_23274[(4)]))){
var statearr_23297_23311 = state_23274;
(statearr_23297_23311[(1)] = cljs.core.first((state_23274[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__23312 = state_23274;
state_23274 = G__23312;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__ = function(state_23274){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____1.call(this,state_23274);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__10750__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_23298 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_23298[(6)] = c__10876__auto__);

return statearr_23298;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
