// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.xhttp');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core.async');
goog.require('clojure.string');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
fluree.db.util.xhttp.node$module$axios = require('axios');
fluree.db.util.xhttp.node$module$ws = require('ws');
fluree.db.util.xhttp.format_error_response = (function fluree$db$util$xhttp$format_error_response(url,e){
var status = (function (){var temp__5753__auto__ = e.response;
if(cljs.core.truth_(temp__5753__auto__)){
var resp = temp__5753__auto__;
var temp__5753__auto____$1 = resp.status;
if(cljs.core.truth_(temp__5753__auto____$1)){
var st = temp__5753__auto____$1;
if((st > (0))){
return st;
} else {
return null;
}
} else {
return null;
}
} else {
return null;
}
})();
var error = ((clojure.string.starts_with_QMARK_(e.message,"timeout"))?cljs.core.cst$kw$xhttp_SLASH_timeout:(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return ((((300) <= status)) && ((status <= (499))));
} else {
return and__4210__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_http_DASH_error:(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status >= (500));
} else {
return and__4210__auto__;
}
})())?cljs.core.cst$kw$xhttp_SLASH_exception:(function (){
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["XHTTP Request Error:",e.request], 0));

return cljs.core.cst$kw$xhttp_SLASH_unknown_DASH_error;
})()

)));
var message = ["xhttp error - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url),(cljs.core.truth_((function (){var and__4210__auto__ = status;
if(cljs.core.truth_(and__4210__auto__)){
return (status > (0));
} else {
return and__4210__auto__;
}
})())?[": ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(status)].join(''):"")].join('');
return cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,(function (){var G__31633 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$error,error], null);
if(cljs.core.truth_(status)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31633,cljs.core.cst$kw$status,status);
} else {
return G__31633;
}
})());
});
/**
 * Posts JSON content.
 *   opts is a map with following optional keys:
 *   :request-timeout - how many milliseconds until we throw an exception without a response (default 5000)
 */
fluree.db.util.xhttp.post_json = (function fluree$db$util$xhttp$post_json(url,message,opts){
var map__31634 = opts;
var map__31634__$1 = cljs.core.__destructure_map(map__31634);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31634__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31634__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31634__$1,cljs.core.cst$kw$headers);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__31635 = new cljs.core.PersistentArrayMap(null, 1, ["Content-Type","application/json"], null);
var G__31635__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__31635,headers], 0)):G__31635);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31635__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__31635__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"post",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1,cljs.core.cst$kw$data,message], null))).then((function (resp){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0))));
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * Returns result body as a string, or an exception.
 * 
 *   If opts contains :body,
 *   It is assumed body is already in a format that can be sent directly in request (already encoded).
 * 
 *   Options
 *   - output-format - can be :text, :json or :binary (default text), or special format (wikidata) to handle wikidata errors, which come back as html.
 * 
 *   
 */
fluree.db.util.xhttp.get = (function fluree$db$util$xhttp$get(url,opts){
var map__31636 = opts;
var map__31636__$1 = cljs.core.__destructure_map(map__31636);
var request_timeout = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31636__$1,cljs.core.cst$kw$request_DASH_timeout,(5000));
var token = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31636__$1,cljs.core.cst$kw$token);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31636__$1,cljs.core.cst$kw$headers);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31636__$1,cljs.core.cst$kw$body);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__31636__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$text);
var response_chan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var headers__$1 = (function (){var G__31637 = cljs.core.PersistentArrayMap.EMPTY;
var G__31637__$1 = (cljs.core.truth_(headers)?cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([G__31637,headers], 0)):G__31637);
if(cljs.core.truth_(token)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31637__$1,"Authorization",["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(token)].join(''));
} else {
return G__31637__$1;
}
})();
fluree.db.util.xhttp.node$module$axios.request(cljs.core.clj__GT_js(new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$url,url,cljs.core.cst$kw$method,"get",cljs.core.cst$kw$timeout,request_timeout,cljs.core.cst$kw$headers,headers__$1], null))).then((function (resp){
var data = cljs.core.cst$kw$data.cljs$core$IFn$_invoke$arity$1(cljs.core.js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(resp,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$keywordize_DASH_keys,true], 0)));
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,(function (){var G__31638 = output_format;
var G__31638__$1 = (((G__31638 instanceof cljs.core.Keyword))?G__31638.fqn:null);
switch (G__31638__$1) {
case "text":
return data;

break;
case "json":
return fluree.db.util.json.stringify(data);

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("http get only supports output formats of json and text.",cljs.core.PersistentArrayMap.EMPTY);

}
})());
})).catch((function (err){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(response_chan,fluree.db.util.xhttp.format_error_response(url,err));
}));

return response_chan;
});
/**
 * http get with JSON response.
 * 
 *   If opts contains :body key, it is encoded into JSON and sent as part
 *   of the body.
 */
fluree.db.util.xhttp.get_json = (function fluree$db$util$xhttp$get_json(url,opts){
var opts_STAR_ = (function (){var G__31640 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc_in(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"Accept"], null),"application/json"),cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$json);
if(cljs.core.truth_(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__31640,cljs.core.cst$kw$body,fluree.db.util.json.stringify(cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(opts)));
} else {
return G__31640;
}
})();
return fluree.db.util.xhttp.get(url,opts_STAR_);
});
fluree.db.util.xhttp.socket_publish_loop = (function fluree$db$util$xhttp$socket_publish_loop(ws,pub_chan){
var c__10876__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_31672){
var state_val_31673 = (state_31672[(1)]);
if((state_val_31673 === (7))){
var inst_31668 = (state_31672[(2)]);
var state_31672__$1 = state_31672;
var statearr_31674_31699 = state_31672__$1;
(statearr_31674_31699[(2)] = inst_31668);

(statearr_31674_31699[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (1))){
var state_31672__$1 = state_31672;
var statearr_31675_31700 = state_31672__$1;
(statearr_31675_31700[(2)] = null);

(statearr_31675_31700[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (4))){
var inst_31643 = (state_31672[(7)]);
var inst_31643__$1 = (state_31672[(2)]);
var inst_31644 = (inst_31643__$1 == null);
var state_31672__$1 = (function (){var statearr_31676 = state_31672;
(statearr_31676[(7)] = inst_31643__$1);

return statearr_31676;
})();
if(cljs.core.truth_(inst_31644)){
var statearr_31677_31701 = state_31672__$1;
(statearr_31677_31701[(1)] = (5));

} else {
var statearr_31678_31702 = state_31672__$1;
(statearr_31678_31702[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (6))){
var inst_31643 = (state_31672[(7)]);
var inst_31651 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31643,(0),null);
var inst_31652 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31643,(1),null);
var state_31672__$1 = (function (){var statearr_31679 = state_31672;
(statearr_31679[(8)] = inst_31652);

(statearr_31679[(9)] = inst_31651);

return statearr_31679;
})();
var statearr_31680_31703 = state_31672__$1;
(statearr_31680_31703[(2)] = null);

(statearr_31680_31703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (3))){
var inst_31670 = (state_31672[(2)]);
var state_31672__$1 = state_31672;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31672__$1,inst_31670);
} else {
if((state_val_31673 === (2))){
var state_31672__$1 = state_31672;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31672__$1,(4),pub_chan);
} else {
if((state_val_31673 === (11))){
var _ = (function (){var statearr_31682 = state_31672;
(statearr_31682[(4)] = cljs.core.rest((state_31672[(4)])));

return statearr_31682;
})();
var state_31672__$1 = state_31672;
var ex31681 = (state_31672__$1[(2)]);
var statearr_31683_31704 = state_31672__$1;
(statearr_31683_31704[(5)] = ex31681);


var statearr_31684_31705 = state_31672__$1;
(statearr_31684_31705[(1)] = (10));

(statearr_31684_31705[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (9))){
var inst_31665 = (state_31672[(2)]);
var state_31672__$1 = (function (){var statearr_31685 = state_31672;
(statearr_31685[(10)] = inst_31665);

return statearr_31685;
})();
var statearr_31686_31706 = state_31672__$1;
(statearr_31686_31706[(2)] = null);

(statearr_31686_31706[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (5))){
var inst_31646 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Web socket pub/producer channel closed."], 0));
var state_31672__$1 = state_31672;
var statearr_31687_31707 = state_31672__$1;
(statearr_31687_31707[(2)] = inst_31646);

(statearr_31687_31707[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (10))){
var inst_31652 = (state_31672[(8)]);
var inst_31651 = (state_31672[(9)]);
var inst_31653 = (state_31672[(2)]);
var inst_31654 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_31653,"Error sending websocket message:",inst_31651], 0));
var inst_31655 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31652,false);
var state_31672__$1 = (function (){var statearr_31688 = state_31672;
(statearr_31688[(11)] = inst_31654);

return statearr_31688;
})();
var statearr_31689_31708 = state_31672__$1;
(statearr_31689_31708[(2)] = inst_31655);

(statearr_31689_31708[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31673 === (8))){
var inst_31652 = (state_31672[(8)]);
var inst_31651 = (state_31672[(9)]);
var _ = (function (){var statearr_31690 = state_31672;
(statearr_31690[(4)] = cljs.core.cons((11),(state_31672[(4)])));

return statearr_31690;
})();
var inst_31661 = ws.send(inst_31651);
var inst_31662 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_31652,true);
var ___$1 = (function (){var statearr_31691 = state_31672;
(statearr_31691[(4)] = cljs.core.rest((state_31672[(4)])));

return statearr_31691;
})();
var state_31672__$1 = (function (){var statearr_31692 = state_31672;
(statearr_31692[(12)] = inst_31661);

return statearr_31692;
})();
var statearr_31693_31709 = state_31672__$1;
(statearr_31693_31709[(2)] = inst_31662);

(statearr_31693_31709[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__ = null;
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____0 = (function (){
var statearr_31694 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31694[(0)] = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__);

(statearr_31694[(1)] = (1));

return statearr_31694;
});
var fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____1 = (function (state_31672){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_31672);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e31695){var ex__10753__auto__ = e31695;
var statearr_31696_31710 = state_31672;
(statearr_31696_31710[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_31672[(4)]))){
var statearr_31697_31711 = state_31672;
(statearr_31697_31711[(1)] = cljs.core.first((state_31672[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__31712 = state_31672;
state_31672 = G__31712;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__ = function(state_31672){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____1.call(this,state_31672);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____0;
fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto____1;
return fluree$db$util$xhttp$socket_publish_loop_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_31698 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_31698[(6)] = c__10876__auto__);

return statearr_31698;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));

return c__10876__auto__;
});
fluree.db.util.xhttp.close_websocket = (function fluree$db$util$xhttp$close_websocket(ws){
return ws.close();
});
fluree.db.util.xhttp.try_socket = (function fluree$db$util$xhttp$try_socket(url,sub_chan,pub_chan,resp_chan,timeout,close_fn){
var ws = (((cljs.core._STAR_target_STAR_ === "nodejs"))?(new fluree.db.util.xhttp.node$module$ws(url)):(new WebSocket(url)));
var open_QMARK_ = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var timeout_chan = cljs.core.async.timeout(timeout);
(ws.binaryType = "arraybuffer");

(ws.onopen = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(open_QMARK_,true);
}));

(ws.onmessage = (function (e){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(sub_chan,e.data);
}));

(ws.onclose = (function (e){
fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Websocket closed: ",e.reason,"Code: ",e.code], 0));

return (close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
}));

var c__10876__auto___31750 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__10877__auto__ = (function (){var switch__10749__auto__ = (function (state_31737){
var state_val_31738 = (state_31737[(1)]);
if((state_val_31738 === (1))){
var inst_31716 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31717 = [open_QMARK_,timeout_chan];
var inst_31718 = (new cljs.core.PersistentVector(null,2,(5),inst_31716,inst_31717,null));
var state_31737__$1 = state_31737;
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic(state_31737__$1,(2),inst_31718,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$priority,true], 0));
} else {
if((state_val_31738 === (2))){
var inst_31720 = (state_31737[(2)]);
var inst_31721 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31720,(0),null);
var inst_31722 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31720,(1),null);
var inst_31723 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31722,timeout_chan);
var state_31737__$1 = (function (){var statearr_31739 = state_31737;
(statearr_31739[(7)] = inst_31721);

return statearr_31739;
})();
if(inst_31723){
var statearr_31740_31751 = state_31737__$1;
(statearr_31740_31751[(1)] = (3));

} else {
var statearr_31741_31752 = state_31737__$1;
(statearr_31741_31752[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31738 === (3))){
var inst_31725 = ["Timeout reached, unable to establish communication to server, which responded healthy: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(url)].join('');
var inst_31726 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31727 = [(400),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_31728 = cljs.core.PersistentHashMap.fromArrays(inst_31726,inst_31727);
var inst_31729 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31725,inst_31728);
var inst_31730 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,inst_31729);
var inst_31731 = fluree.db.util.xhttp.close_websocket(ws);
var state_31737__$1 = (function (){var statearr_31742 = state_31737;
(statearr_31742[(8)] = inst_31730);

return statearr_31742;
})();
var statearr_31743_31753 = state_31737__$1;
(statearr_31743_31753[(2)] = inst_31731);

(statearr_31743_31753[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31738 === (4))){
var inst_31733 = fluree.db.util.xhttp.socket_publish_loop(ws,pub_chan);
var state_31737__$1 = state_31737;
var statearr_31744_31754 = state_31737__$1;
(statearr_31744_31754[(2)] = inst_31733);

(statearr_31744_31754[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31738 === (5))){
var inst_31735 = (state_31737[(2)]);
var state_31737__$1 = state_31737;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31737__$1,inst_31735);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__ = null;
var fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____0 = (function (){
var statearr_31745 = [null,null,null,null,null,null,null,null,null];
(statearr_31745[(0)] = fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__);

(statearr_31745[(1)] = (1));

return statearr_31745;
});
var fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____1 = (function (state_31737){
while(true){
var ret_value__10751__auto__ = (function (){try{while(true){
var result__10752__auto__ = switch__10749__auto__(state_31737);
if(cljs.core.keyword_identical_QMARK_(result__10752__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__10752__auto__;
}
break;
}
}catch (e31746){var ex__10753__auto__ = e31746;
var statearr_31747_31755 = state_31737;
(statearr_31747_31755[(2)] = ex__10753__auto__);


if(cljs.core.seq((state_31737[(4)]))){
var statearr_31748_31756 = state_31737;
(statearr_31748_31756[(1)] = cljs.core.first((state_31737[(4)])));

} else {
throw ex__10753__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__10751__auto__,cljs.core.cst$kw$recur)){
var G__31757 = state_31737;
state_31737 = G__31757;
continue;
} else {
return ret_value__10751__auto__;
}
break;
}
});
fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__ = function(state_31737){
switch(arguments.length){
case 0:
return fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____0.call(this);
case 1:
return fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____1.call(this,state_31737);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____0;
fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto____1;
return fluree$db$util$xhttp$try_socket_$_state_machine__10750__auto__;
})()
})();
var state__10878__auto__ = (function (){var statearr_31749 = (f__10877__auto__.cljs$core$IFn$_invoke$arity$0 ? f__10877__auto__.cljs$core$IFn$_invoke$arity$0() : f__10877__auto__.call(null));
(statearr_31749[(6)] = c__10876__auto___31750);

return statearr_31749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__10878__auto__);
}));


return cljs.core.cst$kw$fluree$db$util$xhttp_SLASH_no_DASH_return;
});
