// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__76363 = (line + (1));
var G__76364 = (1);
var G__76365 = (counter + (1));
line = G__76363;
col = G__76364;
counter = G__76365;
continue;
} else {
var G__76366 = line;
var G__76367 = (col + (1));
var G__76368 = (counter + (1));
line = G__76366;
col = G__76367;
counter = G__76368;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__76369 = cljs.core.next(chars);
var G__76370 = (n__$1 - (1));
chars = G__76369;
n__$1 = G__76370;
continue;
} else {
var G__76371 = cljs.core.next(chars);
var G__76372 = n__$1;
chars = G__76371;
n__$1 = G__76372;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__76373){
var map__76374 = p__76373;
var map__76374__$1 = cljs.core.__destructure_map(map__76374);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76374__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76374__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76374__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76374__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__76375_76383 = cljs.core.seq(full_reasons);
var chunk__76376_76384 = null;
var count__76377_76385 = (0);
var i__76378_76386 = (0);
while(true){
if((i__76378_76386 < count__76377_76385)){
var r_76387 = chunk__76376_76384.cljs$core$IIndexed$_nth$arity$2(null,i__76378_76386);
instaparse.failure.print_reason(r_76387);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76388 = seq__76375_76383;
var G__76389 = chunk__76376_76384;
var G__76390 = count__76377_76385;
var G__76391 = (i__76378_76386 + (1));
seq__76375_76383 = G__76388;
chunk__76376_76384 = G__76389;
count__76377_76385 = G__76390;
i__76378_76386 = G__76391;
continue;
} else {
var temp__5753__auto___76392 = cljs.core.seq(seq__76375_76383);
if(temp__5753__auto___76392){
var seq__76375_76393__$1 = temp__5753__auto___76392;
if(cljs.core.chunked_seq_QMARK_(seq__76375_76393__$1)){
var c__4638__auto___76394 = cljs.core.chunk_first(seq__76375_76393__$1);
var G__76395 = cljs.core.chunk_rest(seq__76375_76393__$1);
var G__76396 = c__4638__auto___76394;
var G__76397 = cljs.core.count(c__4638__auto___76394);
var G__76398 = (0);
seq__76375_76383 = G__76395;
chunk__76376_76384 = G__76396;
count__76377_76385 = G__76397;
i__76378_76386 = G__76398;
continue;
} else {
var r_76399 = cljs.core.first(seq__76375_76393__$1);
instaparse.failure.print_reason(r_76399);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76400 = cljs.core.next(seq__76375_76393__$1);
var G__76401 = null;
var G__76402 = (0);
var G__76403 = (0);
seq__76375_76383 = G__76400;
chunk__76376_76384 = G__76401;
count__76377_76385 = G__76402;
i__76378_76386 = G__76403;
continue;
}
} else {
}
}
break;
}

var seq__76379 = cljs.core.seq(partial_reasons);
var chunk__76380 = null;
var count__76381 = (0);
var i__76382 = (0);
while(true){
if((i__76382 < count__76381)){
var r = chunk__76380.cljs$core$IIndexed$_nth$arity$2(null,i__76382);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76404 = seq__76379;
var G__76405 = chunk__76380;
var G__76406 = count__76381;
var G__76407 = (i__76382 + (1));
seq__76379 = G__76404;
chunk__76380 = G__76405;
count__76381 = G__76406;
i__76382 = G__76407;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__76379);
if(temp__5753__auto__){
var seq__76379__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__76379__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__76379__$1);
var G__76408 = cljs.core.chunk_rest(seq__76379__$1);
var G__76409 = c__4638__auto__;
var G__76410 = cljs.core.count(c__4638__auto__);
var G__76411 = (0);
seq__76379 = G__76408;
chunk__76380 = G__76409;
count__76381 = G__76410;
i__76382 = G__76411;
continue;
} else {
var r = cljs.core.first(seq__76379__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76412 = cljs.core.next(seq__76379__$1);
var G__76413 = null;
var G__76414 = (0);
var G__76415 = (0);
seq__76379 = G__76412;
chunk__76380 = G__76413;
count__76381 = G__76414;
i__76382 = G__76415;
continue;
}
} else {
return null;
}
}
break;
}
});
