// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('cljs.compiler');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.analyzer');
goog.require('cljs.analyzer.impl');
goog.require('cljs.env');
goog.require('cljs.source_map');
goog.require('cljs.tools.reader');
goog.require('clojure.set');
goog.require('clojure.string');
goog.require('goog.string');
goog.require('goog.string.StringBuffer');
cljs.compiler.js_reserved = cljs.analyzer.js_reserved;
cljs.compiler.es5_GT__EQ_ = cljs.core.into.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentHashSet.EMPTY,cljs.core.comp.cljs$core$IFn$_invoke$arity$1(cljs.core.mapcat.cljs$core$IFn$_invoke$arity$1((function (lang){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [lang,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(clojure.string.replace(cljs.core.name(lang),/^ecmascript/,"es"))], null);
}))),new cljs.core.PersistentVector(null, 9, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ecmascript5,cljs.core.cst$kw$ecmascript5_DASH_strict,cljs.core.cst$kw$ecmascript6,cljs.core.cst$kw$ecmascript6_DASH_strict,cljs.core.cst$kw$ecmascript_DASH_2015,cljs.core.cst$kw$ecmascript6_DASH_typed,cljs.core.cst$kw$ecmascript_DASH_2016,cljs.core.cst$kw$ecmascript_DASH_2017,cljs.core.cst$kw$ecmascript_DASH_next], null));
cljs.compiler._STAR_recompiled_STAR_ = null;
cljs.compiler._STAR_inputs_STAR_ = null;
cljs.compiler._STAR_source_map_data_STAR_ = null;
cljs.compiler._STAR_source_map_data_gen_col_STAR_ = null;
cljs.compiler._STAR_lexical_renames_STAR_ = cljs.core.PersistentArrayMap.EMPTY;
cljs.compiler.cljs_reserved_file_names = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["deps.cljs",null], null), null);
/**
 * Gets the part up to the first `.` of a namespace.
 * Returns the empty string for nil.
 * Returns the entire string if no `.` in namespace
 */
cljs.compiler.get_first_ns_segment = (function cljs$compiler$get_first_ns_segment(ns){
var ns__$1 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
var idx = ns__$1.indexOf(".");
if(((-1) === idx)){
return ns__$1;
} else {
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(ns__$1,(0),idx);
}
});
cljs.compiler.find_ns_starts_with = (function cljs$compiler$find_ns_starts_with(needle){
return cljs.core.reduce_kv((function (xs,ns,_){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(needle,cljs.compiler.get_first_ns_segment(ns))){
return cljs.core.reduced(needle);
} else {
return null;
}
}),null,cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
});
cljs.compiler.shadow_depth = (function cljs$compiler$shadow_depth(s){
var map__11524 = s;
var map__11524__$1 = cljs.core.__destructure_map(map__11524);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11524__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11524__$1,cljs.core.cst$kw$info);
var d = (0);
var G__11526 = info;
var map__11527 = G__11526;
var map__11527__$1 = cljs.core.__destructure_map(map__11527);
var shadow = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11527__$1,cljs.core.cst$kw$shadow);
var d__$1 = d;
var G__11526__$1 = G__11526;
while(true){
var d__$2 = d__$1;
var map__11529 = G__11526__$1;
var map__11529__$1 = cljs.core.__destructure_map(map__11529);
var shadow__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11529__$1,cljs.core.cst$kw$shadow);
if(cljs.core.truth_(shadow__$1)){
var G__11530 = (d__$2 + (1));
var G__11531 = shadow__$1;
d__$1 = G__11530;
G__11526__$1 = G__11531;
continue;
} else {
if(cljs.core.truth_((cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.find_ns_starts_with.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)) : cljs.compiler.find_ns_starts_with.call(null,cljs.core.str.cljs$core$IFn$_invoke$arity$1(name))))){
return (d__$2 + (1));
} else {
return d__$2;

}
}
break;
}
});
cljs.compiler.hash_scope = (function cljs$compiler$hash_scope(s){
return cljs.core.hash_combine(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(s).cljs$core$IHash$_hash$arity$1(null),cljs.compiler.shadow_depth(s));
});
cljs.compiler.fn_self_name = (function cljs$compiler$fn_self_name(p__11532){
var map__11533 = p__11532;
var map__11533__$1 = cljs.core.__destructure_map(map__11533);
var name_var = map__11533__$1;
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11533__$1,cljs.core.cst$kw$name);
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11533__$1,cljs.core.cst$kw$info);
var name__$1 = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"..","_DOT__DOT_");
var map__11534 = info;
var map__11534__$1 = cljs.core.__destructure_map(map__11534);
var ns = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11534__$1,cljs.core.cst$kw$ns);
var fn_scope = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11534__$1,cljs.core.cst$kw$fn_DASH_scope);
var scoped_name = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.interpose.cljs$core$IFn$_invoke$arity$2("_$_",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.cst$kw$name),fn_scope),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [name__$1], null))));
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1((function (){var G__11535 = [clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),".","$"),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(scoped_name)].join('');
return (cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(G__11535) : cljs.compiler.munge.call(null,G__11535));
})());
});
cljs.compiler.munge_reserved = (function cljs$compiler$munge_reserved(reserved){
return (function (s){
if((!((cljs.core.get.cljs$core$IFn$_invoke$arity$2(reserved,s) == null)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"$"].join('');
} else {
return s;
}
});
});
cljs.compiler.munge = (function cljs$compiler$munge(var_args){
var G__11537 = arguments.length;
switch (G__11537) {
case 1:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1 = (function (s){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(s,cljs.compiler.js_reserved);
}));

(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2 = (function (s,reserved){
if(cljs.analyzer.impl.cljs_map_QMARK_(s)){
var name_var = s;
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(name_var);
var field = cljs.core.cst$kw$field.cljs$core$IFn$_invoke$arity$1(name_var);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(name_var);
if((!((cljs.core.cst$kw$fn_DASH_self_DASH_name.cljs$core$IFn$_invoke$arity$1(info) == null)))){
return cljs.compiler.fn_self_name(s);
} else {
var depth = cljs.compiler.shadow_depth(s);
var code = cljs.compiler.hash_scope(s);
var renamed = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,code);
var name__$1 = ((field === true)?["self__.",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join(''):(((!((renamed == null))))?renamed:name
));
var munged_name = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(name__$1,reserved);
if(((field === true) || ((depth === (0))))){
return munged_name;
} else {
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(munged_name),"__$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(depth)].join(''));
}
}
} else {
var ss = clojure.string.replace(cljs.core.str.cljs$core$IFn$_invoke$arity$1(s),"..","_DOT__DOT_");
var ss__$1 = clojure.string.replace(ss,(new RegExp("\\/(.)")),".$1");
var rf = cljs.compiler.munge_reserved(reserved);
var ss__$2 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(rf,clojure.string.split.cljs$core$IFn$_invoke$arity$2(ss__$1,/\./));
var ss__$3 = clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",ss__$2);
var ms = (function (){var fexpr__11538 = new cljs.core.Var(function(){return cljs.core.munge_str;},cljs.core.cst$sym$cljs$core_SLASH_munge_DASH_str,cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$private,cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$tag,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test],[true,cljs.core.cst$sym$cljs$core,cljs.core.cst$sym$munge_DASH_str,"cljs/core.cljs",25,1,11639,11639,cljs.core.cst$sym$string,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$name], null)),null,(cljs.core.truth_(cljs.core.munge_str)?cljs.core.munge_str.cljs$lang$test:null)]));
return (fexpr__11538.cljs$core$IFn$_invoke$arity$1 ? fexpr__11538.cljs$core$IFn$_invoke$arity$1(ss__$3) : fexpr__11538.call(null,ss__$3));
})();
if((s instanceof cljs.core.Symbol)){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(ms);
} else {
return ms;
}
}
}));

(cljs.compiler.munge.cljs$lang$maxFixedArity = 2);

cljs.compiler.comma_sep = (function cljs$compiler$comma_sep(xs){
return cljs.core.interpose.cljs$core$IFn$_invoke$arity$2(",",xs);
});
cljs.compiler.escape_char = (function cljs$compiler$escape_char(c){
var cp = goog.string.hashCode(c);
var G__11540 = cp;
switch (G__11540) {
case (34):
return "\\\"";

break;
case (92):
return "\\\\";

break;
case (8):
return "\\b";

break;
case (12):
return "\\f";

break;
case (10):
return "\\n";

break;
case (13):
return "\\r";

break;
case (9):
return "\\t";

break;
default:
if(((((31) < cp)) && ((cp < (127))))){
return c;
} else {
var unpadded = cp.toString((16));
var pad = cljs.core.subs.cljs$core$IFn$_invoke$arity$2("0000",unpadded.length);
return ["\\u",pad,cljs.core.str.cljs$core$IFn$_invoke$arity$1(unpadded)].join('');
}

}
});
cljs.compiler.escape_string = (function cljs$compiler$escape_string(s){
var sb = (new goog.string.StringBuffer());
var seq__11542_11546 = cljs.core.seq(s);
var chunk__11543_11547 = null;
var count__11544_11548 = (0);
var i__11545_11549 = (0);
while(true){
if((i__11545_11549 < count__11544_11548)){
var c_11550 = chunk__11543_11547.cljs$core$IIndexed$_nth$arity$2(null,i__11545_11549);
sb.append(cljs.compiler.escape_char(c_11550));


var G__11551 = seq__11542_11546;
var G__11552 = chunk__11543_11547;
var G__11553 = count__11544_11548;
var G__11554 = (i__11545_11549 + (1));
seq__11542_11546 = G__11551;
chunk__11543_11547 = G__11552;
count__11544_11548 = G__11553;
i__11545_11549 = G__11554;
continue;
} else {
var temp__5753__auto___11555 = cljs.core.seq(seq__11542_11546);
if(temp__5753__auto___11555){
var seq__11542_11556__$1 = temp__5753__auto___11555;
if(cljs.core.chunked_seq_QMARK_(seq__11542_11556__$1)){
var c__4638__auto___11557 = cljs.core.chunk_first(seq__11542_11556__$1);
var G__11558 = cljs.core.chunk_rest(seq__11542_11556__$1);
var G__11559 = c__4638__auto___11557;
var G__11560 = cljs.core.count(c__4638__auto___11557);
var G__11561 = (0);
seq__11542_11546 = G__11558;
chunk__11543_11547 = G__11559;
count__11544_11548 = G__11560;
i__11545_11549 = G__11561;
continue;
} else {
var c_11562 = cljs.core.first(seq__11542_11556__$1);
sb.append(cljs.compiler.escape_char(c_11562));


var G__11563 = cljs.core.next(seq__11542_11556__$1);
var G__11564 = null;
var G__11565 = (0);
var G__11566 = (0);
seq__11542_11546 = G__11563;
chunk__11543_11547 = G__11564;
count__11544_11548 = G__11565;
i__11545_11549 = G__11566;
continue;
}
} else {
}
}
break;
}

return sb.toString();
});
cljs.compiler.wrap_in_double_quotes = (function cljs$compiler$wrap_in_double_quotes(x){
return ["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"\""].join('');
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11567 = cljs.core.get_global_hierarchy;
return (fexpr__11567.cljs$core$IFn$_invoke$arity$0 ? fexpr__11567.cljs$core$IFn$_invoke$arity$0() : fexpr__11567.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit*"),cljs.core.cst$kw$op,cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
cljs.compiler.emit = (function cljs$compiler$emit(ast){
if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
var map__11568_11573 = ast;
var map__11568_11574__$1 = cljs.core.__destructure_map(map__11568_11573);
var env_11575 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11568_11574__$1,cljs.core.cst$kw$env);
if(cljs.core.truth_(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(env_11575))){
var map__11569_11576 = env_11575;
var map__11569_11577__$1 = cljs.core.__destructure_map(map__11569_11576);
var line_11578 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11569_11577__$1,cljs.core.cst$kw$line);
var column_11579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11569_11577__$1,cljs.core.cst$kw$column);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (m){
var minfo = (function (){var G__11570 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$gcol,cljs.core.cst$kw$gen_DASH_col.cljs$core$IFn$_invoke$arity$1(m),cljs.core.cst$kw$gline,cljs.core.cst$kw$gen_DASH_line.cljs$core$IFn$_invoke$arity$1(m)], null);
if(cljs.core.truth_((function (){var G__11572 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(ast);
var fexpr__11571 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$binding,null,cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__11571.cljs$core$IFn$_invoke$arity$1 ? fexpr__11571.cljs$core$IFn$_invoke$arity$1(G__11572) : fexpr__11571.call(null,G__11572));
})())){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__11570,cljs.core.cst$kw$name,cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(ast))));
} else {
return G__11570;
}
})();
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(m,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$source_DASH_map,(line_11578 - (1))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (line__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(line__$1,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(column_11579)?(column_11579 - (1)):(0))], null),cljs.core.fnil.cljs$core$IFn$_invoke$arity$2((function (column__$1){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(column__$1,minfo);
}),cljs.core.PersistentVector.EMPTY));
}),cljs.core.sorted_map()));
}));
} else {
}
} else {
}

return (cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_STAR_.cljs$core$IFn$_invoke$arity$1(ast) : cljs.compiler.emit_STAR_.call(null,ast));
});
cljs.compiler.emits = (function cljs$compiler$emits(var_args){
var G__11588 = arguments.length;
switch (G__11588) {
case 0:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___11595 = arguments.length;
var i__4819__auto___11596 = (0);
while(true){
if((i__4819__auto___11596 < len__4818__auto___11595)){
args_arr__4839__auto__.push((arguments[i__4819__auto___11596]));

var G__11597 = (i__4819__auto___11596 + (1));
i__4819__auto___11596 = G__11597;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$0 = (function (){
return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1 = (function (a){
if((a == null)){
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(a)){
cljs.compiler.emit(a);
} else {
if(cljs.analyzer.impl.cljs_seq_QMARK_(a)){
cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.compiler.emits,a);
} else {
if(typeof a === 'function'){
(a.cljs$core$IFn$_invoke$arity$0 ? a.cljs$core$IFn$_invoke$arity$0() : a.call(null));
} else {
var s_11598 = (function (){var G__11589 = a;
if((!(typeof a === 'string'))){
return G__11589.toString();
} else {
return G__11589;
}
})();
var temp__5757__auto___11599 = cljs.compiler._STAR_source_map_data_STAR_;
if((temp__5757__auto___11599 == null)){
} else {
var sm_data_11600 = temp__5757__auto___11599;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(sm_data_11600,cljs.core.update,cljs.core.cst$kw$gen_DASH_col,(function (p1__11580_SHARP_){
return (p1__11580_SHARP_ + s_11598.length);
}));
}

cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([s_11598], 0));

}
}
}
}

return null;
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);
}));

(cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11590 = cljs.core.seq(xs);
var chunk__11591 = null;
var count__11592 = (0);
var i__11593 = (0);
while(true){
if((i__11593 < count__11592)){
var x = chunk__11591.cljs$core$IIndexed$_nth$arity$2(null,i__11593);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11601 = seq__11590;
var G__11602 = chunk__11591;
var G__11603 = count__11592;
var G__11604 = (i__11593 + (1));
seq__11590 = G__11601;
chunk__11591 = G__11602;
count__11592 = G__11603;
i__11593 = G__11604;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11590);
if(temp__5753__auto__){
var seq__11590__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11590__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__11590__$1);
var G__11605 = cljs.core.chunk_rest(seq__11590__$1);
var G__11606 = c__4638__auto__;
var G__11607 = cljs.core.count(c__4638__auto__);
var G__11608 = (0);
seq__11590 = G__11605;
chunk__11591 = G__11606;
count__11592 = G__11607;
i__11593 = G__11608;
continue;
} else {
var x = cljs.core.first(seq__11590__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x);


var G__11609 = cljs.core.next(seq__11590__$1);
var G__11610 = null;
var G__11611 = (0);
var G__11612 = (0);
seq__11590 = G__11609;
chunk__11591 = G__11610;
count__11592 = G__11611;
i__11593 = G__11612;
continue;
}
} else {
return null;
}
}
break;
}
}));

/** @this {Function} */
(cljs.compiler.emits.cljs$lang$applyTo = (function (seq11582){
var G__11583 = cljs.core.first(seq11582);
var seq11582__$1 = cljs.core.next(seq11582);
var G__11584 = cljs.core.first(seq11582__$1);
var seq11582__$2 = cljs.core.next(seq11582__$1);
var G__11585 = cljs.core.first(seq11582__$2);
var seq11582__$3 = cljs.core.next(seq11582__$2);
var G__11586 = cljs.core.first(seq11582__$3);
var seq11582__$4 = cljs.core.next(seq11582__$3);
var G__11587 = cljs.core.first(seq11582__$4);
var seq11582__$5 = cljs.core.next(seq11582__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11583,G__11584,G__11585,G__11586,G__11587,seq11582__$5);
}));

(cljs.compiler.emits.cljs$lang$maxFixedArity = (5));

cljs.compiler._emitln = (function cljs$compiler$_emitln(){
cljs.core.newline.cljs$core$IFn$_invoke$arity$0();

if(cljs.core.truth_(cljs.compiler._STAR_source_map_data_STAR_)){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_source_map_data_STAR_,(function (p__11613){
var map__11614 = p__11613;
var map__11614__$1 = cljs.core.__destructure_map(map__11614);
var m = map__11614__$1;
var gen_line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11614__$1,cljs.core.cst$kw$gen_DASH_line);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(m,cljs.core.cst$kw$gen_DASH_line,(gen_line + (1)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$gen_DASH_col,(0)], 0));
}));
} else {
}

return null;
});
cljs.compiler.emitln = (function cljs$compiler$emitln(var_args){
var G__11622 = arguments.length;
switch (G__11622) {
case 0:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
var args_arr__4839__auto__ = [];
var len__4818__auto___11628 = arguments.length;
var i__4819__auto___11629 = (0);
while(true){
if((i__4819__auto___11629 < len__4818__auto___11628)){
args_arr__4839__auto__.push((arguments[i__4819__auto___11629]));

var G__11630 = (i__4819__auto___11629 + (1));
i__4819__auto___11629 = G__11630;
continue;
} else {
}
break;
}

var argseq__4840__auto__ = (new cljs.core.IndexedSeq(args_arr__4839__auto__.slice((5)),(0),null));
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),argseq__4840__auto__);

}
});

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1 = (function (a){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

return cljs.compiler._emitln();
}));

(cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic = (function (a,b,c,d,e,xs){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(a);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(b);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(c);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(d);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(e);

var seq__11623_11631 = cljs.core.seq(xs);
var chunk__11624_11632 = null;
var count__11625_11633 = (0);
var i__11626_11634 = (0);
while(true){
if((i__11626_11634 < count__11625_11633)){
var x_11635 = chunk__11624_11632.cljs$core$IIndexed$_nth$arity$2(null,i__11626_11634);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11635);


var G__11636 = seq__11623_11631;
var G__11637 = chunk__11624_11632;
var G__11638 = count__11625_11633;
var G__11639 = (i__11626_11634 + (1));
seq__11623_11631 = G__11636;
chunk__11624_11632 = G__11637;
count__11625_11633 = G__11638;
i__11626_11634 = G__11639;
continue;
} else {
var temp__5753__auto___11640 = cljs.core.seq(seq__11623_11631);
if(temp__5753__auto___11640){
var seq__11623_11641__$1 = temp__5753__auto___11640;
if(cljs.core.chunked_seq_QMARK_(seq__11623_11641__$1)){
var c__4638__auto___11642 = cljs.core.chunk_first(seq__11623_11641__$1);
var G__11643 = cljs.core.chunk_rest(seq__11623_11641__$1);
var G__11644 = c__4638__auto___11642;
var G__11645 = cljs.core.count(c__4638__auto___11642);
var G__11646 = (0);
seq__11623_11631 = G__11643;
chunk__11624_11632 = G__11644;
count__11625_11633 = G__11645;
i__11626_11634 = G__11646;
continue;
} else {
var x_11647 = cljs.core.first(seq__11623_11641__$1);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(x_11647);


var G__11648 = cljs.core.next(seq__11623_11641__$1);
var G__11649 = null;
var G__11650 = (0);
var G__11651 = (0);
seq__11623_11631 = G__11648;
chunk__11624_11632 = G__11649;
count__11625_11633 = G__11650;
i__11626_11634 = G__11651;
continue;
}
} else {
}
}
break;
}

return cljs.compiler._emitln();
}));

/** @this {Function} */
(cljs.compiler.emitln.cljs$lang$applyTo = (function (seq11616){
var G__11617 = cljs.core.first(seq11616);
var seq11616__$1 = cljs.core.next(seq11616);
var G__11618 = cljs.core.first(seq11616__$1);
var seq11616__$2 = cljs.core.next(seq11616__$1);
var G__11619 = cljs.core.first(seq11616__$2);
var seq11616__$3 = cljs.core.next(seq11616__$2);
var G__11620 = cljs.core.first(seq11616__$3);
var seq11616__$4 = cljs.core.next(seq11616__$3);
var G__11621 = cljs.core.first(seq11616__$4);
var seq11616__$5 = cljs.core.next(seq11616__$4);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__11617,G__11618,G__11619,G__11620,G__11621,seq11616__$5);
}));

(cljs.compiler.emitln.cljs$lang$maxFixedArity = (5));

cljs.compiler.emit_str = (function cljs$compiler$emit_str(expr){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__11652_11656 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__11653_11657 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__11654_11658 = true;
var _STAR_print_fn_STAR__temp_val__11655_11659 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__11654_11658);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__11655_11659);

try{cljs.compiler.emit(expr);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__11653_11657);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__11652_11656);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
});
if((typeof cljs !== 'undefined') && (typeof cljs.compiler !== 'undefined') && (typeof cljs.compiler.emit_constant_STAR_ !== 'undefined')){
} else {
cljs.compiler.emit_constant_STAR_ = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__11660 = cljs.core.get_global_hierarchy;
return (fexpr__11660.cljs$core$IFn$_invoke$arity$0 ? fexpr__11660.cljs$core$IFn$_invoke$arity$0() : fexpr__11660.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("cljs.compiler","emit-constant*"),cljs.core.type,cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}









cljs.compiler.all_distinct_QMARK_ = (function cljs$compiler$all_distinct_QMARK_(xs){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,xs);
});
cljs.compiler.emit_constant_no_meta = (function cljs$compiler$emit_constant_no_meta(x){
if(cljs.analyzer.impl.cljs_seq_QMARK_(x)){
return (cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_list.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_list.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.core.record_QMARK_(x)){
var vec__11661 = cljs.analyzer.record_ns_PLUS_name(x);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11661,(0),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11661,(1),null);
var G__11664 = ns;
var G__11665 = name;
var G__11666 = (function (){
var G__11667 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,x);
return (cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant.cljs$core$IFn$_invoke$arity$1(G__11667) : cljs.compiler.emit_constant.call(null,G__11667));
});
return (cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_record_value.cljs$core$IFn$_invoke$arity$3(G__11664,G__11665,G__11666) : cljs.compiler.emit_record_value.call(null,G__11664,G__11665,G__11666));
} else {
if(cljs.analyzer.impl.cljs_map_QMARK_(x)){
var G__11668 = cljs.core.keys(x);
var G__11669 = cljs.core.vals(x);
var G__11670 = cljs.compiler.emit_constants_comma_sep;
var G__11671 = cljs.compiler.all_distinct_QMARK_;
return (cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4 ? cljs.compiler.emit_map.cljs$core$IFn$_invoke$arity$4(G__11668,G__11669,G__11670,G__11671) : cljs.compiler.emit_map.call(null,G__11668,G__11669,G__11670,G__11671));
} else {
if(cljs.analyzer.impl.cljs_vector_QMARK_(x)){
return (cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_vector.cljs$core$IFn$_invoke$arity$2(x,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_vector.call(null,x,cljs.compiler.emit_constants_comma_sep));
} else {
if(cljs.analyzer.impl.cljs_set_QMARK_(x)){
return (cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3 ? cljs.compiler.emit_set.cljs$core$IFn$_invoke$arity$3(x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_) : cljs.compiler.emit_set.call(null,x,cljs.compiler.emit_constants_comma_sep,cljs.compiler.all_distinct_QMARK_));
} else {
return (cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.emit_constant_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.compiler.emit_constant_STAR_.call(null,x));

}
}
}
}
}
});
cljs.compiler.emit_constant = (function cljs$compiler$emit_constant(v){
var m = cljs.analyzer.elide_irrelevant_meta(cljs.core.meta(v));
if((!((cljs.core.seq(m) == null)))){
var G__11672 = (function (){
return cljs.compiler.emit_constant_no_meta(v);
});
var G__11673 = (function (){
return cljs.compiler.emit_constant_no_meta(m);
});
return (cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_with_meta.cljs$core$IFn$_invoke$arity$2(G__11672,G__11673) : cljs.compiler.emit_with_meta.call(null,G__11672,G__11673));
} else {
return cljs.compiler.emit_constant_no_meta(v);
}
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$default,(function (x){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["failed compiling constant: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),"; ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.type(x)], 0))," is not a valid ClojureScript constant."].join(''),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$constant,x,cljs.core.cst$kw$type,cljs.core.type(x),cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,null,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("null");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Number,(function (x){
if(cljs.core.truth_(isNaN(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("NaN");
} else {
if(cljs.core.not(isFinite(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((((x > (0)))?"Infinity":"-Infinity"));
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(",x,")");

}
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,String,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.wrap_in_double_quotes(cljs.compiler.escape_string(x)));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Boolean,(function (x){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1((cljs.core.truth_(x)?"true":"false"));
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,RegExp,(function (x){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(new RegExp(\"\"))");
} else {
var vec__11674 = cljs.core.re_find(/^(?:\(\?([idmsux]*)\))?(.*)/,cljs.core.str.cljs$core$IFn$_invoke$arity$1(x));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11674,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11674,(1),null);
var pattern = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11674,(2),null);
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(pattern);
}
}));
cljs.compiler.emits_keyword = (function cljs$compiler$emits_keyword(kw){
var ns = cljs.core.namespace(kw);
var name = cljs.core.name(kw);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Keyword(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant((cljs.core.truth_(ns)?[ns,"/",name].join(''):name));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(kw));

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emits_symbol = (function cljs$compiler$emits_symbol(sym){
var ns = cljs.core.namespace(sym);
var name = cljs.core.name(sym);
var symstr = (((!((ns == null))))?[ns,"/",name].join(''):name);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("new cljs.core.Symbol(");

cljs.compiler.emit_constant(ns);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(name);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(symstr);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(cljs.core.hash(sym));

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");

cljs.compiler.emit_constant(null);

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Keyword,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__11677 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11677) : x.call(null,G__11677));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_keyword(x);
}
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.Symbol,(function (x){
var temp__5751__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)));
if(cljs.core.truth_(and__4210__auto__)){
var G__11678 = cljs.core.cst$kw$cljs$analyzer_SLASH_constant_DASH_table.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_));
return (x.cljs$core$IFn$_invoke$arity$1 ? x.cljs$core$IFn$_invoke$arity$1(G__11678) : x.call(null,G__11678));
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var value = temp__5751__auto__;
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2("cljs.core.",value);
} else {
return cljs.compiler.emits_symbol(x);
}
}));
cljs.compiler.emit_constants_comma_sep = (function cljs$compiler$emit_constants_comma_sep(cs){
return (function (){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2((function (i,m){
if(cljs.core.even_QMARK_(i)){
return cljs.compiler.emit_constant(m);
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(m);
}
}),cljs.compiler.comma_sep(cs)));
});
});
cljs.compiler.array_map_threshold = (8);
cljs.compiler.emit_inst = (function cljs$compiler$emit_inst(inst_ms){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("new Date(",inst_ms,")");
});
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,Date,(function (date){
return cljs.compiler.emit_inst(date.getTime());
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.UUID,(function (uuid){
var uuid_str = uuid.toString();
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.UUID(\"",uuid_str,"\", ",cljs.core.hash(uuid_str),")");
}));
cljs.compiler.emit_constant_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.tagged_literals.JSValue,(function (v){
var items = v.val;
if(cljs.core.map_QMARK_(items)){
var G__11680 = items;
var G__11681 = (function (p1__11679_SHARP_){
return (function (){
return cljs.compiler.emit_constant(p1__11679_SHARP_);
});
});
return (cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_object.cljs$core$IFn$_invoke$arity$2(G__11680,G__11681) : cljs.compiler.emit_js_object.call(null,G__11680,G__11681));
} else {
return (cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.emit_js_array.cljs$core$IFn$_invoke$arity$2(items,cljs.compiler.emit_constants_comma_sep) : cljs.compiler.emit_js_array.call(null,items,cljs.compiler.emit_constants_comma_sep));
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$no_DASH_op,(function (m){
return null;
}));
cljs.compiler.emit_var = (function cljs$compiler$emit_var(p__11683){
var map__11684 = p__11683;
var map__11684__$1 = cljs.core.__destructure_map(map__11684);
var ast = map__11684__$1;
var info = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11684__$1,cljs.core.cst$kw$info);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11684__$1,cljs.core.cst$kw$env);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11684__$1,cljs.core.cst$kw$form);
var temp__5751__auto__ = cljs.core.cst$kw$const_DASH_expr.cljs$core$IFn$_invoke$arity$1(ast);
if(cljs.core.truth_(temp__5751__auto__)){
var const_expr = temp__5751__auto__;
return cljs.compiler.emit(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(const_expr,cljs.core.cst$kw$env,env));
} else {
var map__11685 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__11685__$1 = cljs.core.__destructure_map(map__11685);
var cenv = map__11685__$1;
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11685__$1,cljs.core.cst$kw$options);
var var_name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info);
var info__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),"js"))?(function (){var js_module_name = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_module_DASH_index,cljs.core.name(var_name),cljs.core.cst$kw$name], null));
var or__4212__auto__ = js_module_name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})():info);
if(cljs.core.truth_(cljs.core.cst$kw$binding_DASH_form_QMARK_.cljs$core$IFn$_invoke$arity$1(ast))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ast));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var reserved = (function (){var G__11686 = cljs.compiler.js_reserved;
if(cljs.core.truth_((function (){var and__4210__auto__ = (function (){var G__11687 = cljs.core.cst$kw$language_DASH_out.cljs$core$IFn$_invoke$arity$1(options);
return (cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.es5_GT__EQ_.cljs$core$IFn$_invoke$arity$1(G__11687) : cljs.compiler.es5_GT__EQ_.call(null,G__11687));
})();
if(cljs.core.truth_(and__4210__auto__)){
return (!((cljs.core.namespace(var_name) == null)));
} else {
return and__4210__auto__;
}
})())){
return clojure.set.difference.cljs$core$IFn$_invoke$arity$2(G__11686,cljs.analyzer.es5_allowed);
} else {
return G__11686;
}
})();
var js_module = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cenv,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$js_DASH_namespaces,(function (){var or__4212__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.name(var_name);
}
})()], null));
var info__$2 = (function (){var G__11688 = info__$1;
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(form,cljs.core.cst$sym$js_SLASH__DASH_Infinity)){
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(G__11688,reserved);
} else {
return G__11688;
}
})();
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var G__11689_11690 = cljs.core.cst$kw$module_DASH_type.cljs$core$IFn$_invoke$arity$1(js_module);
var G__11689_11691__$1 = (((G__11689_11690 instanceof cljs.core.Keyword))?G__11689_11690.fqn:null);
switch (G__11689_11691__$1) {
case "commonjs":
if(cljs.core.truth_(cljs.core.namespace(var_name))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"].",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.name(var_name),reserved),"[\"default\"]");
}

break;
case "es6":
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.namespace(var_name);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("default",cljs.core.name(var_name));
} else {
return and__4210__auto__;
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(cljs.core.namespace(var_name),reserved),"[\"default\"]");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);
}

break;
default:
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(info__$2);

}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$binding,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_var,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$local,(function (expr){
return cljs.compiler.emit_var(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$the_DASH_var,(function (p__11693){
var map__11694 = p__11693;
var map__11694__$1 = cljs.core.__destructure_map(map__11694);
var arg = map__11694__$1;
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11694__$1,cljs.core.cst$kw$env);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11694__$1,cljs.core.cst$kw$var);
var sym = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11694__$1,cljs.core.cst$kw$sym);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11694__$1,cljs.core.cst$kw$meta);
if(cljs.analyzer.ast_QMARK_(sym)){
} else {
throw (new Error("Assert failed: (ana/ast? sym)"));
}

if(cljs.analyzer.ast_QMARK_(meta)){
} else {
throw (new Error("Assert failed: (ana/ast? meta)"));
}

var map__11695 = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(var$);
var map__11695__$1 = cljs.core.__destructure_map(map__11695);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11695__$1,cljs.core.cst$kw$name);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("new cljs.core.Var(function(){return ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),";},",sym,",",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([meta,")"], 0));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_with_meta = (function cljs$compiler$emit_with_meta(expr,meta){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.with_meta(",expr,",",meta,")");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$with_DASH_meta,(function (p__11696){
var map__11697 = p__11696;
var map__11697__$1 = cljs.core.__destructure_map(map__11697);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11697__$1,cljs.core.cst$kw$expr);
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11697__$1,cljs.core.cst$kw$meta);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11697__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_with_meta(expr,meta);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_keys_QMARK_ = (function cljs$compiler$distinct_keys_QMARK_(keys){
var keys__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,keys);
return ((cljs.core.every_QMARK_((function (p1__11698_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11698_SHARP_),cljs.core.cst$kw$const);
}),keys__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,keys__$1)),cljs.core.count(keys__$1))));
});
cljs.compiler.emit_map = (function cljs$compiler$emit_map(keys,vals,comma_sep,distinct_keys_QMARK_){
if((cljs.core.count(keys) === (0))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentArrayMap.EMPTY");
} else {
if((cljs.core.count(keys) <= cljs.compiler.array_map_threshold)){
if(cljs.core.truth_((distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_keys_QMARK_.cljs$core$IFn$_invoke$arity$1(keys) : distinct_keys_QMARK_.call(null,keys)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentArrayMap(null, ",cljs.core.count(keys),", [",(function (){var G__11699 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11699) : comma_sep.call(null,G__11699));
})(),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentArrayMap.createAsIfByAssoc([",(function (){var G__11700 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(keys,vals);
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11700) : comma_sep.call(null,G__11700));
})(),"])");
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("cljs.core.PersistentHashMap.fromArrays([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(keys) : comma_sep.call(null,keys)),"],[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(vals) : comma_sep.call(null,vals)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$map,(function (p__11701){
var map__11702 = p__11701;
var map__11702__$1 = cljs.core.__destructure_map(map__11702);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11702__$1,cljs.core.cst$kw$env);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11702__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11702__$1,cljs.core.cst$kw$vals);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_map(keys,vals,cljs.compiler.comma_sep,cljs.compiler.distinct_keys_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_list = (function cljs$compiler$emit_list(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.List.EMPTY");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.list(",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),")");
}
});
cljs.compiler.emit_vector = (function cljs$compiler$emit_vector(items,comma_sep){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentVector.EMPTY");
} else {
var cnt = cljs.core.count(items);
if((cnt < (32))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentVector(null, ",cnt,", 5, cljs.core.PersistentVector.EMPTY_NODE, [",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentVector.fromArray([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"], true)");
}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$vector,(function (p__11703){
var map__11704 = p__11703;
var map__11704__$1 = cljs.core.__destructure_map(map__11704);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11704__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11704__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_vector(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.distinct_constants_QMARK_ = (function cljs$compiler$distinct_constants_QMARK_(items){
var items__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.unwrap_quote,items);
return ((cljs.core.every_QMARK_((function (p1__11705_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(p1__11705_SHARP_),cljs.core.cst$kw$const);
}),items__$1)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,items__$1)),cljs.core.count(items__$1))));
});
cljs.compiler.emit_set = (function cljs$compiler$emit_set(items,comma_sep,distinct_constants_QMARK_){
if(cljs.core.empty_QMARK_(items)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("cljs.core.PersistentHashSet.EMPTY");
} else {
if(cljs.core.truth_((distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1 ? distinct_constants_QMARK_.cljs$core$IFn$_invoke$arity$1(items) : distinct_constants_QMARK_.call(null,items)))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, ",cljs.core.count(items),", [",(function (){var G__11706 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(items,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1("null"));
return (comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(G__11706) : comma_sep.call(null,G__11706));
})(),"], null), null)");
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.PersistentHashSet.createAsIfByAssoc([",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"])");

}
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set,(function (p__11707){
var map__11708 = p__11707;
var map__11708__$1 = cljs.core.__destructure_map(map__11708);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11708__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11708__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_set(items,cljs.compiler.comma_sep,cljs.compiler.distinct_constants_QMARK_);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_js_object = (function cljs$compiler$emit_js_object(items,emit_js_object_val){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("({");

var temp__5753__auto___11731 = cljs.core.seq(items);
if(temp__5753__auto___11731){
var items_11732__$1 = temp__5753__auto___11731;
var vec__11709_11733 = items_11732__$1;
var seq__11710_11734 = cljs.core.seq(vec__11709_11733);
var first__11711_11735 = cljs.core.first(seq__11710_11734);
var seq__11710_11736__$1 = cljs.core.next(seq__11710_11734);
var vec__11712_11737 = first__11711_11735;
var k_11738 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11712_11737,(0),null);
var v_11739 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11712_11737,(1),null);
var r_11740 = seq__11710_11736__$1;
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4("\"",cljs.core.name(k_11738),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11739) : emit_js_object_val.call(null,v_11739)));

var seq__11715_11741 = cljs.core.seq(r_11740);
var chunk__11716_11742 = null;
var count__11717_11743 = (0);
var i__11718_11744 = (0);
while(true){
if((i__11718_11744 < count__11717_11743)){
var vec__11725_11745 = chunk__11716_11742.cljs$core$IIndexed$_nth$arity$2(null,i__11718_11744);
var k_11746__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725_11745,(0),null);
var v_11747__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11725_11745,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11746__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11747__$1) : emit_js_object_val.call(null,v_11747__$1)));


var G__11748 = seq__11715_11741;
var G__11749 = chunk__11716_11742;
var G__11750 = count__11717_11743;
var G__11751 = (i__11718_11744 + (1));
seq__11715_11741 = G__11748;
chunk__11716_11742 = G__11749;
count__11717_11743 = G__11750;
i__11718_11744 = G__11751;
continue;
} else {
var temp__5753__auto___11752__$1 = cljs.core.seq(seq__11715_11741);
if(temp__5753__auto___11752__$1){
var seq__11715_11753__$1 = temp__5753__auto___11752__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11715_11753__$1)){
var c__4638__auto___11754 = cljs.core.chunk_first(seq__11715_11753__$1);
var G__11755 = cljs.core.chunk_rest(seq__11715_11753__$1);
var G__11756 = c__4638__auto___11754;
var G__11757 = cljs.core.count(c__4638__auto___11754);
var G__11758 = (0);
seq__11715_11741 = G__11755;
chunk__11716_11742 = G__11756;
count__11717_11743 = G__11757;
i__11718_11744 = G__11758;
continue;
} else {
var vec__11728_11759 = cljs.core.first(seq__11715_11753__$1);
var k_11760__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728_11759,(0),null);
var v_11761__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11728_11759,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(", \"",cljs.core.name(k_11760__$1),"\": ",(emit_js_object_val.cljs$core$IFn$_invoke$arity$1 ? emit_js_object_val.cljs$core$IFn$_invoke$arity$1(v_11761__$1) : emit_js_object_val.call(null,v_11761__$1)));


var G__11762 = cljs.core.next(seq__11715_11753__$1);
var G__11763 = null;
var G__11764 = (0);
var G__11765 = (0);
seq__11715_11741 = G__11762;
chunk__11716_11742 = G__11763;
count__11717_11743 = G__11764;
i__11718_11744 = G__11765;
continue;
}
} else {
}
}
break;
}
} else {
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_js_array = (function cljs$compiler$emit_js_array(items,comma_sep){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("[",(comma_sep.cljs$core$IFn$_invoke$arity$1 ? comma_sep.cljs$core$IFn$_invoke$arity$1(items) : comma_sep.call(null,items)),"]");
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_object,(function (p__11766){
var map__11767 = p__11766;
var map__11767__$1 = cljs.core.__destructure_map(map__11767);
var keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11767__$1,cljs.core.cst$kw$keys);
var vals = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11767__$1,cljs.core.cst$kw$vals);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11767__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_object(cljs.core.map.cljs$core$IFn$_invoke$arity$3(cljs.core.vector,keys,vals),cljs.core.identity);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js_DASH_array,(function (p__11768){
var map__11769 = p__11768;
var map__11769__$1 = cljs.core.__destructure_map(map__11769);
var items = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11769__$1,cljs.core.cst$kw$items);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11769__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_js_array(items,cljs.compiler.comma_sep);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_record_value = (function cljs$compiler$emit_record_value(ns,name,items){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(ns,".map__GT_",name,"(",items,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$quote,(function (p__11770){
var map__11771 = p__11770;
var map__11771__$1 = cljs.core.__destructure_map(map__11771);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11771__$1,cljs.core.cst$kw$expr);
return cljs.compiler.emit(expr);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$const,(function (p__11772){
var map__11773 = p__11772;
var map__11773__$1 = cljs.core.__destructure_map(map__11773);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11773__$1,cljs.core.cst$kw$form);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11773__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emit_constant(form);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.truthy_constant_QMARK_ = (function cljs$compiler$truthy_constant_QMARK_(expr){
var map__11774 = cljs.analyzer.unwrap_quote(expr);
var map__11774__$1 = cljs.core.__destructure_map(map__11774);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11774__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11774__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11774__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const);
if(and__4210__auto__){
var and__4210__auto____$1 = form;
if(cljs.core.truth_(and__4210__auto____$1)){
return (!(((((typeof form === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(form,"")))) || (((typeof form === 'number') && ((form === (0))))))));
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.truthy_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.truthy_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.falsey_constant_QMARK_ = (function cljs$compiler$falsey_constant_QMARK_(expr){
var map__11775 = cljs.analyzer.unwrap_quote(expr);
var map__11775__$1 = cljs.core.__destructure_map(map__11775);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11775__$1,cljs.core.cst$kw$op);
var form = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11775__$1,cljs.core.cst$kw$form);
var const_expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11775__$1,cljs.core.cst$kw$const_DASH_expr);
var or__4212__auto__ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$const)) && (((form === false) || ((form == null)))));
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = (!((const_expr == null)));
if(and__4210__auto__){
return (cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1 ? cljs.compiler.falsey_constant_QMARK_.cljs$core$IFn$_invoke$arity$1(const_expr) : cljs.compiler.falsey_constant_QMARK_.call(null,const_expr));
} else {
return and__4210__auto__;
}
}
});
cljs.compiler.safe_test_QMARK_ = (function cljs$compiler$safe_test_QMARK_(env,e){
var tag = cljs.analyzer.infer_tag(env,e);
var or__4212__auto__ = (function (){var fexpr__11776 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$seq,null,cljs.core.cst$sym$boolean,null], null), null);
return (fexpr__11776.cljs$core$IFn$_invoke$arity$1 ? fexpr__11776.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__11776.call(null,tag));
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.truthy_constant_QMARK_(e);
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$if,(function (p__11777){
var map__11778 = p__11777;
var map__11778__$1 = cljs.core.__destructure_map(map__11778);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11778__$1,cljs.core.cst$kw$test);
var then = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11778__$1,cljs.core.cst$kw$then);
var else$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11778__$1,cljs.core.cst$kw$else);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11778__$1,cljs.core.cst$kw$env);
var unchecked = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11778__$1,cljs.core.cst$kw$unchecked);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
var checked = cljs.core.not((function (){var or__4212__auto__ = unchecked;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.compiler.safe_test_QMARK_(env,test);
}
})());
if(cljs.core.truth_(cljs.compiler.truthy_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then);
} else {
if(cljs.core.truth_(cljs.compiler.falsey_constant_QMARK_(test))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(else$);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",((checked)?"cljs.core.truth_":null),"(",test,")?",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([then,":",else$,")"], 0));
} else {
if(checked){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(cljs.core.truth_(",test,")){");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(",test,"){");
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(then,"} else {");

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(else$,"}");
}

}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$case,(function (p__11779){
var map__11780 = p__11779;
var map__11780__$1 = cljs.core.__destructure_map(map__11780);
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11780__$1,cljs.core.cst$kw$test);
var nodes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11780__$1,cljs.core.cst$kw$nodes);
var default$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11780__$1,cljs.core.cst$kw$default);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11780__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env),cljs.core.cst$kw$expr)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function(){");
} else {
}

var gs = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("caseval__");
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",gs,";");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("switch (",v,") {");

var seq__11781_11809 = cljs.core.seq(nodes);
var chunk__11782_11810 = null;
var count__11783_11811 = (0);
var i__11784_11812 = (0);
while(true){
if((i__11784_11812 < count__11783_11811)){
var map__11797_11813 = chunk__11782_11810.cljs$core$IIndexed$_nth$arity$2(null,i__11784_11812);
var map__11797_11814__$1 = cljs.core.__destructure_map(map__11797_11813);
var ts_11815 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11797_11814__$1,cljs.core.cst$kw$tests);
var map__11798_11816 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11797_11814__$1,cljs.core.cst$kw$then);
var map__11798_11817__$1 = cljs.core.__destructure_map(map__11798_11816);
var then_11818 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11798_11817__$1,cljs.core.cst$kw$then);
var seq__11799_11819 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11815));
var chunk__11800_11820 = null;
var count__11801_11821 = (0);
var i__11802_11822 = (0);
while(true){
if((i__11802_11822 < count__11801_11821)){
var test_11823 = chunk__11800_11820.cljs$core$IIndexed$_nth$arity$2(null,i__11802_11822);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11823,":");


var G__11824 = seq__11799_11819;
var G__11825 = chunk__11800_11820;
var G__11826 = count__11801_11821;
var G__11827 = (i__11802_11822 + (1));
seq__11799_11819 = G__11824;
chunk__11800_11820 = G__11825;
count__11801_11821 = G__11826;
i__11802_11822 = G__11827;
continue;
} else {
var temp__5753__auto___11828 = cljs.core.seq(seq__11799_11819);
if(temp__5753__auto___11828){
var seq__11799_11829__$1 = temp__5753__auto___11828;
if(cljs.core.chunked_seq_QMARK_(seq__11799_11829__$1)){
var c__4638__auto___11830 = cljs.core.chunk_first(seq__11799_11829__$1);
var G__11831 = cljs.core.chunk_rest(seq__11799_11829__$1);
var G__11832 = c__4638__auto___11830;
var G__11833 = cljs.core.count(c__4638__auto___11830);
var G__11834 = (0);
seq__11799_11819 = G__11831;
chunk__11800_11820 = G__11832;
count__11801_11821 = G__11833;
i__11802_11822 = G__11834;
continue;
} else {
var test_11835 = cljs.core.first(seq__11799_11829__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11835,":");


var G__11836 = cljs.core.next(seq__11799_11829__$1);
var G__11837 = null;
var G__11838 = (0);
var G__11839 = (0);
seq__11799_11819 = G__11836;
chunk__11800_11820 = G__11837;
count__11801_11821 = G__11838;
i__11802_11822 = G__11839;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11818);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11818);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11840 = seq__11781_11809;
var G__11841 = chunk__11782_11810;
var G__11842 = count__11783_11811;
var G__11843 = (i__11784_11812 + (1));
seq__11781_11809 = G__11840;
chunk__11782_11810 = G__11841;
count__11783_11811 = G__11842;
i__11784_11812 = G__11843;
continue;
} else {
var temp__5753__auto___11844 = cljs.core.seq(seq__11781_11809);
if(temp__5753__auto___11844){
var seq__11781_11845__$1 = temp__5753__auto___11844;
if(cljs.core.chunked_seq_QMARK_(seq__11781_11845__$1)){
var c__4638__auto___11846 = cljs.core.chunk_first(seq__11781_11845__$1);
var G__11847 = cljs.core.chunk_rest(seq__11781_11845__$1);
var G__11848 = c__4638__auto___11846;
var G__11849 = cljs.core.count(c__4638__auto___11846);
var G__11850 = (0);
seq__11781_11809 = G__11847;
chunk__11782_11810 = G__11848;
count__11783_11811 = G__11849;
i__11784_11812 = G__11850;
continue;
} else {
var map__11803_11851 = cljs.core.first(seq__11781_11845__$1);
var map__11803_11852__$1 = cljs.core.__destructure_map(map__11803_11851);
var ts_11853 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11803_11852__$1,cljs.core.cst$kw$tests);
var map__11804_11854 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11803_11852__$1,cljs.core.cst$kw$then);
var map__11804_11855__$1 = cljs.core.__destructure_map(map__11804_11854);
var then_11856 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11804_11855__$1,cljs.core.cst$kw$then);
var seq__11805_11857 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$test,ts_11853));
var chunk__11806_11858 = null;
var count__11807_11859 = (0);
var i__11808_11860 = (0);
while(true){
if((i__11808_11860 < count__11807_11859)){
var test_11861 = chunk__11806_11858.cljs$core$IIndexed$_nth$arity$2(null,i__11808_11860);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11861,":");


var G__11862 = seq__11805_11857;
var G__11863 = chunk__11806_11858;
var G__11864 = count__11807_11859;
var G__11865 = (i__11808_11860 + (1));
seq__11805_11857 = G__11862;
chunk__11806_11858 = G__11863;
count__11807_11859 = G__11864;
i__11808_11860 = G__11865;
continue;
} else {
var temp__5753__auto___11866__$1 = cljs.core.seq(seq__11805_11857);
if(temp__5753__auto___11866__$1){
var seq__11805_11867__$1 = temp__5753__auto___11866__$1;
if(cljs.core.chunked_seq_QMARK_(seq__11805_11867__$1)){
var c__4638__auto___11868 = cljs.core.chunk_first(seq__11805_11867__$1);
var G__11869 = cljs.core.chunk_rest(seq__11805_11867__$1);
var G__11870 = c__4638__auto___11868;
var G__11871 = cljs.core.count(c__4638__auto___11868);
var G__11872 = (0);
seq__11805_11857 = G__11869;
chunk__11806_11858 = G__11870;
count__11807_11859 = G__11871;
i__11808_11860 = G__11872;
continue;
} else {
var test_11873 = cljs.core.first(seq__11805_11867__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",test_11873,":");


var G__11874 = cljs.core.next(seq__11805_11867__$1);
var G__11875 = null;
var G__11876 = (0);
var G__11877 = (0);
seq__11805_11857 = G__11874;
chunk__11806_11858 = G__11875;
count__11807_11859 = G__11876;
i__11808_11860 = G__11877;
continue;
}
} else {
}
}
break;
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",then_11856);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(then_11856);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");


var G__11878 = cljs.core.next(seq__11781_11845__$1);
var G__11879 = null;
var G__11880 = (0);
var G__11881 = (0);
seq__11781_11809 = G__11878;
chunk__11782_11810 = G__11879;
count__11783_11811 = G__11880;
i__11784_11812 = G__11881;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(default$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(gs,"=",default$);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(default$);
}
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",gs,";})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$throw,(function (p__11882){
var map__11883 = p__11882;
var map__11883__$1 = cljs.core.__destructure_map(map__11883);
var throw$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11883__$1,cljs.core.cst$kw$exception);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11883__$1,cljs.core.cst$kw$env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function(){throw ",throw$,"})()");
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw ",throw$,";");
}
}));
cljs.compiler.base_types = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 15, ["boolean",null,"object",null,"*",null,"string",null,"Object",null,"Number",null,"null",null,"Date",null,"number",null,"String",null,"RegExp",null,"...*",null,"Array",null,"array",null,"Boolean",null], null), null);
cljs.compiler.mapped_types = new cljs.core.PersistentArrayMap(null, 1, ["nil","null"], null);
cljs.compiler.resolve_type = (function cljs$compiler$resolve_type(env,t){
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.base_types,t))){
return t;
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t))){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.compiler.mapped_types,t);
} else {
if(goog.string.startsWith(t,"!")){
return ["!",cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11887 = env;
var G__11888 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(t,(1));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11887,G__11888) : cljs.compiler.resolve_type.call(null,G__11887,G__11888));
})())].join('');
} else {
if(goog.string.startsWith(t,"{")){
return t;
} else {
if(goog.string.startsWith(t,"function")){
var idx = t.lastIndexOf(":");
var vec__11889 = (((!(((-1) === idx))))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),idx),cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(idx + (1)),cljs.core.count(t))], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [t,null], null));
var fstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11889,(0),null);
var rstr = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11889,(1),null);
var ret_t = (cljs.core.truth_(rstr)?(cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,rstr) : cljs.compiler.resolve_type.call(null,env,rstr)):null);
var axstr = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(fstr,(9),(cljs.core.count(fstr) - (1)));
var args_ts = ((clojure.string.blank_QMARK_(axstr))?null:cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.comp.cljs$core$IFn$_invoke$arity$2((function (p1__11884_SHARP_){
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(env,p1__11884_SHARP_) : cljs.compiler.resolve_type.call(null,env,p1__11884_SHARP_));
}),clojure.string.trim),clojure.string.split.cljs$core$IFn$_invoke$arity$2(axstr,/,/)));
var G__11892 = ["function(",clojure.string.join.cljs$core$IFn$_invoke$arity$2(",",args_ts),")"].join('');
if(cljs.core.truth_(ret_t)){
return [G__11892,":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ret_t)].join('');
} else {
return G__11892;
}
} else {
if(goog.string.endsWith(t,"=")){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((function (){var G__11895 = env;
var G__11896 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(t,(0),(cljs.core.count(t) - (1)));
return (cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2 ? cljs.compiler.resolve_type.cljs$core$IFn$_invoke$arity$2(G__11895,G__11896) : cljs.compiler.resolve_type.call(null,G__11895,G__11896));
})()),"="].join('');
} else {
return cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_var.cljs$core$IFn$_invoke$arity$2(env,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(t)))));

}
}
}
}
}
}
});
cljs.compiler.resolve_types = (function cljs$compiler$resolve_types(env,ts){
var ts__$1 = cljs.core.subs.cljs$core$IFn$_invoke$arity$3(clojure.string.trim(ts),(1),(cljs.core.count(ts) - (1)));
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(ts__$1,/\|/);
return ["{",clojure.string.join.cljs$core$IFn$_invoke$arity$2("|",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11897_SHARP_){
return cljs.compiler.resolve_type(env,p1__11897_SHARP_);
}),xs)),"}"].join('');
});
cljs.compiler.munge_param_return = (function cljs$compiler$munge_param_return(env,line){
if(cljs.core.truth_(cljs.core.re_find(/@param/,line))){
var vec__11898 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11899 = cljs.core.seq(vec__11898);
var first__11900 = cljs.core.first(seq__11899);
var seq__11899__$1 = cljs.core.next(seq__11899);
var p = first__11900;
var first__11900__$1 = cljs.core.first(seq__11899__$1);
var seq__11899__$2 = cljs.core.next(seq__11899__$1);
var ts = first__11900__$1;
var first__11900__$2 = cljs.core.first(seq__11899__$2);
var seq__11899__$3 = cljs.core.next(seq__11899__$2);
var n = first__11900__$2;
var xs = seq__11899__$3;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@param",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts),cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(n)], null),xs));
} else {
return line;
}
} else {
if(cljs.core.truth_(cljs.core.re_find(/@return/,line))){
var vec__11901 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(clojure.string.trim,clojure.string.split.cljs$core$IFn$_invoke$arity$2(clojure.string.trim(line),/ /));
var seq__11902 = cljs.core.seq(vec__11901);
var first__11903 = cljs.core.first(seq__11902);
var seq__11902__$1 = cljs.core.next(seq__11902);
var p = first__11903;
var first__11903__$1 = cljs.core.first(seq__11902__$1);
var seq__11902__$2 = cljs.core.next(seq__11902__$1);
var ts = first__11903__$1;
var xs = seq__11902__$2;
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("@return",p);
if(and__4210__auto__){
var and__4210__auto____$1 = ts;
if(cljs.core.truth_(and__4210__auto____$1)){
return goog.string.startsWith(ts,"{");
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,cljs.compiler.resolve_types(env,ts)], null),xs));
} else {
return line;
}
} else {
return line;

}
}
});
cljs.compiler.checking_types_QMARK_ = (function cljs$compiler$checking_types_QMARK_(){
var G__11905 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$options,cljs.core.cst$kw$closure_DASH_warnings,cljs.core.cst$kw$check_DASH_types], null));
var fexpr__11904 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$warning,null,cljs.core.cst$kw$error,null], null), null);
return (fexpr__11904.cljs$core$IFn$_invoke$arity$1 ? fexpr__11904.cljs$core$IFn$_invoke$arity$1(G__11905) : fexpr__11904.call(null,G__11905));
});
/**
 * Emit a nicely formatted comment string.
 */
cljs.compiler.emit_comment = (function cljs$compiler$emit_comment(var_args){
var G__11908 = arguments.length;
switch (G__11908) {
case 2:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$2 = (function (doc,jsdoc){
return cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(null,doc,jsdoc);
}));

(cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3 = (function (env,doc,jsdoc){
var docs = (cljs.core.truth_(doc)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null):null);
var docs__$1 = (cljs.core.truth_(jsdoc)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(docs,jsdoc):docs);
var docs__$2 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,docs__$1);
var print_comment_lines = (function cljs$compiler$print_comment_lines(e){
var vec__11916 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__11906_SHARP_){
if(cljs.core.truth_(cljs.compiler.checking_types_QMARK_())){
return cljs.compiler.munge_param_return(env,p1__11906_SHARP_);
} else {
return p1__11906_SHARP_;
}
}),clojure.string.split_lines(e));
var seq__11917 = cljs.core.seq(vec__11916);
var first__11918 = cljs.core.first(seq__11917);
var seq__11917__$1 = cljs.core.next(seq__11917);
var x = first__11918;
var ys = seq__11917__$1;
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(x,"*/","* /"));

var seq__11919 = cljs.core.seq(ys);
var chunk__11920 = null;
var count__11921 = (0);
var i__11922 = (0);
while(true){
if((i__11922 < count__11921)){
var next_line = chunk__11920.cljs$core$IIndexed$_nth$arity$2(null,i__11922);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11928 = seq__11919;
var G__11929 = chunk__11920;
var G__11930 = count__11921;
var G__11931 = (i__11922 + (1));
seq__11919 = G__11928;
chunk__11920 = G__11929;
count__11921 = G__11930;
i__11922 = G__11931;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__11919);
if(temp__5753__auto__){
var seq__11919__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__11919__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__11919__$1);
var G__11932 = cljs.core.chunk_rest(seq__11919__$1);
var G__11933 = c__4638__auto__;
var G__11934 = cljs.core.count(c__4638__auto__);
var G__11935 = (0);
seq__11919 = G__11932;
chunk__11920 = G__11933;
count__11921 = G__11934;
i__11922 = G__11935;
continue;
} else {
var next_line = cljs.core.first(seq__11919__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(" * ",clojure.string.replace(clojure.string.replace(next_line,/^   /,""),"*/","* /"));


var G__11936 = cljs.core.next(seq__11919__$1);
var G__11937 = null;
var G__11938 = (0);
var G__11939 = (0);
seq__11919 = G__11936;
chunk__11920 = G__11937;
count__11921 = G__11938;
i__11922 = G__11939;
continue;
}
} else {
return null;
}
}
break;
}
});
if(cljs.core.seq(docs__$2)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

var seq__11923_11940 = cljs.core.seq(docs__$2);
var chunk__11924_11941 = null;
var count__11925_11942 = (0);
var i__11926_11943 = (0);
while(true){
if((i__11926_11943 < count__11925_11942)){
var e_11944 = chunk__11924_11941.cljs$core$IIndexed$_nth$arity$2(null,i__11926_11943);
if(cljs.core.truth_(e_11944)){
print_comment_lines(e_11944);
} else {
}


var G__11945 = seq__11923_11940;
var G__11946 = chunk__11924_11941;
var G__11947 = count__11925_11942;
var G__11948 = (i__11926_11943 + (1));
seq__11923_11940 = G__11945;
chunk__11924_11941 = G__11946;
count__11925_11942 = G__11947;
i__11926_11943 = G__11948;
continue;
} else {
var temp__5753__auto___11949 = cljs.core.seq(seq__11923_11940);
if(temp__5753__auto___11949){
var seq__11923_11950__$1 = temp__5753__auto___11949;
if(cljs.core.chunked_seq_QMARK_(seq__11923_11950__$1)){
var c__4638__auto___11951 = cljs.core.chunk_first(seq__11923_11950__$1);
var G__11952 = cljs.core.chunk_rest(seq__11923_11950__$1);
var G__11953 = c__4638__auto___11951;
var G__11954 = cljs.core.count(c__4638__auto___11951);
var G__11955 = (0);
seq__11923_11940 = G__11952;
chunk__11924_11941 = G__11953;
count__11925_11942 = G__11954;
i__11926_11943 = G__11955;
continue;
} else {
var e_11956 = cljs.core.first(seq__11923_11950__$1);
if(cljs.core.truth_(e_11956)){
print_comment_lines(e_11956);
} else {
}


var G__11957 = cljs.core.next(seq__11923_11950__$1);
var G__11958 = null;
var G__11959 = (0);
var G__11960 = (0);
seq__11923_11940 = G__11957;
chunk__11924_11941 = G__11958;
count__11925_11942 = G__11959;
i__11926_11943 = G__11960;
continue;
}
} else {
}
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" */");
} else {
return null;
}
}));

(cljs.compiler.emit_comment.cljs$lang$maxFixedArity = 3);

cljs.compiler.valid_define_value_QMARK_ = (function cljs$compiler$valid_define_value_QMARK_(x){
return ((typeof x === 'string') || (((x === true) || (((x === false) || (typeof x === 'number'))))));
});
cljs.compiler.get_define = (function cljs$compiler$get_define(mname,jsdoc){
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cljs.env._STAR_compiler_STAR_),cljs.core.cst$kw$options);
var and__4210__auto__ = cljs.core.some((function (p1__11962_SHARP_){
return goog.string.startsWith(p1__11962_SHARP_,"@define");
}),jsdoc);
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = opts;
if(cljs.core.truth_(and__4210__auto____$1)){
var and__4210__auto____$2 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$optimizations.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.cst$kw$none);
if(and__4210__auto____$2){
var define = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$closure_DASH_defines,cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname)], null));
if(cljs.compiler.valid_define_value_QMARK_(define)){
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([define], 0));
} else {
return null;
}
} else {
return and__4210__auto____$2;
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$def,(function (p__11963){
var map__11964 = p__11963;
var map__11964__$1 = cljs.core.__destructure_map(map__11964);
var doc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$doc);
var jsdoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$jsdoc);
var test = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$test);
var goog_define = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$goog_DASH_define);
var init = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$init);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$env);
var export$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$export);
var var$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$var);
var var_ast = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11964__$1,cljs.core.cst$kw$var_DASH_ast);
if(cljs.core.truth_((function (){var or__4212__auto__ = init;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env);
}
})())){
var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name);
cljs.compiler.emit_comment.cljs$core$IFn$_invoke$arity$3(env,doc,cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((cljs.core.truth_(goog_define)?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [["@define {",cljs.core.str.cljs$core$IFn$_invoke$arity$1(goog_define),"}"].join('')], null):null),jsdoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$jsdoc.cljs$core$IFn$_invoke$arity$1(init)], 0)));

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("return (");
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(var$);

if(cljs.core.truth_(init)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(" = ",(function (){var temp__5751__auto__ = cljs.compiler.get_define(mname,jsdoc);
if(cljs.core.truth_(temp__5751__auto__)){
var define = temp__5751__auto__;
return define;
} else {
return init;
}
})());
} else {
}

if(cljs.core.truth_(cljs.core.cst$kw$def_DASH_emits_DASH_var.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("; return (");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$the_DASH_var,cljs.core.cst$kw$env,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(env,cljs.core.cst$kw$context,cljs.core.cst$kw$expr)], null),var_ast], 0)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");})()");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(")");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}

if(cljs.core.truth_(export$)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("goog.exportSymbol('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(export$),"', ",mname,");");
} else {
}

if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_load_tests_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
return test;
} else {
return and__4210__auto__;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
} else {
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(var$,".cljs$lang$test = ",test,";");
} else {
return null;
}
} else {
return null;
}
}));
cljs.compiler.emit_apply_to = (function cljs$compiler$emit_apply_to(p__11965){
var map__11966 = p__11965;
var map__11966__$1 = cljs.core.__destructure_map(map__11966);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11966__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11966__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__11966__$1,cljs.core.cst$kw$env);
var arglist = cljs.core.gensym.cljs$core$IFn$_invoke$arity$1("arglist__");
var delegate_name = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name)),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("(function (",arglist,"){");

var seq__11967_11991 = cljs.core.seq(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,cljs.core.drop_last.cljs$core$IFn$_invoke$arity$2((2),params)));
var chunk__11968_11992 = null;
var count__11969_11993 = (0);
var i__11970_11994 = (0);
while(true){
if((i__11970_11994 < count__11969_11993)){
var vec__11977_11995 = chunk__11968_11992.cljs$core$IIndexed$_nth$arity$2(null,i__11970_11994);
var i_11996 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11977_11995,(0),null);
var param_11997 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11977_11995,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_11997);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__11998 = seq__11967_11991;
var G__11999 = chunk__11968_11992;
var G__12000 = count__11969_11993;
var G__12001 = (i__11970_11994 + (1));
seq__11967_11991 = G__11998;
chunk__11968_11992 = G__11999;
count__11969_11993 = G__12000;
i__11970_11994 = G__12001;
continue;
} else {
var temp__5753__auto___12002 = cljs.core.seq(seq__11967_11991);
if(temp__5753__auto___12002){
var seq__11967_12003__$1 = temp__5753__auto___12002;
if(cljs.core.chunked_seq_QMARK_(seq__11967_12003__$1)){
var c__4638__auto___12004 = cljs.core.chunk_first(seq__11967_12003__$1);
var G__12005 = cljs.core.chunk_rest(seq__11967_12003__$1);
var G__12006 = c__4638__auto___12004;
var G__12007 = cljs.core.count(c__4638__auto___12004);
var G__12008 = (0);
seq__11967_11991 = G__12005;
chunk__11968_11992 = G__12006;
count__11969_11993 = G__12007;
i__11970_11994 = G__12008;
continue;
} else {
var vec__11980_12009 = cljs.core.first(seq__11967_12003__$1);
var i_12010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12009,(0),null);
var param_12011 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__11980_12009,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(param_12011);

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(" = cljs.core.first(");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(arglist,");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(arglist," = cljs.core.next(",arglist,");");


var G__12012 = cljs.core.next(seq__11967_12003__$1);
var G__12013 = null;
var G__12014 = (0);
var G__12015 = (0);
seq__11967_11991 = G__12012;
chunk__11968_11992 = G__12013;
count__11969_11993 = G__12014;
i__11970_11994 = G__12015;
continue;
}
} else {
}
}
break;
}

if(((1) < cljs.core.count(params))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(cljs.core.butlast(params)));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.first(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.rest(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11983_12016 = cljs.core.seq(params);
var chunk__11984_12017 = null;
var count__11985_12018 = (0);
var i__11986_12019 = (0);
while(true){
if((i__11986_12019 < count__11985_12018)){
var param_12020 = chunk__11984_12017.cljs$core$IIndexed$_nth$arity$2(null,i__11986_12019);
cljs.compiler.emit(param_12020);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12020,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12021 = seq__11983_12016;
var G__12022 = chunk__11984_12017;
var G__12023 = count__11985_12018;
var G__12024 = (i__11986_12019 + (1));
seq__11983_12016 = G__12021;
chunk__11984_12017 = G__12022;
count__11985_12018 = G__12023;
i__11986_12019 = G__12024;
continue;
} else {
var temp__5753__auto___12025 = cljs.core.seq(seq__11983_12016);
if(temp__5753__auto___12025){
var seq__11983_12026__$1 = temp__5753__auto___12025;
if(cljs.core.chunked_seq_QMARK_(seq__11983_12026__$1)){
var c__4638__auto___12027 = cljs.core.chunk_first(seq__11983_12026__$1);
var G__12028 = cljs.core.chunk_rest(seq__11983_12026__$1);
var G__12029 = c__4638__auto___12027;
var G__12030 = cljs.core.count(c__4638__auto___12027);
var G__12031 = (0);
seq__11983_12016 = G__12028;
chunk__11984_12017 = G__12029;
count__11985_12018 = G__12030;
i__11986_12019 = G__12031;
continue;
} else {
var param_12032 = cljs.core.first(seq__11983_12026__$1);
cljs.compiler.emit(param_12032);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12032,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12033 = cljs.core.next(seq__11983_12026__$1);
var G__12034 = null;
var G__12035 = (0);
var G__12036 = (0);
seq__11983_12016 = G__12033;
chunk__11984_12017 = G__12034;
count__11985_12018 = G__12035;
i__11986_12019 = G__12036;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = cljs.core.seq(",arglist,");");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name,"(");

var seq__11987_12037 = cljs.core.seq(params);
var chunk__11988_12038 = null;
var count__11989_12039 = (0);
var i__11990_12040 = (0);
while(true){
if((i__11990_12040 < count__11989_12039)){
var param_12041 = chunk__11988_12038.cljs$core$IIndexed$_nth$arity$2(null,i__11990_12040);
cljs.compiler.emit(param_12041);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12041,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12042 = seq__11987_12037;
var G__12043 = chunk__11988_12038;
var G__12044 = count__11989_12039;
var G__12045 = (i__11990_12040 + (1));
seq__11987_12037 = G__12042;
chunk__11988_12038 = G__12043;
count__11989_12039 = G__12044;
i__11990_12040 = G__12045;
continue;
} else {
var temp__5753__auto___12046 = cljs.core.seq(seq__11987_12037);
if(temp__5753__auto___12046){
var seq__11987_12047__$1 = temp__5753__auto___12046;
if(cljs.core.chunked_seq_QMARK_(seq__11987_12047__$1)){
var c__4638__auto___12048 = cljs.core.chunk_first(seq__11987_12047__$1);
var G__12049 = cljs.core.chunk_rest(seq__11987_12047__$1);
var G__12050 = c__4638__auto___12048;
var G__12051 = cljs.core.count(c__4638__auto___12048);
var G__12052 = (0);
seq__11987_12037 = G__12049;
chunk__11988_12038 = G__12050;
count__11989_12039 = G__12051;
i__11990_12040 = G__12052;
continue;
} else {
var param_12053 = cljs.core.first(seq__11987_12047__$1);
cljs.compiler.emit(param_12053);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12053,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12054 = cljs.core.next(seq__11987_12047__$1);
var G__12055 = null;
var G__12056 = (0);
var G__12057 = (0);
seq__11987_12037 = G__12054;
chunk__11988_12038 = G__12055;
count__11989_12039 = G__12056;
i__11990_12040 = G__12057;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(");");
}

return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");
});
cljs.compiler.emit_fn_params = (function cljs$compiler$emit_fn_params(params){
var seq__12058 = cljs.core.seq(params);
var chunk__12059 = null;
var count__12060 = (0);
var i__12061 = (0);
while(true){
if((i__12061 < count__12060)){
var param = chunk__12059.cljs$core$IIndexed$_nth$arity$2(null,i__12061);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12062 = seq__12058;
var G__12063 = chunk__12059;
var G__12064 = count__12060;
var G__12065 = (i__12061 + (1));
seq__12058 = G__12062;
chunk__12059 = G__12063;
count__12060 = G__12064;
i__12061 = G__12065;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12058);
if(temp__5753__auto__){
var seq__12058__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12058__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__12058__$1);
var G__12066 = cljs.core.chunk_rest(seq__12058__$1);
var G__12067 = c__4638__auto__;
var G__12068 = cljs.core.count(c__4638__auto__);
var G__12069 = (0);
seq__12058 = G__12066;
chunk__12059 = G__12067;
count__12060 = G__12068;
i__12061 = G__12069;
continue;
} else {
var param = cljs.core.first(seq__12058__$1);
cljs.compiler.emit(param);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12070 = cljs.core.next(seq__12058__$1);
var G__12071 = null;
var G__12072 = (0);
var G__12073 = (0);
seq__12058 = G__12070;
chunk__12059 = G__12071;
count__12060 = G__12072;
i__12061 = G__12073;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_fn_method = (function cljs$compiler$emit_fn_method(p__12074){
var map__12075 = p__12074;
var map__12075__$1 = cljs.core.__destructure_map(map__12075);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$body);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12075__$1,cljs.core.cst$kw$recurs);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(function ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"(");

cljs.compiler.emit_fn_params(params);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
/**
 * Emit code that copies function arguments into an array starting at an index.
 *   Returns name of var holding the array.
 */
cljs.compiler.emit_arguments_to_array = (function cljs$compiler$emit_arguments_to_array(startslice){
if((((startslice >= (0))) && (cljs.core.integer_QMARK_(startslice)))){
} else {
throw (new Error("Assert failed: (and (>= startslice 0) (integer? startslice))"));
}

var mname = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
var i = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__i"].join('');
var a = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname),"__a"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("var ",i," = 0, ",a," = new Array(arguments.length -  ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([startslice,");"], 0));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("while (",i," < ",a,".length) {",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([a,"[",i,"] = arguments[",i," + ",startslice,"]; ++",i,";}"], 0));

return a;
});
cljs.compiler.emit_variadic_fn_method = (function cljs$compiler$emit_variadic_fn_method(p__12076){
var map__12077 = p__12076;
var map__12077__$1 = cljs.core.__destructure_map(map__12077);
var f = map__12077__$1;
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$body);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$fixed_DASH_arity);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$variadic_QMARK_);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$type);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$name);
var params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$params);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$env);
var recurs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12077__$1,cljs.core.cst$kw$recurs);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

var name_12086__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_12087 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_12086__$1);
var delegate_name_12088 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12087),"__delegate"].join('');
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() { ");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",delegate_name_12088," = function (");

var seq__12078_12089 = cljs.core.seq(params);
var chunk__12079_12090 = null;
var count__12080_12091 = (0);
var i__12081_12092 = (0);
while(true){
if((i__12081_12092 < count__12080_12091)){
var param_12093 = chunk__12079_12090.cljs$core$IIndexed$_nth$arity$2(null,i__12081_12092);
cljs.compiler.emit(param_12093);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12093,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12094 = seq__12078_12089;
var G__12095 = chunk__12079_12090;
var G__12096 = count__12080_12091;
var G__12097 = (i__12081_12092 + (1));
seq__12078_12089 = G__12094;
chunk__12079_12090 = G__12095;
count__12080_12091 = G__12096;
i__12081_12092 = G__12097;
continue;
} else {
var temp__5753__auto___12098 = cljs.core.seq(seq__12078_12089);
if(temp__5753__auto___12098){
var seq__12078_12099__$1 = temp__5753__auto___12098;
if(cljs.core.chunked_seq_QMARK_(seq__12078_12099__$1)){
var c__4638__auto___12100 = cljs.core.chunk_first(seq__12078_12099__$1);
var G__12101 = cljs.core.chunk_rest(seq__12078_12099__$1);
var G__12102 = c__4638__auto___12100;
var G__12103 = cljs.core.count(c__4638__auto___12100);
var G__12104 = (0);
seq__12078_12089 = G__12101;
chunk__12079_12090 = G__12102;
count__12080_12091 = G__12103;
i__12081_12092 = G__12104;
continue;
} else {
var param_12105 = cljs.core.first(seq__12078_12099__$1);
cljs.compiler.emit(param_12105);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12105,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12106 = cljs.core.next(seq__12078_12099__$1);
var G__12107 = null;
var G__12108 = (0);
var G__12109 = (0);
seq__12078_12089 = G__12106;
chunk__12079_12090 = G__12107;
count__12080_12091 = G__12108;
i__12081_12092 = G__12109;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(recurs)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",mname_12087," = function (",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(params),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):params)),"){");

if(cljs.core.truth_(type)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("var self__ = this;");
} else {
}

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(params));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",(cljs.core.count(params) - (1)),") {");

var a_12110 = cljs.compiler.emit_arguments_to_array((cljs.core.count(params) - (1)));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("  ",cljs.core.last(params)," = new cljs.core.IndexedSeq(",a_12110,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("} ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("return ",delegate_name_12088,".call(this,");

var seq__12082_12111 = cljs.core.seq(params);
var chunk__12083_12112 = null;
var count__12084_12113 = (0);
var i__12085_12114 = (0);
while(true){
if((i__12085_12114 < count__12084_12113)){
var param_12115 = chunk__12083_12112.cljs$core$IIndexed$_nth$arity$2(null,i__12085_12114);
cljs.compiler.emit(param_12115);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12115,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12116 = seq__12082_12111;
var G__12117 = chunk__12083_12112;
var G__12118 = count__12084_12113;
var G__12119 = (i__12085_12114 + (1));
seq__12082_12111 = G__12116;
chunk__12083_12112 = G__12117;
count__12084_12113 = G__12118;
i__12085_12114 = G__12119;
continue;
} else {
var temp__5753__auto___12120 = cljs.core.seq(seq__12082_12111);
if(temp__5753__auto___12120){
var seq__12082_12121__$1 = temp__5753__auto___12120;
if(cljs.core.chunked_seq_QMARK_(seq__12082_12121__$1)){
var c__4638__auto___12122 = cljs.core.chunk_first(seq__12082_12121__$1);
var G__12123 = cljs.core.chunk_rest(seq__12082_12121__$1);
var G__12124 = c__4638__auto___12122;
var G__12125 = cljs.core.count(c__4638__auto___12122);
var G__12126 = (0);
seq__12082_12111 = G__12123;
chunk__12083_12112 = G__12124;
count__12084_12113 = G__12125;
i__12085_12114 = G__12126;
continue;
} else {
var param_12127 = cljs.core.first(seq__12082_12121__$1);
cljs.compiler.emit(param_12127);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(param_12127,cljs.core.last(params))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(",");
}


var G__12128 = cljs.core.next(seq__12082_12121__$1);
var G__12129 = null;
var G__12130 = (0);
var G__12131 = (0);
seq__12082_12111 = G__12128;
chunk__12083_12112 = G__12129;
count__12084_12113 = G__12130;
i__12085_12114 = G__12131;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(");");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12087,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$2(mname_12087,".cljs$lang$applyTo = ");

cljs.compiler.emit_apply_to(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(f,cljs.core.cst$kw$name,name_12086__$1));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12087,".cljs$core$IFn$_invoke$arity$variadic = ",delegate_name_12088,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_12087,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$fn,(function (p__12135){
var map__12136 = p__12135;
var map__12136__$1 = cljs.core.__destructure_map(map__12136);
var variadic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$variadic_QMARK_);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$name);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$env);
var methods$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$methods);
var max_fixed_arity = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$max_DASH_fixed_DASH_arity);
var recur_frames = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$recur_DASH_frames);
var in_loop = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$in_DASH_loop);
var loop_lets = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12136__$1,cljs.core.cst$kw$loop_DASH_lets);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
return null;
} else {
var recur_params = cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__12132_SHARP_){
var and__4210__auto__ = p1__12132_SHARP_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.deref(cljs.core.cst$kw$flag.cljs$core$IFn$_invoke$arity$1(p1__12132_SHARP_));
} else {
return and__4210__auto__;
}
}),recur_frames)], 0));
var loop_locals = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(recur_params,(cljs.core.truth_((function (){var or__4212__auto__ = in_loop;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.seq(recur_params);
}
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$params,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loop_lets], 0)):null))));
if(loop_locals){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("((function (",cljs.compiler.comma_sep(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,loop_locals)),"){");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
}
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(methods$))){
if(cljs.core.truth_(variadic)){
cljs.compiler.emit_variadic_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
} else {
cljs.compiler.emit_fn_method(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.first(methods$),cljs.core.cst$kw$name,name));
}
} else {
var name_12188__$1 = (function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.gensym.cljs$core$IFn$_invoke$arity$0();
}
})();
var mname_12189 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name_12188__$1);
var maxparams_12190 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.max_key,cljs.core.count,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$params,methods$));
var mmap_12191 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (method){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(mname_12189),"__",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(method)))].join(''))),method], null);
}),methods$));
var ms_12192 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2((function (p1__12133_SHARP_){
return cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.second(p1__12133_SHARP_)));
}),cljs.core.seq(mmap_12191));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function() {");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",mname_12189," = null;");

var seq__12137_12193 = cljs.core.seq(ms_12192);
var chunk__12138_12194 = null;
var count__12139_12195 = (0);
var i__12140_12196 = (0);
while(true){
if((i__12140_12196 < count__12139_12195)){
var vec__12147_12197 = chunk__12138_12194.cljs$core$IIndexed$_nth$arity$2(null,i__12140_12196);
var n_12198 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12147_12197,(0),null);
var meth_12199 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12147_12197,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_12198," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12199))){
cljs.compiler.emit_variadic_fn_method(meth_12199);
} else {
cljs.compiler.emit_fn_method(meth_12199);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__12200 = seq__12137_12193;
var G__12201 = chunk__12138_12194;
var G__12202 = count__12139_12195;
var G__12203 = (i__12140_12196 + (1));
seq__12137_12193 = G__12200;
chunk__12138_12194 = G__12201;
count__12139_12195 = G__12202;
i__12140_12196 = G__12203;
continue;
} else {
var temp__5753__auto___12204 = cljs.core.seq(seq__12137_12193);
if(temp__5753__auto___12204){
var seq__12137_12205__$1 = temp__5753__auto___12204;
if(cljs.core.chunked_seq_QMARK_(seq__12137_12205__$1)){
var c__4638__auto___12206 = cljs.core.chunk_first(seq__12137_12205__$1);
var G__12207 = cljs.core.chunk_rest(seq__12137_12205__$1);
var G__12208 = c__4638__auto___12206;
var G__12209 = cljs.core.count(c__4638__auto___12206);
var G__12210 = (0);
seq__12137_12193 = G__12207;
chunk__12138_12194 = G__12208;
count__12139_12195 = G__12209;
i__12140_12196 = G__12210;
continue;
} else {
var vec__12150_12211 = cljs.core.first(seq__12137_12205__$1);
var n_12212 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12150_12211,(0),null);
var meth_12213 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12150_12211,(1),null);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("var ",n_12212," = ");

if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12213))){
cljs.compiler.emit_variadic_fn_method(meth_12213);
} else {
cljs.compiler.emit_fn_method(meth_12213);
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");


var G__12214 = cljs.core.next(seq__12137_12205__$1);
var G__12215 = null;
var G__12216 = (0);
var G__12217 = (0);
seq__12137_12193 = G__12214;
chunk__12138_12194 = G__12215;
count__12139_12195 = G__12216;
i__12140_12196 = G__12217;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12189," = function(",cljs.compiler.comma_sep((cljs.core.truth_(variadic)?cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(maxparams_12190),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$var_args], null)):maxparams_12190)),"){");

if(cljs.core.truth_(variadic)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(cljs.core.last(maxparams_12190));

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(" = var_args;");
} else {
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("switch(arguments.length){");

var seq__12153_12218 = cljs.core.seq(ms_12192);
var chunk__12154_12219 = null;
var count__12155_12220 = (0);
var i__12156_12221 = (0);
while(true){
if((i__12156_12221 < count__12155_12220)){
var vec__12163_12222 = chunk__12154_12219.cljs$core$IIndexed$_nth$arity$2(null,i__12156_12221);
var n_12223 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163_12222,(0),null);
var meth_12224 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12163_12222,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12224))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_12225 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_12225," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_12226 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_12225," = new cljs.core.IndexedSeq(",a_12226,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_12223,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_12190)),(((cljs.core.count(maxparams_12190) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_12225,");"], 0));
} else {
var pcnt_12227 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12224));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_12227,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_12223,".call(this",(((pcnt_12227 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_12227,maxparams_12190)),null,(1),null)),(2),null))),");");
}


var G__12228 = seq__12153_12218;
var G__12229 = chunk__12154_12219;
var G__12230 = count__12155_12220;
var G__12231 = (i__12156_12221 + (1));
seq__12153_12218 = G__12228;
chunk__12154_12219 = G__12229;
count__12155_12220 = G__12230;
i__12156_12221 = G__12231;
continue;
} else {
var temp__5753__auto___12232 = cljs.core.seq(seq__12153_12218);
if(temp__5753__auto___12232){
var seq__12153_12233__$1 = temp__5753__auto___12232;
if(cljs.core.chunked_seq_QMARK_(seq__12153_12233__$1)){
var c__4638__auto___12234 = cljs.core.chunk_first(seq__12153_12233__$1);
var G__12235 = cljs.core.chunk_rest(seq__12153_12233__$1);
var G__12236 = c__4638__auto___12234;
var G__12237 = cljs.core.count(c__4638__auto___12234);
var G__12238 = (0);
seq__12153_12218 = G__12235;
chunk__12154_12219 = G__12236;
count__12155_12220 = G__12237;
i__12156_12221 = G__12238;
continue;
} else {
var vec__12166_12239 = cljs.core.first(seq__12153_12233__$1);
var n_12240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12166_12239,(0),null);
var meth_12241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12166_12239,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12241))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("default:");

var restarg_12242 = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$0());
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",restarg_12242," = null;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if (arguments.length > ",max_fixed_arity,") {");

var a_12243 = cljs.compiler.emit_arguments_to_array(max_fixed_arity);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(restarg_12242," = new cljs.core.IndexedSeq(",a_12243,",0,null);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("return ",n_12240,".cljs$core$IFn$_invoke$arity$variadic(",cljs.compiler.comma_sep(cljs.core.butlast(maxparams_12190)),(((cljs.core.count(maxparams_12190) > (1)))?", ":null),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([restarg_12242,");"], 0));
} else {
var pcnt_12244 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12241));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("case ",pcnt_12244,":");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("return ",n_12240,".call(this",(((pcnt_12244 === (0)))?null:(new cljs.core.List(null,",",(new cljs.core.List(null,cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(pcnt_12244,maxparams_12190)),null,(1),null)),(2),null))),");");
}


var G__12245 = cljs.core.next(seq__12153_12233__$1);
var G__12246 = null;
var G__12247 = (0);
var G__12248 = (0);
seq__12153_12218 = G__12245;
chunk__12154_12219 = G__12246;
count__12155_12220 = G__12247;
i__12156_12221 = G__12248;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");

var arg_count_js_12249 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$self__,cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(cljs.core.val(cljs.core.first(ms_12192)))))))?"(arguments.length - 1)":"arguments.length");
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("throw(new Error('Invalid arity: ' + ",arg_count_js_12249,"));");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("};");

if(cljs.core.truth_(variadic)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12189,".cljs$lang$maxFixedArity = ",max_fixed_arity,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12189,".cljs$lang$applyTo = ",cljs.core.some((function (p1__12134_SHARP_){
var vec__12169 = p1__12134_SHARP_;
var n = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12169,(0),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12169,(1),null);
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(m))){
return n;
} else {
return null;
}
}),ms_12192),".cljs$lang$applyTo;");
} else {
}

var seq__12172_12250 = cljs.core.seq(ms_12192);
var chunk__12173_12251 = null;
var count__12174_12252 = (0);
var i__12175_12253 = (0);
while(true){
if((i__12175_12253 < count__12174_12252)){
var vec__12182_12254 = chunk__12173_12251.cljs$core$IIndexed$_nth$arity$2(null,i__12175_12253);
var n_12255 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12182_12254,(0),null);
var meth_12256 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12182_12254,(1),null);
var c_12257 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12256));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12256))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12189,".cljs$core$IFn$_invoke$arity$variadic = ",n_12255,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_12189,".cljs$core$IFn$_invoke$arity$",c_12257," = ",n_12255,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__12258 = seq__12172_12250;
var G__12259 = chunk__12173_12251;
var G__12260 = count__12174_12252;
var G__12261 = (i__12175_12253 + (1));
seq__12172_12250 = G__12258;
chunk__12173_12251 = G__12259;
count__12174_12252 = G__12260;
i__12175_12253 = G__12261;
continue;
} else {
var temp__5753__auto___12262 = cljs.core.seq(seq__12172_12250);
if(temp__5753__auto___12262){
var seq__12172_12263__$1 = temp__5753__auto___12262;
if(cljs.core.chunked_seq_QMARK_(seq__12172_12263__$1)){
var c__4638__auto___12264 = cljs.core.chunk_first(seq__12172_12263__$1);
var G__12265 = cljs.core.chunk_rest(seq__12172_12263__$1);
var G__12266 = c__4638__auto___12264;
var G__12267 = cljs.core.count(c__4638__auto___12264);
var G__12268 = (0);
seq__12172_12250 = G__12265;
chunk__12173_12251 = G__12266;
count__12174_12252 = G__12267;
i__12175_12253 = G__12268;
continue;
} else {
var vec__12185_12269 = cljs.core.first(seq__12172_12263__$1);
var n_12270 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12185_12269,(0),null);
var meth_12271 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12185_12269,(1),null);
var c_12272 = cljs.core.count(cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(meth_12271));
if(cljs.core.truth_(cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(meth_12271))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(mname_12189,".cljs$core$IFn$_invoke$arity$variadic = ",n_12270,".cljs$core$IFn$_invoke$arity$variadic;");
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(mname_12189,".cljs$core$IFn$_invoke$arity$",c_12272," = ",n_12270,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([";"], 0));
}


var G__12273 = cljs.core.next(seq__12172_12263__$1);
var G__12274 = null;
var G__12275 = (0);
var G__12276 = (0);
seq__12172_12250 = G__12273;
chunk__12173_12251 = G__12274;
count__12174_12252 = G__12275;
i__12175_12253 = G__12276;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("return ",mname_12189,";");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
}

if(loop_locals){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(";})(",cljs.compiler.comma_sep(loop_locals),"))");
} else {
return null;
}
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$do,(function (p__12277){
var map__12278 = p__12277;
var map__12278__$1 = cljs.core.__destructure_map(map__12278);
var statements = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12278__$1,cljs.core.cst$kw$statements);
var ret = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12278__$1,cljs.core.cst$kw$ret);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12278__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12279_12283 = cljs.core.seq(statements);
var chunk__12280_12284 = null;
var count__12281_12285 = (0);
var i__12282_12286 = (0);
while(true){
if((i__12282_12286 < count__12281_12285)){
var s_12287 = chunk__12280_12284.cljs$core$IIndexed$_nth$arity$2(null,i__12282_12286);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12287);


var G__12288 = seq__12279_12283;
var G__12289 = chunk__12280_12284;
var G__12290 = count__12281_12285;
var G__12291 = (i__12282_12286 + (1));
seq__12279_12283 = G__12288;
chunk__12280_12284 = G__12289;
count__12281_12285 = G__12290;
i__12282_12286 = G__12291;
continue;
} else {
var temp__5753__auto___12292 = cljs.core.seq(seq__12279_12283);
if(temp__5753__auto___12292){
var seq__12279_12293__$1 = temp__5753__auto___12292;
if(cljs.core.chunked_seq_QMARK_(seq__12279_12293__$1)){
var c__4638__auto___12294 = cljs.core.chunk_first(seq__12279_12293__$1);
var G__12295 = cljs.core.chunk_rest(seq__12279_12293__$1);
var G__12296 = c__4638__auto___12294;
var G__12297 = cljs.core.count(c__4638__auto___12294);
var G__12298 = (0);
seq__12279_12283 = G__12295;
chunk__12280_12284 = G__12296;
count__12281_12285 = G__12297;
i__12282_12286 = G__12298;
continue;
} else {
var s_12299 = cljs.core.first(seq__12279_12293__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(s_12299);


var G__12300 = cljs.core.next(seq__12279_12293__$1);
var G__12301 = null;
var G__12302 = (0);
var G__12303 = (0);
seq__12279_12283 = G__12300;
chunk__12280_12284 = G__12301;
count__12281_12285 = G__12302;
i__12282_12286 = G__12303;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emit(ret);

if(((cljs.core.seq(statements)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$try,(function (p__12304){
var map__12305 = p__12304;
var map__12305__$1 = cljs.core.__destructure_map(map__12305);
var try$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12305__$1,cljs.core.cst$kw$body);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12305__$1,cljs.core.cst$kw$env);
var catch$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12305__$1,cljs.core.cst$kw$catch);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12305__$1,cljs.core.cst$kw$name);
var finally$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12305__$1,cljs.core.cst$kw$finally);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core.truth_((function (){var or__4212__auto__ = name;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return finally$;
}
})())){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("try{",try$,"}");

if(cljs.core.truth_(name)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("catch (",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"){",catch$,"}");
} else {
}

if(cljs.core.truth_(finally$)){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$const,cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.unwrap_quote(finally$)))){
} else {
throw (new Error(["Assert failed: ","finally block cannot contain constant","\n","(not= :const (:op (ana/unwrap-quote finally)))"].join('')));
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("finally {",finally$,"}");
} else {
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
} else {
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(try$);
}
}));
cljs.compiler.emit_let = (function cljs$compiler$emit_let(p__12306,is_loop){
var map__12307 = p__12306;
var map__12307__$1 = cljs.core.__destructure_map(map__12307);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12307__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12307__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12307__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var _STAR_lexical_renames_STAR__orig_val__12308_12318 = cljs.compiler._STAR_lexical_renames_STAR_;
var _STAR_lexical_renames_STAR__temp_val__12309_12319 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.compiler._STAR_lexical_renames_STAR_,((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$statement,context))?cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (binding){
var name = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(binding);
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.compiler.hash_scope(binding),cljs.core.gensym.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(name),"-"].join(''))],null));
}),bindings):null));
(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__temp_val__12309_12319);

try{var seq__12310_12320 = cljs.core.seq(bindings);
var chunk__12311_12321 = null;
var count__12312_12322 = (0);
var i__12313_12323 = (0);
while(true){
if((i__12313_12323 < count__12312_12322)){
var map__12316_12324 = chunk__12311_12321.cljs$core$IIndexed$_nth$arity$2(null,i__12313_12323);
var map__12316_12325__$1 = cljs.core.__destructure_map(map__12316_12324);
var binding_12326 = map__12316_12325__$1;
var init_12327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12316_12325__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12326);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12327,";");


var G__12328 = seq__12310_12320;
var G__12329 = chunk__12311_12321;
var G__12330 = count__12312_12322;
var G__12331 = (i__12313_12323 + (1));
seq__12310_12320 = G__12328;
chunk__12311_12321 = G__12329;
count__12312_12322 = G__12330;
i__12313_12323 = G__12331;
continue;
} else {
var temp__5753__auto___12332 = cljs.core.seq(seq__12310_12320);
if(temp__5753__auto___12332){
var seq__12310_12333__$1 = temp__5753__auto___12332;
if(cljs.core.chunked_seq_QMARK_(seq__12310_12333__$1)){
var c__4638__auto___12334 = cljs.core.chunk_first(seq__12310_12333__$1);
var G__12335 = cljs.core.chunk_rest(seq__12310_12333__$1);
var G__12336 = c__4638__auto___12334;
var G__12337 = cljs.core.count(c__4638__auto___12334);
var G__12338 = (0);
seq__12310_12320 = G__12335;
chunk__12311_12321 = G__12336;
count__12312_12322 = G__12337;
i__12313_12323 = G__12338;
continue;
} else {
var map__12317_12339 = cljs.core.first(seq__12310_12333__$1);
var map__12317_12340__$1 = cljs.core.__destructure_map(map__12317_12339);
var binding_12341 = map__12317_12340__$1;
var init_12342 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12317_12340__$1,cljs.core.cst$kw$init);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("var ");

cljs.compiler.emit(binding_12341);

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" = ",init_12342,";");


var G__12343 = cljs.core.next(seq__12310_12333__$1);
var G__12344 = null;
var G__12345 = (0);
var G__12346 = (0);
seq__12310_12320 = G__12343;
chunk__12311_12321 = G__12344;
count__12312_12322 = G__12345;
i__12313_12323 = G__12346;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("while(true){");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core.truth_(is_loop)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("break;");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("}");
} else {
}
}finally {(cljs.compiler._STAR_lexical_renames_STAR_ = _STAR_lexical_renames_STAR__orig_val__12308_12318);
}
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$let,(function (ast){
return cljs.compiler.emit_let(ast,false);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$loop,(function (ast){
return cljs.compiler.emit_let(ast,true);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$recur,(function (p__12347){
var map__12348 = p__12347;
var map__12348__$1 = cljs.core.__destructure_map(map__12348);
var frame = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12348__$1,cljs.core.cst$kw$frame);
var exprs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12348__$1,cljs.core.cst$kw$exprs);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12348__$1,cljs.core.cst$kw$env);
var temps = cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(cljs.core.count(exprs),cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym)));
var params = cljs.core.cst$kw$params.cljs$core$IFn$_invoke$arity$1(frame);
var n__4695__auto___12349 = cljs.core.count(exprs);
var i_12350 = (0);
while(true){
if((i_12350 < n__4695__auto___12349)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12350) : temps.call(null,i_12350))," = ",(exprs.cljs$core$IFn$_invoke$arity$1 ? exprs.cljs$core$IFn$_invoke$arity$1(i_12350) : exprs.call(null,i_12350)),";");

var G__12351 = (i_12350 + (1));
i_12350 = G__12351;
continue;
} else {
}
break;
}

var n__4695__auto___12352 = cljs.core.count(exprs);
var i_12353 = (0);
while(true){
if((i_12353 < n__4695__auto___12352)){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1((params.cljs$core$IFn$_invoke$arity$1 ? params.cljs$core$IFn$_invoke$arity$1(i_12353) : params.call(null,i_12353)))," = ",(temps.cljs$core$IFn$_invoke$arity$1 ? temps.cljs$core$IFn$_invoke$arity$1(i_12353) : temps.call(null,i_12353)),";");

var G__12354 = (i_12353 + (1));
i_12353 = G__12354;
continue;
} else {
}
break;
}

return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("continue;");
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$letfn,(function (p__12355){
var map__12356 = p__12355;
var map__12356__$1 = cljs.core.__destructure_map(map__12356);
var expr = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12356__$1,cljs.core.cst$kw$body);
var bindings = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12356__$1,cljs.core.cst$kw$bindings);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12356__$1,cljs.core.cst$kw$env);
var context = cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("(function (){");
} else {
}

var seq__12357_12365 = cljs.core.seq(bindings);
var chunk__12358_12366 = null;
var count__12359_12367 = (0);
var i__12360_12368 = (0);
while(true){
if((i__12360_12368 < count__12359_12367)){
var map__12363_12369 = chunk__12358_12366.cljs$core$IIndexed$_nth$arity$2(null,i__12360_12368);
var map__12363_12370__$1 = cljs.core.__destructure_map(map__12363_12369);
var binding_12371 = map__12363_12370__$1;
var init_12372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12363_12370__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12371)," = ",init_12372,";");


var G__12373 = seq__12357_12365;
var G__12374 = chunk__12358_12366;
var G__12375 = count__12359_12367;
var G__12376 = (i__12360_12368 + (1));
seq__12357_12365 = G__12373;
chunk__12358_12366 = G__12374;
count__12359_12367 = G__12375;
i__12360_12368 = G__12376;
continue;
} else {
var temp__5753__auto___12377 = cljs.core.seq(seq__12357_12365);
if(temp__5753__auto___12377){
var seq__12357_12378__$1 = temp__5753__auto___12377;
if(cljs.core.chunked_seq_QMARK_(seq__12357_12378__$1)){
var c__4638__auto___12379 = cljs.core.chunk_first(seq__12357_12378__$1);
var G__12380 = cljs.core.chunk_rest(seq__12357_12378__$1);
var G__12381 = c__4638__auto___12379;
var G__12382 = cljs.core.count(c__4638__auto___12379);
var G__12383 = (0);
seq__12357_12365 = G__12380;
chunk__12358_12366 = G__12381;
count__12359_12367 = G__12382;
i__12360_12368 = G__12383;
continue;
} else {
var map__12364_12384 = cljs.core.first(seq__12357_12378__$1);
var map__12364_12385__$1 = cljs.core.__destructure_map(map__12364_12384);
var binding_12386 = map__12364_12385__$1;
var init_12387 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12364_12385__$1,cljs.core.cst$kw$init);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("var ",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(binding_12386)," = ",init_12387,";");


var G__12388 = cljs.core.next(seq__12357_12378__$1);
var G__12389 = null;
var G__12390 = (0);
var G__12391 = (0);
seq__12357_12365 = G__12388;
chunk__12358_12366 = G__12389;
count__12359_12367 = G__12390;
i__12360_12368 = G__12391;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(expr);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,context)){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("})()");
} else {
return null;
}
}));
cljs.compiler.protocol_prefix = (function cljs$compiler$protocol_prefix(psym){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(psym).replace((new RegExp("\\.","g")),"$").replace("/","$")),"$"].join(''));
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$invoke,(function (p__12394){
var map__12395 = p__12394;
var map__12395__$1 = cljs.core.__destructure_map(map__12395);
var expr = map__12395__$1;
var f = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12395__$1,cljs.core.cst$kw$fn);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12395__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12395__$1,cljs.core.cst$kw$env);
var info = cljs.core.cst$kw$info.cljs$core$IFn$_invoke$arity$1(f);
var fn_QMARK_ = (function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = cljs.core.not(cljs.core.cst$kw$dynamic.cljs$core$IFn$_invoke$arity$1(info));
if(and__4210__auto____$1){
return cljs.core.cst$kw$fn_DASH_var.cljs$core$IFn$_invoke$arity$1(info);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var protocol = cljs.core.cst$kw$protocol.cljs$core$IFn$_invoke$arity$1(info);
var tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var proto_QMARK_ = (function (){var and__4210__auto__ = protocol;
if(cljs.core.truth_(and__4210__auto__)){
var and__4210__auto____$1 = tag;
if(cljs.core.truth_(and__4210__auto____$1)){
var or__4212__auto__ = (function (){var and__4210__auto____$2 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto____$2)){
var and__4210__auto____$3 = protocol;
if(cljs.core.truth_(and__4210__auto____$3)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(tag,cljs.core.cst$sym$not_DASH_native);
} else {
return and__4210__auto____$3;
}
} else {
return and__4210__auto____$2;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto____$2 = (function (){var or__4212__auto____$1 = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$protocol_DASH_inline.cljs$core$IFn$_invoke$arity$1(env);
}
})();
if(cljs.core.truth_(and__4210__auto____$2)){
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(protocol,tag);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
var and__4210__auto____$3 = (!(cljs.core.set_QMARK_(tag)));
if(and__4210__auto____$3){
var and__4210__auto____$4 = cljs.core.not((function (){var fexpr__12399 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 11, [cljs.core.cst$sym$clj,"null",cljs.core.cst$sym$boolean,"null",cljs.core.cst$sym$object,"null",cljs.core.cst$sym$any,"null",cljs.core.cst$sym$js,"null",cljs.core.cst$sym$number,"null",cljs.core.cst$sym$clj_DASH_or_DASH_nil,"null",cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null",cljs.core.cst$sym$function,"null",cljs.core.cst$sym$clj_DASH_nil,"null"], null), null);
return (fexpr__12399.cljs$core$IFn$_invoke$arity$1 ? fexpr__12399.cljs$core$IFn$_invoke$arity$1(tag) : fexpr__12399.call(null,tag));
})());
if(and__4210__auto____$4){
var temp__5753__auto__ = cljs.core.cst$kw$protocols.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.resolve_existing_var(env,cljs.core.vary_meta.cljs$core$IFn$_invoke$arity$4(tag,cljs.core.assoc,cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true)));
if(cljs.core.truth_(temp__5753__auto__)){
var ps = temp__5753__auto__;
return (ps.cljs$core$IFn$_invoke$arity$1 ? ps.cljs$core$IFn$_invoke$arity$1(protocol) : ps.call(null,protocol));
} else {
return null;
}
} else {
return and__4210__auto____$4;
}
} else {
return and__4210__auto____$3;
}
}
} else {
return and__4210__auto____$2;
}
}
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})();
var first_arg_tag = cljs.analyzer.infer_tag(env,cljs.core.first(cljs.core.cst$kw$args.cljs$core$IFn$_invoke$arity$1(expr)));
var opt_not_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_not)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(first_arg_tag,cljs.core.cst$sym$boolean)));
var opt_count_QMARK_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info),cljs.core.cst$sym$cljs$core_SLASH_count)) && (cljs.core.boolean$((function (){var fexpr__12400 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$sym$array,"null",cljs.core.cst$sym$string,"null"], null), null);
return (fexpr__12400.cljs$core$IFn$_invoke$arity$1 ? fexpr__12400.cljs$core$IFn$_invoke$arity$1(first_arg_tag) : fexpr__12400.call(null,first_arg_tag));
})())));
var ns = cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(info);
var ftag = cljs.analyzer.infer_tag(env,f);
var js_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$js);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$Math);
if(or__4212__auto____$1){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$foreign.cljs$core$IFn$_invoke$arity$1(info);
}
}
})();
var goog_QMARK_ = (cljs.core.truth_(ns)?(function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(ns,cljs.core.cst$sym$goog);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = (function (){var temp__5753__auto__ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns);
if(cljs.core.truth_(temp__5753__auto__)){
var ns_str = temp__5753__auto__;
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(clojure.string.split.cljs$core$IFn$_invoke$arity$2(ns_str,/\./),(0),null),"goog");
} else {
return null;
}
})();
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return (!(cljs.core.contains_QMARK_(cljs.core.cst$kw$cljs$analyzer_SLASH_namespaces.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_)),ns)));
}
}
})():null);
var keyword_QMARK_ = (function (){var or__4212__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$cljs$core_SLASH_Keyword,ftag);
if(or__4212__auto__){
return or__4212__auto__;
} else {
var f__$1 = cljs.analyzer.unwrap_quote(f);
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1),cljs.core.cst$kw$const)) && ((cljs.core.cst$kw$form.cljs$core$IFn$_invoke$arity$1(f__$1) instanceof cljs.core.Keyword)));
}
})();
var vec__12396 = (cljs.core.truth_(fn_QMARK_)?(function (){var arity = cljs.core.count(args);
var variadic_QMARK_ = cljs.core.cst$kw$variadic_QMARK_.cljs$core$IFn$_invoke$arity$1(info);
var mps = cljs.core.cst$kw$method_DASH_params.cljs$core$IFn$_invoke$arity$1(info);
var mfa = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(info);
if(((cljs.core.not(variadic_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(mps),(1))))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = variadic_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (arity > mfa);
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$variadic"].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12392_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12392_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$max_DASH_fixed_DASH_arity,mfa], null)], null);
} else {
var arities = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.count,mps);
if(cljs.core.truth_(cljs.core.some(cljs.core.PersistentHashSet.createAsIfByAssoc([arity]),arities))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(f,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (info__$1){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(info__$1,cljs.core.cst$kw$name,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(info__$1)),".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arity)].join(''))),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$info], null),(function (p1__12393_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__12393_SHARP_,cljs.core.cst$kw$shadow),cljs.core.cst$kw$fn_DASH_self_DASH_name);
}));
})),null], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null);
}

}
}
})():new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f,null], null));
var f__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12396,(0),null);
var variadic_invoke = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12396,(1),null);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(opt_not_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("(!(",cljs.core.first(args),"))");
} else {
if(opt_count_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("((",cljs.core.first(args),").length)");
} else {
if(cljs.core.truth_(proto_QMARK_)){
var pimpl_12403 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.compiler.protocol_prefix(protocol))),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.name(cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(info)))),"$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(cljs.core.first(args),".",pimpl_12403,"(",cljs.compiler.comma_sep(cljs.core.cons("null",cljs.core.rest(args))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(keyword_QMARK_){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,".cljs$core$IFn$_invoke$arity$",cljs.core.count(args),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
} else {
if(cljs.core.truth_(variadic_invoke)){
var mfa_12404 = cljs.core.cst$kw$max_DASH_fixed_DASH_arity.cljs$core$IFn$_invoke$arity$1(variadic_invoke);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(f__$1,"(",cljs.compiler.comma_sep(cljs.core.take.cljs$core$IFn$_invoke$arity$2(mfa_12404,args)),(((mfa_12404 === (0)))?null:","),"cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.comma_sep(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(mfa_12404,args)),"], 0))"], 0));
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = fn_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = js_QMARK_;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return goog_QMARK_;
}
}
})())){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,"(",cljs.compiler.comma_sep(args),")");
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.analyzer._STAR_cljs_static_fns_STAR_;
if(cljs.core.truth_(and__4210__auto__)){
var G__12402 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(f__$1);
var fexpr__12401 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$var,null,cljs.core.cst$kw$js_DASH_var,null,cljs.core.cst$kw$local,null], null), null);
return (fexpr__12401.cljs$core$IFn$_invoke$arity$1 ? fexpr__12401.cljs$core$IFn$_invoke$arity$1(G__12402) : fexpr__12401.call(null,G__12402));
} else {
return and__4210__auto__;
}
})())){
var fprop_12405 = [".cljs$core$IFn$_invoke$arity$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(args))].join('');
if(cljs.core.truth_(cljs.analyzer._STAR_fn_invoke_direct_STAR_)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12405," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12405,"(",cljs.compiler.comma_sep(args),") : ",f__$1,"(",cljs.compiler.comma_sep(args),"))"], 0));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic("(",f__$1,fprop_12405," ? ",f__$1,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fprop_12405,"(",cljs.compiler.comma_sep(args),") : ",f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),"))"], 0));
}
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$4(f__$1,".call(",cljs.compiler.comma_sep(cljs.core.cons("null",args)),")");
}

}
}
}
}
}
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$new,(function (p__12406){
var map__12407 = p__12406;
var map__12407__$1 = cljs.core.__destructure_map(map__12407);
var ctor = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12407__$1,cljs.core.cst$kw$class);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12407__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12407__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(new ",ctor,"(",cljs.compiler.comma_sep(args),"))");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$set_BANG_,(function (p__12408){
var map__12409 = p__12408;
var map__12409__$1 = cljs.core.__destructure_map(map__12409);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12409__$1,cljs.core.cst$kw$target);
var val = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12409__$1,cljs.core.cst$kw$val);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12409__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$5("(",target," = ",val,")");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}));
cljs.compiler.sublib_select = (function cljs$compiler$sublib_select(sublib){
if(cljs.core.truth_(sublib)){
var xs = clojure.string.split.cljs$core$IFn$_invoke$arity$2(sublib,/\./);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__12410_SHARP_){
return ["['",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p1__12410_SHARP_),"']"].join('');
}),xs));
} else {
return null;
}
});
cljs.compiler.emit_global_export = (function cljs$compiler$emit_global_export(ns_name,global_exports,lib){
var vec__12411 = cljs.analyzer.lib_AMPERSAND_sublib(lib);
var lib_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12411,(0),null);
var sublib = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12411,(1),null);
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_global_export(lib)," = goog.global",cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (prop){
return ["[\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(prop),"\"]"].join('');
}),clojure.string.split.cljs$core$IFn$_invoke$arity$2(cljs.core.name((function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(lib_SINGLEQUOTE_));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(global_exports,cljs.core.name(lib_SINGLEQUOTE_));
}
})()),/\./))),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.compiler.sublib_select(sublib),";"], 0));
});
cljs.compiler.load_libs = (function cljs$compiler$load_libs(libs,seen,reloads,deps,ns_name){
var map__12414 = cljs.core.deref(cljs.env._STAR_compiler_STAR_);
var map__12414__$1 = cljs.core.__destructure_map(map__12414);
var options = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12414__$1,cljs.core.cst$kw$options);
var js_dependency_index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12414__$1,cljs.core.cst$kw$js_DASH_dependency_DASH_index);
var map__12415 = options;
var map__12415__$1 = cljs.core.__destructure_map(map__12415);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12415__$1,cljs.core.cst$kw$target);
var nodejs_rt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12415__$1,cljs.core.cst$kw$nodejs_DASH_rt);
var optimizations = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12415__$1,cljs.core.cst$kw$optimizations);
var loaded_libs = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_);
var loaded_libs_temp = cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.gensym.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$sym$cljs$core$_STAR_loaded_DASH_libs_STAR_));
var vec__12416 = (function (){var libs__$1 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(seen)),cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.set(cljs.core.vals(libs)),deps));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$nodejs,target)){
var map__12419 = cljs.core.group_by(cljs.analyzer.node_module_dep_QMARK_,libs__$1);
var map__12419__$1 = cljs.core.__destructure_map(map__12419);
var node_libs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12419__$1,true);
var libs_to_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12419__$1,false);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [node_libs,libs_to_load], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,libs__$1], null);
}
})();
var node_libs = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12416,(0),null);
var libs_to_load = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12416,(1),null);
var global_exports_libs = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.analyzer.dep_has_global_exports_QMARK_,libs_to_load);
if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("if(!COMPILED) ",loaded_libs_temp," = ",loaded_libs," || cljs.core.set([\"cljs.core\"]);");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("if(!COMPILED) ",loaded_libs," = cljs.core.set([\"cljs.core\"]);");
} else {
}

var seq__12420_12448 = cljs.core.seq(libs_to_load);
var chunk__12421_12449 = null;
var count__12422_12450 = (0);
var i__12423_12451 = (0);
while(true){
if((i__12423_12451 < count__12422_12450)){
var lib_12452 = chunk__12421_12449.cljs$core$IIndexed$_nth$arity$2(null,i__12423_12451);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12452)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12452),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12452),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12452),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12452),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12452,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12452),"');");
}

}
}
}


var G__12453 = seq__12420_12448;
var G__12454 = chunk__12421_12449;
var G__12455 = count__12422_12450;
var G__12456 = (i__12423_12451 + (1));
seq__12420_12448 = G__12453;
chunk__12421_12449 = G__12454;
count__12422_12450 = G__12455;
i__12423_12451 = G__12456;
continue;
} else {
var temp__5753__auto___12457 = cljs.core.seq(seq__12420_12448);
if(temp__5753__auto___12457){
var seq__12420_12458__$1 = temp__5753__auto___12457;
if(cljs.core.chunked_seq_QMARK_(seq__12420_12458__$1)){
var c__4638__auto___12459 = cljs.core.chunk_first(seq__12420_12458__$1);
var G__12460 = cljs.core.chunk_rest(seq__12420_12458__$1);
var G__12461 = c__4638__auto___12459;
var G__12462 = cljs.core.count(c__4638__auto___12459);
var G__12463 = (0);
seq__12420_12448 = G__12460;
chunk__12421_12449 = G__12461;
count__12422_12450 = G__12462;
i__12423_12451 = G__12463;
continue;
} else {
var lib_12464 = cljs.core.first(seq__12420_12458__$1);
if(((cljs.analyzer.foreign_dep_QMARK_(lib_12464)) && ((!(cljs.core.keyword_identical_QMARK_(optimizations,cljs.core.cst$kw$none)))))){
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12464),cljs.core.cst$kw$reload);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12464),"', 'reload');");
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(reloads,lib_12464),cljs.core.cst$kw$reload_DASH_all);
}
})())){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12464),"', 'reload-all');");
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lib_12464,cljs.core.cst$sym$goog)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(lib_12464),"');");
}

}
}
}


var G__12465 = cljs.core.next(seq__12420_12458__$1);
var G__12466 = null;
var G__12467 = (0);
var G__12468 = (0);
seq__12420_12448 = G__12465;
chunk__12421_12449 = G__12466;
count__12422_12450 = G__12467;
i__12423_12451 = G__12468;
continue;
}
} else {
}
}
break;
}

var seq__12424_12469 = cljs.core.seq(node_libs);
var chunk__12425_12470 = null;
var count__12426_12471 = (0);
var i__12427_12472 = (0);
while(true){
if((i__12427_12472 < count__12426_12471)){
var lib_12473 = chunk__12425_12470.cljs$core$IIndexed$_nth$arity$2(null,i__12427_12472);
var vec__12434_12474 = cljs.analyzer.lib_AMPERSAND_sublib(lib_12473);
var lib_SINGLEQUOTE__12475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12434_12474,(0),null);
var sublib_12476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12434_12474,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12473)," = require('",lib_SINGLEQUOTE__12475,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_12476),";"], 0));


var G__12477 = seq__12424_12469;
var G__12478 = chunk__12425_12470;
var G__12479 = count__12426_12471;
var G__12480 = (i__12427_12472 + (1));
seq__12424_12469 = G__12477;
chunk__12425_12470 = G__12478;
count__12426_12471 = G__12479;
i__12427_12472 = G__12480;
continue;
} else {
var temp__5753__auto___12481 = cljs.core.seq(seq__12424_12469);
if(temp__5753__auto___12481){
var seq__12424_12482__$1 = temp__5753__auto___12481;
if(cljs.core.chunked_seq_QMARK_(seq__12424_12482__$1)){
var c__4638__auto___12483 = cljs.core.chunk_first(seq__12424_12482__$1);
var G__12484 = cljs.core.chunk_rest(seq__12424_12482__$1);
var G__12485 = c__4638__auto___12483;
var G__12486 = cljs.core.count(c__4638__auto___12483);
var G__12487 = (0);
seq__12424_12469 = G__12484;
chunk__12425_12470 = G__12485;
count__12426_12471 = G__12486;
i__12427_12472 = G__12487;
continue;
} else {
var lib_12488 = cljs.core.first(seq__12424_12482__$1);
var vec__12437_12489 = cljs.analyzer.lib_AMPERSAND_sublib(lib_12488);
var lib_SINGLEQUOTE__12490 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12437_12489,(0),null);
var sublib_12491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12437_12489,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(ns_name),".",cljs.analyzer.munge_node_lib(lib_12488)," = require('",lib_SINGLEQUOTE__12490,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["')",cljs.compiler.sublib_select(sublib_12491),";"], 0));


var G__12492 = cljs.core.next(seq__12424_12482__$1);
var G__12493 = null;
var G__12494 = (0);
var G__12495 = (0);
seq__12424_12469 = G__12492;
chunk__12425_12470 = G__12493;
count__12426_12471 = G__12494;
i__12427_12472 = G__12495;
continue;
}
} else {
}
}
break;
}

var seq__12440_12496 = cljs.core.seq(global_exports_libs);
var chunk__12441_12497 = null;
var count__12442_12498 = (0);
var i__12443_12499 = (0);
while(true){
if((i__12443_12499 < count__12442_12498)){
var lib_12500 = chunk__12441_12497.cljs$core$IIndexed$_nth$arity$2(null,i__12443_12499);
var map__12446_12501 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12500))));
var map__12446_12502__$1 = cljs.core.__destructure_map(map__12446_12501);
var global_exports_12503 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12446_12502__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12503,lib_12500);


var G__12504 = seq__12440_12496;
var G__12505 = chunk__12441_12497;
var G__12506 = count__12442_12498;
var G__12507 = (i__12443_12499 + (1));
seq__12440_12496 = G__12504;
chunk__12441_12497 = G__12505;
count__12442_12498 = G__12506;
i__12443_12499 = G__12507;
continue;
} else {
var temp__5753__auto___12508 = cljs.core.seq(seq__12440_12496);
if(temp__5753__auto___12508){
var seq__12440_12509__$1 = temp__5753__auto___12508;
if(cljs.core.chunked_seq_QMARK_(seq__12440_12509__$1)){
var c__4638__auto___12510 = cljs.core.chunk_first(seq__12440_12509__$1);
var G__12511 = cljs.core.chunk_rest(seq__12440_12509__$1);
var G__12512 = c__4638__auto___12510;
var G__12513 = cljs.core.count(c__4638__auto___12510);
var G__12514 = (0);
seq__12440_12496 = G__12511;
chunk__12441_12497 = G__12512;
count__12442_12498 = G__12513;
i__12443_12499 = G__12514;
continue;
} else {
var lib_12515 = cljs.core.first(seq__12440_12509__$1);
var map__12447_12516 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(js_dependency_index,cljs.core.name(cljs.core.first(cljs.analyzer.lib_AMPERSAND_sublib(lib_12515))));
var map__12447_12517__$1 = cljs.core.__destructure_map(map__12447_12516);
var global_exports_12518 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12447_12517__$1,cljs.core.cst$kw$global_DASH_exports);
cljs.compiler.emit_global_export(ns_name,global_exports_12518,lib_12515);


var G__12519 = cljs.core.next(seq__12440_12509__$1);
var G__12520 = null;
var G__12521 = (0);
var G__12522 = (0);
seq__12440_12496 = G__12519;
chunk__12441_12497 = G__12520;
count__12442_12498 = G__12521;
i__12443_12499 = G__12522;
continue;
}
} else {
}
}
break;
}

if(cljs.core.truth_(cljs.core.cst$kw$reload_DASH_all.cljs$core$IFn$_invoke$arity$1(cljs.core.meta(libs)))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$variadic("if(!COMPILED) ",loaded_libs," = cljs.core.into(",loaded_libs_temp,", ",cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([loaded_libs,");"], 0));
} else {
return null;
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns_STAR_,(function (p__12523){
var map__12524 = p__12523;
var map__12524__$1 = cljs.core.__destructure_map(map__12524);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12524__$1,cljs.core.cst$kw$deps);
cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

if(cljs.core.truth_(cljs.core.cst$kw$repl_DASH_env.cljs$core$IFn$_invoke$arity$1(env))){
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("'nil';");
} else {
return null;
}
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$ns,(function (p__12525){
var map__12526 = p__12525;
var map__12526__$1 = cljs.core.__destructure_map(map__12526);
var name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$name);
var requires = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$requires);
var uses = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$uses);
var require_macros = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$require_DASH_macros);
var reloads = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$reloads);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$env);
var deps = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12526__$1,cljs.core.cst$kw$deps);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(name),"');");

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(name,cljs.core.cst$sym$cljs$core)){
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

if(cljs.core.truth_(cljs.core.cst$kw$emit_DASH_constants.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$options.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.env._STAR_compiler_STAR_))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.require('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");
} else {
}
}

cljs.compiler.load_libs(requires,null,cljs.core.cst$kw$require.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);

return cljs.compiler.load_libs(uses,requires,cljs.core.cst$kw$use.cljs$core$IFn$_invoke$arity$1(reloads),deps,name);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$deftype,(function (p__12527){
var map__12528 = p__12527;
var map__12528__$1 = cljs.core.__destructure_map(map__12528);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12528__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12528__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12528__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12528__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12528__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12529_12553 = cljs.core.seq(protocols);
var chunk__12530_12554 = null;
var count__12531_12555 = (0);
var i__12532_12556 = (0);
while(true){
if((i__12532_12556 < count__12531_12555)){
var protocol_12557 = chunk__12530_12554.cljs$core$IIndexed$_nth$arity$2(null,i__12532_12556);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12557)),"}");


var G__12558 = seq__12529_12553;
var G__12559 = chunk__12530_12554;
var G__12560 = count__12531_12555;
var G__12561 = (i__12532_12556 + (1));
seq__12529_12553 = G__12558;
chunk__12530_12554 = G__12559;
count__12531_12555 = G__12560;
i__12532_12556 = G__12561;
continue;
} else {
var temp__5753__auto___12562 = cljs.core.seq(seq__12529_12553);
if(temp__5753__auto___12562){
var seq__12529_12563__$1 = temp__5753__auto___12562;
if(cljs.core.chunked_seq_QMARK_(seq__12529_12563__$1)){
var c__4638__auto___12564 = cljs.core.chunk_first(seq__12529_12563__$1);
var G__12565 = cljs.core.chunk_rest(seq__12529_12563__$1);
var G__12566 = c__4638__auto___12564;
var G__12567 = cljs.core.count(c__4638__auto___12564);
var G__12568 = (0);
seq__12529_12553 = G__12565;
chunk__12530_12554 = G__12566;
count__12531_12555 = G__12567;
i__12532_12556 = G__12568;
continue;
} else {
var protocol_12569 = cljs.core.first(seq__12529_12563__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12569)),"}");


var G__12570 = cljs.core.next(seq__12529_12563__$1);
var G__12571 = null;
var G__12572 = (0);
var G__12573 = (0);
seq__12529_12553 = G__12570;
chunk__12530_12554 = G__12571;
count__12531_12555 = G__12572;
i__12532_12556 = G__12573;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12533_12574 = cljs.core.seq(fields__$1);
var chunk__12534_12575 = null;
var count__12535_12576 = (0);
var i__12536_12577 = (0);
while(true){
if((i__12536_12577 < count__12535_12576)){
var fld_12578 = chunk__12534_12575.cljs$core$IIndexed$_nth$arity$2(null,i__12536_12577);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12578," = ",fld_12578,";");


var G__12579 = seq__12533_12574;
var G__12580 = chunk__12534_12575;
var G__12581 = count__12535_12576;
var G__12582 = (i__12536_12577 + (1));
seq__12533_12574 = G__12579;
chunk__12534_12575 = G__12580;
count__12535_12576 = G__12581;
i__12536_12577 = G__12582;
continue;
} else {
var temp__5753__auto___12583 = cljs.core.seq(seq__12533_12574);
if(temp__5753__auto___12583){
var seq__12533_12584__$1 = temp__5753__auto___12583;
if(cljs.core.chunked_seq_QMARK_(seq__12533_12584__$1)){
var c__4638__auto___12585 = cljs.core.chunk_first(seq__12533_12584__$1);
var G__12586 = cljs.core.chunk_rest(seq__12533_12584__$1);
var G__12587 = c__4638__auto___12585;
var G__12588 = cljs.core.count(c__4638__auto___12585);
var G__12589 = (0);
seq__12533_12574 = G__12586;
chunk__12534_12575 = G__12587;
count__12535_12576 = G__12588;
i__12536_12577 = G__12589;
continue;
} else {
var fld_12590 = cljs.core.first(seq__12533_12584__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12590," = ",fld_12590,";");


var G__12591 = cljs.core.next(seq__12533_12584__$1);
var G__12592 = null;
var G__12593 = (0);
var G__12594 = (0);
seq__12533_12574 = G__12591;
chunk__12534_12575 = G__12592;
count__12535_12576 = G__12593;
i__12536_12577 = G__12594;
continue;
}
} else {
}
}
break;
}

var seq__12537_12595 = cljs.core.seq(pmasks);
var chunk__12538_12596 = null;
var count__12539_12597 = (0);
var i__12540_12598 = (0);
while(true){
if((i__12540_12598 < count__12539_12597)){
var vec__12547_12599 = chunk__12538_12596.cljs$core$IIndexed$_nth$arity$2(null,i__12540_12598);
var pno_12600 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12547_12599,(0),null);
var pmask_12601 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12547_12599,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12600,"$ = ",pmask_12601,";");


var G__12602 = seq__12537_12595;
var G__12603 = chunk__12538_12596;
var G__12604 = count__12539_12597;
var G__12605 = (i__12540_12598 + (1));
seq__12537_12595 = G__12602;
chunk__12538_12596 = G__12603;
count__12539_12597 = G__12604;
i__12540_12598 = G__12605;
continue;
} else {
var temp__5753__auto___12606 = cljs.core.seq(seq__12537_12595);
if(temp__5753__auto___12606){
var seq__12537_12607__$1 = temp__5753__auto___12606;
if(cljs.core.chunked_seq_QMARK_(seq__12537_12607__$1)){
var c__4638__auto___12608 = cljs.core.chunk_first(seq__12537_12607__$1);
var G__12609 = cljs.core.chunk_rest(seq__12537_12607__$1);
var G__12610 = c__4638__auto___12608;
var G__12611 = cljs.core.count(c__4638__auto___12608);
var G__12612 = (0);
seq__12537_12595 = G__12609;
chunk__12538_12596 = G__12610;
count__12539_12597 = G__12611;
i__12540_12598 = G__12612;
continue;
} else {
var vec__12550_12613 = cljs.core.first(seq__12537_12607__$1);
var pno_12614 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12550_12613,(0),null);
var pmask_12615 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12550_12613,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12614,"$ = ",pmask_12615,";");


var G__12616 = cljs.core.next(seq__12537_12607__$1);
var G__12617 = null;
var G__12618 = (0);
var G__12619 = (0);
seq__12537_12595 = G__12616;
chunk__12538_12596 = G__12617;
count__12539_12597 = G__12618;
i__12540_12598 = G__12619;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$defrecord,(function (p__12620){
var map__12621 = p__12620;
var map__12621__$1 = cljs.core.__destructure_map(map__12621);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12621__$1,cljs.core.cst$kw$t);
var fields = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12621__$1,cljs.core.cst$kw$fields);
var pmasks = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12621__$1,cljs.core.cst$kw$pmasks);
var body = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12621__$1,cljs.core.cst$kw$body);
var protocols = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12621__$1,cljs.core.cst$kw$protocols);
var fields__$1 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,fields),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$__meta,cljs.core.cst$sym$__extmap,cljs.core.cst$sym$__hash], null));
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("/**");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("* @constructor");

var seq__12622_12646 = cljs.core.seq(protocols);
var chunk__12623_12647 = null;
var count__12624_12648 = (0);
var i__12625_12649 = (0);
while(true){
if((i__12625_12649 < count__12624_12648)){
var protocol_12650 = chunk__12623_12647.cljs$core$IIndexed$_nth$arity$2(null,i__12625_12649);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12650)),"}");


var G__12651 = seq__12622_12646;
var G__12652 = chunk__12623_12647;
var G__12653 = count__12624_12648;
var G__12654 = (i__12625_12649 + (1));
seq__12622_12646 = G__12651;
chunk__12623_12647 = G__12652;
count__12624_12648 = G__12653;
i__12625_12649 = G__12654;
continue;
} else {
var temp__5753__auto___12655 = cljs.core.seq(seq__12622_12646);
if(temp__5753__auto___12655){
var seq__12622_12656__$1 = temp__5753__auto___12655;
if(cljs.core.chunked_seq_QMARK_(seq__12622_12656__$1)){
var c__4638__auto___12657 = cljs.core.chunk_first(seq__12622_12656__$1);
var G__12658 = cljs.core.chunk_rest(seq__12622_12656__$1);
var G__12659 = c__4638__auto___12657;
var G__12660 = cljs.core.count(c__4638__auto___12657);
var G__12661 = (0);
seq__12622_12646 = G__12658;
chunk__12623_12647 = G__12659;
count__12624_12648 = G__12660;
i__12625_12649 = G__12661;
continue;
} else {
var protocol_12662 = cljs.core.first(seq__12622_12656__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3(" * @implements {",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.core.str.cljs$core$IFn$_invoke$arity$1(protocol_12662)),"}");


var G__12663 = cljs.core.next(seq__12622_12656__$1);
var G__12664 = null;
var G__12665 = (0);
var G__12666 = (0);
seq__12622_12646 = G__12663;
chunk__12623_12647 = G__12664;
count__12624_12648 = G__12665;
i__12625_12649 = G__12666;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("*/");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$4(cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(t)," = (function (",cljs.compiler.comma_sep(fields__$1),"){");

var seq__12626_12667 = cljs.core.seq(fields__$1);
var chunk__12627_12668 = null;
var count__12628_12669 = (0);
var i__12629_12670 = (0);
while(true){
if((i__12629_12670 < count__12628_12669)){
var fld_12671 = chunk__12627_12668.cljs$core$IIndexed$_nth$arity$2(null,i__12629_12670);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12671," = ",fld_12671,";");


var G__12672 = seq__12626_12667;
var G__12673 = chunk__12627_12668;
var G__12674 = count__12628_12669;
var G__12675 = (i__12629_12670 + (1));
seq__12626_12667 = G__12672;
chunk__12627_12668 = G__12673;
count__12628_12669 = G__12674;
i__12629_12670 = G__12675;
continue;
} else {
var temp__5753__auto___12676 = cljs.core.seq(seq__12626_12667);
if(temp__5753__auto___12676){
var seq__12626_12677__$1 = temp__5753__auto___12676;
if(cljs.core.chunked_seq_QMARK_(seq__12626_12677__$1)){
var c__4638__auto___12678 = cljs.core.chunk_first(seq__12626_12677__$1);
var G__12679 = cljs.core.chunk_rest(seq__12626_12677__$1);
var G__12680 = c__4638__auto___12678;
var G__12681 = cljs.core.count(c__4638__auto___12678);
var G__12682 = (0);
seq__12626_12667 = G__12679;
chunk__12627_12668 = G__12680;
count__12628_12669 = G__12681;
i__12629_12670 = G__12682;
continue;
} else {
var fld_12683 = cljs.core.first(seq__12626_12677__$1);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.",fld_12683," = ",fld_12683,";");


var G__12684 = cljs.core.next(seq__12626_12677__$1);
var G__12685 = null;
var G__12686 = (0);
var G__12687 = (0);
seq__12626_12667 = G__12684;
chunk__12627_12668 = G__12685;
count__12628_12669 = G__12686;
i__12629_12670 = G__12687;
continue;
}
} else {
}
}
break;
}

var seq__12630_12688 = cljs.core.seq(pmasks);
var chunk__12631_12689 = null;
var count__12632_12690 = (0);
var i__12633_12691 = (0);
while(true){
if((i__12633_12691 < count__12632_12690)){
var vec__12640_12692 = chunk__12631_12689.cljs$core$IIndexed$_nth$arity$2(null,i__12633_12691);
var pno_12693 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12640_12692,(0),null);
var pmask_12694 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12640_12692,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12693,"$ = ",pmask_12694,";");


var G__12695 = seq__12630_12688;
var G__12696 = chunk__12631_12689;
var G__12697 = count__12632_12690;
var G__12698 = (i__12633_12691 + (1));
seq__12630_12688 = G__12695;
chunk__12631_12689 = G__12696;
count__12632_12690 = G__12697;
i__12633_12691 = G__12698;
continue;
} else {
var temp__5753__auto___12699 = cljs.core.seq(seq__12630_12688);
if(temp__5753__auto___12699){
var seq__12630_12700__$1 = temp__5753__auto___12699;
if(cljs.core.chunked_seq_QMARK_(seq__12630_12700__$1)){
var c__4638__auto___12701 = cljs.core.chunk_first(seq__12630_12700__$1);
var G__12702 = cljs.core.chunk_rest(seq__12630_12700__$1);
var G__12703 = c__4638__auto___12701;
var G__12704 = cljs.core.count(c__4638__auto___12701);
var G__12705 = (0);
seq__12630_12688 = G__12702;
chunk__12631_12689 = G__12703;
count__12632_12690 = G__12704;
i__12633_12691 = G__12705;
continue;
} else {
var vec__12643_12706 = cljs.core.first(seq__12630_12700__$1);
var pno_12707 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12643_12706,(0),null);
var pmask_12708 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12643_12706,(1),null);
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$5("this.cljs$lang$protocol_mask$partition",pno_12707,"$ = ",pmask_12708,";");


var G__12709 = cljs.core.next(seq__12630_12700__$1);
var G__12710 = null;
var G__12711 = (0);
var G__12712 = (0);
seq__12630_12688 = G__12709;
chunk__12631_12689 = G__12710;
count__12632_12690 = G__12711;
i__12633_12691 = G__12712;
continue;
}
} else {
}
}
break;
}

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("});");

return cljs.compiler.emit(body);
}));
cljs.compiler.emit_dot = (function cljs$compiler$emit_dot(p__12713){
var map__12714 = p__12713;
var map__12714__$1 = cljs.core.__destructure_map(map__12714);
var target = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$target);
var field = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$field);
var method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$method);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$args);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12714__$1,cljs.core.cst$kw$env);
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(field)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(field,cljs.core.PersistentHashSet.EMPTY));
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$variadic(target,".",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$2(method,cljs.core.PersistentHashSet.EMPTY),"(",cljs.compiler.comma_sep(args),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([")"], 0));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
});
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_field,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$host_DASH_call,(function (ast){
return cljs.compiler.emit_dot(ast);
}));
cljs.compiler.emit_STAR_.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$js,(function (p__12715){
var map__12716 = p__12715;
var map__12716__$1 = cljs.core.__destructure_map(map__12716);
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12716__$1,cljs.core.cst$kw$op);
var env = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12716__$1,cljs.core.cst$kw$env);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12716__$1,cljs.core.cst$kw$code);
var segs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12716__$1,cljs.core.cst$kw$segs);
var args = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__12716__$1,cljs.core.cst$kw$args);
if(cljs.core.truth_((function (){var and__4210__auto__ = code;
if(cljs.core.truth_(and__4210__auto__)){
return goog.string.startsWith(clojure.string.trim(code),"/*");
} else {
return and__4210__auto__;
}
})())){
return cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
var env__11516__auto__ = env;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$return,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1("return ");
} else {
}

if(cljs.core.truth_(code)){
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(code);
} else {
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(segs,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(null)),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(args,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [null], null))));
}

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expr,cljs.core.cst$kw$context.cljs$core$IFn$_invoke$arity$1(env__11516__auto__))){
return null;
} else {
return cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1(";");
}
}
}));
cljs.compiler.emit_constants_table = (function cljs$compiler$emit_constants_table(table){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("goog.provide('",cljs.compiler.munge.cljs$core$IFn$_invoke$arity$1(cljs.analyzer.constants_ns_sym),"');");

cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$1("goog.require('cljs.core');");

var seq__12721 = cljs.core.seq(table);
var chunk__12722 = null;
var count__12723 = (0);
var i__12724 = (0);
while(true){
if((i__12724 < count__12723)){
var vec__12731 = chunk__12722.cljs$core$IIndexed$_nth$arity$2(null,i__12724);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12731,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12731,(1),null);
var ns_12737 = cljs.core.namespace(sym);
var name_12738 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12739 = seq__12721;
var G__12740 = chunk__12722;
var G__12741 = count__12723;
var G__12742 = (i__12724 + (1));
seq__12721 = G__12739;
chunk__12722 = G__12740;
count__12723 = G__12741;
i__12724 = G__12742;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__12721);
if(temp__5753__auto__){
var seq__12721__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__12721__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__12721__$1);
var G__12743 = cljs.core.chunk_rest(seq__12721__$1);
var G__12744 = c__4638__auto__;
var G__12745 = cljs.core.count(c__4638__auto__);
var G__12746 = (0);
seq__12721 = G__12743;
chunk__12722 = G__12744;
count__12723 = G__12745;
i__12724 = G__12746;
continue;
} else {
var vec__12734 = cljs.core.first(seq__12721__$1);
var sym = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12734,(0),null);
var value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12734,(1),null);
var ns_12747 = cljs.core.namespace(sym);
var name_12748 = cljs.core.name(sym);
cljs.compiler.emits.cljs$core$IFn$_invoke$arity$3("cljs.core.",value," = ");

if((sym instanceof cljs.core.Keyword)){
cljs.compiler.emits_keyword(sym);
} else {
if((sym instanceof cljs.core.Symbol)){
cljs.compiler.emits_symbol(sym);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Cannot emit constant for type ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.type(sym))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$error,cljs.core.cst$kw$invalid_DASH_constant_DASH_type,cljs.core.cst$kw$clojure$error_SLASH_phase,cljs.core.cst$kw$compilation], null));

}
}

cljs.compiler.emits.cljs$core$IFn$_invoke$arity$1(";\n");


var G__12749 = cljs.core.next(seq__12721__$1);
var G__12750 = null;
var G__12751 = (0);
var G__12752 = (0);
seq__12721 = G__12749;
chunk__12722 = G__12750;
count__12723 = G__12751;
i__12724 = G__12752;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.compiler.emit_externs = (function cljs$compiler$emit_externs(var_args){
var G__12754 = arguments.length;
switch (G__12754) {
case 1:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 4:
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$1 = (function (externs){
return cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentVector.EMPTY,externs,cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY),(cljs.core.truth_(cljs.env._STAR_compiler_STAR_)?cljs.analyzer.get_externs():null));
}));

(cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4 = (function (prefix,externs,top_level,known_externs){
var ks = cljs.core.seq(cljs.core.keys(externs));
while(true){
if(ks){
var k_12759 = cljs.core.first(ks);
var vec__12755_12760 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(prefix,k_12759);
var top_12761 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__12755_12760,(0),null);
var prefix_SINGLEQUOTE__12762 = vec__12755_12760;
if(((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$prototype,k_12759)) && ((cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(known_externs,prefix_SINGLEQUOTE__12762) == null)))){
if((!(((cljs.core.contains_QMARK_(cljs.core.deref(top_level),top_12761)) || (cljs.core.contains_QMARK_(known_externs,top_12761)))))){
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$3("var ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12762)),";");

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(top_level,cljs.core.conj,top_12761);
} else {
cljs.compiler.emitln.cljs$core$IFn$_invoke$arity$2(clojure.string.join.cljs$core$IFn$_invoke$arity$2(".",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.compiler.munge,prefix_SINGLEQUOTE__12762)),";");
}
} else {
}

var m_12763 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(externs,k_12759);
if(cljs.core.empty_QMARK_(m_12763)){
} else {
cljs.compiler.emit_externs.cljs$core$IFn$_invoke$arity$4(prefix_SINGLEQUOTE__12762,m_12763,top_level,known_externs);
}

var G__12764 = cljs.core.next(ks);
ks = G__12764;
continue;
} else {
return null;
}
break;
}
}));

(cljs.compiler.emit_externs.cljs$lang$maxFixedArity = 4);

