// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fipp.engine');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('fipp.deque');
if((typeof fipp !== 'undefined') && (typeof fipp.engine !== 'undefined') && (typeof fipp.engine.serialize_node !== 'undefined')){
} else {
fipp.engine.serialize_node = (function (){var method_table__4701__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var prefer_table__4702__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var method_cache__4703__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var cached_hierarchy__4704__auto__ = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var hierarchy__4705__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$hierarchy,(function (){var fexpr__8153 = cljs.core.get_global_hierarchy;
return (fexpr__8153.cljs$core$IFn$_invoke$arity$0 ? fexpr__8153.cljs$core$IFn$_invoke$arity$0() : fexpr__8153.call(null));
})());
return (new cljs.core.MultiFn(cljs.core.symbol.cljs$core$IFn$_invoke$arity$2("fipp.engine","serialize-node"),cljs.core.first,cljs.core.cst$kw$default,hierarchy__4705__auto__,method_table__4701__auto__,prefer_table__4702__auto__,method_cache__4703__auto__,cached_hierarchy__4704__auto__));
})();
}
fipp.engine.serialize = (function fipp$engine$serialize(doc){
if((doc == null)){
return null;
} else {
if(cljs.core.seq_QMARK_(doc)){
return cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(fipp.engine.serialize,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([doc], 0));
} else {
if(typeof doc === 'string'){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$text,cljs.core.cst$kw$text,doc], null)], null);
} else {
if((doc instanceof cljs.core.Keyword)){
var G__8154 = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [doc], null);
return (fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1 ? fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1(G__8154) : fipp.engine.serialize_node.call(null,G__8154));
} else {
if(cljs.core.vector_QMARK_(doc)){
return (fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1 ? fipp.engine.serialize_node.cljs$core$IFn$_invoke$arity$1(doc) : fipp.engine.serialize_node.call(null,doc));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected class for doc node",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$node,doc], null));

}
}
}
}
}
});
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$text,(function (p__8155){
var vec__8156 = p__8155;
var seq__8157 = cljs.core.seq(vec__8156);
var first__8158 = cljs.core.first(seq__8157);
var seq__8157__$1 = cljs.core.next(seq__8157);
var _ = first__8158;
var text = seq__8157__$1;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$text,cljs.core.cst$kw$text,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,text)], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$pass,(function (p__8159){
var vec__8160 = p__8159;
var seq__8161 = cljs.core.seq(vec__8160);
var first__8162 = cljs.core.first(seq__8161);
var seq__8161__$1 = cljs.core.next(seq__8161);
var _ = first__8162;
var text = seq__8161__$1;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$pass,cljs.core.cst$kw$text,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,text)], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$escaped,(function (p__8163){
var vec__8164 = p__8163;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8164,(0),null);
var text = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8164,(1),null);
if(typeof text === 'string'){
} else {
throw (new Error("Assert failed: (string? text)"));
}

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$escaped,cljs.core.cst$kw$text,text], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$span,(function (p__8167){
var vec__8168 = p__8167;
var seq__8169 = cljs.core.seq(vec__8168);
var first__8170 = cljs.core.first(seq__8169);
var seq__8169__$1 = cljs.core.next(seq__8169);
var _ = first__8170;
var children = seq__8169__$1;
return fipp.engine.serialize(children);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$line,(function (p__8171){
var vec__8172 = p__8171;
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8172,(0),null);
var inline = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8172,(1),null);
var terminate = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8172,(2),null);
var inline__$1 = (function (){var or__4212__auto__ = inline;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return " ";
}
})();
var terminate__$1 = (function (){var or__4212__auto__ = terminate;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return "";
}
})();
if(typeof inline__$1 === 'string'){
} else {
throw (new Error("Assert failed: (string? inline)"));
}

if(typeof terminate__$1 === 'string'){
} else {
throw (new Error("Assert failed: (string? terminate)"));
}

return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$op,cljs.core.cst$kw$line,cljs.core.cst$kw$inline,inline__$1,cljs.core.cst$kw$terminate,terminate__$1], null)], null);
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$break,(function() { 
var G__8175__delegate = function (_){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$break], null)], null);
};
var G__8175 = function (var_args){
var _ = null;
if (arguments.length > 0) {
var G__8176__i = 0, G__8176__a = new Array(arguments.length -  0);
while (G__8176__i < G__8176__a.length) {G__8176__a[G__8176__i] = arguments[G__8176__i + 0]; ++G__8176__i;}
  _ = new cljs.core.IndexedSeq(G__8176__a,0,null);
} 
return G__8175__delegate.call(this,_);};
G__8175.cljs$lang$maxFixedArity = 0;
G__8175.cljs$lang$applyTo = (function (arglist__8177){
var _ = cljs.core.seq(arglist__8177);
return G__8175__delegate(_);
});
G__8175.cljs$core$IFn$_invoke$arity$variadic = G__8175__delegate;
return G__8175;
})()
);
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$group,(function (p__8178){
var vec__8179 = p__8178;
var seq__8180 = cljs.core.seq(vec__8179);
var first__8181 = cljs.core.first(seq__8180);
var seq__8180__$1 = cljs.core.next(seq__8180);
var _ = first__8181;
var children = seq__8180__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$end], null)], null)], 0));
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$nest,(function (p__8182){
var vec__8183 = p__8182;
var seq__8184 = cljs.core.seq(vec__8183);
var first__8185 = cljs.core.first(seq__8184);
var seq__8184__$1 = cljs.core.next(seq__8184);
var _ = first__8185;
var args = seq__8184__$1;
var vec__8186 = ((typeof cljs.core.first(args) === 'number')?args:cljs.core.cons((2),args));
var seq__8187 = cljs.core.seq(vec__8186);
var first__8188 = cljs.core.first(seq__8187);
var seq__8187__$1 = cljs.core.next(seq__8187);
var offset = first__8188;
var children = seq__8187__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$nest,cljs.core.cst$kw$offset,offset], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$outdent], null)], null)], 0));
}));
fipp.engine.serialize_node.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$align,(function (p__8189){
var vec__8190 = p__8189;
var seq__8191 = cljs.core.seq(vec__8190);
var first__8192 = cljs.core.first(seq__8191);
var seq__8191__$1 = cljs.core.next(seq__8191);
var _ = first__8192;
var args = seq__8191__$1;
var vec__8193 = ((typeof cljs.core.first(args) === 'number')?args:cljs.core.cons((0),args));
var seq__8194 = cljs.core.seq(vec__8193);
var first__8195 = cljs.core.first(seq__8194);
var seq__8194__$1 = cljs.core.next(seq__8194);
var offset = first__8195;
var children = seq__8194__$1;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$align,cljs.core.cst$kw$offset,offset], null)], null),fipp.engine.serialize(children),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$op,cljs.core.cst$kw$outdent], null)], null)], 0));
}));
/**
 * A transducer which annotates the right-side of nodes assuming a
 *   hypothetical single-line formatting of the document. Groups and indentation
 *   directives are temporarily assumed to be zero-width. These values are used
 *   by subsequent passes to produce the final layout.
 */
fipp.engine.annotate_rights = (function fipp$engine$annotate_rights(rf){
var pos = cljs.core.volatile_BANG_((0));
return (function() {
var G__8199 = null;
var G__8199__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8199__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__8199__2 = (function (res,node){
var delta = (function (){var G__8196 = cljs.core.cst$kw$op.cljs$core$IFn$_invoke$arity$1(node);
var G__8196__$1 = (((G__8196 instanceof cljs.core.Keyword))?G__8196.fqn:null);
switch (G__8196__$1) {
case "text":
return cljs.core.count(cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node));

break;
case "line":
return cljs.core.count(cljs.core.cst$kw$inline.cljs$core$IFn$_invoke$arity$1(node));

break;
case "escaped":
return (1);

break;
default:
return (0);

}
})();
var p = pos.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(pos.cljs$core$IDeref$_deref$arity$1(null) + delta));
var G__8197 = res;
var G__8198 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(node,cljs.core.cst$kw$right,p);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8197,G__8198) : rf.call(null,G__8197,G__8198));
});
G__8199 = function(res,node){
switch(arguments.length){
case 0:
return G__8199__0.call(this);
case 1:
return G__8199__1.call(this,res);
case 2:
return G__8199__2.call(this,res,node);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8199.cljs$core$IFn$_invoke$arity$0 = G__8199__0;
G__8199.cljs$core$IFn$_invoke$arity$1 = G__8199__1;
G__8199.cljs$core$IFn$_invoke$arity$2 = G__8199__2;
return G__8199;
})()
});
fipp.engine.update_right = (function fipp$engine$update_right(var_args){
var args__4824__auto__ = [];
var len__4818__auto___8206 = arguments.length;
var i__4819__auto___8207 = (0);
while(true){
if((i__4819__auto___8207 < len__4818__auto___8206)){
args__4824__auto__.push((arguments[i__4819__auto___8207]));

var G__8208 = (i__4819__auto___8207 + (1));
i__4819__auto___8207 = G__8208;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic = (function (deque,f,args){
var G__8204 = cljs.core.pop(deque);
var G__8205 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,cljs.core.peek(deque),args);
return (fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2 ? fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2(G__8204,G__8205) : fipp.deque.conjr.call(null,G__8204,G__8205));
}));

(fipp.engine.update_right.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fipp.engine.update_right.cljs$lang$applyTo = (function (seq8201){
var G__8202 = cljs.core.first(seq8201);
var seq8201__$1 = cljs.core.next(seq8201);
var G__8203 = cljs.core.first(seq8201__$1);
var seq8201__$2 = cljs.core.next(seq8201__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__8202,G__8203,seq8201__$2);
}));

/**
 * Given printing options, returns a transducer which annotate the right-side
 *   of groups on their :begin nodes.  This includes the pruning algorithm which
 *   will annotate some :begin nodes as being :too-far to the right without
 *   calculating their exact sizes.
 */
fipp.engine.annotate_begins = (function fipp$engine$annotate_begins(p__8209){
var map__8210 = p__8209;
var map__8210__$1 = cljs.core.__destructure_map(map__8210);
var options = map__8210__$1;
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8210__$1,cljs.core.cst$kw$width);
return (function (rf){
var pos = cljs.core.volatile_BANG_((0));
var bufs = cljs.core.volatile_BANG_(fipp.deque.empty);
return (function() {
var G__8215 = null;
var G__8215__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8215__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__8215__2 = (function (res,p__8211){
var map__8212 = p__8211;
var map__8212__$1 = cljs.core.__destructure_map(map__8212);
var node = map__8212__$1;
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8212__$1,cljs.core.cst$kw$op);
var right = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8212__$1,cljs.core.cst$kw$right);
var buffers = cljs.core.deref(bufs);
if(cljs.core.empty_QMARK_(buffers)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$begin)){
var position_STAR_ = (right + width);
var buffer = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$position,position_STAR_,cljs.core.cst$kw$nodes,fipp.deque.empty], null);
cljs.core.vreset_BANG_(pos,position_STAR_);

cljs.core.vreset_BANG_(bufs,(fipp.deque.create.cljs$core$IFn$_invoke$arity$1 ? fipp.deque.create.cljs$core$IFn$_invoke$arity$1(buffer) : fipp.deque.create.call(null,buffer)));

return res;
} else {
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,node) : rf.call(null,res,node));
}
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$end)){
var buffer = cljs.core.peek(buffers);
var buffers_STAR_ = cljs.core.pop(buffers);
var begin = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin,cljs.core.cst$kw$right,right], null);
var nodes = fipp.deque.conjlr(begin,cljs.core.cst$kw$nodes.cljs$core$IFn$_invoke$arity$1(buffer),node);
if(cljs.core.empty_QMARK_(buffers_STAR_)){
cljs.core.vreset_BANG_(pos,(0));

cljs.core.vreset_BANG_(bufs,fipp.deque.empty);

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,res,nodes);
} else {
if(cljs.core.vector_QMARK_(buffers_STAR_)){
} else {
throw (new Error("Assert failed: (vector? buffers*)"));
}

if(cljs.core.vector_QMARK_(nodes)){
} else {
throw (new Error("Assert failed: (vector? nodes)"));
}

cljs.core.vreset_BANG_(bufs,fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic(buffers_STAR_,cljs.core.update_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nodes], null),fipp.deque.concat,nodes], 0)));

return res;
}
} else {
var buffers_STAR_ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(op,cljs.core.cst$kw$begin))?(function (){var G__8213 = buffers;
var G__8214 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$position,(right + width),cljs.core.cst$kw$nodes,fipp.deque.empty], null);
return (fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2 ? fipp.deque.conjr.cljs$core$IFn$_invoke$arity$2(G__8213,G__8214) : fipp.deque.conjr.call(null,G__8213,G__8214));
})():fipp.engine.update_right.cljs$core$IFn$_invoke$arity$variadic(buffers,cljs.core.update_in,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$nodes], null),fipp.deque.conjr,node], 0)));
var res__$1 = res;
while(true){
if((((right <= cljs.core.deref(pos))) && ((cljs.core.count(buffers_STAR_) <= width)))){
cljs.core.vreset_BANG_(bufs,buffers_STAR_);

return res__$1;
} else {
var buffer = cljs.core.first(buffers_STAR_);
var buffers_STAR__STAR_ = fipp.deque.popl(buffers_STAR_);
var begin = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$op,cljs.core.cst$kw$begin,cljs.core.cst$kw$right,cljs.core.cst$kw$too_DASH_far], null);
var res_STAR_ = (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res__$1,begin) : rf.call(null,res__$1,begin));
var res_STAR___$1 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf,res_STAR_,cljs.core.cst$kw$nodes.cljs$core$IFn$_invoke$arity$1(buffer));
if(cljs.core.empty_QMARK_(buffers_STAR__STAR_)){
cljs.core.vreset_BANG_(pos,(0));

cljs.core.vreset_BANG_(bufs,fipp.deque.empty);

return res_STAR___$1;
} else {
cljs.core.vreset_BANG_(pos,cljs.core.cst$kw$position.cljs$core$IFn$_invoke$arity$1(cljs.core.first(buffers_STAR__STAR_)));

var G__8216 = buffers_STAR__STAR_;
var G__8217 = res_STAR___$1;
buffers_STAR_ = G__8216;
res__$1 = G__8217;
continue;
}
}
break;
}
}
}
});
G__8215 = function(res,p__8211){
switch(arguments.length){
case 0:
return G__8215__0.call(this);
case 1:
return G__8215__1.call(this,res);
case 2:
return G__8215__2.call(this,res,p__8211);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8215.cljs$core$IFn$_invoke$arity$0 = G__8215__0;
G__8215.cljs$core$IFn$_invoke$arity$1 = G__8215__1;
G__8215.cljs$core$IFn$_invoke$arity$2 = G__8215__2;
return G__8215;
})()
});
});
/**
 * Given printing options, returns a transducer which produces the fully
 *   laid-out strings.
 */
fipp.engine.format_nodes = (function fipp$engine$format_nodes(p__8218){
var map__8219 = p__8218;
var map__8219__$1 = cljs.core.__destructure_map(map__8219);
var options = map__8219__$1;
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8219__$1,cljs.core.cst$kw$width);
return (function (rf){
var fits = cljs.core.volatile_BANG_((0));
var length = cljs.core.volatile_BANG_(width);
var tab_stops = cljs.core.volatile_BANG_(cljs.core.list((0)));
var column = cljs.core.volatile_BANG_((0));
return (function() {
var G__8231 = null;
var G__8231__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8231__1 = (function (res){
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(res) : rf.call(null,res));
});
var G__8231__2 = (function (res,p__8220){
var map__8221 = p__8220;
var map__8221__$1 = cljs.core.__destructure_map(map__8221);
var node = map__8221__$1;
var op = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8221__$1,cljs.core.cst$kw$op);
var right = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8221__$1,cljs.core.cst$kw$right);
var indent = cljs.core.peek(cljs.core.deref(tab_stops));
var G__8222 = op;
var G__8222__$1 = (((G__8222 instanceof cljs.core.Keyword))?G__8222.fqn:null);
switch (G__8222__$1) {
case "text":
var text = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
var res_STAR_ = (((cljs.core.deref(column) === (0)))?(function (){
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + indent));

var G__8223 = res;
var G__8224 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indent," "));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8223,G__8224) : rf.call(null,G__8223,G__8224));
})()
:res);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + cljs.core.count(text)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res_STAR_,text) : rf.call(null,res_STAR_,text));

break;
case "escaped":
var text = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
var res_STAR_ = (((cljs.core.deref(column) === (0)))?(function (){
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + indent));

var G__8225 = res;
var G__8226 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indent," "));
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8225,G__8226) : rf.call(null,G__8225,G__8226));
})()
:res);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + (1)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res_STAR_,text) : rf.call(null,res_STAR_,text));

break;
case "pass":
var G__8227 = res;
var G__8228 = cljs.core.cst$kw$text.cljs$core$IFn$_invoke$arity$1(node);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8227,G__8228) : rf.call(null,G__8227,G__8228));

break;
case "line":
if((cljs.core.deref(fits) === (0))){
cljs.core.vreset_BANG_(length,((right + width) - indent));

cljs.core.vreset_BANG_(column,(0));

var G__8229 = res;
var G__8230 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$terminate.cljs$core$IFn$_invoke$arity$1(node)),"\n"].join('');
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8229,G__8230) : rf.call(null,G__8229,G__8230));
} else {
var inline = cljs.core.cst$kw$inline.cljs$core$IFn$_invoke$arity$1(node);
column.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(column.cljs$core$IDeref$_deref$arity$1(null) + cljs.core.count(inline)));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,inline) : rf.call(null,res,inline));
}

break;
case "break":
cljs.core.vreset_BANG_(length,((right + width) - indent));

cljs.core.vreset_BANG_(column,(0));

return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(res,"\n") : rf.call(null,res,"\n"));

break;
case "nest":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tab_stops.cljs$core$IDeref$_deref$arity$1(null),(indent + cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(node))));

return res;

break;
case "align":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(tab_stops.cljs$core$IDeref$_deref$arity$1(null),(cljs.core.deref(column) + cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(node))));

return res;

break;
case "outdent":
tab_stops.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.pop(tab_stops.cljs$core$IDeref$_deref$arity$1(null)));

return res;

break;
case "begin":
cljs.core.vreset_BANG_(fits,(((cljs.core.deref(fits) > (0)))?(cljs.core.deref(fits) + (1)):((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(right,cljs.core.cst$kw$too_DASH_far))?(0):(((right <= cljs.core.deref(length)))?(1):(0)
))));

return res;

break;
case "end":
cljs.core.vreset_BANG_(fits,(function (){var x__4295__auto__ = (0);
var y__4296__auto__ = (cljs.core.deref(fits) - (1));
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
})());

return res;

break;
default:
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected node op",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$node,node], null));

}
});
G__8231 = function(res,p__8220){
switch(arguments.length){
case 0:
return G__8231__0.call(this);
case 1:
return G__8231__1.call(this,res);
case 2:
return G__8231__2.call(this,res,p__8220);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8231.cljs$core$IFn$_invoke$arity$0 = G__8231__0;
G__8231.cljs$core$IFn$_invoke$arity$1 = G__8231__1;
G__8231.cljs$core$IFn$_invoke$arity$2 = G__8231__2;
return G__8231;
})()
});
});
fipp.engine.pprint_document = (function fipp$engine$pprint_document(document,options){
var options_8233__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$width,(70)], null),options], 0));
cljs.core.run_BANG_(cljs.core.print,cljs.core.eduction.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fipp.engine.annotate_rights,fipp.engine.annotate_begins(options_8233__$1),fipp.engine.format_nodes(options_8233__$1),fipp.engine.serialize(document)], 0)));

return cljs.core.println();
});
