// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.crypto.aes');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('alphabase.core');
goog.require('fluree.crypto.util');
goog.require('goog.crypt.Aes');
goog.require('goog.crypt.Cbc');
goog.require('fluree.crypto.pkcs7');
fluree.crypto.aes.encrypt_STAR_ = (function fluree$crypto$aes$encrypt_STAR_(iv,key_ba,ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
var padded = fluree.crypto.pkcs7.encode((16),ba);
return cbc.encrypt(padded,cljs.core.clj__GT_js(iv));
});
/**
 * Encrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out
 *   of key (requires Unlimited Strength crypto to be enabled).
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.encrypt = (function fluree$crypto$aes$encrypt(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44522 = arguments.length;
var i__4819__auto___44523 = (0);
while(true){
if((i__4819__auto___44523 < len__4818__auto___44522)){
args__4824__auto__.push((arguments[i__4819__auto___44523]));

var G__44524 = (i__4819__auto___44523 + (1));
i__4819__auto___44523 = G__44524;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});
goog.exportSymbol('fluree.crypto.aes.encrypt', fluree.crypto.aes.encrypt);

(fluree.crypto.aes.encrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__44516){
var vec__44517 = p__44516;
var map__44520 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44517,(0),null);
var map__44520__$1 = cljs.core.__destructure_map(map__44520);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44520__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44520__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$hex);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var ba = ((typeof x === 'string')?alphabase.core.string__GT_bytes(x):x);
var encrypted = fluree.crypto.aes.encrypt_STAR_(iv,key_ba,ba);
var G__44521 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__44521__$1 = (((G__44521 instanceof cljs.core.Keyword))?G__44521.fqn:null);
switch (G__44521__$1) {
case "none":
return encrypted;

break;
case "hex":
return alphabase.core.bytes__GT_hex(encrypted);

break;
case "base64":
return alphabase.core.bytes__GT_base64(encrypted);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44521__$1)].join('')));

}
}));

(fluree.crypto.aes.encrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.encrypt.cljs$lang$applyTo = (function (seq44513){
var G__44514 = cljs.core.first(seq44513);
var seq44513__$1 = cljs.core.next(seq44513);
var G__44515 = cljs.core.first(seq44513__$1);
var seq44513__$2 = cljs.core.next(seq44513__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44514,G__44515,seq44513__$2);
}));

fluree.crypto.aes.decrypt_STAR_ = (function fluree$crypto$aes$decrypt_STAR_(iv,key_ba,x_ba){
var cipher = (new goog.crypt.Aes(key_ba));
var cbc = (new goog.crypt.Cbc(cipher));
return fluree.crypto.pkcs7.decode((16),cbc.decrypt(x_ba,cljs.core.clj__GT_js(iv)));
});
/**
 * Decrypts with AES/CBC/PKCS{5/7}Padding by hashing a 256 bit key out of key.
 *   You can provide an alternate initial vector of unsigned(!) bytes of size 16 for CBC.
 */
fluree.crypto.aes.decrypt = (function fluree$crypto$aes$decrypt(var_args){
var args__4824__auto__ = [];
var len__4818__auto___44537 = arguments.length;
var i__4819__auto___44538 = (0);
while(true){
if((i__4819__auto___44538 < len__4818__auto___44537)){
args__4824__auto__.push((arguments[i__4819__auto___44538]));

var G__44539 = (i__4819__auto___44538 + (1));
i__4819__auto___44538 = G__44539;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});
goog.exportSymbol('fluree.crypto.aes.decrypt', fluree.crypto.aes.decrypt);

(fluree.crypto.aes.decrypt.cljs$core$IFn$_invoke$arity$variadic = (function (x,key,p__44530){
var vec__44531 = p__44530;
var map__44534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__44531,(0),null);
var map__44534__$1 = cljs.core.__destructure_map(map__44534);
var iv = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44534__$1,cljs.core.cst$kw$iv,new cljs.core.PersistentVector(null, 16, 5, cljs.core.PersistentVector.EMPTY_NODE, [(6),(224),(71),(170),(241),(204),(115),(21),(30),(8),(46),(223),(106),(207),(55),(42)], null));
var input_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44534__$1,cljs.core.cst$kw$input_DASH_format,cljs.core.cst$kw$hex);
var output_format = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__44534__$1,cljs.core.cst$kw$output_DASH_format,cljs.core.cst$kw$string);
var key_ba = ((typeof key === 'string')?fluree.crypto.util.hash_string_key(key,(32)):key);
var x_ba = ((typeof x === 'string')?(function (){var G__44535 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(input_format);
var G__44535__$1 = (((G__44535 instanceof cljs.core.Keyword))?G__44535.fqn:null);
switch (G__44535__$1) {
case "hex":
return alphabase.core.hex__GT_bytes(x);

break;
case "base64":
return alphabase.core.base64__GT_bytes(x);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44535__$1)].join('')));

}
})():x);
var decrypt_ba = fluree.crypto.aes.decrypt_STAR_(iv,key_ba,x_ba);
var G__44536 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(output_format);
var G__44536__$1 = (((G__44536 instanceof cljs.core.Keyword))?G__44536.fqn:null);
switch (G__44536__$1) {
case "none":
return decrypt_ba;

break;
case "hex":
return alphabase.core.bytes__GT_hex(decrypt_ba);

break;
case "string":
return alphabase.core.bytes__GT_string(decrypt_ba);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__44536__$1)].join('')));

}
}));

(fluree.crypto.aes.decrypt.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(fluree.crypto.aes.decrypt.cljs$lang$applyTo = (function (seq44527){
var G__44528 = cljs.core.first(seq44527);
var seq44527__$1 = cljs.core.next(seq44527);
var G__44529 = cljs.core.first(seq44527__$1);
var seq44527__$2 = cljs.core.next(seq44527__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__44528,G__44529,seq44527__$2);
}));

