// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.connection');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.string');
goog.require('cljs.core.async');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.log');
goog.require('fluree.db.dbfunctions.core');
goog.require('cljs.cache');
goog.require('fluree.db.session');
goog.require('fluree.db.util.xhttp');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.async');
goog.require('fluree.db.serde.json');
goog.require('fluree.db.query.http_signatures');
goog.require('fluree.db.conn_events');
fluree.db.connection.server_connections_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
fluree.db.connection.server_regex = /^(?:((?:https?):)\/\/)([^:\/\s#]+)(?::(\d*))?/;
/**
 * Tries all servers in parallel, the first healthy response will be used for the connection
 *   (additional server healthy writes will be no-ops after first).
 */
fluree.db.connection.acquire_healthy_server = (function fluree$db$connection$acquire_healthy_server(conn_id,servers,promise_chan){
var seq__73705_73874 = cljs.core.seq(servers);
var chunk__73706_73875 = null;
var count__73707_73876 = (0);
var i__73708_73877 = (0);
while(true){
if((i__73708_73877 < count__73707_73876)){
var server_73878 = chunk__73706_73875.cljs$core$IIndexed$_nth$arity$2(null,i__73708_73877);
var healthcheck_uri_73879 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73878),"/fdb/health"].join('');
var resp_chan_73880 = fluree.db.util.xhttp.post_json(healthcheck_uri_73879,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16469__auto___73881 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878){
return (function (state_73769){
var state_val_73770 = (state_73769[(1)]);
if((state_val_73770 === (1))){
var state_73769__$1 = state_73769;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73769__$1,(2),resp_chan_73880);
} else {
if((state_val_73770 === (2))){
var inst_73758 = (state_73769[(7)]);
var inst_73758__$1 = (state_73769[(2)]);
var inst_73759 = fluree.db.util.core.exception_QMARK_(inst_73758__$1);
var state_73769__$1 = (function (){var statearr_73771 = state_73769;
(statearr_73771[(7)] = inst_73758__$1);

return statearr_73771;
})();
if(inst_73759){
var statearr_73772_73882 = state_73769__$1;
(statearr_73772_73882[(1)] = (3));

} else {
var statearr_73773_73883 = state_73769__$1;
(statearr_73773_73883[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73770 === (3))){
var inst_73758 = (state_73769[(7)]);
var inst_73761 = cljs.core.ex_message(inst_73758);
var inst_73762 = cljs.core.ex_data(inst_73758);
var inst_73763 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_73761,inst_73762], 0));
var state_73769__$1 = state_73769;
var statearr_73774_73884 = state_73769__$1;
(statearr_73774_73884[(2)] = inst_73763);

(statearr_73774_73884[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73770 === (4))){
var inst_73765 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_73878);
var state_73769__$1 = state_73769;
var statearr_73775_73885 = state_73769__$1;
(statearr_73775_73885[(2)] = inst_73765);

(statearr_73775_73885[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73770 === (5))){
var inst_73767 = (state_73769[(2)]);
var state_73769__$1 = state_73769;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73769__$1,inst_73767);
} else {
return null;
}
}
}
}
}
});})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878))
;
return ((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,switch__16394__auto__,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_73776 = [null,null,null,null,null,null,null,null];
(statearr_73776[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_73776[(1)] = (1));

return statearr_73776;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_73769){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73769);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73777){var ex__16398__auto__ = e73777;
var statearr_73778_73886 = state_73769;
(statearr_73778_73886[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73769[(4)]))){
var statearr_73779_73887 = state_73769;
(statearr_73779_73887[(1)] = cljs.core.first((state_73769[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73888 = state_73769;
state_73769 = G__73888;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_73769){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_73769);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
;})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,switch__16394__auto__,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878))
})();
var state__16471__auto__ = (function (){var statearr_73780 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73780[(6)] = c__16469__auto___73881);

return statearr_73780;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73881,healthcheck_uri_73879,resp_chan_73880,server_73878))
);



var G__73889 = seq__73705_73874;
var G__73890 = chunk__73706_73875;
var G__73891 = count__73707_73876;
var G__73892 = (i__73708_73877 + (1));
seq__73705_73874 = G__73889;
chunk__73706_73875 = G__73890;
count__73707_73876 = G__73891;
i__73708_73877 = G__73892;
continue;
} else {
var temp__5753__auto___73893 = cljs.core.seq(seq__73705_73874);
if(temp__5753__auto___73893){
var seq__73705_73894__$1 = temp__5753__auto___73893;
if(cljs.core.chunked_seq_QMARK_(seq__73705_73894__$1)){
var c__4638__auto___73895 = cljs.core.chunk_first(seq__73705_73894__$1);
var G__73896 = cljs.core.chunk_rest(seq__73705_73894__$1);
var G__73897 = c__4638__auto___73895;
var G__73898 = cljs.core.count(c__4638__auto___73895);
var G__73899 = (0);
seq__73705_73874 = G__73896;
chunk__73706_73875 = G__73897;
count__73707_73876 = G__73898;
i__73708_73877 = G__73899;
continue;
} else {
var server_73900 = cljs.core.first(seq__73705_73894__$1);
var healthcheck_uri_73901 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(server_73900),"/fdb/health"].join('');
var resp_chan_73902 = fluree.db.util.xhttp.post_json(healthcheck_uri_73901,cljs.core.PersistentArrayMap.EMPTY,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$request_DASH_timeout,(5000)], null));
var c__16469__auto___73903 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893){
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = ((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893){
return (function (state_73793){
var state_val_73794 = (state_73793[(1)]);
if((state_val_73794 === (1))){
var state_73793__$1 = state_73793;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73793__$1,(2),resp_chan_73902);
} else {
if((state_val_73794 === (2))){
var inst_73782 = (state_73793[(7)]);
var inst_73782__$1 = (state_73793[(2)]);
var inst_73783 = fluree.db.util.core.exception_QMARK_(inst_73782__$1);
var state_73793__$1 = (function (){var statearr_73795 = state_73793;
(statearr_73795[(7)] = inst_73782__$1);

return statearr_73795;
})();
if(inst_73783){
var statearr_73796_73904 = state_73793__$1;
(statearr_73796_73904[(1)] = (3));

} else {
var statearr_73797_73905 = state_73793__$1;
(statearr_73797_73905[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73794 === (3))){
var inst_73782 = (state_73793[(7)]);
var inst_73785 = cljs.core.ex_message(inst_73782);
var inst_73786 = cljs.core.ex_data(inst_73782);
var inst_73787 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Server contact error: ",inst_73785,inst_73786], 0));
var state_73793__$1 = state_73793;
var statearr_73798_73906 = state_73793__$1;
(statearr_73798_73906[(2)] = inst_73787);

(statearr_73798_73906[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73794 === (4))){
var inst_73789 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,server_73900);
var state_73793__$1 = state_73793;
var statearr_73799_73907 = state_73793__$1;
(statearr_73799_73907[(2)] = inst_73789);

(statearr_73799_73907[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73794 === (5))){
var inst_73791 = (state_73793[(2)]);
var state_73793__$1 = state_73793;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73793__$1,inst_73791);
} else {
return null;
}
}
}
}
}
});})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893))
;
return ((function (seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,switch__16394__auto__,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893){
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_73800 = [null,null,null,null,null,null,null,null];
(statearr_73800[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_73800[(1)] = (1));

return statearr_73800;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_73793){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73793);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73801){var ex__16398__auto__ = e73801;
var statearr_73802_73908 = state_73793;
(statearr_73802_73908[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73793[(4)]))){
var statearr_73803_73909 = state_73793;
(statearr_73803_73909[(1)] = cljs.core.first((state_73793[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73910 = state_73793;
state_73793 = G__73910;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_73793){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_73793);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
;})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,switch__16394__auto__,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893))
})();
var state__16471__auto__ = (function (){var statearr_73804 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73804[(6)] = c__16469__auto___73903);

return statearr_73804;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});})(seq__73705_73874,chunk__73706_73875,count__73707_73876,i__73708_73877,c__16469__auto___73903,healthcheck_uri_73901,resp_chan_73902,server_73900,seq__73705_73894__$1,temp__5753__auto___73893))
);



var G__73911 = cljs.core.next(seq__73705_73894__$1);
var G__73912 = null;
var G__73913 = (0);
var G__73914 = (0);
seq__73705_73874 = G__73911;
chunk__73706_73875 = G__73912;
count__73707_73876 = G__73913;
i__73708_73877 = G__73914;
continue;
}
} else {
}
}
break;
}

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73848){
var state_val_73849 = (state_73848[(1)]);
if((state_val_73849 === (7))){
var inst_73820 = (state_73848[(7)]);
var inst_73827 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73820,cljs.core.cst$kw$default);
var state_73848__$1 = state_73848;
if(inst_73827){
var statearr_73850_73915 = state_73848__$1;
(statearr_73850_73915[(1)] = (9));

} else {
var statearr_73851_73916 = state_73848__$1;
(statearr_73851_73916[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (1))){
var inst_73812 = (state_73848[(8)]);
var inst_73813 = (state_73848[(9)]);
var inst_73812__$1 = promise_chan;
var inst_73813__$1 = cljs.core.async.timeout((60000));
var inst_73814 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73815 = [inst_73812__$1,inst_73813__$1];
var inst_73816 = (new cljs.core.PersistentVector(null,2,(5),inst_73814,inst_73815,null));
var state_73848__$1 = (function (){var statearr_73852 = state_73848;
(statearr_73852[(8)] = inst_73812__$1);

(statearr_73852[(9)] = inst_73813__$1);

return statearr_73852;
})();
return cljs.core.async.ioc_alts_BANG_(state_73848__$1,(2),inst_73816);
} else {
if((state_val_73849 === (4))){
var inst_73820 = (state_73848[(7)]);
var inst_73813 = (state_73848[(9)]);
var inst_73824 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73820,inst_73813);
var state_73848__$1 = state_73848;
if(inst_73824){
var statearr_73853_73917 = state_73848__$1;
(statearr_73853_73917[(1)] = (6));

} else {
var statearr_73854_73918 = state_73848__$1;
(statearr_73854_73918[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (13))){
var state_73848__$1 = state_73848;
var statearr_73855_73919 = state_73848__$1;
(statearr_73855_73919[(2)] = null);

(statearr_73855_73919[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (6))){
var state_73848__$1 = state_73848;
var statearr_73856_73920 = state_73848__$1;
(statearr_73856_73920[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_timeout);

(statearr_73856_73920[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (3))){
var state_73848__$1 = state_73848;
var statearr_73857_73921 = state_73848__$1;
(statearr_73857_73921[(2)] = cljs.core.cst$kw$fluree$db$connection_SLASH_server_DASH_found);

(statearr_73857_73921[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (12))){
var inst_73838 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$server], 0));
var inst_73839 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73840 = [(500),cljs.core.cst$kw$db_SLASH_connection_DASH_error];
var inst_73841 = cljs.core.PersistentHashMap.fromArrays(inst_73839,inst_73840);
var inst_73842 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unable to find healthy server before timeout.",inst_73841);
var inst_73843 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(promise_chan,inst_73842);
var state_73848__$1 = (function (){var statearr_73858 = state_73848;
(statearr_73858[(10)] = inst_73838);

return statearr_73858;
})();
var statearr_73859_73922 = state_73848__$1;
(statearr_73859_73922[(2)] = inst_73843);

(statearr_73859_73922[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (2))){
var inst_73812 = (state_73848[(8)]);
var inst_73820 = (state_73848[(7)]);
var inst_73818 = (state_73848[(2)]);
var inst_73819 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73818,(0),null);
var inst_73820__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_73818,(1),null);
var inst_73821 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73820__$1,inst_73812);
var state_73848__$1 = (function (){var statearr_73860 = state_73848;
(statearr_73860[(11)] = inst_73819);

(statearr_73860[(7)] = inst_73820__$1);

return statearr_73860;
})();
if(inst_73821){
var statearr_73861_73923 = state_73848__$1;
(statearr_73861_73923[(1)] = (3));

} else {
var statearr_73862_73924 = state_73848__$1;
(statearr_73862_73924[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (11))){
var inst_73831 = (state_73848[(2)]);
var state_73848__$1 = state_73848;
var statearr_73863_73925 = state_73848__$1;
(statearr_73863_73925[(2)] = inst_73831);

(statearr_73863_73925[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (9))){
var inst_73819 = (state_73848[(11)]);
var state_73848__$1 = state_73848;
var statearr_73864_73926 = state_73848__$1;
(statearr_73864_73926[(2)] = inst_73819);

(statearr_73864_73926[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (5))){
var inst_73835 = (state_73848[(2)]);
var inst_73836 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$fluree$db$connection_SLASH_timeout,inst_73835);
var state_73848__$1 = state_73848;
if(inst_73836){
var statearr_73865_73927 = state_73848__$1;
(statearr_73865_73927[(1)] = (12));

} else {
var statearr_73866_73928 = state_73848__$1;
(statearr_73866_73928[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (14))){
var inst_73846 = (state_73848[(2)]);
var state_73848__$1 = state_73848;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73848__$1,inst_73846);
} else {
if((state_val_73849 === (10))){
var state_73848__$1 = state_73848;
var statearr_73867_73929 = state_73848__$1;
(statearr_73867_73929[(2)] = null);

(statearr_73867_73929[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73849 === (8))){
var inst_73833 = (state_73848[(2)]);
var state_73848__$1 = state_73848;
var statearr_73868_73930 = state_73848__$1;
(statearr_73868_73930[(2)] = inst_73833);

(statearr_73868_73930[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = null;
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0 = (function (){
var statearr_73869 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73869[(0)] = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__);

(statearr_73869[(1)] = (1));

return statearr_73869;
});
var fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1 = (function (state_73848){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73848);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73870){var ex__16398__auto__ = e73870;
var statearr_73871_73931 = state_73848;
(statearr_73871_73931[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73848[(4)]))){
var statearr_73872_73932 = state_73848;
(statearr_73872_73932[(1)] = cljs.core.first((state_73848[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73933 = state_73848;
state_73848 = G__73933;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__ = function(state_73848){
switch(arguments.length){
case 0:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1.call(this,state_73848);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____0;
fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto____1;
return fluree$db$connection$acquire_healthy_server_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73873 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73873[(6)] = c__16469__auto__);

return statearr_73873;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a core async channel that will contain first healthy as it appears.
 * 
 *   Use with a timeout to consume, as no healthy servers may be avail.
 */
fluree.db.connection.get_healthy_server = (function fluree$db$connection$get_healthy_server(conn_id,servers){
var lock_id = fluree.db.util.core.random_uuid();
var new_state = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server], null),(function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$chan,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
}));
var have_lock_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(lock_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$lock_DASH_id], null)));
var promise_chan = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(new_state,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(have_lock_QMARK_){
fluree.db.connection.acquire_healthy_server(conn_id,servers,promise_chan);
} else {
}

return promise_chan;
});
fluree.db.connection.establish_socket = (function fluree$db$connection$establish_socket(conn_id,sub_chan,pub_chan,servers){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73977){
var state_val_73978 = (state_73977[(1)]);
if((state_val_73978 === (7))){
var state_73977__$1 = state_73977;
var statearr_73979_74005 = state_73977__$1;
(statearr_73979_74005[(2)] = null);

(statearr_73979_74005[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (1))){
var state_73977__$1 = state_73977;
var statearr_73980_74006 = state_73977__$1;
(statearr_73980_74006[(2)] = null);

(statearr_73980_74006[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (4))){
var inst_73934 = (state_73977[(2)]);
var state_73977__$1 = state_73977;
var statearr_73981_74007 = state_73977__$1;
(statearr_73981_74007[(2)] = inst_73934);

(statearr_73981_74007[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (6))){
var inst_73956 = fluree.db.connection.get_healthy_server(conn_id,servers);
var state_73977__$1 = state_73977;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73977__$1,(9),inst_73956);
} else {
if((state_val_73978 === (3))){
var inst_73975 = (state_73977[(2)]);
var state_73977__$1 = state_73977;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73977__$1,inst_73975);
} else {
if((state_val_73978 === (12))){
var inst_73969 = (state_73977[(2)]);
var state_73977__$1 = state_73977;
var statearr_73982_74008 = state_73977__$1;
(statearr_73982_74008[(2)] = inst_73969);

(statearr_73982_74008[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (2))){
var inst_73950 = (state_73977[(7)]);
var inst_73945 = (state_73977[(8)]);
var inst_73940 = (state_73977[(9)]);
var _ = (function (){var statearr_73983 = state_73977;
(statearr_73983[(4)] = cljs.core.cons((5),(state_73977[(4)])));

return statearr_73983;
})();
var inst_73940__$1 = fluree.db.util.core.random_uuid();
var inst_73941 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73942 = [conn_id,cljs.core.cst$kw$ws];
var inst_73943 = (new cljs.core.PersistentVector(null,2,(5),inst_73941,inst_73942,null));
var inst_73944 = (function (){var lock_id = inst_73940__$1;
return (function (x){
if(cljs.core.truth_(x)){
return x;
} else {
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$lock_DASH_id,lock_id,cljs.core.cst$kw$socket,cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0()], null);
}
});
})();
var inst_73945__$1 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,inst_73943,inst_73944);
var inst_73946 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73947 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$lock_DASH_id];
var inst_73948 = (new cljs.core.PersistentVector(null,3,(5),inst_73946,inst_73947,null));
var inst_73949 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73945__$1,inst_73948);
var inst_73950__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_73940__$1,inst_73949);
var inst_73951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_73952 = [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_73953 = (new cljs.core.PersistentVector(null,3,(5),inst_73951,inst_73952,null));
var inst_73954 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_73945__$1,inst_73953);
var state_73977__$1 = (function (){var statearr_73984 = state_73977;
(statearr_73984[(7)] = inst_73950__$1);

(statearr_73984[(8)] = inst_73945__$1);

(statearr_73984[(9)] = inst_73940__$1);

(statearr_73984[(10)] = inst_73954);

return statearr_73984;
})();
if(inst_73950__$1){
var statearr_73985_74009 = state_73977__$1;
(statearr_73985_74009[(1)] = (6));

} else {
var statearr_73986_74010 = state_73977__$1;
(statearr_73986_74010[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (11))){
var inst_73960 = (state_73977[(11)]);
var inst_73954 = (state_73977[(10)]);
var inst_73961 = (state_73977[(12)]);
var inst_73967 = fluree.db.util.xhttp.try_socket(inst_73960,sub_chan,pub_chan,inst_73954,(60000),inst_73961);
var state_73977__$1 = state_73977;
var statearr_73988_74011 = state_73977__$1;
(statearr_73988_74011[(2)] = inst_73967);

(statearr_73988_74011[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (9))){
var inst_73950 = (state_73977[(7)]);
var inst_73945 = (state_73977[(8)]);
var inst_73940 = (state_73977[(9)]);
var inst_73960 = (state_73977[(11)]);
var inst_73954 = (state_73977[(10)]);
var inst_73958 = (state_73977[(13)]);
var inst_73958__$1 = (state_73977[(2)]);
var inst_73959 = clojure.string.replace(inst_73958__$1,"http","ws");
var inst_73960__$1 = [inst_73959,"/fdb/ws"].join('');
var inst_73961 = (function (){var lock_id = inst_73940;
var state = inst_73945;
var have_lock_QMARK_ = inst_73950;
var resp_chan = inst_73954;
var healthy_server = inst_73958__$1;
var ws_url = inst_73960__$1;
var timeout = (60000);
return (function (){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

return fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);
});
})();
var inst_73962 = fluree.db.util.core.exception_QMARK_(inst_73958__$1);
var state_73977__$1 = (function (){var statearr_73989 = state_73977;
(statearr_73989[(11)] = inst_73960__$1);

(statearr_73989[(12)] = inst_73961);

(statearr_73989[(13)] = inst_73958__$1);

return statearr_73989;
})();
if(inst_73962){
var statearr_73990_74012 = state_73977__$1;
(statearr_73990_74012[(1)] = (10));

} else {
var statearr_73991_74013 = state_73977__$1;
(statearr_73991_74013[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (5))){
var _ = (function (){var statearr_73992 = state_73977;
(statearr_73992[(4)] = cljs.core.rest((state_73977[(4)])));

return statearr_73992;
})();
var state_73977__$1 = state_73977;
var ex73987 = (state_73977__$1[(2)]);
var statearr_73993_74014 = state_73977__$1;
(statearr_73993_74014[(5)] = ex73987);


if((ex73987 instanceof Error)){
var statearr_73994_74015 = state_73977__$1;
(statearr_73994_74015[(1)] = (4));

(statearr_73994_74015[(5)] = null);

} else {
throw ex73987;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (10))){
var inst_73954 = (state_73977[(10)]);
var inst_73958 = (state_73977[(13)]);
var inst_73964 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(fluree.db.connection.server_connections_atom,cljs.core.update,conn_id,cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ws], 0));
var inst_73965 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_73954,inst_73958);
var state_73977__$1 = (function (){var statearr_73995 = state_73977;
(statearr_73995[(14)] = inst_73964);

return statearr_73995;
})();
var statearr_73996_74016 = state_73977__$1;
(statearr_73996_74016[(2)] = inst_73965);

(statearr_73996_74016[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73978 === (8))){
var inst_73954 = (state_73977[(10)]);
var inst_73972 = (state_73977[(2)]);
var _ = (function (){var statearr_73997 = state_73977;
(statearr_73997[(4)] = cljs.core.rest((state_73977[(4)])));

return statearr_73997;
})();
var state_73977__$1 = (function (){var statearr_73998 = state_73977;
(statearr_73998[(15)] = inst_73972);

return statearr_73998;
})();
var statearr_73999_74017 = state_73977__$1;
(statearr_73999_74017[(2)] = inst_73954);

(statearr_73999_74017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$establish_socket_$_state_machine__16395__auto__ = null;
var fluree$db$connection$establish_socket_$_state_machine__16395__auto____0 = (function (){
var statearr_74000 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74000[(0)] = fluree$db$connection$establish_socket_$_state_machine__16395__auto__);

(statearr_74000[(1)] = (1));

return statearr_74000;
});
var fluree$db$connection$establish_socket_$_state_machine__16395__auto____1 = (function (state_73977){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73977);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74001){var ex__16398__auto__ = e74001;
var statearr_74002_74018 = state_73977;
(statearr_74002_74018[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73977[(4)]))){
var statearr_74003_74019 = state_73977;
(statearr_74003_74019[(1)] = cljs.core.first((state_73977[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74020 = state_73977;
state_73977 = G__74020;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$establish_socket_$_state_machine__16395__auto__ = function(state_73977){
switch(arguments.length){
case 0:
return fluree$db$connection$establish_socket_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$establish_socket_$_state_machine__16395__auto____1.call(this,state_73977);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$establish_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$establish_socket_$_state_machine__16395__auto____0;
fluree$db$connection$establish_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$establish_socket_$_state_machine__16395__auto____1;
return fluree$db$connection$establish_socket_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74004 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74004[(6)] = c__16469__auto__);

return statearr_74004;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.connection.Connection = (function (id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,__meta,__extmap,__hash){
this.id = id;
this.servers = servers;
this.state = state;
this.req_chan = req_chan;
this.sub_chan = sub_chan;
this.pub_chan = pub_chan;
this.storage_read = storage_read;
this.storage_write = storage_write;
this.object_cache = object_cache;
this.parallelism = parallelism;
this.serializer = serializer;
this.default_network = default_network;
this.transactor_QMARK_ = transactor_QMARK_;
this.publish = publish;
this.transact_handler = transact_handler;
this.tx_private_key = tx_private_key;
this.tx_key_id = tx_key_id;
this.meta = meta;
this.add_listener = add_listener;
this.remove_listener = remove_listener;
this.close = close;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.connection.Connection.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k74022,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__74026 = k74022;
var G__74026__$1 = (((G__74026 instanceof cljs.core.Keyword))?G__74026.fqn:null);
switch (G__74026__$1) {
case "id":
return self__.id;

break;
case "servers":
return self__.servers;

break;
case "state":
return self__.state;

break;
case "req-chan":
return self__.req_chan;

break;
case "sub-chan":
return self__.sub_chan;

break;
case "pub-chan":
return self__.pub_chan;

break;
case "storage-read":
return self__.storage_read;

break;
case "storage-write":
return self__.storage_write;

break;
case "object-cache":
return self__.object_cache;

break;
case "parallelism":
return self__.parallelism;

break;
case "serializer":
return self__.serializer;

break;
case "default-network":
return self__.default_network;

break;
case "transactor?":
return self__.transactor_QMARK_;

break;
case "publish":
return self__.publish;

break;
case "transact-handler":
return self__.transact_handler;

break;
case "tx-private-key":
return self__.tx_private_key;

break;
case "tx-key-id":
return self__.tx_key_id;

break;
case "meta":
return self__.meta;

break;
case "add-listener":
return self__.add_listener;

break;
case "remove-listener":
return self__.remove_listener;

break;
case "close":
return self__.close;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k74022,else__4464__auto__);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__74027){
var vec__74028 = p__74027;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74028,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74028,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.connection.Connection.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.connection.Connection{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$servers,self__.servers],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$state,self__.state],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$req_DASH_chan,self__.req_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_read,self__.storage_read],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$storage_DASH_write,self__.storage_write],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$object_DASH_cache,self__.object_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$parallelism,self__.parallelism],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$serializer,self__.serializer],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$default_DASH_network,self__.default_network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$publish,self__.publish],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$meta,self__.meta],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$add_DASH_listener,self__.add_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$close,self__.close],null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__74021){
var self__ = this;
var G__74021__$1 = this;
return (new cljs.core.RecordIter((0),G__74021__$1,21,new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (21 + cljs.core.count(self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__74031 = (function (coll__4458__auto__){
return (1865480964 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__74031(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this74023,other74024){
var self__ = this;
var this74023__$1 = this;
return (((!((other74024 == null)))) && ((((this74023__$1.constructor === other74024.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.id,other74024.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.servers,other74024.servers)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.state,other74024.state)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.req_chan,other74024.req_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.sub_chan,other74024.sub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.pub_chan,other74024.pub_chan)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.storage_read,other74024.storage_read)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.storage_write,other74024.storage_write)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.object_cache,other74024.object_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.parallelism,other74024.parallelism)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.serializer,other74024.serializer)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.default_network,other74024.default_network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.transactor_QMARK_,other74024.transactor_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.publish,other74024.publish)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.transact_handler,other74024.transact_handler)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.tx_private_key,other74024.tx_private_key)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.tx_key_id,other74024.tx_key_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.meta,other74024.meta)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.add_listener,other74024.add_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.remove_listener,other74024.remove_listener)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.close,other74024.close)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this74023__$1.__extmap,other74024.__extmap)))))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 21, [cljs.core.cst$kw$object_DASH_cache,null,cljs.core.cst$kw$default_DASH_network,null,cljs.core.cst$kw$parallelism,null,cljs.core.cst$kw$transact_DASH_handler,null,cljs.core.cst$kw$add_DASH_listener,null,cljs.core.cst$kw$meta,null,cljs.core.cst$kw$tx_DASH_private_DASH_key,null,cljs.core.cst$kw$remove_DASH_listener,null,cljs.core.cst$kw$transactor_QMARK_,null,cljs.core.cst$kw$storage_DASH_read,null,cljs.core.cst$kw$serializer,null,cljs.core.cst$kw$state,null,cljs.core.cst$kw$close,null,cljs.core.cst$kw$tx_DASH_key_DASH_id,null,cljs.core.cst$kw$storage_DASH_write,null,cljs.core.cst$kw$req_DASH_chan,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$servers,null,cljs.core.cst$kw$pub_DASH_chan,null,cljs.core.cst$kw$sub_DASH_chan,null,cljs.core.cst$kw$publish,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k74022){
var self__ = this;
var this__4468__auto____$1 = this;
var G__74032 = k74022;
var G__74032__$1 = (((G__74032 instanceof cljs.core.Keyword))?G__74032.fqn:null);
switch (G__74032__$1) {
case "id":
case "servers":
case "state":
case "req-chan":
case "sub-chan":
case "pub-chan":
case "storage-read":
case "storage-write":
case "object-cache":
case "parallelism":
case "serializer":
case "default-network":
case "transactor?":
case "publish":
case "transact-handler":
case "tx-private-key":
case "tx-key-id":
case "meta":
case "add-listener":
case "remove-listener":
case "close":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k74022);

}
}));

(fluree.db.connection.Connection.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__74021){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__74033 = cljs.core.keyword_identical_QMARK_;
var expr__74034 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__74036 = cljs.core.cst$kw$id;
var G__74037 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74036,G__74037) : pred__74033.call(null,G__74036,G__74037));
})())){
return (new fluree.db.connection.Connection(G__74021,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74038 = cljs.core.cst$kw$servers;
var G__74039 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74038,G__74039) : pred__74033.call(null,G__74038,G__74039));
})())){
return (new fluree.db.connection.Connection(self__.id,G__74021,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74040 = cljs.core.cst$kw$state;
var G__74041 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74040,G__74041) : pred__74033.call(null,G__74040,G__74041));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,G__74021,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74042 = cljs.core.cst$kw$req_DASH_chan;
var G__74043 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74042,G__74043) : pred__74033.call(null,G__74042,G__74043));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,G__74021,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74044 = cljs.core.cst$kw$sub_DASH_chan;
var G__74045 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74044,G__74045) : pred__74033.call(null,G__74044,G__74045));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,G__74021,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74046 = cljs.core.cst$kw$pub_DASH_chan;
var G__74047 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74046,G__74047) : pred__74033.call(null,G__74046,G__74047));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,G__74021,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74048 = cljs.core.cst$kw$storage_DASH_read;
var G__74049 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74048,G__74049) : pred__74033.call(null,G__74048,G__74049));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,G__74021,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74050 = cljs.core.cst$kw$storage_DASH_write;
var G__74051 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74050,G__74051) : pred__74033.call(null,G__74050,G__74051));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,G__74021,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74052 = cljs.core.cst$kw$object_DASH_cache;
var G__74053 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74052,G__74053) : pred__74033.call(null,G__74052,G__74053));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,G__74021,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74054 = cljs.core.cst$kw$parallelism;
var G__74055 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74054,G__74055) : pred__74033.call(null,G__74054,G__74055));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,G__74021,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74056 = cljs.core.cst$kw$serializer;
var G__74057 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74056,G__74057) : pred__74033.call(null,G__74056,G__74057));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,G__74021,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74058 = cljs.core.cst$kw$default_DASH_network;
var G__74059 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74058,G__74059) : pred__74033.call(null,G__74058,G__74059));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,G__74021,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74060 = cljs.core.cst$kw$transactor_QMARK_;
var G__74061 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74060,G__74061) : pred__74033.call(null,G__74060,G__74061));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,G__74021,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74062 = cljs.core.cst$kw$publish;
var G__74063 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74062,G__74063) : pred__74033.call(null,G__74062,G__74063));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,G__74021,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74064 = cljs.core.cst$kw$transact_DASH_handler;
var G__74065 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74064,G__74065) : pred__74033.call(null,G__74064,G__74065));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,G__74021,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74066 = cljs.core.cst$kw$tx_DASH_private_DASH_key;
var G__74067 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74066,G__74067) : pred__74033.call(null,G__74066,G__74067));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,G__74021,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74068 = cljs.core.cst$kw$tx_DASH_key_DASH_id;
var G__74069 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74068,G__74069) : pred__74033.call(null,G__74068,G__74069));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,G__74021,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74070 = cljs.core.cst$kw$meta;
var G__74071 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74070,G__74071) : pred__74033.call(null,G__74070,G__74071));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,G__74021,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74072 = cljs.core.cst$kw$add_DASH_listener;
var G__74073 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74072,G__74073) : pred__74033.call(null,G__74072,G__74073));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,G__74021,self__.remove_listener,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74074 = cljs.core.cst$kw$remove_DASH_listener;
var G__74075 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74074,G__74075) : pred__74033.call(null,G__74074,G__74075));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,G__74021,self__.close,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__74076 = cljs.core.cst$kw$close;
var G__74077 = expr__74034;
return (pred__74033.cljs$core$IFn$_invoke$arity$2 ? pred__74033.cljs$core$IFn$_invoke$arity$2(G__74076,G__74077) : pred__74033.call(null,G__74076,G__74077));
})())){
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,G__74021,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__74021),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.connection.Connection.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$servers,self__.servers,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$state,self__.state,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$req_DASH_chan,self__.req_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$sub_DASH_chan,self__.sub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$pub_DASH_chan,self__.pub_chan,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_read,self__.storage_read,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$storage_DASH_write,self__.storage_write,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$object_DASH_cache,self__.object_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$parallelism,self__.parallelism,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$serializer,self__.serializer,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$default_DASH_network,self__.default_network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transactor_QMARK_,self__.transactor_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$publish,self__.publish,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$transact_DASH_handler,self__.transact_handler,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_private_DASH_key,self__.tx_private_key,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tx_DASH_key_DASH_id,self__.tx_key_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$meta,self__.meta,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$add_DASH_listener,self__.add_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$remove_DASH_listener,self__.remove_listener,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$close,self__.close,null))], null),self__.__extmap));
}));

(fluree.db.connection.Connection.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__74021){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.connection.Connection(self__.id,self__.servers,self__.state,self__.req_chan,self__.sub_chan,self__.pub_chan,self__.storage_read,self__.storage_write,self__.object_cache,self__.parallelism,self__.serializer,self__.default_network,self__.transactor_QMARK_,self__.publish,self__.transact_handler,self__.tx_private_key,self__.tx_key_id,self__.meta,self__.add_listener,self__.remove_listener,self__.close,G__74021,self__.__extmap,self__.__hash));
}));

(fluree.db.connection.Connection.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.connection.Connection.getBasis = (function (){
return new cljs.core.PersistentVector(null, 21, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$id,cljs.core.cst$sym$servers,cljs.core.cst$sym$state,cljs.core.cst$sym$req_DASH_chan,cljs.core.cst$sym$sub_DASH_chan,cljs.core.cst$sym$pub_DASH_chan,cljs.core.cst$sym$storage_DASH_read,cljs.core.cst$sym$storage_DASH_write,cljs.core.cst$sym$object_DASH_cache,cljs.core.cst$sym$parallelism,cljs.core.cst$sym$serializer,cljs.core.cst$sym$default_DASH_network,cljs.core.cst$sym$transactor_QMARK_,cljs.core.cst$sym$publish,cljs.core.cst$sym$transact_DASH_handler,cljs.core.cst$sym$tx_DASH_private_DASH_key,cljs.core.cst$sym$tx_DASH_key_DASH_id,cljs.core.cst$sym$meta,cljs.core.cst$sym$add_DASH_listener,cljs.core.cst$sym$remove_DASH_listener,cljs.core.cst$sym$close], null);
}));

(fluree.db.connection.Connection.cljs$lang$type = true);

(fluree.db.connection.Connection.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.connection/Connection",null,(1),null));
}));

(fluree.db.connection.Connection.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.connection/Connection");
}));

/**
 * Positional factory function for fluree.db.connection/Connection.
 */
fluree.db.connection.__GT_Connection = (function fluree$db$connection$__GT_Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close){
return (new fluree.db.connection.Connection(id,servers,state,req_chan,sub_chan,pub_chan,storage_read,storage_write,object_cache,parallelism,serializer,default_network,transactor_QMARK_,publish,transact_handler,tx_private_key,tx_key_id,meta,add_listener,remove_listener,close,null,null,null));
});

/**
 * Factory function for fluree.db.connection/Connection, taking a map of keywords to field values.
 */
fluree.db.connection.map__GT_Connection = (function fluree$db$connection$map__GT_Connection(G__74025){
var extmap__4501__auto__ = (function (){var G__74078 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__74025,cljs.core.cst$kw$id,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$servers,cljs.core.cst$kw$state,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$serializer,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$publish,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$meta,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$close], 0));
if(cljs.core.record_QMARK_(G__74025)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__74078);
} else {
return G__74078;
}
})();
return (new fluree.db.connection.Connection(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$default_DASH_network.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$transact_DASH_handler.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$tx_DASH_private_DASH_key.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$tx_DASH_key_DASH_id.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$add_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$remove_DASH_listener.cljs$core$IFn$_invoke$arity$1(G__74025),cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(G__74025),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Split servers in a string into a vector.
 * 
 *   Randomizies order, ensures uniqueness.
 */
fluree.db.connection.normalize_servers = (function fluree$db$connection$normalize_servers(servers,transactor_QMARK_){
var servers_STAR_ = ((typeof servers === 'string')?clojure.string.split.cljs$core$IFn$_invoke$arity$2(servers,/,/):servers);
if(((cljs.core.empty_QMARK_(servers)) && (cljs.core.not(transactor_QMARK_)))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("At least one server must be supplied for connection.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.truth_(cljs.core.not_empty(servers_STAR_))){
var G__74084 = servers_STAR_;
var vec__74085 = G__74084;
var seq__74086 = cljs.core.seq(vec__74085);
var first__74087 = cljs.core.first(seq__74086);
var seq__74086__$1 = cljs.core.next(seq__74086);
var server = first__74087;
var r = seq__74086__$1;
var https_QMARK_ = null;
var result = cljs.core.PersistentHashSet.EMPTY;
var G__74084__$1 = G__74084;
var https_QMARK___$1 = https_QMARK_;
var result__$1 = result;
while(true){
var vec__74091 = G__74084__$1;
var seq__74092 = cljs.core.seq(vec__74091);
var first__74093 = cljs.core.first(seq__74092);
var seq__74092__$1 = cljs.core.next(seq__74092);
var server__$1 = first__74093;
var r__$1 = seq__74092__$1;
var https_QMARK___$2 = https_QMARK___$1;
var result__$2 = result__$1;
if(typeof server__$1 === 'string'){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid server provided for connection, must be a string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([server__$1], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

var server__$2 = clojure.string.replace(server__$1,/.+@/,"");
var server_STAR_ = (cljs.core.truth_(cljs.core.re_matches(/^https?:\/\/.+/,server__$2))?server__$2:((clojure.string.includes_QMARK_(server__$2,"//"))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Only http:// and https:// protocols currently supported for connection servers. Provided:",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null))})():["http://",server__$2].join('')
));
var server_STAR___$1 = (cljs.core.truth_(cljs.core.re_matches(/.+:[0-9]+/,server_STAR_))?server_STAR_:[server_STAR_,":8090"].join(''));
var is_https_QMARK_ = clojure.string.starts_with_QMARK_(server__$2,"https://");
var result_STAR_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result__$2,server_STAR___$1);
if(cljs.core.truth_(cljs.core.re_matches(fluree.db.connection.server_regex,server_STAR___$1))){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid connection server, provide url and port only. Optionally specify http:// or https://. Provided: ",server__$2].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
}

if(cljs.core.truth_((function (){var and__4210__auto__ = https_QMARK___$2;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(is_https_QMARK_,https_QMARK___$2);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection servers must all be http or https, not a mix.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_connection], null));
} else {
}

if(cljs.core.empty_QMARK_(r__$1)){
return cljs.core.shuffle(result_STAR_);
} else {
var G__74094 = r__$1;
var G__74095 = is_https_QMARK_;
var G__74096 = result_STAR_;
G__74084__$1 = G__74094;
https_QMARK___$1 = G__74095;
result__$1 = G__74096;
continue;
}
break;
}
} else {
return null;
}
});
/**
 * Returns true if connection has been closed.
 */
fluree.db.connection.closed_QMARK_ = (function fluree$db$connection$closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Closes websocket on connection if exists.
 */
fluree.db.connection.close_websocket = (function fluree$db$connection$close_websocket(conn_id){
var existing_socket = (function (){var G__74097 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.server_connections_atom,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket], null));
if((G__74097 == null)){
return null;
} else {
return cljs.core.async.poll_BANG_(G__74097);
}
})();
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(fluree.db.connection.server_connections_atom,cljs.core.dissoc,conn_id);

if(cljs.core.truth_(existing_socket)){
return fluree.db.util.xhttp.close_websocket(existing_socket);
} else {
return false;
}
});
/**
 * Gets websocket from connection, or establishes one if not already done.
 * 
 *   Returns a core async promise channel. Check for exceptions.
 */
fluree.db.connection.get_socket = (function fluree$db$connection$get_socket(conn){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74126){
var state_val_74127 = (state_74126[(1)]);
if((state_val_74127 === (7))){
var inst_74112 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74113 = cljs.core.cst$kw$sub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74114 = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74115 = cljs.core.cst$kw$servers.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74116 = fluree.db.connection.establish_socket(inst_74112,inst_74113,inst_74114,inst_74115);
var state_74126__$1 = state_74126;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74126__$1,(9),inst_74116);
} else {
if((state_val_74127 === (1))){
var state_74126__$1 = state_74126;
var statearr_74128_74147 = state_74126__$1;
(statearr_74128_74147[(2)] = null);

(statearr_74128_74147[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (4))){
var inst_74098 = (state_74126[(2)]);
var state_74126__$1 = state_74126;
var statearr_74129_74148 = state_74126__$1;
(statearr_74129_74148[(2)] = inst_74098);

(statearr_74129_74148[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (6))){
var inst_74109 = (state_74126[(7)]);
var state_74126__$1 = state_74126;
var statearr_74130_74149 = state_74126__$1;
(statearr_74130_74149[(2)] = inst_74109);

(statearr_74130_74149[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (3))){
var inst_74124 = (state_74126[(2)]);
var state_74126__$1 = state_74126;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74126__$1,inst_74124);
} else {
if((state_val_74127 === (2))){
var inst_74109 = (state_74126[(7)]);
var _ = (function (){var statearr_74132 = state_74126;
(statearr_74132[(4)] = cljs.core.cons((5),(state_74126[(4)])));

return statearr_74132;
})();
var inst_74104 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74106 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74107 = [inst_74106,cljs.core.cst$kw$ws,cljs.core.cst$kw$socket];
var inst_74108 = (new cljs.core.PersistentVector(null,3,(5),inst_74105,inst_74107,null));
var inst_74109__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74104,inst_74108);
var state_74126__$1 = (function (){var statearr_74133 = state_74126;
(statearr_74133[(7)] = inst_74109__$1);

return statearr_74133;
})();
if(cljs.core.truth_(inst_74109__$1)){
var statearr_74134_74150 = state_74126__$1;
(statearr_74134_74150[(1)] = (6));

} else {
var statearr_74135_74151 = state_74126__$1;
(statearr_74135_74151[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (9))){
var inst_74118 = (state_74126[(2)]);
var inst_74119 = fluree.db.util.async.throw_err(inst_74118);
var state_74126__$1 = state_74126;
var statearr_74136_74152 = state_74126__$1;
(statearr_74136_74152[(2)] = inst_74119);

(statearr_74136_74152[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (5))){
var _ = (function (){var statearr_74137 = state_74126;
(statearr_74137[(4)] = cljs.core.rest((state_74126[(4)])));

return statearr_74137;
})();
var state_74126__$1 = state_74126;
var ex74131 = (state_74126__$1[(2)]);
var statearr_74138_74153 = state_74126__$1;
(statearr_74138_74153[(5)] = ex74131);


if((ex74131 instanceof Error)){
var statearr_74139_74154 = state_74126__$1;
(statearr_74139_74154[(1)] = (4));

(statearr_74139_74154[(5)] = null);

} else {
throw ex74131;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74127 === (8))){
var inst_74121 = (state_74126[(2)]);
var _ = (function (){var statearr_74140 = state_74126;
(statearr_74140[(4)] = cljs.core.rest((state_74126[(4)])));

return statearr_74140;
})();
var state_74126__$1 = state_74126;
var statearr_74141_74155 = state_74126__$1;
(statearr_74141_74155[(2)] = inst_74121);

(statearr_74141_74155[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$get_socket_$_state_machine__16395__auto__ = null;
var fluree$db$connection$get_socket_$_state_machine__16395__auto____0 = (function (){
var statearr_74142 = [null,null,null,null,null,null,null,null];
(statearr_74142[(0)] = fluree$db$connection$get_socket_$_state_machine__16395__auto__);

(statearr_74142[(1)] = (1));

return statearr_74142;
});
var fluree$db$connection$get_socket_$_state_machine__16395__auto____1 = (function (state_74126){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74126);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74143){var ex__16398__auto__ = e74143;
var statearr_74144_74156 = state_74126;
(statearr_74144_74156[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74126[(4)]))){
var statearr_74145_74157 = state_74126;
(statearr_74145_74157[(1)] = cljs.core.first((state_74126[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74158 = state_74126;
state_74126 = G__74158;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$get_socket_$_state_machine__16395__auto__ = function(state_74126){
switch(arguments.length){
case 0:
return fluree$db$connection$get_socket_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$get_socket_$_state_machine__16395__auto____1.call(this,state_74126);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$get_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$get_socket_$_state_machine__16395__auto____0;
fluree$db$connection$get_socket_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$get_socket_$_state_machine__16395__auto____1;
return fluree$db$connection$get_socket_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74146 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74146[(6)] = c__16469__auto__);

return statearr_74146;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * returns promise channel, check for errors
 */
fluree.db.connection.get_server = (function fluree$db$connection$get_server(conn_id,servers){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(fluree.db.connection.server_connections_atom),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$server,cljs.core.cst$kw$chan], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.get_healthy_server(conn_id,servers);
}
});
/**
 * Publishes message to the websocket associated with the connection.
 */
fluree.db.connection.default_publish_fn = (function fluree$db$connection$default_publish_fn(conn,message){
var pub_chan = cljs.core.cst$kw$pub_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var resp_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var msg = (function (){try{return fluree.db.util.json.stringify(message);
}catch (e74159){var e = e74159;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unable to publish message on websocket. Error encoding JSON message: ",message], 0));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_chan,cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Error encoding JSON message: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(message)].join(''),cljs.core.PersistentArrayMap.EMPTY));

return null;
}})();
if(cljs.core.truth_(msg)){
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pub_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [msg,resp_chan], null));
} else {
}

return resp_chan;
});
/**
 * Shuffles outgoing messages to the web socket in order.
 */
fluree.db.connection.msg_producer = (function fluree$db$connection$msg_producer(conn){
var state = cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn);
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var publish_fn = (function (){var or__4212__auto__ = cljs.core.cst$kw$publish.cljs$core$IFn$_invoke$arity$1(conn);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_publish_fn;
}
})();
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74286){
var state_val_74287 = (state_74286[(1)]);
if((state_val_74287 === (7))){
var inst_74282 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
var statearr_74289_74359 = state_74286__$1;
(statearr_74289_74359[(2)] = inst_74282);

(statearr_74289_74359[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (20))){
var _ = (function (){var statearr_74290 = state_74286;
(statearr_74290[(4)] = cljs.core.rest((state_74286[(4)])));

return statearr_74290;
})();
var state_74286__$1 = state_74286;
var ex74288 = (state_74286__$1[(2)]);
var statearr_74291_74360 = state_74286__$1;
(statearr_74291_74360[(5)] = ex74288);


var statearr_74292_74361 = state_74286__$1;
(statearr_74292_74361[(1)] = (10));

(statearr_74292_74361[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (27))){
var inst_74274 = (state_74286[(2)]);
var _ = (function (){var statearr_74293 = state_74286;
(statearr_74293[(4)] = cljs.core.rest((state_74286[(4)])));

return statearr_74293;
})();
var state_74286__$1 = state_74286;
var statearr_74294_74362 = state_74286__$1;
(statearr_74294_74362[(2)] = inst_74274);

(statearr_74294_74362[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (1))){
var inst_74161 = (0);
var state_74286__$1 = (function (){var statearr_74295 = state_74286;
(statearr_74295[(7)] = inst_74161);

return statearr_74295;
})();
var statearr_74296_74363 = state_74286__$1;
(statearr_74296_74363[(2)] = null);

(statearr_74296_74363[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (24))){
var inst_74252 = (state_74286[(8)]);
var inst_74252__$1 = (state_74286[(2)]);
var inst_74253 = inst_74252__$1 === true;
var state_74286__$1 = (function (){var statearr_74297 = state_74286;
(statearr_74297[(8)] = inst_74252__$1);

return statearr_74297;
})();
if(cljs.core.truth_(inst_74253)){
var statearr_74298_74364 = state_74286__$1;
(statearr_74298_74364[(1)] = (25));

} else {
var statearr_74299_74365 = state_74286__$1;
(statearr_74299_74365[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (4))){
var inst_74164 = (state_74286[(9)]);
var inst_74164__$1 = (state_74286[(2)]);
var state_74286__$1 = (function (){var statearr_74300 = state_74286;
(statearr_74300[(9)] = inst_74164__$1);

return statearr_74300;
})();
if(cljs.core.truth_(inst_74164__$1)){
var statearr_74301_74366 = state_74286__$1;
(statearr_74301_74366[(1)] = (5));

} else {
var statearr_74302_74367 = state_74286__$1;
(statearr_74302_74367[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (15))){
var inst_74177 = (state_74286[(10)]);
var state_74286__$1 = state_74286;
var statearr_74303_74368 = state_74286__$1;
(statearr_74303_74368[(2)] = inst_74177);

(statearr_74303_74368[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (21))){
var inst_74200 = (state_74286[(11)]);
var inst_74161 = (state_74286[(7)]);
var inst_74203 = (state_74286[(12)]);
var inst_74201 = (state_74286[(13)]);
var inst_74202 = (state_74286[(14)]);
var inst_74208 = (state_74286[(15)]);
var inst_74204 = (state_74286[(16)]);
var inst_74205 = (state_74286[(17)]);
var inst_74209 = (state_74286[(18)]);
var inst_74164 = (state_74286[(9)]);
var inst_74211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74212 = [cljs.core.cst$kw$pending_DASH_req,inst_74208];
var inst_74213 = (new cljs.core.PersistentVector(null,2,(5),inst_74211,inst_74212,null));
var inst_74214 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.assoc_in,inst_74213,inst_74203);
var inst_74241 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_74242 = (function (){var resp_chan = inst_74203;
var map__74199 = inst_74205;
var timeout = inst_74209;
var i = inst_74161;
var data = inst_74202;
var c__16469__auto____$1 = inst_74241;
var _ = inst_74200;
var req_id = inst_74208;
var operation = inst_74201;
var msg = inst_74164;
var vec__74196 = inst_74164;
var opts = inst_74204;
return (function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74239){
var state_val_74240 = (state_74239[(1)]);
if((state_val_74240 === (1))){
var inst_74218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74219 = cljs.core.async.timeout(timeout);
var inst_74220 = [resp_chan,inst_74219];
var inst_74221 = (new cljs.core.PersistentVector(null,2,(5),inst_74218,inst_74220,null));
var state_74239__$1 = state_74239;
return cljs.core.async.ioc_alts_BANG_(state_74239__$1,(2),inst_74221);
} else {
if((state_val_74240 === (2))){
var inst_74224 = (state_74239[(7)]);
var inst_74223 = (state_74239[(2)]);
var inst_74224__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74223,(0),null);
var inst_74225 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74223,(1),null);
var inst_74226 = (function (){var vec__74215 = inst_74223;
var resp = inst_74224__$1;
var c = inst_74225;
return (function (p1__74160_SHARP_){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(p1__74160_SHARP_,req_id);
});
})();
var inst_74227 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state,cljs.core.update,cljs.core.cst$kw$pending_DASH_req,inst_74226);
var inst_74228 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74225,resp_chan);
var state_74239__$1 = (function (){var statearr_74304 = state_74239;
(statearr_74304[(7)] = inst_74224__$1);

(statearr_74304[(8)] = inst_74227);

return statearr_74304;
})();
if(inst_74228){
var statearr_74305_74369 = state_74239__$1;
(statearr_74305_74369[(1)] = (3));

} else {
var statearr_74306_74370 = state_74239__$1;
(statearr_74306_74370[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74240 === (3))){
var inst_74224 = (state_74239[(7)]);
var state_74239__$1 = state_74239;
var statearr_74307_74371 = state_74239__$1;
(statearr_74307_74371[(2)] = inst_74224);

(statearr_74307_74371[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74240 === (4))){
var inst_74231 = ["Request ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(req_id)," timed out."].join('');
var inst_74232 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_74233 = [(408),cljs.core.cst$kw$db_SLASH_timeout];
var inst_74234 = cljs.core.PersistentHashMap.fromArrays(inst_74232,inst_74233);
var inst_74235 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_74231,inst_74234);
var state_74239__$1 = state_74239;
var statearr_74308_74372 = state_74239__$1;
(statearr_74308_74372[(2)] = inst_74235);

(statearr_74308_74372[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74240 === (5))){
var inst_74237 = (state_74239[(2)]);
var state_74239__$1 = state_74239;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74239__$1,inst_74237);
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____0 = (function (){
var statearr_74309 = [null,null,null,null,null,null,null,null,null];
(statearr_74309[(0)] = fluree$db$connection$msg_producer_$_state_machine__16395__auto__);

(statearr_74309[(1)] = (1));

return statearr_74309;
});
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____1 = (function (state_74239){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74239);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74310){var ex__16398__auto__ = e74310;
var statearr_74311_74373 = state_74239;
(statearr_74311_74373[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74239[(4)]))){
var statearr_74312_74374 = state_74239;
(statearr_74312_74374[(1)] = cljs.core.first((state_74239[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74375 = state_74239;
state_74239 = G__74375;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = function(state_74239){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____1.call(this,state_74239);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74313 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74313[(6)] = c__16469__auto____$1);

return statearr_74313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
});
})();
var inst_74243 = cljs.core.async.impl.dispatch.run(inst_74242);
var state_74286__$1 = (function (){var statearr_74314 = state_74286;
(statearr_74314[(19)] = inst_74214);

(statearr_74314[(20)] = inst_74243);

return statearr_74314;
})();
var statearr_74315_74376 = state_74286__$1;
(statearr_74315_74376[(2)] = inst_74241);

(statearr_74315_74376[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (31))){
var inst_74262 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed."], 0));
var state_74286__$1 = state_74286;
var statearr_74316_74377 = state_74286__$1;
(statearr_74316_74377[(2)] = inst_74262);

(statearr_74316_74377[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (32))){
var state_74286__$1 = state_74286;
var statearr_74317_74378 = state_74286__$1;
(statearr_74317_74378[(1)] = (34));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (33))){
var inst_74270 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
var statearr_74319_74379 = state_74286__$1;
(statearr_74319_74379[(2)] = inst_74270);

(statearr_74319_74379[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (13))){
var inst_74177 = (state_74286[(10)]);
var inst_74174 = (state_74286[(2)]);
var inst_74175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74174,(0),null);
var inst_74176 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74174,(1),null);
var inst_74177__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74174,(2),null);
var state_74286__$1 = (function (){var statearr_74320 = state_74286;
(statearr_74320[(21)] = inst_74176);

(statearr_74320[(10)] = inst_74177__$1);

(statearr_74320[(22)] = inst_74175);

return statearr_74320;
})();
if(cljs.core.truth_(inst_74177__$1)){
var statearr_74321_74380 = state_74286__$1;
(statearr_74321_74380[(1)] = (14));

} else {
var statearr_74322_74381 = state_74286__$1;
(statearr_74322_74381[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (22))){
var state_74286__$1 = state_74286;
var statearr_74323_74382 = state_74286__$1;
(statearr_74323_74382[(2)] = null);

(statearr_74323_74382[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (36))){
var inst_74268 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
var statearr_74324_74383 = state_74286__$1;
(statearr_74324_74383[(2)] = inst_74268);

(statearr_74324_74383[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (29))){
var inst_74252 = (state_74286[(8)]);
var inst_74260 = (inst_74252 == null);
var state_74286__$1 = state_74286;
if(cljs.core.truth_(inst_74260)){
var statearr_74325_74384 = state_74286__$1;
(statearr_74325_74384[(1)] = (31));

} else {
var statearr_74326_74385 = state_74286__$1;
(statearr_74326_74385[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (6))){
var state_74286__$1 = state_74286;
var statearr_74327_74386 = state_74286__$1;
(statearr_74327_74386[(2)] = null);

(statearr_74327_74386[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (28))){
var inst_74252 = (state_74286[(8)]);
var inst_74258 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74252,"Error processing message in producer."], 0));
var state_74286__$1 = state_74286;
var statearr_74328_74387 = state_74286__$1;
(statearr_74328_74387[(2)] = inst_74258);

(statearr_74328_74387[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (25))){
var state_74286__$1 = state_74286;
var statearr_74329_74388 = state_74286__$1;
(statearr_74329_74388[(2)] = null);

(statearr_74329_74388[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (34))){
var inst_74252 = (state_74286[(8)]);
var inst_74265 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Error processing message in producer. Socket closed. Published result",inst_74252], 0));
var state_74286__$1 = state_74286;
var statearr_74330_74389 = state_74286__$1;
(statearr_74330_74389[(2)] = inst_74265);

(statearr_74330_74389[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (17))){
var inst_74166 = (state_74286[(23)]);
var inst_74177 = (state_74286[(10)]);
var inst_74184 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_74177,inst_74166);
var state_74286__$1 = state_74286;
var statearr_74331_74390 = state_74286__$1;
(statearr_74331_74390[(2)] = inst_74184);

(statearr_74331_74390[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (3))){
var inst_74284 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74286__$1,inst_74284);
} else {
if((state_val_74287 === (12))){
var state_74286__$1 = state_74286;
var statearr_74332_74391 = state_74286__$1;
(statearr_74332_74391[(2)] = null);

(statearr_74332_74391[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (2))){
var state_74286__$1 = state_74286;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74286__$1,(4),req_chan);
} else {
if((state_val_74287 === (23))){
var inst_74201 = (state_74286[(13)]);
var inst_74202 = (state_74286[(14)]);
var inst_74208 = (state_74286[(15)]);
var inst_74246 = (state_74286[(2)]);
var inst_74247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74248 = [inst_74201,inst_74208,inst_74202];
var inst_74249 = (new cljs.core.PersistentVector(null,3,(5),inst_74247,inst_74248,null));
var inst_74250 = (publish_fn.cljs$core$IFn$_invoke$arity$2 ? publish_fn.cljs$core$IFn$_invoke$arity$2(conn,inst_74249) : publish_fn.call(null,conn,inst_74249));
var state_74286__$1 = (function (){var statearr_74333 = state_74286;
(statearr_74333[(24)] = inst_74246);

return statearr_74333;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74286__$1,(24),inst_74250);
} else {
if((state_val_74287 === (35))){
var state_74286__$1 = state_74286;
var statearr_74334_74392 = state_74286__$1;
(statearr_74334_74392[(2)] = null);

(statearr_74334_74392[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (19))){
var inst_74190 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
var statearr_74335_74393 = state_74286__$1;
(statearr_74335_74393[(2)] = inst_74190);

(statearr_74335_74393[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (11))){
var inst_74164 = (state_74286[(9)]);
var state_74286__$1 = state_74286;
var statearr_74336_74394 = state_74286__$1;
(statearr_74336_74394[(2)] = inst_74164);

(statearr_74336_74394[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (9))){
var inst_74161 = (state_74286[(7)]);
var inst_74277 = (state_74286[(2)]);
var inst_74278 = (inst_74161 + (1));
var inst_74161__$1 = inst_74278;
var state_74286__$1 = (function (){var statearr_74337 = state_74286;
(statearr_74337[(7)] = inst_74161__$1);

(statearr_74337[(25)] = inst_74277);

return statearr_74337;
})();
var statearr_74338_74395 = state_74286__$1;
(statearr_74338_74395[(2)] = null);

(statearr_74338_74395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (5))){
var state_74286__$1 = state_74286;
var statearr_74339_74396 = state_74286__$1;
(statearr_74339_74396[(2)] = null);

(statearr_74339_74396[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (14))){
var inst_74177 = (state_74286[(10)]);
var inst_74179 = fluree.db.util.async.channel_QMARK_(inst_74177);
var state_74286__$1 = state_74286;
var statearr_74340_74397 = state_74286__$1;
(statearr_74340_74397[(2)] = inst_74179);

(statearr_74340_74397[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (26))){
var inst_74252 = (state_74286[(8)]);
var inst_74256 = fluree.db.util.core.exception_QMARK_(inst_74252);
var state_74286__$1 = state_74286;
if(inst_74256){
var statearr_74341_74398 = state_74286__$1;
(statearr_74341_74398[(1)] = (28));

} else {
var statearr_74342_74399 = state_74286__$1;
(statearr_74342_74399[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (16))){
var inst_74182 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
if(cljs.core.truth_(inst_74182)){
var statearr_74343_74400 = state_74286__$1;
(statearr_74343_74400[(1)] = (17));

} else {
var statearr_74344_74401 = state_74286__$1;
(statearr_74344_74401[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (30))){
var inst_74272 = (state_74286[(2)]);
var state_74286__$1 = state_74286;
var statearr_74345_74402 = state_74286__$1;
(statearr_74345_74402[(2)] = inst_74272);

(statearr_74345_74402[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (10))){
var inst_74164 = (state_74286[(9)]);
var inst_74166 = (state_74286[(2)]);
var inst_74170 = cljs.core.sequential_QMARK_(inst_74164);
var state_74286__$1 = (function (){var statearr_74346 = state_74286;
(statearr_74346[(23)] = inst_74166);

return statearr_74346;
})();
if(inst_74170){
var statearr_74347_74403 = state_74286__$1;
(statearr_74347_74403[(1)] = (11));

} else {
var statearr_74348_74404 = state_74286__$1;
(statearr_74348_74404[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (18))){
var inst_74166 = (state_74286[(23)]);
var inst_74164 = (state_74286[(9)]);
var inst_74186 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74164], 0));
var inst_74187 = ["Error processing ledger request, no valid return channel: ",inst_74186].join('');
var inst_74188 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74166,inst_74187], 0));
var state_74286__$1 = state_74286;
var statearr_74349_74405 = state_74286__$1;
(statearr_74349_74405[(2)] = inst_74188);

(statearr_74349_74405[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74287 === (8))){
var inst_74203 = (state_74286[(12)]);
var inst_74204 = (state_74286[(16)]);
var inst_74205 = (state_74286[(17)]);
var inst_74164 = (state_74286[(9)]);
var _ = (function (){var statearr_74350 = state_74286;
(statearr_74350[(4)] = cljs.core.cons((20),(state_74286[(4)])));

return statearr_74350;
})();
var inst_74200 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Outgoing message to websocket: ",inst_74164], 0));
var inst_74201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74164,(0),null);
var inst_74202 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74164,(1),null);
var inst_74203__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74164,(2),null);
var inst_74204__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74164,(3),null);
var inst_74205__$1 = cljs.core.__destructure_map(inst_74204__$1);
var inst_74206 = fluree.db.util.core.random_uuid();
var inst_74207 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74206);
var inst_74208 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74205__$1,cljs.core.cst$kw$req_DASH_id,inst_74207);
var inst_74209 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_74205__$1,cljs.core.cst$kw$timeout,(60000));
var state_74286__$1 = (function (){var statearr_74351 = state_74286;
(statearr_74351[(11)] = inst_74200);

(statearr_74351[(12)] = inst_74203__$1);

(statearr_74351[(13)] = inst_74201);

(statearr_74351[(14)] = inst_74202);

(statearr_74351[(15)] = inst_74208);

(statearr_74351[(16)] = inst_74204__$1);

(statearr_74351[(17)] = inst_74205__$1);

(statearr_74351[(18)] = inst_74209);

return statearr_74351;
})();
if(cljs.core.truth_(inst_74203__$1)){
var statearr_74352_74406 = state_74286__$1;
(statearr_74352_74406[(1)] = (21));

} else {
var statearr_74353_74407 = state_74286__$1;
(statearr_74353_74407[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____0 = (function (){
var statearr_74354 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74354[(0)] = fluree$db$connection$msg_producer_$_state_machine__16395__auto__);

(statearr_74354[(1)] = (1));

return statearr_74354;
});
var fluree$db$connection$msg_producer_$_state_machine__16395__auto____1 = (function (state_74286){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74286);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74355){var ex__16398__auto__ = e74355;
var statearr_74356_74408 = state_74286;
(statearr_74356_74408[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74286[(4)]))){
var statearr_74357_74409 = state_74286;
(statearr_74357_74409[(1)] = cljs.core.first((state_74286[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74410 = state_74286;
state_74286 = G__74410;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_producer_$_state_machine__16395__auto__ = function(state_74286){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_producer_$_state_machine__16395__auto____1.call(this,state_74286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_producer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_producer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_producer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74358 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74358[(6)] = c__16469__auto__);

return statearr_74358;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.connection.ping_transactor = (function fluree$db$connection$ping_transactor(conn){
var req_chan = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(req_chan,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ping,true], null));
});
/**
 * Takes messages from peer/ledger and processes them.
 */
fluree.db.connection.msg_consumer = (function fluree$db$connection$msg_consumer(conn){
var ping_transactor_after = (2500);
var map__74411 = conn;
var map__74411__$1 = cljs.core.__destructure_map(map__74411);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74411__$1,cljs.core.cst$kw$sub_DASH_chan);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74496){
var state_val_74497 = (state_74496[(1)]);
if((state_val_74497 === (7))){
var inst_74492 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74498_74549 = state_74496__$1;
(statearr_74498_74549[(2)] = inst_74492);

(statearr_74498_74549[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (20))){
var inst_74430 = (state_74496[(7)]);
var inst_74444 = [cljs.core.cst$kw$keep_DASH_alive_DASH_fn];
var inst_74445 = [inst_74430];
var inst_74446 = cljs.core.PersistentHashMap.fromArrays(inst_74444,inst_74445);
var inst_74447 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Unsupported callback registered",inst_74446], 0));
var state_74496__$1 = state_74496;
var statearr_74499_74550 = state_74496__$1;
(statearr_74499_74550[(2)] = inst_74447);

(statearr_74499_74550[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (27))){
var state_74496__$1 = state_74496;
var statearr_74500_74551 = state_74496__$1;
(statearr_74500_74551[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (1))){
var inst_74412 = (0);
var state_74496__$1 = (function (){var statearr_74502 = state_74496;
(statearr_74502[(8)] = inst_74412);

return statearr_74502;
})();
var statearr_74503_74552 = state_74496__$1;
(statearr_74503_74552[(2)] = null);

(statearr_74503_74552[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (24))){
var inst_74423 = (state_74496[(9)]);
var inst_74472 = fluree.db.util.core.exception_QMARK_(inst_74423);
var state_74496__$1 = state_74496;
if(inst_74472){
var statearr_74504_74553 = state_74496__$1;
(statearr_74504_74553[(1)] = (26));

} else {
var statearr_74505_74554 = state_74496__$1;
(statearr_74505_74554[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (4))){
var inst_74417 = (state_74496[(10)]);
var inst_74422 = (state_74496[(2)]);
var inst_74423 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74422,(0),null);
var inst_74424 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_74422,(1),null);
var inst_74425 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_74424,inst_74417);
var state_74496__$1 = (function (){var statearr_74506 = state_74496;
(statearr_74506[(9)] = inst_74423);

return statearr_74506;
})();
if(inst_74425){
var statearr_74507_74555 = state_74496__$1;
(statearr_74507_74555[(1)] = (5));

} else {
var statearr_74508_74556 = state_74496__$1;
(statearr_74508_74556[(1)] = (6));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (15))){
var inst_74430 = (state_74496[(7)]);
var inst_74439 = typeof inst_74430 === 'string';
var state_74496__$1 = state_74496;
if(cljs.core.truth_(inst_74439)){
var statearr_74509_74557 = state_74496__$1;
(statearr_74509_74557[(1)] = (17));

} else {
var statearr_74510_74558 = state_74496__$1;
(statearr_74510_74558[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (21))){
var state_74496__$1 = state_74496;
var statearr_74511_74559 = state_74496__$1;
(statearr_74511_74559[(2)] = null);

(statearr_74511_74559[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (31))){
var inst_74486 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74512_74560 = state_74496__$1;
(statearr_74512_74560[(2)] = inst_74486);

(statearr_74512_74560[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (13))){
var inst_74456 = (state_74496[(2)]);
var inst_74457 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74458 = fluree.db.connection.close_websocket(inst_74457);
var inst_74459 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74460 = fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(inst_74459);
var state_74496__$1 = (function (){var statearr_74513 = state_74496;
(statearr_74513[(11)] = inst_74458);

(statearr_74513[(12)] = inst_74456);

return statearr_74513;
})();
var statearr_74514_74561 = state_74496__$1;
(statearr_74514_74561[(2)] = inst_74460);

(statearr_74514_74561[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (22))){
var inst_74450 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74515_74562 = state_74496__$1;
(statearr_74515_74562[(2)] = inst_74450);

(statearr_74515_74562[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (29))){
var inst_74423 = (state_74496[(9)]);
var inst_74478 = fluree.db.util.json.parse(inst_74423);
var inst_74479 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74478], 0));
var inst_74480 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Received message:",inst_74479], 0));
var inst_74481 = fluree.db.util.json.parse(inst_74423);
var inst_74482 = fluree.db.conn_events.process_events(conn,inst_74481);
var inst_74412 = (0);
var state_74496__$1 = (function (){var statearr_74516 = state_74496;
(statearr_74516[(13)] = inst_74480);

(statearr_74516[(8)] = inst_74412);

(statearr_74516[(14)] = inst_74482);

return statearr_74516;
})();
var statearr_74517_74563 = state_74496__$1;
(statearr_74517_74563[(2)] = null);

(statearr_74517_74563[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (6))){
var inst_74423 = (state_74496[(9)]);
var inst_74468 = (inst_74423 == null);
var state_74496__$1 = state_74496;
if(cljs.core.truth_(inst_74468)){
var statearr_74518_74564 = state_74496__$1;
(statearr_74518_74564[(1)] = (23));

} else {
var statearr_74519_74565 = state_74496__$1;
(statearr_74519_74565[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (28))){
var inst_74488 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74520_74566 = state_74496__$1;
(statearr_74520_74566[(2)] = inst_74488);

(statearr_74520_74566[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (25))){
var inst_74490 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74521_74567 = state_74496__$1;
(statearr_74521_74567[(2)] = inst_74490);

(statearr_74521_74567[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (17))){
var inst_74430 = (state_74496[(7)]);
var inst_74441 = cljs.core.eval(inst_74430);
var state_74496__$1 = state_74496;
var statearr_74522_74568 = state_74496__$1;
(statearr_74522_74568[(2)] = inst_74441);

(statearr_74522_74568[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (3))){
var inst_74494 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74496__$1,inst_74494);
} else {
if((state_val_74497 === (12))){
var inst_74430 = (state_74496[(7)]);
var inst_74435 = cljs.core.fn_QMARK_(inst_74430);
var state_74496__$1 = state_74496;
if(inst_74435){
var statearr_74523_74569 = state_74496__$1;
(statearr_74523_74569[(1)] = (14));

} else {
var statearr_74524_74570 = state_74496__$1;
(statearr_74524_74570[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (2))){
var inst_74417 = (state_74496[(10)]);
var inst_74417__$1 = cljs.core.async.timeout(ping_transactor_after);
var inst_74418 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74419 = [sub_chan,inst_74417__$1];
var inst_74420 = (new cljs.core.PersistentVector(null,2,(5),inst_74418,inst_74419,null));
var state_74496__$1 = (function (){var statearr_74525 = state_74496;
(statearr_74525[(10)] = inst_74417__$1);

return statearr_74525;
})();
return cljs.core.async.ioc_alts_BANG_(state_74496__$1,(4),inst_74420);
} else {
if((state_val_74497 === (23))){
var inst_74470 = fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection closed."], 0));
var state_74496__$1 = state_74496;
var statearr_74526_74571 = state_74496__$1;
(statearr_74526_74571[(2)] = inst_74470);

(statearr_74526_74571[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (19))){
var inst_74452 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74527_74572 = state_74496__$1;
(statearr_74527_74572[(2)] = inst_74452);

(statearr_74527_74572[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (11))){
var inst_74433 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["No keep-alive callback is registered"], 0));
var state_74496__$1 = state_74496;
var statearr_74528_74573 = state_74496__$1;
(statearr_74528_74573[(2)] = inst_74433);

(statearr_74528_74573[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (9))){
var inst_74412 = (state_74496[(8)]);
var inst_74462 = fluree.db.connection.ping_transactor(conn);
var inst_74463 = (inst_74412 + (1));
var inst_74412__$1 = inst_74463;
var state_74496__$1 = (function (){var statearr_74529 = state_74496;
(statearr_74529[(8)] = inst_74412__$1);

(statearr_74529[(15)] = inst_74462);

return statearr_74529;
})();
var statearr_74530_74574 = state_74496__$1;
(statearr_74530_74574[(2)] = null);

(statearr_74530_74574[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (5))){
var inst_74412 = (state_74496[(8)]);
var inst_74427 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_74412);
var state_74496__$1 = state_74496;
if(inst_74427){
var statearr_74531_74575 = state_74496__$1;
(statearr_74531_74575[(1)] = (8));

} else {
var statearr_74532_74576 = state_74496__$1;
(statearr_74532_74576[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (14))){
var inst_74430 = (state_74496[(7)]);
var inst_74437 = (inst_74430.cljs$core$IFn$_invoke$arity$0 ? inst_74430.cljs$core$IFn$_invoke$arity$0() : inst_74430.call(null));
var state_74496__$1 = state_74496;
var statearr_74533_74577 = state_74496__$1;
(statearr_74533_74577[(2)] = inst_74437);

(statearr_74533_74577[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (26))){
var inst_74423 = (state_74496[(9)]);
var inst_74474 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74423], 0));
var inst_74412 = (0);
var state_74496__$1 = (function (){var statearr_74534 = state_74496;
(statearr_74534[(8)] = inst_74412);

(statearr_74534[(16)] = inst_74474);

return statearr_74534;
})();
var statearr_74535_74578 = state_74496__$1;
(statearr_74535_74578[(2)] = null);

(statearr_74535_74578[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (16))){
var inst_74454 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74536_74579 = state_74496__$1;
(statearr_74536_74579[(2)] = inst_74454);

(statearr_74536_74579[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (30))){
var state_74496__$1 = state_74496;
var statearr_74537_74580 = state_74496__$1;
(statearr_74537_74580[(2)] = null);

(statearr_74537_74580[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (10))){
var inst_74466 = (state_74496[(2)]);
var state_74496__$1 = state_74496;
var statearr_74538_74581 = state_74496__$1;
(statearr_74538_74581[(2)] = inst_74466);

(statearr_74538_74581[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (18))){
var state_74496__$1 = state_74496;
var statearr_74539_74582 = state_74496__$1;
(statearr_74539_74582[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_74497 === (8))){
var inst_74430 = (state_74496[(7)]);
var inst_74429 = fluree.db.util.log.warn.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Connection has gone stale. Perhaps network conditions are poor. Disconnecting socket."], 0));
var inst_74430__$1 = cljs.core.cst$kw$keep_DASH_alive_DASH_fn.cljs$core$IFn$_invoke$arity$1(conn);
var inst_74431 = (inst_74430__$1 == null);
var state_74496__$1 = (function (){var statearr_74541 = state_74496;
(statearr_74541[(17)] = inst_74429);

(statearr_74541[(7)] = inst_74430__$1);

return statearr_74541;
})();
if(cljs.core.truth_(inst_74431)){
var statearr_74542_74583 = state_74496__$1;
(statearr_74542_74583[(1)] = (11));

} else {
var statearr_74543_74584 = state_74496__$1;
(statearr_74543_74584[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto__ = null;
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0 = (function (){
var statearr_74544 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74544[(0)] = fluree$db$connection$msg_consumer_$_state_machine__16395__auto__);

(statearr_74544[(1)] = (1));

return statearr_74544;
});
var fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1 = (function (state_74496){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74496);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74545){var ex__16398__auto__ = e74545;
var statearr_74546_74585 = state_74496;
(statearr_74546_74585[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74496[(4)]))){
var statearr_74547_74586 = state_74496;
(statearr_74547_74586[(1)] = cljs.core.first((state_74496[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74587 = state_74496;
state_74496 = G__74587;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__ = function(state_74496){
switch(arguments.length){
case 0:
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1.call(this,state_74496);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$msg_consumer_$_state_machine__16395__auto____0;
fluree$db$connection$msg_consumer_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$msg_consumer_$_state_machine__16395__auto____1;
return fluree$db$connection$msg_consumer_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74548 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74548[(6)] = c__16469__auto__);

return statearr_74548;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Default storage read function - uses ledger storage and issues http(s) requests.
 */
fluree.db.connection.default_storage_read = (function fluree$db$connection$default_storage_read(var_args){
var G__74589 = arguments.length;
switch (G__74589) {
case 2:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$2 = (function (conn_id,servers){
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers,null);
}));

(fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3 = (function (conn_id,servers,opts){
var map__74590 = opts;
var map__74590__$1 = cljs.core.__destructure_map(map__74590);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74590__$1,cljs.core.cst$kw$private);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74590__$1,cljs.core.cst$kw$jwt);
return (function (k){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74642){
var state_val_74643 = (state_74642[(1)]);
if((state_val_74643 === (7))){
var inst_74600 = cljs.core.deref(fluree.db.connection.server_connections_atom);
var inst_74601 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_74602 = [conn_id,cljs.core.cst$kw$token];
var inst_74603 = (new cljs.core.PersistentVector(null,2,(5),inst_74601,inst_74602,null));
var inst_74604 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_74600,inst_74603);
var state_74642__$1 = state_74642;
var statearr_74644_74675 = state_74642__$1;
(statearr_74644_74675[(2)] = inst_74604);

(statearr_74644_74675[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (1))){
var state_74642__$1 = state_74642;
var statearr_74645_74676 = state_74642__$1;
(statearr_74645_74676[(2)] = null);

(statearr_74645_74676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (4))){
var inst_74591 = (state_74642[(2)]);
var state_74642__$1 = state_74642;
var statearr_74646_74677 = state_74642__$1;
(statearr_74646_74677[(2)] = inst_74591);

(statearr_74646_74677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (15))){
var inst_74611 = (state_74642[(7)]);
var inst_74630 = (state_74642[(2)]);
var inst_74631 = [cljs.core.cst$kw$request_DASH_timeout,cljs.core.cst$kw$headers,cljs.core.cst$kw$output_DASH_format];
var inst_74632 = [(5000),inst_74630,cljs.core.cst$kw$json];
var inst_74633 = cljs.core.PersistentHashMap.fromArrays(inst_74631,inst_74632);
var inst_74634 = fluree.db.util.xhttp.get(inst_74611,inst_74633);
var state_74642__$1 = state_74642;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74642__$1,(16),inst_74634);
} else {
if((state_val_74643 === (13))){
var inst_74611 = (state_74642[(7)]);
var inst_74621 = (state_74642[(8)]);
var inst_74623 = [cljs.core.cst$kw$headers];
var inst_74624 = [inst_74621];
var inst_74625 = cljs.core.PersistentHashMap.fromArrays(inst_74623,inst_74624);
var inst_74626 = fluree.db.query.http_signatures.sign_request.cljs$core$IFn$_invoke$arity$4("get",inst_74611,inst_74625,private$);
var inst_74627 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_74626);
var state_74642__$1 = state_74642;
var statearr_74647_74678 = state_74642__$1;
(statearr_74647_74678[(2)] = inst_74627);

(statearr_74647_74678[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (6))){
var inst_74597 = (state_74642[(9)]);
var state_74642__$1 = state_74642;
var statearr_74648_74679 = state_74642__$1;
(statearr_74648_74679[(2)] = inst_74597);

(statearr_74648_74679[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (3))){
var inst_74640 = (state_74642[(2)]);
var state_74642__$1 = state_74642;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74642__$1,inst_74640);
} else {
if((state_val_74643 === (12))){
var inst_74621 = (state_74642[(2)]);
var state_74642__$1 = (function (){var statearr_74649 = state_74642;
(statearr_74649[(8)] = inst_74621);

return statearr_74649;
})();
if(cljs.core.truth_(private$)){
var statearr_74650_74680 = state_74642__$1;
(statearr_74650_74680[(1)] = (13));

} else {
var statearr_74651_74681 = state_74642__$1;
(statearr_74651_74681[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (2))){
var inst_74597 = (state_74642[(9)]);
var _ = (function (){var statearr_74652 = state_74642;
(statearr_74652[(4)] = cljs.core.cons((5),(state_74642[(4)])));

return statearr_74652;
})();
var inst_74597__$1 = jwt;
var state_74642__$1 = (function (){var statearr_74653 = state_74642;
(statearr_74653[(9)] = inst_74597__$1);

return statearr_74653;
})();
if(cljs.core.truth_(inst_74597__$1)){
var statearr_74654_74682 = state_74642__$1;
(statearr_74654_74682[(1)] = (6));

} else {
var statearr_74655_74683 = state_74642__$1;
(statearr_74655_74683[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (11))){
var inst_74615 = (state_74642[(10)]);
var state_74642__$1 = state_74642;
var statearr_74657_74684 = state_74642__$1;
(statearr_74657_74684[(2)] = inst_74615);

(statearr_74657_74684[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (9))){
var inst_74607 = (state_74642[(11)]);
var inst_74606 = (state_74642[(12)]);
var inst_74610 = (state_74642[(2)]);
var inst_74611 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74610),"/fdb/storage/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74607)].join('');
var inst_74613 = ["Accept"];
var inst_74614 = ["application/json"];
var inst_74615 = cljs.core.PersistentHashMap.fromArrays(inst_74613,inst_74614);
var state_74642__$1 = (function (){var statearr_74658 = state_74642;
(statearr_74658[(10)] = inst_74615);

(statearr_74658[(7)] = inst_74611);

return statearr_74658;
})();
if(cljs.core.truth_(inst_74606)){
var statearr_74659_74685 = state_74642__$1;
(statearr_74659_74685[(1)] = (10));

} else {
var statearr_74660_74686 = state_74642__$1;
(statearr_74660_74686[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (5))){
var _ = (function (){var statearr_74661 = state_74642;
(statearr_74661[(4)] = cljs.core.rest((state_74642[(4)])));

return statearr_74661;
})();
var state_74642__$1 = state_74642;
var ex74656 = (state_74642__$1[(2)]);
var statearr_74662_74687 = state_74642__$1;
(statearr_74662_74687[(5)] = ex74656);


if((ex74656 instanceof Error)){
var statearr_74663_74688 = state_74642__$1;
(statearr_74663_74688[(1)] = (4));

(statearr_74663_74688[(5)] = null);

} else {
throw ex74656;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (14))){
var inst_74621 = (state_74642[(8)]);
var state_74642__$1 = state_74642;
var statearr_74664_74689 = state_74642__$1;
(statearr_74664_74689[(2)] = inst_74621);

(statearr_74664_74689[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (16))){
var inst_74636 = (state_74642[(2)]);
var inst_74637 = fluree.db.util.async.throw_err(inst_74636);
var _ = (function (){var statearr_74665 = state_74642;
(statearr_74665[(4)] = cljs.core.rest((state_74642[(4)])));

return statearr_74665;
})();
var state_74642__$1 = state_74642;
var statearr_74666_74690 = state_74642__$1;
(statearr_74666_74690[(2)] = inst_74637);

(statearr_74666_74690[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (10))){
var inst_74615 = (state_74642[(10)]);
var inst_74606 = (state_74642[(12)]);
var inst_74617 = ["Bearer ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_74606)].join('');
var inst_74618 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_74615,"Authorization",inst_74617);
var state_74642__$1 = state_74642;
var statearr_74667_74691 = state_74642__$1;
(statearr_74667_74691[(2)] = inst_74618);

(statearr_74667_74691[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74643 === (8))){
var inst_74606 = (state_74642[(2)]);
var inst_74607 = clojure.string.replace(k,"_","/");
var inst_74608 = fluree.db.connection.get_server(conn_id,servers);
var state_74642__$1 = (function (){var statearr_74668 = state_74642;
(statearr_74668[(11)] = inst_74607);

(statearr_74668[(12)] = inst_74606);

return statearr_74668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74642__$1,(9),inst_74608);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16395__auto__ = null;
var fluree$db$connection$state_machine__16395__auto____0 = (function (){
var statearr_74669 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_74669[(0)] = fluree$db$connection$state_machine__16395__auto__);

(statearr_74669[(1)] = (1));

return statearr_74669;
});
var fluree$db$connection$state_machine__16395__auto____1 = (function (state_74642){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74642);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74670){var ex__16398__auto__ = e74670;
var statearr_74671_74692 = state_74642;
(statearr_74671_74692[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74642[(4)]))){
var statearr_74672_74693 = state_74642;
(statearr_74672_74693[(1)] = cljs.core.first((state_74642[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74694 = state_74642;
state_74642 = G__74694;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16395__auto__ = function(state_74642){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16395__auto____1.call(this,state_74642);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16395__auto____0;
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16395__auto____1;
return fluree$db$connection$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74673 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74673[(6)] = c__16469__auto__);

return statearr_74673;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
}));

(fluree.db.connection.default_storage_read.cljs$lang$maxFixedArity = 3);

/**
 * Default object cache to use for ledger.
 */
fluree.db.connection.default_object_cache_fn = (function fluree$db$connection$default_object_cache_fn(cache_atom){
return (function (k,value_fn){
if((value_fn == null)){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.evict,k);
} else {
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache_atom),k);
if(cljs.core.truth_(temp__5751__auto__)){
var v = temp__5751__auto__;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cache_atom,cljs.cache.hit,k);

return v;
} else {
var v = (value_fn.cljs$core$IFn$_invoke$arity$1 ? value_fn.cljs$core$IFn$_invoke$arity$1(k) : value_fn.call(null,k));
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cache_atom,cljs.cache.miss,k,v);

return v;
}
}
});
});
/**
 * Generates a default object cache.
 */
fluree.db.connection.default_object_cache_factory = (function fluree$db$connection$default_object_cache_factory(cache_size){
return cljs.cache.lru_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$threshold,cache_size], 0));
});
/**
 * Gets a specific key from the environment, returns nil if doesn't exist.
 */
fluree.db.connection.from_environment = (function fluree$db$connection$from_environment(key){
return null;
});
/**
 * Returns list of listeners
 */
fluree.db.connection.listeners = (function fluree$db$connection$listeners(conn){
return cljs.core.cst$kw$listeners.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Internal call to add-listener that uses the state atom directly.
 */
fluree.db.connection.add_listener_STAR_ = (function fluree$db$connection$add_listener_STAR_(conn_state,network,dbid,key,fn){
if(cljs.core.fn_QMARK_(fn)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener fn paramer not a function.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
}

if((key == null)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("add-listener key must not be nil.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
}

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null),(function (p1__74695_SHARP_){
if(cljs.core.truth_(p1__74695_SHARP_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["add-listener key already in use: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_listener], null));
} else {
return fn;
}
}));

return true;
});
/**
 * Internal call to remove-listener that uses the state atom directly.
 */
fluree.db.connection.remove_listener_STAR_ = (function fluree$db$connection$remove_listener_STAR_(conn_state,network,dbid,key){
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(conn_state),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null),key], null)))){
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$variadic(conn_state,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$listeners,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null)], null),cljs.core.dissoc,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([key], 0));

return true;
} else {
return false;
}
});
/**
 * Registers a new listener function, fn,  on connection.
 * 
 *   Each listener must have an associated key, which is used to remove the listener
 *   when needed but is otherwise opaque to the function. Each key must be unique for the
 *   given network + dbid.
 */
fluree.db.connection.add_listener = (function fluree$db$connection$add_listener(conn,network,dbid,key,fn){
var ledger = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)].join('');
var db = fluree.db.session.db(conn,ledger,null);
return fluree.db.connection.add_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key,fn);
});
/**
 * Removes listener on given network + dbid for the provided key.
 * 
 *   The key is the same provided for add-listener when registering.
 * 
 *   Will return true if a function exists for that key and it was removed.
 */
fluree.db.connection.remove_listener = (function fluree$db$connection$remove_listener(conn,network,dbid,key){
return fluree.db.connection.remove_listener_STAR_(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn),network,dbid,key);
});
/**
 * Adds token to connection information so it is available to submit storage read requests.
 * 
 *   Returns true if successful, false otherwise.
 */
fluree.db.connection.add_token = (function fluree$db$connection$add_token(conn,token){
var conn_id = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(conn);
try{cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.connection.server_connections_atom,cljs.core.update_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [conn_id,cljs.core.cst$kw$token], null),(function (p1__74696_SHARP_){
var or__4212__auto__ = p1__74696_SHARP_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return token;
}
}));

return true;
}catch (e74697){var e = e74697;
return false;
}});
/**
 * Generates connection object.
 */
fluree.db.connection.generate_connection = (function fluree$db$connection$generate_connection(servers,opts){
var state_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$close_QMARK_,false,cljs.core.cst$kw$health,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$connected_DASH_to,null,cljs.core.cst$kw$socket,null,cljs.core.cst$kw$socket_DASH_id,null,cljs.core.cst$kw$pending_DASH_req,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$listeners,cljs.core.PersistentArrayMap.EMPTY], null));
var map__74698 = opts;
var map__74698__$1 = cljs.core.__destructure_map(map__74698);
var sub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$sub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var storage_rename = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$storage_DASH_rename);
var keep_alive_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$keep_DASH_alive_DASH_fn);
var publish = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$publish);
var close_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$close_DASH_fn);
var default_network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$default_DASH_network);
var object_cache = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$object_DASH_cache);
var transact_handler = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$transact_DASH_handler);
var parallelism = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$parallelism,(4));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$meta);
var tx_private_key = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$tx_DASH_private_DASH_key);
var private$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$private);
var storage_read = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$storage_DASH_read);
var transactor_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$transactor_QMARK_,false);
var serializer = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$serializer,fluree.db.serde.json.json_serde());
var memory = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$memory,(1000000));
var storage_exists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$storage_DASH_exists);
var storage_write = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$storage_DASH_write,(function (k,v){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Storage write was not implemented on connection, but was called to store key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join(''),cljs.core.PersistentArrayMap.EMPTY);
}));
var memory_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$memory_QMARK_,false);
var req_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$req_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var pub_chan = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$pub_DASH_chan,cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0());
var private_key_file = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map__74698__$1,cljs.core.cst$kw$private_DASH_key_DASH_file,"default-private-key.txt");
var storage_list = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__74698__$1,cljs.core.cst$kw$storage_DASH_list);
var memory_object_size = cljs.core.quot(memory,(100000));
var _ = (((memory_object_size < (10)))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Must allocate at least 1MB of memory for Fluree. You've allocated: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(memory)," bytes."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_configuration], null))})():null);
var default_cache_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.connection.default_object_cache_factory(memory_object_size));
var object_cache_fn = (function (){var or__4212__auto__ = object_cache;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_object_cache_fn(default_cache_atom);
}
})();
var conn_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var close = (function (){
cljs.core.async.close_BANG_(req_chan);

cljs.core.async.close_BANG_(sub_chan);

cljs.core.async.close_BANG_(pub_chan);

fluree.db.connection.close_websocket(conn_id);

cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(state_atom,cljs.core.assoc,cljs.core.cst$kw$close_QMARK_,true);

if(("nodejs" === cljs.core._STAR_target_STAR_)){
fluree.db.dbfunctions.core.clear_db_fn_cache();
} else {
}

fluree.db.session.close_all_sessions.cljs$core$IFn$_invoke$arity$1(conn_id);

cljs.core.reset_BANG_(default_cache_atom,fluree.db.connection.default_object_cache_factory(memory_object_size));

if(cljs.core.fn_QMARK_(close_fn)){
(close_fn.cljs$core$IFn$_invoke$arity$0 ? close_fn.cljs$core$IFn$_invoke$arity$0() : close_fn.call(null));
} else {
}

return fluree.db.util.log.info.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$conn_DASH_closed], 0));
});
var servers_STAR_ = fluree.db.connection.normalize_servers(servers,transactor_QMARK_);
var storage_read_STAR_ = (function (){var or__4212__auto__ = storage_read;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
})();
var storage_exists_STAR_ = (function (){var or__4212__auto__ = storage_exists;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = storage_read;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return fluree.db.connection.default_storage_read.cljs$core$IFn$_invoke$arity$3(conn_id,servers_STAR_,opts);
}
}
})();
var ___$1 = ((cljs.core.fn_QMARK_(storage_read_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-read must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_read], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$2 = ((cljs.core.fn_QMARK_(storage_exists_STAR_))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-exists must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_exists], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})());
var ___$3 = (cljs.core.truth_((function (){var and__4210__auto__ = storage_write;
if(cljs.core.truth_(and__4210__auto__)){
return (!(cljs.core.fn_QMARK_(storage_write)));
} else {
return and__4210__auto__;
}
})())?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Connection's storage-write, if provided, must be a function. Provided: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([storage_write], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null))})():null);
var settings = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$object_DASH_cache,cljs.core.cst$kw$default_DASH_network,cljs.core.cst$kw$parallelism,cljs.core.cst$kw$transact_DASH_handler,cljs.core.cst$kw$add_DASH_listener,cljs.core.cst$kw$meta,cljs.core.cst$kw$tx_DASH_private_DASH_key,cljs.core.cst$kw$remove_DASH_listener,cljs.core.cst$kw$transactor_QMARK_,cljs.core.cst$kw$storage_DASH_read,cljs.core.cst$kw$serializer,cljs.core.cst$kw$memory,cljs.core.cst$kw$storage_DASH_exists,cljs.core.cst$kw$state,cljs.core.cst$kw$close,cljs.core.cst$kw$tx_DASH_key_DASH_id,cljs.core.cst$kw$storage_DASH_write,cljs.core.cst$kw$req_DASH_chan,cljs.core.cst$kw$id,cljs.core.cst$kw$servers,cljs.core.cst$kw$pub_DASH_chan,cljs.core.cst$kw$storage_DASH_list,cljs.core.cst$kw$sub_DASH_chan,cljs.core.cst$kw$storage_DASH_rename,cljs.core.cst$kw$keep_DASH_alive_DASH_fn,cljs.core.cst$kw$publish],[object_cache_fn,default_network,parallelism,transact_handler,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.add_listener_STAR_,state_atom),meta,tx_private_key,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(fluree.db.connection.remove_listener_STAR_,state_atom),transactor_QMARK_,storage_read_STAR_,serializer,memory_QMARK_,storage_exists_STAR_,state_atom,close,(cljs.core.truth_(tx_private_key)?null:null),storage_write,req_chan,conn_id,servers_STAR_,pub_chan,storage_list,sub_chan,storage_rename,((((cljs.core.fn_QMARK_(keep_alive_fn)) || (typeof keep_alive_fn === 'string')))?keep_alive_fn:null),publish]);
return fluree.db.connection.map__GT_Connection(settings);
});
/**
 * Closes connection, returns true if close successful, false if already closed.
 */
fluree.db.connection.close_BANG_ = (function fluree$db$connection$close_BANG_(conn){
if(cljs.core.truth_(fluree.db.connection.closed_QMARK_(conn))){
return false;
} else {
var fexpr__74699_74700 = cljs.core.cst$kw$close.cljs$core$IFn$_invoke$arity$1(conn);
(fexpr__74699_74700.cljs$core$IFn$_invoke$arity$0 ? fexpr__74699_74700.cljs$core$IFn$_invoke$arity$0() : fexpr__74699_74700.call(null));

return true;
}
});
/**
 * Creates a connection to a ledger group server.
 *   Provide servers in either a sequence or as a string that is comma-separated.
 */
fluree.db.connection.connect = (function fluree$db$connection$connect(var_args){
var args__4824__auto__ = [];
var len__4818__auto___74741 = arguments.length;
var i__4819__auto___74742 = (0);
while(true){
if((i__4819__auto___74742 < len__4818__auto___74741)){
args__4824__auto__.push((arguments[i__4819__auto___74742]));

var G__74743 = (i__4819__auto___74742 + (1));
i__4819__auto___74742 = G__74743;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.connection.connect.cljs$core$IFn$_invoke$arity$variadic = (function (servers,p__74703){
var vec__74704 = p__74703;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__74704,(0),null);
var conn = fluree.db.connection.generate_connection(servers,opts);
var transactor_QMARK_ = cljs.core.cst$kw$transactor_QMARK_.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(transactor_QMARK_)){
} else {
var c__16469__auto___74744 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_74724){
var state_val_74725 = (state_74724[(1)]);
if((state_val_74725 === (1))){
var inst_74707 = fluree.db.connection.get_socket(conn);
var state_74724__$1 = state_74724;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_74724__$1,(2),inst_74707);
} else {
if((state_val_74725 === (2))){
var inst_74710 = (state_74724[(7)]);
var inst_74709 = (state_74724[(8)]);
var inst_74709__$1 = (state_74724[(2)]);
var inst_74710__$1 = (inst_74709__$1 == null);
var state_74724__$1 = (function (){var statearr_74726 = state_74724;
(statearr_74726[(7)] = inst_74710__$1);

(statearr_74726[(8)] = inst_74709__$1);

return statearr_74726;
})();
if(cljs.core.truth_(inst_74710__$1)){
var statearr_74727_74745 = state_74724__$1;
(statearr_74727_74745[(1)] = (3));

} else {
var statearr_74728_74746 = state_74724__$1;
(statearr_74728_74746[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (3))){
var inst_74710 = (state_74724[(7)]);
var state_74724__$1 = state_74724;
var statearr_74729_74747 = state_74724__$1;
(statearr_74729_74747[(2)] = inst_74710);

(statearr_74729_74747[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (4))){
var inst_74709 = (state_74724[(8)]);
var inst_74713 = fluree.db.util.core.exception_QMARK_(inst_74709);
var state_74724__$1 = state_74724;
var statearr_74730_74748 = state_74724__$1;
(statearr_74730_74748[(2)] = inst_74713);

(statearr_74730_74748[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (5))){
var inst_74715 = (state_74724[(2)]);
var state_74724__$1 = state_74724;
if(cljs.core.truth_(inst_74715)){
var statearr_74731_74749 = state_74724__$1;
(statearr_74731_74749[(1)] = (6));

} else {
var statearr_74732_74750 = state_74724__$1;
(statearr_74732_74750[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (6))){
var inst_74709 = (state_74724[(8)]);
var inst_74717 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_74709,"Cannot establish connection to a healthy server, disconnecting."], 0));
var inst_74718 = cljs.core.async.close_BANG_(conn);
var state_74724__$1 = (function (){var statearr_74733 = state_74724;
(statearr_74733[(9)] = inst_74717);

return statearr_74733;
})();
var statearr_74734_74751 = state_74724__$1;
(statearr_74734_74751[(2)] = inst_74718);

(statearr_74734_74751[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (7))){
var inst_74720 = fluree.db.connection.msg_consumer(conn);
var state_74724__$1 = state_74724;
var statearr_74735_74752 = state_74724__$1;
(statearr_74735_74752[(2)] = inst_74720);

(statearr_74735_74752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_74725 === (8))){
var inst_74722 = (state_74724[(2)]);
var state_74724__$1 = state_74724;
return cljs.core.async.impl.ioc_helpers.return_chan(state_74724__$1,inst_74722);
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$connection$state_machine__16395__auto__ = null;
var fluree$db$connection$state_machine__16395__auto____0 = (function (){
var statearr_74736 = [null,null,null,null,null,null,null,null,null,null];
(statearr_74736[(0)] = fluree$db$connection$state_machine__16395__auto__);

(statearr_74736[(1)] = (1));

return statearr_74736;
});
var fluree$db$connection$state_machine__16395__auto____1 = (function (state_74724){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_74724);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e74737){var ex__16398__auto__ = e74737;
var statearr_74738_74753 = state_74724;
(statearr_74738_74753[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_74724[(4)]))){
var statearr_74739_74754 = state_74724;
(statearr_74739_74754[(1)] = cljs.core.first((state_74724[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__74755 = state_74724;
state_74724 = G__74755;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$connection$state_machine__16395__auto__ = function(state_74724){
switch(arguments.length){
case 0:
return fluree$db$connection$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$connection$state_machine__16395__auto____1.call(this,state_74724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$connection$state_machine__16395__auto____0;
fluree$db$connection$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$connection$state_machine__16395__auto____1;
return fluree$db$connection$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_74740 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_74740[(6)] = c__16469__auto___74744);

return statearr_74740;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

}

fluree.db.connection.msg_producer(conn);

return conn;
}));

(fluree.db.connection.connect.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.connection.connect.cljs$lang$applyTo = (function (seq74701){
var G__74702 = cljs.core.first(seq74701);
var seq74701__$1 = cljs.core.next(seq74701);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__74702,seq74701__$1);
}));

