// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.reader');
goog.require('cljs.cache');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.async');
goog.require('fluree.db.dbfunctions.fns');
goog.require('clojure.string');
/**
 * Returns an empty TTL cache for db-function caching.
 *   Implication of this caching strategy is changes to db functions that get
 *   update will take 5 seconds to recompile, benefit is that the same function
 *   call for a ledger will not have to recompile every time.
 */
fluree.db.dbfunctions.core.db_fn_cache_factory = (function fluree$db$dbfunctions$core$db_fn_cache_factory(){
return cljs.cache.ttl_cache_factory.cljs$core$IFn$_invoke$arity$variadic(cljs.core.PersistentArrayMap.EMPTY,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$ttl,(5000)], 0));
});
fluree.db.dbfunctions.core.db_fn_cache = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(fluree.db.dbfunctions.core.db_fn_cache_factory());
fluree.db.dbfunctions.core.clear_db_fn_cache = (function fluree$db$dbfunctions$core$clear_db_fn_cache(){
return cljs.core.reset_BANG_(fluree.db.dbfunctions.core.db_fn_cache,fluree.db.dbfunctions.core.db_fn_cache_factory());
});
/**
 * Returns true if this value is a transaction function.
 */
fluree.db.dbfunctions.core.tx_fn_QMARK_ = (function fluree$db$dbfunctions$core$tx_fn_QMARK_(value){
var and__4210__auto__ = typeof value === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,value);
} else {
return and__4210__auto__;
}
});
fluree.db.dbfunctions.core.default_fn_map = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$_QMARK_pO,cljs.core.cst$sym$_QMARK_auth_id,cljs.core.cst$sym$and,cljs.core.cst$sym$upper_DASH_case,cljs.core.cst$sym$cas,cljs.core.cst$sym$max_DASH_pred_DASH_val,cljs.core.cst$sym$_GT__EQ_,cljs.core.cst$sym$lower_DASH_case,cljs.core.cst$sym$_GT_,cljs.core.cst$sym$count,cljs.core.cst$sym$nil_QMARK_,cljs.core.cst$sym$objT,cljs.core.cst$sym$inc,cljs.core.cst$sym$_SLASH_,cljs.core.cst$sym$quot,cljs.core.cst$sym$flakes,cljs.core.cst$sym$not,cljs.core.cst$sym$_QMARK_sid,cljs.core.cst$sym$uuid,cljs.core.cst$sym$_QMARK_user_id,cljs.core.cst$sym$_LT__EQ_,cljs.core.cst$sym$_EQ_,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$if_DASH_else,cljs.core.cst$sym$_QMARK_pid,cljs.core.cst$sym$_PLUS_,cljs.core.cst$sym$_EQ__EQ_,cljs.core.cst$sym$boolean,cljs.core.cst$sym$max,cljs.core.cst$sym$empty_QMARK_,cljs.core.cst$sym$_STAR_,cljs.core.cst$sym$relationship_QMARK_,cljs.core.cst$sym$get_DASH_in,cljs.core.cst$sym$now,cljs.core.cst$sym$dec,cljs.core.cst$sym$get_DASH_all,cljs.core.cst$sym$floor,cljs.core.cst$sym$not_EQ_,cljs.core.cst$sym$get,cljs.core.cst$sym$str,cljs.core.cst$sym$_LT_,cljs.core.cst$sym$_DASH_,cljs.core.cst$sym$rand,cljs.core.cst$sym$contains_QMARK_,cljs.core.cst$sym$hash_DASH_set,cljs.core.cst$sym$valid_DASH_email_QMARK_,cljs.core.cst$sym$_QMARK_p,cljs.core.cst$sym$nth,cljs.core.cst$sym$subs,cljs.core.cst$sym$mod,cljs.core.cst$sym$_QMARK_s,cljs.core.cst$sym$rem,cljs.core.cst$sym$query,cljs.core.cst$sym$_QMARK_o,cljs.core.cst$sym$objF,cljs.core.cst$sym$follow,cljs.core.cst$sym$or,cljs.core.cst$sym$re_DASH_find],[(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pO !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pO;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pO,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pO,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,302,null,302,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the most recent object of an predicate, as of the previous block",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pO)?fluree.db.dbfunctions.fns._QMARK_pO.cljs$lang$test:null),"10 plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_auth_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_auth_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_auth_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_auth_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,715,null,715,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current auth _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_auth_id)?fluree.db.dbfunctions.fns._QMARK_auth_id.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.and !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.and;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_and,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$and,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,232,null,232,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if all in a sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.and)?fluree.db.dbfunctions.fns.and.cljs$lang$test:null),"Count of objects in and"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.upper_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.upper_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_upper_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$upper_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,159,null,159,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string upper-case",(cljs.core.truth_(fluree.db.dbfunctions.fns.upper_case)?fluree.db.dbfunctions.fns.upper_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.cas !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.cas;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_cas,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$cas,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,813,null,813,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$compare_DASH_val,cljs.core.cst$sym$new_DASH_val], null)),"Does a compare and set/swap operation as a transaction function.",(cljs.core.truth_(fluree.db.dbfunctions.fns.cas)?fluree.db.dbfunctions.fns.cas.cljs$lang$test:null),(20)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max_pred_val !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max_pred_val;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max_DASH_pred_DASH_val,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max_DASH_pred_DASH_val,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,522,null,522,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pred_DASH_name], null)),"Finds the maximum predicate value.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max_pred_val)?fluree.db.dbfunctions.fns.max_pred_val.cljs$lang$test:null),"10, plus fuel cost."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,428,null,428,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-increasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT__EQ_)?fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.lower_case !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.lower_case;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_lower_DASH_case,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$lower_DASH_case,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",17,1,147,null,147,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$str], null)),"Makes string lower case",(cljs.core.truth_(fluree.db.dbfunctions.fns.lower_case)?fluree.db.dbfunctions.fns.lower_case.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._GT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._GT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__GT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_GT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,389,null,389,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically decreasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._GT_)?fluree.db.dbfunctions.fns._GT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.count !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.count;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_count,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$count,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,258,null,258,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll], null)),"Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps",(cljs.core.truth_(fluree.db.dbfunctions.fns.count)?fluree.db.dbfunctions.fns.count.cljs$lang$test:null),"9 + count of objects in count"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nil_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nil_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nil_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nil_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,88,null,88,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if nil, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.nil_QMARK_)?fluree.db.dbfunctions.fns.nil_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objT !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objT;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objT,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objT,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,727,null,727,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all true flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objT)?fluree.db.dbfunctions.fns.objT.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.inc !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.inc;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_inc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$inc,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,534,null,534,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Increments any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.inc)?fluree.db.dbfunctions.fns.inc.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._SLASH_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__SLASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_SLASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,608,null,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence",(cljs.core.truth_(fluree.db.dbfunctions.fns._SLASH_)?fluree.db.dbfunctions.fns._SLASH_.cljs$lang$test:null),"9 + count of numbers in /"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.quot !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.quot;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_quot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$quot,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,621,null,621,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Quot[ient] of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.quot)?fluree.db.dbfunctions.fns.quot.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.flakes !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.flakes;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_flakes,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$flakes,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,751,null,751,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the flakes from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.flakes)?fluree.db.dbfunctions.fns.flakes.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,100,null,100,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"Takes a boolean, true returns false, false returns true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not)?fluree.db.dbfunctions.fns.not.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_sid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_sid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_sid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_sid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,171,null,171,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current subject id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_sid)?fluree.db.dbfunctions.fns._QMARK_sid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.uuid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.uuid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_uuid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$uuid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,779,null,779,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.uuid)?fluree.db.dbfunctions.fns.uuid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_user_id !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_user_id;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_user_id,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_user_id,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,1,697,null,697,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current user _id.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_user_id)?fluree.db.dbfunctions.fns._QMARK_user_id.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,415,null,415,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically non-decreasing order,\notherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT__EQ_)?fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.min !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.min;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_min,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$min,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,467,null,467,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets min value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.min)?fluree.db.dbfunctions.fns.min.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.ceil !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.ceil;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_ceil,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$ceil,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,789,null,789,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the ceiling of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.ceil)?fluree.db.dbfunctions.fns.ceil.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.if_else !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.if_else;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_if_DASH_else,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$if_DASH_else,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,75,null,75,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$test,cljs.core.cst$sym$t,cljs.core.cst$sym$f], null)),"Evaluates test.",(cljs.core.truth_(fluree.db.dbfunctions.fns.if_else)?fluree.db.dbfunctions.fns.if_else.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_pid !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_pid;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_pid,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_pid,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,190,null,190,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets current predicate id",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_pid)?fluree.db.dbfunctions.fns._QMARK_pid.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._PLUS_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._PLUS_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__PLUS_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_PLUS_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,569,null,569,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns sum of each argument.",(cljs.core.truth_(fluree.db.dbfunctions.fns._PLUS_)?fluree.db.dbfunctions.fns._PLUS_.cljs$lang$test:null),"9 + count of numbers in +"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._EQ__EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._EQ__EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__EQ__EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_EQ__EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,376,null,376,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Return true if arguments in sequence equal each other.",(cljs.core.truth_(fluree.db.dbfunctions.fns._EQ__EQ_)?fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.boolean$ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.boolean$;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_boolean,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$boolean,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,660,null,660,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$x], null)),"Coerce to boolean. Everything except false and nil is true.",(cljs.core.truth_(fluree.db.dbfunctions.fns.boolean$)?fluree.db.dbfunctions.fns.boolean$.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.max !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.max;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_max,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$max,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,454,null,454,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Gets max value from a sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.max)?fluree.db.dbfunctions.fns.max.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.empty_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.empty_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_empty_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$empty_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,111,null,111,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$arg], null)),"True if empty or #{nil}, else false.",(cljs.core.truth_(fluree.db.dbfunctions.fns.empty_QMARK_)?fluree.db.dbfunctions.fns.empty_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._STAR_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._STAR_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__STAR_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_STAR_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,595,null,595,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns product of all the numbers in the sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns._STAR_)?fluree.db.dbfunctions.fns._STAR_.cljs$lang$test:null),"9 + count of numbers in *"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.relationship_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.relationship_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_relationship_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$relationship_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",20,1,507,null,507,cljs.core.list(new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$startSubject,cljs.core.cst$sym$path,cljs.core.cst$sym$endSubject], null)),"Determines whether there is a relationship between two subjects",(cljs.core.truth_(fluree.db.dbfunctions.fns.relationship_QMARK_)?fluree.db.dbfunctions.fns.relationship_QMARK_.cljs$lang$test:null),"10, plus fuel cost"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_in !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_in;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_in,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_in,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",13,1,334,null,334,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Returns the value of a nested structure",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_in)?fluree.db.dbfunctions.fns.get_in.cljs$lang$test:null),"Length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.now !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.now;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_now,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$now,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,559,null,559,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Returns current epoch milliseconds on the executing machine.",(cljs.core.truth_(fluree.db.dbfunctions.fns.now)?fluree.db.dbfunctions.fns.now.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.dec !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.dec;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_dec,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$dec,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,546,null,546,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n], null)),"Decrements any number (or nil/null) by 1.",(cljs.core.truth_(fluree.db.dbfunctions.fns.dec)?fluree.db.dbfunctions.fns.dec.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.floor !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.floor;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_floor,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$floor,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,1,801,null,801,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$num], null)),"Takes the floor of a number",(cljs.core.truth_(fluree.db.dbfunctions.fns.floor)?fluree.db.dbfunctions.fns.floor.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.not_EQ_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.not_EQ_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_not_EQ_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$not_EQ_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,441,null,441,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if two (or more) values are not equal.",(cljs.core.truth_(fluree.db.dbfunctions.fns.not_EQ_)?fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,272,null,272,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$pred], null)),"Gets a value from an subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get)?fluree.db.dbfunctions.fns.get.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.str !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.str;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_str,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$str,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,123,null,123,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Concatenates all in sequence.",(cljs.core.truth_(fluree.db.dbfunctions.fns.str)?fluree.db.dbfunctions.fns.str.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._LT_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._LT_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_LT_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,402,null,402,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns non-nil if nums are in monotonically increasing order, otherwise false.",(cljs.core.truth_(fluree.db.dbfunctions.fns._LT_)?fluree.db.dbfunctions.fns._LT_.cljs$lang$test:null),"9 + number of arguments."]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__DASH_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_DASH_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",8,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,582,null,582,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns difference of all the numbers in the sequence with the first number as the minuend.",(cljs.core.truth_(fluree.db.dbfunctions.fns._)?fluree.db.dbfunctions.fns._.cljs$lang$test:null),"9 + count of numbers in -"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rand !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rand;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rand,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rand,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,3,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,3,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,763,null,763,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max], null),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$max,cljs.core.cst$sym$seed], null)),"Returns a random number, seed is either provided or a we use the txn instant",(cljs.core.truth_(fluree.db.dbfunctions.fns.rand)?fluree.db.dbfunctions.fns.rand.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.contains_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.contains_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_contains_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$contains_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",16,1,348,null,348,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns true if key is present.",(cljs.core.truth_(fluree.db.dbfunctions.fns.contains_QMARK_)?fluree.db.dbfunctions.fns.contains_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.hash_set !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.hash_set;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_hash_DASH_set,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$hash_DASH_set,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",15,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,362,null,362,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns a hash-set of values",(cljs.core.truth_(fluree.db.dbfunctions.fns.hash_set)?fluree.db.dbfunctions.fns.hash_set.cljs$lang$test:null),"9 + count of items in hash-set"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.valid_email_QMARK_ !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.valid_email_QMARK_;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_valid_DASH_email_QMARK_,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$valid_DASH_email_QMARK_,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",19,1,685,null,685,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$email], null)),"Determines whether an email is valid, based on its pattern",(cljs.core.truth_(fluree.db.dbfunctions.fns.valid_email_QMARK_)?fluree.db.dbfunctions.fns.valid_email_QMARK_.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_p !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_p;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_p,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_p,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,216,null,216,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current predicate predicates",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_p)?fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.nth !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.nth;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_nth,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$nth,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,60,null,60,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$coll,cljs.core.cst$sym$key], null)),"Returns the nth item in a collection",(cljs.core.truth_(fluree.db.dbfunctions.fns.nth)?fluree.db.dbfunctions.fns.nth.cljs$lang$test:null),"9 + count of objects in collection"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.subs !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.subs;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_subs,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$subs,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,135,null,135,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args], null)),"Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.",(cljs.core.truth_(fluree.db.dbfunctions.fns.subs)?fluree.db.dbfunctions.fns.subs.cljs$lang$test:null),(30)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.mod !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.mod;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_mod,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$mod,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,634,null,634,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Modulus of num and div. Truncates toward negative infinity.",(cljs.core.truth_(fluree.db.dbfunctions.fns.mod)?fluree.db.dbfunctions.fns.mod.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_s !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_s;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_s,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_s,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,2,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,2,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,203,null,203,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$additional_DASH_select], null)),"Gets current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_s)?fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$test:null),"10 if no lookup necessary, 10 plus fuel cost if lookup necessary"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.rem !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.rem;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_rem,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$rem,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",10,1,647,null,647,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$n,cljs.core.cst$sym$d], null)),"Remainder of dividing numerator by denominator.",(cljs.core.truth_(fluree.db.dbfunctions.fns.rem)?fluree.db.dbfunctions.fns.rem.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.query !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.query;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_query,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$query,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",12,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,false,cljs.core.cst$kw$fixed_DASH_arity,6,cljs.core.cst$kw$max_DASH_fixed_DASH_arity,6,cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null,null)], null),1,480,null,480,cljs.core.list(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$query_DASH_map], null),new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$select,cljs.core.cst$sym$from,cljs.core.cst$sym$where,cljs.core.cst$sym$block,cljs.core.cst$sym$limit], null)),"Executes a query",(cljs.core.truth_(fluree.db.dbfunctions.fns.query)?fluree.db.dbfunctions.fns.query.cljs$lang$test:null),"Fuel required for query"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns._QMARK_o !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns._QMARK_o;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__QMARK_o,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$_QMARK_o,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,1,290,null,290,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the object of an predicate from the current subject.",(cljs.core.truth_(fluree.db.dbfunctions.fns._QMARK_o)?fluree.db.dbfunctions.fns._QMARK_o.cljs$lang$test:null),(1)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.objF !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.objF;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_objF,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$objF,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",11,1,739,null,739,cljs.core.list(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx], null)),"Gets the summed object of all false flakes",(cljs.core.truth_(fluree.db.dbfunctions.fns.objF)?fluree.db.dbfunctions.fns.objF.cljs$lang$test:null),(10)]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.get_all !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.get_all;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_get_DASH_all,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$get_DASH_all,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,315,null,315,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$subject,cljs.core.cst$sym$path], null)),"Follows an subject down the provided path and returns a set of all matching subjects.",(cljs.core.truth_(fluree.db.dbfunctions.fns.get_all)?fluree.db.dbfunctions.fns.get_all.cljs$lang$test:null),"9 + length of path"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.or !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.or;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_or,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$top_DASH_fn,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$or,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",9,new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$variadic_QMARK_,true,cljs.core.cst$kw$fixed_DASH_arity,(1),cljs.core.cst$kw$max_DASH_fixed_DASH_arity,(1),cljs.core.cst$kw$method_DASH_params,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.list(cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$args)], null),cljs.core.cst$kw$arglists,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),cljs.core.cst$kw$arglists_DASH_meta,cljs.core.list(null)], null),1,245,null,245,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$_AMPERSAND_,cljs.core.cst$sym$args], null)),"Returns true if any in the sequence are true, else returns false",(cljs.core.truth_(fluree.db.dbfunctions.fns.or)?fluree.db.dbfunctions.fns.or.cljs$lang$test:null),"Count of objects in or"]))):null),(((typeof fluree !== 'undefined') && (typeof fluree.db !== 'undefined') && (typeof fluree.db.dbfunctions !== 'undefined') && (typeof fluree.db.dbfunctions.fns !== 'undefined') && (typeof fluree.db.dbfunctions.fns.re_find !== 'undefined'))?(new cljs.core.Var((function (){
return fluree.db.dbfunctions.fns.re_find;
}),cljs.core.with_meta(cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH_re_DASH_find,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$cljs$analyzer_SLASH_no_DASH_resolve,true], null)),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$ns,cljs.core.cst$kw$name,cljs.core.cst$kw$file,cljs.core.cst$kw$end_DASH_column,cljs.core.cst$kw$column,cljs.core.cst$kw$line,cljs.core.cst$kw$fdb_SLASH_spec,cljs.core.cst$kw$end_DASH_line,cljs.core.cst$kw$arglists,cljs.core.cst$kw$doc,cljs.core.cst$kw$test,cljs.core.cst$kw$fdb_SLASH_cost],[cljs.core.cst$sym$fluree$db$dbfunctions$fns,cljs.core.cst$sym$re_DASH_find,"/Volumes/Development/fluree/db/src/fluree/db/dbfunctions/fns.cljc",14,1,672,null,672,cljs.core.list(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$_QMARK_ctx,cljs.core.cst$sym$pattern,cljs.core.cst$sym$string], null)),"Execute a re-find operation of regex pattern on provided string.",(cljs.core.truth_(fluree.db.dbfunctions.fns.re_find)?fluree.db.dbfunctions.fns.re_find.cljs$lang$test:null),(10)]))):null)]);
fluree.db.dbfunctions.core.resolve_local_fn = (function fluree$db$dbfunctions$core$resolve_local_fn(f){
var map__72679 = cljs.core.meta(f);
var map__72679__$1 = cljs.core.__destructure_map(map__72679);
var spec = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72679__$1,cljs.core.cst$kw$fdb_SLASH_spec);
var arglists = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__72679__$1,cljs.core.cst$kw$arglists);
var arglist = cljs.core.first(arglists);
var _AMPERSAND_args_QMARK_ = (function (){var and__4210__auto__ = (function (){var G__72681 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("&");
var fexpr__72680 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__72680.cljs$core$IFn$_invoke$arity$1 ? fexpr__72680.cljs$core$IFn$_invoke$arity$1(G__72681) : fexpr__72680.call(null,G__72681));
})();
if(cljs.core.truth_(and__4210__auto__)){
var G__72683 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1("args");
var fexpr__72682 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,arglist);
return (fexpr__72682.cljs$core$IFn$_invoke$arity$1 ? fexpr__72682.cljs$core$IFn$_invoke$arity$1(G__72683) : fexpr__72682.call(null,G__72683));
} else {
return and__4210__auto__;
}
})();
var arity = ((cljs.core.not(_AMPERSAND_args_QMARK_))?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__72678_SHARP_){
return (cljs.core.count(p1__72678_SHARP_) - (1));
}),arglists)):null);
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$f,f,cljs.core.cst$kw$params,arglists,cljs.core.cst$kw$arity,arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,spec,cljs.core.cst$kw$code,null], null);
});
fluree.db.dbfunctions.core.build_fn = (function fluree$db$dbfunctions$core$build_fn(var$,fun){
return cljs.core.eval(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$cljs$core_SLASH_fn,null,(1),null)),(new cljs.core.List(null,cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$1((new cljs.core.List(null,var$,null,(1),null)))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,fun,null,(1),null))], 0)))));
});
fluree.db.dbfunctions.core.find_fn_STAR_ = (function fluree$db$dbfunctions$core$find_fn_STAR_(db,fn_name,funType){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72768){
var state_val_72769 = (state_72768[(1)]);
if((state_val_72769 === (7))){
var inst_72693 = cljs.core.deref(fluree.db.dbfunctions.core.db_fn_cache);
var inst_72694 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72695 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_72696 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_72697 = [fn_name,inst_72695,inst_72696];
var inst_72698 = (new cljs.core.PersistentVector(null,3,(5),inst_72694,inst_72697,null));
var inst_72699 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72693,inst_72698);
var state_72768__$1 = state_72768;
var statearr_72770_72807 = state_72768__$1;
(statearr_72770_72807[(2)] = inst_72699);

(statearr_72770_72807[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (1))){
var state_72768__$1 = state_72768;
var statearr_72771_72808 = state_72768__$1;
(statearr_72771_72808[(2)] = null);

(statearr_72771_72808[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (4))){
var inst_72684 = (state_72768[(2)]);
var state_72768__$1 = state_72768;
var statearr_72772_72809 = state_72768__$1;
(statearr_72772_72809[(2)] = inst_72684);

(statearr_72772_72809[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (15))){
var inst_72731 = (state_72768[(7)]);
var inst_72717 = (state_72768[(8)]);
var inst_72729 = (state_72768[(2)]);
var inst_72730 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72717,"_fn/params");
var inst_72731__$1 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_72730);
var inst_72732 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72717,"_fn/code");
var inst_72733 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(inst_72732);
var inst_72734 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_72733,funType,inst_72731__$1) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_72733,funType,inst_72731__$1));
var state_72768__$1 = (function (){var statearr_72773 = state_72768;
(statearr_72773[(9)] = inst_72729);

(statearr_72773[(7)] = inst_72731__$1);

return statearr_72773;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72768__$1,(16),inst_72734);
} else {
if((state_val_72769 === (13))){
var inst_72720 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([fn_name], 0));
var inst_72721 = ["Unknown function: ",inst_72720].join('');
var inst_72722 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_72723 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_72724 = cljs.core.PersistentHashMap.fromArrays(inst_72722,inst_72723);
var inst_72725 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72721,inst_72724);
var inst_72726 = (function(){throw inst_72725})();
var state_72768__$1 = state_72768;
var statearr_72774_72810 = state_72768__$1;
(statearr_72774_72810[(2)] = inst_72726);

(statearr_72774_72810[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (6))){
var state_72768__$1 = state_72768;
var statearr_72775_72811 = state_72768__$1;
(statearr_72775_72811[(2)] = null);

(statearr_72775_72811[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (17))){
var state_72768__$1 = state_72768;
var statearr_72776_72812 = state_72768__$1;
(statearr_72776_72812[(2)] = null);

(statearr_72776_72812[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (3))){
var inst_72766 = (state_72768[(2)]);
var state_72768__$1 = state_72768;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72768__$1,inst_72766);
} else {
if((state_val_72769 === (12))){
var inst_72717 = (state_72768[(8)]);
var inst_72716 = (state_72768[(2)]);
var inst_72717__$1 = fluree.db.util.async.throw_err(inst_72716);
var inst_72718 = cljs.core.empty_QMARK_(inst_72717__$1);
var state_72768__$1 = (function (){var statearr_72777 = state_72768;
(statearr_72777[(8)] = inst_72717__$1);

return statearr_72777;
})();
if(inst_72718){
var statearr_72778_72813 = state_72768__$1;
(statearr_72778_72813[(1)] = (13));

} else {
var statearr_72779_72814 = state_72768__$1;
(statearr_72779_72814[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (2))){
var inst_72690 = (state_72768[(10)]);
var _ = (function (){var statearr_72780 = state_72768;
(statearr_72780[(4)] = cljs.core.cons((5),(state_72768[(4)])));

return statearr_72780;
})();
var inst_72690__$1 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var state_72768__$1 = (function (){var statearr_72781 = state_72768;
(statearr_72781[(10)] = inst_72690__$1);

return statearr_72781;
})();
if(cljs.core.truth_(inst_72690__$1)){
var statearr_72782_72815 = state_72768__$1;
(statearr_72782_72815[(1)] = (6));

} else {
var statearr_72783_72816 = state_72768__$1;
(statearr_72783_72816[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (19))){
var inst_72751 = (state_72768[(11)]);
var inst_72761 = (state_72768[(2)]);
var state_72768__$1 = (function (){var statearr_72784 = state_72768;
(statearr_72784[(12)] = inst_72761);

return statearr_72784;
})();
var statearr_72785_72817 = state_72768__$1;
(statearr_72785_72817[(2)] = inst_72751);

(statearr_72785_72817[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (11))){
var inst_72763 = (state_72768[(2)]);
var _ = (function (){var statearr_72787 = state_72768;
(statearr_72787[(4)] = cljs.core.rest((state_72768[(4)])));

return statearr_72787;
})();
var state_72768__$1 = state_72768;
var statearr_72788_72818 = state_72768__$1;
(statearr_72788_72818[(2)] = inst_72763);

(statearr_72788_72818[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (9))){
var inst_72701 = (state_72768[(13)]);
var state_72768__$1 = state_72768;
var statearr_72789_72819 = state_72768__$1;
(statearr_72789_72819[(2)] = inst_72701);

(statearr_72789_72819[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (5))){
var _ = (function (){var statearr_72790 = state_72768;
(statearr_72790[(4)] = cljs.core.rest((state_72768[(4)])));

return statearr_72790;
})();
var state_72768__$1 = state_72768;
var ex72786 = (state_72768__$1[(2)]);
var statearr_72791_72820 = state_72768__$1;
(statearr_72791_72820[(5)] = ex72786);


if((ex72786 instanceof Error)){
var statearr_72792_72821 = state_72768__$1;
(statearr_72792_72821[(1)] = (4));

(statearr_72792_72821[(5)] = null);

} else {
throw ex72786;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (14))){
var state_72768__$1 = state_72768;
var statearr_72793_72822 = state_72768__$1;
(statearr_72793_72822[(2)] = null);

(statearr_72793_72822[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (16))){
var inst_72713 = (state_72768[(14)]);
var inst_72701 = (state_72768[(13)]);
var inst_72729 = (state_72768[(9)]);
var inst_72731 = (state_72768[(7)]);
var inst_72690 = (state_72768[(10)]);
var inst_72717 = (state_72768[(8)]);
var inst_72736 = (state_72768[(2)]);
var inst_72737 = fluree.db.util.async.throw_err(inst_72736);
var inst_72738 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_72717,"_fn/spec");
var inst_72739 = cljs.core.PersistentVector.EMPTY;
var inst_72740 = cljs.core.cst$sym$_QMARK_ctx;
var inst_72741 = (function (){var forward_time_travel_db_QMARK_ = inst_72690;
var or__4212__auto__ = inst_72701;
var query = inst_72713;
var res = inst_72717;
var _ = inst_72729;
var params = inst_72731;
var code = inst_72737;
var spec = inst_72738;
return (function (x){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(x);
});
})();
var inst_72742 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_72741,inst_72731);
var inst_72743 = cljs.core.cons(inst_72740,inst_72742);
var inst_72744 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_72739,inst_72743);
var inst_72745 = fluree.db.dbfunctions.core.build_fn(inst_72744,inst_72737);
var inst_72746 = [cljs.core.cst$kw$f,cljs.core.cst$kw$params,cljs.core.cst$kw$arity,cljs.core.cst$kw$_AMPERSAND_args_QMARK_,cljs.core.cst$kw$spec,cljs.core.cst$kw$code];
var inst_72747 = cljs.core.count(inst_72731);
var inst_72748 = [inst_72747];
var inst_72749 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_72748);
var inst_72750 = [inst_72745,inst_72731,inst_72749,false,inst_72738,null];
var inst_72751 = cljs.core.PersistentHashMap.fromArrays(inst_72746,inst_72750);
var state_72768__$1 = (function (){var statearr_72794 = state_72768;
(statearr_72794[(11)] = inst_72751);

return statearr_72794;
})();
if(cljs.core.truth_(inst_72690)){
var statearr_72795_72823 = state_72768__$1;
(statearr_72795_72823[(1)] = (17));

} else {
var statearr_72796_72824 = state_72768__$1;
(statearr_72796_72824[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (10))){
var inst_72713 = (state_72768[(14)]);
var inst_72704 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from];
var inst_72705 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72706 = ["_fn/params","_fn/code","_fn/spec"];
var inst_72707 = (new cljs.core.PersistentVector(null,3,(5),inst_72705,inst_72706,null));
var inst_72708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72709 = cljs.core.name(fn_name);
var inst_72710 = ["_fn/name",inst_72709];
var inst_72711 = (new cljs.core.PersistentVector(null,2,(5),inst_72708,inst_72710,null));
var inst_72712 = [inst_72707,inst_72711];
var inst_72713__$1 = cljs.core.PersistentHashMap.fromArrays(inst_72704,inst_72712);
var inst_72714 = fluree.db.dbproto._query.cljs$core$IFn$_invoke$arity$2(db,inst_72713__$1);
var state_72768__$1 = (function (){var statearr_72797 = state_72768;
(statearr_72797[(14)] = inst_72713__$1);

return statearr_72797;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72768__$1,(12),inst_72714);
} else {
if((state_val_72769 === (18))){
var inst_72751 = (state_72768[(11)]);
var inst_72754 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72755 = cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(db);
var inst_72756 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_72757 = [fn_name,inst_72755,inst_72756];
var inst_72758 = (new cljs.core.PersistentVector(null,3,(5),inst_72754,inst_72757,null));
var inst_72759 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(fluree.db.dbfunctions.core.db_fn_cache,cljs.core.assoc,inst_72758,inst_72751);
var state_72768__$1 = state_72768;
var statearr_72798_72825 = state_72768__$1;
(statearr_72798_72825[(2)] = inst_72759);

(statearr_72798_72825[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72769 === (8))){
var inst_72701 = (state_72768[(13)]);
var inst_72701__$1 = (state_72768[(2)]);
var state_72768__$1 = (function (){var statearr_72799 = state_72768;
(statearr_72799[(13)] = inst_72701__$1);

return statearr_72799;
})();
if(cljs.core.truth_(inst_72701__$1)){
var statearr_72800_72826 = state_72768__$1;
(statearr_72800_72826[(1)] = (9));

} else {
var statearr_72801_72827 = state_72768__$1;
(statearr_72801_72827[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0 = (function (){
var statearr_72802 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_72802[(0)] = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__);

(statearr_72802[(1)] = (1));

return statearr_72802;
});
var fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1 = (function (state_72768){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72768);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72803){var ex__16398__auto__ = e72803;
var statearr_72804_72828 = state_72768;
(statearr_72804_72828[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72768[(4)]))){
var statearr_72805_72829 = state_72768;
(statearr_72805_72829[(1)] = cljs.core.first((state_72768[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72830 = state_72768;
state_72768 = G__72830;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__ = function(state_72768){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1.call(this,state_72768);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$find_fn_STAR__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72806 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72806[(6)] = c__16469__auto__);

return statearr_72806;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.dbfunctions.core.find_fn = (function fluree$db$dbfunctions$core$find_fn(var_args){
var G__72832 = arguments.length;
switch (G__72832) {
case 2:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,fn_name){
return fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,fn_name,null);
}));

(fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_name,funType){
if(("nodejs" === cljs.core._STAR_target_STAR_)){
return fluree.db.dbfunctions.core.find_fn_STAR_(db,fn_name,funType);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("DB functions not yet supported in javascript!",cljs.core.PersistentArrayMap.EMPTY);

}
}));

(fluree.db.dbfunctions.core.find_fn.cljs$lang$maxFixedArity = 3);

/**
 * Given a collection of function strings, returns a combined function using the and function
 */
fluree.db.dbfunctions.core.combine_fns = (function fluree$db$dbfunctions$core$combine_fns(fn_str_coll){
if((cljs.core.count(fn_str_coll) > (1))){
return ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",fn_str_coll),")"].join('');
} else {
return cljs.core.first(fn_str_coll);
}
});
fluree.db.dbfunctions.core.symbol_whitelist = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 9, [cljs.core.cst$sym$_QMARK_pO,null,cljs.core.cst$sym$_QMARK_auth_id,null,cljs.core.cst$sym$sid,null,cljs.core.cst$sym$_QMARK_user_id,null,cljs.core.cst$sym$_QMARK_pid,null,cljs.core.cst$sym$_QMARK_a,null,cljs.core.cst$sym$_QMARK_db,null,cljs.core.cst$sym$_QMARK_s,null,cljs.core.cst$sym$_QMARK_o,null], null), null);
/**
 * Ensures contents of vector are allowed
 */
fluree.db.dbfunctions.core.parse_vector = (function fluree$db$dbfunctions$core$parse_vector(var_args){
var G__72836 = arguments.length;
switch (G__72836) {
case 2:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$2 = (function (db,vec){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,null,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$3 = (function (db,vec,funType){
return fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,vec,funType,null);
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4 = (function (db,vec,funType,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72966){
var state_val_72967 = (state_72966[(1)]);
if((state_val_72967 === (7))){
var inst_72961 = (state_72966[(2)]);
var _ = (function (){var statearr_72968 = state_72966;
(statearr_72968[(4)] = cljs.core.rest((state_72966[(4)])));

return statearr_72968;
})();
var state_72966__$1 = state_72966;
var statearr_72969_73049 = state_72966__$1;
(statearr_72969_73049[(2)] = inst_72961);

(statearr_72969_73049[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (20))){
var inst_72875 = (state_72966[(7)]);
var state_72966__$1 = state_72966;
var statearr_72970_73050 = state_72966__$1;
(statearr_72970_73050[(2)] = inst_72875);

(statearr_72970_73050[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (27))){
var inst_72862 = (state_72966[(8)]);
var inst_72888 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_72889 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72862)," used in function.",inst_72888].join('');
var inst_72890 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_72891 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_72892 = cljs.core.PersistentHashMap.fromArrays(inst_72890,inst_72891);
var inst_72893 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72889,inst_72892);
var inst_72894 = (function(){throw inst_72893})();
var state_72966__$1 = state_72966;
var statearr_72971_73051 = state_72966__$1;
(statearr_72971_73051[(2)] = inst_72894);

(statearr_72971_73051[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (1))){
var state_72966__$1 = state_72966;
var statearr_72972_73052 = state_72966__$1;
(statearr_72972_73052[(2)] = null);

(statearr_72972_73052[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (24))){
var inst_72885 = (state_72966[(9)]);
var inst_72885__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(funType,"functionDec");
var state_72966__$1 = (function (){var statearr_72973 = state_72966;
(statearr_72973[(9)] = inst_72885__$1);

return statearr_72973;
})();
if(inst_72885__$1){
var statearr_72974_73053 = state_72966__$1;
(statearr_72974_73053[(1)] = (26));

} else {
var statearr_72975_73054 = state_72966__$1;
(statearr_72975_73054[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (39))){
var inst_72862 = (state_72966[(8)]);
var inst_72922 = (inst_72862 == null);
var state_72966__$1 = state_72966;
if(cljs.core.truth_(inst_72922)){
var statearr_72976_73055 = state_72966__$1;
(statearr_72976_73055[(1)] = (42));

} else {
var statearr_72977_73056 = state_72966__$1;
(statearr_72977_73056[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (46))){
var state_72966__$1 = state_72966;
var statearr_72978_73057 = state_72966__$1;
(statearr_72978_73057[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (4))){
var inst_72837 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_72980_73058 = state_72966__$1;
(statearr_72980_73058[(2)] = inst_72837);

(statearr_72980_73058[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (15))){
var inst_72862 = (state_72966[(8)]);
var inst_72873 = (inst_72862 instanceof cljs.core.Symbol);
var state_72966__$1 = state_72966;
if(cljs.core.truth_(inst_72873)){
var statearr_72981_73059 = state_72966__$1;
(statearr_72981_73059[(1)] = (17));

} else {
var statearr_72982_73060 = state_72966__$1;
(statearr_72982_73060[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (48))){
var inst_72929 = (state_72966[(2)]);
var inst_72930 = fluree.db.util.async.throw_err(inst_72929);
var state_72966__$1 = state_72966;
var statearr_72983_73061 = state_72966__$1;
(statearr_72983_73061[(2)] = inst_72930);

(statearr_72983_73061[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (50))){
var state_72966__$1 = state_72966;
var statearr_72984_73062 = state_72966__$1;
(statearr_72984_73062[(2)] = null);

(statearr_72984_73062[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (21))){
var inst_72855 = (state_72966[(10)]);
var inst_72882 = (state_72966[(11)]);
var inst_72852 = (state_72966[(12)]);
var inst_72856 = (state_72966[(13)]);
var inst_72850 = (state_72966[(14)]);
var inst_72863 = (state_72966[(15)]);
var inst_72853 = (state_72966[(16)]);
var inst_72875 = (state_72966[(7)]);
var inst_72862 = (state_72966[(8)]);
var inst_72878 = [inst_72862];
var inst_72879 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_72878);
var inst_72880 = (function (){var x = inst_72862;
var first__72849 = inst_72852;
var G__72846 = inst_72855;
var seq__72848 = inst_72853;
var r = inst_72863;
var or__4212__auto__ = inst_72875;
var vec__72858 = inst_72855;
var first__72860 = inst_72862;
var acc = inst_72856;
var vec__72847 = inst_72850;
var seq__72859 = inst_72863;
return (function (p1__72834_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__72834_SHARP_);
});
})();
var inst_72881 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_72880,params);
var inst_72882__$1 = cljs.core.some(inst_72879,inst_72881);
var state_72966__$1 = (function (){var statearr_72985 = state_72966;
(statearr_72985[(11)] = inst_72882__$1);

return statearr_72985;
})();
if(cljs.core.truth_(inst_72882__$1)){
var statearr_72986_73063 = state_72966__$1;
(statearr_72986_73063[(1)] = (23));

} else {
var statearr_72987_73064 = state_72966__$1;
(statearr_72987_73064[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (31))){
var inst_72912 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
if(cljs.core.truth_(inst_72912)){
var statearr_72988_73065 = state_72966__$1;
(statearr_72988_73065[(1)] = (35));

} else {
var statearr_72989_73066 = state_72966__$1;
(statearr_72989_73066[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (32))){
var inst_72905 = (state_72966[(17)]);
var state_72966__$1 = state_72966;
var statearr_72990_73067 = state_72966__$1;
(statearr_72990_73067[(2)] = inst_72905);

(statearr_72990_73067[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (40))){
var inst_72947 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_72991_73068 = state_72966__$1;
(statearr_72991_73068[(2)] = inst_72947);

(statearr_72991_73068[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (33))){
var inst_72862 = (state_72966[(8)]);
var inst_72908 = (inst_72862 == null);
var state_72966__$1 = state_72966;
var statearr_72992_73069 = state_72966__$1;
(statearr_72992_73069[(2)] = inst_72908);

(statearr_72992_73069[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (13))){
var inst_72856 = (state_72966[(13)]);
var inst_72863 = (state_72966[(15)]);
var inst_72955 = (state_72966[(2)]);
var inst_72956 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_72856,inst_72955);
var inst_72855 = inst_72863;
var inst_72856__$1 = inst_72956;
var state_72966__$1 = (function (){var statearr_72993 = state_72966;
(statearr_72993[(10)] = inst_72855);

(statearr_72993[(13)] = inst_72856__$1);

return statearr_72993;
})();
var statearr_72994_73070 = state_72966__$1;
(statearr_72994_73070[(2)] = null);

(statearr_72994_73070[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (22))){
var inst_72900 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_72995_73071 = state_72966__$1;
(statearr_72995_73071[(2)] = inst_72900);

(statearr_72995_73071[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (36))){
var inst_72862 = (state_72966[(8)]);
var inst_72915 = cljs.core.vector_QMARK_(inst_72862);
var state_72966__$1 = state_72966;
if(inst_72915){
var statearr_72996_73072 = state_72966__$1;
(statearr_72996_73072[(1)] = (38));

} else {
var statearr_72997_73073 = state_72966__$1;
(statearr_72997_73073[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (41))){
var inst_72919 = (state_72966[(2)]);
var inst_72920 = fluree.db.util.async.throw_err(inst_72919);
var state_72966__$1 = state_72966;
var statearr_72998_73074 = state_72966__$1;
(statearr_72998_73074[(2)] = inst_72920);

(statearr_72998_73074[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (43))){
var inst_72862 = (state_72966[(8)]);
var inst_72925 = cljs.core.list_QMARK_(inst_72862);
var state_72966__$1 = state_72966;
if(inst_72925){
var statearr_72999_73075 = state_72966__$1;
(statearr_72999_73075[(1)] = (45));

} else {
var statearr_73000_73076 = state_72966__$1;
(statearr_73000_73076[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (29))){
var inst_72902 = (state_72966[(18)]);
var state_72966__$1 = state_72966;
var statearr_73001_73077 = state_72966__$1;
(statearr_73001_73077[(2)] = inst_72902);

(statearr_73001_73077[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (44))){
var inst_72945 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73002_73078 = state_72966__$1;
(statearr_73002_73078[(2)] = inst_72945);

(statearr_73002_73078[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (6))){
var inst_72855 = (state_72966[(10)]);
var inst_72862 = (state_72966[(8)]);
var inst_72861 = cljs.core.seq(inst_72855);
var inst_72862__$1 = cljs.core.first(inst_72861);
var inst_72863 = cljs.core.next(inst_72861);
var inst_72864 = (inst_72862__$1 == null);
var state_72966__$1 = (function (){var statearr_73003 = state_72966;
(statearr_73003[(15)] = inst_72863);

(statearr_73003[(8)] = inst_72862__$1);

return statearr_73003;
})();
if(cljs.core.truth_(inst_72864)){
var statearr_73004_73079 = state_72966__$1;
(statearr_73004_73079[(1)] = (8));

} else {
var statearr_73005_73080 = state_72966__$1;
(statearr_73005_73080[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (28))){
var inst_72896 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73006_73081 = state_72966__$1;
(statearr_73006_73081[(2)] = inst_72896);

(statearr_73006_73081[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (51))){
var inst_72941 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73007_73082 = state_72966__$1;
(statearr_73007_73082[(2)] = inst_72941);

(statearr_73007_73082[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (25))){
var inst_72898 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73008_73083 = state_72966__$1;
(statearr_73008_73083[(2)] = inst_72898);

(statearr_73008_73083[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (34))){
var inst_72910 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73009_73084 = state_72966__$1;
(statearr_73009_73084[(2)] = inst_72910);

(statearr_73009_73084[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (17))){
var inst_72875 = (state_72966[(7)]);
var inst_72862 = (state_72966[(8)]);
var inst_72875__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_72862) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_72862));
var state_72966__$1 = (function (){var statearr_73010 = state_72966;
(statearr_73010[(7)] = inst_72875__$1);

return statearr_73010;
})();
if(cljs.core.truth_(inst_72875__$1)){
var statearr_73011_73085 = state_72966__$1;
(statearr_73011_73085[(1)] = (20));

} else {
var statearr_73012_73086 = state_72966__$1;
(statearr_73012_73086[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (3))){
var inst_72964 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72966__$1,inst_72964);
} else {
if((state_val_72967 === (12))){
var inst_72862 = (state_72966[(8)]);
var inst_72870 = typeof inst_72862 === 'number';
var state_72966__$1 = state_72966;
if(cljs.core.truth_(inst_72870)){
var statearr_73013_73087 = state_72966__$1;
(statearr_73013_73087[(1)] = (14));

} else {
var statearr_73014_73088 = state_72966__$1;
(statearr_73014_73088[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (2))){
var inst_72850 = (state_72966[(14)]);
var _ = (function (){var statearr_73015 = state_72966;
(statearr_73015[(4)] = cljs.core.cons((5),(state_72966[(4)])));

return statearr_73015;
})();
var inst_72850__$1 = vec;
var inst_72851 = cljs.core.seq(inst_72850__$1);
var inst_72852 = cljs.core.first(inst_72851);
var inst_72853 = cljs.core.next(inst_72851);
var inst_72854 = cljs.core.PersistentVector.EMPTY;
var inst_72855 = inst_72850__$1;
var inst_72856 = inst_72854;
var state_72966__$1 = (function (){var statearr_73016 = state_72966;
(statearr_73016[(10)] = inst_72855);

(statearr_73016[(12)] = inst_72852);

(statearr_73016[(13)] = inst_72856);

(statearr_73016[(14)] = inst_72850__$1);

(statearr_73016[(16)] = inst_72853);

return statearr_73016;
})();
var statearr_73017_73089 = state_72966__$1;
(statearr_73017_73089[(2)] = null);

(statearr_73017_73089[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (23))){
var inst_72882 = (state_72966[(11)]);
var state_72966__$1 = state_72966;
var statearr_73018_73090 = state_72966__$1;
(statearr_73018_73090[(2)] = inst_72882);

(statearr_73018_73090[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (47))){
var inst_72943 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73019_73091 = state_72966__$1;
(statearr_73019_73091[(2)] = inst_72943);

(statearr_73019_73091[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (35))){
var inst_72862 = (state_72966[(8)]);
var state_72966__$1 = state_72966;
var statearr_73020_73092 = state_72966__$1;
(statearr_73020_73092[(2)] = inst_72862);

(statearr_73020_73092[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (19))){
var inst_72951 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73021_73093 = state_72966__$1;
(statearr_73021_73093[(2)] = inst_72951);

(statearr_73021_73093[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (11))){
var inst_72862 = (state_72966[(8)]);
var state_72966__$1 = state_72966;
var statearr_73023_73094 = state_72966__$1;
(statearr_73023_73094[(2)] = inst_72862);

(statearr_73023_73094[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (9))){
var inst_72862 = (state_72966[(8)]);
var inst_72867 = typeof inst_72862 === 'string';
var state_72966__$1 = state_72966;
if(cljs.core.truth_(inst_72867)){
var statearr_73024_73095 = state_72966__$1;
(statearr_73024_73095[(1)] = (11));

} else {
var statearr_73025_73096 = state_72966__$1;
(statearr_73025_73096[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (5))){
var _ = (function (){var statearr_73026 = state_72966;
(statearr_73026[(4)] = cljs.core.rest((state_72966[(4)])));

return statearr_73026;
})();
var state_72966__$1 = state_72966;
var ex73022 = (state_72966__$1[(2)]);
var statearr_73027_73097 = state_72966__$1;
(statearr_73027_73097[(5)] = ex73022);


if((ex73022 instanceof Error)){
var statearr_73028_73098 = state_72966__$1;
(statearr_73028_73098[(1)] = (4));

(statearr_73028_73098[(5)] = null);

} else {
throw ex73022;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (14))){
var inst_72862 = (state_72966[(8)]);
var state_72966__$1 = state_72966;
var statearr_73029_73099 = state_72966__$1;
(statearr_73029_73099[(2)] = inst_72862);

(statearr_73029_73099[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (45))){
var inst_72862 = (state_72966[(8)]);
var inst_72927 = (fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 ? fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_72862,funType,params) : fluree.db.dbfunctions.core.resolve_fn.call(null,db,inst_72862,funType,params));
var state_72966__$1 = state_72966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72966__$1,(48),inst_72927);
} else {
if((state_val_72967 === (26))){
var inst_72885 = (state_72966[(9)]);
var state_72966__$1 = state_72966;
var statearr_73030_73100 = state_72966__$1;
(statearr_73030_73100[(2)] = inst_72885);

(statearr_73030_73100[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (16))){
var inst_72953 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73031_73101 = state_72966__$1;
(statearr_73031_73101[(2)] = inst_72953);

(statearr_73031_73101[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (38))){
var inst_72862 = (state_72966[(8)]);
var inst_72917 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_72862,funType,params);
var state_72966__$1 = state_72966;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72966__$1,(41),inst_72917);
} else {
if((state_val_72967 === (30))){
var inst_72905 = (state_72966[(17)]);
var inst_72862 = (state_72966[(8)]);
var inst_72905__$1 = inst_72862 === false;
var state_72966__$1 = (function (){var statearr_73032 = state_72966;
(statearr_73032[(17)] = inst_72905__$1);

return statearr_73032;
})();
if(cljs.core.truth_(inst_72905__$1)){
var statearr_73033_73102 = state_72966__$1;
(statearr_73033_73102[(1)] = (32));

} else {
var statearr_73034_73103 = state_72966__$1;
(statearr_73034_73103[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (10))){
var inst_72959 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73035_73104 = state_72966__$1;
(statearr_73035_73104[(2)] = inst_72959);

(statearr_73035_73104[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (18))){
var inst_72902 = (state_72966[(18)]);
var inst_72862 = (state_72966[(8)]);
var inst_72902__$1 = inst_72862 === true;
var state_72966__$1 = (function (){var statearr_73036 = state_72966;
(statearr_73036[(18)] = inst_72902__$1);

return statearr_73036;
})();
if(cljs.core.truth_(inst_72902__$1)){
var statearr_73037_73105 = state_72966__$1;
(statearr_73037_73105[(1)] = (29));

} else {
var statearr_73038_73106 = state_72966__$1;
(statearr_73038_73106[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (42))){
var inst_72862 = (state_72966[(8)]);
var state_72966__$1 = state_72966;
var statearr_73039_73107 = state_72966__$1;
(statearr_73039_73107[(2)] = inst_72862);

(statearr_73039_73107[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (37))){
var inst_72949 = (state_72966[(2)]);
var state_72966__$1 = state_72966;
var statearr_73040_73108 = state_72966__$1;
(statearr_73040_73108[(2)] = inst_72949);

(statearr_73040_73108[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (8))){
var inst_72856 = (state_72966[(13)]);
var state_72966__$1 = state_72966;
var statearr_73041_73109 = state_72966__$1;
(statearr_73041_73109[(2)] = inst_72856);

(statearr_73041_73109[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72967 === (49))){
var inst_72862 = (state_72966[(8)]);
var inst_72933 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_72862], 0));
var inst_72934 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([vec], 0));
var inst_72935 = ["Illegal element (",inst_72933,") in vector: ",inst_72934,"."].join('');
var inst_72936 = cljs.core.PersistentHashMap.EMPTY;
var inst_72937 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_72935,inst_72936);
var inst_72938 = (function(){throw inst_72937})();
var state_72966__$1 = state_72966;
var statearr_73042_73110 = state_72966__$1;
(statearr_73042_73110[(2)] = inst_72938);

(statearr_73042_73110[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73043 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73043[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73043[(1)] = (1));

return statearr_73043;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_72966){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72966);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73044){var ex__16398__auto__ = e73044;
var statearr_73045_73111 = state_72966;
(statearr_73045_73111[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72966[(4)]))){
var statearr_73046_73112 = state_72966;
(statearr_73046_73112[(1)] = cljs.core.first((state_72966[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73113 = state_72966;
state_72966 = G__73113;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_72966){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_72966);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73047 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73047[(6)] = c__16469__auto__);

return statearr_73047;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.parse_vector.cljs$lang$maxFixedArity = 4);

/**
 * Looks up function in local-function map. If exists returns map of function details,
 *   if doesn't exist returns nil.
 */
fluree.db.dbfunctions.core.find_local_fn_STAR_ = (function fluree$db$dbfunctions$core$find_local_fn_STAR_(fn_name){
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.core.default_fn_map,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(fn_name));
if(cljs.core.truth_(temp__5753__auto__)){
var local_fn = temp__5753__auto__;
return fluree.db.dbfunctions.core.resolve_local_fn(local_fn);
} else {
return null;
}
});
fluree.db.dbfunctions.core.find_local_fn = cljs.core.memoize(fluree.db.dbfunctions.core.find_local_fn_STAR_);
/**
 * Resolves a full code form expression.
 */
fluree.db.dbfunctions.core.resolve_fn = (function fluree$db$dbfunctions$core$resolve_fn(var_args){
var G__73116 = arguments.length;
switch (G__73116) {
case 2:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$2 = (function (db,form){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,null,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,form,type){
return fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,form,type,null);
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,form,type,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73280){
var state_val_73281 = (state_73280[(1)]);
if((state_val_73281 === (7))){
var inst_73124 = (state_73280[(7)]);
var inst_73130 = fluree.db.dbfunctions.core.find_fn.cljs$core$IFn$_invoke$arity$3(db,inst_73124,type);
var state_73280__$1 = state_73280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73280__$1,(9),inst_73130);
} else {
if((state_val_73281 === (59))){
var inst_73173 = (state_73280[(8)]);
var inst_73244 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73173], 0));
var inst_73245 = (type.cljs$core$IFn$_invoke$arity$1 ? type.cljs$core$IFn$_invoke$arity$1(inst_73173) : type.call(null,inst_73173));
var inst_73246 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73247 = ["Illegal element (",inst_73244,cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73245),") in function argument: ",inst_73246,"."].join('');
var inst_73248 = cljs.core.PersistentHashMap.EMPTY;
var inst_73249 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73247,inst_73248);
var inst_73250 = (function(){throw inst_73249})();
var state_73280__$1 = state_73280;
var statearr_73282_73377 = state_73280__$1;
(statearr_73282_73377[(2)] = inst_73250);

(statearr_73282_73377[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (20))){
var inst_73179 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
if(cljs.core.truth_(inst_73179)){
var statearr_73283_73378 = state_73280__$1;
(statearr_73283_73378[(1)] = (21));

} else {
var statearr_73284_73379 = state_73280__$1;
(statearr_73284_73379[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (58))){
var inst_73240 = (state_73280[(2)]);
var inst_73241 = fluree.db.util.async.throw_err(inst_73240);
var state_73280__$1 = state_73280;
var statearr_73285_73380 = state_73280__$1;
(statearr_73285_73380[(2)] = inst_73241);

(statearr_73285_73380[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (60))){
var state_73280__$1 = state_73280;
var statearr_73286_73381 = state_73280__$1;
(statearr_73286_73381[(2)] = null);

(statearr_73286_73381[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (27))){
var inst_73185 = (state_73280[(2)]);
var inst_73186 = fluree.db.util.async.throw_err(inst_73185);
var state_73280__$1 = state_73280;
var statearr_73287_73382 = state_73280__$1;
(statearr_73287_73382[(2)] = inst_73186);

(statearr_73287_73382[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (1))){
var state_73280__$1 = state_73280;
var statearr_73288_73383 = state_73280__$1;
(statearr_73288_73383[(2)] = null);

(statearr_73288_73383[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (24))){
var inst_73173 = (state_73280[(8)]);
var inst_73183 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73173,type,params);
var state_73280__$1 = state_73280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73280__$1,(27),inst_73183);
} else {
if((state_val_73281 === (55))){
var inst_73173 = (state_73280[(8)]);
var inst_73238 = fluree.db.dbfunctions.core.parse_vector.cljs$core$IFn$_invoke$arity$4(db,inst_73173,type,params);
var state_73280__$1 = state_73280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73280__$1,(58),inst_73238);
} else {
if((state_val_73281 === (39))){
var inst_73221 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73289_73384 = state_73280__$1;
(statearr_73289_73384[(2)] = inst_73221);

(statearr_73289_73384[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (46))){
var inst_73223 = (state_73280[(9)]);
var state_73280__$1 = state_73280;
var statearr_73290_73385 = state_73280__$1;
(statearr_73290_73385[(2)] = inst_73223);

(statearr_73290_73385[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (4))){
var inst_73117 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73291_73386 = state_73280__$1;
(statearr_73291_73386[(2)] = inst_73117);

(statearr_73291_73386[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (54))){
var inst_73257 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73292_73387 = state_73280__$1;
(statearr_73292_73387[(2)] = inst_73257);

(statearr_73292_73387[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (15))){
var inst_73125 = (state_73280[(10)]);
var inst_73154 = (state_73280[(2)]);
var inst_73162 = cljs.core.seq(inst_73125);
var inst_73163 = cljs.core.first(inst_73162);
var inst_73164 = cljs.core.next(inst_73162);
var inst_73165 = cljs.core.PersistentVector.EMPTY;
var inst_73166 = inst_73125;
var inst_73167 = inst_73165;
var state_73280__$1 = (function (){var statearr_73293 = state_73280;
(statearr_73293[(11)] = inst_73154);

(statearr_73293[(12)] = inst_73167);

(statearr_73293[(13)] = inst_73163);

(statearr_73293[(14)] = inst_73164);

(statearr_73293[(15)] = inst_73166);

return statearr_73293;
})();
var statearr_73294_73388 = state_73280__$1;
(statearr_73294_73388[(2)] = null);

(statearr_73294_73388[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (48))){
var inst_73233 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
if(cljs.core.truth_(inst_73233)){
var statearr_73295_73389 = state_73280__$1;
(statearr_73295_73389[(1)] = (52));

} else {
var statearr_73296_73390 = state_73280__$1;
(statearr_73296_73390[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (50))){
var inst_73173 = (state_73280[(8)]);
var inst_73229 = (inst_73173 == null);
var state_73280__$1 = state_73280;
var statearr_73297_73391 = state_73280__$1;
(statearr_73297_73391[(2)] = inst_73229);

(statearr_73297_73391[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (21))){
var inst_73173 = (state_73280[(8)]);
var inst_73181 = cljs.core.list_QMARK_(inst_73173);
var state_73280__$1 = state_73280;
if(inst_73181){
var statearr_73298_73392 = state_73280__$1;
(statearr_73298_73392[(1)] = (24));

} else {
var statearr_73299_73393 = state_73280__$1;
(statearr_73299_73393[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (31))){
var inst_73173 = (state_73280[(8)]);
var state_73280__$1 = state_73280;
var statearr_73300_73394 = state_73280__$1;
(statearr_73300_73394[(2)] = inst_73173);

(statearr_73300_73394[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (32))){
var inst_73173 = (state_73280[(8)]);
var inst_73194 = (inst_73173 instanceof cljs.core.Symbol);
var state_73280__$1 = state_73280;
if(cljs.core.truth_(inst_73194)){
var statearr_73301_73395 = state_73280__$1;
(statearr_73301_73395[(1)] = (34));

} else {
var statearr_73302_73396 = state_73280__$1;
(statearr_73302_73396[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (40))){
var inst_73203 = (state_73280[(16)]);
var state_73280__$1 = state_73280;
var statearr_73303_73397 = state_73280__$1;
(statearr_73303_73397[(2)] = inst_73203);

(statearr_73303_73397[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (56))){
var state_73280__$1 = state_73280;
var statearr_73304_73398 = state_73280__$1;
(statearr_73304_73398[(1)] = (59));



return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (33))){
var inst_73261 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73306_73399 = state_73280__$1;
(statearr_73306_73399[(2)] = inst_73261);

(statearr_73306_73399[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (13))){
var inst_73126 = (state_73280[(17)]);
var inst_73124 = (state_73280[(7)]);
var inst_73138 = (state_73280[(18)]);
var inst_73148 = ["Incorrect arity for function ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73124),". Expected ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73138),", provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73126),"."].join('');
var inst_73149 = cljs.core.PersistentHashMap.EMPTY;
var inst_73150 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73148,inst_73149);
var inst_73151 = (function(){throw inst_73150})();
var state_73280__$1 = state_73280;
var statearr_73307_73400 = state_73280__$1;
(statearr_73307_73400[(2)] = inst_73151);

(statearr_73307_73400[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (22))){
var inst_73167 = (state_73280[(12)]);
var state_73280__$1 = state_73280;
var statearr_73308_73401 = state_73280__$1;
(statearr_73308_73401[(2)] = inst_73167);

(statearr_73308_73401[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (36))){
var inst_73259 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73309_73402 = state_73280__$1;
(statearr_73309_73402[(2)] = inst_73259);

(statearr_73309_73402[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (41))){
var inst_73206 = (state_73280[(19)]);
var inst_73206__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_73280__$1 = (function (){var statearr_73310 = state_73280;
(statearr_73310[(19)] = inst_73206__$1);

return statearr_73310;
})();
if(inst_73206__$1){
var statearr_73311_73403 = state_73280__$1;
(statearr_73311_73403[(1)] = (43));

} else {
var statearr_73312_73404 = state_73280__$1;
(statearr_73312_73404[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (43))){
var inst_73206 = (state_73280[(19)]);
var state_73280__$1 = state_73280;
var statearr_73313_73405 = state_73280__$1;
(statearr_73313_73405[(2)] = inst_73206);

(statearr_73313_73405[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (61))){
var inst_73253 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73314_73406 = state_73280__$1;
(statearr_73314_73406[(2)] = inst_73253);

(statearr_73314_73406[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (29))){
var inst_73173 = (state_73280[(8)]);
var inst_73191 = typeof inst_73173 === 'number';
var state_73280__$1 = state_73280;
if(cljs.core.truth_(inst_73191)){
var statearr_73315_73407 = state_73280__$1;
(statearr_73315_73407[(1)] = (31));

} else {
var statearr_73316_73408 = state_73280__$1;
(statearr_73316_73408[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (44))){
var inst_73173 = (state_73280[(8)]);
var inst_73209 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([form], 0));
var inst_73210 = ["Invalid symbol: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_73173)," used in function argument: ",inst_73209].join('');
var inst_73211 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73212 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73213 = cljs.core.PersistentHashMap.fromArrays(inst_73211,inst_73212);
var inst_73214 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73210,inst_73213);
var inst_73215 = (function(){throw inst_73214})();
var state_73280__$1 = state_73280;
var statearr_73317_73409 = state_73280__$1;
(statearr_73317_73409[(2)] = inst_73215);

(statearr_73317_73409[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (6))){
var inst_73127 = (state_73280[(20)]);
var state_73280__$1 = state_73280;
var statearr_73318_73410 = state_73280__$1;
(statearr_73318_73410[(2)] = inst_73127);

(statearr_73318_73410[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (28))){
var inst_73173 = (state_73280[(8)]);
var state_73280__$1 = state_73280;
var statearr_73319_73411 = state_73280__$1;
(statearr_73319_73411[(2)] = inst_73173);

(statearr_73319_73411[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (51))){
var inst_73231 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73320_73412 = state_73280__$1;
(statearr_73320_73412[(2)] = inst_73231);

(statearr_73320_73412[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (25))){
var inst_73173 = (state_73280[(8)]);
var inst_73188 = typeof inst_73173 === 'string';
var state_73280__$1 = state_73280;
if(cljs.core.truth_(inst_73188)){
var statearr_73321_73413 = state_73280__$1;
(statearr_73321_73413[(1)] = (28));

} else {
var statearr_73322_73414 = state_73280__$1;
(statearr_73322_73414[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (34))){
var inst_73173 = (state_73280[(8)]);
var inst_73196 = (state_73280[(21)]);
var inst_73196__$1 = (fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.symbol_whitelist.cljs$core$IFn$_invoke$arity$1(inst_73173) : fluree.db.dbfunctions.core.symbol_whitelist.call(null,inst_73173));
var state_73280__$1 = (function (){var statearr_73323 = state_73280;
(statearr_73323[(21)] = inst_73196__$1);

return statearr_73323;
})();
if(cljs.core.truth_(inst_73196__$1)){
var statearr_73324_73415 = state_73280__$1;
(statearr_73324_73415[(1)] = (37));

} else {
var statearr_73325_73416 = state_73280__$1;
(statearr_73325_73416[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (17))){
var inst_73137 = (state_73280[(22)]);
var inst_73272 = (state_73280[(2)]);
var inst_73273 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73274 = cljs.core.cons(inst_73273,inst_73272);
var inst_73275 = cljs.core.cons(inst_73137,inst_73274);
var _ = (function (){var statearr_73326 = state_73280;
(statearr_73326[(4)] = cljs.core.rest((state_73280[(4)])));

return statearr_73326;
})();
var state_73280__$1 = state_73280;
var statearr_73327_73417 = state_73280__$1;
(statearr_73327_73417[(2)] = inst_73275);

(statearr_73327_73417[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (3))){
var inst_73278 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73280__$1,inst_73278);
} else {
if((state_val_73281 === (12))){
var inst_73145 = (state_73280[(2)]);
var inst_73146 = cljs.core.not(inst_73145);
var state_73280__$1 = state_73280;
if(inst_73146){
var statearr_73328_73418 = state_73280__$1;
(statearr_73328_73418[(1)] = (13));

} else {
var statearr_73329_73419 = state_73280__$1;
(statearr_73329_73419[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (2))){
var inst_73124 = (state_73280[(7)]);
var inst_73127 = (state_73280[(20)]);
var inst_73125 = (state_73280[(10)]);
var _ = (function (){var statearr_73330 = state_73280;
(statearr_73330[(4)] = cljs.core.cons((5),(state_73280[(4)])));

return statearr_73330;
})();
var inst_73124__$1 = cljs.core.first(form);
var inst_73125__$1 = cljs.core.rest(form);
var inst_73126 = cljs.core.count(inst_73125__$1);
var inst_73127__$1 = (fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1 ? fluree.db.dbfunctions.core.find_local_fn.cljs$core$IFn$_invoke$arity$1(inst_73124__$1) : fluree.db.dbfunctions.core.find_local_fn.call(null,inst_73124__$1));
var state_73280__$1 = (function (){var statearr_73331 = state_73280;
(statearr_73331[(17)] = inst_73126);

(statearr_73331[(7)] = inst_73124__$1);

(statearr_73331[(20)] = inst_73127__$1);

(statearr_73331[(10)] = inst_73125__$1);

return statearr_73331;
})();
if(cljs.core.truth_(inst_73127__$1)){
var statearr_73332_73420 = state_73280__$1;
(statearr_73332_73420[(1)] = (6));

} else {
var statearr_73333_73421 = state_73280__$1;
(statearr_73333_73421[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (23))){
var inst_73270 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73334_73422 = state_73280__$1;
(statearr_73334_73422[(2)] = inst_73270);

(statearr_73334_73422[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (47))){
var inst_73226 = (state_73280[(23)]);
var inst_73173 = (state_73280[(8)]);
var inst_73226__$1 = inst_73173 === false;
var state_73280__$1 = (function (){var statearr_73335 = state_73280;
(statearr_73335[(23)] = inst_73226__$1);

return statearr_73335;
})();
if(cljs.core.truth_(inst_73226__$1)){
var statearr_73336_73423 = state_73280__$1;
(statearr_73336_73423[(1)] = (49));

} else {
var statearr_73337_73424 = state_73280__$1;
(statearr_73337_73424[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (35))){
var inst_73223 = (state_73280[(9)]);
var inst_73173 = (state_73280[(8)]);
var inst_73223__$1 = inst_73173 === true;
var state_73280__$1 = (function (){var statearr_73338 = state_73280;
(statearr_73338[(9)] = inst_73223__$1);

return statearr_73338;
})();
if(cljs.core.truth_(inst_73223__$1)){
var statearr_73339_73425 = state_73280__$1;
(statearr_73339_73425[(1)] = (46));

} else {
var statearr_73340_73426 = state_73280__$1;
(statearr_73340_73426[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (19))){
var inst_73173 = (state_73280[(8)]);
var inst_73177 = inst_73173 === false;
var state_73280__$1 = state_73280;
var statearr_73341_73427 = state_73280__$1;
(statearr_73341_73427[(2)] = inst_73177);

(statearr_73341_73427[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (57))){
var inst_73255 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73342_73428 = state_73280__$1;
(statearr_73342_73428[(2)] = inst_73255);

(statearr_73342_73428[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (11))){
var inst_73126 = (state_73280[(17)]);
var inst_73138 = (state_73280[(18)]);
var inst_73143 = (inst_73138.cljs$core$IFn$_invoke$arity$1 ? inst_73138.cljs$core$IFn$_invoke$arity$1(inst_73126) : inst_73138.call(null,inst_73126));
var state_73280__$1 = state_73280;
var statearr_73344_73429 = state_73280__$1;
(statearr_73344_73429[(2)] = inst_73143);

(statearr_73344_73429[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (9))){
var inst_73132 = (state_73280[(2)]);
var inst_73133 = fluree.db.util.async.throw_err(inst_73132);
var state_73280__$1 = state_73280;
var statearr_73345_73430 = state_73280__$1;
(statearr_73345_73430[(2)] = inst_73133);

(statearr_73345_73430[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (5))){
var _ = (function (){var statearr_73346 = state_73280;
(statearr_73346[(4)] = cljs.core.rest((state_73280[(4)])));

return statearr_73346;
})();
var state_73280__$1 = state_73280;
var ex73343 = (state_73280__$1[(2)]);
var statearr_73347_73431 = state_73280__$1;
(statearr_73347_73431[(5)] = ex73343);


if((ex73343 instanceof Error)){
var statearr_73348_73432 = state_73280__$1;
(statearr_73348_73432[(1)] = (4));

(statearr_73348_73432[(5)] = null);

} else {
throw ex73343;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (14))){
var state_73280__$1 = state_73280;
var statearr_73349_73433 = state_73280__$1;
(statearr_73349_73433[(2)] = null);

(statearr_73349_73433[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (45))){
var inst_73217 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73350_73434 = state_73280__$1;
(statearr_73350_73434[(2)] = inst_73217);

(statearr_73350_73434[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (53))){
var inst_73173 = (state_73280[(8)]);
var inst_73236 = cljs.core.vector_QMARK_(inst_73173);
var state_73280__$1 = state_73280;
if(inst_73236){
var statearr_73351_73435 = state_73280__$1;
(statearr_73351_73435[(1)] = (55));

} else {
var statearr_73352_73436 = state_73280__$1;
(statearr_73352_73436[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (26))){
var inst_73174 = (state_73280[(24)]);
var inst_73167 = (state_73280[(12)]);
var inst_73265 = (state_73280[(2)]);
var inst_73266 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_73167,inst_73265);
var inst_73166 = inst_73174;
var inst_73167__$1 = inst_73266;
var state_73280__$1 = (function (){var statearr_73353 = state_73280;
(statearr_73353[(12)] = inst_73167__$1);

(statearr_73353[(15)] = inst_73166);

return statearr_73353;
})();
var statearr_73354_73437 = state_73280__$1;
(statearr_73354_73437[(2)] = null);

(statearr_73354_73437[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (16))){
var inst_73173 = (state_73280[(8)]);
var inst_73166 = (state_73280[(15)]);
var inst_73172 = cljs.core.seq(inst_73166);
var inst_73173__$1 = cljs.core.first(inst_73172);
var inst_73174 = cljs.core.next(inst_73172);
var state_73280__$1 = (function (){var statearr_73355 = state_73280;
(statearr_73355[(24)] = inst_73174);

(statearr_73355[(8)] = inst_73173__$1);

return statearr_73355;
})();
if(cljs.core.truth_(inst_73173__$1)){
var statearr_73356_73438 = state_73280__$1;
(statearr_73356_73438[(1)] = (18));

} else {
var statearr_73357_73439 = state_73280__$1;
(statearr_73357_73439[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (38))){
var inst_73203 = (state_73280[(16)]);
var inst_73174 = (state_73280[(24)]);
var inst_73126 = (state_73280[(17)]);
var inst_73154 = (state_73280[(11)]);
var inst_73124 = (state_73280[(7)]);
var inst_73125 = (state_73280[(10)]);
var inst_73167 = (state_73280[(12)]);
var inst_73163 = (state_73280[(13)]);
var inst_73164 = (state_73280[(14)]);
var inst_73140 = (state_73280[(25)]);
var inst_73135 = (state_73280[(26)]);
var inst_73173 = (state_73280[(8)]);
var inst_73138 = (state_73280[(18)]);
var inst_73166 = (state_73280[(15)]);
var inst_73136 = (state_73280[(27)]);
var inst_73139 = (state_73280[(28)]);
var inst_73137 = (state_73280[(22)]);
var inst_73196 = (state_73280[(21)]);
var inst_73199 = [inst_73173];
var inst_73200 = cljs.core.PersistentHashSet.createAsIfByAssoc(inst_73199);
var inst_73201 = (function (){var first__73161 = inst_73163;
var arity = inst_73138;
var args_n = inst_73126;
var fn_map = inst_73135;
var vec__73159 = inst_73125;
var first__73171 = inst_73173;
var args = inst_73125;
var vec__73169 = inst_73166;
var r = inst_73174;
var or__4212__auto__ = inst_73196;
var _ = inst_73154;
var acc = inst_73167;
var G__73158 = inst_73166;
var arglist = inst_73139;
var fn_name = inst_73124;
var _AMPERSAND_args_QMARK_ = inst_73140;
var arg = inst_73173;
var seq__73170 = inst_73174;
var map__73123 = inst_73136;
var seq__73160 = inst_73164;
var f = inst_73137;
return (function (p1__73114_SHARP_){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(p1__73114_SHARP_);
});
})();
var inst_73202 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_73201,params);
var inst_73203__$1 = cljs.core.some(inst_73200,inst_73202);
var state_73280__$1 = (function (){var statearr_73358 = state_73280;
(statearr_73358[(16)] = inst_73203__$1);

return statearr_73358;
})();
if(cljs.core.truth_(inst_73203__$1)){
var statearr_73359_73440 = state_73280__$1;
(statearr_73359_73440[(1)] = (40));

} else {
var statearr_73360_73441 = state_73280__$1;
(statearr_73360_73441[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (30))){
var inst_73263 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73361_73442 = state_73280__$1;
(statearr_73361_73442[(2)] = inst_73263);

(statearr_73361_73442[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (10))){
var inst_73140 = (state_73280[(25)]);
var state_73280__$1 = state_73280;
var statearr_73362_73443 = state_73280__$1;
(statearr_73362_73443[(2)] = inst_73140);

(statearr_73362_73443[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (18))){
var inst_73173 = (state_73280[(8)]);
var state_73280__$1 = state_73280;
var statearr_73363_73444 = state_73280__$1;
(statearr_73363_73444[(2)] = inst_73173);

(statearr_73363_73444[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (52))){
var inst_73173 = (state_73280[(8)]);
var state_73280__$1 = state_73280;
var statearr_73364_73445 = state_73280__$1;
(statearr_73364_73445[(2)] = inst_73173);

(statearr_73364_73445[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (42))){
var inst_73219 = (state_73280[(2)]);
var state_73280__$1 = state_73280;
var statearr_73365_73446 = state_73280__$1;
(statearr_73365_73446[(2)] = inst_73219);

(statearr_73365_73446[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (37))){
var inst_73196 = (state_73280[(21)]);
var state_73280__$1 = state_73280;
var statearr_73366_73447 = state_73280__$1;
(statearr_73366_73447[(2)] = inst_73196);

(statearr_73366_73447[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (8))){
var inst_73140 = (state_73280[(25)]);
var inst_73135 = (state_73280[(26)]);
var inst_73136 = (state_73280[(27)]);
var inst_73135__$1 = (state_73280[(2)]);
var inst_73136__$1 = cljs.core.__destructure_map(inst_73135__$1);
var inst_73137 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73136__$1,cljs.core.cst$kw$f);
var inst_73138 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73136__$1,cljs.core.cst$kw$arity);
var inst_73139 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73136__$1,cljs.core.cst$kw$arglist);
var inst_73140__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_73136__$1,cljs.core.cst$kw$_AMPERSAND_args_QMARK_);
var state_73280__$1 = (function (){var statearr_73367 = state_73280;
(statearr_73367[(25)] = inst_73140__$1);

(statearr_73367[(26)] = inst_73135__$1);

(statearr_73367[(18)] = inst_73138);

(statearr_73367[(27)] = inst_73136__$1);

(statearr_73367[(28)] = inst_73139);

(statearr_73367[(22)] = inst_73137);

return statearr_73367;
})();
if(cljs.core.truth_(inst_73140__$1)){
var statearr_73368_73448 = state_73280__$1;
(statearr_73368_73448[(1)] = (10));

} else {
var statearr_73369_73449 = state_73280__$1;
(statearr_73369_73449[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73281 === (49))){
var inst_73226 = (state_73280[(23)]);
var state_73280__$1 = state_73280;
var statearr_73370_73450 = state_73280__$1;
(statearr_73370_73450[(2)] = inst_73226);

(statearr_73370_73450[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73371 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73371[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73371[(1)] = (1));

return statearr_73371;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_73280){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73280);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73372){var ex__16398__auto__ = e73372;
var statearr_73373_73451 = state_73280;
(statearr_73373_73451[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73280[(4)]))){
var statearr_73374_73452 = state_73280;
(statearr_73374_73452[(1)] = cljs.core.first((state_73280[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73453 = state_73280;
state_73280 = G__73453;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_73280){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_73280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73375 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73375[(6)] = c__16469__auto__);

return statearr_73375;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.resolve_fn.cljs$lang$maxFixedArity = 4);

fluree.db.dbfunctions.core.parse_fn = (function fluree$db$dbfunctions$core$parse_fn(var_args){
var G__73455 = arguments.length;
switch (G__73455) {
case 3:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$3 = (function (db,fn_str,type){
return fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,fn_str,type,null);
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4 = (function (db,fn_str,type,params){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73537){
var state_val_73538 = (state_73537[(1)]);
if((state_val_73538 === (7))){
var inst_73465 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"false");
var state_73537__$1 = state_73537;
var statearr_73539_73587 = state_73537__$1;
(statearr_73539_73587[(2)] = inst_73465);

(statearr_73539_73587[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (20))){
var inst_73515 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"functionDec");
var state_73537__$1 = state_73537;
var statearr_73540_73588 = state_73537__$1;
(statearr_73540_73588[(2)] = inst_73515);

(statearr_73540_73588[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (1))){
var state_73537__$1 = state_73537;
var statearr_73541_73589 = state_73537__$1;
(statearr_73541_73589[(2)] = null);

(statearr_73541_73589[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (24))){
var inst_73512 = (state_73537[(7)]);
var inst_73521 = cljs.core.eval(inst_73512);
var state_73537__$1 = state_73537;
var statearr_73543_73590 = state_73537__$1;
(statearr_73543_73590[(2)] = inst_73521);

(statearr_73543_73590[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (4))){
var inst_73456 = (state_73537[(2)]);
var state_73537__$1 = state_73537;
var statearr_73544_73591 = state_73537__$1;
(statearr_73544_73591[(2)] = inst_73456);

(statearr_73544_73591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (15))){
var _ = (function (){var statearr_73545 = state_73537;
(statearr_73545[(4)] = cljs.core.rest((state_73537[(4)])));

return statearr_73545;
})();
var state_73537__$1 = state_73537;
var ex73542 = (state_73537__$1[(2)]);
var statearr_73546_73592 = state_73537__$1;
(statearr_73546_73592[(5)] = ex73542);


var statearr_73547_73593 = state_73537__$1;
(statearr_73547_73593[(1)] = (14));

(statearr_73547_73593[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (21))){
var inst_73513 = (state_73537[(8)]);
var state_73537__$1 = state_73537;
var statearr_73548_73594 = state_73537__$1;
(statearr_73548_73594[(2)] = inst_73513);

(statearr_73548_73594[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (13))){
var inst_73530 = (state_73537[(2)]);
var state_73537__$1 = state_73537;
var statearr_73549_73595 = state_73537__$1;
(statearr_73549_73595[(2)] = inst_73530);

(statearr_73549_73595[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (22))){
var inst_73518 = (state_73537[(2)]);
var state_73537__$1 = state_73537;
if(cljs.core.truth_(inst_73518)){
var statearr_73550_73596 = state_73537__$1;
(statearr_73550_73596[(1)] = (23));

} else {
var statearr_73551_73597 = state_73537__$1;
(statearr_73551_73597[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (6))){
var inst_73462 = (state_73537[(9)]);
var state_73537__$1 = state_73537;
var statearr_73552_73598 = state_73537__$1;
(statearr_73552_73598[(2)] = inst_73462);

(statearr_73552_73598[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (25))){
var inst_73523 = (state_73537[(2)]);
var inst_73524 = [cljs.core.cst$kw$fnstr];
var inst_73525 = [fn_str];
var inst_73526 = cljs.core.PersistentHashMap.fromArrays(inst_73524,inst_73525);
var inst_73527 = cljs.core.with_meta(inst_73523,inst_73526);
var _ = (function (){var statearr_73553 = state_73537;
(statearr_73553[(4)] = cljs.core.rest((state_73537[(4)])));

return statearr_73553;
})();
var state_73537__$1 = state_73537;
var statearr_73554_73599 = state_73537__$1;
(statearr_73554_73599[(2)] = inst_73527);

(statearr_73554_73599[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (17))){
var inst_73488 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73489 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_fn];
var inst_73490 = cljs.core.PersistentHashMap.fromArrays(inst_73488,inst_73489);
var inst_73491 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Bad function",inst_73490);
var inst_73492 = (function(){throw inst_73491})();
var state_73537__$1 = state_73537;
var statearr_73555_73600 = state_73537__$1;
(statearr_73555_73600[(2)] = inst_73492);

(statearr_73555_73600[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (3))){
var inst_73535 = (state_73537[(2)]);
var state_73537__$1 = state_73537;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73537__$1,inst_73535);
} else {
if((state_val_73538 === (12))){
var _ = (function (){var statearr_73556 = state_73537;
(statearr_73556[(4)] = cljs.core.cons((15),(state_73537[(4)])));

return statearr_73556;
})();
var inst_73485 = cljs.core.re_matches(/(^\(.+\)$)/,fn_str);
var state_73537__$1 = state_73537;
if(cljs.core.truth_(inst_73485)){
var statearr_73557_73601 = state_73537__$1;
(statearr_73557_73601[(1)] = (16));

} else {
var statearr_73558_73602 = state_73537__$1;
(statearr_73558_73602[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (2))){
var inst_73462 = (state_73537[(9)]);
var _ = (function (){var statearr_73559 = state_73537;
(statearr_73559[(4)] = cljs.core.cons((5),(state_73537[(4)])));

return statearr_73559;
})();
var inst_73462__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fn_str,"true");
var state_73537__$1 = (function (){var statearr_73560 = state_73537;
(statearr_73560[(9)] = inst_73462__$1);

return statearr_73560;
})();
if(inst_73462__$1){
var statearr_73561_73603 = state_73537__$1;
(statearr_73561_73603[(1)] = (6));

} else {
var statearr_73562_73604 = state_73537__$1;
(statearr_73562_73604[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (23))){
var inst_73512 = (state_73537[(7)]);
var state_73537__$1 = state_73537;
var statearr_73563_73605 = state_73537__$1;
(statearr_73563_73605[(2)] = inst_73512);

(statearr_73563_73605[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (19))){
var inst_73513 = (state_73537[(8)]);
var inst_73498 = (state_73537[(2)]);
var inst_73499 = fluree.db.util.async.throw_err(inst_73498);
var inst_73500 = cljs.core.cst$sym$cljs$core_SLASH_fn;
var inst_73501 = (new cljs.core.List(null,inst_73500,null,(1),null));
var inst_73502 = cljs.core.cst$sym$_QMARK_ctx;
var inst_73503 = (new cljs.core.List(null,inst_73502,null,(1),null));
var inst_73504 = cljs.core.concat.cljs$core$IFn$_invoke$arity$1(inst_73503);
var inst_73505 = cljs.core.seq(inst_73504);
var inst_73506 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_73505);
var inst_73507 = cljs.core.vec(inst_73506);
var inst_73508 = (new cljs.core.List(null,inst_73507,null,(1),null));
var inst_73509 = (new cljs.core.List(null,inst_73499,null,(1),null));
var inst_73510 = cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(inst_73501,inst_73508,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_73509], 0));
var inst_73511 = cljs.core.seq(inst_73510);
var inst_73512 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(inst_73511);
var inst_73513__$1 = params;
var state_73537__$1 = (function (){var statearr_73564 = state_73537;
(statearr_73564[(8)] = inst_73513__$1);

(statearr_73564[(7)] = inst_73512);

return statearr_73564;
})();
if(cljs.core.truth_(inst_73513__$1)){
var statearr_73565_73606 = state_73537__$1;
(statearr_73565_73606[(1)] = (20));

} else {
var statearr_73566_73607 = state_73537__$1;
(statearr_73566_73607[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (11))){
var inst_73532 = (state_73537[(2)]);
var _ = (function (){var statearr_73568 = state_73537;
(statearr_73568[(4)] = cljs.core.rest((state_73537[(4)])));

return statearr_73568;
})();
var state_73537__$1 = state_73537;
var statearr_73569_73608 = state_73537__$1;
(statearr_73569_73608[(2)] = inst_73532);

(statearr_73569_73608[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (9))){
var inst_73469 = (function (){return (function (n){
return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
});
})();
var inst_73470 = fluree.db.dbfunctions.core.true_or_false = inst_73469;
var state_73537__$1 = state_73537;
var statearr_73570_73609 = state_73537__$1;
(statearr_73570_73609[(2)] = inst_73470);

(statearr_73570_73609[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (5))){
var _ = (function (){var statearr_73571 = state_73537;
(statearr_73571[(4)] = cljs.core.rest((state_73537[(4)])));

return statearr_73571;
})();
var state_73537__$1 = state_73537;
var ex73567 = (state_73537__$1[(2)]);
var statearr_73572_73610 = state_73537__$1;
(statearr_73572_73610[(5)] = ex73567);


if((ex73567 instanceof Error)){
var statearr_73573_73611 = state_73537__$1;
(statearr_73573_73611[(1)] = (4));

(statearr_73573_73611[(5)] = null);

} else {
throw ex73567;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (14))){
var inst_73472 = (state_73537[(2)]);
var inst_73473 = (function(){throw inst_73472})();
var inst_73474 = ["Error parsing function: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fn_str)].join('');
var inst_73475 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_73476 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_73477 = cljs.core.PersistentHashMap.fromArrays(inst_73475,inst_73476);
var inst_73478 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_73474,inst_73477);
var inst_73479 = (function(){throw inst_73478})();
var state_73537__$1 = (function (){var statearr_73574 = state_73537;
(statearr_73574[(10)] = inst_73473);

return statearr_73574;
})();
var statearr_73575_73612 = state_73537__$1;
(statearr_73575_73612[(2)] = inst_73479);

(statearr_73575_73612[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (16))){
var state_73537__$1 = state_73537;
var statearr_73576_73613 = state_73537__$1;
(statearr_73576_73613[(2)] = null);

(statearr_73576_73613[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (10))){
var state_73537__$1 = state_73537;
var statearr_73577_73614 = state_73537__$1;
(statearr_73577_73614[(2)] = null);

(statearr_73577_73614[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73538 === (18))){
var inst_73494 = (state_73537[(2)]);
var inst_73495 = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(fn_str);
var inst_73496 = fluree.db.dbfunctions.core.resolve_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73495,type,params);
var state_73537__$1 = (function (){var statearr_73578 = state_73537;
(statearr_73578[(11)] = inst_73494);

return statearr_73578;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73537__$1,(19),inst_73496);
} else {
if((state_val_73538 === (8))){
var inst_73467 = (state_73537[(2)]);
var state_73537__$1 = state_73537;
if(cljs.core.truth_(inst_73467)){
var statearr_73579_73615 = state_73537__$1;
(statearr_73579_73615[(1)] = (9));

} else {
var statearr_73580_73616 = state_73537__$1;
(statearr_73580_73616[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$state_machine__16395__auto____0 = (function (){
var statearr_73581 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_73581[(0)] = fluree$db$dbfunctions$core$state_machine__16395__auto__);

(statearr_73581[(1)] = (1));

return statearr_73581;
});
var fluree$db$dbfunctions$core$state_machine__16395__auto____1 = (function (state_73537){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73537);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73582){var ex__16398__auto__ = e73582;
var statearr_73583_73617 = state_73537;
(statearr_73583_73617[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73537[(4)]))){
var statearr_73584_73618 = state_73537;
(statearr_73584_73618[(1)] = cljs.core.first((state_73537[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73619 = state_73537;
state_73537 = G__73619;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$state_machine__16395__auto__ = function(state_73537){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$state_machine__16395__auto____1.call(this,state_73537);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$state_machine__16395__auto____0;
fluree$db$dbfunctions$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73585 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73585[(6)] = c__16469__auto__);

return statearr_73585;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.core.parse_fn.cljs$lang$maxFixedArity = 4);

/**
 * Executes a transaction function
 */
fluree.db.dbfunctions.core.execute_tx_fn = (function fluree$db$dbfunctions$core$execute_tx_fn(db,auth_id,credits,s,p,o,fuel,block_instant){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_73647){
var state_val_73648 = (state_73647[(1)]);
if((state_val_73648 === (7))){
var inst_73634 = (state_73647[(7)]);
var state_73647__$1 = state_73647;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73647__$1,(10),inst_73634);
} else {
if((state_val_73648 === (1))){
var state_73647__$1 = state_73647;
var statearr_73649_73669 = state_73647__$1;
(statearr_73649_73669[(2)] = null);

(statearr_73649_73669[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (4))){
var inst_73620 = (state_73647[(2)]);
var state_73647__$1 = state_73647;
var statearr_73650_73670 = state_73647__$1;
(statearr_73650_73670[(2)] = inst_73620);

(statearr_73650_73670[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (6))){
var inst_73629 = (state_73647[(8)]);
var inst_73634 = (state_73647[(7)]);
var inst_73632 = (state_73647[(2)]);
var inst_73633 = fluree.db.util.async.throw_err(inst_73632);
var inst_73634__$1 = (inst_73633.cljs$core$IFn$_invoke$arity$1 ? inst_73633.cljs$core$IFn$_invoke$arity$1(inst_73629) : inst_73633.call(null,inst_73629));
var inst_73635 = fluree.db.util.async.channel_QMARK_(inst_73634__$1);
var state_73647__$1 = (function (){var statearr_73651 = state_73647;
(statearr_73651[(7)] = inst_73634__$1);

return statearr_73651;
})();
if(inst_73635){
var statearr_73652_73671 = state_73647__$1;
(statearr_73652_73671[(1)] = (7));

} else {
var statearr_73653_73672 = state_73647__$1;
(statearr_73653_73672[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (3))){
var inst_73645 = (state_73647[(2)]);
var state_73647__$1 = state_73647;
return cljs.core.async.impl.ioc_helpers.return_chan(state_73647__$1,inst_73645);
} else {
if((state_val_73648 === (2))){
var _ = (function (){var statearr_73655 = state_73647;
(statearr_73655[(4)] = cljs.core.cons((5),(state_73647[(4)])));

return statearr_73655;
})();
var inst_73626 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(o,(1));
var inst_73627 = [cljs.core.cst$kw$db,cljs.core.cst$kw$instant,cljs.core.cst$kw$sid,cljs.core.cst$kw$pid,cljs.core.cst$kw$auth_id,cljs.core.cst$kw$state];
var inst_73628 = [db,block_instant,s,p,auth_id,fuel];
var inst_73629 = cljs.core.PersistentHashMap.fromArrays(inst_73627,inst_73628);
var inst_73630 = fluree.db.dbfunctions.core.parse_fn.cljs$core$IFn$_invoke$arity$4(db,inst_73626,"txn",null);
var state_73647__$1 = (function (){var statearr_73656 = state_73647;
(statearr_73656[(8)] = inst_73629);

return statearr_73656;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_73647__$1,(6),inst_73630);
} else {
if((state_val_73648 === (9))){
var inst_73642 = (state_73647[(2)]);
var _ = (function (){var statearr_73657 = state_73647;
(statearr_73657[(4)] = cljs.core.rest((state_73647[(4)])));

return statearr_73657;
})();
var state_73647__$1 = state_73647;
var statearr_73658_73673 = state_73647__$1;
(statearr_73658_73673[(2)] = inst_73642);

(statearr_73658_73673[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (5))){
var _ = (function (){var statearr_73659 = state_73647;
(statearr_73659[(4)] = cljs.core.rest((state_73647[(4)])));

return statearr_73659;
})();
var state_73647__$1 = state_73647;
var ex73654 = (state_73647__$1[(2)]);
var statearr_73660_73674 = state_73647__$1;
(statearr_73660_73674[(5)] = ex73654);


if((ex73654 instanceof Error)){
var statearr_73661_73675 = state_73647__$1;
(statearr_73661_73675[(1)] = (4));

(statearr_73661_73675[(5)] = null);

} else {
throw ex73654;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (10))){
var inst_73638 = (state_73647[(2)]);
var inst_73639 = fluree.db.util.async.throw_err(inst_73638);
var state_73647__$1 = state_73647;
var statearr_73662_73676 = state_73647__$1;
(statearr_73662_73676[(2)] = inst_73639);

(statearr_73662_73676[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_73648 === (8))){
var inst_73634 = (state_73647[(7)]);
var state_73647__$1 = state_73647;
var statearr_73663_73677 = state_73647__$1;
(statearr_73663_73677[(2)] = inst_73634);

(statearr_73663_73677[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0 = (function (){
var statearr_73664 = [null,null,null,null,null,null,null,null,null];
(statearr_73664[(0)] = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__);

(statearr_73664[(1)] = (1));

return statearr_73664;
});
var fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1 = (function (state_73647){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_73647);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e73665){var ex__16398__auto__ = e73665;
var statearr_73666_73678 = state_73647;
(statearr_73666_73678[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_73647[(4)]))){
var statearr_73667_73679 = state_73647;
(statearr_73667_73679[(1)] = cljs.core.first((state_73647[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__73680 = state_73647;
state_73647 = G__73680;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__ = function(state_73647){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1.call(this,state_73647);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$core$execute_tx_fn_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_73668 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_73668[(6)] = c__16469__auto__);

return statearr_73668;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
