// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.flake');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.constants');
fluree.db.flake.MAX_COLLECTION_ID = (511);
fluree.db.flake.MAX_COLL_SUBJECTS = ((17592186044415) - (1));



fluree.db.flake.lshift = (function fluree$db$flake$lshift(n,bits){
return (n * Math.pow((2),bits));
});
/**
 * Converts a collection id and a number (n) into a subject-id.
 */
fluree.db.flake.__GT_sid = (function fluree$db$flake$__GT_sid(cid,n){
return (fluree.db.flake.lshift(cid,(44)) + n);
});
/**
 * Like ->sid, but checks that cid and n are within allowable range.
 */
fluree.db.flake.__GT_sid_checked = (function fluree$db$flake$__GT_sid_checked(cid,n){
if(((((0) < cid)) && ((cid < (511))))){
} else {
throw (new Error(["Assert failed: ",["Collection id is out of allowable range of 0 - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1((511))].join(''),"\n","(< 0 cid MAX-COLLECTION-ID)"].join('')));
}

if(((((0) < n)) && ((n < fluree.db.flake.MAX_COLL_SUBJECTS)))){
} else {
throw (new Error(["Assert failed: ",["Subject number is out of allowable range of 0 - ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.flake.MAX_COLL_SUBJECTS)].join(''),"\n","(< 0 n MAX-COLL-SUBJECTS)"].join('')));
}

return fluree.db.flake.__GT_sid(cid,n);
});
/**
 * For a given collection id, returns the min subject id that is allowed.
 */
fluree.db.flake.min_subject_id = (function fluree$db$flake$min_subject_id(cid){
return fluree.db.flake.__GT_sid(cid,(0));
});
/**
 * For a given collection id, returns the max subject id that is allowed.
 */
fluree.db.flake.max_subject_id = (function fluree$db$flake$max_subject_id(cid){
return fluree.db.flake.__GT_sid(cid,fluree.db.flake.MAX_COLL_SUBJECTS);
});
fluree.db.flake.MIN_PREDICATE_ID = fluree.db.flake.min_subject_id((0));
fluree.db.flake.MAX_PREDICATE_ID = fluree.db.flake.max_subject_id((0));
/**
 * Will return a collection id from a subject-id.
 */
fluree.db.flake.sid__GT_cid = (function fluree$db$flake$sid__GT_cid(sid){
return Math.floor(fluree.db.flake.lshift(sid,(-44)));
});
/**
 * Returns the subject index from a subject-id.
 */
fluree.db.flake.sid__GT_i = (function fluree$db$flake$sid__GT_i(sid){
return (sid - fluree.db.flake.lshift(fluree.db.flake.sid__GT_cid(sid),(44)));
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.ILookup}
*/
fluree.db.flake.Flake = (function (s,p,o,t,op,m){
this.s = s;
this.p = p;
this.o = o;
this.t = t;
this.op = op;
this.m = m;
this.cljs$lang$protocol_mask$partition0$ = 2162164496;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(fluree.db.flake.Flake.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,k){
var self__ = this;
var this$__$1 = this;
return (fluree.db.flake.get_flake_val.cljs$core$IFn$_invoke$arity$3 ? fluree.db.flake.get_flake_val.cljs$core$IFn$_invoke$arity$3(this$__$1,k,null) : fluree.db.flake.get_flake_val.call(null,this$__$1,k,null));
}));

(fluree.db.flake.Flake.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this$,k,not_found){
var self__ = this;
var this$__$1 = this;
return (fluree.db.flake.get_flake_val.cljs$core$IFn$_invoke$arity$3 ? fluree.db.flake.get_flake_val.cljs$core$IFn$_invoke$arity$3(this$__$1,k,not_found) : fluree.db.flake.get_flake_val.call(null,this$__$1,k,not_found));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,i){
var self__ = this;
var this$__$1 = this;
return (fluree.db.flake.nth_flake.cljs$core$IFn$_invoke$arity$3 ? fluree.db.flake.nth_flake.cljs$core$IFn$_invoke$arity$3(this$__$1,i,null) : fluree.db.flake.nth_flake.call(null,this$__$1,i,null));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,i,not_found){
var self__ = this;
var this$__$1 = this;
return (fluree.db.flake.nth_flake.cljs$core$IFn$_invoke$arity$3 ? fluree.db.flake.nth_flake.cljs$core$IFn$_invoke$arity$3(this$__$1,i,not_found) : fluree.db.flake.nth_flake.call(null,this$__$1,i,not_found));
}));

(fluree.db.flake.Flake.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.List(null,this$__$1.s,(new cljs.core.List(null,this$__$1.p,(new cljs.core.List(null,this$__$1.o,(new cljs.core.List(null,this$__$1.t,(new cljs.core.List(null,this$__$1.op,(new cljs.core.List(null,this$__$1.m,null,(1),null)),(2),null)),(3),null)),(4),null)),(5),null)),(6),null));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash(cljs.core.seq(this$__$1));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,o__$1){
var self__ = this;
var this$__$1 = this;
var and__4210__auto__ = (o__$1 instanceof fluree.db.flake.Flake);
if(and__4210__auto__){
return (fluree.db.flake.equiv_flake.cljs$core$IFn$_invoke$arity$2 ? fluree.db.flake.equiv_flake.cljs$core$IFn$_invoke$arity$2(this$__$1,o__$1) : fluree.db.flake.equiv_flake.call(null,this$__$1,o__$1));
} else {
return and__4210__auto__;
}
}));

(fluree.db.flake.Flake.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,k,v){
var self__ = this;
var this$__$1 = this;
return (fluree.db.flake.assoc_flake.cljs$core$IFn$_invoke$arity$3 ? fluree.db.flake.assoc_flake.cljs$core$IFn$_invoke$arity$3(this$__$1,k,v) : fluree.db.flake.assoc_flake.call(null,this$__$1,k,v));
}));

(fluree.db.flake.Flake.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (f,writer,opts){
var self__ = this;
var f__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#Flake ["," ","]",opts,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [f__$1.s,f__$1.p,f__$1.o,f__$1.t,f__$1.op,f__$1.m], null));
}));

(fluree.db.flake.Flake.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$s,cljs.core.cst$sym$p,cljs.core.cst$sym$o,cljs.core.cst$sym$t,cljs.core.cst$sym$op,cljs.core.cst$sym$m], null);
}));

(fluree.db.flake.Flake.cljs$lang$type = true);

(fluree.db.flake.Flake.cljs$lang$ctorStr = "fluree.db.flake/Flake");

(fluree.db.flake.Flake.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"fluree.db.flake/Flake");
}));

/**
 * Positional factory function for fluree.db.flake/Flake.
 */
fluree.db.flake.__GT_Flake = (function fluree$db$flake$__GT_Flake(s,p,o,t,op,m){
return (new fluree.db.flake.Flake(s,p,o,t,op,m));
});

fluree.db.flake.equiv_flake = (function fluree$db$flake$equiv_flake(f,o){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.s,o.s)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,o.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,o.o)))));
});
/**
 * Used primarily to generate flakes for comparator. If you wish to
 *   generate a flake for other purposes, be sure to supply all components.
 */
fluree.db.flake.parts__GT_Flake = (function fluree$db$flake$parts__GT_Flake(var_args){
var G__28641 = arguments.length;
switch (G__28641) {
case 1:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1 = (function (p__28642){
var vec__28643 = p__28642;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28643,(5),null);
return fluree.db.flake.__GT_Flake(s,p,o,t,op,m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$2 = (function (p__28646,default_tx){
var vec__28647 = p__28646;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28647,(5),null);
return fluree.db.flake.__GT_Flake(s,p,o,(function (){var or__4212__auto__ = t;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default_tx;
}
})(),op,m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$3 = (function (p__28650,default_tx,default_op){
var vec__28651 = p__28650;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28651,(5),null);
return fluree.db.flake.__GT_Flake(s,p,o,(function (){var or__4212__auto__ = t;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default_tx;
}
})(),(function (){var or__4212__auto__ = op;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return default_op;
}
})(),m);
}));

(fluree.db.flake.parts__GT_Flake.cljs$lang$maxFixedArity = 3);

fluree.db.flake.Flake__GT_parts = (function fluree$db$flake$Flake__GT_parts(flake){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [flake.s,flake.p,flake.o,flake.t,flake.op,flake.m], null);
});
/**
 * Assoc for Flakes
 */
fluree.db.flake.assoc_flake = (function fluree$db$flake$assoc_flake(flake,k,v){
var vec__28655 = fluree.db.flake.Flake__GT_parts(flake);
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28655,(5),null);
var G__28658 = k;
var G__28658__$1 = (((G__28658 instanceof cljs.core.Keyword))?G__28658.fqn:null);
switch (G__28658__$1) {
case "s":
return fluree.db.flake.__GT_Flake(v,p,o,t,op,m);

break;
case "p":
return fluree.db.flake.__GT_Flake(s,v,o,t,op,m);

break;
case "o":
return fluree.db.flake.__GT_Flake(s,p,v,t,op,m);

break;
case "t":
return fluree.db.flake.__GT_Flake(s,p,o,v,op,m);

break;
case "op":
return fluree.db.flake.__GT_Flake(s,p,o,t,v,m);

break;
case "m":
return fluree.db.flake.__GT_Flake(s,p,o,t,op,v);

break;
default:
throw (new Error(["Flake does not contain key: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(k)].join('')));

}
});
fluree.db.flake.get_flake_val = (function fluree$db$flake$get_flake_val(flake,k,not_found){
var G__28660 = k;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("s",G__28660)){
return flake.s;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$o,G__28660)){
return flake.o;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("p",G__28660)){
return flake.p;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$m,G__28660)){
return flake.m;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$op,G__28660)){
return flake.op;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$s,G__28660)){
return flake.s;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("t",G__28660)){
return flake.t;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,G__28660)){
return flake.t;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("op",G__28660)){
return flake.op;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("m",G__28660)){
return flake.m;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,G__28660)){
return flake.p;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("o",G__28660)){
return flake.o;
} else {
return not_found;

}
}
}
}
}
}
}
}
}
}
}
}
});
/**
 * Gets position i in flake.
 */
fluree.db.flake.nth_flake = (function fluree$db$flake$nth_flake(flake,i,not_found){
var ii = (i | (0));
var G__28661 = ii;
switch (G__28661) {
case (0):
return flake.s;

break;
case (1):
return flake.p;

break;
case (2):
return flake.o;

break;
case (3):
return flake.t;

break;
case (4):
return flake.op;

break;
case (5):
return flake.m;

break;
default:
var or__4212__auto__ = not_found;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw (new Error(["Index ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(i)," out of bounds for flake: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(flake)].join('')));
}

}
});
fluree.db.flake.cmp_val = (function fluree$db$flake$cmp_val(o1,o2){
if((((!((o1 == null)))) && ((!((o2 == null)))))){
return cljs.core.compare(o1,o2);
} else {
return (0);
}
});
fluree.db.flake.cc_cmp_class = (function fluree$db$flake$cc_cmp_class(x){
if(typeof x === 'string'){
return "string";
} else {
return "number";
}
});
fluree.db.flake.cmp_val_xtype = (function fluree$db$flake$cmp_val_xtype(o1,o2){
if((((!((o1 == null)))) && ((!((o2 == null)))))){
var o1_str = fluree.db.flake.cc_cmp_class(o1);
var o2_str = fluree.db.flake.cc_cmp_class(o2);
var type_cmp = cljs.core.compare(o1_str,o2_str);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),type_cmp)){
return cljs.core.compare(o1,o2);
} else {
return type_cmp;
}
} else {
return (0);
}
});
fluree.db.flake.cmp_bool = (function fluree$db$flake$cmp_bool(b1,b2){
if(((cljs.core.boolean_QMARK_(b1)) && (cljs.core.boolean_QMARK_(b2)))){
return cljs.core.compare(b1,b2);
} else {
return (0);
}
});
/**
 * Meta will always be a map or nil, but can be searched using an integer to
 *   perform effective range scans if needed.
 *   i.e. (Integer/MIN_VALUE) to (Integer/MAX_VALUE) will always include all meta values.
 */
fluree.db.flake.cmp_meta = (function fluree$db$flake$cmp_meta(m1,m2){
var m1h = ((cljs.core.int_QMARK_(m1))?m1:cljs.core.hash(m1));
var m2h = ((cljs.core.int_QMARK_(m2))?m2:cljs.core.hash(m2));
return (m1h - m2h);
});
fluree.db.flake.cmp_pred = (function fluree$db$flake$cmp_pred(p1,p2){
if(cljs.core.truth_((function (){var and__4210__auto__ = p1;
if(cljs.core.truth_(and__4210__auto__)){
return p2;
} else {
return and__4210__auto__;
}
})())){
return (p1 - p2);
} else {
return (0);
}
});
fluree.db.flake.cmp_long = (function fluree$db$flake$cmp_long(l1,l2){
if(cljs.core.truth_((function (){var and__4210__auto__ = l1;
if(cljs.core.truth_(and__4210__auto__)){
return l2;
} else {
return and__4210__auto__;
}
})())){
return (l1 - l2);
} else {
return (0);
}
});
fluree.db.flake.cmp_flakes_spot = (function fluree$db$flake$cmp_flakes_spot(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_val(f1.o,f2.o);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$3)){
return (0);
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_psot = (function fluree$db$flake$cmp_flakes_psot(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_val(f1.o,f2.o);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$3)){
return (0);
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_post = (function fluree$db$flake$cmp_flakes_post(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_val(f1.o,f2.o);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$3)){
return (0);
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_opst = (function fluree$db$flake$cmp_flakes_opst(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f2.o,f1.o);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_long(f1.p,f2.p);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$3)){
return (0);
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_spot_novelty = (function fluree$db$flake$cmp_flakes_spot_novelty(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_val_xtype(f1.o,f2.o);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_long(f2.t,f1.t);
if(((0) === c__28531__auto____$3)){
var c__28531__auto____$4 = fluree.db.flake.cmp_bool(f1.op,f2.op);
if(((0) === c__28531__auto____$4)){
var c__28531__auto____$5 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$5)){
return (0);
} else {
return c__28531__auto____$5;
}
} else {
return c__28531__auto____$4;
}
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_psot_novelty = (function fluree$db$flake$cmp_flakes_psot_novelty(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_val_xtype(f1.o,f2.o);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_long(f2.t,f1.t);
if(((0) === c__28531__auto____$3)){
var c__28531__auto____$4 = fluree.db.flake.cmp_bool(f1.op,f2.op);
if(((0) === c__28531__auto____$4)){
var c__28531__auto____$5 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$5)){
return (0);
} else {
return c__28531__auto____$5;
}
} else {
return c__28531__auto____$4;
}
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_post_novelty = (function fluree$db$flake$cmp_flakes_post_novelty(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_val_xtype(f1.o,f2.o);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_long(f2.t,f1.t);
if(((0) === c__28531__auto____$3)){
var c__28531__auto____$4 = fluree.db.flake.cmp_bool(f1.op,f2.op);
if(((0) === c__28531__auto____$4)){
var c__28531__auto____$5 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$5)){
return (0);
} else {
return c__28531__auto____$5;
}
} else {
return c__28531__auto____$4;
}
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.cmp_flakes_opst_novelty = (function fluree$db$flake$cmp_flakes_opst_novelty(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f2.o,f1.o);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_long(f2.t,f1.t);
if(((0) === c__28531__auto____$3)){
var c__28531__auto____$4 = fluree.db.flake.cmp_bool(f1.op,f2.op);
if(((0) === c__28531__auto____$4)){
var c__28531__auto____$5 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$5)){
return (0);
} else {
return c__28531__auto____$5;
}
} else {
return c__28531__auto____$4;
}
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
/**
 * Comparison for flakes in blocks.
 *   Like cmp-flakes-spot-novelty, but 't' is moved up front.
 */
fluree.db.flake.cmp_flakes_block = (function fluree$db$flake$cmp_flakes_block(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f2.t,f1.t);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = fluree.db.flake.cmp_long(f2.s,f1.s);
if(((0) === c__28531__auto____$1)){
var c__28531__auto____$2 = fluree.db.flake.cmp_pred(f1.p,f2.p);
if(((0) === c__28531__auto____$2)){
var c__28531__auto____$3 = fluree.db.flake.cmp_val_xtype(f1.o,f2.o);
if(((0) === c__28531__auto____$3)){
var c__28531__auto____$4 = fluree.db.flake.cmp_bool(f1.op,f2.op);
if(((0) === c__28531__auto____$4)){
var c__28531__auto____$5 = fluree.db.flake.cmp_meta(f1.m,f2.m);
if(((0) === c__28531__auto____$5)){
return (0);
} else {
return c__28531__auto____$5;
}
} else {
return c__28531__auto____$4;
}
} else {
return c__28531__auto____$3;
}
} else {
return c__28531__auto____$2;
}
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
/**
 * Note this is not suitable for a set, only a vector/list.
 */
fluree.db.flake.cmp_flakes_history = (function fluree$db$flake$cmp_flakes_history(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f1.t,f2.t);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = cljs.core.compare(f2.op,f1.op);
if(((0) === c__28531__auto____$1)){
return (0);
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
/**
 * Sorts by transaction time in ascending order (newest first), then by
 *   the boolean operation descending so assertions (true) come before retractions (false)
 *   so that we can 're-play' the log in reverse order to come up with historical states.
 *   Suitable only for sorting a vector, not a sorted set.
 */
fluree.db.flake.cmp_history_quick_reverse_sort = (function fluree$db$flake$cmp_history_quick_reverse_sort(f1,f2){
var c__28531__auto__ = fluree.db.flake.cmp_long(f1.t,f2.t);
if(((0) === c__28531__auto__)){
var c__28531__auto____$1 = cljs.core.compare(f2.op,f1.op);
if(((0) === c__28531__auto____$1)){
return (0);
} else {
return c__28531__auto____$1;
}
} else {
return c__28531__auto__;
}
});
fluree.db.flake.new_flake = (function fluree$db$flake$new_flake(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28668 = arguments.length;
var i__4819__auto___28669 = (0);
while(true){
if((i__4819__auto___28669 < len__4818__auto___28668)){
args__4824__auto__.push((arguments[i__4819__auto___28669]));

var G__28670 = (i__4819__auto___28669 + (1));
i__4819__auto___28669 = G__28670;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return fluree.db.flake.new_flake.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(fluree.db.flake.new_flake.cljs$core$IFn$_invoke$arity$variadic = (function (parts){
var vec__28665 = parts;
var s = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(1),null);
var o = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28665,(5),null);
return fluree.db.flake.__GT_Flake(s,p,o,t,op,m);
}));

(fluree.db.flake.new_flake.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(fluree.db.flake.new_flake.cljs$lang$applyTo = (function (seq28664){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq28664));
}));

/**
 * Takes a flake and returns one with the provided block and .-op flipped from true/false.
 *   Don't over-ride no-history, even if no-history for this predicate has changed. New inserts
 *   will have the no-history flag, but we need the old inserts to be properly retracted in the txlog.
 */
fluree.db.flake.flip_flake = (function fluree$db$flake$flip_flake(var_args){
var G__28672 = arguments.length;
switch (G__28672) {
case 1:
return fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$1 = (function (flake){
return fluree.db.flake.__GT_Flake(flake.s,flake.p,flake.o,flake.t,cljs.core.not(flake.op),flake.m);
}));

(fluree.db.flake.flip_flake.cljs$core$IFn$_invoke$arity$2 = (function (flake,t){
return fluree.db.flake.__GT_Flake(flake.s,flake.p,flake.o,t,cljs.core.not(flake.op),flake.m);
}));

(fluree.db.flake.flip_flake.cljs$lang$maxFixedArity = 2);

/**
 * Takes a flake and returns one with the provided block and .-op flipped from true/false.
 *   Don't over-ride no-history, even if no-history for this predicate has changed. New inserts
 *   will have the no-history flag, but we need the old inserts to be properly retracted in the txlog.
 */
fluree.db.flake.change_t = (function fluree$db$flake$change_t(flake,t){
return fluree.db.flake.__GT_Flake(flake.s,flake.p,flake.o,t,flake.op,flake.m);
});
/**
 * From and to are Flakes
 */
fluree.db.flake.slice = (function fluree$db$flake$slice(ss,from,to){
if(cljs.core.truth_((function (){var and__4210__auto__ = from;
if(cljs.core.truth_(and__4210__auto__)){
return to;
} else {
return and__4210__auto__;
}
})())){
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(ss,cljs.core._GT__EQ_,from,cljs.core._LT__EQ_,to);
} else {
if((from == null)){
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(ss,cljs.core._LT__EQ_,to);
} else {
if((to == null)){
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(ss,cljs.core._GT__EQ_,from);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Unexpected error performing slice, both from and to conditions are nil. Please report.",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));

}
}
}
});
fluree.db.flake.lookup = (function fluree$db$flake$lookup(ss,start_flake,end_flake){
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(ss,cljs.core._GT__EQ_,start_flake,cljs.core._LT__EQ_,end_flake);
});
fluree.db.flake.subrange = (function fluree$db$flake$subrange(ss,start_test,start_flake,end_test,end_flake){
return clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(ss,start_test,start_flake,end_test,end_flake);
});
fluree.db.flake.split_at = (function fluree$db$flake$split_at(n,ss){
return clojure.data.avl.split_at(n,ss);
});
/**
 * Splits a sorted set at a given flake. If there is an exact match for flake,
 *   puts it in the left-side. Primarily for use with last-flake.
 */
fluree.db.flake.split_by_flake = (function fluree$db$flake$split_by_flake(f,ss){
var vec__28674 = clojure.data.avl.split_key(f,ss);
var l = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28674,(0),null);
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28674,(1),null);
var r = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__28674,(2),null);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(cljs.core.truth_(e)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(l,e):l),r], null);
});
fluree.db.flake.sorted_set_by = (function fluree$db$flake$sorted_set_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___28679 = arguments.length;
var i__4819__auto___28680 = (0);
while(true){
if((i__4819__auto___28680 < len__4818__auto___28679)){
args__4824__auto__.push((arguments[i__4819__auto___28680]));

var G__28681 = (i__4819__auto___28680 + (1));
i__4819__auto___28680 = G__28681;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.flake.sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,flakes){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_set_by,comparator,flakes);
}));

(fluree.db.flake.sorted_set_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.flake.sorted_set_by.cljs$lang$applyTo = (function (seq28677){
var G__28678 = cljs.core.first(seq28677);
var seq28677__$1 = cljs.core.next(seq28677);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__28678,seq28677__$1);
}));

/**
 * Base size of a flake is 38 bytes... then add size for 'o' and 'm'.
 *   Flakes have the following:
 *  - s - 8 bytes
 *  - p - 8 bytes
 *  - o - ??
 *  - t - 8 bytes
 *  - add? - 1 byte
 *  - m - 1 byte + ??
 *  - header - 12 bytes - object header...
 * 
 *   Objects will be rounded up to nearest 8 bytes... we don't do this here as
 *   it should be 'close enough'
 *   reference: https://www.javamex.com/tutorials/memory/string_memory_usage.shtml
 */
fluree.db.flake.size_flake = (function fluree$db$flake$size_flake(f){
var o = f.o;
return (((37) + ((cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([o], 0))).length)) + (((f.m == null))?(1):((2) * ((cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([f.m], 0))).length))));
});
/**
 * Returns approx number of bytes in a collection of flakes.
 */
fluree.db.flake.size_bytes = (function fluree$db$flake$size_bytes(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__28682_SHARP_,p2__28683_SHARP_){
return (p1__28682_SHARP_ + fluree.db.flake.size_flake(p2__28683_SHARP_));
}),(0),flakes);
});
/**
 * Like size-bytes, but kb.
 *   Rounds down for simplicity, as bytes is just an estimate anyhow.
 */
fluree.db.flake.size_kb = (function fluree$db$flake$size_kb(flakes){
var G__28684 = (fluree.db.flake.size_bytes(flakes) / (1000));
return Math.round(G__28684);
});
/**
 * Takes n flakes from a sorted flake set, retaining the set itself.
 */
fluree.db.flake.take = (function fluree$db$flake$take(n,flake_set){
if((n >= cljs.core.count(flake_set))){
return flake_set;
} else {
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(flake_set,n);
return cljs.core.first(clojure.data.avl.split_key(k,flake_set));
}
});
