// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.index');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.data.avl');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.log');

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexConfig = (function (index_type,comparator,historyComparator,__meta,__extmap,__hash){
this.index_type = index_type;
this.comparator = comparator;
this.historyComparator = historyComparator;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32688,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32692 = k32688;
var G__32692__$1 = (((G__32692 instanceof cljs.core.Keyword))?G__32692.fqn:null);
switch (G__32692__$1) {
case "index-type":
return self__.index_type;

break;
case "comparator":
return self__.comparator;

break;
case "historyComparator":
return self__.historyComparator;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32688,else__4464__auto__);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32693){
var vec__32694 = p__32693;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32694,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32694,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexConfig{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_type,self__.index_type],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$comparator,self__.comparator],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$historyComparator,self__.historyComparator],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32687){
var self__ = this;
var G__32687__$1 = this;
return (new cljs.core.RecordIter((0),G__32687__$1,3,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (3 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32697 = (function (coll__4458__auto__){
return (1512230614 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32697(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32689,other32690){
var self__ = this;
var this32689__$1 = this;
return (((!((other32690 == null)))) && ((((this32689__$1.constructor === other32690.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32689__$1.index_type,other32690.index_type)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32689__$1.comparator,other32690.comparator)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32689__$1.historyComparator,other32690.historyComparator)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32689__$1.__extmap,other32690.__extmap)))))))))));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$historyComparator,null,cljs.core.cst$kw$comparator,null,cljs.core.cst$kw$index_DASH_type,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32688){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32698 = k32688;
var G__32698__$1 = (((G__32698 instanceof cljs.core.Keyword))?G__32698.fqn:null);
switch (G__32698__$1) {
case "index-type":
case "comparator":
case "historyComparator":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32688);

}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32687){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32699 = cljs.core.keyword_identical_QMARK_;
var expr__32700 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32702 = cljs.core.cst$kw$index_DASH_type;
var G__32703 = expr__32700;
return (pred__32699.cljs$core$IFn$_invoke$arity$2 ? pred__32699.cljs$core$IFn$_invoke$arity$2(G__32702,G__32703) : pred__32699.call(null,G__32702,G__32703));
})())){
return (new fluree.db.index.IndexConfig(G__32687,self__.comparator,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32704 = cljs.core.cst$kw$comparator;
var G__32705 = expr__32700;
return (pred__32699.cljs$core$IFn$_invoke$arity$2 ? pred__32699.cljs$core$IFn$_invoke$arity$2(G__32704,G__32705) : pred__32699.call(null,G__32704,G__32705));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,G__32687,self__.historyComparator,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32706 = cljs.core.cst$kw$historyComparator;
var G__32707 = expr__32700;
return (pred__32699.cljs$core$IFn$_invoke$arity$2 ? pred__32699.cljs$core$IFn$_invoke$arity$2(G__32706,G__32707) : pred__32699.call(null,G__32706,G__32707));
})())){
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,G__32687,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32687),null));
}
}
}
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_type,self__.index_type,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$comparator,self__.comparator,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$historyComparator,self__.historyComparator,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32687){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexConfig(self__.index_type,self__.comparator,self__.historyComparator,G__32687,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexConfig.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexConfig.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$index_DASH_type,cljs.core.cst$sym$comparator,cljs.core.cst$sym$historyComparator], null);
}));

(fluree.db.index.IndexConfig.cljs$lang$type = true);

(fluree.db.index.IndexConfig.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexConfig",null,(1),null));
}));

(fluree.db.index.IndexConfig.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexConfig");
}));

/**
 * Positional factory function for fluree.db.index/IndexConfig.
 */
fluree.db.index.__GT_IndexConfig = (function fluree$db$index$__GT_IndexConfig(index_type,comparator,historyComparator){
return (new fluree.db.index.IndexConfig(index_type,comparator,historyComparator,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexConfig, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexConfig = (function fluree$db$index$map__GT_IndexConfig(G__32691){
var extmap__4501__auto__ = (function (){var G__32708 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32691,cljs.core.cst$kw$index_DASH_type,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$comparator,cljs.core.cst$kw$historyComparator], 0));
if(cljs.core.record_QMARK_(G__32691)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32708);
} else {
return G__32708;
}
})();
return (new fluree.db.index.IndexConfig(cljs.core.cst$kw$index_DASH_type.cljs$core$IFn$_invoke$arity$1(G__32691),cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(G__32691),cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(G__32691),null,cljs.core.not_empty(extmap__4501__auto__),null));
});


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.IndexNode = (function (block,t,rhs,children,config,leftmost_QMARK_,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.rhs = rhs;
this.children = children;
this.config = config;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32712,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32716 = k32712;
var G__32716__$1 = (((G__32716 instanceof cljs.core.Keyword))?G__32716.fqn:null);
switch (G__32716__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "rhs":
return self__.rhs;

break;
case "children":
return self__.children;

break;
case "config":
return self__.config;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32712,else__4464__auto__);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32717){
var vec__32718 = p__32717;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32718,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32718,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.IndexNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$children,self__.children],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32711){
var self__ = this;
var G__32711__$1 = this;
return (new cljs.core.RecordIter((0),G__32711__$1,6,new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32722){
var state_val_32723 = (state_32722[(1)]);
if((state_val_32723 === (1))){
var state_32722__$1 = state_32722;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32722__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32724 = [null,null,null,null,null,null,null];
(statearr_32724[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32724[(1)] = (1));

return statearr_32724;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32722){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32722);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32725){var ex__16398__auto__ = e32725;
var statearr_32726_32838 = state_32722;
(statearr_32726_32838[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32722[(4)]))){
var statearr_32727_32839 = state_32722;
(statearr_32727_32839[(1)] = cljs.core.first((state_32722[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32840 = state_32722;
state_32722 = G__32840;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32722){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32722);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32728 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32728[(6)] = c__16469__auto__);

return statearr_32728;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.key(cljs.core.first(self__.children));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (6 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._LT__EQ_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.first(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_after$arity$2 = (function (_,flake){
var self__ = this;
var ___$1 = this;
return cljs.core.val((function (){var or__4212__auto__ = clojure.data.avl.nearest(self__.children,cljs.core._GT_,flake);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.last(self__.children);
}
})());
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32753){
var state_val_32754 = (state_32753[(1)]);
if((state_val_32754 === (7))){
var inst_32735 = (state_32753[(7)]);
var inst_32739 = fluree.db.dbproto._resolve(inst_32735);
var state_32753__$1 = state_32753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32753__$1,(10),inst_32739);
} else {
if((state_val_32754 === (1))){
var state_32753__$1 = state_32753;
var statearr_32755_32841 = state_32753__$1;
(statearr_32755_32841[(2)] = null);

(statearr_32755_32841[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (4))){
var inst_32729 = (state_32753[(2)]);
var state_32753__$1 = state_32753;
var statearr_32756_32842 = state_32753__$1;
(statearr_32756_32842[(2)] = inst_32729);

(statearr_32756_32842[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (6))){
var inst_32735 = (state_32753[(7)]);
var state_32753__$1 = state_32753;
var statearr_32757_32843 = state_32753__$1;
(statearr_32757_32843[(2)] = inst_32735);

(statearr_32757_32843[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (3))){
var inst_32751 = (state_32753[(2)]);
var state_32753__$1 = state_32753;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32753__$1,inst_32751);
} else {
if((state_val_32754 === (2))){
var inst_32735 = (state_32753[(7)]);
var _ = (function (){var statearr_32759 = state_32753;
(statearr_32759[(4)] = cljs.core.cons((5),(state_32753[(4)])));

return statearr_32759;
})();
var inst_32735__$1 = this$__$1.fluree$db$dbproto$INode$_lookup$arity$2(null,flake);
var inst_32736 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32735__$1);
var state_32753__$1 = (function (){var statearr_32760 = state_32753;
(statearr_32760[(7)] = inst_32735__$1);

return statearr_32760;
})();
if(cljs.core.truth_(inst_32736)){
var statearr_32761_32844 = state_32753__$1;
(statearr_32761_32844[(1)] = (6));

} else {
var statearr_32762_32845 = state_32753__$1;
(statearr_32762_32845[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (9))){
var inst_32745 = (state_32753[(2)]);
var inst_32746 = fluree.db.util.async.throw_err(inst_32745);
var state_32753__$1 = state_32753;
var statearr_32763_32846 = state_32753__$1;
(statearr_32763_32846[(2)] = inst_32746);

(statearr_32763_32846[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (5))){
var _ = (function (){var statearr_32764 = state_32753;
(statearr_32764[(4)] = cljs.core.rest((state_32753[(4)])));

return statearr_32764;
})();
var state_32753__$1 = state_32753;
var ex32758 = (state_32753__$1[(2)]);
var statearr_32765_32847 = state_32753__$1;
(statearr_32765_32847[(5)] = ex32758);


if((ex32758 instanceof Error)){
var statearr_32766_32848 = state_32753__$1;
(statearr_32766_32848[(1)] = (4));

(statearr_32766_32848[(5)] = null);

} else {
throw ex32758;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32754 === (10))){
var inst_32741 = (state_32753[(2)]);
var inst_32742 = fluree.db.util.async.throw_err(inst_32741);
var inst_32743 = fluree.db.dbproto._lookup_leaf(inst_32742,flake);
var state_32753__$1 = state_32753;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32753__$1,(9),inst_32743);
} else {
if((state_val_32754 === (8))){
var inst_32748 = (state_32753[(2)]);
var _ = (function (){var statearr_32767 = state_32753;
(statearr_32767[(4)] = cljs.core.rest((state_32753[(4)])));

return statearr_32767;
})();
var state_32753__$1 = state_32753;
var statearr_32768_32849 = state_32753__$1;
(statearr_32768_32849[(2)] = inst_32748);

(statearr_32768_32849[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32769 = [null,null,null,null,null,null,null,null];
(statearr_32769[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32769[(1)] = (1));

return statearr_32769;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32753){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32753);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32770){var ex__16398__auto__ = e32770;
var statearr_32771_32850 = state_32753;
(statearr_32771_32850[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32753[(4)]))){
var statearr_32772_32851 = state_32753;
(statearr_32772_32851[(1)] = cljs.core.first((state_32753[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32852 = state_32753;
state_32753 = G__32852;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32753){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32753);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32773 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32773[(6)] = c__16469__auto__);

return statearr_32773;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.fluree$db$dbproto$INode$_lookup_leaf_after$arity$2 = (function (this$,flake){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32798){
var state_val_32799 = (state_32798[(1)]);
if((state_val_32799 === (7))){
var inst_32780 = (state_32798[(7)]);
var inst_32784 = fluree.db.dbproto._resolve(inst_32780);
var state_32798__$1 = state_32798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32798__$1,(10),inst_32784);
} else {
if((state_val_32799 === (1))){
var state_32798__$1 = state_32798;
var statearr_32800_32853 = state_32798__$1;
(statearr_32800_32853[(2)] = null);

(statearr_32800_32853[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (4))){
var inst_32774 = (state_32798[(2)]);
var state_32798__$1 = state_32798;
var statearr_32801_32854 = state_32798__$1;
(statearr_32801_32854[(2)] = inst_32774);

(statearr_32801_32854[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (6))){
var inst_32780 = (state_32798[(7)]);
var state_32798__$1 = state_32798;
var statearr_32802_32855 = state_32798__$1;
(statearr_32802_32855[(2)] = inst_32780);

(statearr_32802_32855[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (3))){
var inst_32796 = (state_32798[(2)]);
var state_32798__$1 = state_32798;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32798__$1,inst_32796);
} else {
if((state_val_32799 === (2))){
var inst_32780 = (state_32798[(7)]);
var _ = (function (){var statearr_32804 = state_32798;
(statearr_32804[(4)] = cljs.core.cons((5),(state_32798[(4)])));

return statearr_32804;
})();
var inst_32780__$1 = this$__$1.fluree$db$dbproto$INode$_lookup_after$arity$2(null,flake);
var inst_32781 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(inst_32780__$1);
var state_32798__$1 = (function (){var statearr_32805 = state_32798;
(statearr_32805[(7)] = inst_32780__$1);

return statearr_32805;
})();
if(cljs.core.truth_(inst_32781)){
var statearr_32806_32856 = state_32798__$1;
(statearr_32806_32856[(1)] = (6));

} else {
var statearr_32807_32857 = state_32798__$1;
(statearr_32807_32857[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (9))){
var inst_32790 = (state_32798[(2)]);
var inst_32791 = fluree.db.util.async.throw_err(inst_32790);
var state_32798__$1 = state_32798;
var statearr_32808_32858 = state_32798__$1;
(statearr_32808_32858[(2)] = inst_32791);

(statearr_32808_32858[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (5))){
var _ = (function (){var statearr_32809 = state_32798;
(statearr_32809[(4)] = cljs.core.rest((state_32798[(4)])));

return statearr_32809;
})();
var state_32798__$1 = state_32798;
var ex32803 = (state_32798__$1[(2)]);
var statearr_32810_32859 = state_32798__$1;
(statearr_32810_32859[(5)] = ex32803);


if((ex32803 instanceof Error)){
var statearr_32811_32860 = state_32798__$1;
(statearr_32811_32860[(1)] = (4));

(statearr_32811_32860[(5)] = null);

} else {
throw ex32803;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32799 === (10))){
var inst_32786 = (state_32798[(2)]);
var inst_32787 = fluree.db.util.async.throw_err(inst_32786);
var inst_32788 = fluree.db.dbproto._lookup_leaf_after(inst_32787,flake);
var state_32798__$1 = state_32798;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32798__$1,(9),inst_32788);
} else {
if((state_val_32799 === (8))){
var inst_32793 = (state_32798[(2)]);
var _ = (function (){var statearr_32812 = state_32798;
(statearr_32812[(4)] = cljs.core.rest((state_32798[(4)])));

return statearr_32812;
})();
var state_32798__$1 = state_32798;
var statearr_32813_32861 = state_32798__$1;
(statearr_32813_32861[(2)] = inst_32793);

(statearr_32813_32861[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32814 = [null,null,null,null,null,null,null,null];
(statearr_32814[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32814[(1)] = (1));

return statearr_32814;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32798){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32798);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32815){var ex__16398__auto__ = e32815;
var statearr_32816_32862 = state_32798;
(statearr_32816_32862[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32798[(4)]))){
var statearr_32817_32863 = state_32798;
(statearr_32817_32863[(1)] = cljs.core.first((state_32798[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32864 = state_32798;
state_32798 = G__32864;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32798){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32798);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32818 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32818[(6)] = c__16469__auto__);

return statearr_32818;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32819 = (function (coll__4458__auto__){
return (659789215 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32819(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32713,other32714){
var self__ = this;
var this32713__$1 = this;
return (((!((other32714 == null)))) && ((((this32713__$1.constructor === other32714.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.block,other32714.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.t,other32714.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.rhs,other32714.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.children,other32714.children)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.config,other32714.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.leftmost_QMARK_,other32714.leftmost_QMARK_)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32713__$1.__extmap,other32714.__extmap)))))))))))))))));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$children,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32712){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32820 = k32712;
var G__32820__$1 = (((G__32820 instanceof cljs.core.Keyword))?G__32820.fqn:null);
switch (G__32820__$1) {
case "block":
case "t":
case "rhs":
case "children":
case "config":
case "leftmost?":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32712);

}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32711){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32821 = cljs.core.keyword_identical_QMARK_;
var expr__32822 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32824 = cljs.core.cst$kw$block;
var G__32825 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32824,G__32825) : pred__32821.call(null,G__32824,G__32825));
})())){
return (new fluree.db.index.IndexNode(G__32711,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32826 = cljs.core.cst$kw$t;
var G__32827 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32826,G__32827) : pred__32821.call(null,G__32826,G__32827));
})())){
return (new fluree.db.index.IndexNode(self__.block,G__32711,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32828 = cljs.core.cst$kw$rhs;
var G__32829 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32828,G__32829) : pred__32821.call(null,G__32828,G__32829));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,G__32711,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32830 = cljs.core.cst$kw$children;
var G__32831 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32830,G__32831) : pred__32821.call(null,G__32830,G__32831));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,G__32711,self__.config,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32832 = cljs.core.cst$kw$config;
var G__32833 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32832,G__32833) : pred__32821.call(null,G__32832,G__32833));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,G__32711,self__.leftmost_QMARK_,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32834 = cljs.core.cst$kw$leftmost_QMARK_;
var G__32835 = expr__32822;
return (pred__32821.cljs$core$IFn$_invoke$arity$2 ? pred__32821.cljs$core$IFn$_invoke$arity$2(G__32834,G__32835) : pred__32821.call(null,G__32834,G__32835));
})())){
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,G__32711,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32711),null));
}
}
}
}
}
}
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$children,self__.children,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null))], null),self__.__extmap));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32711){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.IndexNode(self__.block,self__.t,self__.rhs,self__.children,self__.config,self__.leftmost_QMARK_,G__32711,self__.__extmap,self__.__hash));
}));

(fluree.db.index.IndexNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.IndexNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$rhs,cljs.core.cst$sym$children,cljs.core.cst$sym$config,cljs.core.cst$sym$leftmost_QMARK_], null);
}));

(fluree.db.index.IndexNode.cljs$lang$type = true);

(fluree.db.index.IndexNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/IndexNode",null,(1),null));
}));

(fluree.db.index.IndexNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/IndexNode");
}));

/**
 * Positional factory function for fluree.db.index/IndexNode.
 */
fluree.db.index.__GT_IndexNode = (function fluree$db$index$__GT_IndexNode(block,t,rhs,children,config,leftmost_QMARK_){
return (new fluree.db.index.IndexNode(block,t,rhs,children,config,leftmost_QMARK_,null,null,null));
});

/**
 * Factory function for fluree.db.index/IndexNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_IndexNode = (function fluree$db$index$map__GT_IndexNode(G__32715){
var extmap__4501__auto__ = (function (){var G__32836 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32715,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$rhs,cljs.core.cst$kw$children,cljs.core.cst$kw$config,cljs.core.cst$kw$leftmost_QMARK_], 0));
if(cljs.core.record_QMARK_(G__32715)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32836);
} else {
return G__32836;
}
})();
return (new fluree.db.index.IndexNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32715),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32715),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32715),cljs.core.cst$kw$children.cljs$core$IFn$_invoke$arity$1(G__32715),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32715),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__32715),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

fluree.db.index.index_node_QMARK_ = (function fluree$db$index$index_node_QMARK_(node){
return (node instanceof fluree.db.index.IndexNode);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {fluree.db.dbproto.INode}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.index.DataNode = (function (block,t,flakes,rhs,config,__meta,__extmap,__hash){
this.block = block;
this.t = t;
this.flakes = flakes;
this.rhs = rhs;
this.config = config;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.index.DataNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k32867,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__32871 = k32867;
var G__32871__$1 = (((G__32871 instanceof cljs.core.Keyword))?G__32871.fqn:null);
switch (G__32871__$1) {
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "flakes":
return self__.flakes;

break;
case "rhs":
return self__.rhs;

break;
case "config":
return self__.config;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k32867,else__4464__auto__);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__32872){
var vec__32873 = p__32872;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32873,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32873,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.index.DataNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.index.DataNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$flakes,self__.flakes],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__32866){
var self__ = this;
var G__32866__$1 = this;
return (new cljs.core.RecordIter((0),G__32866__$1,5,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32877){
var state_val_32878 = (state_32877[(1)]);
if((state_val_32878 === (1))){
var state_32877__$1 = state_32877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32877__$1,this$__$1);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32879 = [null,null,null,null,null,null,null];
(statearr_32879[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32879[(1)] = (1));

return statearr_32879;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32877){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32877);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32880){var ex__16398__auto__ = e32880;
var statearr_32881_32913 = state_32877;
(statearr_32881_32913[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32877[(4)]))){
var statearr_32882_32914 = state_32877;
(statearr_32882_32914[(1)] = cljs.core.first((state_32877[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32915 = state_32877;
state_32877 = G__32915;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32877){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32883 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32883[(6)] = c__16469__auto__);

return statearr_32883;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-resolve-history called on DATA NODE!!!",cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.first(self__.flakes);
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (5 + cljs.core.count(self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup was called on a data node, which shouldn't happen!",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}));

(fluree.db.index.DataNode.prototype.fluree$db$dbproto$INode$_lookup_leaf$arity$2 = (function (root,flake){
var self__ = this;
var root__$1 = this;
fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["-lookup-leaf was called on a data node, which shouldn't happen!"], 0));

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32889){
var state_val_32890 = (state_32889[(1)]);
if((state_val_32890 === (1))){
var inst_32884 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32885 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_32886 = cljs.core.PersistentHashMap.fromArrays(inst_32884,inst_32885);
var inst_32887 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("-lookup-leaf was called on a data node, which shouldn't happen!",inst_32886);
var state_32889__$1 = state_32889;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32889__$1,inst_32887);
} else {
return null;
}
});
return (function() {
var fluree$db$index$state_machine__16395__auto__ = null;
var fluree$db$index$state_machine__16395__auto____0 = (function (){
var statearr_32891 = [null,null,null,null,null,null,null];
(statearr_32891[(0)] = fluree$db$index$state_machine__16395__auto__);

(statearr_32891[(1)] = (1));

return statearr_32891;
});
var fluree$db$index$state_machine__16395__auto____1 = (function (state_32889){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32889);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32892){var ex__16398__auto__ = e32892;
var statearr_32893_32916 = state_32889;
(statearr_32893_32916[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32889[(4)]))){
var statearr_32894_32917 = state_32889;
(statearr_32894_32917[(1)] = cljs.core.first((state_32889[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32918 = state_32889;
state_32889 = G__32918;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$index$state_machine__16395__auto__ = function(state_32889){
switch(arguments.length){
case 0:
return fluree$db$index$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$index$state_machine__16395__auto____1.call(this,state_32889);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$index$state_machine__16395__auto____0;
fluree$db$index$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$index$state_machine__16395__auto____1;
return fluree$db$index$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32895 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32895[(6)] = c__16469__auto__);

return statearr_32895;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.index.DataNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__32896 = (function (coll__4458__auto__){
return (1312629141 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__32896(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this32868,other32869){
var self__ = this;
var this32868__$1 = this;
return (((!((other32869 == null)))) && ((((this32868__$1.constructor === other32869.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.block,other32869.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.t,other32869.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.flakes,other32869.flakes)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.rhs,other32869.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.config,other32869.config)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this32868__$1.__extmap,other32869.__extmap)))))))))))))));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$flakes,null,cljs.core.cst$kw$rhs,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k32867){
var self__ = this;
var this__4468__auto____$1 = this;
var G__32897 = k32867;
var G__32897__$1 = (((G__32897 instanceof cljs.core.Keyword))?G__32897.fqn:null);
switch (G__32897__$1) {
case "block":
case "t":
case "flakes":
case "rhs":
case "config":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k32867);

}
}));

(fluree.db.index.DataNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__32866){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__32898 = cljs.core.keyword_identical_QMARK_;
var expr__32899 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__32901 = cljs.core.cst$kw$block;
var G__32902 = expr__32899;
return (pred__32898.cljs$core$IFn$_invoke$arity$2 ? pred__32898.cljs$core$IFn$_invoke$arity$2(G__32901,G__32902) : pred__32898.call(null,G__32901,G__32902));
})())){
return (new fluree.db.index.DataNode(G__32866,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32903 = cljs.core.cst$kw$t;
var G__32904 = expr__32899;
return (pred__32898.cljs$core$IFn$_invoke$arity$2 ? pred__32898.cljs$core$IFn$_invoke$arity$2(G__32903,G__32904) : pred__32898.call(null,G__32903,G__32904));
})())){
return (new fluree.db.index.DataNode(self__.block,G__32866,self__.flakes,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32905 = cljs.core.cst$kw$flakes;
var G__32906 = expr__32899;
return (pred__32898.cljs$core$IFn$_invoke$arity$2 ? pred__32898.cljs$core$IFn$_invoke$arity$2(G__32905,G__32906) : pred__32898.call(null,G__32905,G__32906));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,G__32866,self__.rhs,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32907 = cljs.core.cst$kw$rhs;
var G__32908 = expr__32899;
return (pred__32898.cljs$core$IFn$_invoke$arity$2 ? pred__32898.cljs$core$IFn$_invoke$arity$2(G__32907,G__32908) : pred__32898.call(null,G__32907,G__32908));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,G__32866,self__.config,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__32909 = cljs.core.cst$kw$config;
var G__32910 = expr__32899;
return (pred__32898.cljs$core$IFn$_invoke$arity$2 ? pred__32898.cljs$core$IFn$_invoke$arity$2(G__32909,G__32910) : pred__32898.call(null,G__32909,G__32910));
})())){
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,G__32866,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__32866),null));
}
}
}
}
}
}));

(fluree.db.index.DataNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$flakes,self__.flakes,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null))], null),self__.__extmap));
}));

(fluree.db.index.DataNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__32866){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.index.DataNode(self__.block,self__.t,self__.flakes,self__.rhs,self__.config,G__32866,self__.__extmap,self__.__hash));
}));

(fluree.db.index.DataNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.index.DataNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$flakes,cljs.core.cst$sym$rhs,cljs.core.cst$sym$config], null);
}));

(fluree.db.index.DataNode.cljs$lang$type = true);

(fluree.db.index.DataNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.index/DataNode",null,(1),null));
}));

(fluree.db.index.DataNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.index/DataNode");
}));

/**
 * Positional factory function for fluree.db.index/DataNode.
 */
fluree.db.index.__GT_DataNode = (function fluree$db$index$__GT_DataNode(block,t,flakes,rhs,config){
return (new fluree.db.index.DataNode(block,t,flakes,rhs,config,null,null,null));
});

/**
 * Factory function for fluree.db.index/DataNode, taking a map of keywords to field values.
 */
fluree.db.index.map__GT_DataNode = (function fluree$db$index$map__GT_DataNode(G__32870){
var extmap__4501__auto__ = (function (){var G__32911 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__32870,cljs.core.cst$kw$block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,cljs.core.cst$kw$flakes,cljs.core.cst$kw$rhs,cljs.core.cst$kw$config], 0));
if(cljs.core.record_QMARK_(G__32870)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__32911);
} else {
return G__32911;
}
})();
return (new fluree.db.index.DataNode(cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__32870),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__32870),cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(G__32870),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__32870),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__32870),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Creates a new data node
 */
fluree.db.index.data_node = (function fluree$db$index$data_node(block_id,t,flakes,rhs,config){
return fluree.db.index.__GT_DataNode(block_id,t,flakes,rhs,config);
});
fluree.db.index.data_node_QMARK_ = (function fluree$db$index$data_node_QMARK_(node){
return (node instanceof fluree.db.index.DataNode);
});
