// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.operations');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.log');
goog.require('cljs.core.async');
/**
 * Returns true if connection has been closed.
 */
fluree.db.operations.conn_closed_QMARK_ = (function fluree$db$operations$conn_closed_QMARK_(conn){
return cljs.core.cst$kw$close_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(conn)));
});
/**
 * Creates the operation header.
 */
fluree.db.operations.formulate_op_header = (function fluree$db$operations$formulate_op_header(var_args){
var G__34480 = arguments.length;
switch (G__34480) {
case 2:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$2 = (function (operation,db){
return fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3(operation,db,(60000));
}));

(fluree.db.operations.formulate_op_header.cljs$core$IFn$_invoke$arity$3 = (function (operation,db,timeout){
var req_id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(fluree.db.util.core.random_uuid());
var header = new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$op,operation,cljs.core.cst$kw$req_DASH_id,req_id,cljs.core.cst$kw$timestamp,fluree.db.util.core.current_time_millis(),cljs.core.cst$kw$timeout,timeout], null);
return header;
}));

(fluree.db.operations.formulate_op_header.cljs$lang$maxFixedArity = 3);

/**
 * Sends operation off, returns core async promise channel that will have eventual response
 *   or timeout response.
 * 
 *   Records the request-id which is stored in an atom along with the response channel.
 * 
 *   Incoming ledger notifications will look at request id and see if
 *   there is a matching request-id in the record with its corresponding
 *   async channel, and if so it will populate that channel with the response.
 * 
 *   We use the timeout to create a timeout channel, so if no transactions with
 *   the corresponding request id are 'seen' in that timeframe, a timeout response
 *   is given.
 */
fluree.db.operations.send_operation = (function fluree$db$operations$send_operation(var_args){
var G__34483 = arguments.length;
switch (G__34483) {
case 3:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3 = (function (conn,operation,data){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4(conn,operation,data,null);
}));

(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$4 = (function (conn,operation,data,opts){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___34536 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34514){
var state_val_34515 = (state_34514[(1)]);
if((state_val_34515 === (1))){
var state_34514__$1 = state_34514;
var statearr_34516_34537 = state_34514__$1;
(statearr_34516_34537[(2)] = null);

(statearr_34516_34537[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (2))){
var _ = (function (){var statearr_34517 = state_34514;
(statearr_34517[(4)] = cljs.core.cons((5),(state_34514[(4)])));

return statearr_34517;
})();
var inst_34491 = fluree.db.operations.conn_closed_QMARK_(conn);
var state_34514__$1 = state_34514;
if(cljs.core.truth_(inst_34491)){
var statearr_34518_34538 = state_34514__$1;
(statearr_34518_34538[(1)] = (6));

} else {
var statearr_34519_34539 = state_34514__$1;
(statearr_34519_34539[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (3))){
var inst_34512 = (state_34514[(2)]);
var state_34514__$1 = state_34514;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34514__$1,inst_34512);
} else {
if((state_val_34515 === (4))){
var inst_34484 = (state_34514[(2)]);
var inst_34485 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,inst_34484);
var state_34514__$1 = state_34514;
var statearr_34521_34540 = state_34514__$1;
(statearr_34521_34540[(2)] = inst_34485);

(statearr_34521_34540[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (5))){
var _ = (function (){var statearr_34522 = state_34514;
(statearr_34522[(4)] = cljs.core.rest((state_34514[(4)])));

return statearr_34522;
})();
var state_34514__$1 = state_34514;
var ex34520 = (state_34514__$1[(2)]);
var statearr_34523_34541 = state_34514__$1;
(statearr_34523_34541[(5)] = ex34520);


var statearr_34524_34542 = state_34514__$1;
(statearr_34524_34542[(1)] = (4));

(statearr_34524_34542[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (6))){
var inst_34493 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34494 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_connection];
var inst_34495 = cljs.core.PersistentHashMap.fromArrays(inst_34493,inst_34494);
var inst_34496 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Connection was closed.",inst_34495);
var inst_34497 = (function(){throw inst_34496})();
var state_34514__$1 = state_34514;
var statearr_34525_34543 = state_34514__$1;
(statearr_34525_34543[(2)] = inst_34497);

(statearr_34525_34543[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (7))){
var inst_34499 = cljs.core.cst$kw$req_DASH_chan.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34501 = [operation,data,pc,opts];
var inst_34502 = (new cljs.core.PersistentVector(null,4,(5),inst_34500,inst_34501,null));
var inst_34503 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(inst_34499,inst_34502);
var inst_34504 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_34505 = [operation,data,pc,opts];
var inst_34506 = (new cljs.core.PersistentVector(null,4,(5),inst_34504,inst_34505,null));
var inst_34507 = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Put operation on connection req-chan: ",inst_34506], 0));
var state_34514__$1 = (function (){var statearr_34526 = state_34514;
(statearr_34526[(7)] = inst_34503);

return statearr_34526;
})();
var statearr_34527_34544 = state_34514__$1;
(statearr_34527_34544[(2)] = inst_34507);

(statearr_34527_34544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34515 === (8))){
var inst_34509 = (state_34514[(2)]);
var _ = (function (){var statearr_34528 = state_34514;
(statearr_34528[(4)] = cljs.core.rest((state_34514[(4)])));

return statearr_34528;
})();
var state_34514__$1 = state_34514;
var statearr_34529_34545 = state_34514__$1;
(statearr_34529_34545[(2)] = inst_34509);

(statearr_34529_34545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$operations$state_machine__16395__auto__ = null;
var fluree$db$operations$state_machine__16395__auto____0 = (function (){
var statearr_34530 = [null,null,null,null,null,null,null,null];
(statearr_34530[(0)] = fluree$db$operations$state_machine__16395__auto__);

(statearr_34530[(1)] = (1));

return statearr_34530;
});
var fluree$db$operations$state_machine__16395__auto____1 = (function (state_34514){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34514);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34531){var ex__16398__auto__ = e34531;
var statearr_34532_34546 = state_34514;
(statearr_34532_34546[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34514[(4)]))){
var statearr_34533_34547 = state_34514;
(statearr_34533_34547[(1)] = cljs.core.first((state_34514[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34548 = state_34514;
state_34514 = G__34548;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16395__auto__ = function(state_34514){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16395__auto____1.call(this,state_34514);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16395__auto____0;
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16395__auto____1;
return fluree$db$operations$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34534 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34534[(6)] = c__16469__auto___34536);

return statearr_34534;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return pc;
}));

(fluree.db.operations.send_operation.cljs$lang$maxFixedArity = 4);

/**
 * A quick async response to confirm as initiated, but deletion happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.delete_ledger_async = (function fluree$db$operations$delete_ledger_async(var_args){
var G__34550 = arguments.length;
switch (G__34550) {
case 1:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.delete_ledger_async.cljs$core$IFn$_invoke$arity$2 = (function (session,p__34551){
var map__34552 = p__34551;
var map__34552__$1 = cljs.core.__destructure_map(map__34552);
var opts = map__34552__$1;
var snapshot_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34552__$1,cljs.core.cst$kw$snapshot_QMARK_);
var map__34553 = session;
var map__34553__$1 = cljs.core.__destructure_map(map__34553);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34553__$1,cljs.core.cst$kw$dbid);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34553__$1,cljs.core.cst$kw$network);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34553__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$delete_DASH_db,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$snapshot_QMARK_,snapshot_QMARK_], null));
}));

(fluree.db.operations.delete_ledger_async.cljs$lang$maxFixedArity = 2);

/**
 * A quick async response to confirm as initiated, but garbage collection happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.garbage_collect_async = (function fluree$db$operations$garbage_collect_async(var_args){
var args__4824__auto__ = [];
var len__4818__auto___34580 = arguments.length;
var i__4819__auto___34581 = (0);
while(true){
if((i__4819__auto___34581 < len__4818__auto___34580)){
args__4824__auto__.push((arguments[i__4819__auto___34581]));

var G__34582 = (i__4819__auto___34581 + (1));
i__4819__auto___34581 = G__34582;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.operations.garbage_collect_async.cljs$core$IFn$_invoke$arity$variadic = (function (session,p__34557){
var vec__34558 = p__34557;
var map__34561 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34558,(0),null);
var map__34561__$1 = cljs.core.__destructure_map(map__34561);
var toBlock = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34561__$1,cljs.core.cst$kw$toBlock);
var toTime = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34561__$1,cljs.core.cst$kw$toTime);
var opts = vec__34558;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34573){
var state_val_34574 = (state_34573[(1)]);
if((state_val_34574 === (1))){
var inst_34563 = session;
var inst_34564 = cljs.core.__destructure_map(inst_34563);
var inst_34565 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34564,cljs.core.cst$kw$network);
var inst_34566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34564,cljs.core.cst$kw$dbid);
var inst_34567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34564,cljs.core.cst$kw$conn);
var inst_34568 = [cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$toBlock,cljs.core.cst$kw$toTime];
var inst_34569 = [inst_34565,inst_34566,toBlock,toTime];
var inst_34570 = cljs.core.PersistentHashMap.fromArrays(inst_34568,inst_34569);
var inst_34571 = fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(inst_34567,cljs.core.cst$kw$garbage,inst_34570);
var state_34573__$1 = state_34573;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34573__$1,inst_34571);
} else {
return null;
}
});
return (function() {
var fluree$db$operations$state_machine__16395__auto__ = null;
var fluree$db$operations$state_machine__16395__auto____0 = (function (){
var statearr_34575 = [null,null,null,null,null,null,null];
(statearr_34575[(0)] = fluree$db$operations$state_machine__16395__auto__);

(statearr_34575[(1)] = (1));

return statearr_34575;
});
var fluree$db$operations$state_machine__16395__auto____1 = (function (state_34573){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34573);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34576){var ex__16398__auto__ = e34576;
var statearr_34577_34583 = state_34573;
(statearr_34577_34583[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34573[(4)]))){
var statearr_34578_34584 = state_34573;
(statearr_34578_34584[(1)] = cljs.core.first((state_34573[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34585 = state_34573;
state_34573 = G__34585;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$operations$state_machine__16395__auto__ = function(state_34573){
switch(arguments.length){
case 0:
return fluree$db$operations$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$operations$state_machine__16395__auto____1.call(this,state_34573);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$operations$state_machine__16395__auto____0;
fluree$db$operations$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$operations$state_machine__16395__auto____1;
return fluree$db$operations$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34579 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34579[(6)] = c__16469__auto__);

return statearr_34579;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.operations.garbage_collect_async.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.operations.garbage_collect_async.cljs$lang$applyTo = (function (seq34555){
var G__34556 = cljs.core.first(seq34555);
var seq34555__$1 = cljs.core.next(seq34555);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__34556,seq34555__$1);
}));

/**
 * A quick async response to confirm, but archival happens in background.
 * 
 *   A final 'completed' message will be sent in the future, if anyone cares to hear it.
 */
fluree.db.operations.snapshot_ledger_async = (function fluree$db$operations$snapshot_ledger_async(session,opts){
var map__34586 = session;
var map__34586__$1 = cljs.core.__destructure_map(map__34586);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34586__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34586__$1,cljs.core.cst$kw$dbid);
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34586__$1,cljs.core.cst$kw$conn);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$snapshot_DASH_db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,dbid], null));
});
/**
 * Submits a command to connected tx-group server
 */
fluree.db.operations.command_async = (function fluree$db$operations$command_async(conn,cmd){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$cmd,cmd);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.unsigned_command_async = (function fluree$db$operations$unsigned_command_async(conn,unsigned_cmd_map){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsigned_DASH_cmd,unsigned_cmd_map);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_info_async = (function fluree$db$operations$ledger_info_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger);
});
/**
 * Returns information about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_status_async = (function fluree$db$operations$ledger_status_async(conn,ledger){
return cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_info,ledger));
});
/**
 * Returns stats about a ledger in a map, or empty map if db doesn't exist.
 */
fluree.db.operations.ledger_stats_async = (function fluree$db$operations$ledger_stats_async(conn,ledger){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$ledger_DASH_stats,ledger);
});
/**
 * Returns a list of ledgers in two-tuples of [network ledger-id].
 */
fluree.db.operations.ledgers_async = (function fluree$db$operations$ledgers_async(conn){
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$db_DASH_list,null);
});
/**
 * A response will not be returned until transaction is completed.
 * 
 *   An option of {:wait false} can be provided which will return 'true' when the transaction
 *   has been successfully persisted by the transactors, or throw an exception.
 * 
 *   By default transact will monitor completed blocks and only return once it sees
 *   the successful transaction completed, or it will return with an error.
 */
fluree.db.operations.transact_async = (function fluree$db$operations$transact_async(conn,tx_map){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Sending transaction async: ",tx_map], 0));

return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$tx,tx_map);
});
/**
 * Starts a subscription to the session's ledger.
 * 
 *   Supported options:
 *   - auth    - auth, if specified, takes precedence
 *   - jwt     - valid jwt
 *   
 */
fluree.db.operations.subscribe = (function fluree$db$operations$subscribe(var_args){
var G__34588 = arguments.length;
switch (G__34588) {
case 1:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$1 = (function (session){
return fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2(session,null);
}));

(fluree.db.operations.subscribe.cljs$core$IFn$_invoke$arity$2 = (function (session,opts){
var map__34589 = opts;
var map__34589__$1 = cljs.core.__destructure_map(map__34589);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34589__$1,cljs.core.cst$kw$auth);
var jwt = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34589__$1,cljs.core.cst$kw$jwt);
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
var auth_or_jwt = (function (){var or__4212__auto__ = auth;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return jwt;
}
})();
var _ = fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Subscribe to: ",cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session),auth_or_jwt], 0));
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$subscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null),auth_or_jwt], null));
}));

(fluree.db.operations.subscribe.cljs$lang$maxFixedArity = 2);

/**
 * Unsubscribes from the session's ledger.
 */
fluree.db.operations.unsubscribe = (function fluree$db$operations$unsubscribe(session){
var conn = cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(session);
return fluree.db.operations.send_operation.cljs$core$IFn$_invoke$arity$3(conn,cljs.core.cst$kw$unsbuscribe,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(session),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(session)], null));
});
