// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__37869 = arguments.length;
switch (G__37869) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__37870 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__37870) : f.call(null,G__37870));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__37871 = cljs.core._deref(vol);
var G__37872 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__37871,G__37872) : f.call(null,G__37871,G__37872));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__37873 = cljs.core._deref(vol);
var G__37874 = arg1;
var G__37875 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__37873,G__37874,G__37875) : f.call(null,G__37873,G__37874,G__37875));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__37876 = cljs.core._deref(vol);
var G__37877 = arg1;
var G__37878 = arg2;
var G__37879 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__37876,G__37877,G__37878,G__37879) : f.call(null,G__37876,G__37877,G__37878,G__37879));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__37882 = arguments.length;
switch (G__37882) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__37884 = null;
var G__37884__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37884__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37884__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37884 = function(result,flake){
switch(arguments.length){
case 0:
return G__37884__0.call(this);
case 1:
return G__37884__1.call(this,result);
case 2:
return G__37884__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37884.cljs$core$IFn$_invoke$arity$0 = G__37884__0;
G__37884.cljs$core$IFn$_invoke$arity$1 = G__37884__1;
G__37884.cljs$core$IFn$_invoke$arity$2 = G__37884__2;
return G__37884;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37885 = null;
var G__37885__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37885__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37885__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37885 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37885__0.call(this);
case 1:
return G__37885__1.call(this,result);
case 2:
return G__37885__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37885.cljs$core$IFn$_invoke$arity$0 = G__37885__0;
G__37885.cljs$core$IFn$_invoke$arity$1 = G__37885__1;
G__37885.cljs$core$IFn$_invoke$arity$2 = G__37885__2;
return G__37885;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37887 = res;
var G__37887__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37886_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37886_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37887):G__37887);
var G__37887__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37887__$1):G__37887__$1);
var G__37887__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37887__$2):G__37887__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37887__$3);
} else {
return G__37887__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37891 = arguments.length;
switch (G__37891) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_38263){
var state_val_38264 = (state_38263[(1)]);
if((state_val_38264 === (65))){
var inst_38045 = (state_38263[(2)]);
var inst_38046 = fluree.db.util.async.throw_err(inst_38045);
var state_38263__$1 = (function (){var statearr_38265 = state_38263;
(statearr_38265[(7)] = inst_38046);

return statearr_38265;
})();
if(cljs.core.truth_(fuel)){
var statearr_38266_38451 = state_38263__$1;
(statearr_38266_38451[(1)] = (66));

} else {
var statearr_38267_38452 = state_38263__$1;
(statearr_38267_38452[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (70))){
var inst_38069 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38077 = flakes;
var inst_38078 = cljs.core.seq(inst_38077);
var inst_38079 = cljs.core.first(inst_38078);
var inst_38080 = cljs.core.next(inst_38078);
var inst_38081 = cljs.core.PersistentVector.EMPTY;
var inst_38082 = inst_38077;
var inst_38083 = inst_38081;
var state_38263__$1 = (function (){var statearr_38268 = state_38263;
(statearr_38268[(8)] = inst_38083);

(statearr_38268[(9)] = inst_38080);

(statearr_38268[(10)] = inst_38069);

(statearr_38268[(11)] = inst_38082);

(statearr_38268[(12)] = inst_38079);

return statearr_38268;
})();
var statearr_38269_38453 = state_38263__$1;
(statearr_38269_38453[(2)] = null);

(statearr_38269_38453[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (62))){
var inst_38036 = (state_38263[(13)]);
var inst_38039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38040 = inst_38036.o;
var inst_38041 = [inst_38040];
var inst_38042 = (new cljs.core.PersistentVector(null,1,(5),inst_38039,inst_38041,null));
var inst_38043 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38042);
var state_38263__$1 = state_38263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38263__$1,(65),inst_38043);
} else {
if((state_val_38264 === (74))){
var inst_38069 = (state_38263[(10)]);
var inst_38125 = (state_38263[(2)]);
var inst_38126 = [inst_38125,offset_map];
var inst_38127 = (new cljs.core.PersistentVector(null,2,(5),inst_38069,inst_38126,null));
var state_38263__$1 = state_38263;
var statearr_38270_38454 = state_38263__$1;
(statearr_38270_38454[(2)] = inst_38127);

(statearr_38270_38454[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (110))){
var inst_38233 = (state_38263[(14)]);
var inst_38236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38237 = [acc,inst_38233];
var inst_38238 = (new cljs.core.PersistentVector(null,2,(5),inst_38236,inst_38237,null));
var state_38263__$1 = state_38263;
var statearr_38271_38455 = state_38263__$1;
(statearr_38271_38455[(2)] = inst_38238);

(statearr_38271_38455[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (7))){
var inst_37903 = (state_38263[(15)]);
var state_38263__$1 = state_38263;
var statearr_38272_38456 = state_38263__$1;
(statearr_38272_38456[(2)] = inst_37903);

(statearr_38272_38456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (59))){
var inst_38227 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38273_38457 = state_38263__$1;
(statearr_38273_38457[(2)] = inst_38227);

(statearr_38273_38457[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (86))){
var inst_38129 = (state_38263[(16)]);
var state_38263__$1 = state_38263;
var statearr_38274_38458 = state_38263__$1;
(statearr_38274_38458[(2)] = inst_38129);

(statearr_38274_38458[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (20))){
var inst_37944 = (state_38263[(17)]);
var inst_37945 = (state_38263[(18)]);
var inst_37932 = (state_38263[(19)]);
var inst_37943 = (state_38263[(2)]);
var inst_37944__$1 = cljs.core.__destructure_map(inst_37932);
var inst_37945__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$limit);
var inst_37948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$orderBy);
var inst_37949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$offset);
var inst_37950 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37944__$1,cljs.core.cst$kw$p);
var state_38263__$1 = (function (){var statearr_38275 = state_38263;
(statearr_38275[(20)] = inst_37947);

(statearr_38275[(21)] = inst_37949);

(statearr_38275[(17)] = inst_37944__$1);

(statearr_38275[(18)] = inst_37945__$1);

(statearr_38275[(22)] = inst_37943);

(statearr_38275[(23)] = inst_37950);

(statearr_38275[(24)] = inst_37948);

(statearr_38275[(25)] = inst_37946);

return statearr_38275;
})();
if(cljs.core.truth_(inst_37945__$1)){
var statearr_38276_38459 = state_38263__$1;
(statearr_38276_38459[(1)] = (24));

} else {
var statearr_38277_38460 = state_38263__$1;
(statearr_38277_38460[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (72))){
var inst_38225 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38278_38461 = state_38263__$1;
(statearr_38278_38461[(2)] = inst_38225);

(statearr_38278_38461[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (58))){
var inst_37932 = (state_38263[(19)]);
var inst_38067 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_38067)){
var statearr_38279_38462 = state_38263__$1;
(statearr_38279_38462[(1)] = (70));

} else {
var statearr_38280_38463 = state_38263__$1;
(statearr_38280_38463[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (60))){
var inst_38036 = (state_38263[(13)]);
var inst_38029 = (state_38263[(26)]);
var inst_38035 = cljs.core.seq(inst_38029);
var inst_38036__$1 = cljs.core.first(inst_38035);
var inst_38037 = cljs.core.next(inst_38035);
var state_38263__$1 = (function (){var statearr_38281 = state_38263;
(statearr_38281[(13)] = inst_38036__$1);

(statearr_38281[(27)] = inst_38037);

return statearr_38281;
})();
if(cljs.core.truth_(inst_38036__$1)){
var statearr_38282_38464 = state_38263__$1;
(statearr_38282_38464[(1)] = (62));

} else {
var statearr_38283_38465 = state_38263__$1;
(statearr_38283_38465[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (27))){
var inst_37949 = (state_38263[(21)]);
var inst_37953 = (state_38263[(28)]);
var inst_37953__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37949);
var state_38263__$1 = (function (){var statearr_38284 = state_38263;
(statearr_38284[(28)] = inst_37953__$1);

return statearr_38284;
})();
if(inst_37953__$1){
var statearr_38285_38466 = state_38263__$1;
(statearr_38285_38466[(1)] = (30));

} else {
var statearr_38286_38467 = state_38263__$1;
(statearr_38286_38467[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (1))){
var state_38263__$1 = state_38263;
var statearr_38287_38468 = state_38263__$1;
(statearr_38287_38468[(2)] = null);

(statearr_38287_38468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (69))){
var inst_38037 = (state_38263[(27)]);
var inst_38030 = (state_38263[(29)]);
var inst_38055 = (state_38263[(2)]);
var inst_38056 = fluree.db.util.async.throw_err(inst_38055);
var inst_38057 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38030,inst_38056);
var inst_38029 = inst_38037;
var inst_38030__$1 = inst_38057;
var state_38263__$1 = (function (){var statearr_38288 = state_38263;
(statearr_38288[(26)] = inst_38029);

(statearr_38288[(29)] = inst_38030__$1);

return statearr_38288;
})();
var statearr_38289_38469 = state_38263__$1;
(statearr_38289_38469[(2)] = null);

(statearr_38289_38469[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (101))){
var inst_38170 = (state_38263[(30)]);
var inst_38190 = cljs.core.count(inst_38170);
var inst_38191 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_38190);
var state_38263__$1 = state_38263;
var statearr_38290_38470 = state_38263__$1;
(statearr_38290_38470[(2)] = inst_38191);

(statearr_38290_38470[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (24))){
var inst_37949 = (state_38263[(21)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37949)){
var statearr_38291_38471 = state_38263__$1;
(statearr_38291_38471[(1)] = (27));

} else {
var statearr_38292_38472 = state_38263__$1;
(statearr_38292_38472[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (102))){
var state_38263__$1 = state_38263;
var statearr_38293_38473 = state_38263__$1;
(statearr_38293_38473[(2)] = null);

(statearr_38293_38473[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (55))){
var inst_37932 = (state_38263[(19)]);
var inst_38005 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = state_38263;
var statearr_38294_38474 = state_38263__$1;
(statearr_38294_38474[(2)] = inst_38005);

(statearr_38294_38474[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (85))){
var inst_37932 = (state_38263[(19)]);
var inst_38131 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = state_38263;
var statearr_38295_38475 = state_38263__$1;
(statearr_38295_38475[(2)] = inst_38131);

(statearr_38295_38475[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (39))){
var inst_37980 = (state_38263[(31)]);
var inst_37948 = (state_38263[(24)]);
var inst_37980__$1 = cljs.core.not(inst_37948);
var state_38263__$1 = (function (){var statearr_38296 = state_38263;
(statearr_38296[(31)] = inst_37980__$1);

return statearr_38296;
})();
if(inst_37980__$1){
var statearr_38297_38476 = state_38263__$1;
(statearr_38297_38476[(1)] = (42));

} else {
var statearr_38298_38477 = state_38263__$1;
(statearr_38298_38477[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (88))){
var inst_38136 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38144 = flakes;
var inst_38145 = cljs.core.seq(inst_38144);
var inst_38146 = cljs.core.first(inst_38145);
var inst_38147 = cljs.core.next(inst_38145);
var inst_38148 = cljs.core.PersistentVector.EMPTY;
var inst_38149 = inst_38144;
var inst_38150 = inst_38148;
var state_38263__$1 = (function (){var statearr_38299 = state_38263;
(statearr_38299[(32)] = inst_38146);

(statearr_38299[(33)] = inst_38149);

(statearr_38299[(34)] = inst_38147);

(statearr_38299[(35)] = inst_38136);

(statearr_38299[(36)] = inst_38150);

return statearr_38299;
})();
var statearr_38300_38478 = state_38263__$1;
(statearr_38300_38478[(2)] = null);

(statearr_38300_38478[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (46))){
var inst_37947 = (state_38263[(20)]);
var state_38263__$1 = state_38263;
var statearr_38301_38479 = state_38263__$1;
(statearr_38301_38479[(2)] = inst_37947);

(statearr_38301_38479[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (4))){
var inst_37892 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38302_38480 = state_38263__$1;
(statearr_38302_38480[(2)] = inst_37892);

(statearr_38302_38480[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (77))){
var inst_38123 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38303_38481 = state_38263__$1;
(statearr_38303_38481[(2)] = inst_38123);

(statearr_38303_38481[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (106))){
var inst_38221 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38304_38482 = state_38263__$1;
(statearr_38304_38482[(2)] = inst_38221);

(statearr_38304_38482[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (95))){
var inst_38198 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38305_38483 = state_38263__$1;
(statearr_38305_38483[(2)] = inst_38198);

(statearr_38305_38483[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (54))){
var inst_38002 = (state_38263[(37)]);
var state_38263__$1 = state_38263;
var statearr_38306_38484 = state_38263__$1;
(statearr_38306_38484[(2)] = inst_38002);

(statearr_38306_38484[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (92))){
var inst_38136 = (state_38263[(35)]);
var inst_38200 = (state_38263[(2)]);
var inst_38201 = [inst_38200,offset_map];
var inst_38202 = (new cljs.core.PersistentVector(null,2,(5),inst_38136,inst_38201,null));
var state_38263__$1 = state_38263;
var statearr_38307_38485 = state_38263__$1;
(statearr_38307_38485[(2)] = inst_38202);

(statearr_38307_38485[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (104))){
var inst_37947 = (state_38263[(20)]);
var inst_37949 = (state_38263[(21)]);
var inst_37944 = (state_38263[(17)]);
var inst_37945 = (state_38263[(18)]);
var inst_37943 = (state_38263[(22)]);
var inst_37902 = (state_38263[(38)]);
var inst_37950 = (state_38263[(23)]);
var inst_37948 = (state_38263[(24)]);
var inst_37932 = (state_38263[(19)]);
var inst_37946 = (state_38263[(25)]);
var inst_37917 = (state_38263[(39)]);
var inst_38205 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38206 = (function (){var p = inst_37950;
var pred_spec__$1 = inst_37917;
var orderBy = inst_37948;
var multi_QMARK_ = inst_37945;
var limit = inst_37947;
var offset = inst_37949;
var map__37898 = inst_37944;
var k = inst_37943;
var compact_QMARK_ = inst_37902;
var pred_spec_SINGLEQUOTE_ = inst_37932;
var ref_QMARK_ = inst_37946;
return (function (p1__37888_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_id],[p1__37888_SHARP_.o]);
});
})();
var inst_38207 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38206,flakes);
var inst_38208 = [inst_38207,offset_map];
var inst_38209 = (new cljs.core.PersistentVector(null,2,(5),inst_38205,inst_38208,null));
var state_38263__$1 = state_38263;
var statearr_38308_38486 = state_38263__$1;
(statearr_38308_38486[(2)] = inst_38209);

(statearr_38308_38486[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (15))){
var inst_37902 = (state_38263[(38)]);
var inst_37925 = (state_38263[(40)]);
var inst_37929 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37925,cljs.core.cst$kw$compact_QMARK_,inst_37902);
var state_38263__$1 = state_38263;
var statearr_38309_38487 = state_38263__$1;
(statearr_38309_38487[(2)] = inst_37929);

(statearr_38309_38487[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (48))){
var inst_37996 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37997 = [null,offset_map];
var inst_37998 = (new cljs.core.PersistentVector(null,2,(5),inst_37996,inst_37997,null));
var state_38263__$1 = state_38263;
var statearr_38310_38488 = state_38263__$1;
(statearr_38310_38488[(2)] = inst_37998);

(statearr_38310_38488[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (50))){
var inst_38229 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38311_38489 = state_38263__$1;
(statearr_38311_38489[(2)] = inst_38229);

(statearr_38311_38489[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (116))){
var inst_37943 = (state_38263[(22)]);
var inst_38232 = (state_38263[(41)]);
var inst_38233 = (state_38263[(14)]);
var inst_38247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38248 = cljs.core.first(inst_38232);
var inst_38249 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37943,inst_38248);
var inst_38250 = [inst_38249,inst_38233];
var inst_38251 = (new cljs.core.PersistentVector(null,2,(5),inst_38247,inst_38250,null));
var state_38263__$1 = state_38263;
var statearr_38312_38490 = state_38263__$1;
(statearr_38312_38490[(2)] = inst_38251);

(statearr_38312_38490[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (75))){
var inst_38098 = (state_38263[(42)]);
var inst_38089 = (state_38263[(43)]);
var inst_37932 = (state_38263[(19)]);
var inst_38092 = cljs.core.deref(cache);
var inst_38093 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38094 = inst_38089.o;
var inst_38095 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38096 = [inst_38094,inst_38095];
var inst_38097 = (new cljs.core.PersistentVector(null,2,(5),inst_38093,inst_38096,null));
var inst_38098__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38092,inst_38097);
var state_38263__$1 = (function (){var statearr_38313 = state_38263;
(statearr_38313[(42)] = inst_38098__$1);

return statearr_38313;
})();
if(cljs.core.truth_(inst_38098__$1)){
var statearr_38314_38491 = state_38263__$1;
(statearr_38314_38491[(1)] = (78));

} else {
var statearr_38315_38492 = state_38263__$1;
(statearr_38315_38492[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (99))){
var inst_38188 = (state_38263[(2)]);
var state_38263__$1 = (function (){var statearr_38316 = state_38263;
(statearr_38316[(44)] = inst_38188);

return statearr_38316;
})();
if(cljs.core.truth_(fuel)){
var statearr_38317_38493 = state_38263__$1;
(statearr_38317_38493[(1)] = (101));

} else {
var statearr_38318_38494 = state_38263__$1;
(statearr_38318_38494[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (21))){
var inst_37936 = (state_38263[(45)]);
var state_38263__$1 = state_38263;
var statearr_38319_38495 = state_38263__$1;
(statearr_38319_38495[(2)] = inst_37936);

(statearr_38319_38495[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (31))){
var inst_37953 = (state_38263[(28)]);
var state_38263__$1 = state_38263;
var statearr_38320_38496 = state_38263__$1;
(statearr_38320_38496[(2)] = inst_37953);

(statearr_38320_38496[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (113))){
var inst_37943 = (state_38263[(22)]);
var inst_38232 = (state_38263[(41)]);
var inst_38233 = (state_38263[(14)]);
var inst_38241 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38242 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37943,inst_38232);
var inst_38243 = [inst_38242,inst_38233];
var inst_38244 = (new cljs.core.PersistentVector(null,2,(5),inst_38241,inst_38243,null));
var state_38263__$1 = state_38263;
var statearr_38321_38497 = state_38263__$1;
(statearr_38321_38497[(2)] = inst_38244);

(statearr_38321_38497[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (32))){
var inst_37959 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38322_38498 = state_38263__$1;
(statearr_38322_38498[(2)] = inst_37959);

(statearr_38322_38498[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (40))){
var inst_37945 = (state_38263[(18)]);
var state_38263__$1 = state_38263;
var statearr_38323_38499 = state_38263__$1;
(statearr_38323_38499[(2)] = inst_37945);

(statearr_38323_38499[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (91))){
var inst_38156 = (state_38263[(46)]);
var inst_38149 = (state_38263[(33)]);
var inst_38155 = cljs.core.seq(inst_38149);
var inst_38156__$1 = cljs.core.first(inst_38155);
var inst_38157 = cljs.core.next(inst_38155);
var state_38263__$1 = (function (){var statearr_38324 = state_38263;
(statearr_38324[(47)] = inst_38157);

(statearr_38324[(46)] = inst_38156__$1);

return statearr_38324;
})();
if(cljs.core.truth_(inst_38156__$1)){
var statearr_38325_38500 = state_38263__$1;
(statearr_38325_38500[(1)] = (93));

} else {
var statearr_38326_38501 = state_38263__$1;
(statearr_38326_38501[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (117))){
var state_38263__$1 = state_38263;
var statearr_38327_38502 = state_38263__$1;
(statearr_38327_38502[(2)] = null);

(statearr_38327_38502[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (108))){
var state_38263__$1 = state_38263;
var statearr_38328_38503 = state_38263__$1;
(statearr_38328_38503[(2)] = null);

(statearr_38328_38503[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (56))){
var inst_38007 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38329_38504 = state_38263__$1;
(statearr_38329_38504[(2)] = inst_38007);

(statearr_38329_38504[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (33))){
var inst_37950 = (state_38263[(23)]);
var inst_37967 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37968 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37950);
var state_38263__$1 = (function (){var statearr_38330 = state_38263;
(statearr_38330[(48)] = inst_37967);

return statearr_38330;
})();
if(cljs.core.truth_(inst_37968)){
var statearr_38331_38505 = state_38263__$1;
(statearr_38331_38505[(1)] = (36));

} else {
var statearr_38332_38506 = state_38263__$1;
(statearr_38332_38506[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (13))){
var inst_37917 = (state_38263[(39)]);
var state_38263__$1 = state_38263;
var statearr_38333_38507 = state_38263__$1;
(statearr_38333_38507[(2)] = inst_37917);

(statearr_38333_38507[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (22))){
var inst_37932 = (state_38263[(19)]);
var inst_37939 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = state_38263;
var statearr_38334_38508 = state_38263__$1;
(statearr_38334_38508[(2)] = inst_37939);

(statearr_38334_38508[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (90))){
var inst_38223 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38335_38509 = state_38263__$1;
(statearr_38335_38509[(2)] = inst_38223);

(statearr_38335_38509[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (109))){
var inst_38219 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38336_38510 = state_38263__$1;
(statearr_38336_38510[(2)] = inst_38219);

(statearr_38336_38510[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (36))){
var inst_37950 = (state_38263[(23)]);
var inst_37970 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37950,cljs.core.dec);
var state_38263__$1 = state_38263;
var statearr_38337_38511 = state_38263__$1;
(statearr_38337_38511[(2)] = inst_37970);

(statearr_38337_38511[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (41))){
var inst_37994 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37994)){
var statearr_38338_38512 = state_38263__$1;
(statearr_38338_38512[(1)] = (48));

} else {
var statearr_38339_38513 = state_38263__$1;
(statearr_38339_38513[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (118))){
var inst_38254 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38340_38514 = state_38263__$1;
(statearr_38340_38514[(2)] = inst_38254);

(statearr_38340_38514[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (89))){
var inst_37946 = (state_38263[(25)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37946)){
var statearr_38341_38515 = state_38263__$1;
(statearr_38341_38515[(1)] = (104));

} else {
var statearr_38342_38516 = state_38263__$1;
(statearr_38342_38516[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (100))){
var inst_38150 = (state_38263[(36)]);
var inst_38184 = (state_38263[(2)]);
var inst_38185 = fluree.db.util.async.throw_err(inst_38184);
var inst_38186 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38150,inst_38185);
var state_38263__$1 = state_38263;
var statearr_38343_38517 = state_38263__$1;
(statearr_38343_38517[(2)] = inst_38186);

(statearr_38343_38517[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (43))){
var inst_37980 = (state_38263[(31)]);
var state_38263__$1 = state_38263;
var statearr_38344_38518 = state_38263__$1;
(statearr_38344_38518[(2)] = inst_37980);

(statearr_38344_38518[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (61))){
var inst_38016 = (state_38263[(49)]);
var inst_38063 = (state_38263[(2)]);
var inst_38064 = [inst_38063,offset_map];
var inst_38065 = (new cljs.core.PersistentVector(null,2,(5),inst_38016,inst_38064,null));
var state_38263__$1 = state_38263;
var statearr_38345_38519 = state_38263__$1;
(statearr_38345_38519[(2)] = inst_38065);

(statearr_38345_38519[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (29))){
var inst_37962 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38346_38520 = state_38263__$1;
(statearr_38346_38520[(2)] = inst_37962);

(statearr_38346_38520[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (44))){
var inst_37991 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38347_38521 = state_38263__$1;
(statearr_38347_38521[(2)] = inst_37991);

(statearr_38347_38521[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (93))){
var inst_38156 = (state_38263[(46)]);
var inst_37932 = (state_38263[(19)]);
var inst_38159 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38160 = inst_38156.o;
var inst_38161 = [inst_38160];
var inst_38162 = (new cljs.core.PersistentVector(null,1,(5),inst_38159,inst_38161,null));
var inst_38163 = [cljs.core.cst$kw$limit];
var inst_38164 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38165 = [inst_38164];
var inst_38166 = cljs.core.PersistentHashMap.fromArrays(inst_38163,inst_38165);
var inst_38167 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38162,inst_38166);
var state_38263__$1 = state_38263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38263__$1,(96),inst_38167);
} else {
if((state_val_38264 === (6))){
var inst_37905 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37906 = (inst_37905 == null);
var state_38263__$1 = state_38263;
var statearr_38348_38522 = state_38263__$1;
(statearr_38348_38522[(2)] = inst_37906);

(statearr_38348_38522[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (111))){
var inst_37945 = (state_38263[(18)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37945)){
var statearr_38349_38523 = state_38263__$1;
(statearr_38349_38523[(1)] = (113));

} else {
var statearr_38350_38524 = state_38263__$1;
(statearr_38350_38524[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (28))){
var inst_37949 = (state_38263[(21)]);
var state_38263__$1 = state_38263;
var statearr_38351_38525 = state_38263__$1;
(statearr_38351_38525[(2)] = inst_37949);

(statearr_38351_38525[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (64))){
var inst_38061 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38352_38526 = state_38263__$1;
(statearr_38352_38526[(2)] = inst_38061);

(statearr_38352_38526[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (103))){
var inst_38188 = (state_38263[(44)]);
var inst_38157 = (state_38263[(47)]);
var inst_38194 = (state_38263[(2)]);
var inst_38149 = inst_38157;
var inst_38150 = inst_38188;
var state_38263__$1 = (function (){var statearr_38353 = state_38263;
(statearr_38353[(50)] = inst_38194);

(statearr_38353[(33)] = inst_38149);

(statearr_38353[(36)] = inst_38150);

return statearr_38353;
})();
var statearr_38354_38527 = state_38263__$1;
(statearr_38354_38527[(2)] = null);

(statearr_38354_38527[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (51))){
var inst_38002 = (state_38263[(37)]);
var inst_37932 = (state_38263[(19)]);
var inst_38002__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = (function (){var statearr_38355 = state_38263;
(statearr_38355[(37)] = inst_38002__$1);

return statearr_38355;
})();
if(cljs.core.truth_(inst_38002__$1)){
var statearr_38356_38528 = state_38263__$1;
(statearr_38356_38528[(1)] = (54));

} else {
var statearr_38357_38529 = state_38263__$1;
(statearr_38357_38529[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (25))){
var inst_37945 = (state_38263[(18)]);
var state_38263__$1 = state_38263;
var statearr_38358_38530 = state_38263__$1;
(statearr_38358_38530[(2)] = inst_37945);

(statearr_38358_38530[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (34))){
var inst_37945 = (state_38263[(18)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37945)){
var statearr_38359_38531 = state_38263__$1;
(statearr_38359_38531[(1)] = (39));

} else {
var statearr_38360_38532 = state_38263__$1;
(statearr_38360_38532[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (17))){
var inst_37933 = (state_38263[(51)]);
var inst_37932 = (state_38263[(19)]);
var inst_37932__$1 = (state_38263[(2)]);
var inst_37933__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37932__$1);
var state_38263__$1 = (function (){var statearr_38361 = state_38263;
(statearr_38361[(51)] = inst_37933__$1);

(statearr_38361[(19)] = inst_37932__$1);

return statearr_38361;
})();
if(cljs.core.truth_(inst_37933__$1)){
var statearr_38362_38533 = state_38263__$1;
(statearr_38362_38533[(1)] = (18));

} else {
var statearr_38363_38534 = state_38263__$1;
(statearr_38363_38534[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (3))){
var inst_38261 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38263__$1,inst_38261);
} else {
if((state_val_38264 === (12))){
var inst_37917 = (state_38263[(39)]);
var inst_37922 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37917,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_38263__$1 = state_38263;
var statearr_38364_38535 = state_38263__$1;
(statearr_38364_38535[(2)] = inst_37922);

(statearr_38364_38535[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (2))){
var inst_37903 = (state_38263[(15)]);
var _ = (function (){var statearr_38365 = state_38263;
(statearr_38365[(4)] = cljs.core.cons((5),(state_38263[(4)])));

return statearr_38365;
})();
var inst_37902 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37903__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_38263__$1 = (function (){var statearr_38366 = state_38263;
(statearr_38366[(38)] = inst_37902);

(statearr_38366[(15)] = inst_37903__$1);

return statearr_38366;
})();
if(cljs.core.truth_(inst_37903__$1)){
var statearr_38367_38536 = state_38263__$1;
(statearr_38367_38536[(1)] = (6));

} else {
var statearr_38368_38537 = state_38263__$1;
(statearr_38368_38537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (66))){
var inst_38046 = (state_38263[(7)]);
var inst_38048 = cljs.core.count(inst_38046);
var inst_38049 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_38048);
var state_38263__$1 = state_38263;
var statearr_38369_38538 = state_38263__$1;
(statearr_38369_38538[(2)] = inst_38049);

(statearr_38369_38538[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (107))){
var inst_37947 = (state_38263[(20)]);
var inst_37949 = (state_38263[(21)]);
var inst_37944 = (state_38263[(17)]);
var inst_37945 = (state_38263[(18)]);
var inst_37943 = (state_38263[(22)]);
var inst_37902 = (state_38263[(38)]);
var inst_37950 = (state_38263[(23)]);
var inst_37948 = (state_38263[(24)]);
var inst_37932 = (state_38263[(19)]);
var inst_37946 = (state_38263[(25)]);
var inst_37917 = (state_38263[(39)]);
var inst_38212 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38213 = (function (){var p = inst_37950;
var pred_spec__$1 = inst_37917;
var orderBy = inst_37948;
var multi_QMARK_ = inst_37945;
var limit = inst_37947;
var offset = inst_37949;
var map__37898 = inst_37944;
var k = inst_37943;
var compact_QMARK_ = inst_37902;
var pred_spec_SINGLEQUOTE_ = inst_37932;
var ref_QMARK_ = inst_37946;
return (function (p1__37889_SHARP_){
return p1__37889_SHARP_.o;
});
})();
var inst_38214 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38213,flakes);
var inst_38215 = [inst_38214,offset_map];
var inst_38216 = (new cljs.core.PersistentVector(null,2,(5),inst_38212,inst_38215,null));
var state_38263__$1 = state_38263;
var statearr_38370_38539 = state_38263__$1;
(statearr_38370_38539[(2)] = inst_38216);

(statearr_38370_38539[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (23))){
var inst_37941 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38371_38540 = state_38263__$1;
(statearr_38371_38540[(2)] = inst_37941);

(statearr_38371_38540[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (47))){
var inst_37988 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38372_38541 = state_38263__$1;
(statearr_38372_38541[(2)] = inst_37988);

(statearr_38372_38541[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (35))){
var inst_38232 = (state_38263[(41)]);
var inst_38231 = (state_38263[(2)]);
var inst_38232__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38231,(0),null);
var inst_38233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38231,(1),null);
var inst_38234 = cljs.core.empty_QMARK_(inst_38232__$1);
var state_38263__$1 = (function (){var statearr_38373 = state_38263;
(statearr_38373[(41)] = inst_38232__$1);

(statearr_38373[(14)] = inst_38233);

return statearr_38373;
})();
if(inst_38234){
var statearr_38374_38542 = state_38263__$1;
(statearr_38374_38542[(1)] = (110));

} else {
var statearr_38375_38543 = state_38263__$1;
(statearr_38375_38543[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (82))){
var inst_38083 = (state_38263[(8)]);
var inst_38114 = (state_38263[(52)]);
var inst_38116 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38083,inst_38114);
var state_38263__$1 = state_38263;
var statearr_38376_38544 = state_38263__$1;
(statearr_38376_38544[(2)] = inst_38116);

(statearr_38376_38544[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (76))){
var inst_38083 = (state_38263[(8)]);
var state_38263__$1 = state_38263;
var statearr_38377_38545 = state_38263__$1;
(statearr_38377_38545[(2)] = inst_38083);

(statearr_38377_38545[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (97))){
var inst_38156 = (state_38263[(46)]);
var inst_38150 = (state_38263[(36)]);
var inst_38173 = [cljs.core.cst$kw$_id];
var inst_38174 = inst_38156.o;
var inst_38175 = [inst_38174];
var inst_38176 = cljs.core.PersistentHashMap.fromArrays(inst_38173,inst_38175);
var inst_38177 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38150,inst_38176);
var state_38263__$1 = state_38263;
var statearr_38378_38546 = state_38263__$1;
(statearr_38378_38546[(2)] = inst_38177);

(statearr_38378_38546[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (19))){
var inst_37936 = (state_38263[(45)]);
var inst_37932 = (state_38263[(19)]);
var inst_37936__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var state_38263__$1 = (function (){var statearr_38379 = state_38263;
(statearr_38379[(45)] = inst_37936__$1);

return statearr_38379;
})();
if(cljs.core.truth_(inst_37936__$1)){
var statearr_38380_38547 = state_38263__$1;
(statearr_38380_38547[(1)] = (21));

} else {
var statearr_38381_38548 = state_38263__$1;
(statearr_38381_38548[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (57))){
var inst_37932 = (state_38263[(19)]);
var inst_38012 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38013 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_38014 = (new cljs.core.PersistentVector(null,3,(5),inst_38012,inst_38013,null));
var inst_38015 = cljs.core.select_keys(inst_37932,inst_38014);
var inst_38016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38024 = flakes;
var inst_38025 = cljs.core.seq(inst_38024);
var inst_38026 = cljs.core.first(inst_38025);
var inst_38027 = cljs.core.next(inst_38025);
var inst_38028 = cljs.core.PersistentVector.EMPTY;
var inst_38029 = inst_38024;
var inst_38030 = inst_38028;
var state_38263__$1 = (function (){var statearr_38382 = state_38263;
(statearr_38382[(53)] = inst_38026);

(statearr_38382[(49)] = inst_38016);

(statearr_38382[(54)] = inst_38015);

(statearr_38382[(55)] = inst_38027);

(statearr_38382[(26)] = inst_38029);

(statearr_38382[(29)] = inst_38030);

return statearr_38382;
})();
var statearr_38383_38549 = state_38263__$1;
(statearr_38383_38549[(2)] = null);

(statearr_38383_38549[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (68))){
var inst_38046 = (state_38263[(7)]);
var inst_38015 = (state_38263[(54)]);
var inst_38052 = (state_38263[(2)]);
var inst_38053 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38015,inst_38046) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38015,inst_38046));
var state_38263__$1 = (function (){var statearr_38384 = state_38263;
(statearr_38384[(56)] = inst_38052);

return statearr_38384;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38263__$1,(69),inst_38053);
} else {
if((state_val_38264 === (11))){
var inst_37917 = (state_38263[(39)]);
var inst_37917__$1 = (state_38263[(2)]);
var inst_37919 = cljs.core.contains_QMARK_(inst_37917__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_37920 = (!(inst_37919));
var state_38263__$1 = (function (){var statearr_38385 = state_38263;
(statearr_38385[(39)] = inst_37917__$1);

return statearr_38385;
})();
if(inst_37920){
var statearr_38386_38550 = state_38263__$1;
(statearr_38386_38550[(1)] = (12));

} else {
var statearr_38387_38551 = state_38263__$1;
(statearr_38387_38551[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (115))){
var inst_38256 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
var statearr_38389_38552 = state_38263__$1;
(statearr_38389_38552[(2)] = inst_38256);

(statearr_38389_38552[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (9))){
var inst_37911 = cljs.core.first(flakes);
var inst_37912 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37911);
var inst_37913 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37914 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37912,inst_37913);
var state_38263__$1 = state_38263;
var statearr_38390_38553 = state_38263__$1;
(statearr_38390_38553[(2)] = inst_37914);

(statearr_38390_38553[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (5))){
var _ = (function (){var statearr_38391 = state_38263;
(statearr_38391[(4)] = cljs.core.rest((state_38263[(4)])));

return statearr_38391;
})();
var state_38263__$1 = state_38263;
var ex38388 = (state_38263__$1[(2)]);
var statearr_38392_38554 = state_38263__$1;
(statearr_38392_38554[(5)] = ex38388);


if((ex38388 instanceof Error)){
var statearr_38393_38555 = state_38263__$1;
(statearr_38393_38555[(1)] = (4));

(statearr_38393_38555[(5)] = null);

} else {
throw ex38388;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (112))){
var inst_38258 = (state_38263[(2)]);
var _ = (function (){var statearr_38394 = state_38263;
(statearr_38394[(4)] = cljs.core.rest((state_38263[(4)])));

return statearr_38394;
})();
var state_38263__$1 = state_38263;
var statearr_38395_38556 = state_38263__$1;
(statearr_38395_38556[(2)] = inst_38258);

(statearr_38395_38556[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (83))){
var inst_38083 = (state_38263[(8)]);
var state_38263__$1 = state_38263;
var statearr_38396_38557 = state_38263__$1;
(statearr_38396_38557[(2)] = inst_38083);

(statearr_38396_38557[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (14))){
var inst_37917 = (state_38263[(39)]);
var inst_37925 = (state_38263[(2)]);
var inst_37926 = cljs.core.contains_QMARK_(inst_37917,cljs.core.cst$kw$compact_QMARK_);
var inst_37927 = (!(inst_37926));
var state_38263__$1 = (function (){var statearr_38397 = state_38263;
(statearr_38397[(40)] = inst_37925);

return statearr_38397;
})();
if(inst_37927){
var statearr_38398_38558 = state_38263__$1;
(statearr_38398_38558[(1)] = (15));

} else {
var statearr_38399_38559 = state_38263__$1;
(statearr_38399_38559[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (45))){
var inst_37947 = (state_38263[(20)]);
var inst_37943 = (state_38263[(22)]);
var inst_37983 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37943);
var inst_37984 = cljs.core.count(inst_37983);
var inst_37985 = (inst_37984 >= inst_37947);
var state_38263__$1 = state_38263;
var statearr_38400_38560 = state_38263__$1;
(statearr_38400_38560[(2)] = inst_37985);

(statearr_38400_38560[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (53))){
var inst_38010 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_38010)){
var statearr_38401_38561 = state_38263__$1;
(statearr_38401_38561[(1)] = (57));

} else {
var statearr_38402_38562 = state_38263__$1;
(statearr_38402_38562[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (78))){
var inst_38098 = (state_38263[(42)]);
var state_38263__$1 = state_38263;
var statearr_38403_38563 = state_38263__$1;
(statearr_38403_38563[(2)] = inst_38098);

(statearr_38403_38563[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (26))){
var inst_37965 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37965)){
var statearr_38404_38564 = state_38263__$1;
(statearr_38404_38564[(1)] = (33));

} else {
var statearr_38405_38565 = state_38263__$1;
(statearr_38405_38565[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (16))){
var inst_37925 = (state_38263[(40)]);
var state_38263__$1 = state_38263;
var statearr_38406_38566 = state_38263__$1;
(statearr_38406_38566[(2)] = inst_37925);

(statearr_38406_38566[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (81))){
var inst_38089 = (state_38263[(43)]);
var inst_37932 = (state_38263[(19)]);
var inst_38105 = (state_38263[(2)]);
var inst_38106 = fluree.db.util.async.throw_err(inst_38105);
var inst_38107 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38108 = inst_38089.o;
var inst_38109 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38110 = [inst_38108,inst_38109];
var inst_38111 = (new cljs.core.PersistentVector(null,2,(5),inst_38107,inst_38110,null));
var inst_38112 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_38111,inst_38106);
var state_38263__$1 = (function (){var statearr_38407 = state_38263;
(statearr_38407[(57)] = inst_38112);

return statearr_38407;
})();
var statearr_38408_38567 = state_38263__$1;
(statearr_38408_38567[(2)] = inst_38106);

(statearr_38408_38567[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (79))){
var inst_38089 = (state_38263[(43)]);
var inst_37932 = (state_38263[(19)]);
var inst_38101 = inst_38089.o;
var inst_38102 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37932);
var inst_38103 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_38101,inst_38102);
var state_38263__$1 = state_38263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38263__$1,(81),inst_38103);
} else {
if((state_val_38264 === (38))){
var inst_37967 = (state_38263[(48)]);
var inst_37975 = (state_38263[(2)]);
var inst_37976 = [null,inst_37975];
var inst_37977 = (new cljs.core.PersistentVector(null,2,(5),inst_37967,inst_37976,null));
var state_38263__$1 = state_38263;
var statearr_38409_38568 = state_38263__$1;
(statearr_38409_38568[(2)] = inst_37977);

(statearr_38409_38568[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (98))){
var inst_37902 = (state_38263[(38)]);
var inst_38170 = (state_38263[(30)]);
var inst_38179 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_];
var inst_38180 = [true,inst_37902];
var inst_38181 = cljs.core.PersistentHashMap.fromArrays(inst_38179,inst_38180);
var inst_38182 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38181,inst_38170) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38181,inst_38170));
var state_38263__$1 = state_38263;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38263__$1,(100),inst_38182);
} else {
if((state_val_38264 === (87))){
var inst_38134 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_38134)){
var statearr_38410_38569 = state_38263__$1;
(statearr_38410_38569[(1)] = (88));

} else {
var statearr_38411_38570 = state_38263__$1;
(statearr_38411_38570[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (30))){
var inst_37950 = (state_38263[(23)]);
var inst_37955 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37950);
var inst_37956 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37955);
var state_38263__$1 = state_38263;
var statearr_38412_38571 = state_38263__$1;
(statearr_38412_38571[(2)] = inst_37956);

(statearr_38412_38571[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (73))){
var inst_38082 = (state_38263[(11)]);
var inst_38089 = (state_38263[(43)]);
var inst_38088 = cljs.core.seq(inst_38082);
var inst_38089__$1 = cljs.core.first(inst_38088);
var inst_38090 = cljs.core.next(inst_38088);
var state_38263__$1 = (function (){var statearr_38413 = state_38263;
(statearr_38413[(58)] = inst_38090);

(statearr_38413[(43)] = inst_38089__$1);

return statearr_38413;
})();
if(cljs.core.truth_(inst_38089__$1)){
var statearr_38414_38572 = state_38263__$1;
(statearr_38414_38572[(1)] = (75));

} else {
var statearr_38415_38573 = state_38263__$1;
(statearr_38415_38573[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (96))){
var inst_38170 = (state_38263[(30)]);
var inst_38169 = (state_38263[(2)]);
var inst_38170__$1 = fluree.db.util.async.throw_err(inst_38169);
var inst_38171 = cljs.core.empty_QMARK_(inst_38170__$1);
var state_38263__$1 = (function (){var statearr_38416 = state_38263;
(statearr_38416[(30)] = inst_38170__$1);

return statearr_38416;
})();
if(inst_38171){
var statearr_38417_38574 = state_38263__$1;
(statearr_38417_38574[(1)] = (97));

} else {
var statearr_38418_38575 = state_38263__$1;
(statearr_38418_38575[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (10))){
var state_38263__$1 = state_38263;
var statearr_38419_38576 = state_38263__$1;
(statearr_38419_38576[(2)] = pred_spec);

(statearr_38419_38576[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (18))){
var inst_37933 = (state_38263[(51)]);
var state_38263__$1 = state_38263;
var statearr_38420_38577 = state_38263__$1;
(statearr_38420_38577[(2)] = inst_37933);

(statearr_38420_38577[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (105))){
var state_38263__$1 = state_38263;
var statearr_38421_38578 = state_38263__$1;
(statearr_38421_38578[(1)] = (107));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (52))){
var inst_38000 = (state_38263[(59)]);
var state_38263__$1 = state_38263;
var statearr_38423_38579 = state_38263__$1;
(statearr_38423_38579[(2)] = inst_38000);

(statearr_38423_38579[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (114))){
var state_38263__$1 = state_38263;
var statearr_38424_38580 = state_38263__$1;
(statearr_38424_38580[(1)] = (116));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (67))){
var state_38263__$1 = state_38263;
var statearr_38426_38581 = state_38263__$1;
(statearr_38426_38581[(2)] = null);

(statearr_38426_38581[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (71))){
var inst_38129 = (state_38263[(16)]);
var inst_38129__$1 = componentFollow_QMARK_;
var state_38263__$1 = (function (){var statearr_38427 = state_38263;
(statearr_38427[(16)] = inst_38129__$1);

return statearr_38427;
})();
if(cljs.core.truth_(inst_38129__$1)){
var statearr_38428_38582 = state_38263__$1;
(statearr_38428_38582[(1)] = (85));

} else {
var statearr_38429_38583 = state_38263__$1;
(statearr_38429_38583[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (42))){
var inst_37947 = (state_38263[(20)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37947)){
var statearr_38430_38584 = state_38263__$1;
(statearr_38430_38584[(1)] = (45));

} else {
var statearr_38431_38585 = state_38263__$1;
(statearr_38431_38585[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (80))){
var inst_38114 = (state_38263[(52)]);
var inst_38114__$1 = (state_38263[(2)]);
var state_38263__$1 = (function (){var statearr_38432 = state_38263;
(statearr_38432[(52)] = inst_38114__$1);

return statearr_38432;
})();
if(cljs.core.truth_(inst_38114__$1)){
var statearr_38433_38586 = state_38263__$1;
(statearr_38433_38586[(1)] = (82));

} else {
var statearr_38434_38587 = state_38263__$1;
(statearr_38434_38587[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (37))){
var inst_37949 = (state_38263[(21)]);
var inst_37950 = (state_38263[(23)]);
var inst_37972 = (inst_37949 - (1));
var inst_37973 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37950,inst_37972);
var state_38263__$1 = state_38263;
var statearr_38435_38588 = state_38263__$1;
(statearr_38435_38588[(2)] = inst_37973);

(statearr_38435_38588[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (63))){
var inst_38030 = (state_38263[(29)]);
var state_38263__$1 = state_38263;
var statearr_38436_38589 = state_38263__$1;
(statearr_38436_38589[(2)] = inst_38030);

(statearr_38436_38589[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (94))){
var inst_38150 = (state_38263[(36)]);
var state_38263__$1 = state_38263;
var statearr_38437_38590 = state_38263__$1;
(statearr_38437_38590[(2)] = inst_38150);

(statearr_38437_38590[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (8))){
var inst_37909 = (state_38263[(2)]);
var state_38263__$1 = state_38263;
if(cljs.core.truth_(inst_37909)){
var statearr_38438_38591 = state_38263__$1;
(statearr_38438_38591[(1)] = (9));

} else {
var statearr_38439_38592 = state_38263__$1;
(statearr_38439_38592[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (49))){
var inst_38000 = (state_38263[(59)]);
var inst_38000__$1 = cljs.core.not(recur_QMARK_);
var state_38263__$1 = (function (){var statearr_38440 = state_38263;
(statearr_38440[(59)] = inst_38000__$1);

return statearr_38440;
})();
if(inst_38000__$1){
var statearr_38441_38593 = state_38263__$1;
(statearr_38441_38593[(1)] = (51));

} else {
var statearr_38442_38594 = state_38263__$1;
(statearr_38442_38594[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38264 === (84))){
var inst_38090 = (state_38263[(58)]);
var inst_38119 = (state_38263[(2)]);
var inst_38082 = inst_38090;
var inst_38083 = inst_38119;
var state_38263__$1 = (function (){var statearr_38443 = state_38263;
(statearr_38443[(8)] = inst_38083);

(statearr_38443[(11)] = inst_38082);

return statearr_38443;
})();
var statearr_38444_38595 = state_38263__$1;
(statearr_38444_38595[(2)] = null);

(statearr_38444_38595[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_38445 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38445[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_38445[(1)] = (1));

return statearr_38445;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_38263){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_38263);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e38446){var ex__16398__auto__ = e38446;
var statearr_38447_38596 = state_38263;
(statearr_38447_38596[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_38263[(4)]))){
var statearr_38448_38597 = state_38263;
(statearr_38448_38597[(1)] = cljs.core.first((state_38263[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__38598 = state_38263;
state_38263 = G__38598;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_38263){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_38263);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_38449 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_38449[(6)] = c__16469__auto__);

return statearr_38449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_38758){
var state_val_38759 = (state_38758[(1)]);
if((state_val_38759 === (7))){
var inst_38753 = (state_38758[(2)]);
var _ = (function (){var statearr_38760 = state_38758;
(statearr_38760[(4)] = cljs.core.rest((state_38758[(4)])));

return statearr_38760;
})();
var state_38758__$1 = state_38758;
var statearr_38761_38843 = state_38758__$1;
(statearr_38761_38843[(2)] = inst_38753);

(statearr_38761_38843[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (20))){
var inst_38680 = (state_38758[(7)]);
var state_38758__$1 = state_38758;
var statearr_38762_38844 = state_38758__$1;
(statearr_38762_38844[(2)] = inst_38680);

(statearr_38762_38844[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (27))){
var inst_38635 = (state_38758[(8)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38635)){
var statearr_38763_38845 = state_38758__$1;
(statearr_38763_38845[(1)] = (29));

} else {
var statearr_38764_38846 = state_38758__$1;
(statearr_38764_38846[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (1))){
var state_38758__$1 = state_38758;
var statearr_38765_38847 = state_38758__$1;
(statearr_38765_38847[(2)] = null);

(statearr_38765_38847[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (24))){
var inst_38636 = (state_38758[(9)]);
var state_38758__$1 = state_38758;
var statearr_38766_38848 = state_38758__$1;
(statearr_38766_38848[(2)] = inst_38636);

(statearr_38766_38848[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (39))){
var inst_38672 = (state_38758[(10)]);
var state_38758__$1 = state_38758;
var statearr_38767_38849 = state_38758__$1;
(statearr_38767_38849[(2)] = inst_38672);

(statearr_38767_38849[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (46))){
var inst_38637 = (state_38758[(11)]);
var state_38758__$1 = state_38758;
var statearr_38768_38850 = state_38758__$1;
(statearr_38768_38850[(2)] = inst_38637);

(statearr_38768_38850[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (4))){
var inst_38599 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38769_38851 = state_38758__$1;
(statearr_38769_38851[(2)] = inst_38599);

(statearr_38769_38851[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (15))){
var inst_38648 = (state_38758[(12)]);
var inst_38654 = cljs.core.count(inst_38648);
var inst_38655 = fluree.db.query.fql.add_fuel(fuel,inst_38654,max_fuel);
var state_38758__$1 = state_38758;
var statearr_38770_38852 = state_38758__$1;
(statearr_38770_38852[(2)] = inst_38655);

(statearr_38770_38852[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (48))){
var inst_38617 = (state_38758[(13)]);
var inst_38739 = (state_38758[(14)]);
var inst_38624 = (state_38758[(15)]);
var inst_38747 = (state_38758[(2)]);
var inst_38748 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38617,inst_38747,inst_38739);
var inst_38616 = inst_38624;
var inst_38617__$1 = inst_38748;
var state_38758__$1 = (function (){var statearr_38771 = state_38758;
(statearr_38771[(13)] = inst_38617__$1);

(statearr_38771[(16)] = inst_38616);

return statearr_38771;
})();
var statearr_38772_38853 = state_38758__$1;
(statearr_38772_38853[(2)] = null);

(statearr_38772_38853[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (50))){
var inst_38639 = (state_38758[(17)]);
var state_38758__$1 = state_38758;
var statearr_38773_38854 = state_38758__$1;
(statearr_38773_38854[(2)] = inst_38639);

(statearr_38773_38854[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (21))){
var inst_38636 = (state_38758[(9)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38636)){
var statearr_38775_38855 = state_38758__$1;
(statearr_38775_38855[(1)] = (23));

} else {
var statearr_38776_38856 = state_38758__$1;
(statearr_38776_38856[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (31))){
var inst_38696 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38696)){
var statearr_38777_38857 = state_38758__$1;
(statearr_38777_38857[(1)] = (32));

} else {
var statearr_38778_38858 = state_38758__$1;
(statearr_38778_38858[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (32))){
var inst_38671 = (state_38758[(18)]);
var inst_38672 = (state_38758[(10)]);
var inst_38679 = (state_38758[(19)]);
var inst_38698 = (inst_38671 + (1));
var tmp38774 = inst_38672;
var inst_38670 = inst_38679;
var inst_38671__$1 = inst_38698;
var inst_38672__$1 = tmp38774;
var state_38758__$1 = (function (){var statearr_38779 = state_38758;
(statearr_38779[(18)] = inst_38671__$1);

(statearr_38779[(20)] = inst_38670);

(statearr_38779[(10)] = inst_38672__$1);

return statearr_38779;
})();
var statearr_38780_38859 = state_38758__$1;
(statearr_38780_38859[(2)] = null);

(statearr_38780_38859[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (40))){
var state_38758__$1 = state_38758;
if(cljs.core.truth_(fuel)){
var statearr_38781_38860 = state_38758__$1;
(statearr_38781_38860[(1)] = (42));

} else {
var statearr_38782_38861 = state_38758__$1;
(statearr_38782_38861[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (33))){
var state_38758__$1 = state_38758;
var statearr_38783_38862 = state_38758__$1;
(statearr_38783_38862[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (13))){
var inst_38648 = (state_38758[(12)]);
var state_38758__$1 = state_38758;
var statearr_38785_38863 = state_38758__$1;
(statearr_38785_38863[(2)] = inst_38648);

(statearr_38785_38863[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (22))){
var inst_38689 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38689)){
var statearr_38786_38864 = state_38758__$1;
(statearr_38786_38864[(1)] = (26));

} else {
var statearr_38787_38865 = state_38758__$1;
(statearr_38787_38865[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (36))){
var state_38758__$1 = state_38758;
var statearr_38788_38866 = state_38758__$1;
(statearr_38788_38866[(2)] = null);

(statearr_38788_38866[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (41))){
var inst_38671 = (state_38758[(18)]);
var inst_38679 = (state_38758[(19)]);
var inst_38728 = (state_38758[(2)]);
var inst_38729 = (inst_38671 + (1));
var inst_38670 = inst_38679;
var inst_38671__$1 = inst_38729;
var inst_38672 = inst_38728;
var state_38758__$1 = (function (){var statearr_38789 = state_38758;
(statearr_38789[(18)] = inst_38671__$1);

(statearr_38789[(20)] = inst_38670);

(statearr_38789[(10)] = inst_38672);

return statearr_38789;
})();
var statearr_38790_38867 = state_38758__$1;
(statearr_38790_38867[(2)] = null);

(statearr_38790_38867[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (43))){
var state_38758__$1 = state_38758;
var statearr_38791_38868 = state_38758__$1;
(statearr_38791_38868[(2)] = null);

(statearr_38791_38868[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (29))){
var inst_38671 = (state_38758[(18)]);
var inst_38635 = (state_38758[(8)]);
var inst_38693 = (inst_38671 < inst_38635);
var state_38758__$1 = state_38758;
var statearr_38792_38869 = state_38758__$1;
(statearr_38792_38869[(2)] = inst_38693);

(statearr_38792_38869[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (44))){
var inst_38708 = (state_38758[(21)]);
var inst_38712 = (state_38758[(22)]);
var inst_38721 = (state_38758[(2)]);
var inst_38722 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38712,inst_38708) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38712,inst_38708));
var state_38758__$1 = (function (){var statearr_38793 = state_38758;
(statearr_38793[(23)] = inst_38721);

return statearr_38793;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38758__$1,(45),inst_38722);
} else {
if((state_val_38759 === (6))){
var inst_38623 = (state_38758[(24)]);
var inst_38616 = (state_38758[(16)]);
var inst_38622 = cljs.core.seq(inst_38616);
var inst_38623__$1 = cljs.core.first(inst_38622);
var inst_38624 = cljs.core.next(inst_38622);
var inst_38625 = cljs.core.not(inst_38623__$1);
var state_38758__$1 = (function (){var statearr_38794 = state_38758;
(statearr_38794[(24)] = inst_38623__$1);

(statearr_38794[(15)] = inst_38624);

return statearr_38794;
})();
if(inst_38625){
var statearr_38795_38870 = state_38758__$1;
(statearr_38795_38870[(1)] = (8));

} else {
var statearr_38796_38871 = state_38758__$1;
(statearr_38796_38871[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (28))){
var inst_38737 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38797_38872 = state_38758__$1;
(statearr_38797_38872[(2)] = inst_38737);

(statearr_38797_38872[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (51))){
var inst_38745 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38798_38873 = state_38758__$1;
(statearr_38798_38873[(2)] = inst_38745);

(statearr_38798_38873[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (25))){
var inst_38687 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38799_38874 = state_38758__$1;
(statearr_38799_38874[(2)] = inst_38687);

(statearr_38799_38874[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (34))){
var inst_38735 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38800_38875 = state_38758__$1;
(statearr_38800_38875[(2)] = inst_38735);

(statearr_38800_38875[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (17))){
var inst_38648 = (state_38758[(12)]);
var inst_38658 = (state_38758[(2)]);
var inst_38666 = cljs.core.seq(inst_38648);
var inst_38667 = cljs.core.first(inst_38666);
var inst_38668 = cljs.core.next(inst_38666);
var inst_38669 = cljs.core.PersistentVector.EMPTY;
var inst_38670 = inst_38648;
var inst_38671 = (0);
var inst_38672 = inst_38669;
var state_38758__$1 = (function (){var statearr_38801 = state_38758;
(statearr_38801[(18)] = inst_38671);

(statearr_38801[(20)] = inst_38670);

(statearr_38801[(10)] = inst_38672);

(statearr_38801[(25)] = inst_38658);

(statearr_38801[(26)] = inst_38668);

(statearr_38801[(27)] = inst_38667);

return statearr_38801;
})();
var statearr_38802_38876 = state_38758__$1;
(statearr_38802_38876[(2)] = null);

(statearr_38802_38876[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (3))){
var inst_38756 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38758__$1,inst_38756);
} else {
if((state_val_38759 === (12))){
var state_38758__$1 = state_38758;
var statearr_38803_38877 = state_38758__$1;
(statearr_38803_38877[(2)] = fuel);

(statearr_38803_38877[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (2))){
var _ = (function (){var statearr_38804 = state_38758;
(statearr_38804[(4)] = cljs.core.cons((5),(state_38758[(4)])));

return statearr_38804;
})();
var inst_38612 = reverse_refs_specs;
var inst_38613 = cljs.core.seq(inst_38612);
var inst_38614 = cljs.core.first(inst_38613);
var inst_38615 = cljs.core.next(inst_38613);
var inst_38616 = inst_38612;
var inst_38617 = null;
var state_38758__$1 = (function (){var statearr_38805 = state_38758;
(statearr_38805[(28)] = inst_38615);

(statearr_38805[(13)] = inst_38617);

(statearr_38805[(29)] = inst_38614);

(statearr_38805[(16)] = inst_38616);

return statearr_38805;
})();
var statearr_38806_38878 = state_38758__$1;
(statearr_38806_38878[(2)] = null);

(statearr_38806_38878[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (23))){
var inst_38671 = (state_38758[(18)]);
var inst_38636 = (state_38758[(9)]);
var inst_38684 = (inst_38671 >= inst_38636);
var state_38758__$1 = state_38758;
var statearr_38807_38879 = state_38758__$1;
(statearr_38807_38879[(2)] = inst_38684);

(statearr_38807_38879[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (47))){
var inst_38638 = (state_38758[(30)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38638)){
var statearr_38808_38880 = state_38758__$1;
(statearr_38808_38880[(1)] = (49));

} else {
var statearr_38809_38881 = state_38758__$1;
(statearr_38809_38881[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (35))){
var inst_38678 = (state_38758[(31)]);
var inst_38702 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38703 = [inst_38678];
var inst_38704 = (new cljs.core.PersistentVector(null,1,(5),inst_38702,inst_38703,null));
var inst_38705 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38704);
var state_38758__$1 = state_38758;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38758__$1,(38),inst_38705);
} else {
if((state_val_38759 === (19))){
var inst_38637 = (state_38758[(11)]);
var inst_38739 = (state_38758[(2)]);
var state_38758__$1 = (function (){var statearr_38810 = state_38758;
(statearr_38810[(14)] = inst_38739);

return statearr_38810;
})();
if(cljs.core.truth_(inst_38637)){
var statearr_38811_38882 = state_38758__$1;
(statearr_38811_38882[(1)] = (46));

} else {
var statearr_38812_38883 = state_38758__$1;
(statearr_38812_38883[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (11))){
var inst_38648 = (state_38758[(12)]);
var inst_38645 = (state_38758[(2)]);
var inst_38646 = fluree.db.util.async.throw_err(inst_38645);
var inst_38647 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38646);
var inst_38648__$1 = cljs.core.not_empty(inst_38647);
var state_38758__$1 = (function (){var statearr_38814 = state_38758;
(statearr_38814[(12)] = inst_38648__$1);

return statearr_38814;
})();
if(cljs.core.truth_(inst_38648__$1)){
var statearr_38815_38884 = state_38758__$1;
(statearr_38815_38884[(1)] = (12));

} else {
var statearr_38816_38885 = state_38758__$1;
(statearr_38816_38885[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (9))){
var inst_38623 = (state_38758[(24)]);
var inst_38633 = (state_38758[(32)]);
var inst_38632 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38623,(0),null);
var inst_38633__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38623,(1),null);
var inst_38634 = cljs.core.__destructure_map(inst_38633__$1);
var inst_38635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38634,cljs.core.cst$kw$offset);
var inst_38636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38634,cljs.core.cst$kw$limit);
var inst_38637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38634,cljs.core.cst$kw$as);
var inst_38638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38634,cljs.core.cst$kw$name);
var inst_38639 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38634,cljs.core.cst$kw$p);
var inst_38640 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38641 = [subject_id,inst_38632];
var inst_38642 = (new cljs.core.PersistentVector(null,2,(5),inst_38640,inst_38641,null));
var inst_38643 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_38642);
var state_38758__$1 = (function (){var statearr_38817 = state_38758;
(statearr_38817[(30)] = inst_38638);

(statearr_38817[(17)] = inst_38639);

(statearr_38817[(32)] = inst_38633__$1);

(statearr_38817[(11)] = inst_38637);

(statearr_38817[(9)] = inst_38636);

(statearr_38817[(8)] = inst_38635);

return statearr_38817;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38758__$1,(11),inst_38643);
} else {
if((state_val_38759 === (5))){
var _ = (function (){var statearr_38818 = state_38758;
(statearr_38818[(4)] = cljs.core.rest((state_38758[(4)])));

return statearr_38818;
})();
var state_38758__$1 = state_38758;
var ex38813 = (state_38758__$1[(2)]);
var statearr_38819_38886 = state_38758__$1;
(statearr_38819_38886[(5)] = ex38813);


if((ex38813 instanceof Error)){
var statearr_38820_38887 = state_38758__$1;
(statearr_38820_38887[(1)] = (4));

(statearr_38820_38887[(5)] = null);

} else {
throw ex38813;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (14))){
var inst_38652 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
if(cljs.core.truth_(inst_38652)){
var statearr_38821_38888 = state_38758__$1;
(statearr_38821_38888[(1)] = (15));

} else {
var statearr_38822_38889 = state_38758__$1;
(statearr_38822_38889[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (45))){
var inst_38672 = (state_38758[(10)]);
var inst_38724 = (state_38758[(2)]);
var inst_38725 = fluree.db.util.async.throw_err(inst_38724);
var inst_38726 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38672,inst_38725);
var state_38758__$1 = state_38758;
var statearr_38823_38890 = state_38758__$1;
(statearr_38823_38890[(2)] = inst_38726);

(statearr_38823_38890[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (26))){
var inst_38672 = (state_38758[(10)]);
var state_38758__$1 = state_38758;
var statearr_38824_38891 = state_38758__$1;
(statearr_38824_38891[(2)] = inst_38672);

(statearr_38824_38891[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (16))){
var state_38758__$1 = state_38758;
var statearr_38825_38892 = state_38758__$1;
(statearr_38825_38892[(2)] = null);

(statearr_38825_38892[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (38))){
var inst_38708 = (state_38758[(21)]);
var inst_38633 = (state_38758[(32)]);
var inst_38707 = (state_38758[(2)]);
var inst_38708__$1 = fluree.db.util.async.throw_err(inst_38707);
var inst_38709 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38710 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_38711 = (new cljs.core.PersistentVector(null,4,(5),inst_38709,inst_38710,null));
var inst_38712 = cljs.core.select_keys(inst_38633,inst_38711);
var inst_38713 = cljs.core.empty_QMARK_(inst_38708__$1);
var state_38758__$1 = (function (){var statearr_38826 = state_38758;
(statearr_38826[(21)] = inst_38708__$1);

(statearr_38826[(22)] = inst_38712);

return statearr_38826;
})();
if(inst_38713){
var statearr_38827_38893 = state_38758__$1;
(statearr_38827_38893[(1)] = (39));

} else {
var statearr_38828_38894 = state_38758__$1;
(statearr_38828_38894[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (30))){
var inst_38635 = (state_38758[(8)]);
var state_38758__$1 = state_38758;
var statearr_38829_38895 = state_38758__$1;
(statearr_38829_38895[(2)] = inst_38635);

(statearr_38829_38895[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (10))){
var inst_38751 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38830_38896 = state_38758__$1;
(statearr_38830_38896[(2)] = inst_38751);

(statearr_38830_38896[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (18))){
var inst_38670 = (state_38758[(20)]);
var inst_38680 = (state_38758[(7)]);
var inst_38678 = (state_38758[(31)]);
var inst_38677 = cljs.core.seq(inst_38670);
var inst_38678__$1 = cljs.core.first(inst_38677);
var inst_38679 = cljs.core.next(inst_38677);
var inst_38680__$1 = cljs.core.not(inst_38678__$1);
var state_38758__$1 = (function (){var statearr_38831 = state_38758;
(statearr_38831[(19)] = inst_38679);

(statearr_38831[(7)] = inst_38680__$1);

(statearr_38831[(31)] = inst_38678__$1);

return statearr_38831;
})();
if(inst_38680__$1){
var statearr_38832_38897 = state_38758__$1;
(statearr_38832_38897[(1)] = (20));

} else {
var statearr_38833_38898 = state_38758__$1;
(statearr_38833_38898[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (42))){
var inst_38708 = (state_38758[(21)]);
var inst_38717 = cljs.core.count(inst_38708);
var inst_38718 = fluree.db.query.fql.add_fuel(fuel,inst_38717,max_fuel);
var state_38758__$1 = state_38758;
var statearr_38834_38899 = state_38758__$1;
(statearr_38834_38899[(2)] = inst_38718);

(statearr_38834_38899[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (37))){
var inst_38733 = (state_38758[(2)]);
var state_38758__$1 = state_38758;
var statearr_38835_38900 = state_38758__$1;
(statearr_38835_38900[(2)] = inst_38733);

(statearr_38835_38900[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (8))){
var inst_38617 = (state_38758[(13)]);
var state_38758__$1 = state_38758;
var statearr_38836_38901 = state_38758__$1;
(statearr_38836_38901[(2)] = inst_38617);

(statearr_38836_38901[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38759 === (49))){
var inst_38638 = (state_38758[(30)]);
var state_38758__$1 = state_38758;
var statearr_38837_38902 = state_38758__$1;
(statearr_38837_38902[(2)] = inst_38638);

(statearr_38837_38902[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0 = (function (){
var statearr_38838 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38838[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__);

(statearr_38838[(1)] = (1));

return statearr_38838;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1 = (function (state_38758){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_38758);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e38839){var ex__16398__auto__ = e38839;
var statearr_38840_38903 = state_38758;
(statearr_38840_38903[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_38758[(4)]))){
var statearr_38841_38904 = state_38758;
(statearr_38841_38904[(1)] = cljs.core.first((state_38758[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__38905 = state_38758;
state_38758 = G__38905;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__ = function(state_38758){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1.call(this,state_38758);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_38842 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_38842[(6)] = c__16469__auto__);

return statearr_38842;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__38906 = select_spec;
var map__38906__$1 = cljs.core.__destructure_map(map__38906);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38906__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38906__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39020){
var state_val_39021 = (state_39020[(1)]);
if((state_val_39021 === (7))){
var inst_38932 = flakes;
var inst_38933 = cljs.core.seq(inst_38932);
var inst_38934 = cljs.core.first(inst_38933);
var inst_38935 = cljs.core.next(inst_38933);
var inst_38936 = cljs.core.PersistentVector.EMPTY;
var inst_38937 = inst_38932;
var inst_38938 = (0);
var inst_38939 = inst_38936;
var state_39020__$1 = (function (){var statearr_39022 = state_39020;
(statearr_39022[(7)] = inst_38935);

(statearr_39022[(8)] = inst_38938);

(statearr_39022[(9)] = inst_38934);

(statearr_39022[(10)] = inst_38937);

(statearr_39022[(11)] = inst_38939);

return statearr_39022;
})();
var statearr_39023_39089 = state_39020__$1;
(statearr_39023_39089[(2)] = null);

(statearr_39023_39089[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (20))){
var state_39020__$1 = state_39020;
var statearr_39024_39090 = state_39020__$1;
(statearr_39024_39090[(2)] = results);

(statearr_39024_39090[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (27))){
var state_39020__$1 = state_39020;
var statearr_39025_39091 = state_39020__$1;
(statearr_39025_39091[(2)] = null);

(statearr_39025_39091[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (1))){
var state_39020__$1 = state_39020;
var statearr_39026_39092 = state_39020__$1;
(statearr_39026_39092[(2)] = null);

(statearr_39026_39092[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (24))){
var state_39020__$1 = state_39020;
var statearr_39027_39093 = state_39020__$1;
(statearr_39027_39093[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (39))){
var inst_39001 = (state_39020[(12)]);
var inst_38946 = (state_39020[(13)]);
var inst_38939 = (state_39020[(11)]);
var inst_39004 = (state_39020[(2)]);
var inst_39005 = fluree.db.util.async.throw_err(inst_39004);
var inst_39006 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38939,inst_39005);
var inst_38937 = inst_38946;
var inst_38938 = inst_39001;
var inst_38939__$1 = inst_39006;
var state_39020__$1 = (function (){var statearr_39029 = state_39020;
(statearr_39029[(8)] = inst_38938);

(statearr_39029[(10)] = inst_38937);

(statearr_39029[(11)] = inst_38939__$1);

return statearr_39029;
})();
var statearr_39030_39094 = state_39020__$1;
(statearr_39030_39094[(2)] = null);

(statearr_39030_39094[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (4))){
var inst_38907 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39031_39095 = state_39020__$1;
(statearr_39031_39095[(2)] = inst_38907);

(statearr_39031_39095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (15))){
var inst_38920 = (state_39020[(14)]);
var state_39020__$1 = state_39020;
var statearr_39032_39096 = state_39020__$1;
(statearr_39032_39096[(2)] = inst_38920);

(statearr_39032_39096[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (21))){
var inst_38916 = (state_39020[(15)]);
var state_39020__$1 = state_39020;
if(cljs.core.truth_(inst_38916)){
var statearr_39033_39097 = state_39020__$1;
(statearr_39033_39097[(1)] = (23));

} else {
var statearr_39034_39098 = state_39020__$1;
(statearr_39034_39098[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (31))){
var inst_38984 = (state_39020[(16)]);
var state_39020__$1 = state_39020;
var statearr_39035_39099 = state_39020__$1;
(statearr_39035_39099[(2)] = inst_38984);

(statearr_39035_39099[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (32))){
var inst_38976 = (state_39020[(17)]);
var inst_38990 = (state_39020[(2)]);
var state_39020__$1 = (function (){var statearr_39036 = state_39020;
(statearr_39036[(18)] = inst_38990);

return statearr_39036;
})();
if(cljs.core.truth_(inst_38976)){
var statearr_39037_39100 = state_39020__$1;
(statearr_39037_39100[(1)] = (33));

} else {
var statearr_39038_39101 = state_39020__$1;
(statearr_39038_39101[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (33))){
var inst_38976 = (state_39020[(17)]);
var state_39020__$1 = state_39020;
var statearr_39039_39102 = state_39020__$1;
(statearr_39039_39102[(2)] = inst_38976);

(statearr_39039_39102[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (13))){
var inst_38956 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
if(cljs.core.truth_(inst_38956)){
var statearr_39041_39103 = state_39020__$1;
(statearr_39041_39103[(1)] = (17));

} else {
var statearr_39042_39104 = state_39020__$1;
(statearr_39042_39104[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (22))){
var inst_38973 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39043_39105 = state_39020__$1;
(statearr_39043_39105[(2)] = inst_38973);

(statearr_39043_39105[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (36))){
var inst_38938 = (state_39020[(8)]);
var inst_38946 = (state_39020[(13)]);
var inst_38939 = (state_39020[(11)]);
var inst_38998 = (inst_38938 + (1));
var tmp39040 = inst_38939;
var inst_38937 = inst_38946;
var inst_38938__$1 = inst_38998;
var inst_38939__$1 = tmp39040;
var state_39020__$1 = (function (){var statearr_39044 = state_39020;
(statearr_39044[(8)] = inst_38938__$1);

(statearr_39044[(10)] = inst_38937);

(statearr_39044[(11)] = inst_38939__$1);

return statearr_39044;
})();
var statearr_39045_39106 = state_39020__$1;
(statearr_39045_39106[(2)] = null);

(statearr_39045_39106[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (29))){
var inst_38983 = (state_39020[(2)]);
var inst_38984 = fluree.db.util.async.throw_err(inst_38983);
var state_39020__$1 = (function (){var statearr_39046 = state_39020;
(statearr_39046[(16)] = inst_38984);

return statearr_39046;
})();
if(cljs.core.truth_(fuel)){
var statearr_39047_39107 = state_39020__$1;
(statearr_39047_39107[(1)] = (30));

} else {
var statearr_39048_39108 = state_39020__$1;
(statearr_39048_39108[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (6))){
var state_39020__$1 = state_39020;
var statearr_39049_39109 = state_39020__$1;
(statearr_39049_39109[(2)] = results);

(statearr_39049_39109[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (28))){
var inst_38969 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39050_39110 = state_39020__$1;
(statearr_39050_39110[(2)] = inst_38969);

(statearr_39050_39110[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (25))){
var inst_38971 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39051_39111 = state_39020__$1;
(statearr_39051_39111[(2)] = inst_38971);

(statearr_39051_39111[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (34))){
var inst_38990 = (state_39020[(18)]);
var inst_38993 = cljs.core.empty_QMARK_(inst_38990);
var state_39020__$1 = state_39020;
var statearr_39052_39112 = state_39020__$1;
(statearr_39052_39112[(2)] = inst_38993);

(statearr_39052_39112[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (17))){
var inst_38939 = (state_39020[(11)]);
var inst_38958 = cljs.core.empty_QMARK_(inst_38939);
var state_39020__$1 = state_39020;
if(inst_38958){
var statearr_39053_39113 = state_39020__$1;
(statearr_39053_39113[(1)] = (20));

} else {
var statearr_39054_39114 = state_39020__$1;
(statearr_39054_39114[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (3))){
var inst_39018 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39020__$1,inst_39018);
} else {
if((state_val_39021 === (12))){
var inst_38920 = (state_39020[(14)]);
var state_39020__$1 = state_39020;
if(cljs.core.truth_(inst_38920)){
var statearr_39055_39115 = state_39020__$1;
(statearr_39055_39115[(1)] = (14));

} else {
var statearr_39056_39116 = state_39020__$1;
(statearr_39056_39116[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (2))){
var _ = (function (){var statearr_39057 = state_39020;
(statearr_39057[(4)] = cljs.core.cons((5),(state_39020[(4)])));

return statearr_39057;
})();
var inst_38914 = select_spec;
var inst_38915 = cljs.core.__destructure_map(inst_38914);
var inst_38916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38915,cljs.core.cst$kw$multi_QMARK_);
var inst_38917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38915,cljs.core.cst$kw$as);
var inst_38918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38915,cljs.core.cst$kw$recur_DASH_seen);
var inst_38919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38915,cljs.core.cst$kw$recur_DASH_depth);
var inst_38920 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38915,cljs.core.cst$kw$limit);
var inst_38921 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_38922 = (inst_38919 > inst_38921);
var state_39020__$1 = (function (){var statearr_39058 = state_39020;
(statearr_39058[(19)] = inst_38918);

(statearr_39058[(15)] = inst_38916);

(statearr_39058[(20)] = inst_38917);

(statearr_39058[(14)] = inst_38920);

return statearr_39058;
})();
if(cljs.core.truth_(inst_38922)){
var statearr_39059_39117 = state_39020__$1;
(statearr_39059_39117[(1)] = (6));

} else {
var statearr_39060_39118 = state_39020__$1;
(statearr_39060_39118[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (23))){
var inst_38939 = (state_39020[(11)]);
var inst_38917 = (state_39020[(20)]);
var inst_38962 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_38917,inst_38939);
var state_39020__$1 = state_39020;
var statearr_39061_39119 = state_39020__$1;
(statearr_39061_39119[(2)] = inst_38962);

(statearr_39061_39119[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (35))){
var inst_38945 = (state_39020[(21)]);
var inst_38995 = (state_39020[(2)]);
var inst_38996 = fluree.db.query.fql.recur_select_spec(select_spec,inst_38945);
var state_39020__$1 = (function (){var statearr_39062 = state_39020;
(statearr_39062[(22)] = inst_38996);

return statearr_39062;
})();
if(cljs.core.truth_(inst_38995)){
var statearr_39063_39120 = state_39020__$1;
(statearr_39063_39120[(1)] = (36));

} else {
var statearr_39064_39121 = state_39020__$1;
(statearr_39064_39121[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (19))){
var inst_39011 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39065_39122 = state_39020__$1;
(statearr_39065_39122[(2)] = inst_39011);

(statearr_39065_39122[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (11))){
var inst_38947 = (state_39020[(23)]);
var state_39020__$1 = state_39020;
var statearr_39067_39123 = state_39020__$1;
(statearr_39067_39123[(2)] = inst_38947);

(statearr_39067_39123[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (9))){
var inst_38947 = (state_39020[(23)]);
var inst_38945 = (state_39020[(21)]);
var inst_38937 = (state_39020[(10)]);
var inst_38944 = cljs.core.seq(inst_38937);
var inst_38945__$1 = cljs.core.first(inst_38944);
var inst_38946 = cljs.core.next(inst_38944);
var inst_38947__$1 = cljs.core.not(inst_38945__$1);
var state_39020__$1 = (function (){var statearr_39068 = state_39020;
(statearr_39068[(23)] = inst_38947__$1);

(statearr_39068[(21)] = inst_38945__$1);

(statearr_39068[(13)] = inst_38946);

return statearr_39068;
})();
if(inst_38947__$1){
var statearr_39069_39124 = state_39020__$1;
(statearr_39069_39124[(1)] = (11));

} else {
var statearr_39070_39125 = state_39020__$1;
(statearr_39070_39125[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (5))){
var _ = (function (){var statearr_39071 = state_39020;
(statearr_39071[(4)] = cljs.core.rest((state_39020[(4)])));

return statearr_39071;
})();
var state_39020__$1 = state_39020;
var ex39066 = (state_39020__$1[(2)]);
var statearr_39072_39126 = state_39020__$1;
(statearr_39072_39126[(5)] = ex39066);


if((ex39066 instanceof Error)){
var statearr_39073_39127 = state_39020__$1;
(statearr_39073_39127[(1)] = (4));

(statearr_39073_39127[(5)] = null);

} else {
throw ex39066;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (14))){
var inst_38938 = (state_39020[(8)]);
var inst_38920 = (state_39020[(14)]);
var inst_38951 = (inst_38938 < inst_38920);
var state_39020__$1 = state_39020;
var statearr_39074_39128 = state_39020__$1;
(statearr_39074_39128[(2)] = inst_38951);

(statearr_39074_39128[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (26))){
var inst_38939 = (state_39020[(11)]);
var inst_38917 = (state_39020[(20)]);
var inst_38965 = cljs.core.first(inst_38939);
var inst_38966 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_38917,inst_38965);
var state_39020__$1 = state_39020;
var statearr_39075_39129 = state_39020__$1;
(statearr_39075_39129[(2)] = inst_38966);

(statearr_39075_39129[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (16))){
var inst_38954 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39076_39130 = state_39020__$1;
(statearr_39076_39130[(2)] = inst_38954);

(statearr_39076_39130[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (38))){
var inst_39009 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39077_39131 = state_39020__$1;
(statearr_39077_39131[(2)] = inst_39009);

(statearr_39077_39131[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (30))){
var inst_38984 = (state_39020[(16)]);
var inst_38986 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_38987 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38986,inst_38984);
var state_39020__$1 = state_39020;
var statearr_39078_39132 = state_39020__$1;
(statearr_39078_39132[(2)] = inst_38987);

(statearr_39078_39132[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (10))){
var inst_39013 = (state_39020[(2)]);
var state_39020__$1 = state_39020;
var statearr_39079_39133 = state_39020__$1;
(statearr_39079_39133[(2)] = inst_39013);

(statearr_39079_39133[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39021 === (18))){
var inst_38918 = (state_39020[(19)]);
var inst_38945 = (state_39020[(21)]);
var inst_38975 = inst_38945.o;
var inst_38976 = cljs.core.contains_QMARK_(inst_38918,inst_38975);
var inst_38978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38979 = [inst_38975];
var inst_38980 = (new cljs.core.PersistentVector(null,1,(5),inst_38978,inst_38979,null));
var inst_38981 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38980);
var state_39020__$1 = (function (){var statearr_39080 = state_39020;
(statearr_39080[(17)] = inst_38976);

return statearr_39080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39020__$1,(29),inst_38981);
} else {
if((state_val_39021 === (37))){
var inst_38938 = (state_39020[(8)]);
var inst_38990 = (state_39020[(18)]);
var inst_38996 = (state_39020[(22)]);
var inst_39001 = (inst_38938 + (1));
var inst_39002 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38996,inst_38990) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38996,inst_38990));
var state_39020__$1 = (function (){var statearr_39081 = state_39020;
(statearr_39081[(12)] = inst_39001);

return statearr_39081;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39020__$1,(39),inst_39002);
} else {
if((state_val_39021 === (8))){
var inst_39015 = (state_39020[(2)]);
var _ = (function (){var statearr_39082 = state_39020;
(statearr_39082[(4)] = cljs.core.rest((state_39020[(4)])));

return statearr_39082;
})();
var state_39020__$1 = state_39020;
var statearr_39083_39134 = state_39020__$1;
(statearr_39083_39134[(2)] = inst_39015);

(statearr_39083_39134[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0 = (function (){
var statearr_39084 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39084[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__);

(statearr_39084[(1)] = (1));

return statearr_39084;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1 = (function (state_39020){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39020);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39085){var ex__16398__auto__ = e39085;
var statearr_39086_39135 = state_39020;
(statearr_39086_39135[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39020[(4)]))){
var statearr_39087_39136 = state_39020;
(statearr_39087_39136[(1)] = cljs.core.first((state_39020[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39137 = state_39020;
state_39020 = G__39137;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__ = function(state_39020){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1.call(this,state_39020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39088 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39088[(6)] = c__16469__auto__);

return statearr_39088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39318){
var state_val_39319 = (state_39318[(1)]);
if((state_val_39319 === (7))){
var state_39318__$1 = state_39318;
var statearr_39320_39406 = state_39318__$1;
(statearr_39320_39406[(2)] = null);

(statearr_39320_39406[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (20))){
var inst_39176 = cljs.core.PersistentHashMap.EMPTY;
var state_39318__$1 = state_39318;
var statearr_39321_39407 = state_39318__$1;
(statearr_39321_39407[(2)] = inst_39176);

(statearr_39321_39407[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (27))){
var inst_39164 = (state_39318[(7)]);
var inst_39194 = (state_39318[(8)]);
var inst_39158 = (state_39318[(9)]);
var inst_39178 = (state_39318[(10)]);
var inst_39297 = (state_39318[(2)]);
var inst_39298 = (function (){var top_level_subject = inst_39158;
var select_spec = inst_39164;
var base_acc = inst_39178;
var acc_PLUS_refs = inst_39194;
var result = inst_39297;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_39299 = cljs.core.PersistentVector.EMPTY;
var inst_39300 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39164);
var inst_39301 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_39300);
var inst_39302 = cljs.core.vals(inst_39301);
var inst_39303 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39164);
var inst_39304 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_39303);
var inst_39305 = cljs.core.vals(inst_39304);
var inst_39306 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39302,inst_39305);
var inst_39307 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39298,inst_39299,inst_39306);
var inst_39309 = (function (){var top_level_subject = inst_39158;
var select_spec = inst_39164;
var base_acc = inst_39178;
var acc_PLUS_refs = inst_39194;
var result = inst_39297;
var sort_preds = inst_39307;
return (function (acc,p__39308){
var vec__39322 = p__39308;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39322,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_39310 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39309,inst_39297,inst_39307);
var state_39318__$1 = state_39318;
var statearr_39325_39408 = state_39318__$1;
(statearr_39325_39408[(2)] = inst_39310);

(statearr_39325_39408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (1))){
var state_39318__$1 = state_39318;
var statearr_39326_39409 = state_39318__$1;
(statearr_39326_39409[(2)] = null);

(statearr_39326_39409[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (24))){
var inst_39194 = (state_39318[(8)]);
var inst_39194__$1 = (state_39318[(2)]);
var inst_39195 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,flakes);
var inst_39196 = cljs.core.PersistentHashMap.EMPTY;
var inst_39197 = inst_39195;
var inst_39198 = inst_39194__$1;
var inst_39199 = inst_39196;
var state_39318__$1 = (function (){var statearr_39327 = state_39318;
(statearr_39327[(11)] = inst_39198);

(statearr_39327[(8)] = inst_39194__$1);

(statearr_39327[(12)] = inst_39197);

(statearr_39327[(13)] = inst_39199);

return statearr_39327;
})();
var statearr_39328_39410 = state_39318__$1;
(statearr_39328_39410[(2)] = null);

(statearr_39328_39410[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (39))){
var inst_39164 = (state_39318[(7)]);
var inst_39198 = (state_39318[(11)]);
var inst_39207 = (state_39318[(14)]);
var inst_39214 = (state_39318[(15)]);
var inst_39243 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39244 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_39198,inst_39164,inst_39207,inst_39214,false);
var state_39318__$1 = (function (){var statearr_39329 = state_39318;
(statearr_39329[(16)] = inst_39243);

return statearr_39329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39318__$1,(42),inst_39244);
} else {
if((state_val_39319 === (46))){
var inst_39197 = (state_39318[(12)]);
var inst_39199 = (state_39318[(13)]);
var inst_39207 = (state_39318[(14)]);
var inst_39261 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39262 = [cljs.core.cst$kw$_id];
var inst_39263 = cljs.core.first(inst_39207);
var inst_39264 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_39263);
var inst_39265 = [inst_39264];
var inst_39266 = cljs.core.PersistentHashMap.fromArrays(inst_39262,inst_39265);
var inst_39267 = cljs.core.rest(inst_39197);
var inst_39268 = [inst_39266,inst_39267,inst_39199];
var inst_39269 = (new cljs.core.PersistentVector(null,3,(5),inst_39261,inst_39268,null));
var state_39318__$1 = state_39318;
var statearr_39330_39411 = state_39318__$1;
(statearr_39330_39411[(2)] = inst_39269);

(statearr_39330_39411[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (4))){
var inst_39138 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39331_39412 = state_39318__$1;
(statearr_39331_39412[(2)] = inst_39138);

(statearr_39331_39412[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (15))){
var inst_39164 = (state_39318[(7)]);
var inst_39165 = (state_39318[(17)]);
var inst_39164__$1 = (state_39318[(2)]);
var inst_39165__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39164__$1);
var state_39318__$1 = (function (){var statearr_39332 = state_39318;
(statearr_39332[(7)] = inst_39164__$1);

(statearr_39332[(17)] = inst_39165__$1);

return statearr_39332;
})();
if(cljs.core.truth_(inst_39165__$1)){
var statearr_39333_39413 = state_39318__$1;
(statearr_39333_39413[(1)] = (16));

} else {
var statearr_39334_39414 = state_39318__$1;
(statearr_39334_39414[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (48))){
var inst_39280 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39335_39415 = state_39318__$1;
(statearr_39335_39415[(2)] = inst_39280);

(statearr_39335_39415[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (50))){
var state_39318__$1 = state_39318;
var statearr_39336_39416 = state_39318__$1;
(statearr_39336_39416[(2)] = null);

(statearr_39336_39416[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (21))){
var inst_39164 = (state_39318[(7)]);
var inst_39178 = (state_39318[(2)]);
var inst_39179 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39180 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_39181 = (new cljs.core.PersistentVector(null,2,(5),inst_39179,inst_39180,null));
var inst_39182 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39164,inst_39181);
var state_39318__$1 = (function (){var statearr_39337 = state_39318;
(statearr_39337[(10)] = inst_39178);

return statearr_39337;
})();
if(cljs.core.truth_(inst_39182)){
var statearr_39338_39417 = state_39318__$1;
(statearr_39338_39417[(1)] = (22));

} else {
var statearr_39339_39418 = state_39318__$1;
(statearr_39339_39418[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (31))){
var inst_39198 = (state_39318[(11)]);
var inst_39213 = (state_39318[(18)]);
var inst_39207 = (state_39318[(14)]);
var inst_39217 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39218 = fluree.db.query.fql.flake__GT_recur(db,inst_39207,inst_39213,inst_39198,fuel,max_fuel,cache);
var state_39318__$1 = (function (){var statearr_39340 = state_39318;
(statearr_39340[(19)] = inst_39217);

return statearr_39340;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39318__$1,(34),inst_39218);
} else {
if((state_val_39319 === (32))){
var inst_39213 = (state_39318[(18)]);
var state_39318__$1 = state_39318;
if(cljs.core.truth_(inst_39213)){
var statearr_39341_39419 = state_39318__$1;
(statearr_39341_39419[(1)] = (35));

} else {
var statearr_39342_39420 = state_39318__$1;
(statearr_39342_39420[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (40))){
var inst_39254 = (state_39318[(20)]);
var inst_39164 = (state_39318[(7)]);
var inst_39253 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39164);
var inst_39254__$1 = cljs.core.empty_QMARK_(inst_39253);
var state_39318__$1 = (function (){var statearr_39343 = state_39318;
(statearr_39343[(20)] = inst_39254__$1);

return statearr_39343;
})();
if(inst_39254__$1){
var statearr_39344_39421 = state_39318__$1;
(statearr_39344_39421[(1)] = (43));

} else {
var statearr_39345_39422 = state_39318__$1;
(statearr_39345_39422[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (33))){
var inst_39207 = (state_39318[(14)]);
var inst_39286 = (state_39318[(2)]);
var inst_39287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39286,(0),null);
var inst_39288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39286,(1),null);
var inst_39289 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39286,(2),null);
var inst_39290 = cljs.core.first(inst_39207);
var inst_39291 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_39290);
var inst_39292 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39287,cljs.core.cst$kw$_id,inst_39291);
var inst_39197 = inst_39288;
var inst_39198 = inst_39292;
var inst_39199 = inst_39289;
var state_39318__$1 = (function (){var statearr_39346 = state_39318;
(statearr_39346[(11)] = inst_39198);

(statearr_39346[(12)] = inst_39197);

(statearr_39346[(13)] = inst_39199);

return statearr_39346;
})();
var statearr_39347_39423 = state_39318__$1;
(statearr_39347_39423[(2)] = null);

(statearr_39347_39423[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (13))){
var inst_39158 = (state_39318[(9)]);
var inst_39161 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_39158);
var state_39318__$1 = state_39318;
var statearr_39348_39424 = state_39318__$1;
(statearr_39348_39424[(2)] = inst_39161);

(statearr_39348_39424[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (22))){
var inst_39164 = (state_39318[(7)]);
var inst_39184 = cljs.core.first(flakes);
var inst_39185 = fluree.db.query.fql.s(inst_39184);
var inst_39186 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_39164);
var inst_39187 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_39185,inst_39186);
var state_39318__$1 = state_39318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39318__$1,(25),inst_39187);
} else {
if((state_val_39319 === (36))){
var inst_39164 = (state_39318[(7)]);
var inst_39241 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39164);
var state_39318__$1 = state_39318;
if(cljs.core.truth_(inst_39241)){
var statearr_39349_39425 = state_39318__$1;
(statearr_39349_39425[(1)] = (39));

} else {
var statearr_39350_39426 = state_39318__$1;
(statearr_39350_39426[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (41))){
var inst_39282 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39351_39427 = state_39318__$1;
(statearr_39351_39427[(2)] = inst_39282);

(statearr_39351_39427[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (43))){
var inst_39164 = (state_39318[(7)]);
var inst_39256 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39164);
var state_39318__$1 = state_39318;
var statearr_39352_39428 = state_39318__$1;
(statearr_39352_39428[(2)] = inst_39256);

(statearr_39352_39428[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (29))){
var inst_39164 = (state_39318[(7)]);
var inst_39197 = (state_39318[(12)]);
var inst_39213 = (state_39318[(18)]);
var inst_39207 = (state_39318[(14)]);
var inst_39207__$1 = cljs.core.first(inst_39197);
var inst_39208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39209 = cljs.core.first(inst_39207__$1);
var inst_39210 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_39209);
var inst_39211 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_39210];
var inst_39212 = (new cljs.core.PersistentVector(null,3,(5),inst_39208,inst_39211,null));
var inst_39213__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39164,inst_39212);
var inst_39214 = fluree.db.query.fql.component_follow_QMARK_(inst_39213__$1,inst_39164);
var inst_39215 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_39213__$1);
var state_39318__$1 = (function (){var statearr_39353 = state_39318;
(statearr_39353[(18)] = inst_39213__$1);

(statearr_39353[(14)] = inst_39207__$1);

(statearr_39353[(15)] = inst_39214);

return statearr_39353;
})();
if(cljs.core.truth_(inst_39215)){
var statearr_39354_39429 = state_39318__$1;
(statearr_39354_39429[(1)] = (31));

} else {
var statearr_39355_39430 = state_39318__$1;
(statearr_39355_39430[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (44))){
var inst_39254 = (state_39318[(20)]);
var state_39318__$1 = state_39318;
var statearr_39356_39431 = state_39318__$1;
(statearr_39356_39431[(2)] = inst_39254);

(statearr_39356_39431[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (6))){
var state_39318__$1 = state_39318;
var statearr_39357_39432 = state_39318__$1;
(statearr_39357_39432[(2)] = null);

(statearr_39357_39432[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (28))){
var inst_39198 = (state_39318[(11)]);
var state_39318__$1 = state_39318;
var statearr_39358_39433 = state_39318__$1;
(statearr_39358_39433[(2)] = inst_39198);

(statearr_39358_39433[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (51))){
var inst_39278 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39359_39434 = state_39318__$1;
(statearr_39359_39434[(2)] = inst_39278);

(statearr_39359_39434[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (25))){
var inst_39178 = (state_39318[(10)]);
var inst_39189 = (state_39318[(2)]);
var inst_39190 = fluree.db.util.async.throw_err(inst_39189);
var inst_39191 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39178,inst_39190], 0));
var state_39318__$1 = state_39318;
var statearr_39360_39435 = state_39318__$1;
(statearr_39360_39435[(2)] = inst_39191);

(statearr_39360_39435[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (34))){
var inst_39197 = (state_39318[(12)]);
var inst_39199 = (state_39318[(13)]);
var inst_39217 = (state_39318[(19)]);
var inst_39220 = (state_39318[(2)]);
var inst_39221 = fluree.db.util.async.throw_err(inst_39220);
var inst_39222 = cljs.core.rest(inst_39197);
var inst_39223 = [inst_39221,inst_39222,inst_39199];
var inst_39224 = (new cljs.core.PersistentVector(null,3,(5),inst_39217,inst_39223,null));
var state_39318__$1 = state_39318;
var statearr_39361_39436 = state_39318__$1;
(statearr_39361_39436[(2)] = inst_39224);

(statearr_39361_39436[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (17))){
var inst_39164 = (state_39318[(7)]);
var inst_39168 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39164);
var state_39318__$1 = state_39318;
var statearr_39363_39437 = state_39318__$1;
(statearr_39363_39437[(2)] = inst_39168);

(statearr_39363_39437[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (3))){
var inst_39316 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39318__$1,inst_39316);
} else {
if((state_val_39319 === (12))){
var _ = (function (){var statearr_39364 = state_39318;
(statearr_39364[(4)] = cljs.core.rest((state_39318[(4)])));

return statearr_39364;
})();
var state_39318__$1 = state_39318;
var ex39362 = (state_39318__$1[(2)]);
var statearr_39365_39438 = state_39318__$1;
(statearr_39365_39438[(5)] = ex39362);


var statearr_39366_39439 = state_39318__$1;
(statearr_39366_39439[(1)] = (11));

(statearr_39366_39439[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (2))){
var _ = (function (){var statearr_39367 = state_39318;
(statearr_39367[(4)] = cljs.core.cons((5),(state_39318[(4)])));

return statearr_39367;
})();
var inst_39144 = cljs.core.not_empty(flakes);
var state_39318__$1 = state_39318;
if(cljs.core.truth_(inst_39144)){
var statearr_39368_39440 = state_39318__$1;
(statearr_39368_39440[(1)] = (6));

} else {
var statearr_39369_39441 = state_39318__$1;
(statearr_39369_39441[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (23))){
var inst_39178 = (state_39318[(10)]);
var state_39318__$1 = state_39318;
var statearr_39370_39442 = state_39318__$1;
(statearr_39370_39442[(2)] = inst_39178);

(statearr_39370_39442[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (47))){
var state_39318__$1 = state_39318;
var statearr_39371_39443 = state_39318__$1;
(statearr_39371_39443[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (35))){
var inst_39198 = (state_39318[(11)]);
var inst_39199 = (state_39318[(13)]);
var inst_39213 = (state_39318[(18)]);
var inst_39207 = (state_39318[(14)]);
var inst_39214 = (state_39318[(15)]);
var inst_39230 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_39198,inst_39213,inst_39207,inst_39214,false,inst_39199);
var state_39318__$1 = state_39318;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39318__$1,(38),inst_39230);
} else {
if((state_val_39319 === (19))){
var inst_39158 = (state_39318[(9)]);
var inst_39172 = [cljs.core.cst$kw$_id];
var inst_39173 = [inst_39158];
var inst_39174 = cljs.core.PersistentHashMap.fromArrays(inst_39172,inst_39173);
var state_39318__$1 = state_39318;
var statearr_39373_39444 = state_39318__$1;
(statearr_39373_39444[(2)] = inst_39174);

(statearr_39373_39444[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (11))){
var inst_39146 = (state_39318[(2)]);
var inst_39147 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39146], 0));
var inst_39148 = (function(){throw inst_39146})();
var state_39318__$1 = (function (){var statearr_39375 = state_39318;
(statearr_39375[(21)] = inst_39147);

return statearr_39375;
})();
var statearr_39376_39445 = state_39318__$1;
(statearr_39376_39445[(2)] = inst_39148);

(statearr_39376_39445[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (9))){
var _ = (function (){var statearr_39377 = state_39318;
(statearr_39377[(4)] = cljs.core.cons((12),(state_39318[(4)])));

return statearr_39377;
})();
var inst_39154 = cljs.core.first(flakes);
var inst_39155 = fluree.db.query.fql.s(inst_39154);
var ___$1 = (function (){var statearr_39378 = state_39318;
(statearr_39378[(4)] = cljs.core.rest((state_39318[(4)])));

return statearr_39378;
})();
var state_39318__$1 = state_39318;
var statearr_39379_39446 = state_39318__$1;
(statearr_39379_39446[(2)] = inst_39155);

(statearr_39379_39446[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (5))){
var _ = (function (){var statearr_39380 = state_39318;
(statearr_39380[(4)] = cljs.core.rest((state_39318[(4)])));

return statearr_39380;
})();
var state_39318__$1 = state_39318;
var ex39374 = (state_39318__$1[(2)]);
var statearr_39381_39447 = state_39318__$1;
(statearr_39381_39447[(5)] = ex39374);


if((ex39374 instanceof Error)){
var statearr_39382_39448 = state_39318__$1;
(statearr_39382_39448[(1)] = (4));

(statearr_39382_39448[(5)] = null);

} else {
throw ex39374;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (14))){
var state_39318__$1 = state_39318;
var statearr_39383_39449 = state_39318__$1;
(statearr_39383_39449[(2)] = base_select_spec);

(statearr_39383_39449[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (45))){
var inst_39259 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
if(cljs.core.truth_(inst_39259)){
var statearr_39384_39450 = state_39318__$1;
(statearr_39384_39450[(1)] = (46));

} else {
var statearr_39385_39451 = state_39318__$1;
(statearr_39385_39451[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (26))){
var inst_39197 = (state_39318[(12)]);
var inst_39201 = cljs.core.empty_QMARK_(inst_39197);
var state_39318__$1 = state_39318;
if(inst_39201){
var statearr_39386_39452 = state_39318__$1;
(statearr_39386_39452[(1)] = (28));

} else {
var statearr_39387_39453 = state_39318__$1;
(statearr_39387_39453[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (16))){
var inst_39165 = (state_39318[(17)]);
var state_39318__$1 = state_39318;
var statearr_39388_39454 = state_39318__$1;
(statearr_39388_39454[(2)] = inst_39165);

(statearr_39388_39454[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (38))){
var inst_39197 = (state_39318[(12)]);
var inst_39232 = (state_39318[(2)]);
var inst_39233 = fluree.db.util.async.throw_err(inst_39232);
var inst_39234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39233,(0),null);
var inst_39235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39233,(1),null);
var inst_39236 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39237 = cljs.core.rest(inst_39197);
var inst_39238 = [inst_39234,inst_39237,inst_39235];
var inst_39239 = (new cljs.core.PersistentVector(null,3,(5),inst_39236,inst_39238,null));
var state_39318__$1 = state_39318;
var statearr_39389_39455 = state_39318__$1;
(statearr_39389_39455[(2)] = inst_39239);

(statearr_39389_39455[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (30))){
var inst_39295 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39390_39456 = state_39318__$1;
(statearr_39390_39456[(2)] = inst_39295);

(statearr_39390_39456[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (10))){
var inst_39158 = (state_39318[(2)]);
var inst_39159 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_39318__$1 = (function (){var statearr_39391 = state_39318;
(statearr_39391[(9)] = inst_39158);

return statearr_39391;
})();
if(cljs.core.truth_(inst_39159)){
var statearr_39392_39457 = state_39318__$1;
(statearr_39392_39457[(1)] = (13));

} else {
var statearr_39393_39458 = state_39318__$1;
(statearr_39393_39458[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (18))){
var inst_39170 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
if(cljs.core.truth_(inst_39170)){
var statearr_39394_39459 = state_39318__$1;
(statearr_39394_39459[(1)] = (19));

} else {
var statearr_39395_39460 = state_39318__$1;
(statearr_39395_39460[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (42))){
var inst_39197 = (state_39318[(12)]);
var inst_39199 = (state_39318[(13)]);
var inst_39243 = (state_39318[(16)]);
var inst_39246 = (state_39318[(2)]);
var inst_39247 = fluree.db.util.async.throw_err(inst_39246);
var inst_39248 = cljs.core.first(inst_39247);
var inst_39249 = cljs.core.rest(inst_39197);
var inst_39250 = [inst_39248,inst_39249,inst_39199];
var inst_39251 = (new cljs.core.PersistentVector(null,3,(5),inst_39243,inst_39250,null));
var state_39318__$1 = state_39318;
var statearr_39396_39461 = state_39318__$1;
(statearr_39396_39461[(2)] = inst_39251);

(statearr_39396_39461[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (37))){
var inst_39284 = (state_39318[(2)]);
var state_39318__$1 = state_39318;
var statearr_39397_39462 = state_39318__$1;
(statearr_39397_39462[(2)] = inst_39284);

(statearr_39397_39462[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (8))){
var inst_39313 = (state_39318[(2)]);
var _ = (function (){var statearr_39398 = state_39318;
(statearr_39398[(4)] = cljs.core.rest((state_39318[(4)])));

return statearr_39398;
})();
var state_39318__$1 = state_39318;
var statearr_39399_39463 = state_39318__$1;
(statearr_39399_39463[(2)] = inst_39313);

(statearr_39399_39463[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39319 === (49))){
var inst_39198 = (state_39318[(11)]);
var inst_39197 = (state_39318[(12)]);
var inst_39199 = (state_39318[(13)]);
var inst_39272 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39273 = cljs.core.rest(inst_39197);
var inst_39274 = [inst_39198,inst_39273,inst_39199];
var inst_39275 = (new cljs.core.PersistentVector(null,3,(5),inst_39272,inst_39274,null));
var state_39318__$1 = state_39318;
var statearr_39400_39464 = state_39318__$1;
(statearr_39400_39464[(2)] = inst_39275);

(statearr_39400_39464[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0 = (function (){
var statearr_39401 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39401[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__);

(statearr_39401[(1)] = (1));

return statearr_39401;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1 = (function (state_39318){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39318);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39402){var ex__16398__auto__ = e39402;
var statearr_39403_39465 = state_39318;
(statearr_39403_39465[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39318[(4)]))){
var statearr_39404_39466 = state_39318;
(statearr_39404_39466[(1)] = cljs.core.first((state_39318[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39467 = state_39318;
state_39318 = G__39467;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__ = function(state_39318){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1.call(this,state_39318);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39405 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39405[(6)] = c__16469__auto__);

return statearr_39405;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__39470 = arguments.length;
switch (G__39470) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39512){
var state_val_39513 = (state_39512[(1)]);
if((state_val_39513 === (7))){
var inst_39478 = (state_39512[(7)]);
var state_39512__$1 = state_39512;
var statearr_39514_39544 = state_39512__$1;
(statearr_39514_39544[(2)] = inst_39478);

(statearr_39514_39544[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (1))){
var state_39512__$1 = state_39512;
var statearr_39515_39545 = state_39512__$1;
(statearr_39515_39545[(2)] = null);

(statearr_39515_39545[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (4))){
var inst_39471 = (state_39512[(2)]);
var state_39512__$1 = state_39512;
var statearr_39516_39546 = state_39512__$1;
(statearr_39516_39546[(2)] = inst_39471);

(statearr_39516_39546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (15))){
var inst_39506 = (state_39512[(2)]);
var inst_39507 = fluree.db.util.async.throw_err(inst_39506);
var _ = (function (){var statearr_39517 = state_39512;
(statearr_39517[(4)] = cljs.core.rest((state_39512[(4)])));

return statearr_39517;
})();
var state_39512__$1 = state_39512;
var statearr_39518_39547 = state_39512__$1;
(statearr_39518_39547[(2)] = inst_39507);

(statearr_39518_39547[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (13))){
var inst_39490 = (state_39512[(8)]);
var state_39512__$1 = state_39512;
var statearr_39519_39548 = state_39512__$1;
(statearr_39519_39548[(2)] = inst_39490);

(statearr_39519_39548[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (6))){
var inst_39478 = (state_39512[(7)]);
var inst_39480 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_39481 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39478,inst_39480);
var state_39512__$1 = state_39512;
var statearr_39520_39549 = state_39512__$1;
(statearr_39520_39549[(2)] = inst_39481);

(statearr_39520_39549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (3))){
var inst_39510 = (state_39512[(2)]);
var state_39512__$1 = state_39512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39512__$1,inst_39510);
} else {
if((state_val_39513 === (12))){
var inst_39490 = (state_39512[(8)]);
var inst_39492 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_39493 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39490,inst_39492);
var state_39512__$1 = state_39512;
var statearr_39521_39550 = state_39512__$1;
(statearr_39521_39550[(2)] = inst_39493);

(statearr_39521_39550[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (2))){
var _ = (function (){var statearr_39522 = state_39512;
(statearr_39522[(4)] = cljs.core.cons((5),(state_39512[(4)])));

return statearr_39522;
})();
var inst_39478 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_39512__$1 = (function (){var statearr_39523 = state_39512;
(statearr_39523[(7)] = inst_39478);

return statearr_39523;
})();
if(cljs.core.truth_(fuel)){
var statearr_39524_39551 = state_39512__$1;
(statearr_39524_39551[(1)] = (6));

} else {
var statearr_39525_39552 = state_39512__$1;
(statearr_39525_39552[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (11))){
var inst_39490 = (state_39512[(2)]);
var state_39512__$1 = (function (){var statearr_39527 = state_39512;
(statearr_39527[(8)] = inst_39490);

return statearr_39527;
})();
if(cljs.core.truth_(limit)){
var statearr_39528_39553 = state_39512__$1;
(statearr_39528_39553[(1)] = (12));

} else {
var statearr_39529_39554 = state_39512__$1;
(statearr_39529_39554[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (9))){
var inst_39484 = (state_39512[(9)]);
var inst_39486 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_39487 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39484,inst_39486);
var state_39512__$1 = state_39512;
var statearr_39530_39555 = state_39512__$1;
(statearr_39530_39555[(2)] = inst_39487);

(statearr_39530_39555[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (5))){
var _ = (function (){var statearr_39531 = state_39512;
(statearr_39531[(4)] = cljs.core.rest((state_39512[(4)])));

return statearr_39531;
})();
var state_39512__$1 = state_39512;
var ex39526 = (state_39512__$1[(2)]);
var statearr_39532_39556 = state_39512__$1;
(statearr_39532_39556[(5)] = ex39526);


if((ex39526 instanceof Error)){
var statearr_39533_39557 = state_39512__$1;
(statearr_39533_39557[(1)] = (4));

(statearr_39533_39557[(5)] = null);

} else {
throw ex39526;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (14))){
var inst_39496 = (state_39512[(2)]);
var inst_39497 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_39498 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_39497);
var inst_39499 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39496,inst_39498);
var inst_39500 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39499,flakes);
var inst_39501 = cljs.core.PersistentVector.EMPTY;
var inst_39502 = (function (){var xf = inst_39499;
var flakes_by_sub = inst_39500;
return (function (p1__39468_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__39468_SHARP_);
});
})();
var inst_39503 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39502,inst_39500);
var inst_39504 = fluree.db.util.async.merge_into_QMARK_(inst_39501,inst_39503);
var state_39512__$1 = state_39512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39512__$1,(15),inst_39504);
} else {
if((state_val_39513 === (10))){
var inst_39484 = (state_39512[(9)]);
var state_39512__$1 = state_39512;
var statearr_39534_39558 = state_39512__$1;
(statearr_39534_39558[(2)] = inst_39484);

(statearr_39534_39558[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39513 === (8))){
var inst_39484 = (state_39512[(2)]);
var state_39512__$1 = (function (){var statearr_39535 = state_39512;
(statearr_39535[(9)] = inst_39484);

return statearr_39535;
})();
if(cljs.core.truth_(offset)){
var statearr_39536_39559 = state_39512__$1;
(statearr_39536_39559[(1)] = (9));

} else {
var statearr_39537_39560 = state_39512__$1;
(statearr_39537_39560[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_39538 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39538[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_39538[(1)] = (1));

return statearr_39538;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_39512){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39512);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39539){var ex__16398__auto__ = e39539;
var statearr_39540_39561 = state_39512;
(statearr_39540_39561[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39512[(4)]))){
var statearr_39541_39562 = state_39512;
(statearr_39541_39562[(1)] = cljs.core.first((state_39512[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39563 = state_39512;
state_39512 = G__39563;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_39512){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_39512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39542 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39542[(6)] = c__16469__auto__);

return statearr_39542;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__39565 = arguments.length;
switch (G__39565) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39651){
var state_val_39652 = (state_39651[(1)]);
if((state_val_39652 === (7))){
var inst_39646 = (state_39651[(2)]);
var _ = (function (){var statearr_39654 = state_39651;
(statearr_39654[(4)] = cljs.core.rest((state_39651[(4)])));

return statearr_39654;
})();
var state_39651__$1 = state_39651;
var statearr_39655_39707 = state_39651__$1;
(statearr_39655_39707[(2)] = inst_39646);

(statearr_39655_39707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (20))){
var inst_39586 = (state_39651[(7)]);
var inst_39585 = (state_39651[(8)]);
var inst_39593 = (state_39651[(9)]);
var inst_39614 = (inst_39585 + (1));
var tmp39653 = inst_39586;
var inst_39584 = inst_39593;
var inst_39585__$1 = inst_39614;
var inst_39586__$1 = tmp39653;
var state_39651__$1 = (function (){var statearr_39656 = state_39651;
(statearr_39656[(10)] = inst_39584);

(statearr_39656[(7)] = inst_39586__$1);

(statearr_39656[(8)] = inst_39585__$1);

return statearr_39656;
})();
var statearr_39657_39708 = state_39651__$1;
(statearr_39657_39708[(2)] = null);

(statearr_39657_39708[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (27))){
var inst_39624 = (state_39651[(11)]);
var inst_39626 = cljs.core.count(inst_39624);
var inst_39627 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_39626);
var state_39651__$1 = state_39651;
var statearr_39658_39709 = state_39651__$1;
(statearr_39658_39709[(2)] = inst_39627);

(statearr_39658_39709[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (1))){
var state_39651__$1 = state_39651;
var statearr_39659_39710 = state_39651__$1;
(statearr_39659_39710[(2)] = null);

(statearr_39659_39710[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (24))){
var state_39651__$1 = state_39651;
var statearr_39660_39711 = state_39651__$1;
(statearr_39660_39711[(2)] = null);

(statearr_39660_39711[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (4))){
var inst_39566 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
var statearr_39661_39712 = state_39651__$1;
(statearr_39661_39712[(2)] = inst_39566);

(statearr_39661_39712[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (15))){
var inst_39607 = (state_39651[(12)]);
var inst_39607__$1 = offset;
var state_39651__$1 = (function (){var statearr_39662 = state_39651;
(statearr_39662[(12)] = inst_39607__$1);

return statearr_39662;
})();
if(cljs.core.truth_(inst_39607__$1)){
var statearr_39663_39713 = state_39651__$1;
(statearr_39663_39713[(1)] = (17));

} else {
var statearr_39664_39714 = state_39651__$1;
(statearr_39664_39714[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (21))){
var state_39651__$1 = state_39651;
var statearr_39665_39715 = state_39651__$1;
(statearr_39665_39715[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (13))){
var inst_39602 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
var statearr_39667_39716 = state_39651__$1;
(statearr_39667_39716[(2)] = inst_39602);

(statearr_39667_39716[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (22))){
var inst_39642 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
var statearr_39668_39717 = state_39651__$1;
(statearr_39668_39717[(2)] = inst_39642);

(statearr_39668_39717[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (29))){
var inst_39624 = (state_39651[(11)]);
var inst_39585 = (state_39651[(8)]);
var inst_39630 = (state_39651[(2)]);
var inst_39631 = (inst_39585 + (1));
var inst_39632 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_39624);
var state_39651__$1 = (function (){var statearr_39669 = state_39651;
(statearr_39669[(13)] = inst_39630);

(statearr_39669[(14)] = inst_39631);

return statearr_39669;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39651__$1,(30),inst_39632);
} else {
if((state_val_39652 === (6))){
var inst_39592 = (state_39651[(15)]);
var inst_39584 = (state_39651[(10)]);
var inst_39594 = (state_39651[(16)]);
var inst_39591 = cljs.core.seq(inst_39584);
var inst_39592__$1 = cljs.core.first(inst_39591);
var inst_39593 = cljs.core.next(inst_39591);
var inst_39594__$1 = (inst_39592__$1 == null);
var state_39651__$1 = (function (){var statearr_39670 = state_39651;
(statearr_39670[(15)] = inst_39592__$1);

(statearr_39670[(16)] = inst_39594__$1);

(statearr_39670[(9)] = inst_39593);

return statearr_39670;
})();
if(cljs.core.truth_(inst_39594__$1)){
var statearr_39671_39718 = state_39651__$1;
(statearr_39671_39718[(1)] = (8));

} else {
var statearr_39672_39719 = state_39651__$1;
(statearr_39672_39719[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (28))){
var state_39651__$1 = state_39651;
var statearr_39673_39720 = state_39651__$1;
(statearr_39673_39720[(2)] = null);

(statearr_39673_39720[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (25))){
var inst_39640 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
var statearr_39674_39721 = state_39651__$1;
(statearr_39674_39721[(2)] = inst_39640);

(statearr_39674_39721[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (17))){
var inst_39585 = (state_39651[(8)]);
var inst_39609 = (inst_39585 < offset);
var state_39651__$1 = state_39651;
var statearr_39675_39722 = state_39651__$1;
(statearr_39675_39722[(2)] = inst_39609);

(statearr_39675_39722[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (3))){
var inst_39649 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39651__$1,inst_39649);
} else {
if((state_val_39652 === (12))){
var inst_39597 = (state_39651[(17)]);
var state_39651__$1 = state_39651;
var statearr_39676_39723 = state_39651__$1;
(statearr_39676_39723[(2)] = inst_39597);

(statearr_39676_39723[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (2))){
var _ = (function (){var statearr_39677 = state_39651;
(statearr_39677[(4)] = cljs.core.cons((5),(state_39651[(4)])));

return statearr_39677;
})();
var inst_39579 = subjects;
var inst_39580 = cljs.core.seq(inst_39579);
var inst_39581 = cljs.core.first(inst_39580);
var inst_39582 = cljs.core.next(inst_39580);
var inst_39583 = cljs.core.PersistentVector.EMPTY;
var inst_39584 = inst_39579;
var inst_39585 = (0);
var inst_39586 = inst_39583;
var state_39651__$1 = (function (){var statearr_39678 = state_39651;
(statearr_39678[(10)] = inst_39584);

(statearr_39678[(7)] = inst_39586);

(statearr_39678[(8)] = inst_39585);

(statearr_39678[(18)] = inst_39581);

(statearr_39678[(19)] = inst_39582);

return statearr_39678;
})();
var statearr_39679_39724 = state_39651__$1;
(statearr_39679_39724[(2)] = null);

(statearr_39679_39724[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (23))){
var inst_39592 = (state_39651[(15)]);
var inst_39618 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39619 = [inst_39592];
var inst_39620 = (new cljs.core.PersistentVector(null,1,(5),inst_39618,inst_39619,null));
var inst_39621 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39620);
var state_39651__$1 = state_39651;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39651__$1,(26),inst_39621);
} else {
if((state_val_39652 === (19))){
var inst_39612 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
if(cljs.core.truth_(inst_39612)){
var statearr_39680_39725 = state_39651__$1;
(statearr_39680_39725[(1)] = (20));

} else {
var statearr_39681_39726 = state_39651__$1;
(statearr_39681_39726[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (11))){
var inst_39585 = (state_39651[(8)]);
var inst_39599 = (inst_39585 > limit);
var state_39651__$1 = state_39651;
var statearr_39683_39727 = state_39651__$1;
(statearr_39683_39727[(2)] = inst_39599);

(statearr_39683_39727[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (9))){
var inst_39597 = (state_39651[(17)]);
var inst_39597__$1 = limit;
var state_39651__$1 = (function (){var statearr_39684 = state_39651;
(statearr_39684[(17)] = inst_39597__$1);

return statearr_39684;
})();
if(cljs.core.truth_(inst_39597__$1)){
var statearr_39685_39728 = state_39651__$1;
(statearr_39685_39728[(1)] = (11));

} else {
var statearr_39686_39729 = state_39651__$1;
(statearr_39686_39729[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (5))){
var _ = (function (){var statearr_39687 = state_39651;
(statearr_39687[(4)] = cljs.core.rest((state_39651[(4)])));

return statearr_39687;
})();
var state_39651__$1 = state_39651;
var ex39682 = (state_39651__$1[(2)]);
var statearr_39688_39730 = state_39651__$1;
(statearr_39688_39730[(5)] = ex39682);


if((ex39682 instanceof Error)){
var statearr_39689_39731 = state_39651__$1;
(statearr_39689_39731[(1)] = (4));

(statearr_39689_39731[(5)] = null);

} else {
throw ex39682;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (14))){
var inst_39586 = (state_39651[(7)]);
var state_39651__$1 = state_39651;
var statearr_39690_39732 = state_39651__$1;
(statearr_39690_39732[(2)] = inst_39586);

(statearr_39690_39732[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (26))){
var inst_39623 = (state_39651[(2)]);
var inst_39624 = fluree.db.util.async.throw_err(inst_39623);
var state_39651__$1 = (function (){var statearr_39691 = state_39651;
(statearr_39691[(11)] = inst_39624);

return statearr_39691;
})();
if(cljs.core.truth_(fuel)){
var statearr_39692_39733 = state_39651__$1;
(statearr_39692_39733[(1)] = (27));

} else {
var statearr_39693_39734 = state_39651__$1;
(statearr_39693_39734[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (16))){
var inst_39644 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
var statearr_39694_39735 = state_39651__$1;
(statearr_39694_39735[(2)] = inst_39644);

(statearr_39694_39735[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (30))){
var inst_39586 = (state_39651[(7)]);
var inst_39631 = (state_39651[(14)]);
var inst_39593 = (state_39651[(9)]);
var inst_39634 = (state_39651[(2)]);
var inst_39635 = fluree.db.util.async.throw_err(inst_39634);
var inst_39636 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39586,inst_39635);
var inst_39584 = inst_39593;
var inst_39585 = inst_39631;
var inst_39586__$1 = inst_39636;
var state_39651__$1 = (function (){var statearr_39695 = state_39651;
(statearr_39695[(10)] = inst_39584);

(statearr_39695[(7)] = inst_39586__$1);

(statearr_39695[(8)] = inst_39585);

return statearr_39695;
})();
var statearr_39696_39736 = state_39651__$1;
(statearr_39696_39736[(2)] = null);

(statearr_39696_39736[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (10))){
var inst_39604 = (state_39651[(2)]);
var state_39651__$1 = state_39651;
if(cljs.core.truth_(inst_39604)){
var statearr_39697_39737 = state_39651__$1;
(statearr_39697_39737[(1)] = (14));

} else {
var statearr_39698_39738 = state_39651__$1;
(statearr_39698_39738[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (18))){
var inst_39607 = (state_39651[(12)]);
var state_39651__$1 = state_39651;
var statearr_39699_39739 = state_39651__$1;
(statearr_39699_39739[(2)] = inst_39607);

(statearr_39699_39739[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39652 === (8))){
var inst_39594 = (state_39651[(16)]);
var state_39651__$1 = state_39651;
var statearr_39700_39740 = state_39651__$1;
(statearr_39700_39740[(2)] = inst_39594);

(statearr_39700_39740[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_39701 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39701[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_39701[(1)] = (1));

return statearr_39701;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_39651){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39651);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39702){var ex__16398__auto__ = e39702;
var statearr_39703_39741 = state_39651;
(statearr_39703_39741[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39651[(4)]))){
var statearr_39704_39742 = state_39651;
(statearr_39704_39742[(1)] = cljs.core.first((state_39651[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39743 = state_39651;
state_39651 = G__39743;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_39651){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_39651);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39705 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39705[(6)] = c__16469__auto__);

return statearr_39705;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__39745 = arguments.length;
switch (G__39745) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where_clause,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3 = (function (db,where_clause,default_collection){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39936){
var state_val_39937 = (state_39936[(1)]);
if((state_val_39937 === (7))){
var state_39936__$1 = state_39936;
var statearr_39938_40013 = state_39936__$1;
(statearr_39938_40013[(2)] = null);

(statearr_39938_40013[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (20))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39816 = (state_39936[(2)]);
var inst_39817 = fluree.db.util.async.throw_err(inst_39816);
var inst_39818 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39819 = [inst_39786];
var inst_39820 = (new cljs.core.PersistentVector(null,1,(5),inst_39818,inst_39819,null));
var inst_39821 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39822 = [inst_39786,inst_39788];
var inst_39823 = (new cljs.core.PersistentVector(null,2,(5),inst_39821,inst_39822,null));
var inst_39824 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39820,cljs.core._LT_,inst_39823);
var state_39936__$1 = (function (){var statearr_39939 = state_39936;
(statearr_39939[(9)] = inst_39817);

return statearr_39939;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(21),inst_39824);
} else {
if((state_val_39937 === (27))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39853 = (inst_39805.cljs$core$IFn$_invoke$arity$2 ? inst_39805.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_39787) : inst_39805.call(null,cljs.core._GT__EQ_,inst_39787));
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39853)){
var statearr_39940_40014 = state_39936__$1;
(statearr_39940_40014[(1)] = (30));

} else {
var statearr_39941_40015 = state_39936__$1;
(statearr_39941_40015[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (1))){
var state_39936__$1 = state_39936;
var statearr_39942_40016 = state_39936__$1;
(statearr_39942_40016[(2)] = null);

(statearr_39942_40016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (24))){
var inst_39902 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39943_40017 = state_39936__$1;
(statearr_39943_40017[(2)] = inst_39902);

(statearr_39943_40017[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (39))){
var inst_39892 = null;
var state_39936__$1 = state_39936;
var statearr_39944_40018 = state_39936__$1;
(statearr_39944_40018[(2)] = inst_39892);

(statearr_39944_40018[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (46))){
var inst_39914 = (state_39936[(12)]);
var state_39936__$1 = state_39936;
var statearr_39945_40019 = state_39936__$1;
(statearr_39945_40019[(2)] = inst_39914);

(statearr_39945_40019[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (4))){
var inst_39746 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39946_40020 = state_39936__$1;
(statearr_39946_40020[(2)] = inst_39746);

(statearr_39946_40020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (15))){
var state_39936__$1 = state_39936;
var statearr_39947_40021 = state_39936__$1;
(statearr_39947_40021[(2)] = null);

(statearr_39947_40021[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (48))){
var inst_39913 = (state_39936[(13)]);
var state_39936__$1 = state_39936;
var statearr_39948_40022 = state_39936__$1;
(statearr_39948_40022[(2)] = inst_39913);

(statearr_39948_40022[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (50))){
var inst_39924 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39949_40023 = state_39936__$1;
(statearr_39949_40023[(2)] = inst_39924);

(statearr_39949_40023[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (21))){
var inst_39817 = (state_39936[(9)]);
var inst_39826 = (state_39936[(2)]);
var inst_39827 = fluree.db.util.async.throw_err(inst_39826);
var inst_39828 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39817,inst_39827);
var state_39936__$1 = state_39936;
var statearr_39950_40024 = state_39936__$1;
(statearr_39950_40024[(2)] = inst_39828);

(statearr_39950_40024[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (31))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39866 = (inst_39805.cljs$core$IFn$_invoke$arity$2 ? inst_39805.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_39787) : inst_39805.call(null,cljs.core._LT_,inst_39787));
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39866)){
var statearr_39951_40025 = state_39936__$1;
(statearr_39951_40025[(1)] = (34));

} else {
var statearr_39952_40026 = state_39936__$1;
(statearr_39952_40026[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (32))){
var inst_39898 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39953_40027 = state_39936__$1;
(statearr_39953_40027[(2)] = inst_39898);

(statearr_39953_40027[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (40))){
var inst_39894 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39954_40028 = state_39936__$1;
(statearr_39954_40028[(2)] = inst_39894);

(statearr_39954_40028[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (33))){
var inst_39863 = (state_39936[(2)]);
var inst_39864 = fluree.db.util.async.throw_err(inst_39863);
var state_39936__$1 = state_39936;
var statearr_39955_40029 = state_39936__$1;
(statearr_39955_40029[(2)] = inst_39864);

(statearr_39955_40029[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (13))){
var inst_39926 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39956_40030 = state_39936__$1;
(statearr_39956_40030[(2)] = inst_39926);

(statearr_39956_40030[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (22))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39832 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39833 = [inst_39786,inst_39788];
var inst_39834 = (new cljs.core.PersistentVector(null,2,(5),inst_39832,inst_39833,null));
var inst_39835 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39834);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(25),inst_39835);
} else {
if((state_val_39937 === (36))){
var inst_39896 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39957_40031 = state_39936__$1;
(statearr_39957_40031[(2)] = inst_39896);

(statearr_39957_40031[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (41))){
var inst_39889 = (state_39936[(2)]);
var inst_39890 = fluree.db.util.async.throw_err(inst_39889);
var state_39936__$1 = state_39936;
var statearr_39958_40032 = state_39936__$1;
(statearr_39958_40032[(2)] = inst_39890);

(statearr_39958_40032[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (43))){
var inst_39905 = (state_39936[(14)]);
var inst_39772 = (state_39936[(15)]);
var inst_39906 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39772,inst_39905);
var state_39936__$1 = state_39936;
var statearr_39959_40033 = state_39936__$1;
(statearr_39959_40033[(2)] = inst_39906);

(statearr_39959_40033[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (29))){
var inst_39850 = (state_39936[(2)]);
var inst_39851 = fluree.db.util.async.throw_err(inst_39850);
var state_39936__$1 = state_39936;
var statearr_39960_40034 = state_39936__$1;
(statearr_39960_40034[(2)] = inst_39851);

(statearr_39960_40034[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (44))){
var inst_39905 = (state_39936[(14)]);
var inst_39772 = (state_39936[(15)]);
var inst_39908 = cljs.core.PersistentHashSet.EMPTY;
var inst_39909 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39908,inst_39905);
var inst_39910 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_39772,inst_39909);
var state_39936__$1 = state_39936;
var statearr_39961_40035 = state_39936__$1;
(statearr_39961_40035[(2)] = inst_39910);

(statearr_39961_40035[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (6))){
var inst_39757 = (state_39936[(16)]);
var inst_39767 = cljs.core.seq(inst_39757);
var inst_39768 = cljs.core.first(inst_39767);
var inst_39769 = cljs.core.next(inst_39767);
var inst_39770 = cljs.core.PersistentHashSet.EMPTY;
var inst_39771 = inst_39757;
var inst_39772 = inst_39770;
var state_39936__$1 = (function (){var statearr_39962 = state_39936;
(statearr_39962[(17)] = inst_39769);

(statearr_39962[(18)] = inst_39771);

(statearr_39962[(15)] = inst_39772);

(statearr_39962[(19)] = inst_39768);

return statearr_39962;
})();
var statearr_39963_40036 = state_39936__$1;
(statearr_39963_40036[(2)] = null);

(statearr_39963_40036[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (28))){
var inst_39900 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39964_40037 = state_39936__$1;
(statearr_39964_40037[(2)] = inst_39900);

(statearr_39964_40037[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (25))){
var inst_39837 = (state_39936[(2)]);
var inst_39838 = fluree.db.util.async.throw_err(inst_39837);
var state_39936__$1 = state_39936;
var statearr_39965_40038 = state_39936__$1;
(statearr_39965_40038[(2)] = inst_39838);

(statearr_39965_40038[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (34))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39869 = [inst_39786];
var inst_39870 = (new cljs.core.PersistentVector(null,1,(5),inst_39868,inst_39869,null));
var inst_39871 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39872 = [inst_39786,inst_39788];
var inst_39873 = (new cljs.core.PersistentVector(null,2,(5),inst_39871,inst_39872,null));
var inst_39874 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39870,cljs.core._LT_,inst_39873);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(37),inst_39874);
} else {
if((state_val_39937 === (17))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39809 = [inst_39786,inst_39788];
var inst_39810 = (new cljs.core.PersistentVector(null,2,(5),inst_39808,inst_39809,null));
var inst_39811 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39812 = [inst_39786];
var inst_39813 = (new cljs.core.PersistentVector(null,1,(5),inst_39811,inst_39812,null));
var inst_39814 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39810,cljs.core._LT__EQ_,inst_39813);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(20),inst_39814);
} else {
if((state_val_39937 === (3))){
var inst_39934 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39936__$1,inst_39934);
} else {
if((state_val_39937 === (12))){
var inst_39778 = (state_39936[(20)]);
var inst_39786 = (state_39936[(8)]);
var inst_39786__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39778,(0),null);
var inst_39787 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39778,(1),null);
var inst_39788 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39778,(2),null);
var inst_39789 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_39786__$1);
var inst_39790 = cljs.core.not(inst_39789);
var state_39936__$1 = (function (){var statearr_39966 = state_39936;
(statearr_39966[(7)] = inst_39788);

(statearr_39966[(8)] = inst_39786__$1);

(statearr_39966[(10)] = inst_39787);

return statearr_39966;
})();
if(inst_39790){
var statearr_39967_40039 = state_39936__$1;
(statearr_39967_40039[(1)] = (14));

} else {
var statearr_39968_40040 = state_39936__$1;
(statearr_39968_40040[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (2))){
var inst_39757 = (state_39936[(16)]);
var _ = (function (){var statearr_39969 = state_39936;
(statearr_39969[(4)] = cljs.core.cons((5),(state_39936[(4)])));

return statearr_39969;
})();
var inst_39755 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_39756 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39755,(0),null);
var inst_39757__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39755,(1),null);
var inst_39758 = cljs.core.not_empty(inst_39757__$1);
var state_39936__$1 = (function (){var statearr_39970 = state_39936;
(statearr_39970[(21)] = inst_39756);

(statearr_39970[(16)] = inst_39757__$1);

return statearr_39970;
})();
if(cljs.core.truth_(inst_39758)){
var statearr_39971_40041 = state_39936__$1;
(statearr_39971_40041[(1)] = (6));

} else {
var statearr_39972_40042 = state_39936__$1;
(statearr_39972_40042[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (23))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39840 = (inst_39805.cljs$core$IFn$_invoke$arity$2 ? inst_39805.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_39787) : inst_39805.call(null,cljs.core._GT_,inst_39787));
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39840)){
var statearr_39973_40043 = state_39936__$1;
(statearr_39973_40043[(1)] = (26));

} else {
var statearr_39974_40044 = state_39936__$1;
(statearr_39974_40044[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (47))){
var inst_39919 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39919)){
var statearr_39975_40045 = state_39936__$1;
(statearr_39975_40045[(1)] = (48));

} else {
var statearr_39976_40046 = state_39936__$1;
(statearr_39976_40046[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (35))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39879 = (inst_39805.cljs$core$IFn$_invoke$arity$2 ? inst_39805.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_39787) : inst_39805.call(null,cljs.core._LT__EQ_,inst_39787));
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39879)){
var statearr_39977_40047 = state_39936__$1;
(statearr_39977_40047[(1)] = (38));

} else {
var statearr_39978_40048 = state_39936__$1;
(statearr_39978_40048[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (19))){
var inst_39756 = (state_39936[(21)]);
var inst_39904 = (state_39936[(2)]);
var inst_39905 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_39904);
var state_39936__$1 = (function (){var statearr_39979 = state_39936;
(statearr_39979[(14)] = inst_39905);

return statearr_39979;
})();
var G__39980_40049 = inst_39756;
var G__39980_40050__$1 = (((G__39980_40049 instanceof cljs.core.Keyword))?G__39980_40049.fqn:null);
switch (G__39980_40050__$1) {
case "or":
var statearr_39981_40052 = state_39936__$1;
(statearr_39981_40052[(1)] = (43));


break;
case "and":
var statearr_39982_40053 = state_39936__$1;
(statearr_39982_40053[(1)] = (44));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__39980_40050__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (11))){
var inst_39772 = (state_39936[(15)]);
var state_39936__$1 = state_39936;
var statearr_39984_40054 = state_39936__$1;
(statearr_39984_40054[(2)] = inst_39772);

(statearr_39984_40054[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (9))){
var inst_39778 = (state_39936[(20)]);
var inst_39771 = (state_39936[(18)]);
var inst_39777 = cljs.core.seq(inst_39771);
var inst_39778__$1 = cljs.core.first(inst_39777);
var inst_39779 = cljs.core.next(inst_39777);
var inst_39780 = cljs.core.not(inst_39778__$1);
var state_39936__$1 = (function (){var statearr_39985 = state_39936;
(statearr_39985[(20)] = inst_39778__$1);

(statearr_39985[(22)] = inst_39779);

return statearr_39985;
})();
if(inst_39780){
var statearr_39986_40055 = state_39936__$1;
(statearr_39986_40055[(1)] = (11));

} else {
var statearr_39987_40056 = state_39936__$1;
(statearr_39987_40056[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (5))){
var _ = (function (){var statearr_39988 = state_39936;
(statearr_39988[(4)] = cljs.core.rest((state_39936[(4)])));

return statearr_39988;
})();
var state_39936__$1 = state_39936;
var ex39983 = (state_39936__$1[(2)]);
var statearr_39989_40057 = state_39936__$1;
(statearr_39989_40057[(5)] = ex39983);


if((ex39983 instanceof Error)){
var statearr_39990_40058 = state_39936__$1;
(statearr_39990_40058[(1)] = (4));

(statearr_39990_40058[(5)] = null);

} else {
throw ex39983;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (14))){
var inst_39786 = (state_39936[(8)]);
var inst_39792 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_39786);
var inst_39793 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39792)].join('');
var inst_39794 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39795 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39796 = cljs.core.PersistentHashMap.fromArrays(inst_39794,inst_39795);
var inst_39797 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39793,inst_39796);
var inst_39798 = (function(){throw inst_39797})();
var state_39936__$1 = state_39936;
var statearr_39991_40059 = state_39936__$1;
(statearr_39991_40059[(2)] = inst_39798);

(statearr_39991_40059[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (45))){
var inst_39913 = (state_39936[(13)]);
var inst_39916 = cljs.core.empty_QMARK_(inst_39913);
var state_39936__$1 = state_39936;
var statearr_39992_40060 = state_39936__$1;
(statearr_39992_40060[(2)] = inst_39916);

(statearr_39992_40060[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (26))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39842 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39843 = [inst_39786,inst_39788];
var inst_39844 = (new cljs.core.PersistentVector(null,2,(5),inst_39842,inst_39843,null));
var inst_39845 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39846 = [inst_39786];
var inst_39847 = (new cljs.core.PersistentVector(null,1,(5),inst_39845,inst_39846,null));
var inst_39848 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39844,cljs.core._LT__EQ_,inst_39847);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(29),inst_39848);
} else {
if((state_val_39937 === (16))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39801 = (state_39936[(2)]);
var inst_39805__$1 = cljs.core.identical_QMARK_;
var inst_39806 = (inst_39805__$1.cljs$core$IFn$_invoke$arity$2 ? inst_39805__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_39787) : inst_39805__$1.call(null,cljs.core.not_EQ_,inst_39787));
var state_39936__$1 = (function (){var statearr_39993 = state_39936;
(statearr_39993[(23)] = inst_39801);

(statearr_39993[(11)] = inst_39805__$1);

return statearr_39993;
})();
if(cljs.core.truth_(inst_39806)){
var statearr_39994_40061 = state_39936__$1;
(statearr_39994_40061[(1)] = (17));

} else {
var statearr_39995_40062 = state_39936__$1;
(statearr_39995_40062[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (38))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39882 = [inst_39786];
var inst_39883 = (new cljs.core.PersistentVector(null,1,(5),inst_39881,inst_39882,null));
var inst_39884 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39885 = [inst_39786,inst_39788];
var inst_39886 = (new cljs.core.PersistentVector(null,2,(5),inst_39884,inst_39885,null));
var inst_39887 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39883,cljs.core._LT__EQ_,inst_39886);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(41),inst_39887);
} else {
if((state_val_39937 === (30))){
var inst_39788 = (state_39936[(7)]);
var inst_39786 = (state_39936[(8)]);
var inst_39855 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39856 = [inst_39786,inst_39788];
var inst_39857 = (new cljs.core.PersistentVector(null,2,(5),inst_39855,inst_39856,null));
var inst_39858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39859 = [inst_39786];
var inst_39860 = (new cljs.core.PersistentVector(null,1,(5),inst_39858,inst_39859,null));
var inst_39861 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39857,cljs.core._LT__EQ_,inst_39860);
var state_39936__$1 = state_39936;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39936__$1,(33),inst_39861);
} else {
if((state_val_39937 === (10))){
var inst_39928 = (state_39936[(2)]);
var state_39936__$1 = state_39936;
var statearr_39996_40063 = state_39936__$1;
(statearr_39996_40063[(2)] = inst_39928);

(statearr_39996_40063[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (18))){
var inst_39787 = (state_39936[(10)]);
var inst_39805 = (state_39936[(11)]);
var inst_39830 = (inst_39805.cljs$core$IFn$_invoke$arity$2 ? inst_39805.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_39787) : inst_39805.call(null,cljs.core._EQ_,inst_39787));
var state_39936__$1 = state_39936;
if(cljs.core.truth_(inst_39830)){
var statearr_39997_40064 = state_39936__$1;
(statearr_39997_40064[(1)] = (22));

} else {
var statearr_39998_40065 = state_39936__$1;
(statearr_39998_40065[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (42))){
var inst_39756 = (state_39936[(21)]);
var inst_39914 = (state_39936[(12)]);
var inst_39913 = (state_39936[(2)]);
var inst_39914__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_39756);
var state_39936__$1 = (function (){var statearr_39999 = state_39936;
(statearr_39999[(13)] = inst_39913);

(statearr_39999[(12)] = inst_39914__$1);

return statearr_39999;
})();
if(inst_39914__$1){
var statearr_40000_40066 = state_39936__$1;
(statearr_40000_40066[(1)] = (45));

} else {
var statearr_40001_40067 = state_39936__$1;
(statearr_40001_40067[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (37))){
var inst_39876 = (state_39936[(2)]);
var inst_39877 = fluree.db.util.async.throw_err(inst_39876);
var state_39936__$1 = state_39936;
var statearr_40002_40068 = state_39936__$1;
(statearr_40002_40068[(2)] = inst_39877);

(statearr_40002_40068[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (8))){
var inst_39931 = (state_39936[(2)]);
var _ = (function (){var statearr_40003 = state_39936;
(statearr_40003[(4)] = cljs.core.rest((state_39936[(4)])));

return statearr_40003;
})();
var state_39936__$1 = state_39936;
var statearr_40004_40069 = state_39936__$1;
(statearr_40004_40069[(2)] = inst_39931);

(statearr_40004_40069[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39937 === (49))){
var inst_39913 = (state_39936[(13)]);
var inst_39779 = (state_39936[(22)]);
var inst_39771 = inst_39779;
var inst_39772 = inst_39913;
var state_39936__$1 = (function (){var statearr_40005 = state_39936;
(statearr_40005[(18)] = inst_39771);

(statearr_40005[(15)] = inst_39772);

return statearr_40005;
})();
var statearr_40006_40070 = state_39936__$1;
(statearr_40006_40070[(2)] = null);

(statearr_40006_40070[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_40007 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40007[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_40007[(1)] = (1));

return statearr_40007;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_39936){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39936);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40008){var ex__16398__auto__ = e40008;
var statearr_40009_40071 = state_39936;
(statearr_40009_40071[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39936[(4)]))){
var statearr_40010_40072 = state_39936;
(statearr_40010_40072[(1)] = cljs.core.first((state_39936[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40073 = state_39936;
state_39936 = G__40073;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_39936){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_39936);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40011 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40011[(6)] = c__16469__auto__);

return statearr_40011;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 3);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__40074_SHARP_){
return ((typeof p1__40074_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__40074_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__40075_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__40075_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__40079 = vars;
var vec__40080 = G__40079;
var seq__40081 = cljs.core.seq(vec__40080);
var first__40082 = cljs.core.first(seq__40081);
var seq__40081__$1 = cljs.core.next(seq__40081);
var var$ = first__40082;
var r = seq__40081__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__40079__$1 = G__40079;
var all_vars__$1 = all_vars;
while(true){
var vec__40087 = G__40079__$1;
var seq__40088 = cljs.core.seq(vec__40087);
var first__40089 = cljs.core.first(seq__40088);
var seq__40088__$1 = cljs.core.next(seq__40088);
var var$__$1 = first__40089;
var r__$1 = seq__40088__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__40090 = cljs.core.set(all_vars__$2);
return (fexpr__40090.cljs$core$IFn$_invoke$arity$1 ? fexpr__40090.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__40090.call(null,var$__$1));
})())){
var G__40091 = r__$1;
var G__40092 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__40079__$1 = G__40091;
all_vars__$1 = G__40092;
continue;
} else {
var G__40093 = r__$1;
var G__40094 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__40079__$1 = G__40093;
all_vars__$1 = G__40094;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40129){
var state_val_40130 = (state_40129[(1)]);
if((state_val_40130 === (1))){
var inst_40102 = functionArray;
var inst_40103 = cljs.core.seq(inst_40102);
var inst_40104 = cljs.core.first(inst_40103);
var inst_40105 = cljs.core.next(inst_40103);
var inst_40106 = cljs.core.PersistentVector.EMPTY;
var inst_40107 = inst_40102;
var inst_40108 = inst_40106;
var state_40129__$1 = (function (){var statearr_40131 = state_40129;
(statearr_40131[(7)] = inst_40104);

(statearr_40131[(8)] = inst_40105);

(statearr_40131[(9)] = inst_40108);

(statearr_40131[(10)] = inst_40107);

return statearr_40131;
})();
var statearr_40132_40145 = state_40129__$1;
(statearr_40132_40145[(2)] = null);

(statearr_40132_40145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40130 === (2))){
var inst_40114 = (state_40129[(11)]);
var inst_40107 = (state_40129[(10)]);
var inst_40113 = cljs.core.seq(inst_40107);
var inst_40114__$1 = cljs.core.first(inst_40113);
var inst_40115 = cljs.core.next(inst_40113);
var state_40129__$1 = (function (){var statearr_40133 = state_40129;
(statearr_40133[(12)] = inst_40115);

(statearr_40133[(11)] = inst_40114__$1);

return statearr_40133;
})();
if(cljs.core.truth_(inst_40114__$1)){
var statearr_40134_40146 = state_40129__$1;
(statearr_40134_40146[(1)] = (4));

} else {
var statearr_40135_40147 = state_40129__$1;
(statearr_40135_40147[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40130 === (3))){
var inst_40127 = (state_40129[(2)]);
var state_40129__$1 = state_40129;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40129__$1,inst_40127);
} else {
if((state_val_40130 === (4))){
var inst_40114 = (state_40129[(11)]);
var inst_40117 = (inst_40114.cljs$core$IFn$_invoke$arity$1 ? inst_40114.cljs$core$IFn$_invoke$arity$1(tuple) : inst_40114.call(null,tuple));
var state_40129__$1 = state_40129;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40129__$1,(7),inst_40117);
} else {
if((state_val_40130 === (5))){
var inst_40108 = (state_40129[(9)]);
var state_40129__$1 = state_40129;
var statearr_40136_40148 = state_40129__$1;
(statearr_40136_40148[(2)] = inst_40108);

(statearr_40136_40148[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40130 === (6))){
var inst_40125 = (state_40129[(2)]);
var state_40129__$1 = state_40129;
var statearr_40137_40149 = state_40129__$1;
(statearr_40137_40149[(2)] = inst_40125);

(statearr_40137_40149[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40130 === (7))){
var inst_40115 = (state_40129[(12)]);
var inst_40108 = (state_40129[(9)]);
var inst_40119 = (state_40129[(2)]);
var inst_40120 = fluree.db.util.async.throw_err(inst_40119);
var inst_40121 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40108,inst_40120);
var inst_40107 = inst_40115;
var inst_40108__$1 = inst_40121;
var state_40129__$1 = (function (){var statearr_40138 = state_40129;
(statearr_40138[(9)] = inst_40108__$1);

(statearr_40138[(10)] = inst_40107);

return statearr_40138;
})();
var statearr_40139_40150 = state_40129__$1;
(statearr_40139_40150[(2)] = null);

(statearr_40139_40150[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0 = (function (){
var statearr_40140 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40140[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__);

(statearr_40140[(1)] = (1));

return statearr_40140;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1 = (function (state_40129){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40129);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40141){var ex__16398__auto__ = e40141;
var statearr_40142_40151 = state_40129;
(statearr_40142_40151[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40129[(4)]))){
var statearr_40143_40152 = state_40129;
(statearr_40143_40152[(1)] = cljs.core.first((state_40129[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40153 = state_40129;
state_40129 = G__40153;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__ = function(state_40129){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1.call(this,state_40129);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40144 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40144[(6)] = c__16469__auto__);

return statearr_40144;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__40154){
var vec__40155 = p__40154;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40155,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40155,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40169){
var state_val_40170 = (state_40169[(1)]);
if((state_val_40170 === (1))){
var inst_40158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40159 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40160 = [query_map,_id,query_opts];
var inst_40161 = cljs.core.PersistentHashMap.fromArrays(inst_40159,inst_40160);
var inst_40162 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_40161) : fluree.db.query.fql.query.call(null,db,inst_40161));
var state_40169__$1 = (function (){var statearr_40171 = state_40169;
(statearr_40171[(7)] = inst_40158);

return statearr_40171;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40169__$1,(2),inst_40162);
} else {
if((state_val_40170 === (2))){
var inst_40158 = (state_40169[(7)]);
var inst_40164 = (state_40169[(2)]);
var inst_40165 = fluree.db.util.async.throw_err(inst_40164);
var inst_40166 = [tuple_index,inst_40165];
var inst_40167 = (new cljs.core.PersistentVector(null,2,(5),inst_40158,inst_40166,null));
var state_40169__$1 = state_40169;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40169__$1,inst_40167);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0 = (function (){
var statearr_40172 = [null,null,null,null,null,null,null,null];
(statearr_40172[(0)] = fluree$db$query$fql$expand_map_$_state_machine__16395__auto__);

(statearr_40172[(1)] = (1));

return statearr_40172;
});
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1 = (function (state_40169){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40169);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40173){var ex__16398__auto__ = e40173;
var statearr_40174_40177 = state_40169;
(statearr_40174_40177[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40169[(4)]))){
var statearr_40175_40178 = state_40169;
(statearr_40175_40178[(1)] = cljs.core.first((state_40169[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40179 = state_40169;
state_40169 = G__40179;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__ = function(state_40169){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1.call(this,state_40169);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40176 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40176[(6)] = c__16469__auto__);

return statearr_40176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__40180 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40180,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40180,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40243){
var state_val_40244 = (state_40243[(1)]);
if((state_val_40244 === (7))){
var inst_40238 = (state_40243[(2)]);
var _ = (function (){var statearr_40245 = state_40243;
(statearr_40245[(4)] = cljs.core.rest((state_40243[(4)])));

return statearr_40245;
})();
var state_40243__$1 = state_40243;
var statearr_40246_40337 = state_40243__$1;
(statearr_40246_40337[(2)] = inst_40238);

(statearr_40246_40337[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (20))){
var inst_40229 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40247_40338 = state_40243__$1;
(statearr_40247_40338[(2)] = inst_40229);

(statearr_40247_40338[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (1))){
var state_40243__$1 = state_40243;
var statearr_40248_40339 = state_40243__$1;
(statearr_40248_40339[(2)] = null);

(statearr_40248_40339[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (4))){
var inst_40185 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40249_40340 = state_40243__$1;
(statearr_40249_40340[(2)] = inst_40185);

(statearr_40249_40340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (15))){
var inst_40205 = (state_40243[(7)]);
var inst_40214 = cljs.core.second(inst_40205);
var inst_40215 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_40214);
var inst_40216 = (inst_40215 > max_fuel);
var state_40243__$1 = state_40243;
if(cljs.core.truth_(inst_40216)){
var statearr_40250_40341 = state_40243__$1;
(statearr_40250_40341[(1)] = (18));

} else {
var statearr_40251_40342 = state_40243__$1;
(statearr_40251_40342[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (13))){
var state_40243__$1 = state_40243;
var statearr_40252_40343 = state_40243__$1;
(statearr_40252_40343[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (6))){
var inst_40193 = (state_40243[(8)]);
var state_40243__$1 = state_40243;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40243__$1,(8),inst_40193);
} else {
if((state_val_40244 === (17))){
var inst_40232 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40254_40344 = state_40243__$1;
(statearr_40254_40344[(2)] = inst_40232);

(statearr_40254_40344[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (3))){
var inst_40241 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40243__$1,inst_40241);
} else {
if((state_val_40244 === (12))){
var inst_40205 = (state_40243[(7)]);
var inst_40194 = (state_40243[(9)]);
var inst_40211 = (inst_40194.cljs$core$IFn$_invoke$arity$0 ? inst_40194.cljs$core$IFn$_invoke$arity$0() : inst_40194.call(null));
var state_40243__$1 = (function (){var statearr_40255 = state_40243;
(statearr_40255[(10)] = inst_40211);

return statearr_40255;
})();
var statearr_40256_40345 = state_40243__$1;
(statearr_40256_40345[(2)] = inst_40205);

(statearr_40256_40345[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (2))){
var inst_40193 = (state_40243[(8)]);
var inst_40194 = (state_40243[(9)]);
var _ = (function (){var statearr_40257 = state_40243;
(statearr_40257[(4)] = cljs.core.cons((5),(state_40243[(4)])));

return statearr_40257;
})();
var inst_40191 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_40192 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_40193__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_40194__$1 = (function (){var expandMaps = inst_40191;
var queue_ch = inst_40192;
var res_ch = inst_40193__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_40195 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_40196 = cljs.core.volatile_BANG_((0));
var inst_40197 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40195,cljs.core.cst$kw$fuel,inst_40196);
var inst_40198 = (function (){var expandMaps = inst_40191;
var queue_ch = inst_40192;
var res_ch = inst_40193__$1;
var stop_BANG_ = inst_40194__$1;
var opts_STAR_ = inst_40197;
return (function (tuple_res,port){
var c__16469__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40290){
var state_val_40291 = (state_40290[(1)]);
if((state_val_40291 === (7))){
var state_40290__$1 = state_40290;
var statearr_40292_40346 = state_40290__$1;
(statearr_40292_40346[(2)] = tuple_res);

(statearr_40292_40346[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (1))){
var state_40290__$1 = state_40290;
var statearr_40293_40347 = state_40290__$1;
(statearr_40293_40347[(2)] = null);

(statearr_40293_40347[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (4))){
var inst_40258 = (state_40290[(2)]);
var inst_40259 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_40258);
var inst_40260 = cljs.core.async.close_BANG_(port);
var state_40290__$1 = (function (){var statearr_40294 = state_40290;
(statearr_40294[(7)] = inst_40259);

return statearr_40294;
})();
var statearr_40295_40348 = state_40290__$1;
(statearr_40295_40348[(2)] = inst_40260);

(statearr_40295_40348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (6))){
var inst_40267 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40268 = [tuple_res];
var inst_40269 = (new cljs.core.PersistentVector(null,1,(5),inst_40267,inst_40268,null));
var state_40290__$1 = state_40290;
var statearr_40296_40349 = state_40290__$1;
(statearr_40296_40349[(2)] = inst_40269);

(statearr_40296_40349[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (3))){
var inst_40288 = (state_40290[(2)]);
var state_40290__$1 = state_40290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40290__$1,inst_40288);
} else {
if((state_val_40291 === (2))){
var ___$1 = (function (){var statearr_40298 = state_40290;
(statearr_40298[(4)] = cljs.core.cons((5),(state_40290[(4)])));

return statearr_40298;
})();
var state_40290__$1 = state_40290;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_40299_40350 = state_40290__$1;
(statearr_40299_40350[(1)] = (6));

} else {
var statearr_40300_40351 = state_40290__$1;
(statearr_40300_40351[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (9))){
var inst_40272 = (state_40290[(8)]);
var inst_40274 = (state_40290[(9)]);
var inst_40281 = (state_40290[(2)]);
var inst_40282 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_40272,inst_40281);
var inst_40283 = (inst_40274.cljs$core$IFn$_invoke$arity$1 ? inst_40274.cljs$core$IFn$_invoke$arity$1(inst_40282) : inst_40274.call(null,inst_40282));
var inst_40284 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_40283);
var inst_40285 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_40301 = state_40290;
(statearr_40301[(4)] = cljs.core.rest((state_40290[(4)])));

return statearr_40301;
})();
var state_40290__$1 = (function (){var statearr_40302 = state_40290;
(statearr_40302[(10)] = inst_40284);

return statearr_40302;
})();
var statearr_40303_40352 = state_40290__$1;
(statearr_40303_40352[(2)] = inst_40285);

(statearr_40303_40352[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (5))){
var ___$1 = (function (){var statearr_40304 = state_40290;
(statearr_40304[(4)] = cljs.core.rest((state_40290[(4)])));

return statearr_40304;
})();
var state_40290__$1 = state_40290;
var ex40297 = (state_40290__$1[(2)]);
var statearr_40305_40353 = state_40290__$1;
(statearr_40305_40353[(5)] = ex40297);


var statearr_40306_40354 = state_40290__$1;
(statearr_40306_40354[(1)] = (4));

(statearr_40306_40354[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40291 === (8))){
var inst_40272 = (state_40290[(8)]);
var inst_40272__$1 = (state_40290[(2)]);
var inst_40273 = cljs.core.volatile_BANG_((0));
var inst_40274 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40272__$1;
var query_fuel = inst_40273;
return (function (p1__40184_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__40184_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__40184_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_40275 = cljs.core.PersistentVector.EMPTY;
var inst_40276 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40272__$1;
var query_fuel = inst_40273;
return (function (p1__40183_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__40183_SHARP_);
});
})();
var inst_40277 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_40276,expandMaps);
var inst_40278 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_40277);
var inst_40279 = cljs.core.async.into(inst_40275,inst_40278);
var state_40290__$1 = (function (){var statearr_40307 = state_40290;
(statearr_40307[(8)] = inst_40272__$1);

(statearr_40307[(9)] = inst_40274);

return statearr_40307;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40290__$1,(9),inst_40279);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0 = (function (){
var statearr_40308 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40308[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__);

(statearr_40308[(1)] = (1));

return statearr_40308;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1 = (function (state_40290){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40290);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40309){var ex__16398__auto__ = e40309;
var statearr_40310_40355 = state_40290;
(statearr_40310_40355[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40290[(4)]))){
var statearr_40311_40356 = state_40290;
(statearr_40311_40356[(1)] = cljs.core.first((state_40290[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40357 = state_40290;
state_40290 = G__40357;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = function(state_40290){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1.call(this,state_40290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40312 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40312[(6)] = c__16469__auto____$1);

return statearr_40312;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto____$1;
});
})();
var inst_40199 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40192,tuples_res);
var inst_40200 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_40193__$1,inst_40198,inst_40192);
var inst_40201 = cljs.core.PersistentVector.EMPTY;
var inst_40202 = inst_40201;
var state_40243__$1 = (function (){var statearr_40313 = state_40243;
(statearr_40313[(11)] = inst_40200);

(statearr_40313[(12)] = inst_40199);

(statearr_40313[(8)] = inst_40193__$1);

(statearr_40313[(9)] = inst_40194__$1);

(statearr_40313[(13)] = inst_40202);

return statearr_40313;
})();
var statearr_40314_40358 = state_40243__$1;
(statearr_40314_40358[(2)] = null);

(statearr_40314_40358[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (19))){
var inst_40205 = (state_40243[(7)]);
var inst_40202 = (state_40243[(13)]);
var inst_40225 = cljs.core.first(inst_40205);
var inst_40226 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40202,inst_40225);
var inst_40202__$1 = inst_40226;
var state_40243__$1 = (function (){var statearr_40315 = state_40243;
(statearr_40315[(13)] = inst_40202__$1);

return statearr_40315;
})();
var statearr_40316_40359 = state_40243__$1;
(statearr_40316_40359[(2)] = null);

(statearr_40316_40359[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (11))){
var inst_40236 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40318_40360 = state_40243__$1;
(statearr_40318_40360[(2)] = inst_40236);

(statearr_40318_40360[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (9))){
var inst_40202 = (state_40243[(13)]);
var state_40243__$1 = state_40243;
var statearr_40319_40361 = state_40243__$1;
(statearr_40319_40361[(2)] = inst_40202);

(statearr_40319_40361[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (5))){
var _ = (function (){var statearr_40320 = state_40243;
(statearr_40320[(4)] = cljs.core.rest((state_40243[(4)])));

return statearr_40320;
})();
var state_40243__$1 = state_40243;
var ex40317 = (state_40243__$1[(2)]);
var statearr_40321_40362 = state_40243__$1;
(statearr_40321_40362[(5)] = ex40317);


if((ex40317 instanceof Error)){
var statearr_40322_40363 = state_40243__$1;
(statearr_40322_40363[(1)] = (4));

(statearr_40322_40363[(5)] = null);

} else {
throw ex40317;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (14))){
var inst_40234 = (state_40243[(2)]);
var state_40243__$1 = state_40243;
var statearr_40323_40364 = state_40243__$1;
(statearr_40323_40364[(2)] = inst_40234);

(statearr_40323_40364[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (16))){
var state_40243__$1 = state_40243;
var statearr_40324_40365 = state_40243__$1;
(statearr_40324_40365[(2)] = null);

(statearr_40324_40365[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (10))){
var inst_40205 = (state_40243[(7)]);
var inst_40209 = fluree.db.util.core.exception_QMARK_(inst_40205);
var state_40243__$1 = state_40243;
if(inst_40209){
var statearr_40325_40366 = state_40243__$1;
(statearr_40325_40366[(1)] = (12));

} else {
var statearr_40326_40367 = state_40243__$1;
(statearr_40326_40367[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (18))){
var inst_40194 = (state_40243[(9)]);
var inst_40218 = (inst_40194.cljs$core$IFn$_invoke$arity$0 ? inst_40194.cljs$core$IFn$_invoke$arity$0() : inst_40194.call(null));
var inst_40219 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_40220 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_40221 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_40222 = cljs.core.PersistentHashMap.fromArrays(inst_40220,inst_40221);
var inst_40223 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40219,inst_40222);
var state_40243__$1 = (function (){var statearr_40327 = state_40243;
(statearr_40327[(14)] = inst_40218);

return statearr_40327;
})();
var statearr_40328_40368 = state_40243__$1;
(statearr_40328_40368[(2)] = inst_40223);

(statearr_40328_40368[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40244 === (8))){
var inst_40205 = (state_40243[(7)]);
var inst_40205__$1 = (state_40243[(2)]);
var inst_40206 = (inst_40205__$1 == null);
var state_40243__$1 = (function (){var statearr_40329 = state_40243;
(statearr_40329[(7)] = inst_40205__$1);

return statearr_40329;
})();
if(cljs.core.truth_(inst_40206)){
var statearr_40330_40369 = state_40243__$1;
(statearr_40330_40369[(1)] = (9));

} else {
var statearr_40331_40370 = state_40243__$1;
(statearr_40331_40370[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0 = (function (){
var statearr_40332 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40332[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__);

(statearr_40332[(1)] = (1));

return statearr_40332;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1 = (function (state_40243){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40243);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40333){var ex__16398__auto__ = e40333;
var statearr_40334_40371 = state_40243;
(statearr_40334_40371[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40243[(4)]))){
var statearr_40335_40372 = state_40243;
(statearr_40335_40372[(1)] = cljs.core.first((state_40243[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40373 = state_40243;
state_40243 = G__40373;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = function(state_40243){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1.call(this,state_40243);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40336 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40336[(6)] = c__16469__auto__);

return statearr_40336;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__40374 = select;
var map__40374__$1 = cljs.core.__destructure_map(map__40374);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40374__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40374__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40374__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__40377 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40377,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40377,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40377,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__40375_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40375_SHARP_,compare_idx));
}):(function (p1__40376_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40376_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__40382 = arguments.length;
switch (G__40382) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__40383,p__40384,group_limit,opts){
var map__40385 = p__40383;
var map__40385__$1 = cljs.core.__destructure_map(map__40385);
var res = map__40385__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40385__$1,cljs.core.cst$kw$vars);
var map__40386 = p__40384;
var map__40386__$1 = cljs.core.__destructure_map(map__40386);
var select_spec = map__40386__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40386__$1,cljs.core.cst$kw$groupBy);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40523){
var state_val_40524 = (state_40523[(1)]);
if((state_val_40524 === (7))){
var inst_40393 = (state_40523[(7)]);
var state_40523__$1 = state_40523;
var statearr_40525_40627 = state_40523__$1;
(statearr_40525_40627[(2)] = inst_40393);

(statearr_40525_40627[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (59))){
var inst_40516 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
var statearr_40526_40628 = state_40523__$1;
(statearr_40526_40628[(2)] = inst_40516);

(statearr_40526_40628[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (20))){
var inst_40429 = (state_40523[(8)]);
var inst_40432 = (state_40523[(9)]);
var inst_40428 = (state_40523[(2)]);
var inst_40429__$1 = cljs.core.__destructure_map(inst_40428);
var inst_40430 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40429__$1,cljs.core.cst$kw$headers);
var inst_40431 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40429__$1,cljs.core.cst$kw$tuples);
var inst_40432__$1 = offset;
var state_40523__$1 = (function (){var statearr_40527 = state_40523;
(statearr_40527[(10)] = inst_40431);

(statearr_40527[(8)] = inst_40429__$1);

(statearr_40527[(11)] = inst_40430);

(statearr_40527[(9)] = inst_40432__$1);

return statearr_40527;
})();
if(cljs.core.truth_(inst_40432__$1)){
var statearr_40528_40629 = state_40523__$1;
(statearr_40528_40629[(1)] = (21));

} else {
var statearr_40529_40630 = state_40523__$1;
(statearr_40529_40630[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (58))){
var inst_40508 = (state_40523[(12)]);
var state_40523__$1 = state_40523;
var statearr_40530_40631 = state_40523__$1;
(statearr_40530_40631[(2)] = inst_40508);

(statearr_40530_40631[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (60))){
var inst_40512 = (state_40523[(2)]);
var inst_40513 = fluree.db.util.async.throw_err(inst_40512);
var state_40523__$1 = state_40523;
var statearr_40531_40632 = state_40523__$1;
(statearr_40531_40632[(2)] = inst_40513);

(statearr_40531_40632[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (27))){
var inst_40444 = cljs.core.not(inVector_QMARK_);
var state_40523__$1 = state_40523;
var statearr_40532_40633 = state_40523__$1;
(statearr_40532_40633[(2)] = inst_40444);

(statearr_40532_40633[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (1))){
var state_40523__$1 = state_40523;
var statearr_40533_40634 = state_40523__$1;
(statearr_40533_40634[(2)] = null);

(statearr_40533_40634[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (24))){
var state_40523__$1 = state_40523;
var statearr_40534_40635 = state_40523__$1;
(statearr_40534_40635[(2)] = offset);

(statearr_40534_40635[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (55))){
var inst_40502 = (state_40523[(13)]);
var state_40523__$1 = state_40523;
var statearr_40535_40636 = state_40523__$1;
(statearr_40535_40636[(2)] = inst_40502);

(statearr_40535_40636[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (39))){
var inst_40470 = (state_40523[(14)]);
var inst_40472 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40473 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40470,inst_40472);
var state_40523__$1 = state_40523;
var statearr_40536_40637 = state_40523__$1;
(statearr_40536_40637[(2)] = inst_40473);

(statearr_40536_40637[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (46))){
var inst_40482 = (state_40523[(15)]);
var state_40523__$1 = state_40523;
var statearr_40537_40638 = state_40523__$1;
(statearr_40537_40638[(2)] = inst_40482);

(statearr_40537_40638[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (4))){
var inst_40387 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
var statearr_40538_40639 = state_40523__$1;
(statearr_40538_40639[(2)] = inst_40387);

(statearr_40538_40639[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (54))){
var inst_40502 = (state_40523[(13)]);
var inst_40496 = (state_40523[(16)]);
var inst_40504 = cljs.core.PersistentVector.EMPTY;
var inst_40505 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_40504,inst_40496,inst_40502);
var state_40523__$1 = state_40523;
var statearr_40539_40640 = state_40523__$1;
(statearr_40539_40640[(2)] = inst_40505);

(statearr_40539_40640[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (15))){
var inst_40414 = (state_40523[(17)]);
var inst_40416 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40417 = [inst_40414];
var inst_40418 = (new cljs.core.PersistentVector(null,1,(5),inst_40416,inst_40417,null));
var state_40523__$1 = state_40523;
var statearr_40540_40641 = state_40523__$1;
(statearr_40540_40641[(2)] = inst_40418);

(statearr_40540_40641[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (48))){
var inst_40488 = (state_40523[(18)]);
var inst_40431 = (state_40523[(10)]);
var inst_40429 = (state_40523[(8)]);
var inst_40430 = (state_40523[(11)]);
var inst_40452 = (state_40523[(19)]);
var inst_40447 = (state_40523[(20)]);
var inst_40441 = (state_40523[(21)]);
var inst_40490 = (function (){var map__40423 = inst_40429;
var headers = inst_40430;
var tuples = inst_40431;
var offset_SINGLEQUOTE_ = inst_40441;
var single_result_QMARK_ = inst_40447;
var pp_keys = inst_40452;
var G__40453 = inst_40488;
return (function (p1__40380_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__40380_SHARP_);
});
})();
var inst_40491 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40490);
var inst_40492 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40488,inst_40491);
var state_40523__$1 = state_40523;
var statearr_40541_40642 = state_40523__$1;
(statearr_40541_40642[(2)] = inst_40492);

(statearr_40541_40642[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (50))){
var inst_40495 = (state_40523[(2)]);
var inst_40496 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_40495);
var state_40523__$1 = (function (){var statearr_40542 = state_40523;
(statearr_40542[(16)] = inst_40496);

return statearr_40542;
})();
if(cljs.core.truth_(orderBy)){
var statearr_40543_40643 = state_40523__$1;
(statearr_40543_40643[(1)] = (51));

} else {
var statearr_40544_40644 = state_40523__$1;
(statearr_40544_40644[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (21))){
var inst_40434 = cljs.core.not(groupBy);
var state_40523__$1 = state_40523;
var statearr_40545_40645 = state_40523__$1;
(statearr_40545_40645[(2)] = inst_40434);

(statearr_40545_40645[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (31))){
var state_40523__$1 = state_40523;
var statearr_40546_40646 = state_40523__$1;
(statearr_40546_40646[(2)] = null);

(statearr_40546_40646[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (32))){
var inst_40430 = (state_40523[(11)]);
var inst_40447 = (state_40523[(20)]);
var inst_40452 = (state_40523[(2)]);
var inst_40454 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40455 = fluree.db.query.fql.select_tuples_fn(inst_40430,vars,select);
var inst_40456 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40455);
var inst_40457 = [inst_40456];
var inst_40458 = (new cljs.core.PersistentVector(null,1,(5),inst_40454,inst_40457,null));
var state_40523__$1 = (function (){var statearr_40547 = state_40523;
(statearr_40547[(22)] = inst_40458);

(statearr_40547[(19)] = inst_40452);

return statearr_40547;
})();
if(cljs.core.truth_(inst_40447)){
var statearr_40548_40647 = state_40523__$1;
(statearr_40548_40647[(1)] = (33));

} else {
var statearr_40549_40648 = state_40523__$1;
(statearr_40549_40648[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (40))){
var inst_40470 = (state_40523[(14)]);
var state_40523__$1 = state_40523;
var statearr_40550_40649 = state_40523__$1;
(statearr_40550_40649[(2)] = inst_40470);

(statearr_40550_40649[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (56))){
var inst_40508 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40551 = state_40523;
(statearr_40551[(12)] = inst_40508);

return statearr_40551;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_40552_40650 = state_40523__$1;
(statearr_40552_40650[(1)] = (57));

} else {
var statearr_40553_40651 = state_40523__$1;
(statearr_40553_40651[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (33))){
var inst_40458 = (state_40523[(22)]);
var inst_40460 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_40461 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40458,inst_40460);
var state_40523__$1 = state_40523;
var statearr_40554_40652 = state_40523__$1;
(statearr_40554_40652[(2)] = inst_40461);

(statearr_40554_40652[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (13))){
var inst_40403 = (state_40523[(23)]);
var state_40523__$1 = state_40523;
var statearr_40555_40653 = state_40523__$1;
(statearr_40555_40653[(2)] = inst_40403);

(statearr_40555_40653[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (22))){
var inst_40432 = (state_40523[(9)]);
var state_40523__$1 = state_40523;
var statearr_40556_40654 = state_40523__$1;
(statearr_40556_40654[(2)] = inst_40432);

(statearr_40556_40654[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (36))){
var inst_40464 = (state_40523[(24)]);
var inst_40466 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_40467 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40464,inst_40466);
var state_40523__$1 = state_40523;
var statearr_40557_40655 = state_40523__$1;
(statearr_40557_40655[(2)] = inst_40467);

(statearr_40557_40655[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (41))){
var inst_40441 = (state_40523[(21)]);
var inst_40476 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40558 = state_40523;
(statearr_40558[(25)] = inst_40476);

return statearr_40558;
})();
if(cljs.core.truth_(inst_40441)){
var statearr_40559_40656 = state_40523__$1;
(statearr_40559_40656[(1)] = (42));

} else {
var statearr_40560_40657 = state_40523__$1;
(statearr_40560_40657[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (43))){
var inst_40476 = (state_40523[(25)]);
var state_40523__$1 = state_40523;
var statearr_40561_40658 = state_40523__$1;
(statearr_40561_40658[(2)] = inst_40476);

(statearr_40561_40658[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (29))){
var inst_40447 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40562 = state_40523;
(statearr_40562[(20)] = inst_40447);

return statearr_40562;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40563_40659 = state_40523__$1;
(statearr_40563_40659[(1)] = (30));

} else {
var statearr_40564_40660 = state_40523__$1;
(statearr_40564_40660[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (44))){
var inst_40482 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40565 = state_40523;
(statearr_40565[(15)] = inst_40482);

return statearr_40565;
})();
if(cljs.core.truth_(group_limit)){
var statearr_40566_40661 = state_40523__$1;
(statearr_40566_40661[(1)] = (45));

} else {
var statearr_40567_40662 = state_40523__$1;
(statearr_40567_40662[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (6))){
var inst_40395 = cljs.core.count(select);
var inst_40396 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_40395);
var state_40523__$1 = state_40523;
var statearr_40568_40663 = state_40523__$1;
(statearr_40568_40663[(2)] = inst_40396);

(statearr_40568_40663[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (28))){
var inst_40442 = (state_40523[(26)]);
var state_40523__$1 = state_40523;
var statearr_40569_40664 = state_40523__$1;
(statearr_40569_40664[(2)] = inst_40442);

(statearr_40569_40664[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (51))){
var inst_40431 = (state_40523[(10)]);
var inst_40430 = (state_40523[(11)]);
var inst_40499 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_40430,orderBy,inst_40431);
var state_40523__$1 = state_40523;
var statearr_40570_40665 = state_40523__$1;
(statearr_40570_40665[(2)] = inst_40499);

(statearr_40570_40665[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (25))){
var state_40523__$1 = state_40523;
var statearr_40571_40666 = state_40523__$1;
(statearr_40571_40666[(2)] = null);

(statearr_40571_40666[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (34))){
var inst_40458 = (state_40523[(22)]);
var state_40523__$1 = state_40523;
var statearr_40572_40667 = state_40523__$1;
(statearr_40572_40667[(2)] = inst_40458);

(statearr_40572_40667[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (17))){
var inst_40421 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
var statearr_40573_40668 = state_40523__$1;
(statearr_40573_40668[(2)] = inst_40421);

(statearr_40573_40668[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (3))){
var inst_40521 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40523__$1,inst_40521);
} else {
if((state_val_40524 === (12))){
var inst_40403 = (state_40523[(23)]);
var inst_40405 = cljs.core.first(select);
var inst_40406 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_40405);
var inst_40407 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40406);
var inst_40408 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_40407,(1));
var inst_40409 = [inst_40408];
var inst_40410 = [inst_40403];
var inst_40411 = cljs.core.PersistentHashMap.fromArrays(inst_40409,inst_40410);
var state_40523__$1 = state_40523;
var statearr_40574_40669 = state_40523__$1;
(statearr_40574_40669[(2)] = inst_40411);

(statearr_40574_40669[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (2))){
var inst_40393 = (state_40523[(7)]);
var _ = (function (){var statearr_40575 = state_40523;
(statearr_40575[(4)] = cljs.core.cons((5),(state_40523[(4)])));

return statearr_40575;
})();
var inst_40393__$1 = aggregates;
var state_40523__$1 = (function (){var statearr_40576 = state_40523;
(statearr_40576[(7)] = inst_40393__$1);

return statearr_40576;
})();
if(cljs.core.truth_(inst_40393__$1)){
var statearr_40577_40670 = state_40523__$1;
(statearr_40577_40670[(1)] = (6));

} else {
var statearr_40578_40671 = state_40523__$1;
(statearr_40578_40671[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (23))){
var inst_40437 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
if(cljs.core.truth_(inst_40437)){
var statearr_40579_40672 = state_40523__$1;
(statearr_40579_40672[(1)] = (24));

} else {
var statearr_40580_40673 = state_40523__$1;
(statearr_40580_40673[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (47))){
var inst_40488 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40581 = state_40523;
(statearr_40581[(18)] = inst_40488);

return statearr_40581;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40582_40674 = state_40523__$1;
(statearr_40582_40674[(1)] = (48));

} else {
var statearr_40583_40675 = state_40523__$1;
(statearr_40583_40675[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (35))){
var inst_40464 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40584 = state_40523;
(statearr_40584[(24)] = inst_40464);

return statearr_40584;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40585_40676 = state_40523__$1;
(statearr_40585_40676[(1)] = (36));

} else {
var statearr_40586_40677 = state_40523__$1;
(statearr_40586_40677[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (19))){
var state_40523__$1 = state_40523;
var statearr_40587_40678 = state_40523__$1;
(statearr_40587_40678[(2)] = res);

(statearr_40587_40678[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (57))){
var inst_40508 = (state_40523[(12)]);
var inst_40452 = (state_40523[(19)]);
var inst_40447 = (state_40523[(20)]);
var inst_40510 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_40452,inst_40447,db,fuel,max_fuel,opts,(8),inst_40508);
var state_40523__$1 = state_40523;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40523__$1,(60),inst_40510);
} else {
if((state_val_40524 === (11))){
var inst_40518 = (state_40523[(2)]);
var _ = (function (){var statearr_40589 = state_40523;
(statearr_40589[(4)] = cljs.core.rest((state_40523[(4)])));

return statearr_40589;
})();
var state_40523__$1 = state_40523;
var statearr_40590_40679 = state_40523__$1;
(statearr_40590_40679[(2)] = inst_40518);

(statearr_40590_40679[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (9))){
var inst_40401 = cljs.core.first(aggregates);
var inst_40402 = fluree.db.query.analytical.calculate_aggregate(res,inst_40401);
var inst_40403 = cljs.core.second(inst_40402);
var state_40523__$1 = (function (){var statearr_40591 = state_40523;
(statearr_40591[(23)] = inst_40403);

return statearr_40591;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40592_40680 = state_40523__$1;
(statearr_40592_40680[(1)] = (12));

} else {
var statearr_40593_40681 = state_40523__$1;
(statearr_40593_40681[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (5))){
var _ = (function (){var statearr_40594 = state_40523;
(statearr_40594[(4)] = cljs.core.rest((state_40523[(4)])));

return statearr_40594;
})();
var state_40523__$1 = state_40523;
var ex40588 = (state_40523__$1[(2)]);
var statearr_40595_40682 = state_40523__$1;
(statearr_40595_40682[(5)] = ex40588);


if((ex40588 instanceof Error)){
var statearr_40596_40683 = state_40523__$1;
(statearr_40596_40683[(1)] = (4));

(statearr_40596_40683[(5)] = null);

} else {
throw ex40588;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (14))){
var inst_40414 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40597 = state_40523;
(statearr_40597[(17)] = inst_40414);

return statearr_40597;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40598_40684 = state_40523__$1;
(statearr_40598_40684[(1)] = (15));

} else {
var statearr_40599_40685 = state_40523__$1;
(statearr_40599_40685[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (45))){
var inst_40482 = (state_40523[(15)]);
var inst_40484 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_40485 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40482,inst_40484);
var state_40523__$1 = state_40523;
var statearr_40600_40686 = state_40523__$1;
(statearr_40600_40686[(2)] = inst_40485);

(statearr_40600_40686[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (53))){
var inst_40502 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40601 = state_40523;
(statearr_40601[(13)] = inst_40502);

return statearr_40601;
})();
var statearr_40602_40687 = state_40523__$1;
(statearr_40602_40687[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (26))){
var inst_40442 = (state_40523[(26)]);
var inst_40441 = (state_40523[(2)]);
var inst_40442__$1 = cljs.core.not(prettyPrint);
var state_40523__$1 = (function (){var statearr_40604 = state_40523;
(statearr_40604[(21)] = inst_40441);

(statearr_40604[(26)] = inst_40442__$1);

return statearr_40604;
})();
if(inst_40442__$1){
var statearr_40605_40688 = state_40523__$1;
(statearr_40605_40688[(1)] = (27));

} else {
var statearr_40606_40689 = state_40523__$1;
(statearr_40606_40689[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (16))){
var inst_40414 = (state_40523[(17)]);
var state_40523__$1 = state_40523;
var statearr_40607_40690 = state_40523__$1;
(statearr_40607_40690[(2)] = inst_40414);

(statearr_40607_40690[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (38))){
var inst_40470 = (state_40523[(2)]);
var state_40523__$1 = (function (){var statearr_40608 = state_40523;
(statearr_40608[(14)] = inst_40470);

return statearr_40608;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40609_40691 = state_40523__$1;
(statearr_40609_40691[(1)] = (39));

} else {
var statearr_40610_40692 = state_40523__$1;
(statearr_40610_40692[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (30))){
var inst_40449 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_40523__$1 = state_40523;
var statearr_40611_40693 = state_40523__$1;
(statearr_40611_40693[(2)] = inst_40449);

(statearr_40611_40693[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (10))){
var state_40523__$1 = state_40523;
if(cljs.core.truth_(aggregates)){
var statearr_40612_40694 = state_40523__$1;
(statearr_40612_40694[(1)] = (18));

} else {
var statearr_40613_40695 = state_40523__$1;
(statearr_40613_40695[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (18))){
var inst_40425 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_40523__$1 = state_40523;
var statearr_40614_40696 = state_40523__$1;
(statearr_40614_40696[(2)] = inst_40425);

(statearr_40614_40696[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (52))){
var inst_40431 = (state_40523[(10)]);
var state_40523__$1 = state_40523;
var statearr_40615_40697 = state_40523__$1;
(statearr_40615_40697[(2)] = inst_40431);

(statearr_40615_40697[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (42))){
var inst_40476 = (state_40523[(25)]);
var inst_40441 = (state_40523[(21)]);
var inst_40478 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_40441);
var inst_40479 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40476,inst_40478);
var state_40523__$1 = state_40523;
var statearr_40616_40698 = state_40523__$1;
(statearr_40616_40698[(2)] = inst_40479);

(statearr_40616_40698[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (37))){
var inst_40464 = (state_40523[(24)]);
var state_40523__$1 = state_40523;
var statearr_40617_40699 = state_40523__$1;
(statearr_40617_40699[(2)] = inst_40464);

(statearr_40617_40699[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (8))){
var inst_40399 = (state_40523[(2)]);
var state_40523__$1 = state_40523;
if(cljs.core.truth_(inst_40399)){
var statearr_40618_40700 = state_40523__$1;
(statearr_40618_40700[(1)] = (9));

} else {
var statearr_40619_40701 = state_40523__$1;
(statearr_40619_40701[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40524 === (49))){
var inst_40488 = (state_40523[(18)]);
var state_40523__$1 = state_40523;
var statearr_40620_40702 = state_40523__$1;
(statearr_40620_40702[(2)] = inst_40488);

(statearr_40620_40702[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_40621 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40621[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_40621[(1)] = (1));

return statearr_40621;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_40523){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40523);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40622){var ex__16398__auto__ = e40622;
var statearr_40623_40703 = state_40523;
(statearr_40623_40703[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40523[(4)]))){
var statearr_40624_40704 = state_40523;
(statearr_40624_40704[(1)] = cljs.core.first((state_40523[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40705 = state_40523;
state_40523 = G__40705;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_40523){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_40523);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40625 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40625[(6)] = c__16469__auto__);

return statearr_40625;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__40708,groupBy){
var map__40709 = p__40708;
var map__40709__$1 = cljs.core.__destructure_map(map__40709);
var res = map__40709__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40709__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40709__$1,cljs.core.cst$kw$tuples);
var vec__40710 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40710,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40710,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40706_SHARP_){
return fluree.db.util.core.index_of(headers,p1__40706_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40707_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__40707_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__40713 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40713,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40713,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__40716,p__40717,opts){
var map__40718 = p__40716;
var map__40718__$1 = cljs.core.__destructure_map(map__40718);
var res = map__40718__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40718__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40718__$1,cljs.core.cst$kw$vars);
var map__40719 = p__40717;
var map__40719__$1 = cljs.core.__destructure_map(map__40719);
var select_spec = map__40719__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40719__$1,cljs.core.cst$kw$offset);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40961){
var state_val_40962 = (state_40961[(1)]);
if((state_val_40962 === (65))){
var state_40961__$1 = state_40961;
var statearr_40963_41114 = state_40961__$1;
(statearr_40963_41114[(1)] = (67));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (70))){
var inst_40882 = (state_40961[(7)]);
var state_40961__$1 = state_40961;
var statearr_40965_41115 = state_40961__$1;
(statearr_40965_41115[(2)] = inst_40882);

(statearr_40965_41115[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (62))){
var state_40961__$1 = state_40961;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40966_41116 = state_40961__$1;
(statearr_40966_41116[(1)] = (64));

} else {
var statearr_40967_41117 = state_40961__$1;
(statearr_40967_41117[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (74))){
var inst_40789 = (state_40961[(8)]);
var inst_40857 = (state_40961[(9)]);
var inst_40798 = (state_40961[(10)]);
var inst_40890 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40789,inst_40798,inst_40857);
var state_40961__$1 = state_40961;
var statearr_40968_41118 = state_40961__$1;
(statearr_40968_41118[(2)] = inst_40890);

(statearr_40968_41118[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (7))){
var state_40961__$1 = state_40961;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_40969_41119 = state_40961__$1;
(statearr_40969_41119[(1)] = (82));

} else {
var statearr_40970_41120 = state_40961__$1;
(statearr_40970_41120[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (59))){
var inst_40857 = (state_40961[(9)]);
var inst_40787 = (state_40961[(11)]);
var inst_40861 = cljs.core.count(inst_40857);
var inst_40862 = (inst_40787 - inst_40861);
var state_40961__$1 = state_40961;
var statearr_40971_41121 = state_40961__$1;
(statearr_40971_41121[(2)] = inst_40862);

(statearr_40971_41121[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (86))){
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40972_41122 = state_40961__$1;
(statearr_40972_41122[(1)] = (89));

} else {
var statearr_40973_41123 = state_40961__$1;
(statearr_40973_41123[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (20))){
var state_40961__$1 = state_40961;
var statearr_40974_41124 = state_40961__$1;
(statearr_40974_41124[(2)] = (0));

(statearr_40974_41124[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (72))){
var inst_40887 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40887)){
var statearr_40975_41125 = state_40961__$1;
(statearr_40975_41125[(1)] = (73));

} else {
var statearr_40976_41126 = state_40961__$1;
(statearr_40976_41126[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (58))){
var state_40961__$1 = state_40961;
var statearr_40977_41127 = state_40961__$1;
(statearr_40977_41127[(2)] = null);

(statearr_40977_41127[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (60))){
var inst_40788 = (state_40961[(12)]);
var inst_40864 = (state_40961[(2)]);
var inst_40865 = (inst_40788 <= (0));
var state_40961__$1 = (function (){var statearr_40978 = state_40961;
(statearr_40978[(13)] = inst_40864);

return statearr_40978;
})();
if(cljs.core.truth_(inst_40865)){
var statearr_40979_41128 = state_40961__$1;
(statearr_40979_41128[(1)] = (61));

} else {
var statearr_40980_41129 = state_40961__$1;
(statearr_40980_41129[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (27))){
var inst_40787 = (state_40961[(11)]);
var inst_40811 = (inst_40787 < (1));
var state_40961__$1 = state_40961;
var statearr_40981_41130 = state_40961__$1;
(statearr_40981_41130[(2)] = inst_40811);

(statearr_40981_41130[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (1))){
var state_40961__$1 = state_40961;
var statearr_40982_41131 = state_40961__$1;
(statearr_40982_41131[(2)] = null);

(statearr_40982_41131[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (69))){
var inst_40877 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_40983_41132 = state_40961__$1;
(statearr_40983_41132[(2)] = inst_40877);

(statearr_40983_41132[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (24))){
var inst_40789 = (state_40961[(8)]);
var state_40961__$1 = state_40961;
var statearr_40984_41133 = state_40961__$1;
(statearr_40984_41133[(2)] = inst_40789);

(statearr_40984_41133[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (55))){
var inst_40787 = (state_40961[(11)]);
var inst_40847 = (state_40961[(14)]);
var inst_40854 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40787,inst_40847);
var state_40961__$1 = state_40961;
var statearr_40985_41134 = state_40961__$1;
(statearr_40985_41134[(2)] = inst_40854);

(statearr_40985_41134[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (85))){
var inst_40932 = (state_40961[(15)]);
var inst_40931 = (state_40961[(2)]);
var inst_40932__$1 = fluree.db.util.async.throw_err(inst_40931);
var inst_40933 = cljs.core.coll_QMARK_(inst_40932__$1);
var inst_40934 = (!(inst_40933));
var state_40961__$1 = (function (){var statearr_40986 = state_40961;
(statearr_40986[(15)] = inst_40932__$1);

return statearr_40986;
})();
if(inst_40934){
var statearr_40987_41135 = state_40961__$1;
(statearr_40987_41135[(1)] = (86));

} else {
var statearr_40988_41136 = state_40961__$1;
(statearr_40988_41136[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (39))){
var inst_40806 = (state_40961[(16)]);
var inst_40828 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_40829 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_40830 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_40806,inst_40828,inst_40829);
var state_40961__$1 = state_40961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40961__$1,(42),inst_40830);
} else {
if((state_val_40962 === (88))){
var inst_40954 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_40989_41137 = state_40961__$1;
(statearr_40989_41137[(2)] = inst_40954);

(statearr_40989_41137[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (46))){
var inst_40788 = (state_40961[(12)]);
var inst_40842 = ((0) < inst_40788);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40842)){
var statearr_40990_41138 = state_40961__$1;
(statearr_40990_41138[(1)] = (49));

} else {
var statearr_40991_41139 = state_40961__$1;
(statearr_40991_41139[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (4))){
var inst_40720 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_40992_41140 = state_40961__$1;
(statearr_40992_41140[(2)] = inst_40720);

(statearr_40992_41140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (77))){
var inst_40787 = (state_40961[(11)]);
var inst_40898 = (inst_40787 - (1));
var state_40961__$1 = state_40961;
var statearr_40993_41141 = state_40961__$1;
(statearr_40993_41141[(2)] = inst_40898);

(statearr_40993_41141[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (95))){
var inst_40932 = (state_40961[(15)]);
var state_40961__$1 = state_40961;
var statearr_40994_41142 = state_40961__$1;
(statearr_40994_41142[(2)] = inst_40932);

(statearr_40994_41142[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (54))){
var inst_40852 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40852)){
var statearr_40995_41143 = state_40961__$1;
(statearr_40995_41143[(1)] = (55));

} else {
var statearr_40996_41144 = state_40961__$1;
(statearr_40996_41144[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (92))){
var inst_40932 = (state_40961[(15)]);
var inst_40945 = cljs.core.first(inst_40932);
var state_40961__$1 = state_40961;
var statearr_40997_41145 = state_40961__$1;
(statearr_40997_41145[(2)] = inst_40945);

(statearr_40997_41145[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (15))){
var inst_40738 = (state_40961[(17)]);
var inst_40746 = (state_40961[(2)]);
var inst_40747 = fluree.db.util.async.throw_err(inst_40746);
var inst_40748 = [inst_40738];
var inst_40749 = [inst_40747];
var inst_40750 = cljs.core.PersistentHashMap.fromArrays(inst_40748,inst_40749);
var state_40961__$1 = state_40961;
var statearr_40998_41146 = state_40961__$1;
(statearr_40998_41146[(2)] = inst_40750);

(statearr_40998_41146[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (48))){
var inst_40910 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_40999_41147 = state_40961__$1;
(statearr_40999_41147[(2)] = inst_40910);

(statearr_40999_41147[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (50))){
var inst_40833 = (state_40961[(18)]);
var state_40961__$1 = state_40961;
var statearr_41000_41148 = state_40961__$1;
(statearr_41000_41148[(2)] = inst_40833);

(statearr_41000_41148[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (75))){
var inst_40864 = (state_40961[(13)]);
var inst_40799 = (state_40961[(19)]);
var inst_40881 = (state_40961[(20)]);
var inst_40802 = (state_40961[(21)]);
var inst_40892 = (state_40961[(2)]);
var inst_40785 = inst_40799;
var inst_40786 = inst_40802;
var inst_40787 = inst_40864;
var inst_40788 = inst_40881;
var inst_40789 = inst_40892;
var state_40961__$1 = (function (){var statearr_41001 = state_40961;
(statearr_41001[(12)] = inst_40788);

(statearr_41001[(22)] = inst_40786);

(statearr_41001[(8)] = inst_40789);

(statearr_41001[(23)] = inst_40785);

(statearr_41001[(11)] = inst_40787);

return statearr_41001;
})();
var statearr_41002_41149 = state_40961__$1;
(statearr_41002_41149[(2)] = null);

(statearr_41002_41149[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (21))){
var inst_40766 = (state_40961[(24)]);
var inst_40778 = (state_40961[(25)]);
var inst_40770 = (state_40961[(26)]);
var inst_40783 = (state_40961[(2)]);
var inst_40784 = cljs.core.PersistentHashMap.EMPTY;
var inst_40785 = inst_40766;
var inst_40786 = inst_40770;
var inst_40787 = inst_40778;
var inst_40788 = inst_40783;
var inst_40789 = inst_40784;
var state_40961__$1 = (function (){var statearr_41003 = state_40961;
(statearr_41003[(12)] = inst_40788);

(statearr_41003[(22)] = inst_40786);

(statearr_41003[(8)] = inst_40789);

(statearr_41003[(23)] = inst_40785);

(statearr_41003[(11)] = inst_40787);

return statearr_41003;
})();
var statearr_41004_41150 = state_40961__$1;
(statearr_41004_41150[(2)] = null);

(statearr_41004_41150[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (31))){
var inst_40788 = (state_40961[(12)]);
var inst_40803 = (state_40961[(27)]);
var inst_40817 = (inst_40788 >= inst_40803);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40817)){
var statearr_41005_41151 = state_40961__$1;
(statearr_41005_41151[(1)] = (33));

} else {
var statearr_41006_41152 = state_40961__$1;
(statearr_41006_41152[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (32))){
var inst_40917 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41007_41153 = state_40961__$1;
(statearr_41007_41153[(2)] = inst_40917);

(statearr_41007_41153[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (40))){
var state_40961__$1 = state_40961;
var statearr_41008_41154 = state_40961__$1;
(statearr_41008_41154[(2)] = null);

(statearr_41008_41154[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (91))){
var inst_40942 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41009_41155 = state_40961__$1;
(statearr_41009_41155[(2)] = inst_40942);

(statearr_41009_41155[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (56))){
var inst_40847 = (state_40961[(14)]);
var state_40961__$1 = state_40961;
var statearr_41010_41156 = state_40961__$1;
(statearr_41010_41156[(2)] = inst_40847);

(statearr_41010_41156[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (33))){
var state_40961__$1 = state_40961;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_41011_41157 = state_40961__$1;
(statearr_41011_41157[(1)] = (36));

} else {
var statearr_41012_41158 = state_40961__$1;
(statearr_41012_41158[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (13))){
var inst_40766 = (state_40961[(24)]);
var inst_40735 = (state_40961[(28)]);
var inst_40770 = (state_40961[(26)]);
var inst_40766__$1 = cljs.core.keys(inst_40735);
var inst_40767 = cljs.core.seq(inst_40766__$1);
var inst_40768 = cljs.core.first(inst_40767);
var inst_40769 = cljs.core.next(inst_40767);
var inst_40770__$1 = cljs.core.vals(inst_40735);
var inst_40771 = cljs.core.seq(inst_40770__$1);
var inst_40772 = cljs.core.first(inst_40771);
var inst_40773 = cljs.core.next(inst_40771);
var inst_40774 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_40961__$1 = (function (){var statearr_41013 = state_40961;
(statearr_41013[(29)] = inst_40773);

(statearr_41013[(24)] = inst_40766__$1);

(statearr_41013[(30)] = inst_40768);

(statearr_41013[(31)] = inst_40772);

(statearr_41013[(26)] = inst_40770__$1);

(statearr_41013[(32)] = inst_40769);

return statearr_41013;
})();
if(inst_40774){
var statearr_41014_41159 = state_40961__$1;
(statearr_41014_41159[(1)] = (16));

} else {
var statearr_41015_41160 = state_40961__$1;
(statearr_41015_41160[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (22))){
var inst_40786 = (state_40961[(22)]);
var inst_40785 = (state_40961[(23)]);
var inst_40797 = cljs.core.seq(inst_40785);
var inst_40798 = cljs.core.first(inst_40797);
var inst_40799 = cljs.core.next(inst_40797);
var inst_40800 = cljs.core.seq(inst_40786);
var inst_40801 = cljs.core.first(inst_40800);
var inst_40802 = cljs.core.next(inst_40800);
var inst_40803 = cljs.core.count(inst_40801);
var inst_40804 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40805 = [headers,vars,inst_40801];
var inst_40806 = cljs.core.PersistentHashMap.fromArrays(inst_40804,inst_40805);
var inst_40807 = (inst_40801 == null);
var state_40961__$1 = (function (){var statearr_41016 = state_40961;
(statearr_41016[(19)] = inst_40799);

(statearr_41016[(21)] = inst_40802);

(statearr_41016[(27)] = inst_40803);

(statearr_41016[(10)] = inst_40798);

(statearr_41016[(16)] = inst_40806);

return statearr_41016;
})();
if(cljs.core.truth_(inst_40807)){
var statearr_41017_41161 = state_40961__$1;
(statearr_41017_41161[(1)] = (24));

} else {
var statearr_41018_41162 = state_40961__$1;
(statearr_41018_41162[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (90))){
var inst_40932 = (state_40961[(15)]);
var state_40961__$1 = state_40961;
var statearr_41019_41163 = state_40961__$1;
(statearr_41019_41163[(2)] = inst_40932);

(statearr_41019_41163[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (36))){
var inst_40788 = (state_40961[(12)]);
var inst_40820 = (inst_40788 - (1));
var state_40961__$1 = state_40961;
var statearr_41020_41164 = state_40961__$1;
(statearr_41020_41164[(2)] = inst_40820);

(statearr_41020_41164[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (41))){
var inst_40913 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41021_41165 = state_40961__$1;
(statearr_41021_41165[(2)] = inst_40913);

(statearr_41021_41165[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (89))){
var inst_40932 = (state_40961[(15)]);
var inst_40937 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40938 = [inst_40932];
var inst_40939 = (new cljs.core.PersistentVector(null,1,(5),inst_40937,inst_40938,null));
var state_40961__$1 = state_40961;
var statearr_41022_41166 = state_40961__$1;
(statearr_41022_41166[(2)] = inst_40939);

(statearr_41022_41166[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (43))){
var inst_40833 = (state_40961[(18)]);
var inst_40836 = cljs.core.seq(inst_40833);
var state_40961__$1 = state_40961;
var statearr_41023_41167 = state_40961__$1;
(statearr_41023_41167[(2)] = inst_40836);

(statearr_41023_41167[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (61))){
var state_40961__$1 = state_40961;
var statearr_41024_41168 = state_40961__$1;
(statearr_41024_41168[(2)] = (0));

(statearr_41024_41168[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (29))){
var inst_40814 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40814)){
var statearr_41025_41169 = state_40961__$1;
(statearr_41025_41169[(1)] = (30));

} else {
var statearr_41026_41170 = state_40961__$1;
(statearr_41026_41170[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (44))){
var inst_40834 = (state_40961[(33)]);
var state_40961__$1 = state_40961;
var statearr_41027_41171 = state_40961__$1;
(statearr_41027_41171[(2)] = inst_40834);

(statearr_41027_41171[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (93))){
var state_40961__$1 = state_40961;
var statearr_41028_41172 = state_40961__$1;
(statearr_41028_41172[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (6))){
var inst_40727 = (state_40961[(34)]);
var inst_40727__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_40729 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_40961__$1 = (function (){var statearr_41030 = state_40961;
(statearr_41030[(35)] = inst_40729);

(statearr_41030[(34)] = inst_40727__$1);

return statearr_41030;
})();
if(cljs.core.truth_(inst_40727__$1)){
var statearr_41031_41173 = state_40961__$1;
(statearr_41031_41173[(1)] = (9));

} else {
var statearr_41032_41174 = state_40961__$1;
(statearr_41032_41174[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (28))){
var inst_40787 = (state_40961[(11)]);
var state_40961__$1 = state_40961;
var statearr_41033_41175 = state_40961__$1;
(statearr_41033_41175[(2)] = inst_40787);

(statearr_41033_41175[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (64))){
var inst_40788 = (state_40961[(12)]);
var inst_40869 = (inst_40788 - (1));
var state_40961__$1 = state_40961;
var statearr_41034_41176 = state_40961__$1;
(statearr_41034_41176[(2)] = inst_40869);

(statearr_41034_41176[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (51))){
var inst_40787 = (state_40961[(11)]);
var inst_40847 = (state_40961[(2)]);
var state_40961__$1 = (function (){var statearr_41035 = state_40961;
(statearr_41035[(14)] = inst_40847);

return statearr_41035;
})();
if(cljs.core.truth_(inst_40787)){
var statearr_41036_41177 = state_40961__$1;
(statearr_41036_41177[(1)] = (52));

} else {
var statearr_41037_41178 = state_40961__$1;
(statearr_41037_41178[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (25))){
var inst_40787 = (state_40961[(11)]);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40787)){
var statearr_41038_41179 = state_40961__$1;
(statearr_41038_41179[(1)] = (27));

} else {
var statearr_41039_41180 = state_40961__$1;
(statearr_41039_41180[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (34))){
var state_40961__$1 = state_40961;
var statearr_41040_41181 = state_40961__$1;
(statearr_41040_41181[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (17))){
var state_40961__$1 = state_40961;
var statearr_41042_41182 = state_40961__$1;
(statearr_41042_41182[(2)] = limit);

(statearr_41042_41182[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (3))){
var inst_40959 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40961__$1,inst_40959);
} else {
if((state_val_40962 === (12))){
var inst_40735 = (state_40961[(28)]);
var inst_40737 = cljs.core.keys(inst_40735);
var inst_40738 = cljs.core.first(inst_40737);
var inst_40739 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40740 = cljs.core.vals(inst_40735);
var inst_40741 = cljs.core.first(inst_40740);
var inst_40742 = [headers,vars,inst_40741];
var inst_40743 = cljs.core.PersistentHashMap.fromArrays(inst_40739,inst_40742);
var inst_40744 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_40743,select_spec,limit,opts);
var state_40961__$1 = (function (){var statearr_41043 = state_40961;
(statearr_41043[(17)] = inst_40738);

return statearr_41043;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40961__$1,(15),inst_40744);
} else {
if((state_val_40962 === (2))){
var _ = (function (){var statearr_41044 = state_40961;
(statearr_41044[(4)] = cljs.core.cons((5),(state_40961[(4)])));

return statearr_41044;
})();
var state_40961__$1 = state_40961;
if(cljs.core.truth_(groupBy)){
var statearr_41045_41183 = state_40961__$1;
(statearr_41045_41183[(1)] = (6));

} else {
var statearr_41046_41184 = state_40961__$1;
(statearr_41046_41184[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (66))){
var inst_40879 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41047_41185 = state_40961__$1;
(statearr_41047_41185[(2)] = inst_40879);

(statearr_41047_41185[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (23))){
var inst_40921 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41048_41186 = state_40961__$1;
(statearr_41048_41186[(2)] = inst_40921);

(statearr_41048_41186[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (47))){
var inst_40787 = (state_40961[(11)]);
var inst_40895 = (inst_40787 == null);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40895)){
var statearr_41049_41187 = state_40961__$1;
(statearr_41049_41187[(1)] = (76));

} else {
var statearr_41050_41188 = state_40961__$1;
(statearr_41050_41188[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (35))){
var inst_40915 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41051_41189 = state_40961__$1;
(statearr_41051_41189[(2)] = inst_40915);

(statearr_41051_41189[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (82))){
var state_40961__$1 = state_40961;
var statearr_41052_41190 = state_40961__$1;
(statearr_41052_41190[(2)] = (1));

(statearr_41052_41190[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (76))){
var state_40961__$1 = state_40961;
var statearr_41053_41191 = state_40961__$1;
(statearr_41053_41191[(2)] = null);

(statearr_41053_41191[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (97))){
var inst_40950 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41054_41192 = state_40961__$1;
(statearr_41054_41192[(2)] = inst_40950);

(statearr_41054_41192[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (19))){
var inst_40779 = (state_40961[(36)]);
var state_40961__$1 = state_40961;
var statearr_41055_41193 = state_40961__$1;
(statearr_41055_41193[(2)] = inst_40779);

(statearr_41055_41193[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (57))){
var inst_40787 = (state_40961[(11)]);
var inst_40857 = (state_40961[(2)]);
var inst_40858 = (inst_40787 == null);
var state_40961__$1 = (function (){var statearr_41056 = state_40961;
(statearr_41056[(9)] = inst_40857);

return statearr_41056;
})();
if(cljs.core.truth_(inst_40858)){
var statearr_41057_41194 = state_40961__$1;
(statearr_41057_41194[(1)] = (58));

} else {
var statearr_41058_41195 = state_40961__$1;
(statearr_41058_41195[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (68))){
var state_40961__$1 = state_40961;
var statearr_41059_41196 = state_40961__$1;
(statearr_41059_41196[(2)] = null);

(statearr_41059_41196[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (11))){
var inst_40735 = (state_40961[(2)]);
var state_40961__$1 = (function (){var statearr_41061 = state_40961;
(statearr_41061[(28)] = inst_40735);

return statearr_41061;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41062_41197 = state_40961__$1;
(statearr_41062_41197[(1)] = (12));

} else {
var statearr_41063_41198 = state_40961__$1;
(statearr_41063_41198[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (9))){
var inst_40729 = (state_40961[(35)]);
var inst_40727 = (state_40961[(34)]);
var inst_40731 = cljs.core.sorted_map_by(inst_40727);
var inst_40732 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40731,inst_40729);
var state_40961__$1 = state_40961;
var statearr_41064_41199 = state_40961__$1;
(statearr_41064_41199[(2)] = inst_40732);

(statearr_41064_41199[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (5))){
var _ = (function (){var statearr_41065 = state_40961;
(statearr_41065[(4)] = cljs.core.rest((state_40961[(4)])));

return statearr_41065;
})();
var state_40961__$1 = state_40961;
var ex41060 = (state_40961__$1[(2)]);
var statearr_41066_41200 = state_40961__$1;
(statearr_41066_41200[(5)] = ex41060);


if((ex41060 instanceof Error)){
var statearr_41067_41201 = state_40961__$1;
(statearr_41067_41201[(1)] = (4));

(statearr_41067_41201[(5)] = null);

} else {
throw ex41060;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (83))){
var state_40961__$1 = state_40961;
var statearr_41068_41202 = state_40961__$1;
(statearr_41068_41202[(2)] = limit);

(statearr_41068_41202[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (14))){
var inst_40923 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41069_41203 = state_40961__$1;
(statearr_41069_41203[(2)] = inst_40923);

(statearr_41069_41203[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (45))){
var inst_40839 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
if(cljs.core.truth_(inst_40839)){
var statearr_41070_41204 = state_40961__$1;
(statearr_41070_41204[(1)] = (46));

} else {
var statearr_41071_41205 = state_40961__$1;
(statearr_41071_41205[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (53))){
var inst_40787 = (state_40961[(11)]);
var state_40961__$1 = state_40961;
var statearr_41072_41206 = state_40961__$1;
(statearr_41072_41206[(2)] = inst_40787);

(statearr_41072_41206[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (78))){
var inst_40788 = (state_40961[(12)]);
var inst_40900 = (state_40961[(2)]);
var inst_40901 = (inst_40788 <= (0));
var state_40961__$1 = (function (){var statearr_41073 = state_40961;
(statearr_41073[(37)] = inst_40900);

return statearr_41073;
})();
if(cljs.core.truth_(inst_40901)){
var statearr_41074_41207 = state_40961__$1;
(statearr_41074_41207[(1)] = (79));

} else {
var statearr_41075_41208 = state_40961__$1;
(statearr_41075_41208[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (26))){
var inst_40919 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41076_41209 = state_40961__$1;
(statearr_41076_41209[(2)] = inst_40919);

(statearr_41076_41209[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (16))){
var state_40961__$1 = state_40961;
var statearr_41077_41210 = state_40961__$1;
(statearr_41077_41210[(2)] = null);

(statearr_41077_41210[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (81))){
var inst_40833 = (state_40961[(18)]);
var inst_40900 = (state_40961[(37)]);
var inst_40799 = (state_40961[(19)]);
var inst_40789 = (state_40961[(8)]);
var inst_40802 = (state_40961[(21)]);
var inst_40798 = (state_40961[(10)]);
var inst_40906 = (state_40961[(2)]);
var inst_40907 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40789,inst_40798,inst_40833);
var inst_40785 = inst_40799;
var inst_40786 = inst_40802;
var inst_40787 = inst_40900;
var inst_40788 = inst_40906;
var inst_40789__$1 = inst_40907;
var state_40961__$1 = (function (){var statearr_41080 = state_40961;
(statearr_41080[(12)] = inst_40788);

(statearr_41080[(22)] = inst_40786);

(statearr_41080[(8)] = inst_40789__$1);

(statearr_41080[(23)] = inst_40785);

(statearr_41080[(11)] = inst_40787);

return statearr_41080;
})();
var statearr_41081_41211 = state_40961__$1;
(statearr_41081_41211[(2)] = null);

(statearr_41081_41211[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (79))){
var state_40961__$1 = state_40961;
var statearr_41082_41212 = state_40961__$1;
(statearr_41082_41212[(2)] = (0));

(statearr_41082_41212[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (38))){
var inst_40799 = (state_40961[(19)]);
var inst_40789 = (state_40961[(8)]);
var inst_40802 = (state_40961[(21)]);
var inst_40787 = (state_40961[(11)]);
var inst_40824 = (state_40961[(2)]);
var tmp41078 = inst_40789;
var tmp41079 = inst_40787;
var inst_40785 = inst_40799;
var inst_40786 = inst_40802;
var inst_40787__$1 = tmp41079;
var inst_40788 = inst_40824;
var inst_40789__$1 = tmp41078;
var state_40961__$1 = (function (){var statearr_41083 = state_40961;
(statearr_41083[(12)] = inst_40788);

(statearr_41083[(22)] = inst_40786);

(statearr_41083[(8)] = inst_40789__$1);

(statearr_41083[(23)] = inst_40785);

(statearr_41083[(11)] = inst_40787__$1);

return statearr_41083;
})();
var statearr_41084_41213 = state_40961__$1;
(statearr_41084_41213[(2)] = null);

(statearr_41084_41213[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (87))){
var state_40961__$1 = state_40961;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41085_41214 = state_40961__$1;
(statearr_41085_41214[(1)] = (92));

} else {
var statearr_41086_41215 = state_40961__$1;
(statearr_41086_41215[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (30))){
var inst_40789 = (state_40961[(8)]);
var state_40961__$1 = state_40961;
var statearr_41087_41216 = state_40961__$1;
(statearr_41087_41216[(2)] = inst_40789);

(statearr_41087_41216[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (73))){
var inst_40789 = (state_40961[(8)]);
var state_40961__$1 = state_40961;
var statearr_41088_41217 = state_40961__$1;
(statearr_41088_41217[(2)] = inst_40789);

(statearr_41088_41217[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (96))){
var state_40961__$1 = state_40961;
var statearr_41089_41218 = state_40961__$1;
(statearr_41089_41218[(2)] = null);

(statearr_41089_41218[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (10))){
var inst_40729 = (state_40961[(35)]);
var state_40961__$1 = state_40961;
var statearr_41090_41219 = state_40961__$1;
(statearr_41090_41219[(2)] = inst_40729);

(statearr_41090_41219[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (18))){
var inst_40779 = (state_40961[(36)]);
var inst_40778 = (state_40961[(2)]);
var inst_40779__$1 = offset;
var state_40961__$1 = (function (){var statearr_41091 = state_40961;
(statearr_41091[(25)] = inst_40778);

(statearr_41091[(36)] = inst_40779__$1);

return statearr_41091;
})();
if(cljs.core.truth_(inst_40779__$1)){
var statearr_41092_41220 = state_40961__$1;
(statearr_41092_41220[(1)] = (19));

} else {
var statearr_41093_41221 = state_40961__$1;
(statearr_41093_41221[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (52))){
var inst_40787 = (state_40961[(11)]);
var inst_40849 = ((0) < inst_40787);
var state_40961__$1 = state_40961;
var statearr_41094_41222 = state_40961__$1;
(statearr_41094_41222[(2)] = inst_40849);

(statearr_41094_41222[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (67))){
var inst_40788 = (state_40961[(12)]);
var inst_40857 = (state_40961[(9)]);
var inst_40803 = (state_40961[(27)]);
var inst_40872 = cljs.core.count(inst_40857);
var inst_40873 = (inst_40803 - inst_40872);
var inst_40874 = (inst_40788 - inst_40873);
var state_40961__$1 = state_40961;
var statearr_41095_41223 = state_40961__$1;
(statearr_41095_41223[(2)] = inst_40874);

(statearr_41095_41223[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (71))){
var inst_40857 = (state_40961[(9)]);
var inst_40885 = cljs.core.empty_QMARK_(inst_40857);
var state_40961__$1 = state_40961;
var statearr_41096_41224 = state_40961__$1;
(statearr_41096_41224[(2)] = inst_40885);

(statearr_41096_41224[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (42))){
var inst_40833 = (state_40961[(18)]);
var inst_40834 = (state_40961[(33)]);
var inst_40832 = (state_40961[(2)]);
var inst_40833__$1 = fluree.db.util.async.throw_err(inst_40832);
var inst_40834__$1 = cljs.core.coll_QMARK_(inst_40833__$1);
var state_40961__$1 = (function (){var statearr_41097 = state_40961;
(statearr_41097[(18)] = inst_40833__$1);

(statearr_41097[(33)] = inst_40834__$1);

return statearr_41097;
})();
if(inst_40834__$1){
var statearr_41098_41225 = state_40961__$1;
(statearr_41098_41225[(1)] = (43));

} else {
var statearr_41099_41226 = state_40961__$1;
(statearr_41099_41226[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (80))){
var inst_40788 = (state_40961[(12)]);
var inst_40904 = (inst_40788 - (1));
var state_40961__$1 = state_40961;
var statearr_41100_41227 = state_40961__$1;
(statearr_41100_41227[(2)] = inst_40904);

(statearr_41100_41227[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (37))){
var inst_40788 = (state_40961[(12)]);
var inst_40803 = (state_40961[(27)]);
var inst_40822 = (inst_40788 - inst_40803);
var state_40961__$1 = state_40961;
var statearr_41101_41228 = state_40961__$1;
(statearr_41101_41228[(2)] = inst_40822);

(statearr_41101_41228[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (63))){
var inst_40882 = (state_40961[(7)]);
var inst_40857 = (state_40961[(9)]);
var inst_40881 = (state_40961[(2)]);
var inst_40882__$1 = (inst_40857 == null);
var state_40961__$1 = (function (){var statearr_41102 = state_40961;
(statearr_41102[(7)] = inst_40882__$1);

(statearr_41102[(20)] = inst_40881);

return statearr_41102;
})();
if(cljs.core.truth_(inst_40882__$1)){
var statearr_41103_41229 = state_40961__$1;
(statearr_41103_41229[(1)] = (70));

} else {
var statearr_41104_41230 = state_40961__$1;
(statearr_41104_41230[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (94))){
var inst_40952 = (state_40961[(2)]);
var state_40961__$1 = state_40961;
var statearr_41105_41231 = state_40961__$1;
(statearr_41105_41231[(2)] = inst_40952);

(statearr_41105_41231[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (8))){
var inst_40956 = (state_40961[(2)]);
var _ = (function (){var statearr_41106 = state_40961;
(statearr_41106[(4)] = cljs.core.rest((state_40961[(4)])));

return statearr_41106;
})();
var state_40961__$1 = state_40961;
var statearr_41107_41232 = state_40961__$1;
(statearr_41107_41232[(2)] = inst_40956);

(statearr_41107_41232[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (49))){
var inst_40833 = (state_40961[(18)]);
var inst_40788 = (state_40961[(12)]);
var inst_40844 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_40788,inst_40833);
var state_40961__$1 = state_40961;
var statearr_41108_41233 = state_40961__$1;
(statearr_41108_41233[(2)] = inst_40844);

(statearr_41108_41233[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40962 === (84))){
var inst_40928 = (state_40961[(2)]);
var inst_40929 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_40928,opts);
var state_40961__$1 = state_40961;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40961__$1,(85),inst_40929);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0 = (function (){
var statearr_41109 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41109[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__);

(statearr_41109[(1)] = (1));

return statearr_41109;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1 = (function (state_40961){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40961);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e41110){var ex__16398__auto__ = e41110;
var statearr_41111_41234 = state_40961;
(statearr_41111_41234[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40961[(4)]))){
var statearr_41112_41235 = state_40961;
(statearr_41112_41235[(1)] = cljs.core.first((state_40961[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__41236 = state_40961;
state_40961 = G__41236;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__ = function(state_40961){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1.call(this,state_40961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_41113 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_41113[(6)] = c__16469__auto__);

return statearr_41113;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__41239,opts){
var map__41240 = p__41239;
var map__41240__$1 = cljs.core.__destructure_map(map__41240);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41240__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41240__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41240__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41240__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41237_SHARP_){
return cljs.core.contains_QMARK_(p1__41237_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__41238_SHARP_){
return cljs.core.contains_QMARK_(p1__41238_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__41242 = cljs.core.first(orderBy);
var fexpr__41241 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__41241.cljs$core$IFn$_invoke$arity$1 ? fexpr__41241.cljs$core$IFn$_invoke$arity$1(G__41242) : fexpr__41241.call(null,G__41242));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4212__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__41243,p__41244){
var map__41245 = p__41243;
var map__41245__$1 = cljs.core.__destructure_map(map__41245);
var query_map = map__41245__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41245__$1,cljs.core.cst$kw$construct);
var map__41246 = p__41244;
var map__41246__$1 = cljs.core.__destructure_map(map__41246);
var where_result = map__41246__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41246__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41246__$1,cljs.core.cst$kw$tuples);
var vec__41247 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41247,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41247,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41247,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_41280){
var state_val_41281 = (state_41280[(1)]);
if((state_val_41281 === (7))){
var inst_41259 = (state_41280[(7)]);
var state_41280__$1 = state_41280;
var statearr_41282_41305 = state_41280__$1;
(statearr_41282_41305[(2)] = inst_41259);

(statearr_41282_41305[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (1))){
var state_41280__$1 = state_41280;
var statearr_41283_41306 = state_41280__$1;
(statearr_41283_41306[(2)] = null);

(statearr_41283_41306[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (4))){
var inst_41250 = (state_41280[(2)]);
var state_41280__$1 = state_41280;
var statearr_41284_41307 = state_41280__$1;
(statearr_41284_41307[(2)] = inst_41250);

(statearr_41284_41307[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (13))){
var inst_41269 = (state_41280[(2)]);
var inst_41270 = fluree.db.util.async.throw_err(inst_41269);
var state_41280__$1 = state_41280;
var statearr_41285_41308 = state_41280__$1;
(statearr_41285_41308[(2)] = inst_41270);

(statearr_41285_41308[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (6))){
var inst_41259 = (state_41280[(7)]);
var inst_41258 = (state_41280[(2)]);
var inst_41259__$1 = fluree.db.util.async.throw_err(inst_41258);
var inst_41260 = fluree.db.util.core.exception_QMARK_(inst_41259__$1);
var state_41280__$1 = (function (){var statearr_41286 = state_41280;
(statearr_41286[(7)] = inst_41259__$1);

return statearr_41286;
})();
if(inst_41260){
var statearr_41287_41309 = state_41280__$1;
(statearr_41287_41309[(1)] = (7));

} else {
var statearr_41288_41310 = state_41280__$1;
(statearr_41288_41310[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (3))){
var inst_41278 = (state_41280[(2)]);
var state_41280__$1 = state_41280;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41280__$1,inst_41278);
} else {
if((state_val_41281 === (12))){
var inst_41273 = (state_41280[(2)]);
var state_41280__$1 = state_41280;
var statearr_41289_41311 = state_41280__$1;
(statearr_41289_41311[(2)] = inst_41273);

(statearr_41289_41311[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (2))){
var _ = (function (){var statearr_41290 = state_41280;
(statearr_41290[(4)] = cljs.core.cons((5),(state_41280[(4)])));

return statearr_41290;
})();
var inst_41256 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_41280__$1 = state_41280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41280__$1,(6),inst_41256);
} else {
if((state_val_41281 === (11))){
var state_41280__$1 = state_41280;
var statearr_41292_41312 = state_41280__$1;
(statearr_41292_41312[(2)] = null);

(statearr_41292_41312[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (9))){
var inst_41275 = (state_41280[(2)]);
var _ = (function (){var statearr_41293 = state_41280;
(statearr_41293[(4)] = cljs.core.rest((state_41280[(4)])));

return statearr_41293;
})();
var state_41280__$1 = state_41280;
var statearr_41294_41313 = state_41280__$1;
(statearr_41294_41313[(2)] = inst_41275);

(statearr_41294_41313[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (5))){
var _ = (function (){var statearr_41295 = state_41280;
(statearr_41295[(4)] = cljs.core.rest((state_41280[(4)])));

return statearr_41295;
})();
var state_41280__$1 = state_41280;
var ex41291 = (state_41280__$1[(2)]);
var statearr_41296_41314 = state_41280__$1;
(statearr_41296_41314[(5)] = ex41291);


if((ex41291 instanceof Error)){
var statearr_41297_41315 = state_41280__$1;
(statearr_41297_41315[(1)] = (4));

(statearr_41297_41315[(5)] = null);

} else {
throw ex41291;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41281 === (10))){
var inst_41259 = (state_41280[(7)]);
var inst_41264 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_41259);
var inst_41265 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_41259);
var inst_41266 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_41264,inst_41265,query_map,opts);
var inst_41267 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_41259,inst_41266,opts);
var state_41280__$1 = state_41280;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41280__$1,(13),inst_41267);
} else {
if((state_val_41281 === (8))){
var state_41280__$1 = state_41280;
var statearr_41298_41316 = state_41280__$1;
(statearr_41298_41316[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0 = (function (){
var statearr_41300 = [null,null,null,null,null,null,null,null];
(statearr_41300[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__);

(statearr_41300[(1)] = (1));

return statearr_41300;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1 = (function (state_41280){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_41280);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e41301){var ex__16398__auto__ = e41301;
var statearr_41302_41317 = state_41280;
(statearr_41302_41317[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_41280[(4)]))){
var statearr_41303_41318 = state_41280;
(statearr_41303_41318[(1)] = cljs.core.first((state_41280[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__41319 = state_41280;
state_41280 = G__41319;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__ = function(state_41280){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1.call(this,state_41280);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_41304 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_41304[(6)] = c__16469__auto__);

return statearr_41304;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__41320 = query_map;
var map__41320__$1 = cljs.core.__destructure_map(map__41320);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41320__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__41321 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41321,cljs.core.cst$kw$limit,(1));
} else {
return G__41321;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_41676){
var state_val_41677 = (state_41676[(1)]);
if((state_val_41677 === (121))){
var inst_41637 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41678_41873 = state_41676__$1;
(statearr_41678_41873[(2)] = inst_41637);

(statearr_41678_41873[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (65))){
var inst_41514 = typeof from === 'string';
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41514)){
var statearr_41679_41874 = state_41676__$1;
(statearr_41679_41874[(1)] = (72));

} else {
var statearr_41680_41875 = state_41676__$1;
(statearr_41680_41875[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (70))){
var inst_41385 = (state_41676[(7)]);
var inst_41383 = (state_41676[(8)]);
var inst_41507 = (state_41676[(2)]);
var inst_41508 = fluree.db.util.async.throw_err(inst_41507);
var inst_41509 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41385,fuel,max_fuel,inst_41383,inst_41508);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(71),inst_41509);
} else {
if((state_val_41677 === (62))){
var inst_41487 = (state_41676[(9)]);
var state_41676__$1 = state_41676;
var statearr_41681_41876 = state_41676__$1;
(statearr_41681_41876[(2)] = inst_41487);

(statearr_41681_41876[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (74))){
var inst_41643 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41682_41877 = state_41676__$1;
(statearr_41682_41877[(2)] = inst_41643);

(statearr_41682_41877[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (110))){
var inst_41578 = (state_41676[(10)]);
var state_41676__$1 = state_41676;
var statearr_41683_41878 = state_41676__$1;
(statearr_41683_41878[(2)] = inst_41578);

(statearr_41683_41878[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (130))){
var inst_41663 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41684_41879 = state_41676__$1;
(statearr_41684_41879[(2)] = inst_41663);

(statearr_41684_41879[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (128))){
var inst_41654 = (state_41676[(11)]);
var inst_41659 = fluree.db.util.core.exception_QMARK_(inst_41654);
var inst_41660 = (!(inst_41659));
var state_41676__$1 = state_41676;
var statearr_41685_41880 = state_41676__$1;
(statearr_41685_41880[(2)] = inst_41660);

(statearr_41685_41880[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (7))){
var inst_41353 = (state_41676[(12)]);
var inst_41353__$1 = selectOne;
var state_41676__$1 = (function (){var statearr_41686 = state_41676;
(statearr_41686[(12)] = inst_41353__$1);

return statearr_41686;
})();
if(cljs.core.truth_(inst_41353__$1)){
var statearr_41687_41881 = state_41676__$1;
(statearr_41687_41881[(1)] = (9));

} else {
var statearr_41688_41882 = state_41676__$1;
(statearr_41688_41882[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (59))){
var inst_41373 = (state_41676[(13)]);
var inst_41385 = (state_41676[(7)]);
var inst_41465 = (state_41676[(14)]);
var inst_41383 = (state_41676[(8)]);
var inst_41479 = (state_41676[(2)]);
var inst_41480 = fluree.db.util.async.throw_err(inst_41479);
var inst_41481 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_41465,inst_41480);
var inst_41482 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_41385,fuel,max_fuel,inst_41383,inst_41481,inst_41373);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(60),inst_41482);
} else {
if((state_val_41677 === (86))){
var inst_41373 = (state_41676[(13)]);
var inst_41385 = (state_41676[(7)]);
var inst_41375 = (state_41676[(15)]);
var inst_41383 = (state_41676[(8)]);
var inst_41547 = (state_41676[(2)]);
var inst_41548 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41385,fuel,max_fuel,inst_41383,inst_41547,inst_41373,inst_41375);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(87),inst_41548);
} else {
if((state_val_41677 === (20))){
var inst_41417 = (state_41676[(2)]);
var inst_41418 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41417,(0),null);
var inst_41419 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41417,(1),null);
var inst_41420 = typeof where === 'string';
var state_41676__$1 = (function (){var statearr_41689 = state_41676;
(statearr_41689[(16)] = inst_41418);

(statearr_41689[(17)] = inst_41419);

return statearr_41689;
})();
if(cljs.core.truth_(inst_41420)){
var statearr_41690_41883 = state_41676__$1;
(statearr_41690_41883[(1)] = (30));

} else {
var statearr_41691_41884 = state_41676__$1;
(statearr_41691_41884[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (72))){
var inst_41372 = (state_41676[(18)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41372)){
var statearr_41692_41885 = state_41676__$1;
(statearr_41692_41885[(1)] = (75));

} else {
var statearr_41693_41886 = state_41676__$1;
(statearr_41693_41886[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (58))){
var inst_41473 = (state_41676[(2)]);
var inst_41474 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41475 = [from];
var inst_41476 = (new cljs.core.PersistentVector(null,1,(5),inst_41474,inst_41475,null));
var inst_41477 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41476,inst_41473);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(59),inst_41477);
} else {
if((state_val_41677 === (60))){
var inst_41484 = (state_41676[(2)]);
var inst_41485 = fluree.db.util.async.throw_err(inst_41484);
var state_41676__$1 = state_41676;
var statearr_41694_41887 = state_41676__$1;
(statearr_41694_41887[(2)] = inst_41485);

(statearr_41694_41887[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (27))){
var inst_41402 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41403 = [null,null];
var inst_41404 = (new cljs.core.PersistentVector(null,2,(5),inst_41402,inst_41403,null));
var state_41676__$1 = state_41676;
var statearr_41695_41888 = state_41676__$1;
(statearr_41695_41888[(2)] = inst_41404);

(statearr_41695_41888[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (1))){
var state_41676__$1 = state_41676;
var statearr_41696_41889 = state_41676__$1;
(statearr_41696_41889[(2)] = null);

(statearr_41696_41889[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (69))){
var inst_41504 = (state_41676[(2)]);
var inst_41505 = fluree.db.query.range._block_or_tx_collection(db,inst_41504);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(70),inst_41505);
} else {
if((state_val_41677 === (101))){
var inst_41610 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41697_41890 = state_41676__$1;
(statearr_41697_41890[(2)] = inst_41610);

(statearr_41697_41890[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (24))){
var inst_41372 = (state_41676[(18)]);
var inst_41397 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41398 = [inst_41372,"ASC"];
var inst_41399 = (new cljs.core.PersistentVector(null,2,(5),inst_41397,inst_41398,null));
var state_41676__$1 = state_41676;
var statearr_41698_41891 = state_41676__$1;
(statearr_41698_41891[(2)] = inst_41399);

(statearr_41698_41891[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (102))){
var inst_41584 = (state_41676[(19)]);
var state_41676__$1 = state_41676;
var statearr_41699_41892 = state_41676__$1;
(statearr_41699_41892[(2)] = inst_41584);

(statearr_41699_41892[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (55))){
var inst_41372 = (state_41676[(18)]);
var inst_41465 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41700 = state_41676;
(statearr_41700[(14)] = inst_41465);

return statearr_41700;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41701_41893 = state_41676__$1;
(statearr_41701_41893[(1)] = (56));

} else {
var statearr_41702_41894 = state_41676__$1;
(statearr_41702_41894[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (85))){
var inst_41539 = (state_41676[(20)]);
var inst_41543 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41544 = [inst_41539];
var inst_41545 = (new cljs.core.PersistentVector(null,1,(5),inst_41543,inst_41544,null));
var state_41676__$1 = state_41676;
var statearr_41703_41895 = state_41676__$1;
(statearr_41703_41895[(2)] = inst_41545);

(statearr_41703_41895[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (39))){
var inst_41373 = (state_41676[(13)]);
var state_41676__$1 = state_41676;
var statearr_41704_41896 = state_41676__$1;
(statearr_41704_41896[(2)] = inst_41373);

(statearr_41704_41896[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (88))){
var inst_41553 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_41676__$1 = state_41676;
var statearr_41705_41897 = state_41676__$1;
(statearr_41705_41897[(2)] = inst_41553);

(statearr_41705_41897[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (46))){
var inst_41450 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41450)){
var statearr_41706_41898 = state_41676__$1;
(statearr_41706_41898[(1)] = (47));

} else {
var statearr_41707_41899 = state_41676__$1;
(statearr_41707_41899[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (4))){
var inst_41340 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41708_41900 = state_41676__$1;
(statearr_41708_41900[(2)] = inst_41340);

(statearr_41708_41900[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (77))){
var inst_41523 = (state_41676[(2)]);
var inst_41524 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_41523);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(78),inst_41524);
} else {
if((state_val_41677 === (106))){
var state_41676__$1 = state_41676;
var statearr_41709_41901 = state_41676__$1;
(statearr_41709_41901[(2)] = null);

(statearr_41709_41901[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (119))){
var inst_41629 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_41630 = ["Invalid 'from' in query:",inst_41629].join('');
var inst_41631 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41632 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41633 = cljs.core.PersistentHashMap.fromArrays(inst_41631,inst_41632);
var inst_41634 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41630,inst_41633);
var state_41676__$1 = state_41676;
var statearr_41710_41902 = state_41676__$1;
(statearr_41710_41902[(2)] = inst_41634);

(statearr_41710_41902[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (95))){
var state_41676__$1 = state_41676;
var statearr_41711_41903 = state_41676__$1;
(statearr_41711_41903[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (54))){
var inst_41459 = (state_41676[(21)]);
var state_41676__$1 = state_41676;
var statearr_41713_41904 = state_41676__$1;
(statearr_41713_41904[(2)] = inst_41459);

(statearr_41713_41904[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (92))){
var inst_41558 = (state_41676[(22)]);
var state_41676__$1 = state_41676;
var statearr_41714_41905 = state_41676__$1;
(statearr_41714_41905[(2)] = inst_41558);

(statearr_41714_41905[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (104))){
var inst_41602 = (state_41676[(23)]);
var inst_41602__$1 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41715 = state_41676;
(statearr_41715[(23)] = inst_41602__$1);

return statearr_41715;
})();
if(cljs.core.truth_(inst_41602__$1)){
var statearr_41716_41906 = state_41676__$1;
(statearr_41716_41906[(1)] = (109));

} else {
var statearr_41717_41907 = state_41676__$1;
(statearr_41717_41907[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (15))){
var inst_41374 = (state_41676[(24)]);
var inst_41376 = (state_41676[(25)]);
var inst_41380 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41376,cljs.core.cst$kw$componentFollow_QMARK_,inst_41374);
var state_41676__$1 = state_41676;
var statearr_41718_41908 = state_41676__$1;
(statearr_41718_41908[(2)] = inst_41380);

(statearr_41718_41908[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (48))){
var inst_41487 = (state_41676[(9)]);
var inst_41487__$1 = typeof from === 'string';
var state_41676__$1 = (function (){var statearr_41719 = state_41676;
(statearr_41719[(9)] = inst_41487__$1);

return statearr_41719;
})();
if(cljs.core.truth_(inst_41487__$1)){
var statearr_41720_41909 = state_41676__$1;
(statearr_41720_41909[(1)] = (61));

} else {
var statearr_41721_41910 = state_41676__$1;
(statearr_41721_41910[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (50))){
var inst_41453 = (state_41676[(26)]);
var inst_41455 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_41456 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41453,inst_41455);
var state_41676__$1 = state_41676;
var statearr_41722_41911 = state_41676__$1;
(statearr_41722_41911[(2)] = inst_41456);

(statearr_41722_41911[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (116))){
var state_41676__$1 = state_41676;
var statearr_41723_41912 = state_41676__$1;
(statearr_41723_41912[(2)] = null);

(statearr_41723_41912[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (75))){
var inst_41517 = cljs.core.PersistentHashMap.EMPTY;
var state_41676__$1 = state_41676;
var statearr_41724_41913 = state_41676__$1;
(statearr_41724_41913[(2)] = inst_41517);

(statearr_41724_41913[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (99))){
var inst_41578 = (state_41676[(10)]);
var state_41676__$1 = state_41676;
var statearr_41725_41914 = state_41676__$1;
(statearr_41725_41914[(2)] = inst_41578);

(statearr_41725_41914[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (21))){
var inst_41372 = (state_41676[(18)]);
var inst_41389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41390 = cljs.core.second(inst_41372);
var inst_41391 = cljs.core.first(inst_41372);
var inst_41392 = [inst_41390,inst_41391];
var inst_41393 = (new cljs.core.PersistentVector(null,2,(5),inst_41389,inst_41392,null));
var state_41676__$1 = state_41676;
var statearr_41726_41915 = state_41676__$1;
(statearr_41726_41915[(2)] = inst_41393);

(statearr_41726_41915[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (31))){
var inst_41444 = (state_41676[(27)]);
var inst_41444__$1 = typeof from === 'string';
var state_41676__$1 = (function (){var statearr_41727 = state_41676;
(statearr_41727[(27)] = inst_41444__$1);

return statearr_41727;
})();
if(cljs.core.truth_(inst_41444__$1)){
var statearr_41728_41916 = state_41676__$1;
(statearr_41728_41916[(1)] = (44));

} else {
var statearr_41729_41917 = state_41676__$1;
(statearr_41729_41917[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (113))){
var state_41676__$1 = state_41676;
var statearr_41730_41918 = state_41676__$1;
(statearr_41730_41918[(2)] = null);

(statearr_41730_41918[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (32))){
var inst_41418 = (state_41676[(16)]);
var inst_41649 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41731 = state_41676;
(statearr_41731[(28)] = inst_41649);

return statearr_41731;
})();
if(cljs.core.truth_(inst_41418)){
var statearr_41732_41919 = state_41676__$1;
(statearr_41732_41919[(1)] = (122));

} else {
var statearr_41733_41920 = state_41676__$1;
(statearr_41733_41920[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (40))){
var inst_41372 = (state_41676[(18)]);
var inst_41434 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41734 = state_41676;
(statearr_41734[(29)] = inst_41434);

return statearr_41734;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41735_41921 = state_41676__$1;
(statearr_41735_41921[(1)] = (41));

} else {
var statearr_41736_41922 = state_41676__$1;
(statearr_41736_41922[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (129))){
var inst_41657 = (state_41676[(30)]);
var state_41676__$1 = state_41676;
var statearr_41737_41923 = state_41676__$1;
(statearr_41737_41923[(2)] = inst_41657);

(statearr_41737_41923[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (91))){
var inst_41560 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_41676__$1 = state_41676;
var statearr_41738_41924 = state_41676__$1;
(statearr_41738_41924[(2)] = inst_41560);

(statearr_41738_41924[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (117))){
var inst_41375 = (state_41676[(15)]);
var state_41676__$1 = state_41676;
var statearr_41739_41925 = state_41676__$1;
(statearr_41739_41925[(2)] = inst_41375);

(statearr_41739_41925[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (108))){
var inst_41599 = (state_41676[(2)]);
var inst_41600 = fluree.db.util.async.throw_err(inst_41599);
var state_41676__$1 = state_41676;
var statearr_41740_41926 = state_41676__$1;
(statearr_41740_41926[(2)] = inst_41600);

(statearr_41740_41926[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (56))){
var inst_41467 = cljs.core.PersistentHashMap.EMPTY;
var state_41676__$1 = state_41676;
var statearr_41741_41927 = state_41676__$1;
(statearr_41741_41927[(2)] = inst_41467);

(statearr_41741_41927[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (33))){
var state_41676__$1 = state_41676;
var statearr_41742_41928 = state_41676__$1;
(statearr_41742_41928[(2)] = from);

(statearr_41742_41928[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (13))){
var inst_41359 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41360 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41361 = cljs.core.PersistentHashMap.fromArrays(inst_41359,inst_41360);
var inst_41362 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_41361);
var inst_41363 = (function(){throw inst_41362})();
var state_41676__$1 = state_41676;
var statearr_41743_41929 = state_41676__$1;
(statearr_41743_41929[(2)] = inst_41363);

(statearr_41743_41929[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (22))){
var inst_41372 = (state_41676[(18)]);
var inst_41395 = typeof inst_41372 === 'string';
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41395)){
var statearr_41744_41930 = state_41676__$1;
(statearr_41744_41930[(1)] = (24));

} else {
var statearr_41745_41931 = state_41676__$1;
(statearr_41745_41931[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (90))){
var inst_41551 = (state_41676[(31)]);
var inst_41556 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41746 = state_41676;
(statearr_41746[(32)] = inst_41556);

return statearr_41746;
})();
var statearr_41747_41932 = state_41676__$1;
(statearr_41747_41932[(2)] = inst_41551);

(statearr_41747_41932[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (109))){
var inst_41602 = (state_41676[(23)]);
var inst_41578 = (state_41676[(10)]);
var inst_41604 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41578,inst_41602);
var state_41676__$1 = state_41676;
var statearr_41748_41933 = state_41676__$1;
(statearr_41748_41933[(2)] = inst_41604);

(statearr_41748_41933[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (36))){
var inst_41372 = (state_41676[(18)]);
var inst_41429 = (state_41676[(2)]);
var inst_41430 = fluree.db.util.async.throw_err(inst_41429);
var state_41676__$1 = (function (){var statearr_41749 = state_41676;
(statearr_41749[(33)] = inst_41430);

return statearr_41749;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41750_41934 = state_41676__$1;
(statearr_41750_41934[(1)] = (38));

} else {
var statearr_41751_41935 = state_41676__$1;
(statearr_41751_41935[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (41))){
var state_41676__$1 = state_41676;
var statearr_41752_41936 = state_41676__$1;
(statearr_41752_41936[(2)] = null);

(statearr_41752_41936[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (118))){
var inst_41614 = (state_41676[(34)]);
var inst_41385 = (state_41676[(7)]);
var inst_41383 = (state_41676[(8)]);
var inst_41618 = (state_41676[(35)]);
var inst_41622 = (state_41676[(2)]);
var inst_41623 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41385,fuel,max_fuel,inst_41383,inst_41614,inst_41618,inst_41622);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(112),inst_41623);
} else {
if((state_val_41677 === (89))){
var state_41676__$1 = state_41676;
var statearr_41753_41937 = state_41676__$1;
(statearr_41753_41937[(2)] = null);

(statearr_41753_41937[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (100))){
var inst_41584 = (state_41676[(19)]);
var inst_41589 = cljs.core.int_QMARK_(inst_41584);
var state_41676__$1 = state_41676;
if(inst_41589){
var statearr_41754_41938 = state_41676__$1;
(statearr_41754_41938[(1)] = (102));

} else {
var statearr_41755_41939 = state_41676__$1;
(statearr_41755_41939[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (131))){
var inst_41654 = (state_41676[(11)]);
var inst_41668 = cljs.core.first(inst_41654);
var state_41676__$1 = state_41676;
var statearr_41756_41940 = state_41676__$1;
(statearr_41756_41940[(2)] = inst_41668);

(statearr_41756_41940[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (122))){
var inst_41418 = (state_41676[(16)]);
var inst_41649 = (state_41676[(28)]);
var inst_41373 = (state_41676[(13)]);
var inst_41419 = (state_41676[(17)]);
var inst_41375 = (state_41676[(15)]);
var inst_41651 = fluree.db.query.fql.sort_offset_and_limit_res(inst_41418,inst_41419,inst_41375,inst_41373,inst_41649);
var state_41676__$1 = state_41676;
var statearr_41757_41941 = state_41676__$1;
(statearr_41757_41941[(2)] = inst_41651);

(statearr_41757_41941[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (43))){
var inst_41434 = (state_41676[(29)]);
var inst_41385 = (state_41676[(7)]);
var inst_41430 = (state_41676[(33)]);
var inst_41383 = (state_41676[(8)]);
var inst_41438 = (state_41676[(2)]);
var inst_41439 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41385,fuel,max_fuel,inst_41383,inst_41430,inst_41434,inst_41438);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(37),inst_41439);
} else {
if((state_val_41677 === (61))){
var inst_41489 = ["_tx",null,"_block",null];
var inst_41490 = (new cljs.core.PersistentArrayMap(null,2,inst_41489,null));
var inst_41491 = (new cljs.core.PersistentHashSet(null,inst_41490,null));
var inst_41492 = (inst_41491.cljs$core$IFn$_invoke$arity$1 ? inst_41491.cljs$core$IFn$_invoke$arity$1(from) : inst_41491.call(null,from));
var state_41676__$1 = state_41676;
var statearr_41758_41942 = state_41676__$1;
(statearr_41758_41942[(2)] = inst_41492);

(statearr_41758_41942[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (29))){
var inst_41407 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41759_41943 = state_41676__$1;
(statearr_41759_41943[(2)] = inst_41407);

(statearr_41759_41943[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (44))){
var inst_41446 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_41447 = clojure.string.includes_QMARK_(inst_41446,"/");
var state_41676__$1 = state_41676;
var statearr_41760_41944 = state_41676__$1;
(statearr_41760_41944[(2)] = inst_41447);

(statearr_41760_41944[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (93))){
var inst_41563 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41563)){
var statearr_41761_41945 = state_41676__$1;
(statearr_41761_41945[(1)] = (94));

} else {
var statearr_41762_41946 = state_41676__$1;
(statearr_41762_41946[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (6))){
var inst_41350 = (state_41676[(36)]);
var state_41676__$1 = state_41676;
var statearr_41763_41947 = state_41676__$1;
(statearr_41763_41947[(2)] = inst_41350);

(statearr_41763_41947[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (111))){
var inst_41585 = (state_41676[(37)]);
var inst_41607 = (state_41676[(2)]);
var inst_41577 = inst_41585;
var inst_41578 = inst_41607;
var state_41676__$1 = (function (){var statearr_41764 = state_41676;
(statearr_41764[(10)] = inst_41578);

(statearr_41764[(38)] = inst_41577);

return statearr_41764;
})();
var statearr_41765_41948 = state_41676__$1;
(statearr_41765_41948[(2)] = null);

(statearr_41765_41948[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (28))){
var state_41676__$1 = state_41676;
var statearr_41766_41949 = state_41676__$1;
(statearr_41766_41949[(2)] = null);

(statearr_41766_41949[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (64))){
var inst_41372 = (state_41676[(18)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41372)){
var statearr_41767_41950 = state_41676__$1;
(statearr_41767_41950[(1)] = (67));

} else {
var statearr_41768_41951 = state_41676__$1;
(statearr_41768_41951[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (103))){
var state_41676__$1 = state_41676;
if(cljs.core.truth_(fuel)){
var statearr_41769_41952 = state_41676__$1;
(statearr_41769_41952[(1)] = (105));

} else {
var statearr_41770_41953 = state_41676__$1;
(statearr_41770_41953[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (51))){
var inst_41453 = (state_41676[(26)]);
var state_41676__$1 = state_41676;
var statearr_41771_41954 = state_41676__$1;
(statearr_41771_41954[(2)] = inst_41453);

(statearr_41771_41954[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (25))){
var state_41676__$1 = state_41676;
var statearr_41772_41955 = state_41676__$1;
(statearr_41772_41955[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (34))){
var state_41676__$1 = state_41676;
var statearr_41774_41956 = state_41676__$1;
(statearr_41774_41956[(2)] = null);

(statearr_41774_41956[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (125))){
var inst_41654 = (state_41676[(11)]);
var inst_41657 = (state_41676[(30)]);
var inst_41657__$1 = cljs.core.coll_QMARK_(inst_41654);
var state_41676__$1 = (function (){var statearr_41775 = state_41676;
(statearr_41775[(30)] = inst_41657__$1);

return statearr_41775;
})();
if(inst_41657__$1){
var statearr_41776_41957 = state_41676__$1;
(statearr_41776_41957[(1)] = (128));

} else {
var statearr_41777_41958 = state_41676__$1;
(statearr_41777_41958[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (17))){
var inst_41372 = (state_41676[(18)]);
var inst_41383 = (state_41676[(2)]);
var inst_41384 = cljs.core.PersistentHashMap.EMPTY;
var inst_41385 = cljs.core.volatile_BANG_(inst_41384);
var state_41676__$1 = (function (){var statearr_41778 = state_41676;
(statearr_41778[(7)] = inst_41385);

(statearr_41778[(8)] = inst_41383);

return statearr_41778;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41779_41959 = state_41676__$1;
(statearr_41779_41959[(1)] = (18));

} else {
var statearr_41780_41960 = state_41676__$1;
(statearr_41780_41960[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (3))){
var inst_41674 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41676__$1,inst_41674);
} else {
if((state_val_41677 === (12))){
var inst_41356 = (state_41676[(39)]);
var state_41676__$1 = state_41676;
var statearr_41781_41961 = state_41676__$1;
(statearr_41781_41961[(2)] = inst_41356);

(statearr_41781_41961[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (2))){
var inst_41350 = (state_41676[(36)]);
var _ = (function (){var statearr_41782 = state_41676;
(statearr_41782[(4)] = cljs.core.cons((5),(state_41676[(4)])));

return statearr_41782;
})();
var inst_41350__$1 = select;
var state_41676__$1 = (function (){var statearr_41783 = state_41676;
(statearr_41783[(36)] = inst_41350__$1);

return statearr_41783;
})();
if(cljs.core.truth_(inst_41350__$1)){
var statearr_41784_41962 = state_41676__$1;
(statearr_41784_41962[(1)] = (6));

} else {
var statearr_41785_41963 = state_41676__$1;
(statearr_41785_41963[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (66))){
var inst_41645 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41786_41964 = state_41676__$1;
(statearr_41786_41964[(2)] = inst_41645);

(statearr_41786_41964[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (107))){
var inst_41584 = (state_41676[(19)]);
var inst_41596 = (state_41676[(2)]);
var inst_41597 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_41584,false);
var state_41676__$1 = (function (){var statearr_41787 = state_41676;
(statearr_41787[(40)] = inst_41596);

return statearr_41787;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(108),inst_41597);
} else {
if((state_val_41677 === (23))){
var inst_41411 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41788_41965 = state_41676__$1;
(statearr_41788_41965[(2)] = inst_41411);

(statearr_41788_41965[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (47))){
var inst_41453 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_41676__$1 = (function (){var statearr_41789 = state_41676;
(statearr_41789[(26)] = inst_41453);

return statearr_41789;
})();
if(cljs.core.truth_(fuel)){
var statearr_41790_41966 = state_41676__$1;
(statearr_41790_41966[(1)] = (50));

} else {
var statearr_41791_41967 = state_41676__$1;
(statearr_41791_41967[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (35))){
var inst_41426 = (state_41676[(2)]);
var inst_41427 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$3(db,where,inst_41426);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(36),inst_41427);
} else {
if((state_val_41677 === (127))){
var inst_41666 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41666)){
var statearr_41792_41968 = state_41676__$1;
(statearr_41792_41968[(1)] = (131));

} else {
var statearr_41793_41969 = state_41676__$1;
(statearr_41793_41969[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (82))){
var inst_41641 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41794_41970 = state_41676__$1;
(statearr_41794_41970[(2)] = inst_41641);

(statearr_41794_41970[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (76))){
var inst_41373 = (state_41676[(13)]);
var inst_41375 = (state_41676[(15)]);
var inst_41519 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41520 = [inst_41373,inst_41375];
var inst_41521 = cljs.core.PersistentHashMap.fromArrays(inst_41519,inst_41520);
var state_41676__$1 = state_41676;
var statearr_41795_41971 = state_41676__$1;
(statearr_41795_41971[(2)] = inst_41521);

(statearr_41795_41971[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (97))){
var inst_41584 = (state_41676[(19)]);
var inst_41577 = (state_41676[(38)]);
var inst_41583 = cljs.core.seq(inst_41577);
var inst_41584__$1 = cljs.core.first(inst_41583);
var inst_41585 = cljs.core.next(inst_41583);
var inst_41586 = cljs.core.not(inst_41584__$1);
var state_41676__$1 = (function (){var statearr_41796 = state_41676;
(statearr_41796[(37)] = inst_41585);

(statearr_41796[(19)] = inst_41584__$1);

return statearr_41796;
})();
if(inst_41586){
var statearr_41797_41972 = state_41676__$1;
(statearr_41797_41972[(1)] = (99));

} else {
var statearr_41798_41973 = state_41676__$1;
(statearr_41798_41973[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (19))){
var inst_41413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41414 = [null,null];
var inst_41415 = (new cljs.core.PersistentVector(null,2,(5),inst_41413,inst_41414,null));
var state_41676__$1 = state_41676;
var statearr_41799_41974 = state_41676__$1;
(statearr_41799_41974[(2)] = inst_41415);

(statearr_41799_41974[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (57))){
var inst_41373 = (state_41676[(13)]);
var inst_41375 = (state_41676[(15)]);
var inst_41469 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41470 = [inst_41373,inst_41375];
var inst_41471 = cljs.core.PersistentHashMap.fromArrays(inst_41469,inst_41470);
var state_41676__$1 = state_41676;
var statearr_41800_41975 = state_41676__$1;
(statearr_41800_41975[(2)] = inst_41471);

(statearr_41800_41975[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (68))){
var inst_41373 = (state_41676[(13)]);
var inst_41375 = (state_41676[(15)]);
var inst_41500 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41501 = [inst_41373,inst_41375];
var inst_41502 = cljs.core.PersistentHashMap.fromArrays(inst_41500,inst_41501);
var state_41676__$1 = state_41676;
var statearr_41801_41976 = state_41676__$1;
(statearr_41801_41976[(2)] = inst_41502);

(statearr_41801_41976[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (11))){
var inst_41367 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41802_41977 = state_41676__$1;
(statearr_41802_41977[(2)] = inst_41367);

(statearr_41802_41977[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (115))){
var inst_41372 = (state_41676[(18)]);
var inst_41618 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41804 = state_41676;
(statearr_41804[(35)] = inst_41618);

return statearr_41804;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41805_41978 = state_41676__$1;
(statearr_41805_41978[(1)] = (116));

} else {
var statearr_41806_41979 = state_41676__$1;
(statearr_41806_41979[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (9))){
var inst_41353 = (state_41676[(12)]);
var state_41676__$1 = state_41676;
var statearr_41807_41980 = state_41676__$1;
(statearr_41807_41980[(2)] = inst_41353);

(statearr_41807_41980[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (5))){
var _ = (function (){var statearr_41808 = state_41676;
(statearr_41808[(4)] = cljs.core.rest((state_41676[(4)])));

return statearr_41808;
})();
var state_41676__$1 = state_41676;
var ex41803 = (state_41676__$1[(2)]);
var statearr_41809_41981 = state_41676__$1;
(statearr_41809_41981[(5)] = ex41803);


if((ex41803 instanceof Error)){
var statearr_41810_41982 = state_41676__$1;
(statearr_41810_41982[(1)] = (4));

(statearr_41810_41982[(5)] = null);

} else {
throw ex41803;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (112))){
var inst_41625 = (state_41676[(2)]);
var inst_41626 = fluree.db.util.async.throw_err(inst_41625);
var state_41676__$1 = state_41676;
var statearr_41811_41983 = state_41676__$1;
(statearr_41811_41983[(2)] = inst_41626);

(statearr_41811_41983[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (83))){
var inst_41539 = (state_41676[(20)]);
var inst_41538 = (state_41676[(2)]);
var inst_41539__$1 = fluree.db.util.async.throw_err(inst_41538);
var inst_41540 = (inst_41539__$1 == null);
var state_41676__$1 = (function (){var statearr_41812 = state_41676;
(statearr_41812[(20)] = inst_41539__$1);

return statearr_41812;
})();
if(cljs.core.truth_(inst_41540)){
var statearr_41813_41984 = state_41676__$1;
(statearr_41813_41984[(1)] = (84));

} else {
var statearr_41814_41985 = state_41676__$1;
(statearr_41814_41985[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (14))){
var inst_41365 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41815_41986 = state_41676__$1;
(statearr_41815_41986[(2)] = inst_41365);

(statearr_41815_41986[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (45))){
var inst_41444 = (state_41676[(27)]);
var state_41676__$1 = state_41676;
var statearr_41816_41987 = state_41676__$1;
(statearr_41816_41987[(2)] = inst_41444);

(statearr_41816_41987[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (53))){
var inst_41459 = (state_41676[(21)]);
var inst_41461 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_41462 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41459,inst_41461);
var state_41676__$1 = state_41676;
var statearr_41817_41988 = state_41676__$1;
(statearr_41817_41988[(2)] = inst_41462);

(statearr_41817_41988[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (78))){
var inst_41385 = (state_41676[(7)]);
var inst_41383 = (state_41676[(8)]);
var inst_41526 = (state_41676[(2)]);
var inst_41527 = fluree.db.util.async.throw_err(inst_41526);
var inst_41528 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41385,fuel,max_fuel,inst_41383,inst_41527);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(79),inst_41528);
} else {
if((state_val_41677 === (132))){
var inst_41654 = (state_41676[(11)]);
var state_41676__$1 = state_41676;
var statearr_41818_41989 = state_41676__$1;
(statearr_41818_41989[(2)] = inst_41654);

(statearr_41818_41989[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (26))){
var inst_41409 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41819_41990 = state_41676__$1;
(statearr_41819_41990[(2)] = inst_41409);

(statearr_41819_41990[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (123))){
var inst_41649 = (state_41676[(28)]);
var state_41676__$1 = state_41676;
var statearr_41820_41991 = state_41676__$1;
(statearr_41820_41991[(2)] = inst_41649);

(statearr_41820_41991[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (16))){
var inst_41376 = (state_41676[(25)]);
var state_41676__$1 = state_41676;
var statearr_41821_41992 = state_41676__$1;
(statearr_41821_41992[(2)] = inst_41376);

(statearr_41821_41992[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (133))){
var inst_41671 = (state_41676[(2)]);
var _ = (function (){var statearr_41822 = state_41676;
(statearr_41822[(4)] = cljs.core.rest((state_41676[(4)])));

return statearr_41822;
})();
var state_41676__$1 = state_41676;
var statearr_41823_41993 = state_41676__$1;
(statearr_41823_41993[(2)] = inst_41671);

(statearr_41823_41993[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (81))){
var inst_41558 = (state_41676[(22)]);
var inst_41558__$1 = cljs.core.sequential_QMARK_(from);
var state_41676__$1 = (function (){var statearr_41824 = state_41676;
(statearr_41824[(22)] = inst_41558__$1);

return statearr_41824;
})();
if(inst_41558__$1){
var statearr_41825_41994 = state_41676__$1;
(statearr_41825_41994[(1)] = (91));

} else {
var statearr_41826_41995 = state_41676__$1;
(statearr_41826_41995[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (120))){
var state_41676__$1 = state_41676;
var statearr_41827_41996 = state_41676__$1;
(statearr_41827_41996[(2)] = null);

(statearr_41827_41996[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (79))){
var inst_41530 = (state_41676[(2)]);
var inst_41531 = fluree.db.util.async.throw_err(inst_41530);
var state_41676__$1 = state_41676;
var statearr_41828_41997 = state_41676__$1;
(statearr_41828_41997[(2)] = inst_41531);

(statearr_41828_41997[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (38))){
var state_41676__$1 = state_41676;
var statearr_41829_41998 = state_41676__$1;
(statearr_41829_41998[(2)] = null);

(statearr_41829_41998[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (126))){
var inst_41655 = (state_41676[(41)]);
var state_41676__$1 = state_41676;
var statearr_41830_41999 = state_41676__$1;
(statearr_41830_41999[(2)] = inst_41655);

(statearr_41830_41999[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (98))){
var inst_41372 = (state_41676[(18)]);
var inst_41612 = (state_41676[(2)]);
var inst_41613 = cljs.core.PersistentVector.EMPTY;
var inst_41614 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41613,inst_41612);
var state_41676__$1 = (function (){var statearr_41831 = state_41676;
(statearr_41831[(34)] = inst_41614);

return statearr_41831;
})();
if(cljs.core.truth_(inst_41372)){
var statearr_41832_42000 = state_41676__$1;
(statearr_41832_42000[(1)] = (113));

} else {
var statearr_41833_42001 = state_41676__$1;
(statearr_41833_42001[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (124))){
var inst_41655 = (state_41676[(41)]);
var inst_41654 = (state_41676[(2)]);
var inst_41655__$1 = selectOne;
var state_41676__$1 = (function (){var statearr_41834 = state_41676;
(statearr_41834[(41)] = inst_41655__$1);

(statearr_41834[(11)] = inst_41654);

return statearr_41834;
})();
if(cljs.core.truth_(inst_41655__$1)){
var statearr_41835_42002 = state_41676__$1;
(statearr_41835_42002[(1)] = (125));

} else {
var statearr_41836_42003 = state_41676__$1;
(statearr_41836_42003[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (87))){
var inst_41550 = (state_41676[(2)]);
var inst_41551 = fluree.db.util.async.throw_err(inst_41550);
var state_41676__$1 = (function (){var statearr_41837 = state_41676;
(statearr_41837[(31)] = inst_41551);

return statearr_41837;
})();
if(cljs.core.truth_(fuel)){
var statearr_41838_42004 = state_41676__$1;
(statearr_41838_42004[(1)] = (88));

} else {
var statearr_41839_42005 = state_41676__$1;
(statearr_41839_42005[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (30))){
var inst_41422 = typeof from === 'string';
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41422)){
var statearr_41840_42006 = state_41676__$1;
(statearr_41840_42006[(1)] = (33));

} else {
var statearr_41841_42007 = state_41676__$1;
(statearr_41841_42007[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (73))){
var inst_41533 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_41676__$1 = state_41676;
if(inst_41533){
var statearr_41842_42008 = state_41676__$1;
(statearr_41842_42008[(1)] = (80));

} else {
var statearr_41843_42009 = state_41676__$1;
(statearr_41843_42009[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (96))){
var inst_41639 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41844_42010 = state_41676__$1;
(statearr_41844_42010[(2)] = inst_41639);

(statearr_41844_42010[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (10))){
var inst_41356 = (state_41676[(39)]);
var inst_41356__$1 = selectDistinct;
var state_41676__$1 = (function (){var statearr_41845 = state_41676;
(statearr_41845[(39)] = inst_41356__$1);

return statearr_41845;
})();
if(cljs.core.truth_(inst_41356__$1)){
var statearr_41846_42011 = state_41676__$1;
(statearr_41846_42011[(1)] = (12));

} else {
var statearr_41847_42012 = state_41676__$1;
(statearr_41847_42012[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (18))){
var inst_41372 = (state_41676[(18)]);
var inst_41387 = cljs.core.vector_QMARK_(inst_41372);
var state_41676__$1 = state_41676;
if(inst_41387){
var statearr_41848_42013 = state_41676__$1;
(statearr_41848_42013[(1)] = (21));

} else {
var statearr_41849_42014 = state_41676__$1;
(statearr_41849_42014[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (105))){
var inst_41593 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_41676__$1 = state_41676;
var statearr_41850_42015 = state_41676__$1;
(statearr_41850_42015[(2)] = inst_41593);

(statearr_41850_42015[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (52))){
var inst_41459 = (state_41676[(2)]);
var state_41676__$1 = (function (){var statearr_41851 = state_41676;
(statearr_41851[(21)] = inst_41459);

return statearr_41851;
})();
var statearr_41852_42016 = state_41676__$1;
(statearr_41852_42016[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (114))){
var inst_41373 = (state_41676[(13)]);
var state_41676__$1 = state_41676;
var statearr_41854_42017 = state_41676__$1;
(statearr_41854_42017[(2)] = inst_41373);

(statearr_41854_42017[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (67))){
var inst_41498 = cljs.core.PersistentHashMap.EMPTY;
var state_41676__$1 = state_41676;
var statearr_41855_42018 = state_41676__$1;
(statearr_41855_42018[(2)] = inst_41498);

(statearr_41855_42018[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (71))){
var inst_41511 = (state_41676[(2)]);
var inst_41512 = fluree.db.util.async.throw_err(inst_41511);
var state_41676__$1 = state_41676;
var statearr_41856_42019 = state_41676__$1;
(statearr_41856_42019[(2)] = inst_41512);

(statearr_41856_42019[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (42))){
var inst_41375 = (state_41676[(15)]);
var state_41676__$1 = state_41676;
var statearr_41857_42020 = state_41676__$1;
(statearr_41857_42020[(2)] = inst_41375);

(statearr_41857_42020[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (80))){
var inst_41536 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_41676__$1 = state_41676;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41676__$1,(83),inst_41536);
} else {
if((state_val_41677 === (37))){
var inst_41441 = (state_41676[(2)]);
var inst_41442 = fluree.db.util.async.throw_err(inst_41441);
var state_41676__$1 = state_41676;
var statearr_41858_42021 = state_41676__$1;
(statearr_41858_42021[(2)] = inst_41442);

(statearr_41858_42021[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (63))){
var inst_41495 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
if(cljs.core.truth_(inst_41495)){
var statearr_41859_42022 = state_41676__$1;
(statearr_41859_42022[(1)] = (64));

} else {
var statearr_41860_42023 = state_41676__$1;
(statearr_41860_42023[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (94))){
var inst_41572 = from;
var inst_41573 = cljs.core.seq(inst_41572);
var inst_41574 = cljs.core.first(inst_41573);
var inst_41575 = cljs.core.next(inst_41573);
var inst_41576 = cljs.core.PersistentVector.EMPTY;
var inst_41577 = inst_41572;
var inst_41578 = inst_41576;
var state_41676__$1 = (function (){var statearr_41861 = state_41676;
(statearr_41861[(42)] = inst_41575);

(statearr_41861[(43)] = inst_41574);

(statearr_41861[(10)] = inst_41578);

(statearr_41861[(38)] = inst_41577);

return statearr_41861;
})();
var statearr_41862_42024 = state_41676__$1;
(statearr_41862_42024[(2)] = null);

(statearr_41862_42024[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (8))){
var inst_41374 = (state_41676[(24)]);
var inst_41369 = (state_41676[(2)]);
var inst_41370 = opts_SINGLEQUOTE_;
var inst_41371 = cljs.core.__destructure_map(inst_41370);
var inst_41372 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41371,cljs.core.cst$kw$orderBy);
var inst_41373 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41371,cljs.core.cst$kw$limit);
var inst_41374__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41371,cljs.core.cst$kw$component);
var inst_41375 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41371,cljs.core.cst$kw$offset);
var inst_41376 = fluree.db.query.fql_parser.parse_db(db,inst_41369,opts_SINGLEQUOTE_);
var inst_41377 = (inst_41374__$1 == null);
var inst_41378 = cljs.core.not(inst_41377);
var state_41676__$1 = (function (){var statearr_41863 = state_41676;
(statearr_41863[(13)] = inst_41373);

(statearr_41863[(24)] = inst_41374__$1);

(statearr_41863[(18)] = inst_41372);

(statearr_41863[(15)] = inst_41375);

(statearr_41863[(25)] = inst_41376);

return statearr_41863;
})();
if(inst_41378){
var statearr_41864_42025 = state_41676__$1;
(statearr_41864_42025[(1)] = (15));

} else {
var statearr_41865_42026 = state_41676__$1;
(statearr_41865_42026[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (49))){
var inst_41647 = (state_41676[(2)]);
var state_41676__$1 = state_41676;
var statearr_41866_42027 = state_41676__$1;
(statearr_41866_42027[(2)] = inst_41647);

(statearr_41866_42027[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41677 === (84))){
var state_41676__$1 = state_41676;
var statearr_41867_42028 = state_41676__$1;
(statearr_41867_42028[(2)] = null);

(statearr_41867_42028[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16395__auto____0 = (function (){
var statearr_41868 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41868[(0)] = fluree$db$query$fql$query_$_state_machine__16395__auto__);

(statearr_41868[(1)] = (1));

return statearr_41868;
});
var fluree$db$query$fql$query_$_state_machine__16395__auto____1 = (function (state_41676){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_41676);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e41869){var ex__16398__auto__ = e41869;
var statearr_41870_42029 = state_41676;
(statearr_41870_42029[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_41676[(4)]))){
var statearr_41871_42030 = state_41676;
(statearr_41871_42030[(1)] = cljs.core.first((state_41676[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42031 = state_41676;
state_41676 = G__42031;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16395__auto__ = function(state_41676){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16395__auto____1.call(this,state_41676);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16395__auto____0;
fluree$db$query$fql$query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16395__auto____1;
return fluree$db$query$fql$query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_41872 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_41872[(6)] = c__16469__auto__);

return statearr_41872;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}

});
