// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.async');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.schema');
/**
 * Takes an predicate name (string) and returns the namespace portion of it as a keyword.
 */
fluree.db.query.schema.pred_name__GT_keyword = (function fluree$db$query$schema$pred_name__GT_keyword(pred_name){
if(typeof pred_name === 'string'){
return cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(cljs.core.re_find(/[^\/]+$/,pred_name));
} else {
return null;
}
});
/**
 * Converts a tag sid for a _predicate/type attributes into a keyword of just the 'name'.
 */
fluree.db.query.schema.convert_type_to_kw = (function fluree$db$query$schema$convert_type_to_kw(type_tag_sid,db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31508){
var state_val_31509 = (state_31508[(1)]);
if((state_val_31509 === (1))){
var state_31508__$1 = state_31508;
var statearr_31510_31524 = state_31508__$1;
(statearr_31510_31524[(2)] = null);

(statearr_31510_31524[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31509 === (2))){
var _ = (function (){var statearr_31511 = state_31508;
(statearr_31511[(4)] = cljs.core.cons((5),(state_31508[(4)])));

return statearr_31511;
})();
var inst_31499 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,type_tag_sid,"_predicate/type");
var state_31508__$1 = state_31508;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31508__$1,(6),inst_31499);
} else {
if((state_val_31509 === (3))){
var inst_31506 = (state_31508[(2)]);
var state_31508__$1 = state_31508;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31508__$1,inst_31506);
} else {
if((state_val_31509 === (4))){
var inst_31493 = (state_31508[(2)]);
var state_31508__$1 = state_31508;
var statearr_31513_31525 = state_31508__$1;
(statearr_31513_31525[(2)] = inst_31493);

(statearr_31513_31525[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31509 === (5))){
var _ = (function (){var statearr_31514 = state_31508;
(statearr_31514[(4)] = cljs.core.rest((state_31508[(4)])));

return statearr_31514;
})();
var state_31508__$1 = state_31508;
var ex31512 = (state_31508__$1[(2)]);
var statearr_31515_31526 = state_31508__$1;
(statearr_31515_31526[(5)] = ex31512);


if((ex31512 instanceof Error)){
var statearr_31516_31527 = state_31508__$1;
(statearr_31516_31527[(1)] = (4));

(statearr_31516_31527[(5)] = null);

} else {
throw ex31512;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31509 === (6))){
var inst_31501 = (state_31508[(2)]);
var inst_31502 = fluree.db.util.async.throw_err(inst_31501);
var inst_31503 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_31502);
var _ = (function (){var statearr_31517 = state_31508;
(statearr_31517[(4)] = cljs.core.rest((state_31508[(4)])));

return statearr_31517;
})();
var state_31508__$1 = state_31508;
var statearr_31518_31528 = state_31508__$1;
(statearr_31518_31528[(2)] = inst_31503);

(statearr_31518_31528[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0 = (function (){
var statearr_31519 = [null,null,null,null,null,null,null];
(statearr_31519[(0)] = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__);

(statearr_31519[(1)] = (1));

return statearr_31519;
});
var fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1 = (function (state_31508){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31508);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31520){var ex__16398__auto__ = e31520;
var statearr_31521_31529 = state_31508;
(statearr_31521_31529[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31508[(4)]))){
var statearr_31522_31530 = state_31508;
(statearr_31522_31530[(1)] = cljs.core.first((state_31508[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31531 = state_31508;
state_31508 = G__31531;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__ = function(state_31508){
switch(arguments.length){
case 0:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1.call(this,state_31508);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____0;
fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto____1;
return fluree$db$query$schema$convert_type_to_kw_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31523 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31523[(6)] = c__16469__auto__);

return statearr_31523;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.schema.pred_objects_unique_QMARK_ = (function fluree$db$query$schema$pred_objects_unique_QMARK_(db,pred_id){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31563){
var state_val_31564 = (state_31563[(1)]);
if((state_val_31564 === (7))){
var inst_31547 = (state_31563[(7)]);
var inst_31549 = cljs.core.empty_QMARK_(inst_31547);
var inst_31550 = (!(inst_31549));
var state_31563__$1 = state_31563;
var statearr_31565_31589 = state_31563__$1;
(statearr_31565_31589[(2)] = inst_31550);

(statearr_31565_31589[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (1))){
var state_31563__$1 = state_31563;
var statearr_31566_31590 = state_31563__$1;
(statearr_31566_31590[(2)] = null);

(statearr_31566_31590[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (4))){
var inst_31533 = (state_31563[(2)]);
var state_31563__$1 = state_31563;
var statearr_31567_31591 = state_31563__$1;
(statearr_31567_31591[(2)] = inst_31533);

(statearr_31567_31591[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (6))){
var inst_31547 = (state_31563[(7)]);
var inst_31539 = (state_31563[(8)]);
var inst_31545 = (state_31563[(2)]);
var inst_31546 = fluree.db.util.async.throw_err(inst_31545);
var inst_31547__$1 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_31539,inst_31546);
var state_31563__$1 = (function (){var statearr_31568 = state_31563;
(statearr_31568[(7)] = inst_31547__$1);

return statearr_31568;
})();
if(cljs.core.truth_(inst_31547__$1)){
var statearr_31569_31592 = state_31563__$1;
(statearr_31569_31592[(1)] = (7));

} else {
var statearr_31570_31593 = state_31563__$1;
(statearr_31570_31593[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (3))){
var inst_31561 = (state_31563[(2)]);
var state_31563__$1 = state_31563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31563__$1,inst_31561);
} else {
if((state_val_31564 === (12))){
var inst_31558 = (state_31563[(2)]);
var _ = (function (){var statearr_31571 = state_31563;
(statearr_31571[(4)] = cljs.core.rest((state_31563[(4)])));

return statearr_31571;
})();
var state_31563__$1 = state_31563;
var statearr_31572_31594 = state_31563__$1;
(statearr_31572_31594[(2)] = inst_31558);

(statearr_31572_31594[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (2))){
var _ = (function (){var statearr_31573 = state_31563;
(statearr_31573[(4)] = cljs.core.cons((5),(state_31563[(4)])));

return statearr_31573;
})();
var inst_31539 = (function (){return (function (p1__31532_SHARP_){
return p1__31532_SHARP_.o;
});
})();
var inst_31540 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31541 = [pred_id];
var inst_31542 = (new cljs.core.PersistentVector(null,1,(5),inst_31540,inst_31541,null));
var inst_31543 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31542);
var state_31563__$1 = (function (){var statearr_31574 = state_31563;
(statearr_31574[(8)] = inst_31539);

return statearr_31574;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31563__$1,(6),inst_31543);
} else {
if((state_val_31564 === (11))){
var state_31563__$1 = state_31563;
var statearr_31576_31595 = state_31563__$1;
(statearr_31576_31595[(2)] = true);

(statearr_31576_31595[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (9))){
var inst_31553 = (state_31563[(2)]);
var state_31563__$1 = state_31563;
if(cljs.core.truth_(inst_31553)){
var statearr_31577_31596 = state_31563__$1;
(statearr_31577_31596[(1)] = (10));

} else {
var statearr_31578_31597 = state_31563__$1;
(statearr_31578_31597[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (5))){
var _ = (function (){var statearr_31579 = state_31563;
(statearr_31579[(4)] = cljs.core.rest((state_31563[(4)])));

return statearr_31579;
})();
var state_31563__$1 = state_31563;
var ex31575 = (state_31563__$1[(2)]);
var statearr_31580_31598 = state_31563__$1;
(statearr_31580_31598[(5)] = ex31575);


if((ex31575 instanceof Error)){
var statearr_31581_31599 = state_31563__$1;
(statearr_31581_31599[(1)] = (4));

(statearr_31581_31599[(5)] = null);

} else {
throw ex31575;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (10))){
var inst_31547 = (state_31563[(7)]);
var inst_31555 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.distinct_QMARK_,inst_31547);
var state_31563__$1 = state_31563;
var statearr_31582_31600 = state_31563__$1;
(statearr_31582_31600[(2)] = inst_31555);

(statearr_31582_31600[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31564 === (8))){
var inst_31547 = (state_31563[(7)]);
var state_31563__$1 = state_31563;
var statearr_31583_31601 = state_31563__$1;
(statearr_31583_31601[(2)] = inst_31547);

(statearr_31583_31601[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_31584 = [null,null,null,null,null,null,null,null,null];
(statearr_31584[(0)] = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__);

(statearr_31584[(1)] = (1));

return statearr_31584;
});
var fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1 = (function (state_31563){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31563);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31585){var ex__16398__auto__ = e31585;
var statearr_31586_31602 = state_31563;
(statearr_31586_31602[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31563[(4)]))){
var statearr_31587_31603 = state_31563;
(statearr_31587_31603[(1)] = cljs.core.first((state_31563[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31604 = state_31563;
state_31563 = G__31604;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__ = function(state_31563){
switch(arguments.length){
case 0:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1.call(this,state_31563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____0;
fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto____1;
return fluree$db$query$schema$pred_objects_unique_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31588 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31588[(6)] = c__16469__auto__);

return statearr_31588;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a map of predicate changes with their respective old
 *   value and new value, both the key and value of the map are two-tuples as follows:
 *   {subid  {:new?  true
 *        :type  {:old :int :new :long}
 *        :index {:old nil  :new true }}}
 * 
 *   If the predicate being changed is the :type, it resolves the type _tag to its short keyword name
 * 
 *   When an old value does not exist, old-val is nil.
 *   If they subject being created is completely new, :new? true 
 */
fluree.db.query.schema.new_pred_changes = (function fluree$db$query$schema$new_pred_changes(db,tempids,flakes,filter_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31685){
var state_val_31686 = (state_31685[(1)]);
if((state_val_31686 === (7))){
var state_31685__$1 = state_31685;
var statearr_31687_31725 = state_31685__$1;
(statearr_31687_31725[(2)] = flakes);

(statearr_31687_31725[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (20))){
var inst_31642 = (state_31685[(7)]);
var inst_31675 = (state_31685[(2)]);
var inst_31634 = inst_31642;
var inst_31635 = inst_31675;
var state_31685__$1 = (function (){var statearr_31688 = state_31685;
(statearr_31688[(8)] = inst_31635);

(statearr_31688[(9)] = inst_31634);

return statearr_31688;
})();
var statearr_31689_31726 = state_31685__$1;
(statearr_31689_31726[(2)] = null);

(statearr_31689_31726[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (1))){
var state_31685__$1 = state_31685;
var statearr_31690_31727 = state_31685__$1;
(statearr_31690_31727[(2)] = null);

(statearr_31690_31727[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (4))){
var inst_31607 = (state_31685[(2)]);
var state_31685__$1 = state_31685;
var statearr_31691_31728 = state_31685__$1;
(statearr_31691_31728[(2)] = inst_31607);

(statearr_31691_31728[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (15))){
var inst_31641 = (state_31685[(10)]);
var inst_31659 = inst_31641.o;
var state_31685__$1 = state_31685;
var statearr_31692_31729 = state_31685__$1;
(statearr_31692_31729[(2)] = inst_31659);

(statearr_31692_31729[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (13))){
var inst_31678 = (state_31685[(2)]);
var state_31685__$1 = state_31685;
var statearr_31693_31730 = state_31685__$1;
(statearr_31693_31730[(2)] = inst_31678);

(statearr_31693_31730[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (6))){
var inst_31614 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
var state_31685__$1 = state_31685;
var statearr_31694_31731 = state_31685__$1;
(statearr_31694_31731[(2)] = inst_31614);

(statearr_31694_31731[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (17))){
var inst_31656 = (state_31685[(2)]);
var inst_31657 = fluree.db.util.async.throw_err(inst_31656);
var state_31685__$1 = state_31685;
var statearr_31695_31732 = state_31685__$1;
(statearr_31695_31732[(2)] = inst_31657);

(statearr_31695_31732[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (3))){
var inst_31683 = (state_31685[(2)]);
var state_31685__$1 = state_31685;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31685__$1,inst_31683);
} else {
if((state_val_31686 === (12))){
var inst_31648 = (state_31685[(11)]);
var inst_31641 = (state_31685[(10)]);
var inst_31646 = inst_31641.p;
var inst_31647 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31646);
var inst_31648__$1 = fluree.db.query.schema.pred_name__GT_keyword(inst_31647);
var inst_31649 = inst_31641.op;
var inst_31650 = inst_31649 === false;
var inst_31651 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$type,inst_31648__$1);
var state_31685__$1 = (function (){var statearr_31696 = state_31685;
(statearr_31696[(12)] = inst_31650);

(statearr_31696[(11)] = inst_31648__$1);

return statearr_31696;
})();
if(inst_31651){
var statearr_31697_31733 = state_31685__$1;
(statearr_31697_31733[(1)] = (14));

} else {
var statearr_31698_31734 = state_31685__$1;
(statearr_31698_31734[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (2))){
var _ = (function (){var statearr_31699 = state_31685;
(statearr_31699[(4)] = cljs.core.cons((5),(state_31685[(4)])));

return statearr_31699;
})();
var state_31685__$1 = state_31685;
if(cljs.core.truth_(filter_QMARK_)){
var statearr_31700_31735 = state_31685__$1;
(statearr_31700_31735[(1)] = (6));

} else {
var statearr_31701_31736 = state_31685__$1;
(statearr_31701_31736[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (19))){
var inst_31635 = (state_31685[(8)]);
var inst_31661 = (state_31685[(13)]);
var inst_31648 = (state_31685[(11)]);
var inst_31641 = (state_31685[(10)]);
var inst_31669 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31670 = inst_31641.s;
var inst_31671 = [inst_31670,inst_31648,cljs.core.cst$kw$new];
var inst_31672 = (new cljs.core.PersistentVector(null,3,(5),inst_31669,inst_31671,null));
var inst_31673 = cljs.core.assoc_in(inst_31635,inst_31672,inst_31661);
var state_31685__$1 = state_31685;
var statearr_31702_31737 = state_31685__$1;
(statearr_31702_31737[(2)] = inst_31673);

(statearr_31702_31737[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (11))){
var inst_31635 = (state_31685[(8)]);
var state_31685__$1 = state_31685;
var statearr_31704_31738 = state_31685__$1;
(statearr_31704_31738[(2)] = inst_31635);

(statearr_31704_31738[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (9))){
var inst_31634 = (state_31685[(9)]);
var inst_31641 = (state_31685[(10)]);
var inst_31640 = cljs.core.seq(inst_31634);
var inst_31641__$1 = cljs.core.first(inst_31640);
var inst_31642 = cljs.core.next(inst_31640);
var inst_31643 = cljs.core.not(inst_31641__$1);
var state_31685__$1 = (function (){var statearr_31705 = state_31685;
(statearr_31705[(10)] = inst_31641__$1);

(statearr_31705[(7)] = inst_31642);

return statearr_31705;
})();
if(inst_31643){
var statearr_31706_31739 = state_31685__$1;
(statearr_31706_31739[(1)] = (11));

} else {
var statearr_31707_31740 = state_31685__$1;
(statearr_31707_31740[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (5))){
var _ = (function (){var statearr_31708 = state_31685;
(statearr_31708[(4)] = cljs.core.rest((state_31685[(4)])));

return statearr_31708;
})();
var state_31685__$1 = state_31685;
var ex31703 = (state_31685__$1[(2)]);
var statearr_31709_31741 = state_31685__$1;
(statearr_31709_31741[(5)] = ex31703);


if((ex31703 instanceof Error)){
var statearr_31710_31742 = state_31685__$1;
(statearr_31710_31742[(1)] = (4));

(statearr_31710_31742[(5)] = null);

} else {
throw ex31703;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (14))){
var inst_31641 = (state_31685[(10)]);
var inst_31653 = inst_31641.o;
var inst_31654 = fluree.db.query.schema.convert_type_to_kw(inst_31653,db);
var state_31685__$1 = state_31685;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31685__$1,(17),inst_31654);
} else {
if((state_val_31686 === (16))){
var inst_31650 = (state_31685[(12)]);
var inst_31661 = (state_31685[(2)]);
var state_31685__$1 = (function (){var statearr_31711 = state_31685;
(statearr_31711[(13)] = inst_31661);

return statearr_31711;
})();
if(cljs.core.truth_(inst_31650)){
var statearr_31712_31743 = state_31685__$1;
(statearr_31712_31743[(1)] = (18));

} else {
var statearr_31713_31744 = state_31685__$1;
(statearr_31713_31744[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (10))){
var inst_31680 = (state_31685[(2)]);
var _ = (function (){var statearr_31714 = state_31685;
(statearr_31714[(4)] = cljs.core.rest((state_31685[(4)])));

return statearr_31714;
})();
var state_31685__$1 = state_31685;
var statearr_31715_31745 = state_31685__$1;
(statearr_31715_31745[(2)] = inst_31680);

(statearr_31715_31745[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (18))){
var inst_31635 = (state_31685[(8)]);
var inst_31661 = (state_31685[(13)]);
var inst_31648 = (state_31685[(11)]);
var inst_31641 = (state_31685[(10)]);
var inst_31663 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31664 = inst_31641.s;
var inst_31665 = [inst_31664,inst_31648,cljs.core.cst$kw$old];
var inst_31666 = (new cljs.core.PersistentVector(null,3,(5),inst_31663,inst_31665,null));
var inst_31667 = cljs.core.assoc_in(inst_31635,inst_31666,inst_31661);
var state_31685__$1 = state_31685;
var statearr_31716_31746 = state_31685__$1;
(statearr_31716_31746[(2)] = inst_31667);

(statearr_31716_31746[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31686 === (8))){
var inst_31617 = (state_31685[(2)]);
var inst_31618 = cljs.core.PersistentHashSet.EMPTY;
var inst_31619 = cljs.core.vals(tempids);
var inst_31620 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_31618,inst_31619);
var inst_31621 = (function (){var pred_flakes = inst_31617;
var is_new_QMARK_ = inst_31620;
return (function (p1__31606_SHARP_,p2__31605_SHARP_){
var f = p2__31605_SHARP_;
return cljs.core.assoc_in(p1__31606_SHARP_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [f.s,cljs.core.cst$kw$new_QMARK_], null),cljs.core.boolean$((function (){var G__31717 = f.s;
return (is_new_QMARK_.cljs$core$IFn$_invoke$arity$1 ? is_new_QMARK_.cljs$core$IFn$_invoke$arity$1(G__31717) : is_new_QMARK_.call(null,G__31717));
})()));
});
})();
var inst_31622 = cljs.core.PersistentHashMap.EMPTY;
var inst_31623 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_31621,inst_31622,inst_31617);
var inst_31631 = cljs.core.seq(inst_31617);
var inst_31632 = cljs.core.first(inst_31631);
var inst_31633 = cljs.core.next(inst_31631);
var inst_31634 = inst_31617;
var inst_31635 = inst_31623;
var state_31685__$1 = (function (){var statearr_31718 = state_31685;
(statearr_31718[(14)] = inst_31632);

(statearr_31718[(8)] = inst_31635);

(statearr_31718[(9)] = inst_31634);

(statearr_31718[(15)] = inst_31633);

return statearr_31718;
})();
var statearr_31719_31747 = state_31685__$1;
(statearr_31719_31747[(2)] = null);

(statearr_31719_31747[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0 = (function (){
var statearr_31720 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31720[(0)] = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__);

(statearr_31720[(1)] = (1));

return statearr_31720;
});
var fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1 = (function (state_31685){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31685);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31721){var ex__16398__auto__ = e31721;
var statearr_31722_31748 = state_31685;
(statearr_31722_31748[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31685[(4)]))){
var statearr_31723_31749 = state_31685;
(statearr_31723_31749[(1)] = cljs.core.first((state_31685[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31750 = state_31685;
state_31685 = G__31750;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__ = function(state_31685){
switch(arguments.length){
case 0:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1.call(this,state_31685);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____0;
fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto____1;
return fluree$db$query$schema$new_pred_changes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31724 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31724[(6)] = c__16469__auto__);

return statearr_31724;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Throw an error if schema update attempt is invalid.
 */
fluree.db.query.schema.type_error = (function fluree$db$query$schema$type_error(var_args){
var G__31752 = arguments.length;
switch (G__31752) {
case 3:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3 = (function (current_type,new_type,throw_QMARK_){
return fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(null,current_type,new_type,throw_QMARK_);
}));

(fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4 = (function (db,current_type,new_type,throw_QMARK_){
var message = ["Cannot convert an _predicate from ",cljs.core.name(current_type)," to ",cljs.core.name(new_type),"."].join('');
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(message,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_tx], null));
} else {
return db;
}
}));

(fluree.db.query.schema.type_error.cljs$lang$maxFixedArity = 4);

/**
 * Accepts a db (should have root permissions) and a map of predicate changes as produced by new-pred-changes.
 *   Returns a db with updated idxs if relevant, i.e. if non-unique predicate converted to unique
 *   If optional throw? parameter is true, will throw with an ex-info error.
 */
fluree.db.query.schema.predicate_change_error = (function fluree$db$query$schema$predicate_change_error(var_args){
var G__31755 = arguments.length;
switch (G__31755) {
case 2:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$2 = (function (pred_changes,db){
return fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(pred_changes,db,false);
}));

(fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3 = (function (pred_changes,db,throw_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32067){
var state_val_32068 = (state_32067[(1)]);
if((state_val_32068 === (121))){
var inst_32022 = (state_32067[(7)]);
var state_32067__$1 = state_32067;
var statearr_32069_32262 = state_32067__$1;
(statearr_32069_32262[(2)] = inst_32022);

(statearr_32069_32262[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (65))){
var inst_31921 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31921)){
var statearr_32070_32263 = state_32067__$1;
(statearr_32070_32263[(1)] = (66));

} else {
var statearr_32071_32264 = state_32067__$1;
(statearr_32071_32264[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (70))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31931 = [cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$string,null,cljs.core.cst$kw$bigdec,null];
var inst_31932 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31931,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,3,inst_31931,null));
var inst_31933 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31932,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31932,null));
var inst_31934 = (inst_31933.cljs$core$IFn$_invoke$arity$1 ? inst_31933.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31933.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31934)){
var statearr_32072_32265 = state_32067__$1;
(statearr_32072_32265[(1)] = (72));

} else {
var statearr_32073_32266 = state_32067__$1;
(statearr_32073_32266[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (62))){
var inst_31911 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32074_32267 = state_32067__$1;
(statearr_32074_32267[(2)] = inst_31911);

(statearr_32074_32267[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (74))){
var inst_32017 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32075_32268 = state_32067__$1;
(statearr_32075_32268[(2)] = inst_32017);

(statearr_32075_32268[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (110))){
var inst_32044 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_32044)){
var statearr_32076_32269 = state_32067__$1;
(statearr_32076_32269[(1)] = (117));

} else {
var statearr_32077_32270 = state_32067__$1;
(statearr_32077_32270[(1)] = (118));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (7))){
var inst_32062 = (state_32067[(2)]);
var _ = (function (){var statearr_32078 = state_32067;
(statearr_32078[(4)] = cljs.core.rest((state_32067[(4)])));

return statearr_32078;
})();
var state_32067__$1 = state_32067;
var statearr_32079_32271 = state_32067__$1;
(statearr_32079_32271[(2)] = inst_32062);

(statearr_32079_32271[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (59))){
var inst_31795 = (state_32067[(10)]);
var inst_31915 = (state_32067[(11)]);
var inst_31914 = (state_32067[(2)]);
var inst_31915__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32080 = state_32067;
(statearr_32080[(11)] = inst_31915__$1);

(statearr_32080[(12)] = inst_31914);

return statearr_32080;
})();
if(cljs.core.truth_(inst_31915__$1)){
var statearr_32081_32272 = state_32067__$1;
(statearr_32081_32272[(1)] = (63));

} else {
var statearr_32082_32273 = state_32067__$1;
(statearr_32082_32273[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (86))){
var inst_31957 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32083_32274 = state_32067__$1;
(statearr_32083_32274[(2)] = inst_31957);

(statearr_32083_32274[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (20))){
var inst_31821 = (state_32067[(13)]);
var inst_31795 = (state_32067[(10)]);
var inst_31821__$1 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32084 = state_32067;
(statearr_32084[(13)] = inst_31821__$1);

return statearr_32084;
})();
if(cljs.core.truth_(inst_31821__$1)){
var statearr_32085_32275 = state_32067__$1;
(statearr_32085_32275[(1)] = (23));

} else {
var statearr_32086_32276 = state_32067__$1;
(statearr_32086_32276[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (72))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31936 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32087_32277 = state_32067__$1;
(statearr_32087_32277[(2)] = inst_31936);

(statearr_32087_32277[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (58))){
var inst_31876 = (state_32067[(14)]);
var state_32067__$1 = state_32067;
var statearr_32088_32278 = state_32067__$1;
(statearr_32088_32278[(2)] = inst_31876);

(statearr_32088_32278[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (60))){
var inst_31794 = (state_32067[(15)]);
var inst_31783 = (state_32067[(16)]);
var inst_31902 = fluree.db.dbproto._p_prop(inst_31783,cljs.core.cst$kw$name,inst_31794);
var inst_31903 = ["The _predicate ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31902)," cannot be set to unique, because there are existing non-unique values."].join('');
var inst_31904 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31905 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31906 = cljs.core.PersistentHashMap.fromArrays(inst_31904,inst_31905);
var inst_31907 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31903,inst_31906);
var inst_31908 = (function(){throw inst_31907})();
var state_32067__$1 = state_32067;
var statearr_32089_32279 = state_32067__$1;
(statearr_32089_32279[(2)] = inst_31908);

(statearr_32089_32279[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (27))){
var inst_31824 = (state_32067[(17)]);
var state_32067__$1 = state_32067;
var statearr_32090_32280 = state_32067__$1;
(statearr_32090_32280[(2)] = inst_31824);

(statearr_32090_32280[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (1))){
var state_32067__$1 = state_32067;
var statearr_32091_32281 = state_32067__$1;
(statearr_32091_32281[(2)] = null);

(statearr_32091_32281[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (69))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32092_32282 = state_32067__$1;
(statearr_32092_32282[(2)] = inst_31914);

(statearr_32092_32282[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (101))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31995 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32093_32283 = state_32067__$1;
(statearr_32093_32283[(2)] = inst_31995);

(statearr_32093_32283[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (24))){
var inst_31821 = (state_32067[(13)]);
var state_32067__$1 = state_32067;
var statearr_32094_32284 = state_32067__$1;
(statearr_32094_32284[(2)] = inst_31821);

(statearr_32094_32284[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (102))){
var inst_31997 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32095_32285 = state_32067__$1;
(statearr_32095_32285[(2)] = inst_31997);

(statearr_32095_32285[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (55))){
var inst_31893 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32096_32286 = state_32067__$1;
(statearr_32096_32286[(2)] = inst_31893);

(statearr_32096_32286[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (85))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31955 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32097_32287 = state_32067__$1;
(statearr_32097_32287[(2)] = inst_31955);

(statearr_32097_32287[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (39))){
var inst_31858 = (state_32067[(18)]);
var state_32067__$1 = state_32067;
var statearr_32098_32288 = state_32067__$1;
(statearr_32098_32288[(2)] = inst_31858);

(statearr_32098_32288[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (88))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32099_32289 = state_32067__$1;
(statearr_32099_32289[(2)] = inst_31914);

(statearr_32099_32289[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (46))){
var inst_31877 = (state_32067[(19)]);
var inst_31795 = (state_32067[(10)]);
var inst_31876 = (state_32067[(2)]);
var inst_31877__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32100 = state_32067;
(statearr_32100[(19)] = inst_31877__$1);

(statearr_32100[(14)] = inst_31876);

return statearr_32100;
})();
if(cljs.core.truth_(inst_31877__$1)){
var statearr_32101_32290 = state_32067__$1;
(statearr_32101_32290[(1)] = (47));

} else {
var statearr_32102_32291 = state_32067__$1;
(statearr_32102_32291[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (4))){
var inst_31756 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32103_32292 = state_32067__$1;
(statearr_32103_32292[(2)] = inst_31756);

(statearr_32103_32292[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (77))){
var inst_32015 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32104_32293 = state_32067__$1;
(statearr_32104_32293[(2)] = inst_32015);

(statearr_32104_32293[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (106))){
var inst_32007 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32105_32294 = state_32067__$1;
(statearr_32105_32294[(2)] = inst_32007);

(statearr_32105_32294[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (119))){
var inst_31793 = (state_32067[(20)]);
var inst_32057 = (state_32067[(2)]);
var inst_31782 = inst_31793;
var inst_31783 = inst_32057;
var state_32067__$1 = (function (){var statearr_32106 = state_32067;
(statearr_32106[(21)] = inst_31782);

(statearr_32106[(16)] = inst_31783);

return statearr_32106;
})();
var statearr_32107_32295 = state_32067__$1;
(statearr_32107_32295[(2)] = null);

(statearr_32107_32295[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (95))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31979 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$double,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$bigint,null,cljs.core.cst$kw$float,null];
var inst_31980 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31979,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,5,inst_31979,null));
var inst_31981 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31980,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31980,null));
var inst_31982 = (inst_31981.cljs$core$IFn$_invoke$arity$1 ? inst_31981.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31981.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31982)){
var statearr_32108_32296 = state_32067__$1;
(statearr_32108_32296[(1)] = (96));

} else {
var statearr_32109_32297 = state_32067__$1;
(statearr_32109_32297[(1)] = (97));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (54))){
var inst_31884 = (state_32067[(22)]);
var state_32067__$1 = state_32067;
var statearr_32110_32298 = state_32067__$1;
(statearr_32110_32298[(2)] = inst_31884);

(statearr_32110_32298[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (92))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32111_32299 = state_32067__$1;
(statearr_32111_32299[(2)] = inst_31914);

(statearr_32111_32299[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (104))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32112_32300 = state_32067__$1;
(statearr_32112_32300[(2)] = inst_31914);

(statearr_32112_32300[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (15))){
var inst_31803 = (state_32067[(23)]);
var state_32067__$1 = state_32067;
var statearr_32113_32301 = state_32067__$1;
(statearr_32113_32301[(2)] = inst_31803);

(statearr_32113_32301[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (48))){
var inst_31877 = (state_32067[(19)]);
var state_32067__$1 = state_32067;
var statearr_32114_32302 = state_32067__$1;
(statearr_32114_32302[(2)] = inst_31877);

(statearr_32114_32302[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (50))){
var inst_31884 = (state_32067[(22)]);
var inst_31795 = (state_32067[(10)]);
var inst_31882 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31883 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31882);
var inst_31884__$1 = inst_31883 === true;
var state_32067__$1 = (function (){var statearr_32115 = state_32067;
(statearr_32115[(22)] = inst_31884__$1);

return statearr_32115;
})();
if(cljs.core.truth_(inst_31884__$1)){
var statearr_32116_32303 = state_32067__$1;
(statearr_32116_32303[(1)] = (53));

} else {
var statearr_32117_32304 = state_32067__$1;
(statearr_32117_32304[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (116))){
var inst_32038 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32118_32305 = state_32067__$1;
(statearr_32118_32305[(2)] = inst_32038);

(statearr_32118_32305[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (75))){
var inst_31927 = (state_32067[(8)]);
var state_32067__$1 = state_32067;
var G__32119_32306 = inst_31927;
var G__32119_32307__$1 = (((G__32119_32306 instanceof cljs.core.Keyword))?G__32119_32306.fqn:null);
switch (G__32119_32307__$1) {
case "long":
var statearr_32120_32309 = state_32067__$1;
(statearr_32120_32309[(1)] = (79));


break;
case "bigint":
var statearr_32121_32310 = state_32067__$1;
(statearr_32121_32310[(1)] = (83));


break;
case "double":
var statearr_32122_32311 = state_32067__$1;
(statearr_32122_32311[(1)] = (87));


break;
case "float":
var statearr_32123_32312 = state_32067__$1;
(statearr_32123_32312[(1)] = (91));


break;
case "bigdec":
var statearr_32124_32313 = state_32067__$1;
(statearr_32124_32313[(1)] = (95));


break;
case "string":
var statearr_32125_32314 = state_32067__$1;
(statearr_32125_32314[(1)] = (99));


break;
case "instant":
var statearr_32126_32315 = state_32067__$1;
(statearr_32126_32315[(1)] = (103));


break;
default:
var statearr_32127_32316 = state_32067__$1;
(statearr_32127_32316[(1)] = (107));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (99))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31989 = [cljs.core.cst$kw$geojson,null,cljs.core.cst$kw$bytes,null,cljs.core.cst$kw$uri,null,cljs.core.cst$kw$uuid,null,cljs.core.cst$kw$json,null];
var inst_31990 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,5,inst_31989,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,5,inst_31989,null));
var inst_31991 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31990,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31990,null));
var inst_31992 = (inst_31991.cljs$core$IFn$_invoke$arity$1 ? inst_31991.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31991.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31992)){
var statearr_32128_32317 = state_32067__$1;
(statearr_32128_32317[(1)] = (100));

} else {
var statearr_32129_32318 = state_32067__$1;
(statearr_32129_32318[(1)] = (101));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (21))){
var inst_31819 = (state_32067[(24)]);
var state_32067__$1 = state_32067;
var statearr_32130_32319 = state_32067__$1;
(statearr_32130_32319[(2)] = inst_31819);

(statearr_32130_32319[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (31))){
var inst_31835 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32131_32320 = state_32067__$1;
(statearr_32131_32320[(2)] = inst_31835);

(statearr_32131_32320[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (113))){
var inst_32041 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32132_32321 = state_32067__$1;
(statearr_32132_32321[(2)] = inst_32041);

(statearr_32132_32321[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (32))){
var state_32067__$1 = state_32067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32133_32322 = state_32067__$1;
(statearr_32133_32322[(1)] = (35));

} else {
var statearr_32134_32323 = state_32067__$1;
(statearr_32134_32323[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (40))){
var inst_31871 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31871)){
var statearr_32135_32324 = state_32067__$1;
(statearr_32135_32324[(1)] = (44));

} else {
var statearr_32136_32325 = state_32067__$1;
(statearr_32136_32325[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (91))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31969 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31970 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31969,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,3,inst_31969,null));
var inst_31971 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31970,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31970,null));
var inst_31972 = (inst_31971.cljs$core$IFn$_invoke$arity$1 ? inst_31971.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31971.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31972)){
var statearr_32137_32326 = state_32067__$1;
(statearr_32137_32326[(1)] = (92));

} else {
var statearr_32138_32327 = state_32067__$1;
(statearr_32138_32327[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (117))){
var state_32067__$1 = state_32067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32139_32328 = state_32067__$1;
(statearr_32139_32328[(1)] = (120));

} else {
var statearr_32140_32329 = state_32067__$1;
(statearr_32140_32329[(1)] = (121));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (108))){
var inst_32026 = (state_32067[(25)]);
var inst_31795 = (state_32067[(10)]);
var inst_32026__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32141 = state_32067;
(statearr_32141[(25)] = inst_32026__$1);

return statearr_32141;
})();
if(cljs.core.truth_(inst_32026__$1)){
var statearr_32142_32330 = state_32067__$1;
(statearr_32142_32330[(1)] = (111));

} else {
var statearr_32143_32331 = state_32067__$1;
(statearr_32143_32331[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (56))){
var inst_31888 = (state_32067[(2)]);
var inst_31889 = fluree.db.util.async.throw_err(inst_31888);
var inst_31890 = cljs.core.not(inst_31889);
var state_32067__$1 = state_32067;
var statearr_32144_32332 = state_32067__$1;
(statearr_32144_32332[(2)] = inst_31890);

(statearr_32144_32332[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (33))){
var inst_31818 = (state_32067[(26)]);
var state_32067__$1 = state_32067;
var statearr_32145_32333 = state_32067__$1;
(statearr_32145_32333[(2)] = inst_31818);

(statearr_32145_32333[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (13))){
var inst_31813 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31813)){
var statearr_32146_32334 = state_32067__$1;
(statearr_32146_32334[(1)] = (17));

} else {
var statearr_32147_32335 = state_32067__$1;
(statearr_32147_32335[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (22))){
var inst_31844 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31844)){
var statearr_32148_32336 = state_32067__$1;
(statearr_32148_32336[(1)] = (32));

} else {
var statearr_32149_32337 = state_32067__$1;
(statearr_32149_32337[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (90))){
var inst_31967 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32150_32338 = state_32067__$1;
(statearr_32150_32338[(2)] = inst_31967);

(statearr_32150_32338[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (109))){
var inst_32024 = (state_32067[(27)]);
var state_32067__$1 = state_32067;
var statearr_32151_32339 = state_32067__$1;
(statearr_32151_32339[(2)] = inst_32024);

(statearr_32151_32339[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (36))){
var inst_31818 = (state_32067[(26)]);
var state_32067__$1 = state_32067;
var statearr_32152_32340 = state_32067__$1;
(statearr_32152_32340[(2)] = inst_31818);

(statearr_32152_32340[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (41))){
var inst_31795 = (state_32067[(10)]);
var inst_31863 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31864 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31863);
var inst_31865 = inst_31864 === true;
var state_32067__$1 = state_32067;
var statearr_32153_32341 = state_32067__$1;
(statearr_32153_32341[(2)] = inst_31865);

(statearr_32153_32341[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (118))){
var inst_32022 = (state_32067[(7)]);
var state_32067__$1 = state_32067;
var statearr_32154_32342 = state_32067__$1;
(statearr_32154_32342[(2)] = inst_32022);

(statearr_32154_32342[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (89))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31965 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32155_32343 = state_32067__$1;
(statearr_32155_32343[(2)] = inst_31965);

(statearr_32155_32343[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (100))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32156_32344 = state_32067__$1;
(statearr_32156_32344[(2)] = inst_31914);

(statearr_32156_32344[(1)] = (102));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (122))){
var inst_32054 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32157_32345 = state_32067__$1;
(statearr_32157_32345[(2)] = inst_32054);

(statearr_32157_32345[(1)] = (119));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (43))){
var inst_31868 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32158_32346 = state_32067__$1;
(statearr_32158_32346[(2)] = inst_31868);

(statearr_32158_32346[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (61))){
var inst_31876 = (state_32067[(14)]);
var state_32067__$1 = state_32067;
var statearr_32159_32347 = state_32067__$1;
(statearr_32159_32347[(2)] = inst_31876);

(statearr_32159_32347[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (29))){
var inst_31795 = (state_32067[(10)]);
var inst_31830 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31831 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31830);
var inst_31832 = inst_31831 === true;
var state_32067__$1 = state_32067;
var statearr_32160_32348 = state_32067__$1;
(statearr_32160_32348[(2)] = inst_31832);

(statearr_32160_32348[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (44))){
var inst_31857 = (state_32067[(28)]);
var inst_31873 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31857,"a component","a non-component",throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32161_32349 = state_32067__$1;
(statearr_32161_32349[(2)] = inst_31873);

(statearr_32161_32349[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (93))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31975 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32162_32350 = state_32067__$1;
(statearr_32162_32350[(2)] = inst_31975);

(statearr_32162_32350[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (6))){
var inst_31794 = (state_32067[(15)]);
var inst_31782 = (state_32067[(21)]);
var inst_31791 = cljs.core.seq(inst_31782);
var inst_31792 = cljs.core.first(inst_31791);
var inst_31793 = cljs.core.next(inst_31791);
var inst_31794__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31792,(0),null);
var inst_31795 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31792,(1),null);
var inst_31796 = cljs.core.not(inst_31794__$1);
var state_32067__$1 = (function (){var statearr_32163 = state_32067;
(statearr_32163[(15)] = inst_31794__$1);

(statearr_32163[(10)] = inst_31795);

(statearr_32163[(20)] = inst_31793);

return statearr_32163;
})();
if(inst_31796){
var statearr_32164_32351 = state_32067__$1;
(statearr_32164_32351[(1)] = (8));

} else {
var statearr_32165_32352 = state_32067__$1;
(statearr_32165_32352[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (111))){
var inst_32030 = (state_32067[(29)]);
var inst_31795 = (state_32067[(10)]);
var inst_32028 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_32029 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32028);
var inst_32030__$1 = inst_32029 === true;
var state_32067__$1 = (function (){var statearr_32166 = state_32067;
(statearr_32166[(29)] = inst_32030__$1);

return statearr_32166;
})();
if(cljs.core.truth_(inst_32030__$1)){
var statearr_32167_32353 = state_32067__$1;
(statearr_32167_32353[(1)] = (114));

} else {
var statearr_32168_32354 = state_32067__$1;
(statearr_32168_32354[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (28))){
var inst_31838 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32169_32355 = state_32067__$1;
(statearr_32169_32355[(2)] = inst_31838);

(statearr_32169_32355[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (64))){
var inst_31915 = (state_32067[(11)]);
var state_32067__$1 = state_32067;
var statearr_32170_32356 = state_32067__$1;
(statearr_32170_32356[(2)] = inst_31915);

(statearr_32170_32356[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (103))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31999 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null];
var inst_32000 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_31999,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,2,inst_31999,null));
var inst_32001 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_32000,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_32000,null));
var inst_32002 = (inst_32001.cljs$core$IFn$_invoke$arity$1 ? inst_32001.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_32001.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_32002)){
var statearr_32171_32357 = state_32067__$1;
(statearr_32171_32357[(1)] = (104));

} else {
var statearr_32172_32358 = state_32067__$1;
(statearr_32172_32358[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (51))){
var inst_31880 = (state_32067[(30)]);
var state_32067__$1 = state_32067;
var statearr_32173_32359 = state_32067__$1;
(statearr_32173_32359[(2)] = inst_31880);

(statearr_32173_32359[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (25))){
var inst_31841 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32174_32360 = state_32067__$1;
(statearr_32174_32360[(2)] = inst_31841);

(statearr_32174_32360[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (34))){
var inst_31858 = (state_32067[(18)]);
var inst_31795 = (state_32067[(10)]);
var inst_31857 = (state_32067[(2)]);
var inst_31858__$1 = cljs.core.cst$kw$component.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32175 = state_32067;
(statearr_32175[(28)] = inst_31857);

(statearr_32175[(18)] = inst_31858__$1);

return statearr_32175;
})();
if(cljs.core.truth_(inst_31858__$1)){
var statearr_32176_32361 = state_32067__$1;
(statearr_32176_32361[(1)] = (38));

} else {
var statearr_32177_32362 = state_32067__$1;
(statearr_32177_32362[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (17))){
var inst_31783 = (state_32067[(16)]);
var inst_31815 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$4(inst_31783,"multi-cardinality","single-cardinality",throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32178_32363 = state_32067__$1;
(statearr_32178_32363[(2)] = inst_31815);

(statearr_32178_32363[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (3))){
var inst_32065 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32067__$1,inst_32065);
} else {
if((state_val_32068 === (12))){
var inst_31799 = (state_32067[(31)]);
var state_32067__$1 = state_32067;
var statearr_32179_32364 = state_32067__$1;
(statearr_32179_32364[(2)] = inst_31799);

(statearr_32179_32364[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (2))){
var _ = (function (){var statearr_32180 = state_32067;
(statearr_32180[(4)] = cljs.core.cons((5),(state_32067[(4)])));

return statearr_32180;
})();
var inst_31775 = pred_changes;
var inst_31776 = cljs.core.seq(inst_31775);
var inst_31777 = cljs.core.first(inst_31776);
var inst_31778 = cljs.core.next(inst_31776);
var inst_31779 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31777,(0),null);
var inst_31780 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31777,(1),null);
var inst_31781 = db;
var inst_31782 = inst_31775;
var inst_31783 = inst_31781;
var state_32067__$1 = (function (){var statearr_32181 = state_32067;
(statearr_32181[(32)] = inst_31779);

(statearr_32181[(21)] = inst_31782);

(statearr_32181[(33)] = inst_31778);

(statearr_32181[(34)] = inst_31780);

(statearr_32181[(16)] = inst_31783);

return statearr_32181;
})();
var statearr_32182_32365 = state_32067__$1;
(statearr_32182_32365[(2)] = null);

(statearr_32182_32365[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (66))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31795 = (state_32067[(10)]);
var inst_31924 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31925 = cljs.core.__destructure_map(inst_31924);
var inst_31926__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31925,cljs.core.cst$kw$old);
var inst_31927__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_31925,cljs.core.cst$kw$new);
var inst_31928 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_31927__$1,inst_31926__$1);
var state_32067__$1 = (function (){var statearr_32183 = state_32067;
(statearr_32183[(8)] = inst_31927__$1);

(statearr_32183[(9)] = inst_31926__$1);

return statearr_32183;
})();
if(inst_31928){
var statearr_32184_32366 = state_32067__$1;
(statearr_32184_32366[(1)] = (69));

} else {
var statearr_32185_32367 = state_32067__$1;
(statearr_32185_32367[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (107))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_32009 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32186_32368 = state_32067__$1;
(statearr_32186_32368[(2)] = inst_32009);

(statearr_32186_32368[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (23))){
var inst_31824 = (state_32067[(17)]);
var inst_31795 = (state_32067[(10)]);
var inst_31823 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31824__$1 = inst_31823 === true;
var state_32067__$1 = (function (){var statearr_32187 = state_32067;
(statearr_32187[(17)] = inst_31824__$1);

return statearr_32187;
})();
if(cljs.core.truth_(inst_31824__$1)){
var statearr_32188_32369 = state_32067__$1;
(statearr_32188_32369[(1)] = (26));

} else {
var statearr_32189_32370 = state_32067__$1;
(statearr_32189_32370[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (47))){
var inst_31880 = (state_32067[(30)]);
var inst_31795 = (state_32067[(10)]);
var inst_31879 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31880__$1 = cljs.core.not(inst_31879);
var state_32067__$1 = (function (){var statearr_32190 = state_32067;
(statearr_32190[(30)] = inst_31880__$1);

return statearr_32190;
})();
if(inst_31880__$1){
var statearr_32191_32371 = state_32067__$1;
(statearr_32191_32371[(1)] = (50));

} else {
var statearr_32192_32372 = state_32067__$1;
(statearr_32192_32372[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (35))){
var inst_31847 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31848 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_31849 = cljs.core.PersistentHashMap.fromArrays(inst_31847,inst_31848);
var inst_31850 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A boolean _predicate cannot be unique.",inst_31849);
var inst_31851 = (function(){throw inst_31850})();
var state_32067__$1 = state_32067;
var statearr_32193_32373 = state_32067__$1;
(statearr_32193_32373[(2)] = inst_31851);

(statearr_32193_32373[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (82))){
var inst_31947 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32194_32374 = state_32067__$1;
(statearr_32194_32374[(2)] = inst_31947);

(statearr_32194_32374[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (76))){
var state_32067__$1 = state_32067;
var statearr_32195_32375 = state_32067__$1;
(statearr_32195_32375[(2)] = null);

(statearr_32195_32375[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (97))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31985 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32196_32376 = state_32067__$1;
(statearr_32196_32376[(2)] = inst_31985);

(statearr_32196_32376[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (19))){
var inst_31819 = (state_32067[(24)]);
var inst_31795 = (state_32067[(10)]);
var inst_31818 = (state_32067[(2)]);
var inst_31819__$1 = cljs.core.cst$kw$unique.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32197 = state_32067;
(statearr_32197[(26)] = inst_31818);

(statearr_32197[(24)] = inst_31819__$1);

return statearr_32197;
})();
if(cljs.core.truth_(inst_31819__$1)){
var statearr_32198_32377 = state_32067__$1;
(statearr_32198_32377[(1)] = (20));

} else {
var statearr_32199_32378 = state_32067__$1;
(statearr_32199_32378[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (57))){
var state_32067__$1 = state_32067;
if(cljs.core.truth_(throw_QMARK_)){
var statearr_32200_32379 = state_32067__$1;
(statearr_32200_32379[(1)] = (60));

} else {
var statearr_32201_32380 = state_32067__$1;
(statearr_32201_32380[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (68))){
var inst_32024 = (state_32067[(27)]);
var inst_31795 = (state_32067[(10)]);
var inst_32022 = (state_32067[(2)]);
var inst_32023 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_32024__$1 = inst_32023 === true;
var state_32067__$1 = (function (){var statearr_32202 = state_32067;
(statearr_32202[(27)] = inst_32024__$1);

(statearr_32202[(7)] = inst_32022);

return statearr_32202;
})();
if(cljs.core.truth_(inst_32024__$1)){
var statearr_32203_32381 = state_32067__$1;
(statearr_32203_32381[(1)] = (108));

} else {
var statearr_32204_32382 = state_32067__$1;
(statearr_32204_32382[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (11))){
var inst_31803 = (state_32067[(23)]);
var inst_31795 = (state_32067[(10)]);
var inst_31801 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31802 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31801);
var inst_31803__$1 = inst_31802 === false;
var state_32067__$1 = (function (){var statearr_32205 = state_32067;
(statearr_32205[(23)] = inst_31803__$1);

return statearr_32205;
})();
if(cljs.core.truth_(inst_31803__$1)){
var statearr_32206_32383 = state_32067__$1;
(statearr_32206_32383[(1)] = (14));

} else {
var statearr_32207_32384 = state_32067__$1;
(statearr_32207_32384[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (115))){
var inst_32030 = (state_32067[(29)]);
var state_32067__$1 = state_32067;
var statearr_32209_32385 = state_32067__$1;
(statearr_32209_32385[(2)] = inst_32030);

(statearr_32209_32385[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (9))){
var inst_31795 = (state_32067[(10)]);
var inst_31799 = (state_32067[(31)]);
var inst_31799__$1 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31795);
var state_32067__$1 = (function (){var statearr_32210 = state_32067;
(statearr_32210[(31)] = inst_31799__$1);

return statearr_32210;
})();
if(cljs.core.truth_(inst_31799__$1)){
var statearr_32211_32386 = state_32067__$1;
(statearr_32211_32386[(1)] = (11));

} else {
var statearr_32212_32387 = state_32067__$1;
(statearr_32212_32387[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (5))){
var _ = (function (){var statearr_32213 = state_32067;
(statearr_32213[(4)] = cljs.core.rest((state_32067[(4)])));

return statearr_32213;
})();
var state_32067__$1 = state_32067;
var ex32208 = (state_32067__$1[(2)]);
var statearr_32214_32388 = state_32067__$1;
(statearr_32214_32388[(5)] = ex32208);


if((ex32208 instanceof Error)){
var statearr_32215_32389 = state_32067__$1;
(statearr_32215_32389[(1)] = (4));

(statearr_32215_32389[(5)] = null);

} else {
throw ex32208;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (112))){
var inst_32026 = (state_32067[(25)]);
var state_32067__$1 = state_32067;
var statearr_32216_32390 = state_32067__$1;
(statearr_32216_32390[(2)] = inst_32026);

(statearr_32216_32390[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (83))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31949 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31950 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31949,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,3,inst_31949,null));
var inst_31951 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31950,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31950,null));
var inst_31952 = (inst_31951.cljs$core$IFn$_invoke$arity$1 ? inst_31951.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31951.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31952)){
var statearr_32217_32391 = state_32067__$1;
(statearr_32217_32391[(1)] = (84));

} else {
var statearr_32218_32392 = state_32067__$1;
(statearr_32218_32392[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (14))){
var inst_31795 = (state_32067[(10)]);
var inst_31805 = cljs.core.cst$kw$multi.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31806 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31805);
var inst_31807 = inst_31806 === true;
var state_32067__$1 = state_32067;
var statearr_32219_32393 = state_32067__$1;
(statearr_32219_32393[(2)] = inst_31807);

(statearr_32219_32393[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (45))){
var inst_31857 = (state_32067[(28)]);
var state_32067__$1 = state_32067;
var statearr_32220_32394 = state_32067__$1;
(statearr_32220_32394[(2)] = inst_31857);

(statearr_32220_32394[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (53))){
var inst_31794 = (state_32067[(15)]);
var inst_31783 = (state_32067[(16)]);
var inst_31886 = fluree.db.query.schema.pred_objects_unique_QMARK_(inst_31783,inst_31794);
var state_32067__$1 = state_32067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32067__$1,(56),inst_31886);
} else {
if((state_val_32068 === (78))){
var inst_32012 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32221_32395 = state_32067__$1;
(statearr_32221_32395[(2)] = inst_32012);

(statearr_32221_32395[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (26))){
var inst_31828 = (state_32067[(35)]);
var inst_31795 = (state_32067[(10)]);
var inst_31826 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31827 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_31826);
var inst_31828__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$boolean,inst_31827);
var state_32067__$1 = (function (){var statearr_32222 = state_32067;
(statearr_32222[(35)] = inst_31828__$1);

return statearr_32222;
})();
if(inst_31828__$1){
var statearr_32223_32396 = state_32067__$1;
(statearr_32223_32396[(1)] = (29));

} else {
var statearr_32224_32397 = state_32067__$1;
(statearr_32224_32397[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (16))){
var inst_31810 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32225_32398 = state_32067__$1;
(statearr_32225_32398[(2)] = inst_31810);

(statearr_32225_32398[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (81))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31945 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32226_32399 = state_32067__$1;
(statearr_32226_32399[(2)] = inst_31945);

(statearr_32226_32399[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (120))){
var inst_32047 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_32048 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_tx];
var inst_32049 = cljs.core.PersistentHashMap.fromArrays(inst_32047,inst_32048);
var inst_32050 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("A component _predicate must be of type \"ref.\"",inst_32049);
var inst_32051 = (function(){throw inst_32050})();
var state_32067__$1 = state_32067;
var statearr_32227_32400 = state_32067__$1;
(statearr_32227_32400[(2)] = inst_32051);

(statearr_32227_32400[(1)] = (122));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (79))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31939 = [cljs.core.cst$kw$instant,null,cljs.core.cst$kw$int,null];
var inst_31940 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,2,inst_31939,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,2,inst_31939,null));
var inst_31941 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31940,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31940,null));
var inst_31942 = (inst_31941.cljs$core$IFn$_invoke$arity$1 ? inst_31941.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31941.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31942)){
var statearr_32228_32401 = state_32067__$1;
(statearr_32228_32401[(1)] = (80));

} else {
var statearr_32229_32402 = state_32067__$1;
(statearr_32229_32402[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (38))){
var inst_31861 = (state_32067[(36)]);
var inst_31795 = (state_32067[(10)]);
var inst_31860 = cljs.core.cst$kw$new_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31861__$1 = cljs.core.not(inst_31860);
var state_32067__$1 = (function (){var statearr_32230 = state_32067;
(statearr_32230[(36)] = inst_31861__$1);

return statearr_32230;
})();
if(inst_31861__$1){
var statearr_32231_32403 = state_32067__$1;
(statearr_32231_32403[(1)] = (41));

} else {
var statearr_32232_32404 = state_32067__$1;
(statearr_32232_32404[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (98))){
var inst_31987 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32233_32405 = state_32067__$1;
(statearr_32233_32405[(2)] = inst_31987);

(statearr_32233_32405[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (87))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_31959 = [cljs.core.cst$kw$long,null,cljs.core.cst$kw$int,null,cljs.core.cst$kw$float,null];
var inst_31960 = (inst_31927.cljs$core$IFn$_invoke$arity$5 ? inst_31927.cljs$core$IFn$_invoke$arity$5(cljs.core.PersistentArrayMap,null,3,inst_31959,null) : inst_31927.call(null,cljs.core.PersistentArrayMap,null,3,inst_31959,null));
var inst_31961 = (inst_31927.cljs$core$IFn$_invoke$arity$4 ? inst_31927.cljs$core$IFn$_invoke$arity$4(cljs.core.PersistentHashSet,null,inst_31960,null) : inst_31927.call(null,cljs.core.PersistentHashSet,null,inst_31960,null));
var inst_31962 = (inst_31961.cljs$core$IFn$_invoke$arity$1 ? inst_31961.cljs$core$IFn$_invoke$arity$1(inst_31926) : inst_31961.call(null,inst_31926));
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31962)){
var statearr_32234_32406 = state_32067__$1;
(statearr_32234_32406[(1)] = (88));

} else {
var statearr_32235_32407 = state_32067__$1;
(statearr_32235_32407[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (30))){
var inst_31828 = (state_32067[(35)]);
var state_32067__$1 = state_32067;
var statearr_32236_32408 = state_32067__$1;
(statearr_32236_32408[(2)] = inst_31828);

(statearr_32236_32408[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (73))){
var state_32067__$1 = state_32067;
var statearr_32237_32409 = state_32067__$1;
(statearr_32237_32409[(1)] = (75));



return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (96))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32239_32410 = state_32067__$1;
(statearr_32239_32410[(2)] = inst_31914);

(statearr_32239_32410[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (10))){
var inst_32060 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32240_32411 = state_32067__$1;
(statearr_32240_32411[(2)] = inst_32060);

(statearr_32240_32411[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (18))){
var inst_31783 = (state_32067[(16)]);
var state_32067__$1 = state_32067;
var statearr_32241_32412 = state_32067__$1;
(statearr_32241_32412[(2)] = inst_31783);

(statearr_32241_32412[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (105))){
var inst_31927 = (state_32067[(8)]);
var inst_31926 = (state_32067[(9)]);
var inst_32005 = fluree.db.query.schema.type_error.cljs$core$IFn$_invoke$arity$3(inst_31926,inst_31927,throw_QMARK_);
var state_32067__$1 = state_32067;
var statearr_32242_32413 = state_32067__$1;
(statearr_32242_32413[(2)] = inst_32005);

(statearr_32242_32413[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (52))){
var inst_31896 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32243_32414 = state_32067__$1;
(statearr_32243_32414[(2)] = inst_31896);

(statearr_32243_32414[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (114))){
var inst_31795 = (state_32067[(10)]);
var inst_32032 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_32033 = cljs.core.cst$kw$new.cljs$core$IFn$_invoke$arity$1(inst_32032);
var inst_32034 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$ref,inst_32033);
var inst_32035 = (!(inst_32034));
var state_32067__$1 = state_32067;
var statearr_32244_32415 = state_32067__$1;
(statearr_32244_32415[(2)] = inst_32035);

(statearr_32244_32415[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (67))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32245_32416 = state_32067__$1;
(statearr_32245_32416[(2)] = inst_31914);

(statearr_32245_32416[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (71))){
var inst_32019 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32246_32417 = state_32067__$1;
(statearr_32246_32417[(2)] = inst_32019);

(statearr_32246_32417[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (42))){
var inst_31861 = (state_32067[(36)]);
var state_32067__$1 = state_32067;
var statearr_32247_32418 = state_32067__$1;
(statearr_32247_32418[(2)] = inst_31861);

(statearr_32247_32418[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (80))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32248_32419 = state_32067__$1;
(statearr_32248_32419[(2)] = inst_31914);

(statearr_32248_32419[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (37))){
var inst_31854 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32249_32420 = state_32067__$1;
(statearr_32249_32420[(2)] = inst_31854);

(statearr_32249_32420[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (63))){
var inst_31795 = (state_32067[(10)]);
var inst_31917 = cljs.core.cst$kw$type.cljs$core$IFn$_invoke$arity$1(inst_31795);
var inst_31918 = cljs.core.cst$kw$old.cljs$core$IFn$_invoke$arity$1(inst_31917);
var state_32067__$1 = state_32067;
var statearr_32250_32421 = state_32067__$1;
(statearr_32250_32421[(2)] = inst_31918);

(statearr_32250_32421[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (94))){
var inst_31977 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
var statearr_32251_32422 = state_32067__$1;
(statearr_32251_32422[(2)] = inst_31977);

(statearr_32251_32422[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (8))){
var inst_31783 = (state_32067[(16)]);
var state_32067__$1 = state_32067;
var statearr_32252_32423 = state_32067__$1;
(statearr_32252_32423[(2)] = inst_31783);

(statearr_32252_32423[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (49))){
var inst_31899 = (state_32067[(2)]);
var state_32067__$1 = state_32067;
if(cljs.core.truth_(inst_31899)){
var statearr_32253_32424 = state_32067__$1;
(statearr_32253_32424[(1)] = (57));

} else {
var statearr_32254_32425 = state_32067__$1;
(statearr_32254_32425[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32068 === (84))){
var inst_31914 = (state_32067[(12)]);
var state_32067__$1 = state_32067;
var statearr_32255_32426 = state_32067__$1;
(statearr_32255_32426[(2)] = inst_31914);

(statearr_32255_32426[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16395__auto__ = null;
var fluree$db$query$schema$state_machine__16395__auto____0 = (function (){
var statearr_32256 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_32256[(0)] = fluree$db$query$schema$state_machine__16395__auto__);

(statearr_32256[(1)] = (1));

return statearr_32256;
});
var fluree$db$query$schema$state_machine__16395__auto____1 = (function (state_32067){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32067);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32257){var ex__16398__auto__ = e32257;
var statearr_32258_32427 = state_32067;
(statearr_32258_32427[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32067[(4)]))){
var statearr_32259_32428 = state_32067;
(statearr_32259_32428[(1)] = cljs.core.first((state_32067[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32429 = state_32067;
state_32067 = G__32429;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16395__auto__ = function(state_32067){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16395__auto____1.call(this,state_32067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16395__auto____0;
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16395__auto____1;
return fluree$db$query$schema$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32260 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32260[(6)] = c__16469__auto__);

return statearr_32260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.schema.predicate_change_error.cljs$lang$maxFixedArity = 3);

fluree.db.query.schema.validate_schema_change = (function fluree$db$query$schema$validate_schema_change(var_args){
var G__32431 = arguments.length;
switch (G__32431) {
case 3:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$3 = (function (db,tempids,flakes){
return fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4(db,tempids,flakes,true);
}));

(fluree.db.query.schema.validate_schema_change.cljs$core$IFn$_invoke$arity$4 = (function (db,tempids,flakes,filter_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32455){
var state_val_32456 = (state_32455[(1)]);
if((state_val_32456 === (7))){
var state_32455__$1 = state_32455;
var statearr_32457_32477 = state_32455__$1;
(statearr_32457_32477[(2)] = db);

(statearr_32457_32477[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (1))){
var state_32455__$1 = state_32455;
var statearr_32458_32478 = state_32455__$1;
(statearr_32458_32478[(2)] = null);

(statearr_32458_32478[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (4))){
var inst_32432 = (state_32455[(2)]);
var state_32455__$1 = state_32455;
var statearr_32459_32479 = state_32455__$1;
(statearr_32459_32479[(2)] = inst_32432);

(statearr_32459_32479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (6))){
var inst_32441 = (state_32455[(7)]);
var inst_32440 = (state_32455[(2)]);
var inst_32441__$1 = fluree.db.util.async.throw_err(inst_32440);
var inst_32442 = cljs.core.empty_QMARK_(inst_32441__$1);
var state_32455__$1 = (function (){var statearr_32460 = state_32455;
(statearr_32460[(7)] = inst_32441__$1);

return statearr_32460;
})();
if(inst_32442){
var statearr_32461_32480 = state_32455__$1;
(statearr_32461_32480[(1)] = (7));

} else {
var statearr_32462_32481 = state_32455__$1;
(statearr_32462_32481[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (3))){
var inst_32453 = (state_32455[(2)]);
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32455__$1,inst_32453);
} else {
if((state_val_32456 === (2))){
var _ = (function (){var statearr_32464 = state_32455;
(statearr_32464[(4)] = cljs.core.cons((5),(state_32455[(4)])));

return statearr_32464;
})();
var inst_32438 = fluree.db.query.schema.new_pred_changes(db,tempids,flakes,filter_QMARK_);
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32455__$1,(6),inst_32438);
} else {
if((state_val_32456 === (9))){
var inst_32450 = (state_32455[(2)]);
var _ = (function (){var statearr_32465 = state_32455;
(statearr_32465[(4)] = cljs.core.rest((state_32455[(4)])));

return statearr_32465;
})();
var state_32455__$1 = state_32455;
var statearr_32466_32482 = state_32455__$1;
(statearr_32466_32482[(2)] = inst_32450);

(statearr_32466_32482[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (5))){
var _ = (function (){var statearr_32467 = state_32455;
(statearr_32467[(4)] = cljs.core.rest((state_32455[(4)])));

return statearr_32467;
})();
var state_32455__$1 = state_32455;
var ex32463 = (state_32455__$1[(2)]);
var statearr_32468_32483 = state_32455__$1;
(statearr_32468_32483[(5)] = ex32463);


if((ex32463 instanceof Error)){
var statearr_32469_32484 = state_32455__$1;
(statearr_32469_32484[(1)] = (4));

(statearr_32469_32484[(5)] = null);

} else {
throw ex32463;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (10))){
var inst_32447 = (state_32455[(2)]);
var inst_32448 = fluree.db.util.async.throw_err(inst_32447);
var state_32455__$1 = state_32455;
var statearr_32470_32485 = state_32455__$1;
(statearr_32470_32485[(2)] = inst_32448);

(statearr_32470_32485[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32456 === (8))){
var inst_32441 = (state_32455[(7)]);
var inst_32445 = fluree.db.query.schema.predicate_change_error.cljs$core$IFn$_invoke$arity$3(inst_32441,db,true);
var state_32455__$1 = state_32455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32455__$1,(10),inst_32445);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$state_machine__16395__auto__ = null;
var fluree$db$query$schema$state_machine__16395__auto____0 = (function (){
var statearr_32471 = [null,null,null,null,null,null,null,null];
(statearr_32471[(0)] = fluree$db$query$schema$state_machine__16395__auto__);

(statearr_32471[(1)] = (1));

return statearr_32471;
});
var fluree$db$query$schema$state_machine__16395__auto____1 = (function (state_32455){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32455);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32472){var ex__16398__auto__ = e32472;
var statearr_32473_32486 = state_32455;
(statearr_32473_32486[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32455[(4)]))){
var statearr_32474_32487 = state_32455;
(statearr_32474_32487[(1)] = cljs.core.first((state_32455[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32488 = state_32455;
state_32455 = G__32488;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$state_machine__16395__auto__ = function(state_32455){
switch(arguments.length){
case 0:
return fluree$db$query$schema$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$state_machine__16395__auto____1.call(this,state_32455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$state_machine__16395__auto____0;
fluree$db$query$schema$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$state_machine__16395__auto____1;
return fluree$db$query$schema$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32475 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32475[(6)] = c__16469__auto__);

return statearr_32475;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.schema.validate_schema_change.cljs$lang$maxFixedArity = 4);

fluree.db.query.schema.predicate_re = /(?:([^\/]+)\/)([^\/]+)/;
fluree.db.query.schema.pred_reverse_ref_re = /(?:([^\/]+)\/)_([^\/]+)/;
/**
 * Reverse refs must be strings that include a '/_' in them, which characters before and after.
 */
fluree.db.query.schema.reverse_ref_QMARK_ = (function fluree$db$query$schema$reverse_ref_QMARK_(var_args){
var G__32490 = arguments.length;
switch (G__32490) {
case 1:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (predicate_name){
return fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2(predicate_name,false);
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (predicate_name,throw_QMARK_){
if(typeof predicate_name === 'string'){
return cljs.core.boolean$(cljs.core.re_matches(fluree.db.query.schema.pred_reverse_ref_re,predicate_name));
} else {
if(cljs.core.truth_(throw_QMARK_)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
} else {
return false;
}
}
}));

(fluree.db.query.schema.reverse_ref_QMARK_.cljs$lang$maxFixedArity = 2);

/**
 * Reverses an predicate name.
 */
fluree.db.query.schema.reverse_ref = (function fluree$db$query$schema$reverse_ref(predicate_name){
if(typeof predicate_name === 'string'){
var vec__32492 = cljs.core.re_matches(/(?:([^\/]+)\/)?([^\/]+)/,predicate_name);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32492,(0),null);
var ns = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32492,(1),null);
var name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32492,(2),null);
if(cljs.core.truth_(ns)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_",cljs.core.nth.cljs$core$IFn$_invoke$arity$2(name,(0)))){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/",cljs.core.subs.cljs$core$IFn$_invoke$arity$2(name,(1))].join('');
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(ns),"/_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(name)].join('');
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, does not contain a namespace portion: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Bad predicate name, should be string: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([predicate_name], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
});
fluree.db.query.schema.type_sid__GT_type = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(2)),fluree.db.flake.__GT_sid((3),(9)),fluree.db.flake.__GT_sid((3),(14)),fluree.db.flake.__GT_sid((3),(16)),fluree.db.flake.__GT_sid((3),(8)),fluree.db.flake.__GT_sid((3),(4)),fluree.db.flake.__GT_sid((3),(5)),fluree.db.flake.__GT_sid((3),(15)),fluree.db.flake.__GT_sid((3),(17)),fluree.db.flake.__GT_sid((3),(11)),fluree.db.flake.__GT_sid((3),(12)),fluree.db.flake.__GT_sid((3),(1)),fluree.db.flake.__GT_sid((3),(10)),fluree.db.flake.__GT_sid((3),(6)),fluree.db.flake.__GT_sid((3),(7)),fluree.db.flake.__GT_sid((3),(13))],[cljs.core.cst$kw$ref,cljs.core.cst$kw$int,cljs.core.cst$kw$bigdec,cljs.core.cst$kw$json,cljs.core.cst$kw$bytes,cljs.core.cst$kw$boolean,cljs.core.cst$kw$instant,cljs.core.cst$kw$tag,cljs.core.cst$kw$geojson,cljs.core.cst$kw$bigint,cljs.core.cst$kw$float,cljs.core.cst$kw$string,cljs.core.cst$kw$long,cljs.core.cst$kw$uuid,cljs.core.cst$kw$uri,cljs.core.cst$kw$double]);
fluree.db.query.schema.lang_sid__GT_lang = cljs.core.PersistentHashMap.fromArrays([fluree.db.flake.__GT_sid((3),(62)),fluree.db.flake.__GT_sid((3),(68)),fluree.db.flake.__GT_sid((3),(67)),fluree.db.flake.__GT_sid((3),(69)),fluree.db.flake.__GT_sid((3),(63)),fluree.db.flake.__GT_sid((3),(70)),fluree.db.flake.__GT_sid((3),(65)),fluree.db.flake.__GT_sid((3),(66)),fluree.db.flake.__GT_sid((3),(64)),fluree.db.flake.__GT_sid((3),(61))],[cljs.core.cst$kw$bn,cljs.core.cst$kw$hi,cljs.core.cst$kw$fr,cljs.core.cst$kw$id,cljs.core.cst$kw$br,cljs.core.cst$kw$ru,cljs.core.cst$kw$en,cljs.core.cst$kw$es,cljs.core.cst$kw$cn,cljs.core.cst$kw$ar]);
fluree.db.query.schema.flake__GT_pred_map = (function fluree$db$query$schema$flake__GT_pred_map(flakes){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,flake){
var p = flake.p;
var o = flake.o;
var existing_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,p);
if(cljs.core.truth_((function (){var and__4210__auto__ = existing_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.vector_QMARK_(existing_QMARK_);
} else {
return and__4210__auto__;
}
})())){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,cljs.core.conj,o);
} else {
if(cljs.core.truth_(existing_QMARK_)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,p,(function (p1__32495_SHARP_,p2__32496_SHARP_){
return cljs.core.vec(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__32495_SHARP_,p2__32496_SHARP_], null));
}),o);
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,p,o);

}
}
}),cljs.core.PersistentArrayMap.EMPTY,flakes);
});
fluree.db.query.schema.extract_spec_ids = (function fluree$db$query$schema$extract_spec_ids(spec_pid,schema_flakes){
return cljs.core.vec(cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__32497_SHARP_){
var f = p1__32497_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(spec_pid,f.p)){
return f.o;
} else {
return null;
}
}),schema_flakes));
});
/**
 * Returns a map of the schema for a db to allow quick lookups of schema properties.
 *   Schema is a map with keys:
 *   - :t - the 't' value when schema built, allows schema equality checks
 *   - :coll - collection info, mapping cid->name and name->cid all within the same map
 *   - :pred - predicate info, mapping pid->properties and name->properties for quick lookup based on id or name respectively
 *   - :fullText - contains predicate ids that need fulltext search
 *   
 */
fluree.db.query.schema.schema_map = (function fluree$db$query$schema$schema_map(db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32563){
var state_val_32564 = (state_32563[(1)]);
if((state_val_32564 === (1))){
var state_32563__$1 = state_32563;
var statearr_32565_32583 = state_32563__$1;
(statearr_32565_32583[(2)] = null);

(statearr_32565_32583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (2))){
var _ = (function (){var statearr_32566 = state_32563;
(statearr_32566[(4)] = cljs.core.cons((5),(state_32563[(4)])));

return statearr_32566;
})();
var inst_32515 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32516 = fluree.db.flake.max_subject_id((1));
var inst_32517 = [inst_32516];
var inst_32518 = (new cljs.core.PersistentVector(null,1,(5),inst_32515,inst_32517,null));
var inst_32519 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32520 = [(0)];
var inst_32521 = (new cljs.core.PersistentVector(null,1,(5),inst_32519,inst_32520,null));
var inst_32522 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_32518,cljs.core._LT__EQ_,inst_32521);
var state_32563__$1 = state_32563;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32563__$1,(6),inst_32522);
} else {
if((state_val_32564 === (3))){
var inst_32561 = (state_32563[(2)]);
var state_32563__$1 = state_32563;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32563__$1,inst_32561);
} else {
if((state_val_32564 === (4))){
var inst_32503 = (state_32563[(2)]);
var state_32563__$1 = state_32563;
var statearr_32568_32584 = state_32563__$1;
(statearr_32568_32584[(2)] = inst_32503);

(statearr_32568_32584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (5))){
var _ = (function (){var statearr_32569 = state_32563;
(statearr_32569[(4)] = cljs.core.rest((state_32563[(4)])));

return statearr_32569;
})();
var state_32563__$1 = state_32563;
var ex32567 = (state_32563__$1[(2)]);
var statearr_32570_32585 = state_32563__$1;
(statearr_32570_32585[(5)] = ex32567);


if((ex32567 instanceof Error)){
var statearr_32571_32586 = state_32563__$1;
(statearr_32571_32586[(1)] = (4));

(statearr_32571_32586[(5)] = null);

} else {
throw ex32567;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32564 === (6))){
var inst_32524 = (state_32563[(2)]);
var inst_32525 = fluree.db.util.async.throw_err(inst_32524);
var inst_32526 = (function (){var schema_flakes = inst_32525;
return (function (p1__32498_SHARP_){
return (p1__32498_SHARP_.s <= fluree.db.flake.MAX_COLL_SUBJECTS);
});
})();
var inst_32527 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32526,inst_32525);
var inst_32528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32527,(0),null);
var inst_32529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32527,(1),null);
var inst_32530 = (function (){var schema_flakes = inst_32525;
var vec__32509 = inst_32527;
var collection_flakes = inst_32528;
var predicate_flakes = inst_32529;
return (function (acc,coll_flakes){
var first_flake = cljs.core.first(coll_flakes);
var sid = first_flake.s;
var p__GT_v = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__32501_SHARP_,p2__32500_SHARP_){
var f = p2__32500_SHARP_;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__32501_SHARP_,f.p,f.o);
}),cljs.core.PersistentArrayMap.EMPTY,coll_flakes);
var partition = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(47));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return fluree.db.flake.sid__GT_i(sid);
}
})();
var c_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(40));
var specs = (cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(43)))?fluree.db.query.schema.extract_spec_ids((43),coll_flakes):null);
var specDoc = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(44));
var c_props = new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,c_name,cljs.core.cst$kw$sid,sid,cljs.core.cst$kw$spec,specs,cljs.core.cst$kw$specDoc,specDoc,cljs.core.cst$kw$id,partition,cljs.core.cst$kw$partition,partition], null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(acc,partition,c_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([c_name,c_props], 0));
});
})();
var inst_32531 = [(-1),"_tx"];
var inst_32532 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_32533 = ["_tx",(-1),(-1),(-1),null,null];
var inst_32534 = cljs.core.PersistentHashMap.fromArrays(inst_32532,inst_32533);
var inst_32535 = [cljs.core.cst$kw$name,cljs.core.cst$kw$id,cljs.core.cst$kw$sid,cljs.core.cst$kw$partition,cljs.core.cst$kw$spec,cljs.core.cst$kw$specDoc];
var inst_32536 = ["_tx",(-1),(-1),(-1),null,null];
var inst_32537 = cljs.core.PersistentHashMap.fromArrays(inst_32535,inst_32536);
var inst_32538 = [inst_32534,inst_32537];
var inst_32539 = cljs.core.PersistentHashMap.fromArrays(inst_32531,inst_32538);
var inst_32540 = (function (){var schema_flakes = inst_32525;
var vec__32509 = inst_32527;
var collection_flakes = inst_32528;
var predicate_flakes = inst_32529;
return (function (p1__32499_SHARP_){
return p1__32499_SHARP_.s;
});
})();
var inst_32541 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32540,inst_32528);
var inst_32542 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32530,inst_32539,inst_32541);
var inst_32544 = (function (){var schema_flakes = inst_32525;
var vec__32509 = inst_32527;
var collection_flakes = inst_32528;
var predicate_flakes = inst_32529;
var coll = inst_32542;
return (function (p__32543,pred_flakes){
var vec__32572 = p__32543;
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32572,(0),null);
var fullText = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__32572,(1),null);
var first_flake = cljs.core.first(pred_flakes);
var id = first_flake.s;
var p__GT_v = fluree.db.query.schema.flake__GT_pred_map(pred_flakes);
var p_name = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(10));
var p_type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.type_sid__GT_type,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(12)));
var ref_QMARK_ = cljs.core.boolean$((function (){var fexpr__32575 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,null,cljs.core.cst$kw$tag,null], null), null);
return (fexpr__32575.cljs$core$IFn$_invoke$arity$1 ? fexpr__32575.cljs$core$IFn$_invoke$arity$1(p_type) : fexpr__32575.call(null,p_type));
})());
var idx_QMARK_ = cljs.core.boolean$((function (){var or__4212__auto__ = ref_QMARK_;
if(or__4212__auto__){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15));
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13));
}
}
})());
var fullText_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(27));
var p_props = cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$unique,cljs.core.cst$kw$restrictCollection,cljs.core.cst$kw$index,cljs.core.cst$kw$name,cljs.core.cst$kw$noHistory,cljs.core.cst$kw$type,cljs.core.cst$kw$txSpec,cljs.core.cst$kw$component,cljs.core.cst$kw$txSpecDoc,cljs.core.cst$kw$spec,cljs.core.cst$kw$multi,cljs.core.cst$kw$id,cljs.core.cst$kw$specDoc,cljs.core.cst$kw$idx_QMARK_,cljs.core.cst$kw$ref_QMARK_,cljs.core.cst$kw$upsert,cljs.core.cst$kw$retractDuplicates,cljs.core.cst$kw$restrictTag,cljs.core.cst$kw$fullText],[cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(13))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(19)),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(15))),p_name,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(18))),p_type,(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(24)))?fluree.db.query.schema.extract_spec_ids((24),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(17))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(25)),(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(20)))?fluree.db.query.schema.extract_spec_ids((20),pred_flakes):null),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(14))),id,cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(23)),idx_QMARK_,ref_QMARK_,cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(16))),cljs.core.boolean$(cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(29))),cljs.core.get.cljs$core$IFn$_invoke$arity$2(p__GT_v,(26)),fullText_QMARK_]);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(pred,id,p_props,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([p_name,p_props], 0)),(cljs.core.truth_(fullText_QMARK_)?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(fullText,id):fullText)], null);
});
})();
var inst_32545 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32546 = cljs.core.PersistentHashMap.EMPTY;
var inst_32547 = cljs.core.PersistentHashSet.EMPTY;
var inst_32548 = [inst_32546,inst_32547];
var inst_32549 = (new cljs.core.PersistentVector(null,2,(5),inst_32545,inst_32548,null));
var inst_32550 = (function (){var schema_flakes = inst_32525;
var vec__32509 = inst_32527;
var collection_flakes = inst_32528;
var predicate_flakes = inst_32529;
var coll = inst_32542;
return (function (p1__32502_SHARP_){
return p1__32502_SHARP_.s;
});
})();
var inst_32551 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_32550,inst_32529);
var inst_32552 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_32544,inst_32549,inst_32551);
var inst_32553 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32552,(0),null);
var inst_32554 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_32552,(1),null);
var inst_32555 = [cljs.core.cst$kw$t,cljs.core.cst$kw$coll,cljs.core.cst$kw$pred,cljs.core.cst$kw$fullText];
var inst_32556 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_32557 = [inst_32556,inst_32542,inst_32553,inst_32554];
var inst_32558 = cljs.core.PersistentHashMap.fromArrays(inst_32555,inst_32557);
var _ = (function (){var statearr_32576 = state_32563;
(statearr_32576[(4)] = cljs.core.rest((state_32563[(4)])));

return statearr_32576;
})();
var state_32563__$1 = state_32563;
var statearr_32577_32587 = state_32563__$1;
(statearr_32577_32587[(2)] = inst_32558);

(statearr_32577_32587[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0 = (function (){
var statearr_32578 = [null,null,null,null,null,null,null];
(statearr_32578[(0)] = fluree$db$query$schema$schema_map_$_state_machine__16395__auto__);

(statearr_32578[(1)] = (1));

return statearr_32578;
});
var fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1 = (function (state_32563){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32563);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32579){var ex__16398__auto__ = e32579;
var statearr_32580_32588 = state_32563;
(statearr_32580_32588[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32563[(4)]))){
var statearr_32581_32589 = state_32563;
(statearr_32581_32589[(1)] = cljs.core.first((state_32563[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32590 = state_32563;
state_32563 = G__32590;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__ = function(state_32563){
switch(arguments.length){
case 0:
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1.call(this,state_32563);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$schema_map_$_state_machine__16395__auto____0;
fluree$db$query$schema$schema_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$schema_map_$_state_machine__16395__auto____1;
return fluree$db$query$schema$schema_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32582 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32582[(6)] = c__16469__auto__);

return statearr_32582;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.schema.setting_map = (function fluree$db$query$schema$setting_map(db){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32632){
var state_val_32633 = (state_32632[(1)]);
if((state_val_32633 === (7))){
var inst_32615 = (state_32632[(2)]);
var inst_32616 = fluree.db.query.schema.flake__GT_pred_map(inst_32615);
var inst_32617 = [cljs.core.cst$kw$passwords,cljs.core.cst$kw$anonymous,cljs.core.cst$kw$language,cljs.core.cst$kw$ledgers,cljs.core.cst$kw$txMax,cljs.core.cst$kw$consensus];
var inst_32618 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(114));
var inst_32619 = cljs.core.boolean$(inst_32618);
var inst_32620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(110));
var inst_32621 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(117));
var inst_32622 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(fluree.db.query.schema.lang_sid__GT_lang,inst_32621);
var inst_32623 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(111));
var inst_32624 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(115));
var inst_32625 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_32616,(112));
var inst_32626 = [inst_32619,inst_32620,inst_32622,inst_32623,inst_32624,inst_32625];
var inst_32627 = cljs.core.PersistentHashMap.fromArrays(inst_32617,inst_32626);
var _ = (function (){var statearr_32634 = state_32632;
(statearr_32634[(4)] = cljs.core.rest((state_32632[(4)])));

return statearr_32634;
})();
var state_32632__$1 = state_32632;
var statearr_32635_32658 = state_32632__$1;
(statearr_32635_32658[(2)] = inst_32627);

(statearr_32635_32658[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (1))){
var state_32632__$1 = state_32632;
var statearr_32636_32659 = state_32632__$1;
(statearr_32636_32659[(2)] = null);

(statearr_32636_32659[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (4))){
var inst_32591 = (state_32632[(2)]);
var state_32632__$1 = state_32632;
var statearr_32637_32660 = state_32632__$1;
(statearr_32637_32660[(2)] = inst_32591);

(statearr_32637_32660[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (6))){
var _ = (function (){var statearr_32638 = state_32632;
(statearr_32638[(4)] = cljs.core.cons((9),(state_32632[(4)])));

return statearr_32638;
})();
var inst_32603 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32604 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_32605 = ["_setting/id","root"];
var inst_32606 = (new cljs.core.PersistentVector(null,2,(5),inst_32604,inst_32605,null));
var inst_32607 = [inst_32606];
var inst_32608 = (new cljs.core.PersistentVector(null,1,(5),inst_32603,inst_32607,null));
var inst_32609 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_32608);
var state_32632__$1 = state_32632;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32632__$1,(10),inst_32609);
} else {
if((state_val_32633 === (3))){
var inst_32630 = (state_32632[(2)]);
var state_32632__$1 = state_32632;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32632__$1,inst_32630);
} else {
if((state_val_32633 === (2))){
var _ = (function (){var statearr_32641 = state_32632;
(statearr_32641[(4)] = cljs.core.cons((5),(state_32632[(4)])));

return statearr_32641;
})();
var state_32632__$1 = state_32632;
var statearr_32642_32661 = state_32632__$1;
(statearr_32642_32661[(2)] = null);

(statearr_32642_32661[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (9))){
var _ = (function (){var statearr_32643 = state_32632;
(statearr_32643[(4)] = cljs.core.rest((state_32632[(4)])));

return statearr_32643;
})();
var state_32632__$1 = state_32632;
var ex32639 = (state_32632__$1[(2)]);
var statearr_32644_32662 = state_32632__$1;
(statearr_32644_32662[(5)] = ex32639);


var statearr_32645_32663 = state_32632__$1;
(statearr_32645_32663[(1)] = (8));

(statearr_32645_32663[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (5))){
var _ = (function (){var statearr_32646 = state_32632;
(statearr_32646[(4)] = cljs.core.rest((state_32632[(4)])));

return statearr_32646;
})();
var state_32632__$1 = state_32632;
var ex32640 = (state_32632__$1[(2)]);
var statearr_32647_32664 = state_32632__$1;
(statearr_32647_32664[(5)] = ex32640);


if((ex32640 instanceof Error)){
var statearr_32648_32665 = state_32632__$1;
(statearr_32648_32665[(1)] = (4));

(statearr_32648_32665[(5)] = null);

} else {
throw ex32640;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (10))){
var inst_32611 = (state_32632[(2)]);
var inst_32612 = fluree.db.util.async.throw_err(inst_32611);
var _ = (function (){var statearr_32649 = state_32632;
(statearr_32649[(4)] = cljs.core.rest((state_32632[(4)])));

return statearr_32649;
})();
var state_32632__$1 = state_32632;
var statearr_32650_32666 = state_32632__$1;
(statearr_32650_32666[(2)] = inst_32612);

(statearr_32650_32666[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32633 === (8))){
var inst_32597 = (state_32632[(2)]);
var state_32632__$1 = (function (){var statearr_32651 = state_32632;
(statearr_32651[(7)] = inst_32597);

return statearr_32651;
})();
var statearr_32652_32667 = state_32632__$1;
(statearr_32652_32667[(2)] = null);

(statearr_32652_32667[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0 = (function (){
var statearr_32653 = [null,null,null,null,null,null,null,null];
(statearr_32653[(0)] = fluree$db$query$schema$setting_map_$_state_machine__16395__auto__);

(statearr_32653[(1)] = (1));

return statearr_32653;
});
var fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1 = (function (state_32632){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32632);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32654){var ex__16398__auto__ = e32654;
var statearr_32655_32668 = state_32632;
(statearr_32655_32668[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32632[(4)]))){
var statearr_32656_32669 = state_32632;
(statearr_32656_32669[(1)] = cljs.core.first((state_32632[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32670 = state_32632;
state_32632 = G__32670;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__ = function(state_32632){
switch(arguments.length){
case 0:
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1.call(this,state_32632);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$schema$setting_map_$_state_machine__16395__auto____0;
fluree$db$query$schema$setting_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$schema$setting_map_$_state_machine__16395__auto____1;
return fluree$db$query$schema$setting_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32657 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32657[(6)] = c__16469__auto__);

return statearr_32657;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns schema version from a db, which is the :t when the schema was last updated.
 */
fluree.db.query.schema.version = (function fluree$db$query$schema$version(db){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$schema,cljs.core.cst$kw$t], null));
});
