// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.async');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.util.core');
goog.require('cljs.core.async');
goog.require('cljs.core.async.impl.protocols');
fluree.db.util.async.throw_err = (function fluree$db$util$async$throw_err(e){
if((e instanceof Error)){
throw e;
} else {
}

return e;
});
/**
 * Helper method that checks if x is Exception and if yes, wraps it in a new
 *   exception, passing though ex-data if any, and throws it. The wrapping is done
 *   to maintain a full stack trace when jumping between multiple contexts.
 */
fluree.db.util.async.throw_if_exception = (function fluree$db$util$async$throw_if_exception(x){
if((x instanceof Error)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(cljs.core.str.cljs$core$IFn$_invoke$arity$1(x),(function (){var or__4212__auto__ = cljs.core.ex_data(x);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),x);
} else {
return x;
}
});
/**
 * Takes a sequence of single-value chans and returns the conjoined into collection.
 *   Realizes entire channel sequence first, and if an error value exists returns just the exception.
 */
fluree.db.util.async.merge_into_QMARK_ = (function fluree$db$util$async$merge_into_QMARK_(coll,chs){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_26926){
var state_val_26927 = (state_26926[(1)]);
if((state_val_26927 === (7))){
var inst_26921 = (state_26926[(2)]);
var _ = (function (){var statearr_26928 = state_26926;
(statearr_26928[(4)] = cljs.core.rest((state_26926[(4)])));

return statearr_26928;
})();
var state_26926__$1 = state_26926;
var statearr_26929_26951 = state_26926__$1;
(statearr_26929_26951[(2)] = inst_26921);

(statearr_26929_26951[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (1))){
var state_26926__$1 = state_26926;
var statearr_26930_26952 = state_26926__$1;
(statearr_26930_26952[(2)] = null);

(statearr_26930_26952[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (4))){
var inst_26883 = (state_26926[(2)]);
var state_26926__$1 = state_26926;
var statearr_26931_26953 = state_26926__$1;
(statearr_26931_26953[(2)] = inst_26883);

(statearr_26931_26953[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (6))){
var inst_26908 = (state_26926[(7)]);
var inst_26901 = (state_26926[(8)]);
var inst_26907 = cljs.core.seq(inst_26901);
var inst_26908__$1 = cljs.core.first(inst_26907);
var inst_26909 = cljs.core.next(inst_26907);
var inst_26910 = cljs.core.not(inst_26908__$1);
var state_26926__$1 = (function (){var statearr_26932 = state_26926;
(statearr_26932[(7)] = inst_26908__$1);

(statearr_26932[(9)] = inst_26909);

return statearr_26932;
})();
if(inst_26910){
var statearr_26933_26954 = state_26926__$1;
(statearr_26933_26954[(1)] = (8));

} else {
var statearr_26934_26955 = state_26926__$1;
(statearr_26934_26955[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (3))){
var inst_26924 = (state_26926[(2)]);
var state_26926__$1 = state_26926;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26926__$1,inst_26924);
} else {
if((state_val_26927 === (2))){
var _ = (function (){var statearr_26935 = state_26926;
(statearr_26935[(4)] = cljs.core.cons((5),(state_26926[(4)])));

return statearr_26935;
})();
var inst_26896 = chs;
var inst_26897 = cljs.core.seq(inst_26896);
var inst_26898 = cljs.core.first(inst_26897);
var inst_26899 = cljs.core.next(inst_26897);
var inst_26900 = coll;
var inst_26901 = inst_26896;
var inst_26902 = inst_26900;
var state_26926__$1 = (function (){var statearr_26936 = state_26926;
(statearr_26936[(8)] = inst_26901);

(statearr_26936[(10)] = inst_26898);

(statearr_26936[(11)] = inst_26902);

(statearr_26936[(12)] = inst_26899);

return statearr_26936;
})();
var statearr_26937_26956 = state_26926__$1;
(statearr_26937_26956[(2)] = null);

(statearr_26937_26956[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (11))){
var inst_26902 = (state_26926[(11)]);
var inst_26909 = (state_26926[(9)]);
var inst_26914 = (state_26926[(2)]);
var inst_26915 = fluree.db.util.async.throw_err(inst_26914);
var inst_26916 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26902,inst_26915);
var inst_26901 = inst_26909;
var inst_26902__$1 = inst_26916;
var state_26926__$1 = (function (){var statearr_26939 = state_26926;
(statearr_26939[(8)] = inst_26901);

(statearr_26939[(11)] = inst_26902__$1);

return statearr_26939;
})();
var statearr_26940_26957 = state_26926__$1;
(statearr_26940_26957[(2)] = null);

(statearr_26940_26957[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (9))){
var inst_26908 = (state_26926[(7)]);
var state_26926__$1 = state_26926;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26926__$1,(11),inst_26908);
} else {
if((state_val_26927 === (5))){
var _ = (function (){var statearr_26941 = state_26926;
(statearr_26941[(4)] = cljs.core.rest((state_26926[(4)])));

return statearr_26941;
})();
var state_26926__$1 = state_26926;
var ex26938 = (state_26926__$1[(2)]);
var statearr_26942_26958 = state_26926__$1;
(statearr_26942_26958[(5)] = ex26938);


var statearr_26943_26959 = state_26926__$1;
(statearr_26943_26959[(1)] = (4));

(statearr_26943_26959[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (10))){
var inst_26919 = (state_26926[(2)]);
var state_26926__$1 = state_26926;
var statearr_26944_26960 = state_26926__$1;
(statearr_26944_26960[(2)] = inst_26919);

(statearr_26944_26960[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26927 === (8))){
var inst_26902 = (state_26926[(11)]);
var state_26926__$1 = state_26926;
var statearr_26945_26961 = state_26926__$1;
(statearr_26945_26961[(2)] = inst_26902);

(statearr_26945_26961[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_26946 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_26946[(0)] = fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__);

(statearr_26946[(1)] = (1));

return statearr_26946;
});
var fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____1 = (function (state_26926){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_26926);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e26947){var ex__16398__auto__ = e26947;
var statearr_26948_26962 = state_26926;
(statearr_26948_26962[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_26926[(4)]))){
var statearr_26949_26963 = state_26926;
(statearr_26949_26963[(1)] = cljs.core.first((state_26926[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__26964 = state_26926;
state_26926 = G__26964;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__ = function(state_26926){
switch(arguments.length){
case 0:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____1.call(this,state_26926);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____0;
fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto____1;
return fluree$db$util$async$merge_into_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_26950 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_26950[(6)] = c__16469__auto__);

return statearr_26950;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Like async/into, but checks each item for an error response and returns exception
 *   onto the response channel instead of results if there is one.
 */
fluree.db.util.async.into_QMARK_ = (function fluree$db$util$async$into_QMARK_(coll,chan){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_26990){
var state_val_26991 = (state_26990[(1)]);
if((state_val_26991 === (7))){
var inst_26985 = (state_26990[(2)]);
var _ = (function (){var statearr_26992 = state_26990;
(statearr_26992[(4)] = cljs.core.rest((state_26990[(4)])));

return statearr_26992;
})();
var state_26990__$1 = state_26990;
var statearr_26993_27015 = state_26990__$1;
(statearr_26993_27015[(2)] = inst_26985);

(statearr_26993_27015[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (1))){
var state_26990__$1 = state_26990;
var statearr_26994_27016 = state_26990__$1;
(statearr_26994_27016[(2)] = null);

(statearr_26994_27016[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (4))){
var inst_26965 = (state_26990[(2)]);
var state_26990__$1 = state_26990;
var statearr_26995_27017 = state_26990__$1;
(statearr_26995_27017[(2)] = inst_26965);

(statearr_26995_27017[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (6))){
var state_26990__$1 = state_26990;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_26990__$1,(8),chan);
} else {
if((state_val_26991 === (3))){
var inst_26988 = (state_26990[(2)]);
var state_26990__$1 = state_26990;
return cljs.core.async.impl.ioc_helpers.return_chan(state_26990__$1,inst_26988);
} else {
if((state_val_26991 === (2))){
var _ = (function (){var statearr_26996 = state_26990;
(statearr_26996[(4)] = cljs.core.cons((5),(state_26990[(4)])));

return statearr_26996;
})();
var inst_26971 = coll;
var inst_26972 = inst_26971;
var state_26990__$1 = (function (){var statearr_26997 = state_26990;
(statearr_26997[(7)] = inst_26972);

return statearr_26997;
})();
var statearr_26998_27018 = state_26990__$1;
(statearr_26998_27018[(2)] = null);

(statearr_26998_27018[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (11))){
var inst_26983 = (state_26990[(2)]);
var state_26990__$1 = state_26990;
var statearr_27000_27019 = state_26990__$1;
(statearr_27000_27019[(2)] = inst_26983);

(statearr_27000_27019[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (9))){
var inst_26972 = (state_26990[(7)]);
var state_26990__$1 = state_26990;
var statearr_27001_27020 = state_26990__$1;
(statearr_27001_27020[(2)] = inst_26972);

(statearr_27001_27020[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (5))){
var _ = (function (){var statearr_27002 = state_26990;
(statearr_27002[(4)] = cljs.core.rest((state_26990[(4)])));

return statearr_27002;
})();
var state_26990__$1 = state_26990;
var ex26999 = (state_26990__$1[(2)]);
var statearr_27003_27021 = state_26990__$1;
(statearr_27003_27021[(5)] = ex26999);


var statearr_27004_27022 = state_26990__$1;
(statearr_27004_27022[(1)] = (4));

(statearr_27004_27022[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (10))){
var inst_26976 = (state_26990[(8)]);
var inst_26972 = (state_26990[(7)]);
var inst_26980 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_26972,inst_26976);
var inst_26972__$1 = inst_26980;
var state_26990__$1 = (function (){var statearr_27005 = state_26990;
(statearr_27005[(7)] = inst_26972__$1);

return statearr_27005;
})();
var statearr_27006_27023 = state_26990__$1;
(statearr_27006_27023[(2)] = null);

(statearr_27006_27023[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_26991 === (8))){
var inst_26976 = (state_26990[(8)]);
var inst_26975 = (state_26990[(2)]);
var inst_26976__$1 = fluree.db.util.async.throw_err(inst_26975);
var inst_26977 = (inst_26976__$1 == null);
var state_26990__$1 = (function (){var statearr_27007 = state_26990;
(statearr_27007[(8)] = inst_26976__$1);

return statearr_27007;
})();
if(cljs.core.truth_(inst_26977)){
var statearr_27008_27024 = state_26990__$1;
(statearr_27008_27024[(1)] = (9));

} else {
var statearr_27009_27025 = state_26990__$1;
(statearr_27009_27025[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_27010 = [null,null,null,null,null,null,null,null,null];
(statearr_27010[(0)] = fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__);

(statearr_27010[(1)] = (1));

return statearr_27010;
});
var fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____1 = (function (state_26990){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_26990);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e27011){var ex__16398__auto__ = e27011;
var statearr_27012_27026 = state_26990;
(statearr_27012_27026[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_26990[(4)]))){
var statearr_27013_27027 = state_26990;
(statearr_27013_27027[(1)] = cljs.core.first((state_26990[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__27028 = state_26990;
state_26990 = G__27028;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__ = function(state_26990){
switch(arguments.length){
case 0:
return fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____1.call(this,state_26990);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____0;
fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$util$async$into_QMARK__$_state_machine__16395__auto____1;
return fluree$db$util$async$into_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_27014 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_27014[(6)] = c__16469__auto__);

return statearr_27014;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns true if core async channel.
 */
fluree.db.util.async.channel_QMARK_ = (function fluree$db$util$async$channel_QMARK_(x){
if((!((x == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === x.cljs$core$async$impl$protocols$Channel$)))){
return true;
} else {
if((!x.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.Channel,x);
}
});
