// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.util.schema');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.constants');
fluree.db.util.schema.schema_sid_start = fluree.db.flake.min_subject_id((0));
fluree.db.util.schema.schema_sid_end = fluree.db.flake.max_subject_id((1));
fluree.db.util.schema.collection_sid_start = fluree.db.flake.min_subject_id((1));
fluree.db.util.schema.collection_sid_end = fluree.db.flake.max_subject_id((1));
fluree.db.util.schema.predicate_sid_start = fluree.db.flake.min_subject_id((0));
fluree.db.util.schema.predicate_sid_end = fluree.db.flake.max_subject_id((0));
fluree.db.util.schema.setting_sid_start = fluree.db.flake.min_subject_id((9));
fluree.db.util.schema.setting_sid_end = fluree.db.flake.max_subject_id((9));
fluree.db.util.schema.auth_sid_start = fluree.db.flake.min_subject_id((6));
fluree.db.util.schema.auth_sid_end = fluree.db.flake.max_subject_id((6));
fluree.db.util.schema.role_sid_start = fluree.db.flake.min_subject_id((7));
fluree.db.util.schema.role_sid_end = fluree.db.flake.max_subject_id((7));
fluree.db.util.schema.rule_sid_start = fluree.db.flake.min_subject_id((8));
fluree.db.util.schema.rule_sid_end = fluree.db.flake.max_subject_id((8));
fluree.db.util.schema.fn_sid_start = fluree.db.flake.min_subject_id((4));
fluree.db.util.schema.fn_sid_end = fluree.db.flake.max_subject_id((4));
fluree.db.util.schema.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.util.schema.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if this flake is for tx-meta
 */
fluree.db.util.schema.is_tx_meta_flake_QMARK_ = (function fluree$db$util$schema$is_tx_meta_flake_QMARK_(f){
return (f.s < (0));
});
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_schema_flake_QMARK_ = (function fluree$db$util$schema$is_schema_flake_QMARK_(f){
return (((fluree.db.util.schema.schema_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.schema_sid_end)));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_setting_flake_QMARK_ = (function fluree$db$util$schema$is_setting_flake_QMARK_(f){
return (((fluree.db.util.schema.setting_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.setting_sid_end)));
});
/**
 * Returns true if flake is a language flake.
 */
fluree.db.util.schema.is_language_flake_QMARK_ = (function fluree$db$util$schema$is_language_flake_QMARK_(f){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(117));
});
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.util.schema.is_genesis_flake_QMARK_ = (function fluree$db$util$schema$is_genesis_flake_QMARK_(f){
if((((fluree.db.util.schema.tag_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.tag_sid_end)))){
return true;
} else {
if(fluree.db.util.schema.is_setting_flake_QMARK_(f)){
return true;
} else {
if((((fluree.db.util.schema.auth_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.auth_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.role_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.role_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.rule_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.rule_sid_end)))){
return true;
} else {
if((((fluree.db.util.schema.fn_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.fn_sid_end)))){
return true;
} else {
if((((((fluree.db.util.schema.collection_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.collection_sid_end)))) && ((fluree.db.flake.sid__GT_i(f.s) <= (9))))){
return true;
} else {
if((((((fluree.db.util.schema.predicate_sid_start <= f.s)) && ((f.s <= fluree.db.util.schema.predicate_sid_end)))) && ((fluree.db.flake.sid__GT_i(f.s) <= (999))))){
return true;
} else {
return false;

}
}
}
}
}
}
}
}
});
fluree.db.util.schema.add_to_post_preds_QMARK_ = (function fluree$db$util$schema$add_to_post_preds_QMARK_(flakes,pred_ecount){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__28757_SHARP_){
var f = p1__28757_SHARP_;
if(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(15))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(13))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,true)) && ((pred_ecount >= f.s)))))){
return f.s;
} else {
return null;
}
}),flakes);
});
/**
 * Returns any predicate subject flakes that are removing
 *   an existing index, either via index: true or unique: true.
 */
fluree.db.util.schema.remove_from_post_preds = (function fluree$db$util$schema$remove_from_post_preds(flakes){
return cljs.core.keep.cljs$core$IFn$_invoke$arity$2((function (p1__28758_SHARP_){
var f = p1__28758_SHARP_;
if(((f.op === true) && (((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(15))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(13))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,false)))))){
return f.s;
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if any of the provided flakes are a schema flake.
 */
fluree.db.util.schema.schema_change_QMARK_ = (function fluree$db$util$schema$schema_change_QMARK_(flakes){
return cljs.core.some(fluree.db.util.schema.is_schema_flake_QMARK_,flakes);
});
fluree.db.util.schema.setting_change_QMARK_ = (function fluree$db$util$schema$setting_change_QMARK_(flakes){
return cljs.core.some(fluree.db.util.schema.is_setting_flake_QMARK_,flakes);
});
/**
 * Returns the language being added, if any. Else returns nil.
 */
fluree.db.util.schema.get_language_change = (function fluree$db$util$schema$get_language_change(flakes){
return cljs.core.some((function (p1__28759_SHARP_){
var f = p1__28759_SHARP_;
if(((fluree.db.util.schema.is_language_flake_QMARK_(f)) && (((fluree.db.util.schema.is_setting_flake_QMARK_(f)) && (f.op === true))))){
return f.o;
} else {
return null;
}
}),flakes);
});
/**
 * Returns true if flake is a schema flake.
 */
fluree.db.util.schema.is_pred_flake_QMARK_ = (function fluree$db$util$schema$is_pred_flake_QMARK_(f){
return (((fluree.db.flake.MIN_PREDICATE_ID <= f.s)) && ((f.s <= fluree.db.flake.MAX_PREDICATE_ID)));
});
/**
 * Returns true if there are any predicate changes present in set of flakes.
 */
fluree.db.util.schema.pred_change_QMARK_ = (function fluree$db$util$schema$pred_change_QMARK_(flakes){
return cljs.core.some(fluree.db.util.schema.is_pred_flake_QMARK_,flakes);
});
