// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('instaparse.failure');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('instaparse.print');
/**
 * Takes an index into text, and determines the line and column info
 */
instaparse.failure.index__GT_line_column = (function instaparse$failure$index__GT_line_column(index,text){
var line = (1);
var col = (1);
var counter = (0);
while(true){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(index,counter)){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$line,line,cljs.core.cst$kw$column,col], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.get.cljs$core$IFn$_invoke$arity$2(text,counter))){
var G__76478 = (line + (1));
var G__76479 = (1);
var G__76480 = (counter + (1));
line = G__76478;
col = G__76479;
counter = G__76480;
continue;
} else {
var G__76481 = line;
var G__76482 = (col + (1));
var G__76483 = (counter + (1));
line = G__76481;
col = G__76482;
counter = G__76483;
continue;

}
}
break;
}
});
instaparse.failure.get_line = (function instaparse$failure$get_line(n,text){
var chars = cljs.core.seq(clojure.string.replace(text,"\r\n","\n"));
var n__$1 = n;
while(true){
if(cljs.core.empty_QMARK_(chars)){
return "";
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n__$1,(1))){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, ["\n",null], null), null)),chars));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("\n",cljs.core.first(chars))){
var G__76484 = cljs.core.next(chars);
var G__76485 = (n__$1 - (1));
chars = G__76484;
n__$1 = G__76485;
continue;
} else {
var G__76486 = cljs.core.next(chars);
var G__76487 = n__$1;
chars = G__76486;
n__$1 = G__76487;
continue;

}
}
}
break;
}
});
/**
 * Creates string with caret at nth position, 1-based
 */
instaparse.failure.marker = (function instaparse$failure$marker(n){
if(cljs.core.integer_QMARK_(n)){
if((n <= (1))){
return "^";
} else {
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$2((n - (1))," "),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["^"], null)));
}
} else {
return null;
}
});
/**
 * Adds text, line, and column info to failure object.
 */
instaparse.failure.augment_failure = (function instaparse$failure$augment_failure(failure,text){
var lc = instaparse.failure.index__GT_line_column(cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1(failure),text);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([failure,lc,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$text,instaparse.failure.get_line(cljs.core.cst$kw$line.cljs$core$IFn$_invoke$arity$1(lc),text)], null)], 0));
});
/**
 * Provides special case for printing negative lookahead reasons
 */
instaparse.failure.print_reason = (function instaparse$failure$print_reason(r){
if(cljs.core.truth_(cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r))){
cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["NOT "], 0));

return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$NOT.cljs$core$IFn$_invoke$arity$1(r)], 0));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$char_DASH_range.cljs$core$IFn$_invoke$arity$1(r))){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.char_range__GT_str(r)], 0));
} else {
if((r instanceof RegExp)){
return cljs.core.print.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.print.regexp__GT_str(r)], 0));
} else {
return cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([r], 0));

}
}
}
});
/**
 * Takes an augmented failure object and prints the error message
 */
instaparse.failure.pprint_failure = (function instaparse$failure$pprint_failure(p__76488){
var map__76489 = p__76488;
var map__76489__$1 = cljs.core.__destructure_map(map__76489);
var line = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76489__$1,cljs.core.cst$kw$line);
var column = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76489__$1,cljs.core.cst$kw$column);
var text = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76489__$1,cljs.core.cst$kw$text);
var reason = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__76489__$1,cljs.core.cst$kw$reason);
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([["Parse error at line ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(line),", column ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(column),":"].join('')], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([text], 0));

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([instaparse.failure.marker(column)], 0));

var full_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$full,reason)));
var partial_reasons = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$expecting,cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(cljs.core.cst$kw$full),reason)));
var total = (cljs.core.count(full_reasons) + cljs.core.count(partial_reasons));
if((total === (0))){
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),total)){
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected:"], 0));
} else {
cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Expected one of:"], 0));

}
}

var seq__76490_76498 = cljs.core.seq(full_reasons);
var chunk__76491_76499 = null;
var count__76492_76500 = (0);
var i__76493_76501 = (0);
while(true){
if((i__76493_76501 < count__76492_76500)){
var r_76502 = chunk__76491_76499.cljs$core$IIndexed$_nth$arity$2(null,i__76493_76501);
instaparse.failure.print_reason(r_76502);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76503 = seq__76490_76498;
var G__76504 = chunk__76491_76499;
var G__76505 = count__76492_76500;
var G__76506 = (i__76493_76501 + (1));
seq__76490_76498 = G__76503;
chunk__76491_76499 = G__76504;
count__76492_76500 = G__76505;
i__76493_76501 = G__76506;
continue;
} else {
var temp__5753__auto___76507 = cljs.core.seq(seq__76490_76498);
if(temp__5753__auto___76507){
var seq__76490_76508__$1 = temp__5753__auto___76507;
if(cljs.core.chunked_seq_QMARK_(seq__76490_76508__$1)){
var c__4638__auto___76509 = cljs.core.chunk_first(seq__76490_76508__$1);
var G__76510 = cljs.core.chunk_rest(seq__76490_76508__$1);
var G__76511 = c__4638__auto___76509;
var G__76512 = cljs.core.count(c__4638__auto___76509);
var G__76513 = (0);
seq__76490_76498 = G__76510;
chunk__76491_76499 = G__76511;
count__76492_76500 = G__76512;
i__76493_76501 = G__76513;
continue;
} else {
var r_76514 = cljs.core.first(seq__76490_76508__$1);
instaparse.failure.print_reason(r_76514);

cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([" (followed by end-of-string)"], 0));


var G__76515 = cljs.core.next(seq__76490_76508__$1);
var G__76516 = null;
var G__76517 = (0);
var G__76518 = (0);
seq__76490_76498 = G__76515;
chunk__76491_76499 = G__76516;
count__76492_76500 = G__76517;
i__76493_76501 = G__76518;
continue;
}
} else {
}
}
break;
}

var seq__76494 = cljs.core.seq(partial_reasons);
var chunk__76495 = null;
var count__76496 = (0);
var i__76497 = (0);
while(true){
if((i__76497 < count__76496)){
var r = chunk__76495.cljs$core$IIndexed$_nth$arity$2(null,i__76497);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76519 = seq__76494;
var G__76520 = chunk__76495;
var G__76521 = count__76496;
var G__76522 = (i__76497 + (1));
seq__76494 = G__76519;
chunk__76495 = G__76520;
count__76496 = G__76521;
i__76497 = G__76522;
continue;
} else {
var temp__5753__auto__ = cljs.core.seq(seq__76494);
if(temp__5753__auto__){
var seq__76494__$1 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__76494__$1)){
var c__4638__auto__ = cljs.core.chunk_first(seq__76494__$1);
var G__76523 = cljs.core.chunk_rest(seq__76494__$1);
var G__76524 = c__4638__auto__;
var G__76525 = cljs.core.count(c__4638__auto__);
var G__76526 = (0);
seq__76494 = G__76523;
chunk__76495 = G__76524;
count__76496 = G__76525;
i__76497 = G__76526;
continue;
} else {
var r = cljs.core.first(seq__76494__$1);
instaparse.failure.print_reason(r);

cljs.core.println();


var G__76527 = cljs.core.next(seq__76494__$1);
var G__76528 = null;
var G__76529 = (0);
var G__76530 = (0);
seq__76494 = G__76527;
chunk__76495 = G__76528;
count__76496 = G__76529;
i__76497 = G__76530;
continue;
}
} else {
return null;
}
}
break;
}
});
