// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.dbfunctions.fns');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbfunctions.internal');
goog.require('fluree.db.util.log');
goog.require('fluree.db.util.json');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
var ret__4867__auto___69165 = /**
 * Resolves a value if a channel.
 *   Must be used inside of a go-block.
 */
fluree.db.dbfunctions.fns.extract = (function fluree$db$dbfunctions$fns$extract(_AMPERSAND_form,_AMPERSAND_env,v){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic((new cljs.core.List(null,cljs.core.cst$sym$if,null,(1),null)),(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$util$async_SLASH_channel_QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([(new cljs.core.List(null,cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2((new cljs.core.List(null,cljs.core.cst$sym$fluree$db$dbfunctions$fns_SLASH__LT__QMARK_,null,(1),null)),(new cljs.core.List(null,v,null,(1),null))))),null,(1),null)),(new cljs.core.List(null,v,null,(1),null))], 0))));
});
(fluree.db.dbfunctions.fns.extract.cljs$lang$macro = true);

/**
 * Coerces args that may be core async channels into values.
 *   Returns exception instead of args if any exception occurs during resolution.
 */
fluree.db.dbfunctions.fns.coerce_args = (function fluree$db$dbfunctions$fns$coerce_args(args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69216){
var state_val_69217 = (state_69216[(1)]);
if((state_val_69217 === (7))){
var inst_69211 = (state_69216[(2)]);
var _ = (function (){var statearr_69218 = state_69216;
(statearr_69218[(4)] = cljs.core.rest((state_69216[(4)])));

return statearr_69218;
})();
var state_69216__$1 = state_69216;
var statearr_69219_69246 = state_69216__$1;
(statearr_69219_69246[(2)] = inst_69211);

(statearr_69219_69246[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (1))){
var state_69216__$1 = state_69216;
var statearr_69220_69247 = state_69216__$1;
(statearr_69220_69247[(2)] = null);

(statearr_69220_69247[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (4))){
var inst_69166 = (state_69216[(2)]);
var state_69216__$1 = state_69216;
var statearr_69221_69248 = state_69216__$1;
(statearr_69221_69248[(2)] = inst_69166);

(statearr_69221_69248[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (13))){
var inst_69207 = (state_69216[(2)]);
var state_69216__$1 = state_69216;
var statearr_69222_69249 = state_69216__$1;
(statearr_69222_69249[(2)] = inst_69207);

(statearr_69222_69249[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (6))){
var inst_69184 = (state_69216[(7)]);
var inst_69191 = (state_69216[(8)]);
var inst_69190 = cljs.core.seq(inst_69184);
var inst_69191__$1 = cljs.core.first(inst_69190);
var inst_69192 = cljs.core.next(inst_69190);
var inst_69193 = cljs.core.not(inst_69191__$1);
var state_69216__$1 = (function (){var statearr_69223 = state_69216;
(statearr_69223[(9)] = inst_69192);

(statearr_69223[(8)] = inst_69191__$1);

return statearr_69223;
})();
if(inst_69193){
var statearr_69224_69250 = state_69216__$1;
(statearr_69224_69250[(1)] = (8));

} else {
var statearr_69225_69251 = state_69216__$1;
(statearr_69225_69251[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (3))){
var inst_69214 = (state_69216[(2)]);
var state_69216__$1 = state_69216;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69216__$1,inst_69214);
} else {
if((state_val_69217 === (12))){
var inst_69192 = (state_69216[(9)]);
var inst_69191 = (state_69216[(8)]);
var inst_69185 = (state_69216[(10)]);
var inst_69204 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69185,inst_69191);
var inst_69184 = inst_69192;
var inst_69185__$1 = inst_69204;
var state_69216__$1 = (function (){var statearr_69226 = state_69216;
(statearr_69226[(7)] = inst_69184);

(statearr_69226[(10)] = inst_69185__$1);

return statearr_69226;
})();
var statearr_69227_69252 = state_69216__$1;
(statearr_69227_69252[(2)] = null);

(statearr_69227_69252[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (2))){
var _ = (function (){var statearr_69228 = state_69216;
(statearr_69228[(4)] = cljs.core.cons((5),(state_69216[(4)])));

return statearr_69228;
})();
var inst_69179 = args;
var inst_69180 = cljs.core.seq(inst_69179);
var inst_69181 = cljs.core.first(inst_69180);
var inst_69182 = cljs.core.next(inst_69180);
var inst_69183 = cljs.core.PersistentVector.EMPTY;
var inst_69184 = inst_69179;
var inst_69185 = inst_69183;
var state_69216__$1 = (function (){var statearr_69229 = state_69216;
(statearr_69229[(11)] = inst_69182);

(statearr_69229[(7)] = inst_69184);

(statearr_69229[(12)] = inst_69181);

(statearr_69229[(10)] = inst_69185);

return statearr_69229;
})();
var statearr_69230_69253 = state_69216__$1;
(statearr_69230_69253[(2)] = null);

(statearr_69230_69253[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (11))){
var inst_69191 = (state_69216[(8)]);
var state_69216__$1 = state_69216;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69216__$1,(14),inst_69191);
} else {
if((state_val_69217 === (9))){
var inst_69191 = (state_69216[(8)]);
var inst_69196 = fluree.db.util.async.channel_QMARK_(inst_69191);
var state_69216__$1 = state_69216;
if(inst_69196){
var statearr_69232_69254 = state_69216__$1;
(statearr_69232_69254[(1)] = (11));

} else {
var statearr_69233_69255 = state_69216__$1;
(statearr_69233_69255[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (5))){
var _ = (function (){var statearr_69234 = state_69216;
(statearr_69234[(4)] = cljs.core.rest((state_69216[(4)])));

return statearr_69234;
})();
var state_69216__$1 = state_69216;
var ex69231 = (state_69216__$1[(2)]);
var statearr_69235_69256 = state_69216__$1;
(statearr_69235_69256[(5)] = ex69231);


if((ex69231 instanceof Error)){
var statearr_69236_69257 = state_69216__$1;
(statearr_69236_69257[(1)] = (4));

(statearr_69236_69257[(5)] = null);

} else {
throw ex69231;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (14))){
var inst_69192 = (state_69216[(9)]);
var inst_69185 = (state_69216[(10)]);
var inst_69199 = (state_69216[(2)]);
var inst_69200 = fluree.db.util.async.throw_err(inst_69199);
var inst_69201 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_69185,inst_69200);
var inst_69184 = inst_69192;
var inst_69185__$1 = inst_69201;
var state_69216__$1 = (function (){var statearr_69237 = state_69216;
(statearr_69237[(7)] = inst_69184);

(statearr_69237[(10)] = inst_69185__$1);

return statearr_69237;
})();
var statearr_69238_69258 = state_69216__$1;
(statearr_69238_69258[(2)] = null);

(statearr_69238_69258[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (10))){
var inst_69209 = (state_69216[(2)]);
var state_69216__$1 = state_69216;
var statearr_69239_69259 = state_69216__$1;
(statearr_69239_69259[(2)] = inst_69209);

(statearr_69239_69259[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69217 === (8))){
var inst_69185 = (state_69216[(10)]);
var state_69216__$1 = state_69216;
var statearr_69240_69260 = state_69216__$1;
(statearr_69240_69260[(2)] = inst_69185);

(statearr_69240_69260[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0 = (function (){
var statearr_69241 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_69241[(0)] = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__);

(statearr_69241[(1)] = (1));

return statearr_69241;
});
var fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1 = (function (state_69216){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69216);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69242){var ex__16398__auto__ = e69242;
var statearr_69243_69261 = state_69216;
(statearr_69243_69261[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69216[(4)]))){
var statearr_69244_69262 = state_69216;
(statearr_69244_69262[(1)] = cljs.core.first((state_69216[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69263 = state_69216;
state_69216 = G__69263;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__ = function(state_69216){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1.call(this,state_69216);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$coerce_args_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69245 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69245[(6)] = c__16469__auto__);

return statearr_69245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns the current stack.
 */
fluree.db.dbfunctions.fns.stack = (function fluree$db$dbfunctions$fns$stack(_QMARK_ctx){
return cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(cljs.core.deref(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx)));
});
/**
 * Adds an entry to the current stack.
 */
fluree.db.dbfunctions.fns.add_stack = (function fluree$db$dbfunctions$fns$add_stack(_QMARK_ctx,entry){
var vec__69264 = entry;
var res = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69264,(0),null);
var cost = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__69264,(1),null);
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Smart function stack: ",res], 0));

return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$state.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),(function (s){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(s,cljs.core.cst$kw$stack,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$stack.cljs$core$IFn$_invoke$arity$1(s),entry),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits,fluree.db.dbfunctions.internal._.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$credits.cljs$core$IFn$_invoke$arity$1(s),cost], 0)),cljs.core.cst$kw$spent,fluree.db.dbfunctions.internal._PLUS_.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$spent.cljs$core$IFn$_invoke$arity$1(s),cost], 0))], 0));
}));
});
/**
 * Throws an exception with the provided message.
 */
fluree.db.dbfunctions.fns.raise = (function fluree$db$dbfunctions$fns$raise(_QMARK_ctx,msg){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(msg,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_fn,cljs.core.cst$kw$stack,fluree.db.dbfunctions.fns.stack(_QMARK_ctx)], null));
});
/**
 * Returns the nth item in a collection
 */
fluree.db.dbfunctions.fns.nth = (function fluree$db$dbfunctions$fns$nth(_QMARK_ctx,coll,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69312){
var state_val_69313 = (state_69312[(1)]);
if((state_val_69313 === (7))){
var state_69312__$1 = state_69312;
var statearr_69314_69343 = state_69312__$1;
(statearr_69314_69343[(2)] = coll);

(statearr_69314_69343[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (1))){
var state_69312__$1 = state_69312;
var statearr_69315_69344 = state_69312__$1;
(statearr_69315_69344[(2)] = null);

(statearr_69315_69344[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (4))){
var inst_69267 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
var statearr_69316_69345 = state_69312__$1;
(statearr_69316_69345[(2)] = inst_69267);

(statearr_69316_69345[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (15))){
var inst_69286 = (state_69312[(7)]);
var inst_69294 = (state_69312[(2)]);
var inst_69295 = fluree.db.dbfunctions.internal.nth(inst_69286,inst_69294);
var inst_69296 = cljs.core.count(inst_69286);
var inst_69297 = ((9) + inst_69296);
var inst_69298 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69299 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69300 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69301 = [inst_69286,inst_69294];
var inst_69302 = (new cljs.core.PersistentVector(null,2,(5),inst_69300,inst_69301,null));
var inst_69303 = ["nth",inst_69302,inst_69295];
var inst_69304 = cljs.core.PersistentHashMap.fromArrays(inst_69299,inst_69303);
var inst_69305 = [inst_69304,inst_69297];
var inst_69306 = (new cljs.core.PersistentVector(null,2,(5),inst_69298,inst_69305,null));
var inst_69307 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69306);
var _ = (function (){var statearr_69317 = state_69312;
(statearr_69317[(4)] = cljs.core.rest((state_69312[(4)])));

return statearr_69317;
})();
var state_69312__$1 = (function (){var statearr_69318 = state_69312;
(statearr_69318[(8)] = inst_69307);

return statearr_69318;
})();
var statearr_69319_69346 = state_69312__$1;
(statearr_69319_69346[(2)] = inst_69295);

(statearr_69319_69346[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (13))){
var state_69312__$1 = state_69312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69312__$1,(16),key);
} else {
if((state_val_69313 === (6))){
var state_69312__$1 = state_69312;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69312__$1,(9),coll);
} else {
if((state_val_69313 === (3))){
var inst_69310 = (state_69312[(2)]);
var state_69312__$1 = state_69312;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69312__$1,inst_69310);
} else {
if((state_val_69313 === (12))){
var inst_69286 = (state_69312[(2)]);
var inst_69287 = fluree.db.util.async.channel_QMARK_(key);
var state_69312__$1 = (function (){var statearr_69320 = state_69312;
(statearr_69320[(7)] = inst_69286);

return statearr_69320;
})();
if(inst_69287){
var statearr_69321_69347 = state_69312__$1;
(statearr_69321_69347[(1)] = (13));

} else {
var statearr_69322_69348 = state_69312__$1;
(statearr_69322_69348[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (2))){
var _ = (function (){var statearr_69323 = state_69312;
(statearr_69323[(4)] = cljs.core.cons((5),(state_69312[(4)])));

return statearr_69323;
})();
var inst_69273 = fluree.db.util.async.channel_QMARK_(coll);
var state_69312__$1 = state_69312;
if(inst_69273){
var statearr_69324_69349 = state_69312__$1;
(statearr_69324_69349[(1)] = (6));

} else {
var statearr_69325_69350 = state_69312__$1;
(statearr_69325_69350[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (11))){
var inst_69280 = (state_69312[(9)]);
var state_69312__$1 = state_69312;
var statearr_69327_69351 = state_69312__$1;
(statearr_69327_69351[(2)] = inst_69280);

(statearr_69327_69351[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (9))){
var inst_69276 = (state_69312[(2)]);
var inst_69277 = fluree.db.util.async.throw_err(inst_69276);
var state_69312__$1 = state_69312;
var statearr_69328_69352 = state_69312__$1;
(statearr_69328_69352[(2)] = inst_69277);

(statearr_69328_69352[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (5))){
var _ = (function (){var statearr_69329 = state_69312;
(statearr_69329[(4)] = cljs.core.rest((state_69312[(4)])));

return statearr_69329;
})();
var state_69312__$1 = state_69312;
var ex69326 = (state_69312__$1[(2)]);
var statearr_69330_69353 = state_69312__$1;
(statearr_69330_69353[(5)] = ex69326);


if((ex69326 instanceof Error)){
var statearr_69331_69354 = state_69312__$1;
(statearr_69331_69354[(1)] = (4));

(statearr_69331_69354[(5)] = null);

} else {
throw ex69326;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (14))){
var state_69312__$1 = state_69312;
var statearr_69332_69355 = state_69312__$1;
(statearr_69332_69355[(2)] = key);

(statearr_69332_69355[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (16))){
var inst_69290 = (state_69312[(2)]);
var inst_69291 = fluree.db.util.async.throw_err(inst_69290);
var state_69312__$1 = state_69312;
var statearr_69333_69356 = state_69312__$1;
(statearr_69333_69356[(2)] = inst_69291);

(statearr_69333_69356[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (10))){
var inst_69280 = (state_69312[(9)]);
var inst_69283 = cljs.core.vec(inst_69280);
var state_69312__$1 = state_69312;
var statearr_69334_69357 = state_69312__$1;
(statearr_69334_69357[(2)] = inst_69283);

(statearr_69334_69357[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69313 === (8))){
var inst_69280 = (state_69312[(9)]);
var inst_69280__$1 = (state_69312[(2)]);
var inst_69281 = cljs.core.set_QMARK_(inst_69280__$1);
var state_69312__$1 = (function (){var statearr_69335 = state_69312;
(statearr_69335[(9)] = inst_69280__$1);

return statearr_69335;
})();
if(inst_69281){
var statearr_69336_69358 = state_69312__$1;
(statearr_69336_69358[(1)] = (10));

} else {
var statearr_69337_69359 = state_69312__$1;
(statearr_69337_69359[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0 = (function (){
var statearr_69338 = [null,null,null,null,null,null,null,null,null,null];
(statearr_69338[(0)] = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__);

(statearr_69338[(1)] = (1));

return statearr_69338;
});
var fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1 = (function (state_69312){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69312);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69339){var ex__16398__auto__ = e69339;
var statearr_69340_69360 = state_69312;
(statearr_69340_69360[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69312[(4)]))){
var statearr_69341_69361 = state_69312;
(statearr_69341_69361[(1)] = cljs.core.first((state_69312[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69362 = state_69312;
state_69312 = G__69362;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__ = function(state_69312){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1.call(this,state_69312);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$nth_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69342 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69342[(6)] = c__16469__auto__);

return statearr_69342;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Evaluates test.
 */
fluree.db.dbfunctions.fns.if_else = (function fluree$db$dbfunctions$fns$if_else(_QMARK_ctx,test,t,f){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69423){
var state_val_69424 = (state_69423[(1)]);
if((state_val_69424 === (7))){
var state_69423__$1 = state_69423;
var statearr_69425_69459 = state_69423__$1;
(statearr_69425_69459[(2)] = test);

(statearr_69425_69459[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (20))){
var inst_69397 = (state_69423[(2)]);
var inst_69398 = fluree.db.util.async.throw_err(inst_69397);
var state_69423__$1 = state_69423;
var statearr_69426_69460 = state_69423__$1;
(statearr_69426_69460[(2)] = inst_69398);

(statearr_69426_69460[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (1))){
var state_69423__$1 = state_69423;
var statearr_69427_69461 = state_69423__$1;
(statearr_69427_69461[(2)] = null);

(statearr_69427_69461[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (4))){
var inst_69363 = (state_69423[(2)]);
var state_69423__$1 = state_69423;
var statearr_69428_69462 = state_69423__$1;
(statearr_69428_69462[(2)] = inst_69363);

(statearr_69428_69462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (15))){
var inst_69381 = (state_69423[(7)]);
var inst_69389 = (state_69423[(2)]);
var inst_69390 = [inst_69389,f];
var inst_69391 = (new cljs.core.PersistentVector(null,2,(5),inst_69381,inst_69390,null));
var state_69423__$1 = state_69423;
var statearr_69429_69463 = state_69423__$1;
(statearr_69429_69463[(2)] = inst_69391);

(statearr_69429_69463[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (13))){
var state_69423__$1 = state_69423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69423__$1,(16),t);
} else {
if((state_val_69424 === (6))){
var state_69423__$1 = state_69423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69423__$1,(9),test);
} else {
if((state_val_69424 === (17))){
var state_69423__$1 = state_69423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69423__$1,(20),f);
} else {
if((state_val_69424 === (3))){
var inst_69421 = (state_69423[(2)]);
var state_69423__$1 = state_69423;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69423__$1,inst_69421);
} else {
if((state_val_69424 === (12))){
var inst_69379 = (state_69423[(8)]);
var inst_69405 = (state_69423[(2)]);
var inst_69406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69405,(0),null);
var inst_69407 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69405,(1),null);
var inst_69408 = fluree.db.dbfunctions.internal.if_else(inst_69379,inst_69406,inst_69407);
var inst_69409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69410 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69411 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69412 = [inst_69379,inst_69406,inst_69407];
var inst_69413 = (new cljs.core.PersistentVector(null,3,(5),inst_69411,inst_69412,null));
var inst_69414 = ["if-else",inst_69413,inst_69408];
var inst_69415 = cljs.core.PersistentHashMap.fromArrays(inst_69410,inst_69414);
var inst_69416 = [inst_69415,(10)];
var inst_69417 = (new cljs.core.PersistentVector(null,2,(5),inst_69409,inst_69416,null));
var inst_69418 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69417);
var _ = (function (){var statearr_69430 = state_69423;
(statearr_69430[(4)] = cljs.core.rest((state_69423[(4)])));

return statearr_69430;
})();
var state_69423__$1 = (function (){var statearr_69431 = state_69423;
(statearr_69431[(9)] = inst_69418);

return statearr_69431;
})();
var statearr_69432_69464 = state_69423__$1;
(statearr_69432_69464[(2)] = inst_69408);

(statearr_69432_69464[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (2))){
var _ = (function (){var statearr_69433 = state_69423;
(statearr_69433[(4)] = cljs.core.cons((5),(state_69423[(4)])));

return statearr_69433;
})();
var inst_69372 = fluree.db.util.async.channel_QMARK_(test);
var state_69423__$1 = state_69423;
if(inst_69372){
var statearr_69434_69465 = state_69423__$1;
(statearr_69434_69465[(1)] = (6));

} else {
var statearr_69435_69466 = state_69423__$1;
(statearr_69435_69466[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (19))){
var inst_69393 = (state_69423[(10)]);
var inst_69401 = (state_69423[(2)]);
var inst_69402 = [f,inst_69401];
var inst_69403 = (new cljs.core.PersistentVector(null,2,(5),inst_69393,inst_69402,null));
var state_69423__$1 = state_69423;
var statearr_69436_69467 = state_69423__$1;
(statearr_69436_69467[(2)] = inst_69403);

(statearr_69436_69467[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (11))){
var inst_69393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69394 = fluree.db.util.async.channel_QMARK_(f);
var state_69423__$1 = (function (){var statearr_69438 = state_69423;
(statearr_69438[(10)] = inst_69393);

return statearr_69438;
})();
if(inst_69394){
var statearr_69439_69468 = state_69423__$1;
(statearr_69439_69468[(1)] = (17));

} else {
var statearr_69440_69469 = state_69423__$1;
(statearr_69440_69469[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (9))){
var inst_69375 = (state_69423[(2)]);
var inst_69376 = fluree.db.util.async.throw_err(inst_69375);
var state_69423__$1 = state_69423;
var statearr_69441_69470 = state_69423__$1;
(statearr_69441_69470[(2)] = inst_69376);

(statearr_69441_69470[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (5))){
var _ = (function (){var statearr_69442 = state_69423;
(statearr_69442[(4)] = cljs.core.rest((state_69423[(4)])));

return statearr_69442;
})();
var state_69423__$1 = state_69423;
var ex69437 = (state_69423__$1[(2)]);
var statearr_69443_69471 = state_69423__$1;
(statearr_69443_69471[(5)] = ex69437);


if((ex69437 instanceof Error)){
var statearr_69444_69472 = state_69423__$1;
(statearr_69444_69472[(1)] = (4));

(statearr_69444_69472[(5)] = null);

} else {
throw ex69437;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (14))){
var state_69423__$1 = state_69423;
var statearr_69445_69473 = state_69423__$1;
(statearr_69445_69473[(2)] = t);

(statearr_69445_69473[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (16))){
var inst_69385 = (state_69423[(2)]);
var inst_69386 = fluree.db.util.async.throw_err(inst_69385);
var state_69423__$1 = state_69423;
var statearr_69446_69474 = state_69423__$1;
(statearr_69446_69474[(2)] = inst_69386);

(statearr_69446_69474[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (10))){
var inst_69381 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69382 = fluree.db.util.async.channel_QMARK_(t);
var state_69423__$1 = (function (){var statearr_69447 = state_69423;
(statearr_69447[(7)] = inst_69381);

return statearr_69447;
})();
if(inst_69382){
var statearr_69448_69475 = state_69423__$1;
(statearr_69448_69475[(1)] = (13));

} else {
var statearr_69449_69476 = state_69423__$1;
(statearr_69449_69476[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (18))){
var state_69423__$1 = state_69423;
var statearr_69450_69477 = state_69423__$1;
(statearr_69450_69477[(2)] = f);

(statearr_69450_69477[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69424 === (8))){
var inst_69379 = (state_69423[(8)]);
var inst_69379__$1 = (state_69423[(2)]);
var state_69423__$1 = (function (){var statearr_69451 = state_69423;
(statearr_69451[(8)] = inst_69379__$1);

return statearr_69451;
})();
if(cljs.core.truth_(inst_69379__$1)){
var statearr_69452_69478 = state_69423__$1;
(statearr_69452_69478[(1)] = (10));

} else {
var statearr_69453_69479 = state_69423__$1;
(statearr_69453_69479[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0 = (function (){
var statearr_69454 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_69454[(0)] = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__);

(statearr_69454[(1)] = (1));

return statearr_69454;
});
var fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1 = (function (state_69423){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69423);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69455){var ex__16398__auto__ = e69455;
var statearr_69456_69480 = state_69423;
(statearr_69456_69480[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69423[(4)]))){
var statearr_69457_69481 = state_69423;
(statearr_69457_69481[(1)] = cljs.core.first((state_69423[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69482 = state_69423;
state_69423 = G__69482;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__ = function(state_69423){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1.call(this,state_69423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$if_else_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69458 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69458[(6)] = c__16469__auto__);

return statearr_69458;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * True if nil, else false.
 */
fluree.db.dbfunctions.fns.nil_QMARK_ = (function fluree$db$dbfunctions$fns$nil_QMARK_(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69512){
var state_val_69513 = (state_69512[(1)]);
if((state_val_69513 === (7))){
var state_69512__$1 = state_69512;
var statearr_69514_69533 = state_69512__$1;
(statearr_69514_69533[(2)] = arg);

(statearr_69514_69533[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (1))){
var state_69512__$1 = state_69512;
var statearr_69515_69534 = state_69512__$1;
(statearr_69515_69534[(2)] = null);

(statearr_69515_69534[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (4))){
var inst_69483 = (state_69512[(2)]);
var state_69512__$1 = state_69512;
var statearr_69516_69535 = state_69512__$1;
(statearr_69516_69535[(2)] = inst_69483);

(statearr_69516_69535[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (6))){
var state_69512__$1 = state_69512;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69512__$1,(9),arg);
} else {
if((state_val_69513 === (3))){
var inst_69510 = (state_69512[(2)]);
var state_69512__$1 = state_69512;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69512__$1,inst_69510);
} else {
if((state_val_69513 === (2))){
var _ = (function (){var statearr_69518 = state_69512;
(statearr_69518[(4)] = cljs.core.cons((5),(state_69512[(4)])));

return statearr_69518;
})();
var inst_69489 = fluree.db.util.async.channel_QMARK_(arg);
var state_69512__$1 = state_69512;
if(inst_69489){
var statearr_69519_69536 = state_69512__$1;
(statearr_69519_69536[(1)] = (6));

} else {
var statearr_69520_69537 = state_69512__$1;
(statearr_69520_69537[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (9))){
var inst_69492 = (state_69512[(2)]);
var inst_69493 = fluree.db.util.async.throw_err(inst_69492);
var state_69512__$1 = state_69512;
var statearr_69521_69538 = state_69512__$1;
(statearr_69521_69538[(2)] = inst_69493);

(statearr_69521_69538[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (5))){
var _ = (function (){var statearr_69522 = state_69512;
(statearr_69522[(4)] = cljs.core.rest((state_69512[(4)])));

return statearr_69522;
})();
var state_69512__$1 = state_69512;
var ex69517 = (state_69512__$1[(2)]);
var statearr_69523_69539 = state_69512__$1;
(statearr_69523_69539[(5)] = ex69517);


if((ex69517 instanceof Error)){
var statearr_69524_69540 = state_69512__$1;
(statearr_69524_69540[(1)] = (4));

(statearr_69524_69540[(5)] = null);

} else {
throw ex69517;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69513 === (8))){
var inst_69496 = (state_69512[(2)]);
var inst_69497 = fluree.db.dbfunctions.internal.nil_QMARK_(inst_69496);
var inst_69498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69499 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69500 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69501 = [inst_69496];
var inst_69502 = (new cljs.core.PersistentVector(null,1,(5),inst_69500,inst_69501,null));
var inst_69503 = ["nil?",inst_69502,inst_69497];
var inst_69504 = cljs.core.PersistentHashMap.fromArrays(inst_69499,inst_69503);
var inst_69505 = [inst_69504,(10)];
var inst_69506 = (new cljs.core.PersistentVector(null,2,(5),inst_69498,inst_69505,null));
var inst_69507 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69506);
var _ = (function (){var statearr_69525 = state_69512;
(statearr_69525[(4)] = cljs.core.rest((state_69512[(4)])));

return statearr_69525;
})();
var state_69512__$1 = (function (){var statearr_69526 = state_69512;
(statearr_69526[(7)] = inst_69507);

return statearr_69526;
})();
var statearr_69527_69541 = state_69512__$1;
(statearr_69527_69541[(2)] = inst_69497);

(statearr_69527_69541[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_69528 = [null,null,null,null,null,null,null,null];
(statearr_69528[(0)] = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__);

(statearr_69528[(1)] = (1));

return statearr_69528;
});
var fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1 = (function (state_69512){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69512);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69529){var ex__16398__auto__ = e69529;
var statearr_69530_69542 = state_69512;
(statearr_69530_69542[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69512[(4)]))){
var statearr_69531_69543 = state_69512;
(statearr_69531_69543[(1)] = cljs.core.first((state_69512[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69544 = state_69512;
state_69512 = G__69544;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__ = function(state_69512){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1.call(this,state_69512);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$nil_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69532 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69532[(6)] = c__16469__auto__);

return statearr_69532;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes a boolean, true returns false, false returns true.
 */
fluree.db.dbfunctions.fns.not = (function fluree$db$dbfunctions$fns$not(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69574){
var state_val_69575 = (state_69574[(1)]);
if((state_val_69575 === (7))){
var state_69574__$1 = state_69574;
var statearr_69576_69595 = state_69574__$1;
(statearr_69576_69595[(2)] = arg);

(statearr_69576_69595[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (1))){
var state_69574__$1 = state_69574;
var statearr_69577_69596 = state_69574__$1;
(statearr_69577_69596[(2)] = null);

(statearr_69577_69596[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (4))){
var inst_69545 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
var statearr_69578_69597 = state_69574__$1;
(statearr_69578_69597[(2)] = inst_69545);

(statearr_69578_69597[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (6))){
var state_69574__$1 = state_69574;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69574__$1,(9),arg);
} else {
if((state_val_69575 === (3))){
var inst_69572 = (state_69574[(2)]);
var state_69574__$1 = state_69574;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69574__$1,inst_69572);
} else {
if((state_val_69575 === (2))){
var _ = (function (){var statearr_69580 = state_69574;
(statearr_69580[(4)] = cljs.core.cons((5),(state_69574[(4)])));

return statearr_69580;
})();
var inst_69551 = fluree.db.util.async.channel_QMARK_(arg);
var state_69574__$1 = state_69574;
if(inst_69551){
var statearr_69581_69598 = state_69574__$1;
(statearr_69581_69598[(1)] = (6));

} else {
var statearr_69582_69599 = state_69574__$1;
(statearr_69582_69599[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (9))){
var inst_69554 = (state_69574[(2)]);
var inst_69555 = fluree.db.util.async.throw_err(inst_69554);
var state_69574__$1 = state_69574;
var statearr_69583_69600 = state_69574__$1;
(statearr_69583_69600[(2)] = inst_69555);

(statearr_69583_69600[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (5))){
var _ = (function (){var statearr_69584 = state_69574;
(statearr_69584[(4)] = cljs.core.rest((state_69574[(4)])));

return statearr_69584;
})();
var state_69574__$1 = state_69574;
var ex69579 = (state_69574__$1[(2)]);
var statearr_69585_69601 = state_69574__$1;
(statearr_69585_69601[(5)] = ex69579);


if((ex69579 instanceof Error)){
var statearr_69586_69602 = state_69574__$1;
(statearr_69586_69602[(1)] = (4));

(statearr_69586_69602[(5)] = null);

} else {
throw ex69579;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69575 === (8))){
var inst_69558 = (state_69574[(2)]);
var inst_69559 = fluree.db.dbfunctions.internal.not(inst_69558);
var inst_69560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69561 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69562 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69563 = [inst_69558];
var inst_69564 = (new cljs.core.PersistentVector(null,1,(5),inst_69562,inst_69563,null));
var inst_69565 = ["not?",inst_69564,inst_69559];
var inst_69566 = cljs.core.PersistentHashMap.fromArrays(inst_69561,inst_69565);
var inst_69567 = [inst_69566,(10)];
var inst_69568 = (new cljs.core.PersistentVector(null,2,(5),inst_69560,inst_69567,null));
var inst_69569 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69568);
var _ = (function (){var statearr_69587 = state_69574;
(statearr_69587[(4)] = cljs.core.rest((state_69574[(4)])));

return statearr_69587;
})();
var state_69574__$1 = (function (){var statearr_69588 = state_69574;
(statearr_69588[(7)] = inst_69569);

return statearr_69588;
})();
var statearr_69589_69603 = state_69574__$1;
(statearr_69589_69603[(2)] = inst_69559);

(statearr_69589_69603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0 = (function (){
var statearr_69590 = [null,null,null,null,null,null,null,null];
(statearr_69590[(0)] = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__);

(statearr_69590[(1)] = (1));

return statearr_69590;
});
var fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1 = (function (state_69574){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69574);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69591){var ex__16398__auto__ = e69591;
var statearr_69592_69604 = state_69574;
(statearr_69592_69604[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69574[(4)]))){
var statearr_69593_69605 = state_69574;
(statearr_69593_69605[(1)] = cljs.core.first((state_69574[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69606 = state_69574;
state_69574 = G__69606;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__ = function(state_69574){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1.call(this,state_69574);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$not_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69594 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69594[(6)] = c__16469__auto__);

return statearr_69594;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * True if empty or #{nil}, else false.
 */
fluree.db.dbfunctions.fns.empty_QMARK_ = (function fluree$db$dbfunctions$fns$empty_QMARK_(_QMARK_ctx,arg){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69636){
var state_val_69637 = (state_69636[(1)]);
if((state_val_69637 === (7))){
var state_69636__$1 = state_69636;
var statearr_69638_69657 = state_69636__$1;
(statearr_69638_69657[(2)] = arg);

(statearr_69638_69657[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (1))){
var state_69636__$1 = state_69636;
var statearr_69639_69658 = state_69636__$1;
(statearr_69639_69658[(2)] = null);

(statearr_69639_69658[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (4))){
var inst_69607 = (state_69636[(2)]);
var state_69636__$1 = state_69636;
var statearr_69640_69659 = state_69636__$1;
(statearr_69640_69659[(2)] = inst_69607);

(statearr_69640_69659[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (6))){
var state_69636__$1 = state_69636;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69636__$1,(9),arg);
} else {
if((state_val_69637 === (3))){
var inst_69634 = (state_69636[(2)]);
var state_69636__$1 = state_69636;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69636__$1,inst_69634);
} else {
if((state_val_69637 === (2))){
var _ = (function (){var statearr_69642 = state_69636;
(statearr_69642[(4)] = cljs.core.cons((5),(state_69636[(4)])));

return statearr_69642;
})();
var inst_69613 = fluree.db.util.async.channel_QMARK_(arg);
var state_69636__$1 = state_69636;
if(inst_69613){
var statearr_69643_69660 = state_69636__$1;
(statearr_69643_69660[(1)] = (6));

} else {
var statearr_69644_69661 = state_69636__$1;
(statearr_69644_69661[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (9))){
var inst_69616 = (state_69636[(2)]);
var inst_69617 = fluree.db.util.async.throw_err(inst_69616);
var state_69636__$1 = state_69636;
var statearr_69645_69662 = state_69636__$1;
(statearr_69645_69662[(2)] = inst_69617);

(statearr_69645_69662[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (5))){
var _ = (function (){var statearr_69646 = state_69636;
(statearr_69646[(4)] = cljs.core.rest((state_69636[(4)])));

return statearr_69646;
})();
var state_69636__$1 = state_69636;
var ex69641 = (state_69636__$1[(2)]);
var statearr_69647_69663 = state_69636__$1;
(statearr_69647_69663[(5)] = ex69641);


if((ex69641 instanceof Error)){
var statearr_69648_69664 = state_69636__$1;
(statearr_69648_69664[(1)] = (4));

(statearr_69648_69664[(5)] = null);

} else {
throw ex69641;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69637 === (8))){
var inst_69620 = (state_69636[(2)]);
var inst_69621 = fluree.db.dbfunctions.internal.empty_QMARK_(inst_69620);
var inst_69622 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69623 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69624 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69625 = [inst_69620];
var inst_69626 = (new cljs.core.PersistentVector(null,1,(5),inst_69624,inst_69625,null));
var inst_69627 = ["empty?",inst_69626,inst_69621];
var inst_69628 = cljs.core.PersistentHashMap.fromArrays(inst_69623,inst_69627);
var inst_69629 = [inst_69628,(10)];
var inst_69630 = (new cljs.core.PersistentVector(null,2,(5),inst_69622,inst_69629,null));
var inst_69631 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69630);
var _ = (function (){var statearr_69649 = state_69636;
(statearr_69649[(4)] = cljs.core.rest((state_69636[(4)])));

return statearr_69649;
})();
var state_69636__$1 = (function (){var statearr_69650 = state_69636;
(statearr_69650[(7)] = inst_69631);

return statearr_69650;
})();
var statearr_69651_69665 = state_69636__$1;
(statearr_69651_69665[(2)] = inst_69621);

(statearr_69651_69665[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_69652 = [null,null,null,null,null,null,null,null];
(statearr_69652[(0)] = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__);

(statearr_69652[(1)] = (1));

return statearr_69652;
});
var fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1 = (function (state_69636){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69636);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69653){var ex__16398__auto__ = e69653;
var statearr_69654_69666 = state_69636;
(statearr_69654_69666[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69636[(4)]))){
var statearr_69655_69667 = state_69636;
(statearr_69655_69667[(1)] = cljs.core.first((state_69636[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69668 = state_69636;
state_69636 = G__69668;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__ = function(state_69636){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1.call(this,state_69636);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$empty_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69656 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69656[(6)] = c__16469__auto__);

return statearr_69656;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Concatenates all in sequence.
 */
fluree.db.dbfunctions.fns.str = (function fluree$db$dbfunctions$fns$str(var_args){
var args__4824__auto__ = [];
var len__4818__auto___69713 = arguments.length;
var i__4819__auto___69714 = (0);
while(true){
if((i__4819__auto___69714 < len__4818__auto___69713)){
args__4824__auto__.push((arguments[i__4819__auto___69714]));

var G__69715 = (i__4819__auto___69714 + (1));
i__4819__auto___69714 = G__69715;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.str.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69696){
var state_val_69697 = (state_69696[(1)]);
if((state_val_69697 === (1))){
var state_69696__$1 = state_69696;
var statearr_69698_69716 = state_69696__$1;
(statearr_69698_69716[(2)] = null);

(statearr_69698_69716[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69697 === (2))){
var _ = (function (){var statearr_69699 = state_69696;
(statearr_69699[(4)] = cljs.core.cons((5),(state_69696[(4)])));

return statearr_69699;
})();
var inst_69677 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69696__$1 = state_69696;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69696__$1,(6),inst_69677);
} else {
if((state_val_69697 === (3))){
var inst_69694 = (state_69696[(2)]);
var state_69696__$1 = state_69696;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69696__$1,inst_69694);
} else {
if((state_val_69697 === (4))){
var inst_69671 = (state_69696[(2)]);
var state_69696__$1 = state_69696;
var statearr_69701_69717 = state_69696__$1;
(statearr_69701_69717[(2)] = inst_69671);

(statearr_69701_69717[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69697 === (5))){
var _ = (function (){var statearr_69702 = state_69696;
(statearr_69702[(4)] = cljs.core.rest((state_69696[(4)])));

return statearr_69702;
})();
var state_69696__$1 = state_69696;
var ex69700 = (state_69696__$1[(2)]);
var statearr_69703_69718 = state_69696__$1;
(statearr_69703_69718[(5)] = ex69700);


if((ex69700 instanceof Error)){
var statearr_69704_69719 = state_69696__$1;
(statearr_69704_69719[(1)] = (4));

(statearr_69704_69719[(5)] = null);

} else {
throw ex69700;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69697 === (6))){
var inst_69679 = (state_69696[(2)]);
var inst_69680 = fluree.db.util.async.throw_err(inst_69679);
var inst_69681 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.str,inst_69680);
var inst_69682 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69683 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69684 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69685 = [inst_69680];
var inst_69686 = (new cljs.core.PersistentVector(null,1,(5),inst_69684,inst_69685,null));
var inst_69687 = ["str",inst_69686,inst_69681];
var inst_69688 = cljs.core.PersistentHashMap.fromArrays(inst_69683,inst_69687);
var inst_69689 = [inst_69688,(10)];
var inst_69690 = (new cljs.core.PersistentVector(null,2,(5),inst_69682,inst_69689,null));
var inst_69691 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69690);
var _ = (function (){var statearr_69705 = state_69696;
(statearr_69705[(4)] = cljs.core.rest((state_69696[(4)])));

return statearr_69705;
})();
var state_69696__$1 = (function (){var statearr_69706 = state_69696;
(statearr_69706[(7)] = inst_69691);

return statearr_69706;
})();
var statearr_69707_69720 = state_69696__$1;
(statearr_69707_69720[(2)] = inst_69681);

(statearr_69707_69720[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69708 = [null,null,null,null,null,null,null,null];
(statearr_69708[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69708[(1)] = (1));

return statearr_69708;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69696){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69696);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69709){var ex__16398__auto__ = e69709;
var statearr_69710_69721 = state_69696;
(statearr_69710_69721[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69696[(4)]))){
var statearr_69711_69722 = state_69696;
(statearr_69711_69722[(1)] = cljs.core.first((state_69696[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69723 = state_69696;
state_69696 = G__69723;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69696){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69712 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69712[(6)] = c__16469__auto__);

return statearr_69712;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.str.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.str.cljs$lang$applyTo = (function (seq69669){
var G__69670 = cljs.core.first(seq69669);
var seq69669__$1 = cljs.core.next(seq69669);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__69670,seq69669__$1);
}));

/**
 * Returns substring of a string with a start and optional end integer. Returned string is inclusive of start integer and exclusive of end integer.
 */
fluree.db.dbfunctions.fns.subs = (function fluree$db$dbfunctions$fns$subs(_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69749){
var state_val_69750 = (state_69749[(1)]);
if((state_val_69750 === (1))){
var state_69749__$1 = state_69749;
var statearr_69751_69766 = state_69749__$1;
(statearr_69751_69766[(2)] = null);

(statearr_69751_69766[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69750 === (2))){
var _ = (function (){var statearr_69752 = state_69749;
(statearr_69752[(4)] = cljs.core.cons((5),(state_69749[(4)])));

return statearr_69752;
})();
var inst_69730 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_69749__$1 = state_69749;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69749__$1,(6),inst_69730);
} else {
if((state_val_69750 === (3))){
var inst_69747 = (state_69749[(2)]);
var state_69749__$1 = state_69749;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69749__$1,inst_69747);
} else {
if((state_val_69750 === (4))){
var inst_69724 = (state_69749[(2)]);
var state_69749__$1 = state_69749;
var statearr_69754_69767 = state_69749__$1;
(statearr_69754_69767[(2)] = inst_69724);

(statearr_69754_69767[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69750 === (5))){
var _ = (function (){var statearr_69755 = state_69749;
(statearr_69755[(4)] = cljs.core.rest((state_69749[(4)])));

return statearr_69755;
})();
var state_69749__$1 = state_69749;
var ex69753 = (state_69749__$1[(2)]);
var statearr_69756_69768 = state_69749__$1;
(statearr_69756_69768[(5)] = ex69753);


if((ex69753 instanceof Error)){
var statearr_69757_69769 = state_69749__$1;
(statearr_69757_69769[(1)] = (4));

(statearr_69757_69769[(5)] = null);

} else {
throw ex69753;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69750 === (6))){
var inst_69732 = (state_69749[(2)]);
var inst_69733 = fluree.db.util.async.throw_err(inst_69732);
var inst_69734 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.subs,inst_69733);
var inst_69735 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69736 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69737 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69738 = [inst_69733];
var inst_69739 = (new cljs.core.PersistentVector(null,1,(5),inst_69737,inst_69738,null));
var inst_69740 = ["subs",inst_69739,inst_69734];
var inst_69741 = cljs.core.PersistentHashMap.fromArrays(inst_69736,inst_69740);
var inst_69742 = [inst_69741,(30)];
var inst_69743 = (new cljs.core.PersistentVector(null,2,(5),inst_69735,inst_69742,null));
var inst_69744 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69743);
var _ = (function (){var statearr_69758 = state_69749;
(statearr_69758[(4)] = cljs.core.rest((state_69749[(4)])));

return statearr_69758;
})();
var state_69749__$1 = (function (){var statearr_69759 = state_69749;
(statearr_69759[(7)] = inst_69744);

return statearr_69759;
})();
var statearr_69760_69770 = state_69749__$1;
(statearr_69760_69770[(2)] = inst_69734);

(statearr_69760_69770[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0 = (function (){
var statearr_69761 = [null,null,null,null,null,null,null,null];
(statearr_69761[(0)] = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__);

(statearr_69761[(1)] = (1));

return statearr_69761;
});
var fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1 = (function (state_69749){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69749);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69762){var ex__16398__auto__ = e69762;
var statearr_69763_69771 = state_69749;
(statearr_69763_69771[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69749[(4)]))){
var statearr_69764_69772 = state_69749;
(statearr_69764_69772[(1)] = cljs.core.first((state_69749[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69773 = state_69749;
state_69749 = G__69773;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__ = function(state_69749){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1.call(this,state_69749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$subs_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69765 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69765[(6)] = c__16469__auto__);

return statearr_69765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Makes string lower case
 */
fluree.db.dbfunctions.fns.lower_case = (function fluree$db$dbfunctions$fns$lower_case(_QMARK_ctx,str){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69803){
var state_val_69804 = (state_69803[(1)]);
if((state_val_69804 === (7))){
var state_69803__$1 = state_69803;
var statearr_69805_69824 = state_69803__$1;
(statearr_69805_69824[(2)] = str);

(statearr_69805_69824[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (1))){
var state_69803__$1 = state_69803;
var statearr_69806_69825 = state_69803__$1;
(statearr_69806_69825[(2)] = null);

(statearr_69806_69825[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (4))){
var inst_69774 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
var statearr_69807_69826 = state_69803__$1;
(statearr_69807_69826[(2)] = inst_69774);

(statearr_69807_69826[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (6))){
var state_69803__$1 = state_69803;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69803__$1,(9),str);
} else {
if((state_val_69804 === (3))){
var inst_69801 = (state_69803[(2)]);
var state_69803__$1 = state_69803;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69803__$1,inst_69801);
} else {
if((state_val_69804 === (2))){
var _ = (function (){var statearr_69809 = state_69803;
(statearr_69809[(4)] = cljs.core.cons((5),(state_69803[(4)])));

return statearr_69809;
})();
var inst_69780 = fluree.db.util.async.channel_QMARK_(str);
var state_69803__$1 = state_69803;
if(inst_69780){
var statearr_69810_69827 = state_69803__$1;
(statearr_69810_69827[(1)] = (6));

} else {
var statearr_69811_69828 = state_69803__$1;
(statearr_69811_69828[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (9))){
var inst_69783 = (state_69803[(2)]);
var inst_69784 = fluree.db.util.async.throw_err(inst_69783);
var state_69803__$1 = state_69803;
var statearr_69812_69829 = state_69803__$1;
(statearr_69812_69829[(2)] = inst_69784);

(statearr_69812_69829[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (5))){
var _ = (function (){var statearr_69813 = state_69803;
(statearr_69813[(4)] = cljs.core.rest((state_69803[(4)])));

return statearr_69813;
})();
var state_69803__$1 = state_69803;
var ex69808 = (state_69803__$1[(2)]);
var statearr_69814_69830 = state_69803__$1;
(statearr_69814_69830[(5)] = ex69808);


if((ex69808 instanceof Error)){
var statearr_69815_69831 = state_69803__$1;
(statearr_69815_69831[(1)] = (4));

(statearr_69815_69831[(5)] = null);

} else {
throw ex69808;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69804 === (8))){
var inst_69787 = (state_69803[(2)]);
var inst_69788 = fluree.db.dbfunctions.internal.lower_case(inst_69787);
var inst_69789 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69790 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69791 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69792 = [inst_69787];
var inst_69793 = (new cljs.core.PersistentVector(null,1,(5),inst_69791,inst_69792,null));
var inst_69794 = ["lower-case",inst_69793,inst_69788];
var inst_69795 = cljs.core.PersistentHashMap.fromArrays(inst_69790,inst_69794);
var inst_69796 = [inst_69795,(10)];
var inst_69797 = (new cljs.core.PersistentVector(null,2,(5),inst_69789,inst_69796,null));
var inst_69798 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69797);
var _ = (function (){var statearr_69816 = state_69803;
(statearr_69816[(4)] = cljs.core.rest((state_69803[(4)])));

return statearr_69816;
})();
var state_69803__$1 = (function (){var statearr_69817 = state_69803;
(statearr_69817[(7)] = inst_69798);

return statearr_69817;
})();
var statearr_69818_69832 = state_69803__$1;
(statearr_69818_69832[(2)] = inst_69788);

(statearr_69818_69832[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0 = (function (){
var statearr_69819 = [null,null,null,null,null,null,null,null];
(statearr_69819[(0)] = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__);

(statearr_69819[(1)] = (1));

return statearr_69819;
});
var fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1 = (function (state_69803){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69803);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69820){var ex__16398__auto__ = e69820;
var statearr_69821_69833 = state_69803;
(statearr_69821_69833[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69803[(4)]))){
var statearr_69822_69834 = state_69803;
(statearr_69822_69834[(1)] = cljs.core.first((state_69803[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69835 = state_69803;
state_69803 = G__69835;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__ = function(state_69803){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1.call(this,state_69803);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$lower_case_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69823 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69823[(6)] = c__16469__auto__);

return statearr_69823;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Makes string upper-case
 */
fluree.db.dbfunctions.fns.upper_case = (function fluree$db$dbfunctions$fns$upper_case(_QMARK_ctx,str){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69865){
var state_val_69866 = (state_69865[(1)]);
if((state_val_69866 === (7))){
var state_69865__$1 = state_69865;
var statearr_69867_69886 = state_69865__$1;
(statearr_69867_69886[(2)] = str);

(statearr_69867_69886[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (1))){
var state_69865__$1 = state_69865;
var statearr_69868_69887 = state_69865__$1;
(statearr_69868_69887[(2)] = null);

(statearr_69868_69887[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (4))){
var inst_69836 = (state_69865[(2)]);
var state_69865__$1 = state_69865;
var statearr_69869_69888 = state_69865__$1;
(statearr_69869_69888[(2)] = inst_69836);

(statearr_69869_69888[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (6))){
var state_69865__$1 = state_69865;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69865__$1,(9),str);
} else {
if((state_val_69866 === (3))){
var inst_69863 = (state_69865[(2)]);
var state_69865__$1 = state_69865;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69865__$1,inst_69863);
} else {
if((state_val_69866 === (2))){
var _ = (function (){var statearr_69871 = state_69865;
(statearr_69871[(4)] = cljs.core.cons((5),(state_69865[(4)])));

return statearr_69871;
})();
var inst_69842 = fluree.db.util.async.channel_QMARK_(str);
var state_69865__$1 = state_69865;
if(inst_69842){
var statearr_69872_69889 = state_69865__$1;
(statearr_69872_69889[(1)] = (6));

} else {
var statearr_69873_69890 = state_69865__$1;
(statearr_69873_69890[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (9))){
var inst_69845 = (state_69865[(2)]);
var inst_69846 = fluree.db.util.async.throw_err(inst_69845);
var state_69865__$1 = state_69865;
var statearr_69874_69891 = state_69865__$1;
(statearr_69874_69891[(2)] = inst_69846);

(statearr_69874_69891[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (5))){
var _ = (function (){var statearr_69875 = state_69865;
(statearr_69875[(4)] = cljs.core.rest((state_69865[(4)])));

return statearr_69875;
})();
var state_69865__$1 = state_69865;
var ex69870 = (state_69865__$1[(2)]);
var statearr_69876_69892 = state_69865__$1;
(statearr_69876_69892[(5)] = ex69870);


if((ex69870 instanceof Error)){
var statearr_69877_69893 = state_69865__$1;
(statearr_69877_69893[(1)] = (4));

(statearr_69877_69893[(5)] = null);

} else {
throw ex69870;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69866 === (8))){
var inst_69849 = (state_69865[(2)]);
var inst_69850 = fluree.db.dbfunctions.internal.upper_case(inst_69849);
var inst_69851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69852 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69853 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69854 = [inst_69849];
var inst_69855 = (new cljs.core.PersistentVector(null,1,(5),inst_69853,inst_69854,null));
var inst_69856 = ["upper-case",inst_69855,inst_69850];
var inst_69857 = cljs.core.PersistentHashMap.fromArrays(inst_69852,inst_69856);
var inst_69858 = [inst_69857,(10)];
var inst_69859 = (new cljs.core.PersistentVector(null,2,(5),inst_69851,inst_69858,null));
var inst_69860 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69859);
var _ = (function (){var statearr_69878 = state_69865;
(statearr_69878[(4)] = cljs.core.rest((state_69865[(4)])));

return statearr_69878;
})();
var state_69865__$1 = (function (){var statearr_69879 = state_69865;
(statearr_69879[(7)] = inst_69860);

return statearr_69879;
})();
var statearr_69880_69894 = state_69865__$1;
(statearr_69880_69894[(2)] = inst_69850);

(statearr_69880_69894[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0 = (function (){
var statearr_69881 = [null,null,null,null,null,null,null,null];
(statearr_69881[(0)] = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__);

(statearr_69881[(1)] = (1));

return statearr_69881;
});
var fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1 = (function (state_69865){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69865);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69882){var ex__16398__auto__ = e69882;
var statearr_69883_69895 = state_69865;
(statearr_69883_69895[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69865[(4)]))){
var statearr_69884_69896 = state_69865;
(statearr_69884_69896[(1)] = cljs.core.first((state_69865[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69897 = state_69865;
state_69865 = G__69897;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__ = function(state_69865){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1.call(this,state_69865);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$upper_case_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69885 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69885[(6)] = c__16469__auto__);

return statearr_69885;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current subject id
 */
fluree.db.dbfunctions.fns._QMARK_sid = (function fluree$db$dbfunctions$fns$_QMARK_sid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
var _ = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);
return res;
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
if(cljs.core.truth_(and__4210__auto__)){
return (!(typeof cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null)) === 'string'));
} else {
return and__4210__auto__;
}
})())){
var res = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$s,cljs.core.cst$kw$_id], null));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?sid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?sid from this function interface");

}
}
});
/**
 * Gets current predicate id
 */
fluree.db.dbfunctions.fns._QMARK_pid = (function fluree$db$dbfunctions$fns$_QMARK_pid(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?pid",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pid from this function interface");

}
});
/**
 * Gets current subject.
 */
fluree.db.dbfunctions.fns._QMARK_s = (function fluree$db$dbfunctions$fns$_QMARK_s(var_args){
var G__69899 = arguments.length;
switch (G__69899) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69927){
var state_val_69928 = (state_69927[(1)]);
if((state_val_69928 === (1))){
var state_69927__$1 = state_69927;
var statearr_69929_69945 = state_69927__$1;
(statearr_69929_69945[(2)] = null);

(statearr_69929_69945[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69928 === (2))){
var _ = (function (){var statearr_69930 = state_69927;
(statearr_69930[(4)] = cljs.core.cons((5),(state_69927[(4)])));

return statearr_69930;
})();
var inst_69909 = fluree.db.dbfunctions.internal._QMARK_s.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,additional_select);
var state_69927__$1 = state_69927;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69927__$1,(6),inst_69909);
} else {
if((state_val_69928 === (3))){
var inst_69925 = (state_69927[(2)]);
var state_69927__$1 = state_69927;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69927__$1,inst_69925);
} else {
if((state_val_69928 === (4))){
var inst_69900 = (state_69927[(2)]);
var state_69927__$1 = state_69927;
var statearr_69932_69946 = state_69927__$1;
(statearr_69932_69946[(2)] = inst_69900);

(statearr_69932_69946[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69928 === (5))){
var _ = (function (){var statearr_69933 = state_69927;
(statearr_69933[(4)] = cljs.core.rest((state_69927[(4)])));

return statearr_69933;
})();
var state_69927__$1 = state_69927;
var ex69931 = (state_69927__$1[(2)]);
var statearr_69934_69947 = state_69927__$1;
(statearr_69934_69947[(5)] = ex69931);


if((ex69931 instanceof Error)){
var statearr_69935_69948 = state_69927__$1;
(statearr_69935_69948[(1)] = (4));

(statearr_69935_69948[(5)] = null);

} else {
throw ex69931;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69928 === (6))){
var inst_69911 = (state_69927[(2)]);
var inst_69912 = fluree.db.util.async.throw_err(inst_69911);
var inst_69913 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69912,(0),null);
var inst_69914 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69912,(1),null);
var inst_69915 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69916 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69917 = ["?s","?ctx",inst_69913];
var inst_69918 = cljs.core.PersistentHashMap.fromArrays(inst_69916,inst_69917);
var inst_69919 = ((10) + inst_69914);
var inst_69920 = [inst_69918,inst_69919];
var inst_69921 = (new cljs.core.PersistentVector(null,2,(5),inst_69915,inst_69920,null));
var inst_69922 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69921);
var _ = (function (){var statearr_69936 = state_69927;
(statearr_69936[(4)] = cljs.core.rest((state_69927[(4)])));

return statearr_69936;
})();
var state_69927__$1 = (function (){var statearr_69937 = state_69927;
(statearr_69937[(7)] = inst_69922);

return statearr_69937;
})();
var statearr_69938_69949 = state_69927__$1;
(statearr_69938_69949[(2)] = inst_69913);

(statearr_69938_69949[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_69939 = [null,null,null,null,null,null,null,null];
(statearr_69939[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_69939[(1)] = (1));

return statearr_69939;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69927){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69927);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e69940){var ex__16398__auto__ = e69940;
var statearr_69941_69950 = state_69927;
(statearr_69941_69950[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69927[(4)]))){
var statearr_69942_69951 = state_69927;
(statearr_69942_69951[(1)] = cljs.core.first((state_69927[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__69952 = state_69927;
state_69927 = G__69952;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69927){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69927);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_69943 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_69943[(6)] = c__16469__auto__);

return statearr_69943;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_s.cljs$lang$maxFixedArity = 2);

/**
 * Gets current predicate predicates
 */
fluree.db.dbfunctions.fns._QMARK_p = (function fluree$db$dbfunctions$fns$_QMARK_p(var_args){
var G__69954 = arguments.length;
switch (G__69954) {
case 1:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$1 = (function (_QMARK_ctx){
return fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,null);
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,additional_select){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_69992){
var state_val_69993 = (state_69992[(1)]);
if((state_val_69993 === (7))){
var inst_69985 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?p from this function interface");
var state_69992__$1 = state_69992;
var statearr_69994_70014 = state_69992__$1;
(statearr_69994_70014[(2)] = inst_69985);

(statearr_69994_70014[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (1))){
var state_69992__$1 = state_69992;
var statearr_69995_70015 = state_69992__$1;
(statearr_69995_70015[(2)] = null);

(statearr_69995_70015[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (4))){
var inst_69955 = (state_69992[(2)]);
var state_69992__$1 = state_69992;
var statearr_69996_70016 = state_69992__$1;
(statearr_69996_70016[(2)] = inst_69955);

(statearr_69996_70016[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (6))){
var inst_69966 = fluree.db.dbfunctions.fns.coerce_args(additional_select);
var state_69992__$1 = state_69992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69992__$1,(10),inst_69966);
} else {
if((state_val_69993 === (3))){
var inst_69990 = (state_69992[(2)]);
var state_69992__$1 = state_69992;
return cljs.core.async.impl.ioc_helpers.return_chan(state_69992__$1,inst_69990);
} else {
if((state_val_69993 === (2))){
var _ = (function (){var statearr_69998 = state_69992;
(statearr_69998[(4)] = cljs.core.cons((5),(state_69992[(4)])));

return statearr_69998;
})();
var inst_69961 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_69992__$1 = state_69992;
if(cljs.core.truth_(inst_69961)){
var statearr_69999_70017 = state_69992__$1;
(statearr_69999_70017[(1)] = (6));

} else {
var statearr_70000_70018 = state_69992__$1;
(statearr_70000_70018[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (9))){
var inst_69972 = (state_69992[(2)]);
var inst_69973 = fluree.db.util.async.throw_err(inst_69972);
var inst_69974 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69973,(0),null);
var inst_69975 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_69973,(1),null);
var inst_69976 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_69977 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_69978 = ["?p","?ctx",inst_69974];
var inst_69979 = cljs.core.PersistentHashMap.fromArrays(inst_69977,inst_69978);
var inst_69980 = ((10) + inst_69975);
var inst_69981 = [inst_69979,inst_69980];
var inst_69982 = (new cljs.core.PersistentVector(null,2,(5),inst_69976,inst_69981,null));
var inst_69983 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_69982);
var state_69992__$1 = (function (){var statearr_70001 = state_69992;
(statearr_70001[(7)] = inst_69983);

return statearr_70001;
})();
var statearr_70002_70019 = state_69992__$1;
(statearr_70002_70019[(2)] = inst_69974);

(statearr_70002_70019[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (5))){
var _ = (function (){var statearr_70003 = state_69992;
(statearr_70003[(4)] = cljs.core.rest((state_69992[(4)])));

return statearr_70003;
})();
var state_69992__$1 = state_69992;
var ex69997 = (state_69992__$1[(2)]);
var statearr_70004_70020 = state_69992__$1;
(statearr_70004_70020[(5)] = ex69997);


if((ex69997 instanceof Error)){
var statearr_70005_70021 = state_69992__$1;
(statearr_70005_70021[(1)] = (4));

(statearr_70005_70021[(5)] = null);

} else {
throw ex69997;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_69993 === (10))){
var inst_69968 = (state_69992[(2)]);
var inst_69969 = fluree.db.util.async.throw_err(inst_69968);
var inst_69970 = fluree.db.dbfunctions.internal._QMARK_p.cljs$core$IFn$_invoke$arity$2(_QMARK_ctx,inst_69969);
var state_69992__$1 = state_69992;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_69992__$1,(9),inst_69970);
} else {
if((state_val_69993 === (8))){
var inst_69987 = (state_69992[(2)]);
var _ = (function (){var statearr_70006 = state_69992;
(statearr_70006[(4)] = cljs.core.rest((state_69992[(4)])));

return statearr_70006;
})();
var state_69992__$1 = state_69992;
var statearr_70007_70022 = state_69992__$1;
(statearr_70007_70022[(2)] = inst_69987);

(statearr_70007_70022[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70008 = [null,null,null,null,null,null,null,null];
(statearr_70008[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70008[(1)] = (1));

return statearr_70008;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_69992){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_69992);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70009){var ex__16398__auto__ = e70009;
var statearr_70010_70023 = state_69992;
(statearr_70010_70023[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_69992[(4)]))){
var statearr_70011_70024 = state_69992;
(statearr_70011_70024[(1)] = cljs.core.first((state_69992[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70025 = state_69992;
state_69992 = G__70025;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_69992){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_69992);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70012 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70012[(6)] = c__16469__auto__);

return statearr_70012;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._QMARK_p.cljs$lang$maxFixedArity = 2);

/**
 * Returns true if all in a sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.and = (function fluree$db$dbfunctions$fns$and(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70074 = arguments.length;
var i__4819__auto___70075 = (0);
while(true){
if((i__4819__auto___70075 < len__4818__auto___70074)){
args__4824__auto__.push((arguments[i__4819__auto___70075]));

var G__70076 = (i__4819__auto___70075 + (1));
i__4819__auto___70075 = G__70076;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.and.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70057){
var state_val_70058 = (state_70057[(1)]);
if((state_val_70058 === (1))){
var state_70057__$1 = state_70057;
var statearr_70059_70077 = state_70057__$1;
(statearr_70059_70077[(2)] = null);

(statearr_70059_70077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70058 === (2))){
var _ = (function (){var statearr_70060 = state_70057;
(statearr_70060[(4)] = cljs.core.cons((5),(state_70057[(4)])));

return statearr_70060;
})();
var inst_70034 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70057__$1 = state_70057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70057__$1,(6),inst_70034);
} else {
if((state_val_70058 === (3))){
var inst_70055 = (state_70057[(2)]);
var state_70057__$1 = state_70057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70057__$1,inst_70055);
} else {
if((state_val_70058 === (4))){
var inst_70028 = (state_70057[(2)]);
var state_70057__$1 = state_70057;
var statearr_70062_70078 = state_70057__$1;
(statearr_70062_70078[(2)] = inst_70028);

(statearr_70062_70078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70058 === (5))){
var _ = (function (){var statearr_70063 = state_70057;
(statearr_70063[(4)] = cljs.core.rest((state_70057[(4)])));

return statearr_70063;
})();
var state_70057__$1 = state_70057;
var ex70061 = (state_70057__$1[(2)]);
var statearr_70064_70079 = state_70057__$1;
(statearr_70064_70079[(5)] = ex70061);


if((ex70061 instanceof Error)){
var statearr_70065_70080 = state_70057__$1;
(statearr_70065_70080[(1)] = (4));

(statearr_70065_70080[(5)] = null);

} else {
throw ex70061;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70058 === (6))){
var inst_70036 = (state_70057[(2)]);
var inst_70037 = fluree.db.util.async.throw_err(inst_70036);
var inst_70038 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.and,inst_70037);
var inst_70039 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70040 = [inst_70037];
var inst_70041 = (new cljs.core.PersistentVector(null,1,(5),inst_70039,inst_70040,null));
var inst_70042 = cljs.core.count(inst_70041);
var inst_70043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70044 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70046 = [inst_70037];
var inst_70047 = (new cljs.core.PersistentVector(null,1,(5),inst_70045,inst_70046,null));
var inst_70048 = ["and",inst_70047,inst_70038];
var inst_70049 = cljs.core.PersistentHashMap.fromArrays(inst_70044,inst_70048);
var inst_70050 = [inst_70049,inst_70042];
var inst_70051 = (new cljs.core.PersistentVector(null,2,(5),inst_70043,inst_70050,null));
var inst_70052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70051);
var _ = (function (){var statearr_70066 = state_70057;
(statearr_70066[(4)] = cljs.core.rest((state_70057[(4)])));

return statearr_70066;
})();
var state_70057__$1 = (function (){var statearr_70067 = state_70057;
(statearr_70067[(7)] = inst_70052);

return statearr_70067;
})();
var statearr_70068_70081 = state_70057__$1;
(statearr_70068_70081[(2)] = inst_70038);

(statearr_70068_70081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70069 = [null,null,null,null,null,null,null,null];
(statearr_70069[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70069[(1)] = (1));

return statearr_70069;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70057){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70057);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70070){var ex__16398__auto__ = e70070;
var statearr_70071_70082 = state_70057;
(statearr_70071_70082[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70057[(4)]))){
var statearr_70072_70083 = state_70057;
(statearr_70072_70083[(1)] = cljs.core.first((state_70057[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70084 = state_70057;
state_70057 = G__70084;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70073 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70073[(6)] = c__16469__auto__);

return statearr_70073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.and.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.and.cljs$lang$applyTo = (function (seq70026){
var G__70027 = cljs.core.first(seq70026);
var seq70026__$1 = cljs.core.next(seq70026);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70027,seq70026__$1);
}));

/**
 * Returns true if any in the sequence are true, else returns false
 */
fluree.db.dbfunctions.fns.or = (function fluree$db$dbfunctions$fns$or(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70133 = arguments.length;
var i__4819__auto___70134 = (0);
while(true){
if((i__4819__auto___70134 < len__4818__auto___70133)){
args__4824__auto__.push((arguments[i__4819__auto___70134]));

var G__70135 = (i__4819__auto___70134 + (1));
i__4819__auto___70134 = G__70135;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.or.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70116){
var state_val_70117 = (state_70116[(1)]);
if((state_val_70117 === (1))){
var state_70116__$1 = state_70116;
var statearr_70118_70136 = state_70116__$1;
(statearr_70118_70136[(2)] = null);

(statearr_70118_70136[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70117 === (2))){
var _ = (function (){var statearr_70119 = state_70116;
(statearr_70119[(4)] = cljs.core.cons((5),(state_70116[(4)])));

return statearr_70119;
})();
var inst_70093 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70116__$1 = state_70116;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70116__$1,(6),inst_70093);
} else {
if((state_val_70117 === (3))){
var inst_70114 = (state_70116[(2)]);
var state_70116__$1 = state_70116;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70116__$1,inst_70114);
} else {
if((state_val_70117 === (4))){
var inst_70087 = (state_70116[(2)]);
var state_70116__$1 = state_70116;
var statearr_70121_70137 = state_70116__$1;
(statearr_70121_70137[(2)] = inst_70087);

(statearr_70121_70137[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70117 === (5))){
var _ = (function (){var statearr_70122 = state_70116;
(statearr_70122[(4)] = cljs.core.rest((state_70116[(4)])));

return statearr_70122;
})();
var state_70116__$1 = state_70116;
var ex70120 = (state_70116__$1[(2)]);
var statearr_70123_70138 = state_70116__$1;
(statearr_70123_70138[(5)] = ex70120);


if((ex70120 instanceof Error)){
var statearr_70124_70139 = state_70116__$1;
(statearr_70124_70139[(1)] = (4));

(statearr_70124_70139[(5)] = null);

} else {
throw ex70120;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70117 === (6))){
var inst_70095 = (state_70116[(2)]);
var inst_70096 = fluree.db.util.async.throw_err(inst_70095);
var inst_70097 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.or,inst_70096);
var inst_70098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70099 = [inst_70096];
var inst_70100 = (new cljs.core.PersistentVector(null,1,(5),inst_70098,inst_70099,null));
var inst_70101 = cljs.core.count(inst_70100);
var inst_70102 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70103 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70104 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70105 = [inst_70096];
var inst_70106 = (new cljs.core.PersistentVector(null,1,(5),inst_70104,inst_70105,null));
var inst_70107 = ["or",inst_70106,inst_70097];
var inst_70108 = cljs.core.PersistentHashMap.fromArrays(inst_70103,inst_70107);
var inst_70109 = [inst_70108,inst_70101];
var inst_70110 = (new cljs.core.PersistentVector(null,2,(5),inst_70102,inst_70109,null));
var inst_70111 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70110);
var _ = (function (){var statearr_70125 = state_70116;
(statearr_70125[(4)] = cljs.core.rest((state_70116[(4)])));

return statearr_70125;
})();
var state_70116__$1 = (function (){var statearr_70126 = state_70116;
(statearr_70126[(7)] = inst_70111);

return statearr_70126;
})();
var statearr_70127_70140 = state_70116__$1;
(statearr_70127_70140[(2)] = inst_70097);

(statearr_70127_70140[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70128 = [null,null,null,null,null,null,null,null];
(statearr_70128[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70128[(1)] = (1));

return statearr_70128;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70116){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70116);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70129){var ex__16398__auto__ = e70129;
var statearr_70130_70141 = state_70116;
(statearr_70130_70141[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70116[(4)]))){
var statearr_70131_70142 = state_70116;
(statearr_70131_70142[(1)] = cljs.core.first((state_70116[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70143 = state_70116;
state_70116 = G__70143;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70116){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70116);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70132 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70132[(6)] = c__16469__auto__);

return statearr_70132;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.or.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.or.cljs$lang$applyTo = (function (seq70085){
var G__70086 = cljs.core.first(seq70085);
var seq70085__$1 = cljs.core.next(seq70085);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70086,seq70085__$1);
}));

/**
 * Returns the number of items in the collection. (count nil) returns 0.  Also works on strings, arrays, and Java Collections and Maps
 */
fluree.db.dbfunctions.fns.count = (function fluree$db$dbfunctions$fns$count(_QMARK_ctx,coll){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70181){
var state_val_70182 = (state_70181[(1)]);
if((state_val_70182 === (7))){
var inst_70157 = fluree.db.util.async.channel_QMARK_(coll);
var state_70181__$1 = state_70181;
if(inst_70157){
var statearr_70183_70206 = state_70181__$1;
(statearr_70183_70206[(1)] = (10));

} else {
var statearr_70184_70207 = state_70181__$1;
(statearr_70184_70207[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (1))){
var state_70181__$1 = state_70181;
var statearr_70185_70208 = state_70181__$1;
(statearr_70185_70208[(2)] = null);

(statearr_70185_70208[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (4))){
var inst_70144 = (state_70181[(2)]);
var state_70181__$1 = state_70181;
var statearr_70186_70209 = state_70181__$1;
(statearr_70186_70209[(2)] = inst_70144);

(statearr_70186_70209[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (13))){
var inst_70160 = (state_70181[(2)]);
var inst_70161 = fluree.db.util.async.throw_err(inst_70160);
var state_70181__$1 = state_70181;
var statearr_70187_70210 = state_70181__$1;
(statearr_70187_70210[(2)] = inst_70161);

(statearr_70187_70210[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (6))){
var inst_70152 = fluree.db.dbfunctions.fns.coerce_args(coll);
var state_70181__$1 = state_70181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70181__$1,(9),inst_70152);
} else {
if((state_val_70182 === (3))){
var inst_70179 = (state_70181[(2)]);
var state_70181__$1 = state_70181;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70181__$1,inst_70179);
} else {
if((state_val_70182 === (12))){
var inst_70164 = (state_70181[(2)]);
var state_70181__$1 = state_70181;
var statearr_70188_70211 = state_70181__$1;
(statearr_70188_70211[(2)] = inst_70164);

(statearr_70188_70211[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (2))){
var _ = (function (){var statearr_70189 = state_70181;
(statearr_70189[(4)] = cljs.core.cons((5),(state_70181[(4)])));

return statearr_70189;
})();
var inst_70150 = cljs.core.vector_QMARK_(coll);
var state_70181__$1 = state_70181;
if(inst_70150){
var statearr_70190_70212 = state_70181__$1;
(statearr_70190_70212[(1)] = (6));

} else {
var statearr_70191_70213 = state_70181__$1;
(statearr_70191_70213[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (11))){
var state_70181__$1 = state_70181;
var statearr_70193_70214 = state_70181__$1;
(statearr_70193_70214[(2)] = coll);

(statearr_70193_70214[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (9))){
var inst_70154 = (state_70181[(2)]);
var inst_70155 = fluree.db.util.async.throw_err(inst_70154);
var state_70181__$1 = state_70181;
var statearr_70194_70215 = state_70181__$1;
(statearr_70194_70215[(2)] = inst_70155);

(statearr_70194_70215[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (5))){
var _ = (function (){var statearr_70195 = state_70181;
(statearr_70195[(4)] = cljs.core.rest((state_70181[(4)])));

return statearr_70195;
})();
var state_70181__$1 = state_70181;
var ex70192 = (state_70181__$1[(2)]);
var statearr_70196_70216 = state_70181__$1;
(statearr_70196_70216[(5)] = ex70192);


if((ex70192 instanceof Error)){
var statearr_70197_70217 = state_70181__$1;
(statearr_70197_70217[(1)] = (4));

(statearr_70197_70217[(5)] = null);

} else {
throw ex70192;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70182 === (10))){
var state_70181__$1 = state_70181;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70181__$1,(13),coll);
} else {
if((state_val_70182 === (8))){
var inst_70166 = (state_70181[(2)]);
var inst_70167 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_70166);
var inst_70168 = cljs.core.count(inst_70167);
var inst_70169 = ((9) + inst_70168);
var inst_70170 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70171 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70172 = ["count",inst_70166,inst_70168];
var inst_70173 = cljs.core.PersistentHashMap.fromArrays(inst_70171,inst_70172);
var inst_70174 = [inst_70173,inst_70169];
var inst_70175 = (new cljs.core.PersistentVector(null,2,(5),inst_70170,inst_70174,null));
var inst_70176 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70175);
var _ = (function (){var statearr_70198 = state_70181;
(statearr_70198[(4)] = cljs.core.rest((state_70181[(4)])));

return statearr_70198;
})();
var state_70181__$1 = (function (){var statearr_70199 = state_70181;
(statearr_70199[(7)] = inst_70176);

return statearr_70199;
})();
var statearr_70200_70218 = state_70181__$1;
(statearr_70200_70218[(2)] = inst_70168);

(statearr_70200_70218[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0 = (function (){
var statearr_70201 = [null,null,null,null,null,null,null,null];
(statearr_70201[(0)] = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__);

(statearr_70201[(1)] = (1));

return statearr_70201;
});
var fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1 = (function (state_70181){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70181);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70202){var ex__16398__auto__ = e70202;
var statearr_70203_70219 = state_70181;
(statearr_70203_70219[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70181[(4)]))){
var statearr_70204_70220 = state_70181;
(statearr_70204_70220[(1)] = cljs.core.first((state_70181[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70221 = state_70181;
state_70181 = G__70221;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__ = function(state_70181){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1.call(this,state_70181);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$count_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70205 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70205[(6)] = c__16469__auto__);

return statearr_70205;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets a value from an subject.
 */
fluree.db.dbfunctions.fns.get = (function fluree$db$dbfunctions$fns$get(_QMARK_ctx,subject,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70271){
var state_val_70272 = (state_70271[(1)]);
if((state_val_70272 === (7))){
var state_70271__$1 = state_70271;
var statearr_70273_70306 = state_70271__$1;
(statearr_70273_70306[(2)] = subject);

(statearr_70273_70306[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (1))){
var state_70271__$1 = state_70271;
var statearr_70274_70307 = state_70271__$1;
(statearr_70274_70307[(2)] = null);

(statearr_70274_70307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (4))){
var inst_70222 = (state_70271[(2)]);
var state_70271__$1 = state_70271;
var statearr_70275_70308 = state_70271__$1;
(statearr_70275_70308[(2)] = inst_70222);

(statearr_70275_70308[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (15))){
var inst_70235 = (state_70271[(7)]);
var state_70271__$1 = state_70271;
var statearr_70276_70309 = state_70271__$1;
(statearr_70276_70309[(2)] = inst_70235);

(statearr_70276_70309[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (13))){
var inst_70239 = (state_70271[(2)]);
var inst_70240 = fluree.db.util.async.throw_err(inst_70239);
var state_70271__$1 = state_70271;
var statearr_70277_70310 = state_70271__$1;
(statearr_70277_70310[(2)] = inst_70240);

(statearr_70277_70310[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (6))){
var state_70271__$1 = state_70271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70271__$1,(9),subject);
} else {
if((state_val_70272 === (17))){
var inst_70235 = (state_70271[(7)]);
var inst_70249 = cljs.core.first(inst_70235);
var state_70271__$1 = state_70271;
var statearr_70278_70311 = state_70271__$1;
(statearr_70278_70311[(2)] = inst_70249);

(statearr_70278_70311[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (3))){
var inst_70269 = (state_70271[(2)]);
var state_70271__$1 = state_70271;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70271__$1,inst_70269);
} else {
if((state_val_70272 === (12))){
var inst_70235 = (state_70271[(7)]);
var inst_70243 = (state_70271[(2)]);
var inst_70244 = cljs.core.vector_QMARK_(inst_70235);
var state_70271__$1 = (function (){var statearr_70279 = state_70271;
(statearr_70279[(8)] = inst_70243);

return statearr_70279;
})();
if(inst_70244){
var statearr_70280_70312 = state_70271__$1;
(statearr_70280_70312[(1)] = (14));

} else {
var statearr_70281_70313 = state_70271__$1;
(statearr_70281_70313[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (2))){
var _ = (function (){var statearr_70282 = state_70271;
(statearr_70282[(4)] = cljs.core.cons((5),(state_70271[(4)])));

return statearr_70282;
})();
var inst_70228 = fluree.db.util.async.channel_QMARK_(subject);
var state_70271__$1 = state_70271;
if(inst_70228){
var statearr_70283_70314 = state_70271__$1;
(statearr_70283_70314[(1)] = (6));

} else {
var statearr_70284_70315 = state_70271__$1;
(statearr_70284_70315[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (19))){
var inst_70252 = (state_70271[(2)]);
var state_70271__$1 = state_70271;
var statearr_70285_70316 = state_70271__$1;
(statearr_70285_70316[(2)] = inst_70252);

(statearr_70285_70316[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (11))){
var state_70271__$1 = state_70271;
var statearr_70287_70317 = state_70271__$1;
(statearr_70287_70317[(2)] = pred);

(statearr_70287_70317[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (9))){
var inst_70231 = (state_70271[(2)]);
var inst_70232 = fluree.db.util.async.throw_err(inst_70231);
var state_70271__$1 = state_70271;
var statearr_70288_70318 = state_70271__$1;
(statearr_70288_70318[(2)] = inst_70232);

(statearr_70288_70318[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (5))){
var _ = (function (){var statearr_70289 = state_70271;
(statearr_70289[(4)] = cljs.core.rest((state_70271[(4)])));

return statearr_70289;
})();
var state_70271__$1 = state_70271;
var ex70286 = (state_70271__$1[(2)]);
var statearr_70290_70319 = state_70271__$1;
(statearr_70290_70319[(5)] = ex70286);


if((ex70286 instanceof Error)){
var statearr_70291_70320 = state_70271__$1;
(statearr_70291_70320[(1)] = (4));

(statearr_70291_70320[(5)] = null);

} else {
throw ex70286;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (14))){
var inst_70235 = (state_70271[(7)]);
var inst_70246 = cljs.core.count(inst_70235);
var inst_70247 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70246);
var state_70271__$1 = state_70271;
if(inst_70247){
var statearr_70292_70321 = state_70271__$1;
(statearr_70292_70321[(1)] = (17));

} else {
var statearr_70293_70322 = state_70271__$1;
(statearr_70293_70322[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (16))){
var inst_70235 = (state_70271[(7)]);
var inst_70243 = (state_70271[(8)]);
var inst_70255 = (state_70271[(2)]);
var inst_70256 = fluree.db.dbfunctions.internal.get(inst_70255,inst_70243);
var inst_70257 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70258 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70259 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70260 = [inst_70235,inst_70243];
var inst_70261 = (new cljs.core.PersistentVector(null,2,(5),inst_70259,inst_70260,null));
var inst_70262 = ["get",inst_70261,inst_70256];
var inst_70263 = cljs.core.PersistentHashMap.fromArrays(inst_70258,inst_70262);
var inst_70264 = [inst_70263,(10)];
var inst_70265 = (new cljs.core.PersistentVector(null,2,(5),inst_70257,inst_70264,null));
var inst_70266 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70265);
var _ = (function (){var statearr_70294 = state_70271;
(statearr_70294[(4)] = cljs.core.rest((state_70271[(4)])));

return statearr_70294;
})();
var state_70271__$1 = (function (){var statearr_70295 = state_70271;
(statearr_70295[(9)] = inst_70266);

return statearr_70295;
})();
var statearr_70296_70323 = state_70271__$1;
(statearr_70296_70323[(2)] = inst_70256);

(statearr_70296_70323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (10))){
var state_70271__$1 = state_70271;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70271__$1,(13),pred);
} else {
if((state_val_70272 === (18))){
var inst_70235 = (state_70271[(7)]);
var state_70271__$1 = state_70271;
var statearr_70297_70324 = state_70271__$1;
(statearr_70297_70324[(2)] = inst_70235);

(statearr_70297_70324[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70272 === (8))){
var inst_70235 = (state_70271[(2)]);
var inst_70236 = fluree.db.util.async.channel_QMARK_(pred);
var state_70271__$1 = (function (){var statearr_70298 = state_70271;
(statearr_70298[(7)] = inst_70235);

return statearr_70298;
})();
if(inst_70236){
var statearr_70299_70325 = state_70271__$1;
(statearr_70299_70325[(1)] = (10));

} else {
var statearr_70300_70326 = state_70271__$1;
(statearr_70300_70326[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0 = (function (){
var statearr_70301 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70301[(0)] = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__);

(statearr_70301[(1)] = (1));

return statearr_70301;
});
var fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1 = (function (state_70271){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70271);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70302){var ex__16398__auto__ = e70302;
var statearr_70303_70327 = state_70271;
(statearr_70303_70327[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70271[(4)]))){
var statearr_70304_70328 = state_70271;
(statearr_70304_70328[(1)] = cljs.core.first((state_70271[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70329 = state_70271;
state_70271 = G__70329;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__ = function(state_70271){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1.call(this,state_70271);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70305 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70305[(6)] = c__16469__auto__);

return statearr_70305;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets the object of an predicate from the current subject.
 */
fluree.db.dbfunctions.fns._QMARK_o = (function fluree$db$dbfunctions$fns$_QMARK_o(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$o.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"?o",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(1)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?o from this function interface");
}
});
/**
 * Gets the most recent object of an predicate, as of the previous block
 */
fluree.db.dbfunctions.fns._QMARK_pO = (function fluree$db$dbfunctions$fns$_QMARK_pO(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70368){
var state_val_70369 = (state_70368[(1)]);
if((state_val_70369 === (7))){
var inst_70336 = (state_70368[(7)]);
var state_70368__$1 = state_70368;
var statearr_70370_70394 = state_70368__$1;
(statearr_70370_70394[(2)] = inst_70336);

(statearr_70370_70394[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (1))){
var state_70368__$1 = state_70368;
var statearr_70371_70395 = state_70368__$1;
(statearr_70371_70395[(2)] = null);

(statearr_70371_70395[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (4))){
var inst_70330 = (state_70368[(2)]);
var state_70368__$1 = state_70368;
var statearr_70372_70396 = state_70368__$1;
(statearr_70372_70396[(2)] = inst_70330);

(statearr_70372_70396[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (6))){
var inst_70338 = cljs.core.cst$kw$pid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70368__$1 = state_70368;
var statearr_70373_70397 = state_70368__$1;
(statearr_70373_70397[(2)] = inst_70338);

(statearr_70373_70397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (3))){
var inst_70366 = (state_70368[(2)]);
var state_70368__$1 = state_70368;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70368__$1,inst_70366);
} else {
if((state_val_70369 === (12))){
var inst_70348 = (state_70368[(2)]);
var inst_70349 = fluree.db.util.async.throw_err(inst_70348);
var inst_70350 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70349,(0),null);
var inst_70351 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_70349,(1),null);
var inst_70352 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70353 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70354 = ["?pO","?ctx",inst_70350];
var inst_70355 = cljs.core.PersistentHashMap.fromArrays(inst_70353,inst_70354);
var inst_70356 = ((10) + inst_70351);
var inst_70357 = [inst_70355,inst_70356];
var inst_70358 = (new cljs.core.PersistentVector(null,2,(5),inst_70352,inst_70357,null));
var inst_70359 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70358);
var state_70368__$1 = (function (){var statearr_70374 = state_70368;
(statearr_70374[(8)] = inst_70359);

return statearr_70374;
})();
var statearr_70375_70398 = state_70368__$1;
(statearr_70375_70398[(2)] = inst_70350);

(statearr_70375_70398[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (2))){
var inst_70336 = (state_70368[(7)]);
var _ = (function (){var statearr_70376 = state_70368;
(statearr_70376[(4)] = cljs.core.cons((5),(state_70368[(4)])));

return statearr_70376;
})();
var inst_70336__$1 = cljs.core.cst$kw$sid.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_70368__$1 = (function (){var statearr_70377 = state_70368;
(statearr_70377[(7)] = inst_70336__$1);

return statearr_70377;
})();
if(cljs.core.truth_(inst_70336__$1)){
var statearr_70378_70399 = state_70368__$1;
(statearr_70378_70399[(1)] = (6));

} else {
var statearr_70379_70400 = state_70368__$1;
(statearr_70379_70400[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (11))){
var inst_70363 = (state_70368[(2)]);
var _ = (function (){var statearr_70381 = state_70368;
(statearr_70381[(4)] = cljs.core.rest((state_70368[(4)])));

return statearr_70381;
})();
var state_70368__$1 = state_70368;
var statearr_70382_70401 = state_70368__$1;
(statearr_70382_70401[(2)] = inst_70363);

(statearr_70382_70401[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (9))){
var inst_70346 = fluree.db.dbfunctions.internal._QMARK_pO(_QMARK_ctx);
var state_70368__$1 = state_70368;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70368__$1,(12),inst_70346);
} else {
if((state_val_70369 === (5))){
var _ = (function (){var statearr_70383 = state_70368;
(statearr_70383[(4)] = cljs.core.rest((state_70368[(4)])));

return statearr_70383;
})();
var state_70368__$1 = state_70368;
var ex70380 = (state_70368__$1[(2)]);
var statearr_70384_70402 = state_70368__$1;
(statearr_70384_70402[(5)] = ex70380);


if((ex70380 instanceof Error)){
var statearr_70385_70403 = state_70368__$1;
(statearr_70385_70403[(1)] = (4));

(statearr_70385_70403[(5)] = null);

} else {
throw ex70380;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (10))){
var inst_70361 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?pO from this function interface");
var state_70368__$1 = state_70368;
var statearr_70386_70404 = state_70368__$1;
(statearr_70386_70404[(2)] = inst_70361);

(statearr_70386_70404[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70369 === (8))){
var inst_70341 = (state_70368[(2)]);
var state_70368__$1 = state_70368;
if(cljs.core.truth_(inst_70341)){
var statearr_70387_70405 = state_70368__$1;
(statearr_70387_70405[(1)] = (9));

} else {
var statearr_70388_70406 = state_70368__$1;
(statearr_70388_70406[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0 = (function (){
var statearr_70389 = [null,null,null,null,null,null,null,null,null];
(statearr_70389[(0)] = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__);

(statearr_70389[(1)] = (1));

return statearr_70389;
});
var fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1 = (function (state_70368){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70368);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70390){var ex__16398__auto__ = e70390;
var statearr_70391_70407 = state_70368;
(statearr_70391_70407[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70368[(4)]))){
var statearr_70392_70408 = state_70368;
(statearr_70392_70408[(1)] = cljs.core.first((state_70368[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70409 = state_70368;
state_70368 = G__70409;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__ = function(state_70368){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1.call(this,state_70368);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_pO_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70393 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70393[(6)] = c__16469__auto__);

return statearr_70393;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Follows an subject down the provided path and returns a set of all matching subjects.
 */
fluree.db.dbfunctions.fns.get_all = (function fluree$db$dbfunctions$fns$get_all(_QMARK_ctx,subject,path){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70461){
var state_val_70462 = (state_70461[(1)]);
if((state_val_70462 === (7))){
var state_70461__$1 = state_70461;
var statearr_70463_70496 = state_70461__$1;
(statearr_70463_70496[(2)] = subject);

(statearr_70463_70496[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (1))){
var state_70461__$1 = state_70461;
var statearr_70464_70497 = state_70461__$1;
(statearr_70464_70497[(2)] = null);

(statearr_70464_70497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (4))){
var inst_70410 = (state_70461[(2)]);
var state_70461__$1 = state_70461;
var statearr_70465_70498 = state_70461__$1;
(statearr_70465_70498[(2)] = inst_70410);

(statearr_70465_70498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (15))){
var inst_70423 = (state_70461[(7)]);
var state_70461__$1 = state_70461;
var statearr_70466_70499 = state_70461__$1;
(statearr_70466_70499[(2)] = inst_70423);

(statearr_70466_70499[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (13))){
var inst_70427 = (state_70461[(2)]);
var inst_70428 = fluree.db.util.async.throw_err(inst_70427);
var state_70461__$1 = state_70461;
var statearr_70467_70500 = state_70461__$1;
(statearr_70467_70500[(2)] = inst_70428);

(statearr_70467_70500[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (6))){
var state_70461__$1 = state_70461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70461__$1,(9),subject);
} else {
if((state_val_70462 === (17))){
var inst_70423 = (state_70461[(7)]);
var inst_70437 = cljs.core.first(inst_70423);
var state_70461__$1 = state_70461;
var statearr_70468_70501 = state_70461__$1;
(statearr_70468_70501[(2)] = inst_70437);

(statearr_70468_70501[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (3))){
var inst_70459 = (state_70461[(2)]);
var state_70461__$1 = state_70461;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70461__$1,inst_70459);
} else {
if((state_val_70462 === (12))){
var inst_70423 = (state_70461[(7)]);
var inst_70431 = (state_70461[(2)]);
var inst_70432 = cljs.core.vector_QMARK_(inst_70423);
var state_70461__$1 = (function (){var statearr_70469 = state_70461;
(statearr_70469[(8)] = inst_70431);

return statearr_70469;
})();
if(inst_70432){
var statearr_70470_70502 = state_70461__$1;
(statearr_70470_70502[(1)] = (14));

} else {
var statearr_70471_70503 = state_70461__$1;
(statearr_70471_70503[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (2))){
var _ = (function (){var statearr_70472 = state_70461;
(statearr_70472[(4)] = cljs.core.cons((5),(state_70461[(4)])));

return statearr_70472;
})();
var inst_70416 = fluree.db.util.async.channel_QMARK_(subject);
var state_70461__$1 = state_70461;
if(inst_70416){
var statearr_70473_70504 = state_70461__$1;
(statearr_70473_70504[(1)] = (6));

} else {
var statearr_70474_70505 = state_70461__$1;
(statearr_70474_70505[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (19))){
var inst_70440 = (state_70461[(2)]);
var state_70461__$1 = state_70461;
var statearr_70475_70506 = state_70461__$1;
(statearr_70475_70506[(2)] = inst_70440);

(statearr_70475_70506[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (11))){
var state_70461__$1 = state_70461;
var statearr_70477_70507 = state_70461__$1;
(statearr_70477_70507[(2)] = path);

(statearr_70477_70507[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (9))){
var inst_70419 = (state_70461[(2)]);
var inst_70420 = fluree.db.util.async.throw_err(inst_70419);
var state_70461__$1 = state_70461;
var statearr_70478_70508 = state_70461__$1;
(statearr_70478_70508[(2)] = inst_70420);

(statearr_70478_70508[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (5))){
var _ = (function (){var statearr_70479 = state_70461;
(statearr_70479[(4)] = cljs.core.rest((state_70461[(4)])));

return statearr_70479;
})();
var state_70461__$1 = state_70461;
var ex70476 = (state_70461__$1[(2)]);
var statearr_70480_70509 = state_70461__$1;
(statearr_70480_70509[(5)] = ex70476);


if((ex70476 instanceof Error)){
var statearr_70481_70510 = state_70461__$1;
(statearr_70481_70510[(1)] = (4));

(statearr_70481_70510[(5)] = null);

} else {
throw ex70476;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (14))){
var inst_70423 = (state_70461[(7)]);
var inst_70434 = cljs.core.count(inst_70423);
var inst_70435 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70434);
var state_70461__$1 = state_70461;
if(inst_70435){
var statearr_70482_70511 = state_70461__$1;
(statearr_70482_70511[(1)] = (17));

} else {
var statearr_70483_70512 = state_70461__$1;
(statearr_70483_70512[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (16))){
var inst_70431 = (state_70461[(8)]);
var inst_70423 = (state_70461[(7)]);
var inst_70443 = (state_70461[(2)]);
var inst_70444 = fluree.db.dbfunctions.internal.get_all(inst_70443,inst_70431);
var inst_70445 = cljs.core.count(inst_70431);
var inst_70446 = ((9) + inst_70445);
var inst_70447 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70448 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70449 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70450 = [inst_70423,inst_70431];
var inst_70451 = (new cljs.core.PersistentVector(null,2,(5),inst_70449,inst_70450,null));
var inst_70452 = ["get-all",inst_70451,inst_70444];
var inst_70453 = cljs.core.PersistentHashMap.fromArrays(inst_70448,inst_70452);
var inst_70454 = [inst_70453,inst_70446];
var inst_70455 = (new cljs.core.PersistentVector(null,2,(5),inst_70447,inst_70454,null));
var inst_70456 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70455);
var _ = (function (){var statearr_70484 = state_70461;
(statearr_70484[(4)] = cljs.core.rest((state_70461[(4)])));

return statearr_70484;
})();
var state_70461__$1 = (function (){var statearr_70485 = state_70461;
(statearr_70485[(9)] = inst_70456);

return statearr_70485;
})();
var statearr_70486_70513 = state_70461__$1;
(statearr_70486_70513[(2)] = inst_70444);

(statearr_70486_70513[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (10))){
var state_70461__$1 = state_70461;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70461__$1,(13),path);
} else {
if((state_val_70462 === (18))){
var inst_70423 = (state_70461[(7)]);
var state_70461__$1 = state_70461;
var statearr_70487_70514 = state_70461__$1;
(statearr_70487_70514[(2)] = inst_70423);

(statearr_70487_70514[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70462 === (8))){
var inst_70423 = (state_70461[(2)]);
var inst_70424 = fluree.db.util.async.channel_QMARK_(path);
var state_70461__$1 = (function (){var statearr_70488 = state_70461;
(statearr_70488[(7)] = inst_70423);

return statearr_70488;
})();
if(inst_70424){
var statearr_70489_70515 = state_70461__$1;
(statearr_70489_70515[(1)] = (10));

} else {
var statearr_70490_70516 = state_70461__$1;
(statearr_70490_70516[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0 = (function (){
var statearr_70491 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70491[(0)] = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__);

(statearr_70491[(1)] = (1));

return statearr_70491;
});
var fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1 = (function (state_70461){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70461);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70492){var ex__16398__auto__ = e70492;
var statearr_70493_70517 = state_70461;
(statearr_70493_70517[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70461[(4)]))){
var statearr_70494_70518 = state_70461;
(statearr_70494_70518[(1)] = cljs.core.first((state_70461[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70519 = state_70461;
state_70461 = G__70519;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__ = function(state_70461){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1.call(this,state_70461);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_all_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70495 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70495[(6)] = c__16469__auto__);

return statearr_70495;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns the value of a nested structure
 */
fluree.db.dbfunctions.fns.get_in = (function fluree$db$dbfunctions$fns$get_in(_QMARK_ctx,subject,path){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70558){
var state_val_70559 = (state_70558[(1)]);
if((state_val_70559 === (7))){
var state_70558__$1 = state_70558;
var statearr_70560_70584 = state_70558__$1;
(statearr_70560_70584[(2)] = subject);

(statearr_70560_70584[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (1))){
var state_70558__$1 = state_70558;
var statearr_70561_70585 = state_70558__$1;
(statearr_70561_70585[(2)] = null);

(statearr_70561_70585[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (4))){
var inst_70520 = (state_70558[(2)]);
var state_70558__$1 = state_70558;
var statearr_70562_70586 = state_70558__$1;
(statearr_70562_70586[(2)] = inst_70520);

(statearr_70562_70586[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (13))){
var inst_70537 = (state_70558[(2)]);
var inst_70538 = fluree.db.util.async.throw_err(inst_70537);
var state_70558__$1 = state_70558;
var statearr_70563_70587 = state_70558__$1;
(statearr_70563_70587[(2)] = inst_70538);

(statearr_70563_70587[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (6))){
var state_70558__$1 = state_70558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70558__$1,(9),subject);
} else {
if((state_val_70559 === (3))){
var inst_70556 = (state_70558[(2)]);
var state_70558__$1 = state_70558;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70558__$1,inst_70556);
} else {
if((state_val_70559 === (12))){
var inst_70533 = (state_70558[(7)]);
var inst_70541 = (state_70558[(2)]);
var inst_70542 = fluree.db.dbfunctions.internal.get_in(inst_70533,inst_70541);
var inst_70543 = cljs.core.count(inst_70541);
var inst_70544 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70545 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70546 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70547 = [inst_70533,inst_70541];
var inst_70548 = (new cljs.core.PersistentVector(null,2,(5),inst_70546,inst_70547,null));
var inst_70549 = ["get-in",inst_70548,inst_70542];
var inst_70550 = cljs.core.PersistentHashMap.fromArrays(inst_70545,inst_70549);
var inst_70551 = [inst_70550,inst_70543];
var inst_70552 = (new cljs.core.PersistentVector(null,2,(5),inst_70544,inst_70551,null));
var inst_70553 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70552);
var _ = (function (){var statearr_70564 = state_70558;
(statearr_70564[(4)] = cljs.core.rest((state_70558[(4)])));

return statearr_70564;
})();
var state_70558__$1 = (function (){var statearr_70565 = state_70558;
(statearr_70565[(8)] = inst_70553);

return statearr_70565;
})();
var statearr_70566_70588 = state_70558__$1;
(statearr_70566_70588[(2)] = inst_70542);

(statearr_70566_70588[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (2))){
var _ = (function (){var statearr_70567 = state_70558;
(statearr_70567[(4)] = cljs.core.cons((5),(state_70558[(4)])));

return statearr_70567;
})();
var inst_70526 = fluree.db.util.async.channel_QMARK_(subject);
var state_70558__$1 = state_70558;
if(inst_70526){
var statearr_70568_70589 = state_70558__$1;
(statearr_70568_70589[(1)] = (6));

} else {
var statearr_70569_70590 = state_70558__$1;
(statearr_70569_70590[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (11))){
var state_70558__$1 = state_70558;
var statearr_70571_70591 = state_70558__$1;
(statearr_70571_70591[(2)] = path);

(statearr_70571_70591[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (9))){
var inst_70529 = (state_70558[(2)]);
var inst_70530 = fluree.db.util.async.throw_err(inst_70529);
var state_70558__$1 = state_70558;
var statearr_70572_70592 = state_70558__$1;
(statearr_70572_70592[(2)] = inst_70530);

(statearr_70572_70592[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (5))){
var _ = (function (){var statearr_70573 = state_70558;
(statearr_70573[(4)] = cljs.core.rest((state_70558[(4)])));

return statearr_70573;
})();
var state_70558__$1 = state_70558;
var ex70570 = (state_70558__$1[(2)]);
var statearr_70574_70593 = state_70558__$1;
(statearr_70574_70593[(5)] = ex70570);


if((ex70570 instanceof Error)){
var statearr_70575_70594 = state_70558__$1;
(statearr_70575_70594[(1)] = (4));

(statearr_70575_70594[(5)] = null);

} else {
throw ex70570;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70559 === (10))){
var state_70558__$1 = state_70558;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70558__$1,(13),path);
} else {
if((state_val_70559 === (8))){
var inst_70533 = (state_70558[(2)]);
var inst_70534 = fluree.db.util.async.channel_QMARK_(path);
var state_70558__$1 = (function (){var statearr_70576 = state_70558;
(statearr_70576[(7)] = inst_70533);

return statearr_70576;
})();
if(inst_70534){
var statearr_70577_70595 = state_70558__$1;
(statearr_70577_70595[(1)] = (10));

} else {
var statearr_70578_70596 = state_70558__$1;
(statearr_70578_70596[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0 = (function (){
var statearr_70579 = [null,null,null,null,null,null,null,null,null];
(statearr_70579[(0)] = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__);

(statearr_70579[(1)] = (1));

return statearr_70579;
});
var fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1 = (function (state_70558){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70558);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70580){var ex__16398__auto__ = e70580;
var statearr_70581_70597 = state_70558;
(statearr_70581_70597[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70558[(4)]))){
var statearr_70582_70598 = state_70558;
(statearr_70582_70598[(1)] = cljs.core.first((state_70558[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70599 = state_70558;
state_70558 = G__70599;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__ = function(state_70558){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1.call(this,state_70558);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$get_in_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70583 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70583[(6)] = c__16469__auto__);

return statearr_70583;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns true if key is present.
 */
fluree.db.dbfunctions.fns.contains_QMARK_ = (function fluree$db$dbfunctions$fns$contains_QMARK_(_QMARK_ctx,coll,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70644){
var state_val_70645 = (state_70644[(1)]);
if((state_val_70645 === (7))){
var state_70644__$1 = state_70644;
var statearr_70646_70675 = state_70644__$1;
(statearr_70646_70675[(2)] = coll);

(statearr_70646_70675[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (1))){
var state_70644__$1 = state_70644;
var statearr_70647_70676 = state_70644__$1;
(statearr_70647_70676[(2)] = null);

(statearr_70647_70676[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (4))){
var inst_70600 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
var statearr_70648_70677 = state_70644__$1;
(statearr_70648_70677[(2)] = inst_70600);

(statearr_70648_70677[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (15))){
var inst_70620 = (state_70644[(7)]);
var inst_70628 = (state_70644[(2)]);
var inst_70629 = fluree.db.dbfunctions.internal.contains_QMARK_(inst_70620,inst_70628);
var inst_70630 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70631 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70632 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70633 = [inst_70620,inst_70628];
var inst_70634 = (new cljs.core.PersistentVector(null,2,(5),inst_70632,inst_70633,null));
var inst_70635 = ["contains?",inst_70634,inst_70629];
var inst_70636 = cljs.core.PersistentHashMap.fromArrays(inst_70631,inst_70635);
var inst_70637 = [inst_70636,(10)];
var inst_70638 = (new cljs.core.PersistentVector(null,2,(5),inst_70630,inst_70637,null));
var inst_70639 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70638);
var _ = (function (){var statearr_70649 = state_70644;
(statearr_70649[(4)] = cljs.core.rest((state_70644[(4)])));

return statearr_70649;
})();
var state_70644__$1 = (function (){var statearr_70650 = state_70644;
(statearr_70650[(8)] = inst_70639);

return statearr_70650;
})();
var statearr_70651_70678 = state_70644__$1;
(statearr_70651_70678[(2)] = inst_70629);

(statearr_70651_70678[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (13))){
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70644__$1,(16),key);
} else {
if((state_val_70645 === (6))){
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70644__$1,(9),coll);
} else {
if((state_val_70645 === (3))){
var inst_70642 = (state_70644[(2)]);
var state_70644__$1 = state_70644;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70644__$1,inst_70642);
} else {
if((state_val_70645 === (12))){
var inst_70620 = (state_70644[(2)]);
var inst_70621 = fluree.db.util.async.channel_QMARK_(key);
var state_70644__$1 = (function (){var statearr_70652 = state_70644;
(statearr_70652[(7)] = inst_70620);

return statearr_70652;
})();
if(inst_70621){
var statearr_70653_70679 = state_70644__$1;
(statearr_70653_70679[(1)] = (13));

} else {
var statearr_70654_70680 = state_70644__$1;
(statearr_70654_70680[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (2))){
var _ = (function (){var statearr_70655 = state_70644;
(statearr_70655[(4)] = cljs.core.cons((5),(state_70644[(4)])));

return statearr_70655;
})();
var inst_70606 = fluree.db.util.async.channel_QMARK_(coll);
var state_70644__$1 = state_70644;
if(inst_70606){
var statearr_70656_70681 = state_70644__$1;
(statearr_70656_70681[(1)] = (6));

} else {
var statearr_70657_70682 = state_70644__$1;
(statearr_70657_70682[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (11))){
var inst_70613 = (state_70644[(9)]);
var inst_70617 = cljs.core.flatten(inst_70613);
var inst_70618 = cljs.core.set(inst_70617);
var state_70644__$1 = state_70644;
var statearr_70659_70683 = state_70644__$1;
(statearr_70659_70683[(2)] = inst_70618);

(statearr_70659_70683[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (9))){
var inst_70609 = (state_70644[(2)]);
var inst_70610 = fluree.db.util.async.throw_err(inst_70609);
var state_70644__$1 = state_70644;
var statearr_70660_70684 = state_70644__$1;
(statearr_70660_70684[(2)] = inst_70610);

(statearr_70660_70684[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (5))){
var _ = (function (){var statearr_70661 = state_70644;
(statearr_70661[(4)] = cljs.core.rest((state_70644[(4)])));

return statearr_70661;
})();
var state_70644__$1 = state_70644;
var ex70658 = (state_70644__$1[(2)]);
var statearr_70662_70685 = state_70644__$1;
(statearr_70662_70685[(5)] = ex70658);


if((ex70658 instanceof Error)){
var statearr_70663_70686 = state_70644__$1;
(statearr_70663_70686[(1)] = (4));

(statearr_70663_70686[(5)] = null);

} else {
throw ex70658;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (14))){
var state_70644__$1 = state_70644;
var statearr_70664_70687 = state_70644__$1;
(statearr_70664_70687[(2)] = key);

(statearr_70664_70687[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (16))){
var inst_70624 = (state_70644[(2)]);
var inst_70625 = fluree.db.util.async.throw_err(inst_70624);
var state_70644__$1 = state_70644;
var statearr_70665_70688 = state_70644__$1;
(statearr_70665_70688[(2)] = inst_70625);

(statearr_70665_70688[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (10))){
var inst_70613 = (state_70644[(9)]);
var state_70644__$1 = state_70644;
var statearr_70666_70689 = state_70644__$1;
(statearr_70666_70689[(2)] = inst_70613);

(statearr_70666_70689[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70645 === (8))){
var inst_70613 = (state_70644[(9)]);
var inst_70613__$1 = (state_70644[(2)]);
var inst_70614 = cljs.core.set_QMARK_(inst_70613__$1);
var state_70644__$1 = (function (){var statearr_70667 = state_70644;
(statearr_70667[(9)] = inst_70613__$1);

return statearr_70667;
})();
if(inst_70614){
var statearr_70668_70690 = state_70644__$1;
(statearr_70668_70690[(1)] = (10));

} else {
var statearr_70669_70691 = state_70644__$1;
(statearr_70669_70691[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_70670 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70670[(0)] = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__);

(statearr_70670[(1)] = (1));

return statearr_70670;
});
var fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1 = (function (state_70644){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70644);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70671){var ex__16398__auto__ = e70671;
var statearr_70672_70692 = state_70644;
(statearr_70672_70692[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70644[(4)]))){
var statearr_70673_70693 = state_70644;
(statearr_70673_70693[(1)] = cljs.core.first((state_70644[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70694 = state_70644;
state_70644 = G__70694;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__ = function(state_70644){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1.call(this,state_70644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$contains_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70674 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70674[(6)] = c__16469__auto__);

return statearr_70674;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a hash-set of values
 */
fluree.db.dbfunctions.fns.hash_set = (function fluree$db$dbfunctions$fns$hash_set(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70766 = arguments.length;
var i__4819__auto___70767 = (0);
while(true){
if((i__4819__auto___70767 < len__4818__auto___70766)){
args__4824__auto__.push((arguments[i__4819__auto___70767]));

var G__70768 = (i__4819__auto___70767 + (1));
i__4819__auto___70767 = G__70768;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.hash_set.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70740){
var state_val_70741 = (state_70740[(1)]);
if((state_val_70741 === (7))){
var inst_70706 = (state_70740[(7)]);
var inst_70710 = cljs.core.first(inst_70706);
var inst_70711 = cljs.core.coll_QMARK_(inst_70710);
var state_70740__$1 = state_70740;
var statearr_70742_70769 = state_70740__$1;
(statearr_70742_70769[(2)] = inst_70711);

(statearr_70742_70769[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (1))){
var state_70740__$1 = state_70740;
var statearr_70743_70770 = state_70740__$1;
(statearr_70743_70770[(2)] = null);

(statearr_70743_70770[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (4))){
var inst_70697 = (state_70740[(2)]);
var state_70740__$1 = state_70740;
var statearr_70744_70771 = state_70740__$1;
(statearr_70744_70771[(2)] = inst_70697);

(statearr_70744_70771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (6))){
var inst_70708 = (state_70740[(8)]);
var inst_70706 = (state_70740[(7)]);
var inst_70705 = (state_70740[(2)]);
var inst_70706__$1 = fluree.db.util.async.throw_err(inst_70705);
var inst_70707 = cljs.core.count(inst_70706__$1);
var inst_70708__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_70707);
var state_70740__$1 = (function (){var statearr_70745 = state_70740;
(statearr_70745[(8)] = inst_70708__$1);

(statearr_70745[(7)] = inst_70706__$1);

return statearr_70745;
})();
if(inst_70708__$1){
var statearr_70746_70772 = state_70740__$1;
(statearr_70746_70772[(1)] = (7));

} else {
var statearr_70747_70773 = state_70740__$1;
(statearr_70747_70773[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (3))){
var inst_70738 = (state_70740[(2)]);
var state_70740__$1 = state_70740;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70740__$1,inst_70738);
} else {
if((state_val_70741 === (12))){
var inst_70719 = (state_70740[(2)]);
var inst_70720 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.hash_set,inst_70719);
var inst_70721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70722 = [inst_70719];
var inst_70723 = (new cljs.core.PersistentVector(null,1,(5),inst_70721,inst_70722,null));
var inst_70724 = cljs.core.count(inst_70723);
var inst_70725 = ((9) + inst_70724);
var inst_70726 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70727 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70728 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70729 = [inst_70719];
var inst_70730 = (new cljs.core.PersistentVector(null,1,(5),inst_70728,inst_70729,null));
var inst_70731 = ["hash-set",inst_70730,inst_70720];
var inst_70732 = cljs.core.PersistentHashMap.fromArrays(inst_70727,inst_70731);
var inst_70733 = [inst_70732,inst_70725];
var inst_70734 = (new cljs.core.PersistentVector(null,2,(5),inst_70726,inst_70733,null));
var inst_70735 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70734);
var _ = (function (){var statearr_70748 = state_70740;
(statearr_70748[(4)] = cljs.core.rest((state_70740[(4)])));

return statearr_70748;
})();
var state_70740__$1 = (function (){var statearr_70749 = state_70740;
(statearr_70749[(9)] = inst_70735);

return statearr_70749;
})();
var statearr_70750_70774 = state_70740__$1;
(statearr_70750_70774[(2)] = inst_70720);

(statearr_70750_70774[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (2))){
var _ = (function (){var statearr_70751 = state_70740;
(statearr_70751[(4)] = cljs.core.cons((5),(state_70740[(4)])));

return statearr_70751;
})();
var inst_70703 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70740__$1 = state_70740;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70740__$1,(6),inst_70703);
} else {
if((state_val_70741 === (11))){
var inst_70706 = (state_70740[(7)]);
var state_70740__$1 = state_70740;
var statearr_70753_70775 = state_70740__$1;
(statearr_70753_70775[(2)] = inst_70706);

(statearr_70753_70775[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (9))){
var inst_70714 = (state_70740[(2)]);
var state_70740__$1 = state_70740;
if(cljs.core.truth_(inst_70714)){
var statearr_70754_70776 = state_70740__$1;
(statearr_70754_70776[(1)] = (10));

} else {
var statearr_70755_70777 = state_70740__$1;
(statearr_70755_70777[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (5))){
var _ = (function (){var statearr_70756 = state_70740;
(statearr_70756[(4)] = cljs.core.rest((state_70740[(4)])));

return statearr_70756;
})();
var state_70740__$1 = state_70740;
var ex70752 = (state_70740__$1[(2)]);
var statearr_70757_70778 = state_70740__$1;
(statearr_70757_70778[(5)] = ex70752);


if((ex70752 instanceof Error)){
var statearr_70758_70779 = state_70740__$1;
(statearr_70758_70779[(1)] = (4));

(statearr_70758_70779[(5)] = null);

} else {
throw ex70752;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (10))){
var inst_70706 = (state_70740[(7)]);
var inst_70716 = cljs.core.first(inst_70706);
var state_70740__$1 = state_70740;
var statearr_70759_70780 = state_70740__$1;
(statearr_70759_70780[(2)] = inst_70716);

(statearr_70759_70780[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70741 === (8))){
var inst_70708 = (state_70740[(8)]);
var state_70740__$1 = state_70740;
var statearr_70760_70781 = state_70740__$1;
(statearr_70760_70781[(2)] = inst_70708);

(statearr_70760_70781[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70761 = [null,null,null,null,null,null,null,null,null,null];
(statearr_70761[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70761[(1)] = (1));

return statearr_70761;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70740){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70740);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70762){var ex__16398__auto__ = e70762;
var statearr_70763_70782 = state_70740;
(statearr_70763_70782[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70740[(4)]))){
var statearr_70764_70783 = state_70740;
(statearr_70764_70783[(1)] = cljs.core.first((state_70740[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70784 = state_70740;
state_70740 = G__70784;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70740){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70740);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70765 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70765[(6)] = c__16469__auto__);

return statearr_70765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.hash_set.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.hash_set.cljs$lang$applyTo = (function (seq70695){
var G__70696 = cljs.core.first(seq70695);
var seq70695__$1 = cljs.core.next(seq70695);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70696,seq70695__$1);
}));

/**
 * Return true if arguments in sequence equal each other.
 */
fluree.db.dbfunctions.fns._EQ__EQ_ = (function fluree$db$dbfunctions$fns$_EQ__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70834 = arguments.length;
var i__4819__auto___70835 = (0);
while(true){
if((i__4819__auto___70835 < len__4818__auto___70834)){
args__4824__auto__.push((arguments[i__4819__auto___70835]));

var G__70836 = (i__4819__auto___70835 + (1));
i__4819__auto___70835 = G__70836;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70817){
var state_val_70818 = (state_70817[(1)]);
if((state_val_70818 === (1))){
var state_70817__$1 = state_70817;
var statearr_70819_70837 = state_70817__$1;
(statearr_70819_70837[(2)] = null);

(statearr_70819_70837[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70818 === (2))){
var _ = (function (){var statearr_70820 = state_70817;
(statearr_70820[(4)] = cljs.core.cons((5),(state_70817[(4)])));

return statearr_70820;
})();
var inst_70793 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70817__$1 = state_70817;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70817__$1,(6),inst_70793);
} else {
if((state_val_70818 === (3))){
var inst_70815 = (state_70817[(2)]);
var state_70817__$1 = state_70817;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70817__$1,inst_70815);
} else {
if((state_val_70818 === (4))){
var inst_70787 = (state_70817[(2)]);
var state_70817__$1 = state_70817;
var statearr_70822_70838 = state_70817__$1;
(statearr_70822_70838[(2)] = inst_70787);

(statearr_70822_70838[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70818 === (5))){
var _ = (function (){var statearr_70823 = state_70817;
(statearr_70823[(4)] = cljs.core.rest((state_70817[(4)])));

return statearr_70823;
})();
var state_70817__$1 = state_70817;
var ex70821 = (state_70817__$1[(2)]);
var statearr_70824_70839 = state_70817__$1;
(statearr_70824_70839[(5)] = ex70821);


if((ex70821 instanceof Error)){
var statearr_70825_70840 = state_70817__$1;
(statearr_70825_70840[(1)] = (4));

(statearr_70825_70840[(5)] = null);

} else {
throw ex70821;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70818 === (6))){
var inst_70795 = (state_70817[(2)]);
var inst_70796 = fluree.db.util.async.throw_err(inst_70795);
var inst_70797 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._EQ__EQ_,inst_70796);
var inst_70798 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70799 = [inst_70796];
var inst_70800 = (new cljs.core.PersistentVector(null,1,(5),inst_70798,inst_70799,null));
var inst_70801 = cljs.core.count(inst_70800);
var inst_70802 = ((9) + inst_70801);
var inst_70803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70804 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70805 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70806 = [inst_70796];
var inst_70807 = (new cljs.core.PersistentVector(null,1,(5),inst_70805,inst_70806,null));
var inst_70808 = ["==",inst_70807,inst_70797];
var inst_70809 = cljs.core.PersistentHashMap.fromArrays(inst_70804,inst_70808);
var inst_70810 = [inst_70809,inst_70802];
var inst_70811 = (new cljs.core.PersistentVector(null,2,(5),inst_70803,inst_70810,null));
var inst_70812 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70811);
var _ = (function (){var statearr_70826 = state_70817;
(statearr_70826[(4)] = cljs.core.rest((state_70817[(4)])));

return statearr_70826;
})();
var state_70817__$1 = (function (){var statearr_70827 = state_70817;
(statearr_70827[(7)] = inst_70812);

return statearr_70827;
})();
var statearr_70828_70841 = state_70817__$1;
(statearr_70828_70841[(2)] = inst_70797);

(statearr_70828_70841[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70829 = [null,null,null,null,null,null,null,null];
(statearr_70829[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70829[(1)] = (1));

return statearr_70829;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70817){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70817);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70830){var ex__16398__auto__ = e70830;
var statearr_70831_70842 = state_70817;
(statearr_70831_70842[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70817[(4)]))){
var statearr_70832_70843 = state_70817;
(statearr_70832_70843[(1)] = cljs.core.first((state_70817[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70844 = state_70817;
state_70817 = G__70844;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70817){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70817);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70833 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70833[(6)] = c__16469__auto__);

return statearr_70833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._EQ__EQ_.cljs$lang$applyTo = (function (seq70785){
var G__70786 = cljs.core.first(seq70785);
var seq70785__$1 = cljs.core.next(seq70785);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70786,seq70785__$1);
}));

/**
 * Returns non-nil if nums are in monotonically decreasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._GT_ = (function fluree$db$dbfunctions$fns$_GT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70894 = arguments.length;
var i__4819__auto___70895 = (0);
while(true){
if((i__4819__auto___70895 < len__4818__auto___70894)){
args__4824__auto__.push((arguments[i__4819__auto___70895]));

var G__70896 = (i__4819__auto___70895 + (1));
i__4819__auto___70895 = G__70896;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70877){
var state_val_70878 = (state_70877[(1)]);
if((state_val_70878 === (1))){
var state_70877__$1 = state_70877;
var statearr_70879_70897 = state_70877__$1;
(statearr_70879_70897[(2)] = null);

(statearr_70879_70897[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70878 === (2))){
var _ = (function (){var statearr_70880 = state_70877;
(statearr_70880[(4)] = cljs.core.cons((5),(state_70877[(4)])));

return statearr_70880;
})();
var inst_70853 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70877__$1 = state_70877;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70877__$1,(6),inst_70853);
} else {
if((state_val_70878 === (3))){
var inst_70875 = (state_70877[(2)]);
var state_70877__$1 = state_70877;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70877__$1,inst_70875);
} else {
if((state_val_70878 === (4))){
var inst_70847 = (state_70877[(2)]);
var state_70877__$1 = state_70877;
var statearr_70882_70898 = state_70877__$1;
(statearr_70882_70898[(2)] = inst_70847);

(statearr_70882_70898[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70878 === (5))){
var _ = (function (){var statearr_70883 = state_70877;
(statearr_70883[(4)] = cljs.core.rest((state_70877[(4)])));

return statearr_70883;
})();
var state_70877__$1 = state_70877;
var ex70881 = (state_70877__$1[(2)]);
var statearr_70884_70899 = state_70877__$1;
(statearr_70884_70899[(5)] = ex70881);


if((ex70881 instanceof Error)){
var statearr_70885_70900 = state_70877__$1;
(statearr_70885_70900[(1)] = (4));

(statearr_70885_70900[(5)] = null);

} else {
throw ex70881;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70878 === (6))){
var inst_70855 = (state_70877[(2)]);
var inst_70856 = fluree.db.util.async.throw_err(inst_70855);
var inst_70857 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT_,inst_70856);
var inst_70858 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70859 = [inst_70856];
var inst_70860 = (new cljs.core.PersistentVector(null,1,(5),inst_70858,inst_70859,null));
var inst_70861 = cljs.core.count(inst_70860);
var inst_70862 = ((9) + inst_70861);
var inst_70863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70864 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70866 = [inst_70856];
var inst_70867 = (new cljs.core.PersistentVector(null,1,(5),inst_70865,inst_70866,null));
var inst_70868 = [">",inst_70867,inst_70857];
var inst_70869 = cljs.core.PersistentHashMap.fromArrays(inst_70864,inst_70868);
var inst_70870 = [inst_70869,inst_70862];
var inst_70871 = (new cljs.core.PersistentVector(null,2,(5),inst_70863,inst_70870,null));
var inst_70872 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70871);
var _ = (function (){var statearr_70886 = state_70877;
(statearr_70886[(4)] = cljs.core.rest((state_70877[(4)])));

return statearr_70886;
})();
var state_70877__$1 = (function (){var statearr_70887 = state_70877;
(statearr_70887[(7)] = inst_70872);

return statearr_70887;
})();
var statearr_70888_70901 = state_70877__$1;
(statearr_70888_70901[(2)] = inst_70857);

(statearr_70888_70901[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70889 = [null,null,null,null,null,null,null,null];
(statearr_70889[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70889[(1)] = (1));

return statearr_70889;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70877){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70877);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70890){var ex__16398__auto__ = e70890;
var statearr_70891_70902 = state_70877;
(statearr_70891_70902[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70877[(4)]))){
var statearr_70892_70903 = state_70877;
(statearr_70892_70903[(1)] = cljs.core.first((state_70877[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70904 = state_70877;
state_70877 = G__70904;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70877){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70877);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70893 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70893[(6)] = c__16469__auto__);

return statearr_70893;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._GT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT_.cljs$lang$applyTo = (function (seq70845){
var G__70846 = cljs.core.first(seq70845);
var seq70845__$1 = cljs.core.next(seq70845);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70846,seq70845__$1);
}));

/**
 * Returns non-nil if nums are in monotonically increasing order, otherwise false.
 */
fluree.db.dbfunctions.fns._LT_ = (function fluree$db$dbfunctions$fns$_LT_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___70954 = arguments.length;
var i__4819__auto___70955 = (0);
while(true){
if((i__4819__auto___70955 < len__4818__auto___70954)){
args__4824__auto__.push((arguments[i__4819__auto___70955]));

var G__70956 = (i__4819__auto___70955 + (1));
i__4819__auto___70955 = G__70956;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70937){
var state_val_70938 = (state_70937[(1)]);
if((state_val_70938 === (1))){
var state_70937__$1 = state_70937;
var statearr_70939_70957 = state_70937__$1;
(statearr_70939_70957[(2)] = null);

(statearr_70939_70957[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70938 === (2))){
var _ = (function (){var statearr_70940 = state_70937;
(statearr_70940[(4)] = cljs.core.cons((5),(state_70937[(4)])));

return statearr_70940;
})();
var inst_70913 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70937__$1 = state_70937;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70937__$1,(6),inst_70913);
} else {
if((state_val_70938 === (3))){
var inst_70935 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70937__$1,inst_70935);
} else {
if((state_val_70938 === (4))){
var inst_70907 = (state_70937[(2)]);
var state_70937__$1 = state_70937;
var statearr_70942_70958 = state_70937__$1;
(statearr_70942_70958[(2)] = inst_70907);

(statearr_70942_70958[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70938 === (5))){
var _ = (function (){var statearr_70943 = state_70937;
(statearr_70943[(4)] = cljs.core.rest((state_70937[(4)])));

return statearr_70943;
})();
var state_70937__$1 = state_70937;
var ex70941 = (state_70937__$1[(2)]);
var statearr_70944_70959 = state_70937__$1;
(statearr_70944_70959[(5)] = ex70941);


if((ex70941 instanceof Error)){
var statearr_70945_70960 = state_70937__$1;
(statearr_70945_70960[(1)] = (4));

(statearr_70945_70960[(5)] = null);

} else {
throw ex70941;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70938 === (6))){
var inst_70915 = (state_70937[(2)]);
var inst_70916 = fluree.db.util.async.throw_err(inst_70915);
var inst_70917 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT_,inst_70916);
var inst_70918 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70919 = [inst_70916];
var inst_70920 = (new cljs.core.PersistentVector(null,1,(5),inst_70918,inst_70919,null));
var inst_70921 = cljs.core.count(inst_70920);
var inst_70922 = ((9) + inst_70921);
var inst_70923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70924 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70925 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70926 = [inst_70916];
var inst_70927 = (new cljs.core.PersistentVector(null,1,(5),inst_70925,inst_70926,null));
var inst_70928 = ["<",inst_70927,inst_70917];
var inst_70929 = cljs.core.PersistentHashMap.fromArrays(inst_70924,inst_70928);
var inst_70930 = [inst_70929,inst_70922];
var inst_70931 = (new cljs.core.PersistentVector(null,2,(5),inst_70923,inst_70930,null));
var inst_70932 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70931);
var _ = (function (){var statearr_70946 = state_70937;
(statearr_70946[(4)] = cljs.core.rest((state_70937[(4)])));

return statearr_70946;
})();
var state_70937__$1 = (function (){var statearr_70947 = state_70937;
(statearr_70947[(7)] = inst_70932);

return statearr_70947;
})();
var statearr_70948_70961 = state_70937__$1;
(statearr_70948_70961[(2)] = inst_70917);

(statearr_70948_70961[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_70949 = [null,null,null,null,null,null,null,null];
(statearr_70949[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_70949[(1)] = (1));

return statearr_70949;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70937){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70937);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e70950){var ex__16398__auto__ = e70950;
var statearr_70951_70962 = state_70937;
(statearr_70951_70962[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70937[(4)]))){
var statearr_70952_70963 = state_70937;
(statearr_70952_70963[(1)] = cljs.core.first((state_70937[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__70964 = state_70937;
state_70937 = G__70964;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70937){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70937);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_70953 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_70953[(6)] = c__16469__auto__);

return statearr_70953;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._LT_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT_.cljs$lang$applyTo = (function (seq70905){
var G__70906 = cljs.core.first(seq70905);
var seq70905__$1 = cljs.core.next(seq70905);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70906,seq70905__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._LT__EQ_ = (function fluree$db$dbfunctions$fns$_LT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71014 = arguments.length;
var i__4819__auto___71015 = (0);
while(true){
if((i__4819__auto___71015 < len__4818__auto___71014)){
args__4824__auto__.push((arguments[i__4819__auto___71015]));

var G__71016 = (i__4819__auto___71015 + (1));
i__4819__auto___71015 = G__71016;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_70997){
var state_val_70998 = (state_70997[(1)]);
if((state_val_70998 === (1))){
var state_70997__$1 = state_70997;
var statearr_70999_71017 = state_70997__$1;
(statearr_70999_71017[(2)] = null);

(statearr_70999_71017[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70998 === (2))){
var _ = (function (){var statearr_71000 = state_70997;
(statearr_71000[(4)] = cljs.core.cons((5),(state_70997[(4)])));

return statearr_71000;
})();
var inst_70973 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_70997__$1 = state_70997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_70997__$1,(6),inst_70973);
} else {
if((state_val_70998 === (3))){
var inst_70995 = (state_70997[(2)]);
var state_70997__$1 = state_70997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_70997__$1,inst_70995);
} else {
if((state_val_70998 === (4))){
var inst_70967 = (state_70997[(2)]);
var state_70997__$1 = state_70997;
var statearr_71002_71018 = state_70997__$1;
(statearr_71002_71018[(2)] = inst_70967);

(statearr_71002_71018[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_70998 === (5))){
var _ = (function (){var statearr_71003 = state_70997;
(statearr_71003[(4)] = cljs.core.rest((state_70997[(4)])));

return statearr_71003;
})();
var state_70997__$1 = state_70997;
var ex71001 = (state_70997__$1[(2)]);
var statearr_71004_71019 = state_70997__$1;
(statearr_71004_71019[(5)] = ex71001);


if((ex71001 instanceof Error)){
var statearr_71005_71020 = state_70997__$1;
(statearr_71005_71020[(1)] = (4));

(statearr_71005_71020[(5)] = null);

} else {
throw ex71001;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_70998 === (6))){
var inst_70975 = (state_70997[(2)]);
var inst_70976 = fluree.db.util.async.throw_err(inst_70975);
var inst_70977 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._LT__EQ_,inst_70976);
var inst_70978 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70979 = [inst_70976];
var inst_70980 = (new cljs.core.PersistentVector(null,1,(5),inst_70978,inst_70979,null));
var inst_70981 = cljs.core.count(inst_70980);
var inst_70982 = ((9) + inst_70981);
var inst_70983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70984 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_70985 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_70986 = [inst_70976];
var inst_70987 = (new cljs.core.PersistentVector(null,1,(5),inst_70985,inst_70986,null));
var inst_70988 = ["<=",inst_70987,inst_70977];
var inst_70989 = cljs.core.PersistentHashMap.fromArrays(inst_70984,inst_70988);
var inst_70990 = [inst_70989,inst_70982];
var inst_70991 = (new cljs.core.PersistentVector(null,2,(5),inst_70983,inst_70990,null));
var inst_70992 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_70991);
var _ = (function (){var statearr_71006 = state_70997;
(statearr_71006[(4)] = cljs.core.rest((state_70997[(4)])));

return statearr_71006;
})();
var state_70997__$1 = (function (){var statearr_71007 = state_70997;
(statearr_71007[(7)] = inst_70992);

return statearr_71007;
})();
var statearr_71008_71021 = state_70997__$1;
(statearr_71008_71021[(2)] = inst_70977);

(statearr_71008_71021[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71009 = [null,null,null,null,null,null,null,null];
(statearr_71009[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71009[(1)] = (1));

return statearr_71009;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_70997){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_70997);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71010){var ex__16398__auto__ = e71010;
var statearr_71011_71022 = state_70997;
(statearr_71011_71022[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_70997[(4)]))){
var statearr_71012_71023 = state_70997;
(statearr_71012_71023[(1)] = cljs.core.first((state_70997[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71024 = state_70997;
state_70997 = G__71024;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_70997){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_70997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71013 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71013[(6)] = c__16469__auto__);

return statearr_71013;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._LT__EQ_.cljs$lang$applyTo = (function (seq70965){
var G__70966 = cljs.core.first(seq70965);
var seq70965__$1 = cljs.core.next(seq70965);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__70966,seq70965__$1);
}));

/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 */
fluree.db.dbfunctions.fns._GT__EQ_ = (function fluree$db$dbfunctions$fns$_GT__EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71074 = arguments.length;
var i__4819__auto___71075 = (0);
while(true){
if((i__4819__auto___71075 < len__4818__auto___71074)){
args__4824__auto__.push((arguments[i__4819__auto___71075]));

var G__71076 = (i__4819__auto___71075 + (1));
i__4819__auto___71075 = G__71076;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71057){
var state_val_71058 = (state_71057[(1)]);
if((state_val_71058 === (1))){
var state_71057__$1 = state_71057;
var statearr_71059_71077 = state_71057__$1;
(statearr_71059_71077[(2)] = null);

(statearr_71059_71077[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71058 === (2))){
var _ = (function (){var statearr_71060 = state_71057;
(statearr_71060[(4)] = cljs.core.cons((5),(state_71057[(4)])));

return statearr_71060;
})();
var inst_71033 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71057__$1 = state_71057;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71057__$1,(6),inst_71033);
} else {
if((state_val_71058 === (3))){
var inst_71055 = (state_71057[(2)]);
var state_71057__$1 = state_71057;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71057__$1,inst_71055);
} else {
if((state_val_71058 === (4))){
var inst_71027 = (state_71057[(2)]);
var state_71057__$1 = state_71057;
var statearr_71062_71078 = state_71057__$1;
(statearr_71062_71078[(2)] = inst_71027);

(statearr_71062_71078[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71058 === (5))){
var _ = (function (){var statearr_71063 = state_71057;
(statearr_71063[(4)] = cljs.core.rest((state_71057[(4)])));

return statearr_71063;
})();
var state_71057__$1 = state_71057;
var ex71061 = (state_71057__$1[(2)]);
var statearr_71064_71079 = state_71057__$1;
(statearr_71064_71079[(5)] = ex71061);


if((ex71061 instanceof Error)){
var statearr_71065_71080 = state_71057__$1;
(statearr_71065_71080[(1)] = (4));

(statearr_71065_71080[(5)] = null);

} else {
throw ex71061;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71058 === (6))){
var inst_71035 = (state_71057[(2)]);
var inst_71036 = fluree.db.util.async.throw_err(inst_71035);
var inst_71037 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._GT__EQ_,inst_71036);
var inst_71038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71039 = [inst_71036];
var inst_71040 = (new cljs.core.PersistentVector(null,1,(5),inst_71038,inst_71039,null));
var inst_71041 = cljs.core.count(inst_71040);
var inst_71042 = ((9) + inst_71041);
var inst_71043 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71044 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71045 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71046 = [inst_71036];
var inst_71047 = (new cljs.core.PersistentVector(null,1,(5),inst_71045,inst_71046,null));
var inst_71048 = [">=",inst_71047,inst_71037];
var inst_71049 = cljs.core.PersistentHashMap.fromArrays(inst_71044,inst_71048);
var inst_71050 = [inst_71049,inst_71042];
var inst_71051 = (new cljs.core.PersistentVector(null,2,(5),inst_71043,inst_71050,null));
var inst_71052 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71051);
var _ = (function (){var statearr_71066 = state_71057;
(statearr_71066[(4)] = cljs.core.rest((state_71057[(4)])));

return statearr_71066;
})();
var state_71057__$1 = (function (){var statearr_71067 = state_71057;
(statearr_71067[(7)] = inst_71052);

return statearr_71067;
})();
var statearr_71068_71081 = state_71057__$1;
(statearr_71068_71081[(2)] = inst_71037);

(statearr_71068_71081[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71069 = [null,null,null,null,null,null,null,null];
(statearr_71069[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71069[(1)] = (1));

return statearr_71069;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71057){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71057);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71070){var ex__16398__auto__ = e71070;
var statearr_71071_71082 = state_71057;
(statearr_71071_71082[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71057[(4)]))){
var statearr_71072_71083 = state_71057;
(statearr_71072_71083[(1)] = cljs.core.first((state_71057[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71084 = state_71057;
state_71057 = G__71084;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71057){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71057);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71073 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71073[(6)] = c__16469__auto__);

return statearr_71073;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._GT__EQ_.cljs$lang$applyTo = (function (seq71025){
var G__71026 = cljs.core.first(seq71025);
var seq71025__$1 = cljs.core.next(seq71025);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71026,seq71025__$1);
}));

/**
 * Returns true if two (or more) values are not equal.
 */
fluree.db.dbfunctions.fns.not_EQ_ = (function fluree$db$dbfunctions$fns$not_EQ_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71134 = arguments.length;
var i__4819__auto___71135 = (0);
while(true){
if((i__4819__auto___71135 < len__4818__auto___71134)){
args__4824__auto__.push((arguments[i__4819__auto___71135]));

var G__71136 = (i__4819__auto___71135 + (1));
i__4819__auto___71135 = G__71136;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.not_EQ_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71117){
var state_val_71118 = (state_71117[(1)]);
if((state_val_71118 === (1))){
var state_71117__$1 = state_71117;
var statearr_71119_71137 = state_71117__$1;
(statearr_71119_71137[(2)] = null);

(statearr_71119_71137[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71118 === (2))){
var _ = (function (){var statearr_71120 = state_71117;
(statearr_71120[(4)] = cljs.core.cons((5),(state_71117[(4)])));

return statearr_71120;
})();
var inst_71093 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71117__$1 = state_71117;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71117__$1,(6),inst_71093);
} else {
if((state_val_71118 === (3))){
var inst_71115 = (state_71117[(2)]);
var state_71117__$1 = state_71117;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71117__$1,inst_71115);
} else {
if((state_val_71118 === (4))){
var inst_71087 = (state_71117[(2)]);
var state_71117__$1 = state_71117;
var statearr_71122_71138 = state_71117__$1;
(statearr_71122_71138[(2)] = inst_71087);

(statearr_71122_71138[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71118 === (5))){
var _ = (function (){var statearr_71123 = state_71117;
(statearr_71123[(4)] = cljs.core.rest((state_71117[(4)])));

return statearr_71123;
})();
var state_71117__$1 = state_71117;
var ex71121 = (state_71117__$1[(2)]);
var statearr_71124_71139 = state_71117__$1;
(statearr_71124_71139[(5)] = ex71121);


if((ex71121 instanceof Error)){
var statearr_71125_71140 = state_71117__$1;
(statearr_71125_71140[(1)] = (4));

(statearr_71125_71140[(5)] = null);

} else {
throw ex71121;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71118 === (6))){
var inst_71095 = (state_71117[(2)]);
var inst_71096 = fluree.db.util.async.throw_err(inst_71095);
var inst_71097 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.not_EQ_,inst_71096);
var inst_71098 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71099 = [inst_71096];
var inst_71100 = (new cljs.core.PersistentVector(null,1,(5),inst_71098,inst_71099,null));
var inst_71101 = cljs.core.count(inst_71100);
var inst_71102 = ((9) + inst_71101);
var inst_71103 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71104 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71105 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71106 = [inst_71096];
var inst_71107 = (new cljs.core.PersistentVector(null,1,(5),inst_71105,inst_71106,null));
var inst_71108 = ["not=",inst_71107,inst_71097];
var inst_71109 = cljs.core.PersistentHashMap.fromArrays(inst_71104,inst_71108);
var inst_71110 = [inst_71109,inst_71102];
var inst_71111 = (new cljs.core.PersistentVector(null,2,(5),inst_71103,inst_71110,null));
var inst_71112 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71111);
var _ = (function (){var statearr_71126 = state_71117;
(statearr_71126[(4)] = cljs.core.rest((state_71117[(4)])));

return statearr_71126;
})();
var state_71117__$1 = (function (){var statearr_71127 = state_71117;
(statearr_71127[(7)] = inst_71112);

return statearr_71127;
})();
var statearr_71128_71141 = state_71117__$1;
(statearr_71128_71141[(2)] = inst_71097);

(statearr_71128_71141[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71129 = [null,null,null,null,null,null,null,null];
(statearr_71129[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71129[(1)] = (1));

return statearr_71129;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71117){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71117);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71130){var ex__16398__auto__ = e71130;
var statearr_71131_71142 = state_71117;
(statearr_71131_71142[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71117[(4)]))){
var statearr_71132_71143 = state_71117;
(statearr_71132_71143[(1)] = cljs.core.first((state_71117[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71144 = state_71117;
state_71117 = G__71144;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71117){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71117);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71133 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71133[(6)] = c__16469__auto__);

return statearr_71133;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.not_EQ_.cljs$lang$applyTo = (function (seq71085){
var G__71086 = cljs.core.first(seq71085);
var seq71085__$1 = cljs.core.next(seq71085);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71086,seq71085__$1);
}));

/**
 * Gets max value from a sequence.
 */
fluree.db.dbfunctions.fns.max = (function fluree$db$dbfunctions$fns$max(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71194 = arguments.length;
var i__4819__auto___71195 = (0);
while(true){
if((i__4819__auto___71195 < len__4818__auto___71194)){
args__4824__auto__.push((arguments[i__4819__auto___71195]));

var G__71196 = (i__4819__auto___71195 + (1));
i__4819__auto___71195 = G__71196;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.max.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71177){
var state_val_71178 = (state_71177[(1)]);
if((state_val_71178 === (1))){
var state_71177__$1 = state_71177;
var statearr_71179_71197 = state_71177__$1;
(statearr_71179_71197[(2)] = null);

(statearr_71179_71197[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71178 === (2))){
var _ = (function (){var statearr_71180 = state_71177;
(statearr_71180[(4)] = cljs.core.cons((5),(state_71177[(4)])));

return statearr_71180;
})();
var inst_71153 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71177__$1 = state_71177;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71177__$1,(6),inst_71153);
} else {
if((state_val_71178 === (3))){
var inst_71175 = (state_71177[(2)]);
var state_71177__$1 = state_71177;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71177__$1,inst_71175);
} else {
if((state_val_71178 === (4))){
var inst_71147 = (state_71177[(2)]);
var state_71177__$1 = state_71177;
var statearr_71182_71198 = state_71177__$1;
(statearr_71182_71198[(2)] = inst_71147);

(statearr_71182_71198[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71178 === (5))){
var _ = (function (){var statearr_71183 = state_71177;
(statearr_71183[(4)] = cljs.core.rest((state_71177[(4)])));

return statearr_71183;
})();
var state_71177__$1 = state_71177;
var ex71181 = (state_71177__$1[(2)]);
var statearr_71184_71199 = state_71177__$1;
(statearr_71184_71199[(5)] = ex71181);


if((ex71181 instanceof Error)){
var statearr_71185_71200 = state_71177__$1;
(statearr_71185_71200[(1)] = (4));

(statearr_71185_71200[(5)] = null);

} else {
throw ex71181;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71178 === (6))){
var inst_71155 = (state_71177[(2)]);
var inst_71156 = fluree.db.util.async.throw_err(inst_71155);
var inst_71157 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.max,inst_71156);
var inst_71158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71159 = [inst_71156];
var inst_71160 = (new cljs.core.PersistentVector(null,1,(5),inst_71158,inst_71159,null));
var inst_71161 = cljs.core.count(inst_71160);
var inst_71162 = ((9) + inst_71161);
var inst_71163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71164 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71165 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71166 = [inst_71156];
var inst_71167 = (new cljs.core.PersistentVector(null,1,(5),inst_71165,inst_71166,null));
var inst_71168 = ["max",inst_71167,inst_71157];
var inst_71169 = cljs.core.PersistentHashMap.fromArrays(inst_71164,inst_71168);
var inst_71170 = [inst_71169,inst_71162];
var inst_71171 = (new cljs.core.PersistentVector(null,2,(5),inst_71163,inst_71170,null));
var inst_71172 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71171);
var _ = (function (){var statearr_71186 = state_71177;
(statearr_71186[(4)] = cljs.core.rest((state_71177[(4)])));

return statearr_71186;
})();
var state_71177__$1 = (function (){var statearr_71187 = state_71177;
(statearr_71187[(7)] = inst_71172);

return statearr_71187;
})();
var statearr_71188_71201 = state_71177__$1;
(statearr_71188_71201[(2)] = inst_71157);

(statearr_71188_71201[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71189 = [null,null,null,null,null,null,null,null];
(statearr_71189[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71189[(1)] = (1));

return statearr_71189;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71177){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71177);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71190){var ex__16398__auto__ = e71190;
var statearr_71191_71202 = state_71177;
(statearr_71191_71202[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71177[(4)]))){
var statearr_71192_71203 = state_71177;
(statearr_71192_71203[(1)] = cljs.core.first((state_71177[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71204 = state_71177;
state_71177 = G__71204;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71177){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71177);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71193 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71193[(6)] = c__16469__auto__);

return statearr_71193;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.max.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.max.cljs$lang$applyTo = (function (seq71145){
var G__71146 = cljs.core.first(seq71145);
var seq71145__$1 = cljs.core.next(seq71145);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71146,seq71145__$1);
}));

/**
 * Gets min value from a sequence.
 */
fluree.db.dbfunctions.fns.min = (function fluree$db$dbfunctions$fns$min(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71254 = arguments.length;
var i__4819__auto___71255 = (0);
while(true){
if((i__4819__auto___71255 < len__4818__auto___71254)){
args__4824__auto__.push((arguments[i__4819__auto___71255]));

var G__71256 = (i__4819__auto___71255 + (1));
i__4819__auto___71255 = G__71256;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns.min.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71237){
var state_val_71238 = (state_71237[(1)]);
if((state_val_71238 === (1))){
var state_71237__$1 = state_71237;
var statearr_71239_71257 = state_71237__$1;
(statearr_71239_71257[(2)] = null);

(statearr_71239_71257[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71238 === (2))){
var _ = (function (){var statearr_71240 = state_71237;
(statearr_71240[(4)] = cljs.core.cons((5),(state_71237[(4)])));

return statearr_71240;
})();
var inst_71213 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71237__$1 = state_71237;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71237__$1,(6),inst_71213);
} else {
if((state_val_71238 === (3))){
var inst_71235 = (state_71237[(2)]);
var state_71237__$1 = state_71237;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71237__$1,inst_71235);
} else {
if((state_val_71238 === (4))){
var inst_71207 = (state_71237[(2)]);
var state_71237__$1 = state_71237;
var statearr_71242_71258 = state_71237__$1;
(statearr_71242_71258[(2)] = inst_71207);

(statearr_71242_71258[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71238 === (5))){
var _ = (function (){var statearr_71243 = state_71237;
(statearr_71243[(4)] = cljs.core.rest((state_71237[(4)])));

return statearr_71243;
})();
var state_71237__$1 = state_71237;
var ex71241 = (state_71237__$1[(2)]);
var statearr_71244_71259 = state_71237__$1;
(statearr_71244_71259[(5)] = ex71241);


if((ex71241 instanceof Error)){
var statearr_71245_71260 = state_71237__$1;
(statearr_71245_71260[(1)] = (4));

(statearr_71245_71260[(5)] = null);

} else {
throw ex71241;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71238 === (6))){
var inst_71215 = (state_71237[(2)]);
var inst_71216 = fluree.db.util.async.throw_err(inst_71215);
var inst_71217 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal.min,inst_71216);
var inst_71218 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71219 = [inst_71216];
var inst_71220 = (new cljs.core.PersistentVector(null,1,(5),inst_71218,inst_71219,null));
var inst_71221 = cljs.core.count(inst_71220);
var inst_71222 = ((9) + inst_71221);
var inst_71223 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71224 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71225 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71226 = [inst_71216];
var inst_71227 = (new cljs.core.PersistentVector(null,1,(5),inst_71225,inst_71226,null));
var inst_71228 = ["min",inst_71227,inst_71217];
var inst_71229 = cljs.core.PersistentHashMap.fromArrays(inst_71224,inst_71228);
var inst_71230 = [inst_71229,inst_71222];
var inst_71231 = (new cljs.core.PersistentVector(null,2,(5),inst_71223,inst_71230,null));
var inst_71232 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71231);
var _ = (function (){var statearr_71246 = state_71237;
(statearr_71246[(4)] = cljs.core.rest((state_71237[(4)])));

return statearr_71246;
})();
var state_71237__$1 = (function (){var statearr_71247 = state_71237;
(statearr_71247[(7)] = inst_71232);

return statearr_71247;
})();
var statearr_71248_71261 = state_71237__$1;
(statearr_71248_71261[(2)] = inst_71217);

(statearr_71248_71261[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71249 = [null,null,null,null,null,null,null,null];
(statearr_71249[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71249[(1)] = (1));

return statearr_71249;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71237){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71237);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71250){var ex__16398__auto__ = e71250;
var statearr_71251_71262 = state_71237;
(statearr_71251_71262[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71237[(4)]))){
var statearr_71252_71263 = state_71237;
(statearr_71252_71263[(1)] = cljs.core.first((state_71237[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71264 = state_71237;
state_71237 = G__71264;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71237){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71237);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71253 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71253[(6)] = c__16469__auto__);

return statearr_71253;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.min.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns.min.cljs$lang$applyTo = (function (seq71205){
var G__71206 = cljs.core.first(seq71205);
var seq71205__$1 = cljs.core.next(seq71205);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71206,seq71205__$1);
}));

/**
 * Executes a query
 */
fluree.db.dbfunctions.fns.query = (function fluree$db$dbfunctions$fns$query(var_args){
var G__71266 = arguments.length;
switch (G__71266) {
case 2:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 6:
return fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,query_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71311){
var state_val_71312 = (state_71311[(1)]);
if((state_val_71312 === (7))){
var state_71311__$1 = state_71311;
var statearr_71313_71450 = state_71311__$1;
(statearr_71313_71450[(2)] = query_map);

(statearr_71313_71450[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (1))){
var state_71311__$1 = state_71311;
var statearr_71314_71451 = state_71311__$1;
(statearr_71314_71451[(2)] = null);

(statearr_71314_71451[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (4))){
var inst_71267 = (state_71311[(2)]);
var state_71311__$1 = state_71311;
var statearr_71315_71452 = state_71311__$1;
(statearr_71315_71452[(2)] = inst_71267);

(statearr_71315_71452[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (13))){
var inst_71289 = (state_71311[(7)]);
var inst_71293 = (state_71311[(2)]);
var inst_71294 = fluree.db.util.async.throw_err(inst_71293);
var inst_71295 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71294,(0),null);
var inst_71296 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71294,(1),null);
var inst_71297 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71298 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71299 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71300 = [inst_71289];
var inst_71301 = (new cljs.core.PersistentVector(null,1,(5),inst_71299,inst_71300,null));
var inst_71302 = ["query",inst_71301,inst_71295];
var inst_71303 = cljs.core.PersistentHashMap.fromArrays(inst_71298,inst_71302);
var inst_71304 = [inst_71303,inst_71296];
var inst_71305 = (new cljs.core.PersistentVector(null,2,(5),inst_71297,inst_71304,null));
var inst_71306 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71305);
var _ = (function (){var statearr_71316 = state_71311;
(statearr_71316[(4)] = cljs.core.rest((state_71311[(4)])));

return statearr_71316;
})();
var state_71311__$1 = (function (){var statearr_71317 = state_71311;
(statearr_71317[(8)] = inst_71306);

return statearr_71317;
})();
var statearr_71318_71453 = state_71311__$1;
(statearr_71318_71453[(2)] = inst_71295);

(statearr_71318_71453[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (6))){
var state_71311__$1 = state_71311;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71311__$1,(9),query_map);
} else {
if((state_val_71312 === (3))){
var inst_71309 = (state_71311[(2)]);
var state_71311__$1 = state_71311;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71311__$1,inst_71309);
} else {
if((state_val_71312 === (12))){
var inst_71289 = (state_71311[(7)]);
var inst_71289__$1 = (state_71311[(2)]);
var inst_71290 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71291 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$2(inst_71290,inst_71289__$1);
var state_71311__$1 = (function (){var statearr_71319 = state_71311;
(statearr_71319[(7)] = inst_71289__$1);

return statearr_71319;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71311__$1,(13),inst_71291);
} else {
if((state_val_71312 === (2))){
var _ = (function (){var statearr_71320 = state_71311;
(statearr_71320[(4)] = cljs.core.cons((5),(state_71311[(4)])));

return statearr_71320;
})();
var inst_71276 = fluree.db.util.async.channel_QMARK_(query_map);
var state_71311__$1 = state_71311;
if(inst_71276){
var statearr_71321_71454 = state_71311__$1;
(statearr_71321_71454[(1)] = (6));

} else {
var statearr_71322_71455 = state_71311__$1;
(statearr_71322_71455[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (11))){
var inst_71283 = (state_71311[(9)]);
var state_71311__$1 = state_71311;
var statearr_71324_71456 = state_71311__$1;
(statearr_71324_71456[(2)] = inst_71283);

(statearr_71324_71456[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (9))){
var inst_71279 = (state_71311[(2)]);
var inst_71280 = fluree.db.util.async.throw_err(inst_71279);
var state_71311__$1 = state_71311;
var statearr_71325_71457 = state_71311__$1;
(statearr_71325_71457[(2)] = inst_71280);

(statearr_71325_71457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (5))){
var _ = (function (){var statearr_71326 = state_71311;
(statearr_71326[(4)] = cljs.core.rest((state_71311[(4)])));

return statearr_71326;
})();
var state_71311__$1 = state_71311;
var ex71323 = (state_71311__$1[(2)]);
var statearr_71327_71458 = state_71311__$1;
(statearr_71327_71458[(5)] = ex71323);


if((ex71323 instanceof Error)){
var statearr_71328_71459 = state_71311__$1;
(statearr_71328_71459[(1)] = (4));

(statearr_71328_71459[(5)] = null);

} else {
throw ex71323;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (10))){
var inst_71283 = (state_71311[(9)]);
var inst_71286 = fluree.db.util.json.parse(inst_71283);
var state_71311__$1 = state_71311;
var statearr_71329_71460 = state_71311__$1;
(statearr_71329_71460[(2)] = inst_71286);

(statearr_71329_71460[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71312 === (8))){
var inst_71283 = (state_71311[(9)]);
var inst_71283__$1 = (state_71311[(2)]);
var inst_71284 = typeof inst_71283__$1 === 'string';
var state_71311__$1 = (function (){var statearr_71330 = state_71311;
(statearr_71330[(9)] = inst_71283__$1);

return statearr_71330;
})();
if(cljs.core.truth_(inst_71284)){
var statearr_71331_71461 = state_71311__$1;
(statearr_71331_71461[(1)] = (10));

} else {
var statearr_71332_71462 = state_71311__$1;
(statearr_71332_71462[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71333 = [null,null,null,null,null,null,null,null,null,null];
(statearr_71333[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71333[(1)] = (1));

return statearr_71333;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71311){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71311);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71334){var ex__16398__auto__ = e71334;
var statearr_71335_71463 = state_71311;
(statearr_71335_71463[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71311[(4)]))){
var statearr_71336_71464 = state_71311;
(statearr_71336_71464[(1)] = cljs.core.first((state_71311[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71465 = state_71311;
state_71311 = G__71465;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71311){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71311);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71337 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71337[(6)] = c__16469__auto__);

return statearr_71337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$core$IFn$_invoke$arity$6 = (function (_QMARK_ctx,select,from,where,block,limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71408){
var state_val_71409 = (state_71408[(1)]);
if((state_val_71409 === (7))){
var state_71408__$1 = state_71408;
var statearr_71410_71466 = state_71408__$1;
(statearr_71410_71466[(2)] = select);

(statearr_71410_71466[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (20))){
var inst_71378 = (state_71408[(2)]);
var inst_71379 = fluree.db.util.async.channel_QMARK_(limit);
var state_71408__$1 = (function (){var statearr_71411 = state_71408;
(statearr_71411[(7)] = inst_71378);

return statearr_71411;
})();
if(inst_71379){
var statearr_71412_71467 = state_71408__$1;
(statearr_71412_71467[(1)] = (22));

} else {
var statearr_71413_71468 = state_71408__$1;
(statearr_71413_71468[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (1))){
var state_71408__$1 = state_71408;
var statearr_71414_71469 = state_71408__$1;
(statearr_71414_71469[(2)] = null);

(statearr_71414_71469[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (24))){
var inst_71370 = (state_71408[(8)]);
var inst_71378 = (state_71408[(7)]);
var inst_71362 = (state_71408[(9)]);
var inst_71354 = (state_71408[(10)]);
var inst_71386 = (state_71408[(2)]);
var inst_71387 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71388 = fluree.db.dbfunctions.internal.query.cljs$core$IFn$_invoke$arity$6(inst_71387,inst_71354,inst_71362,inst_71370,inst_71378,inst_71386);
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(26),inst_71388);
} else {
if((state_val_71409 === (4))){
var inst_71338 = (state_71408[(2)]);
var state_71408__$1 = state_71408;
var statearr_71415_71470 = state_71408__$1;
(statearr_71415_71470[(2)] = inst_71338);

(statearr_71415_71470[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (15))){
var state_71408__$1 = state_71408;
var statearr_71416_71471 = state_71408__$1;
(statearr_71416_71471[(2)] = where);

(statearr_71416_71471[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (21))){
var inst_71374 = (state_71408[(2)]);
var inst_71375 = fluree.db.util.async.throw_err(inst_71374);
var state_71408__$1 = state_71408;
var statearr_71417_71472 = state_71408__$1;
(statearr_71417_71472[(2)] = inst_71375);

(statearr_71417_71472[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (13))){
var inst_71358 = (state_71408[(2)]);
var inst_71359 = fluree.db.util.async.throw_err(inst_71358);
var state_71408__$1 = state_71408;
var statearr_71418_71473 = state_71408__$1;
(statearr_71418_71473[(2)] = inst_71359);

(statearr_71418_71473[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (22))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(25),limit);
} else {
if((state_val_71409 === (6))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(9),select);
} else {
if((state_val_71409 === (25))){
var inst_71382 = (state_71408[(2)]);
var inst_71383 = fluree.db.util.async.throw_err(inst_71382);
var state_71408__$1 = state_71408;
var statearr_71419_71474 = state_71408__$1;
(statearr_71419_71474[(2)] = inst_71383);

(statearr_71419_71474[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (17))){
var inst_71366 = (state_71408[(2)]);
var inst_71367 = fluree.db.util.async.throw_err(inst_71366);
var state_71408__$1 = state_71408;
var statearr_71420_71475 = state_71408__$1;
(statearr_71420_71475[(2)] = inst_71367);

(statearr_71420_71475[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (3))){
var inst_71406 = (state_71408[(2)]);
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71408__$1,inst_71406);
} else {
if((state_val_71409 === (12))){
var inst_71362 = (state_71408[(2)]);
var inst_71363 = fluree.db.util.async.channel_QMARK_(where);
var state_71408__$1 = (function (){var statearr_71421 = state_71408;
(statearr_71421[(9)] = inst_71362);

return statearr_71421;
})();
if(inst_71363){
var statearr_71422_71476 = state_71408__$1;
(statearr_71422_71476[(1)] = (14));

} else {
var statearr_71423_71477 = state_71408__$1;
(statearr_71423_71477[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (2))){
var _ = (function (){var statearr_71424 = state_71408;
(statearr_71424[(4)] = cljs.core.cons((5),(state_71408[(4)])));

return statearr_71424;
})();
var inst_71347 = fluree.db.util.async.channel_QMARK_(select);
var state_71408__$1 = state_71408;
if(inst_71347){
var statearr_71425_71478 = state_71408__$1;
(statearr_71425_71478[(1)] = (6));

} else {
var statearr_71426_71479 = state_71408__$1;
(statearr_71426_71479[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (23))){
var state_71408__$1 = state_71408;
var statearr_71427_71480 = state_71408__$1;
(statearr_71427_71480[(2)] = limit);

(statearr_71427_71480[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (19))){
var state_71408__$1 = state_71408;
var statearr_71428_71481 = state_71408__$1;
(statearr_71428_71481[(2)] = block);

(statearr_71428_71481[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (11))){
var state_71408__$1 = state_71408;
var statearr_71430_71482 = state_71408__$1;
(statearr_71430_71482[(2)] = from);

(statearr_71430_71482[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (9))){
var inst_71350 = (state_71408[(2)]);
var inst_71351 = fluree.db.util.async.throw_err(inst_71350);
var state_71408__$1 = state_71408;
var statearr_71431_71483 = state_71408__$1;
(statearr_71431_71483[(2)] = inst_71351);

(statearr_71431_71483[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (5))){
var _ = (function (){var statearr_71432 = state_71408;
(statearr_71432[(4)] = cljs.core.rest((state_71408[(4)])));

return statearr_71432;
})();
var state_71408__$1 = state_71408;
var ex71429 = (state_71408__$1[(2)]);
var statearr_71433_71484 = state_71408__$1;
(statearr_71433_71484[(5)] = ex71429);


if((ex71429 instanceof Error)){
var statearr_71434_71485 = state_71408__$1;
(statearr_71434_71485[(1)] = (4));

(statearr_71434_71485[(5)] = null);

} else {
throw ex71429;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (14))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(17),where);
} else {
if((state_val_71409 === (26))){
var inst_71370 = (state_71408[(8)]);
var inst_71378 = (state_71408[(7)]);
var inst_71362 = (state_71408[(9)]);
var inst_71354 = (state_71408[(10)]);
var inst_71390 = (state_71408[(2)]);
var inst_71391 = fluree.db.util.async.throw_err(inst_71390);
var inst_71392 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71391,(0),null);
var inst_71393 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71391,(1),null);
var inst_71394 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71395 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71396 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71397 = [inst_71354,inst_71362,inst_71370,inst_71378];
var inst_71398 = (new cljs.core.PersistentVector(null,4,(5),inst_71396,inst_71397,null));
var inst_71399 = ["query",inst_71398,inst_71392];
var inst_71400 = cljs.core.PersistentHashMap.fromArrays(inst_71395,inst_71399);
var inst_71401 = [inst_71400,inst_71393];
var inst_71402 = (new cljs.core.PersistentVector(null,2,(5),inst_71394,inst_71401,null));
var inst_71403 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71402);
var _ = (function (){var statearr_71435 = state_71408;
(statearr_71435[(4)] = cljs.core.rest((state_71408[(4)])));

return statearr_71435;
})();
var state_71408__$1 = (function (){var statearr_71436 = state_71408;
(statearr_71436[(11)] = inst_71403);

return statearr_71436;
})();
var statearr_71437_71486 = state_71408__$1;
(statearr_71437_71486[(2)] = inst_71392);

(statearr_71437_71486[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (16))){
var inst_71370 = (state_71408[(2)]);
var inst_71371 = fluree.db.util.async.channel_QMARK_(block);
var state_71408__$1 = (function (){var statearr_71438 = state_71408;
(statearr_71438[(8)] = inst_71370);

return statearr_71438;
})();
if(inst_71371){
var statearr_71439_71487 = state_71408__$1;
(statearr_71439_71487[(1)] = (18));

} else {
var statearr_71440_71488 = state_71408__$1;
(statearr_71440_71488[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71409 === (10))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(13),from);
} else {
if((state_val_71409 === (18))){
var state_71408__$1 = state_71408;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71408__$1,(21),block);
} else {
if((state_val_71409 === (8))){
var inst_71354 = (state_71408[(2)]);
var inst_71355 = fluree.db.util.async.channel_QMARK_(from);
var state_71408__$1 = (function (){var statearr_71441 = state_71408;
(statearr_71441[(10)] = inst_71354);

return statearr_71441;
})();
if(inst_71355){
var statearr_71442_71489 = state_71408__$1;
(statearr_71442_71489[(1)] = (10));

} else {
var statearr_71443_71490 = state_71408__$1;
(statearr_71443_71490[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71444 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71444[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71444[(1)] = (1));

return statearr_71444;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71408){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71408);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71445){var ex__16398__auto__ = e71445;
var statearr_71446_71491 = state_71408;
(statearr_71446_71491[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71408[(4)]))){
var statearr_71447_71492 = state_71408;
(statearr_71447_71492[(1)] = cljs.core.first((state_71408[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71493 = state_71408;
state_71408 = G__71493;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71408){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71448 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71448[(6)] = c__16469__auto__);

return statearr_71448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.query.cljs$lang$maxFixedArity = 6);

/**
 * Determines whether there is a relationship between two subjects
 */
fluree.db.dbfunctions.fns.relationship_QMARK_ = (function fluree$db$dbfunctions$fns$relationship_QMARK_(_QMARK_ctx,startSubject,path,endSubject){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71549){
var state_val_71550 = (state_71549[(1)]);
if((state_val_71550 === (7))){
var state_71549__$1 = state_71549;
var statearr_71551_71582 = state_71549__$1;
(statearr_71551_71582[(2)] = startSubject);

(statearr_71551_71582[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (1))){
var state_71549__$1 = state_71549;
var statearr_71552_71583 = state_71549__$1;
(statearr_71552_71583[(2)] = null);

(statearr_71552_71583[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (4))){
var inst_71494 = (state_71549[(2)]);
var state_71549__$1 = state_71549;
var statearr_71553_71584 = state_71549__$1;
(statearr_71553_71584[(2)] = inst_71494);

(statearr_71553_71584[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (15))){
var inst_71526 = (state_71549[(2)]);
var inst_71527 = fluree.db.util.async.throw_err(inst_71526);
var inst_71528 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71527,(0),null);
var inst_71529 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71527,(1),null);
var inst_71530 = cljs.core.empty_QMARK_(inst_71528);
var state_71549__$1 = (function (){var statearr_71554 = state_71549;
(statearr_71554[(7)] = inst_71529);

return statearr_71554;
})();
if(inst_71530){
var statearr_71555_71585 = state_71549__$1;
(statearr_71555_71585[(1)] = (16));

} else {
var statearr_71556_71586 = state_71549__$1;
(statearr_71556_71586[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (13))){
var inst_71510 = (state_71549[(8)]);
var inst_71514 = (state_71549[(9)]);
var inst_71522 = (state_71549[(10)]);
var inst_71522__$1 = (state_71549[(2)]);
var inst_71523 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71524 = fluree.db.dbfunctions.internal.relationship_QMARK_(inst_71523,inst_71510,inst_71514,inst_71522__$1);
var state_71549__$1 = (function (){var statearr_71557 = state_71549;
(statearr_71557[(10)] = inst_71522__$1);

return statearr_71557;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71549__$1,(15),inst_71524);
} else {
if((state_val_71550 === (6))){
var state_71549__$1 = state_71549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71549__$1,(9),startSubject);
} else {
if((state_val_71550 === (17))){
var state_71549__$1 = state_71549;
var statearr_71558_71587 = state_71549__$1;
(statearr_71558_71587[(2)] = true);

(statearr_71558_71587[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (3))){
var inst_71547 = (state_71549[(2)]);
var state_71549__$1 = state_71549;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71549__$1,inst_71547);
} else {
if((state_val_71550 === (12))){
var state_71549__$1 = state_71549;
var statearr_71559_71588 = state_71549__$1;
(statearr_71559_71588[(2)] = endSubject);

(statearr_71559_71588[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (2))){
var _ = (function (){var statearr_71560 = state_71549;
(statearr_71560[(4)] = cljs.core.cons((5),(state_71549[(4)])));

return statearr_71560;
})();
var inst_71503 = fluree.db.util.async.channel_QMARK_(startSubject);
var state_71549__$1 = state_71549;
if(inst_71503){
var statearr_71561_71589 = state_71549__$1;
(statearr_71561_71589[(1)] = (6));

} else {
var statearr_71562_71590 = state_71549__$1;
(statearr_71562_71590[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (11))){
var state_71549__$1 = state_71549;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71549__$1,(14),endSubject);
} else {
if((state_val_71550 === (9))){
var inst_71506 = (state_71549[(2)]);
var inst_71507 = fluree.db.util.async.throw_err(inst_71506);
var state_71549__$1 = state_71549;
var statearr_71564_71591 = state_71549__$1;
(statearr_71564_71591[(2)] = inst_71507);

(statearr_71564_71591[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (5))){
var _ = (function (){var statearr_71565 = state_71549;
(statearr_71565[(4)] = cljs.core.rest((state_71549[(4)])));

return statearr_71565;
})();
var state_71549__$1 = state_71549;
var ex71563 = (state_71549__$1[(2)]);
var statearr_71566_71592 = state_71549__$1;
(statearr_71566_71592[(5)] = ex71563);


if((ex71563 instanceof Error)){
var statearr_71567_71593 = state_71549__$1;
(statearr_71567_71593[(1)] = (4));

(statearr_71567_71593[(5)] = null);

} else {
throw ex71563;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (14))){
var inst_71518 = (state_71549[(2)]);
var inst_71519 = fluree.db.util.async.throw_err(inst_71518);
var state_71549__$1 = state_71549;
var statearr_71568_71594 = state_71549__$1;
(statearr_71568_71594[(2)] = inst_71519);

(statearr_71568_71594[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (16))){
var state_71549__$1 = state_71549;
var statearr_71569_71595 = state_71549__$1;
(statearr_71569_71595[(2)] = false);

(statearr_71569_71595[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (10))){
var inst_71513 = (state_71549[(2)]);
var inst_71514 = fluree.db.util.async.throw_err(inst_71513);
var inst_71515 = fluree.db.util.async.channel_QMARK_(endSubject);
var state_71549__$1 = (function (){var statearr_71570 = state_71549;
(statearr_71570[(9)] = inst_71514);

return statearr_71570;
})();
if(inst_71515){
var statearr_71571_71596 = state_71549__$1;
(statearr_71571_71596[(1)] = (11));

} else {
var statearr_71572_71597 = state_71549__$1;
(statearr_71572_71597[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (18))){
var inst_71529 = (state_71549[(7)]);
var inst_71510 = (state_71549[(8)]);
var inst_71514 = (state_71549[(9)]);
var inst_71522 = (state_71549[(10)]);
var inst_71534 = (state_71549[(2)]);
var inst_71535 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71536 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71537 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71538 = [inst_71510,inst_71514,inst_71522];
var inst_71539 = (new cljs.core.PersistentVector(null,3,(5),inst_71537,inst_71538,null));
var inst_71540 = ["relationship?",inst_71539,inst_71534];
var inst_71541 = cljs.core.PersistentHashMap.fromArrays(inst_71536,inst_71540);
var inst_71542 = [inst_71541,inst_71529];
var inst_71543 = (new cljs.core.PersistentVector(null,2,(5),inst_71535,inst_71542,null));
var inst_71544 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71543);
var _ = (function (){var statearr_71573 = state_71549;
(statearr_71573[(4)] = cljs.core.rest((state_71549[(4)])));

return statearr_71573;
})();
var state_71549__$1 = (function (){var statearr_71574 = state_71549;
(statearr_71574[(11)] = inst_71544);

return statearr_71574;
})();
var statearr_71575_71598 = state_71549__$1;
(statearr_71575_71598[(2)] = inst_71534);

(statearr_71575_71598[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71550 === (8))){
var inst_71510 = (state_71549[(2)]);
var inst_71511 = fluree.db.dbfunctions.fns.coerce_args(path);
var state_71549__$1 = (function (){var statearr_71576 = state_71549;
(statearr_71576[(8)] = inst_71510);

return statearr_71576;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71549__$1,(10),inst_71511);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_71577 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_71577[(0)] = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__);

(statearr_71577[(1)] = (1));

return statearr_71577;
});
var fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1 = (function (state_71549){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71549);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71578){var ex__16398__auto__ = e71578;
var statearr_71579_71599 = state_71549;
(statearr_71579_71599[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71549[(4)]))){
var statearr_71580_71600 = state_71549;
(statearr_71580_71600[(1)] = cljs.core.first((state_71549[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71601 = state_71549;
state_71549 = G__71601;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__ = function(state_71549){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1.call(this,state_71549);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$relationship_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71581 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71581[(6)] = c__16469__auto__);

return statearr_71581;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Finds the maximum predicate value.
 */
fluree.db.dbfunctions.fns.max_pred_val = (function fluree$db$dbfunctions$fns$max_pred_val(_QMARK_ctx,pred_name){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71638){
var state_val_71639 = (state_71638[(1)]);
if((state_val_71639 === (7))){
var state_71638__$1 = state_71638;
var statearr_71640_71660 = state_71638__$1;
(statearr_71640_71660[(2)] = pred_name);

(statearr_71640_71660[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (1))){
var state_71638__$1 = state_71638;
var statearr_71641_71661 = state_71638__$1;
(statearr_71641_71661[(2)] = null);

(statearr_71641_71661[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (4))){
var inst_71602 = (state_71638[(2)]);
var state_71638__$1 = state_71638;
var statearr_71642_71662 = state_71638__$1;
(statearr_71642_71662[(2)] = inst_71602);

(statearr_71642_71662[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (6))){
var state_71638__$1 = state_71638;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71638__$1,(9),pred_name);
} else {
if((state_val_71639 === (3))){
var inst_71636 = (state_71638[(2)]);
var state_71638__$1 = state_71638;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71638__$1,inst_71636);
} else {
if((state_val_71639 === (2))){
var _ = (function (){var statearr_71644 = state_71638;
(statearr_71644[(4)] = cljs.core.cons((5),(state_71638[(4)])));

return statearr_71644;
})();
var inst_71611 = fluree.db.util.async.channel_QMARK_(pred_name);
var state_71638__$1 = state_71638;
if(inst_71611){
var statearr_71645_71663 = state_71638__$1;
(statearr_71645_71663[(1)] = (6));

} else {
var statearr_71646_71664 = state_71638__$1;
(statearr_71646_71664[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (9))){
var inst_71614 = (state_71638[(2)]);
var inst_71615 = fluree.db.util.async.throw_err(inst_71614);
var state_71638__$1 = state_71638;
var statearr_71647_71665 = state_71638__$1;
(statearr_71647_71665[(2)] = inst_71615);

(statearr_71647_71665[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (5))){
var _ = (function (){var statearr_71648 = state_71638;
(statearr_71648[(4)] = cljs.core.rest((state_71638[(4)])));

return statearr_71648;
})();
var state_71638__$1 = state_71638;
var ex71643 = (state_71638__$1[(2)]);
var statearr_71649_71666 = state_71638__$1;
(statearr_71649_71666[(5)] = ex71643);


if((ex71643 instanceof Error)){
var statearr_71650_71667 = state_71638__$1;
(statearr_71650_71667[(1)] = (4));

(statearr_71650_71667[(5)] = null);

} else {
throw ex71643;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (10))){
var inst_71618 = (state_71638[(7)]);
var inst_71622 = (state_71638[(2)]);
var inst_71623 = fluree.db.util.async.throw_err(inst_71622);
var inst_71624 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71623,(0),null);
var inst_71625 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_71623,(1),null);
var inst_71626 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71627 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71628 = ["max-pred-val",inst_71618,inst_71624];
var inst_71629 = cljs.core.PersistentHashMap.fromArrays(inst_71627,inst_71628);
var inst_71630 = (inst_71625 + (10));
var inst_71631 = [inst_71629,inst_71630];
var inst_71632 = (new cljs.core.PersistentVector(null,2,(5),inst_71626,inst_71631,null));
var inst_71633 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71632);
var _ = (function (){var statearr_71651 = state_71638;
(statearr_71651[(4)] = cljs.core.rest((state_71638[(4)])));

return statearr_71651;
})();
var state_71638__$1 = (function (){var statearr_71652 = state_71638;
(statearr_71652[(8)] = inst_71633);

return statearr_71652;
})();
var statearr_71653_71668 = state_71638__$1;
(statearr_71653_71668[(2)] = inst_71624);

(statearr_71653_71668[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71639 === (8))){
var inst_71618 = (state_71638[(7)]);
var inst_71618__$1 = (state_71638[(2)]);
var inst_71619 = cljs.core.cst$kw$db.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_71620 = fluree.db.dbfunctions.internal.max_pred_val(inst_71619,inst_71618__$1,null);
var state_71638__$1 = (function (){var statearr_71654 = state_71638;
(statearr_71654[(7)] = inst_71618__$1);

return statearr_71654;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71638__$1,(10),inst_71620);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0 = (function (){
var statearr_71655 = [null,null,null,null,null,null,null,null,null];
(statearr_71655[(0)] = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__);

(statearr_71655[(1)] = (1));

return statearr_71655;
});
var fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1 = (function (state_71638){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71638);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71656){var ex__16398__auto__ = e71656;
var statearr_71657_71669 = state_71638;
(statearr_71657_71669[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71638[(4)]))){
var statearr_71658_71670 = state_71638;
(statearr_71658_71670[(1)] = cljs.core.first((state_71638[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71671 = state_71638;
state_71638 = G__71671;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__ = function(state_71638){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1.call(this,state_71638);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$max_pred_val_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71659 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71659[(6)] = c__16469__auto__);

return statearr_71659;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Increments any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.inc = (function fluree$db$dbfunctions$fns$inc(_QMARK_ctx,n){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71698){
var state_val_71699 = (state_71698[(1)]);
if((state_val_71699 === (7))){
var state_71698__$1 = state_71698;
var statearr_71700_71719 = state_71698__$1;
(statearr_71700_71719[(2)] = n);

(statearr_71700_71719[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (1))){
var state_71698__$1 = state_71698;
var statearr_71701_71720 = state_71698__$1;
(statearr_71701_71720[(2)] = null);

(statearr_71701_71720[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (4))){
var inst_71672 = (state_71698[(2)]);
var state_71698__$1 = state_71698;
var statearr_71702_71721 = state_71698__$1;
(statearr_71702_71721[(2)] = inst_71672);

(statearr_71702_71721[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (6))){
var state_71698__$1 = state_71698;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71698__$1,(9),n);
} else {
if((state_val_71699 === (3))){
var inst_71696 = (state_71698[(2)]);
var state_71698__$1 = state_71698;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71698__$1,inst_71696);
} else {
if((state_val_71699 === (2))){
var _ = (function (){var statearr_71704 = state_71698;
(statearr_71704[(4)] = cljs.core.cons((5),(state_71698[(4)])));

return statearr_71704;
})();
var inst_71678 = fluree.db.util.async.channel_QMARK_(n);
var state_71698__$1 = state_71698;
if(inst_71678){
var statearr_71705_71722 = state_71698__$1;
(statearr_71705_71722[(1)] = (6));

} else {
var statearr_71706_71723 = state_71698__$1;
(statearr_71706_71723[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (9))){
var inst_71681 = (state_71698[(2)]);
var inst_71682 = fluree.db.util.async.throw_err(inst_71681);
var state_71698__$1 = state_71698;
var statearr_71707_71724 = state_71698__$1;
(statearr_71707_71724[(2)] = inst_71682);

(statearr_71707_71724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (5))){
var _ = (function (){var statearr_71708 = state_71698;
(statearr_71708[(4)] = cljs.core.rest((state_71698[(4)])));

return statearr_71708;
})();
var state_71698__$1 = state_71698;
var ex71703 = (state_71698__$1[(2)]);
var statearr_71709_71725 = state_71698__$1;
(statearr_71709_71725[(5)] = ex71703);


if((ex71703 instanceof Error)){
var statearr_71710_71726 = state_71698__$1;
(statearr_71710_71726[(1)] = (4));

(statearr_71710_71726[(5)] = null);

} else {
throw ex71703;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71699 === (8))){
var inst_71685 = (state_71698[(2)]);
var inst_71686 = fluree.db.dbfunctions.internal.inc(inst_71685);
var inst_71687 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71688 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71689 = ["inc",inst_71685,inst_71686];
var inst_71690 = cljs.core.PersistentHashMap.fromArrays(inst_71688,inst_71689);
var inst_71691 = [inst_71690,(10)];
var inst_71692 = (new cljs.core.PersistentVector(null,2,(5),inst_71687,inst_71691,null));
var inst_71693 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71692);
var _ = (function (){var statearr_71711 = state_71698;
(statearr_71711[(4)] = cljs.core.rest((state_71698[(4)])));

return statearr_71711;
})();
var state_71698__$1 = (function (){var statearr_71712 = state_71698;
(statearr_71712[(7)] = inst_71693);

return statearr_71712;
})();
var statearr_71713_71727 = state_71698__$1;
(statearr_71713_71727[(2)] = inst_71686);

(statearr_71713_71727[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0 = (function (){
var statearr_71714 = [null,null,null,null,null,null,null,null];
(statearr_71714[(0)] = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__);

(statearr_71714[(1)] = (1));

return statearr_71714;
});
var fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1 = (function (state_71698){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71698);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71715){var ex__16398__auto__ = e71715;
var statearr_71716_71728 = state_71698;
(statearr_71716_71728[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71698[(4)]))){
var statearr_71717_71729 = state_71698;
(statearr_71717_71729[(1)] = cljs.core.first((state_71698[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71730 = state_71698;
state_71698 = G__71730;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__ = function(state_71698){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1.call(this,state_71698);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$inc_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71718 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71718[(6)] = c__16469__auto__);

return statearr_71718;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Decrements any number (or nil/null) by 1.
 */
fluree.db.dbfunctions.fns.dec = (function fluree$db$dbfunctions$fns$dec(_QMARK_ctx,n){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71757){
var state_val_71758 = (state_71757[(1)]);
if((state_val_71758 === (7))){
var state_71757__$1 = state_71757;
var statearr_71759_71778 = state_71757__$1;
(statearr_71759_71778[(2)] = n);

(statearr_71759_71778[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (1))){
var state_71757__$1 = state_71757;
var statearr_71760_71779 = state_71757__$1;
(statearr_71760_71779[(2)] = null);

(statearr_71760_71779[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (4))){
var inst_71731 = (state_71757[(2)]);
var state_71757__$1 = state_71757;
var statearr_71761_71780 = state_71757__$1;
(statearr_71761_71780[(2)] = inst_71731);

(statearr_71761_71780[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (6))){
var state_71757__$1 = state_71757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71757__$1,(9),n);
} else {
if((state_val_71758 === (3))){
var inst_71755 = (state_71757[(2)]);
var state_71757__$1 = state_71757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71757__$1,inst_71755);
} else {
if((state_val_71758 === (2))){
var _ = (function (){var statearr_71763 = state_71757;
(statearr_71763[(4)] = cljs.core.cons((5),(state_71757[(4)])));

return statearr_71763;
})();
var inst_71737 = fluree.db.util.async.channel_QMARK_(n);
var state_71757__$1 = state_71757;
if(inst_71737){
var statearr_71764_71781 = state_71757__$1;
(statearr_71764_71781[(1)] = (6));

} else {
var statearr_71765_71782 = state_71757__$1;
(statearr_71765_71782[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (9))){
var inst_71740 = (state_71757[(2)]);
var inst_71741 = fluree.db.util.async.throw_err(inst_71740);
var state_71757__$1 = state_71757;
var statearr_71766_71783 = state_71757__$1;
(statearr_71766_71783[(2)] = inst_71741);

(statearr_71766_71783[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (5))){
var _ = (function (){var statearr_71767 = state_71757;
(statearr_71767[(4)] = cljs.core.rest((state_71757[(4)])));

return statearr_71767;
})();
var state_71757__$1 = state_71757;
var ex71762 = (state_71757__$1[(2)]);
var statearr_71768_71784 = state_71757__$1;
(statearr_71768_71784[(5)] = ex71762);


if((ex71762 instanceof Error)){
var statearr_71769_71785 = state_71757__$1;
(statearr_71769_71785[(1)] = (4));

(statearr_71769_71785[(5)] = null);

} else {
throw ex71762;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71758 === (8))){
var inst_71744 = (state_71757[(2)]);
var inst_71745 = fluree.db.dbfunctions.internal.dec(inst_71744);
var inst_71746 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71747 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71748 = ["dec",inst_71744,inst_71745];
var inst_71749 = cljs.core.PersistentHashMap.fromArrays(inst_71747,inst_71748);
var inst_71750 = [inst_71749,(10)];
var inst_71751 = (new cljs.core.PersistentVector(null,2,(5),inst_71746,inst_71750,null));
var inst_71752 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71751);
var _ = (function (){var statearr_71770 = state_71757;
(statearr_71770[(4)] = cljs.core.rest((state_71757[(4)])));

return statearr_71770;
})();
var state_71757__$1 = (function (){var statearr_71771 = state_71757;
(statearr_71771[(7)] = inst_71752);

return statearr_71771;
})();
var statearr_71772_71786 = state_71757__$1;
(statearr_71772_71786[(2)] = inst_71745);

(statearr_71772_71786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0 = (function (){
var statearr_71773 = [null,null,null,null,null,null,null,null];
(statearr_71773[(0)] = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__);

(statearr_71773[(1)] = (1));

return statearr_71773;
});
var fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1 = (function (state_71757){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71757);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71774){var ex__16398__auto__ = e71774;
var statearr_71775_71787 = state_71757;
(statearr_71775_71787[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71757[(4)]))){
var statearr_71776_71788 = state_71757;
(statearr_71776_71788[(1)] = cljs.core.first((state_71757[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71789 = state_71757;
state_71757 = G__71789;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__ = function(state_71757){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1.call(this,state_71757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$dec_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71777 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71777[(6)] = c__16469__auto__);

return statearr_71777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns current epoch milliseconds on the executing machine.
 */
fluree.db.dbfunctions.fns.now = (function fluree$db$dbfunctions$fns$now(_QMARK_ctx){
var res = cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"now",cljs.core.cst$kw$arguments,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
});
/**
 * Returns sum of each argument.
 */
fluree.db.dbfunctions.fns._PLUS_ = (function fluree$db$dbfunctions$fns$_PLUS_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71839 = arguments.length;
var i__4819__auto___71840 = (0);
while(true){
if((i__4819__auto___71840 < len__4818__auto___71839)){
args__4824__auto__.push((arguments[i__4819__auto___71840]));

var G__71841 = (i__4819__auto___71840 + (1));
i__4819__auto___71840 = G__71841;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._PLUS_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71822){
var state_val_71823 = (state_71822[(1)]);
if((state_val_71823 === (1))){
var state_71822__$1 = state_71822;
var statearr_71824_71842 = state_71822__$1;
(statearr_71824_71842[(2)] = null);

(statearr_71824_71842[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71823 === (2))){
var _ = (function (){var statearr_71825 = state_71822;
(statearr_71825[(4)] = cljs.core.cons((5),(state_71822[(4)])));

return statearr_71825;
})();
var inst_71798 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71822__$1 = state_71822;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71822__$1,(6),inst_71798);
} else {
if((state_val_71823 === (3))){
var inst_71820 = (state_71822[(2)]);
var state_71822__$1 = state_71822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71822__$1,inst_71820);
} else {
if((state_val_71823 === (4))){
var inst_71792 = (state_71822[(2)]);
var state_71822__$1 = state_71822;
var statearr_71827_71843 = state_71822__$1;
(statearr_71827_71843[(2)] = inst_71792);

(statearr_71827_71843[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71823 === (5))){
var _ = (function (){var statearr_71828 = state_71822;
(statearr_71828[(4)] = cljs.core.rest((state_71822[(4)])));

return statearr_71828;
})();
var state_71822__$1 = state_71822;
var ex71826 = (state_71822__$1[(2)]);
var statearr_71829_71844 = state_71822__$1;
(statearr_71829_71844[(5)] = ex71826);


if((ex71826 instanceof Error)){
var statearr_71830_71845 = state_71822__$1;
(statearr_71830_71845[(1)] = (4));

(statearr_71830_71845[(5)] = null);

} else {
throw ex71826;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71823 === (6))){
var inst_71800 = (state_71822[(2)]);
var inst_71801 = fluree.db.util.async.throw_err(inst_71800);
var inst_71802 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._PLUS_,inst_71801);
var inst_71803 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71804 = [inst_71801];
var inst_71805 = (new cljs.core.PersistentVector(null,1,(5),inst_71803,inst_71804,null));
var inst_71806 = cljs.core.count(inst_71805);
var inst_71807 = ((9) + inst_71806);
var inst_71808 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71809 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71810 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71811 = [inst_71801];
var inst_71812 = (new cljs.core.PersistentVector(null,1,(5),inst_71810,inst_71811,null));
var inst_71813 = ["+",inst_71812,inst_71802];
var inst_71814 = cljs.core.PersistentHashMap.fromArrays(inst_71809,inst_71813);
var inst_71815 = [inst_71814,inst_71807];
var inst_71816 = (new cljs.core.PersistentVector(null,2,(5),inst_71808,inst_71815,null));
var inst_71817 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71816);
var _ = (function (){var statearr_71831 = state_71822;
(statearr_71831[(4)] = cljs.core.rest((state_71822[(4)])));

return statearr_71831;
})();
var state_71822__$1 = (function (){var statearr_71832 = state_71822;
(statearr_71832[(7)] = inst_71817);

return statearr_71832;
})();
var statearr_71833_71846 = state_71822__$1;
(statearr_71833_71846[(2)] = inst_71802);

(statearr_71833_71846[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71834 = [null,null,null,null,null,null,null,null];
(statearr_71834[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71834[(1)] = (1));

return statearr_71834;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71822){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71822);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71835){var ex__16398__auto__ = e71835;
var statearr_71836_71847 = state_71822;
(statearr_71836_71847[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71822[(4)]))){
var statearr_71837_71848 = state_71822;
(statearr_71837_71848[(1)] = cljs.core.first((state_71822[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71849 = state_71822;
state_71822 = G__71849;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71822){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71838 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71838[(6)] = c__16469__auto__);

return statearr_71838;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._PLUS_.cljs$lang$applyTo = (function (seq71790){
var G__71791 = cljs.core.first(seq71790);
var seq71790__$1 = cljs.core.next(seq71790);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71791,seq71790__$1);
}));

/**
 * Returns difference of all the numbers in the sequence with the first number as the minuend.
 */
fluree.db.dbfunctions.fns._ = (function fluree$db$dbfunctions$fns$_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71899 = arguments.length;
var i__4819__auto___71900 = (0);
while(true){
if((i__4819__auto___71900 < len__4818__auto___71899)){
args__4824__auto__.push((arguments[i__4819__auto___71900]));

var G__71901 = (i__4819__auto___71900 + (1));
i__4819__auto___71900 = G__71901;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71882){
var state_val_71883 = (state_71882[(1)]);
if((state_val_71883 === (1))){
var state_71882__$1 = state_71882;
var statearr_71884_71902 = state_71882__$1;
(statearr_71884_71902[(2)] = null);

(statearr_71884_71902[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71883 === (2))){
var _ = (function (){var statearr_71885 = state_71882;
(statearr_71885[(4)] = cljs.core.cons((5),(state_71882[(4)])));

return statearr_71885;
})();
var inst_71858 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71882__$1 = state_71882;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71882__$1,(6),inst_71858);
} else {
if((state_val_71883 === (3))){
var inst_71880 = (state_71882[(2)]);
var state_71882__$1 = state_71882;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71882__$1,inst_71880);
} else {
if((state_val_71883 === (4))){
var inst_71852 = (state_71882[(2)]);
var state_71882__$1 = state_71882;
var statearr_71887_71903 = state_71882__$1;
(statearr_71887_71903[(2)] = inst_71852);

(statearr_71887_71903[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71883 === (5))){
var _ = (function (){var statearr_71888 = state_71882;
(statearr_71888[(4)] = cljs.core.rest((state_71882[(4)])));

return statearr_71888;
})();
var state_71882__$1 = state_71882;
var ex71886 = (state_71882__$1[(2)]);
var statearr_71889_71904 = state_71882__$1;
(statearr_71889_71904[(5)] = ex71886);


if((ex71886 instanceof Error)){
var statearr_71890_71905 = state_71882__$1;
(statearr_71890_71905[(1)] = (4));

(statearr_71890_71905[(5)] = null);

} else {
throw ex71886;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71883 === (6))){
var inst_71860 = (state_71882[(2)]);
var inst_71861 = fluree.db.util.async.throw_err(inst_71860);
var inst_71862 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._,inst_71861);
var inst_71863 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71864 = [inst_71861];
var inst_71865 = (new cljs.core.PersistentVector(null,1,(5),inst_71863,inst_71864,null));
var inst_71866 = cljs.core.count(inst_71865);
var inst_71867 = ((9) + inst_71866);
var inst_71868 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71869 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71870 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71871 = [inst_71861];
var inst_71872 = (new cljs.core.PersistentVector(null,1,(5),inst_71870,inst_71871,null));
var inst_71873 = ["-",inst_71872,inst_71862];
var inst_71874 = cljs.core.PersistentHashMap.fromArrays(inst_71869,inst_71873);
var inst_71875 = [inst_71874,inst_71867];
var inst_71876 = (new cljs.core.PersistentVector(null,2,(5),inst_71868,inst_71875,null));
var inst_71877 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71876);
var _ = (function (){var statearr_71891 = state_71882;
(statearr_71891[(4)] = cljs.core.rest((state_71882[(4)])));

return statearr_71891;
})();
var state_71882__$1 = (function (){var statearr_71892 = state_71882;
(statearr_71892[(7)] = inst_71877);

return statearr_71892;
})();
var statearr_71893_71906 = state_71882__$1;
(statearr_71893_71906[(2)] = inst_71862);

(statearr_71893_71906[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71894 = [null,null,null,null,null,null,null,null];
(statearr_71894[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71894[(1)] = (1));

return statearr_71894;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71882){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71882);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71895){var ex__16398__auto__ = e71895;
var statearr_71896_71907 = state_71882;
(statearr_71896_71907[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71882[(4)]))){
var statearr_71897_71908 = state_71882;
(statearr_71897_71908[(1)] = cljs.core.first((state_71882[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71909 = state_71882;
state_71882 = G__71909;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71882){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71882);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71898 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71898[(6)] = c__16469__auto__);

return statearr_71898;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._.cljs$lang$applyTo = (function (seq71850){
var G__71851 = cljs.core.first(seq71850);
var seq71850__$1 = cljs.core.next(seq71850);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71851,seq71850__$1);
}));

/**
 * Returns product of all the numbers in the sequence.
 */
fluree.db.dbfunctions.fns._STAR_ = (function fluree$db$dbfunctions$fns$_STAR_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___71959 = arguments.length;
var i__4819__auto___71960 = (0);
while(true){
if((i__4819__auto___71960 < len__4818__auto___71959)){
args__4824__auto__.push((arguments[i__4819__auto___71960]));

var G__71961 = (i__4819__auto___71960 + (1));
i__4819__auto___71960 = G__71961;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._STAR_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_71942){
var state_val_71943 = (state_71942[(1)]);
if((state_val_71943 === (1))){
var state_71942__$1 = state_71942;
var statearr_71944_71962 = state_71942__$1;
(statearr_71944_71962[(2)] = null);

(statearr_71944_71962[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71943 === (2))){
var _ = (function (){var statearr_71945 = state_71942;
(statearr_71945[(4)] = cljs.core.cons((5),(state_71942[(4)])));

return statearr_71945;
})();
var inst_71918 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_71942__$1 = state_71942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_71942__$1,(6),inst_71918);
} else {
if((state_val_71943 === (3))){
var inst_71940 = (state_71942[(2)]);
var state_71942__$1 = state_71942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_71942__$1,inst_71940);
} else {
if((state_val_71943 === (4))){
var inst_71912 = (state_71942[(2)]);
var state_71942__$1 = state_71942;
var statearr_71947_71963 = state_71942__$1;
(statearr_71947_71963[(2)] = inst_71912);

(statearr_71947_71963[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_71943 === (5))){
var _ = (function (){var statearr_71948 = state_71942;
(statearr_71948[(4)] = cljs.core.rest((state_71942[(4)])));

return statearr_71948;
})();
var state_71942__$1 = state_71942;
var ex71946 = (state_71942__$1[(2)]);
var statearr_71949_71964 = state_71942__$1;
(statearr_71949_71964[(5)] = ex71946);


if((ex71946 instanceof Error)){
var statearr_71950_71965 = state_71942__$1;
(statearr_71950_71965[(1)] = (4));

(statearr_71950_71965[(5)] = null);

} else {
throw ex71946;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_71943 === (6))){
var inst_71920 = (state_71942[(2)]);
var inst_71921 = fluree.db.util.async.throw_err(inst_71920);
var inst_71922 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._STAR_,inst_71921);
var inst_71923 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71924 = [inst_71921];
var inst_71925 = (new cljs.core.PersistentVector(null,1,(5),inst_71923,inst_71924,null));
var inst_71926 = cljs.core.count(inst_71925);
var inst_71927 = ((9) + inst_71926);
var inst_71928 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71929 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71930 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71931 = [inst_71921];
var inst_71932 = (new cljs.core.PersistentVector(null,1,(5),inst_71930,inst_71931,null));
var inst_71933 = ["*",inst_71932,inst_71922];
var inst_71934 = cljs.core.PersistentHashMap.fromArrays(inst_71929,inst_71933);
var inst_71935 = [inst_71934,inst_71927];
var inst_71936 = (new cljs.core.PersistentVector(null,2,(5),inst_71928,inst_71935,null));
var inst_71937 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71936);
var _ = (function (){var statearr_71951 = state_71942;
(statearr_71951[(4)] = cljs.core.rest((state_71942[(4)])));

return statearr_71951;
})();
var state_71942__$1 = (function (){var statearr_71952 = state_71942;
(statearr_71952[(7)] = inst_71937);

return statearr_71952;
})();
var statearr_71953_71966 = state_71942__$1;
(statearr_71953_71966[(2)] = inst_71922);

(statearr_71953_71966[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_71954 = [null,null,null,null,null,null,null,null];
(statearr_71954[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_71954[(1)] = (1));

return statearr_71954;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_71942){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_71942);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e71955){var ex__16398__auto__ = e71955;
var statearr_71956_71967 = state_71942;
(statearr_71956_71967[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_71942[(4)]))){
var statearr_71957_71968 = state_71942;
(statearr_71957_71968[(1)] = cljs.core.first((state_71942[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__71969 = state_71942;
state_71942 = G__71969;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_71942){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_71942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_71958 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_71958[(6)] = c__16469__auto__);

return statearr_71958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._STAR_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._STAR_.cljs$lang$applyTo = (function (seq71910){
var G__71911 = cljs.core.first(seq71910);
var seq71910__$1 = cljs.core.next(seq71910);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71911,seq71910__$1);
}));

/**
 * If no denominators are supplied, returns 1/numerator, else returns numerator divided by all of the denominators. Takes a sequence
 */
fluree.db.dbfunctions.fns._SLASH_ = (function fluree$db$dbfunctions$fns$_SLASH_(var_args){
var args__4824__auto__ = [];
var len__4818__auto___72019 = arguments.length;
var i__4819__auto___72020 = (0);
while(true){
if((i__4819__auto___72020 < len__4818__auto___72019)){
args__4824__auto__.push((arguments[i__4819__auto___72020]));

var G__72021 = (i__4819__auto___72020 + (1));
i__4819__auto___72020 = G__72021;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(fluree.db.dbfunctions.fns._SLASH_.cljs$core$IFn$_invoke$arity$variadic = (function (_QMARK_ctx,args){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72002){
var state_val_72003 = (state_72002[(1)]);
if((state_val_72003 === (1))){
var state_72002__$1 = state_72002;
var statearr_72004_72022 = state_72002__$1;
(statearr_72004_72022[(2)] = null);

(statearr_72004_72022[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72003 === (2))){
var _ = (function (){var statearr_72005 = state_72002;
(statearr_72005[(4)] = cljs.core.cons((5),(state_72002[(4)])));

return statearr_72005;
})();
var inst_71978 = fluree.db.dbfunctions.fns.coerce_args(args);
var state_72002__$1 = state_72002;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72002__$1,(6),inst_71978);
} else {
if((state_val_72003 === (3))){
var inst_72000 = (state_72002[(2)]);
var state_72002__$1 = state_72002;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72002__$1,inst_72000);
} else {
if((state_val_72003 === (4))){
var inst_71972 = (state_72002[(2)]);
var state_72002__$1 = state_72002;
var statearr_72007_72023 = state_72002__$1;
(statearr_72007_72023[(2)] = inst_71972);

(statearr_72007_72023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72003 === (5))){
var _ = (function (){var statearr_72008 = state_72002;
(statearr_72008[(4)] = cljs.core.rest((state_72002[(4)])));

return statearr_72008;
})();
var state_72002__$1 = state_72002;
var ex72006 = (state_72002__$1[(2)]);
var statearr_72009_72024 = state_72002__$1;
(statearr_72009_72024[(5)] = ex72006);


if((ex72006 instanceof Error)){
var statearr_72010_72025 = state_72002__$1;
(statearr_72010_72025[(1)] = (4));

(statearr_72010_72025[(5)] = null);

} else {
throw ex72006;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72003 === (6))){
var inst_71980 = (state_72002[(2)]);
var inst_71981 = fluree.db.util.async.throw_err(inst_71980);
var inst_71982 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(fluree.db.dbfunctions.internal._SLASH_,inst_71981);
var inst_71983 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71984 = [inst_71981];
var inst_71985 = (new cljs.core.PersistentVector(null,1,(5),inst_71983,inst_71984,null));
var inst_71986 = cljs.core.count(inst_71985);
var inst_71987 = ((9) + inst_71986);
var inst_71988 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71989 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_71990 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_71991 = [inst_71981];
var inst_71992 = (new cljs.core.PersistentVector(null,1,(5),inst_71990,inst_71991,null));
var inst_71993 = ["/",inst_71992,inst_71982];
var inst_71994 = cljs.core.PersistentHashMap.fromArrays(inst_71989,inst_71993);
var inst_71995 = [inst_71994,inst_71987];
var inst_71996 = (new cljs.core.PersistentVector(null,2,(5),inst_71988,inst_71995,null));
var inst_71997 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_71996);
var _ = (function (){var statearr_72011 = state_72002;
(statearr_72011[(4)] = cljs.core.rest((state_72002[(4)])));

return statearr_72011;
})();
var state_72002__$1 = (function (){var statearr_72012 = state_72002;
(statearr_72012[(7)] = inst_71997);

return statearr_72012;
})();
var statearr_72013_72026 = state_72002__$1;
(statearr_72013_72026[(2)] = inst_71982);

(statearr_72013_72026[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_72014 = [null,null,null,null,null,null,null,null];
(statearr_72014[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_72014[(1)] = (1));

return statearr_72014;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_72002){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72002);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72015){var ex__16398__auto__ = e72015;
var statearr_72016_72027 = state_72002;
(statearr_72016_72027[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72002[(4)]))){
var statearr_72017_72028 = state_72002;
(statearr_72017_72028[(1)] = cljs.core.first((state_72002[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72029 = state_72002;
state_72002 = G__72029;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_72002){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_72002);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72018 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72018[(6)] = c__16469__auto__);

return statearr_72018;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(fluree.db.dbfunctions.fns._SLASH_.cljs$lang$applyTo = (function (seq71970){
var G__71971 = cljs.core.first(seq71970);
var seq71970__$1 = cljs.core.next(seq71970);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__71971,seq71970__$1);
}));

/**
 * Quot[ient] of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.quot = (function fluree$db$dbfunctions$fns$quot(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72067){
var state_val_72068 = (state_72067[(1)]);
if((state_val_72068 === (7))){
var state_72067__$1 = state_72067;
var statearr_72069_72093 = state_72067__$1;
(statearr_72069_72093[(2)] = n);

(statearr_72069_72093[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (1))){
var state_72067__$1 = state_72067;
var statearr_72070_72094 = state_72067__$1;
(statearr_72070_72094[(2)] = null);

(statearr_72070_72094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (4))){
var inst_72030 = (state_72067[(2)]);
var state_72067__$1 = state_72067;
var statearr_72071_72095 = state_72067__$1;
(statearr_72071_72095[(2)] = inst_72030);

(statearr_72071_72095[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (13))){
var inst_72047 = (state_72067[(2)]);
var inst_72048 = fluree.db.util.async.throw_err(inst_72047);
var state_72067__$1 = state_72067;
var statearr_72072_72096 = state_72067__$1;
(statearr_72072_72096[(2)] = inst_72048);

(statearr_72072_72096[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (6))){
var state_72067__$1 = state_72067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72067__$1,(9),n);
} else {
if((state_val_72068 === (3))){
var inst_72065 = (state_72067[(2)]);
var state_72067__$1 = state_72067;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72067__$1,inst_72065);
} else {
if((state_val_72068 === (12))){
var inst_72043 = (state_72067[(7)]);
var inst_72051 = (state_72067[(2)]);
var inst_72052 = fluree.db.dbfunctions.internal.quot(inst_72043,inst_72051);
var inst_72053 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72054 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72055 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72056 = [inst_72043,inst_72051];
var inst_72057 = (new cljs.core.PersistentVector(null,2,(5),inst_72055,inst_72056,null));
var inst_72058 = ["quot",inst_72057,inst_72052];
var inst_72059 = cljs.core.PersistentHashMap.fromArrays(inst_72054,inst_72058);
var inst_72060 = [inst_72059,(2)];
var inst_72061 = (new cljs.core.PersistentVector(null,2,(5),inst_72053,inst_72060,null));
var inst_72062 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72061);
var _ = (function (){var statearr_72073 = state_72067;
(statearr_72073[(4)] = cljs.core.rest((state_72067[(4)])));

return statearr_72073;
})();
var state_72067__$1 = (function (){var statearr_72074 = state_72067;
(statearr_72074[(8)] = inst_72062);

return statearr_72074;
})();
var statearr_72075_72097 = state_72067__$1;
(statearr_72075_72097[(2)] = inst_72052);

(statearr_72075_72097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (2))){
var _ = (function (){var statearr_72076 = state_72067;
(statearr_72076[(4)] = cljs.core.cons((5),(state_72067[(4)])));

return statearr_72076;
})();
var inst_72036 = fluree.db.util.async.channel_QMARK_(n);
var state_72067__$1 = state_72067;
if(inst_72036){
var statearr_72077_72098 = state_72067__$1;
(statearr_72077_72098[(1)] = (6));

} else {
var statearr_72078_72099 = state_72067__$1;
(statearr_72078_72099[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (11))){
var state_72067__$1 = state_72067;
var statearr_72080_72100 = state_72067__$1;
(statearr_72080_72100[(2)] = d);

(statearr_72080_72100[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (9))){
var inst_72039 = (state_72067[(2)]);
var inst_72040 = fluree.db.util.async.throw_err(inst_72039);
var state_72067__$1 = state_72067;
var statearr_72081_72101 = state_72067__$1;
(statearr_72081_72101[(2)] = inst_72040);

(statearr_72081_72101[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (5))){
var _ = (function (){var statearr_72082 = state_72067;
(statearr_72082[(4)] = cljs.core.rest((state_72067[(4)])));

return statearr_72082;
})();
var state_72067__$1 = state_72067;
var ex72079 = (state_72067__$1[(2)]);
var statearr_72083_72102 = state_72067__$1;
(statearr_72083_72102[(5)] = ex72079);


if((ex72079 instanceof Error)){
var statearr_72084_72103 = state_72067__$1;
(statearr_72084_72103[(1)] = (4));

(statearr_72084_72103[(5)] = null);

} else {
throw ex72079;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72068 === (10))){
var state_72067__$1 = state_72067;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72067__$1,(13),d);
} else {
if((state_val_72068 === (8))){
var inst_72043 = (state_72067[(2)]);
var inst_72044 = fluree.db.util.async.channel_QMARK_(d);
var state_72067__$1 = (function (){var statearr_72085 = state_72067;
(statearr_72085[(7)] = inst_72043);

return statearr_72085;
})();
if(inst_72044){
var statearr_72086_72104 = state_72067__$1;
(statearr_72086_72104[(1)] = (10));

} else {
var statearr_72087_72105 = state_72067__$1;
(statearr_72087_72105[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0 = (function (){
var statearr_72088 = [null,null,null,null,null,null,null,null,null];
(statearr_72088[(0)] = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__);

(statearr_72088[(1)] = (1));

return statearr_72088;
});
var fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1 = (function (state_72067){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72067);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72089){var ex__16398__auto__ = e72089;
var statearr_72090_72106 = state_72067;
(statearr_72090_72106[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72067[(4)]))){
var statearr_72091_72107 = state_72067;
(statearr_72091_72107[(1)] = cljs.core.first((state_72067[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72108 = state_72067;
state_72067 = G__72108;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__ = function(state_72067){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1.call(this,state_72067);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$quot_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72092 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72092[(6)] = c__16469__auto__);

return statearr_72092;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
fluree.db.dbfunctions.fns.mod = (function fluree$db$dbfunctions$fns$mod(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72146){
var state_val_72147 = (state_72146[(1)]);
if((state_val_72147 === (7))){
var state_72146__$1 = state_72146;
var statearr_72148_72172 = state_72146__$1;
(statearr_72148_72172[(2)] = n);

(statearr_72148_72172[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (1))){
var state_72146__$1 = state_72146;
var statearr_72149_72173 = state_72146__$1;
(statearr_72149_72173[(2)] = null);

(statearr_72149_72173[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (4))){
var inst_72109 = (state_72146[(2)]);
var state_72146__$1 = state_72146;
var statearr_72150_72174 = state_72146__$1;
(statearr_72150_72174[(2)] = inst_72109);

(statearr_72150_72174[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (13))){
var inst_72126 = (state_72146[(2)]);
var inst_72127 = fluree.db.util.async.throw_err(inst_72126);
var state_72146__$1 = state_72146;
var statearr_72151_72175 = state_72146__$1;
(statearr_72151_72175[(2)] = inst_72127);

(statearr_72151_72175[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (6))){
var state_72146__$1 = state_72146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72146__$1,(9),n);
} else {
if((state_val_72147 === (3))){
var inst_72144 = (state_72146[(2)]);
var state_72146__$1 = state_72146;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72146__$1,inst_72144);
} else {
if((state_val_72147 === (12))){
var inst_72122 = (state_72146[(7)]);
var inst_72130 = (state_72146[(2)]);
var inst_72131 = fluree.db.dbfunctions.internal.mod(inst_72122,inst_72130);
var inst_72132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72133 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72135 = [inst_72122,inst_72130];
var inst_72136 = (new cljs.core.PersistentVector(null,2,(5),inst_72134,inst_72135,null));
var inst_72137 = ["mod",inst_72136,inst_72131];
var inst_72138 = cljs.core.PersistentHashMap.fromArrays(inst_72133,inst_72137);
var inst_72139 = [inst_72138,(2)];
var inst_72140 = (new cljs.core.PersistentVector(null,2,(5),inst_72132,inst_72139,null));
var inst_72141 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72140);
var _ = (function (){var statearr_72152 = state_72146;
(statearr_72152[(4)] = cljs.core.rest((state_72146[(4)])));

return statearr_72152;
})();
var state_72146__$1 = (function (){var statearr_72153 = state_72146;
(statearr_72153[(8)] = inst_72141);

return statearr_72153;
})();
var statearr_72154_72176 = state_72146__$1;
(statearr_72154_72176[(2)] = inst_72131);

(statearr_72154_72176[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (2))){
var _ = (function (){var statearr_72155 = state_72146;
(statearr_72155[(4)] = cljs.core.cons((5),(state_72146[(4)])));

return statearr_72155;
})();
var inst_72115 = fluree.db.util.async.channel_QMARK_(n);
var state_72146__$1 = state_72146;
if(inst_72115){
var statearr_72156_72177 = state_72146__$1;
(statearr_72156_72177[(1)] = (6));

} else {
var statearr_72157_72178 = state_72146__$1;
(statearr_72157_72178[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (11))){
var state_72146__$1 = state_72146;
var statearr_72159_72179 = state_72146__$1;
(statearr_72159_72179[(2)] = d);

(statearr_72159_72179[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (9))){
var inst_72118 = (state_72146[(2)]);
var inst_72119 = fluree.db.util.async.throw_err(inst_72118);
var state_72146__$1 = state_72146;
var statearr_72160_72180 = state_72146__$1;
(statearr_72160_72180[(2)] = inst_72119);

(statearr_72160_72180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (5))){
var _ = (function (){var statearr_72161 = state_72146;
(statearr_72161[(4)] = cljs.core.rest((state_72146[(4)])));

return statearr_72161;
})();
var state_72146__$1 = state_72146;
var ex72158 = (state_72146__$1[(2)]);
var statearr_72162_72181 = state_72146__$1;
(statearr_72162_72181[(5)] = ex72158);


if((ex72158 instanceof Error)){
var statearr_72163_72182 = state_72146__$1;
(statearr_72163_72182[(1)] = (4));

(statearr_72163_72182[(5)] = null);

} else {
throw ex72158;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72147 === (10))){
var state_72146__$1 = state_72146;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72146__$1,(13),d);
} else {
if((state_val_72147 === (8))){
var inst_72122 = (state_72146[(2)]);
var inst_72123 = fluree.db.util.async.channel_QMARK_(d);
var state_72146__$1 = (function (){var statearr_72164 = state_72146;
(statearr_72164[(7)] = inst_72122);

return statearr_72164;
})();
if(inst_72123){
var statearr_72165_72183 = state_72146__$1;
(statearr_72165_72183[(1)] = (10));

} else {
var statearr_72166_72184 = state_72146__$1;
(statearr_72166_72184[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0 = (function (){
var statearr_72167 = [null,null,null,null,null,null,null,null,null];
(statearr_72167[(0)] = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__);

(statearr_72167[(1)] = (1));

return statearr_72167;
});
var fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1 = (function (state_72146){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72146);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72168){var ex__16398__auto__ = e72168;
var statearr_72169_72185 = state_72146;
(statearr_72169_72185[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72146[(4)]))){
var statearr_72170_72186 = state_72146;
(statearr_72170_72186[(1)] = cljs.core.first((state_72146[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72187 = state_72146;
state_72146 = G__72187;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__ = function(state_72146){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1.call(this,state_72146);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$mod_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72171 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72171[(6)] = c__16469__auto__);

return statearr_72171;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Remainder of dividing numerator by denominator.
 */
fluree.db.dbfunctions.fns.rem = (function fluree$db$dbfunctions$fns$rem(_QMARK_ctx,n,d){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72225){
var state_val_72226 = (state_72225[(1)]);
if((state_val_72226 === (7))){
var state_72225__$1 = state_72225;
var statearr_72227_72251 = state_72225__$1;
(statearr_72227_72251[(2)] = n);

(statearr_72227_72251[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (1))){
var state_72225__$1 = state_72225;
var statearr_72228_72252 = state_72225__$1;
(statearr_72228_72252[(2)] = null);

(statearr_72228_72252[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (4))){
var inst_72188 = (state_72225[(2)]);
var state_72225__$1 = state_72225;
var statearr_72229_72253 = state_72225__$1;
(statearr_72229_72253[(2)] = inst_72188);

(statearr_72229_72253[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (13))){
var inst_72205 = (state_72225[(2)]);
var inst_72206 = fluree.db.util.async.throw_err(inst_72205);
var state_72225__$1 = state_72225;
var statearr_72230_72254 = state_72225__$1;
(statearr_72230_72254[(2)] = inst_72206);

(statearr_72230_72254[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (6))){
var state_72225__$1 = state_72225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72225__$1,(9),n);
} else {
if((state_val_72226 === (3))){
var inst_72223 = (state_72225[(2)]);
var state_72225__$1 = state_72225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72225__$1,inst_72223);
} else {
if((state_val_72226 === (12))){
var inst_72201 = (state_72225[(7)]);
var inst_72209 = (state_72225[(2)]);
var inst_72210 = fluree.db.dbfunctions.internal.rem(inst_72201,inst_72209);
var inst_72211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72212 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72213 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72214 = [inst_72201,inst_72209];
var inst_72215 = (new cljs.core.PersistentVector(null,2,(5),inst_72213,inst_72214,null));
var inst_72216 = ["rem",inst_72215,inst_72210];
var inst_72217 = cljs.core.PersistentHashMap.fromArrays(inst_72212,inst_72216);
var inst_72218 = [inst_72217,(2)];
var inst_72219 = (new cljs.core.PersistentVector(null,2,(5),inst_72211,inst_72218,null));
var inst_72220 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72219);
var _ = (function (){var statearr_72231 = state_72225;
(statearr_72231[(4)] = cljs.core.rest((state_72225[(4)])));

return statearr_72231;
})();
var state_72225__$1 = (function (){var statearr_72232 = state_72225;
(statearr_72232[(8)] = inst_72220);

return statearr_72232;
})();
var statearr_72233_72255 = state_72225__$1;
(statearr_72233_72255[(2)] = inst_72210);

(statearr_72233_72255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (2))){
var _ = (function (){var statearr_72234 = state_72225;
(statearr_72234[(4)] = cljs.core.cons((5),(state_72225[(4)])));

return statearr_72234;
})();
var inst_72194 = fluree.db.util.async.channel_QMARK_(n);
var state_72225__$1 = state_72225;
if(inst_72194){
var statearr_72235_72256 = state_72225__$1;
(statearr_72235_72256[(1)] = (6));

} else {
var statearr_72236_72257 = state_72225__$1;
(statearr_72236_72257[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (11))){
var state_72225__$1 = state_72225;
var statearr_72238_72258 = state_72225__$1;
(statearr_72238_72258[(2)] = d);

(statearr_72238_72258[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (9))){
var inst_72197 = (state_72225[(2)]);
var inst_72198 = fluree.db.util.async.throw_err(inst_72197);
var state_72225__$1 = state_72225;
var statearr_72239_72259 = state_72225__$1;
(statearr_72239_72259[(2)] = inst_72198);

(statearr_72239_72259[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (5))){
var _ = (function (){var statearr_72240 = state_72225;
(statearr_72240[(4)] = cljs.core.rest((state_72225[(4)])));

return statearr_72240;
})();
var state_72225__$1 = state_72225;
var ex72237 = (state_72225__$1[(2)]);
var statearr_72241_72260 = state_72225__$1;
(statearr_72241_72260[(5)] = ex72237);


if((ex72237 instanceof Error)){
var statearr_72242_72261 = state_72225__$1;
(statearr_72242_72261[(1)] = (4));

(statearr_72242_72261[(5)] = null);

} else {
throw ex72237;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72226 === (10))){
var state_72225__$1 = state_72225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72225__$1,(13),d);
} else {
if((state_val_72226 === (8))){
var inst_72201 = (state_72225[(2)]);
var inst_72202 = fluree.db.util.async.channel_QMARK_(d);
var state_72225__$1 = (function (){var statearr_72243 = state_72225;
(statearr_72243[(7)] = inst_72201);

return statearr_72243;
})();
if(inst_72202){
var statearr_72244_72262 = state_72225__$1;
(statearr_72244_72262[(1)] = (10));

} else {
var statearr_72245_72263 = state_72225__$1;
(statearr_72245_72263[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0 = (function (){
var statearr_72246 = [null,null,null,null,null,null,null,null,null];
(statearr_72246[(0)] = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__);

(statearr_72246[(1)] = (1));

return statearr_72246;
});
var fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1 = (function (state_72225){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72225);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72247){var ex__16398__auto__ = e72247;
var statearr_72248_72264 = state_72225;
(statearr_72248_72264[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72225[(4)]))){
var statearr_72249_72265 = state_72225;
(statearr_72249_72265[(1)] = cljs.core.first((state_72225[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72266 = state_72225;
state_72225 = G__72266;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__ = function(state_72225){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1.call(this,state_72225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$rem_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72250 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72250[(6)] = c__16469__auto__);

return statearr_72250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Coerce to boolean. Everything except false and nil is true.
 */
fluree.db.dbfunctions.fns.boolean$ = (function fluree$db$dbfunctions$fns$boolean(_QMARK_ctx,x){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72293){
var state_val_72294 = (state_72293[(1)]);
if((state_val_72294 === (7))){
var state_72293__$1 = state_72293;
var statearr_72295_72314 = state_72293__$1;
(statearr_72295_72314[(2)] = x);

(statearr_72295_72314[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (1))){
var state_72293__$1 = state_72293;
var statearr_72296_72315 = state_72293__$1;
(statearr_72296_72315[(2)] = null);

(statearr_72296_72315[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (4))){
var inst_72267 = (state_72293[(2)]);
var state_72293__$1 = state_72293;
var statearr_72297_72316 = state_72293__$1;
(statearr_72297_72316[(2)] = inst_72267);

(statearr_72297_72316[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (6))){
var state_72293__$1 = state_72293;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72293__$1,(9),x);
} else {
if((state_val_72294 === (3))){
var inst_72291 = (state_72293[(2)]);
var state_72293__$1 = state_72293;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72293__$1,inst_72291);
} else {
if((state_val_72294 === (2))){
var _ = (function (){var statearr_72299 = state_72293;
(statearr_72299[(4)] = cljs.core.cons((5),(state_72293[(4)])));

return statearr_72299;
})();
var inst_72273 = fluree.db.util.async.channel_QMARK_(x);
var state_72293__$1 = state_72293;
if(inst_72273){
var statearr_72300_72317 = state_72293__$1;
(statearr_72300_72317[(1)] = (6));

} else {
var statearr_72301_72318 = state_72293__$1;
(statearr_72301_72318[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (9))){
var inst_72276 = (state_72293[(2)]);
var inst_72277 = fluree.db.util.async.throw_err(inst_72276);
var state_72293__$1 = state_72293;
var statearr_72302_72319 = state_72293__$1;
(statearr_72302_72319[(2)] = inst_72277);

(statearr_72302_72319[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (5))){
var _ = (function (){var statearr_72303 = state_72293;
(statearr_72303[(4)] = cljs.core.rest((state_72293[(4)])));

return statearr_72303;
})();
var state_72293__$1 = state_72293;
var ex72298 = (state_72293__$1[(2)]);
var statearr_72304_72320 = state_72293__$1;
(statearr_72304_72320[(5)] = ex72298);


if((ex72298 instanceof Error)){
var statearr_72305_72321 = state_72293__$1;
(statearr_72305_72321[(1)] = (4));

(statearr_72305_72321[(5)] = null);

} else {
throw ex72298;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72294 === (8))){
var inst_72280 = (state_72293[(2)]);
var inst_72281 = fluree.db.dbfunctions.internal.boolean$(inst_72280);
var inst_72282 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72283 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72284 = ["boolean",inst_72280,inst_72281];
var inst_72285 = cljs.core.PersistentHashMap.fromArrays(inst_72283,inst_72284);
var inst_72286 = [inst_72285,(10)];
var inst_72287 = (new cljs.core.PersistentVector(null,2,(5),inst_72282,inst_72286,null));
var inst_72288 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72287);
var _ = (function (){var statearr_72306 = state_72293;
(statearr_72306[(4)] = cljs.core.rest((state_72293[(4)])));

return statearr_72306;
})();
var state_72293__$1 = (function (){var statearr_72307 = state_72293;
(statearr_72307[(7)] = inst_72288);

return statearr_72307;
})();
var statearr_72308_72322 = state_72293__$1;
(statearr_72308_72322[(2)] = inst_72281);

(statearr_72308_72322[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0 = (function (){
var statearr_72309 = [null,null,null,null,null,null,null,null];
(statearr_72309[(0)] = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__);

(statearr_72309[(1)] = (1));

return statearr_72309;
});
var fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1 = (function (state_72293){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72293);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72310){var ex__16398__auto__ = e72310;
var statearr_72311_72323 = state_72293;
(statearr_72311_72323[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72293[(4)]))){
var statearr_72312_72324 = state_72293;
(statearr_72312_72324[(1)] = cljs.core.first((state_72293[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72325 = state_72293;
state_72293 = G__72325;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__ = function(state_72293){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1.call(this,state_72293);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$boolean_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72313 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72313[(6)] = c__16469__auto__);

return statearr_72313;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Execute a re-find operation of regex pattern on provided string.
 */
fluree.db.dbfunctions.fns.re_find = (function fluree$db$dbfunctions$fns$re_find(_QMARK_ctx,pattern,string){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72363){
var state_val_72364 = (state_72363[(1)]);
if((state_val_72364 === (7))){
var state_72363__$1 = state_72363;
var statearr_72365_72389 = state_72363__$1;
(statearr_72365_72389[(2)] = pattern);

(statearr_72365_72389[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (1))){
var state_72363__$1 = state_72363;
var statearr_72366_72390 = state_72363__$1;
(statearr_72366_72390[(2)] = null);

(statearr_72366_72390[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (4))){
var inst_72326 = (state_72363[(2)]);
var state_72363__$1 = state_72363;
var statearr_72367_72391 = state_72363__$1;
(statearr_72367_72391[(2)] = inst_72326);

(statearr_72367_72391[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (13))){
var inst_72343 = (state_72363[(2)]);
var inst_72344 = fluree.db.util.async.throw_err(inst_72343);
var state_72363__$1 = state_72363;
var statearr_72368_72392 = state_72363__$1;
(statearr_72368_72392[(2)] = inst_72344);

(statearr_72368_72392[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (6))){
var state_72363__$1 = state_72363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72363__$1,(9),pattern);
} else {
if((state_val_72364 === (3))){
var inst_72361 = (state_72363[(2)]);
var state_72363__$1 = state_72363;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72363__$1,inst_72361);
} else {
if((state_val_72364 === (12))){
var inst_72339 = (state_72363[(7)]);
var inst_72347 = (state_72363[(2)]);
var inst_72348 = fluree.db.dbfunctions.internal.re_find(inst_72339,inst_72347);
var inst_72349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72350 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72351 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72352 = [inst_72339,inst_72347];
var inst_72353 = (new cljs.core.PersistentVector(null,2,(5),inst_72351,inst_72352,null));
var inst_72354 = ["re-find",inst_72353,inst_72348];
var inst_72355 = cljs.core.PersistentHashMap.fromArrays(inst_72350,inst_72354);
var inst_72356 = [inst_72355,(10)];
var inst_72357 = (new cljs.core.PersistentVector(null,2,(5),inst_72349,inst_72356,null));
var inst_72358 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72357);
var _ = (function (){var statearr_72369 = state_72363;
(statearr_72369[(4)] = cljs.core.rest((state_72363[(4)])));

return statearr_72369;
})();
var state_72363__$1 = (function (){var statearr_72370 = state_72363;
(statearr_72370[(8)] = inst_72358);

return statearr_72370;
})();
var statearr_72371_72393 = state_72363__$1;
(statearr_72371_72393[(2)] = inst_72348);

(statearr_72371_72393[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (2))){
var _ = (function (){var statearr_72372 = state_72363;
(statearr_72372[(4)] = cljs.core.cons((5),(state_72363[(4)])));

return statearr_72372;
})();
var inst_72332 = fluree.db.util.async.channel_QMARK_(pattern);
var state_72363__$1 = state_72363;
if(inst_72332){
var statearr_72373_72394 = state_72363__$1;
(statearr_72373_72394[(1)] = (6));

} else {
var statearr_72374_72395 = state_72363__$1;
(statearr_72374_72395[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (11))){
var state_72363__$1 = state_72363;
var statearr_72376_72396 = state_72363__$1;
(statearr_72376_72396[(2)] = string);

(statearr_72376_72396[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (9))){
var inst_72335 = (state_72363[(2)]);
var inst_72336 = fluree.db.util.async.throw_err(inst_72335);
var state_72363__$1 = state_72363;
var statearr_72377_72397 = state_72363__$1;
(statearr_72377_72397[(2)] = inst_72336);

(statearr_72377_72397[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (5))){
var _ = (function (){var statearr_72378 = state_72363;
(statearr_72378[(4)] = cljs.core.rest((state_72363[(4)])));

return statearr_72378;
})();
var state_72363__$1 = state_72363;
var ex72375 = (state_72363__$1[(2)]);
var statearr_72379_72398 = state_72363__$1;
(statearr_72379_72398[(5)] = ex72375);


if((ex72375 instanceof Error)){
var statearr_72380_72399 = state_72363__$1;
(statearr_72380_72399[(1)] = (4));

(statearr_72380_72399[(5)] = null);

} else {
throw ex72375;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72364 === (10))){
var state_72363__$1 = state_72363;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72363__$1,(13),string);
} else {
if((state_val_72364 === (8))){
var inst_72339 = (state_72363[(2)]);
var inst_72340 = fluree.db.util.async.channel_QMARK_(string);
var state_72363__$1 = (function (){var statearr_72381 = state_72363;
(statearr_72381[(7)] = inst_72339);

return statearr_72381;
})();
if(inst_72340){
var statearr_72382_72400 = state_72363__$1;
(statearr_72382_72400[(1)] = (10));

} else {
var statearr_72383_72401 = state_72363__$1;
(statearr_72383_72401[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0 = (function (){
var statearr_72384 = [null,null,null,null,null,null,null,null,null];
(statearr_72384[(0)] = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__);

(statearr_72384[(1)] = (1));

return statearr_72384;
});
var fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1 = (function (state_72363){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72363);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72385){var ex__16398__auto__ = e72385;
var statearr_72386_72402 = state_72363;
(statearr_72386_72402[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72363[(4)]))){
var statearr_72387_72403 = state_72363;
(statearr_72387_72403[(1)] = cljs.core.first((state_72363[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72404 = state_72363;
state_72363 = G__72404;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__ = function(state_72363){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1.call(this,state_72363);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$re_find_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72388 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72388[(6)] = c__16469__auto__);

return statearr_72388;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Determines whether an email is valid, based on its pattern
 */
fluree.db.dbfunctions.fns.valid_email_QMARK_ = (function fluree$db$dbfunctions$fns$valid_email_QMARK_(_QMARK_ctx,email){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72431){
var state_val_72432 = (state_72431[(1)]);
if((state_val_72432 === (7))){
var state_72431__$1 = state_72431;
var statearr_72433_72452 = state_72431__$1;
(statearr_72433_72452[(2)] = email);

(statearr_72433_72452[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (1))){
var state_72431__$1 = state_72431;
var statearr_72434_72453 = state_72431__$1;
(statearr_72434_72453[(2)] = null);

(statearr_72434_72453[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (4))){
var inst_72405 = (state_72431[(2)]);
var state_72431__$1 = state_72431;
var statearr_72435_72454 = state_72431__$1;
(statearr_72435_72454[(2)] = inst_72405);

(statearr_72435_72454[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (6))){
var state_72431__$1 = state_72431;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72431__$1,(9),email);
} else {
if((state_val_72432 === (3))){
var inst_72429 = (state_72431[(2)]);
var state_72431__$1 = state_72431;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72431__$1,inst_72429);
} else {
if((state_val_72432 === (2))){
var _ = (function (){var statearr_72437 = state_72431;
(statearr_72437[(4)] = cljs.core.cons((5),(state_72431[(4)])));

return statearr_72437;
})();
var inst_72411 = fluree.db.util.async.channel_QMARK_(email);
var state_72431__$1 = state_72431;
if(inst_72411){
var statearr_72438_72455 = state_72431__$1;
(statearr_72438_72455[(1)] = (6));

} else {
var statearr_72439_72456 = state_72431__$1;
(statearr_72439_72456[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (9))){
var inst_72414 = (state_72431[(2)]);
var inst_72415 = fluree.db.util.async.throw_err(inst_72414);
var state_72431__$1 = state_72431;
var statearr_72440_72457 = state_72431__$1;
(statearr_72440_72457[(2)] = inst_72415);

(statearr_72440_72457[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (5))){
var _ = (function (){var statearr_72441 = state_72431;
(statearr_72441[(4)] = cljs.core.rest((state_72431[(4)])));

return statearr_72441;
})();
var state_72431__$1 = state_72431;
var ex72436 = (state_72431__$1[(2)]);
var statearr_72442_72458 = state_72431__$1;
(statearr_72442_72458[(5)] = ex72436);


if((ex72436 instanceof Error)){
var statearr_72443_72459 = state_72431__$1;
(statearr_72443_72459[(1)] = (4));

(statearr_72443_72459[(5)] = null);

} else {
throw ex72436;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72432 === (8))){
var inst_72418 = (state_72431[(2)]);
var inst_72419 = fluree.db.dbfunctions.internal.valid_email_QMARK_(inst_72418);
var inst_72420 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72421 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72422 = ["re-find",inst_72418,inst_72419];
var inst_72423 = cljs.core.PersistentHashMap.fromArrays(inst_72421,inst_72422);
var inst_72424 = [inst_72423,(10)];
var inst_72425 = (new cljs.core.PersistentVector(null,2,(5),inst_72420,inst_72424,null));
var inst_72426 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72425);
var _ = (function (){var statearr_72444 = state_72431;
(statearr_72444[(4)] = cljs.core.rest((state_72431[(4)])));

return statearr_72444;
})();
var state_72431__$1 = (function (){var statearr_72445 = state_72431;
(statearr_72445[(7)] = inst_72426);

return statearr_72445;
})();
var statearr_72446_72460 = state_72431__$1;
(statearr_72446_72460[(2)] = inst_72419);

(statearr_72446_72460[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0 = (function (){
var statearr_72447 = [null,null,null,null,null,null,null,null];
(statearr_72447[(0)] = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__);

(statearr_72447[(1)] = (1));

return statearr_72447;
});
var fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1 = (function (state_72431){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72431);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72448){var ex__16398__auto__ = e72448;
var statearr_72449_72461 = state_72431;
(statearr_72449_72461[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72431[(4)]))){
var statearr_72450_72462 = state_72431;
(statearr_72450_72462[(1)] = cljs.core.first((state_72431[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72463 = state_72431;
state_72431 = G__72463;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__ = function(state_72431){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1.call(this,state_72431);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$valid_email_QMARK__$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72451 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72451[(6)] = c__16469__auto__);

return statearr_72451;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current user _id.
 */
fluree.db.dbfunctions.fns._QMARK_user_id = (function fluree$db$dbfunctions$fns$_QMARK_user_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72510){
var state_val_72511 = (state_72510[(1)]);
if((state_val_72511 === (7))){
var inst_72480 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72510__$1 = state_72510;
if(cljs.core.truth_(inst_72480)){
var statearr_72512_72539 = state_72510__$1;
(statearr_72512_72539[(1)] = (9));

} else {
var statearr_72513_72540 = state_72510__$1;
(statearr_72513_72540[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (1))){
var state_72510__$1 = state_72510;
var statearr_72514_72541 = state_72510__$1;
(statearr_72514_72541[(2)] = null);

(statearr_72514_72541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (4))){
var inst_72464 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
var statearr_72515_72542 = state_72510__$1;
(statearr_72515_72542[(2)] = inst_72464);

(statearr_72515_72542[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (15))){
var inst_72491 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
var statearr_72516_72543 = state_72510__$1;
(statearr_72516_72543[(2)] = inst_72491);

(statearr_72516_72543[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (13))){
var inst_72488 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?user_id from this function interface");
var state_72510__$1 = state_72510;
var statearr_72517_72544 = state_72510__$1;
(statearr_72517_72544[(2)] = inst_72488);

(statearr_72517_72544[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (6))){
var inst_72475 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72476 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var inst_72477 = [inst_72476,(0)];
var inst_72478 = (new cljs.core.PersistentVector(null,2,(5),inst_72475,inst_72477,null));
var state_72510__$1 = state_72510;
var statearr_72518_72545 = state_72510__$1;
(statearr_72518_72545[(2)] = inst_72478);

(statearr_72518_72545[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (3))){
var inst_72508 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72510__$1,inst_72508);
} else {
if((state_val_72511 === (12))){
var inst_72484 = (state_72510[(2)]);
var inst_72485 = fluree.db.util.async.throw_err(inst_72484);
var state_72510__$1 = state_72510;
var statearr_72519_72546 = state_72510__$1;
(statearr_72519_72546[(2)] = inst_72485);

(statearr_72519_72546[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (2))){
var _ = (function (){var statearr_72520 = state_72510;
(statearr_72520[(4)] = cljs.core.cons((5),(state_72510[(4)])));

return statearr_72520;
})();
var inst_72473 = cljs.core.cst$kw$user_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72510__$1 = state_72510;
if(cljs.core.truth_(inst_72473)){
var statearr_72521_72547 = state_72510__$1;
(statearr_72521_72547[(1)] = (6));

} else {
var statearr_72522_72548 = state_72510__$1;
(statearr_72522_72548[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (11))){
var inst_72493 = (state_72510[(2)]);
var state_72510__$1 = state_72510;
var statearr_72524_72549 = state_72510__$1;
(statearr_72524_72549[(2)] = inst_72493);

(statearr_72524_72549[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (9))){
var inst_72482 = fluree.db.dbfunctions.internal._QMARK_user_id_from_auth(_QMARK_ctx);
var state_72510__$1 = state_72510;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72510__$1,(12),inst_72482);
} else {
if((state_val_72511 === (5))){
var _ = (function (){var statearr_72525 = state_72510;
(statearr_72525[(4)] = cljs.core.rest((state_72510[(4)])));

return statearr_72525;
})();
var state_72510__$1 = state_72510;
var ex72523 = (state_72510__$1[(2)]);
var statearr_72526_72550 = state_72510__$1;
(statearr_72526_72550[(5)] = ex72523);


if((ex72523 instanceof Error)){
var statearr_72527_72551 = state_72510__$1;
(statearr_72527_72551[(1)] = (4));

(statearr_72527_72551[(5)] = null);

} else {
throw ex72523;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (14))){
var state_72510__$1 = state_72510;
var statearr_72528_72552 = state_72510__$1;
(statearr_72528_72552[(2)] = null);

(statearr_72528_72552[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (10))){
var state_72510__$1 = state_72510;
var statearr_72529_72553 = state_72510__$1;
(statearr_72529_72553[(1)] = (13));



return cljs.core.cst$kw$recur;
} else {
if((state_val_72511 === (8))){
var inst_72495 = (state_72510[(2)]);
var inst_72496 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72495,(0),null);
var inst_72497 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_72495,(1),null);
var inst_72498 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72499 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72500 = ["?user_id","?ctx",inst_72496];
var inst_72501 = cljs.core.PersistentHashMap.fromArrays(inst_72499,inst_72500);
var inst_72502 = ((10) + inst_72497);
var inst_72503 = [inst_72501,inst_72502];
var inst_72504 = (new cljs.core.PersistentVector(null,2,(5),inst_72498,inst_72503,null));
var inst_72505 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72504);
var _ = (function (){var statearr_72531 = state_72510;
(statearr_72531[(4)] = cljs.core.rest((state_72510[(4)])));

return statearr_72531;
})();
var state_72510__$1 = (function (){var statearr_72532 = state_72510;
(statearr_72532[(7)] = inst_72505);

return statearr_72532;
})();
var statearr_72533_72554 = state_72510__$1;
(statearr_72533_72554[(2)] = inst_72496);

(statearr_72533_72554[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0 = (function (){
var statearr_72534 = [null,null,null,null,null,null,null,null];
(statearr_72534[(0)] = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__);

(statearr_72534[(1)] = (1));

return statearr_72534;
});
var fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1 = (function (state_72510){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72510);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72535){var ex__16398__auto__ = e72535;
var statearr_72536_72555 = state_72510;
(statearr_72536_72555[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72510[(4)]))){
var statearr_72537_72556 = state_72510;
(statearr_72537_72556[(1)] = cljs.core.first((state_72510[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72557 = state_72510;
state_72510 = G__72557;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__ = function(state_72510){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1.call(this,state_72510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_user_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72538 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72538[(6)] = c__16469__auto__);

return statearr_72538;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets current auth _id.
 */
fluree.db.dbfunctions.fns._QMARK_auth_id = (function fluree$db$dbfunctions$fns$_QMARK_auth_id(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72585){
var state_val_72586 = (state_72585[(1)]);
if((state_val_72586 === (7))){
var inst_72578 = fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access ?auth_id from this function interface");
var state_72585__$1 = state_72585;
var statearr_72587_72606 = state_72585__$1;
(statearr_72587_72606[(2)] = inst_72578);

(statearr_72587_72606[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (1))){
var state_72585__$1 = state_72585;
var statearr_72588_72607 = state_72585__$1;
(statearr_72588_72607[(2)] = null);

(statearr_72588_72607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (4))){
var inst_72558 = (state_72585[(2)]);
var state_72585__$1 = state_72585;
var statearr_72589_72608 = state_72585__$1;
(statearr_72589_72608[(2)] = inst_72558);

(statearr_72589_72608[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (6))){
var inst_72566 = fluree.db.dbfunctions.internal._QMARK_auth_id(_QMARK_ctx);
var state_72585__$1 = state_72585;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72585__$1,(9),inst_72566);
} else {
if((state_val_72586 === (3))){
var inst_72583 = (state_72585[(2)]);
var state_72585__$1 = state_72585;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72585__$1,inst_72583);
} else {
if((state_val_72586 === (2))){
var _ = (function (){var statearr_72591 = state_72585;
(statearr_72591[(4)] = cljs.core.cons((5),(state_72585[(4)])));

return statearr_72591;
})();
var inst_72564 = cljs.core.cst$kw$auth_id.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var state_72585__$1 = state_72585;
if(cljs.core.truth_(inst_72564)){
var statearr_72592_72609 = state_72585__$1;
(statearr_72592_72609[(1)] = (6));

} else {
var statearr_72593_72610 = state_72585__$1;
(statearr_72593_72610[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (9))){
var inst_72568 = (state_72585[(2)]);
var inst_72569 = fluree.db.util.async.throw_err(inst_72568);
var inst_72570 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72571 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72572 = ["?auth_id","?ctx",inst_72569];
var inst_72573 = cljs.core.PersistentHashMap.fromArrays(inst_72571,inst_72572);
var inst_72574 = [inst_72573,(10)];
var inst_72575 = (new cljs.core.PersistentVector(null,2,(5),inst_72570,inst_72574,null));
var inst_72576 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72575);
var state_72585__$1 = (function (){var statearr_72594 = state_72585;
(statearr_72594[(7)] = inst_72576);

return statearr_72594;
})();
var statearr_72595_72611 = state_72585__$1;
(statearr_72595_72611[(2)] = inst_72569);

(statearr_72595_72611[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (5))){
var _ = (function (){var statearr_72596 = state_72585;
(statearr_72596[(4)] = cljs.core.rest((state_72585[(4)])));

return statearr_72596;
})();
var state_72585__$1 = state_72585;
var ex72590 = (state_72585__$1[(2)]);
var statearr_72597_72612 = state_72585__$1;
(statearr_72597_72612[(5)] = ex72590);


if((ex72590 instanceof Error)){
var statearr_72598_72613 = state_72585__$1;
(statearr_72598_72613[(1)] = (4));

(statearr_72598_72613[(5)] = null);

} else {
throw ex72590;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72586 === (8))){
var inst_72580 = (state_72585[(2)]);
var _ = (function (){var statearr_72599 = state_72585;
(statearr_72599[(4)] = cljs.core.rest((state_72585[(4)])));

return statearr_72599;
})();
var state_72585__$1 = state_72585;
var statearr_72600_72614 = state_72585__$1;
(statearr_72600_72614[(2)] = inst_72580);

(statearr_72600_72614[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0 = (function (){
var statearr_72601 = [null,null,null,null,null,null,null,null];
(statearr_72601[(0)] = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__);

(statearr_72601[(1)] = (1));

return statearr_72601;
});
var fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1 = (function (state_72585){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72585);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72602){var ex__16398__auto__ = e72602;
var statearr_72603_72615 = state_72585;
(statearr_72603_72615[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72585[(4)]))){
var statearr_72604_72616 = state_72585;
(statearr_72604_72616[(1)] = cljs.core.first((state_72585[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72617 = state_72585;
state_72585 = G__72617;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__ = function(state_72585){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1.call(this,state_72585);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$_QMARK_auth_id_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72605 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72605[(6)] = c__16469__auto__);

return statearr_72605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Gets the summed object of all true flakes
 */
fluree.db.dbfunctions.fns.objT = (function fluree$db$dbfunctions$fns$objT(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objT(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objT",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objT function from this function interface");
}
});
/**
 * Gets the summed object of all false flakes
 */
fluree.db.dbfunctions.fns.objF = (function fluree$db$dbfunctions$fns$objF(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = fluree.db.dbfunctions.internal.objF(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"objF",cljs.core.cst$kw$arguments,cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx),cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes, or use objF function from this function interface");
}
});
/**
 * Gets the flakes from the current subject.
 */
fluree.db.dbfunctions.fns.flakes = (function fluree$db$dbfunctions$fns$flakes(_QMARK_ctx){
if(cljs.core.truth_(cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx))){
var res = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx);
var entry = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$function,"flakes",cljs.core.cst$kw$arguments,"?ctx",cljs.core.cst$kw$result,res], null),(10)], null);
fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,entry);

return res;
} else {
return fluree.db.dbfunctions.fns.raise(_QMARK_ctx,"Cannot access flakes from this function interface");
}
});
/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.rand = (function fluree$db$dbfunctions$fns$rand(var_args){
var G__72619 = arguments.length;
switch (G__72619) {
case 2:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$2 = (function (_QMARK_ctx,max){
return fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3(_QMARK_ctx,max,cljs.core.cst$kw$instant.cljs$core$IFn$_invoke$arity$1(_QMARK_ctx));
}));

(fluree.db.dbfunctions.fns.rand.cljs$core$IFn$_invoke$arity$3 = (function (_QMARK_ctx,max,seed){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72661){
var state_val_72662 = (state_72661[(1)]);
if((state_val_72662 === (7))){
var state_72661__$1 = state_72661;
var statearr_72663_72693 = state_72661__$1;
(statearr_72663_72693[(2)] = seed);

(statearr_72663_72693[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (1))){
var state_72661__$1 = state_72661;
var statearr_72664_72694 = state_72661__$1;
(statearr_72664_72694[(2)] = null);

(statearr_72664_72694[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (4))){
var inst_72620 = (state_72661[(2)]);
var state_72661__$1 = state_72661;
var statearr_72665_72695 = state_72661__$1;
(statearr_72665_72695[(2)] = inst_72620);

(statearr_72665_72695[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (15))){
var state_72661__$1 = state_72661;
var statearr_72666_72696 = state_72661__$1;
(statearr_72666_72696[(2)] = (10));

(statearr_72666_72696[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (13))){
var inst_72637 = (state_72661[(2)]);
var inst_72638 = fluree.db.util.async.throw_err(inst_72637);
var state_72661__$1 = state_72661;
var statearr_72667_72697 = state_72661__$1;
(statearr_72667_72697[(2)] = inst_72638);

(statearr_72667_72697[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (6))){
var state_72661__$1 = state_72661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72661__$1,(9),seed);
} else {
if((state_val_72662 === (3))){
var inst_72659 = (state_72661[(2)]);
var state_72661__$1 = state_72661;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72661__$1,inst_72659);
} else {
if((state_val_72662 === (12))){
var inst_72641 = (state_72661[(7)]);
var inst_72641__$1 = (state_72661[(2)]);
var state_72661__$1 = (function (){var statearr_72668 = state_72661;
(statearr_72668[(7)] = inst_72641__$1);

return statearr_72668;
})();
if(cljs.core.truth_(inst_72641__$1)){
var statearr_72669_72698 = state_72661__$1;
(statearr_72669_72698[(1)] = (14));

} else {
var statearr_72670_72699 = state_72661__$1;
(statearr_72670_72699[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (2))){
var _ = (function (){var statearr_72671 = state_72661;
(statearr_72671[(4)] = cljs.core.cons((5),(state_72661[(4)])));

return statearr_72671;
})();
var inst_72626 = fluree.db.util.async.channel_QMARK_(seed);
var state_72661__$1 = state_72661;
if(inst_72626){
var statearr_72672_72700 = state_72661__$1;
(statearr_72672_72700[(1)] = (6));

} else {
var statearr_72673_72701 = state_72661__$1;
(statearr_72673_72701[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (11))){
var state_72661__$1 = state_72661;
var statearr_72675_72702 = state_72661__$1;
(statearr_72675_72702[(2)] = max);

(statearr_72675_72702[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (9))){
var inst_72629 = (state_72661[(2)]);
var inst_72630 = fluree.db.util.async.throw_err(inst_72629);
var state_72661__$1 = state_72661;
var statearr_72676_72703 = state_72661__$1;
(statearr_72676_72703[(2)] = inst_72630);

(statearr_72676_72703[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (5))){
var _ = (function (){var statearr_72677 = state_72661;
(statearr_72677[(4)] = cljs.core.rest((state_72661[(4)])));

return statearr_72677;
})();
var state_72661__$1 = state_72661;
var ex72674 = (state_72661__$1[(2)]);
var statearr_72678_72704 = state_72661__$1;
(statearr_72678_72704[(5)] = ex72674);


if((ex72674 instanceof Error)){
var statearr_72679_72705 = state_72661__$1;
(statearr_72679_72705[(1)] = (4));

(statearr_72679_72705[(5)] = null);

} else {
throw ex72674;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (14))){
var inst_72641 = (state_72661[(7)]);
var state_72661__$1 = state_72661;
var statearr_72680_72706 = state_72661__$1;
(statearr_72680_72706[(2)] = inst_72641);

(statearr_72680_72706[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (16))){
var inst_72633 = (state_72661[(8)]);
var inst_72645 = (state_72661[(2)]);
var inst_72646 = fluree.db.dbfunctions.internal.rand(inst_72633,inst_72645);
var inst_72647 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72648 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72649 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72650 = [max,seed];
var inst_72651 = (new cljs.core.PersistentVector(null,2,(5),inst_72649,inst_72650,null));
var inst_72652 = ["rand",inst_72651,inst_72646];
var inst_72653 = cljs.core.PersistentHashMap.fromArrays(inst_72648,inst_72652);
var inst_72654 = [inst_72653,(10)];
var inst_72655 = (new cljs.core.PersistentVector(null,2,(5),inst_72647,inst_72654,null));
var inst_72656 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72655);
var _ = (function (){var statearr_72681 = state_72661;
(statearr_72681[(4)] = cljs.core.rest((state_72661[(4)])));

return statearr_72681;
})();
var state_72661__$1 = (function (){var statearr_72682 = state_72661;
(statearr_72682[(9)] = inst_72656);

return statearr_72682;
})();
var statearr_72683_72707 = state_72661__$1;
(statearr_72683_72707[(2)] = inst_72646);

(statearr_72683_72707[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72662 === (10))){
var state_72661__$1 = state_72661;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72661__$1,(13),max);
} else {
if((state_val_72662 === (8))){
var inst_72633 = (state_72661[(2)]);
var inst_72634 = fluree.db.util.async.channel_QMARK_(max);
var state_72661__$1 = (function (){var statearr_72684 = state_72661;
(statearr_72684[(8)] = inst_72633);

return statearr_72684;
})();
if(inst_72634){
var statearr_72685_72708 = state_72661__$1;
(statearr_72685_72708[(1)] = (10));

} else {
var statearr_72686_72709 = state_72661__$1;
(statearr_72686_72709[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$state_machine__16395__auto____0 = (function (){
var statearr_72687 = [null,null,null,null,null,null,null,null,null,null];
(statearr_72687[(0)] = fluree$db$dbfunctions$fns$state_machine__16395__auto__);

(statearr_72687[(1)] = (1));

return statearr_72687;
});
var fluree$db$dbfunctions$fns$state_machine__16395__auto____1 = (function (state_72661){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72661);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72688){var ex__16398__auto__ = e72688;
var statearr_72689_72710 = state_72661;
(statearr_72689_72710[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72661[(4)]))){
var statearr_72690_72711 = state_72661;
(statearr_72690_72711[(1)] = cljs.core.first((state_72661[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72712 = state_72661;
state_72661 = G__72712;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$state_machine__16395__auto__ = function(state_72661){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$state_machine__16395__auto____1.call(this,state_72661);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72691 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72691[(6)] = c__16469__auto__);

return statearr_72691;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.dbfunctions.fns.rand.cljs$lang$maxFixedArity = 3);

/**
 * Returns a random number, seed is either provided or a we use the txn instant
 */
fluree.db.dbfunctions.fns.uuid = (function fluree$db$dbfunctions$fns$uuid(_QMARK_ctx){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72733){
var state_val_72734 = (state_72733[(1)]);
if((state_val_72734 === (1))){
var state_72733__$1 = state_72733;
var statearr_72735_72750 = state_72733__$1;
(statearr_72735_72750[(2)] = null);

(statearr_72735_72750[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (2))){
var _ = (function (){var statearr_72736 = state_72733;
(statearr_72736[(4)] = cljs.core.cons((5),(state_72733[(4)])));

return statearr_72736;
})();
var inst_72719 = fluree.db.util.core.random_uuid();
var inst_72720 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_72719);
var inst_72721 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72722 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72723 = cljs.core.PersistentVector.EMPTY;
var inst_72724 = ["uuid",inst_72723,inst_72720];
var inst_72725 = cljs.core.PersistentHashMap.fromArrays(inst_72722,inst_72724);
var inst_72726 = [inst_72725,(10)];
var inst_72727 = (new cljs.core.PersistentVector(null,2,(5),inst_72721,inst_72726,null));
var inst_72728 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72727);
var ___$1 = (function (){var statearr_72737 = state_72733;
(statearr_72737[(4)] = cljs.core.rest((state_72733[(4)])));

return statearr_72737;
})();
var state_72733__$1 = (function (){var statearr_72738 = state_72733;
(statearr_72738[(7)] = inst_72728);

return statearr_72738;
})();
var statearr_72739_72751 = state_72733__$1;
(statearr_72739_72751[(2)] = inst_72720);

(statearr_72739_72751[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (3))){
var inst_72731 = (state_72733[(2)]);
var state_72733__$1 = state_72733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72733__$1,inst_72731);
} else {
if((state_val_72734 === (4))){
var inst_72713 = (state_72733[(2)]);
var state_72733__$1 = state_72733;
var statearr_72741_72752 = state_72733__$1;
(statearr_72741_72752[(2)] = inst_72713);

(statearr_72741_72752[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72734 === (5))){
var _ = (function (){var statearr_72742 = state_72733;
(statearr_72742[(4)] = cljs.core.rest((state_72733[(4)])));

return statearr_72742;
})();
var state_72733__$1 = state_72733;
var ex72740 = (state_72733__$1[(2)]);
var statearr_72743_72753 = state_72733__$1;
(statearr_72743_72753[(5)] = ex72740);


if((ex72740 instanceof Error)){
var statearr_72744_72754 = state_72733__$1;
(statearr_72744_72754[(1)] = (4));

(statearr_72744_72754[(5)] = null);

} else {
throw ex72740;

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0 = (function (){
var statearr_72745 = [null,null,null,null,null,null,null,null];
(statearr_72745[(0)] = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__);

(statearr_72745[(1)] = (1));

return statearr_72745;
});
var fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1 = (function (state_72733){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72733);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72746){var ex__16398__auto__ = e72746;
var statearr_72747_72755 = state_72733;
(statearr_72747_72755[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72733[(4)]))){
var statearr_72748_72756 = state_72733;
(statearr_72748_72756[(1)] = cljs.core.first((state_72733[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72757 = state_72733;
state_72733 = G__72757;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__ = function(state_72733){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1.call(this,state_72733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$uuid_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72749 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72749[(6)] = c__16469__auto__);

return statearr_72749;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes the ceiling of a number
 */
fluree.db.dbfunctions.fns.ceil = (function fluree$db$dbfunctions$fns$ceil(_QMARK_ctx,num){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72787){
var state_val_72788 = (state_72787[(1)]);
if((state_val_72788 === (7))){
var state_72787__$1 = state_72787;
var statearr_72789_72808 = state_72787__$1;
(statearr_72789_72808[(2)] = num);

(statearr_72789_72808[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (1))){
var state_72787__$1 = state_72787;
var statearr_72790_72809 = state_72787__$1;
(statearr_72790_72809[(2)] = null);

(statearr_72790_72809[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (4))){
var inst_72758 = (state_72787[(2)]);
var state_72787__$1 = state_72787;
var statearr_72791_72810 = state_72787__$1;
(statearr_72791_72810[(2)] = inst_72758);

(statearr_72791_72810[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (6))){
var state_72787__$1 = state_72787;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72787__$1,(9),num);
} else {
if((state_val_72788 === (3))){
var inst_72785 = (state_72787[(2)]);
var state_72787__$1 = state_72787;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72787__$1,inst_72785);
} else {
if((state_val_72788 === (2))){
var _ = (function (){var statearr_72793 = state_72787;
(statearr_72793[(4)] = cljs.core.cons((5),(state_72787[(4)])));

return statearr_72793;
})();
var inst_72764 = fluree.db.util.async.channel_QMARK_(num);
var state_72787__$1 = state_72787;
if(inst_72764){
var statearr_72794_72811 = state_72787__$1;
(statearr_72794_72811[(1)] = (6));

} else {
var statearr_72795_72812 = state_72787__$1;
(statearr_72795_72812[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (9))){
var inst_72767 = (state_72787[(2)]);
var inst_72768 = fluree.db.util.async.throw_err(inst_72767);
var state_72787__$1 = state_72787;
var statearr_72796_72813 = state_72787__$1;
(statearr_72796_72813[(2)] = inst_72768);

(statearr_72796_72813[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (5))){
var _ = (function (){var statearr_72797 = state_72787;
(statearr_72797[(4)] = cljs.core.rest((state_72787[(4)])));

return statearr_72797;
})();
var state_72787__$1 = state_72787;
var ex72792 = (state_72787__$1[(2)]);
var statearr_72798_72814 = state_72787__$1;
(statearr_72798_72814[(5)] = ex72792);


if((ex72792 instanceof Error)){
var statearr_72799_72815 = state_72787__$1;
(statearr_72799_72815[(1)] = (4));

(statearr_72799_72815[(5)] = null);

} else {
throw ex72792;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72788 === (8))){
var inst_72771 = (state_72787[(2)]);
var inst_72772 = fluree.db.dbfunctions.internal.ceil(inst_72771);
var inst_72773 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72774 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72775 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72776 = [fluree.db.dbfunctions.fns.ceil];
var inst_72777 = (new cljs.core.PersistentVector(null,1,(5),inst_72775,inst_72776,null));
var inst_72778 = ["",inst_72777,inst_72772];
var inst_72779 = cljs.core.PersistentHashMap.fromArrays(inst_72774,inst_72778);
var inst_72780 = [inst_72779,(10)];
var inst_72781 = (new cljs.core.PersistentVector(null,2,(5),inst_72773,inst_72780,null));
var inst_72782 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72781);
var _ = (function (){var statearr_72800 = state_72787;
(statearr_72800[(4)] = cljs.core.rest((state_72787[(4)])));

return statearr_72800;
})();
var state_72787__$1 = (function (){var statearr_72801 = state_72787;
(statearr_72801[(7)] = inst_72782);

return statearr_72801;
})();
var statearr_72802_72816 = state_72787__$1;
(statearr_72802_72816[(2)] = inst_72772);

(statearr_72802_72816[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0 = (function (){
var statearr_72803 = [null,null,null,null,null,null,null,null];
(statearr_72803[(0)] = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__);

(statearr_72803[(1)] = (1));

return statearr_72803;
});
var fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1 = (function (state_72787){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72787);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72804){var ex__16398__auto__ = e72804;
var statearr_72805_72817 = state_72787;
(statearr_72805_72817[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72787[(4)]))){
var statearr_72806_72818 = state_72787;
(statearr_72806_72818[(1)] = cljs.core.first((state_72787[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72819 = state_72787;
state_72787 = G__72819;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__ = function(state_72787){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1.call(this,state_72787);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$ceil_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72807 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72807[(6)] = c__16469__auto__);

return statearr_72807;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes the floor of a number
 */
fluree.db.dbfunctions.fns.floor = (function fluree$db$dbfunctions$fns$floor(_QMARK_ctx,num){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72849){
var state_val_72850 = (state_72849[(1)]);
if((state_val_72850 === (7))){
var state_72849__$1 = state_72849;
var statearr_72851_72870 = state_72849__$1;
(statearr_72851_72870[(2)] = num);

(statearr_72851_72870[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (1))){
var state_72849__$1 = state_72849;
var statearr_72852_72871 = state_72849__$1;
(statearr_72852_72871[(2)] = null);

(statearr_72852_72871[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (4))){
var inst_72820 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
var statearr_72853_72872 = state_72849__$1;
(statearr_72853_72872[(2)] = inst_72820);

(statearr_72853_72872[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (6))){
var state_72849__$1 = state_72849;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72849__$1,(9),num);
} else {
if((state_val_72850 === (3))){
var inst_72847 = (state_72849[(2)]);
var state_72849__$1 = state_72849;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72849__$1,inst_72847);
} else {
if((state_val_72850 === (2))){
var _ = (function (){var statearr_72855 = state_72849;
(statearr_72855[(4)] = cljs.core.cons((5),(state_72849[(4)])));

return statearr_72855;
})();
var inst_72826 = fluree.db.util.async.channel_QMARK_(num);
var state_72849__$1 = state_72849;
if(inst_72826){
var statearr_72856_72873 = state_72849__$1;
(statearr_72856_72873[(1)] = (6));

} else {
var statearr_72857_72874 = state_72849__$1;
(statearr_72857_72874[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (9))){
var inst_72829 = (state_72849[(2)]);
var inst_72830 = fluree.db.util.async.throw_err(inst_72829);
var state_72849__$1 = state_72849;
var statearr_72858_72875 = state_72849__$1;
(statearr_72858_72875[(2)] = inst_72830);

(statearr_72858_72875[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (5))){
var _ = (function (){var statearr_72859 = state_72849;
(statearr_72859[(4)] = cljs.core.rest((state_72849[(4)])));

return statearr_72859;
})();
var state_72849__$1 = state_72849;
var ex72854 = (state_72849__$1[(2)]);
var statearr_72860_72876 = state_72849__$1;
(statearr_72860_72876[(5)] = ex72854);


if((ex72854 instanceof Error)){
var statearr_72861_72877 = state_72849__$1;
(statearr_72861_72877[(1)] = (4));

(statearr_72861_72877[(5)] = null);

} else {
throw ex72854;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72850 === (8))){
var inst_72833 = (state_72849[(2)]);
var inst_72834 = fluree.db.dbfunctions.internal.floor(inst_72833);
var inst_72835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72836 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72837 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72838 = [fluree.db.dbfunctions.fns.floor];
var inst_72839 = (new cljs.core.PersistentVector(null,1,(5),inst_72837,inst_72838,null));
var inst_72840 = ["",inst_72839,inst_72834];
var inst_72841 = cljs.core.PersistentHashMap.fromArrays(inst_72836,inst_72840);
var inst_72842 = [inst_72841,(10)];
var inst_72843 = (new cljs.core.PersistentVector(null,2,(5),inst_72835,inst_72842,null));
var inst_72844 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72843);
var _ = (function (){var statearr_72862 = state_72849;
(statearr_72862[(4)] = cljs.core.rest((state_72849[(4)])));

return statearr_72862;
})();
var state_72849__$1 = (function (){var statearr_72863 = state_72849;
(statearr_72863[(7)] = inst_72844);

return statearr_72863;
})();
var statearr_72864_72878 = state_72849__$1;
(statearr_72864_72878[(2)] = inst_72834);

(statearr_72864_72878[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0 = (function (){
var statearr_72865 = [null,null,null,null,null,null,null,null];
(statearr_72865[(0)] = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__);

(statearr_72865[(1)] = (1));

return statearr_72865;
});
var fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1 = (function (state_72849){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72849);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72866){var ex__16398__auto__ = e72866;
var statearr_72867_72879 = state_72849;
(statearr_72867_72879[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72849[(4)]))){
var statearr_72868_72880 = state_72849;
(statearr_72868_72880[(1)] = cljs.core.first((state_72849[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72881 = state_72849;
state_72849 = G__72881;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__ = function(state_72849){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1.call(this,state_72849);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$floor_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72869 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72869[(6)] = c__16469__auto__);

return statearr_72869;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Does a compare and set/swap operation as a transaction function.
 */
fluree.db.dbfunctions.fns.cas = (function fluree$db$dbfunctions$fns$cas(_QMARK_ctx,compare_val,new_val){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_72906){
var state_val_72907 = (state_72906[(1)]);
if((state_val_72907 === (1))){
var state_72906__$1 = state_72906;
var statearr_72908_72923 = state_72906__$1;
(statearr_72908_72923[(2)] = null);

(statearr_72908_72923[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72907 === (2))){
var _ = (function (){var statearr_72909 = state_72906;
(statearr_72909[(4)] = cljs.core.cons((5),(state_72906[(4)])));

return statearr_72909;
})();
var inst_72888 = fluree.db.dbfunctions.internal.cas(_QMARK_ctx,compare_val,new_val);
var state_72906__$1 = state_72906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_72906__$1,(6),inst_72888);
} else {
if((state_val_72907 === (3))){
var inst_72904 = (state_72906[(2)]);
var state_72906__$1 = state_72906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_72906__$1,inst_72904);
} else {
if((state_val_72907 === (4))){
var inst_72882 = (state_72906[(2)]);
var state_72906__$1 = state_72906;
var statearr_72911_72924 = state_72906__$1;
(statearr_72911_72924[(2)] = inst_72882);

(statearr_72911_72924[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_72907 === (5))){
var _ = (function (){var statearr_72912 = state_72906;
(statearr_72912[(4)] = cljs.core.rest((state_72906[(4)])));

return statearr_72912;
})();
var state_72906__$1 = state_72906;
var ex72910 = (state_72906__$1[(2)]);
var statearr_72913_72925 = state_72906__$1;
(statearr_72913_72925[(5)] = ex72910);


if((ex72910 instanceof Error)){
var statearr_72914_72926 = state_72906__$1;
(statearr_72914_72926[(1)] = (4));

(statearr_72914_72926[(5)] = null);

} else {
throw ex72910;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_72907 === (6))){
var inst_72890 = (state_72906[(2)]);
var inst_72891 = fluree.db.util.async.throw_err(inst_72890);
var inst_72892 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72893 = [cljs.core.cst$kw$function,cljs.core.cst$kw$arguments,cljs.core.cst$kw$result];
var inst_72894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_72895 = [compare_val,new_val];
var inst_72896 = (new cljs.core.PersistentVector(null,2,(5),inst_72894,inst_72895,null));
var inst_72897 = ["",inst_72896,inst_72891];
var inst_72898 = cljs.core.PersistentHashMap.fromArrays(inst_72893,inst_72897);
var inst_72899 = [inst_72898,(10)];
var inst_72900 = (new cljs.core.PersistentVector(null,2,(5),inst_72892,inst_72899,null));
var inst_72901 = fluree.db.dbfunctions.fns.add_stack(_QMARK_ctx,inst_72900);
var _ = (function (){var statearr_72915 = state_72906;
(statearr_72915[(4)] = cljs.core.rest((state_72906[(4)])));

return statearr_72915;
})();
var state_72906__$1 = (function (){var statearr_72916 = state_72906;
(statearr_72916[(7)] = inst_72901);

return statearr_72916;
})();
var statearr_72917_72927 = state_72906__$1;
(statearr_72917_72927[(2)] = inst_72891);

(statearr_72917_72927[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__ = null;
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0 = (function (){
var statearr_72918 = [null,null,null,null,null,null,null,null];
(statearr_72918[(0)] = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__);

(statearr_72918[(1)] = (1));

return statearr_72918;
});
var fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1 = (function (state_72906){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_72906);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e72919){var ex__16398__auto__ = e72919;
var statearr_72920_72928 = state_72906;
(statearr_72920_72928[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_72906[(4)]))){
var statearr_72921_72929 = state_72906;
(statearr_72921_72929[(1)] = cljs.core.first((state_72906[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__72930 = state_72906;
state_72906 = G__72930;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__ = function(state_72906){
switch(arguments.length){
case 0:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1.call(this,state_72906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____0;
fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto____1;
return fluree$db$dbfunctions$fns$cas_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_72922 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_72922[(6)] = c__16469__auto__);

return statearr_72922;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
