// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.graphdb');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.storage.core');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
goog.require('fluree.db.util.schema');
goog.require('clojure.data.avl');
goog.require('fluree.db.query.fql');
goog.require('fluree.db.index');
goog.require('fluree.db.query.range');
goog.require('fluree.db.constants');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.async');
goog.require('cljs.core.async');
goog.require('clojure.string');
/**
 * Returns when ledger name is valid.
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_name = (function fluree$db$graphdb$validate_ledger_name(ledger_id,type){
if(cljs.core.truth_(cljs.core.re_matches(/^[a-z0-9-]{1,100}/,ledger_id))){
return null;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(type)," id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),". Must match a-z0-9- and be no more than 100 characters long."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_db], null));
}
});
/**
 * Returns two-tuple of [network name-or-dbid] if db-ident is valid.
 * 
 *   Will ignore a direct db name reference (prefixed with '_')
 *   Otherwise throws.
 */
fluree.db.graphdb.validate_ledger_ident = (function fluree$db$graphdb$validate_ledger_ident(ledger){
var vec__42195 = cljs.core.re_find(/^([^\/]+)\/(?:_)?([^\/]+)$/,fluree.db.util.core.keyword__GT_str(ledger));
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42195,(0),null);
var network = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42195,(1),null);
var maybe_alias = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__42195,(2),null);
if(cljs.core.truth_((function (){var and__4210__auto__ = network;
if(cljs.core.truth_(and__4210__auto__)){
return maybe_alias;
} else {
return and__4210__auto__;
}
})())){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [network,maybe_alias], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid ledger identity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_ledger_DASH_name], null));
}
});
fluree.db.graphdb.exclude_predicates = cljs.core.PersistentHashSet.createAsIfByAssoc([(107),(108),(106)]);
/**
 * Adds a predicate to post index when :index true is turned on.
 *   Ensures adding the predicate into novelty won't blow past novelty-max.
 *   When reindex? is true, we are doing a full reindex and allow the novelty
 *   to grow beyond novelty-max.
 */
fluree.db.graphdb.add_predicate_to_idx = (function fluree$db$graphdb$add_predicate_to_idx(db,pred_id,p__42198){
var map__42199 = p__42198;
var map__42199__$1 = cljs.core.__destructure_map(map__42199);
var opts = map__42199__$1;
var reindex_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__42199__$1,cljs.core.cst$kw$reindex_QMARK_);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42259){
var state_val_42260 = (state_42259[(1)]);
if((state_val_42260 === (7))){
var inst_42230 = cljs.core.not(reindex_QMARK_);
var state_42259__$1 = state_42259;
var statearr_42261_42285 = state_42259__$1;
(statearr_42261_42285[(2)] = inst_42230);

(statearr_42261_42285[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (1))){
var state_42259__$1 = state_42259;
var statearr_42262_42286 = state_42259__$1;
(statearr_42262_42286[(2)] = null);

(statearr_42262_42286[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (4))){
var inst_42200 = (state_42259[(2)]);
var state_42259__$1 = state_42259;
var statearr_42263_42287 = state_42259__$1;
(statearr_42263_42287[(2)] = inst_42200);

(statearr_42263_42287[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (6))){
var inst_42220 = (state_42259[(7)]);
var inst_42214 = (state_42259[(8)]);
var inst_42228 = (state_42259[(9)]);
var inst_42213 = (state_42259[(2)]);
var inst_42214__$1 = fluree.db.util.async.throw_err(inst_42213);
var inst_42215 = cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(db);
var inst_42216 = cljs.core.__destructure_map(inst_42215);
var inst_42217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42216,cljs.core.cst$kw$post);
var inst_42218 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42216,cljs.core.cst$kw$size);
var inst_42219 = fluree.db.flake.size_bytes(inst_42214__$1);
var inst_42220__$1 = (inst_42218 + inst_42219);
var inst_42221 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42222 = [cljs.core.cst$kw$conn,cljs.core.cst$kw$meta];
var inst_42223 = (new cljs.core.PersistentVector(null,2,(5),inst_42221,inst_42222,null));
var inst_42224 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_42223);
var inst_42225 = cljs.core.__destructure_map(inst_42224);
var inst_42226 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42225,cljs.core.cst$kw$novelty_DASH_min);
var inst_42227 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42225,cljs.core.cst$kw$novelty_DASH_max);
var inst_42228__$1 = (inst_42220__$1 > inst_42227);
var state_42259__$1 = (function (){var statearr_42264 = state_42259;
(statearr_42264[(7)] = inst_42220__$1);

(statearr_42264[(10)] = inst_42217);

(statearr_42264[(8)] = inst_42214__$1);

(statearr_42264[(9)] = inst_42228__$1);

(statearr_42264[(11)] = inst_42226);

return statearr_42264;
})();
if(cljs.core.truth_(inst_42228__$1)){
var statearr_42265_42288 = state_42259__$1;
(statearr_42265_42288[(1)] = (7));

} else {
var statearr_42266_42289 = state_42259__$1;
(statearr_42266_42289[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (3))){
var inst_42257 = (state_42259[(2)]);
var state_42259__$1 = state_42259;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42259__$1,inst_42257);
} else {
if((state_val_42260 === (12))){
var inst_42220 = (state_42259[(7)]);
var inst_42217 = (state_42259[(10)]);
var inst_42214 = (state_42259[(8)]);
var inst_42243 = (state_42259[(2)]);
var inst_42244 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42217,inst_42214);
var inst_42245 = cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(db);
var inst_42246 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(inst_42245,cljs.core.empty);
var inst_42247 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42248 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_42249 = (new cljs.core.PersistentVector(null,2,(5),inst_42247,inst_42248,null));
var inst_42250 = cljs.core.assoc_in(db,inst_42249,inst_42244);
var inst_42251 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42252 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_42253 = (new cljs.core.PersistentVector(null,2,(5),inst_42251,inst_42252,null));
var inst_42254 = cljs.core.assoc_in(inst_42250,inst_42253,inst_42220);
var _ = (function (){var statearr_42267 = state_42259;
(statearr_42267[(4)] = cljs.core.rest((state_42259[(4)])));

return statearr_42267;
})();
var state_42259__$1 = (function (){var statearr_42268 = state_42259;
(statearr_42268[(12)] = inst_42246);

(statearr_42268[(13)] = inst_42243);

return statearr_42268;
})();
var statearr_42269_42290 = state_42259__$1;
(statearr_42269_42290[(2)] = inst_42254);

(statearr_42269_42290[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (2))){
var _ = (function (){var statearr_42270 = state_42259;
(statearr_42270[(4)] = cljs.core.cons((5),(state_42259[(4)])));

return statearr_42270;
})();
var inst_42208 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42209 = [pred_id];
var inst_42210 = (new cljs.core.PersistentVector(null,1,(5),inst_42208,inst_42209,null));
var inst_42211 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_42210);
var state_42259__$1 = state_42259;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42259__$1,(6),inst_42211);
} else {
if((state_val_42260 === (11))){
var state_42259__$1 = state_42259;
var statearr_42272_42291 = state_42259__$1;
(statearr_42272_42291[(2)] = null);

(statearr_42272_42291[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (9))){
var inst_42233 = (state_42259[(2)]);
var state_42259__$1 = state_42259;
if(cljs.core.truth_(inst_42233)){
var statearr_42273_42292 = state_42259__$1;
(statearr_42273_42292[(1)] = (10));

} else {
var statearr_42274_42293 = state_42259__$1;
(statearr_42274_42293[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (5))){
var _ = (function (){var statearr_42275 = state_42259;
(statearr_42275[(4)] = cljs.core.rest((state_42259[(4)])));

return statearr_42275;
})();
var state_42259__$1 = state_42259;
var ex42271 = (state_42259__$1[(2)]);
var statearr_42276_42294 = state_42259__$1;
(statearr_42276_42294[(5)] = ex42271);


if((ex42271 instanceof Error)){
var statearr_42277_42295 = state_42259__$1;
(statearr_42277_42295[(1)] = (4));

(statearr_42277_42295[(5)] = null);

} else {
throw ex42271;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (10))){
var inst_42235 = ["You cannot add ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(pred_id)," to the index at this point. There are too many affected flakes."].join('');
var inst_42236 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_42237 = [cljs.core.cst$kw$db_SLASH_max_DASH_novelty_DASH_size,(400)];
var inst_42238 = cljs.core.PersistentHashMap.fromArrays(inst_42236,inst_42237);
var inst_42239 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42235,inst_42238);
var inst_42240 = (function(){throw inst_42239})();
var state_42259__$1 = state_42259;
var statearr_42278_42296 = state_42259__$1;
(statearr_42278_42296[(2)] = inst_42240);

(statearr_42278_42296[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42260 === (8))){
var inst_42228 = (state_42259[(9)]);
var state_42259__$1 = state_42259;
var statearr_42279_42297 = state_42259__$1;
(statearr_42279_42297[(2)] = inst_42228);

(statearr_42279_42297[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0 = (function (){
var statearr_42280 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42280[(0)] = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__);

(statearr_42280[(1)] = (1));

return statearr_42280;
});
var fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1 = (function (state_42259){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42259);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42281){var ex__16398__auto__ = e42281;
var statearr_42282_42298 = state_42259;
(statearr_42282_42298[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42259[(4)]))){
var statearr_42283_42299 = state_42259;
(statearr_42283_42299[(1)] = cljs.core.first((state_42259[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42300 = state_42259;
state_42259 = G__42300;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__ = function(state_42259){
switch(arguments.length){
case 0:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1.call(this,state_42259);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____0;
fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto____1;
return fluree$db$graphdb$add_predicate_to_idx_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42284 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42284[(6)] = c__16469__auto__);

return statearr_42284;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Processes a single transaction, adding it to the DB.
 *   Assumes flakes are already properly sorted.
 */
fluree.db.graphdb.with_t = (function fluree$db$graphdb$with_t(var_args){
var G__42305 = arguments.length;
switch (G__42305) {
case 2:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2 = (function (db,flakes){
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(db,flakes,null);
}));

(fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3 = (function (db,flakes,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42501){
var state_val_42502 = (state_42501[(1)]);
if((state_val_42502 === (7))){
var state_42501__$1 = state_42501;
var statearr_42503_42571 = state_42501__$1;
(statearr_42503_42571[(2)] = null);

(statearr_42503_42571[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (20))){
var inst_42424 = (state_42501[(7)]);
var inst_42426 = (state_42501[(8)]);
var inst_42394 = (state_42501[(9)]);
var inst_42343 = (state_42501[(10)]);
var inst_42427 = (state_42501[(11)]);
var inst_42423 = (state_42501[(12)]);
var inst_42425 = (state_42501[(13)]);
var inst_42344 = (state_42501[(14)]);
var inst_42437 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$size];
var inst_42438 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42439 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$size];
var inst_42440 = (new cljs.core.PersistentVector(null,2,(5),inst_42438,inst_42439,null));
var inst_42441 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42394,inst_42440);
var inst_42442 = (inst_42343 + inst_42441);
var inst_42443 = [inst_42423,inst_42424,inst_42425,inst_42426,inst_42442];
var inst_42444 = cljs.core.PersistentHashMap.fromArrays(inst_42437,inst_42443);
var inst_42445 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(inst_42394,cljs.core.cst$kw$ecount,inst_42427,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$novelty,inst_42444], 0));
var state_42501__$1 = (function (){var statearr_42504 = state_42501;
(statearr_42504[(15)] = inst_42445);

return statearr_42504;
})();
if(cljs.core.truth_(inst_42344)){
var statearr_42505_42572 = state_42501__$1;
(statearr_42505_42572[(1)] = (23));

} else {
var statearr_42506_42573 = state_42501__$1;
(statearr_42506_42573[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (27))){
var inst_42445 = (state_42501[(15)]);
var state_42501__$1 = state_42501;
var statearr_42507_42574 = state_42501__$1;
(statearr_42507_42574[(2)] = inst_42445);

(statearr_42507_42574[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (1))){
var state_42501__$1 = state_42501;
var statearr_42508_42575 = state_42501__$1;
(statearr_42508_42575[(2)] = null);

(statearr_42508_42575[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (24))){
var inst_42445 = (state_42501[(15)]);
var inst_42448 = cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(inst_42445);
var inst_42449 = (inst_42448 == null);
var state_42501__$1 = state_42501;
var statearr_42509_42576 = state_42501__$1;
(statearr_42509_42576[(2)] = inst_42449);

(statearr_42509_42576[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (39))){
var inst_42476 = (state_42501[(16)]);
var inst_42434 = (state_42501[(17)]);
var inst_42475 = (state_42501[(18)]);
var inst_42477 = (state_42501[(19)]);
var inst_42484 = (state_42501[(20)]);
var inst_42491 = (state_42501[(2)]);
var inst_42422 = inst_42434;
var inst_42423 = inst_42476;
var inst_42424 = inst_42477;
var inst_42425 = inst_42484;
var inst_42426 = inst_42491;
var inst_42427 = inst_42475;
var state_42501__$1 = (function (){var statearr_42510 = state_42501;
(statearr_42510[(21)] = inst_42422);

(statearr_42510[(7)] = inst_42424);

(statearr_42510[(8)] = inst_42426);

(statearr_42510[(11)] = inst_42427);

(statearr_42510[(12)] = inst_42423);

(statearr_42510[(13)] = inst_42425);

return statearr_42510;
})();
var statearr_42511_42577 = state_42501__$1;
(statearr_42511_42577[(2)] = null);

(statearr_42511_42577[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (4))){
var inst_42306 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
var statearr_42512_42578 = state_42501__$1;
(statearr_42512_42578[(2)] = inst_42306);

(statearr_42512_42578[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (15))){
var inst_42366 = (state_42501[(22)]);
var state_42501__$1 = state_42501;
var statearr_42513_42579 = state_42501__$1;
(statearr_42513_42579[(2)] = inst_42366);

(statearr_42513_42579[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (21))){
var inst_42347 = (state_42501[(23)]);
var inst_42342 = (state_42501[(24)]);
var inst_42313 = (state_42501[(25)]);
var inst_42422 = (state_42501[(21)]);
var inst_42424 = (state_42501[(7)]);
var inst_42328 = (state_42501[(26)]);
var inst_42334 = (state_42501[(27)]);
var inst_42338 = (state_42501[(28)]);
var inst_42403 = (state_42501[(29)]);
var inst_42426 = (state_42501[(8)]);
var inst_42434 = (state_42501[(17)]);
var inst_42394 = (state_42501[(9)]);
var inst_42345 = (state_42501[(30)]);
var inst_42343 = (state_42501[(10)]);
var inst_42330 = (state_42501[(31)]);
var inst_42404 = (state_42501[(32)]);
var inst_42427 = (state_42501[(11)]);
var inst_42423 = (state_42501[(12)]);
var inst_42433 = (state_42501[(33)]);
var inst_42425 = (state_42501[(13)]);
var inst_42344 = (state_42501[(14)]);
var inst_42353 = (state_42501[(34)]);
var inst_42472 = inst_42433.s;
var inst_42473 = fluree.db.flake.sid__GT_cid(inst_42472);
var inst_42474 = (function (){var flakes_bytes = inst_42343;
var t = inst_42313;
var seq__42400 = inst_42404;
var spot = inst_42423;
var add_flakes = inst_42330;
var root_setting_change_QMARK_ = inst_42345;
var ref_QMARK__map = inst_42342;
var r = inst_42434;
var psot = inst_42424;
var vec__42429 = inst_42422;
var vec__42399 = inst_42330;
var add_pred_to_idx_QMARK_ = inst_42353;
var _ = inst_42328;
var cid = inst_42473;
var ecount = inst_42427;
var pred_ecount = inst_42347;
var first__42431 = inst_42433;
var db_STAR_ = inst_42394;
var schema_change_QMARK_ = inst_42344;
var add_preds = inst_42334;
var opst = inst_42426;
var idx_QMARK__map = inst_42338;
var seq__42430 = inst_42434;
var G__42398 = inst_42422;
var post = inst_42425;
var first__42401 = inst_42403;
var f = inst_42433;
return (function (p1__42303_SHARP_){
if(cljs.core.truth_(p1__42303_SHARP_)){
var x__4295__auto__ = p1__42303_SHARP_;
var y__4296__auto__ = f.s;
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
} else {
return f.s;
}
});
})();
var inst_42475 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(inst_42427,inst_42473,inst_42474);
var inst_42476 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42423,inst_42433);
var inst_42477 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42424,inst_42433);
var inst_42478 = inst_42433.p;
var inst_42479 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42338,inst_42478);
var state_42501__$1 = (function (){var statearr_42514 = state_42501;
(statearr_42514[(16)] = inst_42476);

(statearr_42514[(18)] = inst_42475);

(statearr_42514[(19)] = inst_42477);

return statearr_42514;
})();
if(cljs.core.truth_(inst_42479)){
var statearr_42515_42580 = state_42501__$1;
(statearr_42515_42580[(1)] = (34));

} else {
var statearr_42516_42581 = state_42501__$1;
(statearr_42516_42581[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (31))){
var inst_42460 = (state_42501[(35)]);
var state_42501__$1 = state_42501;
var statearr_42517_42582 = state_42501__$1;
(statearr_42517_42582[(2)] = inst_42460);

(statearr_42517_42582[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (32))){
var inst_42470 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
var statearr_42518_42583 = state_42501__$1;
(statearr_42518_42583[(2)] = inst_42470);

(statearr_42518_42583[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (33))){
var inst_42460 = (state_42501[(35)]);
var inst_42465 = (state_42501[(2)]);
var inst_42466 = fluree.db.util.async.throw_err(inst_42465);
var inst_42467 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42460,cljs.core.cst$kw$settings,inst_42466);
var state_42501__$1 = state_42501;
var statearr_42519_42584 = state_42501__$1;
(statearr_42519_42584[(2)] = inst_42467);

(statearr_42519_42584[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (13))){
var inst_42313 = (state_42501[(25)]);
var inst_42394 = (state_42501[(9)]);
var inst_42343 = (state_42501[(10)]);
var inst_42330 = (state_42501[(31)]);
var inst_42384 = (state_42501[(2)]);
var inst_42385 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42384,cljs.core.cst$kw$t,inst_42313);
var inst_42386 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42387 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$size];
var inst_42388 = (new cljs.core.PersistentVector(null,2,(5),inst_42386,inst_42387,null));
var inst_42389 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_42385,inst_42388,cljs.core._PLUS_,inst_42343);
var inst_42390 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42391 = [cljs.core.cst$kw$stats,cljs.core.cst$kw$flakes];
var inst_42392 = (new cljs.core.PersistentVector(null,2,(5),inst_42390,inst_42391,null));
var inst_42393 = cljs.core.count(inst_42330);
var inst_42394__$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(inst_42389,inst_42392,cljs.core._PLUS_,inst_42393);
var inst_42402 = cljs.core.seq(inst_42330);
var inst_42403 = cljs.core.first(inst_42402);
var inst_42404 = cljs.core.next(inst_42402);
var inst_42405 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42406 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$spot];
var inst_42407 = (new cljs.core.PersistentVector(null,2,(5),inst_42405,inst_42406,null));
var inst_42408 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42394__$1,inst_42407);
var inst_42409 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42410 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$psot];
var inst_42411 = (new cljs.core.PersistentVector(null,2,(5),inst_42409,inst_42410,null));
var inst_42412 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42394__$1,inst_42411);
var inst_42413 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42414 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$post];
var inst_42415 = (new cljs.core.PersistentVector(null,2,(5),inst_42413,inst_42414,null));
var inst_42416 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42394__$1,inst_42415);
var inst_42417 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42418 = [cljs.core.cst$kw$novelty,cljs.core.cst$kw$opst];
var inst_42419 = (new cljs.core.PersistentVector(null,2,(5),inst_42417,inst_42418,null));
var inst_42420 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_42394__$1,inst_42419);
var inst_42421 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_42422 = inst_42330;
var inst_42423 = inst_42408;
var inst_42424 = inst_42412;
var inst_42425 = inst_42416;
var inst_42426 = inst_42420;
var inst_42427 = inst_42421;
var state_42501__$1 = (function (){var statearr_42520 = state_42501;
(statearr_42520[(21)] = inst_42422);

(statearr_42520[(7)] = inst_42424);

(statearr_42520[(29)] = inst_42403);

(statearr_42520[(8)] = inst_42426);

(statearr_42520[(9)] = inst_42394__$1);

(statearr_42520[(32)] = inst_42404);

(statearr_42520[(11)] = inst_42427);

(statearr_42520[(12)] = inst_42423);

(statearr_42520[(13)] = inst_42425);

return statearr_42520;
})();
var statearr_42521_42585 = state_42501__$1;
(statearr_42521_42585[(2)] = null);

(statearr_42521_42585[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (22))){
var inst_42494 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
var statearr_42522_42586 = state_42501__$1;
(statearr_42522_42586[(2)] = inst_42494);

(statearr_42522_42586[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (36))){
var inst_42342 = (state_42501[(24)]);
var inst_42433 = (state_42501[(33)]);
var inst_42484 = (state_42501[(2)]);
var inst_42485 = inst_42433.p;
var inst_42486 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42342,inst_42485);
var state_42501__$1 = (function (){var statearr_42523 = state_42501;
(statearr_42523[(20)] = inst_42484);

return statearr_42523;
})();
if(cljs.core.truth_(inst_42486)){
var statearr_42524_42587 = state_42501__$1;
(statearr_42524_42587[(1)] = (37));

} else {
var statearr_42525_42588 = state_42501__$1;
(statearr_42525_42588[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (29))){
var inst_42445 = (state_42501[(15)]);
var inst_42455 = (state_42501[(2)]);
var inst_42456 = fluree.db.util.async.throw_err(inst_42455);
var inst_42457 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42445,cljs.core.cst$kw$schema,inst_42456);
var state_42501__$1 = state_42501;
var statearr_42526_42589 = state_42501__$1;
(statearr_42526_42589[(2)] = inst_42457);

(statearr_42526_42589[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (6))){
var inst_42313 = (state_42501[(25)]);
var inst_42318 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_42319 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42320 = ["Invalid with called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42318)," because current 't', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42319)," is not beyond supplied transaction t: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42313),"."].join('');
var inst_42321 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42322 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42323 = cljs.core.PersistentHashMap.fromArrays(inst_42321,inst_42322);
var inst_42324 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42320,inst_42323);
var inst_42325 = (function(){throw inst_42324})();
var state_42501__$1 = state_42501;
var statearr_42527_42590 = state_42501__$1;
(statearr_42527_42590[(2)] = inst_42325);

(statearr_42527_42590[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (28))){
var inst_42345 = (state_42501[(30)]);
var inst_42460 = (state_42501[(2)]);
var state_42501__$1 = (function (){var statearr_42528 = state_42501;
(statearr_42528[(35)] = inst_42460);

return statearr_42528;
})();
if(cljs.core.truth_(inst_42345)){
var statearr_42529_42591 = state_42501__$1;
(statearr_42529_42591[(1)] = (30));

} else {
var statearr_42530_42592 = state_42501__$1;
(statearr_42530_42592[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (25))){
var inst_42451 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
if(cljs.core.truth_(inst_42451)){
var statearr_42531_42593 = state_42501__$1;
(statearr_42531_42593[(1)] = (26));

} else {
var statearr_42532_42594 = state_42501__$1;
(statearr_42532_42594[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (34))){
var inst_42433 = (state_42501[(33)]);
var inst_42425 = (state_42501[(13)]);
var inst_42481 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42425,inst_42433);
var state_42501__$1 = state_42501;
var statearr_42533_42595 = state_42501__$1;
(statearr_42533_42595[(2)] = inst_42481);

(statearr_42533_42595[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (17))){
var inst_42373 = (state_42501[(36)]);
var inst_42377 = (state_42501[(2)]);
var inst_42378 = fluree.db.util.async.throw_err(inst_42377);
var inst_42365 = inst_42373;
var inst_42366 = inst_42378;
var state_42501__$1 = (function (){var statearr_42534 = state_42501;
(statearr_42534[(37)] = inst_42365);

(statearr_42534[(22)] = inst_42366);

return statearr_42534;
})();
var statearr_42535_42596 = state_42501__$1;
(statearr_42535_42596[(2)] = null);

(statearr_42535_42596[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (3))){
var inst_42499 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42501__$1,inst_42499);
} else {
if((state_val_42502 === (12))){
var inst_42365 = (state_42501[(37)]);
var inst_42372 = (state_42501[(38)]);
var inst_42371 = cljs.core.seq(inst_42365);
var inst_42372__$1 = cljs.core.first(inst_42371);
var inst_42373 = cljs.core.next(inst_42371);
var state_42501__$1 = (function (){var statearr_42536 = state_42501;
(statearr_42536[(38)] = inst_42372__$1);

(statearr_42536[(36)] = inst_42373);

return statearr_42536;
})();
if(cljs.core.truth_(inst_42372__$1)){
var statearr_42537_42597 = state_42501__$1;
(statearr_42537_42597[(1)] = (14));

} else {
var statearr_42538_42598 = state_42501__$1;
(statearr_42538_42598[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (2))){
var inst_42313 = (state_42501[(25)]);
var _ = (function (){var statearr_42539 = state_42501;
(statearr_42539[(4)] = cljs.core.cons((5),(state_42501[(4)])));

return statearr_42539;
})();
var inst_42312 = cljs.core.first(flakes);
var inst_42313__$1 = inst_42312.t;
var inst_42314 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_42315 = (inst_42314 - (1));
var inst_42316 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(inst_42313__$1,inst_42315);
var state_42501__$1 = (function (){var statearr_42540 = state_42501;
(statearr_42540[(25)] = inst_42313__$1);

return statearr_42540;
})();
if(inst_42316){
var statearr_42541_42599 = state_42501__$1;
(statearr_42541_42599[(1)] = (6));

} else {
var statearr_42542_42600 = state_42501__$1;
(statearr_42542_42600[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (23))){
var inst_42344 = (state_42501[(14)]);
var state_42501__$1 = state_42501;
var statearr_42543_42601 = state_42501__$1;
(statearr_42543_42601[(2)] = inst_42344);

(statearr_42543_42601[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (35))){
var inst_42425 = (state_42501[(13)]);
var state_42501__$1 = state_42501;
var statearr_42544_42602 = state_42501__$1;
(statearr_42544_42602[(2)] = inst_42425);

(statearr_42544_42602[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (19))){
var inst_42496 = (state_42501[(2)]);
var _ = (function (){var statearr_42545 = state_42501;
(statearr_42545[(4)] = cljs.core.rest((state_42501[(4)])));

return statearr_42545;
})();
var state_42501__$1 = state_42501;
var statearr_42546_42603 = state_42501__$1;
(statearr_42546_42603[(2)] = inst_42496);

(statearr_42546_42603[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (11))){
var inst_42353 = (state_42501[(34)]);
var inst_42353__$1 = (state_42501[(2)]);
var inst_42361 = cljs.core.seq(inst_42353__$1);
var inst_42362 = cljs.core.first(inst_42361);
var inst_42363 = cljs.core.next(inst_42361);
var inst_42364 = db;
var inst_42365 = inst_42353__$1;
var inst_42366 = inst_42364;
var state_42501__$1 = (function (){var statearr_42548 = state_42501;
(statearr_42548[(39)] = inst_42363);

(statearr_42548[(37)] = inst_42365);

(statearr_42548[(22)] = inst_42366);

(statearr_42548[(40)] = inst_42362);

(statearr_42548[(34)] = inst_42353__$1);

return statearr_42548;
})();
var statearr_42549_42604 = state_42501__$1;
(statearr_42549_42604[(2)] = null);

(statearr_42549_42604[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (9))){
var inst_42347 = (state_42501[(23)]);
var inst_42330 = (state_42501[(31)]);
var inst_42349 = fluree.db.util.schema.add_to_post_preds_QMARK_(inst_42330,inst_42347);
var state_42501__$1 = state_42501;
var statearr_42550_42605 = state_42501__$1;
(statearr_42550_42605[(2)] = inst_42349);

(statearr_42550_42605[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (5))){
var _ = (function (){var statearr_42551 = state_42501;
(statearr_42551[(4)] = cljs.core.rest((state_42501[(4)])));

return statearr_42551;
})();
var state_42501__$1 = state_42501;
var ex42547 = (state_42501__$1[(2)]);
var statearr_42552_42606 = state_42501__$1;
(statearr_42552_42606[(5)] = ex42547);


if((ex42547 instanceof Error)){
var statearr_42553_42607 = state_42501__$1;
(statearr_42553_42607[(1)] = (4));

(statearr_42553_42607[(5)] = null);

} else {
throw ex42547;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (14))){
var inst_42366 = (state_42501[(22)]);
var inst_42372 = (state_42501[(38)]);
var inst_42375 = fluree.db.graphdb.add_predicate_to_idx(inst_42366,inst_42372,opts);
var state_42501__$1 = state_42501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42501__$1,(17),inst_42375);
} else {
if((state_val_42502 === (26))){
var inst_42445 = (state_42501[(15)]);
var inst_42453 = fluree.db.query.schema.schema_map(inst_42445);
var state_42501__$1 = state_42501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42501__$1,(29),inst_42453);
} else {
if((state_val_42502 === (16))){
var inst_42382 = (state_42501[(2)]);
var state_42501__$1 = state_42501;
var statearr_42554_42608 = state_42501__$1;
(statearr_42554_42608[(2)] = inst_42382);

(statearr_42554_42608[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (38))){
var inst_42426 = (state_42501[(8)]);
var state_42501__$1 = state_42501;
var statearr_42555_42609 = state_42501__$1;
(statearr_42555_42609[(2)] = inst_42426);

(statearr_42555_42609[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (30))){
var inst_42460 = (state_42501[(35)]);
var inst_42463 = fluree.db.query.schema.setting_map(inst_42460);
var state_42501__$1 = state_42501;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42501__$1,(33),inst_42463);
} else {
if((state_val_42502 === (10))){
var inst_42351 = cljs.core.PersistentVector.EMPTY;
var state_42501__$1 = state_42501;
var statearr_42556_42610 = state_42501__$1;
(statearr_42556_42610[(2)] = inst_42351);

(statearr_42556_42610[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (18))){
var inst_42422 = (state_42501[(21)]);
var inst_42433 = (state_42501[(33)]);
var inst_42432 = cljs.core.seq(inst_42422);
var inst_42433__$1 = cljs.core.first(inst_42432);
var inst_42434 = cljs.core.next(inst_42432);
var inst_42435 = cljs.core.not(inst_42433__$1);
var state_42501__$1 = (function (){var statearr_42557 = state_42501;
(statearr_42557[(17)] = inst_42434);

(statearr_42557[(33)] = inst_42433__$1);

return statearr_42557;
})();
if(inst_42435){
var statearr_42558_42611 = state_42501__$1;
(statearr_42558_42611[(1)] = (20));

} else {
var statearr_42559_42612 = state_42501__$1;
(statearr_42559_42612[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (37))){
var inst_42426 = (state_42501[(8)]);
var inst_42433 = (state_42501[(33)]);
var inst_42488 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42426,inst_42433);
var state_42501__$1 = state_42501;
var statearr_42560_42613 = state_42501__$1;
(statearr_42560_42613[(2)] = inst_42488);

(statearr_42560_42613[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42502 === (8))){
var inst_42313 = (state_42501[(25)]);
var inst_42328 = (state_42501[(26)]);
var inst_42334 = (state_42501[(27)]);
var inst_42338 = (state_42501[(28)]);
var inst_42330 = (state_42501[(31)]);
var inst_42344 = (state_42501[(14)]);
var inst_42328__$1 = (state_42501[(2)]);
var inst_42329 = (function (){var t = inst_42313;
var _ = inst_42328__$1;
return (function (p1__42301_SHARP_){
return cljs.core.not((function (){var G__42561 = p1__42301_SHARP_.p;
return (fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.graphdb.exclude_predicates.cljs$core$IFn$_invoke$arity$1(G__42561) : fluree.db.graphdb.exclude_predicates.call(null,G__42561));
})());
});
})();
var inst_42330__$1 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_42329,flakes);
var inst_42331 = cljs.core.PersistentHashSet.EMPTY;
var inst_42332 = (function (){var t = inst_42313;
var _ = inst_42328__$1;
var add_flakes = inst_42330__$1;
return (function (p1__42302_SHARP_){
return p1__42302_SHARP_.p;
});
})();
var inst_42333 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42332,inst_42330__$1);
var inst_42334__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42331,inst_42333);
var inst_42335 = cljs.core.PersistentHashMap.EMPTY;
var inst_42336 = (function (){var t = inst_42313;
var _ = inst_42328__$1;
var add_flakes = inst_42330__$1;
var add_preds = inst_42334__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p)], null);
});
})();
var inst_42337 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42336,inst_42334__$1);
var inst_42338__$1 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42335,inst_42337);
var inst_42339 = cljs.core.PersistentHashMap.EMPTY;
var inst_42340 = (function (){var t = inst_42313;
var _ = inst_42328__$1;
var add_flakes = inst_42330__$1;
var add_preds = inst_42334__$1;
var idx_QMARK__map = inst_42338__$1;
return (function (p){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p)], null);
});
})();
var inst_42341 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_42340,inst_42334__$1);
var inst_42342 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_42339,inst_42341);
var inst_42343 = fluree.db.flake.size_bytes(inst_42330__$1);
var inst_42344__$1 = fluree.db.util.schema.schema_change_QMARK_(inst_42330__$1);
var inst_42345 = fluree.db.util.schema.setting_change_QMARK_(inst_42330__$1);
var inst_42346 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_42347 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_42346,(0));
var state_42501__$1 = (function (){var statearr_42562 = state_42501;
(statearr_42562[(23)] = inst_42347);

(statearr_42562[(24)] = inst_42342);

(statearr_42562[(26)] = inst_42328__$1);

(statearr_42562[(27)] = inst_42334__$1);

(statearr_42562[(28)] = inst_42338__$1);

(statearr_42562[(30)] = inst_42345);

(statearr_42562[(10)] = inst_42343);

(statearr_42562[(31)] = inst_42330__$1);

(statearr_42562[(14)] = inst_42344__$1);

return statearr_42562;
})();
if(cljs.core.truth_(inst_42344__$1)){
var statearr_42563_42614 = state_42501__$1;
(statearr_42563_42614[(1)] = (9));

} else {
var statearr_42564_42615 = state_42501__$1;
(statearr_42564_42615[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_42565 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42565[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_42565[(1)] = (1));

return statearr_42565;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_42501){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42501);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42566){var ex__16398__auto__ = e42566;
var statearr_42567_42616 = state_42501;
(statearr_42567_42616[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42501[(4)]))){
var statearr_42568_42617 = state_42501;
(statearr_42568_42617[(1)] = cljs.core.first((state_42501[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42618 = state_42501;
state_42501 = G__42618;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_42501){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_42501);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42569 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42569[(6)] = c__16469__auto__);

return statearr_42569;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.with_t.cljs$lang$maxFixedArity = 3);

/**
 * Returns db 'with' flakes added as a core async promise channel.
 *   Note this always does a re-sort.
 */
fluree.db.graphdb.with$ = (function fluree$db$graphdb$with(var_args){
var G__42620 = arguments.length;
switch (G__42620) {
case 3:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$3 = (function (db,block,flakes){
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(db,block,flakes,null);
}));

(fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4 = (function (db,block,flakes,opts){
var resp_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___42767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42716){
var state_val_42717 = (state_42716[(1)]);
if((state_val_42717 === (7))){
var state_42716__$1 = state_42716;
var statearr_42718_42768 = state_42716__$1;
(statearr_42718_42768[(2)] = null);

(statearr_42718_42768[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (20))){
var inst_42664 = (state_42716[(7)]);
var inst_42666 = (state_42716[(8)]);
var inst_42665 = (state_42716[(9)]);
var inst_42685 = (inst_42664 + (1));
var inst_42686 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42666,cljs.core.cst$kw$t,inst_42685);
var inst_42687 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(inst_42686,inst_42665,opts);
var state_42716__$1 = state_42716;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42716__$1,(23),inst_42687);
} else {
if((state_val_42717 === (1))){
var state_42716__$1 = state_42716;
var statearr_42719_42769 = state_42716__$1;
(statearr_42719_42769[(2)] = null);

(statearr_42719_42769[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (24))){
var inst_42690 = (state_42716[(10)]);
var inst_42693 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_42690,cljs.core.cst$kw$block,block);
var state_42716__$1 = state_42716;
var statearr_42720_42770 = state_42716__$1;
(statearr_42720_42770[(2)] = inst_42693);

(statearr_42720_42770[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (4))){
var inst_42621 = (state_42716[(2)]);
var inst_42622 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42621);
var state_42716__$1 = state_42716;
var statearr_42721_42771 = state_42716__$1;
(statearr_42721_42771[(2)] = inst_42622);

(statearr_42721_42771[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (15))){
var inst_42672 = (state_42716[(11)]);
var state_42716__$1 = state_42716;
var statearr_42722_42772 = state_42716__$1;
(statearr_42722_42772[(2)] = inst_42672);

(statearr_42722_42772[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (21))){
var state_42716__$1 = state_42716;
var statearr_42723_42773 = state_42716__$1;
(statearr_42723_42773[(2)] = null);

(statearr_42723_42773[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (13))){
var inst_42708 = (state_42716[(2)]);
var inst_42709 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42708);
var state_42716__$1 = state_42716;
var statearr_42724_42774 = state_42716__$1;
(statearr_42724_42774[(2)] = inst_42709);

(statearr_42724_42774[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (22))){
var inst_42704 = (state_42716[(2)]);
var state_42716__$1 = state_42716;
var statearr_42725_42775 = state_42716__$1;
(statearr_42725_42775[(2)] = inst_42704);

(statearr_42725_42775[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (6))){
var inst_42632 = cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(db);
var inst_42633 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42634 = ["Invalid 'with' called for db ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42632)," because current db 'block', ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_42633)," must be one less than supplied block ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block),"."].join('');
var inst_42635 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42636 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_42637 = cljs.core.PersistentHashMap.fromArrays(inst_42635,inst_42636);
var inst_42638 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42634,inst_42637);
var inst_42639 = (function(){throw inst_42638})();
var state_42716__$1 = state_42716;
var statearr_42728_42776 = state_42716__$1;
(statearr_42728_42776[(2)] = inst_42639);

(statearr_42728_42776[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (25))){
var inst_42672 = (state_42716[(11)]);
var inst_42673 = (state_42716[(12)]);
var inst_42690 = (state_42716[(10)]);
var inst_42695 = inst_42672.t;
var inst_42696 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42697 = [inst_42672];
var inst_42698 = (new cljs.core.PersistentVector(null,1,(5),inst_42696,inst_42697,null));
var inst_42663 = inst_42673;
var inst_42664 = inst_42695;
var inst_42665 = inst_42698;
var inst_42666 = inst_42690;
var state_42716__$1 = (function (){var statearr_42729 = state_42716;
(statearr_42729[(7)] = inst_42664);

(statearr_42729[(8)] = inst_42666);

(statearr_42729[(13)] = inst_42663);

(statearr_42729[(9)] = inst_42665);

return statearr_42729;
})();
var statearr_42730_42777 = state_42716__$1;
(statearr_42730_42777[(2)] = null);

(statearr_42730_42777[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (17))){
var inst_42664 = (state_42716[(7)]);
var inst_42666 = (state_42716[(8)]);
var inst_42672 = (state_42716[(11)]);
var inst_42673 = (state_42716[(12)]);
var inst_42665 = (state_42716[(9)]);
var inst_42681 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_42665,inst_42672);
var tmp42726 = inst_42664;
var tmp42727 = inst_42666;
var inst_42663 = inst_42673;
var inst_42664__$1 = tmp42726;
var inst_42665__$1 = inst_42681;
var inst_42666__$1 = tmp42727;
var state_42716__$1 = (function (){var statearr_42731 = state_42716;
(statearr_42731[(7)] = inst_42664__$1);

(statearr_42731[(8)] = inst_42666__$1);

(statearr_42731[(13)] = inst_42663);

(statearr_42731[(9)] = inst_42665__$1);

return statearr_42731;
})();
var statearr_42732_42778 = state_42716__$1;
(statearr_42732_42778[(2)] = null);

(statearr_42732_42778[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (3))){
var inst_42714 = (state_42716[(2)]);
var state_42716__$1 = state_42716;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42716__$1,inst_42714);
} else {
if((state_val_42717 === (12))){
var inst_42672 = (state_42716[(11)]);
var inst_42663 = (state_42716[(13)]);
var inst_42671 = cljs.core.seq(inst_42663);
var inst_42672__$1 = cljs.core.first(inst_42671);
var inst_42673 = cljs.core.next(inst_42671);
var state_42716__$1 = (function (){var statearr_42733 = state_42716;
(statearr_42733[(11)] = inst_42672__$1);

(statearr_42733[(12)] = inst_42673);

return statearr_42733;
})();
if(cljs.core.truth_(inst_42672__$1)){
var statearr_42734_42779 = state_42716__$1;
(statearr_42734_42779[(1)] = (14));

} else {
var statearr_42735_42780 = state_42716__$1;
(statearr_42735_42780[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (2))){
var _ = (function (){var statearr_42736 = state_42716;
(statearr_42736[(4)] = cljs.core.cons((5),(state_42716[(4)])));

return statearr_42736;
})();
var inst_42628 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(db);
var inst_42629 = (inst_42628 + (1));
var inst_42630 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(block,inst_42629);
var state_42716__$1 = state_42716;
if(inst_42630){
var statearr_42737_42781 = state_42716__$1;
(statearr_42737_42781[(1)] = (6));

} else {
var statearr_42738_42782 = state_42716__$1;
(statearr_42738_42782[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (23))){
var inst_42672 = (state_42716[(11)]);
var inst_42689 = (state_42716[(2)]);
var inst_42690 = fluree.db.util.async.throw_err(inst_42689);
var inst_42691 = (inst_42672 == null);
var state_42716__$1 = (function (){var statearr_42739 = state_42716;
(statearr_42739[(10)] = inst_42690);

return statearr_42739;
})();
if(cljs.core.truth_(inst_42691)){
var statearr_42740_42783 = state_42716__$1;
(statearr_42740_42783[(1)] = (24));

} else {
var statearr_42741_42784 = state_42716__$1;
(statearr_42741_42784[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (19))){
var inst_42706 = (state_42716[(2)]);
var state_42716__$1 = state_42716;
var statearr_42742_42785 = state_42716__$1;
(statearr_42742_42785[(2)] = inst_42706);

(statearr_42742_42785[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (11))){
var inst_42711 = (state_42716[(2)]);
var _ = (function (){var statearr_42744 = state_42716;
(statearr_42744[(4)] = cljs.core.rest((state_42716[(4)])));

return statearr_42744;
})();
var state_42716__$1 = state_42716;
var statearr_42745_42786 = state_42716__$1;
(statearr_42745_42786[(2)] = inst_42711);

(statearr_42745_42786[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (9))){
var inst_42645 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$block,block);
var inst_42646 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(resp_ch,inst_42645);
var state_42716__$1 = state_42716;
var statearr_42746_42787 = state_42716__$1;
(statearr_42746_42787[(2)] = inst_42646);

(statearr_42746_42787[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (5))){
var _ = (function (){var statearr_42747 = state_42716;
(statearr_42747[(4)] = cljs.core.rest((state_42716[(4)])));

return statearr_42747;
})();
var state_42716__$1 = state_42716;
var ex42743 = (state_42716__$1[(2)]);
var statearr_42748_42788 = state_42716__$1;
(statearr_42748_42788[(5)] = ex42743);


var statearr_42749_42789 = state_42716__$1;
(statearr_42749_42789[(1)] = (4));

(statearr_42749_42789[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (14))){
var inst_42664 = (state_42716[(7)]);
var inst_42672 = (state_42716[(11)]);
var inst_42675 = inst_42672.t;
var inst_42676 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_42664,inst_42675);
var state_42716__$1 = state_42716;
var statearr_42750_42790 = state_42716__$1;
(statearr_42750_42790[(2)] = inst_42676);

(statearr_42750_42790[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (26))){
var inst_42701 = (state_42716[(2)]);
var state_42716__$1 = state_42716;
var statearr_42751_42791 = state_42716__$1;
(statearr_42751_42791[(2)] = inst_42701);

(statearr_42751_42791[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (16))){
var inst_42679 = (state_42716[(2)]);
var state_42716__$1 = state_42716;
if(cljs.core.truth_(inst_42679)){
var statearr_42752_42792 = state_42716__$1;
(statearr_42752_42792[(1)] = (17));

} else {
var statearr_42753_42793 = state_42716__$1;
(statearr_42753_42793[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (10))){
var inst_42648 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_block,flakes);
var inst_42649 = cljs.core.first(inst_42648);
var inst_42657 = cljs.core.seq(inst_42648);
var inst_42658 = cljs.core.first(inst_42657);
var inst_42659 = cljs.core.next(inst_42657);
var inst_42660 = inst_42649.t;
var inst_42661 = cljs.core.PersistentVector.EMPTY;
var inst_42662 = db;
var inst_42663 = inst_42648;
var inst_42664 = inst_42660;
var inst_42665 = inst_42661;
var inst_42666 = inst_42662;
var state_42716__$1 = (function (){var statearr_42754 = state_42716;
(statearr_42754[(7)] = inst_42664);

(statearr_42754[(8)] = inst_42666);

(statearr_42754[(14)] = inst_42659);

(statearr_42754[(15)] = inst_42658);

(statearr_42754[(13)] = inst_42663);

(statearr_42754[(9)] = inst_42665);

return statearr_42754;
})();
var statearr_42755_42794 = state_42716__$1;
(statearr_42755_42794[(2)] = null);

(statearr_42755_42794[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (18))){
var state_42716__$1 = state_42716;
var statearr_42756_42795 = state_42716__$1;
(statearr_42756_42795[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_42717 === (8))){
var inst_42642 = (state_42716[(2)]);
var inst_42643 = cljs.core.empty_QMARK_(flakes);
var state_42716__$1 = (function (){var statearr_42758 = state_42716;
(statearr_42758[(16)] = inst_42642);

return statearr_42758;
})();
if(inst_42643){
var statearr_42759_42796 = state_42716__$1;
(statearr_42759_42796[(1)] = (9));

} else {
var statearr_42760_42797 = state_42716__$1;
(statearr_42760_42797[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_42761 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42761[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_42761[(1)] = (1));

return statearr_42761;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_42716){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42716);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42762){var ex__16398__auto__ = e42762;
var statearr_42763_42798 = state_42716;
(statearr_42763_42798[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42716[(4)]))){
var statearr_42764_42799 = state_42716;
(statearr_42764_42799[(1)] = cljs.core.first((state_42716[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42800 = state_42716;
state_42716 = G__42800;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_42716){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_42716);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42765 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42765[(6)] = c__16469__auto___42767);

return statearr_42765;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return resp_ch;
}));

(fluree.db.graphdb.with$.cljs$lang$maxFixedArity = 4);

/**
 * Returns true if db is a forward time travel db.
 */
fluree.db.graphdb.forward_time_travel_db_QMARK_ = (function fluree$db$graphdb$forward_time_travel_db_QMARK_(db){
return (!((cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db) == null)));
});
/**
 * Returns a core async chan with a new db based on the provided db, including the provided flakes.
 *   Flakes can contain one or more 't's, but should be sequential and start after the current
 *   't' of the provided db. (i.e. if db-t is -14, flakes 't' should be -15, -16, etc.).
 *   Remember 't' is negative and thus should be in descending order.
 * 
 *   A tt-id (time-travel-id), if provided, can be any unique identifier of any type and is required.
 *   It must be unique (to the computer/process) to avoid any query caching issues.
 * 
 *   A forward-time-travel dbf can be further forward-time-traveled. If a tt-id is provided, ensure
 *   it is unique for each successive call.
 * 
 *   A forward-time travel DB is held in memory, and is not shared across servers. Ensure you
 *   have adequate memory to hold the flakes you generate and add. If access is provided via
 *   an external API, do any desired size restrictions or controls within your API endpoint.
 * 
 *   Remember schema operations done via forward-time-travel should be done in a 't' prior to
 *   the flakes that end up requiring the schema change.
 */
fluree.db.graphdb.forward_time_travel = (function fluree$db$graphdb$forward_time_travel(db,tt_id,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_42856){
var state_val_42857 = (state_42856[(1)]);
if((state_val_42857 === (7))){
var state_42856__$1 = state_42856;
var statearr_42858_42885 = state_42856__$1;
(statearr_42858_42885[(2)] = tt_id);

(statearr_42858_42885[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (1))){
var state_42856__$1 = state_42856;
var statearr_42859_42886 = state_42856__$1;
(statearr_42859_42886[(2)] = null);

(statearr_42859_42886[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (4))){
var inst_42801 = (state_42856[(2)]);
var state_42856__$1 = state_42856;
var statearr_42860_42887 = state_42856__$1;
(statearr_42860_42887[(2)] = inst_42801);

(statearr_42860_42887[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (13))){
var inst_42849 = (state_42856[(2)]);
var state_42856__$1 = state_42856;
var statearr_42861_42888 = state_42856__$1;
(statearr_42861_42888[(2)] = inst_42849);

(statearr_42861_42888[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (6))){
var inst_42809 = fluree.db.util.core.random_uuid();
var state_42856__$1 = state_42856;
var statearr_42862_42889 = state_42856__$1;
(statearr_42862_42889[(2)] = inst_42809);

(statearr_42862_42889[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (3))){
var inst_42854 = (state_42856[(2)]);
var state_42856__$1 = state_42856;
return cljs.core.async.impl.ioc_helpers.return_chan(state_42856__$1,inst_42854);
} else {
if((state_val_42857 === (12))){
var inst_42832 = (state_42856[(7)]);
var state_42856__$1 = state_42856;
var statearr_42863_42890 = state_42856__$1;
(statearr_42863_42890[(2)] = inst_42832);

(statearr_42863_42890[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (2))){
var _ = (function (){var statearr_42864 = state_42856;
(statearr_42864[(4)] = cljs.core.cons((5),(state_42856[(4)])));

return statearr_42864;
})();
var inst_42807 = (tt_id == null);
var state_42856__$1 = state_42856;
if(cljs.core.truth_(inst_42807)){
var statearr_42865_42891 = state_42856__$1;
(statearr_42865_42891[(1)] = (6));

} else {
var statearr_42866_42892 = state_42856__$1;
(statearr_42866_42892[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (11))){
var inst_42839 = (state_42856[(8)]);
var inst_42832 = (state_42856[(7)]);
var inst_42842 = fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$2(inst_42832,inst_42839);
var state_42856__$1 = state_42856;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_42856__$1,(14),inst_42842);
} else {
if((state_val_42857 === (9))){
var inst_42833 = (state_42856[(9)]);
var inst_42839 = (state_42856[(8)]);
var inst_42838 = cljs.core.seq(inst_42833);
var inst_42839__$1 = cljs.core.first(inst_42838);
var inst_42840 = cljs.core.next(inst_42838);
var state_42856__$1 = (function (){var statearr_42868 = state_42856;
(statearr_42868[(8)] = inst_42839__$1);

(statearr_42868[(10)] = inst_42840);

return statearr_42868;
})();
if(cljs.core.truth_(inst_42839__$1)){
var statearr_42869_42893 = state_42856__$1;
(statearr_42869_42893[(1)] = (11));

} else {
var statearr_42870_42894 = state_42856__$1;
(statearr_42870_42894[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (5))){
var _ = (function (){var statearr_42871 = state_42856;
(statearr_42871[(4)] = cljs.core.rest((state_42856[(4)])));

return statearr_42871;
})();
var state_42856__$1 = state_42856;
var ex42867 = (state_42856__$1[(2)]);
var statearr_42872_42895 = state_42856__$1;
(statearr_42872_42895[(5)] = ex42867);


if((ex42867 instanceof Error)){
var statearr_42873_42896 = state_42856__$1;
(statearr_42873_42896[(1)] = (4));

(statearr_42873_42896[(5)] = null);

} else {
throw ex42867;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (14))){
var inst_42840 = (state_42856[(10)]);
var inst_42844 = (state_42856[(2)]);
var inst_42845 = fluree.db.util.async.throw_err(inst_42844);
var inst_42832 = inst_42845;
var inst_42833 = inst_42840;
var state_42856__$1 = (function (){var statearr_42874 = state_42856;
(statearr_42874[(9)] = inst_42833);

(statearr_42874[(7)] = inst_42832);

return statearr_42874;
})();
var statearr_42875_42897 = state_42856__$1;
(statearr_42875_42897[(2)] = null);

(statearr_42875_42897[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (10))){
var inst_42851 = (state_42856[(2)]);
var _ = (function (){var statearr_42876 = state_42856;
(statearr_42876[(4)] = cljs.core.rest((state_42856[(4)])));

return statearr_42876;
})();
var state_42856__$1 = state_42856;
var statearr_42877_42898 = state_42856__$1;
(statearr_42877_42898[(2)] = inst_42851);

(statearr_42877_42898[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_42857 === (8))){
var inst_42812 = (state_42856[(2)]);
var inst_42813 = (function (){var tt_id_SINGLEQUOTE_ = inst_42812;
return (function (db_STAR_,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db_STAR_,idx,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(db_STAR_,idx),cljs.core.cst$kw$tt_DASH_id,tt_id_SINGLEQUOTE_));
});
})();
var inst_42814 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,cljs.core.cst$kw$tt_DASH_id,inst_42812);
var inst_42815 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42816 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst];
var inst_42817 = (new cljs.core.PersistentVector(null,4,(5),inst_42815,inst_42816,null));
var inst_42818 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_42813,inst_42814,inst_42817);
var inst_42819 = cljs.core.sort_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,flakes);
var inst_42820 = cljs.core.reverse(inst_42819);
var inst_42821 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$t,inst_42820);
var inst_42829 = cljs.core.seq(inst_42821);
var inst_42830 = cljs.core.first(inst_42829);
var inst_42831 = cljs.core.next(inst_42829);
var inst_42832 = inst_42818;
var inst_42833 = inst_42821;
var state_42856__$1 = (function (){var statearr_42878 = state_42856;
(statearr_42878[(11)] = inst_42831);

(statearr_42878[(9)] = inst_42833);

(statearr_42878[(7)] = inst_42832);

(statearr_42878[(12)] = inst_42830);

return statearr_42878;
})();
var statearr_42879_42899 = state_42856__$1;
(statearr_42879_42899[(2)] = null);

(statearr_42879_42899[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0 = (function (){
var statearr_42880 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42880[(0)] = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__);

(statearr_42880[(1)] = (1));

return statearr_42880;
});
var fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1 = (function (state_42856){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_42856);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42881){var ex__16398__auto__ = e42881;
var statearr_42882_42900 = state_42856;
(statearr_42882_42900[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_42856[(4)]))){
var statearr_42883_42901 = state_42856;
(statearr_42883_42901[(1)] = cljs.core.first((state_42856[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42902 = state_42856;
state_42856 = G__42902;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__ = function(state_42856){
switch(arguments.length){
case 0:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1.call(this,state_42856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____0;
fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto____1;
return fluree$db$graphdb$forward_time_travel_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42884 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42884[(6)] = c__16469__auto__);

return statearr_42884;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns subject ID of ident as async promise channel.
 *   Closes channel (nil) if doesn't exist, or if strict? is true, will return exception.
 */
fluree.db.graphdb.subid = (function fluree$db$graphdb$subid(db,ident,strict_QMARK_){
var return_chan = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___43089 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43020){
var state_val_43021 = (state_43020[(1)]);
if((state_val_43021 === (7))){
var inst_42930 = (state_43020[(7)]);
var inst_42930__$1 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_43020__$1 = (function (){var statearr_43022 = state_43020;
(statearr_43022[(7)] = inst_42930__$1);

return statearr_43022;
})();
if(inst_42930__$1){
var statearr_43023_43090 = state_43020__$1;
(statearr_43023_43090[(1)] = (13));

} else {
var statearr_43024_43091 = state_43020__$1;
(statearr_43024_43091[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (20))){
var state_43020__$1 = state_43020;
var statearr_43025_43092 = state_43020__$1;
(statearr_43025_43092[(1)] = (29));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (27))){
var inst_42966 = (state_43020[(8)]);
var inst_42970 = inst_42966.s;
var state_43020__$1 = state_43020;
var statearr_43027_43093 = state_43020__$1;
(statearr_43027_43093[(2)] = inst_42970);

(statearr_43027_43093[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (1))){
var state_43020__$1 = state_43020;
var statearr_43028_43094 = state_43020__$1;
(statearr_43028_43094[(2)] = null);

(statearr_43028_43094[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (24))){
var inst_42960 = (state_43020[(9)]);
var inst_42964 = cljs.core.first(inst_42960);
var state_43020__$1 = state_43020;
var statearr_43029_43095 = state_43020__$1;
(statearr_43029_43095[(2)] = inst_42964);

(statearr_43029_43095[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (39))){
var state_43020__$1 = state_43020;
var statearr_43030_43096 = state_43020__$1;
(statearr_43030_43096[(1)] = (41));



return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (4))){
var inst_42903 = (state_43020[(2)]);
var inst_42904 = ["Error looking up subject id: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_42905 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42906 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_42907 = cljs.core.PersistentHashMap.fromArrays(inst_42905,inst_42906);
var inst_42908 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$3(inst_42904,inst_42907,inst_42903);
var inst_42909 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42908);
var state_43020__$1 = state_43020;
var statearr_43032_43097 = state_43020__$1;
(statearr_43032_43097[(2)] = inst_42909);

(statearr_43032_43097[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (15))){
var inst_42937 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
if(cljs.core.truth_(inst_42937)){
var statearr_43033_43098 = state_43020__$1;
(statearr_43033_43098[(1)] = (16));

} else {
var statearr_43034_43099 = state_43020__$1;
(statearr_43034_43099[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (21))){
var inst_42986 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43035_43100 = state_43020__$1;
(statearr_43035_43100[(2)] = inst_42986);

(statearr_43035_43100[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (31))){
var inst_42984 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43036_43101 = state_43020__$1;
(statearr_43036_43101[(2)] = inst_42984);

(statearr_43036_43101[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (32))){
var inst_42990 = (state_43020[(10)]);
var inst_42992 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_42990);
var state_43020__$1 = state_43020;
var statearr_43037_43102 = state_43020__$1;
(statearr_43037_43102[(2)] = inst_42992);

(statearr_43037_43102[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (40))){
var inst_43013 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43038_43103 = state_43020__$1;
(statearr_43038_43103[(2)] = inst_43013);

(statearr_43038_43103[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (33))){
var inst_42994 = (state_43020[(11)]);
var inst_42990 = (state_43020[(10)]);
var inst_42994__$1 = (inst_42990 == null);
var state_43020__$1 = (function (){var statearr_43039 = state_43020;
(statearr_43039[(11)] = inst_42994__$1);

return statearr_43039;
})();
if(cljs.core.truth_(inst_42994__$1)){
var statearr_43040_43104 = state_43020__$1;
(statearr_43040_43104[(1)] = (35));

} else {
var statearr_43041_43105 = state_43020__$1;
(statearr_43041_43105[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (13))){
var inst_42932 = cljs.core.first(ident);
var inst_42933 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42932);
var inst_42934 = (inst_42933 == null);
var state_43020__$1 = state_43020;
var statearr_43042_43106 = state_43020__$1;
(statearr_43042_43106[(2)] = inst_42934);

(statearr_43042_43106[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (22))){
var inst_42960 = (state_43020[(9)]);
var inst_42959 = (state_43020[(2)]);
var inst_42960__$1 = fluree.db.util.async.throw_err(inst_42959);
var inst_42961 = (inst_42960__$1 == null);
var state_43020__$1 = (function (){var statearr_43043 = state_43020;
(statearr_43043[(9)] = inst_42960__$1);

return statearr_43043;
})();
if(cljs.core.truth_(inst_42961)){
var statearr_43044_43107 = state_43020__$1;
(statearr_43044_43107[(1)] = (23));

} else {
var statearr_43045_43108 = state_43020__$1;
(statearr_43045_43108[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (36))){
var inst_42994 = (state_43020[(11)]);
var state_43020__$1 = state_43020;
var statearr_43046_43109 = state_43020__$1;
(statearr_43046_43109[(2)] = inst_42994);

(statearr_43046_43109[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (41))){
var inst_43008 = cljs.core.async.close_BANG_(return_chan);
var state_43020__$1 = state_43020;
var statearr_43047_43110 = state_43020__$1;
(statearr_43047_43110[(2)] = inst_43008);

(statearr_43047_43110[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (43))){
var inst_43011 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43048_43111 = state_43020__$1;
(statearr_43048_43111[(2)] = inst_43011);

(statearr_43048_43111[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (29))){
var inst_42975 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([ident], 0));
var inst_42976 = ["Entid lookup must be a number or valid two-tuple identity: ",inst_42975].join('');
var inst_42977 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42978 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42979 = cljs.core.PersistentHashMap.fromArrays(inst_42977,inst_42978);
var inst_42980 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42976,inst_42979);
var inst_42981 = (function(){throw inst_42980})();
var state_43020__$1 = state_43020;
var statearr_43049_43112 = state_43020__$1;
(statearr_43049_43112[(2)] = inst_42981);

(statearr_43049_43112[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (6))){
var inst_42917 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42918 = [ident];
var inst_42919 = (new cljs.core.PersistentVector(null,1,(5),inst_42917,inst_42918,null));
var inst_42920 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_42919);
var state_43020__$1 = state_43020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43020__$1,(9),inst_42920);
} else {
if((state_val_43021 === (28))){
var inst_42972 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43050_43113 = state_43020__$1;
(statearr_43050_43113[(2)] = inst_42972);

(statearr_43050_43113[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (25))){
var inst_42966 = (state_43020[(8)]);
var inst_42966__$1 = (state_43020[(2)]);
var inst_42967 = (inst_42966__$1 == null);
var state_43020__$1 = (function (){var statearr_43051 = state_43020;
(statearr_43051[(8)] = inst_42966__$1);

return statearr_43051;
})();
if(cljs.core.truth_(inst_42967)){
var statearr_43052_43114 = state_43020__$1;
(statearr_43052_43114[(1)] = (26));

} else {
var statearr_43053_43115 = state_43020__$1;
(statearr_43053_43115[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (34))){
var inst_43015 = (state_43020[(2)]);
var _ = (function (){var statearr_43054 = state_43020;
(statearr_43054[(4)] = cljs.core.rest((state_43020[(4)])));

return statearr_43054;
})();
var state_43020__$1 = state_43020;
var statearr_43055_43116 = state_43020__$1;
(statearr_43055_43116[(2)] = inst_43015);

(statearr_43055_43116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (17))){
var inst_42948 = fluree.db.util.core.pred_ident_QMARK_(ident);
var state_43020__$1 = state_43020;
if(inst_42948){
var statearr_43056_43117 = state_43020__$1;
(statearr_43056_43117[(1)] = (19));

} else {
var statearr_43057_43118 = state_43020__$1;
(statearr_43057_43118[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (3))){
var inst_43018 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43020__$1,inst_43018);
} else {
if((state_val_43021 === (12))){
var inst_42928 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43058_43119 = state_43020__$1;
(statearr_43058_43119[(2)] = inst_42928);

(statearr_43058_43119[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (2))){
var _ = (function (){var statearr_43059 = state_43020;
(statearr_43059[(4)] = cljs.core.cons((5),(state_43020[(4)])));

return statearr_43059;
})();
var inst_42915 = typeof ident === 'number';
var state_43020__$1 = state_43020;
if(cljs.core.truth_(inst_42915)){
var statearr_43060_43120 = state_43020__$1;
(statearr_43060_43120[(1)] = (6));

} else {
var statearr_43061_43121 = state_43020__$1;
(statearr_43061_43121[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (23))){
var state_43020__$1 = state_43020;
var statearr_43062_43122 = state_43020__$1;
(statearr_43062_43122[(2)] = null);

(statearr_43062_43122[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (35))){
var state_43020__$1 = state_43020;
var statearr_43063_43123 = state_43020__$1;
(statearr_43063_43123[(2)] = strict_QMARK_);

(statearr_43063_43123[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (19))){
var inst_42951 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_42952 = cljs.core.first(ident);
var inst_42953 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,inst_42952);
var inst_42954 = cljs.core.second(ident);
var inst_42955 = [inst_42953,inst_42954];
var inst_42956 = (new cljs.core.PersistentVector(null,2,(5),inst_42951,inst_42955,null));
var inst_42957 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_42956);
var state_43020__$1 = state_43020;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43020__$1,(22),inst_42957);
} else {
if((state_val_43021 === (11))){
var state_43020__$1 = state_43020;
var statearr_43065_43124 = state_43020__$1;
(statearr_43065_43124[(2)] = null);

(statearr_43065_43124[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (9))){
var inst_42922 = (state_43020[(2)]);
var inst_42923 = fluree.db.util.async.throw_err(inst_42922);
var inst_42924 = cljs.core.not_empty(inst_42923);
var state_43020__$1 = state_43020;
if(cljs.core.truth_(inst_42924)){
var statearr_43066_43125 = state_43020__$1;
(statearr_43066_43125[(1)] = (10));

} else {
var statearr_43067_43126 = state_43020__$1;
(statearr_43067_43126[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (5))){
var _ = (function (){var statearr_43068 = state_43020;
(statearr_43068[(4)] = cljs.core.rest((state_43020[(4)])));

return statearr_43068;
})();
var state_43020__$1 = state_43020;
var ex43064 = (state_43020__$1[(2)]);
var statearr_43069_43127 = state_43020__$1;
(statearr_43069_43127[(5)] = ex43064);


var statearr_43070_43128 = state_43020__$1;
(statearr_43070_43128[(1)] = (4));

(statearr_43070_43128[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (14))){
var inst_42930 = (state_43020[(7)]);
var state_43020__$1 = state_43020;
var statearr_43071_43129 = state_43020__$1;
(statearr_43071_43129[(2)] = inst_42930);

(statearr_43071_43129[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (26))){
var state_43020__$1 = state_43020;
var statearr_43072_43130 = state_43020__$1;
(statearr_43072_43130[(2)] = null);

(statearr_43072_43130[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (16))){
var inst_42939 = cljs.core.first(ident);
var inst_42940 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_42939], 0));
var inst_42941 = ["Subject ID lookup failed. The predicate ",inst_42940," does not exist."].join('');
var inst_42942 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_42943 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_ident];
var inst_42944 = cljs.core.PersistentHashMap.fromArrays(inst_42942,inst_42943);
var inst_42945 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_42941,inst_42944);
var inst_42946 = (function(){throw inst_42945})();
var state_43020__$1 = state_43020;
var statearr_43073_43131 = state_43020__$1;
(statearr_43073_43131[(2)] = inst_42946);

(statearr_43073_43131[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (38))){
var inst_43000 = ["Subject identity does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ident)].join('');
var inst_43001 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_43002 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_subject];
var inst_43003 = cljs.core.PersistentHashMap.fromArrays(inst_43001,inst_43002);
var inst_43004 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_43000,inst_43003);
var inst_43005 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_chan,inst_43004);
var state_43020__$1 = state_43020;
var statearr_43074_43132 = state_43020__$1;
(statearr_43074_43132[(2)] = inst_43005);

(statearr_43074_43132[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (30))){
var state_43020__$1 = state_43020;
var statearr_43075_43133 = state_43020__$1;
(statearr_43075_43133[(2)] = null);

(statearr_43075_43133[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (10))){
var state_43020__$1 = state_43020;
var statearr_43076_43134 = state_43020__$1;
(statearr_43076_43134[(2)] = ident);

(statearr_43076_43134[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (18))){
var inst_42988 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
var statearr_43077_43135 = state_43020__$1;
(statearr_43077_43135[(2)] = inst_42988);

(statearr_43077_43135[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (42))){
var state_43020__$1 = state_43020;
var statearr_43078_43136 = state_43020__$1;
(statearr_43078_43136[(2)] = null);

(statearr_43078_43136[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (37))){
var inst_42998 = (state_43020[(2)]);
var state_43020__$1 = state_43020;
if(cljs.core.truth_(inst_42998)){
var statearr_43079_43137 = state_43020__$1;
(statearr_43079_43137[(1)] = (38));

} else {
var statearr_43080_43138 = state_43020__$1;
(statearr_43080_43138[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43021 === (8))){
var inst_42990 = (state_43020[(10)]);
var inst_42990__$1 = (state_43020[(2)]);
var state_43020__$1 = (function (){var statearr_43081 = state_43020;
(statearr_43081[(10)] = inst_42990__$1);

return statearr_43081;
})();
if(cljs.core.truth_(inst_42990__$1)){
var statearr_43082_43139 = state_43020__$1;
(statearr_43082_43139[(1)] = (32));

} else {
var statearr_43083_43140 = state_43020__$1;
(statearr_43083_43140[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$subid_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$subid_$_state_machine__16395__auto____0 = (function (){
var statearr_43084 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_43084[(0)] = fluree$db$graphdb$subid_$_state_machine__16395__auto__);

(statearr_43084[(1)] = (1));

return statearr_43084;
});
var fluree$db$graphdb$subid_$_state_machine__16395__auto____1 = (function (state_43020){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43020);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43085){var ex__16398__auto__ = e43085;
var statearr_43086_43141 = state_43020;
(statearr_43086_43141[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43020[(4)]))){
var statearr_43087_43142 = state_43020;
(statearr_43087_43142[(1)] = cljs.core.first((state_43020[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43143 = state_43020;
state_43020 = G__43143;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$subid_$_state_machine__16395__auto__ = function(state_43020){
switch(arguments.length){
case 0:
return fluree$db$graphdb$subid_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$subid_$_state_machine__16395__auto____1.call(this,state_43020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$subid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$subid_$_state_machine__16395__auto____0;
fluree$db$graphdb$subid_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$subid_$_state_machine__16395__auto____1;
return fluree$db$graphdb$subid_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43088 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43088[(6)] = c__16469__auto___43089);

return statearr_43088;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_chan;
});
fluree.db.graphdb.graphdb_latest_db = (function fluree$db$graphdb$graphdb_latest_db(p__43144){
var map__43145 = p__43144;
var map__43145__$1 = cljs.core.__destructure_map(map__43145);
var current_db_fn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43145__$1,cljs.core.cst$kw$current_DASH_db_DASH_fn);
var permissions = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43145__$1,cljs.core.cst$kw$permissions);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43161){
var state_val_43162 = (state_43161[(1)]);
if((state_val_43162 === (1))){
var state_43161__$1 = state_43161;
var statearr_43163_43177 = state_43161__$1;
(statearr_43163_43177[(2)] = null);

(statearr_43163_43177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43162 === (2))){
var _ = (function (){var statearr_43164 = state_43161;
(statearr_43164[(4)] = cljs.core.cons((5),(state_43161[(4)])));

return statearr_43164;
})();
var inst_43152 = (current_db_fn.cljs$core$IFn$_invoke$arity$0 ? current_db_fn.cljs$core$IFn$_invoke$arity$0() : current_db_fn.call(null));
var state_43161__$1 = state_43161;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43161__$1,(6),inst_43152);
} else {
if((state_val_43162 === (3))){
var inst_43159 = (state_43161[(2)]);
var state_43161__$1 = state_43161;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43161__$1,inst_43159);
} else {
if((state_val_43162 === (4))){
var inst_43146 = (state_43161[(2)]);
var state_43161__$1 = state_43161;
var statearr_43166_43178 = state_43161__$1;
(statearr_43166_43178[(2)] = inst_43146);

(statearr_43166_43178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43162 === (5))){
var _ = (function (){var statearr_43167 = state_43161;
(statearr_43167[(4)] = cljs.core.rest((state_43161[(4)])));

return statearr_43167;
})();
var state_43161__$1 = state_43161;
var ex43165 = (state_43161__$1[(2)]);
var statearr_43168_43179 = state_43161__$1;
(statearr_43168_43179[(5)] = ex43165);


if((ex43165 instanceof Error)){
var statearr_43169_43180 = state_43161__$1;
(statearr_43169_43180[(1)] = (4));

(statearr_43169_43180[(5)] = null);

} else {
throw ex43165;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43162 === (6))){
var inst_43154 = (state_43161[(2)]);
var inst_43155 = fluree.db.util.async.throw_err(inst_43154);
var inst_43156 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_43155,cljs.core.cst$kw$permissions,permissions);
var _ = (function (){var statearr_43170 = state_43161;
(statearr_43170[(4)] = cljs.core.rest((state_43161[(4)])));

return statearr_43170;
})();
var state_43161__$1 = state_43161;
var statearr_43171_43181 = state_43161__$1;
(statearr_43171_43181[(2)] = inst_43156);

(statearr_43171_43181[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__ = null;
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0 = (function (){
var statearr_43172 = [null,null,null,null,null,null,null];
(statearr_43172[(0)] = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__);

(statearr_43172[(1)] = (1));

return statearr_43172;
});
var fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1 = (function (state_43161){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43161);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43173){var ex__16398__auto__ = e43173;
var statearr_43174_43182 = state_43161;
(statearr_43174_43182[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43161[(4)]))){
var statearr_43175_43183 = state_43161;
(statearr_43175_43183[(1)] = cljs.core.first((state_43161[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43184 = state_43161;
state_43161 = G__43184;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__ = function(state_43161){
switch(arguments.length){
case 0:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1.call(this,state_43161);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____0;
fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto____1;
return fluree$db$graphdb$graphdb_latest_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43176 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43176[(6)] = c__16469__auto__);

return statearr_43176;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.graphdb.graphdb_root_db = (function fluree$db$graphdb$graphdb_root_db(this$){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(this$,cljs.core.cst$kw$permissions,new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$root_QMARK_,true,cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null)], null));
});
fluree.db.graphdb.graphdb_c_prop = (function fluree$db$graphdb$graphdb_c_prop(p__43185,property,collection){
var map__43186 = p__43185;
var map__43186__$1 = cljs.core.__destructure_map(map__43186);
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43186__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__43187 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$name,null,cljs.core.cst$kw$partition,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$sid,null], null), null);
return (fexpr__43187.cljs$core$IFn$_invoke$arity$1 ? fexpr__43187.cljs$core$IFn$_invoke$arity$1(property) : fexpr__43187.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid collection property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:name :partition :spec :id :specDoc :sid} property)"].join('')));
}

if(cljs.core.neg_int_QMARK_(collection)){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,"_tx",property], null));
} else {
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$coll,collection,property], null));
}
});
fluree.db.graphdb.graphdb_p_prop = (function fluree$db$graphdb$graphdb_p_prop(p__43188,property,predicate){
var map__43189 = p__43188;
var map__43189__$1 = cljs.core.__destructure_map(map__43189);
var this$ = map__43189__$1;
var schema = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__43189__$1,cljs.core.cst$kw$schema);
if(cljs.core.truth_((function (){var fexpr__43190 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 18, [cljs.core.cst$kw$unique,null,cljs.core.cst$kw$restrictCollection,null,cljs.core.cst$kw$index,null,cljs.core.cst$kw$name,null,cljs.core.cst$kw$noHistory,null,cljs.core.cst$kw$type,null,cljs.core.cst$kw$txSpec,null,cljs.core.cst$kw$component,null,cljs.core.cst$kw$txSpecDoc,null,cljs.core.cst$kw$spec,null,cljs.core.cst$kw$multi,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$specDoc,null,cljs.core.cst$kw$idx_QMARK_,null,cljs.core.cst$kw$ref_QMARK_,null,cljs.core.cst$kw$upsert,null,cljs.core.cst$kw$retractDuplicates,null,cljs.core.cst$kw$restrictTag,null], null), null);
return (fexpr__43190.cljs$core$IFn$_invoke$arity$1 ? fexpr__43190.cljs$core$IFn$_invoke$arity$1(property) : fexpr__43190.call(null,property));
})())){
} else {
throw (new Error(["Assert failed: ",["Invalid predicate property: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([property], 0))].join(''),"\n","(#{:unique :restrictCollection :index :name :noHistory :type :txSpec :component :txSpecDoc :spec :multi :id :specDoc :idx? :ref? :upsert :retractDuplicates :restrictTag} property)"].join('')));
}

var G__43191 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(schema,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$pred,predicate,property], null));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$restrictCollection,property)){
return fluree.db.dbproto._c_prop(this$,cljs.core.cst$kw$partition,G__43191);
} else {
return G__43191;
}
});
/**
 * Lookup the predicate name if needed; return ::no-pred if pred arg is nil so
 *   we can differentiate between that and (dbproto/-p-prop ...) returning nil
 */
fluree.db.graphdb.graphdb_pred_name = (function fluree$db$graphdb$graphdb_pred_name(this$,pred){
if((pred == null)){
return cljs.core.cst$kw$fluree$db$graphdb_SLASH_no_DASH_pred;
} else {
if(typeof pred === 'string'){
return pred;
} else {
return fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);

}
}
});
/**
 * resolves a tags's value given a tag subject id; optionally shortening the
 *   return value if it starts with the given predicate name
 */
fluree.db.graphdb.graphdb_tag = (function fluree$db$graphdb$graphdb_tag(var_args){
var G__43193 = arguments.length;
switch (G__43193) {
case 2:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_id){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43225){
var state_val_43226 = (state_43225[(1)]);
if((state_val_43226 === (7))){
var state_43225__$1 = state_43225;
var statearr_43227_43321 = state_43225__$1;
(statearr_43227_43321[(2)] = null);

(statearr_43227_43321[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (1))){
var state_43225__$1 = state_43225;
var statearr_43228_43322 = state_43225__$1;
(statearr_43228_43322[(2)] = null);

(statearr_43228_43322[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (4))){
var inst_43194 = (state_43225[(2)]);
var state_43225__$1 = state_43225;
var statearr_43229_43323 = state_43225__$1;
(statearr_43229_43323[(2)] = inst_43194);

(statearr_43229_43323[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (6))){
var inst_43208 = (state_43225[(7)]);
var inst_43207 = (state_43225[(2)]);
var inst_43208__$1 = fluree.db.util.async.throw_err(inst_43207);
var inst_43209 = (inst_43208__$1 == null);
var state_43225__$1 = (function (){var statearr_43230 = state_43225;
(statearr_43230[(7)] = inst_43208__$1);

return statearr_43230;
})();
if(cljs.core.truth_(inst_43209)){
var statearr_43231_43324 = state_43225__$1;
(statearr_43231_43324[(1)] = (7));

} else {
var statearr_43232_43325 = state_43225__$1;
(statearr_43232_43325[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (3))){
var inst_43223 = (state_43225[(2)]);
var state_43225__$1 = state_43225;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43225__$1,inst_43223);
} else {
if((state_val_43226 === (12))){
var inst_43220 = (state_43225[(2)]);
var _ = (function (){var statearr_43233 = state_43225;
(statearr_43233[(4)] = cljs.core.rest((state_43225[(4)])));

return statearr_43233;
})();
var state_43225__$1 = state_43225;
var statearr_43234_43326 = state_43225__$1;
(statearr_43234_43326[(2)] = inst_43220);

(statearr_43234_43326[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (2))){
var _ = (function (){var statearr_43235 = state_43225;
(statearr_43235[(4)] = cljs.core.cons((5),(state_43225[(4)])));

return statearr_43235;
})();
var inst_43201 = fluree.db.dbproto._rootdb(this$);
var inst_43202 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43203 = [tag_id,(30)];
var inst_43204 = (new cljs.core.PersistentVector(null,2,(5),inst_43202,inst_43203,null));
var inst_43205 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_43201,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_43204);
var state_43225__$1 = state_43225;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43225__$1,(6),inst_43205);
} else {
if((state_val_43226 === (11))){
var inst_43214 = (state_43225[(8)]);
var inst_43218 = inst_43214.o;
var state_43225__$1 = state_43225;
var statearr_43237_43327 = state_43225__$1;
(statearr_43237_43327[(2)] = inst_43218);

(statearr_43237_43327[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (9))){
var inst_43214 = (state_43225[(8)]);
var inst_43214__$1 = (state_43225[(2)]);
var inst_43215 = (inst_43214__$1 == null);
var state_43225__$1 = (function (){var statearr_43238 = state_43225;
(statearr_43238[(8)] = inst_43214__$1);

return statearr_43238;
})();
if(cljs.core.truth_(inst_43215)){
var statearr_43239_43328 = state_43225__$1;
(statearr_43239_43328[(1)] = (10));

} else {
var statearr_43240_43329 = state_43225__$1;
(statearr_43240_43329[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (5))){
var _ = (function (){var statearr_43241 = state_43225;
(statearr_43241[(4)] = cljs.core.rest((state_43225[(4)])));

return statearr_43241;
})();
var state_43225__$1 = state_43225;
var ex43236 = (state_43225__$1[(2)]);
var statearr_43242_43330 = state_43225__$1;
(statearr_43242_43330[(5)] = ex43236);


if((ex43236 instanceof Error)){
var statearr_43243_43331 = state_43225__$1;
(statearr_43243_43331[(1)] = (4));

(statearr_43243_43331[(5)] = null);

} else {
throw ex43236;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (10))){
var state_43225__$1 = state_43225;
var statearr_43244_43332 = state_43225__$1;
(statearr_43244_43332[(2)] = null);

(statearr_43244_43332[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43226 === (8))){
var inst_43208 = (state_43225[(7)]);
var inst_43212 = cljs.core.first(inst_43208);
var state_43225__$1 = state_43225;
var statearr_43245_43333 = state_43225__$1;
(statearr_43245_43333[(2)] = inst_43212);

(statearr_43245_43333[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43246 = [null,null,null,null,null,null,null,null,null];
(statearr_43246[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43246[(1)] = (1));

return statearr_43246;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43225){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43225);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43247){var ex__16398__auto__ = e43247;
var statearr_43248_43334 = state_43225;
(statearr_43248_43334[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43225[(4)]))){
var statearr_43249_43335 = state_43225;
(statearr_43249_43335[(1)] = cljs.core.first((state_43225[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43336 = state_43225;
state_43225 = G__43336;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43225){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43225);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43250 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43250[(6)] = c__16469__auto__);

return statearr_43250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_id,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43286){
var state_val_43287 = (state_43286[(1)]);
if((state_val_43287 === (7))){
var inst_43260 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_43286__$1 = state_43286;
var statearr_43288_43337 = state_43286__$1;
(statearr_43288_43337[(2)] = inst_43260);

(statearr_43288_43337[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (1))){
var state_43286__$1 = state_43286;
var statearr_43289_43338 = state_43286__$1;
(statearr_43289_43338[(2)] = null);

(statearr_43289_43338[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (4))){
var inst_43251 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
var statearr_43290_43339 = state_43286__$1;
(statearr_43290_43339[(2)] = inst_43251);

(statearr_43290_43339[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (15))){
var inst_43281 = (state_43286[(2)]);
var _ = (function (){var statearr_43291 = state_43286;
(statearr_43291[(4)] = cljs.core.rest((state_43286[(4)])));

return statearr_43291;
})();
var state_43286__$1 = state_43286;
var statearr_43292_43340 = state_43286__$1;
(statearr_43292_43340[(2)] = inst_43281);

(statearr_43292_43340[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (13))){
var inst_43266 = (state_43286[(7)]);
var inst_43272 = clojure.string.includes_QMARK_(inst_43266,":");
var state_43286__$1 = state_43286;
if(inst_43272){
var statearr_43293_43341 = state_43286__$1;
(statearr_43293_43341[(1)] = (16));

} else {
var statearr_43294_43342 = state_43286__$1;
(statearr_43294_43342[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (6))){
var state_43286__$1 = state_43286;
var statearr_43295_43343 = state_43286__$1;
(statearr_43295_43343[(2)] = pred);

(statearr_43295_43343[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (17))){
var inst_43266 = (state_43286[(7)]);
var state_43286__$1 = state_43286;
var statearr_43296_43344 = state_43286__$1;
(statearr_43296_43344[(2)] = inst_43266);

(statearr_43296_43344[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (3))){
var inst_43284 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43286__$1,inst_43284);
} else {
if((state_val_43287 === (12))){
var inst_43270 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
if(cljs.core.truth_(inst_43270)){
var statearr_43297_43345 = state_43286__$1;
(statearr_43297_43345[(1)] = (13));

} else {
var statearr_43298_43346 = state_43286__$1;
(statearr_43298_43346[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (2))){
var _ = (function (){var statearr_43299 = state_43286;
(statearr_43299[(4)] = cljs.core.cons((5),(state_43286[(4)])));

return statearr_43299;
})();
var inst_43257 = typeof pred === 'string';
var state_43286__$1 = state_43286;
if(cljs.core.truth_(inst_43257)){
var statearr_43300_43347 = state_43286__$1;
(statearr_43300_43347[(1)] = (6));

} else {
var statearr_43301_43348 = state_43286__$1;
(statearr_43301_43348[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (11))){
var inst_43262 = (state_43286[(8)]);
var state_43286__$1 = state_43286;
var statearr_43303_43349 = state_43286__$1;
(statearr_43303_43349[(2)] = inst_43262);

(statearr_43303_43349[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (9))){
var inst_43262 = (state_43286[(8)]);
var inst_43265 = (state_43286[(2)]);
var inst_43266 = fluree.db.util.async.throw_err(inst_43265);
var state_43286__$1 = (function (){var statearr_43304 = state_43286;
(statearr_43304[(7)] = inst_43266);

return statearr_43304;
})();
if(cljs.core.truth_(inst_43262)){
var statearr_43305_43350 = state_43286__$1;
(statearr_43305_43350[(1)] = (10));

} else {
var statearr_43306_43351 = state_43286__$1;
(statearr_43306_43351[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (5))){
var _ = (function (){var statearr_43307 = state_43286;
(statearr_43307[(4)] = cljs.core.rest((state_43286[(4)])));

return statearr_43307;
})();
var state_43286__$1 = state_43286;
var ex43302 = (state_43286__$1[(2)]);
var statearr_43308_43352 = state_43286__$1;
(statearr_43308_43352[(5)] = ex43302);


if((ex43302 instanceof Error)){
var statearr_43309_43353 = state_43286__$1;
(statearr_43309_43353[(1)] = (4));

(statearr_43309_43353[(5)] = null);

} else {
throw ex43302;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (14))){
var state_43286__$1 = state_43286;
var statearr_43310_43354 = state_43286__$1;
(statearr_43310_43354[(2)] = null);

(statearr_43310_43354[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (16))){
var inst_43266 = (state_43286[(7)]);
var inst_43274 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(inst_43266,/:/);
var inst_43275 = cljs.core.second(inst_43274);
var state_43286__$1 = state_43286;
var statearr_43311_43355 = state_43286__$1;
(statearr_43311_43355[(2)] = inst_43275);

(statearr_43311_43355[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (10))){
var inst_43266 = (state_43286[(7)]);
var state_43286__$1 = state_43286;
var statearr_43312_43356 = state_43286__$1;
(statearr_43312_43356[(2)] = inst_43266);

(statearr_43312_43356[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (18))){
var inst_43278 = (state_43286[(2)]);
var state_43286__$1 = state_43286;
var statearr_43313_43357 = state_43286__$1;
(statearr_43313_43357[(2)] = inst_43278);

(statearr_43313_43357[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43287 === (8))){
var inst_43262 = (state_43286[(2)]);
var inst_43263 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$2(this$,tag_id);
var state_43286__$1 = (function (){var statearr_43314 = state_43286;
(statearr_43314[(8)] = inst_43262);

return statearr_43314;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43286__$1,(9),inst_43263);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43315 = [null,null,null,null,null,null,null,null,null];
(statearr_43315[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43315[(1)] = (1));

return statearr_43315;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43286){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43286);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43316){var ex__16398__auto__ = e43316;
var statearr_43317_43358 = state_43286;
(statearr_43317_43358[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43286[(4)]))){
var statearr_43318_43359 = state_43286;
(statearr_43318_43359[(1)] = cljs.core.first((state_43286[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43360 = state_43286;
state_43286 = G__43360;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43286){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43286);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43319 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43319[(6)] = c__16469__auto__);

return statearr_43319;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag.cljs$lang$maxFixedArity = 3);

fluree.db.graphdb.graphdb_tag_id = (function fluree$db$graphdb$graphdb_tag_id(var_args){
var G__43362 = arguments.length;
switch (G__43362) {
case 2:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2 = (function (this$,tag_name){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43395){
var state_val_43396 = (state_43395[(1)]);
if((state_val_43396 === (7))){
var state_43395__$1 = state_43395;
var statearr_43397_43485 = state_43395__$1;
(statearr_43397_43485[(2)] = null);

(statearr_43397_43485[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (1))){
var state_43395__$1 = state_43395;
var statearr_43398_43486 = state_43395__$1;
(statearr_43398_43486[(2)] = null);

(statearr_43398_43486[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (4))){
var inst_43363 = (state_43395[(2)]);
var state_43395__$1 = state_43395;
var statearr_43399_43487 = state_43395__$1;
(statearr_43399_43487[(2)] = inst_43363);

(statearr_43399_43487[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (6))){
var inst_43378 = (state_43395[(7)]);
var inst_43377 = (state_43395[(2)]);
var inst_43378__$1 = fluree.db.util.async.throw_err(inst_43377);
var inst_43379 = (inst_43378__$1 == null);
var state_43395__$1 = (function (){var statearr_43400 = state_43395;
(statearr_43400[(7)] = inst_43378__$1);

return statearr_43400;
})();
if(cljs.core.truth_(inst_43379)){
var statearr_43401_43488 = state_43395__$1;
(statearr_43401_43488[(1)] = (7));

} else {
var statearr_43402_43489 = state_43395__$1;
(statearr_43402_43489[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (3))){
var inst_43393 = (state_43395[(2)]);
var state_43395__$1 = state_43395;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43395__$1,inst_43393);
} else {
if((state_val_43396 === (12))){
var inst_43390 = (state_43395[(2)]);
var _ = (function (){var statearr_43403 = state_43395;
(statearr_43403[(4)] = cljs.core.rest((state_43395[(4)])));

return statearr_43403;
})();
var state_43395__$1 = state_43395;
var statearr_43404_43490 = state_43395__$1;
(statearr_43404_43490[(2)] = inst_43390);

(statearr_43404_43490[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (2))){
var _ = (function (){var statearr_43405 = state_43395;
(statearr_43405[(4)] = cljs.core.cons((5),(state_43395[(4)])));

return statearr_43405;
})();
var inst_43369 = (30);
var inst_43371 = fluree.db.dbproto._rootdb(this$);
var inst_43372 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_43373 = [inst_43369,tag_name];
var inst_43374 = (new cljs.core.PersistentVector(null,2,(5),inst_43372,inst_43373,null));
var inst_43375 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(inst_43371,cljs.core.cst$kw$post,cljs.core._EQ_,inst_43374);
var state_43395__$1 = state_43395;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43395__$1,(6),inst_43375);
} else {
if((state_val_43396 === (11))){
var inst_43384 = (state_43395[(8)]);
var inst_43388 = inst_43384.s;
var state_43395__$1 = state_43395;
var statearr_43407_43491 = state_43395__$1;
(statearr_43407_43491[(2)] = inst_43388);

(statearr_43407_43491[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (9))){
var inst_43384 = (state_43395[(8)]);
var inst_43384__$1 = (state_43395[(2)]);
var inst_43385 = (inst_43384__$1 == null);
var state_43395__$1 = (function (){var statearr_43408 = state_43395;
(statearr_43408[(8)] = inst_43384__$1);

return statearr_43408;
})();
if(cljs.core.truth_(inst_43385)){
var statearr_43409_43492 = state_43395__$1;
(statearr_43409_43492[(1)] = (10));

} else {
var statearr_43410_43493 = state_43395__$1;
(statearr_43410_43493[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (5))){
var _ = (function (){var statearr_43411 = state_43395;
(statearr_43411[(4)] = cljs.core.rest((state_43395[(4)])));

return statearr_43411;
})();
var state_43395__$1 = state_43395;
var ex43406 = (state_43395__$1[(2)]);
var statearr_43412_43494 = state_43395__$1;
(statearr_43412_43494[(5)] = ex43406);


if((ex43406 instanceof Error)){
var statearr_43413_43495 = state_43395__$1;
(statearr_43413_43495[(1)] = (4));

(statearr_43413_43495[(5)] = null);

} else {
throw ex43406;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (10))){
var state_43395__$1 = state_43395;
var statearr_43414_43496 = state_43395__$1;
(statearr_43414_43496[(2)] = null);

(statearr_43414_43496[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43396 === (8))){
var inst_43378 = (state_43395[(7)]);
var inst_43382 = cljs.core.first(inst_43378);
var state_43395__$1 = state_43395;
var statearr_43415_43497 = state_43395__$1;
(statearr_43415_43497[(2)] = inst_43382);

(statearr_43415_43497[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43416 = [null,null,null,null,null,null,null,null,null];
(statearr_43416[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43416[(1)] = (1));

return statearr_43416;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43395){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43395);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43417){var ex__16398__auto__ = e43417;
var statearr_43418_43498 = state_43395;
(statearr_43418_43498[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43395[(4)]))){
var statearr_43419_43499 = state_43395;
(statearr_43419_43499[(1)] = cljs.core.first((state_43395[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43500 = state_43395;
state_43395 = G__43500;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43395){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43395);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43420 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43420[(6)] = c__16469__auto__);

return statearr_43420;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3 = (function (this$,tag_name,pred){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_43455){
var state_val_43456 = (state_43455[(1)]);
if((state_val_43456 === (7))){
var inst_43434 = typeof pred === 'string';
var state_43455__$1 = state_43455;
if(cljs.core.truth_(inst_43434)){
var statearr_43457_43501 = state_43455__$1;
(statearr_43457_43501[(1)] = (10));

} else {
var statearr_43458_43502 = state_43455__$1;
(statearr_43458_43502[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (1))){
var state_43455__$1 = state_43455;
var statearr_43459_43503 = state_43455__$1;
(statearr_43459_43503[(2)] = null);

(statearr_43459_43503[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (4))){
var inst_43421 = (state_43455[(2)]);
var state_43455__$1 = state_43455;
var statearr_43460_43504 = state_43455__$1;
(statearr_43460_43504[(2)] = inst_43421);

(statearr_43460_43504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (15))){
var inst_43448 = (state_43455[(2)]);
var state_43455__$1 = state_43455;
var statearr_43461_43505 = state_43455__$1;
(statearr_43461_43505[(2)] = inst_43448);

(statearr_43461_43505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (13))){
var inst_43439 = (state_43455[(7)]);
var inst_43441 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_43439),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(tag_name)].join('');
var inst_43442 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,inst_43441);
var state_43455__$1 = state_43455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43455__$1,(16),inst_43442);
} else {
if((state_val_43456 === (6))){
var inst_43429 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(this$,tag_name);
var state_43455__$1 = state_43455;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_43455__$1,(9),inst_43429);
} else {
if((state_val_43456 === (3))){
var inst_43453 = (state_43455[(2)]);
var state_43455__$1 = state_43455;
return cljs.core.async.impl.ioc_helpers.return_chan(state_43455__$1,inst_43453);
} else {
if((state_val_43456 === (12))){
var inst_43439 = (state_43455[(7)]);
var inst_43439__$1 = (state_43455[(2)]);
var state_43455__$1 = (function (){var statearr_43462 = state_43455;
(statearr_43462[(7)] = inst_43439__$1);

return statearr_43462;
})();
if(cljs.core.truth_(inst_43439__$1)){
var statearr_43463_43506 = state_43455__$1;
(statearr_43463_43506[(1)] = (13));

} else {
var statearr_43464_43507 = state_43455__$1;
(statearr_43464_43507[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (2))){
var _ = (function (){var statearr_43465 = state_43455;
(statearr_43465[(4)] = cljs.core.cons((5),(state_43455[(4)])));

return statearr_43465;
})();
var inst_43427 = clojure.string.includes_QMARK_(tag_name,"/");
var state_43455__$1 = state_43455;
if(inst_43427){
var statearr_43466_43508 = state_43455__$1;
(statearr_43466_43508[(1)] = (6));

} else {
var statearr_43467_43509 = state_43455__$1;
(statearr_43467_43509[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (11))){
var inst_43437 = fluree.db.dbproto._p_prop(this$,cljs.core.cst$kw$name,pred);
var state_43455__$1 = state_43455;
var statearr_43469_43510 = state_43455__$1;
(statearr_43469_43510[(2)] = inst_43437);

(statearr_43469_43510[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (9))){
var inst_43431 = (state_43455[(2)]);
var inst_43432 = fluree.db.util.async.throw_err(inst_43431);
var state_43455__$1 = state_43455;
var statearr_43470_43511 = state_43455__$1;
(statearr_43470_43511[(2)] = inst_43432);

(statearr_43470_43511[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (5))){
var _ = (function (){var statearr_43471 = state_43455;
(statearr_43471[(4)] = cljs.core.rest((state_43455[(4)])));

return statearr_43471;
})();
var state_43455__$1 = state_43455;
var ex43468 = (state_43455__$1[(2)]);
var statearr_43472_43512 = state_43455__$1;
(statearr_43472_43512[(5)] = ex43468);


if((ex43468 instanceof Error)){
var statearr_43473_43513 = state_43455__$1;
(statearr_43473_43513[(1)] = (4));

(statearr_43473_43513[(5)] = null);

} else {
throw ex43468;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (14))){
var state_43455__$1 = state_43455;
var statearr_43474_43514 = state_43455__$1;
(statearr_43474_43514[(2)] = null);

(statearr_43474_43514[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (16))){
var inst_43444 = (state_43455[(2)]);
var inst_43445 = fluree.db.util.async.throw_err(inst_43444);
var state_43455__$1 = state_43455;
var statearr_43475_43515 = state_43455__$1;
(statearr_43475_43515[(2)] = inst_43445);

(statearr_43475_43515[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (10))){
var state_43455__$1 = state_43455;
var statearr_43476_43516 = state_43455__$1;
(statearr_43476_43516[(2)] = pred);

(statearr_43476_43516[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_43456 === (8))){
var inst_43450 = (state_43455[(2)]);
var _ = (function (){var statearr_43477 = state_43455;
(statearr_43477[(4)] = cljs.core.rest((state_43455[(4)])));

return statearr_43477;
})();
var state_43455__$1 = state_43455;
var statearr_43478_43517 = state_43455__$1;
(statearr_43478_43517[(2)] = inst_43450);

(statearr_43478_43517[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$graphdb$state_machine__16395__auto__ = null;
var fluree$db$graphdb$state_machine__16395__auto____0 = (function (){
var statearr_43479 = [null,null,null,null,null,null,null,null];
(statearr_43479[(0)] = fluree$db$graphdb$state_machine__16395__auto__);

(statearr_43479[(1)] = (1));

return statearr_43479;
});
var fluree$db$graphdb$state_machine__16395__auto____1 = (function (state_43455){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_43455);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e43480){var ex__16398__auto__ = e43480;
var statearr_43481_43518 = state_43455;
(statearr_43481_43518[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_43455[(4)]))){
var statearr_43482_43519 = state_43455;
(statearr_43482_43519[(1)] = cljs.core.first((state_43455[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__43520 = state_43455;
state_43455 = G__43520;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$graphdb$state_machine__16395__auto__ = function(state_43455){
switch(arguments.length){
case 0:
return fluree$db$graphdb$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$graphdb$state_machine__16395__auto____1.call(this,state_43455);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$graphdb$state_machine__16395__auto____0;
fluree$db$graphdb$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$graphdb$state_machine__16395__auto____1;
return fluree$db$graphdb$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_43483 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_43483[(6)] = c__16469__auto__);

return statearr_43483;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.graphdb.graphdb_tag_id.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {fluree.db.dbproto.IFlureeDb}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.graphdb.GraphDb = (function (conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,__meta,__extmap,__hash){
this.conn = conn;
this.network = network;
this.dbid = dbid;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.stats = stats;
this.spot = spot;
this.psot = psot;
this.post = post;
this.opst = opst;
this.schema = schema;
this.settings = settings;
this.index_configs = index_configs;
this.schema_cache = schema_cache;
this.novelty = novelty;
this.permissions = permissions;
this.fork = fork;
this.fork_block = fork_block;
this.current_db_fn = current_db_fn;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k43522,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__43526 = k43522;
var G__43526__$1 = (((G__43526 instanceof cljs.core.Keyword))?G__43526.fqn:null);
switch (G__43526__$1) {
case "conn":
return self__.conn;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "stats":
return self__.stats;

break;
case "spot":
return self__.spot;

break;
case "psot":
return self__.psot;

break;
case "post":
return self__.post;

break;
case "opst":
return self__.opst;

break;
case "schema":
return self__.schema;

break;
case "settings":
return self__.settings;

break;
case "index-configs":
return self__.index_configs;

break;
case "schema-cache":
return self__.schema_cache;

break;
case "novelty":
return self__.novelty;

break;
case "permissions":
return self__.permissions;

break;
case "fork":
return self__.fork;

break;
case "fork-block":
return self__.fork_block;

break;
case "current-db-fn":
return self__.current_db_fn;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k43522,else__4464__auto__);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__43527){
var vec__43528 = p__43527;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43528,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43528,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.graphdb.GraphDb{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$stats,self__.stats],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$spot,self__.spot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$psot,self__.psot],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$post,self__.post],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$opst,self__.opst],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema,self__.schema],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$settings,self__.settings],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$index_DASH_configs,self__.index_configs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$novelty,self__.novelty],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$permissions,self__.permissions],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork,self__.fork],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$fork_DASH_block,self__.fork_block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn],null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__43521){
var self__ = this;
var G__43521__$1 = this;
return (new cljs.core.RecordIter((0),G__43521__$1,20,new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (20 + cljs.core.count(self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__43531 = (function (coll__4458__auto__){
return (485580545 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__43531(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this43523,other43524){
var self__ = this;
var this43523__$1 = this;
return (((!((other43524 == null)))) && ((((this43523__$1.constructor === other43524.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.conn,other43524.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.network,other43524.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.dbid,other43524.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.block,other43524.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.t,other43524.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.tt_id,other43524.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.stats,other43524.stats)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.spot,other43524.spot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.psot,other43524.psot)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.post,other43524.post)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.opst,other43524.opst)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.schema,other43524.schema)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.settings,other43524.settings)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.index_configs,other43524.index_configs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.schema_cache,other43524.schema_cache)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.novelty,other43524.novelty)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.permissions,other43524.permissions)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.fork,other43524.fork)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.fork_block,other43524.fork_block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.current_db_fn,other43524.current_db_fn)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this43523__$1.__extmap,other43524.__extmap)))))))))))))))))))))))))))))))))))))))))))));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 20, [cljs.core.cst$kw$current_DASH_db_DASH_fn,null,cljs.core.cst$kw$schema,null,cljs.core.cst$kw$block,null,cljs.core.cst$kw$psot,null,cljs.core.cst$kw$permissions,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$settings,null,cljs.core.cst$kw$index_DASH_configs,null,cljs.core.cst$kw$opst,null,cljs.core.cst$kw$fork_DASH_block,null,cljs.core.cst$kw$schema_DASH_cache,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$novelty,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$fork,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$stats,null,cljs.core.cst$kw$spot,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k43522){
var self__ = this;
var this__4468__auto____$1 = this;
var G__43532 = k43522;
var G__43532__$1 = (((G__43532 instanceof cljs.core.Keyword))?G__43532.fqn:null);
switch (G__43532__$1) {
case "conn":
case "network":
case "dbid":
case "block":
case "t":
case "tt-id":
case "stats":
case "spot":
case "psot":
case "post":
case "opst":
case "schema":
case "settings":
case "index-configs":
case "schema-cache":
case "novelty":
case "permissions":
case "fork":
case "fork-block":
case "current-db-fn":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k43522);

}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__43521){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__43533 = cljs.core.keyword_identical_QMARK_;
var expr__43534 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__43536 = cljs.core.cst$kw$conn;
var G__43537 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43536,G__43537) : pred__43533.call(null,G__43536,G__43537));
})())){
return (new fluree.db.graphdb.GraphDb(G__43521,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43538 = cljs.core.cst$kw$network;
var G__43539 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43538,G__43539) : pred__43533.call(null,G__43538,G__43539));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,G__43521,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43540 = cljs.core.cst$kw$dbid;
var G__43541 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43540,G__43541) : pred__43533.call(null,G__43540,G__43541));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,G__43521,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43542 = cljs.core.cst$kw$block;
var G__43543 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43542,G__43543) : pred__43533.call(null,G__43542,G__43543));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,G__43521,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43544 = cljs.core.cst$kw$t;
var G__43545 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43544,G__43545) : pred__43533.call(null,G__43544,G__43545));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,G__43521,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43546 = cljs.core.cst$kw$tt_DASH_id;
var G__43547 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43546,G__43547) : pred__43533.call(null,G__43546,G__43547));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,G__43521,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43548 = cljs.core.cst$kw$stats;
var G__43549 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43548,G__43549) : pred__43533.call(null,G__43548,G__43549));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,G__43521,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43550 = cljs.core.cst$kw$spot;
var G__43551 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43550,G__43551) : pred__43533.call(null,G__43550,G__43551));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,G__43521,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43552 = cljs.core.cst$kw$psot;
var G__43553 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43552,G__43553) : pred__43533.call(null,G__43552,G__43553));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,G__43521,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43554 = cljs.core.cst$kw$post;
var G__43555 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43554,G__43555) : pred__43533.call(null,G__43554,G__43555));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,G__43521,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43556 = cljs.core.cst$kw$opst;
var G__43557 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43556,G__43557) : pred__43533.call(null,G__43556,G__43557));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,G__43521,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43558 = cljs.core.cst$kw$schema;
var G__43559 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43558,G__43559) : pred__43533.call(null,G__43558,G__43559));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,G__43521,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43560 = cljs.core.cst$kw$settings;
var G__43561 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43560,G__43561) : pred__43533.call(null,G__43560,G__43561));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,G__43521,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43562 = cljs.core.cst$kw$index_DASH_configs;
var G__43563 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43562,G__43563) : pred__43533.call(null,G__43562,G__43563));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,G__43521,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43564 = cljs.core.cst$kw$schema_DASH_cache;
var G__43565 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43564,G__43565) : pred__43533.call(null,G__43564,G__43565));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,G__43521,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43566 = cljs.core.cst$kw$novelty;
var G__43567 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43566,G__43567) : pred__43533.call(null,G__43566,G__43567));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,G__43521,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43568 = cljs.core.cst$kw$permissions;
var G__43569 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43568,G__43569) : pred__43533.call(null,G__43568,G__43569));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,G__43521,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43570 = cljs.core.cst$kw$fork;
var G__43571 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43570,G__43571) : pred__43533.call(null,G__43570,G__43571));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,G__43521,self__.fork_block,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43572 = cljs.core.cst$kw$fork_DASH_block;
var G__43573 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43572,G__43573) : pred__43533.call(null,G__43572,G__43573));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,G__43521,self__.current_db_fn,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__43574 = cljs.core.cst$kw$current_DASH_db_DASH_fn;
var G__43575 = expr__43534;
return (pred__43533.cljs$core$IFn$_invoke$arity$2 ? pred__43533.cljs$core$IFn$_invoke$arity$2(G__43574,G__43575) : pred__43533.call(null,G__43574,G__43575));
})())){
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,G__43521,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__43521),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$stats,self__.stats,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$spot,self__.spot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$psot,self__.psot,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$post,self__.post,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$opst,self__.opst,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema,self__.schema,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$settings,self__.settings,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$index_DASH_configs,self__.index_configs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$schema_DASH_cache,self__.schema_cache,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$novelty,self__.novelty,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$permissions,self__.permissions,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork,self__.fork,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$fork_DASH_block,self__.fork_block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$current_DASH_db_DASH_fn,self__.current_db_fn,null))], null),self__.__extmap));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__43521){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.graphdb.GraphDb(self__.conn,self__.network,self__.dbid,self__.block,self__.t,self__.tt_id,self__.stats,self__.spot,self__.psot,self__.post,self__.opst,self__.schema,self__.settings,self__.index_configs,self__.schema_cache,self__.novelty,self__.permissions,self__.fork,self__.fork_block,self__.current_db_fn,G__43521,self__.__extmap,self__.__hash));
}));

(fluree.db.graphdb.GraphDb.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_latest_db$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_latest_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_add_predicate_to_idx$arity$2 = (function (this$,pred_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.add_predicate_to_idx(this$__$1,pred_id,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_c_prop$arity$3 = (function (this$,property,collection){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_c_prop(this$__$1,property,collection);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_p_prop$arity$3 = (function (this$,property,predicate){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_p_prop(this$__$1,property,predicate);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$3 = (function (this$,block__$1,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with$arity$4 = (function (this$,block__$1,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with$.cljs$core$IFn$_invoke$arity$4(this$__$1,block__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$2 = (function (this$,ident){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,false);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_subid$arity$3 = (function (this$,ident,strict_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.subid(this$__$1,ident,strict_QMARK_);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_search$arity$2 = (function (this$,fparts){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2(this$__$1,fparts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_rootdb$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_root_db(this$__$1);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$2 = (function (db,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,null,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_forward_time_travel$arity$3 = (function (db,tt_id__$1,flakes){
var self__ = this;
var db__$1 = this;
return fluree.db.graphdb.forward_time_travel(db__$1,tt_id__$1,flakes);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_query$arity$2 = (function (this$,query_map){
var self__ = this;
var this$__$1 = this;
return fluree.db.query.fql.query(this$__$1,query_map);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$2 = (function (this$,flakes){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,null);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_with_t$arity$3 = (function (this$,flakes,opts){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.with_t.cljs$core$IFn$_invoke$arity$3(this$__$1,flakes,opts);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$2 = (function (this$,tag_id){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_id);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag$arity$3 = (function (this$,tag_id,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_id,pred);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$2 = (function (this$,tag_name){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$2(this$__$1,tag_name);
}));

(fluree.db.graphdb.GraphDb.prototype.fluree$db$dbproto$IFlureeDb$_tag_id$arity$3 = (function (this$,tag_name,pred){
var self__ = this;
var this$__$1 = this;
return fluree.db.graphdb.graphdb_tag_id.cljs$core$IFn$_invoke$arity$3(this$__$1,tag_name,pred);
}));

(fluree.db.graphdb.GraphDb.getBasis = (function (){
return new cljs.core.PersistentVector(null, 20, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$stats,cljs.core.cst$sym$spot,cljs.core.cst$sym$psot,cljs.core.cst$sym$post,cljs.core.cst$sym$opst,cljs.core.cst$sym$schema,cljs.core.cst$sym$settings,cljs.core.cst$sym$index_DASH_configs,cljs.core.cst$sym$schema_DASH_cache,cljs.core.cst$sym$novelty,cljs.core.cst$sym$permissions,cljs.core.cst$sym$fork,cljs.core.cst$sym$fork_DASH_block,cljs.core.cst$sym$current_DASH_db_DASH_fn], null);
}));

(fluree.db.graphdb.GraphDb.cljs$lang$type = true);

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.graphdb/GraphDb",null,(1),null));
}));

(fluree.db.graphdb.GraphDb.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.graphdb/GraphDb");
}));

/**
 * Positional factory function for fluree.db.graphdb/GraphDb.
 */
fluree.db.graphdb.__GT_GraphDb = (function fluree$db$graphdb$__GT_GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn){
return (new fluree.db.graphdb.GraphDb(conn,network,dbid,block,t,tt_id,stats,spot,psot,post,opst,schema,settings,index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn,null,null,null));
});

/**
 * Factory function for fluree.db.graphdb/GraphDb, taking a map of keywords to field values.
 */
fluree.db.graphdb.map__GT_GraphDb = (function fluree$db$graphdb$map__GT_GraphDb(G__43525){
var extmap__4501__auto__ = (function (){var G__43576 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__43525,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst,cljs.core.cst$kw$schema,cljs.core.cst$kw$settings,cljs.core.cst$kw$index_DASH_configs,cljs.core.cst$kw$schema_DASH_cache,cljs.core.cst$kw$novelty,cljs.core.cst$kw$permissions,cljs.core.cst$kw$fork,cljs.core.cst$kw$fork_DASH_block,cljs.core.cst$kw$current_DASH_db_DASH_fn], 0));
if(cljs.core.record_QMARK_(G__43525)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__43576);
} else {
return G__43576;
}
})();
return (new fluree.db.graphdb.GraphDb(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$stats.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$spot.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$psot.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$post.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$opst.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$schema.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$settings.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$index_DASH_configs.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$schema_DASH_cache.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$novelty.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$fork.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$fork_DASH_block.cljs$core$IFn$_invoke$arity$1(G__43525),cljs.core.cst$kw$current_DASH_db_DASH_fn.cljs$core$IFn$_invoke$arity$1(G__43525),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.graphdb.GraphDb.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (db,w,opts){
var db__$1 = this;
cljs.core._write(w,"#FlureeGraphDB ");

return cljs.core._write(w,cljs.core.pr.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$network,db__$1.network,cljs.core.cst$kw$dbid,db__$1.dbid,cljs.core.cst$kw$block,db__$1.block,cljs.core.cst$kw$t,db__$1.t,cljs.core.cst$kw$stats,db__$1.stats,cljs.core.cst$kw$permissions,db__$1.permissions], null)], 0)));
}));
fluree.db.graphdb.new_novelty_map = (function fluree$db$graphdb$new_novelty_map(index_configs){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (m,idx){
var ss = clojure.data.avl.sorted_set_by(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(index_configs,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [idx,cljs.core.cst$kw$historyComparator], null)));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,idx,ss);
}),new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$size,(0)], null),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
fluree.db.graphdb.new_empty_index = (function fluree$db$graphdb$new_empty_index(conn,index_configs,network,dbid,idx){
var index_config = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,idx);
var _ = (cljs.core.truth_(index_config)?null:(function(){throw (new Error(["Assert failed: ",["No index config found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","index-config"].join('')))})());
var comparator = cljs.core.cst$kw$historyComparator.cljs$core$IFn$_invoke$arity$1(index_config);
var ___$1 = (cljs.core.truth_(comparator)?null:(function(){throw (new Error(["Assert failed: ",["No index comparator found for index: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(idx)].join(''),"\n","comparator"].join('')))})());
var first_flake = fluree.db.flake.__GT_Flake(fluree.db.util.core.max_long,(0),fluree.db.util.core.max_long,(0),true,null);
var child_node = fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$block,cljs.core.cst$kw$dbid,cljs.core.cst$kw$config,cljs.core.cst$kw$leaf,cljs.core.cst$kw$size,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$id,cljs.core.cst$kw$t,cljs.core.cst$kw$network,cljs.core.cst$kw$first,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$rhs,cljs.core.cst$kw$conn],[(0),dbid,index_config,true,(0),true,cljs.core.cst$kw$empty,(0),network,first_flake,null,null,conn]));
var children = clojure.data.avl.sorted_map_by.cljs$core$IFn$_invoke$arity$variadic(comparator,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([first_flake,child_node], 0));
var idx_node = fluree.db.index.__GT_IndexNode((0),(0),null,children,index_config,true);
return idx_node;
});
fluree.db.graphdb.default_index_configs = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$spot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$spot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_spot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_spot_novelty], null)),cljs.core.cst$kw$psot,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$psot,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_psot,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_psot_novelty], null)),cljs.core.cst$kw$post,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$post,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_post,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_post_novelty], null)),cljs.core.cst$kw$opst,fluree.db.index.map__GT_IndexConfig(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index_DASH_type,cljs.core.cst$kw$opst,cljs.core.cst$kw$comparator,fluree.db.flake.cmp_flakes_opst,cljs.core.cst$kw$historyComparator,fluree.db.flake.cmp_flakes_opst_novelty], null))], null);
fluree.db.graphdb.blank_db = (function fluree$db$graphdb$blank_db(conn,network,dbid,schema_cache,current_db_fn){
if(cljs.core.truth_(conn)){
} else {
throw (new Error(["Assert failed: ","No conn provided when creating new db.","\n","conn"].join('')));
}

if(cljs.core.truth_(network)){
} else {
throw (new Error(["Assert failed: ","No network provided when creating new db.","\n","network"].join('')));
}

if(cljs.core.truth_(dbid)){
} else {
throw (new Error(["Assert failed: ","No dbid provided when creating new db.","\n","dbid"].join('')));
}

var novelty = fluree.db.graphdb.new_novelty_map(fluree.db.graphdb.default_index_configs);
var permissions = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,false], null),cljs.core.cst$kw$predicate,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$all_QMARK_,true], null),cljs.core.cst$kw$root_QMARK_,true], null);
var spot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$spot);
var psot = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$psot);
var post = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$post);
var opst = fluree.db.graphdb.new_empty_index(conn,fluree.db.graphdb.default_index_configs,network,dbid,cljs.core.cst$kw$opst);
var stats = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$flakes,(0),cljs.core.cst$kw$size,(0),cljs.core.cst$kw$indexed,(0)], null);
var fork = null;
var fork_block = null;
var schema = null;
var settings = null;
return fluree.db.graphdb.__GT_GraphDb(conn,network,dbid,(0),(-1),null,stats,spot,psot,post,opst,schema,settings,fluree.db.graphdb.default_index_configs,schema_cache,novelty,permissions,fork,fork_block,current_db_fn);
});
fluree.db.graphdb.graphdb_QMARK_ = (function fluree$db$graphdb$graphdb_QMARK_(db){
return (db instanceof fluree.db.graphdb.GraphDb);
});
