// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.analytical');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('clojure.set');
goog.require('fluree.db.query.range');
goog.require('cljs.core.async');
goog.require('fluree.db.time_travel');
goog.require('fluree.db.util.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.flake');
goog.require('fluree.db.query.analytical_wikidata');
goog.require('fluree.db.query.analytical_filter');
goog.require('fluree.db.query.union');
goog.require('clojure.string');
goog.require('fluree.db.util.log');
goog.require('cljs.reader');
goog.require('fluree.db.dbproto');
fluree.db.query.analytical.variable_QMARK_ = (function fluree$db$query$analytical$variable_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"?")))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.internal_filter_QMARK_ = (function fluree$db$query$analytical$internal_filter_QMARK_(form){
if(((((typeof form === 'string') || ((((form instanceof cljs.core.Keyword)) || ((form instanceof cljs.core.Symbol)))))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"#")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.second(cljs.core.name(form)),"(")))))){
return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(form);
} else {
return null;
}
});
fluree.db.query.analytical.escaped_string_QMARK_ = (function fluree$db$query$analytical$escaped_string_QMARK_(form){
return ((typeof form === 'string') && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.name(form)),"\"")) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.last(cljs.core.name(form)),"\"")))));
});
fluree.db.query.analytical.safe_read_string = (function fluree$db$query$analytical$safe_read_string(string){
try{return cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(string);
}catch (e35859){var e = e35859;
return string;
}});
fluree.db.query.analytical.get_vars = (function fluree$db$query$analytical$get_vars(filter_code){
return cljs.core.some((function (p1__35860_SHARP_){
var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(p1__35860_SHARP_);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.coll_QMARK_(p1__35860_SHARP_)){
return (fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.get_vars.cljs$core$IFn$_invoke$arity$1(p1__35860_SHARP_) : fluree.db.query.analytical.get_vars.call(null,p1__35860_SHARP_));
} else {
return null;
}
}
}),filter_code);
});
/**
 * Given any interm-vars, such as {?article 351843720901583}
 *   and an fdb clause, such as  ["?article", "articles/leadInstitutionOrg", "?org"],
 * 
 * 
 *   Returns a map with the following keys:
 * 
 *   - search - a vector that will be passed to query-range/search, i.e. [ nil "articles/leadInstitutionOrg" nil ]
 *   - rel - a map with any variables (that are not present in interm-vars) and their idx, i.e. {?org 2}
 *   - opts - search opts, currently recur, if the predicate is recurred, and object-fn, if there is an object function.
 *  
 */
fluree.db.query.analytical.clause__GT_rel = (function fluree$db$query$analytical$clause__GT_rel(db,interm_vars,clause){
return cljs.core.reduce_kv((function (acc,idx,key){
var key_as_var = fluree.db.query.analytical.variable_QMARK_(key);
var static_value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(interm_vars,key_as_var);
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1))) && (((cljs.core.not(key_as_var)) && (((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2("_id",key)) && (cljs.core.not(fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,cljs.core.re_find(/[_a-zA-Z0-9\/]*/,key)))))))))){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
} else {
}

if(cljs.core.truth_(static_value)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35861_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35861_SHARP_,static_value);
}));
} else {
if(cljs.core.truth_(key_as_var)){
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35862_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35862_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,key_as_var], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fluree.db.query.analytical.internal_filter_QMARK_(key);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(2));
} else {
return and__4210__auto__;
}
})())){
var filter_code = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(key,(1)));
var var$ = (function (){var or__4212__auto__ = fluree.db.query.analytical.get_vars(filter_code);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter function must contain a valid variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__35867 = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code,cljs.core.PersistentHashSet.createAsIfByAssoc([var$]));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35867,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35867,(1),null);
var filter_fn = fluree.db.query.analytical_filter.get_internal_filter_fn(var$,fun);
return cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35863_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35863_SHARP_,null);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$object_DASH_fn], null),filter_fn),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$rel,var$], null),idx);
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(idx,(1));
if(and__4210__auto__){
return cljs.core.re_find(/\+/,key);
} else {
return and__4210__auto__;
}
})())){
var vec__35870 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(key,/\+/);
var pred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35870,(0),null);
var recur_amt = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__35870,(1),null);
var recur_amt__$1 = (cljs.core.truth_(recur_amt)?(function (){var or__4212__auto__ = fluree.db.query.analytical.safe_read_string(recur_amt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})():(100));
return cljs.core.assoc_in(cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35864_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35864_SHARP_,pred);
})),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$opts,cljs.core.cst$kw$recur], null),recur_amt__$1);
} else {
if(fluree.db.query.analytical.escaped_string_QMARK_(key)){
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35865_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35865_SHARP_,fluree.db.query.analytical.safe_read_string(key));
}));
} else {
return cljs.core.update.cljs$core$IFn$_invoke$arity$3(acc,cljs.core.cst$kw$search,(function (p1__35866_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__35866_SHARP_,key);
}));

}
}
}
}
}
}),new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$search,cljs.core.PersistentVector.EMPTY,cljs.core.cst$kw$rel,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$opts,cljs.core.PersistentArrayMap.EMPTY], null),clause);
});
fluree.db.query.analytical.get_ns_arrays = (function fluree$db$query$analytical$get_ns_arrays(ns,arrays){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (array){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__35873_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(array,p1__35873_SHARP_);
}),ns);
}),arrays);
});
fluree.db.query.analytical.clause__GT_keys = (function fluree$db$query$analytical$clause__GT_keys(clause){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var$){
var temp__5751__auto__ = fluree.db.query.analytical.variable_QMARK_(var$);
if(cljs.core.truth_(temp__5751__auto__)){
var var$__$1 = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,var$__$1);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause);
});
fluree.db.query.analytical.intersecting_keys_tuples_clause = (function fluree$db$query$analytical$intersecting_keys_tuples_clause(tuples,clause){
var rel_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples));
var clause_keys = fluree.db.query.analytical.clause__GT_keys(clause);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((rel_keys.cljs$core$IFn$_invoke$arity$1 ? rel_keys.cljs$core$IFn$_invoke$arity$1(key) : rel_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,clause_keys);
});
fluree.db.query.analytical.intersecting_keys_tuples = (function fluree$db$query$analytical$intersecting_keys_tuples(a_tuples,b_tuples){
var a_keys = cljs.core.set(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples));
var b_keys = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,key){
if(cljs.core.truth_((a_keys.cljs$core$IFn$_invoke$arity$1 ? a_keys.cljs$core$IFn$_invoke$arity$1(key) : a_keys.call(null,key)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,key);
} else {
return acc;
}
}),cljs.core.PersistentVector.EMPTY,b_keys);
});
fluree.db.query.analytical.select_from_tuples = (function fluree$db$query$analytical$select_from_tuples(vars,tuples){
var ns = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,var_smt){
var temp__5751__auto__ = (function (){var or__4212__auto__ = fluree.db.query.analytical.variable_QMARK_(var_smt);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(var_smt);
}
})();
if(cljs.core.truth_(temp__5751__auto__)){
var var$ = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(tuples),var$));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2([cljs.core.str.cljs$core$IFn$_invoke$arity$1(var_smt)," cannot be retrieved from the results. Check that it is declared in your where clause."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
}),cljs.core.PersistentVector.EMPTY,vars);
return fluree.db.query.analytical.get_ns_arrays(ns,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(tuples));
});
fluree.db.query.analytical.add_fuel = (function fluree$db$query$analytical$add_fuel(add_amount,fuel,max_fuel){
if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (add_amount > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query fuel exceeded: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
if(cljs.core.truth_((function (){var and__4210__auto__ = fuel;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.volatile_QMARK_(fuel);
} else {
return and__4210__auto__;
}
})())){
return cljs.core._vreset_BANG_(fuel,(cljs.core._deref(fuel) + add_amount));
} else {
return null;
}
}
});
fluree.db.query.analytical.replace_vars_wikidata = (function fluree$db$query$analytical$replace_vars_wikidata(all_wd,intersecting_vars,vars){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause){
return cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (clause_item){
var temp__5751__auto__ = (function (){var G__35874 = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(clause_item);
return (intersecting_vars.cljs$core$IFn$_invoke$arity$1 ? intersecting_vars.cljs$core$IFn$_invoke$arity$1(G__35874) : intersecting_vars.call(null,G__35874));
})();
if(cljs.core.truth_(temp__5751__auto__)){
var key_replace = temp__5751__auto__;
var replacement = cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,key_replace);
var replacement_SINGLEQUOTE_ = ((typeof cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(replacement) === 'number')?replacement:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(replacement),"\""].join(''));
return replacement_SINGLEQUOTE_;
} else {
return clause_item;
}
}),clause);
}),all_wd);
});
fluree.db.query.analytical.wikidata__GT_tuples = (function fluree$db$query$analytical$wikidata__GT_tuples(q_map,clause,r,p__35877,optional_QMARK_,fuel,max_fuel){
var map__35878 = p__35877;
var map__35878__$1 = cljs.core.__destructure_map(map__35878);
var res = map__35878__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__35878__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_35944){
var state_val_35945 = (state_35944[(1)]);
if((state_val_35945 === (7))){
var inst_35933 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35934 = fluree.db.query.analytical_wikidata.drop_all_wd_clauses(r);
var inst_35935 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_35934,clause);
var inst_35936 = [null,inst_35935];
var inst_35937 = (new cljs.core.PersistentVector(null,2,(5),inst_35933,inst_35936,null));
var state_35944__$1 = state_35944;
var statearr_35946_35974 = state_35944__$1;
(statearr_35946_35974[(2)] = inst_35937);

(statearr_35946_35974[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (1))){
var state_35944__$1 = state_35944;
var statearr_35947_35975 = state_35944__$1;
(statearr_35947_35975[(2)] = null);

(statearr_35947_35975[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (4))){
var inst_35879 = (state_35944[(2)]);
var state_35944__$1 = state_35944;
var statearr_35948_35976 = state_35944__$1;
(statearr_35948_35976[(2)] = inst_35879);

(statearr_35948_35976[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (15))){
var inst_35922 = (state_35944[(2)]);
var inst_35923 = fluree.db.util.async.throw_err(inst_35922);
var inst_35924 = cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(inst_35923);
var inst_35925 = cljs.core.count(inst_35924);
var inst_35926 = fluree.db.query.analytical.add_fuel(inst_35925,fuel,max_fuel);
var inst_35927 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35928 = [inst_35923,r];
var inst_35929 = (new cljs.core.PersistentVector(null,2,(5),inst_35927,inst_35928,null));
var state_35944__$1 = (function (){var statearr_35949 = state_35944;
(statearr_35949[(7)] = inst_35926);

return statearr_35949;
})();
var statearr_35950_35977 = state_35944__$1;
(statearr_35950_35977[(2)] = inst_35929);

(statearr_35950_35977[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (13))){
var inst_35888 = (state_35944[(8)]);
var inst_35901 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35902 = fluree.db.query.analytical_wikidata.get_all_wd_optional_clauses(inst_35901);
var inst_35903 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35888);
var inst_35904 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35903);
var inst_35905 = cljs.core.set(inst_35904);
var inst_35906 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.analytical.clause__GT_keys,inst_35902);
var inst_35907 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35906);
var inst_35908 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_35905,inst_35907);
var inst_35909 = (function (){var all_wd = inst_35888;
var optional = inst_35902;
var all_wd_vars = inst_35905;
var all_vars = inst_35908;
return (function (p1__35875_SHARP_){
return (all_vars.cljs$core$IFn$_invoke$arity$1 ? all_vars.cljs$core$IFn$_invoke$arity$1(p1__35875_SHARP_) : all_vars.call(null,p1__35875_SHARP_));
});
})();
var inst_35910 = cljs.core.keys(vars);
var inst_35911 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35909,inst_35910);
var inst_35912 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(cljs.core.nil_QMARK_,inst_35911);
var inst_35913 = cljs.core.set(inst_35912);
var inst_35914 = (function (){var all_wd = inst_35888;
var optional = inst_35902;
var all_wd_vars = inst_35905;
var all_vars = inst_35908;
var intersecting_vars = inst_35913;
return (function (p1__35876_SHARP_){
return fluree.db.query.analytical.intersecting_keys_tuples_clause(res,p1__35876_SHARP_);
});
})();
var inst_35915 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_35914,inst_35888);
var inst_35916 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_35915);
var inst_35917 = fluree.db.query.analytical.select_from_tuples(inst_35916,res);
var inst_35918 = fluree.db.query.analytical.replace_vars_wikidata(inst_35888,inst_35913,vars);
var inst_35919 = cljs.core.remove.cljs$core$IFn$_invoke$arity$2(inst_35913,inst_35908);
var inst_35920 = fluree.db.query.analytical_wikidata.get_wikidata_tuples(q_map,inst_35918,inst_35916,inst_35917,inst_35919,inst_35902);
var state_35944__$1 = state_35944;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_35944__$1,(15),inst_35920);
} else {
if((state_val_35945 === (6))){
var inst_35889 = (state_35944[(9)]);
var inst_35887 = cljs.core.cst$kw$where.cljs$core$IFn$_invoke$arity$1(q_map);
var inst_35888 = fluree.db.query.analytical_wikidata.get_all_wd_clauses(inst_35887);
var inst_35889__$1 = optional_QMARK_;
var state_35944__$1 = (function (){var statearr_35951 = state_35944;
(statearr_35951[(8)] = inst_35888);

(statearr_35951[(9)] = inst_35889__$1);

return statearr_35951;
})();
if(cljs.core.truth_(inst_35889__$1)){
var statearr_35952_35978 = state_35944__$1;
(statearr_35952_35978[(1)] = (9));

} else {
var statearr_35953_35979 = state_35944__$1;
(statearr_35953_35979[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (3))){
var inst_35942 = (state_35944[(2)]);
var state_35944__$1 = state_35944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_35944__$1,inst_35942);
} else {
if((state_val_35945 === (12))){
var inst_35897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_35898 = [null,r];
var inst_35899 = (new cljs.core.PersistentVector(null,2,(5),inst_35897,inst_35898,null));
var state_35944__$1 = state_35944;
var statearr_35954_35980 = state_35944__$1;
(statearr_35954_35980[(2)] = inst_35899);

(statearr_35954_35980[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (2))){
var _ = (function (){var statearr_35955 = state_35944;
(statearr_35955[(4)] = cljs.core.cons((5),(state_35944[(4)])));

return statearr_35955;
})();
var inst_35885 = (r == null);
var state_35944__$1 = state_35944;
if(cljs.core.truth_(inst_35885)){
var statearr_35956_35981 = state_35944__$1;
(statearr_35956_35981[(1)] = (6));

} else {
var statearr_35957_35982 = state_35944__$1;
(statearr_35957_35982[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (11))){
var inst_35895 = (state_35944[(2)]);
var state_35944__$1 = state_35944;
if(cljs.core.truth_(inst_35895)){
var statearr_35959_35983 = state_35944__$1;
(statearr_35959_35983[(1)] = (12));

} else {
var statearr_35960_35984 = state_35944__$1;
(statearr_35960_35984[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (9))){
var inst_35888 = (state_35944[(8)]);
var inst_35891 = cljs.core.empty_QMARK_(inst_35888);
var inst_35892 = (!(inst_35891));
var state_35944__$1 = state_35944;
var statearr_35961_35985 = state_35944__$1;
(statearr_35961_35985[(2)] = inst_35892);

(statearr_35961_35985[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (5))){
var _ = (function (){var statearr_35962 = state_35944;
(statearr_35962[(4)] = cljs.core.rest((state_35944[(4)])));

return statearr_35962;
})();
var state_35944__$1 = state_35944;
var ex35958 = (state_35944__$1[(2)]);
var statearr_35963_35986 = state_35944__$1;
(statearr_35963_35986[(5)] = ex35958);


if((ex35958 instanceof Error)){
var statearr_35964_35987 = state_35944__$1;
(statearr_35964_35987[(1)] = (4));

(statearr_35964_35987[(5)] = null);

} else {
throw ex35958;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (14))){
var inst_35931 = (state_35944[(2)]);
var state_35944__$1 = state_35944;
var statearr_35965_35988 = state_35944__$1;
(statearr_35965_35988[(2)] = inst_35931);

(statearr_35965_35988[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (10))){
var inst_35889 = (state_35944[(9)]);
var state_35944__$1 = state_35944;
var statearr_35966_35989 = state_35944__$1;
(statearr_35966_35989[(2)] = inst_35889);

(statearr_35966_35989[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_35945 === (8))){
var inst_35939 = (state_35944[(2)]);
var _ = (function (){var statearr_35967 = state_35944;
(statearr_35967[(4)] = cljs.core.rest((state_35944[(4)])));

return statearr_35967;
})();
var state_35944__$1 = state_35944;
var statearr_35968_35990 = state_35944__$1;
(statearr_35968_35990[(2)] = inst_35939);

(statearr_35968_35990[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_35969 = [null,null,null,null,null,null,null,null,null,null];
(statearr_35969[(0)] = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__);

(statearr_35969[(1)] = (1));

return statearr_35969;
});
var fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1 = (function (state_35944){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_35944);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e35970){var ex__16398__auto__ = e35970;
var statearr_35971_35991 = state_35944;
(statearr_35971_35991[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_35944[(4)]))){
var statearr_35972_35992 = state_35944;
(statearr_35972_35992[(1)] = cljs.core.first((state_35944[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__35993 = state_35944;
state_35944 = G__35993;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__ = function(state_35944){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1.call(this,state_35944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$wikidata__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_35973 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_35973[(6)] = c__16469__auto__);

return statearr_35973;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.db_ident_QMARK_ = (function fluree$db$query$analytical$db_ident_QMARK_(source){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(clojure.string.split.cljs$core$IFn$_invoke$arity$2(source,/\//)),(2));
});
fluree.db.query.analytical.parse_block_from_source = (function fluree$db$query$analytical$parse_block_from_source(block){
var block_SINGLEQUOTE_ = fluree.db.query.analytical.safe_read_string(block);
if(cljs.core.int_QMARK_(block_SINGLEQUOTE_)){
return block_SINGLEQUOTE_;
} else {
return block;
}
});
fluree.db.query.analytical.isolate_source_name = (function fluree$db$query$analytical$isolate_source_name(dbid){
return cljs.core.re_find(/[a-z]+/,dbid);
});
fluree.db.query.analytical.isolate_source_block = (function fluree$db$query$analytical$isolate_source_block(dbid){
return cljs.core.re_find(/[A-Z0-9]+/,dbid);
});
fluree.db.query.analytical.get_source_clause = (function fluree$db$query$analytical$get_source_clause(var_args){
var G__35995 = arguments.length;
switch (G__35995) {
case 2:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$2 = (function (db,clause){
return fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4 = (function (db,clause,prefixes,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36089){
var state_val_36090 = (state_36089[(1)]);
if((state_val_36090 === (7))){
var inst_36002 = (state_36089[(7)]);
var inst_36012 = clojure.string.starts_with_QMARK_(inst_36002,"$fdb");
var state_36089__$1 = state_36089;
if(inst_36012){
var statearr_36091_36140 = state_36089__$1;
(statearr_36091_36140[(1)] = (9));

} else {
var statearr_36092_36141 = state_36089__$1;
(statearr_36092_36141[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (20))){
var state_36089__$1 = state_36089;
var statearr_36093_36142 = state_36089__$1;
(statearr_36093_36142[(2)] = null);

(statearr_36093_36142[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (27))){
var inst_36052 = (state_36089[(8)]);
var state_36089__$1 = state_36089;
var statearr_36094_36143 = state_36089__$1;
(statearr_36094_36143[(2)] = inst_36052);

(statearr_36094_36143[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (1))){
var state_36089__$1 = state_36089;
var statearr_36095_36144 = state_36089__$1;
(statearr_36095_36144[(2)] = null);

(statearr_36095_36144[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (24))){
var inst_36075 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
var statearr_36096_36145 = state_36089__$1;
(statearr_36096_36145[(2)] = inst_36075);

(statearr_36096_36145[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (4))){
var inst_35996 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
var statearr_36097_36146 = state_36089__$1;
(statearr_36097_36146[(2)] = inst_35996);

(statearr_36097_36146[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (15))){
var inst_36019 = (state_36089[(9)]);
var inst_36025 = (state_36089[(2)]);
var inst_36026 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36027 = cljs.core.PersistentVector.EMPTY;
var inst_36028 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36029 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36027,inst_36028);
var inst_36030 = [inst_36019,inst_36029];
var inst_36031 = (new cljs.core.PersistentVector(null,2,(5),inst_36026,inst_36030,null));
var state_36089__$1 = (function (){var statearr_36098 = state_36089;
(statearr_36098[(10)] = inst_36025);

return statearr_36098;
})();
var statearr_36099_36147 = state_36089__$1;
(statearr_36099_36147[(2)] = inst_36031);

(statearr_36099_36147[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (21))){
var inst_36078 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
var statearr_36100_36148 = state_36089__$1;
(statearr_36100_36148[(2)] = inst_36078);

(statearr_36100_36148[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (13))){
var inst_36019 = (state_36089[(9)]);
var inst_36022 = (function(){throw inst_36019})();
var state_36089__$1 = state_36089;
var statearr_36101_36149 = state_36089__$1;
(statearr_36101_36149[(2)] = inst_36022);

(statearr_36101_36149[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (22))){
var inst_36041 = (state_36089[(11)]);
var inst_36043 = (state_36089[(12)]);
var inst_36045 = fluree.db.query.analytical.parse_block_from_source(inst_36041);
var inst_36046 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36047 = [cljs.core.cst$kw$sources,inst_36043];
var inst_36048 = (new cljs.core.PersistentVector(null,2,(5),inst_36046,inst_36047,null));
var inst_36049 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(opts,inst_36048);
var state_36089__$1 = (function (){var statearr_36102 = state_36089;
(statearr_36102[(13)] = inst_36045);

return statearr_36102;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36089__$1,(25),inst_36049);
} else {
if((state_val_36090 === (29))){
var inst_36056 = (state_36089[(2)]);
var inst_36057 = fluree.db.util.async.throw_err(inst_36056);
var state_36089__$1 = state_36089;
var statearr_36103_36150 = state_36089__$1;
(statearr_36103_36150[(2)] = inst_36057);

(statearr_36103_36150[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (6))){
var inst_36005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36006 = cljs.core.PersistentVector.EMPTY;
var inst_36007 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36008 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36006,inst_36007);
var inst_36009 = [db,inst_36008];
var inst_36010 = (new cljs.core.PersistentVector(null,2,(5),inst_36005,inst_36009,null));
var state_36089__$1 = state_36089;
var statearr_36104_36151 = state_36089__$1;
(statearr_36104_36151[(2)] = inst_36010);

(statearr_36104_36151[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (28))){
var inst_36060 = (state_36089[(2)]);
var inst_36061 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36062 = cljs.core.PersistentVector.EMPTY;
var inst_36063 = cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(clause,(1),(4));
var inst_36064 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_36062,inst_36063);
var inst_36065 = [inst_36060,inst_36064];
var inst_36066 = (new cljs.core.PersistentVector(null,2,(5),inst_36061,inst_36065,null));
var state_36089__$1 = state_36089;
var statearr_36105_36152 = state_36089__$1;
(statearr_36105_36152[(2)] = inst_36066);

(statearr_36105_36152[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (25))){
var inst_36045 = (state_36089[(13)]);
var inst_36051 = (state_36089[(2)]);
var inst_36052 = fluree.db.util.async.throw_err(inst_36051);
var state_36089__$1 = (function (){var statearr_36106 = state_36089;
(statearr_36106[(8)] = inst_36052);

return statearr_36106;
})();
if(cljs.core.truth_(inst_36045)){
var statearr_36107_36153 = state_36089__$1;
(statearr_36107_36153[(1)] = (26));

} else {
var statearr_36108_36154 = state_36089__$1;
(statearr_36108_36154[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (17))){
var state_36089__$1 = state_36089;
var statearr_36109_36155 = state_36089__$1;
(statearr_36109_36155[(1)] = (19));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (3))){
var inst_36087 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36089__$1,inst_36087);
} else {
if((state_val_36090 === (12))){
var inst_36019 = (state_36089[(9)]);
var inst_36018 = (state_36089[(2)]);
var inst_36019__$1 = fluree.db.util.async.throw_err(inst_36018);
var inst_36020 = fluree.db.util.core.exception_QMARK_(inst_36019__$1);
var state_36089__$1 = (function (){var statearr_36111 = state_36089;
(statearr_36111[(9)] = inst_36019__$1);

return statearr_36111;
})();
if(inst_36020){
var statearr_36112_36156 = state_36089__$1;
(statearr_36112_36156[(1)] = (13));

} else {
var statearr_36113_36157 = state_36089__$1;
(statearr_36113_36157[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (2))){
var inst_36002 = (state_36089[(7)]);
var _ = (function (){var statearr_36114 = state_36089;
(statearr_36114[(4)] = cljs.core.cons((5),(state_36089[(4)])));

return statearr_36114;
})();
var inst_36002__$1 = cljs.core.first(clause);
var inst_36003 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$fdb",inst_36002__$1);
var state_36089__$1 = (function (){var statearr_36115 = state_36089;
(statearr_36115[(7)] = inst_36002__$1);

return statearr_36115;
})();
if(inst_36003){
var statearr_36116_36158 = state_36089__$1;
(statearr_36116_36158[(1)] = (6));

} else {
var statearr_36117_36159 = state_36089__$1;
(statearr_36117_36159[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (23))){
var inst_36002 = (state_36089[(7)]);
var inst_36068 = ["The data source: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36002)," is not supported in Fluree"].join('');
var inst_36069 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36070 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36071 = cljs.core.PersistentHashMap.fromArrays(inst_36069,inst_36070);
var inst_36072 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36068,inst_36071);
var inst_36073 = (function(){throw inst_36072})();
var state_36089__$1 = state_36089;
var statearr_36118_36160 = state_36089__$1;
(statearr_36118_36160[(2)] = inst_36073);

(statearr_36118_36160[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (19))){
var inst_36002 = (state_36089[(7)]);
var inst_36043 = (state_36089[(12)]);
var inst_36040 = fluree.db.query.analytical.isolate_source_name(inst_36002);
var inst_36041 = fluree.db.query.analytical.isolate_source_block(inst_36002);
var inst_36042 = cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(inst_36040);
var inst_36043__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(prefixes,inst_36042);
var state_36089__$1 = (function (){var statearr_36119 = state_36089;
(statearr_36119[(11)] = inst_36041);

(statearr_36119[(12)] = inst_36043__$1);

return statearr_36119;
})();
if(cljs.core.truth_(inst_36043__$1)){
var statearr_36120_36161 = state_36089__$1;
(statearr_36120_36161[(1)] = (22));

} else {
var statearr_36121_36162 = state_36089__$1;
(statearr_36121_36162[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (11))){
var inst_36082 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
var statearr_36123_36163 = state_36089__$1;
(statearr_36123_36163[(2)] = inst_36082);

(statearr_36123_36163[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (9))){
var inst_36002 = (state_36089[(7)]);
var inst_36014 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_36002,(4));
var inst_36015 = fluree.db.query.analytical.parse_block_from_source(inst_36014);
var inst_36016 = fluree.db.time_travel.as_of_block(db,inst_36015);
var state_36089__$1 = state_36089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36089__$1,(12),inst_36016);
} else {
if((state_val_36090 === (5))){
var _ = (function (){var statearr_36124 = state_36089;
(statearr_36124[(4)] = cljs.core.rest((state_36089[(4)])));

return statearr_36124;
})();
var state_36089__$1 = state_36089;
var ex36122 = (state_36089__$1[(2)]);
var statearr_36125_36164 = state_36089__$1;
(statearr_36125_36164[(5)] = ex36122);


if((ex36122 instanceof Error)){
var statearr_36126_36165 = state_36089__$1;
(statearr_36126_36165[(1)] = (4));

(statearr_36126_36165[(5)] = null);

} else {
throw ex36122;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (14))){
var state_36089__$1 = state_36089;
var statearr_36127_36166 = state_36089__$1;
(statearr_36127_36166[(2)] = null);

(statearr_36127_36166[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (26))){
var inst_36052 = (state_36089[(8)]);
var inst_36045 = (state_36089[(13)]);
var inst_36054 = fluree.db.time_travel.as_of_block(inst_36052,inst_36045);
var state_36089__$1 = state_36089;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36089__$1,(29),inst_36054);
} else {
if((state_val_36090 === (16))){
var inst_36035 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36036 = ["$wd",clause];
var inst_36037 = (new cljs.core.PersistentVector(null,2,(5),inst_36035,inst_36036,null));
var state_36089__$1 = state_36089;
var statearr_36128_36167 = state_36089__$1;
(statearr_36128_36167[(2)] = inst_36037);

(statearr_36128_36167[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (10))){
var inst_36002 = (state_36089[(7)]);
var inst_36033 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_36002);
var state_36089__$1 = state_36089;
if(inst_36033){
var statearr_36129_36168 = state_36089__$1;
(statearr_36129_36168[(1)] = (16));

} else {
var statearr_36130_36169 = state_36089__$1;
(statearr_36130_36169[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (18))){
var inst_36080 = (state_36089[(2)]);
var state_36089__$1 = state_36089;
var statearr_36131_36170 = state_36089__$1;
(statearr_36131_36170[(2)] = inst_36080);

(statearr_36131_36170[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36090 === (8))){
var inst_36084 = (state_36089[(2)]);
var _ = (function (){var statearr_36132 = state_36089;
(statearr_36132[(4)] = cljs.core.rest((state_36089[(4)])));

return statearr_36132;
})();
var state_36089__$1 = state_36089;
var statearr_36133_36171 = state_36089__$1;
(statearr_36133_36171[(2)] = inst_36084);

(statearr_36133_36171[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16395__auto__ = null;
var fluree$db$query$analytical$state_machine__16395__auto____0 = (function (){
var statearr_36134 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36134[(0)] = fluree$db$query$analytical$state_machine__16395__auto__);

(statearr_36134[(1)] = (1));

return statearr_36134;
});
var fluree$db$query$analytical$state_machine__16395__auto____1 = (function (state_36089){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36089);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36135){var ex__16398__auto__ = e36135;
var statearr_36136_36172 = state_36089;
(statearr_36136_36172[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36089[(4)]))){
var statearr_36137_36173 = state_36089;
(statearr_36137_36173[(1)] = cljs.core.first((state_36089[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36174 = state_36089;
state_36089 = G__36174;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16395__auto__ = function(state_36089){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16395__auto____1.call(this,state_36089);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16395__auto____0;
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16395__auto____1;
return fluree$db$query$analytical$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36138 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36138[(6)] = c__16469__auto__);

return statearr_36138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.analytical.get_source_clause.cljs$lang$maxFixedArity = 4);

fluree.db.query.analytical.tuples__GT_map = (function fluree$db$query$analytical$tuples__GT_map(start_map,tuples){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36175){
var vec__36176 = p__36175;
var sub = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36176,(0),null);
var obj = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36176,(1),null);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,sub,cljs.core.conj,obj);
}),start_map,tuples);
});
fluree.db.query.analytical.expand_map = (function fluree$db$query$analytical$expand_map(tuple_map){
return cljs.core.zipmap(cljs.core.keys(tuple_map),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36179_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$done,cljs.core.cst$kw$followed,cljs.core.cst$kw$all],[false,cljs.core.PersistentHashSet.EMPTY,cljs.core.set(p1__36179_SHARP_)]);
}),cljs.core.vals(tuple_map)));
});
fluree.db.query.analytical.follow_all_original_subject_paths = (function fluree$db$query$analytical$follow_all_original_subject_paths(subjects,tuple_map){
var expanded_map = fluree.db.query.analytical.expand_map(tuple_map);
var G__36183 = subjects;
var vec__36184 = G__36183;
var seq__36185 = cljs.core.seq(vec__36184);
var first__36186 = cljs.core.first(seq__36185);
var seq__36185__$1 = cljs.core.next(seq__36185);
var subject = first__36186;
var r = seq__36185__$1;
var acc = expanded_map;
var G__36183__$1 = G__36183;
var acc__$1 = acc;
while(true){
var vec__36190 = G__36183__$1;
var seq__36191 = cljs.core.seq(vec__36190);
var first__36192 = cljs.core.first(seq__36191);
var seq__36191__$1 = cljs.core.next(seq__36191);
var subject__$1 = first__36192;
var r__$1 = seq__36191__$1;
var acc__$2 = acc__$1;
if(cljs.core.not(subject__$1)){
return acc__$2;
} else {
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null)))){
var G__36193 = r__$1;
var G__36194 = acc__$2;
G__36183__$1 = G__36193;
acc__$1 = G__36194;
continue;
} else {
var subject_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subjects_to_follow = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(subject_all,subject_followed);
var acc_STAR_ = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (G__36183__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map){
return (function (acc__$3,subject_to_follow){
var all_followed = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var self_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject__$1,subject_to_follow);
var already_followed_QMARK_ = ((self_QMARK_)?false:(all_followed.cljs$core$IFn$_invoke$arity$1 ? all_followed.cljs$core$IFn$_invoke$arity$1(subject_to_follow) : all_followed.call(null,subject_to_follow)));
var acc_SINGLEQUOTE_ = cljs.core.update_in.cljs$core$IFn$_invoke$arity$4(acc__$3,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),cljs.core.conj,subject_to_follow);
if(cljs.core.truth_((function (){var or__4212__auto__ = already_followed_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return self_QMARK_;
}
})())){
return acc_SINGLEQUOTE_;
} else {
var subject_to_follow_all = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$all], null));
var acc_SINGLEQUOTE___$1 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null),((function (G__36183__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36183__$1,acc__$1,subject_to_follow_all,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map))
);
if(cljs.core.truth_(cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject_to_follow,cljs.core.cst$kw$done], null)))){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(acc_SINGLEQUOTE___$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null),((function (G__36183__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map){
return (function (existing){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,existing,subject_to_follow_all);
});})(G__36183__$1,acc__$1,subject_to_follow_all,acc_SINGLEQUOTE___$1,all_followed,self_QMARK_,already_followed_QMARK_,acc_SINGLEQUOTE_,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map))
);
} else {
return acc_SINGLEQUOTE___$1;
}
}
});})(G__36183__$1,acc__$1,subject_all,subject_followed,subjects_to_follow,vec__36190,seq__36191,first__36192,seq__36191__$1,subject__$1,r__$1,acc__$2,G__36183,vec__36184,seq__36185,first__36186,seq__36185__$1,subject,r,acc,expanded_map))
,acc__$2,subjects_to_follow);
var subject_followed_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$followed], null));
var subject_all_count = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(acc__$2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$all], null));
var subject_done_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(subject_followed_count,subject_all_count);
if(subject_done_QMARK_){
var G__36195 = r__$1;
var G__36196 = cljs.core.assoc_in(acc_STAR_,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject__$1,cljs.core.cst$kw$done], null),true);
G__36183__$1 = G__36195;
acc__$1 = G__36196;
continue;
} else {
var G__36197 = subjects;
var G__36198 = acc_STAR_;
G__36183__$1 = G__36197;
acc__$1 = G__36198;
continue;
}

}
}
break;
}
});
fluree.db.query.analytical.recur_map__GT_tuples = (function fluree$db$query$analytical$recur_map__GT_tuples(subjects,recur_map){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,subject){
var subject_vals = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(recur_map,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [subject,cljs.core.cst$kw$followed], null));
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36199_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[subject,p1__36199_SHARP_],null));
}),subject_vals));
}),cljs.core.PersistentVector.EMPTY,subjects);
});
fluree.db.query.analytical.tuples__GT_recur = (function fluree$db$query$analytical$tuples__GT_recur(db,predicate,recur_map,depth,var_first_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36290){
var state_val_36291 = (state_36290[(1)]);
if((state_val_36291 === (7))){
var state_36290__$1 = state_36290;
var statearr_36292_36338 = state_36290__$1;
(statearr_36292_36338[(2)] = (100));

(statearr_36292_36338[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (20))){
var inst_36239 = (state_36290[(7)]);
var state_36290__$1 = state_36290;
var statearr_36293_36339 = state_36290__$1;
(statearr_36293_36339[(2)] = inst_36239);

(statearr_36293_36339[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (1))){
var state_36290__$1 = state_36290;
var statearr_36294_36340 = state_36290__$1;
(statearr_36294_36340[(2)] = null);

(statearr_36294_36340[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (24))){
var inst_36277 = (state_36290[(8)]);
var inst_36278 = (state_36290[(9)]);
var inst_36211 = (state_36290[(10)]);
var inst_36276 = (state_36290[(11)]);
var inst_36281 = (function (){var max_depth = inst_36211;
var recur_map__$1 = inst_36277;
var subjects = inst_36276;
var tuples = inst_36278;
return (function (p1__36200_SHARP_){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.second(p1__36200_SHARP_)],null));
});
})();
var inst_36282 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36281,inst_36278);
var inst_36283 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(inst_36282);
var state_36290__$1 = state_36290;
var statearr_36295_36341 = state_36290__$1;
(statearr_36295_36341[(2)] = inst_36283);

(statearr_36295_36341[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (4))){
var inst_36201 = (state_36290[(2)]);
var state_36290__$1 = state_36290;
var statearr_36296_36342 = state_36290__$1;
(statearr_36296_36342[(2)] = inst_36201);

(statearr_36296_36342[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (15))){
var inst_36224 = (state_36290[(12)]);
var inst_36235 = cljs.core.PersistentVector.EMPTY;
var inst_36236 = cljs.core.seq(inst_36224);
var inst_36237 = cljs.core.first(inst_36236);
var inst_36238 = cljs.core.next(inst_36236);
var inst_36239 = inst_36235;
var inst_36240 = inst_36224;
var state_36290__$1 = (function (){var statearr_36297 = state_36290;
(statearr_36297[(13)] = inst_36237);

(statearr_36297[(14)] = inst_36238);

(statearr_36297[(15)] = inst_36240);

(statearr_36297[(7)] = inst_36239);

return statearr_36297;
})();
var statearr_36298_36343 = state_36290__$1;
(statearr_36298_36343[(2)] = null);

(statearr_36298_36343[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (21))){
var inst_36260 = (state_36290[(2)]);
var state_36290__$1 = state_36290;
var statearr_36299_36344 = state_36290__$1;
(statearr_36299_36344[(2)] = inst_36260);

(statearr_36299_36344[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (13))){
var inst_36273 = (state_36290[(2)]);
var state_36290__$1 = state_36290;
var statearr_36300_36345 = state_36290__$1;
(statearr_36300_36345[(2)] = inst_36273);

(statearr_36300_36345[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (22))){
var inst_36247 = (state_36290[(16)]);
var inst_36239 = (state_36290[(7)]);
var inst_36254 = (state_36290[(2)]);
var inst_36255 = fluree.db.util.async.throw_err(inst_36254);
var inst_36256 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_36239,inst_36255);
var inst_36239__$1 = inst_36256;
var inst_36240 = inst_36247;
var state_36290__$1 = (function (){var statearr_36301 = state_36290;
(statearr_36301[(15)] = inst_36240);

(statearr_36301[(7)] = inst_36239__$1);

return statearr_36301;
})();
var statearr_36302_36346 = state_36290__$1;
(statearr_36302_36346[(2)] = null);

(statearr_36302_36346[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (6))){
var inst_36207 = (state_36290[(17)]);
var state_36290__$1 = state_36290;
var statearr_36303_36347 = state_36290__$1;
(statearr_36303_36347[(2)] = inst_36207);

(statearr_36303_36347[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (25))){
var inst_36285 = (state_36290[(2)]);
var _ = (function (){var statearr_36304 = state_36290;
(statearr_36304[(4)] = cljs.core.rest((state_36290[(4)])));

return statearr_36304;
})();
var state_36290__$1 = state_36290;
var statearr_36305_36348 = state_36290__$1;
(statearr_36305_36348[(2)] = inst_36285);

(statearr_36305_36348[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (17))){
var inst_36246 = (state_36290[(18)]);
var inst_36240 = (state_36290[(15)]);
var inst_36245 = cljs.core.seq(inst_36240);
var inst_36246__$1 = cljs.core.first(inst_36245);
var inst_36247 = cljs.core.next(inst_36245);
var state_36290__$1 = (function (){var statearr_36306 = state_36290;
(statearr_36306[(16)] = inst_36247);

(statearr_36306[(18)] = inst_36246__$1);

return statearr_36306;
})();
if(cljs.core.truth_(inst_36246__$1)){
var statearr_36307_36349 = state_36290__$1;
(statearr_36307_36349[(1)] = (19));

} else {
var statearr_36308_36350 = state_36290__$1;
(statearr_36308_36350[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (3))){
var inst_36288 = (state_36290[(2)]);
var state_36290__$1 = state_36290;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36290__$1,inst_36288);
} else {
if((state_val_36291 === (12))){
var inst_36224 = (state_36290[(12)]);
var inst_36213 = (state_36290[(19)]);
var inst_36219 = cljs.core.vals(inst_36213);
var inst_36220 = cljs.core.flatten(inst_36219);
var inst_36221 = cljs.core.set(inst_36220);
var inst_36222 = cljs.core.keys(inst_36213);
var inst_36223 = cljs.core.set(inst_36222);
var inst_36224__$1 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(inst_36221,inst_36223);
var inst_36225 = cljs.core.empty_QMARK_(inst_36224__$1);
var state_36290__$1 = (function (){var statearr_36309 = state_36290;
(statearr_36309[(12)] = inst_36224__$1);

return statearr_36309;
})();
if(inst_36225){
var statearr_36310_36351 = state_36290__$1;
(statearr_36310_36351[(1)] = (14));

} else {
var statearr_36311_36352 = state_36290__$1;
(statearr_36311_36352[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (2))){
var inst_36207 = (state_36290[(17)]);
var _ = (function (){var statearr_36312 = state_36290;
(statearr_36312[(4)] = cljs.core.cons((5),(state_36290[(4)])));

return statearr_36312;
})();
var inst_36207__$1 = depth;
var state_36290__$1 = (function (){var statearr_36313 = state_36290;
(statearr_36313[(17)] = inst_36207__$1);

return statearr_36313;
})();
if(cljs.core.truth_(inst_36207__$1)){
var statearr_36314_36353 = state_36290__$1;
(statearr_36314_36353[(1)] = (6));

} else {
var statearr_36315_36354 = state_36290__$1;
(statearr_36315_36354[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (23))){
var inst_36278 = (state_36290[(9)]);
var state_36290__$1 = state_36290;
var statearr_36316_36355 = state_36290__$1;
(statearr_36316_36355[(2)] = inst_36278);

(statearr_36316_36355[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (19))){
var inst_36246 = (state_36290[(18)]);
var inst_36249 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36250 = [inst_36246,predicate];
var inst_36251 = (new cljs.core.PersistentVector(null,2,(5),inst_36249,inst_36250,null));
var inst_36252 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_36251);
var state_36290__$1 = state_36290;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36290__$1,(22),inst_36252);
} else {
if((state_val_36291 === (11))){
var inst_36213 = (state_36290[(19)]);
var state_36290__$1 = state_36290;
var statearr_36318_36356 = state_36290__$1;
(statearr_36318_36356[(2)] = inst_36213);

(statearr_36318_36356[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (9))){
var inst_36211 = (state_36290[(10)]);
var inst_36214 = (state_36290[(20)]);
var inst_36216 = (inst_36214 >= inst_36211);
var state_36290__$1 = state_36290;
if(cljs.core.truth_(inst_36216)){
var statearr_36319_36357 = state_36290__$1;
(statearr_36319_36357[(1)] = (11));

} else {
var statearr_36320_36358 = state_36290__$1;
(statearr_36320_36358[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (5))){
var _ = (function (){var statearr_36321 = state_36290;
(statearr_36321[(4)] = cljs.core.rest((state_36290[(4)])));

return statearr_36321;
})();
var state_36290__$1 = state_36290;
var ex36317 = (state_36290__$1[(2)]);
var statearr_36322_36359 = state_36290__$1;
(statearr_36322_36359[(5)] = ex36317);


if((ex36317 instanceof Error)){
var statearr_36323_36360 = state_36290__$1;
(statearr_36323_36360[(1)] = (4));

(statearr_36323_36360[(5)] = null);

} else {
throw ex36317;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (14))){
var inst_36213 = (state_36290[(19)]);
var state_36290__$1 = state_36290;
var statearr_36324_36361 = state_36290__$1;
(statearr_36324_36361[(2)] = inst_36213);

(statearr_36324_36361[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (16))){
var inst_36271 = (state_36290[(2)]);
var state_36290__$1 = state_36290;
var statearr_36325_36362 = state_36290__$1;
(statearr_36325_36362[(2)] = inst_36271);

(statearr_36325_36362[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (10))){
var inst_36277 = (state_36290[(8)]);
var inst_36276 = (state_36290[(11)]);
var inst_36275 = (state_36290[(2)]);
var inst_36276__$1 = cljs.core.keys(inst_36275);
var inst_36277__$1 = fluree.db.query.analytical.follow_all_original_subject_paths(inst_36276__$1,inst_36275);
var inst_36278 = fluree.db.query.analytical.recur_map__GT_tuples(inst_36276__$1,inst_36277__$1);
var state_36290__$1 = (function (){var statearr_36326 = state_36290;
(statearr_36326[(8)] = inst_36277__$1);

(statearr_36326[(9)] = inst_36278);

(statearr_36326[(11)] = inst_36276__$1);

return statearr_36326;
})();
if(cljs.core.truth_(var_first_QMARK_)){
var statearr_36327_36363 = state_36290__$1;
(statearr_36327_36363[(1)] = (23));

} else {
var statearr_36328_36364 = state_36290__$1;
(statearr_36328_36364[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (18))){
var inst_36213 = (state_36290[(19)]);
var inst_36214 = (state_36290[(20)]);
var inst_36262 = (state_36290[(2)]);
var inst_36263 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36264 = [(0),(2)];
var inst_36265 = (new cljs.core.PersistentVector(null,2,(5),inst_36263,inst_36264,null));
var inst_36266 = fluree.db.query.analytical.get_ns_arrays(inst_36265,inst_36262);
var inst_36267 = fluree.db.query.analytical.tuples__GT_map(inst_36213,inst_36266);
var inst_36268 = (inst_36214 + (1));
var inst_36213__$1 = inst_36267;
var inst_36214__$1 = inst_36268;
var state_36290__$1 = (function (){var statearr_36329 = state_36290;
(statearr_36329[(19)] = inst_36213__$1);

(statearr_36329[(20)] = inst_36214__$1);

return statearr_36329;
})();
var statearr_36330_36365 = state_36290__$1;
(statearr_36330_36365[(2)] = null);

(statearr_36330_36365[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36291 === (8))){
var inst_36211 = (state_36290[(2)]);
var inst_36212 = recur_map;
var inst_36213 = inst_36212;
var inst_36214 = (1);
var state_36290__$1 = (function (){var statearr_36331 = state_36290;
(statearr_36331[(10)] = inst_36211);

(statearr_36331[(19)] = inst_36213);

(statearr_36331[(20)] = inst_36214);

return statearr_36331;
})();
var statearr_36332_36366 = state_36290__$1;
(statearr_36332_36366[(2)] = null);

(statearr_36332_36366[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0 = (function (){
var statearr_36333 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36333[(0)] = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__);

(statearr_36333[(1)] = (1));

return statearr_36333;
});
var fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1 = (function (state_36290){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36290);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36334){var ex__16398__auto__ = e36334;
var statearr_36335_36367 = state_36290;
(statearr_36335_36367[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36290[(4)]))){
var statearr_36336_36368 = state_36290;
(statearr_36336_36368[(1)] = cljs.core.first((state_36290[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36369 = state_36290;
state_36290 = G__36369;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__ = function(state_36290){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1.call(this,state_36290);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____0;
fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$tuples__GT_recur_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36337 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36337[(6)] = c__16469__auto__);

return statearr_36337;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.fdb_clause__GT_tuples = (function fluree$db$query$analytical$fdb_clause__GT_tuples(db,p__36370,clause,fuel,max_fuel){
var map__36371 = p__36370;
var map__36371__$1 = cljs.core.__destructure_map(map__36371);
var res = map__36371__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36371__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36371__$1,cljs.core.cst$kw$tuples);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36371__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36482){
var state_val_36483 = (state_36482[(1)]);
if((state_val_36483 === (7))){
var inst_36388 = (state_36482[(7)]);
var state_36482__$1 = state_36482;
var statearr_36484_36537 = state_36482__$1;
(statearr_36484_36537[(2)] = inst_36388);

(statearr_36484_36537[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (20))){
var inst_36416 = (state_36482[(8)]);
var inst_36447 = typeof inst_36416 === 'number';
var state_36482__$1 = state_36482;
if(cljs.core.truth_(inst_36447)){
var statearr_36485_36538 = state_36482__$1;
(statearr_36485_36538[(1)] = (22));

} else {
var statearr_36486_36539 = state_36482__$1;
(statearr_36486_36539[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (27))){
var inst_36462 = (state_36482[(2)]);
var state_36482__$1 = state_36482;
var statearr_36487_36540 = state_36482__$1;
(statearr_36487_36540[(2)] = inst_36462);

(statearr_36487_36540[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (1))){
var state_36482__$1 = state_36482;
var statearr_36488_36541 = state_36482__$1;
(statearr_36488_36541[(2)] = null);

(statearr_36488_36541[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (24))){
var inst_36464 = (state_36482[(2)]);
var state_36482__$1 = state_36482;
var statearr_36489_36542 = state_36482__$1;
(statearr_36489_36542[(2)] = inst_36464);

(statearr_36489_36542[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (4))){
var inst_36372 = (state_36482[(2)]);
var state_36482__$1 = state_36482;
var statearr_36490_36543 = state_36482__$1;
(statearr_36490_36543[(2)] = inst_36372);

(statearr_36490_36543[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (15))){
var inst_36430 = (state_36482[(2)]);
var inst_36431 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,(2));
var inst_36432 = fluree.db.query.analytical.variable_QMARK_(inst_36431);
var state_36482__$1 = (function (){var statearr_36491 = state_36482;
(statearr_36491[(9)] = inst_36430);

return statearr_36491;
})();
if(cljs.core.truth_(inst_36432)){
var statearr_36492_36544 = state_36482__$1;
(statearr_36492_36544[(1)] = (16));

} else {
var statearr_36493_36545 = state_36482__$1;
(statearr_36493_36545[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (21))){
var inst_36418 = (state_36482[(10)]);
var inst_36419 = (state_36482[(11)]);
var inst_36389 = (state_36482[(12)]);
var inst_36466 = (state_36482[(2)]);
var inst_36467 = fluree.db.query.analytical.tuples__GT_recur(db,inst_36419,inst_36466,inst_36389,inst_36418);
var state_36482__$1 = state_36482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36482__$1,(28),inst_36467);
} else {
if((state_val_36483 === (13))){
var inst_36398 = (state_36482[(13)]);
var inst_36422 = ["Cannot use predicate recursion when predicate is variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36398)].join('');
var inst_36423 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36424 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36425 = cljs.core.PersistentHashMap.fromArrays(inst_36423,inst_36424);
var inst_36426 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36422,inst_36425);
var inst_36427 = (function(){throw inst_36426})();
var state_36482__$1 = state_36482;
var statearr_36494_36546 = state_36482__$1;
(statearr_36494_36546[(2)] = inst_36427);

(statearr_36494_36546[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (22))){
var inst_36416 = (state_36482[(8)]);
var inst_36414 = (state_36482[(14)]);
var inst_36449 = cljs.core.PersistentHashMap.EMPTY;
var inst_36450 = cljs.core.flatten(inst_36414);
var inst_36451 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36449,inst_36416,inst_36450);
var state_36482__$1 = state_36482;
var statearr_36495_36547 = state_36482__$1;
(statearr_36495_36547[(2)] = inst_36451);

(statearr_36495_36547[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (6))){
var inst_36400 = (state_36482[(15)]);
var state_36482__$1 = state_36482;
var statearr_36496_36548 = state_36482__$1;
(statearr_36496_36548[(2)] = inst_36400);

(statearr_36496_36548[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (28))){
var inst_36469 = (state_36482[(2)]);
var inst_36470 = fluree.db.util.async.throw_err(inst_36469);
var state_36482__$1 = state_36482;
var statearr_36497_36549 = state_36482__$1;
(statearr_36497_36549[(2)] = inst_36470);

(statearr_36497_36549[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (25))){
var inst_36410 = (state_36482[(16)]);
var inst_36414 = (state_36482[(14)]);
var inst_36455 = cljs.core.PersistentHashMap.EMPTY;
var inst_36456 = cljs.core.first(inst_36410);
var inst_36457 = cljs.core.first(inst_36456);
var inst_36458 = cljs.core.flatten(inst_36414);
var inst_36459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_36455,inst_36457,inst_36458);
var state_36482__$1 = state_36482;
var statearr_36498_36550 = state_36482__$1;
(statearr_36498_36550[(2)] = inst_36459);

(statearr_36498_36550[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (17))){
var inst_36398 = (state_36482[(13)]);
var inst_36435 = ["Cannot use predicate recursion when object is not a variable. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36398)].join('');
var inst_36436 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36437 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36438 = cljs.core.PersistentHashMap.fromArrays(inst_36436,inst_36437);
var inst_36439 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_36435,inst_36438);
var inst_36440 = (function(){throw inst_36439})();
var state_36482__$1 = state_36482;
var statearr_36499_36551 = state_36482__$1;
(statearr_36499_36551[(2)] = inst_36440);

(statearr_36499_36551[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (3))){
var inst_36480 = (state_36482[(2)]);
var state_36482__$1 = state_36482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36482__$1,inst_36480);
} else {
if((state_val_36483 === (12))){
var inst_36385 = (state_36482[(17)]);
var inst_36473 = (state_36482[(2)]);
var inst_36474 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_36475 = cljs.core.keys(inst_36385);
var inst_36476 = [inst_36475,vars,inst_36473];
var inst_36477 = cljs.core.PersistentHashMap.fromArrays(inst_36474,inst_36476);
var _ = (function (){var statearr_36500 = state_36482;
(statearr_36500[(4)] = cljs.core.rest((state_36482[(4)])));

return statearr_36500;
})();
var state_36482__$1 = state_36482;
var statearr_36501_36552 = state_36482__$1;
(statearr_36501_36552[(2)] = inst_36477);

(statearr_36501_36552[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (2))){
var inst_36400 = (state_36482[(15)]);
var inst_36389 = (state_36482[(12)]);
var inst_36388 = (state_36482[(7)]);
var inst_36385 = (state_36482[(17)]);
var _ = (function (){var statearr_36502 = state_36482;
(statearr_36502[(4)] = cljs.core.cons((5),(state_36482[(4)])));

return statearr_36502;
})();
var inst_36382 = fluree.db.query.analytical.clause__GT_rel(db,vars,clause);
var inst_36383 = cljs.core.__destructure_map(inst_36382);
var inst_36384 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36383,cljs.core.cst$kw$search);
var inst_36385__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36383,cljs.core.cst$kw$rel);
var inst_36386 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36383,cljs.core.cst$kw$opts);
var inst_36387 = fluree.db.query.analytical.intersecting_keys_tuples_clause(res,clause);
var inst_36388__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36386);
var inst_36389__$1 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_36386);
var inst_36391 = (function (){var map__36378 = inst_36383;
var search = inst_36384;
var rel = inst_36385__$1;
var opts = inst_36386;
var common_keys = inst_36387;
var object_fn = inst_36388__$1;
var recur_depth = inst_36389__$1;
return (function (p__36390,common_key){
var vec__36503 = p__36390;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36503,(0),null);
var clause_SINGLEQUOTE_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36503,(1),null);
var idx_of = fluree.db.util.core.index_of(clause,cljs.core.str.cljs$core$IFn$_invoke$arity$1(common_key));
var k = (function (){var pred__36506 = cljs.core._EQ_;
var expr__36507 = idx_of;
if(cljs.core.truth_((pred__36506.cljs$core$IFn$_invoke$arity$2 ? pred__36506.cljs$core$IFn$_invoke$arity$2((0),expr__36507) : pred__36506.call(null,(0),expr__36507)))){
return cljs.core.cst$kw$subject_DASH_fn;
} else {
if(cljs.core.truth_((pred__36506.cljs$core$IFn$_invoke$arity$2 ? pred__36506.cljs$core$IFn$_invoke$arity$2((1),expr__36507) : pred__36506.call(null,(1),expr__36507)))){
return cljs.core.cst$kw$predicate_DASH_fn;
} else {
if(cljs.core.truth_((pred__36506.cljs$core$IFn$_invoke$arity$2 ? pred__36506.cljs$core$IFn$_invoke$arity$2((2),expr__36507) : pred__36506.call(null,(2),expr__36507)))){
return cljs.core.cst$kw$object_DASH_fn;
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__36507)].join('')));
}
}
}
})();
var res_idx = fluree.db.util.core.index_of(headers,common_key);
var v = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashSet.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,fluree.db.query.analytical.get_ns_arrays(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [res_idx], null),tuples)));
var single_v_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(v));
var v__$1 = (cljs.core.truth_((function (){var and__4210__auto__ = (!(single_v_QMARK_));
if(and__4210__auto__){
var and__4210__auto____$1 = object_fn;
if(cljs.core.truth_(and__4210__auto____$1)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,object_fn);
} else {
return and__4210__auto____$1;
}
} else {
return and__4210__auto__;
}
})())?cljs.core.comp.cljs$core$IFn$_invoke$arity$2(v,object_fn):v);
if(single_v_QMARK_){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(clause_SINGLEQUOTE_,idx_of,cljs.core.first(v__$1))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,k,v__$1),clause_SINGLEQUOTE_], null);
}
});
})();
var inst_36392 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36393 = cljs.core.PersistentHashMap.EMPTY;
var inst_36394 = [inst_36393,inst_36384];
var inst_36395 = (new cljs.core.PersistentVector(null,2,(5),inst_36392,inst_36394,null));
var inst_36396 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36391,inst_36395,inst_36387);
var inst_36397 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36396,(0),null);
var inst_36398 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36396,(1),null);
var inst_36399 = [cljs.core.cst$kw$object_DASH_fn];
var inst_36400__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(inst_36397);
var state_36482__$1 = (function (){var statearr_36509 = state_36482;
(statearr_36509[(18)] = inst_36399);

(statearr_36509[(13)] = inst_36398);

(statearr_36509[(15)] = inst_36400__$1);

(statearr_36509[(12)] = inst_36389__$1);

(statearr_36509[(7)] = inst_36388__$1);

(statearr_36509[(17)] = inst_36385__$1);

return statearr_36509;
})();
if(cljs.core.truth_(inst_36400__$1)){
var statearr_36510_36553 = state_36482__$1;
(statearr_36510_36553[(1)] = (6));

} else {
var statearr_36511_36554 = state_36482__$1;
(statearr_36511_36554[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (23))){
var inst_36416 = (state_36482[(8)]);
var inst_36453 = cljs.core.coll_QMARK_(inst_36416);
var state_36482__$1 = state_36482;
if(inst_36453){
var statearr_36512_36555 = state_36482__$1;
(statearr_36512_36555[(1)] = (25));

} else {
var statearr_36513_36556 = state_36482__$1;
(statearr_36513_36556[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (19))){
var inst_36414 = (state_36482[(14)]);
var inst_36444 = cljs.core.PersistentHashMap.EMPTY;
var inst_36445 = fluree.db.query.analytical.tuples__GT_map(inst_36444,inst_36414);
var state_36482__$1 = state_36482;
var statearr_36514_36557 = state_36482__$1;
(statearr_36514_36557[(2)] = inst_36445);

(statearr_36514_36557[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (11))){
var inst_36414 = (state_36482[(14)]);
var state_36482__$1 = state_36482;
var statearr_36516_36558 = state_36482__$1;
(statearr_36516_36558[(2)] = inst_36414);

(statearr_36516_36558[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (9))){
var inst_36410 = (state_36482[(16)]);
var inst_36389 = (state_36482[(12)]);
var inst_36385 = (state_36482[(17)]);
var inst_36409 = (state_36482[(2)]);
var inst_36410__$1 = fluree.db.util.async.throw_err(inst_36409);
var inst_36411 = cljs.core.count(inst_36410__$1);
var inst_36412 = fluree.db.query.analytical.add_fuel(inst_36411,fuel,max_fuel);
var inst_36413 = cljs.core.vals(inst_36385);
var inst_36414 = fluree.db.query.analytical.get_ns_arrays(inst_36413,inst_36410__$1);
var state_36482__$1 = (function (){var statearr_36517 = state_36482;
(statearr_36517[(16)] = inst_36410__$1);

(statearr_36517[(19)] = inst_36412);

(statearr_36517[(14)] = inst_36414);

return statearr_36517;
})();
if(cljs.core.truth_(inst_36389)){
var statearr_36518_36559 = state_36482__$1;
(statearr_36518_36559[(1)] = (10));

} else {
var statearr_36519_36560 = state_36482__$1;
(statearr_36519_36560[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (5))){
var _ = (function (){var statearr_36520 = state_36482;
(statearr_36520[(4)] = cljs.core.rest((state_36482[(4)])));

return statearr_36520;
})();
var state_36482__$1 = state_36482;
var ex36515 = (state_36482__$1[(2)]);
var statearr_36521_36561 = state_36482__$1;
(statearr_36521_36561[(5)] = ex36515);


if((ex36515 instanceof Error)){
var statearr_36522_36562 = state_36482__$1;
(statearr_36522_36562[(1)] = (4));

(statearr_36522_36562[(5)] = null);

} else {
throw ex36515;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (14))){
var state_36482__$1 = state_36482;
var statearr_36523_36563 = state_36482__$1;
(statearr_36523_36563[(2)] = null);

(statearr_36523_36563[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (26))){
var state_36482__$1 = state_36482;
var statearr_36524_36564 = state_36482__$1;
(statearr_36524_36564[(2)] = null);

(statearr_36524_36564[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (16))){
var state_36482__$1 = state_36482;
var statearr_36525_36565 = state_36482__$1;
(statearr_36525_36565[(2)] = null);

(statearr_36525_36565[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (10))){
var inst_36398 = (state_36482[(13)]);
var inst_36419 = (state_36482[(11)]);
var inst_36416 = cljs.core.first(inst_36398);
var inst_36417 = cljs.core.first(clause);
var inst_36418 = fluree.db.query.analytical.variable_QMARK_(inst_36417);
var inst_36419__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(inst_36398,(1));
var inst_36420 = fluree.db.query.analytical.variable_QMARK_(inst_36419__$1);
var state_36482__$1 = (function (){var statearr_36526 = state_36482;
(statearr_36526[(10)] = inst_36418);

(statearr_36526[(11)] = inst_36419__$1);

(statearr_36526[(8)] = inst_36416);

return statearr_36526;
})();
if(cljs.core.truth_(inst_36420)){
var statearr_36527_36566 = state_36482__$1;
(statearr_36527_36566[(1)] = (13));

} else {
var statearr_36528_36567 = state_36482__$1;
(statearr_36528_36567[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (18))){
var inst_36418 = (state_36482[(10)]);
var inst_36442 = (state_36482[(2)]);
var state_36482__$1 = (function (){var statearr_36529 = state_36482;
(statearr_36529[(20)] = inst_36442);

return statearr_36529;
})();
if(cljs.core.truth_(inst_36418)){
var statearr_36530_36568 = state_36482__$1;
(statearr_36530_36568[(1)] = (19));

} else {
var statearr_36531_36569 = state_36482__$1;
(statearr_36531_36569[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36483 === (8))){
var inst_36399 = (state_36482[(18)]);
var inst_36398 = (state_36482[(13)]);
var inst_36404 = (state_36482[(2)]);
var inst_36405 = [inst_36404];
var inst_36406 = cljs.core.PersistentHashMap.fromArrays(inst_36399,inst_36405);
var inst_36407 = fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,inst_36398,inst_36406);
var state_36482__$1 = state_36482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36482__$1,(9),inst_36407);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_36532 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36532[(0)] = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__);

(statearr_36532[(1)] = (1));

return statearr_36532;
});
var fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1 = (function (state_36482){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36482);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36533){var ex__16398__auto__ = e36533;
var statearr_36534_36570 = state_36482;
(statearr_36534_36570[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36482[(4)]))){
var statearr_36535_36571 = state_36482;
(statearr_36535_36571[(1)] = cljs.core.first((state_36482[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36572 = state_36482;
state_36482 = G__36572;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__ = function(state_36482){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1.call(this,state_36482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$fdb_clause__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36536 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36536[(6)] = c__16469__auto__);

return statearr_36536;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.full_text__GT_tuples = (function fluree$db$query$analytical$full_text__GT_tuples(p__36573,res,clause){
var map__36574 = p__36573;
var map__36574__$1 = cljs.core.__destructure_map(map__36574);
var db = map__36574__$1;
var conn = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36574__$1,cljs.core.cst$kw$conn);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36574__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36574__$1,cljs.core.cst$kw$dbid);
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Full text search is not supported in JS",new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
});
fluree.db.query.analytical.collection__GT_tuples = (function fluree$db$query$analytical$collection__GT_tuples(db,res,clause){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36673){
var state_val_36674 = (state_36673[(1)]);
if((state_val_36674 === (7))){
var inst_36584 = (state_36673[(7)]);
var state_36673__$1 = state_36673;
var statearr_36675_36715 = state_36673__$1;
(statearr_36675_36715[(2)] = inst_36584);

(statearr_36675_36715[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (20))){
var inst_36664 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
var statearr_36676_36716 = state_36673__$1;
(statearr_36676_36716[(2)] = inst_36664);

(statearr_36676_36716[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (1))){
var state_36673__$1 = state_36673;
var statearr_36677_36717 = state_36673__$1;
(statearr_36677_36717[(2)] = null);

(statearr_36677_36717[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (24))){
var inst_36643 = (state_36673[(2)]);
var inst_36644 = fluree.db.util.async.throw_err(inst_36643);
var state_36673__$1 = state_36673;
var statearr_36678_36718 = state_36673__$1;
(statearr_36678_36718[(2)] = inst_36644);

(statearr_36678_36718[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (4))){
var inst_36577 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
var statearr_36679_36719 = state_36673__$1;
(statearr_36679_36719[(2)] = inst_36577);

(statearr_36679_36719[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (15))){
var inst_36586 = (state_36673[(8)]);
var inst_36584 = (state_36673[(7)]);
var inst_36605 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_36606 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36607 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36608 = [inst_36584];
var inst_36609 = (new cljs.core.PersistentVector(null,1,(5),inst_36607,inst_36608,null));
var inst_36610 = (function (){var subject_var = inst_36584;
var object_var = inst_36586;
var min_sid = inst_36605;
var max_sid = (0);
return (function (p1__36575_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36575_SHARP_);
});
})();
var inst_36611 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36605,(0));
var inst_36612 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36610,inst_36611);
var inst_36613 = cljs.core.PersistentHashMap.EMPTY;
var inst_36614 = [inst_36609,inst_36612,inst_36613];
var inst_36615 = cljs.core.PersistentHashMap.fromArrays(inst_36606,inst_36614);
var state_36673__$1 = state_36673;
var statearr_36680_36720 = state_36673__$1;
(statearr_36680_36720[(2)] = inst_36615);

(statearr_36680_36720[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (21))){
var inst_36637 = (state_36673[(9)]);
var state_36673__$1 = state_36673;
var statearr_36681_36721 = state_36673__$1;
(statearr_36681_36721[(2)] = inst_36637);

(statearr_36681_36721[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (13))){
var inst_36586 = (state_36673[(8)]);
var state_36673__$1 = state_36673;
if(cljs.core.truth_(inst_36586)){
var statearr_36682_36722 = state_36673__$1;
(statearr_36682_36722[(1)] = (18));

} else {
var statearr_36683_36723 = state_36673__$1;
(statearr_36683_36723[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (22))){
var inst_36637 = (state_36673[(9)]);
var inst_36641 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_36637);
var state_36673__$1 = state_36673;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36673__$1,(24),inst_36641);
} else {
if((state_val_36674 === (6))){
var inst_36586 = (state_36673[(8)]);
var state_36673__$1 = state_36673;
var statearr_36684_36724 = state_36673__$1;
(statearr_36684_36724[(2)] = inst_36586);

(statearr_36684_36724[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (17))){
var inst_36634 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
var statearr_36685_36725 = state_36673__$1;
(statearr_36685_36725[(2)] = inst_36634);

(statearr_36685_36725[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (3))){
var inst_36671 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36673__$1,inst_36671);
} else {
if((state_val_36674 === (12))){
var inst_36599 = ["_tx",null,"_block",null];
var inst_36600 = (new cljs.core.PersistentArrayMap(null,2,inst_36599,null));
var inst_36601 = (new cljs.core.PersistentHashSet(null,inst_36600,null));
var inst_36602 = cljs.core.last(clause);
var inst_36603 = (inst_36601.cljs$core$IFn$_invoke$arity$1 ? inst_36601.cljs$core$IFn$_invoke$arity$1(inst_36602) : inst_36601.call(null,inst_36602));
var state_36673__$1 = state_36673;
if(cljs.core.truth_(inst_36603)){
var statearr_36686_36726 = state_36673__$1;
(statearr_36686_36726[(1)] = (15));

} else {
var statearr_36687_36727 = state_36673__$1;
(statearr_36687_36727[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (2))){
var inst_36584 = (state_36673[(7)]);
var _ = (function (){var statearr_36688 = state_36673;
(statearr_36688[(4)] = cljs.core.cons((5),(state_36673[(4)])));

return statearr_36688;
})();
var inst_36583 = cljs.core.first(clause);
var inst_36584__$1 = fluree.db.query.analytical.variable_QMARK_(inst_36583);
var inst_36585 = cljs.core.last(clause);
var inst_36586 = fluree.db.query.analytical.variable_QMARK_(inst_36585);
var state_36673__$1 = (function (){var statearr_36689 = state_36673;
(statearr_36689[(8)] = inst_36586);

(statearr_36689[(7)] = inst_36584__$1);

return statearr_36689;
})();
if(cljs.core.truth_(inst_36584__$1)){
var statearr_36690_36728 = state_36673__$1;
(statearr_36690_36728[(1)] = (6));

} else {
var statearr_36691_36729 = state_36673__$1;
(statearr_36691_36729[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (23))){
var inst_36586 = (state_36673[(8)]);
var inst_36646 = (state_36673[(2)]);
var inst_36647 = fluree.db.flake.sid__GT_cid(inst_36646);
var inst_36648 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$name,inst_36647);
var inst_36649 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36650 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36651 = [inst_36586];
var inst_36652 = (new cljs.core.PersistentVector(null,1,(5),inst_36650,inst_36651,null));
var inst_36653 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36654 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36655 = [inst_36648];
var inst_36656 = (new cljs.core.PersistentVector(null,1,(5),inst_36654,inst_36655,null));
var inst_36657 = [inst_36656];
var inst_36658 = (new cljs.core.PersistentVector(null,1,(5),inst_36653,inst_36657,null));
var inst_36659 = cljs.core.PersistentHashMap.EMPTY;
var inst_36660 = [inst_36652,inst_36658,inst_36659];
var inst_36661 = cljs.core.PersistentHashMap.fromArrays(inst_36649,inst_36660);
var state_36673__$1 = state_36673;
var statearr_36692_36730 = state_36673__$1;
(statearr_36692_36730[(2)] = inst_36661);

(statearr_36692_36730[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (19))){
var state_36673__$1 = state_36673;
var statearr_36693_36731 = state_36673__$1;
(statearr_36693_36731[(2)] = null);

(statearr_36693_36731[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (11))){
var inst_36668 = (state_36673[(2)]);
var _ = (function (){var statearr_36695 = state_36673;
(statearr_36695[(4)] = cljs.core.rest((state_36673[(4)])));

return statearr_36695;
})();
var state_36673__$1 = state_36673;
var statearr_36696_36732 = state_36673__$1;
(statearr_36696_36732[(2)] = inst_36668);

(statearr_36696_36732[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (9))){
var inst_36592 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_36593 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_36594 = cljs.core.PersistentHashMap.fromArrays(inst_36592,inst_36593);
var inst_36595 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("When using rdf:type, either a subject or a type (collection) must be specified.",inst_36594);
var inst_36596 = (function(){throw inst_36595})();
var state_36673__$1 = state_36673;
var statearr_36697_36733 = state_36673__$1;
(statearr_36697_36733[(2)] = inst_36596);

(statearr_36697_36733[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (5))){
var _ = (function (){var statearr_36698 = state_36673;
(statearr_36698[(4)] = cljs.core.rest((state_36673[(4)])));

return statearr_36698;
})();
var state_36673__$1 = state_36673;
var ex36694 = (state_36673__$1[(2)]);
var statearr_36699_36734 = state_36673__$1;
(statearr_36699_36734[(5)] = ex36694);


if((ex36694 instanceof Error)){
var statearr_36700_36735 = state_36673__$1;
(statearr_36700_36735[(1)] = (4));

(statearr_36700_36735[(5)] = null);

} else {
throw ex36694;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (14))){
var inst_36666 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
var statearr_36701_36736 = state_36673__$1;
(statearr_36701_36736[(2)] = inst_36666);

(statearr_36701_36736[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (16))){
var inst_36586 = (state_36673[(8)]);
var inst_36584 = (state_36673[(7)]);
var inst_36617 = cljs.core.last(clause);
var inst_36618 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,inst_36617);
var inst_36619 = cljs.core.cst$kw$ecount.cljs$core$IFn$_invoke$arity$1(db);
var inst_36620 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_36619,inst_36618);
var inst_36621 = fluree.db.flake.min_subject_id(inst_36618);
var inst_36622 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$tuples,cljs.core.cst$kw$vars];
var inst_36623 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36624 = [inst_36584];
var inst_36625 = (new cljs.core.PersistentVector(null,1,(5),inst_36623,inst_36624,null));
var inst_36626 = (function (){var subject_var = inst_36584;
var object_var = inst_36586;
var partition = inst_36618;
var max_sid = inst_36620;
var min_sid = inst_36621;
return (function (p1__36576_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,p1__36576_SHARP_);
});
})();
var inst_36627 = (inst_36620 + (1));
var inst_36628 = cljs.core.range.cljs$core$IFn$_invoke$arity$2(inst_36621,inst_36627);
var inst_36629 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_36626,inst_36628);
var inst_36630 = cljs.core.PersistentHashMap.EMPTY;
var inst_36631 = [inst_36625,inst_36629,inst_36630];
var inst_36632 = cljs.core.PersistentHashMap.fromArrays(inst_36622,inst_36631);
var state_36673__$1 = state_36673;
var statearr_36702_36737 = state_36673__$1;
(statearr_36702_36737[(2)] = inst_36632);

(statearr_36702_36737[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (10))){
var inst_36584 = (state_36673[(7)]);
var state_36673__$1 = state_36673;
if(cljs.core.truth_(inst_36584)){
var statearr_36703_36738 = state_36673__$1;
(statearr_36703_36738[(1)] = (12));

} else {
var statearr_36704_36739 = state_36673__$1;
(statearr_36704_36739[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (18))){
var inst_36637 = (state_36673[(9)]);
var inst_36637__$1 = cljs.core.first(clause);
var inst_36638 = typeof inst_36637__$1 === 'number';
var state_36673__$1 = (function (){var statearr_36705 = state_36673;
(statearr_36705[(9)] = inst_36637__$1);

return statearr_36705;
})();
if(cljs.core.truth_(inst_36638)){
var statearr_36706_36740 = state_36673__$1;
(statearr_36706_36740[(1)] = (21));

} else {
var statearr_36707_36741 = state_36673__$1;
(statearr_36707_36741[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36674 === (8))){
var inst_36590 = (state_36673[(2)]);
var state_36673__$1 = state_36673;
if(cljs.core.truth_(inst_36590)){
var statearr_36708_36742 = state_36673__$1;
(statearr_36708_36742[(1)] = (9));

} else {
var statearr_36709_36743 = state_36673__$1;
(statearr_36709_36743[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_36710 = [null,null,null,null,null,null,null,null,null,null];
(statearr_36710[(0)] = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__);

(statearr_36710[(1)] = (1));

return statearr_36710;
});
var fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1 = (function (state_36673){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36673);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36711){var ex__16398__auto__ = e36711;
var statearr_36712_36744 = state_36673;
(statearr_36712_36744[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36673[(4)]))){
var statearr_36713_36745 = state_36673;
(statearr_36713_36745[(1)] = cljs.core.first((state_36673[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36746 = state_36673;
state_36673 = G__36746;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__ = function(state_36673){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1.call(this,state_36673);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$collection__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36714 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36714[(6)] = c__16469__auto__);

return statearr_36714;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.all_functions = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 41, ["isIRI",null,"YEAR",null,"UCASE",null,"isBLANK",null,"MONTH",null,"STRSTARTS",null,"sameTerm",null,"NOW",null,"MINUTES",null,"isURI",null,"IF",null,"COALESCE",null,"STRLEN",null,"CONCAT",null,"CONTAINS",null,"SHA512",null,"CEIL",null,"SECONDS",null,"SHA384",null,"RAND",null,"TZ",null,"isNUMERIC",null,"STRENDS",null,"STRAFTER",null,"ENCODE_FOR_URI",null,"HOURS",null,"LCASE",null,"STRDT",null,"FLOOR",null,"SHA1",null,"STRBEFORE",null,"STR",null,"TIMEZONE",null,"DAY",null,"SHA256",null,"isLITERAL",null,"STRUUID",null,"MD5",null,"ABS",null,"STRLANG",null,"UUID",null], null), null);
fluree.db.query.analytical.built_in_aggregates = (function (){var sum = (function fluree$db$query$analytical$sum(coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._PLUS_,(0),coll);
});
var avg = (function fluree$db$query$analytical$avg(coll){
return (sum(coll) / cljs.core.count(coll));
});
var median = (function fluree$db$query$analytical$median(coll){
var terms = cljs.core.sort.cljs$core$IFn$_invoke$arity$1(coll);
var size = cljs.core.count(coll);
var med = (size >> (1));
var G__36753 = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,med);
if(cljs.core.even_QMARK_(size)){
return ((G__36753 + cljs.core.nth.cljs$core$IFn$_invoke$arity$2(terms,(med - (1)))) / (2));
} else {
return G__36753;
}
});
var variance = (function fluree$db$query$analytical$variance(coll){
var mean = avg(coll);
var sum__$1 = sum((function (){var iter__4611__auto__ = (function fluree$db$query$analytical$variance_$_iter__36754(s__36755){
return (new cljs.core.LazySeq(null,(function (){
var s__36755__$1 = s__36755;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__36755__$1);
if(temp__5753__auto__){
var s__36755__$2 = temp__5753__auto__;
if(cljs.core.chunked_seq_QMARK_(s__36755__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__36755__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__36757 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__36756 = (0);
while(true){
if((i__36756 < size__4610__auto__)){
var x = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__36756);
var delta = (x - mean);
cljs.core.chunk_append(b__36757,(delta * delta));

var G__36759 = (i__36756 + (1));
i__36756 = G__36759;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__36757),fluree$db$query$analytical$variance_$_iter__36754(cljs.core.chunk_rest(s__36755__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__36757),null);
}
} else {
var x = cljs.core.first(s__36755__$2);
var delta = (x - mean);
return cljs.core.cons((delta * delta),fluree$db$query$analytical$variance_$_iter__36754(cljs.core.rest(s__36755__$2)));
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(coll);
})());
return (sum__$1 / cljs.core.count(coll));
});
var stddev = (function fluree$db$query$analytical$stddev(coll){
var G__36758 = variance(coll);
return Math.sqrt(G__36758);
});
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$sym$variance,cljs.core.cst$sym$count,cljs.core.cst$sym$median,cljs.core.cst$sym$groupconcat,cljs.core.cst$sym$sum,cljs.core.cst$sym$abs,cljs.core.cst$sym$min,cljs.core.cst$sym$ceil,cljs.core.cst$sym$max,cljs.core.cst$sym$count_DASH_distinct,cljs.core.cst$sym$avg,cljs.core.cst$sym$floor,cljs.core.cst$sym$str,cljs.core.cst$sym$stddev,cljs.core.cst$sym$rand,cljs.core.cst$sym$sample],[variance,cljs.core.count,median,cljs.core.concat,sum,(function (n){
var x__4295__auto__ = n;
var y__4296__auto__ = (- n);
return ((x__4295__auto__ > y__4296__auto__) ? x__4295__auto__ : y__4296__auto__);
}),(function() {
var G__36760 = null;
var G__36760__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) < (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36760__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.last(acc)) < (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.butlast(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36760 = function(n,coll){
switch(arguments.length){
case 1:
return G__36760__1.call(this,n);
case 2:
return G__36760__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36760.cljs$core$IFn$_invoke$arity$1 = G__36760__1;
G__36760.cljs$core$IFn$_invoke$arity$2 = G__36760__2;
return G__36760;
})()
,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return ((n | (0)) + (1));
} else {
if((n < (0))){
return (n | (0));
} else {
return null;
}
}
}
}),(function() {
var G__36761 = null;
var G__36761__1 = (function (coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.compare(x,acc) > (0))){
return x;
} else {
return acc;
}
}),cljs.core.first(coll),cljs.core.next(coll));
});
var G__36761__2 = (function (n,coll){
return cljs.core.vec(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,x){
if((cljs.core.count(acc) < n)){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,x));
} else {
if((cljs.core.compare(x,cljs.core.first(acc)) > (0))){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.next(acc),x));
} else {
return acc;

}
}
}),cljs.core.PersistentVector.EMPTY,coll));
});
G__36761 = function(n,coll){
switch(arguments.length){
case 1:
return G__36761__1.call(this,n);
case 2:
return G__36761__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36761.cljs$core$IFn$_invoke$arity$1 = G__36761__1;
G__36761.cljs$core$IFn$_invoke$arity$2 = G__36761__2;
return G__36761;
})()
,(function (coll){
return cljs.core.count(cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll));
}),avg,(function (n){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(n,(n | (0)))){
return n;
} else {
if((n > (0))){
return (n | (0));
} else {
if((n < (0))){
return ((n | (0)) - (1));
} else {
return null;
}
}
}
}),cljs.core.str,stddev,(function() {
var G__36762 = null;
var G__36762__1 = (function (coll){
return cljs.core.rand_nth(coll);
});
var G__36762__2 = (function (n,coll){
return cljs.core.vec(cljs.core.repeatedly.cljs$core$IFn$_invoke$arity$2(n,(function (){
return cljs.core.rand_nth(coll);
})));
});
G__36762 = function(n,coll){
switch(arguments.length){
case 1:
return G__36762__1.call(this,n);
case 2:
return G__36762__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__36762.cljs$core$IFn$_invoke$arity$1 = G__36762__1;
G__36762.cljs$core$IFn$_invoke$arity$2 = G__36762__2;
return G__36762;
})()
,(function (n,coll){
return cljs.core.vec(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.shuffle(coll)));
})]);
})();
fluree.db.query.analytical.aggregate_QMARK_ = (function fluree$db$query$analytical$aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.interm_aggregate_QMARK_ = (function fluree$db$query$analytical$interm_aggregate_QMARK_(x){
var and__4210__auto__ = typeof x === 'string';
if(and__4210__auto__){
return cljs.core.re_matches(/^#\(.+\)$/,x);
} else {
return and__4210__auto__;
}
});
fluree.db.query.analytical.parse_aggregate = (function fluree$db$query$analytical$parse_aggregate(x,valid_var){
var list_agg = cljs.reader.read_string.cljs$core$IFn$_invoke$arity$1(x);
var as_QMARK_ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$as,cljs.core.first(list_agg));
var as = ((as_QMARK_)?cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.last(list_agg))].join('')):cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(["?",cljs.core.str.cljs$core$IFn$_invoke$arity$1(list_agg)].join('')));
var func_list = ((as_QMARK_)?(function (){var func_list = cljs.core.second(list_agg);
if(cljs.core.coll_QMARK_(func_list)){
return func_list;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection. As can only be used in conjunction with other functions. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})():list_agg);
var list_count = cljs.core.count(func_list);
var vec__36763 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),cljs.core.second(func_list),cljs.core.last(func_list)], null):((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$sym$sample,cljs.core.first(func_list)))))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["The sample aggregate function takes two arguments: n and a variable, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),list_count))?new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(func_list),null,cljs.core.last(func_list)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
)));
var fun = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36763,(0),null);
var arg = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36763,(1),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36763,(2),null);
var agg_fn = (function (){var temp__5751__auto__ = (fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1 ? fluree.db.query.analytical.built_in_aggregates.cljs$core$IFn$_invoke$arity$1(fun) : fluree.db.query.analytical.built_in_aggregates.call(null,fun));
if(cljs.core.truth_(temp__5751__auto__)){
var agg_fn = temp__5751__auto__;
if(cljs.core.truth_(arg)){
return (function (coll){
return (agg_fn.cljs$core$IFn$_invoke$arity$2 ? agg_fn.cljs$core$IFn$_invoke$arity$2(arg,coll) : agg_fn.call(null,arg,coll));
});
} else {
return agg_fn;
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection function, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vec__36766 = (function (){var distinct_QMARK_ = ((cljs.core.coll_QMARK_(var$)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(var$),cljs.core.cst$sym$distinct)));
var variable = ((distinct_QMARK_)?cljs.core.second(var$):var$);
var agg_fn__$1 = ((distinct_QMARK_)?(function (coll){
var G__36769 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$1(coll);
return (agg_fn.cljs$core$IFn$_invoke$arity$1 ? agg_fn.cljs$core$IFn$_invoke$arity$1(G__36769) : agg_fn.call(null,G__36769));
}):agg_fn);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [agg_fn__$1,variable], null);
})();
var agg_fn__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36766,(0),null);
var variable = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36766,(1),null);
var _ = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(variable) : valid_var.call(null,variable)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$variable,variable,cljs.core.cst$kw$as,as,cljs.core.cst$kw$code,agg_fn__$1], null);
});
fluree.db.query.analytical.calculate_aggregate = (function fluree$db$query$analytical$calculate_aggregate(res,agg){
var map__36770 = agg;
var map__36770__$1 = cljs.core.__destructure_map(map__36770);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36770__$1,cljs.core.cst$kw$variable);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36770__$1,cljs.core.cst$kw$as);
var code = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36770__$1,cljs.core.cst$kw$code);
var agg_params = cljs.core.flatten(fluree.db.query.analytical.select_from_tuples(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [variable], null),res));
var agg_result = (code.cljs$core$IFn$_invoke$arity$1 ? code.cljs$core$IFn$_invoke$arity$1(agg_params) : code.call(null,agg_params));
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [as,agg_result], null);
});
fluree.db.query.analytical.add_aggregate_cols = (function fluree$db$query$analytical$add_aggregate_cols(res,aggregate){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,agg){
var vec__36772 = fluree.db.query.analytical.calculate_aggregate(res__$1,agg);
var as = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36772,(0),null);
var agg_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36772,(1),null);
var map__36775 = res__$1;
var map__36775__$1 = cljs.core.__destructure_map(map__36775);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36775__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36775__$1,cljs.core.cst$kw$tuples);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36771_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(p1__36771_SHARP_),agg_result);
}),tuples);
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.vec(headers),as);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$headers,headers_SINGLEQUOTE_,cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_], null);
}),res,aggregate);
});
fluree.db.query.analytical.symbolize_keys = (function fluree$db$query$analytical$symbolize_keys(q_map){
var keys = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,cljs.core.keys(q_map));
var vals = cljs.core.vals(q_map);
return cljs.core.zipmap(keys,vals);
});
/**
 * Combines two lists of tuples, a-tuples and b-tuples, into a single aggregated
 *   tuples list based on matching criteria.
 * 
 *   Matching criteria is a-idxs and b-idxs - which represent the multiple index (columns)
 *   of each tuples set that must be compared. i.e. if column 1 in a-tuples is to be compared
 *   to column 3 in b-tuples, then a-idxs will be [0] and b-idxs will be [2]. Indexes start at 0.
 *   Multiple indexes can be compared, i.e. a-idxs of [1 2] means compare both 1 and 2 columns.
 *   Order matters. The count of a-idxs and b-idxs should always be identical, else there would never
 *   be any matches.
 * 
 *   When there is a match, all non-matching columns from matching b-tuples are appended to the
 *   respective matched a-tuple. i.e. if b-tuples had 4 columns (indexes 0 -> 3),
 *   and was matching on [2], then columns [0 1 3] would be appended to the respective matched a-tuple.
 * 
 *   If left-outer-join? is true, instead of discarding any non-matches,
 *   we retain all the a-tuples, but pad the extra b-columns (b-not-idxs) with 'nil'
 */
fluree.db.query.analytical.match_tuples_lists = (function fluree$db$query$analytical$match_tuples_lists(a_idxs,a_tuples,b_idxs,b_tuples,b_not_idxs,left_outer_join_QMARK_){
var b_map = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,tuple){
var b_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36776_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__36776_SHARP_);
}),b_idxs);
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(acc,b_compare,cljs.core.conj,tuple);
}),cljs.core.PersistentArrayMap.EMPTY,b_tuples);
return cljs.core.seq(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,a_tuple){
var a_compare = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36777_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36777_SHARP_);
}),a_idxs);
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(b_map,a_compare);
if(cljs.core.truth_(temp__5751__auto__)){
var b_matched = temp__5751__auto__;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__36778_SHARP_,p2__36779_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36778_SHARP_,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (idx){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p2__36779_SHARP_,idx);
}),b_not_idxs)));
}),acc,b_matched);
} else {
if(cljs.core.truth_(left_outer_join_QMARK_)){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(cljs.core.count(b_not_idxs),null)));
} else {
return acc;
}
}
}),cljs.core.PersistentVector.EMPTY,a_tuples));
});
/**
 * Given a single tuple from A, a-idxs, b-idxs, b-not-idxs, and b-tuples, return any tuples in b that match.
 *   Along with their row-numbers
 */
fluree.db.query.analytical.find_match_PLUS_row_nums = (function fluree$db$query$analytical$find_match_PLUS_row_nums(a_tuple,a_idxs,b_tuples,b_idxs,b_not_idxs){
var a_tuple_part = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36780_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(a_tuple,p1__36780_SHARP_);
}),a_idxs);
return cljs.core.reduce_kv((function (p__36783,row,b_tuple){
var vec__36784 = p__36783;
var acc = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36784,(0),null);
var b_rows = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36784,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a_tuple_part,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36781_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36781_SHARP_);
}),b_idxs))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__4212__auto__ = acc;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),cljs.core.concat.cljs$core$IFn$_invoke$arity$2(a_tuple,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36782_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(b_tuple,p1__36782_SHARP_);
}),b_not_idxs))),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(b_rows,row)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [acc,b_rows], null);
}
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,cljs.core.PersistentHashSet.EMPTY], null),cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,b_tuples));
});
fluree.db.query.analytical.inner_join = (function fluree$db$query$analytical$inner_join(a_res,b_res){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_res,b_res);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36787_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),p1__36787_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36788_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36788_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36793 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36795 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res));
var fexpr__36794 = (function (p1__36789_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36789_SHARP_);
});
return fexpr__36794(G__36795);
})()),cljs.core.set(b_idxs));
var fexpr__36792 = (function (p1__36790_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36790_SHARP_);
});
return fexpr__36792(G__36793);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_res),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_res),b_not_idxs,false);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36791_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_res),p1__36791_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_res),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_res)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
/**
 * OPTIONAL clause is equivalent to a left outer join. If there are no matches in the b-tuples,
 *   we just return a 'match' where each element of the match from b-tuple is nil.
 */
fluree.db.query.analytical.left_outer_join = (function fluree$db$query$analytical$left_outer_join(a_tuples,b_tuples){
var common_keys = fluree.db.query.analytical.intersecting_keys_tuples(a_tuples,b_tuples);
var a_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36796_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),p1__36796_SHARP_);
}),common_keys);
var b_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36797_SHARP_){
return fluree.db.util.core.index_of(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36797_SHARP_);
}),common_keys);
var b_not_idxs = (function (){var G__36802 = clojure.set.difference.cljs$core$IFn$_invoke$arity$2(cljs.core.set((function (){var G__36804 = cljs.core.count(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples));
var fexpr__36803 = (function (p1__36798_SHARP_){
return cljs.core.range.cljs$core$IFn$_invoke$arity$2((0),p1__36798_SHARP_);
});
return fexpr__36803(G__36804);
})()),cljs.core.set(b_idxs));
var fexpr__36801 = (function (p1__36799_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,p1__36799_SHARP_);
});
return fexpr__36801(G__36802);
})();
var c_tuples = fluree.db.query.analytical.match_tuples_lists(a_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(a_tuples),b_idxs,cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(b_tuples),b_not_idxs,true);
var c_headers = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36800_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(b_tuples),p1__36800_SHARP_);
}),b_not_idxs));
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,c_headers,cljs.core.cst$kw$vars,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(a_tuples),cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(b_tuples)], 0)),cljs.core.cst$kw$tuples,c_tuples], null);
});
fluree.db.query.analytical.tuples__GT_filter_required = (function fluree$db$query$analytical$tuples__GT_filter_required(headers,tuples,valid_vars,filter_code_req){
var filter_code_req_str = ["(and ",clojure.string.join.cljs$core$IFn$_invoke$arity$2(" ",filter_code_req),")"].join('');
var vec__36806 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$2(filter_code_req_str,valid_vars);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid required filters, provided: ",filter_code_req_str].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filter_code_req_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36806,(0),null);
var _ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36806,(1),null);
var filter_code_req_str_STAR_ = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filter_code_req_STAR_);
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__36805_SHARP_){
return fluree.db.query.analytical_filter.filter_row(headers,p1__36805_SHARP_,filter_code_req_str_STAR_);
}),tuples);
});
fluree.db.query.analytical.tuples__GT_filter_optional = (function fluree$db$query$analytical$tuples__GT_filter_optional(headers,tuples,valid_vars,filter_code_opts){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (tuples__$1,filt){
var var_atom = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentHashSet.EMPTY);
var vec__36811 = (function (){var or__4212__auto__ = fluree.db.query.analytical_filter.valid_filter_QMARK_.cljs$core$IFn$_invoke$arity$3(filt,valid_vars,var_atom);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid filter, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var filt_STAR_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36811,(0),null);
var filt_vars = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36811,(1),null);
var filt_str = cljs.core.str.cljs$core$IFn$_invoke$arity$1(filt_STAR_);
var filt_vars_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36809_SHARP_){
return fluree.db.util.core.index_of(headers,p1__36809_SHARP_);
}),cljs.core.deref(filt_vars));
var filtered_tuples = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,clause){
if(cljs.core.every_QMARK_((function (p1__36810_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(clause,p1__36810_SHARP_);
}),filt_vars_idxs)){
if(cljs.core.truth_(fluree.db.query.analytical_filter.filter_row(headers,clause,filt_str))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
} else {
return acc;
}
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,clause);
}
}),cljs.core.PersistentVector.EMPTY,tuples__$1);
return filtered_tuples;
}),tuples,filter_code_opts);
});
fluree.db.query.analytical.tuples__GT_filtered = (function fluree$db$query$analytical$tuples__GT_filtered(p__36814,filters,optional_QMARK_){
var map__36815 = p__36814;
var map__36815__$1 = cljs.core.__destructure_map(map__36815);
var tuple_map = map__36815__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36815__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36815__$1,cljs.core.cst$kw$vars);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36815__$1,cljs.core.cst$kw$tuples);
var valid_vars = cljs.core.set(headers);
var header_vec = cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,headers);
var _ = ((typeof filters === 'string')?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Filter must be enclosed in square brackets. Provided: ",filters].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
if(cljs.core.truth_(optional_QMARK_)){
var res = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples,valid_vars,filters)], null);
return res;
} else {
var filter_code_req = fluree.db.query.analytical_filter.get_filters(filters,false);
var tuples__$1 = (cljs.core.truth_(cljs.core.not_empty(filter_code_req))?fluree.db.query.analytical.tuples__GT_filter_required(header_vec,tuples,valid_vars,filter_code_req):tuples);
var filter_code_opt = fluree.db.query.analytical_filter.get_filters(filters,true);
var tuples__$2 = (cljs.core.truth_(cljs.core.not_empty(filter_code_opt))?fluree.db.query.analytical.tuples__GT_filter_optional(header_vec,tuples__$1,valid_vars,filter_code_opt):tuples__$1);
return new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$headers,headers,cljs.core.cst$kw$vars,vars,cljs.core.cst$kw$tuples,tuples__$2], null);
}
});
fluree.db.query.analytical.bind_clause__GT_vars = (function fluree$db$query$analytical$bind_clause__GT_vars(res,clause){
var vec__36816 = clause;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36816,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36816,(1),null);
var k__$1 = fluree.db.query.analytical.variable_QMARK_(k);
var _ = (cljs.core.truth_(k__$1)?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid intermediate aggregate value. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var map__36819 = res;
var map__36819__$1 = cljs.core.__destructure_map(map__36819);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36819__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36819__$1,cljs.core.cst$kw$vars);
var var_value = (cljs.core.truth_(fluree.db.query.analytical.interm_aggregate_QMARK_(v))?cljs.core.second(fluree.db.query.analytical.calculate_aggregate(res,fluree.db.query.analytical.parse_aggregate(cljs.core.subs.cljs$core$IFn$_invoke$arity$2(v,(1)),cljs.core.set((function (){var temp__5751__auto__ = cljs.core.keys(vars);
if(cljs.core.truth_(temp__5751__auto__)){
var valid_var = temp__5751__auto__;
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(headers,valid_var);
} else {
return headers;
}
})())))):v);
return cljs.core.PersistentArrayMap.createAsIfByAssoc([k__$1,var_value]);
});
fluree.db.query.analytical.optional__GT_left_outer_joins = (function fluree$db$query$analytical$optional__GT_left_outer_joins(db,q_map,optional_clauses,where_tuples,fuel,max_fuel,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_36875){
var state_val_36876 = (state_36875[(1)]);
if((state_val_36876 === (7))){
var inst_36849 = (state_36875[(7)]);
var inst_36847 = (state_36875[(2)]);
var inst_36848 = fluree.db.util.async.throw_err(inst_36847);
var inst_36849__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36848,(0),null);
var inst_36850 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_36848,(1),null);
var inst_36851 = (inst_36849__$1 == null);
var state_36875__$1 = (function (){var statearr_36877 = state_36875;
(statearr_36877[(7)] = inst_36849__$1);

(statearr_36877[(8)] = inst_36850);

return statearr_36877;
})();
if(cljs.core.truth_(inst_36851)){
var statearr_36878_36907 = state_36875__$1;
(statearr_36878_36907[(1)] = (8));

} else {
var statearr_36879_36908 = state_36875__$1;
(statearr_36879_36908[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (1))){
var inst_36827 = optional_clauses;
var inst_36828 = cljs.core.seq(inst_36827);
var inst_36829 = cljs.core.first(inst_36828);
var inst_36830 = cljs.core.next(inst_36828);
var inst_36831 = where_tuples;
var inst_36832 = inst_36827;
var inst_36833 = inst_36831;
var state_36875__$1 = (function (){var statearr_36880 = state_36875;
(statearr_36880[(9)] = inst_36832);

(statearr_36880[(10)] = inst_36833);

(statearr_36880[(11)] = inst_36829);

(statearr_36880[(12)] = inst_36830);

return statearr_36880;
})();
var statearr_36881_36909 = state_36875__$1;
(statearr_36881_36909[(2)] = null);

(statearr_36881_36909[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (4))){
var inst_36833 = (state_36875[(10)]);
var inst_36840 = (state_36875[(13)]);
var inst_36839 = (state_36875[(14)]);
var inst_36845 = (fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9 ? fluree.db.query.analytical.clause__GT_tuples.cljs$core$IFn$_invoke$arity$9(db,q_map,inst_36833,inst_36839,inst_36840,true,fuel,max_fuel,opts) : fluree.db.query.analytical.clause__GT_tuples.call(null,db,q_map,inst_36833,inst_36839,inst_36840,true,fuel,max_fuel,opts));
var state_36875__$1 = state_36875;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_36875__$1,(7),inst_36845);
} else {
if((state_val_36876 === (15))){
var state_36875__$1 = state_36875;
var statearr_36882_36910 = state_36875__$1;
(statearr_36882_36910[(2)] = null);

(statearr_36882_36910[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (13))){
var inst_36866 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36883_36911 = state_36875__$1;
(statearr_36883_36911[(2)] = inst_36866);

(statearr_36883_36911[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (6))){
var inst_36871 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36884_36912 = state_36875__$1;
(statearr_36884_36912[(2)] = inst_36871);

(statearr_36884_36912[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (3))){
var inst_36873 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
return cljs.core.async.impl.ioc_helpers.return_chan(state_36875__$1,inst_36873);
} else {
if((state_val_36876 === (12))){
var state_36875__$1 = state_36875;
var statearr_36885_36913 = state_36875__$1;
(statearr_36885_36913[(1)] = (14));



return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (2))){
var inst_36832 = (state_36875[(9)]);
var inst_36839 = (state_36875[(14)]);
var inst_36838 = cljs.core.seq(inst_36832);
var inst_36839__$1 = cljs.core.first(inst_36838);
var inst_36840 = cljs.core.next(inst_36838);
var state_36875__$1 = (function (){var statearr_36887 = state_36875;
(statearr_36887[(13)] = inst_36840);

(statearr_36887[(14)] = inst_36839__$1);

return statearr_36887;
})();
if(cljs.core.truth_(inst_36839__$1)){
var statearr_36888_36914 = state_36875__$1;
(statearr_36888_36914[(1)] = (4));

} else {
var statearr_36889_36915 = state_36875__$1;
(statearr_36889_36915[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (11))){
var inst_36849 = (state_36875[(7)]);
var inst_36850 = (state_36875[(8)]);
var inst_36832 = inst_36850;
var inst_36833 = inst_36849;
var state_36875__$1 = (function (){var statearr_36890 = state_36875;
(statearr_36890[(9)] = inst_36832);

(statearr_36890[(10)] = inst_36833);

return statearr_36890;
})();
var statearr_36891_36916 = state_36875__$1;
(statearr_36891_36916[(2)] = null);

(statearr_36891_36916[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (9))){
var inst_36839 = (state_36875[(14)]);
var inst_36855 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(inst_36839);
var state_36875__$1 = state_36875;
if(cljs.core.truth_(inst_36855)){
var statearr_36892_36917 = state_36875__$1;
(statearr_36892_36917[(1)] = (11));

} else {
var statearr_36893_36918 = state_36875__$1;
(statearr_36893_36918[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (5))){
var inst_36833 = (state_36875[(10)]);
var state_36875__$1 = state_36875;
var statearr_36894_36919 = state_36875__$1;
(statearr_36894_36919[(2)] = inst_36833);

(statearr_36894_36919[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (14))){
var inst_36833 = (state_36875[(10)]);
var inst_36849 = (state_36875[(7)]);
var inst_36850 = (state_36875[(8)]);
var inst_36860 = fluree.db.query.analytical.left_outer_join(inst_36833,inst_36849);
var inst_36832 = inst_36850;
var inst_36833__$1 = inst_36860;
var state_36875__$1 = (function (){var statearr_36895 = state_36875;
(statearr_36895[(9)] = inst_36832);

(statearr_36895[(10)] = inst_36833__$1);

return statearr_36895;
})();
var statearr_36896_36920 = state_36875__$1;
(statearr_36896_36920[(2)] = null);

(statearr_36896_36920[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (16))){
var inst_36864 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36898_36921 = state_36875__$1;
(statearr_36898_36921[(2)] = inst_36864);

(statearr_36898_36921[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (10))){
var inst_36868 = (state_36875[(2)]);
var state_36875__$1 = state_36875;
var statearr_36899_36922 = state_36875__$1;
(statearr_36899_36922[(2)] = inst_36868);

(statearr_36899_36922[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_36876 === (8))){
var inst_36833 = (state_36875[(10)]);
var inst_36850 = (state_36875[(8)]);
var tmp36897 = inst_36833;
var inst_36832 = inst_36850;
var inst_36833__$1 = tmp36897;
var state_36875__$1 = (function (){var statearr_36900 = state_36875;
(statearr_36900[(9)] = inst_36832);

(statearr_36900[(10)] = inst_36833__$1);

return statearr_36900;
})();
var statearr_36901_36923 = state_36875__$1;
(statearr_36901_36923[(2)] = null);

(statearr_36901_36923[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0 = (function (){
var statearr_36902 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_36902[(0)] = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__);

(statearr_36902[(1)] = (1));

return statearr_36902;
});
var fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1 = (function (state_36875){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_36875);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e36903){var ex__16398__auto__ = e36903;
var statearr_36904_36924 = state_36875;
(statearr_36904_36924[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_36875[(4)]))){
var statearr_36905_36925 = state_36875;
(statearr_36905_36925[(1)] = cljs.core.first((state_36875[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__36926 = state_36875;
state_36875 = G__36926;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__ = function(state_36875){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1.call(this,state_36875);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____0;
fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$optional__GT_left_outer_joins_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_36906 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_36906[(6)] = c__16469__auto__);

return statearr_36906;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.res_absorb_vars = (function fluree$db$query$analytical$res_absorb_vars(res){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,p__36928){
var vec__36929 = p__36928;
var var_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36929,(0),null);
var var_val = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__36929,(1),null);
var tuples_SINGLEQUOTE_ = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__36927_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__36927_SHARP_,var_val);
}),cljs.core.cst$kw$tuples.cljs$core$IFn$_invoke$arity$1(res));
var headers_SINGLEQUOTE_ = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(res),var_name);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$tuples,tuples_SINGLEQUOTE_,cljs.core.cst$kw$headers,headers_SINGLEQUOTE_], null);
}),res,cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(res));
});
/**
 * Tuples and optional? are only used for Wikidata, because need to both limit calls to Wikidata,
 *   and ensure that returned results are as limited as possible (but still relevant).
 */
fluree.db.query.analytical.clause__GT_tuples = (function fluree$db$query$analytical$clause__GT_tuples(db,p__36933,p__36934,clause,r,optional_QMARK_,fuel,max_fuel,opts){
var map__36935 = p__36933;
var map__36935__$1 = cljs.core.__destructure_map(map__36935);
var q_map = map__36935__$1;
var prefixes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36935__$1,cljs.core.cst$kw$prefixes);
var map__36936 = p__36934;
var map__36936__$1 = cljs.core.__destructure_map(map__36936);
var res = map__36936__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__36936__$1,cljs.core.cst$kw$vars);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37173){
var state_val_37174 = (state_37173[(1)]);
if((state_val_37174 === (65))){
var inst_37123 = (state_37173[(7)]);
var inst_37122 = (state_37173[(8)]);
var inst_37134 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37135 = fluree.db.query.analytical.full_text__GT_tuples(inst_37122,res,inst_37123);
var inst_37136 = [inst_37135,r];
var inst_37137 = (new cljs.core.PersistentVector(null,2,(5),inst_37134,inst_37136,null));
var state_37173__$1 = state_37173;
var statearr_37175_37288 = state_37173__$1;
(statearr_37175_37288[(2)] = inst_37137);

(statearr_37175_37288[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (70))){
var inst_37149 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37176_37289 = state_37173__$1;
(statearr_37176_37289[(2)] = inst_37149);

(statearr_37176_37289[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (62))){
var inst_37123 = (state_37173[(7)]);
var inst_37131 = cljs.core.second(inst_37123);
var inst_37132 = clojure.string.starts_with_QMARK_(inst_37131,"fullText:");
var state_37173__$1 = state_37173;
if(inst_37132){
var statearr_37177_37290 = state_37173__$1;
(statearr_37177_37290[(1)] = (65));

} else {
var statearr_37178_37291 = state_37173__$1;
(statearr_37178_37291[(1)] = (66));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (7))){
var inst_37042 = (state_37173[(9)]);
var inst_37041 = cljs.core.count(clause);
var inst_37042__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37041);
var state_37173__$1 = (function (){var statearr_37179 = state_37173;
(statearr_37179[(9)] = inst_37042__$1);

return statearr_37179;
})();
if(inst_37042__$1){
var statearr_37180_37292 = state_37173__$1;
(statearr_37180_37292[(1)] = (31));

} else {
var statearr_37181_37293 = state_37173__$1;
(statearr_37181_37293[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (59))){
var inst_37156 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37182_37294 = state_37173__$1;
(statearr_37182_37294[(2)] = inst_37156);

(statearr_37182_37294[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (20))){
var inst_37005 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37183_37295 = state_37173__$1;
(statearr_37183_37295[(2)] = inst_37005);

(statearr_37183_37295[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (58))){
var state_37173__$1 = state_37173;
var statearr_37184_37296 = state_37173__$1;
(statearr_37184_37296[(2)] = null);

(statearr_37184_37296[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (60))){
var inst_37122 = (state_37173[(8)]);
var inst_37120 = (state_37173[(2)]);
var inst_37121 = fluree.db.util.async.throw_err(inst_37120);
var inst_37122__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37121,(0),null);
var inst_37123 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37121,(1),null);
var inst_37124 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("$wd",inst_37122__$1);
var state_37173__$1 = (function (){var statearr_37185 = state_37173;
(statearr_37185[(7)] = inst_37123);

(statearr_37185[(8)] = inst_37122__$1);

return statearr_37185;
})();
if(inst_37124){
var statearr_37186_37297 = state_37173__$1;
(statearr_37186_37297[(1)] = (61));

} else {
var statearr_37187_37298 = state_37173__$1;
(statearr_37187_37298[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (27))){
var inst_37035 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37188_37299 = state_37173__$1;
(statearr_37188_37299[(2)] = inst_37035);

(statearr_37188_37299[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (1))){
var state_37173__$1 = state_37173;
var statearr_37189_37300 = state_37173__$1;
(statearr_37189_37300[(2)] = null);

(statearr_37189_37300[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (69))){
var state_37173__$1 = state_37173;
var statearr_37190_37301 = state_37173__$1;
(statearr_37190_37301[(2)] = null);

(statearr_37190_37301[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (24))){
var inst_36999 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37191_37302 = state_37173__$1;
(statearr_37191_37302[(2)] = inst_36999);

(statearr_37191_37302[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (55))){
var inst_37105 = ["Invalid where clause, it should have 2+ tuples but instead found: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_37106 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37107 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37108 = cljs.core.PersistentHashMap.fromArrays(inst_37106,inst_37107);
var inst_37109 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37105,inst_37108);
var inst_37110 = (function(){throw inst_37109})();
var state_37173__$1 = state_37173;
var statearr_37192_37303 = state_37173__$1;
(statearr_37192_37303[(2)] = inst_37110);

(statearr_37192_37303[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (39))){
var inst_37062 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
if(cljs.core.truth_(inst_37062)){
var statearr_37193_37304 = state_37173__$1;
(statearr_37193_37304[(1)] = (40));

} else {
var statearr_37194_37305 = state_37173__$1;
(statearr_37194_37305[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (46))){
var inst_37162 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37195_37306 = state_37173__$1;
(statearr_37195_37306[(2)] = inst_37162);

(statearr_37195_37306[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (4))){
var inst_36937 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37196_37307 = state_37173__$1;
(statearr_37196_37307[(2)] = inst_36937);

(statearr_37196_37307[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (54))){
var inst_37098 = ["Invalid where clause, it appears you have an extra nested vector here: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(clause)].join('');
var inst_37099 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_37100 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_37101 = cljs.core.PersistentHashMap.fromArrays(inst_37099,inst_37100);
var inst_37102 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_37098,inst_37101);
var inst_37103 = (function(){throw inst_37102})();
var state_37173__$1 = state_37173;
var statearr_37197_37308 = state_37173__$1;
(statearr_37197_37308[(2)] = inst_37103);

(statearr_37197_37308[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (15))){
var inst_37037 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37198_37309 = state_37173__$1;
(statearr_37198_37309[(2)] = inst_37037);

(statearr_37198_37309[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (48))){
var inst_37086 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37087 = fluree.db.query.analytical.bind_clause__GT_vars(res,clause);
var inst_37088 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37087);
var inst_37089 = [inst_37088,r];
var inst_37090 = (new cljs.core.PersistentVector(null,2,(5),inst_37086,inst_37089,null));
var state_37173__$1 = state_37173;
var statearr_37199_37310 = state_37173__$1;
(statearr_37199_37310[(2)] = inst_37090);

(statearr_37199_37310[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (50))){
var inst_37160 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37200_37311 = state_37173__$1;
(statearr_37200_37311[(2)] = inst_37160);

(statearr_37200_37311[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (21))){
var inst_36976 = (state_37173[(10)]);
var inst_36946 = (state_37173[(11)]);
var inst_36973 = (state_37173[(12)]);
var inst_36975 = (state_37173[(13)]);
var inst_36974 = (state_37173[(14)]);
var inst_36982 = (state_37173[(15)]);
var inst_36971 = (state_37173[(16)]);
var inst_36950 = (state_37173[(17)]);
var inst_36983 = (state_37173[(18)]);
var inst_36987 = (state_37173[(2)]);
var inst_36988 = fluree.db.util.async.throw_err(inst_36987);
var inst_36989 = (function (){var new_res = inst_36988;
var first__36970 = inst_36973;
var rest = inst_36983;
var tuples = inst_36976;
var seq__36979 = inst_36983;
var seq__36969 = inst_36974;
var pred__36947 = inst_36950;
var expr__36948 = inst_36946;
var segment_type = inst_36946;
var G__36967 = inst_36975;
var vec__36968 = inst_36971;
var clause_group = inst_36982;
var first__36980 = inst_36982;
var vec__36978 = inst_36975;
return (function (res__$1,var$){
return cljs.core.update.cljs$core$IFn$_invoke$arity$4(new_res,cljs.core.cst$kw$var,cljs.core.dissoc,var$);
});
})();
var inst_36990 = cljs.core.keys(vars);
var inst_36991 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_36989,inst_36988,inst_36990);
var inst_36992 = fluree.db.query.analytical.res_absorb_vars(inst_36991);
var state_37173__$1 = (function (){var statearr_37201 = state_37173;
(statearr_37201[(19)] = inst_36992);

return statearr_37201;
})();
if(cljs.core.truth_(inst_36976)){
var statearr_37202_37312 = state_37173__$1;
(statearr_37202_37312[(1)] = (22));

} else {
var statearr_37203_37313 = state_37173__$1;
(statearr_37203_37313[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (31))){
var inst_37044 = cljs.core.second(clause);
var inst_37045 = clojure.string.starts_with_QMARK_(inst_37044,"fullText:");
var state_37173__$1 = state_37173;
var statearr_37204_37314 = state_37173__$1;
(statearr_37204_37314[(2)] = inst_37045);

(statearr_37204_37314[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (32))){
var inst_37042 = (state_37173[(9)]);
var state_37173__$1 = state_37173;
var statearr_37205_37315 = state_37173__$1;
(statearr_37205_37315[(2)] = inst_37042);

(statearr_37205_37315[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (40))){
var inst_37064 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37065 = fluree.db.query.analytical.collection__GT_tuples(db,res,clause);
var state_37173__$1 = (function (){var statearr_37206 = state_37173;
(statearr_37206[(20)] = inst_37064);

return statearr_37206;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(43),inst_37065);
} else {
if((state_val_37174 === (56))){
var inst_37112 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37207_37316 = state_37173__$1;
(statearr_37207_37316[(2)] = inst_37112);

(statearr_37207_37316[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (33))){
var inst_37048 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
if(cljs.core.truth_(inst_37048)){
var statearr_37208_37317 = state_37173__$1;
(statearr_37208_37317[(1)] = (34));

} else {
var statearr_37209_37318 = state_37173__$1;
(statearr_37209_37318[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (13))){
var inst_36971 = (state_37173[(16)]);
var inst_36971__$1 = cljs.core.cst$kw$union.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36972 = cljs.core.seq(inst_36971__$1);
var inst_36973 = cljs.core.first(inst_36972);
var inst_36974 = cljs.core.next(inst_36972);
var inst_36975 = inst_36971__$1;
var inst_36976 = null;
var state_37173__$1 = (function (){var statearr_37210 = state_37173;
(statearr_37210[(10)] = inst_36976);

(statearr_37210[(12)] = inst_36973);

(statearr_37210[(13)] = inst_36975);

(statearr_37210[(14)] = inst_36974);

(statearr_37210[(16)] = inst_36971__$1);

return statearr_37210;
})();
var statearr_37211_37319 = state_37173__$1;
(statearr_37211_37319[(2)] = null);

(statearr_37211_37319[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (22))){
var inst_36976 = (state_37173[(10)]);
var inst_36992 = (state_37173[(19)]);
var inst_36983 = (state_37173[(18)]);
var inst_36994 = fluree.db.query.union.results(inst_36976,inst_36992);
var inst_36975 = inst_36983;
var inst_36976__$1 = inst_36994;
var state_37173__$1 = (function (){var statearr_37212 = state_37173;
(statearr_37212[(10)] = inst_36976__$1);

(statearr_37212[(13)] = inst_36975);

return statearr_37212;
})();
var statearr_37213_37320 = state_37173__$1;
(statearr_37213_37320[(2)] = null);

(statearr_37213_37320[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (36))){
var inst_37166 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37214_37321 = state_37173__$1;
(statearr_37214_37321[(2)] = inst_37166);

(statearr_37214_37321[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (41))){
var inst_37072 = cljs.core.count(clause);
var inst_37073 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37072);
var state_37173__$1 = state_37173;
if(inst_37073){
var statearr_37215_37322 = state_37173__$1;
(statearr_37215_37322[(1)] = (44));

} else {
var statearr_37216_37323 = state_37173__$1;
(statearr_37216_37323[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (43))){
var inst_37064 = (state_37173[(20)]);
var inst_37067 = (state_37173[(2)]);
var inst_37068 = fluree.db.util.async.throw_err(inst_37067);
var inst_37069 = [inst_37068,r];
var inst_37070 = (new cljs.core.PersistentVector(null,2,(5),inst_37064,inst_37069,null));
var state_37173__$1 = state_37173;
var statearr_37217_37324 = state_37173__$1;
(statearr_37217_37324[(2)] = inst_37070);

(statearr_37217_37324[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (61))){
var inst_37123 = (state_37173[(7)]);
var inst_37126 = fluree.db.query.analytical.wikidata__GT_tuples(q_map,inst_37123,r,res,optional_QMARK_,fuel,max_fuel);
var state_37173__$1 = state_37173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(64),inst_37126);
} else {
if((state_val_37174 === (29))){
var inst_36946 = (state_37173[(11)]);
var inst_37029 = ["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_36946)].join('');
var inst_37030 = (new Error(inst_37029));
var inst_37031 = (function(){throw inst_37030})();
var state_37173__$1 = state_37173;
var statearr_37218_37325 = state_37173__$1;
(statearr_37218_37325[(2)] = inst_37031);

(statearr_37218_37325[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (44))){
var inst_37075 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37076 = fluree.db.query.analytical.fdb_clause__GT_tuples(db,res,clause,fuel,max_fuel);
var state_37173__$1 = (function (){var statearr_37219 = state_37173;
(statearr_37219[(21)] = inst_37075);

return statearr_37219;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(47),inst_37076);
} else {
if((state_val_37174 === (6))){
var inst_36946 = (state_37173[(11)]);
var inst_36950 = (state_37173[(17)]);
var inst_36945 = cljs.core.keys(clause);
var inst_36946__$1 = cljs.core.first(inst_36945);
var inst_36950__$1 = cljs.core._EQ_;
var inst_36951 = (function (){var G__37220 = cljs.core.cst$kw$optional;
var G__37221 = inst_36946__$1;
return (inst_36950__$1.cljs$core$IFn$_invoke$arity$2 ? inst_36950__$1.cljs$core$IFn$_invoke$arity$2(G__37220,G__37221) : inst_36950__$1.call(null,G__37220,G__37221));
})();
var state_37173__$1 = (function (){var statearr_37222 = state_37173;
(statearr_37222[(11)] = inst_36946__$1);

(statearr_37222[(17)] = inst_36950__$1);

return statearr_37222;
})();
if(cljs.core.truth_(inst_36951)){
var statearr_37223_37326 = state_37173__$1;
(statearr_37223_37326[(1)] = (9));

} else {
var statearr_37224_37327 = state_37173__$1;
(statearr_37224_37327[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (28))){
var inst_37023 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37024 = cljs.core.cst$kw$filter.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37025 = fluree.db.query.analytical.tuples__GT_filtered(res,inst_37024,optional_QMARK_);
var inst_37026 = [inst_37025,r];
var inst_37027 = (new cljs.core.PersistentVector(null,2,(5),inst_37023,inst_37026,null));
var state_37173__$1 = state_37173;
var statearr_37225_37328 = state_37173__$1;
(statearr_37225_37328[(2)] = inst_37027);

(statearr_37225_37328[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (64))){
var inst_37128 = (state_37173[(2)]);
var inst_37129 = fluree.db.util.async.throw_err(inst_37128);
var state_37173__$1 = state_37173;
var statearr_37226_37329 = state_37173__$1;
(statearr_37226_37329[(2)] = inst_37129);

(statearr_37226_37329[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (51))){
var inst_37095 = cljs.core.first(clause);
var inst_37096 = cljs.core.sequential_QMARK_(inst_37095);
var state_37173__$1 = state_37173;
if(inst_37096){
var statearr_37227_37330 = state_37173__$1;
(statearr_37227_37330[(1)] = (54));

} else {
var statearr_37228_37331 = state_37173__$1;
(statearr_37228_37331[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (25))){
var inst_36946 = (state_37173[(11)]);
var inst_36950 = (state_37173[(17)]);
var inst_37011 = cljs.core.cst$kw$bind.cljs$core$IFn$_invoke$arity$1(clause);
var inst_37012 = (function (){var segment_type = inst_36946;
var pred__36947 = inst_36950;
var expr__36948 = inst_36946;
var bindings = inst_37011;
return (function (p1__36932_SHARP_){
return fluree.db.query.analytical.bind_clause__GT_vars(res,p1__36932_SHARP_);
});
})();
var inst_37013 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_37012,inst_37011);
var inst_37014 = cljs.core.PersistentHashMap.EMPTY;
var inst_37015 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_37014,inst_37013);
var inst_37016 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37017 = cljs.core.update.cljs$core$IFn$_invoke$arity$4(res,cljs.core.cst$kw$vars,cljs.core.merge,inst_37015);
var inst_37018 = [inst_37017,r];
var inst_37019 = (new cljs.core.PersistentVector(null,2,(5),inst_37016,inst_37018,null));
var state_37173__$1 = state_37173;
var statearr_37229_37332 = state_37173__$1;
(statearr_37229_37332[(2)] = inst_37019);

(statearr_37229_37332[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (34))){
var inst_37050 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37051 = fluree.db.query.analytical.full_text__GT_tuples(db,res,clause);
var inst_37052 = [inst_37051,r];
var inst_37053 = (new cljs.core.PersistentVector(null,2,(5),inst_37050,inst_37052,null));
var state_37173__$1 = state_37173;
var statearr_37230_37333 = state_37173__$1;
(statearr_37230_37333[(2)] = inst_37053);

(statearr_37230_37333[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (17))){
var inst_37007 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37231_37334 = state_37173__$1;
(statearr_37231_37334[(2)] = inst_37007);

(statearr_37231_37334[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (3))){
var inst_37171 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37173__$1,inst_37171);
} else {
if((state_val_37174 === (12))){
var inst_36953 = (state_37173[(22)]);
var inst_36957 = (state_37173[(2)]);
var inst_36958 = fluree.db.util.async.throw_err(inst_36957);
var inst_36959 = [inst_36958,r];
var inst_36960 = (new cljs.core.PersistentVector(null,2,(5),inst_36953,inst_36959,null));
var state_37173__$1 = state_37173;
var statearr_37232_37335 = state_37173__$1;
(statearr_37232_37335[(2)] = inst_36960);

(statearr_37232_37335[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (2))){
var _ = (function (){var statearr_37233 = state_37173;
(statearr_37233[(4)] = cljs.core.cons((5),(state_37173[(4)])));

return statearr_37233;
})();
var inst_36943 = cljs.core.map_QMARK_(clause);
var state_37173__$1 = state_37173;
if(inst_36943){
var statearr_37234_37336 = state_37173__$1;
(statearr_37234_37336[(1)] = (6));

} else {
var statearr_37235_37337 = state_37173__$1;
(statearr_37235_37337[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (66))){
var state_37173__$1 = state_37173;
var statearr_37236_37338 = state_37173__$1;
(statearr_37236_37338[(1)] = (68));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (23))){
var inst_36992 = (state_37173[(19)]);
var inst_36983 = (state_37173[(18)]);
var inst_36975 = inst_36983;
var inst_36976 = inst_36992;
var state_37173__$1 = (function (){var statearr_37238 = state_37173;
(statearr_37238[(10)] = inst_36976);

(statearr_37238[(13)] = inst_36975);

return statearr_37238;
})();
var statearr_37239_37339 = state_37173__$1;
(statearr_37239_37339[(2)] = null);

(statearr_37239_37339[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (47))){
var inst_37075 = (state_37173[(21)]);
var inst_37078 = (state_37173[(2)]);
var inst_37079 = fluree.db.util.async.throw_err(inst_37078);
var inst_37080 = [inst_37079,r];
var inst_37081 = (new cljs.core.PersistentVector(null,2,(5),inst_37075,inst_37080,null));
var state_37173__$1 = state_37173;
var statearr_37240_37340 = state_37173__$1;
(statearr_37240_37340[(2)] = inst_37081);

(statearr_37240_37340[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (35))){
var inst_37056 = (state_37173[(23)]);
var inst_37055 = cljs.core.count(clause);
var inst_37056__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((3),inst_37055);
var state_37173__$1 = (function (){var statearr_37241 = state_37173;
(statearr_37241[(23)] = inst_37056__$1);

return statearr_37241;
})();
if(inst_37056__$1){
var statearr_37242_37341 = state_37173__$1;
(statearr_37242_37341[(1)] = (37));

} else {
var statearr_37243_37342 = state_37173__$1;
(statearr_37243_37342[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (19))){
var inst_36976 = (state_37173[(10)]);
var inst_37001 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37002 = [inst_36976,r];
var inst_37003 = (new cljs.core.PersistentVector(null,2,(5),inst_37001,inst_37002,null));
var state_37173__$1 = state_37173;
var statearr_37244_37343 = state_37173__$1;
(statearr_37244_37343[(2)] = inst_37003);

(statearr_37244_37343[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (57))){
var inst_37118 = fluree.db.query.analytical.get_source_clause.cljs$core$IFn$_invoke$arity$4(db,clause,prefixes,opts);
var state_37173__$1 = state_37173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(60),inst_37118);
} else {
if((state_val_37174 === (68))){
var inst_37123 = (state_37173[(7)]);
var inst_37122 = (state_37173[(8)]);
var inst_37140 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37141 = fluree.db.query.analytical.fdb_clause__GT_tuples(inst_37122,res,inst_37123,fuel,max_fuel);
var state_37173__$1 = (function (){var statearr_37245 = state_37173;
(statearr_37245[(24)] = inst_37140);

return statearr_37245;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(71),inst_37141);
} else {
if((state_val_37174 === (11))){
var inst_37039 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37247_37344 = state_37173__$1;
(statearr_37247_37344[(2)] = inst_37039);

(statearr_37247_37344[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (9))){
var inst_36953 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_36954 = cljs.core.cst$kw$optional.cljs$core$IFn$_invoke$arity$1(clause);
var inst_36955 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_36954,res,fuel,max_fuel,opts);
var state_37173__$1 = (function (){var statearr_37248 = state_37173;
(statearr_37248[(22)] = inst_36953);

return statearr_37248;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(12),inst_36955);
} else {
if((state_val_37174 === (5))){
var _ = (function (){var statearr_37249 = state_37173;
(statearr_37249[(4)] = cljs.core.rest((state_37173[(4)])));

return statearr_37249;
})();
var state_37173__$1 = state_37173;
var ex37246 = (state_37173__$1[(2)]);
var statearr_37250_37345 = state_37173__$1;
(statearr_37250_37345[(5)] = ex37246);


if((ex37246 instanceof Error)){
var statearr_37251_37346 = state_37173__$1;
(statearr_37251_37346[(1)] = (4));

(statearr_37251_37346[(5)] = null);

} else {
throw ex37246;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (14))){
var inst_36946 = (state_37173[(11)]);
var inst_36950 = (state_37173[(17)]);
var inst_37009 = (function (){var G__37252 = cljs.core.cst$kw$bind;
var G__37253 = inst_36946;
return (inst_36950.cljs$core$IFn$_invoke$arity$2 ? inst_36950.cljs$core$IFn$_invoke$arity$2(G__37252,G__37253) : inst_36950.call(null,G__37252,G__37253));
})();
var state_37173__$1 = state_37173;
if(cljs.core.truth_(inst_37009)){
var statearr_37254_37347 = state_37173__$1;
(statearr_37254_37347[(1)] = (25));

} else {
var statearr_37255_37348 = state_37173__$1;
(statearr_37255_37348[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (45))){
var inst_37083 = cljs.core.count(clause);
var inst_37084 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37083);
var state_37173__$1 = state_37173;
if(inst_37084){
var statearr_37256_37349 = state_37173__$1;
(statearr_37256_37349[(1)] = (48));

} else {
var statearr_37257_37350 = state_37173__$1;
(statearr_37257_37350[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (53))){
var inst_37158 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37258_37351 = state_37173__$1;
(statearr_37258_37351[(2)] = inst_37158);

(statearr_37258_37351[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (26))){
var inst_36946 = (state_37173[(11)]);
var inst_36950 = (state_37173[(17)]);
var inst_37021 = (function (){var G__37259 = cljs.core.cst$kw$filter;
var G__37260 = inst_36946;
return (inst_36950.cljs$core$IFn$_invoke$arity$2 ? inst_36950.cljs$core$IFn$_invoke$arity$2(G__37259,G__37260) : inst_36950.call(null,G__37259,G__37260));
})();
var state_37173__$1 = state_37173;
if(cljs.core.truth_(inst_37021)){
var statearr_37261_37352 = state_37173__$1;
(statearr_37261_37352[(1)] = (28));

} else {
var statearr_37262_37353 = state_37173__$1;
(statearr_37262_37353[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (16))){
var inst_36975 = (state_37173[(13)]);
var inst_36982 = (state_37173[(15)]);
var inst_36981 = cljs.core.seq(inst_36975);
var inst_36982__$1 = cljs.core.first(inst_36981);
var inst_36983 = cljs.core.next(inst_36981);
var state_37173__$1 = (function (){var statearr_37263 = state_37173;
(statearr_37263[(15)] = inst_36982__$1);

(statearr_37263[(18)] = inst_36983);

return statearr_37263;
})();
if(cljs.core.truth_(inst_36982__$1)){
var statearr_37264_37354 = state_37173__$1;
(statearr_37264_37354[(1)] = (18));

} else {
var statearr_37265_37355 = state_37173__$1;
(statearr_37265_37355[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (38))){
var inst_37056 = (state_37173[(23)]);
var state_37173__$1 = state_37173;
var statearr_37266_37356 = state_37173__$1;
(statearr_37266_37356[(2)] = inst_37056);

(statearr_37266_37356[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (30))){
var inst_37033 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37267_37357 = state_37173__$1;
(statearr_37267_37357[(2)] = inst_37033);

(statearr_37267_37357[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (10))){
var inst_36946 = (state_37173[(11)]);
var inst_36950 = (state_37173[(17)]);
var inst_36962 = (function (){var G__37268 = cljs.core.cst$kw$union;
var G__37269 = inst_36946;
return (inst_36950.cljs$core$IFn$_invoke$arity$2 ? inst_36950.cljs$core$IFn$_invoke$arity$2(G__37268,G__37269) : inst_36950.call(null,G__37268,G__37269));
})();
var state_37173__$1 = state_37173;
if(cljs.core.truth_(inst_36962)){
var statearr_37270_37358 = state_37173__$1;
(statearr_37270_37358[(1)] = (13));

} else {
var statearr_37271_37359 = state_37173__$1;
(statearr_37271_37359[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (18))){
var inst_36982 = (state_37173[(15)]);
var inst_36985 = (fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 ? fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_36982,q_map,vars,fuel,max_fuel,opts) : fluree.db.query.analytical.resolve_where_clause.call(null,db,inst_36982,q_map,vars,fuel,max_fuel,opts));
var state_37173__$1 = state_37173;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37173__$1,(21),inst_36985);
} else {
if((state_val_37174 === (52))){
var state_37173__$1 = state_37173;
var statearr_37272_37360 = state_37173__$1;
(statearr_37272_37360[(1)] = (57));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (67))){
var inst_37151 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37274_37361 = state_37173__$1;
(statearr_37274_37361[(2)] = inst_37151);

(statearr_37274_37361[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (71))){
var inst_37140 = (state_37173[(24)]);
var inst_37143 = (state_37173[(2)]);
var inst_37144 = fluree.db.util.async.throw_err(inst_37143);
var inst_37145 = [inst_37144,r];
var inst_37146 = (new cljs.core.PersistentVector(null,2,(5),inst_37140,inst_37145,null));
var state_37173__$1 = state_37173;
var statearr_37275_37362 = state_37173__$1;
(statearr_37275_37362[(2)] = inst_37146);

(statearr_37275_37362[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (42))){
var inst_37164 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37276_37363 = state_37173__$1;
(statearr_37276_37363[(2)] = inst_37164);

(statearr_37276_37363[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (37))){
var inst_37058 = cljs.core.second(clause);
var inst_37059 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_37058,"rdf:type");
var state_37173__$1 = state_37173;
var statearr_37277_37364 = state_37173__$1;
(statearr_37277_37364[(2)] = inst_37059);

(statearr_37277_37364[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (63))){
var inst_37153 = (state_37173[(2)]);
var state_37173__$1 = state_37173;
var statearr_37278_37365 = state_37173__$1;
(statearr_37278_37365[(2)] = inst_37153);

(statearr_37278_37365[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (8))){
var inst_37168 = (state_37173[(2)]);
var _ = (function (){var statearr_37279 = state_37173;
(statearr_37279[(4)] = cljs.core.rest((state_37173[(4)])));

return statearr_37279;
})();
var state_37173__$1 = state_37173;
var statearr_37280_37366 = state_37173__$1;
(statearr_37280_37366[(2)] = inst_37168);

(statearr_37280_37366[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37174 === (49))){
var inst_37092 = cljs.core.count(clause);
var inst_37093 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_37092);
var state_37173__$1 = state_37173;
if(inst_37093){
var statearr_37281_37367 = state_37173__$1;
(statearr_37281_37367[(1)] = (51));

} else {
var statearr_37282_37368 = state_37173__$1;
(statearr_37282_37368[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0 = (function (){
var statearr_37283 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37283[(0)] = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__);

(statearr_37283[(1)] = (1));

return statearr_37283;
});
var fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1 = (function (state_37173){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37173);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37284){var ex__16398__auto__ = e37284;
var statearr_37285_37369 = state_37173;
(statearr_37285_37369[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37173[(4)]))){
var statearr_37286_37370 = state_37173;
(statearr_37286_37370[(1)] = cljs.core.first((state_37173[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37371 = state_37173;
state_37173 = G__37371;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__ = function(state_37173){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1.call(this,state_37173);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____0;
fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$clause__GT_tuples_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37287 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37287[(6)] = c__16469__auto__);

return statearr_37287;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.analytical.resolve_where_clause = (function fluree$db$query$analytical$resolve_where_clause(var_args){
var G__37373 = arguments.length;
switch (G__37373) {
case 6:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$6 = (function (db,where,q_map,vars,fuel,max_fuel){
return fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,where,q_map,vars,fuel,max_fuel,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7 = (function (db,where,q_map,vars,fuel,max_fuel,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37453){
var state_val_37454 = (state_37453[(1)]);
if((state_val_37454 === (7))){
var inst_37448 = (state_37453[(2)]);
var _ = (function (){var statearr_37455 = state_37453;
(statearr_37455[(4)] = cljs.core.rest((state_37453[(4)])));

return statearr_37455;
})();
var state_37453__$1 = state_37453;
var statearr_37456_37504 = state_37453__$1;
(statearr_37456_37504[(2)] = inst_37448);

(statearr_37456_37504[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (20))){
var inst_37413 = (state_37453[(7)]);
var inst_37425 = (state_37453[(2)]);
var inst_37395 = inst_37413;
var inst_37396 = inst_37425;
var state_37453__$1 = (function (){var statearr_37457 = state_37453;
(statearr_37457[(8)] = inst_37395);

(statearr_37457[(9)] = inst_37396);

return statearr_37457;
})();
var statearr_37458_37505 = state_37453__$1;
(statearr_37458_37505[(2)] = null);

(statearr_37458_37505[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (1))){
var state_37453__$1 = state_37453;
var statearr_37459_37506 = state_37453__$1;
(statearr_37459_37506[(2)] = null);

(statearr_37459_37506[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (24))){
var inst_37412 = (state_37453[(10)]);
var inst_37413 = (state_37453[(7)]);
var inst_37396 = (state_37453[(9)]);
var inst_37433 = fluree.db.query.analytical.inner_join(inst_37396,inst_37412);
var inst_37395 = inst_37413;
var inst_37396__$1 = inst_37433;
var state_37453__$1 = (function (){var statearr_37460 = state_37453;
(statearr_37460[(8)] = inst_37395);

(statearr_37460[(9)] = inst_37396__$1);

return statearr_37460;
})();
var statearr_37461_37507 = state_37453__$1;
(statearr_37461_37507[(2)] = null);

(statearr_37461_37507[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (4))){
var inst_37374 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37463_37508 = state_37453__$1;
(statearr_37463_37508[(2)] = inst_37374);

(statearr_37463_37508[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (15))){
var inst_37412 = (state_37453[(10)]);
var state_37453__$1 = state_37453;
if(cljs.core.truth_(inst_37412)){
var statearr_37464_37509 = state_37453__$1;
(statearr_37464_37509[(1)] = (18));

} else {
var statearr_37465_37510 = state_37453__$1;
(statearr_37465_37510[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (21))){
var inst_37413 = (state_37453[(7)]);
var inst_37396 = (state_37453[(9)]);
var tmp37462 = inst_37396;
var inst_37395 = inst_37413;
var inst_37396__$1 = tmp37462;
var state_37453__$1 = (function (){var statearr_37466 = state_37453;
(statearr_37466[(8)] = inst_37395);

(statearr_37466[(9)] = inst_37396__$1);

return statearr_37466;
})();
var statearr_37467_37511 = state_37453__$1;
(statearr_37467_37511[(2)] = null);

(statearr_37467_37511[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (13))){
var inst_37396 = (state_37453[(9)]);
var inst_37419 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(inst_37396,cljs.core.cst$kw$vars);
var inst_37420 = cljs.core.empty_QMARK_(inst_37419);
var state_37453__$1 = state_37453;
if(inst_37420){
var statearr_37468_37512 = state_37453__$1;
(statearr_37468_37512[(1)] = (15));

} else {
var statearr_37469_37513 = state_37453__$1;
(statearr_37469_37513[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (22))){
var state_37453__$1 = state_37453;
var statearr_37470_37514 = state_37453__$1;
(statearr_37470_37514[(1)] = (24));



return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (6))){
var inst_37402 = (state_37453[(11)]);
var inst_37395 = (state_37453[(8)]);
var inst_37401 = cljs.core.seq(inst_37395);
var inst_37402__$1 = cljs.core.first(inst_37401);
var inst_37403 = cljs.core.next(inst_37401);
var state_37453__$1 = (function (){var statearr_37472 = state_37453;
(statearr_37472[(11)] = inst_37402__$1);

(statearr_37472[(12)] = inst_37403);

return statearr_37472;
})();
if(cljs.core.truth_(inst_37402__$1)){
var statearr_37473_37515 = state_37453__$1;
(statearr_37473_37515[(1)] = (8));

} else {
var statearr_37474_37516 = state_37453__$1;
(statearr_37474_37516[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (25))){
var state_37453__$1 = state_37453;
var statearr_37475_37517 = state_37453__$1;
(statearr_37475_37517[(2)] = null);

(statearr_37475_37517[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (17))){
var inst_37441 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37476_37518 = state_37453__$1;
(statearr_37476_37518[(2)] = inst_37441);

(statearr_37476_37518[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (3))){
var inst_37451 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37453__$1,inst_37451);
} else {
if((state_val_37454 === (12))){
var inst_37412 = (state_37453[(10)]);
var inst_37413 = (state_37453[(7)]);
var inst_37395 = inst_37413;
var inst_37396 = inst_37412;
var state_37453__$1 = (function (){var statearr_37477 = state_37453;
(statearr_37477[(8)] = inst_37395);

(statearr_37477[(9)] = inst_37396);

return statearr_37477;
})();
var statearr_37478_37519 = state_37453__$1;
(statearr_37478_37519[(2)] = null);

(statearr_37478_37519[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (2))){
var _ = (function (){var statearr_37479 = state_37453;
(statearr_37479[(4)] = cljs.core.cons((5),(state_37453[(4)])));

return statearr_37479;
})();
var inst_37387 = where;
var inst_37388 = cljs.core.seq(inst_37387);
var inst_37389 = cljs.core.first(inst_37388);
var inst_37390 = cljs.core.next(inst_37388);
var inst_37391 = [cljs.core.cst$kw$vars];
var inst_37392 = fluree.db.query.analytical.symbolize_keys(vars);
var inst_37393 = [inst_37392];
var inst_37394 = cljs.core.PersistentHashMap.fromArrays(inst_37391,inst_37393);
var inst_37395 = inst_37387;
var inst_37396 = inst_37394;
var state_37453__$1 = (function (){var statearr_37480 = state_37453;
(statearr_37480[(13)] = inst_37390);

(statearr_37480[(8)] = inst_37395);

(statearr_37480[(14)] = inst_37389);

(statearr_37480[(9)] = inst_37396);

return statearr_37480;
})();
var statearr_37481_37520 = state_37453__$1;
(statearr_37481_37520[(2)] = null);

(statearr_37481_37520[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (23))){
var inst_37439 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37482_37521 = state_37453__$1;
(statearr_37482_37521[(2)] = inst_37439);

(statearr_37482_37521[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (19))){
var inst_37396 = (state_37453[(9)]);
var state_37453__$1 = state_37453;
var statearr_37483_37522 = state_37453__$1;
(statearr_37483_37522[(2)] = inst_37396);

(statearr_37483_37522[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (11))){
var inst_37402 = (state_37453[(11)]);
var inst_37410 = (state_37453[(2)]);
var inst_37411 = fluree.db.util.async.throw_err(inst_37410);
var inst_37412 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37411,(0),null);
var inst_37413 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_37411,(1),null);
var inst_37414 = cljs.core.count(inst_37402);
var inst_37415 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((2),inst_37414);
var state_37453__$1 = (function (){var statearr_37485 = state_37453;
(statearr_37485[(10)] = inst_37412);

(statearr_37485[(7)] = inst_37413);

return statearr_37485;
})();
if(inst_37415){
var statearr_37486_37523 = state_37453__$1;
(statearr_37486_37523[(1)] = (12));

} else {
var statearr_37487_37524 = state_37453__$1;
(statearr_37487_37524[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (9))){
var inst_37396 = (state_37453[(9)]);
var state_37453__$1 = state_37453;
var statearr_37488_37525 = state_37453__$1;
(statearr_37488_37525[(2)] = inst_37396);

(statearr_37488_37525[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (5))){
var _ = (function (){var statearr_37489 = state_37453;
(statearr_37489[(4)] = cljs.core.rest((state_37453[(4)])));

return statearr_37489;
})();
var state_37453__$1 = state_37453;
var ex37484 = (state_37453__$1[(2)]);
var statearr_37490_37526 = state_37453__$1;
(statearr_37490_37526[(5)] = ex37484);


if((ex37484 instanceof Error)){
var statearr_37491_37527 = state_37453__$1;
(statearr_37491_37527[(1)] = (4));

(statearr_37491_37527[(5)] = null);

} else {
throw ex37484;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (14))){
var inst_37443 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37492_37528 = state_37453__$1;
(statearr_37492_37528[(2)] = inst_37443);

(statearr_37492_37528[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (26))){
var inst_37437 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37493_37529 = state_37453__$1;
(statearr_37493_37529[(2)] = inst_37437);

(statearr_37493_37529[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (16))){
var inst_37412 = (state_37453[(10)]);
var inst_37428 = (inst_37412 == null);
var state_37453__$1 = state_37453;
if(cljs.core.truth_(inst_37428)){
var statearr_37494_37530 = state_37453__$1;
(statearr_37494_37530[(1)] = (21));

} else {
var statearr_37495_37531 = state_37453__$1;
(statearr_37495_37531[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (10))){
var inst_37446 = (state_37453[(2)]);
var state_37453__$1 = state_37453;
var statearr_37496_37532 = state_37453__$1;
(statearr_37496_37532[(2)] = inst_37446);

(statearr_37496_37532[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (18))){
var inst_37412 = (state_37453[(10)]);
var state_37453__$1 = state_37453;
var statearr_37497_37533 = state_37453__$1;
(statearr_37497_37533[(2)] = inst_37412);

(statearr_37497_37533[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37454 === (8))){
var inst_37402 = (state_37453[(11)]);
var inst_37396 = (state_37453[(9)]);
var inst_37403 = (state_37453[(12)]);
var inst_37408 = fluree.db.query.analytical.clause__GT_tuples(db,q_map,inst_37396,inst_37402,inst_37403,false,fuel,max_fuel,opts);
var state_37453__$1 = state_37453;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37453__$1,(11),inst_37408);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$state_machine__16395__auto__ = null;
var fluree$db$query$analytical$state_machine__16395__auto____0 = (function (){
var statearr_37498 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_37498[(0)] = fluree$db$query$analytical$state_machine__16395__auto__);

(statearr_37498[(1)] = (1));

return statearr_37498;
});
var fluree$db$query$analytical$state_machine__16395__auto____1 = (function (state_37453){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37453);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37499){var ex__16398__auto__ = e37499;
var statearr_37500_37534 = state_37453;
(statearr_37500_37534[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37453[(4)]))){
var statearr_37501_37535 = state_37453;
(statearr_37501_37535[(1)] = cljs.core.first((state_37453[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37536 = state_37453;
state_37453 = G__37536;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$state_machine__16395__auto__ = function(state_37453){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$state_machine__16395__auto____1.call(this,state_37453);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$state_machine__16395__auto____0;
fluree$db$query$analytical$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$state_machine__16395__auto____1;
return fluree$db$query$analytical$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37502 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37502[(6)] = c__16469__auto__);

return statearr_37502;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.analytical.resolve_where_clause.cljs$lang$maxFixedArity = 7);

fluree.db.query.analytical.q = (function fluree$db$query$analytical$q(q_map,fuel,max_fuel,db,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_37571){
var state_val_37572 = (state_37571[(1)]);
if((state_val_37572 === (7))){
var inst_37553 = (state_37571[(7)]);
var inst_37548 = (state_37571[(8)]);
var inst_37555 = fluree.db.query.analytical.optional__GT_left_outer_joins(db,q_map,inst_37548,inst_37553,fuel,max_fuel,opts);
var state_37571__$1 = state_37571;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37571__$1,(10),inst_37555);
} else {
if((state_val_37572 === (1))){
var state_37571__$1 = state_37571;
var statearr_37573_37598 = state_37571__$1;
(statearr_37573_37598[(2)] = null);

(statearr_37573_37598[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (4))){
var inst_37537 = (state_37571[(2)]);
var state_37571__$1 = state_37571;
var statearr_37574_37599 = state_37571__$1;
(statearr_37574_37599[(2)] = inst_37537);

(statearr_37574_37599[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (13))){
var inst_37566 = (state_37571[(2)]);
var _ = (function (){var statearr_37575 = state_37571;
(statearr_37575[(4)] = cljs.core.rest((state_37571[(4)])));

return statearr_37575;
})();
var state_37571__$1 = state_37571;
var statearr_37576_37600 = state_37571__$1;
(statearr_37576_37600[(2)] = inst_37566);

(statearr_37576_37600[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (6))){
var inst_37548 = (state_37571[(8)]);
var inst_37552 = (state_37571[(2)]);
var inst_37553 = fluree.db.util.async.throw_err(inst_37552);
var state_37571__$1 = (function (){var statearr_37577 = state_37571;
(statearr_37577[(7)] = inst_37553);

return statearr_37577;
})();
if(cljs.core.truth_(inst_37548)){
var statearr_37578_37601 = state_37571__$1;
(statearr_37578_37601[(1)] = (7));

} else {
var statearr_37579_37602 = state_37571__$1;
(statearr_37579_37602[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (3))){
var inst_37569 = (state_37571[(2)]);
var state_37571__$1 = state_37571;
return cljs.core.async.impl.ioc_helpers.return_chan(state_37571__$1,inst_37569);
} else {
if((state_val_37572 === (12))){
var inst_37561 = (state_37571[(9)]);
var state_37571__$1 = state_37571;
var statearr_37580_37603 = state_37571__$1;
(statearr_37580_37603[(2)] = inst_37561);

(statearr_37580_37603[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (2))){
var _ = (function (){var statearr_37581 = state_37571;
(statearr_37581[(4)] = cljs.core.cons((5),(state_37571[(4)])));

return statearr_37581;
})();
var inst_37544 = q_map;
var inst_37545 = cljs.core.__destructure_map(inst_37544);
var inst_37546 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37545,cljs.core.cst$kw$vars);
var inst_37547 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37545,cljs.core.cst$kw$where);
var inst_37548 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37545,cljs.core.cst$kw$optional);
var inst_37549 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37545,cljs.core.cst$kw$filter);
var inst_37550 = fluree.db.query.analytical.resolve_where_clause.cljs$core$IFn$_invoke$arity$7(db,inst_37547,q_map,inst_37546,fuel,max_fuel,opts);
var state_37571__$1 = (function (){var statearr_37582 = state_37571;
(statearr_37582[(10)] = inst_37549);

(statearr_37582[(8)] = inst_37548);

return statearr_37582;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_37571__$1,(6),inst_37550);
} else {
if((state_val_37572 === (11))){
var inst_37549 = (state_37571[(10)]);
var inst_37561 = (state_37571[(9)]);
var inst_37563 = fluree.db.query.analytical.tuples__GT_filtered(inst_37561,inst_37549,null);
var state_37571__$1 = state_37571;
var statearr_37584_37604 = state_37571__$1;
(statearr_37584_37604[(2)] = inst_37563);

(statearr_37584_37604[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (9))){
var inst_37549 = (state_37571[(10)]);
var inst_37561 = (state_37571[(2)]);
var state_37571__$1 = (function (){var statearr_37585 = state_37571;
(statearr_37585[(9)] = inst_37561);

return statearr_37585;
})();
if(cljs.core.truth_(inst_37549)){
var statearr_37586_37605 = state_37571__$1;
(statearr_37586_37605[(1)] = (11));

} else {
var statearr_37587_37606 = state_37571__$1;
(statearr_37587_37606[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (5))){
var _ = (function (){var statearr_37588 = state_37571;
(statearr_37588[(4)] = cljs.core.rest((state_37571[(4)])));

return statearr_37588;
})();
var state_37571__$1 = state_37571;
var ex37583 = (state_37571__$1[(2)]);
var statearr_37589_37607 = state_37571__$1;
(statearr_37589_37607[(5)] = ex37583);


if((ex37583 instanceof Error)){
var statearr_37590_37608 = state_37571__$1;
(statearr_37590_37608[(1)] = (4));

(statearr_37590_37608[(5)] = null);

} else {
throw ex37583;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (10))){
var inst_37557 = (state_37571[(2)]);
var inst_37558 = fluree.db.util.async.throw_err(inst_37557);
var state_37571__$1 = state_37571;
var statearr_37591_37609 = state_37571__$1;
(statearr_37591_37609[(2)] = inst_37558);

(statearr_37591_37609[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_37572 === (8))){
var inst_37553 = (state_37571[(7)]);
var state_37571__$1 = state_37571;
var statearr_37592_37610 = state_37571__$1;
(statearr_37592_37610[(2)] = inst_37553);

(statearr_37592_37610[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$analytical$q_$_state_machine__16395__auto__ = null;
var fluree$db$query$analytical$q_$_state_machine__16395__auto____0 = (function (){
var statearr_37593 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_37593[(0)] = fluree$db$query$analytical$q_$_state_machine__16395__auto__);

(statearr_37593[(1)] = (1));

return statearr_37593;
});
var fluree$db$query$analytical$q_$_state_machine__16395__auto____1 = (function (state_37571){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_37571);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e37594){var ex__16398__auto__ = e37594;
var statearr_37595_37611 = state_37571;
(statearr_37595_37611[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_37571[(4)]))){
var statearr_37596_37612 = state_37571;
(statearr_37596_37612[(1)] = cljs.core.first((state_37571[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__37613 = state_37571;
state_37571 = G__37613;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$analytical$q_$_state_machine__16395__auto__ = function(state_37571){
switch(arguments.length){
case 0:
return fluree$db$query$analytical$q_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$analytical$q_$_state_machine__16395__auto____1.call(this,state_37571);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$analytical$q_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$analytical$q_$_state_machine__16395__auto____0;
fluree$db$query$analytical$q_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$analytical$q_$_state_machine__16395__auto____1;
return fluree$db$query$analytical$q_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_37597 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_37597[(6)] = c__16469__auto__);

return statearr_37597;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
