// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.fql');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.query.fql_parser');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.util.log');
goog.require('clojure.string');
goog.require('fluree.db.query.range');
goog.require('fluree.db.flake');
goog.require('fluree.db.util.core');
goog.require('clojure.set');
goog.require('fluree.db.query.analytical');
goog.require('fluree.db.query.schema');
goog.require('cljs.core.async');
goog.require('fluree.db.util.async');

/**
 * This silly fn exists to work around a bug in go macros where they sometimes clobber
 *   type hints and issue reflection warnings. The vswap! macro uses interop so those forms
 *   get macroexpanded into the go block. You'll then see reflection warnings for reset
 *   deref. By letting the macro expand into this fn instead, it avoids the go bug.
 *   I've filed a JIRA issue here: https://clojure.atlassian.net/browse/ASYNC-240
 *   NB: I couldn't figure out how to get a var-arg version working so this only supports
 *   0-3 args. I didn't see any usages in here that need more than 2, but note well and
 *   feel free to add additional arities if needed (but maybe see if that linked bug has
 *   been fixed first in which case delete this thing with a vengeance and remove the
 *   refer-clojure exclude in the ns form).
 *   - WSM 2021-08-26
 */
fluree.db.query.fql.vswap_BANG_ = (function fluree$db$query$fql$vswap_BANG_(var_args){
var G__37868 = arguments.length;
switch (G__37868) {
case 2:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (vol,f){
return cljs.core._vreset_BANG_(vol,(function (){var G__37869 = cljs.core._deref(vol);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__37869) : f.call(null,G__37869));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (vol,f,arg1){
return cljs.core._vreset_BANG_(vol,(function (){var G__37870 = cljs.core._deref(vol);
var G__37871 = arg1;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__37870,G__37871) : f.call(null,G__37870,G__37871));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (vol,f,arg1,arg2){
return cljs.core._vreset_BANG_(vol,(function (){var G__37872 = cljs.core._deref(vol);
var G__37873 = arg1;
var G__37874 = arg2;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__37872,G__37873,G__37874) : f.call(null,G__37872,G__37873,G__37874));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$5 = (function (vol,f,arg1,arg2,arg3){
return cljs.core._vreset_BANG_(vol,(function (){var G__37875 = cljs.core._deref(vol);
var G__37876 = arg1;
var G__37877 = arg2;
var G__37878 = arg3;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__37875,G__37876,G__37877,G__37878) : f.call(null,G__37875,G__37876,G__37877,G__37878));
})());
}));

(fluree.db.query.fql.vswap_BANG_.cljs$lang$maxFixedArity = 5);

/**
 * Can sit in a flake pipeline and accumulate a count of 'fuel-per' for every flake pulled
 *   or item touched. 'fuel-per' defaults to 1 fuel per item.
 * 
 *   Inputs are:
 *   - fuel - volatile! that holds fuel counter
 *   - max-fuel - throw exception if @fuel ever exceeds this number
 * 
 *   To get final count, just deref fuel volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flake_transducer = (function fluree$db$query$fql$fuel_flake_transducer(var_args){
var G__37881 = arguments.length;
switch (G__37881) {
case 2:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2 = (function (fuel,max_fuel){
return fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(1));
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3 = (function (fuel,max_fuel,fuel_per){
return (function (xf){
return (function() {
var G__37883 = null;
var G__37883__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37883__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37883__2 = (function (result,flake){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,fuel_per);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flake) : xf.call(null,result,flake));
});
G__37883 = function(result,flake){
switch(arguments.length){
case 0:
return G__37883__0.call(this);
case 1:
return G__37883__1.call(this,result);
case 2:
return G__37883__2.call(this,result,flake);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37883.cljs$core$IFn$_invoke$arity$0 = G__37883__0;
G__37883.cljs$core$IFn$_invoke$arity$1 = G__37883__1;
G__37883.cljs$core$IFn$_invoke$arity$2 = G__37883__2;
return G__37883;
})()
});
}));

(fluree.db.query.fql.fuel_flake_transducer.cljs$lang$maxFixedArity = 3);

/**
 * Can sit in a flake group pipeline and accumulate a count of 1 for every flake pulled.
 * 
 *   Supply with a volatile!
 * 
 *   To get final count, just deref volatile when when where is complete.
 */
fluree.db.query.fql.fuel_flakes_transducer = (function fluree$db$query$fql$fuel_flakes_transducer(fuel,max_fuel){
return (function (xf){
return (function() {
var G__37884 = null;
var G__37884__0 = (function (){
return (xf.cljs$core$IFn$_invoke$arity$0 ? xf.cljs$core$IFn$_invoke$arity$0() : xf.call(null));
});
var G__37884__1 = (function (result){
return (xf.cljs$core$IFn$_invoke$arity$1 ? xf.cljs$core$IFn$_invoke$arity$1(result) : xf.call(null,result));
});
var G__37884__2 = (function (result,flakes){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,cljs.core.count(flakes));

return (xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(result,flakes) : xf.call(null,result,flakes));
});
G__37884 = function(result,flakes){
switch(arguments.length){
case 0:
return G__37884__0.call(this);
case 1:
return G__37884__1.call(this,result);
case 2:
return G__37884__2.call(this,result,flakes);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__37884.cljs$core$IFn$_invoke$arity$0 = G__37884__0;
G__37884.cljs$core$IFn$_invoke$arity$1 = G__37884__1;
G__37884.cljs$core$IFn$_invoke$arity$2 = G__37884__2;
return G__37884;
})()
});
});
/**
 * Adds a n amount of fuel and will throw if max fuel exceeded.
 */
fluree.db.query.fql.add_fuel = (function fluree$db$query$fql$add_fuel(fuel,n,max_fuel){
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,n);

if(cljs.core.truth_((function (){var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) > max_fuel);
} else {
return and__4210__auto__;
}
})())){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
return null;
}
});
/**
 * Just uses query cache to avoid constant lookups.
 */
fluree.db.query.fql.wildcard_pred_spec = (function fluree$db$query$fql$wildcard_pred_spec(db,cache,p,compact_QMARK_){
var or__4212__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var p_map = fluree.db.query.fql_parser.p__GT_pred_config(db,p,compact_QMARK_);
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc_in,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p,compact_QMARK_], null),p_map);

return p_map;
}
});
fluree.db.query.fql.compare_fn = (function fluree$db$query$fql$compare_fn(a,b){
if(typeof a === 'string'){
var res = cljs.core.compare(clojure.string.upper_case(a),clojure.string.upper_case(b));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(res,(0))){
return ((-1) * cljs.core.compare(a,b));
} else {
return res;
}
} else {
return cljs.core.compare(a,b);
}
});
/**
 * We only need to do this if there is an orderBy, otherwise limit and offset
 *   were performed in index-range.
 */
fluree.db.query.fql.sort_offset_and_limit_res = (function fluree$db$query$fql$sort_offset_and_limit_res(sortPred,sortOrder,offset,limit,res){
if(cljs.core.vector_QMARK_(res)){
var G__37886 = res;
var G__37886__$1 = (cljs.core.truth_(sortPred)?cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3((function (p1__37885_SHARP_){
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(p1__37885_SHARP_,sortPred);
}),fluree.db.query.fql.compare_fn,G__37886):G__37886);
var G__37886__$2 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortOrder))?cljs.core.reverse(G__37886__$1):G__37886__$1);
var G__37886__$3 = (cljs.core.truth_(offset)?cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,G__37886__$2):G__37886__$2);
if(cljs.core.truth_(limit)){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,G__37886__$3);
} else {
return G__37886__$3;
}
} else {
return res;
}
});
/**
 * Adds a predicate to a select spec graph crawl. flakes input is a list of flakes
 *   all with the same subject and predicate values.
 */
fluree.db.query.fql.add_pred = (function fluree$db$query$fql$add_pred(var_args){
var G__37890 = arguments.length;
switch (G__37890) {
case 9:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]));

break;
case 10:
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]),(arguments[(8)]),(arguments[(9)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_){
return fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10 = (function (db,cache,fuel,max_fuel,acc,pred_spec,flakes,componentFollow_QMARK_,recur_QMARK_,offset_map){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_38262){
var state_val_38263 = (state_38262[(1)]);
if((state_val_38263 === (65))){
var inst_38044 = (state_38262[(2)]);
var inst_38045 = fluree.db.util.async.throw_err(inst_38044);
var state_38262__$1 = (function (){var statearr_38264 = state_38262;
(statearr_38264[(7)] = inst_38045);

return statearr_38264;
})();
if(cljs.core.truth_(fuel)){
var statearr_38265_38450 = state_38262__$1;
(statearr_38265_38450[(1)] = (66));

} else {
var statearr_38266_38451 = state_38262__$1;
(statearr_38266_38451[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (70))){
var inst_38068 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38076 = flakes;
var inst_38077 = cljs.core.seq(inst_38076);
var inst_38078 = cljs.core.first(inst_38077);
var inst_38079 = cljs.core.next(inst_38077);
var inst_38080 = cljs.core.PersistentVector.EMPTY;
var inst_38081 = inst_38076;
var inst_38082 = inst_38080;
var state_38262__$1 = (function (){var statearr_38267 = state_38262;
(statearr_38267[(8)] = inst_38081);

(statearr_38267[(9)] = inst_38082);

(statearr_38267[(10)] = inst_38079);

(statearr_38267[(11)] = inst_38078);

(statearr_38267[(12)] = inst_38068);

return statearr_38267;
})();
var statearr_38268_38452 = state_38262__$1;
(statearr_38268_38452[(2)] = null);

(statearr_38268_38452[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (62))){
var inst_38035 = (state_38262[(13)]);
var inst_38038 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38039 = inst_38035.o;
var inst_38040 = [inst_38039];
var inst_38041 = (new cljs.core.PersistentVector(null,1,(5),inst_38038,inst_38040,null));
var inst_38042 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38041);
var state_38262__$1 = state_38262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38262__$1,(65),inst_38042);
} else {
if((state_val_38263 === (74))){
var inst_38068 = (state_38262[(12)]);
var inst_38124 = (state_38262[(2)]);
var inst_38125 = [inst_38124,offset_map];
var inst_38126 = (new cljs.core.PersistentVector(null,2,(5),inst_38068,inst_38125,null));
var state_38262__$1 = state_38262;
var statearr_38269_38453 = state_38262__$1;
(statearr_38269_38453[(2)] = inst_38126);

(statearr_38269_38453[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (110))){
var inst_38232 = (state_38262[(14)]);
var inst_38235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38236 = [acc,inst_38232];
var inst_38237 = (new cljs.core.PersistentVector(null,2,(5),inst_38235,inst_38236,null));
var state_38262__$1 = state_38262;
var statearr_38270_38454 = state_38262__$1;
(statearr_38270_38454[(2)] = inst_38237);

(statearr_38270_38454[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (7))){
var inst_37902 = (state_38262[(15)]);
var state_38262__$1 = state_38262;
var statearr_38271_38455 = state_38262__$1;
(statearr_38271_38455[(2)] = inst_37902);

(statearr_38271_38455[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (59))){
var inst_38226 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38272_38456 = state_38262__$1;
(statearr_38272_38456[(2)] = inst_38226);

(statearr_38272_38456[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (86))){
var inst_38128 = (state_38262[(16)]);
var state_38262__$1 = state_38262;
var statearr_38273_38457 = state_38262__$1;
(statearr_38273_38457[(2)] = inst_38128);

(statearr_38273_38457[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (20))){
var inst_37931 = (state_38262[(17)]);
var inst_37944 = (state_38262[(18)]);
var inst_37943 = (state_38262[(19)]);
var inst_37942 = (state_38262[(2)]);
var inst_37943__$1 = cljs.core.__destructure_map(inst_37931);
var inst_37944__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$multi_QMARK_);
var inst_37945 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$ref_QMARK_);
var inst_37946 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$limit);
var inst_37947 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$orderBy);
var inst_37948 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$offset);
var inst_37949 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_37943__$1,cljs.core.cst$kw$p);
var state_38262__$1 = (function (){var statearr_38274 = state_38262;
(statearr_38274[(20)] = inst_37942);

(statearr_38274[(21)] = inst_37947);

(statearr_38274[(22)] = inst_37949);

(statearr_38274[(18)] = inst_37944__$1);

(statearr_38274[(23)] = inst_37945);

(statearr_38274[(19)] = inst_37943__$1);

(statearr_38274[(24)] = inst_37948);

(statearr_38274[(25)] = inst_37946);

return statearr_38274;
})();
if(cljs.core.truth_(inst_37944__$1)){
var statearr_38275_38458 = state_38262__$1;
(statearr_38275_38458[(1)] = (24));

} else {
var statearr_38276_38459 = state_38262__$1;
(statearr_38276_38459[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (72))){
var inst_38224 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38277_38460 = state_38262__$1;
(statearr_38277_38460[(2)] = inst_38224);

(statearr_38277_38460[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (58))){
var inst_37931 = (state_38262[(17)]);
var inst_38066 = cljs.core.cst$kw$tag_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_38066)){
var statearr_38278_38461 = state_38262__$1;
(statearr_38278_38461[(1)] = (70));

} else {
var statearr_38279_38462 = state_38262__$1;
(statearr_38279_38462[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (60))){
var inst_38028 = (state_38262[(26)]);
var inst_38035 = (state_38262[(13)]);
var inst_38034 = cljs.core.seq(inst_38028);
var inst_38035__$1 = cljs.core.first(inst_38034);
var inst_38036 = cljs.core.next(inst_38034);
var state_38262__$1 = (function (){var statearr_38280 = state_38262;
(statearr_38280[(27)] = inst_38036);

(statearr_38280[(13)] = inst_38035__$1);

return statearr_38280;
})();
if(cljs.core.truth_(inst_38035__$1)){
var statearr_38281_38463 = state_38262__$1;
(statearr_38281_38463[(1)] = (62));

} else {
var statearr_38282_38464 = state_38262__$1;
(statearr_38282_38464[(1)] = (63));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (27))){
var inst_37952 = (state_38262[(28)]);
var inst_37948 = (state_38262[(24)]);
var inst_37952__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37948);
var state_38262__$1 = (function (){var statearr_38283 = state_38262;
(statearr_38283[(28)] = inst_37952__$1);

return statearr_38283;
})();
if(inst_37952__$1){
var statearr_38284_38465 = state_38262__$1;
(statearr_38284_38465[(1)] = (30));

} else {
var statearr_38285_38466 = state_38262__$1;
(statearr_38285_38466[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (1))){
var state_38262__$1 = state_38262;
var statearr_38286_38467 = state_38262__$1;
(statearr_38286_38467[(2)] = null);

(statearr_38286_38467[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (69))){
var inst_38036 = (state_38262[(27)]);
var inst_38029 = (state_38262[(29)]);
var inst_38054 = (state_38262[(2)]);
var inst_38055 = fluree.db.util.async.throw_err(inst_38054);
var inst_38056 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38029,inst_38055);
var inst_38028 = inst_38036;
var inst_38029__$1 = inst_38056;
var state_38262__$1 = (function (){var statearr_38287 = state_38262;
(statearr_38287[(29)] = inst_38029__$1);

(statearr_38287[(26)] = inst_38028);

return statearr_38287;
})();
var statearr_38288_38468 = state_38262__$1;
(statearr_38288_38468[(2)] = null);

(statearr_38288_38468[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (101))){
var inst_38169 = (state_38262[(30)]);
var inst_38189 = cljs.core.count(inst_38169);
var inst_38190 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_38189);
var state_38262__$1 = state_38262;
var statearr_38289_38469 = state_38262__$1;
(statearr_38289_38469[(2)] = inst_38190);

(statearr_38289_38469[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (24))){
var inst_37948 = (state_38262[(24)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37948)){
var statearr_38290_38470 = state_38262__$1;
(statearr_38290_38470[(1)] = (27));

} else {
var statearr_38291_38471 = state_38262__$1;
(statearr_38291_38471[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (102))){
var state_38262__$1 = state_38262;
var statearr_38292_38472 = state_38262__$1;
(statearr_38292_38472[(2)] = null);

(statearr_38292_38472[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (55))){
var inst_37931 = (state_38262[(17)]);
var inst_38004 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = state_38262;
var statearr_38293_38473 = state_38262__$1;
(statearr_38293_38473[(2)] = inst_38004);

(statearr_38293_38473[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (85))){
var inst_37931 = (state_38262[(17)]);
var inst_38130 = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = state_38262;
var statearr_38294_38474 = state_38262__$1;
(statearr_38294_38474[(2)] = inst_38130);

(statearr_38294_38474[(1)] = (87));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (39))){
var inst_37947 = (state_38262[(21)]);
var inst_37979 = (state_38262[(31)]);
var inst_37979__$1 = cljs.core.not(inst_37947);
var state_38262__$1 = (function (){var statearr_38295 = state_38262;
(statearr_38295[(31)] = inst_37979__$1);

return statearr_38295;
})();
if(inst_37979__$1){
var statearr_38296_38475 = state_38262__$1;
(statearr_38296_38475[(1)] = (42));

} else {
var statearr_38297_38476 = state_38262__$1;
(statearr_38297_38476[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (88))){
var inst_38135 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38143 = flakes;
var inst_38144 = cljs.core.seq(inst_38143);
var inst_38145 = cljs.core.first(inst_38144);
var inst_38146 = cljs.core.next(inst_38144);
var inst_38147 = cljs.core.PersistentVector.EMPTY;
var inst_38148 = inst_38143;
var inst_38149 = inst_38147;
var state_38262__$1 = (function (){var statearr_38298 = state_38262;
(statearr_38298[(32)] = inst_38145);

(statearr_38298[(33)] = inst_38135);

(statearr_38298[(34)] = inst_38146);

(statearr_38298[(35)] = inst_38149);

(statearr_38298[(36)] = inst_38148);

return statearr_38298;
})();
var statearr_38299_38477 = state_38262__$1;
(statearr_38299_38477[(2)] = null);

(statearr_38299_38477[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (46))){
var inst_37946 = (state_38262[(25)]);
var state_38262__$1 = state_38262;
var statearr_38300_38478 = state_38262__$1;
(statearr_38300_38478[(2)] = inst_37946);

(statearr_38300_38478[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (4))){
var inst_37891 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38301_38479 = state_38262__$1;
(statearr_38301_38479[(2)] = inst_37891);

(statearr_38301_38479[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (77))){
var inst_38122 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38302_38480 = state_38262__$1;
(statearr_38302_38480[(2)] = inst_38122);

(statearr_38302_38480[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (106))){
var inst_38220 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38303_38481 = state_38262__$1;
(statearr_38303_38481[(2)] = inst_38220);

(statearr_38303_38481[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (95))){
var inst_38197 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38304_38482 = state_38262__$1;
(statearr_38304_38482[(2)] = inst_38197);

(statearr_38304_38482[(1)] = (92));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (54))){
var inst_38001 = (state_38262[(37)]);
var state_38262__$1 = state_38262;
var statearr_38305_38483 = state_38262__$1;
(statearr_38305_38483[(2)] = inst_38001);

(statearr_38305_38483[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (92))){
var inst_38135 = (state_38262[(33)]);
var inst_38199 = (state_38262[(2)]);
var inst_38200 = [inst_38199,offset_map];
var inst_38201 = (new cljs.core.PersistentVector(null,2,(5),inst_38135,inst_38200,null));
var state_38262__$1 = state_38262;
var statearr_38306_38484 = state_38262__$1;
(statearr_38306_38484[(2)] = inst_38201);

(statearr_38306_38484[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (104))){
var inst_37942 = (state_38262[(20)]);
var inst_37931 = (state_38262[(17)]);
var inst_37947 = (state_38262[(21)]);
var inst_37949 = (state_38262[(22)]);
var inst_37944 = (state_38262[(18)]);
var inst_37945 = (state_38262[(23)]);
var inst_37943 = (state_38262[(19)]);
var inst_37901 = (state_38262[(38)]);
var inst_37948 = (state_38262[(24)]);
var inst_37946 = (state_38262[(25)]);
var inst_37916 = (state_38262[(39)]);
var inst_38204 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38205 = (function (){var p = inst_37949;
var pred_spec__$1 = inst_37916;
var orderBy = inst_37947;
var multi_QMARK_ = inst_37944;
var limit = inst_37946;
var offset = inst_37948;
var map__37897 = inst_37943;
var k = inst_37942;
var compact_QMARK_ = inst_37901;
var pred_spec_SINGLEQUOTE_ = inst_37931;
var ref_QMARK_ = inst_37945;
return (function (p1__37887_SHARP_){
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$_id],[p1__37887_SHARP_.o]);
});
})();
var inst_38206 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38205,flakes);
var inst_38207 = [inst_38206,offset_map];
var inst_38208 = (new cljs.core.PersistentVector(null,2,(5),inst_38204,inst_38207,null));
var state_38262__$1 = state_38262;
var statearr_38307_38485 = state_38262__$1;
(statearr_38307_38485[(2)] = inst_38208);

(statearr_38307_38485[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (15))){
var inst_37901 = (state_38262[(38)]);
var inst_37924 = (state_38262[(40)]);
var inst_37928 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37924,cljs.core.cst$kw$compact_QMARK_,inst_37901);
var state_38262__$1 = state_38262;
var statearr_38308_38486 = state_38262__$1;
(statearr_38308_38486[(2)] = inst_37928);

(statearr_38308_38486[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (48))){
var inst_37995 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37996 = [null,offset_map];
var inst_37997 = (new cljs.core.PersistentVector(null,2,(5),inst_37995,inst_37996,null));
var state_38262__$1 = state_38262;
var statearr_38309_38487 = state_38262__$1;
(statearr_38309_38487[(2)] = inst_37997);

(statearr_38309_38487[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (50))){
var inst_38228 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38310_38488 = state_38262__$1;
(statearr_38310_38488[(2)] = inst_38228);

(statearr_38310_38488[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (116))){
var inst_37942 = (state_38262[(20)]);
var inst_38231 = (state_38262[(41)]);
var inst_38232 = (state_38262[(14)]);
var inst_38246 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38247 = cljs.core.first(inst_38231);
var inst_38248 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37942,inst_38247);
var inst_38249 = [inst_38248,inst_38232];
var inst_38250 = (new cljs.core.PersistentVector(null,2,(5),inst_38246,inst_38249,null));
var state_38262__$1 = state_38262;
var statearr_38311_38489 = state_38262__$1;
(statearr_38311_38489[(2)] = inst_38250);

(statearr_38311_38489[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (75))){
var inst_37931 = (state_38262[(17)]);
var inst_38097 = (state_38262[(42)]);
var inst_38088 = (state_38262[(43)]);
var inst_38091 = cljs.core.deref(cache);
var inst_38092 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38093 = inst_38088.o;
var inst_38094 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37931);
var inst_38095 = [inst_38093,inst_38094];
var inst_38096 = (new cljs.core.PersistentVector(null,2,(5),inst_38092,inst_38095,null));
var inst_38097__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38091,inst_38096);
var state_38262__$1 = (function (){var statearr_38312 = state_38262;
(statearr_38312[(42)] = inst_38097__$1);

return statearr_38312;
})();
if(cljs.core.truth_(inst_38097__$1)){
var statearr_38313_38490 = state_38262__$1;
(statearr_38313_38490[(1)] = (78));

} else {
var statearr_38314_38491 = state_38262__$1;
(statearr_38314_38491[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (99))){
var inst_38187 = (state_38262[(2)]);
var state_38262__$1 = (function (){var statearr_38315 = state_38262;
(statearr_38315[(44)] = inst_38187);

return statearr_38315;
})();
if(cljs.core.truth_(fuel)){
var statearr_38316_38492 = state_38262__$1;
(statearr_38316_38492[(1)] = (101));

} else {
var statearr_38317_38493 = state_38262__$1;
(statearr_38317_38493[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (21))){
var inst_37935 = (state_38262[(45)]);
var state_38262__$1 = state_38262;
var statearr_38318_38494 = state_38262__$1;
(statearr_38318_38494[(2)] = inst_37935);

(statearr_38318_38494[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (31))){
var inst_37952 = (state_38262[(28)]);
var state_38262__$1 = state_38262;
var statearr_38319_38495 = state_38262__$1;
(statearr_38319_38495[(2)] = inst_37952);

(statearr_38319_38495[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (113))){
var inst_37942 = (state_38262[(20)]);
var inst_38231 = (state_38262[(41)]);
var inst_38232 = (state_38262[(14)]);
var inst_38240 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38241 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,inst_37942,inst_38231);
var inst_38242 = [inst_38241,inst_38232];
var inst_38243 = (new cljs.core.PersistentVector(null,2,(5),inst_38240,inst_38242,null));
var state_38262__$1 = state_38262;
var statearr_38320_38496 = state_38262__$1;
(statearr_38320_38496[(2)] = inst_38243);

(statearr_38320_38496[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (32))){
var inst_37958 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38321_38497 = state_38262__$1;
(statearr_38321_38497[(2)] = inst_37958);

(statearr_38321_38497[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (40))){
var inst_37944 = (state_38262[(18)]);
var state_38262__$1 = state_38262;
var statearr_38322_38498 = state_38262__$1;
(statearr_38322_38498[(2)] = inst_37944);

(statearr_38322_38498[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (91))){
var inst_38148 = (state_38262[(36)]);
var inst_38155 = (state_38262[(46)]);
var inst_38154 = cljs.core.seq(inst_38148);
var inst_38155__$1 = cljs.core.first(inst_38154);
var inst_38156 = cljs.core.next(inst_38154);
var state_38262__$1 = (function (){var statearr_38323 = state_38262;
(statearr_38323[(47)] = inst_38156);

(statearr_38323[(46)] = inst_38155__$1);

return statearr_38323;
})();
if(cljs.core.truth_(inst_38155__$1)){
var statearr_38324_38499 = state_38262__$1;
(statearr_38324_38499[(1)] = (93));

} else {
var statearr_38325_38500 = state_38262__$1;
(statearr_38325_38500[(1)] = (94));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (117))){
var state_38262__$1 = state_38262;
var statearr_38326_38501 = state_38262__$1;
(statearr_38326_38501[(2)] = null);

(statearr_38326_38501[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (108))){
var state_38262__$1 = state_38262;
var statearr_38327_38502 = state_38262__$1;
(statearr_38327_38502[(2)] = null);

(statearr_38327_38502[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (56))){
var inst_38006 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38328_38503 = state_38262__$1;
(statearr_38328_38503[(2)] = inst_38006);

(statearr_38328_38503[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (33))){
var inst_37949 = (state_38262[(22)]);
var inst_37966 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_37967 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37949);
var state_38262__$1 = (function (){var statearr_38329 = state_38262;
(statearr_38329[(48)] = inst_37966);

return statearr_38329;
})();
if(cljs.core.truth_(inst_37967)){
var statearr_38330_38504 = state_38262__$1;
(statearr_38330_38504[(1)] = (36));

} else {
var statearr_38331_38505 = state_38262__$1;
(statearr_38331_38505[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (13))){
var inst_37916 = (state_38262[(39)]);
var state_38262__$1 = state_38262;
var statearr_38332_38506 = state_38262__$1;
(statearr_38332_38506[(2)] = inst_37916);

(statearr_38332_38506[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (22))){
var inst_37931 = (state_38262[(17)]);
var inst_37938 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = state_38262;
var statearr_38333_38507 = state_38262__$1;
(statearr_38333_38507[(2)] = inst_37938);

(statearr_38333_38507[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (90))){
var inst_38222 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38334_38508 = state_38262__$1;
(statearr_38334_38508[(2)] = inst_38222);

(statearr_38334_38508[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (109))){
var inst_38218 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38335_38509 = state_38262__$1;
(statearr_38335_38509[(2)] = inst_38218);

(statearr_38335_38509[(1)] = (106));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (36))){
var inst_37949 = (state_38262[(22)]);
var inst_37969 = cljs.core.update.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37949,cljs.core.dec);
var state_38262__$1 = state_38262;
var statearr_38336_38510 = state_38262__$1;
(statearr_38336_38510[(2)] = inst_37969);

(statearr_38336_38510[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (41))){
var inst_37993 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37993)){
var statearr_38337_38511 = state_38262__$1;
(statearr_38337_38511[(1)] = (48));

} else {
var statearr_38338_38512 = state_38262__$1;
(statearr_38338_38512[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (118))){
var inst_38253 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38339_38513 = state_38262__$1;
(statearr_38339_38513[(2)] = inst_38253);

(statearr_38339_38513[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (89))){
var inst_37945 = (state_38262[(23)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37945)){
var statearr_38340_38514 = state_38262__$1;
(statearr_38340_38514[(1)] = (104));

} else {
var statearr_38341_38515 = state_38262__$1;
(statearr_38341_38515[(1)] = (105));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (100))){
var inst_38149 = (state_38262[(35)]);
var inst_38183 = (state_38262[(2)]);
var inst_38184 = fluree.db.util.async.throw_err(inst_38183);
var inst_38185 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38149,inst_38184);
var state_38262__$1 = state_38262;
var statearr_38342_38516 = state_38262__$1;
(statearr_38342_38516[(2)] = inst_38185);

(statearr_38342_38516[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (43))){
var inst_37979 = (state_38262[(31)]);
var state_38262__$1 = state_38262;
var statearr_38343_38517 = state_38262__$1;
(statearr_38343_38517[(2)] = inst_37979);

(statearr_38343_38517[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (61))){
var inst_38015 = (state_38262[(49)]);
var inst_38062 = (state_38262[(2)]);
var inst_38063 = [inst_38062,offset_map];
var inst_38064 = (new cljs.core.PersistentVector(null,2,(5),inst_38015,inst_38063,null));
var state_38262__$1 = state_38262;
var statearr_38344_38518 = state_38262__$1;
(statearr_38344_38518[(2)] = inst_38064);

(statearr_38344_38518[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (29))){
var inst_37961 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38345_38519 = state_38262__$1;
(statearr_38345_38519[(2)] = inst_37961);

(statearr_38345_38519[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (44))){
var inst_37990 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38346_38520 = state_38262__$1;
(statearr_38346_38520[(2)] = inst_37990);

(statearr_38346_38520[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (93))){
var inst_37931 = (state_38262[(17)]);
var inst_38155 = (state_38262[(46)]);
var inst_38158 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38159 = inst_38155.o;
var inst_38160 = [inst_38159];
var inst_38161 = (new cljs.core.PersistentVector(null,1,(5),inst_38158,inst_38160,null));
var inst_38162 = [cljs.core.cst$kw$limit];
var inst_38163 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(inst_37931);
var inst_38164 = [inst_38163];
var inst_38165 = cljs.core.PersistentHashMap.fromArrays(inst_38162,inst_38164);
var inst_38166 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38161,inst_38165);
var state_38262__$1 = state_38262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38262__$1,(96),inst_38166);
} else {
if((state_val_38263 === (6))){
var inst_37904 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37905 = (inst_37904 == null);
var state_38262__$1 = state_38262;
var statearr_38347_38521 = state_38262__$1;
(statearr_38347_38521[(2)] = inst_37905);

(statearr_38347_38521[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (111))){
var inst_37944 = (state_38262[(18)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37944)){
var statearr_38348_38522 = state_38262__$1;
(statearr_38348_38522[(1)] = (113));

} else {
var statearr_38349_38523 = state_38262__$1;
(statearr_38349_38523[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (28))){
var inst_37948 = (state_38262[(24)]);
var state_38262__$1 = state_38262;
var statearr_38350_38524 = state_38262__$1;
(statearr_38350_38524[(2)] = inst_37948);

(statearr_38350_38524[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (64))){
var inst_38060 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38351_38525 = state_38262__$1;
(statearr_38351_38525[(2)] = inst_38060);

(statearr_38351_38525[(1)] = (61));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (103))){
var inst_38187 = (state_38262[(44)]);
var inst_38156 = (state_38262[(47)]);
var inst_38193 = (state_38262[(2)]);
var inst_38148 = inst_38156;
var inst_38149 = inst_38187;
var state_38262__$1 = (function (){var statearr_38352 = state_38262;
(statearr_38352[(50)] = inst_38193);

(statearr_38352[(35)] = inst_38149);

(statearr_38352[(36)] = inst_38148);

return statearr_38352;
})();
var statearr_38353_38526 = state_38262__$1;
(statearr_38353_38526[(2)] = null);

(statearr_38353_38526[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (51))){
var inst_37931 = (state_38262[(17)]);
var inst_38001 = (state_38262[(37)]);
var inst_38001__$1 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = (function (){var statearr_38354 = state_38262;
(statearr_38354[(37)] = inst_38001__$1);

return statearr_38354;
})();
if(cljs.core.truth_(inst_38001__$1)){
var statearr_38355_38527 = state_38262__$1;
(statearr_38355_38527[(1)] = (54));

} else {
var statearr_38356_38528 = state_38262__$1;
(statearr_38356_38528[(1)] = (55));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (25))){
var inst_37944 = (state_38262[(18)]);
var state_38262__$1 = state_38262;
var statearr_38357_38529 = state_38262__$1;
(statearr_38357_38529[(2)] = inst_37944);

(statearr_38357_38529[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (34))){
var inst_37944 = (state_38262[(18)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37944)){
var statearr_38358_38530 = state_38262__$1;
(statearr_38358_38530[(1)] = (39));

} else {
var statearr_38359_38531 = state_38262__$1;
(statearr_38359_38531[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (17))){
var inst_37931 = (state_38262[(17)]);
var inst_37932 = (state_38262[(51)]);
var inst_37931__$1 = (state_38262[(2)]);
var inst_37932__$1 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_37931__$1);
var state_38262__$1 = (function (){var statearr_38360 = state_38262;
(statearr_38360[(17)] = inst_37931__$1);

(statearr_38360[(51)] = inst_37932__$1);

return statearr_38360;
})();
if(cljs.core.truth_(inst_37932__$1)){
var statearr_38361_38532 = state_38262__$1;
(statearr_38361_38532[(1)] = (18));

} else {
var statearr_38362_38533 = state_38262__$1;
(statearr_38362_38533[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (3))){
var inst_38260 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38262__$1,inst_38260);
} else {
if((state_val_38263 === (12))){
var inst_37916 = (state_38262[(39)]);
var inst_37921 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_37916,cljs.core.cst$kw$componentFollow_QMARK_,componentFollow_QMARK_);
var state_38262__$1 = state_38262;
var statearr_38363_38534 = state_38262__$1;
(statearr_38363_38534[(2)] = inst_37921);

(statearr_38363_38534[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (2))){
var inst_37902 = (state_38262[(15)]);
var _ = (function (){var statearr_38364 = state_38262;
(statearr_38364[(4)] = cljs.core.cons((5),(state_38262[(4)])));

return statearr_38364;
})();
var inst_37901 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37902__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var state_38262__$1 = (function (){var statearr_38365 = state_38262;
(statearr_38365[(15)] = inst_37902__$1);

(statearr_38365[(38)] = inst_37901);

return statearr_38365;
})();
if(cljs.core.truth_(inst_37902__$1)){
var statearr_38366_38535 = state_38262__$1;
(statearr_38366_38535[(1)] = (6));

} else {
var statearr_38367_38536 = state_38262__$1;
(statearr_38367_38536[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (66))){
var inst_38045 = (state_38262[(7)]);
var inst_38047 = cljs.core.count(inst_38045);
var inst_38048 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_38047);
var state_38262__$1 = state_38262;
var statearr_38368_38537 = state_38262__$1;
(statearr_38368_38537[(2)] = inst_38048);

(statearr_38368_38537[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (107))){
var inst_37942 = (state_38262[(20)]);
var inst_37931 = (state_38262[(17)]);
var inst_37947 = (state_38262[(21)]);
var inst_37949 = (state_38262[(22)]);
var inst_37944 = (state_38262[(18)]);
var inst_37945 = (state_38262[(23)]);
var inst_37943 = (state_38262[(19)]);
var inst_37901 = (state_38262[(38)]);
var inst_37948 = (state_38262[(24)]);
var inst_37946 = (state_38262[(25)]);
var inst_37916 = (state_38262[(39)]);
var inst_38211 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38212 = (function (){var p = inst_37949;
var pred_spec__$1 = inst_37916;
var orderBy = inst_37947;
var multi_QMARK_ = inst_37944;
var limit = inst_37946;
var offset = inst_37948;
var map__37897 = inst_37943;
var k = inst_37942;
var compact_QMARK_ = inst_37901;
var pred_spec_SINGLEQUOTE_ = inst_37931;
var ref_QMARK_ = inst_37945;
return (function (p1__37888_SHARP_){
return p1__37888_SHARP_.o;
});
})();
var inst_38213 = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2(inst_38212,flakes);
var inst_38214 = [inst_38213,offset_map];
var inst_38215 = (new cljs.core.PersistentVector(null,2,(5),inst_38211,inst_38214,null));
var state_38262__$1 = state_38262;
var statearr_38369_38538 = state_38262__$1;
(statearr_38369_38538[(2)] = inst_38215);

(statearr_38369_38538[(1)] = (109));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (23))){
var inst_37940 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38370_38539 = state_38262__$1;
(statearr_38370_38539[(2)] = inst_37940);

(statearr_38370_38539[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (47))){
var inst_37987 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38371_38540 = state_38262__$1;
(statearr_38371_38540[(2)] = inst_37987);

(statearr_38371_38540[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (35))){
var inst_38231 = (state_38262[(41)]);
var inst_38230 = (state_38262[(2)]);
var inst_38231__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38230,(0),null);
var inst_38232 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38230,(1),null);
var inst_38233 = cljs.core.empty_QMARK_(inst_38231__$1);
var state_38262__$1 = (function (){var statearr_38372 = state_38262;
(statearr_38372[(41)] = inst_38231__$1);

(statearr_38372[(14)] = inst_38232);

return statearr_38372;
})();
if(inst_38233){
var statearr_38373_38541 = state_38262__$1;
(statearr_38373_38541[(1)] = (110));

} else {
var statearr_38374_38542 = state_38262__$1;
(statearr_38374_38542[(1)] = (111));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (82))){
var inst_38113 = (state_38262[(52)]);
var inst_38082 = (state_38262[(9)]);
var inst_38115 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38082,inst_38113);
var state_38262__$1 = state_38262;
var statearr_38375_38543 = state_38262__$1;
(statearr_38375_38543[(2)] = inst_38115);

(statearr_38375_38543[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (76))){
var inst_38082 = (state_38262[(9)]);
var state_38262__$1 = state_38262;
var statearr_38376_38544 = state_38262__$1;
(statearr_38376_38544[(2)] = inst_38082);

(statearr_38376_38544[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (97))){
var inst_38149 = (state_38262[(35)]);
var inst_38155 = (state_38262[(46)]);
var inst_38172 = [cljs.core.cst$kw$_id];
var inst_38173 = inst_38155.o;
var inst_38174 = [inst_38173];
var inst_38175 = cljs.core.PersistentHashMap.fromArrays(inst_38172,inst_38174);
var inst_38176 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38149,inst_38175);
var state_38262__$1 = state_38262;
var statearr_38377_38545 = state_38262__$1;
(statearr_38377_38545[(2)] = inst_38176);

(statearr_38377_38545[(1)] = (99));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (19))){
var inst_37931 = (state_38262[(17)]);
var inst_37935 = (state_38262[(45)]);
var inst_37935__$1 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37931);
var state_38262__$1 = (function (){var statearr_38378 = state_38262;
(statearr_38378[(45)] = inst_37935__$1);

return statearr_38378;
})();
if(cljs.core.truth_(inst_37935__$1)){
var statearr_38379_38546 = state_38262__$1;
(statearr_38379_38546[(1)] = (21));

} else {
var statearr_38380_38547 = state_38262__$1;
(statearr_38380_38547[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (57))){
var inst_37931 = (state_38262[(17)]);
var inst_38011 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38012 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select];
var inst_38013 = (new cljs.core.PersistentVector(null,3,(5),inst_38011,inst_38012,null));
var inst_38014 = cljs.core.select_keys(inst_37931,inst_38013);
var inst_38015 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38023 = flakes;
var inst_38024 = cljs.core.seq(inst_38023);
var inst_38025 = cljs.core.first(inst_38024);
var inst_38026 = cljs.core.next(inst_38024);
var inst_38027 = cljs.core.PersistentVector.EMPTY;
var inst_38028 = inst_38023;
var inst_38029 = inst_38027;
var state_38262__$1 = (function (){var statearr_38381 = state_38262;
(statearr_38381[(53)] = inst_38026);

(statearr_38381[(49)] = inst_38015);

(statearr_38381[(29)] = inst_38029);

(statearr_38381[(26)] = inst_38028);

(statearr_38381[(54)] = inst_38014);

(statearr_38381[(55)] = inst_38025);

return statearr_38381;
})();
var statearr_38382_38548 = state_38262__$1;
(statearr_38382_38548[(2)] = null);

(statearr_38382_38548[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (68))){
var inst_38045 = (state_38262[(7)]);
var inst_38014 = (state_38262[(54)]);
var inst_38051 = (state_38262[(2)]);
var inst_38052 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38014,inst_38045) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38014,inst_38045));
var state_38262__$1 = (function (){var statearr_38383 = state_38262;
(statearr_38383[(56)] = inst_38051);

return statearr_38383;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38262__$1,(69),inst_38052);
} else {
if((state_val_38263 === (11))){
var inst_37916 = (state_38262[(39)]);
var inst_37916__$1 = (state_38262[(2)]);
var inst_37918 = cljs.core.contains_QMARK_(inst_37916__$1,cljs.core.cst$kw$componentFollow_QMARK_);
var inst_37919 = (!(inst_37918));
var state_38262__$1 = (function (){var statearr_38384 = state_38262;
(statearr_38384[(39)] = inst_37916__$1);

return statearr_38384;
})();
if(inst_37919){
var statearr_38385_38549 = state_38262__$1;
(statearr_38385_38549[(1)] = (12));

} else {
var statearr_38386_38550 = state_38262__$1;
(statearr_38386_38550[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (115))){
var inst_38255 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
var statearr_38388_38551 = state_38262__$1;
(statearr_38388_38551[(2)] = inst_38255);

(statearr_38388_38551[(1)] = (112));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (9))){
var inst_37910 = cljs.core.first(flakes);
var inst_37911 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_37910);
var inst_37912 = cljs.core.cst$kw$compact_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
var inst_37913 = fluree.db.query.fql.wildcard_pred_spec(db,cache,inst_37911,inst_37912);
var state_38262__$1 = state_38262;
var statearr_38389_38552 = state_38262__$1;
(statearr_38389_38552[(2)] = inst_37913);

(statearr_38389_38552[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (5))){
var _ = (function (){var statearr_38390 = state_38262;
(statearr_38390[(4)] = cljs.core.rest((state_38262[(4)])));

return statearr_38390;
})();
var state_38262__$1 = state_38262;
var ex38387 = (state_38262__$1[(2)]);
var statearr_38391_38553 = state_38262__$1;
(statearr_38391_38553[(5)] = ex38387);


if((ex38387 instanceof Error)){
var statearr_38392_38554 = state_38262__$1;
(statearr_38392_38554[(1)] = (4));

(statearr_38392_38554[(5)] = null);

} else {
throw ex38387;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (112))){
var inst_38257 = (state_38262[(2)]);
var _ = (function (){var statearr_38393 = state_38262;
(statearr_38393[(4)] = cljs.core.rest((state_38262[(4)])));

return statearr_38393;
})();
var state_38262__$1 = state_38262;
var statearr_38394_38555 = state_38262__$1;
(statearr_38394_38555[(2)] = inst_38257);

(statearr_38394_38555[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (83))){
var inst_38082 = (state_38262[(9)]);
var state_38262__$1 = state_38262;
var statearr_38395_38556 = state_38262__$1;
(statearr_38395_38556[(2)] = inst_38082);

(statearr_38395_38556[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (14))){
var inst_37916 = (state_38262[(39)]);
var inst_37924 = (state_38262[(2)]);
var inst_37925 = cljs.core.contains_QMARK_(inst_37916,cljs.core.cst$kw$compact_QMARK_);
var inst_37926 = (!(inst_37925));
var state_38262__$1 = (function (){var statearr_38396 = state_38262;
(statearr_38396[(40)] = inst_37924);

return statearr_38396;
})();
if(inst_37926){
var statearr_38397_38557 = state_38262__$1;
(statearr_38397_38557[(1)] = (15));

} else {
var statearr_38398_38558 = state_38262__$1;
(statearr_38398_38558[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (45))){
var inst_37942 = (state_38262[(20)]);
var inst_37946 = (state_38262[(25)]);
var inst_37982 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,inst_37942);
var inst_37983 = cljs.core.count(inst_37982);
var inst_37984 = (inst_37983 >= inst_37946);
var state_38262__$1 = state_38262;
var statearr_38399_38559 = state_38262__$1;
(statearr_38399_38559[(2)] = inst_37984);

(statearr_38399_38559[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (53))){
var inst_38009 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_38009)){
var statearr_38400_38560 = state_38262__$1;
(statearr_38400_38560[(1)] = (57));

} else {
var statearr_38401_38561 = state_38262__$1;
(statearr_38401_38561[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (78))){
var inst_38097 = (state_38262[(42)]);
var state_38262__$1 = state_38262;
var statearr_38402_38562 = state_38262__$1;
(statearr_38402_38562[(2)] = inst_38097);

(statearr_38402_38562[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (26))){
var inst_37964 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37964)){
var statearr_38403_38563 = state_38262__$1;
(statearr_38403_38563[(1)] = (33));

} else {
var statearr_38404_38564 = state_38262__$1;
(statearr_38404_38564[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (16))){
var inst_37924 = (state_38262[(40)]);
var state_38262__$1 = state_38262;
var statearr_38405_38565 = state_38262__$1;
(statearr_38405_38565[(2)] = inst_37924);

(statearr_38405_38565[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (81))){
var inst_37931 = (state_38262[(17)]);
var inst_38088 = (state_38262[(43)]);
var inst_38104 = (state_38262[(2)]);
var inst_38105 = fluree.db.util.async.throw_err(inst_38104);
var inst_38106 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38107 = inst_38088.o;
var inst_38108 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37931);
var inst_38109 = [inst_38107,inst_38108];
var inst_38110 = (new cljs.core.PersistentVector(null,2,(5),inst_38106,inst_38109,null));
var inst_38111 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,inst_38110,inst_38105);
var state_38262__$1 = (function (){var statearr_38406 = state_38262;
(statearr_38406[(57)] = inst_38111);

return statearr_38406;
})();
var statearr_38407_38566 = state_38262__$1;
(statearr_38407_38566[(2)] = inst_38105);

(statearr_38407_38566[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (79))){
var inst_37931 = (state_38262[(17)]);
var inst_38088 = (state_38262[(43)]);
var inst_38100 = inst_38088.o;
var inst_38101 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(inst_37931);
var inst_38102 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_38100,inst_38101);
var state_38262__$1 = state_38262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38262__$1,(81),inst_38102);
} else {
if((state_val_38263 === (38))){
var inst_37966 = (state_38262[(48)]);
var inst_37974 = (state_38262[(2)]);
var inst_37975 = [null,inst_37974];
var inst_37976 = (new cljs.core.PersistentVector(null,2,(5),inst_37966,inst_37975,null));
var state_38262__$1 = state_38262;
var statearr_38408_38567 = state_38262__$1;
(statearr_38408_38567[(2)] = inst_37976);

(statearr_38408_38567[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (98))){
var inst_37901 = (state_38262[(38)]);
var inst_38169 = (state_38262[(30)]);
var inst_38178 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_];
var inst_38179 = [true,inst_37901];
var inst_38180 = cljs.core.PersistentHashMap.fromArrays(inst_38178,inst_38179);
var inst_38181 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38180,inst_38169) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38180,inst_38169));
var state_38262__$1 = state_38262;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38262__$1,(100),inst_38181);
} else {
if((state_val_38263 === (87))){
var inst_38133 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_38133)){
var statearr_38409_38568 = state_38262__$1;
(statearr_38409_38568[(1)] = (88));

} else {
var statearr_38410_38569 = state_38262__$1;
(statearr_38410_38569[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (30))){
var inst_37949 = (state_38262[(22)]);
var inst_37954 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(offset_map,inst_37949);
var inst_37955 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_37954);
var state_38262__$1 = state_38262;
var statearr_38411_38570 = state_38262__$1;
(statearr_38411_38570[(2)] = inst_37955);

(statearr_38411_38570[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (73))){
var inst_38081 = (state_38262[(8)]);
var inst_38088 = (state_38262[(43)]);
var inst_38087 = cljs.core.seq(inst_38081);
var inst_38088__$1 = cljs.core.first(inst_38087);
var inst_38089 = cljs.core.next(inst_38087);
var state_38262__$1 = (function (){var statearr_38412 = state_38262;
(statearr_38412[(58)] = inst_38089);

(statearr_38412[(43)] = inst_38088__$1);

return statearr_38412;
})();
if(cljs.core.truth_(inst_38088__$1)){
var statearr_38413_38571 = state_38262__$1;
(statearr_38413_38571[(1)] = (75));

} else {
var statearr_38414_38572 = state_38262__$1;
(statearr_38414_38572[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (96))){
var inst_38169 = (state_38262[(30)]);
var inst_38168 = (state_38262[(2)]);
var inst_38169__$1 = fluree.db.util.async.throw_err(inst_38168);
var inst_38170 = cljs.core.empty_QMARK_(inst_38169__$1);
var state_38262__$1 = (function (){var statearr_38415 = state_38262;
(statearr_38415[(30)] = inst_38169__$1);

return statearr_38415;
})();
if(inst_38170){
var statearr_38416_38573 = state_38262__$1;
(statearr_38416_38573[(1)] = (97));

} else {
var statearr_38417_38574 = state_38262__$1;
(statearr_38417_38574[(1)] = (98));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (10))){
var state_38262__$1 = state_38262;
var statearr_38418_38575 = state_38262__$1;
(statearr_38418_38575[(2)] = pred_spec);

(statearr_38418_38575[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (18))){
var inst_37932 = (state_38262[(51)]);
var state_38262__$1 = state_38262;
var statearr_38419_38576 = state_38262__$1;
(statearr_38419_38576[(2)] = inst_37932);

(statearr_38419_38576[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (105))){
var state_38262__$1 = state_38262;
var statearr_38420_38577 = state_38262__$1;
(statearr_38420_38577[(1)] = (107));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (52))){
var inst_37999 = (state_38262[(59)]);
var state_38262__$1 = state_38262;
var statearr_38422_38578 = state_38262__$1;
(statearr_38422_38578[(2)] = inst_37999);

(statearr_38422_38578[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (114))){
var state_38262__$1 = state_38262;
var statearr_38423_38579 = state_38262__$1;
(statearr_38423_38579[(1)] = (116));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (67))){
var state_38262__$1 = state_38262;
var statearr_38425_38580 = state_38262__$1;
(statearr_38425_38580[(2)] = null);

(statearr_38425_38580[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (71))){
var inst_38128 = (state_38262[(16)]);
var inst_38128__$1 = componentFollow_QMARK_;
var state_38262__$1 = (function (){var statearr_38426 = state_38262;
(statearr_38426[(16)] = inst_38128__$1);

return statearr_38426;
})();
if(cljs.core.truth_(inst_38128__$1)){
var statearr_38427_38581 = state_38262__$1;
(statearr_38427_38581[(1)] = (85));

} else {
var statearr_38428_38582 = state_38262__$1;
(statearr_38428_38582[(1)] = (86));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (42))){
var inst_37946 = (state_38262[(25)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37946)){
var statearr_38429_38583 = state_38262__$1;
(statearr_38429_38583[(1)] = (45));

} else {
var statearr_38430_38584 = state_38262__$1;
(statearr_38430_38584[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (80))){
var inst_38113 = (state_38262[(52)]);
var inst_38113__$1 = (state_38262[(2)]);
var state_38262__$1 = (function (){var statearr_38431 = state_38262;
(statearr_38431[(52)] = inst_38113__$1);

return statearr_38431;
})();
if(cljs.core.truth_(inst_38113__$1)){
var statearr_38432_38585 = state_38262__$1;
(statearr_38432_38585[(1)] = (82));

} else {
var statearr_38433_38586 = state_38262__$1;
(statearr_38433_38586[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (37))){
var inst_37949 = (state_38262[(22)]);
var inst_37948 = (state_38262[(24)]);
var inst_37971 = (inst_37948 - (1));
var inst_37972 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(offset_map,inst_37949,inst_37971);
var state_38262__$1 = state_38262;
var statearr_38434_38587 = state_38262__$1;
(statearr_38434_38587[(2)] = inst_37972);

(statearr_38434_38587[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (63))){
var inst_38029 = (state_38262[(29)]);
var state_38262__$1 = state_38262;
var statearr_38435_38588 = state_38262__$1;
(statearr_38435_38588[(2)] = inst_38029);

(statearr_38435_38588[(1)] = (64));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (94))){
var inst_38149 = (state_38262[(35)]);
var state_38262__$1 = state_38262;
var statearr_38436_38589 = state_38262__$1;
(statearr_38436_38589[(2)] = inst_38149);

(statearr_38436_38589[(1)] = (95));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (8))){
var inst_37908 = (state_38262[(2)]);
var state_38262__$1 = state_38262;
if(cljs.core.truth_(inst_37908)){
var statearr_38437_38590 = state_38262__$1;
(statearr_38437_38590[(1)] = (9));

} else {
var statearr_38438_38591 = state_38262__$1;
(statearr_38438_38591[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (49))){
var inst_37999 = (state_38262[(59)]);
var inst_37999__$1 = cljs.core.not(recur_QMARK_);
var state_38262__$1 = (function (){var statearr_38439 = state_38262;
(statearr_38439[(59)] = inst_37999__$1);

return statearr_38439;
})();
if(inst_37999__$1){
var statearr_38440_38592 = state_38262__$1;
(statearr_38440_38592[(1)] = (51));

} else {
var statearr_38441_38593 = state_38262__$1;
(statearr_38441_38593[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38263 === (84))){
var inst_38089 = (state_38262[(58)]);
var inst_38118 = (state_38262[(2)]);
var inst_38081 = inst_38089;
var inst_38082 = inst_38118;
var state_38262__$1 = (function (){var statearr_38442 = state_38262;
(statearr_38442[(8)] = inst_38081);

(statearr_38442[(9)] = inst_38082);

return statearr_38442;
})();
var statearr_38443_38594 = state_38262__$1;
(statearr_38443_38594[(2)] = null);

(statearr_38443_38594[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_38444 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38444[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_38444[(1)] = (1));

return statearr_38444;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_38262){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_38262);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e38445){var ex__16398__auto__ = e38445;
var statearr_38446_38595 = state_38262;
(statearr_38446_38595[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_38262[(4)]))){
var statearr_38447_38596 = state_38262;
(statearr_38447_38596[(1)] = cljs.core.first((state_38262[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__38597 = state_38262;
state_38262 = G__38597;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_38262){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_38262);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_38448 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_38448[(6)] = c__16469__auto__);

return statearr_38448;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.add_pred.cljs$lang$maxFixedArity = 10);

/**
 * Resolves a full predicate select spec in case there are
 *   any namespace lookups (:ns-lookup) in the map that
 *   need to be resolved for this given subject.
 */
fluree.db.query.fql.full_select_spec = (function fluree$db$query$fql$full_select_spec(db,cache,base_pred_spec,subject_id){
var coll_id = fluree.db.flake.sid__GT_cid(subject_id);
var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(cache),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null));
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var lookup_specs = fluree.db.query.fql_parser.ns_lookup_pred_spec(db,coll_id,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(base_pred_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null)));
var updated_spec = cljs.core.update.cljs$core$IFn$_invoke$arity$3(base_pred_spec,cljs.core.cst$kw$select,(function (sel){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(sel,cljs.core.cst$kw$pred_DASH_id,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([lookup_specs,cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(sel)], 0))),cljs.core.cst$kw$ns_DASH_lookup);
}));
fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$4(cache,cljs.core.assoc,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [coll_id,base_pred_spec], null),updated_spec);

return updated_spec;
}
});
/**
 * Returns true if the predicate spec has a sub-selection that requires a namespace lookup.
 */
fluree.db.query.fql.has_ns_lookups_QMARK_ = (function fluree$db$query$fql$has_ns_lookups_QMARK_(select_spec){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$ns_DASH_lookup], null));
});
fluree.db.query.fql.s = (function fluree$db$query$fql$s(f){
return f.s;
});
fluree.db.query.fql.o = (function fluree$db$query$fql$o(f){
return f.o;
});
/**
 * Resolves all reverse references into a result map.
 */
fluree.db.query.fql.resolve_reverse_refs = (function fluree$db$query$fql$resolve_reverse_refs(db,cache,fuel,max_fuel,subject_id,reverse_refs_specs){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_38757){
var state_val_38758 = (state_38757[(1)]);
if((state_val_38758 === (7))){
var inst_38752 = (state_38757[(2)]);
var _ = (function (){var statearr_38759 = state_38757;
(statearr_38759[(4)] = cljs.core.rest((state_38757[(4)])));

return statearr_38759;
})();
var state_38757__$1 = state_38757;
var statearr_38760_38842 = state_38757__$1;
(statearr_38760_38842[(2)] = inst_38752);

(statearr_38760_38842[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (20))){
var inst_38679 = (state_38757[(7)]);
var state_38757__$1 = state_38757;
var statearr_38761_38843 = state_38757__$1;
(statearr_38761_38843[(2)] = inst_38679);

(statearr_38761_38843[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (27))){
var inst_38634 = (state_38757[(8)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38634)){
var statearr_38762_38844 = state_38757__$1;
(statearr_38762_38844[(1)] = (29));

} else {
var statearr_38763_38845 = state_38757__$1;
(statearr_38763_38845[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (1))){
var state_38757__$1 = state_38757;
var statearr_38764_38846 = state_38757__$1;
(statearr_38764_38846[(2)] = null);

(statearr_38764_38846[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (24))){
var inst_38635 = (state_38757[(9)]);
var state_38757__$1 = state_38757;
var statearr_38765_38847 = state_38757__$1;
(statearr_38765_38847[(2)] = inst_38635);

(statearr_38765_38847[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (39))){
var inst_38671 = (state_38757[(10)]);
var state_38757__$1 = state_38757;
var statearr_38766_38848 = state_38757__$1;
(statearr_38766_38848[(2)] = inst_38671);

(statearr_38766_38848[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (46))){
var inst_38636 = (state_38757[(11)]);
var state_38757__$1 = state_38757;
var statearr_38767_38849 = state_38757__$1;
(statearr_38767_38849[(2)] = inst_38636);

(statearr_38767_38849[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (4))){
var inst_38598 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38768_38850 = state_38757__$1;
(statearr_38768_38850[(2)] = inst_38598);

(statearr_38768_38850[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (15))){
var inst_38647 = (state_38757[(12)]);
var inst_38653 = cljs.core.count(inst_38647);
var inst_38654 = fluree.db.query.fql.add_fuel(fuel,inst_38653,max_fuel);
var state_38757__$1 = state_38757;
var statearr_38769_38851 = state_38757__$1;
(statearr_38769_38851[(2)] = inst_38654);

(statearr_38769_38851[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (48))){
var inst_38623 = (state_38757[(13)]);
var inst_38616 = (state_38757[(14)]);
var inst_38738 = (state_38757[(15)]);
var inst_38746 = (state_38757[(2)]);
var inst_38747 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_38616,inst_38746,inst_38738);
var inst_38615 = inst_38623;
var inst_38616__$1 = inst_38747;
var state_38757__$1 = (function (){var statearr_38770 = state_38757;
(statearr_38770[(16)] = inst_38615);

(statearr_38770[(14)] = inst_38616__$1);

return statearr_38770;
})();
var statearr_38771_38852 = state_38757__$1;
(statearr_38771_38852[(2)] = null);

(statearr_38771_38852[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (50))){
var inst_38638 = (state_38757[(17)]);
var state_38757__$1 = state_38757;
var statearr_38772_38853 = state_38757__$1;
(statearr_38772_38853[(2)] = inst_38638);

(statearr_38772_38853[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (21))){
var inst_38635 = (state_38757[(9)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38635)){
var statearr_38774_38854 = state_38757__$1;
(statearr_38774_38854[(1)] = (23));

} else {
var statearr_38775_38855 = state_38757__$1;
(statearr_38775_38855[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (31))){
var inst_38695 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38695)){
var statearr_38776_38856 = state_38757__$1;
(statearr_38776_38856[(1)] = (32));

} else {
var statearr_38777_38857 = state_38757__$1;
(statearr_38777_38857[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (32))){
var inst_38671 = (state_38757[(10)]);
var inst_38670 = (state_38757[(18)]);
var inst_38678 = (state_38757[(19)]);
var inst_38697 = (inst_38670 + (1));
var tmp38773 = inst_38671;
var inst_38669 = inst_38678;
var inst_38670__$1 = inst_38697;
var inst_38671__$1 = tmp38773;
var state_38757__$1 = (function (){var statearr_38778 = state_38757;
(statearr_38778[(10)] = inst_38671__$1);

(statearr_38778[(18)] = inst_38670__$1);

(statearr_38778[(20)] = inst_38669);

return statearr_38778;
})();
var statearr_38779_38858 = state_38757__$1;
(statearr_38779_38858[(2)] = null);

(statearr_38779_38858[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (40))){
var state_38757__$1 = state_38757;
if(cljs.core.truth_(fuel)){
var statearr_38780_38859 = state_38757__$1;
(statearr_38780_38859[(1)] = (42));

} else {
var statearr_38781_38860 = state_38757__$1;
(statearr_38781_38860[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (33))){
var state_38757__$1 = state_38757;
var statearr_38782_38861 = state_38757__$1;
(statearr_38782_38861[(1)] = (35));



return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (13))){
var inst_38647 = (state_38757[(12)]);
var state_38757__$1 = state_38757;
var statearr_38784_38862 = state_38757__$1;
(statearr_38784_38862[(2)] = inst_38647);

(statearr_38784_38862[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (22))){
var inst_38688 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38688)){
var statearr_38785_38863 = state_38757__$1;
(statearr_38785_38863[(1)] = (26));

} else {
var statearr_38786_38864 = state_38757__$1;
(statearr_38786_38864[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (36))){
var state_38757__$1 = state_38757;
var statearr_38787_38865 = state_38757__$1;
(statearr_38787_38865[(2)] = null);

(statearr_38787_38865[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (41))){
var inst_38670 = (state_38757[(18)]);
var inst_38678 = (state_38757[(19)]);
var inst_38727 = (state_38757[(2)]);
var inst_38728 = (inst_38670 + (1));
var inst_38669 = inst_38678;
var inst_38670__$1 = inst_38728;
var inst_38671 = inst_38727;
var state_38757__$1 = (function (){var statearr_38788 = state_38757;
(statearr_38788[(10)] = inst_38671);

(statearr_38788[(18)] = inst_38670__$1);

(statearr_38788[(20)] = inst_38669);

return statearr_38788;
})();
var statearr_38789_38866 = state_38757__$1;
(statearr_38789_38866[(2)] = null);

(statearr_38789_38866[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (43))){
var state_38757__$1 = state_38757;
var statearr_38790_38867 = state_38757__$1;
(statearr_38790_38867[(2)] = null);

(statearr_38790_38867[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (29))){
var inst_38634 = (state_38757[(8)]);
var inst_38670 = (state_38757[(18)]);
var inst_38692 = (inst_38670 < inst_38634);
var state_38757__$1 = state_38757;
var statearr_38791_38868 = state_38757__$1;
(statearr_38791_38868[(2)] = inst_38692);

(statearr_38791_38868[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (44))){
var inst_38707 = (state_38757[(21)]);
var inst_38711 = (state_38757[(22)]);
var inst_38720 = (state_38757[(2)]);
var inst_38721 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38711,inst_38707) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38711,inst_38707));
var state_38757__$1 = (function (){var statearr_38792 = state_38757;
(statearr_38792[(23)] = inst_38720);

return statearr_38792;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38757__$1,(45),inst_38721);
} else {
if((state_val_38758 === (6))){
var inst_38615 = (state_38757[(16)]);
var inst_38622 = (state_38757[(24)]);
var inst_38621 = cljs.core.seq(inst_38615);
var inst_38622__$1 = cljs.core.first(inst_38621);
var inst_38623 = cljs.core.next(inst_38621);
var inst_38624 = cljs.core.not(inst_38622__$1);
var state_38757__$1 = (function (){var statearr_38793 = state_38757;
(statearr_38793[(13)] = inst_38623);

(statearr_38793[(24)] = inst_38622__$1);

return statearr_38793;
})();
if(inst_38624){
var statearr_38794_38869 = state_38757__$1;
(statearr_38794_38869[(1)] = (8));

} else {
var statearr_38795_38870 = state_38757__$1;
(statearr_38795_38870[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (28))){
var inst_38736 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38796_38871 = state_38757__$1;
(statearr_38796_38871[(2)] = inst_38736);

(statearr_38796_38871[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (51))){
var inst_38744 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38797_38872 = state_38757__$1;
(statearr_38797_38872[(2)] = inst_38744);

(statearr_38797_38872[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (25))){
var inst_38686 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38798_38873 = state_38757__$1;
(statearr_38798_38873[(2)] = inst_38686);

(statearr_38798_38873[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (34))){
var inst_38734 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38799_38874 = state_38757__$1;
(statearr_38799_38874[(2)] = inst_38734);

(statearr_38799_38874[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (17))){
var inst_38647 = (state_38757[(12)]);
var inst_38657 = (state_38757[(2)]);
var inst_38665 = cljs.core.seq(inst_38647);
var inst_38666 = cljs.core.first(inst_38665);
var inst_38667 = cljs.core.next(inst_38665);
var inst_38668 = cljs.core.PersistentVector.EMPTY;
var inst_38669 = inst_38647;
var inst_38670 = (0);
var inst_38671 = inst_38668;
var state_38757__$1 = (function (){var statearr_38800 = state_38757;
(statearr_38800[(10)] = inst_38671);

(statearr_38800[(18)] = inst_38670);

(statearr_38800[(20)] = inst_38669);

(statearr_38800[(25)] = inst_38657);

(statearr_38800[(26)] = inst_38666);

(statearr_38800[(27)] = inst_38667);

return statearr_38800;
})();
var statearr_38801_38875 = state_38757__$1;
(statearr_38801_38875[(2)] = null);

(statearr_38801_38875[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (3))){
var inst_38755 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
return cljs.core.async.impl.ioc_helpers.return_chan(state_38757__$1,inst_38755);
} else {
if((state_val_38758 === (12))){
var state_38757__$1 = state_38757;
var statearr_38802_38876 = state_38757__$1;
(statearr_38802_38876[(2)] = fuel);

(statearr_38802_38876[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (2))){
var _ = (function (){var statearr_38803 = state_38757;
(statearr_38803[(4)] = cljs.core.cons((5),(state_38757[(4)])));

return statearr_38803;
})();
var inst_38611 = reverse_refs_specs;
var inst_38612 = cljs.core.seq(inst_38611);
var inst_38613 = cljs.core.first(inst_38612);
var inst_38614 = cljs.core.next(inst_38612);
var inst_38615 = inst_38611;
var inst_38616 = null;
var state_38757__$1 = (function (){var statearr_38804 = state_38757;
(statearr_38804[(16)] = inst_38615);

(statearr_38804[(28)] = inst_38614);

(statearr_38804[(29)] = inst_38613);

(statearr_38804[(14)] = inst_38616);

return statearr_38804;
})();
var statearr_38805_38877 = state_38757__$1;
(statearr_38805_38877[(2)] = null);

(statearr_38805_38877[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (23))){
var inst_38670 = (state_38757[(18)]);
var inst_38635 = (state_38757[(9)]);
var inst_38683 = (inst_38670 >= inst_38635);
var state_38757__$1 = state_38757;
var statearr_38806_38878 = state_38757__$1;
(statearr_38806_38878[(2)] = inst_38683);

(statearr_38806_38878[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (47))){
var inst_38637 = (state_38757[(30)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38637)){
var statearr_38807_38879 = state_38757__$1;
(statearr_38807_38879[(1)] = (49));

} else {
var statearr_38808_38880 = state_38757__$1;
(statearr_38808_38880[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (35))){
var inst_38677 = (state_38757[(31)]);
var inst_38701 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38702 = [inst_38677];
var inst_38703 = (new cljs.core.PersistentVector(null,1,(5),inst_38701,inst_38702,null));
var inst_38704 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38703);
var state_38757__$1 = state_38757;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38757__$1,(38),inst_38704);
} else {
if((state_val_38758 === (19))){
var inst_38636 = (state_38757[(11)]);
var inst_38738 = (state_38757[(2)]);
var state_38757__$1 = (function (){var statearr_38809 = state_38757;
(statearr_38809[(15)] = inst_38738);

return statearr_38809;
})();
if(cljs.core.truth_(inst_38636)){
var statearr_38810_38881 = state_38757__$1;
(statearr_38810_38881[(1)] = (46));

} else {
var statearr_38811_38882 = state_38757__$1;
(statearr_38811_38882[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (11))){
var inst_38647 = (state_38757[(12)]);
var inst_38644 = (state_38757[(2)]);
var inst_38645 = fluree.db.util.async.throw_err(inst_38644);
var inst_38646 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_38645);
var inst_38647__$1 = cljs.core.not_empty(inst_38646);
var state_38757__$1 = (function (){var statearr_38813 = state_38757;
(statearr_38813[(12)] = inst_38647__$1);

return statearr_38813;
})();
if(cljs.core.truth_(inst_38647__$1)){
var statearr_38814_38883 = state_38757__$1;
(statearr_38814_38883[(1)] = (12));

} else {
var statearr_38815_38884 = state_38757__$1;
(statearr_38815_38884[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (9))){
var inst_38632 = (state_38757[(32)]);
var inst_38622 = (state_38757[(24)]);
var inst_38631 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38622,(0),null);
var inst_38632__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_38622,(1),null);
var inst_38633 = cljs.core.__destructure_map(inst_38632__$1);
var inst_38634 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38633,cljs.core.cst$kw$offset);
var inst_38635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38633,cljs.core.cst$kw$limit);
var inst_38636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38633,cljs.core.cst$kw$as);
var inst_38637 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38633,cljs.core.cst$kw$name);
var inst_38638 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38633,cljs.core.cst$kw$p);
var inst_38639 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38640 = [subject_id,inst_38631];
var inst_38641 = (new cljs.core.PersistentVector(null,2,(5),inst_38639,inst_38640,null));
var inst_38642 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_38641);
var state_38757__$1 = (function (){var statearr_38816 = state_38757;
(statearr_38816[(8)] = inst_38634);

(statearr_38816[(32)] = inst_38632__$1);

(statearr_38816[(17)] = inst_38638);

(statearr_38816[(30)] = inst_38637);

(statearr_38816[(11)] = inst_38636);

(statearr_38816[(9)] = inst_38635);

return statearr_38816;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_38757__$1,(11),inst_38642);
} else {
if((state_val_38758 === (5))){
var _ = (function (){var statearr_38817 = state_38757;
(statearr_38817[(4)] = cljs.core.rest((state_38757[(4)])));

return statearr_38817;
})();
var state_38757__$1 = state_38757;
var ex38812 = (state_38757__$1[(2)]);
var statearr_38818_38885 = state_38757__$1;
(statearr_38818_38885[(5)] = ex38812);


if((ex38812 instanceof Error)){
var statearr_38819_38886 = state_38757__$1;
(statearr_38819_38886[(1)] = (4));

(statearr_38819_38886[(5)] = null);

} else {
throw ex38812;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (14))){
var inst_38651 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
if(cljs.core.truth_(inst_38651)){
var statearr_38820_38887 = state_38757__$1;
(statearr_38820_38887[(1)] = (15));

} else {
var statearr_38821_38888 = state_38757__$1;
(statearr_38821_38888[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (45))){
var inst_38671 = (state_38757[(10)]);
var inst_38723 = (state_38757[(2)]);
var inst_38724 = fluree.db.util.async.throw_err(inst_38723);
var inst_38725 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38671,inst_38724);
var state_38757__$1 = state_38757;
var statearr_38822_38889 = state_38757__$1;
(statearr_38822_38889[(2)] = inst_38725);

(statearr_38822_38889[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (26))){
var inst_38671 = (state_38757[(10)]);
var state_38757__$1 = state_38757;
var statearr_38823_38890 = state_38757__$1;
(statearr_38823_38890[(2)] = inst_38671);

(statearr_38823_38890[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (16))){
var state_38757__$1 = state_38757;
var statearr_38824_38891 = state_38757__$1;
(statearr_38824_38891[(2)] = null);

(statearr_38824_38891[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (38))){
var inst_38632 = (state_38757[(32)]);
var inst_38707 = (state_38757[(21)]);
var inst_38706 = (state_38757[(2)]);
var inst_38707__$1 = fluree.db.util.async.throw_err(inst_38706);
var inst_38708 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38709 = [cljs.core.cst$kw$wildcard_QMARK_,cljs.core.cst$kw$compact_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$limit];
var inst_38710 = (new cljs.core.PersistentVector(null,4,(5),inst_38708,inst_38709,null));
var inst_38711 = cljs.core.select_keys(inst_38632,inst_38710);
var inst_38712 = cljs.core.empty_QMARK_(inst_38707__$1);
var state_38757__$1 = (function (){var statearr_38825 = state_38757;
(statearr_38825[(21)] = inst_38707__$1);

(statearr_38825[(22)] = inst_38711);

return statearr_38825;
})();
if(inst_38712){
var statearr_38826_38892 = state_38757__$1;
(statearr_38826_38892[(1)] = (39));

} else {
var statearr_38827_38893 = state_38757__$1;
(statearr_38827_38893[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (30))){
var inst_38634 = (state_38757[(8)]);
var state_38757__$1 = state_38757;
var statearr_38828_38894 = state_38757__$1;
(statearr_38828_38894[(2)] = inst_38634);

(statearr_38828_38894[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (10))){
var inst_38750 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38829_38895 = state_38757__$1;
(statearr_38829_38895[(2)] = inst_38750);

(statearr_38829_38895[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (18))){
var inst_38679 = (state_38757[(7)]);
var inst_38669 = (state_38757[(20)]);
var inst_38677 = (state_38757[(31)]);
var inst_38676 = cljs.core.seq(inst_38669);
var inst_38677__$1 = cljs.core.first(inst_38676);
var inst_38678 = cljs.core.next(inst_38676);
var inst_38679__$1 = cljs.core.not(inst_38677__$1);
var state_38757__$1 = (function (){var statearr_38830 = state_38757;
(statearr_38830[(7)] = inst_38679__$1);

(statearr_38830[(31)] = inst_38677__$1);

(statearr_38830[(19)] = inst_38678);

return statearr_38830;
})();
if(inst_38679__$1){
var statearr_38831_38896 = state_38757__$1;
(statearr_38831_38896[(1)] = (20));

} else {
var statearr_38832_38897 = state_38757__$1;
(statearr_38832_38897[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (42))){
var inst_38707 = (state_38757[(21)]);
var inst_38716 = cljs.core.count(inst_38707);
var inst_38717 = fluree.db.query.fql.add_fuel(fuel,inst_38716,max_fuel);
var state_38757__$1 = state_38757;
var statearr_38833_38898 = state_38757__$1;
(statearr_38833_38898[(2)] = inst_38717);

(statearr_38833_38898[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (37))){
var inst_38732 = (state_38757[(2)]);
var state_38757__$1 = state_38757;
var statearr_38834_38899 = state_38757__$1;
(statearr_38834_38899[(2)] = inst_38732);

(statearr_38834_38899[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (8))){
var inst_38616 = (state_38757[(14)]);
var state_38757__$1 = state_38757;
var statearr_38835_38900 = state_38757__$1;
(statearr_38835_38900[(2)] = inst_38616);

(statearr_38835_38900[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_38758 === (49))){
var inst_38637 = (state_38757[(30)]);
var state_38757__$1 = state_38757;
var statearr_38836_38901 = state_38757__$1;
(statearr_38836_38901[(2)] = inst_38637);

(statearr_38836_38901[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0 = (function (){
var statearr_38837 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_38837[(0)] = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__);

(statearr_38837[(1)] = (1));

return statearr_38837;
});
var fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1 = (function (state_38757){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_38757);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e38838){var ex__16398__auto__ = e38838;
var statearr_38839_38902 = state_38757;
(statearr_38839_38902[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_38757[(4)]))){
var statearr_38840_38903 = state_38757;
(statearr_38840_38903[(1)] = cljs.core.first((state_38757[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__38904 = state_38757;
state_38757 = G__38904;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__ = function(state_38757){
switch(arguments.length){
case 0:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1.call(this,state_38757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____0;
fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto____1;
return fluree$db$query$fql$resolve_reverse_refs_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_38841 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_38841[(6)] = c__16469__auto__);

return statearr_38841;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.component_follow_QMARK_ = (function fluree$db$query$fql$component_follow_QMARK_(pred_spec,select_spec){
if(cljs.core.contains_QMARK_(pred_spec,cljs.core.cst$kw$componentFollow_QMARK_)){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
} else {
if((!((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec) == null)))){
return cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
} else {
if(cljs.core.truth_((function (){var or__4212__auto__ = cljs.core.cst$kw$component_QMARK_.cljs$core$IFn$_invoke$arity$1(pred_spec);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec);
}
})())){
return true;
} else {
return null;
}
}
}
});
fluree.db.query.fql.select_spec__GT_reverse_pred_specs = (function fluree$db$query$fql$select_spec__GT_reverse_pred_specs(select_spec){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (acc,spec){
var key_spec = cljs.core.key(spec);
var val_spec = (((cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(cljs.core.val(spec)) == null))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.val(spec),cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$componentFollow_QMARK_.cljs$core$IFn$_invoke$arity$1(select_spec)):cljs.core.val(spec));
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,key_spec,val_spec);
}),cljs.core.PersistentArrayMap.EMPTY,cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(select_spec,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse], null)));
});
/**
 * Like conj, but if collection is nil creates a new vector instead of list.
 *   Not built to handle variable arity values
 */
fluree.db.query.fql.conjv = (function fluree$db$query$fql$conjv(coll,x){
if((coll == null)){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[x],null));
} else {
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
});
/**
 * For recursion, takes current select-spec and nests the recur predicate as a child, updating
 *   recur-depth and recur-seen values. Uses flake as the recursion flake being operated on.
 */
fluree.db.query.fql.recur_select_spec = (function fluree$db$query$fql$recur_select_spec(select_spec,flake){
var recur_subject = flake.o;
var recur_pred = flake.p;
var map__38905 = select_spec;
var map__38905__$1 = cljs.core.__destructure_map(map__38905);
var recur_seen = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38905__$1,cljs.core.cst$kw$recur_DASH_seen);
var recur_depth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__38905__$1,cljs.core.cst$kw$recur_DASH_depth);
return cljs.core.select_keys(cljs.core.assoc_in(cljs.core.assoc_in(cljs.core.assoc_in(select_spec,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred], null),select_spec),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_depth], null),(recur_depth + (1))),new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,recur_pred,cljs.core.cst$kw$recur_DASH_seen], null),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(recur_seen,recur_subject)),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$select,cljs.core.cst$kw$componentFollow_QMARK_,cljs.core.cst$kw$compact_QMARK_], null));
});
/**
 * Performs recursion on a select spec graph crawl when specified. flakes input is list
 *   of flakes all with the same subject and predicate values.
 */
fluree.db.query.fql.flake__GT_recur = (function fluree$db$query$fql$flake__GT_recur(db,flakes,select_spec,results,fuel,max_fuel,cache){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39019){
var state_val_39020 = (state_39019[(1)]);
if((state_val_39020 === (7))){
var inst_38931 = flakes;
var inst_38932 = cljs.core.seq(inst_38931);
var inst_38933 = cljs.core.first(inst_38932);
var inst_38934 = cljs.core.next(inst_38932);
var inst_38935 = cljs.core.PersistentVector.EMPTY;
var inst_38936 = inst_38931;
var inst_38937 = (0);
var inst_38938 = inst_38935;
var state_39019__$1 = (function (){var statearr_39021 = state_39019;
(statearr_39021[(7)] = inst_38936);

(statearr_39021[(8)] = inst_38938);

(statearr_39021[(9)] = inst_38934);

(statearr_39021[(10)] = inst_38937);

(statearr_39021[(11)] = inst_38933);

return statearr_39021;
})();
var statearr_39022_39088 = state_39019__$1;
(statearr_39022_39088[(2)] = null);

(statearr_39022_39088[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (20))){
var state_39019__$1 = state_39019;
var statearr_39023_39089 = state_39019__$1;
(statearr_39023_39089[(2)] = results);

(statearr_39023_39089[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (27))){
var state_39019__$1 = state_39019;
var statearr_39024_39090 = state_39019__$1;
(statearr_39024_39090[(2)] = null);

(statearr_39024_39090[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (1))){
var state_39019__$1 = state_39019;
var statearr_39025_39091 = state_39019__$1;
(statearr_39025_39091[(2)] = null);

(statearr_39025_39091[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (24))){
var state_39019__$1 = state_39019;
var statearr_39026_39092 = state_39019__$1;
(statearr_39026_39092[(1)] = (26));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (39))){
var inst_38945 = (state_39019[(12)]);
var inst_38938 = (state_39019[(8)]);
var inst_39000 = (state_39019[(13)]);
var inst_39003 = (state_39019[(2)]);
var inst_39004 = fluree.db.util.async.throw_err(inst_39003);
var inst_39005 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_38938,inst_39004);
var inst_38936 = inst_38945;
var inst_38937 = inst_39000;
var inst_38938__$1 = inst_39005;
var state_39019__$1 = (function (){var statearr_39028 = state_39019;
(statearr_39028[(7)] = inst_38936);

(statearr_39028[(8)] = inst_38938__$1);

(statearr_39028[(10)] = inst_38937);

return statearr_39028;
})();
var statearr_39029_39093 = state_39019__$1;
(statearr_39029_39093[(2)] = null);

(statearr_39029_39093[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (4))){
var inst_38906 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39030_39094 = state_39019__$1;
(statearr_39030_39094[(2)] = inst_38906);

(statearr_39030_39094[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (15))){
var inst_38919 = (state_39019[(14)]);
var state_39019__$1 = state_39019;
var statearr_39031_39095 = state_39019__$1;
(statearr_39031_39095[(2)] = inst_38919);

(statearr_39031_39095[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (21))){
var inst_38915 = (state_39019[(15)]);
var state_39019__$1 = state_39019;
if(cljs.core.truth_(inst_38915)){
var statearr_39032_39096 = state_39019__$1;
(statearr_39032_39096[(1)] = (23));

} else {
var statearr_39033_39097 = state_39019__$1;
(statearr_39033_39097[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (31))){
var inst_38983 = (state_39019[(16)]);
var state_39019__$1 = state_39019;
var statearr_39034_39098 = state_39019__$1;
(statearr_39034_39098[(2)] = inst_38983);

(statearr_39034_39098[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (32))){
var inst_38975 = (state_39019[(17)]);
var inst_38989 = (state_39019[(2)]);
var state_39019__$1 = (function (){var statearr_39035 = state_39019;
(statearr_39035[(18)] = inst_38989);

return statearr_39035;
})();
if(cljs.core.truth_(inst_38975)){
var statearr_39036_39099 = state_39019__$1;
(statearr_39036_39099[(1)] = (33));

} else {
var statearr_39037_39100 = state_39019__$1;
(statearr_39037_39100[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (33))){
var inst_38975 = (state_39019[(17)]);
var state_39019__$1 = state_39019;
var statearr_39038_39101 = state_39019__$1;
(statearr_39038_39101[(2)] = inst_38975);

(statearr_39038_39101[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (13))){
var inst_38955 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
if(cljs.core.truth_(inst_38955)){
var statearr_39040_39102 = state_39019__$1;
(statearr_39040_39102[(1)] = (17));

} else {
var statearr_39041_39103 = state_39019__$1;
(statearr_39041_39103[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (22))){
var inst_38972 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39042_39104 = state_39019__$1;
(statearr_39042_39104[(2)] = inst_38972);

(statearr_39042_39104[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (36))){
var inst_38945 = (state_39019[(12)]);
var inst_38938 = (state_39019[(8)]);
var inst_38937 = (state_39019[(10)]);
var inst_38997 = (inst_38937 + (1));
var tmp39039 = inst_38938;
var inst_38936 = inst_38945;
var inst_38937__$1 = inst_38997;
var inst_38938__$1 = tmp39039;
var state_39019__$1 = (function (){var statearr_39043 = state_39019;
(statearr_39043[(7)] = inst_38936);

(statearr_39043[(8)] = inst_38938__$1);

(statearr_39043[(10)] = inst_38937__$1);

return statearr_39043;
})();
var statearr_39044_39105 = state_39019__$1;
(statearr_39044_39105[(2)] = null);

(statearr_39044_39105[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (29))){
var inst_38982 = (state_39019[(2)]);
var inst_38983 = fluree.db.util.async.throw_err(inst_38982);
var state_39019__$1 = (function (){var statearr_39045 = state_39019;
(statearr_39045[(16)] = inst_38983);

return statearr_39045;
})();
if(cljs.core.truth_(fuel)){
var statearr_39046_39106 = state_39019__$1;
(statearr_39046_39106[(1)] = (30));

} else {
var statearr_39047_39107 = state_39019__$1;
(statearr_39047_39107[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (6))){
var state_39019__$1 = state_39019;
var statearr_39048_39108 = state_39019__$1;
(statearr_39048_39108[(2)] = results);

(statearr_39048_39108[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (28))){
var inst_38968 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39049_39109 = state_39019__$1;
(statearr_39049_39109[(2)] = inst_38968);

(statearr_39049_39109[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (25))){
var inst_38970 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39050_39110 = state_39019__$1;
(statearr_39050_39110[(2)] = inst_38970);

(statearr_39050_39110[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (34))){
var inst_38989 = (state_39019[(18)]);
var inst_38992 = cljs.core.empty_QMARK_(inst_38989);
var state_39019__$1 = state_39019;
var statearr_39051_39111 = state_39019__$1;
(statearr_39051_39111[(2)] = inst_38992);

(statearr_39051_39111[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (17))){
var inst_38938 = (state_39019[(8)]);
var inst_38957 = cljs.core.empty_QMARK_(inst_38938);
var state_39019__$1 = state_39019;
if(inst_38957){
var statearr_39052_39112 = state_39019__$1;
(statearr_39052_39112[(1)] = (20));

} else {
var statearr_39053_39113 = state_39019__$1;
(statearr_39053_39113[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (3))){
var inst_39017 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39019__$1,inst_39017);
} else {
if((state_val_39020 === (12))){
var inst_38919 = (state_39019[(14)]);
var state_39019__$1 = state_39019;
if(cljs.core.truth_(inst_38919)){
var statearr_39054_39114 = state_39019__$1;
(statearr_39054_39114[(1)] = (14));

} else {
var statearr_39055_39115 = state_39019__$1;
(statearr_39055_39115[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (2))){
var _ = (function (){var statearr_39056 = state_39019;
(statearr_39056[(4)] = cljs.core.cons((5),(state_39019[(4)])));

return statearr_39056;
})();
var inst_38913 = select_spec;
var inst_38914 = cljs.core.__destructure_map(inst_38913);
var inst_38915 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38914,cljs.core.cst$kw$multi_QMARK_);
var inst_38916 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38914,cljs.core.cst$kw$as);
var inst_38917 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38914,cljs.core.cst$kw$recur_DASH_seen);
var inst_38918 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38914,cljs.core.cst$kw$recur_DASH_depth);
var inst_38919 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_38914,cljs.core.cst$kw$limit);
var inst_38920 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(select_spec);
var inst_38921 = (inst_38918 > inst_38920);
var state_39019__$1 = (function (){var statearr_39057 = state_39019;
(statearr_39057[(15)] = inst_38915);

(statearr_39057[(19)] = inst_38916);

(statearr_39057[(14)] = inst_38919);

(statearr_39057[(20)] = inst_38917);

return statearr_39057;
})();
if(cljs.core.truth_(inst_38921)){
var statearr_39058_39116 = state_39019__$1;
(statearr_39058_39116[(1)] = (6));

} else {
var statearr_39059_39117 = state_39019__$1;
(statearr_39059_39117[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (23))){
var inst_38916 = (state_39019[(19)]);
var inst_38938 = (state_39019[(8)]);
var inst_38961 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_38916,inst_38938);
var state_39019__$1 = state_39019;
var statearr_39060_39118 = state_39019__$1;
(statearr_39060_39118[(2)] = inst_38961);

(statearr_39060_39118[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (35))){
var inst_38944 = (state_39019[(21)]);
var inst_38994 = (state_39019[(2)]);
var inst_38995 = fluree.db.query.fql.recur_select_spec(select_spec,inst_38944);
var state_39019__$1 = (function (){var statearr_39061 = state_39019;
(statearr_39061[(22)] = inst_38995);

return statearr_39061;
})();
if(cljs.core.truth_(inst_38994)){
var statearr_39062_39119 = state_39019__$1;
(statearr_39062_39119[(1)] = (36));

} else {
var statearr_39063_39120 = state_39019__$1;
(statearr_39063_39120[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (19))){
var inst_39010 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39064_39121 = state_39019__$1;
(statearr_39064_39121[(2)] = inst_39010);

(statearr_39064_39121[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (11))){
var inst_38946 = (state_39019[(23)]);
var state_39019__$1 = state_39019;
var statearr_39066_39122 = state_39019__$1;
(statearr_39066_39122[(2)] = inst_38946);

(statearr_39066_39122[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (9))){
var inst_38936 = (state_39019[(7)]);
var inst_38946 = (state_39019[(23)]);
var inst_38944 = (state_39019[(21)]);
var inst_38943 = cljs.core.seq(inst_38936);
var inst_38944__$1 = cljs.core.first(inst_38943);
var inst_38945 = cljs.core.next(inst_38943);
var inst_38946__$1 = cljs.core.not(inst_38944__$1);
var state_39019__$1 = (function (){var statearr_39067 = state_39019;
(statearr_39067[(12)] = inst_38945);

(statearr_39067[(23)] = inst_38946__$1);

(statearr_39067[(21)] = inst_38944__$1);

return statearr_39067;
})();
if(inst_38946__$1){
var statearr_39068_39123 = state_39019__$1;
(statearr_39068_39123[(1)] = (11));

} else {
var statearr_39069_39124 = state_39019__$1;
(statearr_39069_39124[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (5))){
var _ = (function (){var statearr_39070 = state_39019;
(statearr_39070[(4)] = cljs.core.rest((state_39019[(4)])));

return statearr_39070;
})();
var state_39019__$1 = state_39019;
var ex39065 = (state_39019__$1[(2)]);
var statearr_39071_39125 = state_39019__$1;
(statearr_39071_39125[(5)] = ex39065);


if((ex39065 instanceof Error)){
var statearr_39072_39126 = state_39019__$1;
(statearr_39072_39126[(1)] = (4));

(statearr_39072_39126[(5)] = null);

} else {
throw ex39065;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (14))){
var inst_38937 = (state_39019[(10)]);
var inst_38919 = (state_39019[(14)]);
var inst_38950 = (inst_38937 < inst_38919);
var state_39019__$1 = state_39019;
var statearr_39073_39127 = state_39019__$1;
(statearr_39073_39127[(2)] = inst_38950);

(statearr_39073_39127[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (26))){
var inst_38916 = (state_39019[(19)]);
var inst_38938 = (state_39019[(8)]);
var inst_38964 = cljs.core.first(inst_38938);
var inst_38965 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(results,inst_38916,inst_38964);
var state_39019__$1 = state_39019;
var statearr_39074_39128 = state_39019__$1;
(statearr_39074_39128[(2)] = inst_38965);

(statearr_39074_39128[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (16))){
var inst_38953 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39075_39129 = state_39019__$1;
(statearr_39075_39129[(2)] = inst_38953);

(statearr_39075_39129[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (38))){
var inst_39008 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39076_39130 = state_39019__$1;
(statearr_39076_39130[(2)] = inst_39008);

(statearr_39076_39130[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (30))){
var inst_38983 = (state_39019[(16)]);
var inst_38985 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_38986 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_38985,inst_38983);
var state_39019__$1 = state_39019;
var statearr_39077_39131 = state_39019__$1;
(statearr_39077_39131[(2)] = inst_38986);

(statearr_39077_39131[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (10))){
var inst_39012 = (state_39019[(2)]);
var state_39019__$1 = state_39019;
var statearr_39078_39132 = state_39019__$1;
(statearr_39078_39132[(2)] = inst_39012);

(statearr_39078_39132[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39020 === (18))){
var inst_38944 = (state_39019[(21)]);
var inst_38917 = (state_39019[(20)]);
var inst_38974 = inst_38944.o;
var inst_38975 = cljs.core.contains_QMARK_(inst_38917,inst_38974);
var inst_38977 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_38978 = [inst_38974];
var inst_38979 = (new cljs.core.PersistentVector(null,1,(5),inst_38977,inst_38978,null));
var inst_38980 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_38979);
var state_39019__$1 = (function (){var statearr_39079 = state_39019;
(statearr_39079[(17)] = inst_38975);

return statearr_39079;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39019__$1,(29),inst_38980);
} else {
if((state_val_39020 === (37))){
var inst_38937 = (state_39019[(10)]);
var inst_38995 = (state_39019[(22)]);
var inst_38989 = (state_39019[(18)]);
var inst_39000 = (inst_38937 + (1));
var inst_39001 = (fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6 ? fluree.db.query.fql.flakes__GT_res.cljs$core$IFn$_invoke$arity$6(db,cache,fuel,max_fuel,inst_38995,inst_38989) : fluree.db.query.fql.flakes__GT_res.call(null,db,cache,fuel,max_fuel,inst_38995,inst_38989));
var state_39019__$1 = (function (){var statearr_39080 = state_39019;
(statearr_39080[(13)] = inst_39000);

return statearr_39080;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39019__$1,(39),inst_39001);
} else {
if((state_val_39020 === (8))){
var inst_39014 = (state_39019[(2)]);
var _ = (function (){var statearr_39081 = state_39019;
(statearr_39081[(4)] = cljs.core.rest((state_39019[(4)])));

return statearr_39081;
})();
var state_39019__$1 = state_39019;
var statearr_39082_39133 = state_39019__$1;
(statearr_39082_39133[(2)] = inst_39014);

(statearr_39082_39133[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0 = (function (){
var statearr_39083 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39083[(0)] = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__);

(statearr_39083[(1)] = (1));

return statearr_39083;
});
var fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1 = (function (state_39019){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39019);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39084){var ex__16398__auto__ = e39084;
var statearr_39085_39134 = state_39019;
(statearr_39085_39134[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39019[(4)]))){
var statearr_39086_39135 = state_39019;
(statearr_39086_39135[(1)] = cljs.core.first((state_39019[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39136 = state_39019;
state_39019 = G__39136;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__ = function(state_39019){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1.call(this,state_39019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____0;
fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto____1;
return fluree$db$query$fql$flake__GT_recur_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39087 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39087[(6)] = c__16469__auto__);

return statearr_39087;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Takes a sequence of flakes of the same subject and
 *   composes them into a map result based on the 'select' spec
 *   provided. Optionally, also follows components or recurs.
 */
fluree.db.query.fql.flakes__GT_res = (function fluree$db$query$fql$flakes__GT_res(db,cache,fuel,max_fuel,base_select_spec,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39317){
var state_val_39318 = (state_39317[(1)]);
if((state_val_39318 === (7))){
var state_39317__$1 = state_39317;
var statearr_39319_39405 = state_39317__$1;
(statearr_39319_39405[(2)] = null);

(statearr_39319_39405[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (20))){
var inst_39175 = cljs.core.PersistentHashMap.EMPTY;
var state_39317__$1 = state_39317;
var statearr_39320_39406 = state_39317__$1;
(statearr_39320_39406[(2)] = inst_39175);

(statearr_39320_39406[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (27))){
var inst_39193 = (state_39317[(7)]);
var inst_39157 = (state_39317[(8)]);
var inst_39177 = (state_39317[(9)]);
var inst_39163 = (state_39317[(10)]);
var inst_39296 = (state_39317[(2)]);
var inst_39297 = (function (){var top_level_subject = inst_39157;
var select_spec = inst_39163;
var base_acc = inst_39177;
var acc_PLUS_refs = inst_39193;
var result = inst_39296;
return (function (acc,spec){
if(cljs.core.truth_((function (){var or__4212__auto__ = (function (){var and__4210__auto__ = cljs.core.cst$kw$multi_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
})();
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.cst$kw$reverse_QMARK_.cljs$core$IFn$_invoke$arity$1(spec);
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec);
} else {
return and__4210__auto__;
}
}
})())){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(spec),cljs.core.cst$kw$order.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$predicate.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(spec)),cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(spec)], null));
} else {
return acc;
}
});
})();
var inst_39298 = cljs.core.PersistentVector.EMPTY;
var inst_39299 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39163);
var inst_39300 = cljs.core.cst$kw$pred_DASH_id.cljs$core$IFn$_invoke$arity$1(inst_39299);
var inst_39301 = cljs.core.vals(inst_39300);
var inst_39302 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39163);
var inst_39303 = cljs.core.cst$kw$reverse.cljs$core$IFn$_invoke$arity$1(inst_39302);
var inst_39304 = cljs.core.vals(inst_39303);
var inst_39305 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39301,inst_39304);
var inst_39306 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39297,inst_39298,inst_39305);
var inst_39308 = (function (){var top_level_subject = inst_39157;
var select_spec = inst_39163;
var base_acc = inst_39177;
var acc_PLUS_refs = inst_39193;
var result = inst_39296;
var sort_preds = inst_39306;
return (function (acc,p__39307){
var vec__39321 = p__39307;
var selectPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39321,(0),null);
var sortOrder = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39321,(1),null);
var sortPred = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39321,(2),null);
var limit = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__39321,(3),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(acc,selectPred,fluree.db.query.fql.sort_offset_and_limit_res(sortPred,sortOrder,(0),limit,cljs.core.get.cljs$core$IFn$_invoke$arity$2(acc,selectPred)));
});
})();
var inst_39309 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_39308,inst_39296,inst_39306);
var state_39317__$1 = state_39317;
var statearr_39324_39407 = state_39317__$1;
(statearr_39324_39407[(2)] = inst_39309);

(statearr_39324_39407[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (1))){
var state_39317__$1 = state_39317;
var statearr_39325_39408 = state_39317__$1;
(statearr_39325_39408[(2)] = null);

(statearr_39325_39408[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (24))){
var inst_39193 = (state_39317[(7)]);
var inst_39193__$1 = (state_39317[(2)]);
var inst_39194 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$p,flakes);
var inst_39195 = cljs.core.PersistentHashMap.EMPTY;
var inst_39196 = inst_39194;
var inst_39197 = inst_39193__$1;
var inst_39198 = inst_39195;
var state_39317__$1 = (function (){var statearr_39326 = state_39317;
(statearr_39326[(11)] = inst_39198);

(statearr_39326[(7)] = inst_39193__$1);

(statearr_39326[(12)] = inst_39197);

(statearr_39326[(13)] = inst_39196);

return statearr_39326;
})();
var statearr_39327_39409 = state_39317__$1;
(statearr_39327_39409[(2)] = null);

(statearr_39327_39409[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (39))){
var inst_39206 = (state_39317[(14)]);
var inst_39197 = (state_39317[(12)]);
var inst_39213 = (state_39317[(15)]);
var inst_39163 = (state_39317[(10)]);
var inst_39242 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39243 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$9(db,cache,fuel,max_fuel,inst_39197,inst_39163,inst_39206,inst_39213,false);
var state_39317__$1 = (function (){var statearr_39328 = state_39317;
(statearr_39328[(16)] = inst_39242);

return statearr_39328;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39317__$1,(42),inst_39243);
} else {
if((state_val_39318 === (46))){
var inst_39198 = (state_39317[(11)]);
var inst_39206 = (state_39317[(14)]);
var inst_39196 = (state_39317[(13)]);
var inst_39260 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39261 = [cljs.core.cst$kw$_id];
var inst_39262 = cljs.core.first(inst_39206);
var inst_39263 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_39262);
var inst_39264 = [inst_39263];
var inst_39265 = cljs.core.PersistentHashMap.fromArrays(inst_39261,inst_39264);
var inst_39266 = cljs.core.rest(inst_39196);
var inst_39267 = [inst_39265,inst_39266,inst_39198];
var inst_39268 = (new cljs.core.PersistentVector(null,3,(5),inst_39260,inst_39267,null));
var state_39317__$1 = state_39317;
var statearr_39329_39410 = state_39317__$1;
(statearr_39329_39410[(2)] = inst_39268);

(statearr_39329_39410[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (4))){
var inst_39137 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39330_39411 = state_39317__$1;
(statearr_39330_39411[(2)] = inst_39137);

(statearr_39330_39411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (15))){
var inst_39164 = (state_39317[(17)]);
var inst_39163 = (state_39317[(10)]);
var inst_39163__$1 = (state_39317[(2)]);
var inst_39164__$1 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39163__$1);
var state_39317__$1 = (function (){var statearr_39331 = state_39317;
(statearr_39331[(17)] = inst_39164__$1);

(statearr_39331[(10)] = inst_39163__$1);

return statearr_39331;
})();
if(cljs.core.truth_(inst_39164__$1)){
var statearr_39332_39412 = state_39317__$1;
(statearr_39332_39412[(1)] = (16));

} else {
var statearr_39333_39413 = state_39317__$1;
(statearr_39333_39413[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (48))){
var inst_39279 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39334_39414 = state_39317__$1;
(statearr_39334_39414[(2)] = inst_39279);

(statearr_39334_39414[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (50))){
var state_39317__$1 = state_39317;
var statearr_39335_39415 = state_39317__$1;
(statearr_39335_39415[(2)] = null);

(statearr_39335_39415[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (21))){
var inst_39163 = (state_39317[(10)]);
var inst_39177 = (state_39317[(2)]);
var inst_39178 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39179 = [cljs.core.cst$kw$select,cljs.core.cst$kw$reverse];
var inst_39180 = (new cljs.core.PersistentVector(null,2,(5),inst_39178,inst_39179,null));
var inst_39181 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39163,inst_39180);
var state_39317__$1 = (function (){var statearr_39336 = state_39317;
(statearr_39336[(9)] = inst_39177);

return statearr_39336;
})();
if(cljs.core.truth_(inst_39181)){
var statearr_39337_39416 = state_39317__$1;
(statearr_39337_39416[(1)] = (22));

} else {
var statearr_39338_39417 = state_39317__$1;
(statearr_39338_39417[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (31))){
var inst_39206 = (state_39317[(14)]);
var inst_39212 = (state_39317[(18)]);
var inst_39197 = (state_39317[(12)]);
var inst_39216 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39217 = fluree.db.query.fql.flake__GT_recur(db,inst_39206,inst_39212,inst_39197,fuel,max_fuel,cache);
var state_39317__$1 = (function (){var statearr_39339 = state_39317;
(statearr_39339[(19)] = inst_39216);

return statearr_39339;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39317__$1,(34),inst_39217);
} else {
if((state_val_39318 === (32))){
var inst_39212 = (state_39317[(18)]);
var state_39317__$1 = state_39317;
if(cljs.core.truth_(inst_39212)){
var statearr_39340_39418 = state_39317__$1;
(statearr_39340_39418[(1)] = (35));

} else {
var statearr_39341_39419 = state_39317__$1;
(statearr_39341_39419[(1)] = (36));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (40))){
var inst_39253 = (state_39317[(20)]);
var inst_39163 = (state_39317[(10)]);
var inst_39252 = cljs.core.cst$kw$select.cljs$core$IFn$_invoke$arity$1(inst_39163);
var inst_39253__$1 = cljs.core.empty_QMARK_(inst_39252);
var state_39317__$1 = (function (){var statearr_39342 = state_39317;
(statearr_39342[(20)] = inst_39253__$1);

return statearr_39342;
})();
if(inst_39253__$1){
var statearr_39343_39420 = state_39317__$1;
(statearr_39343_39420[(1)] = (43));

} else {
var statearr_39344_39421 = state_39317__$1;
(statearr_39344_39421[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (33))){
var inst_39206 = (state_39317[(14)]);
var inst_39285 = (state_39317[(2)]);
var inst_39286 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39285,(0),null);
var inst_39287 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39285,(1),null);
var inst_39288 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39285,(2),null);
var inst_39289 = cljs.core.first(inst_39206);
var inst_39290 = cljs.core.cst$kw$s.cljs$core$IFn$_invoke$arity$1(inst_39289);
var inst_39291 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_39286,cljs.core.cst$kw$_id,inst_39290);
var inst_39196 = inst_39287;
var inst_39197 = inst_39291;
var inst_39198 = inst_39288;
var state_39317__$1 = (function (){var statearr_39345 = state_39317;
(statearr_39345[(11)] = inst_39198);

(statearr_39345[(12)] = inst_39197);

(statearr_39345[(13)] = inst_39196);

return statearr_39345;
})();
var statearr_39346_39422 = state_39317__$1;
(statearr_39346_39422[(2)] = null);

(statearr_39346_39422[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (13))){
var inst_39157 = (state_39317[(8)]);
var inst_39160 = fluree.db.query.fql.full_select_spec(db,cache,base_select_spec,inst_39157);
var state_39317__$1 = state_39317;
var statearr_39347_39423 = state_39317__$1;
(statearr_39347_39423[(2)] = inst_39160);

(statearr_39347_39423[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (22))){
var inst_39163 = (state_39317[(10)]);
var inst_39183 = cljs.core.first(flakes);
var inst_39184 = fluree.db.query.fql.s(inst_39183);
var inst_39185 = fluree.db.query.fql.select_spec__GT_reverse_pred_specs(inst_39163);
var inst_39186 = fluree.db.query.fql.resolve_reverse_refs(db,cache,fuel,max_fuel,inst_39184,inst_39185);
var state_39317__$1 = state_39317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39317__$1,(25),inst_39186);
} else {
if((state_val_39318 === (36))){
var inst_39163 = (state_39317[(10)]);
var inst_39240 = cljs.core.cst$kw$wildcard_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39163);
var state_39317__$1 = state_39317;
if(cljs.core.truth_(inst_39240)){
var statearr_39348_39424 = state_39317__$1;
(statearr_39348_39424[(1)] = (39));

} else {
var statearr_39349_39425 = state_39317__$1;
(statearr_39349_39425[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (41))){
var inst_39281 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39350_39426 = state_39317__$1;
(statearr_39350_39426[(2)] = inst_39281);

(statearr_39350_39426[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (43))){
var inst_39163 = (state_39317[(10)]);
var inst_39255 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39163);
var state_39317__$1 = state_39317;
var statearr_39351_39427 = state_39317__$1;
(statearr_39351_39427[(2)] = inst_39255);

(statearr_39351_39427[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (29))){
var inst_39206 = (state_39317[(14)]);
var inst_39212 = (state_39317[(18)]);
var inst_39196 = (state_39317[(13)]);
var inst_39163 = (state_39317[(10)]);
var inst_39206__$1 = cljs.core.first(inst_39196);
var inst_39207 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39208 = cljs.core.first(inst_39206__$1);
var inst_39209 = cljs.core.cst$kw$p.cljs$core$IFn$_invoke$arity$1(inst_39208);
var inst_39210 = [cljs.core.cst$kw$select,cljs.core.cst$kw$pred_DASH_id,inst_39209];
var inst_39211 = (new cljs.core.PersistentVector(null,3,(5),inst_39207,inst_39210,null));
var inst_39212__$1 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(inst_39163,inst_39211);
var inst_39213 = fluree.db.query.fql.component_follow_QMARK_(inst_39212__$1,inst_39163);
var inst_39214 = cljs.core.cst$kw$recur.cljs$core$IFn$_invoke$arity$1(inst_39212__$1);
var state_39317__$1 = (function (){var statearr_39352 = state_39317;
(statearr_39352[(14)] = inst_39206__$1);

(statearr_39352[(18)] = inst_39212__$1);

(statearr_39352[(15)] = inst_39213);

return statearr_39352;
})();
if(cljs.core.truth_(inst_39214)){
var statearr_39353_39428 = state_39317__$1;
(statearr_39353_39428[(1)] = (31));

} else {
var statearr_39354_39429 = state_39317__$1;
(statearr_39354_39429[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (44))){
var inst_39253 = (state_39317[(20)]);
var state_39317__$1 = state_39317;
var statearr_39355_39430 = state_39317__$1;
(statearr_39355_39430[(2)] = inst_39253);

(statearr_39355_39430[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (6))){
var state_39317__$1 = state_39317;
var statearr_39356_39431 = state_39317__$1;
(statearr_39356_39431[(2)] = null);

(statearr_39356_39431[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (28))){
var inst_39197 = (state_39317[(12)]);
var state_39317__$1 = state_39317;
var statearr_39357_39432 = state_39317__$1;
(statearr_39357_39432[(2)] = inst_39197);

(statearr_39357_39432[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (51))){
var inst_39277 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39358_39433 = state_39317__$1;
(statearr_39358_39433[(2)] = inst_39277);

(statearr_39358_39433[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (25))){
var inst_39177 = (state_39317[(9)]);
var inst_39188 = (state_39317[(2)]);
var inst_39189 = fluree.db.util.async.throw_err(inst_39188);
var inst_39190 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39177,inst_39189], 0));
var state_39317__$1 = state_39317;
var statearr_39359_39434 = state_39317__$1;
(statearr_39359_39434[(2)] = inst_39190);

(statearr_39359_39434[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (34))){
var inst_39198 = (state_39317[(11)]);
var inst_39216 = (state_39317[(19)]);
var inst_39196 = (state_39317[(13)]);
var inst_39219 = (state_39317[(2)]);
var inst_39220 = fluree.db.util.async.throw_err(inst_39219);
var inst_39221 = cljs.core.rest(inst_39196);
var inst_39222 = [inst_39220,inst_39221,inst_39198];
var inst_39223 = (new cljs.core.PersistentVector(null,3,(5),inst_39216,inst_39222,null));
var state_39317__$1 = state_39317;
var statearr_39360_39435 = state_39317__$1;
(statearr_39360_39435[(2)] = inst_39223);

(statearr_39360_39435[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (17))){
var inst_39163 = (state_39317[(10)]);
var inst_39167 = cljs.core.cst$kw$id_QMARK_.cljs$core$IFn$_invoke$arity$1(inst_39163);
var state_39317__$1 = state_39317;
var statearr_39362_39436 = state_39317__$1;
(statearr_39362_39436[(2)] = inst_39167);

(statearr_39362_39436[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (3))){
var inst_39315 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39317__$1,inst_39315);
} else {
if((state_val_39318 === (12))){
var _ = (function (){var statearr_39363 = state_39317;
(statearr_39363[(4)] = cljs.core.rest((state_39317[(4)])));

return statearr_39363;
})();
var state_39317__$1 = state_39317;
var ex39361 = (state_39317__$1[(2)]);
var statearr_39364_39437 = state_39317__$1;
(statearr_39364_39437[(5)] = ex39361);


var statearr_39365_39438 = state_39317__$1;
(statearr_39365_39438[(1)] = (11));

(statearr_39365_39438[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (2))){
var _ = (function (){var statearr_39366 = state_39317;
(statearr_39366[(4)] = cljs.core.cons((5),(state_39317[(4)])));

return statearr_39366;
})();
var inst_39143 = cljs.core.not_empty(flakes);
var state_39317__$1 = state_39317;
if(cljs.core.truth_(inst_39143)){
var statearr_39367_39439 = state_39317__$1;
(statearr_39367_39439[(1)] = (6));

} else {
var statearr_39368_39440 = state_39317__$1;
(statearr_39368_39440[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (23))){
var inst_39177 = (state_39317[(9)]);
var state_39317__$1 = state_39317;
var statearr_39369_39441 = state_39317__$1;
(statearr_39369_39441[(2)] = inst_39177);

(statearr_39369_39441[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (47))){
var state_39317__$1 = state_39317;
var statearr_39370_39442 = state_39317__$1;
(statearr_39370_39442[(1)] = (49));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (35))){
var inst_39198 = (state_39317[(11)]);
var inst_39206 = (state_39317[(14)]);
var inst_39212 = (state_39317[(18)]);
var inst_39197 = (state_39317[(12)]);
var inst_39213 = (state_39317[(15)]);
var inst_39229 = fluree.db.query.fql.add_pred.cljs$core$IFn$_invoke$arity$10(db,cache,fuel,max_fuel,inst_39197,inst_39212,inst_39206,inst_39213,false,inst_39198);
var state_39317__$1 = state_39317;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39317__$1,(38),inst_39229);
} else {
if((state_val_39318 === (19))){
var inst_39157 = (state_39317[(8)]);
var inst_39171 = [cljs.core.cst$kw$_id];
var inst_39172 = [inst_39157];
var inst_39173 = cljs.core.PersistentHashMap.fromArrays(inst_39171,inst_39172);
var state_39317__$1 = state_39317;
var statearr_39372_39443 = state_39317__$1;
(statearr_39372_39443[(2)] = inst_39173);

(statearr_39372_39443[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (11))){
var inst_39145 = (state_39317[(2)]);
var inst_39146 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_39145], 0));
var inst_39147 = (function(){throw inst_39145})();
var state_39317__$1 = (function (){var statearr_39374 = state_39317;
(statearr_39374[(21)] = inst_39146);

return statearr_39374;
})();
var statearr_39375_39444 = state_39317__$1;
(statearr_39375_39444[(2)] = inst_39147);

(statearr_39375_39444[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (9))){
var _ = (function (){var statearr_39376 = state_39317;
(statearr_39376[(4)] = cljs.core.cons((12),(state_39317[(4)])));

return statearr_39376;
})();
var inst_39153 = cljs.core.first(flakes);
var inst_39154 = fluree.db.query.fql.s(inst_39153);
var ___$1 = (function (){var statearr_39377 = state_39317;
(statearr_39377[(4)] = cljs.core.rest((state_39317[(4)])));

return statearr_39377;
})();
var state_39317__$1 = state_39317;
var statearr_39378_39445 = state_39317__$1;
(statearr_39378_39445[(2)] = inst_39154);

(statearr_39378_39445[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (5))){
var _ = (function (){var statearr_39379 = state_39317;
(statearr_39379[(4)] = cljs.core.rest((state_39317[(4)])));

return statearr_39379;
})();
var state_39317__$1 = state_39317;
var ex39373 = (state_39317__$1[(2)]);
var statearr_39380_39446 = state_39317__$1;
(statearr_39380_39446[(5)] = ex39373);


if((ex39373 instanceof Error)){
var statearr_39381_39447 = state_39317__$1;
(statearr_39381_39447[(1)] = (4));

(statearr_39381_39447[(5)] = null);

} else {
throw ex39373;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (14))){
var state_39317__$1 = state_39317;
var statearr_39382_39448 = state_39317__$1;
(statearr_39382_39448[(2)] = base_select_spec);

(statearr_39382_39448[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (45))){
var inst_39258 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
if(cljs.core.truth_(inst_39258)){
var statearr_39383_39449 = state_39317__$1;
(statearr_39383_39449[(1)] = (46));

} else {
var statearr_39384_39450 = state_39317__$1;
(statearr_39384_39450[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (26))){
var inst_39196 = (state_39317[(13)]);
var inst_39200 = cljs.core.empty_QMARK_(inst_39196);
var state_39317__$1 = state_39317;
if(inst_39200){
var statearr_39385_39451 = state_39317__$1;
(statearr_39385_39451[(1)] = (28));

} else {
var statearr_39386_39452 = state_39317__$1;
(statearr_39386_39452[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (16))){
var inst_39164 = (state_39317[(17)]);
var state_39317__$1 = state_39317;
var statearr_39387_39453 = state_39317__$1;
(statearr_39387_39453[(2)] = inst_39164);

(statearr_39387_39453[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (38))){
var inst_39196 = (state_39317[(13)]);
var inst_39231 = (state_39317[(2)]);
var inst_39232 = fluree.db.util.async.throw_err(inst_39231);
var inst_39233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39232,(0),null);
var inst_39234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39232,(1),null);
var inst_39235 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39236 = cljs.core.rest(inst_39196);
var inst_39237 = [inst_39233,inst_39236,inst_39234];
var inst_39238 = (new cljs.core.PersistentVector(null,3,(5),inst_39235,inst_39237,null));
var state_39317__$1 = state_39317;
var statearr_39388_39454 = state_39317__$1;
(statearr_39388_39454[(2)] = inst_39238);

(statearr_39388_39454[(1)] = (37));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (30))){
var inst_39294 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39389_39455 = state_39317__$1;
(statearr_39389_39455[(2)] = inst_39294);

(statearr_39389_39455[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (10))){
var inst_39157 = (state_39317[(2)]);
var inst_39158 = fluree.db.query.fql.has_ns_lookups_QMARK_(base_select_spec);
var state_39317__$1 = (function (){var statearr_39390 = state_39317;
(statearr_39390[(8)] = inst_39157);

return statearr_39390;
})();
if(cljs.core.truth_(inst_39158)){
var statearr_39391_39456 = state_39317__$1;
(statearr_39391_39456[(1)] = (13));

} else {
var statearr_39392_39457 = state_39317__$1;
(statearr_39392_39457[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (18))){
var inst_39169 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
if(cljs.core.truth_(inst_39169)){
var statearr_39393_39458 = state_39317__$1;
(statearr_39393_39458[(1)] = (19));

} else {
var statearr_39394_39459 = state_39317__$1;
(statearr_39394_39459[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (42))){
var inst_39242 = (state_39317[(16)]);
var inst_39198 = (state_39317[(11)]);
var inst_39196 = (state_39317[(13)]);
var inst_39245 = (state_39317[(2)]);
var inst_39246 = fluree.db.util.async.throw_err(inst_39245);
var inst_39247 = cljs.core.first(inst_39246);
var inst_39248 = cljs.core.rest(inst_39196);
var inst_39249 = [inst_39247,inst_39248,inst_39198];
var inst_39250 = (new cljs.core.PersistentVector(null,3,(5),inst_39242,inst_39249,null));
var state_39317__$1 = state_39317;
var statearr_39395_39460 = state_39317__$1;
(statearr_39395_39460[(2)] = inst_39250);

(statearr_39395_39460[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (37))){
var inst_39283 = (state_39317[(2)]);
var state_39317__$1 = state_39317;
var statearr_39396_39461 = state_39317__$1;
(statearr_39396_39461[(2)] = inst_39283);

(statearr_39396_39461[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (8))){
var inst_39312 = (state_39317[(2)]);
var _ = (function (){var statearr_39397 = state_39317;
(statearr_39397[(4)] = cljs.core.rest((state_39317[(4)])));

return statearr_39397;
})();
var state_39317__$1 = state_39317;
var statearr_39398_39462 = state_39317__$1;
(statearr_39398_39462[(2)] = inst_39312);

(statearr_39398_39462[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39318 === (49))){
var inst_39198 = (state_39317[(11)]);
var inst_39197 = (state_39317[(12)]);
var inst_39196 = (state_39317[(13)]);
var inst_39271 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39272 = cljs.core.rest(inst_39196);
var inst_39273 = [inst_39197,inst_39272,inst_39198];
var inst_39274 = (new cljs.core.PersistentVector(null,3,(5),inst_39271,inst_39273,null));
var state_39317__$1 = state_39317;
var statearr_39399_39463 = state_39317__$1;
(statearr_39399_39463[(2)] = inst_39274);

(statearr_39399_39463[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0 = (function (){
var statearr_39400 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39400[(0)] = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__);

(statearr_39400[(1)] = (1));

return statearr_39400;
});
var fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1 = (function (state_39317){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39317);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39401){var ex__16398__auto__ = e39401;
var statearr_39402_39464 = state_39317;
(statearr_39402_39464[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39317[(4)]))){
var statearr_39403_39465 = state_39317;
(statearr_39403_39465[(1)] = cljs.core.first((state_39317[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39466 = state_39317;
state_39317 = G__39466;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__ = function(state_39317){
switch(arguments.length){
case 0:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1.call(this,state_39317);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____0;
fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto____1;
return fluree$db$query$fql$flakes__GT_res_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39404 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39404[(6)] = c__16469__auto__);

return statearr_39404;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Runs a select statement based on a sequence of flakes.
 */
fluree.db.query.fql.flake_select = (function fluree$db$query$fql$flake_select(var_args){
var G__39469 = arguments.length;
switch (G__39469) {
case 6:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,flakes){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,null,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit){
return fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,flakes,limit,null);
}));

(fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,flakes,limit,offset){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39511){
var state_val_39512 = (state_39511[(1)]);
if((state_val_39512 === (7))){
var inst_39477 = (state_39511[(7)]);
var state_39511__$1 = state_39511;
var statearr_39513_39543 = state_39511__$1;
(statearr_39513_39543[(2)] = inst_39477);

(statearr_39513_39543[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (1))){
var state_39511__$1 = state_39511;
var statearr_39514_39544 = state_39511__$1;
(statearr_39514_39544[(2)] = null);

(statearr_39514_39544[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (4))){
var inst_39470 = (state_39511[(2)]);
var state_39511__$1 = state_39511;
var statearr_39515_39545 = state_39511__$1;
(statearr_39515_39545[(2)] = inst_39470);

(statearr_39515_39545[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (15))){
var inst_39505 = (state_39511[(2)]);
var inst_39506 = fluree.db.util.async.throw_err(inst_39505);
var _ = (function (){var statearr_39516 = state_39511;
(statearr_39516[(4)] = cljs.core.rest((state_39511[(4)])));

return statearr_39516;
})();
var state_39511__$1 = state_39511;
var statearr_39517_39546 = state_39511__$1;
(statearr_39517_39546[(2)] = inst_39506);

(statearr_39517_39546[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (13))){
var inst_39489 = (state_39511[(8)]);
var state_39511__$1 = state_39511;
var statearr_39518_39547 = state_39511__$1;
(statearr_39518_39547[(2)] = inst_39489);

(statearr_39518_39547[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (6))){
var inst_39477 = (state_39511[(7)]);
var inst_39479 = fluree.db.query.fql.fuel_flakes_transducer(fuel,max_fuel);
var inst_39480 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39477,inst_39479);
var state_39511__$1 = state_39511;
var statearr_39519_39548 = state_39511__$1;
(statearr_39519_39548[(2)] = inst_39480);

(statearr_39519_39548[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (3))){
var inst_39509 = (state_39511[(2)]);
var state_39511__$1 = state_39511;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39511__$1,inst_39509);
} else {
if((state_val_39512 === (12))){
var inst_39489 = (state_39511[(8)]);
var inst_39491 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(limit);
var inst_39492 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39489,inst_39491);
var state_39511__$1 = state_39511;
var statearr_39520_39549 = state_39511__$1;
(statearr_39520_39549[(2)] = inst_39492);

(statearr_39520_39549[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (2))){
var _ = (function (){var statearr_39521 = state_39511;
(statearr_39521[(4)] = cljs.core.cons((5),(state_39511[(4)])));

return statearr_39521;
})();
var inst_39477 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_39511__$1 = (function (){var statearr_39522 = state_39511;
(statearr_39522[(7)] = inst_39477);

return statearr_39522;
})();
if(cljs.core.truth_(fuel)){
var statearr_39523_39550 = state_39511__$1;
(statearr_39523_39550[(1)] = (6));

} else {
var statearr_39524_39551 = state_39511__$1;
(statearr_39524_39551[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (11))){
var inst_39489 = (state_39511[(2)]);
var state_39511__$1 = (function (){var statearr_39526 = state_39511;
(statearr_39526[(8)] = inst_39489);

return statearr_39526;
})();
if(cljs.core.truth_(limit)){
var statearr_39527_39552 = state_39511__$1;
(statearr_39527_39552[(1)] = (12));

} else {
var statearr_39528_39553 = state_39511__$1;
(statearr_39528_39553[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (9))){
var inst_39483 = (state_39511[(9)]);
var inst_39485 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(offset);
var inst_39486 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39483,inst_39485);
var state_39511__$1 = state_39511;
var statearr_39529_39554 = state_39511__$1;
(statearr_39529_39554[(2)] = inst_39486);

(statearr_39529_39554[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (5))){
var _ = (function (){var statearr_39530 = state_39511;
(statearr_39530[(4)] = cljs.core.rest((state_39511[(4)])));

return statearr_39530;
})();
var state_39511__$1 = state_39511;
var ex39525 = (state_39511__$1[(2)]);
var statearr_39531_39555 = state_39511__$1;
(statearr_39531_39555[(5)] = ex39525);


if((ex39525 instanceof Error)){
var statearr_39532_39556 = state_39511__$1;
(statearr_39532_39556[(1)] = (4));

(statearr_39532_39556[(5)] = null);

} else {
throw ex39525;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (14))){
var inst_39495 = (state_39511[(2)]);
var inst_39496 = (function (){return (function (x){
var and__4210__auto__ = max_fuel;
if(cljs.core.truth_(and__4210__auto__)){
return (cljs.core.deref(fuel) >= max_fuel);
} else {
return and__4210__auto__;
}
});
})();
var inst_39497 = cljs.core.halt_when.cljs$core$IFn$_invoke$arity$1(inst_39496);
var inst_39498 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_39495,inst_39497);
var inst_39499 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_39498,flakes);
var inst_39500 = cljs.core.PersistentVector.EMPTY;
var inst_39501 = (function (){var xf = inst_39498;
var flakes_by_sub = inst_39499;
return (function (p1__39467_SHARP_){
return fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,p1__39467_SHARP_);
});
})();
var inst_39502 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(inst_39501,inst_39499);
var inst_39503 = fluree.db.util.async.merge_into_QMARK_(inst_39500,inst_39502);
var state_39511__$1 = state_39511;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39511__$1,(15),inst_39503);
} else {
if((state_val_39512 === (10))){
var inst_39483 = (state_39511[(9)]);
var state_39511__$1 = state_39511;
var statearr_39533_39557 = state_39511__$1;
(statearr_39533_39557[(2)] = inst_39483);

(statearr_39533_39557[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39512 === (8))){
var inst_39483 = (state_39511[(2)]);
var state_39511__$1 = (function (){var statearr_39534 = state_39511;
(statearr_39534[(9)] = inst_39483);

return statearr_39534;
})();
if(cljs.core.truth_(offset)){
var statearr_39535_39558 = state_39511__$1;
(statearr_39535_39558[(1)] = (9));

} else {
var statearr_39536_39559 = state_39511__$1;
(statearr_39536_39559[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_39537 = [null,null,null,null,null,null,null,null,null,null];
(statearr_39537[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_39537[(1)] = (1));

return statearr_39537;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_39511){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39511);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39538){var ex__16398__auto__ = e39538;
var statearr_39539_39560 = state_39511;
(statearr_39539_39560[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39511[(4)]))){
var statearr_39540_39561 = state_39511;
(statearr_39540_39561[(1)] = cljs.core.first((state_39511[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39562 = state_39511;
state_39511 = G__39562;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_39511){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_39511);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39541 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39541[(6)] = c__16469__auto__);

return statearr_39541;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.flake_select.cljs$lang$maxFixedArity = 8);

/**
 * Like flake select, but takes a collection of subject ids which we
 *   then find collections of flakes for.
 */
fluree.db.query.fql.subject_select = (function fluree$db$query$fql$subject_select(var_args){
var G__39564 = arguments.length;
switch (G__39564) {
case 6:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
case 8:
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]),(arguments[(7)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$6 = (function (db,cache,fuel,max_fuel,select_spec,subjects){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,null,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit){
return fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,cache,fuel,max_fuel,select_spec,subjects,limit,null);
}));

(fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8 = (function (db,cache,fuel,max_fuel,select_spec,subjects,limit,offset){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_39650){
var state_val_39651 = (state_39650[(1)]);
if((state_val_39651 === (7))){
var inst_39645 = (state_39650[(2)]);
var _ = (function (){var statearr_39653 = state_39650;
(statearr_39653[(4)] = cljs.core.rest((state_39650[(4)])));

return statearr_39653;
})();
var state_39650__$1 = state_39650;
var statearr_39654_39706 = state_39650__$1;
(statearr_39654_39706[(2)] = inst_39645);

(statearr_39654_39706[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (20))){
var inst_39592 = (state_39650[(7)]);
var inst_39584 = (state_39650[(8)]);
var inst_39585 = (state_39650[(9)]);
var inst_39613 = (inst_39584 + (1));
var tmp39652 = inst_39585;
var inst_39583 = inst_39592;
var inst_39584__$1 = inst_39613;
var inst_39585__$1 = tmp39652;
var state_39650__$1 = (function (){var statearr_39655 = state_39650;
(statearr_39655[(8)] = inst_39584__$1);

(statearr_39655[(9)] = inst_39585__$1);

(statearr_39655[(10)] = inst_39583);

return statearr_39655;
})();
var statearr_39656_39707 = state_39650__$1;
(statearr_39656_39707[(2)] = null);

(statearr_39656_39707[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (27))){
var inst_39623 = (state_39650[(11)]);
var inst_39625 = cljs.core.count(inst_39623);
var inst_39626 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_39625);
var state_39650__$1 = state_39650;
var statearr_39657_39708 = state_39650__$1;
(statearr_39657_39708[(2)] = inst_39626);

(statearr_39657_39708[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (1))){
var state_39650__$1 = state_39650;
var statearr_39658_39709 = state_39650__$1;
(statearr_39658_39709[(2)] = null);

(statearr_39658_39709[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (24))){
var state_39650__$1 = state_39650;
var statearr_39659_39710 = state_39650__$1;
(statearr_39659_39710[(2)] = null);

(statearr_39659_39710[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (4))){
var inst_39565 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
var statearr_39660_39711 = state_39650__$1;
(statearr_39660_39711[(2)] = inst_39565);

(statearr_39660_39711[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (15))){
var inst_39606 = (state_39650[(12)]);
var inst_39606__$1 = offset;
var state_39650__$1 = (function (){var statearr_39661 = state_39650;
(statearr_39661[(12)] = inst_39606__$1);

return statearr_39661;
})();
if(cljs.core.truth_(inst_39606__$1)){
var statearr_39662_39712 = state_39650__$1;
(statearr_39662_39712[(1)] = (17));

} else {
var statearr_39663_39713 = state_39650__$1;
(statearr_39663_39713[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (21))){
var state_39650__$1 = state_39650;
var statearr_39664_39714 = state_39650__$1;
(statearr_39664_39714[(1)] = (23));



return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (13))){
var inst_39601 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
var statearr_39666_39715 = state_39650__$1;
(statearr_39666_39715[(2)] = inst_39601);

(statearr_39666_39715[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (22))){
var inst_39641 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
var statearr_39667_39716 = state_39650__$1;
(statearr_39667_39716[(2)] = inst_39641);

(statearr_39667_39716[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (29))){
var inst_39584 = (state_39650[(8)]);
var inst_39623 = (state_39650[(11)]);
var inst_39629 = (state_39650[(2)]);
var inst_39630 = (inst_39584 + (1));
var inst_39631 = fluree.db.query.fql.flakes__GT_res(db,cache,fuel,max_fuel,select_spec,inst_39623);
var state_39650__$1 = (function (){var statearr_39668 = state_39650;
(statearr_39668[(13)] = inst_39630);

(statearr_39668[(14)] = inst_39629);

return statearr_39668;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39650__$1,(30),inst_39631);
} else {
if((state_val_39651 === (6))){
var inst_39591 = (state_39650[(15)]);
var inst_39593 = (state_39650[(16)]);
var inst_39583 = (state_39650[(10)]);
var inst_39590 = cljs.core.seq(inst_39583);
var inst_39591__$1 = cljs.core.first(inst_39590);
var inst_39592 = cljs.core.next(inst_39590);
var inst_39593__$1 = (inst_39591__$1 == null);
var state_39650__$1 = (function (){var statearr_39669 = state_39650;
(statearr_39669[(7)] = inst_39592);

(statearr_39669[(15)] = inst_39591__$1);

(statearr_39669[(16)] = inst_39593__$1);

return statearr_39669;
})();
if(cljs.core.truth_(inst_39593__$1)){
var statearr_39670_39717 = state_39650__$1;
(statearr_39670_39717[(1)] = (8));

} else {
var statearr_39671_39718 = state_39650__$1;
(statearr_39671_39718[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (28))){
var state_39650__$1 = state_39650;
var statearr_39672_39719 = state_39650__$1;
(statearr_39672_39719[(2)] = null);

(statearr_39672_39719[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (25))){
var inst_39639 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
var statearr_39673_39720 = state_39650__$1;
(statearr_39673_39720[(2)] = inst_39639);

(statearr_39673_39720[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (17))){
var inst_39584 = (state_39650[(8)]);
var inst_39608 = (inst_39584 < offset);
var state_39650__$1 = state_39650;
var statearr_39674_39721 = state_39650__$1;
(statearr_39674_39721[(2)] = inst_39608);

(statearr_39674_39721[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (3))){
var inst_39648 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
return cljs.core.async.impl.ioc_helpers.return_chan(state_39650__$1,inst_39648);
} else {
if((state_val_39651 === (12))){
var inst_39596 = (state_39650[(17)]);
var state_39650__$1 = state_39650;
var statearr_39675_39722 = state_39650__$1;
(statearr_39675_39722[(2)] = inst_39596);

(statearr_39675_39722[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (2))){
var _ = (function (){var statearr_39676 = state_39650;
(statearr_39676[(4)] = cljs.core.cons((5),(state_39650[(4)])));

return statearr_39676;
})();
var inst_39578 = subjects;
var inst_39579 = cljs.core.seq(inst_39578);
var inst_39580 = cljs.core.first(inst_39579);
var inst_39581 = cljs.core.next(inst_39579);
var inst_39582 = cljs.core.PersistentVector.EMPTY;
var inst_39583 = inst_39578;
var inst_39584 = (0);
var inst_39585 = inst_39582;
var state_39650__$1 = (function (){var statearr_39677 = state_39650;
(statearr_39677[(8)] = inst_39584);

(statearr_39677[(9)] = inst_39585);

(statearr_39677[(18)] = inst_39580);

(statearr_39677[(19)] = inst_39581);

(statearr_39677[(10)] = inst_39583);

return statearr_39677;
})();
var statearr_39678_39723 = state_39650__$1;
(statearr_39678_39723[(2)] = null);

(statearr_39678_39723[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (23))){
var inst_39591 = (state_39650[(15)]);
var inst_39617 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39618 = [inst_39591];
var inst_39619 = (new cljs.core.PersistentVector(null,1,(5),inst_39617,inst_39618,null));
var inst_39620 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_39619);
var state_39650__$1 = state_39650;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_39650__$1,(26),inst_39620);
} else {
if((state_val_39651 === (19))){
var inst_39611 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
if(cljs.core.truth_(inst_39611)){
var statearr_39679_39724 = state_39650__$1;
(statearr_39679_39724[(1)] = (20));

} else {
var statearr_39680_39725 = state_39650__$1;
(statearr_39680_39725[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (11))){
var inst_39584 = (state_39650[(8)]);
var inst_39598 = (inst_39584 > limit);
var state_39650__$1 = state_39650;
var statearr_39682_39726 = state_39650__$1;
(statearr_39682_39726[(2)] = inst_39598);

(statearr_39682_39726[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (9))){
var inst_39596 = (state_39650[(17)]);
var inst_39596__$1 = limit;
var state_39650__$1 = (function (){var statearr_39683 = state_39650;
(statearr_39683[(17)] = inst_39596__$1);

return statearr_39683;
})();
if(cljs.core.truth_(inst_39596__$1)){
var statearr_39684_39727 = state_39650__$1;
(statearr_39684_39727[(1)] = (11));

} else {
var statearr_39685_39728 = state_39650__$1;
(statearr_39685_39728[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (5))){
var _ = (function (){var statearr_39686 = state_39650;
(statearr_39686[(4)] = cljs.core.rest((state_39650[(4)])));

return statearr_39686;
})();
var state_39650__$1 = state_39650;
var ex39681 = (state_39650__$1[(2)]);
var statearr_39687_39729 = state_39650__$1;
(statearr_39687_39729[(5)] = ex39681);


if((ex39681 instanceof Error)){
var statearr_39688_39730 = state_39650__$1;
(statearr_39688_39730[(1)] = (4));

(statearr_39688_39730[(5)] = null);

} else {
throw ex39681;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (14))){
var inst_39585 = (state_39650[(9)]);
var state_39650__$1 = state_39650;
var statearr_39689_39731 = state_39650__$1;
(statearr_39689_39731[(2)] = inst_39585);

(statearr_39689_39731[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (26))){
var inst_39622 = (state_39650[(2)]);
var inst_39623 = fluree.db.util.async.throw_err(inst_39622);
var state_39650__$1 = (function (){var statearr_39690 = state_39650;
(statearr_39690[(11)] = inst_39623);

return statearr_39690;
})();
if(cljs.core.truth_(fuel)){
var statearr_39691_39732 = state_39650__$1;
(statearr_39691_39732[(1)] = (27));

} else {
var statearr_39692_39733 = state_39650__$1;
(statearr_39692_39733[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (16))){
var inst_39643 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
var statearr_39693_39734 = state_39650__$1;
(statearr_39693_39734[(2)] = inst_39643);

(statearr_39693_39734[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (30))){
var inst_39592 = (state_39650[(7)]);
var inst_39585 = (state_39650[(9)]);
var inst_39630 = (state_39650[(13)]);
var inst_39633 = (state_39650[(2)]);
var inst_39634 = fluree.db.util.async.throw_err(inst_39633);
var inst_39635 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_39585,inst_39634);
var inst_39583 = inst_39592;
var inst_39584 = inst_39630;
var inst_39585__$1 = inst_39635;
var state_39650__$1 = (function (){var statearr_39694 = state_39650;
(statearr_39694[(8)] = inst_39584);

(statearr_39694[(9)] = inst_39585__$1);

(statearr_39694[(10)] = inst_39583);

return statearr_39694;
})();
var statearr_39695_39735 = state_39650__$1;
(statearr_39695_39735[(2)] = null);

(statearr_39695_39735[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (10))){
var inst_39603 = (state_39650[(2)]);
var state_39650__$1 = state_39650;
if(cljs.core.truth_(inst_39603)){
var statearr_39696_39736 = state_39650__$1;
(statearr_39696_39736[(1)] = (14));

} else {
var statearr_39697_39737 = state_39650__$1;
(statearr_39697_39737[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (18))){
var inst_39606 = (state_39650[(12)]);
var state_39650__$1 = state_39650;
var statearr_39698_39738 = state_39650__$1;
(statearr_39698_39738[(2)] = inst_39606);

(statearr_39698_39738[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_39651 === (8))){
var inst_39593 = (state_39650[(16)]);
var state_39650__$1 = state_39650;
var statearr_39699_39739 = state_39650__$1;
(statearr_39699_39739[(2)] = inst_39593);

(statearr_39699_39739[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_39700 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_39700[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_39700[(1)] = (1));

return statearr_39700;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_39650){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_39650);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e39701){var ex__16398__auto__ = e39701;
var statearr_39702_39740 = state_39650;
(statearr_39702_39740[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_39650[(4)]))){
var statearr_39703_39741 = state_39650;
(statearr_39703_39741[(1)] = cljs.core.first((state_39650[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__39742 = state_39650;
state_39650 = G__39742;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_39650){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_39650);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_39704 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_39704[(6)] = c__16469__auto__);

return statearr_39704;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.subject_select.cljs$lang$maxFixedArity = 8);

fluree.db.query.fql.valid_where_predicate_QMARK_ = (function fluree$db$query$fql$valid_where_predicate_QMARK_(db,p){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$ref_QMARK_,p);
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,p));
}
}
});
/**
 * Takes a where clause and returns subjects that match.
 */
fluree.db.query.fql.where_filter = (function fluree$db$query$fql$where_filter(var_args){
var G__39744 = arguments.length;
switch (G__39744) {
case 2:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$2 = (function (db,where_clause){
return fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where_clause,null,null);
}));

(fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4 = (function (db,where_clause,default_collection,p__39745){
var map__39746 = p__39745;
var map__39746__$1 = cljs.core.__destructure_map(map__39746);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39746__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__39746__$1,cljs.core.cst$kw$offset);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40010){
var state_val_40011 = (state_40010[(1)]);
if((state_val_40011 === (65))){
var inst_39973 = (state_40010[(7)]);
var inst_39973__$1 = (state_40010[(2)]);
var state_40010__$1 = (function (){var statearr_40012 = state_40010;
(statearr_40012[(7)] = inst_39973__$1);

return statearr_40012;
})();
if(cljs.core.truth_(inst_39973__$1)){
var statearr_40013_40131 = state_40010__$1;
(statearr_40013_40131[(1)] = (66));

} else {
var statearr_40014_40132 = state_40010__$1;
(statearr_40014_40132[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (70))){
var inst_39976 = (state_40010[(8)]);
var state_40010__$1 = state_40010;
var statearr_40015_40133 = state_40010__$1;
(statearr_40015_40133[(2)] = inst_39976);

(statearr_40015_40133[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (62))){
var inst_39964 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40016_40134 = state_40010__$1;
(statearr_40016_40134[(2)] = inst_39964);

(statearr_40016_40134[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (74))){
var inst_39983 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40017_40135 = state_40010__$1;
(statearr_40017_40135[(2)] = inst_39983);

(statearr_40017_40135[(1)] = (71));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (7))){
var inst_39759 = (state_40010[(9)]);
var state_40010__$1 = state_40010;
var statearr_40018_40136 = state_40010__$1;
(statearr_40018_40136[(2)] = inst_39759);

(statearr_40018_40136[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (59))){
var inst_39788 = (state_40010[(10)]);
var inst_39956 = cljs.core.empty_QMARK_(inst_39788);
var state_40010__$1 = state_40010;
if(inst_39956){
var statearr_40019_40137 = state_40010__$1;
(statearr_40019_40137[(1)] = (60));

} else {
var statearr_40020_40138 = state_40010__$1;
(statearr_40020_40138[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (20))){
var state_40010__$1 = state_40010;
if(cljs.core.truth_(offset)){
var statearr_40021_40139 = state_40010__$1;
(statearr_40021_40139[(1)] = (23));

} else {
var statearr_40022_40140 = state_40010__$1;
(statearr_40022_40140[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (72))){
var inst_39953 = (state_40010[(11)]);
var inst_39773 = (state_40010[(12)]);
var inst_39979 = cljs.core.count(inst_39953);
var inst_39980 = (inst_39979 > inst_39773);
var state_40010__$1 = state_40010;
var statearr_40023_40141 = state_40010__$1;
(statearr_40023_40141[(2)] = inst_39980);

(statearr_40023_40141[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (58))){
var inst_39788 = (state_40010[(10)]);
var inst_39953 = (state_40010[(11)]);
var inst_39954 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39788,inst_39953);
var state_40010__$1 = state_40010;
var statearr_40024_40142 = state_40010__$1;
(statearr_40024_40142[(2)] = inst_39954);

(statearr_40024_40142[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (60))){
var inst_39788 = (state_40010[(10)]);
var inst_39953 = (state_40010[(11)]);
var inst_39958 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39788,inst_39953);
var state_40010__$1 = state_40010;
var statearr_40025_40143 = state_40010__$1;
(statearr_40025_40143[(2)] = inst_39958);

(statearr_40025_40143[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (27))){
var inst_39803 = (state_40010[(13)]);
var state_40010__$1 = state_40010;
var statearr_40026_40144 = state_40010__$1;
(statearr_40026_40144[(2)] = inst_39803);

(statearr_40026_40144[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (1))){
var state_40010__$1 = state_40010;
var statearr_40027_40145 = state_40010__$1;
(statearr_40027_40145[(2)] = null);

(statearr_40027_40145[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (69))){
var inst_39773 = (state_40010[(12)]);
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39773)){
var statearr_40028_40146 = state_40010__$1;
(statearr_40028_40146[(1)] = (72));

} else {
var statearr_40029_40147 = state_40010__$1;
(statearr_40029_40147[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (24))){
var inst_39788 = (state_40010[(10)]);
var state_40010__$1 = state_40010;
var statearr_40030_40148 = state_40010__$1;
(statearr_40030_40148[(2)] = inst_39788);

(statearr_40030_40148[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (55))){
var inst_39942 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40031_40149 = state_40010__$1;
(statearr_40031_40149[(2)] = inst_39942);

(statearr_40031_40149[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (39))){
var inst_39950 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40032_40150 = state_40010__$1;
(statearr_40032_40150[(2)] = inst_39950);

(statearr_40032_40150[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (46))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39908 = (inst_39832.cljs$core$IFn$_invoke$arity$2 ? inst_39832.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,inst_39814) : inst_39832.call(null,cljs.core._LT_,inst_39814));
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39908)){
var statearr_40033_40151 = state_40010__$1;
(statearr_40033_40151[(1)] = (49));

} else {
var statearr_40034_40152 = state_40010__$1;
(statearr_40034_40152[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (4))){
var inst_39747 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40035_40153 = state_40010__$1;
(statearr_40035_40153[(2)] = inst_39747);

(statearr_40035_40153[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (77))){
var inst_39998 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40036_40154 = state_40010__$1;
(statearr_40036_40154[(2)] = inst_39998);

(statearr_40036_40154[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (54))){
var inst_39940 = cljs.core.PersistentVector.EMPTY;
var state_40010__$1 = state_40010;
var statearr_40037_40155 = state_40010__$1;
(statearr_40037_40155[(2)] = inst_39940);

(statearr_40037_40155[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (15))){
var inst_39758 = (state_40010[(16)]);
var inst_39783 = cljs.core.seq(inst_39758);
var inst_39784 = cljs.core.first(inst_39783);
var inst_39785 = cljs.core.next(inst_39783);
var inst_39786 = cljs.core.PersistentHashSet.EMPTY;
var inst_39787 = inst_39758;
var inst_39788 = inst_39786;
var state_40010__$1 = (function (){var statearr_40038 = state_40010;
(statearr_40038[(10)] = inst_39788);

(statearr_40038[(17)] = inst_39787);

(statearr_40038[(18)] = inst_39784);

(statearr_40038[(19)] = inst_39785);

return statearr_40038;
})();
var statearr_40039_40156 = state_40010__$1;
(statearr_40039_40156[(2)] = null);

(statearr_40039_40156[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (48))){
var inst_39905 = (state_40010[(2)]);
var inst_39906 = fluree.db.util.async.throw_err(inst_39905);
var state_40010__$1 = state_40010;
var statearr_40040_40157 = state_40010__$1;
(statearr_40040_40157[(2)] = inst_39906);

(statearr_40040_40157[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (50))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39924 = (inst_39832.cljs$core$IFn$_invoke$arity$2 ? inst_39832.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,inst_39814) : inst_39832.call(null,cljs.core._LT__EQ_,inst_39814));
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39924)){
var statearr_40041_40158 = state_40010__$1;
(statearr_40041_40158[(1)] = (53));

} else {
var statearr_40042_40159 = state_40010__$1;
(statearr_40042_40159[(1)] = (54));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (75))){
var state_40010__$1 = state_40010;
if(cljs.core.truth_(offset)){
var statearr_40043_40160 = state_40010__$1;
(statearr_40043_40160[(1)] = (78));

} else {
var statearr_40044_40161 = state_40010__$1;
(statearr_40044_40161[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (21))){
var inst_39794 = (state_40010[(20)]);
var inst_39813 = (state_40010[(21)]);
var inst_39813__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39794,(0),null);
var inst_39814 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39794,(1),null);
var inst_39815 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39794,(2),null);
var inst_39816 = fluree.db.query.fql.valid_where_predicate_QMARK_(db,inst_39813__$1);
var inst_39817 = cljs.core.not(inst_39816);
var state_40010__$1 = (function (){var statearr_40045 = state_40010;
(statearr_40045[(21)] = inst_39813__$1);

(statearr_40045[(14)] = inst_39814);

(statearr_40045[(22)] = inst_39815);

return statearr_40045;
})();
if(inst_39817){
var statearr_40046_40162 = state_40010__$1;
(statearr_40046_40162[(1)] = (29));

} else {
var statearr_40047_40163 = state_40010__$1;
(statearr_40047_40163[(1)] = (30));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (31))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39828 = (state_40010[(2)]);
var inst_39832__$1 = cljs.core.identical_QMARK_;
var inst_39833 = (inst_39832__$1.cljs$core$IFn$_invoke$arity$2 ? inst_39832__$1.cljs$core$IFn$_invoke$arity$2(cljs.core.not_EQ_,inst_39814) : inst_39832__$1.call(null,cljs.core.not_EQ_,inst_39814));
var state_40010__$1 = (function (){var statearr_40048 = state_40010;
(statearr_40048[(23)] = inst_39828);

(statearr_40048[(15)] = inst_39832__$1);

return statearr_40048;
})();
if(cljs.core.truth_(inst_39833)){
var statearr_40049_40164 = state_40010__$1;
(statearr_40049_40164[(1)] = (32));

} else {
var statearr_40050_40165 = state_40010__$1;
(statearr_40050_40165[(1)] = (33));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (32))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39835 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39836 = [inst_39813,inst_39815];
var inst_39837 = (new cljs.core.PersistentVector(null,2,(5),inst_39835,inst_39836,null));
var inst_39838 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39839 = [inst_39813];
var inst_39840 = (new cljs.core.PersistentVector(null,1,(5),inst_39838,inst_39839,null));
var inst_39841 = [cljs.core.cst$kw$limit];
var inst_39842 = [inst_39773];
var inst_39843 = cljs.core.PersistentHashMap.fromArrays(inst_39841,inst_39842);
var inst_39844 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39837,cljs.core._LT__EQ_,inst_39840,inst_39843);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(35),inst_39844);
} else {
if((state_val_40011 === (40))){
var inst_39873 = (state_40010[(2)]);
var inst_39874 = fluree.db.util.async.throw_err(inst_39873);
var state_40010__$1 = state_40010;
var statearr_40051_40166 = state_40010__$1;
(statearr_40051_40166[(2)] = inst_39874);

(statearr_40051_40166[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (56))){
var inst_39937 = (state_40010[(2)]);
var inst_39938 = fluree.db.util.async.throw_err(inst_39937);
var state_40010__$1 = state_40010;
var statearr_40052_40167 = state_40010__$1;
(statearr_40052_40167[(2)] = inst_39938);

(statearr_40052_40167[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (33))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39863 = (inst_39832.cljs$core$IFn$_invoke$arity$2 ? inst_39832.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,inst_39814) : inst_39832.call(null,cljs.core._EQ_,inst_39814));
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39863)){
var statearr_40053_40168 = state_40010__$1;
(statearr_40053_40168[(1)] = (37));

} else {
var statearr_40054_40169 = state_40010__$1;
(statearr_40054_40169[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (13))){
var state_40010__$1 = state_40010;
var statearr_40055_40170 = state_40010__$1;
(statearr_40055_40170[(2)] = limit);

(statearr_40055_40170[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (22))){
var inst_40000 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40056_40171 = state_40010__$1;
(statearr_40056_40171[(2)] = inst_40000);

(statearr_40056_40171[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (36))){
var inst_39847 = (state_40010[(24)]);
var inst_39859 = (state_40010[(2)]);
var inst_39860 = fluree.db.util.async.throw_err(inst_39859);
var inst_39861 = cljs.core.concat.cljs$core$IFn$_invoke$arity$2(inst_39847,inst_39860);
var state_40010__$1 = state_40010;
var statearr_40057_40172 = state_40010__$1;
(statearr_40057_40172[(2)] = inst_39861);

(statearr_40057_40172[(1)] = (34));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (41))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39878 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39879 = [inst_39813,inst_39815];
var inst_39880 = (new cljs.core.PersistentVector(null,2,(5),inst_39878,inst_39879,null));
var inst_39881 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39882 = [inst_39813];
var inst_39883 = (new cljs.core.PersistentVector(null,1,(5),inst_39881,inst_39882,null));
var inst_39884 = [cljs.core.cst$kw$limit];
var inst_39885 = [inst_39773];
var inst_39886 = cljs.core.PersistentHashMap.fromArrays(inst_39884,inst_39885);
var inst_39887 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT_,inst_39880,cljs.core._LT__EQ_,inst_39883,inst_39886);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(44),inst_39887);
} else {
if((state_val_40011 === (43))){
var inst_39948 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40058_40173 = state_40010__$1;
(statearr_40058_40173[(2)] = inst_39948);

(statearr_40058_40173[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (61))){
var inst_39788 = (state_40010[(10)]);
var inst_39953 = (state_40010[(11)]);
var inst_39960 = cljs.core.PersistentHashSet.EMPTY;
var inst_39961 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_39960,inst_39953);
var inst_39962 = clojure.set.intersection.cljs$core$IFn$_invoke$arity$2(inst_39788,inst_39961);
var state_40010__$1 = state_40010;
var statearr_40059_40174 = state_40010__$1;
(statearr_40059_40174[(2)] = inst_39962);

(statearr_40059_40174[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (29))){
var inst_39813 = (state_40010[(21)]);
var inst_39819 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_39813);
var inst_39820 = ["Non-indexed predicates are not valid in where clause statements. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_39819)].join('');
var inst_39821 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_39822 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_39823 = cljs.core.PersistentHashMap.fromArrays(inst_39821,inst_39822);
var inst_39824 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_39820,inst_39823);
var inst_39825 = (function(){throw inst_39824})();
var state_40010__$1 = state_40010;
var statearr_40060_40175 = state_40010__$1;
(statearr_40060_40175[(2)] = inst_39825);

(statearr_40060_40175[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (44))){
var inst_39889 = (state_40010[(2)]);
var inst_39890 = fluree.db.util.async.throw_err(inst_39889);
var state_40010__$1 = state_40010;
var statearr_40061_40176 = state_40010__$1;
(statearr_40061_40176[(2)] = inst_39890);

(statearr_40061_40176[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (6))){
var inst_39757 = (state_40010[(25)]);
var inst_39761 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_39757);
var state_40010__$1 = state_40010;
var statearr_40062_40177 = state_40010__$1;
(statearr_40062_40177[(2)] = inst_39761);

(statearr_40062_40177[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (28))){
var inst_39808 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40063_40178 = state_40010__$1;
(statearr_40063_40178[(2)] = inst_39808);

(statearr_40063_40178[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (64))){
var inst_39968 = (state_40010[(26)]);
var state_40010__$1 = state_40010;
var statearr_40064_40179 = state_40010__$1;
(statearr_40064_40179[(2)] = inst_39968);

(statearr_40064_40179[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (51))){
var inst_39944 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40065_40180 = state_40010__$1;
(statearr_40065_40180[(2)] = inst_39944);

(statearr_40065_40180[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (25))){
var inst_39803 = (state_40010[(2)]);
var state_40010__$1 = (function (){var statearr_40066 = state_40010;
(statearr_40066[(13)] = inst_39803);

return statearr_40066;
})();
if(cljs.core.truth_(limit)){
var statearr_40067_40181 = state_40010__$1;
(statearr_40067_40181[(1)] = (26));

} else {
var statearr_40068_40182 = state_40010__$1;
(statearr_40068_40182[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (34))){
var inst_39757 = (state_40010[(25)]);
var inst_39952 = (state_40010[(2)]);
var inst_39953 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(fluree.db.query.fql.s,inst_39952);
var state_40010__$1 = (function (){var statearr_40069 = state_40010;
(statearr_40069[(11)] = inst_39953);

return statearr_40069;
})();
var G__40070_40183 = inst_39757;
var G__40070_40184__$1 = (((G__40070_40183 instanceof cljs.core.Keyword))?G__40070_40183.fqn:null);
switch (G__40070_40184__$1) {
case "or":
var statearr_40071_40186 = state_40010__$1;
(statearr_40071_40186[(1)] = (58));


break;
case "and":
var statearr_40072_40187 = state_40010__$1;
(statearr_40072_40187[(1)] = (59));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__40070_40184__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (17))){
var inst_40005 = (state_40010[(2)]);
var _ = (function (){var statearr_40073 = state_40010;
(statearr_40073[(4)] = cljs.core.rest((state_40010[(4)])));

return statearr_40073;
})();
var state_40010__$1 = state_40010;
var statearr_40074_40188 = state_40010__$1;
(statearr_40074_40188[(2)] = inst_40005);

(statearr_40074_40188[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (3))){
var inst_40008 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40010__$1,inst_40008);
} else {
if((state_val_40011 === (12))){
var inst_39767 = (offset + limit);
var state_40010__$1 = state_40010;
var statearr_40075_40189 = state_40010__$1;
(statearr_40075_40189[(2)] = inst_39767);

(statearr_40075_40189[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (2))){
var inst_39759 = (state_40010[(9)]);
var _ = (function (){var statearr_40076 = state_40010;
(statearr_40076[(4)] = cljs.core.cons((5),(state_40010[(4)])));

return statearr_40076;
})();
var inst_39756 = fluree.db.query.fql_parser.parse_where.cljs$core$IFn$_invoke$arity$3(db,where_clause,default_collection);
var inst_39757 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39756,(0),null);
var inst_39758 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_39756,(1),null);
var inst_39759__$1 = limit;
var state_40010__$1 = (function (){var statearr_40077 = state_40010;
(statearr_40077[(25)] = inst_39757);

(statearr_40077[(9)] = inst_39759__$1);

(statearr_40077[(16)] = inst_39758);

return statearr_40077;
})();
if(cljs.core.truth_(inst_39759__$1)){
var statearr_40078_40190 = state_40010__$1;
(statearr_40078_40190[(1)] = (6));

} else {
var statearr_40079_40191 = state_40010__$1;
(statearr_40079_40191[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (66))){
var inst_39973 = (state_40010[(7)]);
var state_40010__$1 = state_40010;
var statearr_40080_40192 = state_40010__$1;
(statearr_40080_40192[(2)] = inst_39973);

(statearr_40080_40192[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (23))){
var inst_39788 = (state_40010[(10)]);
var inst_39800 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_39788);
var state_40010__$1 = state_40010;
var statearr_40081_40193 = state_40010__$1;
(statearr_40081_40193[(2)] = inst_39800);

(statearr_40081_40193[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (47))){
var inst_39946 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40082_40194 = state_40010__$1;
(statearr_40082_40194[(2)] = inst_39946);

(statearr_40082_40194[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (35))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39846 = (state_40010[(2)]);
var inst_39847 = fluree.db.util.async.throw_err(inst_39846);
var inst_39848 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39849 = [inst_39813];
var inst_39850 = (new cljs.core.PersistentVector(null,1,(5),inst_39848,inst_39849,null));
var inst_39851 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39852 = [inst_39813,inst_39815];
var inst_39853 = (new cljs.core.PersistentVector(null,2,(5),inst_39851,inst_39852,null));
var inst_39854 = [cljs.core.cst$kw$limit];
var inst_39855 = [inst_39773];
var inst_39856 = cljs.core.PersistentHashMap.fromArrays(inst_39854,inst_39855);
var inst_39857 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39850,cljs.core._LT_,inst_39853,inst_39856);
var state_40010__$1 = (function (){var statearr_40083 = state_40010;
(statearr_40083[(24)] = inst_39847);

return statearr_40083;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(36),inst_39857);
} else {
if((state_val_40011 === (76))){
var inst_39967 = (state_40010[(27)]);
var inst_39795 = (state_40010[(28)]);
var inst_39787 = inst_39795;
var inst_39788 = inst_39967;
var state_40010__$1 = (function (){var statearr_40084 = state_40010;
(statearr_40084[(10)] = inst_39788);

(statearr_40084[(17)] = inst_39787);

return statearr_40084;
})();
var statearr_40085_40195 = state_40010__$1;
(statearr_40085_40195[(2)] = null);

(statearr_40085_40195[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (19))){
var inst_40002 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40086_40196 = state_40010__$1;
(statearr_40086_40196[(2)] = inst_40002);

(statearr_40086_40196[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (57))){
var inst_39968 = (state_40010[(26)]);
var inst_39757 = (state_40010[(25)]);
var inst_39967 = (state_40010[(2)]);
var inst_39968__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_39757);
var state_40010__$1 = (function (){var statearr_40087 = state_40010;
(statearr_40087[(26)] = inst_39968__$1);

(statearr_40087[(27)] = inst_39967);

return statearr_40087;
})();
if(inst_39968__$1){
var statearr_40088_40197 = state_40010__$1;
(statearr_40088_40197[(1)] = (63));

} else {
var statearr_40089_40198 = state_40010__$1;
(statearr_40089_40198[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (68))){
var inst_39988 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39988)){
var statearr_40090_40199 = state_40010__$1;
(statearr_40090_40199[(1)] = (75));

} else {
var statearr_40091_40200 = state_40010__$1;
(statearr_40091_40200[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (11))){
var inst_39758 = (state_40010[(16)]);
var inst_39773 = (state_40010[(2)]);
var inst_39774 = cljs.core.not_empty(inst_39758);
var state_40010__$1 = (function (){var statearr_40093 = state_40010;
(statearr_40093[(12)] = inst_39773);

return statearr_40093;
})();
if(cljs.core.truth_(inst_39774)){
var statearr_40094_40201 = state_40010__$1;
(statearr_40094_40201[(1)] = (15));

} else {
var statearr_40095_40202 = state_40010__$1;
(statearr_40095_40202[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (9))){
var state_40010__$1 = state_40010;
if(cljs.core.truth_(offset)){
var statearr_40096_40203 = state_40010__$1;
(statearr_40096_40203[(1)] = (12));

} else {
var statearr_40097_40204 = state_40010__$1;
(statearr_40097_40204[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (5))){
var _ = (function (){var statearr_40098 = state_40010;
(statearr_40098[(4)] = cljs.core.rest((state_40010[(4)])));

return statearr_40098;
})();
var state_40010__$1 = state_40010;
var ex40092 = (state_40010__$1[(2)]);
var statearr_40099_40205 = state_40010__$1;
(statearr_40099_40205[(5)] = ex40092);


if((ex40092 instanceof Error)){
var statearr_40100_40206 = state_40010__$1;
(statearr_40100_40206[(1)] = (4));

(statearr_40100_40206[(5)] = null);

} else {
throw ex40092;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (14))){
var inst_39770 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40101_40207 = state_40010__$1;
(statearr_40101_40207[(2)] = inst_39770);

(statearr_40101_40207[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (45))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39894 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39895 = [inst_39813,inst_39815];
var inst_39896 = (new cljs.core.PersistentVector(null,2,(5),inst_39894,inst_39895,null));
var inst_39897 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39898 = [inst_39813];
var inst_39899 = (new cljs.core.PersistentVector(null,1,(5),inst_39897,inst_39898,null));
var inst_39900 = [cljs.core.cst$kw$limit];
var inst_39901 = [inst_39773];
var inst_39902 = cljs.core.PersistentHashMap.fromArrays(inst_39900,inst_39901);
var inst_39903 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39896,cljs.core._LT__EQ_,inst_39899,inst_39902);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(48),inst_39903);
} else {
if((state_val_40011 === (53))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39926 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39927 = [inst_39813];
var inst_39928 = (new cljs.core.PersistentVector(null,1,(5),inst_39926,inst_39927,null));
var inst_39929 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39930 = [inst_39813,inst_39815];
var inst_39931 = (new cljs.core.PersistentVector(null,2,(5),inst_39929,inst_39930,null));
var inst_39932 = [cljs.core.cst$kw$limit];
var inst_39933 = [inst_39773];
var inst_39934 = cljs.core.PersistentHashMap.fromArrays(inst_39932,inst_39933);
var inst_39935 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39928,cljs.core._LT__EQ_,inst_39931,inst_39934);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(56),inst_39935);
} else {
if((state_val_40011 === (78))){
var inst_39967 = (state_40010[(27)]);
var inst_39991 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(offset,inst_39967);
var state_40010__$1 = state_40010;
var statearr_40102_40208 = state_40010__$1;
(statearr_40102_40208[(2)] = inst_39991);

(statearr_40102_40208[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (26))){
var inst_39803 = (state_40010[(13)]);
var inst_39805 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(limit,inst_39803);
var state_40010__$1 = state_40010;
var statearr_40103_40209 = state_40010__$1;
(statearr_40103_40209[(2)] = inst_39805);

(statearr_40103_40209[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (16))){
var state_40010__$1 = state_40010;
var statearr_40104_40210 = state_40010__$1;
(statearr_40104_40210[(2)] = null);

(statearr_40104_40210[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (79))){
var inst_39967 = (state_40010[(27)]);
var state_40010__$1 = state_40010;
var statearr_40105_40211 = state_40010__$1;
(statearr_40105_40211[(2)] = inst_39967);

(statearr_40105_40211[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (38))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39876 = (inst_39832.cljs$core$IFn$_invoke$arity$2 ? inst_39832.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,inst_39814) : inst_39832.call(null,cljs.core._GT_,inst_39814));
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39876)){
var statearr_40106_40212 = state_40010__$1;
(statearr_40106_40212[(1)] = (41));

} else {
var statearr_40107_40213 = state_40010__$1;
(statearr_40107_40213[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (30))){
var state_40010__$1 = state_40010;
var statearr_40108_40214 = state_40010__$1;
(statearr_40108_40214[(2)] = null);

(statearr_40108_40214[(1)] = (31));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (73))){
var inst_39773 = (state_40010[(12)]);
var state_40010__$1 = state_40010;
var statearr_40109_40215 = state_40010__$1;
(statearr_40109_40215[(2)] = inst_39773);

(statearr_40109_40215[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (10))){
var state_40010__$1 = state_40010;
var statearr_40110_40216 = state_40010__$1;
(statearr_40110_40216[(2)] = null);

(statearr_40110_40216[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (18))){
var inst_39794 = (state_40010[(20)]);
var inst_39787 = (state_40010[(17)]);
var inst_39793 = cljs.core.seq(inst_39787);
var inst_39794__$1 = cljs.core.first(inst_39793);
var inst_39795 = cljs.core.next(inst_39793);
var inst_39796 = cljs.core.not(inst_39794__$1);
var state_40010__$1 = (function (){var statearr_40111 = state_40010;
(statearr_40111[(20)] = inst_39794__$1);

(statearr_40111[(28)] = inst_39795);

return statearr_40111;
})();
if(inst_39796){
var statearr_40112_40217 = state_40010__$1;
(statearr_40112_40217[(1)] = (20));

} else {
var statearr_40113_40218 = state_40010__$1;
(statearr_40113_40218[(1)] = (21));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (52))){
var inst_39921 = (state_40010[(2)]);
var inst_39922 = fluree.db.util.async.throw_err(inst_39921);
var state_40010__$1 = state_40010;
var statearr_40114_40219 = state_40010__$1;
(statearr_40114_40219[(2)] = inst_39922);

(statearr_40114_40219[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (67))){
var inst_39976 = (state_40010[(8)]);
var inst_39757 = (state_40010[(25)]);
var inst_39976__$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$and,inst_39757);
var state_40010__$1 = (function (){var statearr_40115 = state_40010;
(statearr_40115[(8)] = inst_39976__$1);

return statearr_40115;
})();
if(inst_39976__$1){
var statearr_40116_40220 = state_40010__$1;
(statearr_40116_40220[(1)] = (69));

} else {
var statearr_40117_40221 = state_40010__$1;
(statearr_40117_40221[(1)] = (70));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (71))){
var inst_39986 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40118_40222 = state_40010__$1;
(statearr_40118_40222[(2)] = inst_39986);

(statearr_40118_40222[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (42))){
var inst_39814 = (state_40010[(14)]);
var inst_39832 = (state_40010[(15)]);
var inst_39892 = (inst_39832.cljs$core$IFn$_invoke$arity$2 ? inst_39832.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,inst_39814) : inst_39832.call(null,cljs.core._GT__EQ_,inst_39814));
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39892)){
var statearr_40119_40223 = state_40010__$1;
(statearr_40119_40223[(1)] = (45));

} else {
var statearr_40120_40224 = state_40010__$1;
(statearr_40120_40224[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (80))){
var inst_39994 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
var statearr_40121_40225 = state_40010__$1;
(statearr_40121_40225[(2)] = inst_39994);

(statearr_40121_40225[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (37))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39865 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39866 = [inst_39813,inst_39815];
var inst_39867 = (new cljs.core.PersistentVector(null,2,(5),inst_39865,inst_39866,null));
var inst_39868 = [cljs.core.cst$kw$limit];
var inst_39869 = [inst_39773];
var inst_39870 = cljs.core.PersistentHashMap.fromArrays(inst_39868,inst_39869);
var inst_39871 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_39867,inst_39870);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(40),inst_39871);
} else {
if((state_val_40011 === (63))){
var inst_39967 = (state_40010[(27)]);
var inst_39970 = cljs.core.empty_QMARK_(inst_39967);
var state_40010__$1 = state_40010;
var statearr_40122_40226 = state_40010__$1;
(statearr_40122_40226[(2)] = inst_39970);

(statearr_40122_40226[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (8))){
var inst_39764 = (state_40010[(2)]);
var state_40010__$1 = state_40010;
if(cljs.core.truth_(inst_39764)){
var statearr_40123_40227 = state_40010__$1;
(statearr_40123_40227[(1)] = (9));

} else {
var statearr_40124_40228 = state_40010__$1;
(statearr_40124_40228[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40011 === (49))){
var inst_39813 = (state_40010[(21)]);
var inst_39815 = (state_40010[(22)]);
var inst_39773 = (state_40010[(12)]);
var inst_39910 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39911 = [inst_39813];
var inst_39912 = (new cljs.core.PersistentVector(null,1,(5),inst_39910,inst_39911,null));
var inst_39913 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_39914 = [inst_39813,inst_39815];
var inst_39915 = (new cljs.core.PersistentVector(null,2,(5),inst_39913,inst_39914,null));
var inst_39916 = [cljs.core.cst$kw$limit];
var inst_39917 = [inst_39773];
var inst_39918 = cljs.core.PersistentHashMap.fromArrays(inst_39916,inst_39917);
var inst_39919 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$post,cljs.core._GT__EQ_,inst_39912,cljs.core._LT_,inst_39915,inst_39918);
var state_40010__$1 = state_40010;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40010__$1,(52),inst_39919);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_40125 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40125[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_40125[(1)] = (1));

return statearr_40125;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_40010){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40010);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40126){var ex__16398__auto__ = e40126;
var statearr_40127_40229 = state_40010;
(statearr_40127_40229[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40010[(4)]))){
var statearr_40128_40230 = state_40010;
(statearr_40128_40230[(1)] = cljs.core.first((state_40010[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40231 = state_40010;
state_40010 = G__40231;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_40010){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_40010);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40129 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40129[(6)] = c__16469__auto__);

return statearr_40129;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.where_filter.cljs$lang$maxFixedArity = 4);

fluree.db.query.fql.parse_map = (function fluree$db$query$fql$parse_map(x,valid_var){
var _ = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),cljs.core.count(cljs.core.keys(x))))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid aggregate selection, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
var var_as_symbol = cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.keys(x)));
var ___$1 = (cljs.core.truth_((valid_var.cljs$core$IFn$_invoke$arity$1 ? valid_var.cljs$core$IFn$_invoke$arity$1(var_as_symbol) : valid_var.call(null,var_as_symbol)))?null:(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select variable in aggregate select, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(x)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})());
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$variable,var_as_symbol,cljs.core.cst$kw$selection,cljs.core.first(cljs.core.vals(x))], null);
});
fluree.db.query.fql.parse_select = (function fluree$db$query$fql$parse_select(vars,interim_vars,select_smt){
var _ = (function (){var or__4212__auto__ = cljs.core.every_QMARK_((function (p1__40232_SHARP_){
return ((typeof p1__40232_SHARP_ === 'string') || (cljs.core.map_QMARK_(p1__40232_SHARP_)));
}),select_smt);
if(or__4212__auto__){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select statement. Every selection must be a string or map. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select_smt)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
})();
var vars__$1 = cljs.core.set(vars);
var all_vars = cljs.core.set(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(vars__$1,cljs.core.keys(interim_vars)));
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select){
var var_symbol = ((cljs.core.map_QMARK_(select))?null:cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(select));
if(cljs.core.truth_((vars__$1.cljs$core$IFn$_invoke$arity$1 ? vars__$1.cljs$core$IFn$_invoke$arity$1(var_symbol) : vars__$1.call(null,var_symbol)))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$variable,var_symbol], null);
} else {
if(cljs.core.truth_(fluree.db.query.analytical.aggregate_QMARK_(select))){
return fluree.db.query.analytical.parse_aggregate(select,vars__$1);
} else {
if(cljs.core.map_QMARK_(select)){
return fluree.db.query.fql.parse_map(select,all_vars);
} else {
if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol))){
return new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$value,cljs.core.get.cljs$core$IFn$_invoke$arity$2(interim_vars,var_symbol)], null);
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid select in statement, provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(select)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));

}
}
}
}
}),select_smt);
});
fluree.db.query.fql.get_pretty_print_keys = (function fluree$db$query$fql$get_pretty_print_keys(select){
var vars = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (select__$1){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select__$1));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1))){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$2(cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select__$1)),(1));
} else {
return null;
}
}
}
}),select);
var freqs = cljs.core.frequencies(vars);
if(cljs.core.every_QMARK_((function (p1__40233_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),p1__40233_SHARP_);
}),cljs.core.vals(freqs))){
return vars;
} else {
var G__40237 = vars;
var vec__40238 = G__40237;
var seq__40239 = cljs.core.seq(vec__40238);
var first__40240 = cljs.core.first(seq__40239);
var seq__40239__$1 = cljs.core.next(seq__40239);
var var$ = first__40240;
var r = seq__40239__$1;
var all_vars = cljs.core.PersistentVector.EMPTY;
var G__40237__$1 = G__40237;
var all_vars__$1 = all_vars;
while(true){
var vec__40245 = G__40237__$1;
var seq__40246 = cljs.core.seq(vec__40245);
var first__40247 = cljs.core.first(seq__40246);
var seq__40246__$1 = cljs.core.next(seq__40246);
var var$__$1 = first__40247;
var r__$1 = seq__40246__$1;
var all_vars__$2 = all_vars__$1;
if(cljs.core.not(var$__$1)){
return all_vars__$2;
} else {
if(cljs.core.truth_((function (){var fexpr__40248 = cljs.core.set(all_vars__$2);
return (fexpr__40248.cljs$core$IFn$_invoke$arity$1 ? fexpr__40248.cljs$core$IFn$_invoke$arity$1(var$__$1) : fexpr__40248.call(null,var$__$1));
})())){
var G__40249 = r__$1;
var G__40250 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,[cljs.core.str.cljs$core$IFn$_invoke$arity$1(var$__$1),"$",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.count(all_vars__$2))].join(''));
G__40237__$1 = G__40249;
all_vars__$1 = G__40250;
continue;
} else {
var G__40251 = r__$1;
var G__40252 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(all_vars__$2,var$__$1);
G__40237__$1 = G__40251;
all_vars__$1 = G__40252;
continue;

}
}
break;
}
}
});
fluree.db.query.fql.format_tuple = (function fluree$db$query$fql$format_tuple(functionArray,tuple){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40287){
var state_val_40288 = (state_40287[(1)]);
if((state_val_40288 === (1))){
var inst_40260 = functionArray;
var inst_40261 = cljs.core.seq(inst_40260);
var inst_40262 = cljs.core.first(inst_40261);
var inst_40263 = cljs.core.next(inst_40261);
var inst_40264 = cljs.core.PersistentVector.EMPTY;
var inst_40265 = inst_40260;
var inst_40266 = inst_40264;
var state_40287__$1 = (function (){var statearr_40289 = state_40287;
(statearr_40289[(7)] = inst_40266);

(statearr_40289[(8)] = inst_40263);

(statearr_40289[(9)] = inst_40262);

(statearr_40289[(10)] = inst_40265);

return statearr_40289;
})();
var statearr_40290_40303 = state_40287__$1;
(statearr_40290_40303[(2)] = null);

(statearr_40290_40303[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40288 === (2))){
var inst_40272 = (state_40287[(11)]);
var inst_40265 = (state_40287[(10)]);
var inst_40271 = cljs.core.seq(inst_40265);
var inst_40272__$1 = cljs.core.first(inst_40271);
var inst_40273 = cljs.core.next(inst_40271);
var state_40287__$1 = (function (){var statearr_40291 = state_40287;
(statearr_40291[(11)] = inst_40272__$1);

(statearr_40291[(12)] = inst_40273);

return statearr_40291;
})();
if(cljs.core.truth_(inst_40272__$1)){
var statearr_40292_40304 = state_40287__$1;
(statearr_40292_40304[(1)] = (4));

} else {
var statearr_40293_40305 = state_40287__$1;
(statearr_40293_40305[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40288 === (3))){
var inst_40285 = (state_40287[(2)]);
var state_40287__$1 = state_40287;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40287__$1,inst_40285);
} else {
if((state_val_40288 === (4))){
var inst_40272 = (state_40287[(11)]);
var inst_40275 = (inst_40272.cljs$core$IFn$_invoke$arity$1 ? inst_40272.cljs$core$IFn$_invoke$arity$1(tuple) : inst_40272.call(null,tuple));
var state_40287__$1 = state_40287;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40287__$1,(7),inst_40275);
} else {
if((state_val_40288 === (5))){
var inst_40266 = (state_40287[(7)]);
var state_40287__$1 = state_40287;
var statearr_40294_40306 = state_40287__$1;
(statearr_40294_40306[(2)] = inst_40266);

(statearr_40294_40306[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40288 === (6))){
var inst_40283 = (state_40287[(2)]);
var state_40287__$1 = state_40287;
var statearr_40295_40307 = state_40287__$1;
(statearr_40295_40307[(2)] = inst_40283);

(statearr_40295_40307[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40288 === (7))){
var inst_40266 = (state_40287[(7)]);
var inst_40273 = (state_40287[(12)]);
var inst_40277 = (state_40287[(2)]);
var inst_40278 = fluree.db.util.async.throw_err(inst_40277);
var inst_40279 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40266,inst_40278);
var inst_40265 = inst_40273;
var inst_40266__$1 = inst_40279;
var state_40287__$1 = (function (){var statearr_40296 = state_40287;
(statearr_40296[(7)] = inst_40266__$1);

(statearr_40296[(10)] = inst_40265);

return statearr_40296;
})();
var statearr_40297_40308 = state_40287__$1;
(statearr_40297_40308[(2)] = null);

(statearr_40297_40308[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0 = (function (){
var statearr_40298 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40298[(0)] = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__);

(statearr_40298[(1)] = (1));

return statearr_40298;
});
var fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1 = (function (state_40287){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40287);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40299){var ex__16398__auto__ = e40299;
var statearr_40300_40309 = state_40287;
(statearr_40300_40309[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40287[(4)]))){
var statearr_40301_40310 = state_40287;
(statearr_40301_40310[(1)] = cljs.core.first((state_40287[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40311 = state_40287;
state_40287 = G__40311;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__ = function(state_40287){
switch(arguments.length){
case 0:
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1.call(this,state_40287);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____0;
fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$format_tuple_$_state_machine__16395__auto____1;
return fluree$db$query$fql$format_tuple_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40302 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40302[(6)] = c__16469__auto__);

return statearr_40302;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.get_header_idx = (function fluree$db$query$fql$get_header_idx(headers,select){
if(cljs.core.truth_(cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(select));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.str,headers),cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.cst$kw$code.cljs$core$IFn$_invoke$arity$1(select)));
} else {
if(cljs.core.truth_(cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select))){
return fluree.db.util.core.index_of(headers,cljs.core.cst$kw$variable.cljs$core$IFn$_invoke$arity$1(select));
} else {
return null;
}
}
}
});
/**
 * Builds list of two-tuples: ([tuple-index query-map] ...)
 *   for :select tuple positions that define a graph crawling query map.
 * 
 *   Used by 'expand-map' and 'replace-expand-map' functions for executing
 *   the query map and inserting the query map results into the final response
 *   respectively.
 * 
 *   i.e. if the initial query was {:select [?x {?person ['*']} ?y] .... }, then in the
 *   three-tuple :select clause is [?x ?person ?y], where ?person must be expanded with additional query results.
 * 
 *   Given this example, this function would output:
 *   ([1 ['*']]) - which means position 1 in the select clause tuple (0-indexed) needs to be expanded with a
 *   query: {:select ['*'] :from ?person}, for each instance of ?person returned from the query.
 */
fluree.db.query.fql.build_expand_map = (function fluree$db$query$fql$build_expand_map(select,pretty_print_keys){
return cljs.core.keep_indexed.cljs$core$IFn$_invoke$arity$2((function (idx,select_item){
var temp__5753__auto__ = cljs.core.cst$kw$selection.cljs$core$IFn$_invoke$arity$1(select_item);
if(cljs.core.truth_(temp__5753__auto__)){
var query_map = temp__5753__auto__;
var tuple_index = (cljs.core.truth_(pretty_print_keys)?cljs.core.nth.cljs$core$IFn$_invoke$arity$2(pretty_print_keys,idx):idx);
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tuple_index,query_map], null);
} else {
return null;
}
}),select);
});
/**
 * Updates a two-tuple as defined by 'build-expand-map` function by executing the query-map query for
 *   the tuple-result using supplied db and options. Up
 *   [tuple-index query-map] -> [tuple-index query-map-result]
 * 
 *   Returns async channel with the transformed two-tuple, or a query exception if one occurs.
 */
fluree.db.query.fql.expand_map = (function fluree$db$query$fql$expand_map(db,query_opts,tuple_result,p__40312){
var vec__40313 = p__40312;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40313,(0),null);
var query_map = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40313,(1),null);
var temp__5753__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(tuple_result,tuple_index);
if(cljs.core.truth_(temp__5753__auto__)){
var _id = temp__5753__auto__;
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40327){
var state_val_40328 = (state_40327[(1)]);
if((state_val_40328 === (1))){
var inst_40316 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40317 = [cljs.core.cst$kw$selectOne,cljs.core.cst$kw$from,cljs.core.cst$kw$opts];
var inst_40318 = [query_map,_id,query_opts];
var inst_40319 = cljs.core.PersistentHashMap.fromArrays(inst_40317,inst_40318);
var inst_40320 = (fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2 ? fluree.db.query.fql.query.cljs$core$IFn$_invoke$arity$2(db,inst_40319) : fluree.db.query.fql.query.call(null,db,inst_40319));
var state_40327__$1 = (function (){var statearr_40329 = state_40327;
(statearr_40329[(7)] = inst_40316);

return statearr_40329;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40327__$1,(2),inst_40320);
} else {
if((state_val_40328 === (2))){
var inst_40316 = (state_40327[(7)]);
var inst_40322 = (state_40327[(2)]);
var inst_40323 = fluree.db.util.async.throw_err(inst_40322);
var inst_40324 = [tuple_index,inst_40323];
var inst_40325 = (new cljs.core.PersistentVector(null,2,(5),inst_40316,inst_40324,null));
var state_40327__$1 = state_40327;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40327__$1,inst_40325);
} else {
return null;
}
}
});
return (function() {
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0 = (function (){
var statearr_40330 = [null,null,null,null,null,null,null,null];
(statearr_40330[(0)] = fluree$db$query$fql$expand_map_$_state_machine__16395__auto__);

(statearr_40330[(1)] = (1));

return statearr_40330;
});
var fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1 = (function (state_40327){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40327);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40331){var ex__16398__auto__ = e40331;
var statearr_40332_40335 = state_40327;
(statearr_40332_40335[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40327[(4)]))){
var statearr_40333_40336 = state_40327;
(statearr_40333_40336[(1)] = cljs.core.first((state_40327[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40337 = state_40327;
state_40327 = G__40337;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__ = function(state_40327){
switch(arguments.length){
case 0:
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1.call(this,state_40327);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$expand_map_$_state_machine__16395__auto____0;
fluree$db$query$fql$expand_map_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$expand_map_$_state_machine__16395__auto____1;
return fluree$db$query$fql$expand_map_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40334 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40334[(6)] = c__16469__auto__);

return statearr_40334;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
} else {
return null;
}
});
/**
 * Follow-on step for 'expand-map' function above, replaces the final query map
 *   results into the tuple position specified. Designed to be used in a reducing function.
 * 
 *   tuple-result is a single tuple result, like [42 12345 'usa']
 *   expand-map-tuple is a two-tuple of index position to replace in the tuple result
 *   along with the value to replace it with, i.e. [1 {12345 {:firstName 'Jane', :lastName 'Doe'}}]
 *   After replacing position/index 1 in the initial tuple result in this example, the final output
 *   will be the modified tuple result of:
 *   [42 {12345 {:firstName 'Jane', :lastName 'Doe'}} 'usa']
 */
fluree.db.query.fql.replace_expand_maps = (function fluree$db$query$fql$replace_expand_maps(tuple_result,expand_map_tuple){
if(fluree.db.util.core.exception_QMARK_(expand_map_tuple)){
throw expand_map_tuple;
} else {
}

var vec__40338 = expand_map_tuple;
var tuple_index = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40338,(0),null);
var query_map_result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40338,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(tuple_result,tuple_index,query_map_result);
});
/**
 * For each tuple in the results that requires a query map expanded, fetches the
 *   results in parallel with `parallelism` supplied.
 * 
 *   Inputs are:
 *   - select - select specification map
 *   - pp-keys - if prettyPrint was done on the query, the results will be a map instead of a tuple. This lists the map keys
 *   - single-result? - if the query's :select was not wrapped in a vector, we return a single result instead of a tuple
 *   - db - the db to execute the query-map expansion with
 *   - opts - opts to use for the query-map expansion query
 *   - parallelism - how many queries to run in parallel
 *   - tuples-res - final response tuples that need one or more query expansions on them
 * 
 *   i.e. if a simple one-tuple result set were columns [?person], where ?person is just
 *   the subject id of persons... then the tuples would look like
 *   [[1234567] [1234566] [1234565] ...]
 * 
 *   The select clause might be {?person [person/fullName, person/age, {person/children [*]}]}
 * 
 *   This will produce the results of each of the select clauses based on the source tuples.
 */
fluree.db.query.fql.pipeline_expandmaps_result = (function fluree$db$query$fql$pipeline_expandmaps_result(select,pp_keys,single_result_QMARK_,db,fuel,max_fuel,opts,parallelism,tuples_res){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40401){
var state_val_40402 = (state_40401[(1)]);
if((state_val_40402 === (7))){
var inst_40396 = (state_40401[(2)]);
var _ = (function (){var statearr_40403 = state_40401;
(statearr_40403[(4)] = cljs.core.rest((state_40401[(4)])));

return statearr_40403;
})();
var state_40401__$1 = state_40401;
var statearr_40404_40495 = state_40401__$1;
(statearr_40404_40495[(2)] = inst_40396);

(statearr_40404_40495[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (20))){
var inst_40387 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
var statearr_40405_40496 = state_40401__$1;
(statearr_40405_40496[(2)] = inst_40387);

(statearr_40405_40496[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (1))){
var state_40401__$1 = state_40401;
var statearr_40406_40497 = state_40401__$1;
(statearr_40406_40497[(2)] = null);

(statearr_40406_40497[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (4))){
var inst_40343 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
var statearr_40407_40498 = state_40401__$1;
(statearr_40407_40498[(2)] = inst_40343);

(statearr_40407_40498[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (15))){
var inst_40363 = (state_40401[(7)]);
var inst_40372 = cljs.core.second(inst_40363);
var inst_40373 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,inst_40372);
var inst_40374 = (inst_40373 > max_fuel);
var state_40401__$1 = state_40401;
if(cljs.core.truth_(inst_40374)){
var statearr_40408_40499 = state_40401__$1;
(statearr_40408_40499[(1)] = (18));

} else {
var statearr_40409_40500 = state_40401__$1;
(statearr_40409_40500[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (13))){
var state_40401__$1 = state_40401;
var statearr_40410_40501 = state_40401__$1;
(statearr_40410_40501[(1)] = (15));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (6))){
var inst_40351 = (state_40401[(8)]);
var state_40401__$1 = state_40401;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40401__$1,(8),inst_40351);
} else {
if((state_val_40402 === (17))){
var inst_40390 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
var statearr_40412_40502 = state_40401__$1;
(statearr_40412_40502[(2)] = inst_40390);

(statearr_40412_40502[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (3))){
var inst_40399 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40401__$1,inst_40399);
} else {
if((state_val_40402 === (12))){
var inst_40352 = (state_40401[(9)]);
var inst_40363 = (state_40401[(7)]);
var inst_40369 = (inst_40352.cljs$core$IFn$_invoke$arity$0 ? inst_40352.cljs$core$IFn$_invoke$arity$0() : inst_40352.call(null));
var state_40401__$1 = (function (){var statearr_40413 = state_40401;
(statearr_40413[(10)] = inst_40369);

return statearr_40413;
})();
var statearr_40414_40503 = state_40401__$1;
(statearr_40414_40503[(2)] = inst_40363);

(statearr_40414_40503[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (2))){
var inst_40352 = (state_40401[(9)]);
var inst_40351 = (state_40401[(8)]);
var _ = (function (){var statearr_40415 = state_40401;
(statearr_40415[(4)] = cljs.core.cons((5),(state_40401[(4)])));

return statearr_40415;
})();
var inst_40349 = fluree.db.query.fql.build_expand_map(select,pp_keys);
var inst_40350 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_40351__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_40352__$1 = (function (){var expandMaps = inst_40349;
var queue_ch = inst_40350;
var res_ch = inst_40351__$1;
return (function (){
cljs.core.async.close_BANG_(queue_ch);

return cljs.core.async.close_BANG_(res_ch);
});
})();
var inst_40353 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$limit,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$groupBy], 0));
var inst_40354 = cljs.core.volatile_BANG_((0));
var inst_40355 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40353,cljs.core.cst$kw$fuel,inst_40354);
var inst_40356 = (function (){var expandMaps = inst_40349;
var queue_ch = inst_40350;
var res_ch = inst_40351__$1;
var stop_BANG_ = inst_40352__$1;
var opts_STAR_ = inst_40355;
return (function (tuple_res,port){
var c__16469__auto____$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40448){
var state_val_40449 = (state_40448[(1)]);
if((state_val_40449 === (7))){
var state_40448__$1 = state_40448;
var statearr_40450_40504 = state_40448__$1;
(statearr_40450_40504[(2)] = tuple_res);

(statearr_40450_40504[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (1))){
var state_40448__$1 = state_40448;
var statearr_40451_40505 = state_40448__$1;
(statearr_40451_40505[(2)] = null);

(statearr_40451_40505[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (4))){
var inst_40416 = (state_40448[(2)]);
var inst_40417 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_40416);
var inst_40418 = cljs.core.async.close_BANG_(port);
var state_40448__$1 = (function (){var statearr_40452 = state_40448;
(statearr_40452[(7)] = inst_40417);

return statearr_40452;
})();
var statearr_40453_40506 = state_40448__$1;
(statearr_40453_40506[(2)] = inst_40418);

(statearr_40453_40506[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (6))){
var inst_40425 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40426 = [tuple_res];
var inst_40427 = (new cljs.core.PersistentVector(null,1,(5),inst_40425,inst_40426,null));
var state_40448__$1 = state_40448;
var statearr_40454_40507 = state_40448__$1;
(statearr_40454_40507[(2)] = inst_40427);

(statearr_40454_40507[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (3))){
var inst_40446 = (state_40448[(2)]);
var state_40448__$1 = state_40448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40448__$1,inst_40446);
} else {
if((state_val_40449 === (2))){
var ___$1 = (function (){var statearr_40456 = state_40448;
(statearr_40456[(4)] = cljs.core.cons((5),(state_40448[(4)])));

return statearr_40456;
})();
var state_40448__$1 = state_40448;
if(cljs.core.truth_(single_result_QMARK_)){
var statearr_40457_40508 = state_40448__$1;
(statearr_40457_40508[(1)] = (6));

} else {
var statearr_40458_40509 = state_40448__$1;
(statearr_40458_40509[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (9))){
var inst_40430 = (state_40448[(8)]);
var inst_40432 = (state_40448[(9)]);
var inst_40439 = (state_40448[(2)]);
var inst_40440 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.replace_expand_maps,inst_40430,inst_40439);
var inst_40441 = (inst_40432.cljs$core$IFn$_invoke$arity$1 ? inst_40432.cljs$core$IFn$_invoke$arity$1(inst_40440) : inst_40432.call(null,inst_40440));
var inst_40442 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(port,inst_40441);
var inst_40443 = cljs.core.async.close_BANG_(port);
var ___$1 = (function (){var statearr_40459 = state_40448;
(statearr_40459[(4)] = cljs.core.rest((state_40448[(4)])));

return statearr_40459;
})();
var state_40448__$1 = (function (){var statearr_40460 = state_40448;
(statearr_40460[(10)] = inst_40442);

return statearr_40460;
})();
var statearr_40461_40510 = state_40448__$1;
(statearr_40461_40510[(2)] = inst_40443);

(statearr_40461_40510[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (5))){
var ___$1 = (function (){var statearr_40462 = state_40448;
(statearr_40462[(4)] = cljs.core.rest((state_40448[(4)])));

return statearr_40462;
})();
var state_40448__$1 = state_40448;
var ex40455 = (state_40448__$1[(2)]);
var statearr_40463_40511 = state_40448__$1;
(statearr_40463_40511[(5)] = ex40455);


var statearr_40464_40512 = state_40448__$1;
(statearr_40464_40512[(1)] = (4));

(statearr_40464_40512[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_40449 === (8))){
var inst_40430 = (state_40448[(8)]);
var inst_40430__$1 = (state_40448[(2)]);
var inst_40431 = cljs.core.volatile_BANG_((0));
var inst_40432 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40430__$1;
var query_fuel = inst_40431;
return (function (p1__40342_SHARP_){
if(cljs.core.truth_(single_result_QMARK_)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.first(p1__40342_SHARP_),cljs.core.deref(query_fuel)], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__40342_SHARP_,cljs.core.deref(query_fuel)], null);
}
});
})();
var inst_40433 = cljs.core.PersistentVector.EMPTY;
var inst_40434 = (function (){var tuple_res_SINGLEQUOTE_ = inst_40430__$1;
var query_fuel = inst_40431;
return (function (p1__40341_SHARP_){
return fluree.db.query.fql.expand_map(db,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts_STAR_,cljs.core.cst$kw$fuel,fuel),tuple_res_SINGLEQUOTE_,p1__40341_SHARP_);
});
})();
var inst_40435 = cljs.core.keep.cljs$core$IFn$_invoke$arity$2(inst_40434,expandMaps);
var inst_40436 = cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1(inst_40435);
var inst_40437 = cljs.core.async.into(inst_40433,inst_40436);
var state_40448__$1 = (function (){var statearr_40465 = state_40448;
(statearr_40465[(8)] = inst_40430__$1);

(statearr_40465[(9)] = inst_40432);

return statearr_40465;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40448__$1,(9),inst_40437);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0 = (function (){
var statearr_40466 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_40466[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__);

(statearr_40466[(1)] = (1));

return statearr_40466;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1 = (function (state_40448){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40448);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40467){var ex__16398__auto__ = e40467;
var statearr_40468_40513 = state_40448;
(statearr_40468_40513[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40448[(4)]))){
var statearr_40469_40514 = state_40448;
(statearr_40469_40514[(1)] = cljs.core.first((state_40448[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40515 = state_40448;
state_40448 = G__40515;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = function(state_40448){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1.call(this,state_40448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40470 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40470[(6)] = c__16469__auto____$1);

return statearr_40470;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto____$1;
});
})();
var inst_40357 = cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(inst_40350,tuples_res);
var inst_40358 = cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4(parallelism,inst_40351__$1,inst_40356,inst_40350);
var inst_40359 = cljs.core.PersistentVector.EMPTY;
var inst_40360 = inst_40359;
var state_40401__$1 = (function (){var statearr_40471 = state_40401;
(statearr_40471[(11)] = inst_40358);

(statearr_40471[(12)] = inst_40360);

(statearr_40471[(13)] = inst_40357);

(statearr_40471[(9)] = inst_40352__$1);

(statearr_40471[(8)] = inst_40351__$1);

return statearr_40471;
})();
var statearr_40472_40516 = state_40401__$1;
(statearr_40472_40516[(2)] = null);

(statearr_40472_40516[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (19))){
var inst_40360 = (state_40401[(12)]);
var inst_40363 = (state_40401[(7)]);
var inst_40383 = cljs.core.first(inst_40363);
var inst_40384 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40360,inst_40383);
var inst_40360__$1 = inst_40384;
var state_40401__$1 = (function (){var statearr_40473 = state_40401;
(statearr_40473[(12)] = inst_40360__$1);

return statearr_40473;
})();
var statearr_40474_40517 = state_40401__$1;
(statearr_40474_40517[(2)] = null);

(statearr_40474_40517[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (11))){
var inst_40394 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
var statearr_40476_40518 = state_40401__$1;
(statearr_40476_40518[(2)] = inst_40394);

(statearr_40476_40518[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (9))){
var inst_40360 = (state_40401[(12)]);
var state_40401__$1 = state_40401;
var statearr_40477_40519 = state_40401__$1;
(statearr_40477_40519[(2)] = inst_40360);

(statearr_40477_40519[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (5))){
var _ = (function (){var statearr_40478 = state_40401;
(statearr_40478[(4)] = cljs.core.rest((state_40401[(4)])));

return statearr_40478;
})();
var state_40401__$1 = state_40401;
var ex40475 = (state_40401__$1[(2)]);
var statearr_40479_40520 = state_40401__$1;
(statearr_40479_40520[(5)] = ex40475);


if((ex40475 instanceof Error)){
var statearr_40480_40521 = state_40401__$1;
(statearr_40480_40521[(1)] = (4));

(statearr_40480_40521[(5)] = null);

} else {
throw ex40475;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (14))){
var inst_40392 = (state_40401[(2)]);
var state_40401__$1 = state_40401;
var statearr_40481_40522 = state_40401__$1;
(statearr_40481_40522[(2)] = inst_40392);

(statearr_40481_40522[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (16))){
var state_40401__$1 = state_40401;
var statearr_40482_40523 = state_40401__$1;
(statearr_40482_40523[(2)] = null);

(statearr_40482_40523[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (10))){
var inst_40363 = (state_40401[(7)]);
var inst_40367 = fluree.db.util.core.exception_QMARK_(inst_40363);
var state_40401__$1 = state_40401;
if(inst_40367){
var statearr_40483_40524 = state_40401__$1;
(statearr_40483_40524[(1)] = (12));

} else {
var statearr_40484_40525 = state_40401__$1;
(statearr_40484_40525[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (18))){
var inst_40352 = (state_40401[(9)]);
var inst_40376 = (inst_40352.cljs$core$IFn$_invoke$arity$0 ? inst_40352.cljs$core$IFn$_invoke$arity$0() : inst_40352.call(null));
var inst_40377 = ["Query exceeded max fuel while processing: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel),". If you have permission, you can set the max fuel for a query with: 'opts': {'fuel' 10000000}"].join('');
var inst_40378 = [cljs.core.cst$kw$error,cljs.core.cst$kw$status];
var inst_40379 = [cljs.core.cst$kw$db_SLASH_insufficient_DASH_fuel,(400)];
var inst_40380 = cljs.core.PersistentHashMap.fromArrays(inst_40378,inst_40379);
var inst_40381 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_40377,inst_40380);
var state_40401__$1 = (function (){var statearr_40485 = state_40401;
(statearr_40485[(14)] = inst_40376);

return statearr_40485;
})();
var statearr_40486_40526 = state_40401__$1;
(statearr_40486_40526[(2)] = inst_40381);

(statearr_40486_40526[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40402 === (8))){
var inst_40363 = (state_40401[(7)]);
var inst_40363__$1 = (state_40401[(2)]);
var inst_40364 = (inst_40363__$1 == null);
var state_40401__$1 = (function (){var statearr_40487 = state_40401;
(statearr_40487[(7)] = inst_40363__$1);

return statearr_40487;
})();
if(cljs.core.truth_(inst_40364)){
var statearr_40488_40527 = state_40401__$1;
(statearr_40488_40527[(1)] = (9));

} else {
var statearr_40489_40528 = state_40401__$1;
(statearr_40489_40528[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0 = (function (){
var statearr_40490 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40490[(0)] = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__);

(statearr_40490[(1)] = (1));

return statearr_40490;
});
var fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1 = (function (state_40401){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40401);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40491){var ex__16398__auto__ = e40491;
var statearr_40492_40529 = state_40401;
(statearr_40492_40529[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40401[(4)]))){
var statearr_40493_40530 = state_40401;
(statearr_40493_40530[(1)] = cljs.core.first((state_40401[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40531 = state_40401;
state_40401 = G__40531;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__ = function(state_40401){
switch(arguments.length){
case 0:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1.call(this,state_40401);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____0;
fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto____1;
return fluree$db$query$fql$pipeline_expandmaps_result_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40494 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40494[(6)] = c__16469__auto__);

return statearr_40494;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Builds function that returns tuple result based on the :select portion of the original query
 *   when provided the list of tuples that result from the :where portion of the original query.
 */
fluree.db.query.fql.select_fn = (function fluree$db$query$fql$select_fn(headers,vars,select){
var map__40532 = select;
var map__40532__$1 = cljs.core.__destructure_map(map__40532);
var as = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40532__$1,cljs.core.cst$kw$as);
var variable = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40532__$1,cljs.core.cst$kw$variable);
var value = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40532__$1,cljs.core.cst$kw$value);
var select_val = (function (){var or__4212__auto__ = as;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return variable;
}
})();
var idx = fluree.db.query.fql.get_header_idx(headers,select);
var tuple_select = (cljs.core.truth_(value)?cljs.core.constantly(value):(cljs.core.truth_(idx)?(function (tuple){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,idx);
}):(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val))?cljs.core.constantly(cljs.core.get.cljs$core$IFn$_invoke$arity$2(vars,select_val)):null)));
return tuple_select;
});
/**
 * Returns a single function, that when applied against a full result tuple from
 *   the query's :where clause, preps the :select clause response with just the values
 *   in the specified order.
 * 
 *   The :where result tuples will contain a column/tuple index for every variable
 *   that appears in the where clause, but the :select clause specifies which of those
 *   variables to return in the result - which is often a subset.
 * 
 *   Here, the 'headers' will contain the where clause variables and what column/index
 *   they are in, and the 'select' will specify the select variables desired, and order.
 */
fluree.db.query.fql.select_tuples_fn = (function fluree$db$query$fql$select_tuples_fn(headers,vars,select){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.juxt,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.partial.cljs$core$IFn$_invoke$arity$3(fluree.db.query.fql.select_fn,headers,vars),select));
});
/**
 * Sorts result tuples when orderBy is specified.
 * Order By can be:
 * - Single variable, ?favNums
 * - Two-tuple,  [ASC, ?favNums]
 * - Three-tuple, [ASC, ?favNums, 'NOCASE'] - ignore case when sorting strings
 * 
 *   Operation should happen before tuples get filtered, as the orderBy variable might
 *   not be present in the :select clause.
 * 
 *   2 fuel per tuple ordered + 2 additional fuel for 'NOCASE'.
 */
fluree.db.query.fql.order_result_tuples = (function fluree$db$query$fql$order_result_tuples(fuel,max_fuel,headers,orderBy,tuples){
var vec__40535 = orderBy;
var order = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40535,(0),null);
var var$ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40535,(1),null);
var option = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40535,(2),null);
var comparator = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",order))?(function (a,b){
return cljs.core.compare(b,a);
}):cljs.core.compare);
var compare_idx = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(var$));
var no_case_QMARK_ = ((typeof option === 'string') && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("NOCASE",clojure.string.upper_case(option))));
var keyfn = ((no_case_QMARK_)?(function (p1__40533_SHARP_){
return clojure.string.upper_case(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40533_SHARP_,compare_idx));
}):(function (p1__40534_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(p1__40534_SHARP_,compare_idx);
}));
if(cljs.core.truth_(compare_idx)){
var fuel_total = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$3(fuel,cljs.core._PLUS_,(((no_case_QMARK_)?(4):(2)) * cljs.core.count(tuples)));
if((fuel_total > max_fuel)){
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Maximum query cost of ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(max_fuel)," exceeded."].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_exceeded_DASH_cost], null));
} else {
}

return cljs.core.sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,comparator,tuples);
} else {
return tuples;
}
});
fluree.db.query.fql.process_ad_hoc_group = (function fluree$db$query$fql$process_ad_hoc_group(var_args){
var G__40540 = arguments.length;
switch (G__40540) {
case 6:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6 = (function (db,fuel,max_fuel,res,select_spec,opts){
return fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,null,opts);
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7 = (function (db,fuel,max_fuel,p__40541,p__40542,group_limit,opts){
var map__40543 = p__40541;
var map__40543__$1 = cljs.core.__destructure_map(map__40543);
var res = map__40543__$1;
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40543__$1,cljs.core.cst$kw$vars);
var map__40544 = p__40542;
var map__40544__$1 = cljs.core.__destructure_map(map__40544);
var select_spec = map__40544__$1;
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$inVector_QMARK_);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$orderBy);
var expandMaps_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$expandMaps_QMARK_);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$offset);
var aggregates = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$aggregates);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$prettyPrint);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40544__$1,cljs.core.cst$kw$groupBy);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_40681){
var state_val_40682 = (state_40681[(1)]);
if((state_val_40682 === (7))){
var inst_40551 = (state_40681[(7)]);
var state_40681__$1 = state_40681;
var statearr_40683_40785 = state_40681__$1;
(statearr_40683_40785[(2)] = inst_40551);

(statearr_40683_40785[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (59))){
var inst_40674 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
var statearr_40684_40786 = state_40681__$1;
(statearr_40684_40786[(2)] = inst_40674);

(statearr_40684_40786[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (20))){
var inst_40587 = (state_40681[(8)]);
var inst_40590 = (state_40681[(9)]);
var inst_40586 = (state_40681[(2)]);
var inst_40587__$1 = cljs.core.__destructure_map(inst_40586);
var inst_40588 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40587__$1,cljs.core.cst$kw$headers);
var inst_40589 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_40587__$1,cljs.core.cst$kw$tuples);
var inst_40590__$1 = offset;
var state_40681__$1 = (function (){var statearr_40685 = state_40681;
(statearr_40685[(8)] = inst_40587__$1);

(statearr_40685[(9)] = inst_40590__$1);

(statearr_40685[(10)] = inst_40589);

(statearr_40685[(11)] = inst_40588);

return statearr_40685;
})();
if(cljs.core.truth_(inst_40590__$1)){
var statearr_40686_40787 = state_40681__$1;
(statearr_40686_40787[(1)] = (21));

} else {
var statearr_40687_40788 = state_40681__$1;
(statearr_40687_40788[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (58))){
var inst_40666 = (state_40681[(12)]);
var state_40681__$1 = state_40681;
var statearr_40688_40789 = state_40681__$1;
(statearr_40688_40789[(2)] = inst_40666);

(statearr_40688_40789[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (60))){
var inst_40670 = (state_40681[(2)]);
var inst_40671 = fluree.db.util.async.throw_err(inst_40670);
var state_40681__$1 = state_40681;
var statearr_40689_40790 = state_40681__$1;
(statearr_40689_40790[(2)] = inst_40671);

(statearr_40689_40790[(1)] = (59));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (27))){
var inst_40602 = cljs.core.not(inVector_QMARK_);
var state_40681__$1 = state_40681;
var statearr_40690_40791 = state_40681__$1;
(statearr_40690_40791[(2)] = inst_40602);

(statearr_40690_40791[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (1))){
var state_40681__$1 = state_40681;
var statearr_40691_40792 = state_40681__$1;
(statearr_40691_40792[(2)] = null);

(statearr_40691_40792[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (24))){
var state_40681__$1 = state_40681;
var statearr_40692_40793 = state_40681__$1;
(statearr_40692_40793[(2)] = offset);

(statearr_40692_40793[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (55))){
var inst_40660 = (state_40681[(13)]);
var state_40681__$1 = state_40681;
var statearr_40693_40794 = state_40681__$1;
(statearr_40693_40794[(2)] = inst_40660);

(statearr_40693_40794[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (39))){
var inst_40628 = (state_40681[(14)]);
var inst_40630 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_40631 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40628,inst_40630);
var state_40681__$1 = state_40681;
var statearr_40694_40795 = state_40681__$1;
(statearr_40694_40795[(2)] = inst_40631);

(statearr_40694_40795[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (46))){
var inst_40640 = (state_40681[(15)]);
var state_40681__$1 = state_40681;
var statearr_40695_40796 = state_40681__$1;
(statearr_40695_40796[(2)] = inst_40640);

(statearr_40695_40796[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (4))){
var inst_40545 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
var statearr_40696_40797 = state_40681__$1;
(statearr_40696_40797[(2)] = inst_40545);

(statearr_40696_40797[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (54))){
var inst_40654 = (state_40681[(16)]);
var inst_40660 = (state_40681[(13)]);
var inst_40662 = cljs.core.PersistentVector.EMPTY;
var inst_40663 = cljs.core.into.cljs$core$IFn$_invoke$arity$3(inst_40662,inst_40654,inst_40660);
var state_40681__$1 = state_40681;
var statearr_40697_40798 = state_40681__$1;
(statearr_40697_40798[(2)] = inst_40663);

(statearr_40697_40798[(1)] = (56));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (15))){
var inst_40572 = (state_40681[(17)]);
var inst_40574 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40575 = [inst_40572];
var inst_40576 = (new cljs.core.PersistentVector(null,1,(5),inst_40574,inst_40575,null));
var state_40681__$1 = state_40681;
var statearr_40698_40799 = state_40681__$1;
(statearr_40698_40799[(2)] = inst_40576);

(statearr_40698_40799[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (48))){
var inst_40587 = (state_40681[(8)]);
var inst_40599 = (state_40681[(18)]);
var inst_40646 = (state_40681[(19)]);
var inst_40589 = (state_40681[(10)]);
var inst_40588 = (state_40681[(11)]);
var inst_40610 = (state_40681[(20)]);
var inst_40605 = (state_40681[(21)]);
var inst_40648 = (function (){var map__40581 = inst_40587;
var headers = inst_40588;
var tuples = inst_40589;
var offset_SINGLEQUOTE_ = inst_40599;
var single_result_QMARK_ = inst_40605;
var pp_keys = inst_40610;
var G__40611 = inst_40646;
return (function (p1__40538_SHARP_){
return cljs.core.zipmap(fluree.db.query.fql.get_pretty_print_keys(select),p1__40538_SHARP_);
});
})();
var inst_40649 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40648);
var inst_40650 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40646,inst_40649);
var state_40681__$1 = state_40681;
var statearr_40699_40800 = state_40681__$1;
(statearr_40699_40800[(2)] = inst_40650);

(statearr_40699_40800[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (50))){
var inst_40653 = (state_40681[(2)]);
var inst_40654 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.comp,inst_40653);
var state_40681__$1 = (function (){var statearr_40700 = state_40681;
(statearr_40700[(16)] = inst_40654);

return statearr_40700;
})();
if(cljs.core.truth_(orderBy)){
var statearr_40701_40801 = state_40681__$1;
(statearr_40701_40801[(1)] = (51));

} else {
var statearr_40702_40802 = state_40681__$1;
(statearr_40702_40802[(1)] = (52));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (21))){
var inst_40592 = cljs.core.not(groupBy);
var state_40681__$1 = state_40681;
var statearr_40703_40803 = state_40681__$1;
(statearr_40703_40803[(2)] = inst_40592);

(statearr_40703_40803[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (31))){
var state_40681__$1 = state_40681;
var statearr_40704_40804 = state_40681__$1;
(statearr_40704_40804[(2)] = null);

(statearr_40704_40804[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (32))){
var inst_40588 = (state_40681[(11)]);
var inst_40605 = (state_40681[(21)]);
var inst_40610 = (state_40681[(2)]);
var inst_40612 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_40613 = fluree.db.query.fql.select_tuples_fn(inst_40588,vars,select);
var inst_40614 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(inst_40613);
var inst_40615 = [inst_40614];
var inst_40616 = (new cljs.core.PersistentVector(null,1,(5),inst_40612,inst_40615,null));
var state_40681__$1 = (function (){var statearr_40705 = state_40681;
(statearr_40705[(22)] = inst_40616);

(statearr_40705[(20)] = inst_40610);

return statearr_40705;
})();
if(cljs.core.truth_(inst_40605)){
var statearr_40706_40805 = state_40681__$1;
(statearr_40706_40805[(1)] = (33));

} else {
var statearr_40707_40806 = state_40681__$1;
(statearr_40707_40806[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (40))){
var inst_40628 = (state_40681[(14)]);
var state_40681__$1 = state_40681;
var statearr_40708_40807 = state_40681__$1;
(statearr_40708_40807[(2)] = inst_40628);

(statearr_40708_40807[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (56))){
var inst_40666 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40709 = state_40681;
(statearr_40709[(12)] = inst_40666);

return statearr_40709;
})();
if(cljs.core.truth_(expandMaps_QMARK_)){
var statearr_40710_40808 = state_40681__$1;
(statearr_40710_40808[(1)] = (57));

} else {
var statearr_40711_40809 = state_40681__$1;
(statearr_40711_40809[(1)] = (58));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (33))){
var inst_40616 = (state_40681[(22)]);
var inst_40618 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(cljs.core.first);
var inst_40619 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40616,inst_40618);
var state_40681__$1 = state_40681;
var statearr_40712_40810 = state_40681__$1;
(statearr_40712_40810[(2)] = inst_40619);

(statearr_40712_40810[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (13))){
var inst_40561 = (state_40681[(23)]);
var state_40681__$1 = state_40681;
var statearr_40713_40811 = state_40681__$1;
(statearr_40713_40811[(2)] = inst_40561);

(statearr_40713_40811[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (22))){
var inst_40590 = (state_40681[(9)]);
var state_40681__$1 = state_40681;
var statearr_40714_40812 = state_40681__$1;
(statearr_40714_40812[(2)] = inst_40590);

(statearr_40714_40812[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (36))){
var inst_40622 = (state_40681[(24)]);
var inst_40624 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$3(fuel,max_fuel,(5));
var inst_40625 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40622,inst_40624);
var state_40681__$1 = state_40681;
var statearr_40715_40813 = state_40681__$1;
(statearr_40715_40813[(2)] = inst_40625);

(statearr_40715_40813[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (41))){
var inst_40599 = (state_40681[(18)]);
var inst_40634 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40716 = state_40681;
(statearr_40716[(25)] = inst_40634);

return statearr_40716;
})();
if(cljs.core.truth_(inst_40599)){
var statearr_40717_40814 = state_40681__$1;
(statearr_40717_40814[(1)] = (42));

} else {
var statearr_40718_40815 = state_40681__$1;
(statearr_40718_40815[(1)] = (43));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (43))){
var inst_40634 = (state_40681[(25)]);
var state_40681__$1 = state_40681;
var statearr_40719_40816 = state_40681__$1;
(statearr_40719_40816[(2)] = inst_40634);

(statearr_40719_40816[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (29))){
var inst_40605 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40720 = state_40681;
(statearr_40720[(21)] = inst_40605);

return statearr_40720;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40721_40817 = state_40681__$1;
(statearr_40721_40817[(1)] = (30));

} else {
var statearr_40722_40818 = state_40681__$1;
(statearr_40722_40818[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (44))){
var inst_40640 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40723 = state_40681;
(statearr_40723[(15)] = inst_40640);

return statearr_40723;
})();
if(cljs.core.truth_(group_limit)){
var statearr_40724_40819 = state_40681__$1;
(statearr_40724_40819[(1)] = (45));

} else {
var statearr_40725_40820 = state_40681__$1;
(statearr_40725_40820[(1)] = (46));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (6))){
var inst_40553 = cljs.core.count(select);
var inst_40554 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((1),inst_40553);
var state_40681__$1 = state_40681;
var statearr_40726_40821 = state_40681__$1;
(statearr_40726_40821[(2)] = inst_40554);

(statearr_40726_40821[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (28))){
var inst_40600 = (state_40681[(26)]);
var state_40681__$1 = state_40681;
var statearr_40727_40822 = state_40681__$1;
(statearr_40727_40822[(2)] = inst_40600);

(statearr_40727_40822[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (51))){
var inst_40589 = (state_40681[(10)]);
var inst_40588 = (state_40681[(11)]);
var inst_40657 = fluree.db.query.fql.order_result_tuples(fuel,max_fuel,inst_40588,orderBy,inst_40589);
var state_40681__$1 = state_40681;
var statearr_40728_40823 = state_40681__$1;
(statearr_40728_40823[(2)] = inst_40657);

(statearr_40728_40823[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (25))){
var state_40681__$1 = state_40681;
var statearr_40729_40824 = state_40681__$1;
(statearr_40729_40824[(2)] = null);

(statearr_40729_40824[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (34))){
var inst_40616 = (state_40681[(22)]);
var state_40681__$1 = state_40681;
var statearr_40730_40825 = state_40681__$1;
(statearr_40730_40825[(2)] = inst_40616);

(statearr_40730_40825[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (17))){
var inst_40579 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
var statearr_40731_40826 = state_40681__$1;
(statearr_40731_40826[(2)] = inst_40579);

(statearr_40731_40826[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (3))){
var inst_40679 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
return cljs.core.async.impl.ioc_helpers.return_chan(state_40681__$1,inst_40679);
} else {
if((state_val_40682 === (12))){
var inst_40561 = (state_40681[(23)]);
var inst_40563 = cljs.core.first(select);
var inst_40564 = cljs.core.cst$kw$as.cljs$core$IFn$_invoke$arity$1(inst_40563);
var inst_40565 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_40564);
var inst_40566 = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(inst_40565,(1));
var inst_40567 = [inst_40566];
var inst_40568 = [inst_40561];
var inst_40569 = cljs.core.PersistentHashMap.fromArrays(inst_40567,inst_40568);
var state_40681__$1 = state_40681;
var statearr_40732_40827 = state_40681__$1;
(statearr_40732_40827[(2)] = inst_40569);

(statearr_40732_40827[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (2))){
var inst_40551 = (state_40681[(7)]);
var _ = (function (){var statearr_40733 = state_40681;
(statearr_40733[(4)] = cljs.core.cons((5),(state_40681[(4)])));

return statearr_40733;
})();
var inst_40551__$1 = aggregates;
var state_40681__$1 = (function (){var statearr_40734 = state_40681;
(statearr_40734[(7)] = inst_40551__$1);

return statearr_40734;
})();
if(cljs.core.truth_(inst_40551__$1)){
var statearr_40735_40828 = state_40681__$1;
(statearr_40735_40828[(1)] = (6));

} else {
var statearr_40736_40829 = state_40681__$1;
(statearr_40736_40829[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (23))){
var inst_40595 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
if(cljs.core.truth_(inst_40595)){
var statearr_40737_40830 = state_40681__$1;
(statearr_40737_40830[(1)] = (24));

} else {
var statearr_40738_40831 = state_40681__$1;
(statearr_40738_40831[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (47))){
var inst_40646 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40739 = state_40681;
(statearr_40739[(19)] = inst_40646);

return statearr_40739;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40740_40832 = state_40681__$1;
(statearr_40740_40832[(1)] = (48));

} else {
var statearr_40741_40833 = state_40681__$1;
(statearr_40741_40833[(1)] = (49));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (35))){
var inst_40622 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40742 = state_40681;
(statearr_40742[(24)] = inst_40622);

return statearr_40742;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40743_40834 = state_40681__$1;
(statearr_40743_40834[(1)] = (36));

} else {
var statearr_40744_40835 = state_40681__$1;
(statearr_40744_40835[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (19))){
var state_40681__$1 = state_40681;
var statearr_40745_40836 = state_40681__$1;
(statearr_40745_40836[(2)] = res);

(statearr_40745_40836[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (57))){
var inst_40666 = (state_40681[(12)]);
var inst_40610 = (state_40681[(20)]);
var inst_40605 = (state_40681[(21)]);
var inst_40668 = fluree.db.query.fql.pipeline_expandmaps_result(select,inst_40610,inst_40605,db,fuel,max_fuel,opts,(8),inst_40666);
var state_40681__$1 = state_40681;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_40681__$1,(60),inst_40668);
} else {
if((state_val_40682 === (11))){
var inst_40676 = (state_40681[(2)]);
var _ = (function (){var statearr_40747 = state_40681;
(statearr_40747[(4)] = cljs.core.rest((state_40681[(4)])));

return statearr_40747;
})();
var state_40681__$1 = state_40681;
var statearr_40748_40837 = state_40681__$1;
(statearr_40748_40837[(2)] = inst_40676);

(statearr_40748_40837[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (9))){
var inst_40559 = cljs.core.first(aggregates);
var inst_40560 = fluree.db.query.analytical.calculate_aggregate(res,inst_40559);
var inst_40561 = cljs.core.second(inst_40560);
var state_40681__$1 = (function (){var statearr_40749 = state_40681;
(statearr_40749[(23)] = inst_40561);

return statearr_40749;
})();
if(cljs.core.truth_(prettyPrint)){
var statearr_40750_40838 = state_40681__$1;
(statearr_40750_40838[(1)] = (12));

} else {
var statearr_40751_40839 = state_40681__$1;
(statearr_40751_40839[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (5))){
var _ = (function (){var statearr_40752 = state_40681;
(statearr_40752[(4)] = cljs.core.rest((state_40681[(4)])));

return statearr_40752;
})();
var state_40681__$1 = state_40681;
var ex40746 = (state_40681__$1[(2)]);
var statearr_40753_40840 = state_40681__$1;
(statearr_40753_40840[(5)] = ex40746);


if((ex40746 instanceof Error)){
var statearr_40754_40841 = state_40681__$1;
(statearr_40754_40841[(1)] = (4));

(statearr_40754_40841[(5)] = null);

} else {
throw ex40746;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (14))){
var inst_40572 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40755 = state_40681;
(statearr_40755[(17)] = inst_40572);

return statearr_40755;
})();
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_40756_40842 = state_40681__$1;
(statearr_40756_40842[(1)] = (15));

} else {
var statearr_40757_40843 = state_40681__$1;
(statearr_40757_40843[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (45))){
var inst_40640 = (state_40681[(15)]);
var inst_40642 = cljs.core.take.cljs$core$IFn$_invoke$arity$1(group_limit);
var inst_40643 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40640,inst_40642);
var state_40681__$1 = state_40681;
var statearr_40758_40844 = state_40681__$1;
(statearr_40758_40844[(2)] = inst_40643);

(statearr_40758_40844[(1)] = (47));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (53))){
var inst_40660 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40759 = state_40681;
(statearr_40759[(13)] = inst_40660);

return statearr_40759;
})();
var statearr_40760_40845 = state_40681__$1;
(statearr_40760_40845[(1)] = (54));



return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (26))){
var inst_40600 = (state_40681[(26)]);
var inst_40599 = (state_40681[(2)]);
var inst_40600__$1 = cljs.core.not(prettyPrint);
var state_40681__$1 = (function (){var statearr_40762 = state_40681;
(statearr_40762[(18)] = inst_40599);

(statearr_40762[(26)] = inst_40600__$1);

return statearr_40762;
})();
if(inst_40600__$1){
var statearr_40763_40846 = state_40681__$1;
(statearr_40763_40846[(1)] = (27));

} else {
var statearr_40764_40847 = state_40681__$1;
(statearr_40764_40847[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (16))){
var inst_40572 = (state_40681[(17)]);
var state_40681__$1 = state_40681;
var statearr_40765_40848 = state_40681__$1;
(statearr_40765_40848[(2)] = inst_40572);

(statearr_40765_40848[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (38))){
var inst_40628 = (state_40681[(2)]);
var state_40681__$1 = (function (){var statearr_40766 = state_40681;
(statearr_40766[(14)] = inst_40628);

return statearr_40766;
})();
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_40767_40849 = state_40681__$1;
(statearr_40767_40849[(1)] = (39));

} else {
var statearr_40768_40850 = state_40681__$1;
(statearr_40768_40850[(1)] = (40));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (30))){
var inst_40607 = fluree.db.query.fql.get_pretty_print_keys(select);
var state_40681__$1 = state_40681;
var statearr_40769_40851 = state_40681__$1;
(statearr_40769_40851[(2)] = inst_40607);

(statearr_40769_40851[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (10))){
var state_40681__$1 = state_40681;
if(cljs.core.truth_(aggregates)){
var statearr_40770_40852 = state_40681__$1;
(statearr_40770_40852[(1)] = (18));

} else {
var statearr_40771_40853 = state_40681__$1;
(statearr_40771_40853[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (18))){
var inst_40583 = fluree.db.query.analytical.add_aggregate_cols(res,aggregates);
var state_40681__$1 = state_40681;
var statearr_40772_40854 = state_40681__$1;
(statearr_40772_40854[(2)] = inst_40583);

(statearr_40772_40854[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (52))){
var inst_40589 = (state_40681[(10)]);
var state_40681__$1 = state_40681;
var statearr_40773_40855 = state_40681__$1;
(statearr_40773_40855[(2)] = inst_40589);

(statearr_40773_40855[(1)] = (53));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (42))){
var inst_40599 = (state_40681[(18)]);
var inst_40634 = (state_40681[(25)]);
var inst_40636 = cljs.core.drop.cljs$core$IFn$_invoke$arity$1(inst_40599);
var inst_40637 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_40634,inst_40636);
var state_40681__$1 = state_40681;
var statearr_40774_40856 = state_40681__$1;
(statearr_40774_40856[(2)] = inst_40637);

(statearr_40774_40856[(1)] = (44));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (37))){
var inst_40622 = (state_40681[(24)]);
var state_40681__$1 = state_40681;
var statearr_40775_40857 = state_40681__$1;
(statearr_40775_40857[(2)] = inst_40622);

(statearr_40775_40857[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (8))){
var inst_40557 = (state_40681[(2)]);
var state_40681__$1 = state_40681;
if(cljs.core.truth_(inst_40557)){
var statearr_40776_40858 = state_40681__$1;
(statearr_40776_40858[(1)] = (9));

} else {
var statearr_40777_40859 = state_40681__$1;
(statearr_40777_40859[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_40682 === (49))){
var inst_40646 = (state_40681[(19)]);
var state_40681__$1 = state_40681;
var statearr_40778_40860 = state_40681__$1;
(statearr_40778_40860[(2)] = inst_40646);

(statearr_40778_40860[(1)] = (50));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$state_machine__16395__auto__ = null;
var fluree$db$query$fql$state_machine__16395__auto____0 = (function (){
var statearr_40779 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_40779[(0)] = fluree$db$query$fql$state_machine__16395__auto__);

(statearr_40779[(1)] = (1));

return statearr_40779;
});
var fluree$db$query$fql$state_machine__16395__auto____1 = (function (state_40681){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_40681);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e40780){var ex__16398__auto__ = e40780;
var statearr_40781_40861 = state_40681;
(statearr_40781_40861[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_40681[(4)]))){
var statearr_40782_40862 = state_40681;
(statearr_40782_40862[(1)] = cljs.core.first((state_40681[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__40863 = state_40681;
state_40681 = G__40863;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$state_machine__16395__auto__ = function(state_40681){
switch(arguments.length){
case 0:
return fluree$db$query$fql$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$state_machine__16395__auto____1.call(this,state_40681);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$state_machine__16395__auto____0;
fluree$db$query$fql$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$state_machine__16395__auto____1;
return fluree$db$query$fql$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_40783 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_40783[(6)] = c__16469__auto__);

return statearr_40783;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.fql.process_ad_hoc_group.cljs$lang$maxFixedArity = 7);

fluree.db.query.fql.ad_hoc_group_by = (function fluree$db$query$fql$ad_hoc_group_by(p__40866,groupBy){
var map__40867 = p__40866;
var map__40867__$1 = cljs.core.__destructure_map(map__40867);
var res = map__40867__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40867__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40867__$1,cljs.core.cst$kw$tuples);
var vec__40868 = ((cljs.core.vector_QMARK_(groupBy))?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [true,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.symbol,groupBy)], null):((typeof groupBy === 'string')?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [false,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(groupBy)], null)], null):(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause, must be a string or vector. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})()
));
var inVector_QMARK_ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40868,(0),null);
var groupBy__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40868,(1),null);
var group_idxs = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40864_SHARP_){
return fluree.db.util.core.index_of(headers,p1__40864_SHARP_);
}),groupBy__$1);
var _ = (cljs.core.truth_(cljs.core.some(cljs.core.nil_QMARK_,group_idxs))?(function(){throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid groupBy clause - are all groupBy vars declared in the where clause. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(groupBy__$1)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null))})():null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (res__$1,tuple){
var k = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__40865_SHARP_){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(tuple,p1__40865_SHARP_);
}),group_idxs);
var k_SINGLEQUOTE_ = (cljs.core.truth_(inVector_QMARK_)?cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,k):cljs.core.first(k));
var v = tuple;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(res__$1,k_SINGLEQUOTE_,cljs.core.PersistentVector.EMPTY),v));
}),cljs.core.PersistentArrayMap.EMPTY,tuples);
});
fluree.db.query.fql.build_order_fn = (function fluree$db$query$fql$build_order_fn(orderBy,groupBy){
var vec__40871 = (cljs.core.truth_(orderBy)?orderBy:new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",groupBy], null));
var sortDirection = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40871,(0),null);
var sortCriteria = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__40871,(1),null);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortCriteria,groupBy)){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(sortDirection,"DESC")){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(x,y));
});
} else {
return fluree.db.query.fql.compare_fn;
}
} else {
if(((cljs.core.coll_QMARK_(groupBy)) && (typeof sortCriteria === 'string'))){
var orderByIdx = fluree.db.util.core.index_of(groupBy,sortCriteria);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("DESC",sortDirection)){
return (function (x,y){
return ((-1) * fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx)));
});
} else {
return (function (x,y){
return fluree.db.query.fql.compare_fn(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(x,orderByIdx),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(y,orderByIdx));
});
}
} else {
return null;

}
}
});
fluree.db.query.fql.process_ad_hoc_res = (function fluree$db$query$fql$process_ad_hoc_res(db,fuel,max_fuel,p__40874,p__40875,opts){
var map__40876 = p__40874;
var map__40876__$1 = cljs.core.__destructure_map(map__40876);
var res = map__40876__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40876__$1,cljs.core.cst$kw$headers);
var vars = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40876__$1,cljs.core.cst$kw$vars);
var map__40877 = p__40875;
var map__40877__$1 = cljs.core.__destructure_map(map__40877);
var select_spec = map__40877__$1;
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$groupBy);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$orderBy);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$limit);
var selectOne_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$selectOne_QMARK_);
var selectDistinct_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$selectDistinct_QMARK_);
var inVector_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$inVector_QMARK_);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__40877__$1,cljs.core.cst$kw$offset);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_41119){
var state_val_41120 = (state_41119[(1)]);
if((state_val_41120 === (65))){
var state_41119__$1 = state_41119;
var statearr_41121_41272 = state_41119__$1;
(statearr_41121_41272[(1)] = (67));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (70))){
var inst_41040 = (state_41119[(7)]);
var state_41119__$1 = state_41119;
var statearr_41123_41273 = state_41119__$1;
(statearr_41123_41273[(2)] = inst_41040);

(statearr_41123_41273[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (62))){
var state_41119__$1 = state_41119;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_41124_41274 = state_41119__$1;
(statearr_41124_41274[(1)] = (64));

} else {
var statearr_41125_41275 = state_41119__$1;
(statearr_41125_41275[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (74))){
var inst_41015 = (state_41119[(8)]);
var inst_40947 = (state_41119[(9)]);
var inst_40956 = (state_41119[(10)]);
var inst_41048 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40947,inst_40956,inst_41015);
var state_41119__$1 = state_41119;
var statearr_41126_41276 = state_41119__$1;
(statearr_41126_41276[(2)] = inst_41048);

(statearr_41126_41276[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (7))){
var state_41119__$1 = state_41119;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41127_41277 = state_41119__$1;
(statearr_41127_41277[(1)] = (82));

} else {
var statearr_41128_41278 = state_41119__$1;
(statearr_41128_41278[(1)] = (83));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (59))){
var inst_40945 = (state_41119[(11)]);
var inst_41015 = (state_41119[(8)]);
var inst_41019 = cljs.core.count(inst_41015);
var inst_41020 = (inst_40945 - inst_41019);
var state_41119__$1 = state_41119;
var statearr_41129_41279 = state_41119__$1;
(statearr_41129_41279[(2)] = inst_41020);

(statearr_41129_41279[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (86))){
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inVector_QMARK_)){
var statearr_41130_41280 = state_41119__$1;
(statearr_41130_41280[(1)] = (89));

} else {
var statearr_41131_41281 = state_41119__$1;
(statearr_41131_41281[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (20))){
var state_41119__$1 = state_41119;
var statearr_41132_41282 = state_41119__$1;
(statearr_41132_41282[(2)] = (0));

(statearr_41132_41282[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (72))){
var inst_41045 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_41045)){
var statearr_41133_41283 = state_41119__$1;
(statearr_41133_41283[(1)] = (73));

} else {
var statearr_41134_41284 = state_41119__$1;
(statearr_41134_41284[(1)] = (74));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (58))){
var state_41119__$1 = state_41119;
var statearr_41135_41285 = state_41119__$1;
(statearr_41135_41285[(2)] = null);

(statearr_41135_41285[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (60))){
var inst_40946 = (state_41119[(12)]);
var inst_41022 = (state_41119[(2)]);
var inst_41023 = (inst_40946 <= (0));
var state_41119__$1 = (function (){var statearr_41136 = state_41119;
(statearr_41136[(13)] = inst_41022);

return statearr_41136;
})();
if(cljs.core.truth_(inst_41023)){
var statearr_41137_41286 = state_41119__$1;
(statearr_41137_41286[(1)] = (61));

} else {
var statearr_41138_41287 = state_41119__$1;
(statearr_41138_41287[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (27))){
var inst_40945 = (state_41119[(11)]);
var inst_40969 = (inst_40945 < (1));
var state_41119__$1 = state_41119;
var statearr_41139_41288 = state_41119__$1;
(statearr_41139_41288[(2)] = inst_40969);

(statearr_41139_41288[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (1))){
var state_41119__$1 = state_41119;
var statearr_41140_41289 = state_41119__$1;
(statearr_41140_41289[(2)] = null);

(statearr_41140_41289[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (69))){
var inst_41035 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41141_41290 = state_41119__$1;
(statearr_41141_41290[(2)] = inst_41035);

(statearr_41141_41290[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (24))){
var inst_40947 = (state_41119[(9)]);
var state_41119__$1 = state_41119;
var statearr_41142_41291 = state_41119__$1;
(statearr_41142_41291[(2)] = inst_40947);

(statearr_41142_41291[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (55))){
var inst_40945 = (state_41119[(11)]);
var inst_41005 = (state_41119[(14)]);
var inst_41012 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_40945,inst_41005);
var state_41119__$1 = state_41119;
var statearr_41143_41292 = state_41119__$1;
(statearr_41143_41292[(2)] = inst_41012);

(statearr_41143_41292[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (85))){
var inst_41090 = (state_41119[(15)]);
var inst_41089 = (state_41119[(2)]);
var inst_41090__$1 = fluree.db.util.async.throw_err(inst_41089);
var inst_41091 = cljs.core.coll_QMARK_(inst_41090__$1);
var inst_41092 = (!(inst_41091));
var state_41119__$1 = (function (){var statearr_41144 = state_41119;
(statearr_41144[(15)] = inst_41090__$1);

return statearr_41144;
})();
if(inst_41092){
var statearr_41145_41293 = state_41119__$1;
(statearr_41145_41293[(1)] = (86));

} else {
var statearr_41146_41294 = state_41119__$1;
(statearr_41146_41294[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (39))){
var inst_40964 = (state_41119[(16)]);
var inst_40986 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(select_spec,cljs.core.cst$kw$orderBy,null,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$offset,(0),cljs.core.cst$kw$limit,null], 0));
var inst_40987 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$offset,(0),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$limit,null], 0));
var inst_40988 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$6(db,fuel,max_fuel,inst_40964,inst_40986,inst_40987);
var state_41119__$1 = state_41119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41119__$1,(42),inst_40988);
} else {
if((state_val_41120 === (88))){
var inst_41112 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41147_41295 = state_41119__$1;
(statearr_41147_41295[(2)] = inst_41112);

(statearr_41147_41295[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (46))){
var inst_40946 = (state_41119[(12)]);
var inst_41000 = ((0) < inst_40946);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_41000)){
var statearr_41148_41296 = state_41119__$1;
(statearr_41148_41296[(1)] = (49));

} else {
var statearr_41149_41297 = state_41119__$1;
(statearr_41149_41297[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (4))){
var inst_40878 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41150_41298 = state_41119__$1;
(statearr_41150_41298[(2)] = inst_40878);

(statearr_41150_41298[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (77))){
var inst_40945 = (state_41119[(11)]);
var inst_41056 = (inst_40945 - (1));
var state_41119__$1 = state_41119;
var statearr_41151_41299 = state_41119__$1;
(statearr_41151_41299[(2)] = inst_41056);

(statearr_41151_41299[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (95))){
var inst_41090 = (state_41119[(15)]);
var state_41119__$1 = state_41119;
var statearr_41152_41300 = state_41119__$1;
(statearr_41152_41300[(2)] = inst_41090);

(statearr_41152_41300[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (54))){
var inst_41010 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_41010)){
var statearr_41153_41301 = state_41119__$1;
(statearr_41153_41301[(1)] = (55));

} else {
var statearr_41154_41302 = state_41119__$1;
(statearr_41154_41302[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (92))){
var inst_41090 = (state_41119[(15)]);
var inst_41103 = cljs.core.first(inst_41090);
var state_41119__$1 = state_41119;
var statearr_41155_41303 = state_41119__$1;
(statearr_41155_41303[(2)] = inst_41103);

(statearr_41155_41303[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (15))){
var inst_40896 = (state_41119[(17)]);
var inst_40904 = (state_41119[(2)]);
var inst_40905 = fluree.db.util.async.throw_err(inst_40904);
var inst_40906 = [inst_40896];
var inst_40907 = [inst_40905];
var inst_40908 = cljs.core.PersistentHashMap.fromArrays(inst_40906,inst_40907);
var state_41119__$1 = state_41119;
var statearr_41156_41304 = state_41119__$1;
(statearr_41156_41304[(2)] = inst_40908);

(statearr_41156_41304[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (48))){
var inst_41068 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41157_41305 = state_41119__$1;
(statearr_41157_41305[(2)] = inst_41068);

(statearr_41157_41305[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (50))){
var inst_40991 = (state_41119[(18)]);
var state_41119__$1 = state_41119;
var statearr_41158_41306 = state_41119__$1;
(statearr_41158_41306[(2)] = inst_40991);

(statearr_41158_41306[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (75))){
var inst_40960 = (state_41119[(19)]);
var inst_40957 = (state_41119[(20)]);
var inst_41039 = (state_41119[(21)]);
var inst_41022 = (state_41119[(13)]);
var inst_41050 = (state_41119[(2)]);
var inst_40943 = inst_40957;
var inst_40944 = inst_40960;
var inst_40945 = inst_41022;
var inst_40946 = inst_41039;
var inst_40947 = inst_41050;
var state_41119__$1 = (function (){var statearr_41159 = state_41119;
(statearr_41159[(11)] = inst_40945);

(statearr_41159[(12)] = inst_40946);

(statearr_41159[(22)] = inst_40944);

(statearr_41159[(23)] = inst_40943);

(statearr_41159[(9)] = inst_40947);

return statearr_41159;
})();
var statearr_41160_41307 = state_41119__$1;
(statearr_41160_41307[(2)] = null);

(statearr_41160_41307[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (21))){
var inst_40928 = (state_41119[(24)]);
var inst_40936 = (state_41119[(25)]);
var inst_40924 = (state_41119[(26)]);
var inst_40941 = (state_41119[(2)]);
var inst_40942 = cljs.core.PersistentHashMap.EMPTY;
var inst_40943 = inst_40924;
var inst_40944 = inst_40928;
var inst_40945 = inst_40936;
var inst_40946 = inst_40941;
var inst_40947 = inst_40942;
var state_41119__$1 = (function (){var statearr_41161 = state_41119;
(statearr_41161[(11)] = inst_40945);

(statearr_41161[(12)] = inst_40946);

(statearr_41161[(22)] = inst_40944);

(statearr_41161[(23)] = inst_40943);

(statearr_41161[(9)] = inst_40947);

return statearr_41161;
})();
var statearr_41162_41308 = state_41119__$1;
(statearr_41162_41308[(2)] = null);

(statearr_41162_41308[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (31))){
var inst_40946 = (state_41119[(12)]);
var inst_40961 = (state_41119[(27)]);
var inst_40975 = (inst_40946 >= inst_40961);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_40975)){
var statearr_41163_41309 = state_41119__$1;
(statearr_41163_41309[(1)] = (33));

} else {
var statearr_41164_41310 = state_41119__$1;
(statearr_41164_41310[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (32))){
var inst_41075 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41165_41311 = state_41119__$1;
(statearr_41165_41311[(2)] = inst_41075);

(statearr_41165_41311[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (40))){
var state_41119__$1 = state_41119;
var statearr_41166_41312 = state_41119__$1;
(statearr_41166_41312[(2)] = null);

(statearr_41166_41312[(1)] = (41));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (91))){
var inst_41100 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41167_41313 = state_41119__$1;
(statearr_41167_41313[(2)] = inst_41100);

(statearr_41167_41313[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (56))){
var inst_41005 = (state_41119[(14)]);
var state_41119__$1 = state_41119;
var statearr_41168_41314 = state_41119__$1;
(statearr_41168_41314[(2)] = inst_41005);

(statearr_41168_41314[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (33))){
var state_41119__$1 = state_41119;
if(cljs.core.truth_(selectDistinct_QMARK_)){
var statearr_41169_41315 = state_41119__$1;
(statearr_41169_41315[(1)] = (36));

} else {
var statearr_41170_41316 = state_41119__$1;
(statearr_41170_41316[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (13))){
var inst_40928 = (state_41119[(24)]);
var inst_40924 = (state_41119[(26)]);
var inst_40893 = (state_41119[(28)]);
var inst_40924__$1 = cljs.core.keys(inst_40893);
var inst_40925 = cljs.core.seq(inst_40924__$1);
var inst_40926 = cljs.core.first(inst_40925);
var inst_40927 = cljs.core.next(inst_40925);
var inst_40928__$1 = cljs.core.vals(inst_40893);
var inst_40929 = cljs.core.seq(inst_40928__$1);
var inst_40930 = cljs.core.first(inst_40929);
var inst_40931 = cljs.core.next(inst_40929);
var inst_40932 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),limit);
var state_41119__$1 = (function (){var statearr_41171 = state_41119;
(statearr_41171[(29)] = inst_40926);

(statearr_41171[(24)] = inst_40928__$1);

(statearr_41171[(26)] = inst_40924__$1);

(statearr_41171[(30)] = inst_40927);

(statearr_41171[(31)] = inst_40931);

(statearr_41171[(32)] = inst_40930);

return statearr_41171;
})();
if(inst_40932){
var statearr_41172_41317 = state_41119__$1;
(statearr_41172_41317[(1)] = (16));

} else {
var statearr_41173_41318 = state_41119__$1;
(statearr_41173_41318[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (22))){
var inst_40944 = (state_41119[(22)]);
var inst_40943 = (state_41119[(23)]);
var inst_40955 = cljs.core.seq(inst_40943);
var inst_40956 = cljs.core.first(inst_40955);
var inst_40957 = cljs.core.next(inst_40955);
var inst_40958 = cljs.core.seq(inst_40944);
var inst_40959 = cljs.core.first(inst_40958);
var inst_40960 = cljs.core.next(inst_40958);
var inst_40961 = cljs.core.count(inst_40959);
var inst_40962 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40963 = [headers,vars,inst_40959];
var inst_40964 = cljs.core.PersistentHashMap.fromArrays(inst_40962,inst_40963);
var inst_40965 = (inst_40959 == null);
var state_41119__$1 = (function (){var statearr_41174 = state_41119;
(statearr_41174[(19)] = inst_40960);

(statearr_41174[(20)] = inst_40957);

(statearr_41174[(27)] = inst_40961);

(statearr_41174[(16)] = inst_40964);

(statearr_41174[(10)] = inst_40956);

return statearr_41174;
})();
if(cljs.core.truth_(inst_40965)){
var statearr_41175_41319 = state_41119__$1;
(statearr_41175_41319[(1)] = (24));

} else {
var statearr_41176_41320 = state_41119__$1;
(statearr_41176_41320[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (90))){
var inst_41090 = (state_41119[(15)]);
var state_41119__$1 = state_41119;
var statearr_41177_41321 = state_41119__$1;
(statearr_41177_41321[(2)] = inst_41090);

(statearr_41177_41321[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (36))){
var inst_40946 = (state_41119[(12)]);
var inst_40978 = (inst_40946 - (1));
var state_41119__$1 = state_41119;
var statearr_41178_41322 = state_41119__$1;
(statearr_41178_41322[(2)] = inst_40978);

(statearr_41178_41322[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (41))){
var inst_41071 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41179_41323 = state_41119__$1;
(statearr_41179_41323[(2)] = inst_41071);

(statearr_41179_41323[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (89))){
var inst_41090 = (state_41119[(15)]);
var inst_41095 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41096 = [inst_41090];
var inst_41097 = (new cljs.core.PersistentVector(null,1,(5),inst_41095,inst_41096,null));
var state_41119__$1 = state_41119;
var statearr_41180_41324 = state_41119__$1;
(statearr_41180_41324[(2)] = inst_41097);

(statearr_41180_41324[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (43))){
var inst_40991 = (state_41119[(18)]);
var inst_40994 = cljs.core.seq(inst_40991);
var state_41119__$1 = state_41119;
var statearr_41181_41325 = state_41119__$1;
(statearr_41181_41325[(2)] = inst_40994);

(statearr_41181_41325[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (61))){
var state_41119__$1 = state_41119;
var statearr_41182_41326 = state_41119__$1;
(statearr_41182_41326[(2)] = (0));

(statearr_41182_41326[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (29))){
var inst_40972 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_40972)){
var statearr_41183_41327 = state_41119__$1;
(statearr_41183_41327[(1)] = (30));

} else {
var statearr_41184_41328 = state_41119__$1;
(statearr_41184_41328[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (44))){
var inst_40992 = (state_41119[(33)]);
var state_41119__$1 = state_41119;
var statearr_41185_41329 = state_41119__$1;
(statearr_41185_41329[(2)] = inst_40992);

(statearr_41185_41329[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (93))){
var state_41119__$1 = state_41119;
var statearr_41186_41330 = state_41119__$1;
(statearr_41186_41330[(1)] = (95));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (6))){
var inst_40885 = (state_41119[(34)]);
var inst_40885__$1 = fluree.db.query.fql.build_order_fn(orderBy,groupBy);
var inst_40887 = fluree.db.query.fql.ad_hoc_group_by(res,groupBy);
var state_41119__$1 = (function (){var statearr_41188 = state_41119;
(statearr_41188[(34)] = inst_40885__$1);

(statearr_41188[(35)] = inst_40887);

return statearr_41188;
})();
if(cljs.core.truth_(inst_40885__$1)){
var statearr_41189_41331 = state_41119__$1;
(statearr_41189_41331[(1)] = (9));

} else {
var statearr_41190_41332 = state_41119__$1;
(statearr_41190_41332[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (28))){
var inst_40945 = (state_41119[(11)]);
var state_41119__$1 = state_41119;
var statearr_41191_41333 = state_41119__$1;
(statearr_41191_41333[(2)] = inst_40945);

(statearr_41191_41333[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (64))){
var inst_40946 = (state_41119[(12)]);
var inst_41027 = (inst_40946 - (1));
var state_41119__$1 = state_41119;
var statearr_41192_41334 = state_41119__$1;
(statearr_41192_41334[(2)] = inst_41027);

(statearr_41192_41334[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (51))){
var inst_40945 = (state_41119[(11)]);
var inst_41005 = (state_41119[(2)]);
var state_41119__$1 = (function (){var statearr_41193 = state_41119;
(statearr_41193[(14)] = inst_41005);

return statearr_41193;
})();
if(cljs.core.truth_(inst_40945)){
var statearr_41194_41335 = state_41119__$1;
(statearr_41194_41335[(1)] = (52));

} else {
var statearr_41195_41336 = state_41119__$1;
(statearr_41195_41336[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (25))){
var inst_40945 = (state_41119[(11)]);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_40945)){
var statearr_41196_41337 = state_41119__$1;
(statearr_41196_41337[(1)] = (27));

} else {
var statearr_41197_41338 = state_41119__$1;
(statearr_41197_41338[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (34))){
var state_41119__$1 = state_41119;
var statearr_41198_41339 = state_41119__$1;
(statearr_41198_41339[(1)] = (39));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (17))){
var state_41119__$1 = state_41119;
var statearr_41200_41340 = state_41119__$1;
(statearr_41200_41340[(2)] = limit);

(statearr_41200_41340[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (3))){
var inst_41117 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41119__$1,inst_41117);
} else {
if((state_val_41120 === (12))){
var inst_40893 = (state_41119[(28)]);
var inst_40895 = cljs.core.keys(inst_40893);
var inst_40896 = cljs.core.first(inst_40895);
var inst_40897 = [cljs.core.cst$kw$headers,cljs.core.cst$kw$vars,cljs.core.cst$kw$tuples];
var inst_40898 = cljs.core.vals(inst_40893);
var inst_40899 = cljs.core.first(inst_40898);
var inst_40900 = [headers,vars,inst_40899];
var inst_40901 = cljs.core.PersistentHashMap.fromArrays(inst_40897,inst_40900);
var inst_40902 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,inst_40901,select_spec,limit,opts);
var state_41119__$1 = (function (){var statearr_41201 = state_41119;
(statearr_41201[(17)] = inst_40896);

return statearr_41201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41119__$1,(15),inst_40902);
} else {
if((state_val_41120 === (2))){
var _ = (function (){var statearr_41202 = state_41119;
(statearr_41202[(4)] = cljs.core.cons((5),(state_41119[(4)])));

return statearr_41202;
})();
var state_41119__$1 = state_41119;
if(cljs.core.truth_(groupBy)){
var statearr_41203_41341 = state_41119__$1;
(statearr_41203_41341[(1)] = (6));

} else {
var statearr_41204_41342 = state_41119__$1;
(statearr_41204_41342[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (66))){
var inst_41037 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41205_41343 = state_41119__$1;
(statearr_41205_41343[(2)] = inst_41037);

(statearr_41205_41343[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (23))){
var inst_41079 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41206_41344 = state_41119__$1;
(statearr_41206_41344[(2)] = inst_41079);

(statearr_41206_41344[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (47))){
var inst_40945 = (state_41119[(11)]);
var inst_41053 = (inst_40945 == null);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_41053)){
var statearr_41207_41345 = state_41119__$1;
(statearr_41207_41345[(1)] = (76));

} else {
var statearr_41208_41346 = state_41119__$1;
(statearr_41208_41346[(1)] = (77));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (35))){
var inst_41073 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41209_41347 = state_41119__$1;
(statearr_41209_41347[(2)] = inst_41073);

(statearr_41209_41347[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (82))){
var state_41119__$1 = state_41119;
var statearr_41210_41348 = state_41119__$1;
(statearr_41210_41348[(2)] = (1));

(statearr_41210_41348[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (76))){
var state_41119__$1 = state_41119;
var statearr_41211_41349 = state_41119__$1;
(statearr_41211_41349[(2)] = null);

(statearr_41211_41349[(1)] = (78));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (97))){
var inst_41108 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41212_41350 = state_41119__$1;
(statearr_41212_41350[(2)] = inst_41108);

(statearr_41212_41350[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (19))){
var inst_40937 = (state_41119[(36)]);
var state_41119__$1 = state_41119;
var statearr_41213_41351 = state_41119__$1;
(statearr_41213_41351[(2)] = inst_40937);

(statearr_41213_41351[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (57))){
var inst_40945 = (state_41119[(11)]);
var inst_41015 = (state_41119[(2)]);
var inst_41016 = (inst_40945 == null);
var state_41119__$1 = (function (){var statearr_41214 = state_41119;
(statearr_41214[(8)] = inst_41015);

return statearr_41214;
})();
if(cljs.core.truth_(inst_41016)){
var statearr_41215_41352 = state_41119__$1;
(statearr_41215_41352[(1)] = (58));

} else {
var statearr_41216_41353 = state_41119__$1;
(statearr_41216_41353[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (68))){
var state_41119__$1 = state_41119;
var statearr_41217_41354 = state_41119__$1;
(statearr_41217_41354[(2)] = null);

(statearr_41217_41354[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (11))){
var inst_40893 = (state_41119[(2)]);
var state_41119__$1 = (function (){var statearr_41219 = state_41119;
(statearr_41219[(28)] = inst_40893);

return statearr_41219;
})();
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41220_41355 = state_41119__$1;
(statearr_41220_41355[(1)] = (12));

} else {
var statearr_41221_41356 = state_41119__$1;
(statearr_41221_41356[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (9))){
var inst_40885 = (state_41119[(34)]);
var inst_40887 = (state_41119[(35)]);
var inst_40889 = cljs.core.sorted_map_by(inst_40885);
var inst_40890 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_40889,inst_40887);
var state_41119__$1 = state_41119;
var statearr_41222_41357 = state_41119__$1;
(statearr_41222_41357[(2)] = inst_40890);

(statearr_41222_41357[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (5))){
var _ = (function (){var statearr_41223 = state_41119;
(statearr_41223[(4)] = cljs.core.rest((state_41119[(4)])));

return statearr_41223;
})();
var state_41119__$1 = state_41119;
var ex41218 = (state_41119__$1[(2)]);
var statearr_41224_41358 = state_41119__$1;
(statearr_41224_41358[(5)] = ex41218);


if((ex41218 instanceof Error)){
var statearr_41225_41359 = state_41119__$1;
(statearr_41225_41359[(1)] = (4));

(statearr_41225_41359[(5)] = null);

} else {
throw ex41218;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (83))){
var state_41119__$1 = state_41119;
var statearr_41226_41360 = state_41119__$1;
(statearr_41226_41360[(2)] = limit);

(statearr_41226_41360[(1)] = (84));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (14))){
var inst_41081 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41227_41361 = state_41119__$1;
(statearr_41227_41361[(2)] = inst_41081);

(statearr_41227_41361[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (45))){
var inst_40997 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
if(cljs.core.truth_(inst_40997)){
var statearr_41228_41362 = state_41119__$1;
(statearr_41228_41362[(1)] = (46));

} else {
var statearr_41229_41363 = state_41119__$1;
(statearr_41229_41363[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (53))){
var inst_40945 = (state_41119[(11)]);
var state_41119__$1 = state_41119;
var statearr_41230_41364 = state_41119__$1;
(statearr_41230_41364[(2)] = inst_40945);

(statearr_41230_41364[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (78))){
var inst_40946 = (state_41119[(12)]);
var inst_41058 = (state_41119[(2)]);
var inst_41059 = (inst_40946 <= (0));
var state_41119__$1 = (function (){var statearr_41231 = state_41119;
(statearr_41231[(37)] = inst_41058);

return statearr_41231;
})();
if(cljs.core.truth_(inst_41059)){
var statearr_41232_41365 = state_41119__$1;
(statearr_41232_41365[(1)] = (79));

} else {
var statearr_41233_41366 = state_41119__$1;
(statearr_41233_41366[(1)] = (80));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (26))){
var inst_41077 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41234_41367 = state_41119__$1;
(statearr_41234_41367[(2)] = inst_41077);

(statearr_41234_41367[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (16))){
var state_41119__$1 = state_41119;
var statearr_41235_41368 = state_41119__$1;
(statearr_41235_41368[(2)] = null);

(statearr_41235_41368[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (81))){
var inst_41058 = (state_41119[(37)]);
var inst_40960 = (state_41119[(19)]);
var inst_40957 = (state_41119[(20)]);
var inst_40991 = (state_41119[(18)]);
var inst_40947 = (state_41119[(9)]);
var inst_40956 = (state_41119[(10)]);
var inst_41064 = (state_41119[(2)]);
var inst_41065 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_40947,inst_40956,inst_40991);
var inst_40943 = inst_40957;
var inst_40944 = inst_40960;
var inst_40945 = inst_41058;
var inst_40946 = inst_41064;
var inst_40947__$1 = inst_41065;
var state_41119__$1 = (function (){var statearr_41238 = state_41119;
(statearr_41238[(11)] = inst_40945);

(statearr_41238[(12)] = inst_40946);

(statearr_41238[(22)] = inst_40944);

(statearr_41238[(23)] = inst_40943);

(statearr_41238[(9)] = inst_40947__$1);

return statearr_41238;
})();
var statearr_41239_41369 = state_41119__$1;
(statearr_41239_41369[(2)] = null);

(statearr_41239_41369[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (79))){
var state_41119__$1 = state_41119;
var statearr_41240_41370 = state_41119__$1;
(statearr_41240_41370[(2)] = (0));

(statearr_41240_41370[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (38))){
var inst_40945 = (state_41119[(11)]);
var inst_40960 = (state_41119[(19)]);
var inst_40957 = (state_41119[(20)]);
var inst_40947 = (state_41119[(9)]);
var inst_40982 = (state_41119[(2)]);
var tmp41236 = inst_40945;
var tmp41237 = inst_40947;
var inst_40943 = inst_40957;
var inst_40944 = inst_40960;
var inst_40945__$1 = tmp41236;
var inst_40946 = inst_40982;
var inst_40947__$1 = tmp41237;
var state_41119__$1 = (function (){var statearr_41241 = state_41119;
(statearr_41241[(11)] = inst_40945__$1);

(statearr_41241[(12)] = inst_40946);

(statearr_41241[(22)] = inst_40944);

(statearr_41241[(23)] = inst_40943);

(statearr_41241[(9)] = inst_40947__$1);

return statearr_41241;
})();
var statearr_41242_41371 = state_41119__$1;
(statearr_41242_41371[(2)] = null);

(statearr_41242_41371[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (87))){
var state_41119__$1 = state_41119;
if(cljs.core.truth_(selectOne_QMARK_)){
var statearr_41243_41372 = state_41119__$1;
(statearr_41243_41372[(1)] = (92));

} else {
var statearr_41244_41373 = state_41119__$1;
(statearr_41244_41373[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (30))){
var inst_40947 = (state_41119[(9)]);
var state_41119__$1 = state_41119;
var statearr_41245_41374 = state_41119__$1;
(statearr_41245_41374[(2)] = inst_40947);

(statearr_41245_41374[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (73))){
var inst_40947 = (state_41119[(9)]);
var state_41119__$1 = state_41119;
var statearr_41246_41375 = state_41119__$1;
(statearr_41246_41375[(2)] = inst_40947);

(statearr_41246_41375[(1)] = (75));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (96))){
var state_41119__$1 = state_41119;
var statearr_41247_41376 = state_41119__$1;
(statearr_41247_41376[(2)] = null);

(statearr_41247_41376[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (10))){
var inst_40887 = (state_41119[(35)]);
var state_41119__$1 = state_41119;
var statearr_41248_41377 = state_41119__$1;
(statearr_41248_41377[(2)] = inst_40887);

(statearr_41248_41377[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (18))){
var inst_40937 = (state_41119[(36)]);
var inst_40936 = (state_41119[(2)]);
var inst_40937__$1 = offset;
var state_41119__$1 = (function (){var statearr_41249 = state_41119;
(statearr_41249[(25)] = inst_40936);

(statearr_41249[(36)] = inst_40937__$1);

return statearr_41249;
})();
if(cljs.core.truth_(inst_40937__$1)){
var statearr_41250_41378 = state_41119__$1;
(statearr_41250_41378[(1)] = (19));

} else {
var statearr_41251_41379 = state_41119__$1;
(statearr_41251_41379[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (52))){
var inst_40945 = (state_41119[(11)]);
var inst_41007 = ((0) < inst_40945);
var state_41119__$1 = state_41119;
var statearr_41252_41380 = state_41119__$1;
(statearr_41252_41380[(2)] = inst_41007);

(statearr_41252_41380[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (67))){
var inst_40946 = (state_41119[(12)]);
var inst_40961 = (state_41119[(27)]);
var inst_41015 = (state_41119[(8)]);
var inst_41030 = cljs.core.count(inst_41015);
var inst_41031 = (inst_40961 - inst_41030);
var inst_41032 = (inst_40946 - inst_41031);
var state_41119__$1 = state_41119;
var statearr_41253_41381 = state_41119__$1;
(statearr_41253_41381[(2)] = inst_41032);

(statearr_41253_41381[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (71))){
var inst_41015 = (state_41119[(8)]);
var inst_41043 = cljs.core.empty_QMARK_(inst_41015);
var state_41119__$1 = state_41119;
var statearr_41254_41382 = state_41119__$1;
(statearr_41254_41382[(2)] = inst_41043);

(statearr_41254_41382[(1)] = (72));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (42))){
var inst_40991 = (state_41119[(18)]);
var inst_40992 = (state_41119[(33)]);
var inst_40990 = (state_41119[(2)]);
var inst_40991__$1 = fluree.db.util.async.throw_err(inst_40990);
var inst_40992__$1 = cljs.core.coll_QMARK_(inst_40991__$1);
var state_41119__$1 = (function (){var statearr_41255 = state_41119;
(statearr_41255[(18)] = inst_40991__$1);

(statearr_41255[(33)] = inst_40992__$1);

return statearr_41255;
})();
if(inst_40992__$1){
var statearr_41256_41383 = state_41119__$1;
(statearr_41256_41383[(1)] = (43));

} else {
var statearr_41257_41384 = state_41119__$1;
(statearr_41257_41384[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (80))){
var inst_40946 = (state_41119[(12)]);
var inst_41062 = (inst_40946 - (1));
var state_41119__$1 = state_41119;
var statearr_41258_41385 = state_41119__$1;
(statearr_41258_41385[(2)] = inst_41062);

(statearr_41258_41385[(1)] = (81));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (37))){
var inst_40946 = (state_41119[(12)]);
var inst_40961 = (state_41119[(27)]);
var inst_40980 = (inst_40946 - inst_40961);
var state_41119__$1 = state_41119;
var statearr_41259_41386 = state_41119__$1;
(statearr_41259_41386[(2)] = inst_40980);

(statearr_41259_41386[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (63))){
var inst_41040 = (state_41119[(7)]);
var inst_41015 = (state_41119[(8)]);
var inst_41039 = (state_41119[(2)]);
var inst_41040__$1 = (inst_41015 == null);
var state_41119__$1 = (function (){var statearr_41260 = state_41119;
(statearr_41260[(7)] = inst_41040__$1);

(statearr_41260[(21)] = inst_41039);

return statearr_41260;
})();
if(cljs.core.truth_(inst_41040__$1)){
var statearr_41261_41387 = state_41119__$1;
(statearr_41261_41387[(1)] = (70));

} else {
var statearr_41262_41388 = state_41119__$1;
(statearr_41262_41388[(1)] = (71));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (94))){
var inst_41110 = (state_41119[(2)]);
var state_41119__$1 = state_41119;
var statearr_41263_41389 = state_41119__$1;
(statearr_41263_41389[(2)] = inst_41110);

(statearr_41263_41389[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (8))){
var inst_41114 = (state_41119[(2)]);
var _ = (function (){var statearr_41264 = state_41119;
(statearr_41264[(4)] = cljs.core.rest((state_41119[(4)])));

return statearr_41264;
})();
var state_41119__$1 = state_41119;
var statearr_41265_41390 = state_41119__$1;
(statearr_41265_41390[(2)] = inst_41114);

(statearr_41265_41390[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (49))){
var inst_40946 = (state_41119[(12)]);
var inst_40991 = (state_41119[(18)]);
var inst_41002 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_40946,inst_40991);
var state_41119__$1 = state_41119;
var statearr_41266_41391 = state_41119__$1;
(statearr_41266_41391[(2)] = inst_41002);

(statearr_41266_41391[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41120 === (84))){
var inst_41086 = (state_41119[(2)]);
var inst_41087 = fluree.db.query.fql.process_ad_hoc_group.cljs$core$IFn$_invoke$arity$7(db,fuel,max_fuel,res,select_spec,inst_41086,opts);
var state_41119__$1 = state_41119;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41119__$1,(85),inst_41087);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0 = (function (){
var statearr_41267 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_41267[(0)] = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__);

(statearr_41267[(1)] = (1));

return statearr_41267;
});
var fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1 = (function (state_41119){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_41119);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e41268){var ex__16398__auto__ = e41268;
var statearr_41269_41392 = state_41119;
(statearr_41269_41392[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_41119[(4)]))){
var statearr_41270_41393 = state_41119;
(statearr_41270_41393[(1)] = cljs.core.first((state_41119[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__41394 = state_41119;
state_41119 = G__41394;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__ = function(state_41119){
switch(arguments.length){
case 0:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1.call(this,state_41119);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____0;
fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto____1;
return fluree$db$query$fql$process_ad_hoc_res_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_41271 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_41271[(6)] = c__16469__auto__);

return statearr_41271;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.fql.get_ad_hoc_select_spec = (function fluree$db$query$fql$get_ad_hoc_select_spec(headers,vars,p__41397,opts){
var map__41398 = p__41397;
var map__41398__$1 = cljs.core.__destructure_map(map__41398);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41398__$1,cljs.core.cst$kw$selectOne);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41398__$1,cljs.core.cst$kw$select);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41398__$1,cljs.core.cst$kw$selectDistinct);
var selectReduced = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41398__$1,cljs.core.cst$kw$selectReduced);
var select_smt = (function (){var or__4212__auto__ = selectOne;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
var or__4212__auto____$1 = select;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
var or__4212__auto____$2 = selectDistinct;
if(cljs.core.truth_(or__4212__auto____$2)){
return or__4212__auto____$2;
} else {
return selectReduced;
}
}
}
})();
var inVector_QMARK_ = cljs.core.vector_QMARK_(select_smt);
var select_smt__$1 = ((inVector_QMARK_)?select_smt:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [select_smt], null));
var parsed_select = fluree.db.query.fql.parse_select(headers,vars,select_smt__$1);
var aggregates = cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__41395_SHARP_){
return cljs.core.contains_QMARK_(p1__41395_SHARP_,cljs.core.cst$kw$code);
}),parsed_select);
var expandMap_QMARK_ = cljs.core.some((function (p1__41396_SHARP_){
return cljs.core.contains_QMARK_(p1__41396_SHARP_,cljs.core.cst$kw$selection);
}),parsed_select);
var aggregates__$1 = ((cljs.core.empty_QMARK_(aggregates))?null:aggregates);
var orderBy = (function (){var temp__5753__auto__ = cljs.core.cst$kw$orderBy.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__5753__auto__)){
var orderBy = temp__5753__auto__;
if(cljs.core.truth_((function (){var or__4212__auto__ = typeof orderBy === 'string';
if(or__4212__auto__){
return or__4212__auto__;
} else {
var and__4210__auto__ = cljs.core.vector_QMARK_(orderBy);
if(and__4210__auto__){
var G__41400 = cljs.core.first(orderBy);
var fexpr__41399 = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["DESC",null,"ASC",null], null), null);
return (fexpr__41399.cljs$core$IFn$_invoke$arity$1 ? fexpr__41399.cljs$core$IFn$_invoke$arity$1(G__41400) : fexpr__41399.call(null,G__41400));
} else {
return and__4210__auto__;
}
}
})())){
if(cljs.core.vector_QMARK_(orderBy)){
return orderBy;
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["ASC",orderBy], null);
}
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid orderBy clause, must be variable or two-tuple formatted ['ASC' or 'DESC', var]. Provided: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(orderBy)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_query], null));
}
} else {
return null;
}
})();
return cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$expandMaps_QMARK_,cljs.core.cst$kw$limit,cljs.core.cst$kw$offset,cljs.core.cst$kw$aggregates,cljs.core.cst$kw$selectOne_QMARK_,cljs.core.cst$kw$prettyPrint,cljs.core.cst$kw$groupBy,cljs.core.cst$kw$selectDistinct_QMARK_,cljs.core.cst$kw$select,cljs.core.cst$kw$orderBy,cljs.core.cst$kw$inVector_QMARK_],[expandMap_QMARK_,(function (){var or__4212__auto__ = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (100);
}
})(),(function (){var or__4212__auto__ = cljs.core.cst$kw$offset.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),aggregates__$1,cljs.core.boolean$(selectOne),(function (){var or__4212__auto__ = cljs.core.cst$kw$prettyPrint.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return false;
}
})(),cljs.core.cst$kw$groupBy.cljs$core$IFn$_invoke$arity$1(opts),cljs.core.boolean$((function (){var or__4212__auto__ = selectDistinct;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return selectReduced;
}
})()),parsed_select,orderBy,inVector_QMARK_]);
});
fluree.db.query.fql.construct_triples = (function fluree$db$query$fql$construct_triples(p__41401,p__41402){
var map__41403 = p__41401;
var map__41403__$1 = cljs.core.__destructure_map(map__41403);
var query_map = map__41403__$1;
var construct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41403__$1,cljs.core.cst$kw$construct);
var map__41404 = p__41402;
var map__41404__$1 = cljs.core.__destructure_map(map__41404);
var where_result = map__41404__$1;
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41404__$1,cljs.core.cst$kw$headers);
var tuples = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41404__$1,cljs.core.cst$kw$tuples);
var vec__41405 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (construct_item){
var temp__5751__auto__ = fluree.db.util.core.index_of(headers,cljs.core.symbol.cljs$core$IFn$_invoke$arity$1(construct_item));
if(cljs.core.truth_(temp__5751__auto__)){
var index_of = temp__5751__auto__;
return (function (row){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(row,index_of);
});
} else {
return (function (row){
return construct_item;
});
}
}),construct);
var fn1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41405,(0),null);
var fn2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41405,(1),null);
var fn3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__41405,(2),null);
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (res){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(res) : fn1.call(null,res)),(fn2.cljs$core$IFn$_invoke$arity$1 ? fn2.cljs$core$IFn$_invoke$arity$1(res) : fn2.call(null,res)),(fn3.cljs$core$IFn$_invoke$arity$1 ? fn3.cljs$core$IFn$_invoke$arity$1(res) : fn3.call(null,res))], null);
}),tuples);
});
fluree.db.query.fql.ad_hoc_query = (function fluree$db$query$fql$ad_hoc_query(db,fuel,max_fuel,query_map,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_41438){
var state_val_41439 = (state_41438[(1)]);
if((state_val_41439 === (7))){
var inst_41417 = (state_41438[(7)]);
var state_41438__$1 = state_41438;
var statearr_41440_41463 = state_41438__$1;
(statearr_41440_41463[(2)] = inst_41417);

(statearr_41440_41463[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (1))){
var state_41438__$1 = state_41438;
var statearr_41441_41464 = state_41438__$1;
(statearr_41441_41464[(2)] = null);

(statearr_41441_41464[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (4))){
var inst_41408 = (state_41438[(2)]);
var state_41438__$1 = state_41438;
var statearr_41442_41465 = state_41438__$1;
(statearr_41442_41465[(2)] = inst_41408);

(statearr_41442_41465[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (13))){
var inst_41427 = (state_41438[(2)]);
var inst_41428 = fluree.db.util.async.throw_err(inst_41427);
var state_41438__$1 = state_41438;
var statearr_41443_41466 = state_41438__$1;
(statearr_41443_41466[(2)] = inst_41428);

(statearr_41443_41466[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (6))){
var inst_41417 = (state_41438[(7)]);
var inst_41416 = (state_41438[(2)]);
var inst_41417__$1 = fluree.db.util.async.throw_err(inst_41416);
var inst_41418 = fluree.db.util.core.exception_QMARK_(inst_41417__$1);
var state_41438__$1 = (function (){var statearr_41444 = state_41438;
(statearr_41444[(7)] = inst_41417__$1);

return statearr_41444;
})();
if(inst_41418){
var statearr_41445_41467 = state_41438__$1;
(statearr_41445_41467[(1)] = (7));

} else {
var statearr_41446_41468 = state_41438__$1;
(statearr_41446_41468[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (3))){
var inst_41436 = (state_41438[(2)]);
var state_41438__$1 = state_41438;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41438__$1,inst_41436);
} else {
if((state_val_41439 === (12))){
var inst_41431 = (state_41438[(2)]);
var state_41438__$1 = state_41438;
var statearr_41447_41469 = state_41438__$1;
(statearr_41447_41469[(2)] = inst_41431);

(statearr_41447_41469[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (2))){
var _ = (function (){var statearr_41448 = state_41438;
(statearr_41448[(4)] = cljs.core.cons((5),(state_41438[(4)])));

return statearr_41448;
})();
var inst_41414 = fluree.db.query.analytical.q(query_map,fuel,max_fuel,db,opts);
var state_41438__$1 = state_41438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41438__$1,(6),inst_41414);
} else {
if((state_val_41439 === (11))){
var state_41438__$1 = state_41438;
var statearr_41450_41470 = state_41438__$1;
(statearr_41450_41470[(2)] = null);

(statearr_41450_41470[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (9))){
var inst_41433 = (state_41438[(2)]);
var _ = (function (){var statearr_41451 = state_41438;
(statearr_41451[(4)] = cljs.core.rest((state_41438[(4)])));

return statearr_41451;
})();
var state_41438__$1 = state_41438;
var statearr_41452_41471 = state_41438__$1;
(statearr_41452_41471[(2)] = inst_41433);

(statearr_41452_41471[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (5))){
var _ = (function (){var statearr_41453 = state_41438;
(statearr_41453[(4)] = cljs.core.rest((state_41438[(4)])));

return statearr_41453;
})();
var state_41438__$1 = state_41438;
var ex41449 = (state_41438__$1[(2)]);
var statearr_41454_41472 = state_41438__$1;
(statearr_41454_41472[(5)] = ex41449);


if((ex41449 instanceof Error)){
var statearr_41455_41473 = state_41438__$1;
(statearr_41455_41473[(1)] = (4));

(statearr_41455_41473[(5)] = null);

} else {
throw ex41449;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41439 === (10))){
var inst_41417 = (state_41438[(7)]);
var inst_41422 = cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(inst_41417);
var inst_41423 = cljs.core.cst$kw$vars.cljs$core$IFn$_invoke$arity$1(inst_41417);
var inst_41424 = fluree.db.query.fql.get_ad_hoc_select_spec(inst_41422,inst_41423,query_map,opts);
var inst_41425 = fluree.db.query.fql.process_ad_hoc_res(db,fuel,max_fuel,inst_41417,inst_41424,opts);
var state_41438__$1 = state_41438;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41438__$1,(13),inst_41425);
} else {
if((state_val_41439 === (8))){
var state_41438__$1 = state_41438;
var statearr_41456_41474 = state_41438__$1;
(statearr_41456_41474[(1)] = (10));



return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0 = (function (){
var statearr_41458 = [null,null,null,null,null,null,null,null];
(statearr_41458[(0)] = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__);

(statearr_41458[(1)] = (1));

return statearr_41458;
});
var fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1 = (function (state_41438){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_41438);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e41459){var ex__16398__auto__ = e41459;
var statearr_41460_41475 = state_41438;
(statearr_41460_41475[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_41438[(4)]))){
var statearr_41461_41476 = state_41438;
(statearr_41461_41476[(1)] = cljs.core.first((state_41438[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__41477 = state_41438;
state_41438 = G__41477;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__ = function(state_41438){
switch(arguments.length){
case 0:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1.call(this,state_41438);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____0;
fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto____1;
return fluree$db$query$fql$ad_hoc_query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_41462 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_41462[(6)] = c__16469__auto__);

return statearr_41462;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns core async channel with results or exception
 */
fluree.db.query.fql.query = (function fluree$db$query$fql$query(db,query_map){
fluree.db.util.log.debug.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Running query:",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0))], 0));

var map__41478 = query_map;
var map__41478__$1 = cljs.core.__destructure_map(map__41478);
var select = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$select);
var orderBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$orderBy);
var where = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$where);
var limit = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$limit);
var offset = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$offset);
var component = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$component);
var selectDistinct = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$selectDistinct);
var prettyPrint = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$prettyPrint);
var selectOne = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$selectOne);
var from = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$from);
var opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$opts);
var groupBy = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__41478__$1,cljs.core.cst$kw$groupBy);
var opts_SINGLEQUOTE_ = (function (){var G__41479 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$limit,limit,cljs.core.cst$kw$offset,(function (){var or__4212__auto__ = offset;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return (0);
}
})(),cljs.core.cst$kw$component,component,cljs.core.cst$kw$orderBy,orderBy,cljs.core.cst$kw$groupBy,groupBy,cljs.core.cst$kw$prettyPrint,prettyPrint], null),opts], 0));
if(cljs.core.truth_(selectOne)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(G__41479,cljs.core.cst$kw$limit,(1));
} else {
return G__41479;
}
})();
var max_fuel = cljs.core.cst$kw$max_DASH_fuel.cljs$core$IFn$_invoke$arity$1(opts_SINGLEQUOTE_);
var fuel = (function (){var or__4212__auto__ = cljs.core.cst$kw$fuel.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
if(cljs.core.truth_((function (){var or__4212__auto____$1 = max_fuel;
if(cljs.core.truth_(or__4212__auto____$1)){
return or__4212__auto____$1;
} else {
return cljs.core.cst$kw$meta.cljs$core$IFn$_invoke$arity$1(opts);
}
})())){
return cljs.core.volatile_BANG_((0));
} else {
return null;
}
}
})();
if(cljs.core.sequential_QMARK_(where)){
return fluree.db.query.fql.ad_hoc_query(db,fuel,max_fuel,query_map,opts_SINGLEQUOTE_);
} else {
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_41837){
var state_val_41838 = (state_41837[(1)]);
if((state_val_41838 === (121))){
var inst_41798 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41839_42034 = state_41837__$1;
(statearr_41839_42034[(2)] = inst_41798);

(statearr_41839_42034[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (65))){
var inst_41675 = typeof from === 'string';
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41675)){
var statearr_41840_42035 = state_41837__$1;
(statearr_41840_42035[(1)] = (72));

} else {
var statearr_41841_42036 = state_41837__$1;
(statearr_41841_42036[(1)] = (73));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (70))){
var inst_41543 = (state_41837[(7)]);
var inst_41541 = (state_41837[(8)]);
var inst_41668 = (state_41837[(2)]);
var inst_41669 = fluree.db.util.async.throw_err(inst_41668);
var inst_41670 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41543,fuel,max_fuel,inst_41541,inst_41669);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(71),inst_41670);
} else {
if((state_val_41838 === (62))){
var inst_41648 = (state_41837[(9)]);
var state_41837__$1 = state_41837;
var statearr_41842_42037 = state_41837__$1;
(statearr_41842_42037[(2)] = inst_41648);

(statearr_41842_42037[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (74))){
var inst_41804 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41843_42038 = state_41837__$1;
(statearr_41843_42038[(2)] = inst_41804);

(statearr_41843_42038[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (110))){
var inst_41739 = (state_41837[(10)]);
var state_41837__$1 = state_41837;
var statearr_41844_42039 = state_41837__$1;
(statearr_41844_42039[(2)] = inst_41739);

(statearr_41844_42039[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (130))){
var inst_41824 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41845_42040 = state_41837__$1;
(statearr_41845_42040[(2)] = inst_41824);

(statearr_41845_42040[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (128))){
var inst_41815 = (state_41837[(11)]);
var inst_41820 = fluree.db.util.core.exception_QMARK_(inst_41815);
var inst_41821 = (!(inst_41820));
var state_41837__$1 = state_41837;
var statearr_41846_42041 = state_41837__$1;
(statearr_41846_42041[(2)] = inst_41821);

(statearr_41846_42041[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (7))){
var inst_41511 = (state_41837[(12)]);
var inst_41511__$1 = selectOne;
var state_41837__$1 = (function (){var statearr_41847 = state_41837;
(statearr_41847[(12)] = inst_41511__$1);

return statearr_41847;
})();
if(cljs.core.truth_(inst_41511__$1)){
var statearr_41848_42042 = state_41837__$1;
(statearr_41848_42042[(1)] = (9));

} else {
var statearr_41849_42043 = state_41837__$1;
(statearr_41849_42043[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (59))){
var inst_41543 = (state_41837[(7)]);
var inst_41541 = (state_41837[(8)]);
var inst_41626 = (state_41837[(13)]);
var inst_41531 = (state_41837[(14)]);
var inst_41640 = (state_41837[(2)]);
var inst_41641 = fluree.db.util.async.throw_err(inst_41640);
var inst_41642 = cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(inst_41626,inst_41641);
var inst_41643 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$7(db,inst_41543,fuel,max_fuel,inst_41541,inst_41642,inst_41531);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(60),inst_41643);
} else {
if((state_val_41838 === (86))){
var inst_41533 = (state_41837[(15)]);
var inst_41543 = (state_41837[(7)]);
var inst_41541 = (state_41837[(8)]);
var inst_41531 = (state_41837[(14)]);
var inst_41708 = (state_41837[(2)]);
var inst_41709 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41543,fuel,max_fuel,inst_41541,inst_41708,inst_41531,inst_41533);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(87),inst_41709);
} else {
if((state_val_41838 === (20))){
var inst_41575 = (state_41837[(2)]);
var inst_41576 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41575,(0),null);
var inst_41577 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_41575,(1),null);
var inst_41578 = typeof where === 'string';
var state_41837__$1 = (function (){var statearr_41850 = state_41837;
(statearr_41850[(16)] = inst_41577);

(statearr_41850[(17)] = inst_41576);

return statearr_41850;
})();
if(cljs.core.truth_(inst_41578)){
var statearr_41851_42044 = state_41837__$1;
(statearr_41851_42044[(1)] = (30));

} else {
var statearr_41852_42045 = state_41837__$1;
(statearr_41852_42045[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (72))){
var inst_41530 = (state_41837[(18)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41530)){
var statearr_41853_42046 = state_41837__$1;
(statearr_41853_42046[(1)] = (75));

} else {
var statearr_41854_42047 = state_41837__$1;
(statearr_41854_42047[(1)] = (76));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (58))){
var inst_41634 = (state_41837[(2)]);
var inst_41635 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41636 = [from];
var inst_41637 = (new cljs.core.PersistentVector(null,1,(5),inst_41635,inst_41636,null));
var inst_41638 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_41637,inst_41634);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(59),inst_41638);
} else {
if((state_val_41838 === (60))){
var inst_41645 = (state_41837[(2)]);
var inst_41646 = fluree.db.util.async.throw_err(inst_41645);
var state_41837__$1 = state_41837;
var statearr_41855_42048 = state_41837__$1;
(statearr_41855_42048[(2)] = inst_41646);

(statearr_41855_42048[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (27))){
var inst_41560 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41561 = [null,null];
var inst_41562 = (new cljs.core.PersistentVector(null,2,(5),inst_41560,inst_41561,null));
var state_41837__$1 = state_41837;
var statearr_41856_42049 = state_41837__$1;
(statearr_41856_42049[(2)] = inst_41562);

(statearr_41856_42049[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (1))){
var state_41837__$1 = state_41837;
var statearr_41857_42050 = state_41837__$1;
(statearr_41857_42050[(2)] = null);

(statearr_41857_42050[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (69))){
var inst_41665 = (state_41837[(2)]);
var inst_41666 = fluree.db.query.range._block_or_tx_collection(db,inst_41665);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(70),inst_41666);
} else {
if((state_val_41838 === (101))){
var inst_41771 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41858_42051 = state_41837__$1;
(statearr_41858_42051[(2)] = inst_41771);

(statearr_41858_42051[(1)] = (98));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (24))){
var inst_41530 = (state_41837[(18)]);
var inst_41555 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41556 = [inst_41530,"ASC"];
var inst_41557 = (new cljs.core.PersistentVector(null,2,(5),inst_41555,inst_41556,null));
var state_41837__$1 = state_41837;
var statearr_41859_42052 = state_41837__$1;
(statearr_41859_42052[(2)] = inst_41557);

(statearr_41859_42052[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (102))){
var inst_41745 = (state_41837[(19)]);
var state_41837__$1 = state_41837;
var statearr_41860_42053 = state_41837__$1;
(statearr_41860_42053[(2)] = inst_41745);

(statearr_41860_42053[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (55))){
var inst_41530 = (state_41837[(18)]);
var inst_41626 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41861 = state_41837;
(statearr_41861[(13)] = inst_41626);

return statearr_41861;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41862_42054 = state_41837__$1;
(statearr_41862_42054[(1)] = (56));

} else {
var statearr_41863_42055 = state_41837__$1;
(statearr_41863_42055[(1)] = (57));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (85))){
var inst_41700 = (state_41837[(20)]);
var inst_41704 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41705 = [inst_41700];
var inst_41706 = (new cljs.core.PersistentVector(null,1,(5),inst_41704,inst_41705,null));
var state_41837__$1 = state_41837;
var statearr_41864_42056 = state_41837__$1;
(statearr_41864_42056[(2)] = inst_41706);

(statearr_41864_42056[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (39))){
var inst_41531 = (state_41837[(14)]);
var state_41837__$1 = state_41837;
var statearr_41865_42057 = state_41837__$1;
(statearr_41865_42057[(2)] = inst_41531);

(statearr_41865_42057[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (88))){
var inst_41714 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_41837__$1 = state_41837;
var statearr_41866_42058 = state_41837__$1;
(statearr_41866_42058[(2)] = inst_41714);

(statearr_41866_42058[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (46))){
var inst_41611 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41611)){
var statearr_41867_42059 = state_41837__$1;
(statearr_41867_42059[(1)] = (47));

} else {
var statearr_41868_42060 = state_41837__$1;
(statearr_41868_42060[(1)] = (48));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (4))){
var inst_41498 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41869_42061 = state_41837__$1;
(statearr_41869_42061[(2)] = inst_41498);

(statearr_41869_42061[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (77))){
var inst_41684 = (state_41837[(2)]);
var inst_41685 = fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,from,inst_41684);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(78),inst_41685);
} else {
if((state_val_41838 === (106))){
var state_41837__$1 = state_41837;
var statearr_41870_42062 = state_41837__$1;
(statearr_41870_42062[(2)] = null);

(statearr_41870_42062[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (119))){
var inst_41790 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([query_map], 0));
var inst_41791 = ["Invalid 'from' in query:",inst_41790].join('');
var inst_41792 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41793 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41794 = cljs.core.PersistentHashMap.fromArrays(inst_41792,inst_41793);
var inst_41795 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_41791,inst_41794);
var state_41837__$1 = state_41837;
var statearr_41871_42063 = state_41837__$1;
(statearr_41871_42063[(2)] = inst_41795);

(statearr_41871_42063[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (95))){
var state_41837__$1 = state_41837;
var statearr_41872_42064 = state_41837__$1;
(statearr_41872_42064[(1)] = (119));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (54))){
var inst_41620 = (state_41837[(21)]);
var state_41837__$1 = state_41837;
var statearr_41874_42065 = state_41837__$1;
(statearr_41874_42065[(2)] = inst_41620);

(statearr_41874_42065[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (92))){
var inst_41719 = (state_41837[(22)]);
var state_41837__$1 = state_41837;
var statearr_41875_42066 = state_41837__$1;
(statearr_41875_42066[(2)] = inst_41719);

(statearr_41875_42066[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (104))){
var inst_41763 = (state_41837[(23)]);
var inst_41763__$1 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41876 = state_41837;
(statearr_41876[(23)] = inst_41763__$1);

return statearr_41876;
})();
if(cljs.core.truth_(inst_41763__$1)){
var statearr_41877_42067 = state_41837__$1;
(statearr_41877_42067[(1)] = (109));

} else {
var statearr_41878_42068 = state_41837__$1;
(statearr_41878_42068[(1)] = (110));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (15))){
var inst_41534 = (state_41837[(24)]);
var inst_41532 = (state_41837[(25)]);
var inst_41538 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_41534,cljs.core.cst$kw$componentFollow_QMARK_,inst_41532);
var state_41837__$1 = state_41837;
var statearr_41879_42069 = state_41837__$1;
(statearr_41879_42069[(2)] = inst_41538);

(statearr_41879_42069[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (48))){
var inst_41648 = (state_41837[(9)]);
var inst_41648__$1 = typeof from === 'string';
var state_41837__$1 = (function (){var statearr_41880 = state_41837;
(statearr_41880[(9)] = inst_41648__$1);

return statearr_41880;
})();
if(cljs.core.truth_(inst_41648__$1)){
var statearr_41881_42070 = state_41837__$1;
(statearr_41881_42070[(1)] = (61));

} else {
var statearr_41882_42071 = state_41837__$1;
(statearr_41882_42071[(1)] = (62));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (50))){
var inst_41614 = (state_41837[(26)]);
var inst_41616 = fluree.db.query.fql.fuel_flake_transducer.cljs$core$IFn$_invoke$arity$2(fuel,max_fuel);
var inst_41617 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41614,inst_41616);
var state_41837__$1 = state_41837;
var statearr_41883_42072 = state_41837__$1;
(statearr_41883_42072[(2)] = inst_41617);

(statearr_41883_42072[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (116))){
var state_41837__$1 = state_41837;
var statearr_41884_42073 = state_41837__$1;
(statearr_41884_42073[(2)] = null);

(statearr_41884_42073[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (75))){
var inst_41678 = cljs.core.PersistentHashMap.EMPTY;
var state_41837__$1 = state_41837;
var statearr_41885_42074 = state_41837__$1;
(statearr_41885_42074[(2)] = inst_41678);

(statearr_41885_42074[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (99))){
var inst_41739 = (state_41837[(10)]);
var state_41837__$1 = state_41837;
var statearr_41886_42075 = state_41837__$1;
(statearr_41886_42075[(2)] = inst_41739);

(statearr_41886_42075[(1)] = (101));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (21))){
var inst_41530 = (state_41837[(18)]);
var inst_41547 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41548 = cljs.core.second(inst_41530);
var inst_41549 = cljs.core.first(inst_41530);
var inst_41550 = [inst_41548,inst_41549];
var inst_41551 = (new cljs.core.PersistentVector(null,2,(5),inst_41547,inst_41550,null));
var state_41837__$1 = state_41837;
var statearr_41887_42076 = state_41837__$1;
(statearr_41887_42076[(2)] = inst_41551);

(statearr_41887_42076[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (31))){
var inst_41605 = (state_41837[(27)]);
var inst_41605__$1 = typeof from === 'string';
var state_41837__$1 = (function (){var statearr_41888 = state_41837;
(statearr_41888[(27)] = inst_41605__$1);

return statearr_41888;
})();
if(cljs.core.truth_(inst_41605__$1)){
var statearr_41889_42077 = state_41837__$1;
(statearr_41889_42077[(1)] = (44));

} else {
var statearr_41890_42078 = state_41837__$1;
(statearr_41890_42078[(1)] = (45));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (113))){
var state_41837__$1 = state_41837;
var statearr_41891_42079 = state_41837__$1;
(statearr_41891_42079[(2)] = null);

(statearr_41891_42079[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (32))){
var inst_41576 = (state_41837[(17)]);
var inst_41810 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41892 = state_41837;
(statearr_41892[(28)] = inst_41810);

return statearr_41892;
})();
if(cljs.core.truth_(inst_41576)){
var statearr_41893_42080 = state_41837__$1;
(statearr_41893_42080[(1)] = (122));

} else {
var statearr_41894_42081 = state_41837__$1;
(statearr_41894_42081[(1)] = (123));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (40))){
var inst_41530 = (state_41837[(18)]);
var inst_41595 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41895 = state_41837;
(statearr_41895[(29)] = inst_41595);

return statearr_41895;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41896_42082 = state_41837__$1;
(statearr_41896_42082[(1)] = (41));

} else {
var statearr_41897_42083 = state_41837__$1;
(statearr_41897_42083[(1)] = (42));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (129))){
var inst_41818 = (state_41837[(30)]);
var state_41837__$1 = state_41837;
var statearr_41898_42084 = state_41837__$1;
(statearr_41898_42084[(2)] = inst_41818);

(statearr_41898_42084[(1)] = (130));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (91))){
var inst_41721 = cljs.core.every_QMARK_(fluree.db.util.core.subj_ident_QMARK_,from);
var state_41837__$1 = state_41837;
var statearr_41899_42085 = state_41837__$1;
(statearr_41899_42085[(2)] = inst_41721);

(statearr_41899_42085[(1)] = (93));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (117))){
var inst_41533 = (state_41837[(15)]);
var state_41837__$1 = state_41837;
var statearr_41900_42086 = state_41837__$1;
(statearr_41900_42086[(2)] = inst_41533);

(statearr_41900_42086[(1)] = (118));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (108))){
var inst_41760 = (state_41837[(2)]);
var inst_41761 = fluree.db.util.async.throw_err(inst_41760);
var state_41837__$1 = state_41837;
var statearr_41901_42087 = state_41837__$1;
(statearr_41901_42087[(2)] = inst_41761);

(statearr_41901_42087[(1)] = (104));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (56))){
var inst_41628 = cljs.core.PersistentHashMap.EMPTY;
var state_41837__$1 = state_41837;
var statearr_41902_42088 = state_41837__$1;
(statearr_41902_42088[(2)] = inst_41628);

(statearr_41902_42088[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (33))){
var state_41837__$1 = state_41837;
var statearr_41903_42089 = state_41837__$1;
(statearr_41903_42089[(2)] = from);

(statearr_41903_42089[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (13))){
var inst_41517 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_41518 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_query];
var inst_41519 = cljs.core.PersistentHashMap.fromArrays(inst_41517,inst_41518);
var inst_41520 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("Query missing :select or :selectOne.",inst_41519);
var inst_41521 = (function(){throw inst_41520})();
var state_41837__$1 = state_41837;
var statearr_41904_42090 = state_41837__$1;
(statearr_41904_42090[(2)] = inst_41521);

(statearr_41904_42090[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (22))){
var inst_41530 = (state_41837[(18)]);
var inst_41553 = typeof inst_41530 === 'string';
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41553)){
var statearr_41905_42091 = state_41837__$1;
(statearr_41905_42091[(1)] = (24));

} else {
var statearr_41906_42092 = state_41837__$1;
(statearr_41906_42092[(1)] = (25));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (90))){
var inst_41712 = (state_41837[(31)]);
var inst_41717 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41907 = state_41837;
(statearr_41907[(32)] = inst_41717);

return statearr_41907;
})();
var statearr_41908_42093 = state_41837__$1;
(statearr_41908_42093[(2)] = inst_41712);

(statearr_41908_42093[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (109))){
var inst_41739 = (state_41837[(10)]);
var inst_41763 = (state_41837[(23)]);
var inst_41765 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_41739,inst_41763);
var state_41837__$1 = state_41837;
var statearr_41909_42094 = state_41837__$1;
(statearr_41909_42094[(2)] = inst_41765);

(statearr_41909_42094[(1)] = (111));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (36))){
var inst_41530 = (state_41837[(18)]);
var inst_41590 = (state_41837[(2)]);
var inst_41591 = fluree.db.util.async.throw_err(inst_41590);
var state_41837__$1 = (function (){var statearr_41910 = state_41837;
(statearr_41910[(33)] = inst_41591);

return statearr_41910;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41911_42095 = state_41837__$1;
(statearr_41911_42095[(1)] = (38));

} else {
var statearr_41912_42096 = state_41837__$1;
(statearr_41912_42096[(1)] = (39));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (41))){
var state_41837__$1 = state_41837;
var statearr_41913_42097 = state_41837__$1;
(statearr_41913_42097[(2)] = null);

(statearr_41913_42097[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (118))){
var inst_41543 = (state_41837[(7)]);
var inst_41779 = (state_41837[(34)]);
var inst_41541 = (state_41837[(8)]);
var inst_41775 = (state_41837[(35)]);
var inst_41783 = (state_41837[(2)]);
var inst_41784 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41543,fuel,max_fuel,inst_41541,inst_41775,inst_41779,inst_41783);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(112),inst_41784);
} else {
if((state_val_41838 === (89))){
var state_41837__$1 = state_41837;
var statearr_41914_42098 = state_41837__$1;
(statearr_41914_42098[(2)] = null);

(statearr_41914_42098[(1)] = (90));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (100))){
var inst_41745 = (state_41837[(19)]);
var inst_41750 = cljs.core.int_QMARK_(inst_41745);
var state_41837__$1 = state_41837;
if(inst_41750){
var statearr_41915_42099 = state_41837__$1;
(statearr_41915_42099[(1)] = (102));

} else {
var statearr_41916_42100 = state_41837__$1;
(statearr_41916_42100[(1)] = (103));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (131))){
var inst_41815 = (state_41837[(11)]);
var inst_41829 = cljs.core.first(inst_41815);
var state_41837__$1 = state_41837;
var statearr_41917_42101 = state_41837__$1;
(statearr_41917_42101[(2)] = inst_41829);

(statearr_41917_42101[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (122))){
var inst_41533 = (state_41837[(15)]);
var inst_41810 = (state_41837[(28)]);
var inst_41577 = (state_41837[(16)]);
var inst_41531 = (state_41837[(14)]);
var inst_41576 = (state_41837[(17)]);
var inst_41812 = fluree.db.query.fql.sort_offset_and_limit_res(inst_41576,inst_41577,inst_41533,inst_41531,inst_41810);
var state_41837__$1 = state_41837;
var statearr_41918_42102 = state_41837__$1;
(statearr_41918_42102[(2)] = inst_41812);

(statearr_41918_42102[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (43))){
var inst_41543 = (state_41837[(7)]);
var inst_41595 = (state_41837[(29)]);
var inst_41541 = (state_41837[(8)]);
var inst_41591 = (state_41837[(33)]);
var inst_41599 = (state_41837[(2)]);
var inst_41600 = fluree.db.query.fql.subject_select.cljs$core$IFn$_invoke$arity$8(db,inst_41543,fuel,max_fuel,inst_41541,inst_41591,inst_41595,inst_41599);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(37),inst_41600);
} else {
if((state_val_41838 === (61))){
var inst_41650 = ["_tx",null,"_block",null];
var inst_41651 = (new cljs.core.PersistentArrayMap(null,2,inst_41650,null));
var inst_41652 = (new cljs.core.PersistentHashSet(null,inst_41651,null));
var inst_41653 = (inst_41652.cljs$core$IFn$_invoke$arity$1 ? inst_41652.cljs$core$IFn$_invoke$arity$1(from) : inst_41652.call(null,from));
var state_41837__$1 = state_41837;
var statearr_41919_42103 = state_41837__$1;
(statearr_41919_42103[(2)] = inst_41653);

(statearr_41919_42103[(1)] = (63));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (29))){
var inst_41565 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41920_42104 = state_41837__$1;
(statearr_41920_42104[(2)] = inst_41565);

(statearr_41920_42104[(1)] = (26));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (44))){
var inst_41607 = cljs.core.str.cljs$core$IFn$_invoke$arity$1(from);
var inst_41608 = clojure.string.includes_QMARK_(inst_41607,"/");
var state_41837__$1 = state_41837;
var statearr_41921_42105 = state_41837__$1;
(statearr_41921_42105[(2)] = inst_41608);

(statearr_41921_42105[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (93))){
var inst_41724 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41724)){
var statearr_41922_42106 = state_41837__$1;
(statearr_41922_42106[(1)] = (94));

} else {
var statearr_41923_42107 = state_41837__$1;
(statearr_41923_42107[(1)] = (95));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (6))){
var inst_41508 = (state_41837[(36)]);
var state_41837__$1 = state_41837;
var statearr_41924_42108 = state_41837__$1;
(statearr_41924_42108[(2)] = inst_41508);

(statearr_41924_42108[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (111))){
var inst_41746 = (state_41837[(37)]);
var inst_41768 = (state_41837[(2)]);
var inst_41738 = inst_41746;
var inst_41739 = inst_41768;
var state_41837__$1 = (function (){var statearr_41925 = state_41837;
(statearr_41925[(10)] = inst_41739);

(statearr_41925[(38)] = inst_41738);

return statearr_41925;
})();
var statearr_41926_42109 = state_41837__$1;
(statearr_41926_42109[(2)] = null);

(statearr_41926_42109[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (28))){
var state_41837__$1 = state_41837;
var statearr_41927_42110 = state_41837__$1;
(statearr_41927_42110[(2)] = null);

(statearr_41927_42110[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (64))){
var inst_41530 = (state_41837[(18)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41530)){
var statearr_41928_42111 = state_41837__$1;
(statearr_41928_42111[(1)] = (67));

} else {
var statearr_41929_42112 = state_41837__$1;
(statearr_41929_42112[(1)] = (68));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (103))){
var state_41837__$1 = state_41837;
if(cljs.core.truth_(fuel)){
var statearr_41930_42113 = state_41837__$1;
(statearr_41930_42113[(1)] = (105));

} else {
var statearr_41931_42114 = state_41837__$1;
(statearr_41931_42114[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (51))){
var inst_41614 = (state_41837[(26)]);
var state_41837__$1 = state_41837;
var statearr_41932_42115 = state_41837__$1;
(statearr_41932_42115[(2)] = inst_41614);

(statearr_41932_42115[(1)] = (52));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (25))){
var state_41837__$1 = state_41837;
var statearr_41933_42116 = state_41837__$1;
(statearr_41933_42116[(1)] = (27));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (34))){
var state_41837__$1 = state_41837;
var statearr_41935_42117 = state_41837__$1;
(statearr_41935_42117[(2)] = null);

(statearr_41935_42117[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (125))){
var inst_41818 = (state_41837[(30)]);
var inst_41815 = (state_41837[(11)]);
var inst_41818__$1 = cljs.core.coll_QMARK_(inst_41815);
var state_41837__$1 = (function (){var statearr_41936 = state_41837;
(statearr_41936[(30)] = inst_41818__$1);

return statearr_41936;
})();
if(inst_41818__$1){
var statearr_41937_42118 = state_41837__$1;
(statearr_41937_42118[(1)] = (128));

} else {
var statearr_41938_42119 = state_41837__$1;
(statearr_41938_42119[(1)] = (129));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (17))){
var inst_41530 = (state_41837[(18)]);
var inst_41541 = (state_41837[(2)]);
var inst_41542 = cljs.core.PersistentHashMap.EMPTY;
var inst_41543 = cljs.core.volatile_BANG_(inst_41542);
var state_41837__$1 = (function (){var statearr_41939 = state_41837;
(statearr_41939[(7)] = inst_41543);

(statearr_41939[(8)] = inst_41541);

return statearr_41939;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41940_42120 = state_41837__$1;
(statearr_41940_42120[(1)] = (18));

} else {
var statearr_41941_42121 = state_41837__$1;
(statearr_41941_42121[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (3))){
var inst_41835 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.return_chan(state_41837__$1,inst_41835);
} else {
if((state_val_41838 === (12))){
var inst_41514 = (state_41837[(39)]);
var state_41837__$1 = state_41837;
var statearr_41942_42122 = state_41837__$1;
(statearr_41942_42122[(2)] = inst_41514);

(statearr_41942_42122[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (2))){
var inst_41508 = (state_41837[(36)]);
var _ = (function (){var statearr_41943 = state_41837;
(statearr_41943[(4)] = cljs.core.cons((5),(state_41837[(4)])));

return statearr_41943;
})();
var inst_41508__$1 = select;
var state_41837__$1 = (function (){var statearr_41944 = state_41837;
(statearr_41944[(36)] = inst_41508__$1);

return statearr_41944;
})();
if(cljs.core.truth_(inst_41508__$1)){
var statearr_41945_42123 = state_41837__$1;
(statearr_41945_42123[(1)] = (6));

} else {
var statearr_41946_42124 = state_41837__$1;
(statearr_41946_42124[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (66))){
var inst_41806 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41947_42125 = state_41837__$1;
(statearr_41947_42125[(2)] = inst_41806);

(statearr_41947_42125[(1)] = (49));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (107))){
var inst_41745 = (state_41837[(19)]);
var inst_41757 = (state_41837[(2)]);
var inst_41758 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,inst_41745,false);
var state_41837__$1 = (function (){var statearr_41948 = state_41837;
(statearr_41948[(40)] = inst_41757);

return statearr_41948;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(108),inst_41758);
} else {
if((state_val_41838 === (23))){
var inst_41569 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41949_42126 = state_41837__$1;
(statearr_41949_42126[(2)] = inst_41569);

(statearr_41949_42126[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (47))){
var inst_41614 = cljs.core.map.cljs$core$IFn$_invoke$arity$1(fluree.db.query.fql.s);
var state_41837__$1 = (function (){var statearr_41950 = state_41837;
(statearr_41950[(26)] = inst_41614);

return statearr_41950;
})();
if(cljs.core.truth_(fuel)){
var statearr_41951_42127 = state_41837__$1;
(statearr_41951_42127[(1)] = (50));

} else {
var statearr_41952_42128 = state_41837__$1;
(statearr_41952_42128[(1)] = (51));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (35))){
var inst_41533 = (state_41837[(15)]);
var inst_41531 = (state_41837[(14)]);
var inst_41584 = (state_41837[(2)]);
var inst_41585 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41586 = [inst_41531,inst_41533];
var inst_41587 = cljs.core.PersistentHashMap.fromArrays(inst_41585,inst_41586);
var inst_41588 = fluree.db.query.fql.where_filter.cljs$core$IFn$_invoke$arity$4(db,where,inst_41584,inst_41587);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(36),inst_41588);
} else {
if((state_val_41838 === (127))){
var inst_41827 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41827)){
var statearr_41953_42129 = state_41837__$1;
(statearr_41953_42129[(1)] = (131));

} else {
var statearr_41954_42130 = state_41837__$1;
(statearr_41954_42130[(1)] = (132));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (82))){
var inst_41802 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41955_42131 = state_41837__$1;
(statearr_41955_42131[(2)] = inst_41802);

(statearr_41955_42131[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (76))){
var inst_41533 = (state_41837[(15)]);
var inst_41531 = (state_41837[(14)]);
var inst_41680 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41681 = [inst_41531,inst_41533];
var inst_41682 = cljs.core.PersistentHashMap.fromArrays(inst_41680,inst_41681);
var state_41837__$1 = state_41837;
var statearr_41956_42132 = state_41837__$1;
(statearr_41956_42132[(2)] = inst_41682);

(statearr_41956_42132[(1)] = (77));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (97))){
var inst_41745 = (state_41837[(19)]);
var inst_41738 = (state_41837[(38)]);
var inst_41744 = cljs.core.seq(inst_41738);
var inst_41745__$1 = cljs.core.first(inst_41744);
var inst_41746 = cljs.core.next(inst_41744);
var inst_41747 = cljs.core.not(inst_41745__$1);
var state_41837__$1 = (function (){var statearr_41957 = state_41837;
(statearr_41957[(37)] = inst_41746);

(statearr_41957[(19)] = inst_41745__$1);

return statearr_41957;
})();
if(inst_41747){
var statearr_41958_42133 = state_41837__$1;
(statearr_41958_42133[(1)] = (99));

} else {
var statearr_41959_42134 = state_41837__$1;
(statearr_41959_42134[(1)] = (100));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (19))){
var inst_41571 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_41572 = [null,null];
var inst_41573 = (new cljs.core.PersistentVector(null,2,(5),inst_41571,inst_41572,null));
var state_41837__$1 = state_41837;
var statearr_41960_42135 = state_41837__$1;
(statearr_41960_42135[(2)] = inst_41573);

(statearr_41960_42135[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (57))){
var inst_41533 = (state_41837[(15)]);
var inst_41531 = (state_41837[(14)]);
var inst_41630 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41631 = [inst_41531,inst_41533];
var inst_41632 = cljs.core.PersistentHashMap.fromArrays(inst_41630,inst_41631);
var state_41837__$1 = state_41837;
var statearr_41961_42136 = state_41837__$1;
(statearr_41961_42136[(2)] = inst_41632);

(statearr_41961_42136[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (68))){
var inst_41533 = (state_41837[(15)]);
var inst_41531 = (state_41837[(14)]);
var inst_41661 = [cljs.core.cst$kw$limit,cljs.core.cst$kw$offset];
var inst_41662 = [inst_41531,inst_41533];
var inst_41663 = cljs.core.PersistentHashMap.fromArrays(inst_41661,inst_41662);
var state_41837__$1 = state_41837;
var statearr_41962_42137 = state_41837__$1;
(statearr_41962_42137[(2)] = inst_41663);

(statearr_41962_42137[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (11))){
var inst_41525 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41963_42138 = state_41837__$1;
(statearr_41963_42138[(2)] = inst_41525);

(statearr_41963_42138[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (115))){
var inst_41530 = (state_41837[(18)]);
var inst_41779 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_41965 = state_41837;
(statearr_41965[(34)] = inst_41779);

return statearr_41965;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41966_42139 = state_41837__$1;
(statearr_41966_42139[(1)] = (116));

} else {
var statearr_41967_42140 = state_41837__$1;
(statearr_41967_42140[(1)] = (117));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (9))){
var inst_41511 = (state_41837[(12)]);
var state_41837__$1 = state_41837;
var statearr_41968_42141 = state_41837__$1;
(statearr_41968_42141[(2)] = inst_41511);

(statearr_41968_42141[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (5))){
var _ = (function (){var statearr_41969 = state_41837;
(statearr_41969[(4)] = cljs.core.rest((state_41837[(4)])));

return statearr_41969;
})();
var state_41837__$1 = state_41837;
var ex41964 = (state_41837__$1[(2)]);
var statearr_41970_42142 = state_41837__$1;
(statearr_41970_42142[(5)] = ex41964);


if((ex41964 instanceof Error)){
var statearr_41971_42143 = state_41837__$1;
(statearr_41971_42143[(1)] = (4));

(statearr_41971_42143[(5)] = null);

} else {
throw ex41964;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (112))){
var inst_41786 = (state_41837[(2)]);
var inst_41787 = fluree.db.util.async.throw_err(inst_41786);
var state_41837__$1 = state_41837;
var statearr_41972_42144 = state_41837__$1;
(statearr_41972_42144[(2)] = inst_41787);

(statearr_41972_42144[(1)] = (96));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (83))){
var inst_41700 = (state_41837[(20)]);
var inst_41699 = (state_41837[(2)]);
var inst_41700__$1 = fluree.db.util.async.throw_err(inst_41699);
var inst_41701 = (inst_41700__$1 == null);
var state_41837__$1 = (function (){var statearr_41973 = state_41837;
(statearr_41973[(20)] = inst_41700__$1);

return statearr_41973;
})();
if(cljs.core.truth_(inst_41701)){
var statearr_41974_42145 = state_41837__$1;
(statearr_41974_42145[(1)] = (84));

} else {
var statearr_41975_42146 = state_41837__$1;
(statearr_41975_42146[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (14))){
var inst_41523 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41976_42147 = state_41837__$1;
(statearr_41976_42147[(2)] = inst_41523);

(statearr_41976_42147[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (45))){
var inst_41605 = (state_41837[(27)]);
var state_41837__$1 = state_41837;
var statearr_41977_42148 = state_41837__$1;
(statearr_41977_42148[(2)] = inst_41605);

(statearr_41977_42148[(1)] = (46));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (53))){
var inst_41620 = (state_41837[(21)]);
var inst_41622 = cljs.core.distinct.cljs$core$IFn$_invoke$arity$0();
var inst_41623 = cljs.core.comp.cljs$core$IFn$_invoke$arity$2(inst_41620,inst_41622);
var state_41837__$1 = state_41837;
var statearr_41978_42149 = state_41837__$1;
(statearr_41978_42149[(2)] = inst_41623);

(statearr_41978_42149[(1)] = (55));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (78))){
var inst_41543 = (state_41837[(7)]);
var inst_41541 = (state_41837[(8)]);
var inst_41687 = (state_41837[(2)]);
var inst_41688 = fluree.db.util.async.throw_err(inst_41687);
var inst_41689 = fluree.db.query.fql.flake_select.cljs$core$IFn$_invoke$arity$6(db,inst_41543,fuel,max_fuel,inst_41541,inst_41688);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(79),inst_41689);
} else {
if((state_val_41838 === (132))){
var inst_41815 = (state_41837[(11)]);
var state_41837__$1 = state_41837;
var statearr_41979_42150 = state_41837__$1;
(statearr_41979_42150[(2)] = inst_41815);

(statearr_41979_42150[(1)] = (133));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (26))){
var inst_41567 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_41980_42151 = state_41837__$1;
(statearr_41980_42151[(2)] = inst_41567);

(statearr_41980_42151[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (123))){
var inst_41810 = (state_41837[(28)]);
var state_41837__$1 = state_41837;
var statearr_41981_42152 = state_41837__$1;
(statearr_41981_42152[(2)] = inst_41810);

(statearr_41981_42152[(1)] = (124));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (16))){
var inst_41534 = (state_41837[(24)]);
var state_41837__$1 = state_41837;
var statearr_41982_42153 = state_41837__$1;
(statearr_41982_42153[(2)] = inst_41534);

(statearr_41982_42153[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (133))){
var inst_41832 = (state_41837[(2)]);
var _ = (function (){var statearr_41983 = state_41837;
(statearr_41983[(4)] = cljs.core.rest((state_41837[(4)])));

return statearr_41983;
})();
var state_41837__$1 = state_41837;
var statearr_41984_42154 = state_41837__$1;
(statearr_41984_42154[(2)] = inst_41832);

(statearr_41984_42154[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (81))){
var inst_41719 = (state_41837[(22)]);
var inst_41719__$1 = cljs.core.sequential_QMARK_(from);
var state_41837__$1 = (function (){var statearr_41985 = state_41837;
(statearr_41985[(22)] = inst_41719__$1);

return statearr_41985;
})();
if(inst_41719__$1){
var statearr_41986_42155 = state_41837__$1;
(statearr_41986_42155[(1)] = (91));

} else {
var statearr_41987_42156 = state_41837__$1;
(statearr_41987_42156[(1)] = (92));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (120))){
var state_41837__$1 = state_41837;
var statearr_41988_42157 = state_41837__$1;
(statearr_41988_42157[(2)] = null);

(statearr_41988_42157[(1)] = (121));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (79))){
var inst_41691 = (state_41837[(2)]);
var inst_41692 = fluree.db.util.async.throw_err(inst_41691);
var state_41837__$1 = state_41837;
var statearr_41989_42158 = state_41837__$1;
(statearr_41989_42158[(2)] = inst_41692);

(statearr_41989_42158[(1)] = (74));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (38))){
var state_41837__$1 = state_41837;
var statearr_41990_42159 = state_41837__$1;
(statearr_41990_42159[(2)] = null);

(statearr_41990_42159[(1)] = (40));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (126))){
var inst_41816 = (state_41837[(41)]);
var state_41837__$1 = state_41837;
var statearr_41991_42160 = state_41837__$1;
(statearr_41991_42160[(2)] = inst_41816);

(statearr_41991_42160[(1)] = (127));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (98))){
var inst_41530 = (state_41837[(18)]);
var inst_41773 = (state_41837[(2)]);
var inst_41774 = cljs.core.PersistentVector.EMPTY;
var inst_41775 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_41774,inst_41773);
var state_41837__$1 = (function (){var statearr_41992 = state_41837;
(statearr_41992[(35)] = inst_41775);

return statearr_41992;
})();
if(cljs.core.truth_(inst_41530)){
var statearr_41993_42161 = state_41837__$1;
(statearr_41993_42161[(1)] = (113));

} else {
var statearr_41994_42162 = state_41837__$1;
(statearr_41994_42162[(1)] = (114));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (124))){
var inst_41816 = (state_41837[(41)]);
var inst_41815 = (state_41837[(2)]);
var inst_41816__$1 = selectOne;
var state_41837__$1 = (function (){var statearr_41995 = state_41837;
(statearr_41995[(11)] = inst_41815);

(statearr_41995[(41)] = inst_41816__$1);

return statearr_41995;
})();
if(cljs.core.truth_(inst_41816__$1)){
var statearr_41996_42163 = state_41837__$1;
(statearr_41996_42163[(1)] = (125));

} else {
var statearr_41997_42164 = state_41837__$1;
(statearr_41997_42164[(1)] = (126));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (87))){
var inst_41711 = (state_41837[(2)]);
var inst_41712 = fluree.db.util.async.throw_err(inst_41711);
var state_41837__$1 = (function (){var statearr_41998 = state_41837;
(statearr_41998[(31)] = inst_41712);

return statearr_41998;
})();
if(cljs.core.truth_(fuel)){
var statearr_41999_42165 = state_41837__$1;
(statearr_41999_42165[(1)] = (88));

} else {
var statearr_42000_42166 = state_41837__$1;
(statearr_42000_42166[(1)] = (89));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (30))){
var inst_41580 = typeof from === 'string';
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41580)){
var statearr_42001_42167 = state_41837__$1;
(statearr_42001_42167[(1)] = (33));

} else {
var statearr_42002_42168 = state_41837__$1;
(statearr_42002_42168[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (73))){
var inst_41694 = fluree.db.util.core.subj_ident_QMARK_(from);
var state_41837__$1 = state_41837;
if(inst_41694){
var statearr_42003_42169 = state_41837__$1;
(statearr_42003_42169[(1)] = (80));

} else {
var statearr_42004_42170 = state_41837__$1;
(statearr_42004_42170[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (96))){
var inst_41800 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_42005_42171 = state_41837__$1;
(statearr_42005_42171[(2)] = inst_41800);

(statearr_42005_42171[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (10))){
var inst_41514 = (state_41837[(39)]);
var inst_41514__$1 = selectDistinct;
var state_41837__$1 = (function (){var statearr_42006 = state_41837;
(statearr_42006[(39)] = inst_41514__$1);

return statearr_42006;
})();
if(cljs.core.truth_(inst_41514__$1)){
var statearr_42007_42172 = state_41837__$1;
(statearr_42007_42172[(1)] = (12));

} else {
var statearr_42008_42173 = state_41837__$1;
(statearr_42008_42173[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (18))){
var inst_41530 = (state_41837[(18)]);
var inst_41545 = cljs.core.vector_QMARK_(inst_41530);
var state_41837__$1 = state_41837;
if(inst_41545){
var statearr_42009_42174 = state_41837__$1;
(statearr_42009_42174[(1)] = (21));

} else {
var statearr_42010_42175 = state_41837__$1;
(statearr_42010_42175[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (105))){
var inst_41754 = fluree.db.query.fql.vswap_BANG_.cljs$core$IFn$_invoke$arity$2(fuel,cljs.core.inc);
var state_41837__$1 = state_41837;
var statearr_42011_42176 = state_41837__$1;
(statearr_42011_42176[(2)] = inst_41754);

(statearr_42011_42176[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (52))){
var inst_41620 = (state_41837[(2)]);
var state_41837__$1 = (function (){var statearr_42012 = state_41837;
(statearr_42012[(21)] = inst_41620);

return statearr_42012;
})();
var statearr_42013_42177 = state_41837__$1;
(statearr_42013_42177[(1)] = (53));



return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (114))){
var inst_41531 = (state_41837[(14)]);
var state_41837__$1 = state_41837;
var statearr_42015_42178 = state_41837__$1;
(statearr_42015_42178[(2)] = inst_41531);

(statearr_42015_42178[(1)] = (115));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (67))){
var inst_41659 = cljs.core.PersistentHashMap.EMPTY;
var state_41837__$1 = state_41837;
var statearr_42016_42179 = state_41837__$1;
(statearr_42016_42179[(2)] = inst_41659);

(statearr_42016_42179[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (71))){
var inst_41672 = (state_41837[(2)]);
var inst_41673 = fluree.db.util.async.throw_err(inst_41672);
var state_41837__$1 = state_41837;
var statearr_42017_42180 = state_41837__$1;
(statearr_42017_42180[(2)] = inst_41673);

(statearr_42017_42180[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (42))){
var inst_41533 = (state_41837[(15)]);
var state_41837__$1 = state_41837;
var statearr_42018_42181 = state_41837__$1;
(statearr_42018_42181[(2)] = inst_41533);

(statearr_42018_42181[(1)] = (43));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (80))){
var inst_41697 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$3(db,from,false);
var state_41837__$1 = state_41837;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_41837__$1,(83),inst_41697);
} else {
if((state_val_41838 === (37))){
var inst_41602 = (state_41837[(2)]);
var inst_41603 = fluree.db.util.async.throw_err(inst_41602);
var state_41837__$1 = state_41837;
var statearr_42019_42182 = state_41837__$1;
(statearr_42019_42182[(2)] = inst_41603);

(statearr_42019_42182[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (63))){
var inst_41656 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
if(cljs.core.truth_(inst_41656)){
var statearr_42020_42183 = state_41837__$1;
(statearr_42020_42183[(1)] = (64));

} else {
var statearr_42021_42184 = state_41837__$1;
(statearr_42021_42184[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (94))){
var inst_41733 = from;
var inst_41734 = cljs.core.seq(inst_41733);
var inst_41735 = cljs.core.first(inst_41734);
var inst_41736 = cljs.core.next(inst_41734);
var inst_41737 = cljs.core.PersistentVector.EMPTY;
var inst_41738 = inst_41733;
var inst_41739 = inst_41737;
var state_41837__$1 = (function (){var statearr_42022 = state_41837;
(statearr_42022[(42)] = inst_41736);

(statearr_42022[(10)] = inst_41739);

(statearr_42022[(43)] = inst_41735);

(statearr_42022[(38)] = inst_41738);

return statearr_42022;
})();
var statearr_42023_42185 = state_41837__$1;
(statearr_42023_42185[(2)] = null);

(statearr_42023_42185[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (8))){
var inst_41532 = (state_41837[(25)]);
var inst_41527 = (state_41837[(2)]);
var inst_41528 = opts_SINGLEQUOTE_;
var inst_41529 = cljs.core.__destructure_map(inst_41528);
var inst_41530 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41529,cljs.core.cst$kw$orderBy);
var inst_41531 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41529,cljs.core.cst$kw$limit);
var inst_41532__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41529,cljs.core.cst$kw$component);
var inst_41533 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_41529,cljs.core.cst$kw$offset);
var inst_41534 = fluree.db.query.fql_parser.parse_db(db,inst_41527,opts_SINGLEQUOTE_);
var inst_41535 = (inst_41532__$1 == null);
var inst_41536 = cljs.core.not(inst_41535);
var state_41837__$1 = (function (){var statearr_42024 = state_41837;
(statearr_42024[(15)] = inst_41533);

(statearr_42024[(18)] = inst_41530);

(statearr_42024[(24)] = inst_41534);

(statearr_42024[(25)] = inst_41532__$1);

(statearr_42024[(14)] = inst_41531);

return statearr_42024;
})();
if(inst_41536){
var statearr_42025_42186 = state_41837__$1;
(statearr_42025_42186[(1)] = (15));

} else {
var statearr_42026_42187 = state_41837__$1;
(statearr_42026_42187[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (49))){
var inst_41808 = (state_41837[(2)]);
var state_41837__$1 = state_41837;
var statearr_42027_42188 = state_41837__$1;
(statearr_42027_42188[(2)] = inst_41808);

(statearr_42027_42188[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_41838 === (84))){
var state_41837__$1 = state_41837;
var statearr_42028_42189 = state_41837__$1;
(statearr_42028_42189[(2)] = null);

(statearr_42028_42189[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$fql$query_$_state_machine__16395__auto__ = null;
var fluree$db$query$fql$query_$_state_machine__16395__auto____0 = (function (){
var statearr_42029 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_42029[(0)] = fluree$db$query$fql$query_$_state_machine__16395__auto__);

(statearr_42029[(1)] = (1));

return statearr_42029;
});
var fluree$db$query$fql$query_$_state_machine__16395__auto____1 = (function (state_41837){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_41837);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e42030){var ex__16398__auto__ = e42030;
var statearr_42031_42190 = state_41837;
(statearr_42031_42190[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_41837[(4)]))){
var statearr_42032_42191 = state_41837;
(statearr_42032_42191[(1)] = cljs.core.first((state_41837[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__42192 = state_41837;
state_41837 = G__42192;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$fql$query_$_state_machine__16395__auto__ = function(state_41837){
switch(arguments.length){
case 0:
return fluree$db$query$fql$query_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$fql$query_$_state_machine__16395__auto____1.call(this,state_41837);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$fql$query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$fql$query_$_state_machine__16395__auto____0;
fluree$db$query$fql$query_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$fql$query_$_state_machine__16395__auto____1;
return fluree$db$query$fql$query_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_42033 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_42033[(6)] = c__16469__auto__);

return statearr_42033;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}

});
