// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.query.range');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.dbproto');
goog.require('fluree.db.constants');
goog.require('fluree.db.util.core');
goog.require('fluree.db.util.json');
goog.require('fluree.db.flake');
goog.require('cljs.core.async');
goog.require('fluree.db.permissions_validate');
goog.require('fluree.db.util.async');
/**
 * Checks whether an index range is :spot, starts with [s1 -1 o1] and ends with [s1 int/max p1]
 */
fluree.db.query.range.value_with_nil_pred = (function fluree$db$query$range$value_with_nil_pred(idx,start_flake,end_flake){
return ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$spot,idx)) && ((((!((start_flake.o == null)))) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(start_flake.o,end_flake.o)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),start_flake.p)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.MAX_PREDICATE_ID,end_flake.p)))))))));
});
/**
 * Will throw if predicate doesn't exist.
 */
fluree.db.query.range.pred_id_strict = (function fluree$db$query$range$pred_id_strict(db,p){
if(cljs.core.truth_(p)){
var or__4212__auto__ = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Invalid predicate, does not exist: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(p)].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(400),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_invalid_DASH_predicate], null));
}
} else {
return null;
}
});
/**
 * Takes a match from index-range, and based on the index
 *   returns flake-ordered components of [s p o t op m].
 *   Coerces idents and string predicate names.
 */
fluree.db.query.range.match__GT_flake_parts = (function fluree$db$query$range$match__GT_flake_parts(db,idx,match){
var vec__29441 = match;
var p1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(0),null);
var p2 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(1),null);
var p3 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(2),null);
var t = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(3),null);
var op = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(4),null);
var m = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29441,(5),null);
var G__29444 = idx;
var G__29444__$1 = (((G__29444 instanceof cljs.core.Keyword))?G__29444.fqn:null);
switch (G__29444__$1) {
case "spot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p3,t,op,m], null);

break;
case "psot":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p2,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p3,t,op,m], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p1),p2,t,op,m], null);

break;
case "opst":
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [p3,fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$id,p2),p1,t,op,m], null);

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29444__$1)].join('')));

}
});
fluree.db.query.range.subject_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.max_long], null);
fluree.db.query.range.subject_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null);
fluree.db.query.range.pred_min_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);
fluree.db.query.range.pred_max_match = new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.flake.MAX_PREDICATE_ID], null);
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.min_match = (function fluree$db$query$range$min_match(idx){
var G__29446 = idx;
var G__29446__$1 = (((G__29446 instanceof cljs.core.Keyword))?G__29446.fqn:null);
switch (G__29446__$1) {
case "spot":
return fluree.db.query.range.subject_min_match;

break;
case "psot":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "post":
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null);

break;
case "opst":
return fluree.db.query.range.subject_min_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29446__$1)].join('')));

}
});
/**
 * Smallest index flake part match by index
 */
fluree.db.query.range.max_match = (function fluree$db$query$range$max_match(idx){
var G__29448 = idx;
var G__29448__$1 = (((G__29448 instanceof cljs.core.Keyword))?G__29448.fqn:null);
switch (G__29448__$1) {
case "spot":
return fluree.db.query.range.subject_max_match;

break;
case "psot":
return fluree.db.query.range.pred_max_match;

break;
case "post":
return fluree.db.query.range.pred_max_match;

break;
case "opst":
return fluree.db.query.range.subject_max_match;

break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__29448__$1)].join('')));

}
});
/**
 * Range query across an index.
 * 
 *   Uses a DB, but in the future support supplying a connection and db name, as we don't need a 't'
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :from-t - start transaction (transaction 't' is negative, so smallest number is most recent). Defaults to db's t
 *   :to-t - stop transaction - can be null, which pulls full history
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.time_range = (function fluree$db$query$range$time_range(var_args){
var G__29451 = arguments.length;
switch (G__29451) {
case 2:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__29452 = (function (){var pred__29455 = cljs.core.identical_QMARK_;
var expr__29456 = test;
if(cljs.core.truth_((pred__29455.cljs$core$IFn$_invoke$arity$2 ? pred__29455.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__29456) : pred__29455.call(null,cljs.core._EQ_,expr__29456)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29455.cljs$core$IFn$_invoke$arity$2 ? pred__29455.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__29456) : pred__29455.call(null,cljs.core._LT_,expr__29456)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__29455.cljs$core$IFn$_invoke$arity$2 ? pred__29455.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__29456) : pred__29455.call(null,cljs.core._LT__EQ_,expr__29456)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__29455.cljs$core$IFn$_invoke$arity$2 ? pred__29455.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__29456) : pred__29455.call(null,cljs.core._GT_,expr__29456)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__29455.cljs$core$IFn$_invoke$arity$2 ? pred__29455.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__29456) : pred__29455.call(null,cljs.core._GT__EQ_,expr__29456)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__29456)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29452,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29452,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29452,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__29452,(3),null);
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.time_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_29695){
var state_val_29696 = (state_29695[(1)]);
if((state_val_29696 === (65))){
var inst_29666 = (state_29695[(7)]);
var inst_29610 = (state_29695[(8)]);
var inst_29666__$1 = (state_29695[(2)]);
var inst_29667 = cljs.core.count(inst_29666__$1);
var state_29695__$1 = (function (){var statearr_29697 = state_29695;
(statearr_29697[(7)] = inst_29666__$1);

(statearr_29697[(9)] = inst_29667);

return statearr_29697;
})();
if(cljs.core.truth_(inst_29610)){
var statearr_29698_29835 = state_29695__$1;
(statearr_29698_29835[(1)] = (81));

} else {
var statearr_29699_29836 = state_29695__$1;
(statearr_29699_29836[(1)] = (82));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (70))){
var inst_29641 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29641)){
var statearr_29700_29837 = state_29695__$1;
(statearr_29700_29837[(1)] = (71));

} else {
var statearr_29701_29838 = state_29695__$1;
(statearr_29701_29838[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (62))){
var inst_29580 = (state_29695[(10)]);
var inst_29594 = (state_29695[(11)]);
var inst_29609 = (state_29695[(2)]);
var inst_29610 = fluree.db.dbproto._rhs(inst_29594);
var state_29695__$1 = (function (){var statearr_29702 = state_29695;
(statearr_29702[(12)] = inst_29609);

(statearr_29702[(8)] = inst_29610);

return statearr_29702;
})();
if(cljs.core.truth_(inst_29580)){
var statearr_29703_29839 = state_29695__$1;
(statearr_29703_29839[(1)] = (63));

} else {
var statearr_29704_29840 = state_29695__$1;
(statearr_29704_29840[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (74))){
var inst_29634 = (state_29695[(13)]);
var inst_29648 = fluree.db.permissions_validate.allow_flake_QMARK_.cljs$core$IFn$_invoke$arity$2(db,inst_29634);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(77),inst_29648);
} else {
if((state_val_29696 === (7))){
var inst_29471 = (state_29695[(14)]);
var state_29695__$1 = state_29695;
var statearr_29705_29841 = state_29695__$1;
(statearr_29705_29841[(2)] = inst_29471);

(statearr_29705_29841[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (59))){
var inst_29557 = (state_29695[(15)]);
var inst_29556 = (state_29695[(16)]);
var inst_29601 = (state_29695[(17)]);
var inst_29600 = (state_29695[(2)]);
var inst_29601__$1 = fluree.db.util.async.throw_err(inst_29600);
var inst_29602 = fluree.db.flake.subrange(inst_29601__$1,start_test,inst_29556,end_test,inst_29557);
var inst_29603 = fluree.db.query.range.value_with_nil_pred(idx,inst_29556,inst_29557);
var state_29695__$1 = (function (){var statearr_29706 = state_29695;
(statearr_29706[(18)] = inst_29602);

(statearr_29706[(17)] = inst_29601__$1);

return statearr_29706;
})();
if(inst_29603){
var statearr_29707_29842 = state_29695__$1;
(statearr_29707_29842[(1)] = (60));

} else {
var statearr_29708_29843 = state_29695__$1;
(statearr_29708_29843[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (86))){
var inst_29675 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29709_29844 = state_29695__$1;
(statearr_29709_29844[(2)] = inst_29675);

(statearr_29709_29844[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (20))){
var inst_29520 = (state_29695[(19)]);
var inst_29472 = (state_29695[(20)]);
var inst_29519 = (state_29695[(2)]);
var inst_29520__$1 = (inst_29472 == null);
var state_29695__$1 = (function (){var statearr_29710 = state_29695;
(statearr_29710[(21)] = inst_29519);

(statearr_29710[(19)] = inst_29520__$1);

return statearr_29710;
})();
if(cljs.core.truth_(inst_29520__$1)){
var statearr_29711_29845 = state_29695__$1;
(statearr_29711_29845[(1)] = (22));

} else {
var statearr_29712_29846 = state_29695__$1;
(statearr_29712_29846[(1)] = (23));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (72))){
var inst_29627 = (state_29695[(22)]);
var inst_29645 = (inst_29627 + (1));
var inst_29646 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29695__$1 = (function (){var statearr_29713 = state_29695;
(statearr_29713[(23)] = inst_29645);

return statearr_29713;
})();
if(cljs.core.truth_(inst_29646)){
var statearr_29714_29847 = state_29695__$1;
(statearr_29714_29847[(1)] = (74));

} else {
var statearr_29715_29848 = state_29695__$1;
(statearr_29715_29848[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (58))){
var inst_29690 = (state_29695[(2)]);
var _ = (function (){var statearr_29716 = state_29695;
(statearr_29716[(4)] = cljs.core.rest((state_29695[(4)])));

return statearr_29716;
})();
var state_29695__$1 = state_29695;
var statearr_29717_29849 = state_29695__$1;
(statearr_29717_29849[(2)] = inst_29690);

(statearr_29717_29849[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (60))){
var inst_29528 = (state_29695[(24)]);
var inst_29546 = (state_29695[(25)]);
var inst_29474 = (state_29695[(26)]);
var inst_29596 = (state_29695[(27)]);
var inst_29475 = (state_29695[(28)]);
var inst_29477 = (state_29695[(29)]);
var inst_29501 = (state_29695[(30)]);
var inst_29567 = (state_29695[(31)]);
var inst_29589 = (state_29695[(32)]);
var inst_29562 = (state_29695[(33)]);
var inst_29537 = (state_29695[(34)]);
var inst_29470 = (state_29695[(35)]);
var inst_29519 = (state_29695[(21)]);
var inst_29482 = (state_29695[(36)]);
var inst_29563 = (state_29695[(37)]);
var inst_29573 = (state_29695[(38)]);
var inst_29580 = (state_29695[(10)]);
var inst_29557 = (state_29695[(15)]);
var inst_29574 = (state_29695[(39)]);
var inst_29492 = (state_29695[(40)]);
var inst_29594 = (state_29695[(11)]);
var inst_29556 = (state_29695[(16)]);
var inst_29595 = (state_29695[(41)]);
var inst_29481 = (state_29695[(42)]);
var inst_29602 = (state_29695[(18)]);
var inst_29601 = (state_29695[(17)]);
var inst_29584 = (state_29695[(43)]);
var inst_29555 = (state_29695[(44)]);
var inst_29510 = (state_29695[(45)]);
var inst_29605 = (function (){var no_filter_QMARK_ = inst_29580;
var next_node = inst_29594;
var flakes = inst_29601;
var s1 = inst_29492;
var o2 = inst_29519;
var t1 = inst_29474;
var i = inst_29595;
var m1 = inst_29546;
var root_node = inst_29589;
var to_t = inst_29574;
var s2 = inst_29501;
var p2 = inst_29537;
var permissions = inst_29563;
var limit = inst_29562;
var start_flake = inst_29556;
var acc = inst_29596;
var t2 = inst_29481;
var op1 = inst_29475;
var o1 = inst_29510;
var end_flake = inst_29557;
var base_result = inst_29602;
var p1 = inst_29528;
var idx_compare = inst_29567;
var op2 = inst_29482;
var from_t = inst_29573;
var m2 = inst_29555;
var vec__29464 = inst_29470;
var vec__29467 = inst_29477;
var novelty = inst_29584;
return (function (filtered_result,f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.o,start_flake.o)){
return filtered_result;
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(filtered_result,f);
}
});
})();
var inst_29606 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_29605,inst_29602,inst_29602);
var state_29695__$1 = state_29695;
var statearr_29718_29850 = state_29695__$1;
(statearr_29718_29850[(2)] = inst_29606);

(statearr_29718_29850[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (27))){
var inst_29479 = (state_29695[(46)]);
var inst_29529 = (state_29695[(47)]);
var inst_29528 = (state_29695[(2)]);
var inst_29529__$1 = (inst_29479 == null);
var state_29695__$1 = (function (){var statearr_29719 = state_29695;
(statearr_29719[(24)] = inst_29528);

(statearr_29719[(47)] = inst_29529__$1);

return statearr_29719;
})();
if(cljs.core.truth_(inst_29529__$1)){
var statearr_29720_29851 = state_29695__$1;
(statearr_29720_29851[(1)] = (28));

} else {
var statearr_29721_29852 = state_29695__$1;
(statearr_29721_29852[(1)] = (29));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (1))){
var state_29695__$1 = state_29695;
var statearr_29722_29853 = state_29695__$1;
(statearr_29722_29853[(2)] = null);

(statearr_29722_29853[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (69))){
var inst_29627 = (state_29695[(22)]);
var inst_29562 = (state_29695[(33)]);
var inst_29639 = (inst_29627 > inst_29562);
var state_29695__$1 = state_29695;
var statearr_29723_29854 = state_29695__$1;
(statearr_29723_29854[(2)] = inst_29639);

(statearr_29723_29854[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (24))){
var inst_29524 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29524)){
var statearr_29724_29855 = state_29695__$1;
(statearr_29724_29855[(1)] = (25));

} else {
var statearr_29725_29856 = state_29695__$1;
(statearr_29725_29856[(1)] = (26));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (55))){
var inst_29589 = (state_29695[(32)]);
var inst_29556 = (state_29695[(16)]);
var inst_29588 = (state_29695[(2)]);
var inst_29589__$1 = fluree.db.util.async.throw_err(inst_29588);
var inst_29590 = fluree.db.dbproto._lookup_leaf(inst_29589__$1,inst_29556);
var state_29695__$1 = (function (){var statearr_29726 = state_29695;
(statearr_29726[(32)] = inst_29589__$1);

return statearr_29726;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(56),inst_29590);
} else {
if((state_val_29696 === (85))){
var inst_29670 = (state_29695[(48)]);
var state_29695__$1 = state_29695;
var statearr_29727_29857 = state_29695__$1;
(statearr_29727_29857[(2)] = inst_29670);

(statearr_29727_29857[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (39))){
var inst_29544 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29728_29858 = state_29695__$1;
(statearr_29728_29858[(2)] = inst_29544);

(statearr_29728_29858[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (88))){
var inst_29589 = (state_29695[(32)]);
var inst_29610 = (state_29695[(8)]);
var inst_29682 = fluree.db.dbproto._lookup_leaf(inst_29589,inst_29610);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(90),inst_29682);
} else {
if((state_val_29696 === (46))){
var inst_29558 = (state_29695[(49)]);
var state_29695__$1 = state_29695;
var statearr_29729_29859 = state_29695__$1;
(statearr_29729_29859[(2)] = inst_29558);

(statearr_29729_29859[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (4))){
var inst_29458 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29730_29860 = state_29695__$1;
(statearr_29730_29860[(2)] = inst_29458);

(statearr_29730_29860[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (77))){
var inst_29650 = (state_29695[(2)]);
var inst_29651 = fluree.db.util.async.throw_err(inst_29650);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29651)){
var statearr_29731_29861 = state_29695__$1;
(statearr_29731_29861[(1)] = (78));

} else {
var statearr_29732_29862 = state_29695__$1;
(statearr_29732_29862[(1)] = (79));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (54))){
var inst_29580 = (state_29695[(2)]);
var inst_29581 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29582 = [cljs.core.cst$kw$novelty,idx];
var inst_29583 = (new cljs.core.PersistentVector(null,2,(5),inst_29581,inst_29582,null));
var inst_29584 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29583);
var inst_29585 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_29586 = fluree.db.dbproto._resolve(inst_29585);
var state_29695__$1 = (function (){var statearr_29733 = state_29695;
(statearr_29733[(10)] = inst_29580);

(statearr_29733[(43)] = inst_29584);

return statearr_29733;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(55),inst_29586);
} else {
if((state_val_29696 === (15))){
var inst_29473 = (state_29695[(50)]);
var state_29695__$1 = state_29695;
var statearr_29734_29863 = state_29695__$1;
(statearr_29734_29863[(2)] = inst_29473);

(statearr_29734_29863[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (48))){
var inst_29568 = (state_29695[(51)]);
var inst_29562 = (state_29695[(2)]);
var inst_29563 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_29564 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29565 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_29566 = (new cljs.core.PersistentVector(null,3,(5),inst_29564,inst_29565,null));
var inst_29567 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_29566);
var inst_29568__$1 = cljs.core.cst$kw$from_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var state_29695__$1 = (function (){var statearr_29735 = state_29695;
(statearr_29735[(51)] = inst_29568__$1);

(statearr_29735[(31)] = inst_29567);

(statearr_29735[(33)] = inst_29562);

(statearr_29735[(37)] = inst_29563);

return statearr_29735;
})();
if(cljs.core.truth_(inst_29568__$1)){
var statearr_29736_29864 = state_29695__$1;
(statearr_29736_29864[(1)] = (49));

} else {
var statearr_29737_29865 = state_29695__$1;
(statearr_29737_29865[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (50))){
var inst_29571 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var state_29695__$1 = state_29695;
var statearr_29738_29866 = state_29695__$1;
(statearr_29738_29866[(2)] = inst_29571);

(statearr_29738_29866[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (75))){
var inst_29628 = (state_29695[(52)]);
var state_29695__$1 = state_29695;
var statearr_29739_29867 = state_29695__$1;
(statearr_29739_29867[(2)] = inst_29628);

(statearr_29739_29867[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (21))){
var inst_29515 = (state_29695[(2)]);
var inst_29516 = fluree.db.util.async.throw_err(inst_29515);
var state_29695__$1 = state_29695;
var statearr_29740_29868 = state_29695__$1;
(statearr_29740_29868[(2)] = inst_29516);

(statearr_29740_29868[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (31))){
var state_29695__$1 = state_29695;
var statearr_29741_29869 = state_29695__$1;
(statearr_29741_29869[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_29741_29869[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (32))){
var inst_29479 = (state_29695[(46)]);
var state_29695__$1 = state_29695;
var statearr_29742_29870 = state_29695__$1;
(statearr_29742_29870[(2)] = inst_29479);

(statearr_29742_29870[(1)] = (33));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (40))){
var inst_29483 = (state_29695[(53)]);
var state_29695__$1 = state_29695;
var statearr_29743_29871 = state_29695__$1;
(statearr_29743_29871[(2)] = inst_29483);

(statearr_29743_29871[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (56))){
var inst_29592 = (state_29695[(2)]);
var inst_29593 = fluree.db.util.async.throw_err(inst_29592);
var inst_29594 = inst_29593;
var inst_29595 = (0);
var inst_29596 = null;
var state_29695__$1 = (function (){var statearr_29744 = state_29695;
(statearr_29744[(27)] = inst_29596);

(statearr_29744[(11)] = inst_29594);

(statearr_29744[(41)] = inst_29595);

return statearr_29744;
})();
var statearr_29745_29872 = state_29695__$1;
(statearr_29745_29872[(2)] = null);

(statearr_29745_29872[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (33))){
var inst_29476 = (state_29695[(54)]);
var inst_29537 = (state_29695[(2)]);
var state_29695__$1 = (function (){var statearr_29746 = state_29695;
(statearr_29746[(34)] = inst_29537);

return statearr_29746;
})();
if(cljs.core.truth_(inst_29476)){
var statearr_29747_29873 = state_29695__$1;
(statearr_29747_29873[(1)] = (34));

} else {
var statearr_29748_29874 = state_29695__$1;
(statearr_29748_29874[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (13))){
var inst_29497 = (state_29695[(2)]);
var inst_29498 = fluree.db.util.async.throw_err(inst_29497);
var state_29695__$1 = state_29695;
var statearr_29749_29875 = state_29695__$1;
(statearr_29749_29875[(2)] = inst_29498);

(statearr_29749_29875[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (22))){
var inst_29510 = (state_29695[(45)]);
var state_29695__$1 = state_29695;
var statearr_29750_29876 = state_29695__$1;
(statearr_29750_29876[(2)] = inst_29510);

(statearr_29750_29876[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (90))){
var inst_29666 = (state_29695[(7)]);
var inst_29667 = (state_29695[(9)]);
var inst_29684 = (state_29695[(2)]);
var inst_29685 = fluree.db.util.async.throw_err(inst_29684);
var inst_29594 = inst_29685;
var inst_29595 = inst_29667;
var inst_29596 = inst_29666;
var state_29695__$1 = (function (){var statearr_29751 = state_29695;
(statearr_29751[(27)] = inst_29596);

(statearr_29751[(11)] = inst_29594);

(statearr_29751[(41)] = inst_29595);

return statearr_29751;
})();
var statearr_29752_29877 = state_29695__$1;
(statearr_29752_29877[(2)] = null);

(statearr_29752_29877[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (36))){
var inst_29483 = (state_29695[(53)]);
var inst_29546 = (state_29695[(2)]);
var state_29695__$1 = (function (){var statearr_29753 = state_29695;
(statearr_29753[(25)] = inst_29546);

return statearr_29753;
})();
if(cljs.core.truth_(inst_29483)){
var statearr_29754_29878 = state_29695__$1;
(statearr_29754_29878[(1)] = (40));

} else {
var statearr_29755_29879 = state_29695__$1;
(statearr_29755_29879[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (41))){
var inst_29549 = (cljs.core._LT__EQ_ === end_test);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29549)){
var statearr_29756_29880 = state_29695__$1;
(statearr_29756_29880[(1)] = (43));

} else {
var statearr_29757_29881 = state_29695__$1;
(statearr_29757_29881[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (89))){
var inst_29688 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29758_29882 = state_29695__$1;
(statearr_29758_29882[(2)] = inst_29688);

(statearr_29758_29882[(1)] = (58));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (43))){
var state_29695__$1 = state_29695;
var statearr_29759_29883 = state_29695__$1;
(statearr_29759_29883[(2)] = (2147483647));

(statearr_29759_29883[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (61))){
var inst_29602 = (state_29695[(18)]);
var state_29695__$1 = state_29695;
var statearr_29760_29884 = state_29695__$1;
(statearr_29760_29884[(2)] = inst_29602);

(statearr_29760_29884[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (29))){
var inst_29529 = (state_29695[(47)]);
var state_29695__$1 = state_29695;
var statearr_29761_29885 = state_29695__$1;
(statearr_29761_29885[(2)] = inst_29529);

(statearr_29761_29885[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (44))){
var state_29695__$1 = state_29695;
var statearr_29762_29886 = state_29695__$1;
(statearr_29762_29886[(2)] = fluree.db.util.core.min_integer);

(statearr_29762_29886[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (6))){
var inst_29471 = (state_29695[(14)]);
var inst_29486 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29471);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(9),inst_29486);
} else {
if((state_val_29696 === (28))){
var inst_29519 = (state_29695[(21)]);
var state_29695__$1 = state_29695;
var statearr_29763_29887 = state_29695__$1;
(statearr_29763_29887[(2)] = inst_29519);

(statearr_29763_29887[(1)] = (30));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (64))){
var inst_29609 = (state_29695[(12)]);
var inst_29595 = (state_29695[(41)]);
var inst_29623 = cljs.core.seq(inst_29609);
var inst_29624 = cljs.core.first(inst_29623);
var inst_29625 = cljs.core.next(inst_29623);
var inst_29626 = inst_29609;
var inst_29627 = inst_29595;
var inst_29628 = inst_29609;
var state_29695__$1 = (function (){var statearr_29764 = state_29695;
(statearr_29764[(22)] = inst_29627);

(statearr_29764[(55)] = inst_29624);

(statearr_29764[(52)] = inst_29628);

(statearr_29764[(56)] = inst_29625);

(statearr_29764[(57)] = inst_29626);

return statearr_29764;
})();
var statearr_29765_29888 = state_29695__$1;
(statearr_29765_29888[(2)] = null);

(statearr_29765_29888[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (51))){
var inst_29573 = (state_29695[(2)]);
var inst_29574 = cljs.core.cst$kw$to_DASH_t.cljs$core$IFn$_invoke$arity$1(opts);
var inst_29575 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_29695__$1 = (function (){var statearr_29766 = state_29695;
(statearr_29766[(38)] = inst_29573);

(statearr_29766[(39)] = inst_29574);

return statearr_29766;
})();
if(cljs.core.truth_(inst_29575)){
var statearr_29767_29889 = state_29695__$1;
(statearr_29767_29889[(1)] = (52));

} else {
var statearr_29768_29890 = state_29695__$1;
(statearr_29768_29890[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (25))){
var state_29695__$1 = state_29695;
var statearr_29769_29891 = state_29695__$1;
(statearr_29769_29891[(2)] = (-1));

(statearr_29769_29891[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (34))){
var inst_29476 = (state_29695[(54)]);
var state_29695__$1 = state_29695;
var statearr_29770_29892 = state_29695__$1;
(statearr_29770_29892[(2)] = inst_29476);

(statearr_29770_29892[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (17))){
var inst_29506 = (state_29695[(2)]);
var inst_29507 = fluree.db.util.async.throw_err(inst_29506);
var state_29695__$1 = state_29695;
var statearr_29771_29893 = state_29695__$1;
(statearr_29771_29893[(2)] = inst_29507);

(statearr_29771_29893[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (3))){
var inst_29693 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.return_chan(state_29695__$1,inst_29693);
} else {
if((state_val_29696 === (12))){
var inst_29473 = (state_29695[(50)]);
var inst_29501 = (state_29695[(2)]);
var inst_29502 = fluree.db.util.core.pred_ident_QMARK_(inst_29473);
var state_29695__$1 = (function (){var statearr_29772 = state_29695;
(statearr_29772[(30)] = inst_29501);

return statearr_29772;
})();
if(inst_29502){
var statearr_29773_29894 = state_29695__$1;
(statearr_29773_29894[(1)] = (14));

} else {
var statearr_29774_29895 = state_29695__$1;
(statearr_29774_29895[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (2))){
var inst_29477 = (state_29695[(29)]);
var inst_29470 = (state_29695[(35)]);
var inst_29471 = (state_29695[(14)]);
var _ = (function (){var statearr_29775 = state_29695;
(statearr_29775[(4)] = cljs.core.cons((5),(state_29695[(4)])));

return statearr_29775;
})();
var inst_29470__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_29471__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(0),null);
var inst_29472 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(1),null);
var inst_29473 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(2),null);
var inst_29474 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(3),null);
var inst_29475 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(4),null);
var inst_29476 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29470__$1,(5),null);
var inst_29477__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_29478 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(0),null);
var inst_29479 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(1),null);
var inst_29480 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(2),null);
var inst_29481 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(3),null);
var inst_29482 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(4),null);
var inst_29483 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_29477__$1,(5),null);
var inst_29484 = fluree.db.util.core.pred_ident_QMARK_(inst_29471__$1);
var state_29695__$1 = (function (){var statearr_29776 = state_29695;
(statearr_29776[(46)] = inst_29479);

(statearr_29776[(26)] = inst_29474);

(statearr_29776[(28)] = inst_29475);

(statearr_29776[(29)] = inst_29477__$1);

(statearr_29776[(54)] = inst_29476);

(statearr_29776[(35)] = inst_29470__$1);

(statearr_29776[(36)] = inst_29482);

(statearr_29776[(58)] = inst_29478);

(statearr_29776[(50)] = inst_29473);

(statearr_29776[(59)] = inst_29480);

(statearr_29776[(14)] = inst_29471__$1);

(statearr_29776[(53)] = inst_29483);

(statearr_29776[(42)] = inst_29481);

(statearr_29776[(20)] = inst_29472);

return statearr_29776;
})();
if(inst_29484){
var statearr_29777_29896 = state_29695__$1;
(statearr_29777_29896[(1)] = (6));

} else {
var statearr_29778_29897 = state_29695__$1;
(statearr_29778_29897[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (66))){
var inst_29636 = (state_29695[(60)]);
var inst_29634 = (state_29695[(13)]);
var inst_29626 = (state_29695[(57)]);
var inst_29633 = cljs.core.seq(inst_29626);
var inst_29634__$1 = cljs.core.first(inst_29633);
var inst_29635 = cljs.core.next(inst_29633);
var inst_29636__$1 = (inst_29634__$1 == null);
var state_29695__$1 = (function (){var statearr_29779 = state_29695;
(statearr_29779[(61)] = inst_29635);

(statearr_29779[(60)] = inst_29636__$1);

(statearr_29779[(13)] = inst_29634__$1);

return statearr_29779;
})();
if(cljs.core.truth_(inst_29636__$1)){
var statearr_29780_29898 = state_29695__$1;
(statearr_29780_29898[(1)] = (68));

} else {
var statearr_29781_29899 = state_29695__$1;
(statearr_29781_29899[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (23))){
var inst_29520 = (state_29695[(19)]);
var state_29695__$1 = state_29695;
var statearr_29782_29900 = state_29695__$1;
(statearr_29782_29900[(2)] = inst_29520);

(statearr_29782_29900[(1)] = (24));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (47))){
var state_29695__$1 = state_29695;
var statearr_29783_29901 = state_29695__$1;
(statearr_29783_29901[(2)] = fluree.db.util.core.max_long);

(statearr_29783_29901[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (35))){
var inst_29540 = (cljs.core._GT__EQ_ === start_test);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29540)){
var statearr_29784_29902 = state_29695__$1;
(statearr_29784_29902[(1)] = (37));

} else {
var statearr_29785_29903 = state_29695__$1;
(statearr_29785_29903[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (82))){
var inst_29610 = (state_29695[(8)]);
var state_29695__$1 = state_29695;
var statearr_29786_29904 = state_29695__$1;
(statearr_29786_29904[(2)] = inst_29610);

(statearr_29786_29904[(1)] = (83));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (76))){
var inst_29635 = (state_29695[(61)]);
var inst_29645 = (state_29695[(23)]);
var inst_29659 = (state_29695[(2)]);
var inst_29626 = inst_29635;
var inst_29627 = inst_29645;
var inst_29628 = inst_29659;
var state_29695__$1 = (function (){var statearr_29787 = state_29695;
(statearr_29787[(22)] = inst_29627);

(statearr_29787[(52)] = inst_29628);

(statearr_29787[(57)] = inst_29626);

return statearr_29787;
})();
var statearr_29788_29905 = state_29695__$1;
(statearr_29788_29905[(2)] = null);

(statearr_29788_29905[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (19))){
var inst_29480 = (state_29695[(59)]);
var state_29695__$1 = state_29695;
var statearr_29789_29906 = state_29695__$1;
(statearr_29789_29906[(2)] = inst_29480);

(statearr_29789_29906[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (57))){
var inst_29573 = (state_29695[(38)]);
var inst_29574 = (state_29695[(39)]);
var inst_29594 = (state_29695[(11)]);
var inst_29584 = (state_29695[(43)]);
var inst_29598 = fluree.db.dbproto._resolve_history_range.cljs$core$IFn$_invoke$arity$4(inst_29594,inst_29573,inst_29574,inst_29584);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(59),inst_29598);
} else {
if((state_val_29696 === (68))){
var inst_29636 = (state_29695[(60)]);
var state_29695__$1 = state_29695;
var statearr_29790_29907 = state_29695__$1;
(statearr_29790_29907[(2)] = inst_29636);

(statearr_29790_29907[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (11))){
var inst_29478 = (state_29695[(58)]);
var state_29695__$1 = state_29695;
var statearr_29792_29908 = state_29695__$1;
(statearr_29792_29908[(2)] = inst_29478);

(statearr_29792_29908[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (9))){
var inst_29488 = (state_29695[(2)]);
var inst_29489 = fluree.db.util.async.throw_err(inst_29488);
var state_29695__$1 = state_29695;
var statearr_29793_29909 = state_29695__$1;
(statearr_29793_29909[(2)] = inst_29489);

(statearr_29793_29909[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (5))){
var _ = (function (){var statearr_29794 = state_29695;
(statearr_29794[(4)] = cljs.core.rest((state_29695[(4)])));

return statearr_29794;
})();
var state_29695__$1 = state_29695;
var ex29791 = (state_29695__$1[(2)]);
var statearr_29795_29910 = state_29695__$1;
(statearr_29795_29910[(5)] = ex29791);


if((ex29791 instanceof Error)){
var statearr_29796_29911 = state_29695__$1;
(statearr_29796_29911[(1)] = (4));

(statearr_29796_29911[(5)] = null);

} else {
throw ex29791;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (83))){
var inst_29678 = (state_29695[(2)]);
var inst_29679 = cljs.core.not(inst_29678);
var state_29695__$1 = state_29695;
if(inst_29679){
var statearr_29797_29912 = state_29695__$1;
(statearr_29797_29912[(1)] = (87));

} else {
var statearr_29798_29913 = state_29695__$1;
(statearr_29798_29913[(1)] = (88));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (14))){
var inst_29473 = (state_29695[(50)]);
var inst_29504 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29473);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(17),inst_29504);
} else {
if((state_val_29696 === (45))){
var inst_29553 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29799_29914 = state_29695__$1;
(statearr_29799_29914[(2)] = inst_29553);

(statearr_29799_29914[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (53))){
var state_29695__$1 = state_29695;
var statearr_29800_29915 = state_29695__$1;
(statearr_29800_29915[(2)] = true);

(statearr_29800_29915[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (78))){
var inst_29628 = (state_29695[(52)]);
var state_29695__$1 = state_29695;
var statearr_29801_29916 = state_29695__$1;
(statearr_29801_29916[(2)] = inst_29628);

(statearr_29801_29916[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (26))){
var inst_29472 = (state_29695[(20)]);
var state_29695__$1 = state_29695;
var statearr_29802_29917 = state_29695__$1;
(statearr_29802_29917[(2)] = inst_29472);

(statearr_29802_29917[(1)] = (27));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (16))){
var inst_29480 = (state_29695[(59)]);
var inst_29510 = (state_29695[(2)]);
var inst_29511 = fluree.db.util.core.pred_ident_QMARK_(inst_29480);
var state_29695__$1 = (function (){var statearr_29803 = state_29695;
(statearr_29803[(45)] = inst_29510);

return statearr_29803;
})();
if(inst_29511){
var statearr_29804_29918 = state_29695__$1;
(statearr_29804_29918[(1)] = (18));

} else {
var statearr_29805_29919 = state_29695__$1;
(statearr_29805_29919[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (81))){
var inst_29567 = (state_29695[(31)]);
var inst_29557 = (state_29695[(15)]);
var inst_29670 = (state_29695[(48)]);
var inst_29610 = (state_29695[(8)]);
var inst_29669 = (inst_29567.cljs$core$IFn$_invoke$arity$2 ? inst_29567.cljs$core$IFn$_invoke$arity$2(inst_29610,inst_29557) : inst_29567.call(null,inst_29610,inst_29557));
var inst_29670__$1 = (inst_29669 < (0));
var state_29695__$1 = (function (){var statearr_29806 = state_29695;
(statearr_29806[(48)] = inst_29670__$1);

return statearr_29806;
})();
if(cljs.core.truth_(inst_29670__$1)){
var statearr_29807_29920 = state_29695__$1;
(statearr_29807_29920[(1)] = (84));

} else {
var statearr_29808_29921 = state_29695__$1;
(statearr_29808_29921[(1)] = (85));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (79))){
var inst_29628 = (state_29695[(52)]);
var inst_29634 = (state_29695[(13)]);
var inst_29654 = cljs.core.disj.cljs$core$IFn$_invoke$arity$2(inst_29628,inst_29634);
var state_29695__$1 = state_29695;
var statearr_29809_29922 = state_29695__$1;
(statearr_29809_29922[(2)] = inst_29654);

(statearr_29809_29922[(1)] = (80));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (38))){
var state_29695__$1 = state_29695;
var statearr_29810_29923 = state_29695__$1;
(statearr_29810_29923[(2)] = (2147483647));

(statearr_29810_29923[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (87))){
var inst_29666 = (state_29695[(7)]);
var state_29695__$1 = state_29695;
var statearr_29811_29924 = state_29695__$1;
(statearr_29811_29924[(2)] = inst_29666);

(statearr_29811_29924[(1)] = (89));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (30))){
var inst_29533 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
if(cljs.core.truth_(inst_29533)){
var statearr_29812_29925 = state_29695__$1;
(statearr_29812_29925[(1)] = (31));

} else {
var statearr_29813_29926 = state_29695__$1;
(statearr_29813_29926[(1)] = (32));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (73))){
var inst_29662 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29814_29927 = state_29695__$1;
(statearr_29814_29927[(2)] = inst_29662);

(statearr_29814_29927[(1)] = (67));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (10))){
var inst_29478 = (state_29695[(58)]);
var inst_29495 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29478);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(13),inst_29495);
} else {
if((state_val_29696 === (18))){
var inst_29480 = (state_29695[(59)]);
var inst_29513 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_29480);
var state_29695__$1 = state_29695;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_29695__$1,(21),inst_29513);
} else {
if((state_val_29696 === (52))){
var inst_29528 = (state_29695[(24)]);
var inst_29501 = (state_29695[(30)]);
var inst_29537 = (state_29695[(34)]);
var inst_29563 = (state_29695[(37)]);
var inst_29492 = (state_29695[(40)]);
var inst_29577 = fluree.db.permissions_validate.no_filter_QMARK_(inst_29563,inst_29492,inst_29501,inst_29528,inst_29537);
var state_29695__$1 = state_29695;
var statearr_29815_29928 = state_29695__$1;
(statearr_29815_29928[(2)] = inst_29577);

(statearr_29815_29928[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (67))){
var inst_29664 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29816_29929 = state_29695__$1;
(statearr_29816_29929[(2)] = inst_29664);

(statearr_29816_29929[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (71))){
var inst_29596 = (state_29695[(27)]);
var inst_29628 = (state_29695[(52)]);
var inst_29643 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29628,inst_29596);
var state_29695__$1 = state_29695;
var statearr_29817_29930 = state_29695__$1;
(statearr_29817_29930[(2)] = inst_29643);

(statearr_29817_29930[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (42))){
var inst_29528 = (state_29695[(24)]);
var inst_29546 = (state_29695[(25)]);
var inst_29474 = (state_29695[(26)]);
var inst_29475 = (state_29695[(28)]);
var inst_29558 = (state_29695[(49)]);
var inst_29501 = (state_29695[(30)]);
var inst_29537 = (state_29695[(34)]);
var inst_29519 = (state_29695[(21)]);
var inst_29482 = (state_29695[(36)]);
var inst_29492 = (state_29695[(40)]);
var inst_29481 = (state_29695[(42)]);
var inst_29555 = (state_29695[(44)]);
var inst_29510 = (state_29695[(45)]);
var inst_29555__$1 = (state_29695[(2)]);
var inst_29556 = fluree.db.flake.__GT_Flake(inst_29492,inst_29528,inst_29510,inst_29474,inst_29475,inst_29546);
var inst_29557 = fluree.db.flake.__GT_Flake(inst_29501,inst_29537,inst_29519,inst_29481,inst_29482,inst_29555__$1);
var inst_29558__$1 = cljs.core.cst$kw$limit.cljs$core$IFn$_invoke$arity$1(opts);
var state_29695__$1 = (function (){var statearr_29818 = state_29695;
(statearr_29818[(49)] = inst_29558__$1);

(statearr_29818[(15)] = inst_29557);

(statearr_29818[(16)] = inst_29556);

(statearr_29818[(44)] = inst_29555__$1);

return statearr_29818;
})();
if(cljs.core.truth_(inst_29558__$1)){
var statearr_29819_29931 = state_29695__$1;
(statearr_29819_29931[(1)] = (46));

} else {
var statearr_29820_29932 = state_29695__$1;
(statearr_29820_29932[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (80))){
var inst_29656 = (state_29695[(2)]);
var state_29695__$1 = state_29695;
var statearr_29821_29933 = state_29695__$1;
(statearr_29821_29933[(2)] = inst_29656);

(statearr_29821_29933[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (37))){
var state_29695__$1 = state_29695;
var statearr_29822_29934 = state_29695__$1;
(statearr_29822_29934[(2)] = fluree.db.util.core.min_integer);

(statearr_29822_29934[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (63))){
var inst_29609 = (state_29695[(12)]);
var inst_29596 = (state_29695[(27)]);
var inst_29562 = (state_29695[(33)]);
var inst_29595 = (state_29695[(41)]);
var inst_29612 = (inst_29562 - inst_29595);
var inst_29613 = fluree.db.flake.take(inst_29612,inst_29609);
var inst_29614 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29613,inst_29596);
var state_29695__$1 = state_29695;
var statearr_29823_29935 = state_29695__$1;
(statearr_29823_29935[(2)] = inst_29614);

(statearr_29823_29935[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (8))){
var inst_29478 = (state_29695[(58)]);
var inst_29492 = (state_29695[(2)]);
var inst_29493 = fluree.db.util.core.pred_ident_QMARK_(inst_29478);
var state_29695__$1 = (function (){var statearr_29824 = state_29695;
(statearr_29824[(40)] = inst_29492);

return statearr_29824;
})();
if(inst_29493){
var statearr_29825_29936 = state_29695__$1;
(statearr_29825_29936[(1)] = (10));

} else {
var statearr_29826_29937 = state_29695__$1;
(statearr_29826_29937[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (49))){
var inst_29568 = (state_29695[(51)]);
var state_29695__$1 = state_29695;
var statearr_29827_29938 = state_29695__$1;
(statearr_29827_29938[(2)] = inst_29568);

(statearr_29827_29938[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_29696 === (84))){
var inst_29562 = (state_29695[(33)]);
var inst_29667 = (state_29695[(9)]);
var inst_29672 = (inst_29667 < inst_29562);
var state_29695__$1 = state_29695;
var statearr_29828_29939 = state_29695__$1;
(statearr_29828_29939[(2)] = inst_29672);

(statearr_29828_29939[(1)] = (86));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_29829 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_29829[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_29829[(1)] = (1));

return statearr_29829;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_29695){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_29695);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e29830){var ex__16398__auto__ = e29830;
var statearr_29831_29940 = state_29695;
(statearr_29831_29940[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_29695[(4)]))){
var statearr_29832_29941 = state_29695;
(statearr_29832_29941[(1)] = cljs.core.first((state_29695[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__29942 = state_29695;
state_29695 = G__29942;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_29695){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_29695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_29833 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_29833[(6)] = c__16469__auto__);

return statearr_29833;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.time_range.cljs$lang$maxFixedArity = 7);

/**
 * Starting with flakes grouped by subject id, filters the flakes until
 *   either flake-limit or subject-limit reached.
 */
fluree.db.query.range.subject_groups__GT_allow_flakes = (function fluree$db$query$range$subject_groups__GT_allow_flakes(db,subject_groups,flake_start,subject_start,flake_limit,subject_limit){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30017){
var state_val_30018 = (state_30017[(1)]);
if((state_val_30018 === (7))){
var inst_30012 = (state_30017[(2)]);
var _ = (function (){var statearr_30019 = state_30017;
(statearr_30019[(4)] = cljs.core.rest((state_30017[(4)])));

return statearr_30019;
})();
var state_30017__$1 = state_30017;
var statearr_30020_30060 = state_30017__$1;
(statearr_30020_30060[(2)] = inst_30012);

(statearr_30020_30060[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (20))){
var inst_29994 = (state_30017[(2)]);
var inst_29995 = fluree.db.util.async.throw_err(inst_29994);
var state_30017__$1 = state_30017;
var statearr_30021_30061 = state_30017__$1;
(statearr_30021_30061[(2)] = inst_29995);

(statearr_30021_30061[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (1))){
var state_30017__$1 = state_30017;
var statearr_30022_30062 = state_30017__$1;
(statearr_30022_30062[(2)] = null);

(statearr_30022_30062[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (4))){
var inst_29943 = (state_30017[(2)]);
var state_30017__$1 = state_30017;
var statearr_30023_30063 = state_30017__$1;
(statearr_30023_30063[(2)] = inst_29943);

(statearr_30023_30063[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (15))){
var inst_29990 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30017__$1 = state_30017;
if(cljs.core.truth_(inst_29990)){
var statearr_30024_30064 = state_30017__$1;
(statearr_30024_30064[(1)] = (17));

} else {
var statearr_30025_30065 = state_30017__$1;
(statearr_30025_30065[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (21))){
var state_30017__$1 = state_30017;
var statearr_30026_30066 = state_30017__$1;
(statearr_30026_30066[(2)] = (0));

(statearr_30026_30066[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (13))){
var inst_29982 = (state_30017[(2)]);
var state_30017__$1 = state_30017;
var statearr_30027_30067 = state_30017__$1;
(statearr_30027_30067[(2)] = inst_29982);

(statearr_30027_30067[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (22))){
var state_30017__$1 = state_30017;
var statearr_30028_30068 = state_30017__$1;
(statearr_30028_30068[(2)] = (1));

(statearr_30028_30068[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (6))){
var inst_29972 = (state_30017[(7)]);
var inst_29974 = (state_30017[(8)]);
var inst_29963 = (state_30017[(9)]);
var inst_29971 = cljs.core.seq(inst_29963);
var inst_29972__$1 = cljs.core.first(inst_29971);
var inst_29973 = cljs.core.next(inst_29971);
var inst_29974__$1 = (inst_29972__$1 == null);
var state_30017__$1 = (function (){var statearr_30029 = state_30017;
(statearr_30029[(7)] = inst_29972__$1);

(statearr_30029[(8)] = inst_29974__$1);

(statearr_30029[(10)] = inst_29973);

return statearr_30029;
})();
if(cljs.core.truth_(inst_29974__$1)){
var statearr_30030_30069 = state_30017__$1;
(statearr_30030_30069[(1)] = (8));

} else {
var statearr_30031_30070 = state_30017__$1;
(statearr_30031_30070[(1)] = (9));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (17))){
var inst_29972 = (state_30017[(7)]);
var inst_29992 = fluree.db.permissions_validate.allow_flakes_QMARK_(db,inst_29972);
var state_30017__$1 = state_30017;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30017__$1,(20),inst_29992);
} else {
if((state_val_30018 === (3))){
var inst_30015 = (state_30017[(2)]);
var state_30017__$1 = state_30017;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30017__$1,inst_30015);
} else {
if((state_val_30018 === (12))){
var inst_29965 = (state_30017[(11)]);
var inst_29980 = (inst_29965 >= subject_limit);
var state_30017__$1 = state_30017;
var statearr_30032_30071 = state_30017__$1;
(statearr_30032_30071[(2)] = inst_29980);

(statearr_30032_30071[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (2))){
var _ = (function (){var statearr_30033 = state_30017;
(statearr_30033[(4)] = cljs.core.cons((5),(state_30017[(4)])));

return statearr_30033;
})();
var inst_29956 = subject_groups;
var inst_29957 = cljs.core.seq(inst_29956);
var inst_29958 = cljs.core.first(inst_29957);
var inst_29959 = cljs.core.next(inst_29957);
var inst_29960 = flake_start;
var inst_29961 = subject_start;
var inst_29962 = cljs.core.PersistentVector.EMPTY;
var inst_29963 = inst_29956;
var inst_29964 = inst_29960;
var inst_29965 = inst_29961;
var inst_29966 = inst_29962;
var state_30017__$1 = (function (){var statearr_30034 = state_30017;
(statearr_30034[(12)] = inst_29964);

(statearr_30034[(13)] = inst_29959);

(statearr_30034[(11)] = inst_29965);

(statearr_30034[(14)] = inst_29966);

(statearr_30034[(15)] = inst_29958);

(statearr_30034[(9)] = inst_29963);

return statearr_30034;
})();
var statearr_30035_30072 = state_30017__$1;
(statearr_30035_30072[(2)] = null);

(statearr_30035_30072[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (23))){
var inst_29964 = (state_30017[(12)]);
var inst_29999 = (state_30017[(16)]);
var inst_29965 = (state_30017[(11)]);
var inst_29998 = (state_30017[(17)]);
var inst_29966 = (state_30017[(14)]);
var inst_29973 = (state_30017[(10)]);
var inst_30004 = (state_30017[(2)]);
var inst_30005 = (inst_29964 + inst_29999);
var inst_30006 = (inst_29965 + inst_30004);
var inst_30007 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_29966,inst_29998);
var inst_29963 = inst_29973;
var inst_29964__$1 = inst_30005;
var inst_29965__$1 = inst_30006;
var inst_29966__$1 = inst_30007;
var state_30017__$1 = (function (){var statearr_30036 = state_30017;
(statearr_30036[(12)] = inst_29964__$1);

(statearr_30036[(11)] = inst_29965__$1);

(statearr_30036[(14)] = inst_29966__$1);

(statearr_30036[(9)] = inst_29963);

return statearr_30036;
})();
var statearr_30037_30073 = state_30017__$1;
(statearr_30037_30073[(2)] = null);

(statearr_30037_30073[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (19))){
var inst_29999 = (state_30017[(16)]);
var inst_29998 = (state_30017[(17)]);
var inst_29998__$1 = (state_30017[(2)]);
var inst_29999__$1 = cljs.core.count(inst_29998__$1);
var inst_30000 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_29999__$1);
var state_30017__$1 = (function (){var statearr_30038 = state_30017;
(statearr_30038[(16)] = inst_29999__$1);

(statearr_30038[(17)] = inst_29998__$1);

return statearr_30038;
})();
if(inst_30000){
var statearr_30039_30074 = state_30017__$1;
(statearr_30039_30074[(1)] = (21));

} else {
var statearr_30040_30075 = state_30017__$1;
(statearr_30040_30075[(1)] = (22));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (11))){
var inst_29977 = (state_30017[(18)]);
var state_30017__$1 = state_30017;
var statearr_30042_30076 = state_30017__$1;
(statearr_30042_30076[(2)] = inst_29977);

(statearr_30042_30076[(1)] = (13));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (9))){
var inst_29964 = (state_30017[(12)]);
var inst_29977 = (state_30017[(18)]);
var inst_29977__$1 = (inst_29964 >= flake_limit);
var state_30017__$1 = (function (){var statearr_30043 = state_30017;
(statearr_30043[(18)] = inst_29977__$1);

return statearr_30043;
})();
if(cljs.core.truth_(inst_29977__$1)){
var statearr_30044_30077 = state_30017__$1;
(statearr_30044_30077[(1)] = (11));

} else {
var statearr_30045_30078 = state_30017__$1;
(statearr_30045_30078[(1)] = (12));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (5))){
var _ = (function (){var statearr_30046 = state_30017;
(statearr_30046[(4)] = cljs.core.rest((state_30017[(4)])));

return statearr_30046;
})();
var state_30017__$1 = state_30017;
var ex30041 = (state_30017__$1[(2)]);
var statearr_30047_30079 = state_30017__$1;
(statearr_30047_30079[(5)] = ex30041);


if((ex30041 instanceof Error)){
var statearr_30048_30080 = state_30017__$1;
(statearr_30048_30080[(1)] = (4));

(statearr_30048_30080[(5)] = null);

} else {
throw ex30041;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (14))){
var inst_29964 = (state_30017[(12)]);
var inst_29965 = (state_30017[(11)]);
var inst_29966 = (state_30017[(14)]);
var inst_29986 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_29987 = [inst_29964,inst_29965,inst_29966];
var inst_29988 = (new cljs.core.PersistentVector(null,3,(5),inst_29986,inst_29987,null));
var state_30017__$1 = state_30017;
var statearr_30049_30081 = state_30017__$1;
(statearr_30049_30081[(2)] = inst_29988);

(statearr_30049_30081[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (16))){
var inst_30010 = (state_30017[(2)]);
var state_30017__$1 = state_30017;
var statearr_30050_30082 = state_30017__$1;
(statearr_30050_30082[(2)] = inst_30010);

(statearr_30050_30082[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (10))){
var inst_29984 = (state_30017[(2)]);
var state_30017__$1 = state_30017;
if(cljs.core.truth_(inst_29984)){
var statearr_30051_30083 = state_30017__$1;
(statearr_30051_30083[(1)] = (14));

} else {
var statearr_30052_30084 = state_30017__$1;
(statearr_30052_30084[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (18))){
var inst_29972 = (state_30017[(7)]);
var state_30017__$1 = state_30017;
var statearr_30053_30085 = state_30017__$1;
(statearr_30053_30085[(2)] = inst_29972);

(statearr_30053_30085[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30018 === (8))){
var inst_29974 = (state_30017[(8)]);
var state_30017__$1 = state_30017;
var statearr_30054_30086 = state_30017__$1;
(statearr_30054_30086[(2)] = inst_29974);

(statearr_30054_30086[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0 = (function (){
var statearr_30055 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30055[(0)] = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__);

(statearr_30055[(1)] = (1));

return statearr_30055;
});
var fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1 = (function (state_30017){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30017);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30056){var ex__16398__auto__ = e30056;
var statearr_30057_30087 = state_30017;
(statearr_30057_30087[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30017[(4)]))){
var statearr_30058_30088 = state_30017;
(statearr_30058_30088[(1)] = cljs.core.first((state_30017[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30089 = state_30017;
state_30017 = G__30089;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__ = function(state_30017){
switch(arguments.length){
case 0:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1.call(this,state_30017);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____0;
fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto____1;
return fluree$db$query$range$subject_groups__GT_allow_flakes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30059 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30059[(6)] = c__16469__auto__);

return statearr_30059;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.range.find_next_valid_node = (function fluree$db$query$range$find_next_valid_node(root_node,rhs,t,novelty,fast_forward_db_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30135){
var state_val_30136 = (state_30135[(1)]);
if((state_val_30136 === (7))){
var state_30135__$1 = state_30135;
var statearr_30137_30175 = state_30135__$1;
(statearr_30137_30175[(2)] = null);

(statearr_30137_30175[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (20))){
var inst_30121 = (state_30135[(2)]);
var inst_30122 = fluree.db.util.async.throw_err(inst_30121);
var inst_30100 = inst_30122;
var state_30135__$1 = (function (){var statearr_30138 = state_30135;
(statearr_30138[(7)] = inst_30100);

return statearr_30138;
})();
var statearr_30139_30176 = state_30135__$1;
(statearr_30139_30176[(2)] = null);

(statearr_30139_30176[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (1))){
var state_30135__$1 = state_30135;
var statearr_30140_30177 = state_30135__$1;
(statearr_30140_30177[(2)] = null);

(statearr_30140_30177[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (4))){
var inst_30090 = (state_30135[(2)]);
var state_30135__$1 = state_30135;
var statearr_30141_30178 = state_30135__$1;
(statearr_30141_30178[(2)] = inst_30090);

(statearr_30141_30178[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (15))){
var inst_30117 = (state_30135[(8)]);
var inst_30100 = (state_30135[(7)]);
var inst_30117__$1 = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(inst_30100);
var state_30135__$1 = (function (){var statearr_30142 = state_30135;
(statearr_30142[(8)] = inst_30117__$1);

return statearr_30142;
})();
if(cljs.core.truth_(inst_30117__$1)){
var statearr_30143_30179 = state_30135__$1;
(statearr_30143_30179[(1)] = (17));

} else {
var statearr_30144_30180 = state_30135__$1;
(statearr_30144_30180[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (13))){
var inst_30110 = (state_30135[(2)]);
var inst_30111 = fluree.db.util.async.throw_err(inst_30110);
var _ = (function (){var statearr_30145 = state_30135;
(statearr_30145[(4)] = cljs.core.rest((state_30135[(4)])));

return statearr_30145;
})();
var state_30135__$1 = state_30135;
var statearr_30146_30181 = state_30135__$1;
(statearr_30146_30181[(2)] = inst_30111);

(statearr_30146_30181[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (6))){
var inst_30098 = (state_30135[(2)]);
var inst_30099 = fluree.db.util.async.throw_err(inst_30098);
var inst_30100 = inst_30099;
var state_30135__$1 = (function (){var statearr_30147 = state_30135;
(statearr_30147[(7)] = inst_30100);

return statearr_30147;
})();
var statearr_30148_30182 = state_30135__$1;
(statearr_30148_30182[(2)] = null);

(statearr_30148_30182[(1)] = (7));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (17))){
var inst_30117 = (state_30135[(8)]);
var inst_30119 = fluree.db.dbproto._lookup_leaf(root_node,inst_30117);
var state_30135__$1 = state_30135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30135__$1,(20),inst_30119);
} else {
if((state_val_30136 === (3))){
var inst_30133 = (state_30135[(2)]);
var state_30135__$1 = state_30135;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30135__$1,inst_30133);
} else {
if((state_val_30136 === (12))){
var _ = (function (){var statearr_30150 = state_30135;
(statearr_30150[(4)] = cljs.core.rest((state_30135[(4)])));

return statearr_30150;
})();
var state_30135__$1 = state_30135;
var ex30149 = (state_30135__$1[(2)]);
var statearr_30151_30183 = state_30135__$1;
(statearr_30151_30183[(5)] = ex30149);


var statearr_30152_30184 = state_30135__$1;
(statearr_30152_30184[(1)] = (11));

(statearr_30152_30184[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (2))){
var _ = (function (){var statearr_30153 = state_30135;
(statearr_30153[(4)] = cljs.core.cons((5),(state_30135[(4)])));

return statearr_30153;
})();
var inst_30096 = fluree.db.dbproto._lookup_leaf(root_node,rhs);
var state_30135__$1 = state_30135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30135__$1,(6),inst_30096);
} else {
if((state_val_30136 === (19))){
var inst_30126 = (state_30135[(2)]);
var state_30135__$1 = state_30135;
var statearr_30154_30185 = state_30135__$1;
(statearr_30154_30185[(2)] = inst_30126);

(statearr_30154_30185[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (11))){
var inst_30102 = (state_30135[(2)]);
var state_30135__$1 = (function (){var statearr_30156 = state_30135;
(statearr_30156[(9)] = inst_30102);

return statearr_30156;
})();
var statearr_30157_30186 = state_30135__$1;
(statearr_30157_30186[(2)] = null);

(statearr_30157_30186[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (9))){
var inst_30100 = (state_30135[(7)]);
var _ = (function (){var statearr_30158 = state_30135;
(statearr_30158[(4)] = cljs.core.cons((12),(state_30135[(4)])));

return statearr_30158;
})();
var inst_30108 = fluree.db.dbproto._resolve_to_t.cljs$core$IFn$_invoke$arity$4(inst_30100,t,novelty,fast_forward_db_QMARK_);
var state_30135__$1 = state_30135;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30135__$1,(13),inst_30108);
} else {
if((state_val_30136 === (5))){
var _ = (function (){var statearr_30159 = state_30135;
(statearr_30159[(4)] = cljs.core.rest((state_30135[(4)])));

return statearr_30159;
})();
var state_30135__$1 = state_30135;
var ex30155 = (state_30135__$1[(2)]);
var statearr_30160_30187 = state_30135__$1;
(statearr_30160_30187[(5)] = ex30155);


if((ex30155 instanceof Error)){
var statearr_30161_30188 = state_30135__$1;
(statearr_30161_30188[(1)] = (4));

(statearr_30161_30188[(5)] = null);

} else {
throw ex30155;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (14))){
var inst_30114 = (state_30135[(10)]);
var state_30135__$1 = state_30135;
var statearr_30162_30189 = state_30135__$1;
(statearr_30162_30189[(2)] = inst_30114);

(statearr_30162_30189[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (16))){
var inst_30128 = (state_30135[(2)]);
var state_30135__$1 = state_30135;
var statearr_30163_30190 = state_30135__$1;
(statearr_30163_30190[(2)] = inst_30128);

(statearr_30163_30190[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (10))){
var inst_30114 = (state_30135[(10)]);
var inst_30114__$1 = (state_30135[(2)]);
var state_30135__$1 = (function (){var statearr_30164 = state_30135;
(statearr_30164[(10)] = inst_30114__$1);

return statearr_30164;
})();
if(cljs.core.truth_(inst_30114__$1)){
var statearr_30165_30191 = state_30135__$1;
(statearr_30165_30191[(1)] = (14));

} else {
var statearr_30166_30192 = state_30135__$1;
(statearr_30166_30192[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (18))){
var state_30135__$1 = state_30135;
var statearr_30167_30193 = state_30135__$1;
(statearr_30167_30193[(2)] = null);

(statearr_30167_30193[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30136 === (8))){
var inst_30130 = (state_30135[(2)]);
var _ = (function (){var statearr_30168 = state_30135;
(statearr_30168[(4)] = cljs.core.rest((state_30135[(4)])));

return statearr_30168;
})();
var state_30135__$1 = state_30135;
var statearr_30169_30194 = state_30135__$1;
(statearr_30169_30194[(2)] = inst_30130);

(statearr_30169_30194[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0 = (function (){
var statearr_30170 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_30170[(0)] = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__);

(statearr_30170[(1)] = (1));

return statearr_30170;
});
var fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1 = (function (state_30135){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30135);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30171){var ex__16398__auto__ = e30171;
var statearr_30172_30195 = state_30135;
(statearr_30172_30195[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30135[(4)]))){
var statearr_30173_30196 = state_30135;
(statearr_30173_30196[(1)] = cljs.core.first((state_30135[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30197 = state_30135;
state_30135 = G__30197;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__ = function(state_30135){
switch(arguments.length){
case 0:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1.call(this,state_30135);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____0;
fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto____1;
return fluree$db$query$range$find_next_valid_node_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30174 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30174[(6)] = c__16469__auto__);

return statearr_30174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Range query across an index as of a 't' defined by the db.
 * 
 *   Ranges take the natural numeric sort orders, but all results will
 *   return in reverse order (newest subjects and predicates first).
 * 
 *   Returns core async channel.
 * 
 *   opts:
 *   :xform - xform applied to each result individually. This is not used when :chan is supplied.
 *   :limit - max number of flakes to return
 */
fluree.db.query.range.index_range = (function fluree$db$query$range$index_range(var_args){
var G__30204 = arguments.length;
switch (G__30204) {
case 2:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
case 7:
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]),(arguments[(6)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$2 = (function (db,idx){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3(db,idx,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$3 = (function (db,idx,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,cljs.core._GT__EQ_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx),opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$4 = (function (db,idx,test,match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,idx,test,match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5 = (function (db,idx,test,match,opts){
var vec__30205 = (function (){var pred__30208 = cljs.core.identical_QMARK_;
var expr__30209 = test;
if(cljs.core.truth_((pred__30208.cljs$core$IFn$_invoke$arity$2 ? pred__30208.cljs$core$IFn$_invoke$arity$2(cljs.core._EQ_,expr__30209) : pred__30208.call(null,cljs.core._EQ_,expr__30209)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30208.cljs$core$IFn$_invoke$arity$2 ? pred__30208.cljs$core$IFn$_invoke$arity$2(cljs.core._LT_,expr__30209) : pred__30208.call(null,cljs.core._LT_,expr__30209)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT_,match], null);
} else {
if(cljs.core.truth_((pred__30208.cljs$core$IFn$_invoke$arity$2 ? pred__30208.cljs$core$IFn$_invoke$arity$2(cljs.core._LT__EQ_,expr__30209) : pred__30208.call(null,cljs.core._LT__EQ_,expr__30209)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,fluree.db.query.range.min_match(idx),cljs.core._LT__EQ_,match], null);
} else {
if(cljs.core.truth_((pred__30208.cljs$core$IFn$_invoke$arity$2 ? pred__30208.cljs$core$IFn$_invoke$arity$2(cljs.core._GT_,expr__30209) : pred__30208.call(null,cljs.core._GT_,expr__30209)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT_,match,cljs.core._LT__EQ_,fluree.db.query.range.max_match(idx)], null);
} else {
if(cljs.core.truth_((pred__30208.cljs$core$IFn$_invoke$arity$2 ? pred__30208.cljs$core$IFn$_invoke$arity$2(cljs.core._GT__EQ_,expr__30209) : pred__30208.call(null,cljs.core._GT__EQ_,expr__30209)))){
return new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core._GT__EQ_,match,cljs.core._LT_,fluree.db.query.range.max_match(idx)], null);
} else {
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(expr__30209)].join('')));
}
}
}
}
}
})();
var start_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30205,(0),null);
var start_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30205,(1),null);
var end_test = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30205,(2),null);
var end_match = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__30205,(3),null);
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,opts);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$6 = (function (db,idx,start_test,start_match,end_test,end_match){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,idx,start_test,start_match,end_test,end_match,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7 = (function (db,idx,start_test,start_match,end_test,end_match,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30581){
var state_val_30582 = (state_30581[(1)]);
if((state_val_30582 === (121))){
var inst_30537 = (state_30581[(7)]);
var state_30581__$1 = state_30581;
var statearr_30583_30779 = state_30581__$1;
(statearr_30583_30779[(2)] = inst_30537);

(statearr_30583_30779[(1)] = (123));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (65))){
var inst_30389 = (state_30581[(8)]);
var inst_30395 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30584 = state_30581;
(statearr_30584[(9)] = inst_30395);

return statearr_30584;
})();
if(cljs.core.truth_(inst_30389)){
var statearr_30585_30780 = state_30581__$1;
(statearr_30585_30780[(1)] = (66));

} else {
var statearr_30586_30781 = state_30581__$1;
(statearr_30586_30781[(1)] = (67));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (70))){
var inst_30573 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30587_30782 = state_30581__$1;
(statearr_30587_30782[(2)] = inst_30573);

(statearr_30587_30782[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (62))){
var inst_30388 = (state_30581[(2)]);
var inst_30389 = fluree.db.util.async.throw_err(inst_30388);
var inst_30390 = (cljs.core._STAR_target_STAR_ === "nodejs");
var state_30581__$1 = (function (){var statearr_30588 = state_30581;
(statearr_30588[(8)] = inst_30389);

return statearr_30588;
})();
if(cljs.core.truth_(inst_30390)){
var statearr_30589_30783 = state_30581__$1;
(statearr_30589_30783[(1)] = (63));

} else {
var statearr_30590_30784 = state_30581__$1;
(statearr_30590_30784[(1)] = (64));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (74))){
var inst_30235 = (state_30581[(10)]);
var inst_30398 = (state_30581[(11)]);
var inst_30416 = (state_30581[(12)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30368 = (state_30581[(15)]);
var inst_30238 = (state_30581[(16)]);
var inst_30399 = (state_30581[(17)]);
var inst_30236 = (state_30581[(18)]);
var inst_30362 = (state_30581[(19)]);
var inst_30300 = (state_30581[(20)]);
var inst_30380 = (state_30581[(21)]);
var inst_30231 = (state_30581[(22)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30400 = (state_30581[(26)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30389 = (state_30581[(8)]);
var inst_30321 = (state_30581[(29)]);
var inst_30359 = (state_30581[(30)]);
var inst_30303 = (state_30581[(31)]);
var inst_30247 = (state_30581[(32)]);
var inst_30374 = (state_30581[(33)]);
var inst_30375 = (state_30581[(34)]);
var inst_30408 = (state_30581[(35)]);
var inst_30369 = (state_30581[(36)]);
var inst_30379 = (state_30581[(37)]);
var inst_30258 = (state_30581[(38)]);
var inst_30385 = (state_30581[(39)]);
var inst_30401 = (state_30581[(40)]);
var inst_30248 = (state_30581[(41)]);
var inst_30358 = (state_30581[(42)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30402 = (state_30581[(45)]);
var inst_30299 = (state_30581[(46)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30395 = (state_30581[(9)]);
var inst_30418 = (function (){var no_filter_QMARK_ = inst_30395;
var t = inst_30375;
var max_limit_QMARK_ = inst_30369;
var next_node = inst_30398;
var fast_forward_db_QMARK_ = inst_30380;
var s1 = inst_30258;
var o2 = inst_30321;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var i = inst_30400;
var G__30409 = inst_30416;
var m1 = inst_30348;
var root_node = inst_30385;
var s2 = inst_30267;
var map__30230 = inst_30361;
var p2 = inst_30339;
var permissions = inst_30370;
var limit = inst_30368;
var start_flake = inst_30358;
var flake_limit = inst_30362;
var offset = inst_30399;
var vec__30224 = inst_30299;
var acc = inst_30402;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30312;
var end_flake = inst_30359;
var base_result = inst_30408;
var s = inst_30401;
var node_start = inst_30389;
var vec__30227 = inst_30300;
var p1 = inst_30330;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30303;
var idx_compare = inst_30374;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30357;
var map__30223 = inst_30246;
var novelty = inst_30379;
return (function (p1__30199_SHARP_){
var G__30591 = p1__30199_SHARP_.s;
return (subject_fn.cljs$core$IFn$_invoke$arity$1 ? subject_fn.cljs$core$IFn$_invoke$arity$1(G__30591) : subject_fn.call(null,G__30591));
});
})();
var inst_30419 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30418,inst_30416);
var state_30581__$1 = state_30581;
var statearr_30592_30785 = state_30581__$1;
(statearr_30592_30785[(2)] = inst_30419);

(statearr_30592_30785[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (110))){
var inst_30550 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30593_30786 = state_30581__$1;
(statearr_30593_30786[(2)] = inst_30550);

(statearr_30593_30786[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (7))){
var inst_30232 = (state_30581[(49)]);
var state_30581__$1 = state_30581;
var statearr_30594_30787 = state_30581__$1;
(statearr_30594_30787[(2)] = inst_30232);

(statearr_30594_30787[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (59))){
var state_30581__$1 = state_30581;
var statearr_30595_30788 = state_30581__$1;
(statearr_30595_30788[(2)] = fluree.db.util.core.max_long);

(statearr_30595_30788[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (86))){
var inst_30395 = (state_30581[(9)]);
var state_30581__$1 = state_30581;
var statearr_30596_30789 = state_30581__$1;
(statearr_30596_30789[(2)] = inst_30395);

(statearr_30596_30789[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (20))){
var state_30581__$1 = state_30581;
var statearr_30597_30790 = state_30581__$1;
(statearr_30597_30790[(2)] = null);

(statearr_30597_30790[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (72))){
var inst_30408 = (state_30581[(35)]);
var state_30581__$1 = state_30581;
var statearr_30598_30791 = state_30581__$1;
(statearr_30598_30791[(2)] = inst_30408);

(statearr_30598_30791[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (58))){
var inst_30363 = (state_30581[(50)]);
var state_30581__$1 = state_30581;
var statearr_30599_30792 = state_30581__$1;
(statearr_30599_30792[(2)] = inst_30363);

(statearr_30599_30792[(1)] = (60));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (60))){
var inst_30368 = (state_30581[(15)]);
var inst_30368__$1 = (state_30581[(2)]);
var inst_30369 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_30368__$1,fluree.db.util.core.max_long);
var inst_30370 = cljs.core.cst$kw$permissions.cljs$core$IFn$_invoke$arity$1(db);
var inst_30371 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30372 = [cljs.core.cst$kw$index_DASH_configs,idx,cljs.core.cst$kw$comparator];
var inst_30373 = (new cljs.core.PersistentVector(null,3,(5),inst_30371,inst_30372,null));
var inst_30374 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30373);
var inst_30375 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(db);
var inst_30376 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30377 = [cljs.core.cst$kw$novelty,idx];
var inst_30378 = (new cljs.core.PersistentVector(null,2,(5),inst_30376,inst_30377,null));
var inst_30379 = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(db,inst_30378);
var inst_30380 = cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(db);
var inst_30381 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(db,idx);
var inst_30382 = fluree.db.dbproto._resolve(inst_30381);
var state_30581__$1 = (function (){var statearr_30600 = state_30581;
(statearr_30600[(15)] = inst_30368__$1);

(statearr_30600[(21)] = inst_30380);

(statearr_30600[(27)] = inst_30370);

(statearr_30600[(33)] = inst_30374);

(statearr_30600[(34)] = inst_30375);

(statearr_30600[(36)] = inst_30369);

(statearr_30600[(37)] = inst_30379);

return statearr_30600;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(61),inst_30382);
} else {
if((state_val_30582 === (27))){
var inst_30301 = (state_30581[(51)]);
var state_30581__$1 = state_30581;
var statearr_30601_30793 = state_30581__$1;
(statearr_30601_30793[(2)] = inst_30301);

(statearr_30601_30793[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (1))){
var state_30581__$1 = state_30581;
var statearr_30602_30794 = state_30581__$1;
(statearr_30602_30794[(2)] = null);

(statearr_30602_30794[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (69))){
var inst_30398 = (state_30581[(11)]);
var inst_30359 = (state_30581[(30)]);
var inst_30358 = (state_30581[(42)]);
var inst_30407 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_30398);
var inst_30408 = fluree.db.flake.subrange(inst_30407,start_test,inst_30358,end_test,inst_30359);
var inst_30410 = fluree.db.query.range.value_with_nil_pred(idx,inst_30358,inst_30359);
var state_30581__$1 = (function (){var statearr_30603 = state_30581;
(statearr_30603[(35)] = inst_30408);

return statearr_30603;
})();
if(inst_30410){
var statearr_30604_30795 = state_30581__$1;
(statearr_30604_30795[(1)] = (71));

} else {
var statearr_30605_30796 = state_30581__$1;
(statearr_30605_30796[(1)] = (72));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (101))){
var inst_30362 = (state_30581[(19)]);
var inst_30494 = (state_30581[(52)]);
var inst_30495 = (state_30581[(53)]);
var inst_30496 = (state_30581[(54)]);
var inst_30499 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30500 = (inst_30496 - inst_30362);
var inst_30501 = (inst_30495 - inst_30500);
var inst_30502 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30501,inst_30494);
var inst_30503 = [inst_30362,inst_30502];
var inst_30504 = (new cljs.core.PersistentVector(null,2,(5),inst_30499,inst_30503,null));
var state_30581__$1 = state_30581;
var statearr_30606_30797 = state_30581__$1;
(statearr_30606_30797[(2)] = inst_30504);

(statearr_30606_30797[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (24))){
var inst_30235 = (state_30581[(10)]);
var inst_30281 = (state_30581[(55)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30238 = (state_30581[(16)]);
var inst_30240 = (state_30581[(56)]);
var inst_30236 = (state_30581[(18)]);
var inst_30249 = (state_30581[(57)]);
var inst_30231 = (state_30581[(22)]);
var inst_30247 = (state_30581[(32)]);
var inst_30244 = (state_30581[(58)]);
var inst_30258 = (state_30581[(38)]);
var inst_30234 = (state_30581[(59)]);
var inst_30248 = (state_30581[(41)]);
var inst_30241 = (state_30581[(60)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30237 = (state_30581[(61)]);
var inst_30233 = (state_30581[(62)]);
var inst_30291 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30292 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30293 = [null,null];
var inst_30294 = (new cljs.core.PersistentVector(null,2,(5),inst_30292,inst_30293,null));
var inst_30295 = (function (){var bool = inst_30281;
var s1 = inst_30258;
var o2 = inst_30241;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var m1 = inst_30237;
var s2 = inst_30267;
var p2 = inst_30240;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30234;
var p1 = inst_30233;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30249;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30244;
var map__30223 = inst_30246;
var temp__5755__auto__ = inst_30281;
return (function (o){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(o,bool);
});
})();
var inst_30296 = [inst_30294,inst_30295];
var inst_30297 = (new cljs.core.PersistentVector(null,2,(5),inst_30291,inst_30296,null));
var state_30581__$1 = state_30581;
var statearr_30607_30798 = state_30581__$1;
(statearr_30607_30798[(2)] = inst_30297);

(statearr_30607_30798[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (102))){
var inst_30494 = (state_30581[(52)]);
var inst_30496 = (state_30581[(54)]);
var inst_30506 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30507 = [inst_30496,inst_30494];
var inst_30508 = (new cljs.core.PersistentVector(null,2,(5),inst_30506,inst_30507,null));
var state_30581__$1 = state_30581;
var statearr_30608_30799 = state_30581__$1;
(statearr_30608_30799[(2)] = inst_30508);

(statearr_30608_30799[(1)] = (103));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (55))){
var state_30581__$1 = state_30581;
var statearr_30609_30800 = state_30581__$1;
(statearr_30609_30800[(2)] = (2147483647));

(statearr_30609_30800[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (85))){
var inst_30444 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
if(cljs.core.truth_(inst_30444)){
var statearr_30610_30801 = state_30581__$1;
(statearr_30610_30801[(1)] = (89));

} else {
var statearr_30611_30802 = state_30581__$1;
(statearr_30611_30802[(1)] = (90));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (39))){
var inst_30240 = (state_30581[(56)]);
var inst_30331 = (state_30581[(63)]);
var inst_30330 = (state_30581[(2)]);
var inst_30331__$1 = (inst_30240 == null);
var state_30581__$1 = (function (){var statearr_30612 = state_30581;
(statearr_30612[(28)] = inst_30330);

(statearr_30612[(63)] = inst_30331__$1);

return statearr_30612;
})();
if(cljs.core.truth_(inst_30331__$1)){
var statearr_30613_30803 = state_30581__$1;
(statearr_30613_30803[(1)] = (40));

} else {
var statearr_30614_30804 = state_30581__$1;
(statearr_30614_30804[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (88))){
var inst_30441 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30615_30805 = state_30581__$1;
(statearr_30615_30805[(2)] = inst_30441);

(statearr_30615_30805[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (46))){
var inst_30237 = (state_30581[(61)]);
var state_30581__$1 = state_30581;
var statearr_30616_30806 = state_30581__$1;
(statearr_30616_30806[(2)] = inst_30237);

(statearr_30616_30806[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (4))){
var inst_30211 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30617_30807 = state_30581__$1;
(statearr_30617_30807[(2)] = inst_30211);

(statearr_30617_30807[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (77))){
var inst_30235 = (state_30581[(10)]);
var inst_30398 = (state_30581[(11)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30368 = (state_30581[(15)]);
var inst_30238 = (state_30581[(16)]);
var inst_30399 = (state_30581[(17)]);
var inst_30236 = (state_30581[(18)]);
var inst_30362 = (state_30581[(19)]);
var inst_30300 = (state_30581[(20)]);
var inst_30380 = (state_30581[(21)]);
var inst_30231 = (state_30581[(22)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30400 = (state_30581[(26)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30389 = (state_30581[(8)]);
var inst_30321 = (state_30581[(29)]);
var inst_30359 = (state_30581[(30)]);
var inst_30303 = (state_30581[(31)]);
var inst_30247 = (state_30581[(32)]);
var inst_30374 = (state_30581[(33)]);
var inst_30375 = (state_30581[(34)]);
var inst_30408 = (state_30581[(35)]);
var inst_30369 = (state_30581[(36)]);
var inst_30379 = (state_30581[(37)]);
var inst_30422 = (state_30581[(64)]);
var inst_30258 = (state_30581[(38)]);
var inst_30385 = (state_30581[(39)]);
var inst_30401 = (state_30581[(40)]);
var inst_30248 = (state_30581[(41)]);
var inst_30358 = (state_30581[(42)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30402 = (state_30581[(45)]);
var inst_30299 = (state_30581[(46)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30395 = (state_30581[(9)]);
var inst_30424 = (function (){var no_filter_QMARK_ = inst_30395;
var t = inst_30375;
var max_limit_QMARK_ = inst_30369;
var next_node = inst_30398;
var fast_forward_db_QMARK_ = inst_30380;
var s1 = inst_30258;
var o2 = inst_30321;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var i = inst_30400;
var G__30409 = inst_30422;
var m1 = inst_30348;
var root_node = inst_30385;
var s2 = inst_30267;
var map__30230 = inst_30361;
var p2 = inst_30339;
var permissions = inst_30370;
var limit = inst_30368;
var start_flake = inst_30358;
var flake_limit = inst_30362;
var offset = inst_30399;
var vec__30224 = inst_30299;
var acc = inst_30402;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30312;
var end_flake = inst_30359;
var base_result = inst_30408;
var s = inst_30401;
var node_start = inst_30389;
var vec__30227 = inst_30300;
var p1 = inst_30330;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30303;
var idx_compare = inst_30374;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30357;
var map__30223 = inst_30246;
var novelty = inst_30379;
return (function (p1__30200_SHARP_){
var G__30618 = p1__30200_SHARP_.p;
return (predicate_fn.cljs$core$IFn$_invoke$arity$1 ? predicate_fn.cljs$core$IFn$_invoke$arity$1(G__30618) : predicate_fn.call(null,G__30618));
});
})();
var inst_30425 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30424,inst_30422);
var state_30581__$1 = state_30581;
var statearr_30619_30808 = state_30581__$1;
(statearr_30619_30808[(2)] = inst_30425);

(statearr_30619_30808[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (106))){
var inst_30435 = (state_30581[(65)]);
var state_30581__$1 = state_30581;
var statearr_30620_30809 = state_30581__$1;
(statearr_30620_30809[(2)] = inst_30435);

(statearr_30620_30809[(1)] = (107));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (119))){
var inst_30553 = (state_30581[(66)]);
var state_30581__$1 = state_30581;
var statearr_30621_30810 = state_30581__$1;
(statearr_30621_30810[(2)] = inst_30553);

(statearr_30621_30810[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (95))){
var inst_30478 = (state_30581[(67)]);
var inst_30476 = (state_30581[(68)]);
var inst_30368 = (state_30581[(15)]);
var inst_30477 = (state_30581[(69)]);
var inst_30401 = (state_30581[(40)]);
var inst_30468 = (state_30581[(70)]);
var inst_30476__$1 = cljs.core.count(inst_30468);
var inst_30477__$1 = (inst_30401 + inst_30476__$1);
var inst_30478__$1 = (inst_30477__$1 - inst_30368);
var inst_30479 = cljs.core.pos_int_QMARK_(inst_30478__$1);
var state_30581__$1 = (function (){var statearr_30622 = state_30581;
(statearr_30622[(67)] = inst_30478__$1);

(statearr_30622[(68)] = inst_30476__$1);

(statearr_30622[(69)] = inst_30477__$1);

return statearr_30622;
})();
if(inst_30479){
var statearr_30623_30811 = state_30581__$1;
(statearr_30623_30811[(1)] = (98));

} else {
var statearr_30624_30812 = state_30581__$1;
(statearr_30624_30812[(1)] = (99));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (54))){
var inst_30235 = (state_30581[(10)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30236 = (state_30581[(18)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30330 = (state_30581[(28)]);
var inst_30321 = (state_30581[(29)]);
var inst_30258 = (state_30581[(38)]);
var inst_30267 = (state_30581[(43)]);
var inst_30363 = (state_30581[(50)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30357__$1 = (state_30581[(2)]);
var inst_30358 = fluree.db.flake.__GT_Flake(inst_30258,inst_30330,inst_30312,inst_30235,inst_30236,inst_30348);
var inst_30359 = fluree.db.flake.__GT_Flake(inst_30267,inst_30339,inst_30321,inst_30242,inst_30243,inst_30357__$1);
var inst_30360 = opts;
var inst_30361__$1 = cljs.core.__destructure_map(inst_30360);
var inst_30362 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30361__$1,cljs.core.cst$kw$flake_DASH_limit,fluree.db.util.core.max_long);
var inst_30363__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30361__$1,cljs.core.cst$kw$limit);
var inst_30364 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(inst_30361__$1,cljs.core.cst$kw$offset,(0));
var state_30581__$1 = (function (){var statearr_30625 = state_30581;
(statearr_30625[(19)] = inst_30362);

(statearr_30625[(25)] = inst_30357__$1);

(statearr_30625[(30)] = inst_30359);

(statearr_30625[(42)] = inst_30358);

(statearr_30625[(50)] = inst_30363__$1);

(statearr_30625[(71)] = inst_30364);

(statearr_30625[(47)] = inst_30361__$1);

return statearr_30625;
})();
if(cljs.core.truth_(inst_30363__$1)){
var statearr_30626_30813 = state_30581__$1;
(statearr_30626_30813[(1)] = (58));

} else {
var statearr_30627_30814 = state_30581__$1;
(statearr_30627_30814[(1)] = (59));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (92))){
var inst_30399 = (state_30581[(17)]);
var inst_30400 = (state_30581[(26)]);
var inst_30401 = (state_30581[(40)]);
var inst_30402 = (state_30581[(45)]);
var inst_30457 = (state_30581[(72)]);
var inst_30460 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30461 = (inst_30399 - inst_30457);
var inst_30462 = [inst_30461,inst_30400,inst_30401,inst_30402];
var inst_30463 = (new cljs.core.PersistentVector(null,4,(5),inst_30460,inst_30462,null));
var state_30581__$1 = state_30581;
var statearr_30628_30815 = state_30581__$1;
(statearr_30628_30815[(2)] = inst_30463);

(statearr_30628_30815[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (104))){
var inst_30519 = (state_30581[(2)]);
var inst_30520 = fluree.db.util.async.throw_err(inst_30519);
var state_30581__$1 = state_30581;
var statearr_30629_30816 = state_30581__$1;
(statearr_30629_30816[(2)] = inst_30520);

(statearr_30629_30816[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (15))){
var inst_30241 = (state_30581[(60)]);
var inst_30271 = cljs.core.boolean_QMARK_(inst_30241);
var state_30581__$1 = state_30581;
if(inst_30271){
var statearr_30630_30817 = state_30581__$1;
(statearr_30630_30817[(1)] = (17));

} else {
var statearr_30631_30818 = state_30581__$1;
(statearr_30631_30818[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (48))){
var inst_30244 = (state_30581[(58)]);
var inst_30348 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30632 = state_30581;
(statearr_30632[(24)] = inst_30348);

return statearr_30632;
})();
if(cljs.core.truth_(inst_30244)){
var statearr_30633_30819 = state_30581__$1;
(statearr_30633_30819[(1)] = (52));

} else {
var statearr_30634_30820 = state_30581__$1;
(statearr_30634_30820[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (50))){
var state_30581__$1 = state_30581;
var statearr_30635_30821 = state_30581__$1;
(statearr_30635_30821[(2)] = (2147483647));

(statearr_30635_30821[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (116))){
var inst_30553 = (state_30581[(66)]);
var inst_30561 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30636 = state_30581;
(statearr_30636[(73)] = inst_30561);

return statearr_30636;
})();
if(cljs.core.truth_(inst_30553)){
var statearr_30637_30822 = state_30581__$1;
(statearr_30637_30822[(1)] = (118));

} else {
var statearr_30638_30823 = state_30581__$1;
(statearr_30638_30823[(1)] = (119));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (75))){
var inst_30416 = (state_30581[(12)]);
var state_30581__$1 = state_30581;
var statearr_30639_30824 = state_30581__$1;
(statearr_30639_30824[(2)] = inst_30416);

(statearr_30639_30824[(1)] = (76));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (99))){
var inst_30477 = (state_30581[(69)]);
var inst_30486 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30487 = [inst_30477,inst_30477];
var inst_30488 = (new cljs.core.PersistentVector(null,2,(5),inst_30486,inst_30487,null));
var state_30581__$1 = state_30581;
var statearr_30640_30825 = state_30581__$1;
(statearr_30640_30825[(2)] = inst_30488);

(statearr_30640_30825[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (21))){
var state_30581__$1 = state_30581;
var statearr_30641_30826 = state_30581__$1;
(statearr_30641_30826[(2)] = null);

(statearr_30641_30826[(1)] = (22));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (31))){
var inst_30302 = (state_30581[(74)]);
var state_30581__$1 = state_30581;
var statearr_30642_30827 = state_30581__$1;
(statearr_30642_30827[(2)] = inst_30302);

(statearr_30642_30827[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (113))){
var inst_30547 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30643_30828 = state_30581__$1;
(statearr_30643_30828[(2)] = inst_30547);

(statearr_30643_30828[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (32))){
var inst_30322 = (state_30581[(75)]);
var inst_30233 = (state_30581[(62)]);
var inst_30321 = (state_30581[(2)]);
var inst_30322__$1 = (inst_30233 == null);
var state_30581__$1 = (function (){var statearr_30644 = state_30581;
(statearr_30644[(75)] = inst_30322__$1);

(statearr_30644[(29)] = inst_30321);

return statearr_30644;
})();
if(cljs.core.truth_(inst_30322__$1)){
var statearr_30645_30829 = state_30581__$1;
(statearr_30645_30829[(1)] = (34));

} else {
var statearr_30646_30830 = state_30581__$1;
(statearr_30646_30830[(1)] = (35));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (40))){
var inst_30321 = (state_30581[(29)]);
var state_30581__$1 = state_30581;
var statearr_30647_30831 = state_30581__$1;
(statearr_30647_30831[(2)] = inst_30321);

(statearr_30647_30831[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (91))){
var inst_30435 = (state_30581[(65)]);
var inst_30533 = (state_30581[(2)]);
var inst_30534 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30533,(0),null);
var inst_30535 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30533,(1),null);
var inst_30536 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30533,(2),null);
var inst_30537 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30533,(3),null);
var state_30581__$1 = (function (){var statearr_30648 = state_30581;
(statearr_30648[(76)] = inst_30535);

(statearr_30648[(7)] = inst_30537);

(statearr_30648[(77)] = inst_30534);

(statearr_30648[(78)] = inst_30536);

return statearr_30648;
})();
if(cljs.core.truth_(inst_30435)){
var statearr_30649_30832 = state_30581__$1;
(statearr_30649_30832[(1)] = (105));

} else {
var statearr_30650_30833 = state_30581__$1;
(statearr_30650_30833[(1)] = (106));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (117))){
var inst_30557 = (state_30581[(2)]);
var inst_30558 = fluree.db.util.async.throw_err(inst_30557);
var state_30581__$1 = state_30581;
var statearr_30651_30834 = state_30581__$1;
(statearr_30651_30834[(2)] = inst_30558);

(statearr_30651_30834[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (108))){
var inst_30535 = (state_30581[(76)]);
var inst_30362 = (state_30581[(19)]);
var inst_30542 = (state_30581[(79)]);
var inst_30542__$1 = (inst_30535 < inst_30362);
var state_30581__$1 = (function (){var statearr_30652 = state_30581;
(statearr_30652[(79)] = inst_30542__$1);

return statearr_30652;
})();
if(cljs.core.truth_(inst_30542__$1)){
var statearr_30653_30835 = state_30581__$1;
(statearr_30653_30835[(1)] = (111));

} else {
var statearr_30654_30836 = state_30581__$1;
(statearr_30654_30836[(1)] = (112));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (56))){
var state_30581__$1 = state_30581;
var statearr_30655_30837 = state_30581__$1;
(statearr_30655_30837[(2)] = fluree.db.util.core.min_integer);

(statearr_30655_30837[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (33))){
var inst_30317 = (state_30581[(2)]);
var inst_30318 = fluree.db.util.async.throw_err(inst_30317);
var state_30581__$1 = state_30581;
var statearr_30656_30838 = state_30581__$1;
(statearr_30656_30838[(2)] = inst_30318);

(statearr_30656_30838[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (13))){
var inst_30263 = (state_30581[(2)]);
var inst_30264 = fluree.db.util.async.throw_err(inst_30263);
var state_30581__$1 = state_30581;
var statearr_30657_30839 = state_30581__$1;
(statearr_30657_30839[(2)] = inst_30264);

(statearr_30657_30839[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (22))){
var inst_30277 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30658_30840 = state_30581__$1;
(statearr_30658_30840[(2)] = inst_30277);

(statearr_30658_30840[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (90))){
var inst_30235 = (state_30581[(10)]);
var inst_30398 = (state_30581[(11)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30368 = (state_30581[(15)]);
var inst_30238 = (state_30581[(16)]);
var inst_30399 = (state_30581[(17)]);
var inst_30236 = (state_30581[(18)]);
var inst_30435 = (state_30581[(65)]);
var inst_30362 = (state_30581[(19)]);
var inst_30300 = (state_30581[(20)]);
var inst_30380 = (state_30581[(21)]);
var inst_30231 = (state_30581[(22)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30400 = (state_30581[(26)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30389 = (state_30581[(8)]);
var inst_30321 = (state_30581[(29)]);
var inst_30359 = (state_30581[(30)]);
var inst_30303 = (state_30581[(31)]);
var inst_30247 = (state_30581[(32)]);
var inst_30374 = (state_30581[(33)]);
var inst_30375 = (state_30581[(34)]);
var inst_30408 = (state_30581[(35)]);
var inst_30434 = (state_30581[(80)]);
var inst_30369 = (state_30581[(36)]);
var inst_30379 = (state_30581[(37)]);
var inst_30258 = (state_30581[(38)]);
var inst_30385 = (state_30581[(39)]);
var inst_30401 = (state_30581[(40)]);
var inst_30248 = (state_30581[(41)]);
var inst_30358 = (state_30581[(42)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30402 = (state_30581[(45)]);
var inst_30299 = (state_30581[(46)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30395 = (state_30581[(9)]);
var inst_30456 = (state_30581[(81)]);
var inst_30457 = (state_30581[(72)]);
var inst_30455 = (function (){var no_filter_QMARK_ = inst_30395;
var base_result_SINGLEQUOTE_ = inst_30434;
var t = inst_30375;
var max_limit_QMARK_ = inst_30369;
var next_node = inst_30398;
var fast_forward_db_QMARK_ = inst_30380;
var s1 = inst_30258;
var o2 = inst_30321;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var i = inst_30400;
var rhs = inst_30435;
var m1 = inst_30348;
var root_node = inst_30385;
var s2 = inst_30267;
var map__30230 = inst_30361;
var p2 = inst_30339;
var permissions = inst_30370;
var limit = inst_30368;
var start_flake = inst_30358;
var flake_limit = inst_30362;
var offset = inst_30399;
var vec__30224 = inst_30299;
var acc = inst_30402;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30312;
var end_flake = inst_30359;
var base_result = inst_30408;
var s = inst_30401;
var node_start = inst_30389;
var vec__30227 = inst_30300;
var p1 = inst_30330;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30303;
var idx_compare = inst_30374;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30357;
var map__30223 = inst_30246;
var novelty = inst_30379;
return (function (p1__30202_SHARP_){
return p1__30202_SHARP_.s;
});
})();
var inst_30456__$1 = cljs.core.partition_by.cljs$core$IFn$_invoke$arity$2(inst_30455,inst_30434);
var inst_30457__$1 = cljs.core.count(inst_30456__$1);
var inst_30458 = (inst_30399 > inst_30457__$1);
var state_30581__$1 = (function (){var statearr_30659 = state_30581;
(statearr_30659[(81)] = inst_30456__$1);

(statearr_30659[(72)] = inst_30457__$1);

return statearr_30659;
})();
if(cljs.core.truth_(inst_30458)){
var statearr_30660_30841 = state_30581__$1;
(statearr_30660_30841[(1)] = (92));

} else {
var statearr_30661_30842 = state_30581__$1;
(statearr_30661_30842[(1)] = (93));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (109))){
var inst_30540 = (state_30581[(82)]);
var state_30581__$1 = state_30581;
var statearr_30662_30843 = state_30581__$1;
(statearr_30662_30843[(2)] = inst_30540);

(statearr_30662_30843[(1)] = (110));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (36))){
var inst_30326 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
if(cljs.core.truth_(inst_30326)){
var statearr_30663_30844 = state_30581__$1;
(statearr_30663_30844[(1)] = (37));

} else {
var statearr_30664_30845 = state_30581__$1;
(statearr_30664_30845[(1)] = (38));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (41))){
var inst_30331 = (state_30581[(63)]);
var state_30581__$1 = state_30581;
var statearr_30665_30846 = state_30581__$1;
(statearr_30665_30846[(2)] = inst_30331);

(statearr_30665_30846[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (118))){
var inst_30561 = (state_30581[(73)]);
var state_30581__$1 = state_30581;
var statearr_30666_30847 = state_30581__$1;
(statearr_30666_30847[(2)] = inst_30561);

(statearr_30666_30847[(1)] = (120));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (89))){
var inst_30362 = (state_30581[(19)]);
var inst_30400 = (state_30581[(26)]);
var inst_30434 = (state_30581[(80)]);
var inst_30401 = (state_30581[(40)]);
var inst_30402 = (state_30581[(45)]);
var inst_30446 = cljs.core.count(inst_30434);
var inst_30447 = (inst_30362 - inst_30400);
var inst_30448 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30447,inst_30434);
var inst_30449 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30402,inst_30448);
var inst_30450 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30451 = (inst_30400 + inst_30446);
var inst_30452 = [(0),inst_30451,inst_30401,inst_30449];
var inst_30453 = (new cljs.core.PersistentVector(null,4,(5),inst_30450,inst_30452,null));
var state_30581__$1 = state_30581;
var statearr_30667_30848 = state_30581__$1;
(statearr_30667_30848[(2)] = inst_30453);

(statearr_30667_30848[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (100))){
var inst_30362 = (state_30581[(19)]);
var inst_30494 = (state_30581[(52)]);
var inst_30495 = (state_30581[(53)]);
var inst_30400 = (state_30581[(26)]);
var inst_30496 = (state_30581[(54)]);
var inst_30468 = (state_30581[(70)]);
var inst_30490 = (state_30581[(2)]);
var inst_30491 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30490,(0),null);
var inst_30492 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30490,(1),null);
var inst_30493 = cljs.core.take.cljs$core$IFn$_invoke$arity$2(inst_30492,inst_30468);
var inst_30494__$1 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,inst_30493);
var inst_30495__$1 = cljs.core.count(inst_30494__$1);
var inst_30496__$1 = (inst_30400 + inst_30495__$1);
var inst_30497 = (inst_30496__$1 > inst_30362);
var state_30581__$1 = (function (){var statearr_30668 = state_30581;
(statearr_30668[(83)] = inst_30491);

(statearr_30668[(52)] = inst_30494__$1);

(statearr_30668[(53)] = inst_30495__$1);

(statearr_30668[(54)] = inst_30496__$1);

return statearr_30668;
})();
if(cljs.core.truth_(inst_30497)){
var statearr_30669_30849 = state_30581__$1;
(statearr_30669_30849[(1)] = (101));

} else {
var statearr_30670_30850 = state_30581__$1;
(statearr_30670_30850[(1)] = (102));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (122))){
var inst_30535 = (state_30581[(76)]);
var inst_30537 = (state_30581[(7)]);
var inst_30534 = (state_30581[(77)]);
var inst_30536 = (state_30581[(78)]);
var inst_30561 = (state_30581[(73)]);
var inst_30398 = inst_30561;
var inst_30399 = inst_30534;
var inst_30400 = inst_30535;
var inst_30401 = inst_30536;
var inst_30402 = inst_30537;
var state_30581__$1 = (function (){var statearr_30671 = state_30581;
(statearr_30671[(11)] = inst_30398);

(statearr_30671[(17)] = inst_30399);

(statearr_30671[(26)] = inst_30400);

(statearr_30671[(40)] = inst_30401);

(statearr_30671[(45)] = inst_30402);

return statearr_30671;
})();
var statearr_30672_30851 = state_30581__$1;
(statearr_30672_30851[(2)] = null);

(statearr_30672_30851[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (43))){
var state_30581__$1 = state_30581;
var statearr_30673_30852 = state_30581__$1;
(statearr_30673_30852[(2)] = fluree.db.flake.MAX_PREDICATE_ID);

(statearr_30673_30852[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (61))){
var inst_30380 = (state_30581[(21)]);
var inst_30375 = (state_30581[(34)]);
var inst_30379 = (state_30581[(37)]);
var inst_30385 = (state_30581[(39)]);
var inst_30358 = (state_30581[(42)]);
var inst_30384 = (state_30581[(2)]);
var inst_30385__$1 = fluree.db.util.async.throw_err(inst_30384);
var inst_30386 = fluree.db.query.range.find_next_valid_node(inst_30385__$1,inst_30358,inst_30375,inst_30379,inst_30380);
var state_30581__$1 = (function (){var statearr_30674 = state_30581;
(statearr_30674[(39)] = inst_30385__$1);

return statearr_30674;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(62),inst_30386);
} else {
if((state_val_30582 === (29))){
var inst_30308 = (state_30581[(2)]);
var inst_30309 = fluree.db.util.async.throw_err(inst_30308);
var state_30581__$1 = state_30581;
var statearr_30675_30853 = state_30581__$1;
(statearr_30675_30853[(2)] = inst_30309);

(statearr_30675_30853[(1)] = (28));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (44))){
var inst_30240 = (state_30581[(56)]);
var state_30581__$1 = state_30581;
var statearr_30676_30854 = state_30581__$1;
(statearr_30676_30854[(2)] = inst_30240);

(statearr_30676_30854[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (93))){
var inst_30399 = (state_30581[(17)]);
var inst_30395 = (state_30581[(9)]);
var inst_30456 = (state_30581[(81)]);
var inst_30468 = cljs.core.drop.cljs$core$IFn$_invoke$arity$2(inst_30399,inst_30456);
var state_30581__$1 = (function (){var statearr_30677 = state_30581;
(statearr_30677[(70)] = inst_30468);

return statearr_30677;
})();
if(cljs.core.truth_(inst_30395)){
var statearr_30678_30855 = state_30581__$1;
(statearr_30678_30855[(1)] = (95));

} else {
var statearr_30679_30856 = state_30581__$1;
(statearr_30679_30856[(1)] = (96));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (6))){
var inst_30232 = (state_30581[(49)]);
var inst_30252 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30232);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(9),inst_30252);
} else {
if((state_val_30582 === (111))){
var inst_30368 = (state_30581[(15)]);
var inst_30536 = (state_30581[(78)]);
var inst_30544 = (inst_30536 < inst_30368);
var state_30581__$1 = state_30581;
var statearr_30680_30857 = state_30581__$1;
(statearr_30680_30857[(2)] = inst_30544);

(statearr_30680_30857[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (28))){
var inst_30302 = (state_30581[(74)]);
var inst_30312 = (state_30581[(2)]);
var inst_30313 = fluree.db.util.core.pred_ident_QMARK_(inst_30302);
var state_30581__$1 = (function (){var statearr_30681 = state_30581;
(statearr_30681[(48)] = inst_30312);

return statearr_30681;
})();
if(inst_30313){
var statearr_30682_30858 = state_30581__$1;
(statearr_30682_30858[(1)] = (30));

} else {
var statearr_30683_30859 = state_30581__$1;
(statearr_30683_30859[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (64))){
var state_30581__$1 = state_30581;
var statearr_30684_30860 = state_30581__$1;
(statearr_30684_30860[(2)] = true);

(statearr_30684_30860[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (103))){
var inst_30491 = (state_30581[(83)]);
var inst_30510 = (state_30581[(2)]);
var inst_30511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30510,(0),null);
var inst_30512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30510,(1),null);
var inst_30513 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30514 = [inst_30511,inst_30491,inst_30512];
var inst_30515 = (new cljs.core.PersistentVector(null,3,(5),inst_30513,inst_30514,null));
var state_30581__$1 = state_30581;
var statearr_30685_30861 = state_30581__$1;
(statearr_30685_30861[(2)] = inst_30515);

(statearr_30685_30861[(1)] = (97));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (51))){
var inst_30346 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30686_30862 = state_30581__$1;
(statearr_30686_30862[(2)] = inst_30346);

(statearr_30686_30862[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (25))){
var inst_30301 = (state_30581[(51)]);
var inst_30300 = (state_30581[(20)]);
var inst_30299 = (state_30581[(46)]);
var inst_30299__$1 = (state_30581[(2)]);
var inst_30300__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30299__$1,(0),null);
var inst_30301__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30300__$1,(0),null);
var inst_30302 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30300__$1,(1),null);
var inst_30303 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30299__$1,(1),null);
var inst_30304 = fluree.db.util.core.pred_ident_QMARK_(inst_30301__$1);
var state_30581__$1 = (function (){var statearr_30687 = state_30581;
(statearr_30687[(51)] = inst_30301__$1);

(statearr_30687[(20)] = inst_30300__$1);

(statearr_30687[(31)] = inst_30303);

(statearr_30687[(74)] = inst_30302);

(statearr_30687[(46)] = inst_30299__$1);

return statearr_30687;
})();
if(inst_30304){
var statearr_30688_30863 = state_30581__$1;
(statearr_30688_30863[(1)] = (26));

} else {
var statearr_30689_30864 = state_30581__$1;
(statearr_30689_30864[(1)] = (27));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (34))){
var inst_30312 = (state_30581[(48)]);
var state_30581__$1 = state_30581;
var statearr_30690_30865 = state_30581__$1;
(statearr_30690_30865[(2)] = inst_30312);

(statearr_30690_30865[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (17))){
var inst_30241 = (state_30581[(60)]);
var state_30581__$1 = state_30581;
var statearr_30691_30866 = state_30581__$1;
(statearr_30691_30866[(2)] = inst_30241);

(statearr_30691_30866[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (3))){
var inst_30579 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30581__$1,inst_30579);
} else {
if((state_val_30582 === (12))){
var inst_30234 = (state_30581[(59)]);
var inst_30267 = (state_30581[(2)]);
var inst_30268 = cljs.core.boolean_QMARK_(inst_30234);
var state_30581__$1 = (function (){var statearr_30692 = state_30581;
(statearr_30692[(43)] = inst_30267);

return statearr_30692;
})();
if(inst_30268){
var statearr_30693_30867 = state_30581__$1;
(statearr_30693_30867[(1)] = (14));

} else {
var statearr_30694_30868 = state_30581__$1;
(statearr_30694_30868[(1)] = (15));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (2))){
var inst_30238 = (state_30581[(16)]);
var inst_30231 = (state_30581[(22)]);
var inst_30232 = (state_30581[(49)]);
var inst_30246 = (state_30581[(44)]);
var _ = (function (){var statearr_30695 = state_30581;
(statearr_30695[(4)] = cljs.core.cons((5),(state_30581[(4)])));

return statearr_30695;
})();
var inst_30231__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,start_match);
var inst_30232__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(0),null);
var inst_30233 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(1),null);
var inst_30234 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(2),null);
var inst_30235 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(3),null);
var inst_30236 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(4),null);
var inst_30237 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30231__$1,(5),null);
var inst_30238__$1 = fluree.db.query.range.match__GT_flake_parts(db,idx,end_match);
var inst_30239 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(0),null);
var inst_30240 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(1),null);
var inst_30241 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(2),null);
var inst_30242 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(3),null);
var inst_30243 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(4),null);
var inst_30244 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30238__$1,(5),null);
var inst_30245 = opts;
var inst_30246__$1 = cljs.core.__destructure_map(inst_30245);
var inst_30247 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30246__$1,cljs.core.cst$kw$subject_DASH_fn);
var inst_30248 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30246__$1,cljs.core.cst$kw$predicate_DASH_fn);
var inst_30249 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_30246__$1,cljs.core.cst$kw$object_DASH_fn);
var inst_30250 = fluree.db.util.core.pred_ident_QMARK_(inst_30232__$1);
var state_30581__$1 = (function (){var statearr_30696 = state_30581;
(statearr_30696[(10)] = inst_30235);

(statearr_30696[(13)] = inst_30242);

(statearr_30696[(14)] = inst_30243);

(statearr_30696[(16)] = inst_30238__$1);

(statearr_30696[(56)] = inst_30240);

(statearr_30696[(18)] = inst_30236);

(statearr_30696[(57)] = inst_30249);

(statearr_30696[(22)] = inst_30231__$1);

(statearr_30696[(49)] = inst_30232__$1);

(statearr_30696[(32)] = inst_30247);

(statearr_30696[(84)] = inst_30239);

(statearr_30696[(58)] = inst_30244);

(statearr_30696[(59)] = inst_30234);

(statearr_30696[(41)] = inst_30248);

(statearr_30696[(60)] = inst_30241);

(statearr_30696[(44)] = inst_30246__$1);

(statearr_30696[(61)] = inst_30237);

(statearr_30696[(62)] = inst_30233);

return statearr_30696;
})();
if(inst_30250){
var statearr_30697_30869 = state_30581__$1;
(statearr_30697_30869[(1)] = (6));

} else {
var statearr_30698_30870 = state_30581__$1;
(statearr_30698_30870[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (66))){
var inst_30389 = (state_30581[(8)]);
var inst_30364 = (state_30581[(71)]);
var inst_30397 = cljs.core.PersistentVector.EMPTY;
var inst_30398 = inst_30389;
var inst_30399 = inst_30364;
var inst_30400 = (0);
var inst_30401 = (0);
var inst_30402 = inst_30397;
var state_30581__$1 = (function (){var statearr_30699 = state_30581;
(statearr_30699[(11)] = inst_30398);

(statearr_30699[(17)] = inst_30399);

(statearr_30699[(26)] = inst_30400);

(statearr_30699[(40)] = inst_30401);

(statearr_30699[(45)] = inst_30402);

return statearr_30699;
})();
var statearr_30700_30871 = state_30581__$1;
(statearr_30700_30871[(2)] = null);

(statearr_30700_30871[(1)] = (69));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (107))){
var inst_30553 = (state_30581[(66)]);
var inst_30553__$1 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30701 = state_30581;
(statearr_30701[(66)] = inst_30553__$1);

return statearr_30701;
})();
if(cljs.core.truth_(inst_30553__$1)){
var statearr_30702_30872 = state_30581__$1;
(statearr_30702_30872[(1)] = (114));

} else {
var statearr_30703_30873 = state_30581__$1;
(statearr_30703_30873[(1)] = (115));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (23))){
var inst_30249 = (state_30581[(57)]);
var inst_30234 = (state_30581[(59)]);
var inst_30241 = (state_30581[(60)]);
var inst_30284 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30285 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30286 = [inst_30234,inst_30241];
var inst_30287 = (new cljs.core.PersistentVector(null,2,(5),inst_30285,inst_30286,null));
var inst_30288 = [inst_30287,inst_30249];
var inst_30289 = (new cljs.core.PersistentVector(null,2,(5),inst_30284,inst_30288,null));
var state_30581__$1 = state_30581;
var statearr_30704_30874 = state_30581__$1;
(statearr_30704_30874[(2)] = inst_30289);

(statearr_30704_30874[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (47))){
var inst_30342 = (cljs.core._GT__EQ_ === start_test);
var state_30581__$1 = state_30581;
if(cljs.core.truth_(inst_30342)){
var statearr_30705_30875 = state_30581__$1;
(statearr_30705_30875[(1)] = (49));

} else {
var statearr_30706_30876 = state_30581__$1;
(statearr_30706_30876[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (35))){
var inst_30322 = (state_30581[(75)]);
var state_30581__$1 = state_30581;
var statearr_30707_30877 = state_30581__$1;
(statearr_30707_30877[(2)] = inst_30322);

(statearr_30707_30877[(1)] = (36));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (82))){
var inst_30398 = (state_30581[(11)]);
var inst_30369 = (state_30581[(36)]);
var inst_30434 = (state_30581[(2)]);
var inst_30435 = fluree.db.dbproto._rhs(inst_30398);
var state_30581__$1 = (function (){var statearr_30708 = state_30581;
(statearr_30708[(65)] = inst_30435);

(statearr_30708[(80)] = inst_30434);

return statearr_30708;
})();
if(cljs.core.truth_(inst_30369)){
var statearr_30709_30878 = state_30581__$1;
(statearr_30709_30878[(1)] = (83));

} else {
var statearr_30710_30879 = state_30581__$1;
(statearr_30710_30879[(1)] = (84));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (76))){
var inst_30248 = (state_30581[(41)]);
var inst_30422 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30711 = state_30581;
(statearr_30711[(64)] = inst_30422);

return statearr_30711;
})();
if(cljs.core.truth_(inst_30248)){
var statearr_30712_30880 = state_30581__$1;
(statearr_30712_30880[(1)] = (77));

} else {
var statearr_30713_30881 = state_30581__$1;
(statearr_30713_30881[(1)] = (78));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (97))){
var inst_30402 = (state_30581[(45)]);
var inst_30522 = (state_30581[(2)]);
var inst_30523 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30522,(0),null);
var inst_30524 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30522,(1),null);
var inst_30525 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30522,(2),null);
var inst_30526 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30527 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_30402,inst_30525);
var inst_30528 = [(0),inst_30523,inst_30524,inst_30527];
var inst_30529 = (new cljs.core.PersistentVector(null,4,(5),inst_30526,inst_30528,null));
var state_30581__$1 = state_30581;
var statearr_30714_30882 = state_30581__$1;
(statearr_30714_30882[(2)] = inst_30529);

(statearr_30714_30882[(1)] = (94));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (19))){
var inst_30279 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30715_30883 = state_30581__$1;
(statearr_30715_30883[(2)] = inst_30279);

(statearr_30715_30883[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (57))){
var inst_30355 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30716_30884 = state_30581__$1;
(statearr_30716_30884[(2)] = inst_30355);

(statearr_30716_30884[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (68))){
var inst_30576 = (state_30581[(2)]);
var _ = (function (){var statearr_30717 = state_30581;
(statearr_30717[(4)] = cljs.core.rest((state_30581[(4)])));

return statearr_30717;
})();
var state_30581__$1 = state_30581;
var statearr_30718_30885 = state_30581__$1;
(statearr_30718_30885[(2)] = inst_30576);

(statearr_30718_30885[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (11))){
var inst_30239 = (state_30581[(84)]);
var state_30581__$1 = state_30581;
var statearr_30719_30886 = state_30581__$1;
(statearr_30719_30886[(2)] = inst_30239);

(statearr_30719_30886[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (115))){
var state_30581__$1 = state_30581;
var statearr_30721_30887 = state_30581__$1;
(statearr_30721_30887[(2)] = null);

(statearr_30721_30887[(1)] = (116));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (9))){
var inst_30254 = (state_30581[(2)]);
var inst_30255 = fluree.db.util.async.throw_err(inst_30254);
var state_30581__$1 = state_30581;
var statearr_30722_30888 = state_30581__$1;
(statearr_30722_30888[(2)] = inst_30255);

(statearr_30722_30888[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (5))){
var _ = (function (){var statearr_30723 = state_30581;
(statearr_30723[(4)] = cljs.core.rest((state_30581[(4)])));

return statearr_30723;
})();
var state_30581__$1 = state_30581;
var ex30720 = (state_30581__$1[(2)]);
var statearr_30724_30889 = state_30581__$1;
(statearr_30724_30889[(5)] = ex30720);


if((ex30720 instanceof Error)){
var statearr_30725_30890 = state_30581__$1;
(statearr_30725_30890[(1)] = (4));

(statearr_30725_30890[(5)] = null);

} else {
throw ex30720;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (112))){
var inst_30542 = (state_30581[(79)]);
var state_30581__$1 = state_30581;
var statearr_30726_30891 = state_30581__$1;
(statearr_30726_30891[(2)] = inst_30542);

(statearr_30726_30891[(1)] = (113));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (83))){
var inst_30399 = (state_30581[(17)]);
var inst_30437 = (state_30581[(85)]);
var inst_30437__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((0),inst_30399);
var state_30581__$1 = (function (){var statearr_30727 = state_30581;
(statearr_30727[(85)] = inst_30437__$1);

return statearr_30727;
})();
if(inst_30437__$1){
var statearr_30728_30892 = state_30581__$1;
(statearr_30728_30892[(1)] = (86));

} else {
var statearr_30729_30893 = state_30581__$1;
(statearr_30729_30893[(1)] = (87));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (14))){
var inst_30234 = (state_30581[(59)]);
var state_30581__$1 = state_30581;
var statearr_30730_30894 = state_30581__$1;
(statearr_30730_30894[(2)] = inst_30234);

(statearr_30730_30894[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (45))){
var inst_30237 = (state_30581[(61)]);
var inst_30339 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30731 = state_30581;
(statearr_30731[(23)] = inst_30339);

return statearr_30731;
})();
if(cljs.core.truth_(inst_30237)){
var statearr_30732_30895 = state_30581__$1;
(statearr_30732_30895[(1)] = (46));

} else {
var statearr_30733_30896 = state_30581__$1;
(statearr_30733_30896[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (53))){
var inst_30351 = (cljs.core._LT__EQ_ === end_test);
var state_30581__$1 = state_30581;
if(cljs.core.truth_(inst_30351)){
var statearr_30734_30897 = state_30581__$1;
(statearr_30734_30897[(1)] = (55));

} else {
var statearr_30735_30898 = state_30581__$1;
(statearr_30735_30898[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (78))){
var inst_30422 = (state_30581[(64)]);
var state_30581__$1 = state_30581;
var statearr_30736_30899 = state_30581__$1;
(statearr_30736_30899[(2)] = inst_30422);

(statearr_30736_30899[(1)] = (79));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (26))){
var inst_30301 = (state_30581[(51)]);
var inst_30306 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30301);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(29),inst_30306);
} else {
if((state_val_30582 === (123))){
var inst_30571 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30737_30900 = state_30581__$1;
(statearr_30737_30900[(2)] = inst_30571);

(statearr_30737_30900[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (16))){
var inst_30281 = (state_30581[(55)]);
var inst_30281__$1 = (state_30581[(2)]);
var inst_30282 = (inst_30281__$1 == null);
var state_30581__$1 = (function (){var statearr_30738 = state_30581;
(statearr_30738[(55)] = inst_30281__$1);

return statearr_30738;
})();
if(cljs.core.truth_(inst_30282)){
var statearr_30739_30901 = state_30581__$1;
(statearr_30739_30901[(1)] = (23));

} else {
var statearr_30740_30902 = state_30581__$1;
(statearr_30740_30902[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (81))){
var inst_30428 = (state_30581[(86)]);
var state_30581__$1 = state_30581;
var statearr_30741_30903 = state_30581__$1;
(statearr_30741_30903[(2)] = inst_30428);

(statearr_30741_30903[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (120))){
var inst_30565 = (state_30581[(2)]);
var inst_30566 = cljs.core.not(inst_30565);
var state_30581__$1 = state_30581;
if(inst_30566){
var statearr_30742_30904 = state_30581__$1;
(statearr_30742_30904[(1)] = (121));

} else {
var statearr_30743_30905 = state_30581__$1;
(statearr_30743_30905[(1)] = (122));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (79))){
var inst_30303 = (state_30581[(31)]);
var inst_30428 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30744 = state_30581;
(statearr_30744[(86)] = inst_30428);

return statearr_30744;
})();
if(cljs.core.truth_(inst_30303)){
var statearr_30745_30906 = state_30581__$1;
(statearr_30745_30906[(1)] = (80));

} else {
var statearr_30746_30907 = state_30581__$1;
(statearr_30746_30907[(1)] = (81));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (38))){
var inst_30233 = (state_30581[(62)]);
var state_30581__$1 = state_30581;
var statearr_30747_30908 = state_30581__$1;
(statearr_30747_30908[(2)] = inst_30233);

(statearr_30747_30908[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (98))){
var inst_30478 = (state_30581[(67)]);
var inst_30476 = (state_30581[(68)]);
var inst_30368 = (state_30581[(15)]);
var inst_30481 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30482 = (inst_30476 - inst_30478);
var inst_30483 = [inst_30368,inst_30482];
var inst_30484 = (new cljs.core.PersistentVector(null,2,(5),inst_30481,inst_30483,null));
var state_30581__$1 = state_30581;
var statearr_30748_30909 = state_30581__$1;
(statearr_30748_30909[(2)] = inst_30484);

(statearr_30748_30909[(1)] = (100));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (87))){
var inst_30437 = (state_30581[(85)]);
var state_30581__$1 = state_30581;
var statearr_30749_30910 = state_30581__$1;
(statearr_30749_30910[(2)] = inst_30437);

(statearr_30749_30910[(1)] = (88));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (30))){
var inst_30302 = (state_30581[(74)]);
var inst_30315 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30302);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(33),inst_30315);
} else {
if((state_val_30582 === (73))){
var inst_30247 = (state_30581[(32)]);
var inst_30416 = (state_30581[(2)]);
var state_30581__$1 = (function (){var statearr_30750 = state_30581;
(statearr_30750[(12)] = inst_30416);

return statearr_30750;
})();
if(cljs.core.truth_(inst_30247)){
var statearr_30751_30911 = state_30581__$1;
(statearr_30751_30911[(1)] = (74));

} else {
var statearr_30752_30912 = state_30581__$1;
(statearr_30752_30912[(1)] = (75));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (96))){
var inst_30368 = (state_30581[(15)]);
var inst_30362 = (state_30581[(19)]);
var inst_30400 = (state_30581[(26)]);
var inst_30401 = (state_30581[(40)]);
var inst_30468 = (state_30581[(70)]);
var inst_30517 = fluree.db.query.range.subject_groups__GT_allow_flakes(db,inst_30468,inst_30400,inst_30401,inst_30362,inst_30368);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(104),inst_30517);
} else {
if((state_val_30582 === (10))){
var inst_30239 = (state_30581[(84)]);
var inst_30261 = fluree.db.dbproto._subid.cljs$core$IFn$_invoke$arity$2(db,inst_30239);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(13),inst_30261);
} else {
if((state_val_30582 === (18))){
var state_30581__$1 = state_30581;
var statearr_30753_30913 = state_30581__$1;
(statearr_30753_30913[(1)] = (20));



return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (105))){
var inst_30435 = (state_30581[(65)]);
var inst_30540 = (state_30581[(82)]);
var inst_30359 = (state_30581[(30)]);
var inst_30374 = (state_30581[(33)]);
var inst_30539 = (inst_30374.cljs$core$IFn$_invoke$arity$2 ? inst_30374.cljs$core$IFn$_invoke$arity$2(inst_30435,inst_30359) : inst_30374.call(null,inst_30435,inst_30359));
var inst_30540__$1 = (inst_30539 < (0));
var state_30581__$1 = (function (){var statearr_30755 = state_30581;
(statearr_30755[(82)] = inst_30540__$1);

return statearr_30755;
})();
if(cljs.core.truth_(inst_30540__$1)){
var statearr_30756_30914 = state_30581__$1;
(statearr_30756_30914[(1)] = (108));

} else {
var statearr_30757_30915 = state_30581__$1;
(statearr_30757_30915[(1)] = (109));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (52))){
var inst_30244 = (state_30581[(58)]);
var state_30581__$1 = state_30581;
var statearr_30758_30916 = state_30581__$1;
(statearr_30758_30916[(2)] = inst_30244);

(statearr_30758_30916[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (114))){
var inst_30435 = (state_30581[(65)]);
var inst_30380 = (state_30581[(21)]);
var inst_30375 = (state_30581[(34)]);
var inst_30379 = (state_30581[(37)]);
var inst_30385 = (state_30581[(39)]);
var inst_30555 = fluree.db.query.range.find_next_valid_node(inst_30385,inst_30435,inst_30375,inst_30379,inst_30380);
var state_30581__$1 = state_30581;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30581__$1,(117),inst_30555);
} else {
if((state_val_30582 === (67))){
var state_30581__$1 = state_30581;
var statearr_30759_30917 = state_30581__$1;
(statearr_30759_30917[(2)] = null);

(statearr_30759_30917[(1)] = (68));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (71))){
var inst_30235 = (state_30581[(10)]);
var inst_30398 = (state_30581[(11)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30368 = (state_30581[(15)]);
var inst_30238 = (state_30581[(16)]);
var inst_30399 = (state_30581[(17)]);
var inst_30236 = (state_30581[(18)]);
var inst_30362 = (state_30581[(19)]);
var inst_30300 = (state_30581[(20)]);
var inst_30380 = (state_30581[(21)]);
var inst_30231 = (state_30581[(22)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30400 = (state_30581[(26)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30389 = (state_30581[(8)]);
var inst_30321 = (state_30581[(29)]);
var inst_30359 = (state_30581[(30)]);
var inst_30303 = (state_30581[(31)]);
var inst_30247 = (state_30581[(32)]);
var inst_30374 = (state_30581[(33)]);
var inst_30375 = (state_30581[(34)]);
var inst_30408 = (state_30581[(35)]);
var inst_30369 = (state_30581[(36)]);
var inst_30379 = (state_30581[(37)]);
var inst_30258 = (state_30581[(38)]);
var inst_30385 = (state_30581[(39)]);
var inst_30401 = (state_30581[(40)]);
var inst_30248 = (state_30581[(41)]);
var inst_30358 = (state_30581[(42)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30402 = (state_30581[(45)]);
var inst_30299 = (state_30581[(46)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30395 = (state_30581[(9)]);
var inst_30412 = (function (){var no_filter_QMARK_ = inst_30395;
var t = inst_30375;
var max_limit_QMARK_ = inst_30369;
var next_node = inst_30398;
var fast_forward_db_QMARK_ = inst_30380;
var s1 = inst_30258;
var o2 = inst_30321;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var i = inst_30400;
var G__30409 = inst_30408;
var m1 = inst_30348;
var root_node = inst_30385;
var s2 = inst_30267;
var map__30230 = inst_30361;
var p2 = inst_30339;
var permissions = inst_30370;
var limit = inst_30368;
var start_flake = inst_30358;
var flake_limit = inst_30362;
var offset = inst_30399;
var vec__30224 = inst_30299;
var acc = inst_30402;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30312;
var end_flake = inst_30359;
var base_result = inst_30408;
var s = inst_30401;
var node_start = inst_30389;
var vec__30227 = inst_30300;
var p1 = inst_30330;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30303;
var idx_compare = inst_30374;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30357;
var map__30223 = inst_30246;
var novelty = inst_30379;
return (function (p1__30198_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__30198_SHARP_.o,start_flake.o);
});
})();
var inst_30413 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30412,inst_30408);
var state_30581__$1 = state_30581;
var statearr_30760_30918 = state_30581__$1;
(statearr_30760_30918[(2)] = inst_30413);

(statearr_30760_30918[(1)] = (73));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (42))){
var inst_30335 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
if(cljs.core.truth_(inst_30335)){
var statearr_30761_30919 = state_30581__$1;
(statearr_30761_30919[(1)] = (43));

} else {
var statearr_30762_30920 = state_30581__$1;
(statearr_30762_30920[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (80))){
var inst_30235 = (state_30581[(10)]);
var inst_30398 = (state_30581[(11)]);
var inst_30242 = (state_30581[(13)]);
var inst_30243 = (state_30581[(14)]);
var inst_30368 = (state_30581[(15)]);
var inst_30238 = (state_30581[(16)]);
var inst_30399 = (state_30581[(17)]);
var inst_30236 = (state_30581[(18)]);
var inst_30428 = (state_30581[(86)]);
var inst_30362 = (state_30581[(19)]);
var inst_30300 = (state_30581[(20)]);
var inst_30380 = (state_30581[(21)]);
var inst_30231 = (state_30581[(22)]);
var inst_30339 = (state_30581[(23)]);
var inst_30348 = (state_30581[(24)]);
var inst_30357 = (state_30581[(25)]);
var inst_30400 = (state_30581[(26)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30389 = (state_30581[(8)]);
var inst_30321 = (state_30581[(29)]);
var inst_30359 = (state_30581[(30)]);
var inst_30303 = (state_30581[(31)]);
var inst_30247 = (state_30581[(32)]);
var inst_30374 = (state_30581[(33)]);
var inst_30375 = (state_30581[(34)]);
var inst_30408 = (state_30581[(35)]);
var inst_30369 = (state_30581[(36)]);
var inst_30379 = (state_30581[(37)]);
var inst_30258 = (state_30581[(38)]);
var inst_30385 = (state_30581[(39)]);
var inst_30401 = (state_30581[(40)]);
var inst_30248 = (state_30581[(41)]);
var inst_30358 = (state_30581[(42)]);
var inst_30267 = (state_30581[(43)]);
var inst_30246 = (state_30581[(44)]);
var inst_30402 = (state_30581[(45)]);
var inst_30299 = (state_30581[(46)]);
var inst_30361 = (state_30581[(47)]);
var inst_30312 = (state_30581[(48)]);
var inst_30395 = (state_30581[(9)]);
var inst_30430 = (function (){var no_filter_QMARK_ = inst_30395;
var t = inst_30375;
var max_limit_QMARK_ = inst_30369;
var next_node = inst_30398;
var fast_forward_db_QMARK_ = inst_30380;
var s1 = inst_30258;
var o2 = inst_30321;
var t1 = inst_30235;
var predicate_fn = inst_30248;
var i = inst_30400;
var G__30409 = inst_30428;
var m1 = inst_30348;
var root_node = inst_30385;
var s2 = inst_30267;
var map__30230 = inst_30361;
var p2 = inst_30339;
var permissions = inst_30370;
var limit = inst_30368;
var start_flake = inst_30358;
var flake_limit = inst_30362;
var offset = inst_30399;
var vec__30224 = inst_30299;
var acc = inst_30402;
var t2 = inst_30242;
var op1 = inst_30236;
var o1 = inst_30312;
var end_flake = inst_30359;
var base_result = inst_30408;
var s = inst_30401;
var node_start = inst_30389;
var vec__30227 = inst_30300;
var p1 = inst_30330;
var subject_fn = inst_30247;
var vec__30217 = inst_30231;
var object_fn = inst_30303;
var idx_compare = inst_30374;
var vec__30220 = inst_30238;
var op2 = inst_30243;
var m2 = inst_30357;
var map__30223 = inst_30246;
var novelty = inst_30379;
return (function (p1__30201_SHARP_){
var G__30763 = p1__30201_SHARP_.o;
return (object_fn.cljs$core$IFn$_invoke$arity$1 ? object_fn.cljs$core$IFn$_invoke$arity$1(G__30763) : object_fn.call(null,G__30763));
});
})();
var inst_30431 = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(inst_30430,inst_30428);
var state_30581__$1 = state_30581;
var statearr_30764_30921 = state_30581__$1;
(statearr_30764_30921[(2)] = inst_30431);

(statearr_30764_30921[(1)] = (82));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (37))){
var state_30581__$1 = state_30581;
var statearr_30765_30922 = state_30581__$1;
(statearr_30765_30922[(2)] = (-1));

(statearr_30765_30922[(1)] = (39));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (63))){
var inst_30339 = (state_30581[(23)]);
var inst_30370 = (state_30581[(27)]);
var inst_30330 = (state_30581[(28)]);
var inst_30258 = (state_30581[(38)]);
var inst_30267 = (state_30581[(43)]);
var inst_30392 = fluree.db.permissions_validate.no_filter_QMARK_(inst_30370,inst_30258,inst_30267,inst_30330,inst_30339);
var state_30581__$1 = state_30581;
var statearr_30766_30923 = state_30581__$1;
(statearr_30766_30923[(2)] = inst_30392);

(statearr_30766_30923[(1)] = (65));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (94))){
var inst_30531 = (state_30581[(2)]);
var state_30581__$1 = state_30581;
var statearr_30767_30924 = state_30581__$1;
(statearr_30767_30924[(2)] = inst_30531);

(statearr_30767_30924[(1)] = (91));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (8))){
var inst_30239 = (state_30581[(84)]);
var inst_30258 = (state_30581[(2)]);
var inst_30259 = fluree.db.util.core.pred_ident_QMARK_(inst_30239);
var state_30581__$1 = (function (){var statearr_30768 = state_30581;
(statearr_30768[(38)] = inst_30258);

return statearr_30768;
})();
if(inst_30259){
var statearr_30769_30925 = state_30581__$1;
(statearr_30769_30925[(1)] = (10));

} else {
var statearr_30770_30926 = state_30581__$1;
(statearr_30770_30926[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (49))){
var state_30581__$1 = state_30581;
var statearr_30771_30927 = state_30581__$1;
(statearr_30771_30927[(2)] = fluree.db.util.core.min_integer);

(statearr_30771_30927[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30582 === (84))){
var inst_30369 = (state_30581[(36)]);
var state_30581__$1 = state_30581;
var statearr_30772_30928 = state_30581__$1;
(statearr_30772_30928[(2)] = inst_30369);

(statearr_30772_30928[(1)] = (85));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_30773 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_30773[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_30773[(1)] = (1));

return statearr_30773;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_30581){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30581);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e30774){var ex__16398__auto__ = e30774;
var statearr_30775_30929 = state_30581;
(statearr_30775_30929[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30581[(4)]))){
var statearr_30776_30930 = state_30581;
(statearr_30776_30930[(1)] = cljs.core.first((state_30581[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__30931 = state_30581;
state_30581 = G__30931;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_30581){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_30581);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_30777 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_30777[(6)] = c__16469__auto__);

return statearr_30777;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.index_range.cljs$lang$maxFixedArity = 7);

fluree.db.query.range.non_nil_non_boolean_QMARK_ = (function fluree$db$query$range$non_nil_non_boolean_QMARK_(o){
return (((!((o == null)))) && ((!(cljs.core.boolean_QMARK_(o)))));
});
fluree.db.query.range.tag_string_QMARK_ = (function fluree$db$query$range$tag_string_QMARK_(possible_tag){
return cljs.core.re_find(/^[a-zA-Z0-9-_]*\/[a-zA-Z0-9-_]*:[a-zA-Z0-9-]*$/,possible_tag);
});
fluree.db.query.range.tag_sid_start = fluree.db.flake.min_subject_id((3));
fluree.db.query.range.tag_sid_end = fluree.db.flake.max_subject_id((3));
/**
 * Returns true if flake is a root setting flake.
 */
fluree.db.query.range.is_tag_flake_QMARK_ = (function fluree$db$query$range$is_tag_flake_QMARK_(f){
return (((fluree.db.query.range.tag_sid_start <= f.o)) && ((f.o <= fluree.db.query.range.tag_sid_end)));
});
fluree.db.query.range.coerce_tag_flakes = (function fluree$db$query$range$coerce_tag_flakes(db,flakes){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_30987){
var state_val_30988 = (state_30987[(1)]);
if((state_val_30988 === (7))){
var inst_30951 = (state_30987[(7)]);
var inst_30961 = (state_30987[(8)]);
var inst_30959 = fluree.db.flake.Flake__GT_parts(inst_30951);
var inst_30960 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(0),null);
var inst_30961__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(1),null);
var inst_30962 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(2),null);
var inst_30963 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(3),null);
var inst_30964 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(4),null);
var inst_30965 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_30959,(5),null);
var inst_30966 = fluree.db.dbproto._tag.cljs$core$IFn$_invoke$arity$3(db,inst_30962,inst_30961__$1);
var state_30987__$1 = (function (){var statearr_30989 = state_30987;
(statearr_30989[(9)] = inst_30963);

(statearr_30989[(10)] = inst_30964);

(statearr_30989[(11)] = inst_30965);

(statearr_30989[(12)] = inst_30960);

(statearr_30989[(8)] = inst_30961__$1);

return statearr_30989;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_30987__$1,(10),inst_30966);
} else {
if((state_val_30988 === (1))){
var inst_30939 = flakes;
var inst_30940 = cljs.core.seq(inst_30939);
var inst_30941 = cljs.core.first(inst_30940);
var inst_30942 = cljs.core.next(inst_30940);
var inst_30943 = cljs.core.PersistentVector.EMPTY;
var inst_30944 = inst_30939;
var inst_30945 = inst_30943;
var state_30987__$1 = (function (){var statearr_30990 = state_30987;
(statearr_30990[(13)] = inst_30941);

(statearr_30990[(14)] = inst_30944);

(statearr_30990[(15)] = inst_30945);

(statearr_30990[(16)] = inst_30942);

return statearr_30990;
})();
var statearr_30991_31009 = state_30987__$1;
(statearr_30991_31009[(2)] = null);

(statearr_30991_31009[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (4))){
var inst_30951 = (state_30987[(7)]);
var inst_30954 = fluree.db.query.range.is_tag_flake_QMARK_(inst_30951);
var state_30987__$1 = state_30987;
if(inst_30954){
var statearr_30992_31010 = state_30987__$1;
(statearr_30992_31010[(1)] = (7));

} else {
var statearr_30993_31011 = state_30987__$1;
(statearr_30993_31011[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (6))){
var inst_30983 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
var statearr_30994_31012 = state_30987__$1;
(statearr_30994_31012[(2)] = inst_30983);

(statearr_30994_31012[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (3))){
var inst_30985 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
return cljs.core.async.impl.ioc_helpers.return_chan(state_30987__$1,inst_30985);
} else {
if((state_val_30988 === (2))){
var inst_30944 = (state_30987[(14)]);
var inst_30951 = (state_30987[(7)]);
var inst_30950 = cljs.core.seq(inst_30944);
var inst_30951__$1 = cljs.core.first(inst_30950);
var inst_30952 = cljs.core.next(inst_30950);
var state_30987__$1 = (function (){var statearr_30995 = state_30987;
(statearr_30995[(17)] = inst_30952);

(statearr_30995[(7)] = inst_30951__$1);

return statearr_30995;
})();
if(cljs.core.truth_(inst_30951__$1)){
var statearr_30996_31013 = state_30987__$1;
(statearr_30996_31013[(1)] = (4));

} else {
var statearr_30997_31014 = state_30987__$1;
(statearr_30997_31014[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (9))){
var inst_30980 = (state_30987[(2)]);
var state_30987__$1 = state_30987;
var statearr_30998_31015 = state_30987__$1;
(statearr_30998_31015[(2)] = inst_30980);

(statearr_30998_31015[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (5))){
var inst_30945 = (state_30987[(15)]);
var state_30987__$1 = state_30987;
var statearr_30999_31016 = state_30987__$1;
(statearr_30999_31016[(2)] = inst_30945);

(statearr_30999_31016[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (10))){
var inst_30952 = (state_30987[(17)]);
var inst_30963 = (state_30987[(9)]);
var inst_30964 = (state_30987[(10)]);
var inst_30965 = (state_30987[(11)]);
var inst_30945 = (state_30987[(15)]);
var inst_30960 = (state_30987[(12)]);
var inst_30961 = (state_30987[(8)]);
var inst_30968 = (state_30987[(2)]);
var inst_30969 = fluree.db.util.async.throw_err(inst_30968);
var inst_30970 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_30971 = [inst_30960,inst_30961,inst_30969,inst_30963,inst_30964,inst_30965];
var inst_30972 = (new cljs.core.PersistentVector(null,6,(5),inst_30970,inst_30971,null));
var inst_30973 = fluree.db.flake.parts__GT_Flake.cljs$core$IFn$_invoke$arity$1(inst_30972);
var inst_30974 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30945,inst_30973);
var inst_30944 = inst_30952;
var inst_30945__$1 = inst_30974;
var state_30987__$1 = (function (){var statearr_31000 = state_30987;
(statearr_31000[(14)] = inst_30944);

(statearr_31000[(15)] = inst_30945__$1);

return statearr_31000;
})();
var statearr_31001_31017 = state_30987__$1;
(statearr_31001_31017[(2)] = null);

(statearr_31001_31017[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_30988 === (8))){
var inst_30952 = (state_30987[(17)]);
var inst_30951 = (state_30987[(7)]);
var inst_30945 = (state_30987[(15)]);
var inst_30977 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_30945,inst_30951);
var inst_30944 = inst_30952;
var inst_30945__$1 = inst_30977;
var state_30987__$1 = (function (){var statearr_31002 = state_30987;
(statearr_31002[(14)] = inst_30944);

(statearr_31002[(15)] = inst_30945__$1);

return statearr_31002;
})();
var statearr_31003_31018 = state_30987__$1;
(statearr_31003_31018[(2)] = null);

(statearr_31003_31018[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__ = null;
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0 = (function (){
var statearr_31004 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31004[(0)] = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__);

(statearr_31004[(1)] = (1));

return statearr_31004;
});
var fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1 = (function (state_30987){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_30987);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31005){var ex__16398__auto__ = e31005;
var statearr_31006_31019 = state_30987;
(statearr_31006_31019[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_30987[(4)]))){
var statearr_31007_31020 = state_30987;
(statearr_31007_31020[(1)] = cljs.core.first((state_30987[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31021 = state_30987;
state_30987 = G__31021;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__ = function(state_30987){
switch(arguments.length){
case 0:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1.call(this,state_30987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____0;
fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto____1;
return fluree$db$query$range$coerce_tag_flakes_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31008 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31008[(6)] = c__16469__auto__);

return statearr_31008;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.query.range.search = (function fluree$db$query$range$search(var_args){
var G__31023 = arguments.length;
switch (G__31023) {
case 2:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$2 = (function (db,fparts){
return fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3(db,fparts,cljs.core.PersistentArrayMap.EMPTY);
}));

(fluree.db.query.range.search.cljs$core$IFn$_invoke$arity$3 = (function (db,fparts,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31193){
var state_val_31194 = (state_31193[(1)]);
if((state_val_31194 === (65))){
var state_31193__$1 = state_31193;
var statearr_31195_31295 = state_31193__$1;
(statearr_31195_31295[(2)] = null);

(statearr_31195_31295[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (70))){
var inst_31188 = (state_31193[(2)]);
var _ = (function (){var statearr_31196 = state_31193;
(statearr_31196[(4)] = cljs.core.rest((state_31193[(4)])));

return statearr_31196;
})();
var state_31193__$1 = state_31193;
var statearr_31197_31296 = state_31193__$1;
(statearr_31197_31296[(2)] = inst_31188);

(statearr_31197_31296[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (62))){
var inst_31174 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31198_31297 = state_31193__$1;
(statearr_31198_31297[(2)] = inst_31174);

(statearr_31198_31297[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (7))){
var state_31193__$1 = state_31193;
var statearr_31199_31298 = state_31193__$1;
(statearr_31199_31298[(2)] = false);

(statearr_31199_31298[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (59))){
var inst_31148 = (state_31193[(2)]);
var inst_31149 = fluree.db.util.async.throw_err(inst_31148);
var state_31193__$1 = state_31193;
var statearr_31200_31299 = state_31193__$1;
(statearr_31200_31299[(2)] = inst_31149);

(statearr_31200_31299[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (20))){
var state_31193__$1 = state_31193;
var statearr_31201_31300 = state_31193__$1;
(statearr_31201_31300[(2)] = null);

(statearr_31201_31300[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (58))){
var inst_31138 = (state_31193[(2)]);
var inst_31139 = fluree.db.util.async.throw_err(inst_31138);
var inst_31140 = cljs.core.take.cljs$core$IFn$_invoke$arity$2((1),inst_31139);
var state_31193__$1 = state_31193;
var statearr_31202_31301 = state_31193__$1;
(statearr_31202_31301[(2)] = inst_31140);

(statearr_31202_31301[(1)] = (57));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (60))){
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31037 = (state_31193[(10)]);
var inst_31154 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31155 = [inst_31035,inst_31034,inst_31074,inst_31037];
var inst_31156 = (new cljs.core.PersistentVector(null,4,(5),inst_31154,inst_31155,null));
var inst_31157 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31156,opts);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(63),inst_31157);
} else {
if((state_val_31194 === (27))){
var inst_31074 = (state_31193[(9)]);
var inst_31085 = (state_31193[(11)]);
var inst_31085__$1 = fluree.db.query.range.non_nil_non_boolean_QMARK_(inst_31074);
var state_31193__$1 = (function (){var statearr_31203 = state_31193;
(statearr_31203[(11)] = inst_31085__$1);

return statearr_31203;
})();
if(inst_31085__$1){
var statearr_31204_31302 = state_31193__$1;
(statearr_31204_31302[(1)] = (30));

} else {
var statearr_31205_31303 = state_31193__$1;
(statearr_31205_31303[(1)] = (31));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (1))){
var state_31193__$1 = state_31193;
var statearr_31206_31304 = state_31193__$1;
(statearr_31206_31304[(2)] = null);

(statearr_31206_31304[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (69))){
var inst_31180 = (state_31193[(12)]);
var state_31193__$1 = state_31193;
var statearr_31207_31305 = state_31193__$1;
(statearr_31207_31305[(2)] = inst_31180);

(statearr_31207_31305[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (24))){
var inst_31035 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31035)){
var statearr_31208_31306 = state_31193__$1;
(statearr_31208_31306[(1)] = (27));

} else {
var statearr_31209_31307 = state_31193__$1;
(statearr_31209_31307[(1)] = (28));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (55))){
var inst_31074 = (state_31193[(9)]);
var inst_31132 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31133 = [inst_31074];
var inst_31134 = (new cljs.core.PersistentVector(null,1,(5),inst_31132,inst_31133,null));
var inst_31135 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$limit,(1));
var inst_31136 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31134,inst_31135);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(58),inst_31136);
} else {
if((state_val_31194 === (39))){
var inst_31105 = (state_31193[(2)]);
var inst_31106 = fluree.db.util.async.throw_err(inst_31105);
var state_31193__$1 = state_31193;
var statearr_31210_31308 = state_31193__$1;
(statearr_31210_31308[(2)] = inst_31106);

(statearr_31210_31308[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (46))){
var inst_31118 = (state_31193[(13)]);
var inst_31118__$1 = cljs.core.cst$kw$object_DASH_fn.cljs$core$IFn$_invoke$arity$1(opts);
var state_31193__$1 = (function (){var statearr_31211 = state_31193;
(statearr_31211[(13)] = inst_31118__$1);

return statearr_31211;
})();
if(cljs.core.truth_(inst_31118__$1)){
var statearr_31212_31309 = state_31193__$1;
(statearr_31212_31309[(1)] = (49));

} else {
var statearr_31213_31310 = state_31193__$1;
(statearr_31213_31310[(1)] = (50));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (4))){
var inst_31024 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31214_31311 = state_31193__$1;
(statearr_31214_31311[(2)] = inst_31024);

(statearr_31214_31311[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (54))){
var inst_31130 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31130)){
var statearr_31215_31312 = state_31193__$1;
(statearr_31215_31312[(1)] = (55));

} else {
var statearr_31216_31313 = state_31193__$1;
(statearr_31216_31313[(1)] = (56));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (15))){
var inst_31036 = (state_31193[(14)]);
var inst_31055 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31036);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(18),inst_31055);
} else {
if((state_val_31194 === (48))){
var inst_31176 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31217_31314 = state_31193__$1;
(statearr_31217_31314[(2)] = inst_31176);

(statearr_31217_31314[(1)] = (38));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (50))){
var inst_31033 = (state_31193[(15)]);
var inst_31044 = (state_31193[(16)]);
var inst_31118 = (state_31193[(13)]);
var inst_31038 = (state_31193[(17)]);
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31049 = (state_31193[(18)]);
var inst_31037 = (state_31193[(10)]);
var inst_31122 = (function (){var t = inst_31037;
var p = inst_31035;
var idx_predicate_QMARK_ = inst_31038;
var o = inst_31074;
var vec__31030 = inst_31033;
var tag_predicate_QMARK_ = inst_31044;
var temp__5751__auto__ = inst_31118;
var s = inst_31034;
var o_coerce_QMARK_ = inst_31049;
return (function (x){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
});
})();
var state_31193__$1 = state_31193;
var statearr_31218_31315 = state_31193__$1;
(statearr_31218_31315[(2)] = inst_31122);

(statearr_31218_31315[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (21))){
var inst_31070 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31219_31316 = state_31193__$1;
(statearr_31219_31316[(2)] = inst_31070);

(statearr_31219_31316[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (31))){
var inst_31085 = (state_31193[(11)]);
var state_31193__$1 = state_31193;
var statearr_31220_31317 = state_31193__$1;
(statearr_31220_31317[(2)] = inst_31085);

(statearr_31220_31317[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (32))){
var inst_31095 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31221_31318 = state_31193__$1;
(statearr_31221_31318[(2)] = inst_31095);

(statearr_31221_31318[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (40))){
var inst_31038 = (state_31193[(17)]);
var inst_31109 = (state_31193[(19)]);
var inst_31109__$1 = cljs.core.not(inst_31038);
var state_31193__$1 = (function (){var statearr_31222 = state_31193;
(statearr_31222[(19)] = inst_31109__$1);

return statearr_31222;
})();
if(inst_31109__$1){
var statearr_31223_31319 = state_31193__$1;
(statearr_31223_31319[(1)] = (43));

} else {
var statearr_31224_31320 = state_31193__$1;
(statearr_31224_31320[(1)] = (44));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (56))){
var inst_31124 = (state_31193[(20)]);
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31037 = (state_31193[(10)]);
var inst_31142 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31143 = [inst_31035,inst_31034,null,inst_31037];
var inst_31144 = (new cljs.core.PersistentVector(null,4,(5),inst_31142,inst_31143,null));
var inst_31145 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,cljs.core.cst$kw$object_DASH_fn,inst_31124);
var inst_31146 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$psot,cljs.core._EQ_,inst_31144,inst_31145);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(59),inst_31146);
} else {
if((state_val_31194 === (33))){
var inst_31074 = (state_31193[(9)]);
var inst_31088 = cljs.core.fn_QMARK_(inst_31074);
var inst_31089 = (!(inst_31088));
var state_31193__$1 = state_31193;
var statearr_31225_31321 = state_31193__$1;
(statearr_31225_31321[(2)] = inst_31089);

(statearr_31225_31321[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (13))){
var inst_31036 = (state_31193[(14)]);
var inst_31053 = fluree.db.query.range.tag_string_QMARK_(inst_31036);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31053)){
var statearr_31226_31322 = state_31193__$1;
(statearr_31226_31322[(1)] = (15));

} else {
var statearr_31227_31323 = state_31193__$1;
(statearr_31227_31323[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (22))){
var inst_31066 = (state_31193[(2)]);
var inst_31067 = fluree.db.util.async.throw_err(inst_31066);
var state_31193__$1 = state_31193;
var statearr_31228_31324 = state_31193__$1;
(statearr_31228_31324[(2)] = inst_31067);

(statearr_31228_31324[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (36))){
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31037 = (state_31193[(10)]);
var inst_31100 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31101 = [inst_31035,inst_31074,inst_31034,inst_31037];
var inst_31102 = (new cljs.core.PersistentVector(null,4,(5),inst_31100,inst_31101,null));
var inst_31103 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$post,cljs.core._EQ_,inst_31102,opts);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(39),inst_31103);
} else {
if((state_val_31194 === (41))){
var inst_31035 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
var statearr_31229_31325 = state_31193__$1;
(statearr_31229_31325[(2)] = inst_31035);

(statearr_31229_31325[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (43))){
var inst_31074 = (state_31193[(9)]);
var state_31193__$1 = state_31193;
var statearr_31230_31326 = state_31193__$1;
(statearr_31230_31326[(2)] = inst_31074);

(statearr_31230_31326[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (61))){
var inst_31074 = (state_31193[(9)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31074)){
var statearr_31231_31327 = state_31193__$1;
(statearr_31231_31327[(1)] = (64));

} else {
var statearr_31232_31328 = state_31193__$1;
(statearr_31232_31328[(1)] = (65));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (29))){
var inst_31098 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31098)){
var statearr_31233_31329 = state_31193__$1;
(statearr_31233_31329[(1)] = (36));

} else {
var statearr_31234_31330 = state_31193__$1;
(statearr_31234_31330[(1)] = (37));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (44))){
var inst_31109 = (state_31193[(19)]);
var state_31193__$1 = state_31193;
var statearr_31235_31331 = state_31193__$1;
(statearr_31235_31331[(2)] = inst_31109);

(statearr_31235_31331[(1)] = (45));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (6))){
var inst_31035 = (state_31193[(8)]);
var inst_31040 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$type,inst_31035);
var inst_31041 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$tag,inst_31040);
var state_31193__$1 = state_31193;
var statearr_31236_31332 = state_31193__$1;
(statearr_31236_31332[(2)] = inst_31041);

(statearr_31236_31332[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (28))){
var inst_31035 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
var statearr_31237_31333 = state_31193__$1;
(statearr_31237_31333[(2)] = inst_31035);

(statearr_31237_31333[(1)] = (29));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (64))){
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31037 = (state_31193[(10)]);
var inst_31163 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31164 = [inst_31074,inst_31035,inst_31034,inst_31037];
var inst_31165 = (new cljs.core.PersistentVector(null,4,(5),inst_31163,inst_31164,null));
var inst_31166 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$opst,cljs.core._EQ_,inst_31165,opts);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(67),inst_31166);
} else {
if((state_val_31194 === (51))){
var inst_31125 = (state_31193[(21)]);
var inst_31035 = (state_31193[(8)]);
var inst_31124 = (state_31193[(2)]);
var inst_31125__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2("_id",inst_31035);
var state_31193__$1 = (function (){var statearr_31238 = state_31193;
(statearr_31238[(20)] = inst_31124);

(statearr_31238[(21)] = inst_31125__$1);

return statearr_31238;
})();
if(inst_31125__$1){
var statearr_31239_31334 = state_31193__$1;
(statearr_31239_31334[(1)] = (52));

} else {
var statearr_31240_31335 = state_31193__$1;
(statearr_31240_31335[(1)] = (53));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (25))){
var inst_31044 = (state_31193[(16)]);
var inst_31180 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31241 = state_31193;
(statearr_31241[(12)] = inst_31180);

return statearr_31241;
})();
if(cljs.core.truth_(inst_31044)){
var statearr_31242_31336 = state_31193__$1;
(statearr_31242_31336[(1)] = (68));

} else {
var statearr_31243_31337 = state_31193__$1;
(statearr_31243_31337[(1)] = (69));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (34))){
var inst_31038 = (state_31193[(17)]);
var state_31193__$1 = state_31193;
var statearr_31244_31338 = state_31193__$1;
(statearr_31244_31338[(2)] = inst_31038);

(statearr_31244_31338[(1)] = (35));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (17))){
var inst_31072 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31245_31339 = state_31193__$1;
(statearr_31245_31339[(2)] = inst_31072);

(statearr_31245_31339[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (3))){
var inst_31191 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31193__$1,inst_31191);
} else {
if((state_val_31194 === (12))){
var inst_31036 = (state_31193[(14)]);
var state_31193__$1 = state_31193;
var statearr_31246_31340 = state_31193__$1;
(statearr_31246_31340[(2)] = inst_31036);

(statearr_31246_31340[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (2))){
var inst_31033 = (state_31193[(15)]);
var inst_31035 = (state_31193[(8)]);
var _ = (function (){var statearr_31247 = state_31193;
(statearr_31247[(4)] = cljs.core.cons((5),(state_31193[(4)])));

return statearr_31247;
})();
var inst_31033__$1 = fparts;
var inst_31034 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31033__$1,(0),null);
var inst_31035__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31033__$1,(1),null);
var inst_31036 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31033__$1,(2),null);
var inst_31037 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_31033__$1,(3),null);
var inst_31038 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$idx_QMARK_,inst_31035__$1);
var state_31193__$1 = (function (){var statearr_31248 = state_31193;
(statearr_31248[(15)] = inst_31033__$1);

(statearr_31248[(17)] = inst_31038);

(statearr_31248[(7)] = inst_31034);

(statearr_31248[(14)] = inst_31036);

(statearr_31248[(8)] = inst_31035__$1);

(statearr_31248[(10)] = inst_31037);

return statearr_31248;
})();
if(cljs.core.truth_(inst_31035__$1)){
var statearr_31249_31341 = state_31193__$1;
(statearr_31249_31341[(1)] = (6));

} else {
var statearr_31250_31342 = state_31193__$1;
(statearr_31250_31342[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (66))){
var inst_31172 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31251_31343 = state_31193__$1;
(statearr_31251_31343[(2)] = inst_31172);

(statearr_31251_31343[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (23))){
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31037 = (state_31193[(10)]);
var inst_31076 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31077 = [inst_31034,inst_31035,inst_31074,inst_31037];
var inst_31078 = (new cljs.core.PersistentVector(null,4,(5),inst_31076,inst_31077,null));
var inst_31079 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$5(db,cljs.core.cst$kw$spot,cljs.core._EQ_,inst_31078,opts);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(26),inst_31079);
} else {
if((state_val_31194 === (47))){
var inst_31035 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31035)){
var statearr_31252_31344 = state_31193__$1;
(statearr_31252_31344[(1)] = (60));

} else {
var statearr_31253_31345 = state_31193__$1;
(statearr_31253_31345[(1)] = (61));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (35))){
var inst_31092 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31254_31346 = state_31193__$1;
(statearr_31254_31346[(2)] = inst_31092);

(statearr_31254_31346[(1)] = (32));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (19))){
var inst_31036 = (state_31193[(14)]);
var inst_31035 = (state_31193[(8)]);
var inst_31062 = fluree.db.dbproto._p_prop(db,cljs.core.cst$kw$name,inst_31035);
var inst_31063 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31062),":",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_31036)].join('');
var inst_31064 = fluree.db.dbproto._tag_id.cljs$core$IFn$_invoke$arity$2(db,inst_31063);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(22),inst_31064);
} else {
if((state_val_31194 === (57))){
var inst_31151 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31255_31347 = state_31193__$1;
(statearr_31255_31347[(2)] = inst_31151);

(statearr_31255_31347[(1)] = (48));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (68))){
var inst_31180 = (state_31193[(12)]);
var inst_31182 = fluree.db.query.range.coerce_tag_flakes(db,inst_31180);
var state_31193__$1 = state_31193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31193__$1,(71),inst_31182);
} else {
if((state_val_31194 === (11))){
var inst_31049 = (state_31193[(18)]);
var inst_31049__$1 = (state_31193[(2)]);
var inst_31050 = cljs.core.not(inst_31049__$1);
var state_31193__$1 = (function (){var statearr_31257 = state_31193;
(statearr_31257[(18)] = inst_31049__$1);

return statearr_31257;
})();
if(inst_31050){
var statearr_31258_31348 = state_31193__$1;
(statearr_31258_31348[(1)] = (12));

} else {
var statearr_31259_31349 = state_31193__$1;
(statearr_31259_31349[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (9))){
var inst_31036 = (state_31193[(14)]);
var inst_31046 = typeof inst_31036 === 'string';
var state_31193__$1 = state_31193;
var statearr_31260_31350 = state_31193__$1;
(statearr_31260_31350[(2)] = inst_31046);

(statearr_31260_31350[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (5))){
var _ = (function (){var statearr_31261 = state_31193;
(statearr_31261[(4)] = cljs.core.rest((state_31193[(4)])));

return statearr_31261;
})();
var state_31193__$1 = state_31193;
var ex31256 = (state_31193__$1[(2)]);
var statearr_31262_31351 = state_31193__$1;
(statearr_31262_31351[(5)] = ex31256);


if((ex31256 instanceof Error)){
var statearr_31263_31352 = state_31193__$1;
(statearr_31263_31352[(1)] = (4));

(statearr_31263_31352[(5)] = null);

} else {
throw ex31256;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (14))){
var inst_31034 = (state_31193[(7)]);
var inst_31074 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31264 = state_31193;
(statearr_31264[(9)] = inst_31074);

return statearr_31264;
})();
if(cljs.core.truth_(inst_31034)){
var statearr_31265_31353 = state_31193__$1;
(statearr_31265_31353[(1)] = (23));

} else {
var statearr_31266_31354 = state_31193__$1;
(statearr_31266_31354[(1)] = (24));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (45))){
var inst_31113 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31267_31355 = state_31193__$1;
(statearr_31267_31355[(2)] = inst_31113);

(statearr_31267_31355[(1)] = (42));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (53))){
var inst_31125 = (state_31193[(21)]);
var state_31193__$1 = state_31193;
var statearr_31268_31356 = state_31193__$1;
(statearr_31268_31356[(2)] = inst_31125);

(statearr_31268_31356[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (26))){
var inst_31081 = (state_31193[(2)]);
var inst_31082 = fluree.db.util.async.throw_err(inst_31081);
var state_31193__$1 = state_31193;
var statearr_31269_31357 = state_31193__$1;
(statearr_31269_31357[(2)] = inst_31082);

(statearr_31269_31357[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (16))){
var inst_31036 = (state_31193[(14)]);
var inst_31060 = typeof inst_31036 === 'string';
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31060)){
var statearr_31270_31358 = state_31193__$1;
(statearr_31270_31358[(1)] = (19));

} else {
var statearr_31271_31359 = state_31193__$1;
(statearr_31271_31359[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (38))){
var inst_31178 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
var statearr_31272_31360 = state_31193__$1;
(statearr_31272_31360[(2)] = inst_31178);

(statearr_31272_31360[(1)] = (25));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (30))){
var inst_31038 = (state_31193[(17)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31038)){
var statearr_31273_31361 = state_31193__$1;
(statearr_31273_31361[(1)] = (33));

} else {
var statearr_31274_31362 = state_31193__$1;
(statearr_31274_31362[(1)] = (34));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (10))){
var inst_31044 = (state_31193[(16)]);
var state_31193__$1 = state_31193;
var statearr_31275_31363 = state_31193__$1;
(statearr_31275_31363[(2)] = inst_31044);

(statearr_31275_31363[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (18))){
var inst_31057 = (state_31193[(2)]);
var inst_31058 = fluree.db.util.async.throw_err(inst_31057);
var state_31193__$1 = state_31193;
var statearr_31276_31364 = state_31193__$1;
(statearr_31276_31364[(2)] = inst_31058);

(statearr_31276_31364[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (52))){
var inst_31074 = (state_31193[(9)]);
var inst_31127 = cljs.core.int_QMARK_(inst_31074);
var state_31193__$1 = state_31193;
var statearr_31277_31365 = state_31193__$1;
(statearr_31277_31365[(2)] = inst_31127);

(statearr_31277_31365[(1)] = (54));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (67))){
var inst_31168 = (state_31193[(2)]);
var inst_31169 = fluree.db.util.async.throw_err(inst_31168);
var state_31193__$1 = state_31193;
var statearr_31278_31366 = state_31193__$1;
(statearr_31278_31366[(2)] = inst_31169);

(statearr_31278_31366[(1)] = (66));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (71))){
var inst_31184 = (state_31193[(2)]);
var inst_31185 = fluree.db.util.async.throw_err(inst_31184);
var state_31193__$1 = state_31193;
var statearr_31279_31367 = state_31193__$1;
(statearr_31279_31367[(2)] = inst_31185);

(statearr_31279_31367[(1)] = (70));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (42))){
var inst_31116 = (state_31193[(2)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31116)){
var statearr_31280_31368 = state_31193__$1;
(statearr_31280_31368[(1)] = (46));

} else {
var statearr_31281_31369 = state_31193__$1;
(statearr_31281_31369[(1)] = (47));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (37))){
var inst_31035 = (state_31193[(8)]);
var state_31193__$1 = state_31193;
if(cljs.core.truth_(inst_31035)){
var statearr_31282_31370 = state_31193__$1;
(statearr_31282_31370[(1)] = (40));

} else {
var statearr_31283_31371 = state_31193__$1;
(statearr_31283_31371[(1)] = (41));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (63))){
var inst_31159 = (state_31193[(2)]);
var inst_31160 = fluree.db.util.async.throw_err(inst_31159);
var state_31193__$1 = state_31193;
var statearr_31284_31372 = state_31193__$1;
(statearr_31284_31372[(2)] = inst_31160);

(statearr_31284_31372[(1)] = (62));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (8))){
var inst_31044 = (state_31193[(16)]);
var inst_31044__$1 = (state_31193[(2)]);
var state_31193__$1 = (function (){var statearr_31285 = state_31193;
(statearr_31285[(16)] = inst_31044__$1);

return statearr_31285;
})();
if(cljs.core.truth_(inst_31044__$1)){
var statearr_31286_31373 = state_31193__$1;
(statearr_31286_31373[(1)] = (9));

} else {
var statearr_31287_31374 = state_31193__$1;
(statearr_31287_31374[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31194 === (49))){
var inst_31033 = (state_31193[(15)]);
var inst_31044 = (state_31193[(16)]);
var inst_31118 = (state_31193[(13)]);
var inst_31038 = (state_31193[(17)]);
var inst_31034 = (state_31193[(7)]);
var inst_31035 = (state_31193[(8)]);
var inst_31074 = (state_31193[(9)]);
var inst_31049 = (state_31193[(18)]);
var inst_31037 = (state_31193[(10)]);
var inst_31120 = (function (){var obj_fn = inst_31118;
var t = inst_31037;
var p = inst_31035;
var idx_predicate_QMARK_ = inst_31038;
var o = inst_31074;
var vec__31030 = inst_31033;
var tag_predicate_QMARK_ = inst_31044;
var temp__5751__auto__ = inst_31118;
var s = inst_31034;
var o_coerce_QMARK_ = inst_31049;
return (function (x){
var and__4210__auto__ = (obj_fn.cljs$core$IFn$_invoke$arity$1 ? obj_fn.cljs$core$IFn$_invoke$arity$1(x) : obj_fn.call(null,x));
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,o);
} else {
return and__4210__auto__;
}
});
})();
var state_31193__$1 = state_31193;
var statearr_31288_31375 = state_31193__$1;
(statearr_31288_31375[(2)] = inst_31120);

(statearr_31288_31375[(1)] = (51));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_31289 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_31289[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_31289[(1)] = (1));

return statearr_31289;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_31193){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31193);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31290){var ex__16398__auto__ = e31290;
var statearr_31291_31376 = state_31193;
(statearr_31291_31376[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31193[(4)]))){
var statearr_31292_31377 = state_31193;
(statearr_31292_31377[(1)] = cljs.core.first((state_31193[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31378 = state_31193;
state_31193 = G__31378;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_31193){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_31193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31293 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31293[(6)] = c__16469__auto__);

return statearr_31293;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.search.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range.collection = (function fluree$db$query$range$collection(var_args){
var G__31380 = arguments.length;
switch (G__31380) {
case 2:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$2 = (function (db,name){
return fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3(db,name,null);
}));

(fluree.db.query.range.collection.cljs$core$IFn$_invoke$arity$3 = (function (db,name,opts){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_31415){
var state_val_31416 = (state_31415[(1)]);
if((state_val_31416 === (7))){
var inst_31402 = cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([name], 0));
var inst_31403 = ["Invalid collection name: ",inst_31402].join('');
var inst_31404 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_31405 = [(400),cljs.core.cst$kw$db_SLASH_invalid_DASH_collection];
var inst_31406 = cljs.core.PersistentHashMap.fromArrays(inst_31404,inst_31405);
var inst_31407 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_31403,inst_31406);
var inst_31408 = (function(){throw inst_31407})();
var state_31415__$1 = state_31415;
var statearr_31417_31437 = state_31415__$1;
(statearr_31417_31437[(2)] = inst_31408);

(statearr_31417_31437[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (1))){
var state_31415__$1 = state_31415;
var statearr_31418_31438 = state_31415__$1;
(statearr_31418_31438[(2)] = null);

(statearr_31418_31438[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (4))){
var inst_31381 = (state_31415[(2)]);
var state_31415__$1 = state_31415;
var statearr_31419_31439 = state_31415__$1;
(statearr_31419_31439[(2)] = inst_31381);

(statearr_31419_31439[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (6))){
var inst_31387 = (state_31415[(7)]);
var inst_31389 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31390 = fluree.db.flake.max_subject_id(inst_31387);
var inst_31391 = [inst_31390];
var inst_31392 = (new cljs.core.PersistentVector(null,1,(5),inst_31389,inst_31391,null));
var inst_31393 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_31394 = fluree.db.flake.min_subject_id(inst_31387);
var inst_31395 = [inst_31394];
var inst_31396 = (new cljs.core.PersistentVector(null,1,(5),inst_31393,inst_31395,null));
var inst_31397 = fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT__EQ_,inst_31392,cljs.core._LT__EQ_,inst_31396,opts);
var state_31415__$1 = state_31415;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_31415__$1,(9),inst_31397);
} else {
if((state_val_31416 === (3))){
var inst_31413 = (state_31415[(2)]);
var state_31415__$1 = state_31415;
return cljs.core.async.impl.ioc_helpers.return_chan(state_31415__$1,inst_31413);
} else {
if((state_val_31416 === (2))){
var inst_31387 = (state_31415[(7)]);
var _ = (function (){var statearr_31421 = state_31415;
(statearr_31421[(4)] = cljs.core.cons((5),(state_31415[(4)])));

return statearr_31421;
})();
var inst_31387__$1 = fluree.db.dbproto._c_prop(db,cljs.core.cst$kw$partition,name);
var state_31415__$1 = (function (){var statearr_31422 = state_31415;
(statearr_31422[(7)] = inst_31387__$1);

return statearr_31422;
})();
if(cljs.core.truth_(inst_31387__$1)){
var statearr_31423_31440 = state_31415__$1;
(statearr_31423_31440[(1)] = (6));

} else {
var statearr_31424_31441 = state_31415__$1;
(statearr_31424_31441[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (9))){
var inst_31399 = (state_31415[(2)]);
var inst_31400 = fluree.db.util.async.throw_err(inst_31399);
var state_31415__$1 = state_31415;
var statearr_31425_31442 = state_31415__$1;
(statearr_31425_31442[(2)] = inst_31400);

(statearr_31425_31442[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (5))){
var _ = (function (){var statearr_31426 = state_31415;
(statearr_31426[(4)] = cljs.core.rest((state_31415[(4)])));

return statearr_31426;
})();
var state_31415__$1 = state_31415;
var ex31420 = (state_31415__$1[(2)]);
var statearr_31427_31443 = state_31415__$1;
(statearr_31427_31443[(5)] = ex31420);


var statearr_31428_31444 = state_31415__$1;
(statearr_31428_31444[(1)] = (4));

(statearr_31428_31444[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_31416 === (8))){
var inst_31410 = (state_31415[(2)]);
var _ = (function (){var statearr_31429 = state_31415;
(statearr_31429[(4)] = cljs.core.rest((state_31415[(4)])));

return statearr_31429;
})();
var state_31415__$1 = state_31415;
var statearr_31430_31445 = state_31415__$1;
(statearr_31430_31445[(2)] = inst_31410);

(statearr_31430_31445[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$query$range$state_machine__16395__auto__ = null;
var fluree$db$query$range$state_machine__16395__auto____0 = (function (){
var statearr_31431 = [null,null,null,null,null,null,null,null];
(statearr_31431[(0)] = fluree$db$query$range$state_machine__16395__auto__);

(statearr_31431[(1)] = (1));

return statearr_31431;
});
var fluree$db$query$range$state_machine__16395__auto____1 = (function (state_31415){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_31415);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e31432){var ex__16398__auto__ = e31432;
var statearr_31433_31446 = state_31415;
(statearr_31433_31446[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_31415[(4)]))){
var statearr_31434_31447 = state_31415;
(statearr_31434_31447[(1)] = cljs.core.first((state_31415[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__31448 = state_31415;
state_31415 = G__31448;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$query$range$state_machine__16395__auto__ = function(state_31415){
switch(arguments.length){
case 0:
return fluree$db$query$range$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$query$range$state_machine__16395__auto____1.call(this,state_31415);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$query$range$state_machine__16395__auto____0;
fluree$db$query$range$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$query$range$state_machine__16395__auto____1;
return fluree$db$query$range$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_31435 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_31435[(6)] = c__16469__auto__);

return statearr_31435;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.query.range.collection.cljs$lang$maxFixedArity = 3);

/**
 * Returns spot index range for only the requested collection.
 */
fluree.db.query.range._block_or_tx_collection = (function fluree$db$query$range$_block_or_tx_collection(db,opts){
return fluree.db.query.range.index_range.cljs$core$IFn$_invoke$arity$7(db,cljs.core.cst$kw$spot,cljs.core._GT_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(0)], null),cljs.core._LT__EQ_,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [fluree.db.util.core.min_long], null),opts);
});
/**
 * Returns vector of transactions from a set of flakes.
 * Each transaction is a map with the following keys:
 * 1. db - the associated ledger
 * 2. tx - a map containing all transaction data in the original cmd
 * 3. nonce - the nonce
 * 4. auth - the authority that submitted the transaction
 * 5. expire - expiration
 */
fluree.db.query.range.txn_from_flakes = (function fluree$db$query$range$txn_from_flakes(flakes){
var G__31452 = flakes;
var vec__31453 = G__31452;
var seq__31454 = cljs.core.seq(vec__31453);
var first__31455 = cljs.core.first(seq__31454);
var seq__31454__$1 = cljs.core.next(seq__31454);
var flake_SINGLEQUOTE_ = first__31455;
var r = seq__31454__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31452__$1 = G__31452;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31461 = G__31452__$1;
var seq__31462 = cljs.core.seq(vec__31461);
var first__31463 = cljs.core.first(seq__31462);
var seq__31462__$1 = cljs.core.next(seq__31462);
var flake_SINGLEQUOTE___$1 = first__31463;
var r__$1 = seq__31462__$1;
var result_STAR___$2 = result_STAR___$1;
if((flake_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var obj = flake_SINGLEQUOTE___$1.o;
var cmd_map = (function (){try{return fluree.db.util.json.parse(obj);
}catch (e31465){var e = e31465;
return null;
}})();
var map__31464 = cmd_map;
var map__31464__$1 = cljs.core.__destructure_map(map__31464);
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$type);
var db = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$db);
var tx = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$tx);
var nonce = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$nonce);
var auth = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$auth);
var expire = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31464__$1,cljs.core.cst$kw$expire);
var G__31466 = r__$1;
var G__31467 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(type,"tx"))?cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$db,db,cljs.core.cst$kw$tx,tx,cljs.core.cst$kw$nonce,nonce,cljs.core.cst$kw$auth,auth,cljs.core.cst$kw$expire,expire], null)):result_STAR___$2);
G__31452__$1 = G__31466;
result_STAR___$1 = G__31467;
continue;
}
break;
}
});
/**
 * Returns block data as a map, with the following keys:
 *   1. block - block number
 *   2. t - fluree "time" since ledger creation
 *   3. sigs - List of transactor signatures that signed this block
 *   4. instant - instant this block was created, per the transactor.
 *   5. hash - hash of current block
 *   6. prev-hash - hash of previous block, if relevant
 *   7. flakes - list of flakes comprising block
 *   8. txn - list of transactions in block
 *   
 */
fluree.db.query.range.block_with_tx_data = (function fluree$db$query$range$block_with_tx_data(blocks){
var G__31476 = blocks;
var vec__31477 = G__31476;
var seq__31478 = cljs.core.seq(vec__31477);
var first__31479 = cljs.core.first(seq__31478);
var seq__31478__$1 = cljs.core.next(seq__31478);
var block_SINGLEQUOTE_ = first__31479;
var r = seq__31478__$1;
var result_STAR_ = cljs.core.PersistentVector.EMPTY;
var G__31476__$1 = G__31476;
var result_STAR___$1 = result_STAR_;
while(true){
var vec__31484 = G__31476__$1;
var seq__31485 = cljs.core.seq(vec__31484);
var first__31486 = cljs.core.first(seq__31485);
var seq__31485__$1 = cljs.core.next(seq__31485);
var block_SINGLEQUOTE___$1 = first__31486;
var r__$1 = seq__31485__$1;
var result_STAR___$2 = result_STAR___$1;
if((block_SINGLEQUOTE___$1 == null)){
return result_STAR___$2;
} else {
var map__31487 = block_SINGLEQUOTE___$1;
var map__31487__$1 = cljs.core.__destructure_map(map__31487);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31487__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31487__$1,cljs.core.cst$kw$t);
var flakes = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__31487__$1,cljs.core.cst$kw$flakes);
var prev_hash = cljs.core.some(((function (G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31468_SHARP_){
var f = p1__31468_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(2))){
return f.o;
} else {
return null;
}
});})(G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var hash = cljs.core.some(((function (G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31469_SHARP_){
var f = p1__31469_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(1))){
return f.o;
} else {
return null;
}
});})(G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var instant = cljs.core.some(((function (G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31470_SHARP_){
var f = p1__31470_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(5))){
return f.o;
} else {
return null;
}
});})(G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var sigs = cljs.core.some(((function (G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,instant,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31471_SHARP_){
var f = p1__31471_SHARP_;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f.p,(7))){
return f.o;
} else {
return null;
}
});})(G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,instant,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes = cljs.core.filter.cljs$core$IFn$_invoke$arity$2(((function (G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_){
return (function (p1__31472_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(p1__31472_SHARP_.p,(106));
});})(G__31476__$1,result_STAR___$1,map__31487,map__31487__$1,block,t,flakes,prev_hash,hash,instant,sigs,vec__31484,seq__31485,first__31486,seq__31485__$1,block_SINGLEQUOTE___$1,r__$1,result_STAR___$2,G__31476,vec__31477,seq__31478,first__31479,seq__31478__$1,block_SINGLEQUOTE_,r,result_STAR_))
,flakes);
var txn_flakes_SINGLEQUOTE_ = fluree.db.query.range.txn_from_flakes(txn_flakes);
var G__31488 = r__$1;
var G__31489 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(result_STAR___$2,new cljs.core.PersistentArrayMap(null, 8, [cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$hash,hash,cljs.core.cst$kw$prev_DASH_hash,prev_hash,cljs.core.cst$kw$instant,instant,cljs.core.cst$kw$sigs,sigs,cljs.core.cst$kw$flakes,flakes,cljs.core.cst$kw$txn,txn_flakes_SINGLEQUOTE_], null));
G__31476__$1 = G__31488;
result_STAR___$1 = G__31489;
continue;
}
break;
}
});
