// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('fluree.db.storage.core');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('fluree.db.serde.protocol');
goog.require('fluree.db.flake');
goog.require('clojure.data.avl');
goog.require('fluree.db.util.log');
goog.require('fluree.db.index');
goog.require('fluree.db.dbproto');
goog.require('cljs.core.async');
goog.require('fluree.db.util.core');
goog.require('fluree.db.query.schema');
/**
 * Returns truthy if the provided key exists in storage.
 */
fluree.db.storage.core.storage_exists_QMARK_ = (function fluree$db$storage$core$storage_exists_QMARK_(conn,key){
var storage_exists_fn = cljs.core.cst$kw$storage_DASH_exists.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_exists_fn.cljs$core$IFn$_invoke$arity$1 ? storage_exists_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_exists_fn.call(null,key));
});
/**
 * Reads raw bytes from storage based on provided key.
 *   Returns core async channel with eventual response
 */
fluree.db.storage.core.storage_read = (function fluree$db$storage$core$storage_read(conn,key){
var storage_read_fn = cljs.core.cst$kw$storage_DASH_read.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_read_fn.cljs$core$IFn$_invoke$arity$1 ? storage_read_fn.cljs$core$IFn$_invoke$arity$1(key) : storage_read_fn.call(null,key));
});
/**
 * Writes raw bytes to storage based with provided key.
 */
fluree.db.storage.core.storage_write = (function fluree$db$storage$core$storage_write(conn,key,val){
var storage_write_fn = cljs.core.cst$kw$storage_DASH_write.cljs$core$IFn$_invoke$arity$1(conn);
return (storage_write_fn.cljs$core$IFn$_invoke$arity$2 ? storage_write_fn.cljs$core$IFn$_invoke$arity$2(key,val) : storage_write_fn.call(null,key,val));
});
/**
 * Returns serializer from connection.
 */
fluree.db.storage.core.serde = (function fluree$db$storage$core$serde(conn){
return cljs.core.cst$kw$serializer.cljs$core$IFn$_invoke$arity$1(conn);
});
fluree.db.storage.core.ledger_root_key = (function fluree$db$storage$core$ledger_root_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_root_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_garbage_key = (function fluree$db$storage$core$ledger_garbage_key(network,ledger_key,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_key),"_garbage_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(block)].join('');
});
fluree.db.storage.core.ledger_node_key = (function fluree$db$storage$core$ledger_node_key(network,ledger_id,idx_type,base_id,node_type){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_",cljs.core.name(idx_type),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(base_id),"-",cljs.core.str.cljs$core$IFn$_invoke$arity$1(node_type)].join('');
});
fluree.db.storage.core.ledger_block_key = (function fluree$db$storage$core$ledger_block_key(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"_",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"_block_",fluree.db.util.core.zero_pad(block,(15))].join('');
});
fluree.db.storage.core.ledger_block_file_path = (function fluree$db$storage$core$ledger_block_file_path(network,ledger_id,block){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ledger_id),"/block/",fluree.db.util.core.zero_pad(block,(15))].join('');
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block = (function fluree$db$storage$core$read_block(conn,network,ledger_id,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32942){
var state_val_32943 = (state_32942[(1)]);
if((state_val_32943 === (7))){
var inst_32931 = (state_32942[(7)]);
var inst_32933 = fluree.db.storage.core.serde(conn);
var inst_32934 = fluree.db.serde.protocol._deserialize_block(inst_32933,inst_32931);
var state_32942__$1 = state_32942;
var statearr_32944_32963 = state_32942__$1;
(statearr_32944_32963[(2)] = inst_32934);

(statearr_32944_32963[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (1))){
var state_32942__$1 = state_32942;
var statearr_32945_32964 = state_32942__$1;
(statearr_32945_32964[(2)] = null);

(statearr_32945_32964[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (4))){
var inst_32921 = (state_32942[(2)]);
var state_32942__$1 = state_32942;
var statearr_32946_32965 = state_32942__$1;
(statearr_32946_32965[(2)] = inst_32921);

(statearr_32946_32965[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (6))){
var inst_32931 = (state_32942[(7)]);
var inst_32930 = (state_32942[(2)]);
var inst_32931__$1 = fluree.db.util.async.throw_err(inst_32930);
var state_32942__$1 = (function (){var statearr_32947 = state_32942;
(statearr_32947[(7)] = inst_32931__$1);

return statearr_32947;
})();
if(cljs.core.truth_(inst_32931__$1)){
var statearr_32948_32966 = state_32942__$1;
(statearr_32948_32966[(1)] = (7));

} else {
var statearr_32949_32967 = state_32942__$1;
(statearr_32949_32967[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (3))){
var inst_32940 = (state_32942[(2)]);
var state_32942__$1 = state_32942;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32942__$1,inst_32940);
} else {
if((state_val_32943 === (2))){
var _ = (function (){var statearr_32951 = state_32942;
(statearr_32951[(4)] = cljs.core.cons((5),(state_32942[(4)])));

return statearr_32951;
})();
var inst_32927 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32928 = fluree.db.storage.core.storage_read(conn,inst_32927);
var state_32942__$1 = state_32942;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32942__$1,(6),inst_32928);
} else {
if((state_val_32943 === (9))){
var inst_32937 = (state_32942[(2)]);
var _ = (function (){var statearr_32952 = state_32942;
(statearr_32952[(4)] = cljs.core.rest((state_32942[(4)])));

return statearr_32952;
})();
var state_32942__$1 = state_32942;
var statearr_32953_32968 = state_32942__$1;
(statearr_32953_32968[(2)] = inst_32937);

(statearr_32953_32968[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (5))){
var _ = (function (){var statearr_32954 = state_32942;
(statearr_32954[(4)] = cljs.core.rest((state_32942[(4)])));

return statearr_32954;
})();
var state_32942__$1 = state_32942;
var ex32950 = (state_32942__$1[(2)]);
var statearr_32955_32969 = state_32942__$1;
(statearr_32955_32969[(5)] = ex32950);


if((ex32950 instanceof Error)){
var statearr_32956_32970 = state_32942__$1;
(statearr_32956_32970[(1)] = (4));

(statearr_32956_32970[(5)] = null);

} else {
throw ex32950;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32943 === (8))){
var state_32942__$1 = state_32942;
var statearr_32957_32971 = state_32942__$1;
(statearr_32957_32971[(2)] = null);

(statearr_32957_32971[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_block_$_state_machine__16395__auto____0 = (function (){
var statearr_32958 = [null,null,null,null,null,null,null,null];
(statearr_32958[(0)] = fluree$db$storage$core$read_block_$_state_machine__16395__auto__);

(statearr_32958[(1)] = (1));

return statearr_32958;
});
var fluree$db$storage$core$read_block_$_state_machine__16395__auto____1 = (function (state_32942){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32942);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e32959){var ex__16398__auto__ = e32959;
var statearr_32960_32972 = state_32942;
(statearr_32960_32972[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32942[(4)]))){
var statearr_32961_32973 = state_32942;
(statearr_32961_32973[(1)] = cljs.core.first((state_32942[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__32974 = state_32942;
state_32942 = G__32974;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_$_state_machine__16395__auto__ = function(state_32942){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_$_state_machine__16395__auto____1.call(this,state_32942);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_32962 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_32962[(6)] = c__16469__auto__);

return statearr_32962;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a core async channel with the requested block.
 */
fluree.db.storage.core.read_block_version = (function fluree$db$storage$core$read_block_version(conn,network,ledger_id,block,version){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_32997){
var state_val_32998 = (state_32997[(1)]);
if((state_val_32998 === (7))){
var inst_32986 = (state_32997[(7)]);
var inst_32988 = fluree.db.storage.core.serde(conn);
var inst_32989 = fluree.db.serde.protocol._deserialize_block(inst_32988,inst_32986);
var state_32997__$1 = state_32997;
var statearr_32999_33018 = state_32997__$1;
(statearr_32999_33018[(2)] = inst_32989);

(statearr_32999_33018[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (1))){
var state_32997__$1 = state_32997;
var statearr_33000_33019 = state_32997__$1;
(statearr_33000_33019[(2)] = null);

(statearr_33000_33019[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (4))){
var inst_32975 = (state_32997[(2)]);
var state_32997__$1 = state_32997;
var statearr_33001_33020 = state_32997__$1;
(statearr_33001_33020[(2)] = inst_32975);

(statearr_33001_33020[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (6))){
var inst_32986 = (state_32997[(7)]);
var inst_32985 = (state_32997[(2)]);
var inst_32986__$1 = fluree.db.util.async.throw_err(inst_32985);
var state_32997__$1 = (function (){var statearr_33002 = state_32997;
(statearr_33002[(7)] = inst_32986__$1);

return statearr_33002;
})();
if(cljs.core.truth_(inst_32986__$1)){
var statearr_33003_33021 = state_32997__$1;
(statearr_33003_33021[(1)] = (7));

} else {
var statearr_33004_33022 = state_32997__$1;
(statearr_33004_33022[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (3))){
var inst_32995 = (state_32997[(2)]);
var state_32997__$1 = state_32997;
return cljs.core.async.impl.ioc_helpers.return_chan(state_32997__$1,inst_32995);
} else {
if((state_val_32998 === (2))){
var _ = (function (){var statearr_33006 = state_32997;
(statearr_33006[(4)] = cljs.core.cons((5),(state_32997[(4)])));

return statearr_33006;
})();
var inst_32981 = fluree.db.storage.core.ledger_block_key(network,ledger_id,block);
var inst_32982 = [inst_32981,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_32983 = fluree.db.storage.core.storage_read(conn,inst_32982);
var state_32997__$1 = state_32997;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_32997__$1,(6),inst_32983);
} else {
if((state_val_32998 === (9))){
var inst_32992 = (state_32997[(2)]);
var _ = (function (){var statearr_33007 = state_32997;
(statearr_33007[(4)] = cljs.core.rest((state_32997[(4)])));

return statearr_33007;
})();
var state_32997__$1 = state_32997;
var statearr_33008_33023 = state_32997__$1;
(statearr_33008_33023[(2)] = inst_32992);

(statearr_33008_33023[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (5))){
var _ = (function (){var statearr_33009 = state_32997;
(statearr_33009[(4)] = cljs.core.rest((state_32997[(4)])));

return statearr_33009;
})();
var state_32997__$1 = state_32997;
var ex33005 = (state_32997__$1[(2)]);
var statearr_33010_33024 = state_32997__$1;
(statearr_33010_33024[(5)] = ex33005);


if((ex33005 instanceof Error)){
var statearr_33011_33025 = state_32997__$1;
(statearr_33011_33025[(1)] = (4));

(statearr_33011_33025[(5)] = null);

} else {
throw ex33005;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_32998 === (8))){
var state_32997__$1 = state_32997;
var statearr_33012_33026 = state_32997__$1;
(statearr_33012_33026[(2)] = null);

(statearr_33012_33026[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0 = (function (){
var statearr_33013 = [null,null,null,null,null,null,null,null];
(statearr_33013[(0)] = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__);

(statearr_33013[(1)] = (1));

return statearr_33013;
});
var fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1 = (function (state_32997){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_32997);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33014){var ex__16398__auto__ = e33014;
var statearr_33015_33027 = state_32997;
(statearr_33015_33027[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_32997[(4)]))){
var statearr_33016_33028 = state_32997;
(statearr_33016_33028[(1)] = cljs.core.first((state_32997[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33029 = state_32997;
state_32997 = G__33029;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__ = function(state_32997){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1.call(this,state_32997);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_block_version_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_block_version_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33017 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33017[(6)] = c__16469__auto__);

return statearr_33017;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block_version = (function fluree$db$storage$core$write_block_version(conn,network,dbid,block_data,version){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33053){
var state_val_33054 = (state_33053[(1)]);
if((state_val_33054 === (1))){
var state_33053__$1 = state_33053;
var statearr_33055_33069 = state_33053__$1;
(statearr_33055_33069[(2)] = null);

(statearr_33055_33069[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33054 === (2))){
var _ = (function (){var statearr_33056 = state_33053;
(statearr_33056[(4)] = cljs.core.cons((5),(state_33053[(4)])));

return statearr_33056;
})();
var inst_33036 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33037 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33038 = (new cljs.core.PersistentVector(null,3,(5),inst_33036,inst_33037,null));
var inst_33039 = cljs.core.select_keys(block_data,inst_33038);
var inst_33040 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33039);
var inst_33041 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33040);
var inst_33042 = [inst_33041,"--v",cljs.core.str.cljs$core$IFn$_invoke$arity$1(version)].join('');
var inst_33043 = fluree.db.storage.core.serde(conn);
var inst_33044 = fluree.db.serde.protocol._serialize_block(inst_33043,inst_33039);
var inst_33045 = fluree.db.storage.core.storage_write(conn,inst_33042,inst_33044);
var state_33053__$1 = state_33053;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33053__$1,(6),inst_33045);
} else {
if((state_val_33054 === (3))){
var inst_33051 = (state_33053[(2)]);
var state_33053__$1 = state_33053;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33053__$1,inst_33051);
} else {
if((state_val_33054 === (4))){
var inst_33030 = (state_33053[(2)]);
var state_33053__$1 = state_33053;
var statearr_33058_33070 = state_33053__$1;
(statearr_33058_33070[(2)] = inst_33030);

(statearr_33058_33070[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33054 === (5))){
var _ = (function (){var statearr_33059 = state_33053;
(statearr_33059[(4)] = cljs.core.rest((state_33053[(4)])));

return statearr_33059;
})();
var state_33053__$1 = state_33053;
var ex33057 = (state_33053__$1[(2)]);
var statearr_33060_33071 = state_33053__$1;
(statearr_33060_33071[(5)] = ex33057);


if((ex33057 instanceof Error)){
var statearr_33061_33072 = state_33053__$1;
(statearr_33061_33072[(1)] = (4));

(statearr_33061_33072[(5)] = null);

} else {
throw ex33057;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33054 === (6))){
var inst_33047 = (state_33053[(2)]);
var inst_33048 = fluree.db.util.async.throw_err(inst_33047);
var _ = (function (){var statearr_33062 = state_33053;
(statearr_33062[(4)] = cljs.core.rest((state_33053[(4)])));

return statearr_33062;
})();
var state_33053__$1 = state_33053;
var statearr_33063_33073 = state_33053__$1;
(statearr_33063_33073[(2)] = inst_33048);

(statearr_33063_33073[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0 = (function (){
var statearr_33064 = [null,null,null,null,null,null,null];
(statearr_33064[(0)] = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__);

(statearr_33064[(1)] = (1));

return statearr_33064;
});
var fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1 = (function (state_33053){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33053);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33065){var ex__16398__auto__ = e33065;
var statearr_33066_33074 = state_33053;
(statearr_33066_33074[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33053[(4)]))){
var statearr_33067_33075 = state_33053;
(statearr_33067_33075[(1)] = cljs.core.first((state_33053[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33076 = state_33053;
state_33053 = G__33076;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__ = function(state_33053){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1.call(this,state_33053);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_version_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_block_version_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33068 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33068[(6)] = c__16469__auto__);

return statearr_33068;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Block data should look like:
 * 
 *   {:block  block (long)
 * :flakes flakes
 * :hash hash
 * :sigs sigs
 * :txns   {tid (tx-id, string)  {:cmd    command (JSON string)
 *                                :sig    signature (string}]}
 *   
 */
fluree.db.storage.core.write_block = (function fluree$db$storage$core$write_block(conn,network,dbid,block_data){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33099){
var state_val_33100 = (state_33099[(1)]);
if((state_val_33100 === (1))){
var state_33099__$1 = state_33099;
var statearr_33101_33115 = state_33099__$1;
(statearr_33101_33115[(2)] = null);

(statearr_33101_33115[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33100 === (2))){
var _ = (function (){var statearr_33102 = state_33099;
(statearr_33102[(4)] = cljs.core.cons((5),(state_33099[(4)])));

return statearr_33102;
})();
var inst_33083 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33084 = [cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$flakes];
var inst_33085 = (new cljs.core.PersistentVector(null,3,(5),inst_33083,inst_33084,null));
var inst_33086 = cljs.core.select_keys(block_data,inst_33085);
var inst_33087 = cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(inst_33086);
var inst_33088 = fluree.db.storage.core.ledger_block_key(network,dbid,inst_33087);
var inst_33089 = fluree.db.storage.core.serde(conn);
var inst_33090 = fluree.db.serde.protocol._serialize_block(inst_33089,inst_33086);
var inst_33091 = fluree.db.storage.core.storage_write(conn,inst_33088,inst_33090);
var state_33099__$1 = state_33099;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33099__$1,(6),inst_33091);
} else {
if((state_val_33100 === (3))){
var inst_33097 = (state_33099[(2)]);
var state_33099__$1 = state_33099;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33099__$1,inst_33097);
} else {
if((state_val_33100 === (4))){
var inst_33077 = (state_33099[(2)]);
var state_33099__$1 = state_33099;
var statearr_33104_33116 = state_33099__$1;
(statearr_33104_33116[(2)] = inst_33077);

(statearr_33104_33116[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33100 === (5))){
var _ = (function (){var statearr_33105 = state_33099;
(statearr_33105[(4)] = cljs.core.rest((state_33099[(4)])));

return statearr_33105;
})();
var state_33099__$1 = state_33099;
var ex33103 = (state_33099__$1[(2)]);
var statearr_33106_33117 = state_33099__$1;
(statearr_33106_33117[(5)] = ex33103);


if((ex33103 instanceof Error)){
var statearr_33107_33118 = state_33099__$1;
(statearr_33107_33118[(1)] = (4));

(statearr_33107_33118[(5)] = null);

} else {
throw ex33103;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33100 === (6))){
var inst_33093 = (state_33099[(2)]);
var inst_33094 = fluree.db.util.async.throw_err(inst_33093);
var _ = (function (){var statearr_33108 = state_33099;
(statearr_33108[(4)] = cljs.core.rest((state_33099[(4)])));

return statearr_33108;
})();
var state_33099__$1 = state_33099;
var statearr_33109_33119 = state_33099__$1;
(statearr_33109_33119[(2)] = inst_33094);

(statearr_33109_33119[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_block_$_state_machine__16395__auto____0 = (function (){
var statearr_33110 = [null,null,null,null,null,null,null];
(statearr_33110[(0)] = fluree$db$storage$core$write_block_$_state_machine__16395__auto__);

(statearr_33110[(1)] = (1));

return statearr_33110;
});
var fluree$db$storage$core$write_block_$_state_machine__16395__auto____1 = (function (state_33099){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33099);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33111){var ex__16398__auto__ = e33111;
var statearr_33112_33120 = state_33099;
(statearr_33112_33120[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33099[(4)]))){
var statearr_33113_33121 = state_33099;
(statearr_33113_33121[(1)] = cljs.core.first((state_33099[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33122 = state_33099;
state_33099 = G__33122;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_block_$_state_machine__16395__auto__ = function(state_33099){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_block_$_state_machine__16395__auto____1.call(this,state_33099);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_block_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33114 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33114[(6)] = c__16469__auto__);

return statearr_33114;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Given a child, unresolved node, extracts just the data that will go into storage.
 */
fluree.db.storage.core.child_data = (function fluree$db$storage$core$child_data(child){
return cljs.core.select_keys(child,new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size], null));
});
fluree.db.storage.core.write_history = (function fluree$db$storage$core$write_history(conn,history,his_key,next_his_key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33142){
var state_val_33143 = (state_33142[(1)]);
if((state_val_33143 === (1))){
var state_33142__$1 = state_33142;
var statearr_33144_33158 = state_33142__$1;
(statearr_33144_33158[(2)] = null);

(statearr_33144_33158[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33143 === (2))){
var _ = (function (){var statearr_33145 = state_33142;
(statearr_33145[(4)] = cljs.core.cons((5),(state_33142[(4)])));

return statearr_33145;
})();
var inst_33129 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33130 = [history,next_his_key];
var inst_33131 = cljs.core.PersistentHashMap.fromArrays(inst_33129,inst_33130);
var inst_33132 = fluree.db.storage.core.serde(conn);
var inst_33133 = fluree.db.serde.protocol._serialize_leaf(inst_33132,inst_33131);
var inst_33134 = fluree.db.storage.core.storage_write(conn,his_key,inst_33133);
var state_33142__$1 = state_33142;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33142__$1,(6),inst_33134);
} else {
if((state_val_33143 === (3))){
var inst_33140 = (state_33142[(2)]);
var state_33142__$1 = state_33142;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33142__$1,inst_33140);
} else {
if((state_val_33143 === (4))){
var inst_33123 = (state_33142[(2)]);
var state_33142__$1 = state_33142;
var statearr_33147_33159 = state_33142__$1;
(statearr_33147_33159[(2)] = inst_33123);

(statearr_33147_33159[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33143 === (5))){
var _ = (function (){var statearr_33148 = state_33142;
(statearr_33148[(4)] = cljs.core.rest((state_33142[(4)])));

return statearr_33148;
})();
var state_33142__$1 = state_33142;
var ex33146 = (state_33142__$1[(2)]);
var statearr_33149_33160 = state_33142__$1;
(statearr_33149_33160[(5)] = ex33146);


if((ex33146 instanceof Error)){
var statearr_33150_33161 = state_33142__$1;
(statearr_33150_33161[(1)] = (4));

(statearr_33150_33161[(5)] = null);

} else {
throw ex33146;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33143 === (6))){
var inst_33136 = (state_33142[(2)]);
var inst_33137 = fluree.db.util.async.throw_err(inst_33136);
var _ = (function (){var statearr_33151 = state_33142;
(statearr_33151[(4)] = cljs.core.rest((state_33142[(4)])));

return statearr_33151;
})();
var state_33142__$1 = state_33142;
var statearr_33152_33162 = state_33142__$1;
(statearr_33152_33162[(2)] = inst_33137);

(statearr_33152_33162[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_history_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_history_$_state_machine__16395__auto____0 = (function (){
var statearr_33153 = [null,null,null,null,null,null,null];
(statearr_33153[(0)] = fluree$db$storage$core$write_history_$_state_machine__16395__auto__);

(statearr_33153[(1)] = (1));

return statearr_33153;
});
var fluree$db$storage$core$write_history_$_state_machine__16395__auto____1 = (function (state_33142){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33142);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33154){var ex__16398__auto__ = e33154;
var statearr_33155_33163 = state_33142;
(statearr_33155_33163[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33142[(4)]))){
var statearr_33156_33164 = state_33142;
(statearr_33156_33164[(1)] = cljs.core.first((state_33142[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33165 = state_33142;
state_33142 = G__33165;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_history_$_state_machine__16395__auto__ = function(state_33142){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_history_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_history_$_state_machine__16395__auto____1.call(this,state_33142);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_history_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_history_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_history_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33157 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33157[(6)] = c__16469__auto__);

return statearr_33157;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Writes a leaf plus its history.
 * 
 *   Writes history first, and only on successful history write then writes leaf.
 * 
 *   Returns leaf's key
 */
fluree.db.storage.core.write_leaf = (function fluree$db$storage$core$write_leaf(conn,network,dbid,idx_type,id,flakes,history){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33191){
var state_val_33192 = (state_33191[(1)]);
if((state_val_33192 === (1))){
var state_33191__$1 = state_33191;
var statearr_33193_33210 = state_33191__$1;
(statearr_33193_33210[(2)] = null);

(statearr_33193_33210[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33192 === (2))){
var inst_33172 = (state_33191[(7)]);
var _ = (function (){var statearr_33194 = state_33191;
(statearr_33194[(4)] = cljs.core.cons((5),(state_33191[(4)])));

return statearr_33194;
})();
var inst_33172__$1 = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"l");
var inst_33173 = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33172__$1),"-his"].join('');
var inst_33174 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$his];
var inst_33175 = [flakes,inst_33173];
var inst_33176 = cljs.core.PersistentHashMap.fromArrays(inst_33174,inst_33175);
var inst_33177 = fluree.db.storage.core.serde(conn);
var inst_33178 = fluree.db.serde.protocol._serialize_leaf(inst_33177,inst_33176);
var inst_33179 = fluree.db.storage.core.write_history(conn,history,inst_33173,null);
var inst_33180 = fluree.db.storage.core.storage_write(conn,inst_33172__$1,inst_33178);
var state_33191__$1 = (function (){var statearr_33195 = state_33191;
(statearr_33195[(7)] = inst_33172__$1);

(statearr_33195[(8)] = inst_33180);

return statearr_33195;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33191__$1,(6),inst_33179);
} else {
if((state_val_33192 === (3))){
var inst_33189 = (state_33191[(2)]);
var state_33191__$1 = state_33191;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33191__$1,inst_33189);
} else {
if((state_val_33192 === (4))){
var inst_33166 = (state_33191[(2)]);
var state_33191__$1 = state_33191;
var statearr_33197_33211 = state_33191__$1;
(statearr_33197_33211[(2)] = inst_33166);

(statearr_33197_33211[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33192 === (5))){
var _ = (function (){var statearr_33198 = state_33191;
(statearr_33198[(4)] = cljs.core.rest((state_33191[(4)])));

return statearr_33198;
})();
var state_33191__$1 = state_33191;
var ex33196 = (state_33191__$1[(2)]);
var statearr_33199_33212 = state_33191__$1;
(statearr_33199_33212[(5)] = ex33196);


if((ex33196 instanceof Error)){
var statearr_33200_33213 = state_33191__$1;
(statearr_33200_33213[(1)] = (4));

(statearr_33200_33213[(5)] = null);

} else {
throw ex33196;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33192 === (6))){
var inst_33180 = (state_33191[(8)]);
var inst_33182 = (state_33191[(2)]);
var inst_33183 = fluree.db.util.async.throw_err(inst_33182);
var state_33191__$1 = (function (){var statearr_33201 = state_33191;
(statearr_33201[(9)] = inst_33183);

return statearr_33201;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33191__$1,(7),inst_33180);
} else {
if((state_val_33192 === (7))){
var inst_33172 = (state_33191[(7)]);
var inst_33185 = (state_33191[(2)]);
var inst_33186 = fluree.db.util.async.throw_err(inst_33185);
var _ = (function (){var statearr_33202 = state_33191;
(statearr_33202[(4)] = cljs.core.rest((state_33191[(4)])));

return statearr_33202;
})();
var state_33191__$1 = (function (){var statearr_33203 = state_33191;
(statearr_33203[(10)] = inst_33186);

return statearr_33203;
})();
var statearr_33204_33214 = state_33191__$1;
(statearr_33204_33214[(2)] = inst_33172);

(statearr_33204_33214[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_33205 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33205[(0)] = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__);

(statearr_33205[(1)] = (1));

return statearr_33205;
});
var fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1 = (function (state_33191){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33191);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33206){var ex__16398__auto__ = e33206;
var statearr_33207_33215 = state_33191;
(statearr_33207_33215[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33191[(4)]))){
var statearr_33208_33216 = state_33191;
(statearr_33208_33216[(1)] = cljs.core.first((state_33191[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33217 = state_33191;
state_33191 = G__33217;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__ = function(state_33191){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1.call(this,state_33191);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33209 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33209[(6)] = c__16469__auto__);

return statearr_33209;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Serializes final data for branch and writes it to provided key
 */
fluree.db.storage.core.write_branch_data = (function fluree$db$storage$core$write_branch_data(conn,key,data){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33234){
var state_val_33235 = (state_33234[(1)]);
if((state_val_33235 === (1))){
var state_33234__$1 = state_33234;
var statearr_33236_33251 = state_33234__$1;
(statearr_33236_33251[(2)] = null);

(statearr_33236_33251[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33235 === (2))){
var _ = (function (){var statearr_33237 = state_33234;
(statearr_33237[(4)] = cljs.core.cons((5),(state_33234[(4)])));

return statearr_33237;
})();
var inst_33224 = fluree.db.storage.core.serde(conn);
var inst_33225 = fluree.db.serde.protocol._serialize_branch(inst_33224,data);
var inst_33226 = fluree.db.storage.core.storage_write(conn,key,inst_33225);
var state_33234__$1 = state_33234;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33234__$1,(6),inst_33226);
} else {
if((state_val_33235 === (3))){
var inst_33232 = (state_33234[(2)]);
var state_33234__$1 = state_33234;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33234__$1,inst_33232);
} else {
if((state_val_33235 === (4))){
var inst_33218 = (state_33234[(2)]);
var state_33234__$1 = state_33234;
var statearr_33239_33252 = state_33234__$1;
(statearr_33239_33252[(2)] = inst_33218);

(statearr_33239_33252[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33235 === (5))){
var _ = (function (){var statearr_33240 = state_33234;
(statearr_33240[(4)] = cljs.core.rest((state_33234[(4)])));

return statearr_33240;
})();
var state_33234__$1 = state_33234;
var ex33238 = (state_33234__$1[(2)]);
var statearr_33241_33253 = state_33234__$1;
(statearr_33241_33253[(5)] = ex33238);


if((ex33238 instanceof Error)){
var statearr_33242_33254 = state_33234__$1;
(statearr_33242_33254[(1)] = (4));

(statearr_33242_33254[(5)] = null);

} else {
throw ex33238;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33235 === (6))){
var inst_33228 = (state_33234[(2)]);
var inst_33229 = fluree.db.util.async.throw_err(inst_33228);
var _ = (function (){var statearr_33243 = state_33234;
(statearr_33243[(4)] = cljs.core.rest((state_33234[(4)])));

return statearr_33243;
})();
var state_33234__$1 = (function (){var statearr_33244 = state_33234;
(statearr_33244[(7)] = inst_33229);

return statearr_33244;
})();
var statearr_33245_33255 = state_33234__$1;
(statearr_33245_33255[(2)] = key);

(statearr_33245_33255[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0 = (function (){
var statearr_33246 = [null,null,null,null,null,null,null,null];
(statearr_33246[(0)] = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__);

(statearr_33246[(1)] = (1));

return statearr_33246;
});
var fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1 = (function (state_33234){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33234);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33247){var ex__16398__auto__ = e33247;
var statearr_33248_33256 = state_33234;
(statearr_33248_33256[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33234[(4)]))){
var statearr_33249_33257 = state_33234;
(statearr_33249_33257[(1)] = cljs.core.first((state_33234[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33258 = state_33234;
state_33234 = G__33258;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__ = function(state_33234){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1.call(this,state_33234);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_branch_data_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33250 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33250[(6)] = c__16469__auto__);

return statearr_33250;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns core async channel with index key
 */
fluree.db.storage.core.write_branch = (function fluree$db$storage$core$write_branch(conn,network,dbid,idx_type,id,children){
var branch_key = fluree.db.storage.core.ledger_node_key(network,dbid,idx_type,id,"b");
var child_vals = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (p1__33259_SHARP_){
return fluree.db.storage.core.child_data(cljs.core.val(p1__33259_SHARP_));
}),children);
var rhs = cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(cljs.core.last(child_vals));
var data = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$children,child_vals,cljs.core.cst$kw$rhs,rhs], null);
return fluree.db.storage.core.write_branch_data(conn,branch_key,data);
});
/**
 * Writes garbage record out for latest index.
 */
fluree.db.storage.core.write_garbage = (function fluree$db$storage$core$write_garbage(db,p__33260){
var map__33261 = p__33260;
var map__33261__$1 = cljs.core.__destructure_map(map__33261);
var progress = map__33261__$1;
var garbage = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33261__$1,cljs.core.cst$kw$garbage);
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33289){
var state_val_33290 = (state_33289[(1)]);
if((state_val_33290 === (1))){
var state_33289__$1 = state_33289;
var statearr_33291_33307 = state_33289__$1;
(statearr_33291_33307[(2)] = null);

(statearr_33291_33307[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33290 === (2))){
var inst_33275 = (state_33289[(7)]);
var _ = (function (){var statearr_33292 = state_33289;
(statearr_33292[(4)] = cljs.core.cons((5),(state_33289[(4)])));

return statearr_33292;
})();
var inst_33269 = db;
var inst_33270 = cljs.core.__destructure_map(inst_33269);
var inst_33271 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33270,cljs.core.cst$kw$conn);
var inst_33272 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33270,cljs.core.cst$kw$network);
var inst_33273 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33270,cljs.core.cst$kw$dbid);
var inst_33274 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33270,cljs.core.cst$kw$block);
var inst_33275__$1 = fluree.db.storage.core.ledger_garbage_key(inst_33272,inst_33273,inst_33274);
var inst_33276 = [cljs.core.cst$kw$dbid,cljs.core.cst$kw$block,cljs.core.cst$kw$garbage];
var inst_33277 = [inst_33273,inst_33274,garbage];
var inst_33278 = cljs.core.PersistentHashMap.fromArrays(inst_33276,inst_33277);
var inst_33279 = fluree.db.storage.core.serde(inst_33271);
var inst_33280 = fluree.db.serde.protocol._serialize_garbage(inst_33279,inst_33278);
var inst_33281 = fluree.db.storage.core.storage_write(inst_33271,inst_33275__$1,inst_33280);
var state_33289__$1 = (function (){var statearr_33293 = state_33289;
(statearr_33293[(7)] = inst_33275__$1);

return statearr_33293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33289__$1,(6),inst_33281);
} else {
if((state_val_33290 === (3))){
var inst_33287 = (state_33289[(2)]);
var state_33289__$1 = state_33289;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33289__$1,inst_33287);
} else {
if((state_val_33290 === (4))){
var inst_33262 = (state_33289[(2)]);
var state_33289__$1 = state_33289;
var statearr_33295_33308 = state_33289__$1;
(statearr_33295_33308[(2)] = inst_33262);

(statearr_33295_33308[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33290 === (5))){
var _ = (function (){var statearr_33296 = state_33289;
(statearr_33296[(4)] = cljs.core.rest((state_33289[(4)])));

return statearr_33296;
})();
var state_33289__$1 = state_33289;
var ex33294 = (state_33289__$1[(2)]);
var statearr_33297_33309 = state_33289__$1;
(statearr_33297_33309[(5)] = ex33294);


if((ex33294 instanceof Error)){
var statearr_33298_33310 = state_33289__$1;
(statearr_33298_33310[(1)] = (4));

(statearr_33298_33310[(5)] = null);

} else {
throw ex33294;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33290 === (6))){
var inst_33275 = (state_33289[(7)]);
var inst_33283 = (state_33289[(2)]);
var inst_33284 = fluree.db.util.async.throw_err(inst_33283);
var _ = (function (){var statearr_33299 = state_33289;
(statearr_33299[(4)] = cljs.core.rest((state_33289[(4)])));

return statearr_33299;
})();
var state_33289__$1 = (function (){var statearr_33300 = state_33289;
(statearr_33300[(8)] = inst_33284);

return statearr_33300;
})();
var statearr_33301_33311 = state_33289__$1;
(statearr_33301_33311[(2)] = inst_33275);

(statearr_33301_33311[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0 = (function (){
var statearr_33302 = [null,null,null,null,null,null,null,null,null];
(statearr_33302[(0)] = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__);

(statearr_33302[(1)] = (1));

return statearr_33302;
});
var fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1 = (function (state_33289){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33289);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33303){var ex__16398__auto__ = e33303;
var statearr_33304_33312 = state_33289;
(statearr_33304_33312[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33289[(4)]))){
var statearr_33305_33313 = state_33289;
(statearr_33305_33313[(1)] = cljs.core.first((state_33289[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33314 = state_33289;
state_33289 = G__33314;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__ = function(state_33289){
switch(arguments.length){
case 0:
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1.call(this,state_33289);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____0;
fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$write_garbage_$_state_machine__16395__auto____1;
return fluree$db$storage$core$write_garbage_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33306 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33306[(6)] = c__16469__auto__);

return statearr_33306;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.storage.core.write_db_root = (function fluree$db$storage$core$write_db_root(var_args){
var G__33316 = arguments.length;
switch (G__33316) {
case 1:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$1 = (function (db){
return fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2(db,null);
}));

(fluree.db.storage.core.write_db_root.cljs$core$IFn$_invoke$arity$2 = (function (db,custom_ecount){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33372){
var state_val_33373 = (state_33372[(1)]);
if((state_val_33373 === (7))){
var state_33372__$1 = state_33372;
var statearr_33374_33400 = state_33372__$1;
(statearr_33374_33400[(2)] = (0));

(statearr_33374_33400[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (1))){
var state_33372__$1 = state_33372;
var statearr_33375_33401 = state_33372__$1;
(statearr_33375_33401[(2)] = null);

(statearr_33375_33401[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (4))){
var inst_33317 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
var statearr_33376_33402 = state_33372__$1;
(statearr_33376_33402[(2)] = inst_33317);

(statearr_33376_33402[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (6))){
var inst_33342 = (state_33372[(7)]);
var state_33372__$1 = state_33372;
var statearr_33377_33403 = state_33372__$1;
(statearr_33377_33403[(2)] = inst_33342);

(statearr_33377_33403[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (3))){
var inst_33370 = (state_33372[(2)]);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33372__$1,inst_33370);
} else {
if((state_val_33373 === (12))){
var inst_33339 = (state_33372[(8)]);
var inst_33366 = (state_33372[(2)]);
var inst_33367 = fluree.db.util.async.throw_err(inst_33366);
var _ = (function (){var statearr_33378 = state_33372;
(statearr_33378[(4)] = cljs.core.rest((state_33372[(4)])));

return statearr_33378;
})();
var state_33372__$1 = (function (){var statearr_33379 = state_33372;
(statearr_33379[(9)] = inst_33367);

return statearr_33379;
})();
var statearr_33380_33404 = state_33372__$1;
(statearr_33380_33404[(2)] = inst_33339);

(statearr_33380_33404[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (2))){
var inst_33342 = (state_33372[(7)]);
var inst_33334 = (state_33372[(10)]);
var inst_33332 = (state_33372[(11)]);
var inst_33330 = (state_33372[(12)]);
var _ = (function (){var statearr_33381 = state_33372;
(statearr_33381[(4)] = cljs.core.cons((5),(state_33372[(4)])));

return statearr_33381;
})();
var inst_33324 = db;
var inst_33325 = cljs.core.__destructure_map(inst_33324);
var inst_33326 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$network);
var inst_33327 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$t);
var inst_33328 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$fork);
var inst_33329 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$spot);
var inst_33330__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$stats);
var inst_33331 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$conn);
var inst_33332__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$block);
var inst_33333 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$psot);
var inst_33334__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$dbid);
var inst_33335 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$ecount);
var inst_33336 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$opst);
var inst_33337 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$fork_DASH_block);
var inst_33338 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33325,cljs.core.cst$kw$post);
var inst_33339 = fluree.db.storage.core.ledger_root_key(inst_33326,inst_33334__$1,inst_33332__$1);
var inst_33340 = [cljs.core.cst$kw$block,cljs.core.cst$kw$psot,cljs.core.cst$kw$dbid,cljs.core.cst$kw$prevIndex,cljs.core.cst$kw$ecount,cljs.core.cst$kw$opst,cljs.core.cst$kw$post,cljs.core.cst$kw$t,cljs.core.cst$kw$timestamp,cljs.core.cst$kw$fork,cljs.core.cst$kw$forkBlock,cljs.core.cst$kw$stats,cljs.core.cst$kw$spot];
var inst_33341 = fluree.db.storage.core.child_data(inst_33333);
var inst_33342__$1 = cljs.core.cst$kw$indexed.cljs$core$IFn$_invoke$arity$1(inst_33330__$1);
var state_33372__$1 = (function (){var statearr_33382 = state_33372;
(statearr_33382[(13)] = inst_33328);

(statearr_33382[(14)] = inst_33337);

(statearr_33382[(7)] = inst_33342__$1);

(statearr_33382[(10)] = inst_33334__$1);

(statearr_33382[(15)] = inst_33327);

(statearr_33382[(16)] = inst_33335);

(statearr_33382[(17)] = inst_33336);

(statearr_33382[(11)] = inst_33332__$1);

(statearr_33382[(12)] = inst_33330__$1);

(statearr_33382[(18)] = inst_33341);

(statearr_33382[(19)] = inst_33338);

(statearr_33382[(20)] = inst_33340);

(statearr_33382[(21)] = inst_33331);

(statearr_33382[(8)] = inst_33339);

(statearr_33382[(22)] = inst_33329);

return statearr_33382;
})();
if(cljs.core.truth_(inst_33342__$1)){
var statearr_33383_33405 = state_33372__$1;
(statearr_33383_33405[(1)] = (6));

} else {
var statearr_33384_33406 = state_33372__$1;
(statearr_33384_33406[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (11))){
var inst_33328 = (state_33372[(13)]);
var inst_33337 = (state_33372[(14)]);
var inst_33334 = (state_33372[(10)]);
var inst_33327 = (state_33372[(15)]);
var inst_33346 = (state_33372[(23)]);
var inst_33336 = (state_33372[(17)]);
var inst_33332 = (state_33372[(11)]);
var inst_33330 = (state_33372[(12)]);
var inst_33341 = (state_33372[(18)]);
var inst_33338 = (state_33372[(19)]);
var inst_33340 = (state_33372[(20)]);
var inst_33331 = (state_33372[(21)]);
var inst_33339 = (state_33372[(8)]);
var inst_33329 = (state_33372[(22)]);
var inst_33351 = (state_33372[(2)]);
var inst_33352 = fluree.db.storage.core.child_data(inst_33336);
var inst_33353 = fluree.db.storage.core.child_data(inst_33338);
var inst_33354 = fluree.db.util.core.current_time_millis();
var inst_33355 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_33356 = [cljs.core.cst$kw$flakes,cljs.core.cst$kw$size];
var inst_33357 = (new cljs.core.PersistentVector(null,2,(5),inst_33355,inst_33356,null));
var inst_33358 = cljs.core.select_keys(inst_33330,inst_33357);
var inst_33359 = fluree.db.storage.core.child_data(inst_33329);
var inst_33360 = [inst_33332,inst_33341,inst_33334,inst_33346,inst_33351,inst_33352,inst_33353,inst_33327,inst_33354,inst_33328,inst_33337,inst_33358,inst_33359];
var inst_33361 = cljs.core.PersistentHashMap.fromArrays(inst_33340,inst_33360);
var inst_33362 = fluree.db.storage.core.serde(inst_33331);
var inst_33363 = fluree.db.serde.protocol._serialize_db_root(inst_33362,inst_33361);
var inst_33364 = fluree.db.storage.core.storage_write(inst_33331,inst_33339,inst_33363);
var state_33372__$1 = state_33372;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33372__$1,(12),inst_33364);
} else {
if((state_val_33373 === (9))){
var inst_33347 = (state_33372[(24)]);
var state_33372__$1 = state_33372;
var statearr_33386_33407 = state_33372__$1;
(statearr_33386_33407[(2)] = inst_33347);

(statearr_33386_33407[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (5))){
var _ = (function (){var statearr_33387 = state_33372;
(statearr_33387[(4)] = cljs.core.rest((state_33372[(4)])));

return statearr_33387;
})();
var state_33372__$1 = state_33372;
var ex33385 = (state_33372__$1[(2)]);
var statearr_33388_33408 = state_33372__$1;
(statearr_33388_33408[(5)] = ex33385);


if((ex33385 instanceof Error)){
var statearr_33389_33409 = state_33372__$1;
(statearr_33389_33409[(1)] = (4));

(statearr_33389_33409[(5)] = null);

} else {
throw ex33385;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (10))){
var inst_33335 = (state_33372[(16)]);
var state_33372__$1 = state_33372;
var statearr_33390_33410 = state_33372__$1;
(statearr_33390_33410[(2)] = inst_33335);

(statearr_33390_33410[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33373 === (8))){
var inst_33347 = (state_33372[(24)]);
var inst_33346 = (state_33372[(2)]);
var inst_33347__$1 = custom_ecount;
var state_33372__$1 = (function (){var statearr_33391 = state_33372;
(statearr_33391[(24)] = inst_33347__$1);

(statearr_33391[(23)] = inst_33346);

return statearr_33391;
})();
if(cljs.core.truth_(inst_33347__$1)){
var statearr_33392_33411 = state_33372__$1;
(statearr_33392_33411[(1)] = (9));

} else {
var statearr_33393_33412 = state_33372__$1;
(statearr_33393_33412[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16395__auto__ = null;
var fluree$db$storage$core$state_machine__16395__auto____0 = (function (){
var statearr_33394 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33394[(0)] = fluree$db$storage$core$state_machine__16395__auto__);

(statearr_33394[(1)] = (1));

return statearr_33394;
});
var fluree$db$storage$core$state_machine__16395__auto____1 = (function (state_33372){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33372);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33395){var ex__16398__auto__ = e33395;
var statearr_33396_33413 = state_33372;
(statearr_33396_33413[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33372[(4)]))){
var statearr_33397_33414 = state_33372;
(statearr_33397_33414[(1)] = cljs.core.first((state_33372[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33415 = state_33372;
state_33372 = G__33415;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16395__auto__ = function(state_33372){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16395__auto____1.call(this,state_33372);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16395__auto____0;
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16395__auto____1;
return fluree$db$storage$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33398 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33398[(6)] = c__16469__auto__);

return statearr_33398;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.storage.core.write_db_root.cljs$lang$maxFixedArity = 2);

fluree.db.storage.core.reify_history = (function fluree$db$storage$core$reify_history(conn,key,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33474 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33448){
var state_val_33449 = (state_33448[(1)]);
if((state_val_33449 === (7))){
var inst_33428 = (state_33448[(7)]);
var state_33448__$1 = state_33448;
var statearr_33450_33475 = state_33448__$1;
(statearr_33450_33475[(2)] = inst_33428);

(statearr_33450_33475[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (1))){
var state_33448__$1 = state_33448;
var statearr_33451_33476 = state_33448__$1;
(statearr_33451_33476[(2)] = null);

(statearr_33451_33476[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (4))){
var inst_33416 = (state_33448[(2)]);
var inst_33417 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33418 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33416);
var inst_33419 = cljs.core.async.close_BANG_(return_ch);
var state_33448__$1 = (function (){var statearr_33452 = state_33448;
(statearr_33452[(8)] = inst_33418);

(statearr_33452[(9)] = inst_33417);

return statearr_33452;
})();
var statearr_33453_33477 = state_33448__$1;
(statearr_33453_33477[(2)] = inst_33419);

(statearr_33453_33477[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (6))){
var inst_33427 = (state_33448[(10)]);
var inst_33428 = (state_33448[(7)]);
var inst_33427__$1 = (state_33448[(2)]);
var inst_33428__$1 = (inst_33427__$1 == null);
var state_33448__$1 = (function (){var statearr_33454 = state_33448;
(statearr_33454[(10)] = inst_33427__$1);

(statearr_33454[(7)] = inst_33428__$1);

return statearr_33454;
})();
if(cljs.core.truth_(inst_33428__$1)){
var statearr_33455_33478 = state_33448__$1;
(statearr_33455_33478[(1)] = (7));

} else {
var statearr_33456_33479 = state_33448__$1;
(statearr_33456_33479[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (3))){
var inst_33446 = (state_33448[(2)]);
var state_33448__$1 = state_33448;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33448__$1,inst_33446);
} else {
if((state_val_33449 === (12))){
var inst_33443 = (state_33448[(2)]);
var _ = (function (){var statearr_33457 = state_33448;
(statearr_33457[(4)] = cljs.core.rest((state_33448[(4)])));

return statearr_33457;
})();
var state_33448__$1 = state_33448;
var statearr_33458_33480 = state_33448__$1;
(statearr_33458_33480[(2)] = inst_33443);

(statearr_33458_33480[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (2))){
var _ = (function (){var statearr_33459 = state_33448;
(statearr_33459[(4)] = cljs.core.cons((5),(state_33448[(4)])));

return statearr_33459;
})();
var inst_33425 = fluree.db.storage.core.storage_read(conn,key);
var state_33448__$1 = state_33448;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33448__$1,(6),inst_33425);
} else {
if((state_val_33449 === (11))){
var inst_33427 = (state_33448[(10)]);
var inst_33437 = fluree.db.storage.core.serde(conn);
var inst_33438 = fluree.db.serde.protocol._deserialize_leaf(inst_33437,inst_33427);
var inst_33439 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33438);
var inst_33440 = cljs.core.sort.cljs$core$IFn$_invoke$arity$2(fluree.db.flake.cmp_flakes_history,inst_33439);
var inst_33441 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33440);
var state_33448__$1 = state_33448;
var statearr_33461_33481 = state_33448__$1;
(statearr_33461_33481[(2)] = inst_33441);

(statearr_33461_33481[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (9))){
var inst_33433 = (state_33448[(2)]);
var state_33448__$1 = state_33448;
if(cljs.core.truth_(inst_33433)){
var statearr_33462_33482 = state_33448__$1;
(statearr_33462_33482[(1)] = (10));

} else {
var statearr_33463_33483 = state_33448__$1;
(statearr_33463_33483[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (5))){
var _ = (function (){var statearr_33464 = state_33448;
(statearr_33464[(4)] = cljs.core.rest((state_33448[(4)])));

return statearr_33464;
})();
var state_33448__$1 = state_33448;
var ex33460 = (state_33448__$1[(2)]);
var statearr_33465_33484 = state_33448__$1;
(statearr_33465_33484[(5)] = ex33460);


var statearr_33466_33485 = state_33448__$1;
(statearr_33466_33485[(1)] = (4));

(statearr_33466_33485[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (10))){
var inst_33435 = cljs.core.async.close_BANG_(return_ch);
var state_33448__$1 = state_33448;
var statearr_33467_33486 = state_33448__$1;
(statearr_33467_33486[(2)] = inst_33435);

(statearr_33467_33486[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33449 === (8))){
var inst_33427 = (state_33448[(10)]);
var inst_33431 = (inst_33427 instanceof Error);
var state_33448__$1 = state_33448;
var statearr_33468_33487 = state_33448__$1;
(statearr_33468_33487[(2)] = inst_33431);

(statearr_33468_33487[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0 = (function (){
var statearr_33469 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33469[(0)] = fluree$db$storage$core$reify_history_$_state_machine__16395__auto__);

(statearr_33469[(1)] = (1));

return statearr_33469;
});
var fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1 = (function (state_33448){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33448);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33470){var ex__16398__auto__ = e33470;
var statearr_33471_33488 = state_33448;
(statearr_33471_33488[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33448[(4)]))){
var statearr_33472_33489 = state_33448;
(statearr_33472_33489[(1)] = cljs.core.first((state_33448[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33490 = state_33448;
state_33448 = G__33490;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__ = function(state_33448){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1.call(this,state_33448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_history_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_history_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_history_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_history_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33473 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33473[(6)] = c__16469__auto___33474);

return statearr_33473;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});
/**
 * Given a novelty set, a first-flake and rhs flake boundary,
 *   returns novelty subrange as a collection.
 * 
 *   If through-t is specified, will return novelty only through the
 *   specified t.
 */
fluree.db.storage.core.source_novelty_t = (function fluree$db$storage$core$source_novelty_t(var_args){
var G__33492 = arguments.length;
switch (G__33492) {
case 4:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$4 = (function (novelty,first_flake,rhs,leftmost_QMARK_){
return fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(novelty,first_flake,rhs,leftmost_QMARK_,null);
}));

(fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5 = (function (novelty,first_flake,rhs,leftmost_QMARK_,through_t){
var novelty_subrange = (cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return cljs.core.not(leftmost_QMARK_);
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$5(novelty,cljs.core._GT_,first_flake,cljs.core._LT__EQ_,rhs):(cljs.core.truth_((function (){var and__4210__auto__ = rhs;
if(cljs.core.truth_(and__4210__auto__)){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._LT__EQ_,rhs):(((((rhs == null)) && (cljs.core.not(leftmost_QMARK_))))?clojure.data.avl.subrange.cljs$core$IFn$_invoke$arity$3(novelty,cljs.core._GT_,first_flake):(cljs.core.truth_((function (){var and__4210__auto__ = (rhs == null);
if(and__4210__auto__){
return leftmost_QMARK_;
} else {
return and__4210__auto__;
}
})())?novelty:null))));
if(cljs.core.truth_(through_t)){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (novelty_set,f){
if((f.t < through_t)){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(novelty_set,f);
} else {
return novelty_set;
}
}),novelty_subrange,novelty_subrange);
} else {
return novelty_subrange;
}
}));

(fluree.db.storage.core.source_novelty_t.cljs$lang$maxFixedArity = 5);

fluree.db.storage.core.resolve_t = (function fluree$db$storage$core$resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,error_fn){
var result_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33604 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33555){
var state_val_33556 = (state_33555[(1)]);
if((state_val_33556 === (7))){
var state_33555__$1 = state_33555;
var statearr_33557_33605 = state_33555__$1;
(statearr_33557_33605[(2)] = cljs.core.cst$kw$novelty);

(statearr_33557_33605[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (20))){
var inst_33534 = cljs.core.PersistentVector.EMPTY;
var state_33555__$1 = state_33555;
var statearr_33558_33606 = state_33555__$1;
(statearr_33558_33606[(2)] = inst_33534);

(statearr_33558_33606[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (1))){
var state_33555__$1 = state_33555;
var statearr_33559_33607 = state_33555__$1;
(statearr_33559_33607[(2)] = null);

(statearr_33559_33607[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (24))){
var state_33555__$1 = state_33555;
var statearr_33560_33608 = state_33555__$1;
(statearr_33560_33608[(2)] = null);

(statearr_33560_33608[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (4))){
var inst_33495 = (state_33555[(2)]);
var inst_33496 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33497 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33495);
var inst_33498 = cljs.core.async.close_BANG_(result_ch);
var state_33555__$1 = (function (){var statearr_33561 = state_33555;
(statearr_33561[(7)] = inst_33496);

(statearr_33561[(8)] = inst_33497);

return statearr_33561;
})();
var statearr_33562_33609 = state_33555__$1;
(statearr_33562_33609[(2)] = inst_33498);

(statearr_33562_33609[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (15))){
var inst_33520 = (state_33555[(2)]);
var state_33555__$1 = state_33555;
var statearr_33563_33610 = state_33555__$1;
(statearr_33563_33610[(2)] = inst_33520);

(statearr_33563_33610[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (21))){
var inst_33507 = (state_33555[(9)]);
var inst_33524 = (state_33555[(10)]);
var inst_33508 = (state_33555[(11)]);
var inst_33509 = (state_33555[(12)]);
var inst_33537 = (state_33555[(13)]);
var inst_33544 = (state_33555[(2)]);
var inst_33545 = (function (){var base_node = inst_33507;
var first_flake = inst_33508;
var node_t = inst_33509;
var source = inst_33524;
var coll = inst_33537;
var conj_QMARK_ = inst_33544;
return (function (acc,f){
if(cljs.core.truth_((function (){var G__33565 = f.p;
var fexpr__33564 = (function (){var or__4212__auto__ = remove_preds;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core.PersistentHashSet.EMPTY;
}
})();
return (fexpr__33564.cljs$core$IFn$_invoke$arity$1 ? fexpr__33564.cljs$core$IFn$_invoke$arity$1(G__33565) : fexpr__33564.call(null,G__33565));
})())){
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
if(cljs.core.truth_((conj_QMARK_.cljs$core$IFn$_invoke$arity$1 ? conj_QMARK_.cljs$core$IFn$_invoke$arity$1(f) : conj_QMARK_.call(null,f)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(acc,f);
} else {
return cljs.core.disj.cljs$core$IFn$_invoke$arity$2(acc,f);

}
}
});
})();
var inst_33546 = cljs.core.cst$kw$flakes.cljs$core$IFn$_invoke$arity$1(inst_33507);
var inst_33547 = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(inst_33545,inst_33546,inst_33537);
var inst_33548 = cljs.core.doall.cljs$core$IFn$_invoke$arity$1(inst_33547);
var inst_33549 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_33507,cljs.core.cst$kw$flakes,inst_33548);
var inst_33550 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(result_ch,inst_33549);
var _ = (function (){var statearr_33566 = state_33555;
(statearr_33566[(4)] = cljs.core.rest((state_33555[(4)])));

return statearr_33566;
})();
var state_33555__$1 = state_33555;
var statearr_33567_33611 = state_33555__$1;
(statearr_33567_33611[(2)] = inst_33550);

(statearr_33567_33611[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (13))){
var state_33555__$1 = state_33555;
var statearr_33568_33612 = state_33555__$1;
(statearr_33568_33612[(2)] = cljs.core.cst$kw$none);

(statearr_33568_33612[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (22))){
var inst_33507 = (state_33555[(9)]);
var inst_33524 = (state_33555[(10)]);
var inst_33508 = (state_33555[(11)]);
var inst_33509 = (state_33555[(12)]);
var inst_33537 = (state_33555[(13)]);
var inst_33538 = (function (){var base_node = inst_33507;
var first_flake = inst_33508;
var node_t = inst_33509;
var source = inst_33524;
var coll = inst_33537;
return (function (f){
return f.op === true;
});
})();
var state_33555__$1 = state_33555;
var statearr_33569_33613 = state_33555__$1;
(statearr_33569_33613[(2)] = inst_33538);

(statearr_33569_33613[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (6))){
var inst_33507 = (state_33555[(9)]);
var inst_33509 = (state_33555[(12)]);
var inst_33506 = (state_33555[(2)]);
var inst_33507__$1 = fluree.db.util.async.throw_err(inst_33506);
var inst_33508 = fluree.db.dbproto._first_flake(inst_33507__$1);
var inst_33509__$1 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(inst_33507__$1);
var inst_33510 = (inst_33509__$1 > t);
var state_33555__$1 = (function (){var statearr_33570 = state_33555;
(statearr_33570[(9)] = inst_33507__$1);

(statearr_33570[(11)] = inst_33508);

(statearr_33570[(12)] = inst_33509__$1);

return statearr_33570;
})();
if(cljs.core.truth_(inst_33510)){
var statearr_33571_33614 = state_33555__$1;
(statearr_33571_33614[(1)] = (7));

} else {
var statearr_33572_33615 = state_33555__$1;
(statearr_33572_33615[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (17))){
var inst_33508 = (state_33555[(11)]);
var inst_33525 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33508,rhs,leftmost_QMARK_,t);
var state_33555__$1 = state_33555;
var statearr_33573_33616 = state_33555__$1;
(statearr_33573_33616[(2)] = inst_33525);

(statearr_33573_33616[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (3))){
var inst_33553 = (state_33555[(2)]);
var state_33555__$1 = state_33555;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33555__$1,inst_33553);
} else {
if((state_val_33556 === (12))){
var inst_33522 = (state_33555[(2)]);
var state_33555__$1 = state_33555;
var statearr_33574_33617 = state_33555__$1;
(statearr_33574_33617[(2)] = inst_33522);

(statearr_33574_33617[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (2))){
var _ = (function (){var statearr_33575 = state_33555;
(statearr_33575[(4)] = cljs.core.cons((5),(state_33555[(4)])));

return statearr_33575;
})();
var inst_33504 = fluree.db.dbproto._resolve(node);
var state_33555__$1 = state_33555;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33555__$1,(6),inst_33504);
} else {
if((state_val_33556 === (23))){
var inst_33507 = (state_33555[(9)]);
var inst_33524 = (state_33555[(10)]);
var inst_33508 = (state_33555[(11)]);
var inst_33509 = (state_33555[(12)]);
var inst_33537 = (state_33555[(13)]);
var inst_33540 = (function (){var base_node = inst_33507;
var first_flake = inst_33508;
var node_t = inst_33509;
var source = inst_33524;
var coll = inst_33537;
return (function (f){
return f.op === false;
});
})();
var state_33555__$1 = state_33555;
var statearr_33576_33618 = state_33555__$1;
(statearr_33576_33618[(2)] = inst_33540);

(statearr_33576_33618[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (19))){
var inst_33527 = (state_33555[(14)]);
var inst_33530 = (state_33555[(2)]);
var inst_33531 = fluree.db.util.async.throw_err(inst_33530);
var inst_33532 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33527,inst_33531);
var state_33555__$1 = state_33555;
var statearr_33577_33619 = state_33555__$1;
(statearr_33577_33619[(2)] = inst_33532);

(statearr_33577_33619[(1)] = (16));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (11))){
var inst_33509 = (state_33555[(12)]);
var inst_33516 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_33509,t);
var state_33555__$1 = state_33555;
if(inst_33516){
var statearr_33579_33620 = state_33555__$1;
(statearr_33579_33620[(1)] = (13));

} else {
var statearr_33580_33621 = state_33555__$1;
(statearr_33580_33621[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (9))){
var inst_33524 = (state_33555[(10)]);
var inst_33524__$1 = (state_33555[(2)]);
var state_33555__$1 = (function (){var statearr_33581 = state_33555;
(statearr_33581[(10)] = inst_33524__$1);

return statearr_33581;
})();
var G__33582_33622 = inst_33524__$1;
var G__33582_33623__$1 = (((G__33582_33622 instanceof cljs.core.Keyword))?G__33582_33622.fqn:null);
switch (G__33582_33623__$1) {
case "novelty":
var statearr_33583_33625 = state_33555__$1;
(statearr_33583_33625[(1)] = (17));


break;
case "history":
var statearr_33584_33626 = state_33555__$1;
(statearr_33584_33626[(1)] = (18));


break;
case "none":
var statearr_33585_33627 = state_33555__$1;
(statearr_33585_33627[(1)] = (20));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33582_33623__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (5))){
var _ = (function (){var statearr_33586 = state_33555;
(statearr_33586[(4)] = cljs.core.rest((state_33555[(4)])));

return statearr_33586;
})();
var state_33555__$1 = state_33555;
var ex33578 = (state_33555__$1[(2)]);
var statearr_33587_33628 = state_33555__$1;
(statearr_33587_33628[(5)] = ex33578);


var statearr_33588_33629 = state_33555__$1;
(statearr_33588_33629[(1)] = (4));

(statearr_33588_33629[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (14))){
var state_33555__$1 = state_33555;
var statearr_33589_33630 = state_33555__$1;
(statearr_33589_33630[(2)] = null);

(statearr_33589_33630[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (16))){
var inst_33524 = (state_33555[(10)]);
var inst_33537 = (state_33555[(2)]);
var state_33555__$1 = (function (){var statearr_33590 = state_33555;
(statearr_33590[(13)] = inst_33537);

return statearr_33590;
})();
var G__33591_33631 = inst_33524;
var G__33591_33632__$1 = (((G__33591_33631 instanceof cljs.core.Keyword))?G__33591_33631.fqn:null);
switch (G__33591_33632__$1) {
case "novelty":
var statearr_33592_33634 = state_33555__$1;
(statearr_33592_33634[(1)] = (22));


break;
case "history":
var statearr_33593_33635 = state_33555__$1;
(statearr_33593_33635[(1)] = (23));


break;
case "none":
var statearr_33594_33636 = state_33555__$1;
(statearr_33594_33636[(1)] = (24));


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__33591_33632__$1)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (10))){
var state_33555__$1 = state_33555;
var statearr_33595_33637 = state_33555__$1;
(statearr_33595_33637[(2)] = cljs.core.cst$kw$history);

(statearr_33595_33637[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33556 === (18))){
var inst_33507 = (state_33555[(9)]);
var inst_33524 = (state_33555[(10)]);
var inst_33508 = (state_33555[(11)]);
var inst_33509 = (state_33555[(12)]);
var inst_33527 = (function (){var base_node = inst_33507;
var first_flake = inst_33508;
var node_t = inst_33509;
var source = inst_33524;
return (function (p1__33494_SHARP_){
return (p1__33494_SHARP_.t <= t);
});
})();
var inst_33528 = fluree.db.dbproto._resolve_history(node);
var state_33555__$1 = (function (){var statearr_33596 = state_33555;
(statearr_33596[(14)] = inst_33527);

return statearr_33596;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33555__$1,(19),inst_33528);
} else {
if((state_val_33556 === (8))){
var inst_33509 = (state_33555[(12)]);
var inst_33513 = (inst_33509 < t);
var state_33555__$1 = state_33555;
if(cljs.core.truth_(inst_33513)){
var statearr_33597_33638 = state_33555__$1;
(statearr_33597_33638[(1)] = (10));

} else {
var statearr_33598_33639 = state_33555__$1;
(statearr_33598_33639[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0 = (function (){
var statearr_33599 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33599[(0)] = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__);

(statearr_33599[(1)] = (1));

return statearr_33599;
});
var fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1 = (function (state_33555){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33555);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33600){var ex__16398__auto__ = e33600;
var statearr_33601_33640 = state_33555;
(statearr_33601_33640[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33555[(4)]))){
var statearr_33602_33641 = state_33555;
(statearr_33602_33641[(1)] = cljs.core.first((state_33555[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33642 = state_33555;
state_33555 = G__33642;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__ = function(state_33555){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1.call(this,state_33555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____0;
fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_t_$_state_machine__16395__auto____1;
return fluree$db$storage$core$resolve_t_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33603 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33603[(6)] = c__16469__auto___33604);

return statearr_33603;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return result_ch;
});
/**
 * Gets a history slice of a node with the oldest 't' from-t, to the
 *   most recent 't', to-t.
 * 
 *   Returns sorted set in novelty's sort order (spot, psot, post, or opst)
 */
fluree.db.storage.core.resolve_history_range = (function fluree$db$storage$core$resolve_history_range(node,from_t,to_t,idx_novelty,leftmost_QMARK_){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33702){
var state_val_33703 = (state_33702[(1)]);
if((state_val_33703 === (7))){
var inst_33653 = (state_33702[(7)]);
var inst_33657 = (inst_33653 <= from_t);
var state_33702__$1 = state_33702;
var statearr_33704_33744 = state_33702__$1;
(statearr_33704_33744[(2)] = inst_33657);

(statearr_33704_33744[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (20))){
var inst_33687 = cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(node);
var inst_33688 = ["resolve-history-range called on index node: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(inst_33687)].join('');
var inst_33689 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33690 = [(500),cljs.core.cst$kw$db_SLASH_unexpected_DASH_error];
var inst_33691 = cljs.core.PersistentHashMap.fromArrays(inst_33689,inst_33690);
var inst_33692 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33688,inst_33691);
var inst_33693 = (function(){throw inst_33692})();
var state_33702__$1 = state_33702;
var statearr_33705_33745 = state_33702__$1;
(statearr_33705_33745[(2)] = inst_33693);

(statearr_33705_33745[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (1))){
var state_33702__$1 = state_33702;
var statearr_33706_33746 = state_33702__$1;
(statearr_33706_33746[(2)] = null);

(statearr_33706_33746[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (4))){
var inst_33645 = (state_33702[(2)]);
var inst_33646 = fluree.db.util.log.error.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([inst_33645], 0));
var inst_33647 = (function(){throw inst_33645})();
var state_33702__$1 = (function (){var statearr_33707 = state_33702;
(statearr_33707[(8)] = inst_33646);

return statearr_33707;
})();
var statearr_33708_33747 = state_33702__$1;
(statearr_33708_33747[(2)] = inst_33647);

(statearr_33708_33747[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (15))){
var inst_33672 = (state_33702[(2)]);
var state_33702__$1 = (function (){var statearr_33709 = state_33702;
(statearr_33709[(9)] = inst_33672);

return statearr_33709;
})();
if(cljs.core.truth_(from_t)){
var statearr_33710_33748 = state_33702__$1;
(statearr_33710_33748[(1)] = (16));

} else {
var statearr_33711_33749 = state_33702__$1;
(statearr_33711_33749[(1)] = (17));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (21))){
var inst_33681 = (state_33702[(10)]);
var inst_33682 = (state_33702[(11)]);
var inst_33683 = (state_33702[(12)]);
var inst_33695 = (state_33702[(2)]);
var inst_33696 = fluree.db.storage.core.source_novelty_t.cljs$core$IFn$_invoke$arity$5(idx_novelty,inst_33682,inst_33683,leftmost_QMARK_,to_t);
var inst_33697 = cljs.core.into.cljs$core$IFn$_invoke$arity$2(inst_33696,inst_33681);
var _ = (function (){var statearr_33712 = state_33702;
(statearr_33712[(4)] = cljs.core.rest((state_33702[(4)])));

return statearr_33712;
})();
var state_33702__$1 = (function (){var statearr_33713 = state_33702;
(statearr_33713[(13)] = inst_33695);

return statearr_33713;
})();
var statearr_33714_33750 = state_33702__$1;
(statearr_33714_33750[(2)] = inst_33697);

(statearr_33714_33750[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (13))){
var inst_33665 = (state_33702[(14)]);
var inst_33653 = (state_33702[(7)]);
var inst_33668 = (function (){var node_t = inst_33653;
var G__33661 = inst_33665;
return (function (p1__33643_SHARP_){
return (p1__33643_SHARP_.t < to_t);
});
})();
var inst_33669 = cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(inst_33668,inst_33665);
var state_33702__$1 = state_33702;
var statearr_33715_33751 = state_33702__$1;
(statearr_33715_33751[(2)] = inst_33669);

(statearr_33715_33751[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (6))){
var inst_33654 = (state_33702[(15)]);
var state_33702__$1 = state_33702;
var statearr_33716_33752 = state_33702__$1;
(statearr_33716_33752[(2)] = inst_33654);

(statearr_33716_33752[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (17))){
var inst_33672 = (state_33702[(9)]);
var state_33702__$1 = state_33702;
var statearr_33717_33753 = state_33702__$1;
(statearr_33717_33753[(2)] = inst_33672);

(statearr_33717_33753[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (3))){
var inst_33700 = (state_33702[(2)]);
var state_33702__$1 = state_33702;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33702__$1,inst_33700);
} else {
if((state_val_33703 === (12))){
var inst_33653 = (state_33702[(7)]);
var inst_33664 = (state_33702[(2)]);
var inst_33665 = fluree.db.util.async.throw_err(inst_33664);
var inst_33666 = (to_t > inst_33653);
var state_33702__$1 = (function (){var statearr_33718 = state_33702;
(statearr_33718[(14)] = inst_33665);

return statearr_33718;
})();
if(cljs.core.truth_(inst_33666)){
var statearr_33719_33754 = state_33702__$1;
(statearr_33719_33754[(1)] = (13));

} else {
var statearr_33720_33755 = state_33702__$1;
(statearr_33720_33755[(1)] = (14));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (2))){
var inst_33654 = (state_33702[(15)]);
var _ = (function (){var statearr_33721 = state_33702;
(statearr_33721[(4)] = cljs.core.cons((5),(state_33702[(4)])));

return statearr_33721;
})();
var inst_33653 = cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(node);
var inst_33654__$1 = (from_t == null);
var state_33702__$1 = (function (){var statearr_33722 = state_33702;
(statearr_33722[(15)] = inst_33654__$1);

(statearr_33722[(7)] = inst_33653);

return statearr_33722;
})();
if(cljs.core.truth_(inst_33654__$1)){
var statearr_33723_33756 = state_33702__$1;
(statearr_33723_33756[(1)] = (6));

} else {
var statearr_33724_33757 = state_33702__$1;
(statearr_33724_33757[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (19))){
var state_33702__$1 = state_33702;
var statearr_33725_33758 = state_33702__$1;
(statearr_33725_33758[(2)] = null);

(statearr_33725_33758[(1)] = (21));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (11))){
var inst_33681 = (state_33702[(2)]);
var inst_33682 = fluree.db.dbproto._first_flake(node);
var inst_33683 = fluree.db.dbproto._rhs(node);
var inst_33684 = cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(node);
var state_33702__$1 = (function (){var statearr_33727 = state_33702;
(statearr_33727[(10)] = inst_33681);

(statearr_33727[(11)] = inst_33682);

(statearr_33727[(12)] = inst_33683);

return statearr_33727;
})();
if(cljs.core.truth_(inst_33684)){
var statearr_33728_33759 = state_33702__$1;
(statearr_33728_33759[(1)] = (19));

} else {
var statearr_33729_33760 = state_33702__$1;
(statearr_33729_33760[(1)] = (20));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (9))){
var inst_33662 = fluree.db.dbproto._resolve_history(node);
var state_33702__$1 = state_33702;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33702__$1,(12),inst_33662);
} else {
if((state_val_33703 === (5))){
var _ = (function (){var statearr_33730 = state_33702;
(statearr_33730[(4)] = cljs.core.rest((state_33702[(4)])));

return statearr_33730;
})();
var state_33702__$1 = state_33702;
var ex33726 = (state_33702__$1[(2)]);
var statearr_33731_33761 = state_33702__$1;
(statearr_33731_33761[(5)] = ex33726);


var statearr_33732_33762 = state_33702__$1;
(statearr_33732_33762[(1)] = (4));

(statearr_33732_33762[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (14))){
var inst_33665 = (state_33702[(14)]);
var state_33702__$1 = state_33702;
var statearr_33733_33763 = state_33702__$1;
(statearr_33733_33763[(2)] = inst_33665);

(statearr_33733_33763[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (16))){
var inst_33653 = (state_33702[(7)]);
var inst_33672 = (state_33702[(9)]);
var inst_33674 = (function (){var node_t = inst_33653;
var G__33661 = inst_33672;
return (function (p1__33644_SHARP_){
return (p1__33644_SHARP_.t <= from_t);
});
})();
var inst_33675 = cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(inst_33674,inst_33672);
var state_33702__$1 = state_33702;
var statearr_33734_33764 = state_33702__$1;
(statearr_33734_33764[(2)] = inst_33675);

(statearr_33734_33764[(1)] = (18));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (10))){
var state_33702__$1 = state_33702;
var statearr_33735_33765 = state_33702__$1;
(statearr_33735_33765[(2)] = null);

(statearr_33735_33765[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (18))){
var inst_33678 = (state_33702[(2)]);
var state_33702__$1 = state_33702;
var statearr_33736_33766 = state_33702__$1;
(statearr_33736_33766[(2)] = inst_33678);

(statearr_33736_33766[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33703 === (8))){
var inst_33659 = (state_33702[(2)]);
var state_33702__$1 = state_33702;
if(cljs.core.truth_(inst_33659)){
var statearr_33737_33767 = state_33702__$1;
(statearr_33737_33767[(1)] = (9));

} else {
var statearr_33738_33768 = state_33702__$1;
(statearr_33738_33768[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0 = (function (){
var statearr_33739 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_33739[(0)] = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__);

(statearr_33739[(1)] = (1));

return statearr_33739;
});
var fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1 = (function (state_33702){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33702);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33740){var ex__16398__auto__ = e33740;
var statearr_33741_33769 = state_33702;
(statearr_33741_33769[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33702[(4)]))){
var statearr_33742_33770 = state_33702;
(statearr_33742_33770[(1)] = cljs.core.first((state_33702[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33771 = state_33702;
state_33702 = G__33771;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__ = function(state_33702){
switch(arguments.length){
case 0:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1.call(this,state_33702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____0;
fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto____1;
return fluree$db$storage$core$resolve_history_range_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33743 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33743[(6)] = c__16469__auto__);

return statearr_33743;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
fluree.db.storage.core.resolve_to_t = (function fluree$db$storage$core$resolve_to_t(node,id,tempid,rhs,leftmost_QMARK_,t,tt_id,idx_novelty,conn,fast_foward_db_QMARK_,remove_preds){
if(cljs.core.truth_((function (){var or__4212__auto__ = fast_foward_db_QMARK_;
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,id);
}
})())){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,null);
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(conn);
if((!(cljs.core.empty_QMARK_(remove_preds)))){
var G__33772_33782 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33773_33783 = null;
(object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33772_33782,G__33773_33783) : object_cache.call(null,G__33772_33782,G__33773_33783));

var G__33774 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33775 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33776 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33777 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33776,G__33777) : object_cache.call(null,G__33776,G__33777));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33774,G__33775) : object_cache.call(null,G__33774,G__33775));
} else {
var G__33778 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33779 = (function (_){
return fluree.db.storage.core.resolve_t(node,t,idx_novelty,rhs,leftmost_QMARK_,remove_preds,(function (){
var G__33780 = new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [id,t,tt_id,tempid], null);
var G__33781 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33780,G__33781) : object_cache.call(null,G__33780,G__33781));
}));
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__33778,G__33779) : object_cache.call(null,G__33778,G__33779));
}
}
});
/**
 * Reads and deserializes branch node.
 */
fluree.db.storage.core.read_branch = (function fluree$db$storage$core$read_branch(conn,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33804){
var state_val_33805 = (state_33804[(1)]);
if((state_val_33805 === (7))){
var state_33804__$1 = state_33804;
var statearr_33806_33826 = state_33804__$1;
(statearr_33806_33826[(2)] = null);

(statearr_33806_33826[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (1))){
var state_33804__$1 = state_33804;
var statearr_33807_33827 = state_33804__$1;
(statearr_33807_33827[(2)] = null);

(statearr_33807_33827[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (4))){
var inst_33784 = (state_33804[(2)]);
var state_33804__$1 = state_33804;
var statearr_33808_33828 = state_33804__$1;
(statearr_33808_33828[(2)] = inst_33784);

(statearr_33808_33828[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (6))){
var inst_33790 = (state_33804[(7)]);
var inst_33792 = fluree.db.storage.core.serde(conn);
var state_33804__$1 = (function (){var statearr_33809 = state_33804;
(statearr_33809[(8)] = inst_33792);

return statearr_33809;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33804__$1,(9),inst_33790);
} else {
if((state_val_33805 === (3))){
var inst_33802 = (state_33804[(2)]);
var state_33804__$1 = state_33804;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33804__$1,inst_33802);
} else {
if((state_val_33805 === (2))){
var inst_33790 = (state_33804[(7)]);
var _ = (function (){var statearr_33811 = state_33804;
(statearr_33811[(4)] = cljs.core.cons((5),(state_33804[(4)])));

return statearr_33811;
})();
var inst_33790__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33804__$1 = (function (){var statearr_33812 = state_33804;
(statearr_33812[(7)] = inst_33790__$1);

return statearr_33812;
})();
if(cljs.core.truth_(inst_33790__$1)){
var statearr_33813_33829 = state_33804__$1;
(statearr_33813_33829[(1)] = (6));

} else {
var statearr_33814_33830 = state_33804__$1;
(statearr_33814_33830[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (9))){
var inst_33792 = (state_33804[(8)]);
var inst_33794 = (state_33804[(2)]);
var inst_33795 = fluree.db.util.async.throw_err(inst_33794);
var inst_33796 = fluree.db.serde.protocol._deserialize_branch(inst_33792,inst_33795);
var state_33804__$1 = state_33804;
var statearr_33815_33831 = state_33804__$1;
(statearr_33815_33831[(2)] = inst_33796);

(statearr_33815_33831[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (5))){
var _ = (function (){var statearr_33816 = state_33804;
(statearr_33816[(4)] = cljs.core.rest((state_33804[(4)])));

return statearr_33816;
})();
var state_33804__$1 = state_33804;
var ex33810 = (state_33804__$1[(2)]);
var statearr_33817_33832 = state_33804__$1;
(statearr_33817_33832[(5)] = ex33810);


if((ex33810 instanceof Error)){
var statearr_33818_33833 = state_33804__$1;
(statearr_33818_33833[(1)] = (4));

(statearr_33818_33833[(5)] = null);

} else {
throw ex33810;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33805 === (8))){
var inst_33799 = (state_33804[(2)]);
var _ = (function (){var statearr_33819 = state_33804;
(statearr_33819[(4)] = cljs.core.rest((state_33804[(4)])));

return statearr_33819;
})();
var state_33804__$1 = state_33804;
var statearr_33820_33834 = state_33804__$1;
(statearr_33820_33834[(2)] = inst_33799);

(statearr_33820_33834[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0 = (function (){
var statearr_33821 = [null,null,null,null,null,null,null,null,null];
(statearr_33821[(0)] = fluree$db$storage$core$read_branch_$_state_machine__16395__auto__);

(statearr_33821[(1)] = (1));

return statearr_33821;
});
var fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1 = (function (state_33804){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33804);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33822){var ex__16398__auto__ = e33822;
var statearr_33823_33835 = state_33804;
(statearr_33823_33835[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33804[(4)]))){
var statearr_33824_33836 = state_33804;
(statearr_33824_33836[(1)] = cljs.core.first((state_33804[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33837 = state_33804;
state_33804 = G__33837;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__ = function(state_33804){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1.call(this,state_33804);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_branch_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_branch_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_branch_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33825 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33825[(6)] = c__16469__auto__);

return statearr_33825;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_branch = (function fluree$db$storage$core$reify_branch(conn,config,network,dbid,key,block,t,tt_id,leftmost_QMARK_,tempid,error_fn){
var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___33916 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33888){
var state_val_33889 = (state_33888[(1)]);
if((state_val_33889 === (7))){
var inst_33855 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_33856 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_33857 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_33858 = cljs.core.PersistentHashMap.fromArrays(inst_33856,inst_33857);
var inst_33859 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_33855,inst_33858);
var inst_33860 = (function(){throw inst_33859})();
var state_33888__$1 = state_33888;
var statearr_33890_33917 = state_33888__$1;
(statearr_33890_33917[(2)] = inst_33860);

(statearr_33890_33917[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (1))){
var state_33888__$1 = state_33888;
var statearr_33891_33918 = state_33888__$1;
(statearr_33891_33918[(2)] = null);

(statearr_33891_33918[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (4))){
var inst_33838 = (state_33888[(2)]);
var inst_33839 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33840 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33838);
var inst_33841 = cljs.core.async.close_BANG_(return_ch);
var state_33888__$1 = (function (){var statearr_33892 = state_33888;
(statearr_33892[(7)] = inst_33839);

(statearr_33892[(8)] = inst_33840);

return statearr_33892;
})();
var statearr_33893_33919 = state_33888__$1;
(statearr_33893_33919[(2)] = inst_33841);

(statearr_33893_33919[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (6))){
var inst_33852 = (state_33888[(9)]);
var inst_33851 = (state_33888[(2)]);
var inst_33852__$1 = fluree.db.util.async.throw_err(inst_33851);
var inst_33853 = (inst_33852__$1 == null);
var state_33888__$1 = (function (){var statearr_33894 = state_33888;
(statearr_33894[(9)] = inst_33852__$1);

return statearr_33894;
})();
if(cljs.core.truth_(inst_33853)){
var statearr_33895_33920 = state_33888__$1;
(statearr_33895_33920[(1)] = (7));

} else {
var statearr_33896_33921 = state_33888__$1;
(statearr_33896_33921[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (3))){
var inst_33886 = (state_33888[(2)]);
var state_33888__$1 = state_33888;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33888__$1,inst_33886);
} else {
if((state_val_33889 === (12))){
var inst_33852 = (state_33888[(9)]);
var inst_33869 = (state_33888[(2)]);
var inst_33870 = cljs.core.__destructure_map(inst_33852);
var inst_33871 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33870,cljs.core.cst$kw$children);
var inst_33872 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33870,cljs.core.cst$kw$rhs);
var inst_33873 = config;
var inst_33874 = cljs.core.__destructure_map(inst_33873);
var inst_33875 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_33874,cljs.core.cst$kw$comparator);
var inst_33877 = (function (){var data = inst_33852;
var _ = inst_33869;
var map__33847 = inst_33870;
var children = inst_33871;
var rhs = inst_33872;
var map__33848 = inst_33874;
var comparator = inst_33875;
return (function (idx,p__33876){
var map__33897 = p__33876;
var map__33897__$1 = cljs.core.__destructure_map(map__33897);
var child = map__33897__$1;
var id = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33897__$1,cljs.core.cst$kw$id);
var leaf = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33897__$1,cljs.core.cst$kw$leaf);
var first = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33897__$1,cljs.core.cst$kw$first);
var rhs__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33897__$1,cljs.core.cst$kw$rhs);
var size = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__33897__$1,cljs.core.cst$kw$size);
var at_leftmost_QMARK_ = (function (){var and__4210__auto__ = leftmost_QMARK_;
if(cljs.core.truth_(and__4210__auto__)){
return (idx === (0));
} else {
return and__4210__auto__;
}
})();
return (fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14 ? fluree.db.storage.core.__GT_UnresolvedNode.cljs$core$IFn$_invoke$arity$14(conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid) : fluree.db.storage.core.__GT_UnresolvedNode.call(null,conn,config,network,dbid,id,leaf,first,rhs__$1,size,block,t,tt_id,at_leftmost_QMARK_,tempid));
});
})();
var inst_33878 = cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(inst_33877,inst_33871);
var inst_33879 = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$first,inst_33878);
var inst_33880 = cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(inst_33879,inst_33878);
var inst_33881 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(clojure.data.avl.sorted_map_by,inst_33875,inst_33880);
var inst_33882 = fluree.db.index.__GT_IndexNode(block,t,inst_33872,inst_33881,config,leftmost_QMARK_);
var inst_33883 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33882);
var _ = (function (){var statearr_33898 = state_33888;
(statearr_33898[(4)] = cljs.core.rest((state_33888[(4)])));

return statearr_33898;
})();
var state_33888__$1 = state_33888;
var statearr_33899_33922 = state_33888__$1;
(statearr_33899_33922[(2)] = inst_33883);

(statearr_33899_33922[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (2))){
var _ = (function (){var statearr_33900 = state_33888;
(statearr_33900[(4)] = cljs.core.cons((5),(state_33888[(4)])));

return statearr_33900;
})();
var inst_33849 = fluree.db.storage.core.read_branch(conn,key);
var state_33888__$1 = state_33888;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33888__$1,(6),inst_33849);
} else {
if((state_val_33889 === (11))){
var state_33888__$1 = state_33888;
var statearr_33902_33923 = state_33888__$1;
(statearr_33902_33923[(2)] = null);

(statearr_33902_33923[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (9))){
var inst_33852 = (state_33888[(9)]);
var inst_33863 = (state_33888[(2)]);
var inst_33864 = fluree.db.util.core.exception_QMARK_(inst_33852);
var state_33888__$1 = (function (){var statearr_33903 = state_33888;
(statearr_33903[(10)] = inst_33863);

return statearr_33903;
})();
if(inst_33864){
var statearr_33904_33924 = state_33888__$1;
(statearr_33904_33924[(1)] = (10));

} else {
var statearr_33905_33925 = state_33888__$1;
(statearr_33905_33925[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (5))){
var _ = (function (){var statearr_33906 = state_33888;
(statearr_33906[(4)] = cljs.core.rest((state_33888[(4)])));

return statearr_33906;
})();
var state_33888__$1 = state_33888;
var ex33901 = (state_33888__$1[(2)]);
var statearr_33907_33926 = state_33888__$1;
(statearr_33907_33926[(5)] = ex33901);


var statearr_33908_33927 = state_33888__$1;
(statearr_33908_33927[(1)] = (4));

(statearr_33908_33927[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (10))){
var inst_33852 = (state_33888[(9)]);
var inst_33866 = (function(){throw inst_33852})();
var state_33888__$1 = state_33888;
var statearr_33909_33928 = state_33888__$1;
(statearr_33909_33928[(2)] = inst_33866);

(statearr_33909_33928[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33889 === (8))){
var state_33888__$1 = state_33888;
var statearr_33910_33929 = state_33888__$1;
(statearr_33910_33929[(2)] = null);

(statearr_33910_33929[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0 = (function (){
var statearr_33911 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_33911[(0)] = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__);

(statearr_33911[(1)] = (1));

return statearr_33911;
});
var fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1 = (function (state_33888){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33888);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33912){var ex__16398__auto__ = e33912;
var statearr_33913_33930 = state_33888;
(statearr_33913_33930[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33888[(4)]))){
var statearr_33914_33931 = state_33888;
(statearr_33914_33931[(1)] = cljs.core.first((state_33888[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33932 = state_33888;
state_33888 = G__33932;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__ = function(state_33888){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1.call(this,state_33888);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_branch_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_branch_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33915 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33915[(6)] = c__16469__auto___33916);

return statearr_33915;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});
/**
 * Reads and deserializes a leaf node
 */
fluree.db.storage.core.read_leaf = (function fluree$db$storage$core$read_leaf(conn,key){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_33953){
var state_val_33954 = (state_33953[(1)]);
if((state_val_33954 === (7))){
var state_33953__$1 = state_33953;
var statearr_33955_33975 = state_33953__$1;
(statearr_33955_33975[(2)] = null);

(statearr_33955_33975[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (1))){
var state_33953__$1 = state_33953;
var statearr_33956_33976 = state_33953__$1;
(statearr_33956_33976[(2)] = null);

(statearr_33956_33976[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (4))){
var inst_33933 = (state_33953[(2)]);
var state_33953__$1 = state_33953;
var statearr_33957_33977 = state_33953__$1;
(statearr_33957_33977[(2)] = inst_33933);

(statearr_33957_33977[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (6))){
var inst_33939 = (state_33953[(7)]);
var inst_33941 = fluree.db.storage.core.serde(conn);
var state_33953__$1 = (function (){var statearr_33958 = state_33953;
(statearr_33958[(8)] = inst_33941);

return statearr_33958;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_33953__$1,(9),inst_33939);
} else {
if((state_val_33954 === (3))){
var inst_33951 = (state_33953[(2)]);
var state_33953__$1 = state_33953;
return cljs.core.async.impl.ioc_helpers.return_chan(state_33953__$1,inst_33951);
} else {
if((state_val_33954 === (2))){
var inst_33939 = (state_33953[(7)]);
var _ = (function (){var statearr_33960 = state_33953;
(statearr_33960[(4)] = cljs.core.cons((5),(state_33953[(4)])));

return statearr_33960;
})();
var inst_33939__$1 = fluree.db.storage.core.storage_read(conn,key);
var state_33953__$1 = (function (){var statearr_33961 = state_33953;
(statearr_33961[(7)] = inst_33939__$1);

return statearr_33961;
})();
if(cljs.core.truth_(inst_33939__$1)){
var statearr_33962_33978 = state_33953__$1;
(statearr_33962_33978[(1)] = (6));

} else {
var statearr_33963_33979 = state_33953__$1;
(statearr_33963_33979[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (9))){
var inst_33941 = (state_33953[(8)]);
var inst_33943 = (state_33953[(2)]);
var inst_33944 = fluree.db.util.async.throw_err(inst_33943);
var inst_33945 = fluree.db.serde.protocol._deserialize_leaf(inst_33941,inst_33944);
var state_33953__$1 = state_33953;
var statearr_33964_33980 = state_33953__$1;
(statearr_33964_33980[(2)] = inst_33945);

(statearr_33964_33980[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (5))){
var _ = (function (){var statearr_33965 = state_33953;
(statearr_33965[(4)] = cljs.core.rest((state_33953[(4)])));

return statearr_33965;
})();
var state_33953__$1 = state_33953;
var ex33959 = (state_33953__$1[(2)]);
var statearr_33966_33981 = state_33953__$1;
(statearr_33966_33981[(5)] = ex33959);


if((ex33959 instanceof Error)){
var statearr_33967_33982 = state_33953__$1;
(statearr_33967_33982[(1)] = (4));

(statearr_33967_33982[(5)] = null);

} else {
throw ex33959;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_33954 === (8))){
var inst_33948 = (state_33953[(2)]);
var _ = (function (){var statearr_33968 = state_33953;
(statearr_33968[(4)] = cljs.core.rest((state_33953[(4)])));

return statearr_33968;
})();
var state_33953__$1 = state_33953;
var statearr_33969_33983 = state_33953__$1;
(statearr_33969_33983[(2)] = inst_33948);

(statearr_33969_33983[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_33970 = [null,null,null,null,null,null,null,null,null];
(statearr_33970[(0)] = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__);

(statearr_33970[(1)] = (1));

return statearr_33970;
});
var fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1 = (function (state_33953){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_33953);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e33971){var ex__16398__auto__ = e33971;
var statearr_33972_33984 = state_33953;
(statearr_33972_33984[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_33953[(4)]))){
var statearr_33973_33985 = state_33953;
(statearr_33973_33985[(1)] = cljs.core.first((state_33953[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__33986 = state_33953;
state_33953 = G__33986;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__ = function(state_33953){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1.call(this,state_33953);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_33974 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_33974[(6)] = c__16469__auto__);

return statearr_33974;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Should throw if no result... should never be the case.
 */
fluree.db.storage.core.reify_leaf = (function fluree$db$storage$core$reify_leaf(conn,config,key,block,t,rhs,error_fn){
if(cljs.core.truth_(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(config))){
} else {
throw (new Error(["Assert failed: ",["Cannot reify leaf, config does not have a comparator. Config: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([config], 0))].join(''),"\n","(:comparator config)"].join('')));
}

var return_ch = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
var c__16469__auto___34059 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34031){
var state_val_34032 = (state_34031[(1)]);
if((state_val_34032 === (7))){
var inst_34003 = ["Unable to retrieve key from storage: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(key)].join('');
var inst_34004 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34005 = [(500),cljs.core.cst$kw$db_SLASH_storage_DASH_error];
var inst_34006 = cljs.core.PersistentHashMap.fromArrays(inst_34004,inst_34005);
var inst_34007 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34003,inst_34006);
var inst_34008 = (function(){throw inst_34007})();
var state_34031__$1 = state_34031;
var statearr_34033_34060 = state_34031__$1;
(statearr_34033_34060[(2)] = inst_34008);

(statearr_34033_34060[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (1))){
var state_34031__$1 = state_34031;
var statearr_34034_34061 = state_34031__$1;
(statearr_34034_34061[(2)] = null);

(statearr_34034_34061[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (4))){
var inst_33987 = (state_34031[(2)]);
var inst_33988 = (error_fn.cljs$core$IFn$_invoke$arity$0 ? error_fn.cljs$core$IFn$_invoke$arity$0() : error_fn.call(null));
var inst_33989 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_33987);
var inst_33990 = cljs.core.async.close_BANG_(return_ch);
var state_34031__$1 = (function (){var statearr_34035 = state_34031;
(statearr_34035[(7)] = inst_33989);

(statearr_34035[(8)] = inst_33988);

return statearr_34035;
})();
var statearr_34036_34062 = state_34031__$1;
(statearr_34036_34062[(2)] = inst_33990);

(statearr_34036_34062[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (6))){
var inst_34000 = (state_34031[(9)]);
var inst_34000__$1 = (state_34031[(2)]);
var inst_34001 = (inst_34000__$1 == null);
var state_34031__$1 = (function (){var statearr_34037 = state_34031;
(statearr_34037[(9)] = inst_34000__$1);

return statearr_34037;
})();
if(cljs.core.truth_(inst_34001)){
var statearr_34038_34063 = state_34031__$1;
(statearr_34038_34063[(1)] = (7));

} else {
var statearr_34039_34064 = state_34031__$1;
(statearr_34039_34064[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (3))){
var inst_34029 = (state_34031[(2)]);
var state_34031__$1 = state_34031;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34031__$1,inst_34029);
} else {
if((state_val_34032 === (12))){
var inst_34000 = (state_34031[(9)]);
var inst_34017 = (state_34031[(2)]);
var inst_34018 = cljs.core.__destructure_map(inst_34000);
var inst_34019 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34018,cljs.core.cst$kw$flakes);
var inst_34020 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34018,cljs.core.cst$kw$his);
var inst_34021 = config;
var inst_34022 = cljs.core.__destructure_map(inst_34021);
var inst_34023 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_34022,cljs.core.cst$kw$comparator);
var inst_34024 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(fluree.db.flake.sorted_set_by,inst_34023,inst_34019);
var inst_34025 = fluree.db.index.data_node(block,t,inst_34024,rhs,config);
var inst_34026 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(return_ch,inst_34025);
var _ = (function (){var statearr_34040 = state_34031;
(statearr_34040[(4)] = cljs.core.rest((state_34031[(4)])));

return statearr_34040;
})();
var state_34031__$1 = (function (){var statearr_34041 = state_34031;
(statearr_34041[(10)] = inst_34020);

(statearr_34041[(11)] = inst_34017);

return statearr_34041;
})();
var statearr_34042_34065 = state_34031__$1;
(statearr_34042_34065[(2)] = inst_34026);

(statearr_34042_34065[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (2))){
var _ = (function (){var statearr_34043 = state_34031;
(statearr_34043[(4)] = cljs.core.cons((5),(state_34031[(4)])));

return statearr_34043;
})();
var inst_33998 = fluree.db.storage.core.read_leaf(conn,key);
var state_34031__$1 = state_34031;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34031__$1,(6),inst_33998);
} else {
if((state_val_34032 === (11))){
var state_34031__$1 = state_34031;
var statearr_34045_34066 = state_34031__$1;
(statearr_34045_34066[(2)] = null);

(statearr_34045_34066[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (9))){
var inst_34000 = (state_34031[(9)]);
var inst_34011 = (state_34031[(2)]);
var inst_34012 = fluree.db.util.core.exception_QMARK_(inst_34000);
var state_34031__$1 = (function (){var statearr_34046 = state_34031;
(statearr_34046[(12)] = inst_34011);

return statearr_34046;
})();
if(inst_34012){
var statearr_34047_34067 = state_34031__$1;
(statearr_34047_34067[(1)] = (10));

} else {
var statearr_34048_34068 = state_34031__$1;
(statearr_34048_34068[(1)] = (11));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (5))){
var _ = (function (){var statearr_34049 = state_34031;
(statearr_34049[(4)] = cljs.core.rest((state_34031[(4)])));

return statearr_34049;
})();
var state_34031__$1 = state_34031;
var ex34044 = (state_34031__$1[(2)]);
var statearr_34050_34069 = state_34031__$1;
(statearr_34050_34069[(5)] = ex34044);


var statearr_34051_34070 = state_34031__$1;
(statearr_34051_34070[(1)] = (4));

(statearr_34051_34070[(5)] = null);



return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (10))){
var inst_34000 = (state_34031[(9)]);
var inst_34014 = (function(){throw inst_34000})();
var state_34031__$1 = state_34031;
var statearr_34052_34071 = state_34031__$1;
(statearr_34052_34071[(2)] = inst_34014);

(statearr_34052_34071[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34032 === (8))){
var state_34031__$1 = state_34031;
var statearr_34053_34072 = state_34031__$1;
(statearr_34053_34072[(2)] = null);

(statearr_34053_34072[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0 = (function (){
var statearr_34054 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34054[(0)] = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__);

(statearr_34054[(1)] = (1));

return statearr_34054;
});
var fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1 = (function (state_34031){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34031);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34055){var ex__16398__auto__ = e34055;
var statearr_34056_34073 = state_34031;
(statearr_34056_34073[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34031[(4)]))){
var statearr_34057_34074 = state_34031;
(statearr_34057_34074[(1)] = cljs.core.first((state_34031[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34075 = state_34031;
state_34031 = G__34075;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__ = function(state_34031){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1.call(this,state_34031);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_leaf_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34058 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34058[(6)] = c__16469__auto___34059);

return statearr_34058;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));


return return_ch;
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {fluree.db.dbproto.IResolve}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
fluree.db.storage.core.UnresolvedNode = (function (conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,__meta,__extmap,__hash){
this.conn = conn;
this.config = config;
this.network = network;
this.dbid = dbid;
this.id = id;
this.leaf = leaf;
this.first = first;
this.rhs = rhs;
this.size = size;
this.block = block;
this.t = t;
this.tt_id = tt_id;
this.leftmost_QMARK_ = leftmost_QMARK_;
this.tempid = tempid;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__4461__auto__,k__4462__auto__){
var self__ = this;
var this__4461__auto____$1 = this;
return this__4461__auto____$1.cljs$core$ILookup$_lookup$arity$3(null,k__4462__auto__,null);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__4463__auto__,k34077,else__4464__auto__){
var self__ = this;
var this__4463__auto____$1 = this;
var G__34081 = k34077;
var G__34081__$1 = (((G__34081 instanceof cljs.core.Keyword))?G__34081.fqn:null);
switch (G__34081__$1) {
case "conn":
return self__.conn;

break;
case "config":
return self__.config;

break;
case "network":
return self__.network;

break;
case "dbid":
return self__.dbid;

break;
case "id":
return self__.id;

break;
case "leaf":
return self__.leaf;

break;
case "first":
return self__.first;

break;
case "rhs":
return self__.rhs;

break;
case "size":
return self__.size;

break;
case "block":
return self__.block;

break;
case "t":
return self__.t;

break;
case "tt-id":
return self__.tt_id;

break;
case "leftmost?":
return self__.leftmost_QMARK_;

break;
case "tempid":
return self__.tempid;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k34077,else__4464__auto__);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__4481__auto__,f__4482__auto__,init__4483__auto__){
var self__ = this;
var this__4481__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__4484__auto__,p__34082){
var vec__34083 = p__34082;
var k__4485__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34083,(0),null);
var v__4486__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__34083,(1),null);
return (f__4482__auto__.cljs$core$IFn$_invoke$arity$3 ? f__4482__auto__.cljs$core$IFn$_invoke$arity$3(ret__4484__auto__,k__4485__auto__,v__4486__auto__) : f__4482__auto__.call(null,ret__4484__auto__,k__4485__auto__,v__4486__auto__));
}),init__4483__auto__,this__4481__auto____$1);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__4476__auto__,writer__4477__auto__,opts__4478__auto__){
var self__ = this;
var this__4476__auto____$1 = this;
var pr_pair__4479__auto__ = (function (keyval__4480__auto__){
return cljs.core.pr_sequential_writer(writer__4477__auto__,cljs.core.pr_writer,""," ","",opts__4478__auto__,keyval__4480__auto__);
});
return cljs.core.pr_sequential_writer(writer__4477__auto__,pr_pair__4479__auto__,"#fluree.db.storage.core.UnresolvedNode{",", ","}",opts__4478__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$conn,self__.conn],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$config,self__.config],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$network,self__.network],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$dbid,self__.dbid],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$id,self__.id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leaf,self__.leaf],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$first,self__.first],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$rhs,self__.rhs],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$size,self__.size],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$block,self__.block],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$t,self__.t],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tt_DASH_id,self__.tt_id],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.cst$kw$tempid,self__.tempid],null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__34076){
var self__ = this;
var G__34076__$1 = this;
return (new cljs.core.RecordIter((0),G__34076__$1,14,new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$conn,cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$ = cljs.core.PROTOCOL_SENTINEL);

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_first_flake$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.first;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_rhs$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.rhs;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$empty,self__.id)){
var pc = cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();
cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(pc,fluree.db.index.data_node((0),(0),fluree.db.flake.sorted_set_by(cljs.core.cst$kw$comparator.cljs$core$IFn$_invoke$arity$1(self__.config)),null,self__.config));

return pc;
} else {
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var G__34086 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34087 = (function (___$2){
if(cljs.core.truth_(self__.leaf)){
return fluree.db.storage.core.reify_leaf(self__.conn,self__.config,self__.id,self__.block,self__.t,self__.rhs,(function (){
var G__34088 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34089 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34088,G__34089) : object_cache.call(null,G__34088,G__34089));
}));
} else {
return fluree.db.storage.core.reify_branch(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,(function (){
var G__34090 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.id,self__.tempid], null);
var G__34091 = null;
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34090,G__34091) : object_cache.call(null,G__34090,G__34091));
}));
}
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34086,G__34087) : object_cache.call(null,G__34086,G__34087));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
var history_id = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.id),"-his"].join('');
var object_cache = cljs.core.cst$kw$object_DASH_cache.cljs$core$IFn$_invoke$arity$1(self__.conn);
var error_fn = (function (){
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(history_id,null) : object_cache.call(null,history_id,null));
});
var G__34092 = history_id;
var G__34093 = (function (___$2){
return fluree.db.storage.core.reify_history(self__.conn,history_id,error_fn);
});
return (object_cache.cljs$core$IFn$_invoke$arity$2 ? object_cache.cljs$core$IFn$_invoke$arity$2(G__34092,G__34093) : object_cache.call(null,G__34092,G__34093));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$3 = (function (this$,to_t,idx_novelty){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,false,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$4 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,cljs.core.PersistentHashSet.EMPTY);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_to_t$arity$5 = (function (this$,to_t,idx_novelty,fast_foward_db_QMARK_,remove_preds){
var self__ = this;
var this$__$1 = this;
return fluree.db.storage.core.resolve_to_t(this$__$1,self__.id,self__.tempid,self__.rhs,self__.leftmost_QMARK_,to_t,self__.tt_id,idx_novelty,self__.conn,fast_foward_db_QMARK_,remove_preds);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$3 = (function (node,from_t,to_t){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,null,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.fluree$db$dbproto$IResolve$_resolve_history_range$arity$4 = (function (node,from_t,to_t,idx_novelty){
var self__ = this;
var node__$1 = this;
return fluree.db.storage.core.resolve_history_range(node__$1,from_t,to_t,idx_novelty,self__.leftmost_QMARK_);
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__4459__auto__){
var self__ = this;
var this__4459__auto____$1 = this;
return self__.__meta;
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__4456__auto__){
var self__ = this;
var this__4456__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__4465__auto__){
var self__ = this;
var this__4465__auto____$1 = this;
return (14 + cljs.core.count(self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__4457__auto__){
var self__ = this;
var this__4457__auto____$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = (function (){var fexpr__34094 = (function (coll__4458__auto__){
return (502391120 ^ cljs.core.hash_unordered_coll(coll__4458__auto__));
});
return fexpr__34094(this__4457__auto____$1);
})();
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this34078,other34079){
var self__ = this;
var this34078__$1 = this;
return (((!((other34079 == null)))) && ((((this34078__$1.constructor === other34079.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.conn,other34079.conn)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.config,other34079.config)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.network,other34079.network)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.dbid,other34079.dbid)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.id,other34079.id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.leaf,other34079.leaf)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.first,other34079.first)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.rhs,other34079.rhs)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.size,other34079.size)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.block,other34079.block)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.t,other34079.t)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.tt_id,other34079.tt_id)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.leftmost_QMARK_,other34079.leftmost_QMARK_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.tempid,other34079.tempid)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this34078__$1.__extmap,other34079.__extmap)))))))))))))))))))))))))))))))));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__4471__auto__,k__4472__auto__){
var self__ = this;
var this__4471__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 14, [cljs.core.cst$kw$block,null,cljs.core.cst$kw$dbid,null,cljs.core.cst$kw$config,null,cljs.core.cst$kw$leaf,null,cljs.core.cst$kw$size,null,cljs.core.cst$kw$leftmost_QMARK_,null,cljs.core.cst$kw$id,null,cljs.core.cst$kw$tempid,null,cljs.core.cst$kw$t,null,cljs.core.cst$kw$network,null,cljs.core.cst$kw$first,null,cljs.core.cst$kw$tt_DASH_id,null,cljs.core.cst$kw$rhs,null,cljs.core.cst$kw$conn,null], null), null),k__4472__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__4471__auto____$1),self__.__meta),k__4472__auto__);
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__4472__auto__)),null));
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__4468__auto__,k34077){
var self__ = this;
var this__4468__auto____$1 = this;
var G__34095 = k34077;
var G__34095__$1 = (((G__34095 instanceof cljs.core.Keyword))?G__34095.fqn:null);
switch (G__34095__$1) {
case "conn":
case "config":
case "network":
case "dbid":
case "id":
case "leaf":
case "first":
case "rhs":
case "size":
case "block":
case "t":
case "tt-id":
case "leftmost?":
case "tempid":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k34077);

}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__4469__auto__,k__4470__auto__,G__34076){
var self__ = this;
var this__4469__auto____$1 = this;
var pred__34096 = cljs.core.keyword_identical_QMARK_;
var expr__34097 = k__4470__auto__;
if(cljs.core.truth_((function (){var G__34099 = cljs.core.cst$kw$conn;
var G__34100 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34099,G__34100) : pred__34096.call(null,G__34099,G__34100));
})())){
return (new fluree.db.storage.core.UnresolvedNode(G__34076,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34101 = cljs.core.cst$kw$config;
var G__34102 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34101,G__34102) : pred__34096.call(null,G__34101,G__34102));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,G__34076,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34103 = cljs.core.cst$kw$network;
var G__34104 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34103,G__34104) : pred__34096.call(null,G__34103,G__34104));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,G__34076,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34105 = cljs.core.cst$kw$dbid;
var G__34106 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34105,G__34106) : pred__34096.call(null,G__34105,G__34106));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,G__34076,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34107 = cljs.core.cst$kw$id;
var G__34108 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34107,G__34108) : pred__34096.call(null,G__34107,G__34108));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,G__34076,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34109 = cljs.core.cst$kw$leaf;
var G__34110 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34109,G__34110) : pred__34096.call(null,G__34109,G__34110));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,G__34076,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34111 = cljs.core.cst$kw$first;
var G__34112 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34111,G__34112) : pred__34096.call(null,G__34111,G__34112));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,G__34076,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34113 = cljs.core.cst$kw$rhs;
var G__34114 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34113,G__34114) : pred__34096.call(null,G__34113,G__34114));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,G__34076,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34115 = cljs.core.cst$kw$size;
var G__34116 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34115,G__34116) : pred__34096.call(null,G__34115,G__34116));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,G__34076,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34117 = cljs.core.cst$kw$block;
var G__34118 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34117,G__34118) : pred__34096.call(null,G__34117,G__34118));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,G__34076,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34119 = cljs.core.cst$kw$t;
var G__34120 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34119,G__34120) : pred__34096.call(null,G__34119,G__34120));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,G__34076,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34121 = cljs.core.cst$kw$tt_DASH_id;
var G__34122 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34121,G__34122) : pred__34096.call(null,G__34121,G__34122));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,G__34076,self__.leftmost_QMARK_,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34123 = cljs.core.cst$kw$leftmost_QMARK_;
var G__34124 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34123,G__34124) : pred__34096.call(null,G__34123,G__34124));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,G__34076,self__.tempid,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((function (){var G__34125 = cljs.core.cst$kw$tempid;
var G__34126 = expr__34097;
return (pred__34096.cljs$core$IFn$_invoke$arity$2 ? pred__34096.cljs$core$IFn$_invoke$arity$2(G__34125,G__34126) : pred__34096.call(null,G__34125,G__34126));
})())){
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,G__34076,self__.__meta,self__.__extmap,null));
} else {
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__4470__auto__,G__34076),null));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__4474__auto__){
var self__ = this;
var this__4474__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(cljs.core.cst$kw$conn,self__.conn,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$config,self__.config,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$network,self__.network,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$dbid,self__.dbid,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$id,self__.id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leaf,self__.leaf,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$first,self__.first,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$rhs,self__.rhs,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$size,self__.size,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$block,self__.block,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$t,self__.t,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tt_DASH_id,self__.tt_id,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$leftmost_QMARK_,self__.leftmost_QMARK_,null)),(new cljs.core.MapEntry(cljs.core.cst$kw$tempid,self__.tempid,null))], null),self__.__extmap));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__4460__auto__,G__34076){
var self__ = this;
var this__4460__auto____$1 = this;
return (new fluree.db.storage.core.UnresolvedNode(self__.conn,self__.config,self__.network,self__.dbid,self__.id,self__.leaf,self__.first,self__.rhs,self__.size,self__.block,self__.t,self__.tt_id,self__.leftmost_QMARK_,self__.tempid,G__34076,self__.__extmap,self__.__hash));
}));

(fluree.db.storage.core.UnresolvedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__4466__auto__,entry__4467__auto__){
var self__ = this;
var this__4466__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__4467__auto__)){
return this__4466__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__4467__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__4466__auto____$1,entry__4467__auto__);
}
}));

(fluree.db.storage.core.UnresolvedNode.getBasis = (function (){
return new cljs.core.PersistentVector(null, 14, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$conn,cljs.core.cst$sym$config,cljs.core.cst$sym$network,cljs.core.cst$sym$dbid,cljs.core.cst$sym$id,cljs.core.cst$sym$leaf,cljs.core.cst$sym$first,cljs.core.cst$sym$rhs,cljs.core.cst$sym$size,cljs.core.cst$sym$block,cljs.core.cst$sym$t,cljs.core.cst$sym$tt_DASH_id,cljs.core.cst$sym$leftmost_QMARK_,cljs.core.cst$sym$tempid], null);
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$type = true);

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrSeq = (function (this__4505__auto__){
return (new cljs.core.List(null,"fluree.db.storage.core/UnresolvedNode",null,(1),null));
}));

(fluree.db.storage.core.UnresolvedNode.cljs$lang$ctorPrWriter = (function (this__4505__auto__,writer__4506__auto__){
return cljs.core._write(writer__4506__auto__,"fluree.db.storage.core/UnresolvedNode");
}));

/**
 * Positional factory function for fluree.db.storage.core/UnresolvedNode.
 */
fluree.db.storage.core.__GT_UnresolvedNode = (function fluree$db$storage$core$__GT_UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid){
return (new fluree.db.storage.core.UnresolvedNode(conn,config,network,dbid,id,leaf,first,rhs,size,block,t,tt_id,leftmost_QMARK_,tempid,null,null,null));
});

/**
 * Factory function for fluree.db.storage.core/UnresolvedNode, taking a map of keywords to field values.
 */
fluree.db.storage.core.map__GT_UnresolvedNode = (function fluree$db$storage$core$map__GT_UnresolvedNode(G__34080){
var extmap__4501__auto__ = (function (){var G__34127 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__34080,cljs.core.cst$kw$conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cljs.core.cst$kw$network,cljs.core.cst$kw$dbid,cljs.core.cst$kw$id,cljs.core.cst$kw$leaf,cljs.core.cst$kw$first,cljs.core.cst$kw$rhs,cljs.core.cst$kw$size,cljs.core.cst$kw$block,cljs.core.cst$kw$t,cljs.core.cst$kw$tt_DASH_id,cljs.core.cst$kw$leftmost_QMARK_,cljs.core.cst$kw$tempid], 0));
if(cljs.core.record_QMARK_(G__34080)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__34127);
} else {
return G__34127;
}
})();
return (new fluree.db.storage.core.UnresolvedNode(cljs.core.cst$kw$conn.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$config.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$network.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$dbid.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$leaf.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$first.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$rhs.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$size.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$block.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$t.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$tt_DASH_id.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$leftmost_QMARK_.cljs$core$IFn$_invoke$arity$1(G__34080),cljs.core.cst$kw$tempid.cljs$core$IFn$_invoke$arity$1(G__34080),null,cljs.core.not_empty(extmap__4501__auto__),null));
});

/**
 * Turns each index root node into an unresolved node.
 */
fluree.db.storage.core.reify_index_root = (function fluree$db$storage$core$reify_index_root(conn,index_configs,network,dbid,index,index_data,block,t){
var cfg = (function (){var or__4212__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(index_configs,index);
if(cljs.core.truth_(or__4212__auto__)){
return or__4212__auto__;
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(["Internal error reifying db root index: ",cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([index], 0))].join(''),new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$status,(500),cljs.core.cst$kw$error,cljs.core.cst$kw$db_SLASH_unexpected_DASH_error], null));
}
})();
return fluree.db.storage.core.map__GT_UnresolvedNode(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(index_data,cljs.core.cst$kw$conn,conn,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$config,cfg,cljs.core.cst$kw$network,network,cljs.core.cst$kw$dbid,dbid,cljs.core.cst$kw$block,block,cljs.core.cst$kw$t,t,cljs.core.cst$kw$leftmost_QMARK_,true], 0)));
});
/**
 * Constructs db from blank-db, and ensure index roots have proper config as unresolved nodes.
 */
fluree.db.storage.core.reify_db_root = (function fluree$db$storage$core$reify_db_root(conn,blank_db,root_data){
var map__34130 = blank_db;
var map__34130__$1 = cljs.core.__destructure_map(map__34130);
var network = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34130__$1,cljs.core.cst$kw$network);
var dbid = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34130__$1,cljs.core.cst$kw$dbid);
var index_configs = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34130__$1,cljs.core.cst$kw$index_DASH_configs);
var map__34131 = root_data;
var map__34131__$1 = cljs.core.__destructure_map(map__34131);
var block = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$block);
var t = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$t);
var ecount = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$ecount);
var stats = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__34131__$1,cljs.core.cst$kw$stats);
var db_STAR_ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(blank_db,cljs.core.cst$kw$block,block,cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([cljs.core.cst$kw$t,t,cljs.core.cst$kw$ecount,ecount,cljs.core.cst$kw$stats,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(stats,cljs.core.cst$kw$indexed,block)], 0));
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (db,idx){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(db,idx,fluree.db.storage.core.reify_index_root(conn,index_configs,network,dbid,idx,cljs.core.get.cljs$core$IFn$_invoke$arity$2(root_data,idx),block,t));
}),db_STAR_,new cljs.core.PersistentVector(null, 4, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot,cljs.core.cst$kw$psot,cljs.core.cst$kw$post,cljs.core.cst$kw$opst], null));
});
/**
 * Returns a all data for a db index root of a given block.
 */
fluree.db.storage.core.read_garbage = (function fluree$db$storage$core$read_garbage(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34153){
var state_val_34154 = (state_34153[(1)]);
if((state_val_34154 === (7))){
var state_34153__$1 = state_34153;
var statearr_34155_34175 = state_34153__$1;
(statearr_34155_34175[(2)] = null);

(statearr_34155_34175[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (1))){
var state_34153__$1 = state_34153;
var statearr_34156_34176 = state_34153__$1;
(statearr_34156_34176[(2)] = null);

(statearr_34156_34176[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (4))){
var inst_34132 = (state_34153[(2)]);
var state_34153__$1 = state_34153;
var statearr_34157_34177 = state_34153__$1;
(statearr_34157_34177[(2)] = inst_34132);

(statearr_34157_34177[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (6))){
var inst_34139 = (state_34153[(7)]);
var inst_34141 = fluree.db.storage.core.serde(conn);
var state_34153__$1 = (function (){var statearr_34158 = state_34153;
(statearr_34158[(8)] = inst_34141);

return statearr_34158;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34153__$1,(9),inst_34139);
} else {
if((state_val_34154 === (3))){
var inst_34151 = (state_34153[(2)]);
var state_34153__$1 = state_34153;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34153__$1,inst_34151);
} else {
if((state_val_34154 === (2))){
var inst_34139 = (state_34153[(7)]);
var _ = (function (){var statearr_34160 = state_34153;
(statearr_34160[(4)] = cljs.core.cons((5),(state_34153[(4)])));

return statearr_34160;
})();
var inst_34138 = fluree.db.storage.core.ledger_garbage_key(network,dbid,block);
var inst_34139__$1 = fluree.db.storage.core.storage_read(conn,inst_34138);
var state_34153__$1 = (function (){var statearr_34161 = state_34153;
(statearr_34161[(7)] = inst_34139__$1);

return statearr_34161;
})();
if(cljs.core.truth_(inst_34139__$1)){
var statearr_34162_34178 = state_34153__$1;
(statearr_34162_34178[(1)] = (6));

} else {
var statearr_34163_34179 = state_34153__$1;
(statearr_34163_34179[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (9))){
var inst_34141 = (state_34153[(8)]);
var inst_34143 = (state_34153[(2)]);
var inst_34144 = fluree.db.util.async.throw_err(inst_34143);
var inst_34145 = fluree.db.serde.protocol._deserialize_garbage(inst_34141,inst_34144);
var state_34153__$1 = state_34153;
var statearr_34164_34180 = state_34153__$1;
(statearr_34164_34180[(2)] = inst_34145);

(statearr_34164_34180[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (5))){
var _ = (function (){var statearr_34165 = state_34153;
(statearr_34165[(4)] = cljs.core.rest((state_34153[(4)])));

return statearr_34165;
})();
var state_34153__$1 = state_34153;
var ex34159 = (state_34153__$1[(2)]);
var statearr_34166_34181 = state_34153__$1;
(statearr_34166_34181[(5)] = ex34159);


if((ex34159 instanceof Error)){
var statearr_34167_34182 = state_34153__$1;
(statearr_34167_34182[(1)] = (4));

(statearr_34167_34182[(5)] = null);

} else {
throw ex34159;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34154 === (8))){
var inst_34148 = (state_34153[(2)]);
var _ = (function (){var statearr_34168 = state_34153;
(statearr_34168[(4)] = cljs.core.rest((state_34153[(4)])));

return statearr_34168;
})();
var state_34153__$1 = state_34153;
var statearr_34169_34183 = state_34153__$1;
(statearr_34169_34183[(2)] = inst_34148);

(statearr_34169_34183[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0 = (function (){
var statearr_34170 = [null,null,null,null,null,null,null,null,null];
(statearr_34170[(0)] = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__);

(statearr_34170[(1)] = (1));

return statearr_34170;
});
var fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1 = (function (state_34153){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34153);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34171){var ex__16398__auto__ = e34171;
var statearr_34172_34184 = state_34153;
(statearr_34172_34184[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34153[(4)]))){
var statearr_34173_34185 = state_34153;
(statearr_34173_34185[(1)] = cljs.core.first((state_34153[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34186 = state_34153;
state_34153 = G__34186;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__ = function(state_34153){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1.call(this,state_34153);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_garbage_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_garbage_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34174 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34174[(6)] = c__16469__auto__);

return statearr_34174;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns all data for a db index root of a given block.
 */
fluree.db.storage.core.read_db_root = (function fluree$db$storage$core$read_db_root(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34208){
var state_val_34209 = (state_34208[(1)]);
if((state_val_34209 === (7))){
var inst_34197 = (state_34208[(7)]);
var inst_34199 = fluree.db.storage.core.serde(conn);
var inst_34200 = fluree.db.serde.protocol._deserialize_db_root(inst_34199,inst_34197);
var state_34208__$1 = state_34208;
var statearr_34210_34229 = state_34208__$1;
(statearr_34210_34229[(2)] = inst_34200);

(statearr_34210_34229[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (1))){
var state_34208__$1 = state_34208;
var statearr_34211_34230 = state_34208__$1;
(statearr_34211_34230[(2)] = null);

(statearr_34211_34230[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (4))){
var inst_34187 = (state_34208[(2)]);
var state_34208__$1 = state_34208;
var statearr_34212_34231 = state_34208__$1;
(statearr_34212_34231[(2)] = inst_34187);

(statearr_34212_34231[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (6))){
var inst_34197 = (state_34208[(7)]);
var inst_34196 = (state_34208[(2)]);
var inst_34197__$1 = fluree.db.util.async.throw_err(inst_34196);
var state_34208__$1 = (function (){var statearr_34213 = state_34208;
(statearr_34213[(7)] = inst_34197__$1);

return statearr_34213;
})();
if(cljs.core.truth_(inst_34197__$1)){
var statearr_34214_34232 = state_34208__$1;
(statearr_34214_34232[(1)] = (7));

} else {
var statearr_34215_34233 = state_34208__$1;
(statearr_34215_34233[(1)] = (8));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (3))){
var inst_34206 = (state_34208[(2)]);
var state_34208__$1 = state_34208;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34208__$1,inst_34206);
} else {
if((state_val_34209 === (2))){
var _ = (function (){var statearr_34217 = state_34208;
(statearr_34217[(4)] = cljs.core.cons((5),(state_34208[(4)])));

return statearr_34217;
})();
var inst_34193 = fluree.db.storage.core.ledger_root_key(network,dbid,block);
var inst_34194 = fluree.db.storage.core.storage_read(conn,inst_34193);
var state_34208__$1 = state_34208;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34208__$1,(6),inst_34194);
} else {
if((state_val_34209 === (9))){
var inst_34203 = (state_34208[(2)]);
var _ = (function (){var statearr_34218 = state_34208;
(statearr_34218[(4)] = cljs.core.rest((state_34208[(4)])));

return statearr_34218;
})();
var state_34208__$1 = state_34208;
var statearr_34219_34234 = state_34208__$1;
(statearr_34219_34234[(2)] = inst_34203);

(statearr_34219_34234[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (5))){
var _ = (function (){var statearr_34220 = state_34208;
(statearr_34220[(4)] = cljs.core.rest((state_34208[(4)])));

return statearr_34220;
})();
var state_34208__$1 = state_34208;
var ex34216 = (state_34208__$1[(2)]);
var statearr_34221_34235 = state_34208__$1;
(statearr_34221_34235[(5)] = ex34216);


if((ex34216 instanceof Error)){
var statearr_34222_34236 = state_34208__$1;
(statearr_34222_34236[(1)] = (4));

(statearr_34222_34236[(5)] = null);

} else {
throw ex34216;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34209 === (8))){
var state_34208__$1 = state_34208;
var statearr_34223_34237 = state_34208__$1;
(statearr_34223_34237[(2)] = null);

(statearr_34223_34237[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0 = (function (){
var statearr_34224 = [null,null,null,null,null,null,null,null];
(statearr_34224[(0)] = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__);

(statearr_34224[(1)] = (1));

return statearr_34224;
});
var fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1 = (function (state_34208){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34208);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34225){var ex__16398__auto__ = e34225;
var statearr_34226_34238 = state_34208;
(statearr_34226_34238[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34208[(4)]))){
var statearr_34227_34239 = state_34208;
(statearr_34227_34239[(1)] = cljs.core.first((state_34208[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34240 = state_34208;
state_34208 = G__34240;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__ = function(state_34208){
switch(arguments.length){
case 0:
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1.call(this,state_34208);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____0;
fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$read_db_root_$_state_machine__16395__auto____1;
return fluree$db$storage$core$read_db_root_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34228 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34228[(6)] = c__16469__auto__);

return statearr_34228;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Reifies db at specified index point. If unable to read db-root at index, throws.
 */
fluree.db.storage.core.reify_db = (function fluree$db$storage$core$reify_db(conn,network,dbid,blank_db,index){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34276){
var state_val_34277 = (state_34276[(1)]);
if((state_val_34277 === (7))){
var inst_34250 = ["Database ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(network),"/",cljs.core.str.cljs$core$IFn$_invoke$arity$1(dbid)," could not be loaded at index point: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(index),"."].join('');
var inst_34251 = [cljs.core.cst$kw$status,cljs.core.cst$kw$error];
var inst_34252 = [(400),cljs.core.cst$kw$db_SLASH_unavailable];
var inst_34253 = cljs.core.PersistentHashMap.fromArrays(inst_34251,inst_34252);
var inst_34254 = cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2(inst_34250,inst_34253);
var inst_34255 = (function(){throw inst_34254})();
var state_34276__$1 = state_34276;
var statearr_34278_34300 = state_34276__$1;
(statearr_34278_34300[(2)] = inst_34255);

(statearr_34278_34300[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (1))){
var state_34276__$1 = state_34276;
var statearr_34279_34301 = state_34276__$1;
(statearr_34279_34301[(2)] = null);

(statearr_34279_34301[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (4))){
var inst_34241 = (state_34276[(2)]);
var state_34276__$1 = state_34276;
var statearr_34280_34302 = state_34276__$1;
(statearr_34280_34302[(2)] = inst_34241);

(statearr_34280_34302[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (6))){
var state_34276__$1 = state_34276;
var statearr_34281_34303 = state_34276__$1;
(statearr_34281_34303[(2)] = null);

(statearr_34281_34303[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (3))){
var inst_34274 = (state_34276[(2)]);
var state_34276__$1 = state_34276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34276__$1,inst_34274);
} else {
if((state_val_34277 === (2))){
var inst_34247 = (state_34276[(7)]);
var _ = (function (){var statearr_34282 = state_34276;
(statearr_34282[(4)] = cljs.core.cons((5),(state_34276[(4)])));

return statearr_34282;
})();
var inst_34247__$1 = fluree.db.storage.core.read_db_root(conn,network,dbid,index);
var state_34276__$1 = (function (){var statearr_34283 = state_34276;
(statearr_34283[(7)] = inst_34247__$1);

return statearr_34283;
})();
if(cljs.core.truth_(inst_34247__$1)){
var statearr_34284_34304 = state_34276__$1;
(statearr_34284_34304[(1)] = (6));

} else {
var statearr_34285_34305 = state_34276__$1;
(statearr_34285_34305[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (11))){
var inst_34266 = (state_34276[(8)]);
var inst_34269 = (state_34276[(2)]);
var inst_34270 = fluree.db.util.async.throw_err(inst_34269);
var inst_34271 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34266,cljs.core.cst$kw$settings,inst_34270);
var _ = (function (){var statearr_34287 = state_34276;
(statearr_34287[(4)] = cljs.core.rest((state_34276[(4)])));

return statearr_34287;
})();
var state_34276__$1 = state_34276;
var statearr_34288_34306 = state_34276__$1;
(statearr_34288_34306[(2)] = inst_34271);

(statearr_34288_34306[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (9))){
var inst_34261 = (state_34276[(9)]);
var inst_34259 = (state_34276[(2)]);
var inst_34260 = fluree.db.util.async.throw_err(inst_34259);
var inst_34261__$1 = fluree.db.storage.core.reify_db_root(conn,blank_db,inst_34260);
var inst_34262 = fluree.db.query.schema.schema_map(inst_34261__$1);
var state_34276__$1 = (function (){var statearr_34289 = state_34276;
(statearr_34289[(9)] = inst_34261__$1);

return statearr_34289;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34276__$1,(10),inst_34262);
} else {
if((state_val_34277 === (5))){
var _ = (function (){var statearr_34290 = state_34276;
(statearr_34290[(4)] = cljs.core.rest((state_34276[(4)])));

return statearr_34290;
})();
var state_34276__$1 = state_34276;
var ex34286 = (state_34276__$1[(2)]);
var statearr_34291_34307 = state_34276__$1;
(statearr_34291_34307[(5)] = ex34286);


if((ex34286 instanceof Error)){
var statearr_34292_34308 = state_34276__$1;
(statearr_34292_34308[(1)] = (4));

(statearr_34292_34308[(5)] = null);

} else {
throw ex34286;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34277 === (10))){
var inst_34261 = (state_34276[(9)]);
var inst_34266 = (state_34276[(8)]);
var inst_34264 = (state_34276[(2)]);
var inst_34265 = fluree.db.util.async.throw_err(inst_34264);
var inst_34266__$1 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_34261,cljs.core.cst$kw$schema,inst_34265);
var inst_34267 = fluree.db.query.schema.setting_map(inst_34266__$1);
var state_34276__$1 = (function (){var statearr_34293 = state_34276;
(statearr_34293[(8)] = inst_34266__$1);

return statearr_34293;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34276__$1,(11),inst_34267);
} else {
if((state_val_34277 === (8))){
var inst_34247 = (state_34276[(7)]);
var inst_34257 = (state_34276[(2)]);
var state_34276__$1 = (function (){var statearr_34294 = state_34276;
(statearr_34294[(10)] = inst_34257);

return statearr_34294;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34276__$1,(9),inst_34247);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0 = (function (){
var statearr_34295 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_34295[(0)] = fluree$db$storage$core$reify_db_$_state_machine__16395__auto__);

(statearr_34295[(1)] = (1));

return statearr_34295;
});
var fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1 = (function (state_34276){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34276);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34296){var ex__16398__auto__ = e34296;
var statearr_34297_34309 = state_34276;
(statearr_34297_34309[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34276[(4)]))){
var statearr_34298_34310 = state_34276;
(statearr_34298_34310[(1)] = cljs.core.first((state_34276[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34311 = state_34276;
state_34276 = G__34311;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__ = function(state_34276){
switch(arguments.length){
case 0:
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1.call(this,state_34276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$reify_db_$_state_machine__16395__auto____0;
fluree$db$storage$core$reify_db_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$reify_db_$_state_machine__16395__auto____1;
return fluree$db$storage$core$reify_db_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34299 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34299[(6)] = c__16469__auto__);

return statearr_34299;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
/**
 * Returns a channel that will contains blocks in specified range.
 */
fluree.db.storage.core.block_range = (function fluree$db$storage$core$block_range(var_args){
var G__34313 = arguments.length;
switch (G__34313) {
case 4:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$4 = (function (conn,network,dbid,start){
return fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,start,null);
}));

(fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5 = (function (conn,network,dbid,start,end){
fluree.db.util.log.trace.cljs$core$IFn$_invoke$arity$variadic(cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(["Block-range request: ",network,dbid,start,end], 0));

var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34366){
var state_val_34367 = (state_34366[(1)]);
if((state_val_34367 === (7))){
var inst_34323 = ["Assert failed: ","Block range should be in ascending order, from earliest (smallest) block to most recent (largest) block.","\n","(>= end start)"].join('');
var inst_34324 = (new Error(inst_34323));
var inst_34325 = (function(){throw inst_34324})();
var state_34366__$1 = state_34366;
var statearr_34368_34408 = state_34366__$1;
(statearr_34368_34408[(2)] = inst_34325);

(statearr_34368_34408[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (20))){
var inst_34357 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
var statearr_34369_34409 = state_34366__$1;
(statearr_34369_34409[(2)] = inst_34357);

(statearr_34369_34409[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (1))){
var state_34366__$1 = state_34366;
var statearr_34370_34410 = state_34366__$1;
(statearr_34370_34410[(2)] = null);

(statearr_34370_34410[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (4))){
var inst_34314 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
var statearr_34371_34411 = state_34366__$1;
(statearr_34371_34411[(2)] = inst_34314);

(statearr_34371_34411[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (15))){
var inst_34332 = (state_34366[(7)]);
var state_34366__$1 = state_34366;
var statearr_34372_34412 = state_34366__$1;
(statearr_34372_34412[(2)] = inst_34332);

(statearr_34372_34412[(1)] = (17));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (21))){
var inst_34336 = (state_34366[(8)]);
var inst_34332 = (state_34366[(7)]);
var inst_34331 = (state_34366[(9)]);
var inst_34350 = (inst_34331 + (1));
var inst_34351 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34332,inst_34336);
var inst_34331__$1 = inst_34350;
var inst_34332__$1 = inst_34351;
var state_34366__$1 = (function (){var statearr_34373 = state_34366;
(statearr_34373[(7)] = inst_34332__$1);

(statearr_34373[(9)] = inst_34331__$1);

return statearr_34373;
})();
var statearr_34374_34413 = state_34366__$1;
(statearr_34374_34413[(2)] = null);

(statearr_34374_34413[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (13))){
var inst_34336 = (state_34366[(8)]);
var inst_34340 = (inst_34336 instanceof Error);
var state_34366__$1 = state_34366;
var statearr_34375_34414 = state_34366__$1;
(statearr_34375_34414[(2)] = inst_34340);

(statearr_34375_34414[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (22))){
var state_34366__$1 = state_34366;
var statearr_34376_34415 = state_34366__$1;
(statearr_34376_34415[(2)] = null);

(statearr_34376_34415[(1)] = (23));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (6))){
var state_34366__$1 = state_34366;
var statearr_34377_34416 = state_34366__$1;
(statearr_34377_34416[(2)] = null);

(statearr_34377_34416[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (17))){
var inst_34359 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
var statearr_34378_34417 = state_34366__$1;
(statearr_34378_34417[(2)] = inst_34359);

(statearr_34378_34417[(1)] = (10));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (3))){
var inst_34364 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34366__$1,inst_34364);
} else {
if((state_val_34367 === (12))){
var inst_34337 = (state_34366[(10)]);
var state_34366__$1 = state_34366;
var statearr_34379_34418 = state_34366__$1;
(statearr_34379_34418[(2)] = inst_34337);

(statearr_34379_34418[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (2))){
var _ = (function (){var statearr_34380 = state_34366;
(statearr_34380[(4)] = cljs.core.cons((5),(state_34366[(4)])));

return statearr_34380;
})();
var inst_34320 = (end >= start);
var state_34366__$1 = state_34366;
if(cljs.core.truth_(inst_34320)){
var statearr_34381_34419 = state_34366__$1;
(statearr_34381_34419[(1)] = (6));

} else {
var statearr_34382_34420 = state_34366__$1;
(statearr_34382_34420[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (23))){
var inst_34355 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
var statearr_34383_34421 = state_34366__$1;
(statearr_34383_34421[(2)] = inst_34355);

(statearr_34383_34421[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (19))){
var state_34366__$1 = state_34366;
var statearr_34384_34422 = state_34366__$1;
(statearr_34384_34422[(1)] = (21));



return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (11))){
var inst_34337 = (state_34366[(10)]);
var inst_34336 = (state_34366[(8)]);
var inst_34336__$1 = (state_34366[(2)]);
var inst_34337__$1 = (inst_34336__$1 == null);
var state_34366__$1 = (function (){var statearr_34387 = state_34366;
(statearr_34387[(10)] = inst_34337__$1);

(statearr_34387[(8)] = inst_34336__$1);

return statearr_34387;
})();
if(cljs.core.truth_(inst_34337__$1)){
var statearr_34388_34423 = state_34366__$1;
(statearr_34388_34423[(1)] = (12));

} else {
var statearr_34389_34424 = state_34366__$1;
(statearr_34389_34424[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (9))){
var inst_34331 = (state_34366[(9)]);
var inst_34334 = fluree.db.storage.core.read_block(conn,network,dbid,inst_34331);
var state_34366__$1 = state_34366;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34366__$1,(11),inst_34334);
} else {
if((state_val_34367 === (5))){
var _ = (function (){var statearr_34390 = state_34366;
(statearr_34390[(4)] = cljs.core.rest((state_34366[(4)])));

return statearr_34390;
})();
var state_34366__$1 = state_34366;
var ex34386 = (state_34366__$1[(2)]);
var statearr_34391_34425 = state_34366__$1;
(statearr_34391_34425[(5)] = ex34386);


if((ex34386 instanceof Error)){
var statearr_34392_34426 = state_34366__$1;
(statearr_34392_34426[(1)] = (4));

(statearr_34392_34426[(5)] = null);

} else {
throw ex34386;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (14))){
var inst_34342 = (state_34366[(2)]);
var state_34366__$1 = state_34366;
if(cljs.core.truth_(inst_34342)){
var statearr_34393_34427 = state_34366__$1;
(statearr_34393_34427[(1)] = (15));

} else {
var statearr_34394_34428 = state_34366__$1;
(statearr_34394_34428[(1)] = (16));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (16))){
var inst_34331 = (state_34366[(9)]);
var inst_34345 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_34331,end);
var state_34366__$1 = state_34366;
if(inst_34345){
var statearr_34395_34429 = state_34366__$1;
(statearr_34395_34429[(1)] = (18));

} else {
var statearr_34396_34430 = state_34366__$1;
(statearr_34396_34430[(1)] = (19));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (10))){
var inst_34361 = (state_34366[(2)]);
var _ = (function (){var statearr_34397 = state_34366;
(statearr_34397[(4)] = cljs.core.rest((state_34366[(4)])));

return statearr_34397;
})();
var state_34366__$1 = state_34366;
var statearr_34398_34431 = state_34366__$1;
(statearr_34398_34431[(2)] = inst_34361);

(statearr_34398_34431[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (18))){
var inst_34336 = (state_34366[(8)]);
var inst_34332 = (state_34366[(7)]);
var inst_34347 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(inst_34332,inst_34336);
var state_34366__$1 = state_34366;
var statearr_34399_34432 = state_34366__$1;
(statearr_34399_34432[(2)] = inst_34347);

(statearr_34399_34432[(1)] = (20));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34367 === (8))){
var inst_34327 = (state_34366[(2)]);
var inst_34328 = cljs.core.cst$kw$parallelism.cljs$core$IFn$_invoke$arity$1(conn);
var inst_34329 = start;
var inst_34330 = cljs.core.PersistentVector.EMPTY;
var inst_34331 = inst_34329;
var inst_34332 = inst_34330;
var state_34366__$1 = (function (){var statearr_34400 = state_34366;
(statearr_34400[(7)] = inst_34332);

(statearr_34400[(11)] = inst_34328);

(statearr_34400[(12)] = inst_34327);

(statearr_34400[(9)] = inst_34331);

return statearr_34400;
})();
var statearr_34401_34433 = state_34366__$1;
(statearr_34401_34433[(2)] = null);

(statearr_34401_34433[(1)] = (9));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$state_machine__16395__auto__ = null;
var fluree$db$storage$core$state_machine__16395__auto____0 = (function (){
var statearr_34402 = [null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_34402[(0)] = fluree$db$storage$core$state_machine__16395__auto__);

(statearr_34402[(1)] = (1));

return statearr_34402;
});
var fluree$db$storage$core$state_machine__16395__auto____1 = (function (state_34366){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34366);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34403){var ex__16398__auto__ = e34403;
var statearr_34404_34434 = state_34366;
(statearr_34404_34434[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34366[(4)]))){
var statearr_34405_34435 = state_34366;
(statearr_34405_34435[(1)] = cljs.core.first((state_34366[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34436 = state_34366;
state_34366 = G__34436;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$state_machine__16395__auto__ = function(state_34366){
switch(arguments.length){
case 0:
return fluree$db$storage$core$state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$state_machine__16395__auto____1.call(this,state_34366);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$state_machine__16395__auto____0;
fluree$db$storage$core$state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$state_machine__16395__auto____1;
return fluree$db$storage$core$state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34406 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34406[(6)] = c__16469__auto__);

return statearr_34406;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
}));

(fluree.db.storage.core.block_range.cljs$lang$maxFixedArity = 5);

/**
 * Reads a single block from storage
 */
fluree.db.storage.core.block = (function fluree$db$storage$core$block(conn,network,dbid,block){
var c__16469__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__16470__auto__ = (function (){var switch__16394__auto__ = (function (state_34452){
var state_val_34453 = (state_34452[(1)]);
if((state_val_34453 === (1))){
var state_34452__$1 = state_34452;
var statearr_34454_34468 = state_34452__$1;
(statearr_34454_34468[(2)] = null);

(statearr_34454_34468[(1)] = (2));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34453 === (2))){
var _ = (function (){var statearr_34455 = state_34452;
(statearr_34455[(4)] = cljs.core.cons((5),(state_34452[(4)])));

return statearr_34455;
})();
var inst_34443 = fluree.db.storage.core.block_range.cljs$core$IFn$_invoke$arity$5(conn,network,dbid,block,block);
var state_34452__$1 = state_34452;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_34452__$1,(6),inst_34443);
} else {
if((state_val_34453 === (3))){
var inst_34450 = (state_34452[(2)]);
var state_34452__$1 = state_34452;
return cljs.core.async.impl.ioc_helpers.return_chan(state_34452__$1,inst_34450);
} else {
if((state_val_34453 === (4))){
var inst_34437 = (state_34452[(2)]);
var state_34452__$1 = state_34452;
var statearr_34457_34469 = state_34452__$1;
(statearr_34457_34469[(2)] = inst_34437);

(statearr_34457_34469[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
if((state_val_34453 === (5))){
var _ = (function (){var statearr_34458 = state_34452;
(statearr_34458[(4)] = cljs.core.rest((state_34452[(4)])));

return statearr_34458;
})();
var state_34452__$1 = state_34452;
var ex34456 = (state_34452__$1[(2)]);
var statearr_34459_34470 = state_34452__$1;
(statearr_34459_34470[(5)] = ex34456);


if((ex34456 instanceof Error)){
var statearr_34460_34471 = state_34452__$1;
(statearr_34460_34471[(1)] = (4));

(statearr_34460_34471[(5)] = null);

} else {
throw ex34456;

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_34453 === (6))){
var inst_34445 = (state_34452[(2)]);
var inst_34446 = fluree.db.util.async.throw_err(inst_34445);
var inst_34447 = cljs.core.first(inst_34446);
var _ = (function (){var statearr_34461 = state_34452;
(statearr_34461[(4)] = cljs.core.rest((state_34452[(4)])));

return statearr_34461;
})();
var state_34452__$1 = state_34452;
var statearr_34462_34472 = state_34452__$1;
(statearr_34462_34472[(2)] = inst_34447);

(statearr_34462_34472[(1)] = (3));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
});
return (function() {
var fluree$db$storage$core$block_$_state_machine__16395__auto__ = null;
var fluree$db$storage$core$block_$_state_machine__16395__auto____0 = (function (){
var statearr_34463 = [null,null,null,null,null,null,null];
(statearr_34463[(0)] = fluree$db$storage$core$block_$_state_machine__16395__auto__);

(statearr_34463[(1)] = (1));

return statearr_34463;
});
var fluree$db$storage$core$block_$_state_machine__16395__auto____1 = (function (state_34452){
while(true){
var ret_value__16396__auto__ = (function (){try{while(true){
var result__16397__auto__ = switch__16394__auto__(state_34452);
if(cljs.core.keyword_identical_QMARK_(result__16397__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__16397__auto__;
}
break;
}
}catch (e34464){var ex__16398__auto__ = e34464;
var statearr_34465_34473 = state_34452;
(statearr_34465_34473[(2)] = ex__16398__auto__);


if(cljs.core.seq((state_34452[(4)]))){
var statearr_34466_34474 = state_34452;
(statearr_34466_34474[(1)] = cljs.core.first((state_34452[(4)])));

} else {
throw ex__16398__auto__;
}

return cljs.core.cst$kw$recur;
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__16396__auto__,cljs.core.cst$kw$recur)){
var G__34475 = state_34452;
state_34452 = G__34475;
continue;
} else {
return ret_value__16396__auto__;
}
break;
}
});
fluree$db$storage$core$block_$_state_machine__16395__auto__ = function(state_34452){
switch(arguments.length){
case 0:
return fluree$db$storage$core$block_$_state_machine__16395__auto____0.call(this);
case 1:
return fluree$db$storage$core$block_$_state_machine__16395__auto____1.call(this,state_34452);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
fluree$db$storage$core$block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$0 = fluree$db$storage$core$block_$_state_machine__16395__auto____0;
fluree$db$storage$core$block_$_state_machine__16395__auto__.cljs$core$IFn$_invoke$arity$1 = fluree$db$storage$core$block_$_state_machine__16395__auto____1;
return fluree$db$storage$core$block_$_state_machine__16395__auto__;
})()
})();
var state__16471__auto__ = (function (){var statearr_34467 = (f__16470__auto__.cljs$core$IFn$_invoke$arity$0 ? f__16470__auto__.cljs$core$IFn$_invoke$arity$0() : f__16470__auto__.call(null));
(statearr_34467[(6)] = c__16469__auto__);

return statearr_34467;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__16471__auto__);
}));

return c__16469__auto__;
});
