// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('jx.reporter.karma');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.test');
goog.require('clojure.data');
goog.require('fipp.clojure');
goog.require('clojure.string');
goog.require('goog.object');
jx.reporter.karma.karma = cljs.core.volatile_BANG_(null);
jx.reporter.karma.karma_QMARK_ = (function jx$reporter$karma$karma_QMARK_(){
return (!((cljs.core.deref(jx.reporter.karma.karma) == null)));
});
jx.reporter.karma.karma_info_BANG_ = (function jx$reporter$karma$karma_info_BANG_(m){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).info(cljs.core.clj__GT_js(m));
} else {
return null;
}
});
jx.reporter.karma.karma_result_BANG_ = (function jx$reporter$karma$karma_result_BANG_(m){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).result(cljs.core.clj__GT_js(m));
} else {
return null;
}
});
jx.reporter.karma.coverage_result = (function jx$reporter$karma$coverage_result(){
return ({"coverage": goog.object.get(window,"__coverage__")});
});
jx.reporter.karma.karma_complete_BANG_ = (function jx$reporter$karma$karma_complete_BANG_(){
if(jx.reporter.karma.karma_QMARK_()){
return cljs.core.deref(jx.reporter.karma.karma).complete(jx.reporter.karma.coverage_result());
} else {
return null;
}
});
jx.reporter.karma.now = (function jx$reporter$karma$now(){
return (new Date()).getTime();
});
jx.reporter.karma.indent = (function jx$reporter$karma$indent(n,s){
var indentation = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.str,"",cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(n," "));
return clojure.string.replace(s,/\n/,["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(indentation)].join(''));
});
jx.reporter.karma.remove_last_new_line = (function jx$reporter$karma$remove_last_new_line(s){
return cljs.core.subs.cljs$core$IFn$_invoke$arity$3(s,(0),(cljs.core.count(s) - (1)));
});
jx.reporter.karma.format_fn = (function jx$reporter$karma$format_fn(indentation,p__8559){
var vec__8560 = p__8559;
var seq__8561 = cljs.core.seq(vec__8560);
var first__8562 = cljs.core.first(seq__8561);
var seq__8561__$1 = cljs.core.next(seq__8561);
var c = first__8562;
var q = seq__8561__$1;
var e = ["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__8558_SHARP_){
var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__8567_8571 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__8568_8572 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__8569_8573 = true;
var _STAR_print_fn_STAR__temp_val__8570_8574 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__8569_8573);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__8570_8574);

try{fipp.clojure.pprint.cljs$core$IFn$_invoke$arity$1(p1__8558_SHARP_);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__8568_8572);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__8567_8571);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
}),q)))].join('');
return ["(",cljs.core.str.cljs$core$IFn$_invoke$arity$1(c),jx.reporter.karma.indent((indentation + (2)),jx.reporter.karma.remove_last_new_line(e)),")"].join('');
});
jx.reporter.karma.format_diff = (function jx$reporter$karma$format_diff(indentation,assert,p__8575){
var vec__8576 = p__8575;
var seq__8577 = cljs.core.seq(vec__8576);
var first__8578 = cljs.core.first(seq__8577);
var seq__8577__$1 = cljs.core.next(seq__8577);
var c = first__8578;
var first__8578__$1 = cljs.core.first(seq__8577__$1);
var seq__8577__$2 = cljs.core.next(seq__8577__$1);
var a = first__8578__$1;
var first__8578__$2 = cljs.core.first(seq__8577__$2);
var seq__8577__$3 = cljs.core.next(seq__8577__$2);
var b = first__8578__$2;
var q = seq__8577__$3;
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(c,cljs.core.cst$sym$_EQ_)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(assert),(3))) && ((q == null)))))){
var format = (function (sign,value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(sign)," ",(cljs.core.truth_(value)?jx.reporter.karma.indent((indentation + (2)),jx.reporter.karma.remove_last_new_line((function (){var sb__4749__auto__ = (new goog.string.StringBuffer());
var _STAR_print_newline_STAR__orig_val__8586_8590 = cljs.core._STAR_print_newline_STAR_;
var _STAR_print_fn_STAR__orig_val__8587_8591 = cljs.core._STAR_print_fn_STAR_;
var _STAR_print_newline_STAR__temp_val__8588_8592 = true;
var _STAR_print_fn_STAR__temp_val__8589_8593 = (function (x__4750__auto__){
return sb__4749__auto__.append(x__4750__auto__);
});
(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__temp_val__8588_8592);

(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__temp_val__8589_8593);

try{fipp.clojure.pprint.cljs$core$IFn$_invoke$arity$1(value);
}finally {(cljs.core._STAR_print_fn_STAR_ = _STAR_print_fn_STAR__orig_val__8587_8591);

(cljs.core._STAR_print_newline_STAR_ = _STAR_print_newline_STAR__orig_val__8586_8590);
}
return cljs.core.str.cljs$core$IFn$_invoke$arity$1(sb__4749__auto__);
})())):"\n")].join('');
});
var vec__8579 = clojure.data.diff(a,b);
var removed = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8579,(0),null);
var added = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__8579,(1),null);
return [format("-",removed),format(["\n",cljs.core.str.cljs$core$IFn$_invoke$arity$1(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.repeat.cljs$core$IFn$_invoke$arity$2(indentation," "))),"+"].join(''),added)].join('');
} else {
return null;
}
});
jx.reporter.karma.format_log = (function jx$reporter$karma$format_log(p__8594){
var map__8595 = p__8594;
var map__8595__$1 = cljs.core.__destructure_map(map__8595);
var result = map__8595__$1;
var expected = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8595__$1,cljs.core.cst$kw$expected);
var actual = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8595__$1,cljs.core.cst$kw$actual);
var message = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8595__$1,cljs.core.cst$kw$message);
var testing_contexts_str = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__8595__$1,cljs.core.cst$kw$testing_DASH_contexts_DASH_str);
var indentation = (("expected: ").length);
return ["FAIL in   ",cljs.test.testing_vars_str(result),"\n",((clojure.string.blank_QMARK_(testing_contexts_str))?null:["\"",cljs.core.str.cljs$core$IFn$_invoke$arity$1(testing_contexts_str),"\"\n"].join('')),((((cljs.core.seq_QMARK_(expected)) && (cljs.core.seq_QMARK_(actual))))?["expected: ",jx.reporter.karma.format_fn(indentation,expected),"\n","  actual: ",jx.reporter.karma.format_fn(indentation,cljs.core.second(actual)),"\n",(function (){var temp__5753__auto__ = jx.reporter.karma.format_diff(indentation,expected,cljs.core.second(actual));
if(cljs.core.truth_(temp__5753__auto__)){
var diff = temp__5753__auto__;
return ["    diff: ",diff,"\n"].join('');
} else {
return null;
}
})()].join(''):[cljs.core.str.cljs$core$IFn$_invoke$arity$1(expected)," failed with ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(actual),"\n"].join('')),(cljs.core.truth_(message)?[" message: ",jx.reporter.karma.indent(indentation,message),"\n"].join(''):null)].join('');
});
jx.reporter.karma.test_var_result = cljs.core.volatile_BANG_(cljs.core.PersistentVector.EMPTY);
jx.reporter.karma.test_var_time_start = cljs.core.volatile_BANG_(jx.reporter.karma.now());
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,cljs.core.cst$kw$karma,(function (_){
return null;
}));
cljs.core.derive.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$cljs$test_SLASH_default);
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$summary], null),(function (_){
return null;
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$begin_DASH_test_DASH_ns], null),(function (m){
return null;
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$begin_DASH_test_DASH_var], null),(function (_){
cljs.core.vreset_BANG_(jx.reporter.karma.test_var_time_start,jx.reporter.karma.now());

return cljs.core.vreset_BANG_(jx.reporter.karma.test_var_result,cljs.core.PersistentVector.EMPTY);
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$end_DASH_test_DASH_var], null),(function (m){
var var_meta = cljs.core.meta(cljs.core.cst$kw$var.cljs$core$IFn$_invoke$arity$1(m));
var result = new cljs.core.PersistentArrayMap(null, 6, ["suite",new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$ns.cljs$core$IFn$_invoke$arity$1(var_meta)], null),"description",cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(var_meta),"success",(cljs.core.count(cljs.core.deref(jx.reporter.karma.test_var_result)) === (0)),"skipped",null,"time",(jx.reporter.karma.now() - cljs.core.deref(jx.reporter.karma.test_var_time_start)),"log",cljs.core.map.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.format_log,cljs.core.deref(jx.reporter.karma.test_var_result))], null);
return jx.reporter.karma.karma_result_BANG_(result);
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$fail], null),(function (m){
cljs.test.inc_report_counter_BANG_(cljs.core.cst$kw$fail);

return jx.reporter.karma.test_var_result.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.test_var_result.cljs$core$IDeref$_deref$arity$1(null),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,cljs.core.cst$kw$testing_DASH_contexts_DASH_str,cljs.test.testing_contexts_str())));
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$error], null),(function (m){
cljs.test.inc_report_counter_BANG_(cljs.core.cst$kw$error);

return jx.reporter.karma.test_var_result.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(jx.reporter.karma.test_var_result.cljs$core$IDeref$_deref$arity$1(null),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,cljs.core.cst$kw$testing_DASH_contexts_DASH_str,cljs.test.testing_contexts_str())));
}));
cljs.test.report.cljs$core$IMultiFn$_add_method$arity$3(null,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$jx$reporter$karma_SLASH_karma,cljs.core.cst$kw$end_DASH_run_DASH_tests], null),(function (_){
return jx.reporter.karma.karma_complete_BANG_();
}));
jx.reporter.karma.start = (function jx$reporter$karma$start(tc,total_count){
cljs.core.vreset_BANG_(jx.reporter.karma.karma,tc);

return jx.reporter.karma.karma_info_BANG_(new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$total,total_count], null));
});
