// Compiled by ClojureScript 1.10.879 {:static-fns true, :optimize-constants true, :target :nodejs, :nodejs-rt false, :optimizations :advanced}
goog.provide('tailrecursion.priority_map');
goog.require('cljs.core');
goog.require('cljs.core.constants');
goog.require('cljs.core');
goog.require('cljs.reader');

/**
* @constructor
 * @implements {cljs.core.IReversible}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.IFn}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.IEmptyableCollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISorted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IStack}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
tailrecursion.priority_map.PersistentPriorityMap = (function (priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
this.priority__GT_set_of_items = priority__GT_set_of_items;
this.item__GT_priority = item__GT_priority;
this.meta = meta;
this.keyfn = keyfn;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2565220111;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,item,not_found){
var self__ = this;
var coll__$1 = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var self__ = this;
var coll__$1 = this;
var pr_pair = (function (keyval){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,""," ","",opts,keyval);
});
return cljs.core.pr_sequential_writer(writer,pr_pair,"#tailrecursion.priority-map {",", ","}",opts,coll__$1);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.meta;
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.count(self__.item__GT_priority);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_peek$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
return null;
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item = cljs.core.first(cljs.core.val(f));
if(cljs.core.truth_(self__.keyfn)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,cljs.core.key(f)], null);
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IStack$_pop$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((cljs.core.count(self__.item__GT_priority) === (0))){
throw (new Error("Can't pop empty priority map"));
} else {
var f = cljs.core.first(self__.priority__GT_set_of_items);
var item_set = cljs.core.val(f);
var item = cljs.core.first(item_set);
var priority_key = cljs.core.key(f);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43582(s__43583){
return (new cljs.core.LazySeq(null,(function (){
var s__43583__$1 = s__43583;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43583__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43588 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43588,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43588,(1),null);
var iterys__4607__auto__ = ((function (s__43583__$1,vec__43588,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43582_$_iter__43584(s__43585){
return (new cljs.core.LazySeq(null,((function (s__43583__$1,vec__43588,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43585__$1 = s__43585;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43585__$1);
if(temp__5753__auto____$1){
var s__43585__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43585__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43585__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43587 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43586 = (0);
while(true){
if((i__43586 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43586);
cljs.core.chunk_append(b__43587,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43640 = (i__43586 + (1));
i__43586 = G__43640;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43587),tailrecursion$priority_map$iter__43582_$_iter__43584(cljs.core.chunk_rest(s__43585__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43587),null);
}
} else {
var item = cljs.core.first(s__43585__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43582_$_iter__43584(cljs.core.rest(s__43585__$2)));
}
} else {
return null;
}
break;
}
});})(s__43583__$1,vec__43588,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43583__$1,vec__43588,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43582(cljs.core.rest(s__43583__$1)));
} else {
var G__43641 = cljs.core.rest(s__43583__$1);
s__43583__$1 = G__43641;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43591(s__43592){
return (new cljs.core.LazySeq(null,(function (){
var s__43592__$1 = s__43592;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43592__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43597 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43597,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43597,(1),null);
var iterys__4607__auto__ = ((function (s__43592__$1,vec__43597,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function tailrecursion$priority_map$iter__43591_$_iter__43593(s__43594){
return (new cljs.core.LazySeq(null,((function (s__43592__$1,vec__43597,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1){
return (function (){
var s__43594__$1 = s__43594;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43594__$1);
if(temp__5753__auto____$1){
var s__43594__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43594__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43594__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43596 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43595 = (0);
while(true){
if((i__43595 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43595);
cljs.core.chunk_append(b__43596,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43642 = (i__43595 + (1));
i__43595 = G__43642;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43596),tailrecursion$priority_map$iter__43591_$_iter__43593(cljs.core.chunk_rest(s__43594__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43596),null);
}
} else {
var item = cljs.core.first(s__43594__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43591_$_iter__43593(cljs.core.rest(s__43594__$2)));
}
} else {
return null;
}
break;
}
});})(s__43592__$1,vec__43597,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
,null,null));
});})(s__43592__$1,vec__43597,priority,item_set,xs__6308__auto__,temp__5753__auto__,coll__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43591(cljs.core.rest(s__43592__$1)));
} else {
var G__43643 = cljs.core.rest(s__43592__$1);
s__43592__$1 = G__43643;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(cljs.core.rseq(self__.priority__GT_set_of_items));
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4319__auto__ = self__.__hash;
if((!((h__4319__auto__ == null)))){
return h__4319__auto__;
} else {
var h__4319__auto____$1 = cljs.core.hash_unordered_coll(this$__$1);
(self__.__hash = h__4319__auto____$1);

return h__4319__auto____$1;
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
return cljs.core._equiv(self__.item__GT_priority,other);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.with_meta(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,self__.meta);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
var priority = (function (){var G__43600 = item;
var G__43601 = cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found;
return (self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$2(G__43600,G__43601) : self__.item__GT_priority.call(null,G__43600,G__43601));
})();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(priority,cljs.core.cst$kw$tailrecursion$priority_DASH_map_SLASH_not_DASH_found)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var item_set = (self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1 ? self__.priority__GT_set_of_items.cljs$core$IFn$_invoke$arity$1(priority_key) : self__.priority__GT_set_of_items.call(null,priority_key));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,priority_key),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(item_set,item)),cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.item__GT_priority,item),self__.meta,self__.keyfn,null));
}
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this$,item,priority){
var self__ = this;
var this$__$1 = this;
var temp__5751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,null);
if(cljs.core.truth_(temp__5751__auto__)){
var current_priority = temp__5751__auto__;
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current_priority,priority)){
return this$__$1;
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
var current_priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(current_priority) : self__.keyfn.call(null,current_priority));
var item_set = cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.count(item_set),(1))){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
} else {
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(self__.priority__GT_set_of_items,current_priority_key,cljs.core.disj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$2(self__.priority__GT_set_of_items,current_priority_key),item),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)], 0)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}
} else {
var priority_key = (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(priority) : self__.keyfn.call(null,priority));
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,priority_key,cljs.core.PersistentHashSet.EMPTY),item)),cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.item__GT_priority,item,priority),self__.meta,self__.keyfn,null));
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this$,item){
var self__ = this;
var this$__$1 = this;
return cljs.core.contains_QMARK_(self__.item__GT_priority,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43602(s__43603){
return (new cljs.core.LazySeq(null,(function (){
var s__43603__$1 = s__43603;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43603__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43608 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43608,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43608,(1),null);
var iterys__4607__auto__ = ((function (s__43603__$1,vec__43608,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43602_$_iter__43604(s__43605){
return (new cljs.core.LazySeq(null,((function (s__43603__$1,vec__43608,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43605__$1 = s__43605;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43605__$1);
if(temp__5753__auto____$1){
var s__43605__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43605__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43605__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43607 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43606 = (0);
while(true){
if((i__43606 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43606);
cljs.core.chunk_append(b__43607,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43644 = (i__43606 + (1));
i__43606 = G__43644;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43607),tailrecursion$priority_map$iter__43602_$_iter__43604(cljs.core.chunk_rest(s__43605__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43607),null);
}
} else {
var item = cljs.core.first(s__43605__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43602_$_iter__43604(cljs.core.rest(s__43605__$2)));
}
} else {
return null;
}
break;
}
});})(s__43603__$1,vec__43608,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43603__$1,vec__43608,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43602(cljs.core.rest(s__43603__$1)));
} else {
var G__43645 = cljs.core.rest(s__43603__$1);
s__43603__$1 = G__43645;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43611(s__43612){
return (new cljs.core.LazySeq(null,(function (){
var s__43612__$1 = s__43612;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43612__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43617 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43617,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43617,(1),null);
var iterys__4607__auto__ = ((function (s__43612__$1,vec__43617,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function tailrecursion$priority_map$iter__43611_$_iter__43613(s__43614){
return (new cljs.core.LazySeq(null,((function (s__43612__$1,vec__43617,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1){
return (function (){
var s__43614__$1 = s__43614;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43614__$1);
if(temp__5753__auto____$1){
var s__43614__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43614__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43614__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43616 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43615 = (0);
while(true){
if((i__43615 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43615);
cljs.core.chunk_append(b__43616,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43646 = (i__43615 + (1));
i__43615 = G__43646;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43616),tailrecursion$priority_map$iter__43611_$_iter__43613(cljs.core.chunk_rest(s__43614__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43616),null);
}
} else {
var item = cljs.core.first(s__43614__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43611_$_iter__43613(cljs.core.rest(s__43614__$2)));
}
} else {
return null;
}
break;
}
});})(s__43612__$1,vec__43617,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
,null,null));
});})(s__43612__$1,vec__43617,priority,item_set,xs__6308__auto__,temp__5753__auto__,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43611(cljs.core.rest(s__43612__$1)));
} else {
var G__43647 = cljs.core.rest(s__43612__$1);
s__43612__$1 = G__43647;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(self__.priority__GT_set_of_items);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,meta__$1){
var self__ = this;
var this$__$1 = this;
return (new tailrecursion.priority_map.PersistentPriorityMap(self__.priority__GT_set_of_items,self__.item__GT_priority,meta__$1,self__.keyfn,self__.__hash));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return this$__$1.cljs$core$IAssociative$_assoc$arity$3(null,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this$__$1,entry);
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.call = (function() {
var G__43648 = null;
var G__43648__2 = (function (self__,item){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
});
var G__43648__3 = (function (self__,item,not_found){
var self__ = this;
var self____$1 = this;
var this$ = self____$1;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
});
G__43648 = function(self__,item,not_found){
switch(arguments.length){
case 2:
return G__43648__2.call(this,self__,item);
case 3:
return G__43648__3.call(this,self__,item,not_found);
}
throw(new Error('Invalid arity: ' + (arguments.length - 1)));
};
G__43648.cljs$core$IFn$_invoke$arity$2 = G__43648__2;
G__43648.cljs$core$IFn$_invoke$arity$3 = G__43648__3;
return G__43648;
})()
);

(tailrecursion.priority_map.PersistentPriorityMap.prototype.apply = (function (self__,args43581){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args43581)));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (item){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$2(null,item);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (item,not_found){
var self__ = this;
var this$ = this;
return this$.cljs$core$ILookup$_lookup$arity$3(null,item,not_found);
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (this$,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var fexpr__43620 = (cljs.core.truth_(ascending_QMARK_)?cljs.core.seq:cljs.core.rseq);
return (fexpr__43620.cljs$core$IFn$_invoke$arity$1 ? fexpr__43620.cljs$core$IFn$_invoke$arity$1(this$__$1) : fexpr__43620.call(null,this$__$1));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (this$,k,ascending_QMARK_){
var self__ = this;
var this$__$1 = this;
var sets = (cljs.core.truth_(ascending_QMARK_)?cljs.core.subseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._GT__EQ_,k):cljs.core.rsubseq.cljs$core$IFn$_invoke$arity$3(self__.priority__GT_set_of_items,cljs.core._LT__EQ_,k));
if(cljs.core.truth_(self__.keyfn)){
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43621(s__43622){
return (new cljs.core.LazySeq(null,(function (){
var s__43622__$1 = s__43622;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43622__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43627 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43627,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43627,(1),null);
var iterys__4607__auto__ = ((function (s__43622__$1,vec__43627,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43621_$_iter__43623(s__43624){
return (new cljs.core.LazySeq(null,((function (s__43622__$1,vec__43627,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43624__$1 = s__43624;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43624__$1);
if(temp__5753__auto____$1){
var s__43624__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43624__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43624__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43626 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43625 = (0);
while(true){
if((i__43625 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43625);
cljs.core.chunk_append(b__43626,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null));

var G__43649 = (i__43625 + (1));
i__43625 = G__43649;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43626),tailrecursion$priority_map$iter__43621_$_iter__43623(cljs.core.chunk_rest(s__43624__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43626),null);
}
} else {
var item = cljs.core.first(s__43624__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,(self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1 ? self__.item__GT_priority.cljs$core$IFn$_invoke$arity$1(item) : self__.item__GT_priority.call(null,item))], null),tailrecursion$priority_map$iter__43621_$_iter__43623(cljs.core.rest(s__43624__$2)));
}
} else {
return null;
}
break;
}
});})(s__43622__$1,vec__43627,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43622__$1,vec__43627,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43621(cljs.core.rest(s__43622__$1)));
} else {
var G__43650 = cljs.core.rest(s__43622__$1);
s__43622__$1 = G__43650;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
} else {
return cljs.core.seq((function (){var iter__4611__auto__ = (function tailrecursion$priority_map$iter__43630(s__43631){
return (new cljs.core.LazySeq(null,(function (){
var s__43631__$1 = s__43631;
while(true){
var temp__5753__auto__ = cljs.core.seq(s__43631__$1);
if(temp__5753__auto__){
var xs__6308__auto__ = temp__5753__auto__;
var vec__43636 = cljs.core.first(xs__6308__auto__);
var priority = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43636,(0),null);
var item_set = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__43636,(1),null);
var iterys__4607__auto__ = ((function (s__43631__$1,vec__43636,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function tailrecursion$priority_map$iter__43630_$_iter__43632(s__43633){
return (new cljs.core.LazySeq(null,((function (s__43631__$1,vec__43636,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1){
return (function (){
var s__43633__$1 = s__43633;
while(true){
var temp__5753__auto____$1 = cljs.core.seq(s__43633__$1);
if(temp__5753__auto____$1){
var s__43633__$2 = temp__5753__auto____$1;
if(cljs.core.chunked_seq_QMARK_(s__43633__$2)){
var c__4609__auto__ = cljs.core.chunk_first(s__43633__$2);
var size__4610__auto__ = cljs.core.count(c__4609__auto__);
var b__43635 = cljs.core.chunk_buffer(size__4610__auto__);
if((function (){var i__43634 = (0);
while(true){
if((i__43634 < size__4610__auto__)){
var item = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4609__auto__,i__43634);
cljs.core.chunk_append(b__43635,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null));

var G__43651 = (i__43634 + (1));
i__43634 = G__43651;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__43635),tailrecursion$priority_map$iter__43630_$_iter__43632(cljs.core.chunk_rest(s__43633__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__43635),null);
}
} else {
var item = cljs.core.first(s__43633__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [item,priority], null),tailrecursion$priority_map$iter__43630_$_iter__43632(cljs.core.rest(s__43633__$2)));
}
} else {
return null;
}
break;
}
});})(s__43631__$1,vec__43636,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
,null,null));
});})(s__43631__$1,vec__43636,priority,item_set,xs__6308__auto__,temp__5753__auto__,sets,this$__$1))
;
var fs__4608__auto__ = cljs.core.seq(iterys__4607__auto__(item_set));
if(fs__4608__auto__){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(fs__4608__auto__,tailrecursion$priority_map$iter__43630(cljs.core.rest(s__43631__$1)));
} else {
var G__43652 = cljs.core.rest(s__43631__$1);
s__43631__$1 = G__43652;
continue;
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__4611__auto__(sets);
})());
}
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (this$,entry){
var self__ = this;
var this$__$1 = this;
var G__43639 = cljs.core.val(entry);
return (self__.keyfn.cljs$core$IFn$_invoke$arity$1 ? self__.keyfn.cljs$core$IFn$_invoke$arity$1(G__43639) : self__.keyfn.call(null,G__43639));
}));

(tailrecursion.priority_map.PersistentPriorityMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.compare;
}));

(tailrecursion.priority_map.PersistentPriorityMap.getBasis = (function (){
return new cljs.core.PersistentVector(null, 5, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$sym$priority_DASH__GT_set_DASH_of_DASH_items,cljs.core.cst$sym$item_DASH__GT_priority,cljs.core.cst$sym$meta,cljs.core.cst$sym$keyfn,cljs.core.with_meta(cljs.core.cst$sym$__hash,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$mutable,true], null))], null);
}));

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$type = true);

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorStr = "tailrecursion.priority-map/PersistentPriorityMap");

(tailrecursion.priority_map.PersistentPriorityMap.cljs$lang$ctorPrWriter = (function (this__4450__auto__,writer__4451__auto__,opt__4452__auto__){
return cljs.core._write(writer__4451__auto__,"tailrecursion.priority-map/PersistentPriorityMap");
}));

/**
 * Positional factory function for tailrecursion.priority-map/PersistentPriorityMap.
 */
tailrecursion.priority_map.__GT_PersistentPriorityMap = (function tailrecursion$priority_map$__GT_PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash){
return (new tailrecursion.priority_map.PersistentPriorityMap(priority__GT_set_of_items,item__GT_priority,meta,keyfn,__hash));
});

(tailrecursion.priority_map.PersistentPriorityMap.EMPTY = (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null)));
tailrecursion.priority_map.pm_empty_by = (function tailrecursion$priority_map$pm_empty_by(comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,cljs.core.identity,null));
});
tailrecursion.priority_map.pm_empty_keyfn = (function tailrecursion$priority_map$pm_empty_keyfn(var_args){
var G__43654 = arguments.length;
switch (G__43654) {
case 1:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1 = (function (keyfn){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map(),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2 = (function (keyfn,comparator){
return (new tailrecursion.priority_map.PersistentPriorityMap(cljs.core.sorted_map_by(comparator),cljs.core.PersistentArrayMap.EMPTY,cljs.core.PersistentArrayMap.EMPTY,keyfn,null));
}));

(tailrecursion.priority_map.pm_empty_keyfn.cljs$lang$maxFixedArity = 2);

tailrecursion.priority_map.read_priority_map = (function tailrecursion$priority_map$read_priority_map(elems){
if(cljs.core.map_QMARK_(elems)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(tailrecursion.priority_map.PersistentPriorityMap.EMPTY,elems);
} else {
throw Error("Priority map literal expects a map for its elements.");
}
});
cljs.reader.register_tag_parser_BANG_("tailrecursion.priority-map",tailrecursion.priority_map.read_priority_map);
/**
 * keyval => key val
 *   Returns a new priority map with supplied mappings.
 */
tailrecursion.priority_map.priority_map = (function tailrecursion$priority_map$priority_map(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43657 = arguments.length;
var i__4819__auto___43658 = (0);
while(true){
if((i__4819__auto___43658 < len__4818__auto___43657)){
args__4824__auto__.push((arguments[i__4819__auto___43658]));

var G__43659 = (i__4819__auto___43658 + (1));
i__4819__auto___43658 = G__43659;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((0) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((0)),(0),null)):null);
return tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic(argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map.cljs$core$IFn$_invoke$arity$variadic = (function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.PersistentPriorityMap.EMPTY;
while(true){
if(in$){
var G__43660 = cljs.core.nnext(in$);
var G__43661 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43660;
out = G__43661;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(tailrecursion.priority_map.priority_map.cljs$lang$applyTo = (function (seq43656){
var self__4806__auto__ = this;
return self__4806__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq43656));
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied comparator.
 */
tailrecursion.priority_map.priority_map_by = (function tailrecursion$priority_map$priority_map_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43664 = arguments.length;
var i__4819__auto___43665 = (0);
while(true){
if((i__4819__auto___43665 < len__4818__auto___43664)){
args__4824__auto__.push((arguments[i__4819__auto___43665]));

var G__43666 = (i__4819__auto___43665 + (1));
i__4819__auto___43665 = G__43666;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_by.cljs$core$IFn$_invoke$arity$variadic = (function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_by(comparator);
while(true){
if(in$){
var G__43667 = cljs.core.nnext(in$);
var G__43668 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43667;
out = G__43668;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_by.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_by.cljs$lang$applyTo = (function (seq43662){
var G__43663 = cljs.core.first(seq43662);
var seq43662__$1 = cljs.core.next(seq43662);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43663,seq43662__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn.
 */
tailrecursion.priority_map.priority_map_keyfn = (function tailrecursion$priority_map$priority_map_keyfn(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43671 = arguments.length;
var i__4819__auto___43672 = (0);
while(true){
if((i__4819__auto___43672 < len__4818__auto___43671)){
args__4824__auto__.push((arguments[i__4819__auto___43672]));

var G__43673 = (i__4819__auto___43672 + (1));
i__4819__auto___43672 = G__43673;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((1) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((1)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$1(keyfn);
while(true){
if(in$){
var G__43674 = cljs.core.nnext(in$);
var G__43675 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43674;
out = G__43675;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn.cljs$lang$applyTo = (function (seq43669){
var G__43670 = cljs.core.first(seq43669);
var seq43669__$1 = cljs.core.next(seq43669);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43670,seq43669__$1);
}));

/**
 * keyval => key val
 *   Returns a new priority map with supplied
 *   mappings, using the supplied keyfn and comparator.
 */
tailrecursion.priority_map.priority_map_keyfn_by = (function tailrecursion$priority_map$priority_map_keyfn_by(var_args){
var args__4824__auto__ = [];
var len__4818__auto___43679 = arguments.length;
var i__4819__auto___43680 = (0);
while(true){
if((i__4819__auto___43680 < len__4818__auto___43679)){
args__4824__auto__.push((arguments[i__4819__auto___43680]));

var G__43681 = (i__4819__auto___43680 + (1));
i__4819__auto___43680 = G__43681;
continue;
} else {
}
break;
}

var argseq__4825__auto__ = ((((2) < args__4824__auto__.length))?(new cljs.core.IndexedSeq(args__4824__auto__.slice((2)),(0),null)):null);
return tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__4825__auto__);
});

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$core$IFn$_invoke$arity$variadic = (function (keyfn,comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = tailrecursion.priority_map.pm_empty_keyfn.cljs$core$IFn$_invoke$arity$2(keyfn,comparator);
while(true){
if(in$){
var G__43682 = cljs.core.nnext(in$);
var G__43683 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__43682;
out = G__43683;
continue;
} else {
return out;
}
break;
}
}));

(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$maxFixedArity = (2));

/** @this {Function} */
(tailrecursion.priority_map.priority_map_keyfn_by.cljs$lang$applyTo = (function (seq43676){
var G__43677 = cljs.core.first(seq43676);
var seq43676__$1 = cljs.core.next(seq43676);
var G__43678 = cljs.core.first(seq43676__$1);
var seq43676__$2 = cljs.core.next(seq43676__$1);
var self__4805__auto__ = this;
return self__4805__auto__.cljs$core$IFn$_invoke$arity$variadic(G__43677,G__43678,seq43676__$2);
}));

